/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.data.task;

import com.wavemaker.common.Resource;
import com.wavemaker.common.util.CastUtils;
import com.wavemaker.common.util.ObjectAccess;
import com.wavemaker.common.util.ObjectUtils;
import com.wavemaker.runtime.data.DataServiceLoggers;
import com.wavemaker.runtime.data.DataServiceMetaData;
import com.wavemaker.runtime.data.DataServiceRuntimeException;
import com.wavemaker.runtime.data.Task;
import com.wavemaker.runtime.data.task.BaseTask;
import com.wavemaker.runtime.data.util.DataServiceUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.engine.NamedQueryDefinition;
import org.hibernate.engine.NamedSQLQueryDefinition;
import org.hibernate.type.Type;

public class NamedQueryTask
extends BaseTask
implements Task {
    private Log logger = DataServiceLoggers.taskLogger;

    public Object run(Session session, String dbName, Object ... input) {
        DataServiceMetaData meta = NamedQueryTask.getMetaData(dbName);
        String queryName = (String)input[0];
        Object[] bindParamValues = new Object[input.length - 1];
        System.arraycopy(input, 1, bindParamValues, 0, bindParamValues.length);
        Query query = session.getNamedQuery(queryName);
        String queryString = query.getQueryString();
        this.handleBindParams(query, queryName, bindParamValues, meta);
        Object rtn = null;
        if (DataServiceUtils.isDML(queryString)) {
            ArrayList<Integer> l = new ArrayList<Integer>(1);
            l.add(query.executeUpdate());
            rtn = l;
        } else {
            boolean supportsReturnType;
            rtn = query.list();
            NamedQueryDefinition def = meta.getQueryDefinition(queryName);
            boolean bl = supportsReturnType = !(def instanceof NamedSQLQueryDefinition);
            if (supportsReturnType && DataServiceUtils.requiresResultWrapper(queryString) && !DataServiceUtils.isDynamicInstantiationQuery(queryString)) {
                rtn = this.marshalIntoCustomType(queryName, meta, query, rtn);
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("rtn for query \"" + queryName + "\": " + rtn));
        }
        return rtn;
    }

    public String getName() {
        return "Built-in Named Query Task";
    }

    private void handleBindParams(Query query, String queryName, Object[] paramValues, DataServiceMetaData meta) {
        NamedQueryDefinition def = meta.getQueryDefinition(queryName);
        Map m = CastUtils.cast((Map)def.getParameterTypes());
        String[] paramNames = new String[m.size()];
        Object[] paramTypes = new String[m.size()];
        int i = 0;
        for (Map.Entry e : m.entrySet()) {
            paramNames[i] = (String)e.getKey();
            paramTypes[i] = (String)e.getValue();
            ++i;
        }
        if (paramTypes.length == 0) {
            if (paramValues.length > 0) {
                this.logExtraParam(queryName, paramValues);
            }
        } else {
            if (paramValues.length == 0) {
                throw new DataServiceRuntimeException(Resource.QUERY_REQUIRES_PARAMS, queryName, ObjectUtils.toString((Object[])paramTypes));
            }
            for (int j = 0; j < paramValues.length; ++j) {
                String name = paramNames[j];
                Object value = paramValues[j];
                if (value != null && Collection.class.isAssignableFrom(value.getClass())) {
                    query.setParameterList(name, (Collection)value);
                    continue;
                }
                query.setParameter(name, value);
            }
        }
    }

    private void logExtraParam(String queryName, Object[] bindParams) {
        if (this.logger.isWarnEnabled()) {
            String val = ObjectUtils.toString((Object[])bindParams);
            this.logger.warn((Object)Resource.QUERY_NO_PARMS.getMessage(new Object[]{queryName, val}));
            if (bindParams.length == 1 && bindParams[0] == null && this.logger.isDebugEnabled()) {
                this.logger.debug((Object)(queryName + " invoked with input (Object)null " + "instead of (Object[])null?"));
            }
        }
    }

    private Object marshalIntoCustomType(String queryName, DataServiceMetaData meta, Query query, Object rtn) {
        Type[] types = query.getReturnTypes();
        String[] returnAliases = query.getReturnAliases();
        if (returnAliases == null) {
            returnAliases = new String[]{};
        }
        List<String> propertyNames = DataServiceUtils.getColumnNames(types.length, Arrays.asList(returnAliases));
        List rows = (List)rtn;
        ArrayList<Object> newRtn = new ArrayList<Object>(rows.size());
        ObjectAccess oa = this.getObjectAccess();
        for (Object o : rows) {
            Object bean = this.instantiateOutputType(meta.getDataPackage(), queryName);
            newRtn.add(bean);
            if (o instanceof Object[]) {
                Object[] row = (Object[])o;
                if (row.length != propertyNames.size()) {
                    throw new AssertionError((Object)"Number of columns doesn't match");
                }
                int i = 0;
                for (Object col : row) {
                    oa.setProperty(bean, propertyNames.get(i++), col);
                }
                continue;
            }
            if (propertyNames.size() != 1) {
                throw new AssertionError((Object)"Expected single column");
            }
            oa.setProperty(bean, propertyNames.get(0), o);
        }
        return newRtn;
    }

    private Object instantiateOutputType(String dataPackage, String queryName) {
        try {
            return this.getObjectAccess().newInstance(DataServiceUtils.getOutputType(dataPackage, queryName));
        }
        catch (RuntimeException ex) {
            try {
                return this.getObjectAccess().newInstance(DataServiceUtils.getOldOutputType(dataPackage, queryName));
            }
            catch (RuntimeException ex2) {
                throw ex;
            }
        }
    }
}

