/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.data.task;

import com.wavemaker.common.util.ImmutableEntryMap;
import com.wavemaker.common.util.ObjectAccess;
import com.wavemaker.common.util.ObjectGraphTraversal;
import com.wavemaker.common.util.ObjectUtils;
import com.wavemaker.runtime.data.DataServiceLoggers;
import com.wavemaker.runtime.data.DataServiceMetaData;
import com.wavemaker.runtime.data.QueryOptions;
import com.wavemaker.runtime.data.Task;
import com.wavemaker.runtime.data.task.AbstractReadTask;
import com.wavemaker.runtime.data.task.DefaultRollback;
import com.wavemaker.runtime.data.util.DataServiceUtils;
import com.wavemaker.runtime.service.PagingOptions;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Example;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;

public class SearchTask
extends AbstractReadTask
implements Task,
DefaultRollback {
    private static final QueryOptions DEFAULT_QUERY_OPTIONS = new QueryOptions();

    public Object run(Session session, String dbName, Object ... input) {
        if (input == null || input.length == 0) {
            throw new IllegalArgumentException("Need search instance or class");
        }
        QueryOptions options = this.getQueryOptions(input);
        Criteria criteria = this.getCritieria(session, input[0], options, dbName);
        this.applyPaging((PagingOptions)options, criteria);
        return criteria.list();
    }

    protected boolean addOrder() {
        return true;
    }

    protected QueryOptions getQueryOptions(Object[] input) {
        QueryOptions rtn = DEFAULT_QUERY_OPTIONS;
        if (input.length > 1) {
            if (input[1] == null) {
                return new QueryOptions();
            }
            if (input[1] instanceof PagingOptions) {
                if (input[1] instanceof QueryOptions) {
                    rtn = (QueryOptions)input[1];
                } else {
                    PagingOptions po = (PagingOptions)input[1];
                    rtn = new QueryOptions(po);
                }
            } else {
                throw new IllegalArgumentException("Second input argument must be a " + PagingOptions.class.getName() + " or " + QueryOptions.class.getName() + " instance");
            }
        }
        return rtn;
    }

    protected Criteria getCritieria(Session session, Object rootSearchObject, QueryOptions options, String dbName) {
        DataServiceMetaData metaData = SearchTask.getMetaData(dbName);
        Criteria rootCriteria = null;
        ImmutableEntryMap criterias = new ImmutableEntryMap();
        if (rootSearchObject instanceof Class) {
            rootCriteria = this.initCriteriasMap((Map<String, Criteria>)criterias, (Class)rootSearchObject, session);
        } else {
            rootCriteria = this.initCriteriasMap((Map<String, Criteria>)criterias, rootSearchObject.getClass(), session);
            SearchTask.addExample(rootSearchObject, rootCriteria, options);
            this.handleIdInSearch(rootSearchObject, rootCriteria, options, metaData);
            ObjectGraphTraversal.ObjectVisitor ov = new ObjectGraphTraversal.ObjectVisitor((Map)criterias, options, metaData){
                final /* synthetic */ Map val$criterias;
                final /* synthetic */ QueryOptions val$options;
                final /* synthetic */ DataServiceMetaData val$metaData;
                {
                    this.val$criterias = map;
                    this.val$options = queryOptions;
                    this.val$metaData = dataServiceMetaData;
                }

                public void cycle(Object o, ObjectGraphTraversal.Context ctx) {
                }

                public void visit(Object queryInstance, ObjectGraphTraversal.Context ctx) {
                    String propertyName = (String)ctx.getProperties().get(0);
                    if (DataServiceLoggers.taskLogger.isDebugEnabled()) {
                        DataServiceLoggers.taskLogger.debug((Object)("Adding criteria on property " + propertyName));
                    }
                    Criteria parentCriteria = (Criteria)ctx.getValues().get(1);
                    if (DataServiceLoggers.taskLogger.isDebugEnabled()) {
                        DataServiceLoggers.taskLogger.debug((Object)("Parent criteria is " + parentCriteria));
                    }
                    Criteria c = parentCriteria.createCriteria(propertyName);
                    String k = ObjectUtils.toString((Collection)ctx.getProperties(), (String)".");
                    this.val$criterias.put(k, c);
                    ctx.getValues().set(0, c);
                    SearchTask.addExample(queryInstance, c, this.val$options);
                    SearchTask.this.handleIdInSearch(queryInstance, c, this.val$options, this.val$metaData);
                }
            };
            ObjectGraphTraversal tr = DataServiceUtils.getRelatedTraversal(ov, this.getObjectAccess(), metaData, false);
            tr.traverse(rootSearchObject, (Object)rootCriteria);
        }
        if (this.addOrder()) {
            this.applyOrderBy(options, (Map<String, Criteria>)criterias);
        }
        for (String s : options.getSqlRestrictions()) {
            rootCriteria.add(Restrictions.sqlRestriction((String)s));
        }
        return rootCriteria;
    }

    public String getName() {
        return "Built-in Query By Example Task";
    }

    private void handleIdInSearch(Object o, Criteria c, QueryOptions options, DataServiceMetaData metaData) {
        String idPropName = metaData.getIdPropertyName(o.getClass());
        ObjectAccess oa = this.getObjectAccess();
        Object value = oa.getProperty(o, idPropName);
        if (value == null && options.getExcludeNone()) {
            return;
        }
        if (metaData.isCompositeProperty(o.getClass(), idPropName)) {
            if (value != null) {
                List propNames = oa.getPropertyNames(value.getClass());
                for (String p : propNames) {
                    String compPropName = idPropName + "." + p;
                    Object pv = this.getObjectAccess().getProperty(value, p);
                    SearchTask.addRestriction(c, compPropName, pv, options);
                }
            }
        } else {
            SearchTask.addRestriction(c, idPropName, value, options);
        }
    }

    private static void addRestriction(Criteria c, String propName, Object value, QueryOptions options) {
        if (value == null && options.getExcludeNone()) {
            return;
        }
        if (String.class.isAssignableFrom(value.getClass())) {
            MatchMode matchMode = options.getTypedMatchMode();
            if (options.getIgnoreCase()) {
                c.add(Restrictions.ilike((String)propName, (String)((String)value), (MatchMode)matchMode));
            } else {
                c.add((Criterion)Restrictions.like((String)propName, (String)((String)value), (MatchMode)matchMode));
            }
        } else {
            if (String.valueOf(value).equals("0") && options.getExcludeZeros()) {
                return;
            }
            c.add((Criterion)Restrictions.eq((String)propName, (Object)value));
        }
    }

    private static void addExample(Object o, Criteria c, QueryOptions options) {
        Example e = Example.create((Object)o);
        c.add((Criterion)e);
        if (DataServiceLoggers.taskLogger.isDebugEnabled()) {
            DataServiceLoggers.taskLogger.debug((Object)("Added example for " + ObjectUtils.objectToString((Object)o)));
        }
        if (options.getTypedMatchMode() != null) {
            e.enableLike(options.getTypedMatchMode());
        }
        if (options.getExcludeNone()) {
            e.excludeNone();
        }
        if (options.getExcludeZeros()) {
            e.excludeZeroes();
        }
        if (options.getIgnoreCase()) {
            e.ignoreCase();
        }
    }
}

