/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.data.util;

import com.wavemaker.common.util.StringUtils;
import com.wavemaker.common.util.Tuple;
import com.wavemaker.runtime.service.Filter;
import com.wavemaker.runtime.service.OrderBy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HQLGenerator {
    private static final String SELECT = "select";
    private static final String FROM = "from";
    private static final String WHERE = "where";
    private static final String FETCH = "fetch";
    private static final String ORDER_BY = "order by";
    private static final String ASC = "asc";
    private static final String DESC = "desc";
    private static final String COUNT = "count";
    private static final String LOWER = "lower";
    private static final String ALIAS_PREFIX = "_e";
    private static final String ALL_COLUMNS = "*";
    private static final String ROOT_PATH = "";
    private static final JoinStrategy DEFAULT_JOIN_STRATEGY = new JoinStrategy(){

        public JoinStrategy.Join getJoin(String propertyPath, String dbName) {
            return JoinStrategy.Join.INNER_JOIN;
        }
    };
    private final Class<?> rootEntity;
    private final Collection<String> eagerPropertyPaths = new LinkedHashSet<String>();
    private final Map<String, String> propPathToAlias = new HashMap<String, String>();
    private final Map<String, String> aliasToPropPath = new HashMap<String, String>();
    private final Collection<String> aliases = new HashSet<String>();
    private final Collection<String> lowerPropertyPaths = new HashSet<String>();
    private final Collection<String> lowerOrders = new HashSet<String>();
    private final JoinStrategy joinStrategy;
    private final TypeManager typeManager;
    private Collection<Filter> selections = new ArrayList<Filter>();
    private Collection<OrderBy> orders = new ArrayList<OrderBy>();

    public HQLGenerator(Class<?> rootEntity) {
        this(rootEntity, DEFAULT_JOIN_STRATEGY, new TypeManager(){

            public boolean isComponentPath(String propertyPath, String dbName) {
                return false;
            }
        });
    }

    public HQLGenerator(Class<?> rootEntity, TypeManager typeManager) {
        this(rootEntity, DEFAULT_JOIN_STRATEGY, typeManager);
    }

    public HQLGenerator(Class<?> rootEntity, JoinStrategy joinStrategy, TypeManager typeManager) {
        this.rootEntity = rootEntity;
        this.joinStrategy = joinStrategy;
        this.typeManager = typeManager;
    }

    public HQLGenerator loadEagerly(Collection<String> propertyPaths) {
        for (String s : propertyPaths) {
            this.loadEagerly(s);
        }
        return this;
    }

    public HQLGenerator loadEagerly(String propertyPath) {
        this.validatePropertyPath(propertyPath);
        this.eagerPropertyPaths.add(propertyPath);
        int i = 0;
        while ((i = propertyPath.lastIndexOf(".")) != -1) {
            propertyPath = propertyPath.substring(0, i);
            this.eagerPropertyPaths.add(propertyPath);
        }
        return this;
    }

    public HQLGenerator setSelections(Collection<Filter> selections) {
        this.selections = selections;
        return this;
    }

    public HQLGenerator addSelection(String propertyPath, String expression) {
        return this.addSelection(propertyPath, expression, false);
    }

    public HQLGenerator addSelection(String propertyPath, String expression, boolean lower) {
        if (expression == null) {
            throw new IllegalArgumentException("expression cannot be null");
        }
        this.validatePropertyPath(propertyPath);
        Filter f = new Filter(propertyPath, expression);
        this.selections.add(f);
        if (lower) {
            this.lowerPropertyPaths.add(propertyPath);
        }
        return this;
    }

    public HQLGenerator setOrderBy(Collection<OrderBy> orders) {
        return this.setOrderBy(orders, false);
    }

    public HQLGenerator setOrderBy(Collection<OrderBy> orders, boolean lower) {
        this.orders = orders;
        if (lower) {
            for (OrderBy order : orders) {
                this.lowerOrders.add(order.getPropertyPath());
            }
        }
        return this;
    }

    public HQLGenerator addAscOrder(String propertyPath) {
        return this.addAscOrder(propertyPath, false);
    }

    public HQLGenerator addAscOrder(String propertyPath, boolean lower) {
        OrderBy o = new OrderBy();
        o.setAsc(propertyPath);
        this.orders.add(o);
        if (lower) {
            this.lowerOrders.add(propertyPath);
        }
        return this;
    }

    public HQLGenerator addDescOrder(String propertyPath) {
        return this.addDescOrder(propertyPath, false);
    }

    public HQLGenerator addDescOrder(String propertyPath, boolean lower) {
        OrderBy o = new OrderBy();
        o.setDesc(propertyPath);
        this.orders.add(o);
        if (lower) {
            this.lowerOrders.add(propertyPath);
        }
        return this;
    }

    public String getQuery(String dbName) {
        return this.getQuery(false, dbName);
    }

    public String getCountQuery(String dbName) {
        return this.getQuery(true, dbName);
    }

    private String getQuery(boolean count, String dbName) {
        this.reset();
        StringBuilder rtn = new StringBuilder();
        this.select(rtn, count);
        this.from(rtn);
        for (String s : this.getJoinPropertyPaths(count)) {
            this.createAlias(rtn, s, count, dbName);
        }
        boolean isFirst = true;
        for (Filter f : this.selections) {
            if (isFirst) {
                this.where(rtn);
                this.condition(rtn, f.getPropertyPath(), f.getExpression());
                isFirst = false;
                continue;
            }
            this.condition(rtn, f.getPropertyPath(), f.getExpression(), Operator.AND);
        }
        if (!count) {
            isFirst = true;
            for (OrderBy o : this.orders) {
                this.order(rtn, o, isFirst);
                isFirst = false;
            }
        }
        return rtn.toString();
    }

    private void reset() {
        this.propPathToAlias.clear();
        this.aliasToPropPath.clear();
        this.aliases.clear();
        this.propPathToAlias.put(ROOT_PATH, this.getNextAlias());
    }

    private Collection<String> getJoinPropertyPaths(boolean count) {
        String s;
        HashSet<String> rtn = new HashSet<String>();
        if (!count) {
            for (String s2 : this.eagerPropertyPaths) {
                rtn.add(s2);
            }
        }
        for (Filter f : this.selections) {
            s = (String)this.splitProperty((String)f.getPropertyPath()).v1;
            if (s.length() <= 0) continue;
            rtn.add(s);
        }
        if (!count) {
            for (OrderBy o : this.orders) {
                s = (String)this.splitProperty((String)o.getPropertyPath()).v1;
                if (s.length() <= 0) continue;
                rtn.add(s);
            }
        }
        return rtn;
    }

    private boolean isComponentPath(String propertyPath, String dbName) {
        return this.typeManager.isComponentPath(propertyPath, dbName);
    }

    private void validatePropertyPath(String propertyPath) {
        if (propertyPath == null) {
            throw new IllegalArgumentException("propertyPath cannot be null");
        }
        if (propertyPath.startsWith(".")) {
            throw new IllegalArgumentException("propertyPath cannot start with .");
        }
        if (propertyPath.endsWith(".")) {
            throw new IllegalArgumentException("propertyPath cannot end with .");
        }
    }

    private void select(StringBuilder sb, boolean count) {
        sb.append(SELECT).append(" ");
        if (count) {
            sb.append(COUNT).append("(");
            sb.append(ALL_COLUMNS);
            sb.append(")");
        } else {
            sb.append(this.getRootAlias());
        }
    }

    private void from(StringBuilder sb) {
        sb.append(" ").append(FROM).append(" ").append(this.rootEntity.getName()).append(" ").append(this.getRootAlias());
    }

    private void where(StringBuilder sb) {
        sb.append(" ");
        sb.append(WHERE);
    }

    private void condition(StringBuilder sb, String propertyPath, String expression) {
        this.condition(sb, propertyPath, expression, null);
    }

    private void condition(StringBuilder sb, String propertyPath, String expression, Operator op) {
        sb.append(" ");
        if (op != null) {
            sb.append((Object)op);
            sb.append(" ");
        }
        String alias = this.getAliasedPropertyPath(propertyPath);
        if (this.lowerPropertyPaths.contains(propertyPath)) {
            this.applyFunction(sb, LOWER, alias);
        } else {
            sb.append(alias);
        }
        sb.append(" ");
        sb.append(expression);
    }

    private void order(StringBuilder sb, OrderBy order, boolean isFirst) {
        if (isFirst) {
            sb.append(" ");
            sb.append(ORDER_BY);
            sb.append(" ");
        } else {
            sb.append(", ");
        }
        String alias = this.getAliasedPropertyPath(order.getPropertyPath());
        if (this.lowerOrders.contains(order.getPropertyPath())) {
            this.applyFunction(sb, LOWER, alias);
        } else {
            sb.append(alias);
        }
        sb.append(" ");
        if (order.isAsc()) {
            sb.append(ASC);
        } else {
            sb.append(DESC);
        }
    }

    private void join(StringBuilder sb, String propertyPath, String alias, String join, boolean eager) {
        sb.append(" ").append(join).append(" ");
        if (eager) {
            sb.append(FETCH).append(" ");
        }
        sb.append(propertyPath).append(" ").append(alias);
    }

    private void applyFunction(StringBuilder sb, String function, String arg) {
        sb.append(function);
        sb.append("(");
        sb.append(arg);
        sb.append(")");
    }

    private String getRootAlias() {
        return this.propPathToAlias.get(ROOT_PATH);
    }

    private String getAliasedPropertyPath(String propertyPath) {
        Tuple.Two<String, String> t = this.splitProperty(propertyPath);
        String path = (String)t.v1;
        String propName = (String)t.v2;
        String alias = this.getAlias(path);
        if (alias == null) {
            throw new AssertionError((Object)("unknown property path \"" + path + "\""));
        }
        return alias + "." + propName;
    }

    private String getAlias(String propertyPath) {
        return this.propPathToAlias.get(propertyPath);
    }

    private String createAlias(StringBuilder sb, String propertyPath, boolean count, String dbName) {
        Tuple.Three<String, String, String> t = this.resolvePropertyPath(propertyPath);
        String resolvedPath = (String)t.v1;
        String alias = (String)t.v2;
        String unresolvedPath = (String)t.v3;
        if (unresolvedPath == null) {
            return alias;
        }
        int i = 0;
        while (unresolvedPath.length() > 0) {
            i = unresolvedPath.indexOf(".");
            String joinOn = unresolvedPath;
            if (i > -1) {
                joinOn = unresolvedPath.substring(0, i);
                unresolvedPath = unresolvedPath.substring(i + 1);
            } else {
                unresolvedPath = ROOT_PATH;
            }
            String path = alias + "." + joinOn;
            if (resolvedPath.length() > 0) {
                resolvedPath = resolvedPath + ".";
            }
            if (this.isComponentPath(resolvedPath = resolvedPath + joinOn, dbName)) {
                Tuple.Three<String, String, String> rp = this.resolvePropertyPath(resolvedPath);
                String aliasedComponentPath = (String)rp.v2 + "." + (String)rp.v3;
                this.addAlias(aliasedComponentPath, resolvedPath);
                continue;
            }
            alias = this.getNextAlias();
            this.addAlias(alias, resolvedPath);
            boolean eager = !count && this.eagerPropertyPaths.contains(resolvedPath);
            String join = this.joinStrategy.getJoin(resolvedPath, dbName).toString();
            this.join(sb, path, alias, join, eager);
        }
        return alias;
    }

    private void addAlias(String alias, String path) {
        this.propPathToAlias.put(path, alias);
        this.aliasToPropPath.put(alias, path);
    }

    private Tuple.Three<String, String, String> resolvePropertyPath(String propertyPath) {
        String alias = null;
        String path = propertyPath;
        int i = 0;
        while ((alias = this.getAlias(path)) == null) {
            i = path.lastIndexOf(".");
            if (i > -1) {
                path = path.substring(0, i);
                continue;
            }
            path = ROOT_PATH;
        }
        String unresolvedPath = null;
        if (i != 0) {
            unresolvedPath = propertyPath.substring(i + 1);
        }
        return Tuple.tuple((Object)path, (Object)alias, unresolvedPath);
    }

    private Tuple.Two<String, String> splitProperty(String propertyPath) {
        String path = ROOT_PATH;
        String propName = propertyPath;
        int i = propertyPath.lastIndexOf(".");
        if (i > -1) {
            path = propertyPath.substring(0, i);
            propName = propertyPath.substring(i + 1);
        }
        return Tuple.tuple((Object)path, (Object)propName);
    }

    private String getNextAlias() {
        String rtn = StringUtils.getUniqueName((String)ALIAS_PREFIX, this.aliases);
        this.aliases.add(rtn);
        return rtn;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Operator {
        AND,
        OR;


        public String toString() {
            if (this == OR) {
                return "or";
            }
            if (this == AND) {
                return "and";
            }
            throw new AssertionError();
        }
    }

    public static interface JoinStrategy {
        public Join getJoin(String var1, String var2);

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Join {
            INNER_JOIN,
            LEFT_OUTER_JOIN;


            public String toString() {
                if (this == INNER_JOIN) {
                    return "join";
                }
                return "left outer join";
            }
        }
    }

    public static interface TypeManager {
        public boolean isComponentPath(String var1, String var2);
    }
}

