/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.data.util;

import com.wavemaker.common.util.ClassLoaderUtils;
import com.wavemaker.common.util.StringUtils;
import com.wavemaker.runtime.data.DataServiceRuntimeException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;

public class JDBCUtils {
    private JDBCUtils() {
        throw new UnsupportedOperationException();
    }

    public static void loadDriver(String driverClassName) {
        ClassLoaderUtils.loadClass((String)driverClassName);
    }

    public static Connection getConnection(String url, String username, String password, String driverClassName) {
        try {
            JDBCUtils.loadDriver(driverClassName);
            return DriverManager.getConnection(url, username, password);
        }
        catch (SQLException ex) {
            throw new DataServiceRuntimeException(ex);
        }
    }

    public static Object runSql(String[] sql, String url, String username, String password, String driverClassName) {
        return JDBCUtils.runSql(sql, url, username, password, driverClassName, false);
    }

    public static Object runSql(String[] sql, String url, String username, String password, String driverClassName, boolean isDDL) {
        return JDBCUtils.runSql(sql, url, username, password, driverClassName, null, isDDL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object runSql(String[] sql, String url, String username, String password, String driverClassName, Log logger, boolean isDDL) {
        block26: {
            block25: {
                con = JDBCUtils.getConnection(url, username, password, driverClassName);
                try {
                    try {
                        block24: {
                            block27: {
                                try {
                                    con.setAutoCommit(true);
                                }
                                catch (SQLException ex) {
                                    throw new DataServiceRuntimeException(ex);
                                }
                                s = con.createStatement();
                                try {
                                    try {
                                        for (String stmt : sql) {
                                            if (logger != null && logger.isInfoEnabled()) {
                                                logger.info((Object)("Running " + stmt));
                                            }
                                            s.execute(stmt);
                                        }
                                        if (isDDL) break block24;
                                        r = s.getResultSet();
                                        rtn = new ArrayList<Object>();
                                        while (r.next()) {
                                            rtn.add(r.getObject(1));
                                        }
                                        var11_16 = rtn.toArray(new Object[rtn.size()]);
                                    }
                                    catch (Exception ex) {
                                        if (logger == null) throw ex;
                                        if (logger.isErrorEnabled() == false) throw ex;
                                        logger.error((Object)ex.getMessage());
                                        throw ex;
                                    }
                                    var14_18 = null;
                                }
                                catch (Throwable var13_30) {
                                    var14_20 = null;
                                    try {
                                        s.close();
                                        throw var13_30;
                                    }
                                    catch (Exception ignore) {
                                        // empty catch block
                                    }
                                    throw var13_30;
                                }
                                ** try [egrp 6[TRYBLOCK] [5 : 259->269)] { 
lbl44:
                                // 1 sources

                                s.close();
                                break block27;
lbl46:
                                // 1 sources

                                catch (Exception ignore) {
                                }
                            }
                            var17_24 = null;
                            break block25;
                        }
                        var14_19 = null;
                        try {}
                        catch (Exception ignore) {}
                        s.close();
                        break block26;
                    }
                    catch (Exception ex) {
                        if (ex instanceof RuntimeException == false) throw new DataServiceRuntimeException(ex);
                        throw (RuntimeException)ex;
                    }
                }
                catch (Throwable var16_31) {
                    var17_26 = null;
                    try {
                        con.close();
                        throw var16_31;
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                    throw var16_31;
                }
            }
            try {}
            catch (Exception ignore) {
                // empty catch block
                return var11_16;
            }
            con.close();
            return var11_16;
        }
        var17_25 = null;
        try {}
        catch (Exception ignore) {}
        con.close();
        return null;
        return null;
    }

    public static void testMySQLConnection(String url, String username, String password, String driverClassName) {
        JDBCUtils.runSql(new String[]{"SHOW DATABASES"}, url, username, password, driverClassName);
    }

    public static void testOracleConnection(String url, String username, String password, String driverClassName) {
        JDBCUtils.runSql(new String[]{"SELECT TABLE_NAME FROM TABS"}, url, username, password, driverClassName);
    }

    public static void testSQLServerConnection(String url, String username, String password, String driverClassName) {
        JDBCUtils.runSql(new String[]{"SELECT NAME FROM master..sysdatabases"}, url, username, password, driverClassName);
    }

    public static String reWriteConnectionUrl(String connectionUrl, String webAppRoot) {
        if (connectionUrl.contains(webAppRoot)) {
            return connectionUrl;
        }
        StringTokenizer cxnStrTokens = new StringTokenizer(connectionUrl, ":");
        String driverType = null;
        String dbType = null;
        String dbFormat = null;
        String dbFileName = null;
        int index = 0;
        ArrayList<String> dbSettings = new ArrayList<String>();
        while (cxnStrTokens.hasMoreElements()) {
            String token = cxnStrTokens.nextToken();
            if (token.equals("jdbc") && index == 0) {
                driverType = token;
            }
            if (token.equals("hsqldb") && index == 1) {
                dbType = token;
            }
            if (token.equals("file") && index == 2) {
                dbFormat = token;
            }
            if (index == 3) {
                StringTokenizer dbFileCfgTokens = new StringTokenizer(token, ";");
                dbFileName = dbFileCfgTokens.nextToken();
                while (dbFileCfgTokens.hasMoreTokens()) {
                    dbSettings.add(dbFileCfgTokens.nextToken());
                }
            }
            ++index;
        }
        assert (driverType != null && driverType.equals("jdbc"));
        assert (dbType != null && dbType.equals("hsqldb"));
        assert (dbFormat != null && dbFormat.equals("file"));
        assert (dbFileName != null);
        assert (index == 4);
        String hsqlDBName = "{WebAppRoot}/data/" + dbFileName;
        String cxnUrl = new String("jdbc:hsqldb:file:" + hsqlDBName);
        Iterator itr = dbSettings.iterator();
        while (itr.hasNext()) {
            cxnUrl = cxnUrl + ";";
            cxnUrl = cxnUrl + (String)itr.next();
        }
        cxnUrl = StringUtils.replacePlainStr((String)cxnUrl, (String)"{WebAppRoot}", (String)webAppRoot);
        return cxnUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void testHSQLConnection(String url, String username, String password, String driverClassName) {
        if (!url.contains("ifexists")) {
            if (!url.endsWith(";")) {
                url = url + ";";
            }
            url = url + "ifexists=true";
        }
        Connection con = null;
        try {
            con = JDBCUtils.getConnection(url, username, password, driverClassName);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            try {
                con.close();
            }
            catch (Exception ignore) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            con.close();
        }
        catch (Exception ignore) {}
    }

    public static String getMySQLDatabaseName(String connectionUrl) {
        String s = StringUtils.fromFirstOccurrence((String)connectionUrl, (String)"?", (int)-1);
        int i = s.lastIndexOf("/");
        if (i <= 0 || i == s.length() - 1) {
            return null;
        }
        if (s.charAt(i - 1) == '/') {
            return null;
        }
        return s.substring(i + 1);
    }
}

