/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.data.util;

import com.wavemaker.common.util.ClassLoaderUtils;
import com.wavemaker.common.util.StringUtils;
import com.wavemaker.common.util.TypeConversionUtils;
import com.wavemaker.runtime.data.DataServiceManager;
import com.wavemaker.runtime.data.DataServiceQueryException;
import com.wavemaker.runtime.data.DefaultTaskManager;
import com.wavemaker.runtime.data.Task;
import com.wavemaker.runtime.data.util.DataServiceUtils;
import com.wavemaker.runtime.data.util.SystemUtils;
import com.wavemaker.runtime.service.PagingOptions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.hql.ast.QuerySyntaxException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryRunner {
    private static final Task runQueryTask;
    private static final Task checkQueryTask;
    private final DataServiceManager mgr;
    private final Map<String, Object> bindParameters = new HashMap<String, Object>();
    private Long maxResults = null;

    public QueryRunner(DataServiceManager mgr) {
        this.mgr = mgr;
    }

    public void addBindParameters(List<String> names, List<String> types, String value, List<Boolean> isList) {
        List<Object> values = new ArrayList(names.size());
        if (value == null) {
            for (String s : names) {
                values.add(null);
            }
        } else {
            values = StringUtils.split((String)value);
        }
        for (int i = 0; i < names.size(); ++i) {
            this.addBindParameter(names.get(i), types.get(i), (String)values.get(i), (boolean)isList.get(i));
        }
    }

    public void addBindParameter(String name, String type, String value) {
        this.addBindParameter(name, type, value, false);
    }

    public void addBindParameter(String name, String type, String value, boolean isList) {
        this.addBindParameter(name, ClassLoaderUtils.loadClass((String)type, (boolean)false), value, isList);
    }

    public void addBindParameter(String name, Class<?> type, String value) {
        this.addBindParameter(name, type, value, false);
    }

    public void addBindParameter(String name, Class<?> type, String value, boolean isList) {
        Object o = TypeConversionUtils.fromString(type, (String)value, (boolean)isList);
        this.bindParameters.put(name, o);
    }

    public void setMaxResults(Long maxResults) {
        this.maxResults = maxResults;
    }

    public void check(String query) {
        block2: {
            Object[] args = this.setupTaskArgs(query, false);
            try {
                this.mgr.invoke(checkQueryTask, args);
            }
            catch (RuntimeException ex) {
                ex = DataServiceUtils.unwrap(ex);
                if (!(ex instanceof QuerySyntaxException) && !(ex instanceof DataServiceQueryException)) break block2;
                throw ex;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object run(String query) {
        try {
            Object[] args = this.setupTaskArgs(query, true);
            Object rtn = this.mgr.invoke(runQueryTask, args);
            SystemUtils.clientPrepare();
            Object object = rtn;
            Object var6_5 = null;
            this.bindParameters.clear();
            return object;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.bindParameters.clear();
            throw throwable;
        }
    }

    public void dispose() {
        this.mgr.dispose();
    }

    private Object[] setupTaskArgs(String query, boolean includePagingOptions) {
        int size = this.bindParameters.size() * 2 + 1;
        if (includePagingOptions) {
            ++size;
        }
        Object[] args = new Object[size];
        args[0] = query;
        int i = 1;
        for (String paramName : this.bindParameters.keySet()) {
            args[i] = paramName;
            args[i + 1] = this.bindParameters.get(paramName);
            i += 2;
        }
        if (includePagingOptions) {
            PagingOptions pagingOptions = new PagingOptions();
            pagingOptions.setMaxResults(this.maxResults);
            args[i] = pagingOptions;
        }
        return args;
    }

    static {
        DefaultTaskManager taskMgr = DefaultTaskManager.getInstance();
        runQueryTask = taskMgr.getRunQueryTask();
        checkQueryTask = taskMgr.getCheckQueryTask();
    }
}

