/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.data.util;

import com.wavemaker.json.PropertyFilter;
import com.wavemaker.runtime.data.DataPropertyFilter;
import com.wavemaker.runtime.data.DataServiceManager;
import com.wavemaker.runtime.data.DataServiceManagerAccess;
import com.wavemaker.runtime.data.DataServiceMetaData;
import com.wavemaker.runtime.data.util.DataServiceUtils;
import com.wavemaker.runtime.server.InternalRuntime;
import java.util.List;
import org.hibernate.Session;

public class SystemUtils {
    public static void clientPrepare() {
        SystemUtils.registerPropertyFilter();
    }

    public static Object serverMergeForUpdate(Object o, DataServiceManagerAccess mgrAccess) {
        DataServiceManager mgr = mgrAccess.getDataServiceManager();
        return SystemUtils.serverMergeForUpdate(o, mgr.getSession(), mgr.getMetaData());
    }

    public static Object serverMergeForUpdate(Object o, Session session, DataServiceMetaData metaData) {
        if (o == null) {
            return null;
        }
        InternalRuntime internalRuntime = InternalRuntime.getInstance();
        List<List<String>> args = internalRuntime.getDeserializedProperties();
        if (args.isEmpty()) {
            return o;
        }
        List<String> populatedProperties = args.get(0);
        return DataServiceUtils.mergeForUpdate(o, session, metaData, populatedProperties);
    }

    public static Object serverMergeForInsert(Object o, Session session, DataServiceMetaData metaData) {
        return DataServiceUtils.mergeForInsert(o, session, metaData);
    }

    public static void registerPropertyFilter() {
        InternalRuntime internalRuntime = InternalRuntime.getInstance();
        internalRuntime.getJSONState().setPropertyFilter((PropertyFilter)DataPropertyFilter.getInstance());
    }

    @Deprecated
    public static Object clientPrepare(Object o) {
        SystemUtils.registerPropertyFilter();
        return o;
    }

    @Deprecated
    public static Object clientPrepare(Object o, DataServiceManagerAccess mgrAccess) {
        SystemUtils.registerPropertyFilter();
        return o;
    }

    private SystemUtils() {
        throw new UnsupportedOperationException();
    }
}

