/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.javaservice;

import com.wavemaker.common.util.IOUtils;
import com.wavemaker.runtime.RuntimeAccess;
import com.wavemaker.runtime.service.annotations.HideFromClient;
import java.io.File;
import java.util.Properties;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContextHolder;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class JavaServiceSuperClass {
    private Logger logger;
    public static final int FATAL = 0;
    public static final int ERROR = 1;
    public static final int WARN = 2;
    public static final int INFO = 3;
    public static final int DEBUG = 4;
    public static final String[] LEVELS = new String[]{"FATAL", "ERROR", "WARN", "INFO", "DEBUG"};
    public static final String OPEN_PROJECT_SESSION_NAME = "agOpenProjectName";
    public static final String PROJECTHOME_KEY = "wm.projectsDir";

    public JavaServiceSuperClass() {
        this.init(1);
    }

    public JavaServiceSuperClass(int logLevel) {
        this.init(logLevel);
    }

    private void init(int logLevel) {
        this.logger = Logger.getLogger((String)this.getClass().getName());
        try {
            String currentPath = RuntimeAccess.getInstance().getSession().getServletContext().getRealPath("");
            File webapproot = new File(currentPath);
            boolean isLiveLayout = false;
            boolean isDeployedApp = false;
            boolean isTestRun = false;
            if (new File(webapproot, "app/deploy.js").exists()) {
                isLiveLayout = true;
            } else if (new File(webapproot, "lib/dojo").exists()) {
                isDeployedApp = true;
            } else {
                isTestRun = true;
            }
            String startLogLine = "START_WM_LOG_LINE %d{ABSOLUTE}";
            String endLogLine = "END_WM_LOG_LINE";
            File logFolder = new File(System.getProperty("catalina.home") + "/logs/ProjectLogs");
            if (!isDeployedApp) {
                String projectName = webapproot.getParentFile().getName();
                logFolder = new File(logFolder, projectName);
            }
            IOUtils.makeDirectories((File)logFolder, (File)new File(System.getProperty("catalina.home")));
            if (isDeployedApp) {
                startLogLine = "";
                endLogLine = "";
            }
            System.out.println("LOG FOLDER: " + logFolder.toString() + " | " + logFolder.exists());
            Properties props = new Properties();
            props.setProperty("log4j.logger." + this.getClass().getName(), LEVELS[logLevel] + ", WebServiceLogger1, WebServiceLogger2");
            props.setProperty("log4j.appender.WebServiceLogger1", "org.apache.log4j.RollingFileAppender");
            props.setProperty("log4j.appender.WebServiceLogger1.File", logFolder.toString() + "/" + this.getClass().getName() + ".log");
            props.setProperty("log4j.appender.WebServiceLogger1.MaxFileSize", "50KB");
            props.setProperty("log4j.appender.WebServiceLogger1.layout", "org.apache.log4j.PatternLayout");
            props.setProperty("log4j.appender.WebServiceLogger1.layout.ConversionPattern", startLogLine + " %5p (%F:%L) " + (isDeployedApp ? "%d" : "%d{HH:mm:ss}") + " - %m " + endLogLine + "%n");
            props.setProperty("log4j.appender.WebServiceLogger2", "org.apache.log4j.RollingFileAppender");
            props.setProperty("log4j.appender.WebServiceLogger2.File", logFolder.toString() + "/project.log");
            props.setProperty("log4j.appender.WebServiceLogger2.MaxFileSize", "50KB");
            props.setProperty("log4j.appender.WebServiceLogger2.layout", "org.apache.log4j.PatternLayout");
            props.setProperty("log4j.appender.WebServiceLogger2.layout.ConversionPattern", startLogLine + " %5p (%F:%L) %d{HH:mm:ss} - %m " + endLogLine + "%n");
            PropertyConfigurator.configure((Properties)props);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getCurrentUsername() {
        try {
            Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
            String username = authentication.getName();
            username = username.replaceAll("_", "__");
            username = username.replaceAll("\\.", "_DOT_");
            username = username.replaceAll("@", "_AT_");
            return username;
        }
        catch (Exception e) {
            return null;
        }
    }

    protected void log(int level, String message, Exception e) {
        switch (level) {
            case 4: {
                this.logger.debug((Object)message, (Throwable)e);
                break;
            }
            case 1: {
                this.logger.error((Object)message, (Throwable)e);
                break;
            }
            case 3: {
                this.logger.info((Object)message, (Throwable)e);
                break;
            }
            case 2: {
                this.logger.warn((Object)message, (Throwable)e);
                break;
            }
            case 0: {
                this.logger.fatal((Object)message, (Throwable)e);
            }
        }
    }

    protected void log(int level, String message) {
        switch (level) {
            case 4: {
                this.logger.debug((Object)message);
                break;
            }
            case 1: {
                this.logger.error((Object)message);
                break;
            }
            case 3: {
                this.logger.info((Object)message);
                break;
            }
            case 2: {
                this.logger.warn((Object)message);
                break;
            }
            case 0: {
                this.logger.fatal((Object)message);
            }
        }
    }

    @HideFromClient
    public void setLogLevel(int level) {
    }
}

