/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.module;

import com.wavemaker.common.Resource;
import com.wavemaker.common.WMRuntimeException;
import com.wavemaker.common.util.Tuple;
import com.wavemaker.runtime.module.ModuleWire;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBException;
import org.apache.log4j.Logger;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.SimpleBeanDefinitionRegistry;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.core.io.UrlResource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.ResourceUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleManager {
    protected final Logger logger = Logger.getLogger(this.getClass());
    private ClassLoader classLoader;
    private Map<String, Tuple.Two<URL, ModuleWire>> moduleLocations = new HashMap<String, Tuple.Two<URL, ModuleWire>>();
    public static final String MODULE_CONFIG_FILE = "module-configuration.xml";

    public ModuleManager() {
        this.classLoader = null;
    }

    public ModuleManager(ClassLoader cl) {
        this.classLoader = cl;
    }

    public ModuleWire getModule(String extensionPoint) {
        List<ModuleWire> modules = this.getModules(extensionPoint);
        if (modules.size() > 1) {
            throw new WMRuntimeException(Resource.TOO_MANY_MODULES_FOR_EXTENSION_POINT, new Object[]{extensionPoint, modules});
        }
        if (modules.size() == 1) {
            return modules.get(0);
        }
        return null;
    }

    public List<ModuleWire> getModules(String extensionPoint) {
        ArrayList<ModuleWire> ret = new ArrayList<ModuleWire>();
        for (Tuple.Two<URL, ModuleWire> tuple : this.moduleLocations.values()) {
            if (!extensionPoint.equals(((ModuleWire)tuple.v2).getExtensionPoint())) continue;
            ret.add((ModuleWire)tuple.v2);
        }
        return ret;
    }

    public ModuleWire getModuleByName(String name) {
        if (this.moduleLocations.containsKey(name)) {
            return (ModuleWire)this.moduleLocations.get((Object)name).v2;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addModuleWire(ModuleWire moduleWire) {
        URL ur;
        try {
            ur = this.findModuleLocation(moduleWire.getName());
        }
        catch (IOException e) {
            throw new WMRuntimeException((Throwable)e);
        }
        catch (JAXBException e) {
            throw new WMRuntimeException((Throwable)e);
        }
        if (null == ur) {
            throw new WMRuntimeException(Resource.MODULE_NOT_FOUND, new Object[]{moduleWire.getName(), moduleWire});
        }
        if (this.moduleLocations.containsKey(moduleWire.getName())) {
            if (!((URL)this.moduleLocations.get((Object)moduleWire.getName()).v1).equals(ur)) throw new WMRuntimeException(Resource.MODULE_DUPLICATE, new Object[]{moduleWire.getName(), this.moduleLocations.get((Object)moduleWire.getName()).v1, ur});
            this.logger.debug((Object)("Skipping ModuleWire that already exists " + moduleWire.getName() + " (location " + ur + ")"));
            return;
        } else {
            this.logger.info((Object)("Adding ModuleWire " + moduleWire.getName() + " (" + moduleWire + ") at location " + ur));
            this.moduleLocations.put(moduleWire.getName(), (Tuple.Two<URL, ModuleWire>)new Tuple.Two((Object)ur, (Object)moduleWire));
        }
    }

    public Set<String> listExtensionPoints() {
        HashSet<String> ret = new HashSet<String>();
        for (Tuple.Two<URL, ModuleWire> tuple : this.moduleLocations.values()) {
            ret.add(((ModuleWire)tuple.v2).getExtensionPoint());
        }
        return Collections.unmodifiableSet(ret);
    }

    public Set<String> listModules() {
        return Collections.unmodifiableSet(this.moduleLocations.keySet());
    }

    public URL getModuleResource(ModuleWire moduleWire, String relativePath) throws MalformedURLException, FileNotFoundException {
        File moduleRoot = this.getModuleRoot(moduleWire.getName());
        if (moduleRoot.isDirectory()) {
            File f = new File(moduleRoot, relativePath);
            return f.toURL();
        }
        StringBuffer ret = new StringBuffer();
        ret.append("jar:" + moduleRoot.toURL() + "!");
        if (!relativePath.startsWith("/")) {
            ret.append("/");
        }
        ret.append(relativePath);
        return new URL(ret.toString());
    }

    protected File getModuleRoot(String name) throws MalformedURLException, FileNotFoundException {
        Tuple.Two<URL, ModuleWire> tuple = this.moduleLocations.get(name);
        if (null == tuple) {
            throw new WMRuntimeException(Resource.MODULE_UNINITIALIZED, new Object[]{name});
        }
        URL url = (URL)tuple.v1;
        if (ResourceUtils.isJarURL((URL)url)) {
            URL jarURL = ResourceUtils.extractJarFileURL((URL)url);
            return ResourceUtils.getFile((URL)jarURL);
        }
        return ResourceUtils.getFile((URL)url).getParentFile();
    }

    protected URL findModuleLocation(String moduleName) throws IOException, JAXBException {
        org.springframework.core.io.Resource[] resources;
        PathMatchingResourcePatternResolver searcher = null == this.classLoader ? new PathMatchingResourcePatternResolver() : new PathMatchingResourcePatternResolver(this.classLoader);
        for (org.springframework.core.io.Resource resource : resources = searcher.getResources("classpath*:/module-configuration.xml")) {
            if (resource instanceof UrlResource) {
                UrlResource ur = (UrlResource)resource;
                List<BeanDefinition> beans = this.readSpringBean(resource);
                for (BeanDefinition bean : beans) {
                    String name;
                    MutablePropertyValues props = bean.getPropertyValues();
                    PropertyValue val = props.getPropertyValue("name");
                    if (null == val) {
                        throw new WMRuntimeException(Resource.MODULEWIRE_MISSING_NAME, new Object[]{ur});
                    }
                    if (null != val.getConvertedValue()) {
                        name = (String)val.getConvertedValue();
                    } else if (val.getValue() instanceof TypedStringValue) {
                        name = ((TypedStringValue)val.getValue()).getValue();
                    } else {
                        throw new WMRuntimeException(Resource.MODULE_BAD_NAME, new Object[]{val.getValue(), null != val.getValue() ? val.getValue().getClass() : null, ur});
                    }
                    if (null == name || "".equals(name)) {
                        throw new WMRuntimeException(Resource.MODULEWIRE_MISSING_NAME, new Object[]{ur});
                    }
                    if (!moduleName.equals(name)) continue;
                    return resource.getURL();
                }
                continue;
            }
            throw new WMRuntimeException(Resource.MODULE_UNKNOWN_RESOURCE_TYPE, new Object[]{resource, resource.getClass()});
        }
        return null;
    }

    protected Map<String, Tuple.Two<URL, ModuleWire>> getModuleLocations() {
        return this.moduleLocations;
    }

    private List<BeanDefinition> readSpringBean(org.springframework.core.io.Resource resource) {
        SimpleBeanDefinitionRegistry registry = new SimpleBeanDefinitionRegistry();
        XmlBeanDefinitionReader reader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)registry);
        reader.loadBeanDefinitions(resource);
        ArrayList<BeanDefinition> ret = new ArrayList<BeanDefinition>();
        for (String beanName : registry.getBeanDefinitionNames()) {
            BeanDefinition beandef = registry.getBeanDefinition(beanName);
            if (!beandef.getBeanClassName().equals(ModuleWire.class.getName())) continue;
            ret.add(beandef);
        }
        return ret;
    }
}

