/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.security;

import com.wavemaker.runtime.security.RedirectResponseWrapper;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.acegisecurity.AuthenticationException;
import org.springframework.web.filter.OncePerRequestFilter;

public class AcegiAjaxFilter
extends OncePerRequestFilter {
    private static final String ACEGI_AJAX_LOGIN_REQUEST_PARAM = "acegiAjaxLogin";
    private static final String SUCCESS_URL = "url";
    private static final String FAILURE_ERROR_MESSAGE = "error";
    private static final String FAILURE_INDICATOR = "login_error=1";

    protected void doFilterInternal(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws ServletException, IOException {
        HttpServletRequest request = httpServletRequest;
        HttpServletResponse response = httpServletResponse;
        if (!this.isAjaxRequest(request)) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        RedirectResponseWrapper redirectResponseWrapper = new RedirectResponseWrapper(response);
        filterChain.doFilter((ServletRequest)request, (ServletResponse)redirectResponseWrapper);
        if (redirectResponseWrapper.getRedirect() != null) {
            String jsonContent;
            request.setCharacterEncoding("UTF-8");
            response.setContentType("text/plain;charset=utf-8");
            response.setHeader("Cache-Control", "no-cache");
            response.setDateHeader("Expires", 0L);
            response.setHeader("Pragma", "no-cache");
            String redirectURL = redirectResponseWrapper.getRedirect();
            if (redirectURL.indexOf(FAILURE_INDICATOR) == -1) {
                jsonContent = "{\"url\":\"" + redirectURL + "\"}";
            } else {
                String errorMsg = ((AuthenticationException)request.getSession().getAttribute("ACEGI_SECURITY_LAST_EXCEPTION")).getMessage();
                jsonContent = "{\"error\":\"" + errorMsg + "\"}";
            }
            response.getOutputStream().write(jsonContent.getBytes());
        }
    }

    private boolean isAjaxRequest(HttpServletRequest request) {
        return request.getParameter(ACEGI_AJAX_LOGIN_REQUEST_PARAM) != null;
    }
}

