/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.security;

import com.wavemaker.common.WMRuntimeInitException;
import com.wavemaker.runtime.WMAppContext;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.userdetails.User;
import org.acegisecurity.userdetails.jdbc.JdbcDaoImpl;
import org.springframework.jdbc.core.SqlParameter;
import org.springframework.jdbc.object.MappingSqlQuery;

public class EnhancedJdbcDaoImpl
extends JdbcDaoImpl {
    private String authoritiesByUsernameQueryParamType;

    protected void initMappingSqlQueries() {
        String qryStr = this.getUsersByUsernameQuery();
        try {
            WMAppContext wmApp = WMAppContext.getInstance();
            if (wmApp != null && WMAppContext.getInstance().isMultiTenant()) {
                qryStr = this.insertTenantIdField(this.getUsersByUsernameQuery(), wmApp.getTenantColumnName());
            }
        }
        catch (WMRuntimeInitException wMRuntimeInitException) {
            // empty catch block
        }
        this.usersByUsernameMapping = new UsersByUsernameMapping(this.getDataSource(), qryStr);
        this.authoritiesByUsernameMapping = new AuthoritiesByUsernameMapping(this.getDataSource());
    }

    private String insertTenantIdField(String str, String colName) {
        StringBuffer sb = new StringBuffer(str);
        int indx = sb.lastIndexOf("FROM");
        if (indx < 0) {
            indx = sb.lastIndexOf("from");
        }
        if (indx < 0) {
            return str;
        }
        sb.insert(indx, ", " + colName + " ");
        return sb.toString();
    }

    public String getAuthoritiesByUsernameQueryParamType() {
        return this.authoritiesByUsernameQueryParamType;
    }

    public void setAuthoritiesByUsernameQueryParamType(String authoritiesByUsernameQueryParamType) {
        this.authoritiesByUsernameQueryParamType = authoritiesByUsernameQueryParamType;
    }

    protected class UsersByUsernameMapping
    extends MappingSqlQuery {
        protected UsersByUsernameMapping(DataSource ds, String str) {
            super(ds, str);
            this.declareParameter(new SqlParameter(12));
            this.compile();
        }

        protected Object mapRow(ResultSet rs, int rownum) throws SQLException {
            String userid = rs.getString(1);
            String password = rs.getString(2);
            boolean enabled = rs.getBoolean(3);
            String username = null;
            try {
                username = rs.getString(4);
            }
            catch (SQLException e) {
                // empty catch block
            }
            try {
                int tenantId = -1;
                WMAppContext wmApp = WMAppContext.getInstance();
                if (wmApp != null && wmApp.isMultiTenant()) {
                    tenantId = rs.getInt(5);
                    wmApp.setTenantIdForUser(username, tenantId);
                }
            }
            catch (WMRuntimeInitException ex) {
                // empty catch block
            }
            WMAppContext.getInstance().setUserNameForUserID(userid, username);
            User user = new User(userid, password, enabled, true, true, true, new GrantedAuthority[]{new GrantedAuthorityImpl("HOLDER")});
            return user;
        }
    }

    protected class AuthoritiesByUsernameMapping
    extends MappingSqlQuery {
        protected AuthoritiesByUsernameMapping(DataSource ds) {
            super(ds, EnhancedJdbcDaoImpl.this.getAuthoritiesByUsernameQuery());
            int type = 12;
            String sType = EnhancedJdbcDaoImpl.this.getAuthoritiesByUsernameQueryParamType();
            if (sType != null && sType.equals("integer")) {
                type = 4;
            }
            this.declareParameter(new SqlParameter(type));
            this.compile();
        }

        protected Object mapRow(ResultSet rs, int rownum) throws SQLException {
            String roleName = EnhancedJdbcDaoImpl.this.getRolePrefix() + rs.getString(2);
            GrantedAuthorityImpl authority = new GrantedAuthorityImpl(roleName);
            return authority;
        }
    }
}

