/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.server;

import com.activegrid.runtime.AGRuntime;
import com.wavemaker.common.Resource;
import com.wavemaker.common.WMException;
import com.wavemaker.common.WMRuntimeException;
import com.wavemaker.json.JSONArray;
import com.wavemaker.json.JSONState;
import com.wavemaker.json.type.FieldDefinition;
import com.wavemaker.json.type.GenericFieldDefinition;
import com.wavemaker.json.type.TypeDefinition;
import com.wavemaker.json.type.TypeState;
import com.wavemaker.json.type.reflect.MapReflectTypeDefinition;
import com.wavemaker.json.type.reflect.ReflectTypeState;
import com.wavemaker.json.type.reflect.ReflectTypeUtils;
import com.wavemaker.json.type.reflect.converters.DateTypeDefinition;
import com.wavemaker.json.type.reflect.converters.FileTypeDefinition;
import com.wavemaker.runtime.RuntimeAccess;
import com.wavemaker.runtime.server.InternalRuntime;
import com.wavemaker.runtime.server.ServerUtils;
import com.wavemaker.runtime.server.json.converters.BlobTypeDefinition;
import com.wavemaker.runtime.server.json.converters.ClobTypeDefinition;
import com.wavemaker.runtime.server.view.TypedView;
import com.wavemaker.runtime.service.ParsedServiceArguments;
import com.wavemaker.runtime.service.ServiceManager;
import com.wavemaker.runtime.service.ServiceWire;
import com.wavemaker.runtime.service.TypedServiceReturn;
import com.wavemaker.runtime.service.events.ServiceEventNotifier;
import com.wavemaker.runtime.service.events.ServletEventNotifier;
import com.wavemaker.runtime.service.response.RootServiceResponse;
import java.io.File;
import java.io.IOException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.NullArgumentException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.NDC;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.mvc.AbstractController;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ControllerBase
extends AbstractController {
    protected final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private ServiceManager serviceManager;
    private ServiceEventNotifier serviceEventNotifier;
    private ServletEventNotifier servletEventNotifier;
    private AGRuntime runtime;
    private InternalRuntime internalRuntime;
    private RuntimeAccess runtimeAccess;

    public static JSONState createJSONState() {
        JSONState jsonState = new JSONState();
        jsonState.setCycleHandler(JSONState.CycleHandler.NO_PROPERTY);
        jsonState.getTypeState().addType((TypeDefinition)new DateTypeDefinition(java.util.Date.class));
        jsonState.getTypeState().addType((TypeDefinition)new DateTypeDefinition(Date.class));
        jsonState.getTypeState().addType((TypeDefinition)new DateTypeDefinition(Timestamp.class));
        jsonState.getTypeState().addType((TypeDefinition)new DateTypeDefinition(Time.class));
        jsonState.getTypeState().addType((TypeDefinition)new FileTypeDefinition(File.class));
        jsonState.getTypeState().addType((TypeDefinition)new BlobTypeDefinition(Blob.class));
        jsonState.getTypeState().addType((TypeDefinition)new ClobTypeDefinition(Clob.class));
        return jsonState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) {
        ModelAndView ret;
        if (null == request) {
            throw new WMRuntimeException(Resource.SERVER_NOREQUEST);
        }
        if (null == response) {
            throw new WMRuntimeException(Resource.SERVER_NORESPONSE);
        }
        try {
            try {
                StringBuilder logEntry = new StringBuilder();
                HttpSession session = request.getSession(false);
                if (null != session) {
                    logEntry.append("session " + session.getId() + ", ");
                }
                logEntry.append("thread " + Thread.currentThread().getId());
                NDC.push((String)logEntry.toString());
                response.setCharacterEncoding("UTF-8");
                this.getServletEventNotifier().executeStartRequest();
                this.initializeRuntime(request);
                ret = this.executeRequest(request, response);
                this.getServletEventNotifier().executeEndRequest();
            }
            catch (Throwable t) {
                this.logger.error((Object)t.getMessage(), t);
                while (null != t.getCause()) {
                    t = t.getCause();
                }
                String message = null != t.getMessage() && t.getMessage().length() > 0 ? t.getMessage() : t.toString();
                ModelAndView modelAndView = this.handleError(message, t);
                Object var8_10 = null;
                NDC.pop();
                NDC.remove();
                return modelAndView;
            }
            Object var8_9 = null;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            NDC.pop();
            NDC.remove();
            throw throwable;
        }
        NDC.pop();
        NDC.remove();
        return ret;
    }

    protected void initializeRuntimeController(HttpServletRequest request) {
        JSONState jsonConfig = ControllerBase.createJSONState();
        this.getInternalRuntime().setJSONState(jsonConfig);
    }

    protected abstract ModelAndView executeRequest(HttpServletRequest var1, HttpServletResponse var2) throws IOException, WMException;

    protected abstract ModelAndView handleError(String var1, Throwable var2);

    protected abstract View getView();

    protected ModelAndView getModelAndView(TypedView view, TypedServiceReturn typedServiceReturn) {
        ModelAndView ret;
        Object fd = null != typedServiceReturn.getReturnType() ? typedServiceReturn.getReturnType() : new GenericFieldDefinition();
        Object resultObject = typedServiceReturn.getReturnValue();
        if (null != resultObject && resultObject instanceof RootServiceResponse) {
            view.setRootType((FieldDefinition)fd);
            ret = new ModelAndView((View)view, "WM_ROOT_MODEL_OBJECT_KEY", resultObject);
        } else {
            MapReflectTypeDefinition mrtd = new MapReflectTypeDefinition();
            mrtd.setKeyFieldDefinition(ReflectTypeUtils.getFieldDefinition(String.class, (TypeState)new ReflectTypeState(), (boolean)false, null));
            mrtd.setValueFieldDefinition(fd);
            view.setRootType((FieldDefinition)new GenericFieldDefinition((TypeDefinition)mrtd));
            ret = new ModelAndView((View)view, "result", resultObject);
        }
        return ret;
    }

    protected TypedServiceReturn invokeMethod(ServiceWire sw, String method, JSONArray jsonArgs, Map<String, Object[]> mapParams) throws WMException {
        if (null != jsonArgs && null != mapParams) {
            throw new WMRuntimeException(Resource.BOTH_ARGUMENT_TYPES, new Object[]{jsonArgs, mapParams});
        }
        if (null == sw) {
            throw new NullArgumentException("sw");
        }
        sw.getServiceType().setup(sw, this.internalRuntime, this.runtimeAccess);
        JSONState jsonState = this.getInternalRuntime().getJSONState();
        ParsedServiceArguments args = null != mapParams ? sw.getServiceType().parseServiceArgs(sw, method, mapParams, jsonState) : sw.getServiceType().parseServiceArgs(sw, method, jsonArgs, jsonState);
        this.getInternalRuntime().setDeserializedProperties(args.getGettersCalled());
        return ServerUtils.invokeMethodWithEvents(this.getServiceEventNotifier(), sw, method, args, jsonState, false);
    }

    private void initializeRuntime(HttpServletRequest request) {
        RuntimeAccess.setRuntimeBean(this.getRuntimeAccess());
        InternalRuntime.setInternalRuntimeBean(this.getInternalRuntime());
        AGRuntime.setRuntimeBean(this.getRuntime());
        this.getRuntimeAccess().setRequest(request);
        this.initializeRuntimeController(request);
    }

    public void setServiceManager(ServiceManager spm) {
        this.serviceManager = spm;
    }

    public ServiceManager getServiceManager() {
        return this.serviceManager;
    }

    public ServletEventNotifier getServletEventNotifier() {
        return this.servletEventNotifier;
    }

    public void setServletEventNotifier(ServletEventNotifier servletEventNotifier) {
        this.servletEventNotifier = servletEventNotifier;
    }

    public ServiceEventNotifier getServiceEventNotifier() {
        return this.serviceEventNotifier;
    }

    public void setServiceEventNotifier(ServiceEventNotifier serviceEventNotifier) {
        this.serviceEventNotifier = serviceEventNotifier;
    }

    public AGRuntime getRuntime() {
        return this.runtime;
    }

    public void setRuntime(AGRuntime runtime) {
        this.runtime = runtime;
    }

    public InternalRuntime getInternalRuntime() {
        return this.internalRuntime;
    }

    public void setInternalRuntime(InternalRuntime internalRuntime) {
        this.internalRuntime = internalRuntime;
    }

    public RuntimeAccess getRuntimeAccess() {
        return this.runtimeAccess;
    }

    public void setRuntimeAccess(RuntimeAccess runtimeAccess) {
        this.runtimeAccess = runtimeAccess;
    }
}

