/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.server;

import com.wavemaker.common.Resource;
import com.wavemaker.common.WMException;
import com.wavemaker.common.WMRuntimeException;
import com.wavemaker.json.JSONArray;
import com.wavemaker.json.JSONObject;
import com.wavemaker.json.JSONState;
import com.wavemaker.json.JSONUnmarshaller;
import com.wavemaker.json.type.TypeState;
import com.wavemaker.json.type.reflect.ReflectTypeUtils;
import com.wavemaker.runtime.server.ControllerBase;
import com.wavemaker.runtime.server.ServerUtils;
import com.wavemaker.runtime.service.ServiceWire;
import com.wavemaker.runtime.service.TypedServiceReturn;
import com.wavemaker.runtime.service.response.ErrorResponse;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.view.JsonView;

public class JSONRPCController
extends ControllerBase {
    protected final Logger logger = Logger.getLogger(((Object)((Object)this)).getClass());

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected ModelAndView executeRequest(HttpServletRequest request, HttpServletResponse response) throws IOException, WMException {
        ServiceWire sw;
        String serviceName = ServerUtils.getServiceName(request);
        ModelAndView ret = null;
        String method = null;
        JSONArray params = null;
        String input = 0 == request.getContentLength() || null == request.getInputStream() ? "" : ServerUtils.readInput(request);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Request body: '" + input + "'"));
        }
        System.out.println("REQUEST: " + serviceName + ", INPUT: " + input);
        JSONObject jsonReq = (JSONObject)JSONUnmarshaller.unmarshal((String)input, (JSONState)this.getInternalRuntime().getJSONState());
        if (null == jsonReq) {
            throw new WMRuntimeException(Resource.FAILED_TO_PARSE_REQUEST, new Object[]{input});
        }
        if (!jsonReq.containsKey((Object)"method") || !jsonReq.containsKey((Object)"id")) {
            throw new WMRuntimeException(Resource.SERVER_NOMETHODORID, new Object[]{input});
        }
        method = (String)jsonReq.get((Object)"method");
        this.logger.debug((Object)("MICHAEL: invoke service: " + serviceName + ", method: " + method));
        params = null;
        if (jsonReq.containsKey((Object)"params")) {
            Object rawParams = jsonReq.get((Object)"params");
            if (rawParams instanceof JSONArray) {
                params = (JSONArray)rawParams;
            } else if (null == rawParams) {
                params = new JSONArray();
            } else {
                if (!(rawParams instanceof JSONObject)) throw new WMRuntimeException(Resource.JSONRPC_CONTROLLER_BAD_PARAMS_UNKNOWN_TYPE, new Object[]{rawParams.getClass(), jsonReq});
                JSONObject tjo = (JSONObject)rawParams;
                if (!tjo.isEmpty()) throw new WMRuntimeException(Resource.JSONRPC_CONTROLLER_BAD_PARAMS_NON_EMPTY, new Object[]{tjo, jsonReq});
                params = new JSONArray();
            }
        } else {
            params = new JSONArray();
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("invoke service: " + serviceName + ", method: " + method));
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("method " + method + " parameters: " + params));
            }
        }
        if (null == (sw = this.getServiceManager().getServiceWire(serviceName))) {
            throw new WMRuntimeException(Resource.NO_SERVICEWIRE, new Object[]{serviceName});
        }
        TypedServiceReturn reflInvokeRef = this.invokeMethod(sw, method, params, null);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("method " + method + " result: " + reflInvokeRef));
        }
        JsonView jv = this.getView();
        return this.getModelAndView(jv, reflInvokeRef);
    }

    protected JsonView getView() {
        JsonView ret = new JsonView();
        ret.setJsonConfig(this.getInternalRuntime().getJSONState());
        return ret;
    }

    protected ModelAndView handleError(final String message, Throwable t) {
        JsonView view = this.getView();
        ErrorResponse er = new ErrorResponse(){

            public String getError() {
                return message;
            }
        };
        TypedServiceReturn tsr = new TypedServiceReturn();
        tsr.setReturnValue(er);
        tsr.setReturnType(ReflectTypeUtils.getFieldDefinition(er.getClass(), (TypeState)this.getInternalRuntime().getJSONState().getTypeState(), (boolean)false, null));
        return this.getModelAndView(view, tsr);
    }
}

