/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.server.json;

import com.wavemaker.common.Resource;
import com.wavemaker.common.WMRuntimeException;
import com.wavemaker.json.AlternateJSONTransformer;
import com.wavemaker.json.JSONArray;
import com.wavemaker.json.JSONObject;
import com.wavemaker.json.JSONState;
import com.wavemaker.json.type.FieldDefinition;
import com.wavemaker.json.type.TypeState;
import com.wavemaker.json.type.reflect.ReflectTypeUtils;
import com.wavemaker.runtime.server.JSONParameterTypeField;
import com.wavemaker.runtime.service.ParsedServiceArguments;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONUtils {
    private static final Log logger = LogFactory.getLog(JSONUtils.class);

    private JSONUtils() {
        throw new UnsupportedOperationException();
    }

    public static ParsedServiceArguments convertJSONToObjects(JSONArray params, Method method, JSONState jsonState) {
        return JSONUtils.convertJSONToObjects(params, JSONUtils.getParameterTypes(method, params, jsonState.getTypeState()), jsonState);
    }

    public static ParsedServiceArguments convertJSONToObjects(JSONArray params, List<FieldDefinition> fieldDefinitions, JSONState jsonState) {
        Object[] objects = new Object[fieldDefinitions.size()];
        ArrayList<List<String>> deserializedProps = new ArrayList<List<String>>(fieldDefinitions.size());
        for (int i = 0; i < fieldDefinitions.size(); ++i) {
            Object elem = params.get(i);
            FieldDefinition fieldDefinition = fieldDefinitions.get(i);
            objects[i] = AlternateJSONTransformer.toObject((JSONState)jsonState, (Object)elem, (FieldDefinition)fieldDefinition);
            deserializedProps.add(i, jsonState.getSettersCalled());
            jsonState.setSettersCalled(new ArrayList());
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Deserialized properties " + deserializedProps));
        }
        ParsedServiceArguments psa = new ParsedServiceArguments();
        psa.setArguments(objects);
        psa.setGettersCalled(deserializedProps);
        return psa;
    }

    public static List<FieldDefinition> getParameterTypes(Method m, JSONArray params, TypeState typeState) {
        ArrayList<FieldDefinition> fieldDefinitions = new ArrayList<FieldDefinition>();
        for (Type type : m.getGenericParameterTypes()) {
            fieldDefinitions.add(ReflectTypeUtils.getFieldDefinition((Type)type, (TypeState)typeState, (boolean)false, null));
        }
        Annotation[][] paramAnnotations = m.getParameterAnnotations();
        for (int i = 0; i < paramAnnotations.length; ++i) {
            for (Annotation ann : paramAnnotations[i]) {
                if (!(ann instanceof JSONParameterTypeField)) continue;
                JSONParameterTypeField paramTypeField = (JSONParameterTypeField)ann;
                int pos = paramTypeField.typeParameter();
                String typeString = (String)params.get(pos);
                try {
                    Class newType = ClassUtils.forName((String)typeString);
                    if (Collection.class.isAssignableFrom(newType)) {
                        throw new WMRuntimeException(Resource.JSONUTILS_PARAMTYPEGENERIC, new Object[]{i, m.getName()});
                    }
                    fieldDefinitions.set(i, ReflectTypeUtils.getFieldDefinition((Type)newType, (TypeState)typeState, (boolean)false, null));
                }
                catch (ClassNotFoundException e) {
                    throw new WMRuntimeException(Resource.JSONPARAMETER_COULD_NOTLLOAD_TYPE, (Throwable)e, new Object[]{typeString, m.getName(), i});
                }
                catch (LinkageError e) {
                    throw new WMRuntimeException((Throwable)e);
                }
            }
        }
        return fieldDefinitions;
    }

    public static Object toBean(JSONObject jo, Class<?> klass) {
        return AlternateJSONTransformer.toObject((JSONObject)jo, klass);
    }

    public static Object toBean(Object jo, Class<?> klass) {
        return AlternateJSONTransformer.toObject((JSONState)new JSONState(), (Object)jo, klass);
    }

    public static Object toBean(Object jo, FieldDefinition fieldDefinition, JSONState jsonState) {
        return AlternateJSONTransformer.toObject((JSONState)jsonState, (Object)jo, (FieldDefinition)fieldDefinition);
    }
}

