/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.server.json.converters;

import com.wavemaker.common.Resource;
import com.wavemaker.common.WMRuntimeException;
import com.wavemaker.json.JSONArray;
import com.wavemaker.json.JSONMarshaller;
import com.wavemaker.json.type.converters.ReadObjectConverter;
import com.wavemaker.json.type.converters.WriteObjectConverter;
import com.wavemaker.json.type.reflect.PrimitiveReflectTypeDefinition;
import com.wavemaker.json.type.reflect.ReflectTypeUtils;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Type;
import java.sql.Blob;
import java.sql.SQLException;
import org.apache.commons.io.IOUtils;
import org.hibernate.lob.BlobImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlobTypeDefinition
extends PrimitiveReflectTypeDefinition
implements ReadObjectConverter,
WriteObjectConverter {
    public BlobTypeDefinition(Class<? extends Blob> klass) {
        this.setKlass(klass);
        this.setTypeName(ReflectTypeUtils.getTypeName((Type)this.getKlass()));
    }

    public Object readObject(Object input, Object root, String path) {
        if (null == input) {
            return null;
        }
        if (JSONArray.class.isAssignableFrom(input.getClass())) {
            JSONArray jarr = (JSONArray)input;
            byte[] barr = new byte[jarr.size()];
            for (int i = 0; i < barr.length; ++i) {
                if (!Number.class.isAssignableFrom(jarr.get(i).getClass())) {
                    throw new WMRuntimeException("expected number, not: " + jarr.get(i) + " (class: " + jarr.get(i).getClass() + ")");
                }
                barr[i] = ((Number)jarr.get(i)).byteValue();
            }
            return new BlobImpl(barr);
        }
        return input;
    }

    public void writeObject(Object input, Object root, String path, Writer writer) throws IOException {
        if (null == input) {
            JSONMarshaller.marshal((Writer)writer, (Object)input);
        } else if (input instanceof Blob) {
            try {
                byte[] bytes = IOUtils.toByteArray(((Blob)input).getBinaryStream());
                JSONMarshaller.marshal((Writer)writer, (Object)bytes);
            }
            catch (SQLException e) {
                throw new WMRuntimeException((Throwable)e);
            }
        } else {
            throw new WMRuntimeException(Resource.JSON_UNHANDLED_TYPE, new Object[]{input, input.getClass()});
        }
    }
}

