/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.server.json.converters;

import com.wavemaker.common.Resource;
import com.wavemaker.common.WMRuntimeException;
import com.wavemaker.json.JSONMarshaller;
import com.wavemaker.json.type.converters.ReadObjectConverter;
import com.wavemaker.json.type.converters.WriteObjectConverter;
import com.wavemaker.json.type.reflect.PrimitiveReflectTypeDefinition;
import com.wavemaker.json.type.reflect.ReflectTypeUtils;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Type;
import java.sql.Clob;
import java.sql.SQLException;
import org.apache.commons.io.IOUtils;
import org.hibernate.lob.ClobImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClobTypeDefinition
extends PrimitiveReflectTypeDefinition
implements ReadObjectConverter,
WriteObjectConverter {
    public ClobTypeDefinition(Class<? extends Clob> klass) {
        this.setKlass(klass);
        this.setTypeName(ReflectTypeUtils.getTypeName((Type)this.getKlass()));
    }

    public Object readObject(Object input, Object root, String path) {
        if (null == input) {
            return null;
        }
        if (String.class.isAssignableFrom(input.getClass())) {
            return new ClobImpl((String)input);
        }
        return input;
    }

    public void writeObject(Object input, Object root, String path, Writer writer) throws IOException {
        if (null == input) {
            JSONMarshaller.marshal((Writer)writer, (Object)input);
        } else if (input instanceof Clob) {
            try {
                String str = IOUtils.toString(((Clob)input).getCharacterStream());
                JSONMarshaller.marshal((Writer)writer, (Object)str);
            }
            catch (SQLException e) {
                throw new WMRuntimeException((Throwable)e);
            }
        } else {
            throw new WMRuntimeException(Resource.JSON_UNHANDLED_TYPE, new Object[]{input, input.getClass()});
        }
    }
}

