/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.service;

import com.wavemaker.runtime.service.OrderBy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PagingOptions {
    private Long maxResults = null;
    private Long firstResult = Long.valueOf("0");
    private List<OrderBy> orderbys = new ArrayList<OrderBy>();

    public PagingOptions() {
    }

    public PagingOptions(PagingOptions po) {
        this(po.getMaxResults(), po.getFirstResult());
        this.orderbys = po.getOrderByList();
    }

    public PagingOptions(Long limit) {
        this.setMaxResults(limit);
    }

    public PagingOptions(Long limit, Long offset) {
        this(limit);
        this.setFirstResult(offset);
    }

    public void setFirstResult(Long offset) {
        this.firstResult = offset;
    }

    public void setMaxResults(Long limit) {
        this.maxResults = limit;
    }

    public Long getMaxResults() {
        return this.maxResults;
    }

    public Long getFirstResult() {
        return this.firstResult;
    }

    public void addAscOrder(String propertyPath) {
        OrderBy o = new OrderBy();
        o.setAsc(propertyPath);
        this.orderbys.add(o);
    }

    public void addDescOrder(String propertyPath) {
        OrderBy o = new OrderBy();
        o.setDesc(propertyPath);
        this.orderbys.add(o);
    }

    public void setOrderBy(List<String> orderByStrings) {
        if (orderByStrings == null) {
            throw new IllegalArgumentException("orderbys cannot be null");
        }
        for (String s : orderByStrings) {
            this.orderbys.add(OrderBy.newInstance(s));
        }
    }

    public List<String> getOrderBy() {
        ArrayList<String> rtn = new ArrayList<String>(this.orderbys.size());
        for (OrderBy o : this.orderbys) {
            rtn.add(o.toString());
        }
        return Collections.unmodifiableList(rtn);
    }

    public List<OrderBy> getOrderByList() {
        return this.orderbys;
    }

    public void nextPage() {
        if (this.maxResults != null) {
            this.firstResult = this.firstResult + this.maxResults;
        }
    }
}

