/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.service.reflect;

import com.wavemaker.common.Resource;
import com.wavemaker.common.WMRuntimeException;
import com.wavemaker.json.JSONArray;
import com.wavemaker.json.JSONState;
import com.wavemaker.json.type.TypeState;
import com.wavemaker.json.type.reflect.ReflectTypeUtils;
import com.wavemaker.runtime.RuntimeAccess;
import com.wavemaker.runtime.server.InternalRuntime;
import com.wavemaker.runtime.server.ServerUtils;
import com.wavemaker.runtime.server.json.JSONUtils;
import com.wavemaker.runtime.service.ParsedServiceArguments;
import com.wavemaker.runtime.service.ServiceType;
import com.wavemaker.runtime.service.ServiceWire;
import com.wavemaker.runtime.service.TypedServiceReturn;
import com.wavemaker.runtime.service.reflect.ReflectParsedServiceArguments;
import com.wavemaker.runtime.service.reflect.ReflectServiceWire;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ReflectServiceType
implements ServiceType {
    @Override
    public ParsedServiceArguments parseServiceArgs(ServiceWire serviceWire, String methodName, JSONArray args, JSONState jsonState) {
        if (!(serviceWire instanceof ReflectServiceWire)) {
            throw new WMRuntimeException(Resource.EXPECTED_REFLECT_SW, new Object[]{serviceWire});
        }
        ReflectServiceWire rsw = (ReflectServiceWire)serviceWire;
        Object serviceObject = rsw.getServiceBean();
        Method method = ReflectServiceType.findMethod(methodName, serviceObject, args.size());
        ParsedServiceArguments psa = JSONUtils.convertJSONToObjects(args, method, jsonState);
        ReflectParsedServiceArguments rpsa = new ReflectParsedServiceArguments(psa);
        rpsa.setMethod(method);
        rpsa.setServiceObject(serviceObject);
        return rpsa;
    }

    @Override
    public ParsedServiceArguments parseServiceArgs(ServiceWire serviceWire, String methodName, Map<String, Object[]> args, JSONState jsonState) {
        if (!(serviceWire instanceof ReflectServiceWire)) {
            throw new WMRuntimeException(Resource.EXPECTED_REFLECT_SW, new Object[]{serviceWire});
        }
        ReflectServiceWire rsw = (ReflectServiceWire)serviceWire;
        Object serviceObject = rsw.getServiceBean();
        Method method = ReflectServiceType.findMethod(methodName, serviceObject, args.size());
        Object[] translatedArgs = ReflectServiceType.paramsFromAnnotatedMethod(method, args);
        ReflectParsedServiceArguments rpsa = new ReflectParsedServiceArguments();
        rpsa.setArguments(translatedArgs);
        rpsa.setMethod(method);
        rpsa.setServiceObject(serviceObject);
        return rpsa;
    }

    @Override
    public void setup(ServiceWire serviceWire, InternalRuntime internalRuntime, RuntimeAccess runtimeAccess) {
    }

    @Override
    public TypedServiceReturn invokeMethod(ServiceWire serviceWire, String methodName, ParsedServiceArguments args, JSONState jsonState) {
        Method method;
        Object serviceObject;
        if (!(args instanceof ReflectParsedServiceArguments)) {
            if (!(serviceWire instanceof ReflectServiceWire)) {
                throw new WMRuntimeException(Resource.EXPECTED_REFLECT_SW, new Object[]{serviceWire});
            }
            ReflectServiceWire rsw = (ReflectServiceWire)serviceWire;
            serviceObject = rsw.getServiceBean();
            method = ReflectServiceType.findMethod(methodName, serviceObject, args.getArguments().length);
        } else {
            ReflectParsedServiceArguments rpsa = (ReflectParsedServiceArguments)args;
            method = rpsa.getMethod();
            serviceObject = rpsa.getServiceObject();
        }
        Object ret = null;
        try {
            ret = method.invoke(serviceObject, args.getArguments());
        }
        catch (Exception e) {
            if (null != e.getCause()) {
                throw new WMRuntimeException(Resource.JSONUTILS_FAILEDINVOKE, e.getCause(), new Object[]{method.getName(), method.getDeclaringClass()});
            }
            throw new WMRuntimeException(Resource.JSONUTILS_FAILEDINVOKE, (Throwable)e, new Object[]{method.getName(), method.getDeclaringClass()});
        }
        if (ret instanceof TypedServiceReturn) {
            return (TypedServiceReturn)ret;
        }
        TypedServiceReturn tsr = new TypedServiceReturn(ret, ReflectTypeUtils.getFieldDefinition((Method)method, (TypeState)jsonState.getTypeState(), (boolean)false, null));
        return tsr;
    }

    public static Method findMethod(String method, Object s, int paramsLength) {
        List<Method> methods = ServerUtils.getClientExposedMethods(ServerUtils.getRealClass(s));
        Method meth = null;
        for (Method m : methods) {
            if (!m.getName().equals(method) || m.getParameterTypes().length != paramsLength) continue;
            if (null != meth) {
                throw new WMRuntimeException(Resource.JSONUTILS_BADMETHODOVERLOAD, new Object[]{method, s.getClass()});
            }
            meth = m;
        }
        if (null == meth) {
            throw new WMRuntimeException(Resource.JSONRPC_CONTROLLER_METHOD_NOT_FOUND, new Object[]{method, paramsLength, s.getClass()});
        }
        return meth;
    }

    public static Object[] paramsFromAnnotatedMethod(Method method, Map<String, Object[]> params) {
        int i;
        Class<?>[] paramTypes = method.getParameterTypes();
        Object[] ret = new Object[paramTypes.length];
        List<String> paramNames = ServerUtils.getParameterNames(method);
        for (i = 0; i < paramNames.size(); ++i) {
            ret[i] = params.get(paramNames.get(i));
        }
        for (i = 0; i < paramTypes.length; ++i) {
            if (!(ret[i] instanceof Object[]) || 1 != ((Object[])ret[i]).length || paramTypes[i].isAssignableFrom(Object[].class)) continue;
            ret[i] = ((Object[])ret[i])[0];
        }
        return ret;
    }
}

