/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.ws;

import com.sun.xml.ws.encoding.xml.XMLMessage;
import com.wavemaker.runtime.ws.BindingProperties;
import com.wavemaker.runtime.ws.WebServiceException;
import com.wavemaker.runtime.ws.WebServiceInvocationException;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.activation.DataSource;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.ws.Dispatch;
import javax.xml.ws.Service;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTTPBindingSupport {
    private static Log logger = LogFactory.getLog(HTTPBindingSupport.class);

    public static <T> T getResponseObject(QName serviceQName, QName portQName, String endpointAddress, HTTPRequestMethod method, String contentType, Object postData, Class<T> responseType, BindingProperties bindingProperties) throws WebServiceException {
        String msg = postData == null ? null : (postData instanceof String ? (String)postData : HTTPBindingSupport.convertToXMLString(postData));
        DataSource postSource = null;
        if (method == HTTPRequestMethod.POST) {
            postSource = HTTPBindingSupport.createDataSource(contentType, msg);
        }
        DataSource response = HTTPBindingSupport.getResponse(serviceQName, portQName, endpointAddress, method, postSource, bindingProperties, DataSource.class);
        try {
            InputStream inputStream = response.getInputStream();
            if (responseType == Void.class) {
                return null;
            }
            if (responseType == String.class) {
                String responseString = HTTPBindingSupport.convertStreamToString(inputStream);
                return responseType.cast(responseString);
            }
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{responseType});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            Object object = unmarshaller.unmarshal(inputStream);
            return responseType.cast(object);
        }
        catch (IOException e) {
            throw new WebServiceException(e);
        }
        catch (JAXBException e) {
            throw new WebServiceException(e);
        }
    }

    public static String convertToXMLString(Object o) {
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{o.getClass()});
            Marshaller marshaller = context.createMarshaller();
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            marshaller.marshal(o, (OutputStream)os);
            return new String(os.toByteArray());
        }
        catch (JAXBException e) {
            throw new WebServiceInvocationException(e);
        }
    }

    public static DataSource createDataSource(String contentType, String msg) throws WebServiceException {
        ByteArrayInputStream is = null;
        if (msg != null) {
            try {
                StringBuffer sb = new StringBuffer(msg);
                is = new ByteArrayInputStream(sb.toString().getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new WebServiceException(e);
            }
        }
        return XMLMessage.createDataSource((String)contentType, is);
    }

    private static <T> T getResponse(QName serviceQName, QName portQName, String endpointAddress, HTTPRequestMethod method, T postSource, BindingProperties bindingProperties, Class<T> type) throws WebServiceException {
        URI endpointURI;
        Service service = Service.create((QName)serviceQName);
        try {
            String endAddress;
            if (bindingProperties != null && (endAddress = bindingProperties.getEndpointAddress()) != null) {
                endpointAddress = endAddress;
            }
            endpointURI = new URI(endpointAddress);
        }
        catch (URISyntaxException e) {
            throw new WebServiceException(e);
        }
        String endpointPath = null;
        String endpointQueryString = null;
        if (endpointURI != null) {
            endpointPath = endpointURI.getRawPath();
            endpointQueryString = endpointURI.getRawQuery();
        }
        service.addPort(portQName, "http://www.w3.org/2004/08/wsdl/http", endpointAddress);
        Dispatch d = service.createDispatch(portQName, type, Service.Mode.MESSAGE);
        Map requestContext = d.getRequestContext();
        requestContext.put("javax.xml.ws.http.request.method", method.toString());
        requestContext.put("javax.xml.ws.http.request.querystring", endpointQueryString);
        requestContext.put("javax.xml.ws.http.request.pathinfo", endpointPath);
        if (bindingProperties != null) {
            String httpBasicAuthUsername = bindingProperties.getHttpBasicAuthUsername();
            if (httpBasicAuthUsername != null) {
                requestContext.put("javax.xml.ws.security.auth.username", httpBasicAuthUsername);
                String httpBasicAuthPassword = bindingProperties.getHttpBasicAuthPassword();
                requestContext.put("javax.xml.ws.security.auth.password", httpBasicAuthPassword);
            }
            int connectionTimeout = bindingProperties.getConnectionTimeout();
            requestContext.put("com.sun.xml.ws.connect.timeout", connectionTimeout);
            int requestTimeout = bindingProperties.getRequestTimeout();
            requestContext.put("com.sun.xml.ws.request.timeout", requestTimeout);
            Map<String, List<String>> httpHeaders = bindingProperties.getHttpHeaders();
            if (httpHeaders != null && !httpHeaders.isEmpty()) {
                HashMap<String, List<String>> reqHeaders = (HashMap<String, List<String>>)requestContext.get("javax.xml.ws.http.request.headers");
                if (reqHeaders == null) {
                    reqHeaders = new HashMap<String, List<String>>();
                    requestContext.put("javax.xml.ws.http.request.headers", reqHeaders);
                }
                for (Map.Entry<String, List<String>> entry : httpHeaders.entrySet()) {
                    reqHeaders.put(entry.getKey(), entry.getValue());
                }
            }
        }
        logger.info((Object)("Invoking HTTP '" + (Object)((Object)method) + "' request with URL: " + endpointAddress));
        Object result = d.invoke(postSource);
        return (T)result;
    }

    public static String getResponseString(QName serviceQName, QName portQName, String endpointAddress, HTTPRequestMethod method, DataSource postSource, BindingProperties bindingProperties) throws WebServiceException {
        DataSource response = HTTPBindingSupport.getResponse(serviceQName, portQName, endpointAddress, method, postSource, bindingProperties, DataSource.class);
        try {
            InputStream inputStream = response.getInputStream();
            return HTTPBindingSupport.convertStreamToString(inputStream);
        }
        catch (IOException e) {
            throw new WebServiceException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String convertStreamToString(InputStream is) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        StringBuilder sb = new StringBuilder();
        String line = null;
        try {
            while ((line = reader.readLine()) != null) {
                sb.append(line + "\n");
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            is.close();
            throw throwable;
        }
        is.close();
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum HTTPRequestMethod {
        GET,
        POST,
        PUT,
        DELETE;

    }
}

