/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.actions;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.lib.profiler.TargetAppRunner;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.global.Platform;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.ProfilerControlPanel2;
import org.netbeans.modules.profiler.ProfilerIDESettings;
import org.netbeans.modules.profiler.actions.ProfilingAwareAction;
import org.netbeans.modules.profiler.heapwalk.HeapWalkerManager;
import org.netbeans.modules.profiler.ui.ProfilerDialogs;
import org.netbeans.modules.profiler.utils.IDEUtils;
import org.openide.DialogDescriptor;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public final class HeapDumpAction
extends ProfilingAwareAction {
    private static final String ACTION_NAME = NbBundle.getMessage(HeapDumpAction.class, (String)"HeapDumpAction_ActionName");
    private static final String REQUIRED_JDK_MSG = NbBundle.getMessage(HeapDumpAction.class, (String)"HeapDumpAction_RequiredJdkMsg");
    private static final String REMOTE_UNSUPPORTED_MSG = NbBundle.getMessage(HeapDumpAction.class, (String)"HeapDumpAction_RemoteUnsupportedMsg");
    private static final String WRONG_DESTINATION_MSG = NbBundle.getMessage(HeapDumpAction.class, (String)"HeapDumpAction_WrongDestinationMsg");
    private static final String DUMPING_HEAP_TEXT = NbBundle.getMessage(HeapDumpAction.class, (String)"HeapDumpAction_DumpingHeapText");
    private static final String SAVED_DIALOG_CAPTION = NbBundle.getMessage(HeapDumpAction.class, (String)"HeapDumpAction_SavedDialogCaption");
    private static final String SAVED_DIALOG_TEXT = NbBundle.getMessage(HeapDumpAction.class, (String)"HeapDumpAction_SavedDialogText");
    private static final String DUMPING_FAILED_MSG = NbBundle.getMessage(HeapDumpAction.class, (String)"HeapDumpAction_DumpingFailedMsg");
    private static final String DESTINATION_DIALOG_CAPTION = NbBundle.getMessage(HeapDumpAction.class, (String)"HeapDumpAction_DestinationDialogCaption");
    private static final String LOCATION_PROJECT_STRING = NbBundle.getMessage(HeapDumpAction.class, (String)"HeapDumpAction_LocationProjectString");
    private static final String LOCATION_GLOBAL_STRING = NbBundle.getMessage(HeapDumpAction.class, (String)"HeapDumpAction_LocationGlobalString");
    private static final String DIRECTORY_DIALOG_CAPTION = NbBundle.getMessage(HeapDumpAction.class, (String)"HeapDumpAction_DirectoryDialogCaption");
    private static final String OK_BUTTON_TEXT = NbBundle.getMessage(HeapDumpAction.class, (String)"HeapDumpAction_OkButtonText");
    private static final String DESTINATION_LABEL_TEXT = NbBundle.getMessage(HeapDumpAction.class, (String)"HeapDumpAction_DestinationLabelText");
    private static final String DEFAULT_LOCATION_RADIO_TEXT = NbBundle.getMessage(HeapDumpAction.class, (String)"HeapDumpAction_DefaultLocationRadioText");
    private static final String CUSTOM_LOCATION_RADIO_TEXT = NbBundle.getMessage(HeapDumpAction.class, (String)"HeapDumpAction_CustomLocationRadioText");
    private static final String BROWSE_BUTTON_TEXT = NbBundle.getMessage(HeapDumpAction.class, (String)"HeapDumpAction_BrowseButtonText");
    public static final String TAKEN_HEAPDUMP_PREFIX = "heapdump-";
    private static final String SELECTING_TARGET_CANCELLED = "&*$?CANCELLED?$*&";
    private static final int[] ENABLED_STATES = new int[]{4};
    private static JFileChooser snapshotDirectoryChooser;
    private ChooseHeapdumpTargetPanel heapdumpTargetSelector;

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public String getName() {
        return ACTION_NAME;
    }

    public void dumpToProject() {
        this.takeHeapDump(false);
    }

    public void performAction() {
        this.takeHeapDump(true);
    }

    protected int[] enabledStates() {
        return ENABLED_STATES;
    }

    protected String iconResource() {
        return "org/netbeans/modules/profiler/actions/resources/dumpHeap.png";
    }

    private String getCurrentHeapDumpFilename(String string) {
        try {
            String string2 = TAKEN_HEAPDUMP_PREFIX + System.currentTimeMillis();
            FileObject fileObject = string == null ? IDEUtils.getProjectSettingsFolder(true) : FileUtil.toFileObject((File)FileUtil.normalizeFile((File)new File(string)));
            return FileUtil.toFile((FileObject)fileObject).getAbsolutePath() + File.separator + FileUtil.findFreeFileName((FileObject)fileObject, (String)string2, (String)"hprof") + "." + "hprof";
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private boolean isHeapDumpSupported() {
        String string;
        int n;
        TargetAppRunner targetAppRunner = Profiler.getDefault().getTargetAppRunner();
        String string2 = targetAppRunner.getProfilerEngineSettings().getTargetJDKVersionString();
        if ("jdk16".equals(string2) || "jdk17".equals(string2)) {
            return true;
        }
        return "jdk15".equals(string2) && (n = Platform.getJDKMinorNumber((String)(string = targetAppRunner.getProfilingSessionStatus().fullTargetJDKVersionString))) >= 12;
    }

    private static JFileChooser getSnapshotDirectoryChooser() {
        if (snapshotDirectoryChooser == null) {
            snapshotDirectoryChooser = new JFileChooser();
            snapshotDirectoryChooser.setFileSelectionMode(1);
            snapshotDirectoryChooser.setMultiSelectionEnabled(false);
            snapshotDirectoryChooser.setDialogType(0);
            snapshotDirectoryChooser.setDialogTitle(DIRECTORY_DIALOG_CAPTION);
        }
        return snapshotDirectoryChooser;
    }

    private ChooseHeapdumpTargetPanel getHeapdumpTargetSelector() {
        if (this.heapdumpTargetSelector == null) {
            this.heapdumpTargetSelector = new ChooseHeapdumpTargetPanel();
        }
        return this.heapdumpTargetSelector;
    }

    private String selectTargetDirectory() {
        ChooseHeapdumpTargetPanel chooseHeapdumpTargetPanel = this.getHeapdumpTargetSelector();
        chooseHeapdumpTargetPanel.updateDefaultLocation(LOCATION_GLOBAL_STRING);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)chooseHeapdumpTargetPanel, DESTINATION_DIALOG_CAPTION, true, new Object[]{chooseHeapdumpTargetPanel.getOKButton(), DialogDescriptor.CANCEL_OPTION}, DialogDescriptor.OK_OPTION, 0, null, null);
        Object object = ProfilerDialogs.notify((NotifyDescriptor)dialogDescriptor);
        if (!object.equals(chooseHeapdumpTargetPanel.getOKButton())) {
            return SELECTING_TARGET_CANCELLED;
        }
        int n = chooseHeapdumpTargetPanel.getDestinationType();
        if (n == 0) {
            return this.getCurrentHeapDumpFilename(null);
        }
        if (n == 1) {
            return this.getCurrentHeapDumpFilename(chooseHeapdumpTargetPanel.getCustomDirectory());
        }
        return null;
    }

    private void takeHeapDump(final boolean bl) {
        IDEUtils.runInProfilerRequestProcessor(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                NetBeansProfiler netBeansProfiler = NetBeansProfiler.getDefaultNB();
                TargetAppRunner targetAppRunner = netBeansProfiler.getTargetAppRunner();
                if (!targetAppRunner.hasSupportedJDKForHeapDump()) {
                    netBeansProfiler.displayWarning(REQUIRED_JDK_MSG);
                    return;
                }
                if (targetAppRunner.getProfilingSessionStatus().remoteProfiling) {
                    netBeansProfiler.displayWarning(REMOTE_UNSUPPORTED_MSG);
                    return;
                }
                try {
                    String string;
                    String string2 = string = bl ? HeapDumpAction.this.selectTargetDirectory() : HeapDumpAction.this.getCurrentHeapDumpFilename(null);
                    if (string == HeapDumpAction.SELECTING_TARGET_CANCELLED) {
                        return;
                    }
                    if (string == null) {
                        netBeansProfiler.displayError(WRONG_DESTINATION_MSG);
                        return;
                    }
                    boolean bl2 = false;
                    ProgressHandle progressHandle = null;
                    try {
                        progressHandle = ProgressHandleFactory.createHandle((String)DUMPING_HEAP_TEXT);
                        progressHandle.setInitialDelay(0);
                        progressHandle.start();
                        bl2 = targetAppRunner.getProfilerClient().takeHeapDump(string);
                    }
                    finally {
                        if (progressHandle != null) {
                            progressHandle.finish();
                        }
                    }
                    if (bl2) {
                        ProfilerControlPanel2.getDefault().refreshSnapshotsList();
                        if (bl) {
                            ProfilerDialogs.DNSAConfirmation dNSAConfirmation = new ProfilerDialogs.DNSAConfirmation("HeapDumpAction.heapdumpSaved", (Object)SAVED_DIALOG_TEXT, SAVED_DIALOG_CAPTION, 0);
                            dNSAConfirmation.setDNSADefault(false);
                            if (ProfilerDialogs.notify((NotifyDescriptor)dNSAConfirmation).equals(ProfilerDialogs.DNSAConfirmation.YES_OPTION)) {
                                HeapWalkerManager.getDefault().openHeapWalker(new File(string));
                            }
                        } else if (ProfilerIDESettings.getInstance().getAutoOpenSnapshot()) {
                            HeapWalkerManager.getDefault().openHeapWalker(new File(string));
                        }
                    } else {
                        netBeansProfiler.displayError(DUMPING_FAILED_MSG);
                    }
                }
                catch (Exception exception) {
                    netBeansProfiler.displayError(exception.getMessage());
                    ProfilerLogger.log((Exception)exception);
                }
            }
        });
    }

    private class ChooseHeapdumpTargetPanel
    extends JPanel {
        public static final int DESTINATION_DEFAULT = 0;
        public static final int DESTINATION_CUSTOM = 1;
        private JButton customLocationButton;
        private JButton okButton;
        private JLabel chooseDestinationLabel;
        private JRadioButton customLocationRadio;
        private JRadioButton defaultLocationRadio;
        private JTextField customLocationField;

        public ChooseHeapdumpTargetPanel() {
            this.initComponents();
        }

        public String getCustomDirectory() {
            return this.customLocationField.getText();
        }

        public int getDestinationType() {
            if (this.defaultLocationRadio.isSelected()) {
                return 0;
            }
            return 1;
        }

        public JButton getOKButton() {
            return this.okButton;
        }

        public void updateDefaultLocation(String string) {
            this.defaultLocationRadio.setText(string);
        }

        private void initComponents() {
            this.okButton = new JButton(OK_BUTTON_TEXT);
            this.setLayout(new GridBagLayout());
            ButtonGroup buttonGroup = new ButtonGroup();
            this.chooseDestinationLabel = new JLabel(DESTINATION_LABEL_TEXT);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(15, 10, 8, 5);
            this.add((Component)this.chooseDestinationLabel, gridBagConstraints);
            this.defaultLocationRadio = new JRadioButton(DEFAULT_LOCATION_RADIO_TEXT);
            buttonGroup.add(this.defaultLocationRadio);
            this.defaultLocationRadio.setSelected(true);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(0, 15, 0, 5);
            this.add((Component)this.defaultLocationRadio, gridBagConstraints);
            this.customLocationRadio = new JRadioButton(CUSTOM_LOCATION_RADIO_TEXT);
            buttonGroup.add(this.customLocationRadio);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(0, 15, 0, 5);
            this.add((Component)this.customLocationRadio, gridBagConstraints);
            String string = System.getProperty("java.io.tmpdir");
            if (string.endsWith(File.separator)) {
                string = string.substring(0, string.length() - File.separator.length());
            }
            this.customLocationField = new JTextField();
            this.customLocationField.setText(string);
            this.customLocationField.setPreferredSize(new Dimension(210, this.customLocationField.getPreferredSize().height));
            this.customLocationField.setEnabled(false);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(0, 15 + new JRadioButton((String)"").getPreferredSize().width, 5, 5);
            this.add((Component)this.customLocationField, gridBagConstraints);
            this.customLocationButton = new JButton(BROWSE_BUTTON_TEXT);
            this.customLocationButton.setEnabled(false);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(0, 5, 5, 10);
            this.add((Component)this.customLocationButton, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 4;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 1;
            this.add((Component)new JPanel(new FlowLayout(0, 0, 3)), gridBagConstraints);
            DocumentListener documentListener = new DocumentListener(){

                public void insertUpdate(DocumentEvent documentEvent) {
                    ChooseHeapdumpTargetPanel.this.updateOKButton();
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    ChooseHeapdumpTargetPanel.this.updateOKButton();
                }

                public void changedUpdate(DocumentEvent documentEvent) {
                    ChooseHeapdumpTargetPanel.this.updateOKButton();
                }
            };
            this.customLocationField.getDocument().addDocumentListener(documentListener);
            this.defaultLocationRadio.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    ChooseHeapdumpTargetPanel.this.updateOKButton();
                }
            });
            this.customLocationRadio.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    ChooseHeapdumpTargetPanel.this.customLocationField.setEnabled(ChooseHeapdumpTargetPanel.this.customLocationRadio.isSelected());
                    ChooseHeapdumpTargetPanel.this.customLocationButton.setEnabled(ChooseHeapdumpTargetPanel.this.customLocationRadio.isSelected());
                    ChooseHeapdumpTargetPanel.this.updateOKButton();
                }
            });
            this.customLocationButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    File file;
                    JFileChooser jFileChooser = HeapDumpAction.getSnapshotDirectoryChooser();
                    jFileChooser.setCurrentDirectory(new File(ChooseHeapdumpTargetPanel.this.getCustomDirectory()));
                    if (jFileChooser.showOpenDialog(IDEUtils.getMainWindow()) == 0 && (file = jFileChooser.getSelectedFile()) != null) {
                        ChooseHeapdumpTargetPanel.this.customLocationField.setText(jFileChooser.getSelectedFile().getAbsolutePath());
                    }
                }
            });
            this.updateOKButton();
        }

        private void updateOKButton() {
            if (this.defaultLocationRadio.isSelected()) {
                this.okButton.setEnabled(true);
            } else if (this.customLocationRadio.isSelected()) {
                File file = new File(this.getCustomDirectory());
                this.okButton.setEnabled(file.exists() && file.isDirectory());
            } else {
                this.okButton.setEnabled(false);
            }
        }
    }
}

