/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.memorylint;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Histogram<T extends Entry> {
    private HashMap<String, T> map = new HashMap();

    public static final Comparator<Entry> sortByCount() {
        return new Comparator<Entry>(){

            @Override
            public int compare(Entry entry, Entry entry2) {
                return entry2.count - entry.count;
            }
        };
    }

    public static final Comparator<Entry> sortBySize() {
        return new Comparator<Entry>(){

            @Override
            public int compare(Entry entry, Entry entry2) {
                return entry2.size - entry.size;
            }
        };
    }

    public SortedMap<String, T> getResults(final Comparator<Entry> comparator) {
        TreeMap<String, T> treeMap = new TreeMap<String, T>(new Comparator<String>(){

            @Override
            public int compare(String string, String string2) {
                Entry entry;
                Entry entry2 = (Entry)Histogram.this.map.get(string);
                int n = comparator.compare(entry2, entry = (Entry)Histogram.this.map.get(string2));
                if (n == 0) {
                    n = string.compareTo(string2);
                }
                return n;
            }
        });
        treeMap.putAll(this.map);
        return treeMap;
    }

    public void add(String string, T t) {
        Entry entry = (Entry)this.map.get(string);
        if (entry != null) {
            entry.doAdd((Entry)t);
        } else {
            this.map.put(string, t);
        }
    }

    public String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        int n3 = 0;
        SortedMap<String, T> sortedMap = this.getResults(Histogram.sortBySize());
        for (Map.Entry<String, T> entry : sortedMap.entrySet()) {
            int n4 = ((Entry)entry.getValue()).getSize();
            if (n4 > n) {
                stringBuffer.append(entry.getKey()).append(": ").append(entry.getValue()).append("<br>");
            }
            n2 += n4;
            n3 += ((Entry)entry.getValue()).getCount();
        }
        stringBuffer.append(NbBundle.getMessage(Histogram.class, (String)"FMT_HistogramSum", (Object)n3, (Object)n2));
        return stringBuffer.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Entry<T extends Entry> {
        private int count = 1;
        private int size;

        public Entry(int n) {
            this.size = n;
        }

        public final int getCount() {
            return this.count;
        }

        public final int getSize() {
            return this.size;
        }

        public String toString() {
            return "#:" + this.getCount() + "/" + this.getSize() + "B\n";
        }

        protected void add(T t) {
        }

        private void doAdd(T t) {
            this.count += ((Entry)t).count;
            this.size += ((Entry)t).size;
            this.add(t);
        }
    }
}

