/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ui.panels;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.netbeans.lib.profiler.ui.components.JExtendedSpinner;
import org.netbeans.modules.profiler.ProfilerIDESettings;
import org.netbeans.modules.profiler.ui.stp.Utils;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public final class ProfilerOptionsPanel
extends JPanel
implements ActionListener {
    private static final String USE_PROJECT_JVM_TEXT = NbBundle.getMessage(ProfilerOptionsPanel.class, (String)"ProfilerOptionsPanel_UseProjectJvmText");
    private static final String KEY_OPEN_ALWAYS = NbBundle.getMessage(ProfilerOptionsPanel.class, (String)"ProfilerOptionsPanel_KeyOpenAlways");
    private static final String KEY_OPEN_MONITORING = NbBundle.getMessage(ProfilerOptionsPanel.class, (String)"ProfilerOptionsPanel_KeyOpenMonitoring");
    private static final String KEY_OPEN_NEVER = NbBundle.getMessage(ProfilerOptionsPanel.class, (String)"ProfilerOptionsPanel_KeyOpenNever");
    private static final String ENGINE_SETTINGS_BORDER_TEXT = NbBundle.getMessage(ProfilerOptionsPanel.class, (String)"ProfilerOptionsPanel_EngineSettingsBorderText");
    private static final String JAVA_PLATFORM_LABEL_TEXT = NbBundle.getMessage(ProfilerOptionsPanel.class, (String)"ProfilerOptionsPanel_JavaPlatformLabelText");
    private static final String MANAGE_PLATFORMS_BUTTON_NAME = NbBundle.getMessage(ProfilerOptionsPanel.class, (String)"ProfilerOptionsPanel_ManagePlatformsButtonName");
    private static final String COMM_PORT_LABEL_TEXT = NbBundle.getMessage(ProfilerOptionsPanel.class, (String)"ProfilerOptionsPanel_CommPortLabelText");
    private static final String WINDOWS_SETTINGS_BORDER_TEXT = NbBundle.getMessage(ProfilerOptionsPanel.class, (String)"ProfilerOptionsPanel_WindowsSettingsBorderText");
    private static final String TELEMETRY_OVERVIEW_LABEL_TEXT = NbBundle.getMessage(ProfilerOptionsPanel.class, (String)"ProfilerOptionsPanel_TelemetryOverviewLabelText");
    private static final String THREADS_VIEW_LABEL_TEXT = NbBundle.getMessage(ProfilerOptionsPanel.class, (String)"ProfilerOptionsPanel_ThreadsViewLabelText");
    private static final String THREADS_VIEW_HINT_TEXT = NbBundle.getMessage(ProfilerOptionsPanel.class, (String)"ProfilerOptionsPanel_ThreadsViewHintText");
    private static final String LIVE_RESULTS_LABEL_TEXT = NbBundle.getMessage(ProfilerOptionsPanel.class, (String)"ProfilerOptionsPanel_LiveResultsLabelText");
    private static final String CPU_CHCKBOX_TEXT = NbBundle.getMessage(ProfilerOptionsPanel.class, (String)"ProfilerOptionsPanel_CpuChckBoxText");
    private static final String MEMORY_CHCKBOX_TEXT = NbBundle.getMessage(ProfilerOptionsPanel.class, (String)"ProfilerOptionsPanel_MemoryChckBoxText");
    private static final String SNAPSHOTS_SETTINGS_BORDER_TEXT = NbBundle.getMessage(ProfilerOptionsPanel.class, (String)"ProfilerOptionsPanel_SnapshotsSettingsBorderText");
    private static final String OPEN_SNAPSHOT_RADIO_TEXT = NbBundle.getMessage(ProfilerOptionsPanel.class, (String)"ProfilerOptionsPanel_OpenSnapshotRadioText");
    private static final String SAVE_SNAPSHOT_RADIO_TEXT = NbBundle.getMessage(ProfilerOptionsPanel.class, (String)"ProfilerOptionsPanel_SaveSnapshotRadioText");
    private static final String OPEN_SAVE_SNAPSHOT_RADIO_TEXT = NbBundle.getMessage(ProfilerOptionsPanel.class, (String)"ProfilerOptionsPanel_OpenSaveSnapshotRadioText");
    private static final String RESET_HINT_TEXT = NbBundle.getMessage(ProfilerOptionsPanel.class, (String)"ProfilerOptionsPanel_ResetHintText");
    private static final String RESET_BUTTON_NAME = NbBundle.getMessage(ProfilerOptionsPanel.class, (String)"ProfilerOptionsPanel_ResetButtonName");
    private static final String PORT_NO_SPINNER_ACCESS_DESCR = NbBundle.getMessage(ProfilerOptionsPanel.class, (String)"ProfilerOptionsPanel_PortNoSpinnerAccessDescr");
    private static final String CPU_LIVE_RESULTS_CHECKBOX_ACCESS_DESCR = NbBundle.getMessage(ProfilerOptionsPanel.class, (String)"ProfilerOptionsPanel_CpuLiveResultsCheckboxAccessDescr");
    private static final String MEMORY_LIVE_RESULTS_CHECKBOX_ACCESS_DESCR = NbBundle.getMessage(ProfilerOptionsPanel.class, (String)"ProfilerOptionsPanel_MemoryLiveResultsCheckboxAccessDescr");
    private static final String TELEMETRY_OVERVIEW_COMBO_ACCESS_DESCR = NbBundle.getMessage(ProfilerOptionsPanel.class, (String)"ProfilerOptionsPanel_TelemetryOverviewComboAccessDescr");
    private static final String THREADS_VIEW_COMBO_ACCESS_DESCR = NbBundle.getMessage(ProfilerOptionsPanel.class, (String)"ProfilerOptionsPanel_ThreadsViewComboAccessDescr");
    private static final String OOME_BORDER_TEXT = NbBundle.getMessage(ProfilerOptionsPanel.class, (String)"ProfilerOptionsPanel_OomeBorderText");
    private static final String OOME_NOTHING_TEXT = NbBundle.getMessage(ProfilerOptionsPanel.class, (String)"ProfilerOptionsPanel_OomeNothingText");
    private static final String OOME_PROJECT_TEXT = NbBundle.getMessage(ProfilerOptionsPanel.class, (String)"ProfilerOptionsPanel_OomeProjectText");
    private static final String OOME_CUSTOM_TEXT = NbBundle.getMessage(ProfilerOptionsPanel.class, (String)"ProfilerOptionsPanel_OomeCustomText");
    private static final String OOME_TEMP_TEXT = NbBundle.getMessage(ProfilerOptionsPanel.class, (String)"ProfilerOptionsPanel_OomeTempText");
    private static final String OOME_CUSTOM_ACCESS_DESCR = NbBundle.getMessage(ProfilerOptionsPanel.class, (String)"ProfilerOptionsPanel_OomeCustomAccessDescr");
    private static final String OOME_CUSTOM_TEXTFIELD_ACCESS_DESCR = NbBundle.getMessage(ProfilerOptionsPanel.class, (String)"ProfilerOptionsPanel_OomeCustomTextfieldAccessDescr");
    private static final String OOME_CUSTOM_BUTTON_ACCESS_NAME = NbBundle.getMessage(ProfilerOptionsPanel.class, (String)"ProfilerOptionsPanel_OomeCustomButtonAccessName");
    private static final String CHOOSE_DUMPDIR_CAPTION = NbBundle.getMessage(ProfilerOptionsPanel.class, (String)"ProfilerOptionsPanel_ChooseDumpDirCaption");
    private static final String ENABLE_ANALYSIS_CHECKBOX = NbBundle.getMessage(ProfilerOptionsPanel.class, (String)"ProfilerOptionsPanel_EnableAnalysisCheckbox");
    private static final String TAKING_SNAPSHOT_LABEL_TEXT = NbBundle.getMessage(ProfilerOptionsPanel.class, (String)"ProfilerOptionsPanel_TakingSnapshotLabelText");
    private static final String TAKING_SNAPSHOT_COMBO_ACCESS_DESCR = NbBundle.getMessage(ProfilerOptionsPanel.class, (String)"ProfilerOptionsPanel_TakingSnapshotComboAccessDescr");
    private static final String OOME_COMBO_ACCESS_DESCR = NbBundle.getMessage(ProfilerOptionsPanel.class, (String)"ProfilerOptionsPanel_OomeComboAccessDescr");
    private static final String HEAPWALKER_LABEL_TEXT = NbBundle.getMessage(ProfilerOptionsPanel.class, (String)"ProfilerOptionsPanel_HeapWalkerLabelText");
    private static final String JAVA_PLAFORM_COMBO_ACCESS_DESCR = NbBundle.getMessage(ProfilerOptionsPanel.class, (String)"ProfilerOptionsPanel_JavaPlatformComboAccessDescr");
    private ArrayList supportedJavaPlatforms = new ArrayList();
    private ArrayList supportedJavaPlatformsNames = new ArrayList();
    private JButton managePlatformsButton;
    private JButton oomeDetectionChooseDirButton;
    private JButton resetConfirmationsButton;
    private JCheckBox cpuLiveResultsCheckbox;
    private JCheckBox enableHeapWalkerAnalysisCheckbox;
    private JCheckBox memoryLiveResultsCheckbox;
    private JComboBox javaPlatformCombo;
    private JComboBox oomeCombo;
    private JComboBox openThreadsViewCombo;
    private JComboBox takingSnapshotCombo;
    private JComboBox telemetryOverviewCombo;
    private JExtendedSpinner portNoSpinner;
    private JTextField oomeDetectionDirTextField;

    public ProfilerOptionsPanel() {
        this.initComponents();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.resetConfirmationsButton) {
            ProfilerIDESettings.getInstance().clearDoNotShowAgainMap();
            this.resetConfirmationsButton.setEnabled(false);
        } else if (actionEvent.getSource() == this.managePlatformsButton) {
            this.updateJavaPlatformComboItems();
        } else if (actionEvent.getSource() == this.oomeDetectionChooseDirButton) {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setCurrentDirectory(new File(this.oomeDetectionDirTextField.getText()));
            jFileChooser.setFileSelectionMode(1);
            jFileChooser.setMultiSelectionEnabled(false);
            jFileChooser.setDialogType(0);
            jFileChooser.setDialogTitle(CHOOSE_DUMPDIR_CAPTION);
            if (jFileChooser.showOpenDialog(SwingUtilities.getRoot(this)) == 0) {
                this.oomeDetectionDirTextField.setText(jFileChooser.getSelectedFile().getAbsolutePath());
            }
        }
    }

    public void applySettings(ProfilerIDESettings profilerIDESettings) {
        profilerIDESettings.setPortNo(((Number)this.portNoSpinner.getValue()).intValue());
        profilerIDESettings.setDisplayLiveResultsCPU(this.cpuLiveResultsCheckbox.isSelected());
        profilerIDESettings.setDisplayLiveResultsMemory(this.memoryLiveResultsCheckbox.isSelected());
        Object object = this.takingSnapshotCombo.getSelectedItem();
        profilerIDESettings.setAutoOpenSnapshot(object == OPEN_SNAPSHOT_RADIO_TEXT || object == OPEN_SAVE_SNAPSHOT_RADIO_TEXT);
        profilerIDESettings.setAutoSaveSnapshot(object == SAVE_SNAPSHOT_RADIO_TEXT || object == OPEN_SAVE_SNAPSHOT_RADIO_TEXT);
        Object object2 = this.oomeCombo.getSelectedItem();
        if (object2 == OOME_NOTHING_TEXT) {
            profilerIDESettings.setOOMDetectionMode(0);
        } else if (object2 == OOME_PROJECT_TEXT) {
            profilerIDESettings.setOOMDetectionMode(2);
        } else if (object2 == OOME_TEMP_TEXT) {
            profilerIDESettings.setOOMDetectionMode(1);
        } else if (object2 == OOME_CUSTOM_TEXT) {
            profilerIDESettings.setOOMDetectionMode(3);
        }
        profilerIDESettings.setCustomHeapdumpPath(this.oomeDetectionDirTextField.getText());
        profilerIDESettings.setHeapWalkerAnalysisEnabled(this.enableHeapWalkerAnalysisCheckbox.isSelected());
        if (this.telemetryOverviewCombo.getSelectedItem() == KEY_OPEN_ALWAYS) {
            profilerIDESettings.setTelemetryOverviewBehavior(1);
        } else if (this.telemetryOverviewCombo.getSelectedItem() == KEY_OPEN_MONITORING) {
            profilerIDESettings.setTelemetryOverviewBehavior(2);
        } else {
            profilerIDESettings.setTelemetryOverviewBehavior(3);
        }
        if (this.openThreadsViewCombo.getSelectedItem() == KEY_OPEN_ALWAYS) {
            profilerIDESettings.setThreadsViewBehavior(1);
        } else if (this.openThreadsViewCombo.getSelectedItem() == KEY_OPEN_MONITORING) {
            profilerIDESettings.setThreadsViewBehavior(2);
        } else {
            profilerIDESettings.setThreadsViewBehavior(3);
        }
    }

    public boolean currentSettingsEquals(ProfilerIDESettings profilerIDESettings) {
        if (((Number)this.portNoSpinner.getValue()).intValue() != profilerIDESettings.getPortNo()) {
            return false;
        }
        if (this.cpuLiveResultsCheckbox.isSelected() != profilerIDESettings.getDisplayLiveResultsCPU()) {
            return false;
        }
        if (this.memoryLiveResultsCheckbox.isSelected() != profilerIDESettings.getDisplayLiveResultsMemory()) {
            return false;
        }
        if (profilerIDESettings.getAutoOpenSnapshot() && profilerIDESettings.getAutoSaveSnapshot() && this.takingSnapshotCombo.getSelectedItem() != OPEN_SAVE_SNAPSHOT_RADIO_TEXT) {
            return false;
        }
        if (profilerIDESettings.getAutoOpenSnapshot() && this.takingSnapshotCombo.getSelectedItem() != OPEN_SNAPSHOT_RADIO_TEXT) {
            return false;
        }
        if (profilerIDESettings.getAutoSaveSnapshot() && this.takingSnapshotCombo.getSelectedItem() != SAVE_SNAPSHOT_RADIO_TEXT) {
            return false;
        }
        if (profilerIDESettings.getOOMDetectionMode() == 0 && this.oomeCombo.getSelectedItem() != OOME_NOTHING_TEXT) {
            return false;
        }
        if (profilerIDESettings.getOOMDetectionMode() == 2 && this.oomeCombo.getSelectedItem() != OOME_PROJECT_TEXT) {
            return false;
        }
        if (profilerIDESettings.getOOMDetectionMode() == 1 && this.oomeCombo.getSelectedItem() != OOME_TEMP_TEXT) {
            return false;
        }
        if (profilerIDESettings.getOOMDetectionMode() == 3 && this.oomeCombo.getSelectedItem() != OOME_CUSTOM_TEXT) {
            return false;
        }
        if (!this.oomeDetectionDirTextField.getText().equals(profilerIDESettings.getCustomHeapdumpPath())) {
            return false;
        }
        if (this.telemetryOverviewCombo.getSelectedItem() == KEY_OPEN_ALWAYS ? profilerIDESettings.getTelemetryOverviewBehavior() != 1 : (this.telemetryOverviewCombo.getSelectedItem() == KEY_OPEN_MONITORING ? profilerIDESettings.getTelemetryOverviewBehavior() != 2 : this.telemetryOverviewCombo.getSelectedItem() == KEY_OPEN_NEVER && profilerIDESettings.getTelemetryOverviewBehavior() != 3)) {
            return false;
        }
        if (this.openThreadsViewCombo.getSelectedItem() == KEY_OPEN_ALWAYS ? profilerIDESettings.getThreadsViewBehavior() != 1 : (this.openThreadsViewCombo.getSelectedItem() == KEY_OPEN_MONITORING ? profilerIDESettings.getThreadsViewBehavior() != 2 : this.openThreadsViewCombo.getSelectedItem() == KEY_OPEN_NEVER && profilerIDESettings.getThreadsViewBehavior() != 3)) {
            return false;
        }
        return profilerIDESettings.getHeapWalkerAnalysisEnabled() == this.enableHeapWalkerAnalysisCheckbox.isSelected();
    }

    public void init(ProfilerIDESettings profilerIDESettings) {
        this.resetConfirmationsButton.setEnabled(true);
        this.updateJavaPlatformComboItems();
        this.portNoSpinner.setValue((Object)new Integer(profilerIDESettings.getPortNo()));
        if (profilerIDESettings.getJavaPlatformForProfiling() != null) {
            this.javaPlatformCombo.setSelectedItem(profilerIDESettings.getJavaPlatformForProfiling());
        } else {
            this.javaPlatformCombo.setSelectedIndex(0);
        }
        this.cpuLiveResultsCheckbox.setSelected(profilerIDESettings.getDisplayLiveResultsCPU());
        this.memoryLiveResultsCheckbox.setSelected(profilerIDESettings.getDisplayLiveResultsMemory());
        if (profilerIDESettings.getAutoOpenSnapshot() && profilerIDESettings.getAutoSaveSnapshot()) {
            this.takingSnapshotCombo.setSelectedItem(OPEN_SAVE_SNAPSHOT_RADIO_TEXT);
        } else if (profilerIDESettings.getAutoOpenSnapshot()) {
            this.takingSnapshotCombo.setSelectedItem(OPEN_SNAPSHOT_RADIO_TEXT);
        } else if (profilerIDESettings.getAutoSaveSnapshot()) {
            this.takingSnapshotCombo.setSelectedItem(SAVE_SNAPSHOT_RADIO_TEXT);
        }
        if (profilerIDESettings.getOOMDetectionMode() == 0) {
            this.oomeCombo.setSelectedItem(OOME_NOTHING_TEXT);
        } else if (profilerIDESettings.getOOMDetectionMode() == 2) {
            this.oomeCombo.setSelectedItem(OOME_PROJECT_TEXT);
        } else if (profilerIDESettings.getOOMDetectionMode() == 1) {
            this.oomeCombo.setSelectedItem(OOME_TEMP_TEXT);
        } else if (profilerIDESettings.getOOMDetectionMode() == 3) {
            this.oomeCombo.setSelectedItem(OOME_CUSTOM_TEXT);
        }
        this.oomeDetectionDirTextField.setText(profilerIDESettings.getCustomHeapdumpPath());
        this.enableHeapWalkerAnalysisCheckbox.setSelected(profilerIDESettings.getHeapWalkerAnalysisEnabled());
        switch (profilerIDESettings.getTelemetryOverviewBehavior()) {
            case 1: {
                this.telemetryOverviewCombo.setSelectedItem(KEY_OPEN_ALWAYS);
                break;
            }
            case 2: {
                this.telemetryOverviewCombo.setSelectedItem(KEY_OPEN_MONITORING);
                break;
            }
            default: {
                this.telemetryOverviewCombo.setSelectedItem(KEY_OPEN_NEVER);
            }
        }
        switch (profilerIDESettings.getThreadsViewBehavior()) {
            case 1: {
                this.openThreadsViewCombo.setSelectedItem(KEY_OPEN_ALWAYS);
                break;
            }
            case 2: {
                this.openThreadsViewCombo.setSelectedItem(KEY_OPEN_MONITORING);
                break;
            }
            default: {
                this.openThreadsViewCombo.setSelectedItem(KEY_OPEN_NEVER);
            }
        }
        this.updateEnabling();
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        ButtonGroup buttonGroup = new ButtonGroup();
        CategorySeparator categorySeparator = new CategorySeparator(ENGINE_SETTINGS_BORDER_TEXT);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 0, 0, 6);
        this.add((Component)categorySeparator, gridBagConstraints);
        JLabel jLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)jLabel, (String)JAVA_PLATFORM_LABEL_TEXT);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 10, 0, 5);
        gridBagConstraints.anchor = 17;
        this.add((Component)jLabel, gridBagConstraints);
        this.javaPlatformCombo = new JComboBox(){

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        this.javaPlatformCombo.getAccessibleContext().setAccessibleDescription(JAVA_PLAFORM_COMBO_ACCESS_DESCR);
        jLabel.setLabelFor(this.javaPlatformCombo);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(5, 10, 0, 5);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.javaPlatformCombo, gridBagConstraints);
        this.managePlatformsButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.managePlatformsButton, (String)MANAGE_PLATFORMS_BUTTON_NAME);
        this.managePlatformsButton.getAccessibleContext().setAccessibleDescription(MANAGE_PLATFORMS_BUTTON_NAME);
        this.managePlatformsButton.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 3, 0, 6);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.managePlatformsButton, gridBagConstraints);
        JLabel jLabel2 = new JLabel();
        Mnemonics.setLocalizedText((JLabel)jLabel2, (String)COMM_PORT_LABEL_TEXT);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(5, 10, 0, 5);
        gridBagConstraints.anchor = 17;
        this.add((Component)jLabel2, gridBagConstraints);
        this.portNoSpinner = new JExtendedSpinner(){

            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, Utils.getDefaultSpinnerHeight());
            }

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        jLabel2.setLabelFor((Component)this.portNoSpinner);
        if (this.portNoSpinner.getAccessibleContext() != null) {
            this.portNoSpinner.getAccessibleContext().setAccessibleDescription(PORT_NO_SPINNER_ACCESS_DESCR);
        }
        this.portNoSpinner.fixAccessibility();
        this.portNoSpinner.setModel((SpinnerModel)new SpinnerNumberModel(5140, 1, 65535, 1));
        this.portNoSpinner.setPreferredSize(new Dimension(this.portNoSpinner.getPreferredSize().width, this.javaPlatformCombo.getPreferredSize().height));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(5, 10, 0, 6);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.portNoSpinner, gridBagConstraints);
        CategorySeparator categorySeparator2 = new CategorySeparator(WINDOWS_SETTINGS_BORDER_TEXT);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(7, 0, 0, 6);
        this.add((Component)categorySeparator2, gridBagConstraints);
        JLabel jLabel3 = new JLabel();
        Mnemonics.setLocalizedText((JLabel)jLabel3, (String)TELEMETRY_OVERVIEW_LABEL_TEXT);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(5, 10, 0, 5);
        gridBagConstraints.anchor = 17;
        this.add((Component)jLabel3, gridBagConstraints);
        this.telemetryOverviewCombo = new JComboBox(){

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        jLabel3.setLabelFor(this.telemetryOverviewCombo);
        this.telemetryOverviewCombo.getAccessibleContext().setAccessibleDescription(TELEMETRY_OVERVIEW_COMBO_ACCESS_DESCR);
        this.telemetryOverviewCombo.setModel(new DefaultComboBoxModel<String>(new String[]{KEY_OPEN_ALWAYS, KEY_OPEN_MONITORING, KEY_OPEN_NEVER}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(5, 10, 0, 6);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.telemetryOverviewCombo, gridBagConstraints);
        JLabel jLabel4 = new JLabel();
        Mnemonics.setLocalizedText((JLabel)jLabel4, (String)THREADS_VIEW_LABEL_TEXT);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(5, 10, 0, 5);
        gridBagConstraints.anchor = 17;
        this.add((Component)jLabel4, gridBagConstraints);
        this.openThreadsViewCombo = new JComboBox(){

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        jLabel4.setLabelFor(this.openThreadsViewCombo);
        this.openThreadsViewCombo.getAccessibleContext().setAccessibleDescription(THREADS_VIEW_COMBO_ACCESS_DESCR + THREADS_VIEW_HINT_TEXT);
        this.openThreadsViewCombo.setModel(new DefaultComboBoxModel<String>(new String[]{KEY_OPEN_ALWAYS, KEY_OPEN_MONITORING, KEY_OPEN_NEVER}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(5, 10, 0, 6);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.openThreadsViewCombo, gridBagConstraints);
        int n = Math.max(this.telemetryOverviewCombo.getPreferredSize().width, this.openThreadsViewCombo.getPreferredSize().width) + 15;
        int n2 = Math.max(this.telemetryOverviewCombo.getPreferredSize().height, this.openThreadsViewCombo.getPreferredSize().height);
        this.telemetryOverviewCombo.setPreferredSize(new Dimension(n, n2));
        this.openThreadsViewCombo.setPreferredSize(new Dimension(n, n2));
        JLabel jLabel5 = new JLabel(LIVE_RESULTS_LABEL_TEXT);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.insets = new Insets(5, 10, 0, 5);
        gridBagConstraints.anchor = 17;
        this.add((Component)jLabel5, gridBagConstraints);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 2, 0, 0));
        this.cpuLiveResultsCheckbox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.cpuLiveResultsCheckbox, (String)CPU_CHCKBOX_TEXT);
        this.cpuLiveResultsCheckbox.getAccessibleContext().setAccessibleDescription(CPU_LIVE_RESULTS_CHECKBOX_ACCESS_DESCR);
        jPanel.add(this.cpuLiveResultsCheckbox);
        this.memoryLiveResultsCheckbox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.memoryLiveResultsCheckbox, (String)MEMORY_CHCKBOX_TEXT);
        this.memoryLiveResultsCheckbox.getAccessibleContext().setAccessibleDescription(MEMORY_LIVE_RESULTS_CHECKBOX_ACCESS_DESCR);
        jPanel.add(this.memoryLiveResultsCheckbox);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(5, 10, 0, 6);
        gridBagConstraints.anchor = 17;
        this.add((Component)jPanel, gridBagConstraints);
        CategorySeparator categorySeparator3 = new CategorySeparator(SNAPSHOTS_SETTINGS_BORDER_TEXT);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 6);
        this.add((Component)categorySeparator3, gridBagConstraints);
        JLabel jLabel6 = new JLabel();
        Mnemonics.setLocalizedText((JLabel)jLabel6, (String)TAKING_SNAPSHOT_LABEL_TEXT);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.insets = new Insets(5, 10, 0, 5);
        gridBagConstraints.anchor = 17;
        this.add((Component)jLabel6, gridBagConstraints);
        this.takingSnapshotCombo = new JComboBox(){

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        jLabel6.setLabelFor(this.takingSnapshotCombo);
        this.takingSnapshotCombo.getAccessibleContext().setAccessibleDescription(TAKING_SNAPSHOT_COMBO_ACCESS_DESCR);
        this.takingSnapshotCombo.setModel(new DefaultComboBoxModel<String>(new String[]{OPEN_SNAPSHOT_RADIO_TEXT, SAVE_SNAPSHOT_RADIO_TEXT, OPEN_SAVE_SNAPSHOT_RADIO_TEXT}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(5, 10, 0, 6);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.takingSnapshotCombo, gridBagConstraints);
        JLabel jLabel7 = new JLabel();
        Mnemonics.setLocalizedText((JLabel)jLabel7, (String)OOME_BORDER_TEXT);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.insets = new Insets(5, 10, 0, 5);
        gridBagConstraints.anchor = 17;
        this.add((Component)jLabel7, gridBagConstraints);
        this.oomeCombo = new JComboBox(){

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        jLabel7.setLabelFor(this.oomeCombo);
        this.oomeCombo.getAccessibleContext().setAccessibleDescription(OOME_COMBO_ACCESS_DESCR);
        this.oomeCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                ProfilerOptionsPanel.this.updateEnabling();
            }
        });
        this.oomeCombo.setModel(new DefaultComboBoxModel<String>(new String[]{OOME_NOTHING_TEXT, OOME_PROJECT_TEXT, OOME_TEMP_TEXT, OOME_CUSTOM_TEXT}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.insets = new Insets(5, 10, 0, 6);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.oomeCombo, gridBagConstraints);
        int n3 = Math.max(this.takingSnapshotCombo.getPreferredSize().width, this.oomeCombo.getPreferredSize().width);
        int n4 = Math.max(this.takingSnapshotCombo.getPreferredSize().height, this.oomeCombo.getPreferredSize().height);
        this.takingSnapshotCombo.setPreferredSize(new Dimension(n3, n4));
        this.oomeCombo.setPreferredSize(new Dimension(n3, n4));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        this.oomeDetectionDirTextField = new JTextField(){

            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, ((ProfilerOptionsPanel)ProfilerOptionsPanel.this).oomeDetectionChooseDirButton.getPreferredSize().height);
            }

            public Dimension getMinimumSize() {
                return new Dimension(super.getMinimumSize().width, this.getPreferredSize().height);
            }
        };
        this.oomeDetectionDirTextField.getAccessibleContext().setAccessibleName(OOME_CUSTOM_ACCESS_DESCR);
        this.oomeDetectionDirTextField.getAccessibleContext().setAccessibleDescription(OOME_CUSTOM_TEXTFIELD_ACCESS_DESCR);
        this.oomeDetectionDirTextField.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)this.oomeDetectionDirTextField, gridBagConstraints);
        this.oomeDetectionChooseDirButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.oomeDetectionChooseDirButton, (String)"&...");
        this.oomeDetectionChooseDirButton.getAccessibleContext().setAccessibleName(OOME_CUSTOM_BUTTON_ACCESS_NAME);
        this.oomeDetectionChooseDirButton.addActionListener(this);
        this.oomeDetectionChooseDirButton.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        gridBagConstraints.anchor = 17;
        jPanel2.add((Component)this.oomeDetectionChooseDirButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 6);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        this.add((Component)jPanel2, gridBagConstraints);
        JLabel jLabel8 = new JLabel(HEAPWALKER_LABEL_TEXT);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.insets = new Insets(5, 10, 0, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        this.add((Component)jLabel8, gridBagConstraints);
        this.enableHeapWalkerAnalysisCheckbox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.enableHeapWalkerAnalysisCheckbox, (String)ENABLE_ANALYSIS_CHECKBOX);
        this.enableHeapWalkerAnalysisCheckbox.getAccessibleContext().setAccessibleDescription(ENABLE_ANALYSIS_CHECKBOX);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(5, 10, 0, 6);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        this.add((Component)this.enableHeapWalkerAnalysisCheckbox, gridBagConstraints);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        JTextArea jTextArea = new JTextArea(RESET_HINT_TEXT){

            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                dimension.width = 1;
                return dimension;
            }
        };
        jTextArea.setOpaque(false);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setLineWrap(true);
        jTextArea.setEnabled(false);
        jTextArea.setFont(UIManager.getFont("Label.font"));
        jTextArea.setDisabledTextColor(UIManager.getColor("Label.foreground"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        jPanel3.add((Component)jTextArea, gridBagConstraints);
        this.resetConfirmationsButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.resetConfirmationsButton, (String)RESET_BUTTON_NAME);
        this.resetConfirmationsButton.getAccessibleContext().setAccessibleDescription(RESET_HINT_TEXT);
        this.resetConfirmationsButton.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        gridBagConstraints.anchor = 18;
        jPanel3.add((Component)this.resetConfirmationsButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 0, 6);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        this.add((Component)jPanel3, gridBagConstraints);
    }

    private void updateEnabling() {
        boolean bl = this.oomeCombo.getSelectedItem() == OOME_CUSTOM_TEXT;
        this.oomeDetectionDirTextField.setEnabled(bl);
        this.oomeDetectionChooseDirButton.setEnabled(bl);
    }

    private void updateJavaPlatformComboItems() {
        this.updateJavaPlatforms();
        Object object = this.javaPlatformCombo.getSelectedItem();
        this.javaPlatformCombo.removeAllItems();
        DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>(this.supportedJavaPlatformsNames.toArray());
        defaultComboBoxModel.insertElementAt(USE_PROJECT_JVM_TEXT, 0);
        this.javaPlatformCombo.setModel(defaultComboBoxModel);
        if (object != null) {
            this.javaPlatformCombo.setSelectedItem(object);
        }
    }

    private void updateJavaPlatforms() {
        this.supportedJavaPlatforms.clear();
        this.supportedJavaPlatformsNames.clear();
    }

    private static class CategorySeparator
    extends JPanel {
        private JLabel captionLabel;
        private JSeparator captionSeparator;

        public CategorySeparator(String string) {
            this.initComponents();
            this.captionLabel.setText(string);
        }

        private void initComponents() {
            this.setLayout(new GridBagLayout());
            this.captionLabel = new JLabel();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            this.add((Component)this.captionLabel, gridBagConstraints);
            this.captionSeparator = new JSeparator();
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(0, 4, 0, 0);
            this.add((Component)this.captionSeparator, gridBagConstraints);
        }
    }
}

