/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ui.stp;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.lang.ref.WeakReference;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.lib.profiler.common.AttachSettings;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.common.filters.SimpleFilter;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.ImagePanel;
import org.netbeans.lib.profiler.ui.components.VerticalLayout;
import org.netbeans.lib.profiler.ui.components.XPStyleBorder;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.ui.ProfilerDialogs;
import org.netbeans.modules.profiler.ui.stp.AttachSettingsPanel;
import org.netbeans.modules.profiler.ui.stp.DefaultSettingsConfigurator;
import org.netbeans.modules.profiler.ui.stp.ProfilingSettingsManager;
import org.netbeans.modules.profiler.ui.stp.SettingsContainerPanel;
import org.netbeans.modules.profiler.ui.stp.TaskChooser;
import org.netbeans.modules.profiler.ui.stp.TaskPresenter;
import org.netbeans.modules.profiler.ui.stp.Utils;
import org.netbeans.modules.profiler.ui.stp.WelcomePanel;
import org.netbeans.modules.profiler.utils.IDEUtils;
import org.openide.DialogDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectProfilingTask
extends JPanel
implements TaskChooser.Listener,
HelpCtx.Provider {
    private static final String SELECT_PROJECT_TO_ATTACH_STRING = NbBundle.getMessage(SelectProfilingTask.class, (String)"SelectProfilingTask_SelectProjectToAttachString");
    public static final String EXTERNAL_APPLICATION_STRING = NbBundle.getMessage(SelectProfilingTask.class, (String)"SelectProfilingTask_ExternalApplicationString");
    private static final String PROFILE_DIALOG_CAPTION = NbBundle.getMessage(SelectProfilingTask.class, (String)"SelectProfilingTask_ProfileDialogCaption");
    private static final String ATTACH_DIALOG_CAPTION = NbBundle.getMessage(SelectProfilingTask.class, (String)"SelectProfilingTask_AttachDialogCaption");
    private static final String MODIFY_DIALOG_CAPTION = NbBundle.getMessage(SelectProfilingTask.class, (String)"SelectProfilingTask_ModifyDialogCaption");
    private static final String MONITOR_STRING = NbBundle.getMessage(SelectProfilingTask.class, (String)"SelectProfilingTask_MonitorString");
    private static final String CPU_STRING = NbBundle.getMessage(SelectProfilingTask.class, (String)"SelectProfilingTask_CpuString");
    private static final String MEMORY_STRING = NbBundle.getMessage(SelectProfilingTask.class, (String)"SelectProfilingTask_MemoryString");
    private static final String ATTACH_LABEL_TEXT = NbBundle.getMessage(SelectProfilingTask.class, (String)"SelectProfilingTask_AttachLabelText");
    private static final String RUN_BUTTON_TEXT = NbBundle.getMessage(SelectProfilingTask.class, (String)"SelectProfilingTask_RunButtonText");
    private static final String ATTACH_BUTTON_TEXT = NbBundle.getMessage(SelectProfilingTask.class, (String)"SelectProfilingTask_AttachButtonText");
    private static final String OK_BUTTON_TEXT = NbBundle.getMessage(SelectProfilingTask.class, (String)"SelectProfilingTask_OkButtonText");
    private static final String CANCEL_BUTTON_TEXT = NbBundle.getMessage(SelectProfilingTask.class, (String)"SelectProfilingTask_CancelButtonText");
    private static final String INIT_SESSION_STRING = NbBundle.getMessage(SelectProfilingTask.class, (String)"SelectProfilingTask_InitSessionString");
    private static final String CHOOSER_COMBO_ACCESS_DESCR = NbBundle.getMessage(SelectProfilingTask.class, (String)"SelectProfilingTask_ChooserComboAccessDescr");
    private static final String WORKDIR_INVALID_MSG = NbBundle.getMessage(SelectProfilingTask.class, (String)"SelectProfilingTask_WorkDirInvalidMsg");
    public static Color BACKGROUND_COLOR;
    public static Color BACKGROUND_COLOR_INACTIVE;
    public static Color DARKLINK_COLOR;
    public static Color DARKLINK_COLOR_INACTIVE;
    private static SelectProfilingTask defaultInstance;
    private static final Image BACKGROUND_IMAGE;
    private static final Icon MONITOR_ICON;
    private static final Icon CPU_ICON;
    private static final Icon MEMORY_ICON;
    private static final Icon RUN_ICON;
    private static final Icon ATTACH_ICON;
    private AttachSettingsPanel attachSettingsPanel;
    private DialogDescriptor dd;
    private FileObject profiledFile;
    private JPanel taskChooserPanel;
    private JButton attachButton;
    private JButton cancelButton;
    private JButton modifyButton;
    private JButton runButton;
    private JButton submitButton;
    private JComboBox projectsChooserCombo;
    private JLabel projectsChooserLabel;
    private JPanel attachSettingsPanelContainer;
    private JPanel contentsPanel;
    private JPanel customSettingsPanelContainer;
    private JPanel extraSettingsPanel;
    private JPanel projectsChooserComboContainer;
    private JPanel projectsChooserPanel;
    private JSeparator attachSettingsPanelSeparator;
    private JSeparator customSettingsPanelSeparator;
    private JSeparator extraSettingsPanelSeparator;
    private JSeparator projectsChooserSeparator;
    private List<SimpleFilter> predefinedInstrFilterKeys;
    private Object lastAttachProject;
    private SettingsConfigurator configurator;
    private SettingsContainerPanel settingsContainerPanel;
    private TaskChooser taskChooser;
    private TaskPresenter selectedTask;
    private TaskPresenter taskCPU;
    private TaskPresenter taskMemory;
    private TaskPresenter taskMonitor;
    private WeakReference<WelcomePanel> welcomePanelReference;
    private SimpleFilter[] predefinedInstrFilters;
    private String[][] projectPackages;
    private boolean enableOverride;
    private boolean internalComboChange = false;
    private boolean isAttach;
    private boolean isModify;

    private SelectProfilingTask() {
        this.initComponents();
        this.initTasks();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SelectProfilingTask.this.initTaskChooserSize();
                SelectProfilingTask.this.initPreferredSize();
            }
        });
    }

    private static void initColors() {
        boolean bl;
        boolean bl2;
        Color color = UIUtils.getProfilerResultsBackground();
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        boolean bl3 = bl2 = n < 18 || n2 < 18 || n3 < 18;
        if (bl2) {
            BACKGROUND_COLOR = UIUtils.getSafeColor((int)(n + 11), (int)(n2 + 11), (int)(n3 + 11));
            BACKGROUND_COLOR_INACTIVE = UIUtils.getSafeColor((int)(n + 18), (int)(n2 + 18), (int)(n3 + 18));
        } else {
            BACKGROUND_COLOR = UIUtils.getSafeColor((int)(n - 11), (int)(n2 - 11), (int)(n3 - 11));
            BACKGROUND_COLOR_INACTIVE = UIUtils.getSafeColor((int)(n - 18), (int)(n2 - 18), (int)(n3 - 18));
        }
        boolean bl4 = bl = BACKGROUND_COLOR_INACTIVE.getRed() - Color.DARK_GRAY.getRed() < 50;
        if (bl) {
            int n4 = Color.DARK_GRAY.getRed() - Color.BLACK.getRed();
            int n5 = Color.WHITE.getRed() - n4;
            DARKLINK_COLOR = Color.WHITE;
            DARKLINK_COLOR_INACTIVE = UIUtils.getSafeColor((int)n5, (int)n5, (int)n5);
        } else {
            DARKLINK_COLOR = Color.BLACK;
            DARKLINK_COLOR_INACTIVE = Color.DARK_GRAY;
        }
    }

    public static Configuration selectAttachProfilerTask() {
        assert (!SwingUtilities.isEventDispatchThread());
        final SelectProfilingTask selectProfilingTask = SelectProfilingTask.getDefault();
        selectProfilingTask.setSubmitButton(selectProfilingTask.attachButton);
        selectProfilingTask.setupAttachProfiler();
        selectProfilingTask.dd = new DialogDescriptor((Object)selectProfilingTask, ATTACH_DIALOG_CAPTION, true, new Object[]{selectProfilingTask.attachButton, selectProfilingTask.cancelButton}, (Object)selectProfilingTask.attachButton, 0, null, null);
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Dialog dialog = ProfilerDialogs.createDialog(selectProfilingTask.dd);
                dialog.pack();
                dialog.setVisible(true);
                countDownLatch.countDown();
            }
        });
        try {
            countDownLatch.await();
            Configuration configuration = null;
            if (selectProfilingTask.dd.getValue() == selectProfilingTask.attachButton) {
                configuration = new Configuration(selectProfilingTask.createFinalSettings(), selectProfilingTask.getAttachSettings());
            }
            selectProfilingTask.cleanup();
            return configuration;
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    public static Configuration selectModifyProfilingTask(FileObject fileObject, boolean bl) {
        assert (!SwingUtilities.isEventDispatchThread());
        final SelectProfilingTask selectProfilingTask = SelectProfilingTask.getDefault();
        selectProfilingTask.setSubmitButton(selectProfilingTask.modifyButton);
        selectProfilingTask.setupModifyProfiling(fileObject, bl);
        selectProfilingTask.dd = new DialogDescriptor((Object)selectProfilingTask, MessageFormat.format(MODIFY_DIALOG_CAPTION, Utils.getProjectName()), true, new Object[]{selectProfilingTask.modifyButton, selectProfilingTask.cancelButton}, (Object)selectProfilingTask.modifyButton, 0, null, null);
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Dialog dialog = ProfilerDialogs.createDialog(selectProfilingTask.dd);
                dialog.pack();
                dialog.setVisible(true);
                countDownLatch.countDown();
            }
        });
        try {
            countDownLatch.await();
            Configuration configuration = null;
            if (selectProfilingTask.dd.getValue() == selectProfilingTask.modifyButton) {
                configuration = new Configuration(selectProfilingTask.createFinalSettings(), null);
            }
            selectProfilingTask.cleanup();
            return configuration;
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    public static Configuration selectProfileProjectTask(FileObject fileObject, boolean bl) {
        assert (!SwingUtilities.isEventDispatchThread());
        final SelectProfilingTask selectProfilingTask = SelectProfilingTask.getDefault();
        selectProfilingTask.setSubmitButton(selectProfilingTask.runButton);
        selectProfilingTask.setupProfileProject(fileObject, bl);
        String string = Utils.getProjectName() + (fileObject == null ? "" : ": " + fileObject.getNameExt());
        selectProfilingTask.dd = new DialogDescriptor((Object)selectProfilingTask, MessageFormat.format(PROFILE_DIALOG_CAPTION, string), true, new Object[]{selectProfilingTask.runButton, selectProfilingTask.cancelButton}, (Object)selectProfilingTask.runButton, 0, null, null);
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Dialog dialog = ProfilerDialogs.createDialog(selectProfilingTask.dd);
                dialog.getAccessibleContext().setAccessibleDescription(dialog.getTitle());
                dialog.pack();
                dialog.setVisible(true);
                countDownLatch.countDown();
            }
        });
        try {
            countDownLatch.await();
            Configuration configuration = null;
            if (selectProfilingTask.dd.getValue() == selectProfilingTask.runButton) {
                String string2;
                ProfilingSettings profilingSettings = selectProfilingTask.createFinalSettings();
                if (profilingSettings.getOverrideGlobalSettings() && (string2 = profilingSettings.getWorkingDir().trim()).length() != 0 && !new File(string2).exists()) {
                    profilingSettings.setWorkingDir("");
                    NetBeansProfiler.getDefaultNB().displayWarning(WORKDIR_INVALID_MSG);
                }
                configuration = new Configuration(profilingSettings, null);
            }
            selectProfilingTask.cleanup();
            return configuration;
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    public HelpCtx getHelpCtx() {
        return this.settingsContainerPanel.getHelpCtx();
    }

    @Override
    public void itemCollapsed(TaskChooser.Item item) {
    }

    @Override
    public void itemExpanded(TaskChooser.Item item) {
        this.selectedTask.selectProfilingSettings(((TaskPresenter)item).getSelectedProfilingSettings());
    }

    @Override
    public void itemWillCollapse(TaskChooser.Item item) {
    }

    @Override
    public void itemWillExpand(TaskChooser.Item item) {
        this.selectProfilingSettings(((TaskPresenter)item).getSelectedProfilingSettings());
    }

    static SelectProfilingTask getDefault() {
        if (defaultInstance == null) {
            defaultInstance = new SelectProfilingTask();
        }
        return defaultInstance;
    }

    List<SimpleFilter> getPredefinedInstrFilterKeys() {
        return this.predefinedInstrFilterKeys;
    }

    SimpleFilter getResolvedPredefinedFilter(SimpleFilter simpleFilter) {
        return null;
    }

    void setSubmitButton(JButton jButton) {
        this.submitButton = jButton;
    }

    void disableSubmitButton() {
        if (this.submitButton != null) {
            this.submitButton.setEnabled(false);
        }
    }

    void enableSubmitButton() {
        if (this.submitButton != null) {
            this.submitButton.setEnabled(true);
        }
    }

    void synchronizeCurrentSettings() {
        if (this.configurator != null && this.configurator.getSettings() != null) {
            this.configurator.synchronizeSettings();
        }
    }

    void updateHelpCtx() {
        if (this.dd != null) {
            this.dd.setHelpCtx(this.getHelpCtx());
        }
    }

    private AttachSettings getAttachSettings() {
        return this.attachSettingsPanel.getSettings();
    }

    private TaskPresenter getTaskPresenter(ProfilingSettings profilingSettings) {
        if (profilingSettings == null) {
            return null;
        }
        if (Utils.isMonitorSettings(profilingSettings)) {
            return this.taskMonitor;
        }
        if (Utils.isCPUSettings(profilingSettings)) {
            return this.taskCPU;
        }
        if (Utils.isMemorySettings(profilingSettings)) {
            return this.taskMemory;
        }
        return null;
    }

    private WelcomePanel getWelcomePanel() {
        WelcomePanel welcomePanel;
        if (this.welcomePanelReference == null || this.welcomePanelReference.get() == null) {
            welcomePanel = new WelcomePanel();
            this.welcomePanelReference = new WeakReference<WelcomePanel>(welcomePanel);
        } else {
            welcomePanel = (WelcomePanel)this.welcomePanelReference.get();
        }
        return welcomePanel;
    }

    private void cleanup() {
        if (!this.projectsChooserPanel.isVisible() || this.projectsChooserCombo.getSelectedItem() != SELECT_PROJECT_TO_ATTACH_STRING) {
            this.storeCurrentSettings();
        }
        this.projectCleanup();
        this.profiledFile = null;
        this.enableOverride = false;
        this.isAttach = false;
        this.isModify = false;
        this.contentsPanel.removeAll();
        this.customSettingsPanelContainer.removeAll();
        this.internalComboChange = true;
        this.projectsChooserCombo.removeAllItems();
        this.internalComboChange = false;
        this.submitButton = null;
        this.projectPackages = null;
        this.predefinedInstrFilters = null;
        this.predefinedInstrFilterKeys = null;
        this.dd = null;
        this.contentsPanel.setPreferredSize(this.contentsPanel.getSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProfilingSettings createFinalSettings() {
        if (this.configurator != null) {
            ProfilingSettings profilingSettings;
            this.synchronizeCurrentSettings();
            ProfilingSettings profilingSettings2 = this.configurator.createFinalSettings();
            ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)INIT_SESSION_STRING);
            progressHandle.setInitialDelay(0);
            progressHandle.start();
            try {
                profilingSettings = profilingSettings2;
            }
            catch (Throwable throwable) {
                SwingUtilities.invokeLater(new Runnable(progressHandle){
                    final /* synthetic */ ProgressHandle val$pHandle;
                    {
                        this.val$pHandle = progressHandle;
                    }

                    public void run() {
                        this.val$pHandle.finish();
                    }
                });
                throw throwable;
            }
            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            return profilingSettings;
        }
        return null;
    }

    private void initComponents() {
        this.projectsChooserLabel = new JLabel(ATTACH_LABEL_TEXT);
        this.projectsChooserLabel.setBorder(BorderFactory.createEmptyBorder(6, 15, 6, 0));
        this.projectsChooserLabel.setOpaque(false);
        this.projectsChooserCombo = new JComboBox();
        this.projectsChooserLabel.setLabelFor(this.projectsChooserCombo);
        this.projectsChooserCombo.getAccessibleContext().setAccessibleDescription(CHOOSER_COMBO_ACCESS_DESCR);
        this.projectsChooserComboContainer = new JPanel(new BorderLayout());
        this.projectsChooserComboContainer.setBorder(BorderFactory.createEmptyBorder(6, 10, 6, 10));
        this.projectsChooserComboContainer.setOpaque(false);
        this.projectsChooserComboContainer.add((Component)this.projectsChooserCombo, "Center");
        if (!UIUtils.isNimbus()) {
            this.projectsChooserSeparator = Utils.createHorizontalSeparator();
        }
        this.projectsChooserPanel = new JPanel(new BorderLayout());
        this.projectsChooserPanel.add((Component)this.projectsChooserLabel, "West");
        this.projectsChooserPanel.add((Component)this.projectsChooserComboContainer, "Center");
        if (this.projectsChooserSeparator != null) {
            this.projectsChooserPanel.add((Component)this.projectsChooserSeparator, "South");
        }
        this.taskChooser = new TaskChooser();
        this.taskChooser.addItemListener(this);
        this.taskChooserPanel = BACKGROUND_IMAGE != null ? new ImagePanel(BACKGROUND_IMAGE, 3) : new JPanel(null);
        this.taskChooserPanel.setLayout(new BorderLayout());
        this.taskChooserPanel.add((Component)this.taskChooser, "North");
        this.settingsContainerPanel = new SettingsContainerPanel();
        this.contentsPanel = new JPanel(new BorderLayout());
        this.customSettingsPanelSeparator = Utils.createHorizontalSeparator();
        this.customSettingsPanelContainer = new JPanel(new BorderLayout());
        this.attachSettingsPanel = new AttachSettingsPanel();
        this.attachSettingsPanelSeparator = Utils.createHorizontalSeparator();
        this.attachSettingsPanelContainer = new JPanel(new BorderLayout());
        this.attachSettingsPanelContainer.add((Component)this.attachSettingsPanel, "Center");
        this.attachSettingsPanelContainer.add((Component)this.attachSettingsPanelSeparator, "South");
        this.extraSettingsPanelSeparator = Utils.createHorizontalSeparator();
        this.extraSettingsPanel = new JPanel(new BorderLayout());
        this.extraSettingsPanel.add((Component)this.extraSettingsPanelSeparator, "North");
        this.extraSettingsPanel.add((Component)this.customSettingsPanelContainer, "Center");
        this.extraSettingsPanel.add((Component)this.attachSettingsPanelContainer, "South");
        this.runButton = UIUtils.isNimbus() ? new JButton(RUN_BUTTON_TEXT) : new JButton(RUN_BUTTON_TEXT, RUN_ICON);
        this.attachButton = UIUtils.isNimbus() ? new JButton(ATTACH_BUTTON_TEXT){

            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, ((SelectProfilingTask)SelectProfilingTask.this).runButton.getPreferredSize().height);
            }
        } : new JButton(ATTACH_BUTTON_TEXT, ATTACH_ICON){

            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, ((SelectProfilingTask)SelectProfilingTask.this).runButton.getPreferredSize().height);
            }
        };
        this.modifyButton = new JButton(OK_BUTTON_TEXT){

            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, ((SelectProfilingTask)SelectProfilingTask.this).runButton.getPreferredSize().height);
            }
        };
        this.cancelButton = new JButton(CANCEL_BUTTON_TEXT){

            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, ((SelectProfilingTask)SelectProfilingTask.this).runButton.getPreferredSize().height);
            }
        };
        this.setLayout(new BorderLayout());
        this.add((Component)this.projectsChooserPanel, "North");
        this.add((Component)this.taskChooserPanel, "West");
        this.add((Component)this.contentsPanel, "Center");
        this.add((Component)this.extraSettingsPanel, "South");
        this.projectsChooserPanel.setOpaque(true);
        this.projectsChooserPanel.setBackground(this.taskChooserPanel.getBackground());
        this.projectsChooserCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (SelectProfilingTask.this.internalComboChange) {
                    return;
                }
                Object object = SelectProfilingTask.this.projectsChooserCombo.getSelectedItem();
                if (SelectProfilingTask.this.lastAttachProject != null) {
                    SelectProfilingTask.this.storeSettings();
                }
                if (object == null || object == SELECT_PROJECT_TO_ATTACH_STRING) {
                    return;
                }
                if (object != SELECT_PROJECT_TO_ATTACH_STRING && SelectProfilingTask.this.projectsChooserCombo.getItemAt(0) == SELECT_PROJECT_TO_ATTACH_STRING) {
                    SelectProfilingTask.this.projectsChooserCombo.removeItemAt(0);
                }
                if (object == EXTERNAL_APPLICATION_STRING) {
                    SelectProfilingTask.this.updateProject();
                    SelectProfilingTask.this.lastAttachProject = EXTERNAL_APPLICATION_STRING;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        SelectProfilingTask.this.projectsChooserCombo.requestFocusInWindow();
                    }
                });
            }
        });
    }

    private void initPreferredSize() {
        Dimension dimension = new Dimension(360, 215);
        Dimension dimension2 = DefaultSettingsConfigurator.SHARED_INSTANCE.getMonitorConfigurator().getBasicSettingsPanel().getPreferredSize();
        Dimension dimension3 = DefaultSettingsConfigurator.SHARED_INSTANCE.getCPUConfigurator().getBasicSettingsPanel().getPreferredSize();
        Dimension dimension4 = DefaultSettingsConfigurator.SHARED_INSTANCE.getMemoryConfigurator().getBasicSettingsPanel().getPreferredSize();
        dimension.setSize(Math.max(dimension.width, dimension2.width), Math.max(dimension.height, dimension2.height));
        dimension.setSize(Math.max(dimension.width, dimension3.width), Math.max(dimension.height, dimension3.height));
        dimension.setSize(Math.max(dimension.width, dimension4.width), Math.max(dimension.height, dimension4.height));
        this.settingsContainerPanel.setPreferredContentsSize(dimension);
        Dimension dimension5 = this.settingsContainerPanel.getPreferredSize();
        this.contentsPanel.setPreferredSize(dimension5);
    }

    private void initTaskChooserSize() {
        Dimension dimension = new Dimension(200, this.taskChooserPanel.getPreferredSize().height);
        int n = ((VerticalLayout)this.taskChooser.getLayout()).getVGap() * 2;
        int n2 = XPStyleBorder.getBorderInsets().left + XPStyleBorder.getBorderInsets().right;
        Dimension dimension2 = this.taskMonitor.getSmallComponent().getPreferredSize();
        Dimension dimension3 = this.taskCPU.getSmallComponent().getPreferredSize();
        Dimension dimension4 = this.taskMemory.getSmallComponent().getPreferredSize();
        dimension.setSize(Math.max(dimension.width, dimension2.width + n + n2), dimension.height);
        dimension.setSize(Math.max(dimension.width, dimension3.width + n + n2), dimension.height);
        dimension.setSize(Math.max(dimension.width, dimension4.width + n + n2), dimension.height);
        this.taskChooserPanel.setPreferredSize(dimension);
    }

    private void initTasks() {
        TaskPresenter.Context context = new TaskPresenter.Context(){

            public void selectSettings(ProfilingSettings profilingSettings) {
                SelectProfilingTask.this.selectProfilingSettings(profilingSettings);
            }

            public void refreshLayout() {
                SelectProfilingTask.this.taskChooser.refreshLayout();
            }
        };
        this.taskMonitor = new TaskPresenter(MONITOR_STRING, MONITOR_ICON, context);
        this.taskCPU = new TaskPresenter(CPU_STRING, CPU_ICON, context);
        this.taskMemory = new TaskPresenter(MEMORY_STRING, MEMORY_ICON, context);
        this.taskChooser.add(this.taskMonitor);
        this.taskChooser.add(this.taskCPU);
        this.taskChooser.add(this.taskMemory);
    }

    private void projectCleanup() {
        this.taskChooser.reset();
        this.taskMonitor.resetProfilingSettings();
        this.taskCPU.resetProfilingSettings();
        this.taskMemory.resetProfilingSettings();
        this.attachSettingsPanel.resetSettings();
        this.selectedTask = null;
        if (this.configurator != null) {
            this.configurator.reset();
        }
        this.configurator = null;
    }

    private void selectProfilingSettings(ProfilingSettings profilingSettings) {
        this.synchronizeCurrentSettings();
        TaskPresenter taskPresenter = this.getTaskPresenter(profilingSettings);
        if (taskPresenter == null || taskPresenter != this.selectedTask) {
            JPanel jPanel = null;
            if (taskPresenter == null) {
                WelcomePanel welcomePanel;
                jPanel = welcomePanel = this.getWelcomePanel();
            } else {
                if (taskPresenter == this.taskMonitor) {
                    this.settingsContainerPanel.setContents(this.configurator.getMonitorConfigurator());
                } else if (taskPresenter == this.taskCPU) {
                    this.settingsContainerPanel.setContents(this.configurator.getCPUConfigurator());
                } else if (taskPresenter == this.taskMemory) {
                    this.settingsContainerPanel.setContents(this.configurator.getMemoryConfigurator());
                }
                jPanel = this.settingsContainerPanel;
            }
            this.contentsPanel.removeAll();
            this.contentsPanel.add((Component)jPanel, "Center");
            this.contentsPanel.doLayout();
            this.contentsPanel.repaint();
            this.selectedTask = taskPresenter;
        }
        if (profilingSettings != null) {
            this.settingsContainerPanel.setShowingPreset(profilingSettings.isPreset());
            this.settingsContainerPanel.switchToBasicSettings();
            this.settingsContainerPanel.setCaption(profilingSettings.getSettingsName());
            this.selectedTask.selectProfilingSettings(profilingSettings);
            this.configurator.setSettings(profilingSettings);
        }
    }

    private void setupAttachProfiler() {
        this.profiledFile = null;
        this.enableOverride = false;
        this.isAttach = true;
        this.isModify = false;
        this.projectsChooserLabel.setEnabled(true);
        this.projectsChooserCombo.setEnabled(true);
        this.projectsChooserPanel.setVisible(true);
        this.attachSettingsPanel.setEnabled(true);
        this.attachSettingsPanelContainer.setVisible(true);
        if (this.lastAttachProject == null) {
            this.lastAttachProject = EXTERNAL_APPLICATION_STRING;
        }
        this.updateProjectsCombo(EXTERNAL_APPLICATION_STRING);
        this.updateProject();
    }

    private void setupModifyProfiling(FileObject fileObject, boolean bl) {
        this.profiledFile = fileObject;
        this.enableOverride = false;
        this.isAttach = bl;
        this.isModify = true;
        this.projectsChooserLabel.setEnabled(false);
        this.projectsChooserCombo.setEnabled(false);
        this.projectsChooserPanel.setVisible(bl);
        this.attachSettingsPanel.setEnabled(false);
        this.attachSettingsPanelContainer.setVisible(bl);
        if (bl) {
            this.updateProjectsCombo(EXTERNAL_APPLICATION_STRING);
        }
        this.updateProject();
    }

    private void setupProfileProject(FileObject fileObject, boolean bl) {
        this.enableOverride = bl;
        this.isAttach = false;
        this.isModify = false;
        this.projectsChooserPanel.setVisible(false);
        this.attachSettingsPanelContainer.setVisible(false);
        this.updateProject();
    }

    private void storeCurrentSettings() {
        this.storeSettings();
    }

    private void storeSettings() {
        this.synchronizeCurrentSettings();
        final ArrayList<ProfilingSettings> arrayList = new ArrayList<ProfilingSettings>();
        arrayList.addAll(this.taskMonitor.getProfilingSettings());
        arrayList.addAll(this.taskCPU.getProfilingSettings());
        arrayList.addAll(this.taskMemory.getProfilingSettings());
        final ProfilingSettings profilingSettings = this.selectedTask == null ? null : this.selectedTask.getSelectedProfilingSettings();
        IDEUtils.runInProfilerRequestProcessor(new Runnable(){

            public void run() {
                ProfilingSettingsManager.getDefault().storeProfilingSettings(arrayList.toArray(new ProfilingSettings[arrayList.size()]), profilingSettings);
            }
        });
    }

    private void updateProject() {
        Runnable runnable = new Runnable(){

            public void run() {
                SelectProfilingTask.this.projectCleanup();
                SelectProfilingTask.access$1302(SelectProfilingTask.this, null);
                SelectProfilingTask.access$1402(SelectProfilingTask.this, null);
                SelectProfilingTask.this.predefinedInstrFilterKeys = null;
                if (SelectProfilingTask.this.projectsChooserPanel.isVisible() && SelectProfilingTask.this.projectsChooserCombo.getSelectedItem() == SELECT_PROJECT_TO_ATTACH_STRING) {
                    SelectProfilingTask.this.taskChooser.setEnabled(false);
                    SelectProfilingTask.this.contentsPanel.removeAll();
                    SelectProfilingTask.this.contentsPanel.add((Component)SelectProfilingTask.this.getWelcomePanel(), "Center");
                    SelectProfilingTask.this.contentsPanel.doLayout();
                    SelectProfilingTask.this.contentsPanel.repaint();
                } else {
                    SelectProfilingTask.this.configurator = Utils.getSettingsConfigurator();
                    SelectProfilingTask.this.configurator.setContext(SelectProfilingTask.this.profiledFile, SelectProfilingTask.this.isAttach, SelectProfilingTask.this.isModify, SelectProfilingTask.this.enableOverride);
                    JPanel jPanel = SelectProfilingTask.this.configurator.getCustomSettingsPanel();
                    if (jPanel != null) {
                        SelectProfilingTask.this.customSettingsPanelContainer.removeAll();
                        SelectProfilingTask.this.customSettingsPanelContainer.add((Component)jPanel, "North");
                        SelectProfilingTask.this.customSettingsPanelContainer.add((Component)SelectProfilingTask.this.customSettingsPanelSeparator, "South");
                        SelectProfilingTask.this.customSettingsPanelContainer.setVisible(true);
                    } else {
                        SelectProfilingTask.this.customSettingsPanelContainer.removeAll();
                        SelectProfilingTask.this.customSettingsPanelContainer.setVisible(false);
                    }
                    SelectProfilingTask.this.taskChooser.setEnabled(true);
                    ProfilingSettings[] profilingSettingsArray = new ProfilingSettings[]{};
                    ProfilingSettings profilingSettings = null;
                    ProfilingSettingsManager.ProfilingSettingsDescriptor profilingSettingsDescriptor = ProfilingSettingsManager.getDefault().getProfilingSettings();
                    profilingSettingsArray = profilingSettingsDescriptor.getProfilingSettings();
                    profilingSettings = profilingSettingsDescriptor.getLastSelectedProfilingSettings();
                    ArrayList<ProfilingSettings> arrayList = new ArrayList<ProfilingSettings>();
                    ArrayList<ProfilingSettings> arrayList2 = new ArrayList<ProfilingSettings>();
                    ArrayList<ProfilingSettings> arrayList3 = new ArrayList<ProfilingSettings>();
                    Object object = profilingSettingsArray;
                    int n = ((ProfilingSettings[])object).length;
                    for (int i = 0; i < n; ++i) {
                        ProfilingSettings profilingSettings2 = object[i];
                        if (Utils.isMonitorSettings(profilingSettings2)) {
                            arrayList.add(profilingSettings2);
                            continue;
                        }
                        if (Utils.isCPUSettings(profilingSettings2)) {
                            arrayList2.add(profilingSettings2);
                            continue;
                        }
                        if (!Utils.isMemorySettings(profilingSettings2)) continue;
                        arrayList3.add(profilingSettings2);
                    }
                    SelectProfilingTask.this.taskMonitor.setProfilingSettings(arrayList);
                    SelectProfilingTask.this.taskCPU.setProfilingSettings(arrayList2);
                    SelectProfilingTask.this.taskMemory.setProfilingSettings(arrayList3);
                    if (profilingSettings == null) {
                        object = arrayList2.iterator();
                        while (object.hasNext()) {
                            ProfilingSettings profilingSettings3 = (ProfilingSettings)object.next();
                            if (!profilingSettings3.isPreset()) continue;
                            profilingSettings = profilingSettings3;
                        }
                    }
                    if (profilingSettings != null && (object = SelectProfilingTask.this.getTaskPresenter(profilingSettings)) != null) {
                        SelectProfilingTask.this.taskChooser.expandImmediately((TaskChooser.Item)object);
                    }
                    SelectProfilingTask.this.selectProfilingSettings(profilingSettings);
                }
                if (SelectProfilingTask.this.attachSettingsPanelContainer.isVisible()) {
                    SelectProfilingTask.this.attachSettingsPanel.setSettings(SelectProfilingTask.this.projectsChooserCombo.getSelectedItem() != SELECT_PROJECT_TO_ATTACH_STRING);
                }
            }
        };
        IDEUtils.runInEventDispatchThread(runnable);
    }

    private void updateProjectsCombo(Object object) {
        this.internalComboChange = true;
        if (object == null) {
            this.projectsChooserCombo.addItem(SELECT_PROJECT_TO_ATTACH_STRING);
        }
        this.projectsChooserCombo.addItem(EXTERNAL_APPLICATION_STRING);
        if (object == null) {
            this.projectsChooserCombo.setSelectedIndex(0);
        } else {
            this.projectsChooserCombo.setSelectedItem(object);
        }
        this.internalComboChange = false;
    }

    static /* synthetic */ String[][] access$1302(SelectProfilingTask selectProfilingTask, String[][] stringArray) {
        selectProfilingTask.projectPackages = stringArray;
        return stringArray;
    }

    static /* synthetic */ SimpleFilter[] access$1402(SelectProfilingTask selectProfilingTask, SimpleFilter[] simpleFilterArray) {
        selectProfilingTask.predefinedInstrFilters = simpleFilterArray;
        return simpleFilterArray;
    }

    static {
        SelectProfilingTask.initColors();
        BACKGROUND_IMAGE = UIUtils.isNimbus() ? null : ImageUtilities.loadImage((String)"org/netbeans/modules/profiler/ui/stp/resources/sptBar.png");
        MONITOR_ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/profiler/ui/resources/monitoring.png", (boolean)false);
        CPU_ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/profiler/ui/resources/cpu.png", (boolean)false);
        MEMORY_ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/profiler/ui/resources/memory.png", (boolean)false);
        RUN_ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/profiler/actions/resources/runButton.gif", (boolean)false);
        ATTACH_ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/profiler/actions/resources/attachButton.gif", (boolean)false);
    }

    public static class Configuration {
        private AttachSettings attachSettings;
        private ProfilingSettings profilingSettings;

        Configuration(ProfilingSettings profilingSettings, AttachSettings attachSettings) {
            this.profilingSettings = profilingSettings;
            this.attachSettings = attachSettings;
        }

        public AttachSettings getAttachSettings() {
            return this.attachSettings;
        }

        public ProfilingSettings getProfilingSettings() {
            return this.profilingSettings;
        }
    }

    public static interface SettingsConfigurator {
        public SettingsContainerPanel.Contents getCPUConfigurator();

        public void setContext(FileObject var1, boolean var2, boolean var3, boolean var4);

        public JPanel getCustomSettingsPanel();

        public SettingsContainerPanel.Contents getMemoryConfigurator();

        public SettingsContainerPanel.Contents getMonitorConfigurator();

        public void setSettings(ProfilingSettings var1);

        public ProfilingSettings getSettings();

        public ProfilingSettings createFinalSettings();

        public void loadCustomSettings(Properties var1);

        public void reset();

        public void storeCustomSettings(Properties var1);

        public void synchronizeSettings();
    }
}

