/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.desktop.launcher;

import com.wavemaker.desktop.launcher.Launcher;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;

public class AppServer
implements LifecycleListener {
    private Launcher launcher;
    private String[] args;
    private SERVER_STATUS status = SERVER_STATUS.UNKNOWN;

    public AppServer(Launcher launcher, String[] args) {
        this.launcher = launcher;
        this.args = args;
        this.launcher.addLifecycleListener(this);
    }

    @Override
    public void lifecycleEvent(LifecycleEvent event) {
        if ("init".equals(event.getType())) {
            this.status = SERVER_STATUS.INITIALIZING;
        } else if ("before_start".equals(event.getType())) {
            this.status = SERVER_STATUS.STARTING;
        } else if ("after_start".equals(event.getType())) {
            this.status = SERVER_STATUS.RUNNING;
        } else if ("before_stop".equals(event.getType())) {
            this.status = SERVER_STATUS.STOPPING;
        } else if ("after_stop".equals(event.getType())) {
            this.status = SERVER_STATUS.STOPPED;
        }
    }

    public SERVER_STATUS getStatus() {
        return this.status;
    }

    public void start() {
        Thread server = new Thread(new Runnable(){

            @Override
            public void run() {
                AppServer.this.launcher.process(AppServer.this.args);
            }
        });
        server.start();
    }

    public void stop() {
        this.launcher.stopServer();
    }

    public Launcher getLauncher() {
        return this.launcher;
    }

    public void setLauncher(Launcher launcher) {
        this.launcher = launcher;
    }

    public String[] getArgs() {
        return this.args;
    }

    public void setArgs(String[] args) {
        this.args = args;
    }

    public static enum SERVER_STATUS {
        UNKNOWN,
        INITIALIZING,
        STARTING,
        RUNNING,
        STOPPING,
        STOPPED;

    }
}

