/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.desktop.launcher;

import com.wavemaker.desktop.launcher.AppServer;
import com.wavemaker.desktop.launcher.Launcher;
import com.wavemaker.desktop.launcher.TomcatConfig;
import com.wavemaker.desktop.launcher.ui.MainLauncherUI;
import com.wavemaker.desktop.launcher.ui.ProgressDialog;
import com.wavemaker.desktop.launcher.ui.StudioUpgradeDialog;
import java.awt.DisplayMode;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;

public class Main {
    public static final String STUDIO_DIR = "studio";
    public static final String studioWebApp = "wavemaker";
    public static final String SRC_DEMOS_DIR = "Samples";
    public static final String DEST_DEMOS_DIR = "samples";
    public static File CatalinaHome;
    public static TomcatConfig tomcatConfig;
    public static PrintStream consoleOut;
    public static PrintStream consoleErr;
    public static PrintStream logOut;

    public static File getTomcatServerXML() throws URISyntaxException, MalformedURLException {
        try {
            File wmHomeConf = new File(Main.getWaveMakerHome(), "server.xml");
            if (wmHomeConf.exists()) {
                return wmHomeConf;
            }
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        try {
            File catalinaHomeConf = new File(Main.getCatalinaHome(), "conf/server.xml");
            if (catalinaHomeConf.exists()) {
                return catalinaHomeConf;
            }
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public static void setDefaultTomcatConfiguration(TomcatConfig config) throws IOException, URISyntaxException {
        try {
            File wmHomeConf = new File(Main.getWaveMakerHome(), "server.xml");
            FileOutputStream fos = new FileOutputStream(wmHomeConf);
            config.serialize(fos);
            fos.close();
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
    }

    public static File getCatalinaHome() throws URISyntaxException {
        URL resource = Main.class.getClassLoader().getResource("catalina.home.marker");
        File file = null;
        if (resource != null) {
            URI uri = new URI(resource.toString());
            file = new File(uri).getParentFile();
        } else {
            file = new File("C:\\program files\\WaveMaker\\Tomcat\\");
        }
        return file;
    }

    public static File getSourceDemosDir() throws URISyntaxException {
        File catalinaHome = Main.getCatalinaHome();
        File ret = new File(catalinaHome, "../Samples");
        return ret;
    }

    public static File getStudioDir() throws URISyntaxException {
        return new File(new File(Main.getCatalinaHome(), ".."), STUDIO_DIR);
    }

    protected static void createDefaultContextXml(File contextDir) throws IOException {
        File defaultContext = new File(contextDir, "context.xml.default");
        FileWriter writer = new FileWriter(defaultContext);
        writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?><Context>\n\t<Manager className=\"org.apache.catalina.session.PersistentManager\" saveOnRestart=\"false\"/>\n</Context>\n");
        ((Writer)writer).close();
    }

    protected static void createContextXml(File contextDir, File webAppDir, String webAppName) throws IOException {
        FileWriter writer = new FileWriter(new File(contextDir, webAppName + ".xml"));
        writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?><Context antiJARLocking=\"false\" antiResourceLocking=\"false\" \t\tdocBase=\"" + webAppDir.getAbsolutePath() + "\" path=\"/" + webAppName + "\" privileged=\"true\">\n" + "</Context>\n");
        ((Writer)writer).close();
    }

    public static void main(String[] args) throws InterruptedException, URISyntaxException, IOException {
        if (GraphicsEnvironment.isHeadless()) {
            boolean starting;
            if (0 == args.length) {
                args = new String[]{"start"};
            }
            if (starting = Arrays.asList(args).contains("start")) {
                Main.start(args, false);
            } else {
                Main.stop(args);
            }
        } else {
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            DisplayMode display = ge.getDefaultScreenDevice().getDisplayMode();
            if (Main.isStudioUpgrade()) {
                StudioUpgradeDialog sud = new StudioUpgradeDialog(Main.getCurrentVersionString(), Main.getWaveMakerHome(), Main.getNewDefaultWMHome(), Main.isMajorUpgrade());
                sud.setLocation(display.getWidth() / 2 - sud.getWidth() / 2, display.getHeight() / 2 - sud.getHeight() / 2);
                sud.setVisible(true);
                ProgressDialog progress = new ProgressDialog("Studio Upgrade:", "Please wait while the Studio upgrade is completed.", false, false);
                progress.start();
                try {
                    Main.doUpgrade(sud.getSelectedProjectsPath());
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                }
                progress.stop();
            }
            tomcatConfig = TomcatConfig.GetDefaultConfig();
            MainLauncherUI ui = new MainLauncherUI(Main.getCurrentVersionString(), tomcatConfig);
            ui.pack();
            ui.setLocation(display.getWidth() / 2 - ui.getWidth() / 2, display.getHeight() / 2 - ui.getHeight() / 2);
            ui.setVisible(true);
            ui.clickStart();
        }
    }

    public static Launcher start(String[] args, boolean noStdoutRedirect) throws IOException, URISyntaxException {
        return Main.start(args, null, noStdoutRedirect);
    }

    public static Launcher start(TomcatConfig config, boolean noStdoutRedirect) throws IOException, URISyntaxException {
        return Main.start(new String[]{"start"}, config, noStdoutRedirect);
    }

    public static Launcher start(String[] args, TomcatConfig config, boolean noStdoutRedirect) throws IOException, URISyntaxException {
        AppServer server = Main.getServerInstance(args, config, noStdoutRedirect);
        server.start();
        return server.getLauncher();
    }

    public static AppServer getServerInstance(String[] args, boolean noStdoutRedirect) throws IOException, URISyntaxException {
        return Main.getServerInstance(args, null, noStdoutRedirect);
    }

    public static AppServer getServerInstance(TomcatConfig config, boolean noStdoutRedirect) throws IOException, URISyntaxException {
        return Main.getServerInstance(new String[]{"start"}, config, noStdoutRedirect);
    }

    public static AppServer getServerInstance(String[] args, TomcatConfig config, boolean noStdoutRedirect) throws IOException, URISyntaxException {
        File catalinaHome = Main.init(noStdoutRedirect, config);
        Main.printlnToLog("Studio Version is " + Main.getCurrentVersionString());
        Main.printlnToLog("Java version is " + System.getProperty("java.version"));
        Main.printlnToLog("Starting Tomcat");
        File catalinaDir = new File(new File(catalinaHome, "conf"), "Catalina");
        catalinaDir.mkdir();
        File localhostDir = new File(catalinaDir, "localhost");
        localhostDir.mkdir();
        Main.createDefaultContextXml(localhostDir);
        File studioDir = Main.getStudioDir();
        if (studioDir.exists()) {
            Main.createContextXml(localhostDir, studioDir, studioWebApp);
        }
        File oldCatalinaWebApps = new File(Main.getCatalinaHome(), "webapps");
        Main.createContextXml(localhostDir, new File(oldCatalinaWebApps, "ROOT"), "ROOT");
        Main.createContextXml(localhostDir, new File(oldCatalinaWebApps, "manager"), "manager");
        return Main.createLauncher(args, catalinaHome);
    }

    public static void stop() throws URISyntaxException {
        Main.stop(new String[]{"stop"});
    }

    public static void stop(String[] args) throws URISyntaxException {
        File catalinaHome = Main.getCatalinaHome();
        AppServer server = Main.createLauncher(args, catalinaHome);
        server.start();
    }

    private static AppServer createLauncher(String[] args, File catalinaHome) {
        Main.printlnToLog("Catalina Home is: " + catalinaHome);
        Launcher launcher = new Launcher();
        launcher.setCatalinaHome(catalinaHome.getAbsolutePath());
        AppServer server = new AppServer(launcher, args);
        return server;
    }

    private static File init(boolean noStdoutRedirect, TomcatConfig configuration) throws IOException, URISyntaxException {
        File catalinaHome;
        try {
            catalinaHome = Main.initHome(configuration);
            if (!noStdoutRedirect) {
                Main.initStreams();
            }
            Main.initDemosDir();
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        CatalinaHome = catalinaHome;
        return catalinaHome;
    }

    private static File initHome(TomcatConfig configuration) throws IOException, URISyntaxException, ClassNotFoundException, SecurityException, IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        File newCatalinaHome = Main.createTempDirectory("WMCatalinaHome", ".temp");
        File oldCatalinaHome = Main.getCatalinaHome();
        Main.copy(new File(oldCatalinaHome, "conf"), new File(newCatalinaHome, "conf"));
        if (configuration != null) {
            File serverXML = new File(newCatalinaHome, File.separator + "conf" + File.separator + "server.xml");
            FileOutputStream os = new FileOutputStream(serverXML);
            configuration.serialize(os);
            os.close();
        }
        File webapp = new File(newCatalinaHome, "webapps");
        webapp.mkdir();
        return newCatalinaHome;
    }

    private static void initDemosDir() throws URISyntaxException, IOException, SecurityException, IllegalArgumentException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        File srcDemosDir = Main.getSourceDemosDir();
        File destDemosDir = new File(Main.getWaveMakerHome(), DEST_DEMOS_DIR);
        if (!destDemosDir.exists()) {
            destDemosDir.mkdir();
        }
        if (null != srcDemosDir && srcDemosDir.exists()) {
            for (File file : srcDemosDir.listFiles()) {
                File destFile = new File(destDemosDir, file.getName());
                if (!file.isDirectory() || destFile.exists()) continue;
                Main.copy(file, destFile);
            }
            Main.setDemosDir(destDemosDir);
        }
    }

    private static PrintStream initLogs() throws SecurityException, IllegalArgumentException, ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException, URISyntaxException, MalformedURLException {
        File wmHome = Main.getWaveMakerHome();
        File logDir = new File(wmHome, "logs");
        if (!logDir.exists()) {
            logDir.mkdir();
        }
        File logFile = new File(logDir, "wm.log");
        PrintStream ps = null;
        try {
            logOut = ps = new PrintStream(new FileOutputStream(logFile, true));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("failed to init logging: " + e.getMessage(), e);
        }
        return ps;
    }

    private static void initStreams() throws SecurityException, IllegalArgumentException, ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException, URISyntaxException, MalformedURLException {
        PrintStream ps = Main.initLogs();
        consoleOut = System.out;
        consoleErr = System.err;
        System.setOut(ps);
        System.setErr(ps);
    }

    public static synchronized void printlnToConsole(String line) {
        if (consoleOut != null) {
            consoleOut.println(line);
        } else {
            System.out.println(line);
        }
    }

    public static synchronized void printlnToLog(String line) {
        if (logOut == null) {
            try {
                Main.initLogs();
            }
            catch (SecurityException e) {
            }
            catch (IllegalArgumentException e) {
            }
            catch (MalformedURLException e) {
            }
            catch (ClassNotFoundException e) {
            }
            catch (InstantiationException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (NoSuchMethodException e) {
            }
            catch (InvocationTargetException e) {
            }
            catch (URISyntaxException e) {
                // empty catch block
            }
        }
        line = "WaveMaker: " + line;
        PrintStream ps = logOut;
        if (ps != null) {
            ps.println(line);
        } else {
            System.out.println(line);
        }
    }

    private static ClassLoader getToolsClassLoader() throws URISyntaxException, MalformedURLException {
        File studioDir = Main.getStudioDir();
        File wmToolsJar = new File(studioDir, "WEB-INF/lib/wmtools.jar");
        if (!wmToolsJar.exists()) {
            throw new RuntimeException("No wmtools.jar found: " + wmToolsJar);
        }
        File wmCommonJar = new File(studioDir, "WEB-INF/lib/wmcommon.jar");
        if (!wmToolsJar.exists()) {
            throw new RuntimeException("No wmcommon.jar found: " + wmCommonJar);
        }
        return new URLClassLoader(new URL[]{wmToolsJar.toURI().toURL(), wmCommonJar.toURI().toURL()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object invokeFromWM(String fqClass, String methodName, Class<?>[] argTypes, Object[] args, boolean isStatic) {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader cl = Main.getToolsClassLoader();
            Thread.currentThread().setContextClassLoader(cl);
            Class<?> klass = cl.loadClass("com.wavemaker.tools.project.LauncherHelper");
            Method m = klass.getMethod("invoke", ClassLoader.class, String.class, String.class, new Class[0].getClass(), new Object[0].getClass(), Boolean.TYPE);
            Object object = m.invoke(null, cl, fqClass, methodName, argTypes, args, isStatic);
            Thread.currentThread().setContextClassLoader(old);
            return object;
        }
        catch (Throwable throwable) {
            try {
                Thread.currentThread().setContextClassLoader(old);
                throw throwable;
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (SecurityException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static void copy(File source, File dest) {
        Main.invokeFromWM("com.wavemaker.common.util.IOUtils", "copy", new Class[]{File.class, File.class}, new Object[]{source, dest}, true);
    }

    public static File createTempDirectory(String prefix, String suffix) {
        return (File)Main.invokeFromWM("com.wavemaker.common.util.IOUtils", "createTempDirectory", new Class[]{String.class, String.class}, new Object[]{prefix, suffix}, true);
    }

    private static File getWaveMakerHome() {
        Object result = Main.invokeFromWM("com.wavemaker.tools.project.StudioConfiguration", "getWaveMakerHome", new Class[0], new Object[0], false);
        return (File)result;
    }

    private static void setDemosDir(File newDemosDir) {
        Main.invokeFromWM("com.wavemaker.tools.project.StudioConfiguration", "setDemoDir", new Class[]{File.class}, new Object[]{newDemosDir}, false);
    }

    private static boolean isStudioUpgrade() {
        return (Boolean)Main.invokeFromWM("com.wavemaker.tools.project.LauncherHelper", "isStudioUpgrade", new Class[0], new Object[0], false);
    }

    private static boolean isMajorUpgrade() {
        return (Boolean)Main.invokeFromWM("com.wavemaker.tools.project.LauncherHelper", "isMajorUpgrade", new Class[0], new Object[0], false);
    }

    private static void doUpgrade(File waveMakerHome) {
        Main.invokeFromWM("com.wavemaker.tools.project.LauncherHelper", "doUpgrade", new Class[]{File.class}, new Object[]{waveMakerHome}, false);
    }

    private static String getCurrentVersionString() {
        return (String)Main.invokeFromWM("com.wavemaker.tools.project.LauncherHelper", "getCurrentVersionString", new Class[0], new Object[0], false);
    }

    private static File getNewDefaultWMHome() {
        File result = null;
        String path = (String)Main.invokeFromWM("com.wavemaker.tools.project.LauncherHelper", "getNewDefaultWMHome", new Class[0], new Object[0], false);
        if (path != null) {
            result = new File(path);
        }
        return result;
    }
}

