/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.desktop.launcher;

import com.wavemaker.desktop.launcher.InvalidServerConfigurationException;
import com.wavemaker.desktop.launcher.Main;
import com.wavemaker.desktop.launcher.TomcatConfig;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;

public class Server {
    private static final String NO_STDOUT_REDIRECT = "--no-stdout-redirect";
    public static final int DEFAULT_FIRSTPORT = 8000;
    public static final int DEFAULT_LASTPORT = 9000;

    private static void usage() {
        System.out.println("Server usage: [-h] [--no-stdout-redirect]");
        System.out.println("\t-h: print usage and exit");
        System.out.println("\t--no-stdout-redirect: don't redirect stdout");
    }

    public static void main(String[] args) throws IOException, URISyntaxException {
        boolean noStdoutRedirect = false;
        ArrayList<String> argsList = new ArrayList<String>();
        argsList.add("start");
        for (String arg : args) {
            if (arg.equals("-h")) {
                Server.usage();
                return;
            }
            if (arg.equals(NO_STDOUT_REDIRECT)) {
                noStdoutRedirect = true;
                continue;
            }
            argsList.add(arg);
        }
        Main.start(argsList.toArray(new String[argsList.size()]), noStdoutRedirect);
    }

    public static void ValidateConfig(TomcatConfig config) throws InvalidServerConfigurationException {
        Server.ValidateConfig(config, 8000, 9000);
    }

    public static void ValidateConfig(TomcatConfig config, int firstPort, int lastPort) throws InvalidServerConfigurationException {
        Main.printlnToLog("\tScanning for Shutdown Port:");
        int shutdownPort = Server.FindOpenPort(config.getShutdownPort(), firstPort, lastPort);
        if (shutdownPort == -1) {
            throw new InvalidServerConfigurationException(InvalidServerConfigurationException.Parameter.SHUTDOWN_PORT, "Unable to locate an available port.");
        }
        Main.printlnToLog("\tSelected Shutdown Port: " + shutdownPort);
        Main.printlnToLog("\tScanning for Service Port: ");
        int servicePort = Server.FindOpenPort(config.getServicePort(), firstPort, lastPort, new int[]{shutdownPort});
        if (servicePort == -1) {
            throw new InvalidServerConfigurationException(InvalidServerConfigurationException.Parameter.SERIVCE_PORT, "Unable to locate an available port.");
        }
        Main.printlnToLog("\tSelected Service Port: " + servicePort);
        config.setShutdownPort(shutdownPort);
        config.setServicePort(servicePort);
    }

    public static int FindOpenPort(int preferred, int minPort, int maxPort) {
        return Server.FindOpenPort(preferred, minPort, maxPort, new int[0]);
    }

    /*
     * Exception decompiling
     */
    public static int FindOpenPort(int preferred, int minPort, int maxPort, int[] exclude) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

