/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.desktop.launcher.ui;

import com.wavemaker.desktop.launcher.AppServer;
import com.wavemaker.desktop.launcher.InvalidServerConfigurationException;
import com.wavemaker.desktop.launcher.Main;
import com.wavemaker.desktop.launcher.Server;
import com.wavemaker.desktop.launcher.TomcatConfig;
import com.wavemaker.desktop.launcher.ui.BrowserLauncher;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.prefs.Preferences;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.SoftBevelBorder;
import javax.swing.border.TitledBorder;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;

public class MainLauncherUI
extends JFrame {
    private static final long serialVersionUID = 1L;
    public static String OPTION_ENABLE_DEBUG = "debug";
    public static String OPTION_ENABLE_LIVELAYOUT = "livelayout";
    protected String version;
    protected TomcatConfig config;
    protected AppServer appServer;
    protected JButton startButton;
    protected JButton stopButton;
    protected JButton optionsButton;
    protected JPanel optionsPanel;
    protected JPanel statusBar;
    protected JCheckBox debugCheckbox;
    protected JCheckBox noLiveCheckbox;
    protected JTextField servicePortField;
    protected JTextField shutdownPortField;
    protected JLabel servicePortStatus;
    protected JLabel shutdownPortStatus;
    protected JLabel serverStatus;

    public MainLauncherUI(String version, TomcatConfig config) {
        this.version = version;
        this.setTitle("WaveMaker Studio " + version + " ");
        try {
            BufferedImage source = ImageIO.read(MainLauncherUI.class.getResourceAsStream("wavemaker_small.png"));
            if (source != null) {
                BufferedImage icon = source;
                this.setIconImage(icon);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.config = config;
        this.init();
    }

    private void initOptions() {
        this.optionsPanel = new JPanel();
        this.optionsPanel.setBorder(new TitledBorder("WaveMaker Options:"));
        this.optionsPanel.setLayout(new GridBagLayout());
        final Preferences prefs = Preferences.userNodeForPackage(MainLauncherUI.class);
        this.debugCheckbox = new JCheckBox("Enable Debug");
        this.debugCheckbox.setSelected(prefs.getBoolean(OPTION_ENABLE_DEBUG, false));
        this.optionsPanel.add((Component)this.debugCheckbox, new GridBagConstraints(0, 0, 1, 1, 0.25, 0.0, 18, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.noLiveCheckbox = new JCheckBox("Enable LiveLayout");
        this.noLiveCheckbox.setSelected(prefs.getBoolean(OPTION_ENABLE_LIVELAYOUT, true));
        this.optionsPanel.add((Component)this.noLiveCheckbox, new GridBagConstraints(0, 1, 1, 1, 0.25, 0.0, 18, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.servicePortField = new JTextField(Integer.toString(this.config.getServicePort()));
        this.servicePortField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent arg0) {
            }

            @Override
            public void focusLost(FocusEvent arg0) {
                try {
                    int newPort = Integer.parseInt(MainLauncherUI.this.servicePortField.getText());
                    if (newPort != MainLauncherUI.this.config.getServicePort()) {
                        MainLauncherUI.this.config.setServicePort(newPort);
                    }
                }
                catch (NumberFormatException e) {
                    MainLauncherUI.this.servicePortField.setText(Integer.toString(MainLauncherUI.this.config.getServicePort()));
                }
            }
        });
        this.optionsPanel.add((Component)new JLabel("Server Port:"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.optionsPanel.add((Component)this.servicePortField, new GridBagConstraints(1, 2, 1, 1, 0.75, 0.0, 18, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.shutdownPortField = new JTextField(Integer.toString(this.config.getShutdownPort()));
        this.shutdownPortField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent arg0) {
            }

            @Override
            public void focusLost(FocusEvent arg0) {
                try {
                    int newPort = Integer.parseInt(MainLauncherUI.this.shutdownPortField.getText());
                    if (newPort != MainLauncherUI.this.config.getShutdownPort()) {
                        MainLauncherUI.this.config.setShutdownPort(newPort);
                    }
                }
                catch (NumberFormatException e) {
                    MainLauncherUI.this.shutdownPortField.setText(Integer.toString(MainLauncherUI.this.config.getShutdownPort()));
                }
            }
        });
        this.optionsPanel.add((Component)new JLabel("Shutdown Port:"), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.optionsPanel.add((Component)this.shutdownPortField, new GridBagConstraints(1, 3, 1, 1, 0.75, 0.0, 18, 2, new Insets(2, 2, 2, 2), 0, 0));
        JButton saveButton = new JButton("Save Preferences");
        saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "Save current options for future sessions?", "Save Preferences", 0) == 0) {
                    prefs.putBoolean(OPTION_ENABLE_DEBUG, MainLauncherUI.this.debugCheckbox.isSelected());
                    prefs.putBoolean(OPTION_ENABLE_LIVELAYOUT, MainLauncherUI.this.noLiveCheckbox.isSelected());
                    try {
                        Main.setDefaultTomcatConfiguration(MainLauncherUI.this.config);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "Error storing server configuration information:\n" + e.getMessage(), "Save Preferences", 0, 0);
                    }
                    catch (URISyntaxException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        this.optionsPanel.add((Component)saveButton, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 14, 0, new Insets(2, 2, 2, 2), 0, 0));
    }

    private void init() {
        this.setDefaultCloseOperation(3);
        this.setLayout(new GridBagLayout());
        this.startButton = new JButton("Start WaveMaker");
        this.add((Component)this.startButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.stopButton = new JButton("Stop WaveMaker");
        this.stopButton.setEnabled(false);
        this.add((Component)this.stopButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.initOptions();
        this.optionsPanel.setVisible(false);
        this.optionsButton = new JButton("Advanced >>");
        this.add((Component)this.optionsButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)this.optionsPanel, new GridBagConstraints(0, 2, 3, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.statusBar = new JPanel();
        this.statusBar.setLayout(new GridBagLayout());
        this.statusBar.setBorder(new SoftBevelBorder(1));
        JLabel label = new JLabel("ServerPort:");
        this.statusBar.add((Component)label, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.servicePortStatus = new JLabel(this.servicePortField.getText());
        this.statusBar.add((Component)this.servicePortStatus, new GridBagConstraints(1, 0, 1, 1, 0.2, 0.0, 17, 0, new Insets(0, 2, 0, 0), 0, 0));
        label = new JLabel("ShutdownPort:");
        this.statusBar.add((Component)label, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.shutdownPortStatus = new JLabel(this.shutdownPortField.getText());
        this.statusBar.add((Component)this.shutdownPortStatus, new GridBagConstraints(3, 0, 1, 1, 0.2, 0.0, 17, 0, new Insets(0, 2, 0, 0), 0, 0));
        label = new JLabel("Status:");
        this.statusBar.add((Component)label, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.serverStatus = new JLabel("Stopped");
        this.statusBar.add((Component)this.serverStatus, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 0), 0, 0));
        this.add((Component)this.statusBar, new GridBagConstraints(0, 3, 3, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.config.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName() == "ShutdownPort") {
                    MainLauncherUI.this.shutdownPortField.setText(Integer.toString(MainLauncherUI.this.config.getShutdownPort()));
                    MainLauncherUI.this.shutdownPortStatus.setText(Integer.toString(MainLauncherUI.this.config.getShutdownPort()));
                } else if (evt.getPropertyName() == "ServicePort") {
                    MainLauncherUI.this.servicePortField.setText(Integer.toString(MainLauncherUI.this.config.getServicePort()));
                    MainLauncherUI.this.servicePortStatus.setText(Integer.toString(MainLauncherUI.this.config.getServicePort()));
                }
            }
        });
        this.startButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MainLauncherUI.this.startButton.setEnabled(false);
                MainLauncherUI.this.stopButton.setEnabled(true);
                if (MainLauncherUI.this.appServer == null) {
                    try {
                        Main.printlnToLog("Starting WaveMaker ");
                        Server.ValidateConfig(MainLauncherUI.this.config);
                        MainLauncherUI.this.appServer = Main.getServerInstance(MainLauncherUI.this.config, false);
                        MainLauncherUI.this.appServer.getLauncher().addLifecycleListener(new LifecycleListener(){

                            @Override
                            public void lifecycleEvent(LifecycleEvent event) {
                                if ("init".equals(event.getType())) {
                                    MainLauncherUI.this.serverStatus.setText("Initializing");
                                } else if ("before_start".equals(event.getType())) {
                                    MainLauncherUI.this.serverStatus.setText("Starting");
                                } else if ("start".equals(event.getType())) {
                                    MainLauncherUI.this.serverStatus.setText("Started");
                                } else if ("after_start".equals(event.getType())) {
                                    MainLauncherUI.this.serverStatus.setText("Running");
                                } else if ("before_stop".equals(event.getType())) {
                                    MainLauncherUI.this.serverStatus.setText("Stopping");
                                } else if ("after_stop".equals(event.getType())) {
                                    MainLauncherUI.this.serverStatus.setText("Stopped");
                                }
                            }
                        });
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    catch (URISyntaxException e) {
                        e.printStackTrace();
                    }
                    catch (InvalidServerConfigurationException e) {
                        JOptionPane.showMessageDialog(MainLauncherUI.this.getParent(), "Unable to locate an available port.");
                        Main.printlnToLog(e.getMessage());
                        if (Main.logOut != null) {
                            e.printStackTrace(Main.logOut);
                        }
                        e.printStackTrace();
                    }
                }
                if (MainLauncherUI.this.appServer != null && MainLauncherUI.this.appServer.getStatus() != AppServer.SERVER_STATUS.RUNNING) {
                    MainLauncherUI.this.appServer.start();
                    for (int i = 0; i < 600 && MainLauncherUI.this.appServer.getStatus() != AppServer.SERVER_STATUS.RUNNING; ++i) {
                        try {
                            Thread.sleep(100L);
                            continue;
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    if (MainLauncherUI.this.appServer.getStatus() != AppServer.SERVER_STATUS.RUNNING) {
                        JOptionPane.showMessageDialog(MainLauncherUI.this.getParent(), "Server did not start. Server Status: " + (Object)((Object)MainLauncherUI.this.appServer.getStatus()));
                    }
                }
                if (MainLauncherUI.this.appServer != null && MainLauncherUI.this.appServer.getStatus() == AppServer.SERVER_STATUS.RUNNING) {
                    MainLauncherUI.this.stopButton.setEnabled(true);
                    MainLauncherUI.this.openBrowser();
                } else {
                    MainLauncherUI.this.stopButton.setEnabled(false);
                }
                MainLauncherUI.this.startButton.setEnabled(true);
            }
        });
        this.stopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (MainLauncherUI.this.appServer != null) {
                    MainLauncherUI.this.appServer.stop();
                }
                MainLauncherUI.this.stopButton.setEnabled(false);
            }
        });
        this.optionsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (MainLauncherUI.this.optionsPanel.isVisible()) {
                    MainLauncherUI.this.optionsButton.setText("Advanced >>");
                    MainLauncherUI.this.optionsPanel.setVisible(false);
                } else {
                    MainLauncherUI.this.optionsPanel.setVisible(true);
                    MainLauncherUI.this.optionsButton.setText("Advanced <<");
                }
                MainLauncherUI.this.pack();
            }
        });
    }

    public void clickStart() {
        this.serverStatus.setText("Starting");
        this.startButton.doClick();
    }

    public void openBrowser() {
        String attributes = "";
        if (this.debugCheckbox.isSelected()) {
            attributes = attributes + "?debug";
        }
        if (!this.noLiveCheckbox.isSelected()) {
            attributes = attributes.length() == 0 ? attributes + "?nolive" : attributes + "&nolive";
        }
        try {
            URL target = new URL("http://localhost:" + this.config.getServicePort() + "/" + "wavemaker" + "/" + attributes);
            BrowserLauncher.openURL(target);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }
}

