/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.desktop.launcher.ui;

import com.wavemaker.desktop.launcher.ui.CancelEvent;
import com.wavemaker.desktop.launcher.ui.CancelListener;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.DisplayMode;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JProgressBar;

public class ProgressDialog
extends JDialog {
    private static final long serialVersionUID = -8319548537136757995L;
    protected boolean allowCancel;
    protected boolean allowVetoes;
    protected boolean isRunning;
    protected Thread thread;
    protected JLabel messageLabel;
    protected JButton cancelButton;
    protected JProgressBar progress;
    protected ArrayList<CancelListener> listeners = new ArrayList();

    public ProgressDialog() {
        this.dialogInit();
        this.isRunning = false;
        this.messageLabel = new JLabel("");
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setEnabled(false);
        this.progress = new JProgressBar();
        this.progress.setIndeterminate(true);
        this.init();
    }

    public ProgressDialog(String title, String message, boolean allowCancel, boolean allowVeto) {
        this.dialogInit();
        this.allowCancel = allowCancel;
        this.allowVetoes = allowVeto;
        this.isRunning = false;
        this.setTitle(title);
        this.messageLabel = new JLabel(message);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setEnabled(allowCancel);
        this.progress = new JProgressBar();
        this.progress.setIndeterminate(true);
        this.init();
    }

    public static void main(String[] args) {
        ProgressDialog pd = new ProgressDialog("Test Progress", "This is a test of the emergency progress system.", true, false);
        pd.start();
    }

    public void addCancelListener(CancelListener listener) {
        this.listeners.add(listener);
        if (this.allowCancel) {
            this.cancelButton.setEnabled(true);
        }
    }

    public void removeCancelListener(CancelListener listener) {
        this.listeners.remove(listener);
        if (this.listeners.size() == 0) {
            this.cancelButton.setEnabled(false);
        }
    }

    protected void notifyListeners() {
        if (this.isVetoable()) {
            for (CancelListener listener : this.listeners) {
                if (listener.cancelRequested(new CancelEvent()) || !this.isVetoable()) continue;
                return;
            }
        }
        for (CancelListener listener : this.listeners) {
            listener.cancelPerformed(new CancelEvent());
        }
        this.dispose();
    }

    public boolean isCancellable() {
        return this.allowCancel;
    }

    public boolean isVetoable() {
        return this.allowVetoes;
    }

    protected void init() {
        this.setDefaultCloseOperation(0);
        this.setSize(300, 200);
        this.progress.setVisible(true);
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.messageLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.getContentPane().add((Component)this.progress, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.getContentPane().add((Component)this.cancelButton, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.pack();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        DisplayMode display = ge.getDefaultScreenDevice().getDisplayMode();
        this.setLocation(display.getWidth() / 2 - this.getWidth() / 2, display.getHeight() / 2 - this.getHeight() / 2);
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.cancelButton.setCursor(Cursor.getDefaultCursor());
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ProgressDialog.this.notifyListeners();
            }
        });
    }

    public void setCancellable(boolean allowCancel) {
        this.allowCancel = allowCancel;
        if (this.allowCancel && this.listeners.size() > 0) {
            this.cancelButton.setEnabled(true);
        }
    }

    public void setIndeterminate(boolean state) {
        this.progress.setIndeterminate(true);
    }

    public void setVetoable(boolean allowVetoes) {
        this.allowVetoes = allowVetoes;
    }

    public void start() {
        this.thread = new Thread(new Runnable(){

            @Override
            public void run() {
                ProgressDialog.this.setVisible(true);
            }
        });
        this.isRunning = true;
        this.thread.start();
    }

    public void stop() {
        this.isRunning = false;
        this.setVisible(false);
        try {
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

