/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.desktop.launcher.ui;

import com.wavemaker.desktop.launcher.Main;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class StudioUpgradeDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private boolean normalClose = false;
    protected String version;
    protected File projectsDir;
    protected File existingDir;
    protected JButton okButton;
    protected JRadioButton oldProjectsButton;
    protected JRadioButton copyProjectsButton;
    protected JPanel subPanel;
    protected JTextField projectsPathField;
    protected JButton browseButton;

    public StudioUpgradeDialog(String version, File existingProjectsDirectory, File defaultProjectsDirectory, boolean majorUpgrade) {
        this.dialogInit();
        this.version = version;
        this.existingDir = existingProjectsDirectory;
        this.projectsDir = existingProjectsDirectory;
        if (defaultProjectsDirectory != null) {
            this.projectsDir = defaultProjectsDirectory;
        }
        this.oldProjectsButton = new JRadioButton("Share projects directory with the previous version at \"" + this.existingDir.getAbsolutePath() + "\"");
        this.copyProjectsButton = new JRadioButton("Copy projects from \"" + this.existingDir.getAbsolutePath() + "\" to a new project directory.");
        this.projectsPathField = new JTextField(this.projectsDir.getAbsolutePath());
        ButtonGroup optionsGroup = new ButtonGroup();
        optionsGroup.add(this.oldProjectsButton);
        optionsGroup.add(this.copyProjectsButton);
        if (majorUpgrade) {
            this.copyProjectsButton.setSelected(true);
        } else {
            this.oldProjectsButton.setSelected(true);
        }
        this.init();
        this.setModal(true);
        this.setSize(this.getPreferredSize());
        this.updateSubPanel();
    }

    public StudioUpgradeDialog(String version, File existingProjectsDirectory, File defaultProjectsDirectory) {
        this(version, existingProjectsDirectory, defaultProjectsDirectory, false);
    }

    private void init() {
        this.setTitle("WaveMaker Studio Upgrade:");
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                if (!StudioUpgradeDialog.this.normalClose) {
                    Main.printlnToConsole("User terminated application.");
                    System.exit(0);
                }
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)new JLabel("<html>Congratulations! You have successfully installed WaveMaker v" + this.version + "<P>Clear your browser's cache of previous version to ensure proper operation of Studio</html>"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.getContentPane().add((Component)this.oldProjectsButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.getContentPane().add((Component)new JLabel("Or"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.getContentPane().add((Component)this.copyProjectsButton, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.subPanel = new JPanel();
        this.subPanel.setLayout(new GridBagLayout());
        this.subPanel.setBorder(new TitledBorder("Project Settings:"));
        this.getContentPane().add((Component)this.subPanel, new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.subPanel.add((Component)new JLabel("New Projects Directory:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.1, 13, 3, new Insets(2, 2, 2, 2), 0, 0));
        this.subPanel.add((Component)this.projectsPathField, new GridBagConstraints(1, 0, 1, 1, 0.6, 0.1, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.browseButton = new JButton("Browse...");
        this.subPanel.add((Component)this.browseButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.1, 17, 3, new Insets(2, 2, 2, 2), 0, 0));
        this.okButton = new JButton("OK");
        this.getContentPane().add((Component)this.okButton, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 2, 4, 2), 0, 0));
        this.pack();
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                JFileChooser jfc = new JFileChooser(StudioUpgradeDialog.this.existingDir);
                jfc.setFileSelectionMode(1);
                if (jfc.showOpenDialog(null) == 0) {
                    File temp = jfc.getSelectedFile();
                    if (temp.isFile()) {
                        temp = temp.getParentFile();
                    }
                    StudioUpgradeDialog.this.projectsDir = temp;
                    StudioUpgradeDialog.this.projectsPathField.setText(StudioUpgradeDialog.this.projectsDir.getAbsolutePath());
                }
            }
        });
        this.oldProjectsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                StudioUpgradeDialog.this.updateSubPanel();
            }
        });
        this.copyProjectsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                StudioUpgradeDialog.this.updateSubPanel();
            }
        });
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                File proposed;
                boolean success = true;
                if (StudioUpgradeDialog.this.upgradeSelected() && !(proposed = new File(StudioUpgradeDialog.this.projectsPathField.getText())).equals(StudioUpgradeDialog.this.projectsDir)) {
                    if (proposed.exists()) {
                        if (proposed.isDirectory()) {
                            if (proposed.canWrite()) {
                                StudioUpgradeDialog.this.projectsDir = proposed;
                            } else {
                                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "Unable to write to \"" + proposed.getAbsolutePath() + "\".\nPlease correct the permissions or select a different location.", "Error Opening Projects Directory:", 0);
                                success = false;
                            }
                        } else {
                            JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\"" + proposed.getAbsolutePath() + "\" is not a directory.\nPlease select a different location.", "Error Opening Projects Directory:", 0);
                            success = false;
                        }
                    } else if (proposed.mkdirs()) {
                        StudioUpgradeDialog.this.projectsDir = proposed;
                    } else {
                        JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "", "Error Creating Projects Directory:", 0);
                        success = false;
                    }
                }
                if (success) {
                    StudioUpgradeDialog.this.normalClose = true;
                    StudioUpgradeDialog.this.dispose();
                }
            }
        });
    }

    public File getSelectedProjectsPath() {
        return this.projectsDir;
    }

    protected void updateSubPanel() {
        boolean isUpgrade = this.upgradeSelected();
        if (!isUpgrade) {
            this.projectsDir = this.existingDir;
        }
        for (int i = this.subPanel.getComponentCount() - 1; i >= 0; --i) {
            this.subPanel.getComponent(i).setEnabled(isUpgrade);
        }
    }

    public boolean upgradeSelected() {
        return this.copyProjectsButton.isSelected();
    }
}

