/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.desktop.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.catalina.util.Base64;

public class TomcatUndeployer {
    private static final String MANAGER_CHARSET = "utf-8";
    private static final String URL_ENCODE_CHARSET = "ISO-8859-1";
    private String username = "manager";
    private String password = "manager";
    private String managerUri = "manager";
    private InetAddress ip = null;
    private int port = 8080;

    public String undeploy(String contextRoot, Map<String, String> props) {
        for (Map.Entry<String, String> mapEntry : props.entrySet()) {
            String key = mapEntry.getKey();
            String val = mapEntry.getValue();
            if (key.equals("tomcat.host")) {
                this.setHost(val);
                continue;
            }
            if (key.equals("tomcat.port")) {
                this.port = Integer.parseInt(val);
                continue;
            }
            if (key.equals("tomcat.manager.username")) {
                this.username = val;
                continue;
            }
            if (!key.equals("tomcat.manager.password")) continue;
            this.password = val;
        }
        contextRoot = this.checkContextRoot(contextRoot);
        return this.toString(this.getResponse(this.getManagerGetConnection("undeploy?" + this.getPathParam(contextRoot))), "");
    }

    private void setHost(String host) {
        try {
            this.ip = InetAddress.getByName(host);
        }
        catch (UnknownHostException ex) {
            throw new RuntimeException(ex);
        }
    }

    private String toString(Collection c, String sep) {
        StringBuilder sb = new StringBuilder();
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            sb.append(String.valueOf(iter.next()));
            if (!iter.hasNext()) continue;
            sb.append(sep);
        }
        return sb.toString();
    }

    private String getManagerUri() {
        return this.managerUri;
    }

    private String getPathParam(String contextRoot) {
        try {
            return "path=" + URLEncoder.encode(contextRoot, URL_ENCODE_CHARSET);
        }
        catch (UnsupportedEncodingException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    private HttpURLConnection getManagerGetConnection(String command) {
        HttpURLConnection rtn = this.getGetConnection(this.getManagerUri() + "/" + command);
        return this.prepareConnection(rtn);
    }

    private HttpURLConnection getGetConnection(String uri) {
        HttpURLConnection rtn = this.getConnection(uri);
        try {
            rtn.setRequestMethod("GET");
        }
        catch (ProtocolException ex) {
            throw new RuntimeException(ex);
        }
        rtn.setDoOutput(false);
        return rtn;
    }

    private HttpURLConnection getConnection(String uri) {
        if (uri == null) {
            throw new IllegalArgumentException("uri cannot be null");
        }
        HttpURLConnection rtn = null;
        try {
            String url = "http://" + this.ip.getHostName() + ":" + this.port + "/" + uri;
            rtn = (HttpURLConnection)new URL(url).openConnection();
        }
        catch (MalformedURLException ex) {
            throw new AssertionError((Object)ex);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        rtn.setAllowUserInteraction(false);
        rtn.setDoInput(true);
        rtn.setUseCaches(false);
        return rtn;
    }

    private HttpURLConnection prepareConnection(HttpURLConnection con) {
        con.setRequestProperty("User-Agent", "Catalina-Ant-Task/1.0");
        String input = this.username + ":" + this.password;
        String output = new String(Base64.encode(input.getBytes()));
        con.setRequestProperty("Authorization", "Basic " + output);
        try {
            con.connect();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return con;
    }

    private List<String> getResponse(HttpURLConnection con) {
        return this.getResponse(con, true);
    }

    private List<String> getResponse(HttpURLConnection con, boolean includeStatus) {
        ArrayList<String> rtn = new ArrayList<String>();
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(con.getInputStream(), MANAGER_CHARSET));
            String line = "";
            boolean isFirst = true;
            while ((line = br.readLine()) != null) {
                if (isFirst && !line.startsWith("OK")) {
                    throw new RuntimeException(line);
                }
                if (!isFirst || includeStatus) {
                    rtn.add(line.trim());
                }
                isFirst = false;
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return rtn;
    }

    private String checkContextRoot(String contextRoot) {
        if (contextRoot == null) {
            throw new IllegalArgumentException("contextRoot cannot be null");
        }
        if (!contextRoot.startsWith("/")) {
            return "/" + contextRoot;
        }
        return contextRoot;
    }
}

