/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.common.util;

import com.wavemaker.common.Resource;
import com.wavemaker.common.util.FileAccessException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.io.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IOUtils {
    private static final int DEFAULT_BUFFER_SIZE = 1024;
    public static final List<String> DEFAULT_EXCLUSION = Collections.unmodifiableList(Arrays.asList(".svn"));

    private IOUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String read(File f) throws IOException {
        StringBuilder fileSB = new StringBuilder();
        char[] buf = new char[1024];
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(f));
            while (br.ready()) {
                int readlen = br.read(buf);
                fileSB.append(buf, 0, readlen);
            }
            String string = fileSB.toString();
            return string;
        }
        finally {
            try {
                br.close();
            }
            catch (Exception ignore) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(File f, String s) throws IOException {
        f.getParentFile().mkdirs();
        BufferedWriter br = null;
        try {
            br = new BufferedWriter(new FileWriter(f));
            br.write(s);
        }
        finally {
            try {
                br.close();
            }
            catch (Exception exception) {}
        }
    }

    public static boolean compare(InputStream i1, InputStream i2) throws IOException {
        int b1 = 0;
        while ((b1 = i1.read()) != -1) {
            int b2 = i2.read();
            if (b2 == -1) {
                return false;
            }
            if (b1 == b2) continue;
            return false;
        }
        return i2.read() == -1;
    }

    public static int countFoldersInDir(File f) {
        int count = 0;
        try {
            File[] listing = f.listFiles();
            for (int i = 0; i < listing.length; ++i) {
                if (!listing[i].isDirectory() || listing[i].getName().startsWith(".") || listing[i].getName().startsWith("_")) continue;
                ++count;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return count;
    }

    public static void copy(InputStream is, OutputStream os) throws IOException {
        org.apache.commons.io.IOUtils.copy(is, os);
    }

    public static void copy(File source, File destination) throws IOException {
        IOUtils.copy(source, destination, new ArrayList<String>());
    }

    public static void copy(File source, File destination, List<String> excludes) throws IOException {
        if (!source.exists()) {
            throw new IOException("Can't copy from non-existent file: " + source.getAbsolutePath());
        }
        if (excludes.contains(source.getName())) {
            return;
        }
        if (source.isDirectory()) {
            if (!destination.exists()) {
                FileUtils.forceMkdir(destination);
            }
            if (!destination.isDirectory()) {
                throw new IOException("Can't copy directory (" + source.getAbsolutePath() + ") to non-directory: " + destination.getAbsolutePath());
            }
            File[] files = source.listFiles();
            for (int i = 0; i < files.length; ++i) {
                IOUtils.copy(files[i], new File(destination, files[i].getName()), excludes);
            }
        } else if (source.isFile()) {
            if (destination.isDirectory()) {
                destination = new File(destination, source.getName());
            }
            FileInputStream in = new FileInputStream(source);
            FileOutputStream out = new FileOutputStream(destination);
            IOUtils.copy(in, out);
            ((InputStream)in).close();
            ((OutputStream)out).close();
        } else {
            throw new IOException("Don't know how to copy " + source.getAbsolutePath() + "; it's neither a directory nor a file");
        }
    }

    public static File createTempDirectory() throws IOException {
        return IOUtils.createTempDirectory("fileUtils_createTempDirectory", null);
    }

    public static File createTempDirectory(String prefix, String suffix) throws IOException {
        StringBuilder prefixSB = new StringBuilder(prefix);
        while (prefixSB.length() < 3) {
            prefixSB.append("a");
        }
        prefix = prefixSB.toString();
        File dir = null;
        IOException exception = null;
        for (int i = 0; i < 10; ++i) {
            try {
                dir = File.createTempFile(prefix, suffix);
                break;
            }
            catch (IOException e) {
                exception = e;
                continue;
            }
        }
        if (null == dir) {
            throw exception;
        }
        if (!dir.delete()) {
            throw new IOException("Couldn't delete: " + dir);
        }
        if (!dir.mkdir()) {
            throw new IOException("Couldn't mkdir: " + dir);
        }
        IOUtils.deleteFileOnShutdown(dir);
        return dir;
    }

    public static void deleteRecursive(File dir) throws IOException {
        FileUtils.forceDelete(dir);
    }

    public static void makeDirectories(File newDir, File topLevel) throws FileAccessException {
        if (newDir.exists()) {
            return;
        }
        if (!topLevel.exists()) {
            throw new FileAccessException(Resource.UTIL_FILEUTILS_PATHDNE, topLevel);
        }
        if (!topLevel.isDirectory()) {
            throw new FileAccessException(Resource.UTIL_FILEUTILS_PATHNOTDIR, topLevel);
        }
        File absNewFile = newDir.getAbsoluteFile();
        IOUtils.makeDirectoriesRecurse(absNewFile, topLevel);
    }

    public static Collection<File> getFiles(File indir) {
        if (!indir.isDirectory()) {
            throw new IllegalArgumentException("Expected directory as input");
        }
        HashSet<File> rtn = new HashSet<File>();
        ArrayList<File> dirs = new ArrayList<File>();
        dirs.add(indir);
        while (!dirs.isEmpty()) {
            String[] files;
            File dir = (File)dirs.remove(0);
            for (String s : files = dir.list()) {
                File f = new File(dir, s);
                if (f.isDirectory()) {
                    dirs.add(f);
                    continue;
                }
                rtn.add(f);
            }
        }
        return rtn;
    }

    private static void makeDirectoriesRecurse(File dir, File topLevel) throws FileAccessException {
        if (dir.equals(topLevel)) {
            return;
        }
        for (File root : File.listRoots()) {
            if (!dir.equals(root)) continue;
            throw new FileAccessException(Resource.UTIL_FILEUTILS_REACHEDROOT, root, topLevel);
        }
        IOUtils.makeDirectoriesRecurse(dir.getParentFile(), topLevel);
        if (!dir.exists()) {
            dir.mkdir();
        }
    }

    public static void touch(File f) throws IOException {
        if (!f.exists()) {
            FileWriter fw = new FileWriter(f);
            fw.close();
        } else {
            f.setLastModified(System.currentTimeMillis());
        }
    }

    public static long getMostRecentModificationTime(File f) {
        return IOUtils.getMostRecentModificationTime(f, ".svn");
    }

    public static long getMostRecentModificationTime(File f, String ... excludes) {
        if (!f.exists()) {
            throw new IllegalArgumentException("File doesn't exist: " + f);
        }
        if (f.isFile()) {
            return f.lastModified();
        }
        long rtn = -1L;
        for (String s : f.list()) {
            for (String exclude : excludes) {
                if (!s.equals(exclude)) continue;
            }
            File f2 = new File(f, s);
            long l = IOUtils.getMostRecentModificationTime(f2);
            if (l <= rtn) continue;
            rtn = l;
        }
        return rtn;
    }

    public static void deleteFileOnShutdown(File file) {
        DeleteFileThread dft = new DeleteFileThread(file);
        Runtime.getRuntime().addShutdownHook(dft);
    }

    public static boolean excludeByExactMatch(File file) {
        return DEFAULT_EXCLUSION.contains(file.getName());
    }

    private static class DeleteFileThread
    extends Thread {
        private final File toBeDeleted;

        public DeleteFileThread(File toBeDeleted) {
            this.toBeDeleted = toBeDeleted;
        }

        public void run() {
            try {
                FileUtils.forceDelete(this.toBeDeleted);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

