/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.common.util;

import com.wavemaker.common.util.ObjectAccess;
import com.wavemaker.common.util.ObjectUtils;
import com.wavemaker.common.util.TypeConversionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectGraphTraversal {
    private static final ObjectVisitor NOOP_VISITOR = new ObjectVisitor(){

        public void visit(Object o, Context ctx) {
        }

        public void cycle(Object o, Context ctx) {
        }
    };
    private final PropertyFactory propertyFactory;
    private final ObjectVisitor objectVisitor;
    private final ObjectAccess objectAccess;
    private boolean propertiesAreBeanProperties = true;

    public ObjectGraphTraversal(PropertyFactory propertyFactory) {
        this(propertyFactory, NOOP_VISITOR);
    }

    public ObjectGraphTraversal(PropertyFactory propertyFactory, ObjectAccess objectAccess) {
        this(propertyFactory, NOOP_VISITOR, objectAccess);
    }

    public ObjectGraphTraversal(PropertyFactory propertyFactory, ObjectVisitor objectVisitor) {
        this(propertyFactory, objectVisitor, ObjectAccess.getInstance());
    }

    public ObjectGraphTraversal(PropertyFactory propertyFactory, ObjectVisitor objectVisitor, ObjectAccess objectAccess) {
        this.propertyFactory = propertyFactory;
        this.objectVisitor = objectVisitor;
        this.objectAccess = objectAccess;
    }

    public void setBeanProperties(boolean b) {
        this.propertiesAreBeanProperties = b;
    }

    public void traverse(Object root) {
        this.traverse(root, null);
    }

    public void traverse(Object root, Object rootContextValue) {
        Context ctx = new Context();
        ctx.valueStack.add(rootContextValue);
        HashSet<Object> alreadyVisited = new HashSet<Object>();
        alreadyVisited.add(root);
        this.traverseInternal(root, ctx, alreadyVisited);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void traverseInternal(Object o, Context ctx, Collection<Object> alreadyVisited) {
        Collection<String> properties = this.propertyFactory.getProperties(o, ctx);
        Iterator<String> i$ = properties.iterator();
        while (i$.hasNext()) {
            String property;
            String methodName = property = i$.next();
            Object propval = null;
            propval = this.propertiesAreBeanProperties ? this.objectAccess.getProperty(o, methodName) : this.objectAccess.invoke(o, methodName);
            if (propval == null) continue;
            ctx.valueStack.add(0, null);
            ctx.parents.add(0, o);
            ctx.properties.add(0, property);
            try {
                if (propval instanceof Map || propval instanceof Collection) {
                    Collection propsvals = null;
                    propsvals = propval instanceof Map ? ((Map)propval).values() : (Collection)propval;
                    for (Object val : propsvals) {
                        this.visitAndRecurse(val, ctx, alreadyVisited);
                    }
                    continue;
                }
                this.visitAndRecurse(propval, ctx, alreadyVisited);
            }
            finally {
                ctx.valueStack.remove(0);
                ctx.parents.remove(0);
                ctx.properties.remove(0);
            }
        }
    }

    private void visitAndRecurse(Object o, Context ctx, Collection<Object> alreadyVisited) {
        if (!TypeConversionUtils.isPrimitiveOrWrapper(o.getClass())) {
            if (alreadyVisited.contains(o)) {
                this.objectVisitor.cycle(o, ctx);
                return;
            }
            alreadyVisited.add(o);
        }
        this.objectVisitor.visit(o, ctx);
        this.traverseInternal(o, ctx, alreadyVisited);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Context {
        private List<Object> parents = new ArrayList<Object>();
        private List<String> properties = new ArrayList<String>();
        private List<Object> valueStack = new ArrayList<Object>();

        public List<?> getParents() {
            return this.parents;
        }

        public List<String> getProperties() {
            return this.properties;
        }

        public List<Object> getValues() {
            return this.valueStack;
        }

        public String getPropertyPath() {
            ArrayList<String> l = new ArrayList<String>(this.getProperties());
            Collections.reverse(l);
            return ObjectUtils.toString(l, ".");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface PropertyFactory {
        public Collection<String> getProperties(Object var1, Context var2);
    }

    public static interface ObjectVisitor {
        public void visit(Object var1, Context var2);

        public void cycle(Object var1, Context var2);
    }
}

