/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.common.util;

import java.io.File;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringUtils {
    public static final String VALUE_ELEMENT = "value";

    private SpringUtils() {
        throw new UnsupportedOperationException();
    }

    public static Object getRuntimeBean(File webAppRoot, String beanName) {
        GenericApplicationContext ctx = new GenericApplicationContext();
        XmlBeanDefinitionReader xmlReader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)ctx);
        File f = new File(webAppRoot, "WEB-INF/project-springapp.xml");
        xmlReader.loadBeanDefinitions((Resource)new FileSystemResource(f));
        ctx.refresh();
        return ctx.getBean(beanName);
    }

    public static GenericApplicationContext initSpringConfig() {
        return SpringUtils.initSpringConfig(true);
    }

    public static Object getBean(File cfg, String beanName) {
        return SpringUtils.getBean((Resource)new FileSystemResource(cfg), beanName);
    }

    public static Object getBean(String cfg, String beanName) {
        return SpringUtils.getBean((Resource)new ClassPathResource(cfg), beanName);
    }

    public static Object getBean(Resource resource, String beanName) {
        GenericApplicationContext ctx = SpringUtils.initSpringConfig(false);
        XmlBeanDefinitionReader xmlReader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)ctx);
        xmlReader.loadBeanDefinitions(resource);
        ctx.refresh();
        return ctx.getBean(beanName);
    }

    private static GenericApplicationContext initSpringConfig(boolean refresh) {
        GenericApplicationContext ctx = new GenericApplicationContext();
        XmlBeanDefinitionReader xmlReader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)ctx);
        xmlReader.loadBeanDefinitions((Resource)new ClassPathResource("config.xml"));
        if (refresh) {
            ctx.refresh();
        }
        return ctx;
    }

    public static void throwSpringNotInitializedError(Class<?> uninitializedBean) {
        throw new AssertionError((Object)("Spring has not initialized " + uninitializedBean.getName()));
    }
}

