/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.common.util;

import com.wavemaker.common.util.ObjectUtils;
import com.wavemaker.common.util.Tuple;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.math.NumberUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringUtils {
    public static final String JAVA_SRC_EXT = ".java";
    private static final Collection<String> JAVA_KEYWORDS = new HashSet<String>(50);

    public static String toString(Throwable th) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        th.printStackTrace(pw);
        String rtn = sw.toString();
        pw.close();
        return rtn;
    }

    public static boolean hasUpperCase(String s) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (!Character.isUpperCase(c)) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidJavaIdentifier(String s) {
        return StringUtils.toJavaIdentifier(s).equals(s);
    }

    public static String toJavaIdentifier(String s) {
        return StringUtils.toJavaIdentifier(s, '_');
    }

    public static String toJavaIdentifier(String s, char replacementChar) {
        if (ObjectUtils.isNullOrEmpty(s)) {
            throw new IllegalArgumentException("input cannot be null or empty");
        }
        String unquoted = StringUtils.unquote(s);
        if (unquoted.length() > 0) {
            s = unquoted;
        }
        if ((s = s.replace("$", "")).length() == 0) {
            s = "" + replacementChar;
        }
        StringBuilder rtn = new StringBuilder();
        if (JAVA_KEYWORDS.contains(s.toLowerCase()) || !Character.isJavaIdentifierStart(s.charAt(0))) {
            rtn.append(replacementChar);
        }
        if (s.length() == 1) {
            if (rtn.length() > 0) {
                return rtn.toString();
            }
            return s;
        }
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (!Character.isJavaIdentifierPart(c)) {
                c = replacementChar;
            }
            rtn.append(c);
        }
        return rtn.toString();
    }

    public static List<String> getItemsStartingWith(Collection<String> items, String prefix, boolean removePrefix) {
        ArrayList<String> rtn = new ArrayList<String>();
        for (String s : items) {
            if (!s.startsWith(prefix)) continue;
            if (removePrefix) {
                s = s.substring(prefix.length());
            }
            rtn.add(s);
        }
        return rtn;
    }

    public static String getFormattedDate() {
        SimpleDateFormat f = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
        return f.format(new Date());
    }

    public static Tuple.Two<String, String> splitPackageAndClass(String s) {
        int i = s.lastIndexOf(".");
        if (i == -1) {
            return Tuple.tuple("", s);
        }
        if (i == 0 && s.length() == 1) {
            throw new IllegalArgumentException("Cannot handle \".\"");
        }
        return Tuple.tuple(s.substring(0, i), s.substring(i + 1));
    }

    public static Tuple.Two<String, String> splitPackageAndClass(Class<?> c) {
        return StringUtils.splitPackageAndClass(c.getName());
    }

    public static String doubleQuote(String s) {
        return "\"" + s + "\"";
    }

    public static List<String> split(String s) {
        HashSet<Character> sep = new HashSet<Character>(1);
        sep.add(Character.valueOf(','));
        return StringUtils.split(s, sep);
    }

    public static List<String> split(String s, Collection<Character> sep) {
        ArrayList<String> rtn = new ArrayList<String>();
        boolean inDoubleQuotes = false;
        boolean inSingleQuotes = false;
        int bracesDepth = 0;
        int bracketsDepth = 0;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '{') {
                ++bracesDepth;
            } else if (c == '}') {
                --bracesDepth;
            } else if (c == '[') {
                ++bracketsDepth;
            } else if (c == ']') {
                --bracketsDepth;
            } else if (c == '\'') {
                inSingleQuotes = !inSingleQuotes;
            } else if (c == '\"') {
                inDoubleQuotes = !inDoubleQuotes;
            }
            boolean add = true;
            if (sep.contains(Character.valueOf(c)) && !inDoubleQuotes && !inSingleQuotes && bracesDepth == 0 && bracketsDepth == 0) {
                add = false;
                rtn.add(sb.toString().trim());
                sb.delete(0, sb.length());
            }
            if (!add) continue;
            sb.append(c);
        }
        if (sb.length() > 0) {
            rtn.add(sb.toString().trim());
        }
        return rtn;
    }

    public static String getUniqueName(String name, String names) {
        HashSet<String> c = new HashSet<String>(1);
        c.add(names);
        return StringUtils.getUniqueName(name, c);
    }

    public static String getUniqueName(String name, Collection<String> names) {
        if (!names.contains(name)) {
            return name;
        }
        for (int i = 2; i < Integer.MAX_VALUE; ++i) {
            String newName = name + i;
            if (names.contains(newName)) continue;
            return newName;
        }
        throw new AssertionError((Object)("Cannot get unique name for " + name));
    }

    public static String classNameToClassFilePath(String className) {
        return className.replace(".", "/") + ".class";
    }

    public static String packageToSrcFilePath(String packageName) {
        return packageName.replace(".", "/");
    }

    public static String classNameToSrcFilePath(String className) {
        return className.replace(".", "/") + JAVA_SRC_EXT;
    }

    public static String getPackage(String className) {
        return StringUtils.fromLastOccurrence(className, ".", -1);
    }

    public static String getClassName(String className) {
        return StringUtils.fromLastOccurrence(className, ".", 1);
    }

    public static boolean isFullyQualified(String className) {
        return className.indexOf(".") != -1;
    }

    public static String fq(String packageName, String className) {
        return packageName + "." + className;
    }

    public static String upperCaseFirstLetter(String s) {
        return s.substring(0, 1).toUpperCase() + s.substring(1);
    }

    public static String lowerCaseFirstLetter(String s) {
        return s.substring(0, 1).toLowerCase() + s.substring(1);
    }

    public static String removeIfEndsWith(String s, String end) {
        if (s.endsWith(end)) {
            return s.substring(0, s.length() - end.length());
        }
        return s;
    }

    public static String removeIfStartsWith(String s, String start) {
        if (s.startsWith(start)) {
            return s.substring(start.length());
        }
        return s;
    }

    public static String fromFirstOccurrence(String s, String substring) {
        return StringUtils.fromFirstOccurrence(s, substring, 1);
    }

    public static String fromFirstOccurrence(String s, String substring, int direction) {
        int i = s.indexOf(substring);
        if (i == -1) {
            return s;
        }
        return StringUtils.substring(s, i, substring, direction);
    }

    public static String fromLastOccurrence(String s, String substring) {
        return StringUtils.fromLastOccurrence(s, substring, 1);
    }

    public static String fromLastOccurrence(String s, String substring, int direction) {
        int i = s.lastIndexOf(substring);
        if (i == -1) {
            return s;
        }
        return StringUtils.substring(s, i, substring, direction);
    }

    public static boolean isNumber(String s) {
        return NumberUtils.isNumber((String)s);
    }

    public static boolean isNumber(char c) {
        return Character.isDigit(c);
    }

    public static String unquote(String s) {
        if (s == null) {
            return null;
        }
        if (s.startsWith("'") && s.endsWith("'") || s.startsWith("\"") && s.endsWith("\"") || s.startsWith("`") && s.endsWith("`")) {
            s = s.substring(1, s.length() - 1);
        }
        return s;
    }

    public static String replacePlainStr(String original, String from, String to) {
        int from_length = from.length();
        if (from_length != to.length()) {
            if (from_length == 0 && to.length() != 0) {
                throw new IllegalArgumentException("Replacing the empty string with something was attempted");
            }
            int start = original.indexOf(from);
            if (start == -1) {
                return original;
            }
            char[] original_chars = original.toCharArray();
            StringBuffer buffer = new StringBuffer(original.length());
            int copy_from = 0;
            while (start != -1) {
                buffer.append(original_chars, copy_from, start - copy_from);
                buffer.append(to);
                copy_from = start + from_length;
                start = original.indexOf(from, copy_from);
            }
            buffer.append(original_chars, copy_from, original_chars.length - copy_from);
            return buffer.toString();
        }
        if (from.equals(to)) {
            return original;
        }
        int start = original.indexOf(from);
        if (start == -1) {
            return original;
        }
        StringBuffer buffer = new StringBuffer(original);
        while (start != -1) {
            buffer.replace(start, start + from_length, to);
            start = original.indexOf(from, start + from_length);
        }
        return buffer.toString();
    }

    private static String substring(String s, int i, String substring, int direction) {
        if (direction >= 0) {
            return s.substring(i + substring.length());
        }
        return s.substring(0, i);
    }

    private StringUtils() {
        throw new UnsupportedOperationException();
    }

    static {
        JAVA_KEYWORDS.add("abstract");
        JAVA_KEYWORDS.add("assert");
        JAVA_KEYWORDS.add("boolean");
        JAVA_KEYWORDS.add("break");
        JAVA_KEYWORDS.add("byte");
        JAVA_KEYWORDS.add("case");
        JAVA_KEYWORDS.add("catch");
        JAVA_KEYWORDS.add("char");
        JAVA_KEYWORDS.add("class");
        JAVA_KEYWORDS.add("const");
        JAVA_KEYWORDS.add("continue");
        JAVA_KEYWORDS.add("default");
        JAVA_KEYWORDS.add("do");
        JAVA_KEYWORDS.add("double");
        JAVA_KEYWORDS.add("else");
        JAVA_KEYWORDS.add("enum");
        JAVA_KEYWORDS.add("extends");
        JAVA_KEYWORDS.add("final");
        JAVA_KEYWORDS.add("finally");
        JAVA_KEYWORDS.add("float");
        JAVA_KEYWORDS.add("for");
        JAVA_KEYWORDS.add("goto");
        JAVA_KEYWORDS.add("if");
        JAVA_KEYWORDS.add("implements");
        JAVA_KEYWORDS.add("import");
        JAVA_KEYWORDS.add("instanceof");
        JAVA_KEYWORDS.add("int");
        JAVA_KEYWORDS.add("interface");
        JAVA_KEYWORDS.add("long");
        JAVA_KEYWORDS.add("native");
        JAVA_KEYWORDS.add("new");
        JAVA_KEYWORDS.add("package");
        JAVA_KEYWORDS.add("private");
        JAVA_KEYWORDS.add("protected");
        JAVA_KEYWORDS.add("public");
        JAVA_KEYWORDS.add("return");
        JAVA_KEYWORDS.add("short");
        JAVA_KEYWORDS.add("static");
        JAVA_KEYWORDS.add("strictfp");
        JAVA_KEYWORDS.add("super");
        JAVA_KEYWORDS.add("switch");
        JAVA_KEYWORDS.add("synchronized");
        JAVA_KEYWORDS.add("this");
        JAVA_KEYWORDS.add("throw");
        JAVA_KEYWORDS.add("throws");
        JAVA_KEYWORDS.add("transient");
        JAVA_KEYWORDS.add("try");
        JAVA_KEYWORDS.add("void");
        JAVA_KEYWORDS.add("volatile");
        JAVA_KEYWORDS.add("while");
    }
}

