/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.ws.wadl2java;

import com.sun.codemodel.JClassAlreadyExistsException;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import javax.xml.bind.JAXBException;
import org.jvnet.ws.wadl2java.Wadl2Java;
import org.jvnet.ws.wadl2java.Wadl2JavaMessages;

public class Main {
    protected static void printUsage() {
        System.err.println(Wadl2JavaMessages.USAGE());
    }

    public static void main(String[] args) {
        try {
            URI wadlDesc;
            int i = 0;
            File outputDir = null;
            String pkg = null;
            boolean autoPackage = false;
            ArrayList<File> customizations = new ArrayList<File>();
            while (i < args.length - 2) {
                if (args[i].equals("-o")) {
                    outputDir = new File(args[i + 1]);
                    i += 2;
                    continue;
                }
                if (args[i].equals("-p")) {
                    pkg = args[i + 1];
                    i += 2;
                    continue;
                }
                if (args[i].equals("-c")) {
                    customizations.add(new File(args[i + 1]));
                    i += 2;
                    continue;
                }
                if (args[i].equals("-a")) {
                    autoPackage = true;
                    ++i;
                    continue;
                }
                System.err.println(Wadl2JavaMessages.UNKNOWN_OPTION((Object)args[i]));
                Main.printUsage();
                System.exit(1);
            }
            if (i > args.length - 1 || outputDir == null || pkg == null) {
                Main.printUsage();
                System.exit(1);
            }
            if ((wadlDesc = new URI(args[args.length - 1])).getScheme() == null || wadlDesc.getScheme().equals("file")) {
                File wadlFile = new File(wadlDesc.getPath());
                if (!wadlFile.exists() || !wadlFile.isFile()) {
                    System.err.println(Wadl2JavaMessages.NOT_A_FILE((Object)wadlFile.getPath()));
                    Main.printUsage();
                    System.exit(1);
                }
                if (!outputDir.exists() || !outputDir.isDirectory()) {
                    System.err.println(Wadl2JavaMessages.NOT_A_DIRECTORY((Object)outputDir.getPath()));
                    Main.printUsage();
                    System.exit(1);
                }
                for (File customization : customizations) {
                    if (customization.exists() && customization.isFile()) continue;
                    System.err.println(Wadl2JavaMessages.NOT_A_FILE((Object)customization.getPath()));
                    Main.printUsage();
                    System.exit(1);
                }
                wadlDesc = wadlFile.toURI();
            }
            Wadl2Java w = new Wadl2Java(outputDir, pkg, autoPackage, customizations);
            w.process(wadlDesc);
        }
        catch (URISyntaxException ex) {
            ex.printStackTrace();
        }
        catch (JAXBException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (JClassAlreadyExistsException ex) {
            ex.printStackTrace();
        }
    }
}

