/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.charts.xy;

import com.sun.tools.visualvm.charts.xy.XYItem;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.netbeans.lib.profiler.charts.Timeline;
import org.netbeans.lib.profiler.charts.xy.synchronous.SynchronousXYItem;

public class XYStorage
implements Timeline {
    private static final String SNAPSHOT_HEADER = "XYStorageSnapshot";
    private static final int SNAPSHOT_VERSION = 1;
    public static final long NO_VALUE = Long.MAX_VALUE;
    private int valuesLimit;
    private int bufferStep;
    private int valuesCount;
    private long[] timestamps;
    private long[][] values;
    private int cycleIndex;

    public XYStorage(int valuesLimit, int bufferStep) {
        this.valuesLimit = valuesLimit;
        this.bufferStep = bufferStep;
        this.initialize();
    }

    public synchronized SynchronousXYItem addItem(String name, long minValue, long maxValue) {
        final int itemIndex = this.addItemImpl();
        return new XYItem(name, minValue, maxValue){

            public long getYValue(int valueIndex) {
                return XYStorage.this.getValue(itemIndex, valueIndex);
            }
        };
    }

    public synchronized void addValues(long timestamp, long[] values) {
        this.updateStorage();
        this.setTimestamp(Math.min(this.valuesCount, this.valuesLimit - 1), timestamp);
        for (int i = 0; i < values.length; ++i) {
            this.setValue(i, Math.min(this.valuesCount, this.valuesLimit - 1), values[i]);
        }
        if (this.valuesCount < this.valuesLimit) {
            ++this.valuesCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void saveValues(OutputStream os) throws IOException {
        FilterOutputStream dos = null;
        try {
            int icount = this.values.length;
            int vcount = this.getTimestampsCount();
            dos = new DataOutputStream(os);
            ((DataOutputStream)dos).writeUTF(SNAPSHOT_HEADER);
            ((DataOutputStream)dos).writeInt(1);
            ((DataOutputStream)dos).writeInt(icount);
            ((DataOutputStream)dos).writeInt(vcount);
            for (int vidx = 0; vidx < vcount; ++vidx) {
                ((DataOutputStream)dos).writeLong(this.getTimestamp(vidx));
                for (int iidx = 0; iidx < icount; ++iidx) {
                    ((DataOutputStream)dos).writeLong(this.getValue(iidx, vidx));
                }
            }
        }
        finally {
            if (dos != null) {
                dos.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void loadValues(InputStream is) throws IOException {
        DataInputStream dis = null;
        try {
            dis = new DataInputStream(is);
            if (!SNAPSHOT_HEADER.equals(dis.readUTF())) {
                throw new IOException("Unknown snapshot format");
            }
            if (1 != dis.readInt()) {
                throw new IOException("Unsupported snapshot version");
            }
            if (this.values.length != dis.readInt()) {
                throw new IOException("Snapshot doesn't match number of items");
            }
            int vcount = dis.readInt();
            long[] vals = new long[this.values.length];
            for (int vidx = 0; vidx < vcount; ++vidx) {
                long timestamp = dis.readLong();
                for (int iidx = 0; iidx < vals.length; ++iidx) {
                    vals[iidx] = dis.readLong();
                }
                this.addValues(timestamp, vals);
            }
        }
        finally {
            if (dis != null) {
                dis.close();
            }
        }
    }

    private void initialize() {
        this.reset();
    }

    private void reset() {
        this.valuesCount = 0;
        this.cycleIndex = 0;
        this.timestamps = null;
        if (this.values != null) {
            if (this.values.length == 0) {
                this.values = null;
            } else {
                for (int i = 0; i < this.values.length; ++i) {
                    this.values[i] = new long[this.bufferStep];
                }
            }
        }
    }

    private int addItemImpl() {
        int itemIndex = 0;
        if (this.timestamps == null) {
            this.timestamps = new long[this.bufferStep];
            this.values = new long[1][];
            this.values[0] = new long[this.bufferStep];
        } else {
            this.values = XYStorage.extendArray(this.values, 1);
            itemIndex = this.values.length - 1;
            this.values[itemIndex] = new long[this.timestamps.length];
            if (this.values[itemIndex].length > 0) {
                Arrays.fill(this.values[itemIndex], Long.MAX_VALUE);
            }
        }
        return itemIndex;
    }

    private int getIndex(int index) {
        if (this.cycleIndex != 0 && (index += this.cycleIndex) >= this.valuesCount) {
            index -= this.valuesCount;
        }
        return index;
    }

    public int getTimestampsCount() {
        return this.valuesCount;
    }

    private void setTimestamp(int index, long value) {
        this.timestamps[this.getIndex((int)index)] = value;
    }

    public long getTimestamp(int index) {
        return this.timestamps[this.getIndex(index)];
    }

    private void setValue(int itemIndex, int valueIndex, long value) {
        this.values[itemIndex][this.getIndex((int)valueIndex)] = value;
    }

    private long getValue(int itemIndex, int valueIndex) {
        return this.values[itemIndex][this.getIndex(valueIndex)];
    }

    private void updateStorage() {
        int bufferSize = this.timestamps.length;
        if (this.valuesCount == bufferSize && bufferSize < this.valuesLimit) {
            int extent = Math.min(this.bufferStep, this.valuesLimit - bufferSize);
            this.timestamps = XYStorage.extendArray(this.timestamps, extent);
            for (int i = 0; i < this.values.length; ++i) {
                this.values[i] = XYStorage.extendArray(this.values[i], extent);
            }
            this.cycleIndex = 0;
        } else if (this.valuesCount == this.valuesLimit) {
            ++this.cycleIndex;
            if (this.cycleIndex == this.valuesLimit) {
                this.cycleIndex = 0;
            }
        }
    }

    private static long[] extendArray(long[] array, int extraLength) {
        int originalLength = array.length;
        long[] newArray = new long[originalLength + extraLength];
        System.arraycopy(array, 0, newArray, 0, originalLength);
        return newArray;
    }

    private static long[][] extendArray(long[][] array, int extraLength) {
        int originalLength = array.length;
        long[][] newArray = new long[originalLength + extraLength][];
        System.arraycopy(array, 0, newArray, 0, originalLength);
        return newArray;
    }
}

