/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openide.loaders;

import java.awt.EventQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.Mutex;
import org.openide.util.Task;

public final class AWTTask
extends Task {
    static final LinkedBlockingQueue<AWTTask> PENDING = new LinkedBlockingQueue();
    private static final Runnable PROCESSOR = new Processor();
    private boolean executed;

    public AWTTask(Runnable runnable) {
        super(runnable);
        PENDING.add(this);
        Mutex.EVENT.readAccess(PROCESSOR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (!this.executed) {
            try {
                super.run();
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable) {
                Logger.getLogger("org.openide.awt.Toolbar").log(Level.WARNING, "Error in AWT task", throwable);
            }
            finally {
                this.executed = true;
            }
        }
    }

    public void waitFinished() {
        if (EventQueue.isDispatchThread()) {
            this.run();
        } else {
            super.waitFinished();
        }
    }

    public static final void flush() {
        PROCESSOR.run();
    }

    private static final class Processor
    implements Runnable {
        private Processor() {
        }

        public void run() {
            assert (EventQueue.isDispatchThread());
            AWTTask aWTTask;
            while ((aWTTask = PENDING.poll()) != null) {
                aWTTask.run();
            }
            return;
        }
    }
}

