/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2x.pojo;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.hibernate.tool.hbm2x.pojo.ImportContext;
import org.hibernate.util.StringHelper;

public class ImportContextImpl
implements ImportContext {
    Set imports = new TreeSet();
    Set staticImports = new TreeSet();
    Map simpleNames = new HashMap();
    String basePackage = "";
    private static final Map PRIMITIVES = new HashMap();

    public ImportContextImpl(String string) {
        this.basePackage = string;
    }

    public String importType(String string) {
        String string2 = string;
        String string3 = null;
        if (string.indexOf(60) >= 0) {
            string3 = string2.substring(string.indexOf(60));
            string = string2 = string2.substring(0, string.indexOf(60));
        } else if (string.indexOf(91) >= 0) {
            string3 = string2.substring(string.indexOf(91));
            string = string2 = string2.substring(0, string.indexOf(91));
        }
        String string4 = string.replace('$', '.');
        boolean bl = true;
        String string5 = StringHelper.unqualify((String)string);
        if (this.simpleNames.containsKey(string5)) {
            String string6 = (String)this.simpleNames.get(string5);
            bl = string6.equals(string4);
        } else {
            bl = true;
            this.simpleNames.put(string5, string4);
            this.imports.add(string4);
        }
        if (this.inSamePackage(string) || this.imports.contains(string4) && bl) {
            string2 = StringHelper.unqualify((String)string2);
        } else if (this.inJavaLang(string)) {
            string2 = string2.substring("java.lang.".length());
        }
        if (string3 != null) {
            string2 = string2 + string3;
        }
        string2 = string2.replace('$', '.');
        return string2;
    }

    public String staticImport(String string, String string2) {
        String string3 = string + "." + string2;
        this.imports.add(string3);
        this.staticImports.add(string3);
        if (string2.equals("*")) {
            return "";
        }
        return string2;
    }

    private boolean inDefaultPackage(String string) {
        return string.indexOf(".") < 0;
    }

    private boolean isPrimitive(String string) {
        return PRIMITIVES.containsKey(string);
    }

    private boolean inSamePackage(String string) {
        String string2 = StringHelper.qualifier((String)string);
        return string2 == this.basePackage || string2 != null && string2.equals(this.basePackage);
    }

    private boolean inJavaLang(String string) {
        return "java.lang".equals(StringHelper.qualifier((String)string));
    }

    public String generateImports() {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : this.imports) {
            if (this.isPrimitive(string) || this.inDefaultPackage(string) || this.inJavaLang(string) || this.inSamePackage(string)) continue;
            if (this.staticImports.contains(string)) {
                stringBuffer.append("import static " + string + ";\n");
                continue;
            }
            stringBuffer.append("import " + string + ";\n");
        }
        if (stringBuffer.indexOf("$") >= 0) {
            return stringBuffer.toString();
        }
        return stringBuffer.toString();
    }

    static {
        PRIMITIVES.put("char", "Character");
        PRIMITIVES.put("byte", "Byte");
        PRIMITIVES.put("short", "Short");
        PRIMITIVES.put("int", "Integer");
        PRIMITIVES.put("long", "Long");
        PRIMITIVES.put("boolean", "Boolean");
        PRIMITIVES.put("float", "Float");
        PRIMITIVES.put("double", "Double");
    }
}

