/*
 * Copyright (C) 2010 WaveMaker Software, Inc.
 *
 * This file is part of WaveMaker Studio.
 *
 * WaveMaker Studio is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, version 3 of the License, only.
 *
 * WaveMaker Studio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with WaveMaker Studio.  If not, see <http://www.gnu.org/licenses/>.
 */ 

dependencies = {
	layers: [
		{
			name: "studio_base.js",
			resourceName: "studio_base",
			dependencies: [
				"wm.studio.app.packageLoader",
				"wm.base.lib.util",
				"wm.base.lib.date",
				"wm.base.lib.text",
				"wm.base.lib.types",
				"wm.base.lib.data",
				"wm.base.layout.console",
				"wm.base.data.expression",
				"wm.base.data.SimpleStore",
				"wm.base.drag.capture",
				"wm.base.drag.drag",
				"wm.base.drag.layout",
				"dojox.grid._grid.scroller",
				"dojox.grid._grid.edit",
				"dojox.grid._grid.cell",
				"dojox.grid._grid.builder",
				"dojox.grid._grid.layout",
				"dojox.grid._grid.view",
				"dojox.grid._grid.drag",
				"dojox.grid._grid.lib",
				"dojox.grid._grid.views",
				"dojox.grid._grid.rows",
				"dojox.grid._grid.focus",
				"dojox.grid._grid.selection",
				"dojox.grid._grid.rowbar",
				"dojox.grid._grid.publicEvents",
				"dojox.grid.VirtualGrid",
				"dojox.grid.compat.Grid",
				"dijit.form.TextBox",
				"dijit.form._FormWidget",
				"dijit._Widget",
				"dijit._base",
				"dijit._base.focus",
				"dijit._base.manager",
				"dijit._base.place",
				"dijit._base.popup",
				"dijit._base.window",
				"dijit._base.scroll",
				"dijit._base.sniff",
				"dijit._base.bidi",
				"dijit._base.typematic",
				"dijit._base.wai",
				"dijit._Templated",
				"dojo.string",
				"dojo.parser",
				"dojo.date.stamp",
				"dijit.Tooltip",
				"dijit.form.ComboBox",
				"dojo.date.locale",
				"dojo.date",
				"dojo.regexp",
				"dojo.data.util.simpleFetch",
				"dojo.data.util.sorter",
				"dojo.rpc.JsonService",
				"dojo.rpc.RpcService",
				"dojo.cookie",
				"dijit.form.CheckBox",
				"dijit.form.Button",
				"dijit._Container",
				"dijit.form.DateTextBox",
				"dijit._Calendar",
				"dijit.form._DateTimeTextBox",
				"dijit.form.TimeTextBox",
				"dijit._TimePicker",
				"dijit.form.NumberTextBox",
				"dijit.form.FilteringSelect",
				"dojo.number",
				"dijit.form.CurrencyTextBox",
				"dojo.currency",
				"dijit.form.HorizontalSlider",
				"dijit.form.VerticalSlider",
				"dojo.io.iframe",
				"dijit.ProgressBar",
				"dojo.fx",
				"dijit.form._Spinner",
				"dojox.charting.Chart2D",
				"dojox.charting.Theme",
				"dojox.charting.widget.Legend"
			]
		},
		{
			name: "studio_wm.js",
			resourceName: "studio_wm",
			layerDependencies: [
				"studio_base.js"
			],
			dependencies: [
				"wm.base.Object",
				"wm.base.Component",
				"wm.base.Component_design",
				"wm.base.Control",
				"wm.base.Control_design",
				"wm.base.Widget",
				"wm.base.Widget_design",
				"wm.base.Plugin",
				"wm.base.components.Page",
				"wm.base.components.HtmlLoader",
				"wm.base.components.CssLoader",
				"wm.base.components.PageLoader",
				"wm.base.components.Application",
				"wm.base.components.Property",
				"wm.base.components.Publisher",
				"wm.base.components.ImageList",
				"wm.base.components.Variable",
				"wm.base.components.Binding",
				"wm.base.components.Service",
				"wm.base.components.ServiceQueue",
				"wm.base.components.ServiceCall",
				"wm.base.components.ServiceVariable",
				"wm.base.components.LiveView",
				"wm.base.components.LiveView_design",
				"wm.base.components.LiveVariable",
				"wm.base.components.NavigationCall",
				"wm.base.components.NavigationService",
				"wm.base.components.FunctionService",
				"wm.base.components.JsonRpcService",
				"wm.base.components.Security",
				"wm.base.components.DomMacro",
				"wm.base.widget.Formatters",
				"wm.base.widget.Editors.dijit",
				"wm.base.widget.Editors.Base",
				"wm.base.widget.Editors.Text",
				"wm.base.widget.Editors.Number",
				"wm.base.widget.Editors.Date",
				"wm.base.widget.Editors.Checkbox",
				"wm.base.widget.Editors.Radiobutton",
				"wm.base.widget.Editors.Select",
				"wm.base.widget.Box",
				"wm.base.widget.Box_design",
				"wm.base.widget.Spacer",
				"wm.base.widget.layout.Layout",
				"wm.base.widget.layout.Box",
				"wm.base.widget.layout.Abs",
				"wm.base.widget.Container",
				"wm.base.widget.Panel",
				"wm.base.widget.Template",
				"wm.base.widget.Layout",
				"wm.base.widget.Content",
				"wm.base.widget.Content_design",
				"wm.base.widget.Html",
				"wm.base.widget.Bevel",
				"wm.base.widget.Splitter",
				"wm.base.widget.Splitter_design",
				"wm.base.widget.Layers.Decorator",
				"wm.base.widget.Layers.TabsDecorator",
				"wm.base.widget.Layers.TabsDecorator_design",
				"wm.base.widget.Layers.AccordionDecorator",
				"wm.base.widget.Layers",
				"wm.base.widget.Layers_design",
				"wm.base.widget.Button",
				"wm.base.widget.Picture",
				"wm.base.widget.Tree",
				"wm.base.widget.Label",
				"wm.base.widget.gadget.Gadget",
				"wm.base.widget.gadget.Stocks",
				"wm.base.widget.gadget.Weather",
				"wm.base.widget.gadget.YouTube",
				"wm.base.widget.PageContainer",
				"wm.base.widget.Table.builder",
				"wm.base.widget.VirtualList",
				"wm.base.widget.List",
				"wm.base.widget.FeedList",
				"wm.base.widget.Detail",
				"wm.base.widget.Form",
				"wm.base.widget.LiveForm",
				"wm.base.widget.LiveForm_design",
				"wm.base.widget.LivePanel",
				"wm.base.widget.RelatedEditor",
				"wm.base.widget.RelatedEditor_design",
				"wm.base.widget.EditPanel",
				"wm.base.widget.DataNavigator",
				"wm.base.widget.Input",
				"wm.base.widget.TextArea",
				"wm.base.widget.Select",
				"wm.base.widget.Scrim",
				"wm.base.widget.Dialog",
				"wm.base.widget.Editor",
				"wm.base.widget.FileUpload",
				"wm.base.widget.EditArea",
				"wm.base.widget.EditArea_design",
				"wm.base.widget.Popup",
				"wm.base.widget.IFrame",
				"wm.base.widget.LayoutBox",
				"wm.base.widget.dijit.Dijit",
				"wm.base.widget.dijit.Dijit_design",
				"wm.base.widget.dijit.CheckBox",
				"wm.base.widget.dijit.Calendar",
				"wm.base.widget.dijit.ProgressBar",
				"wm.base.widget.dijit.ProgressBar_design",
				"wm.base.widget.dijit.Grid",
				"wm.base.widget.DataGrid",
				"wm.base.widget.Toolbar",
				"wm.base.widget.Ticker",
				"wm.base.widget.Composite",
				"wm.base.widget.Cards",
				"wm.base.lib.date",
	        	"wm.base.lib.text",
	        	"wm.base.widget.Formatters",
	        	"wm.base.widget.Editors.dijit",
	            "wm.base.widget.Editor",
	            "wm.base.widget.RelatedEditor",
	            "wm.base.widget.Editors.Base",
	            "wm.base.widget.Editors.Text",
	            "wm.base.widget.Editors.Number",
	            "wm.base.widget.Editors.Date",
	            "wm.base.widget.Editors.Checkbox",
	            "wm.base.widget.Editors.Radiobutton",
	            "wm.base.widget.Editors.Select",
	            "wm.base.widget.Editors.Slider",
				"wm.base.widget.Editors.RichText",
				"wm.base.widget.DojoLightbox",
				"wm.base.widget.Dashboard",
				"wm.base.widget.Dashboard_design",
				"wm.base.widget.DojoGrid",
				"wm.base.widget.DojoGrid_design",
				"wm.base.widget.DojoMenu",
				"wm.base.widget.DojoChart",
				"wm.base.widget.DojoFisheye"
				
				
			]
		},
		{
			name: "studio.js",
			resourceName: "studio",
			layerDependencies: [
				"studio_base.js", "studio_wm.js"
			],
			dependencies: [
				"wm.base.design.Designable",
				"wm.base.design.Surface",
				"wm.base.design.Drag",
				"wm.base.design.Wrapper",
				"wm.base.design.Designer",
				"wm.studio.app.StudioApplication",
				"wm.studio.pages.Studio.Studio",
				"wm.studio.app.util",
				"wm.studio.app.mainNavigation",
				"wm.studio.app.keyconfig",
				"wm.studio.app.Palette",
				"wm.studio.app.binding",
				"wm.studio.app.inspector.Inspector",
				"wm.studio.app.inspector.BindInspector",
				"wm.studio.app.inspector.StyleInspector",
				"wm.studio.app.inspector.SecurityInspector",
				"wm.studio.app.inspector.ComponentInspector",
				"wm.studio.app.inspect",
				"wm.studio.app.sourcer",
				"wm.studio.app.events",
				"wm.studio.app.file",
				"wm.studio.app.css",
				"wm.studio.app.project",
				"wm.studio.app.markup",
				"wm.studio.app.actions",
				"wm.studio.app.clipboard",
				"wm.studio.app.trees",
				"wm.studio.app.menu",
				"wm.studio.app.deploy",
				"wm.studio.app.dom",
				"wm.studio.app.propertyEdit",
				"wm.studio.app.data",
				"wm.studio.app.templates.widgetTemplates",
				"wm.studio.app.dataconstants",
				"wm.studio.app.datautils",
				"wm.studio.app.servicesTree",
				"wm.studio.pages.Binder.Binder",
				"wm.studio.pages.BindSourceDialog.BindSourceDialog",
				"wm.studio.pages.ImportPageDialog.ImportPageDialog",
				"wm.studio.pages.CreateLiveView.CreateLiveView",
				"wm.studio.pages.DataObjectsEditor.DataObjectsEditor",
				"wm.studio.pages.DBConnectionSettings.DBConnectionSettings",
				"wm.studio.pages.DDLDialog.DDLDialog",
				"wm.studio.pages.DeploymentDialog.DeploymentDialog",
				"wm.studio.pages.Diagnostics.Diagnostics",
				"wm.studio.pages.ImportDatabase.ImportDatabase",
				"wm.studio.pages.ImportWebService.ImportWebService",
				"wm.studio.pages.JavaEditor.JavaEditor",
				"wm.studio.pages.LiveViewEditor.LiveViewEditor",
				"wm.studio.pages.NavigationDialog.NavigationDialog",
				"wm.studio.pages.NewJavaService.NewJavaService",
				"wm.studio.pages.PreferencesPane.PreferencesPane",
				"wm.studio.pages.QueryEditor.QueryEditor",
				"wm.studio.pages.QueueDialog.QueueDialog",
				"wm.studio.pages.RegistrationDialog.RegistrationDialog",
				"wm.studio.pages.RestServiceBuilder.RestServiceBuilder",
				"wm.studio.pages.RestUrlDialog.RestUrlDialog",
				"wm.studio.pages.Security.Security",
				"wm.studio.pages.ServiceDialog.ServiceDialog",
				"wm.studio.pages.Services.Services",
				"wm.studio.pages.Start.Start"
			]
		}
	],

	prefixes: [
		[ "dijit", "../dijit" ],
		[ "dojox", "../dojox" ],
		[ "wm", "../../wm" ]
	]
}
