/*
 * Copyright (C) 2008-2010 WaveMaker Software, Inc.
 *
 * This file is part of WaveMaker Studio.
 *
 * WaveMaker Studio is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, version 3 of the License, only.
 *
 * WaveMaker Studio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with WaveMaker Studio.  If not, see <http://www.gnu.org/licenses/>.
 */ 
dojo.provide("wm.studio.app.inspector.BindInspector");
dojo.require("wm.studio.app.inspector.Inspector");
dojo.require("wm.studio.app.binding");
dojo.require('wm.base.lib.data');

dojo.declare("wm.BindInspector", wm.GroupInspector, {
	colCount: 3,
	init: function() {
		this.inherited(arguments);
		studio.bindDialog = this.getBindDialog();
	},
	getProps: function(inInspectorProps) {
		var props = this.inherited(arguments);
		for (var i in props)
			if (props[i].isEvent || props[i].isCustomMethod)
				delete props[i];
		return props;
	},
	inspect: function() {
		this.inherited(arguments);
		studio.bindDialog.page.initBinding();
	},
	getBindDialog: function() {
		if (!studio.bindDialog) {
		    var
				props = {
					owner: this,
					pageName: "BindSourceDialog",
				    border: "1px",
				    positionLocation: "tl",
				    width: "550",
				    height: "350",
				    modal: false,
				    hideControls: true,
				    title: "Binding..."
				},
				d = studio.bindDialog = new wm.PageDialog(props);
 
		    //d.setContainerOptions(true, 450, 300);
		}
		var b = studio.bindDialog;

		if (b._hideConnect)
			dojo.disconnect(b._hideConnect);
		b._hideConnect = dojo.connect(b, "onHide", this, "endBind");
		return b;
	},
	generateHeaderCells: function() {
		var r = this.inherited(arguments);
		//r.unshift('<th class="wminspector-header wminspector-binding"></th>');
		r.push('<th class="wminspector-header wminspector-binding"></th>');		
		return r;
	},
	generateRowCells: function(inName, inProp) {
		var
			n = inName,
			bindable = this.isBindable(inProp),
			wire = bindable && this.getPropWire(inProp),
			c = " wminspector-bindProp" + (bindable ? "" : "-disabled"),
			bc = wire ? " wminspector-boundProp" : "",
			b = '';
m=n;
switch (m) {
case 'add':m='追加';break;
case 'addColumn':m='列の追加';break;
case 'addEditors':m='エディタを追加';break;
case 'align':m='配置';break;
case 'allowNone':m='非選択を可';break;
case 'aspect':m='アスペクト';break;
case 'Auto Height':m='自動高さ';break;
case 'Auto Width':m='自動幅';break;
case 'autoColumns':m='自動列';break;
case 'autoComplete':m='入力補助';break;
case 'autoDataSet':m='自動データセット';break;
case 'autoScroll':m='自動スクロール';break;
case 'autoSize':m='自動サイズ調整';break;
case 'autoSizeWidth':m='幅を自動調整';break;
case 'autoUpdate':m='自動更新';break;
case 'bindSource':m='ﾊﾞｲﾝﾄﾞｿｰｽ';break;
case 'bindTarget':m='ﾊﾞｲﾝﾄﾞﾀｰｹﾞｯﾄ';break;
case 'border':m='ボーダー';break;
case 'borderColor':m='ボーダー色';break;
case 'byPage':m='ページ毎';break;
case 'caption':m='見出し';break;
case 'captionAlign':m='見出し配置';break;
case 'captionPosition':m='見出し位置';break;
case 'captionSize':m='見出し長さ';break;
case 'changeOnEnter':m='入力時に変更';break;
case 'changeOnKey':m='入力を表示';break;
case 'chartColor':m='グラフ色';break;
case 'chartType':m='グラフタイプ';break;
case 'checkedValue':m='チェック値';break;
case 'clearColumns':m='列の消去';break;
case 'clearData':m='データを消去';break;
case 'clearInput':m='入力を消去';break;
case 'clickVariable':m='クリック変数';break;
case 'colCount':m='列数';break;
case 'columnWidth':
case 'columnWidths': m='列幅';break;
case 'connectors':m='コネクタ';break;
case 'content':m='内容';break;
case 'currency':m='通貨';break;
case 'dataExpression':m='データ式';break;
case 'dataField':
case 'dataFields':m='データ項目';break;
case 'dataOutput':m='データ出力';break;
case 'dataSet':m='データセット';break;
case 'dataType':m='データ型';break;
case 'dataValue':m='データ値';break;
case 'dateValue':m='日付';break;
case 'defaultButton':m='デフォルトボタン';break;
case 'defaultIconUrl':m='ﾃﾞﾌｫﾙﾄｱｲｺﾝURL';break;
case 'defaultLayer':m='デフォルトレイヤ';break;
case 'deferLoad':m='遅延読込み';break;
case 'delay':m='ディレイ';break;
case 'deploy':m='デプロイ';break;
case 'description':m='説明';break;
case 'designMaxResults':m='設計時最大数';break;
case 'disabled':m='無効';break;
case 'discreteValues':m='離散値';break;
case 'display':m='表示';break;
case 'displayDate':m='表示日付';break;
case 'displayErrors':m='エラーを表示';break;
case 'displayExpression':m='表示式';break;
case 'displayField':m='表示フィールド';break;
case 'displayName':m='表示名';break;
case 'displayValue':m='値を表示';break;
case 'documentation':m='ドキュメント';break;
case 'editingMode':m='編集モード';break;
case 'editorBorder':m='エディタボーダー';break;
case 'editorHeight':m='エディタ高さ';break;
case 'editorWidth':m='エディタ幅';break;
case 'editPanelStyle':m='ﾊﾟﾈﾙｽﾀｲﾙを編集';break;
case 'editProperties':m='プロパティを編集';break;
case 'emptyValue':m='空の値';break;
case 'enableAnimation':m='アニメを有効';break;
case 'expand':m='展開';break;
case 'field':m='フィールド';break;
case 'filter':m='フィルタ';break;
case 'firstRecord':m='先頭レコード';break;
case 'firstRow':m='先頭行';break;
case 'fitToContentHeight':m='内容の高さに調整';break;
case 'fitToContentWidth':m='内容の幅に調整';break;
case 'format':m='書式';break;
case 'formField':m='ﾌｫｰﾑﾌｨｰﾙﾄﾞ';break;
case 'freeze':m='固定';break;
case 'gap':m='間隙';break;
case 'generateDocumentation':m='ﾄﾞｷｭﾒﾝﾄを生成';break;
case 'group':m='グループ';break;
case 'headerHeight':m='ヘッダの高さ';break;
case 'groupValue':m='グループ';break;
case 'hasDownArrow':m='下矢印';break;
case 'headerVisible':m='ヘッダを表示';break;
case 'height':m='高さ';break;
case 'hint':m='ヒント';break;
case 'horizontalAlign':m='横揃え';break;
case 'html':m='HTML';break;
case 'imageIndex':m='イメージインデックス';break;
case 'imageList':m='イメージリスト';break;
case 'iconErrorUrl':m='ｴﾗｰｱｲｺﾝURL';break;
case 'iconHeight':m='アイコンの高さ';break;
case 'iconLoadingUrl':m='読込みｱｲｺﾝURL';break;
case 'iconMargin':m='アイコン余白';break;
case 'iconSuccessUrl':m='成功ｱｲｺﾝURL';break;
case 'iconUrl':m='アイコンURL';break;
case 'iconWidth':m='アイコン幅';break;
case 'ignoreCase':m='大小文字を区別しない';break;
case 'imageLabelField':m='画像ラベル';break;
case 'imageUrlField':m='画像URL';break;
case 'includeGrid':m='グリッドを表示';break;
case 'includeX':m='X軸を表示';break;
case 'includeY':m='Y軸を表示';break;
case 'indeterminate':m='不確定';break;
case 'index':m='インデックス';break;
case 'innerLayoutKind':m='内部レイアウト';break;
case 'invalidMessage':m='不正メッセージ';break;
case 'isEvent':m='イベントである';break;
case 'itemMaxHeight':m='項目の最大高';break;
case 'itemMaxWidth':m='項目の最大幅';break;
case 'itemHeight':m='項目の高さ';break;
case 'itemWidth':m='項目の幅';break;
case 'json':m='JSON';break;
case 'lastRecord':m='最後のレコード';break;
case 'layer':m='レイヤー';break;
case 'layersType':m='レイヤタイプ';break;
case 'layoutKind':m='レイアウト';break;
case 'legendHeight':m='凡例の高さ';break;
case 'link':m='リンク';break;
case 'liveEditing':m='ライブ編集';break;
case 'liveSource':m='ライブソース';break;
case 'loadParentFirst':m='親から読込み';break;
case 'lock':m='ロック';break;
case 'lookupDisplay':m='ルックアップ';break;
case 'main':m='メイン';break;
case 'margin':m='余白';break;
case 'matchMode':m='一致条件';break;
case 'maxChars':m='最大文字数';break;
case 'maxHeight':m='最大高さ';break;
case 'maximum':m='最大';break;
case 'maxResults':m='最大結果数';break;
case 'menu':m='メニュー';break;
case 'minHeight':m='最初高さ';break;
case 'minimum':m='最小';break;
case 'minWidth':m='最初幅';break;
case 'motion':m='動作';break;
case 'moveNext':m='次へ';break;
case 'movePrevious':m='前へ';break;
case 'multiActive':m='ﾏﾙﾁｱｸﾃｨﾌﾞ';break;
case 'name':m='名前';break;
case 'namespace':m='名前空間';break;
case 'nextRecord':m='次のレコード';break;
case 'noInspector':m='ｲﾝｽﾍﾟｸﾀ無し';break;
case 'operation':m='処理';break;
case 'options':m='引数';break;
case 'orderBy':m='並び替え';break;
case 'owner':m='オーナー';break;
case 'padding':m='パディング';break;
case 'pageName':m='ページ名';break;
case 'pageSize':m='ページサイズ';break;
case 'password':m='パスワード';break;
case 'places':m='小数点';break;
case 'previousRecord':m='前のレコード';break;
case 'progress':m='進捗';break;
case 'projectSubVersion':m='ｻﾌﾞﾊﾞｰｼﾞｮﾝ';break;
case 'projectVersion':m='ﾌﾟﾛｼﾞｪｸﾄﾊﾞｰｼﾞｮﾝ';break;
case 'promptChromeFrame':m='ﾌﾟﾛﾝﾄｸﾛﾑﾌﾚｰﾑ';break;
case 'property':m='プロパティ';break;
case 'promptMessage':m='メッセージ';break;
case 'publishName':m='公開名';break;
case 'queue':m='キュー';break;
case 'radioGroup':m='ラジオグループ';break;
case 'rangeMessage':m='範囲メッセージ';break;
case 'readonly':m='読取り専用';break;
case 'regExp':m='正規表現';break;
case 'removeColumn':m='列を削除';break;
case 'removeEditors':m='エディタを削除';break;
case 'required':m='必須';break;
case 'resizeToFit':m='自動リサイズ';break;
case 'resource':m='リソース';break;
case 'restrictValues':m='値を制限';break;
case 'rewindDelay':m='巻き戻しﾃﾞｨﾚｨ';break;
case 'saveDisplayValue':m='表示値を保存';break;
case 'scrollX':m='横スクロール';break;
case 'scrollY':m='縦スクロール';break;
case 'selectionMode':m='選択モード';break;
case 'service':m='サービス';break;
case 'showing':m='表示';break;
case 'showButtons':m='ボタンを表示';break;
case 'showLink':m='リンクを表示';break;
case 'showMessages':m='ﾒｯｾｰｼﾞを表示';break;
case 'showOnlyParentLayer':m='親ﾚｲﾔｰのみ表示';break;
case 'singleClickEdit':m='１クリック編集';break;
case 'singleLine':m='一行';break;
case 'source':m='ソース';break;
case 'sourceData':m='ソースデータ';break;
case 'startChecked':m='チェック開始';break;
case 'startNow':m='開始';break;
case 'startUpdate':m='起動時更新';break;
case 'stopNow':m='停止';break;
case 'studioVersion':m='ｽﾀｼﾞｵﾊﾞｰｼﾞｮﾝ';break;
case 'theme':m='テーマ';break;
case 'themeStyleType':m='ﾃｰﾏｽﾀｲﾙ型';break;
case 'title':m='題名';break;
case 'timePattern':m='時刻パターン';break;
case 'toggleSelect':m='選択の切替え';break;
case 'toastPosition':m='ﾄｰｽﾄ位置';break;
case 'toolbarAlign':m='ﾂｰﾙﾊﾞｰ配置';break;
case 'toolbarColor':m='ﾂｰﾙﾊﾞｰ色';break;
case 'toolbarFont':m='ﾂｰﾙﾊﾞｰﾌｫﾝﾄ';break;
case 'toolbarLink':m='ﾂｰﾙﾊﾞｰﾘﾝｸ';break;
case 'toolbarList':m='ﾂｰﾙﾊﾞｰﾘｽﾄ';break;
case 'toolbarStyle':m='ﾂｰﾙﾊﾞｰｽﾀｲﾙ';break;
case 'toolbarStyleAll':m='ﾂｰﾙﾊﾞｰｽﾀｲﾙ全';break;
case 'toolbarUndo':m='ﾂｰﾙﾊﾞｰ解除';break;
case 'tooltipDisplayTime':m='ﾂｰﾙﾁｯﾌﾟ時間';break;
case 'totalItems':m='項目数';break;
case 'twitterId':m='TwitterID';break;
case 'type':m='型';break;
case 'undeploy':m='アンデプロイ';break;
case 'updateNow':m='更新';break;
case 'url':m='URL';break;
case 'validateBeforeSave':m='保存前に検証';break;
case 'vertical':m='縦に表示';break;
case 'verticalAlign':m='縦揃え';break;
case 'width':m='幅';break;
case 'xAxis':m='X軸';break;
case 'yAxis':m='Y軸';break;
case 'zip':m='郵便番号';break;
default:
//window.alert(m);
}
		return [
			//'<td class="wminspector-binding', c, bc, '">', b, '</td>',
			'<td class="wminspector-caption" style="font-size:x-small">', this.makeRowCaption(m, inProp), '</td>',
			'<td class="wminspector-property">', this.makePropEdit(n, inProp, wire), '</td>',
			'<td class="wminspector-binding', c, bc, '">', b, '</td>'
		];
	},
	shouldShowProp: function(inName, inProp) {
		return this.inherited(arguments) || this.isBindable(inProp);
	},
	canMakeDefaultPropEdit: function(inProp) {
		return !inProp.ignore;
	},
	makePropEdit: function(inName, inProp, inWire) {
		if (inWire && inWire instanceof wm.Wire)
			return this.makeBoundPropEdit(inName, inWire.source || inWire.expression)
		if (this.canMakeDefaultPropEdit(inProp)) 
			return this.inherited(arguments, [inName, inProp])
		return this.makeBindPropEdit(inName);
	},
	makeBindPropEdit: function(inName) {
		var m = "(data binding)";
		return makeInputPropEdit(inName, m, m, true);
	},
	makeBoundPropEdit: function(inName, inSource) {
		return makeBoundEdit(inName, inSource)
	},
	propClick: function(e) {
		var
			handled = this.inherited(arguments),
			propName = this.getPropNameByEvent(e);
		if (this.selectMode)
			return this.endBind(propName, e.target);
		else if (!handled && dojo.hasClass(e.target, "wminspector-bindProp"))
			return this.beginBind(propName, e.target);
		else if (dojo.hasClass(e.target, "bound-prop-button"))
			this.unbindProp(propName);
	},
	unbindProp: function(inPropName) {
		var
			b = this.getBinding(),
			tp = this.getTargetProperty(inPropName),
			w = wm.data.getPropWire(b.owner, tp);
		if (tp && w) {
			var wireOwner = w.owner;
			//wireOwner.removeWire(wireOwner.getWireId(w));
			wireOwner.removeWire(w.getWireId());
			this._setInspectedProp(tp, "");
			this._inspect();
		}
	},
	isBindable: function(inProp) {
		return inProp && (inProp.bindable || inProp.bindTarget);
	},
	getBinding: function() {
		var i = this.inspected;
		return i && i.components.binding;
	},
	getTargetProperty: function(inPropName) {
		return inPropName;
	},
	getPropWire: function(inProp) {
		var
			b = this.getBinding(),
			tp = this.getTargetProperty(inProp.name);
		return b && b.owner && wm.data.getPropWire(b.owner, tp);
	},
	getBindDialogProps: function(inPropName) {
		var
			o = this.inspected,
			tp = this.getTargetProperty(inPropName),
			prop = this.props[tp];
		if (this.isBindable(prop))
			return dojo.mixin({object: o, targetProperty: tp}, prop || {});
	},
	beginBind: function(inPropName, inNode) {
		var
			bd = studio.bindDialog,
			p = this.getBindDialogProps(inPropName),
			coords = dojo.coords(inNode);

		bd.positionLocation = (coords.y > bd.contentHeight) ? "tl" : "bl"; 
		if (p) {

			bd.page.update(p);
			// FIXME: wm.calcOffset fails for td/tr so use tr for now.
			bd.positionNode = inNode.parentNode;
			bd.show();
			return true;
		}
	},
	endBind: function(inPropName, inNode) {
		//if (this.selectMode) {
		//	studio.propertySelected(this.inspected.getRuntimeId() + "." + inPropName);
		//}
		//else
		if (this.active)
			this._inspect();
	}
	/*
	beginBind: function(inPropName, inNode) {
		// may be a different inspector that does endBind
		studio._bindTarget = this.inspected;
		var
			p = this.getBindDialogProps(inPropName);
		if (p) {
			// SJM2008
			studio.testClick(this, p, "Select binding for<br/><b>" + this.inspected.name + "." + inPropName + "</b>");
		}
	},*/
	/*
	endBind: function(inPropName, inNode) {
		//alert(inPropName);
		studio.onSelectProperty(this.inspected.getRuntimeId() + "." + inPropName);
		studio.testClick();
		// bindBind may have been performed by a different inspector
		studio.select(studio._bindTarget);
		//if (this.active)
		//	this._inspect();
	}
	*/
});

// Data inspector
dojo.declare("wm.DataInspector", wm.BindInspector, {
	constructor: function() {
		this.initNodeChildren = dojo.hitch(this, this.initNodeChildren);
	},
	preinspect: function(inInspectorProps) {
		var
			ip = inInspectorProps,
			bindToComponent = ip && ip.bindToComponent;
		// FIXME:
		// note: inspected is always the component we're inspecting
		// and ip.inspected is always the root object bding inspected
		this.bindingOwner = bindToComponent ? this.inspected : ip && studio.page.getValueById(ip.inspected);
		this.bindPrefix = ip && ip.bindPrefix;
		this.dataProp = ip && ip.dataProp ? ip.dataProp : "";
		this.inherited(arguments);
	},
	getProps: function(inInspectorProps) {
		var c = this.inspected, dp = this.dataProp;
		if (!(c instanceof wm.Variable)) {
			return {};
		}
		var props = dojo.mixin({}, this.getSchema(c, c.type, dp));
		for (var i in props) {
			props[i].name = i;
		}
		return props;
	},
	getSchema: function(inInspected, inType, inDataProp) {
		// get root type, may be custom
		var
			s = wm.typeManager.isType(inType) ? wm.typeManager.getTypeSchema(inType) : (inInspected || 0)._dataSchema;
		// if there's a dataProp, get schema for that property's type
		if (inDataProp && s) {
			var
				pi = wm.typeManager.getPropertyInfoFromSchema(s, inDataProp),
				t = (pi||0).type,
				s = wm.typeManager.getTypeSchema(t);
		}
		return s;
	},
	getRootType: function(inPropInfo) {
		var i = this.getInspected(inPropInfo);
		return (i || 0).type;
	},
	getInspected: function(inPropInfo) {
		var
			pi = inPropInfo,
			n = pi.component ? [pi.inspected, pi.component].join('.') : pi.inspected;
		return studio.page.getValueById(n);
	},
	getBinding: function() {
		var i = this.bindingOwner;
		return i && i.components.binding;
	},
	getTargetProperty: function(inPropName) {
		var
			dp = this.dataProp,
			bp = this.bindPrefix,
			p = inPropName;
		if (dp)
			p = [dp, p].join('.');
		if (bp)
			p = [bp, p].join('.');
		return p;
	},
	getBindDialogProps: function(inPropName) {
		var
			o = this.bindingOwner || this.inspected,
			tp = this.getTargetProperty(inPropName);
		return {object: o, targetProperty: tp};
	},
	isBindable: function() {
		return true;
	},
	addTreeNode: function(inParent, inInspected, inNodeProps, inInspectorProps, inNodeList) {
		this.nodeList = inNodeList;
		var np = inNodeProps;
		np.type = this.getRootType(np);
		np.dataProp = "";
		np.bindPrefix = np.bindToComponent ? "" : np.component;
		np.content = this.getNodeContent(np.content, np.type);
		return this._addTreeNode(inParent, np);
	},
	_addTreeNode: function(inParent, inProps) {
		inProps.nodeInfos = this.listNodeChildren(inProps);
		inProps._hasChildren = Boolean(inProps.nodeInfos.length);
		inProps.initNodeChildren = this.initNodeChildren;
		inProps.closed = true;
		return new wm.TreeNode(inParent, inProps);
	},
	getNodeContent: function(inName, inTypeName) {
		var tn = (inTypeName || "").split('.').pop();
		tn = tn ? [" (", tn, ")"].join('') : "";
		return inName + tn;
	},
	getNodeProps: function(inProps, inNode, inName) {
		var p = inProps;
		p.component = inNode.component;
		p.inspected = inNode.inspected;
		p._nodeName = [inNode._nodeName, inName].join('.');
		p.content = this.getNodeContent(inName, inProps.type);
		p.bindToComponent = inNode.bindToComponent;
		p.bindPrefix = inNode.bindPrefix;
		p.inspector = inNode.inspector;
		p.image = inNode.image;
		p.dataProp = inNode.dataProp ? [inNode.dataProp, inName].join('.') : inName;
		return p;
	},
	getSortedSchema: function(inProps) {
		var ins = this.getInspected(inProps);
		// get a copy of the schema
		var s = dojo.mixin({}, this.getSchema(ins, inProps.type, ""));
		// convert to array for sorting
		var sa = [];
		for (var i in s) {
			s[i].name = i;
			sa.push(s[i]);
		}
		// sort by name
		sa.sort(function(a, b) { return wm.compareStrings(a.name, b.name)});
		return sa;
	},
	listNodeChildren: function(inProps) {
		var result = [];
		var ss = this.getSortedSchema(inProps);
		// iterate over props and create tree nodes
		for (var i=0, nodeProps, c, propInfo; (propInfo=ss[i]); i++) {
			if (propInfo.isList)
				continue;
			if (wm.typeManager.isStructuredType(propInfo.type)) {
				c = wm.typeManager.hasStructuredType(propInfo.type, function(ti) { return ti.isList == false });
				nodeProps = this.getNodeProps({type: propInfo.type, _hasChildren: c}, inProps, propInfo.name);
				result.push(nodeProps);
			}
		}
		//
		return result;
	},
	initNodeChildren: function(inNode) {
		var infos = inNode.nodeInfos;
		for (var i=0, info, n; (info=infos[i]); i++) {
			n = this._addTreeNode(inNode, info);
			// keep track of nodes added (this list may be used externally)
			this.nodeList[n._nodeName] = n;
		}
	},
	canMakeDefaultPropEdit: function(inProp) {
		return false;
	},
	// optional: make a special name for properties that are object types
	makeRowCaption: function(inName, inProp) {
		inName = inName + (wm.typeManager.isStructuredType(inProp.type) ? "*" : "");
		return this.inherited(arguments, [inName, inProp]);
	}
});

dojo.declare("wm.NavigationInspector", wm.DataInspector, {
	makePropEdit: function(inName, inProp, inWire) {
		var ins = this.inspected.getValue(inName);
		switch (inName) {
			case "pageName":
				return (new wm.propEdit.PagesSelect({
						component: this, 
						name: inName, 
						value: ins
					})).getHtml();
                        case "cssClasses":
                                return (new wm.propEdit.Select({component: this,
                                                                value: ins || "Info",
                                                                name: inName,
                                                                defaultValue: "Info",
                                                                options: ["Success", "Error", "Warning", "Info", "Misc"]})).getHtml();
                        case "duration":
                                return (new wm.propEdit.Select({component: this,
                                                                value: ins || "5000",
                                                                name: inName,
                                                                defaultValue: "5000",
                                                                options: ["1000", "2000", "3000", "4000", "5000", "6000", "8000", "10000", "15000"]})).getHtml();
                        case "dialogPosition":
                                return (new wm.propEdit.Select({component: this,
                                                                value: ins || "Info",
                                                                name: inName,
                                                                defaultValue: "Info",
                                                                options: ["", "top left", "top center", "top right", "center left", "center center", "center right", "bottom left", "bottom center", "bottom right"]})).getHtml();

			case "pageContainer":
				return (new wm.propEdit.WidgetsSelect({
						widgetType: wm.PageContainer, 
						component: this, 
						name: inName, 
						value: ins && ins.name
					})).getHtml();
			case "layer":
				return (new wm.propEdit.WidgetsSelect({
						widgetType: wm.Layer, 
						component: this, 
						name: inName, 
						value: ins && ins.name
					})).getHtml();
			case "layers":
				return (new wm.propEdit.WidgetsSelect({
						widgetType: wm.Layers, 
						component: this, 
						name: inName, 
						value: ins && ins.name
					})).getHtml();
		}
		if (inWire && inWire instanceof wm.Wire)
			return this.makeBoundPropEdit(inName, inWire.source || inWire.expression)
		if (this.canMakeDefaultPropEdit(inProp)) 
			return this.inherited(arguments, [inName, inProp])
		return this.makeBindPropEdit(inName);
	},
	_applyProp: function(t) {
		if (t && t.name) {
			switch (t.name) {
				case "pageName":
				case "duration":
				case "cssClasses":
				case "dialogPosition":
					this.inspected.components.binding.addWire("", t.name, "", '"' + t.value + '"');
					return;
				case "pageContainer":
				case "layer":
				case "layers":
					this.inspected.components.binding.addWire("", t.name, t.value, "");
					return;
			}
			var e = this._editors && this._editors[t.name];
			if (e) 
				e.applyProp(t);
			else 
				this._setInspectedProp(t.name, t.type == "checkbox" ? t.checked : t.value);
		}
	}
});
