/*
 * Copyright (C) 2008-2010 WaveMaker Software, Inc.
 *
 * This file is part of WaveMaker Studio.
 *
 * WaveMaker Studio is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, version 3 of the License, only.
 *
 * WaveMaker Studio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with WaveMaker Studio.  If not, see <http://www.gnu.org/licenses/>.
 */ 
/*[ Tab, Name, Class, Module, Image ]*/

// built in wm widgets

[ bundlePackage.Common_Widgets, bundlePackage.Button, "wm.Button", "wm.base.widget.Button", "images/wm/button.png", "A simple button"],
[ bundlePackage.Common_Widgets, bundlePackage.Toggle_Button, "wm.ToggleButton", "wm.base.widget.Button", "images/wm/button.png", "A simple button"],
[ bundlePackage.Common_Widgets, bundlePackage.DojoGrid, "wm.DojoGrid", "wm.base.widget.DojoGrid", "images/wm/data.png", "A Dojo grid"],
[ bundlePackage.Common_Widgets, bundlePackage.Label, "wm.Label", "wm.base.widget.Label", "images/wm/content.png", "Static text"],
[ bundlePackage.Common_Widgets, bundlePackage.Picture, "wm.Picture", "wm.base.widget.Picture", "images/wm/picture.png", "A picture from a url"],
[ bundlePackage.Common_Widgets, bundlePackage.Spacer, "wm.Spacer", "wm.base.widget.Spacer", "images/wm/spacer.png", "Add space between widgets"],
[ bundlePackage.Common_Widgets, bundlePackage.Splitter, "wm.Splitter", "wm.base.widget.Splitter", "images/wm/splitter.png", "A moveable bar between widgets"],

[ bundlePackage.Containers, bundlePackage.Accordion, "wm.AccordionLayers", "wm.base.widget.Layers", "images/wm/press.png", "Accordion controlled container"],
[ bundlePackage.Containers, bundlePackage.Layers, "wm.Layers", "wm.base.widget.Layers", "images/wm/notebook.png", "Stackable dynamic container"],
[ bundlePackage.Containers, bundlePackage.PageContainer, "wm.PageContainer", "wm.base.widget.PageContainer", "images/wm/pane.png", "A page container"],
[ bundlePackage.Containers, bundlePackage.Panel, "wm.Panel", "wm.base.widget.Panel", "images/wm/panel.png", "Container for other widgets"],
[ bundlePackage.Containers, bundlePackage.Rounded_Panel, "wm.FancyPanel", "wm.base.widget.Panel", "images/wm/panel.png", "Container for other widgets"],
[ bundlePackage.Containers, bundlePackage.Tabs, "wm.TabLayers", "wm.base.widget.Layers", "images/wm/tabbook.png", "Tabbed container for other widgets"],
[ bundlePackage.Containers, bundlePackage.Wizards, "wm.WizardLayers", "wm.base.widget.Layers", "images/wm/tabbook.png", "Tabbed container for other widgets"],

[ bundlePackage.Editor, bundlePackage.Checkbox, "wm.Checkbox", "wm.base.widget.Editors.Checkbox", "images/wm/edit.png", "A checkbox"],
[ bundlePackage.Editor, bundlePackage.Currency, "wm.Currency", "wm.base.widget.Editors.Text", "images/wm/edit.png", "An editor for currency"],
[ bundlePackage.Editor, bundlePackage.Date, "wm.Date", "wm.base.widget.Editors.Date", "images/wm/edit.png", "An editor for dates"],
[ bundlePackage.Editor, bundlePackage.Number, "wm.Number", "wm.base.widget.Editors.Number", "images/wm/edit.png", "An editor for numbers"],
[ bundlePackage.Editor, bundlePackage.RadioButton, "wm.RadioButton", "wm.base.widget.Editors.Radiobutton", "images/wm/edit.png", "A radiobutton"],
[ bundlePackage.Editor, bundlePackage.Select, "wm.SelectMenu", "wm.base.widget.Editors.Select", "images/wm/edit.png", "A drop down menu"],
[ bundlePackage.Editor, bundlePackage.Slider, "wm.Slider", "wm.base.widget.Editors.Number", "images/wm/edit.png", "An editor for slider"],
[ bundlePackage.Editor, bundlePackage.Text, "wm.Text", "wm.base.widget.Editors.Text", "images/wm/edit.png", "An editor for text"],
[ bundlePackage.Editor, bundlePackage.TextArea, "wm.LargeTextArea", "wm.base.widget.Editors.Text", "images/wm/edit.png", "An editor for multiline text"],
[ bundlePackage.Editor, bundlePackage.Time, "wm.Time", "wm.base.widget.Editors.Date", "images/wm/edit.png", "An editor for time"],
[ bundlePackage.Editor, bundlePackage.RichText, "wm.RichText", "wm.base.widget.Editors.RichText", "images/wm/edit.png", "An rich text editor"],
[ bundlePackage.Editor, bundlePackage.ColorPicker, "wm.ColorPicker", "wm.base.widget.Editors.Text", "images/wm/edit.png", "A text editor that pops up a color picker dialog"],

[ bundlePackage.Dialogs, bundlePackage.GenericDialog, "wm.GenericDialog", "wm.base.widget.Dialog", "images/wm/button.png", "A simple button"],
[ bundlePackage.Dialogs, bundlePackage.PageDialog, "wm.PageDialog", "wm.base.widget.Dialog", "images/wm/button.png", "A simple button"],
[ bundlePackage.Dialogs, bundlePackage.RichTextDialog, "wm.RichTextDialog", "wm.base.widget.Dialog", "images/wm/button.png", "A simple button"],
[ bundlePackage.Dialogs, bundlePackage.DesignableDialog, "wm.DesignableDialog", "wm.base.widget.Dialog", "images/wm/button.png", "A simple button"],


[ bundlePackage.Dojo_Widgets, bundlePackage.Chart, "wm.DojoChart", "wm.base.widget.DojoChart", "images/wm/bar_chart.png", "A Dojo chart"],
[ bundlePackage.Dojo_Widgets, bundlePackage.Dashboard, "wm.Dashboard", "wm.base.widget.Dashboard", "images/wm/lightbox_16.png", "Dashboard"],
[ bundlePackage.Dojo_Widgets, bundlePackage.Menu, "wm.DojoMenu", "wm.base.widget.DojoMenu", "images/wm/menu.png", "A Dojo menu"],
[ bundlePackage.Dojo_Widgets, bundlePackage.Fisheye, "wm.DojoFisheye", "wm.base.widget.DojoFisheye", "images/wm/fisheye.png", "A Dojo Fisheye"],
[ bundlePackage.Dojo_Widgets, bundlePackage.Lightbox, "wm.DojoLightbox", "wm.base.widget.DojoLightbox", "images/wm/lightbox_16.png", "A Dojo Lightbox"],
/*[ "Dojo Widgets", "Test", "wm.DojoWidget", "wm.base.widget.DojoWidget", "images/wm/button.png", "A button with a progress indicator"],*/

[ bundlePackage.Form_Tools, bundlePackage.DataNavigator, "wm.DataNavigator", "wm.base.widget.DataNavigator", "images/wm/edit.png"],
// [ bundlePackage.Form_Tools, "EditPanel", "wm.EditPanel", "wm.base.widget.EditPanel", "images/wm/panel.png"], //
[ bundlePackage.Form_Tools, bundlePackage.SimpleForm, "wm.SimpleForm", "wm.base.widget.LiveForm", "images/wm/content.png"],
[ bundlePackage.Form_Tools, bundlePackage.LiveForm, "wm.LiveForm", "wm.base.widget.LiveForm", "images/wm/content.png"],
[ bundlePackage.Form_Tools, bundlePackage.RelatedEditor, "wm.RelatedEditor", "wm.base.widget.RelatedEditor", "images/wm/edit.png", "A group of editors for related data"],

[ bundlePackage.More_Widgets, bundlePackage.Bevel, "wm.Bevel", "wm.base.widget.Bevel", "images/wm/bevel.png", "A bar to put between widgets"],
[ bundlePackage.More_Widgets, bundlePackage.Calendar, "wm.dijit.Calendar", "wm.base.widget.dijit.Calendar", "images/wm.dijit/Calendar.png", "Dojo calendar control"],
[ bundlePackage.More_Widgets, bundlePackage.Content, "wm.Content", "wm.base.widget.Content", "images/wm/content.png", "A display for static markup"],
[ bundlePackage.More_Widgets, bundlePackage.HTML, "wm.Html", "wm.base.widget.Html", "images/wm/content.png", "A display for static markup"],
[ bundlePackage.More_Widgets, bundlePackage.IFrame, "wm.IFrame", "wm.base.widget.IFrame", "images/wm/pane.png", "An IFrame for external content"],
[ bundlePackage.More_Widgets, bundlePackage.List, "wm.List", "wm.base.widget.List", "images/wm/content.png", "A simple list control"],
[ bundlePackage.More_Widgets, bundlePackage.ListViewer, "wm.ListViewer", "wm.base.widget.ListViewer", "images/wm/content.png", "A simple list control"],
[ bundlePackage.More_Widgets, bundlePackage.ProgressBar, "wm.dijit.ProgressBar", "wm.base.widget.dijit.ProgressBar", "images/wm.dijit/ProgressBar.png", "Dojo progress bar"],

/*
[ bundlePackage.Templates, bundlePackage.FancyCentered, "wm.Template", "wm.base.widget.Template", "images/wm/template.png", "Template for OMG", wm.fullTemplates.fancyCenteredTemplate],
[ bundlePackage.Templates, bundlePackage.CenteredPageContainer, "wm.Template", "wm.base.widget.Template", "images/wm/template.png", "A 800px wide centered page container with header and footer", wm.fullTemplates.CenteredPageContainerWithHeaderFooter],
[ bundlePackage.Templates, bundlePackage.ComplexLayout, "wm.Template", "wm.base.widget.Template", "images/wm/template.png", "A complicated layout template.", wm.fullTemplates.complexLayout],
[ bundlePackage.Templates, bundlePackage.CenteredLayout, "wm.Template", "wm.base.widget.Template", "images/wm/template.png", "A 600px wide fixed centered layout", wm.fullTemplates.centeredFixedLayout],
*/
[ bundlePackage.Templates, bundlePackage.FancyTemplate, "wm.Template", "wm.base.widget.Template", "images/wm/template.png", "Template for OMG", wm.fullTemplates.fancyTemplate],
[ bundlePackage.Templates, bundlePackage.SideMenu, "wm.Template", "wm.base.widget.Template", "images/wm/template.png", "A 800px wide centered page container with header and footer", wm.fullTemplates.sideMenuTemplate],
[ bundlePackage.Templates, bundlePackage.TabsTemplate, "wm.Template", "wm.base.widget.Template", "images/wm/template.png", "A complicated layout template.", wm.fullTemplates.tabTemplate],
[ bundlePackage.Templates, bundlePackage.TopMenu, "wm.Template", "wm.base.widget.Template", "images/wm/template.png", "A 600px wide fixed centered layout", wm.fullTemplates.topMenuTemplate],

[ bundlePackage.SubTemplates, bundlePackage.TitleBar, "wm.Template", "wm.base.widget.Template", "images/wm/template.png", "An App Title Bar", wm.widgetTemplates.titleBar],
[ bundlePackage.SubTemplates, bundlePackage.Footer, "wm.Template", "wm.base.widget.Template", "images/wm/template.png", "A footer template.", wm.widgetTemplates.footer],
[ bundlePackage.SubTemplates, bundlePackage.SearchListDetail, "wm.Template", "wm.base.widget.Template", "images/wm/template.png", "A simple CRUD template.", wm.widgetTemplates.searchListDetail],
[ bundlePackage.SubTemplates, bundlePackage.Toolbar, "wm.Template", "wm.base.widget.Template", "images/wm/template.png", "A toolbar with buttons", wm.widgetTemplates.toolbar],
[ bundlePackage.SubTemplates, bundlePackage.TwoColumns, "wm.Template", "wm.base.widget.Template", "images/wm/template.png", "A simple template.", wm.widgetTemplates.twoColumn],
[ bundlePackage.SubTemplates, bundlePackage.TabbedTwoCol, "wm.Template", "wm.base.widget.Template", "images/wm/template.png", "Tabbed two column interface.", wm.widgetTemplates.tabbedTwoColumn],
//[ bundlePackage.SubTemplates, "ToolbarAndForm", "wm.Template", "wm.base.widget.Template", "images/wm/template.png", "A toolbar and simple form template.", wm.widgetTemplates.toolbarWithGroupBox],

[ bundlePackage.Web_Content, bundlePackage.Feed_List, "wm.FeedList", "wm.base.widget.FeedList", "images/rss.png", "Feed List"],
[ bundlePackage.Web_Content, bundlePackage.Twitter_Feed, "wm.TwitterFeed", "wm.base.widget.TwitterFeed", "images/wm/twitter.png", "Twitter Feed"],
//[ bundlePackage.Web_Content, "Stocks", "wm.gadget.Stocks", "wm.base.widget.gadget.Stocks", "images/flash.png", "Stocks Google Gadget"],
[ bundlePackage.Web_Content, bundlePackage.Weather, "wm.gadget.Weather", "wm.base.widget.gadget.Weather", "images/flash.png", "Weather Google Gadget"],
[ bundlePackage.Web_Content, bundlePackage.YouTube, "wm.gadget.YouTube", "wm.base.widget.gadget.YouTube", "images/flash.png", "YouTube Google Gadget"],

[ bundlePackage.Beta, bundlePackage.ColorPicker, "wm.ColorPicker", "wm.base.widget.Editors.Text", "images/wm/edit.png", "A color picker"],
[ bundlePackage.Beta, bundlePackage.BusyButton, "wm.BusyButton", "wm.base.widget.BusyButton", "images/wm/button.png", "A button with a progress indicator"],
[ bundlePackage.Beta, bundlePackage.Tree, "wm.Tree", "wm.base.widget.Tree", "images/wm/tree.png", "A tree control"],
[ bundlePackage.Beta, bundlePackage.Ticker, "wm.Ticker", "wm.base.widget.Ticker", "images/wm/widget.png", "Animated scrolling panel"],

[ bundlePackage.Deprecated, bundlePackage.DataGrid, "wm.DataGrid", "wm.base.widget.DataGrid", "images/wm/data.png", "A grid control for displaying lists"],
[ bundlePackage.Deprecated, bundlePackage.Rounded_Button, "wm.RoundedButton", "wm.base.widget.Button", "images/wm/button.png", "A simple rounded button"],
[ bundlePackage.Deprecated, bundlePackage.Checkbox, "wm.CheckBoxEditor", "wm.base.widget.Editor", "images/wm/edit.png", "A checkbox"],
[ bundlePackage.Deprecated, bundlePackage.Currency, "wm.CurrencyEditor", "wm.base.widget.Editor", "images/wm/edit.png", "An editor for currency"],
[ bundlePackage.Deprecated, bundlePackage.Date, "wm.DateEditor", "wm.base.widget.Editor", "images/wm/edit.png", "An editor for dates"],
[ bundlePackage.Deprecated, bundlePackage.Number, "wm.NumberEditor", "wm.base.widget.Editor", "images/wm/edit.png", "An editor for numbers"],
[ bundlePackage.Deprecated, bundlePackage.RadioButton, "wm.RadioButtonEditor", "wm.base.widget.Editor", "images/wm/edit.png", "A radiobutton"],
[ bundlePackage.Deprecated, bundlePackage.Select, "wm.SelectEditor", "wm.base.widget.Editor", "images/wm/edit.png", "A drop down menu"],
[ bundlePackage.Deprecated, bundlePackage.Slider, "wm.SliderEditor", "wm.base.widget.Editor", "images/wm/edit.png", "An editor for slider"],
[ bundlePackage.Deprecated, bundlePackage.Text, "wm.TextEditor", "wm.base.widget.Editor", "images/wm/edit.png", "An editor for text"],
[ bundlePackage.Deprecated, bundlePackage.TextArea, "wm.TextAreaEditor", "wm.base.widget.Editor", "images/wm/edit.png", "An editor for multiline text"],
[ bundlePackage.Deprecated, bundlePackage.Time, "wm.TimeEditor", "wm.base.widget.Editor", "images/wm/edit.png", "An editor for time"],

/*
[ "Non-Visual Components", "Composite Publisher", "wm.CompositePublisher", "wm.base.components.Publisher", "images/flash.png"],
[ "Non-Visual Components", "ImageList", "wm.ImageList", "wm.base.components.ImageList", "images/wm/picture.png", ""],
[ "Non-Visual Components", "LiveVariable", "wm.LiveVariable", "wm.base.components.LiveVariable", "images/wm/livevar_24.png"],
[ "Non-Visual Components", "NavigationCall", "wm.NavigationCall", "wm.base.components.NavigationCall", "images/wm/navigation_24.png"],
[ "Non-Visual Components", "Property", "wm.Property", "wm.base.components.Property", "images/flash.png" ],
[ "Non-Visual Components", "ServiceVariable", "wm.ServiceVariable", "wm.base.components.ServiceVariable", "images/wm/servicevar_24.png"],
[ "Non-Visual Components", "LogoutVariable", "wm.LogoutVariable", "wm.base.components.LogoutVariable", "images/wm/servicevar_24.png"],
[ "Non-Visual Components", "Template Publisher", "wm.TemplatePublisher", "wm.base.components.Publisher", "images/flash.png"],
[ "Non-Visual Components", "Variable", "wm.Variable", "wm.base.components.Variable", "images/wm/variable_24.png"],
*/



[ bundlePackage.Non_Visual_Components, bundlePackage.Variable, "wm.Variable", "wm.base.components.Variable", "images/wm/variable_24.png"],
[ bundlePackage.Non_Visual_Components, bundlePackage.ServiceVariable, "wm.ServiceVariable", "wm.base.components.ServiceVariable", "images/wm/servicevar_24.png"],
[ bundlePackage.Non_Visual_Components, bundlePackage.LiveVariable, "wm.LiveVariable", "wm.base.components.LiveVariable", "images/wm/livevar_24.png"],
[ bundlePackage.Non_Visual_Components, bundlePackage.SalesForceMonitorVariable, "wm.SalesForceMonitorVariable", "wm.base.components.SalesForceMonitorVariable", "images/wm/servicevar_24.png"],
[ bundlePackage.Non_Visual_Components, bundlePackage.ImageList, "wm.ImageList", "wm.base.components.ImageList", "images/wm/picture.png", ""],
[ bundlePackage.Non_Visual_Components, bundlePackage.NavigationCall, "wm.NavigationCall", "wm.base.components.NavigationCall", "images/wm/navigation_24.png"],
[ bundlePackage.Non_Visual_Components, bundlePackage.LogoutVariable, "wm.LogoutVariable", "wm.base.components.LogoutVariable", "images/wm/servicevar_24.png"],
[ bundlePackage.Non_Visual_Components, bundlePackage.Timer, "wm.Timer", "wm.base.components.Timer", "images/wm/variable_24.png"],
[ bundlePackage.Non_Visual_Components, bundlePackage.TypeDefinition, "wm.TypeDefinition", "wm.base.components.TypeDefinition", "images/wm/variable_24.png"],


[ bundlePackage.Services, bundlePackage.Database_Service, "wm.DataModel", "wm.base.components.DataModel", "images/wm/data_blue.png"],
[ bundlePackage.Services, bundlePackage.Java_Service, "wm.JavaService", "wm.base.components.JavaService", "images/wm/component.png"],
// [ bundlePackage.Services, bundlePackage.UploadDownload_Service, "wm.JavaService", "wm.base.components.JavaService", "images/wm/component.png", "Creates a java service for handling file downloads", {initialCode: "public String download() {return 'Ouch!';}", serviceId: "Download", initialClassId: "Download"}],
[ bundlePackage.Services, bundlePackage.LiveView, "wm.LiveView", "wm.base.components.LiveView", "images/wm/liveview_16.png"],
[ bundlePackage.Services, bundlePackage.Query, "wm.Query", "wm.base.components.Query", "images/wm/operation.png"],
[ bundlePackage.Services, bundlePackage.Security, "wm.Security", "wm.base.components.Security", "images/lock_16.png"],
[ bundlePackage.Services, bundlePackage.Web_Service, "wm.WebService", "wm.base.components.WebService", "images/wm/service.png"],

// hidden (don't show up in palette, but images are defined)
[ "", bundlePackage.Variable, "wm.Variable", "wm.base.components.Variable", "images/wm/variable_24.png"],
[ "", bundlePackage.LiveVariable, "wm.LiveVariable", "wm.base.components.LiveVariable", "images/wm/livevar_24.png"],
[ "", bundlePackage.ServiceVariable, "wm.ServiceVariable", "wm.base.components.ServiceVariable", "images/wm/servicevar_24.png"],
[ "", bundlePackage.NavigationCall, "wm.NavigationCall", "wm.base.components.NavigationCall", "images/wm/navigation_24.png"],
[ "", bundlePackage.Layer, "wm.Layer", "wm.base.widget.Layers", "images/wm/spacer.png"],
[ "", bundlePackage.Layout, "wm.Layout", "wm.base.widget.Layout", "images/wm/panel.png"]
