﻿/*
	Copyright (c) 2004-2009, The Dojo Foundation All Rights Reserved.
	Available via Academic Free License >= 2.1 OR the modified BSD license.
	see: http://dojotoolkit.org/license for details
*/

/*
	This is a compiled version of Dojo, built for deployment and not for
	development. To get an editable version, please visit:

		http://dojotoolkit.org

	for documentation and information on getting the source.
*/


dojo.provide("studio");
if (!dojo._hasResource["wm.base.design.Designable"]) {
	dojo._hasResource["wm.base.design.Designable"] = true;
	dojo.provide("wm.base.design.Designable");
	wm.design = {handles:{none:-1, not:0, leftTop:1, leftMiddle:2, leftBottom:3, rightTop:4, rightMiddle:5, rightBottom:6, middleTop:7, middleBottom:8, client:9}, cursors:{"-1":"", 0:"not-allowed", 1:"nw-resize", 2:"w-resize", 3:"sw-resize", 4:"ne-resize", 5:"e-resize", 6:"se-resize", 7:"n-resize", 8:"s-resize", 9:"move"}, drags:{none:0, move:1, resize:2, select:3, create:4}};
	dojo.declare("wm.Designable", wm.Box, {classNames:"wmdesignable", surface:null, designNode:null, dragMode:wm.design.drags.none, handleId:wm.design.handles.none, init:function () {
		this.inherited(arguments);
		this.domNode.className = this.classNames;
		this.connectEvents(this.domNode, ["mousedown", "click"]);
		this.designNode = this.domNode;
	}, getCursor:function () {
		return wm.design.cursors[this.handleId];
	}, selectDragMode:function (e) {
		with (wm.design) {
			this.handleId = this.getHitHandle(e);
			this.dragMode = this.handleId <= handles.not ? drags.none : this.handleId == handles.client ? drags.move : drags.resize;
		}
	}, mousemove:function (e) {
		this.handleId = this.getHitHandle(e);
		e.currentTarget.style.cursor = this.getCursor();
	}});
}
if (!dojo._hasResource["wm.base.design.Surface"]) {
	dojo._hasResource["wm.base.design.Surface"] = true;
	dojo.provide("wm.base.design.Surface");
	dojo.declare("wm.design.Surface", null, {origin:{l:2, t:2}, snapMask:7, add:function (inDesignable) {
		inDesignable.setBounds(wm.design.rect(-1, -1, 160, 96));
		this.domNode.appendChild(inDesignable.domNode);
	}, snap:function (inRect) {
		var mask = this.snapMask, o = this.origin;
		with (inRect) {
			l -= (l - o.l) & mask;
			t -= (t - o.t) & mask;
			w -= w & mask;
			h -= h & mask;
		}
	}, dragStart:function (inDragger) {
	}, drag:function (inDragger, inEvent) {
		inDragger.client.setBounds(inDragger.dragRect);
	}, drop:function (inDragger) {
		inDragger.client.setBounds(inDragger.dragRect);
	}});
	dojo.declare("wm.Surface", [wm.Box, wm.design.Surface], {});
}
if (!dojo._hasResource["wm.base.design.Drag"]) {
	dojo._hasResource["wm.base.design.Drag"] = true;
	dojo.provide("wm.base.design.Drag");
	dojo["require"]("wm.base.drag.drag");
	dojo.declare("wm.design.Mover", wm.DragDropper, {constructor:function () {
		this.info = {};
	}, beginDrag:function (inEvent, inInfo) {
		this.info = inInfo || this.info;
		this.mousedown(inEvent);
	}, initNodes:function () {
		this.inherited(arguments);
		this.markNode = document.createElement("div");
		this.markNode.style.cssText = "position: absolute; z-index: 2; border: 2px solid green;";
		this.scrimNode.appendChild(this.markNode);
		this.hSnapNode = document.createElement("div");
		this.hSnapNode.style.cssText = "position: absolute; z-index: 2; border: 1px dotted red; display: none;";
		this.scrimNode.appendChild(this.hSnapNode);
		this.vSnapNode = document.createElement("div");
		this.vSnapNode.style.cssText = "position: absolute; z-index: 2; border: 1px dotted red; display: none;";
		this.scrimNode.appendChild(this.vSnapNode);
	}, start:function (e) {
		this.target = null;
		kit._setMarginBox(this.markNode, 0, 0, 0, 0);
		this.root = window.studio ? studio.page.root : app._page.root;
		this.rootOffset = wm.calcOffset(this.root.domNode.parentNode, this.scrimNode);
		this.inherited(arguments);
		this.setTarget(null);
		this.designable = this.isDesignable();
	}, drag:function (e) {
		this.inherited(arguments);
		var r = {l:this.pxp - this.rootOffset.x, t:this.pyp - this.rootOffset.y, w:0, h:0};
		this.findTarget(r);
		if (this.target && this.designable) {
			var r = {l:this.pxp - this.targetOff.x, t:this.pyp - this.targetOff.y, w:0, h:0, dx:this.dx, dy:this.dy};
			this.target.suggestDropRect(this.info.control, r);
			kit._setMarginBox(this.markNode, r.l + this.targetOff.x, r.t + this.targetOff.y, r.w, r.h);
			wm.showHideNode(this.hSnapNode, Boolean(r.hSnap));
			if (r.hSnap) {
				r.hSnap.l += this.targetOff.x;
				r.hSnap.t += this.targetOff.y;
				kit.marginBox(this.hSnapNode, r.hSnap);
			}
			wm.showHideNode(this.vSnapNode, Boolean(r.vSnap));
			if (r.vSnap) {
				r.vSnap.l += this.targetOff.x;
				r.vSnap.t += this.targetOff.y;
				kit.marginBox(this.vSnapNode, r.vSnap);
			}
			this.dropRect = r;
		}
	}, drop:function (e) {
		if (this.target && this.target.layout.removeEdges) {
			this.target.layout.removeEdges(this.target);
		}
		this.inherited(arguments);
	}, setTarget:function (inTarget) {
		if (this.target && this.target.layout.removeEdges) {
			this.target.layout.removeEdges(this.target);
		}
		this.target = inTarget;
		if (this.target) {
			this.setCursor("default");
			this.targetNode = this.target.containerNode || this.target.domNode;
			this.targetOff = wm.calcOffset(this.targetNode, this.scrimNode, true);
		} else {
			this.setCursor("no-drop");
			this.targetNode = null;
			this.targetOff = null;
		}
		if (this.target && this.target.layout.renderEdges) {
			this.target.layout.renderEdges(this.target, this.info.control);
		}
		this.updateAvatar();
	}, updateAvatar:function () {
		this.showHideAvatar(true);
		var contentNode = this.info.obj ? this.info.obj.contentNode : "";
		var contentHTML = contentNode != "" ? "<span>" + contentNode.innerHTML + "</span>" : this.info.caption;
		if (this.target) {
			var dn = this.designable ? this.target.name : this.root.owner.type;
			this.setAvatarContent(contentHTML + " -> <b>" + dn + "</b>");
		} else {
			this.setAvatarContent(contentHTML);
		}
	}, findTarget:function (inHit) {
		var t;
		var d = this.getDesignableDialog();
		if (d) {
			if (this.targetInDialog(inHit, d)) {
				t = (this.designable ? this._findTarget(inHit, d.containerWidget) : d.containerWidget);
			}
		} else {
			if (this.targetInRoot(inHit)) {
				t = (this.designable ? this._findTarget(inHit, this.root) : this.root);
			}
		}
		if (!t) {
			kit._setMarginBox(this.markNode, 0, 0, 0, 0);
		}
		if (t != this.target) {
			this.setTarget(t);
		}
	}, _findTarget:function (inHit, inWidget, inMargin) {
		var h = inHit, dn = inWidget.domNode, w, b, o;
		var sl = dn.scrollLeft, st = dn.scrollTop;
		var ws = inWidget.widgets;
		var m = inMargin || 0;
		for (var i in ws) {
			w = ws[i];
			if (w != this.info.control && w.container && !w.getLock()) {
				b = kit._getMarginBox(w.domNode);
				if (w.domNode.parentNode != inWidget.domNode) {
					o = wm.calcOffset(w.domNode.parentNode, inWidget.domNode);
					b.l += o.x;
					b.t += o.y;
				} else {
					b.l -= sl;
					b.t -= st;
				}
				b.r = b.l + b.w;
				b.b = b.t + b.h;
				if (h.l - b.l > m && b.r - h.l > m && h.t - b.t > m && b.b - h.t > m) {
					h.l -= b.l;
					h.t -= b.t;
					return this._findTarget(h, w, m + 1);
				}
			}
		}
		var t = inWidget._noCreate ? inWidget.parent : inWidget;
		return this.canBeTarget(t) ? t : null;
	}, canBeTarget:function (inWidget) {
		return inWidget.container && !inWidget.flags.notInspectable && !inWidget.getFreeze();
	}, targetInRoot:function (inHit) {
		var h = inHit, b = kit._getMarginBox(this.root.domNode);
		return !(h.l < 0 || h.t < 0 || h.l > b.w || h.t > b.h);
	}, targetInDialog:function (inHit, inDialog) {
		var h = inHit, b = kit._getMarginBox(inDialog.containerWidget.domNode);
		return !(h.l < 0 || h.t < 0 || h.l > b.w || h.t > b.h);
	}, isDesignableDialogShowing:function () {
		return Boolean(this.getDesignableDialog());
	}, getDesignableDialog:function () {
		for (var i = wm.dialog.showingList.length - 1; i >= 0; i--) {
			var d = wm.dialog.showingList[i];
			if (d.owner == studio.wip && d instanceof wm.DesignableDialog) {
				return d;
			}
		}
		return;
	}, isDesignable:function () {
		var c = this.info.control || (dojo.getObject(this.info.type)).prototype;
		return c instanceof wm.Control;
	}});
	dojo.declare("wm.design.Resizer", wm.DragDropper, {snapMask:3, constructor:function () {
		this.info = {};
	}, beginDrag:function (inEvent, inInfo) {
		this.info = inInfo || this.info;
		this.info.caption = this.info.control.name;
		this.info.node = this.info.control.domNode;
		this.info.rect = dojo.marginBox(this.info.node);
		this.target = this.info.control.parent;
		this.mousedown(inEvent);
	}, updateAvatar:function () {
		this.setAvatarContent("<b>" + this.info.caption + "</b>: " + this.dropRect.w + ", " + this.dropRect.h);
	}, start:function (e) {
		this.inherited(arguments);
		this.setCursor(this.info.cursor);
		if (this.target && this.target.layout && this.target.layout.renderEdges) {
			this.target.layout.renderEdges(this.target, this.info.control);
		}
	}, finish:function () {
		this.inherited(arguments);
		if (this.target && this.target.layout && this.target.layout.removeEdges) {
			this.target.layout.removeEdges(this.target);
		}
	}, applyMouseDelta:function () {
		with (this.info.rect) {
			this.dropRect = {l:l, t:t, w:w, h:h};
		}
		with (wm.design.handles) {
			switch (this.info.handleId) {
			  case leftTop:
			  case middleTop:
			  case rightTop:
				this.dropRect.t += this.dy;
				this.dropRect.h -= this.dy;
				break;
			  case leftBottom:
			  case middleBottom:
			  case rightBottom:
				this.dropRect.h += this.dy;
				break;
			}
			switch (this.info.handleId) {
			  case leftTop:
			  case leftMiddle:
			  case leftBottom:
				this.dropRect.l += this.dx;
				this.dropRect.w -= this.dx;
				break;
			  case rightTop:
			  case rightMiddle:
			  case rightBottom:
				this.dropRect.w += this.dx;
				break;
			}
		}
	}, applySnap:function (inRect) {
		with (wm.design.handles) {
			switch (this.info.handleId) {
			  case leftTop:
			  case middleTop:
			  case rightTop:
			  case leftBottom:
			  case middleBottom:
			  case rightBottom:
				inRect.h = this.snap(inRect.h);
				break;
			  case leftTop:
			  case leftMiddle:
			  case leftBottom:
			  case rightTop:
			  case rightMiddle:
			  case rightBottom:
				inRect.w = this.snap(inRect.w);
				break;
			}
		}
	}, snap:function (inValue) {
		return inValue - (inValue & this.snapMask);
	}, drag:function (e) {
		this.inherited(arguments);
		this.applyMouseDelta();
		dojo.mixin(this.dropRect, this.info);
		this.target.suggestSize(this.info.control, this.dropRect);
		with (this.dropRect) {
			w = Math.max(1, w);
			h = Math.max(1, h);
		}
		this.info.control.resizeUpdate(this.dropRect);
		this.updateAvatar();
	}});
}
if (!dojo._hasResource["wm.base.design.Wrapper"]) {
	dojo._hasResource["wm.base.design.Wrapper"] = true;
	dojo.provide("wm.base.design.Wrapper");
	dojo.declare("wm.DomBorder", null, {classNames:"", size:4, constructor:function (inClassNames) {
		this.classNames = inClassNames || "";
		this.make();
	}, make:function () {
		this.handles = [];
		for (var i = 0, s, ss = ["top", "right", "bottom", "left"]; s = ss[i]; i++) {
			this.handles[i] = this.makeHandle(s);
		}
	}, makeHandle:function (inSide) {
		var d = document.createElement("div");
		this.domNode = d;
		d.className = "wmdesign-handle wmdesign-handle-" + inSide + " " + this.classNames;
		d.style.zIndex = 20;
		return d;
	}, setBounds:function (inBox) {
		var hs = this.handles, bx = dojo._setBox, sz = this.size;
		with (inBox) {
			bx(hs[0], l, t, w, sz);
			bx(hs[1], l + w - sz, t, sz, h);
			bx(hs[2], l, t + h - sz, w, sz);
			bx(hs[3], l, t, sz, h);
		}
	}, setParentNode:function (inNode) {
		for (var i = 0, h; h = this.handles[i]; i++) {
			inNode.appendChild(h);
		}
	}, showHide:function (inShow) {
		for (var i = 0, h; h = this.handles[i]; i++) {
			wm.showHideNode(h, inShow);
		}
	}, destroy:function () {
		for (var i = 0, h; h = this.handles[i]; i++) {
			dojo.destroy(h);
		}
	}});
	dojo.declare("wm.DesignHandles", wm.DomBorder, {constructor:function () {
		this.connect();
	}, connect:function () {
		this.click = this.mousedown = this.mousemove = this.mouseevent;
		var c = [];
		for (var i = 0, h; h = this.handles[i]; i++) {
			c = c.concat(wm.connectEvents(this, h, ["mousedown", "mousemove"]));
		}
		this.connects = c;
	}, mouseevent:function (e) {
		wm.fire(this.parent, e.type, [e]);
	}, showHide:function (inShow, inParent) {
		if (!inParent.domNode) {
			return;
		}
		var h;
		var parentNode = inParent.domNode.parentNode;
		if (!parentNode) {
			return;
		}
		var parentObj = this.parent;
		var same = !!(parentObj && parentObj.domNode && (parentNode == parentObj.domNode.parentNode));
		this.parent = (inShow ? inParent : null);
		if (inShow != same) {
			for (var i = 0, h; h = this.handles[i]; i++) {
				try {
					if (inShow) {
						if (h.parentNode != parentNode) {
							parentNode.appendChild(h);
						}
					} else {
						if (h.parentNode == parentNode) {
							parentNode.removeChild(h);
						}
					}
				}
				catch (e) {
					djConfig.isDebug && console.info("Error while deleting node: " + e);
				}
			}
		}
	}});
	dojo.declare("wm.WrapperMover", wm.design.Mover, {beginDrag:function (e, inWrapper) {
		this.wrapper = inWrapper;
		this.inherited(arguments, [e, {control:this.wrapper.control, caption:this.wrapper.control.name}]);
	}, ondrop:function (e) {
		var i = this.dropRect;
		i.target = this.target;
		new wm.DropTask(this.wrapper.control);
		this.wrapper.designMove(i);
	}});
	wm.wrapperMover = new wm.WrapperMover();
	dojo.declare("wm.WrapperResizer", wm.design.Resizer, {beginDrag:function (e, inWrapper) {
		this.wrapper = inWrapper;
		this.inherited(arguments, [e, {control:this.wrapper.control, handleId:this.wrapper.getHitHandle(e), cursor:this.wrapper.getCursor()}]);
	}, ondrop:function () {
		this.info.control.designResize(this.dropRect);
	}});
	wm.wrapperResizer = new wm.WrapperResizer();
	dojo.declare("wm.DesignWrapper", wm.Designable, {border:0, borderColor:"#F0F0F0", handles:null, surface:null, init:function () {
		this.designConnects = [];
		this.makeLabel();
		this.makeHandles();
		this.inherited(arguments);
		dojo.addClass(this.domNode, "wmdesign-wrapper");
		this.domNode.style.cssText = "z-index: 10; visibility: hidden;";
		this.setControl(this.control);
	}, destroy:function () {
		this.surface._deleted(this.control);
		this.disconnect();
		this.inherited(arguments);
	}, makeLabel:function () {
		var l = document.createElement("div");
		l.className = "wmdesign-label";
		l.innerHTML = "<img class=\"wmdesign-label-corner\" /><div>control</div>";
		this.domNode.appendChild(l);
		this.label = l.childNodes[1];
	}, makeMarker:function () {
		this.marker = new wm.DomBorder("wmdesign-marker");
		this.marker.size = 0;
		this.marker.setParentNode(this.domNode);
	}, makeHandles:function () {
		this.handles = this.surface.handles || (this.surface.handles = new wm.DesignHandles());
	}, setControl:function (inControl) {
		var c = this.control = inControl, n = this.designNode = c && c.domNode;
		if (c) {
			c.designWrapper = this;
			this.domNode.style.backgroundColor = "transparent";
			if (c.scrim) {
				this.setScrim(c.scrim);
			}
			this.label.innerHTML = c.name;
			this.owner = c.owner;
			this.setShowing(inControl.showing);
		}
		if (n) {
			this.setDesignNode(n);
		}
	}, setShowing:function (inShowing) {
		if (inShowing != this.showing) {
			this.showHideHandles(inShowing);
		}
		this.inherited(arguments);
	}, disconnect:function () {
		dojo.forEach(this.designConnects, dojo.disconnect);
		this.designConnects = [];
	}, connect:function (n) {
		var d = this.designConnects = wm.connectEvents(this, n, ["click", "mousedown", "mousemove"]);
		d.push(dojo.connect(n, "onboundschange", this, "controlBoundsChange", true), dojo.connect(this.control, "setName", this, "controlNameChanged"));
	}, controlNameChanged:function () {
		this.label.innerHTML = this.control.name;
	}, controlParentChanged:function () {
		this.setDesignNode(this.control.domNode);
		if (this.handles.parent == this) {
			this.handles.setParentNode(this.domNode.parentNode);
		}
	}, setScrim:function (inScrim) {
		this.domNode.style.visibility = (inScrim ? "visible" : "hidden");
	}, setDesignNode:function (inNode) {
		this.disconnect();
		this.designNode = inNode;
		inNode.parentNode.appendChild(this.domNode);
		this.connect(inNode);
	}, setBounds:function (inBox) {
		return;
	}, setControlBounds:function (inBox) {
		this.control.setBounds(inBox);
		this.control.renderBounds();
		this.controlBoundsChange();
	}, controlBoundsChange:function () {
		this._setBounds(this.control.bounds);
	}, _setBounds:function (inBox) {
		var o = {x:0, y:0};
		var b = {l:inBox.l + o.x, t:inBox.t + o.y, w:inBox.w, h:inBox.h};
		wm.Bounds.prototype.setBounds.call(this, b.l, b.t, b.w, b.h);
		this.renderBounds();
		if (this.handles.parent == this) {
			this.handles.setBounds(b);
		}
		this.label.innerHTML = (b.h > 22 && b.w > 64) ? this.control.name : ".";
		wm.onidle(this, "setLabelPosition");
		b.l = b.t = 0;
	}, setLabelPosition:function () {
		if (studio.selected == this.control) {
			this.label.parentNode.style.right = this.label.parentNode.style.top = "0px";
		} else {
			this.label.parentNode.style.right = (this.control.marginExtents.r - 2) + "px";
			this.label.parentNode.style.top = this.control.marginExtents.t + "px";
		}
	}, canSize:function (box, next) {
		if (!this.control.canResize(box)) {
			return false;
		}
		return true;
		var n = this.designNode;
		var ok = true;
		while (n = n[next]) {
			if (n.flex > 0) {
				return true;
			} else {
				if (ok && n.style && !n.style.visibility && !n.style.display) {
					ok = false;
				}
			}
		}
		return ok || (next == "nextSibling");
	}, getHitHandle:function (e) {
		var dh = wm.design.handles, m = 4;
		var result = this.control.isMoveable() === false ? dh.none : dh.client;
		if (result == dh.client) {
			var d = this.control.domNode, n = m * 3;
			if (d.offsetHeight < n || d.offsetWidth < n) {
				return result;
			}
		}
		var w = e.target.offsetWidth - m, h = e.target.offsetHeight - m, ps = "previousSibling", ns = "nextSibling", hs = this.handles.handles;
		if (e.target == hs[0]) {
			if (!this.canSize("h", ps) || !this.canSize("flow")) {
				return dh.not;
			}
			return (e.layerX < m ? dh.leftTop : (e.layerX > w ? dh.rightTop : dh.middleTop));
		}
		if (e.target == hs[1]) {
			if (!this.canSize("v", ns)) {
				return dh.not;
			}
			return (e.layerY < m ? dh.rightTop : (e.layerY > h ? dh.rightBottom : dh.rightMiddle));
		}
		if (e.target == hs[2]) {
			if (!this.canSize("h", ns)) {
				return dh.not;
			}
			return (e.layerX < m ? dh.leftBottom : (e.layerX > w ? dh.rightBottom : dh.middleBottom));
		}
		if (e.target == hs[3]) {
			if (!this.canSize("v", ps) || !this.canSize("flow")) {
				return dh.not;
			}
			return (e.layerY < m ? dh.leftTop : (e.layerY > h ? dh.leftBottom : dh.leftMiddle));
		}
		return result;
	}, showHideHandles:function (inShow) {
		if (!this.control.showing && inShow) {
			return;
		}
		this.handles.showHide(inShow, this);
		if (inShow) {
			this.controlBoundsChange();
		}
	}, select:function () {
		var c = this.control;
		while (c && c.isParentLocked()) {
			c = c.parent;
		}
		this.surface.select(c);
	}, _selected:function (inSelected) {
		if (!this.domNode || !this.control.domNode) {
			return;
		}
		this.showHideHandles(inSelected);
		var zIndex = parseInt(this.control.domNode.style.zIndex);
		if (zIndex > 10 && inSelected) {
			this.domNode.style.zIndex = zIndex + 1;
		} else {
			this.domNode.style.zIndex = inSelected ? 11 : 10;
		}
		wm.addRemoveClass(this.domNode, "wmdesign-wrapper-selected", inSelected);
	}, onselected:function () {
		this._selected(true);
		wm.onidle(this, function () {
			this.control.getDesignBorder();
			this.control.invalidCss = true;
			this.control.render();
			this.setLabelPosition();
		});
	}, ondeselected:function () {
		this._selected(false);
		wm.onidle(this, function () {
			if (this.control.isDestroyed) {
				return;
			}
			this.control.getDesignBorder();
			this.control.invalidCss = true;
			this.control.render();
			this.setLabelPosition();
		});
	}, getId:function () {
		return "";
	}, mousedown:function (e) {
		if (wm.inScrollbar(e)) {
			this.click(e);
			dojo.stopEvent(e);
			return;
		}
		this.selectDragMode(e);
		switch (this.dragMode) {
		  case wm.design.drags.move:
			wm.wrapperMover.beginDrag(e, this);
			break;
		  case wm.design.drags.resize:
			wm.wrapperResizer.beginDrag(e, this);
			break;
		}
	}, click:function (e) {
		dojo.stopEvent(e);
		this.select();
	}, designMove:function (inDropInfo) {
		this.surface.designMove(this.control, inDropInfo);
	}, destroy:function () {
		this.handles.destroy();
		this.inherited(arguments);
	}});
	dojo.declare("wm.ComponentWrapper", null, {setDesignNode:function () {
	}, showHideHandles:function () {
	}, select:function () {
	}, onselected:function () {
	}, ondeselected:function () {
	}});
}
if (!dojo._hasResource["wm.base.design.Designer"]) {
	dojo._hasResource["wm.base.design.Designer"] = true;
	dojo.provide("wm.base.design.Designer");
	dojo.declare("wm.Designer", wm.Surface, {selected:null, box:"v", init:function () {
		this.inherited(arguments);
		if (this.isDesignLoaded()) {
			this.flow = function () {
			};
			return;
		}
		this.domNode.setAttribute("tabindex", -1);
		this.connectEvents(this.domNode, ["mousedown"]);
	}, onselect:function (inControl) {
	}, ondelete:function (inControl) {
	}, onmove:function (inControl) {
	}, keypress:function (e) {
	}, mousedown:function (e) {
		if (e.target == this.domNode) {
			this.select(null);
		}
	}, showHideHandles:function (inShowHide) {
		var s = this.selected;
		if (s && !s.isDestroyed) {
			s.designWrapper.showHideHandles(inShowHide);
		}
	}, replace:function (inControl, inTarget, inBounds, inNextSibling) {
		var c = inControl, t = inTarget, w = c.designWrapper;
		w.showHideHandles(false);
		var i = inNextSibling ? t.indexOfControl(inNextSibling) : t.c$.length;
		t.designMoveControl(c, {i:i});
		w.setDesignNode(c.domNode);
		w.showHideHandles(true);
		c.designResize(inBounds);
	}, select:function (inControl) {
		if (inControl && !inControl.designWrapper || this._selecting) {
			return;
		}
		try {
			this._selecting = true;
			if (this.selected) {
				this.selected.designWrapper.ondeselected();
			}
			this.selected = inControl;
			if (this.selected) {
				this.selected.designWrapper.onselected();
			}
			this.onselect(inControl);
			try {
				this.domNode.focus();
			}
			catch (e) {
			}
		}
		finally {
			this._selecting = false;
		}
	}, selectParent:function (inControl) {
		var p = inControl || this.selected;
		p = p && p.parent;
		if (p) {
			if (p.designWrapper) {
				this.select(p);
			} else {
				this.selectParent(p);
			}
		}
	}, _deleted:function (inControl) {
	}, reflow:function () {
		this._boundsDirty = true;
		this.flow();
	}, flow:function () {
		if (this._boundsDirty) {
			wm.fire(studio.wip, "reflow");
			this._boundsDirty = false;
		}
	}, designMove:function (inControl, inDropInfo) {
		inControl.designMove(inDropInfo.target, inDropInfo);
		this.onmove(inControl);
	}});
}
if (!dojo._hasResource["wm.studio.app.StudioApplication"]) {
	dojo._hasResource["wm.studio.app.StudioApplication"] = true;
	dojo.provide("wm.studio.app.StudioApplication");
	dojo.declare("StudioApplication", wm.Application, {main:"Main", theme:"wm_studio", widgets:{}, confirm:function () {
		this.inherited(arguments);
		this.confirmDialog.setBorderColor("white");
		this.confirmDialog.setBorder("2");
		this.confirmDialog.$.genericInfoPanel.setBorder("10");
		this.confirmDialog.$.genericInfoPanel.setBorderColor("#424A5A");
	}, init:function () {
		this.inherited(arguments);
		this.alertDialog.setBorderColor("white");
		this.alertDialog.setBorder("2");
		this.alertDialog.$.genericInfoPanel.setBorder("10");
		this.alertDialog.$.genericInfoPanel.setBorderColor("#424A5A");
	}});
}
if (!dojo._hasResource["wm.studio.pages.Studio.Studio"]) {
	dojo._hasResource["wm.studio.pages.Studio.Studio"] = true;
	dojo.provide("wm.studio.pages.Studio.Studio");
	loadFrames = function () {
	};
	wm.disEnableButton = function (inBtn, inDisEnable) {
		var a = ["setAttribute", "removeAttribute"], d = "disabled";
		inBtn[a[Number(Boolean(inDisEnable))]](d, d);
	};
	dojo.declare("Studio", wm.Page, {_isWaveMakerStudio:true, _outlineClass:"Studio-outline", _explodeClass:"Studio-exploded", studioKeyPriority:false, projectPrefix:"", userName:"", resourcesLastUpdate:0, _deploying:false, _runRequested:false, start:function () {
		try {
			this.documentationDialog = new wm.RichTextDialog({owner:this, name:"documentationDialog"});
			this.connect(this.documentationDialog, "onOkClick", this, "saveDocumentation");
		}
		catch (e) {
			console.info("error while creating RichTextDialog for documentation.");
		}
		this.project = new wm.studio.Project();
		this.startEditor = studio.addEditor("Start");
		this.startEditor.connect(this.startEditor, "onStart", this, "startPageOnStart");
		this.initUserSettings();
		this.loadModuleConfig();
		this.owner = app;
		this.scrim = new wm.Scrim({owner:this, _classes:{domNode:["wmdialog-scrim"]}, waitCursor:false});
		loadPackages();
		this.outlinedClick();
		if (this.getUserSetting("explode")) {
			this.explodedClick();
		}
		this.clearTrees();
		this.initConsole();
		this.connect(wm.inflight, "change", this, "inflightChange");
		if (wm.studioConfig.preventUnloadWarning) {
			dojo.connect(window, "onbeforeunload", this, "windowUnload");
		}
		dojo.subscribe("wm-textsizechange", this, "reflow");
		dojo.subscribe("wmwidget-rename", this, "componentRenamed");
		setInterval(dojo.hitch(this, "updateStatus"), 2000);
		this.requestUserName();
		var defaultProject = this.getUserSetting("defaultProject");
		if (this.getUserSetting("useLop") && defaultProject) {
			this.project.openProject(defaultProject);
		} else {
			studio.disableMenuBar(true);
		}
		if (this.isCloud()) {
			this.navLogoutBtn.setShowing(true);
			this.navEditAccountBtn.setShowing(true);
		}
		this.updateProjectTree();
		this.subscribe("session-expiration-servicecall", this, "handleSessionExpiration");
		this.subscribe("service-variable-error", this, "handleServiceVariableError");
		this.loadThemeList();
		this.helpDialog.containerWidget.c$[0].setPadding("0");
		this.helpDialog.containerWidget.c$[0].setBorder("10");
		this.helpDialog.containerWidget.c$[0].setBorderColor("#424959");
	}, startPageOnStart:function () {
		this.startLayer = this.startEditor.parent;
		if (!this.getUserSetting("useLop") || !this.getUserSetting("defaultProject")) {
			this.startLayer.activate();
		}
	}, handleServiceVariableError:function (inServiceVar, inError) {
		studio.endWait();
	}, handleSessionExpiration:function (serviceVar) {
		if (serviceVar.getRoot().app == window.studio) {
			if (!this.isLoginShowing()) {
				if (!studio.getUserName()) {
					wm.logout();
				} else {
					studio.navGoToLoginPage();
				}
			}
		}
	}, isCloud:function () {
		return this.isModuleEnabled("cloud", "wm.cloud");
	}, preloadImages:function () {
		var p = "images/", t = "lib/wm/base/widget/themes/default/images/";
		wm.preloadImage(p + "loadingThrobber.gif");
		wm.preloadImage(p + "properties_16.png");
		wm.preloadImage(p + "inspector_bound.gif");
		wm.preloadImage(p + "project_16t.png");
		wm.preloadImage(p + "colorwheel_16.png");
		wm.preloadImage(p + "lock_16.png");
		wm.preloadImage(p + "group_open.gif");
		wm.preloadImage(p + "star_16.png");
		wm.preloadImage(p + "inspector_bind.gif");
		wm.preloadImage(t + "tree_closed.gif");
	}, windowUnload:function (e) {
		if (this._isLogout) {
			return;
		}
		var u = bundleStudio.MSG_PleaseNoteUnpublishedChanges, s = bundleStudio.MSG_PleaseNoteUnsavedChanges, m = this.isProjectDirty() ? u : s;
		e.returnValue = m;
		if (!m) {
			dojo.publish("wm-unload-app");
		}
		return m;
	}, initConsole:function () {
		this.console.inFlow = false;
		adaptConsole(this.console.domNode);
		this.reflow();
	}, initUserSettings:function () {
		this._userSettings = dojo.fromJson(dojo.cookie("wmStudioSettings")) || {};
		if (this._userSettings.location != window.location.href || this._userSettings.version != wm.studioConfig.studioVersion) {
			delete this._userSettings.defaultProject;
		}
		var dp = location.hash.slice(1) || wm.defaultProject;
		if (dp) {
			this.setUserSettings({defaultProject:dp});
		}
	}, setUserSettings:function (inProps) {
		dojo.mixin(this._userSettings, inProps || {});
		this._userSettings.location = window.location.href;
		this._userSettings.version = wm.studioConfig.studioVersion;
		dojo.cookie("wmStudioSettings", dojo.toJson(this._userSettings), {expires:365});
	}, getUserSetting:function (inProp) {
		return (this._userSettings || 0)[inProp];
	}, loadModuleConfig:function () {
		loadData(dojo.moduleUrl("wm.modules") + "../modules.js", dojo.hitch(this, "_loadModuleConfig"));
	}, _loadModuleConfig:function (d) {
		this.moduleConfig = eval("(" + d + ")");
	}, isModuleEnabled:function (inExtensionPoint, inModuleName) {
		var ep = this.moduleConfig && this.moduleConfig.extensionPoints && this.moduleConfig.extensionPoints[inExtensionPoint];
		if (ep) {
			for (var i = 0, k; (k = ep[i]); i++) {
				if (k == inModuleName) {
					return true;
				}
			}
		}
	}, projectChanging:function () {
		this.clearProjectPages();
		if (this.application) {
			var c = this.application.declaredClass;
			wm.fire(this.application, "destroy");
			this.removeClassCtor(c);
			this.application = null;
		}
		this.clearTrees();
		wm.typeManager.clearTypes();
		wm.services.clear();
		this.updateServices();
		wm.roles = [];
		if (this.project.projectName) {
			this.navGotoDesignerClick();
		}
	}, projectChanged:function (inName, inAppData) {
		var b = this.application && this.page;
		if (inName == this.project.projectName) {
			this.setUserSettings({defaultProject:inName});
			this.setAppCss(inAppData.css || "");
			this.setAppScript(inAppData.jscustom || "");
			this.setCleanApp();
			this.updateWindowTitle();
			if (b) {
				this.navGotoDesignerClick();
				this.mlpal.activate();
			} else {
				if (!this.isLoginShowing()) {
					this.startLayer.activate();
				}
			}
			if (!wm.studioConfig.preventLiveData && inName != "") {
				studio.deploy(null, null, true);
			}
		}
		this.disableMenuBar(!b);
		this.disableCanvasSourceBtns(!b);
		this.updateProjectTree();
		if (inName && inName != "") {
			if (inName == this.project.projectName) {
				dojo.publish("wm-project-changed");
			}
		}
	}, pageChanging:function () {
		wm.undo.clear();
		if (!this.page) {
			return;
		}
		this.select(null);
		this.setScript("");
		var c = this.page.declaredClass;
		wm.fire(this.page, "destroy");
		this.removeClassCtor(c);
		this.page = null;
		if (this.project.pageName) {
			this.navGotoDesignerClick();
		}
	}, pageChanged:function (inName, inPageData) {
		this.setScript(inPageData.js);
		this.setCss(inPageData.css || "");
		this.cssChanged();
		this.setMarkup(inPageData.html || "");
		this.setCleanPage(inPageData);
		this.refreshDesignTrees();
		if (this.page) {
			this.select(this.page.root);
		}
		dojo.publish("wm-page-changed");
		this.pagesChanged();
	}, pagesChanged:function () {
		this.updateWindowTitle();
		this.refreshPagePalette();
		this.updateProjectTreePages();
	}, projectsChanged:function () {
		this.updateProjectTree();
	}, updateWindowTitle:function () {
		var project = studio.application ? studio.application.declaredClass : "";
		var page = studio.page ? studio.page.declaredClass : "";
		var main = studio.application ? studio.application.main : "";
		var title = [];
		if (project) {
			title.push(project);
		}
		if (page) {
			title.push(page + (page == main ? " (Home)" : ""));
		}
		title.push("WaveMaker Studio");
		window.document.title = title.join(" - ");
	}, updateServices:function () {
		this.setLiveLayoutReady(false);
		this.servicesService.requestSync("listTypes", [], dojo.hitch(this, "typesChanged"));
		this.servicesService.requestSync("listServicesWithType", [], dojo.hitch(this, "servicesDataChanged"));
	}, typesChanged:function (inData) {
		wm.typeManager.setTypes(inData.types);
		wm.dataSources.update();
		this.refreshDataPalette();
		dojo.publish("wmtypes-changed");
	}, servicesDataChanged:function (inData) {
		wm.services.clear();
		for (var d in inData) {
			wm.services.add({name:d, type:inData[d]});
		}
		dojo.publish("wmservices-changed");
	}, getImageLists:function () {
		var obj = studio.page;
		var list = [];
		for (var i in obj.components) {
			if (wm.isInstanceType(obj.components[i], wm.ImageList)) {
				list.push(obj.components[i].getId());
			}
		}
		obj = studio.application;
		for (var i in obj.components) {
			if (wm.isInstanceType(obj.components[i], wm.ImageList)) {
				list.push(obj.components[i].getId());
			}
		}
		return list;
	}, refreshPagePalette:function () {
		var palette = studio.palette, list = this.project.getPageList(), caption = "Pages", desc = "A page in this project.", image = "images/wm/pane.png";
		palette.clearSection(caption);
		for (var i = 0, current = studio.page ? studio.page.declaredClass : "", p; (p = list[i]); i++) {
			if (current != p) {
				var n = p.toLowerCase() + "Page", props = {name:n, pageName:p};
				palette.addItem(caption, n, desc, image, "wm.PageContainer", props);
			}
		}
	}, refreshDataPalette:function () {
		var palette = studio.palette, list = wm.dataSources.sources, caption = "Data", desc = "A data object in this project.", image = "images/wm/data.png";
		palette.makeGroup(caption, 8);
		palette.clearSection(caption);
		wm.forEach(list, function (l, i) {
			wm.forEach(l, function (d) {
				var liveDataName = d.caption.toLowerCase();
				var name = liveDataName + "LivePanel1";
				palette.addItem(caption, d.caption + " (" + i + ")", desc, image, "wm.LivePanel", {name:name, liveDataName:liveDataName, liveSource:d.type});
			});
		});
	}, isLiveLayoutReady:function (inWarn) {
		var r = this._liveLayoutReady;
		if (inWarn && !r) {
			app.alert("Click the Live Layout button before requesting data.");
		}
		return r;
	}, setLiveLayoutReady:function (inReady) {
		this._liveLayoutReady = inReady;
	}, deploySuccess:function () {
		this.setLiveLayoutReady(true);
		this._deploying = false;
		if (this._runRequested) {
			var isTest = (this._runRequested == "navTestBtn");
			this._runRequested = false;
			wm.openUrl(this.getPreviewUrl(isTest), this.project.projectName, "_wmPreview");
		}
	}, deploy:function (inMsg, inCallback, noWait) {
		if (this._deploying) {
			studio.beginWait(inMsg);
			return;
		}
		this._deploying = true;
		var d = this._deployer = studio.deploymentService.requestAsync("testRunStart");
		d.addErrback(dojo.hitch(this, function (result) {
			if (result.message && result.message.match(/Application already exists at/)) {
				this.deploySuccess();
				return true;
			} else {
				if (result.dojoType != "cancel") {
					app.alert("Run failed: " + result.message);
				}
				this._deploying = false;
				this._runRequested = false;
				return result;
			}
		}));
		if (inCallback) {
			d.addCallback(inCallback);
		}
		d.addCallback(dojo.hitch(this, function (result) {
			this.deploySuccess();
			return result;
		}));
		if (!noWait) {
			this.waitForDeferred(d, inMsg);
		}
	}, getScript:function () {
		return this.editArea.getText();
	}, setScript:function (inScript) {
		return this.editArea.setText(inScript);
	}, getAppScript:function () {
		return this.appsourceEditor.getText();
	}, setAppScript:function (inScript) {
		return this.appsourceEditor.setText(inScript);
	}, getWidgets:function () {
		return sourcer(this.project.pageName, this.page);
	}, pageNameChange:function (inOldName, inNewName) {
		this.setScript(this.getScript().replace(new RegExp("\\b" + inOldName + "\\b"), inNewName));
		this.setCss(this.getCss().replace(new RegExp("\\." + inOldName + "\\b", "g"), "." + inNewName));
		this.cssChanged();
		this.page.name = inNewName;
		this.refreshDesignTrees();
	}, getProjectDesignPath:function () {
		return wm.Component.prototype.getPath();
	}, designifyCss:function (inCss) {
		var p = this.getProjectDesignPath();
		return inCss.replace(/url\s*\(\s*([^(http:)\/].*)\.*\)/g, "url(" + p + "$1)");
	}, designifyMarkup:function (inMarkup) {
		var p = this.getProjectDesignPath();
		return inMarkup.replace(/<img([^>]*)src[^>]*=[^>]*(["'])([^(http:)\/][^>]*)\2/g, "<img$1src=\"" + p + "$3\"");
	}, getCss:function () {
		return this.cssEditArea.getText();
	}, getAppCss:function () {
		return this.appCssEditArea.getText();
	}, setCss:function (inCss) {
		this.cssEditArea.setText(inCss);
		this.cssChanged();
	}, setAppCss:function (inCss) {
		this.appCssEditArea.setText(inCss);
		this.cssChanged();
	}, cssChanged:function () {
		setCss("page_ss", this.designifyCss(this.getCss()));
		setCss("app_ss", this.designifyCss(this.getAppCss()));
		this.reflow();
	}, getMarkup:function () {
		return this.markupEditArea.getText();
	}, setMarkup:function (inScript) {
		this.markupEditArea.setText(inScript);
		this.markupChanged();
	}, markupChanged:function () {
		studio.markup.domNode.innerHTML = this.designifyMarkup(this.getMarkup());
		inspect(this.selected || this.root);
		dojo.publish("wm-markupchanged");
	}, makeName:function (inType) {
		var n = inType.replace("wm.", "").replace("dijit.", "").replace("wm.", "");
		n = n.substring(0, 1).toLowerCase() + n.substring(1);
		return n.replace(/\./g, "") + "1";
	}, findContainer:function (inControl, inType) {
		var c = inControl;
		while (c && !(c.container && c.isWidgetTypeAllowed(inType) && !c.getFreeze())) {
			c = c.parent;
		}
		return c;
	}, newComponent:function (inType, inProps) {
		var tree = this.componentsTree;
		var ctor = dojo.getObject(inType), p = (ctor || 0).prototype;
		var s = tree.selected || 0, c = s.component || 0, owner = c.owner || s.owner || this.page;
		return owner.createComponent(this.makeName(inType, owner), inType, inProps);
	}, _newWidget:function (inType, inProps, inParent) {
		inProps = inProps || {};
		var n = inProps.name || inType;
		var c = this.page.loadComponent(this.makeName(n), inParent, inType, inProps);
		return c;
	}, newWidget:function (inType, inProps) {
		var p = this.findContainer(this.selected, inType) || studio.page.root.findContainer(inType);
		if (p) {
			return this._newWidget(inType, inProps, p);
		} else {
			app.alert("No available container for the new widget.  All containers are either locked or frozen.");
		}
	}, _marshall:function (inType) {
		return dojo.getObject(inType) || dojo.declare(inType, wm.Label, {caption:inType});
	}, _make:function (inType, inProps) {
		inProps = inProps || {};
		var ctor = this._marshall(inType);
		if (ctor) {
			var isWidget = ctor.prototype instanceof wm.Widget || ctor.prototype instanceof dijit._Widget;
			inProps._studioCreating = true;
			var c = isWidget ? this.newWidget(inType, inProps) : this.newComponent(inType, inProps);
			if (c) {
				c._studioCreating = false;
			}
			return c;
		}
	}, _add:function (inComponent) {
		if (!inComponent) {
			return;
		}
		new wm.AddTask(inComponent);
		if (!(inComponent instanceof wm.Widget)) {
			this.addComponentToTree(inComponent);
		}
		this.inspector.resetInspector();
		if (!(inComponent instanceof wm.Container)) {
			this.select(inComponent);
		}
		this.page.reflow();
		return inComponent;
	}, make:function (inType, inProps) {
		return this._add(this._make(inType, inProps));
	}, _lastBindSelect:null, select:function (inComponent) {
		if (studio.bindDialog && studio.bindDialog.showing) {
			this.bindDialog.page.binderSource.searchBar.setDataValue("#" + inComponent.name);
			this._lastBindSelect = inComponent;
			return;
		}
		if (this._lastBindSelect) {
			this._lastBindSelect = null;
			this.selected = null;
		}
		if (this.selected == inComponent) {
			return;
		}
		if (this.selected && !this.selected.isDestroyed && this.selected instanceof wm.Control) {
			var dialog1 = this.selected.getParentDialog();
			var dialog2 = (inComponent instanceof wm.Control) ? inComponent.getParentDialog() : null;
			if (dialog1 && dialog1 != dialog2) {
				dialog1.dismiss();
			}
		}
		while (inComponent && inComponent.isParentLocked && inComponent.isParentLocked()) {
			inComponent = inComponent.parent;
		}
		try {
			var s = this.selected = inComponent;
			this.revealSelected();
			this.designer.select(s instanceof wm.Widget ? s : null);
			if (s) {
				this.tree.deselect();
				this.widgetsTree.deselect();
			}
			this.selectInTree(s);
			if (s && !s.noInspector) {
				inspect(s, true);
			}
		}
		finally {
		}
		this.updateCutPasteUi();
		this.updateStatus();
	}, revealSelected:function () {
		var w = this.selected;
		if (w instanceof wm.Widget) {
			while (w) {
				wm.fire(w, "activate");
				w = w.parent;
			}
		}
	}, selectParent:function () {
		if (this.targetMode) {
			this.selectProperty();
		} else {
			this.designer.selectParent();
		}
	}, keyboardShortcutsDialog:function () {
		var shortcuts = [{d:"Most common shortcuts"}, {l:"C-w", d:"Toggle width between 100% and 100px (not supported for chrome in windows)"}, {l:"C-h", d:"Toggle height between 100% and 100px"}, {l:"C-m", d:"Toggle between model and palette"}, {l:"C-s", d:"Save project"}, {l:"C-r", d:"Run project"}, {l:"ESC", d:"If dialog is open: Close the dialog"}, {l:"ESC", d:"If no dialog: Select the parent of the selected widget"}, {l:"DEL", d:"Delete selected component (unless a text field/property field is selected for editting in which case it edits the text field)"}, {d:"Additional shortcuts"}, {l:"C-o", d:"Toggle horizontal alignment of widgets in container"}, {l:"C-e", d:"toggle vertical alignment of widgets in container"}, {l:"C-b", d:"Toggle layoutKind between left-to-right and top-to-bottom"}, {l:"C-z", d:"Undo"}];
		var html = "<table>";
		for (var i = 0; i < shortcuts.length; i++) {
			if (!shortcuts[i].l) {
				html += "<tr><td colspan='2'><b>" + shortcuts[i].d + "</td></tr>\n";
			} else {
				html += "<tr><td style='white-space: nowrap;'>" + shortcuts[i].l + "</td><td>" + shortcuts[i].d + "</td></tr>\n";
			}
		}
		html += "</table>";
		html = "<div class='KeyboardShortcutDialog'>" + html + "</div>";
		this.helpDialog.setUserPrompt(html);
		this.helpDialog.show();
	}, componentRenamed:function (inOld, inNew, inComponent) {
		this.renameComponentOnTree.apply(this, arguments);
		_setInspectedCaption(inComponent);
		this.cssChanged();
	}, waitForDeferred:function (inDeferred, inMsg) {
		this.beginWait(inMsg);
		inDeferred.addBoth(dojo.hitch(this, function (inResult) {
			this.endWait(inMsg);
			return inResult;
		}));
	}, waitForCallback:function (inMsg, inCallback) {
		studio.beginWait(inMsg);
		wm.onidle(function () {
			try {
				inCallback();
			}
			catch (e) {
				console.info("error while waitForCallback: ", e);
			}
			studio.endWait(inMsg);
		});
	}, waitMsg:null, beginWait:function (inMsg, inNoThrobber) {
		if (!this.waitMsg) {
			this.waitMsg = {};
		}
		if (!inMsg) {
			return;
		}
		this.dialog.setWidth("242px");
		this.dialog.setHeight("115px");
		this.dialog.domNode.style.zIndex = 30;
		this.dialog.containerNode.innerHTML = ["<table class=\"wmWaitDialog\"><tr><td>", inNoThrobber ? "" : "<div class=\"wmWaitThrobber\">&nbsp;</div>", "<div class=\"wmWaitMessage\">", inMsg || "Please wait...", "</div>", "<br />", "</td></tr></table>", ""].join("");
		this.dialog.setShowing(true);
		this.waitMsg[inMsg] = 1;
	}, endWait:function (optionalMsg) {
		if (optionalMsg) {
			delete this.waitMsg[optionalMsg];
		} else {
			this.waitMsg = {};
		}
		var firstMsg = "";
		for (var msg in this.waitMsg) {
			firstMsg = msg;
			break;
		}
		if (firstMsg) {
			this.beginWait(firstMsg);
		} else {
			this.dialog.setShowing(false);
		}
	}, addStudioClass:function (inClass) {
		var n = this.designer.domNode;
		if (dojo.hasClass(n, inClass)) {
			dojo.addClass(n, inClass);
		}
	}, removeStudioClass:function (inClass) {
		dojo.removeClass(this.designer.domNode, inClass);
	}, toggleStudioClass:function (inClass) {
		var n = this.designer.domNode;
		dojo[dojo.hasClass(n, inClass) ? "removeClass" : "addClass"](n, inClass);
	}, statusMsg:"", setStatusMsg:function (inMsg) {
		this.statusMsg = inMsg;
		this.updateStatus();
	}, updateStatus:function () {
		var s = this.selected, m = [s ? s.name : "(no selection)"];
		if (s && s instanceof wm.Widget) {
			var b = s.getBounds();
			m.push(Math.round(b.w) + " x " + Math.round(b.h));
		}
		var h = ["<table cellspacing=\"0\" style=\"height: 100%; width: 100%; text-align: center;\"><tr>", "<td class=\"statusNameBox\" style=\"font-weight: bold; width:14em; border-right: 1px solid silver; padding: 2px;\">", m[0], "</td>", "<td class=\"statusSizeBox\"  style=\"width:8em; border-right: 1px solid silver; padding: 2px;\">", m[1], "</td>", "<td class=\"statusMsgBox\" style=\"padding: 2px;\">", this.statusMsg, "</td>", "<td class=\"statusLoadingBox\" style=\"width: 32px; border-left: 1px solid silver; padding: 2px\">", wm.inflight.getCount() ? "<img src=\"images/loadingThrobber.gif\"/>" : "&nbsp;", "</td>", "</tr></table>"].join("");
		if (this._lastStatus != h) {
			this.status.domNode.innerHTML = h;
			this._lastStatus = h;
		}
	}, isShowingWorkspace:function () {
		return (this.tabs.getLayer().name == "workspace");
	}, allowKeyTarget:function (e) {
		var ctrls = {"INPUT":1, "TEXTAREA":1};
		var t = e.target;
		while (t) {
			if (ctrls[t.tagName]) {
				return true;
			}
			t = t.parentNode;
		}
		return false;
	}, processKey:function (inCode, inMap, inCanProcess) {
		for (var i = 0, k; (k = inMap[i]); i++) {
			if (k.key == inCode && (inCanProcess || k.always)) {
				if (this[k.action]) {
					if (k.idleDelay) {
						wm.onidle(this, k.action);
					} else {
						this[k.action]();
					}
				}
				return true;
			}
		}
	}, keydown:function (e) {
		if (wm.dialog.showing) {
			return true;
		}
		var hotkey = (e.ctrlKey && !(e.ctrlKey && e.shiftKey)), kc = e.keyCode, isEsc = kc == dojo.keys.ESCAPE, chr = String.fromCharCode(kc), normalKey = ((!this.studioKeyPriority && this.allowKeyTarget(e)) || !this.isShowingWorkspace() || wm.dialog.showing), handled = false;
		if (hotkey) {
			handled = this.processKey(chr, wm.studioConfig.hotkeyMap, !normalKey);
		}
		if (!hotkey && !isEsc) {
			if (e.target && e.target.nodeName.toLowerCase() == "input" && (dojo.attr(e.target, "type") == "text" || dojo.attr(e.target, "type") == "password")) {
				return;
			}
		}
		if (!handled) {
			handled = this.processKey(kc, wm.studioConfig.hotkeyCodeMap, !normalKey);
		}
		if (handled) {
			dojo.stopEvent(e);
		}
	}, nullAction:function () {
	}, tabsCanChange:function (inSender, inChangeInfo) {
		switch (inSender.getLayerCaption()) {
		  case "IDE":
			setTimeout(dojo.hitch(this, function () {
				this.cssChanged();
				this.markupChanged();
			}), 100);
			break;
		}
		switch (inSender.getLayerCaption(inChangeInfo.newIndex)) {
		  case "IDE":
			this.widgetsHtml.setHtml("<pre style=\"padding: 0; width: 100%; height: 100%;\">" + this.getWidgets() + "</pre>");
			var appsrc = this.project.generateApplicationSource();
			var match = appsrc.split(terminus);
			appsrc = (match) ? match[0] + "\n\t" + terminus + "\n});" : appsrc;
			this.appsourceHtml.setHtml("<pre style=\"padding: 0; width: 100%; height: 100%;\">" + appsrc + "</pre>");
			break;
		}
	}, tabsChange:function (inSender) {
		var caption = inSender.getLayerCaption();
		this.designer.showHideHandles(caption == "Design");
		switch (caption) {
		  case "IDE":
			this.sourceTabsChange(this.sourceTabs);
			break;
		  case "Design":
			if (this.selected) {
				if (this.selected == this.inspector.inspected) {
					this.inspector.reinspect();
				} else {
					this.inspector.inspect(this.selected);
				}
			}
			break;
		}
	}, leftTabsChange:function (inSender) {
		var caption = inSender.getLayerCaption();
		if (caption == bundleStudio.Palette && this.page) {
			this.navGotoDesignerClick();
		}
	}, objectTabsChange:function (inSender) {
		var l = inSender.getLayerCaption(), tree = l == "Widgets" ? this.tree : (l == "Components" ? this.componentsTree : null), ss = this.selected, s = tree && tree.selected, c = s && s.component;
		if (tree && c && c != ss) {
			this.select(c);
		}
	}, sourceTabsCanChange:function (inSender, inChangeInfo) {
	}, sourceTabsChange:function (inSender) {
		var caption = inSender.getLayerCaption();
		dojo[(caption == bundleStudio.R_Themes) ? "removeClass" : "addClass"](this.sourceTab.domNode, "wm-darksnazzy");
		if (caption == bundleStudio.R_Diagnostics) {
			this.diagnosticsPane.page.update();
		} else {
			if (caption == bundleStudio.R_ServerLogs) {
				this.logViewer.page.showLogs();
			}
		}
	}, treeSelect:function (inSender, inNode) {
		this.treeNodeSelect(inNode);
	}, inflightChange:function () {
		this.updateStatus();
	}, toggleControlSize:function (inControl, inDimension) {
		if (!inControl.canResize(inDimension)) {
			return;
		}
		var d = String(inControl.getProp(inDimension));
		if (d.indexOf("%") >= 0) {
			d = Math.max(parseInt(d), inControl["getMin" + wm.capitalize(inDimension) + "Prop"]()) + "px";
		} else {
			d = "100%";
		}
		inControl.setProp(inDimension, d);
	}, toggleControlPosition:function (inControl, inProp, inValues) {
		var v = inControl.getValue(inProp), i = (dojo.indexOf(inValues, v) + 1) % inValues.length;
		inControl.setValue(inProp, inValues[i]);
	}, toggleWidthClick:function () {
		var s = this.selected;
		if (s) {
			this.toggleControlSize(s, "width");
			inspect(s);
		}
	}, toggleHeightClick:function () {
		var s = this.selected;
		if (s) {
			this.toggleControlSize(s, "height");
			inspect(s);
		}
	}, toggleFlexBcClick:function () {
		var s = this.selected;
		if (s) {
			var pBox = s.parent && s.parent.layoutKind;
			this.toggleControlSize(s, pBox == "top-to-bottom" ? "height" : "width");
		}
	}, toggleVerticalAlignClick:function () {
		var s = this.selected;
		if (s) {
			this.toggleControlPosition(s, "verticalAlign", ["top", "middle", "bottom"]);
			inspect(s);
		}
	}, toggleHorizontalAlignClick:function () {
		var s = this.selected;
		if (s) {
			this.toggleControlPosition(s, "horizontalAlign", ["left", "center", "right"]);
			inspect(s);
		}
	}, toggleLayoutClick:function () {
		var s = this.selected;
		if (s) {
			var v = "top-to-bottom", h = "left-to-right";
			s.setLayoutKind(s.layoutKind == v ? h : v);
			inspect(s);
		}
	}, outlinedClick:function () {
		this.removeStudioClass(this._explodeClass);
		this.toggleStudioClass(this._outlineClass);
		var on = dojo.hasClass(this.designer.domNode, this._outlineClass);
		this.useDesignBorder = on;
		if (studio.page) {
			wm.forEachWidget(studio.page.root, function (w) {
				if (w.owner == studio.page) {
					w.getDesignBorder();
					w.invalidCss = true;
					w.renderCss();
				}
			});
		}
		wm.fire(this.page, "reflow");
	}, explodedClick:function () {
		this.addStudioClass(this._outlineClass);
		this.toggleStudioClass(this._explodeClass);
		this.reflow();
		this.setUserSettings({explode:dojo.hasClass(this.designer.domNode, this._explodeClass)});
	}, updateCutPasteUi:function () {
		var klass = this.clipboardClass, needsLayer = (klass == "wm.Layer"), disabled = !this.clipboard;
		if (!disabled && needsLayer) {
			var rp = dojo.getObject(wm.getClassProp(klass, "_requiredParent"));
			disabled = rp && !(this.selected instanceof rp);
		}
		this.pasteBtn.setDisabled(disabled);
	}, copyClick:function () {
		if (!this.copyBtn.disabled) {
			this.copyControl();
		}
	}, cutClick:function () {
		if (!this.cutBtn.disabled) {
			this.cutControl();
		}
	}, pasteClick:function () {
		if (!this.pasteBtn.disabled) {
			this.pasteControl();
		}
	}, deleteClick:function () {
		if (!this.deleteBtn.disabled) {
			this.deleteControl();
		}
	}, undoClick:function () {
		wm.undo.pop();
	}, newComponentButtonClick:function (inSender) {
		var t = inSender.componentType;
		if (t) {
			this.make(t);
			wm.fire(this.selected, "showConfigureDialog");
		}
	}, componentsTreeDblClick:function (inSender, inNode) {
		var c = inNode.component;
		if (c.showConfigureDialog) {
			c.showConfigureDialog();
		}
	}, deleteComponentButtonClick:function () {
		var s = this.componentsTree.selected;
		if (s && s.component) {
			this.deleteControl(s.component);
		}
	}, linkButtonClick:function (inSender, inData) {
		if (inData.openLink) {
			wm.openUrl(inSender.openLink, inSender.openLinkTitle);
		}
	}, saveThemeClick:function (inSender) {
		this.themesPage.page.saveTheme(inSender);
	}, addNewThemeClick:function (inSender) {
		this.themesPage.page.copyThemeClick(inSender, "wm_default");
	}, copyThemeClick:function (inSender) {
		this.themesPage.page.copyThemeClick(inSender);
	}, deleteThemeClick:function (inSender) {
		this.themesPage.page.removeThemeClick(inSender);
	}, revertThemeClick:function (inSender) {
		this.themesPage.page.revertTheme();
	}, selectProperty:function (inSender, info, text) {
		console.log("selectProperty");
		var n = this._testn;
		if (this.targetMode) {
			n.style.display = "none";
			this.targetMode = false;
			this.inspector.setSelectMode(false);
			dojo.disconnect(this._testc);
		} else {
			this._bindTarget = inSender;
			if (!n) {
				n = this._testn = document.createElement("div");
				n.innerHTML = text;
				n.style.cssText = "background-color: lightgreen; border: 1px solid black; position: absolute; padding: 4px;";
				document.body.appendChild(n);
			}
			n.style.display = "";
			this._testc = dojo.connect(document.body, "onmousemove", this, function (e) {
				n.style.left = e.pageX + 16 + "px";
				n.style.top = e.pageY + 16 + "px";
			});
			this.inspector.setSelectMode(true);
			this.targetMode = true;
		}
	}, propertySelected:function (inId) {
		this.onSelectProperty(inId);
		this.selectProperty();
		this.select(this._bindTarget);
	}, onSelectProperty:function (inId) {
	}, designerSelect:function (inSender, inControl) {
		if (inControl) {
			this.select(inControl);
		}
	}, designerMove:function (inSender, inDragger) {
		studio.refreshDesignTrees();
	}, requestUserName:function () {
		studio.securityService.requestSync("getUserName", [], dojo.hitch(this, "requestUserNameSuccess"), dojo.hitch(this, "requestUserNameFailure"));
	}, setUserName:function (inName) {
		this.userName = inName;
		this.userLabel.setCaption(this.userName);
	}, requestUserNameSuccess:function (inResponse) {
		if (inResponse) {
			this.setUserName(inResponse);
			this.userLabel.setCaption(this.userName);
			this.projectPrefix = this.userName;
			this.projectPrefix = this.projectPrefix.replace(/_/g, "__");
			this.projectPrefix = this.projectPrefix.replace(/\@/, "_AT_");
			this.projectPrefix = this.projectPrefix.replace(/\./g, "_DOT_");
			this.projectPrefix += "___";
		}
	}, requestUserNameFailure:function (inResponse) {
		this.getProjectDir("");
	}, getUserName:function () {
		return this.userName;
	}, editAccountClick:function (inSender) {
		app.pageDialog.showPage("UserSettings", true, 500, 200);
	}, logoutClick:function (inSender) {
		this.confirmAppChange("Are you sure you want to logout? Unsaved changes will be lost.", undefined, dojo.hitch(this, function () {
			this._isLogout = true;
			studio.securityService.requestSync("logout", [], dojo.hitch(this, "logoutSuccess"));
		}));
	}, logoutSuccess:function (inResponse) {
		window.location.reload();
	}, saveDocumentation:function () {
		var html = this.documentationDialog.getHtml();
		this.documentationDialog.editComponent.documentation = html;
		if (this.documentationDialog.editComponent == studio.selected) {
			this.inspector.reinspect();
		}
	}, loadThemeList:function (optionalCallback) {
		var d = studio.deploymentService.requestAsync("listThemes");
		d.addCallback(dojo.hitch(this, function (inData) {
			var d = [];
			for (var i = 0; i < inData.length; i++) {
				if (inData[i] != "wm_studio") {
					d.push({dataValue:inData[i]});
				}
			}
			this.themesListVar.setData(d);
		}));
		if (optionalCallback) {
			d.addCallback(optionalCallback);
		}
	}});
}
if (!dojo._hasResource["wm.studio.app.util"]) {
	dojo._hasResource["wm.studio.app.util"] = true;
	dojo.provide("wm.studio.app.util");
	wm.listOfWidgetType = function (inType, inIgnoreBuiltin) {
		var list = [];
		var owners = wm.listComponents([studio.application, studio.page], wm.Dialog, false);
		owners.push(studio.page);
		for (var i = 0; i < owners.length; i++) {
			var root = owners[i] instanceof wm.Page ? owners[i].root : owners[i];
			if (root) {
				wm.forEachWidget(root, function (w) {
					if (w instanceof inType && !(w.owner instanceof wm.Composite)) {
						list.push(w);
					}
				}, inIgnoreBuiltin);
				list.sort(function (a, b) {
					return a.name < b.name ? -1 : a.name == b.name ? 0 : 1;
				});
			}
		}
		return list;
	};
	wm.listOfWidgetTypes = function (inTypes) {
		var list = [];
		dojo.forEach(inTypes, function (t) {
			list = list.concat(wm.listOfWidgetType(t));
		});
		return list;
	};
	wm.listMatchingComponents = function (inOwners, inMatch, inRecurse) {
		var l = [];
		if (inMatch) {
			dojo.forEach(inOwners, function (o) {
				if (!o) {
					return;
				}
				wm.forEachProperty(o.components, function (c) {
					if (inMatch(c)) {
						l.push(c);
					}
					if (inRecurse) {
						l = l.concat(wm.listMatchingComponents([o], inMatch, inRecurse));
					}
				});
			});
		}
		return l;
	};
	wm.listMatchingComponentIds = function (inOwners, inMatch, inRecurse) {
		var d = [], l = wm.listMatchingComponents.call(dojo.global, inOwners, inMatch, inRecurse);
		dojo.forEach(l, function (c) {
			d.push(c.getId());
		});
		d.sort();
		return d;
	};
	wm.listComponents = function (inOwners, inClass, inStrict) {
		isRequestedType = function (inComp) {
			if (inComp) {
				if (inStrict) {
					return (inClass.prototype.declaredClass == inComp.declaredClass);
				} else {
					return inComp instanceof inClass;
				}
			}
		};
		return wm.listMatchingComponents(inOwners, isRequestedType);
	};
	wm.listComponentIds = function (inOwners, inClass, inStrict) {
		var d = [], l = wm.listComponents.call(dojo.global, inOwners, inClass, inStrict);
		dojo.forEach(l, function (c) {
			d.push(c.getId());
		});
		d.sort();
		return d;
	};
	wm.openUrl = function (inUrl, inTitle, inWindowName) {
		var w = window.open(inUrl, inWindowName);
		if (!w) {
			var d = wm.openUrl.dialog;
			if (!d) {
				d = wm.openUrl.dialog = new wm.Dialog({width:320, height:95});
			}
			var target = " target=\"" + (inWindowName || "_blank") + "\"", link = ["<a href=\"", inUrl, , "\"", target, "style=\"color:#FFF\" onclick=\"javascript:wm.openUrl.dialog.dismiss();\">Popup Blocker Detected - Manually Launch ", inTitle || inUrl, "</a>"].join("");
			d.containerNode.innerHTML = ["<table class=\"wmWaitDialog\" width=\"100%\" height=\"100%\" style=\"border: 1px solid #363b44;\">", "<tr><td align=\"center\" valign=\"middle\">", link, "</td></tr></table>"].join("");
			d.show();
		}
	};
	wm.makeLoginHtml = function (fileTemplate, inProjectName, themeName) {
		var macros = ["PROJECT"], data = [inProjectName], t = fileTemplate;
		for (var i = 0, m, d; (m = macros[i]); i++) {
			d = data[i] || "";
			t = t.replace(new RegExp(["{%", m, "}"].join(""), "g"), d);
			t = t.replace(/\wavemakerNode\"\}/, "wavemakerNode\", theme:\"" + themeName + "\", name:\"" + studio.project.projectName + "\"}");
		}
		return t;
	};
}
if (!dojo._hasResource["wm.studio.app.mainNavigation"]) {
	dojo._hasResource["wm.studio.app.mainNavigation"] = true;
	dojo.provide("wm.studio.app.mainNavigation");
	Studio.extend({navGotoDesignerClick:function () {
		this.disableMenuBar(false);
		this.disableCanvasOnlyMenuItems(false);
		this.toggleCanvasSourceBtns(true, false, false);
		this.tabs.setLayer("workspace");
		if (this.page) {
			if (this._themeDesignerChange) {
				this._themeDesignerChange = false;
				studio.application.useWidgetCache();
			}
			if (this._reflowPageDesigner) {
				this._reflowPageDesigner = false;
				wm.onidle(this.page, "reflow");
			}
		}
	}, navGotoSourceClick:function () {
		this.disableMenuBar(false);
		this.disableCanvasOnlyMenuItems(true);
		this.toggleCanvasSourceBtns(false, true, false);
		this.tabs.setLayer("sourceTab");
	}, navGotoResourcesClick:function () {
		this.disableMenuBar(false);
		this.disableCanvasOnlyMenuItems(true);
		this.toggleCanvasSourceBtns(false, false, true);
		this.tabs.setLayer("resourcesTab");
		this.resourcesPage.getComponent("resourceManager").loadResources();
	}, navGoToLoginPage:function () {
		this.disableCanvasOnlyMenuItems(true);
		this.disableMenuBar(true);
		if (this.loginPage.page != "Login") {
			this.loginPage.setPageName("Login");
		}
		this.tabs.setLayer("loginLayer");
	}, navGoToDeploymentPage:function () {
		this.disableMenuBar(false);
		this.disableCanvasOnlyMenuItems(true);
		this.toggleCanvasSourceBtns(false, false, false);
		if (this.deploymentPage.page != "DeploymentPage") {
			this.deploymentPage.setPageName("DeploymentPage");
		}
		this.tabs.setLayer("deploymentLayer");
		if (this.deploymentPage.page && this.deploymentPage.page instanceof DeploymentPage) {
			this.deploymentPage.page.setup();
		}
	}, isLoginShowing:function () {
		return this.tabs.getLayer().name == "loginTab";
	}, toggleCanvasSourceBtns:function (inCanvasOn, inSourceOn, inResourcesOn) {
		dojo.removeClass(this.designerCanvasBtn.domNode, (inCanvasOn ? "Studio-sourceCanvasBtn" : "Studio-designerCanvasBtn"));
		dojo.addClass(this.designerCanvasBtn.domNode, (inCanvasOn ? "Studio-designerCanvasBtn" : "Studio-sourceCanvasBtn"));
		dojo.removeClass(this.designerSourceBtn.domNode, (inSourceOn ? "Studio-designerSourceBtn" : "Studio-sourceSourceBtn"));
		dojo.addClass(this.designerSourceBtn.domNode, (inSourceOn ? "Studio-sourceSourceBtn" : "Studio-designerSourceBtn"));
		dojo.removeClass(this.designerResourcesBtn.domNode, (inResourcesOn ? "Studio-designerResourceBtn" : "Studio-sourceResourceBtn"));
		dojo.addClass(this.designerResourcesBtn.domNode, (inResourcesOn ? "Studio-sourceResourceBtn" : "Studio-designerResourceBtn"));
	}, disableCanvasSourceBtns:function (inDisable) {
		this.leftToolbarButtons.setDisabled(inDisable);
		this.leftToolbarButtons.reflow();
	}, navGotoEditor:function (inEditorName) {
		this.disableCanvasOnlyMenuItems(true);
		this.toggleCanvasSourceBtns(false, false);
		return this.getEditor(inEditorName, true);
	}, getEditor:function (inEditorName, inNav) {
		var n = wm.decapitalize(inEditorName);
		var i = this.tabs.indexOfLayerName(n);
		if (i < 0) {
			return this.addEditor(inEditorName, inNav);
		} else {
			inNav && this.tabs.setLayerIndex(i);
			return this.tabs.getLayer(i).getOrderedWidgets()[0];
		}
	}, addEditor:function (inEditorName, inNav) {
		var n = wm.decapitalize(inEditorName);
		var t = inNav ? this.tabs.addLayer(n) : this.tabs.createLayer(n);
		var editor = studio.createComponent(n + "Container", "wm.PageContainer", {parent:t, pageName:inEditorName, width:"100%", height:"100%"});
		editor.reflowParent();
		return editor;
	}, navGotoPaletteModelClick:function () {
		var n = this.left.getLayerCaption();
		switch (n) {
		  case "Palette":
			this.navGotoModelTreeClick();
			break;
		  case "Model":
		  default:
			this.navGotoPaletteTreeClick();
			break;
		}
	}, navGotoPaletteTreeClick:function () {
		this.left.setLayer("mlpal");
	}, navGotoModelTreeClick:function () {
		this.left.setLayer("leftObjects");
	}, navGotoProjectTreeClick:function () {
		this.left.setLayer("projects");
	}});
}
if (!dojo._hasResource["wm.studio.app.keyconfig"]) {
	dojo._hasResource["wm.studio.app.keyconfig"] = true;
	dojo.provide("wm.studio.app.keyconfig");
	wm.studioConfig = wm.studioConfig || {};
	wm.studioConfig.hotkeyMap = [{key:"X", action:"cutClick"}, {key:"C", action:"copyClick"}, {key:"V", action:"pasteClick"}, {key:"W", action:"toggleWidthClick"}, {key:"H", action:"toggleHeightClick"}, {key:"F", action:"toggleFlexBcClick"}, {key:"O", action:"toggleHorizontalAlignClick"}, {key:"E", action:"toggleVerticalAlignClick"}, {key:"B", action:"toggleLayoutClick"}, {key:"Z", action:"undoClick"}, {key:"M", action:"navGotoPaletteModelClick", always:true}, {key:"S", action:"saveProjectClick", always:true, idleDelay:true}, {key:"R", action:"runProjectClick", always:true, idleDelay:true}];
	wm.studioConfig.hotkeyCodeMap = [{key:dojo.keys.ESCAPE, action:"selectParent"}, {key:46, action:"deleteControl"}, {key:dojo.keys.DELETE, action:"deleteControl"}, {key:dojo.keys.BACKSPACE, action:"nullAction"}, {key:191, action:"keyboardShortcutsDialog"}];
}
if (!dojo._hasResource["wm.studio.app.Palette"]) {
	dojo._hasResource["wm.studio.app.Palette"] = true;
	dojo.provide("wm.studio.app.Palette");
	dojo.declare("wm.Palette", wm.Tree, {init:function () {
		this.items = [];
		this.inherited(arguments);
		this.connect(this.domNode, "onmousedown", this, "mousedown");
		this.dragger = new wm.design.Mover();
		this.dragger.ondrop = dojo.hitch(this, "dragDrop");
	}, mousedown:function (e) {
		var t = this.findEventNode(e);
		if (t) {
			if (t.klass) {
				if (t.klass == "wm.Template" && t.name != "") {
					t.props.name = t.name;
				}
				this.drag(e, t.klass, t.props, t);
			} else {
				if (t.parent == this.root && e.target != t.btnNode) {
					t.setOpen(t.closed);
				}
			}
		}
	}, drag:function (inEvent, inType, inProps, obj) {
		if (!studio.page) {
			return;
		}
		this.dragger.beginDrag(inEvent, {caption:inType, type:inType, props:inProps, obj:obj});
	}, dragDrop:function () {
		if (!this.dragger.target) {
			return;
		}
		var info = this.dragger.info;
		var props = dojo.clone(info.props || {});
		if (props.name) {
			props.name = props.name.replace(/\s/g, "");
		}
		var ctor = dojo.getObject(info.type);
		dojo.mixin(props, {_designer:studio.page._designer, name:studio.page.getUniqueName(props.name || studio.makeName(info.type)), owner:studio.page, parent:this.dragger.target});
		if (ctor.prototype instanceof wm.Control) {
			props.height = ctor.prototype.height || props.height || "48px";
			props.width = ctor.prototype.width || props.width || "96px";
		}
		studio.application.loadThemePrototypeForClass(ctor);
		var comp = new ctor(props);
		if (comp) {
			if (!(comp instanceof wm.ServerComponent)) {
				new wm.AddTask(comp);
			}
			if (comp instanceof wm.Control) {
				this.dragger.target.designMoveControl(comp, this.dragger.dropRect);
			}
			if (!wm.fire(comp, "afterPaletteDrop")) {
				studio.refreshDesignTrees();
				studio.inspector.resetInspector();
				studio.select(comp);
			}
		}
	}, makeGroup:function (inGroup, inParentIndex) {
		if (this.findItemByName(inGroup)) {
			return;
		}
		var props = {content:inGroup, name:inGroup, closed:true};
		if (inParentIndex !== undefined) {
			props.parentIndex = inParentIndex;
		}
		var n = new wm.TreeNode(this.root, props);
		if (n == this.root.kids[0] || n == this.root.kids[1] || n == this.root.kids[2]) {
			n.setOpen(true);
		}
		return n;
	}, addItem:function (inTab, inName, inDescription, inImage, inClass, inProps) {
		if (inTab) {
			var p = this.findItemByName(inTab) || this.makeGroup(inTab);
			wm.fire(this.findItemByName(inName, p), "destroy");
			var n = new wm.TreeNode(p, {name:inName, content:inName, image:inImage, klass:inClass, props:inProps});
		}
		wm.Palette.items[inClass] = {desc:inDescription, image:inImage, klass:inClass};
	}, removeItem:function (inTab, inName) {
		var g = this.findItemByName(inTab);
		if (g) {
			for (var i = 0, nodes = g.kids, l = nodes.length, n; i < l; i++) {
				n = nodes[i];
				if (n && n.name == inName) {
					g.remove(n);
					if (!g.kids || !g.kids.length) {
						g.destroy();
					}
					return;
				}
			}
		}
	}, getItemNames:function (inTab) {
		var g = this.findItemByName(inTab), names = [];
		if (g) {
			for (var i = 0, nodes = g.kids, l = nodes.length, n; i < l; i++) {
				names.push(nodes[i].name);
			}
		}
		return names;
	}, findItemByName:function (inName, inParent) {
		inParent = inParent || this.root;
		for (var i = 0, nodes = inParent.kids, n; (n = nodes[i]); i++) {
			if (inName == (n || 0).name) {
				return n;
			}
		}
	}, select:function () {
	}, setLayerIndex:function () {
	}, clearSection:function (inName) {
		var p = this.findItemByName(inName);
		if (p) {
			dojo.forEach(p.kids, function (n) {
				delete wm.Palette.items[n.klass];
			});
			p.removeChildren();
		}
	}, removeSection:function (inName) {
		wm.fire(this.findItemByName(inName), "destroy");
	}});
	wm.Palette.items = [];
}
if (!dojo._hasResource["wm.studio.app.binding"]) {
	dojo._hasResource["wm.studio.app.binding"] = true;
	dojo.provide("wm.studio.app.binding");
	wm.widgetIsBindSource = function (inWidget) {
		inWidget._isBindSource = inWidget._isBindSource !== undefined ? inWidget._isBindSource : !wm.isEmpty(inWidget.listDataProperties("bindSource"));
		return inWidget._isBindSource;
	};
	wm.widgetIsBindTarget = function (inWidget) {
		inWidget._isBindTarget = inWidget._isBindTarget !== undefined ? inWidget._isBindTarget : !wm.isEmpty(inWidget.listDataProperties("bindTarget"));
		return inWidget._isBindTarget;
	};
	wm.hasBindableWidgets = function (inWidget, inExcludeWidget) {
		var b, f = dojo.hitch(this, function (w) {
			b = b || (w != inExcludeWidget && wm.widgetIsBindSource(w));
		});
		for (var i in inWidget.widgets) {
			wm.forEachWidget(inWidget.widgets[i], f);
		}
		return b;
	};
	addComponentTypeBinderNodes = function (inParent, inClass, inStrict) {
		var comps = wm.listComponents([studio.application, studio.page], inClass, inStrict);
		comps.sort(function (a, b) {
			return wm.data.compare(a.name, b.name);
		});
		dojo.forEach(comps, function (c) {
			if (c != studio.selected) {
				new wm.BindSourceTreeNode(inParent, {object:c});
			}
		});
	};
	addWidgetBinderNodes = function (inParent, optionalWidgets) {
		var types = [wm.AbstractEditor, wm.Composite, wm.DataGrid, wm.DojoGrid, wm.Editor, wm.List, wm.LiveForm];
		var widgets = optionalWidgets || wm.listOfWidgetTypes(types);
		var page = studio.page;
		widgets.sort(function (a, b) {
			return wm.data.compare(a.name, b.name);
		});
		dojo.forEach(widgets, function (w) {
			if (w != studio.selected) {
				var props = {object:w}, object = props.object, schema = object.listDataProperties("bindSource");
				dojo.mixin(props, {isObject:true, isList:object.isList, _hasChildren:!wm.isEmpty(schema), objectId:object.getId(), name:object.name, schema:schema, image:props.image || studio.getComponentImage(object)});
				var b = wm.convertForSimpleBind(props);
				if (b) {
					var p = inParent.parent.owner;
					if ((w instanceof wm.Editor || w instanceof wm.AbstractEditor) && !wm.isNodeBindable(props.type, props, props.isList, p.targetType, p.targetProps)) {
						return;
					}
				}
				new wm.SimpleBindSourceTreeNode(inParent, {object:w});
			}
		});
	};
	addResourceBinderNodes = function (inParent, inFile, isRoot) {
		var newfile;
		var filename = inFile.file;
		if (inFile.type == "file") {
			var ext = filename.substring(filename.lastIndexOf(".") + 1);
			var newfile;
			switch (ext) {
			  case "jpg":
			  case "jpeg":
			  case "gif":
			  case "png":
			  case "tif":
			  case "bmp":
				newfile = new wm.ImageResourceItem({});
				break;
			  case "jar":
				newfile = new wm.JarResourceItem({});
				newfile.isInClassPath = inFile.isInClassPath;
				break;
			  case "zip":
				newfile = new wm.ZipResourceItem({});
				break;
			  case "js":
				newfile = new wm.JSResourceItem({});
				break;
			  case "css":
				newfile = new wm.CSSResourceItem({});
				break;
			  case "html":
				newfile = new wm.HTMLResourceItem({});
				break;
			  default:
				newfile = new wm.MiscResourceItem({});
			}
		} else {
			newfile = new wm.FolderResourceItem({});
		}
		newfile.itemName = inFile.file;
		var extensionMatch = null;
		var owner = null;
		var parent = inParent;
		while (parent && !parent.owner) {
			parent = parent.parent;
		}
		if (parent) {
			owner = parent.owner;
		}
		if (owner.targetProps) {
			var props = owner.targetProps;
			extensionMatch = props.extensionMatch;
		}
		var node = new wm.ResourceTreeNode(inParent, {file:inFile, content:newfile.itemName, data:newfile, closed:!isRoot, isProperty:true, isValidBinding:(!extensionMatch || ext && dojo.indexOf(extensionMatch, ext.toLowerCase()) != -1) ? true : false, source:((inParent.source) ? inParent.source + "/" : "") + escape(inFile.file), image:newfile.iconSrc});
		newfile.treeNode = node;
		return newfile;
	};
	wm.convertForSimpleBind = function (inNodeProps) {
		var p;
		for (var n in inNodeProps.schema) {
			var property = inNodeProps.schema[n];
			if (property.simpleBindProp) {
				p = {name:n, property:property};
			}
		}
		if (p) {
			inNodeProps.source = [inNodeProps.source, p.name].join(".");
			inNodeProps.objectId = inNodeProps.source;
			inNodeProps.isObject = p.property.isObject;
			inNodeProps.isList = p.property.isList;
			inNodeProps.type = p.property.type;
			var schema;
			if (p.property.isObject) {
				var o = inNodeProps.object.getValue(p.name);
				if (o) {
					schema = o.listDataProperties("bindSource");
					inNodeProps.object = o;
				}
			}
			inNodeProps.schema = schema;
			inNodeProps.isSimpleBind = true;
			inNodeProps._hasChildren = !wm.isEmpty(schema);
			return true;
		}
	};
	wm.isNodeBindable = function (inType, inProps, inIsList, inTargetType, inTargetProps) {
		if (!inTargetType) {
			return;
		}
		if (!inProps.isSimpleBind && inProps.isObject && inProps.object instanceof wm.Control) {
			return inProps.object.declaredClass == inTargetType.type;
		}
		var t = (!inProps.isSimpleBind && inType) || inProps.type || (inProps.object && inProps.object.type);
		var originalT = t;
		t = wm.typeManager.getPrimitiveType(t) || t;
		var o = inProps.isSimpleBind ? inProps.isObject : wm.typeManager.isStructuredType(t);
		if (!o) {
			t = wm.decapitalize(t);
		}
		if (!inTargetType.isObject) {
			inTargetType.type = wm.decapitalize(inTargetType.type);
		}
		if (inTargetType.isList && !inIsList) {
			return false;
		}
		if (!inTargetType.isList && inIsList && !(inTargetProps.object instanceof wm.LiveForm)) {
			return false;
		}
		var b = (t == inTargetType.type);
		if (!b) {
			if (inTargetType.type == "wm.Variable") {
				b = wm.typeManager.isStructuredType(t) || (originalT != t && originalT);
			} else {
				if (!inTargetType.isObject && !o) {
					b = true;
				} else {
					if (inTargetType.isList && inIsList && (inTargetProps.object instanceof wm.DojoChart || inTargetProps.object instanceof wm.DojoGrid)) {
						b = true;
					}
				}
			}
		}
		return b;
	};
	dojo.declare("wm.BinderSource", [wm.Panel], {flex:1, box:"v", resourcesModifiedData:0, _source:{bindPanelOuter:["wm.Panel", {width:"100%", height:"100%", layoutKind:"left-to-right"}, {}, {propList:["wm.List", {border:"1,2,1,1", borderColor:"#5D6678", width:"147px", height:"100%", headerVisible:false, dataFields:"name"}], bindPanel:["wm.Panel", {width:"100%", height:"100%", layoutKind:"top-to-bottom"}, {}, {searchBar:["wm.Text", {height:"25px", width:"100%", captionSize:"60px", caption:"検索", changeOnKey:true, changeOnEnter:true}], treeControlsPanel:["wm.Panel", {border:0, height:"22px", layoutKind:"left-to-right", width:"100%"}, {}, {simpleRb:["wm.Editor", {display:"RadioButton", displayValue:"simple", caption:"簡単", width:"76px", captionSize:"50px", captionPosition:"right", captionAlign:"left"}, {}, {editor:["wm._RadioButtonEditor", {radioGroup:"_bindInspector", startChecked:true}, {}]}], advancedRb:["wm.Editor", {display:"RadioButton", displayValue:"advanced", caption:"高度", width:"94px", captionSize:"68px", captionPosition:"right", captionAlign:"left"}, {}, {editor:["wm._RadioButtonEditor", {radioGroup:"_bindInspector"}, {}]}], resourceRb:["wm.Editor", {display:"RadioButton", displayValue:"resources", caption:"リソース", width:"100px", captionSize:"72px", captionPosition:"right", captionAlign:"left"}, {}, {editor:["wm._RadioButtonEditor", {radioGroup:"_bindInspector"}, {}]}], expressionRb:["wm.Editor", {display:"RadioButton", displayValue:"expression", caption:"式", width:"100px", captionSize:"74px", captionPosition:"right", captionAlign:"left"}, {}, {editor:["wm._RadioButtonEditor", {radioGroup:"_bindInspector"}, {}]}], spacer1:["wm.Spacer", {height:"100%", width:"100%"}, {}], validLabel:["wm.Picture", {height:"100%", width:"20px", source:"images/active.png", showing:false}, {}], invalidLabel:["wm.Picture", {height:"100%", width:"20px", source:"images/inactive.png", showing:false}, {}], spacer2:["wm.Spacer", {height:"100%", width:"40px"}, {}]}], bindLayers:["wm.Layers", {border:0, height:"100%", layoutKind:"top-to-bottom"}, {}, {treeLayer:["wm.Layer", {border:0, caption:"ツリー"}, {}, {tree:["wm.Tree", {border:0, padding:2, height:"100%", width:"100%"}, {}, {}], bindEditor:["wm.Editor", {height:"30px", width:"100%", padding:"4,0"}, {}, {editor:["wm._TextEditor", {}, {}]}]}], expressionLayer:["wm.Layer", {border:0, caption:"式"}, {}, {expressionEditor:["wm.Editor", {display:"TextArea", padding:0, width:"100%", height:"100%"}, {}, {editor:["wm._TextAreaEditor", {}, {}]}], expressionBuilderPanel:["wm.Panel", {height:"150px", width:"100%", verticalAlign:"top", horizontalAlign:"left"}, {}, {expressionButtons:["wm.Panel", {height:"25px", width:"100%", layoutKind:"left-to-right", verticalAlign:"top", horizontalAlign:"left"}, {}, {button1:["wm.Button", {caption:"+", margin:2, width:"24px", height:"100%"}, {}], button2:["wm.Button", {caption:"-", margin:2, width:"24px", height:"100%"}, {}], button3:["wm.Button", {caption:"/", margin:2, width:"24px", height:"100%"}, {}], button4:["wm.Button", {caption:"*", margin:2, width:"24px", height:"100%"}, {}]}], expressionTree:["wm.Tree", {margin:2, border:0, padding:2, height:"100%", width:"100%"}, {}, {}]}]}]}]}]}]}, propListVar:null, init:function () {
		this.propListVar = new wm.Variable({name:"propListVar", type:"EntryData", owner:this});
		dojo.addClass(this.domNode, "wmbindersource");
		this.createComponents(this._source);
		this.mixinWidgets(this.widgets);
		this.propList.connect(this.propList, "onselect", this, function () {
			_this.owner.update({object:_this.owner.targetProps.object, targetProperty:this.propList.selectedItem.getData().dataValue}, true);
		});
		this.searchBar.connect(this.searchBar, "onchange", this, function (inDisplayValue, inDataValue) {
			_this.updateBindSourceUi("search");
		});
		var _this = this;
		this.simpleRb.connect(this.simpleRb, "onchange", this, function (inDisplayValue, inDataValue) {
			if (inDataValue == "simple") {
				_this.updateBindSourceUi(inDataValue);
			}
		});
		this.advancedRb.connect(this.advancedRb, "onchange", this, function (inDisplayValue, inDataValue) {
			if (inDataValue == "advanced") {
				_this.updateBindSourceUi(inDataValue);
			}
		});
		this.resourceRb.connect(this.resourceRb, "onchange", this, function (inDisplayValue, inDataValue) {
			if (inDataValue == "resources") {
				_this.updateBindSourceUi(inDataValue);
			}
		});
		this.expressionRb.connect(this.expressionRb, "onchange", this, function (inDisplayValue, inDataValue) {
			if (inDataValue == "expression") {
				_this.updateBindSourceUi(inDataValue);
			}
		});
		this.tree.connect(this.tree, "onselect", this, "bindNodeSelected");
		this.expressionTree.connect(this.expressionTree, "onselect", this, "expressionNodeSelected");
		for (var i = 0, c; c = this.expressionButtons.c$[i]; i++) {
			if (c instanceof wm.Button) {
				this.connect(c, "onclick", this, "expressionButtonClicked");
			}
		}
		this.inherited(arguments);
	}, mixinWidgets:function (inWidgets) {
		dojo.mixin(this, inWidgets || {});
		for (var i in inWidgets) {
			this.mixinWidgets(inWidgets[i].widgets);
		}
	}, initBinding:function (noRegen) {
		if (!noRegen && !this._applyingBinding) {
			this._setRbEditorChecked(this.simpleRb);
			this.searchBar.setDataValue("");
			this.updateBindSourceUi("simple");
		}
		if (this.owner.targetProps) {
			var object = this.owner.targetProps.object;
			var prop = this.owner.targetProps.targetProperty;
			var propPrefix = "";
			if (prop.indexOf(".") != -1) {
				propPrefix = prop.replace(/\..*?$/, "");
				prop = prop.replace(/^.*\./, "");
				object = object.getValue(propPrefix);
				propPrefix += ".";
			}
			if (propPrefix) {
				var propList = object.listDataProperties("bindTarget");
				var list = [];
				var selectedIndex = -1;
				for (var i in propList) {
					list.push({dataValue:propPrefix + i, name:i});
					if (propPrefix + i == this.owner.targetProps.targetProperty) {
						selectedIndex = list.length - 1;
					}
				}
				this.propListVar.setData(list);
				this.propList.setDataSet(this.propListVar);
				if (selectedIndex != this.propList.getSelectedIndex()) {
					this.propList.select(this.propList.getItem(selectedIndex));
				}
				this.owner.applyStayButton.show();
				this.propList.show();
			} else {
				this.propList.hide();
				this.owner.applyStayButton.hide();
			}
		}
	}, _setRbEditorChecked:function (inRbEditor) {
		this.simpleRb.beginEditUpdate();
		this.advancedRb.beginEditUpdate();
		this.expressionRb.beginEditUpdate();
		this.resourceRb.beginEditUpdate();
		inRbEditor.editor.setChecked(true);
		this.simpleRb.endEditUpdate();
		this.advancedRb.endEditUpdate();
		this.expressionRb.endEditUpdate();
		this.resourceRb.endEditUpdate();
	}, isSimpleTree:function () {
		return Boolean(this.simpleRb.getValue("groupValue") == "simple");
	}, isExpression:function () {
		return Boolean(this.expressionRb.getValue("groupValue") == "expression");
	}, isResource:function () {
		return Boolean(this.simpleRb.getValue("groupValue") == "resources");
	}, updateUiForWire:function (inWire) {
		if (inWire) {
			var s = inWire.source || "", ex = inWire.expression || "";
			this.bindEditor.setValue("dataValue", s);
			this.expressionEditor.setValue("dataValue", inWire.expression || "");
			var rb = ex ? this.expressionRb : this.simpleRb;
			this._setRbEditorChecked(rb);
			if (ex) {
				this.expressionLayer.activate();
				this.validLabel.setShowing(false);
				this.invalidLabel.setShowing(false);
			} else {
				this.treeLayer.activate();
				this.expandBySource(s);
			}
		} else {
			this.tree.select(null);
			this.bindEditor.setValue("dataValue", "");
			this.expressionEditor.setValue("dataValue", "");
			this.validLabel.setShowing(false);
			this.invalidLabel.setShowing(false);
		}
	}, updateBindSourceUi:function (gv) {
		var t = this.tree;
		t.clear();
		var r = t.root;
		if (gv != "resources" && this.searchBar.getDataValue()) {
			gv = "search";
		}
		switch (gv) {
		  case "search":
			this.searchBar.setDisabled(false);
			wm.onidle(this, function () {
				this.treeLayer.activate();
				if (this.simpleRb.getGroupValue() == "expression") {
					this.expressionTree.clear();
					this.expressionLayer.activate();
					this._buildSearchTree(this.expressionTree.root);
					this.validLabel.setShowing(false);
					this.invalidLabel.setShowing(false);
				} else {
					this._buildSearchTree(r);
				}
			});
			break;
		  case "simple":
			this.searchBar.setDisabled(false);
			this.treeLayer.activate();
			this._buildSimpleTree(r);
			break;
		  case "advanced":
			this.searchBar.setDisabled(false);
			this.treeLayer.activate();
			this._buildAdvancedTree(r);
			break;
		  case "expression":
			this.searchBar.setDisabled(false);
			this.expressionTree.clear();
			this.expressionLayer.activate();
			this._buildAdvancedTree(this.expressionTree.root);
			this.validLabel.setShowing(false);
			this.invalidLabel.setShowing(false);
			break;
		  case "resources":
			this.searchBar.setDisabled(true);
			this.treeLayer.activate();
			this._buildResourceTree(r);
			this.invalidLabel.setShowing(false);
			break;
		}
	}, _buildSearchTree:function (inParent) {
		var search = this.searchBar.getDataValue();
		if (!search) {
			this.updateBindSourceUi(this.simpleRb.getGroupValue());
			return;
		}
		var appcomps = this.doSearch(studio.application);
		var pagecomps = this.doSearch(studio.page);
		if (this.simpleRb.getGroupValue() == "simple") {
			addWidgetBinderNodes(inParent, appcomps);
			addWidgetBinderNodes(inParent, pagecomps);
			if (this.tree.root.kids.length <= 2) {
				for (var i = 0; i < this.tree.root.kids.length; i++) {
					this.tree.root.kids[i].setOpen(true);
				}
			}
		} else {
			var count = appcomps.length + pagecomps.length;
			dojo.forEach(appcomps, function (c) {
				if (c != studio.selected) {
					new wm.BindSourceTreeNode(inParent, {object:c, closed:count > 2});
				}
			});
			dojo.forEach(pagecomps, function (c) {
				if (c != studio.selected) {
					new wm.BindSourceTreeNode(inParent, {object:c, closed:count > 2});
				}
			});
		}
	}, _buildSimpleTree:function (inParent) {
		addComponentTypeBinderNodes(inParent, wm.ServiceVariable);
		addComponentTypeBinderNodes(inParent, wm.Variable, true);
		addWidgetBinderNodes(inParent);
	}, _buildAdvancedTree:function (inParent) {
		new wm.ComponentTypeSourceTreeNode(inParent, {content:"Non-visual Components", className:"wm.Variable", canSelect:false});
		new wm.WidgetContainerSourceTreeNode(inParent, {content:"Visual Components", object:studio.page.root, hasSchema:true, canSelect:false});
	}, _buildResourceTree:function (inParent) {
		var _this = this;
		if (this.resourceData && this.resourcesModifiedData >= studio.resourcesModifiedData) {
			addResourceBinderNodes(inParent, this.resourceData, true);
			return;
		}
		studio.resourceManagerService.requestAsync("getResourceFolder", [], function (rootfolder) {
			_this.resourceData = rootfolder;
			_this.resourcesModifiedData = new Date().getTime();
			addResourceBinderNodes(inParent, rootfolder, true);
		});
	}, expandBySource:function (inSource) {
		var prop = inSource.split("."), object = prop.shift();
		if (this.isSimpleTree()) {
			if (!this._expandSimpleTree(object, prop)) {
				this._setRbEditorChecked(this.advancedRb);
				this.updateBindSourceUi();
				if (!this._expandAdvancedTree(object, prop)) {
					this._setRbEditorChecked(this.simpleRb);
					this.updateBindSourceUi();
				}
			}
		} else {
			this._expandAdvancedTree(object, prop);
		}
	}, _expandSimpleTree:function (inObject, inProp) {
		var nodes = this.tree.root.kids;
		for (var i = 0, n; (n = nodes[i]); i++) {
			if (n.expandBySource && n.expandBySource(inObject, inProp)) {
				return true;
			}
		}
	}, _expandAdvancedTree:function (inObject, inProp) {
		return this._expandSimpleTree(inObject, inProp);
	}, canBind:function (inTargetProps, inSourceProps) {
		var tp = inTargetProps, sp = inSourceProps;
		if (!tp || !sp) {
			return;
		}
		if (sp.expression) {
			return true;
		}
		if (!tp.targetProperty) {
			return;
		}
		var type = tp.staticType, typeObject = type && dojo.getObject(type), sourceValue = studio.page.getValueById(sp.source);
		if (typeObject && typeObject.prototype instanceof wm.Object) {
			if (!(sourceValue instanceof typeObject)) {
				return;
			}
		}
		if (tp.isList && !wm.fire(sourceValue, "isListBindable")) {
			return;
		}
		return true;
	}, applyBinding:function (inTargetProps) {
		var blankMessage = "Please select a bind value or expression.", errorMessage = "Binding aborted due to the following error: ", isExpression = this.isExpression(), isResource = this.isResource(), s = !isExpression && !isResource && this.bindEditor.getValue("dataValue"), ex = isExpression && this.expressionEditor.getValue("dataValue") || isResource && this.bindEditor.getValue("dataValue"), tp = inTargetProps;
		if (isResource) {
			tp.object.setValue(tp.targetProperty, ex);
			wm.data.clearBinding(tp.object, tp.targetProperty);
			studio.inspector.reinspect();
			return true;
		}
		if (!(s || ex)) {
			alert(blankMessage);
		} else {
			try {
				wm.data.clearBinding(tp.object, tp.targetProperty);
				var info = this._getBindingInfo(tp.object, tp.targetProperty, s, ex);
				wp = info.wireProps;
				if (info.binding && wp.targetProperty && (wp.source || wp.expression)) {
					info.binding.addWire(wp.targetId, wp.targetProperty, wp.source, wp.expression);
					wm.logging && console.log("binding created:", info.targetId, wp.source || wp.expression);
					this._applyingBinding = true;
					studio.inspector.reinspect();
					this._applyingBinding = false;
				} else {
					wm.logging && console.debug("no binding owner or nothing to bind");
				}
			}
			catch (e) {
				wm.data.clearBinding(tp.object, tp.targetProperty);
				alert(errorMessage + e);
				return;
			}
		}
		return true;
	}, _getBindingInfo:function (inTargetObject, inTargetProp, inSource, inExpression) {
		var sa = studio.application, tobj = inTargetObject, sobj = inExpression ? this._getExpressionPageSourceObject(inExpression) : this._getSourceObject(inSource), sourceBind = tobj.isOwnedBy(sa) && sobj && !sobj.isOwnedBy(sa), targetId = (tobj || 0).getId();
		return {binding:(sourceBind ? sobj : tobj).getComponent("binding"), targetId:targetId, wireProps:{targetId:sourceBind ? targetId : "", targetProperty:inTargetProp, source:inSource, expression:inExpression}};
	}, _getSourceObject:function (inSource) {
		var parts = (inSource || "").split("."), o = [];
		parts.length = (parts.length && parts[0] == "app") ? 2 : 1;
		return studio.page.getValueById(parts.join("."));
	}, _getExpressionPageSourceObject:function (inExpression) {
		var sources = wm.expression.getSources(inExpression);
		for (var i = 0, o, s; (s = sources[i]); i++) {
			o = this._getSourceObject(s);
			if (o && o.isOwnedBy(studio.page)) {
				return o;
			}
		}
	}, bindNodeSelected:function (inNode) {
		if (inNode.isProperty) {
			this.onBindNodeSelected(inNode);
		}
	}, onBindNodeSelected:function (inNode) {
		var b = inNode.isValidBinding;
		this.validLabel.setShowing(b);
		this.invalidLabel.setShowing(!b);
	}, addValueToExpressionEditor:function (inValue) {
		var v = inValue, start = this.expressionEditor.editor.editor.focusNode.selectionStart, end = this.expressionEditor.editor.editor.focusNode.selectionEnd, e = this.expressionEditor.getDataValue() || "";
		this.expressionEditor.setDataValue(e.slice(0, start) + v + e.slice(end));
	}, expressionNodeSelected:function (inNode) {
		if (inNode.isProperty && inNode.source) {
			this.addValueToExpressionEditor(["${", inNode.source, "}"].join(""));
		}
	}, expressionButtonClicked:function (e) {
		this.addValueToExpressionEditor(e.target.innerHTML);
	}, doSearch:function (owner) {
		var search = this.searchBar.getDataValue();
		var searchByExactName = false;
		if (search.indexOf("#") == 0) {
			search = search.substring(1);
			searchByExactName = true;
		}
		var searchRegex = new RegExp(search, "i");
		var data = [];
		var comps = owner.components;
		for (var comp in comps) {
			if (comp) {
				c = comps[comp];
			}
			if (c) {
				if (searchByExactName) {
					if (c.name == search) {
						data.push(c);
					}
				} else {
					if (c.declaredClass.match(searchRegex) || c.name.match(searchRegex)) {
						if (wm.widgetIsBindSource(c)) {
							data.push(c);
						}
					} else {
						var props = c.listDataProperties("bindSource");
						for (var p in props) {
							if (p.match(searchRegex)) {
								data.push(c);
								break;
							}
						}
					}
				}
			}
		}
		return data;
	}});
	dojo.declare("wm.BindTreeNode", wm.TreeNode, {initProps:function (inProps) {
		this.initObjectProps(inProps);
		this.closed = true;
		this.inherited(arguments);
	}, initObjectProps:function (inProps) {
		var props = inProps, object = props.object, schema = this.listDataProperties(object);
		dojo.mixin(props, {isObject:true, isList:object.isList, _hasChildren:!wm.isEmpty(schema), objectId:object.getId(), name:object.name, schema:schema, image:props.image || studio.getComponentImage(object)});
		this.initBindingProps(this.parent, props);
		props.content = props.content || this.getNodeContent(object.getId(), object.type, object.isList, props);
	}, dumpSchema:function (inParent, inSchema) {
		inParent.hasSchema = true;
		var props = [];
		for (var n in inSchema) {
			props.push({name:n, property:inSchema[n]});
		}
		props.sort(function (a, b) {
			return wm.data.compare(a.name, b.name);
		});
		dojo.forEach(props, function (p) {
			var nodeProps = {};
			this.initSchemaProps(p.name, p.property, inParent, nodeProps);
			this.initBindingProps(inParent, nodeProps);
			nodeProps.content = this.getNodeContent(p.name, nodeProps.schema ? nodeProps.type : "", nodeProps.isList, nodeProps);
			new wm.TreeNode(inParent, nodeProps);
		}, this);
	}, initSchemaProps:function (inName, inProp, inParent, inNodeProps) {
		var n = inName, t = inProp;
		var schema = wm.typeManager.getTypeSchema(t.type), object = inParent.object;
		if (!schema && t.isObject) {
			var o = object.getValue(n);
			if (o) {
				schema = this.listDataProperties(o);
			}
		}
		dojo.mixin(inNodeProps, {isProperty:true, owner:this, object:object, name:n, type:t.type, isList:(t.isList), _hasChildren:!wm.isEmpty(schema), objectId:inParent.objectId || object.getId(), schema:schema, image:"images/wm/type.png", initNodeChildren:dojo.hitch(this, "initNodeChildren"), expandBySchemaProp:this.expandBySchemaProp, closed:true});
	}, initBindingProps:function (inParent, inNodeProps) {
		var o = inNodeProps.object, s = o && o.constructor.prototype.schema, t = s && (s[inNodeProps.name] || 0).type;
		inNodeProps.staticType = inNodeProps.staticType || t;
		inNodeProps._propertyPath = inParent._propertyPath ? [inParent._propertyPath, inNodeProps.name].join(".") : this.parent != inParent ? inNodeProps.name : "";
	}, getNodeContent:function (inName, inType, inIsList, inProps) {
		var p = this.tree.owner;
		inProps.isValidBinding = wm.isNodeBindable(inType, inProps, inIsList, p.targetType, p.targetProps);
		if (inProps.isSimpleBind) {
			inType = inProps.type;
		}
		var r = [inName];
		r.push((inType && inType != "undefined") ? [": <span style=\"font-style: italic;\">", wm.getFriendlyTypeName(inType, inIsList), "</span>"].join("") : "");
		return r.join("");
	}, listDataProperties:function (inComponent) {
		return dojo.mixin({}, inComponent ? inComponent.listDataProperties(this._bindFlag) : {});
	}, initNodeChildren:function (inNode) {
		if (!inNode.hasSchema) {
			this.dumpSchema(inNode, inNode.schema);
		}
	}, expandBySource:function (inObjectId, inProp) {
		var prop = dojo.clone(inProp || []), objectId = inObjectId;
		if (this.isSimpleBind && prop && prop.length) {
			objectId = [objectId, prop.shift()].join(".");
		}
		if (objectId == this.objectId) {
			if (prop && prop.length) {
				this.setOpen(true);
				for (var i = 0, k, kids = this.kids; (k = kids[i]); i++) {
					if (k.expandBySchemaProp(prop)) {
						return true;
					}
				}
			} else {
				this.tree.select(this);
				return true;
			}
		}
	}, expandBySchemaProp:function (inSource) {
		var a = inSource.shift();
		if (this.name == a) {
			if (!inSource.length) {
				this.tree.select(this);
			} else {
				this.setOpen(true);
				for (var i = 0, k, kids = this.kids; (k = kids[i]); i++) {
					if (k.expandBySchemaProp(inSource)) {
						break;
					}
				}
			}
			return true;
		}
		inSource.unshift(a);
	}});
	dojo.declare("wm.BindSourceTreeNode", wm.BindTreeNode, {_bindFlag:"bindSource", initBindingProps:function (inParent, inNodeProps) {
		this.inherited(arguments);
		inNodeProps.source = inNodeProps._propertyPath ? [inNodeProps.objectId, inNodeProps._propertyPath].join(".") : inNodeProps.objectId;
		inNodeProps.isProperty = true;
	}});
	dojo.declare("wm.SimpleBindSourceTreeNode", wm.BindSourceTreeNode, {initBindingProps:function (inParent, inNodeProps) {
		this.inherited(arguments);
		wm.convertForSimpleBind(inNodeProps);
	}});
	dojo.declare("wm.BindTargetTreeNode", wm.BindTreeNode, {_bindFlag:"bindTarget", initObjectProps:function (inProps) {
		var s = inProps.object && inProps.object.constructor.prototype.schema, p;
		for (var i in s) {
			p = s[i];
			if (p.defaultBindTarget && inProps.object.schema[i].defaultBindTarget) {
				inProps.targetProperty = i;
				inProps.staticType = p.type;
				break;
			}
		}
		inProps.targetProperty = inProps.targetProperty || inProps._propertyPath;
		this.inherited(arguments);
	}, initBindingProps:function (inParent, inNodeProps) {
		this.inherited(arguments);
		var np = inNodeProps, tp = np.targetProperty || np._propertyPath;
		dojo.mixin(np, {type:(np.isObject && np.object ? np.object.type : np.type), targetProperty:tp, getNodeContent:this.getNodeContent, updateNodeContent:this.updateNodeContent});
	}, initSchemaProps:function (inName, inProp, inParent, inNodeProps) {
		this.inherited(arguments);
		inNodeProps.clearBinding = this._clearBinding;
	}, getNodeContent:function (inName, inType, inIsList, inProps) {
		var c = wm.BindTreeNode.prototype.getNodeContent.apply(this, arguments), wire = wm.data.getPropWire(inProps.object, inProps.targetProperty);
		this.tree._bindingImage = this.tree._bindingImage || ["&nbsp;", this.formatImage("images/link.png")].join("");
		if (wire) {
			return [c, this.tree._bindingImage, wire.expression ? "(expression)" : wire.source].join("");
		} else {
			return c;
		}
	}, updateNodeContent:function () {
		var schema = this.object && this.object.listDataProperties();
		this.type = (schema[this.name] || 0).type || this.type;
		this.setContent(this.getNodeContent(this.name, this.schema ? this.type : "", this.isList, this));
	}, clearBinding:function () {
		this._clearBinding();
		this.forEachDescendant(function (n) {
			n.clearBinding();
		});
	}, _clearBinding:function () {
		wm.data.clearBinding(this.object, this.targetProperty);
	}});
	dojo.declare("wm.ComponentTypeSourceTreeNode", wm.TreeNode, {initProps:function (inProps) {
		this.inherited(arguments);
		this._hasChildren = true;
		this.closed = true;
		this.image = this.image || studio.getClassNameImage(this.className);
	}, initNodeChildren:function () {
		if (this.className) {
			addComponentTypeBinderNodes(this, dojo.getObject(this.className), this.strict);
		}
	}, expandBySource:function (inObjectId, inProp) {
		var o = studio.page.getValueById(inObjectId);
		if (o && o.declaredClass == this.className) {
			this.setOpen(true);
			for (var i = 0, n, nodes = this.kids; (n = nodes[i]); i++) {
				if (n.expandBySource && n.expandBySource(inObjectId, inProp)) {
					return true;
				}
			}
		}
	}});
	dojo.declare("wm.ResourceTreeNode", wm.TreeNode, {initProps:function (inProps) {
		this.inherited(arguments);
		this._hasChildren = ("files" in this.file && this.file.files.length);
		this.image = this.image || studio.getClassNameImage(this.className);
	}, initNodeChildren:function () {
		var _this = this;
		var children = this.file.files;
		dojo.forEach(children, function (child) {
			addResourceBinderNodes(_this, child, false);
		});
	}});
	dojo.declare("wm.WidgetContainerSourceTreeNode", wm.BindSourceTreeNode, {initProps:function (inProps) {
		this.inherited(arguments);
		this.closed = true;
		this._hasChildren = true;
	}, shouldInitClosed:function () {
		var r = studio.page.root, w = this.object, l = 0, max = 1;
		while (w && w != r) {
			w = w.parent;
			if (l >= max) {
				return true;
			}
			l++;
		}
		return false;
	}, initNodeChildren:function () {
		this.inherited(arguments);
		var widgets = {};
		for (var w in this.object.widgets) {
			widgets[w] = this.object.widgets[w];
		}
		if (this.object == studio.page.root) {
			var comps = wm.listComponents([studio.application, studio.page], wm.Dialog, false);
			for (var w in comps) {
				widgets[w] = comps[w];
			}
		}
		wm.forEachProperty(widgets, dojo.hitch(this, function (w) {
			var s = (w != studio.selected) && wm.widgetIsBindSource(w) && w.id, c = w.container, cw = c && wm.hasBindableWidgets(w, studio.selected);
			if (cw) {
				new wm.WidgetContainerSourceTreeNode(this, {object:w, hasBindableWidgets:true});
			} else {
				if (s) {
					new wm.BindSourceTreeNode(this, {object:w});
				}
			}
		}));
	}, widgetIsChild:function (inWidget) {
		var w = inWidget, o = this.object;
		while (w) {
			if (w == o) {
				return true;
			}
			w = w.parent;
		}
	}, expandBySource:function (inObjectId, inProp) {
		var o = studio.page.getValueById(inObjectId);
		if (this.widgetIsChild(o)) {
			this.setOpen(true);
			for (var i = 0, n, nodes = this.kids; (n = nodes[i]); i++) {
				if (n.expandBySource && n.expandBySource(inObjectId, inProp)) {
					return true;
				}
			}
		}
	}});
	dojo.declare("wm.ResourceItem", wm.Object, {itemName:"", iconSrc:"images/resourceManagerIcons/file16.png", treeNode:null, constructor:function (inProps) {
		dojo.mixin(this, inProps);
	}, getItemPath:function () {
		if (this.treeNode.parent == this.treeNode.tree.root) {
			return this.itemName;
		} else {
			return this.treeNode.parent.data.getItemPath() + "/" + this.itemName;
		}
	}, _end:null});
	dojo.declare("wm.ImageResourceItem", wm.ResourceItem, {iconSrc:"images/resourceManagerIcons/image16.png", init:function () {
		this.inherited(arguments);
	}});
	dojo.declare("wm.JSResourceItem", wm.ResourceItem, {iconSrc:"images/resourceManagerIcons/cssjs16.png", init:function () {
		this.inherited(arguments);
	}});
	dojo.declare("wm.CSSResourceItem", wm.ResourceItem, {iconSrc:"images/resourceManagerIcons/cssjs16.png", init:function () {
		this.inherited(arguments);
	}});
	dojo.declare("wm.MiscResourceItem", wm.ResourceItem, {init:function () {
		this.inherited(arguments);
	}});
	dojo.declare("wm.HTMLResourceItem", wm.ResourceItem, {iconSrc:"images/resourceManagerIcons/html16.png", init:function () {
		this.inherited(arguments);
	}});
	dojo.declare("wm.ZipResourceItem", wm.ResourceItem, {iconSrc:"images/resourceManagerIcons/file16.png", init:function () {
		this.inherited(arguments);
	}});
	dojo.declare("wm.JarResourceItem", wm.ResourceItem, {iconSrc:"images/resourceManagerIcons/file16.png", init:function () {
		this.inherited(arguments);
	}});
	dojo.declare("wm.FolderResourceItem", wm.ResourceItem, {iconSrc:"images/resourceManagerIcons/folder16.png", init:function () {
		this.inherited(arguments);
	}});
}
if (!dojo._hasResource["wm.studio.app.inspector.Inspector"]) {
	dojo._hasResource["wm.studio.app.inspector.Inspector"] = true;
	dojo.provide("wm.studio.app.inspector.Inspector");
	wm.addPropertyGroups = function (propGroups) {
		dojo.mixin(wm.propertyGroups || (wm.propertyGroups = {}), propGroups);
	};
	wm.addPropertyGroups({common:{displayName:bundleStudio.I_Common, order:10}, data:{displayName:bundleStudio.I_Data, order:13}, display:{displayName:bundleStudio.I_Display, order:15}, layout:{displayName:bundleStudio.I_Layout, order:20}, "advanced layout":{displayName:bundleStudio.I_Advanced_Layout, order:180}, style:{displayName:bundleStudio.I_Style, order:30}, scrolling:{displayName:bundleStudio.I_Scrolling, order:32}, dataobjects:{displayName:bundleStudio.I_Data_Objects, order:35}, format:{displayName:bundleStudio.I_Formatting, order:40}, Labeling:{displayName:bundleStudio.I_Labeling, order:45}, edit:{displayName:bundleStudio.I_Editing, order:50}, editor:{displayName:bundleStudio.I_Editor_Options, order:50}, editData:{displayName:bundleStudio.I_Editor_Data, order:55}, events:{displayName:bundleStudio.I_Events, order:100}, Events:{displayName:bundleStudio.I_General, order:100}, Properties:{displayName:bundleStudio.I_Other, order:100}, validation:{displayName:bundleStudio.I_Validation, order:150}, columns:{displayName:bundleStudio.I_Columns, order:999}, ungrouped:{displayName:bundleStudio.I_Other, order:1000}, operation:{displayName:bundleStudio.I_Operations, order:2000}, docs:{displayName:bundleStudio.I_Docs, order:3000}});
	dojo.declare("wm.InspectorBase", null, {flex:1, box:"v", _editors:null, init:function () {
		this.inherited(arguments);
		this.connect(this.domNode, "onmousemove", this, "propMove");
		this.connect(this.domNode, "onmouseleave", this, "propLeave");
		this.connect(this.domNode, "onmousedown", this, "propDown");
		this.connect(this.domNode, "onchange", this, "propChange");
		this.connect(this.domNode, "onclick", this, "propClick");
		this.connect(this.domNode, "_onblur", this, "propBlur", true);
		this.connect(this.domNode, "_onfocus", this, "propFocus", true);
		this.connect(this.domNode, "_onchange", this, "propChange", true);
		this.connect(this.domNode, "onkeypress", this, "propKey");
		studio.helpPopup = this.getHelpDialog();
	}, reinspect:function () {
		this.owner.reinspect();
	}, getHelpDialog:function () {
		if (!studio.helpPopup) {
			var props = {owner:this, pageName:"PopupHelp", scrimBackground:true, hideOnClick:false, positionLocation:" l"}, d = studio.helpPopup = new wm.PagePopup(props);
			d.setContainerOptions(true, 500, 275);
		}
		var b = studio.helpPopup;
		return b;
	}, finishProp:function () {
		var p = this.focusedProp;
		this.focusedProp = null;
		if (p && this.focusValue != p.value) {
			this._applyProp(p);
		}
	}, _setInspectedProp:function (inProp, inValue) {
		if (!this.inspected) {
			return;
		}
		var type = this.inspected.getPropertyType(inProp);
		switch ((type || 0).type) {
		  case "number":
			inValue = (inValue === "" && type.emptyOK) ? "" : Number(inValue);
			break;
		  case "boolean":
			inValue = Boolean(inValue);
			break;
		}
		this.inspected.setProp(inProp, inValue);
		wm.onidle(this, "reinspect");
	}, _getInspectedProp:function (inProp) {
		if (!this.inspected) {
			return;
		}
		var v = this.inspected.getProp(inProp);
		return dojo.isFunction(v) ? ["(", inProp, ")"].join("") : v;
	}, _applyProp:function (t) {
		if (t && t.name) {
			var e = this._editors && this._editors[t.name];
			if (e) {
				e.applyProp(t);
			} else {
				this._setInspectedProp(t.name, t.type == "checkbox" ? t.checked : t.value);
			}
		}
	}, applyProp:function (e) {
		this._applyProp(e.target);
	}, editProp:function (inTarget) {
		var t = inTarget, p = t && t.parentNode.previousSibling.firstChild;
		if (this.inspected && p && p.name && ("value" in p)) {
			this.inspected.editProp(p.name, p.value, this);
		}
	}, propFocus:function (e) {
		dojo.fixEvent(e);
		var t = e.target;
		if (t && t.tagName == "OPTION") {
			t = t.parentNode;
		}
		if (t && t.name) {
			this.focusedProp = t;
			this.focusValue = t.value;
		}
	}, propBlur:function (e) {
		dojo.fixEvent(e);
		var t = e.target;
		if (this.focusedProp == t) {
			this.finishProp();
		}
	}, propKey:function (e) {
		dojo.fixEvent(e);
		if (e.target == this.focusedProp && e.target.tagName != "TEXTAREA" && e.keyCode == dojo.keys.ENTER && !e.shiftKey) {
			this.finishProp();
			try {
				e.target.select();
			}
			catch (x) {
			}
		}
	}, propChange:function (e) {
		dojo.fixEvent(e);
		if (e.target == this.focusedProp) {
			this.finishProp();
		}
	}, propDown:function (e) {
		if (this.selectMode) {
			console.log("propDown", e);
			dojo.stopEvent(e);
			return true;
		}
	}, propClick:function (e) {
		if (this.selectMode) {
			this.endSelectMode(this.getPropNameByEvent(e));
			return true;
		}
	}, hilite:function (inRow, inTrueToHilite) {
		if (inRow) {
			var bs = inTrueToHilite ? "4px solid lightgreen" : "";
			var bn = inTrueToHilite ? "0px" : "";
			var c = inRow.cells;
			c[0].style.border = bs;
			c[0].style.borderRight = bn;
			c[1].style.border = bs;
			c[1].style.borderLeft = bn;
			if (c[2]) {
				c[1].style.borderRight = bn;
				c[2].style.border = bs;
				c[2].style.borderLeft = bn;
			}
		}
	}, getTargetRow:function (t) {
		while (t && (t.tagName != "TR" || t.getAttribute("propname") == null)) {
			t = t.parentNode;
		}
		return t;
	}, propMove:function (e) {
		if (this.selectMode) {
			var r = this.getTargetRow(e.target);
			if (r && r != this.overRow) {
				this.hilite(this.overRow, false);
				this.hilite(this.overRow = r, true);
			}
		}
	}, propLeave:function (e) {
		if (this.selectMode) {
			if (!this.getTargetRow(e.target)) {
				this.hilite(this.overRow, false);
			}
		}
	}, setSelectMode:function (inTrueForSelectMode) {
		if (this.selectMode && this.overRow && !inTrueForSelectMode) {
			this.hilite(this.overRow, false);
		}
		this.selectMode = inTrueForSelectMode;
	}, endSelectMode:function (inPropName) {
		studio.propertySelected(this.inspected.getRuntimeId() + "." + inPropName);
	}});
	dojo.declare("wm.Inspector", [wm.Box, wm.InspectorBase], {flex:1, box:"v", html:["<div style=\"overflow: auto; width: 100%; height: 100%;\" flex=\"1\" box=\"v\">", "<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\">", "</table>", "</div>"].join(""), inspected:null, props:null, init:function () {
		this.inherited(arguments);
		this.domNode.className = "wminspector";
		this.domNode.innerHTML = this.html;
		this.tableContainer = this.domNode.firstChild;
		this.table = this.tableContainer.firstChild;
	}, inspect:function (inComponent, inInspectorProps) {
		if (!this.active) {
			this.inspected = inComponent;
			return;
		}
		this.finishProp();
		this.nextFocusedPropName = null;
		this.inspected = inComponent;
		this.domNode.scrollTop = 0;
		this.preinspect(inInspectorProps);
		this._inspect();
	}, getProps:function (inInspectorProps) {
		var c = this.inspected, allProps = c ? c.listProperties() : {}, props = {};
		for (var i in allProps) {
			props[i] = dojo.mixin({name:i}, allProps[i]);
		}
		return props;
	}, preinspect:function (inInspectorProps) {
		this.props = this.getProps(inInspectorProps);
	}, _inspect:function () {
		this._editors = {};
		this.focusedProp = null;
		var c = this.inspected;
		if (c.isDestroyed) {
			return;
		}
		var headerCells = this.generateHeaderCells();
		if (!this.groups || this.groups.length == 0 || this.groups[0].name != "Data") {
			headerCells.push("<th class=\"wminspector-header wminspector-help\">?</th>");
		}
		this.tableContainer.innerHTML = ["<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" style=\"width: 100%;\">", "<tr>", headerCells.join(""), "</tr>", this.generateTableContent(), "</table>"].join("");
		this.table = this.tableContainer.firstChild;
		this.editors = this.formatTable();
		this.reflow();
	}, generateHeaderCells:function () {
		return ["<th class=\"wminspector-header\" style=\"width: 30%;\">" + bundleStudio.I_Property + "</th>", "<th class=\"wminspector-header\">" + bundleStudio.I_Value + "</th>"];
	}, generateTableContent:function () {
		var rows = [];
		wm.forEachProperty(this.props, dojo.hitch(this, function (p, n) {
			rows.push("<tr propName=\"", n, "\">", this.generateRowCells(n, p).join(""), "<td class=\"wminspector-help\">?</td>", "</tr>");
		}));
		return rows.join("");
	}, generateRowCells:function (inName, inProp) {
		return ["<td class=\"wminspector-caption\">", this.makeRowCaption(inName, inProp), "</td>", "<td class=\"wminspector-property\">", this.makePropEdit(inName), "</td>"];
	}, makeRowCaption:function (inName, inProp) {
		if (inProp.shortname === undefined) {
			return inName;
		} else {
			return inProp.shortname;
		}
	}, makePropEdit:function (inName) {
		var c = this.inspected;
		if (c.isDestroyed) {
			return;
		}
		var d = c.constructor.prototype[inName], v = this._getInspectedProp(inName);
		var e = c.makePropEdit(inName, v, d) || makeInputPropEdit(inName, v, d);
		if (!dojo.isString(e)) {
			e.inspector = this;
			this._editors[inName] = e;
			e = e.getHtml();
		}
		return e;
	}, formatTable:function () {
		var editors = [];
		for (var i = 1, rows = this.table.rows, tr; (tr = rows[i]); i++) {
			this.formatTableRow(tr, editors);
		}
		return editors;
	}, formatTableRow:function (inTr, ioEditors) {
		var p = inTr.getAttribute("propName");
		if (p) {
			var td = inTr.cells[inTr.cells.length - 2];
			var n = td && td.firstChild;
			var e = formatPropEdit(this.inspected, p, this._getInspectedProp(p), n, wm.isInstanceType(this, wm.BindInspector));
			if (e) {
				ioEditors.push(e);
			}
		}
	}, reinspect:function () {
		this.inherited(arguments);
		if (this.nextFocusedPropName) {
			this.doFocusProp(this.nextFocusedPropName);
			this.nextFocusedPropName = null;
		}
	}, propClick:function (e) {
		if (this.inherited(arguments)) {
			return true;
		}
		studio.studioKeyPriority = false;
		this.propFocus(e);
		var t = e.target || 0;
		if (dojo.hasClass(e.target, "wminspector-help")) {
			if (!dojo.hasClass(e.target, "wminspector-header")) {
				var propName = this.getPropNameByEvent(e);
				return this.beginHelp(propName, e.target, this.inspected.declaredClass);
			} else {
				return true;
			}
		} else {
			if (t.type == "checkbox") {
				this.applyProp(e);
				return true;
			} else {
				var t = this.getTargetByClass(t, "wminspector-prop-button");
				if (t) {
					this.editProp(t);
					return true;
				}
			}
		}
	}, beginHelp:function (inPropName, inNode, inType) {
		var bd = studio.helpPopup;
		bd.page.setHeader(inType, inPropName);
		bd.sourceNode = inNode;
		bd.positionNode = dojo.byId("studio_designer");
		bd.page.setContent("");
		bd.show();
		inType = inType.substring(inType.indexOf(".") + 1);
		if (inType.indexOf("gadget.") == 0) {
			inType = inType.substring(inType.indexOf(".") + 1);
		}
		if (inType.indexOf("dijit.") == 0) {
			inType = inType.substring(inType.indexOf(".") + 1);
		}
		inType = inType.replace(/\./g, "_");
		studio.studioService.requestAsync("getPropertyHelp", [inType + "_" + inPropName + "?synopsis"], function (response) {
			bd.page.setContent(response);
		});
		return true;
	}, getDefaultFocusProp:function () {
	}, focusDefault:function () {
		this.doFocusProp(this.getDefaultFocusProp());
	}, doFocusProp:function (inProp) {
		if (!inProp) {
			return;
		}
		var n = getPropNode(this.table, inProp, 1);
		wm.focusOnIdle(n);
		studio.studioKeyPriority = true;
	}, getPropNameByEvent:function (e) {
		var d = this.domNode, t = e && e.target.parentNode, pn;
		while (t && t != d) {
			pn = t.getAttribute && t.getAttribute("propname");
			if (pn) {
				return pn;
			}
			t = t.parentNode;
		}
	}, getTargetByClass:function (inTarget, inClass) {
		var t = inTarget;
		while (t && t != this.domNode) {
			if (dojo.hasClass(t, inClass)) {
				return t;
			}
			t = t.parentNode;
		}
	}, setSelectMode:function (inTrueForSelectMode) {
		this.inherited(arguments);
	}});
	dojo.declare("wm.GroupInspector", wm.Inspector, {autoScroll:true, colCount:2, preinspect:function (inInspectorProps) {
		this.inherited(arguments);
		this.groups = this.inspected ? this.initGroups(this.props) : [];
	}, generateTableContent:function () {
		var rows = [], c = this.inspected;
		dojo.forEach(this.groups, dojo.hitch(this, function (g) {
			rows.push(this.generateGroup(g));
		}));
		return rows.join("");
	}, generateGroup:function (inGroup) {
		var rows = [], props = inGroup.props;
		if (inGroup.displayName) {
			rows.push(this.generateGroupRow(inGroup));
		}
		for (var i = 0, p, n; (p = props[i]); i++) {
			if (p.hidden) {
				continue;
			}
			if (p.dependency && !wm.expression.getValue(p.dependency, this.inspected)) {
				continue;
			}
			n = p.name;
			rows.push("<tr propName=\"", n, "\"", inGroup.closed ? " style=\"display: none;\"" : "", ">", this.generateRowCells(n, p).join(""), (inGroup.name != "Data") ? "<td class=\"wminspector-help\">?</td>" : "", "</tr>");
		}
		return rows.join("");
	}, generateGroupRow:function (inGroup) {
		var closed = (wm.propertyGroups[inGroup.name] || 0).closed, img = ["<img src=\"images/group_", (closed ? "closed" : "open"), ".gif\">&nbsp;"].join(""), cs = " colSpan=" + this.colCount;
		return ["<tr class=\"wminspector-grouprow\" onclick=\"wm.bubble(event)\" groupRow=\"", inGroup.name, "\">", "<th", cs, " class=\"wminspector-group\">", img, inGroup.displayName, "</th>", "</tr>"].join("");
	}, formatTableRow:function (inTr, inEditors) {
		var tr = inTr, editors = inEditors;
		if (tr.getAttribute("groupRow")) {
			dojo.setSelectable(tr, false);
			return;
		}
		this.inherited(arguments);
	}, shouldShowProp:function (inName, inProp) {
		return !inProp.ignore;
	}, initGroups:function (inProps) {
		var groups = this.buildGroups(inProps);
		this.sortGroups(groups);
		dojo.forEach(groups, function (g) {
			dojo.mixin(g, wm.propertyGroups[g.name] || {displayName:g.name});
		});
		return groups;
	}, buildGroups:function (inProps) {
		var groups = [], groupsArray = [], defaultGroup = this.name;
		wm.forEachProperty(inProps, dojo.hitch(this, function (o, n) {
			if (!this.shouldShowProp(n, o)) {
				return;
			}
			var name = (o && o.group) || defaultGroup || "ungrouped", g = groups[name] || (groups[name] = []), order = o && o.order != undefined ? o.order : 1000, p = dojo.mixin({}, o, {name:n, order:order});
			g.push(p);
		}));
		for (var i in groups) {
			groupsArray.push({name:i, props:groups[i]});
		}
		return groupsArray;
	}, sortGroups:function (inGroups) {
		inGroups.sort(function (a, b) {
			return ((wm.propertyGroups[a.name] || 0).order || 0) - ((wm.propertyGroups[b.name] || 0).order || 0);
		});
		dojo.forEach(inGroups, function (g) {
			if (g.props.sort) {
				g.props.sort(function (a, b) {
					var o = a.order - b.order;
					return o == 0 ? wm.compareStrings(a.name, b.name) : o;
				});
			}
		});
		return inGroups;
	}, propClick:function (e) {
		if (!this.inherited(arguments)) {
			return this.toggleGroup(e.target);
		}
	}, getGroupRow:function (inTarget) {
		return this.getTargetByClass(inTarget, "wminspector-grouprow");
	}, toggleGroup:function (inTarget) {
		var r = this.getGroupRow(inTarget);
		if (!r) {
			return;
		}
		var img = r.cells[0].firstChild, isOpen = img.src.match("open"), gn = r.getAttribute("grouprow");
		(wm.propertyGroups[gn] || 0).closed = Boolean(isOpen);
		img.src = "images/group_" + (isOpen ? "closed.gif" : "open.gif");
		for (var rows = this.table.rows, i = dojo.indexOf(rows, r) + 1, row; (row = rows[i]); i++) {
			if (dojo.hasClass(row, "wminspector-grouprow")) {
				break;
			} else {
				row.style.display = isOpen ? "none" : "";
			}
		}
		return true;
	}, getDefaultFocusProp:function () {
		if (!this.inspected) {
			return;
		}
		for (var i = 0, g, groups = this.groups; (g = groups[i]); i++) {
			for (var j = 0, p; (p = g.props[j]); j++) {
				if ((this.inspected.schema[p.name] || 0).focus) {
					return p.name;
				}
			}
		}
		return "name";
	}});
	dojo.declare("wm.EventInspector", wm.Inspector, {getProps:function (inInspectorProps) {
		var props = this.inherited(arguments);
		for (var i in props) {
			if (!props[i].isEvent || props[i].ignore) {
				delete props[i];
			}
		}
		return props;
	}, hasEvents:function (inProps) {
		var list = inProps;
		for (var i in list) {
			if (list[i].isEvent) {
				return true;
			}
		}
	}, canInspect:function (inInspected, inProps) {
		return this.hasEvents(inProps);
	}});
	dojo.declare("wm.CustomMethodInspector", wm.Inspector, {getProps:function (inInspectorProps) {
		var props = this.inherited(arguments);
		for (var i in props) {
			if (!props[i].isCustomMethod || props[i].ignore) {
				delete props[i];
			}
		}
		return props;
	}, hasCustomMethod:function (inProps) {
		var list = inProps;
		for (var i in list) {
			if (list[i].isCustomMethod) {
				return true;
			}
		}
	}, canInspect:function (inInspected, inProps) {
		return this.hasCustomMethod(inProps);
	}});
	getPropNode = function (inTable, inProp, inCellIndex) {
		for (var i = 1, rows = inTable.rows, tr, n; inProp && (tr = rows[i]); i++) {
			if (tr.getAttribute("propName") == inProp) {
				return (tr.cells[inCellIndex]).firstChild;
			}
		}
	};
}
if (!dojo._hasResource["wm.studio.app.inspector.BindInspector"]) {
	dojo._hasResource["wm.studio.app.inspector.BindInspector"] = true;
	dojo.provide("wm.studio.app.inspector.BindInspector");
	dojo.declare("wm.BindInspector", wm.GroupInspector, {colCount:3, init:function () {
		this.inherited(arguments);
		studio.bindDialog = this.getBindDialog();
	}, getProps:function (inInspectorProps) {
		var props = this.inherited(arguments);
		for (var i in props) {
			if (props[i].isEvent || props[i].isCustomMethod) {
				delete props[i];
			}
		}
		return props;
	}, inspect:function () {
		this.inherited(arguments);
		studio.bindDialog.page.initBinding();
	}, getBindDialog:function () {
		if (!studio.bindDialog) {
			var props = {owner:this, pageName:"BindSourceDialog", border:"1px", positionLocation:"tl", width:"550", height:"350", modal:false, hideControls:true, title:"Binding..."}, d = studio.bindDialog = new wm.PageDialog(props);
		}
		var b = studio.bindDialog;
		if (b._hideConnect) {
			dojo.disconnect(b._hideConnect);
		}
		b._hideConnect = dojo.connect(b, "onHide", this, "endBind");
		return b;
	}, generateHeaderCells:function () {
		var r = this.inherited(arguments);
		r.push("<th class=\"wminspector-header wminspector-binding\"></th>");
		return r;
	}, generateRowCells:function (inName, inProp) {
		var n = inName, bindable = this.isBindable(inProp), wire = bindable && this.getPropWire(inProp), c = " wminspector-bindProp" + (bindable ? "" : "-disabled"), bc = wire ? " wminspector-boundProp" : "", b = "";
m=n;
switch (m) {
case 'add':m='追加';break;
case 'addColumn':m='列の追加';break;
case 'addEditors':m='エディタを追加';break;
case 'align':m='配置';break;
case 'allowNone':m='非選択を可';break;
case 'aspect':m='アスペクト';break;
case 'Auto Height':m='自動高さ';break;
case 'Auto Width':m='自動幅';break;
case 'autoColumns':m='自動列';break;
case 'autoComplete':m='入力補助';break;
case 'autoDataSet':m='自動データセット';break;
case 'autoScroll':m='自動スクロール';break;
case 'autoSize':m='自動サイズ調整';break;
case 'autoSizeWidth':m='幅を自動調整';break;
case 'autoUpdate':m='自動更新';break;
case 'bindSource':m='ﾊﾞｲﾝﾄﾞｿｰｽ';break;
case 'bindTarget':m='ﾊﾞｲﾝﾄﾞﾀｰｹﾞｯﾄ';break;
case 'border':m='ボーダー';break;
case 'borderColor':m='ボーダー色';break;
case 'byPage':m='ページ毎';break;
case 'caption':m='見出し';break;
case 'captionAlign':m='見出し配置';break;
case 'captionPosition':m='見出し位置';break;
case 'captionSize':m='見出し長さ';break;
case 'changeOnEnter':m='入力時に変更';break;
case 'changeOnKey':m='入力を表示';break;
case 'chartColor':m='グラフ色';break;
case 'chartType':m='グラフタイプ';break;
case 'checkedValue':m='チェック値';break;
case 'clearColumns':m='列の消去';break;
case 'clearData':m='データを消去';break;
case 'clearInput':m='入力を消去';break;
case 'clickVariable':m='クリック変数';break;
case 'colCount':m='列数';break;
case 'columnWidth':
case 'columnWidths': m='列幅';break;
case 'connectors':m='コネクタ';break;
case 'content':m='内容';break;
case 'currency':m='通貨';break;
case 'dataExpression':m='データ式';break;
case 'dataField':
case 'dataFields':m='データ項目';break;
case 'dataOutput':m='データ出力';break;
case 'dataSet':m='データセット';break;
case 'dataType':m='データ型';break;
case 'dataValue':m='データ値';break;
case 'dateValue':m='日付';break;
case 'defaultButton':m='デフォルトボタン';break;
case 'defaultIconUrl':m='ﾃﾞﾌｫﾙﾄｱｲｺﾝURL';break;
case 'defaultLayer':m='デフォルトレイヤ';break;
case 'deferLoad':m='遅延読込み';break;
case 'delay':m='ディレイ';break;
case 'deploy':m='デプロイ';break;
case 'description':m='説明';break;
case 'designMaxResults':m='設計時最大数';break;
case 'disabled':m='無効';break;
case 'discreteValues':m='離散値';break;
case 'display':m='表示';break;
case 'displayDate':m='表示日付';break;
case 'displayErrors':m='エラーを表示';break;
case 'displayExpression':m='表示式';break;
case 'displayField':m='表示フィールド';break;
case 'displayName':m='表示名';break;
case 'displayValue':m='値を表示';break;
case 'documentation':m='ドキュメント';break;
case 'editingMode':m='編集モード';break;
case 'editorBorder':m='エディタボーダー';break;
case 'editorHeight':m='エディタ高さ';break;
case 'editorWidth':m='エディタ幅';break;
case 'editPanelStyle':m='ﾊﾟﾈﾙｽﾀｲﾙを編集';break;
case 'editProperties':m='プロパティを編集';break;
case 'emptyValue':m='空の値';break;
case 'enableAnimation':m='アニメを有効';break;
case 'expand':m='展開';break;
case 'field':m='フィールド';break;
case 'filter':m='フィルタ';break;
case 'firstRecord':m='先頭レコード';break;
case 'firstRow':m='先頭行';break;
case 'fitToContentHeight':m='内容の高さに調整';break;
case 'fitToContentWidth':m='内容の幅に調整';break;
case 'format':m='書式';break;
case 'formField':m='ﾌｫｰﾑﾌｨｰﾙﾄﾞ';break;
case 'freeze':m='固定';break;
case 'gap':m='間隙';break;
case 'generateDocumentation':m='ﾄﾞｷｭﾒﾝﾄを生成';break;
case 'group':m='グループ';break;
case 'headerHeight':m='ヘッダの高さ';break;
case 'groupValue':m='グループ';break;
case 'hasDownArrow':m='下矢印';break;
case 'headerVisible':m='ヘッダを表示';break;
case 'height':m='高さ';break;
case 'hint':m='ヒント';break;
case 'horizontalAlign':m='横揃え';break;
case 'html':m='HTML';break;
case 'imageIndex':m='イメージインデックス';break;
case 'imageList':m='イメージリスト';break;
case 'iconErrorUrl':m='ｴﾗｰｱｲｺﾝURL';break;
case 'iconHeight':m='アイコンの高さ';break;
case 'iconLoadingUrl':m='読込みｱｲｺﾝURL';break;
case 'iconMargin':m='アイコン余白';break;
case 'iconSuccessUrl':m='成功ｱｲｺﾝURL';break;
case 'iconUrl':m='アイコンURL';break;
case 'iconWidth':m='アイコン幅';break;
case 'ignoreCase':m='大小文字を区別しない';break;
case 'imageLabelField':m='画像ラベル';break;
case 'imageUrlField':m='画像URL';break;
case 'includeGrid':m='グリッドを表示';break;
case 'includeX':m='X軸を表示';break;
case 'includeY':m='Y軸を表示';break;
case 'indeterminate':m='不確定';break;
case 'index':m='インデックス';break;
case 'innerLayoutKind':m='内部レイアウト';break;
case 'invalidMessage':m='不正メッセージ';break;
case 'isEvent':m='イベントである';break;
case 'itemMaxHeight':m='項目の最大高';break;
case 'itemMaxWidth':m='項目の最大幅';break;
case 'itemHeight':m='項目の高さ';break;
case 'itemWidth':m='項目の幅';break;
case 'json':m='JSON';break;
case 'lastRecord':m='最後のレコード';break;
case 'layer':m='レイヤー';break;
case 'layersType':m='レイヤタイプ';break;
case 'layoutKind':m='レイアウト';break;
case 'legendHeight':m='凡例の高さ';break;
case 'link':m='リンク';break;
case 'liveEditing':m='ライブ編集';break;
case 'liveSource':m='ライブソース';break;
case 'loadParentFirst':m='親から読込み';break;
case 'lock':m='ロック';break;
case 'lookupDisplay':m='ルックアップ';break;
case 'main':m='メイン';break;
case 'margin':m='余白';break;
case 'matchMode':m='一致条件';break;
case 'maxChars':m='最大文字数';break;
case 'maxHeight':m='最大高さ';break;
case 'maximum':m='最大';break;
case 'maxResults':m='最大結果数';break;
case 'menu':m='メニュー';break;
case 'minHeight':m='最初高さ';break;
case 'minimum':m='最小';break;
case 'minWidth':m='最初幅';break;
case 'motion':m='動作';break;
case 'moveNext':m='次へ';break;
case 'movePrevious':m='前へ';break;
case 'multiActive':m='ﾏﾙﾁｱｸﾃｨﾌﾞ';break;
case 'name':m='名前';break;
case 'namespace':m='名前空間';break;
case 'nextRecord':m='次のレコード';break;
case 'noInspector':m='ｲﾝｽﾍﾟｸﾀ無し';break;
case 'operation':m='処理';break;
case 'options':m='引数';break;
case 'orderBy':m='並び替え';break;
case 'owner':m='オーナー';break;
case 'padding':m='パディング';break;
case 'pageName':m='ページ名';break;
case 'pageSize':m='ページサイズ';break;
case 'password':m='パスワード';break;
case 'places':m='小数点';break;
case 'previousRecord':m='前のレコード';break;
case 'progress':m='進捗';break;
case 'projectSubVersion':m='ｻﾌﾞﾊﾞｰｼﾞｮﾝ';break;
case 'projectVersion':m='ﾌﾟﾛｼﾞｪｸﾄﾊﾞｰｼﾞｮﾝ';break;
case 'promptChromeFrame':m='ﾌﾟﾛﾝﾄｸﾛﾑﾌﾚｰﾑ';break;
case 'property':m='プロパティ';break;
case 'promptMessage':m='メッセージ';break;
case 'publishName':m='公開名';break;
case 'queue':m='キュー';break;
case 'radioGroup':m='ラジオグループ';break;
case 'rangeMessage':m='範囲メッセージ';break;
case 'readonly':m='読取り専用';break;
case 'regExp':m='正規表現';break;
case 'removeColumn':m='列を削除';break;
case 'removeEditors':m='エディタを削除';break;
case 'required':m='必須';break;
case 'resizeToFit':m='自動リサイズ';break;
case 'resource':m='リソース';break;
case 'restrictValues':m='値を制限';break;
case 'rewindDelay':m='巻き戻しﾃﾞｨﾚｨ';break;
case 'saveDisplayValue':m='表示値を保存';break;
case 'scrollX':m='横スクロール';break;
case 'scrollY':m='縦スクロール';break;
case 'selectionMode':m='選択モード';break;
case 'service':m='サービス';break;
case 'showing':m='表示';break;
case 'showButtons':m='ボタンを表示';break;
case 'showLink':m='リンクを表示';break;
case 'showMessages':m='ﾒｯｾｰｼﾞを表示';break;
case 'showOnlyParentLayer':m='親ﾚｲﾔｰのみ表示';break;
case 'singleClickEdit':m='１クリック編集';break;
case 'singleLine':m='一行';break;
case 'source':m='ソース';break;
case 'sourceData':m='ソースデータ';break;
case 'startChecked':m='チェック開始';break;
case 'startNow':m='開始';break;
case 'startUpdate':m='起動時更新';break;
case 'stopNow':m='停止';break;
case 'studioVersion':m='ｽﾀｼﾞｵﾊﾞｰｼﾞｮﾝ';break;
case 'theme':m='テーマ';break;
case 'themeStyleType':m='ﾃｰﾏｽﾀｲﾙ型';break;
case 'title':m='題名';break;
case 'timePattern':m='時刻パターン';break;
case 'toggleSelect':m='選択の切替え';break;
case 'toastPosition':m='ﾄｰｽﾄ位置';break;
case 'toolbarAlign':m='ﾂｰﾙﾊﾞｰ配置';break;
case 'toolbarColor':m='ﾂｰﾙﾊﾞｰ色';break;
case 'toolbarFont':m='ﾂｰﾙﾊﾞｰﾌｫﾝﾄ';break;
case 'toolbarLink':m='ﾂｰﾙﾊﾞｰﾘﾝｸ';break;
case 'toolbarList':m='ﾂｰﾙﾊﾞｰﾘｽﾄ';break;
case 'toolbarStyle':m='ﾂｰﾙﾊﾞｰｽﾀｲﾙ';break;
case 'toolbarStyleAll':m='ﾂｰﾙﾊﾞｰｽﾀｲﾙ全';break;
case 'toolbarUndo':m='ﾂｰﾙﾊﾞｰ解除';break;
case 'tooltipDisplayTime':m='ﾂｰﾙﾁｯﾌﾟ時間';break;
case 'totalItems':m='項目数';break;
case 'twitterId':m='TwitterID';break;
case 'type':m='型';break;
case 'undeploy':m='アンデプロイ';break;
case 'updateNow':m='更新';break;
case 'url':m='URL';break;
case 'validateBeforeSave':m='保存前に検証';break;
case 'vertical':m='縦に表示';break;
case 'verticalAlign':m='縦揃え';break;
case 'width':m='幅';break;
case 'xAxis':m='X軸';break;
case 'yAxis':m='Y軸';break;
case 'zip':m='郵便番号';break;
default:
//window.alert(m);
}
		return ["<td class=\"wminspector-caption\" style=\"font-size:x-small\">", this.makeRowCaption(m, inProp), "</td>", "<td class=\"wminspector-property\">", this.makePropEdit(n, inProp, wire), "</td>", "<td class=\"wminspector-binding", c, bc, "\">", b, "</td>"];
	}, shouldShowProp:function (inName, inProp) {
		return this.inherited(arguments) || this.isBindable(inProp);
	}, canMakeDefaultPropEdit:function (inProp) {
		return !inProp.ignore;
	}, makePropEdit:function (inName, inProp, inWire) {
		if (inWire && inWire instanceof wm.Wire) {
			return this.makeBoundPropEdit(inName, inWire.source || inWire.expression);
		}
		if (this.canMakeDefaultPropEdit(inProp)) {
			return this.inherited(arguments, [inName, inProp]);
		}
		return this.makeBindPropEdit(inName);
	}, makeBindPropEdit:function (inName) {
		var m = "(data binding)";
		return makeInputPropEdit(inName, m, m, true);
	}, makeBoundPropEdit:function (inName, inSource) {
		return makeBoundEdit(inName, inSource);
	}, propClick:function (e) {
		var handled = this.inherited(arguments), propName = this.getPropNameByEvent(e);
		if (this.selectMode) {
			return this.endBind(propName, e.target);
		} else {
			if (!handled && dojo.hasClass(e.target, "wminspector-bindProp")) {
				return this.beginBind(propName, e.target);
			} else {
				if (dojo.hasClass(e.target, "bound-prop-button")) {
					this.unbindProp(propName);
				}
			}
		}
	}, unbindProp:function (inPropName) {
		var b = this.getBinding(), tp = this.getTargetProperty(inPropName), w = wm.data.getPropWire(b.owner, tp);
		if (tp && w) {
			var wireOwner = w.owner;
			wireOwner.removeWire(w.getWireId());
			this._setInspectedProp(tp, "");
			this._inspect();
		}
	}, isBindable:function (inProp) {
		return inProp && (inProp.bindable || inProp.bindTarget);
	}, getBinding:function () {
		var i = this.inspected;
		return i && i.components.binding;
	}, getTargetProperty:function (inPropName) {
		return inPropName;
	}, getPropWire:function (inProp) {
		var b = this.getBinding(), tp = this.getTargetProperty(inProp.name);
		return b && b.owner && wm.data.getPropWire(b.owner, tp);
	}, getBindDialogProps:function (inPropName) {
		var o = this.inspected, tp = this.getTargetProperty(inPropName), prop = this.props[tp];
		if (this.isBindable(prop)) {
			return dojo.mixin({object:o, targetProperty:tp}, prop || {});
		}
	}, beginBind:function (inPropName, inNode) {
		var bd = studio.bindDialog, p = this.getBindDialogProps(inPropName), coords = dojo.coords(inNode);
		bd.positionLocation = (coords.y > bd.contentHeight) ? "tl" : "bl";
		if (p) {
			bd.page.update(p);
			bd.positionNode = inNode.parentNode;
			bd.show();
			return true;
		}
	}, endBind:function (inPropName, inNode) {
		if (this.active) {
			this._inspect();
		}
	}});
	dojo.declare("wm.DataInspector", wm.BindInspector, {constructor:function () {
		this.initNodeChildren = dojo.hitch(this, this.initNodeChildren);
	}, preinspect:function (inInspectorProps) {
		var ip = inInspectorProps, bindToComponent = ip && ip.bindToComponent;
		this.bindingOwner = bindToComponent ? this.inspected : ip && studio.page.getValueById(ip.inspected);
		this.bindPrefix = ip && ip.bindPrefix;
		this.dataProp = ip && ip.dataProp ? ip.dataProp : "";
		this.inherited(arguments);
	}, getProps:function (inInspectorProps) {
		var c = this.inspected, dp = this.dataProp;
		if (!(c instanceof wm.Variable)) {
			return {};
		}
		var props = dojo.mixin({}, this.getSchema(c, c.type, dp));
		for (var i in props) {
			props[i].name = i;
		}
		return props;
	}, getSchema:function (inInspected, inType, inDataProp) {
		var s = wm.typeManager.isType(inType) ? wm.typeManager.getTypeSchema(inType) : (inInspected || 0)._dataSchema;
		if (inDataProp && s) {
			var pi = wm.typeManager.getPropertyInfoFromSchema(s, inDataProp), t = (pi || 0).type, s = wm.typeManager.getTypeSchema(t);
		}
		return s;
	}, getRootType:function (inPropInfo) {
		var i = this.getInspected(inPropInfo);
		return (i || 0).type;
	}, getInspected:function (inPropInfo) {
		var pi = inPropInfo, n = pi.component ? [pi.inspected, pi.component].join(".") : pi.inspected;
		return studio.page.getValueById(n);
	}, getBinding:function () {
		var i = this.bindingOwner;
		return i && i.components.binding;
	}, getTargetProperty:function (inPropName) {
		var dp = this.dataProp, bp = this.bindPrefix, p = inPropName;
		if (dp) {
			p = [dp, p].join(".");
		}
		if (bp) {
			p = [bp, p].join(".");
		}
		return p;
	}, getBindDialogProps:function (inPropName) {
		var o = this.bindingOwner || this.inspected, tp = this.getTargetProperty(inPropName);
		return {object:o, targetProperty:tp};
	}, isBindable:function () {
		return true;
	}, addTreeNode:function (inParent, inInspected, inNodeProps, inInspectorProps, inNodeList) {
		this.nodeList = inNodeList;
		var np = inNodeProps;
		np.type = this.getRootType(np);
		np.dataProp = "";
		np.bindPrefix = np.bindToComponent ? "" : np.component;
		np.content = this.getNodeContent(np.content, np.type);
		return this._addTreeNode(inParent, np);
	}, _addTreeNode:function (inParent, inProps) {
		inProps.nodeInfos = this.listNodeChildren(inProps);
		inProps._hasChildren = Boolean(inProps.nodeInfos.length);
		inProps.initNodeChildren = this.initNodeChildren;
		inProps.closed = true;
		return new wm.TreeNode(inParent, inProps);
	}, getNodeContent:function (inName, inTypeName) {
		var tn = (inTypeName || "").split(".").pop();
		tn = tn ? [" (", tn, ")"].join("") : "";
		return inName + tn;
	}, getNodeProps:function (inProps, inNode, inName) {
		var p = inProps;
		p.component = inNode.component;
		p.inspected = inNode.inspected;
		p._nodeName = [inNode._nodeName, inName].join(".");
		p.content = this.getNodeContent(inName, inProps.type);
		p.bindToComponent = inNode.bindToComponent;
		p.bindPrefix = inNode.bindPrefix;
		p.inspector = inNode.inspector;
		p.image = inNode.image;
		p.dataProp = inNode.dataProp ? [inNode.dataProp, inName].join(".") : inName;
		return p;
	}, getSortedSchema:function (inProps) {
		var ins = this.getInspected(inProps);
		var s = dojo.mixin({}, this.getSchema(ins, inProps.type, ""));
		var sa = [];
		for (var i in s) {
			s[i].name = i;
			sa.push(s[i]);
		}
		sa.sort(function (a, b) {
			return wm.compareStrings(a.name, b.name);
		});
		return sa;
	}, listNodeChildren:function (inProps) {
		var result = [];
		var ss = this.getSortedSchema(inProps);
		for (var i = 0, nodeProps, c, propInfo; (propInfo = ss[i]); i++) {
			if (propInfo.isList) {
				continue;
			}
			if (wm.typeManager.isStructuredType(propInfo.type)) {
				c = wm.typeManager.hasStructuredType(propInfo.type, function (ti) {
					return ti.isList == false;
				});
				nodeProps = this.getNodeProps({type:propInfo.type, _hasChildren:c}, inProps, propInfo.name);
				result.push(nodeProps);
			}
		}
		return result;
	}, initNodeChildren:function (inNode) {
		var infos = inNode.nodeInfos;
		for (var i = 0, info, n; (info = infos[i]); i++) {
			n = this._addTreeNode(inNode, info);
			this.nodeList[n._nodeName] = n;
		}
	}, canMakeDefaultPropEdit:function (inProp) {
		return false;
	}, makeRowCaption:function (inName, inProp) {
		inName = inName + (wm.typeManager.isStructuredType(inProp.type) ? "*" : "");
		return this.inherited(arguments, [inName, inProp]);
	}});
	dojo.declare("wm.NavigationInspector", wm.DataInspector, {makePropEdit:function (inName, inProp, inWire) {
		var ins = this.inspected.getValue(inName);
		switch (inName) {
		  case "pageName":
			return (new wm.propEdit.PagesSelect({component:this, name:inName, value:ins})).getHtml();
		  case "cssClasses":
			return (new wm.propEdit.Select({component:this, value:ins || "Info", name:inName, defaultValue:"Info", options:["Success", "Error", "Warning", "Info", "Misc"]})).getHtml();
		  case "duration":
			return (new wm.propEdit.Select({component:this, value:ins || "5000", name:inName, defaultValue:"5000", options:["1000", "2000", "3000", "4000", "5000", "6000", "8000", "10000", "15000"]})).getHtml();
		  case "dialogPosition":
			return (new wm.propEdit.Select({component:this, value:ins || "Info", name:inName, defaultValue:"Info", options:["", "top left", "top center", "top right", "center left", "center center", "center right", "bottom left", "bottom center", "bottom right"]})).getHtml();
		  case "pageContainer":
			return (new wm.propEdit.WidgetsSelect({widgetType:wm.PageContainer, component:this, name:inName, value:ins && ins.name})).getHtml();
		  case "layer":
			return (new wm.propEdit.WidgetsSelect({widgetType:wm.Layer, component:this, name:inName, value:ins && ins.name})).getHtml();
		  case "layers":
			return (new wm.propEdit.WidgetsSelect({widgetType:wm.Layers, component:this, name:inName, value:ins && ins.name})).getHtml();
		}
		if (inWire && inWire instanceof wm.Wire) {
			return this.makeBoundPropEdit(inName, inWire.source || inWire.expression);
		}
		if (this.canMakeDefaultPropEdit(inProp)) {
			return this.inherited(arguments, [inName, inProp]);
		}
		return this.makeBindPropEdit(inName);
	}, _applyProp:function (t) {
		if (t && t.name) {
			switch (t.name) {
			  case "pageName":
			  case "duration":
			  case "cssClasses":
			  case "dialogPosition":
				this.inspected.components.binding.addWire("", t.name, "", "\"" + t.value + "\"");
				return;
			  case "pageContainer":
			  case "layer":
			  case "layers":
				this.inspected.components.binding.addWire("", t.name, t.value, "");
				return;
			}
			var e = this._editors && this._editors[t.name];
			if (e) {
				e.applyProp(t);
			} else {
				this._setInspectedProp(t.name, t.type == "checkbox" ? t.checked : t.value);
			}
		}
	}});
}
if (!dojo._hasResource["wm.studio.app.inspector.StyleInspector"]) {
	dojo._hasResource["wm.studio.app.inspector.StyleInspector"] = true;
	dojo.provide("wm.studio.app.inspector.StyleInspector");
	dojo.declare("wm.StyleInspector", [wm.Layers, wm.InspectorBase], {layersType:"Tabs", flex:1, box:"v", _source:{classes:["wm.Layer", {flex:1, title:bundleStudio.I_Classes, box:"v"}, {}, {classTree:["wm.Tree", {flex:1}, {}, {}], bevel1:["wm.Bevel", {}, {}, {}], classEdit:["wm.Editor", {caption:bundleStudio.I_Custom, captionSize:40, captionUnits:"px", height:"22px"}, {}, {editor:["wm._TextEditor", {changeOnEnter:true}, {}]}]}], custom:["wm.Layer", {flex:1, title:bundleStudio.I_Custom_Styles, box:"v"}, {}, {textArea:["wm.TextArea", {width:"100%", height:"100%", border:0}, {}, {}], panel1:["wm.Panel", {_classes:{domNode:["wm-darksnazzy"]}, layoutKind:"left-to-right", height:"34", boxPosition:"bottomRight", border:0, padding:2}, {}, {applyStylesButton:["wm.Button", {caption:bundleStudio.I_Apply, border:1, width:"60"}, {}]}]}]}, init:function () {
		dojo.addClass(this.domNode, "wmstyleinspector");
		this.inherited(arguments);
		this.createComponents(this._source);
		this.initClasses();
		this.initStyles();
	}, initClasses:function () {
		this.classTree = this.$.client.widgets.classes.widgets.classTree;
		this.classEdit = this.$.client.widgets.classes.widgets.classEdit;
		this.classTree.clear();
		this.connect(this.classEdit.domNode, "onmousedown", this, "textMousedown");
		this.connect(this.classEdit, "onchange", this, "classEditChange");
		this.connect(this.classTree, "oncheckboxclick", this, "classCheckboxClick");
		var n = defaultCssClasses;
		for (var i in n) {
			if (!(i in Array.prototype)) {
				var node = new wm.TreeNode(this.classTree.root, {content:i, name:i, isCategory:true});
				for (var j = 0, g = n[i], c; (c = g[j]); j++) {
					new wm.TreeCheckNode(node, {content:c, closed:true, name:c});
				}
			}
		}
	}, initStyles:function () {
		this.text = this.$.client.widgets.custom.widgets.textArea;
		this.text.domNode.name = "styles";
		this.connect(this.text.domNode, "onmousedown", this, "textMousedown");
		this.connect(this.text.domNode, "onfocus", wm.bubble);
		this.connect(this.text.domNode, "onblur", wm.bubble);
	}, _setInspectedProp:function (inProp, inValue) {
		if (inProp == "styles") {
			this.inspected.setNodeStyles(inValue, this.nodeClass);
		} else {
			this.inherited(arguments);
		}
	}, inspect:function (inInspected, inProps) {
		var ins = this.inspected = inInspected, def = "domNode";
		var isWidget = ins instanceof wm.Widget;
		this.classTree.setShowing(isWidget);
		if (!isWidget) {
			return;
		}
		this.nodeName = (inProps || 0).nodeName || def;
		this.nodeClass = (inProps || 0).nodeClass || "";
		var c = (ins._getUserNodeClasses) ? ins._getUserNodeClasses(this.nodeName) : ins._classes[this.nodeName] || [];
		if (!dojo.isArray(c)) {
			console.debug("inspector: ", ins, " has non-array _classes");
			return;
		}
		this.extraClasses = [].concat(c);
		this.classTree.forEachNode(dojo.hitch(this, function (inNode) {
			if (inNode.setChecked) {
				var nc = this.classFromNode(inNode), check = (dojo.indexOf(c, nc) >= 0);
				inNode.setChecked(check);
				if (check) {
					this.extraClasses.splice(dojo.indexOf(this.extraClasses, nc), 1);
				}
			}
		}));
		this.classEdit.beginEditUpdate();
		this.classEdit.setDataValue(this.extraClasses.join(" "));
		this.classEdit.endEditUpdate();
		var s = ins.getNodeStyles(this.nodeClass);
		this.text.setInputValue(s);
		this.focusedProp = this.text.domNode;
	}, classFromNode:function (inNode) {
		return ["wm", inNode.parent.name, inNode.name].join("_");
	}, classCheckboxClick:function (inNode) {
		var i = this.inspected;
		i[inNode.getChecked() ? "addUserClass" : "removeUserClass"](this.classFromNode(inNode), this.nodeName);
		i.reflowParent();
	}, classEditChange:function () {
		var i = this.inspected, v = this.classEdit.getValue("dataValue") || "", classes = v.split(" ");
		dojo.forEach(this.extraClasses, dojo.hitch(this, function (c) {
			i.removeUserClass(dojo.trim(c), this.nodeName);
		}));
		dojo.forEach(classes, dojo.hitch(this, function (c) {
			var klass = dojo.trim(c);
			if (klass) {
				i.addUserClass(klass, this.nodeName);
			}
		}));
		this.extraClasses = classes;
		i.reflowParent();
	}, textMousedown:function () {
		studio.studioKeyPriority = false;
	}});
}
if (!dojo._hasResource["wm.studio.app.inspector.SecurityInspector"]) {
	dojo._hasResource["wm.studio.app.inspector.SecurityInspector"] = true;
	dojo.provide("wm.studio.app.inspector.SecurityInspector");
	dojo.declare("wm.SecurityInspector", [wm.Box, wm.InspectorBase], {scrollY:true, flex:1, box:"v", _source:{roleLabel:["wm.Label", {height:"20px", caption:"Visible to:"}, {}, {}], roleTree:["wm.Tree", {scrollY:false}, {}, {}]}, init:function () {
		dojo.addClass(this.domNode, "wmstyleinspector");
		this.createComponents(this._source);
		this.inherited(arguments);
		this.subscribe("wm-project-changed", this, "studioProjectChanged");
		this.roleTree = this.widgets.roleTree;
		this.initComponentStyle();
		this.connect(this.roleTree, "oncheckboxclick", this, "roleCheckboxClick");
	}, initComponentStyle:function () {
		var roleLabel = this.widgets.roleLabel;
		roleLabel.domNode.style.position = "";
		roleLabel.domNode.style.width = "";
		this.roleTree.domNode.style.position = "";
		this.roleTree.domNode.style.width = "";
		this.roleTree.domNode.style.height = "";
	}, initRoles:function () {
		this.roleTree.clear();
		var n = wm.roles || [];
		this.everyoneNode = new wm.TreeCheckNode(this.roleTree.root, {content:"Everyone", closed:true, name:"Everyone"});
		for (var i = 0, c; (c = n[i]); i++) {
			new wm.TreeCheckNode(this.roleTree.root, {content:c, closed:true, name:c});
		}
	}, studioProjectChanged:function () {
		this.getRoles();
	}, getRoles:function () {
		studio.securityConfigService.requestSync("getRoles", [], dojo.hitch(this, "getRolesResult"));
	}, getRolesResult:function (inData) {
		wm.roles = inData || [];
	}, inspect:function (inInspected, inProps) {
		this.initRoles();
		var ins = this.inspected = inInspected, def = "domNode";
		var isWidget = ins instanceof wm.Widget;
		this.roleTree.setShowing(isWidget);
		if (!isWidget) {
			return;
		}
		this.nodeName = (inProps || 0).nodeName || def;
		var c = ins.roles || [];
		if (!dojo.isArray(c)) {
			console.debug("inspector: ", ins, " has non-array roles");
			return;
		}
		this.everyoneNode.setChecked(!c.length);
		if (c.length) {
			this.roleTree.forEachNode(dojo.hitch(this, function (inNode) {
				if (inNode.setChecked) {
					inNode.setChecked(dojo.indexOf(c, inNode.name) >= 0);
				}
			}));
		}
	}, roleCheckboxClick:function (inNode) {
		var i = this.inspected;
		if (inNode == this.everyoneNode) {
			if (inNode.getChecked()) {
				i.removeAllRoles();
				this.roleTree.forEachNode(dojo.hitch(this, function (inNode) {
					if (inNode.setChecked && inNode != this.everyoneNode) {
						inNode.setChecked(false);
					}
				}));
			} else {
				inNode.setChecked(true);
			}
		} else {
			i[inNode.getChecked() ? "addRole" : "removeRole"](inNode.name);
			this.everyoneNode.setChecked(!i.roles);
		}
	}});
}
if (!dojo._hasResource["wm.studio.app.inspector.ComponentInspector"]) {
	dojo._hasResource["wm.studio.app.inspector.ComponentInspector"] = true;
	dojo.provide("wm.studio.app.inspector.ComponentInspector");
	dojo.declare("wm.ComponentInspector", wm.Layers, {inspectors:{Properties:wm.BindInspector, "Events":wm.EventInspector, "CustomMethods":wm.CustomMethodInspector, Styles:wm.StyleInspector, Security:wm.SecurityInspector, Data:wm.DataInspector, Navigation:wm.NavigationInspector}, init:function () {
		this.inherited(arguments);
		this._inspectors = {};
		for (var i in this.inspectors) {
			var ctor = this.inspectors[i];
			this._inspectors[i] = new ctor({border:0, name:i, parent:this.addLayer(i), owner:this});
		}
	}, inspect:function (inComponent, inInspectorProps) {
		var c = this.inspected = inComponent, ip = this.inspectorProps = inInspectorProps;
		n = ip && ip.inspector, inspector = this._inspectors[n];
		if (inspector) {
			inspector.inspect(c, inInspectorProps);
		}
	}, reinspect:function () {
		if (this.inspected && this.inspectorProps) {
			this.inspect(this.inspected, this.inspectorProps);
		}
	}, focusDefault:function () {
		var inspector = this._inspectors[this.getLayerCaption()];
		wm.fire(inspector, "focusDefault");
	}, setSelectMode:function (inMode) {
		for (var i in this.inspectors) {
			this._inspectors[i].setSelectMode(inMode);
		}
	}, writeChildren:function () {
	}});
	dojo.declare("wm.ComponentInspectorPanel", wm.Panel, {init:function () {
		this.inherited(arguments);
		var t = ["{", "inspectorTree: [\"wm.Tree\", {height: \"120px\", border: 0}, {}, {}],", "splitter3: [\"wm.Splitter\", {layout: \"top\", border: 0}, {}, {}],", "inspectorLayers: [\"wm.ComponentInspector\", {border: 0, flex: 1, box: \"v\"}, {}, {}]", "}"];
		this.readComponents(t.join(""));
		this.tree = this.owner.inspectorTree;
		this.inspector = this.owner.inspectorLayers;
		this.connect(this.tree, "onselect", this, "treeSelect");
	}, clearTree:function () {
		this.tree.clear();
		this.treeNodes = {};
	}, canInspect:function (inInspector, inNodeProps) {
		var i = inInspector, cs = inNodeProps.canInspect, ics = "canInspect", r;
		if (cs && this[cs]) {
			r = this[cs](this.inspected, this.props);
		} else {
			if (i && i[ics]) {
				r = i[ics](this.inspected, this.props);
			} else {
				r = true;
			}
		}
		if (inInspector) {
			inInspector.active = r;
		}
		return r;
	}, _addTreeNode:function (inInspector, inParent, inProps) {
		var i = inInspector, a = inProps.addTreeNode, ia = (i || 0).addTreeNode;
		if (a && this[a]) {
			return this[a](inParent, this.inspected, inProps, this.props);
		} else {
			if (ia) {
				return ia.apply(i, [inParent, this.inspected, inProps, this.props, this.treeNodes]);
			} else {
				return new wm.TreeNode(inParent, inProps);
			}
		}
	}, addTreeNode:function (inNodeName, inProps, inParent) {
		inParent = inParent || this.tree.root;
		inProps = inProps || {};
		inProps.inspected = this.inspected && this.inspected.getId();
		inProps._nodeName = inNodeName;
		inProps.content = inProps.content || inNodeName;
		inProps.inspector = inProps.inspector || inParent.inspector;
		inProps.image = inProps.image || inParent.image;
		var ni = this.getInspector(inProps.inspector);
		if (!this.canInspect(ni, inProps)) {
			return;
		}
		var n = this._addTreeNode(ni, inParent, inProps);
		if (n) {
			this.treeNodes[n._nodeName || inNodeName] = n;
		}
		return n;
	}, addTreeSubNode:function (inName, inProps, inParent) {
		var np = {content:inName};
		dojo.mixin(np, inProps || {});
		this.addTreeNode(inParent._nodeName + "." + inName, np, inParent);
	}, initTree:function (inComponent) {
		this.clearTree();
		this.props = inComponent && inComponent.listProperties();
		this.addTreeNode("Properties", {content:bundleStudio.I_Properties, image:"images/properties_16.png", inspector:"Properties"});
		this.addTreeNode("Events", {content:bundleStudio.I_Events, image:"images/star_16.png", inspector:"Events"});
		this.addTreeNode("CustomMethods", {content:bundleStudio.I_CustomMethods, image:"images/star_16.png", inspector:"CustomMethods"});
		var props = this.props, p;
		for (var i in props) {
			p = props[i];
			if (p.category && !(p.category in this.treeNodes) && p.categoryProps) {
				this.addTreeNode(p.category, p.categoryProps);
			} else {
				if (p.categoryParent) {
					var n = this.treeNodes[p.categoryParent];
					if (n) {
						this.addTreeSubNode(i, p.categoryProps, n);
					}
				}
			}
		}
	}, _selectComponent:function (inNode, inComponentName) {
		for (var i = 0, kids = inNode.kids; (k = kids[i]); i++) {
			if (k.component == inComponentName) {
				k.tree.select(k);
				this.selectedNode = k;
				return true;
			}
		}
	}, getInspector:function (inInspectorName) {
		return this.inspector._inspectors[inInspectorName];
	}, updateInspectorLayer:function (inInspectorName) {
		var n = this.inspectorName = inInspectorName, i = this.getInspector(n);
		wm.fire((i || 0).parent, "activate");
	}, resetInspector:function () {
		this.inspectorName = null;
	}, inspect:function (inComponent) {
		this.inspected = inComponent;
		this.initTree(inComponent);
		var n = this.selectedNode = this.treeNodes[this.inspectorName] || this.treeNodes["Properties"];
		this.tree.select(n);
	}, reinspect:function () {
		var n = (this.selectedNode || 0).component;
		if (n) {
			this.inspectComponent(n, this.selectedNode);
		} else {
			this.inspector.inspect(this.inspected, this.selectedNode);
		}
	}, focusDefault:function () {
		wm.fire(this.inspector, "focusDefault");
	}, treeSelect:function (inNode) {
		if (inNode.inspector) {
			this.updateInspectorLayer(inNode.inspector);
		}
		this.selectedNode = inNode._nodeName && this.treeNodes[inNode._nodeName];
		this.reinspect();
	}, inspectComponent:function (inComponentName, inInspectorProps) {
		this.inspector.inspect(this.inspected.getComponent(inComponentName), inInspectorProps);
	}, refreshComponent:function (inSubComponent) {
		var n = (inSubComponent || 0).name;
		for (var i = 0, kids = this.tree.root.kids, k, f; (k = kids[i]); i++) {
			if (k._nameName == "Properties" || k.isCollection) {
				var f = this._selectComponent(k, n);
				if (f) {
					break;
				}
			}
		}
	}, setSelectMode:function (inMode) {
		this.inspector.setSelectMode(inMode);
	}, writeChildren:function () {
	}});
}
if (!dojo._hasResource["wm.studio.app.inspect"]) {
	dojo._hasResource["wm.studio.app.inspect"] = true;
	dojo.provide("wm.studio.app.inspect");
	wm.bubble = function (e) {
		dojo.fixEvent(e);
		var t = e.target, n = "_on" + e.type;
		while (t && !t[n]) {
			t = t.parentNode;
		}
		if (t) {
			t[n](e);
		}
	};
	makeSelectPropEdit = function (inName, inValue, inOptions, inDefault, inValues) {
		var html = ["<select name=\"", inName, "\" onfocus=\"wm.bubble(event)\" onchange=\"wm.bubble(event)\">"];
		for (var i = 0, l = inOptions.length, o, v; (o = inOptions[i]) || (i < l); i++) {
			v = inValues ? inValues[i] : o;
			html.push("<option", " value=\"" + v + "\"", (inValue == v ? " selected=\"selected\"" : ""), ">", (o == inDefault ? "" + o + " (default)" : o), "</option>");
		}
		html.push("</select>");
		return html.join("");
	};
	makeCheckPropEdit = function (inName, inValue, inDefault) {
		return ["<input style=\"width: auto; height: auto; background: transparent;\" type=\"checkbox\" name=\"", inName, "\"", (inValue == inDefault ? " class=\"prop-default\"" : ""), (inValue ? "checked=\"checked\"" : "") + "\"/>"].join("");
	};
	makeInputPropEdit = function (inName, inValue, inDefault, inReadonly) {
		inValue = inValue === undefined ? "" : inValue;
		inValue = String(inValue).replace(/\"/g, "&quot;") || "";
		return ["<input name=\"", inName, "\"", "onfocus=\"wm.bubble(event)\" onblur=\"wm.bubble(event)\"", (inValue == inDefault ? " class=\"prop-default\"" : ""), (inReadonly === true ? " readOnly=\"true\"" : ""), " value=\"", inValue, "\"/>"].join("");
	};
	makeTextPropEdit = function (inName, inValue, inDefault, inRows) {
		return ["<textarea name=\"", inName, "\"", " wrap=\"soft\" rows=\"", inRows || 8, "\"", " onfocus=\"wm.bubble(event)\" onblur=\"wm.bubble(event)\"", (inValue == inDefault ? " class=\"prop-default\"" : ""), "\">", inValue, "</textarea>"].join("");
	};
	addButtonToEdit = function (inEdit, inValue, inDefault, inContent) {
		var b = "<button class=\"wminspector-prop-button\" type=\"button\">" + (inContent || "&hellip;") + "</button>";
		return "<table class=\"prop-table\" width=\"100%\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tr><td" + (inValue == inDefault ? " class=\"prop-default\"" : "") + ">" + inEdit + "</td><td class=\"prop-button\">" + b + "</td></tr></table>";
	};
	makeInputButtonEdit = function (inName, inValue, inDefault, inContent) {
		var i = makeInputPropEdit(inName, inValue, inDefault);
		return addButtonToEdit(i, inValue, inDefault, inContent);
	};
	makeBoundEdit = function (inName, inValue) {
		return ["<table class=\"bound-prop-table\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\">", "<tr><td class=\"bound-prop\">", makeInputPropEdit(inName, inValue, "", true), "</td>", "<td class=\"bound-prop-button\"></td></tr>", "</table>"].join("");
	};
	makeReadonlyButtonEdit = function (inName, inValue, inDefault, inContent) {
		var i = makeInputPropEdit(inName, inValue, inDefault, true);
		return addButtonToEdit(i, inValue, inDefault, inContent);
	};
	inspectFileboxUrlChange = function () {
		var v = this.value.replace(/\\/g, "/").replace(/C:\/www\/root/, "");
		this.parentNode.reset();
		this.inspected.set_content(v);
	};
	makePictureSourcePropEdit = function (inName, inValue, inDefault) {
		return makeInputPropEdit(inName, inValue, inDefault);
	};
	makePropEdit = function (inComponent, inName, inValue) {
		var c = inComponent, d = c.constructor.prototype[inName];
		return c.makePropEdit(inName, inValue, d) || makeInputPropEdit(inName, inValue, d);
	};
	makeReferencePropEdit = function (inType, inName, inValue) {
		var list = ["(none)"];
		for (var i in wm.Component.byId) {
			var c = wm.Component.byId[i];
			if (c instanceof inType) {
				if (c.isOwnedBy(studio.page) || c.isOwnedBy(studio.application)) {
					list.push(c.id);
				}
			}
		}
		return makeSelectPropEdit(inName, inValue, list);
	};
	inspect = function (inComponent, inDoFocus) {
		setTimeout(function () {
			_inspect(inComponent, inDoFocus);
		}, 1);
	};
	_setInspectedCaption = function (inComponent) {
		var c = inComponent;
		studio.inspected.setCaption(c ? c.name + ": " + c._designee.declaredClass : "(none)");
	};
	_inspect = function (inComponent, inDoFocus) {
		if (inComponent.isDestroyed) {
			return;
		}
		var c = inspected = inComponent;
		_setInspectedCaption(c);
		studio.inspector.inspect(inComponent);
	};
	dojo.declare("wm.EventEditor", dijit.form.ComboBox, {eventActions:{noEvent:{caption:"- No Event"}, jsFunc:{caption:" - Javascript..."}, jsSharedFunc:{caption:" - Javascript Shared..."}, newService:{caption:" - New Service..."}, newNavigation:{caption:" - New Navigation..."}, serviceVariables:{caption:"Service Variables:", list:"serviceVariable"}, navigations:{caption:"Navigations:", list:"navigationCall"}, existingCalls:{caption:"Shared Event Handlers:", list:"sharedEventHandlers"}, dialogs:{caption:"Show Dialogs:", list:"dialogs"}, dashboards:{caption:"Dashboard Add Widget:", list:"dashboards"}, timers:{caption:"Timers:", list:"timers"}, liveForms:{caption:"Live Forms:", list:"liveForms"}}, isEventAction:function (inValue) {
		var ea = this.eventActions;
		for (var i in ea) {
			if (inValue == ea[i].caption) {
				return true;
			}
		}
	}, generateStore:function () {
		var sc = wm.listComponents([studio.application, studio.page], wm.ServiceVariable);
		var lightboxList = wm.listComponents([studio.application, studio.page], wm.DojoLightbox);
		var nc = wm.listComponents([studio.application, studio.page], wm.NavigationCall);
		var sharedEventHandlers = eventList(this.inspected.getSharedEventLookupName(this.propName), wm.isInstanceType(studio.selected.owner, wm.Application) ? studio.appsourceEditor : studio.editArea);
		var dialogList = wm.listComponents([studio.application, studio.page], wm.Dialog);
		dialogList = dialogList.concat(wm.listComponents([studio.application, studio.page], wm.DojoLightbox));
		var dashboardList = wm.listComponents([studio.application, studio.page], wm.Dashboard);
		var lf = wm.listComponents([studio.application, studio.page], wm.LiveForm);
		var timers = wm.listComponents([studio.application, studio.page], wm.Timer);
		var items = [];
		var eventSchema = this.inspected.schema[this.propName];
		wm.forEachProperty(this.eventActions, function (o, name) {
			var n = o.caption, l = o.list;
			if (l) {
				var a;
				switch (l) {
				  case "navigationCall":
					if (eventSchema && eventSchema.events && dojo.indexOf(eventSchema.events, "navigation") == -1) {
						return;
					}
					a = nc;
					break;
				  case "serviceVariable":
					if (eventSchema && eventSchema.events && dojo.indexOf(eventSchema.events, "service") == -1) {
						return;
					}
					a = sc;
					break;
				  case "sharedEventHandlers":
					if (eventSchema && eventSchema.events && dojo.indexOf(eventSchema.events, "javascript") == -1) {
						return;
					}
					a = sharedEventHandlers;
					break;
				  case "dialogs":
					if (eventSchema && eventSchema.events && dojo.indexOf(eventSchema.events, "dialog") == -1) {
						return;
					}
					a = dialogList;
					break;
				  case "lightboxes":
					if (eventSchema && eventSchema.events && dojo.indexOf(eventSchema.events, "lightbox") == -1) {
						return;
					}
					a = lightboxList;
					break;
				  case "liveForms":
					if (eventSchema && eventSchema.events && dojo.indexOf(eventSchema.events, "liveForm") == -1) {
						return;
					}
					a = lf;
					break;
				  case "dashboards":
					if (eventSchema && eventSchema.events && dojo.indexOf(eventSchema.events, "dashboards") == -1) {
						return;
					}
					a = dashboardList;
					break;
				  case "timers":
					if (eventSchema && eventSchema.events && dojo.indexOf(eventSchema.events, "timers") == -1) {
						return;
					}
					a = timers;
					break;
				}
				if (a && a.length) {
					items.push({name:n, value:n});
					dojo.forEach(a, function (obj) {
						var aa = (wm.isInstanceType(obj, wm.Component)) ? obj.getId() : obj;
						if (obj instanceof wm.LiveForm) {
							items.push({name:aa + ".beginDataInsert", value:aa + ".beginDataInsert"});
							items.push({name:aa + ".saveData", value:aa + ".saveData"});
							items.push({name:aa + ".beginDataUpdate", value:aa + ".beginDataUpdate"});
							items.push({name:aa + ".cancelEdit", value:aa + ".cancelEdit"});
							items.push({name:aa + ".deleteData", value:aa + ".deleteData"});
						} else {
							if (obj instanceof wm.Timer) {
								items.push({name:aa + ".startTimer", value:aa + ".startTimer"});
								items.push({name:aa + ".stopTimer", value:aa + ".stopTimer"});
							} else {
								items.push({name:aa, value:aa});
							}
						}
					});
				}
			} else {
				if (eventSchema && eventSchema.events) {
					switch (name) {
					  case "noEvent":
						if (dojo.indexOf(eventSchema.events, "disableNoEvent") != -1) {
							return;
						}
					  case "jsFunc":
						if (dojo.indexOf(eventSchema.events, "js") == -1) {
							return;
						}
						break;
					  case "jsSharedFunc":
						if (dojo.indexOf(eventSchema.events, "sharedjs") == -1) {
							return;
						}
						break;
					  case "newService":
						if (dojo.indexOf(eventSchema.events, "service") == -1) {
							return;
						}
						break;
					  case "newNavigation":
						if (dojo.indexOf(eventSchema.events, "navigation") == -1) {
							return;
						}
						break;
					}
				}
				items.push({name:n, value:n});
			}
		});
		return new wm.base.data.SimpleStore(items, "name");
	}, postMixInProperties:function () {
		this.store = this.generateStore();
		this.inherited(arguments);
	}, postCreate:function () {
		this.inherited(arguments);
		this.domNode.style.width = this.domNode.style.height = "100%";
	}, attr:function (inName, inValue) {
		if (inName == "value" || inName == "item") {
			var value = inName == "value" ? inValue : inValue.name;
			var c = this.inspected, o = c.getValue(this.propName);
			if (this.isEventAction(value)) {
				this.doEventAction(value);
			} else {
				this.inherited(arguments);
				this.inspected.setProp(this.propName, value);
			}
		}
	}, doEventAction:function (inEventName) {
		var ea = this.eventActions, c = this.inspected, p = this.propName, v;
		switch (inEventName) {
		  case ea.noEvent.caption:
			this.attr("value", "");
			break;
		  case ea.jsFunc.caption:
			v = c.generateEventName(p);
			this.attr("value", v);
			try {
				c.updatingEvent(p, v);
			}
			catch (e) {
			}
			eventEdit(c, p, v);
			break;
		  case ea.jsSharedFunc.caption:
			v = c.generateSharedEventName(p);
			this.attr("value", v);
			try {
				c.updatingEvent(p, v);
			}
			catch (e) {
			}
			eventEdit(c, p, v);
			studio.inspector.reinspect();
			break;
		  case ea.newService.caption:
			studio.newComponentButtonClick({componentType:"wm.ServiceVariable"});
			this.attr("value", studio.selected.name);
			break;
		  case ea.newNavigation.caption:
			studio.newComponentButtonClick({componentType:"wm.NavigationCall"});
			this.attr("value", studio.selected.name);
			break;
		}
	}});
	formatEventProp = function (inComponent, inName, inValue, inNode) {
		return new wm.EventEditor({inspected:inComponent, propName:inName, value:inValue, srcNodeRef:inNode});
	};
	formatPropEdit = function (inComponent, inName, inValue, inNode, noEventProps) {
		if (!noEventProps && inName.slice(0, 2) == "on") {
			return formatEventProp.apply(this, arguments);
		} else {
			return wm.fire(inComponent, "formatPropEdit", inName, inValue, inNode);
		}
	};
}
if (!dojo._hasResource["wm.studio.app.sourcer"]) {
	dojo._hasResource["wm.studio.app.sourcer"] = true;
	dojo.provide("wm.studio.app.sourcer");
	sourcer_tab = "\t";
	sourcer_nl = "\n";
	sourcer = function (inName, inPage) {
		return inName + ".widgets = {" + sourcer_nl + source_body(inPage) + "}";
	};
	source_body = function (inTop) {
		var c = inTop.writeComponents(sourcer_tab);
		if (inTop.root) {
			var s = inTop.root.write(sourcer_tab, {});
			if (s) {
				c.push(s);
			}
		}
		return c.length ? c.join("," + sourcer_nl) + sourcer_nl : "";
	};
	toJson = function (v) {
		return dojo.toJson(v);
	};
	propsToJson = function (p) {
		var s = [], v;
		for (var n in p) {
			if (!(n in Object)) {
				v = p[n];
				if (v != undefined) {
					s.push(n + ": " + toJson(v));
				}
			} else {
				console.info("ignoring: " + n + "in " + Object);
			}
		}
		return s.join(", ");
	};
	elementsToJson = function (p) {
		var s = [];
		for (var i = 0, l = p.length; i < l; i++) {
			s.push(toJson(p[i]));
		}
		return s.join(", ");
	};
	quote = function (inValue) {
		return dojo.isString(inValue) ? dojo._escapeString(inValue) : inValue;
	};
}
if (!dojo._hasResource["wm.studio.app.events"]) {
	dojo._hasResource["wm.studio.app.events"] = true;
	dojo.provide("wm.studio.app.events");
	terminus = "_end: 0";
	pageScript = function (name, defaultFunctions) {
		return ["dojo.declare(\"" + name + "\", wm.Page, {", "\tstart: function() {", "\t\t", "\t},", (defaultFunctions ? "\t" + defaultFunctions + "," : ""), "\t" + terminus, "});"].join("\n");
	};
	getEvent = function (name, text) {
		var r = new RegExp(name + ": function\\(", "");
		var m = text.match(r) || [];
		return (m[0] || "").replace(/\r/g, "");
	};
	getArgs = function (ctrl, name) {
		var fn = ctrl._designee.constructor.prototype[name], m = fn && fn.toString().match(/function\s*\(([^)]*)/);
		return !m && " /*,args*/" || m[1] && (", " + m[1]) || "";
	};
	getEventCode = function (ctrl, name, value, code) {
		var a = getArgs(ctrl, name);
		if (wm.isInstanceType(ctrl, wm.Page)) {
			a = a.substring(1);
		} else {
			a = "inSender" + a;
		}
		return value + ": function(" + a + ") {\n\t\t" + code + "\n\t},\n\t";
	};
	writeCodeFragment = function (code) {
		var t = studio.getScript();
		studio.setScript(t.replace(terminus, code + terminus));
	};
	removeCodeFragment = function (start, end) {
		var code = studio.getScript();
		var re = new RegExp("\\/\\*\\s+" + start + "\\s+\\*\\/[\\S\\s]*\\/\\*\\s+" + end + "\\s+\\*\\/.*\n\t", "i");
		code = code.replace(re, "");
		studio.setScript(t);
	};
	eventList = function (eventname, editor) {
		var tmpEventName = eventname.replace(/^on/, "");
		var code = editor.getText();
		var reg = new RegExp("\\bon\\S*" + tmpEventName + "\\:\\s*function", "gi");
		var results = code.match(reg);
		if (results == null) {
			return [];
		}
		for (var i = 0; i < results.length; i++) {
			results[i] = results[i].replace(/\:.*$/, "");
		}
		return results;
	};
	getAllEventsInCode = function () {
		var code = studio.getScript();
		var reg = new RegExp("\\b\\S*.*" + "\\:\\s*function", "gi");
		var results = code.match(reg);
		if (results == null) {
			return [];
		}
		for (var i = 0; i < results.length; i++) {
			results[i] = results[i].replace(/\s*\:.*$/, "");
		}
		results = wm.Array.removeElement(results, "start");
		return results;
	};
	eventEdit = function (ctrl, name, value, noInSenderInArgs) {
		var appLevel = wm.isInstanceType(ctrl.owner, wm.Application);
		var code = (appLevel) ? studio.getAppScript() : studio.getScript();
		if (wm.isInstanceType(ctrl, wm.Page)) {
			value = name;
		}
		if (!getEvent(value, code)) {
			var a = getArgs(ctrl, name);
			if (wm.isInstanceType(ctrl, wm.Page) || noInSenderInArgs) {
				a = a.substring(1);
			} else {
				a = "inSender" + a;
			}
			var code = code.replace(terminus, value + ": function(" + a + ") {\n	  try {\n		  \n		  \n	  } catch(e) {\n		  console.error('ERROR IN " + value + ": ' + e); \n	  } \n  },\n  " + terminus);
			if (appLevel) {
				studio.setAppScript(code);
			} else {
				studio.setScript(code);
			}
		}
		studio.navGotoSourceClick();
		studio.sourceTabs.setLayer((appLevel) ? "appsource" : "scriptLayer");
		caretToEvent(value, appLevel ? studio.appsourceEditor : studio.editArea);
	};
	eventChange = function (editor, oldName, newName) {
		if (oldName && newName && oldName != newName) {
			var r = new RegExp(oldName + ": function\\(", "m");
			var code = editor.getText();
			editor.setText(code.replace(r, newName + ": function("));
		}
	};
	eventCopy = function (editor, oldName, newName) {
		if (oldName && newName && oldName != newName) {
			var r = new RegExp(oldName + ": function(\\(.*?\\))", "m");
			var code = editor.getText();
			var match = code.match(r);
			if (!match) {
				return;
			}
			if (getEvent(newName, code)) {
				return;
			}
			var newcode = newName + ": function" + match[1] + " {\n	  try {\n		  this." + oldName + match[1] + ";\n		  \n	  } catch(e) {\n		  console.error('ERROR IN " + newName + ": ' + e); \n	  } \n  },\n  ";
			editor.setText(code.replace(terminus, newcode + terminus));
		}
	};
	caretToEvent = function (name, editor) {
		var r = new RegExp("[\\s\\S]*" + name + ": function\\([\\s\\S]*?{[\\s\\S]*?\\n[^\\n\\r\\S]*(try[\\s\\n]*{[\\s\\n]*)?", "m");
		var t = editor.getText();
		var m = t.match(r);
		if (m) {
			editor.setSelectionRange(m[0].length);
		}
	};
	textareaTab = function (e) {
		var t = e.target;
		if (t && t.tagName == "TEXTAREA" && e.keyCode == dojo.keys.TAB) {
			if (document.selection) {
				t.focus();
				var sel = document.selection.createRange();
				sel.text = "\t";
			} else {
				if (t.selectionStart || t.selectionStart == "0") {
					var scrollY = t.scrollTop, scrollX = t.scrollLeft, start = t.selectionStart, end = t.selectionEnd;
					t.value = t.value.substring(0, start) + "\t" + t.value.substring(end, t.value.length);
					t.focus();
					t.selectionStart = t.selectionEnd = start + 1;
					t.scrollTop = scrollY;
					t.scrollLeft = scrollX;
				} else {
					t.value += "\t";
				}
			}
			dojo.stopEvent(e);
		}
	};
	dojo.addOnLoad(function () {
		dojo.connect(document, "keypress", textareaTab);
	});
}
if (!dojo._hasResource["wm.studio.app.file"]) {
	dojo._hasResource["wm.studio.app.file"] = true;
	dojo.provide("wm.studio.app.file");
	loadData = function (inFile, inCallback) {
		if (djConfig.isDebug && !dojo.isFF) {
			console.info("loadData: " + inFile);
		}
		var deferred = dojo.xhrGet({url:inFile, sync:true, preventCache:true}).addCallback(inCallback);
		if (djConfig.isDebug && !dojo.isFF) {
			deferred.addCallback(function (inData) {
				console.log("Service Call Complete: " + inFile);
			});
		}
	};
	loadDataSync = function (inFile) {
		if (djConfig.isDebug && !dojo.isFF) {
			console.info("loadDataSync: " + inFile);
		}
		return dojo.xhrGet({url:inFile, sync:true, preventCache:true}).results[0];
	};
	loadWebData = function (inFile, inCallback) {
		studio.studioService.requestAsync("readWebFile", [inFile]).addCallback(inCallback);
	};
	loadWebDataSync = function (inFile) {
		return studio.studioService.getResultSync("readWebFile", [inFile]);
	};
	_initProjectTemplates = function () {
		var c = wm.studioConfig;
		dojo.mixin(c, {appIndexFileName:"index.html", appConfigFileName:"config.js", appCssFileName:"app.css", appDebugBootFileName:"lib_project.js", appIndexTemplate:"", appCssTemplate:"", appConfigTemplate:""});
		var t = dojo.moduleUrl("wm.studio.app") + "templates/project/";
		loadData(t + c.appIndexFileName, function (t) {
			c.appIndexTemplate = t;
		});
		loadData(t + c.appCssFileName, function (t) {
			c.appCssTemplate = t;
		});
		loadData(t + c.appConfigFileName, function (t) {
			c.appConfigTemplate = t;
		});
	};
	_initPalmProjectTemplates = function () {
		var c = wm.studioConfig;
		dojo.mixin(c, {appIndexFileName:"index.html", appConfigFileName:"config.js", appCssFileName:"app.css", appDebugBootFileName:"lib_project.js", appPalmAppInfoFileName:"appinfo.json", appPalmAppInfoTemplateFileName:"appinfo.template", appIndexTemplate:"", appCssTemplate:"", appConfigTemplate:"", appPalmAppInfoTemplate:""});
		var t = dojo.moduleUrl("wm.studio.app") + "templates/palmproject/";
		loadData(t + c.appIndexFileName, function (t) {
			c.appIndexTemplate = t;
		});
		loadData(t + c.appCssFileName, function (t) {
			c.appCssTemplate = t;
		});
		loadData(t + c.appConfigFileName, function (t) {
			c.appConfigTemplate = t;
		});
		loadData(t + c.appPalmAppInfoTemplateFileName, function (t) {
			c.appPalmAppInfoTemplate = t;
		});
	};
	if (wm.studioConfig.isPalmApp) {
		dojo.addOnLoad(_initPalmProjectTemplates);
	} else {
		dojo.addOnLoad(_initProjectTemplates);
	}
	_saveToFile = function (inPath, inData, inNoOverwrite) {
		return studio.studioService.requestSync("writeWebFile", [inPath, inData, inNoOverwrite || false]);
	};
	_fileExists = function (inPath) {
		return studio.studioService.getResultSync("fileExists", [inPath]);
	};
	webFileExists = function (inPath) {
		return _fileExists("webapproot/" + inPath);
	};
	getPagesScriptTags = function () {
		if (djConfig.isDebug) {
			var n = [], p = studio.project.getPageList();
			tag = ["<scrip", "t type=\"text/javascript\" src=\"", "pages/", "", "/", "", ".js\"></scrip", "t>"];
			for (var i = 0, l; (l = p[i]); i++) {
				tag[3] = tag[5] = l;
				n.push(tag.join(""));
			}
			return n.join("\n");
		}
	};
	makeDebugLoaderJs = function () {
		var n = [], p = studio.project.getPageList();
		tag = ["\t\t\"pages/", "", "/", "", ".js\""];
		for (var i = 0, l; (l = p[i]); i++) {
			tag[1] = tag[3] = l;
			n.push(tag.join(""));
		}
		var s = n.join(",\n");
		return ["if (djConfig.debugBoot) {", "\t" + "wm.loadScripts([", s, "\t]);", "}"].join("\n");
	};
	makeIndexHtml = function (inProjectName) {
		var macros = ["PROJECT"], data = [inProjectName], t = wm.studioConfig.appIndexTemplate;
		for (var i = 0, m, d; (m = macros[i]); i++) {
			d = data[i] || "";
			t = t.replace(new RegExp(["{%", m, "}"].join(""), "g"), d);
		}
		return t;
	};
	makePalmAppInfo = function (inProjectName) {
		var macros = ["PROJECT"], data = [inProjectName.toLowerCase()], t = wm.studioConfig.appPalmAppInfoTemplate;
		for (var i = 0, m, d; (m = macros[i]); i++) {
			d = data[i] || "";
			t = t.replace(new RegExp(["{%", m, "}"].join(""), "g"), d);
		}
		return t;
	};
	packageData = function (inName, inData) {
		var form = document.createElement("form");
		form.action = "php/package.php?t=" + new Date().getTime();
		form.method = "post";
		document.body.appendChild(form);
		var createInput = function (inName, inValue) {
			var input = document.createElement("input");
			input.type = "hidden";
			input.name = inName;
			input.value = inValue;
			form.appendChild(input);
		};
		for (var i = 0, d; (d = inData[i]); i++) {
			createInput("name[]", inName);
			createInput("ext[]", d[0]);
			createInput("data[]", d[1]);
		}
		form.submit();
		document.body.removeChild(form);
	};
}
if (!dojo._hasResource["wm.studio.app.css"]) {
	dojo._hasResource["wm.studio.app.css"] = true;
	dojo.provide("wm.studio.app.css");
	setCss = function (inSheetId, inCss) {
		var sheet = dojo.byId(inSheetId);
		if (!sheet) {
			return;
		}
		inCss = inCss || "";
		if (sheet.styleSheet) {
			if (dojo.isIE < 7) {
				setIe6Css(sheet, inCss);
			} else {
				sheet.styleSheet.cssText = inCss;
			}
		} else {
			sheet.firstChild && sheet.removeChild(sheet.firstChild);
			sheet.appendChild(document.createTextNode(inCss));
		}
	};
	setIe6Css = function (inSheet, inCss) {
		var c = document.documentElement.firstChild, id = inSheet.id;
		c.removeChild(inSheet);
		var n = document.createElement("style");
		n.id = id;
		n.type = "text/css";
		if (n.styleSheet) {
			n.styleSheet.cssText = inCss;
		} else {
			n.appendChild(document.createTextNode(inCss));
		}
		c.appendChild(n);
	};
	getCssDeclaration = function (inName, inNodeName) {
		inNodeName = inNodeName ? " ." + inNodeName : "";
		var pageName = studio.project.pageName;
		var obj = studio.page[inName];
		var isLayout = (obj && obj instanceof wm.Layout);
		var result = ["body.tundra ." + pageName + (isLayout ? "" : " .wmlayout") + " ." + pageName + "-" + inName + inNodeName + (isLayout ? ".wmlayout" : "")];
		return result.join(",\n");
	};
	addCssTemplate = function (inName) {
		var css = studio.cssEditArea, t = css.getText();
		css.setText(t + getCssDeclaration(inName) + " {\n\n}\n\n");
	};
	getNodeStyleRegExp = function (inName, inNodeName) {
		var d = getCssDeclaration(inName, inNodeName).replace(".", "\\.");
		return new RegExp(d + " \\{([^}]*)\\}(\n*)");
	};
	getControlStyleRegExp = function (inName) {
		var d = getCssDeclaration(inName).replace(".", "\\.");
		return new RegExp(d + "(.*)\\{([^}]*)\\}(\n*)", "g");
	};
	getControlStyles = function (inName) {
		var t = studio.cssEditArea.getText(), r = getControlStyleRegExp(inName);
		var m, s, r, result = [], n, c;
		while ((m = r.exec(t)) != null) {
			n = dojo.trim(m[1]);
			if (n.indexOf(".") == 0) {
				n = n.slice(1);
			}
			c = (m[2] || "").replace(/\r|\t/g, "").slice(1, -1);
			result.push({node:n, css:c});
		}
		return result;
	};
	getControlNodeStyles = function (inName, inNodeName) {
		var t = studio.cssEditArea.getText(), r = getNodeStyleRegExp(inName, inNodeName);
		var m = t.match(r) || [], s = m[1] || "";
		return s.replace(/\r|\t/g, "").slice(1);
	};
	setControlNodeStyles = function (inName, inStyles, inNodeName) {
		var s = inStyles;
		if (s) {
			if (s.slice(-1) == "\n") {
				s = s.slice(0, -1);
			}
			s = "\t" + s.replace("\n", "\n\t");
		}
		var css = studio.cssEditArea, t = css.getText(), r = getNodeStyleRegExp(inName, inNodeName), st = getCssDeclaration(inName, inNodeName) + " {\n" + s;
		if (t.match(r)) {
			css.setText(t.replace(r, s ? st + "\n}$2" : ""));
		} else {
			if (s) {
				css.setText(t + st + "\n}\n\n");
			}
		}
	};
	styleChange = function (oldName, newName) {
		if (oldName && newName && oldName != newName) {
			var r = new RegExp("(\\." + studio.project.pageName + "-)(" + oldName + ")(\\W+)", "g"), css = studio.cssEditArea, t = css.getText();
			css.setText(t.replace(r, "$1" + newName + "$3"));
		}
	};
	dojo.subscribe("wmwidget-rename", styleChange);
	listClassNames = function (inStyles) {
		var re = /\.[^.\s\#]*/g;
		return inStyles.match(re);
	};
	dojo.addOnLoad(function () {
		wm.headAppend(wm.createElement("style", {id:"app_ss", type:"text/css"}));
		wm.headAppend(wm.createElement("style", {id:"page_ss", type:"text/css"}));
		wm.headAppend(wm.createElement("style", {id:"theme_ss", type:"text/css"}));
		defaultStyleSheet = loadDataSync(dojo.moduleUrl("wm") + "base/styles/wavemaker.css");
		var n = listClassNames(defaultStyleSheet);
		for (var i = 0, cn, inf; (cn = n[i]); i++) {
			n[i] = cn.split("_");
		}
		var g = [];
		for (i = 0; (cn = n[i]); i++) {
			if (cn.length < 3) {
				continue;
			}
			if (!g[cn[1]]) {
				g[cn[1]] = [];
			}
			g[cn[1]].push(cn[2]);
		}
		defaultCssClasses = g;
	});
}
if (!dojo._hasResource["wm.studio.app.project"]) {
	dojo._hasResource["wm.studio.app.project"] = true;
	dojo.provide("wm.studio.app.project");
	dojo.declare("wm.studio.Project", null, {newProject:function (inName, optionalInTheme, optionalInTemplate) {
		var n = inName || this.projectName || "Project";
		this.projectName = wm.getValidJsName(n);
		this.pageName = "メイン";
		studio.beginWait("新しいプロジェクトをセットアップしています");
		var d = studio.studioService.requestAsync("newProject", [this.projectName]);
		d.addCallbacks(dojo.hitch(this, function (inResult) {
			this.finishNewProject(inResult, optionalInTheme, optionalInTemplate);
		}), function (inResult) {
			console.log(bundleDialog.M_NewProjectFailed, inResult);
		});
		return d;
	}, finishNewProject:function (inResult, optionalInTheme, optionalInTemplate) {
		this.projectChanging();
		this.createApplicationArtifacts();
		this.makeApplication({theme:optionalInTheme || "wm_default"});
		this.newPage(this.pageName, "", {template:optionalInTemplate});
		this.saveProject(this.projectName);
		this.projectChanged();
		this.projectsChanged();
		studio.endWait("新しいプロジェクトをセットアップしました");
	}, newPage:function (inName, pageType, argHash) {
		if (!this.projectName) {
			return;
		}
		this.pageChanging();
		this.pageName = inName;
		this.createPageArtifacts(pageType, argHash);
		this.makePage();
		this.savePage();
		this.pageChanged();
		this.pagesChanged();
	}, createApplicationArtifacts:function () {
		var ctor = dojo.declare(this.projectName, wm.Application);
		this.projectData = {css:"", jscustom:this.projectName + ".extend({\n\n\t" + terminus + "\n});"};
		studio.setAppScript(this.projectData.jscustom);
	}, createPageArtifacts:function (pageType, argHash) {
		if (!argHash) {
			argHash = {};
		}
		var ctor = dojo.declare(this.pageName, wm.Page);
		this.pageData = {};
		this.pageData.widgets = ctor.widgets = this.getPageTemplate(pageType, argHash);
		var functionTemplate = this.getScriptTemplate(pageType, argHash);
		studio.setScript(this.pageData.js = pageScript(this.pageName, functionTemplate));
		this.pageData.css = this.pageData.html = "";
	}, getPageTemplate:function (pageType, argHash) {
		var template_def = argHash.template;
		if (template_def) {
			var template = dojo.clone(template_def);
			var widgets = template._template;
			delete template._template;
			var hasLayout = false;
			for (var i in widgets) {
				if (widgets[i][0] == "wm.Layout") {
					hasLayout = true;
				}
			}
			var widgets_js;
			if (hasLayout) {
				widgets_js = widgets;
			} else {
				widgets_js = {layoutBox1:["wm.Layout", {name:"layout1"}, {}, {}]};
				for (var i in template) {
					widgets_js.layoutBox1[1][i] = template[i];
				}
				widgets_js.layoutBox1[3] = widgets;
			}
			if (argHash.editTemplate) {
				argHash.editTemplate(widgets_js);
			}
			return widgets_js;
		} else {
			return {layoutBox1:["wm.Layout", {height:"100%", width:"100%", horizontalAlign:"left", verticalAlign:"top"}, {}, {}]};
		}
	}, getScriptTemplate:function (pageType, argHash) {
		switch (pageType) {
		  case "wm.ListViewerRow":
			return "button1Click: function(inSender) {\n" + "\t\t/* Example of finding and triggering an action based on a button click */\n" + "\t\tvar data = this.variable.getData();\n" + "\t\tconsole.log(\"You have just clicked on a button in the row showing the following data:\");\n" + "\t\tconsole.log(data);\n" + "\t}";
		  default:
			return "";
		}
	}, openProject:function (inProjectName, inPageName) {
		if (!inProjectName) {
			this.closeProject();
			return;
		}
		if (this.projectName && this.projectName != null && this.projectName != "") {
			if (this.projectName != inProjectName) {
				this.closeProject(this.projectName);
			}
		}
		var o = studio.studioService.getResultSync("openProject", [inProjectName]);
		if (o) {
			this.projectName = inProjectName;
			if (o.upgradeMessages) {
				this.showUpgradeMessage(o.upgradeMessages);
			}
			this.projectChanging();
			try {
				this.loadApplication();
				var ctor = dojo.getObject(this.projectName);
				this.pageName = inPageName || (ctor ? ctor.prototype.main : "Main");
				this.makeApplication();
				this.openPage(this.pageName);
			}
			catch (e) {
				console.debug(e);
				this.loadError(bundleDialog.M_FailedToOpenProject + this.projectName + ". Error: " + e);
				this.projectName = "";
				this.pageName = "";
				studio.application = studio.page = null;
			}
			finally {
				this.projectChanged();
			}
		} else {
			alert(studio.studioService.error || "Failed to open project");
			this.closeProject();
		}
	}, openPage:function (inName) {
		this.pageChanging();
		this.pageName = inName;
		try {
			this.loadPage();
			this.makePage();
		}
		catch (e) {
			console.debug(e);
			this.loadError(bundleDialog.M_FailedToOpenPage + this.pageName + ". Error: " + e);
			this.pageName = "";
			studio.page = null;
		}
		finally {
			this.pageChanged();
		}
	}, loadProjectData:function (inPath) {
		return wm.load("projects/" + this.projectName + "/" + inPath);
	}, loadApplication:function () {
		this.projectData = {js:this.loadProjectData(this.projectName + ".js"), css:this.loadProjectData("app.css").replace(/^\@import.*theme.css.*/, "").replace(/^\n*/, ""), documentation:dojo.fromJson(this.loadProjectData(this.projectName + ".documentation.json"))};
		if (!this.projectData.js) {
			alert(bundleDialog.M_WarningCouldNotFind + " projects/" + this.projectName + "/" + this.projectName + ".js");
		} else {
			var src = this.projectData.js;
			var extendIndex = src.indexOf(this.projectName + ".extend");
			if (extendIndex == -1) {
				this.projectData.js = src;
				this.projectData.jscustom = this.projectName + ".extend({\n\n\t_end: 0});";
			} else {
				this.projectData.js = src.substring(0, extendIndex).trim();
				this.projectData.jscustom = src.substring(extendIndex).trim() || this.projectName + ".extend({\n\n\t_end: 0});";
			}
		}
		eval(this.projectData.js);
	}, loadPage:function () {
		var n = this.pageName, f = wm.pagesFolder + n + "/", p = f + n;
		this.pageData = {js:this.loadProjectData(p + ".js"), widgets:this.loadProjectData(p + ".widgets.js"), css:this.loadProjectData(p + ".css"), html:this.loadProjectData(p + ".html"), documentation:dojo.fromJson(this.loadProjectData(p + ".documentation.json"))};
		var ctor = dojo.declare(n, wm.Page);
		eval(this.pageData.widgets);
	}, makeApplication:function (inProps) {
		inProps = inProps || {};
		var ctor = dojo.getObject(this.projectName);
		if (ctor) {
			studio.application = new ctor(dojo.mixin({_designer:studio.designer}, inProps));
			for (var i in this.projectData.documentation) {
				if (studio.application.components[i]) {
					studio.application.components[i].documentation = this.projectData.documentation[i];
				} else {
					console.error("studio.application.components[" + i + "] not found for setting documentation: " + this.projectData.documentation[i]);
				}
			}
		}
	}, makePage:function () {
		var ctor = dojo.getObject(this.pageName);
		if (ctor) {
			studio.connect(ctor.prototype, "init", function () {
				studio.page = this;
			});
			studio.connect(ctor.prototype, "start", function () {
				wm.fire(studio.application, "start");
			});
			studio.page = new ctor({name:"wip", domNode:studio.designer.domNode, owner:studio, _designer:studio.designer});
			studio.page.root.parent = studio.designer;
			for (var i in this.pageData.documentation) {
				if (i == "wip") {
					studio.page.documentation = this.pageData.documentation[i];
				} else {
					studio.page.components[i].documentation = this.pageData.documentation[i];
				}
			}
		}
	}, loadError:function (inMessage) {
		alert(inMessage);
		this.projectChanged();
	}, saveProject:function () {
		this.saveApplication();
		this.savePage();
		if (webFileExists("login.html")) {
			var templateFolder = dojo.moduleUrl("wm.studio.app") + "templates/security/";
			var loginhtml = loadDataSync(templateFolder + "login.html");
			studio.project.saveProjectData("login.html", wm.makeLoginHtml(loginhtml, studio.project.projectName, studio.application.theme));
		}
		app.toastSuccess("プロジェクトを保存しました。");
	}, saveScript:function () {
		this.saveProject();
	}, saveAppScript:function () {
		this.saveProject();
	}, saveCss:function () {
		this.saveProject();
	}, saveMarkup:function () {
		this.saveProject();
	}, getProjectPath:function () {
		return this.projectName;
	}, saveApplication:function () {
		studio.application.incSubversionNumber();
		try {
			studio.application.setValue("studioVersion", dojo.byId("studio_startContainer_start_content1").innerHTML.match(/Studio Version\: (.*)\</)[1]);
		}
		catch (e) {
			console.error("Failed to write studio version to project file");
		}
		if (studio.tree.selected && studio.tree.selected.component == studio.application) {
			studio.inspector.reinspect();
		}
		var src = this.generateApplicationSource();
		this.saveProjectData(this.projectName + ".js", src);
		var appdocumentation = studio.application.getDocumentationHash();
		this.saveProjectData(this.projectName + ".documentation.json", dojo.toJson(appdocumentation, true));
		var c = wm.studioConfig;
		this.saveProjectData(c.appIndexFileName, makeIndexHtml(this.projectName, studio.application.theme), true);
		this.saveProjectData(c.appConfigFileName, c.appConfigTemplate, true);
		var themename = studio.application.theme;
		var path = (themename.match(/^wm_/)) ? "/wavemaker/lib/wm/base/widget/themes/" + themename + "/theme.css" : "/wavemaker/lib/wm/common/themes/" + themename + "/theme.css";
		this.saveProjectData(c.appCssFileName, "@import \"" + path + "\";\n" + studio.getAppCss());
		this.saveProjectData(c.appDebugBootFileName, "", true);
		if (wm.studioConfig.isPalmApp) {
			this.saveProjectData(c.appPalmAppInfoFileName, makePalmAppInfo(this.projectName), true);
			this.saveProjectData("app/views/first/first-scene.html", "", true);
		}
		studio.setCleanApp();
	}, generateApplicationSource:function () {
		return studio.application.write(sourcer_tab + sourcer_tab);
	}, savePageAs:function (inName) {
		var previousName = this.pageName;
		this.pageName = inName;
		if (this.pageName != previousName) {
			studio.pageNameChange(previousName, this.pageName);
		}
		this.savePage();
		this.pageChanged();
		this.pagesChanged();
		this.openPage(this.pageName);
	}, savePage:function () {
		this.savePageData(this.pageName + ".js", studio.getScript());
		this.savePageData(this.pageName + ".widgets.js", studio.getWidgets());
		this.savePageData(this.pageName + ".css", studio.getCss());
		this.savePageData(this.pageName + ".html", studio.getMarkup());
		var documentation = studio.page.getDocumentationHash();
		this.savePageData(this.pageName + ".documentation.json", dojo.toJson(documentation, true));
		studio.setCleanPage();
	}, saveProjectData:function (inPath, inData, inNoOverwrite) {
		return studio.studioService.requestSync("writeWebFile", [inPath, inData, inNoOverwrite || false]);
	}, savePageData:function (inPath, inData, inNoOverwrite) {
		var path = wm.pagesFolder + this.pageName + "/" + inPath;
		return studio.studioService.requestSync("writeWebFile", [path, inData, inNoOverwrite || false]);
	}, copyProject:function (inName, inNewName) {
		if (inName && inNewName) {
			this.saveProject();
		}
		studio.studioService.requestAsync("copyProject", [inName, inNewName], dojo.hitch(this, "projectsChanged"));
	}, deleteProject:function (inName) {
		var deleteCurrentProject = (inName == this.projectName);
		if (deleteCurrentProject) {
			this.closeProject();
		}
		return studio.studioService.requestAsync("deleteProject", [inName], dojo.hitch(this, function () {
			this.projectChanged(inName);
		}));
	}, deletePage:function (inName) {
		return studio.pagesService.requestAsync("deletePage", [inName], dojo.hitch(this, function () {
			if (inName == this.pageName) {
				this.openPage(studio.application.main);
			}
			this.pagesChanged();
		}), function (inError) {
			alert(inName + bundleDialog.M_CouldNotBeDeleted + ", error: " + inError);
		});
	}, closeProject:function (inProjectName) {
		wm.fire(studio._deployer, "cancel");
		this.pageChanging();
		this.projectChanging();
		studio.studioService.requestSync("closeProject");
		this.pageList = [];
		this.projectName = this.pageName = "";
		this.pageChanged();
		this.projectChanged(inProjectName);
	}, showUpgradeMessage:function (inMessages) {
		var message = bundleDialog.M_BackupOld + inMessages.backupExportFile;
		if (inMessages.messages) {
			var firstElem = true;
			for (var key in inMessages.messages) {
				if (firstElem) {
					message += bundleDialog.M_Important;
					firstElem = false;
				}
				message += "\t" + inMessages.messages[key] + "\n";
			}
		}
		alert(message);
	}, updatePageList:function () {
		var d = studio.pagesService.requestSync("listPages", null);
		d.addCallback(dojo.hitch(this, function (inResult) {
			inResult.sort();
			this.pageList = inResult;
			return inResult;
		}));
		return d;
	}, getPageList:function () {
		return this.pageList || [];
	}, updateProjectList:function () {
		var d = studio.studioService.requestSync("listProjects", null);
		d.addCallback(dojo.hitch(this, function (inResult) {
			inResult.sort();
			this.projectList = inResult;
			return inResult;
		}));
		return d;
	}, getProjectList:function () {
		return this.projectList || [];
	}, projectsChanged:function () {
		studio.projectsChanged();
	}, pagesChanged:function () {
		this.updatePageList();
		studio.pagesChanged();
	}, projectChanging:function () {
		this.updatePageList();
		studio.projectChanging();
	}, projectChanged:function (optionalInName) {
		var name = (optionalInName || this.projectName);
		var projectData = (name == this.projectName) ? (this.projectData || {}) : {};
		studio.projectChanged(name, projectData);
	}, pageChanging:function () {
		studio.pageChanging();
	}, pageChanged:function () {
		studio.pageChanged(this.pageName, this.pageData || {});
	}});
	Studio.extend({setCleanPage:function (inPageData) {
		this._cleanPageData = this.page ? {js:inPageData ? inPageData.js : this.getScript(), widgets:inPageData ? inPageData.widgets : this.getWidgets()} : {};
	}, setCleanApp:function () {
		this._cleanAppData = this.application ? {script:this.project.generateApplicationSource()} : {};
	}, isPageDirty:function () {
		var c = this._cleanPageData;
		if (!c) {
			return;
		}
		return this.page && (c.js != this.getScript() || c.widgets != this.getWidgets());
	}, isAppDirty:function () {
		var c = this._cleanAppData;
		if (!c) {
			return;
		}
		return this.application && (c.script != this.project.generateApplicationSource());
	}, isProjectDirty:function () {
		return this.isAppDirty() || this.isPageDirty();
	}});
	Studio.extend({newPageClick:function (inSender, inEvent, optionalPageType, optionalPageName) {
		var pageName = optionalPageName || "Page";
		if (!this.project.projectName) {
			return;
		}
		if (!this.isShowingWorkspace()) {
			this.tabs.setLayer("workspace");
		}
		this.confirmPageChange(bundleDialog.M_AreYouSureAddNewPage, undefined, dojo.hitch(this, function () {
			var pages = this.project.getPageList();
			var l = {};
			dojo.forEach(pages, function (p) {
				l[p] = true;
			});
			this.promptForName("page", wm.findUniqueName(pageName, [l]), pages, dojo.hitch(this, function (n) {
				n = wm.capitalize(n);
				this.waitForCallback(bundleDialog.M_CreatePage + n, dojo.hitch(this.project, "newPage", n, optionalPageType));
			}));
		}));
	}, newProjectClick:function () {
		if (this.project.projectName) {
			this.confirmAppChange(bundleDialog.M_AreYouSureCloseProject, undefined, dojo.hitch(this, "_newProjectClick"));
		} else {
			this._newProjectClick();
		}
	}, _newProjectClick:function () {
		var projects = this.project.getProjectList();
		var l = {};
		dojo.forEach(projects, function (p) {
			l[p] = true;
		});
		if (!studio.newProjectDialog.pageName) {
			studio.newProjectDialog.setPageName("NewProjectDialog");
		}
		studio.newProjectDialog.page.projectName.setDataValue("Project");
		studio.newProjectDialog.page.reset();
		studio.newProjectDialog.show();
	}, welcomeOpenClick:function () {
		this.projects.activate();
	}, saveProjectClick:function () {
		this.waitForCallback(bundleDialog.M_SavingProject + this.project.projectName, dojo.hitch(this.project, "saveProject"));
	}, saveScriptClick:function () {
		this.waitForCallback(bundleDialog.M_SavingScript + this.project.projectName, dojo.hitch(this.project, "saveScript"));
	}, saveCssClick:function () {
		this.waitForCallback(bundleDialog.M_SavingCSS + this.project.projectName, dojo.hitch(this.project, "saveCss"));
	}, saveMarkupClick:function () {
		this.waitForCallback(bundleDialog.M_SavingMarkup + this.project.projectName, dojo.hitch(this.project, "saveMarkup"));
	}, saveAppSrcClick:function () {
		this.waitForCallback(bundleDialog.M_SavingAppScript + this.project.projectName, dojo.hitch(this.project, "saveAppScript"));
	}, savePageAsClick:function () {
		this.promptForName("page", this.page.declaredClass, this.project.getPageList(), dojo.hitch(this, function (n) {
			if (n) {
				this.waitForCallback(bundleDialog.M_SavingPageAs + n, dojo.hitch(this.project, "savePageAs", n));
			}
		}));
	}, refreshScriptClick:function () {
		app.confirm(bundleDialog.M_AreYouSureReload, false, dojo.hitch(this, function () {
			this.refreshScript();
		}));
	}, refreshScript:function () {
		var updatedScript = studio.project.loadProjectData(wm.pagesFolder + studio.project.pageName + "/" + studio.project.pageName + ".js");
		studio.setScript(updatedScript);
	}, importJavascriptLibrary:function () {
		this.beginBind("Script Importer", studio.editArea, "js");
	}, importAppJavascriptLibrary:function () {
		this.beginBind("Script Importer", studio.appsourceEditor, "js");
	}, importCssLibrary:function () {
		this.beginBind("Css Importer", studio.cssEditArea, "css");
	}, beginBind:function (inPropName, editArea, type) {
		var bd = this.getBindDialog();
		var p = {targetProperty:inPropName, object:editArea};
		bd.positionLocation = "bl";
		bd.positionNode = editArea;
		if (p) {
			bd.page.update(p);
			bd.bindSourceDialog.resourceRb.editor.setChecked(true);
			bd.bindSourceDialog.treeControlsPanel.hide();
			bd.bindSourceDialog.applyButton.setCaption("Import");
			bd.bindSourceDialog.applyButtonClick = function () {
				var filepath = bd.bindSourceDialog.bindEditor.getValue("dataValue");
				var newtext = "";
				if (type == "css") {
					newtext = "@import \"" + filepath + "\";";
					editArea.setText(newtext + "\n" + editArea.getText());
				} else {
					newtext = "eval(wm.load(\"" + filepath + "\"));";
					editArea.setText(editArea.getText() + "\n" + newtext);
				}
				bd.bindSourceDialog.cancelButtonClick();
			};
			bd.show();
			bd.domNode.style.display = "block";
			return true;
		}
	}, endBind:function (inPropName, inNode) {
		if (this.bindDialog) {
			this.bindDialog.destroy();
			this.bindDialog = undefined;
		}
	}, getBindDialog:function () {
		var props = {owner:this, pageName:"BindSourceDialog", modal:false, positionLocation:"tl", border:"1px", width:550, height:350, hideControls:true, title:"Binding..."}, d = this.bindDialog = new wm.PageDialog(props);
		var b = this.bindDialog;
		if (b._hideConnect) {
			dojo.disconnect(b._hideConnect);
		}
		b._hideConnect = dojo.connect(b, "onHide", this, "endBind");
		return b;
	}, deleteSelectedProjectPageClick:function (inSender) {
		var n = this.projectsTree.selected;
		if (!n) {
			return;
		}
		if (n.page) {
			this.deletePage(n.page);
		} else {
			if (n.project) {
				this.deleteProject(n.project);
			}
		}
	}, openSelectedProjectPageClick:function (inSender) {
		var n = this.projectsTree.selected;
		if (!n) {
			return;
		}
		var page = n.page, project = n.project, warnPage = bundleDialog.M_AreYouSureOpenPage, warnProject = bundleDialog.M_AreYouSureCloseProject;
		if (project == this.project.projectName) {
			if (page && page != this.project.pageName) {
				this.confirmPageChange(warnPage, page, dojo.hitch(this, function () {
					this.waitForCallback(bundleDialog.M_OpeningPage + page + ".", dojo.hitch(this.project, "openPage", page));
				}));
			}
		} else {
			if (project) {
				this.confirmAppChange(warnProject, undefined, dojo.hitch(this, function () {
					studio.studioService.requestSync("closeProject");
					var p = bundleDialog.M_OpeningProject + project + (page ? bundleDialog.M_AndPage + page : "") + ".";
					this.waitForCallback(p, dojo.hitch(this.project, "openProject", project, page));
				}));
			}
		}
	}, openProjectClick:function () {
		this.navGotoEditor(this.startLayer.name);
		this.startEditor.page.openProjectTab();
	}, deleteProjectClick:function () {
		if (studio.project) {
			this.deleteProject(studio.project.projectName);
		}
	}, deleteProject:function (inName) {
		var p = inName;
		if (p) {
			app.confirm(bundleDialog.M_AreYouSureDeleteProject + p + "?", false, dojo.hitch(this, function () {
				if (studio.project.projectName == inName) {
					this.project.closeProject();
				}
				this.project.deleteProject(inName);
				this.left.setLayer("projects");
			}));
		}
	}, deletePage:function (inName) {
		if (this.application.main == inName) {
			alert(inName + bundleDialog.M_DeleteHomePage);
			return;
		}
		app.confirm(bundleDialog.M_AreYouSureDeletePage + inName + "?", false, dojo.hitch(this, function () {
			this.project.deletePage(inName);
		}));
	}, closeClick:function () {
		this.confirmAppChange(bundleDialog.M_AreYouSureCloseProject, undefined, dojo.hitch(this, function () {
			this.project.closeProject();
		}));
	}, copyProjectClick:function () {
		if (studio.project) {
			this.getNewProjectName(studio.project.projectName, dojo.hitch(this, function (n) {
				if (n) {
					this.waitForCallback(bundleDialog.M_CopyingProject + studio.project.projectName + bundleDialog.M_CopyProjectTo + n, dojo.hitch(this.project, "copyProject", studio.project.projectName, n));
				}
			}));
		}
	}, importProjectClick:function (inSender) {
		var d = this.importPageDialog;
		if (d) {
			d.page.update();
		} else {
			d = this.importPageDialog = new wm.PageDialog({owner:studio, name:"importPageDialog", pageName:"ImportPageDialog", hideControls:true});
			d.onClose = function (inWhy) {
				if (inWhy == "OK") {
					studio.project.pagesChanged();
				}
			};
		}
		d.show();
	}, makeHomeClick:function () {
		this.setProjectMainPage(this.page.declaredClass);
	}, makeSelectedHomeClick:function (inSender) {
		var n = this.projectsTree.selected;
		if (n && n.page) {
			this.setProjectMainPage(n.page);
		}
	}, setProjectMainPage:function (inName) {
		this.application.main = inName;
		this.pagesChanged();
		this.saveProjectClick();
	}, projectSettingsClick:function (inSender) {
		var d = this.preferencesDialog;
		if (d) {
			d.page.update();
		} else {
			this.preferencesDialog = d = new wm.PageDialog({pageName:"PreferencesPane", owner:studio, hideControls:true, contentHeight:250, contentWidth:500});
			d.onClose = function (inWhy) {
				if (inWhy == "OK") {
					studio.updateProjectTree();
				}
			};
		}
		d.show();
	}, clearProjectPages:function () {
		var pages = this.project.getPageList();
		dojo.forEach(pages, function (p) {
			this.removeClassCtor(p);
		}, this);
	}, removeClassCtor:function (inName) {
		var ctor = dojo.getObject(inName);
		if (ctor) {
			delete ctor;
		}
		window[inName] = null;
	}, getNewProjectName:function (inName, onSuccess) {
		var projects = this.project.getProjectList();
		var l = {};
		dojo.forEach(projects, function (p) {
			l[p] = true;
		});
		return this.promptForName("project", wm.findUniqueName(inName || "Project", [l]), projects, onSuccess);
	}, confirmPageChange:function (inMessage, inNewPage, onConfirm, onCancel) {
		var inMessage = dojo.string.substitute(inMessage, {page:"\"" + this.project.pageName + "\"", newPage:inNewPage});
		if (this.isPageDirty()) {
			app.confirm(inMessage, false, onConfirm, onCancel);
		} else {
			if (onConfirm) {
				onConfirm();
			}
		}
	}, confirmAppChange:function (inMessage, inNewProject, onConfirm, onCancel) {
		var inMessage = dojo.string.substitute(inMessage, {project:"\"" + this.project.projectName + "\"", newProject:inNewProject});
		if (this.isProjectDirty()) {
			app.confirm(inMessage, false, onConfirm, onCancel);
		} else {
			if (onConfirm) {
				onConfirm();
			}
		}
	}, promptForName:function (inTarget, inDefault, inExistingList, onSuccess) {
		var newPrompt = bundleDialog.M_EnterNewName;
		var warnExists = bundleDialog.M_WarnAlreadExist;
		var warnNotValid = bundleDialog.M_WarnInvalidName;
		app.prompt(dojo.string.substitute(newPrompt, {target:inTarget}), inDefault, dojo.hitch(this, function (name) {
			if (name !== null) {
				name = dojo.trim(name);
				for (var i = 0, exists = false, lcn = name.toLowerCase(), n; (n = inExistingList[i]); i++) {
					if (n.toLowerCase() == lcn) {
						exists = true;
						break;
					}
				}
				if (exists) {
					app.toastDialog.showToast(dojo.string.substitute(warnExists, {target:inTarget, name:name}), 5000, "Warning", "cc");
					return wm.onidle(this, function () {
						this.promptForName(inTarget, name, inExistingList, onSuccess);
					});
				} else {
					if (window[name] || wm.getValidJsName(name) != name) {
						app.toastDialog.showToast(dojo.string.substitute(warnNotValid, {name:name}), 5000, "Warning");
						return wm.onidle(this, function () {
							this.promptForName(inTarget, name, inExistingList, onSuccess);
						});
					}
				}
				if (onSuccess) {
					onSuccess(name);
				}
			}
		}));
	}, getPreviewUrl:function (isTest) {
		var s = [], q = "", c = wm.studioConfig;
		if (isTest) {
			s.push("debug");
		}
		if (c.previewPopup) {
			s.push("popup");
		}
		var projectPrefix = studio.projectPrefix;
		return "/" + projectPrefix + this.project.projectName + (s.length ? "/?" + s.join("&") : "");
	}, runProjectClick:function (inSender) {
		this._runRequested = inSender.name;
		var isTest = (inSender.name == "navTestBtn");
		this.saveProjectClick();
		this.deploy(bundleDialog.M_BuildingPreview, dojo.hitch(this, function (result) {
			this._runRequested = false;
			wm.openUrl(this.getPreviewUrl(isTest), this.project.projectName, "_wmPreview");
			studio.endWait();
			return result;
		}));
	}});
	Studio.extend({updateProjectTree:function () {
		var d = this.project.updateProjectList();
		d.addCallback(dojo.hitch(this, "_updateProjectTree"));
		if (this.startContainer && this.startContainer.page instanceof wm.Page) {
			d.addCallback(dojo.hitch(this.startContainer.page, "listProjectsResult"));
		}
	}, updateProjectTreePages:function () {
		var n = this.projectsTree.findNode({project:this.project.projectName});
		if (n) {
			n.removeChildren();
			this._updateProjectNode(n, this.project.getPageList());
			this.selectInProjectTree(this.project.projectName, this.project.pageName);
		}
	}, _updateProjectTree:function (inResult) {
		this.projectsTree.clear();
		dojo.forEach(inResult, function (t) {
			new wm.TreeNode(studio.projectsTree.root, {content:t, project:t, image:"images/project_16.png", closed:true, hasChildren:true, initNodeChildren:dojo.hitch(this, "initProjectNodeChildren")});
		}, this);
		this.selectInProjectTree(this.project.projectName, this.project.pageName);
	}, _updateProjectNode:function (inNode, inResult) {
		dojo.forEach(inResult, function (t) {
			new wm.TreeNode(inNode, {content:t, project:inNode.project, page:t, image:"images/page.png", hasChildren:false});
		});
	}, selectInProjectTree:function (inProjectName, inPageName) {
		var n = this.projectsTree.findNode({project:inProjectName});
		if (n && inPageName) {
			n.setOpen(true);
			n = this.projectsTree.findNode({project:inProjectName, page:inPageName}, n) || n;
		}
		if (n) {
			this.projectsTree.select(n);
		}
	}, projectsTreeDblClick:function (inSender, inNode) {
		this.openSelectedProjectPageClick();
	}, initProjectNodeChildren:function (inNode) {
		this.pagesService.requestSync("listPages", [inNode.content], dojo.hitch(this, "_updateProjectNode", inNode));
	}, projectsTreeSelectionChange:function (inNode) {
		var n = this.projectsTree.selected;
		if (!n) {
			return;
		}
		var sameProject = (this.project.projectName == n.project);
		this.projectNewPageButton.setDisabled(!sameProject);
		this.projectSetHomePageButton.setDisabled(!sameProject);
		if (n.page) {
			this.projectDeleteButton.setDisabled(!sameProject);
		} else {
			if (n.project) {
				this.projectSetHomePageButton.setDisabled(true);
				this.projectDeleteButton.setDisabled(false);
			}
		}
		if (n.page && n.parent.kids.length == 1) {
			this.projectDeleteButton.setDisabled(true);
		}
	}});
}
if (!dojo._hasResource["wm.studio.app.markup"]) {
	dojo._hasResource["wm.studio.app.markup"] = true;
	dojo.provide("wm.studio.app.markup");
	getMarkupIds = function () {
		var ids = wm.getNodeIds(studio.markup.domNode);
		ids.sort();
		return ids;
	};
	makeMarkupIdsPropEdit = function (inName, inValue, inDefault) {
		var ids = getMarkupIds();
		ids.unshift("");
		if (dojo.indexOf(ids, inValue) == -1) {
			ids.splice(ids.length ? 1 : 0, 0, inValue);
		}
		return makeSelectPropEdit(inName, inValue, ids, inDefault);
	};
	insertMarkupNode = function (inNode) {
		var ids = getMarkupIds();
		if (dojo.indexOf(ids, inNode.id) == -1) {
			studio.markup.domNode.appendChild(inNode);
		}
	};
	dojo.subscribe("wm-content-markupchanged", insertMarkupNode);
}
if (!dojo._hasResource["wm.studio.app.actions"]) {
	dojo._hasResource["wm.studio.app.actions"] = true;
	dojo.provide("wm.studio.app.actions");
	dojo.declare("wm.Action", null, {constructor:function (inProps) {
		dojo.mixin(this, inProps);
	}, perform:function () {
		if (!this.disabled) {
			this._perform();
		}
	}});
	new wm.Action({name:"toggleBox", _perform:function () {
		var s = studio.selected;
		if (s) {
			s.setBox(s.box == "h" ? "v" : "h");
			inspect(s);
		}
	}});
	wm.undo = {stack:[], push:function (inTask) {
		if (inTask) {
			this.stack.push(inTask);
		}
		this.updateUi();
	}, pop:function () {
		if (this.stack.length) {
			this.stack.pop().undo();
		}
		this.updateUi();
	}, clear:function () {
		this.stack = [];
		this.updateUi();
	}, canUndo:function () {
		return Boolean(this.stack.length);
	}, updateUi:function () {
		var task = this.stack[this.stack.length - 1];
		studio.undoBtn.setDisabled(!task);
		if (task) {
			studio.undoBtn.setHint("Undo " + task.hint);
		}
	}};
	dojo.declare("wm.ComponentTaskMixin", null, {component:null, componentRootId:"", getComponent:function () {
		if (this.component) {
			var o;
			if (this.component.owner == studio.application || this.component.owner.app == studio.application) {
				o = studio.application;
			} else {
				o = app;
			}
			return o.getValueById(this.componentRootId + this.component.getId());
		}
	}, setComponent:function (inComponent) {
		this.component = inComponent;
		this.componentRootId = inComponent.getRootId();
	}, clearComponent:function () {
		this.component = null;
	}});
	dojo.declare("wm.DeleteTask", wm.ComponentTaskMixin, {hint:"Delete Component", constructor:function () {
		var c = studio.selected;
		if (!c) {
			return;
		}
		this.setComponent(c);
		this.hint = "Delete " + c.declaredClass.split(".").pop();
		this.clip = c.serialize({styles:true});
		this.classType = c.declaredClass;
		this.owner = c.owner;
		this.isWidget = c instanceof wm.Widget;
		this.parent = c.parent;
		this.redo();
	}, cachePlacement:function () {
		var c = this.getComponent();
		this.originalTarget = c.parent;
		this.originalRect = dojo.marginBox(c.domNode);
		if (this.originalTarget) {
			this.originalSibling = this.originalTarget.container && this.originalTarget.nextSibling(c);
		}
	}, restorePlacement:function () {
		studio.designer.replace(this.getComponent(), this.originalTarget, this.originalRect, this.originalSibling);
	}, redo:function () {
		if (this.isWidget) {
			this.cachePlacement();
		}
		if (studio._deleteControl(this.getComponent())) {
			this.clearComponent();
			wm.undo.push(this);
		}
	}, undo:function () {
		var p = this.isWidget ? (this.parent.owner ? this.parent : null) : this.owner;
		var c = studio._pasteControl(p, this.clip, this.classType);
		this.setComponent(c);
		if (this.isWidget) {
			this.restorePlacement();
		}
	}});
	dojo.declare("wm.DropTask", wm.ComponentTaskMixin, {hint:"Drop Component", constructor:function (inComponent) {
		this.setComponent(inComponent);
		this.hint = "Drop " + inComponent.declaredClass.split(".").pop();
		this.bounds = dojo.marginBox(inComponent.domNode);
		var t = inComponent.parent;
		this.targetId = inComponent.parent.getRuntimeId();
		var sib = t.nextSibling(inComponent);
		this.siblingId = sib && sib.getRuntimeId();
		wm.undo.push(this);
	}, undo:function () {
		studio.select(null);
		var t = app.getValueById(this.targetId);
		var sib = app.getValueById(this.siblingId);
		var c = this.getComponent();
		studio.designer.replace(c, t, this.bounds, sib);
		studio.refreshDesignTrees();
		studio.select(this.getComponent());
	}});
	dojo.declare("wm.AddTask", wm.ComponentTaskMixin, {hint:"Add Component", constructor:function (inComponent) {
		this.setComponent(inComponent);
		this.hint = "Add " + inComponent.declaredClass.split(".").pop();
		wm.undo.push(this);
	}, undo:function () {
		studio._deleteControl(this.getComponent());
	}});
}
if (!dojo._hasResource["wm.studio.app.clipboard"]) {
	dojo._hasResource["wm.studio.app.clipboard"] = true;
	dojo.provide("wm.studio.app.clipboard");
	Studio.extend({copyControl:function (inControl) {
		var c = inControl || this.designer.selected;
		if (!c) {
			return;
		}
		this.clipboard = c.serialize({styles:true});
		this.clipboardClass = c.declaredClass;
		this.updateCutPasteUi();
	}, cutControl:function (inControl) {
		var c = inControl || this.designer.selected;
		if (!c) {
			return;
		}
		this.copyControl(c);
		this._deleteControl(c);
	}, pasteControl:function (inParent) {
		if (this.clipboard) {
			this._pasteControl(inParent, this.clipboard, this.clipboardClass);
		}
	}, _pasteControl:function (inParent, inClip, inClass) {
		this.renamedDuringPaste = {};
		var isLayer = (inClass == "wm.Layer"), p = inParent || this.findContainer(this.selected, inClass) || studio.page.root.findContainer(inClass);
		rp = wm.getClassProp(inClass, "_requiredParent");
		if (!p) {
			alert("Unable to paste.  All containers are either locked or frozen.");
			return;
		}
		if (isLayer && rp && !(p instanceof dojo.getObject(rp))) {
			wm.logging && console.debug("Must paste a layer into a layers.");
			return;
		}
		wm.pasting = true;
		var comps = p.readComponents(inClip);
		this.refreshDesignTrees();
		this.page.reflow();
		var comp = comps.length && comps.pop();
		this.select(comp);
		this.updateEventsForRenamedComponents();
		this.renamedDuringPaste = {};
		wm.pasting = false;
		return comp;
	}, updateEventsForRenamedComponents:function () {
		var renamed = this.renamedDuringPaste;
		for (var i in renamed) {
			var comp = renamed[i];
			for (var event in comp.eventBindings) {
				var isFunction = !Boolean(comp.owner.getValue(event));
				var isFunctionForOldCopy = comp.eventBindings[event] == i + wm.capitalize(event.replace(/^on/, ""));
				if (isFunction && isFunctionForOldCopy) {
					var oldname = comp.eventBindings[event];
					var newname = oldname.replace(new RegExp("^" + i), comp.name);
					eventCopy(wm.isInstanceType(comp.owner, wm.Application) ? studio.appsourceEditor : studio.editArea, oldname, newname);
					comp.eventBindings[event] = newname;
				}
			}
		}
	}, deleteControl:function () {
		new wm.DeleteTask();
	}, _deleteControl:function (inControl) {
		var c = inControl, p = c.parent, o = c.owner;
		if (!c.deletionDisabled && (o == this.application || o == this.page) && c != this.page.root && !(c.isParentFrozen && c.isParentFrozen()) || (o == null)) {
			this.page.removeComponent(c);
			this.inspector.inspected = null;
			c.destroy();
			wm.fire(p, "reflow");
			this.select(p || studio.page.root);
			this.removeComponentFromTree(c);
			return true;
		} else {
			console.debug("cannot delete subcomponent");
		}
	}});
}
if (!dojo._hasResource["wm.studio.app.trees"]) {
	dojo._hasResource["wm.studio.app.trees"] = true;
	dojo.provide("wm.studio.app.trees");
	Studio.extend({clearTrees:function () {
		this.tree.clear();
		this.widgetsTree.clear();
	}, refreshDesignTrees:function () {
		this.refreshWidgetsTree();
		this.selectInTree(this.selected);
	}, refreshWidgetsTree:function () {
		this.tree.clear();
		this.widgetsTree.clear();
		if (this.application) {
			this.appComponentsToTree(this.tree);
		}
		if (this.page) {
			this.pageComponentsToTree(this.tree);
			this.widgetToTree(this.widgetsTree.root, this.page.root);
		}
	}, getTreeComponents:function (inComponents, inExcludeTypes, inIncludeTypes) {
		var list = {}, c;
		for (var i in inComponents) {
			c = inComponents[i];
			if (inExcludeTypes) {
				if (!(this._instanceOf(c, inExcludeTypes))) {
					list[i] = c;
				}
			} else {
				if (inIncludeTypes) {
					if ((this._instanceOf(c, inIncludeTypes))) {
						list[i] = c;
					}
				} else {
					list[i] = c;
				}
			}
		}
		return list;
	}, _instanceOf:function (t, types) {
		var ret = false;
		for (var i = 0; i < types.length; i++) {
			var m = types[i];
			if (t instanceof m) {
				ret = true;
				break;
			}
		}
		return ret;
	}, systemComponentsToTree:function (inTree) {
		var n = this.newTreeNode(inTree.root, "images/wm/pane.png", "System Components");
		n.owner = this.page;
		this.componentsToTree(n, this.getTreeComponents(this.page.components));
	}, pageComponentsToTree:function (inTree) {
		var n = this.newTreeNode(inTree.root, "images/wm/pane.png", "Page (" + this.page.declaredClass + ")");
		n.owner = this.page;
		n.component = this.page;
		this.page._studioTreeNode = n;
		this.componentsToTree(n, this.getTreeComponents(this.page.components, [wm.Control]));
		this.componentsToTree(n, this.getTreeComponents(this.page.components, null, [wm.Dialog]));
	}, appComponentsToTree:function (inTree) {
		var n = this.newTreeNode(inTree.root, "images/project_16t.png", "Project (" + studio.project.projectName + ")");
		n.component = n.owner = this.application;
		this.application._studioTreeNode = n;
		this.excTypes = [wm.Query, wm.LiveView];
		if (this.application) {
			this.svrComps = this.application.getServerComponents();
			this.otherComps = this.application.components;
			this.componentsToTree(n, this.getTreeComponents(this.svrComps, this.excTypes));
			this.componentsToTree(n, this.getTreeComponents(this.otherComps, this.excTypes));
		}
	}, addQryAndViewToTree:function (inNode) {
		this.componentsToTree_rev(inNode, this.svrComps, this.excTypes);
		this.componentsToTree_rev(inNode, this.otherComps, this.excTypes);
	}, newTreeNode:function (inParent, inImage, inName, inClosed, inProps) {
		inProps = dojo.mixin(inProps || {}, {image:inImage, content:inName, closed:inClosed});
		return new wm.TreeNode(inParent, inProps);
	}, getClassNameImage:function (inClassName) {
		var i = wm.Palette.items[inClassName] || 0;
		return i.image;
	}, getComponentImage:function (inComponent) {
		var ci = this.getClassNameImage(inComponent.publishClass);
		return ci || inComponent.image || ("images/wm/" + (inComponent instanceof wm.Widget ? "widget" : "component") + ".png");
	}, newComponentNode:function (inParent, inComponent, inName, inImage, inProps) {
		var o = inComponent && inComponent._studioTreeNode, closed = o ? o.closed : (inProps && inProps.closed), img = inImage || this.getComponentImage(inComponent), name = inName || inComponent._treeNodeName || inComponent.name, n = this.newTreeNode(inParent, img, name, closed, inProps);
		if (inComponent) {
			n.component = inComponent;
			inComponent._studioTreeNode = n;
		}
		return n;
	}, widgetToTree:function (inNode, inWidget) {
		if (inWidget) {
			if (inWidget.flags.notInspectable || inWidget.isParentLocked() || inWidget instanceof wm.Dialog) {
				return;
			}
			var n = this.newComponentNode(inNode, inWidget);
			this.subWidgetsToTree(n, inWidget);
		}
	}, subWidgetsToTree:function (inNode, inWidget) {
		this.widgetsToTree(inNode, (inWidget instanceof wm.Control) ? inWidget.getOrderedWidgets() : []);
		var c = inWidget.collection;
		if (c && !inWidget.flags.notInspectable) {
			this.collectionToTree(inNode, inWidget.getCollection(c));
		}
	}, widgetsToTree:function (inNode, inWidgets) {
		dojo.forEach(inWidgets, dojo.hitch(this, function (w) {
			this.widgetToTree(inNode, w);
		}));
	}, componentToTree:function (inNode, inComponent, inType) {
		if (inComponent && !inComponent.flags.notInspectable && (!inType || inComponent instanceof inType)) {
			var props = {};
			props.closed = inComponent instanceof wm.Dialog || inComponent instanceof wm.Control == false;
			inNode = wm.fire(inComponent, "preNewComponentNode", [inNode, props]) || inNode;
			var n = this.newComponentNode(inNode, inComponent, null, null, props);
			if (inComponent instanceof wm.TypeDefinition || inComponent instanceof wm.DesignableDialog) {
				this.subWidgetsToTree(n, inComponent);
			}
		}
	}, collectionToTree:function (inNode, inCollection, inType) {
		for (var i = 0; (c = inCollection[i]); i++) {
			this.componentToTree(inNode, c, inType);
		}
	}, componentsToTree:function (inNode, inComponents, inType) {
		var n = [], cn;
		for (cn in inComponents) {
			n.push(cn);
		}
		n.sort();
		for (var i = 0; (cn = n[i]); i++) {
			this.componentToTree(inNode, inComponents[cn], inType);
		}
	}, componentsToTree_rev:function (inNode, inComponents, inTypes, inType) {
		var n = [], cn;
		for (cn in inComponents) {
			n.push(cn);
		}
		n.sort();
		for (var i = 0; (cn = n[i]); i++) {
			var comp = inComponents[cn];
			if (this._instanceOf(comp, inTypes)) {
				var key;
				if (comp instanceof wm.Query) {
					key = comp.dataModelName;
				} else {
					if (comp instanceof wm.LiveView) {
						key = comp.service;
					}
				}
				if (key == inNode.content) {
					this.componentToTree(inNode, comp, inType);
				}
			}
		}
	}, addComponentToTree:function (inComponent, inType) {
		this.refreshDesignTrees();
	}, removeComponentFromTree:function (inComponent) {
		this.tree.domNode.scrollTop = 0;
		this.refreshDesignTrees();
	}, renameComponentOnTree:function (inOld, inNew, inComponent) {
		var n = inComponent._studioTreeNode;
		if (n) {
			n.setContent(inNew);
		}
	}, selectInTree:function (inComponent) {
		if (inComponent) {
			var n = inComponent._studioTreeNode;
			if (n) {
				n.tree.select(n);
				var p = n.parent;
				while ((p != this.page.root) && !(p instanceof wm.Layer)) {
					p = p.parent;
				}
				if (p) {
					p.show();
				}
			}
		}
	}, refreshComponentOnTree:function (inComponent) {
		var n = inComponent._studioTreeNode;
		if (n) {
			n.removeChildren();
			this.subWidgetsToTree(n, inComponent);
		}
	}, treeNodeSelect:function (inNode) {
		var c = inNode.component;
		this.select(c);
		if (c) {
			if (c.designSelect) {
				return c.designSelect();
			}
			this.navGotoDesignerClick();
		}
		if (!c) {
			var c = inNode.content;
			switch (c) {
			  case "Designer":
				this.navGotoDesignerClick();
				break;
			  case "Source":
				this.navGotoSourceClick();
				break;
			}
		}
	}});
}
if (!dojo._hasResource["wm.studio.app.menu"]) {
	dojo._hasResource["wm.studio.app.menu"] = true;
	dojo.provide("wm.studio.app.menu");
	Studio.extend({addComponentMenuItem:function (inTab, inName, inDescription, inImage, inClass, inProps) {
		try {
			var menu = (inTab == bundleStudio.M_Services) ? this.servicesPopupBtn : this.insertPopupBtn;
			var menuBar = this.navigationMenu;
			var newId = inName + "MenuItem";
			if (!this[newId]) {
				menuBar.addNewMenuItem(menu, {label:inName, info:{type:inClass, props:inProps}, type:inClass, onClick:"selectComponentMenuItem", idInPage:inName + "MenuItem", iconClass:inImage.substring(inImage.lastIndexOf("/") + 1, inImage.indexOf("."))});
			}
		}
		catch (e) {
			console.error("disableMenuBar Failed");
			console.log(e);
		}
	}, selectComponentMenuItem:function (menuObj, info) {
		var props = dojo.clone(info.info.props || {});
		var ctor = dojo.getObject(info.type);
		dojo.mixin(props, {_designer:studio.page._designer, name:studio.page.getUniqueName(props.name || studio.makeName(info.type)), owner:studio.page, parent:studio.page.root});
		var comp = new ctor(props);
		if (comp) {
			if (!(comp instanceof wm.ServerComponent)) {
				new wm.AddTask(comp);
			}
			if (!wm.fire(comp, "afterPaletteDrop")) {
				studio.refreshDesignTrees();
				studio.inspector.resetInspector();
				studio.select(comp);
			}
		}
	}, disableMenuBar:function (inDisabled) {
		try {
			this.projectPopupBtn.attr("disabled", false);
			this.editPopupBtn.attr("disabled", inDisabled);
			this.viewPopupBtn.attr("disabled", inDisabled);
			this.insertPopupBtn.attr("disabled", inDisabled);
			this.servicesPopupBtn.attr("disabled", inDisabled);
			this.pagePopupBtn.attr("disabled", inDisabled);
			this.navTestBtn.setDisabled(inDisabled);
			this.leftToolbarButtons.setDisabled(inDisabled);
			this.navRunBtn.setDisabled(inDisabled);
			if (studio.isCloud()) {
				this.navEditAccountBtn.setDisabled(false);
				this.navLogoutBtn.setDisabled(false);
			}
			this.closeProjectItem.attr("disabled", inDisabled);
			this.copyProjectItem.attr("disabled", inDisabled);
			this.deleteProjectItem.attr("disabled", inDisabled);
			this.exportProjectItem.attr("disabled", inDisabled);
			this.deployProjectItem.attr("disabled", inDisabled);
		}
		catch (e) {
			console.error("disableMenuBar Failed");
			console.log(e);
		}
	}, disableCanvasOnlyMenuItems:function (inDisabled) {
		var d = inDisabled;
		this.editPopupBtn.attr("disabled", d);
		this.insertPopupBtn.attr("disabled", d);
		this.pagePopupBtn.attr("disabled", d);
		this.outlineItem.attr("disabled", d);
	}});
}
if (!dojo._hasResource["wm.studio.app.deploy"]) {
	dojo._hasResource["wm.studio.app.deploy"] = true;
	dojo.provide("wm.studio.app.deploy");
	Studio.extend({deployClick:function (inSender) {
		this.project.saveProject();
		this.navGoToDeploymentPage();
	}, onDeployOkClicked:function (jndiNames, optionalCallback) {
		var msg = "Building WAR file. It may take several minutes. Please wait.";
		studio.beginWait(msg);
		var _this = this;
		studio.deploymentService.requestAsync("buildWar", [jndiNames], function (inResponse) {
			studio.endWait(msg);
			optionalCallback();
		});
	}, deployClickError:function (inError) {
		studio.endWait();
		alert("Error occurred while building WAR File!\n" + inError.message);
	}, refreshLiveData:function () {
		if (!wm.studioConfig.preventLiveData && !this._deploying) {
			this.deploy("", dojo.hitch(this, "isSecurityEnabled"));
		}
	}, makeLiveDataCall:function (inCallback) {
		if (this.isLiveLayoutReady()) {
			return inCallback();
		} else {
			this.refreshLiveData();
			if (this._deploying && this._deployer) {
				var liveDataDeferred = new dojo.Deferred();
				this._deployer.addCallback(function (inResult) {
					var r = inCallback();
					if (r instanceof dojo.Deferred) {
						r.addCallback(function (inResult) {
							if (liveDataDeferred.fired == -1) {
								liveDataDeferred.callback(true);
							}
							return inResult;
						});
					} else {
						if (liveDataDeferred.fired == -1) {
							liveDataDeferred.callback(true);
						}
					}
					return inResult;
				});
				return liveDataDeferred;
			}
		}
	}, isSecurityEnabled:function () {
		return;
	}, isSecurityEnabledResult:function (inResponse) {
		if (inResponse) {
			alert("In order for Live Layout to work, project security needs to be disabled.\n" + "Please uncheck the 'Enable Security' check box in the Security Editor to disable security.\n" + "To disable Live Layout, launch Studio in 'nolive' mode.");
		}
	}, downloadInIFrame:function (url) {
		var iframe = dojo.byId("downloadFrame");
		if (iframe) {
			iframe.parentNode.removeChild(iframe);
		}
		iframe = document.createElement("iframe");
		dojo.attr(iframe, {id:"downloadFrame", name:"downloadFrame"});
		dojo.style(iframe, {top:"1px", left:"1px", width:"1px", height:"1px", visibility:"hidden"});
		dojo.body().appendChild(iframe);
		iframe.src = url;
	}, exportClick:function (inSender) {
		studio.beginWait("ZIPファイルを作成しています...");
		studio.deploymentService.requestAsync("exportProject", null, dojo.hitch(this, "exportClickCallback"), dojo.hitch(this, "exportClickError"));
	}, exportClickCallback:function (inResponse) {
		studio.endWait("ZIPファイルの作成...");
		if (!studio.isCloud()) {
			alert("プロジェクトをZIPファイル「" + inResponse + "」にエクスポートしました。\n\nインポートする場合は、他スタジオのプロジェクトディレクトリに解凍してください。");
		} else {
			this.downloadInIFrame("services/deploymentService.download?method=downloadProjectZip");
		}
	}, exportClickError:function (inError) {
		studio.endWait();
		alert("Error occurred while exporting project!\n" + inError.message);
	}, getImportFileDialog:function () {
		if (!this.importFileDialog) {
			this.importFileDialog = new wm.FileUploadDialog({title:"プロジェクトのインポート", noEscape:false, uploadService:"deploymentService", uploadOperation:"uploadProjectZipFile", owner:studio});
			this.importFileDialog.setUserPrompt("プロジェクトにインポートするzipファイルを選択してください");
			this.importFileDialog.connect(this.importFileDialog, "importClickCallback", this, "importProjectClickCallback");
			this.importFileDialog.connect(this.importFileDialog, "importClickError", this, "importProjectClickError");
		}
		return this.importFileDialog;
	}, importClick:function (inSender) {
		if (this.project.projectName) {
			this.confirmAppChange("プロジェクト「\"${project}\"」を閉じますか？保存されていない変更は失われます。", undefined, dojo.hitch(this, function () {
				this.project.closeProject();
				this.importFileDialog = this.getImportFileDialog().show();
			}));
		} else {
			this.importFileDialog = this.getImportFileDialog().show();
		}
	}, importProjectClickCallback:function (inSource, inResponse) {
		studio.endWait();
		var d = studio.startEditor.page.refreshProjectList();
		app.toastDialog.showToast("プロジェクトをインポートしました " + inResponse, 3000, "Success");
		wm.fire(this.owner, "dismiss");
		studio.project.openProject(inResponse);
	}, importProjectClickError:function (inSource, inError) {
		studio.endWait();
		alert("Error occurred while importing project!\n" + inError);
	}, deployComponent:function (inName, inNamespace, inDisplayName, inGroup, inData) {
		var klass = inNamespace ? inNamespace + "." + inName : inName;
		studio.deploymentService.requestAsync("deployClientComponent", [inName, inNamespace, inData], dojo.hitch(this, "deployComponentCallback", "common.packages." + klass, inDisplayName, inGroup), dojo.hitch(this, "deployComponentError", inName, inNamespace));
	}, deployComponentCallback:function (inModule, inDisplayName, inGroup, inResponse) {
		delete dojo._loadedModules[inModule];
		dojo._loadedUrls = [];
		studio.palette.removeItem(inGroup, inDisplayName);
		dojo["require"](inModule);
		alert("デプロイしました。");
		wm.fire(studio.inspector, "reinspect");
	}, deployComponentError:function (inName, inNamespace, inError) {
		try {
			studio.deploymentService.requestAsync("undeployClientComponent", [inName, inNamespace, true]);
		}
		catch (e) {
			console.debug(e);
		}
		alert("デプロイ中にエラーが発生しました： " + inError);
	}, undeployComponent:function (inName, inNamespace, inDisplayName, inGroup, inRemoveSource) {
		var klass = inNamespace + "." + inName;
		studio.deploymentService.requestAsync("undeployClientComponent", [inName, inNamespace, inRemoveSource], dojo.hitch(this, "undeployComponentCallback", inDisplayName, inGroup), dojo.hitch(this, "undeployComponentError"));
	}, undeployComponentCallback:function (inDisplayName, inGroup, inResponse) {
		if (inResponse == true) {
			studio.palette.removeItem(inGroup, inDisplayName);
			wm.fire(studio.inspector, "reinspect");
			alert("Undeployment successful.");
		} else {
			alert("Component not found.");
		}
	}, undeployComponentError:function (inError) {
		alert("Undeployment error: " + inError);
	}});
}
if (!dojo._hasResource["wm.studio.app.dom"]) {
	dojo._hasResource["wm.studio.app.dom"] = true;
	dojo.provide("wm.studio.app.dom");
	wm.createDocument = function (str, mimetype) {
		var _document = dojo.doc;
		if (!mimetype) {
			mimetype = "text/xml";
		}
		if (str && (typeof dojo.global["DOMParser"]) !== "undefined") {
			var parser = new DOMParser();
			return parser.parseFromString(str, mimetype);
		} else {
			if ((typeof dojo.global["ActiveXObject"]) !== "undefined") {
				var prefixes = ["MSXML2", "Microsoft", "MSXML", "MSXML3"];
				for (var i = 0; i < prefixes.length; i++) {
					try {
						var doc = new ActiveXObject(prefixes[i] + ".XMLDOM");
						if (str) {
							if (doc) {
								doc.async = false;
								doc.loadXML(str);
								return doc;
							} else {
								console.log("loadXML didn't work?");
							}
						} else {
							if (doc) {
								return doc;
							}
						}
					}
					catch (e) {
					}
				}
			} else {
				if ((_document.implementation) && (_document.implementation.createDocument)) {
					if (str) {
						if (_document.createElement) {
							var tmp = _document.createElement("xml");
							tmp.innerHTML = str;
							var xmlDoc = _document.implementation.createDocument("foo", "", null);
							for (var i = 0; i < tmp.childNodes.length; i++) {
								xmlDoc.importNode(tmp.childNodes.item(i), true);
							}
							return xmlDoc;
						}
					} else {
						return _document.implementation.createDocument("", "", null);
					}
				}
			}
		}
		return null;
	};
}
if (!dojo._hasResource["wm.studio.app.propertyEdit"]) {
	dojo._hasResource["wm.studio.app.propertyEdit"] = true;
	dojo.provide("wm.studio.app.propertyEdit");
	dojo.declare("wm.SetPropTask", null, {constructor:function (inComponent, inPropName, inOldValue, inNewValue) {
		dojo.mixin(this, {component:inComponent, propName:inPropName, oldValue:inOldValue, newValue:inNewValue});
		this.hint = "change \"" + inPropName + "\"";
		this.redo();
	}, _do:function (inValue) {
		this.component.setProp(this.propName, inValue);
		wm.onidle(studio.inspector, "reinspect");
	}, redo:function () {
		this._do(this.newValue);
		wm.undo.push(this);
	}, undo:function () {
		this._do(this.oldValue);
	}});
	dojo.declare("wm.propEdit.Base", null, {constructor:function (inProps) {
		dojo.mixin(this, inProps);
		if (!("value" in inProps)) {
			this.value = this._getPropValue();
		}
		if (!("defaultValue" in inProps)) {
			this.defaultValue = this._getPropDefaultValue();
		}
	}, applyProp:function (t) {
		if (t && t.name && ("value" in t)) {
			var v = t.type == "checkbox" ? t.checked : t.value;
			this._setPropValue(v);
		}
	}, _getPropValue:function () {
		var v = this.component.getProp(this.name);
		return dojo.isFunction(v) ? ["(", this.name, ")"].join("") : v;
	}, _getPropDefaultValue:function () {
		return this.component.constructor.prototype[this.name];
	}, _setPropValue:function (inValue) {
		new wm.SetPropTask(this.component, this.name, this.value, inValue);
	}});
	dojo.declare("wm.propEdit.Select", wm.propEdit.Base, {constructor:function (inProps) {
		this.init();
	}, init:function () {
		this.options = this.options || this.getOptions();
		this.values = this.values || this.getValues() || this.options;
	}, getValues:function () {
	}, getOptions:function () {
	}, getHtml:function () {
		return makeSelectPropEdit(this.name, this.value, this.options, this.defaultValue, this.values);
	}});
	dojo.declare("wm.propEdit.UnitValue", wm.propEdit.Select, {lexer:/([\d]+)(.*)/, init:function () {
		this.values = this.values || this.options;
	}, lex:function (inValue) {
		var parts = (inValue || "").match(this.lexer);
		return {value:parts && parts[1] || 0, units:parts && parts[2]};
	}, getHtml:function () {
		var value = wm.splitUnits(this.value);
		var defaultValue = wm.splitUnits(this.defaultValue);
		var html = ["<table class=\"wminspector-property\" width=\"100%\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tr><td style=\"border: 0 none;\">", makeInputPropEdit(this.name, value.value, defaultValue.value), "</td><td style=\"width: 1px; border-left: 1px solid gray\">&nbsp;</td><td width=\"44\">", makeSelectPropEdit(this.name, value.units, this.options, "", this.values), "</td></tr>", "</table>"];
		return html.join("");
	}, applyProp:function (t) {
		var row = t.parentNode.parentNode;
		var edit = row.cells[0].firstChild;
		var select = row.cells[2].firstChild;
		var su = this.lex(edit.value);
		this.inspector._setInspectedProp(this.name, su.value + (su.units || select.value));
	}});
	dojo.declare("wm.propEdit.PagesSelect", wm.propEdit.Select, {getOptions:function () {
		var pagelist = wm.getPageList(this.currentPageOK);
		if (this.newPage) {
			pagelist.push("-New Page");
		}
		return pagelist;
	}});
	wm.getPageList = function (currentPageOK) {
		var pages = [""].concat(studio.project.getPageList()), current = studio.page.declaredClass;
		if (!currentPageOK) {
			return dojo.filter(pages, function (p) {
				return (p != current);
			});
		} else {
			return pages;
		}
	};
	dojo.declare("wm.propEdit.ImageListSelect", wm.propEdit.Select, {getOptions:function () {
		return [""].concat(studio.getImageLists());
	}});
	dojo.declare("wm.propEdit.WidgetsSelect", wm.propEdit.Select, {setWidgetType:function (inWidgetType) {
		this.widgetType = inWidgetType;
	}, getOptions:function () {
		var layers = wm.listOfWidgetType(this.widgetType, true), options = [];
		for (var i = 0, l; l = layers[i]; i++) {
			options.push(l.name);
		}
		return [""].concat(options);
	}});
	dojo.declare("wm.propEdit.FieldSelect", wm.propEdit.Select, {getSchemaOptions:function (inSchema) {
		return [""].concat(wm.typeManager[this.relatedFields ? "getStructuredPropNames" : "getSimplePropNames"](inSchema));
	}, getOptions:function () {
		return this.getSchemaOptions(wm.typeManager.getTypeSchema(this.fromType));
	}});
	dojo.declare("wm.propEdit.FormFieldSelect", wm.propEdit.FieldSelect, {getOptions:function () {
		var f = wm.getParentForm(this.component), ds = f && f.dataSet;
		return ds && ds.type ? this.getSchemaOptions(ds._dataSchema) : [""];
	}});
	dojo.declare("wm.propEdit.DataFieldSelect", wm.propEdit.Select, {getOptions:function () {
		var ds = this.dataSource, r = [""];
		return ds && ds.type ? this.getSchemaOptions(ds._dataSchema) : [""];
	}});
	dojo.declare("wm.propEdit.DataTypesSelect", wm.propEdit.Select, {options:[""], values:[""], init:function () {
		this.inherited(arguments);
		this.addOptionValues(this.getDataTypes(), true);
	}, addOptionValues:function (inOptionValues, inSort) {
		if (inSort) {
			inOptionValues.sort(function (a, b) {
				return wm.data.compare(a.option, b.option);
			});
		}
		this.options = (this.options || []).concat(dojo.map(inOptionValues, function (d) {
			return d.option;
		}));
		this.values = (this.values || []).concat(dojo.map(inOptionValues, function (d) {
			return d.value;
		}));
	}, getDataTypes:function () {
		var types = this.liveTypes ? wm.typeManager.getLiveServiceTypes() : wm.typeManager.getPublicTypes(), dt = [];
		for (var i in types) {
			dt.push({option:wm.getFriendlyTypeName(i), value:i});
		}
		return dt;
	}});
	dojo.declare("wm.propEdit.AllDataTypesSelect", wm.propEdit.DataTypesSelect, {addOptionValues:function (inOptionValues, inSort) {
		if (inSort) {
			inOptionValues.sort(function (a, b) {
				if (a.option.match(/Literal$/) && b.option.match(/Literal$/)) {
					return wm.data.compare(a.option, b.option);
				} else {
					if (a.option.match(/Literal$/)) {
						return -1;
					} else {
						if (b.option.match(/Literal$/)) {
							return -1;
						} else {
							return wm.data.compare(a.option, b.option);
						}
					}
				}
			});
		}
		this.options = (this.options || []).concat(dojo.map(inOptionValues, function (d) {
			return d.option;
		}));
		this.values = (this.values || []).concat(dojo.map(inOptionValues, function (d) {
			return d.value;
		}));
	}, getDataTypes:function () {
		var list = this.inherited(arguments);
		var extras = [{option:"String Literal", value:"String"}, {option:"Number Literal", value:"Number"}, {option:"Boolean Literal", value:"Boolean"}, {option:"Date Literal", value:"Date"}];
		return extras.concat(list);
	}});
	dojo.declare("wm.propEdit.LiveSourcesSelect", wm.propEdit.DataTypesSelect, {liveTypes:true, init:function () {
		this.addOptionValues(this.getLiveViews(), true);
		this.inherited(arguments);
	}, getLiveViews:function () {
		var views = wm.listComponents([studio.application], wm.LiveView), lv = [];
		wm.forEach(views, dojo.hitch(this, function (v) {
			var dt = v.dataType || "", k = dt ? " (" + dt.split(".").pop() + ")" : "";
			lv.push({option:v.name + k, value:v.getId()});
		}));
		return lv;
	}});
	dojo.declare("wm.propEdit.DataSetSelect", wm.propEdit.Select, {getOptions:function () {
		var sp = studio.page, r = this.getDataSets([sp, sp.app]);
		if (this.widgetDataSets) {
			wm.forEachWidget(sp.root, dojo.hitch(this, function (w) {
				if (w !== this && !(w instanceof wm.LiveFormBase) && !(w instanceof wm.Editor && w.formField)) {
					r = r.concat(this.getDataSets([w]));
				}
			}));
		}
		return [""].concat(r.sort());
	}, getDataSets:function (inOwners) {
		var all = this.allowAllTypes, list = this.listMatch;
		return wm.listMatchingComponentIds(inOwners, function (c) {
			return (c instanceof wm.Variable && (all || wm.typeManager.isStructuredType(c.type)) && (list !== undefined ? list == wm.fire(c, "isListBindable") : true));
		});
	}});
}
if (!dojo._hasResource["wm.studio.app.data"]) {
	dojo._hasResource["wm.studio.app.data"] = true;
	dojo.provide("wm.studio.app.data");
	wm.dataSources = {update:function () {
		this.clearSources();
		this.typesToSources();
		this.sortSources();
	}, clearSources:function () {
		this.sources = {};
	}, typesToSources:function () {
		var sources = this.sources, source, ii, caption, s;
		for (var i in wm.typeManager.getPublicTypes()) {
			source = wm.typeManager.getLiveService(i);
			if (!source) {
				continue;
			}
			ii = i.split(".");
			caption = ii.pop();
			ii.pop();
			s = sources[source];
			if (!s) {
				sources[source] = s = [];
			}
			s.push({type:i, caption:caption});
		}
	}, sortSources:function () {
		var ss = this.sources;
		for (var i in ss) {
			if (i in Object.prototype) {
				continue;
			}
			ss[i].sort(function (a, b) {
				return a.caption < b.caption ? -1 : a.caption == b.caption ? 0 : 1;
			});
		}
	}};
}
if (!dojo._hasResource["wm.studio.app.templates.widgetTemplates"]) {
	dojo._hasResource["wm.studio.app.templates.widgetTemplates"] = true;
	dojo.provide("wm.studio.app.templates.widgetTemplates");
	if (!wm.widgetTemplates) {
		wm.widgetTemplates = {};
	}
	if (!wm.fullTemplates) {
		wm.fullTemplates = {};
	}
	if (!wm.widgetSpecificTemplate) {
		wm.widgetSpecificTemplate = {};
	}
	wm.widgetTemplates.twoColumn = {layoutKind:"top-to-bottom", width:"100%", height:"100%", _template:{toolbarPanel:["wm.Panel", {horizontalAlign:"left", verticalAlign:"top", _classes:{domNode:["toolbar"]}, border:"0,0,2,0", layoutKind:"left-to-right", height:"36px", width:"100%"}, {}, {button1:["wm.Button", {width:"80px", height:"100%"}, {}], button2:["wm.Button", {width:"80px", height:"100%"}, {}], button3:["wm.Button", {width:"80px", height:"100%"}, {}]}], panel1:["wm.Panel", {horizontalAlign:"left", verticalAlign:"top", layoutKind:"left-to-right", width:"100%", height:"100%"}, {}, {leftSideBarTOC:["wm.Panel", {horizontalAlign:"left", verticalAlign:"top", _classes:{domNode:["TOC"]}, layoutKind:"top-to-bottom", width:"246px", height:"100%"}, {}], splitter1:["wm.Splitter", {layout:"left"}, {}], mainContent:["wm.Panel", {horizontalAlign:"left", verticalAlign:"top", isMajorContent:true, layoutKind:"top-to-bottom", width:"100%", height:"100%"}, {}]}]}};
	wm.fullTemplates.fancyTemplate = {displayName:bundlePackage.FancyTemplate, thumbnail:"/wavemaker/app/templates/widgetTemplateImages/fancyTemplate.png", layoutKind:"top-to-bottom", width:"100%", height:"100%", verticalAlign:"top", horizontalAlign:"center", _template:{varTemplateUsername:["wm.ServiceVariable", {"autoUpdate":true, "designTime":true, "operation":"getUserName", "service":"securityService", "startUpdate":true}, {}, {input:["wm.ServiceInput", {"type":"getUserNameInputs"}, {}]}], varTemplateLogout:["wm.LogoutVariable", {}, {}, {input:["wm.ServiceInput", {"type":"logoutInputs"}, {}]}], panel1:["wm.Panel", {"border":"0,0", "borderColor":"#999999", "height":"100%", "horizontalAlign":"left", "verticalAlign":"top", "width":"80%"}, {}, {panel2:["wm.HeaderContentPanel", {"height":"60px", "horizontalAlign":"left", "layoutKind":"left-to-right", "padding":"0,10", "verticalAlign":"middle", "width":"100%"}, {}, {picture1:["wm.Picture", {"border":"0", "height":"50px", "source":"/wavemaker/lib/wm/base/widget/themes/default/images/wmLogo.png", "width":"62px"}, {}], label1:["wm.Label", {"border":"0", "caption":"Quisque Molestie Porta", "width":"100%"}, {}, {format:["wm.DataFormatter", {}, {}]}], panel10:["wm.Panel", {"height":"100%", "horizontalAlign":"left", "verticalAlign":"middle", "width":"300px"}, {}, {panel14:["wm.Panel", {"height":"24px", "horizontalAlign":"left", "layoutKind":"left-to-right", "verticalAlign":"middle", "width":"100%"}, {}, {label4:["wm.Label", {"_classes":{"domNode":["wm_FontSizePx_10px"]}, "autoSizeWidth":true, "border":"0", "caption":"Welcome, ", "height":"20px", "width":"67px"}, {}, {binding:["wm.Binding", {}, {}, {wire:["wm.Wire", {"expression":"\"Welcome, \" + ${varTemplateUsername.dataValue}", "targetProperty":"caption"}, {}]}], format:["wm.DataFormatter", {}, {}]}], button2:["wm.Button", {"_classes":{"domNode":["wm_FontSizePx_10px"]}, "caption":"Log Out", "height":"28px"}, {"onclick":"varTemplateLogout"}]}], panel15:["wm.Panel", {"height":"24px", "horizontalAlign":"left", "layoutKind":"left-to-right", "verticalAlign":"middle", "width":"100%"}, {}, {text1:["wm.Text", {"displayValue":"Search", "width":"100%"}, {}], picture5:["wm.Picture", {"border":"0", "height":"16px", "source":"/wavemaker/images/silkIcons/zoom.png", "width":"16px"}, {}]}]}]}], panel3:["wm.Panel", {"height":"32px", "horizontalAlign":"left", "layoutKind":"left-to-right", "verticalAlign":"top", "width":"100%"}, {}, {dojoMenu1:["wm.DojoMenu", {"_classes":{"domNode":["ClickableDojoMenu"]}, "eventList":[{"label":"File", "children":[{"label":"New"}, {"label":"Open"}, {"label":"Save"}, {"label":"Close"}]}, {"label":"New"}, {"label":"Open"}, {"label":"Save"}, {"label":"Close"}, {"label":"Edit", "children":[{"label":"Cut"}, {"label":"Copy"}, {"label":"Paste"}]}, {"label":"Cut"}, {"label":"Copy"}, {"label":"Paste"}, {"label":"Zoom", "children":[{"label":"25%"}, {"label":"50%"}, {"label":"100%"}, {"label":"150%"}]}, {"label":"25%"}, {"label":"50%"}, {"label":"100%"}, {"label":"150%"}, {"label":"Help"}], "height":"100%", "menu":"File > New, Open, Save, Close\nEdit > Cut, Copy, Paste\nZoom > 25%, 50%, 100%, 150%\nHelp", "padding":"4,10,0,10", "structure":"{\"items\":[{\"label\":\"File\",\"children\":[{\"label\":\"New\"},{\"label\":\"Open\"},{\"label\":\"Save\"},{\"label\":\"Close\"}]},{\"label\":\"Edit\",\"children\":[{\"label\":\"Cut\"},{\"label\":\"Copy\"},{\"label\":\"Paste\"}]},{\"label\":\"Zoom\",\"children\":[{\"label\":\"25%\"},{\"label\":\"50%\"},{\"label\":\"100%\"},{\"label\":\"150%\"}]},{\"label\":\"Help\"}]}", "transparent":false}, {}]}], panel4:["wm.MainContentPanel", {"height":"100%", "horizontalAlign":"left", "layoutKind":"left-to-right", "verticalAlign":"top", "width":"100%"}, {}, {tabLayers1:["wm.TabLayers", {}, {}, {layer1:["wm.Layer", {"border":"1", "borderColor":"#999999", "caption":"layer1", "horizontalAlign":"left", "verticalAlign":"top"}, {}, {fancyPanel1:["wm.FancyPanel", {"horizontalAlign":"left", "verticalAlign":"top"}, {}, {dojoGrid1:["wm.DojoGrid", {"dsType":"EntryData", "height":"100%", "columns":[{"show":true, "id":"name", "title":"名前", "width":"auto", "displayType":undefined, "noDelete":true, "align":"left"}, {"show":true, "id":"dataValue", "title":"値", "width":"auto", "displayType":undefined, "noDelete":true, "align":"left"}]}, {}, {binding:["wm.Binding", {}, {}, {wire:["wm.Wire", {"source":"studio.varTemplateData", "targetProperty":"dataSet"}, {}]}]}], panel7:["wm.Panel", {"height":"36px", "horizontalAlign":"right", "layoutKind":"left-to-right", "verticalAlign":"top", "width":"100%"}, {}, {button1:["wm.Button", {}, {}], toggleButton2:["wm.ToggleButton", {"clicked":true, "width":"100px"}, {}]}], }], panel6:["wm.Panel", {"height":"320px", "horizontalAlign":"left", "layoutKind":"left-to-right", "verticalAlign":"top", "width":"100%"}, {}, {fancyPanel3:["wm.FancyPanel", {"horizontalAlign":"left", "verticalAlign":"top"}, {}, {panel12:["wm.Panel", {"height":"100%", "horizontalAlign":"left", "verticalAlign":"top", "width":"100%"}, {}, {text3:["wm.Text", {"caption":"text3", "displayValue":""}, {}], checkbox1:["wm.Checkbox", {"caption":"checkbox1", "displayValue":""}, {}], currency1:["wm.Currency", {"caption":"currency1", "displayValue":""}, {}], date1:["wm.Date", {"caption":"date1", "displayValue":""}, {}], number1:["wm.Number", {"caption":"number1", "displayValue":""}, {}], radioButton1:["wm.RadioButton", {"caption":"radioButton1", "displayValue":""}, {}], slider1:["wm.Slider", {"caption":"slider1", "displayValue":""}, {}], richText1:["wm.RichText", {"height":"100%"}, {}]}], }], panel11:["wm.EmphasizedContentPanel", {"height":"100%", "horizontalAlign":"left", "padding":"10", "verticalAlign":"top", "width":"300px"}, {}, {panel8:["wm.Panel", {"height":"32px", "horizontalAlign":"left", "layoutKind":"left-to-right", "verticalAlign":"top", "width":"100%"}, {}, {text2:["wm.Text", {"displayValue":"Curabitur quis nibh", "width":"100%"}, {}]}], fancyPanel2:["wm.FancyPanel", {"height":"230px", "horizontalAlign":"left", "margin":"3", "title":"Calendar", "verticalAlign":"top"}, {}, {calendar1:["wm.dijit.Calendar", {"height":"100%", "width":"100%"}, {}], }], panel9:["wm.Panel", {"height":"36px", "horizontalAlign":"right", "layoutKind":"left-to-right", "verticalAlign":"top", "width":"100%"}, {}, {button4:["wm.Button", {}, {}], toggleButton1:["wm.ToggleButton", {"clicked":true, "width":"100px"}, {}]}]}]}]}], layer2:["wm.Layer", {"border":"1", "borderColor":"#999999", "caption":"layer2", "horizontalAlign":"left", "verticalAlign":"top"}, {}]}]}], panel5:["wm.Panel", {"height":"24px", "horizontalAlign":"left", "layoutKind":"left-to-right", "verticalAlign":"middle", "width":"100%"}, {}, {picture2:["wm.Picture", {"border":"0", "height":"20px", "source":"/wavemaker/lib/wm/base/widget/themes/default/images/wmSmallLogo.png", "width":"25px"}, {}], label2:["wm.Label", {"border":"0", "caption":"Powered By Wavemaker", "height":"100%", "width":"100%"}, {}, {format:["wm.DataFormatter", {}, {}]}], label3:["wm.Label", {"align":"right", "border":"0", "caption":"Copyright \ufffd [company name] 2010", "height":"100%", "width":"300px"}, {}, {format:["wm.DataFormatter", {}, {}]}]}]}]}};
	wm.fullTemplates.sideMenuTemplate = {displayName:bundlePackage.SideMenu, thumbnail:"/wavemaker/app/templates/widgetTemplateImages/sideMenuTemplate.png", layoutKind:"left-to-right", width:"100%", height:"100%", verticalAlign:"top", horizontalAlign:"left", _template:{varTemplateUsername:["wm.ServiceVariable", {"autoUpdate":true, "designTime":true, "operation":"getUserName", "service":"securityService", "startUpdate":true}, {}, {input:["wm.ServiceInput", {"type":"getUserNameInputs"}, {}]}], varTemplateLogout:["wm.LogoutVariable", {}, {}, {input:["wm.ServiceInput", {"type":"logoutInputs"}, {}]}], panel1:["wm.Panel", {"border":"0,1,0,0", "borderColor":"#999999", "height":"100%", "horizontalAlign":"left", "verticalAlign":"top", "width":"75%"}, {}, {panel2:["wm.HeaderContentPanel", {"border":"0,0,1,0", "height":"65px", "horizontalAlign":"left", "layoutKind":"left-to-right", "margin":"0", "padding":"0,10,0,10", "verticalAlign":"middle", "width":"100%"}, {}, {picture1:["wm.Picture", {"border":"0", "height":"50px", "source":"/wavemaker/lib/wm/base/widget/themes/default/images/wmLogo.png", "width":"62px"}, {}], label3:["wm.Label", {"border":"0", "caption":"Quisque Molestie Porta", "width":"100%"}, {}, {format:["wm.DataFormatter", {}, {}]}], panel10:["wm.Panel", {"height":"100%", "horizontalAlign":"left", "verticalAlign":"middle", "width":"300px"}, {}, {panel14:["wm.Panel", {"height":"24px", "horizontalAlign":"left", "layoutKind":"left-to-right", "verticalAlign":"middle", "width":"100%"}, {}, {label4:["wm.Label", {"_classes":{"domNode":["wm_FontSizePx_10px"]}, "autoSizeWidth":true, "border":"0", "caption":"Welcome, ", "height":"20px", "width":"67px"}, {}, {binding:["wm.Binding", {}, {}, {wire:["wm.Wire", {"expression":"\"Welcome, \" + ${varTemplateUsername.dataValue}", "targetProperty":"caption"}, {}]}], format:["wm.DataFormatter", {}, {}]}], button2:["wm.Button", {"_classes":{"domNode":["wm_FontSizePx_10px"]}, "caption":"Log Out", "height":"28px"}, {"onclick":"varTemplateLogout"}]}], panel15:["wm.Panel", {"height":"24px", "horizontalAlign":"left", "layoutKind":"left-to-right", "verticalAlign":"middle", "width":"100%"}, {}, {text1:["wm.Text", {"displayValue":"Search", "width":"100%"}, {}], picture5:["wm.Picture", {"border":"0", "height":"16px", "source":"/wavemaker/lib/images/silkIcons/zoom.png", "width":"16px"}, {}]}]}]}], panel3:["wm.Panel", {"height":"100%", "horizontalAlign":"left", "layoutKind":"left-to-right", "verticalAlign":"top", "width":"100%"}, {}, {panel5:["wm.Panel", {"height":"100%", "horizontalAlign":"left", "verticalAlign":"top", "width":"120px"}, {}, {dojoMenu1:["wm.DojoMenu", {"_classes":{"domNode":["ClickableDojoMenu"]}, "eventList":[{"label":"Placerat", "children":[{"label":"New"}, {"label":"Open"}, {"label":"Save"}, {"label":"Close"}]}, {"label":"Tristique"}, {"label":"Lacinia"}, {"label":"Egestas"}, {"label":"Viverra"}, {"label":"Feugiat", "children":[{"label":"Cut"}, {"label":"Copy"}, {"label":"Paste"}]}, {"label":"Consequat"}, {"label":"Facilisis"}, {"label":"Convallis"}, {"label":"Pulvinar"}, {"label":"Bibendum"}, {"label":"Bibendum"}, {"label":"Curabitur"}, {"label":"Phasellus"}, {"label":"Habitasse"}], "height":"100%", "menu":"Placerat > Tristique, Lacinia, Egestas, Viverra\nFeugiat > Consequat, Facilisis, Convallis\nBibendum > Pulvinar, Bibendum, Curabitur, Phasellus\nHabitasse", "padding":"20,0,0,0", "structure":"{\"items\":[{\"label\":\"Placerat\",\"children\":[{\"label\":\"Tristique\"},{\"label\":\"Lacinia\"},{\"label\":\"Egestas\"},{\"label\":\"Viverra\"}]},{\"label\":\"Feugiat\",\"children\":[{\"label\":\"Consequat\"},{\"label\":\"Facilisis\"},{\"label\":\"Convallis\"}]},{\"label\":\"Bibendum\",\"children\":[{\"label\":\"Pulvinar\"},{\"label\":\"Bibendum\"},{\"label\":\"Curabitur\"},{\"label\":\"Phasellus\"}]},{\"label\":\"Habitasse\"}]}", "transparent":false, "vertical":true}, {}]}], panel4:["wm.MainContentPanel", {"height":"100%", "horizontalAlign":"left", "layoutKind":"left-to-right", "verticalAlign":"top", "width":"100%"}, {}]}], panel6:["wm.HeaderContentPanel", {"height":"24px", "horizontalAlign":"left", "layoutKind":"left-to-right", "verticalAlign":"top", "width":"100%"}, {}, {picture2:["wm.Picture", {"border":"0", "height":"100%", "source":"/wavemaker/lib/wm/base/widget/themes/default/images/wmSmallLogo.png", "width":"24px"}, {}], label2:["wm.Label", {"_classes":{"domNode":["wm_FontSizePx_10px"]}, "border":"0", "caption":"Powered by WaveMaker", "height":"100%"}, {}, {format:["wm.DataFormatter", {}, {}]}], label1:["wm.Label", {"_classes":{"domNode":["wm_FontSizePx_10px"]}, "align":"right", "border":"0", "caption":"Copyright \ufffd [company name] 2010", "height":"100%", "width":"100%"}, {}, {format:["wm.DataFormatter", {}, {}]}]}]}]}};
	wm.fullTemplates.tabTemplate = {displayName:bundlePackage.TabsTemplate, thumbnail:"/wavemaker/app/templates/widgetTemplateImages/tabLayersTemplate.png", layoutKind:"top-to-bottom", width:"100%", height:"100%", verticalAlign:"top", horizontalAlign:"left", _template:{varTemplateUsername:["wm.ServiceVariable", {"autoUpdate":true, "designTime":true, "operation":"getUserName", "service":"securityService", "startUpdate":true}, {}, {input:["wm.ServiceInput", {"type":"getUserNameInputs"}, {}]}], varTemplateLogout:["wm.LogoutVariable", {}, {}, {input:["wm.ServiceInput", {"type":"logoutInputs"}, {}]}], panel1:["wm.HeaderContentPanel", {"border":"0,0,1,0", "borderColor":"#333333", "height":"65px", "horizontalAlign":"left", "layoutKind":"left-to-right", "padding":"0,10", "verticalAlign":"middle", "width":"100%"}, {}, {picture1:["wm.Picture", {"border":"0", "height":"50px", "source":"/wavemaker/lib/wm/base/widget/themes/default/images/wmLogo.png", "width":"62px"}, {}], label3:["wm.Label", {"_classes":{"domNode":["wm_FontSizePx_20px", "wm_FontSizePx_24px"]}, "border":"0", "caption":"Quisque Molestie Porta", "width":"100%"}, {}, {format:["wm.DataFormatter", {}, {}]}], panel5:["wm.Panel", {"height":"100%", "horizontalAlign":"right", "verticalAlign":"middle", "width":"100%"}, {}, {dojoMenu1:["wm.DojoMenu", {"eventList":[{"label":"Placerat", "children":[{"label":"New"}, {"label":"Open"}, {"label":"Save"}, {"label":"Close"}]}, {"label":"Feugiat", "children":[{"label":"Cut"}, {"label":"Copy"}, {"label":"Paste"}]}, {"label":"Bibendum"}, {"label":"Bibendum"}, {"label":"Habitasse"}], "height":"24px", "menu":"Placerat\nFeugiat\nBibendum\nHabitasse", "structure":"{\"items\":[{\"label\":\"Placerat\"},{\"label\":\"Feugiat\"},{\"label\":\"Bibendum\"},{\"label\":\"Habitasse\"}]}", "transparent":true, "width":"370px"}, {}]}]}], panel2:["wm.MainContentPanel", {"height":"100%", "horizontalAlign":"left", "layoutKind":"left-to-right", "verticalAlign":"top", "width":"100%"}, {}, {tabLayers1:["wm.TabLayers", {}, {}, {layer1:["wm.Layer", {"border":"1", "borderColor":"#999999", "caption":"Quisque", "horizontalAlign":"left", "padding":"10", "verticalAlign":"top"}, {}, {fancyPanel1:["wm.FancyPanel", {"horizontalAlign":"left", "verticalAlign":"top"}, {}, {}]}], layer2:["wm.Layer", {"border":"1", "borderColor":"#999999", "caption":"Ullamcorper", "horizontalAlign":"left", "verticalAlign":"top"}, {}, {pageContainer1:["wm.PageContainer", {"border":"0", "deferLoad":true}, {}]}], layer3:["wm.Layer", {"border":"1", "borderColor":"#999999", "caption":"Porttitor", "horizontalAlign":"left", "verticalAlign":"top"}, {}, {pageContainer2:["wm.PageContainer", {"border":"0", "deferLoad":true}, {}]}], layer4:["wm.Layer", {"border":"1", "borderColor":"#999999", "caption":"Faucibus", "horizontalAlign":"left", "verticalAlign":"top"}, {}, {pageContainer3:["wm.PageContainer", {"border":"0", "deferLoad":true}, {}]}], layer5:["wm.Layer", {"border":"1", "borderColor":"#999999", "caption":"Laoreet", "horizontalAlign":"left", "verticalAlign":"top"}, {}, {pageContainer4:["wm.PageContainer", {"border":"0", "deferLoad":true}, {}]}]}]}], panel6:["wm.HeaderContentPanel", {"height":"24px", "horizontalAlign":"left", "layoutKind":"left-to-right", "verticalAlign":"top", "width":"100%"}, {}, {picture2:["wm.Picture", {"border":"0", "height":"100%", "source":"/wavemaker/lib/wm/base/widget/themes/default/images/wmSmallLogo.png", "width":"24px"}, {}], label2:["wm.Label", {"_classes":{"domNode":["wm_FontSizePx_10px"]}, "border":"0", "caption":"Powered by WaveMaker", "height":"100%"}, {}, {format:["wm.DataFormatter", {}, {}]}], label1:["wm.Label", {"_classes":{"domNode":["wm_FontSizePx_10px"]}, "align":"right", "border":"0", "caption":"Copyright \ufffd [company name] 2010", "height":"100%", "width":"100%"}, {}, {format:["wm.DataFormatter", {}, {}]}]}]}};
	wm.fullTemplates.topMenuTemplate = {displayName:bundlePackage.TopMenu, thumbnail:"/wavemaker/app/templates/widgetTemplateImages/topMenuTemplate.png", layoutKind:"top-to-bottom", width:"100%", height:"100%", verticalAlign:"top", horizontalAlign:"center", _template:{varTemplateUsername:["wm.ServiceVariable", {"autoUpdate":true, "designTime":true, "operation":"getUserName", "service":"securityService", "startUpdate":true}, {}, {input:["wm.ServiceInput", {"type":"getUserNameInputs"}, {}]}], varTemplateLogout:["wm.LogoutVariable", {}, {}, {input:["wm.ServiceInput", {"type":"logoutInputs"}, {}]}], panelCenter:["wm.Panel", {"height":"100%", "horizontalAlign":"left", "verticalAlign":"top", "width":"900px"}, {}, {panelHeader:["wm.HeaderContentPanel", {"height":"65px", "horizontalAlign":"left", "layoutKind":"left-to-right", "padding":"0,10,0,10", "verticalAlign":"middle", "width":"100%"}, {}, {picture1:["wm.Picture", {"border":"0", "height":"50px", "source":"/wavemaker/lib/wm/base/widget/themes/default/images/wmLogo.png", "width":"62px"}, {}], label2:["wm.Label", {"border":"0", "caption":"Quisque Molestie Porta", "width":"100%"}, {}, {format:["wm.DataFormatter", {}, {}]}], panel10:["wm.Panel", {"height":"100%", "horizontalAlign":"left", "verticalAlign":"middle", "width":"300px"}, {}, {panel14:["wm.Panel", {"height":"24px", "horizontalAlign":"left", "layoutKind":"left-to-right", "verticalAlign":"middle", "width":"100%"}, {}, {label4:["wm.Label", {"_classes":{"domNode":["wm_FontSizePx_10px"]}, "autoSizeWidth":true, "border":"0", "caption":"Welcome, ", "height":"20px", "width":"67px"}, {}, {binding:["wm.Binding", {}, {}, {wire:["wm.Wire", {"expression":"\"Welcome, \" + ${varTemplateUsername.dataValue}", "targetProperty":"caption"}, {}]}], format:["wm.DataFormatter", {}, {}]}], button2:["wm.Button", {"_classes":{"domNode":["wm_FontSizePx_10px"]}, "caption":"Log Out", "height":"28px"}, {"onclick":"varTemplateLogout"}]}], panel15:["wm.Panel", {"height":"24px", "horizontalAlign":"left", "layoutKind":"left-to-right", "verticalAlign":"middle", "width":"100%"}, {}, {text1:["wm.Text", {"displayValue":"Search", "width":"100%"}, {}], picture5:["wm.Picture", {"border":"0", "height":"16px", "source":"/wavemaker/lib/images/silkIcons/zoom.png", "width":"16px"}, {}]}]}]}], panel2:["wm.Panel", {"height":"24px", "horizontalAlign":"left", "layoutKind":"left-to-right", "verticalAlign":"top", "width":"100%"}, {}, {dojoMenu1:["wm.DojoMenu", {"_classes":{"domNode":["ClickableDojoMenu"]}, "eventList":[{"label":"Placerat", "children":[{"label":"New"}, {"label":"Open"}, {"label":"Save"}, {"label":"Close"}]}, {"label":"Tristique"}, {"label":"Lacinia"}, {"label":"Egestas"}, {"label":"Viverra"}, {"label":"Feugiat", "children":[{"label":"Cut"}, {"label":"Copy"}, {"label":"Paste"}]}, {"label":"Consequat"}, {"label":"Facilisis"}, {"label":"Convallis"}, {"label":"Pulvinar"}, {"label":"Bibendum"}, {"label":"Bibendum"}, {"label":"Curabitur"}, {"label":"Phasellus"}, {"label":"Habitasse"}], "height":"24px", "menu":"Placerat > Tristique, Lacinia, Egestas, Viverra\nFeugiat > Consequat, Facilisis, Convallis\nBibendum > Pulvinar, Bibendum, Curabitur, Phasellus\nHabitasse", "structure":"{\"items\":[{\"label\":\"Placerat\",\"children\":[{\"label\":\"Tristique\"},{\"label\":\"Lacinia\"},{\"label\":\"Egestas\"},{\"label\":\"Viverra\"}]},{\"label\":\"Feugiat\",\"children\":[{\"label\":\"Consequat\"},{\"label\":\"Facilisis\"},{\"label\":\"Convallis\"}]},{\"label\":\"Bibendum\",\"children\":[{\"label\":\"Pulvinar\"},{\"label\":\"Bibendum\"},{\"label\":\"Curabitur\"},{\"label\":\"Phasellus\"}]},{\"label\":\"Habitasse\"}]}", "transparent":false}, {}]}], panelContent:["wm.MainContentPanel", {"height":"100%", "horizontalAlign":"left", "verticalAlign":"top", "width":"100%"}, {}, {fancyPanel1:["wm.FancyPanel", {"horizontalAlign":"left", "verticalAlign":"top"}, {}, {}], panel1:["wm.EmphasizedContentPanel", {"height":"300px", "horizontalAlign":"left", "layoutKind":"left-to-right", "verticalAlign":"top", "width":"100%"}, {}, {fancyPanel3:["wm.FancyPanel", {"horizontalAlign":"left", "verticalAlign":"top"}, {}, {}], fancyPanel2:["wm.FancyPanel", {"horizontalAlign":"left", "verticalAlign":"top"}, {}, {}]}]}], panelFooter:["wm.HeaderContentPanel", {"height":"24px", "horizontalAlign":"left", "layoutKind":"left-to-right", "verticalAlign":"top", "width":"100%"}, {}, {picture2:["wm.Picture", {"border":"0", "height":"100%", "source":"/wavemaker/lib/wm/base/widget/themes/default/images/wmSmallLogo.png", "width":"24px"}, {}], label1:["wm.Label", {"_classes":{"domNode":["wm_FontSizePx_10px"]}, "border":"0", "caption":"Powered by WaveMaker", "height":"100%"}, {}, {format:["wm.DataFormatter", {}, {}]}], edFooterLabel:["wm.Label", {"_classes":{"domNode":["wm_FontSizePx_10px"]}, "align":"right", "border":"0", "caption":"Copyright \ufffd [company name] 2010", "height":"100%", "width":"100%"}, {}, {format:["wm.DataFormatter", {}, {}]}]}]}]}};
	wm.widgetTemplates.tabbedTwoColumn = {layoutKind:"top-to-bottom", width:"100%", height:"100%", _template:{tabLayers1:["wm.TabLayers", {height:"100%", width:"100%"}, {}, {layer1:["wm.Layer", {caption:"Tab1", layoutKind:"left-to-right"}, {}, {leftSideBarTOC:["wm.Panel", {_classes:{domNode:["TOC"]}, layoutKind:"top-to-bottom", width:"198px", height:"100%"}, {}], splitter1:["wm.Splitter", {layout:"left"}, {}], panel2:["wm.Panel", {box:"v", width:"1flex"}, {}, {toolbarPanel:["wm.Panel", {_classes:{domNode:["toolbar"]}, border:"0,0,2,0", layoutKind:"left-to-right", height:"36px", width:"100%"}, {}, {button1:["wm.Button", {width:"80px", height:"100%"}, {}], button2:["wm.Button", {width:"80px", height:"100%"}, {}]}], mainContent:["wm.Panel", {isMajorContent:true, layoutKind:"left-to-right", width:"100%", height:"100%"}, {}]}]}], layer2:["wm.Layer", {caption:"Tab2"}, {}], layer3:["wm.Layer", {caption:"Tab3"}, {}]}]}};
	wm.widgetTemplates.toolbarWithGroupBox = {layoutKind:"top-to-bottom", width:"100%", height:"100%", _template:{panel1:["wm.Panel", {_classes:{domNode:["wm_SilverBlueTheme_ToolBar"]}, width:"100%", height:"36px", border:"0", layoutKind:"left-to-right"}, {}, {button1:["wm.Button", {width:"50px", height:"100%", border:"1"}, {}], button2:["wm.Button", {width:"50px", height:"100%", border:"1"}, {}]}], panel2:["wm.Panel", {_classes:{domNode:["wm_SilverBlueTheme_LightBlueInsetPanel"]}, width:"100%", height:"100%", border:"0", layoutKind:"left-to-right", horizontalAlign:"center"}, {}, {panel3:["wm.Panel", {width:"542px", height:"100%", border:"0"}, {}, {panel4:["wm.Panel", {height:"45px", border:"0"}, {}, {panel6:["wm.Panel", {width:"100%", height:"20px", border:"0", layoutKind:"left-to-right"}, {}], label1:["wm.Label", {caption:"Group Box", height:"100%", border:"", width:"100%"}, {}, {format:["wm.DataFormatter", {}, {}]}]}], panel5:["wm.Panel", {_classes:{domNode:["wm_SilverBlueTheme_MainOutsetPanel"]}, width:"100%", height:"262px", border:"0", layoutKind:"left-to-right", horizontalAlign:"center"}, {}, {panel7:["wm.Panel", {width:"430px", height:"100%", border:"0", verticalAlign:"middle"}, {}, {editor1:["wm.Editor", {caption:"Foo:", height:"26px", border:"0", width:"100%"}, {}, {editor:["wm._TextEditor", {}, {}]}], editor2:["wm.Editor", {caption:"Bar:", height:"26px", border:"0", width:"100%"}, {}, {editor:["wm._TextEditor", {}, {}]}], editor3:["wm.Editor", {caption:"Foo:", height:"26px", border:"0", width:"100%"}, {}, {editor:["wm._TextEditor", {}, {}]}], editor4:["wm.Editor", {caption:"Bar:", height:"26px", border:"0", width:"100%"}, {}, {editor:["wm._TextEditor", {}, {}]}], editor5:["wm.Editor", {caption:"Foo:", height:"26px", border:"0", width:"100%"}, {}, {editor:["wm._TextEditor", {}, {}]}], panel8:["wm.Panel", {width:"100%", height:"36px", border:"0", layoutKind:"left-to-right", horizontalAlign:"right"}, {}, {button3:["wm.Button", {width:"50px", height:"100%", border:"1"}, {}], button4:["wm.Button", {width:"50px", height:"100%", border:"1"}, {}]}]}]}]}]}]}};
	wm.widgetTemplates.searchListDetail = {layoutKind:"top-to-bottom", width:"100%", height:"100%", _template:{searchBarPanel:["wm.Panel", {_classes:{domNode:["toolbar"]}, width:"100%", height:"36px", layoutKind:"left-to-right"}, {}, {searchBox:["wm.Editor", {width:"219px", margin:"4", padding:"0"}, {}, {editor:["wm._TextEditor", {}, {}]}], searchBtn:["wm.Button", {width:"55px", height:"100%", caption:"Search"}, {}]}], dataGrid1:["wm.DataGrid", {height:"226px"}, {}, {column:["wm.DataGridColumn", {autoSize:true}, {}, {format:["wm.DataFormatter", {}, {}]}]}], splitter1:["wm.Splitter", {layout:"top"}, {}], liveFormOuterPanel:["wm.Panel", {width:"100%", height:"100%", layoutKind:"left-to-right", padding:"48"}, {}, {liveFormInnerPanel:["wm.Panel", {isMajorContent:true, width:"100%", height:"100%", border:"1", padding:"32"}, {}, {liveForm1:["wm.LiveForm", {height:"100%", fitToContent:false, horizontalAlign:"left", verticalAlign:"top"}, {}]}]}]}};
	wm.widgetTemplates.titleBar = {layoutKind:"left-to-right", width:"100%", height:"96px", padding:"8", border:"0,0,4,0", _classes:{domNode:["titlebar"]}, _template:{appNameLabel:["wm.Label", {_classes:{domNode:["wm_FontSizePx_24px"]}, caption:"Application Name", height:"100%", width:"100%"}, {}, {format:["wm.DataFormatter", {}, {}]}], panel3:["wm.Panel", {isMajorContent:true, height:"100%", width:"222px", border:"1"}, {}]}};
	wm.widgetTemplates.toolbar = {layoutKind:"left-to-right", width:"100%", height:"36px", _classes:{domNode:["toolbar"]}, _template:{button1:["wm.Button", {width:"80px", height:"100%"}, {}], button2:["wm.Button", {width:"80px", height:"100%"}, {}]}};
	wm.widgetTemplates.footer = {layoutKind:"top-to-bottom", width:"100%", height:"36px", padding:"2", verticalAlign:"middle", horizontalAlign:"center", _classes:{domNode:["toolbar"]}, _template:{footerLabel:["wm.Label", {align:"center", caption:"Copyright 2010 ACME, Inc.", width:"100%", height:"100%"}, {}, {format:["wm.DataFormatter", {}, {}]}]}};
	wm.widgetTemplates.basic = {layoutKind:"top-to-bottom", height:"100%", width:"100%", _template:{headerLabel:["wm.Label", {height:"40px", width:"100%", border:"0", padding:"10", caption:"Header", backgroundColor:"#C6D3E7"}, {}, {format:["wm.DataFormatter", {}, {}]}], mainPanel:["wm.Panel", {height:"100%", width:"100%", layoutKind:"left-to-right", horizontalAlign:"left", verticalAlign:"top"}, {}, {tabs:["wm.TabLayers", {height:"100%", width:"100%", border:"0", verticalAlign:"top", horizontalAlign:"left"}, {}, {layer1:["wm.Layer", {caption:"layer1"}, {}], layer2:["wm.Layer", {caption:"layer2"}, {}]}]}], footerLabel:["wm.Label", {height:"30px", width:"100%", border:"0", padding:"10", caption:"Footer", backgroundColor:"#C6D3E7"}, {}, {format:["wm.DataFormatter", {}, {}]}]}};
	wm.widgetSpecificTemplate.ListViewerRow = {layoutKind:"top-to-bottom", height:"100%", width:"100%", horizontalAlign:"left", verticalAlign:"top", _template:{variable:["wm.Variable", {}], layoutBox1:["wm.Layout", {height:"100%", width:"100%", horizontalAlign:"left", verticalAlign:"top"}, {}, {sampleRow:["wm.FancyPanel", {title:"Sample Row", layoutKind:"left-to-right", width:"100%", height:"80px"}, {}, {panel1:["wm.Panel", {width:"100%", height:"100%", layoutKind:"left-to-right", verticalAlign:"top", horizontalAlign:"left"}, {}, {label1:["wm.Label", {width:"200px", height:"100%", caption:"Bind me to a field in 'variable'", singleLine:false}], label2:["wm.Label", {width:"100%", height:"100%", caption:"Bind me to another field in 'variable'. Or just delete me and create your own row!", singleLine:false}]}]}]}]}};
}
if (!dojo._hasResource["wm.studio.app.dataconstants"]) {
	dojo._hasResource["wm.studio.app.dataconstants"] = true;
	dojo.provide("wm.studio.app.dataconstants");
	DML_OPERATIONS = ["insert", "update", "delete"];
	ONE_TO_ONE = "to-one";
	ONE_TO_ZERO_OR_ONE = "to-zero-or-one";
	ONE_TO_MANY = "to-many";
	PRIMARY_KEY = "pk";
	DEFAULT_TABLE_FILTER = ".*";
	DEFAULT_SCHEMA_FILTER = ".*";
	DEFAULT_COL_PRECISION = "";
	DEFAULT_COL_LENGTH = "";
	HSQL_DB_TYPE = "HSQLDB";
	MYSQL_DB_TYPE = "MySQL";
	POSTGRESQL_DB_TYPE = "PostgreSQL";
	ORACLE_DB_TYPE = "Oracle";
	DB2_DB_TYPE = "DB2";
	SQL_SERVER_DB_TYPE = "SQLServer";
	OTHER_DB_TYPE = "Other";
	IDENTITY_GENERATOR = "identity";
	HIBERNATE_INT_TYPE = "integer";
	JAVA_INT_TYPE = "Integer";
	HIBERNATE_STRING_TYPE = "string";
	DEFAULT_DB_TYPE = MYSQL_DB_TYPE;
	POSTGRESQL_DEFAULT_TABLE_FILTER = "^pg_.*";
	POSTGRESQL_DEFAULT_SCHEMA_FILTER = "public";
	SQL_SERVER_DEFAULT_SCHEMA = "dbo";
	DEFAULT_PACKAGE_ROOT = "com.";
	DATA_PACKAGE_NAME = ".data";
	ROOT_NODE = "DBOBJS";
	DATA_MODEL_ROOT_NODE = "DB";
	QUERY_ROOT_NODE = "QRS";
	ENTITY_ROOT_NODE = "TPS";
	ENTITY_NODE = "TBL";
	PROPERTY_NODE = "PROP";
	COLUMN_NODE = "COL";
	RELATIONSHIP_NODE = "REL";
	CHECK_QUERY_OP = "checkQuery";
	EXPORT_DB_OP = "exportDatabase";
	IMPORT_DB_OP = "importDatabase";
	LOAD_CONNECTION_PROPS_OP = "readConnectionProperties";
	LOAD_DATA_MODEL_NAMES_OP = "getDataModelNames";
	LOAD_DATA_TYPES_TREE_OP = "getTypeRefTree";
	LOAD_DDL_OP = "getExportDDL";
	LOAD_IP_OP = "getLocalHostIP";
	LOAD_PRIMITIVES_OP = "listPrimitives";
	LOAD_QUERIES_TREE_OP = "getQueriesTree";
	LOAD_QUERY_OP = "getQuery";
	NEW_DATA_MODEL_OP = "newDataModel";
	REIMPORT_DB_OP = "reImportDatabase";
	REMOVE_QUERY_OP = "deleteQuery";
	RUN_QUERY_OP = "runQuery";
	SAVE_CONNECTION_PROPS_OP = "writeConnectionProperties";
	SAVE_QUERY_OP = "updateQuery";
	TEST_CONNECTION_OP = "testConnection";
}
if (!dojo._hasResource["wm.studio.app.datautils"]) {
	dojo._hasResource["wm.studio.app.datautils"] = true;
	dojo.provide("wm.studio.app.datautils");
	isMySQL = function (inValue) {
		return inValue == MYSQL_DB_TYPE;
	};
	isPostgreSQL = function (inValue) {
		return inValue == POSTGRESQL_DB_TYPE;
	};
	isHSQLDB = function (inValue) {
		return inValue == HSQL_DB_TYPE;
	};
	isOracle = function (inValue) {
		return inValue == ORACLE_DB_TYPE;
	};
	isDB2 = function (inValue) {
		return inValue == DB2_DB_TYPE;
	};
	isSQLServer = function (inValue) {
		return inValue == SQL_SERVER_DB_TYPE;
	};
	buildInitialCxnUrl = function (dbtype, extra, inConnectionUrl, overrideFlag) {
		var rtn = "jdbc:";
		if (isHSQLDB(dbtype)) {
			if (overrideFlag == true) {
				rtn += "hsqldb:file:" + extra + ";shutdown=true;";
			} else {
				rtn += "hsqldb:file:" + extra + ";shutdown=true;ifexists=true;";
			}
		} else {
			rtn = inConnectionUrl;
		}
		return rtn;
	};
	buildConnectionUrl = function (dbtype, host, port, extra, extra2) {
		var rtn = "jdbc:";
		if (isMySQL(dbtype)) {
			rtn += "mysql://" + host + ":" + port + "/" + extra;
		} else {
			if (isHSQLDB(dbtype)) {
				if (extra2 == false) {
					rtn += "hsqldb:file:" + extra + ";shutdown=true;ifexists=true;";
				} else {
					rtn += "hsqldb:file:" + extra + ";shutdown=true;";
				}
			} else {
				if (isOracle(dbtype)) {
					rtn += "oracle:thin:@" + host + ":" + port + ":" + extra;
				} else {
					if (isSQLServer(dbtype)) {
						rtn += "jtds:sqlserver://" + host;
						if (port) {
							rtn += ":" + port;
						}
						if (extra) {
							rtn += "/" + extra;
						}
						if (extra2) {
							rtn += ";instance=" + extra2;
						}
					} else {
						if (isDB2(dbtype)) {
							rtn += "db2://" + host + ":" + port + "/" + extra;
						} else {
							if (isPostgreSQL(dbtype)) {
								rtn += "postgresql://" + host + ":" + port + "/" + extra;
							}
						}
					}
				}
			}
		}
		return rtn;
	};
	parseConnectionUrl = function (inConnectionUrl, inData) {
		if (inConnectionUrl.indexOf("jdbc:") == 0) {
			inConnectionUrl = inConnectionUrl.substring(5);
		}
		var c = inConnectionUrl.toLowerCase();
		if (c.indexOf("hsqldb") == 0) {
			return parseHSQLDBUrl(inConnectionUrl.substring(6), inData);
		} else {
			if (c.indexOf("mysql") == 0) {
				return parseMySQLUrl(inConnectionUrl.substring(5));
			} else {
				if (c.indexOf("oracle") == 0) {
					return parseOracleUrl(inConnectionUrl.substring(6));
				} else {
					if (c.indexOf("db2") == 0) {
						return parseDB2Url(inConnectionUrl.substring(3));
					} else {
						if (c.indexOf("jtds:sqlserver") == 0) {
							return parseSQLServerUrl(inConnectionUrl.substring(14));
						} else {
							if (c.indexOf("postgresql") == 0) {
								return parsePostgreSQLUrl(inConnectionUrl.substring(10));
							} else {
								return null;
							}
						}
					}
				}
			}
		}
	};
	parseHSQLDBUrl = function (inConnectionUrl, inData) {
		var c = removeConnectionUrlParams(inConnectionUrl);
		var i = c.indexOf("file:");
		var path = c.substring(i + 5);
		var fileName = inData.hsqldbFile;
		return [HSQL_DB_TYPE, null, null, fileName, null];
	};
	parseMySQLUrl = function (inConnectionUrl) {
		var c = removeConnectionUrlParams(inConnectionUrl);
		return [MYSQL_DB_TYPE].concat(parseGenericHostPortDatabase(c)).concat(null);
	};
	parsePostgreSQLUrl = function (inConnectionUrl) {
		var c = removeConnectionUrlParams(inConnectionUrl);
		return [POSTGRESQL_DB_TYPE].concat(parseGenericHostPortDatabase(c)).concat(null);
	};
	parseOracleUrl = function (inConnectionUrl) {
		var c = removeConnectionUrlParams(inConnectionUrl);
		var i = c.indexOf("thin:@");
		if (i == -1) {
			return [ORACLE_DB_TYPE, null, null, null, null];
		}
		i += 6;
		var j = c.indexOf(":", i);
		var host = c.substring(i, j);
		j += 1;
		i = c.indexOf(":", j);
		if (i == -1) {
			i = c.length;
		}
		var port = c.substring(j, i);
		var sid = null;
		i += 1;
		if (i < c.length) {
			sid = inConnectionUrl.substring(i);
		}
		return [ORACLE_DB_TYPE, host, port, sid, null];
	};
	parseDB2Url = function (inConnectionUrl) {
		var c = removeConnectionUrlParams(inConnectionUrl);
		return [DB2_DB_TYPE].concat(parseGenericHostPortDatabase(c)).concat(null);
	};
	parseSQLServerUrl = function (inConnectionUrl) {
		var instance = null;
		var i = inConnectionUrl.indexOf("instance=");
		if (i != -1) {
			i += 9;
			var j = inConnectionUrl.indexOf(";", i);
			if (j == -1) {
				j = inConnectionUrl.length;
			}
			instance = inConnectionUrl.substring(i, j);
		}
		var c = removeConnectionUrlParams(inConnectionUrl);
		return [SQL_SERVER_DB_TYPE].concat(parseGenericHostPortDatabase(c)).concat(instance);
	};
	parseGenericHostPortDatabase = function (inConnectionUrl) {
		var i = inConnectionUrl.indexOf("://") + 3;
		var j = inConnectionUrl.indexOf(":", i);
		var db = null;
		var host = null;
		var port = null;
		if (j != -1) {
			host = inConnectionUrl.substring(i, j);
			i = inConnectionUrl.indexOf("/", j);
			if (i == -1) {
				i = inConnectionUrl.length;
			}
			port = inConnectionUrl.substring(j + 1, i);
			i += 1;
		} else {
			j = inConnectionUrl.indexOf("/", i);
			if (j == -1) {
				j = inConnectionUrl.length;
			}
			host = inConnectionUrl.substring(i, j);
			i = j + 1;
		}
		if (i < inConnectionUrl.length) {
			db = inConnectionUrl.substring(i);
		}
		return [host, port, db];
	};
	removeConnectionUrlParams = function (inConnectionUrl) {
		var rtn = inConnectionUrl;
		var i = inConnectionUrl.lastIndexOf("?");
		if (i != -1) {
			rtn = inConnectionUrl.substring(0, i);
		}
		i = inConnectionUrl.indexOf(";");
		if (i != -1) {
			rtn = inConnectionUrl.substring(0, i);
		}
		return rtn;
	};
	setupWidgetsForDatabaseType = function (inDBType, ip, hostLabel, hostInput, portLabel, portInput, extraLabel, extraInput, extraLabel2, extraInput2, tableFilterInput, schemaFilterInput, usernameInput, passwordInput) {
		var h = "localhost";
		var p = null;
		var e = "データベース";
		var e2 = null;
		var tableFilter = DEFAULT_TABLE_FILTER;
		var schemaFilter = DEFAULT_SCHEMA_FILTER;
		var username = "";
		var password = "";
		if (isMySQL(inDBType)) {
			p = 3306;
			if (studio.isCloud()) {
				h = "mysql.wavemaker.com";
			}
		} else {
			if (isHSQLDB(inDBType)) {
				h = null;
				p = null;
				e = "ファイル： ";
				username = "sa";
			} else {
				if (isPostgreSQL(inDBType)) {
					p = 5432;
					tableFilter = POSTGRESQL_DEFAULT_TABLE_FILTER;
					schemaFilter = POSTGRESQL_DEFAULT_SCHEMA_FILTER;
				} else {
					if (isOracle(inDBType)) {
						h = ip;
						p = "1521";
						e = "SID:";
					} else {
						if (isSQLServer(inDBType)) {
							p = 1433;
							e2 = "Instance:";
							schemaFilter = SQL_SERVER_DEFAULT_SCHEMA;
						} else {
							if (isDB2(inDBType)) {
								p = 50000;
							}
						}
					}
				}
			}
		}
		hostInput.setInputValue("");
		if (h == null) {
			hostLabel.setCaption("");
			hostInput.parent.setShowing(false);
		} else {
			hostLabel.setCaption("ホスト");
			hostInput.parent.setShowing(true);
			hostInput.setInputValue(h);
		}
		portInput.setInputValue("");
		if (p == null) {
			portLabel.setCaption("");
			portInput.parent.setShowing(false);
		} else {
			portLabel.setCaption("ポート");
			portInput.parent.setShowing(true);
			portInput.setInputValue(p);
		}
		extraInput.setInputValue("");
		extraInput.setShowing(e != null);
		extraLabel.setShowing(e != null);
		if (e != null) {
			extraLabel.setCaption(e);
		}
		extraInput2.setInputValue("");
		extraInput2.setShowing(e2 != null);
		extraLabel2.setShowing(e2 != null);
		if (usernameInput) {
			usernameInput.setInputValue(username);
		}
		if (e2 != null) {
			extraLabel2.setCaption(e2);
		}
		if (tableFilter != null) {
			tableFilterInput.setInputValue(tableFilter);
		}
		if (schemaFilter != null) {
			schemaFilterInput.setInputValue(schemaFilter);
		}
	};
	getDataModelTypeNodes = function (dataModelTree, dataModelName) {
		return getDataModelNodes(dataModelTree, dataModelName, 0);
	};
	getDataModelQueryNodes = function (dataModelTree, dataModelName) {
		return getDataModelNodes(dataModelTree, dataModelName, 0);
	};
	getDataModelNodes = function (dataModelTree, dataModelName, nodesIndex) {
		var r = dataModelTree._data[0];
		for (var i in r.children) {
			if (r.children[i].data[1] == dataModelName) {
				return r.children[i].children[nodesIndex].children;
			}
		}
		return [];
	};
	getDataModelQueryNames = function (dataModelTree, dataModelName) {
		var queryNodes = getDataModelQueryNodes(dataModelTree, dataModelName);
		var rtn = [];
		for (var i in queryNodes) {
			var queryName = queryNodes[i].content;
			rtn.push(queryName);
		}
		return rtn;
	};
	getDataModelTypeNames = function (typeRefTree, dataModelName, valueTypes) {
		var rtn = {};
		var typeNodes = getDataModelTypeNodes(typeRefTree, dataModelName);
		for (var j = 0, node; node = typeNodes[j]; j++) {
			rtn[node.data[1]] = node.data[2];
		}
		var t = valueTypes[dataModelName];
		for (var i in t) {
			rtn[t[i]["name"]] = t[i]["fullyQualifiedName"];
		}
		return rtn;
	};
	getDataModelName = function (inNode) {
		var n = getDataModelNode(inNode);
		return getNodeData(n);
	};
	getNodeData = function (inNode) {
		return inNode && inNode.data && inNode.data[1];
	}, getDataModelNode = function (inNode) {
		var rtn = getAnnotatedNode(inNode, DATA_MODEL_ROOT_NODE);
		return rtn;
	};
	getAnnotatedNode = function (inNode, inAnno) {
		if (inNode && inNode.data[0] == inAnno) {
			return inNode;
		}
		if (inNode && inNode.parent != inNode.tree.root && inNode.parent.data[0] != this.ROOT_NODE) {
			return getAnnotatedNode(inNode.parent, inAnno);
		}
	};
	initDBTypeDropdown = function (inDropdown) {
		var l = [HSQL_DB_TYPE, MYSQL_DB_TYPE, POSTGRESQL_DB_TYPE];
		if (studio) {
			if (studio.isModuleEnabled("jdbc-driver", "wm.oracle")) {
				l.push(ORACLE_DB_TYPE);
			}
			if (studio.isModuleEnabled("jdbc-driver", "wm.db2")) {
				l.push(DB2_DB_TYPE);
			}
			if (studio.isModuleEnabled("jdbc-driver", "wm.mssql")) {
				l.push(SQL_SERVER_DB_TYPE);
			}
		}
		l.sort();
		l = [OTHER_DB_TYPE].concat(l);
		inDropdown.editor.setOptions(l.join());
		inDropdown.setDisplayValue(DEFAULT_DB_TYPE);
	};
	selectFirstChildNode = function (tree) {
		var n = tree.root && tree.root.kids[0];
		if (n) {
			if (n.kids.length > 0) {
				n = n.kids[0].kids[0];
				if (n.kids.length > 0) {
					n = n.kids[0];
				}
			}
			tree.select(n);
		}
	};
	askSaveChanges = function () {
		return confirm("保存されていない変更を破棄しますか？");
	};
}
if (!dojo._hasResource["wm.studio.app.servicesTree"]) {
	dojo._hasResource["wm.studio.app.servicesTree"] = true;
	dojo.provide("wm.studio.app.servicesTree");
	dojo.declare("wm.ServicesTree", wm.Tree, {init:function () {
		this.inherited(arguments);
		this.serviceId = null;
	}, prepare:function () {
		this.inherited(arguments);
	}, setTreeData:function (inData) {
		this.clear();
		this.dumpServiceList(this.root, inData);
		this.selectLastSelectedNode();
		return this.serviceId;
	}, dumpServiceList:function (inNode, inList) {
		for (var i = 0, n; (n = inList[i]); i++) {
			new wm.TreeNode(inNode, {content:n, image:"images/service.png", closed:true, isService:true, name:n, _data:{children:["faux"]}});
		}
	}, dumpOperationList:function (inNode, inList) {
		var sorted = [];
		for (var o in inList) {
			sorted.push(o);
		}
		for (var i = 0, o; o = sorted[i]; i++) {
			new wm.TreeNode(inNode, {content:o, image:"images/operation.png", closed:true, isOperation:true, params:inList[o].parameters, returnType:inList[o].returnType, _data:{children:["faux"]}});
		}
	}, dumpParamList:function (inNode, inList) {
		var sorted = [];
		for (var o in inList) {
			sorted.push(dojo.mixin({name:o}, inList[o]));
		}
		for (var i = 0, p; (p = sorted[i]); i++) {
			this.dumpType(inNode, p.name, p.type);
		}
	}, dumpReturnType:function (inNode, inType) {
		this.dumpType(inNode, "(return)", inType);
	}, dumpTypeList:function (inNode, inList) {
		for (var n in inList) {
			this.dumpType(inNode, n, inList[n].type, inList[n].isList);
		}
	}, dumpType:function (inNode, inName, inType, isList) {
		var lt = inType.slice(-1) == "]", ty = lt ? inType.slice(1, -1) : inType, tn = ty.split(".").pop(), tn = lt ? "[" + tn + "]" : tn;
		if (isList) {
			tn = "[" + tn + "]";
		}
		var h = "<img width=\"16\" height=\"16\" src=\"images/dataobject.png\">&nbsp;" + inName + ": <em>" + tn + "</em>";
		var data = {}, ti = wm.typeManager.getType(ty);
		if (ti) {
			if (!ti.primitiveType) {
				data = {children:["faux"]};
			}
		}
		new wm.TreeNode(inNode, {content:h, closed:true, isType:true, type:ty, _data:data});
	}, treeInitNodeChildren:function (inNode) {
		if (inNode.isService) {
			studio.scrim.scrimify(dojo.hitch(this, function () {
				var s = new wm.JsonRpcService({name:inNode.name, owner:studio.application});
				this.dumpOperationList(inNode, s._operations, "", "");
				s.destroy();
			}));
		} else {
			if (inNode.isOperation) {
				this.dumpParamList(inNode, inNode.params);
				this.dumpReturnType(inNode, inNode.returnType);
			} else {
				if (inNode.isType) {
					this.dumpTypeList(inNode, wm.typeManager.getTypeSchema(inNode.type));
				}
			}
		}
	}, selectLastSelectedNode:function () {
		if (this.serviceId) {
			var kids = this.root.kids;
			for (var i in kids) {
				if (kids[i].isService && kids[i].name == this.serviceId) {
					this.select(kids[i]);
					return;
				}
			}
		}
	}, selectFirstService:function () {
		var kids = this.root.kids;
		for (var i in kids) {
			if (kids[i].isService) {
				this.serviceId = kids[i].name;
				this.select(kids[i]);
				return;
			}
		}
	}});
}
if (!dojo._hasResource["wm.studio.pages.Binder.Binder"]) {
	dojo._hasResource["wm.studio.pages.Binder.Binder"] = true;
	dojo.provide("wm.studio.pages.Binder.Binder");
	dojo.declare("Binder", wm.Page, {start:function () {
		this.update();
	}, update:function () {
		if (this.sourceBinder && this.binding) {
			this.buildSourceTree();
			this.updateTarget();
		}
	}, updateTarget:function () {
		this.sourceBinder.expressionEditor.clear();
		this.buildTargetTree();
		this.disEnableBinding(true);
	}, buildTargetTree:function () {
		var t = this.targetTree;
		t.clear();
		var target = null;
		var n = new wm.BindTargetTreeNode(t.root, {object:this.binding.owner, closed:false});
	}, buildSourceTree:function () {
		if (this.sourceBinder) {
			this.sourceBinder.initBinding();
		}
	}, isRootTargetNode:function (inNode) {
		return inNode == inNode.tree.root.kids[0];
	}, getRootTargetNode:function () {
		return this.targetTree.root.kids[0];
	}, isTarget:function (inObject) {
		return (inObject == this.binding.owner);
	}, doBinding:function () {
		if (this.sourceBinder.applyBinding(this.target)) {
			this.postApplyBinding();
		}
	}, postApplyBinding:function () {
		var isBindingOwner = this.isRootTargetNode(this.target);
		if (isBindingOwner) {
			this.updateTarget();
			this.targetTree.select(this.getRootTargetNode());
		} else {
			this.updateNode(this.target);
		}
	}, updateNode:function (inNode) {
		inNode.updateNodeContent();
	}, disEnableBinding:function (inDisabled) {
		var sb = this.sourceBinder;
		sb.tree.setDisabled(inDisabled);
		sb.expressionEditor.setDisabled(inDisabled);
	}, targetTreeSelect:function (inSender, inNode) {
		this.target = inNode.targetProperty || inNode.isProperty ? inNode : null;
		this.sourceBinder.tree.deselect();
		this.sourceBinder.updateUiForWire(wm.data.getPropWire(inNode.object, inNode.targetProperty));
		this.disEnableBinding(false);
	}, targetTreeDeselect:function (inSender, inNode) {
		this.target = null;
		this.disEnableBinding(true);
	}, clearButtonClick:function () {
		if (this.target) {
			this.sourceBinder.tree.deselect();
			this.target.clearBinding();
			if (this.isRootTargetNode(this.target)) {
				this.updateTarget();
			} else {
				this.updateNode(this.target);
			}
		}
	}, clearAllButtonClick:function () {
		this.getRootTargetNode().clearBinding();
		this.sourceBinder.tree.deselect();
		this.updateTarget();
	}, sourceBinderBindNodeSelected:function (inSender, inNode) {
		if (inNode && this.sourceBinder.canBind(this.target, inNode)) {
			this.sourceBinder.bindEditor.setValue("dataValue", inNode.source);
		}
	}, bindButtonClick:function (inSender) {
		this.doBinding();
	}});
}
if (!dojo._hasResource["wm.studio.pages.BindSourceDialog.BindSourceDialog"]) {
	dojo._hasResource["wm.studio.pages.BindSourceDialog.BindSourceDialog"] = true;
	dojo.provide("wm.studio.pages.BindSourceDialog.BindSourceDialog");
	dojo.declare("BindSourceDialog", wm.Page, {start:function () {
		this.connect(this.owner.parent, "onClose", this, "onClose");
	}, initBinding:function () {
		this.binderSource.initBinding();
	}, onClose:function (inWhy) {
		studio.select(studio.selected);
	}, update:function (inTargetProps, noRegen) {
		this.targetType = this._getTargetType(inTargetProps);
		var tp = this.targetProps = inTargetProps, w = wm.data.getPropWire(tp.object, tp.targetProperty);
		this.binderSource.initBinding(noRegen);
		this.binderSource.updateUiForWire(w);
		this.owner.owner.setTitle("連携： " + [(tp.object || 0).getId(), tp.targetProperty].join("."));
		var bindname = wm.getFriendlyTypeName(this.targetType.type, this.targetType.isList);
		if (bindname.length > 30) {
			bindname = "..." + bindname.substring(bindname.length - 30);
		}
		this.bindTargetTypeLabel.setCaption("<span style=\"font-weight: bold\">型：</span> <span style=\"font-style: italic;\">" + bindname + "</span>");
		if (tp.subtype == "File") {
			this.resourceRb.editor.setChecked(true);
		}
	}, _getTargetType:function (inTargetProps) {
		var tp = inTargetProps, p = tp.targetProperty.split("."), l = p.pop(), v = tp.object.getValue(p.join(".")), ti = v && v.getDataTypeInfo(l), type, isObject, isList;
		if (tp.object.getDataTypeInfo && (!p || !p.length)) {
			ti = tp.object.getDataTypeInfo(l);
			if (!ti) {
				type = tp.object.type;
				isList = tp.isList;
			}
		}
		if (ti) {
			type = ti.type;
			isList = ti.isList;
		}
		type = type || tp.type;
		type = wm.typeManager.getPrimitiveType(type) || type;
		isObject = type == "wm.Variable" || wm.typeManager.isStructuredType(type);
		return {type:type, isObject:isObject, isList:isList || tp.isList};
	}, bindNodeSelected:function (inSender, inNode) {
		if (inNode) {
			this.binderSource.bindEditor.setValue("dataValue", inNode.source);
		}
	}, applyButtonClick:function () {
		if (this.binderSource.applyBinding(this.targetProps)) {
			this.cancelButtonClick();
		}
	}, applyStayButtonClick:function () {
		if (this.binderSource.applyBinding(this.targetProps)) {
			app.toastSuccess("Binding Added");
		} else {
			app.toastWarning("Binding Failed");
		}
	}, cancelButtonClick:function () {
		wm.fire(this.owner.owner, "dismiss");
	}});
}
if (!dojo._hasResource["wm.studio.pages.ImportPageDialog.ImportPageDialog"]) {
	dojo._hasResource["wm.studio.pages.ImportPageDialog.ImportPageDialog"] = true;
	dojo.provide("wm.studio.pages.ImportPageDialog.ImportPageDialog");
	dojo.declare("ImportPageDialog", wm.Page, {start:function () {
		this.update();
	}, update:function (inResponse) {
		studio.studioService.requestAsync("listProjects", null, dojo.hitch(this, "listProjectsResult"));
		return inResponse;
	}, listProjectsResult:function (inResponse) {
		this.projectList.renderData(inResponse);
	}, projectListSelect:function (inSender, inItem) {
		studio.pagesService.requestAsync("listPages", [inItem.getData()], dojo.hitch(this, "listPanesResult"));
	}, listPanesResult:function (inResponse) {
		this.panesList.renderData(inResponse);
	}, panesListSelect:function (inSender, inItem) {
		this.destPageName.setDataValue(inItem.getData());
	}, copyButtonClick:function (inSender) {
		if (!this.projectList.selected) {
			app.alert("ページをインポートするプロジェクトを選択してください。");
			return;
		}
		if (!this.panesList.selected) {
			app.alert("インポートするページを選択してください。");
			return;
		}
		var project = this.projectList.selected.getData();
		var sourcePage = this.panesList.selected.getData();
		var destPage = this.destPageName.getDataValue();
		if (dojo.indexOf(studio.project.getPageList(), destPage) != -1) {
			app.alert("現在のプロジェクトに存在しないページを選択してください。");
			return;
		}
		studio.pagesService.requestAsync("copyPage", [project, sourcePage, destPage], dojo.hitch(this, "copyPaneResult"), dojo.hitch(this, "copyPaneError"));
		return inSender;
	}, copyPaneResult:function (inResponse) {
		this.projectList.deselectAll();
		this.panesList.clear();
		wm.fire(this.owner, "dismiss", ["OK"]);
		return inResponse;
	}, copyPaneError:function (error) {
		app.alert("Copy page failed: " + error.message);
		return error;
	}, cancelButtonClick:function (inSender) {
		this.projectList.deselectAll();
		this.panesList.clear();
		wm.fire(this.owner, "dismiss");
		return inSender;
	}, _end:0});
}
if (!dojo._hasResource["wm.studio.pages.CreateLiveView.CreateLiveView"]) {
	dojo._hasResource["wm.studio.pages.CreateLiveView.CreateLiveView"] = true;
	dojo.provide("wm.studio.pages.CreateLiveView.CreateLiveView");
	dojo.declare("CreateLiveView", wm.Page, {start:function () {
		this.update();
	}, update:function () {
		this.updateServicesSelect();
		this.updateDataTypeList();
		this.okButton.setDisabled(true);
	}, updateServicesSelect:function () {
		var options = [];
		this.serviceSelectEditor.clear();
		for (var i in wm.dataSources.sources) {
			options.push(i);
		}
		this.serviceSelectEditor.editor.setOptions(options.join());
		if (options.length) {
			this.serviceSelectEditor.setDisplayValue(options[0]);
		}
	}, updateDataTypeList:function () {
		var d = this.serviceSelectEditor.getDataValue(), types = wm.dataSources.sources[d] || [];
		this.dataTypeList.renderData(types);
		this.okButton.setDisabled(true);
	}, dataTypeListSelect:function () {
		this.okButton.setDisabled(false);
	}, dataTypeListFormat:function (inSender, ioData) {
		var i = "<img src=\"images/wm/data.png\" height=\"16\" width=\"16\" align=\"absmiddle\"> ", d = ioData.data;
		ioData.data = d ? i + d : d;
	}, okButtonClick:function (inSender, inEvent) {
		wm.fire(this.owner, "dismiss", [inEvent]);
	}, cancelButtonClick:function (inSender, inEvent) {
		wm.fire(this.owner, "dismiss", [inEvent]);
	}, _end:0});
}
if (!dojo._hasResource["wm.studio.pages.DataObjectsEditor.DataObjectsEditor"]) {
	dojo._hasResource["wm.studio.pages.DataObjectsEditor.DataObjectsEditor"] = true;
	dojo.provide("wm.studio.pages.DataObjectsEditor.DataObjectsEditor");
	dojo.declare("DataObjectsEditor", wm.Page, {PK_ATTR:"isPk", FK_ATTR:"isFk", GENERATOR_ATTR:"generator", DEFAULT_PAGE:"defaultPage", OBJECT_PAGE:"objectPage", valueTypes:null, currentDataModelName:null, currentEntity:null, currentEntityName:null, currentPropertyName:null, propertiesAreDirty:false, onlyEntityIsDirty:false, dataModelComponent:null, start:function () {
		this.dataObject = {name:"", table:""};
		this.setDataTypes();
		this.update();
		this.subscribe("wm-project-changed", this, "update");
	}, update:function () {
		this.setSchemas();
		this.clearDetailDisplay();
		this.tree.clear();
		this.initData();
		setTimeout(dojo.hitch(this, "_selectNode"), 10);
	}, setDataModel:function (inDataModel) {
		this.dataModel = inDataModel;
		this.currentDataModelName = this.dataModel.dataModelName;
	}, setDataTypes:function () {
		wm.typeManager.addType("com.wavemaker.tools.data.ColumnInfo", {internal:true, fields:{name:{type:"java.lang.String", isObject:false, isList:false}, isPk:{type:"boolean", isObject:false, isList:false}, isFk:{type:"boolean", isObject:false, isList:false}, notNull:{type:"boolean", isObject:false, isList:false}, length:{type:"java.lang.Integer", isObject:false, isList:false}, precision:{type:"java.lang.Integer", isObject:false, isList:false}, generator:{type:"java.lang.String", isObject:false, isList:false}, generatorParam:{type:"java.lang.String", isObject:false, isList:false}, sqlType:{type:"java.lang.String", isObject:false, isList:false}}});
		wm.typeManager.addType("com.wavemaker.tools.data.RelatedInfo", {internal:true, fields:{name:{type:"java.lang.String", isObject:false, isList:false}, relatedType:{type:"java.lang.String", isObject:false, isList:false}, cardinality:{type:"java.lang.String", isObject:false, isList:false}, tableName:{type:"java.lang.String", isObject:false, isList:false}, columnNames:{type:"java.lang.String", isObject:false, isList:false}, cascadeOptions:{type:"java.lang.String", isObject:false, isList:false}}});
	}, setSchemas:function () {
		this.columnListVar.setType("com.wavemaker.tools.data.ColumnInfo");
		this.columnList.setDataSet(this.columnListVar);
		this.relationshipsListVar.setType("com.wavemaker.tools.data.RelatedInfo");
		this.relationshipsList.setDataSet(this.relationshipsListVar);
	}, initData:function () {
		studio.dataService.requestSync(LOAD_DATA_TYPES_TREE_OP, null, dojo.hitch(this, "gotInitData"));
	}, gotInitData:function (inData) {
		this.tree.renderData(inData.dataObjectsTree);
		this.valueTypes = inData.valueTypes;
	}, reloadEntityNode:function (entity) {
		studio.dataService.requestSync("getTypesSubtree", [this.currentDataModelName], dojo.hitch(this, "gotDataToUpdateEntityNode", entity));
	}, gotDataToUpdateEntityNode:function (entity, inData) {
		if (!entity) {
			entity = this.lastSelectedNode;
		}
		var entityNode = this.getEntityNode(entity);
		if (entityNode) {
			var entityData = null;
			for (var i in inData) {
				if (inData[i].data[1] == entityNode.data[1]) {
					entityData = inData[i].children;
					break;
				}
			}
			if (entityData) {
				var closed = entityNode.closed;
				entityNode.setOpen(true);
				entityNode.removeChildren();
				this.tree.renderDataNode(entityNode, entityData);
				entityNode.setOpen(!closed);
			}
		}
	}, importDBButtonClick:function () {
		if (!studio.importDBDialog) {
			var d = studio.importDBDialog = new wm.PageDialog({owner:app, pageName:"ImportDatabase", hideControls:true, width:700, height:550});
			d.onPageReady = dojo.hitch(d, function () {
				d.onShow = dojo.hitch(d.page, "update");
			});
		}
		studio.importDBDialog.show();
	}, dbSettingsButtonClick:function () {
		var d = this.dbConnectDialog;
		if (d) {
			d.page.setup();
		} else {
			this.dbConnectDialog = d = new wm.PageDialog({owner:app, pageName:"DBConnectionSettings", hideControls:true, width:700, height:510});
			this.connect(d, "onPageReady", dojo.hitch(d.page, "setup"));
		}
		d.show();
	}, resetPropertyEdit:function () {
		this.propertyName.setInputValue("");
		this.currentPropertyName = null;
	}, clearDetailDisplay:function () {
		this.resetSelection();
		this.clearTableDetails();
		this.columnListVar.beginUpdate();
		this.columnListVar.setData([]);
		this.columnListVar.endUpdate();
		this.columnList.setDataSet(this.columnListVar);
		this.relationshipsListVar.beginUpdate();
		this.relationshipsListVar.setData([]);
		this.relationshipsListVar.endUpdate();
		this.relationshipsList.setDataSet(this.relationshipsListVar);
		setTimeout(dojo.hitch(this, "resetChanges"), 0);
	}, clearTableDetails:function () {
		this.tableDetailSchemaName.setDataValue("");
		this.tableDetailCatalogName.setDataValue("");
		this.tableDetailTableName.setDataValue("");
		this.tableDetailEntityName.setDataValue("");
		this.tableDetailPackageName.setDataValue("");
		this.dynamicInsertCheckBox.components.editor.setChecked(false);
		this.dynamicUpdateCheckBox.components.editor.setChecked(false);
		this.refreshCheckBox.components.editor.setChecked(false);
	}, renderTableDetails:function (entity) {
		this.tableDetailSchemaName.setDataValue(entity.schemaName);
		this.tableDetailCatalogName.setDataValue(entity.catalogName);
		this.tableDetailTableName.setDataValue(entity.tableName);
		this.tableDetailEntityName.setDataValue(entity.entityName);
		this.tableDetailPackageName.setDataValue(entity.packageName);
		this.dynamicInsertCheckBox.components.editor.setChecked(entity.dynamicInsert);
		this.dynamicUpdateCheckBox.components.editor.setChecked(entity.dynamicUpdate);
		this.refreshCheckBox.components.editor.setChecked(entity.refreshEntity);
	}, tableDetailSchemaNameChange:function (inSender) {
		this.onlyEntityIsDirty = true;
	}, tableDetailCatalogNameChange:function (inSender) {
		this.onlyEntityIsDirty = true;
	}, tableDetailTableNameChange:function () {
		this.onlyEntityIsDirty = true;
	}, tableDetailEntityNameChange:function () {
		this.propertiesAreDirty = true;
	}, tableDetailPackageNameChange:function (inSender) {
		this.onlyEntityIsDirty = true;
	}, dynamicInsertChange:function (inSender) {
		this.onlyEntityIsDirty = true;
	}, dynamicUpdateChange:function (inSender) {
		this.onlyEntityIsDirty = true;
	}, refreshChange:function (inSender) {
		this.onlyEntityIsDirty = true;
	}, columnsChange:function () {
		this.propertiesAreDirty = true;
	}, relationshipsChange:function () {
		this.propertiesAreDirty = true;
	}, propertyNameChange:function () {
		this.propertiesAreDirty = true;
	}, resetChanges:function () {
		this.onlyEntityIsDirty = false;
		this.propertiesAreDirty = false;
	}, selectEntity:function (inDataModelName, inEntityName) {
		this.currentDataModelName = inDataModelName;
		this.setDataObject(inDataModelName, inEntityName);
	}, treeSelect:function (inSender, inNode) {
		var d = inNode.data[0];
		var dmn = getDataModelName(inNode);
		var en = this.getEntityName(inNode);
		var changed = this.dataObject.name && this.dataObject.table && this.dataObjectSelectionChanged(dmn, en);
		if (changed) {
			if (this._askAboutLosingChanges()) {
				return;
			}
		}
		this.lastSelectedNode = inNode;
		this.currentDataModelName = dmn;
		this.resetPropertyEdit();
		if (d == ROOT_NODE) {
			this.currentDataModelName = null;
		}
		if (d == ROOT_NODE || d == DATA_MODEL_ROOT_NODE || d == ENTITY_ROOT_NODE) {
			this.resetSelection();
			this.objectPages.setLayer(this.DEFAULT_PAGE);
			return;
		} else {
			if (d == ENTITY_NODE) {
				this.columnList.dijit.selection.unselectAll();
			} else {
				if (d == COLUMN_NODE) {
					var columnName = inNode.data[3];
					this.relationshipsList.dijit.selection.unselectAll();
					this.selectRow(this.columnList, columnName);
					this._setCurrentPropertyName(inNode);
				} else {
					if (d == PROPERTY_NODE) {
						this._setCurrentPropertyName(inNode);
					} else {
						if (d == RELATIONSHIP_NODE) {
							this.columnList.dijit.selection.unselectAll();
							this.selectRow(this.relationshipsList, inNode.data[1]);
						}
					}
				}
			}
		}
		this.objectPages.setLayer(this.OBJECT_PAGE);
		this.setDataObject(this.currentDataModelName, this.getEntityName(inNode));
	}, treeDeselect:function (inSender, inNode) {
	}, expandCurrentTypesNode:function () {
		this.tree.forEachNode(dojo.hitch(this, function (inNode) {
			if (inNode.data && inNode.data[0] == ENTITY_ROOT_NODE) {
				if (inNode.parent.data[1] == this.currentDataModelName) {
					inNode.setOpen(true);
				}
			}
		}));
	}, selectTreeNode:function (data) {
		this.findAndSelectNode(this.tree.root, data);
	}, selectEntityNode:function (entity) {
		setTimeout(dojo.hitch(this, "_selectCurrentEntityNode"), 100);
	}, _selectCurrentEntityNode:function () {
		this.expandCurrentTypesNode();
		this.selectTreeNode(this.currentEntity.entityName);
	}, findAndSelectNode:function (inNode, data) {
		var node = this.findNode(inNode, data);
		if (node != null) {
			this.tree.select(node);
		}
	}, findNode:function (inNode, data) {
		if (inNode.data[1] == data) {
			return inNode;
		}
		for (var i = 0; i < inNode.kids.length; i++) {
			var rtn = this.findNode(inNode.kids[i], data);
			if (rtn != null) {
				return rtn;
			}
		}
	}, constructEntity:function (entityName, tableName) {
		var otherTypeNode = null;
		var types = this.getDataModelTypeNodes();
		for (var i = 0, j = types.length; i < j; i++) {
			if (types[i].data[1] != entityName) {
				otherTypeNode = types[i];
				break;
			}
		}
		var entity = {};
		if (otherTypeNode == null) {
			entity.packageName = DEFAULT_PACKAGE_ROOT + this.currentDataModelName + DATA_PACKAGE_NAME;
		} else {
			studio.dataService.requestSync("getEntityWithoutProperties", [this.currentDataModelName, otherTypeNode.data[1]], dojo.hitch(this, "gotEntityAsTemplate", entity));
		}
		entity.entityName = entityName;
		if (tableName) {
			entity.tableName = tableName;
		} else {
			entity.tableName = this.getTableNameFromEntityName(entityName);
		}
		return entity;
	}, gotEntityAsTemplate:function (entity, inData) {
		entity.schemaName = inData.schemaName;
		entity.catalogName = inData.catalogName;
		entity.packageName = inData.packageName;
		this.renderTableDetails(entity);
		this.getEntityOutputChanged(entity);
	}, dataObjectSelectionChanged:function (inName, inTable) {
		var d = this.dataObject;
		return d && (d.name != inName || d.table != inTable);
	}, setDataObject:function (inName, inTable) {
		var changed = this.dataObjectSelectionChanged(inName, inTable);
		this.dataObject.name = inName;
		this.dataObject.table = inTable;
		if (changed) {
			this.dataObjectChanged();
		}
	}, getEntityOutputChanged:function (inData) {
		this.columnListVar.beginUpdate();
		this.columnListVar.setData(inData.columns || []);
		this.columnListVar.endUpdate();
		this.columnList.setDataSet(this.columnListVar);
		this.currentEntity = inData;
		this.currentEntityName = inData.entityName;
		this.resetChanges();
	}, dataObjectChanged:function () {
		var d = this.dataObject, n = d.name, t = d.table;
		if (n || t) {
			var getEntityInput = [n || null, t || null];
			studio.dataService.requestSync("getEntity", getEntityInput, dojo.hitch(this, "getEntityResult"));
			studio.dataService.requestSync("getRelated", getEntityInput, dojo.hitch(this, "getRelatedResult"));
		}
	}, getEntityResult:function (inResponse) {
		this.renderTableDetails(inResponse);
		this.getEntityOutputChanged(inResponse);
	}, getRelatedResult:function (inResponse) {
		this.relationshipsList._columns[1].selectOptions = this.getDataModelEntityNames();
		this.relationshipsListVar.beginUpdate();
		this.relationshipsListVar.setData(inResponse || []);
		this.relationshipsListVar.endUpdate();
		this.relationshipsList.setDataSet(this.relationshipsListVar);
	}, typeUpdated:function (inData) {
		var s = this.tree.selected;
		if (!this.isTypeNode(s)) {
			return;
		}
		var p = s.parent;
		p.removeChildren();
		this.tree.renderDataNode(p, inData);
	}, selectRow:function (list, value) {
		for (var i = 0; i < list.dataSet.data.list.length; i++) {
			var it = list.dataSet.getItem(i);
			if (it.getValue("name") == value) {
				list.dijit.selection.select(i);
				break;
			}
		}
	}, isTypeNode:function (inNode) {
		var p = inNode;
		while (p && p.contentNode) {
			if (p.data[0] == ENTITY_ROOT_NODE) {
				return true;
			}
			p = p.parent;
		}
	}, getDataModelEntityNames:function (dataModelName) {
		var types = getDataModelTypeNames(this.tree, this.currentDataModelName, this.valueTypes);
		var allEntityNames = [];
		for (var shortName in types) {
			allEntityNames.push(shortName);
		}
		return allEntityNames;
	}, getTypesNode:function (inNode) {
		return getAnnotatedNode(inNode, ENTITY_ROOT_NODE);
	}, getEntityNode:function (inNode) {
		return getAnnotatedNode(inNode, ENTITY_NODE);
	}, getEntityName:function (inNode) {
		return getNodeData(this.getEntityNode(inNode));
	}, removeDataModelCompleted:function (inSender) {
		studio.endWait();
		studio.updateServices();
		this.setSchemas();
		this.objectPages.setLayer(this.DEFAULT_PAGE);
		this.clearDetailDisplay();
		this.initData();
		studio.application.removeServerComponent(this.dataModel);
		studio.application.loadServerComponents("wm.Query");
		studio.refreshWidgetsTree();
	}, removeDataModelFailed:function (inSender) {
		studio.endWait();
		this.clearDetailDisplay();
		this.initData();
	}, saveRelationships:function (inSender) {
		this.relationshipsList.dijit.edit.apply();
		var relatedProperties = this.getRelatedProperties();
		studio.dataService.requestSync("updateRelated", [this.currentDataModelName, this.tableDetailEntityName.getDataValue(), relatedProperties], dojo.hitch(this, "relUpdateCompleted"), dojo.hitch(this, "relUpdateError"));
	}, detailRelSelect:function (inSender, inItem) {
		this.removeRelButton.setDisabled(false);
	}, detailColDeselect:function (inSender, inItem) {
	}, getRelatedProperties:function () {
		var rtn = [];
		var length = this.relationshipsListVar.getCount();
		for (var i = 0; i < length; i++) {
			var rel = this.relationshipsListVar.getData()[i];
			rel.fullyQualifiedType = this.currentEntity.packageName + "." + rel.relatedType;
			rtn.push(rel);
		}
		return rtn;
	}, addRel:function (inSender) {
		if (this.columnList.dijit.selection.selectedIndex < 0) {
			app.alert("先ず外部キーとして使う列を選択してください。");
			return;
		}
		this.applyGridEdits();
		var existingNames = [];
		var length = this.relationshipsListVar.getCount();
		for (var i = 0; i < length; i++) {
			existingNames.push(this.relationshipsListVar.getItem(i).getValue("name"));
		}
		var newRelName = "rel";
		newRelName = this.findUniqueName(existingNames, newRelName);
		var r = this.columnListVar.getItem(this.columnList.dijit.selection.selectedIndex);
		var newrel = {name:newRelName, relatedType:this.relationshipsList._columns[1].selectOptions[0], cardinality:r.getValue("notNull") ? ONE_TO_ONE : ONE_TO_ZERO_OR_ONE, tableName:this.tableDetailTableName.getDataValue(), columnNames:[r.getValue("name")]};
		this.relationshipsListVar.addItem(newrel);
		this.relationshipsList.setDataSet(this.relationshipsListVar);
		this.columnList.setDataSet(this.columnListVar);
		this.relationshipsChange();
	}, removeRel:function (inSender) {
		var i = this.relationshipsList.dijit.selection.selectedIndex;
		if (i > -1) {
			var l = this.relationshipsListVar.getData();
			this.relationshipsListVar.data.list.splice(i, 1);
			this.relationshipsList.setDataSet(this.relationshipsListVar);
			this.relationshipsChange();
		}
	}, relUpdateCompleted:function (inSender) {
		this.saveAllCompleted();
	}, relUpdateError:function (inError) {
		studio.endWait();
		var msg = "Failed to update related";
		if (inError.message) {
			msg += ": " + inError.message;
		}
		app.alert(msg);
	}, saveAllCompleted:function () {
		this.clearDetailDisplay();
		this.initData();
		this.setForeignKeyOnColumns();
		studio.updateServices();
		studio.endWait();
		this.selectEntityNode();
		studio.refreshWidgetsTree();
		app.toastSuccess("保存しました");
	}, saveColumns:function (inSender) {
		var length = this.columnListVar.getCount();
		for (var i = 0; i < length; i++) {
			var r = this.columnListVar.getItem(i);
			r.setValue(this.FK_ATTR, false);
			this.columnListVar._setItem(i, r.getData());
		}
		this.columnList.dijit.edit.apply();
		var columns = this.columnListVar.getData();
		var entityName = this.tableDetailEntityName.getDataValue();
		for (var i = 0, j = columns.length; i < j; i++) {
			this._resetPrecisionAndLength(columns[i]);
		}
		var props = this.getPropertiesForColumns();
		for (var i = 0, j = props.length; i < j; i++) {
			this._resetPrecisionAndLength(props[i].column);
		}
		studio.dataService.requestSync("updateColumns", [this.currentDataModelName, entityName, columns, props], dojo.hitch(this, "colUpdateCompleted"), dojo.hitch(this, "colUpdateError"));
	}, colUpdateCompleted:function (inSender) {
		this.saveRelationships();
	}, colUpdateError:function (inError) {
		studio.endWait();
		var msg = "Failed to update columns";
		if (inError.message) {
			msg += ": " + inError.message;
		}
		app.alert(msg);
	}, getPropertiesForColumns:function () {
		var n = this.findNode(this.tree.root, this.currentEntityName);
		if (n == null) {
			return [];
		}
		children = n._data.children;
		var rtn = [];
		var i = 0;
		for (var j = 0, z = children.length; j < z; j++) {
			var child = children[j];
			if (child.data[0] == RELATIONSHIP_NODE) {
				continue;
			}
			rtn[i] = {name:null};
			this.populatePropertyInfo(rtn[i], child);
			i++;
		}
		return rtn;
	}, populatePropertyInfo:function (propertyInfo, node) {
		propertyInfo.name = node.data[1];
		if (this.currentPropertyName != null && propertyInfo.name == this.currentPropertyName) {
			propertyInfo.name = this.propertyName.getInputValue();
		}
		propertyInfo.type = node.data[2];
		propertyInfo.fullyQualifiedType = node.data[2];
		if (node.content.indexOf("* ") == 0) {
			propertyInfo.isId = true;
		} else {
			if (node.content.indexOf("> ") == 0) {
				propertyInfo.isRelated = true;
				propertyInfo.isInverse = false;
			} else {
				if (node.content.indexOf("< ") == 0) {
					propertyInfo.isRelated = true;
					propertyInfo.isInverse = true;
				}
			}
		}
		if (node.data[0] == COLUMN_NODE) {
			propertyInfo.column = this.getNamedColumn(node.data[3]);
		}
		if (node.children.length > 0) {
			propertyInfo.compositeProperties = [];
			for (var i in node.children) {
				propertyInfo.compositeProperties[i] = {name:null};
				this.populatePropertyInfo(propertyInfo.compositeProperties[i], node.children[i]);
			}
		}
	}, getNamedColumn:function (columnName) {
		var length = this.columnListVar.getCount();
		for (var i = 0; i < length; i++) {
			var c = this.columnListVar.getData()[i];
			if (c.name == columnName) {
				return c;
			}
		}
		return null;
	}, saveAll:function (inSender) {
		studio.beginWait("Saving " + this.currentDataModelName);
		this.saveEntity();
	}, getEntityNameFromTableName:function (tableName) {
		return tableName.slice(0, 1).toUpperCase() + tableName.slice(1);
	}, getTableNameFromEntityName:function (entityName) {
		return entityName.slice(0, 1).toLowerCase() + entityName.slice(1);
	}, saveEntity:function (inSender) {
		var schemaName = this.tableDetailSchemaName.getDataValue();
		if (!schemaName) {
			schemaName = "";
		}
		var catalogName = this.tableDetailCatalogName.getDataValue();
		if (!catalogName) {
			catalogName = "";
		}
		var t = {entityName:this.tableDetailEntityName.getDataValue(), tableName:this.tableDetailTableName.getDataValue(), schemaName:schemaName, catalogName:catalogName, packageName:this.tableDetailPackageName.getDataValue(), dynamicInsert:this.dynamicInsertCheckBox.components.editor.getChecked(), dynamicUpdate:this.dynamicUpdateCheckBox.components.editor.getChecked(), refreshEntity:this.refreshCheckBox.components.editor.getChecked()};
		this.updateEntity(t);
	}, updateEntity:function (entity) {
		var save = this.onlyEntityIsDirty;
		studio.dataService.requestSync("updateEntity", [this.currentDataModelName, this.currentEntityName, entity, save], dojo.hitch(this, "entityUpdateCompleted", entity), dojo.hitch(this, "entityUpdateError"));
	}, entityUpdateCompleted:function (entity, inSender) {
		this.currentEntity = entity;
		var tn = this.tableDetailTableName.getDataValue();
		var length = this.relationshipsListVar.getCount();
		for (var i = 0; i < length; i++) {
			var rel = this.relationshipsListVar.getData()[i];
			if (rel.cardinality == ONE_TO_ONE || rel.cardinality == ONE_TO_ZERO_OR_ONE) {
				var r = this.relationshipsListVar.getItem(i);
				r.setValue("tableName", tn);
			}
		}
		var saveColumns = this.propertiesAreDirty;
		this.resetChanges();
		if (saveColumns) {
			this.saveColumns();
		} else {
			this.saveAllCompleted();
		}
	}, isDirty:function () {
		return this.onlyEntityIsDirty || this.propertiesAreDirty;
	}, entityUpdateError:function (inError) {
		studio.endWait();
		if (inError.message) {
			app.alert("Failed to update entity: " + inError.message);
		}
	}, detailColSelect:function (inSender, inItem) {
		this.addRelButton.setDisabled(false);
	}, detailColDeselect:function (inSender, inItem) {
		this.addRelButton.setDisabled(true);
	}, pagesCanChange:function () {
	}, findUniqueName:function (existingNames, newName) {
		var l = {};
		dojo.forEach(existingNames, function (p) {
			l[p] = true;
		});
		return wm.findUniqueName(newName, [l]);
	}, findUniqueEntityName:function () {
		return this.findUniqueName(this.getDataModelEntityNames(), "Table");
	}, addButtonClick:function (inSender) {
		if (this._askAboutLosingChanges()) {
			return;
		}
		var types = this.getDataModelTypeNodes();
		var newEntityName = this.findUniqueEntityName();
		app.prompt("New table name", this.getTableNameFromEntityName(this.findUniqueEntityName()), dojo.hitch(this, function (t) {
			var entity = this.constructEntity(this.getEntityNameFromTableName(t), t);
			this.clearDetailDisplay();
			this.renderTableDetails(entity);
			this.getEntityOutputChanged(entity);
			this.addColumn("id", true, false, true, DEFAULT_COL_LENGTH, DEFAULT_COL_PRECISION, IDENTITY_GENERATOR, HIBERNATE_INT_TYPE);
			this.saveAll();
		}));
	}, newDataModelError:function (inError) {
		studio.endWait();
		if (inError.message) {
			app.alert("Failed to create datamodel: " + inError.message);
		}
		this.initData();
	}, newDataModelResult:function () {
		studio.endWait();
		this.clearDetailDisplay();
		this.pages.setLayer("objectquery");
		this.initData();
		studio.updateServices();
		this.setSchemas();
	}, addColumn:function (name, isPk, isFk, notNull, length, precision, generator, sqlType) {
		var newcol = {name:name, isPk:isPk, isFk:isFk, notNull:notNull, length:length, precision:precision, generator:generator, sqlType:sqlType};
		this.columnListVar.addItem(newcol);
		this.columnList.setDataSet(this.columnListVar);
		this.columnsChange();
	}, removeButtonClick:function (inSender) {
		var dmn = this.currentDataModelName;
		var c = studio.tree.selected && studio.tree.selected.component;
		if (!c) {
			app.alert("Please select an entity or a data model to delete.");
			return;
		}
		if (c instanceof wm.DataModel) {
			app.confirm("Are you sure you want to delete data model \"" + dmn + "\"?", false, dojo.hitch(this, function () {
				studio.beginWait("Removing " + dmn);
				studio.dataService.requestAsync("removeDataModel", [dmn], dojo.hitch(this, "removeDataModelCompleted"), dojo.hitch(this, "removeDataModelFailed"));
			}));
		} else {
			var n = c.entityName;
			app.confirm("Are you sure you want to delete entity \"" + n + "\"?", false, dojo.hitch(this, function () {
				var types = this.getDataModelTypeNodes();
				if (types == null) {
					return;
				}
				for (var i in types) {
					var t = types[i];
					if (t.data[0] == ENTITY_NODE && t.data[1] == n) {
						studio.beginWait("Removing " + n);
						studio.dataService.requestAsync("deleteEntity", [dmn, n], dojo.hitch(this, "deleteEntityCompleted"), dojo.hitch(this, "deleteEntityFailed"));
						return;
					}
				}
			}));
		}
	}, deleteEntityCompleted:function () {
		studio.endWait();
		this.clearDetailDisplay();
		this.initData();
		this.expandCurrentTypesNode();
		this.saveAllCompleted();
	}, deleteEntityFailed:function () {
		studio.endWait();
	}, applyGridEdits:function () {
		this.columnList.dijit.edit.apply();
		this.relationshipsList.dijit.edit.apply();
	}, addColButtonClick:function (inSender) {
		this.applyGridEdits();
		var defaultIsPk = true;
		var existingNames = [];
		var length = this.columnListVar.getCount();
		for (var i = 0; i < length; i++) {
			if (this.columnListVar.getItem(i).getValue(this.PK_ATTR) == true) {
				defaultIsPk = false;
			}
			existingNames.push(this.columnListVar.getItem(i).getValue("name"));
		}
		var newColName = "newcol";
		newColName = this.findUniqueName(existingNames, newColName);
		this.addColumn(newColName, defaultIsPk, false, true, DEFAULT_COL_LENGTH, DEFAULT_COL_PRECISION, "", HIBERNATE_INT_TYPE);
	}, removeCol:function (inSender) {
		var i = this.columnList.dijit.selection.selectedIndex;
		if (i == -1) {
			return;
		}
		if (this.columnListVar.getData()[i].isFk) {
			app.alert("Please delete the relationship using this " + "foreign key column first");
			return;
		}
		this.columnListVar.data.list.splice(i, 1);
		this.columnList.setDataSet(this.columnListVar);
		this.columnsChange();
	}, getDataModelTypeNodes:function () {
		var name = this.currentDataModelName;
		return getDataModelTypeNodes(this.tree, name);
	}, setForeignKeyOnColumns:function () {
		var fkColIndicies = [];
		var length = this.relationshipsListVar.getCount();
		for (var i = 0; i < length; i++) {
			var rel = this.relationshipsListVar.getData()[i];
			for (var j in rel.columnNames) {
				var fkName = rel.columnNames[j];
				var k = this.setFkOnColumn(fkName);
				if (k) {
					fkColIndicies.push(k);
				}
			}
		}
		var length = this.columnListVar.getCount();
		for (var i = 0; i < length; i++) {
			if (dojo.indexOf(fkColIndicies, i) == -1) {
				var c = this.columnListVar.getItem(i);
				c.setValue(this.FK_ATTR, false);
			}
		}
	}, setFkOnColumn:function (colName) {
		var length = this.columnListVar.getCount();
		for (var i = 0; i < length; i++) {
			var c = this.columnListVar.getData()[i];
			if (c.name == colName) {
				var r = this.columnListVar.getItem(i);
				r.setValue(this.FK_ATTR, true);
				return i;
			}
		}
	}, resetSelection:function () {
		this.dataObject = {name:"", table:""};
	}, columnListCanEdit:function (inSender, ioEdit, inCell, inRowIndex) {
		if (inCell.index < 7) {
			ioEdit.canEdit = true;
			return;
		}
		var row = this.columnListVar.getItem(inRowIndex);
		ioEdit.canEdit = row.getValue(this.PK_ATTR);
	}, _setCurrentPropertyName:function (inNode) {
		this.currentPropertyName = inNode.data[1];
		this.propertyName.setInputValue(this.currentPropertyName);
	}, _selectNode:function () {
		selectFirstChildNode(this.tree);
	}, _askAboutLosingChanges:function () {
		if (this.isDirty()) {
			if (!askSaveChanges()) {
				this.tree._select(this.lastSelectedNode);
				return true;
			}
			this.resetChanges();
		}
		return false;
	}, _resetPrecisionAndLength:function (column) {
		if (column == null) {
			return;
		}
		if (column.length == "") {
			column.length = null;
		}
		if (column.precision == "") {
			column.precision = null;
		}
	}, _end:0});
}
if (!dojo._hasResource["wm.studio.pages.DBConnectionSettings.DBConnectionSettings"]) {
	dojo._hasResource["wm.studio.pages.DBConnectionSettings.DBConnectionSettings"] = true;
	dojo.provide("wm.studio.pages.DBConnectionSettings.DBConnectionSettings");
	dojo.declare("DBConnectionSettings", wm.Page, {msgDialog:null, ip:null, start:function () {
		this.msgDialog = new wm.PageDialog({owner:app, pageName:"DDLDialog", hideControls:true});
		this.msgDialog.connect(this.msgDialog, "onPageReady", this, "_updateDDL");
		this.msgDialogLoaded = true;
		initDBTypeDropdown(this.conDBdropdown);
		studio.runtimeService.requestAsync(LOAD_IP_OP, [], dojo.hitch(this, "_loadedIP"));
		this.setup();
		this._enableAll(false);
	}, setup:function () {
		studio.dataService.requestAsync(LOAD_DATA_MODEL_NAMES_OP, [], dojo.hitch(this, "_loadedDataModelNames"));
	}, testConnectionBtnClick:function (inSender) {
		this._testConnection(this.conConnectionUrlInput.getInputValue(), this.conUserInput.getInputValue(), this.conPasswordInput.getInputValue(), this.conDriverClassInput.getInputValue());
	}, reimportBtnClick:function (inSender) {
		var dmn = this._getSelectedDataModelName();
		app.confirm("Are you sure you want to re-import " + dmn + "?", false, dojo.hitch(this, function () {
			studio.beginWait("Re-Importing " + dmn);
			studio.dataService.requestAsync(REIMPORT_DB_OP, [dmn, this.conUserInput.getInputValue(), this.conPasswordInput.getInputValue(), this.conConnectionUrlInput.getInputValue(), this.conTablePatternInput.getInputValue(), this.conSchemaPatternInput.getInputValue(), this.conDriverClassInput.getInputValue(), this.conDialectInput.getInputValue(), this.conRevengNamingStrategyInput.getInputValue()], dojo.hitch(this, "_reImportResult"), dojo.hitch(this, "_reImportError"));
		}));
	}, exportBtnClick:function (inSender) {
		if (this.overrideFlagInput.getDataValue()) {
			if (!confirm("WARNING: If this database already exists, all tables and data will be dropped and deleted. A shiny new database will be created if it does not exist. Do you want to continue?")) {
				return;
			}
		}
		studio.beginWait("DDLの読込み中...");
		studio.dataService.requestAsync(LOAD_DDL_OP, [this._getSelectedDataModelName(), this.conUserInput.getInputValue(), this.conPasswordInput.getInputValue(), this.conConnectionUrlInput.getInputValue(), this.conSchemaPatternInput.getInputValue(), this.conDriverClassInput.getInputValue(), this.conDialectInput.getInputValue(), this.overrideFlagInput.getDataValue(), ], dojo.hitch(this, "_getDDLResult"), dojo.hitch(this, "_getDDLError"));
	}, saveBtnClick:function (inSender) {
		var input = {username:this.conUserInput.getInputValue(), password:this.conPasswordInput.getInputValue(), connectionUrl:this.conConnectionUrlInput.getInputValue(), driverClassName:this.conDriverClassInput.getInputValue(), dialect:this.conDialectInput.getInputValue(), tableFilter:this.conTablePatternInput.getInputValue(), schemaFilter:this.conSchemaPatternInput.getInputValue(), reverseNamingStrategy:this.conRevengNamingStrategyInput.getInputValue()};
		studio.setLiveLayoutReady(false);
		studio.dataService.requestAsync(SAVE_CONNECTION_PROPS_OP, [this._getSelectedDataModelName(), input], dojo.hitch(this, "_propWriteOk"), dojo.hitch(this, "_propWriteFailed"));
	}, cancelBtnClick:function (inSender) {
		wm.dismiss(inSender);
	}, dataModelListSelect:function (inSender, inItem) {
		this._enableAll(true);
		var n = this._getSelectedDataModelName();
		this._loadConnectionProperties(n);
	}, onConUsernameKeyPress:function () {
		setTimeout(dojo.hitch(this, "conUsernameChanged"), 0);
	}, conUsernameChanged:function () {
		var db = this.conDBdropdown.getDisplayValue();
		var username = this.conUserInput.getInputValue();
		this._updateSchemaFilter(db, username, this.conSchemaPatternInput);
	}, onConPasswordKeyPress:function () {
		setTimeout(dojo.hitch(this, "conPasswordChanged"), 0);
	}, conPasswordChanged:function () {
	}, conDBdropdownChanged:function (inSender, inValue) {
		setupWidgetsForDatabaseType(inValue, this.ip, this.conHostLabel, this.conHostInput, this.conPortLabel, this.conPortInput, this.conExtraInputLabel, this.conExtraInput, this.conExtra2InputLabel, this.conExtra2Input, this.conTablePatternInput, this.conSchemaPatternInput);
		this.conDriverClassInput.setInputValue("");
		this.conDialectInput.setInputValue("");
		this.conRevengNamingStrategyInput.setInputValue("");
		this._updateConConnectionUrl();
		this.conUsernameChanged();
	}, onConHostKeyPress:function (inSender) {
		setTimeout(dojo.hitch(this, "conHostChanged", inSender), 0);
	}, conHostChanged:function (inSender) {
		this._updateConConnectionUrl();
		this.connectionSettingsChanged = true;
	}, onConPortKeyPress:function () {
		setTimeout(dojo.hitch(this, "conPortChanged"), 0);
	}, conPortChanged:function () {
		this._updateConConnectionUrl();
	}, onConExtraKeyPress:function () {
		setTimeout(dojo.hitch(this, "conExtraChanged"), 0);
	}, conExtraChanged:function () {
		this._updateConConnectionUrl();
	}, onConExtra2KeyPress:function () {
		setTimeout(dojo.hitch(this, "conExtra2Changed"), 0);
	}, conExtra2Changed:function () {
		this._updateConConnectionUrl();
	}, onConConnectionUrlKeyPress:function () {
		setTimeout(dojo.hitch(this, "conConnectionUrlChanged"), 0);
	}, conConnectionUrlChanged:function () {
		this.connectionSettingsChanged = true;
	}, onConTablePatternKeyPress:function () {
		setTimeout(dojo.hitch(this, "conTablePatternChanged"), 0);
	}, conTablePatternChanged:function () {
	}, onConSchemaPatternKeyPress:function () {
		setTimeout(dojo.hitch(this, "conSchemaPatternChanged"), 0);
	}, conSchemaPatternChanged:function () {
	}, onConDriverClassKeyPress:function () {
		setTimeout(dojo.hitch(this, "conDriverClassChanged"), 0);
	}, conDriverClassChanged:function () {
	}, onConDialectKeyPress:function () {
		setTimeout(dojo.hitch(this, "conDialectChanged"), 0);
	}, conDialectChanged:function () {
	}, onConRevengKeyPress:function () {
		setTimeout(dojo.hitch(this, "conRevengChanged"), 0);
	}, conRevengChanged:function () {
	}, onDDLOkClicked:function () {
		studio.beginWait("Exporting Database...");
		studio.dataService.requestAsync(EXPORT_DB_OP, [this._getSelectedDataModelName(), this.conUserInput.getInputValue(), this.conPasswordInput.getInputValue(), this.conConnectionUrlInput.getInputValue(), this.conSchemaPatternInput.getInputValue(), this.conDriverClassInput.getInputValue(), this.conDialectInput.getInputValue(), this.conRevengNamingStrategyInput.getInputValue(), this.overrideFlagInput.getDataValue(), ], dojo.hitch(this, "_exportResult"), dojo.hitch(this, "_exportError"));
	}, onDDLCancelClicked:function () {
	}, overrideFlagInputChanged:function () {
		var checked = this.overrideFlagInput.getDataValue();
		var dbtype = this.conDBdropdown.getDisplayValue();
		var h = this.conHostInput.getInputValue();
		var p = this.conPortInput.getInputValue();
		var e = this.conExtraInput.getInputValue();
		var e2 = checked;
		var s = buildConnectionUrl(dbtype, h, p, e, e2);
		this.conConnectionUrlInput.setInputValue(s);
	}, _updateSchemaFilter:function (dbtype, username, schemaFilterInput) {
		if (isOracle(dbtype) || isDB2(dbtype)) {
			schemaFilterInput.setInputValue(username.toUpperCase());
		}
	}, _updateConConnectionUrl:function () {
		var dbtype = this.conDBdropdown.getDisplayValue();
		var h = this.conHostInput.getInputValue();
		var p = this.conPortInput.getInputValue();
		var e = this.conExtraInput.getInputValue();
		var e2;
		if (isHSQLDB(dbtype)) {
			e2 = this.overrideFlagInput.getDataValue();
		} else {
			e2 = this.conExtra2Input.getInputValue();
		}
		var s = buildConnectionUrl(dbtype, h, p, e, e2);
		this.conConnectionUrlInput.setInputValue(s);
	}, _loadedDataModelNames:function (inDataModelNames) {
		this.dataModelList._data = inDataModelNames;
		this.dataModelList._render();
		if (inDataModelNames.length == 0) {
			this._loadedConnectionProperties(null);
			this._enableAll(false);
		} else {
			this.dataModelList.selectByIndex(0);
			this.dataModelListSelect();
		}
	}, _loadedConnectionProperties:function (inData) {
		this.conHostInput.setInputValue("");
		this.conPortInput.setInputValue("");
		this.conExtraInput.setInputValue("");
		this.conExtra2Input.setInputValue("");
		this.conUserInput.setInputValue("");
		this.conPasswordInput.setInputValue("");
		this.conConnectionUrlInput.setInputValue("");
		this.conTablePatternInput.setInputValue("");
		this.conSchemaPatternInput.setInputValue("");
		this.conDriverClassInput.setInputValue("");
		this.conDialectInput.setInputValue("");
		this.conRevengNamingStrategyInput.setInputValue("");
		if (inData == null || inData.length == 0) {
			return;
		}
		var l = parseConnectionUrl(inData.connectionUrl, inData);
		if (l == null) {
			this.conDBdropdown.setDisplayValue(" ");
			this.conHostInput.parent.setShowing(false);
			this.conPortInput.parent.setShowing(false);
			this.conExtraInputLabel.setCaption("");
			this.conExtraInput.setShowing(false);
			this.conExtra2InputLabel.setCaption("");
			this.conExtra2Input.setShowing(false);
		} else {
			this.conDBdropdown.setDisplayValue(l[0]);
			setupWidgetsForDatabaseType(l[0], this.ip, this.conHostLabel, this.conHostInput, this.conPortLabel, this.conPortInput, this.conExtraInputLabel, this.conExtraInput, this.conExtra2InputLabel, this.conExtra2Input, this.conTablePatternInput, this.conSchemaPatternInput);
			if (l[1] == null) {
				this.conHostInput.setInputValue("");
			} else {
				this.conHostInput.setInputValue(l[1]);
			}
			if (l[2] == null) {
				this.conPortInput.setInputValue("");
			} else {
				this.conPortInput.setInputValue(l[2]);
			}
			if (l[3] == null) {
				this.conExtraInput.setInputValue("");
			} else {
				this.conExtraInput.setInputValue(l[3]);
			}
			if (l[4] == null) {
				this.conExtra2Input.setInputValue("");
			} else {
				this.conExtra2Input.setInputValue(l[4]);
			}
		}
		this.conUserInput.setInputValue(inData.username);
		this.conPasswordInput.setInputValue(inData.password);
		this.conConnectionUrlInput.setInputValue(buildInitialCxnUrl(l[0], l[3], inData.connectionUrl, this.overrideFlagInput.getDataValue()));
		this.conTablePatternInput.setInputValue(inData.tableFilter);
		this.conSchemaPatternInput.setInputValue(inData.schemaFilter);
		this.conDriverClassInput.setInputValue(inData.driverClassName);
		this.conDialectInput.setInputValue(inData.dialect);
		var rns = inData.reverseNamingStrategy;
		this.conRevengNamingStrategyInput.setInputValue(rns);
	}, _loadedIP:function (inData) {
		this.ip = inData;
	}, _testConnection:function (url, username, password, driverClassName) {
		studio.beginWait("Test Connection: " + url);
		studio.dataService.requestAsync(TEST_CONNECTION_OP, [username, password, url, driverClassName], dojo.hitch(this, "_connectionSucceeded"), dojo.hitch(this, "_connectionFailed"));
	}, _connectionSucceeded:function () {
		studio.endWait();
		app.alert("Connection successful");
	}, _connectionFailed:function (inError) {
		studio.endWait();
		app.alert("Connection failed: " + inError.message);
	}, _propWriteOk:function (inData) {
		app.alert("Updated connection properties");
	}, _propWriteFailed:function (inData) {
		app.alert("Failed to update connection properties");
	}, _getSelectedDataModelName:function () {
		var i = this.dataModelList.selected.index;
		return this.dataModelList._data[i];
	}, _reImportError:function (inError) {
		studio.endWait();
		var msg = "";
		if (inError.message) {
			msg = ": " + inError.message;
		}
		app.alert("Re-Import failed " + msg);
	}, _reImportResult:function () {
		studio.endWait();
		studio.updateServices();
		studio.application.loadServerComponents("wm.Query");
		wm.fire(studio.getEditor("DataObjectsEditor").page, "update");
		wm.fire(studio.getEditor("QueryEditor").page, "update");
	}, _getDDLResult:function (inData) {
		studio.endWait();
		this.msgDialog.ddl = inData;
		this.msgDialog.show();
		if (this.msgDialogLoaded) {
			this._updateDDL();
		}
	}, _getDDLError:function (inError) {
		studio.endWait();
		var msg = "";
		if (inError.message) {
			msg = ": " + inError.message;
		}
		app.alert("Unable to load DDL " + msg);
	}, _updateDDL:function () {
		this.msgDialog.page.setup(true);
		this.msgDialog.page.ddlEditor.setInputValue(this.msgDialog.ddl);
		this.msgDialog.page.dataObjectEditor = this;
		this.msgDialogLoaded = true;
	}, _exportResult:function (inData) {
		studio.endWait();
		var n = this._getSelectedDataModelName();
		this._loadConnectionProperties(n);
		if (inData != "") {
			this.msgDialog.page.setup(false);
			this.msgDialog.page.ddlEditor.setInputValue(inData);
			this.msgDialog.show();
		}
	}, _exportError:function (inError) {
		studio.endWait();
		var msg = "";
		if (inError.message) {
			msg = ": " + inError.message;
		}
		app.alert("Unable to export " + msg);
	}, _loadConnectionProperties:function (dataModelName) {
		studio.dataService.requestAsync(LOAD_CONNECTION_PROPS_OP, [dataModelName], dojo.hitch(this, "_loadedConnectionProperties"));
	}, _enableAll:function (enable) {
		this.conUserInput.setDisabled(!enable);
		this.conPasswordInput.setDisabled(!enable);
		this.conDBdropdown.setDisabled(!enable);
		this.conHostInput.setDisabled(!enable);
		this.conPortInput.setDisabled(!enable);
		this.conExtraInput.setDisabled(!enable);
		this.conExtra2Input.setDisabled(!enable);
		this.conConnectionUrlInput.setDisabled(!enable);
		this.conTablePatternInput.setDisabled(!enable);
		this.conSchemaPatternInput.setDisabled(!enable);
		this.conDriverClassInput.setDisabled(!enable);
		this.conDialectInput.setDisabled(!enable);
		this.conRevengNamingStrategyInput.setDisabled(!enable);
		this.testConnectionBtn.setDisabled(!enable);
		this.saveBtn.setDisabled(!enable);
		this.reimportBtn.setDisabled(!enable);
		this.exportBtn.setDisabled(!enable);
	}, _end:0});
}
if (!dojo._hasResource["wm.studio.pages.DDLDialog.DDLDialog"]) {
	dojo._hasResource["wm.studio.pages.DDLDialog.DDLDialog"] = true;
	dojo.provide("wm.studio.pages.DDLDialog.DDLDialog");
	dojo.declare("DDLDialog", wm.Page, {showDDL:false, start:function () {
	}, setup:function (showDDL) {
		this.showDDL = showDDL;
		if (this.showDDL) {
			this.label1.setCaption("Are you sure you want to export the data model to your database?<br>Running the following DDL will cause tables to get dropped and you will lose data.");
		} else {
			this.label1.setCaption("Export Messages");
		}
	}, onOk:function () {
		this.owner.owner.dismiss();
		if (this.showDDL) {
			this.dataObjectEditor.onDDLOkClicked();
		}
	}, onCancel:function () {
		this.owner.owner.dismiss();
		if (this.showDDL) {
			this.dataObjectEditor.onDDLCancelClicked();
		}
	}, _end:0});
}
if (!dojo._hasResource["wm.studio.pages.DeploymentDialog.DeploymentDialog"]) {
	dojo._hasResource["wm.studio.pages.DeploymentDialog.DeploymentDialog"] = true;
	dojo.provide("wm.studio.pages.DeploymentDialog.DeploymentDialog");
	dojo.declare("DeploymentDialog", wm.Part, {JNDI_NAME_PROPERTY:".jndi.dsname", PROP_PREFIX:"com.wavemaker.tools.deployment.ServiceDeploymentManager", accessKeyId:null, secretAccessKey:null, deployOpt:null, ec2InstanceJsonStr:null, ec2InstanceId:null, ec2InstanceInfo:null, myAMI:"ami-21779c48", s3BucketJsonStr:null, warFile:null, bucketName:null, connHandle_showEC2HostList:null, connHandle_setHostList:null, connHandle_showS3BucketList:null, start:function () {
		this.jndiNames = {};
		this.deploymentTarget = null;
		this.currentEditors = [];
		this.dataModelNames = [];
	}, setup:function () {
		this._setDataTypes();
		this._reset();
		this.useJNDICheckbox.components.editor.setChecked(false);
		this.jndiEditor.setDataValue("");
		studio.dataService.requestAsync(LOAD_DATA_MODEL_NAMES_OP, [], dojo.hitch(this, "_dataModelNamesCallback"));
		studio.studioService.requestAsync("getProperties", [this.PROP_PREFIX], dojo.hitch(this, "_getPropertiesResult"));
		studio.deploymentService.requestAsync("getDeploymentTargetNames", [], dojo.hitch(this, "_getDeploymentTargetNamesResult"));
		this.contextRoot.setDataValue(studio.project.projectName);
	}, useJNDICheckboxChange:function (inSender, inDisplayValue, inDataValue) {
		this.jndiEditor.setDisabled(!inDataValue);
		this.dbtypeEditor.setDisabled(inDataValue);
		this.hostEditor.setDisabled(inDataValue);
		this.portEditor.setDisabled(inDataValue);
		if (!inDataValue) {
			this.jndiEditor.setDataValue("");
		}
	}, dataModelListSelect:function (inSender, inItem) {
		this._dataModelListSelect(true);
	}, okButtonClick:function (inSender) {
		this._saveJNDIName();
		this.owner.owner.dismiss();
		this.studio.onDeployOkClicked(this._prepareJNDINames());
		this._reset();
	}, cancelButtonClick:function (inSender) {
		this._reset();
		this.owner.owner.dismiss();
	}, listAppsButtonClick:function (inSender) {
		this._loadDeployedApps();
	}, deployButtonClick:function (inSender) {
		var cr = this._getContextRoot();
		if (cr == null) {
			return;
		}
		var v = [this.deploymentTarget, cr, this._getProperties()];
		studio.beginWait("Deploying...");
		studio.deploymentService.requestAsync("deploy", v, dojo.hitch(this, "_deployed"), dojo.hitch(this, "_svcError"));
	}, undeployButtonClick:function (inSender) {
		var cr = this._getContextRoot();
		if (cr == null) {
			return;
		}
		var v = [this.deploymentTarget, cr, this._getProperties()];
		studio.beginWait("Undeploying...");
		studio.deploymentService.requestAsync("undeploy", v, dojo.hitch(this, "_undeployed"), dojo.hitch(this, "_svcError"));
	}, redeployButtonClick:function (inSender) {
		var cr = this._getContextRoot();
		if (cr == null) {
			return;
		}
		var v = [this.deploymentTarget, cr, this._getProperties()];
		studio.beginWait("Redeploying...");
		studio.deploymentService.requestAsync("redeploy", v, dojo.hitch(this, "_redeployed"), dojo.hitch(this, "_svcError"));
	}, deploymentTargetSelectChange:function (inSender, inDisplayValue, inDataValue) {
		if (inDataValue == "") {
			return;
		}
		this.deploymentTarget = inDataValue;
		if (inDataValue == "deploy2EC2" || inDataValue == "deploy2RightScale") {
			if (!this.ec2Dialog) {
				var props = {owner:studio, pageName:"EC2Dialog", hideControls:true};
				this.ec2Dialog = new wm.PageDialog(props);
				this.ec2Dialog.setContainerOptions(true, 370, 145);
				dojo.connect(this.ec2Dialog.eC2Dialog, "okButtonClick", this, "_getParms");
			}
			this.ec2Dialog.show();
		} else {
			studio.deploymentService.request("getConfigurableProperties", [inDataValue], dojo.hitch(this, "_loadedDeploymentOptions"), dojo.hitch(this, "_svcError"));
		}
	}, _getParms:function () {
		this.accessKeyId = this.ec2Dialog.eC2Dialog.accessKeyId.getDataValue();
		this.secretAccessKey = this.ec2Dialog.eC2Dialog.secretAccessKey.getDataValue();
		if (this.accessKeyId == undefined || this.accessKeyId == null || this.accessKeyId == "" || this.secretAccessKey == undefined || this.secretAccessKey == null || this.secretAccessKey == "") {
			return;
		}
		if (this.deploymentTarget == "deploy2EC2") {
			this.connHandle_showEC2HostList = dojo.connect(this, "_saveEC2InstanceJsonStr", this, "_showEC2HostList");
			studio.deploymentService.request("getEC2InstanceInfo", [this.deploymentTarget, this.myAMI, this.accessKeyId, this.secretAccessKey], dojo.hitch(this, "_saveEC2InstanceJsonStr"), dojo.hitch(this, "_svcError"));
		} else {
			this.connHandle_showS3BucketList = dojo.connect(this, "_saveS3BucketJsonStr", this, "_showS3BucketList");
			studio.deploymentService.request("getS3BucketInfo", [this.deploymentTarget, this.accessKeyId, this.secretAccessKey], dojo.hitch(this, "_saveS3BucketJsonStr"), dojo.hitch(this, "_svcError"));
		}
	}, _showEC2HostList:function () {
		if (!this.ec2HostDialog) {
			var props = {owner:studio, pageName:"EC2HostList", hideControls:true};
			this.ec2HostDialog = new wm.PageDialog(props);
			this.ec2HostDialog.setContainerOptions(true, 750, 160);
			dojo.connect(this.ec2HostDialog.eC2HostList, "okButtonClick", this, "_getParms1");
			dojo.connect(this.ec2HostDialog.eC2HostList, "dismissToContinue", this, "_getEC2Config1");
			dojo.connect(this.ec2HostDialog.eC2HostList, "newButtonClick", this, "_launchEC2Instance");
			dojo.connect(this.ec2HostDialog.eC2HostList, "terminateButtonClick", this, "_terminateEC2Instance");
		}
		if (this.ec2HostDialog.page) {
			this._setHostList();
		}
		this.ec2HostDialog.show();
		dojo.disconnect(this.connHandle_showEC2HostList);
	}, _showS3BucketList:function () {
		if (!this.s3BucketList) {
			var props = {owner:studio, pageName:"S3BucketList", hideControls:true};
			this.s3BucketList = new wm.PageDialog(props);
			this.s3BucketList.setContainerOptions(true, 750, 160);
			dojo.connect(this.s3BucketList.s3BucketList, "copyWarButtonClick", this, "_copyWarFileToS3");
			dojo.connect(this.s3BucketList.s3BucketList, "deleteWarButtonClick", this, "_deleteWarFileInS3");
			this.connHandle_showS3BucketDialog = dojo.connect(this.s3BucketList.s3BucketList, "newButtonClick", this, "_showS3BucketDialog");
			dojo.connect(this.s3BucketList.s3BucketList, "deleteButtonClick", this, "_deleteS3Bucket");
		}
		if (this.s3BucketList.page) {
			this._setBucketList();
		}
		this.s3BucketList.show();
		dojo.disconnect(this.connHandle_showS3BucketList);
	}, _showS3BucketDialog:function () {
		if (!this.s3BucketDialog) {
			var props = {owner:studio, pageName:"S3BucketDialog", hideControls:true};
			this.s3BucketDialog = new wm.PageDialog(props);
			this.s3BucketDialog.setContainerOptions(true, 390, 140);
			dojo.connect(this.s3BucketDialog.s3BucketDialog, "okButtonClick", this, "_createS3Bucket");
		}
		this.s3BucketDialog.show();
		this.s3BucketDialog.s3BucketDialog.locName.setDataValue("Default");
	}, _getParms1:function () {
		this.ec2InstanceInfo = this.ec2HostDialog.eC2HostList.hostList.getDisplayValue();
	}, _saveEC2InstanceJsonStr:function (inData) {
		this.ec2InstanceJsonStr = inData;
	}, _saveS3BucketJsonStr:function (inData) {
		this.s3BucketJsonStr = inData;
	}, _saveEC2InstanceJsonStr1:function (inData) {
		app.alert("Succesfully terminated the instance, Id = " + this.ec2InstanceId);
		this.ec2InstanceJsonStr = inData;
		this._setHostList();
	}, _setHostList:function () {
		this.ec2HostDialog.eC2HostList.hostNames.setJson(this.ec2InstanceJsonStr);
		this.ec2HostDialog.eC2HostList.hostList.editor.setDataSet(this.ec2HostDialog.eC2HostList.hostNames);
		dojo.disconnect(this.connHandle_setHostList);
	}, _launchEC2Instance:function () {
		studio.beginWait("It may take several minutes to acquire an EC2 Instance. Please wait...");
		studio.deploymentService.request("launchEC2Instance", [this.deploymentTarget, this.myAMI, this.accessKeyId, this.secretAccessKey], dojo.hitch(this, "_postLaunch"), dojo.hitch(this, "_svcError"));
	}, _postLaunch:function (inData) {
		studio.endWait();
		app.alert("Succesfully launched a new instance, Id = " + inData);
		this.connHandle_setHostList = dojo.connect(this, "_saveEC2InstanceJsonStr", this, "_setHostList");
		studio.deploymentService.request("getEC2InstanceInfo", [this.deploymentTarget, this.myAMI, this.accessKeyId, this.secretAccessKey], dojo.hitch(this, "_saveEC2InstanceJsonStr"), dojo.hitch(this, "_svcError"));
	}, _getEC2Config1:function () {
		studio.deploymentService.request("getConfigurableProperties", [this.deploymentTarget, this.ec2InstanceInfo, this.accessKeyId, this.secretAccessKey], dojo.hitch(this, "_loadedDeploymentOptions"), dojo.hitch(this, "_svcError"));
	}, _terminateEC2Instance:function () {
		this.ec2InstanceId = this.ec2HostDialog.eC2HostList.hostList.getDataValue();
		if (this.ec2InstanceId == null || this.ec2InstanceId == undefined || this.ec2InstanceId == "") {
			return;
		}
		studio.deploymentService.request("terminateEC2Instance", [this.deploymentTarget, this.ec2InstanceId, "ami-21779c48", this.accessKeyId, this.secretAccessKey], dojo.hitch(this, "_saveEC2InstanceJsonStr1"), dojo.hitch(this, "_svcError"));
		this._setHostList();
	}, _createS3Bucket:function () {
		this.bucketName = this.s3BucketDialog.s3BucketDialog.bucket.getDataValue();
		var locName = this.s3BucketDialog.s3BucketDialog.locName.getDataValue();
		studio.deploymentService.request("createS3Bucket", [this.deploymentTarget, this.bucketName, locName, this.accessKeyId, this.secretAccessKey], dojo.hitch(this, "_postCreateS3Bucket"), dojo.hitch(this, "_svcError"));
	}, _postCreateS3Bucket:function (inData) {
		if (this.s3BucketDialog) {
			this.s3BucketDialog.dismiss();
		}
		app.alert("Succesfully created a new S3 bucket, name = " + this.bucketName);
		this.s3BucketJsonStr = inData;
		this._setBucketList();
	}, _deleteS3Bucket:function () {
		this.bucketName = this.s3BucketList.s3BucketList.bucketList.getDataValue();
		studio.deploymentService.request("deleteS3Bucket", [this.deploymentTarget, this.bucketName, this.accessKeyId, this.secretAccessKey], dojo.hitch(this, "_postDeleteS3Bucket"), dojo.hitch(this, "_svcError"));
	}, _postDeleteS3Bucket:function (inData) {
		app.alert("Succesfully deleted S3 bucket, name = " + this.bucketName);
		this.s3BucketJsonStr = inData;
		this._setBucketList();
	}, _setBucketList:function () {
		this.s3BucketList.s3BucketList.bucketNames.setJson(this.s3BucketJsonStr);
		this.s3BucketList.s3BucketList.bucketList.editor.setDataSet(this.s3BucketList.s3BucketList.bucketNames);
	}, _copyWarFileToS3:function () {
		this.bucketName = this.s3BucketList.s3BucketList.bucketList.getDataValue();
		if (this.bucketName == null || this.bucketName == undefined || this.bucketName == "") {
			return;
		}
		studio.beginWait("It may take several minutes to upload the WAR file to S3. Please wait...");
		studio.deploymentService.request("copyWarFileToS3", [this.deploymentTarget, this.bucketName, this.accessKeyId, this.secretAccessKey], dojo.hitch(this, "_postCopyWarFile"), dojo.hitch(this, "_svcError"));
	}, _postCopyWarFile:function (inData) {
		studio.endWait();
		app.alert("WAR file " + inData.toString() + " has been uploaded to S3 bucket " + this.bucketName);
	}, _deleteWarFileInS3:function () {
		this.bucketName = this.s3BucketList.s3BucketList.bucketList.getDataValue();
		if (this.bucketName == null || this.bucketName == undefined || this.bucketName == "") {
			return;
		}
		studio.deploymentService.request("deleteWarFileInS3", [this.deploymentTarget, this.bucketName, this.accessKeyId, this.secretAccessKey], dojo.hitch(this, "_postDeleteWarFile"), dojo.hitch(this, "_svcError"));
	}, _postDeleteWarFile:function (inData) {
		studio.endWait();
		app.alert("WAR file " + inData.toString() + " in S3 bucket " + this.bucketName + " has been deleted");
	}, onAppGridCellClick:function (inSender, inEvent) {
		var row = this.appsVar.getItem(inEvent.rowIndex);
		this.contextRoot.setDataValue(row.getValue("name"));
	}, _dataModelNamesCallback:function (dataModelNames) {
		this.dataModelNames = dataModelNames;
		this.dataModelList._data = dataModelNames;
		this.dataModelList._render();
		var d = !this.dataModelNames || this.dataModelNames.length == 0;
		if (d) {
			this.dataModelNameEditor.setDataValue("");
		}
		this.useJNDICheckbox.setDisabled(d);
		this.jndiEditor.setDisabled(d);
	}, _loadDeployedApps:function () {
		studio.deploymentService.requestAsync("listDeploymentNames", [this.deploymentTarget, this._getProperties()], dojo.hitch(this, "_listedDeploymentNames"));
	}, _listedDeploymentNames:function (inData) {
		this.appsVar.setType("com.wavemaker.tools.deployment.AppInfo");
		this.appsVar.setData(inData);
		this.applist.setDataSet(this.appsVar);
	}, _deployed:function (inData) {
		studio.endWait();
		app.alert(inData.toString());
		this._loadDeployedApps();
	}, _svcError:function (inData) {
		studio.endWait();
		app.alert(inData.toString());
	}, _undeployed:function (inData) {
		studio.endWait();
		app.alert(inData.toString());
		this._loadDeployedApps();
	}, _redeployed:function (inData) {
		studio.endWait();
		app.alert(inData.toString());
	}, _getDeploymentTargetNamesResult:function (inData) {
		this.deploymentTargetSelect.editor.setOptions(inData.join(","));
	}, _dataModelListSelect:function (saveCurrentSelection) {
		if (saveCurrentSelection) {
			this._saveJNDIName();
		}
		this.useJNDICheckbox.setDisabled(false);
		var i = this.dataModelList.selected.index;
		var dataModelName = this.dataModelList._data[i];
		this.dataModelNameEditor.setDataValue(dataModelName);
		var key = this._getKey(dataModelName);
		if (this.jndiNames[key] == null) {
			this.useJNDICheckbox.components.editor.setChecked(false);
			this.jndiEditor.setDisabled(true);
			this.jndiEditor.setDataValue("");
		} else {
			this.useJNDICheckbox.components.editor.setChecked(true);
			this.jndiEditor.setDisabled(false);
			this.jndiEditor.setDataValue(this.jndiNames[key]);
		}
	}, _saveJNDIName:function () {
		var key = this._getKey(this.dataModelNameEditor.getDataValue());
		var j = this.jndiEditor.getDataValue();
		if (j == null) {
			j = "";
		} else {
			j = dojo.string.trim(j);
		}
		if (this.useJNDICheckbox.components.editor.getChecked()) {
			if (j == "") {
				this.jndiNames[key] = null;
			} else {
				this.jndiNames[key] = j;
			}
		} else {
			this.jndiNames[key] = null;
		}
	}, _getKey:function (dataModelName) {
		return dataModelName + this.JNDI_NAME_PROPERTY;
	}, _prepareJNDINames:function () {
		var rtn = {};
		for (var i in this.jndiNames) {
			if (this.jndiNames[i] != null) {
				rtn[i] = this.jndiNames[i];
			}
		}
		return rtn;
	}, _reset:function () {
		this.jndiNames = {};
	}, _getPropertiesResult:function (inData) {
		this.jndiNames = inData;
		if (this.dataModelNames.length > 0) {
			this.dataModelList.selectByIndex(0);
			this._dataModelListSelect(false);
		}
	}, _loadedDeploymentOptions:function (inData) {
		if (this.ec2Dialog) {
			this.ec2Dialog.dismiss();
		}
		this._clearEditors();
		var editorInfo = {};
		for (var k in inData) {
			editorInfo[k] = {dataValue:inData[k]};
		}
		this._addEditors(editorInfo);
		studio.endWait();
	}, _clearEditors:function () {
		dojo.map(this.currentEditors, function (o) {
			o.destroy();
		});
		this.currentEditors = [];
	}, _addEditors:function (editorInfo) {
		var self = this, p = this.propertiesPanel;
		wm.forEachProperty(editorInfo, function (o, n) {
			var props = dojo.mixin({name:n, caption:n, owner:self, parent:p}, o);
			var e = new wm.Editor(props);
			if (n == "password") {
				e.editor.setPassword(true);
			}
			self.currentEditors.push(e);
		});
		p.reflow();
	}, _getProperties:function () {
		var rtn = {};
		dojo.map(this.currentEditors, function (e) {
			rtn[e.caption] = e.dataValue;
		});
		return rtn;
	}, _getContextRoot:function () {
		var rtn = this.contextRoot.getDataValue();
		if (rtn == null) {
			app.alert("Please enter a context root");
		}
		return rtn;
	}, _setDataTypes:function () {
		wm.typeManager.addType("com.wavemaker.tools.deployment.AppInfo", {internal:true, fields:{name:{type:"java.lang.String", isObject:false, isList:false}, href:{type:"java.lang.String", isObject:false, isList:false}, description:{type:"java.lang.String", isObject:false, isList:false}}});
	}, _end:0});
}
if (!dojo._hasResource["wm.studio.pages.Diagnostics.Diagnostics"]) {
	dojo._hasResource["wm.studio.pages.Diagnostics.Diagnostics"] = true;
	dojo.provide("wm.studio.pages.Diagnostics.Diagnostics");
	dojo.declare("Diagnostics", wm.Page, {start:function () {
	}, update:function () {
		var ws = this.dumpWires();
		ws.sort(function (a, b) {
			return (a.tid == b.tid ? 0 : a.tid < b.tid ? -1 : 1);
		});
		var h = [];
		for (var i = 0, w; w = ws[i]; i++) {
			h.push("<span class=\"diag-wire-target\">", w.tid, "</span>", bundleStudio.D_BoundTo, "<span class=\"diag-wire-source\">", w.sid, "</span>", !w.ttype || !w.stype ? "" : w.ttype == w.stype ? D_WithMatchedType + w.ttype + "</i>" : "<br/><span class=\"diag-type-error\">! type mismatch</span>" + w.ttype + "!=" + w.stype, "<br/>");
		}
		if (!h.length) {
			h.push("No wires in project.");
		}
		this.wiresPanel.domNode.innerHTML = h.join("");
	}, dumpWires:function () {
		var ws = [];
		var cs = wm.Component.byId, c, s, tt, st;
		for (var i in cs) {
			c = cs[i];
			if (c instanceof wm.Wire) {
				var p = c.target[c.targetProperty];
				tt = p instanceof wm.Variable ? " (" + p.type + ") " : "";
				s = c.getValueById(c.source);
				st = s instanceof wm.Variable ? " (" + s.type + ") " : "";
				ws.push({tid:c.target.getId() + "." + c.targetProperty, ttype:tt, sid:c.source, stype:st});
			}
		}
		return ws;
	}, _end:0});
}
if (!dojo._hasResource["wm.studio.pages.ImportDatabase.ImportDatabase"]) {
	dojo._hasResource["wm.studio.pages.ImportDatabase.ImportDatabase"] = true;
	dojo.provide("wm.studio.pages.ImportDatabase.ImportDatabase");
	dojo.declare("ImportDatabase", wm.Page, {ip:null, start:function () {
		initDBTypeDropdown(this.dbdropdown);
		studio.runtimeService.requestAsync(LOAD_IP_OP, [], dojo.hitch(this, "_loadedIP"));
		this.update();
	}, update:function (inImportDataModel) {
		var d = inImportDataModel;
		if (d) {
			this.serviceNameInput.setInputValue(d.dataModelName || "");
			this.serviceNameChanged();
			this.usernameInput.setInputValue(d.userName || "");
			this.usernameChanged();
			this.passwordInput.setInputValue(d.password || "");
			if (d.dbtype) {
				this.dbdropdown.setDisplayValue(d.dbtype);
				this.importDBdropdownChanged();
			}
			this.hostInput.setInputValue(d.host || ((studio.isCloud()) ? "mysql.wavemaker.com" : "localhost"));
			this.importHostChanged();
			this.portInput.setInputValue(d.port || "3306");
			this.importPortChanged();
			this.extraInput.setInputValue(d.dbName || "");
			this.importExtraChanged();
			if (d.noPrompt) {
				setTimeout(dojo.hitch(this, "importBtnClick"), 100);
			}
		}
	}, cancelBtnClick:function (inSender) {
		this._close();
	}, onServiceNameKeyPress:function () {
		setTimeout(dojo.hitch(this, "serviceNameChanged"), 0);
	}, serviceNameChanged:function () {
		this._updatePackage();
	}, onUsernameKeyPress:function () {
		setTimeout(dojo.hitch(this, "usernameChanged"), 0);
	}, usernameChanged:function () {
		var db = this.dbdropdown.getDisplayValue();
		this._updateSchemaFilter(db, this.usernameInput.getInputValue(), this.schemaPatternInput);
	}, importDBdropdownChanged:function (inSender, inValue) {
		setupWidgetsForDatabaseType(inValue, this.ip, this.hostLabel, this.hostInput, this.portLabel, this.portInput, this.extraInputLabel, this.extraInput, this.extra2InputLabel, this.extra2Input, this.tablePatternInput, this.schemaPatternInput, this.usernameInput, this.passwordInput);
		this._updateImportConnectionUrl();
		this.usernameChanged();
	}, onImportHostKeyPress:function (inSender) {
		setTimeout(dojo.hitch(this, "importHostChanged", inSender), 0);
	}, importHostChanged:function (inSender) {
		this._updateImportConnectionUrl();
	}, onImportPortKeyPress:function () {
		setTimeout(dojo.hitch(this, "importPortChanged"), 0);
	}, importPortChanged:function () {
		this._updateImportConnectionUrl();
	}, onImportExtraKeyPress:function () {
		setTimeout(dojo.hitch(this, "importExtraChanged"), 0);
	}, importExtraChanged:function () {
		this._updateServiceName();
		this._updateImportConnectionUrl();
	}, onImportExtra2KeyPress:function () {
		setTimeout(dojo.hitch(this, "importExtra2Changed"), 0);
	}, importExtra2Changed:function () {
		this._updateImportConnectionUrl();
	}, testConnectionBtnClick:function (inSender) {
		this._testConnection(this.connectionUrlInput.getInputValue(), this.usernameInput.getInputValue(), this.passwordInput.getInputValue(), this.driverClassInput.getInputValue());
	}, importBtnClick:function (inSender) {
		this.dataModelName = null;
		studio.beginWait("Importing Database...");
		studio.dataService.requestAsync(IMPORT_DB_OP, [this.serviceNameInput.getInputValue(), this.packageInput.getInputValue(), this.usernameInput.getInputValue(), this.passwordInput.getInputValue(), this.connectionUrlInput.getInputValue(), this.tablePatternInput.getInputValue(), this.schemaPatternInput.getInputValue(), this.driverClassInput.getInputValue(), this.dialectInput.getInputValue(), this.revengNamingStrategyInput.getInputValue()], dojo.hitch(this, "_importResult"), dojo.hitch(this, "_importError"));
	}, _updatePackage:function () {
		this.packageInput.setInputValue("");
		var s = this.serviceNameInput.getInputValue().toLowerCase();
		this.packageInput.setInputValue(DEFAULT_PACKAGE_ROOT + s);
	}, _updateSchemaFilter:function (dbtype, username, schemaFilterInput) {
		if (isOracle(dbtype) || isDB2(dbtype)) {
			schemaFilterInput.setInputValue(username.toUpperCase());
		}
	}, _updateImportConnectionUrl:function () {
		var dbtype = this.dbdropdown.getDisplayValue();
		var h = this.hostInput.getInputValue();
		var p = this.portInput.getInputValue();
		var e = this.extraInput.getInputValue();
		var e2 = this.extra2Input.getInputValue();
		var s = buildConnectionUrl(dbtype, h, p, e, e2);
		this.connectionUrlInput.setInputValue(s);
	}, _updateServiceName:function () {
		var e = this.extraInput.getInputValue();
		this.serviceNameChanged();
		this.serviceNameInput.setInputValue(e);
	}, _testConnection:function (url, username, password, driverClassName) {
		studio.beginWait("Test Connection: " + url);
		studio.dataService.requestAsync(TEST_CONNECTION_OP, [username, password, url, driverClassName], dojo.hitch(this, "_connectionSucceeded"), dojo.hitch(this, "_connectionFailed"));
	}, _connectionSucceeded:function () {
		studio.endWait();
		app.alert("Connection successful");
	}, _connectionFailed:function (inError) {
		studio.endWait();
		app.alert("Connection failed: " + inError.message);
	}, _importResult:function () {
		studio.endWait();
		this.dataModelName = this.serviceNameInput.getInputValue();
		studio.updateServices();
		wm.fire(studio.getEditor("DataObjectsEditor").page, "update");
		wm.fire(studio.getEditor("QueryEditor").page, "update");
		this._close("Import");
	}, _importError:function (inError) {
		studio.endWait();
		var msg = "";
		if (inError.message) {
			msg = ": " + inError.message;
		}
		app.alert("Import failed " + msg + "\nSee wm.log for compiler output");
	}, _loadedIP:function (inData) {
		this.ip = inData;
	}, newBtnClick:function (inSender) {
		var f = this.newDataModelInput.getDataValue();
		this.dataModelName = f;
		studio.beginWait("Adding " + f);
		studio.dataService.requestAsync(NEW_DATA_MODEL_OP, [f], dojo.hitch(this, "newDataModelResult"), dojo.hitch(this, "newDataModelError"));
	}, newDataModelError:function (inError) {
		this.dataModelName = null;
		app.alert(inError);
	}, newDataModelResult:function () {
		wm.fire(studio.getEditor("DataObjectsEditor").page, "newDataModelResult");
		this._close("New");
	}, _close:function (inWhy) {
		wm.fire(this.owner, "dismiss", [inWhy]);
	}, _end:0});
}
if (!dojo._hasResource["wm.studio.pages.ImportWebService.ImportWebService"]) {
	dojo._hasResource["wm.studio.pages.ImportWebService.ImportWebService"] = true;
	dojo.provide("wm.studio.pages.ImportWebService.ImportWebService");
	dojo.declare("ImportWebService", wm.Page, {TYPE_SOAP:"SOAP", TYPE_REST_WSDL:"REST (WSDL / WADL)", TYPE_REST_BUILDER:"REST (Build-A-Service)", TYPE_FEED:"Feed", IMPORT_TYPE_URL:"URL", IMPORT_TYPE_FILE:"File", start:function () {
		this.updateSelect(this.typeInput, [this.TYPE_SOAP, this.TYPE_REST_WSDL, this.TYPE_REST_BUILDER, this.TYPE_FEED]);
		this.typeInput.setValue("displayValue", this.TYPE_SOAP);
		this.updateSelect(this.wsdlPathTypeInput, [this.IMPORT_TYPE_URL, this.IMPORT_TYPE_FILE]);
		this.wsdlPathTypeInput.setValue("displayValue", this.IMPORT_TYPE_URL);
	}, reset:function () {
		this.typeInput.setValue("displayValue", this.TYPE_SOAP);
		this.wsdlPathTypeInput.setValue("displayValue", this.IMPORT_TYPE_URL);
		this.wsdlUrlInput.clear();
		this.wsdlFileInput.fileNode.value = "";
		this.serviceIdAutoYesRadio.components.editor.setChecked(true);
		this.serviceIdInput.clear();
		this.restServiceBuilderPage.page.clearAll();
	}, updateSelect:function (inSelect, inData) {
		var s = inSelect, o;
		if (inData == null) {
			o = null;
		} else {
			o = inData.join(",");
		}
		s.displayValue = "";
		s.editor.setOptions(o);
	}, typeInputChange:function (inSender, inValue) {
		if (inValue == this.TYPE_SOAP) {
			this.layers.setLayer("wsdlLayer");
			this.wsdlPathTypeInput.setCaption("WSDL");
			this.wsdlGroupLabel.setCaption("WSDL情報");
		} else {
			if (inValue == this.TYPE_REST_WSDL) {
				this.layers.setLayer("wsdlLayer");
				this.wsdlPathTypeInput.setCaption("WSDL / WADL");
				this.wsdlGroupLabel.setCaption("WSDL / WADL情報");
			} else {
				if (inValue == this.TYPE_REST_BUILDER) {
					this.layers.setLayer("restBuilderLayer");
				} else {
					if (inValue == this.TYPE_FEED) {
						this.layers.setLayer("feedLayer");
					}
				}
			}
		}
	}, importButtonClick:function (inSender) {
		this.serviceId = null;
		var t = this.typeInput.getValue("displayValue");
		if (t == this.TYPE_SOAP || t == this.TYPE_REST_WSDL) {
			this.importWSDL(false);
		} else {
			if (t == this.TYPE_FEED) {
				if (wm.services.byName["FeedService"]) {
					app.alert("このフィードサービスは既にインポートされています。");
				} else {
					studio.beginWait("フィードサービスのインポート...");
					studio.webService.requestAsync("registerFeedService", null, dojo.hitch(this, "registerFeedServiceResult"), dojo.hitch(this, "registerFeedServiceError"));
				}
			} else {
				if (t == this.TYPE_REST_BUILDER) {
					this.restServiceBuilderPage.page.saveButtonClick();
				}
			}
		}
	}, cancelButtonClick:function (inSender, inEvent) {
		wm.fire(this.owner, "dismiss", [inEvent]);
	}, importWSDL:function (inOverwrite) {
		var w = (inOverwrite == undefined || inOverwrite == null) ? false : inOverwrite;
		var f, id = this.serviceIdInput.getValue("displayValue");
		if (w) {
			studio.application.removeServerComponentByName(this.overWriteId, "wm.WebService");
		}
		if (this.wsdlPathTypeInput.getValue("displayValue") == this.IMPORT_TYPE_URL) {
			f = this.wsdlUrlInput.getValue("displayValue");
			if (!f) {
				app.alert("WSDLファイルを選択してください！");
			} else {
				studio.beginWait("Web Serviceのインポート...");
				studio.webService.requestAsync("importWSDL", [f, id, w], dojo.hitch(this, "importWSDLResult"), dojo.hitch(this, "importWSDLError"));
			}
		} else {
			f = this.wsdlFileInput.fileNode.value;
			if (!f) {
				app.alert("WSDLファイルを選択してください！");
			} else {
				studio.beginWait("Web Serviceをインポートしています...");
				dojo.io.iframe.send({url:"services/webService.upload", content:{serviceId:id, overwrite:w}, form:this.wsdlFileInput.formNode, handleAs:"json", handle:dojo.hitch(this, "uploadWSDLComplete")});
			}
		}
	}, uploadWSDLComplete:function (inResponse) {
		if (inResponse.result) {
			this.importWSDLResult(inResponse.result);
		} else {
			if (inResponse.error) {
				this.importWSDLError(inResponse.error);
			} else {
				app.alert(inResponse);
			}
		}
	}, importCompleted:function (inResponse) {
		this.serviceId = inResponse;
		wm.fire(this.owner, "dismiss", ["Import"]);
	}, importWSDLResult:function (inResponse) {
		studio.endWait();
		if (inResponse.slice(0, 16) == "$already_exists$") {
			app.confirm("サービスは既に存在しています。上書きしますか？", false, dojo.hitch(this, function () {
				this.overWriteId = inResponse.slice(16);
				this.importWSDL(true);
			}));
		} else {
			this.importCompleted(inResponse);
		}
	}, importWSDLError:function (inError) {
		studio.endWait();
		app.alert("Error occurred while importing WSDL!\n" + inError);
	}, registerFeedServiceResult:function (inResponse) {
		studio.endWait();
		this.importCompleted(inResponse);
	}, registerFeedServiceError:function (inError) {
		studio.endWait();
		app.alert("Error occurred while registering Feed service!\n" + inError);
	}, navGotoDesignerClick:function () {
		studio.tabs.setLayer("workspace");
	}, wsdlPathTypeInputChange:function (inSender, inValue) {
		var b = inValue == this.IMPORT_TYPE_URL;
		this.wsdlFileInput.setShowing(!b);
		this.wsdlUrlInput.setShowing(b);
	}, serviceIdAutoYesRadioChange:function (inSender, inDisplayValue, inDataValue) {
		this.serviceIdInput.setDisabled(inDataValue == 1);
	}, _end:0});
}
if (!dojo._hasResource["wm.studio.pages.JavaEditor.JavaEditor"]) {
	dojo._hasResource["wm.studio.pages.JavaEditor.JavaEditor"] = true;
	dojo.provide("wm.studio.pages.JavaEditor.JavaEditor");
	dojo.declare("JavaEditor", wm.Page, {start:function () {
		this.tree.initNodeChildren = dojo.hitch(this.tree, "treeInitNodeChildren");
		this.update();
		this.subscribe("wmtypes-changed", dojo.hitch(this, "typesChangedCall"));
	}, update:function () {
		studio.updateServices();
		this.servicesChanged();
		this.typesChangedCall();
		studio.refreshWidgetsTree();
	}, servicesChanged:function () {
		var names = [];
		wm.services.forEach(function (s) {
			if (s.type == "JavaService" && (s.name != "securityService" || s.name != "securityServiceJOSSO")) {
				names.push(s.name);
			}
		});
		this.tree.setTreeData(names);
	}, treeSelect:function (inSender, inNode) {
		var n = inNode;
		while (n instanceof wm.TreeNode && n.isService != true) {
			n = n.parent;
		}
		if (n.isService) {
			var id = this.tree.serviceId;
			if (id != n.name) {
				this.tree.serviceId = id = n.name;
				studio.javaService.requestAsync("openClass", [id], dojo.hitch(this, "openJavaClassCallback"), dojo.hitch(this, "openJavaClassErrorCallback"));
			}
		}
	}, selectService:function (inJavaService) {
		this.javaService = inJavaService;
		this.tree.serviceId = this.javaService.serviceId;
		studio.javaService.requestAsync("openClass", [this.javaService.serviceId], dojo.hitch(this, "openJavaClassCallback"), dojo.hitch(this, "openJavaClassErrorCallback"));
	}, openJavaClassCallback:function (inData) {
		this.javaCodeEditor.setText("");
		this.javaCodeEditor.setText(inData || "");
		var matches = inData.match(/^\s*package\s+(\S*)\s*;/);
		this.packageName = (matches) ? matches[1] : "";
		var matches2 = inData.match(/\s*public\s+class\s+(\S+)/);
		this.className = matches2[1];
		this.logViewer.page.setLogFile(this.packageName + "." + this.className + ".log");
	}, openJavaClassErrorCallback:function (inError) {
		this.layers.setLayer("defaultServiceLayer");
	}, typesChangedCall:function (inData) {
		studio.servicesService.requestAsync("listTypesTree", null, dojo.hitch(this, "typesChangedCallback"));
	}, typesChangedCallback:function (inData) {
		this.typeTree.renderData(inData.dataObjectsTree);
	}, newJavaBtnClick:function (inSender) {
		var d = this.newJavaServiceDialog;
		if (d) {
			d.page.clearAll();
		} else {
			this.newJavaServiceDialog = d = new wm.PageDialog({pageName:"NewJavaService", owner:studio, hideControls:true, height:200, width:400});
			d.onClose = dojo.hitch(this, function (inWhy) {
				if (inWhy == "OK") {
					this.newJavaServiceCallback();
				}
			});
		}
		d.show();
	}, newJavaServiceCallback:function (inData) {
		if (this.newJavaServiceDialog && this.newJavaServiceDialog.page.newServiceId) {
			this.tree.serviceId = this.newJavaServiceDialog.page.newServiceId;
			this.javaCodeEditor.getText(this.newJavaServiceDialog.page.newJavaCode || "");
		}
		this.javaService = new wm.JavaService({name:this.tree.serviceId, serviceId:this.tree.serviceId});
		studio.application.addServerComponent(this.javaService);
		this.update();
		studio.select(this.javaService);
	}, delJavaBtnClick:function (inSender) {
		if (this.tree.serviceId) {
			app.confirm("Are you sure you want to delete " + this.tree.serviceId + "?", false, dojo.hitch(this, function () {
				studio.servicesService.requestAsync("deleteService", [this.tree.serviceId], dojo.hitch(this, "deleteServiceCallback"));
			}));
		}
	}, deleteServiceCallback:function (inData) {
		this.tree.serviceId = null;
		this.javaCodeEditor.setText("");
		studio.application.removeServerComponent(this.javaService);
		this.update();
	}, openCmpOutBtnClick:function (inSender) {
	}, closeCmpOutBtnClick:function (inSender) {
	}, javaServiceRefreshButtonClick:function (inSender) {
		if (this.tree.serviceId) {
			app.confirm("Reload service class from disk?  This will destroy any changes in this editor.", false, dojo.hitch(this, function () {
				studio.beginWait("Refreshing Java service...");
				studio.javaService.requestAsync("openClass", [this.tree.serviceId], dojo.hitch(this, "refreshButtonCallback"), dojo.hitch(this, "saveJavaServiceErrorCallback"));
			}));
		}
	}, refreshButtonCallback:function (inData) {
		this.openJavaClassCallback(inData);
		wm.onidle(this, function () {
			studio.javaService.requestAsync("saveClass", [this.tree.serviceId, this.javaCodeEditor.getText()], dojo.hitch(this, "saveJavaServiceCallback"), dojo.hitch(this, "saveJavaServiceErrorCallback"));
		});
	}, javaServiceSaveButtonClick:function (inSender) {
		if (this.tree.serviceId) {
			studio.beginWait("Saving Java service...");
			studio.javaService.requestAsync("saveClass", [this.tree.serviceId, this.javaCodeEditor.getText()], dojo.hitch(this, "saveJavaServiceCallback"), dojo.hitch(this, "saveJavaServiceErrorCallback"));
		}
	}, saveJavaServiceCallback:function (inData) {
		studio.endWait();
		if (inData.buildSucceeded) {
			this.update();
			app.toastSuccess("Compiled Successfully!");
		} else {
			app.alert("Save or compile failed; see compiler output or wm.log");
		}
		var m = (inData.buildSucceeded ? "Service Compiled Successfully" : "Service Compile Failed") + "\n\n";
		this.javaCompilerOutputEditor.setInputValue(m + inData.compileOutput);
		this.logViewer.page.clearLog();
		this.updateJavaLogs();
		this.openCmpOutBtnClick();
	}, changeLogTab:function () {
		this.updateJavaLogs();
	}, updateJavaLogs:function () {
		this.logViewer.page.updateLog();
	}, saveJavaServiceErrorCallback:function (inError) {
		studio.endWait();
		app.alert("Save or compile failed with message:\n" + inError.message + "\nSee wm.log or Compiler output");
	}, _end:0});
}
if (!dojo._hasResource["wm.studio.pages.LiveViewEditor.LiveViewEditor"]) {
	dojo._hasResource["wm.studio.pages.LiveViewEditor.LiveViewEditor"] = true;
	dojo.provide("wm.studio.pages.LiveViewEditor.LiveViewEditor");
	wm.forAllEditors = function (inParent, inFn) {
		var ws = inParent.widgets;
		for (var en in ws) {
			var e = ws[en];
			if (e instanceof wm.Editor) {
				inFn(e);
			} else {
				if (e instanceof wm.Container) {
					wm.forAllEditors(e, inFn);
				}
			}
		}
	};
	dojo.declare("LiveViewEditor", wm.Page, {start:function () {
		this.clearFieldForm();
	}, setLiveView:function (inLiveView) {
		this.clientLiveView = inLiveView;
		this.liveVariable.setLiveView(this.clientLiveView);
		this.update();
	}, update:function () {
		this.liveVariable.owner = studio.wip;
		this.nameEdit.beginEditUpdate();
		this.nameEdit.setDataValue((this.clientLiveView || 0).name);
		var noView = Boolean(!this.clientLiveView);
		this.nameEdit.setDisabled(noView);
		this.nameEdit.endEditUpdate();
		if (noView) {
			this.previewBox.setChecked(false);
			this.dataGrid1.doClearColumns();
		}
		this.previewBox.setDisabled(noView);
		this.dataGrid1.setDataSet(this.liveVariable);
		this.tree1.clear();
		var t = (this.liveVariable.type || "").split(".").pop();
		if (t) {
			var node = new wm.TreeNode(this.tree1.root, {content:t, image:"images/index.png", hasChildren:true});
			this.schemaToNode(node, wm.typeManager.getTypeSchema(this.liveVariable.type));
		}
		this.clearFieldForm();
		this.runtimeServiceFetch();
	}, accept:function () {
		if (this.clientLiveView) {
			this.clientLiveView.setProp("name", this.nameEdit.getDataValue());
			this.clientLiveView.setFields(this.listRelated(), this.listFields());
			this.clientLiveView.viewChanged();
		}
	}, addFieldToView:function (inFieldInfo) {
		this.liveVariable.liveView.view.push(inFieldInfo);
		return inFieldInfo;
	}, removeFieldFromView:function (inFieldInfo) {
		var view = this.liveVariable.liveView.view;
		if (inFieldInfo) {
			for (var i = 0, v; (v = view[i]); i++) {
				if (v.dataIndex == inFieldInfo.dataIndex) {
					view.splice(i, 1);
					return;
				}
			}
		}
	}, findFieldInView:function (inField) {
		for (var i = 0, v; (v = this.liveVariable.liveView.view[i]); i++) {
			if (v.dataIndex == inField) {
				return v;
			}
		}
		return null;
	}, findFieldInRelated:function (inField) {
		for (var i = 0, r; (r = this.liveVariable.liveView.related[i]); i++) {
			if (r == inField) {
				return r;
			}
		}
		return null;
	}, getFullName:function (inNode) {
		var node = inNode, name = [];
		while (node && node.parent != node.tree.root) {
			name.unshift(node.name);
			node = node.parent;
		}
		return name.join(".");
	}, tree1Initchildren:function (inSender, inNode) {
		if (inNode.hasChildren) {
			this.schemaToNode(inNode, inNode.schema);
		}
	}, _schemaToNode:function (inNode, inSchema, inAllow) {
		var s, st, ti, ts = [];
		for (var i in inSchema) {
			s = inSchema[i];
			st = wm.typeManager.isStructuredType(s.type);
			if (inAllow(st, s)) {
				ts.push({name:i, info:s});
			}
		}
		ts.sort(function (a, b) {
			return (a.info.fieldOrder - b.info.fieldOrder);
		});
		for (i = 0; (ti = ts[i]); i++) {
			this.typeInfoToNode(inNode, ti.name, ti.info);
		}
	}, schemaToNode:function (inNode, inSchema) {
		var s, ti;
		this._schemaToNode(inNode, inSchema, function (st) {
			return !st;
		});
		this._schemaToNode(inNode, inSchema, function (st, s) {
			return st && !s.isList;
		});
		this._schemaToNode(inNode, inSchema, function (st, s) {
			return st && s.isList;
		});
	}, checkAncestors:function (inNode) {
		var n = inNode.parent;
		while (n) {
			if (n.setChecked) {
				n.setChecked(true);
			}
			n = n.parent;
		}
	}, addRemoveNode:function (inNode) {
		var n = inNode.fullName, f = n ? this.findFieldInView(n) : null;
		if (inNode.getChecked()) {
			this.checkAncestors(inNode);
			if (inNode.canAddField && !f) {
				this.addFieldToView(this.populateField({}, inNode));
			}
		} else {
			if (f) {
				this.removeFieldFromView(f);
			}
		}
	}, leafChecked:function (inNode) {
		this.addRemoveNode(inNode);
		if (inNode.hasChildren && inNode instanceof wm.TreeCheckNode) {
			this.checkChildren(inNode, inNode.getChecked());
		}
		if (inNode instanceof wm.TreeCheckNode && inNode.getChecked()) {
			inNode.tree._select(inNode);
		}
		this.fieldToForm(inNode);
	}, _checkChildren:function (inNode, inCheck) {
		inNode.setOpen(true);
		dojo.forEach(inNode.kids, function (n) {
			if (n instanceof wm.TreeCheckNode) {
				if (n.hasChildren) {
					if (n.getChecked() && !inCheck) {
						n.setChecked(inCheck);
						this.addRemoveNode(n);
						this._checkChildren(n, inCheck);
					}
				} else {
					n.setChecked(inCheck);
					this.addRemoveNode(n);
				}
			}
		}, this);
	}, checkChildren:function (inNode, inCheck) {
		if (!inCheck) {
			app.confirm("Are you sure you want to deselect all properties in this object?", false, dojo.hitch(this, function () {
				this._checkChildren(inNode, inCheck);
				this.runtimeServiceFetch();
				this.accept();
			}));
		} else {
			this._checkChildren(inNode, inCheck);
		}
	}, allChildrenChecked:function (inNode) {
		inNode.setOpen(true);
		for (var i = 0, kids = inNode.kids, n; (n = kids[i]); i++) {
			if (n instanceof wm.TreeCheckNode && !n.hasChildren) {
				if (!n.getChecked()) {
					return;
				}
			}
		}
		return true;
	}, typeInfoToNode:function (inNode, inName, inTypeInfo) {
		var n = this.getFullName(inNode);
		n = n ? n + "." + inName : inName;
		var isList = inTypeInfo.isList, s = wm.typeManager.getTypeSchema(inTypeInfo.type), isInView = this.findFieldInView(n), isRelated = this.findFieldInRelated(n), showRequired = !isList && inTypeInfo.required && !inTypeInfo.exclude.length, image = inTypeInfo.isList ? "index.png" : (s ? "link.png" : ""), ctor = wm.TreeCheckNode;
		var node = new ctor(inNode, {content:inName + (showRequired ? " <span class=\"wmeditor-required\">*</span>" : ""), as:wm.decapitalize(inName), image:image ? "images/" + image : "", name:inName, caption:inName, fullName:n, schema:s, isList:isList, type:inTypeInfo.type, displayType:wm.getPrimitiveDisplayType(inTypeInfo.type), required:inTypeInfo.required, nodeOrder:inTypeInfo.fieldOrder, checked:isInView || isRelated, canAddField:!s, hasChildren:Boolean(s), closed:!isRelated});
	}, listRelated:function () {
		var h = [], self = this;
		this.tree1.forEachNode(function (k) {
			if (k.schema && k.getChecked && k.getChecked()) {
				h.push(self.getFullName(k));
			}
		});
		return h;
	}, listNodeFields:function (inNode, ioFields) {
		dojo.forEach(inNode.kids, function (node) {
			if (node.getChecked && node.getChecked() && !node.schema) {
				var f = this.findFieldInView(node.fullName) || {};
				ioFields.push(this.populateField(f, node));
			}
		}, this);
		dojo.forEach(inNode.kids, function (node) {
			this.listNodeFields(node, ioFields);
		}, this);
		return ioFields;
	}, listFields:function () {
		return this.listNodeFields(this.tree1.root, []);
	}, setViewFieldProp:function (inViewField, inProperty, inValue) {
		if (inViewField && inProperty) {
			inViewField[inProperty] = inValue;
		}
	}, editorPropertyMap:{captionEdit:{name:"caption", defaultValue:"n/a"}, typeEdit:{name:"displayType", defaultValue:"Text"}, autoSizeBox:{name:"autoSize", defaultValue:false}, widthEdit:{name:"width", defaultValue:""}, widthUnitsEdit:{name:"widthUnits", defaultValue:"px"}, requiredBox:{name:"required", defaultValue:true}, orderEdit:{name:"order"}, }, clearFieldForm:function () {
		this.viewField = null;
		wm.forAllEditors(this.liveForm1, function (e) {
			e.setDisabled(true);
			e.setValue("dataValue", "");
		});
		this.fieldLabel.setValue("caption", "Field Options");
	}, populateField:function (inField, inNode) {
		var f = inField, node = inNode;
		f.caption = f.caption || wm.capitalize(node.name);
		f.sortable = "sortable" in f ? f.sortable : true;
		f.dataIndex = "dataIndex" in f ? f.dataIndex : this.getFullName(node);
		f.type = f.type || node.type;
		f.displayType = f.displayType || node.displayType;
		f.required = "required" in f ? f.required : node.required;
		f.widthUnits = f.widthUnits || "px";
		f.includeLists = "includeLists" in f ? f.includeLists : true;
		f.includeForms = "includeForms" in f ? f.includeForms : true;
		f.order = inNode.nodeOrder;
		return f;
	}, fieldToForm:function (inNode) {
		this.clearFieldForm();
		if (inNode.fullName) {
			this.fieldLabel.setValue("caption", "Options for \"" + inNode.name + "\"");
			var v = this.findFieldInView(inNode.fullName);
			this.viewField = v;
			if (v) {
				wm.forAllEditors(this.liveForm1, dojo.hitch(this, function (e) {
					e.setDisabled(false);
					var field = this.editorPropertyMap[e.id];
					if (field) {
						var n = field.name, defaultValue = n in inNode ? inNode[n] : field.defaultValue;
						e.beginEditUpdate();
						e.setValue("dataValue", v[n] !== undefined ? v[n] : defaultValue);
						e.endEditUpdate();
					}
				}));
			}
		}
	}, previewBoxChange:function (inSender, inDisplayValue, inDataValue) {
		this.dataGrid1.doClearColumns();
		if (inSender.getChecked()) {
			this.previewPanel.setHeight("186px");
			this.dataGrid1.doClearColumns();
			this.dataGrid1.setShowing(true);
			setTimeout(dojo.hitch(this, "runtimeServiceFetch"), 1);
		} else {
			this.dataGrid1.setShowing(false);
			this.previewPanel.setHeight("30px");
		}
	}, tree1DblClick:function (inSender, inNode) {
		if (inNode.hasChildren) {
			var c = true;
			if (inNode instanceof wm.TreeCheckNode) {
				c = inNode.getChecked();
				inNode.setChecked(!c);
			} else {
				c = this.allChildrenChecked(inNode);
			}
			this.checkChildren(inNode, !c);
		}
	}, tree1Checkboxclick:function (inSender, inNode) {
		this.leafChecked(inNode);
		this.runtimeServiceFetch();
		this.accept();
	}, fieldEditorChanged:function (inSender, inDisplayValue, inDataValue) {
		if (!this.viewField) {
			return;
		}
		var f = this.editorPropertyMap[inSender.id];
		if (f) {
			var changed = this.viewField[f.name] != inDataValue;
			this.setViewFieldProp(this.viewField, f.name, inDataValue);
			if (changed) {
				this.runtimeServiceFetch();
				this.accept();
			}
		}
	}, nameEditChanged:function () {
		this.accept();
	}, runtimeServiceFetch:function () {
		if (this.previewBox.getChecked()) {
			var d = this.liveVariable;
			d.maxResults = d.designMaxResults = 10;
			d.liveView.setFields(this.listRelated(), this.listFields());
			d.update();
		}
	}, updateSuccess:function () {
		if (this.previewBox.getChecked()) {
			this.dataGrid1.doClearColumns();
			this.dataGrid1.setDataSet(this.liveVariable);
		}
	}, tree1Select:function (inSender, inNode) {
		this.fieldToForm(inNode);
	}, saveLiveViewBtnClick:function (inSender) {
		studio.refreshWidgetsTree();
		studio.selected = null;
		studio.select(this.clientLiveView);
		studio.project.saveProject();
	}, delLiveViewBtnClick:function (inSender) {
		var v = this.clientLiveView;
		if (v) {
			app.confirm(["Are you sure you want to delete ", v.name, "?"].join(""), false, dojo.hitch(this, function () {
				this.liveVariable.setLiveView(null);
				v.destroy();
				this.update();
				studio.refreshDesignTrees();
				if (studio.page.root) {
					studio.select(studio.page.root);
				}
				studio.navGotoDesignerClick();
				studio.project.saveProject();
			}));
		}
	}});
}
if (!dojo._hasResource["wm.studio.pages.NavigationDialog.NavigationDialog"]) {
	dojo._hasResource["wm.studio.pages.NavigationDialog.NavigationDialog"] = true;
	dojo.provide("wm.studio.pages.NavigationDialog.NavigationDialog");
	dojo.declare("NavigationDialog", wm.Page, {start:function () {
		this.update();
	}, update:function () {
		if (this.host) {
			this.input = this.host.components.input;
			this.binding = this.input.components.binding;
			this.updateLayerSelect();
			this.updatePageSelect();
			this.updatePageContainerList();
			this.updateSettings();
		}
	}, getWidgetsOfType:function (inType) {
		var widgets = [];
		wm.forEachWidget(studio.page.root, function (w) {
			if (w instanceof inType) {
				widgets.push(w.getId());
			}
		});
		return widgets;
	}, getPagesList:function () {
		var pages = [].concat(studio.project.getPageList()), i = dojo.indexOf(pages, studio.page.declaredClass);
		pages.splice(i, 1);
		return pages;
	}, updateSelect:function (inSelect, inData) {
		var s = inSelect, o = inData.join(",");
		s.displayValue = "";
		s.editor.setOptions(o);
	}, updateLayerSelect:function () {
		this.updateSelect(this.layerSelect, this.getWidgetsOfType(wm.Layer));
	}, updatePageSelect:function () {
		this.updateSelect(this.pageSelect, this.getPagesList());
	}, updatePageContainerList:function () {
		var d = ["Entire Screen"].concat(this.getWidgetsOfType(wm.PageContainer));
		this.pageContainerList.renderData(d);
	}, updateSettings:function () {
		var l = this.input.getValue("layer"), p = this.input.getValue("pageName"), pa = this.input.getValue("pageContainer");
		l = l && l.getId();
		pa = pa && pa.getId();
		if (l) {
			this.layerRb.editor.setChecked(true);
			this.layerSelect.setValue("displayValue", l);
		} else {
			if (p || pa) {
				this.pageRb.editor.setChecked(true);
				this.pageSelect.setValue("displayValue", p);
				var pl = this.pageContainerList, i = dojo.indexOf(pl._data, pa);
				pl.select(pl.getItem(i == -1 ? 0 : i));
			} else {
				this.layerRb.setValue("dataValue", "layer");
			}
		}
		this.disEnableControls(!p);
	}, disEnableControls:function (inLayerMode) {
		this.layerSelect.setValue("disabled", !inLayerMode);
		this.pageSelect.setValue("disabled", inLayerMode);
		this.wherePanel.setValue("showing", !inLayerMode);
	}, layerRbChange:function (inSender, inDisplayValue, inDataValue) {
		if (inDataValue) {
			this.disEnableControls(true);
		}
	}, pageRbChange:function (inSender, inDisplayValue, inDataValue) {
		if (inDataValue) {
			this.disEnableControls(false);
		}
	}, getSelectedOperation:function () {
		var g = this.layerRb.getValue("groupValue"), s = this.pageContainerList.selected;
		if (g == "layer") {
			return "gotoLayer";
		}
		if (!s || s.index == 0) {
			return "gotoPage";
		} else {
			return "gotoPageContainerPage";
		}
	}, getSelectedLayer:function () {
		return this.layerSelect.getValue("displayValue");
	}, getSelectedPage:function () {
		return this.pageSelect.getValue("displayValue");
	}, getSelectedPageContainer:function () {
		var s = this.pageContainerList.selected;
		return s && s.index > 0 && s.getData();
	}, removeTargetBindings:function () {
		var f = function (ff) {
			if (!ff.targetId) {
				return true;
			}
		};
		var b = this.binding, wires = b.findWires(f);
		b.removeWireList(wires);
	}, _removeSourceBinding:function (inBinding, inTargetId) {
		var wires = inBinding.findWires(function (w) {
			return (w.targetId.indexOf(inTargetId) == 0);
		});
		inBinding.removeWireList(wires);
	}, removeSourceBindings:function () {
		if (!this.isAppOwned()) {
			return;
		}
		var tid = this.host.getId(), data = this.input.data, d, b, wires;
		for (var i in data) {
			d = data[i];
			b = ((d || 0).components || 0).binding;
			if (!(b instanceof wm.Binding)) {
				continue;
			}
			this._removeSourceBinding(b, tid);
		}
	}, removeBindings:function () {
		this.removeTargetBindings();
		this.removeSourceBindings();
	}, isAppOwned:function () {
		return (this.host.owner == studio.page.app);
	}, setBindings:function () {
		var appOwned = this.isAppOwned();
		this.removeBindings();
		this.input.data = {};
		var ln = this.getSelectedLayer(), p = this.getSelectedPage(), pn = this.getSelectedPageContainer(), layer = studio.page.getValueById(ln), pageContainer = studio.page.getValueById(pn), targetId = appOwned ? this.input.getId() : "", binding;
		switch (this.host.operation) {
		  case "gotoLayer":
			if (ln) {
				binding = appOwned ? layer.components.binding : this.binding;
				binding.addWire(targetId, "layer", ln);
			}
			break;
		  default:
			if (p) {
				this.binding.addWire("", "pageName", "", "\"" + p + "\"");
			}
			if (pageContainer) {
				binding = appOwned ? pageContainer.components.binding : this.binding;
				binding.addWire(targetId, "pageContainer", pn);
			}
			break;
		}
	}, isDefaultName:function () {
		return this.host.name.indexOf("navigationCall") == 0;
	}, getName:function () {
		var l = wm.capitalize((this.input.getValue("layer") || 0).name || ""), p = wm.capitalize(this.input.getValue("pageName") || ""), pa = wm.capitalize((this.input.getValue("pageContainer") || 0).name || "");
		return "goto" + l + p + pa;
	}, updateName:function () {
		if (this.isDefaultName()) {
			this.host.setProp("name", this.getName());
		}
	}, saveSettings:function () {
		this.host.setOperation(this.getSelectedOperation());
		this.setBindings();
		this.updateName();
	}, saveButtonClick:function (inSender) {
		this.saveSettings();
		inspect(this.host);
		wm.fire(this.owner, "dismiss");
	}, cancelButtonClick:function (inSender) {
		inspect(this.host);
		wm.fire(this.owner, "dismiss");
	}, _end:0});
}
if (!dojo._hasResource["wm.studio.pages.NewJavaService.NewJavaService"]) {
	dojo._hasResource["wm.studio.pages.NewJavaService.NewJavaService"] = true;
	dojo.provide("wm.studio.pages.NewJavaService.NewJavaService");
	dojo.declare("NewJavaService", wm.Page, {start:function () {
		this.newServiceId = null;
		this.newJavaCode = null;
	}, clearAll:function () {
		this.newJavaServiceIdInput.clear();
		this.newJavaClassNameInput.clear();
	}, okButtonClick:function (inSender) {
		var srvid = this.newJavaServiceIdInput.getValue("displayValue");
		var cls = this.newJavaClassNameInput.getValue("displayValue");
		this.newServiceId = null;
		this.newJavaCode = null;
		if (srvid && cls) {
			studio.beginWait("Creating new Java service...");
			studio.javaService.requestAsync("newClass", [srvid, cls], dojo.hitch(this, "newJavaClassCallback", srvid), dojo.hitch(this, "newJavaClassErrorCallback"));
		} else {
			app.alert("Service ID and Class Name cannot be empty!");
		}
	}, cancelButtonClick:function (inSender) {
		wm.fire(this.owner, "dismiss");
	}, newJavaClassCallback:function (inServiceId, inData) {
		studio.endWait();
		this.newServiceId = inServiceId;
		this.newJavaCode = inData;
		wm.fire(this.owner, "dismiss", ["OK"]);
	}, newJavaClassErrorCallback:function (inError) {
		studio.endWait();
		app.alert(inError.message);
		wm.fire(this.owner, "dismiss");
	}, _end:0});
}
if (!dojo._hasResource["wm.studio.pages.PreferencesPane.PreferencesPane"]) {
	dojo._hasResource["wm.studio.pages.PreferencesPane.PreferencesPane"] = true;
	dojo.provide("wm.studio.pages.PreferencesPane.PreferencesPane");
	dojo.declare("PreferencesPane", wm.Page, {start:function () {
		this.update();
		if (studio.isCloud()) {
			this.panel2.setShowing(false);
		}
	}, update:function () {
		studio.studioService.requestSync("getPreferences", null, dojo.hitch(this, "getPreferencesCallBack"));
		this.useLopEditor.beginEditUpdate();
		this.useLopEditor.setDataValue(studio.getUserSetting("useLop"));
		this.useLopEditor.endEditUpdate();
	}, getPreferencesCallBack:function (inResult) {
		this.wavemakerFolderEditor.setDataValue(inResult["wavemakerHome"]);
		this.demoFolderEditor.setDataValue(inResult["demoHome"]);
	}, okButtonClick:function (inSender) {
		studio.studioService.requestAsync("setPreferences", [{"wavemakerHome":this.wavemakerFolderEditor.getDataValue(), "demoHome":this.demoFolderEditor.getDataValue()}], dojo.hitch(this, "okButtonClickResult"), dojo.hitch(this, "okButtonClickError"));
	}, okButtonClickResult:function (inSender) {
		wm.fire(this.owner, "dismiss", ["OK"]);
	}, okButtonClickError:function (inSender) {
		app.alert("Error: " + inSender.message);
	}, cancelButtonClick:function (inSender) {
		wm.fire(this.owner, "dismiss");
	}, useLopEditorChange:function (inSender, inDisplayValue, inDataValue) {
		studio.setUserSettings({useLop:inDataValue});
	}, _end:0});
}
if (!dojo._hasResource["wm.studio.pages.QueryEditor.QueryEditor"]) {
	dojo._hasResource["wm.studio.pages.QueryEditor.QueryEditor"] = true;
	dojo.provide("wm.studio.pages.QueryEditor.QueryEditor");
	dojo.declare("QueryEditor", wm.Page, {EOL:"\n", QUERY_COMMENT:"--", selectedQueryName:null, dataModelName:null, valueTypes:null, primitivesLongNameLookup:null, primitivesShortNameLookup:null, typesLongNameLookup:{}, typesShortNameLookup:{}, hasChanges:false, _startCalled:false, start:function () {
		if (this._startCalled) {
			return;
		}
		this._startCalled = true;
		this.subscribe("wm-project-changed", this, "update");
		this.update();
	}, update:function () {
		this.selectedQueryName = null;
		this._enableAll(false);
		this._clear();
		this.updateDataModelInput();
	}, saveQuery:function (inSender) {
		if (this._canSaveQuery()) {
			this._saveQuery();
		} else {
			app.alert("Enter query details before saving.");
		}
	}, removeQuery:function (inSender) {
		var name = this.selectedQueryName;
		if (!name) {
			return;
		}
		app.confirm("Are you sure you want to delete \"" + name + "\"?", false, dojo.hitch(this, "_removeQuery"), null);
	}, _removeQuery:function () {
		var name = this.selectedQueryName;
		this.selectedQueryName = null;
		studio.beginWait("Deleting Query...");
		studio.dataService.requestSync(REMOVE_QUERY_OP, [this.dataModelName, name], dojo.hitch(this, "_removedQuery"));
	}, addQuery:function (inSender) {
		if (!this._startCalled) {
			this.start();
		}
		this.query = null;
		this._clear();
		this._enableAll(true);
		this.saveQueryBtn.setDisabled(false);
		this.queryDataModelInput.setDisabled(false);
	}, selectQuery:function (inQuery) {
		if (!this._startCalled) {
			this.start();
		}
		this.query = inQuery;
		this.dataModelName = this.query.dataModelName;
		this.selectedQueryName = this.query.queryName;
		this.updateDataModelInput();
		this._clear();
		this._loadTypes();
		this._enableAll(true);
		this.saveQueryBtn.setDisabled(true);
		var args = [this.dataModelName, this.selectedQueryName];
		studio.dataService.requestAsync(LOAD_QUERY_OP, args, dojo.hitch(this, "_getQueryResult"));
	}, queryNameKeyPress:function (inSender) {
		setTimeout(dojo.hitch(this, "queryNameChanged"), 0);
	}, queryNameChanged:function (inSender) {
		this._queryChanged();
	}, queryCommentKeyPress:function (inSender) {
		setTimeout(dojo.hitch(this, "queryCommentChanged"), 0);
	}, queryCommentChanged:function (inSender) {
		this._queryChanged();
	}, queryTextAreaKeyPress:function (inSender) {
		setTimeout(dojo.hitch(this, "queryTextAreaChanged"), 0);
	}, queryTextAreaChanged:function (inSender) {
		this._queryChanged();
		this.runQueryBtn.setDisabled(false);
	}, singleResultKeyPress:function (inSender) {
		setTimeout(dojo.hitch(this, "singleResultChanged"), 0);
	}, singleResultChanged:function (inSender) {
		this._queryChanged();
	}, runQuery:function (inSender) {
		if (this._getQueryValue() == "") {
			app.alert("Nothing to run, please enter a query");
			return;
		}
		this.emptyResultSetLabel.setShowing(false);
		this.queryOutputList.setShowing(true);
		for (var i in DML_OPERATIONS) {
			var op = DML_OPERATIONS[i];
			if (this._getQueryValue().toLowerCase().indexOf(op) == 0) {
				if (!confirm("Are you sure you run a DML operation?")) {
					return;
				}
			}
		}
		this.queryOutputList.clear();
		var runQueryInput = [];
		var bindParamValues = this._buildBindParms();
		runQueryInput = [this.dataModelName, this._getQueryValue(), this._getQueryInputs(), bindParamValues, this.maxResultsInput.getDataValue()];
		studio.beginWait("Running Query...");
		studio.dataService.requestAsync(RUN_QUERY_OP, runQueryInput, dojo.hitch(this, "_runQueryResult"), dojo.hitch(this, "_runQueryError"));
	}, _buildBindParms:function () {
		var parms = "";
		for (var i = 0; i < this.queryInputsList._data.length; i++) {
			var list = this.queryInputsList._data[i].list;
			var val = this.queryInputsList._data[i].value;
			if (val == null || val == undefined || val.length == 0) {
				continue;
			}
			if (list) {
				val = "[" + val + "]";
			}
			(i == 0) ? (parms = parms + val) : (parms = parms + ", " + val);
		}
		if (parms.length == 0) {
			return null;
		} else {
			return parms;
		}
	}, isDirty:function () {
		return this.hasChanges;
	}, updateDataModelInput:function () {
		var names = [];
		var cs = studio.application && studio.application.getServerComponents();
		for (var i in cs) {
			var c = cs[i];
			if (c.declaredClass == "wm.DataModel") {
				names.push(c.dataModelName);
			}
		}
		this.queryDataModelInput.editor.setOptions(names.join());
		if (names.length) {
			this.queryDataModelInput.setDataValue(this.dataModelName || names[0]);
		}
	}, _saveQuery:function () {
		var name = dojo.string.trim(this.queryNameInput.getDataValue());
		var cs = studio.application.getServerComponents();
		for (var i in cs) {
			var c = cs[i];
			if (c.declaredClass == "wm.Query" && c.dataModelName == this.dataModelName && c.queryName == name) {
				app.confirm("Overwrite existing query \"" + name + "\"?", false, dojo.hitch(this, "_saveQuery2"), null);
				return;
			}
		}
		this._saveQuery2();
	}, _saveQuery2:function () {
		var name = dojo.string.trim(this.queryNameInput.getDataValue());
		if (this.query) {
			this.query.newName = name;
		}
		studio.beginWait("Saving Query: " + name);
		this._checkQuery();
	}, _checkQuery:function () {
		var bindParamValues = this._buildBindParms();
		checkQueryInput = [this.dataModelName, this._getQueryValue(), this._getQueryInputs(), bindParamValues];
		studio.dataService.requestAsync(CHECK_QUERY_OP, checkQueryInput, dojo.hitch(this, "_checkQueryCompleted"), dojo.hitch(this, "_saveQueryError"));
	}, _checkQueryCompleted:function () {
		this._updateQuery();
		app.toastSuccess("Query Saved");
	}, _updateQuery:function () {
		var name = dojo.string.trim(this.queryNameInput.getDataValue());
		this.selectedQueryName = name;
		var comment = dojo.string.trim(this.queryCommentInput.getDataValue() || "");
		var sr = this.returnsSingleResultCheckBox.editor.getChecked();
		var fqOutputType = null;
		var queryInfo = {name:name, comment:comment, query:this._getQueryValue(), isHQL:true, inputs:this._getQueryInputs(), outputType:fqOutputType, returnsSingleResult:sr};
		studio.dataService.requestAsync(SAVE_QUERY_OP, [this.dataModelName, queryInfo], dojo.hitch(this, "_saveQueryCompleted"), dojo.hitch(this, "_saveQueryError"));
	}, _saveQueryCompleted:function () {
		studio.updateServices();
		studio.endWait();
		this._resetChanges();
		this.saveQueryBtn.setDisabled(true);
		this.queryDataModelInput.setDisabled(true);
		if (!this.query || this.query.name != this.query.newName) {
			this.deleteQuery = this.query;
			var n = this.queryNameInput.getDataValue();
			this.query = new wm.Query({name:n, dataModelName:this.dataModelName, queryName:n});
			studio.application.addServerComponent(this.query);
			if (this.deleteQuery) {
				app.confirm("Your new query has been saved; do you want to delete the original or keep both the new query and the original?", false, dojo.hitch(this, "_deleteOriginalQuery"), dojo.hitch(this, "_keepOriginalQuery"), "Delete", "Keep Original");
				return;
			}
		}
		studio.refreshWidgetsTree();
		studio.selected = null;
		studio.select(this.query);
	}, _keepOriginalQuery:function () {
		studio.refreshWidgetsTree();
		studio.selected = null;
		studio.select(this.query);
	}, _deleteOriginalQuery:function () {
		studio.beginWait("Deleting Query...");
		var _this = this;
		studio.dataService.requestSync(REMOVE_QUERY_OP, [this.deleteQuery.dataModelName, this.deleteQuery.name], function () {
			studio.application.removeServerComponent(_this.deleteQuery);
			studio.refreshWidgetsTree();
			studio.selected = null;
			studio.select(_this.query);
			studio.endWait();
		});
	}, _saveQueryError:function (inError) {
		studio.endWait();
		app.alert("Error saving query: " + inError.message);
	}, _queryChanged:function () {
		this.saveQueryBtn.setDisabled(false);
		this.hasChanges = true;
	}, _getQueryInputs:function () {
		var qi = [];
		for (var i = 0; i < this.queryInputsList._data.length; i++) {
			var q = this.queryInputsList._data[i];
			var type = this.typesLongNameLookup[q.type];
			qi.push({paramName:q.name, paramType:type, list:q.list});
		}
		return qi;
	}, _getQueryValue:function () {
		var rtn = this.queryTextArea.getInputValue();
		if (rtn.charAt(rtn.length - 1) == ";") {
			rtn = rtn.substring(0, rtn.length - 1);
		}
		rtn = dojo.string.trim(rtn);
		var lines = rtn.split(this.EOL);
		rtn = "";
		for (var i = 0; i < lines.length; i++) {
			var line = dojo.string.trim(lines[i]);
			if (line.indexOf(this.QUERY_COMMENT) == 0) {
				continue;
			}
			rtn += line + this.EOL;
		}
		return rtn;
	}, _runQueryResult:function (inResult) {
		studio.endWait();
		if (inResult.length == 0) {
			this.emptyResultSetLabel.setShowing(true);
			this.queryOutputList.setShowing(false);
		} else {
			this.queryOutputList.renderData(inResult);
		}
	}, _runQueryError:function (inError) {
		studio.endWait();
		app.alert("Run query error: " + inError.message);
	}, _setTypes:function () {
		this.typesLongNameLookup = {};
		this.typesShortNameLookup = {};
		var names = [];
		for (var shortName in this.primitivesLongNameLookup) {
			names.push(shortName);
			var longName = this.primitivesLongNameLookup[shortName];
			this.typesLongNameLookup[shortName] = longName;
			this.typesShortNameLookup[longName] = shortName;
		}
		names.sort();
		var dataModelTypes = getDataModelTypeNames(this.typeRefTree, this.dataModelName, this.valueTypes);
		for (var shortName in dataModelTypes) {
			names.push(shortName);
			var longName = dataModelTypes[shortName];
			this.typesLongNameLookup[shortName] = longName;
			this.typesShortNameLookup[longName] = shortName;
		}
		this.bindTypeInput.editor.setOptions(names.join());
		this.bindTypeInput.beginEditUpdate();
		this.bindTypeInput.setDisplayValue(JAVA_INT_TYPE);
		this.bindTypeInput.endEditUpdate();
	}, addBindParam:function (inSender) {
		if (this.bindNameInput.getDataValue() == "") {
			app.alert("The bind parameter name is required");
			return;
		}
		var bp = {name:"", type:"Integer", list:false, value:null};
		this.queryInputsList._data.push(bp);
		this.queryInputsList._render();
		this._queryChanged();
		this.queryInputsList.eventSelect(this.queryInputsList.getItem(this.queryInputsList._data.length - 1));
		this.bindNameInput.focus();
	}, removeBindParam:function (inSender) {
		var s = this.queryInputsList.selected;
		if (s) {
			this.queryInputsList._data.splice(s.index, 1);
			this.queryInputsList._render();
			this._queryChanged();
		}
	}, bindValue:function (inSender) {
		var s = this.queryInputsList.selected;
		if (s == null) {
			return;
		}
		var sIndex = s.index;
		s.list._data[sIndex].value = this.bindParamInput.getDataValue();
		this.queryInputsList._render();
		this.queryInputsList.selectByIndex(sIndex);
	}, parmSelected:function (inSender) {
		this._paramSelecting = true;
		var s = this.queryInputsList.selected;
		var sIndex = s.index;
		this.bindNameInput.setDataValue(s.list._data[sIndex].name);
		this.bindTypeInput.setDataValue(s.list._data[sIndex].type);
		this.bindTypeInput.setDataValue(s.list._data[sIndex].type);
		this.isInputListCheckBox.editor.setChecked(s.list._data[sIndex].list);
		this.bindParamInput.setDataValue(s.list._data[sIndex].value);
		this._paramSelecting = false;
	}, parameterPropEdit:function (inSender) {
		if (this._paramSelecting) {
			return;
		}
		var bp = {name:this.bindNameInput.getDataValue(), type:this.bindTypeInput.getDisplayValue(), list:this.isInputListCheckBox.editor.getChecked(), value:this.bindParamInput.getDataValue()};
		var selectedIndex = this.queryInputsList.getSelectedIndex();
		this.queryInputsList._data[selectedIndex] = bp;
		this.queryInputsList._render();
		this._queryChanged();
		var item = this.queryInputsList.getItem(selectedIndex);
		if (item) {
			this.queryInputsList.eventSelect(item);
		}
	}, _clear:function () {
		this.bindNameInput.setDataValue("");
		this.bindParamInput.setDataValue("");
		this.queryNameInput.setDataValue("");
		this.queryCommentInput.setDataValue("");
		this.queryTextArea.setInputValue("");
		this.queryInputsList.clear();
		this.queryInputsList._data = [];
		this.queryOutputList.clear();
		this._resetChanges();
		this.saveQueryBtn.setDisabled(true);
		this.runQueryBtn.setDisabled(true);
		this.delQueryBtn.setDisabled(true);
		this.newQueryBtn.setDisabled(true);
	}, _resetChanges:function () {
		this.hasChanges = false;
	}, _getQueryResult:function (inResponse) {
		this._getQueryOutputChanged(inResponse);
		if (inResponse) {
			this.queryDataModelInput.setDisplayValue(this.dataModelName);
			this.queryDataModelInput.setDisabled(true);
			this.queryNameInput.setDataValue(inResponse.name);
			this.queryTextArea.setInputValue(inResponse.query);
		}
	}, _getQueryOutputChanged:function (inData) {
		this.queryInputsList._data = [];
		for (var i = 0, j = inData.inputs.length; i < j; i++) {
			var name = inData.inputs[i]["paramName"];
			var typeName = inData.inputs[i]["paramType"];
			var list = inData.inputs[i]["list"];
			this.queryInputsList._data.push({name:name, type:this.typesShortNameLookup[typeName], list:list, value:""});
		}
		this.queryInputsList._render();
		this.returnsSingleResultCheckBox.editor.setChecked(inData.returnsSingleResult);
		this.queryNameInput.setDataValue(inData.name);
		this.queryCommentInput.setDataValue(inData.comment);
		this.queryTextArea.setInputValue(inData.query);
	}, _canSaveQuery:function () {
		var qn = this.queryNameInput.getDataValue();
		var q = this._getQueryValue();
		return dojo.string.trim(qn) != "" && dojo.string.trim(q) != "";
	}, _removedQuery:function () {
		studio.endWait();
		this._clear();
		studio.application.removeServerComponent(this.query);
		studio.refreshWidgetsTree();
	}, _loadTypes:function () {
		studio.servicesService.requestSync(LOAD_PRIMITIVES_OP, [], dojo.hitch(this, "_primitivesLoaded"));
	}, _primitivesLoaded:function (inData) {
		this.primitivesShortNameLookup = {};
		for (var shortName in inData) {
			var longName = inData[shortName];
			this.primitivesShortNameLookup[longName] = shortName;
		}
		this.primitivesLongNameLookup = inData;
		studio.dataService.requestSync(LOAD_DATA_TYPES_TREE_OP, [], dojo.hitch(this, "_loadedDataTypes"));
	}, _loadedDataTypes:function (inData) {
		this.typeRefTree.renderData(inData.dataObjectsTree);
		this.valueTypes = inData.valueTypes;
		this._setTypes();
	}, _enableAll:function (enable) {
		this.newQueryBtn.setDisabled(!enable);
		this.delQueryBtn.setDisabled(!enable);
		this.saveQueryBtn.setDisabled(!enable);
		this.queryNameInput.setDisabled(!enable);
		this.queryCommentInput.setDisabled(!enable);
		this.queryTextArea.setDisabled(!enable);
		this.returnsSingleResultCheckBox.setDisabled(!enable);
		this.queryInputsList.setDisabled(!enable);
		this.deleteParamBtn.setDisabled(!enable);
		this.bindNameInput.setDisabled(!enable);
		this.addInputBtn.setDisabled(!enable);
		this.bindParamInput.setDisabled(!enable);
		this.runQueryBtn.setDisabled(!enable);
		this.maxResultsInput.setDisabled(!enable);
	}, queryDataModelInputChange:function (inSender, inDisplayValue, inDataValue) {
		this.dataModelName = inDisplayValue;
		this._loadTypes();
	}, _end:0});
}
if (!dojo._hasResource["wm.studio.pages.QueueDialog.QueueDialog"]) {
	dojo._hasResource["wm.studio.pages.QueueDialog.QueueDialog"] = true;
	dojo.provide("wm.studio.pages.QueueDialog.QueueDialog");
	dojo.declare("QueueDialog", wm.Page, {start:function () {
		this.list.toggleSelect = true;
		this.update();
	}, update:function () {
		if (this.binding) {
			this.updateSelect();
			this.updateList();
		}
	}, updateSelect:function () {
		var d = this.binding.getAvailableServicesList();
		this.select.setOptionData(d);
	}, updateList:function () {
		var d = [], services = this.binding.getServicesList();
		dojo.forEach(services, function (s) {
			d.push(s.name);
		});
		this.list._data = d;
		this.list._render();
	}, listSelect:function (inSender, inItem) {
		var d = inItem.getData(), i = dojo.indexOf(this.select._data, d);
		if (i != -1) {
			this.select.setSelectedIndex(i);
		}
	}, addButtonClick:function (inSender) {
		var s = this.list.selected, i = (s ? s.index : this.list.getCount() - 1) + 1, d = this.list._data, v = this.select.getInputValue();
		if (i != undefined) {
			d.splice(i, 0, v);
		} else {
			d.push(v);
		}
		this.list._render();
		this.selectListItem(i);
	}, deleteButtonClick:function (inSender) {
		var s = this.list.selected, i = s && s.index, d = this.list._data;
		if (i != undefined) {
			d.splice(i, 1);
			this.list._render();
			this.selectListItem(i);
		}
	}, selectListItem:function (inIndex) {
		var item = this.list.getItem(inIndex != undefined ? inIndex : this.list._data.length - 1);
		this.list.select(item);
	}, applyButtonClick:function (inSender) {
		this.binding.services = this.list._data.join(",");
		wm.fire(this.owner, "dismiss");
	}, cancelButtonClick:function (inSender) {
		wm.fire(this.owner, "dismiss");
	}, moveUpButtonClick:function () {
		this.moveSelected(-1);
	}, moveDownButtonClick:function () {
		this.moveSelected(1);
	}, moveSelected:function (inDelta) {
		var swap = function (inData, inIndex1, inIndex2) {
			var t = inData[inIndex1];
			inData[inIndex1] = inData[inIndex2];
			inData[inIndex2] = t;
		}, l = this.list, s = l.selected;
		if (!s) {
			return;
		}
		var b = s.index, e = b + inDelta;
		e = Math.max(0, Math.min(e, this.list.getCount() - 1));
		if (b != e) {
			swap(l._data, b, e);
			l._render();
			this.selectListItem(e);
		}
	}, _end:0});
}
if (!dojo._hasResource["wm.studio.pages.RegistrationDialog.RegistrationDialog"]) {
	dojo._hasResource["wm.studio.pages.RegistrationDialog.RegistrationDialog"] = true;
	dojo.provide("wm.studio.pages.RegistrationDialog.RegistrationDialog");
	dojo.declare("RegistrationDialog", wm.Page, {dialogReference:null, start:function () {
	}, skipButtonClick:function (inSender) {
		studio.registrationService.requestAsync("setRegistrationChoice", ["Skip"]);
		wm.fire(this.owner, "dismiss");
		return inSender;
	}, registerButtonClick:function (inSender) {
		studio.registrationService.requestAsync("setRegistrationChoice", ["Register"]);
		window.open("http://www.wavemaker.com/community/dlreg.html", "wmregistration");
		wm.fire(this.owner, "dismiss");
		return inSender;
	}, laterButtonClick:function (inSender) {
		studio.registrationService.requestAsync("setRegistrationChoice", ["Later"]);
		wm.fire(this.owner, "dismiss");
		return inSender;
	}, _end:0});
}
if (!dojo._hasResource["wm.studio.pages.RestServiceBuilder.RestServiceBuilder"]) {
	dojo._hasResource["wm.studio.pages.RestServiceBuilder.RestServiceBuilder"] = true;
	dojo.provide("wm.studio.pages.RestServiceBuilder.RestServiceBuilder");
	dojo.declare("RestServiceBuilder", wm.Page, {IMPORT_TYPE_URL:"URL", IMPORT_TYPE_FILE:"File", start:function () {
		this.updateSelect(this.inParamTypeInput, ["string", "int"]);
		this.updateSelect(this.methodInput, ["GET", "POST"]);
		this.methodInput.setValue("displayValue", "GET");
		this.contentTypeInput.setValue("displayValue", "text/xml");
		this.updateSelect(this.pathTypeInput, [this.IMPORT_TYPE_URL]);
		this.pathTypeInput.setValue("displayValue", this.IMPORT_TYPE_URL);
		this.schemaFileRadioInputChange();
		this.schemaTextRadioInputChange();
	}, updateSelect:function (inSelect, inData) {
		var s = inSelect, o;
		if (inData == null) {
			o = null;
		} else {
			o = inData.join(",");
		}
		s.displayValue = "";
		s.editor.setOptions(o);
	}, saveButtonClick:function (inSender) {
		this.buildRestService(false);
	}, buildRestService:function (inOverwrite) {
		var w = (inOverwrite == undefined || inOverwrite == null) ? false : inOverwrite;
		var sname = this.serviceNameInput.getValue("displayValue");
		var opname = this.serviceOpInput.getValue("displayValue");
		if (!sname || sname.length == 0 || !opname || opname.length == 0) {
			app.alert("Service name and operation name are required!");
			return;
		}
		var d = this.inParamsList._data;
		var url = this.urlInput.getValue("displayValue");
		if (!url || url.length == 0) {
			app.alert("Missing Service URL!");
			return;
		}
		var m = this.methodInput.getValue("displayValue");
		var ct = this.contentTypeInput.getValue("displayValue");
		var output;
		if (this.outIsRawStringInput.getChecked()) {
			output = "string";
		} else {
			output = this.outTypeInput.getValue("displayValue");
		}
		if (!output || output == "(None)") {
			output = null;
		}
		var schemaPath = null, schemaText = null;
		if (output != "string") {
			if (this.isSchemaFileRadioSelected()) {
				if (this.pathTypeInput.getValue("displayValue") == this.IMPORT_TYPE_URL) {
					schemaPath = this.xmlSchemaUrlInput.getValue("displayValue");
				} else {
					schemaPath = this.xmlSchemaFileInput.fileNode.value;
				}
			} else {
				schemaText = this.xmlSchemaTextInput.getValue("displayValue");
			}
		}
		studio.beginWait("Importing REST Service...");
		studio.webService.requestAsync("buildRestService", [sname, opname, d, url, m, ct, output, schemaText, schemaPath, w], dojo.hitch(this, "buildRestServiceSuccess"), dojo.hitch(this, "buildRestServiceError"));
	}, buildRestServiceSuccess:function (inResponse) {
		studio.endWait();
		if (inResponse == "$already_exists$") {
			app.confirm("The service name already exists. Overwrite?", false, dojo.hitch(this, function () {
				this.buildRestService(true);
			}));
		} else {
			this.owner.owner.importCompleted(inResponse);
		}
	}, buildRestServiceError:function (inError) {
		studio.endWait();
		app.alert("Error occurred while importing REST service!\n" + inError);
	}, clearAll:function (inSender) {
		this.serviceNameInput.clear();
		this.serviceOpInput.clear();
		this.methodInput.setValue("displayValue", "GET");
		this.contentTypeInput.setValue("displayValue", "text/xml");
		this.inParamsList.clear();
		this.urlInput.clear();
		this.updateSelect(this.outTypeInput, null);
		this.outTypeInput.clear();
		this.outIsRawStringInput.setChecked(false);
		this.xmlSchemaFileInput.fileNode.value = "";
		this.xmlSchemaUrlInput.clear();
		this.xmlSchemaTextInput.clear();
	}, populateButtonClick:function (inSender) {
		this.owner.owner.layers.setLayer("restUrlLayer");
		this.owner.owner.importButton.setDisabled(true);
		this.owner.owner.restUrlPage.page.clearAll();
	}, populate:function () {
		var url = this.owner.owner.restUrlPage.page.url;
		if (url) {
			studio.beginWait("Populating...");
			studio.webService.requestAsync("generateRESTWsdlSettings", [url], dojo.hitch(this, "generateRESTWsdlSettingsSuccess"), dojo.hitch(this, "generateRESTWsdlSettingsError"));
		}
	}, generateRESTWsdlSettingsSuccess:function (inResponse) {
		studio.endWait();
		this.serviceNameInput.setValue("displayValue", inResponse.serviceName);
		this.serviceOpInput.setValue("displayValue", inResponse.operationName);
		var d = inResponse.inputs;
		this.inParamsList.renderData(d);
		this.urlInput.setValue("displayValue", inResponse.parameterizedUrl);
		this.schemaTextRadioInput.components.editor.setChecked(true);
		if (inResponse.outputType && inResponse.outputType == "string") {
			this.outIsRawStringInput.setChecked(true);
		} else {
			this.outIsRawStringInput.setChecked(false);
			this.xmlSchemaTextInput.setValue("displayValue", inResponse.xmlSchemaText);
			this.getSchemaElementTypes(inResponse.outputType);
		}
	}, generateRESTWsdlSettingsError:function (inError) {
		studio.endWait();
	}, addInParamButtonClick:function (inSender) {
		var name = dojo.trim(this.inParamNameInput.getValue("displayValue"));
		var type = dojo.trim(this.inParamTypeInput.getValue("displayValue"));
		if (name && type) {
			var d = this.inParamsList._data;
			if (d == null) {
				d = [];
			}
			for (var i = 0; i < d.length; i++) {
				if (d[i] && d[i].name == name) {
					app.alert("Parameter name already exists, please type in another one!");
					return;
				}
			}
			d.push({name:name, type:type});
			this.inParamsList.renderData(d);
			this.inParamNameInput.clear();
			this.inParamTypeInput.clear();
		}
	}, removeInParamButtonClick:function (inSender) {
		if (this.inParamsList.selected) {
			var d = this.inParamsList._data;
			var nd = [];
			for (var i = 0; i < d.length; i++) {
				if (i != this.inParamsList.selected.index) {
					nd.push(d[i]);
				}
			}
			this.inParamsList.renderData(nd);
		}
	}, parameterizedButtonClick:function (inSender) {
		var url = this.urlInput.getValue("displayValue");
		if (url) {
			var d = this.inParamsList._data;
			if (d && d.length > 0) {
				var queryString = "";
				for (var i = 0; i < d.length; i++) {
					queryString = queryString + d[i].name + "={" + d[i].name + "}" + (i + 1 == d.length ? "" : "&");
				}
				app.confirm("This will append the query string '" + queryString + "' to the Service URL. Proceed?", false, dojo.hitch(this, function () {
					this.urlInput.setValue("displayValue", (url + (url.indexOf("?") > -1 ? "&" : "?") + queryString));
				}));
			}
		}
	}, outIsRawStringInputChange:function (inSender, inDisplayValue, inDataValue) {
		var b = inSender.getChecked();
		this.outTypeInput.editor.setDisabled(b);
		this.xmlSchemaLabel.setDisabled(b);
		this.schemaFileRadioInput.setDisabled(b);
		this.schemaTextRadioInput.setDisabled(b);
		this.importXmlSchemaButton.setDisabled(b);
		if (b) {
			this.pathTypeInput.setDisabled(b);
			this.xmlSchemaFileInput.fileNode.disabled = b;
			this.xmlSchemaUrlInput.setDisabled(b);
			this.xmlSchemaTextInput.setDisabled(b);
			this.xml2SchemaButton.setDisabled(b);
		} else {
			this.schemaFileRadioInputChange();
			this.schemaTextRadioInputChange();
		}
	}, isSchemaFileRadioSelected:function () {
		return (this.schemaFileRadioInput.getGroupValue() == 1);
	}, schemaFileRadioInputChange:function (inSender, inDisplayValue, inDataValue) {
		var b = this.isSchemaFileRadioSelected();
		this.pathTypeInput.setDisabled(b);
		this.xmlSchemaFileInput.fileNode.disabled = b;
		this.xmlSchemaUrlInput.setDisabled(b);
		this.xmlSchemaTextInput.setDisabled(!b);
		this.xml2SchemaButton.setDisabled(!b);
	}, schemaTextRadioInputChange:function (inSender, inDisplayValue, inDataValue) {
		var b = this.isSchemaFileRadioSelected();
		this.pathTypeInput.setDisabled(!b);
		this.xmlSchemaFileInput.fileNode.disabled = !b;
		this.xmlSchemaUrlInput.setDisabled(!b);
		this.xmlSchemaTextInput.setDisabled(b);
		this.xml2SchemaButton.setDisabled(b);
	}, importXmlSchemaButtonClick:function (inSender) {
		this.getSchemaElementTypes();
	}, getSchemaElementTypes:function (inType) {
		var schemaPath = null, schemaText = null;
		if (this.isSchemaFileRadioSelected()) {
			if (this.pathTypeInput.getValue("displayValue") == this.IMPORT_TYPE_URL) {
				schemaPath = this.xmlSchemaUrlInput.getValue("displayValue");
			} else {
				schemaPath = this.xmlSchemaFileInput.fileNode.value;
			}
		} else {
			schemaText = this.xmlSchemaTextInput.getValue("displayValue");
		}
		studio.webService.requestAsync("getSchemaElementTypes", [schemaPath, schemaText], dojo.hitch(this, "getSchemaElementTypesSuccess", inType), dojo.hitch(this, "getSchemaElementTypesError"));
	}, getSchemaElementTypesSuccess:function (inType, inResponse) {
		var r = inResponse;
		if (r) {
			var o = (this.inParamTypeInput.editor.options.split(",")).concat(r);
			this.updateSelect(this.inParamTypeInput, o);
			r.push("(None)");
		}
		this.updateSelect(this.outTypeInput, r);
		if (inType) {
			this.outTypeInput.setValue("displayValue", inType);
		} else {
			if (r && r.length > 0) {
				this.outTypeInput.setValue("displayValue", r[0]);
			}
		}
	}, getSchemaElementTypesError:function (inError) {
	}, xml2SchemaButtonClick:function (inSender) {
		var xml = this.xmlSchemaTextInput.getValue("displayValue");
		if (xml) {
			app.confirm("This will generate a XML Schema for the sample XML response entered in the text area. Proceed?", false, dojo.hitch(this, function () {
				studio.beginWait("Generating XML Schema...");
				studio.webService.requestAsync("convertXmlToSchema", [xml], dojo.hitch(this, "convertXmlToSchemaSuccess"), dojo.hitch(this, "convertXmlToSchemaError"));
			}));
		}
	}, convertXmlToSchemaSuccess:function (inResponse) {
		studio.endWait();
		this.xmlSchemaTextInput.setValue("displayValue", inResponse);
		this.getSchemaElementTypes();
	}, convertXmlToSchemaError:function (inError) {
		studio.endWait();
		app.alert("Error occurred while Generating XML Schema!\n" + inError);
	}, pathTypeInputChange:function (inSender, inValue) {
		var b = (inValue == this.IMPORT_TYPE_URL);
		this.xmlSchemaFileInput.setShowing(!b);
		this.xmlSchemaUrlInput.setShowing(b);
	}, _end:0});
}
if (!dojo._hasResource["wm.studio.pages.RestUrlDialog.RestUrlDialog"]) {
	dojo._hasResource["wm.studio.pages.RestUrlDialog.RestUrlDialog"] = true;
	dojo.provide("wm.studio.pages.RestUrlDialog.RestUrlDialog");
	dojo.declare("RestUrlDialog", wm.Page, {start:function () {
		this.url = null;
	}, clearAll:function () {
		this.urlInput.clear();
		this.responseTextArea.clear();
		this.errorMessageTextArea.clear();
		this.errorMessageTextArea.setShowing(false);
	}, testBtnClick:function (inSender) {
		var u = this.urlInput.getValue("displayValue");
		if (u) {
			studio.beginWait("Invoking REST Service...");
			studio.webService.requestAsync("invokeRestCall", [u], dojo.hitch(this, "invokeRestCallSuccess"), dojo.hitch(this, "invokeRestCallError"));
		}
	}, invokeRestCallSuccess:function (inResponse) {
		studio.endWait();
		if (inResponse && inResponse.length > 0) {
			this.responseTextArea.setValue("displayValue", inResponse[0]);
			this.errorMessageTextArea.setShowing((inResponse.length > 1));
			if (inResponse.length > 1) {
				this.errorMessageTextArea.setValue("displayValue", inResponse[1]);
			}
		}
	}, invokeRestCallError:function (inError) {
		studio.endWait();
	}, populateBtnClick:function (inSender) {
		var u = this.urlInput.getValue("displayValue");
		if (u) {
			this.url = u;
			this.owner.owner.layers.setLayer("restBuilderLayer");
			this.owner.owner.importButton.setDisabled(false);
			this.owner.owner.restServiceBuilderPage.page.populate();
		}
	}, cancelBtnClick:function (inSender) {
		this.url = null;
		this.owner.owner.layers.setLayer("restBuilderLayer");
		this.owner.owner.importButton.setDisabled(false);
	}, _end:0});
}
if (!dojo._hasResource["wm.studio.pages.Security.Security"]) {
	dojo._hasResource["wm.studio.pages.Security.Security"] = true;
	dojo.provide("wm.studio.pages.Security.Security");
	dojo.declare("Security", wm.Page, {SELECT_ONE:"- Select One -", NO_VALUE:"(no value)", start:function () {
		this.loginTemplateFolder = dojo.moduleUrl("wm.studio.app") + "templates/security/";
		this.loginPageTemplateFolder = this.loginTemplateFolder + "pages/Login/";
		this.populatingOptions = false;
		this.subscribe("wm-project-changed", this, "studioProjectChanged");
		this.update();
		dojo.connect(dojo.byId("HelpUID1"), "onclick", this, "showUIDHelp1");
		dojo.connect(dojo.byId("HelpUID2"), "onclick", this, "showUIDHelp2");
	}, showUIDHelp1:function () {
		var bd = this.getHelpDialog();
		bd.page.setHeader("", "Username Field");
		bd.sourceNode = this.databaseLayer.domNode;
		bd.positionNode = this.databaseLayer.domNode;
		bd.page.setContent("Select the user name that the user will type in to log in.  Typically an email address or identifier that is based on the user's personal name.  You can find the value of the logged in user's username in your application by <ol><li>creating a new ServiceVariable</li><li>set its 'service' to 'securityService'</li><li>select the operation 'getUserName'</li></ol>");
		bd.show();
	}, showUIDHelp2:function () {
		var bd = this.getHelpDialog();
		bd.page.setHeader("", "User ID Field");
		bd.sourceNode = this.databaseLayer.domNode;
		bd.positionNode = this.databaseLayer.domNode;
		bd.page.setContent("Select the user ID that uniquely identifies the user in the database.  This is typically a number that the database has assigned to the user's entry in the database.  While you can use an email address, this tends to result in a database that bogs down badly as the size of your database goes up as this value is used by other database tables to identify the user account the data is associated with. You can  find out the ID when your project is running by <ol><li>creating a new ServiceVariable</li><li>set its 'service' to 'securityService'</li><li>select the operation 'getUserId'</li></ol>");
		bd.show();
	}, getHelpDialog:function () {
		if (!this.helpDialog) {
			var props = {owner:this, pageName:"PopupHelp", scrimBackground:true, hideOnClick:false, positionLocation:" l"}, d = this.helpDialog = new wm.PagePopup(props);
			d.setContainerOptions(true, 500, 200);
		}
		var b = this.helpDialog;
		return b;
	}, studioProjectChanged:function () {
		this.update();
		this.updateRoles();
	}, update:function () {
		this.clearSelectInput(this.secProviderInput);
		this.initSecProviderInput();
		this.databaseOptions = {};
		this.secEnableInput.setChecked(true);
		this.showLoginPageInput.setChecked(true);
		this.ldapSearchRoleCheckbox.setChecked(false);
		this.ldapSearchRoleCheckboxChange(this.ldapSearchRoleCheckbox);
		this.dbRoleBySQLCheckbox.setChecked(false);
		this.dbRoleBySQLCheckboxChange(this.dbRoleBySQLCheckbox);
		this.demoUserList.renderData([{userid:"demo", password:"demo"}]);
		this.resetDatabaseInputs();
		this.resetLDAPInputs();
		this.populateGeneralOptions();
		this.populateRolesSetup();
	}, initSecProviderInput:function () {
		var l = [this.SELECT_ONE, "Demo", "Database"];
		if (studio.isModuleEnabled("security-driver", "wm.ldap")) {
			l.push("LDAP");
		}
		if (studio.isModuleEnabled("security-driver", "wm.josso")) {
			l.push("JOSSO");
		}
		this.updateSelect(this.secProviderInput, l);
		this.secProviderInputChange(this.secProviderInput, this.secProviderInput.editor.getEditorValue());
	}, updateSelect:function (inSelect, inData) {
		var s = inSelect, o;
		if (inData == null) {
			o = null;
		} else {
			o = inData.join(",");
		}
		s.displayValue = "";
		s.editor.setOptions(o);
	}, clearSelectInput:function (inSelect) {
		inSelect.beginEditUpdate();
		inSelect.components.editor.options = null;
		inSelect.clear();
		inSelect.endEditUpdate();
	}, getEditorDisplayValue:function (editor) {
		var v = editor.getDisplayValue();
		return v == this.NO_VALUE ? null : v;
	}, resetDatabaseInputs:function () {
		this.clearSelectInput(this.dbDataModelInput);
		this.clearSelectInput(this.dbEntityInput);
		this.clearSelectInput(this.dbUsernameInput);
		this.clearSelectInput(this.dbUseridInput);
		this.clearSelectInput(this.dbPasswordInput);
		this.clearSelectInput(this.dbRoleInput);
		this.clearSelectInput(this.tenantIdField);
		this.defTenantId.clear();
		this.dbRoleBySQLCheckbox.beginEditUpdate();
		this.dbRoleBySQLCheckbox.setChecked(false);
		this.dbRoleBySQLCheckboxChange(this.dbRoleBySQLCheckbox);
		this.dbRoleBySQLCheckbox.endEditUpdate();
		this.dbRoleBySQLInput.clear();
		this.dbTestSQLInput.clear();
		this.dbTestSQLResultList.clear();
		this.dbTestSQLErrorLabel.setCaption("");
	}, resetLDAPInputs:function () {
		this.ldapUrlInput.setDataValue("ldap://localhost:389/dc=wavemaker,dc=com");
		this.ldapManagerDnInput.setDataValue("cn=manager,dc=wavemaker,dc=com");
		this.ldapManagerPasswordInput.setDataValue("manager");
		this.ldapUserDnPatternInput.setDataValue("cn={0},ou=people");
		this.ldapSearchRoleCheckbox.setChecked(false);
		this.ldapGroupSearchBaseInput.setDataValue("ou=groups");
		this.ldapGroupRoleAttributeInput.setDataValue("cn");
		this.ldapGroupSearchFilterInput.setDataValue("(member={0})");
		this.ldapConnectionResultLabel.setCaption("");
	}, resetJOSSOInputs:function () {
	}, secProviderInputChange:function (inSender, inValue) {
		if (inValue == "Demo") {
			this.layers.setLayer("demoLayer");
			this.secEnableInput.setShowing(true);
			this.securityCheckboxChange();
		} else {
			if (inValue == "Database") {
				this.layers.setLayer("databaseLayer");
				if (!this.populatingOptions) {
					this.getDataModelList();
				}
				this.secEnableInput.setShowing(true);
				this.securityCheckboxChange();
			} else {
				if (inValue == "LDAP") {
					this.layers.setLayer("ldapLayer");
					this.secEnableInput.setShowing(true);
					this.securityCheckboxChange();
				} else {
					if (inValue == "JOSSO") {
						this.layers.setLayer("jossoLayer");
						this.secEnableInput.setShowing(true);
						this.securityCheckboxChange();
					} else {
						this.layers.setLayer("emptyLayer");
						this.secEnableInput.editor.setChecked(false);
						this.securityCheckboxChange();
						this.secEnableInput.setShowing(false);
					}
				}
			}
		}
	}, populateGeneralOptions:function () {
		studio.securityConfigService.requestSync("getGeneralOptions", null, dojo.hitch(this, "getGeneralOptionsResult"));
	}, getGeneralOptionsResult:function (inResponse) {
		if (inResponse) {
			this.secEnableInput.setChecked(inResponse.enforceSecurity);
			this.showLoginPageInput.setChecked(inResponse.enforceIndexHtml);
			var t = inResponse.dataSourceType;
			this.populatingOptions = true;
			this.secProviderInput.setDataValue(t);
			if (t == "Demo") {
				this.populateDemoOptions();
			} else {
				if (t == "Database") {
					this.getDataModelList();
					this.populateDatabaseOptions();
				} else {
					if (t == "LDAP") {
						this.populateLDAPOptions();
					} else {
						if (t == "JOSSO") {
							this.populateJOSSOOptions();
						}
					}
				}
			}
			this.populatingOptions = false;
		} else {
			this.secProviderInput.setDataValue(this.SELECT_ONE);
		}
		this.secProviderInputChange(this.secProviderInput, this.secProviderInput.editor.getEditorValue());
	}, populateJOSSOOptions:function () {
		studio.securityConfigService.requestAsync("getJOSSOOptions", null, dojo.hitch(this, "getJOSSOOptionsResult"));
	}, getJOSSOOptionsResult:function (inResponse) {
		this.roleList.renderData(inResponse);
	}, populateDemoOptions:function () {
		studio.securityConfigService.requestSync("getDemoOptions", null, dojo.hitch(this, "getDemoOptionsResult"));
	}, getDemoOptionsResult:function (inResponse) {
		this.demoUserList.renderData(inResponse.users);
	}, populateDatabaseOptions:function () {
		studio.securityConfigService.requestSync("getDatabaseOptions", null, dojo.hitch(this, "getDatabaseOptionsResult"));
	}, getDatabaseOptionsResult:function (inResponse) {
		this.databaseOptions = inResponse;
		this.dbDataModelInput.setDataValue(inResponse.modelName);
		this.dbDataModelInput.editor.changed();
	}, populateLDAPOptions:function () {
		studio.securityConfigService.requestSync("getLDAPOptions", null, dojo.hitch(this, "getLDAPOptionsResult"));
	}, getLDAPOptionsResult:function (inResponse) {
		this.ldapUrlInput.setDataValue(inResponse.ldapUrl);
		this.ldapManagerDnInput.setDataValue(inResponse.managerDn);
		this.ldapManagerPasswordInput.setDataValue(inResponse.managerPassword);
		this.ldapUserDnPatternInput.setDataValue(inResponse.userDnPattern);
		this.ldapSearchRoleCheckbox.setChecked(!inResponse.groupSearchDisabled);
		this.ldapGroupSearchBaseInput.setDataValue(inResponse.groupSearchBase);
		this.ldapGroupRoleAttributeInput.setDataValue(inResponse.groupRoleAttribute);
		this.ldapGroupSearchFilterInput.setDataValue(inResponse.groupSearchFilter);
	}, saveButtonClick:function (inSender) {
		if (this.secProviderInput.getDataValue() == this.SELECT_ONE) {
			return;
		}
		var t = this.layers.getLayer().caption;
		var err = this.checkErrorOnInputFields(t);
		if (err) {
			app.alert(err);
		} else {
			this.copyLoginFiles();
			if (t == "Demo") {
				studio.securityConfigService.requestSync("configDemo", [this.demoUserList._data, this.secEnableInput.getChecked(), this.showLoginPageInput.getChecked()], dojo.hitch(this, "configDemoResult"));
			} else {
				if (t == "Database") {
					var rolesQuery = null;
					if (this.dbRoleBySQLCheckbox.getChecked()) {
						rolesQuery = this.dbRoleBySQLInput.getDataValue();
					}
					studio.securityConfigService.requestSync("configDatabase", [this.dbDataModelInput.getDataValue(), this.dbEntityInput.getDataValue(), this.getEditorDisplayValue(this.dbUsernameInput), this.getEditorDisplayValue(this.dbUseridInput), this.getEditorDisplayValue(this.dbPasswordInput), this.getEditorDisplayValue(this.dbRoleInput), this.getEditorDisplayValue(this.tenantIdField) || "", this.defTenantId.getDataValue() || 0, rolesQuery, this.secEnableInput.getChecked(), this.showLoginPageInput.getChecked()], dojo.hitch(this, "configDatabaseResult"));
				} else {
					if (t == "LDAP") {
						studio.securityConfigService.requestSync("configLDAP", [this.ldapUrlInput.getDataValue(), this.ldapManagerDnInput.getDataValue(), this.ldapManagerPasswordInput.getDataValue(), this.ldapUserDnPatternInput.getDataValue(), !this.ldapSearchRoleCheckbox.getChecked(), this.ldapGroupSearchBaseInput.getDataValue(), this.ldapGroupRoleAttributeInput.getDataValue(), this.ldapGroupSearchFilterInput.getDataValue(), this.secEnableInput.getChecked(), this.showLoginPageInput.getChecked()], dojo.hitch(this, "configLDAPResult"));
					} else {
						if (t == "JOSSO") {
							var roles = this.roleList._data;
							studio.securityConfigService.requestSync("configJOSSO", [this.secEnableInput.getChecked(), roles[0]], dojo.hitch(this, "configJOSSOResult"));
							studio.application.loadServerComponents();
							studio.refreshWidgetsTree();
							return;
						}
					}
				}
			}
			this.saveRolesSetup();
			studio.application.loadServerComponents();
			studio.refreshWidgetsTree();
		}
	}, toastToSuccess:function () {
		app.toastDialog.showToast("Security settings saved; Security is " + (this.secEnableInput.getChecked() ? "ON" : "OFF"), 5000, "Success");
	}, configDemoResult:function (inResponse) {
		this.updateStudioServices();
		this.toastToSuccess();
	}, configDatabaseResult:function (inResponse) {
		this.updateStudioServices();
		this.toastToSuccess();
	}, configLDAPResult:function (inResponse) {
		this.updateStudioServices();
		this.toastToSuccess();
	}, configJOSSOResult:function (inResponse) {
		this.updateStudioServices();
		this.toastToSuccess();
	}, updateStudioServices:function () {
		studio.updateServices();
	}, checkErrorOnInputFields:function (dataSourceType) {
		if (!this.secEnableInput.getChecked()) {
			return err;
		}
		var err = null;
		if (dataSourceType == "Demo") {
			if (this.demoUserList._data == null || this.demoUserList._data.length == 0) {
				err = "At least one user needs to be added to the list!";
			}
		} else {
			if (dataSourceType == "Database") {
				if (!(this.dbDataModelInput.getDataValue() && this.dbEntityInput.getDataValue() && this.getEditorDisplayValue(this.dbUsernameInput) && this.getEditorDisplayValue(this.dbUseridInput) && this.getEditorDisplayValue(this.dbPasswordInput))) {
					err = "All required fields must be filled out!";
				}
			} else {
				if (dataSourceType == "LDAP") {
					if (!(this.ldapUrlInput.getDataValue() && this.ldapUserDnPatternInput.getDataValue())) {
						err = "All required fields must be filled out!";
					}
				} else {
					if (dataSourceType == "JOSSO") {
					}
				}
			}
		}
		return err;
	}, demoAddUserButtonClick:function (inSender) {
		var userid = this.demoUsernameInput.getDataValue();
		if (userid) {
			userid = dojo.trim(userid);
		}
		var password = this.demoPasswordInput.getDataValue();
		if (password) {
			password = dojo.trim(password);
		}
		var role = this.demoRoleInput.getDataValue();
		if (role) {
			role = dojo.trim(role);
		}
		if (userid && password) {
			var d = this.demoUserList._data;
			if (d == null) {
				d = [];
			}
			for (var i = 0; i < d.length; i++) {
				if (d[i] && d[i].userid == userid) {
					app.alert("Username already exists, please type in another one!");
					return;
				}
			}
			if (role) {
				d.push({userid:userid, password:password, roles:[role]});
			} else {
				d.push({userid:userid, password:password, roles:null});
			}
			this.demoUserList.renderData(d);
			this.demoUsernameInput.clear();
			this.demoPasswordInput.clear();
			this.demoRoleInput.clear();
		} else {
			app.alert("Username and Password fields cannot be empty!");
		}
	}, demoDeleteUserButtonClick:function (inSender) {
		if (this.demoUserList.selected) {
			var d = this.demoUserList._data;
			var nd = [];
			for (var i = 0; i < d.length; i++) {
				if (i != this.demoUserList.selected.index) {
					nd.push(d[i]);
				}
			}
			this.demoUserList.renderData(nd);
		}
	}, dbDataModelInputChange:function (inSender, inValue) {
		this.getTableList();
	}, dbEntityInputChange:function (inSender, inValue) {
		this.getPropertyList();
	}, getDataModelList:function () {
		studio.dataService.requestSync("getDataModelNames", null, dojo.hitch(this, "getDataModelListResult"));
	}, getDataModelListResult:function (inResponse) {
		if (inResponse) {
			var t = this.dbEntityInput.getDataValue();
			if (t) {
				this.databaseOptions.entityName = t;
			}
			this.updateSelect(this.dbDataModelInput, inResponse);
		}
	}, getTableList:function () {
		var d = this.dbDataModelInput.getDataValue();
		if (d) {
			studio.dataService.requestSync("getEntityNames", [d], dojo.hitch(this, "getTableListResult"));
		} else {
			this.updateSelect(this.dbEntityInput, null);
		}
	}, getTableListResult:function (inResponse) {
		if (inResponse) {
			this.updateSelect(this.dbEntityInput, inResponse);
			this.dbEntityInput.setDataValue(this.databaseOptions.entityName);
		}
	}, getPropertyList:function () {
		var d = this.dbDataModelInput.getDataValue();
		var t = this.dbEntityInput.getDataValue();
		if (d && t) {
			studio.securityConfigService.requestSync("getDatabaseProperties", [d, t], dojo.hitch(this, "getDatabasePropertiesResult"));
		} else {
			this.updateSelect(this.dbUsernameInput, null);
			this.updateSelect(this.dbUseridInput, null);
			this.updateSelect(this.dbPasswordInput, null);
			this.updateSelect(this.dbRoleInput, null);
		}
	}, getDatabasePropertiesResult:function (inResponse) {
		if (inResponse) {
			var pnames = [];
			for (var i = 0, p; p = inResponse[i]; i++) {
				if (p.compositeProperties && p.compositeProperties.length > 0) {
					for (var j = 0, cp; cp = p.compositeProperties[j]; j++) {
						pnames.push(cp.name);
					}
				} else {
					pnames.push(p.name);
				}
			}
			pnames.push(this.NO_VALUE);
			var u = this.getEditorDisplayValue(this.dbUsernameInput);
			var id = this.getEditorDisplayValue(this.dbUseridInput);
			var p = this.getEditorDisplayValue(this.dbPasswordInput);
			var r = this.getEditorDisplayValue(this.dbRoleInput);
			var tid = this.getEditorDisplayValue(this.tenantIdField);
			if (u) {
				this.databaseOptions.unamePropertyName = u;
			}
			if (id) {
				this.databaseOptions.uidPropertyName = id;
			}
			if (p) {
				this.databaseOptions.pwPropertyName = p;
			}
			if (r) {
				this.databaseOptions.rolePropertyName = r;
			}
			if (tid) {
				this.databaseOptions.tenantIdField = tid;
			}
			this.updateSelect(this.dbUsernameInput, pnames);
			this.updateSelect(this.dbUseridInput, pnames);
			this.updateSelect(this.dbPasswordInput, pnames);
			this.updateSelect(this.dbRoleInput, pnames);
			this.updateSelect(this.tenantIdField, pnames);
			this.dbUsernameInput.setDataValue(this.databaseOptions.unamePropertyName);
			this.dbUseridInput.setDataValue(this.databaseOptions.uidPropertyName);
			this.dbPasswordInput.setDataValue(this.databaseOptions.pwPropertyName || this.databaseOptions.pwColumnName.replace(/,.*$/, ""));
			this.dbRoleInput.setDataValue(this.databaseOptions.rolePropertyName);
			this.tenantIdField.setDataValue(this.databaseOptions.tenantIdField);
			this.defTenantId.setDataValue(this.databaseOptions.defTenantId || "");
			this.dbRoleBySQLCheckbox.setChecked(this.databaseOptions.useRolesQuery);
			this.dbRoleBySQLCheckboxChange(this.dbRoleBySQLCheckbox);
			if (this.databaseOptions.rolesByUsernameQuery) {
				this.dbRoleBySQLInput.setDataValue(this.databaseOptions.rolesByUsernameQuery);
			}
		}
	}, dbRoleBySQLCheckboxChange:function (inSender, inDisplayValue, inDataValue) {
		var c = inSender.components.editor.editor.checked;
		this.dbRoleInput.setDisabled(c);
		this.dbRoleBySQLInput.setShowing(c);
		this.dbRoleBySQLEnablePanel.setShowing(c);
	}, dbTestSQLButtonClick:function (inSender) {
		studio.beginWait("Running Query...");
		studio.securityConfigService.requestAsync("testRolesByUsernameQuery", [this.dbDataModelInput.getDataValue(), this.dbRoleBySQLInput.getDataValue(), this.dbTestSQLInput.getDataValue()], dojo.hitch(this, "testRolesByUsernameQueryResult"), dojo.hitch(this, "testRolesByUsernameQueryError"));
	}, testRolesByUsernameQueryResult:function (inResponse) {
		studio.endWait();
		this.dbTestSQLErrorLabel.setCaption("");
		this.dbTestSQLResultList.renderData(inResponse);
	}, testRolesByUsernameQueryError:function (inResponse) {
		studio.endWait();
		this.dbTestSQLResultList.renderData([]);
		this.dbTestSQLErrorLabel.setCaption(inResponse.message);
	}, ldapSearchRoleCheckboxChange:function (inSender, inDisplayValue, inDataValue) {
		var c = inSender.components.editor.editor.checked;
		this.ldapGroupSearchBaseInput.setShowing(c);
		this.ldapGroupRoleAttributeInput.setShowing(c);
		this.ldapGroupSearchFilterInput.setShowing(c);
	}, ldapConnectionButtonClick:function (inSender) {
		studio.beginWait("Testing LDAP Connection...");
		studio.securityConfigService.requestAsync("testLDAPConnection", [this.ldapUrlInput.getDataValue(), this.ldapManagerDnInput.getDataValue(), this.ldapManagerPasswordInput.getDataValue()], dojo.hitch(this, "testLDAPConnectionResult"), dojo.hitch(this, "testLDAPConnectionError"));
	}, testLDAPConnectionResult:function (inResponse) {
		studio.endWait();
		this.ldapConnectionResultLabel.domNode.style.color = "";
		this.ldapConnectionResultLabel.setCaption("Connection Successful.");
	}, testLDAPConnectionError:function (inError) {
		studio.endWait();
		this.ldapConnectionResultLabel.domNode.style.color = "red";
		this.ldapConnectionResultLabel.setCaption(inError.message);
	}, addRoleButtonClick:function (inSender) {
		var role = this.addRoleInput.getDataValue();
		if (role) {
			role = dojo.trim(role);
		}
		if (role) {
			var d = this.roleList._data;
			if (d == null) {
				d = [];
			}
			for (var i = 0; i < d.length; i++) {
				if (d[i].role == role) {
					app.alert("Role already exists, please type in another one!");
					return;
				}
			}
			if (d.length && this.isJOSSO()) {
				app.alert("JOSSO only allows one role.  Delete existing role before entering new one.");
				return;
			}
			d.push(role);
			this.roleList.renderData(d);
			this.updateSelect(this.demoRoleInput, d);
			this.addRoleInput.clear();
			this.addRoleInput.focus();
		} else {
			app.alert("Role field cannot be empty!");
		}
	}, deleteRoleButtonClick:function (inSender) {
		if (this.roleList.selected) {
			var d = this.roleList._data;
			var nd = [];
			var deletedIndex = -1;
			for (var i = 0; i < d.length; i++) {
				if (i != this.roleList.selected.index) {
					nd.push(d[i]);
				} else {
					deletedIndex = i;
				}
			}
			this.roleList.renderData(nd);
			this.updateSelect(this.demoRoleInput, nd);
		}
	}, populateRolesSetup:function () {
		if (this.isJOSSO()) {
			studio.securityConfigService.requestAsync("getJOSSORoles", null, dojo.hitch(this, "getRolesResult"));
		} else {
			studio.securityConfigService.requestAsync("getRoles", null, dojo.hitch(this, "getRolesResult"));
		}
	}, getRolesResult:function (inResponse) {
		this.roleList.renderData(inResponse);
		this.updateSelect(this.demoRoleInput, inResponse);
	}, saveRolesSetup:function () {
		if (this.isJOSSO()) {
			studio.securityConfigService.requestAsync("setJOSSORoles", [this.roleList._data], dojo.hitch(this, "setRolesResult"));
		} else {
			studio.securityConfigService.requestAsync("setRoles", [this.roleList._data], dojo.hitch(this, "setRolesResult"));
		}
	}, setRolesResult:function () {
		wm.roles = this.roleList._data || [];
	}, copyLoginFiles:function () {
		if (this.isJOSSO()) {
			if (!webFileExists("login-redirect.jsp")) {
				var loginhtml = "<%--\n  ~ JOSSO: Java Open Single Sign-On\n  ~\n  ~ Copyright 2004-2009, Atricore, Inc.\n  ~\n  ~ This is free software; you can redistribute it and/or modify it\n  ~ under the terms of the GNU Lesser General Public License as\n  ~ published by the Free Software Foundation; either version 2.1 of  \n~ the License, or (at your option) any later version.  \n~  \n~ This software is distributed in the hope that it will be useful,  \n~ but WITHOUT ANY WARRANTY; without even the implied warranty of  \n~ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU  \n~ Lesser General Public License for more details.  \n~  ~ You should have received a copy of the GNU Lesser General Public  \n~ License along with this software; if not, write to the Free  \n~ Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  \n~ 02110-1301 USA, or see the FSF site: http://www.fsf.org.  \n~  \n--%>\n\n<%@page contentType=\"text/html; charset=UTF-8\" language=\"java\" session=\"true\" %>\n<%\n response.sendRedirect(request.getContextPath() + \"/josso_login/\");\n%>";
				studio.project.saveProjectData("login-redirect.jsp", loginhtml);
			}
		} else {
			if (!webFileExists("login.html")) {
				var loginhtml = loadDataSync(this.loginTemplateFolder + "login.html");
				studio.project.saveProjectData("login.html", wm.makeLoginHtml(loginhtml, studio.project.projectName, studio.application.theme));
			}
			if (!webFileExists(wm.pagesFolder + "Login/Login.js")) {
				var loginPageCss = loadDataSync(this.loginPageTemplateFolder + "Login.css");
				var loginPageHtml = loadDataSync(this.loginPageTemplateFolder + "Login.html");
				var loginPageJs = loadDataSync(this.loginPageTemplateFolder + "Login.js");
				var loginPageWidgetsJs = loadDataSync(this.loginPageTemplateFolder + "Login.widgets.js");
				var n = wm.pagesFolder + "Login/Login";
				studio.project.saveProjectData(n + ".css", loginPageCss);
				studio.project.saveProjectData(n + ".html", loginPageHtml);
				studio.project.saveProjectData(n + ".js", loginPageJs);
				studio.project.saveProjectData(n + ".widgets.js", loginPageWidgetsJs);
				studio.project.updatePageList();
				studio.project.pagesChanged();
			}
		}
	}, demoUserListFormat:function (inSender, ioData, inColumn, inData, inHeader) {
		if (inHeader) {
			if (inColumn == 0) {
				ioData.data = "<div>Username";
			} else {
				if (inColumn == 1) {
					ioData.data = "<div>Password";
				} else {
					if (inColumn == 2) {
						ioData.data = "<div>Role";
					}
				}
			}
		}
	}, updateRoles:function () {
		if (this.isJOSSO()) {
			studio.securityConfigService.requestSync("getJOSSORoles", [], dojo.hitch(this, "getRolesUpdateResult"));
		} else {
			studio.securityConfigService.requestSync("getRoles", [], dojo.hitch(this, "getRolesUpdateResult"));
		}
	}, getRolesUpdateResult:function (inData) {
		wm.roles = inData || [];
	}, showJossoLayer:function () {
		this.secEnableInput.editor.setChecked(true);
		this.securityCheckboxChange();
		var roles = this.roleList._data;
		if (roles.length) {
			this.roleList._render();
		}
	}, showDemoLayer:function () {
		this.secEnableInput.setDisabled(false);
		this.showLoginPageInput.setShowing(true);
	}, showDBLayer:function () {
		this.secEnableInput.setDisabled(false);
		this.showLoginPageInput.setShowing(true);
	}, showLDAPLayer:function () {
		this.secEnableInput.setDisabled(false);
		this.showLoginPageInput.setShowing(true);
	}, securityCheckboxChange:function () {
		var enabled = this.secEnableInput.editor.getChecked();
		this.showLoginPageInput.setShowing(enabled);
		this.panel4a.setShowing(enabled);
		this.panelBottom.setShowing(enabled);
		this.panelBottom.setShowing(enabled);
		if (this.isJOSSO()) {
			this.showLoginPageInput.setShowing(false);
		}
		this.panel1a.setHeight((this.isJOSSO()) ? "70px" : "350px");
	}, isJOSSO:function () {
		return this.secProviderInput.editor.getEditorValue() == "JOSSO";
	}, _end:0});
}
if (!dojo._hasResource["wm.studio.pages.ServiceDialog.ServiceDialog"]) {
	dojo._hasResource["wm.studio.pages.ServiceDialog.ServiceDialog"] = true;
	dojo.provide("wm.studio.pages.ServiceDialog.ServiceDialog");
	dojo.declare("ServiceDialog", wm.Page, {start:function () {
		this.update();
	}, update:function () {
		this.nameInput.setInputValue(this.binding.name);
		this.updateServicesSelect();
		this.updateOperationSelect();
	}, updateBinding:function () {
		this.pageContainer.page.binding = this.binding.input.components.binding;
		this.pageContainer.page.bindingRoot = this.binding;
		this.pageContainer.page.update();
	}, updateServicesSelect:function () {
		var d = this.binding.getServicesList();
		this.servicesSelect._setOptionData(d);
		this.servicesSelect.setInputValue(this.binding.service);
	}, updateOperationSelect:function () {
		var s = this.binding._service, o = this.binding.operation, valueOk = s && s.getOperation(o), methods = s && s.getOperationsList();
		if (!valueOk) {
			o = methods ? methods[0] : "";
			if (o) {
				this.binding.setOperation(o);
			}
		}
		this.operationSelect._setOptionData(methods);
		this.operationSelect.setInputValue(o);
		this.updateHint();
		this.updateBinding();
	}, updateHint:function () {
		var hint = this.binding.getOperationHint();
		this.hintLabel.setCaption(hint ? "Hint: " + hint : "");
	}, nameInputBlur:function (inSender) {
		this.binding.set_name(inSender.getInputValue());
		this.nameInput.setInputValue(this.binding.name);
	}, servicesSelectChange:function (inSender) {
		this.binding.setService(inSender.getInputValue());
		this.updateOperationSelect();
		this.binding.doClearInput();
		this.updateBinding();
	}, operationSelectChange:function (inSender) {
		this.binding.setOperation(inSender.getInputValue());
		this.binding.doClearInput();
		this.updateHint();
		this.updateBinding();
	}, closeButtonClick:function (inSender) {
		inspect(this.binding);
		wm.fire(this.owner, "dismiss");
	}, _end:0});
}
if (!dojo._hasResource["wm.studio.pages.Services.Services"]) {
	dojo._hasResource["wm.studio.pages.Services.Services"] = true;
	dojo.provide("wm.studio.pages.Services.Services");
	dojo.declare("Services", wm.Page, {start:function () {
		this.tree.initNodeChildren = dojo.hitch(this.tree, "treeInitNodeChildren");
		this.subscribe("wmservices-changed", this, "servicesChanged");
		this.subscribe("wm-project-changed", this, "update");
		this.update();
	}, update:function () {
		studio.updateServices();
		studio.refreshWidgetsTree();
	}, isDirty:function () {
		return this.dirty;
	}, setDirty:function (inDirty) {
		this.dirty = inDirty;
		this.webServiceSaveBtn.setDisabled(!inDirty);
	}, editorChange:function () {
		this.setDirty(true);
	}, updateSelect:function (inSelect, inData) {
		var s = inSelect, o;
		if (inData == null) {
			o = null;
		} else {
			o = inData.join(",");
		}
		s.displayValue = "";
		s.editor.setOptions(o);
	}, servicesChanged:function () {
		this.dirty = false;
		this.clearAll();
		this.tree.deselect();
		var names = [];
		wm.services.forEach(function (s) {
			if (s.type == "WebService") {
				names.push(s.name);
			}
		});
		this.tree.setTreeData(names);
		if (!this.tree.serviceId) {
			this.tree.selectFirstService();
			this.serviceSelected();
		}
	}, treeSelect:function (inSender, inNode) {
		var n = inNode;
		while (n instanceof wm.TreeNode && n.isService != true) {
			n = n.parent;
		}
		if (n.isService) {
			if (this.tree.serviceId != n.name) {
				this.tree.serviceId = n.name;
				this.serviceSelected();
			}
		}
	}, selectService:function (inWebService) {
		this.webService = inWebService;
		this.tree.serviceId = inWebService.serviceId;
		this.serviceSelected();
	}, serviceSelected:function () {
		if (!this.tree.serviceId) {
			return;
		}
		this.serviceNameInput.setValue("dataValue", this.tree.serviceId);
		var isFeedSrv = this.tree.serviceId == "FeedService";
		this.webServiceSaveBtn.setDisabled(!isFeedSrv);
		this.serviceNameInput.setShowing(true);
		this.authUsernameInput.setShowing(!isFeedSrv);
		this.authPasswordInput.setShowing(!isFeedSrv);
		this.wsConnectionTimeoutInput.setShowing(!isFeedSrv);
		this.wsRequestTimeoutInput.setShowing(!isFeedSrv);
		this.wsdlSpacing.setShowing(!isFeedSrv);
		this.feedDescInput.setShowing(isFeedSrv);
		this.setDirty(false);
		if (!isFeedSrv) {
			studio.webService.requestAsync("getBindingProperties", [this.tree.serviceId], dojo.hitch(this, "getBindingPropertiesCallback"));
			studio.webService.requestAsync("getWSDL", [this.tree.serviceId], dojo.hitch(this, "getWSDLCallback"));
		}
	}, getBindingPropertiesCallback:function (inData) {
		if (inData) {
			this.authUsernameInput.beginEditUpdate();
			this.authUsernameInput.setValue("dataValue", inData.httpBasicAuthUsername);
			this.authUsernameInput.endEditUpdate();
			this.authPasswordInput.beginEditUpdate();
			this.authPasswordInput.setValue("dataValue", inData.httpBasicAuthPassword);
			this.authPasswordInput.endEditUpdate();
			var ct = inData.connectionTimeout;
			if (ct == 0) {
				ct = null;
			}
			var rt = inData.requestTimeout;
			if (rt == 0) {
				rt = null;
			}
			this.wsConnectionTimeoutInput.beginEditUpdate();
			this.wsConnectionTimeoutInput.setValue("dataValue", ct);
			this.wsConnectionTimeoutInput.endEditUpdate();
			this.wsRequestTimeoutInput.beginEditUpdate();
			this.wsRequestTimeoutInput.setValue("dataValue", rt);
			this.wsRequestTimeoutInput.endEditUpdate();
		}
	}, getWSDLCallback:function (inData) {
		if (inData.indexOf("services") == 0) {
			this.wsdlCodeEditor.setShowing(false);
			this.wsdlLink.setShowing(true);
			this.wsdlLink.setLink(inData);
		} else {
			this.wsdlCodeEditor.setShowing(true);
			this.wsdlLink.setShowing(false);
			this.wsdlCodeEditor.setInputValue(inData);
		}
	}, webServiceSaveBtnClick:function (inSender) {
		this.setDirty(false);
		if (this.tree.serviceId) {
			var ct = this.wsConnectionTimeoutInput.getValue("dataValue");
			if (ct == null || ct.length == 0) {
				ct = 0;
			}
			var rt = this.wsRequestTimeoutInput.getValue("dataValue");
			if (rt == null || rt.length == 0) {
				rt = 0;
			}
			studio.webService.requestAsync("setBindingProperties", [this.tree.serviceId, {httpBasicAuthUsername:this.authUsernameInput.getValue("dataValue"), httpBasicAuthPassword:this.authPasswordInput.getValue("dataValue"), connectionTimeout:ct, requestTimeout:rt}], dojo.hitch(this, "setBindingPropertiesCallback"), dojo.hitch(this, "setBindingPropertiesErrorCallback"));
		}
	}, setBindingPropertiesCallback:function (inData) {
	}, setBindingPropertiesErrorCallback:function (inError) {
	}, clearAll:function () {
		this.tree.serviceId = null;
		this.wsdlCodeEditor.setInputValue(null);
		this.serviceNameInput.clear();
		this.serviceNameInput.setShowing(false);
		this.feedDescInput.setShowing(false);
		this.authUsernameInput.clear();
		this.authPasswordInput.clear();
		this.wsConnectionTimeoutInput.clear();
		this.wsRequestTimeoutInput.clear();
		this.wsdlCodeEditor.setShowing(true);
		this.wsdlLink.setShowing(false);
	}, importWebServiceBtnClick:function (inSender) {
		var d = this.importWebServiceDialog;
		if (d) {
			d.page.reset();
		} else {
			this.importWebServiceDialog = d = new wm.PageDialog({pageName:"ImportWebService", owner:studio, hideControls:true, contentHeight:600, contentWidth:800});
			d.onClose = dojo.hitch(this, function (inWhy) {
				if (inWhy == "Import") {
					this.serivceImported();
				}
			});
		}
		d.show();
	}, delWebServiceBtnClick:function (inSender) {
		if (this.tree.serviceId) {
			app.confirm("Are you sure you want to delete " + this.tree.serviceId + "?", false, dojo.hitch(this, function () {
				studio.servicesService.requestAsync("deleteService", [this.tree.serviceId], dojo.hitch(this, "deleteServiceCallback"));
			}));
		}
	}, deleteServiceCallback:function (inData) {
		this.tree.serviceId = null;
		studio.application.removeServerComponent(this.webService);
		this.update();
	}, serivceImported:function () {
		var id = this.importWebServiceDialog.page.serviceId;
		this.webService = new wm.WebService({name:id, serviceId:id});
		studio.application.addServerComponent(this.webService);
		this.update();
		this.tree.serviceId = id;
		this.serviceSelected();
		studio.select(this.webService);
	}, _end:0});
}
dojo.declare("Start", wm.Page, {start:function () {
	this.subscribe("wm-project-changed", this, "update");
	this.existingProjectList.connect(this.existingProjectList, "onformat", this, "existingProjectListFormatCell");
	this.update();
}, update:function () {
	this.refreshProjectList();
	this.disEnableProjectButtons(true);
}, welcomeTab:function () {
	this.tabLayers1.setLayer("layer1");
}, openProjectTab:function () {
	this.tabLayers1.setLayer("layer2");
}, highlightProject:function (inName) {
}, newProjectClick:function () {
	studio.newProjectClick();
}, screencastClick:function () {
	window.open("http://www.wavemaker.com/product/screencasts.html");
}, demoClick:function () {
	window.open("http://www.wavemaker.com/product/demos.html");
}, communityClick:function () {
	window.open("http://dev.wavemaker.com/");
}, userGuideClick:function () {
	window.open("http://dev.wavemaker.com/wiki/bin/wmdoc/");
}, tutorialClick:function () {
	window.open("http://dev.wavemaker.com/wiki/bin/wmdoc/Tutorials");
}, documentationClick:function () {
	window.open("http://dev.wavemaker.com/wiki/bin/wmdoc/");
}, registerClick:function () {
	window.open("http://www.wavemaker.com/community/dlreg.html");
}, openProject:function (inSender) {
	var p = this.getSelectedProject();
	if (p) {
		studio.waitForCallback(bundleDialog.M_OpeningProject + p, dojo.hitch(studio.project, "openProject", p));
	}
}, selectProjectInList:function (projectName) {
	var items = this.existingProjectList.items;
	for (var i = 0; i < items.length; i++) {
		if (items[i].projectName == projectName) {
			this.existingProjectList.selectByIndex(i);
			return;
		}
	}
}, getSelectedProject:function () {
	var i = this.existingProjectList.selected;
	if (i) {
		return this.existingProjectList.getItemData(i.index);
	}
}, refreshProjectList:function () {
	var d = studio.studioService.requestSync("listProjects", null, dojo.hitch(this, "listProjectsResult"));
	this.disEnableProjectButtons(this.existingProjectList.selected != true);
}, listProjectsResult:function (inResult) {
	this.existingProjectList.renderData(inResult);
	for (var i = 0; i < inResult.length; i++) {
		this.existingProjectList.items[i].projectName = inResult[i];
	}
}, existingProjectListFormatCell:function (inDataInfo) {
	var di = inDataInfo;
	di.data = "<img src=\"images/project_16.png\"> " + di.data;
}, projectListSelect:function (inSender, inItem) {
	this.disEnableProjectButtons(false);
}, projectListDeselect:function (inSender, inItem) {
	this.disEnableProjectButtons(true);
}, disEnableProjectButtons:function (inDisable) {
}});

