/*
	Copyright (c) 2004-2009, The Dojo Foundation All Rights Reserved.
	Available via Academic Free License >= 2.1 OR the modified BSD license.
	see: http://dojotoolkit.org/license for details
*/

/*
	This is a compiled version of Dojo, built for deployment and not for
	development. To get an editable version, please visit:

		http://dojotoolkit.org

	for documentation and information on getting the source.
*/


dojo.provide("studio_base");
if (!dojo._hasResource["wm.studio.app.packageLoader"]) {
	dojo._hasResource["wm.studio.app.packageLoader"] = true;
	dojo.provide("wm.studio.app.packageLoader");
	_import = function (inTab, inName, inClass, inModule, inImage, inDescription, inProps) {
		var n = inName, c = inClass, m = inModule || c, i = inImage || "images/wm/widget.png";
		try {
			dojo["require"](m);
		}
		catch (e) {
			return "Could not import module \"" + m + "\".";
		}
		var ctor = dojo.getObject(c);
		if (!ctor) {
			return "Module \"" + m + "\" is loaded, but function \"" + c + "\" was not found.";
		}
		var d = inDescription || ctor.description || inClass;
		studio["palette"].addItem(inTab, n, d, i, c, inProps);
		if (!(ctor.prototype instanceof wm.Control)) {
			studio.addComponentMenuItem(inTab, n, d, i, c, inProps);
		}
	};
	installPackages = function (m) {
		for (var i = 0, e; i < m.length; i++) {
			if (e = _import.apply(this, m[i])) {
				console.warn(e);
			}
		}
	};
	_loadPackages = function (d) {
		var m = eval("[" + d + "]");
		installPackages(m);
	};
	loadPackages = function () {
		loadData(dojo.moduleUrl("wm.studio.app") + "packages.js", _loadPackages);
		loadData(dojo.moduleUrl("wm.packages") + "packages.js", _loadPackages);
		if (!studio.isCloud()) {
			loadData(dojo.moduleUrl("wm.studio.app") + "packages.noncloud.js", _loadPackages);
		}
		installPackages(__packageRegistry);
		studio.palette.setLayerIndex(0);
		wm.registerPackage = registerPackage = function (p) {
			wm.onidle(function () {
				installPackages([p]);
			});
		};
	};
	__packageRegistry = [];
	wm.registerPackage = registerPackage = function (p) {
		__packageRegistry.push(p);
	};
}
if (!dojo._hasResource["wm.base.lib.util"]) {
	dojo._hasResource["wm.base.lib.util"] = true;
	dojo.provide("wm.base.lib.util");
	wm = window["wm"] || {};
	wm.logErrors = false;
	wm.log = function () {
		console.log.apply(console, arguments);
	};
	wm.capitalize = function (s) {
		return s ? s.charAt(0).toUpperCase() + s.slice(1) : "";
	};
	wm.decapitalize = function (s) {
		return s ? s.charAt(0).toLowerCase() + s.slice(1) : "";
	};
	wm.isEqual = function (a1, a2) {
		try {
			if (a1 == a2) {
				return true;
			}
			if (dojo.isArray(a1) && dojo.isArray(a2)) {
				return dojo.toJson([].concat(a1).sort()) == dojo.toJson([].concat(a2).sort());
			}
			return dojo.toJson(a1) == dojo.toJson(a2);
		}
		catch (e) {
			console.info("Could not compare objects ", arguments, " therefore returning false. Error ", e);
			return false;
		}
	};
	wm.compareStrings = function (a, b) {
		return a < b ? -1 : a == b ? 0 : 1;
	};
	wm.toTitleCase = function (s) {
		return s.replace(/\b\w+\b/g, function (word) {
			return word ? word.charAt(0).toUpperCase() + (word.slice(1) || "").toLowerCase() : "";
		});
	};
	wm.delimCat = function (inPrefix, inSuffix, inDelim) {
		return inPrefix + (inPrefix && inSuffix ? inDelim : "") + inSuffix;
	};
	wm.joinEx = function (inValues, inDelim) {
		var i = 0;
		while (i < inValues.length) {
			if (inValues[i++] !== "") {
				inValues.splice(--i, 1);
			}
		}
		return inValues.join(inDelim);
	};
	wm.isNumber = function (v) {
		return (typeof v == "number") || (v instanceof Number);
	};
	wm.compareNumbers = function (a, b) {
		var na = wm.isNumber(a), nb = wm.isNumber(b);
		return na && nb ? a - b : (na ? -1 : (nb ? 1 : 0));
	};
	wm.max = function (list) {
		var max = list[0];
		for (var i = 1; i < list.length; i++) {
			if (list[i] > max) {
				max = list[i];
			}
		}
		return max;
	};
	wm.sum = function (list) {
		var sum = 0;
		for (var i = 0; i < list.length; i++) {
			sum += list[i];
		}
		return sum;
	};
	wm.average = function (list) {
		return wm.sum(list) / list.length;
	};
	wm.nop = function () {
	};
	wm.isEmpty = function (inObj) {
		for (var i in inObj) {
			return false;
		}
		return true;
	};
	wm.fire = function (obj, method, args) {
		var f = obj && method && obj[method];
		if (f) {
			return args ? f.apply(obj, args) : f.call(obj);
		}
	};
	wm.async = function (f, delay) {
		return function () {
			setTimeout(f, delay || 1);
		};
	};
	wm.forEach = function (inObject, inFunc) {
		if (dojo.isArray(inObject)) {
			dojo.forEach(inObject, inFunc);
		} else {
			wm.forEachProperty(inObject, inFunc);
		}
	};
	wm.forEachProperty = function (inObject, inFunc) {
		for (var i in inObject) {
			inFunc(inObject[i], i);
		}
	};
	wm.isDomShowing = function (inNode) {
		var n = inNode;
		while (n && n != window.document.body && n.style.display != "none") {
			n = n.parentNode;
		}
		return !n || n.style.display != "none";
	};
	wm.evalJs = function (inJavascript, inDefault) {
		var r = inDefault || "";
		try {
			r = eval(inJavascript);
		}
		catch (e) {
			wm.logging && console.log("Error evaluating Javascript:", e);
		}
		return r;
	};
	wm.getClassProp = function (inClassName, inProp) {
		var klass = dojo.getObject(inClassName);
		var ptype = klass && klass.prototype;
		return ptype && ptype[inProp];
	};
	wm.showHideNode = function (inNode, inTrueToShow) {
		inNode.style.display = inTrueToShow ? "" : "none";
	};
	wm.kids = function (inNode, inTag) {
		var result = [], t = inTag.toUpperCase();
		for (var i = 0, n; (n = inNode.childNodes[i]); i++) {
			if (n.tagName == inTag) {
				result.push(n);
			}
		}
		return result;
	};
	wm.divkids = function (inNode) {
		return wm.kids(inNode, "div");
	};
	wm.clearSelection = function () {
		try {
			if (window.getSelection) {
				window.getSelection().collapseToEnd();
			} else {
				if (document.selection) {
					document.selection.clear();
				}
			}
		}
		catch (e) {
		}
	};
	wm.focusOnIdle = function (inNode) {
		setTimeout(function () {
			try {
				wm.fire(inNode, "focus");
				wm.fire(inNode, "select");
			}
			catch (e) {
			}
		}, 1);
	};
	wm.inScrollbar = function (e) {
		var t = e.target;
		var s = t.style && dojo.getComputedStyle(t);
		return s && (((s.overflow != "hidden" || s.overflowX != "hidden") && (t.scrollWidth != t.offsetWidth) && (t.offsetWidth - 19 - e.clientX < 0)) || ((s.overflow != "hidden" || s.overflowY != "hidden") && (t.scrollHeight != t.offsetHeight) && (t.offsetHeight - 19 - e.clientY < 0)));
	};
	wm.preloadImage = function (inPath) {
		var i = new Image();
		i.src = inPath;
		(wm.preloaded = (wm.preloaded || [])).push(i);
	};
	wm.setUnitsBox = function (node, l, t, w, h) {
		with (node.style) {
			l && (left = l);
			t && (top = t);
			w && (width = w);
			h && (height = h);
		}
	};
	wm.getNaturalBox = function (node) {
		var tn = node.tagName, cs = dojo.getComputedStyle(node), box = dojo._getContentBox(node, cs);
		if (tn == "BUTTON" || tn == "TABLE") {
			var pb = dojo._getPadBorderExtents(node, cs);
			box.w += pb.w;
			box.h += pb.h;
		}
		return box;
	};
	wm.calcOffset = function (inNode, inAncestor, inAdjustMargin) {
		var o = {x:0, y:0}, n = inNode, cs, mb, be;
		while (n && n != inAncestor && n != document) {
			cs = dojo.getComputedStyle(n);
			mb = dojo._getMarginBox(n, cs);
			be = dojo._getBorderExtents(n, cs);
			me = inAdjustMargin ? dojo._getMarginExtents(n, cs) : {l:0, t:0};
			o.x += mb.l + be.l + me.l - (n.scrollLeft || 0);
			o.y += mb.t + be.t + me.t - (n.scrollTop || 0);
			n = n.parentNode;
		}
		return o;
	};
	wm.addRemoveClass = function (node, classn, addRemove) {
		dojo[addRemove ? "addClass" : "removeClass"](node, classn);
	};
	wm.onidle = function () {
		return setTimeout(dojo.hitch.apply(dojo, arguments), 1);
	};
	wm.job = function (inName, inDelay, inJob) {
		wm.cancelJob(inName);
		var job = function () {
			delete wm._jobs[inName];
			inJob();
		};
		wm._jobs[inName] = setTimeout(job, inDelay);
	};
	wm.cancelJob = function (inName) {
		clearTimeout(wm._jobs[inName]);
	};
	wm._jobs = [];
	wm.connectEvents = function (inObject, inNode, inEvents) {
		if (!dojo.isArray(inEvents)) {
			throw ("wm.connectEvents: event list must be an array (did you use variable args?)");
		}
		var links = [];
		for (var i = 0, e; (e = inEvents[i]); i++) {
			links.push(dojo.connect(inNode, "on" + e, inObject, e));
		}
		return links;
	};
	wm._isUniqueName = function (inName, inNameSpaces) {
		for (var j = 0, s; (s = inNameSpaces[j]); j++) {
			if (inName in s) {
				return false;
			}
		}
		return true;
	};
	wm.findUniqueName = function (inName, inNameSpaces) {
		if (wm._isUniqueName(inName, inNameSpaces)) {
			return inName;
		}
		var m = (inName || "").match(/([^\d]*)([\d]*)/);
		var i = m[2] || 1, n0 = m[1] || "noname";
		do {
			inName = n0 + (i > 0 ? i : "");
			i++;
		} while (!wm._isUniqueName(inName, inNameSpaces));
		return inName;
	};
	wm.getValidJsName = function (inName) {
		var dc = "_";
		inName = inName.replace(new RegExp("[- ]", "g"), dc);
		inName = inName.replace(new RegExp("[^a-zA-Z0-9_]", "g"), "");
		if (inName.match(new RegExp("^[0-9]")) || !inName) {
			inName = dc + inName;
		}
		return inName;
	};
	wm._modules = [];
	wm.loadModule = function (inModule) {
		if (!wm._modules[inModule]) {
			tag = ["<scrip", "t type=\"text/javascript\" src=\"", inModule, ".js\"></scrip", "t>"].join("");
			document.write(tag);
			wm._modules[inModule] = true;
		}
	};
	wm.widgetIsShowing = function (inWidget) {
		var w = inWidget, p;
		while (w) {
			p = w.parent;
			if (!w.showing || (w.isActive && !w.isActive())) {
				return false;
			}
			w = p;
		}
		return true;
	};
	wm.forEachWidget = function (inWidget, inFunc, inIgnoreBuiltin) {
		if (inFunc && inFunc(inWidget) === false) {
			return false;
		}
		if (!inWidget) {
			return false;
		}
		for (var i = 0, ws = inWidget.getOrderedWidgets(), r, w; w = ws[i]; i++) {
			r = w.forEachWidget && !inIgnoreBuiltin ? w.forEachWidget(inFunc) : wm.forEachWidget(w, inFunc, inIgnoreBuiltin);
			if (r === false) {
				return false;
			}
		}
	};
	wm.theme = {getPath:function () {
		return dojo.moduleUrl("wm.base", "widget/themes/" + "default/");
	}, getImagesPath:function () {
		return wm.theme.getPath() + "images/";
	}};
	wm.hideToolTip = function (inImmediate) {
		var tt = dijit._masterTT;
		if (tt) {
			dijit.hideTooltip(tt.aroundNode);
			tt._onDeck = null;
			if (inImmediate && tt.fadeOut) {
				tt.fadeOut.stop(true);
				dojo.style(tt.fadeOut.node, "opacity", 0);
			}
		}
	};
	wm.printStackTrace = function (msg) {
		console.group(msg);
		var done = 0;
		try {
			aaaaaaa.aaaaa.aaaa++;
		}
		catch (e) {
			if (e.stack) {
				var lines = e.stack.split("\n");
				for (var i = 0, len = lines.length; i < len; i++) {
					console.log(lines[i]);
					done = 1;
				}
			} else {
				if (window.opera && e.message) {
					var lines = e.message.split("\n");
					for (var i = 0, len = lines.length; i < len; i++) {
						if (lines[i].match(/^\s*[A-Za-z0-9\-_\$]+\(/)) {
							console.log(lines[i]);
							if (lines[i + 1]) {
								console.log("AT: " + lines[i + 1]);
							}
							done = 1;
						}
						i++;
					}
				}
			}
			if (!done) {
				var currentFunction = arguments.callee.caller;
				while (currentFunction) {
					var fn = currentFunction.toString();
					var fname = fn.substring(fn.indexOf("function") + 8, fn.indexOf("(")) || "anonymous";
					console.log(callstack.push(fname));
					currentFunction = currentFunction.caller;
				}
			}
			console.groupEnd();
		}
	};
	wm.focusContainer = function (inContainer) {
		wm.onidle(function () {
			wm.forEachWidget(inContainer, function (w) {
				if (w && w.focus && (!w.canFocus || w.canFocus())) {
					w.focus();
					return false;
				}
			});
		});
	};
	wm.isClassInstanceType = function (inClass, type) {
		try {
			return inClass.prototype instanceof type;
		}
		catch (e) {
		}
		return false;
	};
	wm.isInstanceType = function (obj, type) {
		try {
			return obj instanceof type;
		}
		catch (e) {
		}
		return false;
	};
	wm.getWidgetByDomNode = function (element) {
		if (!element) {
			return;
		}
		if (dojo.isString(element)) {
			element = dojo.byId(element);
		}
		if (!element) {
			return;
		}
		var pageName = app._page.name;
		var reg = new RegExp("^(" + pageName + "|app)_?");
		while ((!element.id || !element.id.match(reg)) && element.parentNode) {
			element = element.parentNode;
		}
		var id = element.id;
		if (!id) {
			return;
		}
		var originalId = id;
		var id = id.replace(reg, "");
		var elements = id.split(/_+/);
		var name = "";
		var widget = (originalId.match(/^app_/)) ? app : app._page;
		for (var i = 0; i < elements.length; i++) {
			if (wm.isInstanceType(widget, wm.PageDialog)) {
				widget = widget.pageContainer;
			}
			if (wm.isInstanceType(widget, wm.PageContainer) || wm.isInstanceType(widget, wm.pageContainerMixin)) {
				widget = widget.page;
				name = "";
			} else {
				name += ((name) ? "_" : "") + elements[i];
				if (wm.isInstanceType(widget, wm.Application)) {
					if (widget[name]) {
						widget = widget[name];
						name = "";
					}
				} else {
					if (widget.$[name]) {
						widget = widget.$[name];
						name = "";
					}
				}
			}
		}
		return widget;
	};
	if (!wm.Array) {
		wm.Array = {};
	}
	wm.Array.removeElementAt = function (inArray, inIndex) {
		inArray.splice(inIndex, 1);
		return inArray;
	};
	wm.Array.removeElement = function (inArray, inElement) {
		var index = dojo.indexOf(inArray, inElement);
		if (index >= 0) {
			inArray.splice(index, 1);
		}
		return inArray;
	};
	wm.Array.equals = function (a, b, optionalCallback) {
		if (a == b) {
			return true;
		}
		if (!a || !b) {
			return false;
		}
		if (a.length != b.length) {
			return false;
		}
		for (var i = 0; i < i.length; i++) {
			if (optionalCallback) {
				if (!optionalCallback(a[i], b[i])) {
					return false;
				}
			} else {
				if (a[i] != b[i]) {
					return false;
				}
			}
		}
		return true;
	};
	wm.Array.last = function (inArray) {
		return inArray[inArray.length - 1];
	};
	if (!wm.String) {
		wm.String = {};
	}
	wm.String.endStringWith = function (inString, inEnd) {
		if (!inString.match(new RegExp(inEnd + "$"))) {
			return inString + inEnd;
		} else {
			return inString;
		}
	};
}
if (!dojo._hasResource["dojo.date"]) {
	dojo._hasResource["dojo.date"] = true;
	dojo.provide("dojo.date");
	dojo.date.getDaysInMonth = function (dateObject) {
		var month = dateObject.getMonth();
		var days = [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
		if (month == 1 && dojo.date.isLeapYear(dateObject)) {
			return 29;
		}
		return days[month];
	};
	dojo.date.isLeapYear = function (dateObject) {
		var year = dateObject.getFullYear();
		return !(year % 400) || (!(year % 4) && !!(year % 100));
	};
	dojo.date.getTimezoneName = function (dateObject) {
		var str = dateObject.toString();
		var tz = "";
		var match;
		var pos = str.indexOf("(");
		if (pos > -1) {
			tz = str.substring(++pos, str.indexOf(")"));
		} else {
			var pat = /([A-Z\/]+) \d{4}$/;
			if ((match = str.match(pat))) {
				tz = match[1];
			} else {
				str = dateObject.toLocaleString();
				pat = / ([A-Z\/]+)$/;
				if ((match = str.match(pat))) {
					tz = match[1];
				}
			}
		}
		return (tz == "AM" || tz == "PM") ? "" : tz;
	};
	dojo.date.compare = function (date1, date2, portion) {
		date1 = new Date(+date1);
		date2 = new Date(+(date2 || new Date()));
		if (portion == "date") {
			date1.setHours(0, 0, 0, 0);
			date2.setHours(0, 0, 0, 0);
		} else {
			if (portion == "time") {
				date1.setFullYear(0, 0, 0);
				date2.setFullYear(0, 0, 0);
			}
		}
		if (date1 > date2) {
			return 1;
		}
		if (date1 < date2) {
			return -1;
		}
		return 0;
	};
	dojo.date.add = function (date, interval, amount) {
		var sum = new Date(+date);
		var fixOvershoot = false;
		var property = "Date";
		switch (interval) {
		  case "day":
			break;
		  case "weekday":
			var days, weeks;
			var mod = amount % 5;
			if (!mod) {
				days = (amount > 0) ? 5 : -5;
				weeks = (amount > 0) ? ((amount - 5) / 5) : ((amount + 5) / 5);
			} else {
				days = mod;
				weeks = parseInt(amount / 5);
			}
			var strt = date.getDay();
			var adj = 0;
			if (strt == 6 && amount > 0) {
				adj = 1;
			} else {
				if (strt == 0 && amount < 0) {
					adj = -1;
				}
			}
			var trgt = strt + days;
			if (trgt == 0 || trgt == 6) {
				adj = (amount > 0) ? 2 : -2;
			}
			amount = (7 * weeks) + days + adj;
			break;
		  case "year":
			property = "FullYear";
			fixOvershoot = true;
			break;
		  case "week":
			amount *= 7;
			break;
		  case "quarter":
			amount *= 3;
		  case "month":
			fixOvershoot = true;
			property = "Month";
			break;
		  default:
			property = "UTC" + interval.charAt(0).toUpperCase() + interval.substring(1) + "s";
		}
		if (property) {
			sum["set" + property](sum["get" + property]() + amount);
		}
		if (fixOvershoot && (sum.getDate() < date.getDate())) {
			sum.setDate(0);
		}
		return sum;
	};
	dojo.date.difference = function (date1, date2, interval) {
		date2 = date2 || new Date();
		interval = interval || "day";
		var yearDiff = date2.getFullYear() - date1.getFullYear();
		var delta = 1;
		switch (interval) {
		  case "quarter":
			var m1 = date1.getMonth();
			var m2 = date2.getMonth();
			var q1 = Math.floor(m1 / 3) + 1;
			var q2 = Math.floor(m2 / 3) + 1;
			q2 += (yearDiff * 4);
			delta = q2 - q1;
			break;
		  case "weekday":
			var days = Math.round(dojo.date.difference(date1, date2, "day"));
			var weeks = parseInt(dojo.date.difference(date1, date2, "week"));
			var mod = days % 7;
			if (mod == 0) {
				days = weeks * 5;
			} else {
				var adj = 0;
				var aDay = date1.getDay();
				var bDay = date2.getDay();
				weeks = parseInt(days / 7);
				mod = days % 7;
				var dtMark = new Date(date1);
				dtMark.setDate(dtMark.getDate() + (weeks * 7));
				var dayMark = dtMark.getDay();
				if (days > 0) {
					switch (true) {
					  case aDay == 6:
						adj = -1;
						break;
					  case aDay == 0:
						adj = 0;
						break;
					  case bDay == 6:
						adj = -1;
						break;
					  case bDay == 0:
						adj = -2;
						break;
					  case (dayMark + mod) > 5:
						adj = -2;
					}
				} else {
					if (days < 0) {
						switch (true) {
						  case aDay == 6:
							adj = 0;
							break;
						  case aDay == 0:
							adj = 1;
							break;
						  case bDay == 6:
							adj = 2;
							break;
						  case bDay == 0:
							adj = 1;
							break;
						  case (dayMark + mod) < 0:
							adj = 2;
						}
					}
				}
				days += adj;
				days -= (weeks * 2);
			}
			delta = days;
			break;
		  case "year":
			delta = yearDiff;
			break;
		  case "month":
			delta = (date2.getMonth() - date1.getMonth()) + (yearDiff * 12);
			break;
		  case "week":
			delta = parseInt(dojo.date.difference(date1, date2, "day") / 7);
			break;
		  case "day":
			delta /= 24;
		  case "hour":
			delta /= 60;
		  case "minute":
			delta /= 60;
		  case "second":
			delta /= 1000;
		  case "millisecond":
			delta *= date2.getTime() - date1.getTime();
		}
		return Math.round(delta);
	};
}
if (!dojo._hasResource["dojo.i18n"]) {
	dojo._hasResource["dojo.i18n"] = true;
	dojo.provide("dojo.i18n");
	dojo.i18n.getLocalization = function (packageName, bundleName, locale) {
		locale = dojo.i18n.normalizeLocale(locale);
		var elements = locale.split("-");
		var module = [packageName, "nls", bundleName].join(".");
		var bundle = dojo._loadedModules[module];
		if (bundle) {
			var localization;
			for (var i = elements.length; i > 0; i--) {
				var loc = elements.slice(0, i).join("_");
				if (bundle[loc]) {
					localization = bundle[loc];
					break;
				}
			}
			if (!localization) {
				localization = bundle.ROOT;
			}
			if (localization) {
				var clazz = function () {
				};
				clazz.prototype = localization;
				return new clazz();
			}
		}
		throw new Error("Bundle not found: " + bundleName + " in " + packageName + " , locale=" + locale);
	};
	dojo.i18n.normalizeLocale = function (locale) {
		var result = locale ? locale.toLowerCase() : dojo.locale;
		if (result == "root") {
			result = "ROOT";
		}
		return result;
	};
	dojo.i18n._requireLocalization = function (moduleName, bundleName, locale, availableFlatLocales) {
		var targetLocale = dojo.i18n.normalizeLocale(locale);
		var bundlePackage = [moduleName, "nls", bundleName].join(".");
		var bestLocale = "";
		if (availableFlatLocales) {
			var flatLocales = availableFlatLocales.split(",");
			for (var i = 0; i < flatLocales.length; i++) {
				if (targetLocale["indexOf"](flatLocales[i]) == 0) {
					if (flatLocales[i].length > bestLocale.length) {
						bestLocale = flatLocales[i];
					}
				}
			}
			if (!bestLocale) {
				bestLocale = "ROOT";
			}
		}
		var tempLocale = availableFlatLocales ? bestLocale : targetLocale;
		var bundle = dojo._loadedModules[bundlePackage];
		var localizedBundle = null;
		if (bundle) {
			if (dojo.config.localizationComplete && bundle._built) {
				return;
			}
			var jsLoc = tempLocale.replace(/-/g, "_");
			var translationPackage = bundlePackage + "." + jsLoc;
			localizedBundle = dojo._loadedModules[translationPackage];
		}
		if (!localizedBundle) {
			bundle = dojo["provide"](bundlePackage);
			var syms = dojo._getModuleSymbols(moduleName);
			var modpath = syms.concat("nls").join("/");
			var parent;
			dojo.i18n._searchLocalePath(tempLocale, availableFlatLocales, function (loc) {
				var jsLoc = loc.replace(/-/g, "_");
				var translationPackage = bundlePackage + "." + jsLoc;
				var loaded = false;
				if (!dojo._loadedModules[translationPackage]) {
					dojo["provide"](translationPackage);
					var module = [modpath];
					if (loc != "ROOT") {
						module.push(loc);
					}
					module.push(bundleName);
					var filespec = module.join("/") + ".js";
					loaded = dojo._loadPath(filespec, null, function (hash) {
						var clazz = function () {
						};
						clazz.prototype = parent;
						bundle[jsLoc] = new clazz();
						for (var j in hash) {
							bundle[jsLoc][j] = hash[j];
						}
					});
				} else {
					loaded = true;
				}
				if (loaded && bundle[jsLoc]) {
					parent = bundle[jsLoc];
				} else {
					bundle[jsLoc] = parent;
				}
				if (availableFlatLocales) {
					return true;
				}
			});
		}
		if (availableFlatLocales && targetLocale != bestLocale) {
			bundle[targetLocale.replace(/-/g, "_")] = bundle[bestLocale.replace(/-/g, "_")];
		}
	};
	(function () {
		var extra = dojo.config.extraLocale;
		if (extra) {
			if (!extra instanceof Array) {
				extra = [extra];
			}
			var req = dojo.i18n._requireLocalization;
			dojo.i18n._requireLocalization = function (m, b, locale, availableFlatLocales) {
				req(m, b, locale, availableFlatLocales);
				if (locale) {
					return;
				}
				for (var i = 0; i < extra.length; i++) {
					req(m, b, extra[i], availableFlatLocales);
				}
			};
		}
	})();
	dojo.i18n._searchLocalePath = function (locale, down, searchFunc) {
		locale = dojo.i18n.normalizeLocale(locale);
		var elements = locale.split("-");
		var searchlist = [];
		for (var i = elements.length; i > 0; i--) {
			searchlist.push(elements.slice(0, i).join("-"));
		}
		searchlist.push(false);
		if (down) {
			searchlist.reverse();
		}
		for (var j = searchlist.length - 1; j >= 0; j--) {
			var loc = searchlist[j] || "ROOT";
			var stop = searchFunc(loc);
			if (stop) {
				break;
			}
		}
	};
	dojo.i18n._preloadLocalizations = function (bundlePrefix, localesGenerated) {
		function preload(locale) {
			locale = dojo.i18n.normalizeLocale(locale);
			dojo.i18n._searchLocalePath(locale, true, function (loc) {
				for (var i = 0; i < localesGenerated.length; i++) {
					if (localesGenerated[i] == loc) {
						dojo["require"](bundlePrefix + "_" + loc);
						return true;
					}
				}
				return false;
			});
		}
		preload();
		var extra = dojo.config.extraLocale || [];
		for (var i = 0; i < extra.length; i++) {
			preload(extra[i]);
		}
	};
}
if (!dojo._hasResource["dojo.cldr.supplemental"]) {
	dojo._hasResource["dojo.cldr.supplemental"] = true;
	dojo.provide("dojo.cldr.supplemental");
	dojo.cldr.supplemental.getFirstDayOfWeek = function (locale) {
		var firstDay = {mv:5, ae:6, af:6, bh:6, dj:6, dz:6, eg:6, er:6, et:6, iq:6, ir:6, jo:6, ke:6, kw:6, lb:6, ly:6, ma:6, om:6, qa:6, sa:6, sd:6, so:6, tn:6, ye:6, as:0, au:0, az:0, bw:0, ca:0, cn:0, fo:0, ge:0, gl:0, gu:0, hk:0, ie:0, il:0, is:0, jm:0, jp:0, kg:0, kr:0, la:0, mh:0, mo:0, mp:0, mt:0, nz:0, ph:0, pk:0, sg:0, th:0, tt:0, tw:0, um:0, us:0, uz:0, vi:0, za:0, zw:0, et:0, mw:0, ng:0, tj:0, sy:4};
		var country = dojo.cldr.supplemental._region(locale);
		var dow = firstDay[country];
		return (dow === undefined) ? 1 : dow;
	};
	dojo.cldr.supplemental._region = function (locale) {
		locale = dojo.i18n.normalizeLocale(locale);
		var tags = locale.split("-");
		var region = tags[1];
		if (!region) {
			region = {de:"de", en:"us", es:"es", fi:"fi", fr:"fr", he:"il", hu:"hu", it:"it", ja:"jp", ko:"kr", nl:"nl", pt:"br", sv:"se", zh:"cn"}[tags[0]];
		} else {
			if (region.length == 4) {
				region = tags[2];
			}
		}
		return region;
	};
	dojo.cldr.supplemental.getWeekend = function (locale) {
		var weekendStart = {eg:5, il:5, sy:5, "in":0, ae:4, bh:4, dz:4, iq:4, jo:4, kw:4, lb:4, ly:4, ma:4, om:4, qa:4, sa:4, sd:4, tn:4, ye:4};
		var weekendEnd = {ae:5, bh:5, dz:5, iq:5, jo:5, kw:5, lb:5, ly:5, ma:5, om:5, qa:5, sa:5, sd:5, tn:5, ye:5, af:5, ir:5, eg:6, il:6, sy:6};
		var country = dojo.cldr.supplemental._region(locale);
		var start = weekendStart[country];
		var end = weekendEnd[country];
		if (start === undefined) {
			start = 6;
		}
		if (end === undefined) {
			end = 0;
		}
		return {start:start, end:end};
	};
}
if (!dojo._hasResource["dojo.regexp"]) {
	dojo._hasResource["dojo.regexp"] = true;
	dojo.provide("dojo.regexp");
	dojo.regexp.escapeString = function (str, except) {
		return str.replace(/([\.$?*|{}\(\)\[\]\\\/\+^])/g, function (ch) {
			if (except && except.indexOf(ch) != -1) {
				return ch;
			}
			return "\\" + ch;
		});
	};
	dojo.regexp.buildGroupRE = function (arr, re, nonCapture) {
		if (!(arr instanceof Array)) {
			return re(arr);
		}
		var b = [];
		for (var i = 0; i < arr.length; i++) {
			b.push(re(arr[i]));
		}
		return dojo.regexp.group(b.join("|"), nonCapture);
	};
	dojo.regexp.group = function (expression, nonCapture) {
		return "(" + (nonCapture ? "?:" : "") + expression + ")";
	};
}
if (!dojo._hasResource["dojo.string"]) {
	dojo._hasResource["dojo.string"] = true;
	dojo.provide("dojo.string");
	dojo.string.rep = function (str, num) {
		if (num <= 0 || !str) {
			return "";
		}
		var buf = [];
		for (; ; ) {
			if (num & 1) {
				buf.push(str);
			}
			if (!(num >>= 1)) {
				break;
			}
			str += str;
		}
		return buf.join("");
	};
	dojo.string.pad = function (text, size, ch, end) {
		if (!ch) {
			ch = "0";
		}
		var out = String(text), pad = dojo.string.rep(ch, Math.ceil((size - out.length) / ch.length));
		return end ? out + pad : pad + out;
	};
	dojo.string.substitute = function (template, map, transform, thisObject) {
		thisObject = thisObject || dojo.global;
		transform = transform ? dojo.hitch(thisObject, transform) : function (v) {
			return v;
		};
		return template.replace(/\$\{([^\s\:\}]+)(?:\:([^\s\:\}]+))?\}/g, function (match, key, format) {
			var value = dojo.getObject(key, false, map);
			if (format) {
				value = dojo.getObject(format, false, thisObject).call(thisObject, value, key);
			}
			return transform(value, key).toString();
		});
	};
	dojo.string.trim = String.prototype.trim ? dojo.trim : function (str) {
		str = str.replace(/^\s+/, "");
		for (var i = str.length - 1; i >= 0; i--) {
			if (/\S/.test(str.charAt(i))) {
				str = str.substring(0, i + 1);
				break;
			}
		}
		return str;
	};
}
if (!dojo._hasResource["dojo.date.locale"]) {
	dojo._hasResource["dojo.date.locale"] = true;
	dojo.provide("dojo.date.locale");
	(function () {
		function formatPattern(dateObject, bundle, options, pattern) {
			return pattern.replace(/([a-z])\1*/ig, function (match) {
				var s, pad, c = match.charAt(0), l = match.length, widthList = ["abbr", "wide", "narrow"];
				switch (c) {
				  case "G":
					s = bundle[(l < 4) ? "eraAbbr" : "eraNames"][dateObject.getFullYear() < 0 ? 0 : 1];
					break;
				  case "y":
					s = dateObject.getFullYear();
					switch (l) {
					  case 1:
						break;
					  case 2:
						if (!options.fullYear) {
							s = String(s);
							s = s.substr(s.length - 2);
							break;
						}
					  default:
						pad = true;
					}
					break;
				  case "Q":
				  case "q":
					s = Math.ceil((dateObject.getMonth() + 1) / 3);
					pad = true;
					break;
				  case "M":
					var m = dateObject.getMonth();
					if (l < 3) {
						s = m + 1;
						pad = true;
					} else {
						var propM = ["months", "format", widthList[l - 3]].join("-");
						s = bundle[propM][m];
					}
					break;
				  case "w":
					var firstDay = 0;
					s = dojo.date.locale._getWeekOfYear(dateObject, firstDay);
					pad = true;
					break;
				  case "d":
					s = dateObject.getDate();
					pad = true;
					break;
				  case "D":
					s = dojo.date.locale._getDayOfYear(dateObject);
					pad = true;
					break;
				  case "E":
					var d = dateObject.getDay();
					if (l < 3) {
						s = d + 1;
						pad = true;
					} else {
						var propD = ["days", "format", widthList[l - 3]].join("-");
						s = bundle[propD][d];
					}
					break;
				  case "a":
					var timePeriod = (dateObject.getHours() < 12) ? "am" : "pm";
					s = bundle[timePeriod];
					break;
				  case "h":
				  case "H":
				  case "K":
				  case "k":
					var h = dateObject.getHours();
					switch (c) {
					  case "h":
						s = (h % 12) || 12;
						break;
					  case "H":
						s = h;
						break;
					  case "K":
						s = (h % 12);
						break;
					  case "k":
						s = h || 24;
						break;
					}
					pad = true;
					break;
				  case "m":
					s = dateObject.getMinutes();
					pad = true;
					break;
				  case "s":
					s = dateObject.getSeconds();
					pad = true;
					break;
				  case "S":
					s = Math.round(dateObject.getMilliseconds() * Math.pow(10, l - 3));
					pad = true;
					break;
				  case "v":
				  case "z":
					s = dojo.date.locale._getZone(dateObject, true, options);
					if (s) {
						break;
					}
					l = 4;
				  case "Z":
					var offset = dojo.date.locale._getZone(dateObject, false, options);
					var tz = [(offset <= 0 ? "+" : "-"), dojo.string.pad(Math.floor(Math.abs(offset) / 60), 2), dojo.string.pad(Math.abs(offset) % 60, 2)];
					if (l == 4) {
						tz.splice(0, 0, "GMT");
						tz.splice(3, 0, ":");
					}
					s = tz.join("");
					break;
				  default:
					throw new Error("dojo.date.locale.format: invalid pattern char: " + pattern);
				}
				if (pad) {
					s = dojo.string.pad(s, l);
				}
				return s;
			});
		}
		dojo.date.locale._getZone = function (dateObject, getName, options) {
			if (getName) {
				return dojo.date.getTimezoneName(dateObject);
			} else {
				return dateObject.getTimezoneOffset();
			}
		};
		dojo.date.locale.format = function (dateObject, options) {
			options = options || {};
			var locale = dojo.i18n.normalizeLocale(options.locale), formatLength = options.formatLength || "short", bundle = dojo.date.locale._getGregorianBundle(locale), str = [], sauce = dojo.hitch(this, formatPattern, dateObject, bundle, options);
			if (options.selector == "year") {
				return _processPattern(bundle["dateFormatItem-yyyy"] || "yyyy", sauce);
			}
			var pattern;
			if (options.selector != "date") {
				pattern = options.timePattern || bundle["timeFormat-" + formatLength];
				if (pattern) {
					str.push(_processPattern(pattern, sauce));
				}
			}
			if (options.selector != "time") {
				pattern = options.datePattern || bundle["dateFormat-" + formatLength];
				if (pattern) {
					str.push(_processPattern(pattern, sauce));
				}
			}
			return str.length == 1 ? str[0] : bundle["dateTimeFormat-" + formatLength].replace(/\{(\d+)\}/g, function (match, key) {
				return str[key];
			});
		};
		dojo.date.locale.regexp = function (options) {
			return dojo.date.locale._parseInfo(options).regexp;
		};
		dojo.date.locale._parseInfo = function (options) {
			options = options || {};
			var locale = dojo.i18n.normalizeLocale(options.locale), bundle = dojo.date.locale._getGregorianBundle(locale), formatLength = options.formatLength || "short", datePattern = options.datePattern || bundle["dateFormat-" + formatLength], timePattern = options.timePattern || bundle["timeFormat-" + formatLength], pattern;
			if (options.selector == "date") {
				pattern = datePattern;
			} else {
				if (options.selector == "time") {
					pattern = timePattern;
				} else {
					pattern = bundle["dateTimeFormat-" + formatLength].replace(/\{(\d+)\}/g, function (match, key) {
						return [timePattern, datePattern][key];
					});
				}
			}
			var tokens = [], re = _processPattern(pattern, dojo.hitch(this, _buildDateTimeRE, tokens, bundle, options));
			return {regexp:re, tokens:tokens, bundle:bundle};
		};
		dojo.date.locale.parse = function (value, options) {
			var info = dojo.date.locale._parseInfo(options), tokens = info.tokens, bundle = info.bundle, re = new RegExp("^" + info.regexp + "$", info.strict ? "" : "i"), match = re.exec(value);
			if (!match) {
				return null;
			}
			var widthList = ["abbr", "wide", "narrow"], result = [1970, 0, 1, 0, 0, 0, 0], amPm = "", valid = dojo.every(match, function (v, i) {
				if (!i) {
					return true;
				}
				var token = tokens[i - 1];
				var l = token.length;
				switch (token.charAt(0)) {
				  case "y":
					if (l != 2 && options.strict) {
						result[0] = v;
					} else {
						if (v < 100) {
							v = Number(v);
							var year = "" + new Date().getFullYear(), century = year.substring(0, 2) * 100, cutoff = Math.min(Number(year.substring(2, 4)) + 20, 99), num = (v < cutoff) ? century + v : century - 100 + v;
							result[0] = num;
						} else {
							if (options.strict) {
								return false;
							}
							result[0] = v;
						}
					}
					break;
				  case "M":
					if (l > 2) {
						var months = bundle["months-format-" + widthList[l - 3]].concat();
						if (!options.strict) {
							v = v.replace(".", "").toLowerCase();
							months = dojo.map(months, function (s) {
								return s.replace(".", "").toLowerCase();
							});
						}
						v = dojo.indexOf(months, v);
						if (v == -1) {
							return false;
						}
					} else {
						v--;
					}
					result[1] = v;
					break;
				  case "E":
				  case "e":
					var days = bundle["days-format-" + widthList[l - 3]].concat();
					if (!options.strict) {
						v = v.toLowerCase();
						days = dojo.map(days, function (d) {
							return d.toLowerCase();
						});
					}
					v = dojo.indexOf(days, v);
					if (v == -1) {
						return false;
					}
					break;
				  case "D":
					result[1] = 0;
				  case "d":
					result[2] = v;
					break;
				  case "a":
					var am = options.am || bundle.am;
					var pm = options.pm || bundle.pm;
					if (!options.strict) {
						var period = /\./g;
						v = v.replace(period, "").toLowerCase();
						am = am.replace(period, "").toLowerCase();
						pm = pm.replace(period, "").toLowerCase();
					}
					if (options.strict && v != am && v != pm) {
						return false;
					}
					amPm = (v == pm) ? "p" : (v == am) ? "a" : "";
					break;
				  case "K":
					if (v == 24) {
						v = 0;
					}
				  case "h":
				  case "H":
				  case "k":
					if (v > 23) {
						return false;
					}
					result[3] = v;
					break;
				  case "m":
					result[4] = v;
					break;
				  case "s":
					result[5] = v;
					break;
				  case "S":
					result[6] = v;
				}
				return true;
			});
			var hours = +result[3];
			if (amPm === "p" && hours < 12) {
				result[3] = hours + 12;
			} else {
				if (amPm === "a" && hours == 12) {
					result[3] = 0;
				}
			}
			var dateObject = new Date(result[0], result[1], result[2], result[3], result[4], result[5], result[6]);
			if (options.strict) {
				dateObject.setFullYear(result[0]);
			}
			var allTokens = tokens.join(""), dateToken = allTokens.indexOf("d") != -1, monthToken = allTokens.indexOf("M") != -1;
			if (!valid || (monthToken && dateObject.getMonth() > result[1]) || (dateToken && dateObject.getDate() > result[2])) {
				return null;
			}
			if ((monthToken && dateObject.getMonth() < result[1]) || (dateToken && dateObject.getDate() < result[2])) {
				dateObject = dojo.date.add(dateObject, "hour", 1);
			}
			return dateObject;
		};
		function _processPattern(pattern, applyPattern, applyLiteral, applyAll) {
			var identity = function (x) {
				return x;
			};
			applyPattern = applyPattern || identity;
			applyLiteral = applyLiteral || identity;
			applyAll = applyAll || identity;
			var chunks = pattern.match(/(''|[^'])+/g), literal = pattern.charAt(0) == "'";
			dojo.forEach(chunks, function (chunk, i) {
				if (!chunk) {
					chunks[i] = "";
				} else {
					chunks[i] = (literal ? applyLiteral : applyPattern)(chunk);
					literal = !literal;
				}
			});
			return applyAll(chunks.join(""));
		}
		function _buildDateTimeRE(tokens, bundle, options, pattern) {
			pattern = dojo.regexp.escapeString(pattern);
			if (!options.strict) {
				pattern = pattern.replace(" a", " ?a");
			}
			return pattern.replace(/([a-z])\1*/ig, function (match) {
				var s, c = match.charAt(0), l = match.length, p2 = "", p3 = "";
				if (options.strict) {
					if (l > 1) {
						p2 = "0" + "{" + (l - 1) + "}";
					}
					if (l > 2) {
						p3 = "0" + "{" + (l - 2) + "}";
					}
				} else {
					p2 = "0?";
					p3 = "0{0,2}";
				}
				switch (c) {
				  case "y":
					s = "\\d{2,4}";
					break;
				  case "M":
					s = (l > 2) ? "\\S+?" : p2 + "[1-9]|1[0-2]";
					break;
				  case "D":
					s = p2 + "[1-9]|" + p3 + "[1-9][0-9]|[12][0-9][0-9]|3[0-5][0-9]|36[0-6]";
					break;
				  case "d":
					s = "[12]\\d|" + p2 + "[1-9]|3[01]";
					break;
				  case "w":
					s = p2 + "[1-9]|[1-4][0-9]|5[0-3]";
					break;
				  case "E":
					s = "\\S+";
					break;
				  case "h":
					s = p2 + "[1-9]|1[0-2]";
					break;
				  case "k":
					s = p2 + "\\d|1[01]";
					break;
				  case "H":
					s = p2 + "\\d|1\\d|2[0-3]";
					break;
				  case "K":
					s = p2 + "[1-9]|1\\d|2[0-4]";
					break;
				  case "m":
				  case "s":
					s = "[0-5]\\d";
					break;
				  case "S":
					s = "\\d{" + l + "}";
					break;
				  case "a":
					var am = options.am || bundle.am || "AM";
					var pm = options.pm || bundle.pm || "PM";
					if (options.strict) {
						s = am + "|" + pm;
					} else {
						s = am + "|" + pm;
						if (am != am.toLowerCase()) {
							s += "|" + am.toLowerCase();
						}
						if (pm != pm.toLowerCase()) {
							s += "|" + pm.toLowerCase();
						}
						if (s.indexOf(".") != -1) {
							s += "|" + s.replace(/\./g, "");
						}
					}
					s = s.replace(/\./g, "\\.");
					break;
				  default:
					s = ".*";
				}
				if (tokens) {
					tokens.push(match);
				}
				return "(" + s + ")";
			}).replace(/[\xa0 ]/g, "[\\s\\xa0]");
		}
	})();
	(function () {
		var _customFormats = [];
		dojo.date.locale.addCustomFormats = function (packageName, bundleName) {
			_customFormats.push({pkg:packageName, name:bundleName});
		};
		dojo.date.locale._getGregorianBundle = function (locale) {
			var gregorian = {};
			dojo.forEach(_customFormats, function (desc) {
				var bundle = dojo.i18n.getLocalization(desc.pkg, desc.name, locale);
				gregorian = dojo.mixin(gregorian, bundle);
			}, this);
			return gregorian;
		};
	})();
	dojo.date.locale.addCustomFormats("dojo.cldr", "gregorian");
	dojo.date.locale.getNames = function (item, type, context, locale) {
		var label, lookup = dojo.date.locale._getGregorianBundle(locale), props = [item, context, type];
		if (context == "standAlone") {
			var key = props.join("-");
			label = lookup[key];
			if (label[0] == 1) {
				label = undefined;
			}
		}
		props[1] = "format";
		return (label || lookup[props.join("-")]).concat();
	};
	dojo.date.locale.isWeekend = function (dateObject, locale) {
		var weekend = dojo.cldr.supplemental.getWeekend(locale), day = (dateObject || new Date()).getDay();
		if (weekend.end < weekend.start) {
			weekend.end += 7;
			if (day < weekend.start) {
				day += 7;
			}
		}
		return day >= weekend.start && day <= weekend.end;
	};
	dojo.date.locale._getDayOfYear = function (dateObject) {
		return dojo.date.difference(new Date(dateObject.getFullYear(), 0, 1, dateObject.getHours()), dateObject) + 1;
	};
	dojo.date.locale._getWeekOfYear = function (dateObject, firstDayOfWeek) {
		if (arguments.length == 1) {
			firstDayOfWeek = 0;
		}
		var firstDayOfYear = new Date(dateObject.getFullYear(), 0, 1).getDay(), adj = (firstDayOfYear - firstDayOfWeek + 7) % 7, week = Math.floor((dojo.date.locale._getDayOfYear(dateObject) + adj - 1) / 7);
		if (firstDayOfYear == firstDayOfWeek) {
			week++;
		}
		return week;
	};
}
if (!dojo._hasResource["wm.base.lib.date"]) {
	dojo._hasResource["wm.base.lib.date"] = true;
	dojo.provide("wm.base.lib.date");
	wm.convertValueToDate = function (inValue, inParams) {
		var v = inValue, s = inParams || {selector:"date"};
		if (!v && v !== 0) {
			return null;
		} else {
			if (Number(v)) {
				return new Date(Number(v));
			} else {
				if (dojo.trim(v.toLowerCase()).indexOf("today") != -1) {
					if (v.indexOf("+") != -1) {
						var range = v.toLowerCase().split("+");
						try {
							var date1 = dojo.trim(range[0]);
							var date2 = dojo.trim(range[1]);
							if (date1 == "today") {
								v = dojo.date.add(new Date(), "day", date2 * 1);
							} else {
								v = dojo.date.add(new Date(), "day", date1 * 1);
							}
						}
						catch (e) {
						}
					} else {
						v = new Date();
					}
					return v;
				}
			}
		}
		return v != Number(v) ? dojo.date.locale.parse(v, s) : new Date(Number(v));
	};
}
if (!dojo._hasResource["wm.base.lib.text"]) {
	dojo._hasResource["wm.base.lib.text"] = true;
	dojo.provide("wm.base.lib.text");
	wm.textSizePoll = function (inObject, inMethod, inInterval) {
		var f = document.createElement("div");
		with (f.style) {
			top = "0px";
			left = "0px";
			position = "absolute";
			visibility = "hidden";
		}
		f.innerHTML = "TheQuickBrownFoxJumpedOverTheLazyDogNotDojo";
		document.body.appendChild(f);
		var fw = f.offsetWidth;
		var job = function () {
			if (f.offsetWidth != fw) {
				fw = f.offsetWidth;
				dojo.publish("wm-textsizechange");
			}
		};
		window.setInterval(job, inInterval || 2000);
		wm.textSizePoll = function () {
		};
	};
	dojo.addOnLoad(wm.textSizePoll);
}
if (!dojo._hasResource["wm.base.lib.types"]) {
	dojo._hasResource["wm.base.lib.types"] = true;
	dojo.provide("wm.base.lib.types");
	wm.typeManager = {types:{}, initialized:false, initTypes:function () {
		var types = (wm.types || 0).types;
		if (types) {
			wm.typeManager.setTypes(types);
		}
	}, setTypes:function (inTypes) {
		this.clearTypes();
		dojo.mixin(this.types, inTypes);
		if (!this.initialized) {
			this.addDefaultTypes();
		}
	}, clearTypes:function () {
		this._publicTypes = {};
		for (var i in this.types) {
			if (!this.types[i].userType) {
				delete this.types[i];
			}
		}
	}, getPrimitiveType:function (inTypeName) {
		return (this.types[inTypeName] || 0).primitiveType;
	}, isStructuredType:function (inTypeName) {
		return this.types[inTypeName] && !this.getPrimitiveType(inTypeName);
	}, getService:function (inTypeName) {
		var t = this.types[inTypeName];
		return (t && t.service);
	}, getLiveService:function (inTypeName) {
		var t = this.types[inTypeName];
		return (t && t.liveService && t.service);
	}, generatePublicTypes:function () {
		var types = {};
		for (var i in this.types) {
			if (this.isPublicType(i)) {
				types[i] = this.types[i];
			}
		}
		return types;
	}, getPublicTypes:function () {
		return wm.isEmpty(this._publicTypes) ? this._publicTypes = this.generatePublicTypes() : this._publicTypes;
	}, getLiveServiceTypes:function () {
		var types = this.getPublicTypes(), liveServiceTypes = {};
		for (var i in types) {
			if (this.getLiveService(i)) {
				liveServiceTypes[i] = types[i];
			}
		}
		return liveServiceTypes;
	}, isPublicType:function (inTypeName) {
		var t = this.types[inTypeName];
		return (t && !t.internal && !t.primitiveType);
	}, getTypeSchema:function (inTypeName) {
		return (this.types[inTypeName] || 0).fields;
	}, getType:function (inTypeName) {
		return this.types[inTypeName];
	}, isType:function (inTypeName) {
		return Boolean(this.getType(inTypeName));
	}, getPropertyInfoFromSchema:function (inTypeSchema, inPropName) {
		var s = inTypeSchema, parts = dojo.isString(inPropName) ? inPropName.split(".") : inPropName, p = parts.shift(), f = s[p];
		if (!parts.length) {
			return f;
		} else {
			var t = (f || 0).type, ts = this.getTypeSchema(t);
			if (ts) {
				return this.getPropertyInfoFromSchema(ts, parts);
			}
		}
	}, getFilteredPropNames:function (inTypeSchema, inFilterFunc) {
		var ts = [], u = [], t, hasFilter = dojo.isFunction(inFilterFunc);
		wm.forEach(inTypeSchema, function (o, i) {
			if (!hasFilter || inFilterFunc(o)) {
				var elem = {};
				elem.info = o;
				elem.name = i;
				ts.push(elem);
			}
		});
		ts.sort(function (a, b) {
			return (a.info.fieldOrder - b.info.fieldOrder);
		});
		for (i = 0; (ti = ts[i]); i++) {
			u.push(ti.name);
		}
		return u;
	}, getSimplePropNames:function (inTypeSchema) {
		return this.getFilteredPropNames(inTypeSchema, function (p) {
			return !wm.typeManager.isStructuredType((p || 0).type);
		});
	}, getStructuredPropNames:function (inTypeSchema) {
		return this.getFilteredPropNames(inTypeSchema, function (p) {
			return wm.typeManager.isStructuredType((p || 0).type);
		});
	}, getPropNames:function (inTypeSchema, inStructured) {
		var u = this.getSimplePropNames(inTypeSchema), s = inStructured ? this.getStructuredPropNames(inTypeSchema) : [];
		return u.concat(s);
	}, getPropertyOrder:function (inType, inPropName) {
		var o = [], parts = dojo.isString(inPropName) ? inPropName.split(".") : inPropName, p = parts.shift(), schema = this.getTypeSchema(inType), propertyArray = this.getPropNames(schema, true);
		var c, l = propertyArray.length;
		for (var i = 0, n; (n = propertyArray[i]); i++) {
			if (p == n) {
				c = i;
				break;
			}
		}
		o.push(c !== undefined ? c : l);
		var f = schema && schema[p], t = (f || 0).type;
		if (!parts.length || !t) {
			return o;
		} else {
			return o.concat(this.getPropertyOrder(t, parts));
		}
	}, hasStructuredType:function (inTypeName, inCondition) {
		var s = this.getTypeSchema(inTypeName), p, c = dojo.isFunction(inCondition) && inCondition;
		for (var i in s) {
			p = s[i];
			if (this.isStructuredType(p.type)) {
				if (c) {
					if (c(p)) {
						return true;
					}
				} else {
					return true;
				}
			}
		}
	}, addType:function (inName, inTypeInfo) {
		if (!inTypeInfo || wm.isEmpty(inTypeInfo)) {
			return;
		}
		inTypeInfo.userType = true;
		this.types[inName] = inTypeInfo;
		if (this.isPublicType(inName) && !wm.isEmpty(this._publicTypes)) {
			this._publicTypes[inName] = inTypeInfo;
		}
	}, removeType:function (inName) {
		delete this._publicTypes[inName];
	}, addDefaultTypes:function () {
		var d = wm.defaultTypes || {};
		for (var i in d) {
			this.addType(i, d[i]);
		}
	}, isPropInList:function (inTypeSchema, inPropName) {
		var s = inTypeSchema, parts = dojo.isString(inPropName) ? inPropName.split(".") : inPropName, p = parts.shift(), f = s[p];
		if (!f) {
			return false;
		} else {
			if (f.isList) {
				return true;
			} else {
				if (parts.length) {
					var t = (f || 0).type, ts = this.getTypeSchema(t);
					if (ts) {
						return this.isPropInList(ts, parts);
					}
				}
			}
		}
	}};
	wm.defaultTypes = {NumberData:{fields:{dataValue:{type:"Number"}}}, BooleanData:{fields:{dataValue:{type:"Boolean"}}}, StringData:{fields:{dataValue:{type:"String"}}}, DateData:{fields:{dataValue:{type:"Date"}}}, EntryData:{fields:{name:{type:"string"}, dataValue:{type:"any"}}}, AnyData:{fields:{dataValue:{type:"any"}}}};
	wm.isListType = function (inTypeName) {
		return inTypeName && inTypeName.charAt(0) == "[";
	};
	wm.getFriendlyTypeName = function (inType, inForceList) {
		inType = inType || "(any)";
		var s = wm.typeManager.getService(inType), isList = wm.isListType(inType), t = s ? [s, inType.split(".").pop()].join(".") : inType;
		if (isList) {
			t = t.slice(0, -1);
		}
		if (inForceList || isList) {
			t = t + " list";
		}
		return t;
	};
	wm.getPrimitiveDisplayType = function (inPrimitiveName) {
		var t = wm.typeManager.getPrimitiveType(inPrimitiveName);
		if (t == "Boolean") {
			t = "CheckBox";
		}
		if (!t || t == "String") {
			t = "Text";
		}
		return t;
	};
}
if (!dojo._hasResource["wm.base.lib.data"]) {
	dojo._hasResource["wm.base.lib.data"] = true;
	dojo.provide("wm.base.lib.data");
	wm.data = wm.data || {};
	dojo.mixin(wm.data, {getIncludeFields:function (inTypeName) {
		var pi, fields = [], schema = wm.typeManager.getTypeSchema(inTypeName);
		for (var i in schema) {
			pi = schema[i];
			if (pi.include && pi.include.length) {
				if (wm.typeManager.isStructuredType(pi.type)) {
					var compSchema = wm.typeManager.getTypeSchema(pi.type);
					for (var j in compSchema) {
						fields.push(i + "." + j);
					}
				} else {
					fields.push(i);
				}
			}
		}
		return fields;
	}, hasIncludeData:function (inTypeName, inData) {
		if (!inData || wm.isEmpty(inData)) {
			return false;
		}
		var fields = this.getIncludeFields(inTypeName);
		for (var i = 0, f; f = fields[i]; i++) {
			if (dojo.getObject(f, false, inData) === undefined) {
				return;
			}
		}
		return true;
	}, hasOperationData:function (inOperation, inTypeName, inData) {
		if (!wm.typeManager.getLiveService(inTypeName)) {
			return false;
		}
		switch (inOperation) {
		  case "read":
			return !inData || wm.data.hasIncludeData(inTypeName, inData);
		  case "delete":
		  case "update":
			return wm.data.hasIncludeData(inTypeName, inData);
		  case "insert":
			return wm.data.hasRequiredData(inOperation, inTypeName, inData, true);
		}
	}, hasRequiredData:function (inOperation, inTypeName, inData, inCheckStructured) {
		var schema = wm.typeManager.getTypeSchema(inTypeName), s, d, isStructured, hasData, missingRequired, hasExcluded;
		for (var i in schema) {
			s = schema[i];
			isStructured = wm.typeManager.isStructuredType(s.type);
			d = inData && inData[i];
			if (isStructured && inCheckStructured) {
				if ((d || s.required) && !s.isList && !this.hasRequiredData(s.type, d, inCheckStructured)) {
					return false;
				}
			} else {
				hasData = (d !== undefined);
				missingRequired = s.required && !hasData;
				if (dojo.indexOf(s.exclude, inOperation) != -1 ? hasData : missingRequired) {
					return false;
				}
			}
		}
		return true;
	}, clearBinding:function (inObject, inTargetProperty) {
		var w = wm.data.getPropWire(inObject, inTargetProperty);
		if (w) {
			var b = w.owner, target = w.target, tp = w.targetProperty;
			if (b) {
				b.removeWire(w.getWireId());
			}
			if (target && tp) {
				target.setValue(tp, "");
			}
		}
	}, getPropWire:function (inTargetObject, inTargetProperty) {
		var tp = inTargetProperty, tobj = inTargetObject, binding = tobj && tobj.$.binding, w = binding && binding.wires[tp];
		if (w) {
			return w;
		}
		var ownerApp = tobj && tobj.isDesignLoaded() ? studio.application : app;
		if (tobj && tobj.isOwnedBy(ownerApp)) {
			return wm.data.findSourceWire((tobj || 0).getId(), tp);
		}
	}, findSourceWire:function (inTargetId, inProp) {
		if (inTargetId) {
			var c, o, id, wires, w;
			for (var i in wm.Component.byId) {
				c = wm.Component.byId[i];
				if ((c instanceof wm.Binding) && (c.isDesignLoaded() || !(window.studio && window.studio._isWaveMakerStudio))) {
					var wires = c.findWiresByProps({targetId:inTargetId, targetProperty:inProp});
					if (wires.length) {
						return wires[0];
					}
				}
			}
		}
	}, getPropBindSource:function (inTargetObject, inTargetProperty) {
		var w = wm.data.getPropWire(inTargetObject, inTargetProperty);
		if (w) {
			return inTargetObject.getValueById(w.source);
		}
	}, compare:function (a, b) {
		return a === b ? 0 : a === undefined ? -1 : b === undefined ? 1 : b === null ? 1 : a > b ? 1 : -1;
	}});
}
if (!dojo._hasResource["wm.base.layout.console"]) {
	dojo._hasResource["wm.base.layout.console"] = true;
	dojo.provide("wm.base.layout.console");
	adaptConsole = function (inNode, inFlex) {
		var n = inNode || document.getElementById("console");
		var f = window.consoleFrame;
		if (!f) {
			if (n) {
				n.parentNode.removeChild(n);
			}
		} else {
			f.flex = inFlex;
			var n = inNode || document.getElementById("console");
			if (n) {
				if (n.flex) {
					f.flex = n.flex;
				}
				n.parentNode.insertBefore(f, n);
				n.parentNode.removeChild(n);
			}
			if (!f.flex) {
				f.style.height = "96px";
				console.layout();
			}
			var s = new wm.Splitter({layout:"bottom"});
			f.parentNode.insertBefore(s.domNode, f);
			dojo.connect(f, "onboundschange", function () {
				setTimeout(console.layout, 100);
			});
		}
	};
	dojo.addOnLoad(function () {
	});
}
if (!dojo._hasResource["wm.base.data.expression"]) {
	dojo._hasResource["wm.base.data.expression"] = true;
	dojo.provide("wm.base.data.expression");
	wm.expression = {getValue:function (inExpression, inRoot) {
		var v = wm.expression._getText(inExpression, inRoot);
		return wm.evalJs(v);
	}, getSources:function (inExpression) {
		var re = wm.expression._getSourceRegEx;
		re.lastIndex = 0;
		var m, sources = [];
		while ((m = re.exec(inExpression)) != null) {
			sources.push(m[1]);
			var mList = m[1].split(".");
			mList.pop();
			while (mList.length > 1) {
				sources.push(mList.join("."));
				mList.pop();
			}
		}
		return sources;
	}, _getText:function (inExpression, inRoot) {
		return inExpression.replace(wm.expression._getSourceRegEx, function () {
			try {
				if (inRoot.getValue) {
					var v = inRoot.getValue(arguments[1]);
				} else {
					if (arguments[1].indexOf(".") != -1) {
						var arr = arguments[1].split(".");
						var v = inRoot;
						dojo.forEach(arr, function (prop) {
							v = v[prop];
						});
					} else {
						var v = inRoot[arguments[1]];
					}
				}
				if (v instanceof wm.Object || v === undefined) {
					v = "";
				}
				return dojo.toJson(v);
			}
			catch (e) {
			}
		});
	}, _getSourceRegEx:new RegExp(/\$\{([^\s\:\}]+)(?:\:([^\s\:\}]+))?\}/g)};
}
if (!dojo._hasResource["dojo.data.util.sorter"]) {
	dojo._hasResource["dojo.data.util.sorter"] = true;
	dojo.provide("dojo.data.util.sorter");
	dojo.data.util.sorter.basicComparator = function (a, b) {
		var r = -1;
		if (a === null) {
			a = undefined;
		}
		if (b === null) {
			b = undefined;
		}
		if (a == b) {
			r = 0;
		} else {
			if (a > b || a == null) {
				r = 1;
			}
		}
		return r;
	};
	dojo.data.util.sorter.createSortFunction = function (sortSpec, store) {
		var sortFunctions = [];
		function createSortFunction(attr, dir, comp, s) {
			return function (itemA, itemB) {
				var a = s.getValue(itemA, attr);
				var b = s.getValue(itemB, attr);
				return dir * comp(a, b);
			};
		}
		var sortAttribute;
		var map = store.comparatorMap;
		var bc = dojo.data.util.sorter.basicComparator;
		for (var i = 0; i < sortSpec.length; i++) {
			sortAttribute = sortSpec[i];
			var attr = sortAttribute.attribute;
			if (attr) {
				var dir = (sortAttribute.descending) ? -1 : 1;
				var comp = bc;
				if (map) {
					if (typeof attr !== "string" && ("toString" in attr)) {
						attr = attr.toString();
					}
					comp = map[attr] || bc;
				}
				sortFunctions.push(createSortFunction(attr, dir, comp, store));
			}
		}
		return function (rowA, rowB) {
			var i = 0;
			while (i < sortFunctions.length) {
				var ret = sortFunctions[i++](rowA, rowB);
				if (ret !== 0) {
					return ret;
				}
			}
			return 0;
		};
	};
}
if (!dojo._hasResource["dojo.data.util.simpleFetch"]) {
	dojo._hasResource["dojo.data.util.simpleFetch"] = true;
	dojo.provide("dojo.data.util.simpleFetch");
	dojo.data.util.simpleFetch.fetch = function (request) {
		request = request || {};
		if (!request.store) {
			request.store = this;
		}
		var self = this;
		var _errorHandler = function (errorData, requestObject) {
			if (requestObject.onError) {
				var scope = requestObject.scope || dojo.global;
				requestObject.onError.call(scope, errorData, requestObject);
			}
		};
		var _fetchHandler = function (items, requestObject) {
			var oldAbortFunction = requestObject.abort || null;
			var aborted = false;
			var startIndex = requestObject.start ? requestObject.start : 0;
			var endIndex = (requestObject.count && (requestObject.count !== Infinity)) ? (startIndex + requestObject.count) : items.length;
			requestObject.abort = function () {
				aborted = true;
				if (oldAbortFunction) {
					oldAbortFunction.call(requestObject);
				}
			};
			var scope = requestObject.scope || dojo.global;
			if (!requestObject.store) {
				requestObject.store = self;
			}
			if (requestObject.onBegin) {
				requestObject.onBegin.call(scope, items.length, requestObject);
			}
			if (requestObject.sort) {
				items.sort(dojo.data.util.sorter.createSortFunction(requestObject.sort, self));
			}
			if (requestObject.onItem) {
				for (var i = startIndex; (i < items.length) && (i < endIndex); ++i) {
					var item = items[i];
					if (!aborted) {
						requestObject.onItem.call(scope, item, requestObject);
					}
				}
			}
			if (requestObject.onComplete && !aborted) {
				var subset = null;
				if (!requestObject.onItem) {
					subset = items.slice(startIndex, endIndex);
				}
				requestObject.onComplete.call(scope, subset, requestObject);
			}
		};
		this._fetchItems(request, _fetchHandler, _errorHandler);
		return request;
	};
}
if (!dojo._hasResource["wm.base.data.SimpleStore"]) {
	dojo._hasResource["wm.base.data.SimpleStore"] = true;
	dojo.provide("wm.base.data.SimpleStore");
	dojo.declare("wm.base.data.SimpleStore", null, {constructor:function (inData, inIdentity) {
		this.data = inData || [];
		this.identity = inIdentity;
	}, getCount:function () {
		return this.data.length;
	}, _fetchItemByIdentity:function (inIdentity) {
		var id = this.identity;
		for (var i = 0, data = this.data, l = this.getCount(), d; i < l && (d = data[i]); i++) {
			if (d[id] === inIdentity) {
				return d;
			}
		}
	}, _getQuery:function (inRequest) {
		var query = inRequest.query;
		if (dojo.isString(query)) {
			var q = query;
			query = {};
			query[this.identity] = q;
		}
		return query;
	}, _objectsMatch:function (inA, inB) {
		var ac = 0, a = inA instanceof wm.Variable ? inA.getData() : inA, b = inB instanceof wm.Variable ? inB.getData() : inB;
		for (var i in a) {
			if (dojo.isObject(a[i])) {
				continue;
			}
			ac++;
			if (a[i] != (b && b[i])) {
				return;
			}
		}
		var bc = 0;
		for (var i in b) {
			if (!dojo.isObject(b[i])) {
				bc++;
			}
		}
		return ac == bc;
	}, _itemInQuery:function (inItem, inQuery, inIgnoreCase, inExactMatch) {
		var d = inItem, w = "*", a, b, exact;
		for (var i in inQuery) {
			a = d[i];
			b = inQuery[i];
			if (b == w) {
				continue;
			}
			exact = inExactMatch || (b.indexOf(w) == -1);
			if (dojo.isString(a) && dojo.isString(b) && !exact) {
				if (b.charAt(b.length - 1) == w) {
					b = b.slice(0, -1);
				}
				if (inIgnoreCase) {
					a = a.toLowerCase();
					b = b.toLowerCase();
				}
				if (a.indexOf(b) != 0) {
					return;
				}
			} else {
				if (dojo.isObject(a) && dojo.isObject(b)) {
					return this._objectsMatch(a, b);
				} else {
					if (a !== b) {
						return;
					}
				}
			}
		}
		return true;
	}, _fetchItems:function (inRequest, inFetchHandler, inErrorHandler) {
		var query = this._getQuery(inRequest), opts = inRequest.queryOptions, ignoreCase = opts && opts.ignoreCase, exactMatch = opts && opts.exactMatch, result = [];
		for (var i = 0, data = this.data, l = this.getCount(), d; i < l && (d = data[i]); i++) {
			if (this._itemInQuery(d, query, ignoreCase, exactMatch)) {
				result.push(d);
				if (exactMatch) {
					break;
				}
			}
		}
		inFetchHandler(result, inRequest);
	}, _assertIsItem:function (item) {
		if (!this.isItem(item)) {
			throw new Error("Invalid item:", item);
		}
	}, getValue:function (item, attribute, defaultValue) {
		this._assertIsItem(item);
		var v = item[attribute];
		return v !== undefined ? v : defaultValue;
	}, getValues:function (item, attribute) {
		var d = this.getValue(item, attribute);
		return d ? [d] : [];
	}, getAttributes:function (item) {
		this._assertIsItem(item);
		var result = [];
		for (var i in item) {
			result.push(i);
		}
		return result;
	}, hasAttribute:function (item, attribute) {
		this._assertIsItem(item);
		for (var i in item) {
			if (attribute == i) {
				return true;
			}
		}
		return false;
	}, containsValue:function (item, attribute, value) {
		this._assertIsItem(item);
		return (this.getValue(item, attribute) === value);
	}, isItem:function (something) {
		return something && dojo.isObject(something);
	}, isItemLoaded:function (something) {
		return this.isItem(something);
	}, loadItem:function (keywordArgs) {
		if (!this.isItemLoaded(keywordArgs.item)) {
			throw new Error("Unimplemented API: dojo.data.api.Read.loadItem");
		}
	}, getFeatures:function () {
		return {"dojo.data.api.Read":true, "dojo.data.api.Identity":true};
	}, close:function (request) {
	}, getLabel:function (item) {
		this._assertIsItem(item);
		return (item || []).toString();
	}, getLabelAttributes:function (item) {
		return this.getAttributes(item);
	}, getIdentity:function (item) {
		this._assertIsItem(item);
		return item[this.identity] || null;
	}, getIdentityAttributes:function (item) {
		return this.identity;
	}, fetchItemByIdentity:function (keywordArgs) {
		var inIdentity = keywordArgs.identity;
		if (inIdentity === undefined) {
			if (keywordArgs.onError) {
				keywordArgs.onError.call(scope, "No item found");
			}
			return;
		}
		var item = this._fetchItemByIdentity(inIdentity), scope = keywordArgs.scope ? keywordArgs.scope : dojo.global;
		if (item) {
			if (keywordArgs.onItem) {
				keywordArgs.onItem.call(scope, item);
			}
		} else {
			if (keywordArgs.onError) {
				keywordArgs.onError.call(scope, "No item found");
			}
		}
	}});
	dojo.extend(wm.base.data.SimpleStore, dojo.data.util.simpleFetch);
}
if (!dojo._hasResource["wm.base.drag.capture"]) {
	dojo._hasResource["wm.base.drag.capture"] = true;
	dojo.provide("wm.base.drag.capture");
	kit = dojo;
	kit.declare("wm.Capture", null, {isCaptured:false, setEvents:function () {
		this.events = {};
		kit.forEach(arguments, kit.hitch(this, "addEvent"));
	}, addEvent:function (inEvent) {
		if (!this[inEvent]) {
			this[inEvent] = function () {
			};
		}
		this.events[inEvent] = kit.hitch(this, inEvent);
	}, capture:function () {
		if (this.isCaptured) {
			return;
		}
		this.doCapture();
		this.isCaptured = true;
	}, release:function () {
		if (!this.isCaptured) {
			return;
		}
		this.doRelease();
		this.isCaptured = false;
	}});
	if (kit.isIE) {
		wm.Capture.extend({_bind:function (inTarget, inEvent, inHandler) {
			var on = "on" + inEvent, old = inTarget[on];
			inTarget[on] = function () {
				inHandler(kit.fixEvent());
			};
			return old;
		}, _unbind:function (inTarget, inEvent, inHandler) {
			var on = "on" + inEvent;
			inTarget[on] = inHandler;
		}, doCapture:function () {
			var n = document.body, e, oldf, newf;
			n.setCapture(true);
			this._captures = {};
			for (var i in this.events) {
				if (!(0)[i]) {
					this._captures[i] = this._bind(n, i, this.events[i]);
				}
			}
		}, doRelease:function () {
			var n = document.body;
			for (var i in this._captures) {
				if (!(0)[i]) {
					this._unbind(n, i, this._captures[i]);
				}
			}
			this._captures = null;
			n.releaseCapture(true);
		}});
	} else {
		wm.Capture.extend({doCapture:function (inEvents) {
			for (var i in this.events) {
				if (!(0)[i]) {
					document.addEventListener(i, this.events[i], true);
				}
			}
		}, doRelease:function () {
			for (var i in this.events) {
				if (!(0)[i]) {
					document.removeEventListener(i, this.events[i], true);
				}
			}
			this.isCaptured = false;
		}});
	}
	kit.declare("wm.MouseCapture", wm.Capture, {constructor:function () {
		this.setEvents("mousemove", "mouseup", "mouseout", "click");
	}, mousedown:function (e) {
		kit.stopEvent(e);
		this.capture();
	}, mousemove:function (e) {
	}, mouseout:function (e) {
	}, mouseup:function (e) {
		this.release();
		kit.stopEvent(e);
	}, click:function (e) {
		alert("MouseCapture saw a click!");
	}});
}
if (!dojo._hasResource["wm.base.drag.drag"]) {
	dojo._hasResource["wm.base.drag.drag"] = true;
	dojo.provide("wm.base.drag.drag");
	dojo.declare("wm.Drag", null, {hysteresis:4, dx:0, dy:0, px:0, py:0, constructor:function () {
		this.initNodes();
	}, initNodes:function () {
		this.scrimNode = document.createElement("div");
		var css = "position: absolute; z-index: 200; width: 100%; height: 100%; top: 0; left: 0; display: none;";
		css += "background-color: transparent;";
		this.scrimNode.style.cssText = css;
		document.body.appendChild(this.scrimNode);
	}, setCursor:function (inCursor) {
		if (!this.avatarNode) {
			this.scrimNode.style.cursor = inCursor;
			return;
		}
		if (inCursor == "no-drop") {
			dojo.addClass(this.avatarNode, "invalidDropCSS");
		} else {
			dojo.removeClass(this.avatarNode, "invalidDropCSS");
		}
		this.scrimNode.style.cursor = "default";
	}, mousedown:function (e) {
		this.inherited(arguments);
		this.mouseIsDown = true;
		this.dragging = false;
		this.dx = 0;
		this.dy = 0;
		this.px = e.pageX;
		this.py = e.pageY;
		if (this.scrimEarly) {
		}
	}, mouseout:function (e) {
		if (this.mouseIsDown && !this.dragging) {
			this.start(e);
		}
	}, mousemove:function (e) {
		if (this.mouseIsDown) {
			this.dx = e.pageX - this.px;
			this.dy = e.pageY - this.py;
			if (this.dragging) {
				this.drag(e);
			} else {
				if (Math.sqrt(this.dx * this.dx + this.dy * this.dy) > this.hysteresis) {
					this.start(e);
				}
			}
		}
	}, start:function (e) {
		this.dragging = true;
		wm.showHideNode(this.scrimNode, true);
		this.onstart(e);
	}, drag:function (e) {
		this.ondrag(e);
	}, mouseup:function (e) {
		this.inherited(arguments);
		this.mouseIsDown = false;
		this.finish();
		if (this.dragging) {
			this.dragging = false;
			this.drop();
		}
	}, drop:function () {
		this.ondrop();
	}, finish:function () {
		wm.showHideNode(this.scrimNode, false);
	}, onstart:function (e) {
	}, ondrag:function (e) {
	}, ondrop:function () {
	}});
	dojo.declare("wm.MouseDrag", [wm.MouseCapture, wm.Drag], {});
	dojo.declare("wm.DragDropper", wm.MouseDrag, {initNodes:function () {
		this.inherited(arguments);
		this.avatarNode = document.createElement("div");
		dojo.addClass(this.avatarNode, "dragAvatarCSS");
		this.avatarNode.style.cssText = "display: none;";
		this.avatarNode.innerHTML = "(control)";
		this.scrimNode.appendChild(this.avatarNode);
	}, showHideAvatar:function (inTrueToShow) {
		wm.showHideNode(this.avatarNode, inTrueToShow);
	}, setAvatarContent:function (inContent) {
		this.avatarNode.innerHTML = inContent;
	}, update:function (e) {
		this.pxp = this.px + this.dx;
		this.pyp = this.py + this.dy;
		dojo._setMarginBox(this.avatarNode, this.pxp + 12, this.pyp + 16);
	}, start:function (e) {
		this.inherited(arguments);
		this.update();
		wm.showHideNode(this.avatarNode, true);
	}, drag:function () {
		this.inherited(arguments);
		this.update();
	}, finish:function () {
		wm.showHideNode(this.avatarNode, false);
		this.inherited(arguments);
	}});
}
if (!dojo._hasResource["wm.base.drag.layout"]) {
	dojo._hasResource["wm.base.drag.layout"] = true;
	dojo.provide("wm.base.drag.layout");
	dojo.declare("wm.LayoutDragDropper", wm.DragDropper, {constructor:function () {
		this.info = {};
	}, beginDrag:function (inEvent, inInfo) {
		this.info = inInfo || this.info;
		this.mousedown(inEvent);
	}, initNodes:function () {
		this.inherited(arguments);
		this.markNode = document.createElement("div");
		this.markNode.style.cssText = "position: absolute; z-index: 2; border: 2px solid green;";
		this.scrimNode.appendChild(this.markNode);
	}, updateAvatar:function () {
		this.showHideAvatar(Boolean(this.target));
		if (this.target) {
			this.setAvatarContent("Drop <b>" + this.info.caption + "</b>" + " into <b>" + this.target.name + "</b>");
		}
	}, setTarget:function (inTarget) {
		this.target = inTarget;
		if (this.target) {
			this.setCursor("default");
			this.targetNode = this.target.containerNode || this.target.domNode;
			this.targetOff = wm.calcOffset(this.targetNode, this.scrimNode);
		} else {
			this.setCursor("no-drop");
			this.targetNode = null;
			this.targetOff = null;
		}
		this.updateAvatar();
	}, canBeTarget:function (inWidget) {
		return (inWidget.container && !inWidget.flags.notInspectable && !inWidget.getFreeze());
	}, _findTarget:function (inHit, inWidget, inMargin) {
		var h = inHit, dn = inWidget.domNode, w, b, o;
		var sl = dn.scrollLeft, st = dn.scrollTop;
		var ws = inWidget.widgets;
		var m = inMargin || 0;
		for (var i in ws) {
			w = ws[i];
			if (w.container && (w != this.info.control) && !w.getLock()) {
				b = kit._getMarginBox(w.domNode);
				if (w.domNode.parentNode != inWidget.domNode) {
					o = wm.calcOffset(w.domNode.parentNode, inWidget.domNode);
					b.l += o.x;
					b.t += o.y;
				} else {
					b.l -= sl;
					b.t -= st;
				}
				b.r = b.l + b.w;
				b.b = b.t + b.h;
				if (h.l - b.l > m && b.r - h.l > m && h.t - b.t > m && b.b - h.t > m) {
					h.l -= b.l;
					h.t -= b.t;
					return this._findTarget(h, w, m + 2);
				}
			}
		}
		var t = inWidget._noCreate ? inWidget.parent : inWidget;
		return this.canBeTarget(t) ? t : null;
	}, findTarget:function (inHit) {
		var t = this._findTarget(inHit, this.root);
		if (t != this.target) {
			this.setTarget(t);
		}
	}, start:function (e) {
		this.root = studio.page.root;
		this.rootOffset = wm.calcOffset(this.root.domNode.parentNode, this.scrimNode);
		var t = this.canBeTarget(this.root) ? this.root : null;
		this.setTarget(t);
		kit._setMarginBox(this.markNode, 0, 0, 0, 0);
		this.inherited(arguments);
		this.updateAvatar();
	}, drag:function (e) {
		this.inherited(arguments);
		var r = {l:this.pxp - this.rootOffset.x, t:this.pyp - this.rootOffset.y, w:0, h:0};
		this.findTarget(r);
		if (this.target) {
			var r = {l:this.pxp - this.targetOff.x, t:this.pyp - this.targetOff.y, w:0, h:0};
			this.target.suggestDropRect(r);
			kit._setMarginBox(this.markNode, r.l + this.targetOff.x, r.t + this.targetOff.y, r.w, r.h);
			this.dropRect = r;
		}
	}});
	dojo.declare("wm.LayoutResizer", wm.DragDropper, {snapMask:7, constructor:function () {
		this.info = {};
	}, beginDrag:function (inEvent, inInfo) {
		this.info = inInfo || this.info;
		this.info.caption = this.info.control.name;
		this.info.node = this.info.control.domNode;
		this.info.rect = dojo.marginBox(this.info.node);
		this.mousedown(inEvent);
	}, updateAvatar:function () {
		this.setAvatarContent("<b>" + this.info.caption + "</b>: " + this.dropRect.w + ", " + this.dropRect.h);
	}, start:function (e) {
		this.inherited(arguments);
		this.setCursor(this.info.cursor);
	}, applyMouseDelta:function () {
		with (this.info.rect) {
			this.dropRect = {l:l, t:t, w:w, h:h};
		}
		with (wm.design.handles) {
			switch (this.info.handleId) {
			  case leftTop:
			  case middleTop:
			  case rightTop:
				this.dropRect.t += this.dy;
				this.dropRect.h -= this.dy;
				break;
			  case leftBottom:
			  case middleBottom:
			  case rightBottom:
				this.dropRect.h += this.dy;
				break;
			}
			switch (this.info.handleId) {
			  case leftTop:
			  case leftMiddle:
			  case leftBottom:
				this.dropRect.l += this.dx;
				this.dropRect.w -= this.dx;
				break;
			  case rightTop:
			  case rightMiddle:
			  case rightBottom:
				this.dropRect.w += this.dx;
				break;
			}
		}
	}, applySnap:function (inRect) {
		with (wm.design.handles) {
			switch (this.info.handleId) {
			  case leftTop:
			  case middleTop:
			  case rightTop:
			  case leftBottom:
			  case middleBottom:
			  case rightBottom:
				inRect.h = this.snap(inRect.h);
				break;
			  case leftTop:
			  case leftMiddle:
			  case leftBottom:
			  case rightTop:
			  case rightMiddle:
			  case rightBottom:
				inRect.w = this.snap(inRect.w);
				break;
			}
		}
	}, snap:function (inValue) {
		return inValue - (inValue & this.snapMask);
	}, drag:function (e) {
		this.inherited(arguments);
		this.applyMouseDelta();
		this.applySnap(this.dropRect);
		with (this.dropRect) {
			w = Math.max(1, w);
			h = Math.max(1, h);
		}
		if (this.info.control.container) {
			this.info.control.designWrapper._setBounds(this.dropRect);
		} else {
			this.info.control.designWrapper.setBounds(this.dropRect);
		}
		this.updateAvatar();
	}});
}
if (!dojo._hasResource["dojox.grid.compat._grid.lib"]) {
	dojo._hasResource["dojox.grid.compat._grid.lib"] = true;
	dojo.provide("dojox.grid.compat._grid.lib");
	dojo.mixin(dojox.grid, {na:"...", nop:function () {
	}, getTdIndex:function (td) {
		return td.cellIndex >= 0 ? td.cellIndex : dojo.indexOf(td.parentNode.cells, td);
	}, getTrIndex:function (tr) {
		return tr.rowIndex >= 0 ? tr.rowIndex : dojo.indexOf(tr.parentNode.childNodes, tr);
	}, getTr:function (rowOwner, index) {
		return rowOwner && ((rowOwner.rows || 0)[index] || rowOwner.childNodes[index]);
	}, getTd:function (rowOwner, rowIndex, cellIndex) {
		return (dojox.grid.getTr(rowOwner, rowIndex) || 0)[cellIndex];
	}, findTable:function (node) {
		for (var n = node; n && n.tagName != "TABLE"; n = n.parentNode) {
		}
		return n;
	}, ascendDom:function (inNode, inWhile) {
		for (var n = inNode; n && inWhile(n); n = n.parentNode) {
		}
		return n;
	}, makeNotTagName:function (inTagName) {
		var name = inTagName.toUpperCase();
		return function (node) {
			return node.tagName != name;
		};
	}, fire:function (ob, ev, args) {
		var fn = ob && ev && ob[ev];
		return fn && (args ? fn.apply(ob, args) : ob[ev]());
	}, setStyleText:function (inNode, inStyleText) {
		if (inNode.style.cssText == undefined) {
			inNode.setAttribute("style", inStyleText);
		} else {
			inNode.style.cssText = inStyleText;
		}
	}, getStyleText:function (inNode, inStyleText) {
		return (inNode.style.cssText == undefined ? inNode.getAttribute("style") : inNode.style.cssText);
	}, setStyle:function (inElement, inStyle, inValue) {
		if (inElement && inElement.style[inStyle] != inValue) {
			inElement.style[inStyle] = inValue;
		}
	}, setStyleHeightPx:function (inElement, inHeight) {
		if (inHeight >= 0) {
			dojox.grid.setStyle(inElement, "height", inHeight + "px");
		}
	}, mouseEvents:["mouseover", "mouseout", "mousedown", "mouseup", "click", "dblclick", "contextmenu"], keyEvents:["keyup", "keydown", "keypress"], funnelEvents:function (inNode, inObject, inMethod, inEvents) {
		var evts = (inEvents ? inEvents : dojox.grid.mouseEvents.concat(dojox.grid.keyEvents));
		for (var i = 0, l = evts.length; i < l; i++) {
			dojo.connect(inNode, "on" + evts[i], inObject, inMethod);
		}
	}, removeNode:function (inNode) {
		inNode = dojo.byId(inNode);
		inNode && inNode.parentNode && inNode.parentNode.removeChild(inNode);
		return inNode;
	}, getScrollbarWidth:function () {
		if (this._scrollBarWidth) {
			return this._scrollBarWidth;
		}
		this._scrollBarWidth = 18;
		try {
			var e = document.createElement("div");
			e.style.cssText = "top:0;left:0;width:100px;height:100px;overflow:scroll;position:absolute;visibility:hidden;";
			document.body.appendChild(e);
			this._scrollBarWidth = e.offsetWidth - e.clientWidth;
			document.body.removeChild(e);
			delete e;
		}
		catch (ex) {
		}
		return this._scrollBarWidth;
	}, getRef:function (name, create, context) {
		var obj = context || dojo.global, parts = name.split("."), prop = parts.pop();
		for (var i = 0, p; obj && (p = parts[i]); i++) {
			obj = (p in obj ? obj[p] : (create ? obj[p] = {} : undefined));
		}
		return {obj:obj, prop:prop};
	}, getProp:function (name, create, context) {
		with (dojox.grid.getRef(name, create, context)) {
			return (obj) && (prop) && (prop in obj ? obj[prop] : (create ? obj[prop] = {} : undefined));
		}
	}, indexInParent:function (inNode) {
		var i = 0, n, p = inNode.parentNode;
		while ((n = p.childNodes[i++])) {
			if (n == inNode) {
				return i - 1;
			}
		}
		return -1;
	}, cleanNode:function (inNode) {
		if (!inNode) {
			return;
		}
		var filter = function (inW) {
			return inW.domNode && dojo.isDescendant(inW.domNode, inNode, true);
		};
		var ws = dijit.registry.filter(filter);
		for (var i = 0, w; (w = ws[i]); i++) {
			w.destroy();
		}
		delete ws;
	}, getTagName:function (inNodeOrId) {
		var node = dojo.byId(inNodeOrId);
		return (node && node.tagName ? node.tagName.toLowerCase() : "");
	}, nodeKids:function (inNode, inTag) {
		var result = [];
		var i = 0, n;
		while ((n = inNode.childNodes[i++])) {
			if (dojox.grid.getTagName(n) == inTag) {
				result.push(n);
			}
		}
		return result;
	}, divkids:function (inNode) {
		return dojox.grid.nodeKids(inNode, "div");
	}, focusSelectNode:function (inNode) {
		try {
			dojox.grid.fire(inNode, "focus");
			dojox.grid.fire(inNode, "select");
		}
		catch (e) {
		}
	}, whenIdle:function () {
		setTimeout(dojo.hitch.apply(dojo, arguments), 0);
	}, arrayCompare:function (inA, inB) {
		for (var i = 0, l = inA.length; i < l; i++) {
			if (inA[i] != inB[i]) {
				return false;
			}
		}
		return (inA.length == inB.length);
	}, arrayInsert:function (inArray, inIndex, inValue) {
		if (inArray.length <= inIndex) {
			inArray[inIndex] = inValue;
		} else {
			inArray.splice(inIndex, 0, inValue);
		}
	}, arrayRemove:function (inArray, inIndex) {
		inArray.splice(inIndex, 1);
	}, arraySwap:function (inArray, inI, inJ) {
		var cache = inArray[inI];
		inArray[inI] = inArray[inJ];
		inArray[inJ] = cache;
	}, initTextSizePoll:function (inInterval) {
		var f = document.createElement("div");
		with (f.style) {
			top = "0px";
			left = "0px";
			position = "absolute";
			visibility = "hidden";
		}
		f.innerHTML = "TheQuickBrownFoxJumpedOverTheLazyDog";
		document.body.appendChild(f);
		var fw = f.offsetWidth;
		var job = function () {
			if (f.offsetWidth != fw) {
				fw = f.offsetWidth;
				dojox.grid.textSizeChanged();
			}
		};
		window.setInterval(job, inInterval || 200);
		dojox.grid.initTextSizePoll = dojox.grid.nop;
	}, textSizeChanged:function () {
	}});
	dojox.grid.jobs = {cancel:function (inHandle) {
		if (inHandle) {
			window.clearTimeout(inHandle);
		}
	}, jobs:[], job:function (inName, inDelay, inJob) {
		dojox.grid.jobs.cancelJob(inName);
		var job = function () {
			delete dojox.grid.jobs.jobs[inName];
			inJob();
		};
		dojox.grid.jobs.jobs[inName] = setTimeout(job, inDelay);
	}, cancelJob:function (inName) {
		dojox.grid.jobs.cancel(dojox.grid.jobs.jobs[inName]);
	}};
}
if (!dojo._hasResource["dojox.grid.compat._grid.scroller"]) {
	dojo._hasResource["dojox.grid.compat._grid.scroller"] = true;
	dojo.provide("dojox.grid.compat._grid.scroller");
	dojo.declare("dojox.grid.scroller.base", null, {constructor:function () {
		this.pageHeights = [];
		this.stack = [];
	}, rowCount:0, defaultRowHeight:10, keepRows:100, contentNode:null, scrollboxNode:null, defaultPageHeight:0, keepPages:10, pageCount:0, windowHeight:0, firstVisibleRow:0, lastVisibleRow:0, page:0, pageTop:0, init:function (inRowCount, inKeepRows, inRowsPerPage) {
		switch (arguments.length) {
		  case 3:
			this.rowsPerPage = inRowsPerPage;
		  case 2:
			this.keepRows = inKeepRows;
		  case 1:
			this.rowCount = inRowCount;
		}
		this.defaultPageHeight = this.defaultRowHeight * this.rowsPerPage;
		this.pageCount = Math.ceil(this.rowCount / this.rowsPerPage);
		this.setKeepInfo(this.keepRows);
		this.invalidate();
		if (this.scrollboxNode) {
			this.scrollboxNode.scrollTop = 0;
			this.scroll(0);
			this.scrollboxNode.onscroll = dojo.hitch(this, "onscroll");
		}
	}, setKeepInfo:function (inKeepRows) {
		this.keepRows = inKeepRows;
		this.keepPages = !this.keepRows ? this.keepRows : Math.max(Math.ceil(this.keepRows / this.rowsPerPage), 2);
	}, invalidate:function () {
		this.invalidateNodes();
		this.pageHeights = [];
		this.height = (this.pageCount ? (this.pageCount - 1) * this.defaultPageHeight + this.calcLastPageHeight() : 0);
		this.resize();
	}, updateRowCount:function (inRowCount) {
		this.invalidateNodes();
		this.rowCount = inRowCount;
		var oldPageCount = this.pageCount;
		this.pageCount = Math.ceil(this.rowCount / this.rowsPerPage);
		if (this.pageCount < oldPageCount) {
			for (var i = oldPageCount - 1; i >= this.pageCount; i--) {
				this.height -= this.getPageHeight(i);
				delete this.pageHeights[i];
			}
		} else {
			if (this.pageCount > oldPageCount) {
				this.height += this.defaultPageHeight * (this.pageCount - oldPageCount - 1) + this.calcLastPageHeight();
			}
		}
		this.resize();
	}, pageExists:function (inPageIndex) {
	}, measurePage:function (inPageIndex) {
	}, positionPage:function (inPageIndex, inPos) {
	}, repositionPages:function (inPageIndex) {
	}, installPage:function (inPageIndex) {
	}, preparePage:function (inPageIndex, inPos, inReuseNode) {
	}, renderPage:function (inPageIndex) {
	}, removePage:function (inPageIndex) {
	}, pacify:function (inShouldPacify) {
	}, pacifying:false, pacifyTicks:200, setPacifying:function (inPacifying) {
		if (this.pacifying != inPacifying) {
			this.pacifying = inPacifying;
			this.pacify(this.pacifying);
		}
	}, startPacify:function () {
		this.startPacifyTicks = new Date().getTime();
	}, doPacify:function () {
		var result = (new Date().getTime() - this.startPacifyTicks) > this.pacifyTicks;
		this.setPacifying(true);
		this.startPacify();
		return result;
	}, endPacify:function () {
		this.setPacifying(false);
	}, resize:function () {
		if (this.scrollboxNode) {
			this.windowHeight = this.scrollboxNode.clientHeight;
		}
		dojox.grid.setStyleHeightPx(this.contentNode, this.height);
	}, calcLastPageHeight:function () {
		if (!this.pageCount) {
			return 0;
		}
		var lastPage = this.pageCount - 1;
		var lastPageHeight = ((this.rowCount % this.rowsPerPage) || (this.rowsPerPage)) * this.defaultRowHeight;
		this.pageHeights[lastPage] = lastPageHeight;
		return lastPageHeight;
	}, updateContentHeight:function (inDh) {
		this.height += inDh;
		this.resize();
	}, updatePageHeight:function (inPageIndex) {
		if (this.pageExists(inPageIndex)) {
			var oh = this.getPageHeight(inPageIndex);
			var h = (this.measurePage(inPageIndex)) || (oh);
			this.pageHeights[inPageIndex] = h;
			if ((h) && (oh != h)) {
				this.updateContentHeight(h - oh);
				this.repositionPages(inPageIndex);
			}
		}
	}, rowHeightChanged:function (inRowIndex) {
		this.updatePageHeight(Math.floor(inRowIndex / this.rowsPerPage));
	}, invalidateNodes:function () {
		while (this.stack.length) {
			this.destroyPage(this.popPage());
		}
	}, createPageNode:function () {
		var p = document.createElement("div");
		p.style.position = "absolute";
		p.style[dojo._isBodyLtr() ? "left" : "right"] = "0";
		return p;
	}, getPageHeight:function (inPageIndex) {
		var ph = this.pageHeights[inPageIndex];
		return (ph !== undefined ? ph : this.defaultPageHeight);
	}, pushPage:function (inPageIndex) {
		return this.stack.push(inPageIndex);
	}, popPage:function () {
		return this.stack.shift();
	}, findPage:function (inTop) {
		var i = 0, h = 0;
		for (var ph = 0; i < this.pageCount; i++, h += ph) {
			ph = this.getPageHeight(i);
			if (h + ph >= inTop) {
				break;
			}
		}
		this.page = i;
		this.pageTop = h;
	}, buildPage:function (inPageIndex, inReuseNode, inPos) {
		this.preparePage(inPageIndex, inReuseNode);
		this.positionPage(inPageIndex, inPos);
		this.installPage(inPageIndex);
		this.renderPage(inPageIndex);
		this.pushPage(inPageIndex);
	}, needPage:function (inPageIndex, inPos) {
		var h = this.getPageHeight(inPageIndex), oh = h;
		if (!this.pageExists(inPageIndex)) {
			this.buildPage(inPageIndex, this.keepPages && (this.stack.length >= this.keepPages), inPos);
			h = this.measurePage(inPageIndex) || h;
			this.pageHeights[inPageIndex] = h;
			if (h && (oh != h)) {
				this.updateContentHeight(h - oh);
			}
		} else {
			this.positionPage(inPageIndex, inPos);
		}
		return h;
	}, onscroll:function () {
		this.scroll(this.scrollboxNode.scrollTop);
	}, scroll:function (inTop) {
		this.startPacify();
		this.findPage(inTop);
		var h = this.height;
		var b = this.getScrollBottom(inTop);
		for (var p = this.page, y = this.pageTop; (p < this.pageCount) && ((b < 0) || (y < b)); p++) {
			y += this.needPage(p, y);
		}
		this.firstVisibleRow = this.getFirstVisibleRow(this.page, this.pageTop, inTop);
		this.lastVisibleRow = this.getLastVisibleRow(p - 1, y, b);
		if (h != this.height) {
			this.repositionPages(p - 1);
		}
		this.endPacify();
	}, getScrollBottom:function (inTop) {
		return (this.windowHeight >= 0 ? inTop + this.windowHeight : -1);
	}, processNodeEvent:function (e, inNode) {
		var t = e.target;
		while (t && (t != inNode) && t.parentNode && (t.parentNode.parentNode != inNode)) {
			t = t.parentNode;
		}
		if (!t || !t.parentNode || (t.parentNode.parentNode != inNode)) {
			return false;
		}
		var page = t.parentNode;
		e.topRowIndex = page.pageIndex * this.rowsPerPage;
		e.rowIndex = e.topRowIndex + dojox.grid.indexInParent(t);
		e.rowTarget = t;
		return true;
	}, processEvent:function (e) {
		return this.processNodeEvent(e, this.contentNode);
	}, dummy:0});
	dojo.declare("dojox.grid.scroller", dojox.grid.scroller.base, {constructor:function () {
		this.pageNodes = [];
	}, renderRow:function (inRowIndex, inPageNode) {
	}, removeRow:function (inRowIndex) {
	}, getDefaultNodes:function () {
		return this.pageNodes;
	}, getDefaultPageNode:function (inPageIndex) {
		return this.getDefaultNodes()[inPageIndex];
	}, positionPageNode:function (inNode, inPos) {
		inNode.style.top = inPos + "px";
	}, getPageNodePosition:function (inNode) {
		return inNode.offsetTop;
	}, repositionPageNodes:function (inPageIndex, inNodes) {
		var last = 0;
		for (var i = 0; i < this.stack.length; i++) {
			last = Math.max(this.stack[i], last);
		}
		var n = inNodes[inPageIndex];
		var y = (n ? this.getPageNodePosition(n) + this.getPageHeight(inPageIndex) : 0);
		for (var p = inPageIndex + 1; p <= last; p++) {
			n = inNodes[p];
			if (n) {
				if (this.getPageNodePosition(n) == y) {
					return;
				}
				this.positionPage(p, y);
			}
			y += this.getPageHeight(p);
		}
	}, invalidatePageNode:function (inPageIndex, inNodes) {
		var p = inNodes[inPageIndex];
		if (p) {
			delete inNodes[inPageIndex];
			this.removePage(inPageIndex, p);
			dojox.grid.cleanNode(p);
			p.innerHTML = "";
		}
		return p;
	}, preparePageNode:function (inPageIndex, inReusePageIndex, inNodes) {
		var p = (inReusePageIndex === null ? this.createPageNode() : this.invalidatePageNode(inReusePageIndex, inNodes));
		p.pageIndex = inPageIndex;
		p.id = (this._pageIdPrefix || "") + "page-" + inPageIndex;
		inNodes[inPageIndex] = p;
	}, pageExists:function (inPageIndex) {
		return Boolean(this.getDefaultPageNode(inPageIndex));
	}, measurePage:function (inPageIndex) {
		var p = this.getDefaultPageNode(inPageIndex);
		var h = p.offsetHeight;
		if (!this._defaultRowHeight) {
			if (p) {
				this._defaultRowHeight = 8;
				var fr = p.firstChild;
				if (fr) {
					var text = dojo.doc.createTextNode("T");
					fr.appendChild(text);
					this._defaultRowHeight = fr.offsetHeight;
					fr.removeChild(text);
				}
			}
		}
		return (this.rowsPerPage == h) ? (h * this._defaultRowHeight) : h;
	}, positionPage:function (inPageIndex, inPos) {
		this.positionPageNode(this.getDefaultPageNode(inPageIndex), inPos);
	}, repositionPages:function (inPageIndex) {
		this.repositionPageNodes(inPageIndex, this.getDefaultNodes());
	}, preparePage:function (inPageIndex, inReuseNode) {
		this.preparePageNode(inPageIndex, (inReuseNode ? this.popPage() : null), this.getDefaultNodes());
	}, installPage:function (inPageIndex) {
		this.contentNode.appendChild(this.getDefaultPageNode(inPageIndex));
	}, destroyPage:function (inPageIndex) {
		var p = this.invalidatePageNode(inPageIndex, this.getDefaultNodes());
		dojox.grid.removeNode(p);
	}, renderPage:function (inPageIndex) {
		var node = this.pageNodes[inPageIndex];
		for (var i = 0, j = inPageIndex * this.rowsPerPage; (i < this.rowsPerPage) && (j < this.rowCount); i++, j++) {
			this.renderRow(j, node);
		}
	}, removePage:function (inPageIndex) {
		for (var i = 0, j = inPageIndex * this.rowsPerPage; i < this.rowsPerPage; i++, j++) {
			this.removeRow(j);
		}
	}, getPageRow:function (inPage) {
		return inPage * this.rowsPerPage;
	}, getLastPageRow:function (inPage) {
		return Math.min(this.rowCount, this.getPageRow(inPage + 1)) - 1;
	}, getFirstVisibleRowNodes:function (inPage, inPageTop, inScrollTop, inNodes) {
		var row = this.getPageRow(inPage);
		var rows = dojox.grid.divkids(inNodes[inPage]);
		for (var i = 0, l = rows.length; i < l && inPageTop < inScrollTop; i++, row++) {
			inPageTop += rows[i].offsetHeight;
		}
		return (row ? row - 1 : row);
	}, getFirstVisibleRow:function (inPage, inPageTop, inScrollTop) {
		if (!this.pageExists(inPage)) {
			return 0;
		}
		return this.getFirstVisibleRowNodes(inPage, inPageTop, inScrollTop, this.getDefaultNodes());
	}, getLastVisibleRowNodes:function (inPage, inBottom, inScrollBottom, inNodes) {
		var row = this.getLastPageRow(inPage);
		var rows = dojox.grid.divkids(inNodes[inPage]);
		for (var i = rows.length - 1; i >= 0 && inBottom > inScrollBottom; i--, row--) {
			inBottom -= rows[i].offsetHeight;
		}
		return row + 1;
	}, getLastVisibleRow:function (inPage, inBottom, inScrollBottom) {
		if (!this.pageExists(inPage)) {
			return 0;
		}
		return this.getLastVisibleRowNodes(inPage, inBottom, inScrollBottom, this.getDefaultNodes());
	}, findTopRowForNodes:function (inScrollTop, inNodes) {
		var rows = dojox.grid.divkids(inNodes[this.page]);
		for (var i = 0, l = rows.length, t = this.pageTop, h; i < l; i++) {
			h = rows[i].offsetHeight;
			t += h;
			if (t >= inScrollTop) {
				this.offset = h - (t - inScrollTop);
				return i + this.page * this.rowsPerPage;
			}
		}
		return -1;
	}, findScrollTopForNodes:function (inRow, inNodes) {
		var rowPage = Math.floor(inRow / this.rowsPerPage);
		var t = 0;
		for (var i = 0; i < rowPage; i++) {
			t += this.getPageHeight(i);
		}
		this.pageTop = t;
		this.needPage(rowPage, this.pageTop);
		var rows = dojox.grid.divkids(inNodes[rowPage]);
		var r = inRow - this.rowsPerPage * rowPage;
		for (var i = 0, l = rows.length; i < l && i < r; i++) {
			t += rows[i].offsetHeight;
		}
		return t;
	}, findTopRow:function (inScrollTop) {
		return this.findTopRowForNodes(inScrollTop, this.getDefaultNodes());
	}, findScrollTop:function (inRow) {
		return this.findScrollTopForNodes(inRow, this.getDefaultNodes());
	}, dummy:0});
	dojo.declare("dojox.grid.scroller.columns", dojox.grid.scroller, {constructor:function (inContentNodes) {
		this.setContentNodes(inContentNodes);
	}, setContentNodes:function (inNodes) {
		this.contentNodes = inNodes;
		this.colCount = (this.contentNodes ? this.contentNodes.length : 0);
		this.pageNodes = [];
		for (var i = 0; i < this.colCount; i++) {
			this.pageNodes[i] = [];
		}
	}, getDefaultNodes:function () {
		return this.pageNodes[0] || [];
	}, scroll:function (inTop) {
		if (this.colCount) {
			dojox.grid.scroller.prototype.scroll.call(this, inTop);
		}
	}, resize:function () {
		if (this.scrollboxNode) {
			this.windowHeight = this.scrollboxNode.clientHeight;
		}
		for (var i = 0; i < this.colCount; i++) {
			dojox.grid.setStyleHeightPx(this.contentNodes[i], this.height);
		}
	}, positionPage:function (inPageIndex, inPos) {
		for (var i = 0; i < this.colCount; i++) {
			this.positionPageNode(this.pageNodes[i][inPageIndex], inPos);
		}
	}, preparePage:function (inPageIndex, inReuseNode) {
		var p = (inReuseNode ? this.popPage() : null);
		for (var i = 0; i < this.colCount; i++) {
			this.preparePageNode(inPageIndex, p, this.pageNodes[i]);
		}
	}, installPage:function (inPageIndex) {
		for (var i = 0; i < this.colCount; i++) {
			this.contentNodes[i].appendChild(this.pageNodes[i][inPageIndex]);
		}
	}, destroyPage:function (inPageIndex) {
		for (var i = 0; i < this.colCount; i++) {
			dojox.grid.removeNode(this.invalidatePageNode(inPageIndex, this.pageNodes[i]));
		}
	}, renderPage:function (inPageIndex) {
		var nodes = [];
		for (var i = 0; i < this.colCount; i++) {
			nodes[i] = this.pageNodes[i][inPageIndex];
		}
		for (var i = 0, j = inPageIndex * this.rowsPerPage; (i < this.rowsPerPage) && (j < this.rowCount); i++, j++) {
			this.renderRow(j, nodes);
		}
	}});
}
if (!dojo._hasResource["dijit._base.manager"]) {
	dojo._hasResource["dijit._base.manager"] = true;
	dojo.provide("dijit._base.manager");
	dojo.declare("dijit.WidgetSet", null, {constructor:function () {
		this._hash = {};
		this.length = 0;
	}, add:function (widget) {
		if (this._hash[widget.id]) {
			throw new Error("Tried to register widget with id==" + widget.id + " but that id is already registered");
		}
		this._hash[widget.id] = widget;
		this.length++;
	}, remove:function (id) {
		if (this._hash[id]) {
			delete this._hash[id];
			this.length--;
		}
	}, forEach:function (func, thisObj) {
		thisObj = thisObj || dojo.global;
		var i = 0, id;
		for (id in this._hash) {
			func.call(thisObj, this._hash[id], i++, this._hash);
		}
		return this;
	}, filter:function (filter, thisObj) {
		thisObj = thisObj || dojo.global;
		var res = new dijit.WidgetSet(), i = 0, id;
		for (id in this._hash) {
			var w = this._hash[id];
			if (filter.call(thisObj, w, i++, this._hash)) {
				res.add(w);
			}
		}
		return res;
	}, byId:function (id) {
		return this._hash[id];
	}, byClass:function (cls) {
		var res = new dijit.WidgetSet(), id, widget;
		for (id in this._hash) {
			widget = this._hash[id];
			if (widget.declaredClass == cls) {
				res.add(widget);
			}
		}
		return res;
	}, toArray:function () {
		var ar = [];
		for (var id in this._hash) {
			ar.push(this._hash[id]);
		}
		return ar;
	}, map:function (func, thisObj) {
		return dojo.map(this.toArray(), func, thisObj);
	}, every:function (func, thisObj) {
		thisObj = thisObj || dojo.global;
		var x = 0, i;
		for (i in this._hash) {
			if (!func.call(thisObj, this._hash[i], x++, this._hash)) {
				return false;
			}
		}
		return true;
	}, some:function (func, thisObj) {
		thisObj = thisObj || dojo.global;
		var x = 0, i;
		for (i in this._hash) {
			if (func.call(thisObj, this._hash[i], x++, this._hash)) {
				return true;
			}
		}
		return false;
	}});
	dijit.registry = new dijit.WidgetSet();
	dijit._widgetTypeCtr = {};
	dijit.getUniqueId = function (widgetType) {
		var id;
		do {
			id = widgetType + "_" + (widgetType in dijit._widgetTypeCtr ? ++dijit._widgetTypeCtr[widgetType] : dijit._widgetTypeCtr[widgetType] = 0);
		} while (dijit.byId(id));
		return dijit._scopeName == "dijit" ? id : dijit._scopeName + "_" + id;
	};
	dijit.findWidgets = function (root) {
		var outAry = [];
		function getChildrenHelper(root) {
			if (!root) {
				return;
			}
			for (var node = root.firstChild; node; node = node.nextSibling) {
				if (node.nodeType == 1) {
					var widgetId = node.getAttribute("widgetId");
					if (widgetId) {
						var widget = dijit.byId(widgetId);
						outAry.push(widget);
					} else {
						getChildrenHelper(node);
					}
				}
			}
		}
		getChildrenHelper(root);
		return outAry;
	};
	dijit._destroyAll = function () {
		dijit._curFocus = null;
		dijit._prevFocus = null;
		dijit._activeStack = [];
		dojo.forEach(dijit.findWidgets(dojo.body()), function (widget) {
			if (!widget._destroyed) {
				if (widget.destroyRecursive) {
					widget.destroyRecursive();
				} else {
					if (widget.destroy) {
						widget.destroy();
					}
				}
			}
		});
	};
	if (dojo.isIE) {
		dojo.addOnWindowUnload(function () {
			dijit._destroyAll();
		});
	}
	dijit.byId = function (id) {
		return typeof id == "string" ? dijit.registry._hash[id] : id;
	};
	dijit.byNode = function (node) {
		return dijit.registry.byId(node.getAttribute("widgetId"));
	};
	dijit.getEnclosingWidget = function (node) {
		while (node) {
			var id = node.getAttribute && node.getAttribute("widgetId");
			if (id) {
				return dijit.byId(id);
			}
			node = node.parentNode;
		}
		return null;
	};
	dijit._isElementShown = function (elem) {
		var style = dojo.style(elem);
		return (style.visibility != "hidden") && (style.visibility != "collapsed") && (style.display != "none") && (dojo.attr(elem, "type") != "hidden");
	};
	dijit.isTabNavigable = function (elem) {
		if (dojo.attr(elem, "disabled")) {
			return false;
		} else {
			if (dojo.hasAttr(elem, "tabIndex")) {
				return dojo.attr(elem, "tabIndex") >= 0;
			} else {
				switch (elem.nodeName.toLowerCase()) {
				  case "a":
					return dojo.hasAttr(elem, "href");
				  case "area":
				  case "button":
				  case "input":
				  case "object":
				  case "select":
				  case "textarea":
					return true;
				  case "iframe":
					if (dojo.isMoz) {
						return elem.contentDocument.designMode == "on";
					} else {
						if (dojo.isWebKit) {
							var doc = elem.contentDocument, body = doc && doc.body;
							return body && body.contentEditable == "true";
						} else {
							try {
								doc = elem.contentWindow.document;
								body = doc && doc.body;
								return body && body.firstChild && body.firstChild.contentEditable == "true";
							}
							catch (e) {
								return false;
							}
						}
					}
				  default:
					return elem.contentEditable == "true";
				}
			}
		}
	};
	dijit._getTabNavigable = function (root) {
		var first, last, lowest, lowestTabindex, highest, highestTabindex;
		var walkTree = function (parent) {
			dojo.query("> *", parent).forEach(function (child) {
				var isShown = dijit._isElementShown(child);
				if (isShown && dijit.isTabNavigable(child)) {
					var tabindex = dojo.attr(child, "tabIndex");
					if (!dojo.hasAttr(child, "tabIndex") || tabindex == 0) {
						if (!first) {
							first = child;
						}
						last = child;
					} else {
						if (tabindex > 0) {
							if (!lowest || tabindex < lowestTabindex) {
								lowestTabindex = tabindex;
								lowest = child;
							}
							if (!highest || tabindex >= highestTabindex) {
								highestTabindex = tabindex;
								highest = child;
							}
						}
					}
				}
				if (isShown && child.nodeName.toUpperCase() != "SELECT") {
					walkTree(child);
				}
			});
		};
		if (dijit._isElementShown(root)) {
			walkTree(root);
		}
		return {first:first, last:last, lowest:lowest, highest:highest};
	};
	dijit.getFirstInTabbingOrder = function (root) {
		var elems = dijit._getTabNavigable(dojo.byId(root));
		return elems.lowest ? elems.lowest : elems.first;
	};
	dijit.getLastInTabbingOrder = function (root) {
		var elems = dijit._getTabNavigable(dojo.byId(root));
		return elems.last ? elems.last : elems.highest;
	};
	dijit.defaultDuration = dojo.config["defaultDuration"] || 200;
}
if (!dojo._hasResource["dijit._base.focus"]) {
	dojo._hasResource["dijit._base.focus"] = true;
	dojo.provide("dijit._base.focus");
	dojo.mixin(dijit, {_curFocus:null, _prevFocus:null, isCollapsed:function () {
		return dijit.getBookmark().isCollapsed;
	}, getBookmark:function () {
		var bm, rg, tg, sel = dojo.doc.selection, cf = dijit._curFocus;
		if (dojo.global.getSelection) {
			sel = dojo.global.getSelection();
			if (sel) {
				if (sel.isCollapsed) {
					tg = cf ? cf.tagName : "";
					if (tg) {
						tg = tg.toLowerCase();
						if (tg == "textarea" || (tg == "input" && (!cf.type || cf.type.toLowerCase() == "text"))) {
							sel = {start:cf.selectionStart, end:cf.selectionEnd, node:cf, pRange:true};
							return {isCollapsed:(sel.end <= sel.start), mark:sel};
						}
					}
					bm = {isCollapsed:true};
				} else {
					rg = sel.getRangeAt(0);
					bm = {isCollapsed:false, mark:rg.cloneRange()};
				}
			}
		} else {
			if (sel) {
				tg = cf ? cf.tagName : "";
				tg = tg.toLowerCase();
				if (cf && tg && (tg == "button" || tg == "textarea" || tg == "input")) {
					if (sel.type && sel.type.toLowerCase() == "none") {
						return {isCollapsed:true, mark:null};
					} else {
						rg = sel.createRange();
						return {isCollapsed:rg.text && rg.text.length ? false : true, mark:{range:rg, pRange:true}};
					}
				}
				bm = {};
				try {
					rg = sel.createRange();
					bm.isCollapsed = !(sel.type == "Text" ? rg.htmlText.length : rg.length);
				}
				catch (e) {
					bm.isCollapsed = true;
					return bm;
				}
				if (sel.type.toUpperCase() == "CONTROL") {
					if (rg.length) {
						bm.mark = [];
						var i = 0, len = rg.length;
						while (i < len) {
							bm.mark.push(rg.item(i++));
						}
					} else {
						bm.isCollapsed = true;
						bm.mark = null;
					}
				} else {
					bm.mark = rg.getBookmark();
				}
			} else {
				console.warn("No idea how to store the current selection for this browser!");
			}
		}
		return bm;
	}, moveToBookmark:function (bookmark) {
		var _doc = dojo.doc, mark = bookmark.mark;
		if (mark) {
			if (dojo.global.getSelection) {
				var sel = dojo.global.getSelection();
				if (sel && sel.removeAllRanges) {
					if (mark.pRange) {
						var r = mark;
						var n = r.node;
						n.selectionStart = r.start;
						n.selectionEnd = r.end;
					} else {
						sel.removeAllRanges();
						sel.addRange(mark);
					}
				} else {
					console.warn("No idea how to restore selection for this browser!");
				}
			} else {
				if (_doc.selection && mark) {
					var rg;
					if (mark.pRange) {
						rg = mark.range;
					} else {
						if (dojo.isArray(mark)) {
							rg = _doc.body.createControlRange();
							dojo.forEach(mark, function (n) {
								rg.addElement(n);
							});
						} else {
							rg = _doc.body.createTextRange();
							rg.moveToBookmark(mark);
						}
					}
					rg.select();
				}
			}
		}
	}, getFocus:function (menu, openedForWindow) {
		var node = !dijit._curFocus || (menu && dojo.isDescendant(dijit._curFocus, menu.domNode)) ? dijit._prevFocus : dijit._curFocus;
		return {node:node, bookmark:(node == dijit._curFocus) && dojo.withGlobal(openedForWindow || dojo.global, dijit.getBookmark), openedForWindow:openedForWindow};
	}, focus:function (handle) {
		if (!handle) {
			return;
		}
		var node = "node" in handle ? handle.node : handle, bookmark = handle.bookmark, openedForWindow = handle.openedForWindow, collapsed = bookmark ? bookmark.isCollapsed : false;
		if (node) {
			var focusNode = (node.tagName.toLowerCase() == "iframe") ? node.contentWindow : node;
			if (focusNode && focusNode.focus) {
				try {
					focusNode.focus();
				}
				catch (e) {
				}
			}
			dijit._onFocusNode(node);
		}
		if (bookmark && dojo.withGlobal(openedForWindow || dojo.global, dijit.isCollapsed) && !collapsed) {
			if (openedForWindow) {
				openedForWindow.focus();
			}
			try {
				dojo.withGlobal(openedForWindow || dojo.global, dijit.moveToBookmark, null, [bookmark]);
			}
			catch (e2) {
			}
		}
	}, _activeStack:[], registerIframe:function (iframe) {
		return dijit.registerWin(iframe.contentWindow, iframe);
	}, unregisterIframe:function (handle) {
		dijit.unregisterWin(handle);
	}, registerWin:function (targetWindow, effectiveNode) {
		var mousedownListener = function (evt) {
			dijit._justMouseDowned = true;
			setTimeout(function () {
				dijit._justMouseDowned = false;
			}, 0);
			dijit._onTouchNode(effectiveNode || evt.target || evt.srcElement, "mouse");
		};
		var doc = dojo.isIE ? targetWindow.document.documentElement : targetWindow.document;
		if (doc) {
			if (dojo.isIE) {
				doc.attachEvent("onmousedown", mousedownListener);
				var activateListener = function (evt) {
					if (evt.srcElement.tagName.toLowerCase() != "#document" && dijit.isTabNavigable(evt.srcElement)) {
						dijit._onFocusNode(effectiveNode || evt.srcElement);
					} else {
						dijit._onTouchNode(effectiveNode || evt.srcElement);
					}
				};
				doc.attachEvent("onactivate", activateListener);
				var deactivateListener = function (evt) {
					dijit._onBlurNode(effectiveNode || evt.srcElement);
				};
				doc.attachEvent("ondeactivate", deactivateListener);
				return function () {
					doc.detachEvent("onmousedown", mousedownListener);
					doc.detachEvent("onactivate", activateListener);
					doc.detachEvent("ondeactivate", deactivateListener);
					doc = null;
				};
			} else {
				doc.addEventListener("mousedown", mousedownListener, true);
				var focusListener = function (evt) {
					dijit._onFocusNode(effectiveNode || evt.target);
				};
				doc.addEventListener("focus", focusListener, true);
				var blurListener = function (evt) {
					dijit._onBlurNode(effectiveNode || evt.target);
				};
				doc.addEventListener("blur", blurListener, true);
				return function () {
					doc.removeEventListener("mousedown", mousedownListener, true);
					doc.removeEventListener("focus", focusListener, true);
					doc.removeEventListener("blur", blurListener, true);
					doc = null;
				};
			}
		}
	}, unregisterWin:function (handle) {
		handle && handle();
	}, _onBlurNode:function (node) {
		dijit._prevFocus = dijit._curFocus;
		dijit._curFocus = null;
		if (dijit._justMouseDowned) {
			return;
		}
		if (dijit._clearActiveWidgetsTimer) {
			clearTimeout(dijit._clearActiveWidgetsTimer);
		}
		dijit._clearActiveWidgetsTimer = setTimeout(function () {
			delete dijit._clearActiveWidgetsTimer;
			dijit._setStack([]);
			dijit._prevFocus = null;
		}, 100);
	}, _onTouchNode:function (node, by) {
		if (dijit._clearActiveWidgetsTimer) {
			clearTimeout(dijit._clearActiveWidgetsTimer);
			delete dijit._clearActiveWidgetsTimer;
		}
		var newStack = [];
		try {
			while (node) {
				var popupParent = dojo.attr(node, "dijitPopupParent");
				if (popupParent) {
					node = dijit.byId(popupParent).domNode;
				} else {
					if (node.tagName && node.tagName.toLowerCase() == "body") {
						if (node === dojo.body()) {
							break;
						}
						node = dijit.getDocumentWindow(node.ownerDocument).frameElement;
					} else {
						var id = node.getAttribute && node.getAttribute("widgetId");
						if (id) {
							newStack.unshift(id);
						}
						node = node.parentNode;
					}
				}
			}
		}
		catch (e) {
		}
		dijit._setStack(newStack, by);
	}, _onFocusNode:function (node) {
		if (!node) {
			return;
		}
		if (node.nodeType == 9) {
			return;
		}
		dijit._onTouchNode(node);
		if (node == dijit._curFocus) {
			return;
		}
		if (dijit._curFocus) {
			dijit._prevFocus = dijit._curFocus;
		}
		dijit._curFocus = node;
		dojo.publish("focusNode", [node]);
	}, _setStack:function (newStack, by) {
		var oldStack = dijit._activeStack;
		dijit._activeStack = newStack;
		for (var nCommon = 0; nCommon < Math.min(oldStack.length, newStack.length); nCommon++) {
			if (oldStack[nCommon] != newStack[nCommon]) {
				break;
			}
		}
		var widget;
		for (var i = oldStack.length - 1; i >= nCommon; i--) {
			widget = dijit.byId(oldStack[i]);
			if (widget) {
				widget._focused = false;
				widget._hasBeenBlurred = true;
				if (widget._onBlur) {
					widget._onBlur(by);
				}
				if (widget._setStateClass) {
					widget._setStateClass();
				}
				dojo.publish("widgetBlur", [widget, by]);
			}
		}
		for (i = nCommon; i < newStack.length; i++) {
			widget = dijit.byId(newStack[i]);
			if (widget) {
				widget._focused = true;
				if (widget._onFocus) {
					widget._onFocus(by);
				}
				if (widget._setStateClass) {
					widget._setStateClass();
				}
				dojo.publish("widgetFocus", [widget, by]);
			}
		}
	}});
	dojo.addOnLoad(function () {
		var handle = dijit.registerWin(window);
		if (dojo.isIE) {
			dojo.addOnWindowUnload(function () {
				dijit.unregisterWin(handle);
				handle = null;
			});
		}
	});
}
if (!dojo._hasResource["dojo.AdapterRegistry"]) {
	dojo._hasResource["dojo.AdapterRegistry"] = true;
	dojo.provide("dojo.AdapterRegistry");
	dojo.AdapterRegistry = function (returnWrappers) {
		this.pairs = [];
		this.returnWrappers = returnWrappers || false;
	};
	dojo.extend(dojo.AdapterRegistry, {register:function (name, check, wrap, directReturn, override) {
		this.pairs[((override) ? "unshift" : "push")]([name, check, wrap, directReturn]);
	}, match:function () {
		for (var i = 0; i < this.pairs.length; i++) {
			var pair = this.pairs[i];
			if (pair[1].apply(this, arguments)) {
				if ((pair[3]) || (this.returnWrappers)) {
					return pair[2];
				} else {
					return pair[2].apply(this, arguments);
				}
			}
		}
		throw new Error("No match found");
	}, unregister:function (name) {
		for (var i = 0; i < this.pairs.length; i++) {
			var pair = this.pairs[i];
			if (pair[0] == name) {
				this.pairs.splice(i, 1);
				return true;
			}
		}
		return false;
	}});
}
if (!dojo._hasResource["dijit._base.place"]) {
	dojo._hasResource["dijit._base.place"] = true;
	dojo.provide("dijit._base.place");
	dijit.getViewport = function () {
		var scrollRoot = (dojo.doc.compatMode == "BackCompat") ? dojo.body() : dojo.doc.documentElement;
		var scroll = dojo._docScroll();
		return {w:scrollRoot.clientWidth, h:scrollRoot.clientHeight, l:scroll.x, t:scroll.y};
	};
	dijit.placeOnScreen = function (node, pos, corners, padding) {
		var choices = dojo.map(corners, function (corner) {
			var c = {corner:corner, pos:{x:pos.x, y:pos.y}};
			if (padding) {
				c.pos.x += corner.charAt(1) == "L" ? padding.x : -padding.x;
				c.pos.y += corner.charAt(0) == "T" ? padding.y : -padding.y;
			}
			return c;
		});
		return dijit._place(node, choices);
	};
	dijit._place = function (node, choices, layoutNode) {
		var view = dijit.getViewport();
		if (!node.parentNode || String(node.parentNode.tagName).toLowerCase() != "body") {
			dojo.body().appendChild(node);
		}
		var best = null;
		dojo.some(choices, function (choice) {
			var corner = choice.corner;
			var pos = choice.pos;
			if (layoutNode) {
				layoutNode(node, choice.aroundCorner, corner);
			}
			var style = node.style;
			var oldDisplay = style.display;
			var oldVis = style.visibility;
			style.visibility = "hidden";
			style.display = "";
			var mb = dojo.marginBox(node);
			style.display = oldDisplay;
			style.visibility = oldVis;
			var startX = Math.max(view.l, corner.charAt(1) == "L" ? pos.x : (pos.x - mb.w)), startY = Math.max(view.t, corner.charAt(0) == "T" ? pos.y : (pos.y - mb.h)), endX = Math.min(view.l + view.w, corner.charAt(1) == "L" ? (startX + mb.w) : pos.x), endY = Math.min(view.t + view.h, corner.charAt(0) == "T" ? (startY + mb.h) : pos.y), width = endX - startX, height = endY - startY, overflow = (mb.w - width) + (mb.h - height);
			if (best == null || overflow < best.overflow) {
				best = {corner:corner, aroundCorner:choice.aroundCorner, x:startX, y:startY, w:width, h:height, overflow:overflow};
			}
			return !overflow;
		});
		node.style.left = best.x + "px";
		node.style.top = best.y + "px";
		if (best.overflow && layoutNode) {
			layoutNode(node, best.aroundCorner, best.corner);
		}
		return best;
	};
	dijit.placeOnScreenAroundNode = function (node, aroundNode, aroundCorners, layoutNode) {
		aroundNode = dojo.byId(aroundNode);
		var oldDisplay = aroundNode.style.display;
		aroundNode.style.display = "";
		var aroundNodePos = dojo.position(aroundNode, true);
		aroundNode.style.display = oldDisplay;
		return dijit._placeOnScreenAroundRect(node, aroundNodePos.x, aroundNodePos.y, aroundNodePos.w, aroundNodePos.h, aroundCorners, layoutNode);
	};
	dijit.placeOnScreenAroundRectangle = function (node, aroundRect, aroundCorners, layoutNode) {
		return dijit._placeOnScreenAroundRect(node, aroundRect.x, aroundRect.y, aroundRect.width, aroundRect.height, aroundCorners, layoutNode);
	};
	dijit._placeOnScreenAroundRect = function (node, x, y, width, height, aroundCorners, layoutNode) {
		var choices = [];
		for (var nodeCorner in aroundCorners) {
			choices.push({aroundCorner:nodeCorner, corner:aroundCorners[nodeCorner], pos:{x:x + (nodeCorner.charAt(1) == "L" ? 0 : width), y:y + (nodeCorner.charAt(0) == "T" ? 0 : height)}});
		}
		return dijit._place(node, choices, layoutNode);
	};
	dijit.placementRegistry = new dojo.AdapterRegistry();
	dijit.placementRegistry.register("node", function (n, x) {
		return typeof x == "object" && typeof x.offsetWidth != "undefined" && typeof x.offsetHeight != "undefined";
	}, dijit.placeOnScreenAroundNode);
	dijit.placementRegistry.register("rect", function (n, x) {
		return typeof x == "object" && "x" in x && "y" in x && "width" in x && "height" in x;
	}, dijit.placeOnScreenAroundRectangle);
	dijit.placeOnScreenAroundElement = function (node, aroundElement, aroundCorners, layoutNode) {
		return dijit.placementRegistry.match.apply(dijit.placementRegistry, arguments);
	};
	dijit.getPopupAlignment = function (position, leftToRight) {
		var align = {};
		dojo.forEach(position, function (pos) {
			switch (pos) {
			  case "after":
				align[leftToRight ? "BR" : "BL"] = leftToRight ? "BL" : "BR";
				break;
			  case "before":
				align[leftToRight ? "BL" : "BR"] = leftToRight ? "BR" : "BL";
				break;
			  case "below":
				align[leftToRight ? "BL" : "BR"] = leftToRight ? "TL" : "TR";
				align[leftToRight ? "BR" : "BL"] = leftToRight ? "TR" : "TL";
				break;
			  case "above":
			  default:
				align[leftToRight ? "TL" : "TR"] = leftToRight ? "BL" : "BR";
				align[leftToRight ? "TR" : "TL"] = leftToRight ? "BR" : "BL";
				break;
			}
		});
		return align;
	};
	dijit.getPopupAroundAlignment = function (position, leftToRight) {
		var align = {};
		dojo.forEach(position, function (pos) {
			switch (pos) {
			  case "after":
				align[leftToRight ? "BR" : "BL"] = leftToRight ? "BL" : "BR";
				break;
			  case "before":
				align[leftToRight ? "BL" : "BR"] = leftToRight ? "BR" : "BL";
				break;
			  case "below":
				align[leftToRight ? "BL" : "BR"] = leftToRight ? "TL" : "TR";
				align[leftToRight ? "BR" : "BL"] = leftToRight ? "TR" : "TL";
				break;
			  case "above":
			  default:
				align[leftToRight ? "TL" : "TR"] = leftToRight ? "BL" : "BR";
				align[leftToRight ? "TR" : "TL"] = leftToRight ? "BR" : "BL";
				break;
			}
		});
		return align;
	};
}
if (!dojo._hasResource["dijit._base.window"]) {
	dojo._hasResource["dijit._base.window"] = true;
	dojo.provide("dijit._base.window");
	dijit.getDocumentWindow = function (doc) {
		if (dojo.isIE && window !== document.parentWindow && !doc._parentWindow) {
			doc.parentWindow.execScript("document._parentWindow = window;", "Javascript");
			var win = doc._parentWindow;
			doc._parentWindow = null;
			return win;
		}
		return doc._parentWindow || doc.parentWindow || doc.defaultView;
	};
}
if (!dojo._hasResource["dijit._base.popup"]) {
	dojo._hasResource["dijit._base.popup"] = true;
	dojo.provide("dijit._base.popup");
	dijit.popup = new function () {
		var stack = [], beginZIndex = 1000, idGen = 1;
		this.moveOffScreen = function (node) {
			var s = node.style;
			s.visibility = "hidden";
			s.position = "absolute";
			s.top = "-9999px";
			if (s.display == "none") {
				s.display = "";
			}
			dojo.body().appendChild(node);
		};
		var getTopPopup = function () {
			for (var pi = stack.length - 1; pi > 0 && stack[pi].parent === stack[pi - 1].widget; pi--) {
			}
			return stack[pi];
		};
		var wrappers = [];
		this.open = function (args) {
			var widget = args.popup, orient = args.orient || (dojo._isBodyLtr() ? {"BL":"TL", "BR":"TR", "TL":"BL", "TR":"BR"} : {"BR":"TR", "BL":"TL", "TR":"BR", "TL":"BL"}), around = args.around, id = (args.around && args.around.id) ? (args.around.id + "_dropdown") : ("popup_" + idGen++);
			var wrapperobj = wrappers.pop(), wrapper, iframe;
			if (!wrapperobj) {
				wrapper = dojo.create("div", {"class":"dijitPopup"}, dojo.body());
				dijit.setWaiRole(wrapper, "presentation");
			} else {
				wrapper = wrapperobj[0];
				iframe = wrapperobj[1];
			}
			dojo.attr(wrapper, {id:id, style:{zIndex:beginZIndex + stack.length, visibility:"hidden", top:"-9999px"}, dijitPopupParent:args.parent ? args.parent.id : ""});
			var s = widget.domNode.style;
			s.display = "";
			s.visibility = "";
			s.position = "";
			s.top = "0px";
			wrapper.appendChild(widget.domNode);
			if (!iframe) {
				iframe = new dijit.BackgroundIframe(wrapper);
			} else {
				iframe.resize(wrapper);
			}
			var best = around ? dijit.placeOnScreenAroundElement(wrapper, around, orient, widget.orient ? dojo.hitch(widget, "orient") : null) : dijit.placeOnScreen(wrapper, args, orient == "R" ? ["TR", "BR", "TL", "BL"] : ["TL", "BL", "TR", "BR"], args.padding);
			wrapper.style.visibility = "visible";
			var handlers = [];
			handlers.push(dojo.connect(wrapper, "onkeypress", this, function (evt) {
				if (evt.charOrCode == dojo.keys.ESCAPE && args.onCancel) {
					dojo.stopEvent(evt);
					args.onCancel();
				} else {
					if (evt.charOrCode === dojo.keys.TAB) {
						dojo.stopEvent(evt);
						var topPopup = getTopPopup();
						if (topPopup && topPopup.onCancel) {
							topPopup.onCancel();
						}
					}
				}
			}));
			if (widget.onCancel) {
				handlers.push(dojo.connect(widget, "onCancel", args.onCancel));
			}
			handlers.push(dojo.connect(widget, widget.onExecute ? "onExecute" : "onChange", function () {
				var topPopup = getTopPopup();
				if (topPopup && topPopup.onExecute) {
					topPopup.onExecute();
				}
			}));
			stack.push({wrapper:wrapper, iframe:iframe, widget:widget, parent:args.parent, onExecute:args.onExecute, onCancel:args.onCancel, onClose:args.onClose, handlers:handlers});
			if (widget.onOpen) {
				widget.onOpen(best);
			}
			return best;
		};
		this.close = function (popup) {
			while (dojo.some(stack, function (elem) {
				return elem.widget == popup;
			})) {
				var top = stack.pop(), wrapper = top.wrapper, iframe = top.iframe, widget = top.widget, onClose = top.onClose;
				if (widget.onClose) {
					widget.onClose();
				}
				dojo.forEach(top.handlers, dojo.disconnect);
				if (widget && widget.domNode) {
					this.moveOffScreen(widget.domNode);
				}
				wrapper.style.top = "-9999px";
				wrapper.style.visibility = "hidden";
				wrappers.push([wrapper, iframe]);
				if (onClose) {
					onClose();
				}
			}
		};
	}();
	dijit._frames = new function () {
		var queue = [];
		this.pop = function () {
			var iframe;
			if (queue.length) {
				iframe = queue.pop();
				iframe.style.display = "";
			} else {
				if (dojo.isIE) {
					var burl = dojo.config["dojoBlankHtmlUrl"] || (dojo.moduleUrl("dojo", "resources/blank.html") + "") || "javascript:\"\"";
					var html = "<iframe src='" + burl + "'" + " style='position: absolute; left: 0px; top: 0px;" + "z-index: -1; filter:Alpha(Opacity=\"0\");'>";
					iframe = dojo.doc.createElement(html);
				} else {
					iframe = dojo.create("iframe");
					iframe.src = "javascript:\"\"";
					iframe.className = "dijitBackgroundIframe";
					dojo.style(iframe, "opacity", 0.1);
				}
				iframe.tabIndex = -1;
			}
			return iframe;
		};
		this.push = function (iframe) {
			iframe.style.display = "none";
			queue.push(iframe);
		};
	}();
	dijit.BackgroundIframe = function (node) {
		if (!node.id) {
			throw new Error("no id");
		}
		if (dojo.isIE || dojo.isMoz) {
			var iframe = dijit._frames.pop();
			node.appendChild(iframe);
			if (dojo.isIE < 7) {
				this.resize(node);
				this._conn = dojo.connect(node, "onresize", this, function () {
					this.resize(node);
				});
			} else {
				dojo.style(iframe, {width:"100%", height:"100%"});
			}
			this.iframe = iframe;
		}
	};
	dojo.extend(dijit.BackgroundIframe, {resize:function (node) {
		if (this.iframe && dojo.isIE < 7) {
			dojo.style(this.iframe, {width:node.offsetWidth + "px", height:node.offsetHeight + "px"});
		}
	}, destroy:function () {
		if (this._conn) {
			dojo.disconnect(this._conn);
			this._conn = null;
		}
		if (this.iframe) {
			dijit._frames.push(this.iframe);
			delete this.iframe;
		}
	}});
}
if (!dojo._hasResource["dijit._base.scroll"]) {
	dojo._hasResource["dijit._base.scroll"] = true;
	dojo.provide("dijit._base.scroll");
	dijit.scrollIntoView = function (node, pos) {
		try {
			node = dojo.byId(node);
			var doc = node.ownerDocument || dojo.doc, body = doc.body || dojo.body(), html = doc.documentElement || body.parentNode, isIE = dojo.isIE, isWK = dojo.isWebKit;
			if ((!(dojo.isMoz || isIE || isWK) || node == body || node == html) && (typeof node.scrollIntoView != "undefined")) {
				node.scrollIntoView(false);
				return;
			}
			var backCompat = doc.compatMode == "BackCompat", clientAreaRoot = backCompat ? body : html, scrollRoot = isWK ? body : clientAreaRoot, rootWidth = clientAreaRoot.clientWidth, rootHeight = clientAreaRoot.clientHeight, rtl = !dojo._isBodyLtr(), nodePos = pos || dojo.position(node), el = node.parentNode, isFixed = function (el) {
				return ((isIE <= 6 || (isIE && backCompat)) ? false : (dojo.style(el, "position").toLowerCase() == "fixed"));
			};
			if (isFixed(node)) {
				return;
			}
			while (el) {
				if (el == body) {
					el = scrollRoot;
				}
				var elPos = dojo.position(el), fixedPos = isFixed(el);
				with (elPos) {
					if (el == scrollRoot) {
						w = rootWidth, h = rootHeight;
						if (scrollRoot == html && isIE && rtl) {
							x += scrollRoot.offsetWidth - w;
						}
						if (x < 0 || !isIE) {
							x = 0;
						}
						if (y < 0 || !isIE) {
							y = 0;
						}
					} else {
						var pb = dojo._getPadBorderExtents(el);
						w -= pb.w;
						h -= pb.h;
						x += pb.l;
						y += pb.t;
					}
					with (el) {
						if (el != scrollRoot) {
							var clientSize = clientWidth, scrollBarSize = w - clientSize;
							if (clientSize > 0 && scrollBarSize > 0) {
								w = clientSize;
								if (isIE && rtl) {
									x += scrollBarSize;
								}
							}
							clientSize = clientHeight;
							scrollBarSize = h - clientSize;
							if (clientSize > 0 && scrollBarSize > 0) {
								h = clientSize;
							}
						}
						if (fixedPos) {
							if (y < 0) {
								h += y, y = 0;
							}
							if (x < 0) {
								w += x, x = 0;
							}
							if (y + h > rootHeight) {
								h = rootHeight - y;
							}
							if (x + w > rootWidth) {
								w = rootWidth - x;
							}
						}
						var l = nodePos.x - x, t = nodePos.y - Math.max(y, 0), r = l + nodePos.w - w, bot = t + nodePos.h - h;
						if (r * l > 0) {
							var s = Math[l < 0 ? "max" : "min"](l, r);
							nodePos.x += scrollLeft;
							scrollLeft += (isIE >= 8 && !backCompat && rtl) ? -s : s;
							nodePos.x -= scrollLeft;
						}
						if (bot * t > 0) {
							nodePos.y += scrollTop;
							scrollTop += Math[t < 0 ? "max" : "min"](t, bot);
							nodePos.y -= scrollTop;
						}
					}
				}
				el = (el != scrollRoot) && !fixedPos && el.parentNode;
			}
		}
		catch (error) {
			console.error("scrollIntoView: " + error);
			node.scrollIntoView(false);
		}
	};
}
if (!dojo._hasResource["dijit._base.sniff"]) {
	dojo._hasResource["dijit._base.sniff"] = true;
	dojo.provide("dijit._base.sniff");
	(function () {
		var d = dojo, html = d.doc.documentElement, ie = d.isIE, opera = d.isOpera, maj = Math.floor, ff = d.isFF, boxModel = d.boxModel.replace(/-/, ""), classes = {dj_ie:ie, dj_ie6:maj(ie) == 6, dj_ie7:maj(ie) == 7, dj_ie8:maj(ie) == 8, dj_iequirks:ie && d.isQuirks, dj_opera:opera, dj_khtml:d.isKhtml, dj_webkit:d.isWebKit, dj_safari:d.isSafari, dj_chrome:d.isChrome, dj_gecko:d.isMozilla, dj_ff3:maj(ff) == 3};
		classes["dj_" + boxModel] = true;
		for (var p in classes) {
			if (classes[p]) {
				if (html.className) {
					html.className += " " + p;
				} else {
					html.className = p;
				}
			}
		}
		dojo._loaders.unshift(function () {
			if (!dojo._isBodyLtr()) {
				html.className += " dijitRtl";
				for (var p in classes) {
					if (classes[p]) {
						html.className += " " + p + "-rtl";
					}
				}
			}
		});
	})();
}
if (!dojo._hasResource["dijit._base.typematic"]) {
	dojo._hasResource["dijit._base.typematic"] = true;
	dojo.provide("dijit._base.typematic");
	dijit.typematic = {_fireEventAndReload:function () {
		this._timer = null;
		this._callback(++this._count, this._node, this._evt);
		this._currentTimeout = Math.max(this._currentTimeout < 0 ? this._initialDelay : (this._subsequentDelay > 1 ? this._subsequentDelay : Math.round(this._currentTimeout * this._subsequentDelay)), 10);
		this._timer = setTimeout(dojo.hitch(this, "_fireEventAndReload"), this._currentTimeout);
	}, trigger:function (evt, _this, node, callback, obj, subsequentDelay, initialDelay) {
		if (obj != this._obj) {
			this.stop();
			this._initialDelay = initialDelay || 500;
			this._subsequentDelay = subsequentDelay || 0.9;
			this._obj = obj;
			this._evt = evt;
			this._node = node;
			this._currentTimeout = -1;
			this._count = -1;
			this._callback = dojo.hitch(_this, callback);
			this._fireEventAndReload();
		}
	}, stop:function () {
		if (this._timer) {
			clearTimeout(this._timer);
			this._timer = null;
		}
		if (this._obj) {
			this._callback(-1, this._node, this._evt);
			this._obj = null;
		}
	}, addKeyListener:function (node, keyObject, _this, callback, subsequentDelay, initialDelay) {
		if (keyObject.keyCode) {
			keyObject.charOrCode = keyObject.keyCode;
			dojo.deprecated("keyCode attribute parameter for dijit.typematic.addKeyListener is deprecated. Use charOrCode instead.", "", "2.0");
		} else {
			if (keyObject.charCode) {
				keyObject.charOrCode = String.fromCharCode(keyObject.charCode);
				dojo.deprecated("charCode attribute parameter for dijit.typematic.addKeyListener is deprecated. Use charOrCode instead.", "", "2.0");
			}
		}
		return [dojo.connect(node, "onkeypress", this, function (evt) {
			if (evt.charOrCode == keyObject.charOrCode && (keyObject.ctrlKey === undefined || keyObject.ctrlKey == evt.ctrlKey) && (keyObject.altKey === undefined || keyObject.altKey == evt.altKey) && (keyObject.metaKey === undefined || keyObject.metaKey == (evt.metaKey || false)) && (keyObject.shiftKey === undefined || keyObject.shiftKey == evt.shiftKey)) {
				dojo.stopEvent(evt);
				dijit.typematic.trigger(keyObject, _this, node, callback, keyObject, subsequentDelay, initialDelay);
			} else {
				if (dijit.typematic._obj == keyObject) {
					dijit.typematic.stop();
				}
			}
		}), dojo.connect(node, "onkeyup", this, function (evt) {
			if (dijit.typematic._obj == keyObject) {
				dijit.typematic.stop();
			}
		})];
	}, addMouseListener:function (node, _this, callback, subsequentDelay, initialDelay) {
		var dc = dojo.connect;
		return [dc(node, "mousedown", this, function (evt) {
			dojo.stopEvent(evt);
			dijit.typematic.trigger(evt, _this, node, callback, node, subsequentDelay, initialDelay);
		}), dc(node, "mouseup", this, function (evt) {
			dojo.stopEvent(evt);
			dijit.typematic.stop();
		}), dc(node, "mouseout", this, function (evt) {
			dojo.stopEvent(evt);
			dijit.typematic.stop();
		}), dc(node, "mousemove", this, function (evt) {
			dojo.stopEvent(evt);
		}), dc(node, "dblclick", this, function (evt) {
			dojo.stopEvent(evt);
			if (dojo.isIE) {
				dijit.typematic.trigger(evt, _this, node, callback, node, subsequentDelay, initialDelay);
				setTimeout(dojo.hitch(this, dijit.typematic.stop), 50);
			}
		})];
	}, addListener:function (mouseNode, keyNode, keyObject, _this, callback, subsequentDelay, initialDelay) {
		return this.addKeyListener(keyNode, keyObject, _this, callback, subsequentDelay, initialDelay).concat(this.addMouseListener(mouseNode, _this, callback, subsequentDelay, initialDelay));
	}, destroy:function () {
		delete this._evt;
		delete this._node;
	}};
	dojo.addOnWindowUnload(function () {
		dijit.typematic.destroy();
	});
}
if (!dojo._hasResource["dijit._base.wai"]) {
	dojo._hasResource["dijit._base.wai"] = true;
	dojo.provide("dijit._base.wai");
	dijit.wai = {onload:function () {
		var div = dojo.create("div", {id:"a11yTestNode", style:{cssText:"border: 1px solid;" + "border-color:red green;" + "position: absolute;" + "height: 5px;" + "top: -999px;" + "background-image: url(\"" + (dojo.config.blankGif || dojo.moduleUrl("dojo", "resources/blank.gif")) + "\");"}}, dojo.body());
		var cs = dojo.getComputedStyle(div);
		if (cs) {
			var bkImg = cs.backgroundImage;
			var needsA11y = (cs.borderTopColor == cs.borderRightColor) || (bkImg != null && (bkImg == "none" || bkImg == "url(invalid-url:)"));
			dojo[needsA11y ? "addClass" : "removeClass"](dojo.body(), "dijit_a11y");
			if (dojo.isIE) {
				div.outerHTML = "";
			} else {
				dojo.body().removeChild(div);
			}
		}
	}};
	if (dojo.isIE || dojo.isMoz) {
		dojo._loaders.unshift(dijit.wai.onload);
	}
	dojo.mixin(dijit, {_XhtmlRoles:/banner|contentinfo|definition|main|navigation|search|note|secondary|seealso/, hasWaiRole:function (elem, role) {
		var waiRole = this.getWaiRole(elem);
		return role ? (waiRole.indexOf(role) > -1) : (waiRole.length > 0);
	}, getWaiRole:function (elem) {
		return dojo.trim((dojo.attr(elem, "role") || "").replace(this._XhtmlRoles, "").replace("wairole:", ""));
	}, setWaiRole:function (elem, role) {
		var curRole = dojo.attr(elem, "role") || "";
		if (!this._XhtmlRoles.test(curRole)) {
			dojo.attr(elem, "role", role);
		} else {
			if ((" " + curRole + " ").indexOf(" " + role + " ") < 0) {
				var clearXhtml = dojo.trim(curRole.replace(this._XhtmlRoles, ""));
				var cleanRole = dojo.trim(curRole.replace(clearXhtml, ""));
				dojo.attr(elem, "role", cleanRole + (cleanRole ? " " : "") + role);
			}
		}
	}, removeWaiRole:function (elem, role) {
		var roleValue = dojo.attr(elem, "role");
		if (!roleValue) {
			return;
		}
		if (role) {
			var t = dojo.trim((" " + roleValue + " ").replace(" " + role + " ", " "));
			dojo.attr(elem, "role", t);
		} else {
			elem.removeAttribute("role");
		}
	}, hasWaiState:function (elem, state) {
		return elem.hasAttribute ? elem.hasAttribute("aria-" + state) : !!elem.getAttribute("aria-" + state);
	}, getWaiState:function (elem, state) {
		return elem.getAttribute("aria-" + state) || "";
	}, setWaiState:function (elem, state, value) {
		elem.setAttribute("aria-" + state, value);
	}, removeWaiState:function (elem, state) {
		elem.removeAttribute("aria-" + state);
	}});
}
if (!dojo._hasResource["dijit._base"]) {
	dojo._hasResource["dijit._base"] = true;
	dojo.provide("dijit._base");
}
if (!dojo._hasResource["dijit._Widget"]) {
	dojo._hasResource["dijit._Widget"] = true;
	dojo.provide("dijit._Widget");
	dojo.require("dijit._base");
	dojo.connect(dojo, "_connect", function (widget, event) {
		if (widget && dojo.isFunction(widget._onConnect)) {
			widget._onConnect(event);
		}
	});
	dijit._connectOnUseEventHandler = function (event) {
	};
	dijit._lastKeyDownNode = null;
	if (dojo.isIE) {
		(function () {
			var keydownCallback = function (evt) {
				dijit._lastKeyDownNode = evt.srcElement;
			};
			dojo.doc.attachEvent("onkeydown", keydownCallback);
			dojo.addOnWindowUnload(function () {
				dojo.doc.detachEvent("onkeydown", keydownCallback);
			});
		})();
	} else {
		dojo.doc.addEventListener("keydown", function (evt) {
			dijit._lastKeyDownNode = evt.target;
		}, true);
	}
	(function () {
		var _attrReg = {}, getSetterAttributes = function (widget) {
			var dc = widget.declaredClass;
			if (!_attrReg[dc]) {
				var r = [], attrs, proto = widget.constructor.prototype;
				for (var fxName in proto) {
					if (dojo.isFunction(proto[fxName]) && (attrs = fxName.match(/^_set([a-zA-Z]*)Attr$/)) && attrs[1]) {
						r.push(attrs[1].charAt(0).toLowerCase() + attrs[1].substr(1));
					}
				}
				_attrReg[dc] = r;
			}
			return _attrReg[dc] || [];
		};
		dojo.declare("dijit._Widget", null, {id:"", lang:"", dir:"", "class":"", style:"", title:"", tooltip:"", srcNodeRef:null, domNode:null, containerNode:null, attributeMap:{id:"", dir:"", lang:"", "class":"", style:"", title:""}, _deferredConnects:{onClick:"", onDblClick:"", onKeyDown:"", onKeyPress:"", onKeyUp:"", onMouseMove:"", onMouseDown:"", onMouseOut:"", onMouseOver:"", onMouseLeave:"", onMouseEnter:"", onMouseUp:""}, onClick:dijit._connectOnUseEventHandler, onDblClick:dijit._connectOnUseEventHandler, onKeyDown:dijit._connectOnUseEventHandler, onKeyPress:dijit._connectOnUseEventHandler, onKeyUp:dijit._connectOnUseEventHandler, onMouseDown:dijit._connectOnUseEventHandler, onMouseMove:dijit._connectOnUseEventHandler, onMouseOut:dijit._connectOnUseEventHandler, onMouseOver:dijit._connectOnUseEventHandler, onMouseLeave:dijit._connectOnUseEventHandler, onMouseEnter:dijit._connectOnUseEventHandler, onMouseUp:dijit._connectOnUseEventHandler, _blankGif:(dojo.config.blankGif || dojo.moduleUrl("dojo", "resources/blank.gif")).toString(), postscript:function (params, srcNodeRef) {
			this.create(params, srcNodeRef);
		}, create:function (params, srcNodeRef) {
			this.srcNodeRef = dojo.byId(srcNodeRef);
			this._connects = [];
			this._subscribes = [];
			this._deferredConnects = dojo.clone(this._deferredConnects);
			for (var attr in this.attributeMap) {
				delete this._deferredConnects[attr];
			}
			for (attr in this._deferredConnects) {
				if (this[attr] !== dijit._connectOnUseEventHandler) {
					delete this._deferredConnects[attr];
				}
			}
			if (this.srcNodeRef && (typeof this.srcNodeRef.id == "string")) {
				this.id = this.srcNodeRef.id;
			}
			if (params) {
				this.params = params;
				dojo.mixin(this, params);
			}
			this.postMixInProperties();
			if (!this.id) {
				this.id = dijit.getUniqueId(this.declaredClass.replace(/\./g, "_"));
			}
			dijit.registry.add(this);
			this.buildRendering();
			if (this.domNode) {
				this._applyAttributes();
				var source = this.srcNodeRef;
				if (source && source.parentNode) {
					source.parentNode.replaceChild(this.domNode, source);
				}
				for (attr in this.params) {
					this._onConnect(attr);
				}
			}
			if (this.domNode) {
				this.domNode.setAttribute("widgetId", this.id);
			}
			this.postCreate();
			if (this.srcNodeRef && !this.srcNodeRef.parentNode) {
				delete this.srcNodeRef;
			}
			this._created = true;
		}, _applyAttributes:function () {
			var condAttrApply = function (attr, scope) {
				if ((scope.params && attr in scope.params) || scope[attr]) {
					scope.attr(attr, scope[attr]);
				}
			};
			for (var attr in this.attributeMap) {
				condAttrApply(attr, this);
			}
			dojo.forEach(getSetterAttributes(this), function (a) {
				if (!(a in this.attributeMap)) {
					condAttrApply(a, this);
				}
			}, this);
		}, postMixInProperties:function () {
		}, buildRendering:function () {
			this.domNode = this.srcNodeRef || dojo.create("div");
		}, postCreate:function () {
		}, startup:function () {
			this._started = true;
		}, destroyRecursive:function (preserveDom) {
			this._beingDestroyed = true;
			this.destroyDescendants(preserveDom);
			this.destroy(preserveDom);
		}, destroy:function (preserveDom) {
			this._beingDestroyed = true;
			this.uninitialize();
			var d = dojo, dfe = d.forEach, dun = d.unsubscribe;
			dfe(this._connects, function (array) {
				dfe(array, d.disconnect);
			});
			dfe(this._subscribes, function (handle) {
				dun(handle);
			});
			dfe(this._supportingWidgets || [], function (w) {
				if (w.destroyRecursive) {
					w.destroyRecursive();
				} else {
					if (w.destroy) {
						w.destroy();
					}
				}
			});
			this.destroyRendering(preserveDom);
			dijit.registry.remove(this.id);
			this._destroyed = true;
		}, destroyRendering:function (preserveDom) {
			if (this.bgIframe) {
				this.bgIframe.destroy(preserveDom);
				delete this.bgIframe;
			}
			if (this.domNode) {
				if (preserveDom) {
					dojo.removeAttr(this.domNode, "widgetId");
				} else {
					dojo.destroy(this.domNode);
				}
				delete this.domNode;
			}
			if (this.srcNodeRef) {
				if (!preserveDom) {
					dojo.destroy(this.srcNodeRef);
				}
				delete this.srcNodeRef;
			}
		}, destroyDescendants:function (preserveDom) {
			dojo.forEach(this.getChildren(), function (widget) {
				if (widget.destroyRecursive) {
					widget.destroyRecursive(preserveDom);
				}
			});
		}, uninitialize:function () {
			return false;
		}, onFocus:function () {
		}, onBlur:function () {
		}, _onFocus:function (e) {
			this.onFocus();
		}, _onBlur:function () {
			this.onBlur();
		}, _onConnect:function (event) {
			if (event in this._deferredConnects) {
				var mapNode = this[this._deferredConnects[event] || "domNode"];
				this.connect(mapNode, event.toLowerCase(), event);
				delete this._deferredConnects[event];
			}
		}, _setClassAttr:function (value) {
			var mapNode = this[this.attributeMap["class"] || "domNode"];
			dojo.removeClass(mapNode, this["class"]);
			this["class"] = value;
			dojo.addClass(mapNode, value);
		}, _setStyleAttr:function (value) {
			var mapNode = this[this.attributeMap.style || "domNode"];
			if (dojo.isObject(value)) {
				dojo.style(mapNode, value);
			} else {
				if (mapNode.style.cssText) {
					mapNode.style.cssText += "; " + value;
				} else {
					mapNode.style.cssText = value;
				}
			}
			this.style = value;
		}, setAttribute:function (attr, value) {
			dojo.deprecated(this.declaredClass + "::setAttribute() is deprecated. Use attr() instead.", "", "2.0");
			this.attr(attr, value);
		}, _attrToDom:function (attr, value) {
			var commands = this.attributeMap[attr];
			dojo.forEach(dojo.isArray(commands) ? commands : [commands], function (command) {
				var mapNode = this[command.node || command || "domNode"];
				var type = command.type || "attribute";
				switch (type) {
				  case "attribute":
					if (dojo.isFunction(value)) {
						value = dojo.hitch(this, value);
					}
					var attrName = command.attribute ? command.attribute : (/^on[A-Z][a-zA-Z]*$/.test(attr) ? attr.toLowerCase() : attr);
					dojo.attr(mapNode, attrName, value);
					break;
				  case "innerText":
					mapNode.innerHTML = "";
					mapNode.appendChild(dojo.doc.createTextNode(value));
					break;
				  case "innerHTML":
					mapNode.innerHTML = value;
					break;
				  case "class":
					dojo.removeClass(mapNode, this[attr]);
					dojo.addClass(mapNode, value);
					break;
				}
			}, this);
			this[attr] = value;
		}, attr:function (name, value) {
			var args = arguments.length;
			if (args == 1 && !dojo.isString(name)) {
				for (var x in name) {
					this.attr(x, name[x]);
				}
				return this;
			}
			var names = this._getAttrNames(name);
			if (args >= 2) {
				if (this[names.s]) {
					args = dojo._toArray(arguments, 1);
					return this[names.s].apply(this, args) || this;
				} else {
					if (name in this.attributeMap) {
						this._attrToDom(name, value);
					}
					this[name] = value;
				}
				return this;
			} else {
				return this[names.g] ? this[names.g]() : this[name];
			}
		}, _attrPairNames:{}, _getAttrNames:function (name) {
			var apn = this._attrPairNames;
			if (apn[name]) {
				return apn[name];
			}
			var uc = name.charAt(0).toUpperCase() + name.substr(1);
			return (apn[name] = {n:name + "Node", s:"_set" + uc + "Attr", g:"_get" + uc + "Attr"});
		}, toString:function () {
			return "[Widget " + this.declaredClass + ", " + (this.id || "NO ID") + "]";
		}, getDescendants:function () {
			return this.containerNode ? dojo.query("[widgetId]", this.containerNode).map(dijit.byNode) : [];
		}, getChildren:function () {
			return this.containerNode ? dijit.findWidgets(this.containerNode) : [];
		}, nodesWithKeyClick:["input", "button"], connect:function (obj, event, method) {
			var d = dojo, dc = d._connect, handles = [];
			if (event == "ondijitclick") {
				if (!this.nodesWithKeyClick[obj.tagName.toLowerCase()]) {
					var m = d.hitch(this, method);
					handles.push(dc(obj, "onkeydown", this, function (e) {
						if ((e.keyCode == d.keys.ENTER || e.keyCode == d.keys.SPACE) && !e.ctrlKey && !e.shiftKey && !e.altKey && !e.metaKey) {
							dijit._lastKeyDownNode = e.target;
							d.stopEvent(e);
						}
					}), dc(obj, "onkeyup", this, function (e) {
						if ((e.keyCode == d.keys.ENTER || e.keyCode == d.keys.SPACE) && e.target === dijit._lastKeyDownNode && !e.ctrlKey && !e.shiftKey && !e.altKey && !e.metaKey) {
							dijit._lastKeyDownNode = null;
							return m(e);
						}
					}));
				}
				event = "onclick";
			}
			handles.push(dc(obj, event, this, method));
			this._connects.push(handles);
			return handles;
		}, disconnect:function (handles) {
			for (var i = 0; i < this._connects.length; i++) {
				if (this._connects[i] == handles) {
					dojo.forEach(handles, dojo.disconnect);
					this._connects.splice(i, 1);
					return;
				}
			}
		}, subscribe:function (topic, method) {
			var d = dojo, handle = d.subscribe(topic, this, method);
			this._subscribes.push(handle);
			return handle;
		}, unsubscribe:function (handle) {
			for (var i = 0; i < this._subscribes.length; i++) {
				if (this._subscribes[i] == handle) {
					dojo.unsubscribe(handle);
					this._subscribes.splice(i, 1);
					return;
				}
			}
		}, isLeftToRight:function () {
			return dojo._isBodyLtr();
		}, isFocusable:function () {
			return this.focus && (dojo.style(this.domNode, "display") != "none");
		}, placeAt:function (reference, position) {
			if (reference.declaredClass && reference.addChild) {
				reference.addChild(this, position);
			} else {
				dojo.place(this.domNode, reference, position);
			}
			return this;
		}, _onShow:function () {
			this.onShow();
		}, onShow:function () {
		}, onHide:function () {
		}});
	})();
}
if (!dojo._hasResource["dojo.date.stamp"]) {
	dojo._hasResource["dojo.date.stamp"] = true;
	dojo.provide("dojo.date.stamp");
	dojo.date.stamp.fromISOString = function (formattedString, defaultTime) {
		if (!dojo.date.stamp._isoRegExp) {
			dojo.date.stamp._isoRegExp = /^(?:(\d{4})(?:-(\d{2})(?:-(\d{2}))?)?)?(?:T(\d{2}):(\d{2})(?::(\d{2})(.\d+)?)?((?:[+-](\d{2}):(\d{2}))|Z)?)?$/;
		}
		var match = dojo.date.stamp._isoRegExp.exec(formattedString), result = null;
		if (match) {
			match.shift();
			if (match[1]) {
				match[1]--;
			}
			if (match[6]) {
				match[6] *= 1000;
			}
			if (defaultTime) {
				defaultTime = new Date(defaultTime);
				dojo.map(["FullYear", "Month", "Date", "Hours", "Minutes", "Seconds", "Milliseconds"], function (prop) {
					return defaultTime["get" + prop]();
				}).forEach(function (value, index) {
					if (match[index] === undefined) {
						match[index] = value;
					}
				});
			}
			result = new Date(match[0] || 1970, match[1] || 0, match[2] || 1, match[3] || 0, match[4] || 0, match[5] || 0, match[6] || 0);
			if (match[0] < 100) {
				result.setFullYear(match[0] || 1970);
			}
			var offset = 0, zoneSign = match[7] && match[7].charAt(0);
			if (zoneSign != "Z") {
				offset = ((match[8] || 0) * 60) + (Number(match[9]) || 0);
				if (zoneSign != "-") {
					offset *= -1;
				}
			}
			if (zoneSign) {
				offset -= result.getTimezoneOffset();
			}
			if (offset) {
				result.setTime(result.getTime() + offset * 60000);
			}
		}
		return result;
	};
	dojo.date.stamp.toISOString = function (dateObject, options) {
		var _ = function (n) {
			return (n < 10) ? "0" + n : n;
		};
		options = options || {};
		var formattedDate = [], getter = options.zulu ? "getUTC" : "get", date = "";
		if (options.selector != "time") {
			var year = dateObject[getter + "FullYear"]();
			date = ["0000".substr((year + "").length) + year, _(dateObject[getter + "Month"]() + 1), _(dateObject[getter + "Date"]())].join("-");
		}
		formattedDate.push(date);
		if (options.selector != "date") {
			var time = [_(dateObject[getter + "Hours"]()), _(dateObject[getter + "Minutes"]()), _(dateObject[getter + "Seconds"]())].join(":");
			var millis = dateObject[getter + "Milliseconds"]();
			if (options.milliseconds) {
				time += "." + (millis < 100 ? "0" : "") + _(millis);
			}
			if (options.zulu) {
				time += "Z";
			} else {
				if (options.selector != "time") {
					var timezoneOffset = dateObject.getTimezoneOffset();
					var absOffset = Math.abs(timezoneOffset);
					time += (timezoneOffset > 0 ? "-" : "+") + _(Math.floor(absOffset / 60)) + ":" + _(absOffset % 60);
				}
			}
			formattedDate.push(time);
		}
		return formattedDate.join("T");
	};
}
if (!dojo._hasResource["dojo.parser"]) {
	dojo._hasResource["dojo.parser"] = true;
	dojo.provide("dojo.parser");
	dojo.parser = new function () {
		var d = dojo;
		this._attrName = d._scopeName + "Type";
		this._query = "[" + this._attrName + "]";
		function val2type(value) {
			if (d.isString(value)) {
				return "string";
			}
			if (typeof value == "number") {
				return "number";
			}
			if (typeof value == "boolean") {
				return "boolean";
			}
			if (d.isFunction(value)) {
				return "function";
			}
			if (d.isArray(value)) {
				return "array";
			}
			if (value instanceof Date) {
				return "date";
			}
			if (value instanceof d._Url) {
				return "url";
			}
			return "object";
		}
		function str2obj(value, type) {
			switch (type) {
			  case "string":
				return value;
			  case "number":
				return value.length ? Number(value) : NaN;
			  case "boolean":
				return typeof value == "boolean" ? value : !(value.toLowerCase() == "false");
			  case "function":
				if (d.isFunction(value)) {
					value = value.toString();
					value = d.trim(value.substring(value.indexOf("{") + 1, value.length - 1));
				}
				try {
					if (value.search(/[^\w\.]+/i) != -1) {
						return new Function(value);
					} else {
						return d.getObject(value, false);
					}
				}
				catch (e) {
					return new Function();
				}
			  case "array":
				return value ? value.split(/\s*,\s*/) : [];
			  case "date":
				switch (value) {
				  case "":
					return new Date("");
				  case "now":
					return new Date();
				  default:
					return d.date.stamp.fromISOString(value);
				}
			  case "url":
				return d.baseUrl + value;
			  default:
				return d.fromJson(value);
			}
		}
		var instanceClasses = {};
		dojo.connect(dojo, "extend", function () {
			instanceClasses = {};
		});
		function getClassInfo(className) {
			if (!instanceClasses[className]) {
				var cls = d.getObject(className);
				if (!d.isFunction(cls)) {
					throw new Error("Could not load class '" + className + "'. Did you spell the name correctly and use a full path, like 'dijit.form.Button'?");
				}
				var proto = cls.prototype;
				var params = {}, dummyClass = {};
				for (var name in proto) {
					if (name.charAt(0) == "_") {
						continue;
					}
					if (name in dummyClass) {
						continue;
					}
					var defVal = proto[name];
					params[name] = val2type(defVal);
				}
				instanceClasses[className] = {cls:cls, params:params};
			}
			return instanceClasses[className];
		}
		this._functionFromScript = function (script) {
			var preamble = "";
			var suffix = "";
			var argsStr = script.getAttribute("args");
			if (argsStr) {
				d.forEach(argsStr.split(/\s*,\s*/), function (part, idx) {
					preamble += "var " + part + " = arguments[" + idx + "]; ";
				});
			}
			var withStr = script.getAttribute("with");
			if (withStr && withStr.length) {
				d.forEach(withStr.split(/\s*,\s*/), function (part) {
					preamble += "with(" + part + "){";
					suffix += "}";
				});
			}
			return new Function(preamble + script.innerHTML + suffix);
		};
		this.instantiate = function (nodes, mixin, args) {
			var thelist = [], dp = dojo.parser;
			mixin = mixin || {};
			args = args || {};
			d.forEach(nodes, function (node) {
				if (!node) {
					return;
				}
				var type = dp._attrName in mixin ? mixin[dp._attrName] : node.getAttribute(dp._attrName);
				if (!type || !type.length) {
					return;
				}
				var clsInfo = getClassInfo(type), clazz = clsInfo.cls, ps = clazz._noScript || clazz.prototype._noScript;
				var params = {}, attributes = node.attributes;
				for (var name in clsInfo.params) {
					var item = name in mixin ? {value:mixin[name], specified:true} : attributes.getNamedItem(name);
					if (!item || (!item.specified && (!dojo.isIE || name.toLowerCase() != "value"))) {
						continue;
					}
					var value = item.value;
					switch (name) {
					  case "class":
						value = "className" in mixin ? mixin.className : node.className;
						break;
					  case "style":
						value = "style" in mixin ? mixin.style : (node.style && node.style.cssText);
					}
					var _type = clsInfo.params[name];
					if (typeof value == "string") {
						params[name] = str2obj(value, _type);
					} else {
						params[name] = value;
					}
				}
				if (!ps) {
					var connects = [], calls = [];
					d.query("> script[type^='dojo/']", node).orphan().forEach(function (script) {
						var event = script.getAttribute("event"), type = script.getAttribute("type"), nf = d.parser._functionFromScript(script);
						if (event) {
							if (type == "dojo/connect") {
								connects.push({event:event, func:nf});
							} else {
								params[event] = nf;
							}
						} else {
							calls.push(nf);
						}
					});
				}
				var markupFactory = clazz.markupFactory || clazz.prototype && clazz.prototype.markupFactory;
				var instance = markupFactory ? markupFactory(params, node, clazz) : new clazz(params, node);
				thelist.push(instance);
				var jsname = node.getAttribute("jsId");
				if (jsname) {
					d.setObject(jsname, instance);
				}
				if (!ps) {
					d.forEach(connects, function (connect) {
						d.connect(instance, connect.event, null, connect.func);
					});
					d.forEach(calls, function (func) {
						func.call(instance);
					});
				}
			});
			if (!mixin._started) {
				d.forEach(thelist, function (instance) {
					if (!args.noStart && instance && instance.startup && !instance._started && (!instance.getParent || !instance.getParent())) {
						instance.startup();
					}
				});
			}
			return thelist;
		};
		this.parse = function (rootNode, args) {
			var root;
			if (!args && rootNode && rootNode.rootNode) {
				args = rootNode;
				root = args.rootNode;
			} else {
				root = rootNode;
			}
			var list = d.query(this._query, root);
			return this.instantiate(list, null, args);
		};
	}();
	(function () {
		var parseRunner = function () {
			if (dojo.config.parseOnLoad) {
				dojo.parser.parse();
			}
		};
		if (dojo.exists("dijit.wai.onload") && (dijit.wai.onload === dojo._loaders[0])) {
			dojo._loaders.splice(1, 0, parseRunner);
		} else {
			dojo._loaders.unshift(parseRunner);
		}
	})();
}
if (!dojo._hasResource["dojo.cache"]) {
	dojo._hasResource["dojo.cache"] = true;
	dojo.provide("dojo.cache");
	(function () {
		var cache = {};
		dojo.cache = function (module, url, value) {
			if (typeof module == "string") {
				var pathObj = dojo.moduleUrl(module, url);
			} else {
				pathObj = module;
				value = url;
			}
			var key = pathObj.toString();
			var val = value;
			if (value !== undefined && !dojo.isString(value)) {
				val = ("value" in value ? value.value : undefined);
			}
			var sanitize = value && value.sanitize ? true : false;
			if (val || val === null) {
				if (val == null) {
					delete cache[key];
				} else {
					val = cache[key] = sanitize ? dojo.cache._sanitize(val) : val;
				}
			} else {
				if (!(key in cache)) {
					val = dojo._getText(key);
					cache[key] = sanitize ? dojo.cache._sanitize(val) : val;
				}
				val = cache[key];
			}
			return val;
		};
		dojo.cache._sanitize = function (val) {
			if (val) {
				val = val.replace(/^\s*<\?xml(\s)+version=[\'\"](\d)*.(\d)*[\'\"](\s)*\?>/im, "");
				var matches = val.match(/<body[^>]*>\s*([\s\S]+)\s*<\/body>/im);
				if (matches) {
					val = matches[1];
				}
			} else {
				val = "";
			}
			return val;
		};
	})();
}
if (!dojo._hasResource["dijit._Templated"]) {
	dojo._hasResource["dijit._Templated"] = true;
	dojo.provide("dijit._Templated");
	dojo.declare("dijit._Templated", null, {templateString:null, templatePath:null, widgetsInTemplate:false, _skipNodeCache:false, _earlyTemplatedStartup:false, constructor:function () {
		this._attachPoints = [];
	}, _stringRepl:function (tmpl) {
		var className = this.declaredClass, _this = this;
		return dojo.string.substitute(tmpl, this, function (value, key) {
			if (key.charAt(0) == "!") {
				value = dojo.getObject(key.substr(1), false, _this);
			}
			if (typeof value == "undefined") {
				throw new Error(className + " template:" + key);
			}
			if (value == null) {
				return "";
			}
			return key.charAt(0) == "!" ? value : value.toString().replace(/"/g, "&quot;");
		}, this);
	}, buildRendering:function () {
		var cached = dijit._Templated.getCachedTemplate(this.templatePath, this.templateString, this._skipNodeCache);
		var node;
		if (dojo.isString(cached)) {
			node = dojo._toDom(this._stringRepl(cached));
			if (node.nodeType != 1) {
				throw new Error("Invalid template: " + cached);
			}
		} else {
			node = cached.cloneNode(true);
		}
		this.domNode = node;
		this._attachTemplateNodes(node);
		if (this.widgetsInTemplate) {
			var parser = dojo.parser, qry, attr;
			if (parser._query != "[dojoType]") {
				qry = parser._query;
				attr = parser._attrName;
				parser._query = "[dojoType]";
				parser._attrName = "dojoType";
			}
			var cw = (this._startupWidgets = dojo.parser.parse(node, {noStart:!this._earlyTemplatedStartup}));
			if (qry) {
				parser._query = qry;
				parser._attrName = attr;
			}
			this._supportingWidgets = dijit.findWidgets(node);
			this._attachTemplateNodes(cw, function (n, p) {
				return n[p];
			});
		}
		this._fillContent(this.srcNodeRef);
	}, _fillContent:function (source) {
		var dest = this.containerNode;
		if (source && dest) {
			while (source.hasChildNodes()) {
				dest.appendChild(source.firstChild);
			}
		}
	}, _attachTemplateNodes:function (rootNode, getAttrFunc) {
		getAttrFunc = getAttrFunc || function (n, p) {
			return n.getAttribute(p);
		};
		var nodes = dojo.isArray(rootNode) ? rootNode : (rootNode.all || rootNode.getElementsByTagName("*"));
		var x = dojo.isArray(rootNode) ? 0 : -1;
		for (; x < nodes.length; x++) {
			var baseNode = (x == -1) ? rootNode : nodes[x];
			if (this.widgetsInTemplate && getAttrFunc(baseNode, "dojoType")) {
				continue;
			}
			var attachPoint = getAttrFunc(baseNode, "dojoAttachPoint");
			if (attachPoint) {
				var point, points = attachPoint.split(/\s*,\s*/);
				while ((point = points.shift())) {
					if (dojo.isArray(this[point])) {
						this[point].push(baseNode);
					} else {
						this[point] = baseNode;
					}
					this._attachPoints.push(point);
				}
			}
			var attachEvent = getAttrFunc(baseNode, "dojoAttachEvent");
			if (attachEvent) {
				var event, events = attachEvent.split(/\s*,\s*/);
				var trim = dojo.trim;
				while ((event = events.shift())) {
					if (event) {
						var thisFunc = null;
						if (event.indexOf(":") != -1) {
							var funcNameArr = event.split(":");
							event = trim(funcNameArr[0]);
							thisFunc = trim(funcNameArr[1]);
						} else {
							event = trim(event);
						}
						if (!thisFunc) {
							thisFunc = event;
						}
						this.connect(baseNode, event, thisFunc);
					}
				}
			}
			var role = getAttrFunc(baseNode, "waiRole");
			if (role) {
				dijit.setWaiRole(baseNode, role);
			}
			var values = getAttrFunc(baseNode, "waiState");
			if (values) {
				dojo.forEach(values.split(/\s*,\s*/), function (stateValue) {
					if (stateValue.indexOf("-") != -1) {
						var pair = stateValue.split("-");
						dijit.setWaiState(baseNode, pair[0], pair[1]);
					}
				});
			}
		}
	}, startup:function () {
		dojo.forEach(this._startupWidgets, function (w) {
			if (w && !w._started && w.startup) {
				w.startup();
			}
		});
		this.inherited(arguments);
	}, destroyRendering:function () {
		dojo.forEach(this._attachPoints, function (point) {
			delete this[point];
		}, this);
		this._attachPoints = [];
		this.inherited(arguments);
	}});
	dijit._Templated._templateCache = {};
	dijit._Templated.getCachedTemplate = function (templatePath, templateString, alwaysUseString) {
		var tmplts = dijit._Templated._templateCache;
		var key = templateString || templatePath;
		var cached = tmplts[key];
		if (cached) {
			try {
				if (!cached.ownerDocument || cached.ownerDocument == dojo.doc) {
					return cached;
				}
			}
			catch (e) {
			}
			dojo.destroy(cached);
		}
		if (!templateString) {
			templateString = dojo.cache(templatePath, {sanitize:true});
		}
		templateString = dojo.string.trim(templateString);
		if (alwaysUseString || templateString.match(/\$\{([^\}]+)\}/g)) {
			return (tmplts[key] = templateString);
		} else {
			var node = dojo._toDom(templateString);
			if (node.nodeType != 1) {
				throw new Error("Invalid template: " + templateString);
			}
			return (tmplts[key] = node);
		}
	};
	if (dojo.isIE) {
		dojo.addOnWindowUnload(function () {
			var cache = dijit._Templated._templateCache;
			for (var key in cache) {
				var value = cache[key];
				if (typeof value == "object") {
					dojo.destroy(value);
				}
				delete cache[key];
			}
		});
	}
	dojo.extend(dijit._Widget, {dojoAttachEvent:"", dojoAttachPoint:"", waiRole:"", waiState:""});
}
if (!dojo._hasResource["dojox.grid.compat._grid.drag"]) {
	dojo._hasResource["dojox.grid.compat._grid.drag"] = true;
	dojo.provide("dojox.grid.compat._grid.drag");
	(function () {
		var dgdrag = dojox.grid.drag = {};
		dgdrag.dragging = false;
		dgdrag.hysteresis = 2;
		dgdrag.capture = function (inElement) {
			if (inElement.setCapture) {
				inElement.setCapture();
			} else {
				document.addEventListener("mousemove", inElement.onmousemove, true);
				document.addEventListener("mouseup", inElement.onmouseup, true);
				document.addEventListener("click", inElement.onclick, true);
			}
		};
		dgdrag.release = function (inElement) {
			if (inElement.releaseCapture) {
				inElement.releaseCapture();
			} else {
				document.removeEventListener("click", inElement.onclick, true);
				document.removeEventListener("mouseup", inElement.onmouseup, true);
				document.removeEventListener("mousemove", inElement.onmousemove, true);
			}
		};
		dgdrag.start = function (inElement, inOnDrag, inOnEnd, inEvent, inOnStart) {
			if (!inElement || dgdrag.dragging) {
				console.debug("failed to start drag: bad input node or already dragging");
				return;
			}
			dgdrag.dragging = true;
			dgdrag.elt = inElement;
			dgdrag.events = {drag:inOnDrag || dojox.grid.nop, end:inOnEnd || dojox.grid.nop, start:inOnStart || dojox.grid.nop, oldmove:inElement.onmousemove, oldup:inElement.onmouseup, oldclick:inElement.onclick};
			dgdrag.positionX = (inEvent && ("screenX" in inEvent) ? inEvent.screenX : false);
			dgdrag.positionY = (inEvent && ("screenY" in inEvent) ? inEvent.screenY : false);
			dgdrag.started = (dgdrag.position === false);
			inElement.onmousemove = dgdrag.mousemove;
			inElement.onmouseup = dgdrag.mouseup;
			inElement.onclick = dgdrag.click;
			dgdrag.capture(dgdrag.elt);
		};
		dgdrag.end = function () {
			dgdrag.release(dgdrag.elt);
			dgdrag.elt.onmousemove = dgdrag.events.oldmove;
			dgdrag.elt.onmouseup = dgdrag.events.oldup;
			dgdrag.elt.onclick = dgdrag.events.oldclick;
			dgdrag.elt = null;
			try {
				if (dgdrag.started) {
					dgdrag.events.end();
				}
			}
			finally {
				dgdrag.dragging = false;
			}
		};
		dgdrag.calcDelta = function (inEvent) {
			inEvent.deltaX = inEvent.screenX - dgdrag.positionX;
			inEvent.deltaY = inEvent.screenY - dgdrag.positionY;
		};
		dgdrag.hasMoved = function (inEvent) {
			return Math.abs(inEvent.deltaX) + Math.abs(inEvent.deltaY) > dgdrag.hysteresis;
		};
		dgdrag.mousemove = function (inEvent) {
			inEvent = dojo.fixEvent(inEvent);
			dojo.stopEvent(inEvent);
			dgdrag.calcDelta(inEvent);
			if ((!dgdrag.started) && (dgdrag.hasMoved(inEvent))) {
				dgdrag.events.start(inEvent);
				dgdrag.started = true;
			}
			if (dgdrag.started) {
				dgdrag.events.drag(inEvent);
			}
		};
		dgdrag.mouseup = function (inEvent) {
			dojo.stopEvent(dojo.fixEvent(inEvent));
			dgdrag.end();
		};
		dgdrag.click = function (inEvent) {
			dojo.stopEvent(dojo.fixEvent(inEvent));
		};
	})();
}
if (!dojo._hasResource["dojox.grid.compat._grid.builder"]) {
	dojo._hasResource["dojox.grid.compat._grid.builder"] = true;
	dojo.provide("dojox.grid.compat._grid.builder");
	dojo.declare("dojox.grid.Builder", null, {constructor:function (inView) {
		this.view = inView;
		this.grid = inView.grid;
	}, view:null, _table:"<table class=\"dojoxGrid-row-table\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" role=\"wairole:presentation\">", generateCellMarkup:function (inCell, inMoreStyles, inMoreClasses, isHeader) {
		var result = [], html;
		if (isHeader) {
			html = ["<th tabIndex=\"-1\" role=\"wairole:columnheader\""];
		} else {
			html = ["<td tabIndex=\"-1\" role=\"wairole:gridcell\""];
		}
		inCell.colSpan && html.push(" colspan=\"", inCell.colSpan, "\"");
		inCell.rowSpan && html.push(" rowspan=\"", inCell.rowSpan, "\"");
		html.push(" class=\"dojoxGrid-cell ");
		inCell.classes && html.push(inCell.classes, " ");
		inMoreClasses && html.push(inMoreClasses, " ");
		result.push(html.join(""));
		result.push("");
		html = ["\" idx=\"", inCell.index, "\" style=\""];
		html.push(inCell.styles, inMoreStyles || "");
		inCell.unitWidth && html.push("width:", inCell.unitWidth, ";");
		result.push(html.join(""));
		result.push("");
		html = ["\""];
		inCell.attrs && html.push(" ", inCell.attrs);
		html.push(">");
		result.push(html.join(""));
		result.push("");
		result.push("</td>");
		return result;
	}, isCellNode:function (inNode) {
		return Boolean(inNode && inNode.getAttribute && inNode.getAttribute("idx"));
	}, getCellNodeIndex:function (inCellNode) {
		return inCellNode ? Number(inCellNode.getAttribute("idx")) : -1;
	}, getCellNode:function (inRowNode, inCellIndex) {
		for (var i = 0, row; row = dojox.grid.getTr(inRowNode.firstChild, i); i++) {
			for (var j = 0, cell; cell = row.cells[j]; j++) {
				if (this.getCellNodeIndex(cell) == inCellIndex) {
					return cell;
				}
			}
		}
	}, findCellTarget:function (inSourceNode, inTopNode) {
		var n = inSourceNode;
		while (n && (!this.isCellNode(n) || (n.offsetParent && dojox.grid.gridViewTag in n.offsetParent.parentNode && n.offsetParent.parentNode[dojox.grid.gridViewTag] != this.view.id)) && (n != inTopNode)) {
			n = n.parentNode;
		}
		return n != inTopNode ? n : null;
	}, baseDecorateEvent:function (e) {
		e.dispatch = "do" + e.type;
		e.grid = this.grid;
		e.sourceView = this.view;
		e.cellNode = this.findCellTarget(e.target, e.rowNode);
		e.cellIndex = this.getCellNodeIndex(e.cellNode);
		e.cell = (e.cellIndex >= 0 ? this.grid.getCell(e.cellIndex) : null);
	}, findTarget:function (inSource, inTag) {
		var n = inSource;
		while (n && (n != this.domNode) && (!(inTag in n) || (dojox.grid.gridViewTag in n && n[dojox.grid.gridViewTag] != this.view.id))) {
			n = n.parentNode;
		}
		return (n != this.domNode) ? n : null;
	}, findRowTarget:function (inSource) {
		return this.findTarget(inSource, dojox.grid.rowIndexTag);
	}, isIntraNodeEvent:function (e) {
		try {
			return (e.cellNode && e.relatedTarget && dojo.isDescendant(e.relatedTarget, e.cellNode));
		}
		catch (x) {
			return false;
		}
	}, isIntraRowEvent:function (e) {
		try {
			var row = e.relatedTarget && this.findRowTarget(e.relatedTarget);
			return !row && (e.rowIndex == -1) || row && (e.rowIndex == row.gridRowIndex);
		}
		catch (x) {
			return false;
		}
	}, dispatchEvent:function (e) {
		if (e.dispatch in this) {
			return this[e.dispatch](e);
		}
	}, domouseover:function (e) {
		if (e.cellNode && (e.cellNode != this.lastOverCellNode)) {
			this.lastOverCellNode = e.cellNode;
			this.grid.onMouseOver(e);
		}
		this.grid.onMouseOverRow(e);
	}, domouseout:function (e) {
		if (e.cellNode && (e.cellNode == this.lastOverCellNode) && !this.isIntraNodeEvent(e, this.lastOverCellNode)) {
			this.lastOverCellNode = null;
			this.grid.onMouseOut(e);
			if (!this.isIntraRowEvent(e)) {
				this.grid.onMouseOutRow(e);
			}
		}
	}, domousedown:function (e) {
		if (e.cellNode) {
			this.grid.onMouseDown(e);
		}
		this.grid.onMouseDownRow(e);
	}});
	dojo.declare("dojox.grid.contentBuilder", dojox.grid.Builder, {update:function () {
		this.prepareHtml();
	}, prepareHtml:function () {
		var defaultGet = this.grid.get, rows = this.view.structure.rows;
		for (var j = 0, row; (row = rows[j]); j++) {
			for (var i = 0, cell; (cell = row[i]); i++) {
				cell.get = cell.get || (cell.value == undefined) && defaultGet;
				cell.markup = this.generateCellMarkup(cell, cell.cellStyles, cell.cellClasses, false);
			}
		}
	}, generateHtml:function (inDataIndex, inRowIndex) {
		var html = [this._table], v = this.view, obr = v.onBeforeRow, rows = v.structure.rows;
		obr && obr(inRowIndex, rows);
		for (var j = 0, row; (row = rows[j]); j++) {
			if (row.hidden || row.header) {
				continue;
			}
			html.push(!row.invisible ? "<tr>" : "<tr class=\"dojoxGrid-invisible\">");
			for (var i = 0, cell, m, cc, cs; (cell = row[i]); i++) {
				m = cell.markup, cc = cell.customClasses = [], cs = cell.customStyles = [];
				m[5] = cell.format(inDataIndex);
				m[1] = cc.join(" ");
				m[3] = cs.join(";");
				html.push.apply(html, m);
			}
			html.push("</tr>");
		}
		html.push("</table>");
		return html.join("");
	}, decorateEvent:function (e) {
		e.rowNode = this.findRowTarget(e.target);
		if (!e.rowNode) {
			return false;
		}
		e.rowIndex = e.rowNode[dojox.grid.rowIndexTag];
		this.baseDecorateEvent(e);
		e.cell = this.grid.getCell(e.cellIndex);
		return true;
	}});
	dojo.declare("dojox.grid.headerBuilder", dojox.grid.Builder, {bogusClickTime:0, overResizeWidth:4, minColWidth:1, _table:"<table class=\"dojoxGrid-row-table\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" role=\"wairole:presentation\"", update:function () {
		this.tableMap = new dojox.grid.tableMap(this.view.structure.rows);
	}, generateHtml:function (inGetValue, inValue) {
		var html = [this._table], rows = this.view.structure.rows;
		if (this.view.viewWidth) {
			html.push([" style=\"width:", this.view.viewWidth, ";\""].join(""));
		}
		html.push(">");
		dojox.grid.fire(this.view, "onBeforeRow", [-1, rows]);
		for (var j = 0, row; (row = rows[j]); j++) {
			if (row.hidden) {
				continue;
			}
			html.push(!row.invisible ? "<tr>" : "<tr class=\"dojoxGrid-invisible\">");
			for (var i = 0, cell, markup; (cell = row[i]); i++) {
				cell.customClasses = [];
				cell.customStyles = [];
				markup = this.generateCellMarkup(cell, cell.headerStyles, cell.headerClasses, true);
				markup[5] = (inValue != undefined ? inValue : inGetValue(cell));
				markup[3] = cell.customStyles.join(";");
				markup[1] = cell.customClasses.join(" ");
				html.push(markup.join(""));
			}
			html.push("</tr>");
		}
		html.push("</table>");
		return html.join("");
	}, getCellX:function (e) {
		var x = e.layerX;
		if (dojo.isMoz) {
			var n = dojox.grid.ascendDom(e.target, dojox.grid.makeNotTagName("th"));
			x -= (n && n.offsetLeft) || 0;
			var t = e.sourceView.getScrollbarWidth();
			if (!dojo._isBodyLtr() && e.sourceView.headerNode.scrollLeft < t) {
				x -= t;
			}
		}
		var n = dojox.grid.ascendDom(e.target, function () {
			if (!n || n == e.cellNode) {
				return false;
			}
			x += (n.offsetLeft < 0 ? 0 : n.offsetLeft);
			return true;
		});
		return x;
	}, decorateEvent:function (e) {
		this.baseDecorateEvent(e);
		e.rowIndex = -1;
		e.cellX = this.getCellX(e);
		return true;
	}, prepareResize:function (e, mod) {
		var i = dojox.grid.getTdIndex(e.cellNode);
		e.cellNode = (i ? e.cellNode.parentNode.cells[i + mod] : null);
		e.cellIndex = (e.cellNode ? this.getCellNodeIndex(e.cellNode) : -1);
		return Boolean(e.cellNode);
	}, canResize:function (e) {
		if (!e.cellNode || e.cellNode.colSpan > 1) {
			return false;
		}
		var cell = this.grid.getCell(e.cellIndex);
		return !cell.noresize && !cell.isFlex();
	}, overLeftResizeArea:function (e) {
		if (dojo._isBodyLtr()) {
			return (e.cellIndex > 0) && (e.cellX < this.overResizeWidth) && this.prepareResize(e, -1);
		}
		var t = e.cellNode && (e.cellX < this.overResizeWidth);
		return;
	}, overRightResizeArea:function (e) {
		if (dojo._isBodyLtr()) {
			return e.cellNode && (e.cellX >= e.cellNode.offsetWidth - this.overResizeWidth);
		}
		return (e.cellIndex > 0) && (e.cellX >= e.cellNode.offsetWidth - this.overResizeWidth) && this.prepareResize(e, -1);
	}, domousemove:function (e) {
		var c = (this.overRightResizeArea(e) ? "e-resize" : (this.overLeftResizeArea(e) ? "w-resize" : ""));
		if (c && !this.canResize(e)) {
			c = "not-allowed";
		}
		e.sourceView.headerNode.style.cursor = c || "";
		if (c) {
			dojo.stopEvent(e);
		}
	}, domousedown:function (e) {
		if (!dojox.grid.drag.dragging) {
			if ((this.overRightResizeArea(e) || this.overLeftResizeArea(e)) && this.canResize(e)) {
				this.beginColumnResize(e);
			} else {
				this.grid.onMouseDown(e);
				this.grid.onMouseOverRow(e);
			}
		}
	}, doclick:function (e) {
		if (new Date().getTime() < this.bogusClickTime) {
			dojo.stopEvent(e);
			return true;
		}
	}, beginColumnResize:function (e) {
		dojo.stopEvent(e);
		var spanners = [], nodes = this.tableMap.findOverlappingNodes(e.cellNode);
		for (var i = 0, cell; (cell = nodes[i]); i++) {
			spanners.push({node:cell, index:this.getCellNodeIndex(cell), width:cell.offsetWidth});
		}
		var drag = {scrollLeft:e.sourceView.headerNode.scrollLeft, view:e.sourceView, node:e.cellNode, index:e.cellIndex, w:e.cellNode.clientWidth, spanners:spanners};
		dojox.grid.drag.start(e.cellNode, dojo.hitch(this, "doResizeColumn", drag), dojo.hitch(this, "endResizeColumn", drag), e);
	}, doResizeColumn:function (inDrag, inEvent) {
		var isLtr = dojo._isBodyLtr();
		if (isLtr) {
			var w = inDrag.w + inEvent.deltaX;
		} else {
			var w = inDrag.w - inEvent.deltaX;
		}
		if (w >= this.minColWidth) {
			for (var i = 0, s, sw; (s = inDrag.spanners[i]); i++) {
				if (isLtr) {
					sw = s.width + inEvent.deltaX;
				} else {
					sw = s.width - inEvent.deltaX;
				}
				s.node.style.width = sw + "px";
				inDrag.view.setColWidth(s.index, sw);
			}
			inDrag.node.style.width = w + "px";
			inDrag.view.setColWidth(inDrag.index, w);
			if (!isLtr) {
				inDrag.view.headerNode.scrollLeft = (inDrag.scrollLeft - inEvent.deltaX);
			}
		}
		if (inDrag.view.flexCells && !inDrag.view.testFlexCells()) {
			var t = dojox.grid.findTable(inDrag.node);
			t && (t.style.width = "");
		}
	}, endResizeColumn:function (inDrag) {
		this.bogusClickTime = new Date().getTime() + 30;
		setTimeout(dojo.hitch(inDrag.view, "update"), 50);
	}});
	dojo.declare("dojox.grid.tableMap", null, {constructor:function (inRows) {
		this.mapRows(inRows);
	}, map:null, mapRows:function (inRows) {
		var rowCount = inRows.length;
		if (!rowCount) {
			return;
		}
		this.map = [];
		for (var j = 0, row; (row = inRows[j]); j++) {
			this.map[j] = [];
		}
		for (var j = 0, row; (row = inRows[j]); j++) {
			for (var i = 0, x = 0, cell, colSpan, rowSpan; (cell = row[i]); i++) {
				while (this.map[j][x]) {
					x++;
				}
				this.map[j][x] = {c:i, r:j};
				rowSpan = cell.rowSpan || 1;
				colSpan = cell.colSpan || 1;
				for (var y = 0; y < rowSpan; y++) {
					for (var s = 0; s < colSpan; s++) {
						this.map[j + y][x + s] = this.map[j][x];
					}
				}
				x += colSpan;
			}
		}
	}, dumpMap:function () {
		for (var j = 0, row, h = ""; (row = this.map[j]); j++, h = "") {
			for (var i = 0, cell; (cell = row[i]); i++) {
				h += cell.r + "," + cell.c + "   ";
			}
			console.log(h);
		}
	}, getMapCoords:function (inRow, inCol) {
		for (var j = 0, row; (row = this.map[j]); j++) {
			for (var i = 0, cell; (cell = row[i]); i++) {
				if (cell.c == inCol && cell.r == inRow) {
					return {j:j, i:i};
				}
			}
		}
		return {j:-1, i:-1};
	}, getNode:function (inTable, inRow, inCol) {
		var row = inTable && inTable.rows[inRow];
		return row && row.cells[inCol];
	}, _findOverlappingNodes:function (inTable, inRow, inCol) {
		var nodes = [];
		var m = this.getMapCoords(inRow, inCol);
		var row = this.map[m.j];
		for (var j = 0, row; (row = this.map[j]); j++) {
			if (j == m.j) {
				continue;
			}
			with (row[m.i]) {
				var n = this.getNode(inTable, r, c);
				if (n) {
					nodes.push(n);
				}
			}
		}
		return nodes;
	}, findOverlappingNodes:function (inNode) {
		return this._findOverlappingNodes(dojox.grid.findTable(inNode), dojox.grid.getTrIndex(inNode.parentNode), dojox.grid.getTdIndex(inNode));
	}});
	dojox.grid.rowIndexTag = "gridRowIndex";
	dojox.grid.gridViewTag = "gridView";
}
if (!dojo._hasResource["dojox.grid.compat._grid.view"]) {
	dojo._hasResource["dojox.grid.compat._grid.view"] = true;
	dojo.provide("dojox.grid.compat._grid.view");
	dojo.declare("dojox.GridView", [dijit._Widget, dijit._Templated], {defaultWidth:"18em", viewWidth:"", templateString:"<div class=\"dojoxGrid-view\">\r\n\t<div class=\"dojoxGrid-header\" dojoAttachPoint=\"headerNode\">\r\n\t\t<div dojoAttachPoint=\"headerNodeContainer\" style=\"width:9000em\">\r\n\t\t\t<div dojoAttachPoint=\"headerContentNode\"></div>\r\n\t\t</div>\r\n\t</div>\r\n\t<input type=\"checkbox\" class=\"dojoxGrid-hidden-focus\" dojoAttachPoint=\"hiddenFocusNode\" />\r\n\t<input type=\"checkbox\" class=\"dojoxGrid-hidden-focus\" />\r\n\t<div class=\"dojoxGrid-scrollbox\" dojoAttachPoint=\"scrollboxNode\">\r\n\t\t<div class=\"dojoxGrid-content\" dojoAttachPoint=\"contentNode\" hidefocus=\"hidefocus\"></div>\r\n\t</div>\r\n</div>\r\n", themeable:false, classTag:"dojoxGrid", marginBottom:0, rowPad:2, postMixInProperties:function () {
		this.rowNodes = [];
	}, postCreate:function () {
		this.connect(this.scrollboxNode, "onscroll", "doscroll");
		dojox.grid.funnelEvents(this.contentNode, this, "doContentEvent", ["mouseover", "mouseout", "click", "dblclick", "contextmenu", "mousedown"]);
		dojox.grid.funnelEvents(this.headerNode, this, "doHeaderEvent", ["dblclick", "mouseover", "mouseout", "mousemove", "mousedown", "click", "contextmenu"]);
		this.content = new dojox.grid.contentBuilder(this);
		this.header = new dojox.grid.headerBuilder(this);
		if (!dojo._isBodyLtr()) {
			this.headerNodeContainer.style.width = "";
		}
	}, destroy:function () {
		dojox.grid.removeNode(this.headerNode);
		this.inherited("destroy", arguments);
	}, focus:function () {
		if (dojo.isWebKit || dojo.isOpera) {
			this.hiddenFocusNode.focus();
		} else {
			this.scrollboxNode.focus();
		}
	}, setStructure:function (inStructure) {
		var vs = (this.structure = inStructure);
		if (vs.width && !isNaN(vs.width)) {
			this.viewWidth = vs.width + "em";
		} else {
			this.viewWidth = vs.width || this.viewWidth;
		}
		this.onBeforeRow = vs.onBeforeRow;
		this.noscroll = vs.noscroll;
		if (this.noscroll) {
			this.scrollboxNode.style.overflow = "hidden";
		}
		this.testFlexCells();
		this.updateStructure();
	}, testFlexCells:function () {
		this.flexCells = false;
		for (var j = 0, row; (row = this.structure.rows[j]); j++) {
			for (var i = 0, cell; (cell = row[i]); i++) {
				cell.view = this;
				this.flexCells = this.flexCells || cell.isFlex();
			}
		}
		return this.flexCells;
	}, updateStructure:function () {
		this.header.update();
		this.content.update();
	}, getScrollbarWidth:function () {
		return (this.noscroll ? 0 : dojox.grid.getScrollbarWidth());
	}, getColumnsWidth:function () {
		return this.headerContentNode.firstChild.offsetWidth;
	}, getWidth:function () {
		return this.viewWidth || (this.getColumnsWidth() + this.getScrollbarWidth()) + "px";
	}, getContentWidth:function () {
		return Math.max(0, dojo._getContentBox(this.domNode).w - this.getScrollbarWidth()) + "px";
	}, render:function () {
		this.scrollboxNode.style.height = "";
		this.renderHeader();
	}, renderHeader:function () {
		this.headerContentNode.innerHTML = this.header.generateHtml(this._getHeaderContent);
	}, _getHeaderContent:function (inCell) {
		var n = inCell.name || inCell.grid.getCellName(inCell);
		if (inCell.index != inCell.grid.getSortIndex()) {
			return n;
		}
		return ["<div class=\"", inCell.grid.sortInfo > 0 ? "dojoxGrid-sort-down" : "dojoxGrid-sort-up", "\"><div class=\"gridArrowButtonChar\">", inCell.grid.sortInfo > 0 ? "&#9660;" : "&#9650;", "</div>", n, "</div>"].join("");
	}, resize:function () {
		this.adaptHeight();
		this.adaptWidth();
	}, hasScrollbar:function () {
		return (this.scrollboxNode.clientHeight != this.scrollboxNode.offsetHeight);
	}, adaptHeight:function () {
		if (!this.grid.autoHeight) {
			var h = this.domNode.clientHeight;
			if (!this.hasScrollbar()) {
				h -= dojox.grid.getScrollbarWidth();
			}
			dojox.grid.setStyleHeightPx(this.scrollboxNode, h);
		}
	}, adaptWidth:function () {
		if (this.flexCells) {
			this.contentWidth = this.getContentWidth();
			this.headerContentNode.firstChild.style.width = this.contentWidth;
		}
		var w = this.scrollboxNode.offsetWidth - this.getScrollbarWidth();
		w = Math.max(w, this.getColumnsWidth()) + "px";
		with (this.contentNode) {
			style.width = "";
			offsetWidth;
			style.width = w;
		}
	}, setSize:function (w, h) {
		with (this.domNode.style) {
			if (w) {
				width = w;
			}
			height = (h >= 0 ? h + "px" : "");
		}
		with (this.headerNode.style) {
			if (w) {
				width = w;
			}
		}
	}, renderRow:function (inRowIndex, inHeightPx) {
		var rowNode = this.createRowNode(inRowIndex);
		this.buildRow(inRowIndex, rowNode, inHeightPx);
		this.grid.edit.restore(this, inRowIndex);
		return rowNode;
	}, createRowNode:function (inRowIndex) {
		var node = document.createElement("div");
		node.className = this.classTag + "-row";
		node[dojox.grid.gridViewTag] = this.id;
		node[dojox.grid.rowIndexTag] = inRowIndex;
		this.rowNodes[inRowIndex] = node;
		return node;
	}, buildRow:function (inRowIndex, inRowNode) {
		this.buildRowContent(inRowIndex, inRowNode);
		this.styleRow(inRowIndex, inRowNode);
	}, buildRowContent:function (inRowIndex, inRowNode) {
		inRowNode.innerHTML = this.content.generateHtml(inRowIndex, inRowIndex);
		if (this.flexCells) {
			inRowNode.firstChild.style.width = this.contentWidth;
		}
	}, rowRemoved:function (inRowIndex) {
		this.grid.edit.save(this, inRowIndex);
		delete this.rowNodes[inRowIndex];
	}, getRowNode:function (inRowIndex) {
		return this.rowNodes[inRowIndex];
	}, getCellNode:function (inRowIndex, inCellIndex) {
		var row = this.getRowNode(inRowIndex);
		if (row) {
			return this.content.getCellNode(row, inCellIndex);
		}
	}, styleRow:function (inRowIndex, inRowNode) {
		inRowNode._style = dojox.grid.getStyleText(inRowNode);
		this.styleRowNode(inRowIndex, inRowNode);
	}, styleRowNode:function (inRowIndex, inRowNode) {
		if (inRowNode) {
			this.doStyleRowNode(inRowIndex, inRowNode);
		}
	}, doStyleRowNode:function (inRowIndex, inRowNode) {
		this.grid.styleRowNode(inRowIndex, inRowNode);
	}, updateRow:function (inRowIndex, inHeightPx, inPageNode) {
		var rowNode = this.getRowNode(inRowIndex);
		if (rowNode) {
			rowNode.style.height = "";
			this.buildRow(inRowIndex, rowNode);
		}
		return rowNode;
	}, updateRowStyles:function (inRowIndex) {
		this.styleRowNode(inRowIndex, this.getRowNode(inRowIndex));
	}, lastTop:0, firstScroll:0, doscroll:function (inEvent) {
		var isLtr = dojo._isBodyLtr();
		if (this.firstScroll < 2) {
			if ((!isLtr && this.firstScroll == 1) || (isLtr && this.firstScroll == 0)) {
				var s = dojo.marginBox(this.headerNodeContainer);
				if (dojo.isIE) {
					this.headerNodeContainer.style.width = s.w + this.getScrollbarWidth() + "px";
				} else {
					if (dojo.isMoz) {
						this.headerNodeContainer.style.width = s.w - this.getScrollbarWidth() + "px";
						if (!isLtr) {
							this.scrollboxNode.scrollLeft = this.scrollboxNode.scrollWidth - this.scrollboxNode.clientWidth;
						} else {
							this.scrollboxNode.scrollLeft = this.scrollboxNode.clientWidth - this.scrollboxNode.scrollWidth;
						}
					}
				}
			}
			this.firstScroll++;
		}
		this.headerNode.scrollLeft = this.scrollboxNode.scrollLeft;
		var top = this.scrollboxNode.scrollTop;
		if (top != this.lastTop) {
			this.grid.scrollTo(top);
		}
	}, setScrollTop:function (inTop) {
		this.lastTop = inTop;
		this.scrollboxNode.scrollTop = inTop;
		return this.scrollboxNode.scrollTop;
	}, doContentEvent:function (e) {
		if (this.content.decorateEvent(e)) {
			this.grid.onContentEvent(e);
		}
	}, doHeaderEvent:function (e) {
		if (this.header.decorateEvent(e)) {
			this.grid.onHeaderEvent(e);
		}
	}, dispatchContentEvent:function (e) {
		return this.content.dispatchEvent(e);
	}, dispatchHeaderEvent:function (e) {
		return this.header.dispatchEvent(e);
	}, setColWidth:function (inIndex, inWidth) {
		this.grid.setCellWidth(inIndex, inWidth + "px");
	}, update:function () {
		var left = this.scrollboxNode.scrollLeft;
		this.content.update();
		this.grid.update();
		this.scrollboxNode.scrollLeft = left;
		this.headerNode.scrollLeft = left;
	}});
}
if (!dojo._hasResource["dojox.grid.compat._grid.views"]) {
	dojo._hasResource["dojox.grid.compat._grid.views"] = true;
	dojo.provide("dojox.grid.compat._grid.views");
	dojo.declare("dojox.grid.views", null, {constructor:function (inGrid) {
		this.grid = inGrid;
	}, defaultWidth:200, views:[], resize:function () {
		this.onEach("resize");
	}, render:function () {
		this.onEach("render");
	}, addView:function (inView) {
		inView.idx = this.views.length;
		this.views.push(inView);
	}, destroyViews:function () {
		for (var i = 0, v; v = this.views[i]; i++) {
			v.destroy();
		}
		this.views = [];
	}, getContentNodes:function () {
		var nodes = [];
		for (var i = 0, v; v = this.views[i]; i++) {
			nodes.push(v.contentNode);
		}
		return nodes;
	}, forEach:function (inCallback) {
		for (var i = 0, v; v = this.views[i]; i++) {
			inCallback(v, i);
		}
	}, onEach:function (inMethod, inArgs) {
		inArgs = inArgs || [];
		for (var i = 0, v; v = this.views[i]; i++) {
			if (inMethod in v) {
				v[inMethod].apply(v, inArgs);
			}
		}
	}, normalizeHeaderNodeHeight:function () {
		var rowNodes = [];
		for (var i = 0, v; (v = this.views[i]); i++) {
			if (v.headerContentNode.firstChild) {
				rowNodes.push(v.headerContentNode);
			}
		}
		this.normalizeRowNodeHeights(rowNodes);
	}, normalizeRowNodeHeights:function (inRowNodes) {
		var h = 0;
		for (var i = 0, n, o; (n = inRowNodes[i]); i++) {
			h = Math.max(h, (n.firstChild.clientHeight) || (n.firstChild.offsetHeight));
		}
		h = (h >= 0 ? h : 0);
		var hpx = h + "px";
		for (var i = 0, n; (n = inRowNodes[i]); i++) {
			if (n.firstChild.clientHeight != h) {
				n.firstChild.style.height = hpx;
			}
		}
		if (inRowNodes && inRowNodes[0]) {
			inRowNodes[0].parentNode.offsetHeight;
		}
	}, resetHeaderNodeHeight:function () {
		for (var i = 0, v, n; (v = this.views[i]); i++) {
			n = v.headerContentNode.firstChild;
			if (n) {
				n.style.height = "";
			}
		}
	}, renormalizeRow:function (inRowIndex) {
		var rowNodes = [];
		for (var i = 0, v, n; (v = this.views[i]) && (n = v.getRowNode(inRowIndex)); i++) {
			n.firstChild.style.height = "";
			rowNodes.push(n);
		}
		this.normalizeRowNodeHeights(rowNodes);
	}, getViewWidth:function (inIndex) {
		return this.views[inIndex].getWidth() || this.defaultWidth;
	}, measureHeader:function () {
		this.resetHeaderNodeHeight();
		this.forEach(function (inView) {
			inView.headerContentNode.style.height = "";
		});
		var h = 0;
		this.forEach(function (inView) {
			h = Math.max(inView.headerNode.offsetHeight, h);
		});
		return h;
	}, measureContent:function () {
		var h = 0;
		this.forEach(function (inView) {
			h = Math.max(inView.domNode.offsetHeight, h);
		});
		return h;
	}, findClient:function (inAutoWidth) {
		var c = this.grid.elasticView || -1;
		if (c < 0) {
			for (var i = 1, v; (v = this.views[i]); i++) {
				if (v.viewWidth) {
					for (i = 1; (v = this.views[i]); i++) {
						if (!v.viewWidth) {
							c = i;
							break;
						}
					}
					break;
				}
			}
		}
		if (c < 0) {
			c = Math.floor(this.views.length / 2);
		}
		return c;
	}, arrange:function (l, w) {
		var i, v, vw, len = this.views.length;
		var c = (w <= 0 ? len : this.findClient());
		var setPosition = function (v, l) {
			with (v.domNode.style) {
				if (!dojo._isBodyLtr()) {
					right = l + "px";
				} else {
					left = l + "px";
				}
				top = 0 + "px";
			}
			with (v.headerNode.style) {
				if (!dojo._isBodyLtr()) {
					right = l + "px";
				} else {
					left = l + "px";
				}
				top = 0;
			}
		};
		for (i = 0; (v = this.views[i]) && (i < c); i++) {
			vw = this.getViewWidth(i);
			v.setSize(vw, 0);
			setPosition(v, l);
			vw = v.domNode.offsetWidth;
			l += vw;
		}
		i++;
		var r = w;
		for (var j = len - 1; (v = this.views[j]) && (i <= j); j--) {
			vw = this.getViewWidth(j);
			v.setSize(vw, 0);
			vw = v.domNode.offsetWidth;
			r -= vw;
			setPosition(v, r);
		}
		if (c < len) {
			v = this.views[c];
			vw = Math.max(1, r - l);
			v.setSize(vw + "px", 0);
			setPosition(v, l);
		}
		return l;
	}, renderRow:function (inRowIndex, inNodes) {
		var rowNodes = [];
		for (var i = 0, v, n, rowNode; (v = this.views[i]) && (n = inNodes[i]); i++) {
			rowNode = v.renderRow(inRowIndex);
			n.appendChild(rowNode);
			rowNodes.push(rowNode);
		}
		this.normalizeRowNodeHeights(rowNodes);
	}, rowRemoved:function (inRowIndex) {
		this.onEach("rowRemoved", [inRowIndex]);
	}, updateRow:function (inRowIndex, inHeight) {
		for (var i = 0, v; v = this.views[i]; i++) {
			v.updateRow(inRowIndex, inHeight);
		}
		this.renormalizeRow(inRowIndex);
	}, updateRowStyles:function (inRowIndex) {
		this.onEach("updateRowStyles", [inRowIndex]);
	}, setScrollTop:function (inTop) {
		var top = inTop;
		for (var i = 0, v; v = this.views[i]; i++) {
			top = v.setScrollTop(inTop);
		}
		return top;
	}, getFirstScrollingView:function () {
		for (var i = 0, v; (v = this.views[i]); i++) {
			if (v.hasScrollbar()) {
				return v;
			}
		}
	}});
}
if (!dojo._hasResource["dojox.grid.compat._grid.cell"]) {
	dojo._hasResource["dojox.grid.compat._grid.cell"] = true;
	dojo.provide("dojox.grid.compat._grid.cell");
	dojo.declare("dojox.grid.cell", null, {styles:"", constructor:function (inProps) {
		dojo.mixin(this, inProps);
		if (this.editor) {
			this.editor = new this.editor(this);
		}
	}, format:function (inRowIndex) {
		var f, i = this.grid.edit.info, d = this.get ? this.get(inRowIndex) : this.value;
		d = (d && d.replace) ? d.replace(/</g, "&lt;") : d;
		if (this.editor && (this.editor.alwaysOn || (i.rowIndex == inRowIndex && i.cell == this))) {
			return this.editor.format(d, inRowIndex);
		} else {
			return (f = this.formatter) ? f.call(this, d, inRowIndex) : d;
		}
	}, getNode:function (inRowIndex) {
		return this.view.getCellNode(inRowIndex, this.index);
	}, isFlex:function () {
		var uw = this.unitWidth;
		return uw && (uw == "auto" || uw.slice(-1) == "%");
	}, applyEdit:function (inValue, inRowIndex) {
		this.grid.edit.applyCellEdit(inValue, this, inRowIndex);
	}, cancelEdit:function (inRowIndex) {
		this.grid.doCancelEdit(inRowIndex);
	}, _onEditBlur:function (inRowIndex) {
		if (this.grid.edit.isEditCell(inRowIndex, this.index)) {
			this.grid.edit.apply();
		}
	}, registerOnBlur:function (inNode, inRowIndex) {
		if (this.commitOnBlur) {
			dojo.connect(inNode, "onblur", function (e) {
				setTimeout(dojo.hitch(this, "_onEditBlur", inRowIndex), 250);
			});
		}
	}});
}
if (!dojo._hasResource["dojox.grid.compat._grid.layout"]) {
	dojo._hasResource["dojox.grid.compat._grid.layout"] = true;
	dojo.provide("dojox.grid.compat._grid.layout");
	dojo.declare("dojox.grid.layout", null, {constructor:function (inGrid) {
		this.grid = inGrid;
	}, cells:[], structure:null, defaultWidth:"6em", setStructure:function (inStructure) {
		this.fieldIndex = 0;
		this.cells = [];
		var s = this.structure = [];
		for (var i = 0, viewDef, rows; (viewDef = inStructure[i]); i++) {
			s.push(this.addViewDef(viewDef));
		}
		this.cellCount = this.cells.length;
	}, addViewDef:function (inDef) {
		this._defaultCellProps = inDef.defaultCell || {};
		return dojo.mixin({}, inDef, {rows:this.addRowsDef(inDef.rows || inDef.cells)});
	}, addRowsDef:function (inDef) {
		var result = [];
		for (var i = 0, row; inDef && (row = inDef[i]); i++) {
			result.push(this.addRowDef(i, row));
		}
		return result;
	}, addRowDef:function (inRowIndex, inDef) {
		var result = [];
		for (var i = 0, def, cell; (def = inDef[i]); i++) {
			cell = this.addCellDef(inRowIndex, i, def);
			result.push(cell);
			this.cells.push(cell);
		}
		return result;
	}, addCellDef:function (inRowIndex, inCellIndex, inDef) {
		var w = 0;
		if (inDef.colSpan > 1) {
			w = 0;
		} else {
			if (!isNaN(inDef.width)) {
				w = inDef.width + "em";
			} else {
				w = inDef.width || this.defaultWidth;
			}
		}
		var fieldIndex = inDef.field != undefined ? inDef.field : (inDef.get ? -1 : this.fieldIndex);
		if ((inDef.field != undefined) || !inDef.get) {
			this.fieldIndex = (inDef.field > -1 ? inDef.field : this.fieldIndex) + 1;
		}
		return new dojox.grid.cell(dojo.mixin({}, this._defaultCellProps, inDef, {grid:this.grid, subrow:inRowIndex, layoutIndex:inCellIndex, index:this.cells.length, fieldIndex:fieldIndex, unitWidth:w}));
	}});
}
if (!dojo._hasResource["dojox.grid.compat._grid.rows"]) {
	dojo._hasResource["dojox.grid.compat._grid.rows"] = true;
	dojo.provide("dojox.grid.compat._grid.rows");
	dojo.declare("dojox.grid.rows", null, {constructor:function (inGrid) {
		this.grid = inGrid;
	}, linesToEms:2, defaultRowHeight:1, overRow:-2, getHeight:function (inRowIndex) {
		return "";
	}, getDefaultHeightPx:function () {
		return 32;
	}, prepareStylingRow:function (inRowIndex, inRowNode) {
		return {index:inRowIndex, node:inRowNode, odd:Boolean(inRowIndex & 1), selected:this.grid.selection.isSelected(inRowIndex), over:this.isOver(inRowIndex), customStyles:"", customClasses:"dojoxGrid-row"};
	}, styleRowNode:function (inRowIndex, inRowNode) {
		var row = this.prepareStylingRow(inRowIndex, inRowNode);
		this.grid.onStyleRow(row);
		this.applyStyles(row);
	}, applyStyles:function (inRow) {
		with (inRow) {
			node.className = customClasses;
			var h = node.style.height;
			dojox.grid.setStyleText(node, customStyles + ";" + (node._style || ""));
			node.style.height = h;
		}
	}, updateStyles:function (inRowIndex) {
		this.grid.updateRowStyles(inRowIndex);
	}, setOverRow:function (inRowIndex) {
		var last = this.overRow;
		this.overRow = inRowIndex;
		if ((last != this.overRow) && (last >= 0)) {
			this.updateStyles(last);
		}
		this.updateStyles(this.overRow);
	}, isOver:function (inRowIndex) {
		return (this.overRow == inRowIndex);
	}});
}
if (!dojo._hasResource["dojox.grid.compat._grid.focus"]) {
	dojo._hasResource["dojox.grid.compat._grid.focus"] = true;
	dojo.provide("dojox.grid.compat._grid.focus");
	dojo.declare("dojox.grid.focus", null, {constructor:function (inGrid) {
		this.grid = inGrid;
		this.cell = null;
		this.rowIndex = -1;
		dojo.connect(this.grid.domNode, "onfocus", this, "doFocus");
	}, tabbingOut:false, focusClass:"dojoxGrid-cell-focus", focusView:null, initFocusView:function () {
		this.focusView = this.grid.views.getFirstScrollingView();
	}, isFocusCell:function (inCell, inRowIndex) {
		return (this.cell == inCell) && (this.rowIndex == inRowIndex);
	}, isLastFocusCell:function () {
		return (this.rowIndex == this.grid.rowCount - 1) && (this.cell.index == this.grid.layout.cellCount - 1);
	}, isFirstFocusCell:function () {
		return (this.rowIndex == 0) && (this.cell.index == 0);
	}, isNoFocusCell:function () {
		return (this.rowIndex < 0) || !this.cell;
	}, _focusifyCellNode:function (inBork) {
		var n = this.cell && this.cell.getNode(this.rowIndex);
		if (n) {
			dojo.toggleClass(n, this.focusClass, inBork);
			if (inBork) {
				this.scrollIntoView();
				try {
					if (!this.grid.edit.isEditing()) {
						dojox.grid.fire(n, "focus");
					}
				}
				catch (e) {
				}
			}
		}
	}, scrollIntoView:function () {
		if (!this.cell) {
			return;
		}
		var c = this.cell, s = c.view.scrollboxNode, sr = {w:s.clientWidth, l:s.scrollLeft, t:s.scrollTop, h:s.clientHeight}, n = c.getNode(this.rowIndex), r = c.view.getRowNode(this.rowIndex), rt = this.grid.scroller.findScrollTop(this.rowIndex);
		if (n.offsetLeft + n.offsetWidth > sr.l + sr.w) {
			s.scrollLeft = n.offsetLeft + n.offsetWidth - sr.w;
		} else {
			if (n.offsetLeft < sr.l) {
				s.scrollLeft = n.offsetLeft;
			}
		}
		if (rt + r.offsetHeight > sr.t + sr.h) {
			this.grid.setScrollTop(rt + r.offsetHeight - sr.h);
		} else {
			if (rt < sr.t) {
				this.grid.setScrollTop(rt);
			}
		}
	}, styleRow:function (inRow) {
		return;
	}, setFocusIndex:function (inRowIndex, inCellIndex) {
		this.setFocusCell(this.grid.getCell(inCellIndex), inRowIndex);
	}, setFocusCell:function (inCell, inRowIndex) {
		if (inCell && !this.isFocusCell(inCell, inRowIndex)) {
			this.tabbingOut = false;
			this.focusGridView();
			this._focusifyCellNode(false);
			this.cell = inCell;
			this.rowIndex = inRowIndex;
			this._focusifyCellNode(true);
		}
		if (dojo.isOpera) {
			setTimeout(dojo.hitch(this.grid, "onCellFocus", this.cell, this.rowIndex), 1);
		} else {
			this.grid.onCellFocus(this.cell, this.rowIndex);
		}
	}, next:function () {
		var row = this.rowIndex, col = this.cell.index + 1, cc = this.grid.layout.cellCount - 1, rc = this.grid.rowCount - 1;
		if (col > cc) {
			col = 0;
			row++;
		}
		if (row > rc) {
			col = cc;
			row = rc;
		}
		this.setFocusIndex(row, col);
	}, previous:function () {
		var row = (this.rowIndex || 0), col = (this.cell.index || 0) - 1;
		if (col < 0) {
			col = this.grid.layout.cellCount - 1;
			row--;
		}
		if (row < 0) {
			row = 0;
			col = 0;
		}
		this.setFocusIndex(row, col);
	}, move:function (inRowDelta, inColDelta) {
		var rc = this.grid.rowCount - 1, cc = this.grid.layout.cellCount - 1, r = this.rowIndex, i = this.cell.index, row = Math.min(rc, Math.max(0, r + inRowDelta)), col = Math.min(cc, Math.max(0, i + inColDelta));
		this.setFocusIndex(row, col);
		if (inRowDelta) {
			this.grid.updateRow(r);
		}
	}, previousKey:function (e) {
		if (this.isFirstFocusCell()) {
			this.tabOut(this.grid.domNode);
		} else {
			dojo.stopEvent(e);
			this.previous();
		}
	}, nextKey:function (e) {
		if (this.isLastFocusCell()) {
			this.tabOut(this.grid.lastFocusNode);
		} else {
			dojo.stopEvent(e);
			this.next();
		}
	}, tabOut:function (inFocusNode) {
		this.tabbingOut = true;
		inFocusNode.focus();
	}, focusGridView:function () {
		dojox.grid.fire(this.focusView, "focus");
	}, focusGrid:function (inSkipFocusCell) {
		this.focusGridView();
		this._focusifyCellNode(true);
	}, doFocus:function (e) {
		if (e && e.target != e.currentTarget) {
			return;
		}
		if (!this.tabbingOut && this.isNoFocusCell()) {
			this.setFocusIndex(0, 0);
		}
		this.tabbingOut = false;
	}});
}
if (!dojo._hasResource["dojo.dnd.common"]) {
	dojo._hasResource["dojo.dnd.common"] = true;
	dojo.provide("dojo.dnd.common");
	dojo.dnd.getCopyKeyState = dojo.isCopyKey;
	dojo.dnd._uniqueId = 0;
	dojo.dnd.getUniqueId = function () {
		var id;
		do {
			id = dojo._scopeName + "Unique" + (++dojo.dnd._uniqueId);
		} while (dojo.byId(id));
		return id;
	};
	dojo.dnd._empty = {};
	dojo.dnd.isFormElement = function (e) {
		var t = e.target;
		if (t.nodeType == 3) {
			t = t.parentNode;
		}
		return " button textarea input select option ".indexOf(" " + t.tagName.toLowerCase() + " ") >= 0;
	};
}
if (!dojo._hasResource["dojox.grid.compat._grid.selection"]) {
	dojo._hasResource["dojox.grid.compat._grid.selection"] = true;
	dojo.provide("dojox.grid.compat._grid.selection");
	dojo.declare("dojox.grid.selection", null, {constructor:function (inGrid) {
		this.grid = inGrid;
		this.selected = [];
	}, multiSelect:true, selected:null, updating:0, selectedIndex:-1, onCanSelect:function (inIndex) {
		return this.grid.onCanSelect(inIndex);
	}, onCanDeselect:function (inIndex) {
		return this.grid.onCanDeselect(inIndex);
	}, onSelected:function (inIndex) {
		return this.grid.onSelected(inIndex);
	}, onDeselected:function (inIndex) {
		return this.grid.onDeselected(inIndex);
	}, onChanging:function () {
	}, onChanged:function () {
		return this.grid.onSelectionChanged();
	}, isSelected:function (inIndex) {
		return this.selected[inIndex];
	}, getFirstSelected:function () {
		for (var i = 0, l = this.selected.length; i < l; i++) {
			if (this.selected[i]) {
				return i;
			}
		}
		return -1;
	}, getNextSelected:function (inPrev) {
		for (var i = inPrev + 1, l = this.selected.length; i < l; i++) {
			if (this.selected[i]) {
				return i;
			}
		}
		return -1;
	}, getSelected:function () {
		var result = [];
		for (var i = 0, l = this.selected.length; i < l; i++) {
			if (this.selected[i]) {
				result.push(i);
			}
		}
		return result;
	}, getSelectedCount:function () {
		var c = 0;
		for (var i = 0; i < this.selected.length; i++) {
			if (this.selected[i]) {
				c++;
			}
		}
		return c;
	}, beginUpdate:function () {
		if (this.updating == 0) {
			this.onChanging();
		}
		this.updating++;
	}, endUpdate:function () {
		this.updating--;
		if (this.updating == 0) {
			this.onChanged();
		}
	}, select:function (inIndex) {
		this.unselectAll(inIndex);
		this.addToSelection(inIndex);
	}, addToSelection:function (inIndex) {
		inIndex = Number(inIndex);
		if (this.selected[inIndex]) {
			this.selectedIndex = inIndex;
		} else {
			if (this.onCanSelect(inIndex) !== false) {
				this.selectedIndex = inIndex;
				this.beginUpdate();
				this.selected[inIndex] = true;
				this.grid.onSelected(inIndex);
				this.endUpdate();
			}
		}
	}, deselect:function (inIndex) {
		inIndex = Number(inIndex);
		if (this.selectedIndex == inIndex) {
			this.selectedIndex = -1;
		}
		if (this.selected[inIndex]) {
			if (this.onCanDeselect(inIndex) === false) {
				return;
			}
			this.beginUpdate();
			delete this.selected[inIndex];
			this.grid.onDeselected(inIndex);
			this.endUpdate();
		}
	}, setSelected:function (inIndex, inSelect) {
		this[(inSelect ? "addToSelection" : "deselect")](inIndex);
	}, toggleSelect:function (inIndex) {
		this.setSelected(inIndex, !this.selected[inIndex]);
	}, insert:function (inIndex) {
		this.selected.splice(inIndex, 0, false);
		if (this.selectedIndex >= inIndex) {
			this.selectedIndex++;
		}
	}, remove:function (inIndex) {
		this.selected.splice(inIndex, 1);
		if (this.selectedIndex >= inIndex) {
			this.selectedIndex--;
		}
	}, unselectAll:function (inExcept) {
		for (var i in this.selected) {
			if ((i != inExcept) && (this.selected[i] === true)) {
				this.deselect(i);
			}
		}
	}, shiftSelect:function (inFrom, inTo) {
		var s = (inFrom >= 0 ? inFrom : inTo), e = inTo;
		if (s > e) {
			e = s;
			s = inTo;
		}
		for (var i = s; i <= e; i++) {
			this.addToSelection(i);
		}
	}, clickSelect:function (inIndex, inCtrlKey, inShiftKey) {
		this.beginUpdate();
		if (!this.multiSelect) {
			this.select(inIndex);
		} else {
			var lastSelected = this.selectedIndex;
			if (!inCtrlKey) {
				this.unselectAll(inIndex);
			}
			if (inShiftKey) {
				this.shiftSelect(lastSelected, inIndex);
			} else {
				if (inCtrlKey) {
					this.toggleSelect(inIndex);
				} else {
					this.addToSelection(inIndex);
				}
			}
		}
		this.endUpdate();
	}, clickSelectEvent:function (e) {
		this.clickSelect(e.rowIndex, dojo.dnd.getCopyKeyState(e), e.shiftKey);
	}, clear:function () {
		this.beginUpdate();
		this.unselectAll();
		this.endUpdate();
	}});
}
if (!dojo._hasResource["dojox.grid.compat._grid.edit"]) {
	dojo._hasResource["dojox.grid.compat._grid.edit"] = true;
	dojo.provide("dojox.grid.compat._grid.edit");
	dojo.declare("dojox.grid.edit", null, {constructor:function (inGrid) {
		this.grid = inGrid;
		this.connections = [];
		if (dojo.isIE) {
			this.connections.push(dojo.connect(document.body, "onfocus", dojo.hitch(this, "_boomerangFocus")));
		}
	}, info:{}, destroy:function () {
		dojo.forEach(this.connections, dojo.disconnect);
	}, cellFocus:function (inCell, inRowIndex) {
		if (this.grid.singleClickEdit || this.isEditRow(inRowIndex)) {
			this.setEditCell(inCell, inRowIndex);
		} else {
			this.apply();
		}
		if (this.isEditing() || (inCell && (inCell.editor || 0).alwaysOn)) {
			this._focusEditor(inCell, inRowIndex);
		}
	}, rowClick:function (e) {
		if (this.isEditing() && !this.isEditRow(e.rowIndex)) {
			this.apply();
		}
	}, styleRow:function (inRow) {
		if (inRow.index == this.info.rowIndex) {
			inRow.customClasses += " dojoxGrid-row-editing";
		}
	}, dispatchEvent:function (e) {
		var c = e.cell, ed = c && c.editor;
		return ed && ed.dispatchEvent(e.dispatch, e);
	}, isEditing:function () {
		return this.info.rowIndex !== undefined;
	}, isEditCell:function (inRowIndex, inCellIndex) {
		return (this.info.rowIndex === inRowIndex) && (this.info.cell.index == inCellIndex);
	}, isEditRow:function (inRowIndex) {
		return this.info.rowIndex === inRowIndex;
	}, setEditCell:function (inCell, inRowIndex) {
		if (!this.isEditCell(inRowIndex, inCell.index) && this.grid.canEdit(inCell, inRowIndex)) {
			this.start(inCell, inRowIndex, this.isEditRow(inRowIndex) || inCell.editor);
		}
	}, _focusEditor:function (inCell, inRowIndex) {
		dojox.grid.fire(inCell.editor, "focus", [inRowIndex]);
	}, focusEditor:function () {
		if (this.isEditing()) {
			this._focusEditor(this.info.cell, this.info.rowIndex);
		}
	}, _boomerangWindow:500, _shouldCatchBoomerang:function () {
		return this._catchBoomerang > new Date().getTime();
	}, _boomerangFocus:function () {
		if (this._shouldCatchBoomerang()) {
			this.grid.focus.focusGrid();
			this.focusEditor();
			this._catchBoomerang = 0;
		}
	}, _doCatchBoomerang:function () {
		if (dojo.isIE) {
			this._catchBoomerang = new Date().getTime() + this._boomerangWindow;
		}
	}, start:function (inCell, inRowIndex, inEditing) {
		this.grid.beginUpdate();
		this.editorApply();
		if (this.isEditing() && !this.isEditRow(inRowIndex)) {
			this.applyRowEdit();
			this.grid.updateRow(inRowIndex);
		}
		if (inEditing) {
			this.info = {cell:inCell, rowIndex:inRowIndex};
			this.grid.doStartEdit(inCell, inRowIndex);
			this.grid.updateRow(inRowIndex);
		} else {
			this.info = {};
		}
		this.grid.endUpdate();
		this.grid.focus.focusGrid();
		this._focusEditor(inCell, inRowIndex);
		this._doCatchBoomerang();
	}, _editorDo:function (inMethod) {
		var c = this.info.cell;
		c && c.editor && c.editor[inMethod](this.info.rowIndex);
	}, editorApply:function () {
		this._editorDo("apply");
	}, editorCancel:function () {
		this._editorDo("cancel");
	}, applyCellEdit:function (inValue, inCell, inRowIndex) {
		if (this.grid.canEdit(inCell, inRowIndex)) {
			this.grid.doApplyCellEdit(inValue, inRowIndex, inCell.fieldIndex);
		}
	}, applyRowEdit:function () {
		this.grid.doApplyEdit(this.info.rowIndex);
	}, apply:function () {
		if (this.isEditing()) {
			this.grid.beginUpdate();
			this.editorApply();
			this.applyRowEdit();
			this.info = {};
			this.grid.endUpdate();
			this.grid.focus.focusGrid();
			this._doCatchBoomerang();
		}
	}, cancel:function () {
		if (this.isEditing()) {
			this.grid.beginUpdate();
			this.editorCancel();
			this.info = {};
			this.grid.endUpdate();
			this.grid.focus.focusGrid();
			this._doCatchBoomerang();
		}
	}, save:function (inRowIndex, inView) {
		var c = this.info.cell;
		if (this.isEditRow(inRowIndex) && (!inView || c.view == inView) && c.editor) {
			c.editor.save(c, this.info.rowIndex);
		}
	}, restore:function (inView, inRowIndex) {
		var c = this.info.cell;
		if (this.isEditRow(inRowIndex) && c.view == inView && c.editor) {
			c.editor.restore(c, this.info.rowIndex);
		}
	}});
}
if (!dojo._hasResource["dojox.grid.compat._grid.rowbar"]) {
	dojo._hasResource["dojox.grid.compat._grid.rowbar"] = true;
	dojo.provide("dojox.grid.compat._grid.rowbar");
	dojo.declare("dojox.GridRowView", dojox.GridView, {defaultWidth:"3em", noscroll:true, padBorderWidth:2, buildRendering:function () {
		this.inherited("buildRendering", arguments);
		this.scrollboxNode.style.overflow = "hidden";
		this.headerNode.style.visibility = "hidden";
	}, getWidth:function () {
		return this.viewWidth || this.defaultWidth;
	}, buildRowContent:function (inRowIndex, inRowNode) {
		var w = this.contentNode.offsetWidth - this.padBorderWidth;
		inRowNode.innerHTML = "<table style=\"width:" + w + "px;\" role=\"wairole:presentation\"><tr><td class=\"dojoxGrid-rowbar-inner\"></td></tr></table>";
	}, renderHeader:function () {
	}, resize:function () {
		this.adaptHeight();
	}, adaptWidth:function () {
	}, doStyleRowNode:function (inRowIndex, inRowNode) {
		var n = ["dojoxGrid-rowbar"];
		if (this.grid.rows.isOver(inRowIndex)) {
			n.push("dojoxGrid-rowbar-over");
		}
		if (this.grid.selection.isSelected(inRowIndex)) {
			n.push("dojoxGrid-rowbar-selected");
		}
		inRowNode.className = n.join(" ");
	}, domouseover:function (e) {
		this.grid.onMouseOverRow(e);
	}, domouseout:function (e) {
		if (!this.isIntraRowEvent(e)) {
			this.grid.onMouseOutRow(e);
		}
	}});
}
if (!dojo._hasResource["dojox.grid.compat._grid.publicEvents"]) {
	dojo._hasResource["dojox.grid.compat._grid.publicEvents"] = true;
	dojo.provide("dojox.grid.compat._grid.publicEvents");
	dojox.grid.publicEvents = {cellOverClass:"dojoxGrid-cell-over", onKeyEvent:function (e) {
		this.dispatchKeyEvent(e);
	}, onContentEvent:function (e) {
		this.dispatchContentEvent(e);
	}, onHeaderEvent:function (e) {
		this.dispatchHeaderEvent(e);
	}, onStyleRow:function (inRow) {
		with (inRow) {
			customClasses += (odd ? " dojoxGrid-row-odd" : "") + (selected ? " dojoxGrid-row-selected" : "") + (over ? " dojoxGrid-row-over" : "");
		}
		this.focus.styleRow(inRow);
		this.edit.styleRow(inRow);
	}, onKeyDown:function (e) {
		if (e.altKey || e.ctrlKey || e.metaKey) {
			return;
		}
		var dk = dojo.keys;
		switch (e.keyCode) {
		  case dk.ESCAPE:
			this.edit.cancel();
			break;
		  case dk.ENTER:
			if (!e.shiftKey) {
				var isEditing = this.edit.isEditing();
				this.edit.apply();
				if (!isEditing) {
					this.edit.setEditCell(this.focus.cell, this.focus.rowIndex);
				}
			}
			break;
		  case dk.TAB:
			this.focus[e.shiftKey ? "previousKey" : "nextKey"](e);
			break;
		  case dk.LEFT_ARROW:
		  case dk.RIGHT_ARROW:
			if (!this.edit.isEditing()) {
				dojo.stopEvent(e);
				var offset = (e.keyCode == dk.LEFT_ARROW) ? 1 : -1;
				if (dojo._isBodyLtr()) {
					offset *= -1;
				}
				this.focus.move(0, offset);
			}
			break;
		  case dk.UP_ARROW:
			if (!this.edit.isEditing() && this.focus.rowIndex != 0) {
				dojo.stopEvent(e);
				this.focus.move(-1, 0);
			}
			break;
		  case dk.DOWN_ARROW:
			if (!this.edit.isEditing() && this.focus.rowIndex + 1 != this.model.count) {
				dojo.stopEvent(e);
				this.focus.move(1, 0);
			}
			break;
		  case dk.PAGE_UP:
			if (!this.edit.isEditing() && this.focus.rowIndex != 0) {
				dojo.stopEvent(e);
				if (this.focus.rowIndex != this.scroller.firstVisibleRow + 1) {
					this.focus.move(this.scroller.firstVisibleRow - this.focus.rowIndex, 0);
				} else {
					this.setScrollTop(this.scroller.findScrollTop(this.focus.rowIndex - 1));
					this.focus.move(this.scroller.firstVisibleRow - this.scroller.lastVisibleRow + 1, 0);
				}
			}
			break;
		  case dk.PAGE_DOWN:
			if (!this.edit.isEditing() && this.focus.rowIndex + 1 != this.model.count) {
				dojo.stopEvent(e);
				if (this.focus.rowIndex != this.scroller.lastVisibleRow - 1) {
					this.focus.move(this.scroller.lastVisibleRow - this.focus.rowIndex - 1, 0);
				} else {
					this.setScrollTop(this.scroller.findScrollTop(this.focus.rowIndex + 1));
					this.focus.move(this.scroller.lastVisibleRow - this.scroller.firstVisibleRow - 1, 0);
				}
			}
			break;
		}
	}, onMouseOver:function (e) {
		e.rowIndex == -1 ? this.onHeaderCellMouseOver(e) : this.onCellMouseOver(e);
	}, onMouseOut:function (e) {
		e.rowIndex == -1 ? this.onHeaderCellMouseOut(e) : this.onCellMouseOut(e);
	}, onMouseDown:function (e) {
		e.rowIndex == -1 ? this.onHeaderCellMouseDown(e) : this.onCellMouseDown(e);
	}, onMouseOverRow:function (e) {
		if (!this.rows.isOver(e.rowIndex)) {
			this.rows.setOverRow(e.rowIndex);
			e.rowIndex == -1 ? this.onHeaderMouseOver(e) : this.onRowMouseOver(e);
		}
	}, onMouseOutRow:function (e) {
		if (this.rows.isOver(-1)) {
			this.onHeaderMouseOut(e);
		} else {
			if (!this.rows.isOver(-2)) {
				this.rows.setOverRow(-2);
				this.onRowMouseOut(e);
			}
		}
	}, onMouseDownRow:function (e) {
		if (e.rowIndex != -1) {
			this.onRowMouseDown(e);
		}
	}, onCellMouseOver:function (e) {
		dojo.addClass(e.cellNode, this.cellOverClass);
	}, onCellMouseOut:function (e) {
		dojo.removeClass(e.cellNode, this.cellOverClass);
	}, onCellMouseDown:function (e) {
	}, onCellClick:function (e) {
		this._click[0] = this._click[1];
		this._click[1] = e;
		if (!this.edit.isEditCell(e.rowIndex, e.cellIndex)) {
			this.focus.setFocusCell(e.cell, e.rowIndex);
		}
		this.onRowClick(e);
	}, onCellDblClick:function (e) {
		if (dojo.isIE) {
			this.edit.setEditCell(this._click[1].cell, this._click[1].rowIndex);
		} else {
			if (this._click[0].rowIndex != this._click[1].rowIndex) {
				this.edit.setEditCell(this._click[0].cell, this._click[0].rowIndex);
			} else {
				this.edit.setEditCell(e.cell, e.rowIndex);
			}
		}
		this.onRowDblClick(e);
	}, onCellContextMenu:function (e) {
		this.onRowContextMenu(e);
	}, onCellFocus:function (inCell, inRowIndex) {
		this.edit.cellFocus(inCell, inRowIndex);
	}, onRowClick:function (e) {
		this.edit.rowClick(e);
		this.selection.clickSelectEvent(e);
	}, onRowDblClick:function (e) {
	}, onRowMouseOver:function (e) {
	}, onRowMouseOut:function (e) {
	}, onRowMouseDown:function (e) {
	}, onRowContextMenu:function (e) {
		dojo.stopEvent(e);
	}, onHeaderMouseOver:function (e) {
	}, onHeaderMouseOut:function (e) {
	}, onHeaderCellMouseOver:function (e) {
		dojo.addClass(e.cellNode, this.cellOverClass);
	}, onHeaderCellMouseOut:function (e) {
		dojo.removeClass(e.cellNode, this.cellOverClass);
	}, onHeaderCellMouseDown:function (e) {
	}, onHeaderClick:function (e) {
	}, onHeaderCellClick:function (e) {
		this.setSortIndex(e.cell.index);
		this.onHeaderClick(e);
	}, onHeaderDblClick:function (e) {
	}, onHeaderCellDblClick:function (e) {
		this.onHeaderDblClick(e);
	}, onHeaderCellContextMenu:function (e) {
		this.onHeaderContextMenu(e);
	}, onHeaderContextMenu:function (e) {
		dojo.stopEvent(e);
	}, onStartEdit:function (inCell, inRowIndex) {
	}, onApplyCellEdit:function (inValue, inRowIndex, inFieldIndex) {
	}, onCancelEdit:function (inRowIndex) {
	}, onApplyEdit:function (inRowIndex) {
	}, onCanSelect:function (inRowIndex) {
		return true;
	}, onCanDeselect:function (inRowIndex) {
		return true;
	}, onSelected:function (inRowIndex) {
		this.updateRowStyles(inRowIndex);
	}, onDeselected:function (inRowIndex) {
		this.updateRowStyles(inRowIndex);
	}, onSelectionChanged:function () {
	}};
}
if (!dojo._hasResource["dojox.grid.compat.VirtualGrid"]) {
	dojo._hasResource["dojox.grid.compat.VirtualGrid"] = true;
	dojo.provide("dojox.grid.compat.VirtualGrid");
	dojo.declare("dojox.VirtualGrid", [dijit._Widget, dijit._Templated], {templateString:"<div class=\"dojoxGrid\" hidefocus=\"hidefocus\" role=\"wairole:grid\">\r\n\t<div class=\"dojoxGrid-master-header\" dojoAttachPoint=\"viewsHeaderNode\"></div>\r\n\t<div class=\"dojoxGrid-master-view\" dojoAttachPoint=\"viewsNode\"></div>\r\n\t<span dojoAttachPoint=\"lastFocusNode\" tabindex=\"0\"></span>\r\n</div>\r\n", classTag:"dojoxGrid", get:function (inRowIndex) {
	}, rowCount:5, keepRows:75, rowsPerPage:25, autoWidth:false, autoHeight:false, autoRender:true, defaultHeight:"15em", structure:"", elasticView:-1, singleClickEdit:false, _click:null, sortInfo:0, themeable:true, buildRendering:function () {
		this.inherited(arguments);
		if (this.get == dojox.VirtualGrid.prototype.get) {
			this.get = null;
		}
		if (!this.domNode.getAttribute("tabIndex")) {
			this.domNode.tabIndex = "0";
		}
		this.createScroller();
		this.createLayout();
		this.createViews();
		this.createManagers();
		dojox.grid.initTextSizePoll();
		this.connect(dojox.grid, "textSizeChanged", "textSizeChanged");
		dojox.grid.funnelEvents(this.domNode, this, "doKeyEvent", dojox.grid.keyEvents);
		this.connect(this, "onShow", "renderOnIdle");
	}, postCreate:function () {
		this.styleChanged = this._styleChanged;
		this.setStructure(this.structure);
		this._click = [];
	}, destroy:function () {
		if (this.domNode) {
			this.domNode.onReveal = null;
			this.domNode.onSizeChange = null;
		}
		this.edit.destroy();
		this.views.destroyViews();
		this.inherited(arguments);
	}, styleChanged:function () {
		this.setStyledClass(this.domNode, "");
	}, _styleChanged:function () {
		this.styleChanged();
		this.update();
	}, textSizeChanged:function () {
		setTimeout(dojo.hitch(this, "_textSizeChanged"), 1);
	}, _textSizeChanged:function () {
		if (this.domNode) {
			this.views.forEach(function (v) {
				v.content.update();
			});
			this.render();
		}
	}, sizeChange:function () {
		dojox.grid.jobs.job(this.id + "SizeChange", 50, dojo.hitch(this, "update"));
	}, renderOnIdle:function () {
		setTimeout(dojo.hitch(this, "render"), 1);
	}, createManagers:function () {
		this.rows = new dojox.grid.rows(this);
		this.focus = new dojox.grid.focus(this);
		this.selection = new dojox.grid.selection(this);
		this.edit = new dojox.grid.edit(this);
	}, createScroller:function () {
		this.scroller = new dojox.grid.scroller.columns();
		this.scroller._pageIdPrefix = this.id + "-";
		this.scroller.renderRow = dojo.hitch(this, "renderRow");
		this.scroller.removeRow = dojo.hitch(this, "rowRemoved");
	}, createLayout:function () {
		this.layout = new dojox.grid.layout(this);
	}, createViews:function () {
		this.views = new dojox.grid.views(this);
		this.views.createView = dojo.hitch(this, "createView");
	}, createView:function (inClass) {
		if (dojo.isAIR) {
			var obj = window;
			var names = inClass.split(".");
			for (var i = 0; i < names.length; i++) {
				if (typeof obj[names[i]] == "undefined") {
					var undefstring = names[0];
					for (var j = 1; j <= i; j++) {
						undefstring += "." + names[j];
					}
					throw new Error(undefstring + " is undefined");
				}
				obj = obj[names[i]];
			}
			var c = obj;
		} else {
			var c = eval(inClass);
		}
		var view = new c({grid:this});
		this.viewsNode.appendChild(view.domNode);
		this.viewsHeaderNode.appendChild(view.headerNode);
		this.views.addView(view);
		return view;
	}, buildViews:function () {
		for (var i = 0, vs; (vs = this.layout.structure[i]); i++) {
			this.createView(vs.type || dojox._scopeName + ".GridView").setStructure(vs);
		}
		this.scroller.setContentNodes(this.views.getContentNodes());
	}, setStructure:function (inStructure) {
		this.views.destroyViews();
		this.structure = inStructure;
		if ((this.structure) && (dojo.isString(this.structure))) {
			this.structure = dojox.grid.getProp(this.structure);
		}
		if (!this.structure) {
			this.structure = window["layout"];
		}
		if (!this.structure) {
			return;
		}
		this.layout.setStructure(this.structure);
		this._structureChanged();
	}, _structureChanged:function () {
		this.buildViews();
		if (this.autoRender) {
			this.render();
		}
	}, hasLayout:function () {
		return this.layout.cells.length;
	}, resize:function (sizeBox) {
		this._sizeBox = sizeBox;
		this._resize();
		this.sizeChange();
	}, _getPadBorder:function () {
		this._padBorder = this._padBorder || dojo._getPadBorderExtents(this.domNode);
		return this._padBorder;
	}, _resize:function () {
		if (!this.domNode.parentNode || this.domNode.parentNode.nodeType != 1 || !this.hasLayout()) {
			return;
		}
		var padBorder = this._getPadBorder();
		if (this.autoHeight) {
			this.domNode.style.height = "auto";
			this.viewsNode.style.height = "";
		} else {
			if (this.flex > 0) {
			} else {
				if (this.domNode.clientHeight <= padBorder.h) {
					if (this.domNode.parentNode == document.body) {
						this.domNode.style.height = this.defaultHeight;
					} else {
						this.fitTo = "parent";
					}
				}
			}
		}
		if (this._sizeBox) {
			dojo.contentBox(this.domNode, this._sizeBox);
		} else {
			if (this.fitTo == "parent") {
				var h = dojo._getContentBox(this.domNode.parentNode).h;
				dojo.marginBox(this.domNode, {h:Math.max(0, h)});
			}
		}
		var h = dojo._getContentBox(this.domNode).h;
		if (h == 0 && !this.autoHeight) {
			this.viewsHeaderNode.style.display = "none";
		} else {
			this.viewsHeaderNode.style.display = "block";
		}
		this.adaptWidth();
		this.adaptHeight();
		this.scroller.defaultRowHeight = this.rows.getDefaultHeightPx() + 1;
		this.postresize();
	}, adaptWidth:function () {
		var w = this.autoWidth ? 0 : this.domNode.clientWidth || (this.domNode.offsetWidth - this._getPadBorder().w);
		var vw = this.views.arrange(1, w);
		this.views.onEach("adaptWidth");
		if (this.autoWidth) {
			this.domNode.style.width = vw + "px";
		}
	}, adaptHeight:function () {
		var vns = this.viewsHeaderNode.style, t = vns.display == "none" ? 0 : this.views.measureHeader();
		vns.height = t + "px";
		this.views.normalizeHeaderNodeHeight();
		var h = (this.autoHeight ? -1 : Math.max(this.domNode.clientHeight - t, 0) || 0);
		this.views.onEach("setSize", [0, h]);
		this.views.onEach("adaptHeight");
		this.scroller.windowHeight = h;
	}, render:function () {
		if (!this.domNode) {
			return;
		}
		if (!this.hasLayout()) {
			this.scroller.init(0, this.keepRows, this.rowsPerPage);
			return;
		}
		this.update = this.defaultUpdate;
		this.scroller.init(this.rowCount, this.keepRows, this.rowsPerPage);
		this.prerender();
		this.setScrollTop(0);
		this.postrender();
	}, prerender:function () {
		this.keepRows = this.autoHeight ? 0 : this.constructor.prototype.keepRows;
		this.scroller.setKeepInfo(this.keepRows);
		this.views.render();
		this._resize();
	}, postrender:function () {
		this.postresize();
		this.focus.initFocusView();
		dojo.setSelectable(this.domNode, false);
	}, postresize:function () {
		if (this.autoHeight) {
			this.viewsNode.style.height = this.views.measureContent() + "px";
		}
	}, renderRow:function (inRowIndex, inNodes) {
		this.views.renderRow(inRowIndex, inNodes);
	}, rowRemoved:function (inRowIndex) {
		this.views.rowRemoved(inRowIndex);
	}, invalidated:null, updating:false, beginUpdate:function () {
		if (this.invalidated == null) {
			this.invalidated = {rows:[], count:1, all:false, rowCount:undefined};
		} else {
			this.invalidated.count++;
		}
		this.updating = true;
	}, endUpdate:function () {
		var i = this.invalidated;
		if (--i.count === 0) {
			this.updating = false;
			if (i.rows.length > 0) {
				for (var r in i.rows) {
					this.updateRow(Number(r));
				}
				this.invalidated.rows = [];
			}
			if (i.rowCount != undefined) {
				this.updateRowCount(i.rowCount);
				i.rowCount = undefined;
			}
			if (i.all) {
				this.update();
				i.all = false;
			}
		}
	}, defaultUpdate:function () {
		if (!this.domNode) {
			return;
		}
		if (this.updating) {
			this.invalidated.all = true;
			return;
		}
		this.prerender();
		this.scroller.invalidateNodes();
		this.setScrollTop(this.scrollTop);
		this.postrender();
	}, update:function () {
		this.render();
	}, updateRow:function (inRowIndex) {
		inRowIndex = Number(inRowIndex);
		if (this.updating) {
			this.invalidated.rows[inRowIndex] = true;
		} else {
			this.views.updateRow(inRowIndex, this.rows.getHeight(inRowIndex));
			this.scroller.rowHeightChanged(inRowIndex);
		}
	}, updateRowCount:function (inRowCount) {
		if (this.updating) {
			this.invalidated.rowCount = inRowCount;
		} else {
			this.rowCount = inRowCount;
			if (this.layout.cells.length) {
				this.scroller.updateRowCount(inRowCount);
				this.setScrollTop(this.scrollTop);
			}
			this._resize();
		}
	}, updateRowStyles:function (inRowIndex) {
		this.views.updateRowStyles(inRowIndex);
	}, rowHeightChanged:function (inRowIndex) {
		this.views.renormalizeRow(inRowIndex);
		this.scroller.rowHeightChanged(inRowIndex);
	}, fastScroll:true, delayScroll:false, scrollRedrawThreshold:(dojo.isIE ? 100 : 50), scrollTo:function (inTop) {
		if (!this.fastScroll) {
			this.setScrollTop(inTop);
			return;
		}
		var delta = Math.abs(this.lastScrollTop - inTop);
		this.lastScrollTop = inTop;
		if (delta > this.scrollRedrawThreshold || this.delayScroll) {
			this.delayScroll = true;
			this.scrollTop = inTop;
			this.views.setScrollTop(inTop);
			dojox.grid.jobs.job("dojoxGrid-scroll", 200, dojo.hitch(this, "finishScrollJob"));
		} else {
			this.setScrollTop(inTop);
		}
	}, finishScrollJob:function () {
		this.delayScroll = false;
		this.setScrollTop(this.scrollTop);
	}, setScrollTop:function (inTop) {
		this.scrollTop = this.views.setScrollTop(inTop);
		this.scroller.scroll(this.scrollTop);
	}, scrollToRow:function (inRowIndex) {
		this.setScrollTop(this.scroller.findScrollTop(inRowIndex) + 1);
	}, styleRowNode:function (inRowIndex, inRowNode) {
		if (inRowNode) {
			this.rows.styleRowNode(inRowIndex, inRowNode);
		}
	}, getCell:function (inIndex) {
		return this.layout.cells[inIndex];
	}, setCellWidth:function (inIndex, inUnitWidth) {
		this.getCell(inIndex).unitWidth = inUnitWidth;
	}, getCellName:function (inCell) {
		return "Cell " + inCell.index;
	}, canSort:function (inSortInfo) {
	}, sort:function () {
	}, getSortAsc:function (inSortInfo) {
		inSortInfo = inSortInfo == undefined ? this.sortInfo : inSortInfo;
		return Boolean(inSortInfo > 0);
	}, getSortIndex:function (inSortInfo) {
		inSortInfo = inSortInfo == undefined ? this.sortInfo : inSortInfo;
		return Math.abs(inSortInfo) - 1;
	}, setSortIndex:function (inIndex, inAsc) {
		var si = inIndex + 1;
		if (inAsc != undefined) {
			si *= (inAsc ? 1 : -1);
		} else {
			if (this.getSortIndex() == inIndex) {
				si = -this.sortInfo;
			}
		}
		this.setSortInfo(si);
	}, setSortInfo:function (inSortInfo) {
		if (this.canSort(inSortInfo)) {
			this.sortInfo = inSortInfo;
			this.sort();
			this.update();
		}
	}, doKeyEvent:function (e) {
		e.dispatch = "do" + e.type;
		this.onKeyEvent(e);
	}, _dispatch:function (m, e) {
		if (m in this) {
			return this[m](e);
		}
	}, dispatchKeyEvent:function (e) {
		this._dispatch(e.dispatch, e);
	}, dispatchContentEvent:function (e) {
		this.edit.dispatchEvent(e) || e.sourceView.dispatchContentEvent(e) || this._dispatch(e.dispatch, e);
	}, dispatchHeaderEvent:function (e) {
		e.sourceView.dispatchHeaderEvent(e) || this._dispatch("doheader" + e.type, e);
	}, dokeydown:function (e) {
		this.onKeyDown(e);
	}, doclick:function (e) {
		if (e.cellNode) {
			this.onCellClick(e);
		} else {
			this.onRowClick(e);
		}
	}, dodblclick:function (e) {
		if (e.cellNode) {
			this.onCellDblClick(e);
		} else {
			this.onRowDblClick(e);
		}
	}, docontextmenu:function (e) {
		if (e.cellNode) {
			this.onCellContextMenu(e);
		} else {
			this.onRowContextMenu(e);
		}
	}, doheaderclick:function (e) {
		if (e.cellNode) {
			this.onHeaderCellClick(e);
		} else {
			this.onHeaderClick(e);
		}
	}, doheaderdblclick:function (e) {
		if (e.cellNode) {
			this.onHeaderCellDblClick(e);
		} else {
			this.onHeaderDblClick(e);
		}
	}, doheadercontextmenu:function (e) {
		if (e.cellNode) {
			this.onHeaderCellContextMenu(e);
		} else {
			this.onHeaderContextMenu(e);
		}
	}, doStartEdit:function (inCell, inRowIndex) {
		this.onStartEdit(inCell, inRowIndex);
	}, doApplyCellEdit:function (inValue, inRowIndex, inFieldIndex) {
		this.onApplyCellEdit(inValue, inRowIndex, inFieldIndex);
	}, doCancelEdit:function (inRowIndex) {
		this.onCancelEdit(inRowIndex);
	}, doApplyEdit:function (inRowIndex) {
		this.onApplyEdit(inRowIndex);
	}, addRow:function () {
		this.updateRowCount(this.rowCount + 1);
	}, removeSelectedRows:function () {
		this.updateRowCount(Math.max(0, this.rowCount - this.selection.getSelected().length));
		this.selection.clear();
	}});
	dojo.mixin(dojox.VirtualGrid.prototype, dojox.grid.publicEvents);
}
if (!dojo._hasResource["dojox.grid.compat._data.fields"]) {
	dojo._hasResource["dojox.grid.compat._data.fields"] = true;
	dojo.provide("dojox.grid.compat._data.fields");
	dojo.declare("dojox.grid.data.Mixer", null, {constructor:function () {
		this.defaultValue = {};
		this.values = [];
	}, count:function () {
		return this.values.length;
	}, clear:function () {
		this.values = [];
	}, build:function (inIndex) {
		var result = dojo.mixin({owner:this}, this.defaultValue);
		result.key = inIndex;
		this.values[inIndex] = result;
		return result;
	}, getDefault:function () {
		return this.defaultValue;
	}, setDefault:function (inField) {
		for (var i = 0, a; (a = arguments[i]); i++) {
			dojo.mixin(this.defaultValue, a);
		}
	}, get:function (inIndex) {
		return this.values[inIndex] || this.build(inIndex);
	}, _set:function (inIndex, inField) {
		var v = this.get(inIndex);
		for (var i = 1; i < arguments.length; i++) {
			dojo.mixin(v, arguments[i]);
		}
		this.values[inIndex] = v;
	}, set:function () {
		if (arguments.length < 1) {
			return;
		}
		var a = arguments[0];
		if (!dojo.isArray(a)) {
			this._set.apply(this, arguments);
		} else {
			if (a.length && a[0]["default"]) {
				this.setDefault(a.shift());
			}
			for (var i = 0, l = a.length; i < l; i++) {
				this._set(i, a[i]);
			}
		}
	}, insert:function (inIndex, inProps) {
		if (inIndex >= this.values.length) {
			this.values[inIndex] = inProps;
		} else {
			this.values.splice(inIndex, 0, inProps);
		}
	}, remove:function (inIndex) {
		this.values.splice(inIndex, 1);
	}, swap:function (inIndexA, inIndexB) {
		dojox.grid.arraySwap(this.values, inIndexA, inIndexB);
	}, move:function (inFromIndex, inToIndex) {
		dojox.grid.arrayMove(this.values, inFromIndex, inToIndex);
	}});
	dojox.grid.data.compare = function (a, b) {
		return (a > b ? 1 : (a == b ? 0 : -1));
	};
	dojo.declare("dojox.grid.data.Field", null, {constructor:function (inName) {
		this.name = inName;
		this.compare = dojox.grid.data.compare;
	}, na:dojox.grid.na});
	dojo.declare("dojox.grid.data.Fields", dojox.grid.data.Mixer, {constructor:function (inFieldClass) {
		var fieldClass = inFieldClass ? inFieldClass : dojox.grid.data.Field;
		this.defaultValue = new fieldClass();
	}, indexOf:function (inKey) {
		for (var i = 0; i < this.values.length; i++) {
			var v = this.values[i];
			if (v && v.key == inKey) {
				return i;
			}
		}
		return -1;
	}});
}
if (!dojo._hasResource["dojox.grid.compat._data.model"]) {
	dojo._hasResource["dojox.grid.compat._data.model"] = true;
	dojo.provide("dojox.grid.compat._data.model");
	dojo.declare("dojox.grid.data.Model", null, {constructor:function (inFields, inData) {
		this.observers = [];
		this.fields = new dojox.grid.data.Fields();
		if (inFields) {
			this.fields.set(inFields);
		}
		this.setData(inData);
	}, count:0, updating:0, observer:function (inObserver, inPrefix) {
		this.observers.push({o:inObserver, p:inPrefix || "model"});
	}, notObserver:function (inObserver) {
		for (var i = 0, m, o; (o = this.observers[i]); i++) {
			if (o.o == inObserver) {
				this.observers.splice(i, 1);
				return;
			}
		}
	}, notify:function (inMsg, inArgs) {
		var a = inArgs || [];
		for (var i = 0, m, o; (o = this.observers[i]); i++) {
			m = o.p + inMsg;
			o = o.o;
			(m in o) && (o[m].apply(o, a));
		}
	}, clear:function () {
		this.fields.clear();
		this.clearData();
	}, beginUpdate:function () {
		this.notify("BeginUpdate", arguments);
	}, endUpdate:function () {
		this.notify("EndUpdate", arguments);
	}, clearData:function () {
		this.setData(null);
	}, change:function () {
		this.notify("Change", arguments);
	}, insertion:function () {
		this.notify("Insertion", arguments);
		this.notify("Change", arguments);
	}, removal:function () {
		this.notify("Removal", arguments);
		this.notify("Change", arguments);
	}, insert:function (inData) {
		if (!this._insert.apply(this, arguments)) {
			return false;
		}
		this.insertion.apply(this, dojo._toArray(arguments, 1));
		return true;
	}, remove:function (inData) {
		if (!this._remove.apply(this, arguments)) {
			return false;
		}
		this.removal.apply(this, arguments);
		return true;
	}, canSort:function () {
		return this.sort != null;
	}, generateComparator:function (inCompare, inField, inTrueForAscend, inSubCompare) {
		return function (a, b) {
			var ineq = inCompare(a[inField], b[inField]);
			return ineq ? (inTrueForAscend ? ineq : -ineq) : inSubCompare && inSubCompare(a, b);
		};
	}, makeComparator:function (inIndices) {
		var idx, col, field, result = null;
		for (var i = inIndices.length - 1; i >= 0; i--) {
			idx = inIndices[i];
			col = Math.abs(idx) - 1;
			if (col >= 0) {
				field = this.fields.get(col);
				result = this.generateComparator(field.compare, field.key, idx > 0, result);
			}
		}
		return result;
	}, sort:null, dummy:0});
	dojo.declare("dojox.grid.data.Rows", dojox.grid.data.Model, {allChange:function () {
		this.notify("AllChange", arguments);
		this.notify("Change", arguments);
	}, rowChange:function () {
		this.notify("RowChange", arguments);
	}, datumChange:function () {
		this.notify("DatumChange", arguments);
	}, beginModifyRow:function (inRowIndex) {
		if (!this.cache[inRowIndex]) {
			this.cache[inRowIndex] = this.copyRow(inRowIndex);
		}
	}, endModifyRow:function (inRowIndex) {
		var cache = this.cache[inRowIndex];
		if (cache) {
			var data = this.getRow(inRowIndex);
			if (!dojox.grid.arrayCompare(cache, data)) {
				this.update(cache, data, inRowIndex);
			}
			delete this.cache[inRowIndex];
		}
	}, cancelModifyRow:function (inRowIndex) {
		var cache = this.cache[inRowIndex];
		if (cache) {
			this.setRow(cache, inRowIndex);
			delete this.cache[inRowIndex];
		}
	}});
	dojo.declare("dojox.grid.data.Table", dojox.grid.data.Rows, {constructor:function () {
		this.cache = [];
	}, colCount:0, data:null, cache:null, measure:function () {
		this.count = this.getRowCount();
		this.colCount = this.getColCount();
		this.allChange();
	}, getRowCount:function () {
		return (this.data ? this.data.length : 0);
	}, getColCount:function () {
		return (this.data && this.data.length ? this.data[0].length : this.fields.count());
	}, badIndex:function (inCaller, inDescriptor) {
		console.error("dojox.grid.data.Table: badIndex");
	}, isGoodIndex:function (inRowIndex, inColIndex) {
		return (inRowIndex >= 0 && inRowIndex < this.count && (arguments.length < 2 || (inColIndex >= 0 && inColIndex < this.colCount)));
	}, getRow:function (inRowIndex) {
		return this.data[inRowIndex];
	}, copyRow:function (inRowIndex) {
		return this.getRow(inRowIndex).slice(0);
	}, getDatum:function (inRowIndex, inColIndex) {
		return this.data[inRowIndex][inColIndex];
	}, get:function () {
		throw ("Plain \"get\" no longer supported. Use \"getRow\" or \"getDatum\".");
	}, setData:function (inData) {
		this.data = (inData || []);
		this.allChange();
	}, setRow:function (inData, inRowIndex) {
		this.data[inRowIndex] = inData;
		this.rowChange(inData, inRowIndex);
		this.change();
	}, setDatum:function (inDatum, inRowIndex, inColIndex) {
		this.data[inRowIndex][inColIndex] = inDatum;
		this.datumChange(inDatum, inRowIndex, inColIndex);
	}, set:function () {
		throw ("Plain \"set\" no longer supported. Use \"setData\", \"setRow\", or \"setDatum\".");
	}, setRows:function (inData, inRowIndex) {
		for (var i = 0, l = inData.length, r = inRowIndex; i < l; i++, r++) {
			this.setRow(inData[i], r);
		}
	}, update:function (inOldData, inNewData, inRowIndex) {
		return true;
	}, _insert:function (inData, inRowIndex) {
		dojox.grid.arrayInsert(this.data, inRowIndex, inData);
		this.count++;
		return true;
	}, _remove:function (inKeys) {
		for (var i = inKeys.length - 1; i >= 0; i--) {
			dojox.grid.arrayRemove(this.data, inKeys[i]);
		}
		this.count -= inKeys.length;
		return true;
	}, sort:function () {
		this.data.sort(this.makeComparator(arguments));
	}, swap:function (inIndexA, inIndexB) {
		dojox.grid.arraySwap(this.data, inIndexA, inIndexB);
		this.rowChange(this.getRow(inIndexA), inIndexA);
		this.rowChange(this.getRow(inIndexB), inIndexB);
		this.change();
	}, dummy:0});
	dojo.declare("dojox.grid.data.Objects", dojox.grid.data.Table, {constructor:function (inFields, inData, inKey) {
		if (!inFields) {
			this.autoAssignFields();
		}
	}, allChange:function () {
		this.notify("FieldsChange");
		this.inherited(arguments);
	}, autoAssignFields:function () {
		var d = this.data[0], i = 0, field;
		for (var f in d) {
			field = this.fields.get(i++);
			if (!dojo.isString(field.key)) {
				field.key = f;
			}
		}
	}, setData:function (inData) {
		this.data = (inData || []);
		this.autoAssignFields();
		this.allChange();
	}, getDatum:function (inRowIndex, inColIndex) {
		return this.data[inRowIndex][this.fields.get(inColIndex).key];
	}});
	dojo.declare("dojox.grid.data.Dynamic", dojox.grid.data.Table, {constructor:function () {
		this.page = [];
		this.pages = [];
	}, page:null, pages:null, rowsPerPage:100, requests:0, bop:-1, eop:-1, clearData:function () {
		this.pages = [];
		this.bop = this.eop = -1;
		this.setData([]);
	}, getRowCount:function () {
		return this.count;
	}, getColCount:function () {
		return this.fields.count();
	}, setRowCount:function (inCount) {
		this.count = inCount;
		this.change();
	}, requestsPending:function (inBoolean) {
	}, rowToPage:function (inRowIndex) {
		return (this.rowsPerPage ? Math.floor(inRowIndex / this.rowsPerPage) : inRowIndex);
	}, pageToRow:function (inPageIndex) {
		return (this.rowsPerPage ? this.rowsPerPage * inPageIndex : inPageIndex);
	}, requestRows:function (inRowIndex, inCount) {
	}, rowsProvided:function (inRowIndex, inCount) {
		this.requests--;
		if (this.requests == 0) {
			this.requestsPending(false);
		}
	}, requestPage:function (inPageIndex) {
		var row = this.pageToRow(inPageIndex);
		var count = Math.min(this.rowsPerPage, this.count - row);
		if (count > 0) {
			this.requests++;
			this.requestsPending(true);
			setTimeout(dojo.hitch(this, "requestRows", row, count), 1);
		}
	}, needPage:function (inPageIndex) {
		if (!this.pages[inPageIndex]) {
			this.pages[inPageIndex] = true;
			this.requestPage(inPageIndex);
		}
	}, preparePage:function (inRowIndex, inColIndex) {
		if (inRowIndex < this.bop || inRowIndex >= this.eop) {
			var pageIndex = this.rowToPage(inRowIndex);
			this.needPage(pageIndex);
			this.bop = pageIndex * this.rowsPerPage;
			this.eop = this.bop + (this.rowsPerPage || this.count);
		}
	}, isRowLoaded:function (inRowIndex) {
		return Boolean(this.data[inRowIndex]);
	}, removePages:function (inRowIndexes) {
		for (var i = 0, r; ((r = inRowIndexes[i]) != undefined); i++) {
			this.pages[this.rowToPage(r)] = false;
		}
		this.bop = this.eop = -1;
	}, remove:function (inRowIndexes) {
		this.removePages(inRowIndexes);
		dojox.grid.data.Table.prototype.remove.apply(this, arguments);
	}, getRow:function (inRowIndex) {
		var row = this.data[inRowIndex];
		if (!row) {
			this.preparePage(inRowIndex);
		}
		return row;
	}, getDatum:function (inRowIndex, inColIndex) {
		var row = this.getRow(inRowIndex);
		return (row ? row[inColIndex] : this.fields.get(inColIndex).na);
	}, setDatum:function (inDatum, inRowIndex, inColIndex) {
		var row = this.getRow(inRowIndex);
		if (row) {
			row[inColIndex] = inDatum;
			this.datumChange(inDatum, inRowIndex, inColIndex);
		} else {
			console.error("[" + this.declaredClass + "] dojox.grid.data.dynamic.set: cannot set data on a non-loaded row");
		}
	}, canSort:function () {
		return false;
	}});
	dojox.grid.data.table = dojox.grid.data.Table;
	dojox.grid.data.dynamic = dojox.grid.data.Dynamic;
	dojo.declare("dojox.grid.data.DojoData", dojox.grid.data.Dynamic, {constructor:function (inFields, inData, args) {
		this.count = 1;
		this._rowIdentities = {};
		this._currentlyProcessing = [];
		if (args) {
			dojo.mixin(this, args);
		}
		if (this.store) {
			var f = this.store.getFeatures();
			this._canNotify = f["dojo.data.api.Notification"];
			this._canWrite = f["dojo.data.api.Write"];
			this._canIdentify = f["dojo.data.api.Identity"];
			if (this._canNotify) {
				dojo.connect(this.store, "onSet", this, "_storeDatumChange");
				dojo.connect(this.store, "onDelete", this, "_storeDatumDelete");
				dojo.connect(this.store, "onNew", this, "_storeDatumNew");
			}
			if (this._canWrite) {
				dojo.connect(this.store, "revert", this, "refresh");
			}
		}
	}, markupFactory:function (args, node) {
		return new dojox.grid.data.DojoData(null, null, args);
	}, query:{name:"*"}, store:null, _currentlyProcessing:null, _canNotify:false, _canWrite:false, _canIdentify:false, _rowIdentities:{}, clientSort:false, sortFields:null, queryOptions:null, setData:function (inData) {
		this.store = inData;
		this.data = [];
		this.allChange();
	}, setRowCount:function (inCount) {
		this.count = inCount;
		this.allChange();
	}, beginReturn:function (inCount) {
		if (this.count != inCount) {
			this.setRowCount(inCount);
		}
	}, _setupFields:function (dataItem) {
		if (this.fields._nameMaps) {
			return;
		}
		var m = {};
		var fields = dojo.map(this.store.getAttributes(dataItem), function (item, idx) {
			m[item] = idx;
			m[idx + ".idx"] = item;
			return {name:item, key:item};
		}, this);
		this.fields._nameMaps = m;
		this.fields.set(fields);
		this.notify("FieldsChange");
	}, _getRowFromItem:function (item) {
	}, _createRow:function (item) {
		var row = {};
		row.__dojo_data_item = item;
		dojo.forEach(this.fields.values, function (a) {
			var value = this.store.getValue(item, a.name);
			row[a.name] = (value === undefined || value === null) ? "" : value;
		}, this);
		return row;
	}, processRows:function (items, request) {
		if (!items || items.length == 0) {
			return;
		}
		this._setupFields(items[0]);
		dojo.forEach(items, function (item, idx) {
			var row = this._createRow(item);
			this._setRowId(item, request.start, idx);
			this.setRow(row, request.start + idx);
		}, this);
		this.endUpdate();
	}, requestRows:function (inRowIndex, inCount) {
		this.beginUpdate();
		var row = inRowIndex || 0;
		var params = {start:row, count:this.rowsPerPage, query:this.query, sort:this.sortFields, queryOptions:this.queryOptions, onBegin:dojo.hitch(this, "beginReturn"), onComplete:dojo.hitch(this, "processRows"), onError:dojo.hitch(this, "processError")};
		this.store.fetch(params);
	}, getDatum:function (inRowIndex, inColIndex) {
		var row = this.getRow(inRowIndex);
		var field = this.fields.values[inColIndex];
		return row && field ? row[field.name] : field ? field.na : "?";
	}, setDatum:function (inDatum, inRowIndex, inColIndex) {
		var n = this.fields._nameMaps[inColIndex + ".idx"];
		if (n) {
			this.data[inRowIndex][n] = inDatum;
			this.datumChange(inDatum, inRowIndex, inColIndex);
		}
	}, copyRow:function (inRowIndex) {
		var row = {};
		var backstop = {};
		var src = this.getRow(inRowIndex);
		for (var x in src) {
			if (src[x] != backstop[x]) {
				row[x] = src[x];
			}
		}
		return row;
	}, _attrCompare:function (cache, data) {
		dojo.forEach(this.fields.values, function (a) {
			if (cache[a.name] != data[a.name]) {
				return false;
			}
		}, this);
		return true;
	}, endModifyRow:function (inRowIndex) {
		var cache = this.cache[inRowIndex];
		if (cache) {
			var data = this.getRow(inRowIndex);
			if (!this._attrCompare(cache, data)) {
				this.update(cache, data, inRowIndex);
			}
			delete this.cache[inRowIndex];
		}
	}, cancelModifyRow:function (inRowIndex) {
		var cache = this.cache[inRowIndex];
		if (cache) {
			this.setRow(cache, inRowIndex);
			delete this.cache[inRowIndex];
		}
	}, _setRowId:function (item, offset, idx) {
		if (this._canIdentify) {
			this._rowIdentities[this.store.getIdentity(item)] = {rowId:offset + idx, item:item};
		} else {
			var identity = dojo.toJson(this.query) + ":start:" + offset + ":idx:" + idx + ":sort:" + dojo.toJson(this.sortFields);
			this._rowIdentities[identity] = {rowId:offset + idx, item:item};
		}
	}, _getRowId:function (item, isNotItem) {
		var rowId = null;
		if (this._canIdentify && !isNotItem) {
			var _rowId = this._rowIdentities[this.store.getIdentity(item)];
			if (_rowId) {
				rowId = _rowId.rowId;
			}
		} else {
			var id;
			for (id in this._rowIdentities) {
				if (this._rowIdentities[id].item === item) {
					rowId = this._rowIdentities[id].rowId;
					break;
				}
			}
		}
		return rowId;
	}, _storeDatumChange:function (item, attr, oldVal, newVal) {
		var rowId = this._getRowId(item);
		var row = this.getRow(rowId);
		if (row) {
			row[attr] = newVal;
			var colId = this.fields._nameMaps[attr];
			this.notify("DatumChange", [newVal, rowId, colId]);
		}
	}, _storeDatumDelete:function (item) {
		if (dojo.indexOf(this._currentlyProcessing, item) != -1) {
			return;
		}
		var rowId = this._getRowId(item, true);
		if (rowId != null) {
			this._removeItems([rowId]);
		}
	}, _storeDatumNew:function (item) {
		if (this._disableNew) {
			return;
		}
		this._insertItem(item, this.data.length);
	}, insert:function (item, index) {
		this._disableNew = true;
		var i = this.store.newItem(item);
		this._disableNew = false;
		this._insertItem(i, index);
	}, _insertItem:function (storeItem, index) {
		if (!this.fields._nameMaps) {
			this._setupFields(storeItem);
		}
		var row = this._createRow(storeItem);
		for (var i in this._rowIdentities) {
			var rowIdentity = this._rowIdentities[i];
			if (rowIdentity.rowId >= index) {
				rowIdentity.rowId++;
			}
		}
		this._setRowId(storeItem, 0, index);
		dojox.grid.data.Dynamic.prototype.insert.apply(this, [row, index]);
	}, datumChange:function (value, rowIdx, colIdx) {
		if (this._canWrite) {
			var row = this.getRow(rowIdx);
			var field = this.fields._nameMaps[colIdx + ".idx"];
			this.store.setValue(row.__dojo_data_item, field, value);
		} else {
			this.notify("DatumChange", arguments);
		}
	}, insertion:function () {
		this.notify("Insertion", arguments);
		this.notify("Change", arguments);
	}, removal:function () {
		this.notify("Removal", arguments);
		this.notify("Change", arguments);
	}, remove:function (inRowIndexes) {
		for (var i = inRowIndexes.length - 1; i >= 0; i--) {
			var item = this.data[inRowIndexes[i]].__dojo_data_item;
			this._currentlyProcessing.push(item);
			this.store.deleteItem(item);
		}
		this._removeItems(inRowIndexes);
		this._currentlyProcessing = [];
	}, _removeItems:function (inRowIndexes) {
		dojox.grid.data.Dynamic.prototype.remove.apply(this, arguments);
		this._rowIdentities = {};
		for (var i = 0; i < this.data.length; i++) {
			this._setRowId(this.data[i].__dojo_data_item, 0, i);
		}
	}, canSort:function () {
		return true;
	}, sort:function (colIndex) {
		var col = Math.abs(colIndex) - 1;
		this.sortFields = [{"attribute":this.fields.values[col].name, "descending":(colIndex > 0)}];
		this.refresh();
	}, refresh:function () {
		this.clearData(true);
		this.requestRows();
	}, clearData:function (keepStore) {
		this._rowIdentities = {};
		this.pages = [];
		this.bop = this.eop = -1;
		this.count = 0;
		this.setData((keepStore ? this.store : []));
	}, processError:function (error, request) {
		console.log(error);
	}});
}
if (!dojo._hasResource["dojox.grid.compat._data.editors"]) {
	dojo._hasResource["dojox.grid.compat._data.editors"] = true;
	dojo.provide("dojox.grid.compat._data.editors");
	dojo.provide("dojox.grid.compat.editors");
	dojo.declare("dojox.grid.editors.Base", null, {constructor:function (inCell) {
		this.cell = inCell;
	}, _valueProp:"value", _formatPending:false, format:function (inDatum, inRowIndex) {
	}, needFormatNode:function (inDatum, inRowIndex) {
		this._formatPending = true;
		dojox.grid.whenIdle(this, "_formatNode", inDatum, inRowIndex);
	}, cancelFormatNode:function () {
		this._formatPending = false;
	}, _formatNode:function (inDatum, inRowIndex) {
		if (this._formatPending) {
			this._formatPending = false;
			dojo.setSelectable(this.cell.grid.domNode, true);
			this.formatNode(this.getNode(inRowIndex), inDatum, inRowIndex);
		}
	}, getNode:function (inRowIndex) {
		return (this.cell.getNode(inRowIndex) || 0).firstChild || 0;
	}, formatNode:function (inNode, inDatum, inRowIndex) {
		if (dojo.isIE) {
			dojox.grid.whenIdle(this, "focus", inRowIndex, inNode);
		} else {
			this.focus(inRowIndex, inNode);
		}
	}, dispatchEvent:function (m, e) {
		if (m in this) {
			return this[m](e);
		}
	}, getValue:function (inRowIndex) {
		return this.getNode(inRowIndex)[this._valueProp];
	}, setValue:function (inRowIndex, inValue) {
		var n = this.getNode(inRowIndex);
		if (n) {
			n[this._valueProp] = inValue;
		}
	}, focus:function (inRowIndex, inNode) {
		dojox.grid.focusSelectNode(inNode || this.getNode(inRowIndex));
	}, save:function (inRowIndex) {
		this.value = this.value || this.getValue(inRowIndex);
	}, restore:function (inRowIndex) {
		this.setValue(inRowIndex, this.value);
	}, _finish:function (inRowIndex) {
		dojo.setSelectable(this.cell.grid.domNode, false);
		this.cancelFormatNode(this.cell);
	}, apply:function (inRowIndex) {
		this.cell.applyEdit(this.getValue(inRowIndex), inRowIndex);
		this._finish(inRowIndex);
	}, cancel:function (inRowIndex) {
		this.cell.cancelEdit(inRowIndex);
		this._finish(inRowIndex);
	}});
	dojox.grid.editors.base = dojox.grid.editors.Base;
	dojo.declare("dojox.grid.editors.Input", dojox.grid.editors.Base, {constructor:function (inCell) {
		this.keyFilter = this.keyFilter || this.cell.keyFilter;
	}, keyFilter:null, format:function (inDatum, inRowIndex) {
		this.needFormatNode(inDatum, inRowIndex);
		return "<input class=\"dojoxGrid-input\" type=\"text\" value=\"" + inDatum + "\">";
	}, formatNode:function (inNode, inDatum, inRowIndex) {
		this.inherited(arguments);
		this.cell.registerOnBlur(inNode, inRowIndex);
	}, doKey:function (e) {
		if (this.keyFilter) {
			var key = String.fromCharCode(e.charCode);
			if (key.search(this.keyFilter) == -1) {
				dojo.stopEvent(e);
			}
		}
	}, _finish:function (inRowIndex) {
		this.inherited(arguments);
		var n = this.getNode(inRowIndex);
		try {
			dojox.grid.fire(n, "blur");
		}
		catch (e) {
		}
	}});
	dojox.grid.editors.input = dojox.grid.editors.Input;
	dojo.declare("dojox.grid.editors.Select", dojox.grid.editors.Input, {constructor:function (inCell) {
		this.options = this.options || this.cell.options;
		this.values = this.values || this.cell.values || this.options;
	}, format:function (inDatum, inRowIndex) {
		this.needFormatNode(inDatum, inRowIndex);
		var h = ["<select class=\"dojoxGrid-select\">"];
		for (var i = 0, o, v; ((o = this.options[i]) !== undefined) && ((v = this.values[i]) !== undefined); i++) {
			h.push("<option", (inDatum == v ? " selected" : ""), " value=\"" + v + "\"", ">", o, "</option>");
		}
		h.push("</select>");
		return h.join("");
	}, getValue:function (inRowIndex) {
		var n = this.getNode(inRowIndex);
		if (n) {
			var i = n.selectedIndex, o = n.options[i];
			return this.cell.returnIndex ? i : o.value || o.innerHTML;
		}
	}});
	dojox.grid.editors.select = dojox.grid.editors.Select;
	dojo.declare("dojox.grid.editors.AlwaysOn", dojox.grid.editors.Input, {alwaysOn:true, _formatNode:function (inDatum, inRowIndex) {
		this.formatNode(this.getNode(inRowIndex), inDatum, inRowIndex);
	}, applyStaticValue:function (inRowIndex) {
		var e = this.cell.grid.edit;
		e.applyCellEdit(this.getValue(inRowIndex), this.cell, inRowIndex);
		e.start(this.cell, inRowIndex, true);
	}});
	dojox.grid.editors.alwaysOn = dojox.grid.editors.AlwaysOn;
	dojo.declare("dojox.grid.editors.Bool", dojox.grid.editors.AlwaysOn, {_valueProp:"checked", format:function (inDatum, inRowIndex) {
		return "<input class=\"dojoxGrid-input\" type=\"checkbox\"" + (inDatum ? " checked=\"checked\"" : "") + " style=\"width: auto\" />";
	}, doclick:function (e) {
		if (e.target.tagName == "INPUT") {
			this.applyStaticValue(e.rowIndex);
		}
	}});
	dojox.grid.editors.bool = dojox.grid.editors.Bool;
}
if (!dojo._hasResource["dijit.Calendar"]) {
	dojo._hasResource["dijit.Calendar"] = true;
	dojo.provide("dijit.Calendar");
	dojo.declare("dijit.Calendar", [dijit._Widget, dijit._Templated], {templateString:dojo.cache("dijit", "templates/Calendar.html", "<table cellspacing=\"0\" cellpadding=\"0\" class=\"dijitCalendarContainer\" role=\"grid\" dojoAttachEvent=\"onkeypress: _onKeyPress\">\r\n\t<thead>\r\n\t\t<tr class=\"dijitReset dijitCalendarMonthContainer\" valign=\"top\">\r\n\t\t\t<th class='dijitReset' dojoAttachPoint=\"decrementMonth\">\r\n\t\t\t\t<img src=\"${_blankGif}\" alt=\"\" class=\"dijitCalendarIncrementControl dijitCalendarDecrease\" waiRole=\"presentation\">\r\n\t\t\t\t<span dojoAttachPoint=\"decreaseArrowNode\" class=\"dijitA11ySideArrow\">-</span>\r\n\t\t\t</th>\r\n\t\t\t<th class='dijitReset' colspan=\"5\">\r\n\t\t\t\t<div class=\"dijitVisible\">\r\n\t\t\t\t\t<div class=\"dijitPopup dijitMenu dijitMenuPassive dijitHidden\" dojoAttachPoint=\"monthDropDown\" dojoAttachEvent=\"onmouseup: _onMonthSelect, onmouseover: _onMenuHover, onmouseout: _onMenuHover\">\r\n\t\t\t\t\t\t<div class=\"dijitCalendarMonthLabelTemplate dijitCalendarMonthLabel\"></div>\r\n\t\t\t\t\t</div>\r\n\t\t\t\t</div>\r\n\t\t\t\t<div dojoAttachPoint=\"monthLabelSpacer\" class=\"dijitSpacer\"></div>\r\n\t\t\t\t<div dojoAttachPoint=\"monthLabelNode\" class=\"dijitCalendarMonthLabel dijitInline dijitVisible\" dojoAttachEvent=\"onmousedown: _onMonthToggle\"></div>\r\n\t\t\t</th>\r\n\t\t\t<th class='dijitReset' dojoAttachPoint=\"incrementMonth\">\r\n\t\t\t\t<img src=\"${_blankGif}\" alt=\"\" class=\"dijitCalendarIncrementControl dijitCalendarIncrease\" waiRole=\"presentation\">\r\n\t\t\t\t<span dojoAttachPoint=\"increaseArrowNode\" class=\"dijitA11ySideArrow\">+</span>\r\n\t\t\t</th>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<th class=\"dijitReset dijitCalendarDayLabelTemplate\" role=\"columnheader\"><span class=\"dijitCalendarDayLabel\"></span></th>\r\n\t\t</tr>\r\n\t</thead>\r\n\t<tbody dojoAttachEvent=\"onclick: _onDayClick, onmouseover: _onDayMouseOver, onmouseout: _onDayMouseOut\" class=\"dijitReset dijitCalendarBodyContainer\">\r\n\t\t<tr class=\"dijitReset dijitCalendarWeekTemplate\" role=\"row\">\r\n\t\t\t<td class=\"dijitReset dijitCalendarDateTemplate\" role=\"gridcell\"><span class=\"dijitCalendarDateLabel\"></span></td>\r\n\t\t</tr>\r\n\t</tbody>\r\n\t<tfoot class=\"dijitReset dijitCalendarYearContainer\">\r\n\t\t<tr>\r\n\t\t\t<td class='dijitReset' valign=\"top\" colspan=\"7\">\r\n\t\t\t\t<h3 class=\"dijitCalendarYearLabel\">\r\n\t\t\t\t\t<span dojoAttachPoint=\"previousYearLabelNode\" class=\"dijitInline dijitCalendarPreviousYear\"></span>\r\n\t\t\t\t\t<span dojoAttachPoint=\"currentYearLabelNode\" class=\"dijitInline dijitCalendarSelectedYear\"></span>\r\n\t\t\t\t\t<span dojoAttachPoint=\"nextYearLabelNode\" class=\"dijitInline dijitCalendarNextYear\"></span>\r\n\t\t\t\t</h3>\r\n\t\t\t</td>\r\n\t\t</tr>\r\n\t</tfoot>\r\n</table>\r\n"), value:new Date(), datePackage:"dojo.date", dayWidth:"narrow", tabIndex:"0", attributeMap:dojo.delegate(dijit._Widget.prototype.attributeMap, {tabIndex:"domNode"}), setValue:function (value) {
		dojo.deprecated("dijit.Calendar:setValue() is deprecated.  Use attr('value', ...) instead.", "", "2.0");
		this.attr("value", value);
	}, _getValueAttr:function () {
		var value = new this.dateClassObj(this.value);
		value.setHours(0, 0, 0, 0);
		if (value.getDate() < this.value.getDate()) {
			value = this.dateFuncObj.add(value, "hour", 1);
		}
		return value;
	}, _setValueAttr:function (value) {
		if (!this.value || this.dateFuncObj.compare(value, this.value)) {
			value = new this.dateClassObj(value);
			value.setHours(1);
			this.displayMonth = new this.dateClassObj(value);
			if (!this.isDisabledDate(value, this.lang)) {
				this.value = value;
				this.onChange(this.attr("value"));
			}
			dojo.attr(this.domNode, "aria-label", this.dateLocaleModule.format(value, {selector:"date", formatLength:"full"}));
			this._populateGrid();
		}
	}, _setText:function (node, text) {
		while (node.firstChild) {
			node.removeChild(node.firstChild);
		}
		node.appendChild(dojo.doc.createTextNode(text));
	}, _populateGrid:function () {
		var month = this.displayMonth;
		month.setDate(1);
		var firstDay = month.getDay(), daysInMonth = this.dateFuncObj.getDaysInMonth(month), daysInPreviousMonth = this.dateFuncObj.getDaysInMonth(this.dateFuncObj.add(month, "month", -1)), today = new this.dateClassObj(), dayOffset = dojo.cldr.supplemental.getFirstDayOfWeek(this.lang);
		if (dayOffset > firstDay) {
			dayOffset -= 7;
		}
		dojo.query(".dijitCalendarDateTemplate", this.domNode).forEach(function (template, i) {
			i += dayOffset;
			var date = new this.dateClassObj(month), number, clazz = "dijitCalendar", adj = 0;
			if (i < firstDay) {
				number = daysInPreviousMonth - firstDay + i + 1;
				adj = -1;
				clazz += "Previous";
			} else {
				if (i >= (firstDay + daysInMonth)) {
					number = i - firstDay - daysInMonth + 1;
					adj = 1;
					clazz += "Next";
				} else {
					number = i - firstDay + 1;
					clazz += "Current";
				}
			}
			if (adj) {
				date = this.dateFuncObj.add(date, "month", adj);
			}
			date.setDate(number);
			if (!this.dateFuncObj.compare(date, today, "date")) {
				clazz = "dijitCalendarCurrentDate " + clazz;
			}
			if (this._isSelectedDate(date, this.lang)) {
				clazz = "dijitCalendarSelectedDate " + clazz;
			}
			if (this.isDisabledDate(date, this.lang)) {
				clazz = "dijitCalendarDisabledDate " + clazz;
			}
			var clazz2 = this.getClassForDate(date, this.lang);
			if (clazz2) {
				clazz = clazz2 + " " + clazz;
			}
			template.className = clazz + "Month dijitCalendarDateTemplate";
			template.dijitDateValue = date.valueOf();
			var label = dojo.query(".dijitCalendarDateLabel", template)[0], text = date.getDateLocalized ? date.getDateLocalized(this.lang) : date.getDate();
			this._setText(label, text);
		}, this);
		var monthNames = this.dateLocaleModule.getNames("months", "wide", "standAlone", this.lang);
		this._setText(this.monthLabelNode, monthNames[month.getMonth()]);
		var y = month.getFullYear() - 1;
		var d = new this.dateClassObj();
		dojo.forEach(["previous", "current", "next"], function (name) {
			d.setFullYear(y++);
			this._setText(this[name + "YearLabelNode"], this.dateLocaleModule.format(d, {selector:"year", locale:this.lang}));
		}, this);
		var _this = this;
		var typematic = function (nodeProp, dateProp, adj) {
			_this._connects.push(dijit.typematic.addMouseListener(_this[nodeProp], _this, function (count) {
				if (count >= 0) {
					_this._adjustDisplay(dateProp, adj);
				}
			}, 0.8, 500));
		};
		typematic("incrementMonth", "month", 1);
		typematic("decrementMonth", "month", -1);
		typematic("nextYearLabelNode", "year", 1);
		typematic("previousYearLabelNode", "year", -1);
	}, goToToday:function () {
		this.attr("value", new this.dateClassObj());
	}, constructor:function (args) {
		var dateClass = (args.datePackage && (args.datePackage != "dojo.date")) ? args.datePackage + ".Date" : "Date";
		this.dateClassObj = dojo.getObject(dateClass, false);
		this.datePackage = args.datePackage || this.datePackage;
		this.dateFuncObj = dojo.getObject(this.datePackage, false);
		this.dateLocaleModule = dojo.getObject(this.datePackage + ".locale", false);
	}, postMixInProperties:function () {
		if (isNaN(this.value)) {
			delete this.value;
		}
		this.inherited(arguments);
	}, postCreate:function () {
		this.inherited(arguments);
		dojo.setSelectable(this.domNode, false);
		var cloneClass = dojo.hitch(this, function (clazz, n) {
			var template = dojo.query(clazz, this.domNode)[0];
			for (var i = 0; i < n; i++) {
				template.parentNode.appendChild(template.cloneNode(true));
			}
		});
		cloneClass(".dijitCalendarDayLabelTemplate", 6);
		cloneClass(".dijitCalendarDateTemplate", 6);
		cloneClass(".dijitCalendarWeekTemplate", 5);
		var dayNames = this.dateLocaleModule.getNames("days", this.dayWidth, "standAlone", this.lang);
		var dayOffset = dojo.cldr.supplemental.getFirstDayOfWeek(this.lang);
		dojo.query(".dijitCalendarDayLabel", this.domNode).forEach(function (label, i) {
			this._setText(label, dayNames[(i + dayOffset) % 7]);
		}, this);
		var monthNames = this.dateLocaleModule.getNames("months", "wide", "standAlone", this.lang);
		cloneClass(".dijitCalendarMonthLabelTemplate", monthNames.length - 1);
		dojo.query(".dijitCalendarMonthLabelTemplate", this.domNode).forEach(function (node, i) {
			dojo.attr(node, "month", i);
			this._setText(node, monthNames[i]);
			dojo.place(node.cloneNode(true), this.monthLabelSpacer);
		}, this);
		var value = this.value;
		this.value = null;
		this.attr("value", new this.dateClassObj(value));
	}, _onMenuHover:function (e) {
		dojo.stopEvent(e);
		dojo.toggleClass(e.target, "dijitMenuItemHover");
	}, _adjustDisplay:function (part, amount) {
		this.displayMonth = this.dateFuncObj.add(this.displayMonth, part, amount);
		this._populateGrid();
	}, _onMonthToggle:function (evt) {
		dojo.stopEvent(evt);
		if (evt.type == "mousedown") {
			var coords = dojo.position(this.monthLabelNode);
			var dim = {width:coords.w + "px", top:-this.displayMonth.getMonth() * coords.h + "px"};
			if ((dojo.isIE && dojo.isQuirks) || dojo.isIE < 7) {
				dim.left = -coords.w / 2 + "px";
			}
			dojo.style(this.monthDropDown, dim);
			this._popupHandler = this.connect(document, "onmouseup", "_onMonthToggle");
		} else {
			this.disconnect(this._popupHandler);
			delete this._popupHandler;
		}
		dojo.toggleClass(this.monthDropDown, "dijitHidden");
		dojo.toggleClass(this.monthLabelNode, "dijitVisible");
	}, _onMonthSelect:function (evt) {
		this._onMonthToggle(evt);
		this.displayMonth.setMonth(dojo.attr(evt.target, "month"));
		this._populateGrid();
	}, _onDayClick:function (evt) {
		dojo.stopEvent(evt);
		for (var node = evt.target; node && !node.dijitDateValue; node = node.parentNode) {
		}
		if (node && !dojo.hasClass(node, "dijitCalendarDisabledDate")) {
			this.attr("value", node.dijitDateValue);
			this.onValueSelected(this.attr("value"));
		}
	}, _onDayMouseOver:function (evt) {
		var node = evt.target;
		if (node && (node.dijitDateValue || node == this.previousYearLabelNode || node == this.nextYearLabelNode)) {
			dojo.addClass(node, "dijitCalendarHoveredDate");
			this._currentNode = node;
		}
	}, _onDayMouseOut:function (evt) {
		if (!this._currentNode) {
			return;
		}
		for (var node = evt.relatedTarget; node; ) {
			if (node == this._currentNode) {
				return;
			}
			try {
				node = node.parentNode;
			}
			catch (x) {
				node = null;
			}
		}
		dojo.removeClass(this._currentNode, "dijitCalendarHoveredDate");
		this._currentNode = null;
	}, _onKeyPress:function (evt) {
		var dk = dojo.keys, increment = -1, interval, newValue = this.value;
		switch (evt.keyCode) {
		  case dk.RIGHT_ARROW:
			increment = 1;
		  case dk.LEFT_ARROW:
			interval = "day";
			if (!this.isLeftToRight()) {
				increment *= -1;
			}
			break;
		  case dk.DOWN_ARROW:
			increment = 1;
		  case dk.UP_ARROW:
			interval = "week";
			break;
		  case dk.PAGE_DOWN:
			increment = 1;
		  case dk.PAGE_UP:
			interval = evt.ctrlKey ? "year" : "month";
			break;
		  case dk.END:
			newValue = this.dateFuncObj.add(newValue, "month", 1);
			interval = "day";
		  case dk.HOME:
			newValue = new Date(newValue).setDate(1);
			break;
		  case dk.ENTER:
			this.onValueSelected(this.attr("value"));
			break;
		  case dk.ESCAPE:
		  default:
			return;
		}
		dojo.stopEvent(evt);
		if (interval) {
			newValue = this.dateFuncObj.add(newValue, interval, increment);
		}
		this.attr("value", newValue);
	}, onValueSelected:function (date) {
	}, onChange:function (date) {
	}, _isSelectedDate:function (dateObject, locale) {
		return !this.dateFuncObj.compare(dateObject, this.value, "date");
	}, isDisabledDate:function (dateObject, locale) {
	}, getClassForDate:function (dateObject, locale) {
	}, destroy:function () {
		this.inherited(arguments);
		if (this._currentNode) {
			dojo.destroy(this._currentNode);
		}
		delete this._currentNode;
		delete this.currentYearLabelNode;
		delete this.decreaseArrowNode;
		delete this.decrementMonth;
		delete this.increaseArrowNode;
		delete this.incrementMonth;
		delete this.monthLabelNode;
		delete this.monthLabelSpacer;
		delete this.nextYearLabelNode;
		delete this.previousYearLabelNode;
		delete this._connects;
	}});
}
if (!dojo._hasResource["dijit.form._FormWidget"]) {
	dojo._hasResource["dijit.form._FormWidget"] = true;
	dojo.provide("dijit.form._FormWidget");
	dojo.declare("dijit.form._FormWidget", [dijit._Widget, dijit._Templated], {baseClass:"", name:"", alt:"", value:"", type:"text", tabIndex:"0", disabled:false, intermediateChanges:false, scrollOnFocus:true, attributeMap:dojo.delegate(dijit._Widget.prototype.attributeMap, {value:"focusNode", id:"focusNode", tabIndex:"focusNode", alt:"focusNode", title:"focusNode"}), postMixInProperties:function () {
		this.nameAttrSetting = this.name ? ("name='" + this.name + "'") : "";
		this.inherited(arguments);
	}, _setDisabledAttr:function (value) {
		this.disabled = value;
		dojo.attr(this.focusNode, "disabled", value);
		if (this.valueNode) {
			dojo.attr(this.valueNode, "disabled", value);
		}
		dijit.setWaiState(this.focusNode, "disabled", value);
		if (value) {
			this._hovering = false;
			this._active = false;
			this.focusNode.setAttribute("tabIndex", "-1");
		} else {
			this.focusNode.setAttribute("tabIndex", this.tabIndex);
		}
		this._setStateClass();
	}, setDisabled:function (disabled) {
		dojo.deprecated("setDisabled(" + disabled + ") is deprecated. Use attr('disabled'," + disabled + ") instead.", "", "2.0");
		this.attr("disabled", disabled);
	}, _onFocus:function (e) {
		if (this.scrollOnFocus) {
			dijit.scrollIntoView(this.domNode);
		}
		this.inherited(arguments);
	}, _onMouse:function (event) {
		var mouseNode = event.currentTarget;
		if (mouseNode && mouseNode.getAttribute) {
			this.stateModifier = mouseNode.getAttribute("stateModifier") || "";
		}
		if (!this.disabled) {
			switch (event.type) {
			  case "mouseenter":
			  case "mouseover":
				this._hovering = true;
				this._active = this._mouseDown;
				break;
			  case "mouseout":
			  case "mouseleave":
				this._hovering = false;
				this._active = false;
				break;
			  case "mousedown":
				this._active = true;
				this._mouseDown = true;
				var mouseUpConnector = this.connect(dojo.body(), "onmouseup", function () {
					if (this._mouseDown && this.isFocusable()) {
						this.focus();
					}
					this._active = false;
					this._mouseDown = false;
					this._setStateClass();
					this.disconnect(mouseUpConnector);
				});
				break;
			}
			this._setStateClass();
		}
	}, isFocusable:function () {
		return !this.disabled && !this.readOnly && this.focusNode && (dojo.style(this.domNode, "display") != "none");
	}, focus:function () {
		dijit.focus(this.focusNode);
	}, _setStateClass:function () {
		var newStateClasses = this.baseClass.split(" ");
		function multiply(modifier) {
			newStateClasses = newStateClasses.concat(dojo.map(newStateClasses, function (c) {
				return c + modifier;
			}), "dijit" + modifier);
		}
		if (this.checked) {
			multiply("Checked");
		}
		if (this.state) {
			multiply(this.state);
		}
		if (this.selected) {
			multiply("Selected");
		}
		if (this.disabled) {
			multiply("Disabled");
		} else {
			if (this.readOnly) {
				multiply("ReadOnly");
			} else {
				if (this._active) {
					multiply(this.stateModifier + "Active");
				} else {
					if (this._focused) {
						multiply("Focused");
					}
					if (this._hovering) {
						multiply(this.stateModifier + "Hover");
					}
				}
			}
		}
		var tn = this.stateNode || this.domNode, classHash = {};
		dojo.forEach(tn.className.split(" "), function (c) {
			classHash[c] = true;
		});
		if ("_stateClasses" in this) {
			dojo.forEach(this._stateClasses, function (c) {
				delete classHash[c];
			});
		}
		dojo.forEach(newStateClasses, function (c) {
			classHash[c] = true;
		});
		var newClasses = [];
		for (var c in classHash) {
			newClasses.push(c);
		}
		tn.className = newClasses.join(" ");
		this._stateClasses = newStateClasses;
	}, compare:function (val1, val2) {
		if (typeof val1 == "number" && typeof val2 == "number") {
			return (isNaN(val1) && isNaN(val2)) ? 0 : val1 - val2;
		} else {
			if (val1 > val2) {
				return 1;
			} else {
				if (val1 < val2) {
					return -1;
				} else {
					return 0;
				}
			}
		}
	}, onChange:function (newValue) {
	}, _onChangeActive:false, _handleOnChange:function (newValue, priorityChange) {
		this._lastValue = newValue;
		if (this._lastValueReported == undefined && (priorityChange === null || !this._onChangeActive)) {
			this._resetValue = this._lastValueReported = newValue;
		}
		if ((this.intermediateChanges || priorityChange || priorityChange === undefined) && ((typeof newValue != typeof this._lastValueReported) || this.compare(newValue, this._lastValueReported) != 0)) {
			this._lastValueReported = newValue;
			if (this._onChangeActive) {
				if (this._onChangeHandle) {
					clearTimeout(this._onChangeHandle);
				}
				this._onChangeHandle = setTimeout(dojo.hitch(this, function () {
					this._onChangeHandle = null;
					this.onChange(newValue);
				}), 0);
			}
		}
	}, create:function () {
		this.inherited(arguments);
		this._onChangeActive = true;
		this._setStateClass();
	}, destroy:function () {
		if (this._onChangeHandle) {
			clearTimeout(this._onChangeHandle);
			this.onChange(this._lastValueReported);
		}
		this.inherited(arguments);
	}, setValue:function (value) {
		dojo.deprecated("dijit.form._FormWidget:setValue(" + value + ") is deprecated.  Use attr('value'," + value + ") instead.", "", "2.0");
		this.attr("value", value);
	}, getValue:function () {
		dojo.deprecated(this.declaredClass + "::getValue() is deprecated. Use attr('value') instead.", "", "2.0");
		return this.attr("value");
	}});
	dojo.declare("dijit.form._FormValueWidget", dijit.form._FormWidget, {readOnly:false, attributeMap:dojo.delegate(dijit.form._FormWidget.prototype.attributeMap, {value:"", readOnly:"focusNode"}), _setReadOnlyAttr:function (value) {
		this.readOnly = value;
		dojo.attr(this.focusNode, "readOnly", value);
		dijit.setWaiState(this.focusNode, "readonly", value);
		this._setStateClass();
	}, postCreate:function () {
		if (dojo.isIE) {
			this.connect(this.focusNode || this.domNode, "onkeydown", this._onKeyDown);
		}
		if (this._resetValue === undefined) {
			this._resetValue = this.value;
		}
	}, _setValueAttr:function (newValue, priorityChange) {
		this.value = newValue;
		this._handleOnChange(newValue, priorityChange);
	}, _getValueAttr:function () {
		return this._lastValue;
	}, undo:function () {
		this._setValueAttr(this._lastValueReported, false);
	}, reset:function () {
		this._hasBeenBlurred = false;
		this._setValueAttr(this._resetValue, true);
	}, _onKeyDown:function (e) {
		if (e.keyCode == dojo.keys.ESCAPE && !(e.ctrlKey || e.altKey || e.metaKey)) {
			var te;
			if (dojo.isIE) {
				e.preventDefault();
				te = document.createEventObject();
				te.keyCode = dojo.keys.ESCAPE;
				te.shiftKey = e.shiftKey;
				e.srcElement.fireEvent("onkeypress", te);
			}
		}
	}, _layoutHackIE7:function () {
		if (dojo.isIE == 7) {
			var domNode = this.domNode;
			var parent = domNode.parentNode;
			var pingNode = domNode.firstChild || domNode;
			var origFilter = pingNode.style.filter;
			while (parent && parent.clientHeight == 0) {
				parent._disconnectHandle = this.connect(parent, "onscroll", dojo.hitch(this, function (e) {
					this.disconnect(parent._disconnectHandle);
					parent.removeAttribute("_disconnectHandle");
					pingNode.style.filter = (new Date()).getMilliseconds();
					setTimeout(function () {
						pingNode.style.filter = origFilter;
					}, 0);
				}));
				parent = parent.parentNode;
			}
		}
	}});
}
if (!dojo._hasResource["dijit.form.TextBox"]) {
	dojo._hasResource["dijit.form.TextBox"] = true;
	dojo.provide("dijit.form.TextBox");
	dojo.declare("dijit.form.TextBox", dijit.form._FormValueWidget, {trim:false, uppercase:false, lowercase:false, propercase:false, maxLength:"", selectOnClick:false, templateString:dojo.cache("dijit.form", "templates/TextBox.html", "<input class=\"dijit dijitReset dijitLeft\" dojoAttachPoint='textbox,focusNode'\r\n\tdojoAttachEvent='onmouseenter:_onMouse,onmouseleave:_onMouse'\r\n\tautocomplete=\"off\" type=\"${type}\" ${nameAttrSetting}\r\n\t/>\r\n"), baseClass:"dijitTextBox", attributeMap:dojo.delegate(dijit.form._FormValueWidget.prototype.attributeMap, {maxLength:"focusNode"}), _getValueAttr:function () {
		return this.parse(this.attr("displayedValue"), this.constraints);
	}, _setValueAttr:function (value, priorityChange, formattedValue) {
		var filteredValue;
		if (value !== undefined) {
			filteredValue = this.filter(value);
			if (typeof formattedValue != "string") {
				if (filteredValue !== null && ((typeof filteredValue != "number") || !isNaN(filteredValue))) {
					formattedValue = this.filter(this.format(filteredValue, this.constraints));
				} else {
					formattedValue = "";
				}
			}
		}
		if (formattedValue != null && formattedValue != undefined && ((typeof formattedValue) != "number" || !isNaN(formattedValue)) && this.textbox.value != formattedValue) {
			this.textbox.value = formattedValue;
		}
		this.inherited(arguments, [filteredValue, priorityChange]);
	}, displayedValue:"", getDisplayedValue:function () {
		dojo.deprecated(this.declaredClass + "::getDisplayedValue() is deprecated. Use attr('displayedValue') instead.", "", "2.0");
		return this.attr("displayedValue");
	}, _getDisplayedValueAttr:function () {
		return this.filter(this.textbox.value);
	}, setDisplayedValue:function (value) {
		dojo.deprecated(this.declaredClass + "::setDisplayedValue() is deprecated. Use attr('displayedValue', ...) instead.", "", "2.0");
		this.attr("displayedValue", value);
	}, _setDisplayedValueAttr:function (value) {
		if (value === null || value === undefined) {
			value = "";
		} else {
			if (typeof value != "string") {
				value = String(value);
			}
		}
		this.textbox.value = value;
		this._setValueAttr(this.attr("value"), undefined, value);
	}, format:function (value, constraints) {
		return ((value == null || value == undefined) ? "" : (value.toString ? value.toString() : value));
	}, parse:function (value, constraints) {
		return value;
	}, _refreshState:function () {
	}, _onInput:function (e) {
		if (e && e.type && /key/i.test(e.type) && e.keyCode) {
			switch (e.keyCode) {
			  case dojo.keys.SHIFT:
			  case dojo.keys.ALT:
			  case dojo.keys.CTRL:
			  case dojo.keys.TAB:
				return;
			}
		}
		if (this.intermediateChanges) {
			var _this = this;
			setTimeout(function () {
				_this._handleOnChange(_this.attr("value"), false);
			}, 0);
		}
		this._refreshState();
	}, postCreate:function () {
		this.textbox.setAttribute("value", this.textbox.value);
		this.inherited(arguments);
		if (dojo.isMoz || dojo.isOpera) {
			this.connect(this.textbox, "oninput", this._onInput);
		} else {
			this.connect(this.textbox, "onkeydown", this._onInput);
			this.connect(this.textbox, "onkeyup", this._onInput);
			this.connect(this.textbox, "onpaste", this._onInput);
			this.connect(this.textbox, "oncut", this._onInput);
		}
	}, _blankValue:"", filter:function (val) {
		if (val === null) {
			return this._blankValue;
		}
		if (typeof val != "string") {
			return val;
		}
		if (this.trim) {
			val = dojo.trim(val);
		}
		if (this.uppercase) {
			val = val.toUpperCase();
		}
		if (this.lowercase) {
			val = val.toLowerCase();
		}
		if (this.propercase) {
			val = val.replace(/[^\s]+/g, function (word) {
				return word.substring(0, 1).toUpperCase() + word.substring(1);
			});
		}
		return val;
	}, _setBlurValue:function () {
		this._setValueAttr(this.attr("value"), true);
	}, _onBlur:function (e) {
		if (this.disabled) {
			return;
		}
		this._setBlurValue();
		this.inherited(arguments);
		if (this._selectOnClickHandle) {
			this.disconnect(this._selectOnClickHandle);
		}
		if (this.selectOnClick && dojo.isMoz) {
			this.textbox.selectionStart = this.textbox.selectionEnd = undefined;
		}
	}, _onFocus:function (by) {
		if (this.disabled || this.readOnly) {
			return;
		}
		if (this.selectOnClick && by == "mouse") {
			this._selectOnClickHandle = this.connect(this.domNode, "onmouseup", function () {
				this.disconnect(this._selectOnClickHandle);
				var textIsNotSelected;
				if (dojo.isIE) {
					var range = dojo.doc.selection.createRange();
					var parent = range.parentElement();
					textIsNotSelected = parent == this.textbox && range.text.length == 0;
				} else {
					textIsNotSelected = this.textbox.selectionStart == this.textbox.selectionEnd;
				}
				if (textIsNotSelected) {
					dijit.selectInputText(this.textbox);
				}
			});
		}
		this._refreshState();
		this.inherited(arguments);
	}, reset:function () {
		this.textbox.value = "";
		this.inherited(arguments);
	}});
	dijit.selectInputText = function (element, start, stop) {
		var _window = dojo.global;
		var _document = dojo.doc;
		element = dojo.byId(element);
		if (isNaN(start)) {
			start = 0;
		}
		if (isNaN(stop)) {
			stop = element.value ? element.value.length : 0;
		}
		dijit.focus(element);
		if (_document["selection"] && dojo.body()["createTextRange"]) {
			if (element.createTextRange) {
				var range = element.createTextRange();
				with (range) {
					collapse(true);
					moveStart("character", -99999);
					moveStart("character", start);
					moveEnd("character", stop - start);
					select();
				}
			}
		} else {
			if (_window["getSelection"]) {
				if (element.setSelectionRange) {
					element.setSelectionRange(start, stop);
				}
			}
		}
	};
}
if (!dojo._hasResource["dijit.Tooltip"]) {
	dojo._hasResource["dijit.Tooltip"] = true;
	dojo.provide("dijit.Tooltip");
	dojo.declare("dijit._MasterTooltip", [dijit._Widget, dijit._Templated], {duration:dijit.defaultDuration, templateString:dojo.cache("dijit", "templates/Tooltip.html", "<div class=\"dijitTooltip dijitTooltipLeft\" id=\"dojoTooltip\">\r\n\t<div class=\"dijitTooltipContainer dijitTooltipContents\" dojoAttachPoint=\"containerNode\" waiRole='alert'></div>\r\n\t<div class=\"dijitTooltipConnector\"></div>\r\n</div>\r\n"), postCreate:function () {
		dojo.body().appendChild(this.domNode);
		this.bgIframe = new dijit.BackgroundIframe(this.domNode);
		this.fadeIn = dojo.fadeIn({node:this.domNode, duration:this.duration, onEnd:dojo.hitch(this, "_onShow")});
		this.fadeOut = dojo.fadeOut({node:this.domNode, duration:this.duration, onEnd:dojo.hitch(this, "_onHide")});
	}, show:function (innerHTML, aroundNode, position) {
		if (this.aroundNode && this.aroundNode === aroundNode) {
			return;
		}
		if (this.fadeOut.status() == "playing") {
			this._onDeck = arguments;
			return;
		}
		this.containerNode.innerHTML = innerHTML;
		this.domNode.style.top = (this.domNode.offsetTop + 1) + "px";
		var pos = dijit.placeOnScreenAroundElement(this.domNode, aroundNode, dijit.getPopupAroundAlignment((position && position.length) ? position : dijit.Tooltip.defaultPosition, this.isLeftToRight()), dojo.hitch(this, "orient"));
		dojo.style(this.domNode, "opacity", 0);
		this.fadeIn.play();
		this.isShowingNow = true;
		this.aroundNode = aroundNode;
	}, orient:function (node, aroundCorner, tooltipCorner) {
		node.className = "dijitTooltip " + {"BL-TL":"dijitTooltipBelow dijitTooltipABLeft", "TL-BL":"dijitTooltipAbove dijitTooltipABLeft", "BR-TR":"dijitTooltipBelow dijitTooltipABRight", "TR-BR":"dijitTooltipAbove dijitTooltipABRight", "BR-BL":"dijitTooltipRight", "BL-BR":"dijitTooltipLeft"}[aroundCorner + "-" + tooltipCorner];
	}, _onShow:function () {
		if (dojo.isIE) {
			this.domNode.style.filter = "";
		}
	}, hide:function (aroundNode) {
		if (this._onDeck && this._onDeck[1] == aroundNode) {
			this._onDeck = null;
		} else {
			if (this.aroundNode === aroundNode) {
				this.fadeIn.stop();
				this.isShowingNow = false;
				this.aroundNode = null;
				this.fadeOut.play();
			} else {
			}
		}
	}, _onHide:function () {
		this.domNode.style.cssText = "";
		if (this._onDeck) {
			this.show.apply(this, this._onDeck);
			this._onDeck = null;
		}
	}});
	dijit.showTooltip = function (innerHTML, aroundNode, position) {
		if (!dijit._masterTT) {
			dijit._masterTT = new dijit._MasterTooltip();
		}
		return dijit._masterTT.show(innerHTML, aroundNode, position);
	};
	dijit.hideTooltip = function (aroundNode) {
		if (!dijit._masterTT) {
			dijit._masterTT = new dijit._MasterTooltip();
		}
		return dijit._masterTT.hide(aroundNode);
	};
	dojo.declare("dijit.Tooltip", dijit._Widget, {label:"", showDelay:400, connectId:[], position:[], constructor:function () {
		this._nodeConnectionsById = {};
	}, _setConnectIdAttr:function (newIds) {
		for (var oldId in this._nodeConnectionsById) {
			this.removeTarget(oldId);
		}
		dojo.forEach(dojo.isArrayLike(newIds) ? newIds : [newIds], this.addTarget, this);
	}, _getConnectIdAttr:function () {
		var ary = [];
		for (var id in this._nodeConnectionsById) {
			ary.push(id);
		}
		return ary;
	}, addTarget:function (id) {
		var node = dojo.byId(id);
		if (!node) {
			return;
		}
		if (node.id in this._nodeConnectionsById) {
			return;
		}
		this._nodeConnectionsById[node.id] = [this.connect(node, "onmouseenter", "_onTargetMouseEnter"), this.connect(node, "onmouseleave", "_onTargetMouseLeave"), this.connect(node, "onfocus", "_onTargetFocus"), this.connect(node, "onblur", "_onTargetBlur")];
		if (dojo.isIE && !node.style.zoom) {
			node.style.zoom = 1;
		}
	}, removeTarget:function (node) {
		var id = node.id || node;
		if (id in this._nodeConnectionsById) {
			dojo.forEach(this._nodeConnectionsById[id], this.disconnect, this);
			delete this._nodeConnectionsById[id];
		}
	}, postCreate:function () {
		dojo.addClass(this.domNode, "dijitTooltipData");
	}, startup:function () {
		this.inherited(arguments);
		var ids = this.connectId;
		dojo.forEach(dojo.isArrayLike(ids) ? ids : [ids], this.addTarget, this);
	}, _onTargetMouseEnter:function (e) {
		this._onHover(e);
	}, _onTargetMouseLeave:function (e) {
		this._onUnHover(e);
	}, _onTargetFocus:function (e) {
		this._focus = true;
		this._onHover(e);
	}, _onTargetBlur:function (e) {
		this._focus = false;
		this._onUnHover(e);
	}, _onHover:function (e) {
		if (!this._showTimer) {
			var target = e.target;
			this._showTimer = setTimeout(dojo.hitch(this, function () {
				this.open(target);
			}), this.showDelay);
		}
	}, _onUnHover:function (e) {
		if (this._focus) {
			return;
		}
		if (this._showTimer) {
			clearTimeout(this._showTimer);
			delete this._showTimer;
		}
		this.close();
	}, open:function (target) {
		if (this._showTimer) {
			clearTimeout(this._showTimer);
			delete this._showTimer;
		}
		dijit.showTooltip(this.label || this.domNode.innerHTML, target, this.position);
		this._connectNode = target;
		this.onShow(target, this.position);
	}, close:function () {
		if (this._connectNode) {
			dijit.hideTooltip(this._connectNode);
			delete this._connectNode;
			this.onHide();
		}
		if (this._showTimer) {
			clearTimeout(this._showTimer);
			delete this._showTimer;
		}
	}, onShow:function (target, position) {
	}, onHide:function () {
	}, uninitialize:function () {
		this.close();
		this.inherited(arguments);
	}});
	dijit.Tooltip.defaultPosition = ["after", "before"];
}
if (!dojo._hasResource["dijit.form.ValidationTextBox"]) {
	dojo._hasResource["dijit.form.ValidationTextBox"] = true;
	dojo.provide("dijit.form.ValidationTextBox");
	dojo.declare("dijit.form.ValidationTextBox", dijit.form.TextBox, {templateString:dojo.cache("dijit.form", "templates/ValidationTextBox.html", "<div class=\"dijit dijitReset dijitInlineTable dijitLeft\"\r\n\tid=\"widget_${id}\"\r\n\tdojoAttachEvent=\"onmouseenter:_onMouse,onmouseleave:_onMouse,onmousedown:_onMouse\" waiRole=\"presentation\"\r\n\t><div style=\"overflow:hidden;\"\r\n\t\t><div class=\"dijitReset dijitValidationIcon\"><br></div\r\n\t\t><div class=\"dijitReset dijitValidationIconText\">&Chi;</div\r\n\t\t><div class=\"dijitReset dijitInputField\"\r\n\t\t\t><input class=\"dijitReset\" dojoAttachPoint='textbox,focusNode' autocomplete=\"off\"\r\n\t\t\t${nameAttrSetting} type='${type}'\r\n\t\t/></div\r\n\t></div\r\n></div>\r\n"), baseClass:"dijitTextBox", required:false, promptMessage:"", invalidMessage:"$_unset_$", constraints:{}, regExp:".*", regExpGen:function (constraints) {
		return this.regExp;
	}, state:"", tooltipPosition:[], _setValueAttr:function () {
		this.inherited(arguments);
		this.validate(this._focused);
	}, validator:function (value, constraints) {
		return (new RegExp("^(?:" + this.regExpGen(constraints) + ")" + (this.required ? "" : "?") + "$")).test(value) && (!this.required || !this._isEmpty(value)) && (this._isEmpty(value) || this.parse(value, constraints) !== undefined);
	}, _isValidSubset:function () {
		return this.textbox.value.search(this._partialre) == 0;
	}, isValid:function (isFocused) {
		return this.validator(this.textbox.value, this.constraints);
	}, _isEmpty:function (value) {
		return /^\s*$/.test(value);
	}, getErrorMessage:function (isFocused) {
		return this.invalidMessage;
	}, getPromptMessage:function (isFocused) {
		return this.promptMessage;
	}, _maskValidSubsetError:true, validate:function (isFocused) {
		var message = "";
		var isValid = this.disabled || this.isValid(isFocused);
		if (isValid) {
			this._maskValidSubsetError = true;
		}
		var isValidSubset = !isValid && isFocused && this._isValidSubset();
		var isEmpty = this._isEmpty(this.textbox.value);
		if (isEmpty) {
			this._maskValidSubsetError = true;
		}
		this.state = (isValid || (!this._hasBeenBlurred && isEmpty) || isValidSubset) ? "" : "Error";
		if (this.state == "Error") {
			this._maskValidSubsetError = false;
		}
		this._setStateClass();
		dijit.setWaiState(this.focusNode, "invalid", isValid ? "false" : "true");
		if (isFocused) {
			if (isEmpty) {
				message = this.getPromptMessage(true);
			}
			if (!message && (this.state == "Error" || (isValidSubset && !this._maskValidSubsetError))) {
				message = this.getErrorMessage(true);
			}
		}
		this.displayMessage(message);
		return isValid;
	}, _message:"", displayMessage:function (message) {
		if (this._message == message) {
			return;
		}
		this._message = message;
		dijit.hideTooltip(this.domNode);
		if (message) {
			dijit.showTooltip(message, this.domNode, this.tooltipPosition);
		}
	}, _refreshState:function () {
		this.validate(this._focused);
		this.inherited(arguments);
	}, constructor:function () {
		this.constraints = {};
	}, postMixInProperties:function () {
		this.inherited(arguments);
		this.constraints.locale = this.lang;
		this.messages = dojo.i18n.getLocalization("dijit.form", "validate", this.lang);
		if (this.invalidMessage == "$_unset_$") {
			this.invalidMessage = this.messages.invalidMessage;
		}
		var p = this.regExpGen(this.constraints);
		this.regExp = p;
		var partialre = "";
		if (p != ".*") {
			this.regExp.replace(/\\.|\[\]|\[.*?[^\\]{1}\]|\{.*?\}|\(\?[=:!]|./g, function (re) {
				switch (re.charAt(0)) {
				  case "{":
				  case "+":
				  case "?":
				  case "*":
				  case "^":
				  case "$":
				  case "|":
				  case "(":
					partialre += re;
					break;
				  case ")":
					partialre += "|$)";
					break;
				  default:
					partialre += "(?:" + re + "|$)";
					break;
				}
			});
		}
		try {
			"".search(partialre);
		}
		catch (e) {
			partialre = this.regExp;
			console.warn("RegExp error in " + this.declaredClass + ": " + this.regExp);
		}
		this._partialre = "^(?:" + partialre + ")$";
	}, _setDisabledAttr:function (value) {
		this.inherited(arguments);
		this._refreshState();
	}, _setRequiredAttr:function (value) {
		this.required = value;
		dijit.setWaiState(this.focusNode, "required", value);
		this._refreshState();
	}, postCreate:function () {
		if (dojo.isIE) {
			var s = dojo.getComputedStyle(this.focusNode);
			if (s) {
				var ff = s.fontFamily;
				if (ff) {
					this.focusNode.style.fontFamily = ff;
				}
			}
		}
		this.inherited(arguments);
	}, reset:function () {
		this._maskValidSubsetError = true;
		this.inherited(arguments);
	}, _onBlur:function () {
		this.displayMessage("");
		this.inherited(arguments);
	}});
	dojo.declare("dijit.form.MappedTextBox", dijit.form.ValidationTextBox, {postMixInProperties:function () {
		this.inherited(arguments);
		this.nameAttrSetting = "";
	}, serialize:function (val, options) {
		return val.toString ? val.toString() : "";
	}, toString:function () {
		var val = this.filter(this.attr("value"));
		return val != null ? (typeof val == "string" ? val : this.serialize(val, this.constraints)) : "";
	}, validate:function () {
		this.valueNode.value = this.toString();
		return this.inherited(arguments);
	}, buildRendering:function () {
		this.inherited(arguments);
		this.valueNode = dojo.place("<input type='hidden'" + (this.name ? " name='" + this.name + "'" : "") + ">", this.textbox, "after");
	}, reset:function () {
		this.valueNode.value = "";
		this.inherited(arguments);
	}});
	dojo.declare("dijit.form.RangeBoundTextBox", dijit.form.MappedTextBox, {rangeMessage:"", rangeCheck:function (primitive, constraints) {
		return ("min" in constraints ? (this.compare(primitive, constraints.min) >= 0) : true) && ("max" in constraints ? (this.compare(primitive, constraints.max) <= 0) : true);
	}, isInRange:function (isFocused) {
		return this.rangeCheck(this.attr("value"), this.constraints);
	}, _isDefinitelyOutOfRange:function () {
		var val = this.attr("value");
		var isTooLittle = false;
		var isTooMuch = false;
		if ("min" in this.constraints) {
			var min = this.constraints.min;
			min = this.compare(val, ((typeof min == "number") && min >= 0 && val != 0) ? 0 : min);
			isTooLittle = (typeof min == "number") && min < 0;
		}
		if ("max" in this.constraints) {
			var max = this.constraints.max;
			max = this.compare(val, ((typeof max != "number") || max > 0) ? max : 0);
			isTooMuch = (typeof max == "number") && max > 0;
		}
		return isTooLittle || isTooMuch;
	}, _isValidSubset:function () {
		return this.inherited(arguments) && !this._isDefinitelyOutOfRange();
	}, isValid:function (isFocused) {
		return this.inherited(arguments) && ((this._isEmpty(this.textbox.value) && !this.required) || this.isInRange(isFocused));
	}, getErrorMessage:function (isFocused) {
		var v = this.attr("value");
		if (v !== null && v !== "" && v !== undefined && !this.isInRange(isFocused)) {
			return this.rangeMessage;
		}
		return this.inherited(arguments);
	}, postMixInProperties:function () {
		this.inherited(arguments);
		if (!this.rangeMessage) {
			this.messages = dojo.i18n.getLocalization("dijit.form", "validate", this.lang);
			this.rangeMessage = this.messages.rangeMessage;
		}
	}, postCreate:function () {
		this.inherited(arguments);
		if (this.constraints.min !== undefined) {
			dijit.setWaiState(this.focusNode, "valuemin", this.constraints.min);
		}
		if (this.constraints.max !== undefined) {
			dijit.setWaiState(this.focusNode, "valuemax", this.constraints.max);
		}
	}, _setValueAttr:function (value, priorityChange) {
		dijit.setWaiState(this.focusNode, "valuenow", value);
		this.inherited(arguments);
	}});
}
if (!dojo._hasResource["dijit.form._DateTimeTextBox"]) {
	dojo._hasResource["dijit.form._DateTimeTextBox"] = true;
	dojo.provide("dijit.form._DateTimeTextBox");
	dojo.declare("dijit.form._DateTimeTextBox", dijit.form.RangeBoundTextBox, {regExpGen:dojo.date.locale.regexp, datePackage:"dojo.date", compare:dojo.date.compare, format:function (value, constraints) {
		if (!value) {
			return "";
		}
		return this.dateLocaleModule.format(value, constraints);
	}, parse:function (value, constraints) {
		return this.dateLocaleModule.parse(value, constraints) || (this._isEmpty(value) ? null : undefined);
	}, serialize:function (val, options) {
		if (val.toGregorian) {
			val = val.toGregorian();
		}
		return dojo.date.stamp.toISOString(val, options);
	}, value:new Date(""), _blankValue:null, popupClass:"", _selector:"", constructor:function (args) {
		var dateClass = args.datePackage ? args.datePackage + ".Date" : "Date";
		this.dateClassObj = dojo.getObject(dateClass, false);
		this.value = new this.dateClassObj("");
		this.datePackage = args.datePackage || this.datePackage;
		this.dateLocaleModule = dojo.getObject(this.datePackage + ".locale", false);
		this.regExpGen = this.dateLocaleModule.regexp;
	}, postMixInProperties:function () {
		this.inherited(arguments);
		if (!this.value || this.value.toString() == dijit.form._DateTimeTextBox.prototype.value.toString()) {
			this.value = null;
		}
		var constraints = this.constraints;
		constraints.selector = this._selector;
		constraints.fullYear = true;
		var fromISO = dojo.date.stamp.fromISOString;
		if (typeof constraints.min == "string") {
			constraints.min = fromISO(constraints.min);
		}
		if (typeof constraints.max == "string") {
			constraints.max = fromISO(constraints.max);
		}
	}, _onFocus:function (evt) {
		this._open();
		this.inherited(arguments);
	}, _setValueAttr:function (value, priorityChange, formattedValue) {
		if (value instanceof Date && !(this.dateClassObj instanceof Date)) {
			value = new this.dateClassObj(value);
		}
		this.inherited(arguments);
		if (this._picker) {
			if (!value) {
				if (this.declaredClass == "wm.IslamicDateTextbox") {
					value = new dojox.date.IslamicDate();
				} else {
					value = new this.dateClassObj();
				}
			}
			this._picker.attr("value", value);
		}
	}, _open:function () {
		if (this.disabled || this.readOnly || !this.popupClass) {
			return;
		}
		var textBox = this;
		if (!this._picker) {
			var PopupProto = dojo.getObject(this.popupClass, false);
			this._picker = new PopupProto({onValueSelected:function (value) {
				if (textBox._tabbingAway) {
					delete textBox._tabbingAway;
				} else {
					textBox.focus();
				}
				setTimeout(dojo.hitch(textBox, "_close"), 1);
				dijit.form._DateTimeTextBox.superclass._setValueAttr.call(textBox, value, true);
			}, id:this.id + "_popup", lang:textBox.lang, constraints:textBox.constraints, datePackage:textBox.datePackage, isDisabledDate:function (date) {
				var compare = dojo.date.compare;
				var constraints = textBox.constraints;
				return constraints && (constraints.min && (compare(constraints.min, date, textBox._selector) > 0) || (constraints.max && compare(constraints.max, date, textBox._selector) < 0));
			}, parentObj:textBox});
			var val = this.attr("value");
			if (!val) {
				if (this.declaredClass == "wm.IslamicDateTextbox") {
					val = new dojox.date.IslamicDate();
				} else {
					if (this.declaredClass == "wm.DualCalendar") {
						val = this.getDefaultDate();
					} else {
						val = new this.dateClassObj();
					}
				}
			}
			this._picker.attr("value", val);
		}
		if (!this._opened) {
			dijit.popup.open({parent:this, popup:this._picker, orient:{"BL":"TL", "TL":"BL"}, around:this.domNode, onCancel:dojo.hitch(this, this._close), onClose:function () {
				textBox._opened = false;
			}});
			this._opened = true;
		}
		dojo.marginBox(this._picker.domNode, {w:this.domNode.offsetWidth});
	}, _close:function () {
		if (this._opened) {
			if (this._picker.params) {
				delete this._picker.params.parentObj;
			}
			delete this._picker.parentObj;
			dijit.popup.close(this._picker);
			this._opened = false;
		}
	}, _onBlur:function () {
		this._close();
		if (this._picker) {
			this._picker.destroy();
			delete this._picker;
		}
		this.inherited(arguments);
	}, _getDisplayedValueAttr:function () {
		return this.textbox.value;
	}, _setDisplayedValueAttr:function (value, priorityChange) {
		this._setValueAttr(this.parse(value, this.constraints), priorityChange, value);
	}, destroy:function () {
		if (this._picker) {
			delete this._picker.parentObj;
			this._picker.destroy();
			delete this._picker;
		}
		this.inherited(arguments);
		try {
			if (this.focusNode) {
				dojo.destroy(this.focusNode);
			}
			if (this.textbox) {
				dojo.destroy(this.textbox);
			}
			if (this.valueNode) {
				dojo.destroy(this.valueNode);
			}
			if (this.params) {
				delete this.params.owner;
				delete this.params.srcNodeRef;
			}
			delete this.focusNode;
			delete this.textbox;
			delete this.valueNode;
			delete this.owner;
		}
		catch (e) {
			console.info("error while destroying dateTimeBox", e);
		}
	}, postCreate:function () {
		this.inherited(arguments);
		this.connect(this.focusNode, "onkeypress", this._onKeyPress);
		this.connect(this.focusNode, "onclick", this._open);
	}, _onKeyPress:function (e) {
		var p = this._picker, dk = dojo.keys;
		if (p && this._opened && p.handleKey) {
			if (p.handleKey(e) === false) {
				return;
			}
		}
		if (this._opened && e.charOrCode == dk.ESCAPE && !(e.shiftKey || e.ctrlKey || e.altKey || e.metaKey)) {
			this._close();
			dojo.stopEvent(e);
		} else {
			if (!this._opened && e.charOrCode == dk.DOWN_ARROW) {
				this._open();
				dojo.stopEvent(e);
			} else {
				if (e.charOrCode === dk.TAB) {
					this._tabbingAway = true;
				} else {
					if (this._opened && (e.keyChar || e.charOrCode === dk.BACKSPACE || e.charOrCode == dk.DELETE)) {
						setTimeout(dojo.hitch(this, function () {
							dijit.placeOnScreenAroundElement(p.domNode.parentNode, this.domNode, {"BL":"TL", "TL":"BL"}, p.orient ? dojo.hitch(p, "orient") : null);
						}), 1);
					}
				}
			}
		}
	}});
}
if (!dojo._hasResource["dijit.form.DateTextBox"]) {
	dojo._hasResource["dijit.form.DateTextBox"] = true;
	dojo.provide("dijit.form.DateTextBox");
	dojo.declare("dijit.form.DateTextBox", dijit.form._DateTimeTextBox, {baseClass:"dijitTextBox dijitDateTextBox", popupClass:"dijit.Calendar", _selector:"date", value:new Date("")});
}
if (!dojo._hasResource["dijit._TimePicker"]) {
	dojo._hasResource["dijit._TimePicker"] = true;
	dojo.provide("dijit._TimePicker");
	dojo.declare("dijit._TimePicker", [dijit._Widget, dijit._Templated], {templateString:dojo.cache("dijit", "templates/TimePicker.html", "<div id=\"widget_${id}\" class=\"dijitMenu ${baseClass}\"\r\n	><div dojoAttachPoint=\"upArrow\" class=\"dijitButtonNode dijitUpArrowButton\" dojoAttachEvent=\"onmouseenter:_buttonMouse,onmouseleave:_buttonMouse\"\r\n\t\t><div class=\"dijitReset dijitInline dijitArrowButtonInner\" wairole=\"presentation\" role=\"presentation\">&nbsp;</div\r\n\t\t><div class=\"dijitArrowButtonChar\">&#9650;</div></div\r\n	><div dojoAttachPoint=\"timeMenu,focusNode\" dojoAttachEvent=\"onclick:_onOptionSelected,onmouseover,onmouseout\"></div\r\n	><div dojoAttachPoint=\"downArrow\" class=\"dijitButtonNode dijitDownArrowButton\" dojoAttachEvent=\"onmouseenter:_buttonMouse,onmouseleave:_buttonMouse\"\r\n\t\t><div class=\"dijitReset dijitInline dijitArrowButtonInner\" wairole=\"presentation\" role=\"presentation\">&nbsp;</div\r\n\t\t><div class=\"dijitArrowButtonChar\">&#9660;</div></div\r\n></div>\r\n"), baseClass:"dijitTimePicker", clickableIncrement:"T00:15:00", visibleIncrement:"T01:00:00", visibleRange:"T05:00:00", value:new Date(), _visibleIncrement:2, _clickableIncrement:1, _totalIncrements:10, constraints:{}, serialize:dojo.date.stamp.toISOString, _filterString:"", setValue:function (value) {
		dojo.deprecated("dijit._TimePicker:setValue() is deprecated.  Use attr('value') instead.", "", "2.0");
		this.attr("value", value);
	}, _setValueAttr:function (date) {
		this.value = date;
		this._showText();
	}, onOpen:function (best) {
		if (this._beenOpened && this.domNode.parentNode) {
			var p = dijit.byId(this.domNode.parentNode.dijitPopupParent);
			if (p) {
				var val = p.attr("displayedValue");
				if (val && !p.parse(val, p.constraints)) {
					this._filterString = val;
				} else {
					this._filterString = "";
				}
				this._showText();
			}
		}
		this._beenOpened = true;
	}, isDisabledDate:function (dateObject, locale) {
		return false;
	}, _getFilteredNodes:function (start, maxNum, before) {
		var nodes = [], n, i = start, max = this._maxIncrement + Math.abs(i), chk = before ? -1 : 1, dec = before ? 1 : 0, inc = before ? 0 : 1;
		do {
			i = i - dec;
			n = this._createOption(i);
			if (n) {
				nodes.push(n);
			}
			i = i + inc;
		} while (nodes.length < maxNum && (i * chk) < max);
		if (before) {
			nodes.reverse();
		}
		return nodes;
	}, _showText:function () {
		this.timeMenu.innerHTML = "";
		var fromIso = dojo.date.stamp.fromISOString;
		this._clickableIncrementDate = fromIso(this.clickableIncrement);
		this._visibleIncrementDate = fromIso(this.visibleIncrement);
		this._visibleRangeDate = fromIso(this.visibleRange);
		var sinceMidnight = function (date) {
			return date.getHours() * 60 * 60 + date.getMinutes() * 60 + date.getSeconds();
		};
		var clickableIncrementSeconds = sinceMidnight(this._clickableIncrementDate);
		var visibleIncrementSeconds = sinceMidnight(this._visibleIncrementDate);
		var visibleRangeSeconds = sinceMidnight(this._visibleRangeDate);
		var time = this.value.getTime();
		this._refDate = new Date(time - time % (visibleIncrementSeconds * 1000));
		this._refDate.setFullYear(1970, 0, 1);
		this._clickableIncrement = 1;
		this._totalIncrements = visibleRangeSeconds / clickableIncrementSeconds;
		this._visibleIncrement = visibleIncrementSeconds / clickableIncrementSeconds;
		this._maxIncrement = (60 * 60 * 24) / clickableIncrementSeconds;
		var before = this._getFilteredNodes(0, this._totalIncrements >> 1, true);
		var after = this._getFilteredNodes(0, this._totalIncrements >> 1, false);
		if (before.length < this._totalIncrements >> 1) {
			before = before.slice(before.length / 2);
			after = after.slice(0, after.length / 2);
		}
		dojo.forEach(before.concat(after), function (n) {
			this.timeMenu.appendChild(n);
		}, this);
	}, postCreate:function () {
		if (this.constraints === dijit._TimePicker.prototype.constraints) {
			this.constraints = {};
		}
		dojo.mixin(this, this.constraints);
		if (!this.constraints.locale) {
			this.constraints.locale = this.lang;
		}
		this.connect(this.timeMenu, dojo.isIE ? "onmousewheel" : "DOMMouseScroll", "_mouseWheeled");
		var _this = this;
		var typematic = function () {
			_this._connects.push(dijit.typematic.addMouseListener.apply(null, arguments));
		};
		typematic(this.upArrow, this, this._onArrowUp, 1, 50);
		typematic(this.downArrow, this, this._onArrowDown, 1, 50);
		var triggerFx = function (cb) {
			return function (cnt) {
				if (cnt > 0) {
					cb.call(this, arguments);
				}
			};
		};
		var hoverFx = function (node, cb) {
			return function (e) {
				dojo.stopEvent(e);
				dijit.typematic.trigger(e, this, node, triggerFx(cb), node, 1, 50);
			};
		};
		this.connect(this.upArrow, "onmouseover", hoverFx(this.upArrow, this._onArrowUp));
		this.connect(this.downArrow, "onmouseover", hoverFx(this.downArrow, this._onArrowDown));
		this.inherited(arguments);
	}, _buttonMouse:function (e) {
		dojo.toggleClass(e.currentTarget, "dijitButtonNodeHover", e.type == "mouseover");
	}, _createOption:function (index) {
		var date = new Date(this._refDate);
		var incrementDate = this._clickableIncrementDate;
		date.setHours(date.getHours() + incrementDate.getHours() * index, date.getMinutes() + incrementDate.getMinutes() * index, date.getSeconds() + incrementDate.getSeconds() * index);
		if (this.constraints.selector == "time") {
			date.setFullYear(1970, 0, 1);
		}
		var dateString = dojo.date.locale.format(date, this.constraints);
		if (this._filterString && dateString.toLowerCase().indexOf(this._filterString) !== 0) {
			return null;
		}
		var div = dojo.create("div", {"class":this.baseClass + "Item"});
		div.date = date;
		div.index = index;
		dojo.create("div", {"class":this.baseClass + "ItemInner", innerHTML:dateString}, div);
		if (index % this._visibleIncrement < 1 && index % this._visibleIncrement > -1) {
			dojo.addClass(div, this.baseClass + "Marker");
		} else {
			if (!(index % this._clickableIncrement)) {
				dojo.addClass(div, this.baseClass + "Tick");
			}
		}
		if (this.isDisabledDate(date)) {
			dojo.addClass(div, this.baseClass + "ItemDisabled");
		}
		if (!dojo.date.compare(this.value, date, this.constraints.selector)) {
			div.selected = true;
			dojo.addClass(div, this.baseClass + "ItemSelected");
			if (dojo.hasClass(div, this.baseClass + "Marker")) {
				dojo.addClass(div, this.baseClass + "MarkerSelected");
			} else {
				dojo.addClass(div, this.baseClass + "TickSelected");
			}
		}
		return div;
	}, _onOptionSelected:function (tgt) {
		var tdate = tgt.target.date || tgt.target.parentNode.date;
		if (!tdate || this.isDisabledDate(tdate)) {
			return;
		}
		this._highlighted_option = null;
		this.attr("value", tdate);
		this.onValueSelected(tdate);
	}, onValueSelected:function (time) {
	}, _highlightOption:function (node, highlight) {
		if (!node) {
			return;
		}
		if (highlight) {
			if (this._highlighted_option) {
				this._highlightOption(this._highlighted_option, false);
			}
			this._highlighted_option = node;
		} else {
			if (this._highlighted_option !== node) {
				return;
			} else {
				this._highlighted_option = null;
			}
		}
		dojo.toggleClass(node, this.baseClass + "ItemHover", highlight);
		if (dojo.hasClass(node, this.baseClass + "Marker")) {
			dojo.toggleClass(node, this.baseClass + "MarkerHover", highlight);
		} else {
			dojo.toggleClass(node, this.baseClass + "TickHover", highlight);
		}
	}, onmouseover:function (e) {
		this._keyboardSelected = null;
		var tgr = (e.target.parentNode === this.timeMenu) ? e.target : e.target.parentNode;
		if (!dojo.hasClass(tgr, this.baseClass + "Item")) {
			return;
		}
		this._highlightOption(tgr, true);
	}, onmouseout:function (e) {
		this._keyboardSelected = null;
		var tgr = (e.target.parentNode === this.timeMenu) ? e.target : e.target.parentNode;
		this._highlightOption(tgr, false);
	}, _mouseWheeled:function (e) {
		this._keyboardSelected = null;
		dojo.stopEvent(e);
		var scrollAmount = (dojo.isIE ? e.wheelDelta : -e.detail);
		this[(scrollAmount > 0 ? "_onArrowUp" : "_onArrowDown")]();
	}, _onArrowUp:function (count) {
		if (typeof count == "number" && count == -1) {
			return;
		}
		if (!this.timeMenu.childNodes.length) {
			return;
		}
		var index = this.timeMenu.childNodes[0].index;
		var divs = this._getFilteredNodes(index, 1, true);
		if (divs.length) {
			this.timeMenu.removeChild(this.timeMenu.childNodes[this.timeMenu.childNodes.length - 1]);
			this.timeMenu.insertBefore(divs[0], this.timeMenu.childNodes[0]);
		}
	}, _onArrowDown:function (count) {
		if (typeof count == "number" && count == -1) {
			return;
		}
		if (!this.timeMenu.childNodes.length) {
			return;
		}
		var index = this.timeMenu.childNodes[this.timeMenu.childNodes.length - 1].index + 1;
		var divs = this._getFilteredNodes(index, 1, false);
		if (divs.length) {
			this.timeMenu.removeChild(this.timeMenu.childNodes[0]);
			this.timeMenu.appendChild(divs[0]);
		}
	}, handleKey:function (e) {
		var dk = dojo.keys;
		if (e.keyChar || e.charOrCode === dk.BACKSPACE || e.charOrCode == dk.DELETE) {
			setTimeout(dojo.hitch(this, function () {
				this._filterString = e.target.value.toLowerCase();
				this._showText();
			}), 1);
		} else {
			if (e.charOrCode == dk.DOWN_ARROW || e.charOrCode == dk.UP_ARROW) {
				dojo.stopEvent(e);
				if (this._highlighted_option && !this._highlighted_option.parentNode) {
					this._highlighted_option = null;
				}
				var timeMenu = this.timeMenu, tgt = this._highlighted_option || dojo.query("." + this.baseClass + "ItemSelected", timeMenu)[0];
				if (!tgt) {
					tgt = timeMenu.childNodes[0];
				} else {
					if (timeMenu.childNodes.length) {
						if (e.charOrCode == dk.DOWN_ARROW && !tgt.nextSibling) {
							this._onArrowDown();
						} else {
							if (e.charOrCode == dk.UP_ARROW && !tgt.previousSibling) {
								this._onArrowUp();
							}
						}
						if (e.charOrCode == dk.DOWN_ARROW) {
							tgt = tgt.nextSibling;
						} else {
							tgt = tgt.previousSibling;
						}
					}
				}
				this._highlightOption(tgt, true);
				this._keyboardSelected = tgt;
			} else {
				if (this._highlighted_option && (e.charOrCode == dk.ENTER || e.charOrCode === dk.TAB)) {
					if (!this._keyboardSelected && e.charOrCode === dk.TAB) {
						return;
					}
					if (e.charOrCode == dk.ENTER) {
						dojo.stopEvent(e);
					}
					this._onOptionSelected({target:this._highlighted_option});
				}
			}
		}
	}});
}
if (!dojo._hasResource["dijit.form.TimeTextBox"]) {
	dojo._hasResource["dijit.form.TimeTextBox"] = true;
	dojo.provide("dijit.form.TimeTextBox");
	dojo.declare("dijit.form.TimeTextBox", dijit.form._DateTimeTextBox, {baseClass:"dijitTextBox dijitTimeTextBox", popupClass:"dijit._TimePicker", _selector:"time", value:new Date("")});
}
if (!dojo._hasResource["dojo.data.util.filter"]) {
	dojo._hasResource["dojo.data.util.filter"] = true;
	dojo.provide("dojo.data.util.filter");
	dojo.data.util.filter.patternToRegExp = function (pattern, ignoreCase) {
		var rxp = "^";
		var c = null;
		for (var i = 0; i < pattern.length; i++) {
			c = pattern.charAt(i);
			switch (c) {
			  case "\\":
				rxp += c;
				i++;
				rxp += pattern.charAt(i);
				break;
			  case "*":
				rxp += ".*";
				break;
			  case "?":
				rxp += ".";
				break;
			  case "$":
			  case "^":
			  case "/":
			  case "+":
			  case ".":
			  case "|":
			  case "(":
			  case ")":
			  case "{":
			  case "}":
			  case "[":
			  case "]":
				rxp += "\\";
			  default:
				rxp += c;
			}
		}
		rxp += "$";
		if (ignoreCase) {
			return new RegExp(rxp, "mi");
		} else {
			return new RegExp(rxp, "m");
		}
	};
}
if (!dojo._hasResource["dijit.form.ComboBox"]) {
	dojo._hasResource["dijit.form.ComboBox"] = true;
	dojo.provide("dijit.form.ComboBox");
	dojo.declare("dijit.form.ComboBoxMixin", null, {item:null, pageSize:Infinity, store:null, fetchProperties:{}, query:{}, autoComplete:true, highlightMatch:"first", searchDelay:100, searchAttr:"name", labelAttr:"", labelType:"text", queryExpr:"${0}*", ignoreCase:true, hasDownArrow:true, templateString:dojo.cache("dijit.form", "templates/ComboBox.html", "<div class=\"dijit dijitReset dijitInlineTable dijitLeft\"\r\n\tid=\"widget_${id}\"\r\n\tdojoAttachEvent=\"onmouseenter:_onMouse,onmouseleave:_onMouse,onmousedown:_onMouse\" dojoAttachPoint=\"comboNode\" waiRole=\"combobox\" tabIndex=\"-1\"\r\n\t><div style=\"overflow:hidden;\"\r\n\t\t><div class='dijitReset dijitRight dijitButtonNode dijitArrowButton dijitDownArrowButton'\r\n\t\t\tdojoAttachPoint=\"downArrowNode\" waiRole=\"presentation\"\r\n\t\t\tdojoAttachEvent=\"onmousedown:_onArrowMouseDown,onmouseup:_onMouse,onmouseenter:_onMouse,onmouseleave:_onMouse\"\r\n\t\t\t><div class=\"dijitArrowButtonInner\">&thinsp;</div\r\n\t\t\t><div class=\"dijitArrowButtonChar\">&#9660;</div\r\n\t\t></div\r\n\t\t><div class=\"dijitReset dijitValidationIcon\"><br></div\r\n\t\t><div class=\"dijitReset dijitValidationIconText\">&Chi;</div\r\n\t\t><div class=\"dijitReset dijitInputField\"\r\n\t\t\t><input ${nameAttrSetting} type=\"text\" autocomplete=\"off\" class='dijitReset'\r\n\t\t\tdojoAttachEvent=\"onkeypress:_onKeyPress,compositionend\"\r\n\t\t\tdojoAttachPoint=\"textbox,focusNode\" waiRole=\"textbox\" waiState=\"haspopup-true,autocomplete-list\"\r\n\t\t/></div\r\n\t></div\r\n></div>\r\n"), baseClass:"dijitComboBox", _getCaretPos:function (element) {
		var pos = 0;
		if (typeof (element.selectionStart) == "number") {
			pos = element.selectionStart;
		} else {
			if (dojo.isIE) {
				var tr = dojo.doc.selection.createRange().duplicate();
				var ntr = element.createTextRange();
				tr.move("character", 0);
				ntr.move("character", 0);
				try {
					ntr.setEndPoint("EndToEnd", tr);
					pos = String(ntr.text).replace(/\r/g, "").length;
				}
				catch (e) {
				}
			}
		}
		return pos;
	}, _setCaretPos:function (element, location) {
		location = parseInt(location);
		dijit.selectInputText(element, location, location);
	}, _setDisabledAttr:function (value) {
		this.inherited(arguments);
		dijit.setWaiState(this.comboNode, "disabled", value);
	}, _abortQuery:function () {
		if (this.searchTimer) {
			clearTimeout(this.searchTimer);
			this.searchTimer = null;
		}
		if (this._fetchHandle) {
			if (this._fetchHandle.abort) {
				this._fetchHandle.abort();
			}
			this._fetchHandle = null;
		}
	}, _onKeyPress:function (evt) {
		var key = evt.charOrCode;
		if (evt.altKey || ((evt.ctrlKey || evt.metaKey) && (key != "x" && key != "v")) || key == dojo.keys.SHIFT) {
			return;
		}
		var doSearch = false;
		var searchFunction = "_startSearchFromInput";
		var pw = this._popupWidget;
		var dk = dojo.keys;
		var highlighted = null;
		this._prev_key_backspace = false;
		this._abortQuery();
		if (this._isShowingNow) {
			pw.handleKey(key);
			highlighted = pw.getHighlightedOption();
		}
		switch (key) {
		  case dk.PAGE_DOWN:
		  case dk.DOWN_ARROW:
		  case dk.PAGE_UP:
		  case dk.UP_ARROW:
			if (!this._isShowingNow) {
				this._arrowPressed();
				doSearch = true;
				searchFunction = "_startSearchAll";
			} else {
				this._announceOption(highlighted);
			}
			dojo.stopEvent(evt);
			break;
		  case dk.ENTER:
			if (highlighted) {
				if (highlighted == pw.nextButton) {
					this._nextSearch(1);
					dojo.stopEvent(evt);
					break;
				} else {
					if (highlighted == pw.previousButton) {
						this._nextSearch(-1);
						dojo.stopEvent(evt);
						break;
					}
				}
			} else {
				this._setBlurValue();
				this._setCaretPos(this.focusNode, this.focusNode.value.length);
			}
			evt.preventDefault();
		  case dk.TAB:
			var newvalue = this.attr("displayedValue");
			if (pw && (newvalue == pw._messages["previousMessage"] || newvalue == pw._messages["nextMessage"])) {
				break;
			}
			if (highlighted) {
				this._selectOption();
			}
			if (this._isShowingNow) {
				this._lastQuery = null;
				this._hideResultList();
			}
			break;
		  case " ":
			if (highlighted) {
				dojo.stopEvent(evt);
				this._selectOption();
				this._hideResultList();
			} else {
				doSearch = true;
			}
			break;
		  case dk.ESCAPE:
			if (this._isShowingNow) {
				dojo.stopEvent(evt);
				this._hideResultList();
			}
			break;
		  case dk.DELETE:
		  case dk.BACKSPACE:
			this._prev_key_backspace = true;
			doSearch = true;
			break;
		  default:
			doSearch = typeof key == "string" || key == 229;
		}
		if (doSearch) {
			this.item = undefined;
			this.searchTimer = setTimeout(dojo.hitch(this, searchFunction), 1);
		}
	}, _autoCompleteText:function (text) {
		var fn = this.focusNode;
		dijit.selectInputText(fn, fn.value.length);
		var caseFilter = this.ignoreCase ? "toLowerCase" : "substr";
		if (text[caseFilter](0).indexOf(this.focusNode.value[caseFilter](0)) == 0) {
			var cpos = this._getCaretPos(fn);
			if ((cpos + 1) > fn.value.length) {
				fn.value = text;
				dijit.selectInputText(fn, cpos);
			}
		} else {
			fn.value = text;
			dijit.selectInputText(fn);
		}
	}, _openResultList:function (results, dataObject) {
		this._fetchHandle = null;
		if (this.disabled || this.readOnly || (dataObject.query[this.searchAttr] != this._lastQuery)) {
			return;
		}
		this._popupWidget.clearResultList();
		if (!results.length) {
			this._hideResultList();
			return;
		}
		dataObject._maxOptions = this._maxOptions;
		var nodes = this._popupWidget.createOptions(results, dataObject, dojo.hitch(this, "_getMenuLabelFromItem"));
		this._showResultList();
		if (dataObject.direction) {
			if (1 == dataObject.direction) {
				this._popupWidget.highlightFirstOption();
			} else {
				if (-1 == dataObject.direction) {
					this._popupWidget.highlightLastOption();
				}
			}
			this._announceOption(this._popupWidget.getHighlightedOption());
		} else {
			if (this.autoComplete && !this._prev_key_backspace && !/^[*]+$/.test(dataObject.query[this.searchAttr])) {
				this._announceOption(nodes[1]);
			}
		}
	}, _showResultList:function () {
		this._hideResultList();
		this._arrowPressed();
		this.displayMessage("");
		dojo.style(this._popupWidget.domNode, {width:"", height:""});
		var best = this.open();
		var popupbox = dojo.marginBox(this._popupWidget.domNode);
		this._popupWidget.domNode.style.overflow = ((best.h == popupbox.h) && (best.w == popupbox.w)) ? "hidden" : "auto";
		var newwidth = best.w;
		if (best.h < this._popupWidget.domNode.scrollHeight) {
			newwidth += 16;
		}
		dojo.marginBox(this._popupWidget.domNode, {h:best.h, w:Math.max(newwidth, this.domNode.offsetWidth)});
		if (newwidth < this.domNode.offsetWidth) {
			this._popupWidget.domNode.parentNode.style.left = dojo.position(this.domNode).x + "px";
		}
		dijit.setWaiState(this.comboNode, "expanded", "true");
	}, _hideResultList:function () {
		this._abortQuery();
		if (this._isShowingNow) {
			dijit.popup.close(this._popupWidget);
			this._arrowIdle();
			this._isShowingNow = false;
			dijit.setWaiState(this.comboNode, "expanded", "false");
			dijit.removeWaiState(this.focusNode, "activedescendant");
		}
	}, _setBlurValue:function () {
		var newvalue = this.attr("displayedValue");
		var pw = this._popupWidget;
		if (pw && (newvalue == pw._messages["previousMessage"] || newvalue == pw._messages["nextMessage"])) {
			this._setValueAttr(this._lastValueReported, true);
		} else {
			if (typeof this.item == "undefined") {
				this.item = null;
				this.attr("displayedValue", newvalue);
			} else {
				if (this.value != this._lastValueReported) {
					dijit.form._FormValueWidget.prototype._setValueAttr.call(this, this.value, true);
				}
				this._refreshState();
			}
		}
	}, _onBlur:function () {
		this._hideResultList();
		this._arrowIdle();
		this.inherited(arguments);
	}, _setItemAttr:function (item, priorityChange, displayedValue) {
		if (!displayedValue) {
			displayedValue = this.labelFunc(item, this.store);
		}
		this.value = this._getValueField() != this.searchAttr ? this.store.getIdentity(item) : displayedValue;
		this.item = item;
		dijit.form.ComboBox.superclass._setValueAttr.call(this, this.value, priorityChange, displayedValue);
	}, _announceOption:function (node) {
		if (!node) {
			return;
		}
		var newValue;
		if (node == this._popupWidget.nextButton || node == this._popupWidget.previousButton) {
			newValue = node.innerHTML;
			this.item = undefined;
			this.value = "";
		} else {
			newValue = this.labelFunc(node.item, this.store);
			this.attr("item", node.item, false, newValue);
		}
		this.focusNode.value = this.focusNode.value.substring(0, this._lastInput.length);
		dijit.setWaiState(this.focusNode, "activedescendant", dojo.attr(node, "id"));
		this._autoCompleteText(newValue);
	}, _selectOption:function (evt) {
		if (evt) {
			this._announceOption(evt.target);
		}
		this._hideResultList();
		this._setCaretPos(this.focusNode, this.focusNode.value.length);
		dijit.form._FormValueWidget.prototype._setValueAttr.call(this, this.value, true);
	}, _onArrowMouseDown:function (evt) {
		if (this.disabled || this.readOnly) {
			return;
		}
		dojo.stopEvent(evt);
		this.focus();
		if (this._isShowingNow) {
			this._hideResultList();
		} else {
			this._startSearchAll();
		}
	}, _startSearchAll:function () {
		this._startSearch("");
	}, _startSearchFromInput:function () {
		this._startSearch(this.focusNode.value.replace(/([\\\*\?])/g, "\\$1"));
	}, _getQueryString:function (text) {
		return dojo.string.substitute(this.queryExpr, [text]);
	}, _startSearch:function (key) {
		if (!this._popupWidget) {
			var popupId = this.id + "_popup";
			this._popupWidget = new dijit.form._ComboBoxMenu({onChange:dojo.hitch(this, this._selectOption), id:popupId});
			dijit.removeWaiState(this.focusNode, "activedescendant");
			dijit.setWaiState(this.textbox, "owns", popupId);
		}
		var query = dojo.clone(this.query);
		this._lastInput = key;
		this._lastQuery = query[this.searchAttr] = this._getQueryString(key);
		this.searchTimer = setTimeout(dojo.hitch(this, function (query, _this) {
			this.searchTimer = null;
			var fetch = {queryOptions:{ignoreCase:this.ignoreCase, deep:true}, query:query, onBegin:dojo.hitch(this, "_setMaxOptions"), onComplete:dojo.hitch(this, "_openResultList"), onError:function (errText) {
				_this._fetchHandle = null;
				console.error("dijit.form.ComboBox: " + errText);
				dojo.hitch(_this, "_hideResultList")();
			}, start:0, count:this.pageSize};
			dojo.mixin(fetch, _this.fetchProperties);
			this._fetchHandle = _this.store.fetch(fetch);
			var nextSearch = function (dataObject, direction) {
				dataObject.start += dataObject.count * direction;
				dataObject.direction = direction;
				this._fetchHandle = this.store.fetch(dataObject);
			};
			this._nextSearch = this._popupWidget.onPage = dojo.hitch(this, nextSearch, this._fetchHandle);
		}, query, this), this.searchDelay);
	}, _setMaxOptions:function (size, request) {
		this._maxOptions = size;
	}, _getValueField:function () {
		return this.searchAttr;
	}, _arrowPressed:function () {
		if (!this.disabled && !this.readOnly && this.hasDownArrow) {
			dojo.addClass(this.downArrowNode, "dijitArrowButtonActive");
		}
	}, _arrowIdle:function () {
		if (!this.disabled && !this.readOnly && this.hasDownArrow) {
			dojo.removeClass(this.downArrowNode, "dojoArrowButtonPushed");
		}
	}, compositionend:function (evt) {
		this._onKeyPress({charOrCode:229});
	}, constructor:function () {
		this.query = {};
		this.fetchProperties = {};
	}, postMixInProperties:function () {
		if (!this.hasDownArrow) {
			this.baseClass = "dijitTextBox";
		}
		if (!this.store) {
			var srcNodeRef = this.srcNodeRef;
			this.store = new dijit.form._ComboBoxDataStore(srcNodeRef);
			if (!this.value || ((typeof srcNodeRef.selectedIndex == "number") && srcNodeRef.selectedIndex.toString() === this.value)) {
				var item = this.store.fetchSelectedItem();
				if (item) {
					var valueField = this._getValueField();
					this.value = valueField != this.searchAttr ? this.store.getValue(item, valueField) : this.labelFunc(item, this.store);
				}
			}
		}
		this.inherited(arguments);
	}, postCreate:function () {
		var label = dojo.query("label[for=\"" + this.id + "\"]");
		if (label.length) {
			label[0].id = (this.id + "_label");
			var cn = this.comboNode;
			dijit.setWaiState(cn, "labelledby", label[0].id);
		}
		this.inherited(arguments);
	}, uninitialize:function () {
		if (this._popupWidget && !this._popupWidget._destroyed) {
			this._hideResultList();
			this._popupWidget.destroy();
		}
		this.inherited(arguments);
	}, _getMenuLabelFromItem:function (item) {
		var label = this.labelAttr ? this.store.getValue(item, this.labelAttr) : this.labelFunc(item, this.store);
		var labelType = this.labelType;
		if (this.highlightMatch != "none" && this.labelType == "text" && this._lastInput) {
			label = this.doHighlight(label, this._escapeHtml(this._lastInput));
			labelType = "html";
		}
		return {html:labelType == "html", label:label};
	}, doHighlight:function (label, find) {
		var modifiers = "i" + (this.highlightMatch == "all" ? "g" : "");
		var escapedLabel = this._escapeHtml(label);
		find = dojo.regexp.escapeString(find);
		var ret = escapedLabel.replace(new RegExp("(^|\\s)(" + find + ")", modifiers), "$1<span class=\"dijitComboBoxHighlightMatch\">$2</span>");
		return ret;
	}, _escapeHtml:function (str) {
		str = String(str).replace(/&/gm, "&amp;").replace(/</gm, "&lt;").replace(/>/gm, "&gt;").replace(/"/gm, "&quot;");
		return str;
	}, open:function () {
		this._isShowingNow = true;
		return dijit.popup.open({popup:this._popupWidget, around:this.domNode, parent:this});
	}, reset:function () {
		this.item = null;
		this.inherited(arguments);
	}, labelFunc:function (item, store) {
		return store.getValue(item, this.searchAttr).toString();
	}});
	dojo.declare("dijit.form._ComboBoxMenu", [dijit._Widget, dijit._Templated], {templateString:"<ul class='dijitReset dijitMenu' dojoAttachEvent='onmousedown:_onMouseDown,onmouseup:_onMouseUp,onmouseover:_onMouseOver,onmouseout:_onMouseOut' tabIndex='-1' style='overflow: \"auto\"; overflow-x: \"hidden\";'>" + "<li class='dijitMenuItem dijitMenuPreviousButton' dojoAttachPoint='previousButton' waiRole='option'></li>" + "<li class='dijitMenuItem dijitMenuNextButton' dojoAttachPoint='nextButton' waiRole='option'></li>" + "</ul>", _messages:null, postMixInProperties:function () {
		this._messages = dojo.i18n.getLocalization("dijit.form", "ComboBox", this.lang);
		this.inherited(arguments);
	}, _setValueAttr:function (value) {
		this.value = value;
		this.onChange(value);
	}, onChange:function (value) {
	}, onPage:function (direction) {
	}, postCreate:function () {
		this.previousButton.innerHTML = this._messages["previousMessage"];
		this.nextButton.innerHTML = this._messages["nextMessage"];
		this.inherited(arguments);
	}, onClose:function () {
		this._blurOptionNode();
	}, _createOption:function (item, labelFunc) {
		var labelObject = labelFunc(item);
		var menuitem = dojo.doc.createElement("li");
		dijit.setWaiRole(menuitem, "option");
		if (labelObject.html) {
			menuitem.innerHTML = labelObject.label;
		} else {
			menuitem.appendChild(dojo.doc.createTextNode(labelObject.label));
		}
		if (menuitem.innerHTML == "") {
			menuitem.innerHTML = "&nbsp;";
		}
		menuitem.item = item;
		return menuitem;
	}, createOptions:function (results, dataObject, labelFunc) {
		this.previousButton.style.display = (dataObject.start == 0) ? "none" : "";
		dojo.attr(this.previousButton, "id", this.id + "_prev");
		dojo.forEach(results, function (item, i) {
			var menuitem = this._createOption(item, labelFunc);
			menuitem.className = "dijitReset dijitMenuItem";
			dojo.attr(menuitem, "id", this.id + i);
			this.domNode.insertBefore(menuitem, this.nextButton);
		}, this);
		var displayMore = false;
		if (dataObject._maxOptions && dataObject._maxOptions != -1) {
			if ((dataObject.start + dataObject.count) < dataObject._maxOptions) {
				displayMore = true;
			} else {
				if ((dataObject.start + dataObject.count) > (dataObject._maxOptions - 1)) {
					if (dataObject.count == results.length) {
						displayMore = true;
					}
				}
			}
		} else {
			if (dataObject.count == results.length) {
				displayMore = true;
			}
		}
		this.nextButton.style.display = displayMore ? "" : "none";
		dojo.attr(this.nextButton, "id", this.id + "_next");
		return this.domNode.childNodes;
	}, clearResultList:function () {
		while (this.domNode.childNodes.length > 2) {
			this.domNode.removeChild(this.domNode.childNodes[this.domNode.childNodes.length - 2]);
		}
	}, _onMouseDown:function (evt) {
		dojo.stopEvent(evt);
	}, _onMouseUp:function (evt) {
		if (evt.target === this.domNode) {
			return;
		} else {
			if (evt.target == this.previousButton) {
				this.onPage(-1);
			} else {
				if (evt.target == this.nextButton) {
					this.onPage(1);
				} else {
					var tgt = evt.target;
					while (!tgt.item) {
						tgt = tgt.parentNode;
					}
					this._setValueAttr({target:tgt}, true);
				}
			}
		}
	}, _onMouseOver:function (evt) {
		if (evt.target === this.domNode) {
			return;
		}
		var tgt = evt.target;
		if (!(tgt == this.previousButton || tgt == this.nextButton)) {
			while (!tgt.item) {
				tgt = tgt.parentNode;
			}
		}
		this._focusOptionNode(tgt);
	}, _onMouseOut:function (evt) {
		if (evt.target === this.domNode) {
			return;
		}
		this._blurOptionNode();
	}, _focusOptionNode:function (node) {
		if (this._highlighted_option != node) {
			this._blurOptionNode();
			this._highlighted_option = node;
			dojo.addClass(this._highlighted_option, "dijitMenuItemSelected");
		}
	}, _blurOptionNode:function () {
		if (this._highlighted_option) {
			dojo.removeClass(this._highlighted_option, "dijitMenuItemSelected");
			this._highlighted_option = null;
		}
	}, _highlightNextOption:function () {
		var fc = this.domNode.firstChild;
		if (!this.getHighlightedOption()) {
			this._focusOptionNode(fc.style.display == "none" ? fc.nextSibling : fc);
		} else {
			var ns = this._highlighted_option.nextSibling;
			if (ns && ns.style.display != "none") {
				this._focusOptionNode(ns);
			}
		}
		dijit.scrollIntoView(this._highlighted_option);
	}, highlightFirstOption:function () {
		this._focusOptionNode(this.domNode.firstChild.nextSibling);
		dijit.scrollIntoView(this._highlighted_option);
	}, highlightLastOption:function () {
		this._focusOptionNode(this.domNode.lastChild.previousSibling);
		dijit.scrollIntoView(this._highlighted_option);
	}, _highlightPrevOption:function () {
		var lc = this.domNode.lastChild;
		if (!this.getHighlightedOption()) {
			this._focusOptionNode(lc.style.display == "none" ? lc.previousSibling : lc);
		} else {
			var ps = this._highlighted_option.previousSibling;
			if (ps && ps.style.display != "none") {
				this._focusOptionNode(ps);
			}
		}
		dijit.scrollIntoView(this._highlighted_option);
	}, _page:function (up) {
		var scrollamount = 0;
		var oldscroll = this.domNode.scrollTop;
		var height = dojo.style(this.domNode, "height");
		if (!this.getHighlightedOption()) {
			this._highlightNextOption();
		}
		while (scrollamount < height) {
			if (up) {
				if (!this.getHighlightedOption().previousSibling || this._highlighted_option.previousSibling.style.display == "none") {
					break;
				}
				this._highlightPrevOption();
			} else {
				if (!this.getHighlightedOption().nextSibling || this._highlighted_option.nextSibling.style.display == "none") {
					break;
				}
				this._highlightNextOption();
			}
			var newscroll = this.domNode.scrollTop;
			scrollamount += (newscroll - oldscroll) * (up ? -1 : 1);
			oldscroll = newscroll;
		}
	}, pageUp:function () {
		this._page(true);
	}, pageDown:function () {
		this._page(false);
	}, getHighlightedOption:function () {
		var ho = this._highlighted_option;
		return (ho && ho.parentNode) ? ho : null;
	}, handleKey:function (key) {
		switch (key) {
		  case dojo.keys.DOWN_ARROW:
			this._highlightNextOption();
			break;
		  case dojo.keys.PAGE_DOWN:
			this.pageDown();
			break;
		  case dojo.keys.UP_ARROW:
			this._highlightPrevOption();
			break;
		  case dojo.keys.PAGE_UP:
			this.pageUp();
			break;
		}
	}});
	dojo.declare("dijit.form.ComboBox", [dijit.form.ValidationTextBox, dijit.form.ComboBoxMixin], {_setValueAttr:function (value, priorityChange, displayedValue) {
		this.item = null;
		if (!value) {
			value = "";
		}
		dijit.form.ValidationTextBox.prototype._setValueAttr.call(this, value, priorityChange, displayedValue);
	}});
	dojo.declare("dijit.form._ComboBoxDataStore", null, {constructor:function (root) {
		this.root = root;
		dojo.query("> option", root).forEach(function (node) {
			node.innerHTML = dojo.trim(node.innerHTML);
		});
	}, getValue:function (item, attribute, defaultValue) {
		return (attribute == "value") ? item.value : (item.innerText || item.textContent || "");
	}, isItemLoaded:function (something) {
		return true;
	}, getFeatures:function () {
		return {"dojo.data.api.Read":true, "dojo.data.api.Identity":true};
	}, _fetchItems:function (args, findCallback, errorCallback) {
		if (!args.query) {
			args.query = {};
		}
		if (!args.query.name) {
			args.query.name = "";
		}
		if (!args.queryOptions) {
			args.queryOptions = {};
		}
		var matcher = dojo.data.util.filter.patternToRegExp(args.query.name, args.queryOptions.ignoreCase), items = dojo.query("> option", this.root).filter(function (option) {
			return (option.innerText || option.textContent || "").match(matcher);
		});
		if (args.sort) {
			items.sort(dojo.data.util.sorter.createSortFunction(args.sort, this));
		}
		findCallback(items, args);
	}, close:function (request) {
		return;
	}, getLabel:function (item) {
		return item.innerHTML;
	}, getIdentity:function (item) {
		return dojo.attr(item, "value");
	}, fetchItemByIdentity:function (args) {
		var item = dojo.query("option[value='" + args.identity + "']", this.root)[0];
		args.onItem(item);
	}, fetchSelectedItem:function () {
		var root = this.root, si = root.selectedIndex;
		return dojo.query("> option:nth-child(" + (si != -1 ? si + 1 : 1) + ")", root)[0];
	}});
	dojo.extend(dijit.form._ComboBoxDataStore, dojo.data.util.simpleFetch);
}
if (!dojo._hasResource["dojo.data.ItemFileReadStore"]) {
	dojo._hasResource["dojo.data.ItemFileReadStore"] = true;
	dojo.provide("dojo.data.ItemFileReadStore");
	dojo.declare("dojo.data.ItemFileReadStore", null, {constructor:function (keywordParameters) {
		this._arrayOfAllItems = [];
		this._arrayOfTopLevelItems = [];
		this._loadFinished = false;
		this._jsonFileUrl = keywordParameters.url;
		this._ccUrl = keywordParameters.url;
		this.url = keywordParameters.url;
		this._jsonData = keywordParameters.data;
		this.data = null;
		this._datatypeMap = keywordParameters.typeMap || {};
		if (!this._datatypeMap["Date"]) {
			this._datatypeMap["Date"] = {type:Date, deserialize:function (value) {
				return dojo.date.stamp.fromISOString(value);
			}};
		}
		this._features = {"dojo.data.api.Read":true, "dojo.data.api.Identity":true};
		this._itemsByIdentity = null;
		this._storeRefPropName = "_S";
		this._itemNumPropName = "_0";
		this._rootItemPropName = "_RI";
		this._reverseRefMap = "_RRM";
		this._loadInProgress = false;
		this._queuedFetches = [];
		if (keywordParameters.urlPreventCache !== undefined) {
			this.urlPreventCache = keywordParameters.urlPreventCache ? true : false;
		}
		if (keywordParameters.hierarchical !== undefined) {
			this.hierarchical = keywordParameters.hierarchical ? true : false;
		}
		if (keywordParameters.clearOnClose) {
			this.clearOnClose = true;
		}
		if ("failOk" in keywordParameters) {
			this.failOk = keywordParameters.failOk ? true : false;
		}
	}, url:"", _ccUrl:"", data:null, typeMap:null, clearOnClose:false, urlPreventCache:false, failOk:false, hierarchical:true, _assertIsItem:function (item) {
		if (!this.isItem(item)) {
			throw new Error("dojo.data.ItemFileReadStore: Invalid item argument.");
		}
	}, _assertIsAttribute:function (attribute) {
		if (typeof attribute !== "string") {
			throw new Error("dojo.data.ItemFileReadStore: Invalid attribute argument.");
		}
	}, getValue:function (item, attribute, defaultValue) {
		var values = this.getValues(item, attribute);
		return (values.length > 0) ? values[0] : defaultValue;
	}, getValues:function (item, attribute) {
		this._assertIsItem(item);
		this._assertIsAttribute(attribute);
		return item[attribute] || [];
	}, getAttributes:function (item) {
		this._assertIsItem(item);
		var attributes = [];
		for (var key in item) {
			if ((key !== this._storeRefPropName) && (key !== this._itemNumPropName) && (key !== this._rootItemPropName) && (key !== this._reverseRefMap)) {
				attributes.push(key);
			}
		}
		return attributes;
	}, hasAttribute:function (item, attribute) {
		this._assertIsItem(item);
		this._assertIsAttribute(attribute);
		return (attribute in item);
	}, containsValue:function (item, attribute, value) {
		var regexp = undefined;
		if (typeof value === "string") {
			regexp = dojo.data.util.filter.patternToRegExp(value, false);
		}
		return this._containsValue(item, attribute, value, regexp);
	}, _containsValue:function (item, attribute, value, regexp) {
		return dojo.some(this.getValues(item, attribute), function (possibleValue) {
			if (possibleValue !== null && !dojo.isObject(possibleValue) && regexp) {
				if (possibleValue.toString().match(regexp)) {
					return true;
				}
			} else {
				if (value === possibleValue) {
					return true;
				}
			}
		});
	}, isItem:function (something) {
		if (something && something[this._storeRefPropName] === this) {
			if (this._arrayOfAllItems[something[this._itemNumPropName]] === something) {
				return true;
			}
		}
		return false;
	}, isItemLoaded:function (something) {
		return this.isItem(something);
	}, loadItem:function (keywordArgs) {
		this._assertIsItem(keywordArgs.item);
	}, getFeatures:function () {
		return this._features;
	}, getLabel:function (item) {
		if (this._labelAttr && this.isItem(item)) {
			return this.getValue(item, this._labelAttr);
		}
		return undefined;
	}, getLabelAttributes:function (item) {
		if (this._labelAttr) {
			return [this._labelAttr];
		}
		return null;
	}, _fetchItems:function (keywordArgs, findCallback, errorCallback) {
		var self = this;
		var filter = function (requestArgs, arrayOfItems) {
			var items = [];
			var i, key;
			if (requestArgs.query) {
				var value;
				var ignoreCase = requestArgs.queryOptions ? requestArgs.queryOptions.ignoreCase : false;
				var regexpList = {};
				for (key in requestArgs.query) {
					value = requestArgs.query[key];
					if (typeof value === "string") {
						regexpList[key] = dojo.data.util.filter.patternToRegExp(value, ignoreCase);
					} else {
						if (value instanceof RegExp) {
							regexpList[key] = value;
						}
					}
				}
				for (i = 0; i < arrayOfItems.length; ++i) {
					var match = true;
					var candidateItem = arrayOfItems[i];
					if (candidateItem === null) {
						match = false;
					} else {
						for (key in requestArgs.query) {
							value = requestArgs.query[key];
							if (!self._containsValue(candidateItem, key, value, regexpList[key])) {
								match = false;
							}
						}
					}
					if (match) {
						items.push(candidateItem);
					}
				}
				findCallback(items, requestArgs);
			} else {
				for (i = 0; i < arrayOfItems.length; ++i) {
					var item = arrayOfItems[i];
					if (item !== null) {
						items.push(item);
					}
				}
				findCallback(items, requestArgs);
			}
		};
		if (this._loadFinished) {
			filter(keywordArgs, this._getItemsArray(keywordArgs.queryOptions));
		} else {
			if (this._jsonFileUrl !== this._ccUrl) {
				dojo.deprecated("dojo.data.ItemFileReadStore: ", "To change the url, set the url property of the store," + " not _jsonFileUrl.  _jsonFileUrl support will be removed in 2.0");
				this._ccUrl = this._jsonFileUrl;
				this.url = this._jsonFileUrl;
			} else {
				if (this.url !== this._ccUrl) {
					this._jsonFileUrl = this.url;
					this._ccUrl = this.url;
				}
			}
			if (this.data != null && this._jsonData == null) {
				this._jsonData = this.data;
				this.data = null;
			}
			if (this._jsonFileUrl) {
				if (this._loadInProgress) {
					this._queuedFetches.push({args:keywordArgs, filter:filter});
				} else {
					this._loadInProgress = true;
					var getArgs = {url:self._jsonFileUrl, handleAs:"json-comment-optional", preventCache:this.urlPreventCache, failOk:this.failOk};
					var getHandler = dojo.xhrGet(getArgs);
					getHandler.addCallback(function (data) {
						try {
							self._getItemsFromLoadedData(data);
							self._loadFinished = true;
							self._loadInProgress = false;
							filter(keywordArgs, self._getItemsArray(keywordArgs.queryOptions));
							self._handleQueuedFetches();
						}
						catch (e) {
							self._loadFinished = true;
							self._loadInProgress = false;
							errorCallback(e, keywordArgs);
						}
					});
					getHandler.addErrback(function (error) {
						self._loadInProgress = false;
						errorCallback(error, keywordArgs);
					});
					var oldAbort = null;
					if (keywordArgs.abort) {
						oldAbort = keywordArgs.abort;
					}
					keywordArgs.abort = function () {
						var df = getHandler;
						if (df && df.fired === -1) {
							df.cancel();
							df = null;
						}
						if (oldAbort) {
							oldAbort.call(keywordArgs);
						}
					};
				}
			} else {
				if (this._jsonData) {
					try {
						this._loadFinished = true;
						this._getItemsFromLoadedData(this._jsonData);
						this._jsonData = null;
						filter(keywordArgs, this._getItemsArray(keywordArgs.queryOptions));
					}
					catch (e) {
						errorCallback(e, keywordArgs);
					}
				} else {
					errorCallback(new Error("dojo.data.ItemFileReadStore: No JSON source data was provided as either URL or a nested Javascript object."), keywordArgs);
				}
			}
		}
	}, _handleQueuedFetches:function () {
		if (this._queuedFetches.length > 0) {
			for (var i = 0; i < this._queuedFetches.length; i++) {
				var fData = this._queuedFetches[i];
				var delayedQuery = fData.args;
				var delayedFilter = fData.filter;
				if (delayedFilter) {
					delayedFilter(delayedQuery, this._getItemsArray(delayedQuery.queryOptions));
				} else {
					this.fetchItemByIdentity(delayedQuery);
				}
			}
			this._queuedFetches = [];
		}
	}, _getItemsArray:function (queryOptions) {
		if (queryOptions && queryOptions.deep) {
			return this._arrayOfAllItems;
		}
		return this._arrayOfTopLevelItems;
	}, close:function (request) {
		if (this.clearOnClose && this._loadFinished && !this._loadInProgress) {
			if (((this._jsonFileUrl == "" || this._jsonFileUrl == null) && (this.url == "" || this.url == null)) && this.data == null) {
				console.debug("dojo.data.ItemFileReadStore: WARNING!  Data reload " + " information has not been provided." + "  Please set 'url' or 'data' to the appropriate value before" + " the next fetch");
			}
			this._arrayOfAllItems = [];
			this._arrayOfTopLevelItems = [];
			this._loadFinished = false;
			this._itemsByIdentity = null;
			this._loadInProgress = false;
			this._queuedFetches = [];
		}
	}, reload:function (data) {
		this.clearOnClose = true;
		this._loadFinished = true;
		this._jsonData = null;
		this.data = data;
		this.close();
	}, _getItemsFromLoadedData:function (dataObject) {
		var addingArrays = false;
		var self = this;
		function valueIsAnItem(aValue) {
			var isItem = ((aValue !== null) && (typeof aValue === "object") && (!dojo.isArray(aValue) || addingArrays) && (!dojo.isFunction(aValue)) && (aValue.constructor == Object || dojo.isArray(aValue)) && (typeof aValue._reference === "undefined") && (typeof aValue._type === "undefined") && (typeof aValue._value === "undefined") && self.hierarchical);
			return isItem;
		}
		function addItemAndSubItemsToArrayOfAllItems(anItem) {
			self._arrayOfAllItems.push(anItem);
			for (var attribute in anItem) {
				var valueForAttribute = anItem[attribute];
				if (valueForAttribute) {
					if (dojo.isArray(valueForAttribute)) {
						var valueArray = valueForAttribute;
						for (var k = 0; k < valueArray.length; ++k) {
							var singleValue = valueArray[k];
							if (valueIsAnItem(singleValue)) {
								addItemAndSubItemsToArrayOfAllItems(singleValue);
							}
						}
					} else {
						if (valueIsAnItem(valueForAttribute)) {
							addItemAndSubItemsToArrayOfAllItems(valueForAttribute);
						}
					}
				}
			}
		}
		this._labelAttr = dataObject.label;
		var i;
		var item;
		this._arrayOfAllItems = [];
		this._arrayOfTopLevelItems = dataObject.items;
		for (i = 0; i < this._arrayOfTopLevelItems.length; ++i) {
			item = this._arrayOfTopLevelItems[i];
			if (dojo.isArray(item)) {
				addingArrays = true;
			}
			addItemAndSubItemsToArrayOfAllItems(item);
			item[this._rootItemPropName] = true;
		}
		var allAttributeNames = {};
		var key;
		for (i = 0; i < this._arrayOfAllItems.length; ++i) {
			item = this._arrayOfAllItems[i];
			for (key in item) {
				if (key !== this._rootItemPropName) {
					var value = item[key];
					if (value !== null) {
						if (!dojo.isArray(value)) {
							item[key] = [value];
						}
					} else {
						item[key] = [null];
					}
				}
				allAttributeNames[key] = key;
			}
		}
		while (allAttributeNames[this._storeRefPropName]) {
			this._storeRefPropName += "_";
		}
		while (allAttributeNames[this._itemNumPropName]) {
			this._itemNumPropName += "_";
		}
		while (allAttributeNames[this._reverseRefMap]) {
			this._reverseRefMap += "_";
		}
		var arrayOfValues;
		var identifier = dataObject.identifier;
		if (identifier) {
			this._itemsByIdentity = {};
			this._features["dojo.data.api.Identity"] = identifier;
			for (i = 0; i < this._arrayOfAllItems.length; ++i) {
				item = this._arrayOfAllItems[i];
				arrayOfValues = item[identifier];
				var identity = arrayOfValues[0];
				if (!this._itemsByIdentity[identity]) {
					this._itemsByIdentity[identity] = item;
				} else {
					if (this._jsonFileUrl) {
						throw new Error("dojo.data.ItemFileReadStore:  The json data as specified by: [" + this._jsonFileUrl + "] is malformed.  Items within the list have identifier: [" + identifier + "].  Value collided: [" + identity + "]");
					} else {
						if (this._jsonData) {
							throw new Error("dojo.data.ItemFileReadStore:  The json data provided by the creation arguments is malformed.  Items within the list have identifier: [" + identifier + "].  Value collided: [" + identity + "]");
						}
					}
				}
			}
		} else {
			this._features["dojo.data.api.Identity"] = Number;
		}
		for (i = 0; i < this._arrayOfAllItems.length; ++i) {
			item = this._arrayOfAllItems[i];
			item[this._storeRefPropName] = this;
			item[this._itemNumPropName] = i;
		}
		for (i = 0; i < this._arrayOfAllItems.length; ++i) {
			item = this._arrayOfAllItems[i];
			for (key in item) {
				arrayOfValues = item[key];
				for (var j = 0; j < arrayOfValues.length; ++j) {
					value = arrayOfValues[j];
					if (value !== null && typeof value == "object") {
						if (("_type" in value) && ("_value" in value)) {
							var type = value._type;
							var mappingObj = this._datatypeMap[type];
							if (!mappingObj) {
								throw new Error("dojo.data.ItemFileReadStore: in the typeMap constructor arg, no object class was specified for the datatype '" + type + "'");
							} else {
								if (dojo.isFunction(mappingObj)) {
									arrayOfValues[j] = new mappingObj(value._value);
								} else {
									if (dojo.isFunction(mappingObj.deserialize)) {
										arrayOfValues[j] = mappingObj.deserialize(value._value);
									} else {
										throw new Error("dojo.data.ItemFileReadStore: Value provided in typeMap was neither a constructor, nor a an object with a deserialize function");
									}
								}
							}
						}
						if (value._reference) {
							var referenceDescription = value._reference;
							if (!dojo.isObject(referenceDescription)) {
								arrayOfValues[j] = this._itemsByIdentity[referenceDescription];
							} else {
								for (var k = 0; k < this._arrayOfAllItems.length; ++k) {
									var candidateItem = this._arrayOfAllItems[k];
									var found = true;
									for (var refKey in referenceDescription) {
										if (candidateItem[refKey] != referenceDescription[refKey]) {
											found = false;
										}
									}
									if (found) {
										arrayOfValues[j] = candidateItem;
									}
								}
							}
							if (this.referenceIntegrity) {
								var refItem = arrayOfValues[j];
								if (this.isItem(refItem)) {
									this._addReferenceToMap(refItem, item, key);
								}
							}
						} else {
							if (this.isItem(value)) {
								if (this.referenceIntegrity) {
									this._addReferenceToMap(value, item, key);
								}
							}
						}
					}
				}
			}
		}
	}, _addReferenceToMap:function (refItem, parentItem, attribute) {
	}, getIdentity:function (item) {
		var identifier = this._features["dojo.data.api.Identity"];
		if (identifier === Number) {
			return item[this._itemNumPropName];
		} else {
			var arrayOfValues = item[identifier];
			if (arrayOfValues) {
				return arrayOfValues[0];
			}
		}
		return null;
	}, fetchItemByIdentity:function (keywordArgs) {
		var item;
		var scope;
		if (!this._loadFinished) {
			var self = this;
			if (this._jsonFileUrl !== this._ccUrl) {
				dojo.deprecated("dojo.data.ItemFileReadStore: ", "To change the url, set the url property of the store," + " not _jsonFileUrl.  _jsonFileUrl support will be removed in 2.0");
				this._ccUrl = this._jsonFileUrl;
				this.url = this._jsonFileUrl;
			} else {
				if (this.url !== this._ccUrl) {
					this._jsonFileUrl = this.url;
					this._ccUrl = this.url;
				}
			}
			if (this.data != null && this._jsonData == null) {
				this._jsonData = this.data;
				this.data = null;
			}
			if (this._jsonFileUrl) {
				if (this._loadInProgress) {
					this._queuedFetches.push({args:keywordArgs});
				} else {
					this._loadInProgress = true;
					var getArgs = {url:self._jsonFileUrl, handleAs:"json-comment-optional", preventCache:this.urlPreventCache, failOk:this.failOk};
					var getHandler = dojo.xhrGet(getArgs);
					getHandler.addCallback(function (data) {
						var scope = keywordArgs.scope ? keywordArgs.scope : dojo.global;
						try {
							self._getItemsFromLoadedData(data);
							self._loadFinished = true;
							self._loadInProgress = false;
							item = self._getItemByIdentity(keywordArgs.identity);
							if (keywordArgs.onItem) {
								keywordArgs.onItem.call(scope, item);
							}
							self._handleQueuedFetches();
						}
						catch (error) {
							self._loadInProgress = false;
							if (keywordArgs.onError) {
								keywordArgs.onError.call(scope, error);
							}
						}
					});
					getHandler.addErrback(function (error) {
						self._loadInProgress = false;
						if (keywordArgs.onError) {
							var scope = keywordArgs.scope ? keywordArgs.scope : dojo.global;
							keywordArgs.onError.call(scope, error);
						}
					});
				}
			} else {
				if (this._jsonData) {
					self._getItemsFromLoadedData(self._jsonData);
					self._jsonData = null;
					self._loadFinished = true;
					item = self._getItemByIdentity(keywordArgs.identity);
					if (keywordArgs.onItem) {
						scope = keywordArgs.scope ? keywordArgs.scope : dojo.global;
						keywordArgs.onItem.call(scope, item);
					}
				}
			}
		} else {
			item = this._getItemByIdentity(keywordArgs.identity);
			if (keywordArgs.onItem) {
				scope = keywordArgs.scope ? keywordArgs.scope : dojo.global;
				keywordArgs.onItem.call(scope, item);
			}
		}
	}, _getItemByIdentity:function (identity) {
		var item = null;
		if (this._itemsByIdentity) {
			item = this._itemsByIdentity[identity];
		} else {
			item = this._arrayOfAllItems[identity];
		}
		if (item === undefined) {
			item = null;
		}
		return item;
	}, getIdentityAttributes:function (item) {
		var identifier = this._features["dojo.data.api.Identity"];
		if (identifier === Number) {
			return null;
		} else {
			return [identifier];
		}
	}, _forceLoad:function () {
		var self = this;
		if (this._jsonFileUrl !== this._ccUrl) {
			dojo.deprecated("dojo.data.ItemFileReadStore: ", "To change the url, set the url property of the store," + " not _jsonFileUrl.  _jsonFileUrl support will be removed in 2.0");
			this._ccUrl = this._jsonFileUrl;
			this.url = this._jsonFileUrl;
		} else {
			if (this.url !== this._ccUrl) {
				this._jsonFileUrl = this.url;
				this._ccUrl = this.url;
			}
		}
		if (this.data != null && this._jsonData == null) {
			this._jsonData = this.data;
			this.data = null;
		}
		if (this._jsonFileUrl) {
			var getArgs = {url:this._jsonFileUrl, handleAs:"json-comment-optional", preventCache:this.urlPreventCache, failOk:this.failOk, sync:true};
			var getHandler = dojo.xhrGet(getArgs);
			getHandler.addCallback(function (data) {
				try {
					if (self._loadInProgress !== true && !self._loadFinished) {
						self._getItemsFromLoadedData(data);
						self._loadFinished = true;
					} else {
						if (self._loadInProgress) {
							throw new Error("dojo.data.ItemFileReadStore:  Unable to perform a synchronous load, an async load is in progress.");
						}
					}
				}
				catch (e) {
					console.log(e);
					throw e;
				}
			});
			getHandler.addErrback(function (error) {
				throw error;
			});
		} else {
			if (this._jsonData) {
				self._getItemsFromLoadedData(self._jsonData);
				self._jsonData = null;
				self._loadFinished = true;
			}
		}
	}});
	dojo.extend(dojo.data.ItemFileReadStore, dojo.data.util.simpleFetch);
}
if (!dojo._hasResource["dijit._Container"]) {
	dojo._hasResource["dijit._Container"] = true;
	dojo.provide("dijit._Container");
	dojo.declare("dijit._Container", null, {isContainer:true, buildRendering:function () {
		this.inherited(arguments);
		if (!this.containerNode) {
			this.containerNode = this.domNode;
		}
	}, addChild:function (widget, insertIndex) {
		var refNode = this.containerNode;
		if (insertIndex && typeof insertIndex == "number") {
			var children = this.getChildren();
			if (children && children.length >= insertIndex) {
				refNode = children[insertIndex - 1].domNode;
				insertIndex = "after";
			}
		}
		dojo.place(widget.domNode, refNode, insertIndex);
		if (this._started && !widget._started) {
			widget.startup();
		}
	}, removeChild:function (widget) {
		if (typeof widget == "number" && widget > 0) {
			widget = this.getChildren()[widget];
		}
		if (widget && widget.domNode) {
			var node = widget.domNode;
			node.parentNode.removeChild(node);
		}
	}, getChildren:function () {
		return dojo.query("> [widgetId]", this.containerNode).map(dijit.byNode);
	}, hasChildren:function () {
		return dojo.query("> [widgetId]", this.containerNode).length > 0;
	}, destroyDescendants:function (preserveDom) {
		dojo.forEach(this.getChildren(), function (child) {
			child.destroyRecursive(preserveDom);
		});
	}, _getSiblingOfChild:function (child, dir) {
		var node = child.domNode, which = (dir > 0 ? "nextSibling" : "previousSibling");
		do {
			node = node[which];
		} while (node && (node.nodeType != 1 || !dijit.byNode(node)));
		return node && dijit.byNode(node);
	}, getIndexOfChild:function (child) {
		return dojo.indexOf(this.getChildren(), child);
	}, startup:function () {
		if (this._started) {
			return;
		}
		dojo.forEach(this.getChildren(), function (child) {
			child.startup();
		});
		this.inherited(arguments);
	}});
}
if (!dojo._hasResource["dijit._HasDropDown"]) {
	dojo._hasResource["dijit._HasDropDown"] = true;
	dojo.provide("dijit._HasDropDown");
	dojo.declare("dijit._HasDropDown", null, {_buttonNode:null, _arrowWrapperNode:null, _popupStateNode:null, _aroundNode:null, dropDown:null, autoWidth:true, forceWidth:false, maxHeight:0, dropDownPosition:["below", "above"], _stopClickEvents:true, _onDropDownMouse:function (e) {
		if (e.type == "click" && !this._seenKeydown) {
			return;
		}
		this._seenKeydown = false;
		if (e.type == "mousedown") {
			this._docHandler = this.connect(dojo.doc, "onmouseup", "_onDropDownMouseup");
		}
		if (this.disabled || this.readOnly) {
			return;
		}
		if (this._stopClickEvents) {
			dojo.stopEvent(e);
		}
		this.toggleDropDown();
		if (e.type == "click" || e.type == "keypress") {
			this._onDropDownMouseup();
		}
	}, _onDropDownMouseup:function (e) {
		if (e && this._docHandler) {
			this.disconnect(this._docHandler);
		}
		var dropDown = this.dropDown, overMenu = false;
		if (e && this._opened) {
			var c = dojo.position(this._buttonNode, true);
			if (!(e.pageX >= c.x && e.pageX <= c.x + c.w) || !(e.pageY >= c.y && e.pageY <= c.y + c.h)) {
				var t = e.target;
				while (t && !overMenu) {
					if (dojo.hasClass(t, "dijitPopup")) {
						overMenu = true;
					} else {
						t = t.parentNode;
					}
				}
				if (overMenu) {
					t = e.target;
					if (dropDown.onItemClick) {
						var menuItem;
						while (t && !(menuItem = dijit.byNode(t))) {
							t = t.parentNode;
						}
						if (menuItem && menuItem.onClick && menuItem.getParent) {
							menuItem.getParent().onItemClick(menuItem, e);
						}
					}
					return;
				}
			}
		}
		if (this._opened && dropDown.focus) {
			window.setTimeout(dojo.hitch(dropDown, "focus"), 1);
		}
	}, _setupDropdown:function () {
		this._buttonNode = this._buttonNode || this.focusNode || this.domNode;
		this._popupStateNode = this._popupStateNode || this.focusNode || this._buttonNode;
		this._aroundNode = this._aroundNode || this.domNode;
		this.connect(this._buttonNode, "onmousedown", "_onDropDownMouse");
		this.connect(this._buttonNode, "onclick", "_onDropDownMouse");
		this.connect(this._buttonNode, "onkeydown", "_onDropDownKeydown");
		this.connect(this._buttonNode, "onblur", "_onDropDownBlur");
		this.connect(this._buttonNode, "onkeypress", "_onKey");
		if (this._setStateClass) {
			this.connect(this, "openDropDown", "_setStateClass");
			this.connect(this, "closeDropDown", "_setStateClass");
		}
		var defaultPos = {"after":this.isLeftToRight() ? "Right" : "Left", "before":this.isLeftToRight() ? "Left" : "Right", "above":"Up", "below":"Down", "left":"Left", "right":"Right"}[this.dropDownPosition[0]] || this.dropDownPosition[0] || "Down";
		dojo.addClass(this._arrowWrapperNode || this._buttonNode, "dijit" + defaultPos + "ArrowButton");
	}, postCreate:function () {
		this._setupDropdown();
		this.inherited(arguments);
	}, destroyDescendants:function () {
		if (this.dropDown) {
			if (!this.dropDown._destroyed) {
				this.dropDown.destroyRecursive();
			}
			delete this.dropDown;
		}
		this.inherited(arguments);
	}, _onDropDownKeydown:function (e) {
		this._seenKeydown = true;
	}, _onKeyPress:function (e) {
		if (this._opened && e.charOrCode == dojo.keys.ESCAPE && !e.shiftKey && !e.ctrlKey && !e.altKey) {
			this.toggleDropDown();
			dojo.stopEvent(e);
			return;
		}
		this.inherited(arguments);
	}, _onDropDownBlur:function (e) {
		this._seenKeydown = false;
	}, _onKey:function (e) {
		if (this.disabled || this.readOnly) {
			return;
		}
		var d = this.dropDown;
		if (d && this._opened && d.handleKey) {
			if (d.handleKey(e) === false) {
				return;
			}
		}
		if (d && this._opened && e.keyCode == dojo.keys.ESCAPE) {
			this.toggleDropDown();
			return;
		}
		if (e.keyCode == dojo.keys.DOWN_ARROW || e.keyCode == dojo.keys.ENTER || e.charOrCode == " ") {
			this._onDropDownMouse(e);
		}
	}, _onBlur:function () {
		this.closeDropDown();
		this.inherited(arguments);
	}, isLoaded:function () {
		return true;
	}, loadDropDown:function (loadCallback) {
		loadCallback();
	}, toggleDropDown:function () {
		if (this.disabled || this.readOnly) {
			return;
		}
		this.focus();
		var dropDown = this.dropDown;
		if (!dropDown) {
			return;
		}
		if (!this._opened) {
			if (!this.isLoaded()) {
				this.loadDropDown(dojo.hitch(this, "openDropDown"));
				return;
			} else {
				this.openDropDown();
			}
		} else {
			this.closeDropDown();
		}
	}, openDropDown:function () {
		var dropDown = this.dropDown;
		var ddNode = dropDown.domNode;
		var self = this;
		if (!this._preparedNode) {
			dijit.popup.moveOffScreen(ddNode);
			this._preparedNode = true;
			if (ddNode.style.width) {
				this._explicitDDWidth = true;
			}
			if (ddNode.style.height) {
				this._explicitDDHeight = true;
			}
		}
		if (this.maxHeight || this.forceWidth || this.autoWidth) {
			var myStyle = {display:"", visibility:"hidden"};
			if (!this._explicitDDWidth) {
				myStyle.width = "";
			}
			if (!this._explicitDDHeight) {
				myStyle.height = "";
			}
			dojo.style(ddNode, myStyle);
			var mb = dojo.marginBox(ddNode);
			var overHeight = (this.maxHeight && mb.h > this.maxHeight);
			dojo.style(ddNode, {overflow:overHeight ? "auto" : "hidden"});
			if (this.forceWidth) {
				mb.w = this.domNode.offsetWidth;
			} else {
				if (this.autoWidth) {
					mb.w = Math.max(mb.w, this.domNode.offsetWidth);
				} else {
					delete mb.w;
				}
			}
			if (overHeight) {
				mb.h = this.maxHeight;
				if ("w" in mb) {
					mb.w += 16;
				}
			} else {
				delete mb.h;
			}
			delete mb.t;
			delete mb.l;
			if (dojo.isFunction(dropDown.resize)) {
				dropDown.resize(mb);
			} else {
				dojo.marginBox(ddNode, mb);
			}
		}
		var retVal = dijit.popup.open({parent:this, popup:dropDown, around:this._aroundNode, orient:dijit.getPopupAroundAlignment((this.dropDownPosition && this.dropDownPosition.length) ? this.dropDownPosition : ["below"], this.isLeftToRight()), onExecute:function () {
			self.closeDropDown(true);
		}, onCancel:function () {
			self.closeDropDown(true);
		}, onClose:function () {
			dojo.attr(self._popupStateNode, "popupActive", false);
			dojo.removeClass(self._popupStateNode, "dijitHasDropDownOpen");
			self._opened = false;
			self.state = "";
		}});
		dojo.attr(this._popupStateNode, "popupActive", "true");
		dojo.addClass(self._popupStateNode, "dijitHasDropDownOpen");
		this._opened = true;
		this.state = "Opened";
		return retVal;
	}, closeDropDown:function (focus) {
		if (this._opened) {
			dijit.popup.close(this.dropDown);
			if (focus) {
				this.focus();
			}
			this._opened = false;
			this.state = "";
		}
	}});
}
if (!dojo._hasResource["dijit.form.Button"]) {
	dojo._hasResource["dijit.form.Button"] = true;
	dojo.provide("dijit.form.Button");
	dojo.declare("dijit.form.Button", dijit.form._FormWidget, {label:"", showLabel:true, iconClass:"", type:"button", baseClass:"dijitButton", templateString:dojo.cache("dijit.form", "templates/Button.html", "<span class=\"dijit dijitReset dijitLeft dijitInline\"\r\n\tdojoAttachEvent=\"onclick:_onButtonClick,onmouseenter:_onMouse,onmouseleave:_onMouse,onmousedown:_onMouse\"\r\n\t><span class=\"dijitReset dijitRight dijitInline\"\r\n\t\t><span class=\"dijitReset dijitInline dijitButtonNode\"\r\n\t\t\t><button class=\"dijitReset dijitStretch dijitButtonContents\"\r\n\t\t\t\tdojoAttachPoint=\"titleNode,focusNode\"\r\n\t\t\t\t${nameAttrSetting} type=\"${type}\" value=\"${value}\" waiRole=\"button\" waiState=\"labelledby-${id}_label\"\r\n\t\t\t\t><span class=\"dijitReset dijitInline\" dojoAttachPoint=\"iconNode\"\r\n\t\t\t\t\t><span class=\"dijitReset dijitToggleButtonIconChar\">&#10003;</span\r\n\t\t\t\t></span\r\n\t\t\t\t><span class=\"dijitReset dijitInline dijitButtonText\"\r\n\t\t\t\t\tid=\"${id}_label\"\r\n\t\t\t\t\tdojoAttachPoint=\"containerNode\"\r\n\t\t\t\t></span\r\n\t\t\t></button\r\n\t\t></span\r\n\t></span\r\n></span>\r\n"), attributeMap:dojo.delegate(dijit.form._FormWidget.prototype.attributeMap, {label:{node:"containerNode", type:"innerHTML"}, iconClass:{node:"iconNode", type:"class"}}), _onClick:function (e) {
		if (this.disabled) {
			return false;
		}
		this._clicked();
		return this.onClick(e);
	}, _onButtonClick:function (e) {
		if (this._onClick(e) === false) {
			e.preventDefault();
		} else {
			if (this.type == "submit" && !this.focusNode.form) {
				for (var node = this.domNode; node.parentNode; node = node.parentNode) {
					var widget = dijit.byNode(node);
					if (widget && typeof widget._onSubmit == "function") {
						widget._onSubmit(e);
						break;
					}
				}
			}
		}
	}, _setValueAttr:function (value) {
		var attr = this.attributeMap.value || "";
		if (this[attr.node || attr || "domNode"].tagName == "BUTTON") {
			if (value != this.value) {
				console.debug("Cannot change the value attribute on a Button widget.");
			}
		}
	}, _fillContent:function (source) {
		if (source && (!this.params || !("label" in this.params))) {
			this.attr("label", source.innerHTML);
		}
	}, postCreate:function () {
		dojo.setSelectable(this.focusNode, false);
		this.inherited(arguments);
	}, _setShowLabelAttr:function (val) {
		if (this.containerNode) {
			dojo.toggleClass(this.containerNode, "dijitDisplayNone", !val);
		}
		this.showLabel = val;
	}, onClick:function (e) {
		return true;
	}, _clicked:function (e) {
	}, setLabel:function (content) {
		dojo.deprecated("dijit.form.Button.setLabel() is deprecated.  Use attr('label', ...) instead.", "", "2.0");
		this.attr("label", content);
	}, _setLabelAttr:function (content) {
		this.containerNode.innerHTML = this.label = content;
		if (this.showLabel == false && !this.params.title) {
			this.titleNode.title = dojo.trim(this.containerNode.innerText || this.containerNode.textContent || "");
		}
	}});
	dojo.declare("dijit.form.DropDownButton", [dijit.form.Button, dijit._Container, dijit._HasDropDown], {baseClass:"dijitDropDownButton", templateString:dojo.cache("dijit.form", "templates/DropDownButton.html", "<span class=\"dijit dijitReset dijitLeft dijitInline\"\r\n\tdojoAttachPoint=\"_buttonNode\"\r\n\tdojoAttachEvent=\"onmouseenter:_onMouse,onmouseleave:_onMouse,onmousedown:_onMouse\"\r\n\t><span class='dijitReset dijitRight dijitInline'\r\n\t\t><span class='dijitReset dijitInline dijitButtonNode'\r\n\t\t\t><button class=\"dijitReset dijitStretch dijitButtonContents\"\r\n\t\t\t\t${nameAttrSetting} type=\"${type}\" value=\"${value}\"\r\n\t\t\t\tdojoAttachPoint=\"focusNode,titleNode,_arrowWrapperNode\"\r\n\t\t\t\twaiRole=\"button\" waiState=\"haspopup-true,labelledby-${id}_label\"\r\n\t\t\t\t><span class=\"dijitReset dijitInline\"\r\n\t\t\t\t\tdojoAttachPoint=\"iconNode\"\r\n\t\t\t\t></span\r\n\t\t\t\t><span class=\"dijitReset dijitInline dijitButtonText\"\r\n\t\t\t\t\tdojoAttachPoint=\"containerNode,_popupStateNode\"\r\n\t\t\t\t\tid=\"${id}_label\"\r\n\t\t\t\t></span\r\n\t\t\t\t><span class=\"dijitReset dijitInline dijitArrowButtonInner\">&thinsp;</span\r\n\t\t\t\t><span class=\"dijitReset dijitInline dijitArrowButtonChar\">&#9660;</span\r\n\t\t\t></button\r\n\t\t></span\r\n\t></span\r\n></span>\r\n"), _fillContent:function () {
		if (this.srcNodeRef) {
			var nodes = dojo.query("*", this.srcNodeRef);
			dijit.form.DropDownButton.superclass._fillContent.call(this, nodes[0]);
			this.dropDownContainer = this.srcNodeRef;
		}
	}, startup:function () {
		if (this._started) {
			return;
		}
		if (!this.dropDown) {
			var dropDownNode = dojo.query("[widgetId]", this.dropDownContainer)[0];
			this.dropDown = dijit.byNode(dropDownNode);
			delete this.dropDownContainer;
		}
		dijit.popup.moveOffScreen(this.dropDown.domNode);
		this.inherited(arguments);
	}, isLoaded:function () {
		var dropDown = this.dropDown;
		return (!dropDown.href || dropDown.isLoaded);
	}, loadDropDown:function () {
		var dropDown = this.dropDown;
		if (!dropDown) {
			return;
		}
		if (!this.isLoaded()) {
			var handler = dojo.connect(dropDown, "onLoad", this, function () {
				dojo.disconnect(handler);
				this.openDropDown();
			});
			dropDown.refresh();
		} else {
			this.openDropDown();
		}
	}, isFocusable:function () {
		return this.inherited(arguments) && !this._mouseDown;
	}});
	dojo.declare("dijit.form.ComboButton", dijit.form.DropDownButton, {templateString:dojo.cache("dijit.form", "templates/ComboButton.html", "<table class='dijit dijitReset dijitInline dijitLeft'\r\n\tcellspacing='0' cellpadding='0' waiRole=\"presentation\"\r\n\t><tbody waiRole=\"presentation\"><tr waiRole=\"presentation\"\r\n\t\t><td class=\"dijitReset dijitStretch dijitButtonNode\"><button id=\"${id}_button\" class=\"dijitReset dijitButtonContents\"\r\n\t\t\tdojoAttachEvent=\"onclick:_onButtonClick,onmouseenter:_onMouse,onmouseleave:_onMouse,onmousedown:_onMouse,onkeypress:_onButtonKeyPress\"  dojoAttachPoint=\"titleNode\"\r\n\t\t\twaiRole=\"button\" waiState=\"labelledby-${id}_label\"\r\n\t\t\t><div class=\"dijitReset dijitInline\" dojoAttachPoint=\"iconNode\" waiRole=\"presentation\"></div\r\n\t\t\t><div class=\"dijitReset dijitInline dijitButtonText\" id=\"${id}_label\" dojoAttachPoint=\"containerNode\" waiRole=\"presentation\"></div\r\n\t\t></button></td\r\n\t\t><td id=\"${id}_arrow\" class='dijitReset dijitRight dijitButtonNode dijitArrowButton'\r\n\t\t\tdojoAttachPoint=\"_popupStateNode,focusNode,_buttonNode\"\r\n\t\t\tdojoAttachEvent=\"onmouseenter:_onMouse,onmouseleave:_onMouse,onkeypress:_onArrowKeyPress\"\r\n\t\t\tstateModifier=\"DownArrow\"\r\n\t\t\ttitle=\"${optionsTitle}\" ${nameAttrSetting}\r\n\t\t\twaiRole=\"button\" waiState=\"haspopup-true\"\r\n\t\t\t><div class=\"dijitReset dijitArrowButtonInner\" waiRole=\"presentation\">&thinsp;</div\r\n\t\t\t><div class=\"dijitReset dijitArrowButtonChar\" waiRole=\"presentation\">&#9660;</div\r\n\t\t></td\r\n\t></tr></tbody\r\n></table>\r\n"), attributeMap:dojo.mixin(dojo.clone(dijit.form.Button.prototype.attributeMap), {id:"", tabIndex:["focusNode", "titleNode"], title:"titleNode"}), optionsTitle:"", baseClass:"dijitComboButton", _focusedNode:null, postCreate:function () {
		this.inherited(arguments);
		this._focalNodes = [this.titleNode, this._popupStateNode];
		var isIE = dojo.isIE;
		dojo.forEach(this._focalNodes, dojo.hitch(this, function (node) {
			this.connect(node, isIE ? "onactivate" : "onfocus", this._onNodeFocus);
			this.connect(node, isIE ? "ondeactivate" : "onblur", this._onNodeBlur);
		}));
		if (isIE && (isIE < 8 || dojo.isQuirks)) {
			with (this.titleNode) {
				style.width = scrollWidth + "px";
				this.connect(this.titleNode, "onresize", function () {
					setTimeout(function () {
						style.width = scrollWidth + "px";
					}, 0);
				});
			}
		}
	}, _onNodeFocus:function (evt) {
		this._focusedNode = evt.currentTarget;
		var fnc = this._focusedNode == this.focusNode ? "dijitDownArrowButtonFocused" : "dijitButtonContentsFocused";
		dojo.addClass(this._focusedNode, fnc);
	}, _onNodeBlur:function (evt) {
		var fnc = evt.currentTarget == this.focusNode ? "dijitDownArrowButtonFocused" : "dijitButtonContentsFocused";
		dojo.removeClass(evt.currentTarget, fnc);
	}, _onBlur:function () {
		this.inherited(arguments);
		this._focusedNode = null;
	}, _onButtonKeyPress:function (evt) {
		if (evt.charOrCode == dojo.keys[this.isLeftToRight() ? "RIGHT_ARROW" : "LEFT_ARROW"]) {
			dijit.focus(this._popupStateNode);
			dojo.stopEvent(evt);
		}
	}, _onArrowKeyPress:function (evt) {
		if (evt.charOrCode == dojo.keys[this.isLeftToRight() ? "LEFT_ARROW" : "RIGHT_ARROW"]) {
			dijit.focus(this.titleNode);
			dojo.stopEvent(evt);
		}
	}, focus:function (position) {
		dijit.focus(position == "start" ? this.titleNode : this._popupStateNode);
	}});
	dojo.declare("dijit.form.ToggleButton", dijit.form.Button, {baseClass:"dijitToggleButton", checked:false, attributeMap:dojo.mixin(dojo.clone(dijit.form.Button.prototype.attributeMap), {checked:"focusNode"}), _clicked:function (evt) {
		this.attr("checked", !this.checked);
	}, _setCheckedAttr:function (value) {
		this.checked = value;
		dojo.attr(this.focusNode || this.domNode, "checked", value);
		dijit.setWaiState(this.focusNode || this.domNode, "pressed", value);
		this._setStateClass();
		this._handleOnChange(value, true);
	}, setChecked:function (checked) {
		dojo.deprecated("setChecked(" + checked + ") is deprecated. Use attr('checked'," + checked + ") instead.", "", "2.0");
		this.attr("checked", checked);
	}, reset:function () {
		this._hasBeenBlurred = false;
		this.attr("checked", this.params.checked || false);
	}});
}
if (!dojo._hasResource["dijit.form.CheckBox"]) {
	dojo._hasResource["dijit.form.CheckBox"] = true;
	dojo.provide("dijit.form.CheckBox");
	dojo.declare("dijit.form.CheckBox", dijit.form.ToggleButton, {templateString:dojo.cache("dijit.form", "templates/CheckBox.html", "<div class=\"dijitReset dijitInline\" waiRole=\"presentation\"\r\n\t><input\r\n\t \t${nameAttrSetting} type=\"${type}\" ${checkedAttrSetting}\r\n\t\tclass=\"dijitReset dijitCheckBoxInput\"\r\n\t\tdojoAttachPoint=\"focusNode\"\r\n\t \tdojoAttachEvent=\"onmouseover:_onMouse,onmouseout:_onMouse,onclick:_onClick\"\r\n/></div>\r\n"), baseClass:"dijitCheckBox", type:"checkbox", value:"on", readOnly:false, attributeMap:dojo.delegate(dijit.form.ToggleButton.prototype.attributeMap, {readOnly:"focusNode"}), _setReadOnlyAttr:function (value) {
		this.readOnly = value;
		dojo.attr(this.focusNode, "readOnly", value);
		dijit.setWaiState(this.focusNode, "readonly", value);
		this._setStateClass();
	}, _setValueAttr:function (newValue) {
		if (typeof newValue == "string") {
			this.value = newValue;
			dojo.attr(this.focusNode, "value", newValue);
			newValue = true;
		}
		if (this._created) {
			this.attr("checked", newValue);
		}
	}, _getValueAttr:function () {
		return (this.checked ? this.value : false);
	}, postMixInProperties:function () {
		if (this.value == "") {
			this.value = "on";
		}
		this.checkedAttrSetting = this.checked ? "checked" : "";
		this.inherited(arguments);
	}, _fillContent:function (source) {
	}, reset:function () {
		this._hasBeenBlurred = false;
		this.attr("checked", this.params.checked || false);
		this.value = this.params.value || "on";
		dojo.attr(this.focusNode, "value", this.value);
	}, _onFocus:function () {
		if (this.id) {
			dojo.query("label[for='" + this.id + "']").addClass("dijitFocusedLabel");
		}
	}, _onBlur:function () {
		if (this.id) {
			dojo.query("label[for='" + this.id + "']").removeClass("dijitFocusedLabel");
		}
	}, _onClick:function (e) {
		if (this.readOnly) {
			return false;
		}
		return this.inherited(arguments);
	}});
	dojo.declare("dijit.form.RadioButton", dijit.form.CheckBox, {type:"radio", baseClass:"dijitRadio", _setCheckedAttr:function (value) {
		this.inherited(arguments);
		if (!this._created) {
			return;
		}
		if (value) {
			var _this = this;
			dojo.query("INPUT[type=radio]", this.focusNode.form || dojo.doc).forEach(function (inputNode) {
				if (inputNode.name == _this.name && inputNode != _this.focusNode && inputNode.form == _this.focusNode.form) {
					var widget = dijit.getEnclosingWidget(inputNode);
					if (widget && widget.checked) {
						widget.attr("checked", false);
					}
				}
			});
		}
	}, _clicked:function (e) {
		if (!this.checked) {
			this.attr("checked", true);
		}
	}});
}
if (!dojo._hasResource["dijit.form._Spinner"]) {
	dojo._hasResource["dijit.form._Spinner"] = true;
	dojo.provide("dijit.form._Spinner");
	dojo.declare("dijit.form._Spinner", dijit.form.RangeBoundTextBox, {defaultTimeout:500, timeoutChangeRate:0.9, smallDelta:1, largeDelta:10, templateString:dojo.cache("dijit.form", "templates/Spinner.html", "<div class=\"dijit dijitReset dijitInlineTable dijitLeft\"\r\n\tid=\"widget_${id}\"\r\n\tdojoAttachEvent=\"onmouseenter:_onMouse,onmouseleave:_onMouse,onmousedown:_onMouse\" waiRole=\"presentation\"\r\n\t><div class=\"dijitInputLayoutContainer\"\r\n\t\t><div class=\"dijitReset dijitSpinnerButtonContainer\"\r\n\t\t\t>&nbsp;<div class=\"dijitReset dijitLeft dijitButtonNode dijitArrowButton dijitUpArrowButton\"\r\n\t\t\t\tdojoAttachPoint=\"upArrowNode\"\r\n\t\t\t\tdojoAttachEvent=\"onmouseenter:_onMouse,onmouseleave:_onMouse\"\r\n\t\t\t\tstateModifier=\"UpArrow\"\r\n\t\t\t\t><div class=\"dijitArrowButtonInner\">&thinsp;</div\r\n\t\t\t\t><div class=\"dijitArrowButtonChar\">&#9650;</div\r\n\t\t\t></div\r\n\t\t\t><div class=\"dijitReset dijitLeft dijitButtonNode dijitArrowButton dijitDownArrowButton\"\r\n\t\t\t\tdojoAttachPoint=\"downArrowNode\"\r\n\t\t\t\tdojoAttachEvent=\"onmouseenter:_onMouse,onmouseleave:_onMouse\"\r\n\t\t\t\tstateModifier=\"DownArrow\"\r\n\t\t\t\t><div class=\"dijitArrowButtonInner\">&thinsp;</div\r\n\t\t\t\t><div class=\"dijitArrowButtonChar\">&#9660;</div\r\n\t\t\t></div\r\n\t\t></div\r\n\t\t><div class=\"dijitReset dijitValidationIcon\"><br></div\r\n\t\t><div class=\"dijitReset dijitValidationIconText\">&Chi;</div\r\n\t\t><div class=\"dijitReset dijitInputField\"\r\n\t\t\t><input class='dijitReset' dojoAttachPoint=\"textbox,focusNode\" type=\"${type}\" dojoAttachEvent=\"onkeypress:_onKeyPress\"\r\n\t\t\t\twaiRole=\"spinbutton\" autocomplete=\"off\" ${nameAttrSetting}\r\n\t\t/></div\r\n\t></div\r\n></div>\r\n"), baseClass:"dijitSpinner", adjust:function (val, delta) {
		return val;
	}, _arrowState:function (node, pressed) {
		this._active = pressed;
		this.stateModifier = node.getAttribute("stateModifier") || "";
		this._setStateClass();
	}, _arrowPressed:function (nodePressed, direction, increment) {
		if (this.disabled || this.readOnly) {
			return;
		}
		this._arrowState(nodePressed, true);
		this._setValueAttr(this.adjust(this.attr("value"), direction * increment), false);
		dijit.selectInputText(this.textbox, this.textbox.value.length);
	}, _arrowReleased:function (node) {
		this._wheelTimer = null;
		if (this.disabled || this.readOnly) {
			return;
		}
		this._arrowState(node, false);
	}, _typematicCallback:function (count, node, evt) {
		var inc = this.smallDelta;
		if (node == this.textbox) {
			var k = dojo.keys;
			var key = evt.charOrCode;
			inc = (key == k.PAGE_UP || key == k.PAGE_DOWN) ? this.largeDelta : this.smallDelta;
			node = (key == k.UP_ARROW || key == k.PAGE_UP) ? this.upArrowNode : this.downArrowNode;
		}
		if (count == -1) {
			this._arrowReleased(node);
		} else {
			this._arrowPressed(node, (node == this.upArrowNode) ? 1 : -1, inc);
		}
	}, _wheelTimer:null, _mouseWheeled:function (evt) {
		dojo.stopEvent(evt);
		var scrollAmount = evt.detail ? (evt.detail * -1) : (evt.wheelDelta / 120);
		if (scrollAmount !== 0) {
			var node = this[(scrollAmount > 0 ? "upArrowNode" : "downArrowNode")];
			this._arrowPressed(node, scrollAmount, this.smallDelta);
			if (!this._wheelTimer) {
				clearTimeout(this._wheelTimer);
			}
			this._wheelTimer = setTimeout(dojo.hitch(this, "_arrowReleased", node), 50);
		}
	}, postCreate:function () {
		this.inherited(arguments);
		this.connect(this.domNode, !dojo.isMozilla ? "onmousewheel" : "DOMMouseScroll", "_mouseWheeled");
		this._connects.push(dijit.typematic.addListener(this.upArrowNode, this.textbox, {charOrCode:dojo.keys.UP_ARROW, ctrlKey:false, altKey:false, shiftKey:false, metaKey:false}, this, "_typematicCallback", this.timeoutChangeRate, this.defaultTimeout));
		this._connects.push(dijit.typematic.addListener(this.downArrowNode, this.textbox, {charOrCode:dojo.keys.DOWN_ARROW, ctrlKey:false, altKey:false, shiftKey:false, metaKey:false}, this, "_typematicCallback", this.timeoutChangeRate, this.defaultTimeout));
		this._connects.push(dijit.typematic.addListener(this.upArrowNode, this.textbox, {charOrCode:dojo.keys.PAGE_UP, ctrlKey:false, altKey:false, shiftKey:false, metaKey:false}, this, "_typematicCallback", this.timeoutChangeRate, this.defaultTimeout));
		this._connects.push(dijit.typematic.addListener(this.downArrowNode, this.textbox, {charOrCode:dojo.keys.PAGE_DOWN, ctrlKey:false, altKey:false, shiftKey:false, metaKey:false}, this, "_typematicCallback", this.timeoutChangeRate, this.defaultTimeout));
		if (dojo.isIE) {
			var _this = this;
			(function resize() {
				var sz = _this.upArrowNode.parentNode.offsetHeight;
				if (sz) {
					_this.upArrowNode.style.height = sz >> 1;
					_this.downArrowNode.style.height = sz - (sz >> 1);
					_this.focusNode.parentNode.style.height = sz;
				}
			})();
			this.connect(this.domNode, "onresize", function () {
				setTimeout(function () {
					resize();
					_this._setStateClass();
				}, 0);
			});
			this._layoutHackIE7();
		}
	}});
}
if (!dojo._hasResource["dojo.number"]) {
	dojo._hasResource["dojo.number"] = true;
	dojo.provide("dojo.number");
	dojo.number.format = function (value, options) {
		options = dojo.mixin({}, options || {});
		var locale = dojo.i18n.normalizeLocale(options.locale);
		var bundle = dojo.i18n.getLocalization("dojo.cldr", "number", locale);
		options.customs = bundle;
		var pattern = options.pattern || bundle[(options.type || "decimal") + "Format"];
		if (isNaN(value) || Math.abs(value) == Infinity) {
			return null;
		}
		return dojo.number._applyPattern(value, pattern, options);
	};
	dojo.number._numberPatternRE = /[#0,]*[#0](?:\.0*#*)?/;
	dojo.number._applyPattern = function (value, pattern, options) {
		options = options || {};
		var group = options.customs.group;
		var decimal = options.customs.decimal;
		var patternList = pattern.split(";");
		var positivePattern = patternList[0];
		pattern = patternList[(value < 0) ? 1 : 0] || ("-" + positivePattern);
		if (pattern.indexOf("%") != -1) {
			value *= 100;
		} else {
			if (pattern.indexOf("\u2030") != -1) {
				value *= 1000;
			} else {
				if (pattern.indexOf("\xa4") != -1) {
					group = options.customs.currencyGroup || group;
					decimal = options.customs.currencyDecimal || decimal;
					pattern = pattern.replace(/\u00a4{1,3}/, function (match) {
						var prop = ["symbol", "currency", "displayName"][match.length - 1];
						return options[prop] || options.currency || "";
					});
				} else {
					if (pattern.indexOf("E") != -1) {
						throw new Error("exponential notation not supported");
					}
				}
			}
		}
		var numberPatternRE = dojo.number._numberPatternRE;
		var numberPattern = positivePattern.match(numberPatternRE);
		if (!numberPattern) {
			throw new Error("unable to find a number expression in pattern: " + pattern);
		}
		if (options.fractional === false) {
			options.places = 0;
		}
		return pattern.replace(numberPatternRE, dojo.number._formatAbsolute(value, numberPattern[0], {decimal:decimal, group:group, places:options.places, round:options.round}));
	};
	dojo.number.round = function (value, places, increment) {
		var factor = 10 / (increment || 10);
		return (factor * +value).toFixed(places) / factor;
	};
	if ((0.9).toFixed() == 0) {
		(function () {
			var round = dojo.number.round;
			dojo.number.round = function (v, p, m) {
				var d = Math.pow(10, -p || 0), a = Math.abs(v);
				if (!v || a >= d || a * Math.pow(10, p + 1) < 5) {
					d = 0;
				}
				return round(v, p, m) + (v > 0 ? d : -d);
			};
		})();
	}
	dojo.number._formatAbsolute = function (value, pattern, options) {
		options = options || {};
		if (options.places === true) {
			options.places = 0;
		}
		if (options.places === Infinity) {
			options.places = 6;
		}
		var patternParts = pattern.split(".");
		var maxPlaces = (options.places >= 0) ? options.places : (patternParts[1] && patternParts[1].length) || 0;
		if (!(options.round < 0)) {
			value = dojo.number.round(value, maxPlaces, options.round);
		}
		var valueParts = String(Math.abs(value)).split(".");
		var fractional = valueParts[1] || "";
		if (options.places) {
			var comma = dojo.isString(options.places) && options.places.indexOf(",");
			if (comma) {
				options.places = options.places.substring(comma + 1);
			}
			valueParts[1] = dojo.string.pad(fractional.substr(0, options.places), options.places, "0", true);
		} else {
			if (patternParts[1] && options.places !== 0) {
				var pad = patternParts[1].lastIndexOf("0") + 1;
				if (pad > fractional.length) {
					valueParts[1] = dojo.string.pad(fractional, pad, "0", true);
				}
				var places = patternParts[1].length;
				if (places < fractional.length) {
					valueParts[1] = fractional.substr(0, places);
				}
			} else {
				if (valueParts[1]) {
					valueParts.pop();
				}
			}
		}
		var patternDigits = patternParts[0].replace(",", "");
		pad = patternDigits.indexOf("0");
		if (pad != -1) {
			pad = patternDigits.length - pad;
			if (pad > valueParts[0].length) {
				valueParts[0] = dojo.string.pad(valueParts[0], pad);
			}
			if (patternDigits.indexOf("#") == -1) {
				valueParts[0] = valueParts[0].substr(valueParts[0].length - pad);
			}
		}
		var index = patternParts[0].lastIndexOf(",");
		var groupSize, groupSize2;
		if (index != -1) {
			groupSize = patternParts[0].length - index - 1;
			var remainder = patternParts[0].substr(0, index);
			index = remainder.lastIndexOf(",");
			if (index != -1) {
				groupSize2 = remainder.length - index - 1;
			}
		}
		var pieces = [];
		for (var whole = valueParts[0]; whole; ) {
			var off = whole.length - groupSize;
			pieces.push((off > 0) ? whole.substr(off) : whole);
			whole = (off > 0) ? whole.slice(0, off) : "";
			if (groupSize2) {
				groupSize = groupSize2;
				delete groupSize2;
			}
		}
		valueParts[0] = pieces.reverse().join(options.group || ",");
		return valueParts.join(options.decimal || ".");
	};
	dojo.number.regexp = function (options) {
		return dojo.number._parseInfo(options).regexp;
	};
	dojo.number._parseInfo = function (options) {
		options = options || {};
		var locale = dojo.i18n.normalizeLocale(options.locale);
		var bundle = dojo.i18n.getLocalization("dojo.cldr", "number", locale);
		var pattern = options.pattern || bundle[(options.type || "decimal") + "Format"];
		var group = bundle.group;
		var decimal = bundle.decimal;
		var factor = 1;
		if (pattern.indexOf("%") != -1) {
			factor /= 100;
		} else {
			if (pattern.indexOf("\u2030") != -1) {
				factor /= 1000;
			} else {
				var isCurrency = pattern.indexOf("\xa4") != -1;
				if (isCurrency) {
					group = bundle.currencyGroup || group;
					decimal = bundle.currencyDecimal || decimal;
				}
			}
		}
		var patternList = pattern.split(";");
		if (patternList.length == 1) {
			patternList.push("-" + patternList[0]);
		}
		var re = dojo.regexp.buildGroupRE(patternList, function (pattern) {
			pattern = "(?:" + dojo.regexp.escapeString(pattern, ".") + ")";
			return pattern.replace(dojo.number._numberPatternRE, function (format) {
				var flags = {signed:false, separator:options.strict ? group : [group, ""], fractional:options.fractional, decimal:decimal, exponent:false};
				var parts = format.split(".");
				var places = options.places;
				if (parts.length == 1 || places === 0) {
					flags.fractional = false;
				} else {
					if (places === undefined) {
						places = options.pattern ? parts[1].lastIndexOf("0") + 1 : Infinity;
					}
					if (places && options.fractional == undefined) {
						flags.fractional = true;
					}
					if (!options.places && (places < parts[1].length)) {
						places += "," + parts[1].length;
					}
					flags.places = places;
				}
				var groups = parts[0].split(",");
				if (groups.length > 1) {
					flags.groupSize = groups.pop().length;
					if (groups.length > 1) {
						flags.groupSize2 = groups.pop().length;
					}
				}
				return "(" + dojo.number._realNumberRegexp(flags) + ")";
			});
		}, true);
		if (isCurrency) {
			re = re.replace(/([\s\xa0]*)(\u00a4{1,3})([\s\xa0]*)/g, function (match, before, target, after) {
				var prop = ["symbol", "currency", "displayName"][target.length - 1];
				var symbol = dojo.regexp.escapeString(options[prop] || options.currency || "");
				before = before ? "[\\s\\xa0]" : "";
				after = after ? "[\\s\\xa0]" : "";
				if (!options.strict) {
					if (before) {
						before += "*";
					}
					if (after) {
						after += "*";
					}
					return "(?:" + before + symbol + after + ")?";
				}
				return before + symbol + after;
			});
		}
		return {regexp:re.replace(/[\xa0 ]/g, "[\\s\\xa0]"), group:group, decimal:decimal, factor:factor};
	};
	dojo.number.parse = function (expression, options) {
		var info = dojo.number._parseInfo(options);
		var results = (new RegExp("^" + info.regexp + "$")).exec(expression);
		if (!results) {
			return NaN;
		}
		var absoluteMatch = results[1];
		if (!results[1]) {
			if (!results[2]) {
				return NaN;
			}
			absoluteMatch = results[2];
			info.factor *= -1;
		}
		absoluteMatch = absoluteMatch.replace(new RegExp("[" + info.group + "\\s\\xa0" + "]", "g"), "").replace(info.decimal, ".");
		return absoluteMatch * info.factor;
	};
	dojo.number._realNumberRegexp = function (flags) {
		flags = flags || {};
		if (!("places" in flags)) {
			flags.places = Infinity;
		}
		if (typeof flags.decimal != "string") {
			flags.decimal = ".";
		}
		if (!("fractional" in flags) || /^0/.test(flags.places)) {
			flags.fractional = [true, false];
		}
		if (!("exponent" in flags)) {
			flags.exponent = [true, false];
		}
		if (!("eSigned" in flags)) {
			flags.eSigned = [true, false];
		}
		var integerRE = dojo.number._integerRegexp(flags);
		var decimalRE = dojo.regexp.buildGroupRE(flags.fractional, function (q) {
			var re = "";
			if (q && (flags.places !== 0)) {
				re = "\\" + flags.decimal;
				if (flags.places == Infinity) {
					re = "(?:" + re + "\\d+)?";
				} else {
					re += "\\d{" + flags.places + "}";
				}
			}
			return re;
		}, true);
		var exponentRE = dojo.regexp.buildGroupRE(flags.exponent, function (q) {
			if (q) {
				return "([eE]" + dojo.number._integerRegexp({signed:flags.eSigned}) + ")";
			}
			return "";
		});
		var realRE = integerRE + decimalRE;
		if (decimalRE) {
			realRE = "(?:(?:" + realRE + ")|(?:" + decimalRE + "))";
		}
		return realRE + exponentRE;
	};
	dojo.number._integerRegexp = function (flags) {
		flags = flags || {};
		if (!("signed" in flags)) {
			flags.signed = [true, false];
		}
		if (!("separator" in flags)) {
			flags.separator = "";
		} else {
			if (!("groupSize" in flags)) {
				flags.groupSize = 3;
			}
		}
		var signRE = dojo.regexp.buildGroupRE(flags.signed, function (q) {
			return q ? "[-+]" : "";
		}, true);
		var numberRE = dojo.regexp.buildGroupRE(flags.separator, function (sep) {
			if (!sep) {
				return "(?:\\d+)";
			}
			sep = dojo.regexp.escapeString(sep);
			if (sep == " ") {
				sep = "\\s";
			} else {
				if (sep == "\xa0") {
					sep = "\\s\\xa0";
				}
			}
			var grp = flags.groupSize, grp2 = flags.groupSize2;
			if (grp2) {
				var grp2RE = "(?:0|[1-9]\\d{0," + (grp2 - 1) + "}(?:[" + sep + "]\\d{" + grp2 + "})*[" + sep + "]\\d{" + grp + "})";
				return ((grp - grp2) > 0) ? "(?:" + grp2RE + "|(?:0|[1-9]\\d{0," + (grp - 1) + "}))" : grp2RE;
			}
			return "(?:0|[1-9]\\d{0," + (grp - 1) + "}(?:[" + sep + "]\\d{" + grp + "})*)";
		}, true);
		return signRE + numberRE;
	};
}
if (!dojo._hasResource["dijit.form.NumberTextBox"]) {
	dojo._hasResource["dijit.form.NumberTextBox"] = true;
	dojo.provide("dijit.form.NumberTextBox");
	dojo.declare("dijit.form.NumberTextBoxMixin", null, {regExpGen:dojo.number.regexp, value:NaN, editOptions:{pattern:"#.######"}, _formatter:dojo.number.format, postMixInProperties:function () {
		var places = typeof this.constraints.places == "number" ? this.constraints.places : 0;
		if (places) {
			places++;
		}
		if (typeof this.constraints.max != "number") {
			this.constraints.max = 9 * Math.pow(10, 15 - places);
		}
		if (typeof this.constraints.min != "number") {
			this.constraints.min = -9 * Math.pow(10, 15 - places);
		}
		this.inherited(arguments);
	}, _onFocus:function () {
		if (this.disabled) {
			return;
		}
		var val = this.attr("value");
		if (typeof val == "number" && !isNaN(val)) {
			var formattedValue = this.format(val, this.constraints);
			if (formattedValue !== undefined) {
				this.textbox.value = formattedValue;
			}
		}
		this.inherited(arguments);
	}, format:function (value, constraints) {
		if (typeof value != "number") {
			return String(value);
		}
		if (isNaN(value)) {
			return "";
		}
		if (("rangeCheck" in this) && !this.rangeCheck(value, constraints)) {
			return String(value);
		}
		if (this.editOptions && this._focused) {
			constraints = dojo.mixin({}, constraints, this.editOptions);
		}
		return this._formatter(value, constraints);
	}, parse:dojo.number.parse, _getDisplayedValueAttr:function () {
		var v = this.inherited(arguments);
		return isNaN(v) ? this.textbox.value : v;
	}, filter:function (value) {
		return (value === null || value === "" || value === undefined) ? NaN : this.inherited(arguments);
	}, serialize:function (value, options) {
		return (typeof value != "number" || isNaN(value)) ? "" : this.inherited(arguments);
	}, _setValueAttr:function (value, priorityChange, formattedValue) {
		if (value !== undefined && formattedValue === undefined) {
			if (typeof value == "number") {
				if (isNaN(value)) {
					formattedValue = "";
				} else {
					if (("rangeCheck" in this) && !this.rangeCheck(value, this.constraints)) {
						formattedValue = String(value);
					}
				}
			} else {
				if (!value) {
					formattedValue = "";
					value = NaN;
				} else {
					formattedValue = String(value);
					value = undefined;
				}
			}
		}
		this.inherited(arguments, [value, priorityChange, formattedValue]);
	}, _getValueAttr:function () {
		var v = this.inherited(arguments);
		if (isNaN(v) && this.textbox.value !== "") {
			if (this.constraints.exponent !== false && /\de[-+]?|\d/i.test(this.textbox.value) && (new RegExp("^" + dojo.number._realNumberRegexp(dojo.mixin({}, this.constraints)) + "$").test(this.textbox.value))) {
				var n = Number(this.textbox.value);
				return isNaN(n) ? undefined : n;
			} else {
				return undefined;
			}
		} else {
			return v;
		}
	}, isValid:function (isFocused) {
		if (!this._focused || this._isEmpty(this.textbox.value)) {
			return this.inherited(arguments);
		} else {
			var v = this.attr("value");
			if (!isNaN(v) && this.rangeCheck(v, this.constraints)) {
				if (this.constraints.exponent !== false && /\de[-+]?\d/i.test(this.textbox.value)) {
					return true;
				} else {
					return this.inherited(arguments);
				}
			} else {
				return false;
			}
		}
	}});
	dojo.declare("dijit.form.NumberTextBox", [dijit.form.RangeBoundTextBox, dijit.form.NumberTextBoxMixin], {});
}
if (!dojo._hasResource["dijit.form.NumberSpinner"]) {
	dojo._hasResource["dijit.form.NumberSpinner"] = true;
	dojo.provide("dijit.form.NumberSpinner");
	dojo.declare("dijit.form.NumberSpinner", [dijit.form._Spinner, dijit.form.NumberTextBoxMixin], {adjust:function (val, delta) {
		var tc = this.constraints, v = isNaN(val), gotMax = !isNaN(tc.max), gotMin = !isNaN(tc.min);
		if (v && delta != 0) {
			val = (delta > 0) ? gotMin ? tc.min : gotMax ? tc.max : 0 : gotMax ? this.constraints.max : gotMin ? tc.min : 0;
		}
		var newval = val + delta;
		if (v || isNaN(newval)) {
			return val;
		}
		if (gotMax && (newval > tc.max)) {
			newval = tc.max;
		}
		if (gotMin && (newval < tc.min)) {
			newval = tc.min;
		}
		return newval;
	}, _onKeyPress:function (e) {
		if ((e.charOrCode == dojo.keys.HOME || e.charOrCode == dojo.keys.END) && !(e.ctrlKey || e.altKey || e.metaKey) && typeof this.attr("value") != "undefined") {
			var value = this.constraints[(e.charOrCode == dojo.keys.HOME ? "min" : "max")];
			if (value) {
				this._setValueAttr(value, true);
			}
			dojo.stopEvent(e);
		}
	}});
}
if (!dojo._hasResource["dojo.cldr.monetary"]) {
	dojo._hasResource["dojo.cldr.monetary"] = true;
	dojo.provide("dojo.cldr.monetary");
	dojo.cldr.monetary.getData = function (code) {
		var placesData = {ADP:0, BHD:3, BIF:0, BYR:0, CLF:0, CLP:0, DJF:0, ESP:0, GNF:0, IQD:3, ITL:0, JOD:3, JPY:0, KMF:0, KRW:0, KWD:3, LUF:0, LYD:3, MGA:0, MGF:0, OMR:3, PYG:0, RWF:0, TND:3, TRL:0, VUV:0, XAF:0, XOF:0, XPF:0};
		var roundingData = {CHF:5};
		var places = placesData[code], round = roundingData[code];
		if (typeof places == "undefined") {
			places = 2;
		}
		if (typeof round == "undefined") {
			round = 0;
		}
		return {places:places, round:round};
	};
}
if (!dojo._hasResource["dojo.currency"]) {
	dojo._hasResource["dojo.currency"] = true;
	dojo.provide("dojo.currency");
	dojo.currency._mixInDefaults = function (options) {
		options = options || {};
		options.type = "currency";
		var bundle = dojo.i18n.getLocalization("dojo.cldr", "currency", options.locale) || {};
		var iso = options.currency;
		var data = dojo.cldr.monetary.getData(iso);
		dojo.forEach(["displayName", "symbol", "group", "decimal"], function (prop) {
			data[prop] = bundle[iso + "_" + prop];
		});
		data.fractional = [true, false];
		return dojo.mixin(data, options);
	};
	dojo.currency.format = function (value, options) {
		return dojo.number.format(value, dojo.currency._mixInDefaults(options));
	};
	dojo.currency.regexp = function (options) {
		return dojo.number.regexp(dojo.currency._mixInDefaults(options));
	};
	dojo.currency.parse = function (expression, options) {
		return dojo.number.parse(expression, dojo.currency._mixInDefaults(options));
	};
}
if (!dojo._hasResource["dijit.form.CurrencyTextBox"]) {
	dojo._hasResource["dijit.form.CurrencyTextBox"] = true;
	dojo.provide("dijit.form.CurrencyTextBox");
	dojo.declare("dijit.form.CurrencyTextBox", dijit.form.NumberTextBox, {currency:"", regExpGen:function (constraints) {
		return "(" + (this._focused ? this.inherited(arguments, [dojo.mixin({}, constraints, this.editOptions)]) + "|" : "") + dojo.currency.regexp(constraints) + ")";
	}, _formatter:dojo.currency.format, parse:function (value, constraints) {
		var v = dojo.currency.parse(value, constraints);
		if (isNaN(v) && /\d+/.test(value)) {
			return this.inherited(arguments, [value, dojo.mixin({}, constraints, this.editOptions)]);
		}
		return v;
	}, postMixInProperties:function () {
		this.constraints = dojo.currency._mixInDefaults(dojo.mixin(this.constraints, {currency:this.currency, exponent:false}));
		this.inherited(arguments);
	}});
}
if (!dojo._hasResource["dojo.dnd.autoscroll"]) {
	dojo._hasResource["dojo.dnd.autoscroll"] = true;
	dojo.provide("dojo.dnd.autoscroll");
	dojo.dnd.getViewport = function () {
		var d = dojo.doc, dd = d.documentElement, w = window, b = dojo.body();
		if (dojo.isMozilla) {
			return {w:dd.clientWidth, h:w.innerHeight};
		} else {
			if (!dojo.isOpera && w.innerWidth) {
				return {w:w.innerWidth, h:w.innerHeight};
			} else {
				if (!dojo.isOpera && dd && dd.clientWidth) {
					return {w:dd.clientWidth, h:dd.clientHeight};
				} else {
					if (b.clientWidth) {
						return {w:b.clientWidth, h:b.clientHeight};
					}
				}
			}
		}
		return null;
	};
	dojo.dnd.V_TRIGGER_AUTOSCROLL = 32;
	dojo.dnd.H_TRIGGER_AUTOSCROLL = 32;
	dojo.dnd.V_AUTOSCROLL_VALUE = 16;
	dojo.dnd.H_AUTOSCROLL_VALUE = 16;
	dojo.dnd.autoScroll = function (e) {
		var v = dojo.dnd.getViewport(), dx = 0, dy = 0;
		if (e.clientX < dojo.dnd.H_TRIGGER_AUTOSCROLL) {
			dx = -dojo.dnd.H_AUTOSCROLL_VALUE;
		} else {
			if (e.clientX > v.w - dojo.dnd.H_TRIGGER_AUTOSCROLL) {
				dx = dojo.dnd.H_AUTOSCROLL_VALUE;
			}
		}
		if (e.clientY < dojo.dnd.V_TRIGGER_AUTOSCROLL) {
			dy = -dojo.dnd.V_AUTOSCROLL_VALUE;
		} else {
			if (e.clientY > v.h - dojo.dnd.V_TRIGGER_AUTOSCROLL) {
				dy = dojo.dnd.V_AUTOSCROLL_VALUE;
			}
		}
		window.scrollBy(dx, dy);
	};
	dojo.dnd._validNodes = {"div":1, "p":1, "td":1};
	dojo.dnd._validOverflow = {"auto":1, "scroll":1};
	dojo.dnd.autoScrollNodes = function (e) {
		for (var n = e.target; n; ) {
			if (n.nodeType == 1 && (n.tagName.toLowerCase() in dojo.dnd._validNodes)) {
				var s = dojo.getComputedStyle(n);
				if (s.overflow.toLowerCase() in dojo.dnd._validOverflow) {
					var b = dojo._getContentBox(n, s), t = dojo.position(n, true);
					var w = Math.min(dojo.dnd.H_TRIGGER_AUTOSCROLL, b.w / 2), h = Math.min(dojo.dnd.V_TRIGGER_AUTOSCROLL, b.h / 2), rx = e.pageX - t.x, ry = e.pageY - t.y, dx = 0, dy = 0;
					if (dojo.isWebKit || dojo.isOpera) {
						rx += dojo.body().scrollLeft, ry += dojo.body().scrollTop;
					}
					if (rx > 0 && rx < b.w) {
						if (rx < w) {
							dx = -w;
						} else {
							if (rx > b.w - w) {
								dx = w;
							}
						}
					}
					if (ry > 0 && ry < b.h) {
						if (ry < h) {
							dy = -h;
						} else {
							if (ry > b.h - h) {
								dy = h;
							}
						}
					}
					var oldLeft = n.scrollLeft, oldTop = n.scrollTop;
					n.scrollLeft = n.scrollLeft + dx;
					n.scrollTop = n.scrollTop + dy;
					if (oldLeft != n.scrollLeft || oldTop != n.scrollTop) {
						return;
					}
				}
			}
			try {
				n = n.parentNode;
			}
			catch (x) {
				n = null;
			}
		}
		dojo.dnd.autoScroll(e);
	};
}
if (!dojo._hasResource["dojo.dnd.Mover"]) {
	dojo._hasResource["dojo.dnd.Mover"] = true;
	dojo.provide("dojo.dnd.Mover");
	dojo.declare("dojo.dnd.Mover", null, {constructor:function (node, e, host) {
		this.node = dojo.byId(node);
		this.marginBox = {l:e.pageX, t:e.pageY};
		this.mouseButton = e.button;
		var h = this.host = host, d = node.ownerDocument, firstEvent = dojo.connect(d, "onmousemove", this, "onFirstMove");
		this.events = [dojo.connect(d, "onmousemove", this, "onMouseMove"), dojo.connect(d, "onmouseup", this, "onMouseUp"), dojo.connect(d, "ondragstart", dojo.stopEvent), dojo.connect(d.body, "onselectstart", dojo.stopEvent), firstEvent];
		if (h && h.onMoveStart) {
			h.onMoveStart(this);
		}
	}, onMouseMove:function (e) {
		dojo.dnd.autoScroll(e);
		var m = this.marginBox;
		this.host.onMove(this, {l:m.l + e.pageX, t:m.t + e.pageY});
		dojo.stopEvent(e);
	}, onMouseUp:function (e) {
		if (dojo.isWebKit && dojo.isMac && this.mouseButton == 2 ? e.button == 0 : this.mouseButton == e.button) {
			this.destroy();
		}
		dojo.stopEvent(e);
	}, onFirstMove:function () {
		var s = this.node.style, l, t, h = this.host;
		switch (s.position) {
		  case "relative":
		  case "absolute":
			l = Math.round(parseFloat(s.left));
			t = Math.round(parseFloat(s.top));
			break;
		  default:
			s.position = "absolute";
			var m = dojo.marginBox(this.node);
			var b = dojo.doc.body;
			var bs = dojo.getComputedStyle(b);
			var bm = dojo._getMarginBox(b, bs);
			var bc = dojo._getContentBox(b, bs);
			l = m.l - (bc.l - bm.l);
			t = m.t - (bc.t - bm.t);
			break;
		}
		this.marginBox.l = l - this.marginBox.l;
		this.marginBox.t = t - this.marginBox.t;
		if (h && h.onFirstMove) {
			h.onFirstMove(this);
		}
		dojo.disconnect(this.events.pop());
	}, destroy:function () {
		dojo.forEach(this.events, dojo.disconnect);
		var h = this.host;
		if (h && h.onMoveStop) {
			h.onMoveStop(this);
		}
		this.events = this.node = this.host = null;
	}});
}
if (!dojo._hasResource["dojo.dnd.Moveable"]) {
	dojo._hasResource["dojo.dnd.Moveable"] = true;
	dojo.provide("dojo.dnd.Moveable");
	dojo.declare("dojo.dnd.Moveable", null, {handle:"", delay:0, skip:false, constructor:function (node, params) {
		this.node = dojo.byId(node);
		if (!params) {
			params = {};
		}
		this.handle = params.handle ? dojo.byId(params.handle) : null;
		if (!this.handle) {
			this.handle = this.node;
		}
		this.delay = params.delay > 0 ? params.delay : 0;
		this.skip = params.skip;
		this.mover = params.mover ? params.mover : dojo.dnd.Mover;
		this.events = [dojo.connect(this.handle, "onmousedown", this, "onMouseDown"), dojo.connect(this.handle, "ondragstart", this, "onSelectStart"), dojo.connect(this.handle, "onselectstart", this, "onSelectStart")];
	}, markupFactory:function (params, node) {
		return new dojo.dnd.Moveable(node, params);
	}, destroy:function () {
		dojo.forEach(this.events, dojo.disconnect);
		this.events = this.node = this.handle = null;
	}, onMouseDown:function (e) {
		if (this.skip && dojo.dnd.isFormElement(e)) {
			return;
		}
		if (this.delay) {
			this.events.push(dojo.connect(this.handle, "onmousemove", this, "onMouseMove"), dojo.connect(this.handle, "onmouseup", this, "onMouseUp"));
			this._lastX = e.pageX;
			this._lastY = e.pageY;
		} else {
			this.onDragDetected(e);
		}
		dojo.stopEvent(e);
	}, onMouseMove:function (e) {
		if (Math.abs(e.pageX - this._lastX) > this.delay || Math.abs(e.pageY - this._lastY) > this.delay) {
			this.onMouseUp(e);
			this.onDragDetected(e);
		}
		dojo.stopEvent(e);
	}, onMouseUp:function (e) {
		for (var i = 0; i < 2; ++i) {
			dojo.disconnect(this.events.pop());
		}
		dojo.stopEvent(e);
	}, onSelectStart:function (e) {
		if (!this.skip || !dojo.dnd.isFormElement(e)) {
			dojo.stopEvent(e);
		}
	}, onDragDetected:function (e) {
		new this.mover(this.node, e, this);
	}, onMoveStart:function (mover) {
		dojo.publish("/dnd/move/start", [mover]);
		dojo.addClass(dojo.body(), "dojoMove");
		dojo.addClass(this.node, "dojoMoveItem");
	}, onMoveStop:function (mover) {
		dojo.publish("/dnd/move/stop", [mover]);
		dojo.removeClass(dojo.body(), "dojoMove");
		dojo.removeClass(this.node, "dojoMoveItem");
	}, onFirstMove:function (mover) {
	}, onMove:function (mover, leftTop) {
		this.onMoving(mover, leftTop);
		var s = mover.node.style;
		s.left = leftTop.l + "px";
		s.top = leftTop.t + "px";
		this.onMoved(mover, leftTop);
	}, onMoving:function (mover, leftTop) {
	}, onMoved:function (mover, leftTop) {
	}});
}
if (!dojo._hasResource["dojo.dnd.move"]) {
	dojo._hasResource["dojo.dnd.move"] = true;
	dojo.provide("dojo.dnd.move");
	dojo.declare("dojo.dnd.move.constrainedMoveable", dojo.dnd.Moveable, {constraints:function () {
	}, within:false, markupFactory:function (params, node) {
		return new dojo.dnd.move.constrainedMoveable(node, params);
	}, constructor:function (node, params) {
		if (!params) {
			params = {};
		}
		this.constraints = params.constraints;
		this.within = params.within;
	}, onFirstMove:function (mover) {
		var c = this.constraintBox = this.constraints.call(this, mover);
		c.r = c.l + c.w;
		c.b = c.t + c.h;
		if (this.within) {
			var mb = dojo.marginBox(mover.node);
			c.r -= mb.w;
			c.b -= mb.h;
		}
	}, onMove:function (mover, leftTop) {
		var c = this.constraintBox, s = mover.node.style;
		s.left = (leftTop.l < c.l ? c.l : c.r < leftTop.l ? c.r : leftTop.l) + "px";
		s.top = (leftTop.t < c.t ? c.t : c.b < leftTop.t ? c.b : leftTop.t) + "px";
	}});
	dojo.declare("dojo.dnd.move.boxConstrainedMoveable", dojo.dnd.move.constrainedMoveable, {box:{}, markupFactory:function (params, node) {
		return new dojo.dnd.move.boxConstrainedMoveable(node, params);
	}, constructor:function (node, params) {
		var box = params && params.box;
		this.constraints = function () {
			return box;
		};
	}});
	dojo.declare("dojo.dnd.move.parentConstrainedMoveable", dojo.dnd.move.constrainedMoveable, {area:"content", markupFactory:function (params, node) {
		return new dojo.dnd.move.parentConstrainedMoveable(node, params);
	}, constructor:function (node, params) {
		var area = params && params.area;
		this.constraints = function () {
			var n = this.node.parentNode, s = dojo.getComputedStyle(n), mb = dojo._getMarginBox(n, s);
			if (area == "margin") {
				return mb;
			}
			var t = dojo._getMarginExtents(n, s);
			mb.l += t.l, mb.t += t.t, mb.w -= t.w, mb.h -= t.h;
			if (area == "border") {
				return mb;
			}
			t = dojo._getBorderExtents(n, s);
			mb.l += t.l, mb.t += t.t, mb.w -= t.w, mb.h -= t.h;
			if (area == "padding") {
				return mb;
			}
			t = dojo._getPadExtents(n, s);
			mb.l += t.l, mb.t += t.t, mb.w -= t.w, mb.h -= t.h;
			return mb;
		};
	}});
	dojo.dnd.move.constrainedMover = function (fun, within) {
		dojo.deprecated("dojo.dnd.move.constrainedMover, use dojo.dnd.move.constrainedMoveable instead");
		var mover = function (node, e, notifier) {
			dojo.dnd.Mover.call(this, node, e, notifier);
		};
		dojo.extend(mover, dojo.dnd.Mover.prototype);
		dojo.extend(mover, {onMouseMove:function (e) {
			dojo.dnd.autoScroll(e);
			var m = this.marginBox, c = this.constraintBox, l = m.l + e.pageX, t = m.t + e.pageY;
			l = l < c.l ? c.l : c.r < l ? c.r : l;
			t = t < c.t ? c.t : c.b < t ? c.b : t;
			this.host.onMove(this, {l:l, t:t});
		}, onFirstMove:function () {
			dojo.dnd.Mover.prototype.onFirstMove.call(this);
			var c = this.constraintBox = fun.call(this);
			c.r = c.l + c.w;
			c.b = c.t + c.h;
			if (within) {
				var mb = dojo.marginBox(this.node);
				c.r -= mb.w;
				c.b -= mb.h;
			}
		}});
		return mover;
	};
	dojo.dnd.move.boxConstrainedMover = function (box, within) {
		dojo.deprecated("dojo.dnd.move.boxConstrainedMover, use dojo.dnd.move.boxConstrainedMoveable instead");
		return dojo.dnd.move.constrainedMover(function () {
			return box;
		}, within);
	};
	dojo.dnd.move.parentConstrainedMover = function (area, within) {
		dojo.deprecated("dojo.dnd.move.parentConstrainedMover, use dojo.dnd.move.parentConstrainedMoveable instead");
		var fun = function () {
			var n = this.node.parentNode, s = dojo.getComputedStyle(n), mb = dojo._getMarginBox(n, s);
			if (area == "margin") {
				return mb;
			}
			var t = dojo._getMarginExtents(n, s);
			mb.l += t.l, mb.t += t.t, mb.w -= t.w, mb.h -= t.h;
			if (area == "border") {
				return mb;
			}
			t = dojo._getBorderExtents(n, s);
			mb.l += t.l, mb.t += t.t, mb.w -= t.w, mb.h -= t.h;
			if (area == "padding") {
				return mb;
			}
			t = dojo._getPadExtents(n, s);
			mb.l += t.l, mb.t += t.t, mb.w -= t.w, mb.h -= t.h;
			return mb;
		};
		return dojo.dnd.move.constrainedMover(fun, within);
	};
	dojo.dnd.constrainedMover = dojo.dnd.move.constrainedMover;
	dojo.dnd.boxConstrainedMover = dojo.dnd.move.boxConstrainedMover;
	dojo.dnd.parentConstrainedMover = dojo.dnd.move.parentConstrainedMover;
}
if (!dojo._hasResource["dijit.form.HorizontalSlider"]) {
	dojo._hasResource["dijit.form.HorizontalSlider"] = true;
	dojo.provide("dijit.form.HorizontalSlider");
	dojo.declare("dijit.form.HorizontalSlider", [dijit.form._FormValueWidget, dijit._Container], {templateString:dojo.cache("dijit.form", "templates/HorizontalSlider.html", "<table class=\"dijit dijitReset dijitSlider\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\" rules=\"none\" dojoAttachEvent=\"onkeypress:_onKeyPress,onkeyup:_onKeyUp\"\r\n\t><tr class=\"dijitReset\"\r\n\t\t><td class=\"dijitReset\" colspan=\"2\"></td\r\n\t\t><td dojoAttachPoint=\"topDecoration\" class=\"dijitReset\" style=\"text-align:center;width:100%;\"></td\r\n\t\t><td class=\"dijitReset\" colspan=\"2\"></td\r\n\t></tr\r\n\t><tr class=\"dijitReset\"\r\n\t\t><td class=\"dijitReset dijitSliderButtonContainer dijitSliderButtonContainerH\"\r\n\t\t\t><div class=\"dijitSliderDecrementIconH\" tabIndex=\"-1\" style=\"display:none\" dojoAttachPoint=\"decrementButton\"><span class=\"dijitSliderButtonInner\">-</span></div\r\n\t\t></td\r\n\t\t><td class=\"dijitReset\"\r\n\t\t\t><div class=\"dijitSliderBar dijitSliderBumper dijitSliderBumperH dijitSliderLeftBumper dijitSliderLeftBumper\" dojoAttachEvent=\"onmousedown:_onClkDecBumper\"></div\r\n\t\t></td\r\n\t\t><td class=\"dijitReset\"\r\n\t\t\t><input dojoAttachPoint=\"valueNode\" type=\"hidden\" ${nameAttrSetting}\r\n\t\t\t/><div class=\"dijitReset dijitSliderBarContainerH\" waiRole=\"presentation\" dojoAttachPoint=\"sliderBarContainer\"\r\n\t\t\t\t><div waiRole=\"presentation\" dojoAttachPoint=\"progressBar\" class=\"dijitSliderBar dijitSliderBarH dijitSliderProgressBar dijitSliderProgressBarH\" dojoAttachEvent=\"onmousedown:_onBarClick\"\r\n\t\t\t\t\t><div class=\"dijitSliderMoveable dijitSliderMoveableH\"\r\n\t\t\t\t\t\t><div dojoAttachPoint=\"sliderHandle,focusNode\" class=\"dijitSliderImageHandle dijitSliderImageHandleH\" dojoAttachEvent=\"onmousedown:_onHandleClick\" waiRole=\"slider\" valuemin=\"${minimum}\" valuemax=\"${maximum}\"></div\r\n\t\t\t\t\t></div\r\n\t\t\t\t></div\r\n\t\t\t\t><div waiRole=\"presentation\" dojoAttachPoint=\"remainingBar\" class=\"dijitSliderBar dijitSliderBarH dijitSliderRemainingBar dijitSliderRemainingBarH\" dojoAttachEvent=\"onmousedown:_onBarClick\"></div\r\n\t\t\t></div\r\n\t\t></td\r\n\t\t><td class=\"dijitReset\"\r\n\t\t\t><div class=\"dijitSliderBar dijitSliderBumper dijitSliderBumperH dijitSliderRightBumper dijitSliderRightBumper\" dojoAttachEvent=\"onmousedown:_onClkIncBumper\"></div\r\n\t\t></td\r\n\t\t><td class=\"dijitReset dijitSliderButtonContainer dijitSliderButtonContainerH\" style=\"right:0px;\"\r\n\t\t\t><div class=\"dijitSliderIncrementIconH\" tabIndex=\"-1\" style=\"display:none\" dojoAttachPoint=\"incrementButton\"><span class=\"dijitSliderButtonInner\">+</span></div\r\n\t\t></td\r\n\t></tr\r\n\t><tr class=\"dijitReset\"\r\n\t\t><td class=\"dijitReset\" colspan=\"2\"></td\r\n\t\t><td dojoAttachPoint=\"containerNode,bottomDecoration\" class=\"dijitReset\" style=\"text-align:center;\"></td\r\n\t\t><td class=\"dijitReset\" colspan=\"2\"></td\r\n\t></tr\r\n></table>\r\n"), value:0, showButtons:true, minimum:0, maximum:100, discreteValues:Infinity, pageIncrement:2, clickSelect:true, slideDuration:dijit.defaultDuration, widgetsInTemplate:true, attributeMap:dojo.delegate(dijit.form._FormWidget.prototype.attributeMap, {id:""}), baseClass:"dijitSlider", _mousePixelCoord:"pageX", _pixelCount:"w", _startingPixelCoord:"x", _startingPixelCount:"l", _handleOffsetCoord:"left", _progressPixelSize:"width", _onKeyUp:function (e) {
		if (this.disabled || this.readOnly || e.altKey || e.ctrlKey || e.metaKey) {
			return;
		}
		this._setValueAttr(this.value, true);
	}, _onKeyPress:function (e) {
		if (this.disabled || this.readOnly || e.altKey || e.ctrlKey || e.metaKey) {
			return;
		}
		switch (e.charOrCode) {
		  case dojo.keys.HOME:
			this._setValueAttr(this.minimum, false);
			break;
		  case dojo.keys.END:
			this._setValueAttr(this.maximum, false);
			break;
		  case ((this._descending || this.isLeftToRight()) ? dojo.keys.RIGHT_ARROW : dojo.keys.LEFT_ARROW):
		  case (this._descending === false ? dojo.keys.DOWN_ARROW : dojo.keys.UP_ARROW):
		  case (this._descending === false ? dojo.keys.PAGE_DOWN : dojo.keys.PAGE_UP):
			this.increment(e);
			break;
		  case ((this._descending || this.isLeftToRight()) ? dojo.keys.LEFT_ARROW : dojo.keys.RIGHT_ARROW):
		  case (this._descending === false ? dojo.keys.UP_ARROW : dojo.keys.DOWN_ARROW):
		  case (this._descending === false ? dojo.keys.PAGE_UP : dojo.keys.PAGE_DOWN):
			this.decrement(e);
			break;
		  default:
			return;
		}
		dojo.stopEvent(e);
	}, _onHandleClick:function (e) {
		if (this.disabled || this.readOnly) {
			return;
		}
		if (!dojo.isIE) {
			dijit.focus(this.sliderHandle);
		}
		dojo.stopEvent(e);
	}, _isReversed:function () {
		return !this.isLeftToRight();
	}, _onBarClick:function (e) {
		if (this.disabled || this.readOnly || !this.clickSelect) {
			return;
		}
		dijit.focus(this.sliderHandle);
		dojo.stopEvent(e);
		var abspos = dojo.position(this.sliderBarContainer, true);
		var pixelValue = e[this._mousePixelCoord] - abspos[this._startingPixelCoord];
		this._setPixelValue(this._isReversed() ? (abspos[this._pixelCount] - pixelValue) : pixelValue, abspos[this._pixelCount], true);
		this._movable.onMouseDown(e);
	}, _setPixelValue:function (pixelValue, maxPixels, priorityChange) {
		if (this.disabled || this.readOnly) {
			return;
		}
		pixelValue = pixelValue < 0 ? 0 : maxPixels < pixelValue ? maxPixels : pixelValue;
		var count = this.discreteValues;
		if (count <= 1 || count == Infinity) {
			count = maxPixels;
		}
		count--;
		var pixelsPerValue = maxPixels / count;
		var wholeIncrements = Math.round(pixelValue / pixelsPerValue);
		this._setValueAttr((this.maximum - this.minimum) * wholeIncrements / count + this.minimum, priorityChange);
	}, _setValueAttr:function (value, priorityChange) {
		this.valueNode.value = this.value = value;
		dijit.setWaiState(this.focusNode, "valuenow", value);
		this.inherited(arguments);
		var percent = (value - this.minimum) / (this.maximum - this.minimum);
		var progressBar = (this._descending === false) ? this.remainingBar : this.progressBar;
		var remainingBar = (this._descending === false) ? this.progressBar : this.remainingBar;
		if (this._inProgressAnim && this._inProgressAnim.status != "stopped") {
			this._inProgressAnim.stop(true);
		}
		if (priorityChange && this.slideDuration > 0 && progressBar.style[this._progressPixelSize]) {
			var _this = this;
			var props = {};
			var start = parseFloat(progressBar.style[this._progressPixelSize]);
			var duration = this.slideDuration * (percent - start / 100);
			if (duration == 0) {
				return;
			}
			if (duration < 0) {
				duration = 0 - duration;
			}
			props[this._progressPixelSize] = {start:start, end:percent * 100, units:"%"};
			this._inProgressAnim = dojo.animateProperty({node:progressBar, duration:duration, onAnimate:function (v) {
				remainingBar.style[_this._progressPixelSize] = (100 - parseFloat(v[_this._progressPixelSize])) + "%";
			}, onEnd:function () {
				delete _this._inProgressAnim;
			}, properties:props});
			this._inProgressAnim.play();
		} else {
			progressBar.style[this._progressPixelSize] = (percent * 100) + "%";
			remainingBar.style[this._progressPixelSize] = ((1 - percent) * 100) + "%";
		}
	}, _bumpValue:function (signedChange, priorityChange) {
		if (this.disabled || this.readOnly) {
			return;
		}
		var s = dojo.getComputedStyle(this.sliderBarContainer);
		var c = dojo._getContentBox(this.sliderBarContainer, s);
		var count = this.discreteValues;
		if (count <= 1 || count == Infinity) {
			count = c[this._pixelCount];
		}
		count--;
		var value = (this.value - this.minimum) * count / (this.maximum - this.minimum) + signedChange;
		if (value < 0) {
			value = 0;
		}
		if (value > count) {
			value = count;
		}
		value = value * (this.maximum - this.minimum) / count + this.minimum;
		this._setValueAttr(value, priorityChange);
	}, _onClkBumper:function (val) {
		if (this.disabled || this.readOnly || !this.clickSelect) {
			return;
		}
		this._setValueAttr(val, true);
	}, _onClkIncBumper:function () {
		this._onClkBumper(this._descending === false ? this.minimum : this.maximum);
	}, _onClkDecBumper:function () {
		this._onClkBumper(this._descending === false ? this.maximum : this.minimum);
	}, decrement:function (e) {
		this._bumpValue(e.charOrCode == dojo.keys.PAGE_DOWN ? -this.pageIncrement : -1);
	}, increment:function (e) {
		this._bumpValue(e.charOrCode == dojo.keys.PAGE_UP ? this.pageIncrement : 1);
	}, _mouseWheeled:function (evt) {
		dojo.stopEvent(evt);
		var janky = !dojo.isMozilla;
		var scroll = evt[(janky ? "wheelDelta" : "detail")] * (janky ? 1 : -1);
		this._bumpValue(scroll < 0 ? -1 : 1, true);
	}, startup:function () {
		dojo.forEach(this.getChildren(), function (child) {
			if (this[child.container] != this.containerNode) {
				this[child.container].appendChild(child.domNode);
			}
		}, this);
	}, _typematicCallback:function (count, button, e) {
		if (count == -1) {
			this._setValueAttr(this.value, true);
		} else {
			this[(button == (this._descending ? this.incrementButton : this.decrementButton)) ? "decrement" : "increment"](e);
		}
	}, postCreate:function () {
		if (this.showButtons) {
			this.incrementButton.style.display = "";
			this.decrementButton.style.display = "";
			this._connects.push(dijit.typematic.addMouseListener(this.decrementButton, this, "_typematicCallback", 25, 500));
			this._connects.push(dijit.typematic.addMouseListener(this.incrementButton, this, "_typematicCallback", 25, 500));
		}
		this.connect(this.domNode, !dojo.isMozilla ? "onmousewheel" : "DOMMouseScroll", "_mouseWheeled");
		var mover = dojo.declare(dijit.form._SliderMover, {widget:this});
		this._movable = new dojo.dnd.Moveable(this.sliderHandle, {mover:mover});
		var label = dojo.query("label[for=\"" + this.id + "\"]");
		if (label.length) {
			label[0].id = (this.id + "_label");
			dijit.setWaiState(this.focusNode, "labelledby", label[0].id);
		}
		dijit.setWaiState(this.focusNode, "valuemin", this.minimum);
		dijit.setWaiState(this.focusNode, "valuemax", this.maximum);
		this.inherited(arguments);
		this._layoutHackIE7();
	}, destroy:function () {
		this._movable.destroy();
		if (this._inProgressAnim && this._inProgressAnim.status != "stopped") {
			this._inProgressAnim.stop(true);
		}
		this._supportingWidgets = dijit.findWidgets(this.domNode);
		this.inherited(arguments);
	}});
	dojo.declare("dijit.form._SliderMover", dojo.dnd.Mover, {onMouseMove:function (e) {
		var widget = this.widget;
		var abspos = widget._abspos;
		if (!abspos) {
			abspos = widget._abspos = dojo.position(widget.sliderBarContainer, true);
			widget._setPixelValue_ = dojo.hitch(widget, "_setPixelValue");
			widget._isReversed_ = widget._isReversed();
		}
		var pixelValue = e[widget._mousePixelCoord] - abspos[widget._startingPixelCoord];
		widget._setPixelValue_(widget._isReversed_ ? (abspos[widget._pixelCount] - pixelValue) : pixelValue, abspos[widget._pixelCount], false);
	}, destroy:function (e) {
		dojo.dnd.Mover.prototype.destroy.apply(this, arguments);
		var widget = this.widget;
		widget._abspos = null;
		widget._setValueAttr(widget.value, true);
	}});
}
if (!dojo._hasResource["dijit.form.VerticalSlider"]) {
	dojo._hasResource["dijit.form.VerticalSlider"] = true;
	dojo.provide("dijit.form.VerticalSlider");
	dojo.declare("dijit.form.VerticalSlider", dijit.form.HorizontalSlider, {templateString:dojo.cache("dijit.form", "templates/VerticalSlider.html", "<table class=\"dijitReset dijitSlider\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\" rules=\"none\" dojoAttachEvent=\"onkeypress:_onKeyPress,onkeyup:_onKeyUp\"\r\n><tbody class=\"dijitReset\"\r\n\t><tr class=\"dijitReset\"\r\n\t\t><td class=\"dijitReset\"></td\r\n\t\t><td class=\"dijitReset dijitSliderButtonContainer dijitSliderButtonContainerV\"\r\n\t\t\t><div class=\"dijitSliderIncrementIconV\" tabIndex=\"-1\" style=\"display:none\" dojoAttachPoint=\"decrementButton\"><span class=\"dijitSliderButtonInner\">+</span></div\r\n\t\t></td\r\n\t\t><td class=\"dijitReset\"></td\r\n\t></tr\r\n\t><tr class=\"dijitReset\"\r\n\t\t><td class=\"dijitReset\"></td\r\n\t\t><td class=\"dijitReset\"\r\n\t\t\t><center><div class=\"dijitSliderBar dijitSliderBumper dijitSliderBumperV dijitSliderTopBumper dijitSliderTopBumper\" dojoAttachEvent=\"onmousedown:_onClkIncBumper\"></div></center\r\n\t\t></td\r\n\t\t><td class=\"dijitReset\"></td\r\n\t></tr\r\n\t><tr class=\"dijitReset\"\r\n\t\t><td dojoAttachPoint=\"leftDecoration\" class=\"dijitReset\" style=\"text-align:center;height:100%;\"></td\r\n\t\t><td class=\"dijitReset\" style=\"height:100%;\"\r\n\t\t\t><input dojoAttachPoint=\"valueNode\" type=\"hidden\" ${nameAttrSetting}\r\n\t\t\t/><center class=\"dijitReset dijitSliderBarContainerV\" waiRole=\"presentation\" dojoAttachPoint=\"sliderBarContainer\"\r\n\t\t\t\t><div waiRole=\"presentation\" dojoAttachPoint=\"remainingBar\" class=\"dijitSliderBar dijitSliderBarV dijitSliderRemainingBar dijitSliderRemainingBarV\" dojoAttachEvent=\"onmousedown:_onBarClick\"><!--#5629--></div\r\n\t\t\t\t><div waiRole=\"presentation\" dojoAttachPoint=\"progressBar\" class=\"dijitSliderBar dijitSliderBarV dijitSliderProgressBar dijitSliderProgressBarV\" dojoAttachEvent=\"onmousedown:_onBarClick\"\r\n\t\t\t\t\t><div class=\"dijitSliderMoveable\" style=\"vertical-align:top;\"\r\n\t\t\t\t\t\t><div dojoAttachPoint=\"sliderHandle,focusNode\" class=\"dijitSliderImageHandle dijitSliderImageHandleV\" dojoAttachEvent=\"onmousedown:_onHandleClick\" waiRole=\"slider\" valuemin=\"${minimum}\" valuemax=\"${maximum}\"></div\r\n\t\t\t\t\t></div\r\n\t\t\t\t></div\r\n\t\t\t></center\r\n\t\t></td\r\n\t\t><td dojoAttachPoint=\"containerNode,rightDecoration\" class=\"dijitReset\" style=\"text-align:center;height:100%;\"></td\r\n\t></tr\r\n\t><tr class=\"dijitReset\"\r\n\t\t><td class=\"dijitReset\"></td\r\n\t\t><td class=\"dijitReset\"\r\n\t\t\t><center><div class=\"dijitSliderBar dijitSliderBumper dijitSliderBumperV dijitSliderBottomBumper dijitSliderBottomBumper\" dojoAttachEvent=\"onmousedown:_onClkDecBumper\"></div></center\r\n\t\t></td\r\n\t\t><td class=\"dijitReset\"></td\r\n\t></tr\r\n\t><tr class=\"dijitReset\"\r\n\t\t><td class=\"dijitReset\"></td\r\n\t\t><td class=\"dijitReset dijitSliderButtonContainer dijitSliderButtonContainerV\"\r\n\t\t\t><div class=\"dijitSliderDecrementIconV\" tabIndex=\"-1\" style=\"display:none\" dojoAttachPoint=\"incrementButton\"><span class=\"dijitSliderButtonInner\">-</span></div\r\n\t\t></td\r\n\t\t><td class=\"dijitReset\"></td\r\n\t></tr\r\n></tbody></table>\r\n"), _mousePixelCoord:"pageY", _pixelCount:"h", _startingPixelCoord:"y", _startingPixelCount:"t", _handleOffsetCoord:"top", _progressPixelSize:"height", _descending:true, startup:function () {
		if (this._started) {
			return;
		}
		if (!this.isLeftToRight() && dojo.isMoz) {
			if (this.leftDecoration) {
				this._rtlRectify(this.leftDecoration);
			}
			if (this.rightDecoration) {
				this._rtlRectify(this.rightDecoration);
			}
		}
		this.inherited(arguments);
	}, _isReversed:function () {
		return this._descending;
	}, _rtlRectify:function (decorationNode) {
		var childNodes = [];
		while (decorationNode.firstChild) {
			childNodes.push(decorationNode.firstChild);
			decorationNode.removeChild(decorationNode.firstChild);
		}
		for (var i = childNodes.length - 1; i >= 0; i--) {
			if (childNodes[i]) {
				decorationNode.appendChild(childNodes[i]);
			}
		}
	}});
}
if (!dojo._hasResource["dijit.form.HorizontalRule"]) {
	dojo._hasResource["dijit.form.HorizontalRule"] = true;
	dojo.provide("dijit.form.HorizontalRule");
	dojo.declare("dijit.form.HorizontalRule", [dijit._Widget, dijit._Templated], {templateString:"<div class=\"dijitRuleContainer dijitRuleContainerH\"></div>", count:3, container:"containerNode", ruleStyle:"", _positionPrefix:"<div class=\"dijitRuleMark dijitRuleMarkH\" style=\"left:", _positionSuffix:"%;", _suffix:"\"></div>", _genHTML:function (pos, ndx) {
		return this._positionPrefix + pos + this._positionSuffix + this.ruleStyle + this._suffix;
	}, _isHorizontal:true, postCreate:function () {
		var innerHTML;
		if (this.count == 1) {
			innerHTML = this._genHTML(50, 0);
		} else {
			var i;
			var interval = 100 / (this.count - 1);
			if (!this._isHorizontal || this.isLeftToRight()) {
				innerHTML = this._genHTML(0, 0);
				for (i = 1; i < this.count - 1; i++) {
					innerHTML += this._genHTML(interval * i, i);
				}
				innerHTML += this._genHTML(100, this.count - 1);
			} else {
				innerHTML = this._genHTML(100, 0);
				for (i = 1; i < this.count - 1; i++) {
					innerHTML += this._genHTML(100 - interval * i, i);
				}
				innerHTML += this._genHTML(0, this.count - 1);
			}
		}
		this.domNode.innerHTML = innerHTML;
	}});
}
if (!dojo._hasResource["dijit.form.VerticalRule"]) {
	dojo._hasResource["dijit.form.VerticalRule"] = true;
	dojo.provide("dijit.form.VerticalRule");
	dojo.declare("dijit.form.VerticalRule", dijit.form.HorizontalRule, {templateString:"<div class=\"dijitRuleContainer dijitRuleContainerV\"></div>", _positionPrefix:"<div class=\"dijitRuleMark dijitRuleMarkV\" style=\"top:", _isHorizontal:false});
}
if (!dojo._hasResource["dijit.form.HorizontalRuleLabels"]) {
	dojo._hasResource["dijit.form.HorizontalRuleLabels"] = true;
	dojo.provide("dijit.form.HorizontalRuleLabels");
	dojo.declare("dijit.form.HorizontalRuleLabels", dijit.form.HorizontalRule, {templateString:"<div class=\"dijitRuleContainer dijitRuleContainerH dijitRuleLabelsContainer dijitRuleLabelsContainerH\"></div>", labelStyle:"", labels:[], numericMargin:0, minimum:0, maximum:1, constraints:{pattern:"#%"}, _positionPrefix:"<div class=\"dijitRuleLabelContainer dijitRuleLabelContainerH\" style=\"left:", _labelPrefix:"\"><span class=\"dijitRuleLabel dijitRuleLabelH\">", _suffix:"</span></div>", _calcPosition:function (pos) {
		return pos;
	}, _genHTML:function (pos, ndx) {
		return this._positionPrefix + this._calcPosition(pos) + this._positionSuffix + this.labelStyle + this._labelPrefix + this.labels[ndx] + this._suffix;
	}, getLabels:function () {
		var labels = this.labels;
		if (!labels.length) {
			labels = dojo.query("> li", this.srcNodeRef).map(function (node) {
				return String(node.innerHTML);
			});
		}
		this.srcNodeRef.innerHTML = "";
		if (!labels.length && this.count > 1) {
			var start = this.minimum;
			var inc = (this.maximum - start) / (this.count - 1);
			for (var i = 0; i < this.count; i++) {
				labels.push((i < this.numericMargin || i >= (this.count - this.numericMargin)) ? "" : dojo.number.format(start, this.constraints));
				start += inc;
			}
		}
		return labels;
	}, postMixInProperties:function () {
		this.inherited(arguments);
		this.labels = this.getLabels();
		this.count = this.labels.length;
	}});
}
if (!dojo._hasResource["dijit.form.VerticalRuleLabels"]) {
	dojo._hasResource["dijit.form.VerticalRuleLabels"] = true;
	dojo.provide("dijit.form.VerticalRuleLabels");
	dojo.declare("dijit.form.VerticalRuleLabels", dijit.form.HorizontalRuleLabels, {templateString:"<div class=\"dijitRuleContainer dijitRuleContainerV dijitRuleLabelsContainer dijitRuleLabelsContainerV\"></div>", _positionPrefix:"<div class=\"dijitRuleLabelContainer dijitRuleLabelContainerV\" style=\"top:", _labelPrefix:"\"><span class=\"dijitRuleLabel dijitRuleLabelV\">", _calcPosition:function (pos) {
		return 100 - pos;
	}});
}
if (!dojo._hasResource["dijit.form.Slider"]) {
	dojo._hasResource["dijit.form.Slider"] = true;
	dojo.provide("dijit.form.Slider");
	dojo.deprecated("Call require() for HorizontalSlider / VerticalRule, explicitly rather than 'dijit.form.Slider' itself", "", "2.0");
}
if (!dojo._hasResource["dijit._editor.selection"]) {
	dojo._hasResource["dijit._editor.selection"] = true;
	dojo.provide("dijit._editor.selection");
	dojo.mixin(dijit._editor.selection, {getType:function () {
		if (dojo.isIE) {
			return dojo.doc.selection.type.toLowerCase();
		} else {
			var stype = "text";
			var oSel;
			try {
				oSel = dojo.global.getSelection();
			}
			catch (e) {
			}
			if (oSel && oSel.rangeCount == 1) {
				var oRange = oSel.getRangeAt(0);
				if ((oRange.startContainer == oRange.endContainer) && ((oRange.endOffset - oRange.startOffset) == 1) && (oRange.startContainer.nodeType != 3)) {
					stype = "control";
				}
			}
			return stype;
		}
	}, getSelectedText:function () {
		if (dojo.isIE) {
			if (dijit._editor.selection.getType() == "control") {
				return null;
			}
			return dojo.doc.selection.createRange().text;
		} else {
			var selection = dojo.global.getSelection();
			if (selection) {
				return selection.toString();
			}
		}
		return "";
	}, getSelectedHtml:function () {
		if (dojo.isIE) {
			if (dijit._editor.selection.getType() == "control") {
				return null;
			}
			return dojo.doc.selection.createRange().htmlText;
		} else {
			var selection = dojo.global.getSelection();
			if (selection && selection.rangeCount) {
				var i;
				var html = "";
				for (i = 0; i < selection.rangeCount; i++) {
					var frag = selection.getRangeAt(i).cloneContents();
					var div = dojo.doc.createElement("div");
					div.appendChild(frag);
					html += div.innerHTML;
				}
				return html;
			}
			return null;
		}
	}, getSelectedElement:function () {
		if (dijit._editor.selection.getType() == "control") {
			if (dojo.isIE) {
				var range = dojo.doc.selection.createRange();
				if (range && range.item) {
					return dojo.doc.selection.createRange().item(0);
				}
			} else {
				var selection = dojo.global.getSelection();
				return selection.anchorNode.childNodes[selection.anchorOffset];
			}
		}
		return null;
	}, getParentElement:function () {
		if (dijit._editor.selection.getType() == "control") {
			var p = this.getSelectedElement();
			if (p) {
				return p.parentNode;
			}
		} else {
			if (dojo.isIE) {
				var r = dojo.doc.selection.createRange();
				r.collapse(true);
				return r.parentElement();
			} else {
				var selection = dojo.global.getSelection();
				if (selection) {
					var node = selection.anchorNode;
					while (node && (node.nodeType != 1)) {
						node = node.parentNode;
					}
					return node;
				}
			}
		}
		return null;
	}, hasAncestorElement:function (tagName) {
		return this.getAncestorElement.apply(this, arguments) != null;
	}, getAncestorElement:function (tagName) {
		var node = this.getSelectedElement() || this.getParentElement();
		return this.getParentOfType(node, arguments);
	}, isTag:function (node, tags) {
		if (node && node.tagName) {
			var _nlc = node.tagName.toLowerCase();
			for (var i = 0; i < tags.length; i++) {
				var _tlc = String(tags[i]).toLowerCase();
				if (_nlc == _tlc) {
					return _tlc;
				}
			}
		}
		return "";
	}, getParentOfType:function (node, tags) {
		while (node) {
			if (this.isTag(node, tags).length) {
				return node;
			}
			node = node.parentNode;
		}
		return null;
	}, collapse:function (beginning) {
		if (window.getSelection) {
			var selection = dojo.global.getSelection();
			if (selection.removeAllRanges) {
				if (beginning) {
					selection.collapseToStart();
				} else {
					selection.collapseToEnd();
				}
			} else {
				selection.collapse(beginning);
			}
		} else {
			if (dojo.isIE) {
				var range = dojo.doc.selection.createRange();
				range.collapse(beginning);
				range.select();
			}
		}
	}, remove:function () {
		var sel = dojo.doc.selection;
		if (dojo.isIE) {
			if (sel.type.toLowerCase() != "none") {
				sel.clear();
			}
			return sel;
		} else {
			sel = dojo.global.getSelection();
			sel.deleteFromDocument();
			return sel;
		}
	}, selectElementChildren:function (element, nochangefocus) {
		var win = dojo.global;
		var doc = dojo.doc;
		var range;
		element = dojo.byId(element);
		if (doc.selection && dojo.isIE && dojo.body().createTextRange) {
			range = element.ownerDocument.body.createTextRange();
			range.moveToElementText(element);
			if (!nochangefocus) {
				try {
					range.select();
				}
				catch (e) {
				}
			}
		} else {
			if (win.getSelection) {
				var selection = dojo.global.getSelection();
				if (selection.setBaseAndExtent) {
					selection.setBaseAndExtent(element, 0, element, element.innerText.length - 1);
				} else {
					if (dojo.isOpera) {
						if (selection.rangeCount) {
							range = selection.getRangeAt(0);
						} else {
							range = doc.createRange();
						}
						range.setStart(element, 0);
						range.setEnd(element, (element.nodeType == 3) ? element.length : element.childNodes.length);
						selection.addRange(range);
					} else {
						if (selection.selectAllChildren) {
							selection.selectAllChildren(element);
						}
					}
				}
			}
		}
	}, selectElement:function (element, nochangefocus) {
		var range;
		var doc = dojo.doc;
		var win = dojo.global;
		element = dojo.byId(element);
		if (dojo.isIE && dojo.body().createTextRange) {
			try {
				range = dojo.body().createControlRange();
				range.addElement(element);
				if (!nochangefocus) {
					range.select();
				}
			}
			catch (e) {
				this.selectElementChildren(element, nochangefocus);
			}
		} else {
			if (dojo.global.getSelection) {
				var selection = win.getSelection();
				range = doc.createRange();
				if (selection.removeAllRanges) {
					if (dojo.isOpera) {
						if (selection.getRangeAt(0)) {
							range = selection.getRangeAt(0);
						}
					}
					range.selectNode(element);
					selection.removeAllRanges();
					selection.addRange(range);
				}
			}
		}
	}});
}
if (!dojo._hasResource["dijit._editor.range"]) {
	dojo._hasResource["dijit._editor.range"] = true;
	dojo.provide("dijit._editor.range");
	dijit.range = {};
	dijit.range.getIndex = function (node, parent) {
		var ret = [], retR = [];
		var stop = parent;
		var onode = node;
		var pnode, n;
		while (node != stop) {
			var i = 0;
			pnode = node.parentNode;
			while ((n = pnode.childNodes[i++])) {
				if (n === node) {
					--i;
					break;
				}
			}
			if (i >= pnode.childNodes.length) {
				dojo.debug("Error finding index of a node in dijit.range.getIndex");
			}
			ret.unshift(i);
			retR.unshift(i - pnode.childNodes.length);
			node = pnode;
		}
		if (ret.length > 0 && onode.nodeType == 3) {
			n = onode.previousSibling;
			while (n && n.nodeType == 3) {
				ret[ret.length - 1]--;
				n = n.previousSibling;
			}
			n = onode.nextSibling;
			while (n && n.nodeType == 3) {
				retR[retR.length - 1]++;
				n = n.nextSibling;
			}
		}
		return {o:ret, r:retR};
	};
	dijit.range.getNode = function (index, parent) {
		if (!dojo.isArray(index) || index.length == 0) {
			return parent;
		}
		var node = parent;
		dojo.every(index, function (i) {
			if (i >= 0 && i < node.childNodes.length) {
				node = node.childNodes[i];
			} else {
				node = null;
				console.debug("Error: can not find node with index", index, "under parent node", parent);
				return false;
			}
			return true;
		});
		return node;
	};
	dijit.range.getCommonAncestor = function (n1, n2) {
		var getAncestors = function (n) {
			var as = [];
			while (n) {
				as.unshift(n);
				if (n.nodeName != "BODY") {
					n = n.parentNode;
				} else {
					break;
				}
			}
			return as;
		};
		var n1as = getAncestors(n1);
		var n2as = getAncestors(n2);
		var m = Math.min(n1as.length, n2as.length);
		var com = n1as[0];
		for (var i = 1; i < m; i++) {
			if (n1as[i] === n2as[i]) {
				com = n1as[i];
			} else {
				break;
			}
		}
		return com;
	};
	dijit.range.getAncestor = function (node, regex, root) {
		root = root || node.ownerDocument.body;
		while (node && node !== root) {
			var name = node.nodeName.toUpperCase();
			if (regex.test(name)) {
				return node;
			}
			node = node.parentNode;
		}
		return null;
	};
	dijit.range.BlockTagNames = /^(?:P|DIV|H1|H2|H3|H4|H5|H6|ADDRESS|PRE|OL|UL|LI|DT|DE)$/;
	dijit.range.getBlockAncestor = function (node, regex, root) {
		root = root || node.ownerDocument.body;
		regex = regex || dijit.range.BlockTagNames;
		var block = null, blockContainer;
		while (node && node !== root) {
			var name = node.nodeName.toUpperCase();
			if (!block && regex.test(name)) {
				block = node;
			}
			if (!blockContainer && (/^(?:BODY|TD|TH|CAPTION)$/).test(name)) {
				blockContainer = node;
			}
			node = node.parentNode;
		}
		return {blockNode:block, blockContainer:blockContainer || node.ownerDocument.body};
	};
	dijit.range.atBeginningOfContainer = function (container, node, offset) {
		var atBeginning = false;
		var offsetAtBeginning = (offset == 0);
		if (!offsetAtBeginning && node.nodeType == 3) {
			if (/^[\s\xA0]+$/.test(node.nodeValue.substr(0, offset))) {
				offsetAtBeginning = true;
			}
		}
		if (offsetAtBeginning) {
			var cnode = node;
			atBeginning = true;
			while (cnode && cnode !== container) {
				if (cnode.previousSibling) {
					atBeginning = false;
					break;
				}
				cnode = cnode.parentNode;
			}
		}
		return atBeginning;
	};
	dijit.range.atEndOfContainer = function (container, node, offset) {
		var atEnd = false;
		var offsetAtEnd = (offset == (node.length || node.childNodes.length));
		if (!offsetAtEnd && node.nodeType == 3) {
			if (/^[\s\xA0]+$/.test(node.nodeValue.substr(offset))) {
				offsetAtEnd = true;
			}
		}
		if (offsetAtEnd) {
			var cnode = node;
			atEnd = true;
			while (cnode && cnode !== container) {
				if (cnode.nextSibling) {
					atEnd = false;
					break;
				}
				cnode = cnode.parentNode;
			}
		}
		return atEnd;
	};
	dijit.range.adjacentNoneTextNode = function (startnode, next) {
		var node = startnode;
		var len = (0 - startnode.length) || 0;
		var prop = next ? "nextSibling" : "previousSibling";
		while (node) {
			if (node.nodeType != 3) {
				break;
			}
			len += node.length;
			node = node[prop];
		}
		return [node, len];
	};
	dijit.range._w3c = Boolean(window["getSelection"]);
	dijit.range.create = function (win) {
		if (dijit.range._w3c) {
			return (win || dojo.global).document.createRange();
		} else {
			return new dijit.range.W3CRange;
		}
	};
	dijit.range.getSelection = function (win, ignoreUpdate) {
		if (dijit.range._w3c) {
			return win.getSelection();
		} else {
			var s = new dijit.range.ie.selection(win);
			if (!ignoreUpdate) {
				s._getCurrentSelection();
			}
			return s;
		}
	};
	if (!dijit.range._w3c) {
		dijit.range.ie = {cachedSelection:{}, selection:function (win) {
			this._ranges = [];
			this.addRange = function (r, internal) {
				this._ranges.push(r);
				if (!internal) {
					r._select();
				}
				this.rangeCount = this._ranges.length;
			};
			this.removeAllRanges = function () {
				this._ranges = [];
				this.rangeCount = 0;
			};
			var _initCurrentRange = function () {
				var r = win.document.selection.createRange();
				var type = win.document.selection.type.toUpperCase();
				if (type == "CONTROL") {
					return new dijit.range.W3CRange(dijit.range.ie.decomposeControlRange(r));
				} else {
					return new dijit.range.W3CRange(dijit.range.ie.decomposeTextRange(r));
				}
			};
			this.getRangeAt = function (i) {
				return this._ranges[i];
			};
			this._getCurrentSelection = function () {
				this.removeAllRanges();
				var r = _initCurrentRange();
				if (r) {
					this.addRange(r, true);
				}
			};
		}, decomposeControlRange:function (range) {
			var firstnode = range.item(0), lastnode = range.item(range.length - 1);
			var startContainer = firstnode.parentNode, endContainer = lastnode.parentNode;
			var startOffset = dijit.range.getIndex(firstnode, startContainer).o;
			var endOffset = dijit.range.getIndex(lastnode, endContainer).o + 1;
			return [startContainer, startOffset, endContainer, endOffset];
		}, getEndPoint:function (range, end) {
			var atmrange = range.duplicate();
			atmrange.collapse(!end);
			var cmpstr = "EndTo" + (end ? "End" : "Start");
			var parentNode = atmrange.parentElement();
			var startnode, startOffset, lastNode;
			if (parentNode.childNodes.length > 0) {
				dojo.every(parentNode.childNodes, function (node, i) {
					var calOffset;
					if (node.nodeType != 3) {
						atmrange.moveToElementText(node);
						if (atmrange.compareEndPoints(cmpstr, range) > 0) {
							if (lastNode && lastNode.nodeType == 3) {
								startnode = lastNode;
								calOffset = true;
							} else {
								startnode = parentNode;
								startOffset = i;
								return false;
							}
						} else {
							if (i == parentNode.childNodes.length - 1) {
								startnode = parentNode;
								startOffset = parentNode.childNodes.length;
								return false;
							}
						}
					} else {
						if (i == parentNode.childNodes.length - 1) {
							startnode = node;
							calOffset = true;
						}
					}
					if (calOffset && startnode) {
						var prevnode = dijit.range.adjacentNoneTextNode(startnode)[0];
						if (prevnode) {
							startnode = prevnode.nextSibling;
						} else {
							startnode = parentNode.firstChild;
						}
						var prevnodeobj = dijit.range.adjacentNoneTextNode(startnode);
						prevnode = prevnodeobj[0];
						var lenoffset = prevnodeobj[1];
						if (prevnode) {
							atmrange.moveToElementText(prevnode);
							atmrange.collapse(false);
						} else {
							atmrange.moveToElementText(parentNode);
						}
						atmrange.setEndPoint(cmpstr, range);
						startOffset = atmrange.text.length - lenoffset;
						return false;
					}
					lastNode = node;
					return true;
				});
			} else {
				startnode = parentNode;
				startOffset = 0;
			}
			if (!end && startnode.nodeType == 1 && startOffset == startnode.childNodes.length) {
				var nextnode = startnode.nextSibling;
				if (nextnode && nextnode.nodeType == 3) {
					startnode = nextnode;
					startOffset = 0;
				}
			}
			return [startnode, startOffset];
		}, setEndPoint:function (range, container, offset) {
			var atmrange = range.duplicate(), node, len;
			if (container.nodeType != 3) {
				if (offset > 0) {
					node = container.childNodes[offset - 1];
					if (node.nodeType == 3) {
						container = node;
						offset = node.length;
					} else {
						if (node.nextSibling && node.nextSibling.nodeType == 3) {
							container = node.nextSibling;
							offset = 0;
						} else {
							atmrange.moveToElementText(node.nextSibling ? node : container);
							var parent = node.parentNode;
							var tempNode = parent.insertBefore(node.ownerDocument.createTextNode(" "), node.nextSibling);
							atmrange.collapse(false);
							parent.removeChild(tempNode);
						}
					}
				} else {
					atmrange.moveToElementText(container);
					atmrange.collapse(true);
				}
			}
			if (container.nodeType == 3) {
				var prevnodeobj = dijit.range.adjacentNoneTextNode(container);
				var prevnode = prevnodeobj[0];
				len = prevnodeobj[1];
				if (prevnode) {
					atmrange.moveToElementText(prevnode);
					atmrange.collapse(false);
					if (prevnode.contentEditable != "inherit") {
						len++;
					}
				} else {
					atmrange.moveToElementText(container.parentNode);
					atmrange.collapse(true);
				}
				offset += len;
				if (offset > 0) {
					if (atmrange.move("character", offset) != offset) {
						console.error("Error when moving!");
					}
				}
			}
			return atmrange;
		}, decomposeTextRange:function (range) {
			var tmpary = dijit.range.ie.getEndPoint(range);
			var startContainer = tmpary[0], startOffset = tmpary[1];
			var endContainer = tmpary[0], endOffset = tmpary[1];
			if (range.htmlText.length) {
				if (range.htmlText == range.text) {
					endOffset = startOffset + range.text.length;
				} else {
					tmpary = dijit.range.ie.getEndPoint(range, true);
					endContainer = tmpary[0], endOffset = tmpary[1];
				}
			}
			return [startContainer, startOffset, endContainer, endOffset];
		}, setRange:function (range, startContainer, startOffset, endContainer, endOffset, collapsed) {
			var start = dijit.range.ie.setEndPoint(range, startContainer, startOffset);
			range.setEndPoint("StartToStart", start);
			if (!collapsed) {
				var end = dijit.range.ie.setEndPoint(range, endContainer, endOffset);
			}
			range.setEndPoint("EndToEnd", end || start);
			return range;
		}};
		dojo.declare("dijit.range.W3CRange", null, {constructor:function () {
			if (arguments.length > 0) {
				this.setStart(arguments[0][0], arguments[0][1]);
				this.setEnd(arguments[0][2], arguments[0][3]);
			} else {
				this.commonAncestorContainer = null;
				this.startContainer = null;
				this.startOffset = 0;
				this.endContainer = null;
				this.endOffset = 0;
				this.collapsed = true;
			}
		}, _updateInternal:function () {
			if (this.startContainer !== this.endContainer) {
				this.commonAncestorContainer = dijit.range.getCommonAncestor(this.startContainer, this.endContainer);
			} else {
				this.commonAncestorContainer = this.startContainer;
			}
			this.collapsed = (this.startContainer === this.endContainer) && (this.startOffset == this.endOffset);
		}, setStart:function (node, offset) {
			offset = parseInt(offset);
			if (this.startContainer === node && this.startOffset == offset) {
				return;
			}
			delete this._cachedBookmark;
			this.startContainer = node;
			this.startOffset = offset;
			if (!this.endContainer) {
				this.setEnd(node, offset);
			} else {
				this._updateInternal();
			}
		}, setEnd:function (node, offset) {
			offset = parseInt(offset);
			if (this.endContainer === node && this.endOffset == offset) {
				return;
			}
			delete this._cachedBookmark;
			this.endContainer = node;
			this.endOffset = offset;
			if (!this.startContainer) {
				this.setStart(node, offset);
			} else {
				this._updateInternal();
			}
		}, setStartAfter:function (node, offset) {
			this._setPoint("setStart", node, offset, 1);
		}, setStartBefore:function (node, offset) {
			this._setPoint("setStart", node, offset, 0);
		}, setEndAfter:function (node, offset) {
			this._setPoint("setEnd", node, offset, 1);
		}, setEndBefore:function (node, offset) {
			this._setPoint("setEnd", node, offset, 0);
		}, _setPoint:function (what, node, offset, ext) {
			var index = dijit.range.getIndex(node, node.parentNode).o;
			this[what](node.parentNode, index.pop() + ext);
		}, _getIERange:function () {
			var r = (this._body || this.endContainer.ownerDocument.body).createTextRange();
			dijit.range.ie.setRange(r, this.startContainer, this.startOffset, this.endContainer, this.endOffset, this.collapsed);
			return r;
		}, getBookmark:function (body) {
			this._getIERange();
			return this._cachedBookmark;
		}, _select:function () {
			var r = this._getIERange();
			r.select();
		}, deleteContents:function () {
			var r = this._getIERange();
			r.pasteHTML("");
			this.endContainer = this.startContainer;
			this.endOffset = this.startOffset;
			this.collapsed = true;
		}, cloneRange:function () {
			var r = new dijit.range.W3CRange([this.startContainer, this.startOffset, this.endContainer, this.endOffset]);
			r._body = this._body;
			return r;
		}, detach:function () {
			this._body = null;
			this.commonAncestorContainer = null;
			this.startContainer = null;
			this.startOffset = 0;
			this.endContainer = null;
			this.endOffset = 0;
			this.collapsed = true;
		}});
	}
}
if (!dojo._hasResource["dijit._editor.html"]) {
	dojo._hasResource["dijit._editor.html"] = true;
	dojo.provide("dijit._editor.html");
	dijit._editor.escapeXml = function (str, noSingleQuotes) {
		str = str.replace(/&/gm, "&amp;").replace(/</gm, "&lt;").replace(/>/gm, "&gt;").replace(/"/gm, "&quot;");
		if (!noSingleQuotes) {
			str = str.replace(/'/gm, "&#39;");
		}
		return str;
	};
	dijit._editor.getNodeHtml = function (node) {
		var output;
		switch (node.nodeType) {
		  case 1:
			var lName = node.nodeName.toLowerCase();
			if (lName.charAt(0) == "/") {
				return "";
			}
			output = "<" + lName;
			var attrarray = [];
			var attr;
			if (dojo.isIE && node.outerHTML) {
				var s = node.outerHTML;
				s = s.substr(0, s.indexOf(">")).replace(/(['"])[^"']*\1/g, "");
				var reg = /(\b\w+)\s?=/g;
				var m, key;
				while ((m = reg.exec(s))) {
					key = m[1];
					if (key.substr(0, 3) != "_dj") {
						if (key == "src" || key == "href") {
							if (node.getAttribute("_djrealurl")) {
								attrarray.push([key, node.getAttribute("_djrealurl")]);
								continue;
							}
						}
						var val, match;
						switch (key) {
						  case "style":
							val = node.style.cssText.toLowerCase();
							break;
						  case "class":
							val = node.className;
							break;
						  case "width":
							if (lName === "img") {
								match = /width=(\S+)/i.exec(s);
								if (match) {
									val = match[1];
								}
								break;
							}
						  case "height":
							if (lName === "img") {
								match = /height=(\S+)/i.exec(s);
								if (match) {
									val = match[1];
								}
								break;
							}
						  default:
							val = node.getAttribute(key);
						}
						if (val != null) {
							attrarray.push([key, val.toString()]);
						}
					}
				}
			} else {
				var i = 0;
				while ((attr = node.attributes[i++])) {
					var n = attr.name;
					if (n.substr(0, 3) != "_dj") {
						var v = attr.value;
						if (n == "src" || n == "href") {
							if (node.getAttribute("_djrealurl")) {
								v = node.getAttribute("_djrealurl");
							}
						}
						attrarray.push([n, v]);
					}
				}
			}
			attrarray.sort(function (a, b) {
				return a[0] < b[0] ? -1 : (a[0] == b[0] ? 0 : 1);
			});
			var j = 0;
			while ((attr = attrarray[j++])) {
				output += " " + attr[0] + "=\"" + (dojo.isString(attr[1]) ? dijit._editor.escapeXml(attr[1], true) : attr[1]) + "\"";
			}
			if (lName === "script") {
				output += ">" + node.innerHTML + "</" + lName + ">";
			} else {
				if (node.childNodes.length) {
					output += ">" + dijit._editor.getChildrenHtml(node) + "</" + lName + ">";
				} else {
					switch (lName) {
					  case "br":
					  case "hr":
					  case "img":
					  case "input":
					  case "base":
					  case "meta":
					  case "area":
					  case "basefont":
						output += " />";
						break;
					  default:
						output += "></" + lName + ">";
					}
				}
			}
			break;
		  case 4:
		  case 3:
			output = dijit._editor.escapeXml(node.nodeValue, true);
			break;
		  case 8:
			output = "<!--" + dijit._editor.escapeXml(node.nodeValue, true) + "-->";
			break;
		  default:
			output = "<!-- Element not recognized - Type: " + node.nodeType + " Name: " + node.nodeName + "-->";
		}
		return output;
	};
	dijit._editor.getChildrenHtml = function (dom) {
		var out = "";
		if (!dom) {
			return out;
		}
		var nodes = dom["childNodes"] || dom;
		var checkParent = !dojo.isIE || nodes !== dom;
		var node, i = 0;
		while ((node = nodes[i++])) {
			if (!checkParent || node.parentNode == dom) {
				out += dijit._editor.getNodeHtml(node);
			}
		}
		return out;
	};
}
if (!dojo._hasResource["dijit._editor.RichText"]) {
	dojo._hasResource["dijit._editor.RichText"] = true;
	dojo.provide("dijit._editor.RichText");
	if (!dojo.config["useXDomain"] || dojo.config["allowXdRichTextSave"]) {
		if (dojo._postLoad) {
			(function () {
				var savetextarea = dojo.doc.createElement("textarea");
				savetextarea.id = dijit._scopeName + "._editor.RichText.savedContent";
				dojo.style(savetextarea, {display:"none", position:"absolute", top:"-100px", height:"3px", width:"3px"});
				dojo.body().appendChild(savetextarea);
			})();
		} else {
			try {
				dojo.doc.write("<textarea id=\"" + dijit._scopeName + "._editor.RichText.savedContent\" " + "style=\"display:none;position:absolute;top:-100px;left:-100px;height:3px;width:3px;overflow:hidden;\"></textarea>");
			}
			catch (e) {
			}
		}
	}
	dojo.declare("dijit._editor.RichText", dijit._Widget, {constructor:function (params) {
		this.contentPreFilters = [];
		this.contentPostFilters = [];
		this.contentDomPreFilters = [];
		this.contentDomPostFilters = [];
		this.editingAreaStyleSheets = [];
		this.events = [].concat(this.events);
		this._keyHandlers = {};
		this.contentPreFilters.push(dojo.hitch(this, "_preFixUrlAttributes"));
		if (dojo.isMoz) {
			this.contentPreFilters.push(this._normalizeFontStyle);
			this.contentPostFilters.push(this._removeMozBogus);
		}
		if (dojo.isWebKit) {
			this.contentPreFilters.push(this._removeWebkitBogus);
			this.contentPostFilters.push(this._removeWebkitBogus);
		}
		if (dojo.isIE) {
			this.contentPostFilters.push(this._normalizeFontStyle);
		}
		this.onLoadDeferred = new dojo.Deferred();
	}, inheritWidth:false, focusOnLoad:false, name:"", styleSheets:"", _content:"", height:"300px", minHeight:"1em", isClosed:true, isLoaded:false, _SEPARATOR:"@@**%%__RICHTEXTBOUNDRY__%%**@@", onLoadDeferred:null, isTabIndent:false, disableSpellCheck:false, postCreate:function () {
		if ("textarea" == this.domNode.tagName.toLowerCase()) {
			console.warn("RichText should not be used with the TEXTAREA tag.  See dijit._editor.RichText docs.");
		}
		dojo.publish(dijit._scopeName + "._editor.RichText::init", [this]);
		this.open();
		this.setupDefaultShortcuts();
	}, setupDefaultShortcuts:function () {
		var exec = dojo.hitch(this, function (cmd, arg) {
			return function () {
				return !this.execCommand(cmd, arg);
			};
		});
		var ctrlKeyHandlers = {b:exec("bold"), i:exec("italic"), u:exec("underline"), a:exec("selectall"), s:function () {
			this.save(true);
		}, m:function () {
			this.isTabIndent = !this.isTabIndent;
		}, "1":exec("formatblock", "h1"), "2":exec("formatblock", "h2"), "3":exec("formatblock", "h3"), "4":exec("formatblock", "h4"), "\\":exec("insertunorderedlist")};
		if (!dojo.isIE) {
			ctrlKeyHandlers.Z = exec("redo");
		}
		for (var key in ctrlKeyHandlers) {
			this.addKeyHandler(key, true, false, ctrlKeyHandlers[key]);
		}
	}, events:["onKeyPress", "onKeyDown", "onKeyUp", "onClick"], captureEvents:[], _editorCommandsLocalized:false, _localizeEditorCommands:function () {
		if (this._editorCommandsLocalized) {
			return;
		}
		this._editorCommandsLocalized = true;
		var formats = ["div", "p", "pre", "h1", "h2", "h3", "h4", "h5", "h6", "ol", "ul", "address"];
		var localhtml = "", format, i = 0;
		while ((format = formats[i++])) {
			if (format.charAt(1) != "l") {
				localhtml += "<" + format + "><span>content</span></" + format + "><br/>";
			} else {
				localhtml += "<" + format + "><li>content</li></" + format + "><br/>";
			}
		}
		var div = dojo.doc.createElement("div");
		dojo.style(div, {position:"absolute", top:"-2000px"});
		dojo.doc.body.appendChild(div);
		div.innerHTML = localhtml;
		var node = div.firstChild;
		while (node) {
			dijit._editor.selection.selectElement(node.firstChild);
			dojo.withGlobal(this.window, "selectElement", dijit._editor.selection, [node.firstChild]);
			var nativename = node.tagName.toLowerCase();
			this._local2NativeFormatNames[nativename] = document.queryCommandValue("formatblock");
			this._native2LocalFormatNames[this._local2NativeFormatNames[nativename]] = nativename;
			node = node.nextSibling.nextSibling;
		}
		dojo.body().removeChild(div);
	}, open:function (element) {
		if (!this.onLoadDeferred || this.onLoadDeferred.fired >= 0) {
			this.onLoadDeferred = new dojo.Deferred();
		}
		if (!this.isClosed) {
			this.close();
		}
		dojo.publish(dijit._scopeName + "._editor.RichText::open", [this]);
		this._content = "";
		if (arguments.length == 1 && element.nodeName) {
			this.domNode = element;
		}
		var dn = this.domNode;
		var html;
		if (dn.nodeName && dn.nodeName.toLowerCase() == "textarea") {
			var ta = (this.textarea = dn);
			this.name = ta.name;
			html = ta.value;
			dn = this.domNode = dojo.doc.createElement("div");
			dn.setAttribute("widgetId", this.id);
			ta.removeAttribute("widgetId");
			dn.cssText = ta.cssText;
			dn.className += " " + ta.className;
			dojo.place(dn, ta, "before");
			var tmpFunc = dojo.hitch(this, function () {
				dojo.style(ta, {display:"block", position:"absolute", top:"-1000px"});
				if (dojo.isIE) {
					var s = ta.style;
					this.__overflow = s.overflow;
					s.overflow = "hidden";
				}
			});
			if (dojo.isIE) {
				setTimeout(tmpFunc, 10);
			} else {
				tmpFunc();
			}
			if (ta.form) {
				dojo.connect(ta.form, "onsubmit", this, function () {
					ta.value = this.getValue();
				});
			}
		} else {
			html = dijit._editor.getChildrenHtml(dn);
			dn.innerHTML = "";
		}
		var content = dojo.contentBox(dn);
		this._oldHeight = content.h;
		this._oldWidth = content.w;
		this.savedContent = html;
		if (dn.nodeName && dn.nodeName == "LI") {
			dn.innerHTML = " <br>";
		}
		this.editingArea = dn.ownerDocument.createElement("div");
		dn.appendChild(this.editingArea);
		if (this.name !== "" && (!dojo.config["useXDomain"] || dojo.config["allowXdRichTextSave"])) {
			var saveTextarea = dojo.byId(dijit._scopeName + "._editor.RichText.savedContent");
			if (saveTextarea.value !== "") {
				var datas = saveTextarea.value.split(this._SEPARATOR), i = 0, dat;
				while ((dat = datas[i++])) {
					var data = dat.split(":");
					if (data[0] == this.name) {
						html = data[1];
						datas.splice(i, 1);
						break;
					}
				}
			}
			dojo.addOnUnload(dojo.hitch(this, "_saveContent"));
		}
		this.isClosed = false;
		var ifr = (this.editorObject = this.iframe = dojo.doc.createElement("iframe"));
		ifr.id = this.id + "_iframe";
		this._iframeSrc = this._getIframeDocTxt();
		ifr.style.border = "none";
		ifr.style.width = "100%";
		if (this._layoutMode) {
			ifr.style.height = "100%";
		} else {
			if (dojo.isIE >= 7) {
				if (this.height) {
					ifr.style.height = this.height;
				}
				if (this.minHeight) {
					ifr.style.minHeight = this.minHeight;
				}
			} else {
				ifr.style.height = this.height ? this.height : this.minHeight;
			}
		}
		ifr.frameBorder = 0;
		ifr._loadFunc = dojo.hitch(this, function (win) {
			this.window = win;
			this.document = this.window.document;
			if (dojo.isIE) {
				this._localizeEditorCommands();
			}
			this.onLoad(html);
			this.savedContent = this.getValue(true);
		});
		var s = "javascript:parent." + dijit._scopeName + ".byId(\"" + this.id + "\")._iframeSrc";
		ifr.setAttribute("src", s);
		this.editingArea.appendChild(ifr);
		if (dojo.isSafari) {
			setTimeout(function () {
				ifr.setAttribute("src", s);
			}, 0);
		}
		if (dn.nodeName == "LI") {
			dn.lastChild.style.marginTop = "-1.2em";
		}
		dojo.addClass(this.domNode, "RichTextEditable");
	}, _local2NativeFormatNames:{}, _native2LocalFormatNames:{}, _getIframeDocTxt:function () {
		var _cs = dojo.getComputedStyle(this.domNode);
		var html = "";
		if (dojo.isIE || (!this.height && !dojo.isMoz)) {
			html = "<div></div>";
		} else {
			if (dojo.isMoz) {
				this._cursorToStart = true;
				html = "&nbsp;";
			}
		}
		var font = [_cs.fontWeight, _cs.fontSize, _cs.fontFamily].join(" ");
		var lineHeight = _cs.lineHeight;
		if (lineHeight.indexOf("px") >= 0) {
			lineHeight = parseFloat(lineHeight) / parseFloat(_cs.fontSize);
		} else {
			if (lineHeight.indexOf("em") >= 0) {
				lineHeight = parseFloat(lineHeight);
			} else {
				lineHeight = "normal";
			}
		}
		var userStyle = "";
		this.style.replace(/(^|;)(line-|font-?)[^;]+/g, function (match) {
			userStyle += match.replace(/^;/g, "") + ";";
		});
		var label = dojo.query("label[for=\"" + this.id + "\"]");
		return [this.isLeftToRight() ? "<html><head>" : "<html dir='rtl'><head>", (dojo.isMoz && label.length ? "<title>" + label[0].innerHTML + "</title>" : ""), "<meta http-equiv='Content-Type' content='text/html'>", "<style>", "body,html {", "\tbackground:transparent;", "\tpadding: 1px 0 0 0;", "\tmargin: -1px 0 0 0;", (dojo.isWebKit ? "\twidth: 100%;" : ""), (dojo.isWebKit ? "\theight: 100%;" : ""), "}", "body{", "\ttop:0px; left:0px; right:0px;", "\tfont:", font, ";", ((this.height || dojo.isOpera) ? "" : "position: fixed;"), "\tmin-height:", this.minHeight, ";", "\tline-height:", lineHeight, "}", "p{ margin: 1em 0; }", (this.height ? "" : "body,html{overflow-y:hidden;/*for IE*/} body > div {overflow-x:auto;/*FF:horizontal scrollbar*/ overflow-y:hidden;/*safari*/ min-height:" + this.minHeight + ";/*safari*/}"), "li > ul:-moz-first-node, li > ol:-moz-first-node{ padding-top: 1.2em; } ", "li{ min-height:1.2em; }", "</style>", this._applyEditingAreaStyleSheets(), "</head><body onload='frameElement._loadFunc(window,document)' style='" + userStyle + "'>", html, "</body></html>"].join("");
	}, _applyEditingAreaStyleSheets:function () {
		var files = [];
		if (this.styleSheets) {
			files = this.styleSheets.split(";");
			this.styleSheets = "";
		}
		files = files.concat(this.editingAreaStyleSheets);
		this.editingAreaStyleSheets = [];
		var text = "", i = 0, url;
		while ((url = files[i++])) {
			var abstring = (new dojo._Url(dojo.global.location, url)).toString();
			this.editingAreaStyleSheets.push(abstring);
			text += "<link rel=\"stylesheet\" type=\"text/css\" href=\"" + abstring + "\"/>";
		}
		return text;
	}, addStyleSheet:function (uri) {
		var url = uri.toString();
		if (url.charAt(0) == "." || (url.charAt(0) != "/" && !uri.host)) {
			url = (new dojo._Url(dojo.global.location, url)).toString();
		}
		if (dojo.indexOf(this.editingAreaStyleSheets, url) > -1) {
			return;
		}
		this.editingAreaStyleSheets.push(url);
		this.onLoadDeferred.addCallback(dojo.hitch(function () {
			if (this.document.createStyleSheet) {
				this.document.createStyleSheet(url);
			} else {
				var head = this.document.getElementsByTagName("head")[0];
				var stylesheet = this.document.createElement("link");
				stylesheet.rel = "stylesheet";
				stylesheet.type = "text/css";
				stylesheet.href = url;
				head.appendChild(stylesheet);
			}
		}));
	}, removeStyleSheet:function (uri) {
		var url = uri.toString();
		if (url.charAt(0) == "." || (url.charAt(0) != "/" && !uri.host)) {
			url = (new dojo._Url(dojo.global.location, url)).toString();
		}
		var index = dojo.indexOf(this.editingAreaStyleSheets, url);
		if (index == -1) {
			return;
		}
		delete this.editingAreaStyleSheets[index];
		dojo.withGlobal(this.window, "query", dojo, ["link:[href=\"" + url + "\"]"]).orphan();
	}, disabled:false, _mozSettingProps:{"styleWithCSS":false}, _setDisabledAttr:function (value) {
		this.disabled = value;
		if (!this.isLoaded) {
			return;
		}
		value = !!value;
		if (dojo.isIE || dojo.isWebKit || dojo.isOpera) {
			var preventIEfocus = dojo.isIE && (this.isLoaded || !this.focusOnLoad);
			if (preventIEfocus) {
				this.editNode.unselectable = "on";
			}
			this.editNode.contentEditable = !value;
			if (preventIEfocus) {
				var _this = this;
				setTimeout(function () {
					_this.editNode.unselectable = "off";
				}, 0);
			}
		} else {
			try {
				this.document.designMode = (value ? "off" : "on");
			}
			catch (e) {
				return;
			}
			if (!value && this._mozSettingProps) {
				var ps = this._mozSettingProps;
				for (var n in ps) {
					if (ps.hasOwnProperty(n)) {
						try {
							this.document.execCommand(n, false, ps[n]);
						}
						catch (e2) {
						}
					}
				}
			}
		}
		this._disabledOK = true;
	}, onLoad:function (html) {
		if (!this.window.__registeredWindow) {
			this.window.__registeredWindow = true;
			this._iframeRegHandle = dijit.registerIframe(this.iframe);
		}
		if (!dojo.isIE && (this.height || dojo.isMoz)) {
			this.editNode = this.document.body;
		} else {
			this.editNode = this.document.body.firstChild;
			var _this = this;
			if (dojo.isIE) {
				var tabStop = (this.tabStop = dojo.doc.createElement("<div tabIndex=-1>"));
				this.editingArea.appendChild(tabStop);
				this.iframe.onfocus = function () {
					_this.editNode.setActive();
				};
			}
		}
		this.focusNode = this.editNode;
		var events = this.events.concat(this.captureEvents);
		var ap = this.iframe ? this.document : this.editNode;
		dojo.forEach(events, function (item) {
			this.connect(ap, item.toLowerCase(), item);
		}, this);
		if (dojo.isIE) {
			this.connect(this.document, "onmousedown", "_onIEMouseDown");
			this.editNode.style.zoom = 1;
		}
		if (dojo.isWebKit) {
			this._webkitListener = this.connect(this.document, "onmouseup", "onDisplayChanged");
		}
		if (dojo.isIE) {
			try {
				this.document.execCommand("RespectVisibilityInDesign", true, null);
			}
			catch (e) {
			}
		}
		this.isLoaded = true;
		this.attr("disabled", this.disabled);
		this.setValue(html);
		if (this.onLoadDeferred) {
			this.onLoadDeferred.callback(true);
		}
		this.onDisplayChanged();
		if (this.focusOnLoad) {
			dojo.addOnLoad(dojo.hitch(this, function () {
				setTimeout(dojo.hitch(this, "focus"), this.updateInterval);
			}));
		}
	}, onKeyDown:function (e) {
		if (e.keyCode === dojo.keys.TAB && this.isTabIndent) {
			dojo.stopEvent(e);
			if (this.queryCommandEnabled((e.shiftKey ? "outdent" : "indent"))) {
				this.execCommand((e.shiftKey ? "outdent" : "indent"));
			}
		}
		if (dojo.isIE) {
			if (e.keyCode == dojo.keys.TAB && !this.isTabIndent) {
				if (e.shiftKey && !e.ctrlKey && !e.altKey) {
					this.iframe.focus();
				} else {
					if (!e.shiftKey && !e.ctrlKey && !e.altKey) {
						this.tabStop.focus();
					}
				}
			} else {
				if (e.keyCode === dojo.keys.BACKSPACE && this.document.selection.type === "Control") {
					dojo.stopEvent(e);
					this.execCommand("delete");
				} else {
					if ((65 <= e.keyCode && e.keyCode <= 90) || (e.keyCode >= 37 && e.keyCode <= 40)) {
						e.charCode = e.keyCode;
						this.onKeyPress(e);
					}
				}
			}
		}
		return true;
	}, onKeyUp:function (e) {
		return;
	}, setDisabled:function (disabled) {
		dojo.deprecated("dijit.Editor::setDisabled is deprecated", "use dijit.Editor::attr(\"disabled\",boolean) instead", 2);
		this.attr("disabled", disabled);
	}, _setValueAttr:function (value) {
		this.setValue(value);
	}, _setDisableSpellCheckAttr:function (disabled) {
		if (this.document) {
			dojo.attr(this.document.body, "spellcheck", !disabled);
		} else {
			this.onLoadDeferred.addCallback(dojo.hitch(this, function () {
				dojo.attr(this.document.body, "spellcheck", !disabled);
			}));
		}
		this.disableSpellCheck = disabled;
	}, onKeyPress:function (e) {
		var c = (e.keyChar && e.keyChar.toLowerCase()) || e.keyCode, handlers = this._keyHandlers[c], args = arguments;
		if (handlers && !e.altKey) {
			dojo.some(handlers, function (h) {
				if (!(h.shift ^ e.shiftKey) && !(h.ctrl ^ e.ctrlKey)) {
					if (!h.handler.apply(this, args)) {
						e.preventDefault();
					}
					return true;
				}
			}, this);
		}
		if (!this._onKeyHitch) {
			this._onKeyHitch = dojo.hitch(this, "onKeyPressed");
		}
		setTimeout(this._onKeyHitch, 1);
		return true;
	}, addKeyHandler:function (key, ctrl, shift, handler) {
		if (!dojo.isArray(this._keyHandlers[key])) {
			this._keyHandlers[key] = [];
		}
		this._keyHandlers[key].push({shift:shift || false, ctrl:ctrl || false, handler:handler});
	}, onKeyPressed:function () {
		this.onDisplayChanged();
	}, onClick:function (e) {
		this.onDisplayChanged(e);
	}, _onIEMouseDown:function (e) {
		if (!this._focused && !this.disabled) {
			this.focus();
		}
	}, _onBlur:function (e) {
		this.inherited(arguments);
		var _c = this.getValue(true);
		if (_c != this.savedContent) {
			this.onChange(_c);
			this.savedContent = _c;
		}
	}, _onFocus:function (e) {
		if (!this.disabled) {
			if (!this._disabledOK) {
				this.attr("disabled", false);
			}
			this.inherited(arguments);
		}
	}, blur:function () {
		if (!dojo.isIE && this.window.document.documentElement && this.window.document.documentElement.focus) {
			this.window.document.documentElement.focus();
		} else {
			if (dojo.doc.body.focus) {
				dojo.doc.body.focus();
			}
		}
	}, focus:function () {
		if (!dojo.isIE) {
			dijit.focus(this.iframe);
			if (this._cursorToStart) {
				delete this._cursorToStart;
				if (this.editNode.childNodes && this.editNode.childNodes.length === 1 && this.editNode.innerHTML === "&nbsp;") {
					this.placeCursorAtStart();
				}
			}
		} else {
			if (this.editNode && this.editNode.focus) {
				this.iframe.fireEvent("onfocus", document.createEventObject());
			}
		}
	}, updateInterval:200, _updateTimer:null, onDisplayChanged:function (e) {
		if (this._updateTimer) {
			clearTimeout(this._updateTimer);
		}
		if (!this._updateHandler) {
			this._updateHandler = dojo.hitch(this, "onNormalizedDisplayChanged");
		}
		this._updateTimer = setTimeout(this._updateHandler, this.updateInterval);
	}, onNormalizedDisplayChanged:function () {
		delete this._updateTimer;
	}, onChange:function (newContent) {
	}, _normalizeCommand:function (cmd, argument) {
		var command = cmd.toLowerCase();
		if (command == "formatblock") {
			if (dojo.isSafari && argument === undefined) {
				command = "heading";
			}
		} else {
			if (command == "hilitecolor" && !dojo.isMoz) {
				command = "backcolor";
			}
		}
		return command;
	}, _qcaCache:{}, queryCommandAvailable:function (command) {
		var ca = this._qcaCache[command];
		if (ca !== undefined) {
			return ca;
		}
		return (this._qcaCache[command] = this._queryCommandAvailable(command));
	}, _queryCommandAvailable:function (command) {
		var ie = 1;
		var mozilla = 1 << 1;
		var webkit = 1 << 2;
		var opera = 1 << 3;
		var webkit420 = 1 << 4;
		function isSupportedBy(browsers) {
			return {ie:Boolean(browsers & ie), mozilla:Boolean(browsers & mozilla), webkit:Boolean(browsers & webkit), webkit420:Boolean(browsers & webkit420), opera:Boolean(browsers & opera)};
		}
		var supportedBy = null;
		switch (command.toLowerCase()) {
		  case "bold":
		  case "italic":
		  case "underline":
		  case "subscript":
		  case "superscript":
		  case "fontname":
		  case "fontsize":
		  case "forecolor":
		  case "hilitecolor":
		  case "justifycenter":
		  case "justifyfull":
		  case "justifyleft":
		  case "justifyright":
		  case "delete":
		  case "selectall":
		  case "toggledir":
			supportedBy = isSupportedBy(mozilla | ie | webkit | opera);
			break;
		  case "createlink":
		  case "unlink":
		  case "removeformat":
		  case "inserthorizontalrule":
		  case "insertimage":
		  case "insertorderedlist":
		  case "insertunorderedlist":
		  case "indent":
		  case "outdent":
		  case "formatblock":
		  case "inserthtml":
		  case "undo":
		  case "redo":
		  case "strikethrough":
		  case "tabindent":
			supportedBy = isSupportedBy(mozilla | ie | opera | webkit420);
			break;
		  case "blockdirltr":
		  case "blockdirrtl":
		  case "dirltr":
		  case "dirrtl":
		  case "inlinedirltr":
		  case "inlinedirrtl":
			supportedBy = isSupportedBy(ie);
			break;
		  case "cut":
		  case "copy":
		  case "paste":
			supportedBy = isSupportedBy(ie | mozilla | webkit420);
			break;
		  case "inserttable":
			supportedBy = isSupportedBy(mozilla | ie);
			break;
		  case "insertcell":
		  case "insertcol":
		  case "insertrow":
		  case "deletecells":
		  case "deletecols":
		  case "deleterows":
		  case "mergecells":
		  case "splitcell":
			supportedBy = isSupportedBy(ie | mozilla);
			break;
		  default:
			return false;
		}
		return (dojo.isIE && supportedBy.ie) || (dojo.isMoz && supportedBy.mozilla) || (dojo.isWebKit && supportedBy.webkit) || (dojo.isWebKit > 420 && supportedBy.webkit420) || (dojo.isOpera && supportedBy.opera);
	}, execCommand:function (command, argument) {
		var returnValue;
		this.focus();
		command = this._normalizeCommand(command, argument);
		if (argument !== undefined) {
			if (command == "heading") {
				throw new Error("unimplemented");
			} else {
				if ((command == "formatblock") && dojo.isIE) {
					argument = "<" + argument + ">";
				}
			}
		}
		var implFunc = "_" + command + "Impl";
		if (this[implFunc]) {
			returnValue = this[implFunc](argument);
		} else {
			argument = arguments.length > 1 ? argument : null;
			if (argument || command != "createlink") {
				returnValue = this.document.execCommand(command, false, argument);
			}
		}
		this.onDisplayChanged();
		return returnValue;
	}, queryCommandEnabled:function (command) {
		if (this.disabled || !this._disabledOK) {
			return false;
		}
		command = this._normalizeCommand(command);
		if (dojo.isMoz || dojo.isWebKit) {
			if (command == "unlink") {
				return this._sCall("hasAncestorElement", ["a"]);
			} else {
				if (command == "inserttable") {
					return true;
				}
			}
		}
		if (dojo.isWebKit) {
			if (command == "copy") {
				command = "cut";
			} else {
				if (command == "paste") {
					return true;
				}
			}
		}
		var elem = dojo.isIE ? this.document.selection.createRange() : this.document;
		try {
			return elem.queryCommandEnabled(command);
		}
		catch (e) {
			return false;
		}
	}, queryCommandState:function (command) {
		if (this.disabled || !this._disabledOK) {
			return false;
		}
		command = this._normalizeCommand(command);
		try {
			return this.document.queryCommandState(command);
		}
		catch (e) {
			return false;
		}
	}, queryCommandValue:function (command) {
		if (this.disabled || !this._disabledOK) {
			return false;
		}
		var r;
		command = this._normalizeCommand(command);
		if (dojo.isIE && command == "formatblock") {
			r = this._native2LocalFormatNames[this.document.queryCommandValue(command)];
		} else {
			if (dojo.isMoz && command === "hilitecolor") {
				var oldValue;
				try {
					oldValue = this.document.queryCommandValue("styleWithCSS");
				}
				catch (e) {
					oldValue = false;
				}
				this.document.execCommand("styleWithCSS", false, true);
				r = this.document.queryCommandValue(command);
				this.document.execCommand("styleWithCSS", false, oldValue);
			} else {
				r = this.document.queryCommandValue(command);
			}
		}
		return r;
	}, _sCall:function (name, args) {
		return dojo.withGlobal(this.window, name, dijit._editor.selection, args);
	}, placeCursorAtStart:function () {
		this.focus();
		var isvalid = false;
		if (dojo.isMoz) {
			var first = this.editNode.firstChild;
			while (first) {
				if (first.nodeType == 3) {
					if (first.nodeValue.replace(/^\s+|\s+$/g, "").length > 0) {
						isvalid = true;
						this._sCall("selectElement", [first]);
						break;
					}
				} else {
					if (first.nodeType == 1) {
						isvalid = true;
						var tg = first.tagName ? first.tagName.toLowerCase() : "";
						if (/br|input|img|base|meta|area|basefont|hr|link/.test(tg)) {
							this._sCall("selectElement", [first]);
						} else {
							this._sCall("selectElementChildren", [first]);
						}
						break;
					}
				}
				first = first.nextSibling;
			}
		} else {
			isvalid = true;
			this._sCall("selectElementChildren", [this.editNode]);
		}
		if (isvalid) {
			this._sCall("collapse", [true]);
		}
	}, placeCursorAtEnd:function () {
		this.focus();
		var isvalid = false;
		if (dojo.isMoz) {
			var last = this.editNode.lastChild;
			while (last) {
				if (last.nodeType == 3) {
					if (last.nodeValue.replace(/^\s+|\s+$/g, "").length > 0) {
						isvalid = true;
						this._sCall("selectElement", [last]);
						break;
					}
				} else {
					if (last.nodeType == 1) {
						isvalid = true;
						if (last.lastChild) {
							this._sCall("selectElement", [last.lastChild]);
						} else {
							this._sCall("selectElement", [last]);
						}
						break;
					}
				}
				last = last.previousSibling;
			}
		} else {
			isvalid = true;
			this._sCall("selectElementChildren", [this.editNode]);
		}
		if (isvalid) {
			this._sCall("collapse", [false]);
		}
	}, getValue:function (nonDestructive) {
		if (this.textarea) {
			if (this.isClosed || !this.isLoaded) {
				return this.textarea.value;
			}
		}
		return this._postFilterContent(null, nonDestructive);
	}, _getValueAttr:function () {
		return this.getValue(true);
	}, setValue:function (html) {
		if (!this.isLoaded) {
			this.onLoadDeferred.addCallback(dojo.hitch(this, function () {
				this.setValue(html);
			}));
			return;
		}
		if (this.textarea && (this.isClosed || !this.isLoaded)) {
			this.textarea.value = html;
		} else {
			html = this._preFilterContent(html);
			var node = this.isClosed ? this.domNode : this.editNode;
			if (!html && dojo.isWebKit) {
				this._cursorToStart = true;
				html = "&nbsp;";
			}
			node.innerHTML = html;
			this._preDomFilterContent(node);
		}
		this.onDisplayChanged();
	}, replaceValue:function (html) {
		if (this.isClosed) {
			this.setValue(html);
		} else {
			if (this.window && this.window.getSelection && !dojo.isMoz) {
				this.setValue(html);
			} else {
				if (this.window && this.window.getSelection) {
					html = this._preFilterContent(html);
					this.execCommand("selectall");
					if (!html) {
						this._cursorToStart = true;
						html = "&nbsp;";
					}
					this.execCommand("inserthtml", html);
					this._preDomFilterContent(this.editNode);
				} else {
					if (this.document && this.document.selection) {
						this.setValue(html);
					}
				}
			}
		}
	}, _preFilterContent:function (html) {
		var ec = html;
		dojo.forEach(this.contentPreFilters, function (ef) {
			if (ef) {
				ec = ef(ec);
			}
		});
		return ec;
	}, _preDomFilterContent:function (dom) {
		dom = dom || this.editNode;
		dojo.forEach(this.contentDomPreFilters, function (ef) {
			if (ef && dojo.isFunction(ef)) {
				ef(dom);
			}
		}, this);
	}, _postFilterContent:function (dom, nonDestructive) {
		var ec;
		if (!dojo.isString(dom)) {
			dom = dom || this.editNode;
			if (this.contentDomPostFilters.length) {
				if (nonDestructive) {
					dom = dojo.clone(dom);
				}
				dojo.forEach(this.contentDomPostFilters, function (ef) {
					dom = ef(dom);
				});
			}
			ec = dijit._editor.getChildrenHtml(dom);
		} else {
			ec = dom;
		}
		if (!dojo.trim(ec.replace(/^\xA0\xA0*/, "").replace(/\xA0\xA0*$/, "")).length) {
			ec = "";
		}
		dojo.forEach(this.contentPostFilters, function (ef) {
			ec = ef(ec);
		});
		return ec;
	}, _saveContent:function (e) {
		var saveTextarea = dojo.byId(dijit._scopeName + "._editor.RichText.savedContent");
		if (saveTextarea.value) {
			saveTextarea.value += this._SEPARATOR;
		}
		saveTextarea.value += this.name + ":" + this.getValue(true);
	}, escapeXml:function (str, noSingleQuotes) {
		str = str.replace(/&/gm, "&amp;").replace(/</gm, "&lt;").replace(/>/gm, "&gt;").replace(/"/gm, "&quot;");
		if (!noSingleQuotes) {
			str = str.replace(/'/gm, "&#39;");
		}
		return str;
	}, getNodeHtml:function (node) {
		dojo.deprecated("dijit.Editor::getNodeHtml is deprecated", "use dijit._editor.getNodeHtml instead", 2);
		return dijit._editor.getNodeHtml(node);
	}, getNodeChildrenHtml:function (dom) {
		dojo.deprecated("dijit.Editor::getNodeChildrenHtml is deprecated", "use dijit._editor.getChildrenHtml instead", 2);
		return dijit._editor.getChildrenHtml(dom);
	}, close:function (save) {
		if (this.isClosed) {
			return false;
		}
		if (!arguments.length) {
			save = true;
		}
		this._content = this.getValue();
		var changed = (this.savedContent != this._content);
		if (this.interval) {
			clearInterval(this.interval);
		}
		if (this._webkitListener) {
			this.disconnect(this._webkitListener);
			delete this._webkitListener;
		}
		if (dojo.isIE) {
			this.iframe.onfocus = null;
		}
		this.iframe._loadFunc = null;
		if (this._iframeRegHandle) {
			dijit.unregisterIframe(this._iframeRegHandle);
			delete this._iframeRegHandle;
		}
		if (this.textarea) {
			var s = this.textarea.style;
			s.position = "";
			s.left = s.top = "";
			if (dojo.isIE) {
				s.overflow = this.__overflow;
				this.__overflow = null;
			}
			this.textarea.value = save ? this._content : this.savedContent;
			dojo.destroy(this.domNode);
			this.domNode = this.textarea;
		} else {
			this.domNode.innerHTML = save ? this._content : this.savedContent;
		}
		delete this.iframe;
		dojo.removeClass(this.domNode, "RichTextEditable");
		this.isClosed = true;
		this.isLoaded = false;
		delete this.editNode;
		delete this.focusNode;
		if (this.window && this.window._frameElement) {
			this.window._frameElement = null;
		}
		this.window = null;
		this.document = null;
		this.editingArea = null;
		this.editorObject = null;
		return changed;
	}, destroy:function () {
		if (!this.isClosed) {
			this.close(false);
		}
		this.inherited(arguments);
	}, _removeMozBogus:function (html) {
		return html.replace(/\stype="_moz"/gi, "").replace(/\s_moz_dirty=""/gi, "").replace(/_moz_resizing="(true|false)"/gi, "");
	}, _removeWebkitBogus:function (html) {
		html = html.replace(/\sclass="webkit-block-placeholder"/gi, "");
		html = html.replace(/\sclass="apple-style-span"/gi, "");
		return html;
	}, _normalizeFontStyle:function (html) {
		return html.replace(/<(\/)?strong([ \>])/gi, "<$1b$2").replace(/<(\/)?em([ \>])/gi, "<$1i$2");
	}, _preFixUrlAttributes:function (html) {
		return html.replace(/(?:(<a(?=\s).*?\shref=)("|')(.*?)\2)|(?:(<a\s.*?href=)([^"'][^ >]+))/gi, "$1$4$2$3$5$2 _djrealurl=$2$3$5$2").replace(/(?:(<img(?=\s).*?\ssrc=)("|')(.*?)\2)|(?:(<img\s.*?src=)([^"'][^ >]+))/gi, "$1$4$2$3$5$2 _djrealurl=$2$3$5$2");
	}, _inserthorizontalruleImpl:function (argument) {
		if (dojo.isIE) {
			return this._inserthtmlImpl("<hr>");
		}
		return this.document.execCommand("inserthorizontalrule", false, argument);
	}, _unlinkImpl:function (argument) {
		if ((this.queryCommandEnabled("unlink")) && (dojo.isMoz || dojo.isWebKit)) {
			var a = this._sCall("getAncestorElement", ["a"]);
			this._sCall("selectElement", [a]);
			return this.document.execCommand("unlink", false, null);
		}
		return this.document.execCommand("unlink", false, argument);
	}, _hilitecolorImpl:function (argument) {
		var returnValue;
		if (dojo.isMoz) {
			this.document.execCommand("styleWithCSS", false, true);
			returnValue = this.document.execCommand("hilitecolor", false, argument);
			this.document.execCommand("styleWithCSS", false, false);
		} else {
			returnValue = this.document.execCommand("hilitecolor", false, argument);
		}
		return returnValue;
	}, _backcolorImpl:function (argument) {
		if (dojo.isIE) {
			argument = argument ? argument : null;
		}
		return this.document.execCommand("backcolor", false, argument);
	}, _forecolorImpl:function (argument) {
		if (dojo.isIE) {
			argument = argument ? argument : null;
		}
		return this.document.execCommand("forecolor", false, argument);
	}, _inserthtmlImpl:function (argument) {
		argument = this._preFilterContent(argument);
		var rv = true;
		if (dojo.isIE) {
			var insertRange = this.document.selection.createRange();
			if (this.document.selection.type.toUpperCase() == "CONTROL") {
				var n = insertRange.item(0);
				while (insertRange.length) {
					insertRange.remove(insertRange.item(0));
				}
				n.outerHTML = argument;
			} else {
				insertRange.pasteHTML(argument);
			}
			insertRange.select();
		} else {
			if (dojo.isMoz && !argument.length) {
				this._sCall("remove");
			} else {
				rv = this.document.execCommand("inserthtml", false, argument);
			}
		}
		return rv;
	}});
}
if (!dojo._hasResource["dijit._KeyNavContainer"]) {
	dojo._hasResource["dijit._KeyNavContainer"] = true;
	dojo.provide("dijit._KeyNavContainer");
	dojo.declare("dijit._KeyNavContainer", dijit._Container, {tabIndex:"0", _keyNavCodes:{}, connectKeyNavHandlers:function (prevKeyCodes, nextKeyCodes) {
		var keyCodes = (this._keyNavCodes = {});
		var prev = dojo.hitch(this, this.focusPrev);
		var next = dojo.hitch(this, this.focusNext);
		dojo.forEach(prevKeyCodes, function (code) {
			keyCodes[code] = prev;
		});
		dojo.forEach(nextKeyCodes, function (code) {
			keyCodes[code] = next;
		});
		this.connect(this.domNode, "onkeypress", "_onContainerKeypress");
		this.connect(this.domNode, "onfocus", "_onContainerFocus");
	}, startupKeyNavChildren:function () {
		dojo.forEach(this.getChildren(), dojo.hitch(this, "_startupChild"));
	}, addChild:function (widget, insertIndex) {
		dijit._KeyNavContainer.superclass.addChild.apply(this, arguments);
		this._startupChild(widget);
	}, focus:function () {
		this.focusFirstChild();
	}, focusFirstChild:function () {
		var child = this._getFirstFocusableChild();
		if (child) {
			this.focusChild(child);
		}
	}, focusNext:function () {
		var child = this._getNextFocusableChild(this.focusedChild, 1);
		this.focusChild(child);
	}, focusPrev:function () {
		var child = this._getNextFocusableChild(this.focusedChild, -1);
		this.focusChild(child, true);
	}, focusChild:function (widget, last) {
		if (this.focusedChild && widget !== this.focusedChild) {
			this._onChildBlur(this.focusedChild);
		}
		widget.focus(last ? "end" : "start");
		this.focusedChild = widget;
	}, _startupChild:function (widget) {
		widget.attr("tabIndex", "-1");
		this.connect(widget, "_onFocus", function () {
			widget.attr("tabIndex", this.tabIndex);
		});
		this.connect(widget, "_onBlur", function () {
			widget.attr("tabIndex", "-1");
		});
	}, _onContainerFocus:function (evt) {
		if (evt.target !== this.domNode) {
			return;
		}
		this.focusFirstChild();
		dojo.attr(this.domNode, "tabIndex", "-1");
	}, _onBlur:function (evt) {
		if (this.tabIndex) {
			dojo.attr(this.domNode, "tabIndex", this.tabIndex);
		}
		this.inherited(arguments);
	}, _onContainerKeypress:function (evt) {
		if (evt.ctrlKey || evt.altKey) {
			return;
		}
		var func = this._keyNavCodes[evt.charOrCode];
		if (func) {
			func();
			dojo.stopEvent(evt);
		}
	}, _onChildBlur:function (widget) {
	}, _getFirstFocusableChild:function () {
		return this._getNextFocusableChild(null, 1);
	}, _getNextFocusableChild:function (child, dir) {
		if (child) {
			child = this._getSiblingOfChild(child, dir);
		}
		var children = this.getChildren();
		for (var i = 0; i < children.length; i++) {
			if (!child) {
				child = children[(dir > 0) ? 0 : (children.length - 1)];
			}
			if (child.isFocusable()) {
				return child;
			}
			child = this._getSiblingOfChild(child, dir);
		}
		return null;
	}});
}
if (!dojo._hasResource["dijit.ToolbarSeparator"]) {
	dojo._hasResource["dijit.ToolbarSeparator"] = true;
	dojo.provide("dijit.ToolbarSeparator");
	dojo.declare("dijit.ToolbarSeparator", [dijit._Widget, dijit._Templated], {templateString:"<div class=\"dijitToolbarSeparator dijitInline\"></div>", postCreate:function () {
		dojo.setSelectable(this.domNode, false);
	}, isFocusable:function () {
		return false;
	}});
}
if (!dojo._hasResource["dijit.Toolbar"]) {
	dojo._hasResource["dijit.Toolbar"] = true;
	dojo.provide("dijit.Toolbar");
	dojo.declare("dijit.Toolbar", [dijit._Widget, dijit._Templated, dijit._KeyNavContainer], {templateString:"<div class=\"dijit dijitToolbar\" waiRole=\"toolbar\" tabIndex=\"${tabIndex}\" dojoAttachPoint=\"containerNode\">" + "</div>", postCreate:function () {
		this.connectKeyNavHandlers(this.isLeftToRight() ? [dojo.keys.LEFT_ARROW] : [dojo.keys.RIGHT_ARROW], this.isLeftToRight() ? [dojo.keys.RIGHT_ARROW] : [dojo.keys.LEFT_ARROW]);
	}, startup:function () {
		if (this._started) {
			return;
		}
		this.startupKeyNavChildren();
		this.inherited(arguments);
	}});
}
if (!dojo._hasResource["dijit._editor._Plugin"]) {
	dojo._hasResource["dijit._editor._Plugin"] = true;
	dojo.provide("dijit._editor._Plugin");
	dojo.declare("dijit._editor._Plugin", null, {constructor:function (args, node) {
		this.params = args || {};
		dojo.mixin(this, this.params);
		this._connects = [];
	}, editor:null, iconClassPrefix:"dijitEditorIcon", button:null, command:"", useDefaultCommand:true, buttonClass:dijit.form.Button, getLabel:function (key) {
		return this.editor.commands[key];
	}, _initButton:function () {
		if (this.command.length) {
			var label = this.getLabel(this.command);
			var className = this.iconClassPrefix + " " + this.iconClassPrefix + this.command.charAt(0).toUpperCase() + this.command.substr(1);
			if (!this.button) {
				var props = dojo.mixin({label:label, showLabel:false, iconClass:className, dropDown:this.dropDown, tabIndex:"-1"}, this.params || {});
				this.button = new this.buttonClass(props);
			}
		}
	}, destroy:function () {
		dojo.forEach(this._connects, dojo.disconnect);
		if (this.dropDown) {
			this.dropDown.destroyRecursive();
		}
	}, connect:function (o, f, tf) {
		this._connects.push(dojo.connect(o, f, this, tf));
	}, updateState:function () {
		var e = this.editor, c = this.command, checked, enabled;
		if (!e || !e.isLoaded || !c.length) {
			return;
		}
		if (this.button) {
			try {
				enabled = e.queryCommandEnabled(c);
				if (this.enabled !== enabled) {
					this.enabled = enabled;
					this.button.attr("disabled", !enabled);
				}
				if (typeof this.button.checked == "boolean") {
					checked = e.queryCommandState(c);
					if (this.checked !== checked) {
						this.checked = checked;
						this.button.attr("checked", e.queryCommandState(c));
					}
				}
			}
			catch (e) {
				console.log(e);
			}
		}
	}, setEditor:function (editor) {
		this.editor = editor;
		this._initButton();
		if (this.command.length && !this.editor.queryCommandAvailable(this.command)) {
			if (this.button) {
				this.button.domNode.style.display = "none";
			}
		}
		if (this.button && this.useDefaultCommand) {
			this.connect(this.button, "onClick", dojo.hitch(this.editor, "execCommand", this.command, this.commandArg));
		}
		this.connect(this.editor, "onNormalizedDisplayChanged", "updateState");
	}, setToolbar:function (toolbar) {
		if (this.button) {
			toolbar.addChild(this.button);
		}
	}});
}
if (!dojo._hasResource["dijit._editor.plugins.EnterKeyHandling"]) {
	dojo._hasResource["dijit._editor.plugins.EnterKeyHandling"] = true;
	dojo.provide("dijit._editor.plugins.EnterKeyHandling");
	dojo.declare("dijit._editor.plugins.EnterKeyHandling", dijit._editor._Plugin, {blockNodeForEnter:"BR", constructor:function (args) {
		if (args) {
			dojo.mixin(this, args);
		}
	}, setEditor:function (editor) {
		this.editor = editor;
		if (this.blockNodeForEnter == "BR") {
			if (dojo.isIE) {
				editor.contentDomPreFilters.push(dojo.hitch(this, "regularPsToSingleLinePs"));
				editor.contentDomPostFilters.push(dojo.hitch(this, "singleLinePsToRegularPs"));
				editor.onLoadDeferred.addCallback(dojo.hitch(this, "_fixNewLineBehaviorForIE"));
			} else {
				editor.onLoadDeferred.addCallback(dojo.hitch(this, function (d) {
					try {
						this.editor.document.execCommand("insertBrOnReturn", false, true);
					}
					catch (e) {
					}
					return d;
				}));
			}
		} else {
			if (this.blockNodeForEnter) {
				dojo["require"]("dijit._editor.range");
				var h = dojo.hitch(this, this.handleEnterKey);
				editor.addKeyHandler(13, 0, 0, h);
				editor.addKeyHandler(13, 0, 1, h);
				this.connect(this.editor, "onKeyPressed", "onKeyPressed");
			}
		}
	}, onKeyPressed:function (e) {
		if (this._checkListLater) {
			if (dojo.withGlobal(this.editor.window, "isCollapsed", dijit)) {
				var liparent = dojo.withGlobal(this.editor.window, "getAncestorElement", dijit._editor.selection, ["LI"]);
				if (!liparent) {
					dijit._editor.RichText.prototype.execCommand.call(this.editor, "formatblock", this.blockNodeForEnter);
					var block = dojo.withGlobal(this.editor.window, "getAncestorElement", dijit._editor.selection, [this.blockNodeForEnter]);
					if (block) {
						block.innerHTML = this.bogusHtmlContent;
						if (dojo.isIE) {
							var r = this.editor.document.selection.createRange();
							r.move("character", -1);
							r.select();
						}
					} else {
						console.error("onKeyPressed: Cannot find the new block node");
					}
				} else {
					if (dojo.isMoz) {
						if (liparent.parentNode.parentNode.nodeName == "LI") {
							liparent = liparent.parentNode.parentNode;
						}
					}
					var fc = liparent.firstChild;
					if (fc && fc.nodeType == 1 && (fc.nodeName == "UL" || fc.nodeName == "OL")) {
						liparent.insertBefore(fc.ownerDocument.createTextNode("\xa0"), fc);
						var newrange = dijit.range.create(this.editor.window);
						newrange.setStart(liparent.firstChild, 0);
						var selection = dijit.range.getSelection(this.editor.window, true);
						selection.removeAllRanges();
						selection.addRange(newrange);
					}
				}
			}
			this._checkListLater = false;
		}
		if (this._pressedEnterInBlock) {
			if (this._pressedEnterInBlock.previousSibling) {
				this.removeTrailingBr(this._pressedEnterInBlock.previousSibling);
			}
			delete this._pressedEnterInBlock;
		}
	}, bogusHtmlContent:"&nbsp;", blockNodes:/^(?:P|H1|H2|H3|H4|H5|H6|LI)$/, handleEnterKey:function (e) {
		var selection, range, newrange, doc = this.editor.document, br;
		if (e.shiftKey) {
			var parent = dojo.withGlobal(this.editor.window, "getParentElement", dijit._editor.selection);
			var header = dijit.range.getAncestor(parent, this.blockNodes);
			if (header) {
				if (!e.shiftKey && header.tagName == "LI") {
					return true;
				}
				selection = dijit.range.getSelection(this.editor.window);
				range = selection.getRangeAt(0);
				if (!range.collapsed) {
					range.deleteContents();
					selection = dijit.range.getSelection(this.editor.window);
					range = selection.getRangeAt(0);
				}
				if (dijit.range.atBeginningOfContainer(header, range.startContainer, range.startOffset)) {
					if (e.shiftKey) {
						br = doc.createElement("br");
						newrange = dijit.range.create(this.editor.window);
						header.insertBefore(br, header.firstChild);
						newrange.setStartBefore(br.nextSibling);
						selection.removeAllRanges();
						selection.addRange(newrange);
					} else {
						dojo.place(br, header, "before");
					}
				} else {
					if (dijit.range.atEndOfContainer(header, range.startContainer, range.startOffset)) {
						newrange = dijit.range.create(this.editor.window);
						br = doc.createElement("br");
						if (e.shiftKey) {
							header.appendChild(br);
							header.appendChild(doc.createTextNode("\xa0"));
							newrange.setStart(header.lastChild, 0);
						} else {
							dojo.place(br, header, "after");
							newrange.setStartAfter(header);
						}
						selection.removeAllRanges();
						selection.addRange(newrange);
					} else {
						return true;
					}
				}
			} else {
				dijit._editor.RichText.prototype.execCommand.call(this.editor, "inserthtml", "<br>");
			}
			return false;
		}
		var _letBrowserHandle = true;
		selection = dijit.range.getSelection(this.editor.window);
		range = selection.getRangeAt(0);
		if (!range.collapsed) {
			range.deleteContents();
			selection = dijit.range.getSelection(this.editor.window);
			range = selection.getRangeAt(0);
		}
		var block = dijit.range.getBlockAncestor(range.endContainer, null, this.editor.editNode);
		var blockNode = block.blockNode;
		if ((this._checkListLater = (blockNode && (blockNode.nodeName == "LI" || blockNode.parentNode.nodeName == "LI")))) {
			if (dojo.isMoz) {
				this._pressedEnterInBlock = blockNode;
			}
			if (/^(\s|&nbsp;|\xA0|<span\b[^>]*\bclass=['"]Apple-style-span['"][^>]*>(\s|&nbsp;|\xA0)<\/span>)?(<br>)?$/.test(blockNode.innerHTML)) {
				blockNode.innerHTML = "";
				if (dojo.isWebKit) {
					newrange = dijit.range.create(this.editor.window);
					newrange.setStart(blockNode, 0);
					selection.removeAllRanges();
					selection.addRange(newrange);
				}
				this._checkListLater = false;
			}
			return true;
		}
		if (!block.blockNode || block.blockNode === this.editor.editNode) {
			try {
				dijit._editor.RichText.prototype.execCommand.call(this.editor, "formatblock", this.blockNodeForEnter);
			}
			catch (e2) {
			}
			block = {blockNode:dojo.withGlobal(this.editor.window, "getAncestorElement", dijit._editor.selection, [this.blockNodeForEnter]), blockContainer:this.editor.editNode};
			if (block.blockNode) {
				if (block.blockNode != this.editor.editNode && (!(block.blockNode.textContent || block.blockNode.innerHTML).replace(/^\s+|\s+$/g, "").length)) {
					this.removeTrailingBr(block.blockNode);
					return false;
				}
			} else {
				block.blockNode = this.editor.editNode;
			}
			selection = dijit.range.getSelection(this.editor.window);
			range = selection.getRangeAt(0);
		}
		var newblock = doc.createElement(this.blockNodeForEnter);
		newblock.innerHTML = this.bogusHtmlContent;
		this.removeTrailingBr(block.blockNode);
		if (dijit.range.atEndOfContainer(block.blockNode, range.endContainer, range.endOffset)) {
			if (block.blockNode === block.blockContainer) {
				block.blockNode.appendChild(newblock);
			} else {
				dojo.place(newblock, block.blockNode, "after");
			}
			_letBrowserHandle = false;
			newrange = dijit.range.create(this.editor.window);
			newrange.setStart(newblock, 0);
			selection.removeAllRanges();
			selection.addRange(newrange);
			if (this.editor.height) {
				dijit.scrollIntoView(newblock);
			}
		} else {
			if (dijit.range.atBeginningOfContainer(block.blockNode, range.startContainer, range.startOffset)) {
				dojo.place(newblock, block.blockNode, block.blockNode === block.blockContainer ? "first" : "before");
				if (newblock.nextSibling && this.editor.height) {
					newrange = dijit.range.create(this.editor.window);
					newrange.setStart(newblock.nextSibling, 0);
					selection.removeAllRanges();
					selection.addRange(newrange);
					dijit.scrollIntoView(newblock.nextSibling);
				}
				_letBrowserHandle = false;
			} else {
				if (dojo.isMoz) {
					this._pressedEnterInBlock = block.blockNode;
				}
			}
		}
		return _letBrowserHandle;
	}, removeTrailingBr:function (container) {
		var para = /P|DIV|LI/i.test(container.tagName) ? container : dijit._editor.selection.getParentOfType(container, ["P", "DIV", "LI"]);
		if (!para) {
			return;
		}
		if (para.lastChild) {
			if ((para.childNodes.length > 1 && para.lastChild.nodeType == 3 && /^[\s\xAD]*$/.test(para.lastChild.nodeValue)) || para.lastChild.tagName == "BR") {
				dojo.destroy(para.lastChild);
			}
		}
		if (!para.childNodes.length) {
			para.innerHTML = this.bogusHtmlContent;
		}
	}, _fixNewLineBehaviorForIE:function (d) {
		var doc = this.editor.document;
		if (doc.__INSERTED_EDITIOR_NEWLINE_CSS === undefined) {
			var style = dojo.create("style", {type:"text/css"}, doc.getElementsByTagName("head")[0]);
			style.styleSheet.cssText = "p{margin:0;}";
			this.editor.document.__INSERTED_EDITIOR_NEWLINE_CSS = true;
		}
		return d;
	}, regularPsToSingleLinePs:function (element, noWhiteSpaceInEmptyP) {
		function wrapLinesInPs(el) {
			function wrapNodes(nodes) {
				var newP = nodes[0].ownerDocument.createElement("p");
				nodes[0].parentNode.insertBefore(newP, nodes[0]);
				dojo.forEach(nodes, function (node) {
					newP.appendChild(node);
				});
			}
			var currentNodeIndex = 0;
			var nodesInLine = [];
			var currentNode;
			while (currentNodeIndex < el.childNodes.length) {
				currentNode = el.childNodes[currentNodeIndex];
				if (currentNode.nodeType == 3 || (currentNode.nodeType == 1 && currentNode.nodeName != "BR" && dojo.style(currentNode, "display") != "block")) {
					nodesInLine.push(currentNode);
				} else {
					var nextCurrentNode = currentNode.nextSibling;
					if (nodesInLine.length) {
						wrapNodes(nodesInLine);
						currentNodeIndex = (currentNodeIndex + 1) - nodesInLine.length;
						if (currentNode.nodeName == "BR") {
							dojo.destroy(currentNode);
						}
					}
					nodesInLine = [];
				}
				currentNodeIndex++;
			}
			if (nodesInLine.length) {
				wrapNodes(nodesInLine);
			}
		}
		function splitP(el) {
			var currentNode = null;
			var trailingNodes = [];
			var lastNodeIndex = el.childNodes.length - 1;
			for (var i = lastNodeIndex; i >= 0; i--) {
				currentNode = el.childNodes[i];
				if (currentNode.nodeName == "BR") {
					var newP = currentNode.ownerDocument.createElement("p");
					dojo.place(newP, el, "after");
					if (trailingNodes.length == 0 && i != lastNodeIndex) {
						newP.innerHTML = "&nbsp;";
					}
					dojo.forEach(trailingNodes, function (node) {
						newP.appendChild(node);
					});
					dojo.destroy(currentNode);
					trailingNodes = [];
				} else {
					trailingNodes.unshift(currentNode);
				}
			}
		}
		var pList = [];
		var ps = element.getElementsByTagName("p");
		dojo.forEach(ps, function (p) {
			pList.push(p);
		});
		dojo.forEach(pList, function (p) {
			var prevSib = p.previousSibling;
			if ((prevSib) && (prevSib.nodeType == 1) && (prevSib.nodeName == "P" || dojo.style(prevSib, "display") != "block")) {
				var newP = p.parentNode.insertBefore(this.document.createElement("p"), p);
				newP.innerHTML = noWhiteSpaceInEmptyP ? "" : "&nbsp;";
			}
			splitP(p);
		}, this.editor);
		wrapLinesInPs(element);
		return element;
	}, singleLinePsToRegularPs:function (element) {
		function getParagraphParents(node) {
			var ps = node.getElementsByTagName("p");
			var parents = [];
			for (var i = 0; i < ps.length; i++) {
				var p = ps[i];
				var knownParent = false;
				for (var k = 0; k < parents.length; k++) {
					if (parents[k] === p.parentNode) {
						knownParent = true;
						break;
					}
				}
				if (!knownParent) {
					parents.push(p.parentNode);
				}
			}
			return parents;
		}
		function isParagraphDelimiter(node) {
			return (!node.childNodes.length || node.innerHTML == "&nbsp;");
		}
		var paragraphContainers = getParagraphParents(element);
		for (var i = 0; i < paragraphContainers.length; i++) {
			var container = paragraphContainers[i];
			var firstPInBlock = null;
			var node = container.firstChild;
			var deleteNode = null;
			while (node) {
				if (node.nodeType != 1 || node.tagName != "P" || (node.getAttributeNode("style") || {}).specified) {
					firstPInBlock = null;
				} else {
					if (isParagraphDelimiter(node)) {
						deleteNode = node;
						firstPInBlock = null;
					} else {
						if (firstPInBlock == null) {
							firstPInBlock = node;
						} else {
							if ((!firstPInBlock.lastChild || firstPInBlock.lastChild.nodeName != "BR") && (node.firstChild) && (node.firstChild.nodeName != "BR")) {
								firstPInBlock.appendChild(this.editor.document.createElement("br"));
							}
							while (node.firstChild) {
								firstPInBlock.appendChild(node.firstChild);
							}
							deleteNode = node;
						}
					}
				}
				node = node.nextSibling;
				if (deleteNode) {
					dojo.destroy(deleteNode);
					deleteNode = null;
				}
			}
		}
		return element;
	}});
}
if (!dojo._hasResource["dijit.Editor"]) {
	dojo._hasResource["dijit.Editor"] = true;
	dojo.provide("dijit.Editor");
	dojo.declare("dijit.Editor", dijit._editor.RichText, {plugins:null, extraPlugins:null, constructor:function () {
		if (!dojo.isArray(this.plugins)) {
			this.plugins = ["undo", "redo", "|", "cut", "copy", "paste", "|", "bold", "italic", "underline", "strikethrough", "|", "insertOrderedList", "insertUnorderedList", "indent", "outdent", "|", "justifyLeft", "justifyRight", "justifyCenter", "justifyFull", "dijit._editor.plugins.EnterKeyHandling"];
		}
		this._plugins = [];
		this._editInterval = this.editActionInterval * 1000;
		if (dojo.isIE) {
			this.events.push("onBeforeDeactivate");
			this.events.push("onBeforeActivate");
		}
	}, postCreate:function () {
		if (this.customUndo) {
			dojo["require"]("dijit._editor.range");
			this._steps = this._steps.slice(0);
			this._undoedSteps = this._undoedSteps.slice(0);
		}
		if (dojo.isArray(this.extraPlugins)) {
			this.plugins = this.plugins.concat(this.extraPlugins);
		}
		this.inherited(arguments);
		this.commands = dojo.i18n.getLocalization("dijit._editor", "commands", this.lang);
		if (!this.toolbar) {
			this.toolbar = new dijit.Toolbar({});
			dojo.place(this.toolbar.domNode, this.editingArea, "before");
		}
		dojo.forEach(this.plugins, this.addPlugin, this);
		this.onNormalizedDisplayChanged();
		this.toolbar.startup();
	}, destroy:function () {
		dojo.forEach(this._plugins, function (p) {
			if (p && p.destroy) {
				p.destroy();
			}
		});
		this._plugins = [];
		this.toolbar.destroyRecursive();
		delete this.toolbar;
		this.inherited(arguments);
	}, addPlugin:function (plugin, index) {
		var args = dojo.isString(plugin) ? {name:plugin} : plugin;
		if (!args.setEditor) {
			var o = {"args":args, "plugin":null, "editor":this};
			dojo.publish(dijit._scopeName + ".Editor.getPlugin", [o]);
			if (!o.plugin) {
				var pc = dojo.getObject(args.name);
				if (pc) {
					o.plugin = new pc(args);
				}
			}
			if (!o.plugin) {
				console.warn("Cannot find plugin", plugin);
				return;
			}
			plugin = o.plugin;
		}
		if (arguments.length > 1) {
			this._plugins[index] = plugin;
		} else {
			this._plugins.push(plugin);
		}
		plugin.setEditor(this);
		if (dojo.isFunction(plugin.setToolbar)) {
			plugin.setToolbar(this.toolbar);
		}
	}, startup:function () {
	}, resize:function (size) {
		if (size) {
			dijit.layout._LayoutWidget.prototype.resize.apply(this, arguments);
		}
	}, layout:function () {
		this.editingArea.style.height = (this._contentBox.h - dojo.marginBox(this.toolbar.domNode).h) + "px";
		if (this.iframe) {
			this.iframe.style.height = "100%";
		}
		this._layoutMode = true;
	}, _onIEMouseDown:function (e) {
		var outsideClientArea = this.document.body.componentFromPoint(e.x, e.y);
		if (!outsideClientArea) {
			delete this._savedSelection;
			if (e.target.tagName == "BODY") {
				setTimeout(dojo.hitch(this, "placeCursorAtEnd"), 0);
			}
			this.inherited(arguments);
		}
	}, onBeforeActivate:function (e) {
		this._restoreSelection();
	}, onBeforeDeactivate:function (e) {
		if (this.customUndo) {
			this.endEditing(true);
		}
		if (e.target.tagName != "BODY") {
			this._saveSelection();
		}
	}, customUndo:dojo.isIE, editActionInterval:3, beginEditing:function (cmd) {
		if (!this._inEditing) {
			this._inEditing = true;
			this._beginEditing(cmd);
		}
		if (this.editActionInterval > 0) {
			if (this._editTimer) {
				clearTimeout(this._editTimer);
			}
			this._editTimer = setTimeout(dojo.hitch(this, this.endEditing), this._editInterval);
		}
	}, _steps:[], _undoedSteps:[], execCommand:function (cmd) {
		if (this.customUndo && (cmd == "undo" || cmd == "redo")) {
			return this[cmd]();
		} else {
			if (this.customUndo) {
				this.endEditing();
				this._beginEditing();
			}
			var r;
			try {
				r = this.inherited("execCommand", arguments);
				if (dojo.isWebKit && cmd == "paste" && !r) {
					throw {code:1011};
				}
			}
			catch (e) {
				if (e.code == 1011 && /copy|cut|paste/.test(cmd)) {
					var sub = dojo.string.substitute, accel = {cut:"X", copy:"C", paste:"V"};
					alert(sub(this.commands.systemShortcut, [this.commands[cmd], sub(this.commands[dojo.isMac ? "appleKey" : "ctrlKey"], [accel[cmd]])]));
				}
				r = false;
			}
			if (this.customUndo) {
				this._endEditing();
			}
			return r;
		}
	}, queryCommandEnabled:function (cmd) {
		if (this.customUndo && (cmd == "undo" || cmd == "redo")) {
			return cmd == "undo" ? (this._steps.length > 1) : (this._undoedSteps.length > 0);
		} else {
			return this.inherited("queryCommandEnabled", arguments);
		}
	}, _moveToBookmark:function (b) {
		var bookmark = b.mark;
		var mark = b.mark;
		var col = b.isCollapsed;
		if (dojo.isIE) {
			if (dojo.isArray(mark)) {
				bookmark = [];
				dojo.forEach(mark, function (n) {
					bookmark.push(dijit.range.getNode(n, this.editNode));
				}, this);
			}
		} else {
			var r = dijit.range.create(this.window);
			r.setStart(dijit.range.getNode(b.startContainer, this.editNode), b.startOffset);
			r.setEnd(dijit.range.getNode(b.endContainer, this.editNode), b.endOffset);
			bookmark = r;
		}
		dojo.withGlobal(this.window, "moveToBookmark", dijit, [{mark:bookmark, isCollapsed:col}]);
	}, _changeToStep:function (from, to) {
		this.setValue(to.text);
		var b = to.bookmark;
		if (!b) {
			return;
		}
		this._moveToBookmark(b);
	}, undo:function () {
		this.endEditing(true);
		var s = this._steps.pop();
		if (this._steps.length > 0) {
			this.focus();
			this._changeToStep(s, this._steps[this._steps.length - 1]);
			this._undoedSteps.push(s);
			this.onDisplayChanged();
			return true;
		}
		return false;
	}, redo:function () {
		this.endEditing(true);
		var s = this._undoedSteps.pop();
		if (s && this._steps.length > 0) {
			this.focus();
			this._changeToStep(this._steps[this._steps.length - 1], s);
			this._steps.push(s);
			this.onDisplayChanged();
			return true;
		}
		return false;
	}, endEditing:function (ignore_caret) {
		if (this._editTimer) {
			clearTimeout(this._editTimer);
		}
		if (this._inEditing) {
			this._endEditing(ignore_caret);
			this._inEditing = false;
		}
	}, _getBookmark:function () {
		var b = dojo.withGlobal(this.window, dijit.getBookmark);
		var tmp = [];
		if (b.mark) {
			var mark = b.mark;
			if (dojo.isIE) {
				if (dojo.isArray(mark)) {
					dojo.forEach(mark, function (n) {
						tmp.push(dijit.range.getIndex(n, this.editNode).o);
					}, this);
					b.mark = tmp;
				}
			} else {
				tmp = dijit.range.getIndex(mark.startContainer, this.editNode).o;
				b.mark = {startContainer:tmp, startOffset:mark.startOffset, endContainer:mark.endContainer === mark.startContainer ? tmp : dijit.range.getIndex(mark.endContainer, this.editNode).o, endOffset:mark.endOffset};
			}
		}
		return b;
	}, _beginEditing:function (cmd) {
		if (this._steps.length === 0) {
			this._steps.push({"text":this.savedContent, "bookmark":this._getBookmark()});
		}
	}, _endEditing:function (ignore_caret) {
		var v = this.getValue(true);
		this._undoedSteps = [];
		this._steps.push({text:v, bookmark:this._getBookmark()});
	}, onKeyDown:function (e) {
		if (!dojo.isIE && !this.iframe && e.keyCode == dojo.keys.TAB && !this.tabIndent) {
			this._saveSelection();
		}
		if (!this.customUndo) {
			this.inherited(arguments);
			return;
		}
		var k = e.keyCode, ks = dojo.keys;
		if (e.ctrlKey && !e.altKey) {
			if (k == 90 || k == 122) {
				dojo.stopEvent(e);
				this.undo();
				return;
			} else {
				if (k == 89 || k == 121) {
					dojo.stopEvent(e);
					this.redo();
					return;
				}
			}
		}
		this.inherited(arguments);
		switch (k) {
		  case ks.ENTER:
		  case ks.BACKSPACE:
		  case ks.DELETE:
			this.beginEditing();
			break;
		  case 88:
		  case 86:
			if (e.ctrlKey && !e.altKey && !e.metaKey) {
				this.endEditing();
				if (e.keyCode == 88) {
					this.beginEditing("cut");
					setTimeout(dojo.hitch(this, this.endEditing), 1);
				} else {
					this.beginEditing("paste");
					setTimeout(dojo.hitch(this, this.endEditing), 1);
				}
				break;
			}
		  default:
			if (!e.ctrlKey && !e.altKey && !e.metaKey && (e.keyCode < dojo.keys.F1 || e.keyCode > dojo.keys.F15)) {
				this.beginEditing();
				break;
			}
		  case ks.ALT:
			this.endEditing();
			break;
		  case ks.UP_ARROW:
		  case ks.DOWN_ARROW:
		  case ks.LEFT_ARROW:
		  case ks.RIGHT_ARROW:
		  case ks.HOME:
		  case ks.END:
		  case ks.PAGE_UP:
		  case ks.PAGE_DOWN:
			this.endEditing(true);
			break;
		  case ks.CTRL:
		  case ks.SHIFT:
		  case ks.TAB:
			break;
		}
	}, _onBlur:function () {
		this.inherited("_onBlur", arguments);
		this.endEditing(true);
	}, _saveSelection:function () {
		this._savedSelection = this._getBookmark();
	}, _restoreSelection:function () {
		if (this._savedSelection) {
			if (dojo.withGlobal(this.window, "isCollapsed", dijit)) {
				this._moveToBookmark(this._savedSelection);
			}
			delete this._savedSelection;
		}
	}, onClick:function () {
		this.endEditing(true);
		this.inherited(arguments);
	}});
	dojo.subscribe(dijit._scopeName + ".Editor.getPlugin", null, function (o) {
		if (o.plugin) {
			return;
		}
		var args = o.args, p;
		var _p = dijit._editor._Plugin;
		var name = args.name;
		switch (name) {
		  case "undo":
		  case "redo":
		  case "cut":
		  case "copy":
		  case "paste":
		  case "insertOrderedList":
		  case "insertUnorderedList":
		  case "indent":
		  case "outdent":
		  case "justifyCenter":
		  case "justifyFull":
		  case "justifyLeft":
		  case "justifyRight":
		  case "delete":
		  case "selectAll":
		  case "removeFormat":
		  case "unlink":
		  case "insertHorizontalRule":
			p = new _p({command:name});
			break;
		  case "bold":
		  case "italic":
		  case "underline":
		  case "strikethrough":
		  case "subscript":
		  case "superscript":
			p = new _p({buttonClass:dijit.form.ToggleButton, command:name});
			break;
		  case "|":
			p = new _p({button:new dijit.ToolbarSeparator()});
		}
		o.plugin = p;
	});
}
if (!dojo._hasResource["dojox.grid.compat._data.dijitEditors"]) {
	dojo._hasResource["dojox.grid.compat._data.dijitEditors"] = true;
	dojo.provide("dojox.grid.compat._data.dijitEditors");
	dojo.declare("dojox.grid.editors.Dijit", dojox.grid.editors.base, {editorClass:"dijit.form.TextBox", constructor:function (inCell) {
		this.editor = null;
		this.editorClass = dojo.getObject(this.cell.editorClass || this.editorClass);
	}, format:function (inDatum, inRowIndex) {
		this.needFormatNode(inDatum, inRowIndex);
		return "<div></div>";
	}, getValue:function (inRowIndex) {
		return this.editor.getValue();
	}, setValue:function (inRowIndex, inValue) {
		if (this.editor && this.editor.setValue) {
			if (this.editor.onLoadDeferred) {
				var self = this;
				this.editor.onLoadDeferred.addCallback(function () {
					self.editor.setValue(inValue == null ? "" : inValue);
				});
			} else {
				this.editor.setValue(inValue);
			}
		} else {
			this.inherited(arguments);
		}
	}, getEditorProps:function (inDatum) {
		return dojo.mixin({}, this.cell.editorProps || {}, {constraints:dojo.mixin({}, this.cell.constraint) || {}, value:inDatum});
	}, createEditor:function (inNode, inDatum, inRowIndex) {
		return new this.editorClass(this.getEditorProps(inDatum), inNode);
	}, attachEditor:function (inNode, inDatum, inRowIndex) {
		inNode.appendChild(this.editor.domNode);
		this.setValue(inRowIndex, inDatum);
	}, formatNode:function (inNode, inDatum, inRowIndex) {
		if (!this.editorClass) {
			return inDatum;
		}
		if (!this.editor) {
			this.editor = this.createEditor.apply(this, arguments);
		} else {
			this.attachEditor.apply(this, arguments);
		}
		this.sizeEditor.apply(this, arguments);
		this.cell.grid.rowHeightChanged(inRowIndex);
		this.focus();
	}, sizeEditor:function (inNode, inDatum, inRowIndex) {
		var p = this.cell.getNode(inRowIndex), box = dojo.contentBox(p);
		dojo.marginBox(this.editor.domNode, {w:box.w});
	}, focus:function (inRowIndex, inNode) {
		if (this.editor) {
			setTimeout(dojo.hitch(this.editor, function () {
				dojox.grid.fire(this, "focus");
			}), 0);
		}
	}, _finish:function (inRowIndex) {
		this.inherited(arguments);
		dojox.grid.removeNode(this.editor.domNode);
	}});
	dojo.declare("dojox.grid.editors.ComboBox", dojox.grid.editors.Dijit, {editorClass:"dijit.form.ComboBox", getEditorProps:function (inDatum) {
		var items = [];
		dojo.forEach(this.cell.options, function (o) {
			items.push({name:o, value:o});
		});
		var store = new dojo.data.ItemFileReadStore({data:{identifier:"name", items:items}});
		return dojo.mixin({}, this.cell.editorProps || {}, {value:inDatum, store:store});
	}, getValue:function () {
		var e = this.editor;
		e.setDisplayedValue(e.getDisplayedValue());
		return e.getValue();
	}});
	dojo.declare("dojox.grid.editors.DateTextBox", dojox.grid.editors.Dijit, {editorClass:"dijit.form.DateTextBox", setValue:function (inRowIndex, inValue) {
		if (this.editor) {
			this.editor.setValue(new Date(inValue));
		} else {
			this.inherited(arguments);
		}
	}, getEditorProps:function (inDatum) {
		return dojo.mixin(this.inherited(arguments), {value:new Date(inDatum)});
	}});
	dojo.declare("dojox.grid.editors.CheckBox", dojox.grid.editors.Dijit, {editorClass:"dijit.form.CheckBox", getValue:function () {
		return this.editor.checked;
	}, setValue:function (inRowIndex, inValue) {
		if (this.editor && this.editor.setAttribute) {
			this.editor.setAttribute("checked", inValue);
		} else {
			this.inherited(arguments);
		}
	}, sizeEditor:function (inNode, inDatum, inRowIndex) {
		return;
	}});
	dojo.declare("dojox.grid.editors.Editor", dojox.grid.editors.Dijit, {editorClass:"dijit.Editor", getEditorProps:function (inDatum) {
		return dojo.mixin({}, this.cell.editorProps || {}, {height:this.cell.editorHeight || "100px"});
	}, createEditor:function (inNode, inDatum, inRowIndex) {
		var editor = new this.editorClass(this.getEditorProps(inDatum), inNode);
		dojo.connect(editor, "onLoad", dojo.hitch(this, "populateEditor"));
		return editor;
	}, formatNode:function (inNode, inDatum, inRowIndex) {
		this.content = inDatum;
		this.inherited(arguments);
		if (dojo.isMoz) {
			var e = this.editor;
			e.open();
			if (this.cell.editorToolbar) {
				dojo.place(e.toolbar.domNode, e.editingArea, "before");
			}
		}
	}, populateEditor:function () {
		this.editor.setValue(this.content);
		this.editor.placeCursorAtEnd();
	}});
}
if (!dojo._hasResource["dojox.grid.compat.Grid"]) {
	dojo._hasResource["dojox.grid.compat.Grid"] = true;
	dojo.provide("dojox.grid.compat.Grid");
	dojo.declare("dojox.Grid", dojox.VirtualGrid, {model:"dojox.grid.data.Table", postCreate:function () {
		if (this.model) {
			var m = this.model;
			if (dojo.isString(m)) {
				m = dojo.getObject(m);
			}
			this.model = (dojo.isFunction(m)) ? new m() : m;
			this._setModel(this.model);
		}
		this.inherited(arguments);
	}, destroy:function () {
		this.setModel(null);
		this.inherited(arguments);
	}, _structureChanged:function () {
		this.indexCellFields();
		this.inherited(arguments);
	}, _setModel:function (inModel) {
		this.model = inModel;
		if (this.model) {
			this.model.observer(this);
			this.model.measure();
			this.indexCellFields();
		}
	}, setModel:function (inModel) {
		if (this.model) {
			this.model.notObserver(this);
		}
		this._setModel(inModel);
	}, get:function (inRowIndex) {
		return this.grid.model.getDatum(inRowIndex, this.fieldIndex);
	}, modelAllChange:function () {
		this.rowCount = (this.model ? this.model.getRowCount() : 0);
		this.updateRowCount(this.rowCount);
	}, modelBeginUpdate:function () {
		this.beginUpdate();
	}, modelEndUpdate:function () {
		this.endUpdate();
	}, modelRowChange:function (inData, inRowIndex) {
		this.updateRow(inRowIndex);
	}, modelDatumChange:function (inDatum, inRowIndex, inFieldIndex) {
		this.updateRow(inRowIndex);
	}, modelFieldsChange:function () {
		this.indexCellFields();
		this.render();
	}, modelInsertion:function (inRowIndex) {
		this.updateRowCount(this.model.getRowCount());
	}, modelRemoval:function (inKeys) {
		this.updateRowCount(this.model.getRowCount());
	}, getCellName:function (inCell) {
		var v = this.model.fields.values, i = inCell.fieldIndex;
		return i >= 0 && i < v.length && v[i].name || this.inherited(arguments);
	}, indexCellFields:function () {
		var cells = this.layout.cells;
		for (var i = 0, c; cells && (c = cells[i]); i++) {
			if (dojo.isString(c.field)) {
				c.fieldIndex = this.model.fields.indexOf(c.field);
			}
		}
	}, refresh:function () {
		this.edit.cancel();
		this.model.measure();
	}, canSort:function (inSortInfo) {
		var f = this.getSortField(inSortInfo);
		return f && this.model.canSort(f);
	}, getSortField:function (inSortInfo) {
		var c = this.getCell(this.getSortIndex(inSortInfo));
		return (c.fieldIndex + 1) * (this.sortInfo > 0 ? 1 : -1);
	}, sort:function () {
		this.edit.apply();
		this.model.sort(this.getSortField());
	}, addRow:function (inRowData, inIndex) {
		this.edit.apply();
		var i = inIndex || -1;
		if (i < 0) {
			i = this.selection.getFirstSelected() || 0;
		}
		if (i < 0) {
			i = 0;
		}
		this.model.insert(inRowData, i);
		this.model.beginModifyRow(i);
		for (var j = 0, c; ((c = this.getCell(j)) && !c.editor); j++) {
		}
		if (c && c.editor) {
			this.edit.setEditCell(c, i);
			this.focus.setFocusCell(c, i);
		} else {
			this.focus.setFocusCell(this.getCell(0), i);
		}
	}, removeSelectedRows:function () {
		this.edit.apply();
		var s = this.selection.getSelected();
		if (s.length) {
			this.model.remove(s);
			this.selection.clear();
		}
	}, canEdit:function (inCell, inRowIndex) {
		return (this.model.canModify ? this.model.canModify(inRowIndex) : true);
	}, doStartEdit:function (inCell, inRowIndex) {
		this.model.beginModifyRow(inRowIndex);
		this.onStartEdit(inCell, inRowIndex);
	}, doApplyCellEdit:function (inValue, inRowIndex, inFieldIndex) {
		this.model.setDatum(inValue, inRowIndex, inFieldIndex);
		this.onApplyCellEdit(inValue, inRowIndex, inFieldIndex);
	}, doCancelEdit:function (inRowIndex) {
		this.model.cancelModifyRow(inRowIndex);
		this.onCancelEdit.apply(this, arguments);
	}, doApplyEdit:function (inRowIndex) {
		this.model.endModifyRow(inRowIndex);
		this.onApplyEdit(inRowIndex);
	}, styleRowState:function (inRow) {
		if (this.model.getState) {
			var states = this.model.getState(inRow.index), c = "";
			for (var i = 0, ss = ["inflight", "error", "inserting"], s; s = ss[i]; i++) {
				if (states[s]) {
					c = " dojoxGrid-row-" + s;
					break;
				}
			}
			inRow.customClasses += c;
		}
	}, onStyleRow:function (inRow) {
		this.styleRowState(inRow);
		this.inherited(arguments);
	}});
	dojox.Grid.markupFactory = function (props, node, ctor) {
		var d = dojo;
		var widthFromAttr = function (n) {
			var w = d.attr(n, "width") || "auto";
			if ((w != "auto") && (w.substr(-2) != "em")) {
				w = parseInt(w) + "px";
			}
			return w;
		};
		if (!props.model && d.hasAttr(node, "store")) {
			var mNode = node.cloneNode(false);
			d.attr(mNode, {"jsId":null, "dojoType":d.attr(node, "dataModelClass") || "dojox.grid.data.DojoData"});
			props.model = d.parser.instantiate([mNode])[0];
		}
		if (!props.structure && node.nodeName.toLowerCase() == "table") {
			props.structure = d.query("> colgroup", node).map(function (cg) {
				var sv = d.attr(cg, "span");
				var v = {noscroll:(d.attr(cg, "noscroll") == "true") ? true : false, __span:(!!sv ? parseInt(sv) : 1), cells:[]};
				if (d.hasAttr(cg, "width")) {
					v.width = widthFromAttr(cg);
				}
				return v;
			});
			if (!props.structure.length) {
				props.structure.push({__span:Infinity, cells:[]});
			}
			d.query("thead > tr", node).forEach(function (tr, tr_idx) {
				var cellCount = 0;
				var viewIdx = 0;
				var lastViewIdx;
				var cView = null;
				d.query("> th", tr).map(function (th) {
					if (!cView) {
						lastViewIdx = 0;
						cView = props.structure[0];
					} else {
						if (cellCount >= (lastViewIdx + cView.__span)) {
							viewIdx++;
							lastViewIdx += cView.__span;
							var lastView = cView;
							cView = props.structure[viewIdx];
						}
					}
					var cell = {name:d.trim(d.attr(th, "name") || th.innerHTML), field:d.trim(d.attr(th, "field") || ""), colSpan:parseInt(d.attr(th, "colspan") || 1)};
					cellCount += cell.colSpan;
					cell.field = cell.field || cell.name;
					cell.width = widthFromAttr(th);
					if (!cView.cells[tr_idx]) {
						cView.cells[tr_idx] = [];
					}
					cView.cells[tr_idx].push(cell);
				});
			});
		}
		return new dojox.Grid(props, node);
	};
	dojox.grid.Grid = dojox.Grid;
}
if (!dojo._hasResource["dojo.rpc.RpcService"]) {
	dojo._hasResource["dojo.rpc.RpcService"] = true;
	dojo.provide("dojo.rpc.RpcService");
	dojo.declare("dojo.rpc.RpcService", null, {constructor:function (args) {
		if (args) {
			if ((dojo.isString(args)) || (args instanceof dojo._Url)) {
				if (args instanceof dojo._Url) {
					var url = args + "";
				} else {
					url = args;
				}
				var def = dojo.xhrGet({url:url, handleAs:"json-comment-optional", sync:true});
				def.addCallback(this, "processSmd");
				def.addErrback(function () {
					throw new Error("Unable to load SMD from " + args);
				});
			} else {
				if (args.smdStr) {
					this.processSmd(dojo.eval("(" + args.smdStr + ")"));
				} else {
					if (args.serviceUrl) {
						this.serviceUrl = args.serviceUrl;
					}
					this.timeout = args.timeout || 3000;
					if ("strictArgChecks" in args) {
						this.strictArgChecks = args.strictArgChecks;
					}
					this.processSmd(args);
				}
			}
		}
	}, strictArgChecks:true, serviceUrl:"", parseResults:function (obj) {
		return obj;
	}, errorCallback:function (deferredRequestHandler) {
		return function (data) {
			deferredRequestHandler.errback(data.message);
		};
	}, resultCallback:function (deferredRequestHandler) {
		var tf = dojo.hitch(this, function (obj) {
			if (obj.error != null) {
				var err;
				if (typeof obj.error == "object") {
					err = new Error(obj.error.message);
					err.code = obj.error.code;
					err.error = obj.error.error;
				} else {
					err = new Error(obj.error);
				}
				err.id = obj.id;
				err.errorObject = obj;
				deferredRequestHandler.errback(err);
			} else {
				deferredRequestHandler.callback(this.parseResults(obj));
			}
		});
		return tf;
	}, generateMethod:function (method, parameters, url) {
		return dojo.hitch(this, function () {
			var deferredRequestHandler = new dojo.Deferred();
			if ((this.strictArgChecks) && (parameters != null) && (arguments.length != parameters.length)) {
				throw new Error("Invalid number of parameters for remote method.");
			} else {
				this.bind(method, dojo._toArray(arguments), deferredRequestHandler, url);
			}
			return deferredRequestHandler;
		});
	}, processSmd:function (object) {
		if (object.methods) {
			dojo.forEach(object.methods, function (m) {
				if (m && m.name) {
					this[m.name] = this.generateMethod(m.name, m.parameters, m.url || m.serviceUrl || m.serviceURL);
					if (!dojo.isFunction(this[m.name])) {
						throw new Error("RpcService: Failed to create" + m.name + "()");
					}
				}
			}, this);
		}
		this.serviceUrl = object.serviceUrl || object.serviceURL;
		this.required = object.required;
		this.smd = object;
	}});
}
if (!dojo._hasResource["dojo.rpc.JsonService"]) {
	dojo._hasResource["dojo.rpc.JsonService"] = true;
	dojo.provide("dojo.rpc.JsonService");
	dojo.declare("dojo.rpc.JsonService", dojo.rpc.RpcService, {bustCache:false, contentType:"application/json-rpc", lastSubmissionId:0, callRemote:function (method, params) {
		var deferred = new dojo.Deferred();
		this.bind(method, params, deferred);
		return deferred;
	}, bind:function (method, parameters, deferredRequestHandler, url) {
		var def = dojo.rawXhrPost({url:url || this.serviceUrl, postData:this.createRequest(method, parameters), contentType:this.contentType, timeout:this.timeout, handleAs:"json-comment-optional"});
		def.addCallbacks(this.resultCallback(deferredRequestHandler), this.errorCallback(deferredRequestHandler));
	}, createRequest:function (method, params) {
		var req = {"params":params, "method":method, "id":++this.lastSubmissionId};
		var data = dojo.toJson(req);
		return data;
	}, parseResults:function (obj) {
		if (dojo.isObject(obj)) {
			if ("result" in obj) {
				return obj.result;
			}
			if ("Result" in obj) {
				return obj.Result;
			}
			if ("ResultSet" in obj) {
				return obj.ResultSet;
			}
		}
		return obj;
	}});
}
if (!dojo._hasResource["dojo.cookie"]) {
	dojo._hasResource["dojo.cookie"] = true;
	dojo.provide("dojo.cookie");
	dojo.cookie = function (name, value, props) {
		var c = document.cookie;
		if (arguments.length == 1) {
			var matches = c.match(new RegExp("(?:^|; )" + dojo.regexp.escapeString(name) + "=([^;]*)"));
			return matches ? decodeURIComponent(matches[1]) : undefined;
		} else {
			props = props || {};
			var exp = props.expires;
			if (typeof exp == "number") {
				var d = new Date();
				d.setTime(d.getTime() + exp * 24 * 60 * 60 * 1000);
				exp = props.expires = d;
			}
			if (exp && exp.toUTCString) {
				props.expires = exp.toUTCString();
			}
			value = encodeURIComponent(value);
			var updatedCookie = name + "=" + value, propName;
			for (propName in props) {
				updatedCookie += "; " + propName;
				var propValue = props[propName];
				if (propValue !== true) {
					updatedCookie += "=" + propValue;
				}
			}
			document.cookie = updatedCookie;
		}
	};
	dojo.cookie.isSupported = function () {
		if (!("cookieEnabled" in navigator)) {
			this("__djCookieTest__", "CookiesAllowed");
			navigator.cookieEnabled = this("__djCookieTest__") == "CookiesAllowed";
			if (navigator.cookieEnabled) {
				this("__djCookieTest__", "", {expires:-1});
			}
		}
		return navigator.cookieEnabled;
	};
}
if (!dojo._hasResource["dijit._Calendar"]) {
	dojo._hasResource["dijit._Calendar"] = true;
	dojo.provide("dijit._Calendar");
	dojo.deprecated("dijit._Calendar is deprecated", "dijit._Calendar moved to dijit.Calendar", 1.5);
	dijit._Calendar = dijit.Calendar;
}
if (!dojo._hasResource["dijit.form.FilteringSelect"]) {
	dojo._hasResource["dijit.form.FilteringSelect"] = true;
	dojo.provide("dijit.form.FilteringSelect");
	dojo.declare("dijit.form.FilteringSelect", [dijit.form.MappedTextBox, dijit.form.ComboBoxMixin], {_isvalid:true, required:true, _lastDisplayedValue:"", isValid:function () {
		return this._isvalid || (!this.required && this.attr("displayedValue") == "");
	}, _callbackSetLabel:function (result, dataObject, priorityChange) {
		if ((dataObject && dataObject.query[this.searchAttr] != this._lastQuery) || (!dataObject && result.length && this.store.getIdentity(result[0]) != this._lastQuery)) {
			return;
		}
		if (!result.length) {
			this.valueNode.value = "";
			dijit.form.TextBox.superclass._setValueAttr.call(this, "", priorityChange || (priorityChange === undefined && !this._focused));
			this._isvalid = false;
			this.validate(this._focused);
			this.item = null;
		} else {
			this.attr("item", result[0], priorityChange);
		}
	}, _openResultList:function (results, dataObject) {
		if (dataObject.query[this.searchAttr] != this._lastQuery) {
			return;
		}
		this._isvalid = results.length != 0;
		this.validate(true);
		dijit.form.ComboBoxMixin.prototype._openResultList.apply(this, arguments);
	}, _getValueAttr:function () {
		return this.valueNode.value;
	}, _getValueField:function () {
		return "value";
	}, _setValueAttr:function (value, priorityChange) {
		if (!this._onChangeActive) {
			priorityChange = null;
		}
		this._lastQuery = value;
		if (value === null || value === "") {
			this._setDisplayedValueAttr("", priorityChange);
			return;
		}
		var self = this;
		this.store.fetchItemByIdentity({identity:value, onItem:function (item) {
			self._callbackSetLabel([item], undefined, priorityChange);
		}});
	}, _setItemAttr:function (item, priorityChange, displayedValue) {
		this._isvalid = true;
		this.inherited(arguments);
		this.valueNode.value = this.value;
		this._lastDisplayedValue = this.textbox.value;
	}, _getDisplayQueryString:function (text) {
		return text.replace(/([\\\*\?])/g, "\\$1");
	}, _setDisplayedValueAttr:function (label, priorityChange) {
		if (!this._created) {
			priorityChange = false;
		}
		if (this.store) {
			this._hideResultList();
			var query = dojo.clone(this.query);
			this._lastQuery = query[this.searchAttr] = this._getDisplayQueryString(label);
			this.textbox.value = label;
			this._lastDisplayedValue = label;
			var _this = this;
			var fetch = {query:query, queryOptions:{ignoreCase:this.ignoreCase, deep:true}, onComplete:function (result, dataObject) {
				_this._fetchHandle = null;
				dojo.hitch(_this, "_callbackSetLabel")(result, dataObject, priorityChange);
			}, onError:function (errText) {
				_this._fetchHandle = null;
				console.error("dijit.form.FilteringSelect: " + errText);
				dojo.hitch(_this, "_callbackSetLabel")([], undefined, false);
			}};
			dojo.mixin(fetch, this.fetchProperties);
			this._fetchHandle = this.store.fetch(fetch);
		}
	}, postMixInProperties:function () {
		this.inherited(arguments);
		this._isvalid = !this.required;
	}, undo:function () {
		this.attr("displayedValue", this._lastDisplayedValue);
	}});
}
if (!dojo._hasResource["dojo.io.iframe"]) {
	dojo._hasResource["dojo.io.iframe"] = true;
	dojo.provide("dojo.io.iframe");
	dojo.io.iframe = {create:function (fname, onloadstr, uri) {
		if (window[fname]) {
			return window[fname];
		}
		if (window.frames[fname]) {
			return window.frames[fname];
		}
		var cframe = null;
		var turi = uri;
		if (!turi) {
			if (dojo.config["useXDomain"] && !dojo.config["dojoBlankHtmlUrl"]) {
				console.warn("dojo.io.iframe.create: When using cross-domain Dojo builds," + " please save dojo/resources/blank.html to your domain and set djConfig.dojoBlankHtmlUrl" + " to the path on your domain to blank.html");
			}
			turi = (dojo.config["dojoBlankHtmlUrl"] || dojo.moduleUrl("dojo", "resources/blank.html"));
		}
		var ifrstr = dojo.isIE ? "<iframe name=\"" + fname + "\" src=\"" + turi + "\" onload=\"" + onloadstr + "\">" : "iframe";
		cframe = dojo.doc.createElement(ifrstr);
		with (cframe) {
			name = fname;
			setAttribute("name", fname);
			id = fname;
		}
		dojo.body().appendChild(cframe);
		window[fname] = cframe;
		with (cframe.style) {
			if (!(dojo.isSafari < 3)) {
				position = "absolute";
			}
			left = top = "1px";
			height = width = "1px";
			visibility = "hidden";
		}
		if (!dojo.isIE) {
			this.setSrc(cframe, turi, true);
			cframe.onload = new Function(onloadstr);
		}
		return cframe;
	}, setSrc:function (iframe, src, replace) {
		try {
			if (!replace) {
				if (dojo.isWebKit) {
					iframe.location = src;
				} else {
					frames[iframe.name].location = src;
				}
			} else {
				var idoc;
				if (dojo.isIE || dojo.isWebKit > 521) {
					idoc = iframe.contentWindow.document;
				} else {
					if (dojo.isSafari) {
						idoc = iframe.document;
					} else {
						idoc = iframe.contentWindow;
					}
				}
				if (!idoc) {
					iframe.location = src;
					return;
				} else {
					idoc.location.replace(src);
				}
			}
		}
		catch (e) {
			console.log("dojo.io.iframe.setSrc: ", e);
		}
	}, doc:function (iframeNode) {
		var doc = iframeNode.contentDocument || (((iframeNode.name) && (iframeNode.document) && (dojo.doc.getElementsByTagName("iframe")[iframeNode.name].contentWindow) && (dojo.doc.getElementsByTagName("iframe")[iframeNode.name].contentWindow.document))) || ((iframeNode.name) && (dojo.doc.frames[iframeNode.name]) && (dojo.doc.frames[iframeNode.name].document)) || null;
		return doc;
	}, send:function (args) {
		if (!this["_frame"]) {
			this._frame = this.create(this._iframeName, dojo._scopeName + ".io.iframe._iframeOnload();");
		}
		var dfd = dojo._ioSetArgs(args, function (dfd) {
			dfd.canceled = true;
			dfd.ioArgs._callNext();
		}, function (dfd) {
			var value = null;
			try {
				var ioArgs = dfd.ioArgs;
				var dii = dojo.io.iframe;
				var ifd = dii.doc(dii._frame);
				var handleAs = ioArgs.handleAs;
				value = ifd;
				if (handleAs != "html") {
					if (handleAs == "xml") {
						if (dojo.isIE) {
							dojo.query("a", dii._frame.contentWindow.document.documentElement).orphan();
							var xmlText = (dii._frame.contentWindow.document).documentElement.innerText;
							xmlText = xmlText.replace(/>\s+</g, "><");
							xmlText = dojo.trim(xmlText);
							var fauxXhr = {responseText:xmlText};
							value = dojo._contentHandlers["xml"](fauxXhr);
						}
					} else {
						value = ifd.getElementsByTagName("textarea")[0].value;
						if (handleAs == "json") {
							value = dojo.fromJson(value);
						} else {
							if (handleAs == "javascript") {
								value = dojo.eval(value);
							}
						}
					}
				}
			}
			catch (e) {
				value = e;
			}
			finally {
				ioArgs._callNext();
			}
			return value;
		}, function (error, dfd) {
			dfd.ioArgs._hasError = true;
			dfd.ioArgs._callNext();
			return error;
		});
		dfd.ioArgs._callNext = function () {
			if (!this["_calledNext"]) {
				this._calledNext = true;
				dojo.io.iframe._currentDfd = null;
				dojo.io.iframe._fireNextRequest();
			}
		};
		this._dfdQueue.push(dfd);
		this._fireNextRequest();
		dojo._ioWatch(dfd, function (dfd) {
			return !dfd.ioArgs["_hasError"];
		}, function (dfd) {
			return (!!dfd.ioArgs["_finished"]);
		}, function (dfd) {
			if (dfd.ioArgs._finished) {
				dfd.callback(dfd);
			} else {
				dfd.errback(new Error("Invalid dojo.io.iframe request state"));
			}
		});
		return dfd;
	}, _currentDfd:null, _dfdQueue:[], _iframeName:dojo._scopeName + "IoIframe", _fireNextRequest:function () {
		try {
			if ((this._currentDfd) || (this._dfdQueue.length == 0)) {
				return;
			}
			do {
				var dfd = this._currentDfd = this._dfdQueue.shift();
			} while (dfd && dfd.canceled && this._dfdQueue.length);
			if (!dfd || dfd.canceled) {
				this._currentDfd = null;
				return;
			}
			var ioArgs = dfd.ioArgs;
			var args = ioArgs.args;
			ioArgs._contentToClean = [];
			var fn = dojo.byId(args["form"]);
			var content = args["content"] || {};
			if (fn) {
				if (content) {
					var pHandler = function (name, value) {
						var tn;
						if (dojo.isIE) {
							tn = dojo.doc.createElement("<input type='hidden' name='" + name + "'>");
						} else {
							tn = dojo.doc.createElement("input");
							tn.type = "hidden";
							tn.name = name;
						}
						tn.value = value;
						fn.appendChild(tn);
						ioArgs._contentToClean.push(name);
					};
					for (var x in content) {
						var val = content[x];
						if (dojo.isArray(val) && val.length > 1) {
							var i;
							for (i = 0; i < val.length; i++) {
								pHandler(x, val[i]);
							}
						} else {
							if (!fn[x]) {
								pHandler(x, val);
							} else {
								fn[x].value = val;
							}
						}
					}
				}
				var actnNode = fn.getAttributeNode("action");
				var mthdNode = fn.getAttributeNode("method");
				var trgtNode = fn.getAttributeNode("target");
				if (args["url"]) {
					ioArgs._originalAction = actnNode ? actnNode.value : null;
					if (actnNode) {
						actnNode.value = args.url;
					} else {
						fn.setAttribute("action", args.url);
					}
				}
				if (!mthdNode || !mthdNode.value) {
					if (mthdNode) {
						mthdNode.value = (args["method"]) ? args["method"] : "post";
					} else {
						fn.setAttribute("method", (args["method"]) ? args["method"] : "post");
					}
				}
				ioArgs._originalTarget = trgtNode ? trgtNode.value : null;
				if (trgtNode) {
					trgtNode.value = this._iframeName;
				} else {
					fn.setAttribute("target", this._iframeName);
				}
				fn.target = this._iframeName;
				dojo._ioNotifyStart(dfd);
				fn.submit();
			} else {
				var tmpUrl = args.url + (args.url.indexOf("?") > -1 ? "&" : "?") + ioArgs.query;
				dojo._ioNotifyStart(dfd);
				this.setSrc(this._frame, tmpUrl, true);
			}
		}
		catch (e) {
			dfd.errback(e);
		}
	}, _iframeOnload:function () {
		var dfd = this._currentDfd;
		if (!dfd) {
			this._fireNextRequest();
			return;
		}
		var ioArgs = dfd.ioArgs;
		var args = ioArgs.args;
		var fNode = dojo.byId(args.form);
		if (fNode) {
			var toClean = ioArgs._contentToClean;
			for (var i = 0; i < toClean.length; i++) {
				var key = toClean[i];
				for (var j = 0; j < fNode.childNodes.length; j++) {
					var chNode = fNode.childNodes[j];
					if (chNode.name == key) {
						dojo.destroy(chNode);
						break;
					}
				}
			}
			if (ioArgs["_originalAction"]) {
				fNode.setAttribute("action", ioArgs._originalAction);
			}
			if (ioArgs["_originalTarget"]) {
				fNode.setAttribute("target", ioArgs._originalTarget);
				fNode.target = ioArgs._originalTarget;
			}
		}
		ioArgs._finished = true;
	}};
}
if (!dojo._hasResource["dojo.fx.Toggler"]) {
	dojo._hasResource["dojo.fx.Toggler"] = true;
	dojo.provide("dojo.fx.Toggler");
	dojo.declare("dojo.fx.Toggler", null, {node:null, showFunc:dojo.fadeIn, hideFunc:dojo.fadeOut, showDuration:200, hideDuration:200, constructor:function (args) {
		var _t = this;
		dojo.mixin(_t, args);
		_t.node = args.node;
		_t._showArgs = dojo.mixin({}, args);
		_t._showArgs.node = _t.node;
		_t._showArgs.duration = _t.showDuration;
		_t.showAnim = _t.showFunc(_t._showArgs);
		_t._hideArgs = dojo.mixin({}, args);
		_t._hideArgs.node = _t.node;
		_t._hideArgs.duration = _t.hideDuration;
		_t.hideAnim = _t.hideFunc(_t._hideArgs);
		dojo.connect(_t.showAnim, "beforeBegin", dojo.hitch(_t.hideAnim, "stop", true));
		dojo.connect(_t.hideAnim, "beforeBegin", dojo.hitch(_t.showAnim, "stop", true));
	}, show:function (delay) {
		return this.showAnim.play(delay || 0);
	}, hide:function (delay) {
		return this.hideAnim.play(delay || 0);
	}});
}
if (!dojo._hasResource["dojo.fx"]) {
	dojo._hasResource["dojo.fx"] = true;
	dojo.provide("dojo.fx");
	(function () {
		var d = dojo, _baseObj = {_fire:function (evt, args) {
			if (this[evt]) {
				this[evt].apply(this, args || []);
			}
			return this;
		}};
		var _chain = function (animations) {
			this._index = -1;
			this._animations = animations || [];
			this._current = this._onAnimateCtx = this._onEndCtx = null;
			this.duration = 0;
			d.forEach(this._animations, function (a) {
				this.duration += a.duration;
				if (a.delay) {
					this.duration += a.delay;
				}
			}, this);
		};
		d.extend(_chain, {_onAnimate:function () {
			this._fire("onAnimate", arguments);
		}, _onEnd:function () {
			d.disconnect(this._onAnimateCtx);
			d.disconnect(this._onEndCtx);
			this._onAnimateCtx = this._onEndCtx = null;
			if (this._index + 1 == this._animations.length) {
				this._fire("onEnd");
			} else {
				this._current = this._animations[++this._index];
				this._onAnimateCtx = d.connect(this._current, "onAnimate", this, "_onAnimate");
				this._onEndCtx = d.connect(this._current, "onEnd", this, "_onEnd");
				this._current.play(0, true);
			}
		}, play:function (delay, gotoStart) {
			if (!this._current) {
				this._current = this._animations[this._index = 0];
			}
			if (!gotoStart && this._current.status() == "playing") {
				return this;
			}
			var beforeBegin = d.connect(this._current, "beforeBegin", this, function () {
				this._fire("beforeBegin");
			}), onBegin = d.connect(this._current, "onBegin", this, function (arg) {
				this._fire("onBegin", arguments);
			}), onPlay = d.connect(this._current, "onPlay", this, function (arg) {
				this._fire("onPlay", arguments);
				d.disconnect(beforeBegin);
				d.disconnect(onBegin);
				d.disconnect(onPlay);
			});
			if (this._onAnimateCtx) {
				d.disconnect(this._onAnimateCtx);
			}
			this._onAnimateCtx = d.connect(this._current, "onAnimate", this, "_onAnimate");
			if (this._onEndCtx) {
				d.disconnect(this._onEndCtx);
			}
			this._onEndCtx = d.connect(this._current, "onEnd", this, "_onEnd");
			this._current.play.apply(this._current, arguments);
			return this;
		}, pause:function () {
			if (this._current) {
				var e = d.connect(this._current, "onPause", this, function (arg) {
					this._fire("onPause", arguments);
					d.disconnect(e);
				});
				this._current.pause();
			}
			return this;
		}, gotoPercent:function (percent, andPlay) {
			this.pause();
			var offset = this.duration * percent;
			this._current = null;
			d.some(this._animations, function (a) {
				if (a.duration <= offset) {
					this._current = a;
					return true;
				}
				offset -= a.duration;
				return false;
			});
			if (this._current) {
				this._current.gotoPercent(offset / this._current.duration, andPlay);
			}
			return this;
		}, stop:function (gotoEnd) {
			if (this._current) {
				if (gotoEnd) {
					for (; this._index + 1 < this._animations.length; ++this._index) {
						this._animations[this._index].stop(true);
					}
					this._current = this._animations[this._index];
				}
				var e = d.connect(this._current, "onStop", this, function (arg) {
					this._fire("onStop", arguments);
					d.disconnect(e);
				});
				this._current.stop();
			}
			return this;
		}, status:function () {
			return this._current ? this._current.status() : "stopped";
		}, destroy:function () {
			if (this._onAnimateCtx) {
				d.disconnect(this._onAnimateCtx);
			}
			if (this._onEndCtx) {
				d.disconnect(this._onEndCtx);
			}
		}});
		d.extend(_chain, _baseObj);
		dojo.fx.chain = function (animations) {
			return new _chain(animations);
		};
		var _combine = function (animations) {
			this._animations = animations || [];
			this._connects = [];
			this._finished = 0;
			this.duration = 0;
			d.forEach(animations, function (a) {
				var duration = a.duration;
				if (a.delay) {
					duration += a.delay;
				}
				if (this.duration < duration) {
					this.duration = duration;
				}
				this._connects.push(d.connect(a, "onEnd", this, "_onEnd"));
			}, this);
			this._pseudoAnimation = new d.Animation({curve:[0, 1], duration:this.duration});
			var self = this;
			d.forEach(["beforeBegin", "onBegin", "onPlay", "onAnimate", "onPause", "onStop", "onEnd"], function (evt) {
				self._connects.push(d.connect(self._pseudoAnimation, evt, function () {
					self._fire(evt, arguments);
				}));
			});
		};
		d.extend(_combine, {_doAction:function (action, args) {
			d.forEach(this._animations, function (a) {
				a[action].apply(a, args);
			});
			return this;
		}, _onEnd:function () {
			if (++this._finished > this._animations.length) {
				this._fire("onEnd");
			}
		}, _call:function (action, args) {
			var t = this._pseudoAnimation;
			t[action].apply(t, args);
		}, play:function (delay, gotoStart) {
			this._finished = 0;
			this._doAction("play", arguments);
			this._call("play", arguments);
			return this;
		}, pause:function () {
			this._doAction("pause", arguments);
			this._call("pause", arguments);
			return this;
		}, gotoPercent:function (percent, andPlay) {
			var ms = this.duration * percent;
			d.forEach(this._animations, function (a) {
				a.gotoPercent(a.duration < ms ? 1 : (ms / a.duration), andPlay);
			});
			this._call("gotoPercent", arguments);
			return this;
		}, stop:function (gotoEnd) {
			this._doAction("stop", arguments);
			this._call("stop", arguments);
			return this;
		}, status:function () {
			return this._pseudoAnimation.status();
		}, destroy:function () {
			d.forEach(this._connects, dojo.disconnect);
		}});
		d.extend(_combine, _baseObj);
		dojo.fx.combine = function (animations) {
			return new _combine(animations);
		};
		dojo.fx.wipeIn = function (args) {
			var node = args.node = d.byId(args.node), s = node.style, o;
			var anim = d.animateProperty(d.mixin({properties:{height:{start:function () {
				o = s.overflow;
				s.overflow = "hidden";
				if (s.visibility == "hidden" || s.display == "none") {
					s.height = "1px";
					s.display = "";
					s.visibility = "";
					return 1;
				} else {
					var height = d.style(node, "height");
					return Math.max(height, 1);
				}
			}, end:function () {
				return node.scrollHeight;
			}}}}, args));
			d.connect(anim, "onEnd", function () {
				s.height = "auto";
				s.overflow = o;
			});
			return anim;
		};
		dojo.fx.wipeOut = function (args) {
			var node = args.node = d.byId(args.node), s = node.style, o;
			var anim = d.animateProperty(d.mixin({properties:{height:{end:1}}}, args));
			d.connect(anim, "beforeBegin", function () {
				o = s.overflow;
				s.overflow = "hidden";
				s.display = "";
			});
			d.connect(anim, "onEnd", function () {
				s.overflow = o;
				s.height = "auto";
				s.display = "none";
			});
			return anim;
		};
		dojo.fx.slideTo = function (args) {
			var node = args.node = d.byId(args.node), top = null, left = null;
			var init = (function (n) {
				return function () {
					var cs = d.getComputedStyle(n);
					var pos = cs.position;
					top = (pos == "absolute" ? n.offsetTop : parseInt(cs.top) || 0);
					left = (pos == "absolute" ? n.offsetLeft : parseInt(cs.left) || 0);
					if (pos != "absolute" && pos != "relative") {
						var ret = d.position(n, true);
						top = ret.y;
						left = ret.x;
						n.style.position = "absolute";
						n.style.top = top + "px";
						n.style.left = left + "px";
					}
				};
			})(node);
			init();
			var anim = d.animateProperty(d.mixin({properties:{top:args.top || 0, left:args.left || 0}}, args));
			d.connect(anim, "beforeBegin", anim, init);
			return anim;
		};
	})();
}
if (!dojo._hasResource["dijit.ProgressBar"]) {
	dojo._hasResource["dijit.ProgressBar"] = true;
	dojo.provide("dijit.ProgressBar");
	dojo.declare("dijit.ProgressBar", [dijit._Widget, dijit._Templated], {progress:"0", maximum:100, places:0, indeterminate:false, name:"", templateString:dojo.cache("dijit", "templates/ProgressBar.html", "<div class=\"dijitProgressBar dijitProgressBarEmpty\"\r\n\t><div waiRole=\"progressbar\" dojoAttachPoint=\"internalProgress\" class=\"dijitProgressBarFull\"\r\n\t\t><div class=\"dijitProgressBarTile\"></div\r\n\t\t><span style=\"visibility:hidden\">&nbsp;</span\r\n\t></div\r\n\t><div dojoAttachPoint=\"label\" class=\"dijitProgressBarLabel\" id=\"${id}_label\">&nbsp;</div\r\n\t><img dojoAttachPoint=\"indeterminateHighContrastImage\" class=\"dijitProgressBarIndeterminateHighContrastImage\" alt=\"\"\r\n\t></img\r\n></div>\r\n"), _indeterminateHighContrastImagePath:dojo.moduleUrl("dijit", "themes/a11y/indeterminate_progress.gif"), postCreate:function () {
		this.inherited(arguments);
		this.indeterminateHighContrastImage.setAttribute("src", this._indeterminateHighContrastImagePath.toString());
		this.update();
	}, update:function (attributes) {
		dojo.mixin(this, attributes || {});
		var tip = this.internalProgress;
		var percent = 1, classFunc;
		if (this.indeterminate) {
			classFunc = "addClass";
			dijit.removeWaiState(tip, "valuenow");
			dijit.removeWaiState(tip, "valuemin");
			dijit.removeWaiState(tip, "valuemax");
		} else {
			classFunc = "removeClass";
			if (String(this.progress).indexOf("%") != -1) {
				percent = Math.min(parseFloat(this.progress) / 100, 1);
				this.progress = percent * this.maximum;
			} else {
				this.progress = Math.min(this.progress, this.maximum);
				percent = this.progress / this.maximum;
			}
			var text = this.report(percent);
			this.label.firstChild.nodeValue = text;
			dijit.setWaiState(tip, "describedby", this.label.id);
			dijit.setWaiState(tip, "valuenow", this.progress);
			dijit.setWaiState(tip, "valuemin", 0);
			dijit.setWaiState(tip, "valuemax", this.maximum);
		}
		dojo[classFunc](this.domNode, "dijitProgressBarIndeterminate");
		tip.style.width = (percent * 100) + "%";
		this.onChange();
	}, _setValueAttr:function (v) {
		if (v == Infinity) {
			this.update({indeterminate:true});
		} else {
			this.update({indeterminate:false, progress:v});
		}
	}, _getValueAttr:function () {
		return this.progress;
	}, report:function (percent) {
		return dojo.number.format(percent, {type:"percent", places:this.places, locale:this.lang});
	}, onChange:function () {
	}});
}
if (!dojo._hasResource["dojox.gfx.matrix"]) {
	dojo._hasResource["dojox.gfx.matrix"] = true;
	dojo.provide("dojox.gfx.matrix");
	(function () {
		var m = dojox.gfx.matrix;
		var _degToRadCache = {};
		m._degToRad = function (degree) {
			return _degToRadCache[degree] || (_degToRadCache[degree] = (Math.PI * degree / 180));
		};
		m._radToDeg = function (radian) {
			return radian / Math.PI * 180;
		};
		m.Matrix2D = function (arg) {
			if (arg) {
				if (typeof arg == "number") {
					this.xx = this.yy = arg;
				} else {
					if (arg instanceof Array) {
						if (arg.length > 0) {
							var matrix = m.normalize(arg[0]);
							for (var i = 1; i < arg.length; ++i) {
								var l = matrix, r = dojox.gfx.matrix.normalize(arg[i]);
								matrix = new m.Matrix2D();
								matrix.xx = l.xx * r.xx + l.xy * r.yx;
								matrix.xy = l.xx * r.xy + l.xy * r.yy;
								matrix.yx = l.yx * r.xx + l.yy * r.yx;
								matrix.yy = l.yx * r.xy + l.yy * r.yy;
								matrix.dx = l.xx * r.dx + l.xy * r.dy + l.dx;
								matrix.dy = l.yx * r.dx + l.yy * r.dy + l.dy;
							}
							dojo.mixin(this, matrix);
						}
					} else {
						dojo.mixin(this, arg);
					}
				}
			}
		};
		dojo.extend(m.Matrix2D, {xx:1, xy:0, yx:0, yy:1, dx:0, dy:0});
		dojo.mixin(m, {identity:new m.Matrix2D(), flipX:new m.Matrix2D({xx:-1}), flipY:new m.Matrix2D({yy:-1}), flipXY:new m.Matrix2D({xx:-1, yy:-1}), translate:function (a, b) {
			if (arguments.length > 1) {
				return new m.Matrix2D({dx:a, dy:b});
			}
			return new m.Matrix2D({dx:a.x, dy:a.y});
		}, scale:function (a, b) {
			if (arguments.length > 1) {
				return new m.Matrix2D({xx:a, yy:b});
			}
			if (typeof a == "number") {
				return new m.Matrix2D({xx:a, yy:a});
			}
			return new m.Matrix2D({xx:a.x, yy:a.y});
		}, rotate:function (angle) {
			var c = Math.cos(angle);
			var s = Math.sin(angle);
			return new m.Matrix2D({xx:c, xy:-s, yx:s, yy:c});
		}, rotateg:function (degree) {
			return m.rotate(m._degToRad(degree));
		}, skewX:function (angle) {
			return new m.Matrix2D({xy:Math.tan(angle)});
		}, skewXg:function (degree) {
			return m.skewX(m._degToRad(degree));
		}, skewY:function (angle) {
			return new m.Matrix2D({yx:Math.tan(angle)});
		}, skewYg:function (degree) {
			return m.skewY(m._degToRad(degree));
		}, reflect:function (a, b) {
			if (arguments.length == 1) {
				b = a.y;
				a = a.x;
			}
			var a2 = a * a, b2 = b * b, n2 = a2 + b2, xy = 2 * a * b / n2;
			return new m.Matrix2D({xx:2 * a2 / n2 - 1, xy:xy, yx:xy, yy:2 * b2 / n2 - 1});
		}, project:function (a, b) {
			if (arguments.length == 1) {
				b = a.y;
				a = a.x;
			}
			var a2 = a * a, b2 = b * b, n2 = a2 + b2, xy = a * b / n2;
			return new m.Matrix2D({xx:a2 / n2, xy:xy, yx:xy, yy:b2 / n2});
		}, normalize:function (matrix) {
			return (matrix instanceof m.Matrix2D) ? matrix : new m.Matrix2D(matrix);
		}, clone:function (matrix) {
			var obj = new m.Matrix2D();
			for (var i in matrix) {
				if (typeof (matrix[i]) == "number" && typeof (obj[i]) == "number" && obj[i] != matrix[i]) {
					obj[i] = matrix[i];
				}
			}
			return obj;
		}, invert:function (matrix) {
			var M = m.normalize(matrix), D = M.xx * M.yy - M.xy * M.yx, M = new m.Matrix2D({xx:M.yy / D, xy:-M.xy / D, yx:-M.yx / D, yy:M.xx / D, dx:(M.xy * M.dy - M.yy * M.dx) / D, dy:(M.yx * M.dx - M.xx * M.dy) / D});
			return M;
		}, _multiplyPoint:function (matrix, x, y) {
			return {x:matrix.xx * x + matrix.xy * y + matrix.dx, y:matrix.yx * x + matrix.yy * y + matrix.dy};
		}, multiplyPoint:function (matrix, a, b) {
			var M = m.normalize(matrix);
			if (typeof a == "number" && typeof b == "number") {
				return m._multiplyPoint(M, a, b);
			}
			return m._multiplyPoint(M, a.x, a.y);
		}, multiply:function (matrix) {
			var M = m.normalize(matrix);
			for (var i = 1; i < arguments.length; ++i) {
				var l = M, r = m.normalize(arguments[i]);
				M = new m.Matrix2D();
				M.xx = l.xx * r.xx + l.xy * r.yx;
				M.xy = l.xx * r.xy + l.xy * r.yy;
				M.yx = l.yx * r.xx + l.yy * r.yx;
				M.yy = l.yx * r.xy + l.yy * r.yy;
				M.dx = l.xx * r.dx + l.xy * r.dy + l.dx;
				M.dy = l.yx * r.dx + l.yy * r.dy + l.dy;
			}
			return M;
		}, _sandwich:function (matrix, x, y) {
			return m.multiply(m.translate(x, y), matrix, m.translate(-x, -y));
		}, scaleAt:function (a, b, c, d) {
			switch (arguments.length) {
			  case 4:
				return m._sandwich(m.scale(a, b), c, d);
			  case 3:
				if (typeof c == "number") {
					return m._sandwich(m.scale(a), b, c);
				}
				return m._sandwich(m.scale(a, b), c.x, c.y);
			}
			return m._sandwich(m.scale(a), b.x, b.y);
		}, rotateAt:function (angle, a, b) {
			if (arguments.length > 2) {
				return m._sandwich(m.rotate(angle), a, b);
			}
			return m._sandwich(m.rotate(angle), a.x, a.y);
		}, rotategAt:function (degree, a, b) {
			if (arguments.length > 2) {
				return m._sandwich(m.rotateg(degree), a, b);
			}
			return m._sandwich(m.rotateg(degree), a.x, a.y);
		}, skewXAt:function (angle, a, b) {
			if (arguments.length > 2) {
				return m._sandwich(m.skewX(angle), a, b);
			}
			return m._sandwich(m.skewX(angle), a.x, a.y);
		}, skewXgAt:function (degree, a, b) {
			if (arguments.length > 2) {
				return m._sandwich(m.skewXg(degree), a, b);
			}
			return m._sandwich(m.skewXg(degree), a.x, a.y);
		}, skewYAt:function (angle, a, b) {
			if (arguments.length > 2) {
				return m._sandwich(m.skewY(angle), a, b);
			}
			return m._sandwich(m.skewY(angle), a.x, a.y);
		}, skewYgAt:function (degree, a, b) {
			if (arguments.length > 2) {
				return m._sandwich(m.skewYg(degree), a, b);
			}
			return m._sandwich(m.skewYg(degree), a.x, a.y);
		}});
	})();
	dojox.gfx.Matrix2D = dojox.gfx.matrix.Matrix2D;
}
if (!dojo._hasResource["dojox.gfx._base"]) {
	dojo._hasResource["dojox.gfx._base"] = true;
	dojo.provide("dojox.gfx._base");
	(function () {
		var g = dojox.gfx, b = g._base;
		g._hasClass = function (node, classStr) {
			var cls = node.getAttribute("className");
			return cls && (" " + cls + " ").indexOf(" " + classStr + " ") >= 0;
		};
		g._addClass = function (node, classStr) {
			var cls = node.getAttribute("className") || "";
			if (!cls || (" " + cls + " ").indexOf(" " + classStr + " ") < 0) {
				node.setAttribute("className", cls + (cls ? " " : "") + classStr);
			}
		};
		g._removeClass = function (node, classStr) {
			var cls = node.getAttribute("className");
			if (cls) {
				node.setAttribute("className", cls.replace(new RegExp("(^|\\s+)" + classStr + "(\\s+|$)"), "$1$2"));
			}
		};
		b._getFontMeasurements = function () {
			var heights = {"1em":0, "1ex":0, "100%":0, "12pt":0, "16px":0, "xx-small":0, "x-small":0, "small":0, "medium":0, "large":0, "x-large":0, "xx-large":0};
			if (dojo.isIE) {
				dojo.doc.documentElement.style.fontSize = "100%";
			}
			var div = dojo.doc.createElement("div");
			var s = div.style;
			s.position = "absolute";
			s.left = "-100px";
			s.top = "0px";
			s.width = "30px";
			s.height = "1000em";
			s.border = "0px";
			s.margin = "0px";
			s.padding = "0px";
			s.outline = "none";
			s.lineHeight = "1";
			s.overflow = "hidden";
			dojo.body().appendChild(div);
			for (var p in heights) {
				div.style.fontSize = p;
				heights[p] = Math.round(div.offsetHeight * 12 / 16) * 16 / 12 / 1000;
			}
			dojo.body().removeChild(div);
			div = null;
			return heights;
		};
		var fontMeasurements = null;
		b._getCachedFontMeasurements = function (recalculate) {
			if (recalculate || !fontMeasurements) {
				fontMeasurements = b._getFontMeasurements();
			}
			return fontMeasurements;
		};
		var measuringNode = null, empty = {};
		b._getTextBox = function (text, style, className) {
			var m, s, al = arguments.length;
			if (!measuringNode) {
				m = measuringNode = dojo.doc.createElement("div");
				s = m.style;
				s.position = "absolute";
				s.left = "-10000px";
				s.top = "0";
				dojo.body().appendChild(m);
			} else {
				m = measuringNode;
				s = m.style;
			}
			m.className = "";
			s.border = "0";
			s.margin = "0";
			s.padding = "0";
			s.outline = "0";
			if (al > 1 && style) {
				for (var i in style) {
					if (i in empty) {
						continue;
					}
					s[i] = style[i];
				}
			}
			if (al > 2 && className) {
				m.className = className;
			}
			m.innerHTML = text;
			if (m["getBoundingClientRect"]) {
				var bcr = m.getBoundingClientRect();
				return {l:bcr.left, t:bcr.top, w:bcr.width || (bcr.right - bcr.left), h:bcr.height || (bcr.bottom - bcr.top)};
			} else {
				return dojo.marginBox(m);
			}
		};
		var uniqueId = 0;
		b._getUniqueId = function () {
			var id;
			do {
				id = dojo._scopeName + "Unique" + (++uniqueId);
			} while (dojo.byId(id));
			return id;
		};
	})();
	dojo.mixin(dojox.gfx, {defaultPath:{type:"path", path:""}, defaultPolyline:{type:"polyline", points:[]}, defaultRect:{type:"rect", x:0, y:0, width:100, height:100, r:0}, defaultEllipse:{type:"ellipse", cx:0, cy:0, rx:200, ry:100}, defaultCircle:{type:"circle", cx:0, cy:0, r:100}, defaultLine:{type:"line", x1:0, y1:0, x2:100, y2:100}, defaultImage:{type:"image", x:0, y:0, width:0, height:0, src:""}, defaultText:{type:"text", x:0, y:0, text:"", align:"start", decoration:"none", rotated:false, kerning:true}, defaultTextPath:{type:"textpath", text:"", align:"start", decoration:"none", rotated:false, kerning:true}, defaultStroke:{type:"stroke", color:"black", style:"solid", width:1, cap:"butt", join:4}, defaultLinearGradient:{type:"linear", x1:0, y1:0, x2:100, y2:100, colors:[{offset:0, color:"black"}, {offset:1, color:"white"}]}, defaultRadialGradient:{type:"radial", cx:0, cy:0, r:100, colors:[{offset:0, color:"black"}, {offset:1, color:"white"}]}, defaultPattern:{type:"pattern", x:0, y:0, width:0, height:0, src:""}, defaultFont:{type:"font", style:"normal", variant:"normal", weight:"normal", size:"10pt", family:"serif"}, getDefault:(function () {
		var typeCtorCache = {};
		return function (type) {
			var t = typeCtorCache[type];
			if (t) {
				return new t();
			}
			t = typeCtorCache[type] = new Function;
			t.prototype = dojox.gfx["default" + type];
			return new t();
		};
	})(), normalizeColor:function (color) {
		return (color instanceof dojo.Color) ? color : new dojo.Color(color);
	}, normalizeParameters:function (existed, update) {
		if (update) {
			var empty = {};
			for (var x in existed) {
				if (x in update && !(x in empty)) {
					existed[x] = update[x];
				}
			}
		}
		return existed;
	}, makeParameters:function (defaults, update) {
		if (!update) {
			return dojo.delegate(defaults);
		}
		var result = {};
		for (var i in defaults) {
			if (!(i in result)) {
				result[i] = dojo.clone((i in update) ? update[i] : defaults[i]);
			}
		}
		return result;
	}, formatNumber:function (x, addSpace) {
		var val = x.toString();
		if (val.indexOf("e") >= 0) {
			val = x.toFixed(4);
		} else {
			var point = val.indexOf(".");
			if (point >= 0 && val.length - point > 5) {
				val = x.toFixed(4);
			}
		}
		if (x < 0) {
			return val;
		}
		return addSpace ? " " + val : val;
	}, makeFontString:function (font) {
		return font.style + " " + font.variant + " " + font.weight + " " + font.size + " " + font.family;
	}, splitFontString:function (str) {
		var font = dojox.gfx.getDefault("Font");
		var t = str.split(/\s+/);
		do {
			if (t.length < 5) {
				break;
			}
			font.style = t[0];
			font.variant = t[1];
			font.weight = t[2];
			var i = t[3].indexOf("/");
			font.size = i < 0 ? t[3] : t[3].substring(0, i);
			var j = 4;
			if (i < 0) {
				if (t[4] == "/") {
					j = 6;
				} else {
					if (t[4].charAt(0) == "/") {
						j = 5;
					}
				}
			}
			if (j < t.length) {
				font.family = t.slice(j).join(" ");
			}
		} while (false);
		return font;
	}, cm_in_pt:72 / 2.54, mm_in_pt:7.2 / 2.54, px_in_pt:function () {
		return dojox.gfx._base._getCachedFontMeasurements()["12pt"] / 12;
	}, pt2px:function (len) {
		return len * dojox.gfx.px_in_pt();
	}, px2pt:function (len) {
		return len / dojox.gfx.px_in_pt();
	}, normalizedLength:function (len) {
		if (len.length == 0) {
			return 0;
		}
		if (len.length > 2) {
			var px_in_pt = dojox.gfx.px_in_pt();
			var val = parseFloat(len);
			switch (len.slice(-2)) {
			  case "px":
				return val;
			  case "pt":
				return val * px_in_pt;
			  case "in":
				return val * 72 * px_in_pt;
			  case "pc":
				return val * 12 * px_in_pt;
			  case "mm":
				return val * dojox.gfx.mm_in_pt * px_in_pt;
			  case "cm":
				return val * dojox.gfx.cm_in_pt * px_in_pt;
			}
		}
		return parseFloat(len);
	}, pathVmlRegExp:/([A-Za-z]+)|(\d+(\.\d+)?)|(\.\d+)|(-\d+(\.\d+)?)|(-\.\d+)/g, pathSvgRegExp:/([A-Za-z])|(\d+(\.\d+)?)|(\.\d+)|(-\d+(\.\d+)?)|(-\.\d+)/g, equalSources:function (a, b) {
		return a && b && a == b;
	}});
}
if (!dojo._hasResource["dojox.gfx"]) {
	dojo._hasResource["dojox.gfx"] = true;
	dojo.provide("dojox.gfx");
	dojo.loadInit(function () {
		var gfx = dojo.getObject("dojox.gfx", true), sl, flag, match;
		if (!gfx.renderer) {
			if (dojo.config.forceGfxRenderer) {
				dojox.gfx.renderer = dojo.config.forceGfxRenderer;
				return;
			}
			var renderers = (typeof dojo.config.gfxRenderer == "string" ? dojo.config.gfxRenderer : "svg,vml,silverlight,canvas").split(",");
			var ua = navigator.userAgent, iPhoneOsBuild = 0, androidVersion = 0;
			if (dojo.isSafari >= 3) {
				if (ua.indexOf("iPhone") >= 0 || ua.indexOf("iPod") >= 0) {
					match = ua.match(/Version\/(\d(\.\d)?(\.\d)?)\sMobile\/([^\s]*)\s?/);
					if (match) {
						iPhoneOsBuild = parseInt(match[4].substr(0, 3), 16);
					}
				}
			}
			if (dojo.isWebKit) {
				if (!iPhoneOsBuild) {
					match = ua.match(/Android\s+(\d+\.\d+)/);
					if (match) {
						androidVersion = parseFloat(match[1]);
					}
				}
			}
			for (var i = 0; i < renderers.length; ++i) {
				switch (renderers[i]) {
				  case "svg":
					if (!dojo.isIE && (!iPhoneOsBuild || iPhoneOsBuild >= 1521) && !androidVersion && !dojo.isAIR) {
						dojox.gfx.renderer = "svg";
					}
					break;
				  case "vml":
					if (dojo.isIE) {
						dojox.gfx.renderer = "vml";
					}
					break;
				  case "silverlight":
					try {
						if (dojo.isIE) {
							sl = new ActiveXObject("AgControl.AgControl");
							if (sl && sl.IsVersionSupported("1.0")) {
								flag = true;
							}
						} else {
							if (navigator.plugins["Silverlight Plug-In"]) {
								flag = true;
							}
						}
					}
					catch (e) {
						flag = false;
					}
					finally {
						sl = null;
					}
					if (flag) {
						dojox.gfx.renderer = "silverlight";
					}
					break;
				  case "canvas":
					if (!dojo.isIE) {
						dojox.gfx.renderer = "canvas";
					}
					break;
				}
				if (dojox.gfx.renderer) {
					break;
				}
			}
			if (dojo.config.isDebug) {
				console.log("gfx renderer = " + dojox.gfx.renderer);
			}
		}
	});
	dojo.requireIf(dojox.gfx.renderer == "svg", "dojox.gfx.svg");
	dojo.requireIf(dojox.gfx.renderer == "vml", "dojox.gfx.vml");
	dojo.requireIf(dojox.gfx.renderer == "silverlight", "dojox.gfx.silverlight");
	dojo.requireIf(dojox.gfx.renderer == "canvas", "dojox.gfx.canvas");
}
if (!dojo._hasResource["dojox.lang.functional.lambda"]) {
	dojo._hasResource["dojox.lang.functional.lambda"] = true;
	dojo.provide("dojox.lang.functional.lambda");
	(function () {
		var df = dojox.lang.functional, lcache = {};
		var split = "ab".split(/a*/).length > 1 ? String.prototype.split : function (sep) {
			var r = this.split.call(this, sep), m = sep.exec(this);
			if (m && m.index == 0) {
				r.unshift("");
			}
			return r;
		};
		var lambda = function (s) {
			var args = [], sects = split.call(s, /\s*->\s*/m);
			if (sects.length > 1) {
				while (sects.length) {
					s = sects.pop();
					args = sects.pop().split(/\s*,\s*|\s+/m);
					if (sects.length) {
						sects.push("(function(" + args + "){return (" + s + ")})");
					}
				}
			} else {
				if (s.match(/\b_\b/)) {
					args = ["_"];
				} else {
					var l = s.match(/^\s*(?:[+*\/%&|\^\.=<>]|!=)/m), r = s.match(/[+\-*\/%&|\^\.=<>!]\s*$/m);
					if (l || r) {
						if (l) {
							args.push("$1");
							s = "$1" + s;
						}
						if (r) {
							args.push("$2");
							s = s + "$2";
						}
					} else {
						var vars = s.replace(/(?:\b[A-Z]|\.[a-zA-Z_$])[a-zA-Z_$\d]*|[a-zA-Z_$][a-zA-Z_$\d]*:|this|true|false|null|undefined|typeof|instanceof|in|delete|new|void|arguments|decodeURI|decodeURIComponent|encodeURI|encodeURIComponent|escape|eval|isFinite|isNaN|parseFloat|parseInt|unescape|dojo|dijit|dojox|window|document|'(?:[^'\\]|\\.)*'|"(?:[^"\\]|\\.)*"/g, "").match(/([a-z_$][a-z_$\d]*)/gi) || [], t = {};
						dojo.forEach(vars, function (v) {
							if (!(v in t)) {
								args.push(v);
								t[v] = 1;
							}
						});
					}
				}
			}
			return {args:args, body:s};
		};
		var compose = function (a) {
			return a.length ? function () {
				var i = a.length - 1, x = df.lambda(a[i]).apply(this, arguments);
				for (--i; i >= 0; --i) {
					x = df.lambda(a[i]).call(this, x);
				}
				return x;
			} : function (x) {
				return x;
			};
		};
		dojo.mixin(df, {rawLambda:function (s) {
			return lambda(s);
		}, buildLambda:function (s) {
			s = lambda(s);
			return "function(" + s.args.join(",") + "){return (" + s.body + ");}";
		}, lambda:function (s) {
			if (typeof s == "function") {
				return s;
			}
			if (s instanceof Array) {
				return compose(s);
			}
			if (s in lcache) {
				return lcache[s];
			}
			s = lambda(s);
			return lcache[s] = new Function(s.args, "return (" + s.body + ");");
		}, clearLambdaCache:function () {
			lcache = {};
		}});
	})();
}
if (!dojo._hasResource["dojox.lang.functional.array"]) {
	dojo._hasResource["dojox.lang.functional.array"] = true;
	dojo.provide("dojox.lang.functional.array");
	(function () {
		var d = dojo, df = dojox.lang.functional, empty = {};
		d.mixin(df, {filter:function (a, f, o) {
			if (typeof a == "string") {
				a = a.split("");
			}
			o = o || d.global;
			f = df.lambda(f);
			var t = [], v, i, n;
			if (d.isArray(a)) {
				for (i = 0, n = a.length; i < n; ++i) {
					v = a[i];
					if (f.call(o, v, i, a)) {
						t.push(v);
					}
				}
			} else {
				if (typeof a.hasNext == "function" && typeof a.next == "function") {
					for (i = 0; a.hasNext(); ) {
						v = a.next();
						if (f.call(o, v, i++, a)) {
							t.push(v);
						}
					}
				} else {
					for (i in a) {
						if (!(i in empty)) {
							v = a[i];
							if (f.call(o, v, i, a)) {
								t.push(v);
							}
						}
					}
				}
			}
			return t;
		}, forEach:function (a, f, o) {
			if (typeof a == "string") {
				a = a.split("");
			}
			o = o || d.global;
			f = df.lambda(f);
			var i, n;
			if (d.isArray(a)) {
				for (i = 0, n = a.length; i < n; f.call(o, a[i], i, a), ++i) {
				}
			} else {
				if (typeof a.hasNext == "function" && typeof a.next == "function") {
					for (i = 0; a.hasNext(); f.call(o, a.next(), i++, a)) {
					}
				} else {
					for (i in a) {
						if (!(i in empty)) {
							f.call(o, a[i], i, a);
						}
					}
				}
			}
			return o;
		}, map:function (a, f, o) {
			if (typeof a == "string") {
				a = a.split("");
			}
			o = o || d.global;
			f = df.lambda(f);
			var t, n, i;
			if (d.isArray(a)) {
				t = new Array(n = a.length);
				for (i = 0; i < n; t[i] = f.call(o, a[i], i, a), ++i) {
				}
			} else {
				if (typeof a.hasNext == "function" && typeof a.next == "function") {
					t = [];
					for (i = 0; a.hasNext(); t.push(f.call(o, a.next(), i++, a))) {
					}
				} else {
					t = [];
					for (i in a) {
						if (!(i in empty)) {
							t.push(f.call(o, a[i], i, a));
						}
					}
				}
			}
			return t;
		}, every:function (a, f, o) {
			if (typeof a == "string") {
				a = a.split("");
			}
			o = o || d.global;
			f = df.lambda(f);
			var i, n;
			if (d.isArray(a)) {
				for (i = 0, n = a.length; i < n; ++i) {
					if (!f.call(o, a[i], i, a)) {
						return false;
					}
				}
			} else {
				if (typeof a.hasNext == "function" && typeof a.next == "function") {
					for (i = 0; a.hasNext(); ) {
						if (!f.call(o, a.next(), i++, a)) {
							return false;
						}
					}
				} else {
					for (i in a) {
						if (!(i in empty)) {
							if (!f.call(o, a[i], i, a)) {
								return false;
							}
						}
					}
				}
			}
			return true;
		}, some:function (a, f, o) {
			if (typeof a == "string") {
				a = a.split("");
			}
			o = o || d.global;
			f = df.lambda(f);
			var i, n;
			if (d.isArray(a)) {
				for (i = 0, n = a.length; i < n; ++i) {
					if (f.call(o, a[i], i, a)) {
						return true;
					}
				}
			} else {
				if (typeof a.hasNext == "function" && typeof a.next == "function") {
					for (i = 0; a.hasNext(); ) {
						if (f.call(o, a.next(), i++, a)) {
							return true;
						}
					}
				} else {
					for (i in a) {
						if (!(i in empty)) {
							if (f.call(o, a[i], i, a)) {
								return true;
							}
						}
					}
				}
			}
			return false;
		}});
	})();
}
if (!dojo._hasResource["dojox.lang.functional.object"]) {
	dojo._hasResource["dojox.lang.functional.object"] = true;
	dojo.provide("dojox.lang.functional.object");
	(function () {
		var d = dojo, df = dojox.lang.functional, empty = {};
		d.mixin(df, {keys:function (obj) {
			var t = [];
			for (var i in obj) {
				if (!(i in empty)) {
					t.push(i);
				}
			}
			return t;
		}, values:function (obj) {
			var t = [];
			for (var i in obj) {
				if (!(i in empty)) {
					t.push(obj[i]);
				}
			}
			return t;
		}, filterIn:function (obj, f, o) {
			o = o || d.global;
			f = df.lambda(f);
			var t = {}, v, i;
			for (i in obj) {
				if (!(i in empty)) {
					v = obj[i];
					if (f.call(o, v, i, obj)) {
						t[i] = v;
					}
				}
			}
			return t;
		}, forIn:function (obj, f, o) {
			o = o || d.global;
			f = df.lambda(f);
			for (var i in obj) {
				if (!(i in empty)) {
					f.call(o, obj[i], i, obj);
				}
			}
			return o;
		}, mapIn:function (obj, f, o) {
			o = o || d.global;
			f = df.lambda(f);
			var t = {}, i;
			for (i in obj) {
				if (!(i in empty)) {
					t[i] = f.call(o, obj[i], i, obj);
				}
			}
			return t;
		}});
	})();
}
if (!dojo._hasResource["dojox.lang.functional"]) {
	dojo._hasResource["dojox.lang.functional"] = true;
	dojo.provide("dojox.lang.functional");
}
if (!dojo._hasResource["dojox.lang.functional.fold"]) {
	dojo._hasResource["dojox.lang.functional.fold"] = true;
	dojo.provide("dojox.lang.functional.fold");
	(function () {
		var d = dojo, df = dojox.lang.functional, empty = {};
		d.mixin(df, {foldl:function (a, f, z, o) {
			if (typeof a == "string") {
				a = a.split("");
			}
			o = o || d.global;
			f = df.lambda(f);
			var i, n;
			if (d.isArray(a)) {
				for (i = 0, n = a.length; i < n; z = f.call(o, z, a[i], i, a), ++i) {
				}
			} else {
				if (typeof a.hasNext == "function" && typeof a.next == "function") {
					for (i = 0; a.hasNext(); z = f.call(o, z, a.next(), i++, a)) {
					}
				} else {
					for (i in a) {
						if (!(i in empty)) {
							z = f.call(o, z, a[i], i, a);
						}
					}
				}
			}
			return z;
		}, foldl1:function (a, f, o) {
			if (typeof a == "string") {
				a = a.split("");
			}
			o = o || d.global;
			f = df.lambda(f);
			var z, i, n;
			if (d.isArray(a)) {
				z = a[0];
				for (i = 1, n = a.length; i < n; z = f.call(o, z, a[i], i, a), ++i) {
				}
			} else {
				if (typeof a.hasNext == "function" && typeof a.next == "function") {
					if (a.hasNext()) {
						z = a.next();
						for (i = 1; a.hasNext(); z = f.call(o, z, a.next(), i++, a)) {
						}
					}
				} else {
					var first = true;
					for (i in a) {
						if (!(i in empty)) {
							if (first) {
								z = a[i];
								first = false;
							} else {
								z = f.call(o, z, a[i], i, a);
							}
						}
					}
				}
			}
			return z;
		}, foldr:function (a, f, z, o) {
			if (typeof a == "string") {
				a = a.split("");
			}
			o = o || d.global;
			f = df.lambda(f);
			for (var i = a.length; i > 0; --i, z = f.call(o, z, a[i], i, a)) {
			}
			return z;
		}, foldr1:function (a, f, o) {
			if (typeof a == "string") {
				a = a.split("");
			}
			o = o || d.global;
			f = df.lambda(f);
			var n = a.length, z = a[n - 1], i = n - 1;
			for (; i > 0; --i, z = f.call(o, z, a[i], i, a)) {
			}
			return z;
		}, reduce:function (a, f, z) {
			return arguments.length < 3 ? df.foldl1(a, f) : df.foldl(a, f, z);
		}, reduceRight:function (a, f, z) {
			return arguments.length < 3 ? df.foldr1(a, f) : df.foldr(a, f, z);
		}, unfold:function (pr, f, g, z, o) {
			o = o || d.global;
			f = df.lambda(f);
			g = df.lambda(g);
			pr = df.lambda(pr);
			var t = [];
			for (; !pr.call(o, z); t.push(f.call(o, z)), z = g.call(o, z)) {
			}
			return t;
		}});
	})();
}
if (!dojo._hasResource["dojox.lang.functional.reversed"]) {
	dojo._hasResource["dojox.lang.functional.reversed"] = true;
	dojo.provide("dojox.lang.functional.reversed");
	(function () {
		var d = dojo, df = dojox.lang.functional;
		d.mixin(df, {filterRev:function (a, f, o) {
			if (typeof a == "string") {
				a = a.split("");
			}
			o = o || d.global;
			f = df.lambda(f);
			var t = [], v, i = a.length - 1;
			for (; i >= 0; --i) {
				v = a[i];
				if (f.call(o, v, i, a)) {
					t.push(v);
				}
			}
			return t;
		}, forEachRev:function (a, f, o) {
			if (typeof a == "string") {
				a = a.split("");
			}
			o = o || d.global;
			f = df.lambda(f);
			for (var i = a.length - 1; i >= 0; f.call(o, a[i], i, a), --i) {
			}
		}, mapRev:function (a, f, o) {
			if (typeof a == "string") {
				a = a.split("");
			}
			o = o || d.global;
			f = df.lambda(f);
			var n = a.length, t = new Array(n), i = n - 1, j = 0;
			for (; i >= 0; t[j++] = f.call(o, a[i], i, a), --i) {
			}
			return t;
		}, everyRev:function (a, f, o) {
			if (typeof a == "string") {
				a = a.split("");
			}
			o = o || d.global;
			f = df.lambda(f);
			for (var i = a.length - 1; i >= 0; --i) {
				if (!f.call(o, a[i], i, a)) {
					return false;
				}
			}
			return true;
		}, someRev:function (a, f, o) {
			if (typeof a == "string") {
				a = a.split("");
			}
			o = o || d.global;
			f = df.lambda(f);
			for (var i = a.length - 1; i >= 0; --i) {
				if (f.call(o, a[i], i, a)) {
					return true;
				}
			}
			return false;
		}});
	})();
}
if (!dojo._hasResource["dojo.colors"]) {
	dojo._hasResource["dojo.colors"] = true;
	dojo.provide("dojo.colors");
	(function () {
		var hue2rgb = function (m1, m2, h) {
			if (h < 0) {
				++h;
			}
			if (h > 1) {
				--h;
			}
			var h6 = 6 * h;
			if (h6 < 1) {
				return m1 + (m2 - m1) * h6;
			}
			if (2 * h < 1) {
				return m2;
			}
			if (3 * h < 2) {
				return m1 + (m2 - m1) * (2 / 3 - h) * 6;
			}
			return m1;
		};
		dojo.colorFromRgb = function (color, obj) {
			var m = color.toLowerCase().match(/^(rgba?|hsla?)\(([\s\.\-,%0-9]+)\)/);
			if (m) {
				var c = m[2].split(/\s*,\s*/), l = c.length, t = m[1], a;
				if ((t == "rgb" && l == 3) || (t == "rgba" && l == 4)) {
					var r = c[0];
					if (r.charAt(r.length - 1) == "%") {
						a = dojo.map(c, function (x) {
							return parseFloat(x) * 2.56;
						});
						if (l == 4) {
							a[3] = c[3];
						}
						return dojo.colorFromArray(a, obj);
					}
					return dojo.colorFromArray(c, obj);
				}
				if ((t == "hsl" && l == 3) || (t == "hsla" && l == 4)) {
					var H = ((parseFloat(c[0]) % 360) + 360) % 360 / 360, S = parseFloat(c[1]) / 100, L = parseFloat(c[2]) / 100, m2 = L <= 0.5 ? L * (S + 1) : L + S - L * S, m1 = 2 * L - m2;
					a = [hue2rgb(m1, m2, H + 1 / 3) * 256, hue2rgb(m1, m2, H) * 256, hue2rgb(m1, m2, H - 1 / 3) * 256, 1];
					if (l == 4) {
						a[3] = c[3];
					}
					return dojo.colorFromArray(a, obj);
				}
			}
			return null;
		};
		var confine = function (c, low, high) {
			c = Number(c);
			return isNaN(c) ? high : c < low ? low : c > high ? high : c;
		};
		dojo.Color.prototype.sanitize = function () {
			var t = this;
			t.r = Math.round(confine(t.r, 0, 255));
			t.g = Math.round(confine(t.g, 0, 255));
			t.b = Math.round(confine(t.b, 0, 255));
			t.a = confine(t.a, 0, 1);
			return this;
		};
	})();
	dojo.colors.makeGrey = function (g, a) {
		return dojo.colorFromArray([g, g, g, a]);
	};
	dojo.mixin(dojo.Color.named, {aliceblue:[240, 248, 255], antiquewhite:[250, 235, 215], aquamarine:[127, 255, 212], azure:[240, 255, 255], beige:[245, 245, 220], bisque:[255, 228, 196], blanchedalmond:[255, 235, 205], blueviolet:[138, 43, 226], brown:[165, 42, 42], burlywood:[222, 184, 135], cadetblue:[95, 158, 160], chartreuse:[127, 255, 0], chocolate:[210, 105, 30], coral:[255, 127, 80], cornflowerblue:[100, 149, 237], cornsilk:[255, 248, 220], crimson:[220, 20, 60], cyan:[0, 255, 255], darkblue:[0, 0, 139], darkcyan:[0, 139, 139], darkgoldenrod:[184, 134, 11], darkgray:[169, 169, 169], darkgreen:[0, 100, 0], darkgrey:[169, 169, 169], darkkhaki:[189, 183, 107], darkmagenta:[139, 0, 139], darkolivegreen:[85, 107, 47], darkorange:[255, 140, 0], darkorchid:[153, 50, 204], darkred:[139, 0, 0], darksalmon:[233, 150, 122], darkseagreen:[143, 188, 143], darkslateblue:[72, 61, 139], darkslategray:[47, 79, 79], darkslategrey:[47, 79, 79], darkturquoise:[0, 206, 209], darkviolet:[148, 0, 211], deeppink:[255, 20, 147], deepskyblue:[0, 191, 255], dimgray:[105, 105, 105], dimgrey:[105, 105, 105], dodgerblue:[30, 144, 255], firebrick:[178, 34, 34], floralwhite:[255, 250, 240], forestgreen:[34, 139, 34], gainsboro:[220, 220, 220], ghostwhite:[248, 248, 255], gold:[255, 215, 0], goldenrod:[218, 165, 32], greenyellow:[173, 255, 47], grey:[128, 128, 128], honeydew:[240, 255, 240], hotpink:[255, 105, 180], indianred:[205, 92, 92], indigo:[75, 0, 130], ivory:[255, 255, 240], khaki:[240, 230, 140], lavender:[230, 230, 250], lavenderblush:[255, 240, 245], lawngreen:[124, 252, 0], lemonchiffon:[255, 250, 205], lightblue:[173, 216, 230], lightcoral:[240, 128, 128], lightcyan:[224, 255, 255], lightgoldenrodyellow:[250, 250, 210], lightgray:[211, 211, 211], lightgreen:[144, 238, 144], lightgrey:[211, 211, 211], lightpink:[255, 182, 193], lightsalmon:[255, 160, 122], lightseagreen:[32, 178, 170], lightskyblue:[135, 206, 250], lightslategray:[119, 136, 153], lightslategrey:[119, 136, 153], lightsteelblue:[176, 196, 222], lightyellow:[255, 255, 224], limegreen:[50, 205, 50], linen:[250, 240, 230], magenta:[255, 0, 255], mediumaquamarine:[102, 205, 170], mediumblue:[0, 0, 205], mediumorchid:[186, 85, 211], mediumpurple:[147, 112, 219], mediumseagreen:[60, 179, 113], mediumslateblue:[123, 104, 238], mediumspringgreen:[0, 250, 154], mediumturquoise:[72, 209, 204], mediumvioletred:[199, 21, 133], midnightblue:[25, 25, 112], mintcream:[245, 255, 250], mistyrose:[255, 228, 225], moccasin:[255, 228, 181], navajowhite:[255, 222, 173], oldlace:[253, 245, 230], olivedrab:[107, 142, 35], orange:[255, 165, 0], orangered:[255, 69, 0], orchid:[218, 112, 214], palegoldenrod:[238, 232, 170], palegreen:[152, 251, 152], paleturquoise:[175, 238, 238], palevioletred:[219, 112, 147], papayawhip:[255, 239, 213], peachpuff:[255, 218, 185], peru:[205, 133, 63], pink:[255, 192, 203], plum:[221, 160, 221], powderblue:[176, 224, 230], rosybrown:[188, 143, 143], royalblue:[65, 105, 225], saddlebrown:[139, 69, 19], salmon:[250, 128, 114], sandybrown:[244, 164, 96], seagreen:[46, 139, 87], seashell:[255, 245, 238], sienna:[160, 82, 45], skyblue:[135, 206, 235], slateblue:[106, 90, 205], slategray:[112, 128, 144], slategrey:[112, 128, 144], snow:[255, 250, 250], springgreen:[0, 255, 127], steelblue:[70, 130, 180], tan:[210, 180, 140], thistle:[216, 191, 216], tomato:[255, 99, 71], transparent:[0, 0, 0, 0], turquoise:[64, 224, 208], violet:[238, 130, 238], wheat:[245, 222, 179], whitesmoke:[245, 245, 245], yellowgreen:[154, 205, 50]});
}
if (!dojo._hasResource["dojox.color._base"]) {
	dojo._hasResource["dojox.color._base"] = true;
	dojo.provide("dojox.color._base");
	dojox.color.Color = dojo.Color;
	dojox.color.blend = dojo.blendColors;
	dojox.color.fromRgb = dojo.colorFromRgb;
	dojox.color.fromHex = dojo.colorFromHex;
	dojox.color.fromArray = dojo.colorFromArray;
	dojox.color.fromString = dojo.colorFromString;
	dojox.color.greyscale = dojo.colors.makeGrey;
	dojo.mixin(dojox.color, {fromCmy:function (cyan, magenta, yellow) {
		if (dojo.isArray(cyan)) {
			magenta = cyan[1], yellow = cyan[2], cyan = cyan[0];
		} else {
			if (dojo.isObject(cyan)) {
				magenta = cyan.m, yellow = cyan.y, cyan = cyan.c;
			}
		}
		cyan /= 100, magenta /= 100, yellow /= 100;
		var r = 1 - cyan, g = 1 - magenta, b = 1 - yellow;
		return new dojox.color.Color({r:Math.round(r * 255), g:Math.round(g * 255), b:Math.round(b * 255)});
	}, fromCmyk:function (cyan, magenta, yellow, black) {
		if (dojo.isArray(cyan)) {
			magenta = cyan[1], yellow = cyan[2], black = cyan[3], cyan = cyan[0];
		} else {
			if (dojo.isObject(cyan)) {
				magenta = cyan.m, yellow = cyan.y, black = cyan.b, cyan = cyan.c;
			}
		}
		cyan /= 100, magenta /= 100, yellow /= 100, black /= 100;
		var r, g, b;
		r = 1 - Math.min(1, cyan * (1 - black) + black);
		g = 1 - Math.min(1, magenta * (1 - black) + black);
		b = 1 - Math.min(1, yellow * (1 - black) + black);
		return new dojox.color.Color({r:Math.round(r * 255), g:Math.round(g * 255), b:Math.round(b * 255)});
	}, fromHsl:function (hue, saturation, luminosity) {
		if (dojo.isArray(hue)) {
			saturation = hue[1], luminosity = hue[2], hue = hue[0];
		} else {
			if (dojo.isObject(hue)) {
				saturation = hue.s, luminosity = hue.l, hue = hue.h;
			}
		}
		saturation /= 100;
		luminosity /= 100;
		while (hue < 0) {
			hue += 360;
		}
		while (hue >= 360) {
			hue -= 360;
		}
		var r, g, b;
		if (hue < 120) {
			r = (120 - hue) / 60, g = hue / 60, b = 0;
		} else {
			if (hue < 240) {
				r = 0, g = (240 - hue) / 60, b = (hue - 120) / 60;
			} else {
				r = (hue - 240) / 60, g = 0, b = (360 - hue) / 60;
			}
		}
		r = 2 * saturation * Math.min(r, 1) + (1 - saturation);
		g = 2 * saturation * Math.min(g, 1) + (1 - saturation);
		b = 2 * saturation * Math.min(b, 1) + (1 - saturation);
		if (luminosity < 0.5) {
			r *= luminosity, g *= luminosity, b *= luminosity;
		} else {
			r = (1 - luminosity) * r + 2 * luminosity - 1;
			g = (1 - luminosity) * g + 2 * luminosity - 1;
			b = (1 - luminosity) * b + 2 * luminosity - 1;
		}
		return new dojox.color.Color({r:Math.round(r * 255), g:Math.round(g * 255), b:Math.round(b * 255)});
	}, fromHsv:function (hue, saturation, value) {
		if (dojo.isArray(hue)) {
			saturation = hue[1], value = hue[2], hue = hue[0];
		} else {
			if (dojo.isObject(hue)) {
				saturation = hue.s, value = hue.v, hue = hue.h;
			}
		}
		if (hue == 360) {
			hue = 0;
		}
		saturation /= 100;
		value /= 100;
		var r, g, b;
		if (saturation == 0) {
			r = value, b = value, g = value;
		} else {
			var hTemp = hue / 60, i = Math.floor(hTemp), f = hTemp - i;
			var p = value * (1 - saturation);
			var q = value * (1 - (saturation * f));
			var t = value * (1 - (saturation * (1 - f)));
			switch (i) {
			  case 0:
				r = value, g = t, b = p;
				break;
			  case 1:
				r = q, g = value, b = p;
				break;
			  case 2:
				r = p, g = value, b = t;
				break;
			  case 3:
				r = p, g = q, b = value;
				break;
			  case 4:
				r = t, g = p, b = value;
				break;
			  case 5:
				r = value, g = p, b = q;
				break;
			}
		}
		return new dojox.color.Color({r:Math.round(r * 255), g:Math.round(g * 255), b:Math.round(b * 255)});
	}});
	dojo.extend(dojox.color.Color, {toCmy:function () {
		var cyan = 1 - (this.r / 255), magenta = 1 - (this.g / 255), yellow = 1 - (this.b / 255);
		return {c:Math.round(cyan * 100), m:Math.round(magenta * 100), y:Math.round(yellow * 100)};
	}, toCmyk:function () {
		var cyan, magenta, yellow, black;
		var r = this.r / 255, g = this.g / 255, b = this.b / 255;
		black = Math.min(1 - r, 1 - g, 1 - b);
		cyan = (1 - r - black) / (1 - black);
		magenta = (1 - g - black) / (1 - black);
		yellow = (1 - b - black) / (1 - black);
		return {c:Math.round(cyan * 100), m:Math.round(magenta * 100), y:Math.round(yellow * 100), b:Math.round(black * 100)};
	}, toHsl:function () {
		var r = this.r / 255, g = this.g / 255, b = this.b / 255;
		var min = Math.min(r, b, g), max = Math.max(r, g, b);
		var delta = max - min;
		var h = 0, s = 0, l = (min + max) / 2;
		if (l > 0 && l < 1) {
			s = delta / ((l < 0.5) ? (2 * l) : (2 - 2 * l));
		}
		if (delta > 0) {
			if (max == r && max != g) {
				h += (g - b) / delta;
			}
			if (max == g && max != b) {
				h += (2 + (b - r) / delta);
			}
			if (max == b && max != r) {
				h += (4 + (r - g) / delta);
			}
			h *= 60;
		}
		return {h:h, s:Math.round(s * 100), l:Math.round(l * 100)};
	}, toHsv:function () {
		var r = this.r / 255, g = this.g / 255, b = this.b / 255;
		var min = Math.min(r, b, g), max = Math.max(r, g, b);
		var delta = max - min;
		var h = null, s = (max == 0) ? 0 : (delta / max);
		if (s == 0) {
			h = 0;
		} else {
			if (r == max) {
				h = 60 * (g - b) / delta;
			} else {
				if (g == max) {
					h = 120 + 60 * (b - r) / delta;
				} else {
					h = 240 + 60 * (r - g) / delta;
				}
			}
			if (h < 0) {
				h += 360;
			}
		}
		return {h:h, s:Math.round(s * 100), v:Math.round(max * 100)};
	}});
}
if (!dojo._hasResource["dojox.color"]) {
	dojo._hasResource["dojox.color"] = true;
	dojo.provide("dojox.color");
}
if (!dojo._hasResource["dojox.color.Palette"]) {
	dojo._hasResource["dojox.color.Palette"] = true;
	dojo.provide("dojox.color.Palette");
	(function () {
		var dxc = dojox.color;
		dxc.Palette = function (base) {
			this.colors = [];
			if (base instanceof dojox.color.Palette) {
				this.colors = base.colors.slice(0);
			} else {
				if (base instanceof dojox.color.Color) {
					this.colors = [null, null, base, null, null];
				} else {
					if (dojo.isArray(base)) {
						this.colors = dojo.map(base.slice(0), function (item) {
							if (dojo.isString(item)) {
								return new dojox.color.Color(item);
							}
							return item;
						});
					} else {
						if (dojo.isString(base)) {
							this.colors = [null, null, new dojox.color.Color(base), null, null];
						}
					}
				}
			}
		};
		function tRGBA(p, param, val) {
			var ret = new dojox.color.Palette();
			ret.colors = [];
			dojo.forEach(p.colors, function (item) {
				var r = (param == "dr") ? item.r + val : item.r, g = (param == "dg") ? item.g + val : item.g, b = (param == "db") ? item.b + val : item.b, a = (param == "da") ? item.a + val : item.a;
				ret.colors.push(new dojox.color.Color({r:Math.min(255, Math.max(0, r)), g:Math.min(255, Math.max(0, g)), b:Math.min(255, Math.max(0, b)), a:Math.min(1, Math.max(0, a))}));
			});
			console.log("The return colors are ", ret.colors, " from the original colors ", p.colors);
			return ret;
		}
		function tCMY(p, param, val) {
			var ret = new dojox.color.Palette();
			ret.colors = [];
			dojo.forEach(p.colors, function (item) {
				var o = item.toCmy(), c = (param == "dc") ? o.c + val : o.c, m = (param == "dm") ? o.m + val : o.m, y = (param == "dy") ? o.y + val : o.y;
				ret.colors.push(dojox.color.fromCmy(Math.min(100, Math.max(0, c)), Math.min(100, Math.max(0, m)), Math.min(100, Math.max(0, y))));
			});
			return ret;
		}
		function tCMYK(p, param, val) {
			var ret = new dojox.color.Palette();
			ret.colors = [];
			dojo.forEach(p.colors, function (item) {
				var o = item.toCmyk(), c = (param == "dc") ? o.c + val : o.c, m = (param == "dm") ? o.m + val : o.m, y = (param == "dy") ? o.y + val : o.y, k = (param == "dk") ? o.b + val : o.b;
				ret.colors.push(dojox.color.fromCmyk(Math.min(100, Math.max(0, c)), Math.min(100, Math.max(0, m)), Math.min(100, Math.max(0, y)), Math.min(100, Math.max(0, k))));
			});
			return ret;
		}
		function tHSL(p, param, val) {
			var ret = new dojox.color.Palette();
			ret.colors = [];
			dojo.forEach(p.colors, function (item) {
				var o = item.toHsl(), h = (param == "dh") ? o.h + val : o.h, s = (param == "ds") ? o.s + val : o.s, l = (param == "dl") ? o.l + val : o.l;
				ret.colors.push(dojox.color.fromHsl(h % 360, Math.min(100, Math.max(0, s)), Math.min(100, Math.max(0, l))));
			});
			return ret;
		}
		function tHSV(p, param, val) {
			var ret = new dojox.color.Palette();
			ret.colors = [];
			dojo.forEach(p.colors, function (item) {
				var o = item.toHsv(), h = (param == "dh") ? o.h + val : o.h, s = (param == "ds") ? o.s + val : o.s, v = (param == "dv") ? o.v + val : o.v;
				ret.colors.push(dojox.color.fromHsv(h % 360, Math.min(100, Math.max(0, s)), Math.min(100, Math.max(0, v))));
			});
			return ret;
		}
		function rangeDiff(val, low, high) {
			return high - ((high - val) * ((high - low) / high));
		}
		dojo.extend(dxc.Palette, {transform:function (kwArgs) {
			var fn = tRGBA;
			if (kwArgs.use) {
				var use = kwArgs.use.toLowerCase();
				if (use.indexOf("hs") == 0) {
					if (use.charAt(2) == "l") {
						fn = tHSL;
					} else {
						fn = tHSV;
					}
				} else {
					if (use.indexOf("cmy") == 0) {
						if (use.charAt(3) == "k") {
							fn = tCMYK;
						} else {
							fn = tCMY;
						}
					}
				}
			} else {
				if ("dc" in kwArgs || "dm" in kwArgs || "dy" in kwArgs) {
					if ("dk" in kwArgs) {
						fn = tCMYK;
					} else {
						fn = tCMY;
					}
				} else {
					if ("dh" in kwArgs || "ds" in kwArgs) {
						if ("dv" in kwArgs) {
							fn = tHSV;
						} else {
							fn = tHSL;
						}
					}
				}
			}
			var palette = this;
			for (var p in kwArgs) {
				if (p == "use") {
					continue;
				}
				palette = fn(palette, p, kwArgs[p]);
			}
			return palette;
		}, clone:function () {
			return new dxc.Palette(this);
		}});
		dojo.mixin(dxc.Palette, {generators:{analogous:function (args) {
			var high = args.high || 60, low = args.low || 18, base = dojo.isString(args.base) ? new dojox.color.Color(args.base) : args.base, hsv = base.toHsv();
			var h = [(hsv.h + low + 360) % 360, (hsv.h + Math.round(low / 2) + 360) % 360, hsv.h, (hsv.h - Math.round(high / 2) + 360) % 360, (hsv.h - high + 360) % 360];
			var s1 = Math.max(10, (hsv.s <= 95) ? hsv.s + 5 : (100 - (hsv.s - 95))), s2 = (hsv.s > 1) ? hsv.s - 1 : 21 - hsv.s, v1 = (hsv.v >= 92) ? hsv.v - 9 : Math.max(hsv.v + 9, 20), v2 = (hsv.v <= 90) ? Math.max(hsv.v + 5, 20) : (95 + Math.ceil((hsv.v - 90) / 2)), s = [s1, s2, hsv.s, s1, s1], v = [v1, v2, hsv.v, v1, v2];
			return new dxc.Palette(dojo.map(h, function (hue, i) {
				return dojox.color.fromHsv(hue, s[i], v[i]);
			}));
		}, monochromatic:function (args) {
			var base = dojo.isString(args.base) ? new dojox.color.Color(args.base) : args.base, hsv = base.toHsv();
			var s1 = (hsv.s - 30 > 9) ? hsv.s - 30 : hsv.s + 30, s2 = hsv.s, v1 = rangeDiff(hsv.v, 20, 100), v2 = (hsv.v - 20 > 20) ? hsv.v - 20 : hsv.v + 60, v3 = (hsv.v - 50 > 20) ? hsv.v - 50 : hsv.v + 30;
			return new dxc.Palette([dojox.color.fromHsv(hsv.h, s1, v1), dojox.color.fromHsv(hsv.h, s2, v3), base, dojox.color.fromHsv(hsv.h, s1, v3), dojox.color.fromHsv(hsv.h, s2, v2)]);
		}, triadic:function (args) {
			var base = dojo.isString(args.base) ? new dojox.color.Color(args.base) : args.base, hsv = base.toHsv();
			var h1 = (hsv.h + 57 + 360) % 360, h2 = (hsv.h - 157 + 360) % 360, s1 = (hsv.s > 20) ? hsv.s - 10 : hsv.s + 10, s2 = (hsv.s > 90) ? hsv.s - 10 : hsv.s + 10, s3 = (hsv.s > 95) ? hsv.s - 5 : hsv.s + 5, v1 = (hsv.v - 20 > 20) ? hsv.v - 20 : hsv.v + 20, v2 = (hsv.v - 30 > 20) ? hsv.v - 30 : hsv.v + 30, v3 = (hsv.v - 30 > 70) ? hsv.v - 30 : hsv.v + 30;
			return new dxc.Palette([dojox.color.fromHsv(h1, s1, hsv.v), dojox.color.fromHsv(hsv.h, s2, v2), base, dojox.color.fromHsv(h2, s2, v1), dojox.color.fromHsv(h2, s3, v3)]);
		}, complementary:function (args) {
			var base = dojo.isString(args.base) ? new dojox.color.Color(args.base) : args.base, hsv = base.toHsv();
			var h1 = ((hsv.h * 2) + 137 < 360) ? (hsv.h * 2) + 137 : Math.floor(hsv.h / 2) - 137, s1 = Math.max(hsv.s - 10, 0), s2 = rangeDiff(hsv.s, 10, 100), s3 = Math.min(100, hsv.s + 20), v1 = Math.min(100, hsv.v + 30), v2 = (hsv.v > 20) ? hsv.v - 30 : hsv.v + 30;
			return new dxc.Palette([dojox.color.fromHsv(hsv.h, s1, v1), dojox.color.fromHsv(hsv.h, s2, v2), base, dojox.color.fromHsv(h1, s3, v2), dojox.color.fromHsv(h1, hsv.s, hsv.v)]);
		}, splitComplementary:function (args) {
			var base = dojo.isString(args.base) ? new dojox.color.Color(args.base) : args.base, dangle = args.da || 30, hsv = base.toHsv();
			var baseh = ((hsv.h * 2) + 137 < 360) ? (hsv.h * 2) + 137 : Math.floor(hsv.h / 2) - 137, h1 = (baseh - dangle + 360) % 360, h2 = (baseh + dangle) % 360, s1 = Math.max(hsv.s - 10, 0), s2 = rangeDiff(hsv.s, 10, 100), s3 = Math.min(100, hsv.s + 20), v1 = Math.min(100, hsv.v + 30), v2 = (hsv.v > 20) ? hsv.v - 30 : hsv.v + 30;
			return new dxc.Palette([dojox.color.fromHsv(h1, s1, v1), dojox.color.fromHsv(h1, s2, v2), base, dojox.color.fromHsv(h2, s3, v2), dojox.color.fromHsv(h2, hsv.s, hsv.v)]);
		}, compound:function (args) {
			var base = dojo.isString(args.base) ? new dojox.color.Color(args.base) : args.base, hsv = base.toHsv();
			var h1 = ((hsv.h * 2) + 18 < 360) ? (hsv.h * 2) + 18 : Math.floor(hsv.h / 2) - 18, h2 = ((hsv.h * 2) + 120 < 360) ? (hsv.h * 2) + 120 : Math.floor(hsv.h / 2) - 120, h3 = ((hsv.h * 2) + 99 < 360) ? (hsv.h * 2) + 99 : Math.floor(hsv.h / 2) - 99, s1 = (hsv.s - 40 > 10) ? hsv.s - 40 : hsv.s + 40, s2 = (hsv.s - 10 > 80) ? hsv.s - 10 : hsv.s + 10, s3 = (hsv.s - 25 > 10) ? hsv.s - 25 : hsv.s + 25, v1 = (hsv.v - 40 > 10) ? hsv.v - 40 : hsv.v + 40, v2 = (hsv.v - 20 > 80) ? hsv.v - 20 : hsv.v + 20, v3 = Math.max(hsv.v, 20);
			return new dxc.Palette([dojox.color.fromHsv(h1, s1, v1), dojox.color.fromHsv(h1, s2, v2), base, dojox.color.fromHsv(h2, s3, v3), dojox.color.fromHsv(h3, s2, v2)]);
		}, shades:function (args) {
			var base = dojo.isString(args.base) ? new dojox.color.Color(args.base) : args.base, hsv = base.toHsv();
			var s = (hsv.s == 100 && hsv.v == 0) ? 0 : hsv.s, v1 = (hsv.v - 50 > 20) ? hsv.v - 50 : hsv.v + 30, v2 = (hsv.v - 25 >= 20) ? hsv.v - 25 : hsv.v + 55, v3 = (hsv.v - 75 >= 20) ? hsv.v - 75 : hsv.v + 5, v4 = Math.max(hsv.v - 10, 20);
			return new dxc.Palette([new dojox.color.fromHsv(hsv.h, s, v1), new dojox.color.fromHsv(hsv.h, s, v2), base, new dojox.color.fromHsv(hsv.h, s, v3), new dojox.color.fromHsv(hsv.h, s, v4)]);
		}}, generate:function (base, type) {
			if (dojo.isFunction(type)) {
				return type({base:base});
			} else {
				if (dxc.Palette.generators[type]) {
					return dxc.Palette.generators[type]({base:base});
				}
			}
			throw new Error("dojox.color.Palette.generate: the specified generator ('" + type + "') does not exist.");
		}});
	})();
}
if (!dojo._hasResource["dojox.charting.Theme"]) {
	dojo._hasResource["dojox.charting.Theme"] = true;
	dojo.provide("dojox.charting.Theme");
	(function () {
		var dxc = dojox.charting;
		dxc.Theme = function (kwArgs) {
			kwArgs = kwArgs || {};
			var def = dxc.Theme._def;
			dojo.forEach(["chart", "plotarea", "axis", "series", "marker"], function (n) {
				this[n] = dojo.delegate(def[n], kwArgs[n] || {});
			}, this);
			this.markers = dojo.delegate(dxc.Theme.Markers, kwArgs.markers || {});
			this.colors = [];
			this.antiAlias = ("antiAlias" in kwArgs) ? kwArgs.antiAlias : true;
			this.assignColors = ("assignColors" in kwArgs) ? kwArgs.assignColors : true;
			this.assignMarkers = ("assignMarkers" in kwArgs) ? kwArgs.assignMarkers : true;
			kwArgs.colors = kwArgs.colors || def.colors;
			dojo.forEach(kwArgs.colors, function (item) {
				this.colors.push(item);
			}, this);
			this._current = {color:0, marker:0};
			this._markers = [];
			this._buildMarkerArray();
		};
		dxc.Theme.Markers = {CIRCLE:"m-3,0 c0,-4 6,-4 6,0 m-6,0 c0,4 6,4 6,0", SQUARE:"m-3,-3 l0,6 6,0 0,-6 z", DIAMOND:"m0,-3 l3,3 -3,3 -3,-3 z", CROSS:"m0,-3 l0,6 m-3,-3 l6,0", X:"m-3,-3 l6,6 m0,-6 l-6,6", TRIANGLE:"m-3,3 l3,-6 3,6 z", TRIANGLE_INVERTED:"m-3,-3 l3,6 3,-6 z"};
		dxc.Theme._def = {chart:{stroke:null, fill:"white"}, plotarea:{stroke:null, fill:"white"}, axis:{stroke:{color:"#333", width:1}, majorTick:{color:"#666", width:1, length:6, position:"center"}, minorTick:{color:"#666", width:0.8, length:3, position:"center"}, microTick:{color:"#666", width:0.5, length:1, position:"center"}, font:"normal normal normal 7pt Tahoma", fontColor:"#333"}, series:{outline:{width:0.1, color:"#ccc"}, stroke:{width:1.5, color:"#333"}, fill:"#ccc", font:"normal normal normal 7pt Tahoma", fontColor:"#000"}, marker:{stroke:{width:1}, fill:"#333", font:"normal normal normal 7pt Tahoma", fontColor:"#000"}, colors:["#54544c", "#858e94", "#6e767a", "#948585", "#474747"]};
		dojo.extend(dxc.Theme, {defineColors:function (obj) {
			var kwArgs = obj || {};
			var c = [], n = kwArgs.num || 5;
			if (kwArgs.colors) {
				var l = kwArgs.colors.length;
				for (var i = 0; i < n; i++) {
					c.push(kwArgs.colors[i % l]);
				}
				this.colors = c;
			} else {
				if (kwArgs.hue) {
					var s = kwArgs.saturation || 100;
					var st = kwArgs.low || 30;
					var end = kwArgs.high || 90;
					var l = (end + st) / 2;
					this.colors = dojox.color.Palette.generate(dojox.color.fromHsv(kwArgs.hue, s, l), "monochromatic").colors;
				} else {
					if (kwArgs.generator) {
						this.colors = dojox.color.Palette.generate(kwArgs.base, kwArgs.generator).colors;
					}
				}
			}
		}, _buildMarkerArray:function () {
			this._markers = [];
			for (var p in this.markers) {
				this._markers.push(this.markers[p]);
			}
			this._current.marker = 0;
		}, _clone:function () {
			return new dxc.Theme({chart:this.chart, plotarea:this.plotarea, axis:this.axis, series:this.series, marker:this.marker, antiAlias:this.antiAlias, assignColors:this.assignColors, assignMarkers:this.assigneMarkers, colors:dojo.delegate(this.colors)});
		}, addMarker:function (name, segment) {
			this.markers[name] = segment;
			this._buildMarkerArray();
		}, setMarkers:function (obj) {
			this.markers = obj;
			this._buildMarkerArray();
		}, next:function (type) {
			if (type == "marker") {
				return this._markers[this._current.marker++ % this._markers.length];
			} else {
				return this.colors[this._current.color++ % this.colors.length];
			}
		}, clear:function () {
			this._current = {color:0, marker:0};
		}});
	})();
}
if (!dojo._hasResource["dojox.charting.Element"]) {
	dojo._hasResource["dojox.charting.Element"] = true;
	dojo.provide("dojox.charting.Element");
	dojo.declare("dojox.charting.Element", null, {constructor:function (chart) {
		this.chart = chart;
		this.group = null;
		this.htmlElements = [];
		this.dirty = true;
	}, createGroup:function (creator) {
		if (!creator) {
			creator = this.chart.surface;
		}
		if (!this.group) {
			this.group = creator.createGroup();
		}
		return this;
	}, purgeGroup:function () {
		this.destroyHtmlElements();
		if (this.group) {
			this.group.clear();
			this.group.removeShape();
			this.group = null;
		}
		this.dirty = true;
		return this;
	}, cleanGroup:function (creator) {
		this.destroyHtmlElements();
		if (!creator) {
			creator = this.chart.surface;
		}
		if (this.group) {
			this.group.clear();
		} else {
			this.group = creator.createGroup();
		}
		this.dirty = true;
		return this;
	}, destroyHtmlElements:function () {
		if (this.htmlElements.length) {
			dojo.forEach(this.htmlElements, dojo.destroy);
			this.htmlElements = [];
		}
	}, destroy:function () {
		this.purgeGroup();
	}});
}
if (!dojo._hasResource["dojox.charting.Series"]) {
	dojo._hasResource["dojox.charting.Series"] = true;
	dojo.provide("dojox.charting.Series");
	dojo.declare("dojox.charting.Series", dojox.charting.Element, {constructor:function (chart, data, kwArgs) {
		dojo.mixin(this, kwArgs);
		if (typeof this.plot != "string") {
			this.plot = "default";
		}
		this.data = data;
		this.dirty = true;
		this.clear();
	}, clear:function () {
		this.dyn = {};
	}});
}
if (!dojo._hasResource["dojox.charting.scaler.common"]) {
	dojo._hasResource["dojox.charting.scaler.common"] = true;
	dojo.provide("dojox.charting.scaler.common");
	(function () {
		var eq = function (a, b) {
			return Math.abs(a - b) <= 0.000001 * (Math.abs(a) + Math.abs(b));
		};
		dojo.mixin(dojox.charting.scaler.common, {findString:function (val, text) {
			val = val.toLowerCase();
			for (var i = 0; i < text.length; ++i) {
				if (val == text[i]) {
					return true;
				}
			}
			return false;
		}, getNumericLabel:function (number, precision, kwArgs) {
			var def = kwArgs.fixed ? number.toFixed(precision < 0 ? -precision : 0) : number.toString();
			if (kwArgs.labelFunc) {
				var r = kwArgs.labelFunc(def, number, precision);
				if (r) {
					return r;
				}
			}
			if (kwArgs.labels) {
				var l = kwArgs.labels, lo = 0, hi = l.length;
				while (lo < hi) {
					var mid = Math.floor((lo + hi) / 2), val = l[mid].value;
					if (val < number) {
						lo = mid + 1;
					} else {
						hi = mid;
					}
				}
				if (lo < l.length && eq(l[lo].value, number)) {
					return l[lo].text;
				}
				--lo;
				if (lo >= 0 && lo < l.length && eq(l[lo].value, number)) {
					return l[lo].text;
				}
				lo += 2;
				if (lo < l.length && eq(l[lo].value, number)) {
					return l[lo].text;
				}
			}
			return def;
		}});
	})();
}
if (!dojo._hasResource["dojox.charting.scaler.linear"]) {
	dojo._hasResource["dojox.charting.scaler.linear"] = true;
	dojo.provide("dojox.charting.scaler.linear");
	(function () {
		var deltaLimit = 3, dc = dojox.charting, dcs = dc.scaler, dcsc = dcs.common, findString = dcsc.findString, getLabel = dcsc.getNumericLabel;
		var calcTicks = function (min, max, kwArgs, majorTick, minorTick, microTick, span) {
			kwArgs = dojo.delegate(kwArgs);
			if (!majorTick) {
				if (kwArgs.fixUpper == "major") {
					kwArgs.fixUpper = "minor";
				}
				if (kwArgs.fixLower == "major") {
					kwArgs.fixLower = "minor";
				}
			}
			if (!minorTick) {
				if (kwArgs.fixUpper == "minor") {
					kwArgs.fixUpper = "micro";
				}
				if (kwArgs.fixLower == "minor") {
					kwArgs.fixLower = "micro";
				}
			}
			if (!microTick) {
				if (kwArgs.fixUpper == "micro") {
					kwArgs.fixUpper = "none";
				}
				if (kwArgs.fixLower == "micro") {
					kwArgs.fixLower = "none";
				}
			}
			var lowerBound = findString(kwArgs.fixLower, ["major"]) ? Math.floor(kwArgs.min / majorTick) * majorTick : findString(kwArgs.fixLower, ["minor"]) ? Math.floor(kwArgs.min / minorTick) * minorTick : findString(kwArgs.fixLower, ["micro"]) ? Math.floor(kwArgs.min / microTick) * microTick : kwArgs.min, upperBound = findString(kwArgs.fixUpper, ["major"]) ? Math.ceil(kwArgs.max / majorTick) * majorTick : findString(kwArgs.fixUpper, ["minor"]) ? Math.ceil(kwArgs.max / minorTick) * minorTick : findString(kwArgs.fixUpper, ["micro"]) ? Math.ceil(kwArgs.max / microTick) * microTick : kwArgs.max;
			if (kwArgs.useMin) {
				min = lowerBound;
			}
			if (kwArgs.useMax) {
				max = upperBound;
			}
			var majorStart = (!majorTick || kwArgs.useMin && findString(kwArgs.fixLower, ["major"])) ? min : Math.ceil(min / majorTick) * majorTick, minorStart = (!minorTick || kwArgs.useMin && findString(kwArgs.fixLower, ["major", "minor"])) ? min : Math.ceil(min / minorTick) * minorTick, microStart = (!microTick || kwArgs.useMin && findString(kwArgs.fixLower, ["major", "minor", "micro"])) ? min : Math.ceil(min / microTick) * microTick, majorCount = !majorTick ? 0 : (kwArgs.useMax && findString(kwArgs.fixUpper, ["major"]) ? Math.round((max - majorStart) / majorTick) : Math.floor((max - majorStart) / majorTick)) + 1, minorCount = !minorTick ? 0 : (kwArgs.useMax && findString(kwArgs.fixUpper, ["major", "minor"]) ? Math.round((max - minorStart) / minorTick) : Math.floor((max - minorStart) / minorTick)) + 1, microCount = !microTick ? 0 : (kwArgs.useMax && findString(kwArgs.fixUpper, ["major", "minor", "micro"]) ? Math.round((max - microStart) / microTick) : Math.floor((max - microStart) / microTick)) + 1, minorPerMajor = minorTick ? Math.round(majorTick / minorTick) : 0, microPerMinor = microTick ? Math.round(minorTick / microTick) : 0, majorPrecision = majorTick ? Math.floor(Math.log(majorTick) / Math.LN10) : 0, minorPrecision = minorTick ? Math.floor(Math.log(minorTick) / Math.LN10) : 0, scale = span / (max - min);
			if (!isFinite(scale)) {
				scale = 1;
			}
			return {bounds:{lower:lowerBound, upper:upperBound, from:min, to:max, scale:scale, span:span}, major:{tick:majorTick, start:majorStart, count:majorCount, prec:majorPrecision}, minor:{tick:minorTick, start:minorStart, count:minorCount, prec:minorPrecision}, micro:{tick:microTick, start:microStart, count:microCount, prec:0}, minorPerMajor:minorPerMajor, microPerMinor:microPerMinor, scaler:dcs.linear};
		};
		dojo.mixin(dojox.charting.scaler.linear, {buildScaler:function (min, max, span, kwArgs) {
			var h = {fixUpper:"none", fixLower:"none", natural:false};
			if (kwArgs) {
				if ("fixUpper" in kwArgs) {
					h.fixUpper = String(kwArgs.fixUpper);
				}
				if ("fixLower" in kwArgs) {
					h.fixLower = String(kwArgs.fixLower);
				}
				if ("natural" in kwArgs) {
					h.natural = Boolean(kwArgs.natural);
				}
			}
			if ("min" in kwArgs) {
				min = kwArgs.min;
			}
			if ("max" in kwArgs) {
				max = kwArgs.max;
			}
			if (kwArgs.includeZero) {
				if (min > 0) {
					min = 0;
				}
				if (max < 0) {
					max = 0;
				}
			}
			h.min = min;
			h.useMin = true;
			h.max = max;
			h.useMax = true;
			if ("from" in kwArgs) {
				min = kwArgs.from;
				h.useMin = false;
			}
			if ("to" in kwArgs) {
				max = kwArgs.to;
				h.useMax = false;
			}
			if (max <= min) {
				return calcTicks(min, max, h, 0, 0, 0, span);
			}
			var mag = Math.floor(Math.log(max - min) / Math.LN10), major = kwArgs && ("majorTickStep" in kwArgs) ? kwArgs.majorTickStep : Math.pow(10, mag), minor = 0, micro = 0, ticks;
			if (kwArgs && ("minorTickStep" in kwArgs)) {
				minor = kwArgs.minorTickStep;
			} else {
				do {
					minor = major / 10;
					if (!h.natural || minor > 0.9) {
						ticks = calcTicks(min, max, h, major, minor, 0, span);
						if (ticks.bounds.scale * ticks.minor.tick > deltaLimit) {
							break;
						}
					}
					minor = major / 5;
					if (!h.natural || minor > 0.9) {
						ticks = calcTicks(min, max, h, major, minor, 0, span);
						if (ticks.bounds.scale * ticks.minor.tick > deltaLimit) {
							break;
						}
					}
					minor = major / 2;
					if (!h.natural || minor > 0.9) {
						ticks = calcTicks(min, max, h, major, minor, 0, span);
						if (ticks.bounds.scale * ticks.minor.tick > deltaLimit) {
							break;
						}
					}
					return calcTicks(min, max, h, major, 0, 0, span);
				} while (false);
			}
			if (kwArgs && ("microTickStep" in kwArgs)) {
				micro = kwArgs.microTickStep;
				ticks = calcTicks(min, max, h, major, minor, micro, span);
			} else {
				do {
					micro = minor / 10;
					if (!h.natural || micro > 0.9) {
						ticks = calcTicks(min, max, h, major, minor, micro, span);
						if (ticks.bounds.scale * ticks.micro.tick > deltaLimit) {
							break;
						}
					}
					micro = minor / 5;
					if (!h.natural || micro > 0.9) {
						ticks = calcTicks(min, max, h, major, minor, micro, span);
						if (ticks.bounds.scale * ticks.micro.tick > deltaLimit) {
							break;
						}
					}
					micro = minor / 2;
					if (!h.natural || micro > 0.9) {
						ticks = calcTicks(min, max, h, major, minor, micro, span);
						if (ticks.bounds.scale * ticks.micro.tick > deltaLimit) {
							break;
						}
					}
					micro = 0;
				} while (false);
			}
			return micro ? ticks : calcTicks(min, max, h, major, minor, 0, span);
		}, buildTicks:function (scaler, kwArgs) {
			var step, next, tick, nextMajor = scaler.major.start, nextMinor = scaler.minor.start, nextMicro = scaler.micro.start;
			if (kwArgs.microTicks && scaler.micro.tick) {
				step = scaler.micro.tick, next = nextMicro;
			} else {
				if (kwArgs.minorTicks && scaler.minor.tick) {
					step = scaler.minor.tick, next = nextMinor;
				} else {
					if (scaler.major.tick) {
						step = scaler.major.tick, next = nextMajor;
					} else {
						return null;
					}
				}
			}
			var revScale = 1 / scaler.bounds.scale;
			if (scaler.bounds.to <= scaler.bounds.from || isNaN(revScale) || !isFinite(revScale) || step <= 0 || isNaN(step) || !isFinite(step)) {
				return null;
			}
			var majorTicks = [], minorTicks = [], microTicks = [];
			while (next <= scaler.bounds.to + revScale) {
				if (Math.abs(nextMajor - next) < step / 2) {
					tick = {value:nextMajor};
					if (kwArgs.majorLabels) {
						tick.label = getLabel(nextMajor, scaler.major.prec, kwArgs);
					}
					majorTicks.push(tick);
					nextMajor += scaler.major.tick;
					nextMinor += scaler.minor.tick;
					nextMicro += scaler.micro.tick;
				} else {
					if (Math.abs(nextMinor - next) < step / 2) {
						if (kwArgs.minorTicks) {
							tick = {value:nextMinor};
							if (kwArgs.minorLabels && (scaler.minMinorStep <= scaler.minor.tick * scaler.bounds.scale)) {
								tick.label = getLabel(nextMinor, scaler.minor.prec, kwArgs);
							}
							minorTicks.push(tick);
						}
						nextMinor += scaler.minor.tick;
						nextMicro += scaler.micro.tick;
					} else {
						if (kwArgs.microTicks) {
							microTicks.push({value:nextMicro});
						}
						nextMicro += scaler.micro.tick;
					}
				}
				next += step;
			}
			return {major:majorTicks, minor:minorTicks, micro:microTicks};
		}, getTransformerFromModel:function (scaler) {
			var offset = scaler.bounds.from, scale = scaler.bounds.scale;
			return function (x) {
				return (x - offset) * scale;
			};
		}, getTransformerFromPlot:function (scaler) {
			var offset = scaler.bounds.from, scale = scaler.bounds.scale;
			return function (x) {
				return x / scale + offset;
			};
		}});
	})();
}
if (!dojo._hasResource["dojox.charting.axis2d.common"]) {
	dojo._hasResource["dojox.charting.axis2d.common"] = true;
	dojo.provide("dojox.charting.axis2d.common");
	(function () {
		var g = dojox.gfx;
		var clearNode = function (s) {
			s.marginLeft = "0px";
			s.marginTop = "0px";
			s.marginRight = "0px";
			s.marginBottom = "0px";
			s.paddingLeft = "0px";
			s.paddingTop = "0px";
			s.paddingRight = "0px";
			s.paddingBottom = "0px";
			s.borderLeftWidth = "0px";
			s.borderTopWidth = "0px";
			s.borderRightWidth = "0px";
			s.borderBottomWidth = "0px";
		};
		var getBoxWidth = function (n) {
			if (n["getBoundingClientRect"]) {
				var bcr = n.getBoundingClientRect();
				return bcr.width || (bcr.right - bcr.left);
			} else {
				return dojo.marginBox(n).w;
			}
		};
		dojo.mixin(dojox.charting.axis2d.common, {createText:{gfx:function (chart, creator, x, y, align, text, font, fontColor) {
			return creator.createText({x:x, y:y, text:text, align:align}).setFont(font).setFill(fontColor);
		}, html:function (chart, creator, x, y, align, text, font, fontColor, labelWidth) {
			var p = dojo.doc.createElement("div"), s = p.style, boxWidth;
			clearNode(s);
			s.font = font;
			p.innerHTML = String(text).replace(/\s/g, "&nbsp;");
			s.color = fontColor;
			s.position = "absolute";
			s.left = "-10000px";
			dojo.body().appendChild(p);
			var size = g.normalizedLength(g.splitFontString(font).size);
			if (!labelWidth) {
				boxWidth = getBoxWidth(p);
			}
			dojo.body().removeChild(p);
			s.position = "relative";
			if (labelWidth) {
				s.width = labelWidth + "px";
				switch (align) {
				  case "middle":
					s.textAlign = "center";
					s.left = (x - labelWidth / 2) + "px";
					break;
				  case "end":
					s.textAlign = "right";
					s.left = (x - labelWidth) + "px";
					break;
				  default:
					s.left = x + "px";
					s.textAlign = "left";
					break;
				}
			} else {
				switch (align) {
				  case "middle":
					s.left = Math.floor(x - boxWidth / 2) + "px";
					break;
				  case "end":
					s.left = Math.floor(x - boxWidth) + "px";
					break;
				  default:
					s.left = Math.floor(x) + "px";
					break;
				}
			}
			s.top = Math.floor(y - size) + "px";
			var wrap = dojo.doc.createElement("div"), w = wrap.style;
			clearNode(w);
			w.width = "0px";
			w.height = "0px";
			wrap.appendChild(p);
			chart.node.insertBefore(wrap, chart.node.firstChild);
			return wrap;
		}}});
	})();
}
if (!dojo._hasResource["dojox.charting.axis2d.Base"]) {
	dojo._hasResource["dojox.charting.axis2d.Base"] = true;
	dojo.provide("dojox.charting.axis2d.Base");
	dojo.declare("dojox.charting.axis2d.Base", dojox.charting.Element, {constructor:function (chart, kwArgs) {
		this.vertical = kwArgs && kwArgs.vertical;
	}, clear:function () {
		return this;
	}, initialized:function () {
		return false;
	}, calculate:function (min, max, span) {
		return this;
	}, getScaler:function () {
		return null;
	}, getTicks:function () {
		return null;
	}, getOffsets:function () {
		return {l:0, r:0, t:0, b:0};
	}, render:function (dim, offsets) {
		return this;
	}});
}
if (!dojo._hasResource["dojox.lang.utils"]) {
	dojo._hasResource["dojox.lang.utils"] = true;
	dojo.provide("dojox.lang.utils");
	(function () {
		var empty = {}, du = dojox.lang.utils;
		var clone = function (o) {
			if (dojo.isArray(o)) {
				return dojo._toArray(o);
			}
			if (!dojo.isObject(o) || dojo.isFunction(o)) {
				return o;
			}
			return dojo.delegate(o);
		};
		dojo.mixin(du, {coerceType:function (target, source) {
			switch (typeof target) {
			  case "number":
				return Number(eval("(" + source + ")"));
			  case "string":
				return String(source);
			  case "boolean":
				return Boolean(eval("(" + source + ")"));
			}
			return eval("(" + source + ")");
		}, updateWithObject:function (target, source, conv) {
			if (!source) {
				return target;
			}
			for (var x in target) {
				if (x in source && !(x in empty)) {
					var t = target[x];
					if (t && typeof t == "object") {
						du.updateWithObject(t, source[x], conv);
					} else {
						target[x] = conv ? du.coerceType(t, source[x]) : clone(source[x]);
					}
				}
			}
			return target;
		}, updateWithPattern:function (target, source, pattern, conv) {
			if (!source || !pattern) {
				return target;
			}
			for (var x in pattern) {
				if (x in source && !(x in empty)) {
					target[x] = conv ? du.coerceType(pattern[x], source[x]) : clone(source[x]);
				}
			}
			return target;
		}});
	})();
}
if (!dojo._hasResource["dojox.charting.axis2d.Default"]) {
	dojo._hasResource["dojox.charting.axis2d.Default"] = true;
	dojo.provide("dojox.charting.axis2d.Default");
	(function () {
		var dc = dojox.charting, df = dojox.lang.functional, du = dojox.lang.utils, g = dojox.gfx, lin = dc.scaler.linear, labelGap = 4;
		dojo.declare("dojox.charting.axis2d.Default", dojox.charting.axis2d.Base, {defaultParams:{vertical:false, fixUpper:"none", fixLower:"none", natural:false, leftBottom:true, includeZero:false, fixed:true, majorLabels:true, minorTicks:true, minorLabels:true, microTicks:false, htmlLabels:true}, optionalParams:{min:0, max:1, from:0, to:1, majorTickStep:4, minorTickStep:2, microTickStep:1, labels:[], labelFunc:null, maxLabelSize:0, stroke:{}, majorTick:{}, minorTick:{}, microTick:{}, font:"", fontColor:""}, constructor:function (chart, kwArgs) {
			this.opt = dojo.delegate(this.defaultParams, kwArgs);
			du.updateWithPattern(this.opt, kwArgs, this.optionalParams);
		}, dependOnData:function () {
			return !("min" in this.opt) || !("max" in this.opt);
		}, clear:function () {
			delete this.scaler;
			delete this.ticks;
			this.dirty = true;
			return this;
		}, initialized:function () {
			return "scaler" in this && !(this.dirty && this.dependOnData());
		}, setWindow:function (scale, offset) {
			this.scale = scale;
			this.offset = offset;
			return this.clear();
		}, getWindowScale:function () {
			return "scale" in this ? this.scale : 1;
		}, getWindowOffset:function () {
			return "offset" in this ? this.offset : 0;
		}, _groupLabelWidth:function (labels, font) {
			if (labels[0]["text"]) {
				labels = df.map(labels, function (label) {
					return label.text;
				});
			}
			var s = labels.join("<br>");
			return dojox.gfx._base._getTextBox(s, {font:font}).w || 0;
		}, calculate:function (min, max, span, labels) {
			if (this.initialized()) {
				return this;
			}
			var o = this.opt;
			this.labels = "labels" in o ? o.labels : labels;
			this.scaler = lin.buildScaler(min, max, span, o);
			var tsb = this.scaler.bounds;
			if ("scale" in this) {
				o.from = tsb.lower + this.offset;
				o.to = (tsb.upper - tsb.lower) / this.scale + o.from;
				if (!isFinite(o.from) || isNaN(o.from) || !isFinite(o.to) || isNaN(o.to) || o.to - o.from >= tsb.upper - tsb.lower) {
					delete o.from;
					delete o.to;
					delete this.scale;
					delete this.offset;
				} else {
					if (o.from < tsb.lower) {
						o.to += tsb.lower - o.from;
						o.from = tsb.lower;
					} else {
						if (o.to > tsb.upper) {
							o.from += tsb.upper - o.to;
							o.to = tsb.upper;
						}
					}
					this.offset = o.from - tsb.lower;
				}
				this.scaler = lin.buildScaler(min, max, span, o);
				tsb = this.scaler.bounds;
				if (this.scale == 1 && this.offset == 0) {
					delete this.scale;
					delete this.offset;
				}
			}
			var minMinorStep = 0, ta = this.chart.theme.axis, taFont = "font" in o ? o.font : ta.font, size = taFont ? g.normalizedLength(g.splitFontString(taFont).size) : 0;
			if (this.vertical) {
				if (size) {
					minMinorStep = size + labelGap;
				}
			} else {
				if (size) {
					var labelWidth, i;
					if (o.labelFunc && o.maxLabelSize) {
						labelWidth = o.maxLabelSize;
					} else {
						if (this.labels) {
							labelWidth = this._groupLabelWidth(this.labels, taFont);
						} else {
							var labelLength = Math.ceil(Math.log(Math.max(Math.abs(tsb.from), Math.abs(tsb.to))) / Math.LN10), t = [];
							if (tsb.from < 0 || tsb.to < 0) {
								t.push("-");
							}
							t.push(dojo.string.rep("9", labelLength));
							var precision = Math.floor(Math.log(tsb.to - tsb.from) / Math.LN10);
							if (precision > 0) {
								t.push(".");
								for (i = 0; i < precision; ++i) {
									t.push("9");
								}
							}
							labelWidth = dojox.gfx._base._getTextBox(t.join(""), {font:taFont}).w;
						}
					}
					minMinorStep = labelWidth + labelGap;
				}
			}
			this.scaler.minMinorStep = minMinorStep;
			this.ticks = lin.buildTicks(this.scaler, o);
			return this;
		}, getScaler:function () {
			return this.scaler;
		}, getTicks:function () {
			return this.ticks;
		}, getOffsets:function () {
			var o = this.opt;
			var offsets = {l:0, r:0, t:0, b:0}, labelWidth, a, b, c, d, gl = dc.scaler.common.getNumericLabel, offset = 0, ta = this.chart.theme.axis, taFont = "font" in o ? o.font : ta.font, taMajorTick = "majorTick" in o ? o.majorTick : ta.majorTick, taMinorTick = "minorTick" in o ? o.minorTick : ta.minorTick, size = taFont ? g.normalizedLength(g.splitFontString(taFont).size) : 0, s = this.scaler;
			if (!s) {
				return offsets;
			}
			var ma = s.major, mi = s.minor;
			if (this.vertical) {
				if (size) {
					if (o.labelFunc && o.maxLabelSize) {
						labelWidth = o.maxLabelSize;
					} else {
						if (this.labels) {
							labelWidth = this._groupLabelWidth(this.labels, taFont);
						} else {
							labelWidth = this._groupLabelWidth([gl(ma.start, ma.prec, o), gl(ma.start + ma.count * ma.tick, ma.prec, o), gl(mi.start, mi.prec, o), gl(mi.start + mi.count * mi.tick, mi.prec, o)], taFont);
						}
					}
					offset = labelWidth + labelGap;
				}
				offset += labelGap + Math.max(taMajorTick.length, taMinorTick.length);
				offsets[o.leftBottom ? "l" : "r"] = offset;
				offsets.t = offsets.b = size / 2;
			} else {
				if (size) {
					offset = size + labelGap;
				}
				offset += labelGap + Math.max(taMajorTick.length, taMinorTick.length);
				offsets[o.leftBottom ? "b" : "t"] = offset;
				if (size) {
					if (o.labelFunc && o.maxLabelSize) {
						labelWidth = o.maxLabelSize;
					} else {
						if (this.labels) {
							labelWidth = this._groupLabelWidth(this.labels, taFont);
						} else {
							labelWidth = this._groupLabelWidth([gl(ma.start, ma.prec, o), gl(ma.start + ma.count * ma.tick, ma.prec, o), gl(mi.start, mi.prec, o), gl(mi.start + mi.count * mi.tick, mi.prec, o)], taFont);
						}
					}
					offsets.l = offsets.r = labelWidth / 2;
				}
			}
			if (labelWidth) {
				this._cachedLabelWidth = labelWidth;
			}
			return offsets;
		}, render:function (dim, offsets) {
			if (!this.dirty) {
				return this;
			}
			var o = this.opt;
			var start, stop, axisVector, tickVector, labelOffset, labelAlign, ta = this.chart.theme.axis, taStroke = "stroke" in o ? o.stroke : ta.stroke, taMajorTick = "majorTick" in o ? o.majorTick : ta.majorTick, taMinorTick = "minorTick" in o ? o.minorTick : ta.minorTick, taMicroTick = "microTick" in o ? o.microTick : ta.minorTick, taFont = "font" in o ? o.font : ta.font, taFontColor = "fontColor" in o ? o.fontColor : ta.fontColor, tickSize = Math.max(taMajorTick.length, taMinorTick.length), size = taFont ? g.normalizedLength(g.splitFontString(taFont).size) : 0;
			if (this.vertical) {
				start = {y:dim.height - offsets.b};
				stop = {y:offsets.t};
				axisVector = {x:0, y:-1};
				if (o.leftBottom) {
					start.x = stop.x = offsets.l;
					tickVector = {x:-1, y:0};
					labelAlign = "end";
				} else {
					start.x = stop.x = dim.width - offsets.r;
					tickVector = {x:1, y:0};
					labelAlign = "start";
				}
				labelOffset = {x:tickVector.x * (tickSize + labelGap), y:size * 0.4};
			} else {
				start = {x:offsets.l};
				stop = {x:dim.width - offsets.r};
				axisVector = {x:1, y:0};
				labelAlign = "middle";
				if (o.leftBottom) {
					start.y = stop.y = dim.height - offsets.b;
					tickVector = {x:0, y:1};
					labelOffset = {y:tickSize + labelGap + size};
				} else {
					start.y = stop.y = offsets.t;
					tickVector = {x:0, y:-1};
					labelOffset = {y:-tickSize - labelGap};
				}
				labelOffset.x = 0;
			}
			this.cleanGroup();
			try {
				var s = this.group, c = this.scaler, t = this.ticks, canLabel, f = lin.getTransformerFromModel(this.scaler), forceHtmlLabels = (dojox.gfx.renderer == "canvas"), labelType = forceHtmlLabels || this.opt.htmlLabels && !dojo.isIE && !dojo.isOpera ? "html" : "gfx", dx = tickVector.x * taMajorTick.length, dy = tickVector.y * taMajorTick.length;
				s.createLine({x1:start.x, y1:start.y, x2:stop.x, y2:stop.y}).setStroke(taStroke);
				dojo.forEach(t.major, function (tick) {
					var offset = f(tick.value), elem, x = start.x + axisVector.x * offset, y = start.y + axisVector.y * offset;
					s.createLine({x1:x, y1:y, x2:x + dx, y2:y + dy}).setStroke(taMajorTick);
					if (tick.label) {
						elem = dc.axis2d.common.createText[labelType](this.chart, s, x + labelOffset.x, y + labelOffset.y, labelAlign, tick.label, taFont, taFontColor, this._cachedLabelWidth);
						if (labelType == "html") {
							this.htmlElements.push(elem);
						}
					}
				}, this);
				dx = tickVector.x * taMinorTick.length;
				dy = tickVector.y * taMinorTick.length;
				canLabel = c.minMinorStep <= c.minor.tick * c.bounds.scale;
				dojo.forEach(t.minor, function (tick) {
					var offset = f(tick.value), elem, x = start.x + axisVector.x * offset, y = start.y + axisVector.y * offset;
					s.createLine({x1:x, y1:y, x2:x + dx, y2:y + dy}).setStroke(taMinorTick);
					if (canLabel && tick.label) {
						elem = dc.axis2d.common.createText[labelType](this.chart, s, x + labelOffset.x, y + labelOffset.y, labelAlign, tick.label, taFont, taFontColor, this._cachedLabelWidth);
						if (labelType == "html") {
							this.htmlElements.push(elem);
						}
					}
				}, this);
				dx = tickVector.x * taMicroTick.length;
				dy = tickVector.y * taMicroTick.length;
				dojo.forEach(t.micro, function (tick) {
					var offset = f(tick.value), elem, x = start.x + axisVector.x * offset, y = start.y + axisVector.y * offset;
					s.createLine({x1:x, y1:y, x2:x + dx, y2:y + dy}).setStroke(taMicroTick);
				}, this);
			}
			catch (e) {
			}
			this.dirty = false;
			return this;
		}});
	})();
}
if (!dojo._hasResource["dojox.charting.plot2d.common"]) {
	dojo._hasResource["dojox.charting.plot2d.common"] = true;
	dojo.provide("dojox.charting.plot2d.common");
	(function () {
		var df = dojox.lang.functional, dc = dojox.charting.plot2d.common;
		dojo.mixin(dojox.charting.plot2d.common, {makeStroke:function (stroke) {
			if (!stroke) {
				return stroke;
			}
			if (typeof stroke == "string" || stroke instanceof dojo.Color) {
				stroke = {color:stroke};
			}
			return dojox.gfx.makeParameters(dojox.gfx.defaultStroke, stroke);
		}, augmentColor:function (target, color) {
			var t = new dojo.Color(target), c = new dojo.Color(color);
			c.a = t.a;
			return c;
		}, augmentStroke:function (stroke, color) {
			var s = dc.makeStroke(stroke);
			if (s) {
				s.color = dc.augmentColor(s.color, color);
			}
			return s;
		}, augmentFill:function (fill, color) {
			var fc, c = new dojo.Color(color);
			if (typeof fill == "string" || fill instanceof dojo.Color) {
				return dc.augmentColor(fill, color);
			}
			return fill;
		}, defaultStats:{hmin:Number.POSITIVE_INFINITY, hmax:Number.NEGATIVE_INFINITY, vmin:Number.POSITIVE_INFINITY, vmax:Number.NEGATIVE_INFINITY}, collectSimpleStats:function (series) {
			var stats = dojo.clone(dc.defaultStats);
			for (var i = 0; i < series.length; ++i) {
				var run = series[i];
				if (!run.data.length) {
					continue;
				}
				if (typeof run.data[0] == "number") {
					var old_vmin = stats.vmin, old_vmax = stats.vmax;
					if (!("ymin" in run) || !("ymax" in run)) {
						dojo.forEach(run.data, function (val, i) {
							var x = i + 1, y = val;
							if (isNaN(y)) {
								y = 0;
							}
							stats.hmin = Math.min(stats.hmin, x);
							stats.hmax = Math.max(stats.hmax, x);
							stats.vmin = Math.min(stats.vmin, y);
							stats.vmax = Math.max(stats.vmax, y);
						});
					}
					if ("ymin" in run) {
						stats.vmin = Math.min(old_vmin, run.ymin);
					}
					if ("ymax" in run) {
						stats.vmax = Math.max(old_vmax, run.ymax);
					}
				} else {
					var old_hmin = stats.hmin, old_hmax = stats.hmax, old_vmin = stats.vmin, old_vmax = stats.vmax;
					if (!("xmin" in run) || !("xmax" in run) || !("ymin" in run) || !("ymax" in run)) {
						dojo.forEach(run.data, function (val, i) {
							var x = "x" in val ? val.x : i + 1, y = val.y;
							if (isNaN(x)) {
								x = 0;
							}
							if (isNaN(y)) {
								y = 0;
							}
							stats.hmin = Math.min(stats.hmin, x);
							stats.hmax = Math.max(stats.hmax, x);
							stats.vmin = Math.min(stats.vmin, y);
							stats.vmax = Math.max(stats.vmax, y);
						});
					}
					if ("xmin" in run) {
						stats.hmin = Math.min(old_hmin, run.xmin);
					}
					if ("xmax" in run) {
						stats.hmax = Math.max(old_hmax, run.xmax);
					}
					if ("ymin" in run) {
						stats.vmin = Math.min(old_vmin, run.ymin);
					}
					if ("ymax" in run) {
						stats.vmax = Math.max(old_vmax, run.ymax);
					}
				}
			}
			return stats;
		}, calculateBarSize:function (availableSize, opt, clusterSize) {
			if (!clusterSize) {
				clusterSize = 1;
			}
			var gap = opt.gap, size = (availableSize - 2 * gap) / clusterSize;
			if ("minBarSize" in opt) {
				size = Math.max(size, opt.minBarSize);
			}
			if ("maxBarSize" in opt) {
				size = Math.min(size, opt.maxBarSize);
			}
			size = Math.max(size, 1);
			gap = (availableSize - size * clusterSize) / 2;
			return {size:size, gap:gap};
		}, collectStackedStats:function (series) {
			var stats = dojo.clone(dc.defaultStats);
			if (series.length) {
				stats.hmin = Math.min(stats.hmin, 1);
				stats.hmax = df.foldl(series, "seed, run -> Math.max(seed, run.data.length)", stats.hmax);
				for (var i = 0; i < stats.hmax; ++i) {
					var v = series[0].data[i];
					if (isNaN(v)) {
						v = 0;
					}
					stats.vmin = Math.min(stats.vmin, v);
					for (var j = 1; j < series.length; ++j) {
						var t = series[j].data[i];
						if (isNaN(t)) {
							t = 0;
						}
						v += t;
					}
					stats.vmax = Math.max(stats.vmax, v);
				}
			}
			return stats;
		}, curve:function (a, tension) {
			var arr = a.slice(0);
			if (tension == "x") {
				arr[arr.length] = arr[0];
			}
			var p = dojo.map(arr, function (item, i) {
				if (i == 0) {
					return "M" + item.x + "," + item.y;
				}
				if (!isNaN(tension)) {
					var dx = item.x - arr[i - 1].x, dy = arr[i - 1].y;
					return "C" + (item.x - (tension - 1) * (dx / tension)) + "," + dy + " " + (item.x - (dx / tension)) + "," + item.y + " " + item.x + "," + item.y;
				} else {
					if (tension == "X" || tension == "x" || tension == "S") {
						var p0, p1 = arr[i - 1], p2 = arr[i], p3;
						var bz1x, bz1y, bz2x, bz2y;
						var f = 1 / 6;
						if (i == 1) {
							if (tension == "x") {
								p0 = arr[arr.length - 2];
							} else {
								p0 = p1;
							}
							f = 1 / 3;
						} else {
							p0 = arr[i - 2];
						}
						if (i == (arr.length - 1)) {
							if (tension == "x") {
								p3 = arr[1];
							} else {
								p3 = p2;
							}
							f = 1 / 3;
						} else {
							p3 = arr[i + 1];
						}
						var p1p2 = Math.sqrt((p2.x - p1.x) * (p2.x - p1.x) + (p2.y - p1.y) * (p2.y - p1.y));
						var p0p2 = Math.sqrt((p2.x - p0.x) * (p2.x - p0.x) + (p2.y - p0.y) * (p2.y - p0.y));
						var p1p3 = Math.sqrt((p3.x - p1.x) * (p3.x - p1.x) + (p3.y - p1.y) * (p3.y - p1.y));
						var p0p2f = p0p2 * f;
						var p1p3f = p1p3 * f;
						if (p0p2f > p1p2 / 2 && p1p3f > p1p2 / 2) {
							p0p2f = p1p2 / 2;
							p1p3f = p1p2 / 2;
						} else {
							if (p0p2f > p1p2 / 2) {
								p0p2f = p1p2 / 2;
								p1p3f = p1p2 / 2 * p1p3 / p0p2;
							} else {
								if (p1p3f > p1p2 / 2) {
									p1p3f = p1p2 / 2;
									p0p2f = p1p2 / 2 * p0p2 / p1p3;
								}
							}
						}
						if (tension == "S") {
							if (p0 == p1) {
								p0p2f = 0;
							}
							if (p2 == p3) {
								p1p3f = 0;
							}
						}
						bz1x = p1.x + p0p2f * (p2.x - p0.x) / p0p2;
						bz1y = p1.y + p0p2f * (p2.y - p0.y) / p0p2;
						bz2x = p2.x - p1p3f * (p3.x - p1.x) / p1p3;
						bz2y = p2.y - p1p3f * (p3.y - p1.y) / p1p3;
					}
				}
				return "C" + (bz1x + "," + bz1y + " " + bz2x + "," + bz2y + " " + p2.x + "," + p2.y);
			});
			return p.join(" ");
		}});
	})();
}
if (!dojo._hasResource["dojox.charting.scaler.primitive"]) {
	dojo._hasResource["dojox.charting.scaler.primitive"] = true;
	dojo.provide("dojox.charting.scaler.primitive");
	dojox.charting.scaler.primitive = {buildScaler:function (min, max, span, kwArgs) {
		return {bounds:{lower:min, upper:max, from:min, to:max, scale:span / (max - min), span:span}, scaler:dojox.charting.scaler.primitive};
	}, buildTicks:function (scaler, kwArgs) {
		return {major:[], minor:[], micro:[]};
	}, getTransformerFromModel:function (scaler) {
		var offset = scaler.bounds.from, scale = scaler.bounds.scale;
		return function (x) {
			return (x - offset) * scale;
		};
	}, getTransformerFromPlot:function (scaler) {
		var offset = scaler.bounds.from, scale = scaler.bounds.scale;
		return function (x) {
			return x / scale + offset;
		};
	}};
}
if (!dojo._hasResource["dojox.charting.plot2d.Base"]) {
	dojo._hasResource["dojox.charting.plot2d.Base"] = true;
	dojo.provide("dojox.charting.plot2d.Base");
	dojo.declare("dojox.charting.plot2d.Base", dojox.charting.Element, {destroy:function () {
		this.resetEvents();
		this.inherited(arguments);
	}, clear:function () {
		this.series = [];
		this._hAxis = null;
		this._vAxis = null;
		this.dirty = true;
		return this;
	}, setAxis:function (axis) {
		if (axis) {
			this[axis.vertical ? "_vAxis" : "_hAxis"] = axis;
		}
		return this;
	}, addSeries:function (run) {
		this.series.push(run);
		return this;
	}, calculateAxes:function (dim) {
		return this;
	}, isDirty:function () {
		return this.dirty || this._hAxis && this._hAxis.dirty || this._vAxis && this._vAxis.dirty;
	}, render:function (dim, offsets) {
		return this;
	}, getRequiredColors:function () {
		return this.series.length;
	}, plotEvent:function (o) {
	}, connect:function (object, method) {
		this.dirty = true;
		return dojo.connect(this, "plotEvent", object, method);
	}, events:function () {
		var ls = this.plotEvent._listeners;
		if (!ls || !ls.length) {
			return false;
		}
		for (var i in ls) {
			if (!(i in Array.prototype)) {
				return true;
			}
		}
		return false;
	}, resetEvents:function () {
		this.plotEvent({type:"onplotreset", plot:this});
	}, _calc:function (dim, stats) {
		if (this._hAxis) {
			if (!this._hAxis.initialized()) {
				this._hAxis.calculate(stats.hmin, stats.hmax, dim.width);
			}
			this._hScaler = this._hAxis.getScaler();
		} else {
			this._hScaler = dojox.charting.scaler.primitive.buildScaler(stats.hmin, stats.hmax, dim.width);
		}
		if (this._vAxis) {
			if (!this._vAxis.initialized()) {
				this._vAxis.calculate(stats.vmin, stats.vmax, dim.height);
			}
			this._vScaler = this._vAxis.getScaler();
		} else {
			this._vScaler = dojox.charting.scaler.primitive.buildScaler(stats.vmin, stats.vmax, dim.height);
		}
	}, _connectEvents:function (shape, o) {
		shape.connect("onmouseover", this, function (e) {
			o.type = "onmouseover";
			o.event = e;
			this.plotEvent(o);
		});
		shape.connect("onmouseout", this, function (e) {
			o.type = "onmouseout";
			o.event = e;
			this.plotEvent(o);
		});
		shape.connect("onclick", this, function (e) {
			o.type = "onclick";
			o.event = e;
			this.plotEvent(o);
		});
	}});
}
if (!dojo._hasResource["dojox.charting.plot2d.Default"]) {
	dojo._hasResource["dojox.charting.plot2d.Default"] = true;
	dojo.provide("dojox.charting.plot2d.Default");
	(function () {
		var df = dojox.lang.functional, du = dojox.lang.utils, dc = dojox.charting.plot2d.common, purgeGroup = df.lambda("item.purgeGroup()");
		dojo.declare("dojox.charting.plot2d.Default", dojox.charting.plot2d.Base, {defaultParams:{hAxis:"x", vAxis:"y", lines:true, areas:false, markers:false, shadows:0, tension:0}, optionalParams:{}, constructor:function (chart, kwArgs) {
			this.opt = dojo.clone(this.defaultParams);
			du.updateWithObject(this.opt, kwArgs);
			this.series = [];
			this.hAxis = this.opt.hAxis;
			this.vAxis = this.opt.vAxis;
		}, calculateAxes:function (dim) {
			this._calc(dim, dc.collectSimpleStats(this.series));
			return this;
		}, render:function (dim, offsets) {
			this.dirty = this.isDirty();
			if (this.dirty) {
				dojo.forEach(this.series, purgeGroup);
				this.cleanGroup();
				var s = this.group;
				df.forEachRev(this.series, function (item) {
					item.cleanGroup(s);
				});
			}
			var t = this.chart.theme, stroke, outline, color, marker, events = this.events();
			this.resetEvents();
			for (var i = this.series.length - 1; i >= 0; --i) {
				var run = this.series[i];
				if (!this.dirty && !run.dirty) {
					continue;
				}
				run.cleanGroup();
				if (!run.data.length) {
					run.dirty = false;
					continue;
				}
				var s = run.group, lpoly, ht = this._hScaler.scaler.getTransformerFromModel(this._hScaler), vt = this._vScaler.scaler.getTransformerFromModel(this._vScaler);
				if (typeof run.data[0] == "number") {
					lpoly = dojo.map(run.data, function (v, i) {
						return {x:ht(i + 1) + offsets.l, y:dim.height - offsets.b - vt(v)};
					}, this);
				} else {
					lpoly = dojo.map(run.data, function (v, i) {
						return {x:ht(v.x) + offsets.l, y:dim.height - offsets.b - vt(v.y)};
					}, this);
				}
				if (!run.fill || !run.stroke) {
					color = run.dyn.color = new dojo.Color(t.next("color"));
				}
				var lpath = this.opt.tension ? dc.curve(lpoly, this.opt.tension) : "";
				if (this.opt.areas) {
					var fill = run.fill ? run.fill : dc.augmentFill(t.series.fill, color);
					var apoly = dojo.clone(lpoly);
					if (this.opt.tension) {
						var apath = "L" + apoly[apoly.length - 1].x + "," + (dim.height - offsets.b) + " L" + apoly[0].x + "," + (dim.height - offsets.b) + " L" + apoly[0].x + "," + apoly[0].y;
						run.dyn.fill = s.createPath(lpath + " " + apath).setFill(fill).getFill();
					} else {
						apoly.push({x:lpoly[lpoly.length - 1].x, y:dim.height - offsets.b});
						apoly.push({x:lpoly[0].x, y:dim.height - offsets.b});
						apoly.push(lpoly[0]);
						run.dyn.fill = s.createPolyline(apoly).setFill(fill).getFill();
					}
				}
				if (this.opt.lines || this.opt.markers) {
					stroke = run.dyn.stroke = run.stroke ? dc.makeStroke(run.stroke) : dc.augmentStroke(t.series.stroke, color);
					if (run.outline || t.series.outline) {
						outline = run.dyn.outline = dc.makeStroke(run.outline ? run.outline : t.series.outline);
						outline.width = 2 * outline.width + stroke.width;
					}
				}
				if (this.opt.markers) {
					marker = run.dyn.marker = run.marker ? run.marker : t.next("marker");
				}
				var frontMarkers = null, outlineMarkers = null, shadowMarkers = null;
				if (this.opt.shadows && stroke) {
					var sh = this.opt.shadows, shadowColor = new dojo.Color([0, 0, 0, 0.3]), spoly = dojo.map(lpoly, function (c) {
						return {x:c.x + sh.dx, y:c.y + sh.dy};
					}), shadowStroke = dojo.clone(outline ? outline : stroke);
					shadowStroke.color = shadowColor;
					shadowStroke.width += sh.dw ? sh.dw : 0;
					if (this.opt.lines) {
						if (this.opt.tension) {
							run.dyn.shadow = s.createPath(dc.curve(spoly, this.opt.tension)).setStroke(shadowStroke).getStroke();
						} else {
							run.dyn.shadow = s.createPolyline(spoly).setStroke(shadowStroke).getStroke();
						}
					}
					if (this.opt.markers) {
						shadowMarkers = dojo.map(spoly, function (c) {
							return s.createPath("M" + c.x + " " + c.y + " " + marker).setStroke(shadowStroke).setFill(shadowColor);
						}, this);
					}
				}
				if (this.opt.lines) {
					if (outline) {
						if (this.opt.tension) {
							run.dyn.outline = s.createPath(lpath).setStroke(outline).getStroke();
						} else {
							run.dyn.outline = s.createPolyline(lpoly).setStroke(outline).getStroke();
						}
					}
					if (this.opt.tension) {
						run.dyn.stroke = s.createPath(lpath).setStroke(stroke).getStroke();
					} else {
						run.dyn.stroke = s.createPolyline(lpoly).setStroke(stroke).getStroke();
					}
				}
				if (this.opt.markers) {
					frontMarkers = new Array(lpoly.length);
					outlineMarkers = new Array(lpoly.length);
					dojo.forEach(lpoly, function (c, i) {
						var path = "M" + c.x + " " + c.y + " " + marker;
						if (outline) {
							outlineMarkers[i] = s.createPath(path).setStroke(outline);
						}
						frontMarkers[i] = s.createPath(path).setStroke(stroke).setFill(stroke.color);
					}, this);
					if (events) {
						dojo.forEach(frontMarkers, function (s, i) {
							var o = {element:"marker", index:i, run:run, plot:this, hAxis:this.hAxis || null, vAxis:this.vAxis || null, shape:s, outline:outlineMarkers[i] || null, shadow:shadowMarkers && shadowMarkers[i] || null, cx:lpoly[i].x, cy:lpoly[i].y};
							if (typeof run.data[0] == "number") {
								o.x = i + 1;
								o.y = run.data[i];
							} else {
								o.x = run.data[i].x;
								o.y = run.data[i].y;
							}
							this._connectEvents(s, o);
						}, this);
					}
				}
				run.dirty = false;
			}
			this.dirty = false;
			return this;
		}});
	})();
}
if (!dojo._hasResource["dojox.charting.plot2d.Lines"]) {
	dojo._hasResource["dojox.charting.plot2d.Lines"] = true;
	dojo.provide("dojox.charting.plot2d.Lines");
	dojo.declare("dojox.charting.plot2d.Lines", dojox.charting.plot2d.Default, {constructor:function () {
		this.opt.lines = true;
	}});
}
if (!dojo._hasResource["dojox.charting.plot2d.Areas"]) {
	dojo._hasResource["dojox.charting.plot2d.Areas"] = true;
	dojo.provide("dojox.charting.plot2d.Areas");
	dojo.declare("dojox.charting.plot2d.Areas", dojox.charting.plot2d.Default, {constructor:function () {
		this.opt.lines = true;
		this.opt.areas = true;
	}});
}
if (!dojo._hasResource["dojox.charting.plot2d.Markers"]) {
	dojo._hasResource["dojox.charting.plot2d.Markers"] = true;
	dojo.provide("dojox.charting.plot2d.Markers");
	dojo.declare("dojox.charting.plot2d.Markers", dojox.charting.plot2d.Default, {constructor:function () {
		this.opt.markers = true;
	}});
}
if (!dojo._hasResource["dojox.charting.plot2d.MarkersOnly"]) {
	dojo._hasResource["dojox.charting.plot2d.MarkersOnly"] = true;
	dojo.provide("dojox.charting.plot2d.MarkersOnly");
	dojo.declare("dojox.charting.plot2d.MarkersOnly", dojox.charting.plot2d.Default, {constructor:function () {
		this.opt.lines = false;
		this.opt.markers = true;
	}});
}
if (!dojo._hasResource["dojox.charting.plot2d.Scatter"]) {
	dojo._hasResource["dojox.charting.plot2d.Scatter"] = true;
	dojo.provide("dojox.charting.plot2d.Scatter");
	dojo.declare("dojox.charting.plot2d.Scatter", dojox.charting.plot2d.Default, {constructor:function () {
		this.opt.lines = false;
		this.opt.markers = true;
	}});
}
if (!dojo._hasResource["dojox.lang.functional.sequence"]) {
	dojo._hasResource["dojox.lang.functional.sequence"] = true;
	dojo.provide("dojox.lang.functional.sequence");
	(function () {
		var d = dojo, df = dojox.lang.functional;
		d.mixin(df, {repeat:function (n, f, z, o) {
			o = o || d.global;
			f = df.lambda(f);
			var t = new Array(n), i = 1;
			t[0] = z;
			for (; i < n; t[i] = z = f.call(o, z), ++i) {
			}
			return t;
		}, until:function (pr, f, z, o) {
			o = o || d.global;
			f = df.lambda(f);
			pr = df.lambda(pr);
			var t = [];
			for (; !pr.call(o, z); t.push(z), z = f.call(o, z)) {
			}
			return t;
		}});
	})();
}
if (!dojo._hasResource["dojox.charting.plot2d.Stacked"]) {
	dojo._hasResource["dojox.charting.plot2d.Stacked"] = true;
	dojo.provide("dojox.charting.plot2d.Stacked");
	(function () {
		var df = dojox.lang.functional, dc = dojox.charting.plot2d.common, purgeGroup = df.lambda("item.purgeGroup()");
		dojo.declare("dojox.charting.plot2d.Stacked", dojox.charting.plot2d.Default, {calculateAxes:function (dim) {
			var stats = dc.collectStackedStats(this.series);
			this._maxRunLength = stats.hmax;
			this._calc(dim, stats);
			return this;
		}, render:function (dim, offsets) {
			if (this._maxRunLength <= 0) {
				return this;
			}
			var acc = df.repeat(this._maxRunLength, "-> 0", 0);
			for (var i = 0; i < this.series.length; ++i) {
				var run = this.series[i];
				for (var j = 0; j < run.data.length; ++j) {
					var v = run.data[j];
					if (isNaN(v)) {
						v = 0;
					}
					acc[j] += v;
				}
			}
			this.dirty = this.isDirty();
			if (this.dirty) {
				dojo.forEach(this.series, purgeGroup);
				this.cleanGroup();
				var s = this.group;
				df.forEachRev(this.series, function (item) {
					item.cleanGroup(s);
				});
			}
			var t = this.chart.theme, stroke, outline, color, marker, events = this.events(), ht = this._hScaler.scaler.getTransformerFromModel(this._hScaler), vt = this._vScaler.scaler.getTransformerFromModel(this._vScaler);
			this.resetEvents();
			for (var i = this.series.length - 1; i >= 0; --i) {
				var run = this.series[i];
				if (!this.dirty && !run.dirty) {
					continue;
				}
				run.cleanGroup();
				var s = run.group, lpoly = dojo.map(acc, function (v, i) {
					return {x:ht(i + 1) + offsets.l, y:dim.height - offsets.b - vt(v)};
				}, this);
				if (!run.fill || !run.stroke) {
					color = new dojo.Color(t.next("color"));
				}
				var lpath = this.opt.tension ? dc.curve(lpoly, this.opt.tension) : "";
				if (this.opt.areas) {
					var apoly = dojo.clone(lpoly);
					var fill = run.fill ? run.fill : dc.augmentFill(t.series.fill, color);
					if (this.opt.tension) {
						var p = dc.curve(apoly, this.opt.tension);
						p += " L" + lpoly[lpoly.length - 1].x + "," + (dim.height - offsets.b) + " L" + lpoly[0].x + "," + (dim.height - offsets.b) + " L" + lpoly[0].x + "," + lpoly[0].y;
						run.dyn.fill = s.createPath(p).setFill(fill).getFill();
					} else {
						apoly.push({x:lpoly[lpoly.length - 1].x, y:dim.height - offsets.b});
						apoly.push({x:lpoly[0].x, y:dim.height - offsets.b});
						apoly.push(lpoly[0]);
						run.dyn.fill = s.createPolyline(apoly).setFill(fill).getFill();
					}
				}
				if (this.opt.lines || this.opt.markers) {
					stroke = run.stroke ? dc.makeStroke(run.stroke) : dc.augmentStroke(t.series.stroke, color);
					if (run.outline || t.series.outline) {
						outline = dc.makeStroke(run.outline ? run.outline : t.series.outline);
						outline.width = 2 * outline.width + stroke.width;
					}
				}
				if (this.opt.markers) {
					marker = run.dyn.marker = run.marker ? run.marker : t.next("marker");
				}
				var frontMarkers, outlineMarkers, shadowMarkers;
				if (this.opt.shadows && stroke) {
					var sh = this.opt.shadows, shadowColor = new dojo.Color([0, 0, 0, 0.3]), spoly = dojo.map(lpoly, function (c) {
						return {x:c.x + sh.dx, y:c.y + sh.dy};
					}), shadowStroke = dojo.clone(outline ? outline : stroke);
					shadowStroke.color = shadowColor;
					shadowStroke.width += sh.dw ? sh.dw : 0;
					if (this.opt.lines) {
						if (this.opt.tension) {
							run.dyn.shadow = s.createPath(dc.curve(spoly, this.opt.tension)).setStroke(shadowStroke).getStroke();
						} else {
							run.dyn.shadow = s.createPolyline(spoly).setStroke(shadowStroke).getStroke();
						}
					}
					if (this.opt.markers) {
						shadowMarkers = dojo.map(spoly, function (c) {
							return s.createPath("M" + c.x + " " + c.y + " " + marker).setStroke(shadowStroke).setFill(shadowColor);
						}, this);
					}
				}
				if (this.opt.lines) {
					if (outline) {
						if (this.opt.tension) {
							run.dyn.outline = s.createPath(lpath).setStroke(outline).getStroke();
						} else {
							run.dyn.outline = s.createPolyline(lpoly).setStroke(outline).getStroke();
						}
					}
					if (this.opt.tension) {
						run.dyn.stroke = s.createPath(lpath).setStroke(stroke).getStroke();
					} else {
						run.dyn.stroke = s.createPolyline(lpoly).setStroke(stroke).getStroke();
					}
				}
				if (this.opt.markers) {
					frontMarkers = new Array(lpoly.length);
					outlineMarkers = new Array(lpoly.length);
					dojo.forEach(lpoly, function (c, i) {
						var path = "M" + c.x + " " + c.y + " " + marker;
						if (outline) {
							outlineMarkers[i] = s.createPath(path).setStroke(outline);
						}
						frontMarkers[i] = s.createPath(path).setStroke(stroke).setFill(stroke.color);
					}, this);
					if (events) {
						dojo.forEach(frontMarkers, function (s, i) {
							var o = {element:"marker", index:i, run:run, plot:this, hAxis:this.hAxis || null, vAxis:this.vAxis || null, shape:s, outline:outlineMarkers[i] || null, shadow:shadowMarkers && shadowMarkers[i] || null, cx:lpoly[i].x, cy:lpoly[i].y, x:i + 1, y:run.data[i]};
							this._connectEvents(s, o);
						}, this);
					}
				}
				run.dirty = false;
				for (var j = 0; j < run.data.length; ++j) {
					var v = run.data[j];
					if (isNaN(v)) {
						v = 0;
					}
					acc[j] -= v;
				}
			}
			this.dirty = false;
			return this;
		}});
	})();
}
if (!dojo._hasResource["dojox.charting.plot2d.StackedLines"]) {
	dojo._hasResource["dojox.charting.plot2d.StackedLines"] = true;
	dojo.provide("dojox.charting.plot2d.StackedLines");
	dojo.declare("dojox.charting.plot2d.StackedLines", dojox.charting.plot2d.Stacked, {constructor:function () {
		this.opt.lines = true;
	}});
}
if (!dojo._hasResource["dojox.charting.plot2d.StackedAreas"]) {
	dojo._hasResource["dojox.charting.plot2d.StackedAreas"] = true;
	dojo.provide("dojox.charting.plot2d.StackedAreas");
	dojo.declare("dojox.charting.plot2d.StackedAreas", dojox.charting.plot2d.Stacked, {constructor:function () {
		this.opt.lines = true;
		this.opt.areas = true;
	}});
}
if (!dojo._hasResource["dojox.gfx.fx"]) {
	dojo._hasResource["dojox.gfx.fx"] = true;
	dojo.provide("dojox.gfx.fx");
	(function () {
		var d = dojo, g = dojox.gfx, m = g.matrix;
		var InterpolNumber = function (start, end) {
			this.start = start, this.end = end;
		};
		d.extend(InterpolNumber, {getValue:function (r) {
			return (this.end - this.start) * r + this.start;
		}});
		var InterpolUnit = function (start, end, units) {
			this.start = start, this.end = end;
			this.units = units;
		};
		d.extend(InterpolUnit, {getValue:function (r) {
			return (this.end - this.start) * r + this.start + this.units;
		}});
		var InterpolColor = function (start, end) {
			this.start = start, this.end = end;
			this.temp = new dojo.Color();
		};
		d.extend(InterpolColor, {getValue:function (r) {
			return d.blendColors(this.start, this.end, r, this.temp);
		}});
		var InterpolValues = function (values) {
			this.values = values;
			this.length = values.length;
		};
		d.extend(InterpolValues, {getValue:function (r) {
			return this.values[Math.min(Math.floor(r * this.length), this.length - 1)];
		}});
		var InterpolObject = function (values, def) {
			this.values = values;
			this.def = def ? def : {};
		};
		d.extend(InterpolObject, {getValue:function (r) {
			var ret = dojo.clone(this.def);
			for (var i in this.values) {
				ret[i] = this.values[i].getValue(r);
			}
			return ret;
		}});
		var InterpolTransform = function (stack, original) {
			this.stack = stack;
			this.original = original;
		};
		d.extend(InterpolTransform, {getValue:function (r) {
			var ret = [];
			dojo.forEach(this.stack, function (t) {
				if (t instanceof m.Matrix2D) {
					ret.push(t);
					return;
				}
				if (t.name == "original" && this.original) {
					ret.push(this.original);
					return;
				}
				if (!(t.name in m)) {
					return;
				}
				var f = m[t.name];
				if (typeof f != "function") {
					ret.push(f);
					return;
				}
				var val = dojo.map(t.start, function (v, i) {
					return (t.end[i] - v) * r + v;
				}), matrix = f.apply(m, val);
				if (matrix instanceof m.Matrix2D) {
					ret.push(matrix);
				}
			}, this);
			return ret;
		}});
		var transparent = new d.Color(0, 0, 0, 0);
		var getColorInterpol = function (prop, obj, name, def) {
			if (prop.values) {
				return new InterpolValues(prop.values);
			}
			var value, start, end;
			if (prop.start) {
				start = g.normalizeColor(prop.start);
			} else {
				start = value = obj ? (name ? obj[name] : obj) : def;
			}
			if (prop.end) {
				end = g.normalizeColor(prop.end);
			} else {
				if (!value) {
					value = obj ? (name ? obj[name] : obj) : def;
				}
				end = value;
			}
			return new InterpolColor(start, end);
		};
		var getNumberInterpol = function (prop, obj, name, def) {
			if (prop.values) {
				return new InterpolValues(prop.values);
			}
			var value, start, end;
			if (prop.start) {
				start = prop.start;
			} else {
				start = value = obj ? obj[name] : def;
			}
			if (prop.end) {
				end = prop.end;
			} else {
				if (typeof value != "number") {
					value = obj ? obj[name] : def;
				}
				end = value;
			}
			return new InterpolNumber(start, end);
		};
		g.fx.animateStroke = function (args) {
			if (!args.easing) {
				args.easing = d._defaultEasing;
			}
			var anim = new d.Animation(args), shape = args.shape, stroke;
			d.connect(anim, "beforeBegin", anim, function () {
				stroke = shape.getStroke();
				var prop = args.color, values = {}, value, start, end;
				if (prop) {
					values.color = getColorInterpol(prop, stroke, "color", transparent);
				}
				prop = args.style;
				if (prop && prop.values) {
					values.style = new InterpolValues(prop.values);
				}
				prop = args.width;
				if (prop) {
					values.width = getNumberInterpol(prop, stroke, "width", 1);
				}
				prop = args.cap;
				if (prop && prop.values) {
					values.cap = new InterpolValues(prop.values);
				}
				prop = args.join;
				if (prop) {
					if (prop.values) {
						values.join = new InterpolValues(prop.values);
					} else {
						start = prop.start ? prop.start : (stroke && stroke.join || 0);
						end = prop.end ? prop.end : (stroke && stroke.join || 0);
						if (typeof start == "number" && typeof end == "number") {
							values.join = new InterpolNumber(start, end);
						}
					}
				}
				this.curve = new InterpolObject(values, stroke);
			});
			d.connect(anim, "onAnimate", shape, "setStroke");
			return anim;
		};
		g.fx.animateFill = function (args) {
			if (!args.easing) {
				args.easing = d._defaultEasing;
			}
			var anim = new d.Animation(args), shape = args.shape, fill;
			d.connect(anim, "beforeBegin", anim, function () {
				fill = shape.getFill();
				var prop = args.color, values = {};
				if (prop) {
					this.curve = getColorInterpol(prop, fill, "", transparent);
				}
			});
			d.connect(anim, "onAnimate", shape, "setFill");
			return anim;
		};
		g.fx.animateFont = function (args) {
			if (!args.easing) {
				args.easing = d._defaultEasing;
			}
			var anim = new d.Animation(args), shape = args.shape, font;
			d.connect(anim, "beforeBegin", anim, function () {
				font = shape.getFont();
				var prop = args.style, values = {}, value, start, end;
				if (prop && prop.values) {
					values.style = new InterpolValues(prop.values);
				}
				prop = args.variant;
				if (prop && prop.values) {
					values.variant = new InterpolValues(prop.values);
				}
				prop = args.weight;
				if (prop && prop.values) {
					values.weight = new InterpolValues(prop.values);
				}
				prop = args.family;
				if (prop && prop.values) {
					values.family = new InterpolValues(prop.values);
				}
				prop = args.size;
				if (prop && prop.units) {
					start = parseFloat(prop.start ? prop.start : (shape.font && shape.font.size || "0"));
					end = parseFloat(prop.end ? prop.end : (shape.font && shape.font.size || "0"));
					values.size = new InterpolUnit(start, end, prop.units);
				}
				this.curve = new InterpolObject(values, font);
			});
			d.connect(anim, "onAnimate", shape, "setFont");
			return anim;
		};
		g.fx.animateTransform = function (args) {
			if (!args.easing) {
				args.easing = d._defaultEasing;
			}
			var anim = new d.Animation(args), shape = args.shape, original;
			d.connect(anim, "beforeBegin", anim, function () {
				original = shape.getTransform();
				this.curve = new InterpolTransform(args.transform, original);
			});
			d.connect(anim, "onAnimate", shape, "setTransform");
			return anim;
		};
	})();
}
if (!dojo._hasResource["dojox.charting.plot2d.Columns"]) {
	dojo._hasResource["dojox.charting.plot2d.Columns"] = true;
	dojo.provide("dojox.charting.plot2d.Columns");
	(function () {
		var df = dojox.lang.functional, du = dojox.lang.utils, dc = dojox.charting.plot2d.common, purgeGroup = df.lambda("item.purgeGroup()");
		dojo.declare("dojox.charting.plot2d.Columns", dojox.charting.plot2d.Base, {defaultParams:{hAxis:"x", vAxis:"y", gap:0, shadows:null, animate:null}, optionalParams:{minBarSize:1, maxBarSize:1}, constructor:function (chart, kwArgs) {
			this.opt = dojo.clone(this.defaultParams);
			du.updateWithObject(this.opt, kwArgs);
			du.updateWithPattern(this.opt, kwArgs, this.optionalParams);
			this.series = [];
			this.hAxis = this.opt.hAxis;
			this.vAxis = this.opt.vAxis;
			this.animate = this.opt.animate;
		}, calculateAxes:function (dim) {
			var stats = dc.collectSimpleStats(this.series);
			stats.hmin -= 0.5;
			stats.hmax += 0.5;
			this._calc(dim, stats);
			return this;
		}, render:function (dim, offsets) {
			this.dirty = this.isDirty();
			if (this.dirty) {
				dojo.forEach(this.series, purgeGroup);
				this.cleanGroup();
				var s = this.group;
				df.forEachRev(this.series, function (item) {
					item.cleanGroup(s);
				});
			}
			var t = this.chart.theme, color, stroke, fill, f, gap, width, ht = this._hScaler.scaler.getTransformerFromModel(this._hScaler), vt = this._vScaler.scaler.getTransformerFromModel(this._vScaler), baseline = Math.max(0, this._vScaler.bounds.lower), baselineHeight = vt(baseline), events = this.events();
			f = dc.calculateBarSize(this._hScaler.bounds.scale, this.opt);
			gap = f.gap;
			width = f.size;
			this.resetEvents();
			for (var i = this.series.length - 1; i >= 0; --i) {
				var run = this.series[i];
				if (!this.dirty && !run.dirty) {
					continue;
				}
				run.cleanGroup();
				var s = run.group;
				if (!run.fill || !run.stroke) {
					color = run.dyn.color = new dojo.Color(t.next("color"));
				}
				stroke = run.stroke ? run.stroke : dc.augmentStroke(t.series.stroke, color);
				fill = run.fill ? run.fill : dc.augmentFill(t.series.fill, color);
				for (var j = 0; j < run.data.length; ++j) {
					var value = run.data[j], v = typeof value == "number" ? value : value.y, vv = vt(v), height = vv - baselineHeight, h = Math.abs(height), specialColor = color, specialFill = fill, specialStroke = stroke;
					if (typeof value != "number") {
						if (value.color) {
							specialColor = new dojo.Color(value.color);
						}
						if ("fill" in value) {
							specialFill = value.fill;
						} else {
							if (value.color) {
								specialFill = dc.augmentFill(t.series.fill, specialColor);
							}
						}
						if ("stroke" in value) {
							specialStroke = value.stroke;
						} else {
							if (value.color) {
								specialStroke = dc.augmentStroke(t.series.stroke, specialColor);
							}
						}
					}
					if (width >= 1 && h >= 1) {
						var shape = s.createRect({x:offsets.l + ht(j + 0.5) + gap, y:dim.height - offsets.b - (v > baseline ? vv : baselineHeight), width:width, height:h}).setFill(specialFill).setStroke(specialStroke);
						run.dyn.fill = shape.getFill();
						run.dyn.stroke = shape.getStroke();
						if (events) {
							var o = {element:"column", index:j, run:run, plot:this, hAxis:this.hAxis || null, vAxis:this.vAxis || null, shape:shape, x:j + 0.5, y:v};
							this._connectEvents(shape, o);
						}
						if (this.animate) {
							this._animateColumn(shape, dim.height - offsets.b - baselineHeight, h);
						}
					}
				}
				run.dirty = false;
			}
			this.dirty = false;
			return this;
		}, _animateColumn:function (shape, voffset, vsize) {
			dojox.gfx.fx.animateTransform(dojo.delegate({shape:shape, duration:1200, transform:[{name:"translate", start:[0, voffset - (voffset / vsize)], end:[0, 0]}, {name:"scale", start:[1, 1 / vsize], end:[1, 1]}, {name:"original"}]}, this.animate)).play();
		}});
	})();
}
if (!dojo._hasResource["dojox.charting.plot2d.StackedColumns"]) {
	dojo._hasResource["dojox.charting.plot2d.StackedColumns"] = true;
	dojo.provide("dojox.charting.plot2d.StackedColumns");
	(function () {
		var df = dojox.lang.functional, dc = dojox.charting.plot2d.common, purgeGroup = df.lambda("item.purgeGroup()");
		dojo.declare("dojox.charting.plot2d.StackedColumns", dojox.charting.plot2d.Columns, {calculateAxes:function (dim) {
			var stats = dc.collectStackedStats(this.series);
			this._maxRunLength = stats.hmax;
			stats.hmin -= 0.5;
			stats.hmax += 0.5;
			this._calc(dim, stats);
			return this;
		}, render:function (dim, offsets) {
			if (this._maxRunLength <= 0) {
				return this;
			}
			var acc = df.repeat(this._maxRunLength, "-> 0", 0);
			for (var i = 0; i < this.series.length; ++i) {
				var run = this.series[i];
				for (var j = 0; j < run.data.length; ++j) {
					var value = run.data[j], v = typeof value == "number" ? value : value.y;
					if (isNaN(v)) {
						v = 0;
					}
					acc[j] += v;
				}
			}
			this.dirty = this.isDirty();
			if (this.dirty) {
				dojo.forEach(this.series, purgeGroup);
				this.cleanGroup();
				var s = this.group;
				df.forEachRev(this.series, function (item) {
					item.cleanGroup(s);
				});
			}
			var t = this.chart.theme, color, stroke, fill, f, gap, width, ht = this._hScaler.scaler.getTransformerFromModel(this._hScaler), vt = this._vScaler.scaler.getTransformerFromModel(this._vScaler), events = this.events();
			f = dc.calculateBarSize(this._hScaler.bounds.scale, this.opt);
			gap = f.gap;
			width = f.size;
			this.resetEvents();
			for (var i = this.series.length - 1; i >= 0; --i) {
				var run = this.series[i];
				if (!this.dirty && !run.dirty) {
					continue;
				}
				run.cleanGroup();
				var s = run.group;
				if (!run.fill || !run.stroke) {
					color = run.dyn.color = new dojo.Color(t.next("color"));
				}
				stroke = run.stroke ? run.stroke : dc.augmentStroke(t.series.stroke, color);
				fill = run.fill ? run.fill : dc.augmentFill(t.series.fill, color);
				for (var j = 0; j < acc.length; ++j) {
					var v = acc[j], height = vt(v), value = run.data[j], specialColor = color, specialFill = fill, specialStroke = stroke;
					if (typeof value != "number") {
						if (value.color) {
							specialColor = new dojo.Color(value.color);
						}
						if ("fill" in value) {
							specialFill = value.fill;
						} else {
							if (value.color) {
								specialFill = dc.augmentFill(t.series.fill, specialColor);
							}
						}
						if ("stroke" in value) {
							specialStroke = value.stroke;
						} else {
							if (value.color) {
								specialStroke = dc.augmentStroke(t.series.stroke, specialColor);
							}
						}
					}
					if (width >= 1 && height >= 1) {
						var shape = s.createRect({x:offsets.l + ht(j + 0.5) + gap, y:dim.height - offsets.b - vt(v), width:width, height:height}).setFill(specialFill).setStroke(specialStroke);
						run.dyn.fill = shape.getFill();
						run.dyn.stroke = shape.getStroke();
						if (events) {
							var o = {element:"column", index:j, run:run, plot:this, hAxis:this.hAxis || null, vAxis:this.vAxis || null, shape:shape, x:j + 0.5, y:v};
							this._connectEvents(shape, o);
						}
						if (this.animate) {
							this._animateColumn(shape, dim.height - offsets.b, height);
						}
					}
				}
				run.dirty = false;
				for (var j = 0; j < run.data.length; ++j) {
					var value = run.data[j], v = typeof value == "number" ? value : value.y;
					if (isNaN(v)) {
						v = 0;
					}
					acc[j] -= v;
				}
			}
			this.dirty = false;
			return this;
		}});
	})();
}
if (!dojo._hasResource["dojox.charting.plot2d.ClusteredColumns"]) {
	dojo._hasResource["dojox.charting.plot2d.ClusteredColumns"] = true;
	dojo.provide("dojox.charting.plot2d.ClusteredColumns");
	(function () {
		var df = dojox.lang.functional, dc = dojox.charting.plot2d.common, purgeGroup = df.lambda("item.purgeGroup()");
		dojo.declare("dojox.charting.plot2d.ClusteredColumns", dojox.charting.plot2d.Columns, {render:function (dim, offsets) {
			this.dirty = this.isDirty();
			if (this.dirty) {
				dojo.forEach(this.series, purgeGroup);
				this.cleanGroup();
				var s = this.group;
				df.forEachRev(this.series, function (item) {
					item.cleanGroup(s);
				});
			}
			var t = this.chart.theme, color, stroke, fill, f, gap, width, thickness, ht = this._hScaler.scaler.getTransformerFromModel(this._hScaler), vt = this._vScaler.scaler.getTransformerFromModel(this._vScaler), baseline = Math.max(0, this._vScaler.bounds.lower), baselineHeight = vt(baseline), events = this.events();
			f = dc.calculateBarSize(this._hScaler.bounds.scale, this.opt, this.series.length);
			gap = f.gap;
			width = thickness = f.size;
			this.resetEvents();
			for (var i = 0; i < this.series.length; ++i) {
				var run = this.series[i], shift = thickness * i;
				if (!this.dirty && !run.dirty) {
					continue;
				}
				run.cleanGroup();
				var s = run.group;
				if (!run.fill || !run.stroke) {
					color = run.dyn.color = new dojo.Color(t.next("color"));
				}
				stroke = run.stroke ? run.stroke : dc.augmentStroke(t.series.stroke, color);
				fill = run.fill ? run.fill : dc.augmentFill(t.series.fill, color);
				for (var j = 0; j < run.data.length; ++j) {
					var value = run.data[j], v = typeof value == "number" ? value : value.y, vv = vt(v), height = vv - baselineHeight, h = Math.abs(height), specialColor = color, specialFill = fill, specialStroke = stroke;
					if (typeof value != "number") {
						if (value.color) {
							specialColor = new dojo.Color(value.color);
						}
						if ("fill" in value) {
							specialFill = value.fill;
						} else {
							if (value.color) {
								specialFill = dc.augmentFill(t.series.fill, specialColor);
							}
						}
						if ("stroke" in value) {
							specialStroke = value.stroke;
						} else {
							if (value.color) {
								specialStroke = dc.augmentStroke(t.series.stroke, specialColor);
							}
						}
					}
					if (width >= 1 && h >= 1) {
						var shape = s.createRect({x:offsets.l + ht(j + 0.5) + gap + shift, y:dim.height - offsets.b - (v > baseline ? vv : baselineHeight), width:width, height:h}).setFill(specialFill).setStroke(specialStroke);
						run.dyn.fill = shape.getFill();
						run.dyn.stroke = shape.getStroke();
						if (events) {
							var o = {element:"column", index:j, run:run, plot:this, hAxis:this.hAxis || null, vAxis:this.vAxis || null, shape:shape, x:j + 0.5, y:v};
							this._connectEvents(shape, o);
						}
						if (this.animate) {
							this._animateColumn(shape, dim.height - offsets.b - baselineHeight, h);
						}
					}
				}
				run.dirty = false;
			}
			this.dirty = false;
			return this;
		}});
	})();
}
if (!dojo._hasResource["dojox.charting.plot2d.Bars"]) {
	dojo._hasResource["dojox.charting.plot2d.Bars"] = true;
	dojo.provide("dojox.charting.plot2d.Bars");
	(function () {
		var df = dojox.lang.functional, du = dojox.lang.utils, dc = dojox.charting.plot2d.common, purgeGroup = df.lambda("item.purgeGroup()");
		dojo.declare("dojox.charting.plot2d.Bars", dojox.charting.plot2d.Base, {defaultParams:{hAxis:"x", vAxis:"y", gap:0, shadows:null, animate:null}, optionalParams:{minBarSize:1, maxBarSize:1}, constructor:function (chart, kwArgs) {
			this.opt = dojo.clone(this.defaultParams);
			du.updateWithObject(this.opt, kwArgs);
			du.updateWithPattern(this.opt, kwArgs, this.optionalParams);
			this.series = [];
			this.hAxis = this.opt.hAxis;
			this.vAxis = this.opt.vAxis;
			this.animate = this.opt.animate;
		}, calculateAxes:function (dim) {
			var stats = dc.collectSimpleStats(this.series), t;
			stats.hmin -= 0.5;
			stats.hmax += 0.5;
			t = stats.hmin, stats.hmin = stats.vmin, stats.vmin = t;
			t = stats.hmax, stats.hmax = stats.vmax, stats.vmax = t;
			this._calc(dim, stats);
			return this;
		}, render:function (dim, offsets) {
			this.dirty = this.isDirty();
			if (this.dirty) {
				dojo.forEach(this.series, purgeGroup);
				this.cleanGroup();
				var s = this.group;
				df.forEachRev(this.series, function (item) {
					item.cleanGroup(s);
				});
			}
			var t = this.chart.theme, color, stroke, fill, f, gap, height, ht = this._hScaler.scaler.getTransformerFromModel(this._hScaler), vt = this._vScaler.scaler.getTransformerFromModel(this._vScaler), baseline = Math.max(0, this._hScaler.bounds.lower), baselineWidth = ht(baseline), events = this.events();
			f = dc.calculateBarSize(this._vScaler.bounds.scale, this.opt);
			gap = f.gap;
			height = f.size;
			this.resetEvents();
			for (var i = this.series.length - 1; i >= 0; --i) {
				var run = this.series[i];
				if (!this.dirty && !run.dirty) {
					continue;
				}
				run.cleanGroup();
				var s = run.group;
				if (!run.fill || !run.stroke) {
					color = run.dyn.color = new dojo.Color(t.next("color"));
				}
				stroke = run.stroke ? run.stroke : dc.augmentStroke(t.series.stroke, color);
				fill = run.fill ? run.fill : dc.augmentFill(t.series.fill, color);
				for (var j = 0; j < run.data.length; ++j) {
					var value = run.data[j], v = typeof value == "number" ? value : value.y, hv = ht(v), width = hv - baselineWidth, w = Math.abs(width), specialColor = color, specialFill = fill, specialStroke = stroke;
					if (typeof value != "number") {
						if (value.color) {
							specialColor = new dojo.Color(value.color);
						}
						if ("fill" in value) {
							specialFill = value.fill;
						} else {
							if (value.color) {
								specialFill = dc.augmentFill(t.series.fill, specialColor);
							}
						}
						if ("stroke" in value) {
							specialStroke = value.stroke;
						} else {
							if (value.color) {
								specialStroke = dc.augmentStroke(t.series.stroke, specialColor);
							}
						}
					}
					if (w >= 1 && height >= 1) {
						var shape = s.createRect({x:offsets.l + (v < baseline ? hv : baselineWidth), y:dim.height - offsets.b - vt(j + 1.5) + gap, width:w, height:height}).setFill(specialFill).setStroke(specialStroke);
						run.dyn.fill = shape.getFill();
						run.dyn.stroke = shape.getStroke();
						if (events) {
							var o = {element:"bar", index:j, run:run, plot:this, hAxis:this.hAxis || null, vAxis:this.vAxis || null, shape:shape, x:v, y:j + 1.5};
							this._connectEvents(shape, o);
						}
						if (this.animate) {
							this._animateBar(shape, offsets.l + baselineWidth, -w);
						}
					}
				}
				run.dirty = false;
			}
			this.dirty = false;
			return this;
		}, _animateBar:function (shape, hoffset, hsize) {
			dojox.gfx.fx.animateTransform(dojo.delegate({shape:shape, duration:1200, transform:[{name:"translate", start:[hoffset - (hoffset / hsize), 0], end:[0, 0]}, {name:"scale", start:[1 / hsize, 1], end:[1, 1]}, {name:"original"}]}, this.animate)).play();
		}});
	})();
}
if (!dojo._hasResource["dojox.charting.plot2d.StackedBars"]) {
	dojo._hasResource["dojox.charting.plot2d.StackedBars"] = true;
	dojo.provide("dojox.charting.plot2d.StackedBars");
	(function () {
		var df = dojox.lang.functional, dc = dojox.charting.plot2d.common, purgeGroup = df.lambda("item.purgeGroup()");
		dojo.declare("dojox.charting.plot2d.StackedBars", dojox.charting.plot2d.Bars, {calculateAxes:function (dim) {
			var stats = dc.collectStackedStats(this.series), t;
			this._maxRunLength = stats.hmax;
			stats.hmin -= 0.5;
			stats.hmax += 0.5;
			t = stats.hmin, stats.hmin = stats.vmin, stats.vmin = t;
			t = stats.hmax, stats.hmax = stats.vmax, stats.vmax = t;
			this._calc(dim, stats);
			return this;
		}, render:function (dim, offsets) {
			if (this._maxRunLength <= 0) {
				return this;
			}
			var acc = df.repeat(this._maxRunLength, "-> 0", 0);
			for (var i = 0; i < this.series.length; ++i) {
				var run = this.series[i];
				for (var j = 0; j < run.data.length; ++j) {
					var value = run.data[j], v = typeof value == "number" ? value : value.y;
					if (isNaN(v)) {
						v = 0;
					}
					acc[j] += v;
				}
			}
			this.dirty = this.isDirty();
			if (this.dirty) {
				dojo.forEach(this.series, purgeGroup);
				this.cleanGroup();
				var s = this.group;
				df.forEachRev(this.series, function (item) {
					item.cleanGroup(s);
				});
			}
			var t = this.chart.theme, color, stroke, fill, f, gap, height, ht = this._hScaler.scaler.getTransformerFromModel(this._hScaler), vt = this._vScaler.scaler.getTransformerFromModel(this._vScaler), events = this.events();
			f = dc.calculateBarSize(this._vScaler.bounds.scale, this.opt);
			gap = f.gap;
			height = f.size;
			this.resetEvents();
			for (var i = this.series.length - 1; i >= 0; --i) {
				var run = this.series[i];
				if (!this.dirty && !run.dirty) {
					continue;
				}
				run.cleanGroup();
				var s = run.group;
				if (!run.fill || !run.stroke) {
					color = run.dyn.color = new dojo.Color(t.next("color"));
				}
				stroke = run.stroke ? run.stroke : dc.augmentStroke(t.series.stroke, color);
				fill = run.fill ? run.fill : dc.augmentFill(t.series.fill, color);
				for (var j = 0; j < acc.length; ++j) {
					var v = acc[j], width = ht(v), value = run.data[j], specialColor = color, specialFill = fill, specialStroke = stroke;
					if (typeof value != "number") {
						if (value.color) {
							specialColor = new dojo.Color(value.color);
						}
						if ("fill" in value) {
							specialFill = value.fill;
						} else {
							if (value.color) {
								specialFill = dc.augmentFill(t.series.fill, specialColor);
							}
						}
						if ("stroke" in value) {
							specialStroke = value.stroke;
						} else {
							if (value.color) {
								specialStroke = dc.augmentStroke(t.series.stroke, specialColor);
							}
						}
					}
					if (width >= 1 && height >= 1) {
						var shape = s.createRect({x:offsets.l, y:dim.height - offsets.b - vt(j + 1.5) + gap, width:width, height:height}).setFill(specialFill).setStroke(specialStroke);
						run.dyn.fill = shape.getFill();
						run.dyn.stroke = shape.getStroke();
						if (events) {
							var o = {element:"bar", index:j, run:run, plot:this, hAxis:this.hAxis || null, vAxis:this.vAxis || null, shape:shape, x:v, y:j + 1.5};
							this._connectEvents(shape, o);
						}
						if (this.animate) {
							this._animateBar(shape, offsets.l, -width);
						}
					}
				}
				run.dirty = false;
				for (var j = 0; j < run.data.length; ++j) {
					var value = run.data[j], v = typeof value == "number" ? value : value.y;
					if (isNaN(v)) {
						v = 0;
					}
					acc[j] -= v;
				}
			}
			this.dirty = false;
			return this;
		}});
	})();
}
if (!dojo._hasResource["dojox.charting.plot2d.ClusteredBars"]) {
	dojo._hasResource["dojox.charting.plot2d.ClusteredBars"] = true;
	dojo.provide("dojox.charting.plot2d.ClusteredBars");
	(function () {
		var df = dojox.lang.functional, dc = dojox.charting.plot2d.common, purgeGroup = df.lambda("item.purgeGroup()");
		dojo.declare("dojox.charting.plot2d.ClusteredBars", dojox.charting.plot2d.Bars, {render:function (dim, offsets) {
			this.dirty = this.isDirty();
			if (this.dirty) {
				dojo.forEach(this.series, purgeGroup);
				this.cleanGroup();
				var s = this.group;
				df.forEachRev(this.series, function (item) {
					item.cleanGroup(s);
				});
			}
			var t = this.chart.theme, color, stroke, fill, f, gap, height, thickness, ht = this._hScaler.scaler.getTransformerFromModel(this._hScaler), vt = this._vScaler.scaler.getTransformerFromModel(this._vScaler), baseline = Math.max(0, this._hScaler.bounds.lower), baselineWidth = ht(baseline), events = this.events();
			f = dc.calculateBarSize(this._vScaler.bounds.scale, this.opt, this.series.length);
			gap = f.gap;
			height = thickness = f.size;
			this.resetEvents();
			for (var i = this.series.length - 1; i >= 0; --i) {
				var run = this.series[i], shift = thickness * (this.series.length - i - 1);
				if (!this.dirty && !run.dirty) {
					continue;
				}
				run.cleanGroup();
				var s = run.group;
				if (!run.fill || !run.stroke) {
					color = run.dyn.color = new dojo.Color(t.next("color"));
				}
				stroke = run.stroke ? run.stroke : dc.augmentStroke(t.series.stroke, color);
				fill = run.fill ? run.fill : dc.augmentFill(t.series.fill, color);
				for (var j = 0; j < run.data.length; ++j) {
					var value = run.data[j], v = typeof value == "number" ? value : value.y, hv = ht(v), width = hv - baselineWidth, w = Math.abs(width), specialColor = color, specialFill = fill, specialStroke = stroke;
					if (typeof value != "number") {
						if (value.color) {
							specialColor = new dojo.Color(value.color);
						}
						if ("fill" in value) {
							specialFill = value.fill;
						} else {
							if (value.color) {
								specialFill = dc.augmentFill(t.series.fill, specialColor);
							}
						}
						if ("stroke" in value) {
							specialStroke = value.stroke;
						} else {
							if (value.color) {
								specialStroke = dc.augmentStroke(t.series.stroke, specialColor);
							}
						}
					}
					if (w >= 1 && height >= 1) {
						var shape = s.createRect({x:offsets.l + (v < baseline ? hv : baselineWidth), y:dim.height - offsets.b - vt(j + 1.5) + gap + shift, width:w, height:height}).setFill(specialFill).setStroke(specialStroke);
						run.dyn.fill = shape.getFill();
						run.dyn.stroke = shape.getStroke();
						if (events) {
							var o = {element:"bar", index:j, run:run, plot:this, hAxis:this.hAxis || null, vAxis:this.vAxis || null, shape:shape, x:v, y:j + 1.5};
							this._connectEvents(shape, o);
						}
						if (this.animate) {
							this._animateBar(shape, offsets.l + baselineWidth, -width);
						}
					}
				}
				run.dirty = false;
			}
			this.dirty = false;
			return this;
		}});
	})();
}
if (!dojo._hasResource["dojox.charting.plot2d.Grid"]) {
	dojo._hasResource["dojox.charting.plot2d.Grid"] = true;
	dojo.provide("dojox.charting.plot2d.Grid");
	(function () {
		var du = dojox.lang.utils;
		dojo.declare("dojox.charting.plot2d.Grid", dojox.charting.Element, {defaultParams:{hAxis:"x", vAxis:"y", hMajorLines:true, hMinorLines:false, vMajorLines:true, vMinorLines:false, hStripes:"none", vStripes:"none"}, optionalParams:{}, constructor:function (chart, kwArgs) {
			this.opt = dojo.clone(this.defaultParams);
			du.updateWithObject(this.opt, kwArgs);
			this.hAxis = this.opt.hAxis;
			this.vAxis = this.opt.vAxis;
			this.dirty = true;
		}, clear:function () {
			this._hAxis = null;
			this._vAxis = null;
			this.dirty = true;
			return this;
		}, setAxis:function (axis) {
			if (axis) {
				this[axis.vertical ? "_vAxis" : "_hAxis"] = axis;
			}
			return this;
		}, addSeries:function (run) {
			return this;
		}, calculateAxes:function (dim) {
			return this;
		}, isDirty:function () {
			return this.dirty || this._hAxis && this._hAxis.dirty || this._vAxis && this._vAxis.dirty;
		}, getRequiredColors:function () {
			return 0;
		}, render:function (dim, offsets) {
			this.dirty = this.isDirty();
			if (!this.dirty) {
				return this;
			}
			this.cleanGroup();
			var s = this.group, ta = this.chart.theme.axis;
			try {
				var vScaler = this._vAxis.getScaler(), vt = vScaler.scaler.getTransformerFromModel(vScaler), ticks = this._vAxis.getTicks();
				if (this.opt.hMinorLines) {
					dojo.forEach(ticks.minor, function (tick) {
						var y = dim.height - offsets.b - vt(tick.value);
						s.createLine({x1:offsets.l, y1:y, x2:dim.width - offsets.r, y2:y}).setStroke(ta.minorTick);
					});
				}
				if (this.opt.hMajorLines) {
					dojo.forEach(ticks.major, function (tick) {
						var y = dim.height - offsets.b - vt(tick.value);
						s.createLine({x1:offsets.l, y1:y, x2:dim.width - offsets.r, y2:y}).setStroke(ta.majorTick);
					});
				}
			}
			catch (e) {
			}
			try {
				var hScaler = this._hAxis.getScaler(), ht = hScaler.scaler.getTransformerFromModel(hScaler), ticks = this._hAxis.getTicks();
				if (ticks && this.opt.vMinorLines) {
					dojo.forEach(ticks.minor, function (tick) {
						var x = offsets.l + ht(tick.value);
						s.createLine({x1:x, y1:offsets.t, x2:x, y2:dim.height - offsets.b}).setStroke(ta.minorTick);
					});
				}
				if (ticks && this.opt.vMajorLines) {
					dojo.forEach(ticks.major, function (tick) {
						var x = offsets.l + ht(tick.value);
						s.createLine({x1:x, y1:offsets.t, x2:x, y2:dim.height - offsets.b}).setStroke(ta.majorTick);
					});
				}
			}
			catch (e) {
			}
			this.dirty = false;
			return this;
		}});
	})();
}
if (!dojo._hasResource["dojox.charting.plot2d.Pie"]) {
	dojo._hasResource["dojox.charting.plot2d.Pie"] = true;
	dojo.provide("dojox.charting.plot2d.Pie");
	(function () {
		var df = dojox.lang.functional, du = dojox.lang.utils, dc = dojox.charting.plot2d.common, da = dojox.charting.axis2d.common, g = dojox.gfx;
		dojo.declare("dojox.charting.plot2d.Pie", dojox.charting.Element, {defaultParams:{labels:true, ticks:false, fixed:true, precision:1, labelOffset:20, labelStyle:"default", htmlLabels:true}, optionalParams:{font:"", fontColor:"", radius:0}, constructor:function (chart, kwArgs) {
			this.opt = dojo.clone(this.defaultParams);
			du.updateWithObject(this.opt, kwArgs);
			du.updateWithPattern(this.opt, kwArgs, this.optionalParams);
			this.run = null;
			this.dyn = [];
		}, destroy:function () {
			this.resetEvents();
			this.inherited(arguments);
		}, clear:function () {
			this.dirty = true;
			this.dyn = [];
			this.run = null;
			return this;
		}, setAxis:function (axis) {
			return this;
		}, addSeries:function (run) {
			this.run = run;
			return this;
		}, calculateAxes:function (dim) {
			return this;
		}, getRequiredColors:function () {
			return this.run ? this.run.data.length : 0;
		}, plotEvent:function (o) {
		}, connect:function (object, method) {
			this.dirty = true;
			return dojo.connect(this, "plotEvent", object, method);
		}, events:function () {
			var ls = this.plotEvent._listeners;
			if (!ls || !ls.length) {
				return false;
			}
			for (var i in ls) {
				if (!(i in Array.prototype)) {
					return true;
				}
			}
			return false;
		}, resetEvents:function () {
			this.plotEvent({type:"onplotreset", plot:this});
		}, _connectEvents:function (shape, o) {
			shape.connect("onmouseover", this, function (e) {
				o.type = "onmouseover";
				o.event = e;
				this.plotEvent(o);
			});
			shape.connect("onmouseout", this, function (e) {
				o.type = "onmouseout";
				o.event = e;
				this.plotEvent(o);
			});
			shape.connect("onclick", this, function (e) {
				o.type = "onclick";
				o.event = e;
				this.plotEvent(o);
			});
		}, render:function (dim, offsets) {
			if (!this.dirty) {
				return this;
			}
			this.dirty = false;
			this.cleanGroup();
			var s = this.group, color, t = this.chart.theme;
			this.resetEvents();
			if (!this.run || !this.run.data.length) {
				return this;
			}
			var rx = (dim.width - offsets.l - offsets.r) / 2, ry = (dim.height - offsets.t - offsets.b) / 2, r = Math.min(rx, ry), taFont = "font" in this.opt ? this.opt.font : t.axis.font, size = taFont ? g.normalizedLength(g.splitFontString(taFont).size) : 0, taFontColor = "fontColor" in this.opt ? this.opt.fontColor : t.axis.fontColor, start = 0, step, filteredRun, slices, labels, shift, labelR, run = this.run.data, events = this.events();
			if (typeof run[0] == "number") {
				filteredRun = df.map(run, "Math.max(x, 0)");
				if (df.every(filteredRun, "<= 0")) {
					return this;
				}
				slices = df.map(filteredRun, "/this", df.foldl(filteredRun, "+", 0));
				if (this.opt.labels) {
					labels = dojo.map(slices, function (x) {
						return x > 0 ? this._getLabel(x * 100) + "%" : "";
					}, this);
				}
			} else {
				filteredRun = df.map(run, "Math.max(x.y, 0)");
				if (df.every(filteredRun, "<= 0")) {
					return this;
				}
				slices = df.map(filteredRun, "/this", df.foldl(filteredRun, "+", 0));
				if (this.opt.labels) {
					labels = dojo.map(slices, function (x, i) {
						if (x <= 0) {
							return "";
						}
						var v = run[i];
						return "text" in v ? v.text : this._getLabel(x * 100) + "%";
					}, this);
				}
			}
			if (this.opt.labels) {
				shift = df.foldl1(df.map(labels, function (label) {
					return dojox.gfx._base._getTextBox(label, {font:taFont}).w;
				}, this), "Math.max(a, b)") / 2;
				if (this.opt.labelOffset < 0) {
					r = Math.min(rx - 2 * shift, ry - size) + this.opt.labelOffset;
				}
				labelR = r - this.opt.labelOffset;
			}
			if ("radius" in this.opt) {
				r = this.opt.radius;
				labelR = r - this.opt.labelOffset;
			}
			var circle = {cx:offsets.l + rx, cy:offsets.t + ry, r:r};
			this.dyn = [];
			dojo.some(slices, function (slice, i) {
				if (slice <= 0) {
					return false;
				}
				var v = run[i];
				if (slice >= 1) {
					var color, fill, stroke;
					if (typeof v == "object") {
						color = "color" in v ? v.color : new dojo.Color(t.next("color"));
						fill = "fill" in v ? v.fill : dc.augmentFill(t.series.fill, color);
						stroke = "stroke" in v ? v.stroke : dc.augmentStroke(t.series.stroke, color);
					} else {
						color = new dojo.Color(t.next("color"));
						fill = dc.augmentFill(t.series.fill, color);
						stroke = dc.augmentStroke(t.series.stroke, color);
					}
					var shape = s.createCircle(circle).setFill(fill).setStroke(stroke);
					this.dyn.push({color:color, fill:fill, stroke:stroke});
					if (events) {
						var o = {element:"slice", index:i, run:this.run, plot:this, shape:shape, x:i, y:typeof v == "number" ? v : v.y, cx:circle.cx, cy:circle.cy, cr:r};
						this._connectEvents(shape, o);
					}
					return true;
				}
				var end = start + slice * 2 * Math.PI;
				if (i + 1 == slices.length) {
					end = 2 * Math.PI;
				}
				var step = end - start, x1 = circle.cx + r * Math.cos(start), y1 = circle.cy + r * Math.sin(start), x2 = circle.cx + r * Math.cos(end), y2 = circle.cy + r * Math.sin(end);
				var color, fill, stroke;
				if (typeof v == "object") {
					color = "color" in v ? v.color : new dojo.Color(t.next("color"));
					fill = "fill" in v ? v.fill : dc.augmentFill(t.series.fill, color);
					stroke = "stroke" in v ? v.stroke : dc.augmentStroke(t.series.stroke, color);
				} else {
					color = new dojo.Color(t.next("color"));
					fill = dc.augmentFill(t.series.fill, color);
					stroke = dc.augmentStroke(t.series.stroke, color);
				}
				var shape = s.createPath({}).moveTo(circle.cx, circle.cy).lineTo(x1, y1).arcTo(r, r, 0, step > Math.PI, true, x2, y2).lineTo(circle.cx, circle.cy).closePath().setFill(fill).setStroke(stroke);
				this.dyn.push({color:color, fill:fill, stroke:stroke});
				if (events) {
					var o = {element:"slice", index:i, run:this.run, plot:this, shape:shape, x:i, y:typeof v == "number" ? v : v.y, cx:circle.cx, cy:circle.cy, cr:r};
					this._connectEvents(shape, o);
				}
				start = end;
				return false;
			}, this);
			if (this.opt.labels) {
				start = 0;
				dojo.some(slices, function (slice, i) {
					if (slice <= 0) {
						return false;
					}
					if (slice >= 1) {
						var v = run[i], elem = da.createText[this.opt.htmlLabels && dojox.gfx.renderer != "vml" ? "html" : "gfx"](this.chart, s, circle.cx, circle.cy + size / 2, "middle", labels[i], taFont, (typeof v == "object" && "fontColor" in v) ? v.fontColor : taFontColor);
						if (this.opt.htmlLabels) {
							this.htmlElements.push(elem);
						}
						return true;
					}
					var end = start + slice * 2 * Math.PI, v = run[i];
					if (i + 1 == slices.length) {
						end = 2 * Math.PI;
					}
					var labelAngle = (start + end) / 2, x = circle.cx + labelR * Math.cos(labelAngle), y = circle.cy + labelR * Math.sin(labelAngle) + size / 2;
					var elem = da.createText[this.opt.htmlLabels && dojox.gfx.renderer != "vml" ? "html" : "gfx"](this.chart, s, x, y, "middle", labels[i], taFont, (typeof v == "object" && "fontColor" in v) ? v.fontColor : taFontColor);
					if (this.opt.htmlLabels) {
						this.htmlElements.push(elem);
					}
					start = end;
					return false;
				}, this);
			}
			return this;
		}, _getLabel:function (number) {
			return this.opt.fixed ? number.toFixed(this.opt.precision) : number.toString();
		}});
	})();
}
if (!dojo._hasResource["dojox.charting.plot2d.Bubble"]) {
	dojo._hasResource["dojox.charting.plot2d.Bubble"] = true;
	dojo.provide("dojox.charting.plot2d.Bubble");
	(function () {
		var df = dojox.lang.functional, du = dojox.lang.utils, dc = dojox.charting.plot2d.common, purgeGroup = df.lambda("item.purgeGroup()");
		dojo.declare("dojox.charting.plot2d.Bubble", dojox.charting.plot2d.Base, {defaultParams:{hAxis:"x", vAxis:"y"}, optionalParams:{}, constructor:function (chart, kwArgs) {
			this.opt = dojo.clone(this.defaultParams);
			du.updateWithObject(this.opt, kwArgs);
			this.series = [];
			this.hAxis = this.opt.hAxis;
			this.vAxis = this.opt.vAxis;
		}, calculateAxes:function (dim) {
			this._calc(dim, dc.collectSimpleStats(this.series));
			return this;
		}, render:function (dim, offsets) {
			this.dirty = this.isDirty();
			if (this.dirty) {
				dojo.forEach(this.series, purgeGroup);
				this.cleanGroup();
				var s = this.group;
				df.forEachRev(this.series, function (item) {
					item.cleanGroup(s);
				});
			}
			var t = this.chart.theme, stroke, outline, color, shadowStroke, shadowColor, ht = this._hScaler.scaler.getTransformerFromModel(this._hScaler), vt = this._vScaler.scaler.getTransformerFromModel(this._vScaler), events = this.events();
			this.resetEvents();
			for (var i = this.series.length - 1; i >= 0; --i) {
				var run = this.series[i];
				if (!this.dirty && !run.dirty) {
					continue;
				}
				run.cleanGroup();
				if (!run.data.length) {
					run.dirty = false;
					continue;
				}
				if (typeof run.data[0] == "number") {
					console.warn("dojox.charting.plot2d.Bubble: the data in the following series cannot be rendered as a bubble chart; ", run);
					continue;
				}
				var s = run.group, points = dojo.map(run.data, function (v, i) {
					return {x:ht(v.x) + offsets.l, y:dim.height - offsets.b - vt(v.y), radius:this._vScaler.bounds.scale * (v.size / 2)};
				}, this);
				if (run.fill) {
					color = run.fill;
				} else {
					if (run.stroke) {
						color = run.stroke;
					} else {
						color = run.dyn.color = new dojo.Color(t.next("color"));
					}
				}
				run.dyn.fill = color;
				stroke = run.dyn.stroke = run.stroke ? dc.makeStroke(run.stroke) : dc.augmentStroke(t.series.stroke, color);
				var frontCircles = null, outlineCircles = null, shadowCircles = null;
				if (this.opt.shadows && stroke) {
					var sh = this.opt.shadows, shadowColor = new dojo.Color([0, 0, 0, 0.2]), shadowStroke = dojo.clone(outline ? outline : stroke);
					shadowStroke.color = shadowColor;
					shadowStroke.width += sh.dw ? sh.dw : 0;
					run.dyn.shadow = shadowStroke;
					var shadowMarkers = dojo.map(points, function (item) {
						var sh = this.opt.shadows;
						return s.createCircle({cx:item.x + sh.dx, cy:item.y + sh.dy, r:item.radius}).setStroke(shadowStroke).setFill(shadowColor);
					}, this);
				}
				if (run.outline || t.series.outline) {
					outline = dc.makeStroke(run.outline ? run.outline : t.series.outline);
					outline.width = 2 * outline.width + stroke.width;
					run.dyn.outline = outline;
					outlineCircles = dojo.map(points, function (item) {
						s.createCircle({cx:item.x, cy:item.y, r:item.radius}).setStroke(outline);
					}, this);
				}
				frontCircles = dojo.map(points, function (item) {
					return s.createCircle({cx:item.x, cy:item.y, r:item.radius}).setStroke(stroke).setFill(color);
				}, this);
				if (events) {
					dojo.forEach(frontCircles, function (s, i) {
						var o = {element:"circle", index:i, run:run, plot:this, hAxis:this.hAxis || null, vAxis:this.vAxis || null, shape:s, outline:outlineCircles && outlineCircles[i] || null, shadow:shadowCircles && shadowCircles[i] || null, x:run.data[i].x, y:run.data[i].y, r:run.data[i].size / 2, cx:points[i].x, cy:points[i].y, cr:points[i].radius};
						this._connectEvents(s, o);
					}, this);
				}
				run.dirty = false;
			}
			this.dirty = false;
			return this;
		}});
	})();
}
if (!dojo._hasResource["dojox.charting.plot2d.Candlesticks"]) {
	dojo._hasResource["dojox.charting.plot2d.Candlesticks"] = true;
	dojo.provide("dojox.charting.plot2d.Candlesticks");
	(function () {
		var df = dojox.lang.functional, du = dojox.lang.utils, dc = dojox.charting.plot2d.common, purgeGroup = df.lambda("item.purgeGroup()");
		dojo.declare("dojox.charting.plot2d.Candlesticks", dojox.charting.plot2d.Base, {defaultParams:{hAxis:"x", vAxis:"y", gap:2, shadows:null}, optionalParams:{minBarSize:1, maxBarSize:1}, constructor:function (chart, kwArgs) {
			this.opt = dojo.clone(this.defaultParams);
			du.updateWithObject(this.opt, kwArgs);
			du.updateWithPattern(this.opt, kwArgs, this.optionalParams);
			this.series = [];
			this.hAxis = this.opt.hAxis;
			this.vAxis = this.opt.vAxis;
		}, collectStats:function (series) {
			var stats = dojo.clone(dc.defaultStats);
			for (var i = 0; i < series.length; i++) {
				var run = series[i];
				if (!run.data.length) {
					continue;
				}
				var old_vmin = stats.vmin, old_vmax = stats.vmax;
				if (!("ymin" in run) || !("ymax" in run)) {
					dojo.forEach(run.data, function (val, idx) {
						var x = val.x || idx + 1;
						stats.hmin = Math.min(stats.hmin, x);
						stats.hmax = Math.max(stats.hmax, x);
						stats.vmin = Math.min(stats.vmin, val.open, val.close, val.high, val.low);
						stats.vmax = Math.max(stats.vmax, val.open, val.close, val.high, val.low);
					});
				}
				if ("ymin" in run) {
					stats.vmin = Math.min(old_vmin, run.ymin);
				}
				if ("ymax" in run) {
					stats.vmax = Math.max(old_vmax, run.ymax);
				}
			}
			return stats;
		}, calculateAxes:function (dim) {
			var stats = this.collectStats(this.series), t;
			stats.hmin -= 0.5;
			stats.hmax += 0.5;
			this._calc(dim, stats);
			return this;
		}, render:function (dim, offsets) {
			this.dirty = this.isDirty();
			if (this.dirty) {
				dojo.forEach(this.series, purgeGroup);
				this.cleanGroup();
				var s = this.group;
				df.forEachRev(this.series, function (item) {
					item.cleanGroup(s);
				});
			}
			var t = this.chart.theme, color, stroke, fill, f, gap, width, ht = this._hScaler.scaler.getTransformerFromModel(this._hScaler), vt = this._vScaler.scaler.getTransformerFromModel(this._vScaler), baseline = Math.max(0, this._vScaler.bounds.lower), baselineHeight = vt(baseline), events = this.events();
			f = dc.calculateBarSize(this._hScaler.bounds.scale, this.opt);
			gap = f.gap;
			width = f.size;
			this.resetEvents();
			for (var i = this.series.length - 1; i >= 0; --i) {
				var run = this.series[i];
				if (!this.dirty && !run.dirty) {
					continue;
				}
				run.cleanGroup();
				var s = run.group;
				if (!run.fill || !run.stroke) {
					color = run.dyn.color = new dojo.Color(t.next("color"));
				}
				stroke = run.stroke ? run.stroke : dc.augmentStroke(t.series.stroke, color);
				fill = run.fill ? run.fill : dc.augmentFill(t.series.fill, color);
				for (var j = 0; j < run.data.length; ++j) {
					var v = run.data[j];
					var x = ht(v.x || (j + 0.5)) + offsets.l + gap, y = dim.height - offsets.b, open = vt(v.open), close = vt(v.close), high = vt(v.high), low = vt(v.low);
					if ("mid" in v) {
						var mid = vt(v.mid);
					}
					if (low > high) {
						var tmp = high;
						high = low;
						low = tmp;
					}
					if (width >= 1) {
						var doFill = open > close;
						var line = {x1:width / 2, x2:width / 2, y1:y - high, y2:y - low}, rect = {x:0, y:y - Math.max(open, close), width:width, height:Math.max(doFill ? open - close : close - open, 1)};
						shape = s.createGroup();
						shape.setTransform({dx:x, dy:0});
						var inner = shape.createGroup();
						inner.createLine(line).setStroke(stroke);
						inner.createRect(rect).setStroke(stroke).setFill(doFill ? fill : "white");
						if ("mid" in v) {
							inner.createLine({x1:(stroke.width || 1), x2:width - (stroke.width || 1), y1:y - mid, y2:y - mid}).setStroke(doFill ? {color:"white"} : stroke);
						}
						run.dyn.fill = fill;
						run.dyn.stroke = stroke;
						if (events) {
							var o = {element:"candlestick", index:j, run:run, plot:this, hAxis:this.hAxis || null, vAxis:this.vAxis || null, shape:inner, x:x, y:y - Math.max(open, close), cx:width / 2, cy:(y - Math.max(open, close)) + (Math.max(doFill ? open - close : close - open, 1) / 2), width:width, height:Math.max(doFill ? open - close : close - open, 1), data:v};
							this._connectEvents(shape, o);
						}
					}
				}
				run.dirty = false;
			}
			this.dirty = false;
			return this;
		}});
	})();
}
if (!dojo._hasResource["dojox.charting.plot2d.OHLC"]) {
	dojo._hasResource["dojox.charting.plot2d.OHLC"] = true;
	dojo.provide("dojox.charting.plot2d.OHLC");
	(function () {
		var df = dojox.lang.functional, du = dojox.lang.utils, dc = dojox.charting.plot2d.common, purgeGroup = df.lambda("item.purgeGroup()");
		dojo.declare("dojox.charting.plot2d.OHLC", dojox.charting.plot2d.Base, {defaultParams:{hAxis:"x", vAxis:"y", gap:2, shadows:null}, optionalParams:{minBarSize:1, maxBarSize:1}, constructor:function (chart, kwArgs) {
			this.opt = dojo.clone(this.defaultParams);
			du.updateWithObject(this.opt, kwArgs);
			du.updateWithPattern(this.opt, kwArgs, this.optionalParams);
			this.series = [];
			this.hAxis = this.opt.hAxis;
			this.vAxis = this.opt.vAxis;
		}, collectStats:function (series) {
			var stats = dojo.clone(dc.defaultStats);
			for (var i = 0; i < series.length; i++) {
				var run = series[i];
				if (!run.data.length) {
					continue;
				}
				var old_vmin = stats.vmin, old_vmax = stats.vmax;
				if (!("ymin" in run) || !("ymax" in run)) {
					dojo.forEach(run.data, function (val, idx) {
						var x = val.x || idx + 1;
						stats.hmin = Math.min(stats.hmin, x);
						stats.hmax = Math.max(stats.hmax, x);
						stats.vmin = Math.min(stats.vmin, val.open, val.close, val.high, val.low);
						stats.vmax = Math.max(stats.vmax, val.open, val.close, val.high, val.low);
					});
				}
				if ("ymin" in run) {
					stats.vmin = Math.min(old_vmin, run.ymin);
				}
				if ("ymax" in run) {
					stats.vmax = Math.max(old_vmax, run.ymax);
				}
			}
			return stats;
		}, calculateAxes:function (dim) {
			var stats = this.collectStats(this.series), t;
			stats.hmin -= 0.5;
			stats.hmax += 0.5;
			this._calc(dim, stats);
			return this;
		}, render:function (dim, offsets) {
			this.dirty = this.isDirty();
			if (this.dirty) {
				dojo.forEach(this.series, purgeGroup);
				this.cleanGroup();
				var s = this.group;
				df.forEachRev(this.series, function (item) {
					item.cleanGroup(s);
				});
			}
			var t = this.chart.theme, color, stroke, fill, f, gap, width, ht = this._hScaler.scaler.getTransformerFromModel(this._hScaler), vt = this._vScaler.scaler.getTransformerFromModel(this._vScaler), baseline = Math.max(0, this._vScaler.bounds.lower), baselineHeight = vt(baseline), events = this.events();
			f = dc.calculateBarSize(this._hScaler.bounds.scale, this.opt);
			gap = f.gap;
			width = f.size;
			this.resetEvents();
			for (var i = this.series.length - 1; i >= 0; --i) {
				var run = this.series[i];
				if (!this.dirty && !run.dirty) {
					continue;
				}
				run.cleanGroup();
				var s = run.group;
				if (!run.fill || !run.stroke) {
					color = run.dyn.color = new dojo.Color(t.next("color"));
				}
				stroke = run.stroke ? run.stroke : dc.augmentStroke(t.series.stroke, color);
				fill = run.fill ? run.fill : dc.augmentFill(t.series.fill, color);
				for (var j = 0; j < run.data.length; ++j) {
					var v = run.data[j];
					var x = ht(v.x || (j + 0.5)) + offsets.l + gap, y = dim.height - offsets.b, open = vt(v.open), close = vt(v.close), high = vt(v.high), low = vt(v.low);
					if (low > high) {
						var tmp = high;
						high = low;
						low = tmp;
					}
					if (width >= 1) {
						var hl = {x1:width / 2, x2:width / 2, y1:y - high, y2:y - low}, op = {x1:0, x2:((width / 2) + ((stroke.width || 1) / 2)), y1:y - open, y2:y - open}, cl = {x1:((width / 2) - ((stroke.width || 1) / 2)), x2:width, y1:y - close, y2:y - close};
						shape = s.createGroup();
						shape.setTransform({dx:x, dy:0});
						var inner = shape.createGroup();
						inner.createLine(hl).setStroke(stroke);
						inner.createLine(op).setStroke(stroke);
						inner.createLine(cl).setStroke(stroke);
						run.dyn.fill = fill;
						run.dyn.stroke = stroke;
						if (events) {
							var o = {element:"candlestick", index:j, run:run, plot:this, hAxis:this.hAxis || null, vAxis:this.vAxis || null, shape:inner, x:x, y:y - Math.max(open, close), cx:width / 2, cy:(y - Math.max(open, close)) + (Math.max(open > close ? open - close : close - open, 1) / 2), width:width, height:Math.max(open > close ? open - close : close - open, 1), data:v};
							this._connectEvents(shape, o);
						}
					}
				}
				run.dirty = false;
			}
			this.dirty = false;
			return this;
		}});
	})();
}
if (!dojo._hasResource["dojox.charting.Chart2D"]) {
	dojo._hasResource["dojox.charting.Chart2D"] = true;
	dojo.provide("dojox.charting.Chart2D");
	(function () {
		var df = dojox.lang.functional, dc = dojox.charting, clear = df.lambda("item.clear()"), purge = df.lambda("item.purgeGroup()"), destroy = df.lambda("item.destroy()"), makeClean = df.lambda("item.dirty = false"), makeDirty = df.lambda("item.dirty = true");
		dojo.declare("dojox.charting.Chart2D", null, {constructor:function (node, kwArgs) {
			if (!kwArgs) {
				kwArgs = {};
			}
			this.margins = kwArgs.margins ? kwArgs.margins : {l:10, t:10, r:10, b:10};
			this.stroke = kwArgs.stroke;
			this.fill = kwArgs.fill;
			this.theme = null;
			this.axes = {};
			this.stack = [];
			this.plots = {};
			this.series = [];
			this.runs = {};
			this.dirty = true;
			this.coords = null;
			this.node = dojo.byId(node);
			var box = dojo.marginBox(node);
			this.surface = dojox.gfx.createSurface(this.node, box.w, box.h);
		}, destroy:function () {
			dojo.forEach(this.series, destroy);
			dojo.forEach(this.stack, destroy);
			df.forIn(this.axes, destroy);
			this.surface.destroy();
		}, getCoords:function () {
			if (!this.coords) {
				this.coords = dojo.coords(this.node, true);
			}
			return this.coords;
		}, setTheme:function (theme) {
			this.theme = theme._clone();
			this.dirty = true;
			return this;
		}, addAxis:function (name, kwArgs) {
			var axis;
			if (!kwArgs || !("type" in kwArgs)) {
				axis = new dc.axis2d.Default(this, kwArgs);
			} else {
				axis = typeof kwArgs.type == "string" ? new dc.axis2d[kwArgs.type](this, kwArgs) : new kwArgs.type(this, kwArgs);
			}
			axis.name = name;
			axis.dirty = true;
			if (name in this.axes) {
				this.axes[name].destroy();
			}
			this.axes[name] = axis;
			this.dirty = true;
			return this;
		}, getAxis:function (name) {
			return this.axes[name];
		}, removeAxis:function (name) {
			if (name in this.axes) {
				this.axes[name].destroy();
				delete this.axes[name];
				this.dirty = true;
			}
			return this;
		}, addPlot:function (name, kwArgs) {
			var plot;
			if (!kwArgs || !("type" in kwArgs)) {
				plot = new dc.plot2d.Default(this, kwArgs);
			} else {
				plot = typeof kwArgs.type == "string" ? new dc.plot2d[kwArgs.type](this, kwArgs) : new kwArgs.type(this, kwArgs);
			}
			plot.name = name;
			plot.dirty = true;
			if (name in this.plots) {
				this.stack[this.plots[name]].destroy();
				this.stack[this.plots[name]] = plot;
			} else {
				this.plots[name] = this.stack.length;
				this.stack.push(plot);
			}
			this.dirty = true;
			return this;
		}, removePlot:function (name) {
			if (name in this.plots) {
				var index = this.plots[name];
				delete this.plots[name];
				this.stack[index].destroy();
				this.stack.splice(index, 1);
				df.forIn(this.plots, function (idx, name, plots) {
					if (idx > index) {
						plots[name] = idx - 1;
					}
				});
				this.dirty = true;
			}
			return this;
		}, addSeries:function (name, data, kwArgs) {
			var run = new dc.Series(this, data, kwArgs);
			if (name in this.runs) {
				this.series[this.runs[name]].destroy();
				this.series[this.runs[name]] = run;
			} else {
				this.runs[name] = this.series.length;
				this.series.push(run);
			}
			run.name = name;
			this.dirty = true;
			if (!("ymin" in run) && "min" in run) {
				run.ymin = run.min;
			}
			if (!("ymax" in run) && "max" in run) {
				run.ymax = run.max;
			}
			return this;
		}, removeSeries:function (name) {
			if (name in this.runs) {
				var index = this.runs[name], plotName = this.series[index].plot;
				delete this.runs[name];
				this.series[index].destroy();
				this.series.splice(index, 1);
				df.forIn(this.runs, function (idx, name, runs) {
					if (idx > index) {
						runs[name] = idx - 1;
					}
				});
				this.dirty = true;
			}
			return this;
		}, updateSeries:function (name, data) {
			if (name in this.runs) {
				var run = this.series[this.runs[name]];
				run.data = data;
				run.dirty = true;
				this._invalidateDependentPlots(run.plot, false);
				this._invalidateDependentPlots(run.plot, true);
			}
			return this;
		}, resize:function (width, height) {
			var box;
			switch (arguments.length) {
			  case 0:
				box = dojo.marginBox(this.node);
				break;
			  case 1:
				box = width;
				break;
			  default:
				box = {w:width, h:height};
				break;
			}
			dojo.marginBox(this.node, box);
			this.surface.setDimensions(box.w, box.h);
			this.dirty = true;
			this.coords = null;
			return this.render();
		}, getGeometry:function () {
			var ret = {};
			df.forIn(this.axes, function (axis) {
				if (axis.initialized()) {
					ret[axis.name] = {name:axis.name, vertical:axis.vertical, scaler:axis.scaler, ticks:axis.ticks};
				}
			});
			return ret;
		}, setAxisWindow:function (name, scale, offset) {
			var axis = this.axes[name];
			if (axis) {
				axis.setWindow(scale, offset);
			}
			return this;
		}, setWindow:function (sx, sy, dx, dy) {
			if (!("plotArea" in this)) {
				this.calculateGeometry();
			}
			df.forIn(this.axes, function (axis) {
				var scale, offset, bounds = axis.getScaler().bounds, s = bounds.span / (bounds.upper - bounds.lower);
				if (axis.vertical) {
					scale = sy;
					offset = dy / s / scale;
				} else {
					scale = sx;
					offset = dx / s / scale;
				}
				axis.setWindow(scale, offset);
			});
			return this;
		}, calculateGeometry:function () {
			if (this.dirty) {
				return this.fullGeometry();
			}
			dojo.forEach(this.stack, function (plot) {
				if (plot.dirty || (plot.hAxis && this.axes[plot.hAxis].dirty) || (plot.vAxis && this.axes[plot.vAxis].dirty)) {
					plot.calculateAxes(this.plotArea);
				}
			}, this);
			return this;
		}, fullGeometry:function () {
			this._makeDirty();
			dojo.forEach(this.stack, clear);
			if (!this.theme) {
				this.setTheme(new dojox.charting.Theme(dojox.charting._def));
			}
			dojo.forEach(this.series, function (run) {
				if (!(run.plot in this.plots)) {
					var plot = new dc.plot2d.Default(this, {});
					plot.name = run.plot;
					this.plots[run.plot] = this.stack.length;
					this.stack.push(plot);
				}
				this.stack[this.plots[run.plot]].addSeries(run);
			}, this);
			dojo.forEach(this.stack, function (plot) {
				if (plot.hAxis) {
					plot.setAxis(this.axes[plot.hAxis]);
				}
				if (plot.vAxis) {
					plot.setAxis(this.axes[plot.vAxis]);
				}
			}, this);
			var dim = this.dim = this.surface.getDimensions();
			dim.width = dojox.gfx.normalizedLength(dim.width);
			dim.height = dojox.gfx.normalizedLength(dim.height);
			df.forIn(this.axes, clear);
			dojo.forEach(this.stack, function (p) {
				p.calculateAxes(dim);
			});
			var offsets = this.offsets = {l:0, r:0, t:0, b:0};
			df.forIn(this.axes, function (axis) {
				df.forIn(axis.getOffsets(), function (o, i) {
					offsets[i] += o;
				});
			});
			df.forIn(this.margins, function (o, i) {
				offsets[i] += o;
			});
			this.plotArea = {width:dim.width - offsets.l - offsets.r, height:dim.height - offsets.t - offsets.b};
			df.forIn(this.axes, clear);
			dojo.forEach(this.stack, function (plot) {
				plot.calculateAxes(this.plotArea);
			}, this);
			return this;
		}, render:function () {
			if (this.theme) {
				this.theme.clear();
			}
			if (this.dirty) {
				return this.fullRender();
			}
			this.calculateGeometry();
			df.forEachRev(this.stack, function (plot) {
				plot.render(this.dim, this.offsets);
			}, this);
			df.forIn(this.axes, function (axis) {
				axis.render(this.dim, this.offsets);
			}, this);
			this._makeClean();
			if (this.surface.render) {
				this.surface.render();
			}
			return this;
		}, fullRender:function () {
			this.fullGeometry();
			var offsets = this.offsets, dim = this.dim;
			var requiredColors = df.foldl(this.stack, "z + plot.getRequiredColors()", 0);
			this.theme.defineColors({num:requiredColors, cache:false});
			dojo.forEach(this.series, purge);
			df.forIn(this.axes, purge);
			dojo.forEach(this.stack, purge);
			this.surface.clear();
			var t = this.theme, fill = t.plotarea && t.plotarea.fill, stroke = t.plotarea && t.plotarea.stroke;
			if (fill) {
				this.surface.createRect({x:offsets.l, y:offsets.t, width:dim.width - offsets.l - offsets.r, height:dim.height - offsets.t - offsets.b}).setFill(fill);
			}
			if (stroke) {
				this.surface.createRect({x:offsets.l, y:offsets.t, width:dim.width - offsets.l - offsets.r - 1, height:dim.height - offsets.t - offsets.b - 1}).setStroke(stroke);
			}
			df.foldr(this.stack, function (z, plot) {
				return plot.render(dim, offsets), 0;
			}, 0);
			fill = this.fill ? this.fill : (t.chart && t.chart.fill);
			stroke = this.stroke ? this.stroke : (t.chart && t.chart.stroke);
			if (fill == "inherit") {
				var node = this.node, fill = new dojo.Color(dojo.style(node, "backgroundColor"));
				while (fill.a == 0 && node != document.documentElement) {
					fill = new dojo.Color(dojo.style(node, "backgroundColor"));
					node = node.parentNode;
				}
			}
			if (fill) {
				if (offsets.l) {
					this.surface.createRect({width:offsets.l, height:dim.height + 1}).setFill(fill);
				}
				if (offsets.r) {
					this.surface.createRect({x:dim.width - offsets.r, width:offsets.r + 1, height:dim.height + 1}).setFill(fill);
				}
				if (offsets.t) {
					this.surface.createRect({width:dim.width + 1, height:offsets.t}).setFill(fill);
				}
				if (offsets.b) {
					this.surface.createRect({y:dim.height - offsets.b, width:dim.width + 1, height:offsets.b + 2}).setFill(fill);
				}
			}
			if (stroke) {
				this.surface.createRect({width:dim.width - 1, height:dim.height - 1}).setStroke(stroke);
			}
			df.forIn(this.axes, function (axis) {
				axis.render(dim, offsets);
			});
			this._makeClean();
			if (this.surface.render) {
				this.surface.render();
			}
			return this;
		}, connectToPlot:function (name, object, method) {
			return name in this.plots ? this.stack[this.plots[name]].connect(object, method) : null;
		}, _makeClean:function () {
			dojo.forEach(this.axes, makeClean);
			dojo.forEach(this.stack, makeClean);
			dojo.forEach(this.series, makeClean);
			this.dirty = false;
		}, _makeDirty:function () {
			dojo.forEach(this.axes, makeDirty);
			dojo.forEach(this.stack, makeDirty);
			dojo.forEach(this.series, makeDirty);
			this.dirty = true;
		}, _invalidateDependentPlots:function (plotName, verticalAxis) {
			if (plotName in this.plots) {
				var plot = this.stack[this.plots[plotName]], axis, axisName = verticalAxis ? "vAxis" : "hAxis";
				if (plot[axisName]) {
					axis = this.axes[plot[axisName]];
					if (axis && axis.dependOnData()) {
						axis.dirty = true;
						dojo.forEach(this.stack, function (p) {
							if (p[axisName] && p[axisName] == plot[axisName]) {
								p.dirty = true;
							}
						});
					}
				} else {
					plot.dirty = true;
				}
			}
		}});
	})();
}
if (!dojo._hasResource["dojox.charting.widget.Legend"]) {
	dojo._hasResource["dojox.charting.widget.Legend"] = true;
	dojo.provide("dojox.charting.widget.Legend");
	dojo.declare("dojox.charting.widget.Legend", [dijit._Widget, dijit._Templated], {chartRef:"", horizontal:true, swatchSize:18, templateString:"<table dojoAttachPoint='legendNode' class='dojoxLegendNode'><tbody dojoAttachPoint='legendBody'></tbody></table>", legendNode:null, legendBody:null, postCreate:function () {
		if (!this.chart) {
			if (!this.chartRef) {
				return;
			}
			this.chart = dijit.byId(this.chartRef);
			if (!this.chart) {
				var node = dojo.byId(this.chartRef);
				if (node) {
					this.chart = dijit.byNode(node);
				} else {
					console.log("Could not find chart instance with id: " + this.chartRef);
					return;
				}
			}
			this.series = this.chart.chart.series;
		} else {
			this.series = this.chart.series;
		}
		this.refresh();
	}, refresh:function () {
		var df = dojox.lang.functional;
		if (this._surfaces) {
			dojo.forEach(this._surfaces, function (surface) {
				surface.destroy();
			});
		}
		this._surfaces = [];
		while (this.legendBody.lastChild) {
			dojo.destroy(this.legendBody.lastChild);
		}
		if (this.horizontal) {
			dojo.addClass(this.legendNode, "dojoxLegendHorizontal");
			this._tr = dojo.doc.createElement("tr");
			this.legendBody.appendChild(this._tr);
		}
		var s = this.series;
		if (s.length == 0) {
			return;
		}
		if (s[0].chart.stack[0].declaredClass == "dojox.charting.plot2d.Pie") {
			var t = s[0].chart.stack[0];
			if (typeof t.run.data[0] == "number") {
				var filteredRun = df.map(t.run.data, "Math.max(x, 0)");
				if (df.every(filteredRun, "<= 0")) {
					return;
				}
				var slices = df.map(filteredRun, "/this", df.foldl(filteredRun, "+", 0));
				dojo.forEach(slices, function (x, i) {
					this._addLabel(t.dyn[i], t._getLabel(x * 100) + "%");
				}, this);
			} else {
				dojo.forEach(t.run.data, function (x, i) {
					this._addLabel(t.dyn[i], x.legend || x.text || x.y);
				}, this);
			}
		} else {
			dojo.forEach(s, function (x) {
				this._addLabel(x.dyn, x.legend || x.name);
			}, this);
		}
	}, _addLabel:function (dyn, label) {
		var icon = dojo.doc.createElement("td"), text = dojo.doc.createElement("td"), div = dojo.doc.createElement("div");
		dojo.addClass(icon, "dojoxLegendIcon");
		dojo.addClass(text, "dojoxLegendText");
		div.style.width = this.swatchSize + "px";
		div.style.height = this.swatchSize + "px";
		icon.appendChild(div);
		if (this._tr) {
			this._tr.appendChild(icon);
			this._tr.appendChild(text);
		} else {
			var tr = dojo.doc.createElement("tr");
			this.legendBody.appendChild(tr);
			tr.appendChild(icon);
			tr.appendChild(text);
		}
		this._makeIcon(div, dyn);
		text.innerHTML = String(label);
	}, _makeIcon:function (div, dyn) {
		var mb = {h:this.swatchSize, w:this.swatchSize};
		var surface = dojox.gfx.createSurface(div, mb.w, mb.h);
		this._surfaces.push(surface);
		if (dyn.fill) {
			surface.createRect({x:2, y:2, width:mb.w - 4, height:mb.h - 4}).setFill(dyn.fill).setStroke(dyn.stroke);
		} else {
			if (dyn.stroke || dyn.marker) {
				var line = {x1:0, y1:mb.h / 2, x2:mb.w, y2:mb.h / 2};
				if (dyn.stroke) {
					surface.createLine(line).setStroke(dyn.stroke);
				}
				if (dyn.marker) {
					var c = {x:mb.w / 2, y:mb.h / 2};
					if (dyn.stroke) {
						surface.createPath({path:"M" + c.x + " " + c.y + " " + dyn.marker}).setFill(dyn.stroke.color).setStroke(dyn.stroke);
					} else {
						surface.createPath({path:"M" + c.x + " " + c.y + " " + dyn.marker}).setFill(dyn.color).setStroke(dyn.color);
					}
				}
			} else {
				surface.createRect({x:2, y:2, width:mb.w - 4, height:mb.h - 4}).setStroke("black");
				surface.createLine({x1:2, y1:2, x2:mb.w - 2, y2:mb.h - 2}).setStroke("black");
				surface.createLine({x1:2, y1:mb.h - 2, x2:mb.w - 2, y2:2}).setStroke("black");
			}
		}
	}});
}
dojo.i18n._preloadLocalizations("dojo.nls.studio_base", ["ROOT", "ar", "ca", "cs", "da", "de", "de-de", "el", "en", "en-gb", "en-us", "es", "es-es", "fi", "fi-fi", "fr", "fr-fr", "he", "he-il", "hu", "it", "it-it", "ja", "ja-jp", "ko", "ko-kr", "nb", "nl", "nl-nl", "pl", "pt", "pt-br", "pt-pt", "ru", "sk", "sl", "sv", "th", "tr", "xx", "zh", "zh-cn", "zh-tw"]);

