/*
	Copyright (c) 2004-2009, The Dojo Foundation All Rights Reserved.
	Available via Academic Free License >= 2.1 OR the modified BSD license.
	see: http://dojotoolkit.org/license for details
*/

/*
	This is a compiled version of Dojo, built for deployment and not for
	development. To get an editable version, please visit:

		http://dojotoolkit.org

	for documentation and information on getting the source.
*/


dojo.provide("studio_wm");
if (!dojo._hasResource["wm.base.Object"]) {
	dojo._hasResource["wm.base.Object"] = true;
	dojo.provide("wm.base.Object");
	dojo.declare("wm.Object", null, {constructor:function () {
		this.type = this.declaredClass;
	}, toString:function () {
		return "[" + this.declaredClass + "]";
	}, getProp:function (inPropertyName) {
		var g = this._getPropWorker(this, inPropertyName, "get");
		if (g) {
			return g.call(this, inPropertyName);
		} else {
			return this._getProp(inPropertyName);
		}
	}, _getProp:function (inProp) {
		return this[inProp];
	}, setProp:function (inProp, inValue) {
		if (this.isDestroyed) {
			return;
		}
		var s = this._getPropWorker(this, inProp, "set");
		if (s) {
			s.call(this, inValue);
		} else {
			this._setProp(inProp, inValue);
		}
		this.valueChanged(inProp, this.getProp(inProp));
	}, _setProp:function (inProp, inValue) {
		if (inProp in this) {
			this[inProp] = inValue;
		}
	}, _getPropWorker:function (inObj, inProp, inPrefix) {
		var w = inObj[inPrefix + "_" + inProp] || this[inPrefix + inProp.slice(0, 1).toUpperCase() + inProp.slice(1)];
		if (dojo.isFunction(w)) {
			return w;
		}
	}, valueChanged:function (inProp, inValue) {
	}, _getValue:function (inProp) {
		return this.getProp(inProp);
	}, _setValue:function (inProp, inValue) {
		this.setProp(inProp, inValue);
	}, getValue:function (inName) {
		if (!inName) {
			return;
		}
		var parts = dojo.isString(inName) ? inName.replace(/([^\.])\[/g, "$1.[").split(".") : inName;
		var o = (parts[0] == "studio" && this instanceof wm.Application) ? window : this;
		var p;
		while (parts.length > 1) {
			p = parts.shift();
			var pmatch;
			if (this instanceof wm.Variable || this instanceof Array) {
				pmatch = p.match(/^\[(\d+)\]$/);
			}
			if (pmatch && this instanceof wm.Variable) {
				o = o.getItem(pmatch[1]);
			} else {
				if (pmatch && this instanceof Array) {
					o = o[pmatch1];
				} else {
					o = o.getValue ? o.getValue(p) : o[p];
				}
			}
			if (!o) {
				wm.logging && console.debug(this, "notice: Object.getValue: couldn't marshall property ", p, " for ", inName);
				return;
			}
			if (o.getValue) {
				return o.getValue(parts);
			}
		}
		p = parts.shift();
		return o._getValue ? o._getValue(p) : o[p];
	}, setValue:function (inName, inValue) {
		var parts = dojo.isString(inName) ? inName.split(".") : inName, o = this, p;
		while (parts.length > 1) {
			o = o.getValue(parts.shift());
			if (!o) {
				return;
			}
			if (o instanceof wm.Object) {
				return o.setValue(parts, inValue);
			}
		}
		p = parts.shift();
		o._setValue ? o._setValue(p, inValue) : o[p] = inValue;
	}});
	dojo.mixin(wm.Object, {makeSchema:function (inClass) {
		inClass.schemaClass = function () {
		};
		var superClass = inClass.superclass;
		try {
			if (inClass._meta.parents && inClass._meta.parents.length > 1) {
				superClass = inClass._meta.parents[0].prototype;
			}
		}
		catch (e) {
		}
		if (superClass) {
			var ctor = this.getSchemaClass(superClass.constructor);
			inClass.schemaClass.prototype = new ctor();
		}
		inClass.prototype.schema = new inClass.schemaClass();
		return inClass.schemaClass;
	}, getSchemaClass:function (inClass) {
		return inClass.schemaClass || wm.Object.makeSchema(inClass);
	}, extendSchema:function (inClass, inSchema) {
		dojo.extend(wm.Object.getSchemaClass(inClass), inSchema);
		delete inClass._publishedProps;
	}});
	wm.Object.extendSchema(wm.Object, {declaredClass:{ignore:1}, schema:{ignore:1}, schemaClass:{ignore:1}, type:{ignore:1}});
	wm.Object.extend({getPropFlags:function (inName, inTypeInfo) {
	}, getPropertyType:function (inName) {
		var v = this.getProp(inName);
		var t = {type:v && v.type || typeof v, isObject:v instanceof wm.Object};
		this.getPropFlags(inName, t);
		var s = this.schema[inName] || {noprop:Boolean((v === undefined) || (v === null) || inName.charAt(0) == "_" || (dojo.isFunction(v) || dojo.isObject(v)) && !t.isCustomMethod)};
		return dojo.mixin(t, s);
	}, _listSchemaProperties:function (ioProps, inSchema, inGetTypeInfo) {
		var getInfo = this[inGetTypeInfo || "getPropertyType"], op = Object.prototype;
		for (var p in inSchema) {
			if (p == "inherited") {
				continue;
			}
			if (!(p in ioProps) && !(p in op)) {
				var t = getInfo.call(this, p);
				if (!t.noprop) {
					ioProps[p] = t;
				}
			}
		}
		return ioProps;
	}, _listProperties:function () {
		var props = {};
		this._listSchemaProperties(props, this);
		return this._listSchemaProperties(props, this.schema);
	}, listProperties:function () {
		return this.constructor._publishedProps || (this.constructor._publishedProps = this._listProperties());
	}, listDataProperties:function () {
		return this.listProperties();
	}});
	wm.define = function (inClass, inSuperclasses, inProperties) {
		if (arguments.length < 3) {
			inProperties = inSuperclasses;
			inSuperclasses = wm.Control;
		}
		var schema = inProperties.published;
		delete inProperties.published;
		var ctor = dojo.declare(inClass, inSuperclasses, inProperties);
		wm.Object.extendSchema(ctor, schema);
		return ctor;
	};
}
if (!dojo._hasResource["wm.base.Component"]) {
	dojo._hasResource["wm.base.Component"] = true;
	dojo.provide("wm.base.Component");
	dojo.declare("wm.Component", wm.Object, {theme:"wm_tundra", name:"", owner:null, getParentDialog:function () {
		var w = this;
		while (w) {
			if (w instanceof wm.Dialog) {
				return w;
			} else {
				w = w.parent;
			}
		}
		return null;
	}, getParentPage:function () {
		if (this instanceof wm.Page || this instanceof wm.PageDialog) {
			return this;
		}
		if (this.owner) {
			return this.owner.getParentPage();
		}
		return null;
	}, getOwnerApp:function () {
		if (wm.isInstanceType(this, wm.Application)) {
			return this;
		}
		if (!this.isDesignLoaded()) {
			return window.app;
		} else {
			if (this == studio.page) {
				return studio.application;
			} else {
				return this.owner.getOwnerApp();
			}
		}
	}, constructor:function (inProps) {
		this.$ = this.components = {};
		this._connections = [];
		this._subscriptions = [];
		this._designee = this;
		this.isDestroyed = false;
		this._subscriptions.push(dojo.subscribe("applicationDestroyed", this, "destroy"));
	}, postscript:function (inProps) {
		this.create(inProps);
		wm.Component.add(this);
	}, create:function (inProps) {
		if (wm.debugPerformance) {
			this.startTimerWithName("create", this.declaredClass);
		}
		this.prepare(inProps);
		this.build();
		this.init();
		if (this._designer) {
			wm.fire(this, "designCreate");
		}
		if (!this._loading) {
			this.postInit();
		}
		dojo.addOnWindowUnload(this, "destroy");
		if (wm.debugPerformance) {
			this.stopTimerWithName("create", this.declaredClass);
		}
	}, destroy:function () {
		if (this.isDestroyed) {
			return;
		}
		try {
			this._disconnect();
			this._unsubscribe();
			wm.fire(this, "designDestroy");
			var comps = [];
			for (var n in this.components) {
				comps.push(this.components[n]);
			}
			for (var i = 0, c; (c = comps[i]); i++) {
				c.destroy();
				for (var n in c) {
					delete c[n];
				}
				c.isDestroyed = true;
			}
			comps = null;
			delete this.components;
			delete this.$;
			wm.Component.remove(this);
			this.setOwner(null);
			this.isDestroyed = true;
		}
		catch (e) {
		}
	}, prepare:function (inProps) {
		this.readProps(inProps);
		dojo.mixin(this, {flags:{}}, inProps);
		this.setOwner(this.owner);
	}, readProps:function (inProps) {
	}, build:function () {
	}, init:function () {
	}, postInit:function () {
		this.valueChanged("", this);
	}, loaded:function () {
		this._loading = false;
		this.postInit();
	}, toString:function () {
		return "[" + this.declaredClass + ((this.name) ? ":" + this.name : "") + "]";
	}, getComponent:function (inName) {
		return this.components[inName] || this.owner && this.owner.getComponent(inName);
	}, isDesignedComponent:function () {
		return this.isDesignLoaded();
	}, isDesignLoaded:function () {
		if (!window.studio) {
			return false;
		}
		if (this.isOwnedBy(studio.page)) {
			return true;
		}
		if (this == studio.page) {
			return true;
		}
		if (this.isOwnedBy(studio.application)) {
			return true;
		}
		if (!this.isOwnedBy(app)) {
			return true;
		}
		return false;
	}, getPath:function () {
		var p = "";
		if (this.isDesignLoaded() && studio.project) {
			p = "projects/" + studio.project.getProjectPath() + "/";
		}
		return p;
	}, addComponent:function (inComponent) {
		var n = inComponent.name;
		this.components[n] = inComponent;
	}, removeComponent:function (inComponent) {
		if (!this.components) {
			return;
		}
		var n = inComponent.name;
		if (this.components[n] == inComponent) {
			delete this.components[n];
		}
	}, setOwner:function (inOwner, nonWritable) {
		var originalOwner = this.owner;
		if (this.owner) {
			this.owner.removeComponent(this);
		}
		this.owner = inOwner;
		if (this.owner) {
			if (!nonWritable) {
				this.owner.addComponent(this);
				if (!this._designer) {
					this._designer = this.owner._designer;
				}
			}
			if ((!originalOwner && this.owner instanceof wm.Page == false) || (this.owner != originalOwner && originalOwner && (this.owner instanceof wm.Page == false && originalOwner instanceof wm.Page || this.owner instanceof wm.Page && originalOwner instanceof wm.Page == false))) {
				this.updateId();
				if (this.isDesignLoaded()) {
					this.resetChildIds();
				}
			}
		}
		delete this.rootId;
	}, isOwnedBy:function (inOwner) {
		var o = this.owner;
		while (o) {
			if (o == inOwner) {
				return true;
			}
			o = o.owner;
		}
	}, qualifyName:function (inName) {
		inName = this.name + "_" + inName;
		if (window.studio && (window.studio.page == this.owner || window.studio.application == this.owner)) {
			return inName;
		}
		return this.owner ? this.owner.qualifyName(inName) : inName;
	}, getUniqueName:function (inName) {
		return wm.findUniqueName(inName, [this, this.components]);
	}, setName:function (inName) {
		if (!inName) {
			return;
		}
		wm.Component.remove(this);
		this.owner.removeComponent(this);
		this.name = inName;
		this.owner.addComponent(this);
		this.updateId();
		wm.Component.add(this);
	}, updateId:function () {
		var id = this.makeId();
		if (id != this.id) {
			this.id = id;
			delete this.runtimeId;
		}
	}, makeId:function (inName) {
		inName = this.name + (inName ? (this.name ? "." : "") + inName : "");
		return this.owner ? this.owner.getId(inName) : inName;
	}, getId:function (inName) {
		if (inName) {
			return this.makeId(inName);
		}
		var id = this.id;
		if (!this.id || this.isDesignLoaded()) {
			var id = this.makeId();
			this.id = id;
		}
		return id;
	}, resetChildIds:function () {
		for (var i in this.components) {
			delete this.components[i].id;
			delete this.components[i].runtimeId;
			delete this.components[i].rootId;
			this.components[i].resetChildIds();
		}
	}, getRoot:function () {
		if (this.owner) {
			return this.owner.getRoot();
		} else {
			return null;
		}
	}, getRootId:function () {
		if (!this.rootId || this.isDesignLoaded()) {
			var r = this.getRoot();
			r = r ? r.getRuntimeId() : "";
			this.rootId = r ? r + (r.charAt(r.length - 1) == "." ? "" : ".") : "";
		}
		return this.rootId;
	}, getRuntimeId:function (inName) {
		if (!this.runtimeId || this.isDesignLoaded()) {
			this.runtimeId = this.getRootId() + this.getId();
		}
		var result = (inName) ? this.runtimeId + "." + inName : this.runtimeId;
		return result;
	}, getValueById:function (inId) {
		var r = this.getRoot();
		r = r && r.getValue(inId);
		var result;
		if (r && r._wmNull) {
			return app.getValue(inId);
		}
		return r || wm.Component.byId[inId];
	}, connect:function () {
		this._connections.push(dojo.connect.apply(dojo, arguments));
	}, connectEvents:function (inObject, inEvents) {
		this._connections = this._connections.concat(wm.connectEvents(this, inObject, inEvents));
	}, _disconnect:function (inNode, inEvents) {
		dojo.forEach(this._connections, dojo.disconnect);
		this._connections = [];
	}, disconnectEvent:function (inEvent) {
		this._connections = dojo.filter(this._connections, function (item, index, array) {
			if (item[1] == inEvent) {
				dojo.disconnect(item);
				return false;
			} else {
				return true;
			}
			return item[1] != inEvent;
		});
	}, subscribe:function () {
		var s = dojo.subscribe.apply(dojo, arguments);
		this._subscriptions.push(s);
		return s;
	}, unsubscribe:function (subname) {
		for (var i = this._subscriptions.length - 1; i >= 0; i--) {
			if (this._subscriptions[i][0] == subname) {
				dojo.unsubscribe(this._subscriptions[i]);
				wm.Array.removeElementAt(this._subscriptions, i);
			}
		}
	}, _unsubscribe:function () {
		dojo.forEach(this._subscriptions, dojo.unsubscribe);
		this._subscriptions = [];
	}, isEventProp:function (n) {
		return dojo.isFunction(this._designee[n]) && (n.slice(0, 2) == "on");
	}, isCustomMethodProp:function (n) {
		return dojo.isFunction(this.constructor.prototype[n]) && (n.slice(0, 6) == "custom");
	}, _getProp:function (n) {
		if (this.isEventProp(n)) {
			return this.eventBindings ? (this.eventBindings[n] || "") : "";
		}
		var g = this._getPropWorker(this._designee, n, "get");
		if (g) {
			return g.call(this, n);
		}
		return n in this._designee ? this._designee[n] : this.components[n];
	}, _setProp:function (n, v) {
		if (this.isEventProp(n)) {
			this.setEvent(n, v);
		} else {
			var s = this._getPropWorker(this._designee, n, "set");
			if (s) {
				s.call(this, v);
			} else {
				this._designee[n] = v;
			}
		}
	}, valueChanged:function (inProp, inValue) {
		var evtId = this.getRuntimeId(inProp);
		if (evtId == "") {
			return;
		}
		dojo.publish(evtId + "-changed", [inValue, this]);
	}, _create:function (ctor, props) {
		try {
			return new ctor(props);
		}
		catch (e) {
			console.debug("Component._create: ignoring unknown component type: ", ctor.prototype, props);
		}
	}, adjustChildProps:function (inCtor, inProps) {
		dojo.mixin(inProps, {owner:this});
	}, createComponent:function (inName, inType, inProps, inEvents, inChildren, inOwner) {
		if (wm.debugPerformance) {
			if (inType == "wm.Layout") {
				if (dojo.isFF) {
					console.groupCollapsed("CREATE " + inType + ": " + inName + " AT " + startTime);
				} else {
					console.group("CREATE " + inType + ": " + inName + " AT " + startTime);
				}
			}
			this.startTimer("CreateComponent", inType);
		}
		var ctor = dojo.getObject(inType);
		if (!ctor) {
			try {
				wm.getComponentStructure(inType);
				ctor = dojo.getObject(inType);
			}
			catch (e) {
				console.info("error while getComponentStructure: " + e);
			}
		}
		if (!ctor) {
			throw ("Component type \"" + inType + "\" is not available.");
		}
		var props = dojo.mixin({_designer:this._designer, _loading:true}, inProps);
		this.adjustChildProps(ctor, props);
		if (inOwner) {
			props.owner = inOwner;
		}
		props.name = props.owner.getRoot()._loading || props.owner._loading ? inName : props.owner.getUniqueName(inName);
		if (!this.isDesignLoaded()) {
			for (var p in props) {
				if (p.indexOf("custom") == 0 && dojo.isFunction(ctor.prototype[p])) {
					var owner = props.owner;
					props[p] = dojo.hitch(owner, owner[props[p]]);
				}
			}
		}
		var w = this._create(ctor, props);
		if (w.name != inName && wm.pasting && window["studio"]) {
			studio.renamedDuringPaste[inName] = w;
		}
		try {
			if (inEvents && w.owner) {
				w.owner.makeEvents(inEvents, w);
			}
			if (inChildren) {
				w.createComponents(inChildren);
			}
		}
		catch (e) {
			console.info("error while creating component: ", e);
		}
		finally {
			w.loaded();
		}
		if (wm.debugPerformance) {
			this.stopTimerWithName("CreateComponent", inType, 1);
		}
		return w;
	}, createComponents:function (inComponents, inOwner) {
		var result = [];
		for (var i in inComponents) {
			var c = inComponents[i];
			result.push(this.createComponent(i, c[0], c[1], c[2], c[3], inOwner));
		}
		return result;
	}, _eventArgs:function (c, a) {
		var args = [c];
		for (var i = 0, l = a.length; i < l; i++) {
			args.push(a[i]);
		}
		return args;
	}, makeEvents:function (inEvents, inComponent) {
		var e, n, f;
		for (n in inEvents) {
			f = inEvents[n];
			e = this[f] || f;
			if (this._designer) {
				wm.fire(inComponent, "setProp", [n, f]);
			} else {
				this.connect(inComponent._eventSource || inComponent, n, this.makeEvent(e, f));
			}
		}
	}, makeEvent:function (inHandler, inName) {
		return dojo.isFunction(inHandler) ? this._makeEvent(inName) : this._makeComponentEvent(inHandler);
	}, _makeEvent:function (inName) {
		var self = this;
		return function () {
			self[inName].apply(self, self._eventArgs(this, arguments));
		};
	}, _makeComponentEvent:function (inHandler) {
		var self = this;
		return function (e) {
			var c = wm.isInstanceType(inHandler, wm.Component) ? inHandler : self.getValueById(inHandler);
			if (wm.isInstanceType(c, wm.Component)) {
				wm.fire(c, "update", [e]);
			} else {
				if (dojo.isString(inHandler)) {
					var o = inHandler.split(".");
					if (o.length > 1) {
						var m = o.pop();
						c = self.getValueById(o);
						if (c && c[m]) {
							c[m]();
						}
					}
				}
			}
		};
	}, readComponents:function (inComponents) {
		var c = dojo.fromJson(inComponents);
		return this.createComponents(c);
	}, startTimerWithName:function (timerName, componentName) {
		if (!wm.debugPerformance) {
			return;
		}
		if (!this.logTimesWithComponentNames) {
			this.logTimesWithComponentNames = {};
		}
		if (!this.logTimesWithComponentNames[componentName]) {
			this.logTimesWithComponentNames[componentName] = {};
		}
		this.logTimesWithComponentNames[componentName][timerName] = new Date().getTime();
	}, stopTimerWithName:function (timerName, componentName) {
		if (!wm.debugPerformance) {
			return;
		}
		if (!this.logTimesWithComponentNames) {
			this.logTimesWithComponentNames = {};
		}
		if (!this.logTimesWithComponentNames[componentName]) {
			this.logTimesWithComponentNames[componentName] = {};
		}
		var startTime = this.logTimesWithComponentNames[componentName][timerName];
		if (!startTime) {
			return -1;
		}
		this.logTimesWithComponentNames[componentName][timerName] = 0;
		var result = new Date().getTime() - startTime;
		var timingObj = wm.Component.timingByComponent[componentName];
		if (!timingObj) {
			wm.Component.timingByComponent[componentName] = {};
			timingObj = wm.Component.timingByComponent[componentName];
		}
		if (!timingObj[timerName]) {
			timingObj[timerName] = [];
		}
		timingObj[timerName].push(result);
		return result;
	}, subtractTimerWithName:function (timerName, componentName, time) {
		if (!wm.debugPerformance) {
			return;
		}
		if (!this.logTimesWithComponentNames) {
			this.logTimesWithComponentNames = {};
		}
		if (!this.logTimesWithComponentNames[componentName]) {
			this.logTimesWithComponentNames[componentName] = {};
		}
		var startTime = this.logTimesWithComponentNames[componentName][timerName];
		if (!startTime) {
			return -1;
		}
		var timingObj = wm.Component.timingByComponent[componentName];
		if (!timingObj) {
			wm.Component.timingByComponent[componentName] = {};
			timingObj = wm.Component.timingByComponent[componentName];
		}
		var tmp = timingObj[timereName];
		tmp[tmp.length - 1] -= time;
	}, startTimer:function (timerName) {
		if (!wm.debugPerformance) {
			return;
		}
		if (!this.logTimes) {
			this.logTimes = {};
		}
		this.logTimes[timerName] = new Date().getTime();
	}, stopTimer:function (timerName, addToComponentLog) {
		if (!wm.debugPerformance) {
			return;
		}
		if (!this.logTimes) {
			this.logTimes = {};
		}
		var startTime = this.logTimes[timerName];
		if (!startTime) {
			return -1;
		}
		this.logTimes[timerName] = 0;
		var result = new Date().getTime() - startTime;
		if (addToComponentLog) {
			var timingObj = wm.Component.timingByComponent[this.declaredClass];
			if (!timingObj) {
				wm.Component.timingByComponent[this.declaredClass] = {};
				timingObj = wm.Component.timingByComponent[this.declaredClass];
			}
			if (!timingObj[timerName]) {
				timingObj[timerName] = [];
			}
			timingObj[timerName].push(result);
		}
		return result;
	}});
	dojo.mixin(wm.Component, {byId:{}, timingByComponent:{}, add:function (inComponent) {
		wm.Component.byId[inComponent.getRuntimeId()] = inComponent;
	}, remove:function (inComponent) {
		delete wm.Component.byId[inComponent.getRuntimeId()];
	}, property:{}});
}
if (!dojo._hasResource["wm.base.Component_design"]) {
	dojo._hasResource["wm.base.Component_design"] = true;
	dojo.provide("wm.base.Component_design");
	wm.Object.extendSchema(wm.Component, {documentation:{group:"docs", readonly:true, order:1}, generateDocumentation:{group:"docs", readonly:true, order:2}, themeable:{ignore:1}, theme:{ignore:1}, isDestroyed:{ignore:1}, deletionDisabled:{ignore:1}, components:{ignore:1}, designWrapper:{ignore:1}, eventBindings:{ignore:1}, id:{ignore:1}, ignoredProps:{ignore:1}, name:{group:"common", order:0, readonly:true}, owner:{group:"common", order:1, readonly:true, options:["Page", "Application"]}, publishClass:{ignore:1}, readonlyProps:{ignore:1}, referenceProps:{ignore:1}, state:{ignore:1}, binding:{ignore:1, writeonly:1}, runtimeId:{ignore:1}, rootId:{ignore:1}});
	wm.Component.extend({themeable:false, designCreate:function () {
		this.eventBindings = {};
		this.referenceProps = {};
		this.publishClass = this.publishClass || this.declaredClass;
		this.subscribe("wmwidget-idchanged", this, "renameComponentEvents");
		if (!(wm.isInstanceType(this, wm.Control))) {
			this.designWrapper = new wm.ComponentWrapper({surface:this._designer, component:this, owner:this.owner});
		}
	}, designDestroy:function () {
		wm.fire(this.designWrapper, "destroy");
	}, getPropFlags:function (inName, inTypeInfo) {
		inTypeInfo.isEvent = this.isEventProp(inName);
		inTypeInfo.isCustomMethod = this.isCustomMethodProp(inName);
	}, listProperties:function () {
		var props = this.inherited(arguments);
		if (this.isDesignLoaded() && (this.owner != studio.application && this.owner != studio.page)) {
			props.owner = {ignore:1};
		}
		if (this.deletionDisabled) {
			props.name = {ignore:1};
		}
		return props;
	}, listDataProperties:function (inType) {
		var props = this.listProperties(), p, list = {};
		for (var i in props) {
			p = props[i];
			if (p.bindable || (inType && p[inType]) || (!inType && (p.bindTarget || p.bindSource))) {
				p = dojo.mixin({}, props[i]);
				p.type = p.isObject ? (this.getValue(i) || 0).type : p.type;
				list[i] = p;
			}
		}
		return list;
	}, serialize:function (inOptions) {
		return "{" + this.write("", inOptions || 0) + "}";
	}, copyProps:function (inProps, inNames, inPrefix) {
		var target = this._designee, p = target.constructor.prototype, pf = inPrefix || "";
		for (var i = 0, n; (n = inNames[i]); i++) {
			if ((n in target) && (target[n] != p[n])) {
				inProps[pf + n] = target[n];
			}
		}
	}, isWriteableProp:function (inPropSchema) {
		var ps = inPropSchema;
		return !ps || ((ps.writeonly || !(ps.ignore || ps.readonly)) && !ps.isEvent && !ps.componentonly);
	}, writeProps:function () {
		var props = this.listProperties(), src = this._designee, p = src.constructor.prototype, out = {};
		var propList = [];
		for (var n in props) {
			propList.push(n);
		}
		propList = propList.sort();
		for (var i = 0; i < propList.length; i++) {
			var n = propList[i];
			if (this.isWriteableProp(props[n])) {
				if (wm.isInstanceType(src, wm.Application) && src[n] !== undefined) {
					out[n] = src[n];
				} else {
					if (n in src && (n == "_classes" && src[n] && src[n].domNode && src[n].domNode.length > 0 || n != "_classes" && src[n] != p[n])) {
						out[n] = src[n];
					}
				}
			}
		}
		return out;
	}, writeEvents:function (inEvents) {
		return this.eventBindings;
	}, _isWriteableComponent:function (inName, inProperties) {
		if (!inName || (this.components[inName] instanceof wm.Widget && !wm.isInstanceType(this.components[inName], wm.Dialog))) {
			return false;
		}
		var ps = inProperties[inName];
		return !ps || ((ps.writeonly || !(ps.ignore || ps.readonly)) && !ps.isEvent && !ps.isCustomMethod);
	}, writeComponents:function (inIndent, inOptions) {
		var s = [], p = this.listProperties();
		for (var cn in this.components) {
			if (this._isWriteableComponent(cn, p)) {
				var c = this.components[cn].write(inIndent, inOptions);
				if (c) {
					s.push(c);
				}
			}
		}
		return s;
	}, write:function (inIndent, inOptions) {
		var o = ["\"" + this.publishClass + "\""];
		var p = this.writeProps(inOptions);
		o.push(toJson(p));
		var e = this.writeEvents();
		o.push(toJson(e));
		var s = this.writeComponents(inIndent + sourcer_tab, inOptions);
		if (s.length) {
			s = "{" + sourcer_nl + s.join("," + sourcer_nl) + sourcer_nl + inIndent + "}";
			o.push(s);
		}
		return [inIndent, this.name, ": [", o.join(", "), "]"].join("");
	}, getDocumentationHash:function () {
		var hash = {};
		if (this.documentation) {
			hash[this.name] = this.documentation;
		}
		for (var i in this.components) {
			var tmp = this.components[i].getDocumentationHash();
			if (!wm.isEmpty(tmp)) {
				dojo.mixin(hash, tmp);
			}
		}
		return hash;
	}, set_name:function (inName) {
		var o = this.name, n = inName;
		if (n == o || !n) {
			return;
		}
		n = wm.getValidJsName(n);
		var un = this.owner.getUniqueName(n);
		if (n != un) {
			return n;
		}
		var oldRtId = this.getRuntimeId(), oldId = this.getId();
		this.renameFunctionEvents(n);
		this.setName(n);
		var rtId = this.getRuntimeId(), id = this.getId();
		dojo.publish("wmwidget-rename", [o, n, this]);
		dojo.publish("wmwidget-idchanged", [oldId, id, oldRtId, rtId, this]);
		return n;
	}, set_owner:function (inOwner) {
		inOwner = inOwner == "Application" ? studio.application : studio.page;
		var n = inOwner.getUniqueName(this.name);
		if (n != this.name) {
			this.set_name(n);
		}
		var id = this.getId(), rtId = this.getRuntimeId();
		this.setOwner(inOwner);
		dojo.publish("wmwidget-idchanged", [id, this.getId(), rtId, this.getRuntimeId(), this]);
		studio.refreshDesignTrees();
		inspect(this, true);
	}, get_owner:function () {
		return this.owner == (studio && studio.application) ? "Application" : "Page";
	}, setEvent:function (n, v) {
		var o = this.eventBindings[n], oc = this.getComponent(o), nc = this.getComponent(v);
		if (!(nc instanceof wm.Component || oc instanceof wm.Component)) {
			eventChange(o, v);
		}
		if (v) {
			this.eventBindings[n] = v;
		} else {
			delete this.eventBindings[n];
		}
	}, renameFunctionEvents:function (inName) {
		var n = inName, l = this.name.length, eb = this.eventBindings, e;
		for (var p in eb) {
			e = eb[p];
			if (e && !this.getComponent(e) && e.slice(0, l) == this.name) {
				this.setEvent(p, n + e.slice(l));
			}
		}
	}, renameComponentEvents:function (originalId, newId) {
		var eventBindings = this.eventBindings;
		for (var eventName in eventBindings) {
			var bindingElements = eventBindings[eventName].split(".");
			var scope = bindingElements.shift();
			if (scope == originalId) {
				if (bindingElements.length) {
					bindingElements.unshift(newId);
					newId = bindingElements.join(".");
				}
				this.setEvent(eventName, newId);
			} else {
				if (scope == "app") {
					this.setEvent(eventName, newId);
				}
			}
		}
	}, makePropEdit:function (inName, inValue, inDefault) {
		switch (inName) {
		  case "documentation":
		  case "generateDocumentation":
			return makeReadonlyButtonEdit(inName, inValue, inDefault);
		}
		if (inName.match(/^custom/) && dojo.isFunction(this.constructor.prototype[inName])) {
			var funclist = getAllEventsInCode();
			funclist.unshift("");
			return new wm.propEdit.Select({component:this, value:inValue, name:inName, defaultValue:inDefault, options:funclist});
		}
		var s = this.schema[inName] || 0;
		var c = (this[inName] || 0).declaredClass;
		p = wm.Component.property[c] || 0;
		if (p.makePropEdit) {
			return p.makePropEdit.apply(this[inName], arguments);
		}
		if (s.operation) {
			return makeReadonlyButtonEdit(inName, inValue, inDefault);
		}
		if (s.options) {
			return new wm.propEdit.Select({component:this, value:inValue, name:inName, defaultValue:inDefault, options:s.options});
		}
		var type = s.componentType;
		if (type) {
			return makeReferencePropEdit(dojo.getObject(type), inName, inValue);
		}
		if (this.components[inName]) {
			return makeReadonlyButtonEdit(inName, inValue, inDefault);
		}
		if (typeof inDefault == "boolean") {
			return makeCheckPropEdit(inName, inValue, inDefault);
		}
	}, editComponentProp:function (inComponent) {
		if (inComponent) {
			var p = wm.Component.property[inComponent.declaredClass];
			if (p && p.editProp) {
				return p.editProp.apply(inComponent, arguments);
			}
			return studio.select(inComponent);
		}
	}, generateEventName:function (inEventName) {
		var n = inEventName;
		return this.name + n.slice(2, 3).toUpperCase() + n.slice(3);
	}, generateSharedEventName:function (inEventName) {
		var n = inEventName;
		var name = this.declaredClass;
		name = name.replace(/^.*\./, "");
		return "on" + name + n.slice(2, 3).toUpperCase() + n.slice(3);
	}, generateDocumentation:function () {
		var html = "<h2>Generated Documentation</h2>\n";
		html += "<h3>Event Handlers</h3><div style='margin-left: 40px;'>";
		var props = this.listProperties();
		for (var i in props) {
			if (props[i].isEvent) {
				var propvalue = this.getProp(i);
				if (!propvalue) {
					html += "<h4>" + i + "</h4>\nUnused<br/>";
				} else {
					html += "<h4>" + i + "</h4>\n executes ";
					var comp = this.owner.components[propvalue] || this.owner.getValue(propvalue);
					if (comp) {
						if (wm.isInstanceType(comp, wm.ServiceCall)) {
							html += propvalue + " (" + comp.declaredClass + ")<ul><li><b>Operation</b>: " + comp.operation;
							var params = comp.input.getData();
							for (var j in params) {
								if (wm.isInstanceType(params[j], wm.Component)) {
									html += "<li><b>" + j + "</b>:" + params[j].toString() + "</li>";
								} else {
									html += "<li><b>" + j + "</b>:" + params[j] + "</li>";
								}
							}
							html += "</ul>";
						} else {
							if (wm.isInstanceType(comp, wm.Dialog)) {
								html += propvalue + " (" + comp.declaredClass + ")";
							}
						}
					} else {
						html += propvalue + " (Function)";
					}
				}
			}
		}
		html += "</div>";
		if (this.components.binding) {
			html += "<h3>This object has the following bindings</h3><div style='margin-left: 40px;'><ul>\n";
			var wires = this.components.binding.components;
			for (var i in wires) {
				html += "<li><b>this." + wires[i].targetProperty + "</b> is bound to <i>" + (wires[i].source || wires[i].expression) + "</i></li>\n";
			}
			html += "</ul></div>";
		}
		html += "<h3>The following objects are bound to this</h3><div style='margin-left: 40px;'> <ul>\n";
		var bindingHash = {};
		this.owner.generateBindingDescriptions(bindingHash, this);
		var wire;
		for (var i in bindingHash) {
			wire = bindingHash[i];
			html += "<li>" + wire.target.getId() + "." + wire.targetProperty + " is bound to <i>" + (wire.source || wire.expression) + "</i></li>\n";
		}
		html += "</ul></div>";
		return html;
	}, generateBindingDescriptions:function (inHash, comparisonObj) {
		if (this.components.binding) {
			var wires = this.components.binding.components;
			for (var i in wires) {
				var source = wires[i].source;
				var componentIds = [];
				if (source) {
					componentIds.push(source.replace(/\.[^\.]*/, ""));
				} else {
					var expression = wires[i].expression;
					var ids = expression.match(/\{(.*?)\}/g);
					for (var j = 0; j < ids.length; j++) {
						ids[j] = ids[j].substring(1, ids[j].length - 1);
						var idparts = ids[j].split(/\./);
						idparts.pop();
						if (idparts[0] == "app") {
							idparts.shift();
						}
						while (idparts.length) {
							componentIds.push(idparts.join("."));
							idparts.pop();
						}
					}
				}
				if (componentIds.indexOf(comparisonObj.getId()) != -1) {
					inHash[wires[i].target.getId()] = wires[i];
				}
			}
		}
		for (var i in this.components) {
			this.components[i].generateBindingDescriptions(inHash, comparisonObj);
		}
	}, editProp:function (inName, inValue) {
		switch (inName) {
		  case "documentation":
			studio.documentationDialog.setHtml(this.documentation);
			studio.documentationDialog.setTitle("Document " + this.getId());
			studio.documentationDialog.editComponent = this;
			studio.documentationDialog.show();
			return;
		  case "generateDocumentation":
			this.documentation = ((this.documentation) ? this.documentation + "<br/><br/><br/>" : "") + this.generateDocumentation();
			this.editProp("documentation");
			return;
		}
		var s = (this.schema[inName] || 0);
		if (s.operation) {
			return wm.fire(this, s.operation);
		}
		var c = this.components[inName];
		if (c) {
			return this.editComponentProp(c);
		}
		var n = inName, v = inValue || this.generateEventName(n);
		this.setEvent(n, v);
		eventEdit(this, n, v);
	}, getSharedEventLookupName:function (inProp) {
		return inProp;
	}});
}
if (!dojo._hasResource["wm.base.Control"]) {
	dojo._hasResource["wm.base.Control"] = true;
	dojo.provide("wm.base.Control");
	wm.splitUnits = function (inUnitValue) {
		if (!dojo.isString(inUnitValue)) {
			return {value:inUnitValue, units:"px"};
		}
		var m = (inUnitValue || "").match(wm.splitUnits.Rx);
		return {value:Number(m[1]) || 0, units:m[2] || "px"};
	};
	wm.splitUnits.Rx = /(\d*)(.*)/;
	dojo.declare("wm.Bounds", null, {padding:"", border:"", margin:"", constructor:function () {
		this.bounds = {l:0, t:0, w:96, h:64};
		this.borderExtents = {l:0, t:0, r:0, b:0};
		this.paddingExtents = {l:0, t:0, r:0, b:0};
		this.marginExtents = {l:0, t:0, r:0, b:0, w:0, h:0};
		this.padBorderMargin = {};
		this.calcPadBorderMargin();
	}, getBounds:function () {
		return this.bounds;
	}, setBounds:function (inL, inT, inW, inH) {
		if (arguments.length == 1) {
			return this.setBounds(inL.l, inL.t, inL.w, inL.h);
		}
		var b = this.bounds;
		if (!isNaN(inL) && b.l != inL) {
			b.l = inL;
		}
		if (!isNaN(inT) && b.t != inT) {
			b.t = inT;
		}
		if (inW >= 0 && b.w != inW) {
			b.w = inW;
			this._boundsDirty = true;
		}
		if (inH >= 0 && b.h != inH) {
			b.h = inH;
			this._boundsDirty = true;
		}
		b.r = b.l * 1 + b.w * 1;
		b.b = b.t * 1 + b.h * 1;
		return b;
	}, setContentBounds:function (inBox) {
		var b = {};
		var sm = this.getScrollMargins();
		if ("w" in inBox) {
			b.w = inBox.w + this.padBorderMargin.w + sm.w;
		}
		if ("h" in inBox) {
			b.h = inBox.h + this.padBorderMargin.h + sm.h;
		}
		return this.setBounds(b);
	}, _parseExtents:function (inExtents) {
		var r = {};
		if (typeof inExtents == "number") {
			r = {l:inExtents, t:inExtents, r:inExtents, b:inExtents};
		} else {
			var ex = inExtents.split(",");
			var l = ex.length;
			r.t = parseFloat(ex[0]) || 0;
			r.r = l < 2 ? r.t : parseFloat(ex[1]) || 0;
			r.b = l < 3 ? r.t : parseFloat(ex[2]) || 0;
			r.l = l < 4 ? r.r : parseFloat(ex[3]) || 0;
		}
		return r;
	}, _stringifyExtents:function (inExtents) {
		return inExtents.t + "," + inExtents.r + "," + inExtents.b + "," + inExtents.l;
	}, setPadding:function (inPadding) {
		this.padding = String(inPadding);
		this.paddingExtents = this._parseExtents(this.padding);
		this.padBorderMarginChanged();
		this.invalidCss = true;
		this.render();
	}, setBorder:function (inBorder) {
		inBorder = String(inBorder);
		inBorder = (inBorder && inBorder.match(/\d/)) ? inBorder : "0";
		if (inBorder !== this.border) {
			this.border = inBorder;
			this.borderExtents = this._parseExtents(inBorder);
			this.padBorderMarginChanged();
			this.invalidCss = true;
			this.render();
		}
	}, setMargin:function (inMargin) {
		this.margin = String(inMargin);
		var me = this.marginExtents = this._parseExtents(this.margin);
		me.h = me.t + me.b;
		me.w = me.l + me.r;
		this.padBorderMarginChanged();
		this.invalidCss = true;
		this.render();
	}, setOneMargin:function (inMargin, edge) {
		var m = this.marginExtents;
		m[edge] = inMargin;
		this.setMargin(this._stringifyExtents(m));
	}, padBorderMarginChanged:function () {
		this.calcPadBorderMargin();
	}, _edges:{l:1, t:1, r:1, b:1}, calcPadBorderMargin:function () {
		var pbm = this.padBorderMargin;
		for (var e in this._edges) {
			pbm[e] = this.borderExtents[e] + this.paddingExtents[e] + this.marginExtents[e];
		}
		pbm.w = pbm.l + pbm.r;
		pbm.h = pbm.t + pbm.b;
	}, getScrollMargins:function () {
		return {w:0, h:0};
	}, getContentBounds:function () {
		var sm = this.getScrollMargins();
		var b = {l:this.paddingExtents.l, t:this.paddingExtents.t, w:Math.floor(this.bounds.w) - this.padBorderMargin.w - sm.w, h:Math.floor(this.bounds.h) - this.padBorderMargin.h - sm.h};
		if (b.w < 0) {
			b.w = 0;
		}
		if (b.h < 0) {
			b.h = 0;
		}
		b.r = b.l + b.w;
		b.b = b.t + b.h;
		return b;
	}, getStyleBounds:function () {
		if (this.isRelativePositioned) {
			return {w:this.width, h:this.height};
		}
		var pbm = (this.dom.node.tagName.toLowerCase() == "button") ? this.marginExtents : this.padBorderMargin;
		var b = {l:this.bounds.l, t:this.bounds.t, w:this.bounds.w - pbm.w, h:this.bounds.h - pbm.h};
		if (b.w < 0) {
			b.w = 0;
		}
		if (b.h < 0) {
			b.h = 0;
		}
		b.r = b.l + b.w;
		b.b = b.t + b.h;
		return b;
	}, cloneBounds:function () {
		with (this.bounds) {
			return {l:l, t:t, w:w, h:h, r:r, b:b};
		}
	}});
	dojo.declare("wm.DomNode", null, {constructor:function (inNode, isRelativePositioned) {
		this.node = inNode || document.createElement("div");
		this.isRelativePositioned = isRelativePositioned;
	}, append:function (inDomNode) {
		this.node.appendChild(inDomNode.node);
	}, remove:function (inDomNode) {
		this.node.removeChild(inDomNode.node);
	}, getWidth:function () {
		return this.node.offsetWidth;
	}, getHeight:function () {
		return this.node.offsetHeight;
	}, setBox:function (inBox, inSingleLine) {
		var s = this.node.style;
		if (this.isRelativePositioned) {
			s.width = inBox.w;
			s.height = inBox.h;
			return;
		}
		var bl = inBox.l + "px";
		if (!isNaN(inBox.l) && s.left != bl) {
			s.left = bl;
		}
		var bt = inBox.t + "px";
		if (!isNaN(inBox.t) && s.top != bt) {
			s.top = bt;
		}
		var bw = inBox.w + "px";
		if (inBox.w >= 0 && s.width != bw) {
			s.width = bw;
		}
		var bh = inBox.h + "px";
		if (inBox.h >= 0) {
			s.height = bh;
			s.lineHeight = inSingleLine ? bh : "normal";
		}
	}, setCssText:function (inText) {
		this.node.style.cssText += ";" + inText;
	}, addCssText:function (inText) {
		this.node.style.cssText += inText;
	}});
	wm.aligns = ["topLeft", "center", "bottomRight", "justified"];
	wm.define("wm.Control", [wm.Component, wm.Bounds], {published:{invalidCss:{ignore:1}, renderedOnce:{ignore:1}, bounds:{ignore:1}, border:{group:"style"}, borderColor:{group:"style"}, backgroundColor:{ignore:1}, margin:{group:"style"}, padding:{group:"style"}, autoScroll:{group:"scrolling", order:100, ignore:1}, scrollX:{group:"scrolling", order:101}, scrollY:{group:"scrolling", order:102}, left:{writeonly:1, ignore:1}, top:{writeonly:1, ignore:1}}, renderedOnce:0, invalidCss:1, autoScroll:false, backgroundColor:"", borderColor:"#F0F0F0", binding:"(data binding)", classNames:"", id:"", autoSizeWidth:false, autoSizeHeight:false, _needsAutoSize:true, width:"", height:"", minHeight:0, minWidth:0, left:0, top:0, group:"", styles:"", state:null, showing:true, disabled:false, container:false, _classes:{domNode:[]}, scrollX:false, scrollY:false, constructor:function () {
		this.widgets = {};
		this._classes = dojo.clone(this._classes);
	}, prepare:function (inProps) {
		try {
			if (inProps) {
				var owner = inProps.owner;
				if (owner) {
					owner = owner.getOwnerApp();
				}
				if (owner) {
					owner.loadThemePrototypeForClass(this.constructor, this);
				}
			}
		}
		catch (e) {
			console.error("What the hell?" + e);
		}
		this.inherited(arguments);
	}, postscript:function (inProps) {
		this.inherited(arguments);
	}, create:function () {
		this._cupdating = true;
		this.inherited(arguments);
	}, build:function () {
		this.domNode = dojo.byId(this.domNode || undefined);
		if (!this.domNode) {
			this.domNode = document.createElement("div");
		}
	}, initDomNode:function () {
		if (!this.dom) {
			this.dom = new wm.DomNode(this.domNode, this.isRelativePositioned);
			if (!this.isRelativePositioned) {
				this.domNode.style.position = "absolute";
			} else {
				this.domNode.style.position = "relative";
			}
			this.setParent(this.parent);
			this.setDomNode(this.domNode);
		}
	}, init:function () {
		this.initDomNode();
		this.inherited(arguments);
		this.bc();
		if (this.isDesignLoaded()) {
			this.set_border((this.border) ? String(this.border) : "0");
		} else {
			this.border = (this.border) ? String(this.border) : "0";
		}
		this.borderExtents = this._parseExtents(this.border);
		this.padding = String(this.padding);
		this.paddingExtents = this._parseExtents(this.padding);
		this.setMargin(this.margin);
		this.doSetSizeBc();
		if (!this.showing) {
			this.setShowing(false, true);
		}
		this.setDisabled(this.disabled);
		if (this.styles) {
			this.set_styles(this.styles);
			this.styles = "";
		}
		this.appendDOMNode(this.parent);
		this.updateBounds();
	}, bc:function () {
	}, postInit:function () {
		this._cupdating = false;
		this.inherited(arguments);
		this.render(1);
		if (!this.$.binding && this.isDesignLoaded()) {
			new wm.Binding({name:"binding", owner:this});
		}
	}, destroy:function () {
		if (this.isDestroyed) {
			return;
		}
		try {
			if (this.widgets) {
				var wids = [];
				for (var n in this.widgets) {
					wids.push(this.widgets[n]);
				}
				for (var i = 0, w; (w = wids[i]); i++) {
					w.destroy();
				}
				wids = [];
			}
			this.widgets = null;
			this.parentNode = null;
			this.setParent(null);
			wm.fire(this.designWrapper, "destroy");
			this.layout = null;
			this.inherited(arguments);
		}
		catch (e) {
			console.info("Error while destroying : " + this.name, e);
		}
		finally {
			if (this.domNode) {
				dojo.destroy(this.domNode);
			}
			this.domNode = null;
			this._designee = null;
			if (this.dom && this.dom.node) {
				dojo.destroy(this.dom.node);
				this.dom.node = null;
				this.dom = null;
			}
		}
	}, loaded:function () {
		this.inherited(arguments);
		this.initUserClasses();
	}, setDomNode:function (inDomNode) {
		var n = this.domNode = inDomNode;
		if (dojo.isIE) {
			n.style.width = "0px";
		}
		this.updateId();
		var cNames = this.classNames + (this.owner ? " " + this.owner.declaredClass.replace(/\./g, "") + "-" + this.name : "") + (this.isRelativePositioned && this.parent && this.parent.layoutKind == "left-to-right" ? " wmInlineDiv" : "");
		dojo.addClass(n, cNames);
		this.initUserClasses();
	}, isAncestorHiddenLayer:function () {
		if (this instanceof wm.Layout) {
			return false;
		}
		if (this instanceof wm.Layer && this.parent && this.parent.getActiveLayer() != this) {
			return true;
		}
		if (this.parent == null || !(this.parent instanceof wm.Control)) {
			return false;
		}
		return this.parent.isAncestorHiddenLayer();
	}, isAncestorHidden:function () {
		if (!this.showing) {
			return true;
		}
		if (this instanceof wm.Layout || this instanceof wm.Dialog) {
			return false;
		}
		if (this instanceof wm.Layer && this.parent.getActiveLayer() != this) {
			return true;
		}
		if (this.parent == null || !(this.parent instanceof wm.Control)) {
			return true;
		}
		return this.parent.isAncestorHidden();
	}, isAncestor:function (inParent) {
		var o;
		while (o && o != inParent) {
			o = o.parent;
		}
		return (o == inParent);
	}, updateId:function () {
		this.inherited(arguments);
		if (this.domNode) {
			var rid = this.getRuntimeId();
			this.domNode.rid = rid;
			this.domNode.id = rid.replace(/\./g, "_");
		}
	}, getUniqueName:function (inName) {
		return wm.findUniqueName(inName, [this, this.components, this.widgets]);
	}, setName:function (inName) {
		if (!inName) {
			return;
		}
		if (this.parent) {
			this.parent.removeWidget(this);
		}
		this.addRemoveDefaultCssClass(false);
		this.inherited(arguments);
		if (this.parent) {
			this.parent.addWidget(this);
		}
		this.addRemoveDefaultCssClass(true);
	}, addWidget:function (inWidget) {
		this.widgets[inWidget.name] = inWidget;
		var p = this.containerNode || this.domNode;
		if (inWidget.domNode.parentNode != p) {
			p.appendChild(inWidget.domNode);
		}
	}, insertDomNodes:function () {
		for (var i in this.widgets) {
			this.widgets[i].insertDomNodes();
		}
		var parentPage = this.getParentPage();
		try {
			var a = 1;
			if ((!parentPage || parentPage._disableRendering) && this.invalidCss) {
				this.renderCss();
				this.invalidCss = false;
			}
			var p = this.containerNode || this.parentNode || this.parent.domNode;
			if (this.domNode.parentNode != p && this.domNode.parentNode != window.document.body) {
				p.appendChild(this.domNode);
			}
		}
		catch (e) {
			console.log("ERROR INSERTING DOM NODES FOR " + this.name);
		}
	}, leafFirstRenderCss:function () {
		for (var i in this.widgets) {
			this.widgets[i].leafFirstRenderCss();
		}
		if (this.invalidCss) {
			this.render(1);
		}
	}, removeWidget:function (inWidget) {
		if (this.widgets) {
			delete this.widgets[inWidget.name];
		}
	}, adjustChildProps:function (inCtor, inProps) {
		if (wm.isClassInstanceType(inCtor, wm.Control)) {
			dojo.mixin(inProps, {owner:this.owner, parent:this});
		} else {
			this.inherited(arguments);
		}
	}, listProperties:function () {
		var p = this.inherited(arguments);
		p.autoSizeWidth.ignore = (!this.isSizeable() && !this.autoSizeWidth) || (this.schema.autoSizeWidth && this.schema.autoSizeWidth.ignore);
		p.autoSizeHeight.ignore = (!this.isSizeable() && !this.autoSizeHeight) || (this.schema.autoSizeHeight && this.schema.autoSizeHeight.ignore);
		p.minWidth.ignore = !this.schema.minWidth || this.schema.minWidth.ignore || (!this._percEx.w && !this.autoSizeWidth);
		p.minHeight.ignore = this.schema.minHeight.ignore || (!this._percEx.h && !this.autoSizeHeight);
		p.width.ignore = p.width.writeonly = this.schema.width.ignore || !this.isSizeable() || this.autoSizeWidth;
		p.height.ignore = p.height.writeonly = this.schema.height.ignore || !this.isSizeable() || this.autoSizeHeight;
		if (p._classes) {
			p._classes.writeonly = (dojo.isArray(this._classes) && this._classes.length) || !wm.isEmpty(this._classes);
		}
		return p;
	}, doSetSizeBc:function () {
		if (this.sizeUnits == "flex") {
			this.setFlex(this.size);
		} else {
			if (this.sizeUnits) {
				var b = this.getParentBox(), p = {v:"height", h:"width"}[b];
				this.setSizeProp(p, this.size + this.sizeUnits);
			} else {
				if (this.flex) {
					this.setFlex(this.flex);
				}
			}
		}
	}, setFlex:function (inFlex) {
		var box = this.getParentBox();
		if (box) {
			var ex = {h:"width", v:"height"}[box];
			this.setSizeProp(ex, inFlex * 100 + "%");
			this._boundsDirty = true;
		} else {
			this.setSizeProp("width", inFlex * 100 + "%");
			this.setSizeProp("height", inFlex * 100 + "%");
		}
	}, getScrollMargins:function () {
		return {w:(this.scrollY || this._xscrollY) ? 17 : 0, h:(this.scrollX || this._xscrollX) ? 17 : 0};
	}, isReflowEnabled:function () {
		if (this._cupdating) {
			return false;
		}
		if (this.owner) {
			if (wm.isInstanceType(this.owner, wm.Control)) {
				return this.owner.isReflowEnabled();
			} else {
				return !this.owner._loadingPage;
			}
		}
		return true;
	}, padBorderMarginChanged:function () {
		this.inherited(arguments);
		if (!this._doingAutoSize) {
			this._needsAutoSize = true;
		}
		if (this.isReflowEnabled()) {
			if (this.parent) {
				this.parent.reflow();
			} else {
				this.render();
				wm.fire(this, "flow");
			}
		}
	}, boundsResized:function () {
		var box = dojo.marginBox(this.dom.node);
		if (this.bounds.w != box.w) {
			this.width = this.bounds.w + "px";
		}
		if (this.bounds.h != box.h) {
			this.height = this.bounds.h + "px";
		}
		this.updateBounds();
	}, updateBounds:function () {
		this._percEx = {w:0, h:0};
		var su = wm.splitUnits(this.width);
		var w = su.value;
		switch (su.units) {
		  case "flex":
			w *= 100;
			this._percEx.w = w;
			this.width = w + "%";
			w = NaN;
			break;
		  case "em":
			w *= 18;
			this.width = w + "px";
			break;
		  case "%":
			this._percEx.w = w;
			w = NaN;
			break;
		}
		su = wm.splitUnits(this.height);
		var h = su.value;
		switch (su.units) {
		  case "flex":
			h *= 100;
			this._percEx.h = h;
			this.height = h + "%";
			h = NaN;
			break;
		  case "em":
			h *= h * 18;
			this.height = h + "px";
			break;
		  case "%":
			this._percEx.h = h;
			h = NaN;
			break;
		}
		this.setBounds(NaN, NaN, w, h);
	}, getParentBox:function () {
		var n = (this.domNode || 0).parentNode;
		return n && (n.box || (n.getAttribute && n.getAttribute("box"))) || (this.parent || 0).box || "";
	}, adjustSetSizeProp:function (n, v) {
		return v;
	}, setSizeProp:function (n, v, inMinSize) {
		var minName = "min" + wm.capitalize(n);
		var getMin = "getMin" + wm.capitalize(n) + "Prop";
		var minSize = inMinSize || this[getMin]();
		v = this.adjustSetSizeProp(n, v);
		if (this[n] == v && this[minName] == inMinSize) {
			if (v.match(/px/) && parseInt(v) != this.bounds[(n == "height") ? "h" : "w"]) {
			} else {
				return;
			}
		}
		this[n] = v;
		this[minName] = inMinSize;
		if (!this._doingAutoSize) {
			this._needsAutoSize = true;
			if (this.autoSizeHeight && n == "height") {
				this.autoSizeHeight = false;
			}
			if (this.autoSizeWidth && n == "width") {
				this.autoSizeWidth = false;
			}
		}
		if (this.designWrapper) {
			this.designWrapper.invalidCss = true;
		}
		if (!this._loading) {
			this.updateBounds();
		}
		if (this.isReflowEnabled() && this.showing) {
			this.reflowParent();
		}
	}, setWidth:function (inWidth) {
		this.setSizeProp("width", inWidth, this.minWidth);
	}, setHeight:function (inHeight) {
		this.setSizeProp("height", inHeight, this.minHeight);
	}, setMinWidth:function (inMinWidth) {
		inMinWidth = (inMinWidth) ? parseInt(inMinWidth) : 0;
		this.setSizeProp("width", this.width, inMinWidth);
	}, setMinHeight:function (inMinHeight) {
		inMinHeight = (inMinHeight) ? parseInt(inMinHeight) : 0;
		this.setSizeProp("height", this.height, inMinHeight);
	}, getMinWidthProp:function () {
		return this.minWidth || 30;
	}, getMinHeightProp:function () {
		return this.minHeight || 15;
	}, setMaxHeight:function (inMaxHeight) {
		inMaxHeight = parseInt(inMaxHeight) || 0;
		this.maxHeight = inMaxHeight;
		if (inMaxHeight > this.bounds.h) {
			this.reflowParent();
		}
	}, getDomHeight:function () {
		return dojo.coords(this.domNode, false).h;
	}, getDomWidth:function () {
		return dojo.coords(this.domNode, false).w;
	}, doAutoSize:function (setSize, force) {
		if (this._doingAutoSize || !this.autoSizeHeight && !this.autoSizeWidth) {
			return;
		}
		if (!force && !this._needsAutoSize) {
			return;
		}
		if (this.isAncestorHidden()) {
			return;
		}
		this._doingAutoSize = true;
		this._needsAutoSize = false;
		if (this.autoSizeWidth) {
			this.domNode.style.width = "";
			var neww = dojo.coords(this.domNode).w;
			if (this.minWidth && this.minWidth > neww) {
				neww = this.minWidth;
			}
			if (setSize) {
				this.setWidth(neww + "px");
			} else {
				this.bounds.w = neww;
				this.domNode.style.width = neww + "px";
			}
		}
		if (this.autoSizeHeight) {
			this.domNode.style.height = "";
			var newh = dojo.coords(this.domNode).h;
			if (this.minHeight && this.minHeight > neww) {
				newh = this.minHeight;
			}
			if (setSize) {
				this.setHeight(newh + "px");
			} else {
				this.bounds.h = newh;
				this.domNode.style.height = newh + "px";
			}
		}
		if (this.isDesignLoaded() && studio.designer.selected == this) {
			setTimeout(dojo.hitch(studio.inspector, "reinspect"), 100);
		}
		this._doingAutoSize = false;
	}, setAutoSizeWidth:function (inAutoSize) {
		this.autoSizeWidth = inAutoSize;
		if (this.autoSizeWidth) {
			if (this._percEx.w) {
				this.width = this.bounds.w + "px";
				this._percEx.w = 0;
			}
			this.doAutoSize(1, 1);
		}
	}, setAutoSizeHeight:function (inAutoSize) {
		this.autoSizeHeight = inAutoSize;
		if (this.autoSizeHeight) {
			if (this._percEx.h) {
				this.height = this.bounds.h + "px";
				this._percEx.h = 0;
			}
			this.doAutoSize(1, 1);
		}
	}, disruptChromeOverflow:function (propName) {
		if (dojo.isChrome) {
			if (!this[propName] || !this[propName].style) {
				return;
			}
			if (this["_disruptChromeOverflowPending_" + propName]) {
				return;
			}
			this["_disruptChromeOverflowPending_" + propName] = true;
			this[propName].style.overflow = "none";
			wm.onidle(this, function () {
				this[propName].style.overflow = "auto";
				this["_disruptChromeOverflowPending_" + propName] = false;
			});
		}
	}, render:function (forceRender) {
		if (forceRender || this.isReflowEnabled()) {
			this.renderCss();
		} else {
			this.invalidCss = true;
		}
		return true;
	}, renderCss:function () {
		if (!this.invalidCss) {
			return;
		}
		this.invalidCss = false;
		var cssObj = this.buildCssSetterObj();
		if (!this.renderedOnce && (dojo.isFF || dojo.isSafari || dojo.isChrome)) {
			this.setCssViaCssText(cssObj);
			this.renderedOnce = 1;
		} else {
			this.setCssViaDom(cssObj);
		}
		if (!this.noRenderBounds) {
			this.renderBounds();
		}
	}, buildCssSetterObj:function () {
		var marginSplitter = this.getCssSplitter(this.margin);
		var paddingSplitter = this.getCssSplitter(this.padding);
		var borderSplitter = this.getCssSplitter(this.border);
		if (this.margin.indexOf(",") == -1 && this.margin.indexOf(" ") != -1) {
			marginSplitter = " ";
		}
		var paddArr = this.padding.split(paddingSplitter);
		if (this.designBorderState) {
			return {margin:(this.margin.split(marginSplitter).join("px ") || 0) + "px", padding:(paddArr.join("px ") || 0) + "px", borderLeftStyle:(this.designBorderState && this.designBorderState.l) ? "dashed" : "solid", borderRightStyle:(this.designBorderState && this.designBorderState.r) ? "dashed" : "solid", borderTopStyle:(this.designBorderState && this.designBorderState.t) ? "dashed" : "solid", borderBottomStyle:(this.designBorderState && this.designBorderState.b) ? "dashed" : "solid", borderLeftColor:(this.designBorderState && this.designBorderState.l) ? "#C1C1C1" : this.borderColor, borderRightColor:(this.designBorderState && this.designBorderState.r) ? "#C1C1C1" : this.borderColor, borderTopColor:(this.designBorderState && this.designBorderState.t) ? "#C1C1C1" : this.borderColor, borderBottomColor:(this.designBorderState && this.designBorderState.b) ? "#C1C1C1" : this.borderColor, borderLeftWidth:((this.designBorderState && this.designBorderState.l) ? "1" : this.borderExtents.l) + "px", borderRightWidth:((this.designBorderState && this.designBorderState.r) ? "1" : this.borderExtents.r) + "px", borderTopWidth:((this.designBorderState && this.designBorderState.t) ? "1" : this.borderExtents.t) + "px", borderBottomWidth:((this.designBorderState && this.designBorderState.b) ? "1" : this.borderExtents.b) + "px", backgroundColor:this.backgroundColor, overflow:(this.autoScroll || this._xscrollX || this._xscrollY ? "auto" : "hidden"), overflowX:(this.scrollX ? "scroll" : "hidden"), overflowY:(this.scrollY ? "scroll" : "hidden")};
		} else {
			return {margin:(this.margin.split(marginSplitter).join("px ") || 0) + "px", padding:(paddArr.join("px ") || 0) + "px", borderStyle:"solid", borderWidth:(this.border.split(borderSplitter).join("px ") || 0) + "px", borderColor:this.borderColor, backgroundColor:this.backgroundColor, overflow:(this.autoScroll || this._xscrollX || this._xscrollY ? "auto" : "hidden"), overflowX:(this.scrollX ? "scroll" : "hidden"), overflowY:(this.scrollY ? "scroll" : "hidden")};
		}
	}, setCssViaCssText:function (cssObj) {
		if (!this.domNode) {
			return;
		}
		if (this.designBorderState) {
			this.domNode.style.cssText += "margin:" + cssObj.margin + ";" + "padding:" + cssObj.padding + ";" + "border-top:" + cssObj.borderTopStyle + " " + cssObj.borderTopWidth + " " + cssObj.borderTopColor + ";" + "border-bottom:" + cssObj.borderBottomStyle + " " + cssObj.borderBottomWidth + " " + cssObj.borderBottomColor + ";" + "border-right:" + cssObj.borderRightStyle + " " + cssObj.borderRightWidth + " " + cssObj.borderRightColor + ";" + "border-left:" + cssObj.borderLeftStyle + " " + cssObj.borderLeftWidth + " " + cssObj.borderLeftColor + ";" + (cssObj.backgroundColor ? "background-color:" + cssObj.backgroundColor + ";" : "") + "overflow-x:" + ((cssObj.overflow != "auto") ? cssObj.overflowX : cssObj.overflow) + ";" + "overflow-y:" + ((cssObj.overflow != "auto") ? cssObj.overflowY : cssObj.overflow) + ";";
		} else {
			this.domNode.style.cssText += "margin:" + cssObj.margin + ";" + "padding:" + cssObj.padding + ";" + "border-style:" + cssObj.borderStyle + ";" + "border-width:" + cssObj.borderWidth + ";" + "border-color:" + cssObj.borderColor + ";" + (cssObj.backgroundColor ? "background-color:" + cssObj.backgroundColor + ";" : "") + "overflow-x:" + ((cssObj.overflow != "auto") ? cssObj.overflowX : cssObj.overflow) + ";" + "overflow-y:" + ((cssObj.overflow != "auto") ? cssObj.overflowY : cssObj.overflow) + ";";
		}
	}, setCssViaDom:function (cssObj) {
		if (!this.domNode) {
			return;
		}
		var s = this.domNode.style;
		try {
			if (s.margin != cssObj.margin && !(s.margin == "" && cssObj.margin == "0px")) {
				s.margin = cssObj.margin;
			}
			if (s.padding != cssObj.padding) {
				s.padding = cssObj.padding;
			}
			if (!this.designBorderState) {
				if (s.borderStyle != cssObj.borderStyle) {
					s.borderStyle = cssObj.borderStyle;
				}
				if (s.borderWidth != cssObj.borderWidth) {
					s.borderWidth = cssObj.borderWidth;
				}
				if (s.borderColor != cssObj.borderColor) {
					s.borderColor = cssObj.borderColor;
				}
			} else {
				s.borderLeft = cssObj.borderLeftStyle + " " + cssObj.borderLeftWidth + " " + cssObj.borderLeftColor;
				s.borderRight = cssObj.borderRightStyle + " " + cssObj.borderRightWidth + " " + cssObj.borderRightColor;
				s.borderTop = cssObj.borderTopStyle + " " + cssObj.borderTopWidth + " " + cssObj.borderTopColor;
				s.borderBottom = cssObj.borderBottomStyle + " " + cssObj.borderBottomWidth + " " + cssObj.borderBottomColor;
			}
			if (cssObj.backgroundColor) {
				s.backgroundColor = cssObj.backgroundColor;
			}
			var o = (cssObj.overflow != "auto") ? cssObj.overflowX : cssObj.overflow;
			if (s.overflowX != o) {
				s.overflowX = o;
			}
			o = (cssObj.overflow != "auto") ? cssObj.overflowY : cssObj.overflow;
			if (s.overflowY != o) {
				s.overflowY = o;
			}
		}
		catch (e) {
			console.error("Invalid style specified for " + this.name + ": " + e);
		}
	}, getCssSplitter:function (value) {
		var splitter = ",";
		value = dojo.string.trim(value);
		if (value.indexOf(",") == -1 && value.indexOf(" ") != -1) {
			splitter = " ";
		}
		return splitter;
	}, renderBounds:function () {
		if (this.dom) {
			this.dom.setBox(this.getStyleBounds(), this.singleLine);
		}
		if (this.designWrapper) {
			this.designWrapper.controlBoundsChange();
			this.designWrapper.renderBounds();
		}
	}, reflow:function () {
	}, reflowParent:function () {
		wm.fire(this.parent, "reflow");
	}, setScrollX:function (inScrollX) {
		this.scrollX = inScrollX;
		this.invalidCss = true;
		this.render();
		this.reflowParent();
	}, setScrollY:function (inScrollY) {
		this.scrollY = inScrollY;
		this.invalidCss = true;
		this.render();
		this.reflowParent();
	}, setAutoScroll:function (inAutoScroll) {
		this.autoScroll = inAutoScroll;
		if (inAutoScroll) {
			if (this.isDesignLoaded() && (this.scrollX || this.scrollY)) {
				this.scrollX = false;
				this.scrollY = false;
				if (studio.designer.selected == this) {
					studio.inspector.reinspect();
				}
			}
		}
		this.noRenderBounds = true;
		this.invalidCss = true;
		this.renderCss();
		delete this.noRenderBounds;
	}, groupHandler:function (inMessage, inArgument) {
		switch (inMessage) {
		  case "disabled":
			this.setDisabled(inDisabled);
			break;
		}
	}, show:function () {
		this.setValue("showing", true);
	}, hide:function () {
		this.setValue("showing", false);
	}, disable:function () {
		this.setValue("disabled", true);
	}, enable:function () {
		this.setValue("disabled", false);
	}, toString:function () {
		return "[" + this.declaredClass + ((this.name) ? ":" + this.name : "") + ((!this.showing) ? "(hidden)" : "") + "]";
	}, setParent:function (inParent) {
		var oldParent = this.parent;
		var newParent = this.parent = inParent;
		if (inParent && inParent.containerWidget && inParent.containerWidget.owner == inParent) {
			newParent = this.parent = inParent.containerWidget;
		}
		if (oldParent && oldParent != newParent) {
			oldParent.removeWidget(this);
			if (oldParent.removeControl) {
				oldParent.removeControl(this);
			}
		}
		if (!this._cupdating) {
			this.appendDOMNode(newParent);
		}
		if (newParent && oldParent) {
			dojo.publish("wmwidget-parentChange", [oldParent, newParent, this]);
		}
	}, appendDOMNode:function (inParent) {
		var newParent = inParent;
		if (newParent) {
			newParent.addWidget(this);
			if (newParent.addControl) {
				newParent.addControl(this);
			}
		} else {
			if (this.parentNode && this.domNode) {
				this.parentNode.appendChild(this.domNode);
			}
		}
	}, canChangeShowing:function () {
		return true;
	}, setShowing:function (inShowing, forceChange) {
		if (!this.canChangeShowing()) {
			return;
		}
		if (forceChange || this.showing != inShowing) {
			this.showing = inShowing;
			this.domNode.style.display = inShowing ? "" : "none";
			this.reflowParent();
		}
	}, setDisabled:function (inDisabled) {
		for (var i in this.widgets) {
			this.widgets[i].setDisabled(inDisabled);
		}
		this.disabled = inDisabled;
	}, setGroup:function (inGroup) {
		this.group = inGroup;
		dojo.unsubscribe(this._subscription);
		if (this.group) {
			this._subscription = dojo.subscribe(this.group, this, "groupHandler");
		}
	}, setBackgroundColor:function (inColor) {
		this.backgroundColor = inColor;
		this.invalidCss = true;
		this.render();
	}, setBorderColor:function (inColor) {
		this.borderColor = inColor;
		this.invalidCss = true;
		this.render();
	}, addRemoveDefaultCssClass:function (inAdd) {
		if (this.owner) {
			dojo[inAdd ? "addClass" : "removeClass"](this.domNode, this.owner.declaredClass + "-" + this.name);
		}
	}, getUserNodeClasses:function (inNodeName) {
		var klasses = this._classes;
		for (var i in klasses) {
			if (inNodeName == i) {
				return klasses[i].join(" ");
			}
		}
		return "";
	}, initUserClasses:function () {
		if (dojo.isArray(this._classes)) {
			this._classes = {domNode:this._classes};
		}
		var klasses = this._classes;
		for (var i in klasses) {
			this.initUserNodeClasses(klasses[i], i);
		}
	}, initUserNodeClasses:function (inClasses, inNodeName) {
		var k = inClasses || [], n = this[inNodeName];
		if (n) {
			dojo.addClass(n, k.join(" "));
		}
	}, addUserClass:function (inClass, inNodeName) {
		inNodeName = inNodeName || "domNode";
		var cs = this._classes[inNodeName] = this._classes[inNodeName] || [];
		cs.push(inClass);
		var n = this[inNodeName];
		if (n) {
			dojo.addClass(n, inClass);
		}
	}, removeUserClass:function (inClass, inNodeName) {
		inNodeName = inNodeName || "domNode";
		var n = this[inNodeName];
		if (n) {
			dojo.removeClass(n, inClass);
		}
		var cs = this._classes[inNodeName] || [];
		for (var i = 0, c; c = cs[i]; i++) {
			if (c == inClass) {
				cs.splice(i--, 1);
			}
		}
		if (!cs.length) {
			delete this._classes[inNodeName];
		}
	}, getOrderedWidgets:function () {
		return [];
	}, updatingEvent:function (prop, inValue) {
	}});
	wm.Widget = wm.Control;
}
if (!dojo._hasResource["wm.base.Control_design"]) {
	dojo._hasResource["wm.base.Control_design"] = true;
	dojo.provide("wm.base.Control_design");
	wm.isDesignable = function (inControl) {
		return inControl.owner && inControl.owner == studio.page;
	};
	wm.Control.extend({themeableProps:["border", "borderColor"], themeable:true, scrim:false, useDesignBorder:1, sizeable:true, _defaultClasses:null, getNumTabbableWidgets:function () {
		return 1;
	}, designMove:function (inTarget, inMoveInfo) {
		inTarget.designMoveControl(this, inMoveInfo);
	}, resizeUpdate:function (inBounds) {
		this.designWrapper._setBounds(inBounds);
	}, _removeStaticBounds:function (inBounds) {
		var domBox = dojo.marginBox(this.dom.node);
		if (domBox.w == inBounds.w) {
			delete inBounds.w;
		} else {
			this.autoSizeWidth = false;
		}
		if (domBox.h == inBounds.h) {
			delete inBounds.h;
		} else {
			this.autoSizeHeight = false;
		}
	}, _sizeFromNode:function (inBounds) {
		var domBox = dojo.marginBox(this.dom.node);
		if (("w" in inBounds)) {
			if (!this.fitToContentWidth) {
				this.width = domBox.w + "px";
			}
			this.autoSizeWidth = false;
		}
		if (("h" in inBounds)) {
			if (!this.fitToContentHeight) {
				this.height = domBox.h + "px";
			}
			this.autoSizeHeight = false;
		}
		this._needsAutoResize = true;
	}, designResize:function (inBounds) {
		this._removeStaticBounds(inBounds);
		this.setBounds(inBounds);
		this.renderBounds();
		this._sizeFromNode(inBounds);
		this.updateBounds();
		this._needsAutoSize = true;
		this.reflowParent();
		setTimeout(dojo.hitch(studio.inspector, "reinspect"), 100);
	}, designCreate:function () {
		this.inherited(arguments);
		if (wm.isDesignable(this)) {
			new wm.DesignWrapper({surface:this._designer, control:this});
		}
		if (this._studioCreating && this._defaultClasses) {
			this._classes = dojo.mixin({}, this._defaultClasses);
		}
	}, getDesignBorder:function (optionalBorder) {
		var useDesignBorder = studio.useDesignBorder && this.useDesignBorder && wm.isDesignable(this) && studio.selected != this;
		var border = this._parseExtents(optionalBorder || this.border);
		if (useDesignBorder) {
			this.designBorderState = {t:!Boolean(border.t), b:!Boolean(border.b), l:!Boolean(border.l), r:!Boolean(border.r)};
		} else {
			delete this.designBorderState;
		}
	}, set_margin:function (inMargin) {
		inMargin = dojo.trim(String(inMargin));
		inMargin = inMargin.replace(/\s*,\s*/g, ",");
		inMargin = inMargin.replace(/px/g, "");
		inMargin = inMargin.replace(/\s+/g, ",");
		this.setMargin(inMargin);
	}, set_padding:function (inPadding) {
		inPadding = dojo.trim(String(inPadding));
		inPadding = inPadding.replace(/\s*,\s*/g, ",");
		inPadding = inPadding.replace(/px/g, "");
		inPadding = inPadding.replace(/\s+/g, ",");
		this.setPadding(inPadding);
	}, set_border:function (inBorder) {
		inBorder = dojo.trim(String(inBorder));
		inBorder = inBorder.replace(/\s*,\s*/g, ",");
		inBorder = inBorder.replace(/px/g, "");
		inBorder = inBorder.replace(/\s+/g, ",");
		if (this.isDesignLoaded()) {
			this.getDesignBorder(inBorder);
		}
		this.setBorder(inBorder);
	}, getNodeStyles:function (inNodeName) {
		return getControlNodeStyles(this.name, inNodeName);
	}, setNodeStyles:function (inStyles, inNodeName) {
		setControlNodeStyles(this.name, inStyles, inNodeName);
		if (!this._stylesUpdating) {
			studio.cssChanged();
		}
	}, get_styles:function () {
		return getControlStyles(this.name);
	}, set_styles:function (inStyles) {
		this._stylesUpdating = true;
		if (dojo.isArray(inStyles)) {
			for (var i = 0, s; (s = inStyles[i]); i++) {
				this.setNodeStyles(s.css, s.node);
			}
		} else {
			this.setNodeStyles(inStyles);
		}
		this._stylesUpdating = false;
		if (!this._cupdating) {
			studio.cssChanged();
		}
	}, set_showing:function (inShowing) {
		this.setShowing(inShowing);
		wm.fire(this.designWrapper, "setShowing", [inShowing]);
	}, isParentLocked:function () {
		return this.parent && this.parent.container && this.parent.getLock();
	}, isParentFrozen:function () {
		return this.parent && this.parent.container && this.parent.getFreeze();
	}, isMoveable:function () {
		return this.isParentFrozen() ? false : this.moveable;
	}, isSizeable:function () {
		return !this.isParentFrozen() && this.sizeable;
	}, canResize:function (box) {
		return this.isSizeable();
	}, _sizeUnits:["px", "%"], makePropEdit:function (inName, inValue, inDefault) {
		switch (inName) {
		  case "styles":
			return makeTextPropEdit(inName, inValue, inDefault);
		  case "width":
		  case "height":
			return new wm.propEdit.UnitValue({component:this, name:inName, value:inValue, options:this._sizeUnits});
		  case "imageList":
			return new wm.propEdit.ImageListSelect({component:this, value:inValue, name:inName});
		  case "isTabbable":
			return new wm.propEdit.Select({component:this, value:inValue, name:inName, options:["false", "true", "accessibility-only"]});
		}
		return this.inherited(arguments);
	}, writeComponents:function (inIndent, inOptions) {
		var s = this.inherited(arguments);
		return s.concat(this.writeChildren(this.domNode, inIndent, inOptions));
	}, writeChildren:function (inNode, inIndent, inOptions) {
		return [];
	}});
	wm.Object.extendSchema(wm.Control, {numTabbableWidgets:{ignore:1}, internalTabIndex:{writeonly:1, ignore:1}, autoScroll:{ignore:1}, useDesignBorder:{ignore:1}, classNames:{ignore:1}, className:{ignore:1}, _classes:{ignore:1, category:"Styles", categoryProps:{content:"スタイル", image:"images/colorwheel_16.png", inspector:"Styles"}}, container:{ignore:1}, flex:{ignore:1}, group:{ignore:1}, html:{ignore:1}, id:{ignore:1}, owner:{ignore:1}, moveable:{ignore:1}, scrim:{ignore:1}, autoSizeWidth:{ignore:1}, autoSizeHeight:{ignore:1}, sizeable:{ignore:1}, styles:{ignore:1}, width:{group:"layout", order:20}, height:{group:"layout", order:30}, minWidth:{group:"advanced layout", order:40}, minHeight:{group:"advanced layout", order:50}, parent:{ignore:1}, domNode:{ignore:1}, parentNode:{ignore:1}, widgets:{ignore:1}, showing:{bindTarget:true, group:"common", order:30}, disabled:{bindTarget:true, type:"Boolean", group:"common", order:40}, size:{ignore:true}, sizeUnits:{ignore:true}});
}
if (!dojo._hasResource["wm.base.Widget"]) {
	dojo._hasResource["wm.base.Widget"] = true;
	dojo.provide("wm.base.Widget");
}
if (!dojo._hasResource["wm.base.Widget_design"]) {
	dojo._hasResource["wm.base.Widget_design"] = true;
	dojo.provide("wm.base.Widget_design");
}
if (!dojo._hasResource["wm.base.Plugin"]) {
	dojo._hasResource["wm.base.Plugin"] = true;
	dojo.provide("wm.base.Plugin");
	wm.Plugin = {targetClass:null, callerFactory:function (inOverrides) {
		return function (inArgs, inNewArgs) {
			var fn = inOverrides[inArgs.callee.nom];
			if (fn) {
				return fn.apply(this, inNewArgs || inArgs || []);
			}
		};
	}, plugin:function (inName, inClass, inProps) {
		var overrides = [];
		for (var p in inProps) {
			if (dojo.isFunction(inProps[p]) && inClass.prototype[p]) {
				overrides[p] = inClass.prototype[p];
			}
		}
		inProps[inName + "Socket"] = this.callerFactory(overrides);
		inClass.extend(inProps);
	}};
}
if (!dojo._hasResource["wm.base.components.Page"]) {
	dojo._hasResource["wm.base.components.Page"] = true;
	dojo.provide("wm.base.components.Page");
	dojo.connect(window, "onresize", function () {
		dojo.publish("window-resize");
	});
	var wmObjectList = [];
	wm.getObject = function (inType) {
		if (!wmObjectList[inType]) {
			wmObjectList[inType] = dojo.getObject(inType);
		}
		return wmObjectList[inType];
	};
	dojo.declare("wm.Page", wm.Component, {name:"", deletionDisabled:1, create:function () {
		this.inherited(arguments);
		if (!this.name) {
			this.name = this.declaredClass.toLowerCase();
		}
		this.render();
	}, getMainPage:function () {
		if (!this.owner) {
			return null;
		}
		var owner = this.owner;
		while (owner.owner) {
			owner = owner.owner;
		}
		if (owner instanceof wm.Application) {
			return owner;
		}
	}, destroy:function () {
		var owner = this.getMainPage();
		if (owner) {
			owner.subPageUnloaded(this);
		}
		if (window.app) {
			window.app.subPageUnloaded(this);
		}
		wm.fire(this.root, "destroy");
		this.inherited(arguments);
		delete this.app;
		delete this.domNode;
		delete this.root;
		owner = null;
		delete this._designee;
	}, init:function () {
		this.app = window.app;
		if (this.owner instanceof wm.Application) {
			window[this.name] = this;
		} else {
			this.owner[this.name] = this;
		}
		this.inherited(arguments);
	}, forEachWidget:function (inFunc) {
		if (this.root) {
			return wm.forEachWidget(this.root, inFunc);
		}
	}, render:function () {
		var d = this.domNode || document.body;
		var notAppOwned = (this.owner != app), ds = d.style;
		dojo.addClass(d, this.declaredClass);
		var previousStyleLeft = ds.left;
		if (notAppOwned) {
			ds.left = "-100000px";
		}
		wm.timePage && console.time("page.loadComponents");
		this._loadingPage = true;
		var startTime = new Date().getTime();
		var widgets = this.constructor.widgets || this.widgets;
		if (wm.isEmpty(widgets)) {
			alert("Page " + this.name + " has been corrupted, and no longer has a wm.Layout nor any widgets; please create a new project or edit " + this.name + ".widgets.js by hand");
		}
		this.loadComponents(widgets, null);
		wm.timePage && console.timeEnd("page.loadComponents");
		var self = this;
		dojo.addOnLoad(function () {
			self.postRender();
			if (notAppOwned) {
				ds.left = previousStyleLeft;
			}
			self.onShow();
		});
	}, postRender:function () {
		wm.timePage && console.time("root.reflow");
		wm.fire(this.root, "reflow");
		wm.timePage && console.timeEnd("root.reflow");
		wm.fire(this, "unloadSupport");
		try {
			this._loadingPage = false;
			if (this.root) {
				this.reflow();
			}
			this.start();
			this._startCalled = true;
			if (wm.debugPerformance) {
				var timeToLoad = this.stopTimerWithName("LoadPage", "wm.Layout");
				console.log("PAGE " + timeToLoad + " ms");
			}
			this.onStart();
		}
		catch (e) {
			console.error("Failed to initialize page " + this.name + "; " + e);
		}
	}, start:function () {
	}, reflow:function () {
		wm.fire(this.root, "reflow");
	}, addComponent:function (inComponent) {
		this[inComponent.name] = inComponent;
		if (inComponent instanceof wm.Widget) {
			if (this._designer && dojo.isIE) {
				var s = inComponent.domNode && dojo.getComputedStyle(inComponent.domNode);
				if (s && s.backgroundImage == "none") {
					inComponent.domNode.style.backgroundImage = "url(images/blank.gif)";
				}
			}
		}
		this.inherited(arguments);
	}, removeComponent:function (inComponent) {
		delete this[inComponent.name];
		this.inherited(arguments);
	}, isDesignLoaded:function () {
		return this.name == "wip";
	}, getRoot:function () {
		return this;
	}, getId:function (inName) {
		return inName;
	}, getRuntimeId:function (inId) {
		inId = this.name + (inId ? "." + inId : "");
		return this.owner ? this.owner.getRuntimeId(inId) : inId;
	}, getComponent:function (inName) {
		return this.components[inName] || this[inName] || this.owner && this.owner.getComponent(inName);
	}, _create:function (ctor, props) {
		if (ctor.prototype instanceof dijit._Widget && window.dijit) {
			return new wm.DijitWrapper(dojo.mixin(props || {}, {dijitClass:ctor, publishClass:p.declaredClass}));
		}
		return this.inherited(arguments);
	}, loadComponent:function (inName, inParent, inType, inProps, inEvents, inChildren, isSecond) {
		if (wm.debugPerformance) {
			if (inType == "wm.Layout") {
				if (dojo.isFF) {
					console.groupCollapsed("LOAD COMPONENT " + inType + ": " + inName);
				} else {
					console.group("LOAD COMPONENT " + inType + ": " + inName);
				}
			}
			this.startTimerWithName("LoadComponent", inType);
			this.startTimerWithName("LoadPage", inType);
		}
		var ctor = wm.getObject(inType);
		if (!ctor) {
			try {
				wm.getComponentStructure(inType);
				ctor = dojo.getObject(inType);
			}
			catch (e) {
				console.info("Error : Page.js trying to get component dynamically-------------> " + e);
			}
			if (!ctor) {
				console.debug("Component type \"" + inType + "\" is not available.");
				ctor = wm.Box;
			}
		}
		var props = {};
		isWidget = (ctor.prototype instanceof wm.Widget || ctor.prototype instanceof dijit._Widget);
		if (isWidget) {
			var parentNode = (inParent ? inParent.containerNode || inParent.domNode : this.domNode);
			props = {owner:this, parent:inParent, domNode:parentNode ? null : document.body, parentNode:parentNode};
		}
		var newOwner;
		if (inParent && inParent instanceof wm.Layout) {
			newOwner = inParent.owner;
		} else {
			if (inParent) {
				newOwner = inParent;
			} else {
				newOwner = this;
			}
		}
		props = dojo.mixin({}, inProps, {name:this.getUniqueName(inName), owner:newOwner, _designer:this._designer, _loading:true}, props);
		if (this.isRelativePositioned) {
			props.isRelativePositioned = true;
		}
		if (!this.isDesignLoaded()) {
			for (var p in props) {
				if (p.indexOf("custom") == 0 && dojo.isFunction(ctor.prototype[p])) {
					var owner = props.owner;
					props[p] = dojo.hitch(owner, owner[props[p]]);
				}
			}
		}
		var c = this._create(ctor, props);
		if (!inParent && isWidget) {
			c.moveable = false;
			this.root = c;
		}
		this.makeEvents(inEvents, c);
		if (inChildren) {
			this.loadComponents(inChildren, c);
		}
		c.loaded();
		var timeToLoad = this.stopTimerWithName("LoadComponent", inType);
		if (wm.debugPerformance) {
			if (inType == "wm.Layout") {
				console.log(inType + ": " + inName + " TOOK " + timeToLoad + " ms");
				console.groupEnd();
				this.printPagePerformanceData();
				console.log(inType + ": " + inName + " TOOK " + timeToLoad + " ms");
			}
		}
		return c;
	}, printPagePerformanceData:function () {
		var totalsByMethod = {};
		for (var componentType in wm.Component.timingByComponent) {
			var obj = wm.Component.timingByComponent[componentType];
			var display = false;
			for (var i in obj) {
				if (wm.sum(obj[i]) > 10) {
					display = true;
				}
			}
			console.group("Timing for " + componentType);
			for (var i in obj) {
				console.log(i + ": Total: " + wm.sum(obj[i]) + ", Average: " + wm.average(obj[i]) + ", Worst: " + wm.max(obj[i]) + ", Instances: " + obj[i].length);
				if (!totalsByMethod[i]) {
					totalsByMethod[i] = 0;
				}
				totalsByMethod[i] += wm.sum(obj[i]);
			}
			console.groupEnd();
		}
		for (var i in totalsByMethod) {
			console.log("TOTAL TIME IN " + i + ": " + totalsByMethod[i]);
		}
	}, loadComponents:function (inChildren, inParent) {
		for (var i in inChildren) {
			try {
				this.loadComponent(i, inParent, inChildren[i][0], inChildren[i][1], inChildren[i][2], inChildren[i][3]);
			}
			catch (e) {
				console.error("FAILED TO LOAD " + "[" + inChildren[i][1].name + "] " + i + ": ", e);
				console.log("COMPONENT:");
				console.log(inChildren);
				console.log("PARENT:");
				console.log(inParent);
			}
		}
	}, onShow:function () {
	}, onStart:function (inPage) {
	}, keydown:function (e) {
		if (wm.dialog.showing || this.owner != app || this != app._page) {
			return true;
		}
		var chr = String.fromCharCode(e.keyCode);
		if (e.shiftKey) {
			if (e.keyCode != dojo.keys.SHIFT) {
				this.onShiftKey(e.keyCode, chr);
			}
		} else {
			if (e.ctrlKey) {
				if (e.keyCode != dojo.keys.CTRL) {
					this.onCtrlKey(e.keyCode, chr);
				}
			} else {
				if (e.keyCode == dojo.keys.ESCAPE) {
					this.onEscapeKey();
				} else {
					if (e.keyCode == dojo.keys.ENTER) {
						this.onEnterKey();
					} else {
						if (chr) {
							this.onLetterKey(chr);
						} else {
							this.onMiscKey(e.keyCode);
						}
					}
				}
			}
		}
	}, onEnterKey:function () {
	}, onShiftKey:function (inKeyCode, inCharacter) {
	}, onCtrlKey:function (inKeyCode, inCharacter) {
	}, onEscapeKey:function () {
	}, onLetterKey:function (inCharacter) {
	}, onMiscKey:function (inKeyCode) {
	}, _end:0});
	wm.Page.extend({designCreate:function () {
		this.inherited(arguments);
		this.app = this.isDesignLoaded() ? studio.application : app;
	}, unloadSupport:function () {
		if (!this.isDesignLoaded() && window.studio && window.studio._isWaveMakerStudio) {
			this.constructor._supported = false;
			this.constructor.widgets = {};
		}
	}, generateEventName:function (inEventName) {
		return inEventName;
	}, _getProp:function (n) {
		if (window["studio"] && this == studio.page && this.isEventProp(n)) {
			return (getEvent(n, studio.getScript())) ? n : "";
		}
		return this.inherited(arguments);
	}});
	wm.Object.extendSchema(wm.Page, {onStart:{events:["js", "disableNoEvent"]}, onShow:{events:["js", "disableNoEvent"]}, onShiftKey:{events:["js", "disableNoEvent"]}, onCtrlKey:{events:["js", "disableNoEvent"]}, onEscapeKey:{events:["js", "disableNoEvent"]}, onEnterKey:{}, onLetterKey:{events:["js", "disableNoEvent"]}, onMiscKey:{events:["js", "disableNoEvent"]}});
	wm.Part = wm.Page;
}
if (!dojo._hasResource["wm.base.components.HtmlLoader"]) {
	dojo._hasResource["wm.base.components.HtmlLoader"] = true;
	dojo.provide("wm.base.components.HtmlLoader");
	wm.getNodeIds = function (inNode) {
		var ids = [];
		dojo.forEach(inNode.childNodes, function (n) {
			if (n.id) {
				ids.push(n.id);
			}
		});
		return ids;
	};
	dojo.declare("wm.HtmlLoader", wm.Component, {url:"", html:"", relativeUrl:true, init:function () {
		this.inherited(arguments);
		this.inherited(arguments);
		if (this.url) {
			this.setUrl(this.url);
		} else {
			this.setHtml(this.html);
		}
	}, destroy:function () {
		this.html = null;
		dojo.destroy(this._htmlNode);
		this._htmlNode = null;
		this.inherited(arguments);
	}, setUrl:function (inUrl) {
		this.url = inUrl || "";
		if (this.url) {
			var loadUrl = this.relativeUrl ? this.getPath() + this.url : this.url;
			this.setHtml(wm.load(loadUrl, true));
		}
	}, setHtml:function (inHtml) {
		this.clearHtml();
		this.html = inHtml || "";
		if (this.html) {
			this.addHtml(this.html);
		}
		dojo.publish("wm-markupchanged");
	}, clearHtml:function () {
		this.html = "";
		this.removeHtml();
	}, getHtmlNode:function () {
		if (!this._htmlNode) {
			var n = this._htmlNode = document.createElement("div");
			n.style.display = "none";
			document.body.appendChild(n);
		}
		return this._htmlNode;
	}, addHtml:function (inHtml) {
		if (this.isDesignLoaded()) {
			var p = this.getPath();
			inHtml = inHtml.replace(/<img([^>]*)src[^>]*=[^>]*(["'])([^(http:)\/][^>]*)\2/g, "<img$1src=\"" + p + "$3\"");
		}
		var n = this.getHtmlNode();
		n.innerHTML = [n.innerHTML, inHtml].join("\n");
	}, removeHtml:function () {
		var n = this.getHtmlNode();
		if (n) {
			n.innerHTML = "";
		}
	}, listProperties:function () {
		var p = this.inherited(arguments);
		p.html.ignore = this.url;
		return p;
	}, getNodeIds:function () {
		return wm.getNodeIds(this.getHtmlNode());
	}});
	wm.HtmlLoader.extend({makePropEdit:function (inName, inValue, inDefault) {
		switch (inName) {
		  case "html":
			return makeReadonlyButtonEdit(inName, "(html)", "(html)");
		}
		return this.inherited(arguments);
	}, editProp:function (inName, inValue, inInspector) {
		switch (inName) {
		  case "html":
			this.showHtmlDialog();
			return;
		}
		return this.inherited(arguments);
	}, showHtmlDialog:function () {
		var d = wm.getSyntaxEditorDialog();
		this._dialogConnect = dojo.connect(d, "onClose", this, "htmlDialogClosed");
		d.show();
		d.page.update(this.html, "html");
	}, htmlDialogClosed:function (inWhy) {
		dojo.disconnect(this._dialogConnect);
		this._dialogConnect = null;
		if (inWhy == "OK") {
			var d = wm.getSyntaxEditorDialog();
			this.setHtml(d.page.getEditorText());
		}
	}});
}
if (!dojo._hasResource["wm.base.components.CssLoader"]) {
	dojo._hasResource["wm.base.components.CssLoader"] = true;
	dojo.provide("wm.base.components.CssLoader");
	dojo.declare("wm.CssLoader", wm.Component, {url:"", css:"", relativeUrl:true, init:function () {
		this.inherited(arguments);
		if (this.url) {
			this.setUrl(this.url);
		} else {
			this.setCss(this.css);
		}
	}, destroy:function () {
		this._sheet = null;
		this.inherited(arguments);
	}, getStyleSheet:function () {
		if (dojo.isIE && !this._sheet) {
			this._sheet = wm.CssLoader.sheet || (wm.CssLoader.sheet = this.makeSheet());
		}
		if (!this._sheet) {
			this._sheet = this.makeSheet();
		}
		return this._sheet;
	}, makeSheet:function () {
		var sheet = document.createElement("style");
		sheet.setAttribute("type", "text/css");
		document.getElementsByTagName("head")[0].appendChild(sheet);
		return sheet;
	}, setUrl:function (inUrl) {
		this.url = inUrl || "";
		if (this.url) {
			var loadUrl = this.relativeUrl ? this.getPath() + this.url : this.url;
			this.setCss(wm.load(loadUrl, true));
		}
	}, setCss:function (inCss) {
		this.clearCss();
		this.css = inCss || "";
		if (this.css) {
			this.addCss(this.css);
		}
	}, clearCss:function () {
		this.css = "";
		this.removeCss();
	}, removeCss:function () {
		if (dojo.isIE) {
			return;
		}
		var s = this.getStyleSheet();
		if (s) {
			if (s.styleSheet) {
				s.styleSheet.cssText = "";
			} else {
				while (s.firstChild) {
					s.removeChild(s.firstChild);
				}
			}
		}
	}, addCss:function (inCss) {
		if (this.isDesignLoaded()) {
			var p = this.getPath();
			inCss = inCss.replace(/url\s*\(\s*([^(http:)\/].*)\.*\)/g, "url(" + p + "$1)");
		}
		var s = this.getStyleSheet();
		if (s.styleSheet) {
			s.styleSheet.cssText = [s.styleSheet.cssText, inCss].join("\n");
		} else {
			s.appendChild(document.createTextNode("\n"));
			s.appendChild(document.createTextNode(inCss));
		}
	}, listProperties:function () {
		var p = this.inherited(arguments);
		p.css.ignore = this.url;
		return p;
	}});
	wm.getSyntaxEditorDialog = function () {
		if (!wm._syntaxEditorDialog) {
			wm._syntaxEditorDialog = new wm.PageDialog({name:"syntaxEditorDialog", owner:studio, contentWidth:600, contentHeight:500, hideControls:true, pageName:"SyntaxEditor"});
		}
		return wm._syntaxEditorDialog;
	};
	wm.CssLoader.extend({makePropEdit:function (inName, inValue, inDefault) {
		switch (inName) {
		  case "css":
			return makeReadonlyButtonEdit(inName, "(css)", "(css)");
		}
		return this.inherited(arguments);
	}, editProp:function (inName, inValue, inInspector) {
		switch (inName) {
		  case "css":
			this.showCssDialog();
			return;
		}
		return this.inherited(arguments);
	}, showCssDialog:function () {
		var d = wm.getSyntaxEditorDialog();
		this._dialogConnect = dojo.connect(d, "onClose", this, "cssDialogClosed");
		d.show();
		d.page.update(this.css, "css");
	}, cssDialogClosed:function (inWhy) {
		dojo.disconnect(this._dialogConnect);
		this._dialogConnect = null;
		if (inWhy == "OK") {
			var d = wm.getSyntaxEditorDialog();
			this.setCss(d.page.getEditorText());
		}
	}});
}
if (!dojo._hasResource["wm.base.components.PageLoader"]) {
	dojo._hasResource["wm.base.components.PageLoader"] = true;
	dojo.provide("wm.base.components.PageLoader");
	wm.load = function (inFile, allowCache) {
		if (djConfig.isDebug && !dojo.isFF) {
			console.info("wm.load: " + inFile);
		}
		return dojo.xhrGet({url:inFile, sync:true, preventCache:!allowCache}).results[0];
	};
	wm.dojoScriptLoader = function (uri) {
		try {
			dojo._loadUri(uri);
		}
		catch (e) {
			console.error(e);
			return false;
		}
	};
	wm.gzScriptLoader = function (name) {
		try {
			var path = "resources/gzipped/";
			dojo._loadUri(path + name.replace(/[.]/g, "/") + ".js");
		}
		catch (e) {
			console.error("error while loading gzipped file ", e);
			return false;
		}
	};
	dojo.declare("wm.PageLoader", wm.Component, {init:function () {
		this.randomNum = new Date().valueOf();
		this.inherited(arguments);
		this._pageConnections = [];
		this.pageProps = {};
		this.cssLoader = new wm.CssLoader({owner:this, relativeUrl:false});
		this.htmlLoader = new wm.HtmlLoader({owner:this, relativeUrl:false});
	}, pageConnect:function () {
		var ctor = this.getPageCtor();
		if (ctor) {
			var args = [ctor.prototype].concat(dojo._toArray(arguments));
			this._pageConnections.push(dojo.connect.apply(dojo, args));
		}
	}, _disconnectPage:function () {
		dojo.forEach(this._pageConnections, dojo.disconnect);
	}, getPageCtor:function () {
		return dojo.getObject(this.className || "");
	}, loadController:function (inName, inPath) {
		var ctor = dojo.getObject(inName);
		if (!ctor) {
			wm.dojoScriptLoader(inPath + ".js?dojo.preventCache=" + new Date().valueOf());
			ctor = dojo.getObject(inName);
		}
		if (!ctor) {
			app.alert("Error parsing " + inPath + ".js");
			ctor = dojo.declare(inName, wm.Page);
		}
		return ctor;
	}, loadSupport:function (inCtor, inPath) {
		if (!inCtor._supported) {
			this.cssLoader.setUrl(inPath + ".css");
			inCtor.css = this.cssLoader.css;
			this.htmlLoader.setUrl(inPath + ".html");
			inCtor.html = this.htmlLoader.html;
			inCtor.html = inCtor.css = "";
			delete dojo._loadedUrls[inPath + ".widgets.js"];
			wm.dojoScriptLoader(inPath + ".widgets.js?rand=" + new Date().valueOf());
			inCtor._supported = true;
		}
	}, unloadSupport:function (ctor) {
		if (!ctor) {
			ctor = this.getPageCtor();
		}
		if (ctor) {
			ctor.css = ctor.html = "";
			ctor._supported = false;
		}
	}, loadPageCode:function (inName) {
		var path = this.getPath() + wm.pagesFolder + inName + "/" + inName;
		var ctor = this.loadController(inName, path);
		if (ctor) {
			this.loadSupport(ctor, path);
		}
		return ctor;
	}, loadPage:function (inClassName, inName) {
		inName = inName || inClassName;
		if (!inName) {
			wm.logging && console.debug("Invalid page name. Must load a valid page.");
			return;
		}
		this.previousPage = this.page;
		this.previousClassName = this.className;
		this.className = inClassName;
		var ctor = this.loadPageCode(inClassName);
		if (ctor) {
			this.onBeforeCreatePage();
			this.createPage(ctor, inName);
			this.pageChanged();
			this.unloadSupport(ctor);
		} else {
			console.log("Page not found:", inClassName);
		}
	}, createPage:function (inCtor, inName) {
		var props = dojo.mixin({name:inName, owner:this.owner, domNode:this.domNode, isRelativePositioned:this.isRelativePositioned}, this.pageProps || {});
		this.page = new inCtor(props);
	}, destroyPage:function (inPage) {
		this._disconnectPage();
		if (inPage) {
			wm.fire(inPage, "destroy");
		}
	}, destroy:function () {
		this.destroyPage();
		delete this.cssLoader;
		delete this.htmlLoader;
		this.inherited(arguments);
		if (this.domNode) {
			dojo.destroy(this.domNode);
			this.domNode = null;
		}
	}, pageChanged:function () {
		this.onPageChanged(this.page, this.previousPage);
		if (this.previousPage) {
			this.destroyPage(this.previousPage);
			delete this.previousPage;
			if (this.previousClassName) {
				try {
					var preObj = dojo.getObject(this.previousClassName);
					preObj._supported = false;
				}
				catch (e) {
				}
			}
		}
	}, onBeforeCreatePage:function () {
	}, onPageChanged:function (inNewPage, inPreviousPage) {
	}});
}
if (!dojo._hasResource["wm.base.components.Application"]) {
	dojo._hasResource["wm.base.components.Application"] = true;
	dojo.provide("wm.base.components.Application");
	wm.componentLoaders = wm.componentLoaders || {};
	wm.registerComponentLoader = function (inType, inLoader) {
		wm.componentLoaders[inType] = inLoader;
	};
	dojo.declare("wm.Application", wm.Component, {main:"Main", deletionDisabled:1, projectSubVersion:1, projectVersion:1, studioVersion:"", theme:"wm_notheme", toastPosition:"br", _lastTheme:"", init:function () {
		app = wm.application = wm.application || this;
		this.connectList = [];
		this.app = this;
		this.inherited(arguments);
		wm.typeManager.initTypes();
		this.setTheme(themematch ? themematch[1] : this.theme, true);
		this.pageDialog = new wm.PageDialog({name:"pageDialog", owner:this});
		this.toastDialog = new wm.Toast({name:"toastDialog", owner:this});
		try {
			this.alertDialog = new wm.GenericDialog({name:"alertDialog", owner:this, title:"Alert!", noEscape:false, width:"300px", height:"180px", button1Caption:"OK", button1Close:true, userPrompt:""});
			this.alertDialog.domNode.style.zIndex = 45;
		}
		catch (e) {
			console.info("error while creating alert Dialog ", e);
		}
		this.createPageLoader();
		this.components = {};
		this.scrim = new wm.Scrim();
		var themematch = window.location.search.match(/theme\=(.*?)\&/) || window.location.search.match(/theme\=(.*?)$/);
		this.loadComponents(this.constructor.widgets || this.widgets);
	}, setTheme:function (inTheme, isInit, optionalCss, optionalPrototype, noRegen, forceUpdate) {
		var isDesigned = (window["studio"] && this != app);
		var node = isDesigned ? studio.designer.domNode : document.body;
		dojo.removeClass(node, this.theme);
		this._lastTheme = this.theme;
		this.theme = inTheme;
		dojo.addClass(node, this.theme);
		if (isDesigned || !isInit) {
			try {
				this.loadThemeCss(this.theme, isDesigned, optionalCss);
				if (isDesigned && !isInit) {
					this._themeChanged = true;
					this.cacheWidgets();
				}
				this.loadThemePrototype(this.theme, optionalPrototype);
				if (isDesigned && !isInit && !noRegen) {
					this.useWidgetCache();
				}
			}
			catch (e) {
				if (inTheme != "wm_notheme") {
					this.setTheme("wm_notheme", isInit, optionalCss, optionalPrototype, noRegen);
					app.alert("The theme '" + inTheme + "' was not found.  This can happen when importing a project that uses a theme that is not in your library.  You can download that theme and copy it into your WaveMaker/common/themes folder or go to your model, select 'Project', and pick a new theme");
				} else {
					app.alert("Fatal error loading theme wm_notheme.  If you see this, please contact WaveMaker support.");
				}
				return;
			}
		} else {
			this.loadThemePrototype(this.theme, optionalPrototype);
		}
	}, cacheWidgets:function () {
		if (!this._widgetsjs) {
			var widgetsjs = dojo.fromJson("{" + studio.page.root.write("") + "}");
			this._widgetsjs = widgetsjs;
		}
	}, useWidgetCache:function () {
		studio.page.root.destroy();
		delete studio.page.root;
		studio.page.loadComponents(this._widgetsjs, null);
		delete this._widgetsjs;
		studio.page.reflow();
		studio.refreshWidgetsTree();
	}, loadThemePrototype:function (inThemeName, optionalThemeData) {
		var themeData = wm.Application.themeData[inThemeName];
		if (!themeData || optionalThemeData) {
			var path;
			if (inThemeName.match(/^wm_/)) {
				path = dojo.moduleUrl("wm") + "base/widget/themes/" + inThemeName + "/Theme.js";
			} else {
				path = dojo.moduleUrl("common") + "themes/" + inThemeName + "/Theme.js";
			}
			themeData = optionalThemeData || dojo.fromJson(dojo.xhrGet({url:path, sync:true, preventCache:true}).results[0]);
			wm.Application.themeData[inThemeName] = themeData || {};
		}
		var propHash = themeData["wm.Control"];
		for (var j in propHash) {
			wm.Control.prototype[j] = propHash[j];
		}
		wm.Application.themePrototypeData = {"wm.Control":this.theme};
	}, loadThemePrototypeForClass:function (ctor, optionalWidget) {
		if (!this.theme || !ctor) {
			return;
		}
		var declaredClass = ctor.prototype.declaredClass;
		if (declaredClass == "wm.Template") {
			declaredClass = "wm.Panel";
		}
		if (!wm.Application.themePrototypeData[declaredClass] || wm.Application.themePrototypeData[declaredClass] != this.theme) {
			var p = ctor.prototype;
			var lastTheme = wm.Application.themePrototypeData[declaredClass];
			var oldThemeData = wm.Application.themeData[lastTheme];
			if (oldThemeData) {
				var oldCtorData = oldThemeData[declaredClass];
				if (oldCtorData) {
					for (var j in oldCtorData) {
						delete p[j];
						if (p[j] === undefined) {
							p[j] = "";
						}
					}
				}
			}
			var themeData = wm.Application.themeData[this.theme];
			var ctorData = themeData[ctor.prototype.declaredClass];
			if (ctorData) {
				for (var j in ctorData) {
					ctor.prototype[j] = ctorData[j];
					if (optionalWidget) {
						optionalWidget[j] = ctorData[j];
					}
				}
			}
			wm.Application.themePrototypeData[declaredClass] = this.theme;
		}
	}, loadThemeCss:function (inThemeName, inDesign, optionalCss) {
		var path;
		var themecss;
		if (inThemeName.match(/^wm_/)) {
			path = dojo.moduleUrl("wm") + "base/widget/themes/" + inThemeName + "/theme.css";
		} else {
			path = dojo.moduleUrl("common") + "themes/" + inThemeName + "/theme.css";
		}
		if (inDesign) {
			var imagepath = path.replace(/\/[^\/]*$/, "/images");
			while (imagepath.match(/[^\/]+\/\.\.\//)) {
				imagepath = imagepath.replace(/[^\/]+\/\.\.\//, "");
			}
			var results = dojo.xhrGet({url:path, sync:true, preventCache:false}).results;
			if (results[1]) {
				throw results[1];
			}
			themecss = optionalCss || results[0] || "";
			themecss = themecss.replace(/url\s*\(\s*images/g, "url(" + imagepath);
			setCss("theme_ss", themecss);
		} else {
			wm.headAppend(wm.createElement("link", {rel:"stylesheet", type:"text/css", href:path}));
		}
	}, postInit:function () {
		this.inherited(arguments);
	}, destroy:function () {
		wm.fire(this.scrim, "destroy");
		wm.fire(this._runtimeService, "destroy");
		this.inherited(arguments);
		dojo.forEach(this.connectList, dojo.disconnect);
		this.connectList = null;
		delete this._page;
		if (this._pageLoader) {
			this._pageLoader.destroy();
			this._pageLoader = null;
		}
		if (this.domNode) {
			dojo.destroy(this.domNode);
			this.domNode = null;
		}
		this.pageDialog.destroy();
		delete this.pageDialog;
		this.scrim.destroy();
		delete this.scrim;
		delete this.app;
	}, createPageLoader:function () {
		this._pageLoader = new wm.PageLoader({owner:this});
		this.connectList[this.connectList.length] = this.connect(this._pageLoader, "onBeforeCreatePage", this, "beforeCreatePage");
		this.connectList[this.connectList.length] = this.connect(this._pageLoader, "onPageChanged", this, "pageChanged");
	}, loadComponents:function (inChildren) {
		this._loading = true;
		this.createComponents(inChildren);
		this._loading = false;
	}, subPageLoaded:function (inPage) {
		if (djConfig.isDebug) {
			if (this.debugSubPageList === undefined) {
				this.debugSubPageList = {};
			}
			this.debugSubPageList[inPage.name] = inPage;
		}
	}, subPageUnloaded:function (inPage) {
		if (djConfig.isDebug && inPage) {
			if (this.debugSubPageList != undefined) {
				delete (this.debugSubPageList[inPage.name]);
			}
		}
	}, qualifyName:function (inName) {
		return inName;
	}, addComponent:function (inComponent) {
		this.inherited(arguments);
		this[inComponent.name] = inComponent;
	}, removeComponent:function (inComponent) {
		delete this[inComponent.name];
		this.inherited(arguments);
	}, getRuntimeService:function (owner) {
		if (!this._runtimeService) {
			this._runtimeService = new wm.JsonRpcService({service:"runtimeService", owner:owner});
		}
		return this._runtimeService;
	}, getRuntimeServiceDesignTime:function (owner) {
		if (!this._runtimeService) {
			this._runtimeService = new wm.JsonRpcService({service:"runtimeService", owner:owner, designTime:true});
		}
		return this._runtimeService;
	}, getRoot:function () {
		return this;
	}, getRuntimeId:function (inId) {
		return inId;
	}, getId:function (inId) {
		if (inId) {
			return "app." + inId;
		} else {
			return "app";
		}
	}, reflow:function () {
		var d = this.domNode;
		d.scrollTop = 0;
	}, reflowParent:function () {
		this.reflow();
	}, hideLoadingIndicator:function () {
		dojo._destroyElement("_wm_loading");
	}, run:function () {
		app = wm.application = this;
		dojo.addOnLoad(dojo.hitch(this, "runOnLoad"));
	}, runOnLoad:function () {
		setTimeout(dojo.hitch(this, "doRun"), dojo.isIE < 7 ? 100 : 1);
	}, doRun:function () {
		this._pageLoader.domNode = this.domNode = dojo.byId(this.domNode) || document.body;
		this.loadPage(app.main);
	}, start:function () {
	}, getServerComponents:function () {
		if (this.serverComponents === undefined) {
			this.loadServerComponents();
		}
		return this.serverComponents;
	}, loadServerComponents:function (inComponentType) {
		if (inComponentType && this.serverComponents) {
			for (var i = 0, c; c = this.serverComponents[i]; i++) {
				if (c.type == inComponentType) {
					this.serverComponents.splice(i--, 1);
				}
			}
			var cl = wm.componentLoaders[inComponentType];
			if (cl) {
				this.serverComponents = this.serverComponents.concat(cl.getComponents());
			}
		} else {
			this.serverComponents = [];
			for (var i in wm.componentLoaders) {
				this.serverComponents = this.serverComponents.concat(wm.componentLoaders[i].getComponents());
			}
		}
	}, addServerComponent:function (inComponent) {
		this.serverComponents.push(inComponent);
	}, removeServerComponent:function (inComponent) {
		for (var i = 0, c; c = this.serverComponents[i]; i++) {
			if (c == inComponent) {
				this.serverComponents.splice(i, 1);
				return i;
			}
		}
	}, removeServerComponentByName:function (inComponentName, inComponentType) {
		for (var i = 0, c; c = this.serverComponents[i]; i++) {
			if (c.type == inComponentType && c.name == inComponentName) {
				this.serverComponents.splice(i, 1);
				return i;
			}
		}
	}, beforeCreatePage:function () {
		this._pageLoader.pageConnect("start", this, "start");
		this.pageLoadedDeferred = new dojo.Deferred();
	}, pageChanged:function (inPage, inPreviousPage) {
		this._page = inPage;
		var n = inPage.name, o = (inPreviousPage || 0).name;
		if (o) {
			window[o] = undefined;
			delete this[o];
		}
		window[n] = this[n] = this._page;
		if (this.pageLoadedDeferred) {
			this.pageLoadedDeferred.callback({page:inPage, previousPage:inPreviousPage});
		}
		this.connect(document, "keydown", inPage, "keydown");
		this.onPageChanged(inPage, inPreviousPage);
	}, loadPage:function (inName) {
		this._pageName = inName;
		try {
			this._pageLoader.loadPage(inName, inName.toLowerCase());
		}
		catch (e) {
			if (djConfig.isDebug) {
				console.error("loadPage error: " + e);
			}
		}
		finally {
			this.hideLoadingIndicator();
		}
	}, forceReloadPage:function () {
		this.loadPage(this._pageName);
	}, onPageChanged:function (inNewPage, inPreviousPage) {
	}, getFullVersionNumber:function () {
		return this.projectVersion + "." + this.projectSubVersion;
	}, alert:function (inText, nonmodal) {
		if (dojo.isObject(inText)) {
			inText = inText.toString();
		}
		nonmodal = Boolean(nonmodal);
		this.alertDialog.setUserPrompt(inText);
		this.alertDialog.setModal(!nonmodal);
		this.alertDialog.show();
	}, confirmOKFunc:null, confirmCancelFunc:null, confirm:function (inText, nonmodal, onOKFunc, onCancelFunc, optionalOKText, optionalCancelText, noshow) {
		if (!this.confirmDialog) {
			this.confirmDialog = new wm.GenericDialog({name:"confirmDialog", owner:this, noEscape:false, width:"350px", height:"180px", button1Caption:"OK", button1Close:true, button2Caption:"Cancel", button2Close:true, userPrompt:"confirm..."});
			this.confirmDialog.domNode.style.zIndex = 50;
			this.confirmDialog.connect(this.confirmDialog, "onButton1Click", this, "confirmDialogOKClick");
			this.confirmDialog.connect(this.confirmDialog, "onButton2Click", this, "confirmDialogCancelClick");
		}
		nonmodal = Boolean(nonmodal);
		this.confirmDialog.setUserPrompt(inText);
		this.confirmDialog.setModal(!nonmodal);
		this.confirmDialog.setShowInput(false);
		this.confirmDialog.setTitle("確認..."), this.confirmOKFunc = onOKFunc;
		this.confirmCancelFunc = onCancelFunc;
		this.confirmDialog.setButton1Caption(optionalOKText || "ＯＫ");
		this.confirmDialog.setButton2Caption(optionalCancelText || "キャンセル");
		if (!noshow) {
			this.confirmDialog.show();
		}
	}, prompt:function (inText, inDefaultValue, onOKFunc, onCancelFunc, optionalOKText, optionalCancelText) {
		this.confirm(inText, false, onOKFunc, onCancelFunc, optionalOKText, optionalCancelText, true);
		this.confirmDialog.setShowInput(true);
		this.confirmDialog.setTitle("入力..."), this.confirmDialog.setInputDataValue(inDefaultValue || "");
		this.confirmDialog.show();
	}, confirmDialogOKClick:function () {
		if (this.confirmDialog.showInput) {
			var val = this.confirmDialog.getInputDataValue();
			if (!val) {
				return this.confirmDialogCancelClick();
			} else {
				if (this.confirmOKFunc) {
					this.confirmOKFunc(val);
				}
			}
		} else {
			if (this.confirmOKFunc) {
				this.confirmOKFunc();
			}
		}
	}, confirmDialogCancelClick:function () {
		if (this.confirmCancelFunc) {
			this.confirmCancelFunc();
		}
	}, toastError:function (inMsg) {
		this.toastDialog.showToast(inMsg, 8000, "Error");
	}, toastWarning:function (inMsg) {
		this.toastDialog.showToast(inMsg, 8000, "Warning");
	}, toastSuccess:function (inMsg) {
		this.toastDialog.showToast(inMsg, 5000, "Success");
	}, toastInfo:function (inMsg) {
		this.toastDialog.showToast(inMsg, 5000, "Info");
	}, createMinifiedDialogPanel:function () {
		this.wmMinifiedDialogPanel = new wm.Panel({name:"wmMinifiedDialogPanel", width:this._page.root.bounds.w + "px", height:"25px", border:"2,0,0,0", padding:"2", autoScroll:true, verticalAlign:"top", horizontalAlign:"left", layoutKind:"left-to-right"});
		document.body.appendChild(this.wmMinifiedDialogPanel.domNode);
		this.wmMinifiedDialogPanel.subscribe("window-resize", this, "resizeMinifiedDialogPanel");
		this.resizeMinifiedDialogPanel();
	}, createMinifiedDialogLabel:function (title) {
		var l = new wm.Button({caption:title, parent:app.wmMinifiedDialogPanel, owner:this, width:"100px", height:"100%", margin:"0", padding:"0"});
		app.wmMinifiedDialogPanel.show();
		return l;
	}, removeMinifiedDialogLabel:function (minifiedLabel) {
		minifiedLabel.destroy();
		this.wmMinifiedDialogPanel.setShowing(Boolean(this.wmMinifiedDialogPanel.c$.length));
	}, resizeMinifiedDialogPanel:function () {
		var b = {l:0, t:this._page.root.bounds.h - this.wmMinifiedDialogPanel.bounds.h, w:this._page.root.bounds.w, h:25};
		this.wmMinifiedDialogPanel.setBounds(b);
		this.wmMinifiedDialogPanel.renderBounds();
	}});
	wm.Application.extend({firstThemeChange:true, write:function (inIndent) {
		var props = dojo.toJson(this.writeProps(), true);
		props = props.substring(1, props.length - 2);
		var compsArray = this.writeComponents(inIndent);
		var classOrdering = ["wm.TypeDefinition", "wm.LiveView"];
		compsArray = compsArray.sort(function (a, b) {
			var alist = a.match(/^(.*?)\:\s*\[\"(.*?)\"/);
			var blist = b.match(/^(.*?)\:\s*\[\"(.*?)\"/);
			var aindex = dojo.indexOf(classOrdering, alist[2]);
			var bindex = dojo.indexOf(classOrdering, blist[2]);
			if (aindex == -1) {
				aindex = classOrdering.length;
			}
			if (bindex == -1) {
				bindex = classOrdering.length;
			}
			if (aindex == bindex) {
				return (alist[1] <= blist[1]) ? -1 : 1;
			} else {
				return (aindex < bindex) ? -1 : 1;
			}
		});
		var comps = compsArray.join(", " + sourcer_nl);
		var customsrc = String(studio.getAppScript()).trim() || studio.project.projectName + ".extend({\n\n\t" + terminus + "\n});";
		var src = "dojo.declare(\"" + this.declaredClass + "\", wm.Application, {" + props + ",\n\t" + "\"widgets\": {\n" + (comps || "") + "\n\t},\n\t" + terminus + "\n});\n\n" + customsrc;
		return src;
	}, setToastPosition:function (inPosition) {
		this.toastPosition = inPosition.replace(/top/, "t").replace(/bottom/, "b").replace(/left/, "l").replace(/right/, "r").replace(/center/, "c").replace(/ /, "");
	}, makePropEdit:function (inName, inValue, inDefault) {
		switch (inName) {
		  case "main":
			return new wm.propEdit.PagesSelect({component:this, name:inName, value:inValue, currentPageOK:true});
		  case "theme":
			var options = [];
			var data = studio.themesListVar.getData();
			dojo.forEach(data, function (item) {
				options.push(item.dataValue);
			});
			return new wm.propEdit.Select({component:this, value:inValue, name:inName, options:options});
		  case "toastPosition":
			inValue = inValue.replace(/^c/, "center ").replace(/^t/, "top ").replace(/^b/, "bottom ").replace(/l$/, "left").replace(/r$/, "right").replace(/c$/, "center");
			return new wm.propEdit.Select({component:this, value:inValue, name:inName, options:["top left", "top center", "top right", "center left", "center center", "center right", "bottom left", "bottom center", "bottom right"]});
		}
		return this.inherited(arguments);
	}, setMain:function (inMain) {
		this.main = inMain;
		studio.setProjectMainPage(inMain);
	}, incSubversionNumber:function () {
		if (dojo.isString(this.projectSubVersion)) {
			if (parseInt(this.projectSubVersion) + "" == this.projectSubVersion) {
				this.projectSubVersion = parseInt(this.projectSubVersion) + 1;
			} else {
				var result = this.projectSubVersion.match(/\d+$/);
				if (result) {
					this.projectSubVersion = this.projectSubVersion.replace(/\d+$/, "");
					result = parseInt(result[0]) + 1;
					this.projectSubVersion += result;
				} else {
					this.projectSubVersion += "0";
				}
			}
		} else {
			this.projectSubVersion++;
		}
	}});
	wm.Object.extendSchema(wm.Application, {name:{ignore:1}, main:{shortname:"mainPageName"}, promptChromeFrame:{shorname:"chromeFrame (NA)"}, theme:{type:"string"}, studioVersion:{writeonly:true, type:"string"}, projectVersion:{type:"string"}, projectSubVersion:{type:"string"}, firstThemeChange:{ignore:true}, documentation:{ignore:true}, generateDocumentation:{ignore:true}});
	wm.Application.themePrototypeData = {};
	wm.Application.themeData = {};
}
if (!dojo._hasResource["wm.base.components.Property"]) {
	dojo._hasResource["wm.base.components.Property"] = true;
	dojo.provide("wm.base.components.Property");
	dojo.declare("wm.Property", wm.Component, {property:"", bindTarget:true, bindSource:true, isEvent:false, readonly:false, init:function () {
		this.inherited(arguments);
	}, listProperties:function () {
		var p = this.inherited(arguments);
		p.bindTarget.ignore = this.isEvent;
		p.bindSource.ignore = this.isEvent;
		return p;
	}, makePropEdit:function (inName, inValue, inDefault) {
		switch (inName) {
		  case "property":
			var i = makeInputPropEdit(inName, inValue, inDefault);
			var b = "<img class=\"wminspector-prop-button\" src=\"images/target.png\" style=\"width:23px;height:21px\">";
			return "<table class=\"prop-table\" width=\"100%\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tr><td" + (inValue == inDefault ? " class=\"prop-default\"" : "") + ">" + i + "</td><td class=\"prop-button\">" + b + "</td></tr></table>";
		}
		return this.inherited(arguments);
	}, editProp:function (inName, inValue, inInspector) {
		switch (inName) {
		  case "property":
			wm.onidle(this, "beginBind");
			break;
		}
	}, beginBind:function (inPropName) {
		studio.onSelectProperty = dojo.hitch(this, "selectProperty");
		studio.selectProperty(this, null, "Select Property to publish as <b>" + this.name + "</b>");
	}, selectProperty:function (inId) {
		studio.onSelectProperty = null;
		var id = inId.replace("studio.wip.", "");
		this.setValue("property", id);
		var ids = id.split("."), c = ids.shift(), prop = ids.join(".");
		var c = studio.wip.getValue(c);
		if (c) {
			if (c.isEventProp(prop)) {
				this.setValue("isEvent", true);
			}
			if (c.schema[prop] && c.schema[prop].readonly) {
				this.setValue("readonly", true);
			}
		}
	}, write:function () {
		return wm.Property.deploy ? "" : this.inherited(arguments);
	}, publish:function () {
		return "[" + "\"" + this.name + "\", " + "\"" + this.property + "\", " + "{" + "group: \"Published\"" + (this.isEvent ? ", isEvent: true" : (this.readonly ? ", readonly: true" : "") + (this.bindSource ? ", bindSource: true" : "") + (this.bindTarget ? ", bindTarget: true" : "")) + "}" + "]";
	}});
	wm.Object.extendSchema(wm.Property, {owner:{ignore:1}});
}
if (!dojo._hasResource["wm.base.components.Publisher"]) {
	dojo._hasResource["wm.base.components.Publisher"] = true;
	dojo.provide("wm.base.components.Publisher");
	dojo.declare("wm.ComponentPublisher", wm.Component, {namespace:"test", publishName:"", displayName:"", description:"", width:"250px", height:"150px", removeSource:true, deploy:"(deploy)", undeploy:"(undeploy)", group:"Published", init:function () {
		this.inherited(arguments);
		var p = studio.project;
		this.publishName = this.publishName || p.projectName + p.pageName;
	}, deploy:function () {
		wm.Property.deploy = true;
		try {
			var json = this.getComponentJson();
			studio.deployComponent(this.publishName, this.namespace, this.displayName || this.publishName, this.group, json);
		}
		finally {
			wm.Property.deploy = false;
		}
	}, undeploy:function () {
		studio.undeployComponent(this.publishName, this.namespace, this.displayName || this.publishName, this.group, this.removeSource);
	}, getComponentJson:function () {
	}, setPublishName:function (inValue) {
		this.publishName = wm.getValidJsName(inValue);
	}, setDisplayName:function (inValue) {
		this.displayName = wm.getValidJsName(inValue);
	}, write:function () {
		return wm.Property.deploy ? "" : this.inherited(arguments);
	}, makePropEdit:function (inName, inValue, inDefault) {
		switch (inName) {
		  case "deploy":
		  case "undeploy":
			return makeReadonlyButtonEdit(inName, inValue, inDefault);
		  case "width":
		  case "height":
			return new wm.propEdit.UnitValue({component:this, name:inName, value:inValue, options:["px", "%"]});
		}
		return this.inherited(arguments);
	}, editProp:function (inName, inValue, inInspector) {
		switch (inName) {
		  case "deploy":
			return this.deploy();
		  case "undeploy":
			return this.undeploy();
		}
		return this.inherited(arguments);
	}});
	wm.Object.extendSchema(wm.ComponentPublisher, {removeSource:{ignore:1}, publishName:{group:"Events", order:10}, namespace:{group:"Events", order:20}, group:{group:"Events", order:30}, displayName:{group:"Events", order:40}, description:{group:"Events", order:50}, width:{group:"layout", order:20}, height:{group:"layout", order:30}, deploy:{group:"operation", order:10}, undeploy:{group:"operation", order:20}, owner:{ignore:1}});
	dojo.declare("wm.CompositePublisher", wm.ComponentPublisher, {getComponentJson:function () {
		if (!this.publishName || !studio.page) {
			return;
		}
		var klass = this.namespace ? this.namespace + "." + this.publishName : this.publishName;
		var pageComponents = studio.page.writeComponents(sourcer_tab);
		var root = studio.page.root;
		var rootWidgets = root.writeComponents(sourcer_tab);
		var components = pageComponents.concat(rootWidgets).join(",\n");
		var widgets = klass + ".components = {" + sourcer_nl + components + "}";
		var css = studio.getCss();
		var html = studio.getMarkup();
		var resource = "common.packages." + klass;
		var group = this.group || "Published";
		var image = "images/wm/widget.png";
		var displayName = this.displayName || this.publishName;
		var js = studio.getScript();
		js = js.split("\n");
		js.shift();
		var rootProps = ["layoutKind", "verticalAlign", "horizontalAlign"];
		dojo.forEach(rootProps, function (p) {
			if (root[p]) {
				js.unshift("  " + p + ": \"" + root[p] + "\",");
			}
		});
		js.unshift("dojo.declare(\"" + klass + "\", wm.Composite, {");
		js = js.join("\n");
		var reg = "wm.registerPackage([\"" + group + "\", " + "\"" + displayName + "\", " + "\"" + klass + "\", " + "\"" + resource + "\", " + "\"" + image + "\", " + "\"" + this.description + "\", " + "{width: \"" + this.width + "\", height: \"" + this.height + "\"}" + "]);";
		var c, props = [];
		for (var n in studio.page.$) {
			c = studio.page.$[n];
			if (c instanceof wm.Property) {
				props.push(c.publish());
			}
		}
		props = props.length ? "wm.publish(" + klass + ", [\n\t" + props.join(",\n\t") + "\n]);\n \n" : "";
		return ["dojo.provide(\"" + resource + "\");", "\n \n", js, "\n \n", widgets, "\n \n", props, css ? klass + ".css = \"" + css + "\";" + "\n \n" : "", html ? klass + ".html = \"" + html + "\";" + "\n \n" : "", reg].join("");
	}});
	dojo.declare("wm.TemplatePublisher", wm.ComponentPublisher, {isFullPageTemplate:false, width:"100%", height:"100%", getComponentJson:function () {
		if (!this.publishName || !studio.page) {
			return;
		}
		var template = ((!this.isFullPageTemplate) ? "wm.widgetTemplates." : "wm.fullTemplates.") + this.publishName;
		var root = studio.page.root;
		var widgets = template + " = {\n" + "\tlayoutKind: \"" + root.layoutKind + "\",\n" + "\twidth: \"" + this.width + "\",\n" + "\theight: \"" + this.height + "\",\n" + "\tverticalAlign: \"" + root.verticalAlign + "\",\n" + "\thorizontalAlign: \"" + root.horizontalAlign + "\",\n" + "\t_template: {\n" + root.writeComponents("\t").join(",\n") + "}};";
		var resource = "common.packages." + (this.namespace ? this.namespace + "." + this.publishName : this.publishName);
		var group = this.group || "Published";
		var image = "images/wm/template.png";
		var displayName = this.displayName || this.publishName;
		var reg = "wm.registerPackage([\"" + group + "\", " + "\"" + displayName + "\", " + "\"wm.Template\"," + "\"" + resource + "\", " + "\"" + image + "\", " + "\"" + this.description + "\", " + template + "]);";
		var r = ["dojo.provide(\"" + resource + "\");", "\n \n", (this.isFullPageTemplate) ? "if (!wm.fullTemplates) wm.fullTemplates = {};\n" : "if (!wm.widgetTemplates) wm.widgetTemplates = {};\n", widgets, "\n \n", reg].join("");
		console.log(r);
		return r;
	}});
}
if (!dojo._hasResource["wm.base.components.ImageList"]) {
	dojo._hasResource["wm.base.components.ImageList"] = true;
	dojo.provide("wm.base.components.ImageList");
	dojo.declare("wm.ImageList", wm.Component, {width:32, height:32, colCount:100, url:"", getImageHtml:function (inIndex) {
		var col = inIndex % this.colCount;
		var row = Math.floor(inIndex / this.colCount);
		var url = this.url;
		if (this.isDesignLoaded() && this.owner != studio) {
			url = "/" + studio.projectPrefix + studio.project.getProjectPath() + "/" + url;
		}
		return "<image src=\"" + wm.theme.getImagesPath() + "blank.gif\"" + " width=\"" + this.width + "\"" + " height=\"" + this.height + "\"" + " style=\"" + "vertical-align: middle; " + "background:url(" + url + ") no-repeat " + (-this.width * col) + "px " + (-this.height * row) + "px;\"" + ">";
	}});
	wm.Object.extendSchema(wm.ImageList, {url:{group:"display", bindable:1, type:"String", subtype:"File", order:10, focus:1, extensionMatch:["jpg", "jpeg", "gif", "png", "tiff"]}});
}
if (!dojo._hasResource["wm.base.components.Variable"]) {
	dojo._hasResource["wm.base.components.Variable"] = true;
	dojo.provide("wm.base.components.Variable");
	wm.getRuntimeService = function (inComponent) {
		var a = dojo.getObject("studio.wip.app") || app;
		return wm.fire(a, "getRuntimeService");
	};
	wm.getRuntimeServiceDesignTime = function (inComponent) {
		var a = dojo.getObject("studio.wip.app") || app;
		return wm.fire(a, "getRuntimeServiceDesignTime");
	};
	dojo.declare("wm.Variable", wm.Component, {json:"", type:"", isList:false, _updating:0, _dataSchema:{}, _greedyLoadProps:false, _allowLazyLoad:true, cursor:0, constructor:function () {
		this.subscribe("wmtypes-changed", this, "wmTypesChanged");
	}, postInit:function () {
		this.inherited(arguments);
		if (!this._subNard && !this.$.binding) {
			new wm.Binding({name:"binding", owner:this});
		}
		this.setType(this.type);
		if (this.json) {
			this.setJson(this.json);
		} else {
			this._clearData();
		}
		if (!this._updating && this.$.binding) {
			this.$.binding.refresh();
		}
	}, wmTypesChanged:function () {
		if (this.isPrimitive || wm.typeManager.isType(this.type)) {
			this.setType(this.type);
		}
	}, canSetType:function (inType) {
		if (this.dataSet) {
			wm.logging && console.debug(this.name, "cannot set variable type because this variable has a dataSet");
			return;
		}
		return true;
	}, setType:function (inType) {
		this.unsubscribe("TypeChange-" + this.type);
		if (!this.canSetType(inType)) {
			return;
		}
		var t = inType;
		if (wm.isListType(t)) {
			this.isList = true;
			t = t.slice(1, -1);
		} else {
			if (!(this.data && this.data.list)) {
				this.isList = false;
			}
		}
		this.type = t;
		if (this._proxy) {
			this._proxy.setType(this.type);
		}
		this.typeChanged(this.type);
		if (this.isDesignLoaded()) {
			this.subscribe("TypeChange-" + inType, dojo.hitch(this, function () {
				this.setType(inType);
				if (this.json) {
					this.setJson(this.json);
				}
			}));
		}
	}, typeChanged:function (inType) {
		var t = inType;
		var primitive = wm.typeManager.getPrimitiveType(t) || !t || t == "wm.Variable";
		this.isPrimitive = Boolean(primitive);
		var schema = this._getSchemaForType(t);
		if (schema) {
			this.setDataSchema(schema);
		}
	}, _getSchemaForType:function (inType) {
		var p = wm.typeManager.getPrimitiveType(inType);
		if (this.isPrimitive) {
			return {dataValue:{type:p || "String"}};
		} else {
			return wm.typeManager.getTypeSchema(inType) || {dataValue:{type:p || "String", isList:this.isList}};
		}
	}, setDataSchema:function (inSchema) {
		this._dataSchema = inSchema;
	}, setJson:function (inJson) {
		this.json = inJson;
		try {
			var d = eval("(" + inJson + ")");
			this.setData(d);
		}
		catch (e) {
			console.error("Json error in " + this.name + ": " + e);
		}
	}, hasList:function () {
		return this.data && ("list" in this.data);
	}, getDataTypeInfo:function (inProp) {
		return this._dataSchema[inProp];
	}, listDataProperties:function () {
		var list = this._listSchemaProperties({}, this._dataSchema, "getDataTypeInfo");
		for (var i in list) {
			list[i].bindable = true;
		}
		return list;
	}, beginUpdate:function () {
		this._updating++;
	}, endUpdate:function () {
		this._updating--;
	}, isUpdating:function () {
		return this._updating > 0;
	}, clearData:function () {
		this._clearData();
		this.setType(this.type);
		this.notify();
	}, _clearData:function () {
		this._isNull = false;
		this._nostub = false;
		if (!this.data) {
			this.data = {};
		}
		if (this.isList) {
			this.data = {list:[]};
		} else {
			var d;
			for (var i in this.data) {
				d = this.data[i];
				if (d instanceof wm.Variable) {
					d._clearData();
				} else {
					delete this.data[i];
				}
			}
		}
	}, _setNull:function (inNull) {
		this._isNull = inNull;
		if (!inNull && this._subNard && this.owner) {
			this.owner._setNull(inNull);
		}
	}, setData:function (inData) {
		this.onPrepareSetData(inData);
		if (inData instanceof wm.Variable) {
			this._setVariableData(inData);
		} else {
			if (dojo.isArray(inData)) {
				this._setArrayData(inData);
			} else {
				if (this.isPrimitive) {
					this._setPrimitiveData(inData);
				} else {
					this._setObjectData(inData);
				}
			}
		}
		this.notify();
		this.onSetData();
	}, onPrepareSetData:function (inData) {
	}, onSetData:function () {
	}, notify:function () {
		this.dataOwnerChanged();
		this.dataChanged();
	}, _setPrimitiveData:function (inValue) {
		this.data = {dataValue:inValue};
		this.isList = false;
	}, _setVariableData:function (inVariable) {
		this.setData(inVariable.getData());
	}, _setArrayData:function (inArray) {
		this.data = {list:inArray};
		this.isList = true;
	}, _setObjectData:function (inObject) {
		this.beginUpdate();
		this._clearData();
		this.isList = false;
		if (!("list" in this._dataSchema)) {
			delete this.data.list;
		}
		var d, v, nv, isNull = inObject === null, empty = wm.isEmpty(inObject);
		for (var i in this._dataSchema) {
			d = this.data[i];
			v = !empty ? inObject[i] : undefined;
			nv = isNull ? null : v;
			if (this._isVariableProp(i)) {
				if (d instanceof wm.Variable) {
					if (nv !== undefined) {
						d.beginUpdate();
						d.setData(nv);
						d.endUpdate();
					}
				} else {
					if (v !== undefined) {
						this._setDataValue(i, v);
					}
				}
			} else {
				if (nv !== undefined) {
					this._setDataValue(i, nv);
				}
			}
		}
		this._setNull(isNull);
		this.endUpdate();
	}, getData:function () {
		if (!this.data) {
			return;
		}
		if (this._isNull) {
			return null;
		} else {
			if (this.isList) {
				var data = [];
				for (var i = 0, l = this.getCount(), v; i < l; i++) {
					v = (this.getItem(i) || 0).getData();
					if (v) {
						data.push(v);
					}
				}
				return data;
			} else {
				var data = {};
				var props = this.listDataProperties();
				for (var i in props) {
					var v = this.data[i];
					if (v !== undefined) {
						v = v instanceof wm.Variable ? v.getData() : v;
						if (v === undefined || (v !== null && typeof v == "object" && wm.isEmpty(v))) {
							continue;
						}
						data[i] = v;
					}
				}
				if (!wm.isEmpty(data)) {
					return data;
				}
			}
		}
	}, _getDataValue:function (n) {
		if (!this.data) {
			this.data = {};
		}
		var d, f;
		if (this.isList) {
			f = this.getCursorItem();
			d = f && f.data;
		} else {
			d = this.data;
		}
		var v = d && d[n], typeInfo = this._dataSchema[n];
		if (this._isVariableProp(n) && (!v || (v._isStub && v._isStub()))) {
			v = d[n] = (f || this).marshallVariable(n, typeInfo, v);
		}
		return v;
	}, _setDataValue:function (n, v) {
		if (this._isNull && v !== undefined) {
			this._setNull(false);
		}
		this.beginUpdate();
		var o = this._getDataValue(n);
		this.endUpdate();
		if (o instanceof wm.Variable) {
			if (this._updating) {
				o._updating++;
			}
			o.setData(v);
			if (this._updating) {
				o._updating--;
			}
			return;
		}
		if (!(v instanceof wm.Variable)) {
			this.data[n] = v;
			this.dataValueChanged(n, v);
		}
	}, getCount:function () {
		if (this._isNull) {
			return 0;
		}
		if (this.isList) {
			return (this.data && this.data.list) ? this.data.list.length : 0;
		}
		return 1;
	}, _isEmpty:function (obj) {
		for (var prop in obj) {
			if (obj.hasOwnProperty(prop)) {
				return false;
			}
		}
		return true;
	}, _needItem:function (inIndex, inData) {
		if (inIndex >= this.getCount() && inData === undefined) {
			return null;
		}
		var item = this.data.list[inIndex];
		var data = inData;
		if (!(item instanceof wm.Variable)) {
			data = inData || item;
			item = this.createVariable({type:this.type, _subNard:true, itemIndex:inIndex});
			this.data.list[inIndex] = item;
		}
		if (data !== undefined) {
			item.beginUpdate();
			item.setData(data);
			item.endUpdate();
		}
		return item;
	}, getItem:function (inIndex) {
		return this.isList && this._needItem(inIndex);
	}, _populateItems:function () {
		for (var i = 0, c = this.getCount(); i < c; i++) {
			this.getItem(i);
		}
	}, sort:function (inComparator) {
		this._populateItems();
		var l = this.isList && this.data && this.data.list;
		l && l.sort(inComparator);
	}, setCursor:function (inCursor) {
		this.cursor = Math.max(0, Math.min(this.getCount() - 1, inCursor));
		this.notify();
	}, setNext:function () {
		this.setCursor(this.cursor + 1);
	}, setPrevious:function () {
		this.setCursor(this.cursor - 1);
	}, setFirst:function () {
		this.setCursor(0);
	}, setLast:function () {
		this.setCursor(this.getCount() - 1);
	}, getCursorItem:function () {
		return this.getItem(this.cursor || 0) || this;
	}, setItem:function (inIndex, inData) {
		this._setItem(inIndex, inData);
		this.cursor = inIndex;
		this.notify();
	}, _setItem:function (inIndex, inData) {
		if (this.isList) {
			this._needItem(inIndex, inData);
		}
	}, addItem:function (inData, inIndex) {
		this._addItem(inData, inIndex);
		this.cursor = inIndex;
		this.notify();
	}, _addItem:function (inData, inIndex) {
		if (this.isList) {
			var c = this.getCount();
			if (inIndex >= 0 && inIndex < c) {
				this.data.list.splice(inIndex, 0, {});
			} else {
				inIndex = this.getCount();
			}
			this._setItem(inIndex, inData);
		}
	}, removeItem:function (inIndex) {
		this._removeItem(inIndex);
		this.cursor = 0;
		this.notify();
	}, _removeItem:function (inIndex) {
		if (this.isList) {
			this.data.list.splice(inIndex, 1);
		}
	}, getItemIndex:function (inVariable) {
		if (!this.isList) {
			return;
		}
		var list = (this.data || 0).list || [];
		for (var i = 0, l = list.length; i < l; i++) {
			if (inVariable == list[i]) {
				return i;
			}
		}
	}, getItemIndexByPrimaryKey:function (inVariable, pkList) {
		if (!this.isList || !pkList || pkList.length < 1) {
			return;
		}
		var obj = inVariable;
		if (obj instanceof wm.Variable) {
			obj = inVariable.getData();
		}
		var list = (this.data || 0).list || [];
		for (var i = 0, l = list.length; i < l; i++) {
			obj2 = list[i] instanceof wm.Variable ? list[i].getData() : list[i];
			var isEqual = true;
			for (var j = 0; j < pkList.length; j++) {
				var f = pkList[j];
				if (obj[f] != obj2[f]) {
					isEqual = false;
					break;
				}
			}
			if (isEqual) {
				return i;
			}
		}
	}, dataRootChanged:function () {
		if (this._subNard) {
			return;
		}
		var o = this.owner, p, root = this.getRoot();
		while (o && o != root) {
			p = o;
			o = o && o.owner;
		}
		var n = p ? p.getRuntimeId() : this.getRuntimeId();
		topic = n + "-rootChanged";
		wm.logging && console.group("<== ROOTCHANGED [", topic, "] published by Variable.dataRootChanged");
		dojo.publish(topic, [n]);
		wm.logging && console.groupEnd();
	}, dataOwnerChanged:function () {
		if (this._updating) {
			return;
		}
		var n = this.getRuntimeId();
		var topic = n + "-ownerChanged";
		wm.logging && console.group("<== OWNERCHANGED [", topic, "] published by Variable.dataOwnerChanged");
		dojo.publish(topic, [n]);
		wm.logging && console.groupEnd();
		if (this._allowLazyLoad) {
			this.dataRootChanged();
		}
		var v = this.getCursorItem();
		for (var i in v.data) {
			wm.fire(v.data[i], "dataOwnerChanged");
		}
	}, dataChanged:function () {
		if (this._updating) {
			return;
		}
		var id = this.getRuntimeId();
		var topic = [id, "-changed"].join("");
		wm.logging && console.group("<== CHANGED [", topic, "] published by Variable.dataChanged");
		dojo.publish(topic, [this]);
		if (this._subNard) {
			wm.fire(this.owner, "dataChanged");
		}
		wm.logging && console.groupEnd();
	}, dataValueChanged:function (inProp, inValue) {
		if (!this._updating) {
			wm.Component.prototype.valueChanged.call(this, inProp, inValue);
			this.dataChanged();
		}
	}, valueChanged:function (inProp, inValue) {
		if (!this.isDataProp(inProp)) {
			this.inherited(arguments);
		}
	}, setDataSet:function (inDataSet) {
		this.dataSet = "";
		if (inDataSet instanceof wm.Variable) {
			this.setType(inDataSet ? inDataSet.type : "wm.Variable");
			this.dataSet = inDataSet;
			this.cursor = inDataSet.cursor;
		}
		this.setData(inDataSet);
	}, _isVariableProp:function (inPropName) {
		var typeInfo = this._dataSchema[inPropName];
		return Boolean(typeInfo && wm.typeManager.isStructuredType(typeInfo.type));
	}, isDataProp:function (inProp) {
		return inProp in this._dataSchema;
	}, _getValue:function (inProp) {
		return this.isDataProp(inProp) ? this._getDataValue(inProp) : this.inherited(arguments);
	}, _setValue:function (n, v) {
		if ((this.schema[n] || 0).defaultBindTarget || !this.isDataProp(n)) {
			this.inherited(arguments);
		} else {
			this._setDataValue(n, v);
		}
	}, createVariable:function (inProps, inPropName) {
		var v = new wm.Variable(inProps);
		v.owner = this;
		return v;
	}, marshallVariable:function (inPropName, inTypeInfo, inVariable) {
		var p = inPropName, v = inVariable, t = inTypeInfo.isList ? "[" + inTypeInfo.type + "]" : inTypeInfo.type;
		if (!(v instanceof wm.Variable)) {
			v = this.createVariable({name:p, type:t, _subNard:true}, p);
			if (inVariable || inVariable === null) {
				v.beginUpdate();
				v.setData(inVariable);
				v.endUpdate();
			}
		}
		if (v._isStub() && this.canLazyLoad(inTypeInfo)) {
			this.beginUpdate();
			this.lazyLoadData(p, v);
			this.endUpdate();
		}
		return v;
	}, _isStub:function () {
		if (!this._nostub && !this._isNull) {
			if (this.data === undefined) {
				return true;
			}
			if (this.isList || this.hasList()) {
				return !this.data.list || !this.data.list.length;
			}
			if (this._greedyLoadProps) {
				var schema = this._dataSchema, s;
				for (var i in schema) {
					s = schema[i];
					if (!s.isList && (this.data[i] === undefined) && !wm.typeManager.isStructuredType(s.type)) {
						return true;
					}
				}
			} else {
				if (wm.isEmpty(this.data)) {
					return true;
				}
			}
		}
		this._nostub = true;
		return false;
	}, lazyLoadData:function (inPropName, inVariable) {
		var s = wm.getRuntimeService(this), v = inVariable;
		try {
			if (s.ready) {
				var d = this.getData();
				if (!wm.isEmpty(d)) {
					var args = [null, this.type, d, {properties:[inPropName]}];
					wm.logging && console.log("lazyLoad", inVariable.owner && inVariable.owner.getId(), args);
					var f = function () {
						var r = s.result, propData = r && r[inPropName];
						if (propData) {
							v.beginUpdate();
							v.setData(propData);
							v.endUpdate();
						}
					};
					if (this.async) {
						s.requestAsync("read", args, f);
					} else {
						s.requestSync("read", args);
						f();
					}
				}
			}
		}
		catch (x) {
		}
	}, canLazyLoad:function (inTypeInfo) {
		if (this._updating || !wm.typeManager.getLiveService(inTypeInfo.type)) {
			return;
		}
		if (this.isDesignLoaded() && !studio.isLiveLayoutReady()) {
			return false;
		}
		var o = this;
		while (o instanceof wm.Variable) {
			if (!o._allowLazyLoad) {
				return false;
			}
			o = o.owner;
		}
		return inTypeInfo.isList || this._hasRequiredReadData();
	}, _hasRequiredReadData:function () {
		var ds = this._dataSchema, s, d;
		for (var i in ds) {
			s = ds[i];
			if (s.include && dojo.indexOf(s.include, "read") > -1) {
				d = this.data[i];
				if (d === undefined || d === null) {
					return false;
				}
			}
		}
		return true;
	}});
	wm.Variable.extend({_includeListProps:false, createVariable:function (inProps, inPropName) {
		inProps = inProps || {};
		inProps.liveView = this.liveView;
		var r = this._rootField, n = inPropName;
		inProps._rootField = r && inPropName ? r + "." + inPropName : (inPropName || "");
		var v = new wm.Variable(inProps);
		v.setOwner(this, true);
		return v;
	}, setDataSet:function (inDataSet) {
		this.dataSet = "";
		if (inDataSet instanceof wm.Variable) {
			this._rootField = inDataSet._rootField || "";
			this.setLiveView(inDataSet.liveView);
			this.setType(inDataSet ? inDataSet.type : "wm.Variable");
			this.dataSet = inDataSet;
			this.cursor = inDataSet.cursor;
		}
		this.setData(inDataSet);
	}, _getEagerProps:function (inVariable) {
		var v = inVariable, props = this.liveView ? this.liveView.getSubRelated(v._rootField) : [], schema = wm.typeManager.getTypeSchema(v.type);
		return this._includeListProps ? props : dojo.filter(props, function (r) {
			return !wm.typeManager.isPropInList(schema, r);
		});
	}, _getLoadProps:function (inPropName, inVariable) {
		return [inPropName].concat(dojo.map(this._getEagerProps(inVariable), function (r) {
			return [inPropName, r].join(".");
		}));
	}, lazyLoadData:function (inPropName, inVariable) {
		var s = wm.getRuntimeService(this), v = inVariable;
		try {
			if (s.ready) {
				var d = this.getData();
				if (!wm.isEmpty(d)) {
					var props = this.liveView ? this._getLoadProps(inPropName, v) : inPropName, args = [null, this.type, d, {properties:props}];
					wm.logging && console.log("lazyLoad", inVariable.owner && inVariable.owner.getId(), args);
					var f = function (r) {
						var propData = r && r[inPropName];
						if (propData) {
							v.beginUpdate();
							v.setData(propData);
							v.endUpdate();
						}
					};
					if (this.async) {
						s.requestAsync("read", args, f);
					} else {
						s.requestSync("read", args);
						f(s.result);
					}
				}
			}
		}
		catch (x) {
			wm.logging && console.log("Failed to lazy load.", args);
		}
	}, setLiveView:function (inLiveView) {
		this.liveView = inLiveView;
	}, getViewType:function () {
		return this.liveView && this.liveView.getSubType(this._rootField);
	}, getViewFields:function () {
		return (this.liveView && this.liveView.getSubView(this._rootField)) || [];
	}, getViewListFields:function () {
		return (this.liveView && this.liveView.getListView(this._rootField)) || [];
	}, getViewRelated:function () {
		return (this.liveView && this.liveView.getSubRelated(this._rootField)) || [];
	}});
	wm.Object.extendSchema(wm.Variable, {onPrepareSetData:{events:["js", "sharedjs"]}, data:{ignore:1}, isList:{ignore:1}, cursor:{ignore:1}, isPrimitive:{ignore:1}, type:{ignore:0, group:"common", order:1}, json:{group:"data", order:5}, dataSet:{readonly:1, bindable:1, group:"data", order:0, defaultBindTarget:1, isObject:true, type:"any", categoryParent:"Properties", categoryProps:{content:"dataSet", inspector:"Data"}}});
	wm.Variable.extend({makePropEdit:function (inName, inValue, inDefault) {
		switch (inName) {
		  case "type":
			return new wm.propEdit.DataTypesSelect({component:this, name:inName, value:inValue});
		  case "json":
			return makeTextPropEdit(inName, inValue, inDefault);
		}
		return this.inherited(arguments);
	}, isListBindable:function () {
		return this.isList;
	}});
}
if (!dojo._hasResource["wm.base.components.Binding"]) {
	dojo._hasResource["wm.base.components.Binding"] = true;
	dojo.provide("wm.base.components.Binding");
	dojo.declare("wm.Wire", wm.Component, {expression:"", source:"", targetProperty:"", targetId:"", destroy:function () {
		this.disconnectWire();
		this.inherited(arguments);
	}, setExpression:function (inExpression) {
		this.expression = inExpression || "";
		this.connectWire();
	}, setSource:function (inSource) {
		this.source = inSource;
		this.connectWire();
	}, setTargetProperty:function (inTargetProperty) {
		this.targetProperty = inTargetProperty;
		this.connectWire();
	}, getFullTarget:function () {
		return this.target.getId() + "." + this.targetProperty;
	}, canSetValue:function () {
		if (this.expression) {
			var sources = wm.expression.getSources(this.expression), ft = this.getFullTarget();
			for (var i = 0, s; (s = sources[i]); i++) {
				if (s == ft) {
					wm.logging && console.debug("Wire:", ft, "cannot be set because the target is an expression source");
					return false;
				}
			}
		}
		return true;
	}, _sourceValueChanged:function (inValue) {
		if (wm.bindingsDisabled) {
			return;
		}
		inValue = this.expression ? wm.expression.getValue(this.expression, this.getRoot()) : inValue;
		if (this.canSetValue()) {
			this.target.setValue(this.targetProperty, inValue);
		}
	}, sourceValueChanged:function (inValue, inV2) {
		wm.logging && console.info("==> (sourceValueChanged) ", this.getFullTarget(), " <= ", this.source, "(" + inValue + ")");
		this._sourceValueChanged(inValue);
	}, sourceTopUpdated:function (inSource, inId) {
		wm.logging && console.info("==> (sourceTopUpdated) ", this.getFullTarget(), " <= ", inSource);
		this.refreshValue();
	}, sourceRootUpdated:function () {
		wm.logging && console.info("==> (sourceRootUpdated)", this.source);
		this.getValueById(this.source);
	}, refreshValue:function () {
		this._sourceValueChanged(this.getValueById(this.source));
	}, disconnectWire:function () {
		this._disconnect();
		this._unsubscribe();
	}, _watch:function (inSource, inRid) {
		wm.logging && console.info("Wire._watch: ", this.target.getId() + "." + this.targetProperty, "watching", inSource);
		var pre = inSource.indexOf("app.") == 0 ? "" : inRid;
		var topic = pre + inSource + "-changed";
		this.subscribe(topic, this, "sourceValueChanged");
		wm.logging && console.info("***", " subscribed to [", topic, "]");
		var oid = inSource.split(".");
		oid.pop();
		oid = oid.join(".");
		if (oid && oid != "app") {
			topic = pre + oid + "-ownerChanged";
			this.subscribe(topic, this, "sourceTopUpdated");
			wm.logging && console.info("***", " subscribed to [", topic, "]");
			var p = inSource.split("."), rootId = p.shift();
			if (rootId == "app" && p.length) {
				rootId += "." + p.shift();
			}
			if (rootId != oid) {
				topic = pre + rootId + "-rootChanged";
				this.subscribe(topic, this, "sourceRootUpdated");
				wm.logging && console.info("Wire._watch: ", this.source, " subscribed to ", topic);
			}
		}
	}, connectWire:function () {
		this.disconnectWire();
		this.target = this.target || (this.targetId ? this.getRoot().getValueById(this.targetId) : this.owner.owner);
		if (!this.target) {
			console.info("wm.Wire.init(): bad target: " + this.targetId + " (" + this.owner.owner.name + ")");
			this.bad = true;
			return;
		}
		if (this.targetProperty && (this.source || this.expression)) {
			this.subscribe("wmwidget-idchanged", this, "wireChanged");
			var rid = this.getRootId();
			if (this.expression) {
				dojo.forEach(wm.expression.getSources(this.expression), dojo.hitch(this, function (s) {
					this._watch(s, rid);
				}));
			} else {
				this._watch(this.source, rid);
			}
			this.refreshValue();
		}
	}, changeExpressionId:function (inOldId, inNewId) {
		var e = this.expression;
		o = "\\${" + inOldId.replace(new RegExp("\\.", "g"), "\\.");
		n = "${" + inNewId, r = (e.match(o + "[\\.|}]"));
		e = e.replace(new RegExp(o + "\\.", "g"), n + ".");
		e = e.replace(new RegExp(o + "}", "g"), n + "}");
		this.expression = e;
		return r;
	}, isPartialId:function (inId, inIdPart) {
		return (inId.indexOf(inIdPart) == 0) && (inIdPart.length == inId.length || inId.charAt(inIdPart.length) == ".");
	}, isPartialRootId:function (inId, inChangeRtId) {
		if (!inId) {
			return;
		}
		inId = inId.match("^app.") ? inId : this.getRootId() + inId;
		return this.isPartialId(inId, inChangeRtId);
	}, getWireId:function () {
		return (this.targetId ? this.targetId + "." : "") + this.targetProperty;
	}, wireChanged:function (inOldId, inNewId, inOldRtId, inNewRtId) {
		var changed, wireId = this.getWireId();
		if (this.expression) {
			changed = this.changeExpressionId(inOldId, inNewId);
		}
		if (this.isPartialRootId(this.source, inOldRtId)) {
			changed = true;
			this.source = inNewId + this.source.slice(inOldId.length);
		}
		if (this.isPartialRootId(this.targetProperty, inOldRtId)) {
			changed = true;
			this.targetProperty = inNewId + this.targetProperty.slice(inOldId.length);
		}
		if (this.isPartialRootId(this.targetId, inOldRtId)) {
			changed = true;
			this.targetId = inNewId + this.targetId.slice(inOldId.length);
		}
		if (changed) {
			this.connectWire();
			if (this.owner && this.owner.wires) {
				delete this.owner.wires[wireId];
				this.owner.wires[this.getWireId()] = this;
			}
		}
	}});
	wm.Object.extendSchema(wm.Wire, {expression:{}, source:{}, targetProperty:{}, targetId:{}});
	dojo.declare("wm.Binding", wm.Component, {constructor:function (inProps) {
		this.wires = {};
	}, destroy:function () {
		this.removeWires();
		this.inherited(arguments);
	}, loaded:function () {
		for (var i in this.components) {
			var c = this.components[i];
			this.wires[c.getWireId()] = c;
			c.connectWire();
		}
		this.inherited(arguments);
	}, refresh:function () {
		wm.forEachProperty(this.wires, function (w) {
			w.refreshValue();
		});
	}, addWire:function (inTargetId, inTargetProperty, inSource, inExpression) {
		var id = (inTargetId ? inTargetId + "." : "") + inTargetProperty;
		this.removeWire(id);
		var props = {name:this.getUniqueName("wire"), owner:this, targetId:inTargetId, targetProperty:inTargetProperty, source:inSource, expression:inExpression};
		var wire = this.wires[id] = new wm.Wire(props);
		wire.connectWire();
	}, removeWire:function (inWireId, inSource, inExpression) {
		var wire = this.wires[inWireId];
		if (wire) {
			var s = inSource == undefined || inSource == wire.source, e = inExpression == undefined || inExpression == wire.expression;
			if (s && e) {
				wire.destroy();
				delete this.wires[inWireId];
			}
		}
	}, findWiresByProps:function (inProps) {
		var match = function (w) {
			for (var i in inProps) {
				if (inProps[i] != w[i]) {
					return;
				}
			}
			return true;
		};
		return this.findWires(match);
	}, findWires:function (inMatchFunc) {
		var f = [];
		if (inMatchFunc) {
			wm.forEachProperty(this.wires, function (w) {
				if (inMatchFunc(w)) {
					f.push(w);
				}
			});
		}
		return f;
	}, removeWireByProps:function (inProps) {
		var wires = this.findWiresByProps(inProps);
		this.removeWiresList(wires);
	}, removeWireList:function (inWires) {
		dojo.forEach(inWires, dojo.hitch(this, function (w) {
			this.removeWire(w.getWireId());
		}));
	}, removeWires:function () {
		wm.forEachProperty(this.wires, function (w) {
			w.destroy();
		});
		this.wires = {};
	}, write:function (inIndent) {
		return !wm.isEmpty(this.wires) ? this.inherited(arguments) : null;
	}});
}
if (!dojo._hasResource["wm.base.components.Service"]) {
	dojo._hasResource["wm.base.components.Service"] = true;
	dojo.provide("wm.base.components.Service");
	dojo.declare("wm.Service", wm.Component, {_operations:{}, result:null, error:null, getOperationsList:function () {
		var l = [];
		for (var i in this._operations) {
			l.push(i);
		}
		l.sort();
		return l;
	}, getOperation:function (inOperation) {
		return this._operations[inOperation];
	}, initService:function () {
	}, invoke:function (inMethod, inArgs, inOwner) {
		var d = new dojo.Deferred(), m = this[inMethod];
		if (m) {
			var result = m.apply(this, inArgs);
			this.onResult();
			wm.onidle(function () {
				d.callback(result);
			});
		} else {
			this.onError();
			wm.onidle(function () {
				d.errback("operation: " + inMethod + " does not exist.");
			});
		}
		return d;
	}, onResult:function (inResult) {
		this.error = null;
		return this.result = inResult;
	}, onError:function (inError) {
		this.result = null;
		return this.error = inError;
	}});
	wm.services = {byName:{}, _services:{}, add:function (inService) {
		return wm.services.byName[inService.name] = inService;
	}, remove:function (inService) {
		var n = inService.name;
		this._destroyService(n);
		delete wm.services.byName[n];
	}, getNamesList:function () {
		var l = [], services = wm.services.byName, s;
		for (var i in services) {
			s = services[i];
			if (!s.clientHide) {
				l.push(i);
			}
		}
		l.sort();
		return l;
	}, forEach:function (inFunction) {
		wm.forEach(this.byName, function (s) {
			inFunction(s);
		});
	}, clear:function () {
		var n = wm.services.byName, s;
		for (var i in n) {
			s = n[i];
			if (!s.isClientService) {
				this.remove(s);
			} else {
				this._destroyService(s);
			}
		}
	}, getService:function (inName) {
		var s;
		if (inName) {
			s = this._services[inName] || this._createService(inName);
			if (!s._service) {
				s.initService();
			}
		}
		return s;
	}, _createService:function (inName) {
		var defaultCtor = "wm.JsonRpcService", s = this.byName[inName];
		if (!s) {
			s = this.add({name:inName, ctor:defaultCtor});
		}
		var ctor = dojo.getObject(s.ctor || defaultCtor);
		var service = new ctor({name:inName, service:inName});
		service.owner = dojo.getObject("studio.wip.app") || app;
		return service;
	}, _destroyService:function (inService) {
		wm.fire(this._services[inService.name], "destroy");
	}};
}
if (!dojo._hasResource["wm.base.components.ServiceQueue"]) {
	dojo._hasResource["wm.base.components.ServiceQueue"] = true;
	dojo.provide("wm.base.components.ServiceQueue");
	dojo.declare("wm.ServiceQueue", wm.Component, {services:"", init:function () {
		this._services = [];
		this._serviceConnections = [];
		this.inherited(arguments);
	}, getServicesCount:function () {
		return this._services && this._services.length;
	}, getServicesList:function () {
		for (var i = 0, l = [], ss = this.services.split(","), s, v; (s = ss[i]); i++) {
			v = this.getValueById(dojo.string.trim(s));
			if (v) {
				l.push(v);
			}
		}
		return l;
	}, update:function () {
		this.beginUpdate();
	}, beginUpdate:function () {
		this._services = this.getServicesList();
		this.connectServices();
		this._currentService = 0;
		this.updateNextService();
	}, getCurrentService:function () {
		return this._services[this._currentService];
	}, updateNextService:function () {
		if (this._currentService < this.getServicesCount()) {
			var s = this.getCurrentService();
			this._currentService++;
			s.update();
		} else {
			this.completeUpdate();
		}
	}, completeUpdate:function () {
		this.disconnectServices();
	}, abortUpdate:function () {
		this.disconnectServices();
	}, connectServices:function () {
		this.disconnectServices();
		dojo.forEach(this._services, dojo.hitch(this, function (s) {
			this._serviceConnections.push(dojo.connect(s, "onResult", this, "updateNextService"));
			this._serviceConnections.push(dojo.connect(s, "onError", this, "abortUpdate"));
		}));
	}, disconnectServices:function () {
		dojo.forEach(this._serviceConnections, function (s) {
			dojo.disconnect(s);
		});
	}});
	wm.ServiceQueue.extend({getAvailableServicesList:function () {
		var d = wm.listComponentIds([studio.application, studio.page], wm.ServiceVariable);
		d = d.concat(wm.listComponentIds([studio.application, studio.page], wm.NavigationCall));
		var i = dojo.indexOf(d, this.owner.getId());
		if (i != -1) {
			d.splice(i, 1);
		}
		return d;
	}, write:function (inIndent) {
		return this.services ? this.inherited(arguments) : null;
	}});
}
if (!dojo._hasResource["wm.base.components.ServiceCall"]) {
	dojo._hasResource["wm.base.components.ServiceCall"] = true;
	dojo.provide("wm.base.components.ServiceCall");
	dojo.declare("wm.ServiceCall", null, {autoUpdate:false, startUpdate:false, startUpdateComplete:false, service:"", operation:"", _operationInfo:{}, destroy:function () {
		this.inherited(arguments);
		wm.fire(this._requester, "cancel");
	}, postInit:function () {
		this.inherited(arguments);
		this.connectStartUpdate();
		if (!this.$.queue) {
			new wm.ServiceQueue({name:"queue", owner:this});
		}
		this.initInput();
		this.setService(this.service);
		this._setOperation(this.operation);
	}, initInput:function () {
		this.input = this.$.input;
		if (!this.input) {
			this.input = this.createInput();
		}
		this.subscribe(this.input.getRuntimeId() + "-changed", this, "inputChanged");
	}, setService:function (inService) {
		this.service = inService;
		this._service = wm.services.getService(this.service) || new wm.Service({});
		wm.fire(this._service, "setServiceCall", [this]);
	}, _setOperation:function (inOperation) {
		this.operation = inOperation;
		this._operationInfo = this.getOperationInfo(this.operation);
		this.operationChanged();
	}, setOperation:function (inOperation) {
		this._setOperation(inOperation);
		this.doAutoUpdate();
	}, getOperationInfo:function (inOperation) {
		return (this._service && this._service.getOperation(inOperation)) || {};
	}, operationChanged:function () {
		this.input.operationChanged(this.operation, this._operationInfo.parameters);
	}, createInput:function () {
		var i = new wm.ServiceInput({name:"input", owner:this});
		i.operationChanged(this.operation, this._operationInfo.parameters);
		return i;
	}, inputChanged:function () {
		this.doAutoUpdate();
	}, connectStartUpdate:function () {
		if (this.owner && this.owner.start) {
			this.connect(this.owner, "start", this, "doStartUpdate");
		}
	}, setAutoUpdate:function (inAutoUpdate) {
		this.autoUpdate = inAutoUpdate;
		this.doAutoUpdate();
	}, setStartUpdate:function (inStartUpdate) {
		this.startUpdate = inStartUpdate;
		if (this.startUpdate && !this._loading && this.isDesignLoaded()) {
			this.update();
		}
	}, doStartUpdate:function () {
		if (this.startUpdate && !this._loading) {
			this.update();
			this.startUpdateComplete = true;
		}
	}, doAutoUpdate:function () {
		if (this.autoUpdate && !this._loading && (!this.startUpdate || this.startUpdateComplete || this.isDesignLoaded())) {
			this.update();
		}
	}, update:function () {
		return this.isDesignLoaded() ? this.doDesigntimeUpdate() : this._update();
	}, _update:function () {
		if (this.canUpdate()) {
			this.onBeforeUpdate(this.input);
			return this.request();
		}
	}, canUpdate:function () {
		var info = {canUpdate:this._getCanUpdate()};
		this.onCanUpdate(info);
		return info.canUpdate;
	}, _getCanUpdate:function () {
		return this._service && this.operation && !Boolean(this._requester);
	}, getArgs:function () {
		return this.input.getArgs();
	}, request:function (inArgs) {
		inArgs = inArgs || this.getArgs();
		wm.logging && console.debug("request", this.getId(), "operation", this.operation, "args", inArgs);
		if (djConfig.isDebug) {
			console.log("REQUEST   Component: " + this.getRoot() + "." + this.name + ";  Operation: " + this.operation);
		}
		var d = this._requester = this._service.invoke(this.operation, inArgs, this.owner);
		return this.processRequest(d);
	}, processRequest:function (inDeferred) {
		var d = inDeferred;
		if (d) {
			d.canceller = function (inDeferred) {
				inDeferred.fired = 1;
			};
			d.addBoth(dojo.hitch(this, function (r) {
				this._requester = false;
				return r;
			}));
			d.addCallbacks(dojo.hitch(this, "result"), dojo.hitch(this, "error"));
			return d;
		}
	}, result:function (inResult) {
		var tmp = [];
		var max = this.isDesignLoaded() ? this.designMaxResults : this.maxResults;
		if ((this instanceof wm.ServiceVariable) && !(this instanceof wm.LiveVariable) && inResult && dojo.isArray(inResult) && inResult.length > 1 && max > 0) {
			var cnt = 0;
			for (var o in inResult) {
				tmp[cnt] = inResult[cnt];
				cnt++;
				if (max > 0 && cnt == max) {
					break;
				}
			}
			this.processResult(tmp);
			return tmp;
		} else {
			this.processResult(inResult);
			return inResult;
		}
	}, processResult:function (inResult) {
		this.onResult(inResult);
		this.onSuccess(inResult);
		this.$.queue.update();
	}, error:function (inError) {
		this.processError(inError);
		return inError;
	}, processError:function (inError) {
		this.onResult(inError);
		this.onError(inError);
	}, onCanUpdate:function (ioUpdate) {
	}, onBeforeUpdate:function (ioInput) {
	}, onResult:function (inDeprecated) {
	}, onSuccess:function (inDeprecated) {
	}, onError:function (inError) {
		var errCodes = inError.message.match(/(\d+)$/);
		var errCode = (errCodes) ? errCodes[0] : "";
		if (errCode == 403) {
			dojo.publish("session-expiration-servicecall", [this]);
		} else {
			dojo.publish("service-variable-error", [this, inError]);
		}
	}});
	wm.ServiceCall.extend({clearInput:"(clear input)", updateNow:"(update now)", queue:"(serviceCalls)", doDesigntimeUpdate:function () {
		this.designTime = true;
		return studio.makeLiveDataCall(dojo.hitch(this, "_update"));
	}, doClearInput:function () {
		this.input.destroy();
		this.input = this.createInput();
	}, set_operation:function (inOperation) {
		this.setOperation(inOperation);
		if (this.isDesignLoaded() && studio.selected == this) {
			studio.inspector.inspect(studio.selected);
		}
	}, getServicesList:function () {
		return [""].concat(wm.services.getNamesList() || []);
	}, showQueueDialog:function () {
		var d = wm.ServiceQueue.dialog, q = this.$.queue;
		if (d) {
			d.page.binding = q;
			d.page.update();
		} else {
			wm.ServiceQueue.dialog = d = new wm.PageDialog({name:"queueDialog", owner:studio, contentWidth:600, contentHeight:400, hideControls:true, pageName:"QueueDialog", pageProperties:{binding:q}});
		}
		d.show();
	}, makePropEdit:function (inName, inValue, inDefault) {
		switch (inName) {
		  case "service":
			return makeSelectPropEdit(inName, inValue, this.getServicesList(), inDefault);
		  case "operation":
			var s = this._service, valueOk = s && s.getOperation(inValue), methods = s && s.getOperationsList();
			if (!valueOk) {
				inValue = methods ? methods[0] : "";
				if (inValue) {
					this.set_operation(inValue);
				}
			}
			if (methods) {
				return makeSelectPropEdit(inName, inValue, methods, inDefault);
			}
			break;
		  case "queue":
		  case "updateNow":
		  case "clearInput":
			return makeReadonlyButtonEdit(inName, inValue, inDefault);
		}
		return this.inherited(arguments);
	}, editProp:function (inName, inValue, inInspector) {
		switch (inName) {
		  case "updateNow":
			return this.update();
		  case "queue":
			this.showQueueDialog();
			return;
		  case "clearInput":
			return this.doClearInput();
		}
		return this.inherited(arguments);
	}});
	wm.Object.extendSchema(wm.ServiceCall, {startUpdateComplete:{ignore:1}, designTime:{ignore:1}});
	dojo.declare("wm.ServiceInput", wm.Variable, {_allowLazyLoad:false, isDataProp:function (inProp) {
		return wm.isEmpty(this._dataSchema) || (inProp in this._dataSchema);
	}, operationChanged:function (inType, inSchema) {
		this.setType(inType + "Inputs");
		this.setDataSchema(inSchema);
		if (this.$.binding) {
			this.$.binding.refresh();
		}
	}, getArgs:function () {
		var data = this.getData(), args = [], d;
		for (var p in this._dataSchema) {
			if (data !== undefined) {
				d = data[p];
			}
			args.push(d !== undefined ? d : null);
		}
		return args;
	}});
	wm.Object.extendSchema(wm.ServiceInput, {dataSet:{ignore:1, defaultBindTarget:false, isObject:true, type:"any"}});
	wm.ServiceInputVariable = wm.ServiceInput;
}
if (!dojo._hasResource["wm.base.components.ServiceVariable"]) {
	dojo._hasResource["wm.base.components.ServiceVariable"] = true;
	dojo.provide("wm.base.components.ServiceVariable");
	dojo.declare("wm.ServiceVariable", [wm.Variable, wm.ServiceCall], {total:0, _page:0, maxResults:0, designMaxResults:50, processResult:function (inResult) {
		this.setData(inResult);
		this.inherited(arguments);
	}, getTotal:function () {
		return this.total || this.getCount();
	}, getPageCount:function () {
		return Math.ceil(this.getTotal() / (this.getCount() || 1));
	}, setPage:function (inPage) {
		this._page = Math.max(0, Math.min(this.getPageCount() - 1, inPage));
		this.firstRow = this._page * this.maxResults;
		this.update();
	}, getPage:function () {
		return this._page;
	}, setFirstPage:function () {
		this.setPage(0);
	}, setPreviousPage:function () {
		this.setPage(this._page - 1);
	}, setNextPage:function () {
		this.setPage(this._page + 1);
	}, setLastPage:function () {
		this.setPage(this.getPageCount());
	}, operationChanged:function () {
		this.inherited(arguments);
		var op = this._operationInfo;
		if (op) {
			this.setType(op.returnType);
		}
		if ((this.autoUpdate || this.startUpdate) && !this._loading && this.isDesignLoaded()) {
			this.update();
		}
	}});
	wm.Object.extendSchema(wm.ServiceVariable, {operation:{group:"common", order:24}, clearInput:{group:"operation", order:30}, onSetData:{ignore:1}, onCanUpdate:{events:["js", "sharedjs", "sharedEventHandlers"]}, input:{ignore:1, writeonly:1, componentonly:1, categoryParent:"Properties", categoryProps:{component:"input", bindToComponent:true, inspector:"Data"}}, service:{group:"common", order:23}, autoUpdate:{group:"common", order:25}, startUpdate:{group:"common", order:26}, maxResults:{group:"data", order:17}, designMaxResults:{group:"data", order:18}, updateNow:{group:"operation", order:10}, queue:{group:"operation", order:20}, json:{ignore:1}, listType:{ignore:1}, isList:{ignore:1}, binding:{ignore:1, writeonly:1}, type:{ignore:1}, dataSet:{ignore:1, defaultBindTarget:1, isObject:true, type:"any"}, startUpdateComplete:{ignore:1}, total:{ignore:1}});
	wm.ServiceVariable.description = "Data from a service.";
	wm.ServiceVariable.extend({});
}
if (!dojo._hasResource["wm.base.components.LiveView"]) {
	dojo._hasResource["wm.base.components.LiveView"] = true;
	dojo.provide("wm.base.components.LiveView");
	wm.getViewField = function (inTypeSchema, inPropName) {
		if (inTypeSchema) {
			var propInfo = wm.typeManager.getPropertyInfoFromSchema(inTypeSchema, inPropName);
			return {caption:wm.capitalize(inPropName.split(".").pop()), sortable:true, dataIndex:inPropName, type:propInfo.type, displayType:wm.getPrimitiveDisplayType(propInfo.type), required:propInfo.required, readonly:dojo.indexOf(propInfo.noChange, "read") >= 0, includeLists:true, includeForms:true, order:propInfo.fieldOrder};
		}
	};
	wm.getDefaultView = function (inTypeName, inPropertyPath) {
		inPropertyPath = inPropertyPath || "";
		var v = [], tm = wm.typeManager, schema = tm.getTypeSchema(inTypeName), propSchema = inPropertyPath ? tm.getTypeSchema(tm.getPropertyInfoFromSchema(schema, inPropertyPath).type) : schema, fields = wm.typeManager.getSimplePropNames(propSchema);
		wm.forEach(fields, function (f) {
			v.push(wm.getViewField(schema, (inPropertyPath ? inPropertyPath + "." : "") + f));
		});
		return v;
	};
	dojo.declare("wm.LiveView", wm.Component, {service:"", dataType:"", related:[], view:[], constructor:function () {
		this.related = [];
		this.view = [];
	}, init:function () {
		this.inherited(arguments);
		this.setDataType(this.dataType);
	}, loaded:function () {
		this.inherited(arguments);
		this.viewChanged();
	}, viewChanged:function () {
		dojo.publish(this.getRuntimeId() + "-viewChanged", [this.getId()]);
	}, createDefaultView:function () {
		this.setFields(this.related || [], wm.getDefaultView(this.dataType));
	}, getRelatedFields:function () {
		if (!this.related || this.related.length == 0) {
			this.related = this.getRequiredRelatedFields();
		}
		return this.related || [];
	}, getRequiredRelatedFields:function () {
		try {
			var ts = [];
			var schema = wm.typeManager.getTypeSchema(this.dataType);
			for (var i in schema) {
				var field = schema[i];
				var isRelatedField = wm.typeManager.isStructuredType(field.type);
				if (isRelatedField && field.required) {
					this.addRelated(i);
					ts.push(i);
				}
			}
			return ts;
		}
		catch (e) {
			console.info("error finding required fields.", e);
		}
		return [];
	}, setFields:function (inRelated, inView) {
		this.related = inRelated;
		this._sortView(inView);
		this.view = inView;
	}, getFieldIndex:function (inField) {
		var di = dojo.isObject(inField) ? inField.dataIndex : inField;
		for (var i = 0, view = this.view, f; f = view[i]; i++) {
			if (f.dataIndex == di) {
				return i;
			}
		}
		return -1;
	}, hasField:function (inField) {
		return (this.getFieldIndex(inField) > -1);
	}, getRelatedIndex:function (inRelated) {
		for (var i = 0, related = this.related, r; r = related[i]; i++) {
			if (r == inRelated) {
				return i;
			}
		}
		return -1;
	}, hasRelated:function (inRelated) {
		return (this.getRelatedIndex(inRelated) > -1);
	}, addField:function (inField) {
		var f = inField && wm.getViewField(wm.typeManager.getTypeSchema(this.dataType), inField);
		if (f && !this.hasField(f)) {
			this.view.push(f);
			this._sortView(this.view);
		}
		return f;
	}, removeField:function (inField) {
		var i = this.getFieldIndex(inField);
		if (i > -1) {
			this.view.splice(i, 1);
		}
	}, addRelated:function (inRelated) {
		if (inRelated && !this.hasRelated(inRelated)) {
			this.related.push(inRelated);
			this.addRelatedDefaultView(inRelated);
		}
	}, removeRelated:function (inRelated) {
		var i = this.getRelatedIndex(inRelated);
		if (i > -1) {
			this.related.splice(i, 1);
		}
	}, addRelatedDefaultView:function (inRelated) {
		var relatedFields = wm.getDefaultView(this.dataType, inRelated);
		dojo.forEach(relatedFields, function (f) {
			if (!this.hasField(f)) {
				this.view.push(f);
			}
		}, this);
		this._sortView();
	}, _sortView:function (inView) {
		if (dojo.isArray(inView)) {
			var t = this.dataType;
			inView.sort(function (a, b) {
				if (wm.isNumber(a.order) || wm.isNumber(b.order)) {
					return wm.compareNumbers(a.order, b.order);
				} else {
					a = a.dataIndex;
					b = b.dataIndex;
					var al = a.split(".").length, bl = b.split(".").length;
					return al == bl ? wm.data.compare(a, b) : wm.compareNumbers(al, bl);
				}
			});
		}
	}, _copyView:function (inView) {
		var view = [];
		for (var i = 0, v; (v = inView[i]); i++) {
			view.push(dojo.mixin({}, v));
		}
		return view;
	}, getViewById:function (inLiveViewId) {
		if (inLiveViewId instanceof wm.LiveView) {
			return inLiveViewId;
		} else {
			if (inLiveViewId) {
				return this.getRoot().app.getValueById(inLiveViewId);
			}
		}
	}, copyLiveView:function (inLiveView) {
		var lv = this.getViewById(inLiveView);
		if (lv) {
			this.setService(lv.service);
			this.setDataType(lv.dataType);
			var v = this._copyView(lv.view);
			this.setFields(lv.related, v);
		} else {
			this.clearView();
		}
	}, clearView:function () {
		this.setService("");
		this.setDataType("");
		this.setFields([], []);
	}, setService:function (inService) {
		this.service = inService;
	}, setDataType:function (inType) {
		var t = this.dataType;
		this.dataType = inType;
		if (t != this.dataType) {
			this.dataTypeChanged();
		}
		if (this._defaultView) {
			this.createDefaultView();
		}
	}, dataTypeChanged:function () {
		this.related = [];
		this.view = [];
	}, hasRelatedProp:function (inRelatedProp) {
		for (var i = 0, related = this.related, r; (r = related[i]); i++) {
			if (r == inRelatedProp) {
				return true;
			}
		}
	}, getListView:function (inPropPath) {
		var schema = wm.typeManager.getTypeSchema(this.getSubType(inPropPath));
		return dojo.filter(this.getSubView(inPropPath), function (v) {
			return !wm.typeManager.isPropInList(schema, v.dataIndex);
		});
	}, getSubType:function (inPropPath) {
		if (inPropPath) {
			var schema = wm.typeManager.getTypeSchema(this.dataType);
			return (schema && (wm.typeManager.getPropertyInfoFromSchema(schema, inPropPath) || 0).type) || this.dataType;
		} else {
			return this.dataType;
		}
	}, getSubRelated:function (inPropPath) {
		inPropPath = inPropPath ? inPropPath + "." : "";
		if (inPropPath) {
			var list = [], l = inPropPath.length;
			dojo.forEach(this.related, function (r) {
				if (r.indexOf(inPropPath) == 0) {
					list.push(r.substring(l));
				}
			});
			return list;
		} else {
			return this.related;
		}
	}, getSubView:function (inPropPath) {
		inPropPath = inPropPath ? inPropPath + "." : "";
		var view = this._copyView(this.view);
		if (inPropPath) {
			var list = [], l = inPropPath.length;
			dojo.forEach(view, function (v) {
				if (v.dataIndex.indexOf(inPropPath) == 0) {
					v.dataIndex = v.dataIndex.substring(l);
					list.push(v);
				}
			});
			return list;
		} else {
			return view;
		}
	}});
	wm.Object.extendSchema(wm.LiveView, {related:{ignore:1, writeonly:1}, view:{ignore:1, writeonly:1}, service:{ignore:1, writeonly:1}, dataType:{ignore:1, writeonly:1}});
}
if (!dojo._hasResource["wm.base.components.LiveView_Design"]) {
	dojo._hasResource["wm.base.components.LiveView_Design"] = true;
	dojo.provide("wm.base.components.LiveView_Design");
	wm.LiveView.extend({noInspector:true, afterPaletteDrop:function () {
		this.set_owner("Application");
		this._defaultView = true;
		this.newLiveViewDialog();
	}, newLiveViewDialog:function (inSender) {
		var d = this.getCreateLiveViewDialog();
		if (d.page) {
			d.page.update();
		}
		d.show();
	}, getCreateLiveViewDialog:function () {
		if (!wm.LiveView.newLiveViewDialog) {
			var props = {owner:studio, pageName:"CreateLiveView", hideControls:true, contentWidth:500, contentHeight:300};
			wm.LiveView.newLiveViewDialog = new wm.PageDialog(props);
		}
		var d = wm.LiveView.newLiveViewDialog;
		d.onClose = dojo.hitch(this, function (inWhy) {
			if (inWhy == "OK") {
				this.completeNewLiveView();
			} else {
				this.destroy();
				studio.refreshDesignTrees();
				studio.navGotoDesignerClick();
			}
		});
		return d;
	}, completeNewLiveView:function () {
		var d = this.getCreateLiveViewDialog(), p = d.page, service = p.serviceSelectEditor.getDataValue(), dataTypeIndex = p.dataTypeList.getSelectedIndex(), dataType = (wm.dataSources.sources[service][dataTypeIndex] || 0).type;
		this.setService(service);
		this.setDataType(dataType);
		this.editView();
	}, editView:function () {
		var c = studio.navGotoEditor("LiveViewEditor");
		var ed = c.page;
		if (ed) {
			ed.setLiveView(this);
			ed.update();
		}
	}, designSelect:function () {
		this.editView();
	}});
}
if (!dojo._hasResource["wm.base.components.LiveVariable"]) {
	dojo._hasResource["wm.base.components.LiveVariable"] = true;
	dojo.provide("wm.base.components.LiveVariable");
	dojo.declare("wm.LiveVariable", wm.ServiceVariable, {autoUpdate:true, startUpdate:true, operation:"read", firstRow:0, sourceData:null, matchMode:"start", ignoreCase:false, orderBy:"", liveSource:null, liveView:null, _rootField:"", destroy:function () {
		this._unsubscribeLiveView();
		this.inherited(arguments);
	}, init:function () {
		this.inherited(arguments);
		this.filter = new wm.Variable({name:"filter", owner:this, type:this.type || "any"});
		this.sourceData = new wm.Variable({name:"sourceData", owner:this, type:this.type || "any"});
		this.subscribe(this.filter.getRuntimeId() + "-changed", this, "filterChanged");
		this.subscribe(this.sourceData.getRuntimeId() + "-changed", this, "sourceDataChanged");
	}, postInit:function () {
		this.inherited(arguments);
		if (this.liveSource) {
			this.setLiveSource(this.liveSource);
		} else {
			this.setLiveView(this.liveView || this.createLiveView(this.type));
		}
		this.doAutoUpdate();
	}, _subscribeLiveView:function () {
		this._unsubscribeLiveView();
		if (this.liveView) {
			this._liveViewSubscription = dojo.subscribe(this.liveView.getRuntimeId() + "-viewChanged", dojo.hitch(this, "_liveViewChanged"));
		}
	}, _unsubscribeLiveView:function () {
		dojo.unsubscribe(this._liveViewSubscription);
		this._liveViewSubscription = null;
	}, isLiveType:function () {
		return wm.typeManager.getLiveService(this.type);
	}, doAutoUpdate:function () {
		if (this.isLiveType()) {
			this.inherited(arguments);
		}
	}, filterChanged:function () {
		this.doAutoUpdate();
	}, sourceDataChanged:function () {
		this.doAutoUpdate();
	}, setFilter:function (inFilter) {
		if ((inFilter || 0).type == this.type) {
			this.filter.setDataSet(inFilter);
		}
	}, setOrderBy:function (inOrderBy) {
		this.orderBy = inOrderBy;
		this.doAutoUpdate();
	}, setSourceData:function (inSourceData) {
		var liveType = this.isLiveType();
		if (!liveType || (inSourceData || 0).type == this.type) {
			this.sourceData.setDataSet(inSourceData);
			if (!liveType) {
				this._updating++;
				this.setLiveSource(this.sourceData.type);
				this._updating--;
			}
		}
	}, setLiveSource:function (inLiveSource) {
		var s = this.liveSource = inLiveSource, v = this.getRoot().app.getValueById(s) || this.createLiveView(s);
		if (v) {
			this.setLiveView(v);
		}
		this.doAutoUpdate();
	}, setLiveView:function (inLiveView) {
		this.clearData();
		this.liveView = inLiveView;
		this._subscribeLiveView();
		this.setType(this.getViewType());
	}, createLiveView:function (inType) {
		return new wm.LiveView({name:"liveView", owner:this, dataType:inType, _defaultView:true});
	}, setType:function (inType) {
		this.inherited(arguments);
		this.filter.setType(this.type);
		this.sourceData.setType(this.type);
		if (!this._updating && this.$.binding) {
			this.$.binding.refresh();
		}
	}, _liveViewChanged:function () {
		this.setType(this.liveView.dataType);
		if (this.isDesignLoaded()) {
			this.doAutoUpdate();
		}
	}, _getCanUpdate:function () {
		return this.inherited(arguments) && !(this.operation == "read" && this._isSourceDataBound() && wm.isEmpty(this.sourceData.getData()));
	}, operationChanged:function () {
	}, _update:function () {
		if (this.designTime) {
			this._service = wm.getRuntimeServiceDesignTime(this);
		} else {
			this._service = wm.getRuntimeService(this);
		}
		return this.inherited(arguments);
	}, getArgs:function () {
		var d = this.sourceData.getData(), t = this.sourceData.type || this.type, s = wm.typeManager.getService(this.type), args = [s, t, wm.isEmpty(d) ? null : d];
		if (this.operation == "read") {
			args = args.concat(this._getReadArguments());
		}
		return args;
	}, _getReadArguments:function () {
		var props = {properties:this._getEagerProps(this), filters:this._getFilters(), matchMode:this.matchMode, ignoreCase:this.ignoreCase}, paging = this.orderBy ? {orderBy:(this.orderBy || "").split(",")} : {}, max = this.isDesignLoaded() ? this.designMaxResults : this.maxResults, results = max ? {maxResults:max, firstResult:this.firstRow} : {};
		dojo.mixin(paging, results);
		return [props, paging];
	}, _getFilters:function () {
		return this._getFilterValues(this.filter.getData());
	}, _getFilterValues:function (inData, inPrefix) {
		var f = [], d, p;
		for (var i in inData) {
			d = inData[i];
			p = (inPrefix ? (inPrefix || "") + "." : "") + i;
			if (dojo.isObject(d) && d !== null) {
				f = f.concat(this._getFilterValues(d, p));
			} else {
				if (p !== undefined && d !== undefined && d !== null) {
					f.push(p + "=" + d);
				}
			}
		}
		return f;
	}, _isSourceDataBound:function () {
		var wires = this.$.binding.wires, w;
		for (var i in wires) {
			w = wires[i];
			if ((w.targetProperty || "").indexOf("sourceData") == 0) {
				return true;
			}
		}
	}, processResult:function (inResult) {
		this.dataSetCount = this._service.fullResult.dataSetSize;
		this.inherited(arguments);
	}, getPage:function () {
		return Math.floor(this.firstRow / (this.maxResults || 1));
	}, getTotalPages:function () {
		return Math.ceil((this.dataSetCount || 1) / (this.maxResults || 1));
	}, setPage:function (inPageIndex) {
		inPageIndex = Math.max(0, Math.min(this.getTotalPages() - 1, inPageIndex));
		this.firstRow = inPageIndex * (this.maxResults || 0);
		this.update();
	}, setNextPage:function () {
		this.setPage(this.getPage() + 1);
	}, setPreviousPage:function () {
		this.setPage(this.getPage() - 1);
	}, setFirstPage:function () {
		this.setPage(0);
	}, setLastPage:function () {
		this.setPage(this.getTotalPages() - 1);
	}});
	wm.Object.extendSchema(wm.LiveVariable, {update:{ignore:1, publicEvent:1}, related:{ignore:1}, view:{ignore:1}, service:{ignore:1}, dataType:{ignore:1}, operation:{group:"data", order:0}, input:{ignore:1}, liveSource:{group:"data", order:1}, liveView:{ignore:1}, sourceData:{ignore:1, group:"data", order:3, bindTarget:1, categoryParent:"Properties", categoryProps:{component:"sourceData", inspector:"Data"}}, filter:{ignore:1, group:"data", order:5, bindTarget:1, categoryParent:"Properties", categoryProps:{component:"filter", inspector:"Data"}}, matchMode:{group:"data", order:10}, firstRow:{group:"data", order:15}, orderBy:{group:"data", order:19}, ignoreCase:{group:"data", order:20}, configure:{ignore:1}, dataSetCount:{ignore:1}});
	wm.LiveVariable.extend({_operations:["read", "insert", "update", "delete"], _matchModes:["start", "end", "anywhere", "exact"], listProperties:function () {
		var p = this.inherited(arguments), r = (this.operation == "read");
		p.matchMode.ignore = !r;
		p.firstRow.ignore = !r;
		p.maxResults.ignore = !r;
		p.designMaxResults.ignore = !r;
		p.orderBy.ignore = !r;
		p.ignoreCase.ignore = !r;
		p.filter.bindTarget = r;
		p.filter.categoryParent = r ? "Properties" : "";
		return p;
	}, isListBindable:function () {
		return this.operation == "read" ? !(this.sourceData && !wm.isEmpty(this.sourceData.getData())) : false;
	}, designCreate:function () {
		this.inherited(arguments);
		this.subscribe("wmwidget-idchanged", this, "componentNameChanged");
	}, componentNameChanged:function (inOldId, inNewId, inOldRtId, inNewRtId) {
		if (inOldId == this.liveSource) {
			this.setLiveSource(inNewId);
		}
	}, set_operation:function (inOperation) {
		this.operation = inOperation;
		if (this.isDesignLoaded()) {
			this.setAutoUpdate(inOperation == "read");
			if (studio.selected == this) {
				studio.inspector.inspect(this);
			}
		}
	}, set_liveSource:function (inLiveSource) {
		this.setLiveSource(inLiveSource);
		if (this.isDesignLoaded() && studio.selected == this) {
			studio.inspector.inspect(this);
		}
	}, set_sourceData:function (inSourceData) {
		this.setSourceData(inSourceData);
		if (this.isDesignLoaded() && studio.selected == this) {
			studio.inspector.inspect(this);
		}
	}, set_filter:function (inFilter) {
		this.setFilter(inFilter);
		if (this.isDesignLoaded() && studio.selected == this) {
			studio.inspector.inspect(this);
		}
	}, checkOrderBy:function (inOrderBy) {
		var orderParts = (inOrderBy || "").split(","), re = new RegExp("^(?:asc|desc):", "i");
		for (var i = 0, o; (o = orderParts[i]); i++) {
			if (!dojo.trim(o).match(re)) {
				alert("Each property used in the orderBy clause must be of the form asc|desc: <propertyPath>. \"" + o + "\" does not match this format." + " The current orderBy clause will generate an error and should be corrected.");
				return;
			}
		}
		return true;
	}, set_orderBy:function (inOrderBy) {
		this.checkOrderBy(inOrderBy);
		this.setOrderBy(inOrderBy);
	}, makePropEdit:function (inName, inValue, inDefault) {
		switch (inName) {
		  case "liveSource":
			return new wm.propEdit.LiveSourcesSelect({component:this, name:inName, value:inValue});
		  case "matchMode":
			return makeSelectPropEdit(inName, inValue, this._matchModes, inDefault);
		  case "operation":
			return makeSelectPropEdit(inName, inValue, this._operations, inDefault);
		}
		return this.inherited(arguments);
	}});
}
if (!dojo._hasResource["wm.base.components.NavigationService"]) {
	dojo._hasResource["wm.base.components.NavigationService"] = true;
	dojo.provide("wm.base.components.NavigationService");
	dojo.declare("wm.NavigationService", wm.Service, {layer:"", layers:"", operation:"", _operations:{gotoLayer:{parameters:{layer:{type:"wm.Layer"}, showOnlyParentLayer:{type:"boolean"}}, returnType:"any", hint:"This operations displays the selected layer."}, nextLayer:{parameters:{layers:{type:"wm.Layers"}}, returnType:"any", hint:"The operation displays the next layer in the selected layers widget."}, previousLayer:{parameters:{layers:{type:"wm.Layers"}}, returnType:"any", hint:"The operation displays the previous layer in the selected layers widget."}, gotoPage:{parameters:{pageName:{type:"string"}}, returnType:"any", hint:"This operation displays a different page and requires a pageName."}, gotoPageContainerPage:{parameters:{pageName:{type:"string"}, pageContainer:{type:"wm.PageContainer"}}, returnType:"any", hint:"This operation displays a page in a pageContainer and requires both a pageContainer and a pageName."}, gotoDialogPage:{parameters:{pageName:{type:"string"}, hideControls:{type:"boolean"}, title:{type:"string"}, modal:{type:"boolean"}, width:{type:"number"}, height:{type:"number"}}, returnType:"any", hint:"This operation displays a page in a dialog."}, showToast:{parameters:{content:{type:"string"}, duration:{type:"number"}, cssClasses:{type:"string"}, dialogPosition:{type:"string"}}, returnType:"any", hint:"This operation displays a page in a dialog."}}, update:function () {
		this[this.operation || "gotoLayer"]();
	}, invoke:function (inMethod, inArgs, inOwner) {
		var d = this._deferred = new dojo.Deferred(), m = this[inMethod];
		if (m) {
			inArgs.push(inOwner);
			m.apply(this, inArgs);
		} else {
			this.onError();
			d.errback("operation: " + inMethod + " does not exist.");
		}
		return d;
	}, doResult:function () {
		if (this._resultConnect) {
			dojo.disconnect(this._resultConnect);
			this._resultConnect = null;
		}
		this.onResult();
		if (this._deferred && this._deferred.fired == -1) {
			this._deferred.callback(true);
		}
		this._deferred = null;
	}, gotoLayer:function (inLayer, showParentOnly) {
		var l = inLayer instanceof wm.Layer ? inLayer : null;
		if (l) {
			this.showLayer(l, showParentOnly);
		}
		this.doResult();
	}, nextLayer:function (inLayers) {
		var l = inLayers instanceof wm.Layers ? inLayers : null;
		if (l) {
			l.setNext();
		}
		this.doResult();
	}, previousLayer:function (inLayers) {
		var l = inLayers instanceof wm.Layers ? inLayers : null;
		if (l) {
			l.setPrevious();
		}
		this.doResult();
	}, showLayer:function (inLayer, showParentOnly) {
		var l = inLayer;
		while (l) {
			wm.fire(l, "activate");
			l = l.parent;
			if (showParentOnly) {
				break;
			}
		}
	}, gotoPage:function (inPageName, inOwner) {
		var page = inOwner.getParentPage();
		if (!app._page || !page || page == app._page) {
			this._resultConnect = dojo.connect(app, "onPageChanged", this, "doResult");
			wm.job(this.getId() + ": PageChange", 1, function () {
				app.loadPage(inPageName);
			});
		} else {
			if (page.owner instanceof wm.PageContainer || page.owner instanceof wm.PageContainerMixin) {
				this.gotoPageContainerPage(inPageName, page.owner);
			}
		}
	}, gotoPageContainerPage:function (inPageName, inPageContainer) {
		if (inPageContainer) {
			if (inPageName != inPageContainer.pageName) {
				this._resultConnect = dojo.connect(inPageContainer, "onPageChanged", this, "doResult");
				inPageContainer.setPageName(inPageName);
			} else {
				this.doResult();
			}
		} else {
			wm.logging && console.debug("pageContainer not found", inPageContainer);
		}
	}, gotoDialogPage:function (inPageName, inHideControls, inTitle, inModal, inWidth, inHeight) {
		this._resultConnect = dojo.connect(app.pageDialog, "onPageReady", this, "doResult");
		app.pageDialog.showPage(inPageName, inHideControls, String(inWidth) + "px", String(inHeight) + "px", inTitle, inModal);
	}, showToast:function (inContent, inDuration, cssClasses, toastPosition) {
		app.toastDialog.showToast(inContent, inDuration, cssClasses, toastPosition);
		this._deferred.callback();
	}});
	wm.services.add({name:"navigationService", ctor:"wm.NavigationService", isClientService:true, clientHide:true});
}
if (!dojo._hasResource["wm.base.components.NavigationCall"]) {
	dojo._hasResource["wm.base.components.NavigationCall"] = true;
	dojo.provide("wm.base.components.NavigationCall");
	dojo.declare("wm.NavigationCall", [wm.Component, wm.ServiceCall], {service:"navigationService", operation:"gotoLayer", processResult:function (inResult) {
		if (!this.owner) {
			return;
		}
		return this.inherited(arguments);
	}, processError:function (inError) {
		if (!this.owner) {
			return;
		}
		return this.inherited(arguments);
	}});
	wm.Object.extendSchema(wm.NavigationCall, {owner:{group:"common", order:1, readonly:true, options:["Page", "Application"], ignore:1}, autoUpdate:{ignore:1}, startUpdateComplete:{ignore:1}, startUpdate:{ignore:1}, service:{ignore:1, writeonly:1}, operation:{group:"common", order:24}, updateNow:{ignore:1}, queue:{group:"operation", order:20}, clearInput:{group:"operation", order:30}, input:{ignore:1, writeonly:1, componentonly:1, categoryParent:"Properties", categoryProps:{component:"input", bindToComponent:true, inspector:"Navigation"}}});
	wm.NavigationCall.extend({listProperties:function () {
		var result = this.inherited(arguments);
		result.owner.ignore = (this.operation == "gotoPage" || this.operation == "gotoDialogPage") ? 0 : 1;
		return result;
	}, operationChanged:function () {
		this.inherited(arguments);
		if (this.isDesignLoaded() && this.owner instanceof wm.Application && this.operation != "gotoPage" && this.operation != "gotoDialogPage" && studio.page) {
			this.set_owner("Page");
		}
	}});
	wm.NavigationCall.description = "Navigation service call.";
}
if (!dojo._hasResource["wm.base.components.FunctionService"]) {
	dojo._hasResource["wm.base.components.FunctionService"] = true;
	dojo.provide("wm.base.components.FunctionService");
	dojo.declare("wm.FunctionService", wm.Service, {operation:"", _operations:{componentFunction:{parameters:{component:{type:"wm.Component"}, functionName:{type:"String"}, functionArguments:{type:"String"}}, returnType:"AnyData", hint:"This operation calls a function on a given component."}, pageFunction:{parameters:{functionName:{type:"String"}, functionArguments:{type:"String"}}, returnType:"AnyData", hint:"This operation calls a function defined in the page or application Javascript source."}}, setServiceCall:function (inServiceCall) {
		this.serviceCall = inServiceCall;
	}, update:function () {
		this[this.operation || "componentFunction"]();
	}, componentFunction:function (inComponent, inFunction, inArguments) {
		if (!(inComponent instanceof wm.Component)) {
			return;
		}
		var args = (inArguments || "").split(",");
		for (var i = 0, l = args.length; i < l; i++) {
			args[i] = dojo.trim(args[i]);
		}
		var result = wm.fire(inComponent, inFunction, args);
		result = result === undefined ? true : result;
		return result;
	}, pageFunction:function (inFunction, inArguments) {
		return this.componentFunction((this.serviceCall ? this.serviceCall.getRoot() : this.getRoot()), inFunction, inArguments);
	}});
	wm.services.add({name:"functionService", ctor:"wm.FunctionService", isClientService:true});
}
if (!dojo._hasResource["wm.base.components.JsonRpcService"]) {
	dojo._hasResource["wm.base.components.JsonRpcService"] = true;
	dojo.provide("wm.base.components.JsonRpcService");
	wm.inflight = {_inflight:[], getCount:function () {
		return this._inflight.length;
	}, change:function () {
	}, add:function (inDeferred) {
		inDeferred._timeStamp = new Date().getTime();
		this._inflight.push(inDeferred);
		inDeferred.addBoth(dojo.hitch(this, "remove", inDeferred));
		this.change();
	}, remove:function (inDeferred, inResult) {
		var i = dojo.indexOf(this._inflight, inDeferred);
		if (i == -1) {
			return;
		}
		var delta = new Date().getTime() - inDeferred._timeStamp;
		this._inflight.splice(i, 1);
		this.change();
		return inResult;
	}, cancel:function () {
		dojo.forEach(this._inflight, function (d) {
			if (!d.canceller) {
				d.canceller = function () {
				};
			}
			d.cancel();
		});
	}};
	dojo.subscribe("wm-unload-app", wm.inflight, "cancel");
	dojo.declare("wm.JsonRpc", dojo.rpc.JsonService, {smd:null, required:false, sync:false, designTime:false, bind:function (method, parameters, deferredRequestHandler, url) {
		url = url || this.serviceUrl;
		if (!url) {
			return;
		}
		if (this.designTime) {
			url = url + "?designTime=true";
		}
		var props = {url:url || this.serviceUrl, postData:this.createRequest(method, parameters || []), contentType:this.contentType, timeout:this.timeout, handleAs:"json", sync:this.sync};
		var def = dojo.rawXhrPost(props);
		def.addCallbacks(this.resultCallback(deferredRequestHandler), this.errorCallback(deferredRequestHandler));
	}, parseResults:function (obj) {
		return obj;
	}});
	dojo.declare("wm.JsonRpcService", wm.Service, {operations:"", ready:false, service:"", timeout:0, errorLevel:10, sync:false, url:"", _methods:[], _operations:{}, _service:null, init:function () {
		this.inherited(arguments);
		this.initService();
	}, setSync:function (inSync) {
		this.sync = inSync;
	}, getServiceRoot:function () {
		return this.getPath() + "services/";
	}, getJsonPath:function () {
		var p = "";
		if (this.isDesignLoaded() && window.studio && studio.project) {
			var projectPrefix = studio.projectPrefix;
			p = "/" + projectPrefix + studio.project.getProjectPath() + "/";
		}
		return p;
	}, initService:function () {
		var n = this.service || this.name, url = this.url || (n && (this.getServiceRoot() + n + ".smd?rand=" + Math.floor(Math.random() * 1000000)));
		this._service = null;
		if (url) {
			try {
				this._service = wm.JsonRpcService.smdCache[url];
				if (this._service) {
					this.listOperations();
				} else {
					this._service = new wm.JsonRpc(url);
					if (this.designTime) {
						this._service.designTime = true;
					}
					this._service.timeout = this.timeout;
					this.ready = Boolean(this._service && this._service.smd);
					if (this.ready) {
						this._service.serviceUrl = this.getJsonPath() + this._service.serviceUrl;
						this.listOperations();
					}
				}
			}
			catch (e) {
				console.debug(e);
			}
		}
	}, setName:function (inName) {
		this.inherited(arguments);
		if (!this.url) {
			this.initService();
		}
	}, ensureArgs:function (inMethod, inArgs) {
		if (inMethod in this._operations && dojo.isArray(inArgs)) {
			var op = this._operations[inMethod], argCount = 0;
			if (op) {
				for (var o in op.parameters) {
					argCount++;
				}
				for (var i = inArgs.length; i < argCount; i++) {
					inArgs.push(null);
				}
			}
		}
	}, invoke:function (inMethod, inArgs, owner) {
		if (!this._service) {
			return null;
		}
		this._service.sync = this.sync;
		this.ensureArgs(inMethod, inArgs);
		this.debugLastMethod = inMethod;
		if (djConfig.isDebug && !dojo.isFF) {
			console.group("JsonRpcService.invoke method:", inMethod);
			if (inArgs && inArgs.length) {
				console.log("Arguments:");
				console.log(inArgs);
			}
			console.groupEnd();
		}
		this.result = null;
		this.error = null;
		var d = this._service.callRemote(inMethod, inArgs || []);
		d.addBoth(dojo.hitch(this, function (r) {
			this.inflight = false;
			return r;
		}));
		d.addCallbacks(dojo.hitch(this, "onResult"), dojo.hitch(this, "onError"));
		wm.inflight.add(d);
		this.inflight = true;
		return d;
	}, request:function (inMethod, inArgs, inResult, inError) {
		var d = this.invoke(inMethod, inArgs);
		if (inResult) {
			if (dojo.isFunction(inResult)) {
				d.addCallback(inResult);
			} else {
				d.addCallback(this.owner, inResult);
			}
		}
		if (inError) {
			if (dojo.isFunction(inError)) {
				d.addErrback(inError);
			} else {
				d.addErrback(this.owner, inError);
			}
		}
		return d;
	}, requestSync:function (inMethod, inArgs, inResult, inError) {
		var s = this.sync;
		this.sync = true;
		var d = this.request.apply(this, arguments);
		this.sync = s;
		return d;
	}, requestAsync:function (inMethod, inArgs, inResult, inError) {
		var s = this.sync;
		this.sync = false;
		var cb = inResult ? dojo.hitch(this, function () {
			this.sync = s;
			return inResult.apply(this, dojo._toArray(arguments));
		}) : null, eb = inError ? dojo.hitch(this, function () {
			this.sync = s;
			return inError.apply(this, dojo._toArray(arguments));
		}) : null;
		return this.request(inMethod, inArgs, cb, eb);
	}, getResultSync:function (inMethod, inArgs) {
		var d = this.requestSync(inMethod, inArgs);
		return d.results[0];
	}, onResult:function (inResult) {
		var r = this.fullResult = inResult;
		this.result = (r || 0).result;
		if (djConfig.isDebug && !dojo.isFF) {
			console.group("Service Call Completed: " + this.name + "." + this.debugLastMethod);
			if (this.result) {
				console.log(this.result);
			} else {
				console.log("Response was null");
			}
			console.groupEnd();
		}
		return this.result;
	}, onError:function (inError) {
		try {
			console.group("Service Call Failed: " + this.name + "." + this.debugLastMethod);
			if (inError) {
				console.error(inError.message);
			}
			console.groupEnd();
			var errCodes = inError.message.match(/(\d+)$/);
			var errCode = (errCodes) ? errCodes[0] : "";
			if (errCode == 403) {
				dojo.publish("session-expiration", []);
			}
		}
		catch (e) {
			if (wm.logging) {
				console.dir(e);
				console.dir(inError);
			}
		}
		this.reportError(inError);
		return this.error = inError;
	}, reportError:function (inError) {
		var m = dojo.isString(inError) ? inError : (inError.message ? "Error: " + inError.message : "Unspecified Error");
		m = (this.name ? this.name + ": " : "") + m;
		if (this.errorLevel > 5) {
			if (!inError.dojoType == "cancel") {
				console.error(m);
			}
		} else {
			if (this.errorLevel > 0) {
				wm.logging && console.debug(m);
			}
		}
	}, paramArrayToHash:function (inParams) {
		var hash = {};
		for (var i = 0, p; (p = inParams[i]); i++) {
			hash[p.name] = {type:p.type, hidden:p.hidden};
		}
		return hash;
	}, listOperations:function () {
		this._methods = [];
		this._operations = {};
		var m = (this._service.smd || 0).methods || [];
		for (var i = 0, op; (op = m[i]); i++) {
			this._methods.push(op.name);
			this._operations[op.name] = {parameters:this.paramArrayToHash(op.parameters || []), returnType:op.returnType || "any"};
		}
		this._methods.sort();
	}, makePropEdit:function (inName, inValue, inDefault) {
		if (inName == "operations") {
			return makeSelectPropEdit(inName, inValue, this._methods || [], inDefault);
		}
		return this.inherited(arguments);
	}});
	wm.Object.extendSchema(wm.JsonRpcService, {ready:{ignore:1}});
	wm.JsonRpcService.description = "Any JsonRpc service.";
	wm.JsonRpcService.smdCache = {};
}
if (!dojo._hasResource["wm.base.components.ServerComponent"]) {
	dojo._hasResource["wm.base.components.ServerComponent"] = true;
	dojo.provide("wm.base.components.ServerComponent");
	dojo.declare("wm.ServerComponent", wm.Component, {noInspector:true, init:function () {
		this.inherited(arguments);
		this.publishClass = this.publishClass || this.declaredClass;
	}, prepare:function () {
		this.inherited(arguments);
		this.setOwner(null);
	}, write:function () {
		return "";
	}, designSelect:function () {
		this.editView();
	}, editView:function () {
	}});
}
if (!dojo._hasResource["wm.base.components.Security"]) {
	dojo._hasResource["wm.base.components.Security"] = true;
	dojo.provide("wm.base.components.Security");
	wm.disableUserPrincipalCookie = false;
	wm.login = function (args, loginSuccessCallback, loginFailedCallback, properties, projectName) {
		if (properties === undefined || properties == null) {
			properties = {j_username:args[0], j_password:args[1]};
		}
		properties.acegiAjaxLogin = "true";
		var def = dojo.xhrPost({url:(projectName ? "/" + projectName + "/" : "") + "j_acegi_security_check", content:properties, handleAs:"json", load:function (response, ioArgs) {
			if (response.url) {
				var pathname = location.protocol + "//" + location.host + location.pathname + location.search;
				if (dojo.cookie.isSupported() && !wm.disableUserPrincipalCookie) {
					var p = {username:properties.j_username, roles:wm.getUserRoles(true)};
					wm.setUserPrincipal(p);
				}
				if (loginSuccessCallback) {
					loginSuccessCallback(response.url);
				} else {
					if (window.studio) {
						if (studio.application && studio.page && studio.project) {
							if (studio.studioService.requestSync("openProject", [studio.project.projectName])) {
							}
							studio.navGotoDesignerClick();
						} else {
							studio.startLayer.activate();
						}
					} else {
						if (pathname != response.url) {
							location.href = response.url;
						} else {
							if (app._page.name == "login" && app.main != "login") {
								app.loadPage(app.main);
							}
						}
					}
				}
			} else {
				if (response.error) {
					if (loginFailedCallback) {
						loginFailedCallback(response.error);
					} else {
						console.error(response.error);
					}
				}
			}
		}});
	};
	wm.getUserPrincipal = function () {
		return wm.disableUserPrincipalCookie ? {} : dojo.fromJson(dojo.cookie("wmUserPrincipal")) || {};
	};
	wm.setUserPrincipal = function (userPrincipal) {
		dojo.cookie("wmUserPrincipal", dojo.toJson(userPrincipal));
	};
	wm.clearUserPrincipal = function () {
		dojo.cookie("wmUserPrincipal", null, {expires:-1});
	};
	wm.getUserRoles = function (force) {
		if (!force && wm.getUserPrincipal().roles) {
			return wm.getUserPrincipal().roles;
		}
		var s = wm.securityService || (wm.securityService = new wm.JsonRpcService({name:"securityService", sync:true}));
		try {
			if (s.ready) {
				s.request("getUserRoles", null);
				if (s.result) {
					return s.result;
				}
			}
		}
		catch (x) {
		}
	};
	wm.logout = function () {
		var s = wm.securityService || (wm.securityService = new wm.JsonRpcService({name:"securityService", sync:true, errorLevel:2}));
		try {
			if (s.ready) {
				s.request("logout", null);
				window.location.reload();
			}
		}
		catch (x) {
		}
	};
	dojo.declare("wm.Security", wm.ServerComponent, {afterPaletteDrop:function () {
		this.editView();
		studio.navGotoModelTreeClick();
		return true;
	}, editView:function () {
		studio.navGotoEditor("Security");
	}});
	dojo.declare("wm.SecurityLoader", null, {getComponents:function () {
		var cs = [];
		wm.services.forEach(function (s) {
			if (s.name == "securityService" || s.name == "securityServiceJOSSO") {
				var c = new wm.Security({name:"Security"});
				cs.push(c);
			}
		});
		return cs;
	}});
	wm.registerComponentLoader("wm.Security", new wm.SecurityLoader());
}
if (!dojo._hasResource["wm.base.components.DomMacro"]) {
	dojo._hasResource["wm.base.components.DomMacro"] = true;
	dojo.provide("wm.base.components.DomMacro");
	dojo.declare("wm.DomMacro", wm.Component, {steps:[], perform:function () {
		for (var i = 0, s; s = this.steps[i]; i++) {
			this.doStep(s);
		}
	}, doStep:function (inStep) {
		var fn = this[inStep.event + "Step"];
		if (fn) {
			fn.apply(this, [inStep, dojo.byId(inStep.node)]);
		}
	}, clickStep:function (inStep, inNode) {
		var event = document.createEvent("MouseEvents");
		event.initMouseEvent("click", true, true, window, 0, 0, 0, 0, 0, false, false, false, false, 0, null);
		inNode.dispatchEvent(event);
	}, sleepStep:function (inStep, inNode) {
		var t = new Date().getTime() + inStep.wait;
		while (new Date().getTime() < t) {
		}
	}, keyStep:function (inStep, inNode) {
		var event = document.createEvent("KeyboardEvent");
		event.initKeyEvent("keydown", true, true, window, false, false, false, false, inStep.key, 0);
		inNode.dispatchEvent(event);
	}, sendChar:function (inChar, inNode) {
		var event = document.createEvent("KeyboardEvent");
		event.initKeyEvent("keypress", true, true, window, false, false, false, false, 0, inChar);
		inNode.dispatchEvent(event);
	}, stringStep:function (inStep, inNode) {
		var s = inStep.chars;
		inNode.focus();
		for (var i = 0; i < s.length; i++) {
			this.sendChar(s.charCodeAt(i), inNode);
		}
	}});
}
if (!dojo._hasResource["wm.base.widget.Formatters"]) {
	dojo._hasResource["wm.base.widget.Formatters"] = true;
	dojo.provide("wm.base.widget.Formatters");
	wm.formatters = ["Number", "Date", "Time", "DateTime", "Currency", "Link", "RegularExpression", "Evaluation", "Image"];
	wm.getFormatter = function (inName) {
		var c = inName;
		if (c.slice(0, 5) != "wm") {
			c = "wm." + c + "Formatter";
		}
		return dojo.getObject(c) || wm.DataFormatter;
	};
	dojo.declare("wm.DataFormatter", wm.Component, {getColProps:function () {
		return {formatter:this.format};
	}, format:function (inDatum) {
		return (inDatum !== undefined) ? inDatum : "&nbsp;";
	}, valueChanged:function (inProp, inValue) {
		this.inherited(arguments);
		if (inProp) {
			wm.fire(this.owner, "formatChanged");
		}
	}});
	dojo.declare("wm.NumberFormatter", wm.DataFormatter, {digits:0, locale:"", round:false, noFormat:false, format:function (inDatum) {
		return (inDatum === undefined) ? "-" : (this.wmNoFormat ? inDatum : dojo.number.format(inDatum, this.getFormatProps()));
	}, getFormatProps:function () {
		return {places:Number(this.digits), locale:this.locale, round:this.round ? 0 : -1};
	}, getColProps:function () {
		return {formatter:this.format, getFormatProps:dojo.hitch(this, "getFormatProps"), wmNoFormat:this.noFormat};
	}});
	dojo.declare("wm.CurrencyFormatter", wm.NumberFormatter, {currency:"$", format:function (inDatum) {
		return (inDatum == undefined) ? "-" : dojo.currency.format(inDatum, this.getFormatProps());
	}, getFormatProps:function () {
		var p = this.inherited(arguments);
		this.digits = 2;
		p.currency = this.currency == "$" ? "USD" : this.currency;
		return p;
	}});
	dojo.declare("wm.RegularExpressionFormatter", wm.DataFormatter, {expression:".*", global:false, caseSensitive:true, replace:"$&", init:function () {
		this.inherited(arguments);
	}, format:function (inDatum) {
		var opts = (this.global ? "g" : "") + (this.caseSensitive ? "" : "i");
		re = new RegExp(this.expression, opts);
		return (inDatum != undefined) ? (this.expression ? String(inDatum).replace(re, this.replace) : inDatum) : "-";
	}, getColProps:function () {
		return {expression:this.expression, global:this.global, caseSensitive:this.caseSensitive, replace:this.replace, formatter:this.format};
	}});
	dojo.declare("wm.EvaluationFormatter", wm.DataFormatter, {_field:"$&", expression:"", init:function () {
		this.expression = this.expression || this._field;
		this.inherited(arguments);
	}, format:function (inDatum) {
		var isObject = dojo.isObject(inDatum), _data;
		if (isObject) {
			if (inDatum instanceof wm.Variable) {
				var o = inDatum.getData();
				_data = wm.isEmpty(o) ? inDatum.data : o;
			} else {
				_data = inDatum;
			}
			inDatum = "_data";
		}
		var ev = this.expression.replace(new RegExp("\\" + this._field, "g"), isObject ? inDatum : "\"" + inDatum + "\"");
		try {
			return String(eval("(" + ev + ")"));
		}
		catch (e) {
			console.log("evaluation error: ", e);
		}
	}, getColProps:function () {
		return {expression:this.expression, _field:this._field, formatter:this.format};
	}});
	dojo.declare("wm.DateTimeFormatter", wm.DataFormatter, {formatLength:"medium", _selector:"", datePattern:"", timePattern:"", locale:"", format:function (inDatum) {
		var opts = {selector:this._selector, formatLength:this.formatLength, datePattern:this.datePattern, timePattern:this.timePattern, locale:this.locale};
		var d = new Date(inDatum);
		if (isNaN(d.getTime())) {
			d = new Date(Number(inDatum));
		}
		return (inDatum == undefined) || isNaN(d.getTime()) ? "-" : dojo.date.locale.format(d, opts);
	}, getColProps:function () {
		return {_selector:this._selector, formatLength:this.formatLength, datePattern:this.datePattern, timePattern:this.timePattern, locale:this.locale, formatter:this.format};
	}, makePropEdit:function (inName, inValue, inDefault) {
		switch (inName) {
		  case "formatLength":
			return makeSelectPropEdit(inName, inValue, ["medium", "short", "long", "full"], inDefault);
		}
		return this.inherited(arguments);
	}});
	dojo.declare("wm.DateFormatter", wm.DateTimeFormatter, {_selector:"date"});
	dojo.declare("wm.TimeFormatter", wm.DateTimeFormatter, {_selector:"time"});
	dojo.declare("wm.LinkFormatter", wm.DataFormatter, {link:"", format:function (inDatum) {
		if (inDatum === undefined) {
			return "-";
		} else {
			var l = this.link;
			return l.indexOf("<a") >= 0 ? dojo.string.substitute(l, {data:inDatum}) : ["<a href=\"", this.link, this.link ? "#" : "", inDatum, "\">", inDatum, "</a>"].join("");
		}
	}, getColProps:function () {
		return {link:this.link, formatter:this.format};
	}});
	dojo.declare("wm.ImageFormatter", wm.DataFormatter, {imageWidth:"50px", imageHeight:"50px", format:function (src) {
		if (!src || src == "") {
			return "-";
		}
		return ["<img src=\"", src, "#", "\" width=\"", this.imageWidth, "\" height=\"", this.imageHeight, "\"/>"].join("");
	}, getColProps:function () {
		return {imageWidth:this.imageWidth, imageHeight:this.imageHeight, formatter:this.format};
	}});
	wm.Object.extendSchema(wm.DataFormatter, {name:{ignore:1}});
	wm.Object.extendSchema(wm.DateFormatter, {timePattern:{ignore:1}});
	wm.Object.extendSchema(wm.TimeFormatter, {datePattern:{ignore:1}});
}
if (!dojo._hasResource["wm.base.widget.Editors.dijit"]) {
	dojo._hasResource["wm.base.widget.Editors.dijit"] = true;
	dojo.provide("wm.base.widget.Editors.dijit");
	dijit.form._FormWidget.prototype.destroy = function () {
		try {
			wm.fire(this, "_hideTooltip");
			dijit._Widget.prototype.destroy.call(this);
		}
		catch (e) {
		}
	};
	dijit.form.ValidationTextBox.prototype._update = function (e) {
		if (e.type == "keyup") {
			wm.fire(this.owner, "validate");
		}
		this._refreshState();
		this._onMouse(e);
	};
	dijit.form.ValidationTextBox.prototype._defaultValidator = dijit.form.ValidationTextBox.prototype.validator;
	dijit.form.ValidationTextBox.prototype.validator = function (value, constraints) {
		var validator = dijit.form.ValidationTextBox.prototype._defaultValidator, valid = validator.call(this, value, constraints);
		return valid && (this.owner && this.owner.validator ? this.owner.validator(value, constraints) : true);
	};
	dijit.form.ValidationTextBox.prototype.displayMessage = function (message) {
		if (this._message == message) {
			return;
		}
		this._message = message;
		this._cancelHideTooltip();
		dijit.hideTooltip(this.domNode);
		if (message && !this.owner.readonly) {
			dijit.showTooltip(message, this.domNode, this.tooltipPosition);
			dijit._hideTooltipHandle = setTimeout(dojo.hitch(this, function () {
				wm.fire(this, "_hideTooltip");
			}), this.tooltipDisplayTime);
		}
	};
	dijit.form.ValidationTextBox.prototype._hideTooltip = function () {
		this._cancelHideTooltip();
		wm.hideToolTip();
	};
	dijit.form.ValidationTextBox.prototype._cancelHideTooltip = function () {
		clearTimeout(dijit._hideTooltipHandle);
		dijit._hideTooltipHandle = null;
	};
	dijit.form.NumberTextBox.prototype.format = function (value, constraints) {
		if (value === null) {
			return "";
		}
		if (typeof value == "string") {
			return value;
		}
		if (isNaN(value)) {
			return "";
		}
		if (this.editOptions && this._focused) {
			constraints = dojo.mixin(dojo.mixin({}, this.editOptions), this.constraints);
		}
		var v = this._formatter(value, constraints);
		return v;
	};
	dijit.form.NumberTextBox.prototype.parse = function (expression, options) {
		var v = dojo.number.parse(expression, options);
		if (isNaN(v) && !expression) {
			v = null;
		}
		return v;
	};
	dijit.form.CurrencyTextBox.prototype.parse = function (expression, options) {
		var v = dojo.currency.parse(expression, options);
		if (isNaN(v) && !expression) {
			v = null;
		}
		return v;
	};
	dijit.form.FilteringSelect.prototype._onKeyPressDefault = dijit.form.FilteringSelect.prototype._onKeyPress;
	dijit.form.FilteringSelect.prototype._onKeyPress = function (evt) {
		if (evt.altKey || (evt.ctrlKey && evt.charCode != 118)) {
			return;
		}
		var dk = dojo.keys;
		if (evt.keyCode == dk.DOWN_ARROW && !this._isShowingNow) {
			setTimeout(dojo.hitch(this, "_startSearch", [""]), 1);
		} else {
			this._onKeyPressDefault(evt);
		}
	};
	dijit.form.FilteringSelect.prototype.isValid = function (isFocused) {
		return !this.required || this._isvalid;
	};
}
if (!dojo._hasResource["wm.base.widget.Editors.Base"]) {
	dojo._hasResource["wm.base.widget.Editors.Base"] = true;
	dojo.provide("wm.base.widget.Editors.Base");
	wm.propertyIsChanged = function (inValue, inProp, inCtor) {
		var p = (inCtor || 0).prototype;
		return p && p[inProp] !== inValue;
	};
	wm.defaultEmptyValue = function (inType) {
		switch (inType) {
		  case "Text":
			return "";
		  case "Number":
			return 0;
		}
	};
	dojo.declare("wm._BaseEditor", wm.Widget, {classNames:"wmeditor", width:"100%", height:"100%", editorBorder:true, border:0, changeOnKey:false, changeOnEnter:false, required:false, showMessages:true, init:function () {
		this._editorConnects = [];
		this.name = "editor";
		this.setOwner(this.parent);
		this.singleLine = this.owner.singleLine;
		this.readonly = this.owner.readonly;
		this.disabled = this.owner.disabled;
		this.inherited(arguments);
	}, postInit:function () {
		this.createEditor();
		this.inherited(arguments);
	}, destroy:function () {
		this.destroyEditor();
		this.inherited(arguments);
	}, createEditor:function (inProps) {
		this.destroyEditor();
		var n = document.createElement("div");
		this.domNode.appendChild(n);
		this.startTimerWithName("CreateDijit", this.declaredClass);
		this.editor = this._createEditor(n, inProps);
		this.stopTimerWithName("CreateDijit", this.declaredClass);
		if (this.editor) {
			this.styleEditor();
			if (this.validationEnabled()) {
				this.validatorNode = this._getValidatorNode();
			}
			this.sizeEditor();
			this.connectEditor();
			this.setRequired(this.required);
			this.setInitialValue();
			if (this.editor._onChangeHandle) {
				window.clearTimeout(this.editor._onChangeHandle);
				this.editor._onChangeHandle = null;
			}
			this.setReadonly(this.readonly);
		}
		this.editor.owner = this;
		if (this.editor.displayMessage) {
			this.editor.displayMessage = function (message) {
				if (!this.owner.showMessages) {
					return;
				}
				var o = dojo.getObject(this.declaredClass);
				if (o) {
					o.prototype.displayMessage.apply(this, arguments);
				}
			};
		}
		return this.editor;
	}, validationEnabled:function () {
		if (this.isLoading()) {
			return false;
		} else {
			return true;
		}
	}, _createEditor:function (inNode, inProps) {
		return new dijit.form.TextBox(this.getEditorProps(inNode, inProps));
	}, destroyEditor:function () {
		this.disconnectEditor();
		wm.fire(this.editor, "destroy");
		this.editor = null;
	}, styleEditor:function () {
	}, sizeEditor:function () {
		if (this._cupdating) {
			return;
		}
		var e = this.editor;
		if (e) {
			var bounds = this.getContentBounds(), height = bounds.h ? bounds.h - 2 + "px" : "", width = bounds.w ? bounds.w - 4 + "px" : "", d = e && e.domNode, s = d.style, fc = d && d.firstChild;
			if (!this.editorBorder) {
				s.border = 0;
			}
			s.backgroundColor = this.editorBorder ? "" : "transparent";
			s.backgroundImage = this.editorBorder ? "" : "none";
			s.width = width;
			if (height) {
				if (fc) {
					dojo.forEach(fc.childNodes, function (c) {
						if (c.style) {
							c.style.height = height;
						}
					});
				}
				if (e.focusNode && e.focusNode.style) {
					e.focusNode.style.height = height;
				}
			}
		}
	}, renderBounds:function () {
		this.inherited(arguments);
		this.sizeEditor();
	}, setEditorBorder:function (inEditorBorder) {
		this.editorBorder = inEditorBorder;
		this.render();
	}, addEditorConnect:function (inConnect) {
		this._editorConnects.push(dojo.connect.apply(dojo, arguments));
	}, connectEditor:function () {
		this.disconnectEditor();
		this.addEditorConnect(this.editor, "onChange", this, "changed");
		this.addEditorConnect(this.editor, "onBlur", this, "blurred");
		this.addEditorConnect(this.editor, "_onFocus", this, "focused");
		this.addEditorConnect(this.editor.domNode, "onkeypress", this, "keypressed");
		this.addEditorConnect(this.editor.domNode, "onkeypress", this, "dokeypress");
		if (this.validationEnabled()) {
			this.addEditorConnect(this.editor, "validate", this, "editorValidated");
		}
	}, disconnectEditor:function () {
		dojo.forEach(this._editorConnects, dojo.disconnect);
		this._editorConnects = [];
	}, invalidate:function () {
		delete this._isValid;
	}, keypressed:function () {
		this.validate();
	}, blurred:function () {
		this.validate();
		this.owner.doOnblur();
	}, doOnblur:function () {
		if (!this.disabled) {
			this.onblur();
		}
	}, focused:function () {
		this.owner.doOnfocus();
	}, changed:function () {
		this.validate();
		this.owner.doOnchange();
	}, _getValidatorNode:function () {
		var n = this.editor && this.editor.domNode.firstChild;
		if (!n) {
			return null;
		}
		for (var i = 0, c, children = n.childNodes; c = children[i]; i++) {
			if (dojo.hasClass(c, "dijitValidationIcon")) {
				return c;
			}
		}
	}, editorValidated:function () {
		if (this.validatorNode) {
			this.validatorNode.style.display = this.editor.state == "Error" ? "" : "none";
		}
	}, validate:function () {
		if (this.validationEnabled()) {
			this.invalidate();
		}
		wm.job(this.getRuntimeId(), 25, dojo.hitch(this, function () {
			wm.fire(this.owner, "validate");
		}));
	}, getEditorProps:function (inNode, inProps) {
		return dojo.mixin({srcNodeRef:inNode, owner:this, disabled:this.owner.disabled}, inProps || {});
	}, getInvalid:function () {
		if (!this.validationEnabled()) {
			return false;
		}
		if (this.editor && this.editor.isValid) {
			if (this._isValid === undefined) {
				this._isValid = this.editor.isValid();
			}
			return !(this.readonly || this._isValid);
		}
	}, _getReadonlyValue:function () {
		return this.getDisplayValue() || "";
	}, setReadonly:function (inReadonly) {
		this.readonly = inReadonly;
		var dn = this.domNode, pn = this.editor.domNode.parentNode;
		if (this.readonly) {
			if (pn == dn) {
				dn.removeChild(this.editor.domNode);
			}
			wm.fire(this.editor, "_hideTooltip");
		} else {
			if (pn != dn) {
				dn.innerHTML = "";
				dn.appendChild(this.editor.domNode);
				this.owner.reflow();
			}
		}
		this.updateReadonlyValue();
	}, updateReadonlyValue:function () {
		if (this.readonly && (!this.editor.domNode.parentNode || !this.editor.domNode.parentNode.id)) {
			if (this instanceof wm._CheckBoxEditor) {
				this.setReadonlyValue();
			} else {
				this.domNode.innerHTML = this._getReadonlyValue();
			}
		}
	}, getDisplayValue:function () {
		return this.editor && this.editor.declaredClass && this.editor.attr && this.editor.attr("displayedValue") ? this.editor.attr("displayedValue") || "" : this.getEditorValue() || "";
	}, makeEmptyValue:function () {
		switch (this.owner.emptyValue) {
		  case "null":
			return null;
		  case "false":
			return false;
		  case "emptyString":
			return "";
		  case "zero":
			return 0;
		}
	}, getEditorValue:function () {
		var v;
		if (this.editor && this.editor.attr) {
			v = this.editor.attr("value");
		}
		return (v || v === 0) ? v : this.makeEmptyValue();
	}, setEditorValue:function (inValue) {
		if (this.editor && this.editor.attr) {
			inValue = inValue === undefined ? null : inValue;
			this.editor.attr("value", inValue);
			this.updateReadonlyValue();
		}
	}, setDisplayValue:function (inValue) {
		this.setEditorValue(inValue);
	}, setRequired:function (inValue) {
		var oldValue = this.required;
		this.required = inValue;
		if (this.editor) {
			this.editor.required = inValue;
			if (this.required || oldValue) {
				this.validate();
				wm.fire(this.owner, "requireChanged");
			}
		}
	}, setInitialValue:function () {
		var o = this.owner;
		o.beginEditUpdate();
		this.setEditorValue(wm.propertyIsChanged(o.dataValue, "dataValue", wm.Editor) ? o.dataValue : o.displayValue);
		o.endEditUpdate();
	}, setDisabled:function (inDisabled) {
		this.disabled = inDisabled;
		if (this.editor && this.editor.attr) {
			this.editor.attr("disabled", inDisabled);
		}
	}, isReady:function () {
		return Boolean(this.editor);
	}, focus:function () {
		wm.fire(this.editor, "focus");
	}, reset:function () {
		var e = this.editor;
		if (e) {
			e._hasBeenBlurred = false;
			wm.fire(e, "_hideTooltip");
		}
	}, clear:function () {
		this.reset();
		this.setEditorValue(null);
	}, listOwnerProperties:function () {
		var p = dojo.mixin({}, wm.Component.prototype.listProperties.apply(this) || {});
		for (var i in p) {
			if (!p[i].isOwnerProperty) {
				delete p[i];
			}
		}
		return p;
	}, listProperties:function () {
		var p = dojo.mixin({}, this.inherited(arguments) || {});
		for (var i in p) {
			if (p[i].isOwnerProperty) {
				delete p[i];
			}
		}
		return p;
	}, valueChanged:function (inProp, inValue) {
		if (this._updating) {
			return;
		}
		this.inherited(arguments);
	}, setValueAsEmpty:function () {
		this.makeEmptyValue();
	}, isLoading:function () {
		return this.owner._loading;
	}, dokeypress:function (inEvent) {
		if (this.changeOnKey || (this.changeOnEnter && inEvent.keyCode == dojo.keys.ENTER)) {
			wm.onidle(this, "doChangeOnKey", arguments);
		}
		if (inEvent.keyCode == dojo.keys.ENTER) {
			wm.onidle(this, "onEnterKeyPress", [this]);
		}
	}, doChangeOnKey:function (inEvent) {
		var e = this.editor;
		e.attr("value", e.attr("value"));
	}, onEnterKeyPress:function () {
	}});
	wm.createFieldEditor = function (inParent, inFieldInfo, inProps, inEvents, inClass) {
		var props = dojo.mixin({}, wm.getFieldEditorProps(inFieldInfo), inProps);
		var name = wm.getValidJsName(props.name || "editor1");
		return inParent.owner.loadComponent(name, inParent, inClass || "wm._TextEditor1", props, inEvents);
	};
	dojo.declare("wm.AbstractEditor", wm.Widget, {classNames:"wmeditor", height:"24px", width:"300px", padding:2, border:0, editorBorder:true, dataValue:null, displayValue:null, emptyValue:"unset", required:false, readonly:false, editorNode:null, caption:"", captionPosition:"left", captionSize:"100px", captionNode:null, captionAlign:"right", singleLine:true, changeOnEnter:false, changeOnKey:false, _updating:0, scrim:true, init:function () {
		this._editorConnects = [];
		this.inherited(arguments);
	}, getMinHeightProp:function () {
		if (this.minHeight) {
			return this.minHeight;
		}
		if (this.captionPosition == "left" || this.captionPosition == "right" || !this.caption) {
			return 24;
		} else {
			if (this.captionSize.match(/\%/)) {
				return 40;
			} else {
				return 24 + parseInt(this.captionSize);
			}
		}
	}, getMinWidthProp:function () {
		if (this.minWidth) {
			return this.minWidth;
		}
		if (this.captionPosition == "top" || this.captionPosition == "bottom" || !this.caption) {
			return 80;
		} else {
			if (this.captionSize.match(/\%/)) {
				return 120;
			} else {
				return 80 + parseInt(this.captionSize);
			}
		}
	}, createCaption:function () {
		var labeldiv = document.createElement("div");
		var s = labeldiv.style;
		s["float"] = "left";
		s.padding = "0px";
		s.margin = "0px";
		dojo.addClass(labeldiv, "wmeditor-caption");
		dojo.addClass(labeldiv, "wmlabel");
		labeldiv.innerHTML = this.caption;
		this.domNode.appendChild(labeldiv);
		this.captionNode = labeldiv;
		this.setCaptionAlign(this.captionAlign);
		this.setSingleLine(this.singleLine);
	}, postInit:function () {
		this.createEditor();
		this.inherited(arguments);
		wm.fire(this, "ownerLoaded");
		if (this.captionPosition != "left") {
			this.setCaptionPosition(this.captionPosition);
		}
		this.editorChanged();
	}, afterPaletteDrop:function () {
		this.setCaption(this.name);
	}, setCaption:function (inCaption) {
		var oldCap = this.caption;
		this.caption = inCaption;
		var cap = inCaption + ((this.required && !this.readonly) ? "&nbsp;<span class=\"wmeditor-required\">*</span>" : "");
		this.captionNode.innerHTML = cap;
		if (oldCap && !inCaption || !oldCap && inCaption) {
			dojo.style(this.captionNode, "display", (inCaption) ? "block" : "none");
			this.sizeEditor();
		}
	}, setCaptionSize:function (inCaptionSize) {
		this.captionSize = inCaptionSize;
		this.sizeEditor();
	}, setCaptionAlign:function (inCaptionAlign) {
		this.captionAlign = inCaptionAlign;
		dojo.style(this.captionNode, "textAlign", this.captionAlign);
	}, setCaptionPosition:function (pos) {
		var oldPos = this.captionPosition;
		this.captionPosition = pos;
		if ((oldPos == "left" || oldPos == "right") && (pos == "bottom" || pos == "top")) {
			if (this.height.match(/px/) && parseInt(this.height) < 48) {
				this.setHeight("48px");
			} else {
				if ((pos == "left" || pos == "right") && (oldPos == "bottom" || oldPos == "top")) {
					if (this.captionSize.match(/px/) && parseInt(this.captionSize) < 100) {
						this.captionSize = "100px";
					}
				}
			}
		}
		this.sizeEditor();
	}, setSingleLine:function (inSingleLine) {
		this.singleLine = inSingleLine;
		var s = this.captionNode.style;
		s.whiteSpace = (inSingleLine) ? "nowrap" : "normal";
		s.overflow = "hidden";
		s.lineHeight = (this.singleLine) ? s.height : "normal";
		if (this.readOnlyNode) {
			this.updateReadOnlyNodeStyle();
		}
	}, setDisabled:function (inDisabled) {
		var d = this.disabled;
		this.inherited(arguments);
		if (d != this.disabled && this.editor) {
			if (this.editor instanceof wm.Control) {
				this.editor.setDisabled(inDisabled);
			} else {
				this.editor.attr("disabled", inDisabled);
			}
			dojo[this.disabled ? "addClass" : "removeClass"](this.captionNode, "wmeditor-caption-disabled");
		}
		this.disabled = inDisabled;
	}, destroy:function () {
		this.destroyEditor();
		this.inherited(arguments);
	}, createEditor:function (inProps) {
		if (!this.captionNode) {
			this.createCaption();
		}
		this.destroyEditor();
		var n = document.createElement("div");
		this.domNode.appendChild(n);
		this.startTimerWithName("CreateDijit", this.declaredClass);
		this.editor = this._createEditor(n, inProps);
		if (this.editor._onChangeHandle) {
			window.clearTimeout(this.editor._onChangeHandle);
			this.editor._onChangeHandle = null;
		}
		this.editorNode = this.editor.domNode;
		this.editorNode.style.margin = "0";
		this.editorNode.style.padding = "0";
		this.stopTimerWithName("CreateDijit", this.declaredClass);
		if (this.editor) {
			this.styleEditor();
			if (this.validationEnabled()) {
				this.validatorNode = this._getValidatorNode();
			}
			this.sizeEditor();
			this.connectEditor();
			this.setRequired(this.required);
			this.setInitialValue();
			if (this.editor._onChangeHandle) {
				window.clearTimeout(this.editor._onChangeHandle);
				this.editor._onChangeHandle = null;
			}
			this.setReadonly(this.readonly);
		}
		if (this.editor.displayMessage) {
			this.editor.displayMessage = dojo.hitch(this, function (message) {
				if (!this.showMessages) {
					return;
				}
				var o = dojo.getObject(this.editor.declaredClass);
				if (o) {
					o.prototype.displayMessage.apply(this.editor, arguments);
				}
			});
		}
		return this.editor;
	}, validationEnabled:function () {
		return true;
	}, _createEditor:function (inNode, inProps) {
		return new dijit.form.TextBox(this.getEditorProps(inNode, inProps));
	}, destroyEditor:function () {
		this.disconnectEditor();
		wm.fire(this.editor, "destroy");
		this.editor = null;
	}, styleEditor:function () {
		if (this.isRelativePositioned) {
			if (this.captionNode) {
				dojo.addClass(this.captionNode, "wmInlineDiv");
			}
			return;
		}
		dojo.style(this.editorNode, {position:"absolute"});
		if (this.captionNode) {
			dojo.style(this.captionNode, {position:"absolute"});
		}
	}, sizeEditor:function () {
		if (this._cupdating) {
			return;
		}
		var e = (this.readonly) ? this.readOnlyNode : this.editor;
		if (e) {
			var bounds = this.getContentBounds();
			var position = this.captionPosition;
			var captionEditorSpacing = (position == "left" || position == "right") ? wm.AbstractEditor.captionPaddingWidth : wm.AbstractEditor.captionPaddingHeight;
			var w = bounds.w;
			var h = bounds.h;
			var labelWidth;
			var editorWidth;
			var height = bounds.h;
			var labelHeight;
			var editorHeight;
			if (!this.caption) {
				labelWidth = 0;
				editorWidth = w;
				editorHeight = h;
			} else {
				if (position == "left" || position == "right") {
					labelWidth = (this.captionSize.match(/px/)) ? parseInt(this.captionSize) : Math.floor(parseInt(this.captionSize) * w / 100);
					editorWidth = w - labelWidth;
					labelHeight = (height) ? height : "";
					editorHeight = labelHeight;
				} else {
					labelHeight = (this.captionSize.match(/px/)) ? parseInt(this.captionSize) : Math.floor(parseInt(this.captionSize) * height / 100);
					if (labelHeight > height) {
						labelHeight = height - 16;
						if (this.captionSize.match(/px/)) {
							this.captionSize = labelHeight + "px";
						}
					}
					editorHeight = (height - labelHeight);
					labelWidth = (w) ? w : "";
					editorWidth = labelWidth;
				}
			}
			labelWidth = Math.round(labelWidth);
			editorWidth = Math.round(editorWidth);
			var s = this.captionNode.style;
			var labelWidthWithSpacing = (labelWidth - ((position == "right" || position == "left") ? captionEditorSpacing : 0));
			labelWidthWithSpacing = (labelWidthWithSpacing) ? labelWidthWithSpacing : 0;
			if (labelWidthWithSpacing < 0) {
				labelWidthWithSpacing = 0;
			}
			s.width = labelWidthWithSpacing + "px";
			s.height = ((labelHeight && labelHeight > 0) ? labelHeight : 0) + "px";
			s.lineHeight = (s.lineHeight != "normal") ? s.height : "normal";
			s.left = (position == "right") ? (bounds.w + bounds.l - labelWidthWithSpacing) + "px" : bounds.l + "px";
			s.top = (position == "bottom") ? (editorHeight + bounds.t - captionEditorSpacing) + "px" : bounds.t + "px";
			var b = {w:editorWidth, h:editorHeight, l:((position == "left") ? labelWidth : 0) + bounds.l, t:((position == "top") ? labelHeight : 0) + bounds.t};
			if (!b.w || b.w < 0) {
				b.w = 0;
			}
			if (!b.h || b.h < 0) {
				b.h = 0;
			}
			if (e instanceof wm.Control) {
				var oldUpdatingValue = e._cupdating;
				e._cupdating = true;
				e.setBorder((this.editorBorder) ? "1" : "0");
				e.setBounds(b);
				e._cupdating = oldUpdatingValue;
				if (e.invalidCss) {
					e.render();
				} else {
					e.renderBounds();
				}
				e.reflow();
			} else {
				var setnode = (e["domNode"]) ? e.domNode : e;
				var s = setnode.style;
				if (this.editorBorder && b.w && b.h) {
					s.borderWidth = "1px";
					if (!this._editorBackgroundColor) {
						s.backgroundColor = "";
					}
					s.backgroundImage = "";
					b.w -= 2;
					b.h -= 2;
				} else {
					s.borderWidth = "0px";
					if (!this._editorBackgroundColor) {
						s.backgroundColor = "transparent";
					}
					s.backgroundImage = "none";
				}
				s.width = b.w + "px";
				s.height = b.h + "px";
				s.left = b.l + "px";
				s.top = b.t + "px";
				if (e == this.readOnlyNode) {
					this.updateReadOnlyNodeStyle(b.h);
				}
			}
		}
	}, updateReadOnlyNodeStyle:function (h) {
		var s = this.readOnlyNode.style;
		var overflow = this.getReadOnlyNodeOverflow();
		if (s.overflow != overflow) {
			s.overflow = overflow;
		}
		var lineHeight = this.getReadOnlyNodeLineHeight();
		if (s.lineHeight != lineHeight) {
			s.lineHeight = lineHeight;
		}
		var whiteSpace = this.getReadOnlyNodeWhiteSpace();
		if (s.whiteSpace != whiteSpace) {
			s.whiteSpace = whiteSpace;
		}
		var wordWrap = this.getReadOnlyNodeWordWrap();
		if (s.wordWrap != wordWrap) {
			s.wordWrap = wordWrap;
		}
	}, getReadOnlyNodeLineHeight:function () {
		if (this.singleLine) {
			return this.readOnlyNode.style.height;
		} else {
			return "normal";
		}
	}, getReadOnlyNodeOverflow:function () {
		return "hidden";
	}, getReadOnlyNodeWhiteSpace:function () {
		return "nowrap";
	}, getReadOnlyNodeWordWrap:function () {
		return "normal";
	}, renderBounds:function () {
		this.inherited(arguments);
		this.sizeEditor();
	}, setEditorBorder:function (inEditorBorder) {
		this.editorBorder = inEditorBorder;
		this.sizeEditor();
	}, addEditorConnect:function (inConnect) {
		this._editorConnects.push(dojo.connect.apply(dojo, arguments));
	}, connectEditor:function () {
		this.disconnectEditor();
		this.addEditorConnect(this.editor, "onChange", this, "changed");
		this.addEditorConnect(this.editor, "onBlur", this, "blurred");
		this.addEditorConnect(this.editor, "_onFocus", this, "focused");
		this.addEditorConnect(this.editor.domNode, "onkeypress", this, "keypressed");
		if (this.validationEnabled()) {
			this.addEditorConnect(this.editor, "validate", this, "editorValidated");
		}
	}, disconnectEditor:function () {
		dojo.forEach(this._editorConnects, dojo.disconnect);
		this._editorConnects = [];
	}, invalidate:function () {
		delete this._isValid;
	}, keypressed:function (inEvent) {
		this.validate();
		this.dokeypress(inEvent);
	}, blurred:function () {
		this.validate();
		this.doOnblur();
	}, focused:function () {
		dojo.publish("wm.AbstractEditor-focused", [this]);
		this.doOnfocus();
	}, doOnblur:function () {
		if (!this.disabled) {
			this.onblur();
		}
	}, onblur:function () {
	}, doOnfocus:function () {
		if (!this.disabled) {
			this.onfocus();
		}
	}, onfocus:function () {
	}, changed:function () {
		this.validate();
		this.doOnchange();
	}, doOnchange:function () {
		this.editorChanged();
		var e = this.editor;
		if (!this._loading && !this.isUpdating() && !this.readonly && e && !this.isLoading()) {
			this.onchange(this.getDisplayValue(), this.getDataValue());
		}
	}, onchange:function () {
	}, _getValidatorNode:function () {
		var n = this.editor && this.editor.domNode.firstChild;
		if (!n) {
			return null;
		}
		for (var i = 0, c, children = n.childNodes; c = children[i]; i++) {
			if (dojo.hasClass(c, "dijitValidationIcon")) {
				return c;
			}
		}
	}, editorValidated:function () {
		if (this.validatorNode) {
			this.validatorNode.style.display = this.editor.state == "Error" ? "" : "none";
		}
	}, validate:function () {
		if (this.validationEnabled()) {
			this.invalidate();
		}
		wm.job(this.getRuntimeId(), 25, dojo.hitch(this, function () {
			if (this.parent) {
				wm.fire(this.parent, "validate");
			}
			this.valueChanged("invalid", this.getInvalid());
		}));
	}, getEditorProps:function (inNode, inProps) {
		return dojo.mixin({srcNodeRef:inNode, owner:this, disabled:this.disabled}, inProps || {});
	}, isValid:function () {
		return !this.getInvalid();
	}, getInvalid:function () {
		if (!this.validationEnabled()) {
			return false;
		}
		if (this.editor && this.editor.isValid) {
			if (this._isValid === undefined) {
				this._isValid = this.editor.isValid();
			}
			return !(this.readonly || this._isValid);
		}
	}, _getReadonlyValue:function () {
		return this.getDisplayValue() || "";
	}, createReadOnlyNode:function () {
		var node = dojo.create("div");
		var readstyle = node.style;
		readstyle.lineHeight = "normal";
		readstyle.position = "absolute";
		readstyle.whiteSpace = (this.singleLine) ? "nowrap" : "normal";
		return node;
	}, setReadonly:function (inReadonly) {
		var r = this.readonly;
		this.readonly = inReadonly;
		if (r != this.readonly) {
			this.setCaption(this.caption);
		}
		var domNode = this.domNode;
		if (!this.readOnlyNode && this.readonly) {
			this.readOnlyNode = this.createReadOnlyNode();
		}
		if (this.readOnlyNode) {
			if (this.readonly && this.readOnlyNode.parentNode != domNode) {
				dojo.place(this.readOnlyNode, domNode, "last");
			} else {
				if (!this.readonly && this.readOnlyNode.parentNode == domNode) {
					domNode.removeChild(this.readOnlyNode);
				}
			}
		}
		if (!this.readonly && this.editorNode.parentNode != domNode) {
			dojo.place(this.editorNode, domNode, "last");
		} else {
			if (this.readonly && this.editorNode.parentNode == domNode) {
				domNode.removeChild(this.editorNode);
			}
		}
		this.invalidCss = true;
		this.render();
		if (this.readonly) {
			wm.fire(this.editor, "_hideTooltip");
		}
		this.updateReadonlyValue();
	}, updateReadonlyValue:function () {
		if (this.readonly && this.readOnlyNode) {
			this.readOnlyNode.innerHTML = this._getReadonlyValue();
		}
	}, getDisplayValue:function () {
		return this.editor && this.editor.declaredClass && this.editor.attr && this.editor.attr("displayedValue") ? this.editor.attr("displayedValue") || "" : this.getEditorValue() || "";
	}, makeEmptyValue:function () {
		if (this.emptyValue == "unset" && this.display) {
			return wm.defaultEmptyValue(this.display);
		}
		switch (this.emptyValue) {
		  case "null":
			return null;
		  case "false":
			return false;
		  case "emptyString":
			return "";
		  case "zero":
			return 0;
		}
	}, getEditorValue:function () {
		var v;
		if (this.editor) {
			v = this.editor.attr("value");
		}
		return (v || v === 0) ? v : this.makeEmptyValue();
	}, setEditorValue:function (inValue) {
		if (this.editor) {
			inValue = inValue === undefined ? null : inValue;
			this.editor.attr("value", inValue);
			this.updateReadonlyValue();
		}
	}, setDisplayValue:function (inValue) {
		this.setEditorValue(inValue);
	}, setRequired:function (inValue) {
		var oldValue = this.required;
		this.required = inValue;
		if (this.editor) {
			this.editor.required = inValue;
			if (this.required || oldValue) {
				this.validate();
				this.setCaption(this.caption);
			}
		}
	}, getRequired:function () {
		return this.required;
	}, beginEditUpdate:function (inProp) {
		this._updating++;
	}, endEditUpdate:function (inProp) {
		this._updating--;
	}, requireChanged:function () {
		this.setCaption(this.caption);
	}, setInitialValue:function () {
		this.beginEditUpdate();
		this.setEditorValue(wm.propertyIsChanged(this.dataValue, "dataValue", wm.Editor) ? this.dataValue : this.displayValue);
		this.endEditUpdate();
	}, editorChanged:function () {
		this.valueChanged("displayValue", this.displayValue = this.getDisplayValue());
		this.valueChanged("dataValue", this.dataValue = this.getDataValue());
	}, getDataValue:function () {
		return this.isReady() ? this.getEditorValue() : this.dataValue;
	}, setDataValue:function (inValue) {
		if (inValue === undefined) {
			inValue = null;
		}
		this.dataValue = inValue instanceof wm.Variable ? inValue.getData() : inValue;
		this.setEditorValue(inValue);
	}, isUpdating:function () {
		return this._updating > 0;
	}, isReady:function () {
		return Boolean(this.editor);
	}, canFocus:function () {
		return !this.readonly;
	}, focus:function () {
		wm.fire(this.editor, "focus");
	}, reset:function () {
		var e = this.editor;
		if (e) {
			e._hasBeenBlurred = false;
			wm.fire(e, "_hideTooltip");
		}
	}, clear:function () {
		this.beginEditUpdate();
		this.reset();
		this.setEditorValue(null);
		this.endEditUpdate();
		this.editorChanged();
	}, listOwnerProperties:function () {
		var p = dojo.mixin({}, wm.Component.prototype.listProperties.apply(this) || {});
		for (var i in p) {
			if (!p[i].isOwnerProperty) {
				delete p[i];
			}
		}
		return p;
	}, listProperties:function () {
		var p = dojo.mixin({}, this.inherited(arguments) || {});
		for (var i in p) {
			if (p[i].isOwnerProperty) {
				delete p[i];
			}
		}
		return p;
	}, valueChanged:function (inProp, inValue) {
		if (this._updating) {
			return;
		}
		this.inherited(arguments);
	}, isLoading:function () {
		return this._loading;
	}, dokeypress:function (inEvent) {
		if (this.changeOnKey || (this.changeOnEnter && inEvent.keyCode == dojo.keys.ENTER)) {
			wm.onidle(this, "doChangeOnKey", arguments);
		}
		if (inEvent.keyCode == dojo.keys.ENTER) {
			wm.onidle(this, "onEnterKeyPress", [this]);
		}
	}, doChangeOnKey:function (inEvent) {
		var e = this.editor;
		e.attr("value", e.attr("value"));
	}, setDefaultOnInsert:function () {
		if (this.editor && this.defaultInsert) {
			this.editor.attr("value", "" + this.defaultInsert, false);
		}
	}, onEnterKeyPress:function () {
	}});
	wm.AbstractEditor.captionPaddingWidth = 8;
	wm.AbstractEditor.captionPaddingHeight = 2;
	wm.Object.extendSchema(wm._BaseEditor, {name:{ignore:1}, showing:{ignore:1}, disabled:{ignore:1}, singleLine:{ignore:1}, readonly:{ignore:1}, border:{ignore:1}, borderColor:{ignore:1}, margin:{ignore:1}, padding:{ignore:1}, scrollX:{ignore:1}, scrollY:{ignore:1}});
	wm.AbstractEditor.extend({themeableDemoProps:{height:"24px"}, themeableSharedStyles:["-Editor Borders", "Editor-Border-Color", "Editor-Hover-Border-Color", "Editor-Focused-Border-Color", "Editor-Radius", "-Editor Backgrounds", "Editor-Background-Color", "Editor-Hover-Background-Color", "Editor-Focus-Background-Color", "-Editor Fonts", "Editor-Font-Color", "Editor-Hover-Font-Color", "Editor-Focus-Font-Color", "-Editor Background Image", "Editor-Image", "Editor-Image-Position", "Editor-Image-Repeat"], addUserClass:function (inClass, inNodeName) {
		this.inherited(arguments);
		if (inNodeName == "captionNode") {
			dojo.addClass(this.captionNode, inClass);
		}
	}, removeUserClass:function (inClass, inNodeName) {
		this.inherited(arguments);
		if (inNodeName == "captionNode") {
			dojo.removeClass(this.captionNode, inClass);
		}
	}, afterPaletteDrop:function () {
		this.setCaption(this.name);
	}, listProperties:function () {
		var props = this.inherited(arguments);
		var f = wm.getParentForm(this);
		props.formField.ignore = !Boolean(f);
		props.displayValue.readonly = this.formField;
		return props;
	}, set_formField:function (inFieldName) {
		if (!inFieldName) {
			delete this.formField;
		} else {
			this.formField = inFieldName;
		}
		var f = wm.getParentForm(this);
		if (f) {
			var fieldInfo = f.addEditorToForm(this);
			if (!this.caption) {
				this.setCaption(inFieldName);
			}
		}
	}, makePropEdit:function (inName, inValue, inDefault) {
		switch (inName) {
		  case "formField":
			return new wm.propEdit.FormFieldSelect({component:this, name:inName, value:inValue});
		  case "captionAlign":
			return makeSelectPropEdit(inName, inValue, ["left", "center", "right"], inDefault);
		  case "captionSize":
			return new wm.propEdit.UnitValue({component:this, name:inName, value:inValue, options:this._sizeUnits});
		  case "captionPosition":
			return makeSelectPropEdit(inName, inValue, ["top", "left", "bottom", "right"], inDefault);
		  case "emptyValue":
			return makeSelectPropEdit(inName, inValue, ["unset", "null", "emptyString", "false", "zero"], inDefault);
		  case "checkedValue":
			return this.editor.dataType == "boolean" ? makeCheckPropEdit(inName, inValue, inDefault) : this.inherited(arguments);
		  case "resizeToFit":
			return makeReadonlyButtonEdit(inName, inValue, inDefault);
		}
		return this.inherited(arguments);
	}});
	wm.Object.extendSchema(wm.AbstractEditor, {formField:{ignore:1, writeonly:1, group:"common", order:500}, caption:{group:"Labeling", order:1}, captionPosition:{group:"Labeling", order:2}, captionAlign:{group:"Labeling", order:3}, captionSize:{group:"layout", order:4}, singleLine:{group:"Labeling", order:5}, readonly:{group:"editor", order:1}, displayValue:{group:"editData", order:2}, dataValue:{ignore:1, bindable:1, group:"editData", order:3, simpleBindProp:true}, emptyValue:{group:"editData", order:4}, required:{group:"validation", order:1}, editorBorder:{group:"style", order:100}, scrollX:{ignore:1}, scrollY:{ignore:1}, changeOnEnter:{ignore:1}, changeOnKey:{ignore:1}, onEnterKeyPress:{ignore:1}, defaultInsert:{type:"String", bindable:1, group:"editData", order:10, dependency:"${parent.declaredClass} == \"wm.LiveForm\" || ${parent.declaredClass} == \"wm.RelatedEditor\""}});
}
if (!dojo._hasResource["dijit.form.SimpleTextarea"]) {
	dojo._hasResource["dijit.form.SimpleTextarea"] = true;
	dojo.provide("dijit.form.SimpleTextarea");
	dojo.declare("dijit.form.SimpleTextarea", dijit.form.TextBox, {baseClass:"dijitTextArea", attributeMap:dojo.delegate(dijit.form._FormValueWidget.prototype.attributeMap, {rows:"textbox", cols:"textbox"}), rows:"3", cols:"20", templateString:"<textarea ${nameAttrSetting} dojoAttachPoint='focusNode,containerNode,textbox' autocomplete='off'></textarea>", postMixInProperties:function () {
		if (!this.value && this.srcNodeRef) {
			this.value = this.srcNodeRef.value;
		}
		this.inherited(arguments);
	}, filter:function (value) {
		if (value) {
			value = value.replace(/\r/g, "");
		}
		return this.inherited(arguments);
	}, postCreate:function () {
		this.inherited(arguments);
		if (dojo.isIE && this.cols) {
			dojo.addClass(this.textbox, "dijitTextAreaCols");
		}
	}, _previousValue:"", _onInput:function (e) {
		if (this.maxLength) {
			var maxLength = parseInt(this.maxLength);
			var value = this.textbox.value.replace(/\r/g, "");
			var overflow = value.length - maxLength;
			if (overflow > 0) {
				if (e) {
					dojo.stopEvent(e);
				}
				var textarea = this.textbox;
				if (textarea.selectionStart) {
					var pos = textarea.selectionStart;
					var cr = 0;
					if (dojo.isOpera) {
						cr = (this.textbox.value.substring(0, pos).match(/\r/g) || []).length;
					}
					this.textbox.value = value.substring(0, pos - overflow - cr) + value.substring(pos - cr);
					textarea.setSelectionRange(pos - overflow, pos - overflow);
				} else {
					if (dojo.doc.selection) {
						textarea.focus();
						var range = dojo.doc.selection.createRange();
						range.moveStart("character", -overflow);
						range.text = "";
						range.select();
					}
				}
			}
			this._previousValue = this.textbox.value;
		}
		this.inherited(arguments);
	}});
}
if (!dojo._hasResource["wm.base.widget.Editors.Text"]) {
	dojo._hasResource["wm.base.widget.Editors.Text"] = true;
	dojo.provide("wm.base.widget.Editors.Text");
	dojo.declare("wm._TextEditor", wm._BaseEditor, {promptMessage:"", invalidMessage:"", password:false, maxChars:"", regExp:".*", _passwordChar:"&#8226;", tooltipDisplayTime:2000, getEditorProps:function (inNode, inProps) {
		var p = dojo.mixin(this.inherited(arguments), {promptMessage:this.promptMessage, invalidMessage:this.invalidMessage || "$_unset_$", regExp:this.regExp, value:this.owner.displayValue, required:this.required, tooltipDisplayTime:this.tooltipDisplayTime});
		if (this.password) {
			p.type = "password";
		}
		if (this.maxChars) {
			p.maxLength = this.maxChars;
		}
		return dojo.mixin(p, inProps || {});
	}, validationEnabled:function () {
		return (this.regExp && this.regExp != ".*") || this.required;
	}, setPassword:function (inPassword) {
		this.password = inPassword;
		this.createEditor();
	}, _createEditor:function (inNode, inProps) {
		if (this.singleLine) {
			if (this.validationEnabled() || this.promptMessage) {
				return new dijit.form.ValidationTextBox(this.getEditorProps(inNode, inProps));
			} else {
				return new dijit.form.TextBox(this.getEditorProps(inNode, inProps));
			}
		} else {
			return new dijit.form.SimpleTextarea(this.getEditorProps(inNode, inProps));
		}
	}, validator:function (inValue, inConstraints) {
		var l = Number(this.maxChars);
		return this.maxChars !== "" && !isNaN(l) ? inValue.length <= l : true;
	}, _getReadonlyValue:function () {
		var v = this.inherited(arguments);
		if (this.password) {
			for (var i = 0, a = [], l = v.length; i < l; i++) {
				a.push(this._passwordChar);
			}
			v = a.join("");
		}
		return v;
	}});
	dojo.declare("wm.ResizableEditor", wm.AbstractEditor, {maxHeight:96, getReadOnlyNodeLineHeight:function () {
		if (this.autoSizeHeight) {
			return "normal";
		} else {
			return this.inherited(arguments);
		}
	}, getReadOnlyNodeWhiteSpace:function () {
		if (this.autoSizeWidth) {
			return "nowrap";
		} else {
			if (this.autoSizeHeight) {
				return "normal";
			} else {
				return this.inherited(arguments);
			}
		}
	}, getReadOnlyNodeOverflow:function () {
		if (this.autoSizeHeight || this.autoSizeWidth) {
			return (this._autoSizeNeedsOverflow) ? "auto" : "hidden";
		} else {
			return "hidden";
		}
	}, updateReadonlyValue:function () {
		this.inherited(arguments);
		if (this.readonly && this.readOnlyNode && this.readOnlyNode.style.width && (this.autoSizeHeight || this.autoSizeWidth)) {
			this.doAutoSize(1, 1);
		}
	}, doAutoSize:function (setSize, force) {
		if (!this.readonly) {
			return;
		}
		if (this._doingAutoSize || !this.autoSizeHeight && !this.autoSizeWidth) {
			return;
		}
		if (!force && !this._needsAutoSize) {
			return;
		}
		if (this.isAncestorHidden()) {
			return;
		}
		this._doingAutoSize = true;
		this._needsAutoSize = false;
		var bases = this.readOnlyNode.style;
		var divObj = wm.Label.sizingNode;
		divObj.innerHTML = this.readOnlyNode.innerHTML;
		divObj.className = this.readOnlyNode.className;
		var s = divObj.style;
		s.position = "absolute";
		s.paddingLeft = (this.padBorderMargin.l + this.padBorderMargin.r) + "px";
		s.paddingTop = (this.padBorderMargin.t + this.padBorderMargin.b) + "px";
		s.lineHeight = bases.lineHeight;
		s.whiteSpace = bases.whiteSpace;
		this.domNode.appendChild(divObj);
		if (this.autoSizeHeight && !this._percEx.h) {
			s.height = "";
			s.width = bases.width;
			var readonlyHeight = divObj.clientHeight;
			var newHeight = readonlyHeight;
			if (this.caption) {
				if (this.captionPosition == "top" || this.captionPosition == "bottom") {
					newHeight += parseInt(this.captionNode.style.height) + wm.AbstractEditor.captionPaddingHeight;
				}
			}
			var minHeight = this.getMinHeightProp();
			if (minHeight > newHeight) {
				newHeight = minHeight;
			}
			if (this.maxHeight && this.maxHeight < newHeight) {
				newHeight = this.maxHeight;
				bases.overflow = "auto";
				this._autoSizeNeedsOverflow = true;
			} else {
				bases.overflow = "hidden";
				this._autoSizeNeedsOverflow = false;
			}
			if (setSize) {
				this.setHeight(newHeight + "px");
			} else {
				this.bounds.h = newHeight;
				this.height = newHeight + "px";
			}
		} else {
			if (this.autoSizeWidth && !this._percEx.w) {
				var maxWidth;
				if (this.parent.layoutKind == "left-to-right") {
					maxWidth = this.parent.layout.getMaxFreeSpace(this.parent.c$, "w", this.parent.bounds.w);
					maxWidth += this.bounds.w;
				} else {
					maxWidth = this.parent.getCurrentMaxWidth();
				}
				s.height = bases.height;
				s.width = "";
				var readonlyWidth = divObj.clientWidth;
				var newWidth = readonlyWidth;
				if (this.caption) {
					if (this.captionPosition == "left" || this.captionPosition == "right") {
						newWidth += parseInt(this.captionNode.style.width) + wm.AbstractEditor.captionPaddingWidth;
					}
				}
				if (newWidth > maxWidth) {
					newWidth = maxWidth;
					bases.overflow = "auto";
					this._autoSizeNeedsOverflow = true;
				} else {
					bases.overflow = "hidden";
					this._autoSizeNeedsOverflow = false;
				}
				var minWidth = this.getMinWidthProp();
				if (minWidth > newWidth) {
					newWidth = minWidth;
				}
				if (setSize) {
					this.setWidth(newWidth + "px");
				} else {
					this.bounds.w = newWidth;
					this.width = newWidth + "px";
				}
			}
		}
		divObj.parentNode.removeChild(divObj);
		this.disruptChromeOverflow("readOnlyNode");
		this.updateReadOnlyNodeStyle();
		this._doingAutoSize = false;
	}, setAutoSizeWidth:function (inValue) {
		if (inValue == "none") {
			wm.Control.prototype.setAutoSizeWidth.call(this, false);
			this.setAutoSizeHeight(false);
		} else {
			if (inValue == "width") {
				this.setAutoSizeHeight(false);
				wm.Control.prototype.setAutoSizeWidth.call(this, true);
			} else {
				if (inValue == "height") {
					wm.Control.prototype.setAutoSizeWidth.call(this, false);
					this.setAutoSizeHeight(true);
				}
			}
		}
		if (this.readOnlyNode && inValue == "none") {
			this.updateReadOnlyNodeStyle();
		}
	}, setMaxHeight:function (newMax) {
		if (this.isDesignLoaded()) {
			if (newMax < this.minHeight) {
				alert("Your maxHeight must be at least as large as your minHeight!");
				return;
			} else {
				if (newMax < this.getMinHeightProp()) {
					alert("Please select a minHeight for this editor that is at least " + this.getMinHeightProp() + " high");
					return;
				}
			}
		}
		this.inherited(arguments);
		if (!this.maxHeight && this.readOnlyNode) {
			this.readOnlyNode.style.overflow = "hidden";
		}
		if (this.readOnlyNode) {
			this.updateReadOnlyNodeStyle();
			this.doAutoSize(1, 1);
		}
	}, addUserClass:function (inClass, inNodeName) {
		this.inherited(arguments);
		if ((this.autoSizeHeight || this.autoSizeWidth) && this.isDesignLoaded()) {
			this.doAutoSize(1, 1);
		}
	}, makePropEdit:function (inName, inValue, inDefault) {
		switch (inName) {
		  case "autoSizeWidth":
			return makeSelectPropEdit(inName, (this.autoSizeHeight) ? "height" : (this.autoSizeWidth) ? "width" : "none", ["none", "width", "height"], inDefault);
		}
		return this.inherited(arguments);
	}});
	wm.Object.extendSchema(wm.ResizableEditor, {autoSizeHeight:{type:"Boolean", group:"advanced layout", order:31, writeonly:true, ignore:true}, autoSizeWidth:{type:"Boolean", group:"advanced layout", order:32, shortname:"Auto Size"}, maxHeight:{type:"Number", group:"advanced layout", order:60}});
	dojo.declare("wm.Text", wm.ResizableEditor, {changeOnKey:false, changeOnEnter:true, showMessages:true, promptMessage:"", invalidMessage:"", password:false, maxChars:"", regExp:".*", _passwordChar:"&#8226;", tooltipDisplayTime:2000, getEditorProps:function (inNode, inProps) {
		var p = dojo.mixin(this.inherited(arguments), {promptMessage:this.promptMessage, invalidMessage:this.invalidMessage || "$_unset_$", regExp:this.regExp, value:this.displayValue, required:this.required, tooltipDisplayTime:this.tooltipDisplayTime});
		if (this.password) {
			p.type = "password";
		}
		if (this.maxChars) {
			p.maxLength = this.maxChars;
		}
		return dojo.mixin(p, inProps || {});
	}, validationEnabled:function () {
		return (this.regExp && this.regExp != ".*") || this.required;
	}, setPassword:function (inPassword) {
		this.password = inPassword;
		this.createEditor();
		var pos = this.captionPosition;
		this.captionPosition = "";
		this.setCaptionPosition(pos);
	}, _createEditor:function (inNode, inProps) {
		if (this.validationEnabled() || this.promptMessage) {
			return new dijit.form.ValidationTextBox(this.getEditorProps(inNode, inProps));
		} else {
			return new dijit.form.TextBox(this.getEditorProps(inNode, inProps));
		}
	}, validator:function (inValue, inConstraints) {
		var l = Number(this.maxChars);
		return this.maxChars !== "" && !isNaN(l) ? inValue.length <= l : true;
	}, _getReadonlyValue:function () {
		var v = this.inherited(arguments);
		if (this.password) {
			for (var i = 0, a = [], l = v.length; i < l; i++) {
				a.push(this._passwordChar);
			}
			v = a.join("");
		}
		return v;
	}});
	dojo.declare("wm._TextAreaEditor", wm._TextEditor, {_createEditor:function (inNode, inProps) {
		return new dijit.form.SimpleTextarea(this.getEditorProps(inNode, inProps));
	}, sizeEditor:function () {
		this.inherited(arguments);
		this.domNode.style.height = "";
		this.domNode.style.lineHeight = "";
	}});
	dojo.declare("wm.LargeTextArea", wm.Text, {width:"300px", height:"96px", captionSize:"24px", captionPosition:"top", captionAlign:"left", singleLine:false, changeOnEnter:false, _createEditor:function (inNode, inProps) {
		return new dijit.form.SimpleTextarea(this.getEditorProps(inNode, inProps));
	}, validationEnabled:function () {
		return false;
	}, sizeEditor:function () {
		this.inherited(arguments);
	}, setSingleLine:function (inSingleLine) {
		this.inherited(arguments);
		this.captionNode.style.lineHeight = "normal";
	}, getReadOnlyNodeLineHeight:function () {
		return "normal";
	}, getReadOnlyNodeWhiteSpace:function () {
		if (this.autoSizeWidth) {
			return this.inherited(arguments);
		} else {
			return "normal";
		}
	}, getReadOnlyNodeOverflow:function () {
		if (this.autoSizeWidth || this.autoSizeHeight) {
			return this.inherited(arguments);
		} else {
			return "auto";
		}
	}, getMinHeightProp:function () {
		return this.minHeight || 80;
	}});
	dojo.declare("wm.ColorPicker", wm.Text, {className:"wmeditor wmcolorpickereditor", _editorBackgroundColor:true, colorPickerDialog:null, cancelValue:null, _empty:true, regExp:"#[0-9a-fA-F]{6}", showMessages:false, init:function () {
		this.inherited(arguments);
		this.subscribe("wm.AbstractEditor-focused", this, function (inEditor) {
			if (this != inEditor) {
				if (this.colorPickerDialog) {
					this.colorPickerDialog.dismiss();
				}
			}
		});
	}, postInit:function () {
		this.inherited(arguments);
		var v = this.getDataValue() || "#FFFFFF";
		this.setNodeColors(v);
	}, createColorPicker:function () {
		this.colorPickerDialog = new wm.ColorPickerDialog({owner:this});
		this.colorPickerDialog.connect(this.colorPickerDialog, "onChange", this, function (inValue) {
			if (this.colorPickerDialog.showing) {
				this.setDataValue(inValue);
			}
		});
		this.colorPickerDialog.connect(this.colorPickerDialog, "onCancel", this, function (inValue) {
			var val = this.getDataValue();
			if (val != this.cancelValue) {
				this.setDataValue(this.cancelValue);
				this.changed();
			}
			this.colorPickerDialog.dismiss();
		});
	}, onfocus:function () {
		if (!this.colorPickerDialog || !this.colorPickerDialog.showing) {
			var v = this.getDataValue() || "#FFFFFF";
			this.cancelValue = this.getDataValue();
			if (!this.colorPickerDialog) {
				this.createColorPicker();
			}
			this.colorPickerDialog.setValue(v);
			this.colorPickerDialog.setShowing(true);
		}
	}, setEditorValue:function (inValue) {
		this.inherited(arguments);
		this._empty = !Boolean(inValue);
		this.setNodeColors(inValue);
	}, setNodeColors:function (inValue) {
		if (inValue) {
			this.editorNode.style.backgroundColor = inValue;
			this.editorNode.style.color = (parseInt(inValue.substr(1, 2), 16) + parseInt(inValue.substr(3, 2), 16) + parseInt(inValue.substr(5, 2), 16) < 200) ? "white" : "black";
		} else {
			this.editorNode.style.backgroundColor = "transparent";
			this.editorNode.style.color = "black";
		}
	}, getDataValue:function () {
		if (this.getInvalid()) {
			return "#ffffff";
		}
		return this.inherited(arguments) || "#ffffff";
	}, onblur:function () {
		if (this.colorPickerDialog && this.getDataValue() && (this._empty || this.colorPickerDialog.getValue().toLowerCase() != this.getDataValue().toLowerCase() && this.colorPickerDialog._changed)) {
			this._empty = false;
			this.changed();
		}
	}, changed:function () {
		if (this.colorPickerDialog) {
			this.setNodeColors(this.getDataValue());
			return this.inherited(arguments);
		}
	}});
	wm.Object.extendSchema(wm._TextAreaEditor, {changeOnEnter:{ignore:1}, password:{ignore:1}});
	wm.Object.extendSchema(wm.Text, {promptMessage:{group:"Labeling", order:6}, tooltipDisplayTime:{group:"Labeling", order:7}, password:{group:"editor", order:5}, maxChars:{group:"editor", order:6}, changeOnKey:{group:"events", order:3}, regExp:{group:"validation", order:2}, invalidMessage:{group:"validation", order:3}, showMessages:{group:"validation", order:4}, onEnterKeyPress:{ignore:0}});
	wm.Object.extendSchema(wm.LargeTextArea, {changeOnEnter:{ignore:1}, onEnterKeyPress:{ignore:1}, password:{ignore:1}});
	wm.LargeTextArea.extend({themeableDemoProps:{height:"100%"}});
	wm.Object.extendSchema(wm.ColorPicker, {regExp:{ignore:true}});
}
if (!dojo._hasResource["wm.base.widget.Editors.Number"]) {
	dojo._hasResource["wm.base.widget.Editors.Number"] = true;
	dojo.provide("wm.base.widget.Editors.Number");
	dojo.declare("wm._NumberEditor", wm._TextEditor, {minimum:"", maximum:"", places:"", _messages:{rangeMin:"Minimum number must be less than the maximum setting of ${0}.", rangeMax:"Maximum number must be greater than the minimum setting of ${0}."}, rangeMessage:"", getEditorProps:function (inNode, inProps) {
		var constraints = {}, v = this.owner.displayValue;
		if (this.minimum) {
			constraints.min = Number(this.minimum);
		}
		if (this.maximum) {
			constraints.max = Number(this.maximum);
		}
		if (this.places) {
			var places = this._getPlaces();
			if (places && places != "") {
				constraints.places = places;
			}
		}
		constraints.pattern = this._getPattern();
		return dojo.mixin(this.inherited(arguments), {constraints:constraints, editPattern:constraints.pattern, rangeMessage:this.rangeMessage, required:this.required, value:v ? Number(v) : ""}, inProps || {});
	}, _getPlaces:function () {
		return "";
	}, _createEditor:function (inNode, inProps) {
		return new dijit.form.NumberTextBox(this.getEditorProps(inNode, inProps));
	}, _getPattern:function () {
		var p = this.places !== "" ? Number(this.places) : 20, n = "#", d = ".", pattern = [n];
		if (p) {
			pattern.push(d);
		}
		for (var i = 0; i < p; i++) {
			pattern.push(n);
		}
		return pattern.join("");
	}, setMaximum:function (inMax) {
		var v = Number(inMax);
		if (this.minimum === "" || this.minimum < v) {
			this.maximum = v;
			if (this.editor) {
				this.editor.constraints.max = v;
			}
		} else {
			if (this.isDesignLoaded()) {
				alert(dojo.string.substitute(this._messages.rangeMax, [this.minimum]));
			}
		}
	}, setMinimum:function (inMin) {
		var v = Number(inMin);
		if (this.maximum === "" || v < this.maximum) {
			this.minimum = v;
			if (this.editor) {
				this.editor.constraints.min = v;
			}
		} else {
			if (this.isDesignLoaded()) {
				alert(dojo.string.substitute(this._messages.rangeMin, [this.maximum]));
			}
		}
	}, _getReadonlyValue:function () {
		return dojo.number.format(this.owner.dataValue, this.getFormatProps());
	}, getFormatProps:function () {
		var formatProps = {};
		if (this.places && this.places != "") {
			formatProps.places = Number(this.places);
		}
		return formatProps;
	}});
	dojo.declare("wm._CurrencyEditor", wm._NumberEditor, {currency:"USD", getEditorProps:function (inNode, inProps) {
		var prop = this.inherited(arguments);
		if (prop.constraints) {
			delete prop.constraints.pattern;
		}
		return dojo.mixin(prop, {currency:this.currency}, inProps || {});
	}, _createEditor:function (inNode, inProps) {
		return new dijit.form.CurrencyTextBox(this.getEditorProps(inNode, inProps));
	}, _getReadonlyValue:function () {
		return dojo.currency.format(this.owner.dataValue, {currency:this.currency, places:this.places});
	}, _getPlaces:function () {
		return this.places;
	}});
	dojo.declare("wm._SliderEditor", wm._BaseEditor, {minimum:0, maximum:100, showButtons:true, discreteValues:"", verticalSlider:false, reflow:function () {
	}, setVerticalSlider:function (inVerticalSlider) {
		this.verticalSlider = inVerticalSlider;
		if (this.editor) {
			this.createEditor();
		}
	}, getEditorProps:function (inNode, inProps) {
		var v = this.owner.displayValue;
		var minV = Number(this.minimum) ? Number(this.minimum) : 0;
		if (!v || (Number(v) < minV)) {
			v = this.owner.displayValue = minV;
		}
		return dojo.mixin(this.inherited(arguments), {minimum:Number(this.minimum), maximum:Number(this.maximum), showButtons:Boolean(this.showButtons), discreteValues:Number(this.discreteValues) || Infinity, value:v}, inProps || {});
	}, _createEditor:function (inNode, inProps) {
		if (this.verticalSlider) {
			return new dijit.form.VerticalSlider(this.getEditorProps(inNode, inProps));
		} else {
			return new dijit.form.HorizontalSlider(this.getEditorProps(inNode, inProps));
		}
	}, sizeEditor:function () {
		if (this._cupdating) {
			return;
		}
		var e = this.editor;
		if (e) {
			var bounds = this.getContentBounds(), height = bounds.h ? bounds.h - 2 + "px" : "", width = bounds.w ? bounds.w - 4 + "px" : "", d = e && e.domNode, s = d.style, fc = d && d.firstChild;
			if (!this.editorBorder) {
				s.border = 0;
			}
			s.backgroundColor = this.editorBorder ? "" : "transparent";
			s.backgroundImage = this.editorBorder ? "" : "none";
			s.width = width;
			s.height = height;
			if (this.verticalSlider) {
				this.editor.incrementButton.style.width = "auto";
				this.editor.decrementButton.style.width = "auto";
			}
		}
	}});
	dojo.declare("wm.Number", wm.Text, {minimum:"", maximum:"", places:"", _messages:{rangeMin:"Minimum number must be less than the maximum setting of ${0}.", rangeMax:"Maximum number must be greater than the minimum setting of ${0}."}, rangeMessage:"", validationEnabled:function () {
		return true;
	}, getEditorProps:function (inNode, inProps) {
		var constraints = {}, v = this.displayValue;
		if (this.minimum) {
			constraints.min = Number(this.minimum);
		}
		if (this.maximum) {
			constraints.max = Number(this.maximum);
		}
		if (this.places) {
			var places = this._getPlaces();
			if (places && places != "") {
				constraints.places = places;
			}
		}
		constraints.pattern = this._getPattern();
		return dojo.mixin(this.inherited(arguments), {constraints:constraints, editPattern:constraints.pattern, rangeMessage:this.rangeMessage, required:this.required, value:v ? Number(v) : ""}, inProps || {});
	}, _getPlaces:function () {
		return "";
	}, _createEditor:function (inNode, inProps) {
		return new dijit.form.NumberTextBox(this.getEditorProps(inNode, inProps));
	}, _getPattern:function () {
		var p = this.places !== "" ? Number(this.places) : 20, n = "#", d = ".", pattern = [n];
		if (p) {
			pattern.push(d);
		}
		for (var i = 0; i < p; i++) {
			pattern.push(n);
		}
		return pattern.join("");
	}, setMaximum:function (inMax) {
		var v = (inMax === "") ? "" : Number(inMax);
		if (this.minimum === "" || this.minimum < v || v === "") {
			this.maximum = v;
			if (this.editor) {
				this.editor.constraints.max = v;
				this.editor.validate();
			}
		} else {
			if (this.isDesignLoaded()) {
				alert(dojo.string.substitute(this._messages.rangeMax, [this.minimum]));
			}
		}
	}, setMinimum:function (inMin) {
		var v = (inMin === "") ? "" : Number(inMin);
		if (this.maximum === "" || v < this.maximum || v === "") {
			this.minimum = v;
			if (this.editor) {
				this.editor.constraints.min = v;
				this.editor.validate();
			}
		} else {
			if (this.isDesignLoaded()) {
				alert(dojo.string.substitute(this._messages.rangeMin, [this.maximum]));
			}
		}
	}, _getReadonlyValue:function () {
		return dojo.number.format(this.dataValue, this.getFormatProps());
	}, getFormatProps:function () {
		var formatProps = {};
		if (this.places && this.places != "") {
			formatProps.places = Number(this.places);
		}
		return formatProps;
	}});
	wm.Object.extendSchema(wm.Number, {places:{group:"editor", order:2}, minimum:{group:"editor", order:3, emptyOK:true}, maximum:{group:"editor", order:4, emptyOK:true}, rangeMessage:{group:"editor", order:5}, regExp:{ignore:1}, maxChars:{ignore:1}});
	dojo.declare("wm.Currency", wm.Number, {currency:"USD", getEditorProps:function (inNode, inProps) {
		var prop = this.inherited(arguments);
		if (prop.constraints) {
			delete prop.constraints.pattern;
		}
		return dojo.mixin(prop, {currency:this.currency}, inProps || {});
	}, _createEditor:function (inNode, inProps) {
		return new dijit.form.CurrencyTextBox(this.getEditorProps(inNode, inProps));
	}, _getReadonlyValue:function () {
		return dojo.currency.format(this.dataValue, {currency:this.currency, places:this.places});
	}, _getPlaces:function () {
		return this.places;
	}});
	wm.Object.extendSchema(wm.Currency, {password:{ignore:1}, currency:{group:"editor", order:2}, minimum:{group:"editor", order:3, emptyOK:true}, maximum:{group:"editor", order:4, emptyOK:true}, places:{group:"editor", order:5}, rangeMessage:{group:"editor", order:6}});
	dojo.declare("wm.Slider", wm.AbstractEditor, {minimum:0, maximum:100, showButtons:true, discreteValues:"", verticalSlider:false, editorBorder:false, reflow:function () {
	}, setVerticalSlider:function (inVerticalSlider) {
		this.verticalSlider = inVerticalSlider;
		if (this.editor) {
			this.createEditor();
		}
		if (this.verticalSlider) {
			this.editor.incrementButton.style.width = "auto";
			this.editor.decrementButton.style.width = "auto";
		}
	}, getEditorProps:function (inNode, inProps) {
		var v = this.displayValue;
		var minV = Number(this.minimum) ? Number(this.minimum) : 0;
		if (!v || (Number(v) < minV)) {
			v = this.displayValue = minV;
		}
		return dojo.mixin(this.inherited(arguments), {minimum:Number(this.minimum), maximum:Number(this.maximum), showButtons:Boolean(this.showButtons), discreteValues:Number(this.discreteValues) || Infinity, value:v}, inProps || {});
	}, _createEditor:function (inNode, inProps) {
		var div = dojo.create("div");
		var dijitObj;
		if (this.verticalSlider) {
			dijitObj = new dijit.form.VerticalSlider(this.getEditorProps(inNode, inProps));
		} else {
			dijitObj = new dijit.form.HorizontalSlider(this.getEditorProps(inNode, inProps));
		}
		div.appendChild(dijitObj.domNode);
		dijitObj.domNode = div;
		return dijitObj;
	}, sizeEditor:function () {
		if (this._cupdating) {
			return;
		}
		this.inherited(arguments);
		this.editor._setStyleAttr("height: " + this.editor.domNode.style.height + ";width:" + this.editor.domNode.style.width);
	}});
	wm.Object.extendSchema(wm.Slider, {discreteValues:{group:"editor", order:2}, minimum:{group:"editor", order:3}, maximum:{group:"editor", order:4}, showButtons:{group:"editor", order:5}, verticalSlider:{group:"editor", order:6, ignore:1}, editorBorder:{ignore:1}, changeOnKey:{ignore:1}, changeOnEnter:{ignore:1}});
	wm.Object.extendSchema(wm._NumberEditor, {regExp:{ignore:1}, maxChars:{ignore:1}});
	wm.Object.extendSchema(wm._SliderEditor, {changeOnKey:{ignore:1}, changeOnEnter:{ignore:1}});
}
if (!dojo._hasResource["wm.base.widget.Editors.Date"]) {
	dojo._hasResource["wm.base.widget.Editors.Date"] = true;
	dojo.provide("wm.base.widget.Editors.Date");
	dojo.declare("wm.Date", wm.Text, {promptMessage:"", invalidMessage:"", minimum:"", maximum:"", format:"", getEditorProps:function (inNode, inProps) {
		var constraints = {};
		if (this.minimum) {
			constraints.min = this.convertValue(this.minimum);
		}
		if (this.maximum) {
			constraints.max = this.convertValue(this.maximum);
		}
		var prop = dojo.mixin(this.inherited(arguments), {promptMessage:this.promptMessage, invalidMessage:this.invalidMessage || "$_unset_$", constraints:constraints, required:this.required, value:this.convertValue(this.displayValue)}, inProps || {});
		if (this.format != "") {
			prop.lang = this.format;
		}
		return prop;
	}, _createEditor:function (inNode, inProps) {
		return new dijit.form.DateTextBox(this.getEditorProps(inNode, inProps));
	}, convertValue:function (inValue) {
		return wm.convertValueToDate(inValue);
	}, getEditorValue:function () {
		var d = this.inherited(arguments);
		return d && d.getTime() || this.makeEmptyValue();
	}, setEditorValue:function (inValue) {
		this.inherited(arguments, [this.convertValue(inValue)]);
	}});
	dojo.declare("wm.Time", wm.Date, {timePattern:"HH:mm a", getEditorProps:function (inNode, inProps) {
		var prop = dojo.mixin(this.inherited(arguments), {constraints:{timePattern:this.timePattern}}, inProps || {});
		return prop;
	}, convertValue:function (inValue) {
		return wm.convertValueToDate(inValue, {selector:"time"});
	}, _createEditor:function (inNode, inProps) {
		return new dijit.form.TimeTextBox(this.getEditorProps(inNode, inProps));
	}, makePropEdit:function (inName, inValue, inDefault) {
		switch (inName) {
		  case "timePattern":
			return makeSelectPropEdit(inName, inValue, ["HH:mm", "HH:mm:ss", "HH:mm a", "HH:mm:ss a"], inDefault);
		}
		return this.inherited(arguments);
	}});
	dojo.declare("wm._DateEditor", wm._BaseEditor, {promptMessage:"", invalidMessage:"", minimum:"", maximum:"", format:"", dateEditorType:"DateTextBox", getEditorProps:function (inNode, inProps) {
		var constraints = {};
		if (this.minimum) {
			constraints.min = this.convertValue(this.minimum);
		}
		if (this.maximum) {
			constraints.max = this.convertValue(this.maximum);
		}
		var prop = dojo.mixin(this.inherited(arguments), {promptMessage:this.promptMessage, invalidMessage:this.invalidMessage || "$_unset_$", constraints:constraints, required:this.required, value:this.convertValue(this.owner.displayValue)}, inProps || {});
		if (this.format != "") {
			prop.lang = this.format;
		}
		return prop;
	}, _createEditor:function (inNode, inProps) {
		if (this.dateEditorType == "DualCalendar") {
			dojo["require"]("wm.base.components.DualCalendar");
			return new wm.DualCalendar(this.getEditorProps(inNode, inProps));
		} else {
			if (this.dateEditorType == "IslamicDateTextbox") {
				dojo["require"]("wm.base.components.IslamicDateTextbox");
				return new wm.IslamicDateTextbox(this.getEditorProps(inNode, inProps));
			} else {
				return new dijit.form.DateTextBox(this.getEditorProps(inNode, inProps));
			}
		}
	}, convertValue:function (inValue) {
		return wm.convertValueToDate(inValue);
	}, getEditorValue:function () {
		var d = this.inherited(arguments);
		return d && d.getTime() || this.makeEmptyValue();
	}, setEditorValue:function (inValue) {
		this.inherited(arguments, [this.convertValue(inValue)]);
	}});
	dojo.declare("wm._TimeEditor", wm._DateEditor, {timePattern:"HH:mm a", getEditorProps:function (inNode, inProps) {
		var prop = dojo.mixin(this.inherited(arguments), {constraints:{timePattern:this.timePattern}}, inProps || {});
		return prop;
	}, convertValue:function (inValue) {
		return wm.convertValueToDate(inValue, {selector:"time"});
	}, _createEditor:function (inNode, inProps) {
		return new dijit.form.TimeTextBox(this.getEditorProps(inNode, inProps));
	}, makePropEdit:function (inName, inValue, inDefault) {
		switch (inName) {
		  case "timePattern":
			return makeSelectPropEdit(inName, inValue, ["HH:mm", "HH:mm:ss", "HH:mm a", "HH:mm:ss a"], inDefault);
		}
		return this.inherited(arguments);
	}});
	wm.Object.extendSchema(wm._DateEditor, {changeOnKey:{ignore:1}});
	wm.Object.extendSchema(wm._TimeEditor, {format:{ignore:1}});
	wm.Object.extendSchema(wm.Date, {changeOnKey:{ignore:1}, minimum:{group:"editor", order:2}, maximum:{group:"editor", order:3}, format:{group:"editor", order:4}, invalidMessage:{group:"validation", order:3}, showMessages:{group:"validation", order:4}, promptMessage:{group:"Labeling", order:6}, password:{ignore:1}, regExp:{ignore:1}, maxChars:{ignore:1}, changeOnKey:{ignore:1}});
	wm.Object.extendSchema(wm.Time, {format:{ignore:1}, minimum:{group:"editor", order:2, ignore:1}, maximum:{group:"editor", order:3, ignore:1}, timePattern:{group:"editor", order:4}, invalidMessage:{group:"validation", order:3}, showMessages:{group:"validation", order:4}, promptMessage:{group:"Labeling", order:6}, password:{ignore:1}, regExp:{ignore:1}, maxChars:{ignore:1}, changeOnKey:{ignore:1}});
}
if (!dojo._hasResource["wm.base.widget.Editors.Checkbox"]) {
	dojo._hasResource["wm.base.widget.Editors.Checkbox"] = true;
	dojo.provide("wm.base.widget.Editors.Checkbox");
	dojo.declare("wm._CheckBoxEditor", wm._BaseEditor, {dataType:"string", startChecked:false, _hasReadonlyValue:false, _createEditor:function (inNode, inProps) {
		return new dijit.form.CheckBox(this.getEditorProps(inNode, inProps));
	}, setRequired:function () {
	}, connectEditor:function () {
		this.inherited(arguments);
		if (this.owner.captionLabel) {
			this.addEditorConnect(this.owner.captionLabel, "onclick", this, "captionClicked");
		}
	}, styleEditor:function () {
		this.inherited(arguments);
		dojo.addClass(this.editor.domNode.parentNode, "wmeditor-cbeditor");
		var n = this.owner.captionLabel.domNode;
		if (n) {
			n.style.cursor = "pointer";
			dojo.setSelectable(n, false);
		}
	}, sizeEditor:function () {
		this.editor.domNode.style.width = "16px";
	}, renderBounds:function () {
		this.inherited(arguments);
		this.domNode.style.textAlign = (this.owner.captionPosition == "right") ? "right" : "";
	}, setInitialValue:function () {
		this.owner.beginEditUpdate();
		if (this.startChecked) {
			this.setChecked(true);
		}
		this.owner.endEditUpdate();
	}, getChecked:function () {
		return Boolean(this.editor.checked);
	}, setChecked:function (inChecked) {
		this.editor.attr("checked", inChecked);
	}, captionClicked:function () {
		if (!this.owner.readonly && !this.owner.disabled) {
			this.setChecked(!this.getChecked());
		}
	}, getDisplayValue:function () {
		return this.getTypedValue(this.owner.displayValue);
	}, setDisplayValue:function (inValue) {
	}, getEditorValue:function () {
		var c = this.editor && this.editor.checked, v = this.getDisplayValue();
		if (v === undefined) {
			v = this.getTypedValue(1);
		}
		return c ? v : this.makeEmptyValue();
	}, getTypedValue:function (inValue) {
		var v = inValue;
		switch (this.dataType) {
		  case "string":
			v = v || v === 0 ? v : "";
			return String(v);
		  case "number":
			var n = Number(v);
			return isNaN(n) ? Number(Boolean(v)) : n;
		  default:
			return Boolean(v);
		}
	}, setEditorValue:function (inValue) {
		if (inValue == null) {
			inValue = this.startChecked;
		}
		if (this.editor) {
			var t = (inValue === this.getDisplayValue()), f = (inValue === this.makeEmptyValue());
			this._hasReadonlyValue = t || f;
			this.editor.attr("checked", t);
			this.updateReadonlyValue();
		}
	}, _getReadonlyValue:function () {
		var v = this._hasReadonlyValue ? this.getEditorValue() : "";
		return wm.capitalize(String(v));
	}, setReadonlyValue:function () {
		if (!this.domNode) {
			return;
		}
		var v = this._hasReadonlyValue ? this.getEditorValue() : "";
		var tempCheckbox = new dijit.form.CheckBox({}, dojo.doc.createElement("div"));
		tempCheckbox.attr("checked", v);
		tempCheckbox.attr("disabled", true);
		while (this.domNode.childNodes.length > 0) {
			this.domNode.removeChild(this.domNode.childNodes[0]);
		}
		this.domNode.appendChild(tempCheckbox.domNode);
	}, setStartChecked:function (inChecked) {
		this.startChecked = inChecked;
		this.createEditor();
	}, setDataType:function (inDataType) {
		this.dataType = inDataType;
		if (inDataType == "boolean") {
			this.owner.displayValue = true;
		}
	}});
	dojo.declare("wm.Checkbox", wm.AbstractEditor, {width:"120px", dataType:"string", startChecked:false, checkedValue:1, _createEditor:function (inNode, inProps) {
		return new dijit.form.CheckBox(this.getEditorProps(inNode, inProps));
	}, setRequired:function () {
	}, connectEditor:function () {
		this.inherited(arguments);
		if (this.captionNode) {
			this.addEditorConnect(this.captionNode, "onclick", this, "captionClicked");
		}
	}, sizeEditor:function () {
		this.inherited(arguments);
		var node = this.editorNode;
		node.style.width = "16px";
		node.style.height = "16px";
	}, styleEditor:function () {
		this.inherited(arguments);
		dojo.addClass(this.editor.domNode.parentNode, "wmeditor-cbeditor");
		var n = this.captionNode;
		if (n) {
			n.style.cursor = "pointer";
			dojo.setSelectable(n, false);
		}
	}, render:function () {
		this.inherited(arguments);
		this.domNode.style.textAlign = (this.captionPosition == "right") ? "right" : "";
	}, setInitialValue:function () {
		this.beginEditUpdate();
		if (this.startChecked) {
			this.setChecked(true);
		}
		this.endEditUpdate();
	}, getChecked:function () {
		return Boolean(this.editor.checked);
	}, setChecked:function (inChecked) {
		this.editor.attr("checked", inChecked);
	}, captionClicked:function () {
		if (!this.readonly && !this.disabled && !this.isDesignLoaded()) {
			this.setChecked(!this.getChecked());
		}
	}, getDisplayValue:function () {
		return this.getTypedValue(this.displayValue);
	}, setDisplayValue:function (inValue) {
	}, getEditorValue:function () {
		var c = this.editor && this.editor.checked;
		var v = this.checkedValue;
		if (v === undefined) {
			v = this.getTypedValue(1);
		}
		return c ? v : this.makeEmptyValue();
	}, getTypedValue:function (inValue) {
		var v = inValue;
		switch (this.dataType) {
		  case "string":
			v = v || v === 0 ? v : "";
			return String(v);
		  case "number":
			var n = Number(v);
			return isNaN(n) ? Number(Boolean(v)) : n;
		  default:
			return Boolean(v);
		}
	}, setEditorValue:function (inValue) {
		if (inValue == null) {
			inValue = this.startChecked;
		}
		if (this.editor) {
			this.editor.attr("checked", Boolean(inValue));
		}
	}, updateReadonlyValue:function () {
	}, setStartChecked:function (inChecked) {
		this.startChecked = inChecked;
		this.createEditor();
	}, setDataType:function (inDataType) {
		this.dataType = inDataType;
		if (inDataType == "boolean") {
			this.displayValue = true;
		}
	}, setDisabled:function (inDisabled) {
		this.inherited(arguments);
		if (!this.editor) {
			return;
		}
		if (this.readonly) {
			this.editor.attr("disabled", true);
		}
	}, setReadonly:function (inReadonly) {
		this.readonly = inReadonly;
		if (!this.editor) {
			return;
		}
		if (!this.readOnlyNode) {
			this.readOnlyNode = this.editor;
		}
		if (inReadonly || !this.disabled) {
			this.editor.attr("disabled", inReadonly);
		}
	}});
	wm._CheckBoxEditor.extend({makePropEdit:function (inName, inValue, inDefault) {
		switch (inName) {
		  case "dataType":
			return makeSelectPropEdit(inName, inValue, ["string", "boolean", "number"], inDefault);
		}
		return this.inherited(arguments);
	}});
	wm.Object.extendSchema(wm._CheckBoxEditor, {changeOnKey:{ignore:1}, changeOnEnter:{ignore:1}, startChecked:{bindable:1, type:"Boolean"}, displayValue:{isOwnerProperty:1, ignore:1, writeonly:1, type:"any"}, checkedValue:{isOwnerProperty:1, readonly:1, bindable:1, group:"edit", order:40, type:"any"}, required:{ignore:1}});
	wm.Object.extendSchema(wm.Checkbox, {readOnlyCheckbox:{ignore:1}, startChecked:{group:"editor", bindable:1, type:"Boolean"}, dataType:{group:"editData"}, displayValue:{ignore:1, writeonly:1, type:"any"}, checkedValue:{group:"editor", bindable:1, order:40, type:"any"}, required:{ignore:1}});
	wm.Checkbox.extend({makePropEdit:function (inName, inValue, inDefault) {
		switch (inName) {
		  case "dataType":
			return makeSelectPropEdit(inName, inValue, ["string", "boolean", "number"], inDefault);
		}
		return this.inherited(arguments);
	}});
}
if (!dojo._hasResource["wm.base.widget.Editors.Radiobutton"]) {
	dojo._hasResource["wm.base.widget.Editors.Radiobutton"] = true;
	dojo.provide("wm.base.widget.Editors.Radiobutton");
	dojo.declare("wm._RadioButtonEditor", wm._CheckBoxEditor, {radioGroup:"", _createEditor:function (inNode, inProps) {
		return new dijit.form.RadioButton(this.getEditorProps(inNode, inProps));
	}, getEditorProps:function (inNode, inProps) {
		return dojo.mixin(this.inherited(arguments), {name:this.radioGroup}, inProps || {});
	}, captionClicked:function () {
		if (!this.owner.readonly && !this.owner.disabled) {
			this.setChecked(true);
		}
	}, setEditorValue:function () {
		this.inherited(arguments);
		this.updateGroupValue();
	}, setRadioGroup:function (inGroup) {
		this.radioGroup = inGroup ? wm.getValidJsName(inGroup) : "";
		var group = this.getGroup();
		if (group.length) {
			this.dataType = group[0].owner.dataType;
		}
		this.createEditor();
		wm.fire(studio.inspector, "reinspect");
	}, getGroup:function () {
		var groupList = [];
		var nList = dojo.query("[name=" + this.radioGroup + "]");
		nList.forEach(function (DOMNode, index, nodeList) {
			groupList[index] = dijit.getEnclosingWidget(DOMNode);
		});
		return groupList;
	}, updateGroupValue:function () {
		var group = this.getGroup(), gv = this.getGroupValue();
		for (var i = 0, v, o; (v = group[i]); i++) {
			o = (v.owner || 0).owner;
			if (o) {
				o.groupValue = gv;
				o.valueChanged("groupValue", gv);
			}
		}
	}, setGroupValue:function (inValue) {
		var group = this.getGroup();
		for (var i = 0, v; (v = group[i]); i++) {
			if (v.owner.getDisplayValue() === inValue) {
				if (!v.checked) {
					v.owner.setChecked(true);
				}
				return;
			}
		}
		for (var i = 0, v; (v = group[i]); i++) {
			if (v.checked) {
				v.owner.setChecked(false);
				return;
			}
		}
	}, getGroupValue:function () {
		var group = this.getGroup();
		for (var i = 0, v; (v = group[i]); i++) {
			if (v.checked) {
				return v.owner.getEditorValue();
			}
		}
		for (var i = 0, v; (v = group[i]); i++) {
			return v.owner.makeEmptyValue();
		}
	}, isLoading:function () {
		var l = this.inherited(arguments);
		if (!l) {
			var group = this.getGroup();
			for (var i = 0, v, gl; (v = group[i]); i++) {
				gl = v.owner.owner._rendering;
				if (gl) {
					return true;
				}
			}
		}
		return l;
	}, setDataType:function (inType) {
		var group = this.getGroup();
		for (var i = 0, v; (v = group[i]); i++) {
			v.owner.dataType = inType;
		}
	}, setStartChecked:function (inChecked) {
		if (inChecked) {
			var group = this.getGroup();
			for (var i = 0, v, r; (v = group[i]); i++) {
				if (v.owner != this) {
					v.owner.setStartChecked(false);
				}
			}
		}
		this.inherited(arguments);
	}, ownerEditorChanged:function () {
		this.updateGroupValue();
	}});
	dojo.declare("wm.RadioButton", wm.Checkbox, {radioGroup:"", _createEditor:function (inNode, inProps) {
		return new dijit.form.RadioButton(this.getEditorProps(inNode, inProps));
	}, getEditorProps:function (inNode, inProps) {
		return dojo.mixin(this.inherited(arguments), {name:this.radioGroup}, inProps || {});
	}, captionClicked:function () {
		if (!this.readonly && !this.disabled) {
			this.setChecked(true);
		}
	}, setEditorValue:function () {
		this.inherited(arguments);
		this.updateGroupValue();
	}, setRadioGroup:function (inGroup) {
		this.radioGroup = inGroup ? wm.getValidJsName(inGroup) : "";
		var group = this.getGroup();
		if (group.length) {
			this.dataType = group[0].dataType;
		}
		this.createEditor();
		wm.fire(studio.inspector, "reinspect");
	}, getGroup:function () {
		var groupList = [];
		var nList = dojo.query("[name=" + this.radioGroup + "]");
		nList.forEach(function (DOMNode, index, nodeList) {
			groupList[index] = dijit.getEnclosingWidget(DOMNode);
		});
		return groupList;
	}, updateGroupValue:function () {
		var group = this.getGroup(), gv = this.getGroupValue();
		for (var i = 0, v, o; (v = group[i]); i++) {
			if (v) {
				o = v.owner;
				if (o) {
					o.groupValue = gv;
					console.log(o.toString() + " has group value " + gv);
					o.valueChanged("groupValue", gv);
				}
			}
		}
	}, setGroupValue:function (inValue) {
		var group = this.getGroup();
		for (var i = 0, v; (v = group[i]); i++) {
			if (v.getDisplayValue() === inValue) {
				if (!v.checked) {
					v.setChecked(true);
				}
				return;
			}
		}
		for (var i = 0, v; (v = group[i]); i++) {
			if (v.checked) {
				v.setChecked(false);
				return;
			}
		}
	}, getGroupValue:function () {
		var group = this.getGroup();
		for (var i = 0, v; (v = group[i]); i++) {
			if (v.checked) {
				return v.owner.getEditorValue();
			}
		}
		for (var i = 0, v; (v = group[i]); i++) {
			return v.owner.makeEmptyValue();
		}
	}, isLoading:function () {
		var l = this.inherited(arguments);
		if (!l) {
			var group = this.getGroup();
			for (var i = 0, v, gl; (v = group[i]); i++) {
				gl = v.owner._rendering;
				if (gl) {
					return true;
				}
			}
		}
		return l;
	}, setDataType:function (inType) {
		var group = this.getGroup();
		for (var i = 0, v; (v = group[i]); i++) {
			v.dataType = inType;
		}
	}, setStartChecked:function (inChecked) {
		if (inChecked) {
			var group = this.getGroup();
			for (var i = 0, v, r; (v = group[i]); i++) {
				if (v != this) {
					v.setStartChecked(false);
				}
			}
		}
		this.inherited(arguments);
	}, editorChanged:function () {
		this.inherited(arguments);
		this.updateGroupValue();
	}});
	wm.Object.extendSchema(wm._RadioButtonEditor, {groupValue:{isOwnerProperty:1, ignore:1, bindable:1, type:"any", group:"edit", order:50}});
	wm.Object.extendSchema(wm.RadioButton, {checkedValue:{group:"editor", bindable:1, order:40, type:"any"}, groupValue:{ignore:1, bindSource:1, type:"any"}, radioGroup:{type:"string", group:"editor", order:50}});
}
if (!dojo._hasResource["wm.base.widget.Editors.Select"]) {
	dojo._hasResource["wm.base.widget.Editors.Select"] = true;
	dojo.provide("wm.base.widget.Editors.Select");
	dojo.declare("wm.SelectMenu", wm.AbstractEditor, {_storeNameField:"_selectMenuName", options:"", displayField:"", dataField:"", displayExpression:"", pageSize:20, allowNone:false, autoComplete:true, startUpdate:false, hasDownArrow:true, binding:"(data binding)", restrictValues:true, _allFields:"All Fields", init:function () {
		this.inherited(arguments);
		this.selectedItem = new wm.Variable({name:"selectedItem", owner:this});
	}, postInit:function () {
		if (this.options) {
			this.setOptionsVariable();
		}
		this.inherited(arguments);
		if (this.startUpdate) {
			this.update();
		}
	}, update:function () {
		if (this.dataSet instanceof wm.ServiceVariable) {
			var d = this.dataSet.update();
			return d;
		}
	}, generateStore:function () {
		this._initDataProps();
		var d = this._getData();
		return new wm.base.data.SimpleStore(d, this._storeNameField, this);
	}, getEditorProps:function (inNode, inProps) {
		var store = this.generateStore();
		return dojo.mixin(this.inherited(arguments), {required:this.required, store:store, autoComplete:this.autoComplete, hasDownArrow:this.hasDownArrow, searchAttr:this._storeNameField, pageSize:this.pageSize ? this.pageSize : Infinity}, inProps || {});
	}, _createEditor:function (inNode, inProps) {
		if (this.restrictValues) {
			return new dijit.form.FilteringSelect(this.getEditorProps(inNode, inProps));
		} else {
			return new dijit.form.ComboBox(this.getEditorProps(inNode, inProps));
		}
	}, setRestrictValues:function (inValue) {
		var dataval = this.getEditorValue();
		var oldval = this.restrictValues;
		this.restrictValues = inValue;
		if (this.editor && oldval != inValue) {
			this.createEditor();
			this.setEditorValue(dataval);
		}
	}, sizeEditor:function () {
		if (this._cupdating) {
			return;
		}
		this.inherited(arguments);
		if (!this.editorNode.style.height) {
			return;
		}
		var h = this.editorNode.style.height.match(/\d+/)[0];
		this.editorNode.style.lineHeight = "";
		var arrowNode = dojo.query(".dijitArrowButtonInner", this.domNode)[0];
		if (arrowNode) {
			arrowNode.style.height = (h - 2) + "px";
		}
	}, hasValues:function () {
		return (this.editor && this.editor.store.getCount());
	}, getStoreItem:function (inValue, inStoreField) {
		if (!this.hasValues()) {
			return;
		}
		var result;
		var onItem = function (item) {
			result = item;
		};
		var query = {};
		query[inStoreField] = inValue;
		this.editor.store.fetch({query:query, queryOptions:{exactMatch:true}, count:1, onItem:onItem});
		return result;
	}, setInitialValue:function () {
		this.beginEditUpdate();
		this.selectedItem.setType(this.dataSet instanceof wm.Variable ? this.dataSet.type : "AnyData");
		var dataValue = this.dataValue;
		var displayValue = this.displayValue;
		if (wm.propertyIsChanged(dataValue, "dataValue", wm._BaseEditor)) {
			this.setEditorValue(dataValue);
		} else {
			this.setDisplayValue(displayValue);
		}
		this.endEditUpdate();
	}, setDisplayValue:function (inValue) {
		var i = this.getStoreItem(inValue, this._storeNameField);
		if (i !== undefined) {
			this._setEditorValue(this.editor.store.getValue(i, this._storeNameField));
		} else {
			if (!this.restrictValues) {
				this.editor.attr("value", inValue);
			} else {
				this.clear();
			}
		}
	}, setEditorValue:function (inValue) {
		var lookupFieldName = this._dataField;
		var i;
		if (inValue !== null && dojo.isObject(inValue)) {
			if (wm.isInstanceType(inValue, wm.Variable)) {
				if (this.isAllDataFields()) {
					var v = this._getDisplayData(inValue);
					i = this.getStoreItem(v, this._displayField);
				} else {
					var v = inValue;
					var lookupVal = v.getValue(lookupFieldName);
					i = this.getStoreItem(lookupVal, lookupFieldName);
					if (!i && !this.restrictValues) {
						i = lookupVal || inValue;
					}
				}
			} else {
				i = inValue;
			}
		} else {
			i = this.getStoreItem(inValue, lookupFieldName);
			if (!i && !this.restrictValues) {
				i = inValue;
			}
		}
		if (i !== undefined && i !== null && dojo.isObject(i)) {
			this._setEditorValue(i[this.displayField || this._displayField]);
		} else {
			if (this.restrictValues) {
				this.clear();
			} else {
				this.editor.attr("value", i);
			}
		}
		this.updateReadonlyValue();
	}, _setEditorValue:function (inDisplayValue) {
		inDisplayValue = String(inDisplayValue);
		var e = this.editor;
		delete this._isValid;
		e._isvalid = true;
		if (this.restrictValues) {
			e.attr("displayedValue", inDisplayValue, !this._updating);
		} else {
			e.attr("value", inDisplayValue, !this._updating);
		}
	}, getDisplayValue:function () {
		if (this.hasValues()) {
			return this.inherited(arguments);
		}
	}, getEditorValue:function (getFullDataObj) {
		var v;
		if (this.editor && this.hasValues()) {
			var displayed = this.editor.attr("value");
			var v = displayed && this.getStoreItem(displayed, this._storeNameField);
		}
		if (v && !(getFullDataObj || this.dataField == "All Fields")) {
			v = v[this.dataField];
		}
		if (!this.restrictValues && displayed && !v) {
			return displayed;
		}
		return (v || v === 0) ? v : this.makeEmptyValue();
	}, setDataField:function (inDataField) {
		this.dataField = inDataField;
	}, setDisplayField:function (inDisplayField) {
		this.displayField = inDisplayField;
	}, _getFirstDataField:function () {
		if (!this.dataSet) {
			return;
		}
		var schema = this.dataSet._dataSchema;
		for (var i in schema) {
			var ti = schema[i];
			if (!ti.isList && !wm.typeManager.isStructuredType(ti.type)) {
				return i;
			}
		}
	}, _initDataProps:function () {
		if (this.dataSet) {
			var ff = this._getFirstDataField();
			this._displayField = this.displayField || ff || "name";
			this._dataField = this.dataField || ff || ("dataValue" in this.dataSet._dataSchema ? "dataValue" : "value");
		} else {
			if (this.options) {
				this._displayField = this._dataField = "name";
			}
		}
	}, _getOptionsData:function () {
		var data = [];
		if (!this.options) {
			return data;
		}
		for (var i = 0, opts = this.options.split(","), l = opts.length, d; i < l; i++) {
			d = dojo.string.trim(opts[i]);
			if (d != "") {
				data[i] = {name:d, dataValue:d};
			}
		}
		return data;
	}, _getDisplayData:function (inObj) {
		var inVariable;
		if (wm.isInstanceType(inObj, wm.Variable)) {
			inVariable = inObj;
		} else {
			inVariable = new wm.Variable();
			inVariable.setType(this.dataSet.type);
			inVariable.setData(inObj);
			inVariable.data[this._storeNameField] = this._getDisplayData(inVariable);
		}
		var de = this.displayExpression, v = inVariable;
		return String(de ? wm.expression.getValue(de, v) : inVariable.getValue(this._displayField));
	}, _getDataSetData:function () {
		var dataSet = this.dataSet;
		var data = [];
		for (var i = 0, c = dataSet.getCount(), v; i < c && (v = dataSet.getItem(i)); i++) {
			var d = v.getData();
			d[this._storeNameField] = this._getDisplayData(v);
			data.push(d);
		}
		return data;
	}, _getData:function () {
		var data = [];
		if (this.dataSet) {
			data = this._getDataSetData();
		} else {
			if (this.options) {
				this.setOptionsVariable();
				data = this._getDataSetData();
			}
		}
		if (this.allowNone) {
			var o = {};
			o[this._storeNameField] = "";
			data.unshift(o);
		}
		return data;
	}, setDataSet:function (inDataSet) {
		var ds = this.dataSet = inDataSet;
		if (!ds || !ds.data || !ds.data.list) {
			return;
		}
		this.createEditor();
	}, setOptionsVariable:function () {
		var opts = this._getOptionsData();
		var ds = this.dataSet = new wm.Variable({name:"optionsVar", owner:this, type:"EntryData"});
		ds.setData(opts);
		this.displayField = "name";
		this.dataField = "dataValue";
	}, setOptions:function (inOptions) {
		this.options = inOptions;
		this.setOptionsVariable();
		var wasUpdating = this._cupdating;
		this._cupdating = true;
		this.createEditor();
		if (!wasUpdating) {
			this._cupdating = false;
			this.render();
		}
	}, isReady:function () {
		return this.inherited(arguments) && this.hasValues();
	}, clear:function () {
		this.reset();
		if (this.editor && this.hasValues()) {
			if (this.restrictValues) {
				this.editor.attr("value", "", false);
			} else {
				this.editor.attr("value", undefined, false);
			}
			this.updateReadonlyValue();
		}
	}, editorChanged:function () {
		this.inherited(arguments);
		this.updateSelectedItem();
	}, updateSelectedItem:function () {
		var v = this.getEditorValue(true);
		this.selectedItem.setData(v);
	}, isAllDataFields:function () {
		return (this.dataField == this._allFields);
	}});
	wm.selectDisplayTypes = ["Text", "Date", "Time", "Number", "Currency"];
	dojo.declare("wm._SelectEditor", wm._BaseEditor, {options:"", displayField:"", dataField:"", displayExpression:"", lookupDisplay:"Text", pageSize:20, allowNone:false, autoComplete:true, hasDownArrow:true, startUpdate:false, _allFields:"All Fields", binding:"(data binding)", restrictValues:true, init:function () {
		this.inherited(arguments);
		this.owner.selectedItem = new wm.Variable({name:"selectedItem", owner:this.owner});
	}, ownerLoaded:function () {
		if (this.startUpdate) {
			this.update();
		}
	}, update:function () {
		if (this.dataSet instanceof wm.ServiceVariable) {
			var d = this.dataSet.update();
			return d;
		}
	}, generateStore:function () {
		this._initDataProps();
		var d = this._getData();
		return new wm.base.data.SimpleStore(d, "name", this);
	}, getEditorProps:function (inNode, inProps) {
		var store = this.generateStore();
		return dojo.mixin(this.inherited(arguments), {required:this.required, store:store, autoComplete:this.autoComplete, hasDownArrow:this.hasDownArrow, searchAttr:"name", pageSize:this.pageSize ? this.pageSize : Infinity}, inProps || {});
	}, _createEditor:function (inNode, inProps) {
		if (this.restrictValues) {
			return new dijit.form.FilteringSelect(this.getEditorProps(inNode, inProps));
		} else {
			return new dijit.form.ComboBox(this.getEditorProps(inNode, inProps));
		}
	}, setRestrictValues:function (inValue) {
		var dataval = this.getEditorValue();
		var oldval = this.restrictValues;
		this.restrictValues = inValue;
		if (this.editor && oldval != inValue) {
			this.createEditor();
			this.setEditorValue(dataval);
		}
		if (!inValue && this.dataField == this._allFields) {
			this.dataField = "";
		}
	}, sizeEditor:function () {
		this.inherited(arguments);
		this.domNode.style.height = "";
		this.domNode.style.lineHeight = "";
	}, hasValues:function () {
		return (this.editor && this.editor.store.getCount());
	}, getStoreItem:function (inValue, inStoreField) {
		if (!this.hasValues()) {
			return;
		}
		var result, onItem = function (item) {
			result = item;
		}, query = {};
		query[inStoreField] = inValue;
		this.editor.store.fetch({query:query, queryOptions:{exactMatch:true}, count:1, onItem:onItem});
		return result;
	}, isAllDataFields:function () {
		return (this.dataField == this._allFields);
	}, setInitialValue:function () {
		this.owner.beginEditUpdate();
		this.owner.selectedItem.setType(this.dataSet instanceof wm.Variable ? this.dataSet.type : "AnyData");
		var dataValue = this.owner.dataValue, displayValue = this.owner.displayValue;
		if (wm.propertyIsChanged(dataValue, "dataValue", wm.Editor)) {
			this.setEditorValue(dataValue);
		} else {
			this.setDisplayValue(displayValue);
		}
		this.owner.endEditUpdate();
	}, setDisplayValue:function (inValue) {
		var i = this.getStoreItem(inValue, "name");
		if (i !== undefined) {
			this._setEditorValue(this.editor.store.getValue(i, "name"));
		} else {
			this.clear();
		}
	}, setEditorValue:function (inValue) {
		var i;
		if (this.isAllDataFields() && inValue instanceof wm.Variable) {
			var v = this._getDisplayData(inValue);
			i = this.getStoreItem(v, "name");
		} else {
			i = this.getStoreItem(inValue, "value");
		}
		if (i !== undefined) {
			this._setEditorValue(this.editor.store.getValue(i, "name"));
		} else {
			if (this.restrictValues) {
				this.clear();
			} else {
				this.editor.attr("value", inValue);
			}
		}
		this.updateReadonlyValue();
	}, _setEditorValue:function (inDisplayValue) {
		inDisplayValue = String(inDisplayValue);
		delete this._isValid;
		var e = this.editor;
		e._isvalid = true;
		if (this.restrictValues) {
			e.attr("displayedValue", inDisplayValue);
		} else {
			e.attr("value", inDisplayValue);
		}
	}, getDisplayValue:function () {
		if (this.hasValues()) {
			return this.inherited(arguments);
		}
	}, getEditorValue:function () {
		var v;
		if (this.editor && this.hasValues()) {
			var displayed = this.editor.attr("value"), i = displayed && this.getStoreItem(displayed, "name");
			if (i) {
				v = this.editor.store.getValue(i, "value");
				v = v instanceof wm.Variable ? v.getData() : v;
			}
		}
		if (!this.restrictValues && displayed && !v) {
			return displayed;
		}
		return (v || v === 0) ? v : this.makeEmptyValue();
	}, setDataField:function (inDataField) {
		this.dataField = inDataField;
	}, setDisplayField:function (inDisplayField) {
		this.displayField = inDisplayField;
	}, _getFirstDataField:function () {
		if (!this.dataSet) {
			return;
		}
		var schema = this.dataSet._dataSchema;
		for (var i in schema) {
			var ti = schema[i];
			if (!ti.isList && !ti.isObject) {
				return i;
			}
		}
	}, _initDataProps:function () {
		if (this.dataSet) {
			var ff = this._getFirstDataField();
			this._displayField = this.displayField || ff || "name";
			this._dataField = this.dataField || ff || ("dataValue" in this.dataSet._dataSchema ? "dataValue" : "value");
		} else {
			if (this.options) {
				this._displayField = this._dataField = "name";
			}
		}
	}, _getOptionsData:function () {
		var data = [];
		if (!this.options) {
			return data;
		}
		for (var i = 0, opts = this.options.split(","), l = opts.length, d; i < l; i++) {
			d = dojo.string.trim(opts[i]);
			if (d != "") {
				data[i] = {name:d, dataValue:d};
			}
		}
		return data;
	}, _getDisplayData:function (inVariable) {
		var de = this.displayExpression, v = inVariable;
		var value = "";
		if (de) {
			return wm.expression.getValue(de, v);
		} else {
			if (this.lookupDisplay && this.lookupDisplay != "Text") {
				return this.formatData(v.getValue(this._displayField));
			} else {
				return v.getValue(this._displayField);
			}
		}
	}, formatData:function (inValue) {
		try {
			if (this.formatter) {
				return this.formatter.format(inValue);
			} else {
				if (this.lookupDisplay) {
					var ctor = wm.getFormatter(this.lookupDisplay);
					this.formatter = new ctor({name:"format", owner:this});
					return this.formatter.format(inValue);
				} else {
					return inValue;
				}
			}
		}
		catch (e) {
			console.info("error while getting data from formatData----- ", e);
		}
	}, _getDataSetData:function () {
		var dataSet = this.dataSet, data = [], dataField = this._dataField, af = this.isAllDataFields();
		for (var i = 0, c = dataSet.getCount(), v; i < c && (v = dataSet.getItem(i)); i++) {
			data.push({name:this._getDisplayData(v), value:af ? v.getData() : v.getValue(dataField)});
		}
		return data;
	}, _getData:function () {
		var data = [];
		if (this.dataSet) {
			data = this._getDataSetData();
		} else {
			if (this.options) {
				this.setOptionsVariable();
				data = this._getDataSetData();
			}
		}
		if (this.allowNone) {
			var o = {name:"", value:null};
			data.unshift(o);
		}
		return data;
	}, setDataSet:function (inDataSet) {
		var ds = this.dataSet = inDataSet;
		if (!ds || !ds.data || !ds.data.list) {
			return;
		}
		this.createEditor();
	}, setOptionsVariable:function () {
		var opts = this._getOptionsData();
		var ds = this.dataSet = new wm.Variable({name:"optionsVar", owner:this, type:"EntryData"});
		ds.setData(opts);
		this.displayField = "name";
		this.dataField = "dataValue";
	}, setOptions:function (inOptions) {
		this.options = inOptions;
		this.setOptionsVariable();
		this.createEditor();
	}, setOptionSet:function (inOptions) {
		if (inOptions == null || inOptions == undefined || inOptions.length == 0) {
			return;
		}
		var obj = inOptions[0];
		var keys = [];
		for (var key in obj) {
			keys.push(key);
		}
		var varParms = {};
		varParms.name = this.owner.name + "Var";
		varParms.owner = this;
		varParms.type = "EntryData";
		var ds = this.dataSet = new wm.Variable(varParms);
		var ds = this.dataSet = new wm.Variable(varParms);
		ds.setData(inOptions);
		this.displayField = keys[0];
		this.dataField = keys[1];
		this.createEditor();
	}, isReady:function () {
		return this.inherited(arguments) && this.hasValues();
	}, clear:function () {
		this.reset();
		if (this.editor && this.hasValues()) {
			if (this.restrictValues) {
				try {
					this.editor.attr("value", "");
				}
				catch (e) {
					console.info("error while clearing editor value............", e);
				}
			} else {
				this.editor.attr("value", undefined);
			}
		}
	}, ownerEditorChanged:function () {
		this.updateSelectedItem();
	}, updateSelectedItem:function () {
		var v = this.getEditorValue();
		this.owner.selectedItem.setData(v);
	}});
	dojo.declare("wm._LookupEditor", wm._SelectEditor, {dataField:"All Fields", autoDataSet:true, startUpdate:true, init:function () {
		this.inherited(arguments);
		if (this.autoDataSet) {
			this.createDataSet();
		}
	}, createDataSet:function () {
		wm.fire(this.$.liveVariable, "destroy");
		var pf = wm.getParentForm(this.owner);
		var v = wm.getFormLiveView(pf);
		if (v) {
			var ff = wm.getFormField(this.owner);
			v.addRelated(ff);
			var lv = this.dataSet = new wm.LiveVariable({name:"liveVariable", owner:this, autoUpdate:false, startUpdate:false, _rootField:ff, liveView:v});
			this.owner.selectedItem.setType(this.dataSet.type);
			this.createDataSetWire(lv);
		} else {
			if (pf) {
				var evt2 = pf._getEditorBindSourceId(pf.getSourceId()) + "-created";
				this._subscriptions.push(dojo.subscribe(evt2, this, "_onSourceCreated"));
			}
		}
	}, _onSourceCreated:function () {
		try {
			this.createDataSet();
			this.update();
		}
		catch (e) {
			console.info("error while updating source in select.js", e);
		}
	}, createDataSetWire:function (inDataSet) {
		var w = this._dataSetWire = new wm.Wire({name:"dataFieldWire", target:this, owner:this, source:inDataSet.getId(), targetProperty:"dataSet"});
		w.connectWire();
	}, setAutoDataSet:function (inAutoDataSet) {
		this.autoDataSet = inAutoDataSet;
		if (this.autoDataSet) {
			this.createDataSet();
			this.update();
		}
	}, _getFormSource:function (inForm) {
		var w = wm.data.getPropWire(inForm, "dataSet");
		return w && w.source && this.getRoot().getValueById(w.source);
	}, changed:function () {
		if (this.owner.isUpdating()) {
			return;
		}
		this.inherited(arguments);
		var f = wm.getParentForm(this.owner);
		var s = this._getFormSource(f);
		if (s) {
			this.owner.beginEditUpdate();
			var v = this.owner.dataValue;
			if (this.autoDataSet) {
				var i = this.dataSet.getItemIndex(v);
				if (i >= 0) {
					this.dataSet.cursor = i;
				}
			}
			s.setData(v);
			this.owner.endEditUpdate();
			wm.fire(f, "populateEditors");
		}
	}});
	wm._SelectEditor.extend({updateNow:"(updateNow)", set_dataSet:function (inDataSet) {
		if (inDataSet && !(inDataSet instanceof wm.Variable)) {
			var ds = this.getValueById(inDataSet);
			if (ds) {
				this.components.binding.addWire("", "dataSet", ds.getId());
			}
		} else {
			this.setDataSet(inDataSet);
		}
	}, _addFields:function (inList, inSchema) {
		for (var i in inSchema) {
			var ti = inSchema[i];
			if (!(ti || 0).isList && !wm.typeManager.isStructuredType((ti || 0).type)) {
				inList.push(i);
			}
		}
	}, _listFields:function () {
		var list = [""];
		var schema = this.dataSet instanceof wm.LiveVariable ? wm.typeManager.getTypeSchema(this.dataSet.type) : (this.dataSet || 0)._dataSchema;
		var schema = (this.dataSet || 0)._dataSchema;
		this._addFields(list, schema);
		return list;
	}, makePropEdit:function (inName, inValue, inDefault) {
		switch (inName) {
		  case "displayField":
			return makeSelectPropEdit(inName, inValue, this._listFields(), inDefault);
		  case "dataField":
			var l = this._listFields();
			l.splice(1, 0, this._allFields);
			return makeSelectPropEdit(inName, inValue, l, inDefault);
		  case "lookupDisplay":
			return makeSelectPropEdit(inName, inValue, wm.selectDisplayTypes, inDefault);
		  case "dataSet":
			return new wm.propEdit.DataSetSelect({component:this, name:inName, value:this.dataSet ? this.dataSet.getId() : "", allowAllTypes:true, listMatch:true});
		  case "updateNow":
			return makeReadonlyButtonEdit(inName, inValue, inDefault);
		}
		return this.inherited(arguments);
	}, editProp:function (inName, inValue, inInspector) {
		switch (inName) {
		  case "updateNow":
			return this.update();
		}
	}});
	wm._LookupEditor.extend({listProperties:function () {
		var props = this.inherited(arguments);
		props.dataSet.ignore = this.autoDataSet;
		props.dataSet.bindTarget = !props.dataSet.ignore;
		return props;
	}});
	dojo.declare("wm.Lookup", wm.SelectMenu, {dataField:"All Fields", autoDataSet:true, startUpdate:true, init:function () {
		this.inherited(arguments);
		if (this.autoDataSet) {
			this.createDataSet();
		}
	}, createDataSet:function () {
		wm.fire(this.$.liveVariable, "destroy");
		var v = wm.getFormLiveView(wm.getParentForm(this));
		if (v) {
			var ff = wm.getFormField(this);
			v.addRelated(ff);
			var lv = this.dataSet = new wm.LiveVariable({name:"liveVariable", owner:this, autoUpdate:false, startUpdate:false, _rootField:ff, liveView:v});
			this.selectedItem.setType(this.dataSet.type);
			this.createDataSetWire(lv);
		}
	}, createDataSetWire:function (inDataSet) {
		var w = this._dataSetWire = new wm.Wire({name:"dataFieldWire", target:this, owner:this, source:inDataSet.getId(), targetProperty:"dataSet"});
		w.connectWire();
	}, setAutoDataSet:function (inAutoDataSet) {
		this.autoDataSet = inAutoDataSet;
		if (this.autoDataSet) {
			this.createDataSet();
			this.update();
		}
	}, _getFormSource:function (inForm) {
		var w = wm.data.getPropWire(inForm, "dataSet");
		return w && w.source && this.getRoot().getValueById(w.source);
	}, changed:function () {
		if (this.isUpdating()) {
			return;
		}
		this.inherited(arguments);
		var f = wm.getParentForm(this);
		var s = this._getFormSource(f);
		if (s) {
			this.beginEditUpdate();
			var v = this.selectedItem;
			if (this.autoDataSet && this.dataSet) {
				var i = this.dataSet.getItemIndex(v);
				if (i >= 0) {
					this.dataSet.cursor = i;
				}
			}
			s.setData(v);
			this.endEditUpdate();
		}
	}, setDefaultOnInsert:function () {
		if (this.editor && this.defaultInsert) {
			this.setEditorValue(this.defaultInsert);
			this.changed();
		}
	}});
	wm.SelectMenu.extend({themeableStyles:["wm.SelectMenu-Down-Arrow_Image", "wm.SelectMenu-Inner_Radius"], updateNow:"(updateNow)", set_dataSet:function (inDataSet) {
		if (inDataSet && !(inDataSet instanceof wm.Variable)) {
			var ds = this.getValueById(inDataSet);
			if (ds) {
				this.components.binding.addWire("", "dataSet", ds.getId());
			}
		} else {
			this.setDataSet(inDataSet);
		}
	}, _addFields:function (inList, inSchema) {
		for (var i in inSchema) {
			var ti = inSchema[i];
			if (!(ti || 0).isList && !wm.typeManager.isStructuredType((ti || 0).type)) {
				inList.push(i);
			}
		}
	}, _listFields:function () {
		var list = [""];
		var schema = this.dataSet instanceof wm.LiveVariable ? wm.typeManager.getTypeSchema(this.dataSet.type) : (this.dataSet || 0)._dataSchema;
		var schema = (this.dataSet || 0)._dataSchema;
		this._addFields(list, schema);
		return list;
	}, makePropEdit:function (inName, inValue, inDefault) {
		switch (inName) {
		  case "displayField":
			return makeSelectPropEdit(inName, inValue, this._listFields(), inDefault);
		  case "dataField":
			var l = this._listFields();
			return makeSelectPropEdit(inName, inValue, l, inDefault);
		  case "dataSet":
			return new wm.propEdit.DataSetSelect({component:this, name:inName, value:this.dataSet ? this.dataSet.getId() : "", allowAllTypes:true, listMatch:true});
		  case "updateNow":
			return makeReadonlyButtonEdit(inName, inValue, inDefault);
		}
		return this.inherited(arguments);
	}, editProp:function (inName, inValue, inInspector) {
		switch (inName) {
		  case "updateNow":
			return this.update();
		}
	}, setHasDownArrow:function (inValue) {
		this.hasDownArrow = inValue;
		if (this.editor.downArrowNode) {
			this.editor.downArrowNode.style.display = this.hasDownArrow ? "" : "none";
		}
	}});
	wm.Object.extendSchema(wm._SelectEditor, {changeOnKey:{ignore:1}, changeOnEnter:{ignore:1}, selectedItem:{ignore:true, isObject:true, bindSource:true, isOwnerProperty:1}, dataSet:{readonly:true, group:"data", order:5, type:"wm.Variable", isList:true, bindTarget:true}, startUpdate:{group:"data", order:6}, liveVariable:{ignore:1}, formatter:{ignore:1}, options:{group:"data", order:7}, dataField:{group:"data", order:10}, displayField:{group:"data", order:15}, lookupDisplay:{group:"data", order:16}, displayExpression:{group:"data", order:20}, hasDownArrow:{group:"editor", order:26}, restrictValues:{type:"wm.Boolean", group:"data", order:40}, pageSize:{order:0}, updateNow:{group:"operation"}, dataFieldWire:{ignore:1}});
	wm.Object.extendSchema(wm.SelectMenu, {restrictValues:{type:"wm.Boolean", group:"editor", order:40}, changeOnKey:{ignore:1}, changeOnEnter:{ignore:1}, selectedItem:{ignore:true, isObject:true, bindSource:true}, dataSet:{readonly:true, group:"editor", order:4, type:"wm.Variable", isList:true, bindTarget:true}, startUpdate:{group:"editor", order:5}, pageSize:{order:6, group:"editor"}, liveVariable:{ignore:1}, options:{group:"editor", order:7}, dataField:{group:"editor", order:10}, displayField:{group:"editor", order:15}, displayExpression:{group:"editor", order:20}, autoComplete:{group:"editor", order:25}, hasDownArrow:{group:"editor", order:26}, allowNone:{group:"editor", order:30}, updateNow:{group:"operation"}, dataFieldWire:{ignore:1}, optionsVar:{ignore:1}, _allFields:{ignore:1}, defaultInsert:{ignore:1, bindTarget:1, type:"wm.Variable", group:"editData", order:10, dependency:"${parent.declaredClass} == \"wm.LiveForm\" || ${parent.declaredClass} == \"wm.RelatedEditor\""}});
	wm.Object.extendSchema(wm._LookupEditor, {autoDataSet:{group:"data", order:3}, options:{ignore:1}, dataField:{ignore:1}});
}
if (!dojo._hasResource["wm.base.widget.Box"]) {
	dojo._hasResource["wm.base.widget.Box"] = true;
	dojo.provide("wm.base.widget.Box");
	dojo.declare("wm.Box", wm.Widget, {});
}
if (!dojo._hasResource["wm.base.widget.Box_design"]) {
	dojo._hasResource["wm.base.widget.Box_design"] = true;
	dojo.provide("wm.base.widget.Box_design");
	wm.Object.extendSchema(wm.Box, {box:{ignore:1}, boxPosition:{ignore:1}});
	wm.Box.extend({_boxTypes:["h", "v"], _boxTypeLabels:["Left-to-Right", "Top-to-Bottom"], _hboxPositions:["left", "center", "right"], _vboxPositions:["top", "center", "bottom"], _boxPositions:["topLeft", "center", "bottomRight"], designCreate:function () {
		this.inherited(arguments);
		var p = this.parent;
		if (p && p.box == "flow") {
			this.moveable = false;
		}
	}, makePropEdit:function (inName, inValue, inDefault) {
		switch (inName) {
		  case "box":
			return makeSelectPropEdit(inName, inValue, this._boxTypeLabels, inDefault, this._boxTypes);
		  case "boxPosition":
			var opts = this.box == "h" ? this._hboxPositions : this._vboxPositions;
			return makeSelectPropEdit(inName, inValue, opts, inDefault, this._boxPositions);
		}
		return this.inherited(arguments);
	}});
}
if (!dojo._hasResource["wm.base.widget.Spacer"]) {
	dojo._hasResource["wm.base.widget.Spacer"] = true;
	dojo.provide("wm.base.widget.Spacer");
	dojo.declare("wm.Spacer", wm.Control, {classNames:"wmspacer", border:0, getMinWidthProp:function () {
		return this.minWidth || 0;
	}, getMinHeightProp:function () {
		return this.minHeight || 0;
	}});
	wm.Object.extendSchema(wm.Spacer, {disabled:{ignore:1}, scrollX:{ignore:1}, scrollY:{ignore:1}, margin:{ignore:1}, padding:{ignore:1}, border:{ignore:1}, borderColor:{ignore:1}});
	dojo.extend(wm.Spacer, {themeable:false, scrim:true});
	wm.Spacer.description = "Resizable spacer for layouts.";
}
if (!dojo._hasResource["wm.base.widget.layout.Layout"]) {
	dojo._hasResource["wm.base.widget.layout.Layout"] = true;
	dojo.provide("wm.base.widget.layout.Layout");
	wm.inLayout = function (inNode) {
		if (!inNode) {
			return false;
		}
		var s = inNode.style;
		return s && s.zIndex >= 0 && s.zIndex <= 1 && s.display != "none" && s.visibility != "hidden" && inNode.tagName != "SCRIPT" && inNode.nodeType == 1;
	};
	dojo.declare("wm.layout.Base", null, {inFlow:function (inControl) {
		return inControl.showing && (inControl.inFlow !== false) && wm.inLayout(inControl.domNode);
	}, flow:function (inContainer) {
	}, suggest:function (inContainer, inControl, ioInfo) {
	}, suggestSize:function (inContainer, inControl, ioInfo) {
	}, insert:function (inTarget, inControl, inInfo) {
	}});
	dojo.mixin(wm.layout, {registry:{}, cache:{}, register:function (inName, inClass) {
		this.registry[inName] = inClass;
	}, addCache:function (inName, inObj) {
		this.cache[inName] = inObj;
	}, listLayouts:function () {
		var list = [];
		for (var n in this.registry) {
			list.push(n);
		}
		return list;
	}});
}
if (!dojo._hasResource["wm.base.widget.layout.Box"]) {
	dojo._hasResource["wm.base.widget.layout.Box"] = true;
	dojo.provide("wm.base.widget.layout.Box");
	dojo.declare("wm.layout.Box", wm.layout.Base, {flow:function (inContainer, reflowTest) {
		if (this.direction == "h") {
			this._flow(inContainer, "l", "t", "w", "h", inContainer.horizontalAlign, inContainer.verticalAlign, reflowTest);
		} else {
			this._flow(inContainer, "t", "l", "h", "w", inContainer.verticalAlign, inContainer.horizontalAlign, reflowTest);
		}
		if (!reflowTest) {
			inContainer.renderControls();
		}
		if (inContainer._autoSizeList) {
			var c;
			while (c = inContainer._autoSizeList.pop()) {
				c.doAutoSize(1, 1);
			}
		}
	}, _flow:function (inContainer, inFlowOrd, inFitOrd, inFlowAxis, inFitAxis, inFlowAlign, inFitAlign, reflowTest) {
		if (inContainer.fitToContentHeight) {
			if (inContainer.layoutKind == "top-to-bottom") {
				inFlowAlign = "top";
			}
		}
		if (inContainer.fitToContentWidth) {
			if (inContainer.layoutKind == "left-to-right") {
				inFlowAlign = "left";
			}
		}
		this.handleAutoSizingWidgets(inContainer);
		if (inContainer.autoScroll) {
			this.handleAutoScrollBars(inContainer);
		}
		var b = inContainer.getContentBounds();
		var flowEx = this.calcFlexRatio(inContainer.c$, inFlowAxis, b[inFlowAxis]);
		if (flowEx.free) {
			var free = flowEx.free;
			for (var i = 0, c; c = inContainer.c$[i]; i++) {
				if (this.inFlow(c)) {
					free -= c._percEx[inFlowAxis] ? (flowEx.ratio * c._percEx[inFlowAxis]) : 0;
				}
			}
			switch (inFlowAlign) {
			  case "bottom":
			  case "right":
				b[inFlowOrd] += free;
				break;
			  case "middle":
			  case "center":
				b[inFlowOrd] += free / 2;
				if (b[inFlowOrd] < 0) {
					b[inFlowOrd] = 0;
				}
				break;
			}
		}
		var fitOrd = b[inFitOrd];
		var fitBound = b[inFitAxis];
		for (var i = 0, c; c = inContainer.c$[i]; i++) {
			if (this.inFlow(c)) {
				b[inFlowAxis] = c._percEx[inFlowAxis] ? Math.round((flowEx.ratio * c._percEx[inFlowAxis])) : NaN;
				var cFitSize;
				if (c._percEx[inFitAxis]) {
					cFitSize = b[inFitAxis] = Math.min(100, c._percEx[inFitAxis]) * fitBound * 0.01;
				} else {
					cFitSize = c.bounds[inFitAxis];
					delete b[inFitAxis];
				}
				b[inFitOrd] = fitOrd;
				switch (inFitAlign) {
				  case "justified":
					if (djConfig.isDebug && !wm.isInstanceType(inContainer, wm.Editor) && inContainer.isDesignedComponent() && inFitAxis == "w" && !wm.isInstanceType(inContainer, wm.Layers) && !wm.isInstanceType(inContainer.owner, wm.Layers)) {
						dojo.deprecated("justified", inContainer.owner.toString() + ":" + inContainer.toString() + "'s " + ((inFitAxis == "w") ? "horizontalAlign" : "verticalAlign") + " is set to 'justified', which may yield unexpected behaviors; please change this alignment in the property editor");
					}
					b[inFitAxis] = fitBound;
					break;
				  case "center":
				  case "middle":
					b[inFitOrd] = (fitOrd + fitBound - cFitSize) / 2;
					if (b[inFitOrd] < 0) {
						b[inFitOrd] = 0;
					}
					break;
				  case "bottom":
				  case "right":
					b[inFitOrd] = fitOrd + fitBound - cFitSize;
					break;
				}
				if (c._percEx.h) {
					var minHeight = c.getMinHeightProp();
					if (minHeight > b.h) {
						b.h = minHeight;
					}
				}
				if (c._percEx.w) {
					var minWidth = c.getMinWidthProp();
					if (minWidth > b.w) {
						b.w = minWidth;
					}
				}
				c.setBounds(b.l, b.t, b.w, b.h);
				c._renderEngineBoundsSet = true;
				if (c.flow) {
					c.flow();
				}
				b[inFlowOrd] += Math.max(0, c.bounds[inFlowAxis]);
				wm.flowees++;
			}
		}
	}, handleAutoSizingWidgets:function (inContainer) {
		if (!inContainer.isAncestorHiddenLayer() && inContainer.showing && (!wm.isInstanceType(inContainer, wm.Layer) || inContainer.active)) {
			var hasAutoHeight;
			var hasAutoWidth;
			for (var i = 0; i < inContainer.c$.length; i++) {
				var c = inContainer.c$[i];
				if (c.showing) {
					if (c._needsAutoSize && (c.autoSizeWidth || c.autoSizeHeight)) {
						var topParent = (c.owner instanceof wm.Page) ? c.owner.root : c.owner;
						if (!topParent._autoSizeList) {
							topParent._autoSizeList = [];
						}
						topParent._autoSizeList.push(c);
					} else {
						if (c.fitToContent) {
							if (c.fitToContentHeight) {
								c.bounds.h = c.getPreferredFitToContentHeight();
							}
							if (c.fitToContentWidth) {
								c.bounds.w = c.getPreferredFitToContentWidth();
							}
							c.calcFitToContent();
							if (c.fitToContentWidth) {
								hasAutoWidth = true;
							}
							if (c.fitToContentHeight) {
								hasAutoHeight = true;
							}
						}
					}
				}
			}
		}
	}, handleAutoScrollBars:function (inContainer) {
		if (inContainer.fitToContentHeight) {
			inContainer._xscrollY = false;
			scrollY = "hidden";
		} else {
			var needsScrollY = inContainer.getPreferredFitToContentHeight() > inContainer.bounds.h;
			var scrollY = (needsScrollY) ? "auto" : "hidden";
			inContainer._xscrollY = (scrollY == "auto");
		}
		if (inContainer.domNode.style.overflowY != scrollY) {
			inContainer.domNode.style.overflowY = scrollY;
			inContainer.domNode.scrollTop = 0;
		}
		if (inContainer.fitToContentWidth) {
			inContainer._xscrollX = false;
			scrollX = "hidden";
		} else {
			var needsScrollX = inContainer.getPreferredFitToContentWidth() > inContainer.bounds.w;
			var scrollX = (needsScrollX) ? "auto" : "hidden";
		}
		inContainer._xscrollX = (scrollX == "auto");
		if (inContainer.domNode.style.overflowX != scrollX) {
			inContainer.domNode.style.overflowX = scrollX;
			inContainer.domNode.scrollLeft = 0;
		}
	}, calcFlexRatio:function (inC$, inAxis, inExtent) {
		var flex = 0;
		var free = inExtent;
		var minSizeSum = 0;
		var minname = "getMin" + ((inAxis == "h") ? "Height" : "Width") + "Prop";
		for (var i = 0, c; c = inC$[i]; i++) {
			if (this.inFlow(c)) {
				if (c._percEx[inAxis]) {
					flex += Number(c._percEx[inAxis]) || 0;
					minSizeSum += c[minname]();
				} else {
					free -= c.bounds[inAxis];
				}
			}
		}
		if (free - minSizeSum < 0) {
			free -= minSizeSum;
		}
		if (flex && flex < 100) {
			flex = 100;
		}
		return {free:free, ratio:(flex && free > 0) ? (free / flex) : 0};
	}, getMaxFreeSpace:function (inC$, inAxis, inExtent) {
		var free = inExtent;
		var minSizeSum = 0;
		var minname = "min" + ((inAxis == "h") ? "Height" : "Width");
		for (var i = 0, c; c = inC$[i]; i++) {
			if (this.inFlow(c)) {
				if (c._percEx[inAxis]) {
					if (c[minname]) {
						minSizeSum += c[minname];
					}
				} else {
					free -= c.bounds[inAxis];
				}
			}
		}
		if (free - minSizeSum < 0) {
			free -= minSizeSum;
		}
		return free;
	}});
	dojo.declare("wm.layout.HBox", wm.layout.Box, {direction:"h", suggest:function (inContainer, inControl, ioRect) {
		var x = 0;
		for (var i = 0, c; c = inContainer.c$[i]; i++) {
			if (this.inFlow(c)) {
				if (ioRect.l < c.bounds.l + c.bounds.w / 2) {
					x = c.bounds.l - 1;
					break;
				}
				x = c.bounds.r;
			}
		}
		var b = inContainer.getContentBounds();
		ioRect.l = x;
		ioRect.t = b.t;
		ioRect.h = b.h;
		ioRect.i = i;
	}});
	dojo.declare("wm.layout.VBox", wm.layout.Box, {direction:"v", suggest:function (inContainer, inControl, ioRect) {
		var y = 0;
		for (var i = 0, c; c = inContainer.c$[i]; i++) {
			if (this.inFlow(c)) {
				if (ioRect.t < c.bounds.t + c.bounds.h / 2) {
					y = c.bounds.t - 1;
					break;
				}
				y = c.bounds.b;
			}
		}
		var b = inContainer.getContentBounds();
		ioRect.l = b.l;
		ioRect.t = y;
		ioRect.w = b.w;
		ioRect.i = i;
	}});
	wm.layout.register("left-to-right", wm.layout.HBox);
	wm.layout.register("top-to-bottom", wm.layout.VBox);
	wm.layout.addCache("left-to-right", new wm.layout.HBox());
	wm.layout.addCache("top-to-bottom", new wm.layout.VBox());
}
if (!dojo._hasResource["wm.base.widget.layout.Abs"]) {
	dojo._hasResource["wm.base.widget.layout.Abs"] = true;
	dojo.provide("wm.base.widget.layout.Abs");
	wm.layout.findColEdges = function (c$, cc, x) {
		var edges = [];
		for (var i = 0, c; c = c$[i]; i++) {
			if (c != cc) {
				if (c.bounds.l == x) {
					edges.push({right:(c$[i] ? c$[i].name : ""), control:c, index:i});
				} else {
					if (c.bounds.r == x) {
						edges.push({left:(c$[i] ? c$[i].name : ""), control:c, index:i});
					}
				}
			}
		}
		return edges;
	};
	dojo.declare("wm.layout.Abs", wm.layout.Base, {_closeness:6, flow:function (inContainer) {
		for (var i = 0, c; c = inContainer.c$[i]; i++) {
			if (c.flow && this.inFlow(c)) {
				c.flow();
			}
		}
		inContainer.renderControls();
	}, suggest:function (inContainer, inControl, ioInfo) {
		var r = ioInfo, c = inControl;
		if (c) {
			r.l = c.bounds.l + r.dx;
			r.t = c.bounds.t + r.dy;
			r.w = c.bounds.w;
			r.h = c.bounds.h;
		} else {
			r.w = 96;
			r.h = 48;
			r.l -= 16;
			r.t -= 16;
		}
		r.r = r.l + r.w;
		r.b = r.t + r.h;
		var hSnap = null, vSnap = null;
		var hys = this._closeness;
		var cb = inContainer.getContentBounds();
		var ib = dojo.mixin({}, r);
		if (Math.abs(ib.t - cb.t) < hys) {
			r.t = cb.t;
			vSnap = {l:cb.l, t:r.t, w:cb.w, h:1};
		} else {
			if (Math.abs(ib.b - cb.b) < hys) {
				r.t = cb.b - ib.h;
				vSnap = {l:cb.l, t:r.t + r.h, w:cb.w, h:1};
			}
		}
		if (Math.abs(ib.l - cb.l) < hys) {
			r.l = 0;
			hSnap = {l:r.l, t:cb.t, w:1, h:cb.h};
		} else {
			if (Math.abs(ib.r - cb.r) < hys) {
				r.l = cb.r - ib.w;
				hSnap = {l:r.l + r.w, t:cb.t, w:1, h:cb.h};
			}
		}
		for (var i = 0, c; c = inContainer.c$[i]; i++) {
			if (c == inControl) {
				continue;
			}
			var b = c.bounds;
			if (Math.abs(b.b - ib.t) < hys) {
				r.t = b.t + b.h;
				vSnap = {l:cb.l, t:r.t, w:cb.w, h:1};
			}
			if (Math.abs(ib.b - b.t) < hys) {
				r.t = b.t - ib.h;
				vSnap = {l:cb.l, t:r.t + r.h, w:cb.w, h:1};
			}
			if (Math.abs(ib.t - b.t) < hys) {
				r.t = b.t;
				vSnap = {l:cb.l, t:r.t, w:cb.w, h:1};
			}
			if (Math.abs(b.r - ib.l) < hys) {
				r.l = b.l + b.w;
				hSnap = {l:r.l, t:cb.t, w:1, h:cb.h};
			}
			if (Math.abs(ib.r - b.l) < hys) {
				r.l = b.l - ib.w;
				hSnap = {l:r.l + r.w, t:cb.t, w:1, h:cb.h};
			}
			if (Math.abs(ib.l - b.l) < hys) {
				r.l = b.l;
				hSnap = {l:r.l, t:cb.t, w:1, h:cb.h};
			}
		}
		r.hSnap = hSnap;
		r.vSnap = vSnap;
	}, suggestSize:function (inContainer, inControl, ioInfo) {
		var r = ioInfo;
		r.b = r.t + r.h;
		r.r = r.l + r.w;
		var cb = inContainer.getContentBounds();
		var hys = this._closeness;
		for (var i = 0, c; c = inContainer.c$[i]; i++) {
			if (c == inControl) {
				continue;
			}
			var b = c.bounds;
			with (wm.design.handles) {
				switch (ioInfo.handleId) {
				  case leftTop:
				  case middleTop:
				  case rightTop:
					if (Math.abs(r.t - cb.t) < hys) {
						r.t = cb.t;
					} else {
						if (Math.abs(r.t - b.b) < hys) {
							r.t = b.b;
						} else {
							if (Math.abs(r.t - b.t) < hys) {
								r.t = b.t;
							}
						}
					}
					r.h = r.b - r.t;
					break;
				  case leftBottom:
				  case middleBottom:
				  case rightBottom:
					if (Math.abs(r.b - cb.b) < hys) {
						r.h = cb.b - r.t;
					} else {
						if (Math.abs(r.b - b.b) < hys) {
							r.h = b.b - r.t;
						} else {
							if (Math.abs(r.b - b.t) < hys) {
								r.h = b.t - r.t;
							}
						}
					}
					break;
				}
				switch (ioInfo.handleId) {
				  case leftTop:
				  case leftMiddle:
				  case leftBottom:
					if (Math.abs(r.l - cb.l) < hys) {
						r.l = cb.l;
					} else {
						if (Math.abs(r.l - b.r) < hys) {
							r.l = b.r;
						} else {
							if (Math.abs(r.l - b.l) < hys) {
								r.l = b.l;
							}
						}
					}
					r.w = r.r - r.l;
					break;
				  case rightTop:
				  case rightMiddle:
				  case rightBottom:
					if (Math.abs(r.r - cb.r) < hys) {
						r.w = cb.r - r.l;
					} else {
						if (Math.abs(r.r - b.r) < hys) {
							r.w = b.r - r.l;
						} else {
							if (Math.abs(r.r - b.l) < hys) {
								r.w = b.l - r.l;
							}
						}
					}
					break;
				}
			}
		}
	}, insert:function (inTarget, inControl, inDropInfo) {
		inControl.setBounds(inDropInfo);
		inControl.left = inDropInfo.l;
		inControl.top = inDropInfo.t;
	}, makeRoom:function (inContainer, inControl) {
		var c$ = inContainer.c$;
		var edges = wm.layout.findColEdges(inContainer.c$, inControl, inControl.bounds.l);
		for (var i = 0, e; e = edges[i]; i++) {
			if (e.right) {
				if (e.control.bounds.t < inControl.bounds.b && e.control.bounds.b > inControl.bounds.t) {
					e.control.setBounds({l:e.control.bounds.l + inControl.bounds.w});
					this.makeRoom(inContainer, e.control);
				}
			}
		}
	}, takeRoom:function (inContainer, inControl) {
		var c$ = inContainer.c$;
		var edges = wm.layout.findColEdges(inContainer.c$, inControl, inControl.bounds.r);
		for (var i = 0, e; e = edges[i]; i++) {
			if (e.right) {
				if (e.control.bounds.t < inControl.bounds.b && e.control.bounds.b > inControl.bounds.t) {
					this.takeRoom(inContainer, e.control);
					e.control.setBounds({l:e.control.bounds.l - inControl.bounds.w});
				}
			}
		}
	}, renderEdges:function (inContainer, inControl) {
		var cb = inContainer.getContentBounds();
		var c$ = inContainer.c$;
		this.nodes = [];
		var ve$ = [cb.l, cb.r - 1];
		for (var i = 0, c; c = c$[i]; i++) {
			if (c != inControl) {
				ve$.push(c.bounds.l);
				ve$.push(c.bounds.r);
			}
		}
		ve$.sort();
		for (var i = 1, e; (e = ve$[i]) || i < ve$.length; i++) {
			if (e == ve$[i - 1]) {
				ve$.splice(i--, 1);
			}
		}
		for (var i = 0, e, n; (e = ve$[i]) || i < ve$.length; i++) {
			var n = document.createElement("div");
			n.style.cssText = "position: absolute; z-index: 40; border: 1px dotted lightgreen;";
			dojo._setBox(n, e, cb.t, 0, cb.h);
			inContainer.dom.node.appendChild(n);
			this.nodes.push(n);
		}
		var he$ = [cb.t, cb.b - 1];
		for (var i = 0, c; c = c$[i]; i++) {
			if (c != inControl) {
				he$.push(c.bounds.t);
				he$.push(c.bounds.b);
			}
		}
		he$.sort();
		for (var i = 1, e; (e = he$[i]) || i < he$.length; i++) {
			if (e == he$[i - 1]) {
				he$.splice(i--, 1);
			}
		}
		for (var i = 0, e, n; (e = he$[i]) || i < he$.length; i++) {
			var n = document.createElement("div");
			n.style.cssText = "position: absolute; z-index: 40; border: 1px dotted lightgreen;";
			dojo._setBox(n, cb.l, e, cb.w, 0);
			inContainer.dom.node.appendChild(n);
			this.nodes.push(n);
		}
	}, removeEdges:function (inContainer) {
		if (!this.nodes) {
			return;
		}
		for (var i = 0, n; n = this.nodes[i]; i++) {
			n.parentNode.removeChild(n);
		}
		delete this.nodes;
	}});
}
if (!dojo._hasResource["wm.base.widget.Container"]) {
	dojo._hasResource["wm.base.widget.Container"] = true;
	dojo.provide("wm.base.widget.Container");
	wm.define("wm.Container", wm.Control, {published:{invalid:{ignore:1, bindSource:1, readonly:1, type:"Boolean"}, lock:{order:0}, freeze:{order:5}, box:{ignore:1}, boxPosition:{ignore:1}, disabled:{ignore:1}, autoScroll:{group:"scrolling", order:100, ignore:0}}, imageList:"", border:0, container:true, lock:false, freeze:false, classNames:"wmcontainer", autoScroll:false, isMajorContent:false, fitToContentWidth:false, fitToContentHeight:false, fitToContent:false, _needsFitToContent:false, constructor:function () {
		this.c$ = [];
	}, init:function () {
		this.inherited(arguments);
		this.setLayoutKind(this.layoutKind);
		this.domNode.box = this.box = "";
		this._needsFitToContent = this.fitToContent = this.fitToContentWidth || this.fitToContentHeight;
	}, postInit:function () {
		if (this.isDesignLoaded()) {
			this.setLock(this.lock);
		}
		this.inherited(arguments);
	}, setThemeStyleType:function (inType) {
		var oldType = this.getThemeStyleType();
		if (oldType) {
			this.removeUserClass(oldType);
		}
		this.addUserClass(inType);
	}, getThemeStyleType:function () {
		var types = ["MainContent", "EmphasizedContent", "HeaderContent"];
		if (this._classes && this._classes.domNode) {
			for (var i = 0; i < types.length; i++) {
				if (dojo.indexOf(this._classes.domNode, types[i]) != -1) {
					return types[i];
				}
			}
		}
	}, destroy:function () {
		if (this.domNode && this.domNode.box) {
			delete this.domNode.box;
		}
		this.inherited(arguments);
	}, afterPaletteDrop:function () {
		if (this.verticalAlign == "justified") {
			this.verticalAlign = "top";
		}
		if (this.horizontalAlign == "justified") {
			this.horizontalAlign = "left";
		}
	}, bc:function () {
		this.inherited(arguments);
		delete this.layoutJustify;
		if (this.layoutAlign) {
			this.contentAlign = this.layoutAlign;
			delete this.layoutAlign;
		}
		if (this.layoutFit) {
			this.fitToContentWidth = this.fitToContentHeight = this.layoutFit;
			delete this.layoutFit;
		}
		if (this.box == "h") {
			this.layoutKind = "left-to-right";
		}
		if (this.boxPosition) {
			var boxPositions = ["topLeft", "center", "bottomRight"], vAligns = ["top", "middle", "bottom"], hAligns = ["left", "center", "right"], h = this.layoutKind == "left-to-right", i = dojo.indexOf(boxPositions, this.boxPosition);
			if (i != -1) {
				if (h) {
					this.horizontalAlign = hAligns[i];
				} else {
					this.verticalAlign = vAligns[i];
				}
			}
		}
	}, addWidget:function (inWidget) {
		this.inherited(arguments);
		if (this.box == "h" && !inWidget.width) {
			inWidget.setProp("width", "64px");
		} else {
			if (this.box == "v" && !inWidget.height) {
				inWidget.setProp("height", "64px");
			}
		}
	}, getOrderedWidgets:function () {
		return this.c$;
	}, addControl:function (inControl) {
		this.c$.push(inControl);
	}, removeControl:function (inControl) {
		for (var i = 0, c; c = this.c$[i]; i++) {
			if (c == inControl) {
				this.c$.splice(i, 1);
				return i;
			}
		}
	}, removeAllControls:function () {
		while (this.c$.length) {
			var c = this.c$[0];
			this.removeControl(c);
			c.destroy();
		}
		this.reflow();
	}, insertControl:function (inControl, inIndex) {
		this.c$.splice(inIndex, 0, inControl);
	}, moveControl:function (inControl, inIndex) {
		var i0 = this.removeControl(inControl);
		if (i0 < inIndex) {
			inIndex--;
		}
		this.c$.splice(inIndex, 0, inControl);
	}, indexOfControl:function (inControl) {
		for (var i = 0, c; c = this.c$[i]; i++) {
			if (c == inControl) {
				return i;
			}
		}
		return -1;
	}, nextSibling:function (inControl) {
		for (var i = 0, c; c = this.c$[i]; i++) {
			if (c == inControl) {
				return this.c$[i + 1];
			}
		}
	}, prevSibling:function (inControl) {
		for (var i = 0, c; c = this.c$[i]; i++) {
			if (c == inControl) {
				return this.c$[i - 1];
			}
		}
	}, setAutoScroll:function (inAutoScroll) {
		this._xscrollX = false;
		this._xscrollY = false;
		this.inherited(arguments);
		this.reflow();
	}, adjustSetSizeProp:function (n, v) {
		if (n == "height" && this.fitToContentHeight && this.getPreferredFitToContentHeight) {
			return this.getPreferredFitToContentHeight() + "px";
		}
		if (n == "width" && this.fitToContentWidth && this.getPreferredFitToContentWidth) {
			return this.getPreferredFitToContentWidth() + "px";
		}
		return v;
	}, reflow:function () {
		this._boundsDirty = true;
		if (!this.isReflowEnabled()) {
			return;
		}
		if (this.parent && (this.fitToContent || this.parent.fitToContent)) {
			if (this._needsFitToContent) {
				delete this._needsFitToContent;
			}
			this.parent.reflow();
		} else {
			this.flow();
		}
	}, flow:function () {
		if (this._boundsDirty && this.isReflowEnabled()) {
			this.layout.flow(this, false);
		}
	}, renderControls:function () {
		for (var i = 0, c; c = this.c$[i]; i++) {
			c.renderBounds();
		}
	}, forEachControl:function (inFunc, paramArray) {
		dojo.forEach(this.c$, function (inControl) {
			inFunc.apply(inControl, (paramArray) ? paramArray : []);
		});
	}, nodeBoundsChange:function () {
	}, imageListChanged:function () {
		for (var i = 0, c; c = this.c$[i]; i++) {
			wm.fire(c, "imageListChanged");
		}
	}, setImageList:function (inImageList) {
		this.imageList = inImageList;
		this.imageListChanged();
	}, validate:function () {
		this.setValue("invalid", this.getInvalid());
		wm.fire(this.parent, "validate");
	}, getInvalid:function () {
		for (var i in this.widgets) {
			var w = this.widgets[i];
			if (w.invalid) {
				return true;
			} else {
				if (w.invalid === undefined && w.getInvalid && w.getInvalid()) {
					return true;
				}
			}
		}
		if (dojo.isFunction(this.customGetValidate)) {
			return !this.customGetValidate();
		}
		return false;
	}, customGetValidate:function () {
		return true;
	}, getInvalidWidget:function () {
		for (var i in this.widgets) {
			var w = this.widgets[i];
			if (wm.isInstanceType(w, wm.Editor) || wm.isInstanceType(w, wm.AbstractEditor)) {
				if (w.getInvalid()) {
					return w;
				}
			} else {
				if (wm.isInstanceType(w, wm.Container)) {
					var tmp = w.getInvalidWidget();
					if (tmp) {
						return tmp;
					}
				}
			}
		}
		return null;
	}, getLock:function () {
		return this.lock || (this.parent && wm.fire(this.parent, "getLock"));
	}, setLock:function (inLock) {
		var original = this.lock;
		this.lock = inLock;
		if (window["studio"] && (this.lock != original || this.lock)) {
			studio.refreshComponentOnTree(this);
		}
	}, getFreeze:function () {
		return this.freeze || this.getLock();
	}, isWidgetTypeAllowed:function (inType) {
		return true;
	}, _reorientChildren:function (inBox) {
		var parentNode = this.containerNode || this.domNode;
		wm.forEachProperty(this.widgets, function (w) {
			if (w.domNode.parentNode != parentNode) {
				return;
			}
			var ww = w.width;
			w.width = w.height;
			w.height = ww;
			w.updateBounds();
		});
	}, clearData:function () {
		var clear = function (w) {
			if (w instanceof wm.Editor) {
				w.clear();
			}
		};
		wm.forEachWidget(this, clear);
	}, getCurrentMaxWidth:function () {
		if (!this.parent || !this.parent.getCurrentMaxWidth) {
			return this.bounds.w - this.padBorderMargin.l - this.padBorderMargin.r;
		} else {
			if (this.fitToContent) {
				return this.parent.getCurrentMaxWidth();
			} else {
				if (this._percEx.w && this.layoutKind == "top-to-bottom") {
					return this.parent.getCurrentMaxWidth();
				} else {
					if (this._percEx.w && this.layoutKind == "top-to-bottom") {
						var maxWidth = this.parent.layout.getMaxFreeSpace(this.parent.c$, "w", this.parent.bounds.w - this.parent.padBorderMargin.l - this.parent.padBorderMargin.r);
						return maxWidth + this.bounds.w;
					} else {
						return this.bounds.w - this.padBorderMargin.l - this.padBorderMargin.r;
					}
				}
			}
		}
	}, getCurrentMaxHeight:function () {
		if (!this.parent || !this.parent.getCurrentMaxHeight) {
			return this.bounds.h - this.padBorderMargin.t - this.padBorderMargin.b;
		} else {
			if (this.fitToContent) {
				return this.parent.getCurrentMaxHeight();
			} else {
				if (this._percEx.h && this.layoutKind == "left-to-right") {
					return this.parent.getCurrentMaxHeight();
				} else {
					if (this._percEx.h && this.layoutKind == "top-to-bottom") {
						var maxHeight = this.parent.layout.getMaxFreeSpace(this.parent.c$, "h", this.parent.bounds.h - this.parent.padBorderMargin.t - this.parent.padBorderMargin.b);
						return maxHeight + this.bounds.h;
					} else {
						return this.bounds.h - this.padBorderMargin.t - this.padBorderMargin.b;
					}
				}
			}
		}
	}});
	wm.Container.extend({listProperties:function () {
		var p = this.inherited(arguments);
		p.freeze.ignore = this.schema.freeze.ignore || this.getLock();
		return p;
	}, writeChildren:function (inNode, inIndent, inOptions) {
		var s = [];
		wm.forEach(this.getOrderedWidgets(), function (c) {
			if (wm.isDesignable(c) && !c.flags.notStreamable) {
				s.push(c.write(inIndent, inOptions));
			}
		});
		return s;
	}, suggestDropRect:function (inControl, ioInfo) {
		this.layout.suggest(this, inControl, ioInfo);
	}, suggestSize:function (inControl, ioInfo) {
		this.layout.suggestSize(this, inControl, ioInfo);
	}, designMoveControl:function (inControl, inDropInfo) {
		info = {l:inDropInfo.l, t:inDropInfo.t, i:inDropInfo.i};
		if (inControl.parent == this) {
			this.moveControl(inControl, info.i || 0);
		} else {
			var p = inControl.parent;
			inControl.setParent(this);
			inControl.designWrapper.controlParentChanged();
			this.removeControl(inControl);
			this.insertControl(inControl, info.i || 0);
			if (p) {
				p.reflow();
			}
		}
		if (this.layout.insert) {
			this.layout.insert(this, inControl, inDropInfo);
		}
		this.reflow();
	}, resizeUpdate:function (inBounds) {
		this.designWrapper._setBounds(inBounds);
	}, getPreferredFitToContentWidth:function () {
		var extra = this.padBorderMargin.r + this.padBorderMargin.l;
		var max = 0;
		var sum = 0;
		var v;
		for (var i = 0, c; c = this.c$[i]; i++) {
			if (this.layout.inFlow(c)) {
				if (c.fitToContentWidth) {
					v = c.getPreferredFitToContentWidth();
				} else {
					if (!c._percEx.w) {
						v = c.bounds.w;
					} else {
						v = c.minWidth || c.getMinWidthProp();
					}
				}
				max = Math.max(max, v);
				sum += v;
			}
		}
		var result = ((this.layoutKind == "top-to-bottom") ? max : sum) + extra;
		return Math.max(result, wm.Control.prototype.getMinWidthProp.call(this));
	}, getPreferredFitToContentHeight:function () {
		var extra = this.padBorderMargin.t + this.padBorderMargin.b;
		var max = 0;
		var sum = 0;
		var v;
		for (var i = 0, c; c = this.c$[i]; i++) {
			if (this.layout.inFlow(c)) {
				if (c.fitToContentHeight) {
					v = c.getPreferredFitToContentHeight();
				} else {
					if (!c._percEx.h) {
						v = c.bounds.h;
					} else {
						v = c.minHeight || c.getMinHeightProp();
					}
				}
				max = Math.max(max, v);
				sum += v;
			}
		}
		var result = ((this.layoutKind == "left-to-right") ? max : sum) + extra;
		return Math.max(result, wm.Control.prototype.getMinHeightProp.call(this));
	}, getMinWidthProp:function () {
		if (this.fitToContentWidth) {
			return this.getPreferredFitToContentWidth();
		} else {
			return this.inherited(arguments);
		}
	}, getMinHeightProp:function () {
		if (this.fitToContentHeight) {
			return this.getPreferredFitToContentHeight();
		} else {
			return this.inherited(arguments);
		}
	}, focusFirstEditor:function () {
		for (var i in this.widgets) {
			var w = this.widgets[i];
			if (wm.isInstanceType(w, wm.Editor) || wm.isInstanceType(w, wm.AbstractEditor)) {
				w.focus();
				return w;
			} else {
				if (wm.isInstanceType(w, wm.Container)) {
					var tmp = w.focusFirstEditor();
					if (tmp) {
						return tmp;
					}
				}
			}
		}
		return null;
	}, setIsMajorContent:function (inMajor) {
		if (inMajor) {
			this.addUserClass("wmcontentarea");
		} else {
			this.removeUserClass("wmcontentarea");
		}
	}, getIsMajorContent:function () {
		try {
			return dojo.indexOf(this._classes.domNode, "wmcontentarea") != -1;
		}
		catch (e) {
		}
	}, clearEditors:function () {
		return this.clearData();
	}});
	wm.Container.extend({layoutKind:"top-to-bottom", horizontalAlign:"justified", verticalAlign:"justified", makePropEdit:function (inName, inValue, inDefault) {
		switch (inName) {
		  case "layoutKind":
			return new wm.propEdit.Select({component:this, value:inValue, name:inName, options:wm.layout.listLayouts()});
		  case "horizontalAlign":
			return new wm.propEdit.Select({component:this, value:inValue, name:inName, options:["left", "center", "right"]});
		  case "verticalAlign":
			return new wm.propEdit.Select({component:this, value:inValue, name:inName, options:["top", "middle", "bottom"]});
		  case "themeStyleType":
			return new wm.propEdit.Select({component:this, value:inValue, name:inName, options:["", "MainContent", "EmphasizedContent", "HeaderContent"]});
		}
		return this.inherited(arguments);
	}, setLayoutKind:function (inLayoutKind) {
		if (this.layoutKind != inLayoutKind || !this.layout) {
			this.layoutKind = inLayoutKind;
			this.layout = wm.layout.cache[inLayoutKind];
		}
		if (this.isDesignLoaded()) {
			dojo.publish("LayoutKindChanged", [this]);
		}
		this.reflow();
	}, setHorizontalAlign:function (inHorizAlign) {
		this.horizontalAlign = inHorizAlign;
		this.reflow();
	}, setVerticalAlign:function (inVertAlign) {
		this.verticalAlign = inVertAlign;
		this.reflow();
	}, setFitToContentWidth:function (inFitToContent) {
		this.fitToContentWidth = inFitToContent;
		this.fitToContent = this.fitToContentWidth || this.fitToContentHeight;
		this.updateBounds();
		this.reflowParent();
		this.calcFitToContent();
		this.reflowParent();
	}, setFitToContentHeight:function (inFitToContent) {
		this.fitToContentHeight = inFitToContent;
		this.fitToContent = this.fitToContentWidth || this.fitToContentHeight;
		this.updateBounds();
		this.reflowParent();
		this.calcFitToContent();
		this.reflowParent();
	}, calcFitToContent:function () {
		if (this.fitToContentHeight) {
			this.height = this.bounds.h + "px";
			this._percEx.h = 0;
		}
		if (this.fitToContentWidth) {
			this.width = this.bounds.w + "px";
			this._percEx.w = 0;
		}
	}});
	wm.Object.extendSchema(wm.Container, {layoutKind:{group:"layout", order:100}, horizontalAlign:{group:"layout", order:110}, verticalAlign:{group:"layout", order:120}, fitToContent:{ignore:true}, fitToContentWidth:{group:"advanced layout", order:90, shortname:"Auto Width"}, fitToContentHeight:{group:"advanced layout", order:91, shortname:"Auto Height"}, autoScroll:{group:"scrolling", order:100, ignore:0}, isMajorContent:{group:"style", order:150, ignore:1}, themeStyleType:{ignore:true, group:"style", order:150}});
}
if (!dojo._hasResource["wm.base.widget.Panel"]) {
	dojo._hasResource["wm.base.widget.Panel"] = true;
	dojo.provide("wm.base.widget.Panel");
	dojo.declare("wm.Panel", wm.Container, {classNames:"wmcontainer wmpanel", setThemeStyleType:function (inType) {
		var widgetsjs = this.write("");
		widgetsjs = dojo.fromJson(widgetsjs.replace(/^.*?\:/, ""));
		var name = this.name;
		var parent = this.parent;
		var owner = this.owner;
		var indexInParent = dojo.indexOf(this.parent.c$, this);
		this.destroy();
		var clone = parent.createComponent(name, "wm." + inType + "Panel", widgetsjs[1], widgetsjs[2], widgetsjs[3], owner);
		parent.moveControl(clone, indexInParent);
		parent.reflow();
		studio.refreshWidgetsTree();
		studio.select(clone);
	}, getThemeStyleType:function () {
		return this.declaredClass.replace(/^wm\.(.*)Panel/, "$1");
	}});
	dojo.declare("wm.MainContentPanel", wm.Panel, {classNames:"wmcontainer wmpanel MainContent"});
	dojo.declare("wm.EmphasizedContentPanel", wm.Panel, {classNames:"wmcontainer wmpanel EmphasizedContent"});
	dojo.declare("wm.HeaderContentPanel", wm.Panel, {classNames:"wmcontainer wmpanel HeaderContent"});
	wm.Object.extendSchema(wm.Panel, {themeStyleType:{group:"style", order:150}, });
	dojo.declare("wm.FancyPanel", wm.Panel, {freeze:true, classNames:"wmcontainer wmfancypanel", title:"パネルヘッダ", labelWidget:null, containerWidget:null, layoutKind:"top-to-bottom", innerLayoutKind:"top-to-bottom", innerHorizontalAlign:"left", innerVerticalAlign:"top", margin:"6", padding:"0", border:"0", innerBorder:"3", borderColor:"#404040", width:"100%", height:"100%", _topImgWidth:0, _bottomImgWidth:0, labelHeight:30, themeStyleType:"ContentPanel", init:function () {
		var classes = this._classes;
		var containerClasses = {domNode:[]};
		for (var i = classes.domNode.length - 1; i >= 0; i--) {
			if (classes.domNode[i].match(/^wm_Border_(Bottom|Drop)/)) {
				containerClasses.domNode.push(classes.domNode[i]);
				wm.Array.removeElementAt(classes.domNode, i);
			}
		}
		this._classes = {domNode:[]};
		try {
			this.layout = wm.layout.cache["top-to-bottom"];
			this.inherited(arguments);
			this.labelWidget = new wm.Label({border:this.innerBorder, borderColor:this.borderColor, showing:Boolean(this.title), _classes:classes, name:"labelWidget", caption:this.title, width:"100%", height:this.labelHeight + "px", padding:"0,0,0,10", owner:this, parent:this, noInspector:true});
			var innerBorder = String(this.innerBorder);
			innerBorder = this._parseExtents(innerBorder);
			this.containerWidget = new wm.Container({_classes:containerClasses, name:"containerWidget", layoutKind:this.innerLayoutKind, width:"100%", height:"100%", owner:this, parent:this, noInspector:true, autoScroll:true, horizontalAlign:this.innerHorizontalAlign, verticalAlign:this.innerVerticalAlign, fitToContentHeight:this.fitToContentHeight, fitToContentWidth:this.fitToContentWidth, border:"0," + innerBorder.r + "," + innerBorder.b + "," + innerBorder.l, borderColor:this.borderColor});
			this.containerWidget.setLayoutKind(this.innerLayoutKind);
			this.widgets.labelWidget = this.labelWidget;
			this.widgets.containerWidget = this.containerWidget;
			this.setTitle(this.title);
		}
		catch (e) {
			alert("PANEL:" + e);
		}
	}, setFitToContentHeight:function (inValue) {
		this.inherited(arguments);
		if (this.containerWidget) {
			this.containerWidget.setFitToContentHeight(inValue);
		}
	}, setFitToContentWidth:function (inValue) {
		this.inherited(arguments);
		if (this.containerWidget) {
			this.containerWidget.setFitToContentWidth(inValue);
		}
	}, setBorder:function (inBorder) {
		wm.Control.prototype.setBorder.call(this, "0");
	}, setShowing:function (inShowing) {
		this.inherited(arguments);
		if (dojo.isIE < 9) {
			if (this._topLeftCornerImg) {
				this._topLeftCornerImg.style.display = (this.showing) ? "block" : "none";
				this._topRightCornerImg.style.display = (this.showing) ? "block" : "none";
			}
			if (this._bottomLeftCornerImg) {
				this._bottomLeftCornerImg.style.display = (this.showing) ? "block" : "none";
				this._bottomRightCornerImg.style.display = (this.showing) ? "block" : "none";
			}
		}
	}, getMinHeightProp:function () {
		if (this.minHeight) {
			return this.minHeight;
		}
		if (!this.containerWidget) {
			return this.inherited(arguments);
		}
		return this.containerWidget.getMinHeightProp() + ((this.labelWidget && this.labelWidget.showing) ? this.labelWidget.bounds.h : 0) + 30;
	}, getPreferredFitToContentWidth:function () {
		var extra = this.padBorderMargin.r + this.padBorderMargin.l;
		var max = 0;
		var sum = 0;
		var v;
		for (var i = 0, c; c = this.c$[i]; i++) {
			if (this.layout.inFlow(c)) {
				if (c instanceof wm.Container) {
					if (c.fitToContentWidth || c._percEx.w) {
						v = c.getPreferredFitToContentWidth();
					} else {
						v = c.bounds.w;
					}
				} else {
					if (c._percEx.w) {
						v = c.getMinWidthProp();
					} else {
						v = c.bounds.w;
					}
				}
				max = Math.max(max, v);
				sum += v;
			}
		}
		var result = ((this.layoutKind == "top-to-bottom") ? max : sum) + extra;
		return Math.max(result, 30);
	}, getPreferredFitToContentHeight:function () {
		var extra = this.padBorderMargin.t + this.padBorderMargin.b;
		var max = 0;
		var sum = 0;
		var v;
		for (var i = 0, c; c = this.c$[i]; i++) {
			if (this.layout.inFlow(c)) {
				if (c instanceof wm.Container) {
					if (c.fitToContentHeight || c._percEx.h) {
						v = c.getPreferredFitToContentHeight();
					} else {
						v = c.bounds.h;
					}
				} else {
					if (c.fitToContentHeight || c._percEx.h) {
						v = c.getMinHeightProp();
					} else {
						v = c.bounds.h;
					}
				}
				max = Math.max(max, v);
				sum += v;
			}
		}
		var result = ((this.layoutKind == "left-to-right") ? max : sum) + extra;
		return Math.max(result, 15);
	}, destroy:function () {
		if (dojo.isIE < 9) {
			if (this._topLeftCornerImg) {
				dojo.destroy(this._topLeftCornerImg);
				dojo.destroy(this._topRightCornerImg);
			}
			if (this._bottomLeftCornerImg) {
				dojo.destroy(this._bottomLeftCornerImg);
				dojo.destroy(this._bottomRightCornerImg);
			}
		}
		this.inherited(arguments);
	}, flow:function () {
		this.inherited(arguments);
		if (dojo.isIE < 9) {
			this.renderCorners();
		}
	}, renderCorners:function () {
		if (!this._topLeftCornerImg) {
			return;
		}
		if (this._topLeftCornerImg.className.match(/px/)) {
			this._topLeftCornerImg.style.top = this._topRightCornerImg.style.top = (this.bounds.t + this.marginExtents.t) + "px";
			this._topLeftCornerImg.style.left = (this.bounds.l + this.marginExtents.l) + "px";
			this._topRightCornerImg.style.left = (this.bounds.r - this._topImgWidth - this.marginExtents.r) + "px";
		}
		if (this._bottomLeftCornerImg.className.match(/px/)) {
			this._bottomLeftCornerImg.style.top = this._bottomRightCornerImg.style.top = (this.bounds.b - this.marginExtents.b - this._bottomImgHeight) + "px";
			this._bottomLeftCornerImg.style.left = (this.bounds.l + this.marginExtents.l) + "px";
			this._bottomRightCornerImg.style.left = (this.bounds.r - this._bottomImgWidth - this.marginExtents.r) + "px";
		}
	}, postInit:function () {
		var changeParents = [];
		for (var i = 0; i < this.c$.length; i++) {
			var c = this.c$[i];
			if (this.$[c.name] != c && c instanceof wm.Control) {
				changeParents.push(c);
			}
		}
		for (var i = 0; i < changeParents.length; i++) {
			var c = changeParents[i];
			c.setParent(this.containerWidget);
			if (c.designWrapper) {
				c.designWrapper.controlParentChanged();
			}
		}
		this.inherited(arguments);
	}, writeComponents:function (inIndent, inOptions) {
		var result = [];
		if (this.containerWidget) {
			result = result.concat(this.containerWidget.writeComponents(inIndent, inOptions));
		}
		if (this.components.binding) {
			result = result.concat(this.components.binding.write(inIndent, inOptions));
		}
		return result;
	}, setInnerHorizontalAlign:function (inAlign) {
		this.innerHorizontalAlign = inAlign;
		if (this.containerWidget) {
			this.containerWidget.setHorizontalAlign(inAlign);
		}
	}, setInnerVerticalAlign:function (inAlign) {
		this.innerVerticalAlign = inAlign;
		if (this.containerWidget) {
			this.containerWidget.setVerticalAlign(inAlign);
		}
	}, setInnerLayoutKind:function (inKind) {
		this.innerLayoutKind = inKind;
		if (this.containerWidget) {
			this.containerWidget.setLayoutKind(inKind);
		}
	}, setInnerBorder:function (inBorder) {
		inBorder = String(inBorder);
		this.innerBorder = inBorder;
		this.labelWidget.setBorder(inBorder);
		var b = this._parseExtents(inBorder);
		this.containerWidget.setBorder("0," + b.r + "," + b.b + "," + b.l);
	}, setLayoutKind:function (inKind) {
		wm.Panel.prototype.setLayoutKind.call(this, "top-to-bottom");
		if (this.containerWidget) {
			this.setInnerLayoutKind(inKind);
		}
	}, setTitle:function (inTitle) {
		var oldTitle = this.title;
		this.title = inTitle;
		if (this.containerWidget) {
			this.labelWidget.setCaption(inTitle);
			this.labelWidget.setShowing(Boolean(inTitle));
		}
	}, setThemeStyleType:function (inMajor) {
		this.containerWidget.setThemeStyleType(inMajor);
		this.themeStyleType = inMajor;
	}, setLabelHeight:function (inHeight) {
		this.labelHeight = inHeight;
		this.labelWidget.setHeight(inHeight);
	}});
	wm.Panel.extend({themeable:false, afterPaletteDrop:function () {
		this.inherited(arguments);
		if (this instanceof wm.FancyPanel) {
			return;
		}
		var v = "top-to-bottom", h = "left-to-right", pv = (this.parent.layoutKind == v);
		this.setLayoutKind(pv ? h : v);
		if (pv) {
			this.setWidth("100%");
		} else {
			this.setHeight("100%");
		}
	}});
	wm.FancyPanel.extend({themeable:true, themeableProps:["innerBorder", "borderColor", "labelHeight"], makePropEdit:function (inName, inValue, inDefault) {
		switch (inName) {
		  case "innerLayoutKind":
			return new wm.propEdit.Select({component:this, value:inValue, name:inName, options:wm.layout.listLayouts()});
		  case "innerHorizontalAlign":
			return new wm.propEdit.Select({component:this, value:inValue, name:inName, options:["left", "center", "right"]});
		  case "innerVerticalAlign":
			return new wm.propEdit.Select({component:this, value:inValue, name:inName, options:["top", "middle", "bottom"]});
		}
		return this.inherited(arguments);
	}});
	wm.Object.extendSchema(wm.FancyPanel, {title:{type:"String", bindable:1, group:"display", order:100, focus:true}, labelWidget:{ignore:1}, themeStyleType:{ignore:1}, containerWidget:{ignore:1}, layoutKind:{ignore:1}, innerLayoutKind:{group:"layout", order:100, shortname:"layoutKind"}, innerHorizontalAlign:{group:"layout", order:101, shortname:"horizontalAlign"}, innerVerticalAlign:{group:"layout", order:101, shortname:"verticalAlign"}, padding:{ignore:1}, labelHeight:{group:"layout", order:90}, border:{ignore:1}, innerBorder:{group:"style", shortname:"border"}});
	wm.Panel.description = "A container for widgets.";
}
if (!dojo._hasResource["wm.base.widget.Template"]) {
	dojo._hasResource["wm.base.widget.Template"] = true;
	dojo.provide("wm.base.widget.Template");
	dojo.declare("wm.Template", wm.Container, {layoutKind:"top-to-bottom", init:function () {
		this.readTemplate();
		this.inherited(arguments);
	}, readTemplate:function () {
		if (this._template) {
			if (dojo.isObject(this._template)) {
				this._template = dojo.toJson(this._template);
			}
			this.readComponents(this._template);
		}
	}, adjustChildProps:function (inCtor, inProps) {
		if (wm.isClassInstanceType(inCtor, wm.Control)) {
			this.inherited(arguments);
		} else {
			dojo.mixin(inProps, {owner:this.owner});
		}
	}});
	wm.Template.extend({themeable:false});
	wm.Template.description = "A set of built from a template.";
}
if (!dojo._hasResource["wm.base.widget.Layout"]) {
	dojo._hasResource["wm.base.widget.Layout"] = true;
	dojo.provide("wm.base.widget.Layout");
	dojo.declare("wm.Layout", wm.Container, {classNames:"wmlayout", autoScroll:true, fit:false, width:"", height:"", create:function () {
		this.inherited(arguments);
	}, build:function () {
		this.inherited(arguments);
		this.domNode.style.cssText += this.style + "overflow: hidden; position: relative;";
	}, init:function () {
		this.inherited(arguments);
		this.subscribe("window-resize", this, "resize");
	}, fitTo:function () {
		if (this.domNode === document.body) {
			document.body.scrollTop = 0;
		}
		var pn = this.domNode.parentNode;
		if (pn && !wm.isEmpty(this.fit)) {
			pn.scrollTop = 0;
			var n = dojo.contentBox(pn), b = {}, f = this.fit;
			b.l = n.l;
			b.t = n.t;
			for (var i in f) {
				if (f[i]) {
					b[i] = n[i];
				}
			}
			dojo.marginBox(this.domNode, b);
		}
	}, resize:function () {
		if (!this.parent) {
			this.reflow();
		}
	}, updateBounds:function () {
		this._percEx = {w:100, h:100};
		if (!this.parent) {
			var pn = this.domNode.parentNode;
			this.setBounds(0, 0, pn.offsetWidth, pn.offsetHeight);
		} else {
			this.setBounds(this.parent.getContentBounds());
		}
	}, reflow:function () {
		if (this._cupdating) {
			return;
		}
		this.updateBounds();
		this.renderBounds();
		this.inherited(arguments);
	}});
	wm.Object.extendSchema(wm.Layout, {themeStyleType:{group:"style", order:150}, fitToContent:{ignore:1}, fitToContentWidth:{ignore:1}, fitToContentHeight:{ignore:1}, minWidth:{ignore:1}, minHeight:{ignore:1}, fit:{ignore:1}});
	wm.LayoutBox = wm.Layout;
	dojo.extend(wm.Layout, {themeable:true, themeableStyles:["Document-Styles-BorderStyle_Radius", "Document-Styles-BorderStyle_Shadow"]});
}
if (!dojo._hasResource["wm.base.widget.Content"]) {
	dojo._hasResource["wm.base.widget.Content"] = true;
	dojo.provide("wm.base.widget.Content");
	dojo.declare("wm.Content", wm.Box, {width:"100%", height:"200px", scrim:true, autoScroll:true, allowDuplicateContent:false, content:"", resource:"", init:function () {
		this.inherited(arguments);
		this.setContent(this.content);
	}, setContent:function (inContent) {
		this.content = inContent;
		this.contentChanged(true);
	}, setResource:function (inResourcePath) {
		this.resource = inResourcePath;
		this.contentChanged();
	}, _makeContentNode:function () {
		var c = this.content && dojo.byId(this.content), n = c ? (this.allowDuplicateContent ? c.cloneNode(true) : c) : document.createElement("div");
		dojo.addClass(n, "wmcontent");
		return n;
	}, contentChanged:function (forceUpdate) {
		if (!forceUpdate && this.isDesignedComponent() && this.owner != studio.page) {
			return;
		}
		var dn = this.domNode;
		if (dn.firstChild) {
			dn.removeChild(dn.firstChild);
		}
		if (this.resource) {
			var root = this.resource.slice(0, 4) != "http" && this.resource.slice(0, 1) != "/" ? this.getPath() : "";
			if (!this.htmlLoader) {
				this.htmlLoader = new wm.HtmlLoader({owner:this, relativeUrl:true});
			}
			this.htmlLoader._htmlNode = this.domNode;
			this.htmlLoader.setUrl(root + this.resource);
		} else {
			var n = this._makeContentNode();
			dn.appendChild(n);
		}
	}});
}
if (!dojo._hasResource["wm.base.widget.Content_design"]) {
	dojo._hasResource["wm.base.widget.Content_design"] = true;
	dojo.provide("wm.base.widget.Content_design");
	wm.Content.description = "Displays markup content.";
	wm.Object.extendSchema(wm.Content, {resource:{type:"String", subtype:"File", bindable:true, extensionMatch:["html", "txt"]}, disabled:{ignore:1}, allowDuplicateContent:{ignore:1}});
	wm.Content.extend({themeable:false, designCreate:function () {
		this.inherited(arguments);
		this.subscribe("wm-markupchanged", dojo.hitch(this, "contentChanged"));
	}, designDestroy:function () {
		this.releaseContentNode(this.domNode, this.content);
		this.inherited(arguments);
	}, set_content:function (inContent) {
		var old = this.domNode.firstChild, oldId = this.content;
		this.setContent(inContent);
		this.releaseContentNode(old, oldId);
	}, releaseContentNode:function (inNode, inContentId) {
		if (inNode && inContentId && !this.allowDuplicateContent) {
			inNode.id = inContentId;
			dojo.publish("wm-content-markupchanged", [inNode]);
		}
	}, makePropEdit:function (inName, inValue, inDefault) {
		if (inName == "content") {
			return makeMarkupIdsPropEdit(inName, inValue, inDefault);
		}
		return this.inherited(arguments);
	}});
}
if (!dojo._hasResource["wm.base.widget.Html"]) {
	dojo._hasResource["wm.base.widget.Html"] = true;
	dojo.provide("wm.base.widget.Html");
	dojo.declare("wm.Html", wm.Box, {html:"", autoScroll:true, init:function () {
		dojo.addClass(this.domNode, "wmhtml");
		this.inherited(arguments);
		this.connect(this.domNode, "onclick", this, "onclick");
		this.setHtml(this.html);
	}, getHtml:function () {
		return this.domNode.innerHTML;
	}, setHtml:function (inHtml) {
		var innerHTML = this.domNode.innerHTML;
		if (inHtml && inHtml.indexOf("resources/") == 0) {
			if (!this.htmlLoader) {
				this.htmlLoader = new wm.HtmlLoader({owner:this, relativeUrl:true});
			}
			this.htmlLoader._htmlNode = this.domNode;
			this.htmlLoader.setUrl(inHtml);
			this.html = inHtml;
			if (innerHTML != this.domNode.innerHTML && (this.autoSizeHeight || this.autoSizeWidth)) {
				this.doAutoSize(1, 1);
			}
			return;
		}
		if (inHtml && dojo.isArray(inHtml)) {
			inHtml = inHtml.join("");
		}
		if (inHtml && inHtml.value) {
			inHtml = inHtml.value;
		}
		this.html = this.domNode.innerHTML = (inHtml == undefined ? "" : inHtml);
		if (innerHTML != this.domNode.innerHTML && (this.autoSizeHeight || this.autoSizeWidth)) {
			this.doAutoSize(1, 1);
		}
	}, doAutoSize:function (setSize, force) {
		if (this._doingAutoSize || !this.autoSizeHeight && !this.autoSizeWidth) {
			return;
		}
		if (!force && !this._needsAutoSize) {
			return;
		}
		if (this.isAncestorHidden()) {
			return;
		}
		this._doingAutoSize = true;
		this._needsAutoSize = false;
		var divObj = wm.Label.sizingNode;
		divObj.innerHTML = this.html;
		divObj.className = this.domNode.className;
		var b = this.bounds;
		var s = divObj.style;
		s.position = "absolute";
		s.height = (!this.autoSizeHeight) ? (b.h - this.padBorderMargin.t - this.padBorderMargin.b) + "px" : "";
		s.width = (!this.autoSizeWidth) ? (b.w - this.padBorderMargin.l - this.padBorderMargin.r) + "px" : "";
		s.paddingLeft = (this.autoSizeWidth) ? (this.padBorderMargin.l + this.padBorderMargin.r) + "px" : "";
		s.paddingTop = (this.autoSizeHeight) ? (this.padBorderMargin.t + this.padBorderMargin.b) + "px" : "";
		s.lineHeight = "normal";
		s.whiteSpace = "";
		this.parent.domNode.appendChild(divObj);
		var captionWidth = divObj.clientWidth;
		var captionHeight = divObj.clientHeight;
		divObj.parentNode.removeChild(divObj);
		if (this.autoSizeHeight) {
			var newh = this.padBorderMargin.t + this.padBorderMargin.b + captionHeight;
			if (newh < 14) {
				newh = 14;
			}
			if (setSize) {
				this.setHeight(newh + "px");
			} else {
				this.bounds.h = newh;
				this.height = newh + "px";
			}
		}
		if (this.autoSizeWidth) {
			var neww = this.padBorderMargin.l + this.padBorderMargin.r + captionWidth;
			if (neww < 80) {
				neww = 80;
			}
			if (setSize) {
				this.setWidth(neww + "px");
			} else {
				this.bounds.w = neww;
				this.width = neww + "px";
			}
		}
		if (this.isDesignLoaded() && studio.designer.selected == this) {
			studio.inspector.reinspect();
		}
		this._doingAutoSize = false;
	}, appendHtml:function (inHtml) {
		if (inHtml && dojo.isArray(inHtml)) {
			inHtml = inHtml.join("");
		}
		if (inHtml && inHtml.value) {
			inHtml = inHtml.value;
		}
		this.domNode.innerHTML += (inHtml == undefined ? "" : inHtml);
		this.html = this.domNode.innerHTML;
	}, onclick:function () {
	}, addUserClass:function (inClass, inNodeName) {
		this.inherited(arguments);
		if (this.isDesignLoaded()) {
			if (this.autoSizeHeight || this.autoSizeWidth) {
				this.doAutoSize(1, 1);
			}
		}
	}, makePropEdit:function (inName, inValue, inDefault) {
		switch (inName) {
		  case "autoSizeWidth":
			return makeSelectPropEdit(inName, (this.autoSizeHeight) ? "height" : (this.autoSizeWidth) ? "width" : "none", ["none", "width", "height"], inDefault);
		}
		return this.inherited(arguments);
	}, setAutoSizeWidth:function (inValue) {
		if (this.autoSizeHeight && inValue != "height") {
			this.setAutoScroll(true);
		}
		if (inValue == "none") {
			wm.Control.prototype.setAutoSizeWidth.call(this, false);
			this.setAutoSizeHeight(false);
		} else {
			if (inValue == "width") {
				this.setAutoSizeHeight(false);
				wm.Control.prototype.setAutoSizeWidth.call(this, true);
			} else {
				if (inValue == "height") {
					this.setAutoScroll(false);
					wm.Control.prototype.setAutoSizeWidth.call(this, false);
					this.setAutoSizeHeight(true);
				}
			}
		}
	}});
	wm.Html.description = "Container for any HTML content.";
	wm.Object.extendSchema(wm.Html, {disabled:{ignore:1}, autoSizeHeight:{type:"Boolean", group:"advanced layout", order:31, writeonly:true, ignore:true}, autoSizeWidth:{type:"Boolean", group:"advanced layout", order:32, shortname:"Auto Size"}, autoScroll:{group:"style", order:100, ignore:0}, html:{type:"String", bindable:1, group:"display", order:100, focus:true}});
	wm.Html.extend({themeable:false});
}
if (!dojo._hasResource["wm.base.widget.Bevel"]) {
	dojo._hasResource["wm.base.widget.Bevel"] = true;
	dojo.provide("wm.base.widget.Bevel");
	dojo.declare("wm.Bevel", wm.Widget, {className:"wmbevel", flex:0, bevelSize:4, init:function () {
		this.inherited(arguments);
	}, getOrientedStyleName:function () {
		return this.className + " " + this.className + (this.vertical ? "-h" : "-v");
	}, addOrientation:function () {
		dojo.addClass(this.domNode, this.getOrientedStyleName());
	}, removeOrientation:function () {
		dojo.removeClass(this.domNode, this.getOrientedStyleName());
	}, updateSize:function () {
		var h = (this.parent || 0).layoutKind == "left-to-right", d = this.bevelSize + "px";
		this.setWidth(h ? d : "100%");
		this.setHeight(h ? "100%" : d);
	}, setParent:function () {
		this.inherited(arguments);
		this.addOrientation();
		this.updateSize();
	}});
	wm.Object.extendSchema(wm.Bevel, {vertical:{ignore:1}, disabled:{ignore:1}, border:{ignore:1}, borderColor:{ignore:1}, margin:{ignore:1}, padding:{ignore:1}, scrollX:{ignore:1}, scrollY:{ignore:1}, minWidth:{ignore:1}, minHeight:{ignore:1}});
	wm.Bevel.extend({themeableProps:["bevelSize", "border", "borderColor"], scrim:true, sizeable:false});
}
if (!dojo._hasResource["wm.base.widget.Splitter"]) {
	dojo._hasResource["wm.base.widget.Splitter"] = true;
	dojo.provide("wm.base.widget.Splitter");
	dojo.declare("wm.SplitterResize", wm.MouseDrag, {beginResize:function (e, inSplitter) {
		this.splitter = inSplitter;
		this.setCursor(this.splitter.vertical ? "w-resize" : "n-resize");
		this.mousedown(e);
	}, drag:function () {
		this.inherited(arguments);
		this.splitter.drag(this.dx, this.dy);
	}, finish:function () {
		this.inherited(arguments);
		this.splitter.drop();
	}});
	dojo.declare("wm.Splitter", wm.Bevel, {className:"wmsplitter", minimum:-1, maximum:-1, mode:dojo.isMoz || dojo.isIE ? 2 : 0, layout:"", constructor:function () {
		wm.Splitter.resizer = wm.Splitter.resizer || new wm.SplitterResize();
	}, init:function () {
		this.inherited(arguments);
		this.findLayout();
		this.connectEvents(this.domNode, ["mousedown", "dblclick"]);
	}, findLayout:function () {
		var v = (this.parent || 0).layoutKind == "left-to-right", p = this.parent.prevSibling(this);
		if (p) {
			var l = v ? (p.width == "100%" ? "right" : "left") : (p.height == "100%" ? "bottom" : "top");
			this.setLayout(l);
		}
	}, setLayout:function (inLayout) {
		this.layout = inLayout;
		this.removeOrientation();
		this.vertical = this.layout == "left" || this.layout == "right";
		this.addOrientation();
		this.updateSize();
	}, getSizeControl:function () {
		switch (this.layout) {
		  case "left":
		  case "top":
			return this.parent.prevSibling(this);
		  case "right":
		  case "bottom":
			return this.parent.nextSibling(this);
		}
	}, getPosition:function () {
		return {top:this.bounds.t, left:this.bounds.l};
	}, mousedown:function (e) {
		this.sizeControl = this.getSizeControl();
		if (!this.sizeControl) {
			return;
		}
		this.size = this.sizeControl.cloneBounds();
		this.containerSize = this.sizeControl.parent.cloneBounds();
		this.initialPosition = this.getPosition();
		this.position = this.getPosition();
		wm.Splitter.resizer.beginResize(e, this);
	}, drag:function (inDx, inDy) {
		if (this.vertical) {
			this.moveX(inDx);
		} else {
			this.moveY(inDy);
		}
		this.changing();
	}, drop:function () {
		this.change();
	}, changing:function () {
		this._collapsed = false;
		switch (this.mode) {
		  case 0:
			this.adjustSize();
			this.reflowParent();
			break;
		  default:
			break;
		}
	}, change:function () {
		this.adjustSize();
		this.reflowParent();
	}, boundValue:function (inValue) {
		var x = inValue;
		if (this.minimum != -1) {
			inValue = Math.max(this.minimum, inValue);
		}
		if (this.maximum != -1) {
			inValue = Math.min(this.maximum, inValue);
		}
		this.atLimit = (x != inValue);
		return inValue;
	}, adjustSize:function () {
		var dx = this.position.left - this.initialPosition.left, dy = this.position.top - this.initialPosition.top;
		var w = this.size.w + (this.layout == "right" ? -dx : dx), h = this.size.h + (this.layout == "bottom" ? -dy : dy);
		this.sizeControl.setBounds(NaN, NaN, w, h);
	}, move:function (inD, inOrd, inExtent) {
		if (inD == 0) {
			return;
		}
		this.position[inOrd] = this.initialPosition[inOrd] + inD;
		if (this.layout == inOrd) {
			this.position[inOrd] = this.boundValue(this.position[inOrd]);
		} else {
			var e = this.containerSize[inExtent];
			this.position[inOrd] = e - this.boundValue(e - this.position[inOrd]);
		}
		this.domNode.style[inOrd] = this.position[inOrd] + "px";
	}, moveX:function (inDx) {
		this.move(inDx, "left", "w");
	}, moveY:function (inDy) {
		this.move(inDy, "top", "h");
	}, dblclick:function () {
		app.scrim.scrimOnIdle(this, function () {
			if (this._collapsed) {
				this.expand();
			} else {
				this.collapse();
			}
		});
	}, collapse:function () {
		this._collapsed = true;
		this.initialPosition = this.getPosition();
		this._expandedPosition = dojo.mixin({}, this.initialPosition);
		switch (this.layout) {
		  case "left":
			this.position.left = 0;
			break;
		  case "top":
			this.position.top = 0;
			break;
		  case "right":
			this.position.left = this.boundValue(this.position.left + this.size.w);
			break;
		  case "bottom":
			this.position.top = this.boundValue(this.position.top + this.size.h);
			break;
		}
		this.change();
	}, expand:function () {
		this._collapsed = false;
		this.initialPosition = this.getPosition();
		dojo.mixin(this.position, this._expandedPosition);
		this.change();
	}});
	wm.Object.extendSchema(wm.Splitter, {left:{ignore:1}, height:{ignore:1}, top:{ignore:1}, mode:{ignore:1}, border:{ignore:1}, borderColor:{ignore:1}, margin:{ignore:1}, padding:{ignore:1}, minWidth:{ignore:1}, minHeight:{ignore:1}, minimum:{group:"layout", order:1}, maximum:{group:"layout", order:5}});
}
if (!dojo._hasResource["wm.base.widget.Splitter_design"]) {
	dojo._hasResource["wm.base.widget.Splitter_design"] = true;
	dojo.provide("wm.base.widget.Splitter_design");
	wm.Splitter.extend({makePropEdit:function (inName, inValue, inDefault) {
		switch (inName) {
		  case "layout":
			return makeSelectPropEdit(inName, inValue, ["top", "left", "bottom", "right"], inDefault);
		}
		return this.inherited(arguments);
	}});
	wm.Object.extendSchema(wm.Splitter, {layout:{ignore:1}});
}
if (!dojo._hasResource["wm.base.widget.Layers.Decorator"]) {
	dojo._hasResource["wm.base.widget.Layers.Decorator"] = true;
	dojo.provide("wm.base.widget.Layers.Decorator");
	dojo.declare("wm.LayersDecorator", null, {decorationClass:"", constructor:function (inDecoree) {
		this.decoree = inDecoree;
	}, destroy:function () {
		this.decoree = null;
	}, decorate:function () {
		this.decorateContainer();
		this.decorateLayers();
	}, decorateContainer:function () {
		var d = this.decoree;
		dojo.addClass(d.domNode, this.decorationClass);
	}, decorateLayers:function () {
		dojo.forEach(this.decoree.layers, function (l, i) {
			this.decorateLayer(l, i);
		}, this);
	}, decorateLayer:function (inLayer, inIndex) {
		inLayer.decorator = this;
	}, undecorate:function () {
		this.undecorateContainer();
		var layers = this.decoree.layers;
		for (var i = layers.length - 1; i >= 0; i--) {
			this.undecorateLayer(layers[i], i);
		}
	}, undecorateContainer:function () {
		dojo.removeClass(this.decoree.domNode, this.decorationClass);
	}, undecorateLayer:function () {
	}, setLayerShowing:function (inLayer, inShowing) {
		wm.Control.prototype.setShowing.call(inLayer, inShowing);
	}, setLayerActive:function (inLayer, inActive) {
		if (inLayer.active == inActive) {
			return;
		}
		inLayer.inFlow = inActive;
		inLayer.active = inActive;
		var page = inLayer.getParentPage();
		if (!this.decoree._cupdating && page && !page._loadingPage && !window["studio"] && this.decoree.transition && this.decoree.transition != "none") {
			console.log("SET ACTIVE LAYER FADE!");
			if (!inActive) {
				this["anim" + wm.capitalize(this.decoree.transition)](inLayer, false);
			} else {
				this["anim" + wm.capitalize(this.decoree.transition)](inLayer, true);
			}
		} else {
			inLayer.domNode.style.display = inActive ? "" : "none";
		}
		wm.fire(inLayer, "domNodeShowingChanged", [inActive]);
	}, animSlide:function (inLayer, inShowing) {
		if (inShowing) {
			inLayer.domNode.style.opacity = "0.1";
			inLayer.domNode.style.display = "";
			inLayer.reflowParent();
			var left = inLayer.bounds.w + "px";
			inLayer.domNode.style.left = (inLayer.transitionNext) ? left : "-" + left;
			inLayer.domNode.style.opacity = 1;
		}
		var newleft = (inShowing) ? 0 : inLayer.transitionNext ? -parseInt(inLayer.domNode.style.width) : parseInt(inLayer.domNode.style.width);
		var anim = dojo.animateProperty({node:inLayer.domNode, properties:{left:newleft}, duration:350});
		dojo.connect(anim, "onEnd", function () {
			console.log("animation ended");
			if (!inShowing) {
				inLayer.domNode.style.display = "none";
				inLayer.domNode.style.left = 0;
			}
		});
		anim.play();
	}, animFade:function (inLayer, inShowing) {
		if (inShowing) {
			inLayer.domNode.style.opacity = 0.1;
			inLayer.domNode.style.display = "";
		}
		var newopacity = (inShowing) ? 1 : 0.1;
		var anim = dojo.animateProperty({node:inLayer.domNode, properties:{opacity:newopacity}, duration:350});
		dojo.connect(anim, "onEnd", function () {
			console.log("animation ended");
			if (!inShowing) {
				inLayer.domNode.style.display = "none";
				inLayer.domNode.style.opacity = 1;
			}
		});
		anim.play();
	}, activateLayer:function (inLayer) {
		var d = this.decoree;
		var old = d.getLayer(d.lastLayerIndex);
		if (old && old != inLayer) {
			old.transitionNext = inLayer.transitionNext = inLayer.getIndex() > old.getIndex();
			this.setLayerActive(old, false);
		}
		this.setLayerActive(inLayer, true);
		d.reflow();
	}, applyLayerCaption:function () {
	}, moveLayerIndex:function (inFromIndex, inToIndex) {
		var d = this.decoree, l = d.getLayer(inFromIndex);
		d.client.removeControl(l);
		d.client.insertControl(l, inToIndex);
	}});
}
if (!dojo._hasResource["wm.base.widget.Layers.TabsDecorator"]) {
	dojo._hasResource["wm.base.widget.Layers.TabsDecorator"] = true;
	dojo.provide("wm.base.widget.Layers.TabsDecorator");
	dojo.declare("wm.TabsDecorator", wm.LayersDecorator, {decorationClass:"wmtablayers", decoratorPadding:"7, 0, 0, 0", undecorate:function () {
		this.inherited(arguments);
		this.tabsControl.destroy();
	}, decorateContainer:function () {
		this.inherited(arguments);
		this.btns = [];
		this.tabsControl = new wm.TabsControl({parent:this.decoree, owner:this.decoree, padding:this.decoratorPadding});
		this.decoree.moveControl(this.tabsControl, 0);
	}, createTab:function (inCaption, inIndex, inLayer) {
		var b = this.btns[inIndex] = document.createElement("button");
		b.style.display = inLayer.showing ? "" : "none";
		this.setBtnText(b, inCaption);
		this.decoree.connect(b, "onclick", dojo.hitch(this, "tabClicked", inLayer));
		b.className = this.decorationClass + "-tab";
		this.tabsControl.domNode.appendChild(b);
	}, tabClicked:function (inLayer, e) {
		var d = this.decoree;
		if (d.isDesignLoaded()) {
			dojo.stopEvent(e);
		}
		d.setLayer(inLayer);
	}, decorateLayer:function (inLayer, inIndex) {
		this.inherited(arguments);
		this.createTab(inLayer.caption, inIndex, inLayer);
	}, undecorateLayer:function (inLayer, inIndex) {
		dojo._destroyElement(this.btns[inIndex]);
		this.btns.splice(inIndex, 1);
	}, setLayerShowing:function (inLayer, inShowing) {
		var i = inLayer.getIndex();
		if (i != -1) {
			this.btns[i].style.display = inShowing ? "" : "none";
		}
		this.inherited(arguments);
	}, setLayerActive:function (inLayer, inActive) {
		var b = this.btns[inLayer.getIndex()];
		if (b) {
			dojo[inActive ? "addClass" : "removeClass"](b, this.decorationClass + "-selected");
		}
		this.inherited(arguments);
	}, applyLayerCaption:function (inLayer) {
		var d = this.decoree, i = inLayer.getIndex();
		if (i != -1) {
			this.setBtnText(this.btns[i], inLayer.caption);
		}
	}, setBtnText:function (inBtn, inCaption) {
		inBtn.innerHTML = inCaption || "&nbsp;";
	}, getBtn:function (inCaption) {
		var d = this.decoree, i = d.indexOfLayerCaption(inCaption);
		if (i != -1) {
			return this.btns[i];
		}
	}, disenableTab:function (inCaption, inDisable) {
		var b = this.getBtn(inCaption);
		if (b) {
			b.disabled = inDisable ? "disabled" : "";
		}
	}, disableTab:function (inCaption) {
		this.disenableTab(inCaption, true);
	}, enableTab:function (inCaption) {
		this.disenableTab(inCaption, false);
	}, moveLayerIndex:function (inFromIndex, inToIndex) {
		this.inherited(arguments);
		var d = this.tabsControl.domNode, f = this.btns[inFromIndex], t = this.btns[inToIndex], c = this.decoree.getCount() - 1;
		if (inToIndex < inFromIndex) {
			d.insertBefore(f, t);
		} else {
			if (inToIndex > inFromIndex) {
				if (inToIndex == c) {
					d.appendChild(f);
				} else {
					var nl = this.btns[inToIndex + 1];
					if (nl) {
						d.insertBefore(f, nl);
					}
				}
			}
		}
		this.btns[inToIndex] = f;
		this.btns[inFromIndex] = t;
	}});
	dojo.declare("wm.RoundedTabsDecorator", wm.TabsDecorator, {decorateContainer:function () {
		this.inherited(arguments);
		dojo.removeClass(this.tabsControl.domNode, "wmtablayers-tabbar");
		dojo.addClass(this.tabsControl.domNode, "wmtablayers-roundedtabbar");
		this.tabsControl.setPadding("0,0,0,15");
		this.tabsControl.domNode.style.paddingTop = "0px";
		this.tabsControl.domNode.style.paddingLeft = "15px";
	}, createTab:function (inCaption, inIndex, inLayer) {
		var b = this.btns[inIndex] = document.createElement("div");
		b.style.display = inLayer.showing ? "" : "none";
		var divLeft = document.createElement("div");
		var divCenter = document.createElement("div");
		var divRight = document.createElement("div");
		divLeft.innerHTML = "&nbsp;";
		divCenter.innerHTML = "&nbsp;";
		divRight.innerHTML = "&nbsp;";
		this.setBtnText(divCenter, inCaption);
		this.decoree.connect(b, "onclick", dojo.hitch(this, "tabClicked", inLayer));
		this.decoree.connect(b, "onmouseover", dojo.hitch(this, "mouseoverout", inLayer, true));
		this.decoree.connect(b, "onmouseout", dojo.hitch(this, "mouseoverout", inLayer, false));
		b.className = "wmtablayers-roundedtab";
		divLeft.className = "wmtablayers-roundedtab-left";
		divCenter.className = "wmtablayers-roundedtab-center";
		divRight.className = "wmtablayers-roundedtab-right";
		b.appendChild(divLeft);
		b.appendChild(divCenter);
		b.appendChild(divRight);
		dojo.connect(b, "onselectstart", dojo, "stopEvent");
		this.tabsControl.domNode.appendChild(b);
	}, tabClicked:function (inLayer) {
		var b = this.btns[inLayer.getIndex()];
		var divLeft = b.childNodes[0];
		var divCenter = b.childNodes[1];
		var divRight = b.childNodes[2];
		if (b) {
			dojo.removeClass(divLeft, "wmtablayers-roundedtab-left-hover");
			dojo.removeClass(divCenter, "wmtablayers-roundedtab-center-hover");
			dojo.removeClass(divRight, "wmtablayers-roundedtab-right-hover");
		}
		this.inherited(arguments);
	}, mouseoverout:function (inLayer, inActive) {
		var inIndex = inLayer.getIndex();
		if (this.decoree.layerIndex != inIndex) {
			var b = this.btns[inIndex];
			var divLeft = b.childNodes[0];
			var divCenter = b.childNodes[1];
			var divRight = b.childNodes[2];
			if (b) {
				dojo[inActive ? "addClass" : "removeClass"](divLeft, "wmtablayers-roundedtab-left-hover");
				dojo[inActive ? "addClass" : "removeClass"](divCenter, "wmtablayers-roundedtab-center-hover");
				dojo[inActive ? "addClass" : "removeClass"](divRight, "wmtablayers-roundedtab-right-hover");
			}
		}
	}, applyLayerCaption:function (inLayer) {
		var d = this.decoree, i = inLayer.getIndex();
		if (i != -1) {
			this.setBtnText(this.btns[i].childNodes[1], inLayer.caption);
		}
	}});
	dojo.declare("wm.WizardDecorator", wm.TabsDecorator, {decorationClass:"wmwizardlayers", decoratorPadding:"2", buttonPanel:null, nextButton:null, prevButton:null, undecorate:function () {
		this.inherited(arguments);
		if (this.buttonPanel) {
			this.buttonPanel.destroy();
		}
		this.buttonPanel = null;
		this.nextButton = null;
		this.prevButton = null;
	}, addFooter:function () {
		this.buttonPanel = new wm.Panel({name:"buttonPanel", parent:this.decoree, owner:this.decoree, layoutKind:"left-to-right", height:"40px", width:"100%", freeze:true, lock:true, verticalAlign:"top", horizontalAlign:"right"});
		this.prevButton = new wm.Button({name:"prevButton", parent:this.buttonPanel, owner:this.decoree, width:"80px", height:"100%", caption:"Back"});
		this.nextButton = new wm.Button({name:"nextButton", parent:this.buttonPanel, owner:this.decoree, width:"80px", height:"100%", caption:"Next"});
		dojo.connect(this.prevButton, "onclick", this, "backClick");
		dojo.connect(this.nextButton, "onclick", this, "nextClick");
	}, setLayerActive:function (inLayer, inActive) {
		this.inherited(arguments);
		var i = inLayer.getIndex();
		this.nextButton.setCaption(i < inLayer.decorator.decoree.layers.length - 1 ? "Next" : "Done");
	}, nextClick:function () {
		var i = this.decoree.layerIndex;
		var layer = this.decoree.getActiveLayer();
		this.validateCurrentLayer();
		if (!layer.invalid) {
			if (i == this.decoree.layers.length - 1) {
				this.decoree.onDoneClick();
			} else {
				this.decoree.setLayerIndex(i + 1);
				var layer = this.decoree.getActiveLayer();
				layer.focusFirstEditor();
			}
		} else {
			this.validateCurrentLayer();
		}
	}, validateCurrentLayer:function (noWarn) {
		var i = this.decoree.layerIndex;
		var layer = this.decoree.getActiveLayer();
		dojo.removeClass(this.btns[i], "done");
		var invalidWidget = layer.getInvalidWidget();
		if (invalidWidget && !noWarn) {
			invalidWidget.focus();
			invalidWidget.editor.displayMessage(invalidWidget.invalidMessage || "Invalid Input", true);
			app.toastDialog.showToast("Invalid value for " + (invalidWidget.caption || invalidWidget.name), 3000, "Warning", "cc");
			return false;
		}
		if (invalidWidget) {
			return false;
		}
		var result = {invalidMessage:null};
		this.decoree.onLayerValidation(layer, result);
		if (result.invalidMessage) {
			app.alertDialog.setUserPrompt(result.invalidMessage);
			app.alertDialog.show();
			return false;
		}
		return true;
	}, backClick:function () {
		this.validateCurrentLayer(true);
		var i = this.decoree.layerIndex;
		if (i == 0) {
			this.decoree.onCancelClick();
		} else {
			this.decoree.setLayerIndex(i - 1);
		}
	}, tabClicked:function (inLayer, e) {
		if (this.decoree.isDesignLoaded()) {
			return this.inherited(arguments);
		}
		var layer = this.decoree.getActiveLayer();
		var newindex = inLayer.getIndex();
		for (var i = 0; i < newindex; i++) {
			if (this.decoree.layers[i].invalid) {
				app.toastDialog.showToast("Please fill out \"" + this.decoree.layers[i].caption + "\" first", 3000, "Warning", "cc");
				return;
			}
		}
		this.inherited(arguments);
	}});
	dojo.declare("wm.TabsControl", wm.Control, {height:"27px", width:"100%", border:0, init:function () {
		if (this.parent && this.parent.isRelativePositioned) {
			this.isRelativePositioned = true;
		}
		dojo.addClass(this.domNode, "wmtablayers-tabbar");
		this.height = this.owner && this.owner.headerHeight;
		this.inherited(arguments);
	}});
}
if (!dojo._hasResource["wm.base.widget.Layers.AccordionDecorator"]) {
	dojo._hasResource["wm.base.widget.Layers.AccordionDecorator"] = true;
	dojo.provide("wm.base.widget.Layers.AccordionDecorator");
	dojo.declare("wm.AccordionDecorator", wm.LayersDecorator, {decorationClass:"wmaccordion", captionBorder:0, captionBorderColor:"", decorateLayer:function (inLayer, inIndex) {
		this.inherited(arguments);
		this.createHeader(inLayer, inIndex);
	}, createHeader:function (inLayer, inIndex) {
		var captionHeight = inLayer.parent.captionHeight;
		var p = this.decoree.client;
		var h = inLayer.header = new wm.Label({caption:inLayer.caption + "<span class='accordionArrowNode'></span>", margin:"0,0,2,0", height:captionHeight + "px", padding:"4,4,0,4", _classes:{domNode:["wmaccordion-header"]}, showing:inLayer.showing, parent:p, owner:p, border:this.captionBorder, borderColor:this.captionBorderColor});
		p.moveControl(h, inIndex * 2);
		dojo.addClass(inLayer.domNode, "wmaccordion-content");
		this.decoree.connect(h.domNode, "onclick", dojo.hitch(this, "headerClicked", inLayer));
	}, headerClicked:function (inLayer, e) {
		var d = this.decoree;
		if (d.isDesignLoaded()) {
			dojo.stopEvent(e);
		}
		d.setProp(inLayer.active && d.multiActive ? "layerInactive" : "layer", inLayer);
	}, getNewLayerIndex:function (inLayer) {
		for (var i = 0, layers = this.decoree.layers, l; (l = layers[i]); i++) {
			if (l != inLayer && l.active) {
				return i;
			}
		}
	}, deactivateLayer:function (inLayer) {
		var newIndex = this.getNewLayerIndex(inLayer);
		if (newIndex != undefined) {
			this.setLayerActive(inLayer, false);
			var d = this.decoree;
			d.layerIndex = newIndex;
			d.reflow();
		}
	}, activateLayer:function (inLayer) {
		var d = this.decoree;
		if (d.multiActive && !d._loading) {
			this.setLayerActive(inLayer, true);
			d.reflow();
		} else {
			this.inherited(arguments);
		}
	}, undecorateLayer:function (inLayer, inIndex) {
		inLayer.header.destroy();
		dojo.removeClass(inLayer.domNode, "wmaccordion-content");
	}, setLayerShowing:function (inLayer, inShowing) {
		inLayer.header.setShowing(inShowing);
		this.inherited(arguments);
	}, setLayerActive:function (inLayer, inShowing) {
		dojo[inShowing ? "removeClass" : "addClass"](inLayer.header.domNode, "wmaccordion-collapsed");
		this.inherited(arguments);
	}, applyLayerCaption:function (inLayer) {
		inLayer.header.setCaption(inLayer.caption + "<span class='accordionArrowNode'></span>");
	}, moveLayerIndex:function (inFromIndex, inToIndex) {
		var d = this.decoree, client = d.client, l = d.getLayer(inFromIndex);
		client.removeControl(l);
		client.removeControl(l.header);
		client.insertControl(l.header, inFromIndex * 2);
		client.insertControl(l, inFromIndex * 2 + 1);
	}});
}
if (!dojo._hasResource["wm.base.widget.Layers"]) {
	dojo._hasResource["wm.base.widget.Layers"] = true;
	dojo.provide("wm.base.widget.Layers");
	dojo.declare("wm.Layer", wm.Container, {height:"100%", width:"100%", caption:"", layoutKind:"top-to-bottom", moveable:false, _requiredParent:"wm.Layers", transition:"none", destroy:function () {
		if (this.parent) {
			this.parent.setCaptionMapLayer(this.caption, null);
		}
		this.inherited(arguments);
	}, init:function () {
		this.inherited(arguments);
		if (this.title) {
			this.caption = this.title;
			delete this.title;
		}
		this.setCaption(this.caption);
		if (!this.isRelativePositioned) {
			dojo.addClass(this.domNode, "wmlayer");
		}
		this.setBorder(this.parent.clientBorder);
		this.setBorderColor(this.parent.clientBorderColor);
	}, setName:function (inName) {
		if (this.parent) {
			delete this.parent.widgets[this.name];
		}
		this.addRemoveDefaultCssClass(false);
		wm.Component.prototype.setName.apply(this, arguments);
		if (this.parent) {
			this.parent.widgets[this.name] = this;
		}
		this.addRemoveDefaultCssClass(true);
	}, activate:function () {
		var p = this.parent;
		if (p && this.showing && !this.isActive()) {
			p.setLayer(this);
		}
	}, isActive:function () {
		return this.active;
	}, setShowing:function (inShowing) {
		if (!this.canChangeShowing()) {
			return;
		}
		if (this.showing != inShowing) {
			this.showing = inShowing;
			this.decorator.setLayerShowing(this, inShowing);
			var p = this.parent;
			if (!inShowing && p.layerIndex == this.getIndex()) {
				p.setNext();
			}
		}
	}, show:function () {
		this.setShowing(true);
	}, hide:function () {
		this.setShowing(false);
	}, setCaption:function (inCaption) {
		this.caption = inCaption;
		if (this.parent) {
			this.parent.setCaptionMapLayer(inCaption, this);
		}
		this.decorator.applyLayerCaption(this);
	}, getIndex:function () {
		var p = this.parent;
		return p && p.indexOfLayer(this);
	}, onShow:function () {
		wm.forEachProperty(this.widgets, function (w) {
			wm.fire(w, "_onShowParent");
		});
	}});
	dojo.declare("wm.Layers", wm.Container, {clientBorder:"", clientBorderColor:"", layerIndex:-1, defaultLayer:-1, decoratorClass:wm.LayersDecorator, layersType:"Layers", layoutKind:"top-to-bottom", height:"100%", width:"100%", destroy:function () {
		this.inherited(arguments);
		if (this.decorator) {
			this.decorator.destroy();
			this.decorator = null;
		}
		this.layers = null;
		this.captionMap = null;
		this.client = null;
	}, prepare:function () {
		this.layers = [];
		this.captionMap = [];
		this.inherited(arguments);
	}, build:function () {
		this.inherited(arguments);
		this.setLayersType(this.layersType);
	}, init:function () {
		if (!this.isRelativePositioned) {
			dojo.addClass(this.domNode, "wmlayers");
		} else {
			this.setHeaderHeight("20px");
		}
		this.client = new wm.Panel({isRelativePositioned:this.isRelativePositioned, border:0, name:"client", parent:this, owner:this, height:"100%", width:"100%", flags:{notInspectable:true}});
		this.inherited(arguments);
	}, postInit:function () {
		this.inherited(arguments);
		if (!this.getCount()) {
			this.addLayer();
		}
		this._initDefaultLayer();
		if (wm.widgetIsShowing(this)) {
			this._fireLayerOnShow();
		}
	}, afterPaletteDrop:function () {
		this.inherited(arguments);
		this.setClientBorder(this.clientBorder);
		this.setClientBorderColor(this.clientBorderColor);
	}, _initDefaultLayer:function () {
		var d = this.defaultLayer;
		d = d != -1 ? d : 0;
		var dl = this.getLayer(d);
		if (dl && !dl.showing) {
			d = this._getPrevNextShownIndex(d);
			dl = this.getLayer(d);
		}
		if (dl) {
			this._setLayerIndex(dl.getIndex());
		}
	}, createLayer:function (inCaption) {
		var defName = this.owner.getUniqueName(inCaption || "layer1"), props = {width:"100%", height:"100%", caption:defName, parent:this, horizontalAlign:"left", verticalAlign:"top", themeStyleType:this.themeStyleType}, o = this.getRoot();
		if (o) {
			return o.createComponent(defName, "wm.Layer", props);
		}
	}, themeStyleType:"", setThemeStyleType:function (inMajor) {
		this.themeStyleType = inMajor;
		for (var i = 0; i < this.layers.length; i++) {
			this.layers[i].setThemeStyleType(inMajor);
		}
	}, setClientBorder:function (inBorder) {
		this.clientBorder = inBorder;
		var method = this.isDesignLoaded() ? "set_border" : "setBorder";
		for (var i = 0; i < this.layers.length; i++) {
			this.layers[i][method](inBorder);
		}
	}, setClientBorderColor:function (inBorderColor) {
		this.clientBorderColor = inBorderColor;
		for (var i = 0; i < this.layers.length; i++) {
			this.layers[i].setBorderColor(inBorderColor);
		}
	}, addLayer:function (inCaption) {
		var pg = this.createLayer(inCaption);
		this._setLayerIndex(this.getCount() - 1);
		return pg;
	}, addWidget:function (inWidget) {
		if (inWidget instanceof wm.Layer) {
			this.client.addWidget(inWidget);
			this.layers.push(inWidget);
			this.setCaptionMapLayer(inWidget.caption, inWidget);
			if (this.decorator) {
				this.decorator.decorateLayer(inWidget, this.getCount() - 1);
				this.decorator.setLayerActive(inWidget, false);
			}
		} else {
			this.inherited(arguments);
		}
	}, removeWidget:function (inWidget) {
		if (inWidget instanceof wm.Layer) {
			var i = this.indexOfLayer(inWidget);
			this.layers.splice(i, 1);
			this.setCaptionMapLayer(inWidget.caption, null);
			this.decorator.undecorateLayer(inWidget, i);
			this.client.removeWidget(inWidget);
			this.setLayerIndex(0);
		} else {
			this.inherited(arguments);
		}
	}, addControl:function (inControl) {
		if (inControl.owner == this) {
			this.inherited(arguments);
		} else {
			if (inControl instanceof wm.Layer) {
				this.client.addControl(inControl);
			}
		}
	}, removeControl:function (inControl) {
		if (inControl.owner == this) {
			this.inherited(arguments);
		} else {
			if (inControl instanceof wm.Layer) {
				this.client.removeControl(inControl);
			}
		}
	}, isWidgetTypeAllowed:function (inChildType) {
		return inChildType == "wm.Layer";
	}, getLayer:function (inIndex) {
		return this.layers[inIndex != undefined ? inIndex : this.layerIndex];
	}, getActiveLayer:function () {
		if (this.layerIndex != -1) {
			return this.layers[this.layerIndex];
		}
		var defaultIndex = (this.defaultLayer == -1) ? 0 : this.defaultLayer;
		return this.layers[defaultIndex];
	}, removeLayer:function (inIndex) {
		if (!this.layers) {
			return;
		}
		var p = this.getLayer(inIndex);
		if (p) {
			this.removeWidget(p);
		}
	}, indexOfLayer:function (inLayer) {
		for (var i = 0, l; (l = this.getLayer(i)); i++) {
			if (l == inLayer) {
				return i;
			}
		}
		return -1;
	}, indexOfLayerName:function (inLayerName) {
		for (var i = 0, l; (l = this.getLayer(i)); i++) {
			if (l.name == inLayerName) {
				return i;
			}
		}
		return -1;
	}, indexOfLayerCaption:function (inCaption) {
		return this.indexOfLayer(this.captionMap[inCaption]);
	}, getLayerCaption:function (inIndex) {
		var p = this.getLayer(inIndex);
		return p && p.caption;
	}, getLayerByCaption:function (inCaption) {
		return this.getLayer(this.indexOfLayerCaption(inCaption));
	}, setLayerByCaption:function (inCaption) {
		var p = this.captionMap[inCaption];
		this.setLayerByName(p || inCaption);
	}, setLayerByName:function (inName) {
		var l = this.client.widgets[inName];
		if (l) {
			this.setLayer(l);
		} else {
			if (inName) {
				this.addLayer(inName);
			}
		}
	}, setLayer:function (inNameOrLayer) {
		if (inNameOrLayer instanceof wm.Layer) {
			this.setProp("layerIndex", inNameOrLayer.getIndex());
		} else {
			this.setLayerByName(inNameOrLayer);
		}
	}, setLayerInactive:function (inLayer) {
		wm.fire(inLayer.decorator, "deactivateLayer", [inLayer]);
	}, setLayerIndex:function (inIndex) {
		if (inIndex == this.layerIndex) {
			return;
		}
		var fireEvents = !this.loading, l = this.getLayer(inIndex);
		if (fireEvents) {
			var info = {newIndex:inIndex, canChange:l && l.showing};
			this.oncanchange(info);
			if (info.canChange === false) {
				return;
			}
			inIndex = info.newIndex;
		}
		if (inIndex < 0 || inIndex > this.getCount() - 1) {
			return;
		}
		this._setLayerIndex(inIndex);
		if (fireEvents) {
			l && l.onShow();
		}
		if (fireEvents && this.lastLayerIndex != this.layerIndex) {
			this.onchange(this.layerIndex);
		}
	}, _setLayerIndex:function (inIndex) {
		this.lastLayerIndex = this.layerIndex;
		this.layerIndex = inIndex;
		var l = this.getLayer(inIndex);
		if (l) {
			this.decorator.activateLayer(l);
		}
	}, setDecoratorClass:function (inClass) {
		this.decoratorClass = inClass;
		this.createDecorator();
	}, createDecorator:function () {
		if (this.decorator) {
			this.decorator.destroy();
		}
		this.decorator = this.decoratorClass ? new this.decoratorClass(this) : null;
	}, setLayersType:function (inLayersType) {
		var ctor = wm[inLayersType + "Decorator"];
		if (!ctor) {
			return;
		}
		this.layersType = inLayersType;
		var i = this.layerIndex;
		if (this.decorator) {
			this.decorator.undecorate();
			this.decorator.destroy();
			this.decorator = null;
		}
		this.setDecoratorClass(ctor);
		this.decorator.decorate();
		this._setLayerIndex(i);
		this.reflow();
	}, setDefaultLayer:function (inLayerIndex) {
		this.defaultLayer = inLayerIndex;
	}, getCount:function () {
		return this.layers.length;
	}, setCaptionMapLayer:function (inCaption, inLayer) {
		try {
			this.captionMap[inCaption] = inLayer;
		}
		catch (e) {
		}
	}, _getPrevNextShownIndex:function (inIndex, inPrev, inBounded) {
		var d = inPrev ? -1 : 1, c = this.getCount(), e = inPrev ? 0 : c - 1, w = inPrev ? c - 1 : 0, i = inPrev ? Math.min(inIndex + d, w) : Math.max(inIndex + d, 0), l;
		while (i != inIndex) {
			l = this.getLayer(i);
			if (l && l.showing) {
				return i;
			}
			if (inPrev ? i > e : i < e) {
				i = i + d;
			} else {
				if (inBounded) {
					return;
				} else {
					i = w;
				}
			}
		}
	}, setNext:function (inBounded) {
		var p = this._getPrevNextShownIndex(Number(this.layerIndex), false, inBounded);
		if (p !== undefined) {
			this.setLayerIndex(p);
		}
	}, setPrevious:function (inBounded) {
		var p = this._getPrevNextShownIndex(Number(this.layerIndex), true, inBounded);
		if (p !== undefined) {
			this.setLayerIndex(p);
		}
	}, moveLayerIndex:function (inLayer, inIndex) {
		var i = inLayer.getIndex(), inIndex = Math.max(0, Math.min(inIndex, this.getCount() - 1));
		if (i == inIndex) {
			return;
		}
		this.layers.splice(i, 1);
		this.layers.splice(inIndex, 0, inLayer);
		this.decorator.moveLayerIndex(i, inIndex);
		this._setLayerIndex(inIndex);
	}, _fireLayerOnShow:function () {
		var l = this.getLayer(this.layerIndex);
		l && l.onShow();
	}, _onShowParent:function () {
		this._fireLayerOnShow();
	}, clear:function () {
		wm.forEach(this.widgets, function (w) {
			w.destroy();
		});
		this.widgets = {};
		this.layers = [];
		this.domNode.innerHTML = "";
	}, oncanchange:function (inChangeInfo) {
	}, onchange:function (inIndex) {
	}, headerHeight:"27px", setHeaderHeight:function (inHeight) {
		if (this.layersType != "Tabs" && this.layersType != "RoundedTabs") {
			return;
		}
		this.headerHeight = inHeight;
		this.decorator && this.decorator.tabsControl && this.decorator.tabsControl.setHeight(inHeight);
	}, getMinHeightProp:function () {
		if (this.minHeight) {
			return this.minHeight;
		}
		var minHeight = 80;
		if (this.layersType.match(/tabs/i)) {
			minHeight += parseInt(this.headerHeight);
		}
		return minHeight;
	}, getMinWidthProp:function () {
		if (this.minWidth) {
			return this.minWidth;
		}
		var minWidth = 80;
		if (this.layersType.match(/tabs/i)) {
			minWidth += 120;
		}
		return minWidth;
	}});
	dojo.declare("wm.TabLayers", wm.Layers, {themeStyleType:"ContentPanel", layersType:"Tabs"});
	dojo.declare("wm.AccordionLayers", wm.Layers, {multiActive:false, themeStyleType:"ContentPanel", layersType:"Accordion", layerBorder:1, captionHeight:26, postInit:function () {
		this.inherited(arguments);
		this.setLayerBorder(this.layerBorder);
	}, setBorderColor:function (inColor) {
		this.inherited(arguments);
		for (var i = 0; i < this.layers.length; i++) {
			this.layers[i].setBorderColor(this.borderColor);
		}
	}, setLayerBorder:function (inBorder) {
		this.layerBorder = inBorder;
		for (var i = 0; i < this.layers.length; i++) {
			this.layers[i].setBorder(this.layerBorder);
			this.layers[i].setBorderColor(this.borderColor);
		}
	}, addLayer:function () {
		this.inherited(arguments);
		this.setLayerBorder(this.layerBorder);
	}});
	dojo.declare("wm.WizardLayers", wm.Layers, {themeStyleType:"ContentPanel", layersType:"Wizard", transition:"fade", init:function () {
		this.inherited(arguments);
		this.decorator.addFooter();
		this.connect(this.domNode, "keydown", this, "keydown");
	}, keydown:function (e) {
		var keyCode = e.keyCode;
		if (e.keyCode == dojo.keys.ENTER || e.keyCode == dojo.keys.NUMPAD_ENTER) {
			this.decorator.nextClick();
			dojo.stopEvent(e);
			return false;
		}
		return true;
	}, onCancelClick:function (inSender) {
	}, onDoneClick:function (inSender) {
	}, onLayerValidation:function (inLayer, outResult) {
	}});
}
if (!dojo._hasResource["wm.base.widget.Layers_design"]) {
	dojo._hasResource["wm.base.widget.Layers_design"] = true;
	dojo.provide("wm.base.widget.Layers_design");
	wm.Object.extendSchema(wm.Layer, {title:{ignore:1}, disabled:{ignore:1}, moveNext:{group:"operation", order:1}, movePrevious:{group:"operation", order:2}, flex:{ignore:1}, sizeUnits:{ignore:1}, size:{ignore:1}, caption:{group:"display", order:200, focus:true}, inFlow:{ignore:1}, active:{ignore:1}, fitToContentWidth:{ignore:1}, fitToContentHeight:{ignore:1}, minWidth:{ignore:1}, minHeight:{ignore:1}});
	wm.Layer.extend({themeable:false, sizeable:false, moveNext:"(move to next)", movePrevious:"(move to previous)", designCreate:function () {
		this.inherited(arguments);
		if (this.designWrapper) {
			this.designWrapper.setShowing(false);
		}
	}, domNodeShowingChanged:function (inShowing) {
		var dw = this.designWrapper;
		if (dw && inShowing != dw.showing) {
			dw.setShowing(inShowing);
		}
	}, moveLayer:function (inDelta) {
		var l = this.parent, i = this.getIndex();
		l.moveLayerIndex(this, i + inDelta);
	}, makePropEdit:function (inName, inValue, inDefault) {
		switch (inName) {
		  case "moveNext":
			return makeReadonlyButtonEdit(inName, inValue, inDefault, "&raquo;");
		  case "movePrevious":
			return makeReadonlyButtonEdit(inName, inValue, inDefault, "&laquo;");
		}
		return this.inherited(arguments);
	}, editProp:function (inName, inValue, inInspector) {
		switch (inName) {
		  case "moveNext":
			this.moveLayer(1);
			studio.refreshComponentOnTree(this.parent);
			studio.select(null);
			studio.select(this);
			break;
		  case "movePrevious":
			this.moveLayer(-1);
			studio.refreshComponentOnTree(this.parent);
			studio.select(null);
			studio.select(this);
			break;
		  default:
			this.inherited(arguments);
			return;
		}
	}});
	wm.Object.extendSchema(wm.Layers, {lock:{ignore:1}, freeze:{ignore:1}, box:{ignore:1}, boxPosition:{ignore:1}, layoutKind:{ignore:1}, horizontalAlign:{ignore:1}, verticalAlign:{ignore:1}, layerIndex:{ignore:1}, lastLayerIndex:{ignore:1}, defaultLayer:{group:"layout", order:105}, layersType:{group:"layout", order:110}, add:{group:"operation", order:1}, fitToContent:{ignore:1}, headerHeight:{group:"layout", order:50}, clientBorder:{group:"style", order:"100"}, clientBorderColor:{group:"style", order:"101"}});
	wm.Layers.extend({themeable:false, add:"(add layer)", _noCreate:true, set_defaultLayer:function (inLayerIndex) {
		this.setDefaultLayer(inLayerIndex);
		if (this.defaultLayer != -1) {
			this.set_layerIndex(this.defaultLayer);
		}
	}, set_layerIndex:function (inLayerIndex) {
		this.setLayerIndex(inLayerIndex);
		if (this.isDesignLoaded()) {
			studio.select(this.getLayer());
		}
	}, set_layerInactive:function (inLayer) {
		this.setLayerInactive(inLayer);
		if (this.isDesignLoaded()) {
			studio.select(this);
		}
	}, getLayerInfo:function (inNameList, inIndexList) {
		dojo.forEach(this.layers, function (l) {
			inNameList.push(l.name);
			inIndexList.push(this.indexOfLayer(l));
		}, this);
	}, makePropEdit:function (inName, inValue, inDefault) {
		switch (inName) {
		  case "transition":
			return new wm.propEdit.Select({component:this, value:inValue, name:inName, options:["none", "fade", "slide"]});
		  case "add":
			return makeReadonlyButtonEdit(inName, inValue, inDefault);
		  case "layersType":
			return makeSelectPropEdit(inName, inValue, ["Layers", "RoundedTabs", "Tabs", "Accordion"], inDefault);
		  case "defaultLayer":
			var options = [""], values = [-1];
			this.getLayerInfo(options, values);
			return makeSelectPropEdit(inName, inValue, options, inDefault, values);
		  case "headerHeight":
			return new wm.propEdit.UnitValue({component:this, name:inName, value:inValue, options:this._sizeUnits});
		}
		return this.inherited(arguments);
	}, editProp:function (inName, inValue, inInspector) {
		switch (inName) {
		  case "add":
			this.addLayer();
			studio.refreshWidgetsTree();
			studio.select(null);
			studio.select(this);
			break;
		  default:
			this.inherited(arguments);
			return;
		}
	}, listProperties:function () {
		var props = this.inherited(arguments);
		props.headerHeight.ignore = (this.layersType != "Tabs" && this.layersType != "RoundedTabs");
		return props;
	}, getOrderedWidgets:function () {
		return this.layers;
	}});
	wm.AccordionLayers.extend({themeable:true, themeableProps:["border", "borderColor", "layerBorder", "captionHeight"], themeableStyles:[{name:"wm.AccordionLayers-Open_Image", displayName:"Open Arrow Icon"}, {name:"wm.AccordionLayers-Closed_Image", displayName:"Closed Arrow Icon"}]});
	wm.TabLayers.extend({themeable:true, themeableProps:["border", "borderColor", "clientBorder", "clientBorderColor", "headerHeight"], themeableStyles:["wm.TabLayers-Button_Height", "wm.TabLayers-Button_TextSize", {name:"wm.TabLayers-BorderStyle_Shadow", displayName:"Shadow (Default)"}, {name:"wm.TabLayers-Hover-BorderStyle_Shadow", displayName:"Shadow (Hover)"}, {name:"wm.TabLayers-Active-BorderStyle_Shadow", displayName:"Shadow (Active)"}]});
	wm.WizardLayers.extend({themeable:true, themeableProps:["border", "borderColor", "clientBorder", "clientBorderColor"]});
	wm.Layers.description = "Show widgets on layers.";
	wm.TabLayers.description = "Layers with tab navigation.";
	wm.AccordionLayers.description = "Expandable layers.";
}
if (!dojo._hasResource["wm.base.widget.Button"]) {
	dojo._hasResource["wm.base.widget.Button"] = true;
	dojo.provide("wm.base.widget.Button");
	dojo.declare("wm.ToolButton", wm.Widget, {width:"80px", border:0, padding:"", margin:"", caption:"", hint:"", imageList:"", classNames:"wmtoolbutton", imageIndex:-1, iconUrl:"", iconWidth:"40px", iconHeight:"40px", iconMargin:"0 10px 0 0", clicked:false, build:function () {
		if (!this.domNode) {
			this.domNode = document.createElement("button");
			dojo.attr(this.domNode, "type", "button");
		}
		this.btnNode = this.domNode;
	}, destroy:function () {
		if (this.btnNode) {
			dojo.destroy(this.btnNode);
			this.btnNode = null;
		}
		if (this.domNode) {
			dojo.destroy(this.domNode);
			this.domNode = null;
		}
		this.inherited(arguments);
	}, init:function () {
		this.inherited(arguments);
		this.connectEvents(this.btnNode, ["click"]);
		this.setHint(this.title || this.hint);
		this.imageListChanged();
	}, click:function (inEvent) {
		this.onclick(inEvent);
		if (!this.clicked) {
			this.setProp("clicked", true);
		}
	}, onclick:function (inEvent) {
	}, findImageList:function () {
		var t = this;
		while (t && !t.imageList) {
			t = t.parent;
		}
		return t ? t.imageList : null;
	}, setDisabled:function (inDisabled) {
		this.inherited(arguments);
		this.btnNode.disabled = inDisabled ? "disabled" : "";
		dojo[inDisabled ? "addClass" : "removeClass"](this.domNode, "wmbutton-disabled");
		this.invalidCss = true;
		this.render();
	}, setSelected:function (inSelected) {
		this.selected = inSelected;
		this.invalidCss = true;
		this.render();
	}, setCaption:function (inCaption) {
		this.caption = inCaption;
		this.invalidCss = true;
		this.render();
	}, setIconUrl:function (inUrl) {
		this.iconUrl = inUrl;
		this.invalidCss = true;
		this.render();
	}, setIconWidth:function (w) {
		this.iconWidth = w;
		this.invalidCss = true;
		this.render();
	}, setIconHeight:function (h) {
		this.iconHeight = h;
		this.invalidCss = true;
		this.render();
	}, setIconMargin:function (m) {
		this.iconMargin = m;
		this.invalidCss = true;
		this.render();
	}, setContent:function (inContent) {
		this.setCaption(inContent);
	}, setHint:function (inHint) {
		this.btnNode.title = this.hint = inHint;
	}, setImageList:function (inImageList) {
		this.imageList = inImageList;
		this.imageListChanged();
	}, setImageIndex:function (inImageIndex) {
		if (inImageIndex !== undefined) {
			this.imageIndex = inImageIndex;
			this.imageListChanged();
		}
	}, imageListChanged:function () {
		var iln = this.findImageList();
		this._imageList = iln ? iln instanceof wm.ImageList ? iln : this.owner.getValueById(iln) : null;
		this.invalidCss = true;
		this.render();
	}, render:function (forceRender) {
		if (!forceRender && (!this.invalidCss || !this.isReflowEnabled())) {
			return;
		}
		this.inherited(arguments);
		var il = this._imageList;
		if (il && il.getImageHtml && this.imageIndex >= 0) {
			var ii = this.imageIndex + (this.disabled ? il.colCount * 2 : 0) + (this.selected ? il.colCount : 0);
			var sl = this.singleLine ? "line-height: " + this.height + "; " : "";
			var captionHtml = this.caption ? "<span style=\"padding-left: 2px; " + sl + "\">" + this.caption + "</span>" : "";
			this.btnNode.innerHTML = il.getImageHtml(ii) + captionHtml;
			this.btnNode.style.padding = "0px";
		} else {
			if (this.iconUrl) {
				var sl = this.singleLine ? "line-height: " + this.height + "; " : "";
				var captionHtml = this.caption ? "<span style=\"padding-left: 2px; " + sl + "\">" + this.caption + "</span>" : "";
				var root = this.getPath() || "";
				this.btnNode.innerHTML = "<img src='" + wm.theme.getImagesPath() + "blank.gif' style='margin: " + this.iconMargin + "; width: " + this.iconWidth + "; height: " + this.iconHeight + "; vertical-align: middle; background:url(" + root + this.iconUrl + ") no-repeat; background-color: transparent;' />" + captionHtml;
				this.btnNode.style.padding = "0px";
			} else {
				this.btnNode.innerHTML = this.caption;
				this.btnNode.style.padding = "";
			}
		}
	}});
	wm.Object.extendSchema(wm.ToolButton, {scrollX:{ignore:1}, scrollY:{ignore:1}, clicked:{ignore:1, bindSource:true}, iconUrl:{group:"format", bindable:true, type:"String", subtype:"File"}, iconWidth:{group:"format"}, iconHeight:{group:"format"}, iconMargin:{group:"format"}});
	wm.ToolButton.extend({scrim:true, makePropEdit:function (inName, inValue, inDefault) {
		switch (inName) {
		  case "iconWidth":
		  case "iconHeight":
			return new wm.propEdit.UnitValue({component:this, name:inName, value:inValue, options:this._sizeUnits});
		}
		return this.inherited(arguments);
	}, destroy:function () {
		if (this.btnNode) {
			dojo.destroy(this.btnNode);
			this.btnNode = null;
		}
		if (this.domNode) {
			dojo.destroy(this.domNode);
			this.domNode = null;
		}
		this.inherited(arguments);
	}});
	dojo.declare("wm.Button", wm.ToolButton, {height:"32px", border:1, borderColor:"#ABB8CF", margin:4, caption:"ボタン", classNames:"wmbutton"});
	dojo.declare("wm.ToggleButton", wm.ToolButton, {height:"32px", border:1, borderColor:"#ABB8CF", margin:4, captionUp:"ボタン上", captionDown:"ボタン下", classNames:"wmbutton wmtogglebutton", init:function () {
		this.caption = this.captionUp;
		this.inherited(arguments);
		if (this.clicked) {
			this.setClicked(true);
		}
	}, click:function () {
		this.onclick();
		this.setProp("clicked", !this.clicked);
	}, setClicked:function (inClicked) {
		if (inClicked != this.clicked) {
			this.clicked = inClicked;
			this.valueChanged("clicked", inClicked);
			this.setCaption(this.clicked ? this.captionDown : this.captionUp);
			dojo[this.clicked ? "addClass" : "removeClass"](this.domNode, "toggleButtonDown");
		}
	}, setCaptionUp:function (inCaption) {
		this.captionUp = inCaption;
		this.setCaption(inCaption);
	}});
	wm.Object.extendSchema(wm.ToggleButton, {captionUp:{group:"display", bindTarget:1, order:10, focus:1}, captionDown:{group:"display", bindTarget:1, order:11}, clicked:{group:"display", bindTarget:1, bindSource:1, order:12}, caption:{ignore:1}});
	dojo.declare("wm.RoundedButton", wm.Button, {useDesignBorder:0, classNames:"roundedwmbutton", margin:2, padding:0, border:0, leftImgWidth:12, rightImgWidth:12, width:"110px", height:"40px", build:function () {
		if (!this.domNode) {
			this.domNode = document.createElement("div");
			var buttonLeft = document.createElement("div");
			var buttonCenter = document.createElement("div");
			var buttonRight = document.createElement("div");
			dojo.addClass(buttonLeft, "button-gray-left");
			dojo.addClass(buttonCenter, "button-gray-center");
			dojo.addClass(buttonRight, "button-gray-right");
			buttonLeft.innerHTML = "&nbsp;";
			buttonRight.innerHTML = "&nbsp;";
			this.domNode.appendChild(buttonLeft);
			this.domNode.appendChild(buttonCenter);
			this.domNode.appendChild(buttonRight);
		}
		this.btnNode = this.domNode;
		this.connect(this.btnNode, "onmouseover", dojo.hitch(this, "mouseoverout", this, true));
		this.connect(this.btnNode, "onmouseout", dojo.hitch(this, "mouseoverout", this, false));
		dojo.connect(this.btnNode, "onselectstart", dojo, "stopEvent");
		this.invalidCss = true;
	}, mouseoverout:function (inButton, inActive) {
		if (inButton && !inButton.disabled) {
			var btnNode = inButton.btnNode;
			var buttonLeft = btnNode.childNodes[0];
			var buttonCenter = btnNode.childNodes[1];
			var buttonRight = btnNode.childNodes[2];
			dojo[inActive ? "addClass" : "removeClass"](buttonLeft, "button-blue-left");
			dojo[inActive ? "addClass" : "removeClass"](buttonCenter, "button-blue-center");
			dojo[inActive ? "addClass" : "removeClass"](buttonRight, "button-blue-right");
			dojo[inActive ? "addClass" : "removeClass"](inButton.btnNode, "button-pointer");
		}
	}, click:function (inEvent) {
		if (!this.disabled) {
			this.onclick(inEvent);
		}
	}, render:function (forceRender) {
		if (!forceRender && (!this.invalidCss || !this.isReflowEnabled())) {
			return;
		}
		dojo.hitch(this, wm.Control.prototype.render)(forceRender);
		var il = this._imageList;
		if (il && il.getImageHtml && this.imageIndex >= 0) {
			var ii = this.imageIndex + (this.disabled ? il.colCount * 2 : 0) + (this.selected ? il.colCount : 0);
			var sl = this.singleLine ? "line-height: " + this.height + "; " : "";
			var captionHtml = this.caption ? "<span style=\"padding-left: 2px; " + sl + "\">" + this.caption + "</span>" : "";
			this.btnNode.innerHTML = il.getImageHtml(ii) + captionHtml;
			this.btnNode.style.padding = "0px";
		} else {
			if (this.iconUrl) {
				var sl = this.singleLine ? "line-height: " + this.height + "; " : "";
				var captionHtml = this.caption ? "<span style=\"padding-left: 2px; " + sl + "\">" + this.caption + "</span>" : "";
				var root = this.getPath() || "";
				this.btnNode.innerHTML = "<img src='" + wm.theme.getImagesPath() + "blank.gif' style='margin: " + this.iconMargin + "; width: " + this.iconWidth + "; height: " + this.iconHeight + "; vertical-align: middle; background:url(" + root + this.iconUrl + ") no-repeat; background-color: transparent;' />" + captionHtml;
				this.btnNode.style.padding = "0px";
			} else {
				this.btnNode.childNodes[1].innerHTML = this.caption;
				this.btnNode.style.padding = "";
			}
		}
	}, updateBounds:function () {
		this.inherited(arguments);
		var bounds = this.getContentBounds();
		var width = bounds.w;
		this.btnNode.childNodes[1].style.width = width - (this.leftImgWidth + this.rightImgWidth) + "px";
	}});
	wm.Object.extendSchema(wm.Button, {caption:{group:"display", bindable:1, order:10, focus:1}, hint:{group:"display", order:20}, imageList:{group:"display", order:50}, imageIndex:{group:"display", order:51}});
	wm.Object.extendSchema(wm.RoundedButton, {imageList:{ignore:1}, imageIndex:{ignore:1}, iconHeight:{ignore:1}, iconWidth:{ignore:1}, iconUrl:{ignore:1}, iconMargin:{ignore:1}, leftImgWidth:{ignore:1}, rightImgWidth:{ignore:1}, border:{ignore:1}, borderColor:{ignore:1}, scrollX:{ignore:1}, scrollY:{ignore:1}, padding:{ignore:1}});
	wm.Button.description = "A simple button.";
}
if (!dojo._hasResource["wm.base.widget.Picture"]) {
	dojo._hasResource["wm.base.widget.Picture"] = true;
	dojo.provide("wm.base.widget.Picture");
	dojo.declare("wm.Picture", wm.Box, {aspect:"none", hint:"", width:"100px", height:"100px", link:"", source:"", init:function () {
		this.inherited(arguments);
		var d = this.domNode;
		d.innerHTML = "<a><img></a>";
		dojo.addClass(d, "wmpicture");
		this.linkNode = d.firstChild;
		this.img = this.linkNode.firstChild;
		dojo.addClass(this.img, "wmpicture-image");
		this.connect(this.img, "click", this, "onclick");
		this.setSource(this.source);
		this.setAspect(this.aspect);
		this.setLink(this.link);
		this.setHint(this.hint);
	}, setSource:function (inSource) {
		this.source = inSource || "";
		this.valueChanged("source", this.source);
		this.img.style.display = this.source ? "" : "none";
		var root = this.source.slice(0, 4) != "http" && this.source.slice(0, 1) != "/" ? this.getPath() : "";
		this.img.src = root + this.source;
	}, setHint:function (inHint) {
		this.domNode.title = this.hint = inHint;
	}, setAspect:function (inAspect) {
		var s = this.img.style, w = "width", h = "height", a = this.aspect = inAspect;
		s.width = (a == "v" ? "100%" : "");
		s.height = (a == "h" ? "100%" : "");
	}, setLink:function (inLink) {
		this.link = inLink;
		if (inLink) {
			this.linkNode.target = "_blank";
			this.linkNode.href = inLink;
		} else {
			this.linkNode.removeAttribute("href");
		}
	}, onclick:function () {
	}});
	wm.Object.extendSchema(wm.Picture, {source:{type:"String", bindable:1, group:"common", order:1, focus:1, subtype:"File", extensionMatch:["jpg", "jpeg", "gif", "png", "tiff"]}, hint:{group:"common", order:2}, link:{type:"String", bindable:1}, aspect:{group:"layout", order:50}});
	dojo.extend(wm.Picture, {themeable:false, themeableDemoProps:{source:"images/add.png"}, makePropEdit:function (inName, inValue, inDefault) {
		switch (inName) {
		  case "source":
			return makePictureSourcePropEdit(inName, inValue, inDefault);
		  case "aspect":
			return makeSelectPropEdit(inName, inValue, ["h", "v", "none"], inDefault);
		}
		return this.inherited("makePropEdit", arguments);
	}});
	makePictureSourcePropEdit = function (inName, inValue, inDefault) {
		var i = makeInputPropEdit(inName, inValue, inDefault);
		var f = "<form class=\"inspector-filebox\"><input class=\"inspector-fileinput\" onchange=\"inspectFileboxUrlChange.call(this)\" size=\"1\" type=\"file\"/></form>";
		return "<table width=\"100%\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tr><td>" + i + "</td><td>" + f + "</td></tr></table>";
	};
}
if (!dojo._hasResource["wm.base.widget.Tree"]) {
	dojo._hasResource["wm.base.widget.Tree"] = true;
	dojo.provide("wm.base.widget.Tree");
	try {
		document.execCommand("BackgroundImageCache", false, true);
	}
	catch (e) {
	}
	dojo.addOnLoad(function () {
		wm.preloadImage(wm.theme.getImagesPath() + "tree_blank.gif");
	});
	dojo.declare("wm.TreeNode", null, {images:{none:"tree_blank.gif", leaf:"tree_leaf.gif", closed:"tree_closed.gif", open:"tree_open.gif"}, classes:{leaf:"wmtree-leaf", lastLeaf:"wmtree-last-leaf", lastItem:"wmtree-last-item", content:"wmtree-content", selected:"wmtree-selected", rootLeaf:"wmtree-root-leaf", rootLastLeaf:"wmtree-root-last-leaf", open:"wmtree-open"}, closed:false, canSelect:true, constructor:function (inParent, inProps) {
		this.addParent(inParent);
		this.initProps(inProps);
		this.placeInParent();
		if (!this.tree._updating) {
			this.render();
		}
	}, destroy:function () {
		this.forEachDescendant(function (n) {
			n._destroy();
		});
		this._destroy();
	}, destroy:function () {
		if (this.tree.nodes[this.id]) {
			this.tree._removeNode(this);
		}
		if (this.parent) {
			wm.fire(this.parent, "_remove", [this]);
		}
		if (this != this.tree.root) {
			var d = this.domNode;
			dojo._destroyElement(d);
		}
	}, addParent:function (inParent) {
		this.parent = inParent;
		this.tree = inParent.tree;
		this.tree._addNode(this);
	}, initProps:function (inProps) {
		inProps = inProps || {};
		dojo.mixin(this, {kids:[], content:"", data:{}, _data:{}, imageRoot:this.tree._imageRoot}, inProps);
		if (this.closed) {
			this._childrenRendered = false;
		}
	}, placeInParent:function () {
		var i = this.parentIndex;
		if (i !== undefined) {
			this.parent.kids.splice(i, 0, this);
		} else {
			this.parent.kids.push(this);
		}
	}, render:function () {
		this.createNode();
		this.domNode.nodeId = this.id;
		this.styleContent();
		this.parent.renderChild(this);
		if (this.selected) {
			this.tree.selected = this;
		}
		if (!this.closed) {
			this.initKids();
		}
	}, createKidsNode:function () {
		var n = this.kidsNode = document.createElement("ul");
		n.style.display = (this.closed ? "none" : "");
		return n;
	}, formatImage:function (inImage, inImageSize) {
		inImage = inImage || this.image;
		inImageSize = inImageSize || this.imageSize || 16;
		return inImage ? ["<img src=\"", inImage, "\" style=\"height: ", inImageSize, "px; width: ", inImageSize, "px;\">&nbsp;"].join("") : "";
	}, formatContent:function () {
		i = this.formatImage();
		return [i, i ? "&nbsp;" : "", this.content].join("");
	}, createNode:function () {
		var li = this.domNode = document.createElement("li");
		li.innerHTML = "<img/><span>" + this.formatContent() + "</span>";
		this.btnNode = li.firstChild;
		this.contentNode = this.btnNode.nextSibling;
	}, isLastChild:function () {
		var k = this.parent.kids;
		return this == k[k.length - 1];
	}, isRoot:function () {
		return (this.parent == this.tree.root) && (this == this.tree.root.kids[0]);
	}, isSelected:function () {
		return this == this.tree.selected;
	}, styleNode:function () {
		var n = this.domNode, i = n.firstChild, isLast = this.isLastChild(), isRoot = this.isRoot();
		if (!n) {
			return;
		}
		var ic = (isLast ? this.classes.lastLeaf : this.classes.leaf);
		if (isRoot) {
			ic = (isLast ? this.classes.rootLastLeaf : this.classes.rootLeaf);
		}
		if (i && i.className != ic) {
			i.className = ic;
		}
		var nc = (isLast ? this.classes.lastItem : "") + (this.closed ? "" : " " + this.classes.open);
		if (n.className != nc) {
			n.className = nc;
		}
		var hasChildren = !this._childrenRendered && (this.hasChildren || this._hasChildren || (this._data.children && this._data.children.length));
		var img = !this.kids.length && !hasChildren ? this.images.none : (this.closed ? this.images.closed : this.images.open), s = this.imageRoot + img;
		if (i && i.src != s) {
			i.src = s;
		}
	}, styleNodeNoDom:function () {
		var d = this.domNode, p = d.parentNode;
		if (p) {
			p.removeChild(d);
		}
		this.styleNode();
		if (p) {
			p.appendChild(d);
		}
	}, renderChild:function (inChild) {
		var i = dojo.indexOf(this.kids, inChild);
		if (i == -1) {
			inChild.placeInParent(inChild);
			i = dojo.indexOf(this.kids, inChild);
		}
		if (this.kids.length == 1) {
			this.styleNode();
			this.domNode.appendChild(this.createKidsNode());
		} else {
			if (i == this.kids.length - 1) {
				var c = this.kids[this.kids.length - 2];
				c.styleNodeNoDom();
			} else {
			}
		}
		inChild.styleNode();
		dojo.setSelectable(inChild.domNode, false);
		if (i == this.kids.length - 1) {
			this.kidsNode.appendChild(inChild.domNode);
		} else {
			this.kidsNode.insertBefore(inChild.domNode, this.kids[i + 1].domNode);
		}
	}, _findIndexInParent:function (inChild) {
		var parent = inChild.parent;
		if (parent) {
			for (var i = 0, l = parent.kids.length, k; i < l && (k = parent.kids[i]); i++) {
				if (inChild == k) {
					return i;
				}
			}
		}
		return -1;
	}, remove:function (inChild) {
		inChild.destroy();
	}, _remove:function (inChild) {
		var i = this._findIndexInParent(inChild);
		if (i >= 0) {
			var last = (i == this.kids.length - 1);
			this.kids.splice(i, 1);
			if (last && this.kids.length) {
				this.kids[this.kids.length - 1].styleNode();
			}
			if (!this.kids.length) {
				this.styleNode();
			}
			return true;
		}
	}, removeChildren:function () {
		while (this.kids.length) {
			this.remove(this.kids[0]);
		}
	}, initKids:function () {
		if (!this._childrenRendered) {
			if (this.initNodeChildren) {
				this.initNodeChildren(this);
			} else {
				this.tree.initNodeChildren(this);
			}
		}
		this._childrenRendered = true;
	}, setOpen:function (inOpen) {
		this.initKids();
		var c = this.closed;
		this.closed = !inOpen;
		if (c != this.closed && this.kidsNode) {
			(this.closed ? wm.collapseNode : wm.expandNode)(this.kidsNode);
			this.styleNode();
		}
	}, btnToggled:function (e) {
		this.tree.dispatchNodeEvent("Btnclick", this, e);
	}, mousedown:function (e) {
	}, click:function (e) {
		if (e.target == this.btnNode) {
			this.btnToggled(e);
		} else {
			this.tree.dispatchNodeEvent("Click", this, e);
		}
	}, dblclick:function (e) {
		this.tree.dispatchNodeEvent("Dblclick", this, e);
	}, styleContent:function () {
		this.contentNode.className = this.classes.content;
		if (this.selected) {
			this.contentNode.className += " " + this.classes.selected;
		}
	}, setContent:function (inContent) {
		this.content = inContent;
		var c = this.formatContent(), n = this.contentNode;
		if (n.nodeType == 3) {
			n.nodeValue = c;
		} else {
			n.innerHTML = c;
		}
	}, forEach:function (inFunc) {
		if (!inFunc) {
			return;
		}
		inFunc(this);
		this.forEachDescendant(inFunc);
	}, forEachDescendant:function (inFunc) {
		for (var i = 0, k, kids = this.kids; (k = kids[i]); i++) {
			k.forEach(inFunc);
		}
	}, forEachChild:function (inFunc) {
		for (var i = 0, k, kids = this.kids; (k = kids[i]); i++) {
			inFunc(k);
		}
	}, hasDescendant:function (inFunc) {
		try {
			if (inFunc(this)) {
				return true;
			}
		}
		catch (e) {
		}
		for (var i = 0, k, kids = this.kids; (k = kids[i]); i++) {
			if (k.hasDescendant(inFunc)) {
				return true;
			}
		}
		return false;
	}, findChild:function (inFunc) {
		for (var i = 0, k, kids = this.kids; (k = kids[i]); i++) {
			if (inFunc(k)) {
				return k;
			}
		}
		return null;
	}, buildPathString:function (inFunc) {
		if (this.parent == this.tree.root || this.parent == this.tree) {
			return "";
		}
		return this.parent.buildPathString(inFunc) + "/" + this.data.getItemName();
	}, findDomNode:function (inDomNode) {
		if (this.domNode == inDomNode || this.contentNode == inDomNode) {
			return this;
		}
		for (var i = 0; i < this.kids.length; i++) {
			var result = this.kids[i].findDomNode(inDomNode);
			if (result) {
				return result;
			}
		}
		return null;
	}});
	dojo.declare("wm.TreeCheckNode", wm.TreeNode, {checked:false, render:function () {
		this.inherited(arguments);
		this.setChecked(this.checked);
	}, createNode:function () {
		var li = this.domNode = document.createElement("li");
		li.innerHTML = ["<img/><input type=\"checkbox\" style=\"margin: 0 4px 0 0; padding:0;\"", this.checked ? " checked=\"yes\"" : "", "><span>" + this.formatContent() + "</span>"].join("");
		this.btnNode = li.firstChild;
		this.checkboxNode = this.btnNode.nextSibling;
		this.contentNode = this.checkboxNode.nextSibling;
	}, click:function (e) {
		if (e.target == this.checkboxNode) {
			this.checkboxClick(e);
		} else {
			this.inherited(arguments);
		}
	}, checkboxClick:function (e) {
		this.tree.dispatchNodeEvent("Checkboxclick", this, e);
	}, getChecked:function (inChecked) {
		return this.checkboxNode ? this.checkboxNode.checked : this.checked;
	}, setChecked:function (inChecked) {
		this.checkboxNode.checked = inChecked;
	}, toggleChecked:function () {
		this.setChecked(!this.checkBoxNode.checked);
	}});
	dojo.declare("wm.TreeRoot", wm.TreeNode, {render:function (inContent) {
		this.domNode = this.tree.domNode;
	}, addParent:function (inTree) {
		this.parent = this.tree = inTree;
		this.tree._addNode(this);
	}, styleNode:function () {
	}, placeInParent:function () {
	}});
	dojo.declare("wm.Tree", wm.Box, {width:"", height:"", connectors:true, selected:null, autoScroll:true, init:function () {
		this.inherited(arguments);
		dojo.addClass(this.domNode, "wmtree");
		this.setConnectors(this.connectors);
		this._nodeId = 0;
		this.nodes = [];
		this._imageRoot = wm.theme.getImagesPath();
		this.root = new wm.TreeRoot(this, "");
		this.connect(this.domNode, "onmousedown", this, "treeMouseDown");
		this.connect(this.domNode, "onclick", this, "treeClick");
		this.connect(this.domNode, "ondblclick", this, "treeDblClick");
	}, setConnectors:function (inConnectors) {
		var c = this.connectors = inConnectors;
		dojo[c ? "removeClass" : "addClass"](this.domNode, "wmtree-noconnectors");
	}, setDisabled:function (inDisabled) {
		this.inherited(arguments);
		if (inDisabled) {
			this.deselect();
		}
		dojo[inDisabled ? "addClass" : "removeClass"](this.domNode, "wmtree-disabled");
	}, forEachNode:function (inFunc) {
		if (dojo.isFunction(inFunc)) {
			this.root.forEach(inFunc);
		}
	}, clear:function () {
		this._data = {};
		this._nodeId = 0;
		this.selected = null;
		this.domNode.innerHTML = "";
		this.nodes = [];
		this.root.destroy();
		this.root = new wm.TreeRoot(this, "");
	}, toggle:function (inNode) {
		var old = this.selected, neo = this.selected = (old == inNode ? null : inNode);
		old && old.styleContent();
		(old != neo) && neo && neo.styleContent();
	}, eventSelect:function (inNode) {
		var selectInfo = {canSelect:true};
		this._oncanselect(inNode, selectInfo);
		if (inNode.canSelect && selectInfo.canSelect) {
			this.select(inNode);
		}
	}, addToSelection:function (inNode) {
		if (inNode) {
			this.selected = inNode;
			inNode.selected = true;
			inNode.styleContent();
			var n = inNode.domNode, d = this.domNode, fc = n.firstChild;
			if (n && d && fc) {
				var isAbove = (n.offsetTop < d.scrollTop), isBelow = (n.offsetTop + fc.offsetHeight > d.scrollTop + d.offsetHeight);
				if ((isAbove || isBelow) && wm.widgetIsShowing(this)) {
					n.scrollIntoView(false);
				}
			}
		}
	}, _deselect:function () {
		var old = this.selected;
		if (old) {
			if (this.selected) {
				this.selected.selected = false;
			}
			this.selected = null;
			old.styleContent();
		}
	}, _select:function (inNode) {
		this._deselect();
		this.addToSelection(inNode);
	}, deselect:function () {
		this.ondeselect(this.selected);
		this._deselect();
	}, select:function (inNode) {
		if (this.selected != inNode) {
			this.deselect();
			this.addToSelection(inNode);
			this.onselect(inNode);
		}
	}, initNodeChildren:function (inNode) {
		this.oninitchildren(inNode);
		this.renderDataNode(inNode, this.getNodeChildData(inNode));
	}, getNodeChildData:function (inNode) {
		return inNode._data.children;
	}, _render:function () {
		this.renderData(this._data);
	}, renderData:function (inData) {
		this.clear();
		this._data = inData;
		this.renderDataNode(this.root, this._data);
	}, renderDataNode:function (inParent, inData) {
		if (!inData) {
			return;
		}
		inParent._childrenRendered = true;
		dojo.forEach(inData, dojo.hitch(this, function (d) {
			var p = {data:d.data || d.content, _data:d, checked:d.checked, content:d.content, closed:d.closed, image:d.image, _childrenRendered:true}, n = new wm[d.type == "checkbox" ? "TreeCheckNode" : "TreeNode"](inParent, p);
			if (d.children && !d.closed) {
				this.renderDataNode(n, d.children);
			}
		}));
	}, _addNode:function (inNode) {
		var id = this.makeNodeId();
		inNode.id = id;
		this.nodes[id] = inNode;
	}, _removeNode:function (inNode) {
		this.nodes[inNode.id] = null;
	}, makeNodeId:function () {
		return this._nodeId++;
	}, findEventNode:function (e) {
		var n = e.target;
		while (n.nodeId === undefined && n != this.domNode) {
			n = n.parentNode;
		}
		if (n.nodeId !== undefined) {
			return this.nodes[n.nodeId];
		}
	}, treeMouseDown:function (e) {
		var n = this.findEventNode(e);
		if (n) {
			n.mousedown(e);
			this.onmousedown(e, n);
		}
	}, treeClick:function (e) {
		var n = this.findEventNode(e);
		if (n) {
			n.click(e);
		} else {
			this.deselect();
		}
	}, treeDblClick:function (e) {
		var n = this.findEventNode(e);
		if (n) {
			n.dblclick(e);
		}
	}, dispatchNodeEvent:function (inEventName, inNode, inEvent) {
		if (this.disabled) {
			inEvent._treeHandled = true;
		} else {
			inEvent.treeNode = inNode;
			wm.fire(this, "node" + inEventName, [inNode, inEvent]);
		}
	}, nodeClick:function (inNode, inEvent) {
		if (inEvent._treeHandled) {
			return;
		}
		inEvent._treeHandled = true;
		this.eventSelect(inNode);
		setTimeout(dojo.hitch(this, "onclick", inNode), 1);
	}, nodeDblclick:function (inNode, inEvent) {
		if (inEvent._treeHandled) {
			return;
		}
		inEvent._treeHandled = true;
		wm.clearSelection();
		this.ondblclick(inNode);
	}, nodeCheckboxclick:function (inNode, inEvent) {
		if (inEvent._treeHandled) {
			return;
		}
		inEvent._treeHandled = true;
		this.oncheckboxclick(inNode, inEvent);
	}, nodeBtnclick:function (inNode, inEvent) {
		if (inEvent._treeHandled) {
			return;
		}
		inEvent._treeHandled = true;
		inNode.setOpen(inNode.closed);
	}, _nodeMatchesProps:function (inNode, inProps) {
		for (var i in inProps) {
			if (inNode[i] != inProps[i]) {
				return;
			}
		}
		return true;
	}, findNode:function (inProps, inStartNode) {
		var n = inStartNode || this.root;
		for (var i = 0, k, c; (k = n.kids[i]); i++) {
			if (this._nodeMatchesProps(k, inProps)) {
				return k;
			} else {
				c = this.findNode(inProps, k);
				if (c) {
					return c;
				}
			}
		}
	}, findTreeNode:function (dataValue, inStartNode) {
		var n = inStartNode || this.root;
		for (var i = 0, k, c; (k = n.kids[i]); i++) {
			if (dataValue == k.data) {
				return k;
			} else {
				c = this.findTreeNode(dataValue, k);
				if (c) {
					return c;
				}
			}
		}
	}, findDomNode:function (inDomNode) {
		return this.root.findDomNode(inDomNode);
	}, onclick:function (inNode) {
	}, _oncanselect:function (inNode, inSelectInfo) {
	}, onmousedown:function (inNode) {
	}, onselect:function (inNode) {
	}, ondeselect:function (inNode) {
	}, ondblclick:function (inNode) {
	}, oninitchildren:function (inNode) {
	}});
	wm.Object.extendSchema(wm.Tree, {disabled:{ignore:1}, nodes:{ignore:1}});
	wm.Tree.extend({themeable:false});
	wm.collapseNode = function (n, step, accel, interval) {
		n.style.display = "none";
		return;
		var v = step || 30, a = accel || 5, i = interval || 2, h = n._height = n.offsetHeight, s = n.style;
		function act() {
			h -= (v += a);
			if (h <= 0) {
				s.display = "none";
				s.height = "";
			} else {
				s.height = h + "px";
				setTimeout(act, i);
			}
		}
		act();
	};
	wm.expandNode = function (n, step, accel, interval) {
		if (n) {
			n.style.display = "";
		}
		return;
		var v = step || 30, a = accel || 5, i = interval || 2, h = 0, s = n.style;
		s.display = "";
		if (!n._height) {
			var ns = n.parentNode.style, o = ns.overflow;
			ns.overflow = "hidden";
			n._height = n.offsetHeight;
			s.height = "1px";
			ns.overflow = o;
		} else {
			s.height = "1px";
		}
		function act() {
			h += (v += a);
			s.height = h + "px";
			if (n.offsetHeight + v >= n._height) {
				s.height = "";
			} else {
				setTimeout(act, i);
			}
		}
		act();
	};
}
if (!dojo._hasResource["wm.base.widget.Label"]) {
	dojo._hasResource["wm.base.widget.Label"] = true;
	dojo.provide("wm.base.widget.Label");
	dojo.declare("wm.Label", wm.Control, {width:"200px", height:"36px", caption:"", link:"", display:"", format:"(details)", padding:4, singleLine:true, align:"none", init:function () {
		dojo.addClass(this.domNode, "wmlabel");
		this.inherited(arguments);
		this.connectEvents(this.domNode, ["click"]);
	}, click:function (e) {
		this.onclick(e);
	}, postInit:function () {
		this.inherited(arguments);
		if (!this.$.format) {
			new wm.DataFormatter({name:"format", owner:this});
		}
		this.caption = this.label || this.content || this.caption;
		delete this.content;
		delete this.label;
		this.renderLabel();
		this.valueChanged("caption", this.caption);
		this.valueChanged("link", this.link);
	}, renderLabel:function () {
		if (this._loading) {
			return;
		}
		var c = this.$.format.format(this.caption);
		if (this.link) {
			c = ["<a ", (this.link.indexOf("#") == -1 && this.link.indexOf("javascript") == -1) ? "target=\"_blank\" " : "", "href=\"", this.link, "\">", c, "</a>"].join("");
		}
		if (this.domNode.innerHTML != c) {
			this.domNode.innerHTML = c;
		}
		var whitespace = (this.singleLine || this.autoSizeWidth) ? "nowrap" : "normal";
		if (this.domNode.style.whiteSpace != whitespace) {
			this.domNode.style.whiteSpace = whitespace;
		}
		var align = (this.align == "none") ? "" : this.align;
		if (this.domNode.style.textAlign != align) {
			this.domNode.style.textAlign = align;
		}
	}, setCaption:function (inCaption) {
		var innerHTML = this.domNode.innerHTML;
		if (inCaption && dojo.isArray(inCaption)) {
			inCaption = inCaption.join(", ");
		} else {
			if (inCaption && dojo.isObject(inCaption)) {
				inCaption = "";
			}
		}
		this.caption = inCaption;
		this.renderLabel();
		if (innerHTML != this.domNode.innerHTML && (this.autoSizeHeight || this.autoSizeWidth)) {
			this.scheduleAutoSize();
		}
	}, scheduleAutoSize:function () {
		this._needsAutoSize = true;
		return wm.job(this.getId() + ": doAutoSize", 10, dojo.hitch(this, function () {
			this.doAutoSize(true, false);
		}));
	}, doAutoSize:function (setSize, force) {
		if (this._doingAutoSize || !this.autoSizeHeight && !this.autoSizeWidth) {
			return;
		}
		if (!force && !this._needsAutoSize) {
			return;
		}
		if (this.isAncestorHidden()) {
			return;
		}
		this._doingAutoSize = true;
		this._needsAutoSize = false;
		var divObj = wm.Label.sizingNode;
		divObj.innerHTML = this.caption;
		divObj.className = this.domNode.className;
		var b = this.bounds;
		var s = divObj.style;
		s.position = "absolute";
		s.height = (!this.autoSizeHeight) ? (b.h - this.padBorderMargin.t - this.padBorderMargin.b) + "px" : "";
		s.width = (!this.autoSizeWidth) ? (b.w - this.padBorderMargin.l - this.padBorderMargin.r) + "px" : "";
		s.paddingLeft = (this.autoSizeWidth) ? (this.padBorderMargin.l + this.padBorderMargin.r) + "px" : "";
		s.paddingTop = (this.autoSizeHeight) ? (this.padBorderMargin.t + this.padBorderMargin.b) + "px" : "";
		s.lineHeight = (this.singleLine || this.autoSizeWidth) ? b.h + "px" : "normal";
		s.whiteSpace = (this.singleLine || this.autoSizeWidth) ? "nowrap" : "";
		this.parent.domNode.appendChild(divObj);
		var captionWidth = divObj.clientWidth;
		var captionHeight = divObj.clientHeight;
		divObj.parentNode.removeChild(divObj);
		if (this.autoSizeHeight) {
			var newh = captionHeight;
			var minHeight = this.getMinHeightProp();
			if (newh < minHeight) {
				newh = minHeight;
			}
			if (setSize) {
				this.setHeight(newh + "px");
			} else {
				this.bounds.h = newh;
				this.height = newh + "px";
			}
		}
		if (this.autoSizeWidth) {
			var neww = captionWidth;
			var minWidth = this.getMinWidthProp();
			if (neww < minWidth) {
				neww = minWidth;
			}
			if (setSize) {
				this.setWidth(neww + "px");
			} else {
				this.bounds.w = neww;
				this.width = neww + "px";
			}
		}
		if (this.isDesignLoaded() && studio.designer.selected == this) {
			studio.inspector.reinspect();
		}
		this._doingAutoSize = false;
	}, setLink:function (inLink) {
		this.link = inLink;
		this.renderLabel();
	}, setSingleLine:function (inSingleLine) {
		var oldSingleLine = this.singleLine;
		this.singleLine = inSingleLine;
		if (oldSingleLine != inSingleLine) {
			this.domNode.style.lineHeight = (inSingleLine) ? this.bounds.h + "px" : "normal";
		}
		this.renderLabel();
		if (inSingleLine && this.autoSizeHeight) {
			this.autoSizeHeight = false;
		}
		if (inSingleLine != oldSingleLine && (this.autoSizeHeight || this.autoSizeWidth)) {
			this.scheduleAutoSize();
		}
	}, setAlign:function (inAlign) {
		this.align = inAlign;
		this.renderLabel();
	}, formatChanged:function () {
		this.renderLabel();
	}, onclick:function (inEvent) {
	}});
	wm.Object.extendSchema(wm.Label, {disabled:{ignore:1}, caption:{type:"String", bindable:1, group:"display", order:100, focus:true}, display:{group:"format", order:20}, align:{group:"display", order:25}, singleLine:{group:"display", order:200}, format:{ignore:1, writeonly:1, categoryParent:"Properties", categoryProps:{component:"format"}}, link:{type:"String", bindable:1, group:"format", order:40}, autoSizeHeight:{type:"Boolean", group:"advanced layout", order:31, writeonly:true, ignore:true}, autoSizeWidth:{type:"Boolean", group:"advanced layout", order:32, shortname:"Auto Size"}});
	wm.Label.description = "A simple label.";
	wm.Label.extend({themeable:false, designCreate:function () {
		if (this._studioCreating) {
			this.studioCreate();
		}
		this.inherited(arguments);
	}, afterPaletteDrop:function () {
		this.caption = this.caption || this.name;
		this.renderLabel();
	}, setDisplay:function (inDisplay) {
		if (this.display == inDisplay) {
			return;
		}
		this.display = inDisplay;
		var ctor = wm.getFormatter(this.display);
		this.components.format.destroy();
		new ctor({name:"format", owner:this});
		this.renderLabel();
	}, makePropEdit:function (inName, inValue, inDefault) {
		switch (inName) {
		  case "display":
			return makeSelectPropEdit(inName, inValue, [""].concat(wm.formatters), inDefault);
		  case "autoSizeWidth":
			return makeSelectPropEdit(inName, (this.autoSizeHeight) ? "height" : (this.autoSizeWidth) ? "width" : "none", ["none", "width", "height"], inDefault);
		  case "align":
			return makeSelectPropEdit(inName, inValue, ["none", "left", "center", "right", "justify"], inDefault);
		}
		return this.inherited(arguments);
	}, setAutoSizeWidth:function (inValue) {
		if (inValue == "none") {
			wm.Control.prototype.setAutoSizeWidth.call(this, false);
			this.setAutoSizeHeight(false);
		} else {
			if (inValue == "width") {
				if (inValue) {
					this.setSingleLine(true);
				}
				this.setAutoSizeHeight(false);
				wm.Control.prototype.setAutoSizeWidth.call(this, true);
			} else {
				if (inValue == "height") {
					if (inValue) {
						this.setSingleLine(false);
					}
					wm.Control.prototype.setAutoSizeWidth.call(this, false);
					this.setAutoSizeHeight(true);
				}
			}
		}
	}, addUserClass:function (inClass, inNodeName) {
		this.inherited(arguments);
		if (this.autoSizeHeight || this.autoSizeWidth) {
			this.scheduleAutoSize();
		}
	}});
	wm.Label.sizingNode = document.createElement("div");
}
if (!dojo._hasResource["wm.base.widget.IFrame"]) {
	dojo._hasResource["wm.base.widget.IFrame"] = true;
	dojo.provide("wm.base.widget.IFrame");
	dojo.declare("wm.IFrame", wm.Box, {scrim:true, source:"", build:function () {
		this.frame = document.createElement("iframe");
		this.domNode = dojo.byId(this.domNode || this.id || undefined);
		if (!this.domNode) {
			this.domNode = this.frame;
		} else {
			this.domNode.appendChild(this.frame);
		}
	}, init:function () {
		dojo.addClass(this.domNode, "wmiframe");
		this.inherited(arguments);
		this.setSource(this.source);
	}, setSource:function (inSource) {
		if (!dojo.isString(inSource) || inSource == "undefined") {
			inSource = "";
		}
		this.source = inSource;
		var root = this.source.slice(0, 4) != "http" && this.source.slice(0, 1) != "/" ? this.getPath() : "";
		this.frame.src = this.source ? root + this.source : this.source;
	}});
	wm.Object.extendSchema(wm.IFrame, {disabled:{ignore:1}, source:{type:"String", bindable:1}});
	wm.IFrame.description = "A frame.";
	dojo.extend(wm.IFrame, {themeable:false});
}
if (!dojo._hasResource["wm.base.widget.gadget.Gadget"]) {
	dojo._hasResource["wm.base.widget.gadget.Gadget"] = true;
	dojo.provide("wm.base.widget.gadget.Gadget");
	dojo.declare("wm.Gadget", wm.IFrame, {width:"268px", height:"246px", update:function () {
		this.setSource(this.source);
	}});
	wm.Object.extendSchema(wm.Gadget, {source:{ignore:1}});
}
if (!dojo._hasResource["wm.base.widget.gadget.Stocks"]) {
	dojo._hasResource["wm.base.widget.gadget.Stocks"] = true;
	dojo.provide("wm.base.widget.gadget.Stocks");
	dojo.declare("wm.gadget.Stocks", wm.Gadget, {ticker:"GOOG", source:"http://gmodules.com/ig/ifr?url=http://www.tigersyard.com/gadgets/stock.xml&up_price1=200&up_refreshtime=1000&up_symbol1=GOOG&up_shares1=5&up_link=google&synd=open&w=320&h=190&title=Stocks&border=%23ffffff%7C3px%2C1px+solid+%23999999", setTicker:function (inTicker) {
		this.ticker = inTicker;
		this.update();
	}, update:function () {
		var rx = new RegExp("up_symbol1=[^&]*&", "g");
		this.source = this.source.replace(rx, "up_symbol1=" + this.ticker + "&");
		this.inherited(arguments);
	}});
	wm.Object.extendSchema(wm.gadget.Stocks, {ticker:{bindable:1, type:"String"}});
}
if (!dojo._hasResource["wm.base.widget.gadget.Weather"]) {
	dojo._hasResource["wm.base.widget.gadget.Weather"] = true;
	dojo.provide("wm.base.widget.gadget.Weather");
	dojo.declare("wm.gadget.Weather", wm.Gadget, {zip:"94105", source:"http://gmodules.com/ig/ifr?url=http://www.labpixies.com/campaigns/weather/weather.xml&up_degree_unit_type=0&up_city_code=none&up_zip_code=94105&synd=open&w=320&h=224&title=Live+Weather&border=%23ffffff%7C3px%2C1px+solid+%23999999", setZip:function (inZip) {
		this.zip = inZip;
		this.update();
	}, update:function () {
		var rx = new RegExp("up_zip_code=[^&]*&", "g");
		this.source = this.source.replace(rx, "up_zip_code=" + this.zip + "&");
		this.inherited(arguments);
	}});
	wm.Object.extendSchema(wm.gadget.Weather, {zip:{bindable:1, type:"String"}});
}
if (!dojo._hasResource["wm.base.widget.gadget.YouTube"]) {
	dojo._hasResource["wm.base.widget.gadget.YouTube"] = true;
	dojo.provide("wm.base.widget.gadget.YouTube");
	dojo.declare("wm.gadget.YouTube", wm.Gadget, {init:function () {
		this.inherited(arguments);
		this.domNode.style.overflow = "auto";
	}, source:"http://gmodules.com/ig/ifr?url=http://throttled.org/googlegadgets/youtubesearch.xml&synd=open&w=320&h=250&title=Search+YouTube&border=%23ffffff%7C3px%2C1px+solid+%23999999"});
}
if (!dojo._hasResource["wm.base.widget.PageContainer"]) {
	dojo._hasResource["wm.base.widget.PageContainer"] = true;
	dojo.provide("wm.base.widget.PageContainer");
	wm.pagesFolder = "pages/";
	dojo.declare("wm.PageContainer", wm.Box, {width:"100%", height:"100%", pageName:"", deferLoad:false, loadParentFirst:true, pageProperties:null, classNames:"wmpagecontainer", init:function () {
		this.pageLoadedList = [];
		this.inherited(arguments);
		this.createPageLoader();
		this.pageLoadedDeferred = new dojo.Deferred();
		if (!this.deferLoad || !this.isAncestorHidden()) {
			this.loadPage(this.pageName);
		}
		dojo.addOnWindowUnload(this, "destroy");
	}, postInit:function () {
		this.inherited(arguments);
		if (this.isDesignedComponent() && this.designWrapper) {
			dojo.addClass(this.designWrapper.domNode, "pageContainerDesignWrapper");
			this.designWrapper.domNode.style.backgroundColor = "white";
			this.createOpenPageButton();
		}
	}, createOpenPageButton:function () {
		if (this.openPageButton) {
			dojo.destroy(this.openPageButton);
			dojo.disconnect(this.openPageButtonConnect);
		}
		var openPageButton = this.openPageButton = document.createElement("div");
		openPageButton.className = "openPageContainerDesignWrapperButton" + ((this.pageName) ? " hasPageName" : "");
		openPageButton.innerHTML = (this.pageName) ? "Open Page" : "New Page";
		this.designWrapper.domNode.appendChild(openPageButton);
		this._designerOpenPageButton = openPageButton;
		this.openPageButtonConnect = dojo.connect(openPageButton, "onclick", this, function () {
			if (this.pageName) {
				if (!studio.isPageDirty() || window.confirm("Are you sure you want to close the current page and open " + this.pageName + "?")) {
					studio.project.openPage(this.pageName);
				}
			} else {
				this.createNewPage();
			}
		});
	}, createPageLoader:function () {
		this._pageLoader = new wm.PageLoader({owner:this, domNode:this.domNode, isRelativePositioned:this.isRelativePositioned});
		this._connections.push(this.connect(this._pageLoader, "onPageChanged", this, "pageChanged"));
	}, getMainPage:function () {
		var owner = this.owner;
		while (owner.owner) {
			owner = owner.owner;
		}
		if (owner instanceof wm.Application) {
			return owner;
		}
	}, destroy:function () {
		if (this.isDestroyed) {
			return;
		}
		var owner = this.getMainPage();
		if (owner) {
			owner.subPageUnloaded(this.page);
		}
		try {
			this.inherited(arguments);
		}
		catch (e) {
		}
		if (this._pageLoader) {
			this.destroyPreviousPage();
			this._pageLoader.destroy();
			this._pageLoader = null;
		}
		owner = null;
	}, destroyPreviousPage:function () {
		for (var i = 0; i < this.pageLoadedList.length; i++) {
			try {
				this._pageLoader.destroyPage(this.pageLoadedList[i]);
			}
			catch (e) {
				console.info("couldnt delete page <--------------");
			}
		}
		this.pageLoadedList = [];
	}, pageChanged:function (inPage, inPreviousPage) {
		try {
			this.destroyPreviousPage();
			this.pageLoadedList.push(inPage);
			this.page = inPage;
			this[inPage.name] = inPage;
			var owner = this.getMainPage();
			if (owner) {
				owner.subPageLoaded(this.page);
			}
			if (this.page.root) {
				this.page.root.parent = this;
			}
			if (this.pageLoadedDeferred) {
				this.pageLoadedDeferred.callback({page:inPage, previousPage:inPreviousPage});
			}
			this.onPageChanged(inPage, inPreviousPage);
			var o = (inPreviousPage || 0).name;
			if (o && this[o]) {
				delete this[o];
			}
		}
		catch (e) {
			console.info("error in pageChanged in pagecontainer.js ......", e);
		}
	}, loadPage:function (inName) {
		try {
			var d = this.isDesignLoaded(), s = wm.studioConfig;
			if (d && s && s.preventSubPages) {
				return;
			}
			var pageName = inName.charAt(0).toLowerCase() + inName.slice(1);
			if (pageName) {
				if (!d && this.loadParentFirst && this.getParentPage()._loadingPage) {
					if (!this._pageLoaderConnectedToOwnerStart) {
						if (this._currentPageConnect) {
							dojo.disconnect(this._currentPageConnect);
						}
						this._currentPageConnect = this.owner.connect(this.owner, "start", dojo.hitch(this, "pageLoaderOnOwnerStart", inName, pageName));
						this._pageLoaderConnectedToOwnerStart = true;
					}
				} else {
					this._pageLoader.loadPage(inName, pageName);
					if (this._currentPageConnect) {
						dojo.disconnect(this._currentPageConnect);
					}
					if (this._pageLoader.page._startCalled) {
						this.onStart();
					} else {
						this._currentPageConnect = this._pageLoader.page.connect(this._pageLoader.page, "onStart", this, "onStart");
					}
				}
			} else {
				this.destroyPreviousPage();
			}
		}
		catch (e) {
			console.error("PageContainer page  '" + inName + "' failed to load: " + e);
		}
	}, pageLoaderOnOwnerStart:function (inName, pageName) {
		this._pageLoaderConnectedToOwnerStart = false;
		this._pageLoader.loadPage(inName, pageName);
		this._pageLoader.page.connect(this._pageLoader.page, "onStart", this, "onStart");
	}, onStart:function () {
		if (this.parent && this.page && !dojo.coords(this.page.root.domNode).w) {
			this.parent.reflow();
		}
	}, forEachWidget:function (inFunc) {
		if (this.page) {
			return this.page.forEachWidget(inFunc);
		}
	}, setPageName:function (inPageName) {
		if (this._pageLoading) {
			return;
		}
		if (inPageName == "-New Page" && this.isDesignLoaded()) {
			return this.createNewPage();
		}
		if (this._designerOpenPageButton) {
			dojo[this.pageName ? "addClass" : "removeClass"](this._designerOpenPageButton, "hasPageName");
		}
		var o = this.pageName;
		this.pageName = inPageName || "";
		if (this.isDesignedComponent() && this.designWrapper) {
			this.createOpenPageButton();
		}
		this.pageLoadedDeferred = new dojo.Deferred();
		if (o != this.pageName) {
			this.loadPage(this.pageName);
		}
	}, forceReloadPage:function () {
		var pageName = this.pageName;
		this.setPageName(null);
		delete window[pageName];
		this.setPageName(pageName);
	}, onPageChanged:function (inNewPage, inPreviousPage) {
	}, _onShowParent:function () {
		this.revealed();
	}, revealed:function () {
		if (!this.page) {
			this.loadPage(this.pageName);
		}
	}, flow:function () {
		if (this._boundsDirty) {
			wm.fire(this.page, "reflow");
		}
	}, reflow:function () {
		this._boundsDirty = true;
		this.flow();
	}, hasPageLoaded:function (optionalPageName) {
		if (!optionalPageName) {
			return Boolean(this.page);
		}
		return Boolean(this.page && this.page.name == optionalPageName);
	}});
	wm.PageContainer.extend({themeable:false, scrim:true, _isBindSource:true, createNewPage:function () {
		var pages = studio.project.getPageList();
		var l = {};
		dojo.forEach(pages, function (p) {
			l[p] = true;
		});
		studio.promptForName("page", wm.findUniqueName("Page", [l]), pages, dojo.hitch(this, function (n) {
			n = wm.capitalize(n);
			this.pageName = n;
			app.confirm("Can we save your current page before moving on to the next page? This will save your pageContainer's pageName.", false, dojo.hitch(this, function () {
				studio.project.saveProject();
				studio.project.newPage(n);
			}), dojo.hitch(this, function () {
				studio.project.newPage(n);
			}));
		}));
	}, designCreate:function () {
		this.inherited(arguments);
		if (this.designWrapper) {
			dojo.addClass(this.designWrapper.domNode, "wmchrome-wrapper");
		}
	}, writeChildren:function () {
		return [];
	}, writeComponents:function (inIndent) {
		var s = [];
		c = this.components.binding.write(inIndent);
		if (c) {
			s.push(c);
		}
		return s;
	}, makePropEdit:function (inName, inValue, inDefault) {
		switch (inName) {
		  case "pageName":
			return new wm.propEdit.PagesSelect({component:this, name:inName, value:inValue, newPage:true});
		}
		return this.inherited(arguments);
	}, afterPaletteDrop:function () {
		this.deferLoad = true;
	}});
	wm.Object.extendSchema(wm.PageContainer, {pageLoadedDeferred:{ignore:1}, pageName:{group:"common", bindable:1, type:"string", order:50}, deferLoad:{group:"common", order:100}, loadParentFirst:{group:"common", order:101}, box:{ignore:1}, disabled:{ignore:1}, page:{ignore:1}, pageProperties:{ignore:1, writeonly:1}});
}
if (!dojo._hasResource["wm.base.widget.Table.builder"]) {
	dojo._hasResource["wm.base.widget.Table.builder"] = true;
	dojo.provide("wm.base.widget.Table.builder");
	wm.getTr = function (inTable, index) {
		return inTable && ((inTable.rows || 0)[index] || inTable.childNodes[index]);
	};
	wm.getTd = function (inTable, rowIndex, cellIndex) {
		return (wm.getTr(inTable, rowIndex) || 0).childNodes[cellIndex];
	};
	dojo.declare("wm.table.builder", null, {rowCount:0, colCount:0, constructor:function (inClassName, inRowClassName, inColumnClassName) {
		this.className = inClassName || "";
		this.rowClassName = inRowClassName || "";
		this.columnClassName = inColumnClassName || "";
	}, _table:["<table class=\"", "", "\" cellspacing=\"0\" cellpadding=\"0\">"], generateCell:function (inRow, inCol, inHeader) {
		var tag = (inHeader ? "th" : "td"), html = ["<", tag, " "], s = (this.getCellStyle) && this.getCellStyle(inRow, inCol), c = this.columnClassName || ((this.getCellClass) && this.getCellClass(inRow, inCol));
		s && html.push([" style=\"", s, "\""].join(""));
		c && html.push([" class=\"", c, "\""].join(""));
		html.push(">");
		html.push(this.getCellContent(inRow, inCol, inHeader));
		html.push("</" + tag + ">");
		return html.join("");
	}, generateRow:function (inRow, inHeader) {
		var s = (this.getRowStyle) && this.getRowStyle(inRow), c = this.rowClassName || ((this.getRowClass) && this.getRowClass(inRow));
		var html = ["<tr", " style=\"", s, "\" class=\"", c, "\">"];
		for (var i = 0, l = this.colCount; i < l; i++) {
			html.push(this.generateCell(inRow, i, inHeader));
		}
		html.push("</tr>");
		return html.join("");
	}, generateTableStart:function () {
		var result = this._table.concat([]);
		result[1] = this.className;
		return result.join("");
	}, generateTableEnd:function () {
		return "</table>";
	}, generateHtml:function () {
		result = [this.generateTableStart()];
		for (var i = 0, l = this.rowCount; i < l; i++) {
			result.push(this.generateRow(i));
		}
		result.push(this.generateTableEnd());
		return result.join("");
	}, generateHeaderHtml:function () {
		result = [this.generateTableStart()];
		result.push(this.generateRow(-1, true));
		result.push(this.generateTableEnd());
		return result.join("");
	}, generateEmptyTable:function () {
		return [this.generateTableStart(), this.generateTableEnd()].join("");
	}});
}
if (!dojo._hasResource["wm.base.widget.VirtualList"]) {
	dojo._hasResource["wm.base.widget.VirtualList"] = true;
	dojo.provide("wm.base.widget.VirtualList");
	dojo.declare("wm.VirtualListItem", null, {selected:false, className:"wmlist-item", constructor:function (inList, inText, inImage) {
		this.list = inList;
		this.connections = [];
		this.create();
		this.setContent(inText, inImage);
	}, destroy:function () {
		dojo.forEach(this.connections, function (inConnect) {
			dojo.disconnect(inConnect);
		});
	}, create:function () {
		var n = this.domNode = document.createElement("div");
		dojo.addClass(n, this.className);
		this.makeConnections();
	}, makeConnections:function () {
		this.connections = [dojo.connect(this.domNode, "mouseover", this, "mouseover"), dojo.connect(this.domNode, "mouseout", this, "mouseout"), dojo.connect(this.domNode, "click", this, "click"), dojo.connect(this.domNode, "dblclick", this, "dblclick")];
	}, setContent:function (inContent) {
		this.domNode.innerHTML = inContent;
	}, getContent:function () {
		return this.domNode.innerHTML;
	}, doOver:function () {
		dojo.addClass(this.domNode, this.className + "-over");
	}, mouseover:function (e) {
		if (e && e.currentTarget == this.domNode) {
			this.list._onmouseover(e, this);
		}
	}, mouseout:function (e) {
		if (e.currentTarget == this.domNode) {
			dojo.removeClass(this.domNode, this.className + "-over");
		}
	}, click:function (e) {
		this.list.onclick(e, this);
	}, dblclick:function (e) {
		this.list.ondblclick(e, this);
	}, select:function () {
		this.selected = true;
		dojo.addClass(this.domNode, this.className + "-selected");
	}, deselect:function () {
		this.selected = false;
		dojo.removeClass(this.domNode, this.className + "-selected");
	}});
	dojo.declare("wm.VirtualList", wm.Box, {headerVisible:true, toggleSelect:false, width:"250px", height:"150px", box:"v", multiSelect:false, className:"wmlist", selectedItem:null, init:function () {
		this.inherited(arguments);
		this.items = [];
		this.selection = [];
		this.selectedItem = new wm.Variable({name:"selectedItem", owner:this});
		this.createHeaderNode();
		this.createListNode();
		this.domNode.appendChild(this.headerNode);
		this.domNode.appendChild(this.listNode);
		this.setHeaderVisible(this.headerVisible);
	}, dataSetToSelectedItem:function (inDataSet) {
		this.selectedItem.setLiveView((inDataSet || 0).liveView);
		this.selectedItem.setType(inDataSet ? inDataSet.type : "any");
	}, getCount:function () {
		return this.items.length;
	}, getItem:function (inIndex) {
		return this.items[inIndex];
	}, getItemByCallback:function (callback) {
		for (var i = 0; i < this.getCount(); i++) {
			var d = this.items[i].getData();
			if (callback(d)) {
				return this.items[i];
			}
		}
	}, getItemByFieldName:function (inName, inValue) {
		for (var i = 0; i < this.getCount(); i++) {
			var d = this.items[i].getData();
			if (d[inName] == inValue) {
				return this.items[i];
			}
		}
	}, createListNode:function () {
		this.listNode = document.createElement("div");
		this.listNode.flex = 1;
		dojo.addClass(this.listNode, "wmlist-list");
	}, createHeaderNode:function () {
		this.headerNode = document.createElement("div");
		dojo.addClass(this.headerNode, "wmlist-header");
	}, clear:function () {
		this._setHeaderVisible(false);
		while (this.getCount()) {
			this.removeItem(this.getCount() - 1);
		}
		this.deselectAll();
		this._setSelected(null);
	}, createItem:function (inContent) {
		return new wm.VirtualListItem(this, inContent);
	}, addItem:function (inContent, inIndex) {
		var li = this.createItem(inContent), ln = this.listNode;
		dojo.setSelectable(li.domNode, false);
		if (inIndex != undefined) {
			this.items.splice(inIndex, 0, li);
			li.index = inIndex;
			this.selection.splice(inIndex, 0, false);
			this.updateItemIndexes(inIndex + 1, 1);
			var sibling = ln.childNodes[inIndex];
			if (sibling) {
				ln.insertBefore(li.domNode, ln.childNodes[inIndex]);
			} else {
				ln.appendChild(li.domNode);
			}
		} else {
			this.items.push(li);
			li.index = this.items.length - 1;
			ln.appendChild(li.domNode);
		}
	}, removeItem:function (inIndex) {
		var li = this.getItem(inIndex);
		if (li) {
			this.listNode.removeChild(li.domNode);
			this.items.splice(inIndex, 1);
			this.selection.splice(inIndex, 1);
			this.updateItemIndexes(inIndex, -1);
			li.destroy();
		}
	}, updateItemIndexes:function (inStart, inDelta) {
		for (var i = inStart, l = this.getCount(), li; i < l && (li = this.items[i]); i++) {
			li.index += inDelta;
		}
	}, removeItems:function (inIndexes) {
		for (var i = inIndexes.length, index; ((index = inIndexes[i]) != undefined); i--) {
			this.removeItem(index);
		}
	}, modifyItem:function (inIndex, inContent) {
		var li = this.getItem(inIndex);
		(li ? li.setContent(inContent) : this.addItem(inContent));
	}, renderHeader:function (inHtml) {
		this.headerNode.innerHTML = inHtml;
	}, _setHeaderVisible:function (inHeaderVisible) {
		this.headerNode.style.display = inHeaderVisible ? "" : "none";
	}, setHeaderVisible:function (inHeaderVisible) {
		this.headerVisible = inHeaderVisible;
		if (this.getCount()) {
			if (this.headerVisible) {
				this.renderHeader();
			}
			this._setHeaderVisible(this.headerVisible);
			this.reflow();
		}
	}, _setSelected:function (inItem) {
		this.selected = inItem;
		if (this.selected) {
			this.selectedItem.setData(this.selected);
		} else {
			this.selectedItem.clearData();
		}
	}, addToSelection:function (inItem) {
		if (!inItem) {
			return;
		}
		this.selection[inItem.index] = true;
		this.lastSelected = this.selected;
		this._setSelected(inItem);
		inItem.select();
	}, removeFromSelection:function (inItem) {
		this.selection[inItem.index] = false;
		inItem.deselect();
		this._setSelected(this.lastSelected);
	}, deselectAll:function (ignoreSelectedItem) {
		dojo.forEach(this.items, function (i) {
			i.deselect();
		});
		this.selection = [];
		if (!ignoreSelectedItem) {
			this._setSelected(null);
		}
	}, isSelected:function (inItem) {
		return this.selection[inItem.index];
	}, ctrlSelect:function (inItem) {
		if (this.isSelected(inItem)) {
			this.eventDeselect(inItem);
		} else {
			this.eventSelect(inItem);
		}
	}, shiftSelect:function (inItem) {
		var t = s = (this.selected || this.lastSelected || 0).index, e = inItem.index, t;
		this.deselectAll();
		if (s > e) {
			s = e;
			e = t;
		}
		for (var i = s, li; i <= e && (li = this.getItem(i)); i++) {
			this.addToSelection(li);
		}
	}, clickSelect:function (inItem, inEvent) {
		if (this.multiSelect && (inEvent.ctrlKey || inEvent.shiftKey)) {
			if (inEvent.ctrlKey) {
				this.ctrlSelect(inItem);
			} else {
				if (inEvent.shiftKey) {
					this.shiftSelect(inItem);
				}
			}
		} else {
			var s = this.selected, oldIndex = s && s.index, newIndex = inItem.index;
			if (oldIndex !== newIndex) {
				this.eventDeselect(inItem, true);
				this.eventSelect(inItem);
			} else {
				if (this.toggleSelect) {
					this.eventDeselect(inItem);
				}
			}
		}
	}, eventDeselect:function (inItem, ignoreSelectedItem) {
		if (this.multiSelect) {
			this.removeFromSelection(inItem);
		} else {
			this.deselectAll(ignoreSelectedItem);
		}
		this.ondeselect(inItem);
	}, eventSelect:function (inItem) {
		var selectInfo = {canSelect:true};
		this._oncanselect(inItem, selectInfo);
		if (selectInfo.canSelect) {
			this.addToSelection(inItem);
			this.onselect(inItem);
		}
	}, select:function (inItem) {
		if (inItem) {
			this.deselectAll();
			this.addToSelection(inItem);
		}
	}, selectByIndex:function (inIndex) {
		var i = this.getItem(inIndex);
		if (i) {
			this.select(i);
		}
	}, getSelectedIndex:function () {
		return this.selected ? this.selected.index : -1;
	}, _oncanmouseover:function (inEvent, inItem, inMouseOverInfo) {
	}, onclick:function (inEvent, inItem) {
		this.clickSelect(inItem, inEvent);
	}, ondblclick:function (inEvent, inItem) {
	}, onselect:function (inItem) {
	}, ondeselect:function (inItem) {
	}, _oncanselect:function (inItem, inSelectInfo) {
	}, _onmouseover:function (inEvent, inItem) {
		var mouseOverInfo = {canMouseOver:true};
		this._oncanmouseover(inEvent, inItem, mouseOverInfo);
		if (mouseOverInfo.canMouseOver) {
			inItem.doOver();
		}
	}});
	wm.Object.extendSchema(wm.VirtualList, {multiSelect:{ignore:1}, box:{ignore:1}, toggleSelect:{group:"common", order:100}});
}
if (!dojo._hasResource["wm.base.widget.List"]) {
	dojo._hasResource["wm.base.widget.List"] = true;
	dojo.provide("wm.base.widget.List");
	dojo.declare("wm.ListItem", wm.VirtualListItem, {create:function () {
		this.inherited(arguments);
		dojo.addClass(this.domNode, "wmlist-item");
	}, format:function (inData, inIndex) {
		return (this.list.format ? this.list.format(inIndex, inData) : inData);
	}, setContent:function (inData, inImage) {
		var f = this.format(inData, this.index);
		this.inherited(arguments, [f]);
		this._data = this.getData();
	}, getData:function () {
		return this.list.getItemData(this.index);
	}, update:function () {
		var html = this.format(this.getData(), this.index);
		this.domNode.innerHTML = html;
	}, getColumnFromNode:function (inNode) {
		if (inNode) {
			while (inNode.tagName != "TD") {
				inNode = inNode.parentNode;
			}
			var td = inNode, tr = inNode.parentNode;
			for (var i = 0, c; (c = tr.childNodes[i]); i++) {
				if (c == td) {
					return i;
				}
			}
		}
		return -1;
	}});
	dojo.declare("wm.List", wm.VirtualList, {autoScroll:true, constructor:function () {
		this._data = [];
	}, binding:"(data)", updateNow:"(update now)", columnWidths:"", dataFields:"", classNames:"wmlist", init:function () {
		this.inherited(arguments);
		this.createSelectedItem();
		this.createBuilder();
		if (this.columnWidths && this.dataFields.split(",").length != this.columnWidths.split(",").length) {
			console.error("Column width count does not match field list count");
		}
		this._setDataFields(this.dataFields);
		this.setColumnWidths(this.columnWidths);
		this._render();
		this.domNode.onboundschange = dojo.hitch(this, "updateHeaderWidth");
	}, createSelectedItem:function () {
		this.selectedItem = new wm.Variable({name:"selectedItem", owner:this});
	}, createBuilder:function () {
		this.builder = new wm.table.builder(this.className + "-table", this.className + "-row", this.className + "-cell");
		this.builder.getCellContent = dojo.hitch(this, "getCellContent");
		this.builder.getCellStyle = dojo.hitch(this, "getCellStyle");
	}, createItem:function (inContent) {
		return new wm.ListItem(this, inContent);
	}, _setSelected:function (inItem) {
		this.selected = inItem;
		var d = this.selected ? this.selected.getData() : {}, s = this.selectedItem;
		if (dojo.isObject(d) && !wm.typeManager.getType(s.type)) {
			s.setDataSchema(d);
		}
		if (this.selected && dojo.isObject(d)) {
			s.setData(d);
		} else {
			s.clearData();
		}
		this.setValue("emptySelection", Boolean(!this.selected));
	}, getEmptySelection:function () {
		return Boolean(!this.selected);
	}, _setDataFields:function (inDataFields) {
		var d = this.dataFields = inDataFields || "";
		if (d) {
			var s = d.split(","), d = [];
			for (var i = 0, v, f; (f = s[i]); i++) {
				v = dojo.trim(f);
				if (v) {
					d.push(v);
				}
			}
		} else {
			var schema = (this.dataSet || 0)._dataSchema;
			if (schema) {
				var d = [];
				for (var i in schema) {
					var ti = schema[i];
					if (!(ti || 0).isList && !wm.typeManager.isStructuredType((ti || 0).type)) {
						d.push(i);
					}
				}
			} else {
				var row = this._data;
				if (dojo.isArray(row)) {
					row = row[0];
				}
				if (dojo.isObject(row) && !dojo.isArray(row)) {
					d = [];
					for (var i in row) {
						if (!dojo.isObject(row[i])) {
							d.push(dojo.trim(i));
						}
					}
				}
			}
		}
		this.trimDataSetObjectFields(d);
		this._dataFields = d;
	}, getDataSetObjectFields:function () {
		var o = {};
		if (!this.dataSet) {
			return o;
		}
		var t = this.dataSet.type, tt = wm.typeManager.getTypeSchema(t) || {};
		for (var i in tt) {
			if (wm.typeManager.isStructuredType(tt[i])) {
				o[i] = tt[i];
			}
		}
		return o;
	}, trimDataSetObjectFields:function (inData) {
		var f = this.getDataSetObjectFields();
		for (var i in f) {
			for (var j = 0, df; (df = inData[j]); j++) {
				if (df == i) {
					inData.splice(j, 1);
					break;
				}
			}
		}
	}, setDataFields:function (inDataFields) {
		this._setDataFields(inDataFields);
		this._render();
	}, setColumnWidths:function (inColumnWidths) {
		var c = this.columnWidths = inColumnWidths;
		this._columnWidths = dojo.isArray(c) ? c : c.split(",");
		this._render();
	}, shouldShowHeader:function () {
		var dataHeader = this._dataFields && this.getCount();
		return (this.headerVisible && (dataHeader || this._headerContent));
	}, getHeaderContent:function () {
		return this._headerContent || this.builder.generateHeaderHtml();
	}, renderHeader:function () {
		var s = this.shouldShowHeader();
		this._setHeaderVisible(s);
		if (s) {
			this.headerNode.innerHTML = this.getHeaderContent();
			this.updateHeaderWidth();
		}
	}, updateHeaderWidth:function () {
		var f = this.items && this.items[0], n = f && f.domNode.firstChild, b = n && dojo.marginBox(n);
		if (b && this.headerNode.firstChild) {
			dojo.marginBox(this.headerNode.firstChild, {w:b.w});
		}
	}, _render:function () {
		this.renderData(this._data);
	}, clear:function () {
		this._data = null;
		this.inherited(arguments);
	}, getDataItemCount:function () {
		return this._data.length;
	}, canSetDataSet:function (inDataSet) {
		return Boolean(inDataSet && inDataSet.isList);
	}, setDataSet:function (inDataSet) {
		if (!this.canSetDataSet(inDataSet)) {
			this.dataSet = "";
		} else {
			this.dataSet = inDataSet;
		}
		var t = (inDataSet || 0).type || "AnyData";
		this.setSelectedItemType(t);
		this.dataSetToSelectedItem(inDataSet);
		this.onsetdata(this.dataSet);
		this.renderDataSet(this.dataSet);
	}, setSelectedItemType:function (inType) {
		this.selectedItem.setType(inType);
	}, update:function () {
		var ds = this.getValueById((this.components.binding.wires["dataSet"] || 0).source);
		wm.fire(ds, "update");
	}, renderDataSet:function (inDataSet) {
		var d = inDataSet instanceof wm.Variable ? inDataSet.getData() : [];
		this.renderData(d);
	}, renderData:function (inData) {
		this.clear();
		this._data = inData;
		if (!this.dataFields) {
			this._setDataFields();
		}
		this.updateBuilder();
		if (!this._data) {
			return;
		}
		for (var i = 0, l = this.getDataItemCount(); i < l; i++) {
			this.addItem(this.getItemData(i), i);
		}
		this.renderHeader();
		dojo.query(".wmlist-item:nth-child(odd)", this.domNode).addClass("Odd");
		this.reflow();
	}, getHeading:function (inField) {
		var d = this._dataSource, s = d && d.schema || 0, si = s[inField] || 0;
		if (si.label) {
			return wm.capitalize(si.label);
		} else {
			var fieldName = inField.replace(/^.*\./, "");
			return wm.capitalize(fieldName);
		}
	}, getItemData:function (inIndex) {
		return this._data[inIndex];
	}, getCellContent:function (inRow, inCol, inHeader) {
		var f = this._dataFields && this._dataFields[inCol], cellData, i = this._formatIndex != null ? this._formatIndex : this.getCount();
		if (inHeader) {
			cellData = "<div>" + this.getHeading(f);
		} else {
			if (this.dataSet && this.dataSet.isList) {
				var v = this.dataSet.getItem(i);
				cellData = v.getValue(f);
			}
		}
		if (cellData == undefined) {
			var d = this.getItemData(i);
			f = wm.decapitalize(f);
			cellData = f ? d[f] : d;
		}
		var info = {column:inCol, data:cellData, header:inHeader};
		this.onformat(info, inCol, cellData, inHeader, v);
		this._formatIndex = null;
		return info.data;
	}, getColWidth:function (inCol) {
		var c = this._columnWidths;
		return c && (c[inCol] != undefined) ? c[inCol] : Math.round(100 / this.builder.colCount) + "%";
	}, getCellStyle:function (inRow, inCol) {
		return "width: " + this.getColWidth(inCol) + ";";
	}, updateBuilder:function () {
		this.builder.colCount = this._dataFields ? this._dataFields.length : 1;
		this.builder.rowCount = 1;
	}, format:function (inIndex, inData) {
		this._formatIndex = inIndex;
		return this.builder.generateHtml(inData);
	}, onformat:function (ioData, inColumn, inData, inHeader, inVariable) {
	}, onsetdata:function (inData) {
	}});
	wm.Object.extendSchema(wm.List, {disabled:{ignore:1}, selectedItem:{ignore:1, bindSource:1, isObject:true, simpleBindProp:true}, dataSet:{readonly:true, group:"data", order:1, bindTarget:1, type:"wm.Variable", isList:true}, emptySelection:{ignore:true, bindSource:1, type:"Boolean"}});
	wm.List.description = "Displays list of items.";
	wm.List.extend({set_dataSet:function (inDataSet) {
		if (inDataSet && !(inDataSet instanceof wm.Variable)) {
			var ds = this.getValueById(inDataSet);
			if (ds) {
				this.components.binding.addWire("", "dataSet", ds.getId());
			}
		} else {
			this.setDataSet(inDataSet);
		}
	}, makePropEdit:function (inName, inValue, inDefault) {
		switch (inName) {
		  case "updateNow":
			return makeReadonlyButtonEdit(inName, inValue, inDefault);
		  case "dataSet":
			return new wm.propEdit.DataSetSelect({component:this, name:inName, value:this.dataSet ? this.dataSet.getId() : "", allowAllTypes:true, listMatch:true});
		}
		return this.inherited(arguments);
	}, editProp:function (inName, inValue, inInspector) {
		switch (inName) {
		  case "updateNow":
			return this.update();
		}
		this.inherited(arguments);
	}});
	wm.FocusablePanelRegistry = [];
	dojo.declare("wm.FocusableList", wm.List, {init:function () {
		this.inherited(arguments);
		wm.FocusablePanelRegistry.push(this);
		dojo.connect(document, "keydown", this, "keydown");
	}, nextFocus:null, nextFocusableItemField:null, priorFocus:null, hasFocus:false, focusOnStart:false, focusEventTime:0, defaultFocusListIndex:0, getNextFocus:function () {
		if (!(this.nextFocus instanceof Object)) {
			this.setNextFocus(this.nextFocus);
		}
		return this.nextFocus;
	}, setNextFocus:function (inFocusable) {
		if (!(inFocusable instanceof Object)) {
			var tmp = this.getRoot()[inFocusable];
			this.nextFocus = tmp || this.nextFocus;
		} else {
			this.nextFocus = inFocusable;
		}
	}, getPriorFocus:function () {
		if (!(this.priorFocus instanceof Object)) {
			this.setPriorFocus(this.priorFocus);
		}
		return this.priorFocus;
	}, setPriorFocus:function (inFocusable) {
		if (!(inFocusable instanceof Object)) {
			this.priorFocus = this.getRoot()[inFocusable];
		} else {
			this.priorFocus = inFocusable;
		}
	}, setFocus:function (inFocus, e) {
		this.focusEventTime = (e) ? e.timeStamp : 0;
		this.hasFocus = inFocus;
		if (inFocus) {
			console.log(this.name + " has focus now");
			this.show();
			dojo.addClass(this.domNode, "wmselectedlist");
			this.setBorderColor("rgb(0,0,160)");
			for (var i = 0; i < wm.FocusablePanelRegistry.length; i++) {
				if (wm.FocusablePanelRegistry[i] != this) {
					wm.FocusablePanelRegistry[i].setFocus(false, e);
				}
			}
			if (this.getSelectedIndex() == -1) {
				this.deselectAll(true);
				if (this.defaultFocusListIndex != -1) {
					this.eventSelect(this.getItem(this.defaultFocusListIndex));
				}
			}
			if (this.getNextFocus() instanceof Object) {
				this.getNextFocus().show();
			}
		} else {
			dojo.removeClass(this.domNode, "wmselectedlist");
			this.setBorderColor("transparent");
		}
	}, show:function () {
		this.inherited(arguments);
		var parent = this.parent;
		while (parent && !(parent instanceof wm.Layer)) {
			parent = parent.parent;
		}
		if (this.autoShowLayer) {
			if (parent && (parent instanceof wm.Layer) && !parent.active) {
				parent.parent.setLayer(parent);
			}
		}
	}, onclick:function (inEvent, inItem) {
		this.inherited(arguments);
		this.setFocus(true, inEvent);
	}, eventSelect:function (inItem) {
		if (this.nextFocusableItemField) {
			var data = inItem.getData();
			var tmpObj = new wm.Object();
			tmpObj.data = data;
			var next = tmpObj.getValue("data." + this.nextFocusableItemField);
			if (next) {
				console.log("set next to " + next);
				this.setNextFocus(next);
				if (this.getNextFocus() instanceof Object) {
					this.getNextFocus().show();
				}
			}
		}
		this.inherited(arguments);
	}, keydown:function (e) {
		if (e.target && e.target.nodeName.toLowerCase() == "input") {
			return;
		}
		if (!this.hasFocus || this.focusEventTime == e.timeStamp) {
			return;
		}
		if (e.ctrlKey || e.shiftKey) {
			return;
		}
		if (e.keyCode == dojo.keys.UP_ARROW) {
			var index = this.getSelectedIndex();
			index = index - 1;
			if (index < 0) {
				index = this.getCount() + index;
			}
			index = index % this.getCount();
			this.deselectAll(true);
			this.eventSelect(this.getItem(index));
			dojo.stopEvent(e);
		} else {
			if (e.keyCode == dojo.keys.DOWN_ARROW) {
				var index = this.getSelectedIndex();
				index = (index + 1) % this.getCount();
				this.deselectAll(true);
				this.eventSelect(this.getItem(index));
				dojo.stopEvent(e);
			} else {
				if (e.keyCode == dojo.keys.RIGHT_ARROW && this.nextFocus) {
					this.getNextFocus().setFocus(true, e);
					dojo.stopEvent(e);
				} else {
					if (e.keyCode == dojo.keys.LEFT_ARROW && this.priorFocus) {
						this.deselectAll();
						this.getPriorFocus().setFocus(true, e);
						dojo.stopEvent(e);
						if (this.nextFocus) {
							this.getNextFocus().hideNextChain();
						}
					}
				}
			}
		}
	}, setDataSet:function (inDataSet) {
		this.inherited(arguments);
		if (this.focusOnStart) {
			this.setFocus(true, 0);
			window.focus();
		}
		this.focusOnStart = false;
	}, hideNextChain:function () {
		this.hide();
		if (this.nextFocus) {
			this.getNextFocus().hideNextChain();
		}
	}});
	dojo.declare("wm.FocusablePanel", wm.Panel, {init:function () {
		this.inherited(arguments);
		wm.FocusablePanelRegistry.push(this);
		dojo.connect(document, "keydown", this, "keydown");
		dojo.connect(this.domNode, "click", this, "onclick");
		if (this.focusOnStart) {
			this.setFocus(true, 0);
		}
	}, autoShowLayer:false, autoFormFocus:null, nextFocus:null, priorFocus:null, hasFocus:false, focusOnStart:false, focusEventTime:0, getNextFocus:function () {
		if (!(this.nextFocus instanceof Object)) {
			this.setNextFocus(this.nextFocus);
		}
		return this.nextFocus;
	}, setNextFocus:function (inFocusable) {
		if (!(inFocusable instanceof Object)) {
			var tmp = this.getRoot()[inFocusable];
			this.nextFocus = tmp || this.nextFocus;
		} else {
			this.nextFocus = inFocusable;
		}
	}, getPriorFocus:function () {
		if (!(this.priorFocus instanceof Object)) {
			this.setPriorFocus(this.priorFocus);
		}
		return this.priorFocus;
	}, setPriorFocus:function (inFocusable) {
		if (!(this.priorFocus instanceof Object)) {
			this.priorFocus = this.getRoot()[inFocusable];
		} else {
			this.priorFocus = inFocusable;
		}
	}, setFocus:function (inFocus, e) {
		this.focusEventTime = e.timeStamp;
		this.hasFocus = inFocus;
		if (inFocus) {
			console.log(this.name + " has focus now");
			this.show();
			this.setBorderColor("rgb(0,0,160)");
			if (this.autoFormFocus) {
				this.getRoot()[this.autoFormFocus].focus();
			}
			for (var i = 0; i < wm.FocusablePanelRegistry.length; i++) {
				if (wm.FocusablePanelRegistry[i] != this) {
					wm.FocusablePanelRegistry[i].setFocus(false, e);
				}
			}
			if (this.getNextFocus() instanceof Object) {
				this.getNextFocus().show();
			}
		} else {
			this.setBorderColor("transparent");
		}
	}, show:function () {
		this.inherited(arguments);
		var parent = this.parent;
		while (parent && !(parent instanceof wm.Layer)) {
			parent = parent.parent;
		}
		if (this.autoShowLayer) {
			if (parent && (parent instanceof wm.Layer) && !parent.active) {
				parent.parent.setLayer(parent);
			}
		}
	}, onclick:function (inEvent, inItem) {
		this.inherited(arguments);
		this.setFocus(true, inEvent);
	}, keydown:function (e) {
		if (e.target && e.target.nodeName.toLowerCase() == "input") {
			return;
		}
		if (!this.hasFocus || this.focusEventTime == e.timeStamp) {
			return;
		}
		if (e.ctrlKey || e.shiftKey) {
			return;
		}
		if (e.keyCode == dojo.keys.RIGHT_ARROW && this.nextFocus) {
			this.getNextFocus().setFocus(true, e);
			dojo.stopEvent(e);
		} else {
			if (e.keyCode == dojo.keys.LEFT_ARROW && this.priorFocus) {
				this.getPriorFocus().setFocus(true, e);
				dojo.stopEvent(e);
				if (this.nextFocus) {
					this.getNextFocus().hideNextChain();
				}
			}
		}
	}, hideNextChain:function () {
		this.hide();
		if (this.nextFocus) {
			this.getNextFocus().hideNextChain();
		}
	}});
	wm.Object.extendSchema(wm.FocusableList, {focusEventTime:{ignore:1}, nextFocus:{bindable:1, type:"wm.FocusableList"}, priorFocus:{bindable:1, type:"wm.FocusableList"}, hasFocus:{ignore:1}, focusOnStart:{type:"boolean"}, defaultFocusListIndex:{}});
	wm.Object.extendSchema(wm.FocusablePanel, {focusEventTime:{ignore:1}});
}
if (!dojo._hasResource["wm.base.widget.FeedList"]) {
	dojo._hasResource["wm.base.widget.FeedList"] = true;
	dojo.provide("wm.base.widget.FeedList");
	dojo.declare("wm.FeedList", wm.List, {url:"", dataFields:"title", title:"", expand:false, headerVisible:true, showLink:true, selectedLink:"", totalItems:"", onselect:null, ondeselect:null, init:function () {
		this.inherited(arguments);
		dojo.addClass(this.domNode, "wmfeedlist");
		if (!this.isDesignLoaded()) {
			this.getFeed();
		}
	}, prepare:function () {
		this.inherited(arguments);
		this.className = "wmfeedlist";
		if (this.isDesignLoaded() && !wm.services.byName["FeedService"]) {
			studio.webService.requestAsync("registerFeedService", null, dojo.hitch(this, "registerFeedServiceSuccess"));
		} else {
			this._createGetFeedServiceVariable();
		}
	}, createListNode:function () {
		this.listNode = document.createElement("div");
		this.listNode.flex = 1;
		dojo.addClass(this.listNode, "wmfeedlist-list");
	}, createHeaderNode:function () {
		this.headerNode = document.createElement("div");
		dojo.addClass(this.headerNode, "wmfeedlist-header");
	}, getHeaderContent:function () {
		return "<div>" + this.title + "</div>";
	}, updateHeaderWidth:function () {
		if (this.headerNode.firstChild) {
			dojo.marginBox(this.headerNode.firstChild, {w:this.width});
		}
	}, getCellContent:function (inRow, inCol, inHeader) {
		var d = this.getItemData(this.getCount());
		var titleData = d.title;
		var linkData = d.link;
		var descriptionData = d.description ? d.description.value : "";
		var info = {column:inCol, data:d, header:inHeader};
		this.onformat(info, inCol, d, inHeader);
		var html = ["<img src=\"" + this._getImageSrc(this.expand) + "\"/>"];
		html.push(this.getFeedItemTitleContent(titleData, linkData));
		html.push("<br>");
		html.push("<div class=\"wmfeedlist-row-desc\" style=\"display: " + (this.expand ? "" : "none") + ";\">" + descriptionData + "</div>");
		return html.join("");
	}, getFeedItemTitleContent:function (inTitle, inLink) {
		return "<a target=\"newpage\" href=\"" + (this.showLink ? inLink : "javascript:;") + "\">" + inTitle + "</a>";
	}, setUrl:function (inUrl) {
		this.url = inUrl;
		if (!this.isDesignLoaded()) {
			this.getFeed();
		}
	}, setExpand:function (inExpand) {
		this.expand = inExpand;
		this._render();
	}, setShowLink:function (inShowLink) {
		this.showLink = inShowLink;
		this._render();
	}, setTotalItems:function (inNum) {
		this.totalItems = parseInt(inNum) || "";
		this._render();
	}, getDataItemCount:function () {
		var c = this.inherited(arguments);
		if (c && parseInt(this.totalItems) && this.totalItems > -1 && c > this.totalItems) {
			return this.totalItems;
		} else {
			return c;
		}
	}, _getImageSrc:function (isCollapsed) {
		return wm.theme.getImagesPath() + (isCollapsed ? "feedlist_open.gif" : "feedlist_closed.gif");
	}, _createGetFeedServiceVariable:function () {
		this.getFeedServiceVariable = new wm.ServiceVariable({name:"getFeedServiceVariable", owner:this, service:"FeedService", operation:"getFeed"});
		this.getFeedServiceVariable["setData"] = function () {
		};
		this.getFeedServiceVariable["onSuccess"] = dojo.hitch(this, "getFeedServiceVariableSuccess");
	}, registerFeedServiceSuccess:function (inResult) {
		this._createGetFeedServiceVariable();
		studio.updateServices();
	}, update:function () {
		if (this.isDesignLoaded() && !studio.isLiveLayoutReady()) {
			studio.refreshLiveData();
			if (studio._deploying && studio._deployer) {
				studio._deployer.addCallback(dojo.hitch(this, function (inResult) {
					this.update();
				}));
			}
		} else {
			this.getFeed();
		}
	}, getFeed:function () {
		if (this.url && this.url !== undefined) {
			this.getFeedServiceVariable.request([this.url]);
		} else {
			this.clear();
		}
	}, getFeedServiceVariableSuccess:function (inResult) {
		this.title = inResult.title;
		this.renderData(inResult.entries);
	}, onclick:function (inEvent, inItem) {
		if (inEvent.target.tagName == "IMG") {
			var isCollapsed = inEvent.target.src.match("feedlist_closed.gif");
			inEvent.target.src = this._getImageSrc(isCollapsed);
			inEvent.target.parentNode.lastChild.style.display = isCollapsed ? "" : "none";
		} else {
			this.setValue("selectedLink", inItem.getData().link);
		}
	}, _onmouseover:function (inEvent, inItem) {
	}});
	wm.Object.extendSchema(wm.FeedList, {dataSet:{ignore:1}, disabled:{ignore:1}, columnWidths:{ignore:1}, dataFields:{ignore:1}, title:{ignore:1}, url:{type:"String", bindTarget:1}, selectedLink:{ignore:1, bindSource:1, type:"String"}, selectedItem:{ignore:1}});
	wm.FeedList.description = "A feed list.";
	dojo.extend(wm.FeedList, {themeable:false});
}
if (!dojo._hasResource["wm.base.widget.Detail"]) {
	dojo._hasResource["wm.base.widget.Detail"] = true;
	dojo.provide("wm.base.widget.Detail");
	dojo.declare("wm.Detail", wm.List, {labelPosition:"left", labelAlign:"left", headerVisible:false, prepare:function () {
		this.inherited(arguments);
		this.className = "wmdetail";
	}, build:function () {
		this.inherited(arguments);
		this.createBuilder();
	}, updateBuilder:function () {
		var v = this.isVertical();
		this.builder.colCount = (v ? 1 : 2);
		this.builder.rowCount = (v ? 2 : 1);
	}, getDataItemCount:function () {
		return this._dataFields.length;
	}, getItemData:function (inIndex) {
		var f = this._dataFields[inIndex];
		return this._data[f];
	}, getCellContent:function (inRow, inCol) {
		var i = this.getCount(), d = this._data, isLabel = this.isLabel(inRow, inCol), f = this._dataFields[i], infoData = isLabel ? this.getHeading(f) : d && d[f];
		var info = {row:inRow, data:infoData, isLabel:isLabel};
		this.onformat(info, inRow, infoData, isLabel);
		return info.data;
	}, onformat:function (ioData, inRow, inData, inIsLabel) {
	}, isLabel:function (inRow, inCol) {
		var d = this.getDetailPosition();
		return (d.row != inRow || d.col != inCol);
	}, getDetailPosition:function () {
		switch (this.labelPosition) {
		  case "top":
			return {row:1, col:0};
		  case "right":
			return {row:0, col:0};
		  case "bottom":
			return {row:0, col:0};
		  default:
			return {row:0, col:1};
		}
	}, isVertical:function () {
		var l = this.labelPosition;
		return (l == "top" || l == "bottom");
	}, getCellStyle:function (inRow, inCol) {
		var l = this.isLabel(inRow, inCol), v = this.isVertical(), r = [(l ? "text-align:" + this.labelAlign : ""), "font-weight:" + (l ? "bold" : "normal"), (!v ? "width: " + this.getColWidth(inCol) + ";" : "")];
		return r.join(";");
	}, setLabelPosition:function (inLabelPosition) {
		this.labelPosition = inLabelPosition;
		this._render();
	}, setLabelAlign:function (inLabelAlign) {
		this.labelAlign = inLabelAlign;
		this._render();
	}, canSetDataSet:function (inDataSet) {
		return Boolean(inDataSet);
	}, _oncanselect:function (inItem, inSelectInfo) {
		inSelectInfo.canSelect = false;
	}, _oncanmouseover:function (inEvent, inItem, inMouseOverInfo) {
		inMouseOverInfo.canMouseOver = false;
	}, onclick:function (inEvent, inItem) {
	}, createSelectedItem:function () {
	}, setSelectedItemType:function (inType) {
	}, _setSelected:function (inItem) {
	}});
	wm.Detail.description = "Displays a detailed list.";
	wm.Object.extendSchema(wm.Detail, {headerVisible:{ignore:1}, selectedItem:{ignore:1}, dataSet:{group:"data", readonly:true, order:1, bindTarget:1, type:"wm.Variable"}});
	wm.Detail.extend({makePropEdit:function (inName, inValue, inDefault) {
		switch (inName) {
		  case "labelAlign":
			return makeSelectPropEdit(inName, inValue, ["left", "center", "right"], inDefault);
		  case "labelPosition":
			return makeSelectPropEdit(inName, inValue, ["top", "right", "bottom", "left"], inDefault);
		  case "dataSet":
			return new wm.propEdit.DataSetSelect({component:this, name:inName, value:this.dataSet ? this.dataSet.getId() : "", allowAllTypes:true, listMatch:false});
		  default:
			return this.inherited(arguments);
		}
	}});
	dojo.extend(wm.Detail, {});
}
if (!dojo._hasResource["wm.base.widget.Form"]) {
	dojo._hasResource["wm.base.widget.Form"] = true;
	dojo.provide("wm.base.widget.Form");
	dojo.declare("wm.Form", wm.Detail, {init:function () {
		this.inherited(arguments);
		new wm.Variable({name:"dataOutput", owner:this});
	}, renderData:function (inData) {
		this.domNode.style.visibility = "hidden";
		this.inherited(arguments);
		this.postRender();
	}, postRender:function () {
		this.createEditors();
	}, createEditors:function () {
		var d = this.getDetailPosition();
		for (var i = 0, li, n, b, td; (li = this.getItem(i)); i++) {
			td = wm.getTd(li.domNode && li.domNode.firstChild, d.row, d.col);
			n = td && td.firstChild;
			dojo.setSelectable(li.domNode, true);
			if (!li.editor) {
				var data = li.getData();
				li.editor = new dijit.form.TextBox({srcNodeRef:n, value:(data != undefined ? data : "")});
				li.editor.domNode.style.width = "100%";
				this.connect(li.editor, "_onBlur", this, "updateDataOutput");
			}
		}
		this.domNode.style.visibility = "";
		this.reflowParent();
	}, onformat:function (ioData, inRow, inData, inIsLabel) {
		if (!ioData.isLabel) {
			ioData.data = "<div></div>";
		}
	}, getValues:function () {
		var v = {};
		dojo.forEach(this.items, dojo.hitch(this, function (i) {
			var f = this._dataFields[i.index], editor = i.editor;
			v[f] = editor && editor.getValue();
		}));
		return v;
	}, setDataSet:function (inDataSet) {
		this.inherited(arguments);
		var t = (inDataSet || 0).type;
		this.components.dataOutput.setType(t || "any");
	}, updateDataOutput:function () {
		var d = this.getValues();
		o = this.components.dataOutput;
		o._clearData();
		o.setData(d);
	}});
	wm.Object.extendSchema(wm.Form, {dataOutput:{ignore:1, group:"data", order:100, bindSource:1, isObject:true}});
	wm.Form.description = "Displays a detailed form.";
}
if (!dojo._hasResource["wm.base.widget.LiveForm"]) {
	dojo._hasResource["wm.base.widget.LiveForm"] = true;
	dojo.provide("wm.base.widget.LiveForm");
	wm.getLiveForms = function (inPage) {
		var forms = [];
		wm.forEachWidget(inPage.root, function (w) {
			if (wm.isInstanceType(w, wm.LiveForm)) {
				forms.push(w);
			}
		});
		return forms;
	};
	wm.getMatchingFormWidgets = function (inForm, inMatch) {
		var match = [];
		wm.forEach(inForm.widgets, function (w) {
			if (inMatch(w)) {
				match.push(w);
			}
			if ((wm.isInstanceType(w, wm.Container) && !(wm.isInstanceType(w, wm.LiveFormBase)))) {
				match = match.concat(wm.getMatchingFormWidgets(w, inMatch));
			}
		});
		return match;
	};
	wm.getParentForm = function (inWidget) {
		var w = inWidget.parent;
		var r = inWidget.getRoot();
		r = r && r.root;
		while (w && w != r) {
			if (wm.isInstanceType(w, wm.LiveFormBase)) {
				return w;
			}
			w = w.parent;
		}
	};
	wm.getFormLiveView = function (inForm) {
		var lv = inForm && inForm.getLiveVariable();
		return lv && lv.liveView;
	};
	wm.getFormField = function (inWidget) {
		var a = [], w = inWidget;
		while (w && !(wm.isInstanceType(w, wm.LiveForm))) {
			if (w.formField) {
				a.unshift(w.formField);
			}
			w = wm.getParentForm(w);
		}
		return a.join(".");
	};
	dojo.declare("wm.LiveFormBase", wm.Panel, {editorHeight:"26px", editorWidth:"100%", captionSize:"50%", captionAlign:"right", captionPosition:"left", height:"228px", width:"100%", layoutKind:"top-to-bottom", readonly:false, validateBeforeSave:false, dataSet:null, dataOutput:null, init:function () {
		this.dataOutput = new wm.Variable({name:"dataOutput", owner:this});
		this.inherited(arguments);
	}, postInit:function () {
		this.inherited(arguments);
		this.dataOutput = this.$.dataOutput;
		if (wm.pasting) {
			wm.fire(this, "designPasted");
		}
		this.populateEditors();
	}, setDataSet:function (inDataSet) {
		this.beginEditUpdate();
		this.dataSet = inDataSet;
		var d = this.getItemData();
		this.populateEditors();
		this.endEditUpdate();
		this.setDataOutput(d);
		this.liveFormChanged();
	}, getSourceId:function () {
		try {
			return this.components.binding.wires.dataSet.source;
		}
		catch (e) {
		}
		return "";
	}, setDataOutput:function (inDataSet) {
		this.dataOutput.setDataSet(inDataSet);
	}, clearDataOutput:function () {
		dojo.forEach(this.getRelatedEditorsArray(), function (e) {
			e.clearDataOutput();
		});
		this.dataOutput.setData({});
	}, getItemData:function () {
		return wm.fire(this.dataSet, "getCursorItem");
	}, _getDataType:function () {
		var t = (this.dataSet || 0).type;
		if (!wm.typeManager.isStructuredType(t)) {
			var v = this.getLiveVariable();
			t = v && v.type;
		}
		if (wm.typeManager.isStructuredType(t)) {
			return t;
		}
	}, getLiveVariable:function () {
		var s = this.dataSet, o = s && s.owner;
		o = o && !(wm.isInstanceType(o, wm.Variable)) ? o : null, ds = o ? (o instanceof wm.DojoGrid ? o.variable : o.dataSet) : null;
		if (o && ds && wm.isInstanceType(ds, wm.LiveVariable)) {
			return ds;
		}
		while (s) {
			if (wm.isInstanceType(s, wm.LiveVariable)) {
				return s;
			}
			s = s.owner;
			if (!(wm.isInstanceType(s.owner, wm.Variable))) {
				break;
			}
		}
	}, beginEditUpdate:function () {
		this.dataOutput.beginUpdate();
		dojo.forEach(this.getFormEditorsArray(), function (e) {
			wm.fire(e, "beginEditUpdate");
		});
	}, endEditUpdate:function () {
		this.dataOutput.endUpdate();
		dojo.forEach(this.getFormEditorsArray(), function (e) {
			wm.fire(e, "endEditUpdate");
		});
	}, liveFormChanged:function () {
		dojo.forEach(this.getFormEditorsArray(), function (e) {
			wm.fire(e, "doOnchange");
		});
	}, populateEditors:function () {
		var i = this.getItemData(), data = i ? i.getData() : null;
		dojo.forEach(this.getFormEditorsArray(), function (e) {
			if (wm.isInstanceType(e, wm.LiveFormBase)) {
				wm.fire(e, "populateEditors");
			} else {
				wm.fire(e, "setDataValue", [e.formField && data ? data[e.formField] : data]);
			}
		});
	}, populateDataOutput:function () {
		var d = this.dataOutput;
		dojo.forEach(this.getFormEditorsArray(), function (e) {
			if (wm.isInstanceType(e, wm.LiveFormBase)) {
				wm.fire(e, "populateDataOutput");
			} else {
				if (e.formField) {
					d.setValue(e.formField, e.getDataValue());
				}
			}
		});
	}, editStarting:function () {
		dojo.forEach(this.getFormEditorsArray(), function (e) {
			wm.fire(e, "editStarting");
		});
	}, editCancelling:function () {
		dojo.forEach(this.getFormEditorsArray(), function (e) {
			wm.fire(e, "editCancelling");
		});
	}, clearData:function () {
		dojo.forEach(this.getFormEditorsArray(), function (e) {
			wm.fire(e, "clear");
		});
		dojo.forEach(this.getRelatedEditorsArray(), function (e) {
			wm.fire(e, "clearData");
		});
	}, setDefaultOnInsert:function () {
		dojo.forEach(this.getFormEditorsArray(), function (e) {
			wm.fire(e, "setDefaultOnInsert");
		});
	}, getEditorsArray:function () {
		return wm.getMatchingFormWidgets(this, function (w) {
			return (wm.isInstanceType(w, wm.Editor) || wm.isInstanceType(w, wm.AbstractEditor));
		});
	}, getRelatedEditorsArray:function (inContainer) {
		return wm.getMatchingFormWidgets(this, function (w) {
			return (wm.isInstanceType(w, wm.RelatedEditor));
		});
	}, getFormEditorsArray:function () {
		return wm.getMatchingFormWidgets(this, function (w) {
			return (w.formField !== undefined);
		});
	}, _getEditorBindSourceId:function (inSourceId) {
		var parts = (inSourceId || "").split(".");
		parts.pop();
		return parts.join(".");
	}, _getEditorBindSource:function (inSourceId) {
		var parts = (inSourceId || "").split(".");
		parts.pop();
		var s = parts.join("."), v = this.getValueById(s);
		if (wm.isInstanceType(v, wm.Editor) || wm.isInstanceType(v, wm.RelatedEditor)) {
			return v;
		}
	}, getBoundEditorsArray:function () {
		var editors = [];
		var wires = this.$.binding.wires;
		for (var i in wires) {
			w = wires[i];
			if (!w.targetId && w.targetProperty.indexOf("dataOutput") == 0) {
				e = this._getEditorBindSource(w.source);
				if (e) {
					editors.push(e);
				}
			}
		}
		return editors;
	}, canChangeEditorReadonly:function (inEditor, inReadonly, inCanChangeFunc) {
		var c = dojo.isFunction(inCanChangeFunc);
		return !c || inCanChangeFunc(inEditor, this, inReadonly);
	}, _setReadonly:function (inReadonly, inCanChangeFunc) {
		dojo.forEach(this.getFormEditorsArray(), function (e) {
			if (this.canChangeEditorReadonly(e, inReadonly, inCanChangeFunc)) {
				e.setReadonly(inReadonly);
			}
		}, this);
		dojo.forEach(this.getRelatedEditorsArray(), function (e) {
			if (this.canChangeEditorReadonly(e, inReadonly, inCanChangeFunc)) {
				e._setReadonly(inReadonly, inCanChangeFunc);
			}
		}, this);
	}, setReadonly:function (inReadonly) {
		this.readonly = inReadonly;
		this._setReadonly(inReadonly);
	}, setCaptionSize:function (inSize) {
		this.captionSize = inSize;
		dojo.forEach(this.getEditorsArray(), function (e) {
			e.setCaptionSize(inSize);
		});
		dojo.forEach(this.getRelatedEditorsArray(), function (e) {
			e.setCaptionSize(inSize);
		});
	}, setCaptionUnits:function (inUnits) {
		this.captionUnits = inUnits;
		dojo.forEach(this.getEditorsArray(), function (e) {
			e.setCaptionUnits(inUnits);
		});
	}, setCaptionAlign:function (inAlign) {
		this.captionAlign = inAlign;
		dojo.forEach(this.getEditorsArray(), function (e) {
			e.setCaptionAlign(inAlign);
		});
	}, setCaptionPosition:function (inPosition) {
		this.captionPosition = inPosition;
		dojo.forEach(this.getEditorsArray(), function (e) {
			e.setCaptionPosition(inPosition);
		});
	}, setEditorWidth:function (inEditorWidth) {
		this.editorWidth = inEditorWidth;
		dojo.forEach(this.getEditorsArray(), function (e) {
			e.setWidth(inEditorWidth);
		});
	}, setEditorHeight:function (inEditorHeight) {
		this.editorHeight = inEditorHeight;
		dojo.forEach(this.getEditorsArray(), function (e) {
			e.setHeight(inEditorHeight);
		});
	}, valueChanged:function (inProp, inValue) {
		if (wm.isInstanceType(this[inProp], wm.Variable)) {
			return;
		} else {
			this.inherited(arguments);
		}
	}, getViewDataIndex:function (inFormField) {
		return inFormField;
	}, validateData:function () {
		var result = true;
		dojo.forEach(this.getFormEditorsArray(), function (e) {
			if (wm.isInstanceType(e, wm.RelatedEditor)) {
				if (!e.validateData()) {
					result = false;
				}
				return result;
			}
			var val = e.dataValue;
			if (e.editor && e.editor.required && (val === null || val === undefined || val === "")) {
				alert(e.caption + " Needs a value");
				result = false;
			}
		});
		return result;
	}, getRecordCount:function () {
		return wm.fire(this.getDataSource(), "getCount");
	}, getDataSource:function () {
		if (!this._dataSource) {
			var b = this.$ && this.$.binding, v = (b && b.wires["dataSet"] || 0).source;
			this._dataSource = v && this.getValueById(v);
		}
		return this._dataSource;
	}, setRecord:function (inIndex) {
		wm.fire(this.getDataSource(), "setCursor", [inIndex]);
	}, setNext:function () {
		wm.fire(this.getDataSource(), "setNext");
	}, setPrevious:function () {
		wm.fire(this.getDataSource(), "setPrevious");
	}, setFirst:function () {
		wm.fire(this.getDataSource(), "setFirst");
	}, setLast:function () {
		wm.fire(this.getDataSource(), "setLast");
	}, getIndex:function () {
		return (this.getDataSource() || 0).cursor || 0;
	}});
	dojo.declare("wm.SimpleForm", wm.LiveFormBase, {});
	dojo.declare("wm.LiveForm", wm.LiveFormBase, {defaultButton:"", displayErrors:true, liveEditing:true, liveSaving:true, liveVariable:null, noButtonPanel:false, editPanelStyle:"wm.Button", _confirmDelete:true, _formMessages:{confirmDelete:"Are you sure you want to delete this data?"}, _controlSubForms:false, destroy:function () {
		this._cancelDefaultButton();
		this.inherited(arguments);
	}, init:function () {
		this.connect(this.domNode, "keyup", this, "keyup");
		this.canBeginEdit = this.hasEditableData;
		this.inherited(arguments);
	}, postInit:function () {
		this.inherited(arguments);
		this.initLiveVariable();
		if (String(this.captionSize).search(/\D/) == -1) {
			this.captionSize += this.captionUnits;
		}
		if (String(this.editorSize).search(/\D/) == -1) {
			this.editorSize += this.editorSizeUnits;
		}
		if (this.liveEditing && !this.isDesignLoaded()) {
			this.setReadonly(this.readonly);
		}
	}, initLiveVariable:function () {
		var lv = this.liveVariable = new wm.LiveVariable({name:"liveVariable", owner:this, liveSource:(this.dataSet || 0).type, autoUpdate:false});
		this.connect(lv, "onBeforeUpdate", this, "beforeOperation");
		this.connect(lv, "onSuccess", this, "operationSucceeded");
		this.connect(lv, "onResult", this, "onResult");
		this.connect(lv, "onError", this, "onError");
	}, setLiveEditing:function (inLiveEditing) {
		this.liveEditing = inLiveEditing;
	}, setDataSet:function (inDataSet) {
		if (this.operation) {
			return;
		}
		if (this.liveVariable && inDataSet && inDataSet.type) {
			this.liveVariable.setLiveSource(inDataSet.type);
		}
		this._cancelDefaultButton();
		this.inherited(arguments, [inDataSet]);
	}, beginDataInsert:function () {
		this.clearDataOutput();
		this.beginEditUpdate();
		this.clearData();
		this.endEditUpdate();
		this.beginEdit("insert");
		this.setDefaultOnInsert();
		this.onBeginInsert();
		this.validate();
		return true;
	}, beginDataUpdate:function () {
		this.beginEdit("update");
		this.onBeginUpdate();
		return true;
	}, beginEdit:function (inOperation) {
		this.editStarting();
		this.operation = inOperation;
		if (this.liveEditing) {
			if (this.hasLiveService()) {
				this._setReadonly(false, dojo.hitch(this, "_canChangeEditorReadonly", [inOperation]));
			} else {
				this.setReadonly(false);
			}
		}
	}, endEdit:function () {
		if (this.liveEditing) {
			this.setReadonly(true);
		}
		this.operation = null;
	}, cancelEdit:function () {
		this.editCancelling();
		var d = this.getItemData();
		this.beginEditUpdate();
		this.dataOutput.setData(d);
		this.endEditUpdate();
		this.populateEditors();
		this.onCancelEdit();
		this.endEdit();
	}, _canChangeEditorReadonly:function (inOperations, inEditor, inForm, inReadonly) {
		if ((wm.isInstanceType(inEditor, wm.Editor) || wm.isInstanceType(inEditor, wm.AbstractEditor)) && inEditor.formField) {
			var f = inEditor.formField, dt = inForm.dataSet.type, s = wm.typeManager.getTypeSchema(dt), pi = wm.typeManager.getPropertyInfoFromSchema(s, f), ops = inOperations;
			if (!f) {
				return true;
			}
			var noChange = pi && dojo.some(pi.noChange, function (i) {
				return (dojo.indexOf(ops, i) > -1);
			}), exclude = pi && dojo.some(pi.exclude, function (i) {
				return (dojo.indexOf(ops, i) > -1);
			});
			if (!inReadonly && (noChange || exclude)) {
				return false;
			}
		}
		return true;
	}, hasLiveService:function () {
		return Boolean(wm.typeManager.getLiveService((this.dataSet || 0).type));
	}, hasEditableData:function () {
		var v = this.dataOutput;
		return !this.liveEditing || (v && wm.typeManager.getLiveService(v.type) && wm.data.hasIncludeData(v.type, v.getData()));
	}, _getDeferredSuccess:function () {
		var d = new dojo.Deferred();
		d.callback(true);
		return d;
	}, saveData:function () {
		if (this.validateBeforeSave) {
			if (!this.validateData()) {
				return;
			}
		}
		if (this.operation == "insert") {
			return this.insertData();
		}
		if (this.operation == "update") {
			return this.updateData();
		}
	}, insertData:function () {
		return this.doOperation("insert");
	}, updateData:function () {
		return this.doOperation("update");
	}, deleteData:function () {
		if (!this._confirmDelete || confirm(this._formMessages.confirmDelete)) {
			this.onBeginDelete();
			return this.doOperation("delete");
		} else {
			this.cancelEdit();
		}
	}, doOperation:function (inOperation) {
		this.populateDataOutput();
		var data = this.dataOutput.getData();
		if (this.liveSaving) {
			var lv = this.liveVariable;
			lv.setOperation(inOperation);
			lv.sourceData.setData(this.dataOutput.getData());
			return lv.update();
		} else {
			switch (this.operation) {
			  case "insert":
				this.onInsertData();
				break;
			  case "update":
				this.onUpdateData();
				break;
			  case "delete":
				this.onDeleteData();
				break;
			}
			this.endEdit();
			return this._getDeferredSuccess();
		}
	}, operationSucceeded:function (inResult) {
		if (dojo.isArray(inResult)) {
			inResult = inResult[0];
		}
		var op = this.liveVariable.operation;
		if (op == "insert" || op == "delete") {
			this.dataSet.cursor = 0;
		}
		if (op == "insert" || op == "update") {
			var item = this.getItemData();
			wm.fire(item, "setData", [inResult]);
			if (item != this.dataSet) {
				wm.fire(this.dataSet, "notify");
			}
		}
		switch (op) {
		  case "insert":
			this.onInsertData(inResult);
			break;
		  case "update":
			this.onUpdateData(inResult);
			break;
		  case "delete":
			this.beginEditUpdate();
			this.clearData();
			this.endEditUpdate();
			this.onDeleteData(inResult);
			break;
		}
		this.onSuccess(inResult);
		this.endEdit();
	}, beforeOperation:function () {
		this.onBeforeOperation(this.liveVariable.operation);
	}, getSubFormsArray:function () {
		var forms = [], w;
		for (var i in this.widgets) {
			w = this.widgets[i];
			if (wm.isInstanceType(w, wm.LiveForm)) {
				forms.push(w);
				forms = forms.concat(w.getSubFormsArray());
			}
		}
		return forms;
	}, clearData:function () {
		this.inherited(arguments);
		if (this._controlSubForms) {
			dojo.forEach(this.getSubFormsArray(), function (f) {
				f.clearData();
			});
		}
	}, _setReadonly:function (inReadonly, inCanChangeFunc) {
		this.inherited(arguments);
		if (this._controlSubForms) {
			dojo.forEach(this.getSubFormsArray(), function (f) {
				f.setReadonly(inReadonly);
			});
		}
	}, forceValidation:function () {
		dojo.forEach(this.getEditorsArray(), function (e) {
			wm.fire(e.editor, "changed");
		});
		this.validate();
	}, keyup:function (e) {
		if (e.keyCode == dojo.keys.ENTER && e.target.tagName != "TEXTAREA") {
			this._defaultButtonHandle = setTimeout(dojo.hitch(this, "_doDefaultButton"), 50);
		}
	}, _doDefaultButton:function () {
		this._defaultButtonHandle = null;
		var d = this.defaultButton;
		if (d) {
			this.forceValidation();
			if (!d.disabled) {
				wm.fire(d, "onclick");
			}
		}
	}, _cancelDefaultButton:function () {
		if (this._defaultButtonHandle) {
			clearTimeout(this._defaultButtonHandle);
			this._defaultButtonHandle = null;
		}
	}, onBeginInsert:function () {
	}, onInsertData:function () {
	}, onBeginUpdate:function () {
	}, onUpdateData:function () {
	}, onBeginDelete:function () {
	}, onDeleteData:function () {
	}, onCancelEdit:function () {
	}, onBeforeOperation:function (inOperation) {
	}, onSuccess:function (inData) {
	}, onResult:function (inData) {
	}, onError:function (inError) {
		wm.logging && console.error(inError);
		if (this.displayErrors) {
			var m = dojo.isString(inError) ? inError : (inError.message ? "Error: " + inError.message : "Unspecified Error");
			alert(m);
		}
	}});
}
if (!dojo._hasResource["wm.base.widget.LiveForm_design"]) {
	dojo._hasResource["wm.base.widget.LiveForm_design"] = true;
	dojo.provide("wm.base.widget.LiveForm_design");
	wm.Object.extendSchema(wm.LiveFormBase, {dataSet:{readonly:1, group:"data", order:1, bindTarget:1, type:"wm.Variable"}, dataOutput:{ignore:1, group:"data", order:2, bindable:1, type:"wm.Variable", simpleBindProp:true, categoryParent:"Properties", categoryProps:{component:"dataOutput", inspector:"Data"}}, clearData:{group:"operation", order:2}, addEditors:{group:"operation", order:5}, removeEditors:{group:"operation", order:10}, readonly:{group:"display", order:5}, validateBeforeSave:{group:"display", order:7, type:"Boolean"}, editorWidth:{group:"display", order:200}, editorHeight:{group:"display", order:201}, editorSize:{ignore:1}, captionSize:{group:"display", order:210}, captionUnits:{ignore:1}, captionAlign:{group:"display", order:230}, captionPosition:{group:"display", order:240}});
	wm.makeNameForProp = function (inProp, inSuffix) {
		return inProp.replace(/\.(\S)/g, function (w) {
			return w.slice(1).toUpperCase();
		}) + (inSuffix || "") + "1";
	};
	wm.getEditorClassName = function (type) {
		if (dojo.indexOf(wm.editors, type) == -1) {
			type = "Text";
		}
		if (type.toLowerCase() == "checkbox") {
			type = "Checkbox";
		}
		if (type.toLowerCase() == "select") {
			type = "SelectMenu";
		}
		return "wm." + type;
	};
	wm.LiveFormBase.extend({addEditors:"(addEditors)", removeEditors:"(removeEditors)", afterPaletteDrop:function () {
		wm.Container.prototype.afterPaletteDrop.call(this);
		this.createLiveSource(this._liveSource);
	}, designPasted:function () {
		this._checkBindings();
	}, listProperties:function () {
		var p = this.inherited(arguments);
		p.editorWidth.ignore = p.editorWidth.writeonly = (this.box == "v");
		p.editorHeight.ignore = p.editorHeight.writeonly = (this.box == "h");
		return p;
	}, set_dataSet:function (inDataSet) {
		if (inDataSet instanceof wm.Variable) {
			this.setDataSet(inDataSet);
			if (this.canAddEditors()) {
				this.addEditors();
			}
		} else {
			var ds = this.getValueById(inDataSet), structured = ds && wm.typeManager.isStructuredType((ds || 0).type);
			if (structured) {
				this.bindDataSet(ds);
			} else {
				if (!inDataSet) {
					this.unsetDataSet();
				}
			}
		}
	}, bindDataSet:function (inDataSet) {
		if (inDataSet instanceof wm.Variable) {
			this.$.binding.addWire("", "dataSet", (inDataSet || 0).getId());
		}
	}, unsetDataSet:function () {
		this.dataSet = null;
	}, destroyEditors:function () {
		this._currentEditors = null;
		for (var i = 0, eds = this.getFormEditorsArray(), e; (e = eds[i]); i++) {
			this._removeBindingForEditor(e);
			e.destroy();
		}
	}, removeEditors:function () {
		this.destroyEditors();
		this.setFitToContentHeight(false);
		this.reflow();
		wm.fire(this, "updateDesignTrees");
	}, destroyGrid:function () {
		for (var i = 0, eds = this.findGrid(), e; (e = eds[i]); i++) {
			this._removeBindingForEditor(e);
			e.destroy();
		}
	}, removeGrid:function () {
		this.destroyGrid();
		this.setFitToContentHeight(false);
		this.reflow();
		wm.fire(this, "updateDesignTrees");
	}, canAddEditors:function () {
		if (!this._loading && this.isDesignLoaded()) {
			if (!wm.typeManager.isStructuredType((this.dataSet || 0).type)) {
				wm.logging && console.log(this.name, "dataSet with known data type required before generating editors.");
			} else {
				return (!this.getFormEditorsArray().length);
			}
		}
	}, addEditors:function () {
		var ds = this.dataSet;
		this._currentEditors = this.getFormEditorsArray();
		ds.beginUpdate();
		this.makeEditors();
		this.finishAddEditors();
		this._currentEditors = null;
		ds.endUpdate();
	}, finishAddEditors:function () {
		var eds = this.getFormEditorsArray();
		dojo.forEach(eds, function (e) {
			e._doRenderReflow = true;
		});
		wm.fire(this, "updateDesignTrees");
		this.populateEditors();
		this.setFitToContentHeight(true);
		this.reflow();
	}, makeEditors:function () {
		var lv = this.getLiveVariable(), fields = lv ? lv.getViewFields() : wm.getDefaultView((this.dataSet || 0).type);
		dojo.forEach(fields, dojo.hitch(this, "makeEditor"));
		if (lv) {
			if (lv.liveView) {
				lv.liveView.getRequiredRelatedFields();
			}
			dojo.forEach(lv.getViewRelated(), function (r) {
				var formField = this._getFormField(r);
				if (formField) {
					this.makeRelatedEditor(formField);
				}
			}, this);
		}
	}, makeEditor:function (inFieldInfo) {
		var f = inFieldInfo, ff = this._getFormField(f.dataIndex);
		if (ff && !this._getEditorForField(ff)) {
			var props = dojo.mixin(this.getFormEditorProps() || {}, {formField:ff, readonly:true, name:wm.makeNameForProp(ff, "Editor")}), e = this.createEditor(f, props, null, wm.getEditorClassName(f.displayType));
			if (e) {
				this._bindEditor(e);
			}
			return true;
		}
	}, makeRelatedEditor:function (inRelated) {
		var re = this._getEditorForField(inRelated);
		if (!re) {
			var list = wm.typeManager.isPropInList((this.dataSet || 0)._dataSchema, inRelated);
			var e = this.createRelatedEditor(inRelated);
			if (e) {
				this._bindEditor(e);
			}
		}
	}, createRelatedEditor:function (inFormField) {
		var props = this.getFormEditorProps();
		props.formField = inFormField;
		return this.owner.loadComponent(wm.makeNameForProp(inFormField, "RelatedEditor"), this, "wm.RelatedEditor", props);
	}, _getFormField:function (inField) {
		if (inField.indexOf(".") == -1) {
			return inField;
		}
	}, _getEditorForField:function (inField) {
		var editors = this._currentEditors = this._currentEditors || this.getFormEditorsArray();
		for (var i = 0, editors, e; (e = editors[i]); i++) {
			if (e.formField == inField) {
				return e;
			}
		}
	}, _hasOutputBindingForProp:function (inProp) {
		var w = wm.data.getPropWire(this, "dataOutput" + (inProp ? "." : "") + inProp || "");
		return Boolean(w);
	}, getFormEditorProps:function () {
		return {size:this.editorSize, readonly:this.readonly, captionSize:this.captionSize, captionAlign:this.captionAlign, captionPosition:this.captionPosition};
	}, getEditorParent:function () {
		return this;
	}, createEditor:function (inFieldInfo, inProps, inEvents, inClass) {
		var e = wm.createFieldEditor(this.getEditorParent(), inFieldInfo, inProps, inEvents, inClass);
		if (e) {
			e.setWidth(this.editorWidth);
			e.setHeight(this.editorHeight);
			return e;
		}
	}, createLiveSource:function (inType) {
		var ti = wm.typeManager.getType(inType);
		if (!ti) {
			return;
		}
		var sa = studio.application, name = inType.split(".").pop().toLowerCase(), lv = new wm.LiveView({owner:sa, name:wm.findUniqueName(name + "LiveView1", [sa]), service:ti.service, dataType:inType, _defaultView:true});
		var r = this.getRoot();
		var d = r.createComponent(name + "LiveVariable1", "wm.LiveVariable", {liveSource:lv.getId()});
		this.set_dataSet(d.name);
		if (r == studio.page) {
			this.updateDesignTrees();
		}
	}, addEditorToForm:function (inEditor) {
		var e = inEditor, ff = e.formField && this.getViewDataIndex(e.formField || "");
		if (ff) {
			var f = this.addEditorToView(e, ff);
			if (f) {
				wm.updateFieldEditorProps(e, f);
			}
		}
		inEditor.setReadonly(this.readonly);
		this._bindEditor(inEditor);
		this.populateEditors();
	}, addEditorToView:function (inEditor, inField) {
		var ff = inField, lv = this.getLiveVariable(), v = lv && lv.liveView;
		if (v) {
			if (inEditor instanceof wm.Editor) {
				return v.addField(ff);
			} else {
				v.addRelated(ff);
				lv.update();
			}
		}
	}, _checkBindings:function () {
		var editors = this.getFormEditorsArray();
		for (var i = 0, ed; (ed = editors[i]); i++) {
			if (!this._isOkOutputBinding(ed)) {
				this._bindEditorOutput(ed);
			}
			if (!this._isOkInputBinding(ed)) {
				this._bindEditorInput(ed);
			}
		}
	}, _isOkInputBinding:function (inEditor) {
		var info = this._getInputBindInfo(inEditor), b = inEditor && inEditor.components.binding, wires = b && b.wires, w = info && wires[info.targetProperty];
		return !info || (w && (w.source == info.source));
	}, _isOkOutputBinding:function (inEditor) {
		var info = this._getOutputBindInfo(inEditor), b = this.components.binding, wires = b.wires, w = info && wires[info.targetProperty];
		return !info || (w && (w.source == info.source));
	}, _removeBindingForEditor:function (inEditor) {
		var wire, binding = this.components.binding, wires = binding.wires, n = inEditor && inEditor.getId();
		if (n) {
			for (var i in wires) {
				wire = wires[i];
				if (wire.source.indexOf(n) == 0) {
					binding.removeWire(wire.getWireId());
				}
			}
		}
		var binding = inEditor.components.binding;
		if (binding) {
			binding.removeWire("dataValue");
		}
	}, _getInputBindInfo:function (inEditor) {
		if (inEditor instanceof wm.Editor) {
			return;
		}
		var f = inEditor.formField, targetProperty = inEditor instanceof wm.Editor ? "dataValue" : (inEditor instanceof wm.RelatedEditor ? "dataSet" : null), ds = this.dataSet, source = ds ? (ds.getId() + (f ? "." + f : "")) : "";
		if (source) {
			return f !== undefined && targetProperty ? {targetProperty:targetProperty, source:source} : false;
		}
	}, _getOutputBindInfo:function (inEditor) {
		if (inEditor instanceof wm.Editor) {
			return;
		}
		var f = inEditor.formField, targetProperty = "dataOutput" + (f ? "." + f : ""), p = inEditor instanceof wm.Editor ? "dataValue" : (inEditor instanceof wm.RelatedEditor ? "dataOutput" : null), source = inEditor.getId() + (p ? "." + p : "");
		return f !== undefined && p ? {targetProperty:targetProperty, source:source} : false;
	}, _bindEditorInput:function (inEditor) {
		var info = this._getInputBindInfo(inEditor);
		if (info) {
			inEditor.$.binding.addWire("", info.targetProperty, info.source);
		}
	}, _bindEditorOutput:function (inEditor) {
		var info = this._getOutputBindInfo(inEditor);
		if (info) {
			this.components.binding.addWire("", info.targetProperty, info.source);
		}
	}, _bindEditor:function (inEditor) {
		if (!inEditor) {
			return;
		}
		this._removeBindingForEditor(inEditor);
		this._bindEditorInput(inEditor);
		this._bindEditorOutput(inEditor);
	}, makePropEdit:function (inName, inValue, inDefault) {
		switch (inName) {
		  case "addEditors":
		  case "removeEditors":
		  case "clearData":
			return makeReadonlyButtonEdit(inName, inValue, inValue);
		  case "editorWidth":
		  case "editorHeight":
		  case "captionSize":
			return new wm.propEdit.UnitValue({component:this, name:inName, value:inValue, options:this._sizeUnits});
		  case "captionAlign":
			return makeSelectPropEdit(inName, inValue, ["left", "center", "right"], inDefault);
		  case "captionPosition":
			return makeSelectPropEdit(inName, inValue, ["top", "left", "bottom", "right"], inDefault);
		  case "editPanelStyle":
			return makeSelectPropEdit(inName, inValue, ["wm.Button", "wm.RoundedButton", "none"], inDefault);
		  case "dataSet":
			var p = wm.getParentForm(this);
			return p ? new wm.propEdit.Select({component:this, name:inName, options:[""].concat(this.getFormSubDataSetNames(p))}) : new wm.propEdit.DataSetSelect({component:this, name:inName, widgetDataSets:true});
		}
		return this.inherited(arguments);
	}, setName:function (inName) {
		this.inherited(arguments);
		var editPanel = this.getEditPanel();
		if (editPanel) {
			editPanel.setName(this.name + "EditPanel");
		}
	}, editProp:function (inName, inValue, inInspector) {
		switch (inName) {
		  case "addEditors":
			return this.addEditors();
		  case "removeEditors":
			if (confirm("Are you sure? All editors in " + this.getId() + " will be deleted.")) {
				return this.removeEditors();
			}
		  case "clearData":
			return this.clearData();
		}
		return this.inherited(arguments);
	}, getFormSubDataSetNames:function (inForm) {
		var ds = [], id = inForm.getId() + ".dataSet.", schema = (inForm.dataSet || 0)._dataSchema;
		for (var i in schema) {
			var ti = schema[i];
			if (ti.isList) {
			} else {
				if (wm.typeManager.isStructuredType(ti.type)) {
					ds.push(id + i);
				}
			}
		}
		return ds;
	}, updateDesignTrees:function () {
		wm.fire(studio, "refreshComponentOnTree", [this]);
		wm.fire(studio, "refreshComponentsTree");
	}});
	wm.LiveForm.description = "Displays a detailed form.";
	wm.Object.extendSchema(wm.LiveForm, {liveVariable:{ignore:1}, liveEditing:{group:"display", order:5, type:"Boolean"}, liveSaving:{ignore:1}, operation:{ignore:1}, defaultButton:{ignore:1, group:"data", order:5, bindTarget:1, type:"wm.Button"}, displayErrors:{group:"data", order:15}, noButtonPanel:{group:"display", order:8, type:"Boolean", ignore:1}, editPanelStyle:{group:"display", order:9, type:"String"}, });
	wm.LiveForm.extend({_defaultClasses:{domNode:["wm_SilverBlueTheme_MainOutsetPanel", "wm_Padding_4px"]}, addEditors:function () {
		this._generateDeferred = new dojo.Deferred();
		studio.beginWait("Adding Editors for " + this.getId());
		wm.onidle(this, function () {
			try {
				if (!this.getEditPanel()) {
					this.addEditPanel();
				}
				wm.LiveFormBase.prototype.addEditors.call(this);
			}
			catch (e) {
				this.finishAddEditors();
			}
			this.setHeight("500px");
			studio.select(null);
			studio.select(this);
		});
	}, setNoButtonPanel:function (inValue) {
		this.noButtonPanel = inValue;
		if (!inValue) {
			this.addEditPanel();
		} else {
			var e = this.getEditPanel();
			e.destroy();
		}
	}, setEditPanelStyle:function (inStyle) {
		if (this.editPanelStyle == inStyle) {
			return;
		}
		this.editPanelStyle = inStyle;
		var e = this.getEditPanel();
		if (e) {
			e.destroy();
		}
		if (inStyle != "none") {
			this.addEditPanel();
		} else {
			this.reflow();
		}
	}, finishAddEditors:function () {
		var p = this.getEditPanel();
		if (p) {
			p.parent.moveControl(p, p.parent.c$.length);
		}
		this.inherited(arguments);
		studio.endWait();
		if (this._generateDeferred && this._generateDeferred.fired == -1) {
			wm.fire(this._generateDeferred, "callback", [true]);
		}
	}, getSuccessUpdateVariable:function () {
		var v = wm.data.getPropBindSource(this, "dataSet");
		if (v instanceof wm.LiveVariable) {
			var w = wm.data.getPropBindSource(v, "sourceData");
			if (w) {
				v = w;
			}
		}
		if (v && (v.getId() || "").split(".").pop() == "selectedItem") {
			var ds = v.owner && v.owner.dataSet;
			if (ds instanceof wm.ServiceVariable && ds.isList) {
				v = ds;
			}
		}
		if (v instanceof wm.ServiceVariable) {
			return v.getId();
		}
	}, addSuccessRefresh:function () {
		if (!("onSuccess" in this.eventBindings)) {
			var s = this.getSuccessUpdateVariable();
			if (s) {
				this.eventBindings.onSuccess = s;
			}
		}
	}, getEditPanel:function () {
		var w, widgets = this.widgets;
		for (var i in widgets) {
			w = widgets[i];
			if (w instanceof wm.EditPanel) {
				return w;
			}
		}
	}, addEditPanel:function () {
		if (this.editPanelStyle == "none") {
			return;
		}
		var r = this.getRoot();
		if (!this.getEditPanel() && (wm.typeManager.getLiveService((this.dataSet || 0).type) || this.liveVariable)) {
			var e = this.owner.loadComponent(this.name + "EditPanel", this, "wm.EditPanel", {editPanelStyle:this.editPanelStyle});
			if (e) {
				e.set_liveForm(this.getId());
			}
		}
		this.setHeight("500px");
	}, isFormFieldInForm:function (ff) {
		var arr = this.getRelatedEditorsArray() || [];
		for (var i = 0; i < arr.length; i++) {
			var e = arr[i];
			if (e.formField == ff) {
				return true;
			}
		}
		return false;
	}});
	wm.SimpleForm.description = "Displays a simple form.";
	wm.SimpleForm.extend({bindEditorDataSet:function (e) {
		if (this.dataSet instanceof wm.Variable && e.formField) {
			e.$.binding.addWire("", "dataValue", this.dataSet.getId() + "." + e.formField);
		}
	}, _bindEditor:function (inEditor) {
		if (!inEditor) {
			return;
		}
		this._removeBindingForEditor(inEditor);
		this.bindEditorDataSet(inEditor);
		this._bindEditorOutput(inEditor);
	}});
	wm.Object.extendSchema(wm.SimpleForm, {readonly:{ignore:1}, validateBeforeSave:{ignore:1}, lock:{ignore:1}, freeze:{ignore:1}});
}
if (!dojo._hasResource["wm.base.widget.LivePanel"]) {
	dojo._hasResource["wm.base.widget.LivePanel"] = true;
	dojo.provide("wm.base.widget.LivePanel");
	dojo.declare("wm.LivePanel", wm.Panel, {height:"100%", width:"100%", layoutKind:"top-to-bottom", liveDataName:"", autoScroll:true, afterPaletteDrop:function () {
		wm.Container.prototype.afterPaletteDrop.call(this);
		var fancyPanel1 = new wm.FancyPanel({parent:this, horizontalAlign:"left", verticalAlign:"top", owner:this.owner, name:this.liveDataName + "GridPanel", title:wm.capitalize(this.liveDataName)});
		this.dataGrid = new wm.DojoGrid({border:"0", name:studio.page.getUniqueName(this.liveDataName + "DojoGrid"), owner:this.owner, height:"100%", parent:fancyPanel1.containerWidget, _classes:{"domNode":["omgDataGrid"]}});
		var fancyPanel2 = new wm.FancyPanel({parent:this, horizontalAlign:"left", verticalAlign:"top", owner:this.owner, name:this.liveDataName + "DetailsPanel", title:"Details"});
		this.liveForm = new wm.LiveForm({name:studio.page.getUniqueName(this.liveDataName + "LiveForm1"), owner:this.owner, parent:fancyPanel2.containerWidget, verticalAlign:"top", horizontalAlign:"left", _liveSource:this.liveSource});
		this.reflow();
		this.liveForm.createLiveSource(this.liveSource);
		var lvar = this.liveForm.dataSet.name;
		this.dataGrid.set_dataSet(lvar);
		this.liveForm.set_dataSet(this.dataGrid.name + ".selectedItem");
		this.liveForm.eventBindings.onSuccess = lvar;
		fancyPanel2.setFitToContentHeight(true);
	}});
	wm.Object.extendSchema(wm.LivePanel, {themeStyleType:{ignore:1}, liveDataName:{ignore:1}, liveSource:{ignore:1}});
}
if (!dojo._hasResource["wm.base.widget.RelatedEditor"]) {
	dojo._hasResource["wm.base.widget.RelatedEditor"] = true;
	dojo.provide("wm.base.widget.RelatedEditor");
	dojo.declare("wm.RelatedEditor", wm.LiveFormBase, {height:"26px", editingMode:"lookup", _lookupCache:null, canChangeEditorReadonly:function (inEditor, inReadonly, inCanChangeFunc) {
		var m = this.editingMode;
		switch (m) {
		  case "readonly":
			if (this.parent && this.parent.operation && this.parent.operation == "insert") {
				return inReadonly || ((inEditor == this.findLookup() && this.inherited(arguments)));
			} else {
				return inReadonly;
			}
		  case "lookup":
			return inReadonly || ((inEditor == this.findLookup() && this.inherited(arguments)));
		  default:
			return this.inherited(arguments);
		}
	}, findLookup:function () {
		var editors = this.getFormEditorsArray();
		for (var i = 0, e; (e = editors[i]); i++) {
			if (e.display == "Lookup") {
				return e;
			}
		}
	}, getLiveVariable:function () {
		var f = this._getLiveForm();
		return f && f.getLiveVariable();
	}, _getLiveForm:function () {
		var p = wm.getParentForm(this);
		while (p && !(wm.isInstanceType(p, wm.LiveForm))) {
			p = wm.getParentForm(p);
		}
		return p;
	}, _getRelativeFormField:function (inField) {
		var rootField = wm.getFormField(this) + ".";
		if (inField.indexOf(rootField) == 0) {
			return inField.substring(rootField.length);
		}
	}, getViewDataIndex:function (inField) {
		var r = wm.getFormField(this);
		return (r ? r + "." : "") + inField;
	}, validate:function () {
		this.inherited(arguments);
		wm.fire(this.parent, "validate");
	}, editStarting:function () {
		if (this.editingMode == "lookup") {
			this._lookupCache = this.dataOutput.getData();
		}
		this.inherited(arguments);
	}, editCancelling:function () {
		if (this.editingMode == "lookup" && this._lookupCache !== undefined) {
			this.dataSet.beginUpdate();
			this.dataSet.setData(this._lookupCache);
			this.dataSet.endUpdate();
			this._lookupCache = null;
		}
		this.inherited(arguments);
	}});
}
if (!dojo._hasResource["wm.base.widget.RelatedEditor_design"]) {
	dojo._hasResource["wm.base.widget.RelatedEditor_design"] = true;
	dojo.provide("wm.base.widget.RelatedEditor_design");
	wm.Object.extendSchema(wm.RelatedEditor, {dataSet:{ignore:1}, editingMode:{group:"common", order:100}, formField:{ignore:1, writeonly:1, group:"common", order:500}, caption:{ignore:1}, readonly:{ignore:1}});
	wm.RelatedEditor.extend({_editingModes:["lookup", "readonly"], _cachedLookup:null, designCreate:function () {
		this.inherited(arguments);
		if (this._hasAncestorEditingMode(["lookup"])) {
			this.editingMode = "readonly";
		}
	}, postInit:function () {
		this.inherited(arguments);
		this.initializeFormField();
	}, initializeFormField:function () {
		if (!this.formField) {
			var ff = this.getUniqueFormField();
			if (ff && ff != "") {
				this.set_formField(ff);
			}
		}
		var fieldSchema = this._getFieldSchema();
		if (fieldSchema && fieldSchema.isList) {
			this._editingModes = ["readonly"];
			this.editingMode = "readonly";
		} else {
			this.set_editingMode("lookup");
		}
	}, getUniqueFormField:function () {
		var lf = wm.getParentForm(this);
		if (!lf) {
			return "";
		}
		var arr = this.getOptions();
		if (arr.length < 2) {
			return arr[0];
		}
		for (var i = 1; i < arr.length; i++) {
			if (!lf.isFormFieldInForm(arr[i])) {
				return arr[i];
			}
		}
		return arr[1];
	}, listProperties:function () {
		var props = dojo.mixin({}, this.inherited(arguments)), f = wm.getParentForm(this);
		props.formField.ignore = !Boolean(f);
		return props;
	}, set_formField:function (inFieldName) {
		if (!inFieldName) {
			delete this.formField;
		} else {
			this.formField = inFieldName;
		}
		if (this.hasGrid()) {
			this.removeGrid();
		} else {
			this.removeEditors();
		}
		var f = wm.getParentForm(this);
		f.addEditorToForm(this);
	}, set_editingMode:function (inMode) {
		if (this._hasAncestorEditingMode(["readonly", "lookup"]) && inMode != "readonly") {
			alert("For this editor to be editable, its parent editor must have an editingMode of editable.");
			return;
		}
		this.editingMode = inMode;
		this._editModeChanged();
	}, _editModeChanged:function () {
		var m = this.editingMode;
		if (m == "readonly") {
			var s = this.findLookup();
			if (s) {
				s.setReadonly(true);
			}
		} else {
			if (m != "lookup") {
				this.cacheLookup();
			} else {
				this.insertLookup();
			}
		}
		this.reflow();
		this.updateDesignTrees();
		this.bindFormEditors();
		if (m != "editable") {
			this._disableChildrenEditing();
		}
	}, _disableChildrenEditing:function () {
		var related = this.getRelatedEditorsArray();
		dojo.forEach(related, function (r) {
			r.set_editingMode("readonly");
		});
	}, _hasAncestorEditingMode:function (inModes) {
		var p = this.parent;
		while (p && p instanceof wm.RelatedEditor) {
			if (dojo.indexOf(inModes || [], p.editingMode) != -1) {
				return true;
			}
			p = p.parent;
		}
	}, _getFormField:function (inField) {
		if (inField.indexOf(".") == -1) {
			return inField;
		}
		var f = this._getRelativeFormField(inField);
		if (f && f.indexOf(".") == -1) {
			return f;
		}
	}, makeEditors:function () {
		try {
			var fieldSchema = this._getFieldSchema();
			if (fieldSchema && fieldSchema.isList) {
				this.makeGrid();
			} else {
				var lookupAdded = null;
				if (this.editingMode == "lookup") {
					lookupAdded = this.makeLookup(fieldSchema);
				}
				if (!lookupAdded) {
					var lv = this.getLiveVariable(), fields = wm.getDefaultView((this.dataSet || 0).type);
					for (var i = 0; i < fields.length; i++) {
						if (this.makeEditor(fields[i])) {
							break;
						}
					}
				}
			}
		}
		catch (e) {
			console.info("error while making editors for related editor", e);
		}
	}, getFormEditorProps:function () {
		return {size:this.editorSize, readonly:true, captionSize:this.captionSize, captionAlign:this.captionAlign, captionPosition:this.captionPosition};
	}, cacheLookup:function () {
		var s = this.findLookup();
		if (s) {
			s.setParent(null);
			this._cachedLookup = s.id;
			s.parentNode.removeChild(s.domNode);
			this._removeBindingForEditor(s);
		}
	}, insertLookup:function () {
		if (this.findLookup()) {
			return;
		}
		var s = this.getValueById(this._cachedLookup) || this.makeLookup(this._getFieldSchema());
		if (s.parent != this) {
			s.setParent(this);
		}
		if (s != this.c$[0]) {
			this.moveControl(s, 0);
		}
	}, makeLookup:function (inFieldSchema) {
		if (this._getEditorForField("")) {
			return;
		}
		var lv = wm.getFormLiveView(this.parent);
		var relatedFields = wm.getDefaultView(lv.dataType, this.formField);
		var ff = "";
		if (relatedFields.length > 1) {
			ff = relatedFields[1];
		} else {
			if (relatedFields.length == 1) {
				ff = relatedFields[0];
			}
		}
		if (ff && ff.dataIndex) {
			ff.dataIndex = ff.dataIndex.split(".").pop();
		}
		var props = dojo.mixin(this.getFormEditorProps(), {formField:"", displayField:ff.dataIndex});
		props.editorInitProps = {allowNone:!inFieldSchema.required, required:inFieldSchema.required, lookupDisplay:ff.displayType || "Text", displayField:ff.dataIndex, formField:ff.dataIndex};
		props.name = wm.makeNameForProp(this.formField, "Lookup");
		var lookupProps = this._getLookupFieldInfo(inFieldSchema);
		lookupProps.displayField = ff.dataIndex;
		var e = this.createEditor(lookupProps, props, null, "wm.Lookup");
		if (e) {
			this._bindEditor(e);
			return e;
		}
	}, _getFieldSchema:function () {
		var f = wm.getParentForm(this);
		if (!f) {
			console.debug("RelatedEditor \"" + this.name + "\" is not inside a live form.");
			return;
		}
		var dataType = f && f._getDataType(), schema = wm.typeManager.getTypeSchema(dataType);
		if (!schema) {
			return;
		}
		return wm.typeManager.getPropertyInfoFromSchema(schema, this.formField);
	}, _getLookupFieldInfo:function (inFieldSchema) {
		return {caption:wm.capitalize(this.formField) + " (lookup)", displayType:"Lookup", required:inFieldSchema.required, includeLists:true, includeForms:true};
	}, _getLookupDisplayExpression:function () {
		var fields = [], t = this._getDataType(), schema = wm.typeManager.getTypeSchema(t);
		if (this.formField in schema && !(wm.typeManager.isStructuredType(schema[this.formField].type))) {
			fields.push(this.formField);
		} else {
			fields = fields.concat(wm.data.getIncludeFields(t));
		}
		return fields.length ? "${" + fields.join("} ${") + "}" : "";
	}, hasGrid:function () {
		return wm.getMatchingFormWidgets(this, dojo.hitch(this, function (w) {
			return ((w instanceof wm.DojoGrid) && w.getDataSet().getId() == this.dataSet.getId());
		})).length;
	}, findGrid:function () {
		return wm.getMatchingFormWidgets(this, dojo.hitch(this, function (w) {
			return ((w instanceof wm.DataGrid) && w.dataSet.getId() == this.dataSet.getId());
		}));
	}, makeGrid:function () {
		if (this.hasGrid()) {
			return;
		}
		var p = this.getEditorParent(), g = this.owner.loadComponent("dataGrid1", p, "wm.DojoGrid", {height:"100px"}), dsId = (this.dataSet || 0).getId();
		if (g && dsId) {
			g.set_dataSet(dsId);
		}
	}, removeGrid:function () {
		this.inherited(arguments);
	}, removeEditors:function () {
		this.inherited(arguments);
	}, _getOutputBindInfo:function (inEditor) {
		var m = this.editingMode, isSelect = inEditor.display == "Lookup";
		if (m == "editable" && !isSelect) {
			return this.inherited(arguments);
		} else {
			if (m == "lookup" && inEditor.display == "Lookup") {
				return {targetProperty:"dataOutput", source:inEditor.getId() + ".selectedItem"};
			}
		}
	}, bindFormEditors:function (inRecurse) {
		var editors = this.getFormEditorsArray();
		dojo.forEach(editors, function (e) {
			this._bindEditor(e);
			if (inRecurse && e instanceof wm.RelatedEditor) {
				e.bindFormEditors(inRecurse);
			}
		}, this);
	}, makePropEdit:function (inName, inValue, inDefault) {
		switch (inName) {
		  case "formField":
			return new wm.propEdit.FormFieldSelect({component:this, name:inName, value:inValue, relatedFields:true});
		  case "editingMode":
			return makeSelectPropEdit(inName, inValue, this._editingModes, inDefault);
		}
		return this.inherited(arguments);
	}, getSchemaOptions:function (inSchema) {
		return [""].concat(wm.typeManager["getStructuredPropNames"](inSchema));
	}, getOptions:function () {
		var f = wm.getParentForm(this), ds = f && f.dataSet;
		return ds && ds.type ? this.getSchemaOptions(ds._dataSchema) : [""];
	}});
}
if (!dojo._hasResource["wm.base.widget.EditPanel"]) {
	dojo._hasResource["wm.base.widget.EditPanel"] = true;
	dojo.provide("wm.base.widget.EditPanel");
	dojo.declare("wm.EditPanel", wm.Panel, {border:"0", operationPanel:"", savePanel:"", liveForm:"", layoutKind:"top-to-bottom", verticalAlign:"top", horizontalAlign:"right", lock:true, formUneditable:false, formInvalid:true, width:"100%", height:"40px", editPanelStyle:"wm.RoundedButton", destroy:function () {
		this._unsubscribeLiveForm();
		this.inherited(arguments);
	}, init:function () {
		this.inherited(arguments);
		this.setLiveForm(this.liveForm);
		this.updateControlsStatus();
	}, loaded:function () {
		this.inherited(arguments);
		if (wm.pasting) {
			wm.fire(this, "designPasted");
		}
	}, setLiveForm:function (inLiveForm) {
		if (inLiveForm instanceof wm.Component) {
			inLiveForm = inLiveForm.getId();
		}
		this.liveForm = inLiveForm;
		this._subscribeLiveForm();
	}, _subscribeLiveForm:function () {
		this._unsubscribeLiveForm();
		var c = this._liveFormSubscriptions = [];
		var w = this._liveFormWires = [];
		if (this.liveForm) {
			var form = this.getValueById(this.liveForm);
			c.push(dojo.connect(form, "setDataSet", this, "updateControlsStatus"));
			c.push(dojo.connect(form, "beginEdit", this, "_beginEdit"));
			c.push(dojo.connect(form, "endEdit", this, "_endEdit"));
			w.push(new wm.Wire({owner:this, targetId:this.getId(), targetProperty:"formInvalid", source:[this.liveForm, "invalid"].join(".")}).connectWire());
		}
	}, _unsubscribeLiveForm:function () {
		dojo.forEach(this._liveFormSubscriptions, dojo.disconnect);
		dojo.forEach(this._liveFormWires, function (w) {
			wm.fire(w, "destroy");
		});
	}, _beginEdit:function () {
		this._toggleEdit(true);
	}, _endEdit:function () {
		this._toggleEdit(false);
	}, _toggleEdit:function (inEdit) {
		wm.fire(this.getValueById(this.operationPanel), "setShowing", [!inEdit]);
		wm.fire(this.getValueById(this.savePanel), "setShowing", [inEdit]);
	}, updateControlsStatus:function () {
		this.setValue("formUneditable", !wm.fire(this.getValueById(this.liveForm), "hasEditableData"));
	}, beginDataInsert:function () {
		wm.fire(this.getValueById(this.liveForm), "beginDataInsert");
	}, beginDataUpdate:function () {
		wm.fire(this.getValueById(this.liveForm), "beginDataUpdate");
	}, deleteData:function () {
		wm.fire(this.getValueById(this.liveForm), "deleteData");
	}, saveData:function () {
		wm.fire(this.getValueById(this.liveForm), "saveData");
	}, cancelEdit:function () {
		wm.fire(this.getValueById(this.liveForm), "cancelEdit");
	}});
	wm.EditPanel.description = "Controls for editing a form.";
	wm.Object.extendSchema(wm.EditPanel, {addControls:{group:"operation", order:7}, removeControls:{group:"operation", order:8}, liveForm:{group:"common", order:200}, savePanel:{ignore:1, writeonly:1}, operationPanel:{ignore:1, writeonly:1}, formUneditable:{ignore:1, bindSource:1}, formInvalid:{ignore:1, bindSource:1}, editPanelStyle:{ignore:1}});
	wm.EditPanel.extend({addControls:"(addControls)", removeControls:"(removeControls)", _defaultClasses:{domNode:["wm_Padding_4px"]}, _buttonWidth:"100px", designCreate:function () {
		this.inherited(arguments);
		this.subscribe("wmwidget-idchanged", this, "widgetNameChanged");
	}, designPasted:function () {
		if (!this._controlsOk()) {
			this._resetContents();
		}
	}, _resetContents:function () {
		this.setLiveForm("");
		this._unsetControls();
		wm.forEach(this.widgets, function (w) {
			w.destroy();
		});
	}, _unsetControls:function () {
		this.operationPanel = this.savePanel = null;
	}, _createSavePanel:function () {
		var props = {showing:false, layoutKind:"left-to-right", horizontalAlign:"right", verticalAlign:"top", width:"100%", height:"100%", border:"0"}, p = this.owner.loadComponent("savePanel1", this, "wm.Panel", props);
		this.savePanel = p.getId();
		var n = this.getId(), sb = this.owner.loadComponent("saveButton1", p, this.editPanelStyle, {caption:"Save", width:this._buttonWidth, height:"100%"}, {onclick:n + ".saveData"});
		this.owner.loadComponent("cancelButton1", p, this.editPanelStyle, {caption:"Cancel", width:this._buttonWidth, height:"100%"}, {onclick:n + ".cancelEdit"});
		sb.$.binding.addWire("", "disabled", n + ".formInvalid");
		this.reflow();
	}, _createOperationPanel:function () {
		var props = {layoutKind:"left-to-right", horizontalAlign:"right", verticalAlign:"top", width:"100%", height:"100%", border:"0"}, p = this.owner.loadComponent("operationPanel1", this, "wm.Panel", props);
		this.operationPanel = p.getId();
		var n = this.getId();
		this.owner.loadComponent("newButton1", p, this.editPanelStyle, {caption:"New", width:this._buttonWidth, height:"100%"}, {onclick:n + ".beginDataInsert"});
		var u = this.owner.loadComponent("updateButton1", p, this.editPanelStyle, {caption:"Update", width:this._buttonWidth, height:"100%"}, {onclick:n + ".beginDataUpdate"});
		var d = this.owner.loadComponent("deleteButton1", p, this.editPanelStyle, {caption:"Delete", width:this._buttonWidth, height:"100%"}, {onclick:n + ".deleteData"});
		this.reflow();
		u.$.binding.addWire("", "disabled", n + ".formUneditable");
		d.$.binding.addWire("", "disabled", n + ".formUneditable");
	}, removeControls:function () {
		if (confirm("Are you sure? All widgets in " + this.getId() + " will be deleted.")) {
			this._removeControls();
		}
	}, _removeControls:function () {
		this._destroyControls();
		this.reflow();
		this.updateDesignTrees();
	}, _destroyControls:function () {
		var o = this.getValueById(this.operationPanel);
		wm.fire(o, "destroy");
		var s = this.getValueById(this.savePanel);
		wm.fire(s, "destroy");
		this._unsetControls();
	}, _addControls:function () {
		this._destroyControls();
		this._createSavePanel();
		this._createOperationPanel();
		this.setLock(true);
		this.updateControlsStatus();
		this.reflow();
	}, updateDesignTrees:function () {
		wm.fire(studio, "refreshComponentOnTree", [this]);
	}, set_liveForm:function (inLiveForm) {
		this.setLiveForm(inLiveForm);
		var a = this.getValueById(this.liveForm);
		if (a) {
			if (!this.c$.length) {
				this._addControls();
			}
			a.setReadonly(true);
		}
	}, getLiveFormNames:function () {
		var l = [""];
		wm.forEachWidget(studio.page.root, function (w) {
			if (w instanceof wm.LiveForm) {
				l.push(w.getId());
			}
		});
		return l;
	}, widgetNameChanged:function (inOldId, inNewId, inOldRtId, inNewRtId) {
		var monitored = {"operationPanel":1, "savePanel":1, "liveForm":1};
		for (var i in monitored) {
			if (this[i] == inOldId) {
				this[i] = inNewId;
			}
		}
	}, _controlsOk:function () {
		var op = this.getValueById(this.operationPanel), sp = this.getValueById(this.savePanel);
		return ((!op || op.parent == this) && (!sp || sp.parent == this));
	}, makePropEdit:function (inName, inValue, inDefault) {
		switch (inName) {
		  case "addControls":
		  case "removeControls":
			return makeReadonlyButtonEdit(inName, inValue, inDefault);
		  case "liveForm":
			return makeSelectPropEdit(inName, inValue, this.getLiveFormNames(inValue), inDefault);
		}
		return this.inherited(arguments);
	}, editProp:function (inName, inValue, inInspector) {
		switch (inName) {
		  case "addControls":
			return this._addControls();
		  case "removeControls":
			return this.removeControls();
		}
		return this.inherited(arguments);
	}});
}
if (!dojo._hasResource["wm.base.widget.DataNavigator"]) {
	dojo._hasResource["wm.base.widget.DataNavigator"] = true;
	dojo.provide("wm.base.widget.DataNavigator");
	dojo.declare("wm.DataNavigator", wm.Panel, {classNames:"wmdatanavigator", box:"h", lock:true, byPage:false, border:0, height:"36px", _buttonWidth:"46px", layoutKind:"left-to-right", horizontalAlign:"right", verticalAlign:"middle", liveSource:"", init:function () {
		this.inherited(arguments);
		this.createNavComponents();
		this.connectNavComponents();
	}, createNavComponents:function () {
		this.readComponents(this.getTemplate());
		dojo.mixin(this, this.widgets);
	}, connectNavComponents:function () {
		this.connect(this.firstButton, "onclick", this, "setFirst");
		this.connect(this.prevButton, "onclick", this, "setPrevious");
		this.connect(this.nextButton, "onclick", this, "setNext");
		this.connect(this.lastButton, "onclick", this, "setLast");
		this.connect(this.recordEditor, "onchange", this, "recordEdited");
	}, getTemplate:function () {
		return ["{", "firstButton: [\"wm.Button\", {caption: \"&nbsp&laquo;&nbsp;\", width: \"", this._buttonWidth, "\", height: \"100%\"}, {}],", "prevButton: [\"wm.Button\", {caption: \"&nbsp&lt;&nbsp;\", width: \"", this._buttonWidth, "\", height: \"100%\"}, {}],", "recordEditor: [\"wm.Editor\", {width: \"65px\", margin: 4, height: \"100%\"}, {}, {", "editor: [\"wm._NumberEditor\", {}, {}]", "}],", "totalLabel: [\"wm.Label\", {caption: \"of 0\", width: \"50px\", border: 0, height: \"100%\"}, {}, {", "format: [\"wm.DataFormatter\", {}, {}]", "}],", "nextButton: [\"wm.Button\", {caption: \"&nbsp&gt;&nbsp;\", width: \"", this._buttonWidth, "\", height: \"100%\"}, {}],", "lastButton: [\"wm.Button\", {caption: \"&nbsp&raquo;&nbsp;\", width: \"", this._buttonWidth, "\", height: \"100%\"}, {}]", "}"].join("");
	}, setFirst:function () {
		wm.fire(this.liveSource, this.byPage ? "setFirstPage" : "setFirst");
		this.update();
	}, setPrevious:function () {
		wm.fire(this.liveSource, this.byPage ? "setPreviousPage" : "setPrevious");
		this.update();
	}, setNext:function () {
		wm.fire(this.liveSource, this.byPage ? "setNextPage" : "setNext");
		this.update();
	}, setLast:function () {
		wm.fire(this.liveSource, this.byPage ? "setLastPage" : "setLast");
		this.update();
	}, recordEdited:function () {
		var r = this.recordEditor;
		if (r.isValid() && !this._updating) {
			wm.fire(this.liveSource, this.byPage ? "setPage" : "setCursor", [this.recordEditor.getValue("dataValue") - 1]);
		}
		this._updating = false;
	}, update:function (inDataSet) {
		var ls = this.liveSource;
		if (!ls) {
			return;
		}
		var c = (this.byPage ? ls.getPage() : ls.cursor) + 1, d = this.liveSource.getCursorItem().getData(), t = (this.byPage ? ls.getTotalPages() : ls.getCount()) || 1;
		r = this.recordEditor;
		this._updating = c != r.getValue("dataValue");
		if (c > t) {
			c = t;
		}
		r.setValue("dataValue", c);
		this.totalLabel.setValue("caption", "of " + t);
		this._doSetRecord(d, c);
	}, setLiveSource:function (inLiveSource) {
		var s = inLiveSource;
		if (dojo.isString(s) && s) {
			this.components.binding.addWire("", "liveSource", s);
			return;
		}
		s = s instanceof wm.LiveForm ? s.dataSet : s;
		if (s instanceof wm.LiveVariable) {
			this.liveSource = s;
			this.connect(this.liveSource, "onSuccess", this, "update");
			this.update();
		} else {
			this.liveSource = "";
		}
	}, getLiveSource:function () {
		return this.liveSource && this.liveSource.getId();
	}, setLiveForm:function (inLiveForm) {
		this.setLiveSource(inLiveForm);
	}, _doSetRecord:function (inData, inIndex) {
		if (inIndex != this._lastRecord) {
			this.onsetrecord(inData, inIndex);
		}
		this._lastRecord = inIndex;
	}, onsetrecord:function (inData, inIndex) {
	}, adjustChildProps:function (inCtor, inProps) {
		this.inherited(arguments);
		dojo.mixin(inProps, {owner:this});
	}, writeChildren:function () {
		return [];
	}});
	wm.Object.extendSchema(wm.DataNavigator, {box:{ignore:1}, lock:{ignore:1}, liveForm:{ignore:1}, layoutKind:{ignore:1}, byPage:{group:"common", order:250}, liveSource:{readonly:1, bindable:1, type:"wm.LiveVariable", group:"common", order:200}, firstRecord:{group:"operation", order:5}, previousRecord:{group:"operation", order:10}, nextRecord:{group:"operation", order:15}, lastRecord:{group:"operation", order:20}});
	wm.DataNavigator.extend({_defaultClasses:{domNode:["wm_Padding_4px"]}, firstRecord:"(first record)", previousRecord:"(previous record)", nextRecord:"(next record)", lastRecord:"(last record)", makePropEdit:function (inName, inValue, inDefault) {
		switch (inName) {
		  case "firstRecord":
		  case "previousRecord":
		  case "nextRecord":
		  case "lastRecord":
			return makeReadonlyButtonEdit(inName, inValue, inDefault);
		  case "liveSource":
			return new wm.propEdit.DataSetSelect({component:this, name:inName, widgetDataSets:true, listMatch:true});
		}
		return this.inherited(arguments);
	}, editProp:function (inName, inValue, inInspector) {
		switch (inName) {
		  case "firstRecord":
			return this.setFirst();
		  case "previousRecord":
			return this.setPrevious();
		  case "nextRecord":
			return this.setNext();
		  case "lastRecord":
			return this.setLast();
		}
		return this.inherited(arguments);
	}});
}
if (!dojo._hasResource["wm.base.widget.Input"]) {
	dojo._hasResource["wm.base.widget.Input"] = true;
	dojo.provide("wm.base.widget.Input");
	dojo.declare("wm.Input", wm.Box, {inputValue:"", margin:2, maxLength:"", inputType:"text", checked:false, readOnly:false, changeOnKey:false, build:function () {
		this.domNode = document.createElement("input");
		this.renderInput();
	}, setDomNode:function (inDomNode) {
		this.inherited(arguments);
		dojo.addClass(this.domNode, "wminput");
	}, init:function () {
		this.inherited(arguments);
		this.connect(this.domNode, "onclick", this, "onclick");
		this.connect(this.domNode, "onchange", this, "onchange");
		this.connect(this.domNode, "onblur", this, "onblur");
		this.connect(this.domNode, "onkeypress", this, "onkeypress");
	}, renderInput:function () {
		this.setValue("inputValue", this.inputValue);
		this.setInputType(this.inputType);
		this.setMaxLength(this.maxLength);
		this.setChecked(this.checked);
		this.setReadOnly(this.readOnly);
	}, renderData:function () {
		var d = this.owner[this.dataSource];
		this.setInputValue(d && d.data && d.data[this.dataField] || this.inputValue);
		this.setChecked(this.checked || this.inputValue != "");
	}, setInputValue:function (inValue) {
		this.inputValue = inValue || "";
		this.domNode.value = this.inputValue;
	}, getInputValue:function () {
		return this.inputValue = this.getNodeValue();
	}, getNodeValue:function () {
		return this.domNode.value;
	}, setDomProp:function (inProp, inValue) {
		this[inProp] = inValue;
		if (inValue) {
			this.domNode.setAttribute(inProp, inValue);
		} else {
			this.domNode.removeAttribute(inProp);
		}
	}, setChecked:function (inChecked) {
		this.domNode.checked = inChecked;
	}, getChecked:function () {
		return this.domNode.checked;
	}, setDisabled:function (inDisabled) {
		this.setDomProp("disabled", inDisabled);
	}, setReadOnly:function (inReadonly) {
		this.setDomProp("readOnly", inReadonly);
	}, setMaxLength:function (inMaxLength) {
		this.maxLength = inMaxLength;
		if (this.maxLength) {
			this.domNode.maxLength = this.maxLength;
		} else {
			this.domNode.removeAttribute("maxlength");
		}
		this.setInputValue(this.getNodeValue());
	}, setInputType:function (inInputType) {
		this.inputType = inInputType;
		if (this.inputType) {
			this.domNode.type = this.inputType;
			this.reflowParent();
		}
	}, inputChanged:function () {
		if (this.inputValue != this.getNodeValue()) {
			this.setValue("inputValue", this.getNodeValue());
		}
	}, canFocus:function () {
		return this.showing;
	}, focus:function () {
		this.domNode.focus();
	}, onclick:function () {
	}, onchange:function () {
	}, onblur:function () {
		this.inputChanged();
	}, onkeypress:function () {
		if (this.changeOnKey) {
			setTimeout(dojo.hitch(this, "inputChanged"), 0);
		}
	}});
	wm.Input.description = "A text input.";
	wm.Object.extendSchema(wm.Input, {inputValue:{bindable:1, group:"common", order:1, focus:1}});
	wm.Input.extend({scrim:true, makePropEdit:function (inName, inValue, inDefault) {
		if (inName == "inputType") {
			return makeSelectPropEdit(inName, inValue, ["text", "checkbox", "password", "file", "hidden"], inDefault);
		}
		return this.inherited("makePropEdit", arguments);
	}});
}
if (!dojo._hasResource["wm.base.widget.TextArea"]) {
	dojo._hasResource["wm.base.widget.TextArea"] = true;
	dojo.provide("wm.base.widget.TextArea");
	dojo.declare("wm.TextArea", wm.Box, {inputValue:"", width:"1flex", height:"1flex", margin:2, readonly:false, build:function () {
		this.domNode = document.createElement("textarea");
		this.domNode.setAttribute("spellCheck", "false");
		this.renderTextArea();
	}, setDomNode:function (inDomNode) {
		this.inherited(arguments);
		dojo.addClass(this.domNode, "wmtextarea");
	}, init:function () {
		this.readonly = this.readOnly;
		this.inherited(arguments);
		this.connect(this.domNode, "onclick", this, "onclick");
		this.connect(this.domNode, "onkeypress", this, "onkeypress");
		this.connect(this.domNode, "onblur", this, "onblur");
	}, renderTextArea:function () {
		this.setValue("inputValue", this.inputValue);
		this.setInputValue(this.inputValue);
		this.setReadonly(this.readonly);
		this.setDisabled(this.disabled);
	}, clear:function () {
		this.setInputValue("");
	}, setInputValue:function (inValue) {
		this.inputValue = inValue;
		this.domNode.value = this.inputValue;
	}, getInputValue:function () {
		return this.inputValue = this.getNodeValue();
	}, getNodeValue:function () {
		return this.domNode.value;
	}, setDomProp:function (inProp, inValue) {
		this[inProp] = inValue;
		if (inValue) {
			this.domNode.setAttribute(inProp, inValue);
		} else {
			this.domNode.removeAttribute(inProp);
		}
	}, setReadonly:function (inReadonly) {
		this.setDomProp("readOnly", inReadonly);
	}, setDisabled:function (inDisabled) {
		this.inherited(arguments);
		this.setDomProp("disabled", inDisabled);
		dojo[inDisabled ? "addClass" : "removeClass"](this.domNode, "wmtextarea-disabled");
	}, inputChanged:function () {
		if (this.inputValue != this.getNodeValue()) {
			this.setValue("inputValue", this.getNodeValue());
			this.onchange(this.inputValue);
		}
	}, onchange:function (newValue) {
	}, onclick:function (inEvent) {
	}, onkeypress:function (inEvent) {
	}, onblur:function (inEvent) {
		this.inputChanged();
	}});
	wm.Object.extendSchema(wm.TextArea, {inputValue:{bindable:1, group:"common", order:1, focus:1}});
	wm.TextArea.description = "A multi-line text input.";
	wm.TextArea.extend({scrim:true});
}
if (!dojo._hasResource["wm.base.widget.Select"]) {
	dojo._hasResource["wm.base.widget.Select"] = true;
	dojo.provide("wm.base.widget.Select");
	dojo.declare("wm.Select", wm.Box, {menuSize:"", dataField:"", constructor:function () {
	}, build:function () {
		this.domNode = document.createElement("select");
		this.renderSelect();
	}, setDomNode:function (inDomNode) {
		this.inherited(arguments);
		dojo.addClass(this.domNode, "wmselect");
	}, init:function () {
		this.inherited(arguments);
		this.connect(this.domNode, "onchange", this, "change");
		this.connect(this.domNode, "onkeyup", this, "keychange");
	}, keychange:function (inEvent) {
		if (dojo.isMoz && (inEvent.keyCode == dojo.keys.UP_ARROW || inEvent.keyCode == dojo.keys.DOWN_ARROW)) {
			this.change();
		}
	}, change:function () {
		if (this.inputValue != this.getNodeValue()) {
			this.setValue("inputValue", this.getNodeValue());
		}
		this.onchange(this.getInputValue());
	}, clearOptions:function () {
		this._data = [];
		this.domNode.options.length = 0;
	}, createOption:function (inValue) {
		this._data.push(inValue);
		this.domNode.options[this.domNode.options.length] = new Option(inValue, inValue);
	}, _setOptionData:function (inOptionData) {
		this.clearOptions();
		dojo.forEach(inOptionData, dojo.hitch(this, function (r) {
			this.createOption(r);
		}));
	}, setOptionData:function (inOptionData) {
		this._setOptionData(inOptionData);
		this.change();
	}, setMenuSize:function (inMenuSize) {
		this.menuSize = inMenuSize;
		if (this.menuSize) {
			this.domNode.size = this.menuSize;
		}
	}, getInputValue:function () {
		return this.inputValue = this.getNodeValue();
	}, getNodeValue:function () {
		var s = this.domNode, i = s.selectedIndex;
		return i >= 0 ? s.options[i].value : null;
	}, getSelectedIndex:function () {
		return this.domNode.selectedIndex;
	}, setSelectedIndex:function (inIndex) {
		this.domNode.selectedIndex = inIndex;
	}, setInputValue:function (inValue) {
		for (var i = 0, d; (d = this._data[i]); i++) {
			if (inValue == d) {
				this.inputValue = inValue;
				this.setSelectedIndex(i);
				return;
			}
		}
	}, onchange:function (inValue) {
	}, getDataField:function () {
		return this.dataField;
	}, setDataField:function (inDataField) {
		this.dataField = inDataField;
		this.renderSelect();
	}, _getFirstDataField:function () {
		if (!this.dataSet) {
			return;
		}
		var schema = this.dataSet._dataSchema;
		for (var i in schema) {
			var ti = schema[i];
			if (!ti.isList && !ti.isObject) {
				return i;
			}
		}
	}, _getData:function () {
		var data = [], dataSet = this.dataSet, f = this.dataField || this._getFirstDataField(), l = dataSet && dataSet.data.list, count = l && l.length || 0;
		for (var i = 0, d; (i < count) && (d = dataSet.getItem(i)); i++) {
			data.push(f ? d.getValue(f) : d);
		}
		return data;
	}, setDataSet:function (inDataSet) {
		this.dataSet = inDataSet;
		this.renderSelect();
	}, renderSelect:function () {
		this.setMenuSize(this.menuSize);
		if (this.dataSet) {
			this.setOptionData(this._getData());
		}
	}});
	wm.Object.extendSchema(wm.Select, {inputValue:{bindSource:1, type:"String"}, dataSet:{bindTarget:1, type:"wm.Variable"}});
	wm.Select.description = "A menu of items.";
	wm.Select.extend({scrim:true, _addFields:function (inList, inSchema, inName) {
		if (!inSchema) {
			return;
		}
		var p = inName ? inName + "." : "";
		for (var i in inSchema) {
			var ti = inSchema[i], n = p + i;
			if (!ti.isList && !ti.isObject) {
				inList.push(n);
			}
		}
	}, _listFields:function (inList, inSchema, inName) {
		var list = [""];
		if (this.dataSet) {
			this._addFields(list, this.dataSet._dataSchema, "");
		}
		return list;
	}, makePropEdit:function (inName, inValue, inDefault) {
		switch (inName) {
		  case "dataField":
			return makeSelectPropEdit(inName, inValue, this._listFields(), inDefault);
		}
		return this.inherited(arguments);
	}});
}
if (!dojo._hasResource["wm.base.widget.LayoutBox"]) {
	dojo._hasResource["wm.base.widget.LayoutBox"] = true;
	dojo.provide("wm.base.widget.LayoutBox");
	wm.LayoutBox = wm.Layout;
}
if (!dojo._hasResource["wm.base.widget.Scrim"]) {
	dojo._hasResource["wm.base.widget.Scrim"] = true;
	dojo.provide("wm.base.widget.Scrim");
	dojo.declare("wm.Scrim", wm.Widget, {showing:false, waitCursor:true, init:function () {
		if (this.owner && this.owner.isDesignedComponent()) {
			studio.designer.domNode.appendChild(this.domNode);
		} else {
			document.body.appendChild(this.domNode);
		}
		this.inherited(arguments);
		dojo.addClass(this.domNode, "wmscrim");
		this.domNode.style.zIndex = 10;
		this.domNode.style.position = "absolute";
		if (this.waitCursor) {
			this.domNode.style.cursor = "wait";
		}
	}, reflowParent:function () {
		dojo.marginBox(this.domNode, dojo.contentBox(this.domNode.parentNode));
	}, scrimify:function () {
		var f = dojo.hitch.apply(dojo, arguments);
		this.setShowing(true);
		try {
			f();
		}
		finally {
			this.setShowing(false);
		}
	}, scrimOnIdle:function () {
		this.setShowing(true);
		var self = this, args = arguments;
		setTimeout(function () {
			self.scrimify.apply(self, args);
		}, 100);
	}, setShowing:function (inShowing) {
		this.inherited(arguments);
	}, scrimifyDeferred:function (inDeferred) {
		this.setShowing(true);
		inDeferred.addCallback(dojo.hitch(this, this.setShowing, false));
	}});
}
if (!dojo._hasResource["dojox.widget.ColorPicker"]) {
	dojo._hasResource["dojox.widget.ColorPicker"] = true;
	dojo.provide("dojox.widget.ColorPicker");
	dojo.experimental("dojox.widget.ColorPicker");
	(function (d) {
		var webSafeFromHex = function (hex) {
			return hex;
		};
		dojo.declare("dojox.widget.ColorPicker", dijit.form._FormWidget, {showRgb:true, showHsv:true, showHex:true, webSafe:true, animatePoint:true, slideDuration:250, liveUpdate:false, PICKER_HUE_H:150, PICKER_SAT_VAL_H:150, PICKER_SAT_VAL_W:150, value:"#ffffff", _underlay:d.moduleUrl("dojox.widget", "ColorPicker/images/underlay.png"), templateString:dojo.cache("dojox.widget", "ColorPicker/ColorPicker.html", "<div class=\"dojoxColorPicker\" dojoAttachEvent=\"onkeypress: _handleKey\">\r\n\t<div class=\"dojoxColorPickerBox\">\r\n\t\t<div dojoAttachPoint=\"cursorNode\" tabIndex=\"0\" class=\"dojoxColorPickerPoint\"></div>\r\n\t\t<img dojoAttachPoint=\"colorUnderlay\" dojoAttachEvent=\"onclick: _setPoint\" class=\"dojoxColorPickerUnderlay\" src=\"${_underlay}\">\r\n\t</div>\r\n\t<div class=\"dojoxHuePicker\">\r\n\t\t<div dojoAttachPoint=\"hueCursorNode\" tabIndex=\"0\" class=\"dojoxHuePickerPoint\"></div>\r\n\t\t<div dojoAttachPoint=\"hueNode\" class=\"dojoxHuePickerUnderlay\" dojoAttachEvent=\"onclick: _setHuePoint\"></div>\r\n\t</div>\r\n\t<div dojoAttachPoint=\"previewNode\" class=\"dojoxColorPickerPreview\"></div>\r\n\t<div dojoAttachPoint=\"safePreviewNode\" class=\"dojoxColorPickerWebSafePreview\"></div>\r\n\t<div class=\"dojoxColorPickerOptional\" dojoAttachEvent=\"onchange: _colorInputChange\">\r\n\t\t<div class=\"dijitInline dojoxColorPickerRgb\" dojoAttachPoint=\"rgbNode\">\r\n\t\t\t<table>\r\n\t\t\t<tr><td>${redLabel}</td><td><input dojoAttachPoint=\"Rval\" size=\"1\"></td></tr>\r\n\t\t\t<tr><td>${greenLabel}</td><td><input dojoAttachPoint=\"Gval\" size=\"1\"></td></tr>\r\n\t\t\t<tr><td>${blueLabel}</td><td><input dojoAttachPoint=\"Bval\" size=\"1\"></td></tr>\r\n\t\t\t</table>\r\n\t\t</div>\r\n\t\t<div class=\"dijitInline dojoxColorPickerHsv\" dojoAttachPoint=\"hsvNode\">\r\n\t\t\t<table>\r\n\t\t\t<tr><td>${hueLabel}</td><td><input dojoAttachPoint=\"Hval\"size=\"1\"> ${degLabel}</td></tr>\r\n\t\t\t<tr><td>${saturationLabel}</td><td><input dojoAttachPoint=\"Sval\" size=\"1\"> ${percentSign}</td></tr>\r\n\t\t\t<tr><td>${valueLabel}</td><td><input dojoAttachPoint=\"Vval\" size=\"1\"> ${percentSign}</td></tr>\r\n\t\t\t</table>\r\n\t\t</div>\r\n\t\t<div class=\"dojoxColorPickerHex\" dojoAttachPoint=\"hexNode\">\t\r\n\t\t\t${hexLabel}: <input dojoAttachPoint=\"hexCode, focusNode, valueNode\" size=\"6\" class=\"dojoxColorPickerHexCode\">\r\n\t\t</div>\r\n\t</div>\r\n</div>\r\n"), postMixInProperties:function () {
			dojo.mixin(this, dojo.i18n.getLocalization("dojox.widget", "ColorPicker"));
			dojo.mixin(this, dojo.i18n.getLocalization("dojo.cldr", "number"));
			this.inherited(arguments);
		}, postCreate:function () {
			this.inherited(arguments);
			if (d.isIE < 7) {
				this.colorUnderlay.style.filter = "progid:DXImageTransform.Microsoft.AlphaImageLoader(src='" + this._underlay + "', sizingMethod='scale')";
				this.colorUnderlay.src = this._blankGif.toString();
			}
			if (!this.showRgb) {
				this.rgbNode.style.display = "none";
			}
			if (!this.showHsv) {
				this.hsvNode.style.display = "none";
			}
			if (!this.showHex) {
				this.hexNode.style.display = "none";
			}
			if (!this.webSafe) {
				this.safePreviewNode.style.visibility = "hidden";
			}
			this._offset = 0;
			var cmb = d.marginBox(this.cursorNode);
			var hmb = d.marginBox(this.hueCursorNode);
			this._shift = {hue:{x:Math.round(hmb.w / 2) - 1, y:Math.round(hmb.h / 2) - 1}, picker:{x:Math.floor(cmb.w / 2), y:Math.floor(cmb.h / 2)}};
			this.PICKER_HUE_H = d.coords(this.hueNode).h;
			var cu = d.coords(this.colorUnderlay);
			this.PICKER_SAT_VAL_H = cu.h;
			this.PICKER_SAT_VAL_W = cu.w;
			var ox = this._shift.picker.x;
			var oy = this._shift.picker.y;
			this._mover = new d.dnd.move.boxConstrainedMoveable(this.cursorNode, {box:{t:0 - oy, l:0 - ox, w:this.PICKER_SAT_VAL_W, h:this.PICKER_SAT_VAL_H}});
			this._hueMover = new d.dnd.move.boxConstrainedMoveable(this.hueCursorNode, {box:{t:0 - this._shift.hue.y, l:0, w:0, h:this.PICKER_HUE_H}});
			d.subscribe("/dnd/move/stop", d.hitch(this, "_clearTimer"));
			d.subscribe("/dnd/move/start", d.hitch(this, "_setTimer"));
		}, startup:function () {
			this._started = true;
			this.attr("value", this.value);
		}, _setValueAttr:function (value) {
			if (!this._started) {
				return;
			}
			this.setColor(value, true);
		}, setColor:function (color, force) {
			var col = dojox.color.fromString(color);
			this._updatePickerLocations(col);
			this._updateColorInputs(col);
			this._updateValue(col, force);
		}, _setTimer:function (mover) {
			dijit.focus(mover.node);
			d.setSelectable(this.domNode, false);
			this._timer = setInterval(d.hitch(this, "_updateColor"), 45);
		}, _clearTimer:function (mover) {
			clearInterval(this._timer);
			this._timer = null;
			this.onChange(this.value);
			d.setSelectable(this.domNode, true);
		}, _setHue:function (h) {
			d.style(this.colorUnderlay, "backgroundColor", dojox.color.fromHsv(h, 100, 100).toHex());
		}, _updateColor:function () {
			var _huetop = d.style(this.hueCursorNode, "top") + this._shift.hue.y, _pickertop = d.style(this.cursorNode, "top") + this._shift.picker.y, _pickerleft = d.style(this.cursorNode, "left") + this._shift.picker.x, h = Math.round(360 - (_huetop / this.PICKER_HUE_H * 360)), col = dojox.color.fromHsv(h, _pickerleft / this.PICKER_SAT_VAL_W * 100, 100 - (_pickertop / this.PICKER_SAT_VAL_H * 100));
			this._updateColorInputs(col);
			this._updateValue(col, true);
			if (h != this._hue) {
				this._setHue(h);
			}
		}, _colorInputChange:function (e) {
			var col, hasit = false;
			switch (e.target) {
			  case this.hexCode:
				col = dojox.color.fromString(e.target.value);
				hasit = true;
				break;
			  case this.Rval:
			  case this.Gval:
			  case this.Bval:
				col = dojox.color.fromArray([this.Rval.value, this.Gval.value, this.Bval.value]);
				hasit = true;
				break;
			  case this.Hval:
			  case this.Sval:
			  case this.Vval:
				col = dojox.color.fromHsv(this.Hval.value, this.Sval.value, this.Vval.value);
				hasit = true;
				break;
			}
			if (hasit) {
				this._updatePickerLocations(col);
				this._updateColorInputs(col);
				this._updateValue(col, true);
			}
		}, _updateValue:function (col, fireChange) {
			var hex = col.toHex();
			this.value = this.valueNode.value = hex;
			if (fireChange && (!this._timer || this.liveUpdate)) {
				this.onChange(hex);
			}
		}, _updatePickerLocations:function (col) {
			var hsv = col.toHsv(), ypos = Math.round(this.PICKER_HUE_H - hsv.h / 360 * this.PICKER_HUE_H - this._shift.hue.y), newLeft = Math.round(hsv.s / 100 * this.PICKER_SAT_VAL_W - this._shift.picker.x), newTop = Math.round(this.PICKER_SAT_VAL_H - hsv.v / 100 * this.PICKER_SAT_VAL_H - this._shift.picker.y);
			if (this.animatePoint) {
				d.fx.slideTo({node:this.hueCursorNode, duration:this.slideDuration, top:ypos, left:0}).play();
				d.fx.slideTo({node:this.cursorNode, duration:this.slideDuration, top:newTop, left:newLeft}).play();
			} else {
				d.style(this.hueCursorNode, "top", ypos + "px");
				d.style(this.cursorNode, {left:newLeft + "px", top:newTop + "px"});
			}
			if (hsv.h != this._hue) {
				this._setHue(hsv.h);
			}
		}, _updateColorInputs:function (col) {
			var hex = col.toHex();
			if (this.showRgb) {
				this.Rval.value = col.r;
				this.Gval.value = col.g;
				this.Bval.value = col.b;
			}
			if (this.showHsv) {
				var hsv = col.toHsv();
				this.Hval.value = Math.round((hsv.h));
				this.Sval.value = Math.round(hsv.s);
				this.Vval.value = Math.round(hsv.v);
			}
			if (this.showHex) {
				this.hexCode.value = hex;
			}
			this.previewNode.style.backgroundColor = hex;
			if (this.webSafe) {
				this.safePreviewNode.style.backgroundColor = webSafeFromHex(hex);
			}
		}, _setHuePoint:function (evt) {
			var ypos = evt.layerY - this._shift.hue.y;
			if (this.animatePoint) {
				d.fx.slideTo({node:this.hueCursorNode, duration:this.slideDuration, top:ypos, left:0, onEnd:d.hitch(this, "_updateColor", true)}).play();
			} else {
				d.style(this.hueCursorNode, "top", ypos + "px");
				this._updateColor(false);
			}
		}, _setPoint:function (evt) {
			var newTop = evt.layerY - this._shift.picker.y, newLeft = evt.layerX - this._shift.picker.x;
			if (evt) {
				dijit.focus(evt.target);
			}
			if (this.animatePoint) {
				d.fx.slideTo({node:this.cursorNode, duration:this.slideDuration, top:newTop, left:newLeft, onEnd:d.hitch(this, "_updateColor", true)}).play();
			} else {
				d.style(this.cursorNode, {left:newLeft + "px", top:newTop + "px"});
				this._updateColor(false);
			}
		}, _handleKey:function (e) {
		}});
	})(dojo);
}
if (!dojo._hasResource["wm.base.widget.Dialog"]) {
	dojo._hasResource["wm.base.widget.Dialog"] = true;
	dojo.provide("wm.base.widget.Dialog");
	wm.dialog = {showingList:[]};
	wm.dialog.getNextZIndex = function () {
		var index = 30;
		for (var i = 0; i < wm.dialog.showingList.length; i++) {
			index = Math.max(index, wm.dialog.showingList[i].domNode.style.zIndex);
		}
		return index + 1;
	};
	wm.dismiss = function (inWidget, inWhy) {
		var o = inWidget;
		while (o && !dojo.isFunction(o.dismiss)) {
			o = o.owner;
		}
		wm.fire(o, "dismiss", [inWhy]);
	};
	wm.bgIframe = {create:function () {
		var html = ["<iframe src='javascript:\"\"'", " style='position: absolute; left: 0px; top: 0px;", " z-index: 2; filter:Alpha(Opacity=\"0\");'>"].join(""), f = this.domNode = dojo.isIE ? document.createElement(html) : document.createElement("IFRAME");
		document.body.appendChild(f);
		f.style.display = "none";
		if (dojo.isMoz) {
			f.style.position = "absolute";
			f.style.left = f.style.top = "0px";
			f.style.opacity = 0;
			f.style.zIndex = 2;
		}
		dojo.subscribe("window-resize", this, "size");
	}, setShowing:function (inShowing, forceChange) {
		if (!this.domNode) {
			return;
		}
		if (forceChange || inShowing != this.showing) {
			this.domNode.style.display = inShowing ? "" : "none";
			this.showing = inShowing;
		}
		if (inShowing) {
			this.size();
		}
	}, size:function (inNode) {
		if (!this.domNode || !this.showing) {
			return;
		}
		if (inNode) {
			this.sizeNode = inNode;
		}
		var sizeNode = this.sizeNode || document.body;
		dojo.marginBox(this.domNode, dojo.contentBox(sizeNode));
	}};
	dojo.addOnLoad(function () {
		if ((dojo.isIE && dojo.isIE < 7) || (dojo.isMoz && dojo.isMoz < 6 && navigator.userAgent.indexOf("Macintosh") != -1)) {
			wm.bgIframe.create();
		}
	});
	dojo.declare("wm.Dialog", wm.Container, {containerClass:"MainContent", corner:"cc", scrim:true, useContainerWidget:false, useButtonBar:true, _minified:false, _maxified:false, noEscape:false, layoutKind:"top-to-bottom", horizontalAlign:"left", verticalAlign:"top", border:2, borderColor:"rgb(80,80,80)", titlebarBorder:"1", titlebarBorderColor:"black", titlebarHeight:"23", margin:"3", width:"640px", height:"400px", showing:false, dialogScrim:null, modal:true, init:function () {
		this.inherited(arguments);
		this.dialogScrim = new wm.Scrim({owner:this, _classes:{domNode:["wmdialog-scrim"]}, waitCursor:false});
		this.createTitle();
	}, postInit:function () {
		this.inherited(arguments);
		if (this.isDesignedComponent()) {
			studio.designer.domNode.appendChild(this.domNode);
		} else {
			document.body.appendChild(this.domNode);
		}
		dojo.addClass(this.domNode, "wmdialog");
		this.domNode.style.position = "absolute";
		this.domNode.style.zIndex = wm.dialog.getNextZIndex();
		this.domNode.style.display = "none";
		this._connections.push(this.connect(document, "onkeypress", this, "keyPress"));
		this._subscriptions.push(dojo.subscribe("window-resize", this, "reflow"));
		var containerWidget, containerNode;
		if (this.$.containerWidget) {
			this.containerWidget = this.$.containerWidget;
		}
		var owner = (this.declaredClass == "wm.Dialog" || this instanceof wm.DesignableDialog) ? this.owner : this;
		if (this.useContainerWidget) {
			if (!this.containerWidget) {
				for (var i = 0; i < this.c$.length; i++) {
					if (this.c$[i].name.match(/containerWidget/)) {
						this.containerWidget = this.c$[i];
						break;
					}
				}
			}
			containerWidget = this.containerWidget || new wm.Container({_classes:{domNode:["wmdialogcontainer", this.containerClass]}, name:owner.getUniqueName("containerWidget"), parent:this, owner:owner, layoutKind:"top-to-bottom", padding:"5", fitToContentHeight:this.fitToContentHeight, margin:"0", border:"0", width:"100%", height:"100%", horizontalAlign:"left", verticalAlign:"top", autoScroll:true});
			containerNode = containerWidget.domNode;
		} else {
			containerNode = this.domNode;
		}
		this.setModal(this.modal);
		this.setTitlebarBorder(this.titlebarBorder);
		this.setTitlebarBorderColor(this.titlebarBorderColor);
		if (this.useButtonBar) {
			if (this.$.buttonBar) {
				this.buttonBar = this.$.buttonBar;
			} else {
				if (this.useContainerWidget) {
					this.buttonBar = new wm.Panel({_classes:{domNode:["dialogfooter"]}, name:"buttonBar", owner:owner, parent:this, width:"100%", height:"0px", fitToContentHeight:true, minHeight:(this.isDesignLoaded()) ? 5 : 1, horizontalAlign:"right", verticalAlign:"top", layoutKind:"left-to-right", border:this.footerBorder + ",0,0,0", borderColor:this.titlebarBorderColor});
				}
			}
		}
		if (containerWidget) {
			this.containerWidget = containerWidget;
		}
		this.containerNode = containerNode;
	}, setTitlebarBorder:function (inBorder) {
		this.titlebarBorder = inBorder;
		var border = (String(inBorder).match(",")) ? inBorder : "0,0," + inBorder + ",0";
		this.titleBar.setBorder(border);
		this.titleBar.setHeight((parseInt(this.titlebarHeight) + this.titleBar.padBorderMargin.t + this.titleBar.padBorderMargin.b) + "px");
	}, setTitlebarBorderColor:function (inBorderColor) {
		this.titlebarBorderColor = inBorderColor;
		this.titleBar.setBorderColor(inBorderColor);
	}, setFooterBorder:function (inBorder) {
		this.footerBorder = inBorder;
		if (this.$.buttonBar) {
			this.$.buttonBar.setBorder(inBorder + ",0,0,0");
		}
	}, setFooterBorderColor:function (inBorderColor) {
		this.footerBorderColor = inBorderColor;
		if (this.$.buttonBar) {
			this.$.buttonBar.setBorderColor(inBorderColor);
		}
	}, setModal:function (inModal) {
		dojo[inModal ? "removeClass" : "addClass"](this.domNode, "nonmodaldialog");
		this.modal = (inModal === undefined || inModal === null) ? true : inModal;
		if (this.dojoMoveable) {
			this.dojoMoveable.destroy();
			this.dojoMoveable = null;
		}
		if (!inModal) {
			this.dojoMoveable = new dojo.dnd.Moveable(this.domNode, {handle:this.titleLabel.domNode});
		}
		if (this.showing) {
			this.dialogScrim.setShowing(this.modal);
			wm.bgIframe.setShowing(!this.modal && !this.isDesignedComponent());
		}
		this.titleClose.setShowing(!this.modal && !this.noEscape);
		this.titleMinify.setShowing(!this.modal);
		this.titleMaxify.setShowing(!this.modal);
	}, setNoEscape:function (inNoEscape) {
		this.noEscape = inNoEscape;
		this.titleClose.setShowing(!this.modal && !this.noEscape);
	}, minify:function () {
		this._minified = true;
		this.setShowing(false);
		if (!app.wmMinifiedDialogPanel) {
			app.createMinifiedDialogPanel();
		}
		this.minifiedLabel = app.createMinifiedDialogLabel(this.title);
		this.minifiedLabel.connect(this.minifiedLabel, "onclick", this, function () {
			app.removeMinifiedDialogLabel(this.minifiedLabel);
			delete this.minifiedLabel;
			app.wmMinifiedDialogPanel.reflow();
			this._minified = false;
			this.setShowing(true);
		});
		app.wmMinifiedDialogPanel.reflow();
	}, unminifyormove:function (inEvent) {
		this._unminifyMouseX = inEvent.x;
		this._unminifyMouseY = inEvent.y;
	}, unminify:function (inEvent, dontCallSetShowing) {
		if (!this._minified) {
			return;
		}
		app.removeMinifiedDialogLabel(this.minifiedLabel);
		delete this.minifiedLabel;
		app.wmMinifiedDialogPanel.reflow();
		this._minified = false;
		if (!dontCallSetShowing) {
			this.show();
		}
	}, maxify:function () {
		if (this._maxified) {
			this._maxified = false;
			this.bounds.h = parseInt(this.height);
			this.bounds.w = parseInt(this.width);
		} else {
			this._maxified = true;
		}
		this.renderBounds();
		this.reflow();
	}, reflowParent:function () {
	}, dismiss:function (e) {
		this.setShowing(false, false, true);
		var why = "" || dojo.isString(e) ? e : e && e.target && e.target.innerHTML;
		this.onClose(why);
		why = null;
	}, destroy:function () {
		this.dismiss();
		if (this.dialogScrim) {
			this.dialogScrim.destroy();
		}
		if (this.minifiedLabel) {
			this.minfiedLabel.destroy();
		}
		this.inherited(arguments);
	}, flow:function () {
		if (this.showing) {
			this.renderBounds();
			this.inherited(arguments);
			this.dialogScrim.reflowParent();
		}
	}, renderBounds:function () {
		if (this.showing) {
			if (this.fitToContentHeight) {
				this.bounds.h = this.getPreferredFitToContentHeight();
			}
			if (this._minified) {
				var parentBox = dojo.contentBox(window.document.body);
				var t = parentBox.h - 30;
				var l = parentBox.w - 200;
				this.setBounds(l, t, 200, 30);
			} else {
				if (this._maxified) {
					var parentBox = dojo.contentBox(window.document.body);
					this.setBounds(20, 20, parentBox.w - 40, parentBox.h - 40);
				} else {
					if (!this._fixPosition) {
						this.renderBoundsByCorner();
					} else {
						this.insureDialogVisible();
					}
					wm.bgIframe.size();
				}
			}
			return this.inherited(arguments);
		}
	}, setCorner:function (inCorner) {
		this.corner = inCorner.replace(/top/, "t").replace(/bottom/, "b").replace(/left/, "l").replace(/right/, "r").replace(/center/, "c").replace(/ /, "");
		this.renderBoundsByCorner();
	}, insureDialogVisible:function () {
		if (!this.showing) {
			return;
		}
		var w = this.bounds.w;
		var h = this.bounds.h;
		var isDesigned = (this.domNode.parentNode != document.body);
		var W = (isDesigned) ? studio.designer.bounds.w : app._page.root.bounds.w;
		var H = (isDesigned) ? studio.designer.bounds.h : app._page.root.bounds.h;
		if (this.bounds.t + this.bounds.h > H) {
			this.bounds.t = H - this.bounds.h;
		}
		if (this.bounds.l + this.bounds.w > W) {
			this.bounds.l = W - this.bounds.w;
		}
		if (this.bounds.t < 0) {
			this.bounds.t = 0;
		}
		if (this.bounds.l < 0) {
			this.bounds.l = 0;
		}
		wm.Control.prototype.renderBounds.call(this);
	}, renderBoundsByCorner:function () {
		if (!this.showing) {
			return;
		}
		var w = this.bounds.w;
		var h = this.bounds.h;
		var W = this.domNode.parentNode.clientWidth;
		var H = this.domNode.parentNode.clientHeight;
		var buffer = 10;
		var t, l;
		var top = this.corner.substring(0, 1);
		var left = this.corner.substring(1, 2);
		for (var i = wm.dialog.showingList.length - 1; i >= 0 && wm.dialog.showingList[i] == this; i--) {
		}
		var last = (i >= 0 && (!window["studio"] || this != window["studio"].dialog)) ? wm.dialog.showingList[i] : null;
		switch (left) {
		  case "l":
			l = buffer;
			break;
		  case "r":
			l = W - w - buffer;
			break;
		  case "c":
			if (last && last.corner == this.corner) {
				l = last.bounds.l + 15;
			} else {
				l = Math.floor((W - w) / 2);
			}
			break;
		}
		switch (top) {
		  case "t":
			t = buffer;
			break;
		  case "b":
			t = H - h - buffer;
			break;
		  case "c":
			if (last && last.corner == this.corner) {
				t = last.bounds.t + 15;
			} else {
				t = Math.floor((H - h) / 2);
			}
			break;
		}
		this.setBounds(l, t, w, h);
		wm.Control.prototype.renderBounds.call(this);
	}, setContent:function (inContent) {
		this.containerNode.innerHTML = inContent;
	}, setShowing:function (inShowing, forceChange, skipOnClose) {
		if (inShowing != this.showing && this.modal) {
			this.dialogScrim.setShowing(inShowing);
		}
		this.inherited(arguments);
		wm.Array.removeElement(wm.dialog.showingList, this);
		if (inShowing && (!window["studio"] || this != window["studio"].dialog)) {
			wm.dialog.showingList.push(this);
			this.domNode.style.zIndex = wm.dialog.getNextZIndex();
		}
		if (this.showing) {
			if (this._minified) {
				this.unminify(null, true);
			}
			this.reflow();
		}
		wm.bgIframe.setShowing(inShowing && this.modal && !this.isDesignedComponent());
		if (this.showing) {
			this.onShow();
		} else {
			if (!skipOnClose) {
				this.onClose("");
			}
		}
		if (this.designWrapper) {
			this.designWrapper.setShowing(inShowing);
		}
	}, keyPress:function (inEvent) {
		if (!this.showing) {
			return true;
		}
		var dialogs = dojo.query(".wmdialog");
		var zindex = parseInt(this.domNode.style.zIndex);
		for (var i = 0; i < dialogs.length; i++) {
			if (dialogs[i].style.display != "none" && parseInt(dialogs[i].style.zIndex) > zindex) {
				return true;
			}
		}
		if (inEvent.keyCode == dojo.keys.ESCAPE && !this.noEscape) {
			if (this.showing) {
				this.setShowing(false);
				this.onClose("cancel");
			}
		} else {
			if (inEvent.keyCode == dojo.keys.ENTER) {
				if (this.$.textInput && this.$.textInput.getDataValue) {
					this.onEnterKeyPress(this.$.textInput.getDataValue());
				} else {
					this.onEnterKeyPress();
				}
			}
		}
		return true;
	}, onEnterKeyPress:function (inText) {
	}, onShow:function () {
	}, onClose:function (inWhy) {
	}, setTitlebarHeight:function (inHeight) {
		this.titlebarHeight = inHeight;
		if (this.titleBar) {
			this.titleBar.setHeight(inHeight + "px");
		}
	}, createTitle:function () {
		this.titleBar = new wm.Container({_classes:{domNode:["dialogtitlebar"]}, noInspector:true, showing:this.title, name:"titleBar", parent:this, owner:this, width:"100%", height:this.titlebarHeight + "px", margin:"0", padding:"0", border:this.titlebarBorder, borderColor:this.titlebarBorderColor, verticalAlign:"middle", layoutKind:"left-to-right"});
		this.titleClose = new wm.Picture({_classes:{domNode:["dialogclosebutton"]}, source:"/wavemaker/lib/wm/base/widget/themes/default/images/blank.gif", noInspector:true, name:"titleClose", width:"22px", height:"19px", margin:"3,3,0,3", parent:this.titleBar, owner:this, showing:!this.modal && !this.noEscape});
		this.titleMinify = new wm.Picture({_classes:{domNode:["dialogminifybutton"]}, noInspector:true, source:"/wavemaker/lib/wm/base/widget/themes/default/images/blank.gif", name:"titleMinify", width:"19px", height:"19px", margin:"3,3,0,0", parent:this.titleBar, owner:this, showing:!this.modal});
		this.titleMaxify = new wm.Picture({_classes:{domNode:["dialogmaxifybutton"]}, noInspector:true, source:"/wavemaker/lib/wm/base/widget/themes/default/images/blank.gif", name:"titleMinify", caption:" ", width:"19px", height:"19px", margin:"3,3,0,0", parent:this.titleBar, owner:this, showing:!this.modal});
		this.titleLabel = new wm.Label({noInspector:true, name:"dialogTitleLabel", parent:this.titleBar, owner:this, caption:this.title, showing:Boolean(this.title), margin:"3,3,0,10", width:"100%", height:"100%"});
		this.connect(this.titleClose, "onclick", this, "dismiss");
		this.connect(this.titleMinify, "onclick", this, "minify");
		this.connect(this.titleMaxify, "onclick", this, "maxify");
		this.connect(this.titleLabel, "onclick", this, "unminify");
		this.connect(this.titleLabel.domNode, "onmousedown", this, "unminifyormove");
	}, setTitle:function (inTitle) {
		this.title = inTitle;
		if (this.titleLabel) {
			this.titleLabel.setCaption(inTitle);
			this.titleLabel.setShowing(true);
		}
		if (this.titleBar) {
			this.titleBar.setShowing(Boolean(inTitle));
		}
	}, setSizeProp:function (n, v, inMinSize) {
		this.inherited(arguments);
		this.renderBounds();
		if (this.designWrapper) {
			this.designWrapper.controlBoundsChange();
			this.designWrapper.renderBounds();
		}
		this.reflow();
	}, update:function () {
		this.show();
	}, activate:function () {
		this.show();
	}, deactivate:function () {
		this.hide();
	}});
	wm.Dialog.extend({themeableStyles:["wm.Dialog_Inner-Radius"], afterPaletteDrop:function () {
		this.inherited(arguments);
		this.setParent(null);
		studio.designer.domNode.appendChild(this.domNode);
		this.show();
	}, makePropEdit:function (inName, inValue, inDefault) {
		switch (inName) {
		  case "corner":
			inValue = inValue.replace(/^c/, "center ").replace(/^t/, "top ").replace(/^b/, "bottom ").replace(/l$/, "left").replace(/r$/, "right").replace(/c$/, "center");
			return new wm.propEdit.Select({component:this, value:inValue, name:inName, options:["top left", "top center", "top right", "center left", "center center", "center right", "bottom left", "bottom center", "bottom right"]});
		}
		return this.inherited(arguments);
	}, });
	wm.Object.extendSchema(wm.Dialog, {title:{group:"Header and Footer", order:1}, titlebarBorder:{group:"Header and Footer", order:5}, titlebarBorderColor:{group:"Header and Footer", order:6}, titlebarHeight:{group:"Header and Footer", order:7}, noEscape:{group:"Dialog Keyboard", order:1}, enterKeyIsButton1:{group:"Dialog Keyboard", order:2, ignore:1}, modal:{group:"Dialog Options", order:1}, fitToContentWidth:{ignore:1}, fitToContentHeight:{ignore:1}, useContainerWidget:{ignore:1}, useButtonBar:{ignore:1}, lock:{ignore:1}, freeze:{ignore:1}, padding:{ignore:1}, margin:{ignore:1}, scrollX:{ignore:1}, scrollY:{ignore:1}, layoutKind:{ignore:1}, horizontalAlign:{ignore:1}, verticalAlign:{ignore:1}, showing:{ignore:1}, owner:{group:"common", order:1, readonly:true, options:["Page", "Application"]}});
	dojo.declare("wm.WidgetsJsDialog", wm.Dialog, {margin:"0,4,4,0", useContainerWidget:true, useButtonBar:false, widgets_data:null, widgets_json:"", width:"400px", height:"150px", setShowing:function (inShowing, forceChange) {
		this.inherited(arguments);
		if (this.isReflowEnabled() && !this._rendered) {
			this.leafFirstRenderCss();
			this._rendered = true;
		}
	}, postInit:function () {
		this.inherited(arguments);
		if (!this.widgets_data) {
			this.setWidgetsJson(this.widgets_json);
		}
		this.generateContents();
		this.containerWidget.setPadding("0");
		this.renderBounds();
		this.reflow();
	}, setWidgetsJson:function (inJson) {
		try {
			this.widgets_json = inJson;
			this.widgets_data = dojo.fromJson(this.widgets_json);
			if (!this._cupdating) {
				this.generateContents();
			}
		}
		catch (e) {
			console.error(e);
		}
	}, generateContents:function () {
		this.containerWidget._cupdating = true;
		this.containerWidget.createComponents(this.widgets_data, this);
		this.containerWidget._cupdating = false;
		this.containerWidget.reflow();
	}});
	dojo.declare("wm.RichTextDialog", wm.WidgetsJsDialog, {autoScroll:false, noEscape:true, footerBorder:"", footerBorderColor:"", title:"Write Your Documentation", padding:"0", width:"500px", height:"500px", modal:false, html:"", prepare:function () {
		this.inherited(arguments);
		this.widgets_data = {documentation:["wm.RichText", {width:"100%", height:"100%", "toolbarAlign":false, "toolbarLink":true, "toolbarColor":true, dataValue:this.html, displayValue:this.html}, {}], buttonBar:["wm.Panel", {_classes:{domNode:["dialogfooter"]}, name:"buttonBar", layoutKind:"left-to-right", padding:"2,0,2,0", horizontalAlign:"right", height:"34px", fitToContentHeight:true, width:"100%", borderColor:this.footerBorderColor, border:this.footerBorder + ",0,0,0"}, {}, {okButton:["wm.Button", {"width":"150px", "caption":"OK"}, {"onclick":"onOkClick"}], cancelButton:["wm.Button", {"width":"150px", "caption":"Cancel"}, {"onclick":"onCancelClick"}]}]};
	}, setHtml:function (inHtml) {
		this.html = inHtml;
		if (this.$.documentation) {
			this.$.documentation.setDataValue(inHtml);
		}
	}, getHtml:function () {
		if (this.$.documentation) {
			return this.$.documentation.getDataValue();
		}
	}, onOkClick:function () {
		this.dismiss();
	}, onCancelClick:function () {
		this.dismiss();
	}, setShowing:function (inShowing) {
		this.inherited(arguments);
		if (this.$.documentation && !this.$.documentation.editor) {
			this.$.documentation.setShowing(true);
		}
	}});
	wm.Object.extendSchema(wm.RichTextDialog, {html:{group:"Dialog Options", order:2, bindable:true, simpleBindProp:true}, enterKeyIsButton1:{group:"Dialog Keyboard", order:2}, footerBorder:{group:"style", order:100}, footerBorderColor:{group:"style", order:101}});
	wm.RichTextDialog.extend({themeable:false});
	dojo.declare("wm.GenericDialog", wm.WidgetsJsDialog, {enterKeyIsButton1:true, autoScroll:false, noEscape:true, title:"Generic Dialog", footerBorder:"", footerBorderColor:"", padding:"0", regExp:".*", button1Caption:"", button2Caption:"", button3Caption:"", button4Caption:"", button1Close:false, button2Close:false, button3Close:false, button4Close:false, userPrompt:"Testing...", showInput:false, prepare:function () {
		this.inherited(arguments);
		this.widgets_data = {genericInfoPanel:["wm.Panel", {layoutKind:"top-to-bottom", width:"100%", height:"100%", horizontalAlign:"left", verticalAlign:"top", autoScroll:true, fitToContentHeight:true, padding:"10,5,10,5"}, {}, {userQuestionLabel:["wm.Html", {autoScroll:false, "height":"25px", autoSizeHeight:true, "width":"100%", html:""}], textInput:["wm.TextEditor", {"width":"100%", "captionSize":"0%", "showing":false}, {}, {editor:["wm._TextEditor", {}, {}]}]}], buttonBar:["wm.Panel", {_classes:{domNode:["dialogfooter"]}, name:"buttonBar", layoutKind:"left-to-right", padding:"2,6,2,6", horizontalAlign:"right", borderColor:this.footerBorderColor, border:this.footerBorder + ",0,0,0", fitToContentHeight:true, height:"34px", width:"100%"}, {}, {button4:["wm.Button", {"width":"130px", "showing":false}, {"onclick":"buttonClick"}], button3:["wm.Button", {"width":"130px", "showing":false}, {"onclick":"buttonClick"}], button2:["wm.Button", {"width":"130px", "showing":false}, {"onclick":"buttonClick"}], button1:["wm.Button", {"width":"130px", "showing":false}, {"onclick":"buttonClick"}]}]};
	}, postInit:function () {
		this.inherited(arguments);
		this.setFooterBorder(this.footerBorder);
		this.setFooterBorderColor(this.footerBorderColor);
		var captionFound = false;
		for (var i = 1; i <= 6; i++) {
			var caption = this["button" + i + "Caption"];
			var button = this.$["button" + i];
			if (caption) {
				captionFound = true;
				button.setCaption(caption);
				button.show();
			}
			if (this.$.buttonBar) {
				this.$.buttonBar.setShowing(captionFound);
			}
			this.setShowInput(this.showInput);
		}
		if (this.$.userQuestionLabel) {
			this.$.userQuestionLabel.setHtml(this.userPrompt);
		}
		this.containerWidget.setFitToContentHeight(true);
	}, setFooterBorder:function (inBorder) {
		this.footerBorder = inBorder;
		if (this.$.buttonBar) {
			this.$.buttonBar.setBorder(inBorder);
			this.$.buttonBar.setHeight((34 + this.$.buttonBar.padBorderMargin.t + this.$.buttonBar.padBorderMargin.b) + "px");
		}
	}, setFooterBorderColor:function (inBorderColor) {
		this.footerBorderColor = inBorderColor;
		if (this.$.buttonBar) {
			this.$.buttonBar.setBorderColor(inBorderColor);
		}
	}, reflow:function () {
		try {
			if (!this._settingHeight) {
				var height = this.getPreferredFitToContentHeight();
				this._settingHeight = true;
				this.setHeight(height + "px");
				this._settingHeight = false;
				this.inherited(arguments);
			}
		}
		catch (e) {
			this._settingHeight = false;
		}
	}, setShowing:function (inShowing, forceChange) {
		this.inherited(arguments);
		if (inShowing) {
			if (this.$.userQuestionLabel) {
				this.$.userQuestionLabel.doAutoSize(true, true);
			}
			if (this.showInput && this.$.textInput && this.$.textInput.focus) {
				this.$.textInput.focus();
			}
			wm.onidle(this, "reflow");
		}
	}, setShowInput:function (inShowInput) {
		this.showInput = inShowInput;
		if (this.$.textInput) {
			this.$.textInput.setShowing(inShowInput);
		}
	}, setInputDataValue:function (inValue) {
		if (this.$.textInput) {
			this.$.textInput.setDataValue(inValue);
		}
	}, getInputDataValue:function (inValue) {
		var result;
		if (this.$.textInput) {
			result = this.$.textInput.getDataValue();
			if (dojo.isString(result)) {
				result = dojo.trim(result);
			}
			return result;
		}
	}, setUserPrompt:function (inPrompt) {
		this.userPrompt = inPrompt;
		if (this.$.userQuestionLabel) {
			this.$.userQuestionLabel.setHtml(inPrompt);
		}
	}, setButton1Caption:function (inCap) {
		this.setButtonCaption(1, inCap);
	}, setButton2Caption:function (inCap) {
		this.setButtonCaption(2, inCap);
	}, setButton3Caption:function (inCap) {
		this.setButtonCaption(3, inCap);
	}, setButton4Caption:function (inCap) {
		this.setButtonCaption(4, inCap);
	}, setButtonCaption:function (inButtonNumber, inButtonCaption) {
		var button = this.$["button" + inButtonNumber];
		this["button" + inButtonNumber + "Caption"] = inButtonCaption;
		if (!button) {
			return;
		}
		if (inButtonCaption) {
			button.setCaption(inButtonCaption);
			button.show();
		} else {
			button.hide();
		}
		this.$.buttonBar.setShowing(this.button1Caption || this.button2Caption || this.button3Caption || this.button4Caption);
	}, onEnterKeyPress:function (inText) {
		if (this.enterKeyIsButton1) {
			if (this.button1Close) {
				this.dismiss();
			}
			this.onButton1Click(this.button1, inText);
		}
	}, buttonClick:function (inSender) {
		var name = inSender.name;
		var id = parseInt(name.match(/\d+/)[0]);
		if (this["button" + id + "Close"]) {
			this.dismiss();
		}
		var text = (this.$.textInput) ? this.$.textInput.getDataValue() : "";
		switch (id) {
		  case 1:
			this.onButton1Click(inSender, text);
			break;
		  case 2:
			this.onButton2Click(inSender, text);
			break;
		  case 3:
			this.onButton3Click(inSender, text);
			break;
		  case 4:
			this.onButton4Click(inSender, text);
			break;
		}
	}, onButton1Click:function (inButton, inText) {
	}, onButton2Click:function (inButton, inText) {
	}, onButton3Click:function (inButton, inText) {
	}, onButton4Click:function (inButton, inText) {
	}, });
	wm.Object.extendSchema(wm.GenericDialog, {enterKeyIsButton1:{group:"Dialog Keyboard", order:2}, widgets_json:{ignore:1}, button1Caption:{group:"Buttons", order:1}, button1Close:{group:"Buttons", order:2}, button2Caption:{group:"Buttons", order:3}, button2Close:{group:"Buttons", order:4}, button3Caption:{group:"Buttons", order:5}, button3Close:{group:"Buttons", order:6}, button4Caption:{group:"Buttons", order:7}, button4Close:{group:"Buttons", order:8}, footerBorder:{group:"Header and Footer", order:10}, footerBorderColor:{group:"Header and Footer", order:11}, userPrompt:{group:"Dialog Options", order:2, bindTarget:true}, showInput:{group:"Dialog Options", order:3, bindTarget:true}, inputDataValue:{group:"Dialog Options", order:4, bindable:true, simpleBindProp:true}, regExp:{group:"Dialog Options", order:4}, footerBorder:{group:"style", order:100}, footerBorderColor:{group:"style", order:101}});
	wm.GenericDialog.extend({});
	dojo.declare("wm.FileUploadDialog", wm.GenericDialog, {uploadService:"", uploadOperation:"", width:"500px", height:"120px", showInput:true, button1Caption:"アップロード", button2Caption:"キャンセル", button1Close:true, button2Close:true, postInit:function () {
		this.widgets_data.genericInfoPanel[3].textInput = ["wm.FileUpload", {caption:"", uploadButton:false, padding:"0,20,0,20", width:"100%", height:"28px", captionSize:"100px", captionAlign:"left", captionPosition:"left", uploadButtonPosition:"right", uploadButtonWidth:"100px", uploadButtonHeight:"30px", service:"", operation:""}, {onUploadSuccess:"importClickCallback", onUploadError:"importClickError", onBegin:"startImportClick"}, {}];
		this.inherited(arguments);
		this.fileUploader = this.$.textInput;
		this.setUploadService(this.uploadService);
		this.setUploadOperation(this.uploadOperation);
	}, startImportClick:function (inSender) {
		if (window["studio"]) {
			studio.beginWait("ファイルをインポートしています...");
		}
	}, importClickCallback:function (inSource, inResponse) {
		if (window["studio"]) {
			studio.endWait();
		}
		wm.fire(this.owner, "dismiss");
	}, importClickError:function (inSource, inError) {
		if (window["studio"]) {
			studio.endWait();
		}
		app.toastDialog.showToast("インポートに失敗しました！", 3000, "Warning");
	}, setUploadService:function (inService) {
		this.uploadService = inService;
		this.fileUploader.setService(inService);
	}, setUploadOperation:function (inOperation) {
		this.uploadOperation = inOperation;
		this.fileUploader.setOperation(inOperation);
	}, buttonClick:function (inSender) {
		var name = inSender.name;
		var id = parseInt(name.match(/\d+/)[0]);
		switch (id) {
		  case 1:
			this.onButton1Click(inSender);
			break;
		  case 2:
			this.onButton2Click(inSender);
			break;
		  case 3:
			this.onButton3Click(inSender);
			break;
		  case 4:
			this.onButton4Click(inSender);
			break;
		  case 5:
			this.onButton5Click(inSender);
			break;
		  case 6:
			this.onButton6Click(inSender);
			break;
		}
		if (this["button" + id + "Close"]) {
			this.dismiss();
		}
	}, onButton1Click:function (inButton) {
		this.fileUploader.upload();
	}, onButton2Click:function (inButton) {
	}, onButton3Click:function (inButton) {
	}, onButton4Click:function (inButton) {
	}, onButton5Click:function (inButton) {
	}, onButton6Click:function (inButton) {
	}});
	dojo.declare("wm.Toast", wm.WidgetsJsDialog, {classNames:"wmtoast wmtoastExtraSpecific", title:"", modal:false, useContainerWidget:true, _timeoutId:0, duration:5000, content:"Toast", height:"100px", width:"350px", corner:"br", border:"2", margin:"0", prepare:function () {
		this.inherited(arguments);
		this.widgets_data = {img:["wm.Picture", {_classes:{domNode:["ToastLeft"]}, width:"30px", height:"100%", margin:"4,0,0,4"}], rightColumn:["wm.Panel", {layoutKind:"top-to-bottom", width:"100%", height:"100%", fitToContentHeight:true, padding:"0"}, {}, {title:["wm.Label", {height:"20px", width:"100%", singleLine:true}], message:["wm.Label", {height:"100px", width:"100%", singleLine:false, autoSizeHeight:true}]}]};
	}, postInit:function () {
		this.inherited(arguments);
		this.containerWidget.setLayoutKind("left-to-right");
		this.containerWidget.setPadding("4");
		this.img = this.containerWidget.c$[0];
		this.title = this.containerWidget.c$[1].c$[0];
		this.message = this.containerWidget.c$[1].c$[1];
		this.setContent(this.content);
		this.connectEvents(this.domNode, ["click"]);
	}, click:function () {
		this.fadeaway(true);
		this.onToastClick();
	}, onToastClick:function () {
	}, setShowing:function (inShow, forceChange) {
		this.inherited(arguments);
		if (inShow) {
			this.renderBounds();
		}
	}, renderBounds:function () {
		this.renderBoundsByCorner();
	}, setContent:function (inContent) {
		this.content = inContent;
		if (this.message) {
			this.message.setCaption(inContent);
		}
	}, setTitle:function (inTitle) {
		if (this.title) {
			this.title.setCaption(inTitle);
		}
	}, showToast:function (inContent, inDuration, inCssClasses, inPosition, optionalTitle) {
		if (inPosition) {
			inPosition = inPosition.replace(/top/, "t").replace(/bottom/, "b").replace(/left/, "l").replace(/right/, "r").replace(/center/, "c").replace(/ /, "");
		}
		this.corner = inPosition || app.toastPosition || "br";
		if (this._timeoutId) {
			window.clearTimeout(this._timeoutId);
			this.hide();
			this._timeoutId = 0;
		}
		this.setTitle(optionalTitle || inCssClasses);
		inCssClasses = inCssClasses || "Info";
		var classes = (inCssClasses) ? inCssClasses.split(" ") : [];
		if (dojo.indexOf(classes, "Success") != -1) {
			this.setBorderColor("rgb(0,120,0)");
		} else {
			if (dojo.indexOf(classes, "Error") != -1) {
				this.setBorderColor("rgb(120,0,0)");
			} else {
				if (dojo.indexOf(classes, "Warning") != -1) {
					this.setBorderColor("#f9a215");
				} else {
					this.setBorderColor("rgb(0,0,0)");
				}
			}
		}
		this.message.autoSizeHeight = false;
		this.setContent(inContent);
		this.message.autoSizeHeight = true;
		this.duration = inDuration || this.duration;
		this.domNode.className = this.classNames + " " + ((inCssClasses) ? inCssClasses : "");
		this._timeoutId = window.setTimeout(dojo.hitch(this, "fadeaway"), this.duration);
		this.domNode.style.opacity = "0.01";
		this.show();
		this.message.doAutoSize(true, true);
		this.setHeight((this.containerWidget.padBorderMargin.t + this.containerWidget.padBorderMargin.b + this.message.parent.bounds.h + this.padBorderMargin.t + this.padBorderMargin.b) + "px");
		dojo.anim(this.domNode, {opacity:1}, 800);
	}, fadeaway:function (fromClick) {
		if (!this._timeoutId) {
			return;
		}
		this._timeoutId = 0;
		if (fromClick) {
			dojo.anim(this.domNode, {opacity:0}, 200, null, dojo.hitch(this, function () {
				this.hide();
				this.domNode.style.opacity = 1;
			}));
		} else {
			dojo.anim(this.domNode, {opacity:0.01}, 500, null, dojo.hitch(this, function () {
				this.hide();
			}));
		}
	}, update:function () {
		this.showToast(this.content, this.duration, this.domNode.className);
	}});
	dojo.declare("wm.ToastFirstDraft", wm.Dialog, {classNames:"wmtoast wmtoastExtraSpecific", title:"", modal:false, useContainerWidget:true, _timeoutId:0, duration:5000, content:"Toast", height:"50px", border:"0,0,5,0", margin:"0", init:function () {
		this.inherited(arguments);
		this.containerWidget.setPadding("2,20,2,20");
		this.setContent(this.content);
		this.connectEvents(this.domNode, ["click"]);
	}, click:function () {
		this.fadeaway(true);
		this.onToastClick();
	}, onToastClick:function () {
	}, postInit:function () {
		this.inherited(arguments);
		this.containerWidget.setHeight("100px");
		this.containerWidget.renderCss();
	}, renderBounds:function () {
		if (this.showing) {
			var t = 0;
			var l = 0;
			var coords = dojo.coords(app.domNode);
			this.setBounds(l, t, coords.w, this.height);
			this.domNode.style.top = t + "px";
			this.domNode.style.left = l + "px";
			this.domNode.style.width = coords.w + "px";
			this.domNode.style.height = this.height;
			wm.Control.prototype.renderBounds.call(this);
		}
	}, setContent:function (inContent) {
		this.inherited(arguments);
		this.content = inContent;
	}, showToast:function (inContent, inDuration, inCssClasses) {
		if (this._timeoutId) {
			window.clearTimeout(this._timeoutId);
			this.hide();
			this._timeoutId = 0;
		}
		inCssClasses = inCssClasses || "Info";
		var classes = (inCssClasses) ? inCssClasses.split(" ") : [];
		if (dojo.indexOf(classes, "Success") != -1) {
			this.setBorderColor("rgb(0,120,0)");
		} else {
			if (dojo.indexOf(classes, "Warning") != -1) {
				this.setBorderColor("rgb(120,0,0)");
			} else {
				this.setBorderColor("rgb(0,0,0)");
			}
		}
		if (!inContent || !inContent.match(/\<img/)) {
			inContent = "<img src='" + wm.theme.getImagesPath() + "blank.gif' class='ToastLeft'/>" + inContent;
		}
		this.toastHeight = parseInt(this.height);
		this.setContent(inContent);
		this.duration = inDuration || this.duration;
		this.domNode.className = this.classNames + " " + ((inCssClasses) ? inCssClasses : "");
		this._timeoutId = window.setTimeout(dojo.hitch(this, "fadeaway"), this.duration);
		this.show();
		this.domNode.style.height = "1px";
		dojo.anim(this.domNode, {height:parseInt(this.height)}, 400);
	}, fadeaway:function (fromClick) {
		if (!this._timeoutId) {
			return;
		}
		this._timeoutId = 0;
		if (fromClick) {
			dojo.anim(this.domNode, {opacity:0}, 200, null, dojo.hitch(this, function () {
				this.hide();
				this.domNode.style.opacity = 1;
			}));
		} else {
			dojo.anim(this.domNode, {height:0}, 800, null, dojo.hitch(this, function () {
				this.hide();
			}));
		}
	}, update:function () {
		this.showToast(this.content, this.duration, this.domNode.className);
	}});
	wm.Object.extendSchema(wm.Toast, {modal:{ignore:1}, backgroundColor:{}});
	wm.Toast.classList = ["wm_FontSizePx_16px", "wm_TextDecoration_Bold"];
	dojo.declare("wm.pageContainerMixin", null, {pageName:"", hideControls:false, pageProperties:null, initPageContainer:function () {
		this.pageContainer = new wm.PageContainer({loadParentFirst:false, parent:this, owner:this, flex:1, pageProperties:this.pageProperties});
		this._connections.push(this.connect(this.pageContainer, "onPageChanged", this, "_pageChanged"));
		this.pageContainer.dismiss = dojo.hitch(this, "dismiss");
		if (this.pageName) {
			this.setPage(this.pageName);
		}
		this.createControls();
	}, setPage:function (inPageName) {
		if (inPageName) {
			if (this.pageContainer.pageName != inPageName) {
				if (this.page) {
					this.page.root.hide();
				}
				this.pageContainer.setPageName(inPageName);
			} else {
				this.onPageReady();
			}
		}
	}, showPage:function (inPageName, inHideControls, inWidth, inHeight, inTitle, inModal) {
		if (inTitle !== undefined) {
			this.setTitle(inTitle);
		}
		if (inModal !== undefined) {
			this.setModal(inModal);
		}
		this.setContainerOptions(inHideControls, inWidth, inHeight);
		this.setShowing(true);
		this.setPage(inPageName);
		this.reflow();
	}, setContainerOptions:function (inHideControls, inWidth, inHeight) {
		this.setHideControls(inHideControls);
	}, _pageChanged:function () {
		this.page = this.pageContainer.page;
		this[this.page.name] = this.page;
		this.onPageReady();
		this.reflow();
		wm.focusContainer(this.page.root);
	}, onPageReady:function () {
	}, forEachWidget:function (inFunc) {
		return this.pageContainer.forEachWidget(inFunc);
	}, createControls:function () {
		var cp = this.controlsPanel = new wm.Panel({parent:this, owner:this, layoutKind:"top-to-bottom", horizontalAlign:"left", verticalAlign:"top", height:"40px", width:"100%", border:this.footerBorder || "", borderColor:this.footerBorderColor || ""});
		if (!this.noBevel) {
			this.controlsBevel = new wm.Bevel({parent:cp, owner:this});
		}
		var bp = this.buttonPanel = new wm.Panel({parent:cp, owner:this, width:"100%", height:"100%", layoutKind:"left-to-right", horizontalAlign:"right"});
		dojo.addClass(bp.domNode, "wmpagedialog-controlspanel");
		this.closeButton = new wm.Button({parent:bp, owner:this, caption:"Close", width:"80px", height:"100%"});
		this._connections.push(this.connect(this.closeButton, "onclick", this, "dismiss"));
		cp.setShowing(!this.hideControls);
		cp = null;
		bp = null;
	}, setHideControls:function (inHideControls) {
		if (inHideControls !== undefined) {
			this.hideControls = inHideControls;
			this.controlsPanel.setShowing(!inHideControls);
		}
	}, destroy:function () {
		if (this.controlsPanel) {
			this.controlsPanel.destroy();
			this.controlsPanel = null;
		}
		if (this.closeButton) {
			this.closeButton.destroy();
			this.closeButton = null;
		}
		if (this.controlsBevel) {
			this.controlsBevel.destroy();
			this.controlsBevel = null;
		}
		if (this.buttonPanel) {
			this.buttonPanel.destroy();
			this.buttonPanel = null;
		}
		if (this.pageContainer) {
			this.pageContainer.dismiss = null;
			this.pageContainer.destroy();
			this.pageContainer = null;
		}
		this.inherited(arguments);
	}});
	dojo.declare("wm.PageDialog", [wm.Dialog, wm.pageContainerMixin], {noBevel:false, footerBorder:"", footerBorderColor:"", postInit:function () {
		this.inherited(arguments);
		this.initPageContainer();
	}, setPageName:function (inPageName) {
		return this.setPage(inPageName);
	}, setPage:function (inPageName) {
		this.pageName = inPageName;
		if (inPageName && this.pageContainer.pageName != inPageName) {
			this.showLoadingIndicator();
		}
		this.inherited(arguments);
	}, setContainerOptions:function (inHideControls, inWidth, inHeight) {
		inWidth = inWidth || wm.Dialog.prototype.contentWidth;
		inHeight = inHeight || wm.Dialog.prototype.contentHeight;
		if (!dojo.isString(inWidth)) {
			inWidth += "px";
		}
		if (!dojo.isString(inHeight)) {
			inHeight += "px";
		}
		this.setWidth(inWidth);
		this.setHeight(inHeight);
		this.inherited(arguments);
	}, hideLoadingIndicator:function () {
		if (this._loader) {
			dojo._destroyElement(this._loader);
			delete this._loader;
		}
	}, showLoadingIndicator:function () {
		if (this.width < 150 || this.height < 80) {
			return;
		}
		var text = "&nbsp;読込み中...";
		var imgsrc = wm.theme.getImagesPath() + "loadingThrobber.gif";
		this._loader = wm.createElement("div", {id:"_wm_loading_" + this.id, innerHTML:"<div class=\"_wm_loading\" style=\"position: absolute; font-weight: bold; font-size: 10pt; z-index: 100; top: 40%; left: 40%;\"><img alt=\"loading\" style=\"vertical-align: middle\" src=\"" + imgsrc + "\" />" + text + "</div>"});
		this.domNode.appendChild(this._loader);
	}, onPageReady:function () {
		this.hideLoadingIndicator();
	}, makePropEdit:function (inName, inValue, inDefault) {
		switch (inName) {
		  case "pageName":
			return new wm.propEdit.PagesSelect({component:this, name:inName, value:inValue});
		}
		return this.inherited(arguments);
	}, destroy:function () {
		this.inherited(arguments);
		if (this.containerNode) {
			dojo.destroy(this.containerNode);
			this.containerNode = null;
		}
		this.c$ = [];
	}});
	wm.PageDialog.extend({themeable:false});
	wm.Object.extendSchema(wm.PageDialog, {pageName:{group:"Dialog Options", bindable:1, type:"string", order:50}, noBevel:{ignore:1}, footerBorder:{group:"style", order:100}, footerBorderColor:{group:"style", order:101}});
	wm.Dialog.description = "ポップアップダイアログ";
	dojo.declare("wm.PopoutDialog", wm.Dialog, {popout:"", postInit:function () {
		this.inherited(arguments);
	}, setShowing:function (inShow, forceChange) {
		this.inherited(arguments);
		if (this.getValueById(this.popout)) {
			this[this.showing ? "_addPopout" : "_removePopout"]();
		}
	}, _addPopout:function () {
		var p = this.getValueById(this.popout);
		this._popoutShowing = p.showing;
		this._popoutParent = p.parent;
		this._popoutIndex = dojo.indexOf(p.parent.c$, this);
		p.setParent(this);
		this.moveControl(p, 0);
		if (!this._popoutShowing) {
			p.setShowing(true);
		}
		if (this._popoutShowing) {
			this._popoutParent.reflow();
		}
		this.flow();
	}, _removePopout:function () {
		var p = this.getValueById(this.popout);
		p.setShowing(this._popoutShowing);
		p.setParent(this._popoutParent);
		this._popoutParent.moveControl(p, this._popoutIndex);
		if (this._popoutShowing) {
			this._popoutParent.reflow();
		}
	}});
	dojo.declare("wm.ColorPickerDialog", wm.Dialog, {colorPicker:null, colorPickerSet:false, border:"1", borderColor:"#888888", width:"325px", height:"210px", modal:false, colorPickerControl:null, init:function () {
		this.inherited(arguments);
	}, postInit:function () {
		this.inherited(arguments);
		if (!wm.ColorPickerDialog.cssLoaded) {
			var link = document.createElement("link");
			link.rel = "stylesheet";
			link.type = "text/css";
			link.href = dojo.moduleUrl("dojox.widget.ColorPicker").uri + "ColorPicker.css";
			document.getElementsByTagName("head")[0].appendChild(link);
			wm.ColorPickerDialog.cssLoaded = true;
		}
		this.colorPickerControl = new wm.Control({name:"colorPickerControl", width:"325px", height:"170px", owner:this, parent:this});
		this.buttonPanel = new wm.Panel({name:"buttonPanel", width:"100%", height:"100%", layoutKind:"left-to-right", owner:this, parent:this, horizontalAlign:"right"});
		this.BrightenButton = new wm.Button({caption:"Bright", width:"80px", height:"30px", parent:this.buttonPanel});
		this.DarkenButton = new wm.Button({caption:"Dark", width:"80px", height:"30px", parent:this.buttonPanel});
		this.CancelButton = new wm.Button({caption:"Cancel", width:"80px", height:"30px", parent:this.buttonPanel});
		this.OKButton = new wm.Button({caption:"OK", width:"80px", height:"30px", parent:this.buttonPanel});
		this.connect(this.BrightenButton, "onclick", this, "brighten");
		this.connect(this.DarkenButton, "onclick", this, "darken");
		this.connect(this.OKButton, "onclick", this, "onOK");
		this.connect(this.CancelButton, "onclick", this, "onCancel");
		this.domNode.style.backgroundColor = "white";
	}, onCancel:function () {
	}, onOK:function () {
		this.dismiss();
	}, getValue:function () {
		if (this.colorPicker) {
			return this.colorPicker.getValue();
		} else {
			return this._tmpValue;
		}
	}, setValue:function (inValue) {
		if (this.colorPicker) {
			this.colorPicker.setColor(inValue);
		} else {
			this._tmpValue = inValue;
		}
	}, setShowing:function (inShowing, forceShow) {
		if (!this.colorPicker && inShowing && this.domNode) {
			this.colorPicker = new dojox.widget.ColorPicker({animatePoint:true, showHsv:false, showRtb:true, webSave:false, onChange:dojo.hitch(this, "valueChange")}, this.domNode);
			this.colorPicker.PICKER_SAT_VAL_H = 152;
			this.colorPicker.PICKER_SAT_VAL_W = 152;
			this.colorPicker.PICKER_HUE_H = 150;
			this.colorPicker._shift.picker.x = 5;
			this.colorPicker._shift.picker.y = 5;
		}
		if (inShowing) {
			if (!this.showing) {
				this._changed = false;
			}
			if (this._tmpValue) {
				this.setValue(this._tmpValue);
				delete this._tmpValue;
			}
			if (this.domNode.parentNode != document.body) {
				document.body.appendChild(this.domNode);
				this.colorPickerControl.domNode.appendChild(this.colorPicker.domNode);
			}
			if (this.owner.editorNode) {
				var o = dojo._abs(this.owner.editorNode);
				o.y += this.owner.bounds.h;
				this.bounds.t = o.y;
				this.bounds.l = o.x;
				this._fixPosition = true;
			}
		}
		this.inherited(arguments);
	}, valueChange:function (inValue) {
		this._changed = true;
		this.onChange(inValue);
	}, onChange:function (inValue) {
	}, brighten:function () {
		var value = this.colorPicker.attr("value");
		var values = [parseInt(value.substr(1, 2), 16), parseInt(value.substr(3, 2), 16), parseInt(value.substr(5, 2), 16)];
		var result = "#";
		var zeroCount = 0;
		var maxCount = 0;
		for (var i = 0; i < 3; i++) {
			if (values[i] == 0) {
				zeroCount++;
			} else {
				if (values[i] == 255) {
					maxCount++;
				}
			}
		}
		var minValue = 0;
		if (maxCount + zeroCount == 3) {
			minValue = 40;
		}
		for (var i = 0; i < 3; i++) {
			values[i] = Math.max(minValue, Math.min(255, Math.floor(values[i] * 1.2)));
			var str = values[i].toString(16);
			if (str.length < 2) {
				str = "0" + str;
			}
			result += str;
		}
		this.setValue(result);
		this.onChange(result);
	}, darken:function () {
		var value = this.colorPicker.attr("value");
		var values = [parseInt(value.substr(1, 2), 16), parseInt(value.substr(3, 2), 16), parseInt(value.substr(5, 2), 16)];
		var result = "#";
		for (var i = 0; i < 3; i++) {
			values[i] = Math.floor(values[i] * 0.8);
			var str = values[i].toString(16);
			if (str.length < 2) {
				str = "0" + str;
			}
			result += str;
		}
		this.setValue(result);
		this.onChange(result);
	}, destroy:function () {
		if (this.colorPicker) {
			this.colorPicker.destroyRecursive();
		}
		this.inherited(arguments);
	}});
	wm.ColorPickerDialog.cssLoaded = false;
	dojo.declare("wm.DesignableDialog", wm.Dialog, {border:"1", borderColor:"black", titlebarBorder:"1", titlebarBorderColor:"black", footerBorder:"1", footerBorderColor:"black", scrim:false, useContainerWidget:true, title:"Dialog", postInit:function () {
		this.inherited(arguments);
		delete this.containerNode;
	}});
	wm.Object.extendSchema(wm.DesignableDialog, {owner:{ignore:true}});
}
if (!dojo._hasResource["wm.base.widget.Editor"]) {
	dojo._hasResource["wm.base.widget.Editor"] = true;
	dojo.provide("wm.base.widget.Editor");
	wm.editors = ["Text", "Date", "Time", "Number", "Currency", "Select", "CheckBox", "TextArea", "RadioButton", "Lookup", "Slider"];
	wm.getEditor = function (inName) {
		var c = inName || "Text";
		if (c.slice(0, 5) != "wm") {
			c = "wm._" + c + "Editor";
		}
		return dojo.getObject(c) || wm._BaseEditor;
	};
	wm.getDataSet = function (inWidget) {
		var w = inWidget;
		while (w && !w.dataSet) {
			w = w.parent;
		}
		if (w && w.dataSet) {
			return w.dataSet;
		}
	};
	wm.getEditorType = function (inPrimitive) {
		var t = wm.typeManager.getPrimitiveType(inPrimitive) || inPrimitive;
		var map = {Boolean:"CheckBox"};
		if (t in map) {
			t = map[t];
		}
		return dojo.indexOf(wm.editors, t) != -1 ? t : "Text";
	};
	wm.getFieldEditorProps = function (inFieldInfo) {
		var f = inFieldInfo, props = {caption:f.caption, display:wm.getEditorType(f.displayType || f.type), readonly:f.readonly, editorInitProps:{required:f.required}, required:true, subType:f.subType};
		if (props.display == "CheckBox") {
			props.editorInitProps.dataType = "boolean";
			props.displayValue = true;
			props.emptyValue = "false";
		}
		return props;
	};
	wm.createFieldEditor = function (inParent, inFieldInfo, inProps, inEvents, inClass) {
		var props = dojo.mixin({}, wm.getFieldEditorProps(inFieldInfo), inProps);
		var name = wm.getValidJsName(props.name || "editor1");
		return inParent.owner.loadComponent(name, inParent, inClass || "wm.Editor", props, inEvents);
	};
	wm.updateFieldEditorProps = function (inEditor, inFieldInfo) {
		var e = inEditor, props = wm.getFieldEditorProps(inFieldInfo), editor = props.editorInitProps;
		delete props.formField;
		delete props.editorInitProps;
		for (var i in props) {
			e.setProp(i, props[i]);
		}
		for (var i in editor) {
			e.editor.setProp(i, editor[i]);
		}
	};
	dojo.declare("wm.Editor", wm.Container, {height:"24px", width:"150px", padding:2, displayValue:"", saveDisplayValue:false, dataValue:null, horizontalAlign:"justified", verticalAlign:"justified", emptyValue:"unset", caption:"", lock:true, box:"h", captionSize:"50%", resizeToFit:"(Resize to Fit)", captionUnits:"flex", captionAlign:"right", captionPosition:"left", singleLine:true, display:"Text", readonly:false, subType:"", _updating:0, editingProps:{displayValue:1, dataValue:1, groupValue:1}, init:function () {
		this.inherited(arguments);
		this.createCaption();
	}, postInit:function () {
		this.startTimer("Editor.postInit", this.declaredClass);
		this.startTimer("Editor.super.postInit", this.declaredClass);
		this.inherited(arguments);
		this.stopTimer("Editor.super.postInit", this.declaredClass);
		this.startTimer("Editor.Misc.postInit", this.declaredClass);
		if (String(this.captionSize).search(/\D/) == -1) {
			this.captionSize += this.captionUnits;
		}
		var su = wm.splitUnits(this.captionSize);
		if (su.units == "flex") {
			this.captionSize = (su.value * 10) + "%";
		}
		if (!this.$.editor) {
			this.setDisplay(this.display);
		} else {
			this.editor = this.$.editor;
		}
		wm.fire(this.editor, "ownerLoaded");
		if (this.captionPosition != "left") {
			this.setCaptionPosition(this.captionPosition);
		}
		this.stopTimer("Editor.Misc.postInit", this.declaredClass);
		this.startTimer("editorChanged", this.declaredClass);
		this.editorChanged();
		this.stopTimer("editorChanged", this.declaredClass);
		this.stopTimer("Editor.postInit", this.declaredClass);
	}, setDomNode:function (inDomNode) {
		this.inherited(arguments);
		dojo.addClass(this.domNode, "wmeditor");
	}, createCaption:function () {
		var cs = String(this.captionSize);
		var classNames = {domNode:["wmeditor-caption"].concat(this._classes.captionNode)};
		this.captionLabel = new wm.Label({parent:this, width:cs, height:cs, _classes:classNames, singleLine:this.singleLine, caption:this.caption, showing:Boolean(this.caption), margin:"0,4,0,0", border:0});
		this.setCaptionAlign(this.captionAlign);
	}, getRequiredHtml:function () {
		var e = this.editor;
		if (!e) {
			e = this.$.editor;
		}
		return !this.readonly && e && e.required ? "&nbsp;<span class=\"wmeditor-required\">*</span>" : "";
	}, setDisplay:function (inDisplay) {
		this.display = inDisplay;
		var e = this.editor || this.$.editor;
		if (e) {
			e.destroy();
			this.editor = null;
		}
		this.createEditor();
		this.reflow();
	}, createEditor:function () {
		var ctor = wm.getEditor(this.display);
		var props = dojo.mixin({name:"editor", owner:this, parent:this, border:0, readonly:this.readonly}, this.editorInitProps || {});
		this.editor = new ctor(props);
		this._editor = this.editor.editor;
	}, setDisplayValue:function (inValue) {
		this.displayValue = inValue;
		wm.fire(this.editor, "setDisplayValue", [inValue]);
	}, getDisplayValue:function () {
		var v = this.getEditorIsReady() ? this.editor.getDisplayValue() : this.displayValue;
		return (v === null || v === undefined || v === false) ? "" : v;
	}, getEditorIsReady:function () {
		return this.editor && this.editor.isReady();
	}, getDataValue:function () {
		return this.getEditorIsReady() ? this.editor.getEditorValue() : this.dataValue;
	}, _getReadonlyValue:function () {
		var v = this.editor && this.editor._getReadonlyValue();
		return v === undefined ? "" : v;
	}, setDataValue:function (inValue) {
		if (inValue === undefined) {
			inValue = null;
		}
		this.dataValue = inValue instanceof wm.Variable ? inValue.getData() : inValue;
		wm.fire(this.editor, "setEditorValue", [inValue]);
	}, setCaption:function (inCaption) {
		var c = this.caption;
		this.caption = inCaption;
		this.captionLabel.setCaption(this.caption + this.getRequiredHtml());
		this.captionLabel.setShowing(Boolean(this.caption));
		if (Boolean(c) != Boolean(this.caption)) {
			this.renderControls();
		}
	}, setCaptionSize:function (inCaptionSize) {
		this.captionLabel[this.layoutKind == "top-to-bottom" ? "setHeight" : "setWidth"](this.captionSize = inCaptionSize);
		this.reflow();
	}, setCaptionAlign:function (inCaptionAlign) {
		this.captionAlign = inCaptionAlign;
		this.captionLabel.setAlign(this.captionAlign);
	}, setCaptionPosition:function (inCaptionPosition) {
		var cp = this.captionPosition = inCaptionPosition;
		this.removeControl(this.captionLabel);
		this.insertControl(this.captionLabel, (cp == "top" || cp == "left") ? 0 : 1);
		this.setLayoutKind((cp == "top" || cp == "bottom") ? "top-to-bottom" : "left-to-right");
		this.setCaptionSize(this.captionSize);
	}, setSingleLine:function (inSingleLine) {
		this.singleLine = inSingleLine;
		this.captionLabel.setSingleLine(inSingleLine);
	}, setDisabled:function (inDisabled) {
		var d = this.disabled;
		this.inherited(arguments);
		if (d != this.disabled) {
			this.updateDisabled();
		}
	}, updateDisabled:function () {
		dojo[this.disabled ? "addClass" : "removeClass"](this.captionLabel.domNode, "wmeditor-caption-disabled");
		wm.fire(this.editor, "setDisabled", [this.disabled]);
	}, setReadonly:function (inReadonly) {
		var r = this.readonly;
		this.readonly = inReadonly;
		if (r != this.readonly) {
			this.setCaption(this.caption);
		}
		wm.fire(this.editor, "setReadonly", [inReadonly]);
	}, setRequired:function (inRequired) {
		wm.fire(this.editor, "setRequired", [inRequired]);
	}, requireChanged:function () {
		this.setCaption(this.caption);
	}, getInvalid:function () {
		return wm.fire(this.editor, "getInvalid");
	}, isValid:function () {
		return !this.getInvalid();
	}, validate:function (inInvalid) {
		wm.fire(this.parent, "validate");
		this.valueChanged("invalid", this.getInvalid());
	}, getGroupValue:function () {
		var e = this.editor;
		return wm.fire(e, "getGroupValue");
	}, setGroupValue:function (inValue) {
		this.groupValue = inValue;
		var e = this.editor;
		wm.fire(e, "setGroupValue", [inValue]);
	}, getCheckedValue:function () {
		return this.getDisplayValue();
	}, setCheckedValue:function (inValue) {
		this.setDisplayValue(inValue);
	}, editorChanged:function () {
		this.valueChanged("displayValue", this.displayValue = this.getDisplayValue());
		this.valueChanged("dataValue", this.dataValue = this.getDataValue());
		wm.fire(this.editor, "ownerEditorChanged");
	}, isUpdating:function () {
		return this._updating > 0;
	}, beginEditUpdate:function (inProp) {
		this._updating++;
	}, endEditUpdate:function (inProp) {
		this._updating--;
	}, valueChanged:function (inProp, inValue) {
		if (this._updating) {
			return;
		}
		this.inherited(arguments);
	}, setValueAsEmpty:function () {
		this.setDataValue(dojo.hitch(this.editor, "makeEmptyValue")());
	}, clear:function () {
		this.dataValue = null;
		this.beginEditUpdate();
		wm.fire(this.editor, "clear");
		this.endEditUpdate();
		this.editorChanged();
	}, update:function () {
		return wm.fire(this.editor, "update");
	}, canFocus:function () {
		return !this.readonly;
	}, focus:function () {
		this.editor.focus();
	}, doOnchange:function () {
		this.editorChanged();
		var e = this.editor;
		if (!this._loading && !this.isUpdating() && !this.readonly && e && !e.isLoading()) {
			this.onchange(this.getDisplayValue(), this.getDataValue());
		}
	}, doOnblur:function () {
		if (!this.disabled) {
			this.onblur();
		}
	}, doOnfocus:function () {
		if (!this.disabled) {
			this.onfocus();
		}
	}, onchange:function (inDisplayValue, inDataValue) {
	}, onfocus:function () {
	}, onblur:function () {
	}});
	wm.Editor.description = "A general purpose editor.";
	wm.Editor.extend({themeable:false, scrim:true, listProperties:function () {
		var e = this.editor, props = dojo.mixin({}, this.inherited(arguments), e ? e.listOwnerProperties() : {}), f = wm.getParentForm(this);
		props.formField.ignore = !Boolean(f);
		props.displayValue.readonly = this.formField && !this.saveDisplayValue;
		props.saveDisplayValue.ignore = !this.formField;
		return props;
	}, afterPaletteDrop:function () {
		this.setCaption(this.name);
	}, set_formField:function (inFieldName) {
		if (!inFieldName) {
			delete this.formField;
		} else {
			this.formField = inFieldName;
		}
		var f = wm.getParentForm(this);
		if (f) {
			var fieldInfo = f.addEditorToForm(this);
		}
	}, resizeLabel:function () {
		var divObj = dojo.doc.createElement("span");
		divObj.style.padding = "5px";
		divObj.innerHTML = this.captionLabel.caption;
		document.body.appendChild(divObj);
		var coords = dojo.coords(divObj);
		var captionWidth = coords.w;
		divObj.parentNode.removeChild(divObj);
		this.setCaptionSize("50%");
		var width = captionWidth * 4;
		this.setWidth(width + "px");
		if (this.isDesignLoaded() && studio.designer.selected == this) {
			setTimeout(dojo.hitch(studio.inspector, "reinspect"), 100);
		}
	}, makePropEdit:function (inName, inValue, inDefault) {
		switch (inName) {
		  case "formField":
			return new wm.propEdit.FormFieldSelect({component:this, name:inName, value:inValue});
		  case "display":
			return makeSelectPropEdit(inName, inValue, wm.editors, inDefault);
		  case "captionAlign":
			return makeSelectPropEdit(inName, inValue, ["left", "center", "right"], inDefault);
		  case "captionSize":
			return new wm.propEdit.UnitValue({component:this, name:inName, value:inValue, options:this._sizeUnits});
		  case "captionPosition":
			return makeSelectPropEdit(inName, inValue, ["top", "left", "bottom", "right"], inDefault);
		  case "emptyValue":
			return makeSelectPropEdit(inName, inValue, ["unset", "null", "emptyString", "false", "zero"], inDefault);
		  case "checkedValue":
			return this.editor.dataType == "boolean" ? makeCheckPropEdit(inName, inValue, inDefault) : this.inherited(arguments);
		  case "resizeToFit":
			return makeReadonlyButtonEdit(inName, inValue, inDefault);
		}
		return this.inherited(arguments);
	}, editProp:function (inName, inValue, inInspector) {
		switch (inName) {
		  case "resizeToFit":
			return this.resizeLabel();
		}
		return this.inherited(arguments);
	}, writeChildren:function (inNode, inIndent, inOptions) {
		var s = this.inherited(arguments);
		s.push(this.editor.write(inIndent, inOptions));
		return s;
	}, addUserClass:function (inClass, inNodeName) {
		this.inherited(arguments);
		if (inNodeName == "captionNode") {
			this.captionLabel.addUserClass(inClass, "domNode");
		}
	}, removeUserClass:function (inClass, inNodeName) {
		this.inherited(arguments);
		if (inNodeName == "captionNode") {
			this.captionLabel.removeUserClass(inClass, "domNode");
		}
	}});
	wm.FormEditor = wm.Editor;
	dojo.declare("wm.TextEditor", wm.Editor, {});
	dojo.declare("wm.DateEditor", wm.Editor, {display:"Date"});
	dojo.declare("wm.TimeEditor", wm.Editor, {display:"Time"});
	dojo.declare("wm.NumberEditor", wm.Editor, {display:"Number"});
	dojo.declare("wm.CurrencyEditor", wm.Editor, {display:"Currency"});
	dojo.declare("wm.SelectEditor", wm.Editor, {display:"Select"});
	dojo.declare("wm.CheckBoxEditor", wm.Editor, {displayValue:1, display:"CheckBox", getChecked:function () {
		return this.editor.getChecked();
	}, setChecked:function (inChecked) {
		this.editor.setChecked(inChecked);
	}});
	dojo.declare("wm.TextAreaEditor", wm.Editor, {display:"TextArea"});
	wm.TextAreaEditor.extend({});
	dojo.declare("wm.RadioButtonEditor", wm.Editor, {displayValue:1, display:"RadioButton"});
	dojo.declare("wm.LookupEditor", wm.Editor, {display:"Lookup"});
	dojo.declare("wm.SliderEditor", wm.Editor, {display:"Slider"});
	wm.Object.extendSchema(wm.Editor, {disabled:{bindTarget:true, type:"Boolean", group:"common", order:40}, formField:{ignore:1, writeonly:1, group:"common", order:500}, singleLine:{group:"display", order:200}, box:{ignore:1}, horizontalAlign:{ignore:1}, verticalAlign:{ignore:1}, layoutKind:{ignore:1}, fitToContent:{ignore:1}, scrollX:{ignore:1}, scrollY:{ignore:1}, lock:{ignore:1}, imageList:{ignore:1}, caption:{bindable:1, group:"display", type:"String", order:0, focus:1}, readonly:{bindable:1, type:"Boolean", group:"display", order:5}, captionSize:{group:"display", order:200}, captionUnits:{ignore:1}, captionAlign:{group:"display", order:210}, captionPosition:{group:"display", order:220}, display:{group:"edit", order:20}, editor:{ignore:1, writeonly:1, componentonly:1, categoryParent:"Properties", categoryProps:{component:"editor"}}, displayValue:{bindable:1, group:"edit", order:40, type:"any"}, dataValue:{ignore:1, bindable:1, group:"edit", order:45, simpleBindProp:true}, emptyValue:{group:"edit", order:50}, invalid:{ignore:1, bindSource:1, type:"boolean"}, groupValue:{ignore:1}, selectedItem:{ignore:1}, resizeToFit:{group:"layout", order:200}, captionStyles:{ignore:1, categoryParent:"Styles", categoryProps:{content:"値", nodeName:"captionNode", nodeClass:"wmeditor-caption"}}});
}
if (!dojo._hasResource["wm.base.widget.FileUpload"]) {
	dojo._hasResource["wm.base.widget.FileUpload"] = true;
	dojo.provide("wm.base.widget.FileUpload");
	dojo.declare("wm.FileUpload", [wm.Container, wm.ServiceCall], {scrim:true, box:"h", lock:true, caption:"Label", captionLabel:null, captionSize:"60px", captionAlign:"right", captionPosition:"left", singleLine:true, uploadButton:true, uploadButtonCaption:"Upload", uploadButtonWidth:"100px", uploadButtonHeight:"48px", uploadButtonPosition:"right", service:"", operation:"", formContainer:null, subPanel1:null, subPanel2:null, formWidth:"230px", width:"420px", destroy:function () {
		this.destroyUploadBtn();
		this.inherited(arguments);
	}, destroyUploadBtn:function () {
		wm.fire(this.uploadBtn, "destroy");
	}, init:function () {
		this.inherited(arguments);
		this.subPanel1 = new wm.Container({name:"SubPanel1", owner:this, parent:this, width:"100%", height:"100%", layoutKind:"top-to-bottom"});
		this.subPanel2 = new wm.Container({name:"SubPanel2", owner:this, parent:this.subPanel1, width:"100%", height:"100%", layoutKind:"left-to-right"});
		this.createCaption();
		this.formContainer = new wm.Control({name:"FormContainer", owner:this, parent:this.subPanel2, width:this.formWidth, height:"100%"});
		var domHTML = ["<form style=\"width:100%;position:absolute;top:0;left:0\" flex=\"1\" box=\"v\" enctype=\"multipart/form-data\" method=\"post\">", "<input class=\"HiddenOperation\" type=\"hidden\" name=\"method\" value=\"" + this.operation + "\" />", "<input id=\"" + this.name + "_FileInputElement\" style=\"width:100%\" type=\"file\" name=\"file\" />", "</form>"].join("");
		this.formContainer.domNode.innerHTML = domHTML;
		this.formNode = this.formContainer.domNode.firstChild;
		this.fileNode = this.formNode.lastChild;
		this.setUploadButton(this.uploadButton);
	}, setOperation:function (inOperation) {
		this.inherited(arguments);
		dojo.query(".HiddenOperation", this.formContainer.domNodeo).attr("value", inOperation);
	}, postInit:function () {
		this.inherited(arguments);
		if (String(this.captionSize).search(/\D/) == -1) {
			this.captionSize += "px";
		}
		var su = wm.splitUnits(this.captionSize);
		if (su.units == "flex") {
			this.captionSize = (su.value * 10) + "%";
		}
		this.setCaptionPosition(this.captionPosition, true);
		this.setUploadButtonPosition(this.uploadButtonPosition);
	}, createCaption:function () {
		var cs = String(this.captionSize);
		var classNames = {domNode:["wmeditor-caption"].concat(this._classes.captionNode)};
		this.captionLabel = new wm.Label({parent:this.subPanel2, width:cs, height:cs, _classes:classNames, singleLine:this.singleLine, caption:this.caption, showing:Boolean(this.caption), margin:"0,4,0,0", border:0});
		this.setCaptionAlign(this.captionAlign);
	}, setCaption:function (inCaption) {
		var c = this.caption;
		this.caption = inCaption;
		this.captionLabel.setCaption(this.caption);
		this.captionLabel.setShowing(Boolean(this.caption));
		if (Boolean(c) != Boolean(this.caption)) {
			this.renderControls();
		}
	}, setCaptionSize:function (inCaptionSize) {
		this.captionSize = inCaptionSize;
		if (this.layoutKind == "top-to-bottom") {
			this.captionLabel.setHeight(this.captionSize);
			this.captionLabel.setWidth("100%");
		} else {
			this.captionLabel.setWidth(this.captionSize);
			this.captionLabel.setHeight("100%");
		}
		this.reflow();
	}, setCaptionAlign:function (inCaptionAlign) {
		this.captionAlign = inCaptionAlign;
		this.captionLabel.domNode.style.textAlign = this.captionAlign;
	}, setCaptionPosition:function (inCaptionPosition, inKeepSize) {
		var cp = this.captionPosition = inCaptionPosition;
		this.subPanel2.setLayoutKind((cp == "top") ? "top-to-bottom" : "left-to-right");
		if (!inKeepSize) {
			if (cp == "top") {
				this.captionSize = "20px";
				if (this.uploadButton && this.uploadButtonPosition == "bottom" && this.getDomHeight() < 90) {
					this.setHeight("90px");
				} else {
					if (this.getDomHeight() < 50) {
						this.setHeight("50px");
					}
				}
			} else {
				this.captionSize = "60px";
			}
		}
		this.setCaptionSize(this.captionSize);
	}, setSingleLine:function (inSingleLine) {
		this.singleLine = inSingleLine;
		this.captionLabel.setSingleLine(inSingleLine);
	}, setUploadButtonPosition:function (inPosition) {
		this.uploadButtonPosition = inPosition;
		if (inPosition == "bottom") {
			this.subPanel1.setLayoutKind("top-to-bottom");
			if (this.uploadButton) {
				this.uploadBtn.setHeight("40px");
				if (this.captionPosition == "top" && this.getDomHeight() < 90) {
					this.setHeight("90px");
				} else {
					if (this.getDomHeight() < 65) {
						this.setHeight("65px");
					}
				}
			}
			this.setUploadButtonWidth("80px");
		} else {
			this.subPanel1.setLayoutKind("left-to-right");
			this.setUploadButtonWidth("100px");
		}
	}, setUploadButtonCaption:function (inCaption) {
		this.uploadButtonCaption = inCaption;
		if (this.uploadBtn) {
			this.uploadBtn.setCaption(this.uploadButtonCaption);
			this.reflow();
		}
	}, setUploadButtonWidth:function (inCaptionSize) {
		if (this.uploadButton) {
			this.uploadBtn.setWidth(inCaptionSize);
			this.uploadButtonWidth = inCaptionSize;
			this.reflow();
		}
	}, setUploadButtonHeight:function (inCaptionSize) {
		if (this.uploadButton) {
			this.uploadBtn.setHeight(inCaptionSize);
			this.uploadButtonHeight = inCaptionSize;
			this.reflow();
		}
	}, setUploadButton:function (inUpload) {
		this.uploadButton = inUpload;
		if (this.uploadButton) {
			var u = this.uploadBtn = new wm.Button({name:"UploadButton", owner:this, parent:this.subPanel1, caption:this.uploadButtonCaption, width:this.uploadButtonWidth, height:this.uploadButtonHeight});
			this.uploadBtn.connect(this.uploadBtn, "onclick", this, "upload");
		} else {
			this.destroyUploadBtn();
		}
		if (!this._loading) {
			this.reflow();
		}
	}, assemblePanels:function () {
		this.removeAllControls();
		if ((this.uploadButtonPosition == "right" || !this.uploadButton) && (this.captionPosition == "left" || this.captionPosition == "right" || !this.caption)) {
			var panel1 = new wm.Container({name:"SubPanel1", owner:this, parent:this, width:"100%", height:"100%", layoutKind:"left-to-right"});
			if (this.captionPosition == "left" && this.caption) {
				this.captionLabel.setParent(panel1);
			}
			this.formContainer.setParent(panel1);
			if (this.captionPosition == "right" && this.caption) {
				this.captionLabel.setParent(panel1);
			}
			if (this.uploadButtonPosition == "right" && this.uploadButton) {
				this.uploadBtn.setParent(panel1);
			}
			if (this.uploadButton && this.caption) {
				this.setUploadButtonWidth("60%");
				this.setCaptionSize("40%");
			} else {
				if (this.uploadButton) {
					this.setUploadButtonWidth("100%");
				} else {
					if (this.caption) {
						this.setCaptionSize("100%");
					}
				}
			}
		} else {
			if ((this.uploadButtonPosition == "bottom" || !this.uploadButton) && (this.captionPosition == "top" || this.captionPosition == "bottom" || !this.caption)) {
				var panel1 = new wm.Container({name:"SubPanel1", owner:this, parent:this, width:"100%", height:"100%", layoutKind:"top-to-bottom"});
				if (this.captionPosition == "top" && this.caption) {
					this.captionLabel.setParent(panel1);
				}
				this.formContainer.setParent(panel1);
				if (this.captionPosition == "bottom" && this.caption) {
					this.captionLabel.setParent(panel1);
				}
				if (this.uploadButtonPosition == "bottom" && this.uploadButton) {
					this.uploadBtn.setParent(panel1);
				}
			} else {
				if (this.captionPosition == "left" || this.captionPosition == "right") {
					var panel1 = new wm.Container({name:"SubPanel1", owner:this, parent:this, width:"100%", height:"100%", layoutKind:"top-to-bottom"});
					var panel2 = new wm.Container({name:"SubPanel2", owner:this, parent:panel1, width:"100%", height:"100%", layoutKind:"left-to-right"});
					if (this.captionPosition == "left") {
						this.captionLabel.setParent(panel2);
					}
					this.formContainer.setParent(panel2);
					if (this.captionPosition == "right") {
						this.captionLabel.setParent(panel2);
					}
					if (this.uploadButton) {
						this.uploadBtn.setParent(panel1);
					}
				} else {
					var panel1 = new wm.Container({name:"SubPanel1", owner:this, parent:this, width:"100%", height:"100%", layoutKind:"top-to-bottom"});
					var panel2 = new wm.Container({name:"SubPanel2", owner:this, parent:panel1, width:"100%", height:"100%", layoutKind:"left-to-right"});
					if (this.captionPosition == "top" && this.caption) {
						this.captionLabel.setParent(panel1);
					}
					this.formContainer.setParent(panel2);
					if (this.uploadButton) {
						this.uploadBtn.setParent(panel2);
						this.setUploadButtonWidth("100%");
					}
					if (this.captionPosition == "bottom" && this.caption) {
						this.captionLabel.setParent(panel1);
					}
				}
			}
		}
		this.formContainer.setWidth(this.formWidth);
		this.reflow();
	}, upload:function () {
		if (!this.fileNode.value) {
			wm.logging && console.debug("Please specify a file to upload.");
			return;
		}
		this.onBegin();
		dojo.io.iframe.send({url:"services/" + this.service + ".upload", content:this._uploadData, form:this.formNode, handleAs:"json", handle:dojo.hitch(this, "onComplete")});
	}, onBegin:function () {
	}, onComplete:function (inResponse) {
		if (inResponse.error) {
			this.onUploadError(inResponse.error);
		} else {
			this.onUploadSuccess(inResponse.result);
		}
		wm.logging && console.debug("Uploaded: " + this.fileNode.value);
	}, onUploadError:function (inResponse) {
	}, onUploadSuccess:function (inError) {
	}, makePropEdit:function (inName, inValue, inDefault) {
		switch (inName) {
		  case "uploadButtonWidth":
			return new wm.propEdit.UnitValue({component:this, name:inName, value:inValue, options:this._sizeUnits});
		  case "uploadButtonHeight":
			return new wm.propEdit.UnitValue({component:this, name:inName, value:inValue, options:this._sizeUnits});
		  case "captionSize":
			return new wm.propEdit.UnitValue({component:this, name:inName, value:inValue, options:this._sizeUnits});
		  case "captionPosition":
			return makeSelectPropEdit(inName, inValue, ["top", "left"], inDefault);
		  case "uploadButtonPosition":
			return makeSelectPropEdit(inName, inValue, ["right", "bottom"], inDefault);
		  case "captionAlign":
			return makeSelectPropEdit(inName, inValue, ["left", "center", "right"], inDefault);
		  case "service":
			return makeSelectPropEdit(inName, inValue, this.getServicesList(), inDefault);
		  case "operation":
			var s = this._service, valueOk = s && s.getOperation(inValue), methods = s && s.getOperationsList();
			if (!valueOk) {
				inValue = methods ? methods[0] : "";
				if (inValue) {
					this.set_operation(inValue);
				}
			}
			if (methods) {
				return makeSelectPropEdit(inName, inValue, methods, inDefault);
			}
			break;
		}
		return this.inherited(arguments);
	}});
	wm.FileUpload.extend({writeComponents:function (inIndent, inOptions) {
		return [this.components.binding.write(inIndent, inOptions)];
	}, writeChildren:function () {
		return [];
	}});
	wm.Object.extendSchema(wm.FileUpload, {lock:{ignore:1}, box:{ignore:1}, boxPosition:{ignore:1}, name:{group:"common", order:1}, showing:{group:"common", order:2}, service:{group:"Upload Service", order:3}, operation:{group:"Upload Service", order:4}, updateNow:{group:"Upload Service", order:5}, uploadButton:{shortname:"Use Button", group:"Upload Button", order:10}, uploadButtonCaption:{shortname:"caption", group:"Upload Button", order:11}, uploadButtonWidth:{shortname:"width", group:"Upload Button", order:12}, uploadButtonHeight:{shortname:"height", group:"Upload Button", order:13}, uploadButtonPosition:{name:"position", group:"Upload Button", order:14}, caption:{group:"Upload Label", order:20}, captionSize:{name:"size", group:"Upload Label", order:21}, captionAlign:{name:"align", group:"Upload Label", order:22}, captionPosition:{name:"position", group:"Upload Label", order:23}, singleLine:{group:"Upload Label", order:24}, startUpdate:{ignore:1}, queue:{ignore:1}, clearInput:{ignore:1}, autoUpdate:{ignore:1}, fitToContent:{ignore:1}, layoutKind:{ignore:1}, verticalAlign:{ignore:1}, imageList:{ignore:1}});
}
if (!dojo._hasResource["wm.base.widget.EditArea"]) {
	dojo._hasResource["wm.base.widget.EditArea"] = true;
	dojo.provide("wm.base.widget.EditArea");
	dojo.declare("wm.EditArea", wm.Box, {scrim:true, syntax:"js", _scrim:null, build:function () {
		this.domNode = dojo.byId(this.domNode || undefined);
		if (!this.domNode) {
			this.domNode = document.createElement("div");
		}
		var n = this.textAreaNode = document.createElement("textarea");
		n.style.border = n.style.padding = 0;
		n.style.width = "100%";
		n.style.height = "100%";
		n.id = this.getRuntimeId();
		this.domNode.appendChild(this.textAreaNode);
		this.textAreaDom = new wm.DomNode(this.textAreaNode);
		this._startHandle = new dojo.Deferred();
	}, getScrim:function () {
		if (!this._scrim) {
			this._scrim = new wm.Scrim();
		}
		return this._scrim;
	}, isOn:function () {
		var id = this.area.textarea.id;
		return editAreas && (editAreas[id] || 0)["displayed"];
	}, isReallyShowing:function () {
		return wm.widgetIsShowing(this);
	}, on:function () {
		this.toggle(true);
	}, off:function () {
		this.toggle(false);
	}, toggle:function (inOn) {
		if (this.isStarted()) {
			try {
				editAreaLoader.toggle(this.area.textarea.id, inOn ? "on" : "off");
				if (!inOn) {
					this.area.textarea.blur();
				}
			}
			catch (x) {
			}
		}
	}, _onShowParent:function () {
		this.render();
	}, render:function () {
		this.inherited(arguments);
		if (this.isReallyShowing()) {
			if (!this.isStarted()) {
				this.initEdit();
			} else {
				this.resize();
			}
		}
	}, initEdit:function () {
		var id = this.getRuntimeId();
		if (this._editAreaInitialized) {
			return;
		}
		this.getScrim().setShowing(true);
		editAreaLoader.init({id:id, start_highlight:true, word_wrap:true, allow_resize:"no", allow_toggle:false, language:"en", syntax:this.syntax, toolbar:" ", cursor_position:"auto", replace_tab_by_spaces:2, callSave:dojo.hitch(this, "saveScript"), EA_init_callback:this.getRuntimeId() + "._onStarted", EA_load_callback:this.getRuntimeId() + "._onLoaded"});
		this.area = editAreas[id];
		this._editAreaInitialized = true;
	}, deleteEdit:function () {
		if (!this._editAreaInitialized) {
			return;
		}
		this.off();
		this._startHandle = new dojo.Deferred();
		var id = this.getRuntimeId();
		this._editAreaInitialized = false;
		editAreaLoader.delete_instance(id);
		window.area = null;
	}, isStarted:function () {
		return Boolean(this.area && this.area.textarea && this._editAreaInitialized && this._isStarted);
	}, resize:function () {
		if (this.isStarted()) {
			try {
				this.off();
				this.textAreaDom.setBox(this.getContentBounds());
				this.on();
			}
			catch (x) {
			}
		}
	}, getText:function () {
		if (this.isStarted()) {
			return editAreaLoader.getValue(this.area.textarea.id);
		} else {
			return this.textAreaNode.value;
		}
	}, setText:function (inText) {
		if (this.isStarted()) {
			if (this.isReallyShowing()) {
				editAreaLoader.setValue(this.area.textarea.id, inText);
			} else {
				this.off();
				this.textAreaNode.value = inText;
			}
			this.resetUndo();
		} else {
			this.textAreaNode.value = inText;
		}
	}, setSelectionRange:function (inStart, inEnd) {
		if (this.isStarted()) {
			inStart = inStart || 0;
			inEnd = inEnd !== undefined ? inEnd : inStart;
			editAreaLoader.setSelectionRange(this.area.textarea.id, inStart, inEnd);
		}
	}, resetUndo:function () {
		var f = this.getEditFrame(), area = f && f.editArea;
		if (area) {
			area.previous = [];
			area.next = [];
			area.last_undo = "";
		}
	}, _onStarted:function () {
		this._isStarted = true;
		setTimeout(dojo.hitch(this, function () {
			this._startHandle && this._startHandle.callback(true);
		}), 1);
	}, _onLoaded:function () {
		this.getScrim().setShowing(false);
	}, callAfterStarted:function (inFunction) {
		if (!dojo.isFunction(inFunction)) {
			return;
		}
		if (!this.isStarted() && this._startHandle) {
			this._startHandle.addCallback(inFunction);
		} else {
			inFunction();
		}
	}, getEditFrame:function () {
		if (this.isStarted()) {
			return window.frames["frame_" + this.getRuntimeId()];
		}
	}, setSyntax:function (inSyntax) {
		this.syntax = inSyntax;
		if (this.isStarted()) {
			editAreaLoader.execCommand(this.area.textarea.id, "change_syntax", this.syntax);
		}
	}, saveScript:function (e) {
		if (studio) {
			studio.saveScriptClick();
		}
		dojo.stopEvent(e);
	}});
}
if (!dojo._hasResource["wm.base.widget.EditArea_design"]) {
	dojo._hasResource["wm.base.widget.EditArea_design"] = true;
	dojo.provide("wm.base.widget.EditArea_design");
	wm.EditArea.extend({editorStarted:function () {
		var f = this.getEditFrame();
		if (f) {
			this.connect(f.document, "keydown", this, "keydown");
		}
	}, keydown:function (e) {
		studio.keydown(e);
	}});
}
if (!dojo._hasResource["wm.base.widget.Popup"]) {
	dojo._hasResource["wm.base.widget.Popup"] = true;
	dojo.provide("wm.base.widget.Popup");
	wm.positionAroundNode = function (inPositionNode, inPositionLocation, inWidth, inHeight) {
		var d = dojo.byId(inPositionNode), location = inPositionLocation || "", w = d.offsetWidth, h = d.offsetHeight, tw = inWidth, th = inHeight, o = wm.calcOffset(d, document.body);
		if (d.tagName == "BUTTON" && dojo.isMoz) {
			var be = dojo._getBorderExtents(d);
			o.x -= be.l;
			o.y -= be.t;
		}
		switch (location.charAt(0)) {
		  case "t":
			o.y -= th;
			break;
		  case "b":
			o.y += h;
			break;
		  case "l":
			o.x -= tw;
			break;
		  case "r":
			o.x += w;
		}
		switch (location.charAt(1)) {
		  case "t":
			o.y += h - th;
			break;
		  case "b":
			break;
		  case "l":
			o.x += w - tw;
			break;
		  case "r":
			break;
		}
		return o;
	};
	dojo.declare("wm.Popup", wm.Panel, {box:"v", scrimBackground:false, hideOnClick:true, positionNode:null, positionLocation:"", left:0, top:0, contentWidth:400, contentHeight:300, showing:false, prepare:function (inProps) {
		this.inherited(arguments);
		this.fitToContent = this.autoHeight;
	}, init:function () {
		this.inherited(arguments);
		document.body.appendChild(this.domNode);
		dojo.addClass(this.domNode, "wmpopup");
		this.domNode.style.position = "absolute";
		this.domNode.style.zIndex = 50;
		this.setContentWidth(this.contentWidth);
		this.setContentHeight(this.contentHeight);
		this.connect(document, "onkeypress", this, "keyPress");
		this.connect(this.domNode, "onclick", this, "onClick");
		dojo.subscribe("window-resize", this, "reflow");
	}, reflowParent:function () {
	}, flow:function () {
		if (this.showing && !this._cupdating) {
			this.inherited(arguments);
			this.doPositionAroundNode();
			this.render();
		}
	}, render:function () {
		if (this.showing) {
			this.inherited(arguments);
			wm.bgIframe.size();
		}
	}, setContentWidth:function (inWidth) {
		this.contentWidth = inWidth;
		this.setWidth(inWidth + "px");
	}, setContentHeight:function (inHeight) {
		this.contentHeight = inHeight;
		this.setHeight(inHeight + "px");
	}, setContentSize:function (inWidth, inHeight) {
		this.setContentWidth(inWidth);
		this.setContentHeight(inHeight);
	}, setPositionLeft:function (inLeft) {
		this.left = inLeft + "px";
		this.setBounds(inLeft, NaN);
	}, setPositionTop:function (inTop) {
		this.setBounds(NaN, inTop);
		this.top = inTop + "px";
	}, setPosition:function (inLeft, inTop) {
		this.setPositionLeft(inLeft);
		this.setPositionTop(inTop);
	}, doPositionAroundNode:function () {
		if (!this.positionNode) {
			return;
		}
		var b = this.getBounds(), o = wm.positionAroundNode(this.positionNode, this.positionLocation, b.w, b.h);
		this.setPosition(o.x, o.y);
	}, keyPress:function (inEvent) {
		if (inEvent.keyCode == dojo.keys.ESCAPE) {
			this.hide();
		}
	}, eventHide:function () {
		if (this.closeAll) {
			wm.Popup.closeAll();
		} else {
			this.hide();
		}
	}, delayedHide:function (inDelay) {
		this._hidePending = setTimeout(dojo.hitch(this, "hide"), inDelay);
	}, cancelHide:function () {
		if (this._hidePending) {
			clearTimeout(this._hidePending);
			this._hidePending = null;
		}
	}, setShowing:function (inShowing, forceChange) {
		wm.dialog.showing = Math.max(0, wm.dialog.showing + ((inShowing) ? 1 : -1));
		if (this._loading) {
			this.inherited(arguments);
		} else {
			if (forceChange || inShowing != this.showing) {
				this[inShowing ? "_popOnIdle" : "_unpop"]();
			}
		}
	}, _superSetShowing:function (inShowing) {
		wm.Panel.prototype.setShowing.call(this, inShowing);
	}, _popOnIdle:function () {
		wm.onidle(this, "_pop");
	}, _pop:function () {
		this.cancelHide();
		this.showing = true;
		this.reflow();
		this.domNode.style.display = "block";
		wm.Popup.addPopup(this);
		this.onShow();
	}, mouseup:function (e) {
		var tmp = e.target;
		if (!tmp || tmp == null) {
			return;
		}
		while (tmp != this.domNode && tmp != dojo.body()) {
			tmp = tmp.parentNode;
		}
		if (tmp != this.domNode) {
			wm.Popup.closeEvent(e);
		}
	}, _unpop:function () {
		var top = wm.Popup.getTop();
		if (top && top != this) {
			wm.Popup.closePopup(this);
		} else {
			this.showing = false;
			this.domNode.style.display = "none";
			wm.Popup.removePopup();
			this.onHide();
		}
	}, onClick:function (e) {
		e._popup = true;
	}, onShow:function () {
	}, onHide:function () {
	}});
	dojo.declare("wm.PopupCapture", wm.Capture, {constructor:function () {
		this.setEvents("mousedown", "mousemove", "mouseover", "mouseout", "mouseup");
		for (var i in this.events) {
			this[i] = this.processCapture;
		}
	}, processCapture:function (e) {
		var c = wm.Popup.captured;
		if (c) {
			if (e.type == "mousemove" && !dojo.isDescendant(e.target, c.domNode)) {
				var n = wm.Popup.findPopupForNode(e.target);
				if (n) {
					wm.Popup.doCapture(n);
					return;
				}
			} else {
				if (c[e.type]) {
					c[e.type].call(c, e);
				}
			}
		}
		if (dojo.isIE) {
			if ((e.srcElement == c.domNode) || dojo.isDescendant(e.srcElement, c.domNode)) {
				wm.fire(e.srcElement, "on" + e.type, [e]);
			}
		}
	}});
	dojo.mixin(wm.Popup, {popups:[], _scrim:null, getScrim:function () {
		if (!this._scrim) {
			this._scrim = new wm.Scrim({waitCursor:false});
			dojo.addClass(this._scrim.domNode, "wmpopupscrim");
		}
		return this._scrim;
	}, getCapture:function () {
		return this._capture || (this._capture = this._createCapture());
	}, _createCapture:function () {
		return new wm.PopupCapture();
	}, findPopupForNode:function (inNode) {
		for (var i = 0, popups = this.popups, p; (p = popups[i]); i++) {
			if (dojo.isDescendant(inNode, p.domNode)) {
				return p;
			}
		}
	}, doCapture:function (inPopup) {
		var c = this.getCapture();
		this.captured = inPopup;
		c.release();
		c.capture();
	}, getCount:function () {
		return this.popups.length;
	}, getTop:function () {
		var c = this.getCount();
		if (c) {
			return this.popups[c - 1];
		}
	}, addPopup:function (inPopup) {
		this.popups.push(inPopup);
		if (inPopup.scrimBackground) {
			this.setScrimShowing(true);
		}
		if (inPopup.hideOnClick) {
			this.doCapture(inPopup);
		}
	}, removePopup:function () {
		var p = this.getTop();
		if (p && p.scrimBackground) {
			this.setScrimShowing(false);
		}
		this.popups.pop();
	}, setScrimShowing:function (inShowing) {
		wm.bgIframe.setShowing(inShowing);
		var scrim = this.getScrim();
		scrim.setShowing(inShowing);
	}, closeEvent:function (e) {
		if (e._popup) {
			return;
		}
		e._popup = true;
		var p = this.getTop();
		if (p) {
			if (p.hideOnClick) {
				this.getCapture().release();
			}
			p.eventHide();
		}
	}, closeTop:function () {
		var p = this.getTop();
		if (p) {
			p.hide();
		}
	}, closePopup:function (inPopup) {
		if (dojo.indexOf(this.popups, inPopup) == -1) {
			return;
		}
		var p = this.getTop();
		while (p) {
			p.hide();
			if (p == inPopup) {
				return;
			}
			p = this.getTop();
		}
	}, closeAll:function () {
		var p = this.getTop();
		while (p) {
			p.hide();
			p = this.getTop();
		}
	}});
	wm.Object.extendSchema(wm.Popup, {contentWidth:{ignore:1}, contentHeight:{ignore:1}, positionLocation:{ignore:1}});
	dojo.declare("wm.PagePopup", [wm.Popup, wm.pageContainerMixin], {init:function () {
		this.inherited(arguments);
		this.initPageContainer();
	}, dismiss:function () {
		this.hide();
	}, setContainerOptions:function (inHideControls, inWidth, inHeight) {
		inWidth = inWidth || wm.Dialog.prototype.contentWidth;
		inHeight = inHeight || wm.Dialog.prototype.contentHeight;
		this.setContentWidth(inWidth);
		this.setContentHeight(inHeight);
		this.inherited(arguments);
	}});
	dojo.declare("wm.ItemsPopup", wm.Popup, {fitToContent:true, init:function () {
		this.items = [];
		this.inherited(arguments);
		dojo.addClass(this.domNode, "wmitempopup");
	}, _addItem:function (inItem) {
		var i = inItem;
		if (i instanceof wm.Item) {
			this.items.push(i);
			if (i.parent != this) {
				i.setParent(this);
			}
			i.render();
			this.connect(i, "onbeforeclick", this, "_itemClick");
			if (i.onItemClick) {
				this.connect(i, "onItemClick", this, "onItemClick");
			}
		}
	}, addWidget:function (inWidget) {
		this.inherited(arguments);
		this._addItem(inWidget);
	}, createItem:function (inItemProps, inItemEvents, inPopupItem) {
		var r = this.getRoot();
		if (r) {
			var itemClass = inPopupItem ? "wm.PopupItem" : "wm.Item", c = r.loadComponent(this.name + "Item", this, itemClass, inItemProps, inItemEvents);
			this._addItem(c);
		}
		return c;
	}, getCount:function () {
		return this.items.length;
	}, _pop:function () {
		if (!this.getCount()) {
			return;
		}
		dojo.forEach(this.items, function (i) {
			i.addRemoveOverState(false);
		});
		this.inherited(arguments);
	}, removeItem:function (inItem) {
		var i = dojo.indexOf(this.items, inItem);
		if (i != -1) {
			var item = this.items[i];
			this.items.splice(i, 1);
			item.destroy();
		}
	}, removeItems:function () {
		dojo.forEach(this.items, function (i) {
			i.destroy();
		});
		this.items = [];
	}, _itemClick:function (e) {
		var item = e.item;
		if (item) {
			if (item.popup && item.popup.items) {
				item._clicked();
			} else {
				this.eventHide();
			}
			this.onItemClick(item);
		}
	}, onItemClick:function (inItem) {
	}});
	dojo.declare("wm.Item", wm.ToolButton, {singleLine:true, height:"24px", backgroundColor:"transparent", border:0, init:function () {
		if (this.parent && this.parent.popup) {
			this.parent = this.parent.popup;
		}
		this.inherited(arguments);
		this.connectEvents(this.domNode, ["mouseover", "mouseout"]);
		dojo.addClass(this.domNode, "wmitem");
	}, isReflowEnabled:function () {
		return 1;
	}, findImageList:function () {
		var t = this;
		while (t && !t.imageList) {
			t = t.parent || t.owner;
		}
		return t ? t.imageList : null;
	}, setDisabled:function (inDisabled) {
		this.inherited(arguments);
		dojo[this.disabled ? "addClass" : "removeClass"](this.domNode, "wmitem-disabled");
	}, mouseover:function () {
		this.addRemoveOverState(true);
	}, mouseout:function () {
		this.addRemoveOverState(false);
	}, addRemoveOverState:function (inAdd) {
		dojo[inAdd ? "addClass" : "removeClass"](this.domNode, "wmitem-over");
	}, click:function (inEvent) {
		inEvent.item = this;
		this.onbeforeclick(inEvent);
		setTimeout(dojo.hitch(this, "onclick", inEvent), 1);
	}, onbeforeclick:function (inEvent) {
	}, onclick:function (inEvent) {
	}});
	wm.Object.extendSchema(wm.Item, {format:{ignore:1}});
	dojo.declare("wm.PopupItemsMixin", null, {container:true, popupWidth:110, popupLocation:"br", initPopup:function () {
		wm.fire(this.popup, "destroy");
		var p = this.popup = new wm.ItemsPopup({owner:this, imageList:wm.Button.prototype.findImageList.call(this), name:"popup", positionLocation:this.popupLocation, positionNode:this.domNode, maxHeight:this.maxHeight, autoHeight:true});
		p.setContentWidth(this.popupWidth);
	}, addPopupItems:function () {
		for (var i in this.widgets) {
			this.popup._addItem(this.widgets[i]);
		}
	}, writeChildren:function (inNode, inIndent, inOptions) {
		var s = [], w, widgets = (this.popup || 0).widgets;
		for (var i in widgets) {
			w = widgets[i];
			s.push(w.write(inIndent, inOptions));
		}
		return s;
	}, getFreeze:function () {
		return true;
	}, isWidgetTypeAllowed:function () {
		return false;
	}});
	dojo.declare("wm.PopupItem", [wm.Item, wm.PopupItemsMixin], {popupLocation:"rb", hideDelay:200, init:function () {
		this.inherited(arguments);
		dojo.addClass(this.domNode, "wmitem-popup");
		this.initPopup();
	}, postInit:function () {
		this.inherited(arguments);
		this.connect(this.popup, "onItemClick", this, "onItemClick");
		this.popup.closeAll = true;
		this.connect(this.popup.domNode, "mouseover", this.popup, "cancelHide");
	}, _hideSiblingPopups:function () {
		var w, widgets = this.parent.widgets;
		for (var i in widgets) {
			w = widgets[i];
			if (w instanceof wm.PopupItem) {
				w.popup.hide();
			}
		}
	}, mouseover:function () {
		this.inherited(arguments);
		this._hideSiblingPopups();
		this.popup.show();
	}, mouseout:function (e) {
		this.inherited(arguments);
		if (e.relatedTarget != this.parent.domNode && dojo.isDescendant(e.relatedTarget, this.parent.domNode)) {
			this.popup.delayedHide(this.hideDelay);
		}
	}, _clicked:function () {
		this.popup.hide();
	}, onItemClick:function (inEvent) {
	}});
	dojo.declare("wm.PopupButton", [wm.ToolButton, wm.PopupItemsMixin], {init:function () {
		this.inherited(arguments);
		this.initPopup();
	}, postInit:function () {
		this.inherited(arguments);
		this.addPopupItems();
	}, onclick:function () {
		if (this.popup) {
			var showing = this.popup.showing;
			wm.Popup.closeAll();
			if (!showing) {
				this.popup.show();
			}
		}
	}});
	wm.Popup.description = "Popup information.";
	wm.PopupButton.description = "Button with menu.";
}
if (!dojo._hasResource["wm.base.widget.dijit.Dijit"]) {
	dojo._hasResource["wm.base.widget.dijit.Dijit"] = true;
	dojo.provide("wm.base.widget.dijit.Dijit");
	dojo.addOnLoad(function () {
		var invisible = function (inId) {
			var n = dojo.byId(inId);
			n && (n.style.visibility = "hidden");
		};
		invisible("a11yTestNode");
	});
	dojo.declare("wm.Dijit", wm.Box, {dijitClass:null, nonDijitProps:{name:1, flex:1, box:1, left:1, top:1, width:1, height:1, owner:1, parent:1, publishClass:1, dijitClass:1, domNode:1, id:1}, prepare:function (inProps) {
		this.dijitProps = {};
		for (var i in inProps) {
			if (!(i in this.nonDijitProps)) {
				this.dijitProps[i] = inProps[i];
			}
		}
		this.inherited(arguments);
	}, destroy:function () {
		this.dijit.destroy();
		this.inherited(arguments);
	}, setDomNode:function (inDomNode) {
		inDomNode = this.initDijit(inDomNode);
		this.inherited(arguments);
	}, initDijit:function (inDomNode) {
		var n = document.createElement("div");
		inDomNode.appendChild(n);
		var p = dojo.mixin({srcNodeRef:n}, this.getProperties());
		this.dijit = this.dijitClass ? new this.dijitClass(p) : null;
		this.setEvents();
		return inDomNode;
	}, getProperties:function () {
		return this.dijitProps;
	}, setEvents:function () {
		for (var n in this.dijit) {
			if (!n.indexOf("on")) {
				var e = "_" + n;
				if (!this[e]) {
					e = n;
				}
				if (this[e]) {
					this.connect(this.dijit, n, this, e);
				}
			}
		}
	}});
	wm.Object.extendSchema(wm.Dijit, {box:{ignore:1}});
	dojo.declare("wm.DijitWrapper", wm.Dijit, {});
}
if (!dojo._hasResource["wm.base.widget.dijit.Dijit_design"]) {
	dojo._hasResource["wm.base.widget.dijit.Dijit_design"] = true;
	dojo.provide("wm.base.widget.dijit.Dijit_design");
	wm.DijitWrapper.extend({designCreate:function () {
		this.inherited(arguments);
		this._designee = this.dijit;
	}, isNativeProp:function (inProp) {
		return inProp in this.nonDijitProps;
	}, getProp:function (n) {
		if (this.isNativeProp(n)) {
			this._designee = this;
		}
		var r = this.inherited(arguments);
		this._designee = this.dijit;
		return r;
	}, setProp:function (n, v) {
		if (this.isNativeProp(n)) {
			this._designee = this;
		}
		this.inherited(arguments);
		this._designee = this.dijit;
	}, dummy:0});
}
if (!dojo._hasResource["wm.base.widget.dijit.CheckBox"]) {
	dojo._hasResource["wm.base.widget.dijit.CheckBox"] = true;
	dojo.provide("wm.base.widget.dijit.CheckBox");
	dojo.declare("wm.dijit.CheckBox", wm.Dijit, {dijitClass:dijit.form.CheckBox});
}
if (!dojo._hasResource["wm.base.widget.dijit.Calendar"]) {
	dojo._hasResource["wm.base.widget.dijit.Calendar"] = true;
	dojo.provide("wm.base.widget.dijit.Calendar");
	dojo.extend(dijit._Calendar, {specialDates:null, getClassForDate:function (date) {
		if (!this.specialDates) {
			return;
		}
		var key = wm.dijit.Calendar.getDateKey(date);
		if (this.specialDates && this.specialDates[key]) {
			var classes = "";
			for (var i = 0; i < this.specialDates[key].length; i++) {
				classes += ((classes) ? " " : "") + this.specialDates[key][i].dateClass;
			}
			return classes;
		}
	}});
	dojo.declare("wm.dijit.Calendar", wm.Dijit, {displayDate:"", dijitClass:dijit._Calendar, width:"360px", height:"160px", dialog:null, useDialog:true, specialDates:null, setSpecialDates:function (inDataSet) {
		if (!inDataSet) {
			this.specialDates = {};
			this.refreshCalendar();
			return;
		}
		var dates = {};
		if (this.isDesignLoaded()) {
			if (!(inDataSet instanceof wm.Variable)) {
				var ds = this.getValueById(inDataSet);
				if (ds) {
					this.components.binding.addWire("", "specialDates", ds.getId());
					return;
				}
			}
		}
		if (dojo.isString(inDataSet)) {
			inDataSet = this.owner.getValue(inDataSet);
		}
		if (inDataSet instanceof wm.Variable) {
			inDataSet = inDataSet.getData();
		}
		for (var i = 0; i < inDataSet.length; i++) {
			var data = inDataSet[i];
			if (!data.date && data.dataValue) {
				data = data.dataValue;
			}
			var date = data.date;
			var key = wm.dijit.Calendar.getDateKey(date);
			if (!dates[key]) {
				dates[key] = [];
			}
			dates[key].push(data);
		}
		this.specialDates = dates;
		this.refreshCalendar();
	}, setSizeProp:function (n, v, inMinSize) {
		this.inherited(arguments);
		this.dijit._setStyleAttr({width:this.bounds.w + "px", height:this.bounds.h + "px"});
	}, refreshCalendar:function () {
		this.dijitProps.specialDates = this.specialDates;
		if (this.dijit) {
			this.dijit.destroy();
			this.initDijit(this.domNode);
			this.dijit._setStyleAttr({width:this.bounds.w + "px", height:this.bounds.h + "px"});
		}
	}, prepare:function () {
		this.inherited(arguments);
		if (this.specialDates) {
			this.setSpecialDates(this.specialDates);
		}
	}, init:function () {
		this.inherited(arguments);
		if (this.useDialog) {
			this.dialog = new wm.WidgetsJsDialog({width:200, height:160, modal:false, owner:this, widgets_data:{startContainer:["wm.Panel", {height:"20px", width:"100%", layoutKind:"left-to-right", horizontalAlign:"left", verticalAlign:"top"}, {}, {startHeading:["wm.Label", {width:"40px", height:"100%", caption:"FROM:"}], startDate:["wm.Label", {width:"100%", height:"100%"}]}], endContainer:["wm.Panel", {height:"20px", width:"100%", layoutKind:"left-to-right", horizontalAlign:"left", verticalAlign:"top"}, {}, {endHeading:["wm.Label", {width:"40px", height:"100%", caption:"TO:"}], endDate:["wm.Label", {width:"100%", height:"100%"}], }], description:["wm.Label", {width:"100%", height:"20px", autoSizeHeight:true, singleLine:false}]}});
			this.dialog.titleMinify.hide();
			this.dialog.titleMaxify.hide();
		}
	}, setDomNode:function () {
		this.inherited(arguments);
		var s = this.dijit.domNode.style;
		s.width = s.height = "100%";
	}, setDate:function (inValue) {
		this.dijit.setValue(wm.convertValueToDate(inValue));
	}, getDisplayDate:function () {
		return dojo.date.locale.format(this.dijit.value, {selector:"date"});
	}, setDisplayDate:function (inValue) {
		this.setDate(inValue);
	}, getDateValue:function () {
		var v = this.dijit.value;
		return v instanceof Date ? v.getTime() : null;
	}, setDateValue:function (inValue) {
		this.setDate(inValue);
	}, onValueSelected:function (inDate) {
		var key = wm.dijit.Calendar.getDateKey(inDate);
		if (this.useDialog && this.specialDates && this.specialDates[key]) {
			var data = this.specialDates[key][0];
			this.dialog.setTitle(key);
			this.dialog.show();
			var o = wm.positionAroundNode(this.domNode, "r");
			this.dialog.domNode.style.left = o.x + "px";
			this.dialog.domNode.style.top = o.y + "px";
			this.dialog.$.startContainer.setShowing(Boolean(data.startDate));
			this.dialog.$.endContainer.setShowing(Boolean(data.endDate));
			this.dialog.$.startDate.setCaption(wm.dijit.Calendar.getTime(data.startDate));
			this.dialog.$.endDate.setCaption(wm.dijit.Calendar.getTime(data.endDate));
			this.dialog.$.description.setCaption(data.description);
		} else {
			if (this.useDialog && this.dialog.showing) {
				this.dialog.dismiss();
			}
		}
		this.setValue("dateValue", inDate instanceof Date ? inDate.getTime() : null);
	}});
	wm.Object.extendSchema(wm.dijit.Calendar, {disabled:{ignore:1}, specialDates:{readonly:true, group:"data", order:0, type:"wm.Variable", isList:true, bindTarget:true}, useDialog:{group:"data", order:1, type:"boolean"}, dateValue:{ignore:1, bindable:1, type:"Date"}});
	wm.dijit.Calendar.extend({scrim:true, makePropEdit:function (inName, inValue, inDefault) {
		switch (inName) {
		  case "specialDates":
			return new wm.propEdit.DataSetSelect({component:this, name:inName, value:this.dataSet ? this.dataSet.getId() : "", allowAllTypes:true, listMatch:true});
		}
		return this.inherited(arguments);
	}});
	wm.dijit.Calendar.getTime = function (date) {
		var hour = date.getHours();
		var ampm = "am";
		if (hour == 0) {
			hour = 12;
		} else {
			if (hour == 12) {
				ampm = "pm";
			} else {
				if (hour > 12) {
					hour = hour % 12;
					ampm = "pm";
				}
			}
		}
		return hour + ":" + date.getMinutes() + " " + ampm;
	};
	wm.dijit.Calendar.getDateKey = function (date) {
		return (date.getYear() + 1900) + "-" + (date.getMonth() + 1) + "-" + date.getDate();
	};
	wm.dijit.Calendar.description = "A monthly calendar.";
}
if (!dojo._hasResource["wm.base.widget.dijit.ProgressBar"]) {
	dojo._hasResource["wm.base.widget.dijit.ProgressBar"] = true;
	dojo.provide("wm.base.widget.dijit.ProgressBar");
	dojo.declare("wm.dijit.ProgressBar", wm.Dijit, {progress:10, indeterminate:false, dijitClass:dijit.ProgressBar, width:"20em", classNames:"wmprogressbar", renderBounds:function () {
		this.inherited(arguments);
		this.reflowDijit();
	}, init:function () {
		this.inherited(arguments);
		this.dijit.progress = this.progress;
		this.dijit.indeterminate = this.indeterminate;
		this.connect(this.dijit, "update", this, "reflowDijit");
		this.dijit.update();
	}, reflowDijit:function () {
		var b = dojo.contentBox(this.domNode);
		if (this.dijit) {
			dojo.marginBox(this.dijit.domNode, {h:b.h});
			dojo.marginBox(this.dijit.label, {h:b.h});
			this.dijit.label.style.lineHeight = b.h + "px";
		}
	}, setProgress:function (inProgress) {
		var p = Number(inProgress);
		this.progress = isNaN(p) ? 0 : p;
		this.dijit.progress = this.progress;
		this.dijit.update();
	}, getProgress:function () {
		return this.dijit.progress;
	}, setIndeterminate:function (inIndeterminate) {
		this.indeterminate = inIndeterminate;
		this.dijit.indeterminate = this.indeterminate;
		this.dijit.update();
	}, getIndeterminate:function () {
		return this.dijit.indeterminate;
	}, onChange:function () {
	}});
	wm.Object.extendSchema(wm.dijit.ProgressBar, {disabled:{ignore:1}, progress:{bindable:1}, indeterminate:{bindable:1}});
	wm.dijit.ProgressBar.extend({themeableDemoProps:{height:"40px"}});
}
if (!dojo._hasResource["wm.base.widget.dijit.ProgressBar_design"]) {
	dojo._hasResource["wm.base.widget.dijit.ProgressBar_design"] = true;
	dojo.provide("wm.base.widget.dijit.ProgressBar_design");
	wm.dijit.ProgressBar.description = "Display a meter.";
	dojo.extend(wm.dijit.ProgressBar, {scrim:true});
}
if (!dojo._hasResource["wm.base.widget.dijit.Grid"]) {
	dojo._hasResource["wm.base.widget.dijit.Grid"] = true;
	dojo.provide("wm.base.widget.dijit.Grid");
	dojo.declare("wm.dijit.Grid", wm.Dijit, {dijitClass:dojox.Grid, width:"100%", height:"100%", init:function () {
		this.inherited(arguments);
	}, renderBounds:function () {
		this.inherited(arguments);
		this.resizeDijit();
	}, resizeDijit:function () {
		this.dijit.sizeChange();
	}});
}
if (!dojo._hasResource["wm.base.widget.DataGrid"]) {
	dojo._hasResource["wm.base.widget.DataGrid"] = true;
	dojo.provide("wm.base.widget.DataGrid");
	dojo.declare("wm.MavericksModel", dojox.grid.data.Model, {maxObjectDepth:5, allChange:function () {
		this.notify("AllChange", arguments);
		this.notify("Change", arguments);
	}, setData:function (inData) {
		this.variable = inData;
		this.schemaToFields();
	}, _schemaToFields:function (inSchema, inName, inRelated, inDepth) {
		if (!inSchema || inDepth > this.maxObjectDepth) {
			return;
		}
		var p = inName ? inName + "." : "", inDepth = inDepth || 0;
		inDepth++;
		for (var i in inSchema) {
			var ti = inSchema[i], n = p + i;
			var field = {name:n.replace(/\./g, "_"), key:n, field:n, compare:wm.data.compare};
			if (ti.isList) {
				this.fields.set(this.fields.values.length, field);
			} else {
				if (wm.typeManager.isStructuredType(ti.type)) {
					if (!inRelated || inRelated && dojo.indexOf(inRelated, n) != -1) {
						var d = inRelated ? 0 : inDepth;
						this._schemaToFields(wm.typeManager.getTypeSchema(ti.type), n, inRelated, d);
					}
				} else {
					this.fields.set(this.fields.values.length, field);
				}
			}
		}
	}, schemaToFields:function () {
		this.fields.clear();
		if (this.variable) {
			this._schemaToFields(this.variable._dataSchema, "", this.variable.related);
		}
	}, getRowCount:function () {
		return this.variable && this.variable.isList && (this.variable.getCount() || 1);
	}, measure:function () {
		this.count = this.getRowCount();
		this.allChange();
	}, getRow:function (inRowIndex) {
		return this.variable.getItem(inRowIndex);
	}, getDatum:function (inRowIndex, inField) {
		var i = this.getRow(inRowIndex), f = i && (inField >= 0) && this.fields.values[inField];
		return f && (i.data[f.key] || i.getValue(f.key));
	}, setDatum:function (inDatum, inRowIndex, inField) {
		if (inDatum !== undefined) {
			var i = this.variable.getItem(inRowIndex);
			if (i) {
				i.beginUpdate();
				i.setValue(this.fields.values[inField].key, inDatum);
				i.endUpdate();
				this.notify("DatumChange", arguments);
			}
		}
	}, beginModifyRow:function (inRowIndex) {
	}, endModifyRow:function (inRowIndex) {
	}, cancelModifyRow:function (inRowIndex) {
		this.allChange();
	}, sort:function () {
		this.variable.sort(this.makeComparator(arguments));
	}, generateComparator:function (inCompare, inField, inTrueForAscend, inSubCompare) {
		return function (a, b) {
			a = a.getValue(inField);
			b = b.getValue(inField);
			var ineq = inCompare(a, b);
			return ineq ? (inTrueForAscend ? ineq : -ineq) : inSubCompare && inSubCompare(a, b);
		};
	}});
	dojo.declare("wm.DataGridColumn", wm.Component, {autoSize:false, dataExpression:"", field:"", caption:"", columnWidth:"120px", display:"", format:"(details)", index:0, showing:true, addColumn:"(click to add column)", removeColumn:"(click to remove)", init:function () {
		this._cupdating = true;
		delete this.format;
		this.caption = this.label || this.caption;
		delete this.label;
		this.inherited(arguments);
		this.setDisplay(this.display);
	}, setField:function (inField) {
		this.field = inField;
		this.caption = this.caption || this.field;
	}, setIndex:function (inIndex) {
		this.owner.setColumnIndex(this, inIndex);
	}, setColumnWidth:function (inColumnWidth) {
		this.columnWidth = inColumnWidth;
		this.autoSize = false;
		this.owner.columnsChanged();
	}, formatChanged:function () {
		if (this.isDesignLoaded() && !this._cupdating) {
			this.owner.renderGrid();
		}
	}, valueChanged:function (inProp, inValue) {
		this.inherited(arguments);
	}, getCellProps:function () {
		var cell = {name:this.caption, field:this.field, dataExpression:this.dataExpression, hide:!this.showing};
		if (this.autoSize) {
			cell.width = "auto";
		} else {
			if (this.columnWidth) {
				cell.width = this.columnWidth;
			}
		}
		if (this.components.format) {
			dojo.mixin(cell, this.components.format.getColProps());
		}
		if (this.editor) {
			cell.editor = this.editor;
		}
		if (this.selectOptions) {
			cell.options = this.selectOptions;
		}
		if (this.dataExpression) {
			cell.get = this.getExpressionDatum;
			cell.formatter = this.gridFormatter;
		}
		return cell;
	}, postInit:function () {
		this.inherited(arguments);
		this._cupdating = false;
	}, getExpressionDatum:function (inRowIndex) {
		return wm.expression.getValue(this.dataExpression, this.grid.model.getRow(inRowIndex));
	}, gridFormatter:function (inValue) {
		if (typeof (inValue) == "string") {
			inValue = inValue.replace(/&lt;/g, "<");
		}
		return inValue;
	}, setDisplay:function (inDisplay) {
		var c = this.display = inDisplay;
		if (c.slice(0, 5) != "wm") {
			c = "wm." + c + "Formatter";
		}
		var ctor = dojo.getObject(c);
		if (!ctor) {
			this.display = "";
			ctor = wm.DataFormatter;
		}
		wm.fire(this.components.format, "destroy");
		new ctor({name:"format", owner:this});
		if (this.isDesignLoaded() && !this._cupdating) {
			this.owner.renderGrid();
		}
	}, onClick:function (inRowIndex, inCell, inEvent) {
	}});
	wm.DataGridColumn.extend({listProperties:function () {
		var p = this.inherited(arguments);
		p.columnWidth.ignore = this.autoSize;
		return p;
	}, set_index:function (inIndex) {
		var reselect = (studio.selected == this);
		this.setIndex(inIndex);
		if (reselect) {
			wm.onidle(this, function () {
				studio.select(null);
				studio.select(this);
			});
		}
	}, setCaption:function (inValue) {
		this.caption = inValue;
		this.owner.columnsChanged();
	}, isParentLocked:function () {
		return this.owner && this.owner.isParentLocked();
	}, isParentFrozen:function () {
		return this.owner && this.owner.isParentFrozen();
	}, makePropEdit:function (inName, inValue, inDefault) {
		switch (inName) {
		  case "addColumn":
		  case "removeColumn":
			return makeReadonlyButtonEdit(inName, inValue, inDefault);
		  case "field":
			return makeSelectPropEdit(inName, inValue, this.owner._listFields(), inDefault);
		  case "display":
			return makeSelectPropEdit(inName, inValue, [""].concat(wm.formatters), inDefault);
		  case "columnWidth":
			return new wm.propEdit.UnitValue({component:this, name:inName, value:inValue, options:this.owner._sizeUnits});
		}
		return this.inherited(arguments);
	}, editProp:function (inName, inValue, inInspector) {
		switch (inName) {
		  case "removeColumn":
			return this.owner.doRemoveColumn(this);
		  case "addColumn":
			return this.owner.doAddColumn();
		}
		return this.inherited(arguments);
	}});
	dojo.declare("wm.DataGrid", wm.dijit.Grid, {addColumn:"(click to add column)", autoColumns:"(auto add columns)", clearColumns:"(clear all columns)", updateNow:"(update now)", collection:"Columns", init:function () {
		this.inherited(arguments);
		this.dijit.canEdit = dojo.hitch(this, "canEdit");
		this._columns = [];
		this.selectedItem = new wm.Variable({name:"selectedItem", owner:this});
		if (this.isDesignLoaded()) {
			this.connect(this.dijit, "onHeaderCellClick", this, "headerCellDesignClick");
			this.connect(this.dijit, "setCellWidth", this, "setDesignCellWidth");
		}
		this.connect(this.dijit, "sort", this, "sort");
	}, doSetSizeBc:function () {
		if (this.size && !this.sizeUnits) {
			this.sizeUnits = "flex";
		}
		this.inherited(arguments);
	}, headerCellDesignClick:function (e) {
		var c = this._columns[e.cell.index];
		if (c) {
			studio.select(c);
		}
		dojo.stopEvent(e);
	}, setDesignCellWidth:function (inIndex, inUnitWidth) {
		this._columns[inIndex].columnWidth = inUnitWidth;
	}, postInit:function () {
		this.inherited(arguments);
		this._clearColumns();
		for (var i in this.components) {
			var c = this.components[i];
			if (c instanceof wm.DataGridColumn) {
				this._columns.push(c);
			}
		}
		this.renderGrid();
		dojo.publish(this.name + ".selectedItem-created");
	}, destroy:function () {
		if (this.isDestroyed) {
			return;
		}
		this.inherited(arguments);
		this._clearColumns();
		delete this.selectedItem;
		delete this.dataSet;
		this.destroyDijit();
		this.isDestroyed = true;
	}, destroyDijit:function () {
		if (this.dijit) {
			try {
				if (this.dijit.edit && this.dijit.edit.grid) {
					try {
						this.dijit.edit.grid.destroy();
					}
					catch (e) {
						console.info("destroy Error:", e);
					}
				}
				if (this.dijit.focus) {
					delete this.dijit.focus.grid;
				}
				if (this.dijit.views) {
					delete this.dijit.views.grid;
				}
				if (this.dijit.selection) {
					delete this.dijit.selection.grid;
				}
				if (this.dijit.rows) {
					delete this.dijit.rows.grid;
				}
				if (this.dijit.scroller) {
					delete this.dijit.scroller.contentNodes;
					delete this.dijit.scroller.pageNodes;
				}
				if (this.dijit.params) {
					delete this.dijit.params.parentNode;
					delete this.dijit.params.srcNodeRef;
				}
				if (this.dijit.layout) {
					delete this.dijit.layout.cells;
					delete this.dijit.layout.grid;
					delete this.dijit.layout.structure;
				}
				delete this.dijit._connects;
				delete this.dijit.parentNode;
				delete this.dijit.rows;
				delete this.dijit.lastFocusNode;
				delete this.dijit.edit;
				delete this.dijit.focus;
				delete this.dijit.structure;
				delete this.dijit.views;
				delete this.dijit.viewsHeaderNode;
				delete this.dijit.viewsNode;
			}
			catch (e) {
			}
		}
		if (this.dijitProps) {
			delete this.dijitProps.parentNode;
			delete this.dijitProps;
		}
	}, getCollection:function (inName) {
		var cn = [];
		for (var i in this.components) {
			var c = this.components[i];
			if (c instanceof wm.DataGridColumn) {
				cn.push(c);
			}
		}
		cn.sort(function (a, b) {
			return a.index - b.index;
		});
		return cn;
	}, columnsToStructure:function () {
		var subrow = [], rows = [], view = {rows:rows}, s = [view];
		this._columns.sort(this._columnsSorter);
		for (var i = 0, c; (c = this._columns[i]); i++) {
			var cell = c.getCellProps();
			this.onSetColumns(cell, i);
			subrow.push(cell);
		}
		this.adjustRowCellProps(subrow);
		rows.push(subrow);
		return s;
	}, adjustRowCellProps:function (inRow) {
		var flex = 0;
		dojo.forEach(inRow, function (c) {
			var u = wm.splitUnits(c.width);
			if (u.units == "flex") {
				flex += u.value;
			}
		});
		dojo.forEach(inRow, function (c) {
			var u = wm.splitUnits(c.width);
			if (flex && u.units == "flex" && u.value) {
				c.width = Math.round(u.value * 100 / flex) + "%";
			}
		});
	}, setStructure:function (inStructure) {
		this.onSetStructure(inStructure);
		this.dijit.setStructure(inStructure && inStructure.length ? inStructure : null);
	}, columnsChanged:function () {
		if (!this._loading && !this._updating) {
			this.setStructure(this.columnsToStructure());
			if (this.isDesignLoaded()) {
				studio.refreshComponentOnTree(this);
			}
		}
	}, setColumnIndex:function (inColumn, inIndex) {
		inColumn.index = inIndex - 0.5;
		this._columns.sort(this._columnsSorter);
		for (var i = 0, c; (c = this._columns[i]); i++) {
			c.index = i;
		}
		this.columnsChanged();
	}, _columnsSorter:function (inA, inB) {
		return inA.index - inB.index;
	}, _addFields:function (inList, inSchema, inName, inRelated, inDepth) {
		if (!inSchema || inDepth > this.dijit.model.maxObjectDepth) {
			return;
		}
		var p = inName ? inName + "." : "", inDepth = inDepth || 0;
		inDepth++;
		for (var i in inSchema) {
			var ti = inSchema[i], n = p + i;
			if (ti.isList) {
			} else {
				if (wm.typeManager.isStructuredType(ti.type)) {
					if (!inRelated || inRelated && dojo.indexOf(inRelated, n) != -1) {
						var d = inRelated ? 0 : inDepth;
						this._addFields(inList, wm.typeManager.getTypeSchema(ti.type), n, inRelated, d);
					}
				} else {
					inList.push(n);
				}
			}
		}
	}, _listFields:function (inList, inSchema, inName) {
		var list = [""];
		if (this.dataSet) {
			this._addFields(list, this.dataSet._dataSchema, "", (this.dataSet || 0).related);
		}
		return list;
	}, _clearColumns:function () {
		for (var i = 0, c; (c = this._columns[i]); i++) {
			c.destroy();
		}
		this._columns = [];
	}, _typifyColumn:function (ioColumn, inType) {
		var t = wm.typeManager.getPrimitiveType(inType) || inType;
		ioColumn.display = dojo.indexOf(wm.formatters, t) != -1 ? t : "";
	}, _hasColumnForField:function (inField) {
		for (var i = 0, columns = this._columns, c; (c = columns[i]); i++) {
			if (c.field == inField) {
				return true;
			}
		}
	}, _viewToColumns:function (inView, inName) {
		var p = inName ? inName + "." : "", col;
		for (var i = 0, f, field; f = inView[i]; i++) {
			field = f.dataIndex;
			if (!f.includeLists || this._hasColumnForField(field)) {
				continue;
			}
			this._index++;
			col = {name:f.dataIndex.replace(/\.(\S)/g, function (w) {
				return w.slice(1).toUpperCase();
			}), label:f.caption, field:field, owner:this, index:f.order === undefined ? this._index : f.order, autoSize:f.autoSize};
			if (!col.autoSize && f.width && f.widthUnits) {
				col.columnWidth = f.width + f.widthUnits;
			}
			this._typifyColumn(col, f.displayType);
			this._adjustColumnProps(col);
			this._addColumn(col);
		}
	}, _schemaToColumns:function (inSchema, inName) {
		if (!inSchema) {
			return;
		}
		var p = inName ? inName + "." : "";
		for (var i in inSchema) {
			var ti = inSchema[i], n = p + i;
			if (this._hasColumnForField(n)) {
				continue;
			}
			if (ti.isList) {
			} else {
				if (wm.typeManager.isStructuredType(ti.type)) {
				} else {
					this._index++;
					var name = n.replace(/\./g, "_");
					var col = {name:name, label:n, field:n, owner:this, index:this._index};
					this._typifyColumn(col, ti.type);
					this._adjustColumnProps(col);
					this._addColumn(col);
				}
			}
		}
	}, _adjustColumnProps:function (inColProps) {
		var name = inColProps.name || "column";
		name = name.match(/[0-9]$/) ? name : name + 1;
		name = this.getUniqueName(name);
		inColProps.name = name;
	}, _addColumn:function (inColProps) {
		this._columns.push(new wm.DataGridColumn(inColProps));
	}, _getStartColIndex:function () {
		var m = 0;
		dojo.forEach(this._columns, function (c) {
			m = Math.max(m, c.index);
		});
		return m == 0 ? m : m++;
	}, dataSetToColumns:function () {
		this._updating = true;
		if (this.dataSet) {
			this._index = this._getStartColIndex();
			if (this.dataSet.liveView && this.dataSet.liveView.service) {
				this._viewToColumns(this.dataSet.getViewListFields(), "");
			} else {
				this._schemaToColumns(this.dataSet._dataSchema, "");
			}
		}
		this._updating = false;
		if (this.isDesignLoaded()) {
			studio.refreshComponentOnTree(this);
		}
	}, createDefaultColumns:function () {
		var col = {name:"column1", autoSize:true, owner:this};
		this._adjustColumnProps(col);
		this._addColumn(col);
	}, _hasDefaultColumns:function () {
		var c = this._columns[0];
		return (!c || (!c.field && !c.dataExpression) && this._columns.length == 1);
	}, setDataSet:function (inDataSet) {
		var d = this.dataSet = inDataSet;
		this.dijit.setModel(new wm.MavericksModel(null, d));
		if (d && this._hasDefaultColumns()) {
			this._clearColumns();
			this.dataSetToColumns();
		}
		this.renderGrid();
	}, preRender:function () {
		this.dataSetToSelectedItem();
		if (this._columns.length == 0) {
			this.createDefaultColumns();
		}
		this._lastSort = this.dijit.sortInfo;
		this._lastSelectedIndex = this.getSelectedIndex();
		this.dijit.sortInfo = 0;
		this.clearSelection();
	}, renderGrid:function () {
		if (!this._loading) {
			this.preRender();
			this.onBeforeRender();
			this.setStructure(this.columnsToStructure());
			this.onAfterRender();
		}
	}, select:function (inIndex) {
		this.dijit.selection.select(inIndex);
	}, clearSelection:function () {
		this.dijit.selection.clear();
		this.updateSelected();
	}, hasSelection:function () {
		return Boolean(this.dijit.selection.getFirstSelected() != -1);
	}, getSelectedIndex:function () {
		return this.dijit.selection.selectedIndex;
	}, getEmptySelection:function () {
		return !this.hasSelection();
	}, dataSetToSelectedItem:function () {
		this.selectedItem.setLiveView((this.dataSet || 0).liveView);
		this.selectedItem.setType(this.dataSet ? this.dataSet.type : "any");
	}, updateSelected:function () {
		if (!this.selectedItem) {
			return;
		}
		var s = this.dijit.selection.selectedIndex;
		this.selected = this.dataSet && s >= 0 ? this.dataSet.getItem(s) : null;
		if (this.selected) {
			this.selectedItem.setData(this.selected);
		} else {
			this.selectedItem.clearData();
		}
		this.setValue("emptySelection", !this.hasSelection());
	}, onCellClick:function (inEvent) {
		if (inEvent.cell) {
			var i = inEvent.cell.index;
			var c = this._columns[i];
			wm.fire(c, "onClick", [inEvent.rowIndex, inEvent.cell, inEvent]);
		}
	}, onHeaderCellClick:function (inEvent) {
	}, onRowDblClick:function (inEvent) {
	}, _onSelected:function (inIndex) {
		wm.job(this.getRuntimeId(), 250, dojo.hitch(this, "onSelected", inIndex));
	}, _onSelectionChanged:function () {
		wm.job(this.getRuntimeId() + "-selectionChanged", 250, dojo.hitch(this, "onSelectionChanged"));
	}, onSelectionChanged:function () {
	}, onSelected:function (inIndex) {
		this.updateSelected();
	}, _onDeselected:function (inIndex) {
		wm.job(this.getRuntimeId(), 250, dojo.hitch(this, "onDeselected", inIndex));
	}, onDeselected:function (inIndex) {
		this.updateSelected();
	}, onSetColumns:function (inColumn, inIndex) {
	}, onSetStructure:function (inStructure) {
	}, onBeforeRender:function () {
	}, onAfterRender:function () {
	}, update:function () {
		var ds = this.getValueById((this.components.binding.wires["dataSet"] || 0).source);
		wm.fire(ds, "update");
	}, canEdit:function (inCell, inRowIndex) {
		ioEdit = {canEdit:Boolean(inCell.editor)};
		this.onCanEdit(ioEdit, inCell, inRowIndex);
		return ioEdit.canEdit;
	}, onCanEdit:function (ioEdit, inCell, inRowIndex) {
	}, sort:function () {
		this.onSort(this.dijit.getSortField());
	}, onSort:function (inSortInfo) {
	}});
	wm.DataGrid.extend({set_dataSet:function (inDataSet) {
		if (inDataSet && !(inDataSet instanceof wm.Variable)) {
			var ds = this.getValueById(inDataSet);
			if (ds) {
				this.components.binding.addWire("", "dataSet", ds.getId());
			}
		} else {
			this.setDataSet(inDataSet);
		}
	}, doAddColumn:function (inColumn) {
		var col = {name:"column1", index:this._columns.length, label:"", owner:this};
		if (!this._columns.length) {
			col.columnWidth = "auto";
		}
		this._adjustColumnProps(col);
		this._addColumn(col);
		this.columnsChanged();
		if (this.isDesignLoaded()) {
			var i = this._columns.length - 1;
			var c = (i >= 0 ? this._columns[i] : this);
			studio.select(c);
		}
	}, doRemoveColumn:function (inColumn) {
		inColumn.destroy();
		this._columns = [];
		this.loaded();
		this.columnsChanged();
		if (this.isDesignLoaded()) {
			var i = inColumn.index - 1;
			var c = this._columns[i < 0 ? 0 : i] || this;
			studio.select(c);
		}
	}, doClearColumns:function () {
		this._clearColumns();
		this.renderGrid();
	}, doAutoColumns:function () {
		this._clearColumns();
		this.dataSetToColumns();
		this.renderGrid();
	}, makePropEdit:function (inName, inValue, inDefault) {
		switch (inName) {
		  case "addColumn":
		  case "autoColumns":
		  case "clearColumns":
		  case "updateNow":
			return makeReadonlyButtonEdit(inName, inValue, inDefault);
		  case "dataSet":
			return new wm.propEdit.DataSetSelect({component:this, name:inName, value:this.dataSet ? this.dataSet.getId() : "", allowAllTypes:true, listMatch:true});
		}
		return this.inherited(arguments);
	}, editProp:function (inName, inValue, inInspector) {
		switch (inName) {
		  case "addColumn":
			return this.doAddColumn();
		  case "autoColumns":
			return this.doAutoColumns();
		  case "clearColumns":
			return this.doClearColumns();
		  case "updateNow":
			return this.update();
		}
		return this.inherited(arguments);
	}});
	wm.Object.extendSchema(wm.DataGridColumn, {caption:{group:"common", order:100, focus:1}, addColumn:{group:"operation", order:10}, removeColumn:{group:"operation", order:20}, autoSize:{group:"layout", order:10}, columnWidth:{group:"layout", order:20}, index:{group:"layout", order:30}, field:{group:"data", order:10}, dataExpression:{group:"data", order:15}, display:{group:"data", order:20}, format:{group:"data", order:30, categoryParent:"Properties", categoryProps:{component:"format"}}, showing:{ignore:1}});
	wm.Object.extendSchema(wm.DataGrid, {selectedItem:{ignore:true, isObject:true, bindSource:true, simpleBindProp:true}, emptySelection:{ignore:true, bindSource:1, type:"Boolean"}, dataSet:{readonly:true, group:"data", order:0, type:"wm.Variable", isList:true, bindTarget:true}, addColumn:{group:"operation", order:1}, autoColumns:{group:"operation", order:5}, clearColumns:{group:"operation", order:10}, updateNow:{group:"operation", order:15}, collection:{ignore:true}, disabled:{ignore:true}});
}
if (!dojo._hasResource["wm.base.widget.Toolbar"]) {
	dojo._hasResource["wm.base.widget.Toolbar"] = true;
	dojo.provide("wm.base.widget.Toolbar");
	dojo.declare("wm.Toolbar", wm.Panel, {box:"h", boxPosition:"bottomRight", _classes:{domNode:["wm_Padding_4px"]}, height:"28px", init:function () {
		this.inherited(arguments);
		this.initContents();
		dojo.connect(this.domNode, "onclick", this, "click");
	}, initContents:function () {
		this.makeButtons(this.buttonList);
	}, makeButtons:function (inButtonList) {
		this.buttons = this.$$ = {};
		if (inButtonList) {
			var l = inButtonList.length;
			dojo.forEach(inButtonList, function (n, i) {
				var b = this.buttons[n] = new wm.Button({owner:this, parent:this, caption:n, name:"button" + i});
				b.spacer = new wm.Spacer({owner:this, parent:this, width:"4px", name:"spacer" + i, showing:(i < l - 1)});
			}, this);
		}
	}, getButton:function (inName) {
		return this.buttons[inName];
	}, getLastShowingButton:function (inWidgets, inButton) {
		var a = dojo.indexOf(inWidgets, inButton);
		for (var i = (a == -1 ? inWidgets.length : a) - 1; w = inWidgets[i]; i--) {
			if (w.showing && (w instanceof wm.Button)) {
				return w;
			}
		}
	}, setButtonShowing:function (inName, inTrueToShow) {
		var b = this.getButton(inName);
		if (b) {
			b.setShowing(inTrueToShow);
			b.spacer.setShowing(inTrueToShow);
			var $$ = this.getOrderedWidgets(), l = this.getLastShowingButton($$);
			if (l) {
				l.spacer.hide();
				$$.splice(dojo.indexOf($$, l));
				var p = this.getLastShowingButton($$);
				if (p && p != l) {
					p.spacer.show();
				}
			}
		}
	}, click:function (e) {
		if (e.target.tagName == "BUTTON") {
			this.onclick(e.target.innerHTML);
		}
	}, onclick:function (inEvent, inCaption) {
	}, adjustChildProps:function (inCtor, inProps) {
		this.inherited(arguments);
		dojo.mixin(inProps, {owner:this});
	}, writeChildren:function () {
		return [];
	}});
	wm.Object.extendSchema(wm.Toolbar, {buttons:{ignore:1}});
}
if (!dojo._hasResource["wm.base.widget.Ticker"]) {
	dojo._hasResource["wm.base.widget.Ticker"] = true;
	dojo.provide("wm.base.widget.Ticker");
	dojo.declare("wm.Ticker", wm.Panel, {delay:20, motion:4, rewindDelay:200, _rewindWait:0, destroy:function () {
		this.stop();
		this.inherited(arguments);
	}, init:function () {
		this.inherited(arguments);
		this._animate = dojo.hitch(this, "animate");
		this.start();
	}, setDomNode:function (inNode) {
		if (this.domNode) {
			this.domNode._noscroll = false;
		}
		this.inherited(arguments);
		this.connect(this.domNode, "onmouseenter", this, "mouseenter");
		this.connect(this.domNode, "onmouseleave", this, "mouseleave");
		if (inNode) {
			inNode._noscroll = true;
		}
	}, mouseenter:function () {
		this._pause = true;
	}, mouseleave:function () {
		this._pause = false;
	}, start:function () {
		if (!this.job) {
			this.job = setInterval(this._animate, this.delay);
		}
	}, stop:function () {
		if (this.job) {
			clearInterval(this.job);
			this.job = null;
			this.setLeft(0);
		}
	}, getLeft:function (inLeft) {
		return this.domNode.scrollLeft;
	}, setLeft:function (inLeft) {
		this.domNode.scrollLeft = inLeft;
	}, animate:function () {
		if (this._pause) {
			return;
		}
		var l = this.getLeft();
		l += this.motion;
		this.setLeft(l);
		if (this._lastLeft == this.getLeft()) {
			if (this._rewindWait++ > this.rewindDelay) {
				this.setLeft(0);
				this._rewindWait = 0;
			}
		}
		this._lastLeft = this.getLeft();
	}});
	wm.Object.extendSchema(wm.Ticker, {startNow:{group:"operation", order:10}, stopNow:{group:"operation", order:20}, fitToContent:{ignore:1}, layoutKind:{ignore:1}});
	wm.Ticker.extend({themeable:false, startNow:"(click to start)", stopNow:"(click to stop)", designCreate:function () {
		this.inherited(arguments);
		this.stop();
	}, makePropEdit:function (inName, inValue, inDefault) {
		switch (inName) {
		  case "startNow":
		  case "stopNow":
			return makeReadonlyButtonEdit(inName, inValue, inDefault);
		}
		return this.inherited(arguments);
	}, editProp:function (inName, inValue, inInspector) {
		switch (inName) {
		  case "startNow":
			return this.start();
		  case "stopNow":
			return this.stop();
		}
		return this.inherited(arguments);
	}, _start:wm.Ticker.prototype.start, _stop:wm.Ticker.prototype.stop, start:function () {
		this.domNode._noscroll = true;
		this.reflowParent();
		this._start();
	}, stop:function () {
		this._stop();
		this.domNode._noscroll = false;
		this.reflowParent();
	}});
}
if (!dojo._hasResource["wm.base.widget.Composite"]) {
	dojo._hasResource["wm.base.widget.Composite"] = true;
	dojo.provide("wm.base.widget.Composite");
	wm.publishProperty = function (ctor, name, id, schema) {
		var pt = ctor.prototype;
		var parts = id.split(".");
		var target = parts.shift();
		var property = parts.join(".");
		if (schema.isEvent) {
			if (name.slice(0, 2) != "on") {
				name = "on" + name;
			}
			pt[name] = function (inSender) {
			};
		} else {
			if (target) {
				pt[name] = undefined;
				var capP = name.slice(0, 1).toUpperCase() + name.slice(1);
				pt["get" + capP] = function (inValue) {
					return this[name] = this.getValue(target).getValue(property);
				};
				pt["set" + capP] = function (inValue) {
					this.getValue(target).setValue(property, this[name] = inValue);
				};
				var pName = "source" + name;
				var pCapP = pName.slice(0, 1).toUpperCase() + pName.slice(1);
				pt["set" + pCapP] = function (inValue) {
					var t = this.getValue(target);
					if (t) {
						t._setProp(property, this[name] = inValue);
						this.valueChanged(name, inValue);
					}
				};
			}
		}
		var exSchema = {};
		if (schema) {
			exSchema[name] = schema;
		}
		wm.Object.extendSchema(ctor, exSchema);
		var pb = pt.published = (pt.published || {});
		pb[name] = {name:name, id:id, target:target, property:property};
	};
	wm.publish = function (inCtor, inProperties) {
		for (var i = 0, p; p = inProperties[i]; i++) {
			p.unshift(inCtor);
			wm.publishProperty.apply(this, p);
		}
	};
	dojo.declare("wm.CompositeMixin", null, {lock:true, init:function () {
		this.initDomNode();
		this.createComposite();
		this.inherited(arguments);
	}, postInit:function () {
		this.inherited(arguments);
		for (var p in this.published) {
			var pre = this.name + ".";
			var pub = this.published[p];
			if (this.schema[pub.name].isEvent) {
				var c = this.marshallFacade(pub.name);
				if (c.comp) {
					dojo.connect(c.comp, pub.property, this, pub.name);
				}
			} else {
				if (this[p] != this.constructor.prototype[p]) {
					this.setValue(p, this[p]);
				}
				new wm.Wire({target:this, targetProperty:"source" + pub.name, source:pre + pub.id, owner:this}).connectWire();
			}
		}
	}, marshallFacade:function (inName) {
		if (this.published) {
			var p = this.published[inName];
			if (p) {
				p.comp = this.getValue(p.target);
			}
			return p;
		}
	}, createComposite:function () {
		var c = dojo.clone(this.constructor.components);
		this.updateComponentsBinding(c);
		this.createComponents(c, this);
	}, updateComponentsBinding:function (inComponents) {
		this.buildComponentsDir(inComponents);
		this._updateComponentsBinding(inComponents);
	}, buildComponentsDir:function (inComponents) {
		this._dir = {};
		this._buildComponentsDir(inComponents);
	}, _buildComponentsDir:function (inComponents) {
		for (var i in inComponents) {
			this._dir[i] = true;
			this._buildComponentsDir(inComponents[i][3]);
		}
	}, _fixupValue:function (inValue) {
		var v = inValue;
		if (v && v.split) {
			v = v.split(".").shift();
			if (v == "*") {
				v = this.name;
			} else {
				if (this._dir[v]) {
					v = this.name + "." + inValue;
				}
			}
		}
		return v;
	}, _fixupExpression:function (inValue) {
		var pre = this.name + ".";
		var srcs = wm.expression.getSources(inValue);
		for (var i in srcs) {
			inValue = inValue.replace(srcs[i], pre + srcs[i]);
		}
		return inValue;
	}, _fixupProperties:function (inClass, inProps) {
		for (var p in inProps) {
			var v = inProps[p];
			switch (inClass) {
			  case "wm.Wire":
				switch (p) {
				  case "expression":
					v = this._fixupExpression(v);
					break;
				  case "source":
					v = this._fixupValue(v);
					break;
				}
				break;
			  default:
				switch (p) {
				  case "dataSet":
				  case "dataOutput":
				  case "liveSource":
				  case "defaultButton":
					v = this._fixupValue(v);
					break;
				}
				break;
			}
			inProps[p] = v;
		}
	}, _fixupEvents:function (inProps) {
		for (var p in inProps) {
			inProps[p] = this._fixupValue(inProps[p]);
		}
	}, _updateComponentsBinding:function (inComponents) {
		for (var i in inComponents) {
			var c = inComponents[i];
			this._fixupProperties(c[0], c[1]);
			this._fixupEvents(c[2]);
			this._updateComponentsBinding(c[3]);
		}
	}});
	wm.CompositeMixin.extend({makePropEdit:function (inName, inValue, inDefault) {
		var p = this.marshallFacade(inName);
		if (p && p.comp) {
			inDefault = p.comp.constructor.prototype[p.property];
			var e = p.comp.makePropEdit(p.property, inValue, inDefault);
			if (dojo.isString(e)) {
				return e.replace("name=\"" + p.property + "\"", "name=\"" + inName + "\"");
			} else {
				if (e) {
					e.name = inName;
					return e;
				}
			}
		}
		return this.inherited(arguments);
	}, editProp:function (inName, inValue, inInspector) {
		var p = this.marshallFacade(inName);
		if (p && p.comp) {
			return p.comp.editProp(p.property, inValue, inInspector);
		}
		return this.inherited(arguments);
	}, writeComponents:function (inIndent, inOptions) {
		var s = [];
		c = this.components.binding.write(inIndent);
		if (c) {
			s.push(c);
		}
		return s;
	}});
	dojo.declare("wm.Composite", [wm.Container, wm.CompositeMixin], {});
	wm.Object.extendSchema(wm.Composite, {box:{ignore:1}, boxPosition:{ignore:1}, freeze:{ignore:1}, lock:{ignore:1}});
}
if (!dojo._hasResource["wm.base.widget.Cards"]) {
	dojo._hasResource["wm.base.widget.Cards"] = true;
	dojo.provide("wm.base.widget.Cards");
	wm.define("wm.Cards", wm.Container, {borderColor:"brown", border:2, padding:8, constructor:function () {
		this.layout = new wm.layout.Cards();
		this.mover = new wm.design.Mover();
	}, loaded:function () {
		this.inherited(arguments);
		console.log(this.columns);
		var lc = [];
		var pc = this.columns;
		if (pc) {
			for (var i = 0, r; r = pc[i]; i++) {
				var lr = [];
				for (var j = 0, ci; ci = r[j]; j++) {
					lr.push(this.c$[ci]);
				}
				lc.push(lr);
			}
		}
		this.layout.columns = lc;
		delete this.columns;
	}, writeProps:function () {
		var props = this.inherited(arguments);
		var pc = [];
		var lc = this.layout.columns;
		for (var i = 0, r; r = lc[i]; i++) {
			var pr = [];
			for (var j = 0, c; c = r[j]; j++) {
				pr.push(this.indexOfControl(c));
			}
			pc.push(pr);
		}
		props.columns = pc;
		return props;
	}, beginDrag:function (e, inCard) {
		this.mover.beginDrag(e, {caption:inCard.name, control:inCard});
	}});
	wm.define("wm.Card", wm.Control, {backgroundColor:"lightblue", border:1, init:function () {
		this.inherited(arguments);
		this.dom.node.innerHTML = "<div style=\"text-align: center;\">" + this.name + "</div>";
		this.connect(this.dom.node, "onmousedown", this, "mousedown");
	}, mousedown:function (e) {
		this.parent.beginDrag(e, this);
	}});
	wm.define("wm.layout.Cards", wm.layout.Base, {margin:8, cardWidth:128, cardHeight:96, constructor:function () {
		this.columns = [];
		this.widths = [];
	}, flow:function (inContainer) {
		for (var i = 0, w; i < this.columns.length; i++) {
			w = this.cardWidth;
			for (var j = 0, c = this.columns[i], d; c && (d = c[j]); j++) {
				w = Math.max(w, d.bounds.w);
			}
			this.widths[i] = w;
		}
		var r = {l:0, t:0, w:0, h:0};
		for (var i = 0, r; i < this.columns.length; i++) {
			r.w = this.widths[i] || this.cardWidth;
			for (var j = 0, c = this.columns[i], d; c && (d = c[j]); j++) {
				r.h = d.bounds.h || this.cardHeight;
				d.setBounds(r);
				r.t += r.h + this.margin;
			}
			r.t = 0;
			r.l += r.w + this.margin;
		}
		inContainer.renderControls();
	}, remove:function (inControl) {
		for (var i = 0, c; i < this.columns.length; i++) {
			c = this.columns[i];
			for (var j = 0, d; c && (d = c[j]); j++) {
				if (d == inControl) {
					c.splice(j, 1);
					return;
				}
			}
		}
	}, insert:function (inTarget, inControl, inInfo) {
		this.remove(inControl);
		inControl.setBounds(inInfo.l, inInfo.t);
		var i = this.findColumnIndex(inInfo.l);
		var col = this.columns[i] || [];
		this.columns[i] = col;
		this.insertInColumn(inControl, col);
	}, findColumnIndex:function (inX) {
		var c = 0, w = 0;
		do {
			w += this.widths[c++] || this.cardWidth;
		} while (inX >= w);
		return c - 1;
	}, insertInColumn:function (inControl, inColumn) {
		for (var i = 0, d; (d = inColumn[i]); i++) {
			if (d.bounds.t >= inControl.bounds.t) {
				inColumn.splice(i, 0, inControl);
				return;
			}
		}
		inColumn.push(inControl);
	}});
}
if (!dojo._hasResource["dijit._editor.plugins.AlwaysShowToolbar"]) {
	dojo._hasResource["dijit._editor.plugins.AlwaysShowToolbar"] = true;
	dojo.provide("dijit._editor.plugins.AlwaysShowToolbar");
	dojo.declare("dijit._editor.plugins.AlwaysShowToolbar", dijit._editor._Plugin, {_handleScroll:true, setEditor:function (e) {
		if (!e.iframe) {
			console.log("Port AlwaysShowToolbar plugin to work with Editor without iframe");
			return;
		}
		this.editor = e;
		e.onLoadDeferred.addCallback(dojo.hitch(this, this.enable));
	}, enable:function (d) {
		this._updateHeight();
		this.connect(window, "onscroll", "globalOnScrollHandler");
		this.connect(this.editor, "onNormalizedDisplayChanged", "_updateHeight");
		return d;
	}, _updateHeight:function () {
		var e = this.editor;
		if (!e.isLoaded) {
			return;
		}
		if (e.height) {
			return;
		}
		var height = dojo.marginBox(e.editNode).h;
		if (dojo.isOpera) {
			height = e.editNode.scrollHeight;
		}
		if (!height) {
			height = dojo.marginBox(e.document.body).h;
		}
		if (height == 0) {
			console.debug("Can not figure out the height of the editing area!");
			return;
		}
		if (dojo.isIE <= 7 && this.editor.minHeight) {
			var min = parseInt(this.editor.minHeight);
			if (height < min) {
				height = min;
			}
		}
		if (height != this._lastHeight) {
			this._lastHeight = height;
			dojo.marginBox(e.iframe, {h:this._lastHeight});
		}
	}, _lastHeight:0, globalOnScrollHandler:function () {
		var isIE6 = dojo.isIE < 7;
		if (!this._handleScroll) {
			return;
		}
		var tdn = this.editor.toolbar.domNode;
		var db = dojo.body;
		if (!this._scrollSetUp) {
			this._scrollSetUp = true;
			this._scrollThreshold = dojo.position(tdn, true).y;
		}
		var scrollPos = dojo._docScroll().y;
		var s = tdn.style;
		if (scrollPos > this._scrollThreshold && scrollPos < this._scrollThreshold + this._lastHeight) {
			if (!this._fixEnabled) {
				var tdnbox = dojo.marginBox(tdn);
				this.editor.iframe.style.marginTop = tdnbox.h + "px";
				if (isIE6) {
					s.left = dojo.position(tdn).x;
					if (tdn.previousSibling) {
						this._IEOriginalPos = ["after", tdn.previousSibling];
					} else {
						if (tdn.nextSibling) {
							this._IEOriginalPos = ["before", tdn.nextSibling];
						} else {
							this._IEOriginalPos = ["last", tdn.parentNode];
						}
					}
					dojo.body().appendChild(tdn);
					dojo.addClass(tdn, "dijitIEFixedToolbar");
				} else {
					s.position = "fixed";
					s.top = "0px";
				}
				dojo.marginBox(tdn, {w:tdnbox.w});
				s.zIndex = 2000;
				this._fixEnabled = true;
			}
			var eHeight = (this.height) ? parseInt(this.editor.height) : this.editor._lastHeight;
			s.display = (scrollPos > this._scrollThreshold + eHeight) ? "none" : "";
		} else {
			if (this._fixEnabled) {
				this.editor.iframe.style.marginTop = "";
				s.position = "";
				s.top = "";
				s.zIndex = "";
				s.display = "";
				if (isIE6) {
					s.left = "";
					dojo.removeClass(tdn, "dijitIEFixedToolbar");
					if (this._IEOriginalPos) {
						dojo.place(tdn, this._IEOriginalPos[1], this._IEOriginalPos[0]);
						this._IEOriginalPos = null;
					} else {
						dojo.place(tdn, this.editor.iframe, "before");
					}
				}
				s.width = "";
				this._fixEnabled = false;
			}
		}
	}, destroy:function () {
		this._IEOriginalPos = null;
		this._handleScroll = false;
		dojo.forEach(this._connects, dojo.disconnect);
		if (dojo.isIE < 7) {
			dojo.removeClass(this.editor.toolbar.domNode, "dijitIEFixedToolbar");
		}
	}});
}
if (!dojo._hasResource["dijit.ColorPalette"]) {
	dojo._hasResource["dijit.ColorPalette"] = true;
	dojo.provide("dijit.ColorPalette");
	dojo.declare("dijit.ColorPalette", [dijit._Widget, dijit._Templated], {defaultTimeout:500, timeoutChangeRate:0.9, palette:"7x10", value:null, _currentFocus:0, _xDim:null, _yDim:null, _palettes:{"7x10":[["white", "seashell", "cornsilk", "lemonchiffon", "lightyellow", "palegreen", "paleturquoise", "lightcyan", "lavender", "plum"], ["lightgray", "pink", "bisque", "moccasin", "khaki", "lightgreen", "lightseagreen", "lightskyblue", "cornflowerblue", "violet"], ["silver", "lightcoral", "sandybrown", "orange", "palegoldenrod", "chartreuse", "mediumturquoise", "skyblue", "mediumslateblue", "orchid"], ["gray", "red", "orangered", "darkorange", "yellow", "limegreen", "darkseagreen", "royalblue", "slateblue", "mediumorchid"], ["dimgray", "crimson", "chocolate", "coral", "gold", "forestgreen", "seagreen", "blue", "blueviolet", "darkorchid"], ["darkslategray", "firebrick", "saddlebrown", "sienna", "olive", "green", "darkcyan", "mediumblue", "darkslateblue", "darkmagenta"], ["black", "darkred", "maroon", "brown", "darkolivegreen", "darkgreen", "midnightblue", "navy", "indigo", "purple"]], "3x4":[["white", "lime", "green", "blue"], ["silver", "yellow", "fuchsia", "navy"], ["gray", "red", "purple", "black"]]}, _imagePaths:{"7x10":dojo.moduleUrl("dijit.themes", "a11y/colors7x10.png"), "3x4":dojo.moduleUrl("dijit.themes", "a11y/colors3x4.png")}, _paletteCoords:{"leftOffset":3, "topOffset":3, "cWidth":20, "cHeight":20}, templateString:dojo.cache("dijit", "templates/ColorPalette.html", "<div class=\"dijitInline dijitColorPalette\">\r\n\t<div class=\"dijitColorPaletteInner\" dojoAttachPoint=\"divNode\" waiRole=\"grid\"\">\r\n\t\t<img class=\"dijitColorPaletteUnder\" dojoAttachPoint=\"imageNode\" waiRole=\"presentation\" alt=\"\">\r\n\t</div>\r\n</div>\r\n"), _paletteDims:{"7x10":{"width":"206px", "height":"145px"}, "3x4":{"width":"86px", "height":"64px"}}, tabIndex:"0", buildRendering:function () {
		this.inherited(arguments);
		dojo.mixin(this.divNode.style, this._paletteDims[this.palette]);
		this.imageNode.setAttribute("src", this._imagePaths[this.palette].toString());
		var choices = this._palettes[this.palette];
		this.domNode.style.position = "relative";
		this._cellNodes = [];
		this.colorNames = dojo.i18n.getLocalization("dojo", "colors", this.lang);
		var url = this._blankGif, colorObject = new dojo.Color(), coords = this._paletteCoords;
		for (var row = 0; row < choices.length; row++) {
			var rowNode = dojo.create("div", {role:"row"}, this.divNode);
			for (var col = 0; col < choices[row].length; col++) {
				var color = choices[row][col], colorValue = colorObject.setColor(dojo.Color.named[color]);
				var cellNode = dojo.create("span", {"class":"dijitPaletteCell", tabIndex:"-1", title:this.colorNames[color], style:{top:coords.topOffset + (row * coords.cHeight) + "px", left:coords.leftOffset + (col * coords.cWidth) + "px"}});
				var imgNode = dojo.create("img", {src:url, "class":"dijitPaletteImg", alt:this.colorNames[color]}, cellNode);
				imgNode.color = colorValue.toHex();
				var imgStyle = imgNode.style;
				imgStyle.color = imgStyle.backgroundColor = imgNode.color;
				dojo.forEach(["Dijitclick", "MouseEnter", "MouseLeave", "Focus"], function (handler) {
					this.connect(cellNode, "on" + handler.toLowerCase(), "_onCell" + handler);
				}, this);
				dojo.place(cellNode, rowNode);
				dijit.setWaiRole(cellNode, "gridcell");
				cellNode.index = this._cellNodes.length;
				this._cellNodes.push(cellNode);
			}
		}
		this._xDim = choices[0].length;
		this._yDim = choices.length;
		var keyIncrementMap = {UP_ARROW:-this._xDim, DOWN_ARROW:this._xDim, RIGHT_ARROW:1, LEFT_ARROW:-1};
		for (var key in keyIncrementMap) {
			this._connects.push(dijit.typematic.addKeyListener(this.domNode, {charOrCode:dojo.keys[key], ctrlKey:false, altKey:false, shiftKey:false}, this, function () {
				var increment = keyIncrementMap[key];
				return function (count) {
					this._navigateByKey(increment, count);
				};
			}(), this.timeoutChangeRate, this.defaultTimeout));
		}
	}, postCreate:function () {
		this.inherited(arguments);
		this._currentFocus = this._cellNodes[0];
		dojo.attr(this._currentFocus, "tabIndex", this.tabIndex);
	}, focus:function () {
		dojo.addClass(this._currentFocus, "dijitPaletteCellHighlight");
		dijit.focus(this._currentFocus);
	}, onChange:function (color) {
	}, _onFocus:function () {
		dojo.addClass(this._currentFocus, "dijitPaletteCellHighlight");
		this.inherited(arguments);
	}, _onBlur:function () {
		dojo.attr(this._currentFocus, "tabIndex", "-1");
		dojo.removeClass(this._currentFocus, "dijitPaletteCellHighlight");
		this._currentFocus = this._cellNodes[0];
		dojo.attr(this._currentFocus, "tabIndex", this.tabIndex);
		this.inherited(arguments);
	}, _onCellDijitclick:function (evt) {
		var target = evt.currentTarget;
		this._selectColor(target);
		dojo.stopEvent(evt);
	}, _onCellMouseEnter:function (evt) {
		var target = evt.currentTarget;
		this._setCurrent(target);
	}, _onCellMouseLeave:function (evt) {
		dojo.removeClass(this._currentFocus, "dijitPaletteCellHighlight");
	}, _onCellFocus:function (evt) {
		this._setCurrent(evt.currentTarget);
	}, _setCurrent:function (node) {
		if ("_currentFocus" in this) {
			dojo.attr(this._currentFocus, "tabIndex", "-1");
			dojo.removeClass(this._currentFocus, "dijitPaletteCellHighlight");
		}
		this._currentFocus = node;
		if (node) {
			dojo.attr(node, "tabIndex", this.tabIndex);
			dojo.addClass(node, "dijitPaletteCellHighlight");
		}
	}, _selectColor:function (selectNode) {
		var img = selectNode.getElementsByTagName("img")[0];
		this.onChange(this.value = img.color);
	}, _navigateByKey:function (increment, typeCount) {
		if (typeCount == -1) {
			return;
		}
		var newFocusIndex = this._currentFocus.index + increment;
		if (newFocusIndex < this._cellNodes.length && newFocusIndex > -1) {
			var focusNode = this._cellNodes[newFocusIndex];
			this._setCurrent(focusNode);
			setTimeout(dojo.hitch(dijit, "focus", focusNode), 0);
		}
	}});
}
if (!dojo._hasResource["dijit._editor.plugins.TextColor"]) {
	dojo._hasResource["dijit._editor.plugins.TextColor"] = true;
	dojo.provide("dijit._editor.plugins.TextColor");
	dojo.declare("dijit._editor.plugins.TextColor", dijit._editor._Plugin, {buttonClass:dijit.form.DropDownButton, constructor:function () {
		this.dropDown = new dijit.ColorPalette();
		this.connect(this.dropDown, "onChange", function (color) {
			this.editor.execCommand(this.command, color);
		});
	}});
	dojo.subscribe(dijit._scopeName + ".Editor.getPlugin", null, function (o) {
		if (o.plugin) {
			return;
		}
		switch (o.args.name) {
		  case "foreColor":
		  case "hiliteColor":
			o.plugin = new dijit._editor.plugins.TextColor({command:o.args.name});
		}
	});
}
if (!dojo._hasResource["dijit._Contained"]) {
	dojo._hasResource["dijit._Contained"] = true;
	dojo.provide("dijit._Contained");
	dojo.declare("dijit._Contained", null, {getParent:function () {
		var parent = dijit.getEnclosingWidget(this.domNode.parentNode);
		return parent && parent.isContainer ? parent : null;
	}, _getSibling:function (which) {
		var node = this.domNode;
		do {
			node = node[which + "Sibling"];
		} while (node && node.nodeType != 1);
		return node && dijit.byNode(node);
	}, getPreviousSibling:function () {
		return this._getSibling("previous");
	}, getNextSibling:function () {
		return this._getSibling("next");
	}, getIndexInParent:function () {
		var p = this.getParent();
		if (!p || !p.getIndexOfChild) {
			return -1;
		}
		return p.getIndexOfChild(this);
	}});
}
if (!dojo._hasResource["dijit.layout._LayoutWidget"]) {
	dojo._hasResource["dijit.layout._LayoutWidget"] = true;
	dojo.provide("dijit.layout._LayoutWidget");
	dojo.declare("dijit.layout._LayoutWidget", [dijit._Widget, dijit._Container, dijit._Contained], {baseClass:"dijitLayoutContainer", isLayoutContainer:true, postCreate:function () {
		dojo.addClass(this.domNode, "dijitContainer");
		dojo.addClass(this.domNode, this.baseClass);
		this.inherited(arguments);
	}, startup:function () {
		if (this._started) {
			return;
		}
		this.inherited(arguments);
		var parent = this.getParent && this.getParent();
		if (!(parent && parent.isLayoutContainer)) {
			this.resize();
			this.connect(dojo.isIE ? this.domNode : dojo.global, "onresize", function () {
				this.resize();
			});
		}
	}, resize:function (changeSize, resultSize) {
		var node = this.domNode;
		if (changeSize) {
			dojo.marginBox(node, changeSize);
			if (changeSize.t) {
				node.style.top = changeSize.t + "px";
			}
			if (changeSize.l) {
				node.style.left = changeSize.l + "px";
			}
		}
		var mb = resultSize || {};
		dojo.mixin(mb, changeSize || {});
		if (!("h" in mb) || !("w" in mb)) {
			mb = dojo.mixin(dojo.marginBox(node), mb);
		}
		var cs = dojo.getComputedStyle(node);
		var me = dojo._getMarginExtents(node, cs);
		var be = dojo._getBorderExtents(node, cs);
		var bb = (this._borderBox = {w:mb.w - (me.w + be.w), h:mb.h - (me.h + be.h)});
		var pe = dojo._getPadExtents(node, cs);
		this._contentBox = {l:dojo._toPixelValue(node, cs.paddingLeft), t:dojo._toPixelValue(node, cs.paddingTop), w:bb.w - pe.w, h:bb.h - pe.h};
		this.layout();
	}, layout:function () {
	}, _setupChild:function (child) {
		dojo.addClass(child.domNode, this.baseClass + "-child");
		if (child.baseClass) {
			dojo.addClass(child.domNode, this.baseClass + "-" + child.baseClass);
		}
	}, addChild:function (child, insertIndex) {
		this.inherited(arguments);
		if (this._started) {
			this._setupChild(child);
		}
	}, removeChild:function (child) {
		dojo.removeClass(child.domNode, this.baseClass + "-child");
		if (child.baseClass) {
			dojo.removeClass(child.domNode, this.baseClass + "-" + child.baseClass);
		}
		this.inherited(arguments);
	}});
	dijit.layout.marginBox2contentBox = function (node, mb) {
		var cs = dojo.getComputedStyle(node);
		var me = dojo._getMarginExtents(node, cs);
		var pb = dojo._getPadBorderExtents(node, cs);
		return {l:dojo._toPixelValue(node, cs.paddingLeft), t:dojo._toPixelValue(node, cs.paddingTop), w:mb.w - (me.w + pb.w), h:mb.h - (me.h + pb.h)};
	};
	(function () {
		var capitalize = function (word) {
			return word.substring(0, 1).toUpperCase() + word.substring(1);
		};
		var size = function (widget, dim) {
			widget.resize ? widget.resize(dim) : dojo.marginBox(widget.domNode, dim);
			dojo.mixin(widget, dojo.marginBox(widget.domNode));
			dojo.mixin(widget, dim);
		};
		dijit.layout.layoutChildren = function (container, dim, children) {
			dim = dojo.mixin({}, dim);
			dojo.addClass(container, "dijitLayoutContainer");
			children = dojo.filter(children, function (item) {
				return item.layoutAlign != "client";
			}).concat(dojo.filter(children, function (item) {
				return item.layoutAlign == "client";
			}));
			dojo.forEach(children, function (child) {
				var elm = child.domNode, pos = child.layoutAlign;
				var elmStyle = elm.style;
				elmStyle.left = dim.l + "px";
				elmStyle.top = dim.t + "px";
				elmStyle.bottom = elmStyle.right = "auto";
				dojo.addClass(elm, "dijitAlign" + capitalize(pos));
				if (pos == "top" || pos == "bottom") {
					size(child, {w:dim.w});
					dim.h -= child.h;
					if (pos == "top") {
						dim.t += child.h;
					} else {
						elmStyle.top = dim.t + dim.h + "px";
					}
				} else {
					if (pos == "left" || pos == "right") {
						size(child, {h:dim.h});
						dim.w -= child.w;
						if (pos == "left") {
							dim.l += child.w;
						} else {
							elmStyle.left = dim.l + dim.w + "px";
						}
					} else {
						if (pos == "client") {
							size(child, dim);
						}
					}
				}
			});
		};
	})();
}
if (!dojo._hasResource["dojo.html"]) {
	dojo._hasResource["dojo.html"] = true;
	dojo.provide("dojo.html");
	(function () {
		var idCounter = 0, d = dojo;
		dojo.html._secureForInnerHtml = function (cont) {
			return cont.replace(/(?:\s*<!DOCTYPE\s[^>]+>|<title[^>]*>[\s\S]*?<\/title>)/ig, "");
		};
		dojo.html._emptyNode = dojo.empty;
		dojo.html._setNodeContent = function (node, cont) {
			d.empty(node);
			if (cont) {
				if (typeof cont == "string") {
					cont = d._toDom(cont, node.ownerDocument);
				}
				if (!cont.nodeType && d.isArrayLike(cont)) {
					for (var startlen = cont.length, i = 0; i < cont.length; i = startlen == cont.length ? i + 1 : 0) {
						d.place(cont[i], node, "last");
					}
				} else {
					d.place(cont, node, "last");
				}
			}
			return node;
		};
		dojo.declare("dojo.html._ContentSetter", null, {node:"", content:"", id:"", cleanContent:false, extractContent:false, parseContent:false, constructor:function (params, node) {
			dojo.mixin(this, params || {});
			node = this.node = dojo.byId(this.node || node);
			if (!this.id) {
				this.id = ["Setter", (node) ? node.id || node.tagName : "", idCounter++].join("_");
			}
			if (!(this.node || node)) {
				new Error(this.declaredClass + ": no node provided to " + this.id);
			}
		}, set:function (cont, params) {
			if (undefined !== cont) {
				this.content = cont;
			}
			if (params) {
				this._mixin(params);
			}
			this.onBegin();
			this.setContent();
			this.onEnd();
			return this.node;
		}, setContent:function () {
			var node = this.node;
			if (!node) {
				console.error("setContent given no node");
			}
			try {
				node = dojo.html._setNodeContent(node, this.content);
			}
			catch (e) {
				var errMess = this.onContentError(e);
				try {
					node.innerHTML = errMess;
				}
				catch (e) {
					console.error("Fatal " + this.declaredClass + ".setContent could not change content due to " + e.message, e);
				}
			}
			this.node = node;
		}, empty:function () {
			if (this.parseResults && this.parseResults.length) {
				dojo.forEach(this.parseResults, function (w) {
					if (w.destroy) {
						w.destroy();
					}
				});
				delete this.parseResults;
			}
			dojo.html._emptyNode(this.node);
		}, onBegin:function () {
			var cont = this.content;
			if (dojo.isString(cont)) {
				if (this.cleanContent) {
					cont = dojo.html._secureForInnerHtml(cont);
				}
				if (this.extractContent) {
					var match = cont.match(/<body[^>]*>\s*([\s\S]+)\s*<\/body>/im);
					if (match) {
						cont = match[1];
					}
				}
			}
			this.empty();
			this.content = cont;
			return this.node;
		}, onEnd:function () {
			if (this.parseContent) {
				this._parse();
			}
			return this.node;
		}, tearDown:function () {
			delete this.parseResults;
			delete this.node;
			delete this.content;
		}, onContentError:function (err) {
			return "Error occured setting content: " + err;
		}, _mixin:function (params) {
			var empty = {}, key;
			for (key in params) {
				if (key in empty) {
					continue;
				}
				this[key] = params[key];
			}
		}, _parse:function () {
			var rootNode = this.node;
			try {
				this.parseResults = dojo.parser.parse(rootNode, true);
			}
			catch (e) {
				this._onError("Content", e, "Error parsing in _ContentSetter#" + this.id);
			}
		}, _onError:function (type, err, consoleText) {
			var errText = this["on" + type + "Error"].call(this, err);
			if (consoleText) {
				console.error(consoleText, err);
			} else {
				if (errText) {
					dojo.html._setNodeContent(this.node, errText, true);
				}
			}
		}});
		dojo.html.set = function (node, cont, params) {
			if (undefined == cont) {
				console.warn("dojo.html.set: no cont argument provided, using empty string");
				cont = "";
			}
			if (!params) {
				return dojo.html._setNodeContent(node, cont, true);
			} else {
				var op = new dojo.html._ContentSetter(dojo.mixin(params, {content:cont, node:node}));
				return op.set();
			}
		};
	})();
}
if (!dojo._hasResource["dijit.layout.ContentPane"]) {
	dojo._hasResource["dijit.layout.ContentPane"] = true;
	dojo.provide("dijit.layout.ContentPane");
	dojo.declare("dijit.layout.ContentPane", dijit._Widget, {href:"", extractContent:false, parseOnLoad:true, preventCache:false, preload:false, refreshOnShow:false, loadingMessage:"<span class='dijitContentPaneLoading'>${loadingState}</span>", errorMessage:"<span class='dijitContentPaneError'>${errorState}</span>", isLoaded:false, baseClass:"dijitContentPane", doLayout:true, ioArgs:{}, isContainer:true, isLayoutContainer:true, onLoadDeferred:null, attributeMap:dojo.delegate(dijit._Widget.prototype.attributeMap, {title:[]}), postMixInProperties:function () {
		this.inherited(arguments);
		var messages = dojo.i18n.getLocalization("dijit", "loading", this.lang);
		this.loadingMessage = dojo.string.substitute(this.loadingMessage, messages);
		this.errorMessage = dojo.string.substitute(this.errorMessage, messages);
		if (!this.href && this.srcNodeRef && this.srcNodeRef.innerHTML) {
			this.isLoaded = true;
		}
	}, buildRendering:function () {
		this.inherited(arguments);
		if (!this.containerNode) {
			this.containerNode = this.domNode;
		}
	}, postCreate:function () {
		this.domNode.title = "";
		if (!dojo.attr(this.domNode, "role")) {
			dijit.setWaiRole(this.domNode, "group");
		}
		dojo.addClass(this.domNode, this.baseClass);
	}, startup:function () {
		if (this._started) {
			return;
		}
		var parent = dijit._Contained.prototype.getParent.call(this);
		this._childOfLayoutWidget = parent && parent.isLayoutContainer;
		this._needLayout = !this._childOfLayoutWidget;
		if (this.isLoaded) {
			dojo.forEach(this.getChildren(), function (child) {
				child.startup();
			});
		}
		if (this._isShown() || this.preload) {
			this._onShow();
		}
		this.inherited(arguments);
	}, _checkIfSingleChild:function () {
		var childNodes = dojo.query("> *", this.containerNode).filter(function (node) {
			return node.tagName !== "SCRIPT";
		}), childWidgetNodes = childNodes.filter(function (node) {
			return dojo.hasAttr(node, "dojoType") || dojo.hasAttr(node, "widgetId");
		}), candidateWidgets = dojo.filter(childWidgetNodes.map(dijit.byNode), function (widget) {
			return widget && widget.domNode && widget.resize;
		});
		if (childNodes.length == childWidgetNodes.length && candidateWidgets.length == 1) {
			this._singleChild = candidateWidgets[0];
		} else {
			delete this._singleChild;
		}
		dojo.toggleClass(this.containerNode, this.baseClass + "SingleChild", !!this._singleChild);
	}, setHref:function (href) {
		dojo.deprecated("dijit.layout.ContentPane.setHref() is deprecated. Use attr('href', ...) instead.", "", "2.0");
		return this.attr("href", href);
	}, _setHrefAttr:function (href) {
		this.cancel();
		this.onLoadDeferred = new dojo.Deferred(dojo.hitch(this, "cancel"));
		this.href = href;
		if (this._created && (this.preload || this._isShown())) {
			this._load();
		} else {
			this._hrefChanged = true;
		}
		return this.onLoadDeferred;
	}, setContent:function (data) {
		dojo.deprecated("dijit.layout.ContentPane.setContent() is deprecated.  Use attr('content', ...) instead.", "", "2.0");
		this.attr("content", data);
	}, _setContentAttr:function (data) {
		this.href = "";
		this.cancel();
		this.onLoadDeferred = new dojo.Deferred(dojo.hitch(this, "cancel"));
		this._setContent(data || "");
		this._isDownloaded = false;
		return this.onLoadDeferred;
	}, _getContentAttr:function () {
		return this.containerNode.innerHTML;
	}, cancel:function () {
		if (this._xhrDfd && (this._xhrDfd.fired == -1)) {
			this._xhrDfd.cancel();
		}
		delete this._xhrDfd;
		this.onLoadDeferred = null;
	}, uninitialize:function () {
		if (this._beingDestroyed) {
			this.cancel();
		}
		this.inherited(arguments);
	}, destroyRecursive:function (preserveDom) {
		if (this._beingDestroyed) {
			return;
		}
		this.inherited(arguments);
	}, resize:function (changeSize, resultSize) {
		if (!this._wasShown) {
			this._onShow();
		}
		this._resizeCalled = true;
		if (changeSize) {
			dojo.marginBox(this.domNode, changeSize);
		}
		var cn = this.containerNode;
		if (cn === this.domNode) {
			var mb = resultSize || {};
			dojo.mixin(mb, changeSize || {});
			if (!("h" in mb) || !("w" in mb)) {
				mb = dojo.mixin(dojo.marginBox(cn), mb);
			}
			this._contentBox = dijit.layout.marginBox2contentBox(cn, mb);
		} else {
			this._contentBox = dojo.contentBox(cn);
		}
		this._layoutChildren();
	}, _isShown:function () {
		if (this._childOfLayoutWidget) {
			if (this._resizeCalled && "open" in this) {
				return this.open;
			}
			return this._resizeCalled;
		} else {
			if ("open" in this) {
				return this.open;
			} else {
				var node = this.domNode;
				return (node.style.display != "none") && (node.style.visibility != "hidden") && !dojo.hasClass(node, "dijitHidden");
			}
		}
	}, _onShow:function () {
		if (this.href) {
			if (!this._xhrDfd && (!this.isLoaded || this._hrefChanged || this.refreshOnShow)) {
				this.refresh();
			}
		} else {
			if (!this._childOfLayoutWidget && this._needLayout) {
				this._layoutChildren();
			}
		}
		this.inherited(arguments);
		this._wasShown = true;
	}, refresh:function () {
		this.cancel();
		this.onLoadDeferred = new dojo.Deferred(dojo.hitch(this, "cancel"));
		this._load();
		return this.onLoadDeferred;
	}, _load:function () {
		this._setContent(this.onDownloadStart(), true);
		var self = this;
		var getArgs = {preventCache:(this.preventCache || this.refreshOnShow), url:this.href, handleAs:"text"};
		if (dojo.isObject(this.ioArgs)) {
			dojo.mixin(getArgs, this.ioArgs);
		}
		var hand = (this._xhrDfd = (this.ioMethod || dojo.xhrGet)(getArgs));
		hand.addCallback(function (html) {
			try {
				self._isDownloaded = true;
				self._setContent(html, false);
				self.onDownloadEnd();
			}
			catch (err) {
				self._onError("Content", err);
			}
			delete self._xhrDfd;
			return html;
		});
		hand.addErrback(function (err) {
			if (!hand.canceled) {
				self._onError("Download", err);
			}
			delete self._xhrDfd;
			return err;
		});
		delete this._hrefChanged;
	}, _onLoadHandler:function (data) {
		this.isLoaded = true;
		try {
			this.onLoadDeferred.callback(data);
			this.onLoad(data);
		}
		catch (e) {
			console.error("Error " + this.widgetId + " running custom onLoad code: " + e.message);
		}
	}, _onUnloadHandler:function () {
		this.isLoaded = false;
		try {
			this.onUnload();
		}
		catch (e) {
			console.error("Error " + this.widgetId + " running custom onUnload code: " + e.message);
		}
	}, destroyDescendants:function () {
		if (this.isLoaded) {
			this._onUnloadHandler();
		}
		var setter = this._contentSetter;
		dojo.forEach(this.getChildren(), function (widget) {
			if (widget.destroyRecursive) {
				widget.destroyRecursive();
			}
		});
		if (setter) {
			dojo.forEach(setter.parseResults, function (widget) {
				if (widget.destroyRecursive && widget.domNode && widget.domNode.parentNode == dojo.body()) {
					widget.destroyRecursive();
				}
			});
			delete setter.parseResults;
		}
		dojo.html._emptyNode(this.containerNode);
		delete this._singleChild;
	}, _setContent:function (cont, isFakeContent) {
		this.destroyDescendants();
		var setter = this._contentSetter;
		if (!(setter && setter instanceof dojo.html._ContentSetter)) {
			setter = this._contentSetter = new dojo.html._ContentSetter({node:this.containerNode, _onError:dojo.hitch(this, this._onError), onContentError:dojo.hitch(this, function (e) {
				var errMess = this.onContentError(e);
				try {
					this.containerNode.innerHTML = errMess;
				}
				catch (e) {
					console.error("Fatal " + this.id + " could not change content due to " + e.message, e);
				}
			})});
		}
		var setterParams = dojo.mixin({cleanContent:this.cleanContent, extractContent:this.extractContent, parseContent:this.parseOnLoad}, this._contentSetterParams || {});
		dojo.mixin(setter, setterParams);
		setter.set((dojo.isObject(cont) && cont.domNode) ? cont.domNode : cont);
		delete this._contentSetterParams;
		if (!isFakeContent) {
			dojo.forEach(this.getChildren(), function (child) {
				if (!this.parseOnLoad || child.getParent) {
					child.startup();
				}
			}, this);
			this._scheduleLayout();
			this._onLoadHandler(cont);
		}
	}, _onError:function (type, err, consoleText) {
		this.onLoadDeferred.errback(err);
		var errText = this["on" + type + "Error"].call(this, err);
		if (consoleText) {
			console.error(consoleText, err);
		} else {
			if (errText) {
				this._setContent(errText, true);
			}
		}
	}, _scheduleLayout:function () {
		if (this._isShown()) {
			this._layoutChildren();
		} else {
			this._needLayout = true;
		}
	}, _layoutChildren:function () {
		if (this.doLayout) {
			this._checkIfSingleChild();
		}
		if (this._singleChild && this._singleChild.resize) {
			var cb = this._contentBox || dojo.contentBox(this.containerNode);
			this._singleChild.resize({w:cb.w, h:cb.h});
		} else {
			dojo.forEach(this.getChildren(), function (widget) {
				if (widget.resize) {
					widget.resize();
				}
			});
		}
		delete this._needLayout;
	}, onLoad:function (data) {
	}, onUnload:function () {
	}, onDownloadStart:function () {
		return this.loadingMessage;
	}, onContentError:function (error) {
	}, onDownloadError:function (error) {
		return this.errorMessage;
	}, onDownloadEnd:function () {
	}});
}
if (!dojo._hasResource["dijit.form._FormMixin"]) {
	dojo._hasResource["dijit.form._FormMixin"] = true;
	dojo.provide("dijit.form._FormMixin");
	dojo.declare("dijit.form._FormMixin", null, {reset:function () {
		dojo.forEach(this.getDescendants(), function (widget) {
			if (widget.reset) {
				widget.reset();
			}
		});
	}, validate:function () {
		var didFocus = false;
		return dojo.every(dojo.map(this.getDescendants(), function (widget) {
			widget._hasBeenBlurred = true;
			var valid = widget.disabled || !widget.validate || widget.validate();
			if (!valid && !didFocus) {
				dijit.scrollIntoView(widget.containerNode || widget.domNode);
				widget.focus();
				didFocus = true;
			}
			return valid;
		}), function (item) {
			return item;
		});
	}, setValues:function (val) {
		dojo.deprecated(this.declaredClass + "::setValues() is deprecated. Use attr('value', val) instead.", "", "2.0");
		return this.attr("value", val);
	}, _setValueAttr:function (obj) {
		var map = {};
		dojo.forEach(this.getDescendants(), function (widget) {
			if (!widget.name) {
				return;
			}
			var entry = map[widget.name] || (map[widget.name] = []);
			entry.push(widget);
		});
		for (var name in map) {
			if (!map.hasOwnProperty(name)) {
				continue;
			}
			var widgets = map[name], values = dojo.getObject(name, false, obj);
			if (values === undefined) {
				continue;
			}
			if (!dojo.isArray(values)) {
				values = [values];
			}
			if (typeof widgets[0].checked == "boolean") {
				dojo.forEach(widgets, function (w, i) {
					w.attr("value", dojo.indexOf(values, w.value) != -1);
				});
			} else {
				if (widgets[0].multiple) {
					widgets[0].attr("value", values);
				} else {
					dojo.forEach(widgets, function (w, i) {
						w.attr("value", values[i]);
					});
				}
			}
		}
	}, getValues:function () {
		dojo.deprecated(this.declaredClass + "::getValues() is deprecated. Use attr('value') instead.", "", "2.0");
		return this.attr("value");
	}, _getValueAttr:function () {
		var obj = {};
		dojo.forEach(this.getDescendants(), function (widget) {
			var name = widget.name;
			if (!name || widget.disabled) {
				return;
			}
			var value = widget.attr("value");
			if (typeof widget.checked == "boolean") {
				if (/Radio/.test(widget.declaredClass)) {
					if (value !== false) {
						dojo.setObject(name, value, obj);
					} else {
						value = dojo.getObject(name, false, obj);
						if (value === undefined) {
							dojo.setObject(name, null, obj);
						}
					}
				} else {
					var ary = dojo.getObject(name, false, obj);
					if (!ary) {
						ary = [];
						dojo.setObject(name, ary, obj);
					}
					if (value !== false) {
						ary.push(value);
					}
				}
			} else {
				var prev = dojo.getObject(name, false, obj);
				if (typeof prev != "undefined") {
					if (dojo.isArray(prev)) {
						prev.push(value);
					} else {
						dojo.setObject(name, [prev, value], obj);
					}
				} else {
					dojo.setObject(name, value, obj);
				}
			}
		});
		return obj;
	}, isValid:function () {
		this._invalidWidgets = dojo.filter(this.getDescendants(), function (widget) {
			return !widget.disabled && widget.isValid && !widget.isValid();
		});
		return !this._invalidWidgets.length;
	}, onValidStateChange:function (isValid) {
	}, _widgetChange:function (widget) {
		var isValid = this._lastValidState;
		if (!widget || this._lastValidState === undefined) {
			isValid = this.isValid();
			if (this._lastValidState === undefined) {
				this._lastValidState = isValid;
			}
		} else {
			if (widget.isValid) {
				this._invalidWidgets = dojo.filter(this._invalidWidgets || [], function (w) {
					return (w != widget);
				}, this);
				if (!widget.isValid() && !widget.attr("disabled")) {
					this._invalidWidgets.push(widget);
				}
				isValid = (this._invalidWidgets.length === 0);
			}
		}
		if (isValid !== this._lastValidState) {
			this._lastValidState = isValid;
			this.onValidStateChange(isValid);
		}
	}, connectChildren:function () {
		dojo.forEach(this._changeConnections, dojo.hitch(this, "disconnect"));
		var _this = this;
		var conns = this._changeConnections = [];
		dojo.forEach(dojo.filter(this.getDescendants(), function (item) {
			return item.validate;
		}), function (widget) {
			conns.push(_this.connect(widget, "validate", dojo.hitch(_this, "_widgetChange", widget)));
			conns.push(_this.connect(widget, "_setDisabledAttr", dojo.hitch(_this, "_widgetChange", widget)));
		});
		this._widgetChange(null);
	}, startup:function () {
		this.inherited(arguments);
		this._changeConnections = [];
		this.connectChildren();
	}});
}
if (!dojo._hasResource["dijit._DialogMixin"]) {
	dojo._hasResource["dijit._DialogMixin"] = true;
	dojo.provide("dijit._DialogMixin");
	dojo.declare("dijit._DialogMixin", null, {attributeMap:dijit._Widget.prototype.attributeMap, execute:function (formContents) {
	}, onCancel:function () {
	}, onExecute:function () {
	}, _onSubmit:function () {
		this.onExecute();
		this.execute(this.attr("value"));
	}, _getFocusItems:function (dialogNode) {
		var elems = dijit._getTabNavigable(dojo.byId(dialogNode));
		this._firstFocusItem = elems.lowest || elems.first || dialogNode;
		this._lastFocusItem = elems.last || elems.highest || this._firstFocusItem;
		if (dojo.isMoz && this._firstFocusItem.tagName.toLowerCase() == "input" && dojo.getNodeProp(this._firstFocusItem, "type").toLowerCase() == "file") {
			dojo.attr(dialogNode, "tabIndex", "0");
			this._firstFocusItem = dialogNode;
		}
	}});
}
if (!dojo._hasResource["dijit.TooltipDialog"]) {
	dojo._hasResource["dijit.TooltipDialog"] = true;
	dojo.provide("dijit.TooltipDialog");
	dojo.declare("dijit.TooltipDialog", [dijit.layout.ContentPane, dijit._Templated, dijit.form._FormMixin, dijit._DialogMixin], {title:"", doLayout:false, autofocus:true, baseClass:"dijitTooltipDialog", _firstFocusItem:null, _lastFocusItem:null, templateString:dojo.cache("dijit", "templates/TooltipDialog.html", "<div waiRole=\"presentation\">\r\n\t<div class=\"dijitTooltipContainer\" waiRole=\"presentation\">\r\n\t\t<div class =\"dijitTooltipContents dijitTooltipFocusNode\" dojoAttachPoint=\"containerNode\" tabindex=\"-1\" waiRole=\"dialog\"></div>\r\n\t</div>\r\n\t<div class=\"dijitTooltipConnector\" waiRole=\"presentation\"></div>\r\n</div>\r\n"), postCreate:function () {
		this.inherited(arguments);
		this.connect(this.containerNode, "onkeypress", "_onKey");
		this.containerNode.title = this.title;
	}, orient:function (node, aroundCorner, corner) {
		var c = this._currentOrientClass;
		if (c) {
			dojo.removeClass(this.domNode, c);
		}
		c = "dijitTooltipAB" + (corner.charAt(1) == "L" ? "Left" : "Right") + " dijitTooltip" + (corner.charAt(0) == "T" ? "Below" : "Above");
		dojo.addClass(this.domNode, c);
		this._currentOrientClass = c;
	}, onOpen:function (pos) {
		this.orient(this.domNode, pos.aroundCorner, pos.corner);
		this._onShow();
		if (this.autofocus) {
			this._getFocusItems(this.containerNode);
			dijit.focus(this._firstFocusItem);
		}
	}, onClose:function () {
		this.onHide();
	}, _onKey:function (evt) {
		var node = evt.target;
		var dk = dojo.keys;
		if (evt.charOrCode === dk.TAB) {
			this._getFocusItems(this.containerNode);
		}
		var singleFocusItem = (this._firstFocusItem == this._lastFocusItem);
		if (evt.charOrCode == dk.ESCAPE) {
			setTimeout(dojo.hitch(this, "onCancel"), 0);
			dojo.stopEvent(evt);
		} else {
			if (node == this._firstFocusItem && evt.shiftKey && evt.charOrCode === dk.TAB) {
				if (!singleFocusItem) {
					dijit.focus(this._lastFocusItem);
				}
				dojo.stopEvent(evt);
			} else {
				if (node == this._lastFocusItem && evt.charOrCode === dk.TAB && !evt.shiftKey) {
					if (!singleFocusItem) {
						dijit.focus(this._firstFocusItem);
					}
					dojo.stopEvent(evt);
				} else {
					if (evt.charOrCode === dk.TAB) {
						evt.stopPropagation();
					}
				}
			}
		}
	}});
}
if (!dojo._hasResource["dijit.form._FormSelectWidget"]) {
	dojo._hasResource["dijit.form._FormSelectWidget"] = true;
	dojo.provide("dijit.form._FormSelectWidget");
	dojo.declare("dijit.form._FormSelectWidget", dijit.form._FormValueWidget, {multiple:false, options:null, store:null, query:null, queryOptions:null, onFetch:null, sortByLabel:true, loadChildrenOnOpen:false, getOptions:function (valueOrIdx) {
		var lookupValue = valueOrIdx, opts = this.options || [], l = opts.length;
		if (lookupValue === undefined) {
			return opts;
		}
		if (dojo.isArray(lookupValue)) {
			return dojo.map(lookupValue, "return this.getOptions(item);", this);
		}
		if (dojo.isObject(valueOrIdx)) {
			if (!dojo.some(this.options, function (o, idx) {
				if (o === lookupValue || (o.value && o.value === lookupValue.value)) {
					lookupValue = idx;
					return true;
				}
				return false;
			})) {
				lookupValue = -1;
			}
		}
		if (typeof lookupValue == "string") {
			for (var i = 0; i < l; i++) {
				if (opts[i].value === lookupValue) {
					lookupValue = i;
					break;
				}
			}
		}
		if (typeof lookupValue == "number" && lookupValue >= 0 && lookupValue < l) {
			return this.options[lookupValue];
		}
		return null;
	}, addOption:function (option) {
		if (!dojo.isArray(option)) {
			option = [option];
		}
		dojo.forEach(option, function (i) {
			if (i && dojo.isObject(i)) {
				this.options.push(i);
			}
		}, this);
		this._loadChildren();
	}, removeOption:function (valueOrIdx) {
		if (!dojo.isArray(valueOrIdx)) {
			valueOrIdx = [valueOrIdx];
		}
		var oldOpts = this.getOptions(valueOrIdx);
		dojo.forEach(oldOpts, function (i) {
			if (i) {
				this.options = dojo.filter(this.options, function (node, idx) {
					return (node.value !== i.value);
				});
				this._removeOptionItem(i);
			}
		}, this);
		this._loadChildren();
	}, updateOption:function (newOption) {
		if (!dojo.isArray(newOption)) {
			newOption = [newOption];
		}
		dojo.forEach(newOption, function (i) {
			var oldOpt = this.getOptions(i), k;
			if (oldOpt) {
				for (k in i) {
					oldOpt[k] = i[k];
				}
			}
		}, this);
		this._loadChildren();
	}, setStore:function (store, selectedValue, fetchArgs) {
		var oStore = this.store;
		fetchArgs = fetchArgs || {};
		if (oStore !== store) {
			dojo.forEach(this._notifyConnections || [], dojo.disconnect);
			delete this._notifyConnections;
			if (store && store.getFeatures()["dojo.data.api.Notification"]) {
				this._notifyConnections = [dojo.connect(store, "onNew", this, "_onNewItem"), dojo.connect(store, "onDelete", this, "_onDeleteItem"), dojo.connect(store, "onSet", this, "_onSetItem")];
			}
			this.store = store;
		}
		this._onChangeActive = false;
		if (this.options && this.options.length) {
			this.removeOption(this.options);
		}
		if (store) {
			var cb = function (items) {
				if (this.sortByLabel && !fetchArgs.sort && items.length) {
					items.sort(dojo.data.util.sorter.createSortFunction([{attribute:store.getLabelAttributes(items[0])[0]}], store));
				}
				if (fetchArgs.onFetch) {
					items = fetchArgs.onFetch(items);
				}
				dojo.forEach(items, function (i) {
					this._addOptionForItem(i);
				}, this);
				this._loadingStore = false;
				this.attr("value", (("_pendingValue" in this) ? this._pendingValue : selectedValue));
				delete this._pendingValue;
				if (!this.loadChildrenOnOpen) {
					this._loadChildren();
				} else {
					this._pseudoLoadChildren(items);
				}
				this._fetchedWith = opts;
				this._lastValueReported = this.multiple ? [] : null;
				this._onChangeActive = true;
				this.onSetStore();
				this._handleOnChange(this.value);
			};
			var opts = dojo.mixin({onComplete:cb, scope:this}, fetchArgs);
			this._loadingStore = true;
			store.fetch(opts);
		} else {
			delete this._fetchedWith;
		}
		return oStore;
	}, _setValueAttr:function (newValue, priorityChange) {
		if (this._loadingStore) {
			this._pendingValue = newValue;
			return;
		}
		var opts = this.getOptions() || [];
		if (!dojo.isArray(newValue)) {
			newValue = [newValue];
		}
		dojo.forEach(newValue, function (i, idx) {
			if (!dojo.isObject(i)) {
				i = i + "";
			}
			if (typeof i === "string") {
				newValue[idx] = dojo.filter(opts, function (node) {
					return node.value === i;
				})[0] || {value:"", label:""};
			}
		}, this);
		newValue = dojo.filter(newValue, function (i) {
			return i && i.value;
		});
		if (!this.multiple && (!newValue[0] || !newValue[0].value) && opts.length) {
			newValue[0] = opts[0];
		}
		dojo.forEach(opts, function (i) {
			i.selected = dojo.some(newValue, function (v) {
				return v.value === i.value;
			});
		});
		var val = dojo.map(newValue, function (i) {
			return i.value;
		}), disp = dojo.map(newValue, function (i) {
			return i.label;
		});
		this.value = this.multiple ? val : val[0];
		this._setDisplay(this.multiple ? disp : disp[0]);
		this._updateSelection();
		this._handleOnChange(this.value, priorityChange);
	}, _getDisplayedValueAttr:function () {
		var val = this.attr("value");
		if (!dojo.isArray(val)) {
			val = [val];
		}
		var ret = dojo.map(this.getOptions(val), function (v) {
			if (v && "label" in v) {
				return v.label;
			} else {
				if (v) {
					return v.value;
				}
			}
			return null;
		}, this);
		return this.multiple ? ret : ret[0];
	}, _getValueDeprecated:false, getValue:function () {
		return this._lastValue;
	}, undo:function () {
		this._setValueAttr(this._lastValueReported, false);
	}, _loadChildren:function () {
		if (this._loadingStore) {
			return;
		}
		dojo.forEach(this._getChildren(), function (child) {
			child.destroyRecursive();
		});
		dojo.forEach(this.options, this._addOptionItem, this);
		this._updateSelection();
	}, _updateSelection:function () {
		this.value = this._getValueFromOpts();
		var val = this.value;
		if (!dojo.isArray(val)) {
			val = [val];
		}
		if (val && val[0]) {
			dojo.forEach(this._getChildren(), function (child) {
				var isSelected = dojo.some(val, function (v) {
					return child.option && (v === child.option.value);
				});
				dojo.toggleClass(child.domNode, this.baseClass + "SelectedOption", isSelected);
				dijit.setWaiState(child.domNode, "selected", isSelected);
			}, this);
		}
		this._handleOnChange(this.value);
	}, _getValueFromOpts:function () {
		var opts = this.getOptions() || [];
		if (!this.multiple && opts.length) {
			var opt = dojo.filter(opts, function (i) {
				return i.selected;
			})[0];
			if (opt && opt.value) {
				return opt.value;
			} else {
				opts[0].selected = true;
				return opts[0].value;
			}
		} else {
			if (this.multiple) {
				return dojo.map(dojo.filter(opts, function (i) {
					return i.selected;
				}), function (i) {
					return i.value;
				}) || [];
			}
		}
		return "";
	}, _onNewItem:function (item, parentInfo) {
		if (!parentInfo || !parentInfo.parent) {
			this._addOptionForItem(item);
		}
	}, _onDeleteItem:function (item) {
		var store = this.store;
		this.removeOption(store.getIdentity(item));
	}, _onSetItem:function (item) {
		this.updateOption(this._getOptionObjForItem(item));
	}, _getOptionObjForItem:function (item) {
		var store = this.store, label = store.getLabel(item), value = (label ? store.getIdentity(item) : null);
		return {value:value, label:label, item:item};
	}, _addOptionForItem:function (item) {
		var store = this.store;
		if (!store.isItemLoaded(item)) {
			store.loadItem({item:item, onComplete:function (i) {
				this._addOptionForItem(item);
			}, scope:this});
			return;
		}
		var newOpt = this._getOptionObjForItem(item);
		this.addOption(newOpt);
	}, constructor:function (keywordArgs) {
		this._oValue = (keywordArgs || {}).value || null;
	}, _fillContent:function () {
		var opts = this.options;
		if (!opts) {
			opts = this.options = this.srcNodeRef ? dojo.query(">", this.srcNodeRef).map(function (node) {
				if (node.getAttribute("type") === "separator") {
					return {value:"", label:"", selected:false, disabled:false};
				}
				return {value:node.getAttribute("value"), label:String(node.innerHTML), selected:node.getAttribute("selected") || false, disabled:node.getAttribute("disabled") || false};
			}, this) : [];
		}
		if (!this.value) {
			this.value = this._getValueFromOpts();
		} else {
			if (this.multiple && typeof this.value == "string") {
				this.value = this.value.split(",");
			}
		}
	}, postCreate:function () {
		dojo.setSelectable(this.focusNode, false);
		this.inherited(arguments);
		this.connect(this, "onChange", "_updateSelection");
		this.connect(this, "startup", "_loadChildren");
		this._setValueAttr(this.value, null);
	}, startup:function () {
		this.inherited(arguments);
		var store = this.store, fetchArgs = {};
		dojo.forEach(["query", "queryOptions", "onFetch"], function (i) {
			if (this[i]) {
				fetchArgs[i] = this[i];
			}
			delete this[i];
		}, this);
		if (store && store.getFeatures()["dojo.data.api.Identity"]) {
			this.store = null;
			this.setStore(store, this._oValue, fetchArgs);
		}
	}, destroy:function () {
		dojo.forEach(this._notifyConnections || [], dojo.disconnect);
		this.inherited(arguments);
	}, _addOptionItem:function (option) {
	}, _removeOptionItem:function (option) {
	}, _setDisplay:function (newDisplay) {
	}, _getChildren:function () {
		return [];
	}, _getSelectedOptionsAttr:function () {
		return this.getOptions(this.attr("value"));
	}, _pseudoLoadChildren:function (items) {
	}, onSetStore:function () {
	}});
}
if (!dojo._hasResource["dijit.MenuItem"]) {
	dojo._hasResource["dijit.MenuItem"] = true;
	dojo.provide("dijit.MenuItem");
	dojo.declare("dijit.MenuItem", [dijit._Widget, dijit._Templated, dijit._Contained], {templateString:dojo.cache("dijit", "templates/MenuItem.html", "<tr class=\"dijitReset dijitMenuItem\" dojoAttachPoint=\"focusNode\" waiRole=\"menuitem\" tabIndex=\"-1\"\r\n\t\tdojoAttachEvent=\"onmouseenter:_onHover,onmouseleave:_onUnhover,ondijitclick:_onClick\">\r\n\t<td class=\"dijitReset\" waiRole=\"presentation\">\r\n\t\t<img src=\"${_blankGif}\" alt=\"\" class=\"dijitMenuItemIcon\" dojoAttachPoint=\"iconNode\">\r\n\t</td>\r\n\t<td class=\"dijitReset dijitMenuItemLabel\" colspan=\"2\" dojoAttachPoint=\"containerNode\"></td>\r\n\t<td class=\"dijitReset dijitMenuItemAccelKey\" style=\"display: none\" dojoAttachPoint=\"accelKeyNode\"></td>\r\n\t<td class=\"dijitReset dijitMenuArrowCell\" waiRole=\"presentation\">\r\n\t\t<div dojoAttachPoint=\"arrowWrapper\" style=\"visibility: hidden\">\r\n\t\t\t<img src=\"${_blankGif}\" alt=\"\" class=\"dijitMenuExpand\">\r\n\t\t\t<span class=\"dijitMenuExpandA11y\">+</span>\r\n\t\t</div>\r\n\t</td>\r\n</tr>\r\n"), attributeMap:dojo.delegate(dijit._Widget.prototype.attributeMap, {label:{node:"containerNode", type:"innerHTML"}, iconClass:{node:"iconNode", type:"class"}}), label:"", iconClass:"", accelKey:"", disabled:false, _fillContent:function (source) {
		if (source && !("label" in this.params)) {
			this.attr("label", source.innerHTML);
		}
	}, postCreate:function () {
		dojo.setSelectable(this.domNode, false);
		var label = this.id + "_text";
		dojo.attr(this.containerNode, "id", label);
		if (this.accelKeyNode) {
			dojo.attr(this.accelKeyNode, "id", this.id + "_accel");
			label += " " + this.id + "_accel";
		}
		dijit.setWaiState(this.domNode, "labelledby", label);
	}, _onHover:function () {
		dojo.addClass(this.domNode, "dijitMenuItemHover");
		this.getParent().onItemHover(this);
	}, _onUnhover:function () {
		dojo.removeClass(this.domNode, "dijitMenuItemHover");
		this.getParent().onItemUnhover(this);
	}, _onClick:function (evt) {
		this.getParent().onItemClick(this, evt);
		dojo.stopEvent(evt);
	}, onClick:function (evt) {
	}, focus:function () {
		try {
			if (dojo.isIE == 8) {
				this.containerNode.focus();
			}
			dijit.focus(this.focusNode);
		}
		catch (e) {
		}
	}, _onFocus:function () {
		this._setSelected(true);
		this.getParent()._onItemFocus(this);
		this.inherited(arguments);
	}, _setSelected:function (selected) {
		dojo.toggleClass(this.domNode, "dijitMenuItemSelected", selected);
	}, setLabel:function (content) {
		dojo.deprecated("dijit.MenuItem.setLabel() is deprecated.  Use attr('label', ...) instead.", "", "2.0");
		this.attr("label", content);
	}, setDisabled:function (disabled) {
		dojo.deprecated("dijit.Menu.setDisabled() is deprecated.  Use attr('disabled', bool) instead.", "", "2.0");
		this.attr("disabled", disabled);
	}, _setDisabledAttr:function (value) {
		this.disabled = value;
		dojo[value ? "addClass" : "removeClass"](this.domNode, "dijitMenuItemDisabled");
		dijit.setWaiState(this.focusNode, "disabled", value ? "true" : "false");
	}, _setAccelKeyAttr:function (value) {
		this.accelKey = value;
		this.accelKeyNode.style.display = value ? "" : "none";
		this.accelKeyNode.innerHTML = value;
		dojo.attr(this.containerNode, "colSpan", value ? "1" : "2");
	}});
}
if (!dojo._hasResource["dijit.PopupMenuItem"]) {
	dojo._hasResource["dijit.PopupMenuItem"] = true;
	dojo.provide("dijit.PopupMenuItem");
	dojo.declare("dijit.PopupMenuItem", dijit.MenuItem, {_fillContent:function () {
		if (this.srcNodeRef) {
			var nodes = dojo.query("*", this.srcNodeRef);
			dijit.PopupMenuItem.superclass._fillContent.call(this, nodes[0]);
			this.dropDownContainer = this.srcNodeRef;
		}
	}, startup:function () {
		if (this._started) {
			return;
		}
		this.inherited(arguments);
		if (!this.popup) {
			var node = dojo.query("[widgetId]", this.dropDownContainer)[0];
			this.popup = dijit.byNode(node);
		}
		dojo.body().appendChild(this.popup.domNode);
		this.popup.domNode.style.display = "none";
		if (this.arrowWrapper) {
			dojo.style(this.arrowWrapper, "visibility", "");
		}
		dijit.setWaiState(this.focusNode, "haspopup", "true");
	}, destroyDescendants:function () {
		if (this.popup) {
			if (!this.popup._destroyed) {
				this.popup.destroyRecursive();
			}
			delete this.popup;
		}
		this.inherited(arguments);
	}});
}
if (!dojo._hasResource["dijit.CheckedMenuItem"]) {
	dojo._hasResource["dijit.CheckedMenuItem"] = true;
	dojo.provide("dijit.CheckedMenuItem");
	dojo.declare("dijit.CheckedMenuItem", dijit.MenuItem, {templateString:dojo.cache("dijit", "templates/CheckedMenuItem.html", "<tr class=\"dijitReset dijitMenuItem\" dojoAttachPoint=\"focusNode\" waiRole=\"menuitemcheckbox\" tabIndex=\"-1\"\r\n\t\tdojoAttachEvent=\"onmouseenter:_onHover,onmouseleave:_onUnhover,ondijitclick:_onClick\">\r\n\t<td class=\"dijitReset\" waiRole=\"presentation\">\r\n\t\t<img src=\"${_blankGif}\" alt=\"\" class=\"dijitMenuItemIcon dijitCheckedMenuItemIcon\" dojoAttachPoint=\"iconNode\">\r\n\t\t<span class=\"dijitCheckedMenuItemIconChar\">&#10003;</span>\r\n\t</td>\r\n\t<td class=\"dijitReset dijitMenuItemLabel\" colspan=\"2\" dojoAttachPoint=\"containerNode,labelNode\"></td>\r\n\t<td class=\"dijitReset dijitMenuItemAccelKey\" style=\"display: none\" dojoAttachPoint=\"accelKeyNode\"></td>\r\n\t<td class=\"dijitReset dijitMenuArrowCell\" waiRole=\"presentation\">\r\n\t</td>\r\n</tr>\r\n"), checked:false, _setCheckedAttr:function (checked) {
		dojo.toggleClass(this.domNode, "dijitCheckedMenuItemChecked", checked);
		dijit.setWaiState(this.domNode, "checked", checked);
		this.checked = checked;
	}, onChange:function (checked) {
	}, _onClick:function (e) {
		if (!this.disabled) {
			this.attr("checked", !this.checked);
			this.onChange(this.checked);
		}
		this.inherited(arguments);
	}});
}
if (!dojo._hasResource["dijit.MenuSeparator"]) {
	dojo._hasResource["dijit.MenuSeparator"] = true;
	dojo.provide("dijit.MenuSeparator");
	dojo.declare("dijit.MenuSeparator", [dijit._Widget, dijit._Templated, dijit._Contained], {templateString:dojo.cache("dijit", "templates/MenuSeparator.html", "<tr class=\"dijitMenuSeparator\">\r\n\t<td colspan=\"4\">\r\n\t\t<div class=\"dijitMenuSeparatorTop\"></div>\r\n\t\t<div class=\"dijitMenuSeparatorBottom\"></div>\r\n\t</td>\r\n</tr>\r\n"), postCreate:function () {
		dojo.setSelectable(this.domNode, false);
	}, isFocusable:function () {
		return false;
	}});
}
if (!dojo._hasResource["dijit.Menu"]) {
	dojo._hasResource["dijit.Menu"] = true;
	dojo.provide("dijit.Menu");
	dojo.declare("dijit._MenuBase", [dijit._Widget, dijit._Templated, dijit._KeyNavContainer], {parentMenu:null, popupDelay:500, startup:function () {
		if (this._started) {
			return;
		}
		dojo.forEach(this.getChildren(), function (child) {
			child.startup();
		});
		this.startupKeyNavChildren();
		this.inherited(arguments);
	}, onExecute:function () {
	}, onCancel:function (closeAll) {
	}, _moveToPopup:function (evt) {
		if (this.focusedChild && this.focusedChild.popup && !this.focusedChild.disabled) {
			this.focusedChild._onClick(evt);
		} else {
			var topMenu = this._getTopMenu();
			if (topMenu && topMenu._isMenuBar) {
				topMenu.focusNext();
			}
		}
	}, _onPopupHover:function (evt) {
		if (this.currentPopup && this.currentPopup._pendingClose_timer) {
			var parentMenu = this.currentPopup.parentMenu;
			if (parentMenu.focusedChild) {
				parentMenu.focusedChild._setSelected(false);
			}
			parentMenu.focusedChild = this.currentPopup.from_item;
			parentMenu.focusedChild._setSelected(true);
			this._stopPendingCloseTimer(this.currentPopup);
		}
	}, onItemHover:function (item) {
		if (this.isActive) {
			this.focusChild(item);
			if (this.focusedChild.popup && !this.focusedChild.disabled && !this.hover_timer) {
				this.hover_timer = setTimeout(dojo.hitch(this, "_openPopup"), this.popupDelay);
			}
		}
		if (this.focusedChild) {
			this.focusChild(item);
		}
		this._hoveredChild = item;
	}, _onChildBlur:function (item) {
		this._stopPopupTimer();
		item._setSelected(false);
		var itemPopup = item.popup;
		if (itemPopup) {
			this._stopPendingCloseTimer(itemPopup);
			itemPopup._pendingClose_timer = setTimeout(function () {
				itemPopup._pendingClose_timer = null;
				if (itemPopup.parentMenu) {
					itemPopup.parentMenu.currentPopup = null;
				}
				dijit.popup.close(itemPopup);
			}, this.popupDelay);
		}
	}, onItemUnhover:function (item) {
		if (this.isActive) {
			this._stopPopupTimer();
		}
		if (this._hoveredChild == item) {
			this._hoveredChild = null;
		}
	}, _stopPopupTimer:function () {
		if (this.hover_timer) {
			clearTimeout(this.hover_timer);
			this.hover_timer = null;
		}
	}, _stopPendingCloseTimer:function (popup) {
		if (popup._pendingClose_timer) {
			clearTimeout(popup._pendingClose_timer);
			popup._pendingClose_timer = null;
		}
	}, _stopFocusTimer:function () {
		if (this._focus_timer) {
			clearTimeout(this._focus_timer);
			this._focus_timer = null;
		}
	}, _getTopMenu:function () {
		for (var top = this; top.parentMenu; top = top.parentMenu) {
		}
		return top;
	}, onItemClick:function (item, evt) {
		if (item.disabled) {
			return false;
		}
		if (typeof this.isShowingNow == "undefined") {
			this._markActive();
		}
		this.focusChild(item);
		if (item.popup) {
			this._openPopup();
		} else {
			this.onExecute();
			item.onClick(evt);
		}
	}, _openPopup:function () {
		this._stopPopupTimer();
		var from_item = this.focusedChild;
		if (!from_item) {
			return;
		}
		var popup = from_item.popup;
		if (popup.isShowingNow) {
			return;
		}
		if (this.currentPopup) {
			this._stopPendingCloseTimer(this.currentPopup);
			dijit.popup.close(this.currentPopup);
		}
		popup.parentMenu = this;
		popup.from_item = from_item;
		var self = this;
		dijit.popup.open({parent:this, popup:popup, around:from_item.domNode, orient:this._orient || (this.isLeftToRight() ? {"TR":"TL", "TL":"TR", "BR":"BL", "BL":"BR"} : {"TL":"TR", "TR":"TL", "BL":"BR", "BR":"BL"}), onCancel:function () {
			self.focusChild(from_item);
			self._cleanUp();
			from_item._setSelected(true);
			self.focusedChild = from_item;
		}, onExecute:dojo.hitch(this, "_cleanUp")});
		this.currentPopup = popup;
		popup.connect(popup.domNode, "onmouseenter", dojo.hitch(self, "_onPopupHover"));
		if (popup.focus) {
			popup._focus_timer = setTimeout(dojo.hitch(popup, function () {
				this._focus_timer = null;
				this.focus();
			}), 0);
		}
	}, _markActive:function () {
		this.isActive = true;
		dojo.addClass(this.domNode, "dijitMenuActive");
		dojo.removeClass(this.domNode, "dijitMenuPassive");
	}, onOpen:function (e) {
		this.isShowingNow = true;
		this._markActive();
	}, _markInactive:function () {
		this.isActive = false;
		dojo.removeClass(this.domNode, "dijitMenuActive");
		dojo.addClass(this.domNode, "dijitMenuPassive");
	}, onClose:function () {
		this._stopFocusTimer();
		this._markInactive();
		this.isShowingNow = false;
		this.parentMenu = null;
	}, _closeChild:function () {
		this._stopPopupTimer();
		if (this.focusedChild) {
			this.focusedChild._setSelected(false);
			this.focusedChild._onUnhover();
			this.focusedChild = null;
		}
		if (this.currentPopup) {
			dijit.popup.close(this.currentPopup);
			this.currentPopup = null;
		}
	}, _onItemFocus:function (item) {
		if (this._hoveredChild && this._hoveredChild != item) {
			this._hoveredChild._onUnhover();
		}
	}, _onBlur:function () {
		this._cleanUp();
		this.inherited(arguments);
	}, _cleanUp:function () {
		this._closeChild();
		if (typeof this.isShowingNow == "undefined") {
			this._markInactive();
		}
	}});
	dojo.declare("dijit.Menu", dijit._MenuBase, {constructor:function () {
		this._bindings = [];
	}, templateString:dojo.cache("dijit", "templates/Menu.html", "<table class=\"dijit dijitMenu dijitMenuPassive dijitReset dijitMenuTable\" waiRole=\"menu\" tabIndex=\"${tabIndex}\" dojoAttachEvent=\"onkeypress:_onKeyPress\">\r\n\t<tbody class=\"dijitReset\" dojoAttachPoint=\"containerNode\"></tbody>\r\n</table>\r\n"), targetNodeIds:[], contextMenuForWindow:false, leftClickToOpen:false, refocus:true, _contextMenuWithMouse:false, postCreate:function () {
		if (this.contextMenuForWindow) {
			this.bindDomNode(dojo.body());
		} else {
			dojo.forEach(this.targetNodeIds, this.bindDomNode, this);
		}
		var k = dojo.keys, l = this.isLeftToRight();
		this._openSubMenuKey = l ? k.RIGHT_ARROW : k.LEFT_ARROW;
		this._closeSubMenuKey = l ? k.LEFT_ARROW : k.RIGHT_ARROW;
		this.connectKeyNavHandlers([k.UP_ARROW], [k.DOWN_ARROW]);
	}, _onKeyPress:function (evt) {
		if (evt.ctrlKey || evt.altKey) {
			return;
		}
		switch (evt.charOrCode) {
		  case this._openSubMenuKey:
			this._moveToPopup(evt);
			dojo.stopEvent(evt);
			break;
		  case this._closeSubMenuKey:
			if (this.parentMenu) {
				if (this.parentMenu._isMenuBar) {
					this.parentMenu.focusPrev();
				} else {
					this.onCancel(false);
				}
			} else {
				dojo.stopEvent(evt);
			}
			break;
		}
	}, _iframeContentWindow:function (iframe_el) {
		var win = dijit.getDocumentWindow(this._iframeContentDocument(iframe_el)) || this._iframeContentDocument(iframe_el)["__parent__"] || (iframe_el.name && dojo.doc.frames[iframe_el.name]) || null;
		return win;
	}, _iframeContentDocument:function (iframe_el) {
		var doc = iframe_el.contentDocument || (iframe_el.contentWindow && iframe_el.contentWindow.document) || (iframe_el.name && dojo.doc.frames[iframe_el.name] && dojo.doc.frames[iframe_el.name].document) || null;
		return doc;
	}, bindDomNode:function (node) {
		node = dojo.byId(node);
		var cn;
		if (node.tagName.toLowerCase() == "iframe") {
			var iframe = node, win = this._iframeContentWindow(iframe);
			cn = dojo.withGlobal(win, dojo.body);
		} else {
			cn = (node == dojo.body() ? dojo.doc.documentElement : node);
		}
		var binding = {node:node, iframe:iframe};
		dojo.attr(node, "_dijitMenu" + this.id, this._bindings.push(binding));
		var doConnects = dojo.hitch(this, function (cn) {
			return [dojo.connect(cn, (this.leftClickToOpen) ? "onclick" : "oncontextmenu", this, function (evt) {
				this._openMyself(evt, cn, iframe);
			}), dojo.connect(cn, "onkeydown", this, "_contextKey"), dojo.connect(cn, "onmousedown", this, "_contextMouse")];
		});
		binding.connects = cn ? doConnects(cn) : [];
		if (iframe) {
			binding.onloadHandler = dojo.hitch(this, function () {
				var win = this._iframeContentWindow(iframe);
				cn = dojo.withGlobal(win, dojo.body);
				binding.connects = doConnects(cn);
			});
			if (iframe.addEventListener) {
				iframe.addEventListener("load", binding.onloadHandler, false);
			} else {
				iframe.attachEvent("onload", binding.onloadHandler);
			}
		}
	}, unBindDomNode:function (nodeName) {
		var node;
		try {
			node = dojo.byId(nodeName);
		}
		catch (e) {
			return;
		}
		var attrName = "_dijitMenu" + this.id;
		if (node && dojo.hasAttr(node, attrName)) {
			var bid = dojo.attr(node, attrName) - 1, b = this._bindings[bid];
			dojo.forEach(b.connects, dojo.disconnect);
			var iframe = b.iframe;
			if (iframe) {
				if (iframe.removeEventListener) {
					iframe.removeEventListener("load", b.onloadHandler, false);
				} else {
					iframe.detachEvent("onload", b.onloadHandler);
				}
			}
			dojo.removeAttr(node, attrName);
			delete this._bindings[bid];
		}
	}, _contextKey:function (e) {
		this._contextMenuWithMouse = false;
		if (e.keyCode == dojo.keys.F10) {
			dojo.stopEvent(e);
			if (e.shiftKey && e.type == "keydown") {
				var _e = {target:e.target, pageX:e.pageX, pageY:e.pageY};
				_e.preventDefault = _e.stopPropagation = function () {
				};
				window.setTimeout(dojo.hitch(this, function () {
					this._openMyself(_e);
				}), 1);
			}
		}
	}, _contextMouse:function (e) {
		this._contextMenuWithMouse = true;
	}, _openMyself:function (e, node, iframe) {
		if (this.leftClickToOpen && e.button > 0) {
			return;
		}
		dojo.stopEvent(e);
		var x, y;
		if (dojo.isSafari || this._contextMenuWithMouse) {
			x = e.pageX;
			y = e.pageY;
			if (iframe) {
				var od = e.target.ownerDocument, ifc = dojo.position(iframe, true), win = this._iframeContentWindow(iframe), scroll = dojo.withGlobal(win, "_docScroll", dojo);
				var cs = dojo.getComputedStyle(iframe), tp = dojo._toPixelValue, left = (dojo.isIE && dojo.isQuirks ? 0 : tp(iframe, cs.paddingLeft)) + (dojo.isIE && dojo.isQuirks ? tp(iframe, cs.borderLeftWidth) : 0), top = (dojo.isIE && dojo.isQuirks ? 0 : tp(iframe, cs.paddingTop)) + (dojo.isIE && dojo.isQuirks ? tp(iframe, cs.borderTopWidth) : 0);
				x += ifc.x + left - scroll.x;
				y += ifc.y + top - scroll.y;
			}
		} else {
			var coords = dojo.position(e.target, true);
			x = coords.x + 10;
			y = coords.y + 10;
		}
		var self = this;
		var savedFocus = dijit.getFocus(this);
		function closeAndRestoreFocus() {
			if (self.refocus) {
				dijit.focus(savedFocus);
			}
			dijit.popup.close(self);
		}
		dijit.popup.open({popup:this, x:x, y:y, onExecute:closeAndRestoreFocus, onCancel:closeAndRestoreFocus, orient:this.isLeftToRight() ? "L" : "R"});
		this.focus();
		this._onBlur = function () {
			this.inherited("_onBlur", arguments);
			dijit.popup.close(this);
		};
	}, uninitialize:function () {
		dojo.forEach(this._bindings, function (b) {
			if (b) {
				this.unBindDomNode(b.node);
			}
		}, this);
		this.inherited(arguments);
	}});
}
if (!dojo._hasResource["dijit.form.Select"]) {
	dojo._hasResource["dijit.form.Select"] = true;
	dojo.provide("dijit.form.Select");
	dojo.declare("dijit.form._SelectMenu", dijit.Menu, {buildRendering:function () {
		this.inherited(arguments);
		var o = (this.menuTableNode = this.domNode);
		var n = (this.domNode = dojo.doc.createElement("div"));
		if (o.parentNode) {
			o.parentNode.replaceChild(n, o);
		}
		dojo.removeClass(o, "dijitMenuTable");
		n.className = o.className + " dijitSelectMenu";
		o.className = "dijitReset dijitMenuTable";
		dijit.setWaiRole(o, "listbox");
		dijit.setWaiRole(n, "presentation");
		n.appendChild(o);
		this.tabIndex = null;
	}, resize:function (mb) {
		if (mb) {
			dojo.marginBox(this.domNode, mb);
			var w = dojo.contentBox(this.domNode).w;
			if (dojo.isMoz && this.domNode.scrollHeight > this.domNode.clientHeight) {
				w--;
			} else {
				if (dojo.isIE < 8 || (dojo.isIE && dojo.isQuirks)) {
					w -= 16;
				}
			}
			dojo.marginBox(this.menuTableNode, {w:w});
		}
	}});
	dojo.declare("dijit.form.Select", [dijit.form._FormSelectWidget, dijit._HasDropDown], {baseClass:"dijitSelect", templateString:dojo.cache("dijit.form", "templates/Select.html", "<table class='dijit dijitReset dijitInline dijitLeft'\r\n\tdojoAttachPoint=\"_buttonNode,tableNode\" cellspacing='0' cellpadding='0' waiRole=\"presentation\"\r\n\tdojoAttachEvent=\"onmouseenter:_onMouse,onmouseleave:_onMouse,onmousedown:_onMouse\"\r\n\t><tbody waiRole=\"presentation\"><tr waiRole=\"presentation\"\r\n\t\t><td class=\"dijitReset dijitStretch dijitButtonContents dijitButtonNode\" dojoAttachPoint=\"focusNode\"\r\n\t\t\twaiRole=\"combobox\" waiState=\"haspopup-true\"\r\n\t\t\t><span class=\"dijitReset dijitInline dijitButtonText\"  dojoAttachPoint=\"containerNode,_popupStateNode\"></span\r\n\t\t\t><input type=\"hidden\" ${nameAttrSetting} dojoAttachPoint=\"valueNode\" value=\"${value}\" waiState=\"hidden-true\" />\r\n\t\t</td><td class=\"dijitReset dijitRight dijitButtonNode dijitArrowButton dijitDownArrowButton\"\r\n\t\t\t\tdojoAttachPoint=\"titleNode\" waiRole=\"presentation\"\r\n\t\t\t><div class=\"dijitReset dijitArrowButtonInner\" waiRole=\"presentation\">&thinsp;</div\r\n\t\t\t><div class=\"dijitReset dijitArrowButtonChar\" waiRole=\"presentation\">&#9660;</div\r\n\t\t></td\r\n\t></tr></tbody\r\n></table>\r\n"), attributeMap:dojo.mixin(dojo.clone(dijit.form._FormSelectWidget.prototype.attributeMap), {style:"tableNode"}), required:false, state:"", tooltipPosition:[], emptyLabel:"", _isLoaded:false, _childrenLoaded:false, _fillContent:function () {
		this.inherited(arguments);
		if (this.options.length && !this.value && this.srcNodeRef) {
			var si = this.srcNodeRef.selectedIndex;
			this.value = this.options[si != -1 ? si : 0].value;
		}
		this.dropDown = new dijit.form._SelectMenu();
		dojo.addClass(this.dropDown.domNode, this.baseClass + "Menu");
	}, _getMenuItemForOption:function (option) {
		if (!option.value) {
			return new dijit.MenuSeparator();
		} else {
			var click = dojo.hitch(this, "_setValueAttr", option);
			var item = new dijit.MenuItem({option:option, label:option.label, onClick:click, disabled:option.disabled || false});
			dijit.setWaiRole(item.focusNode, "listitem");
			return item;
		}
	}, _addOptionItem:function (option) {
		if (this.dropDown) {
			this.dropDown.addChild(this._getMenuItemForOption(option));
		}
	}, _getChildren:function () {
		if (!this.dropDown) {
			return [];
		}
		return this.dropDown.getChildren();
	}, _loadChildren:function (loadMenuItems) {
		if (loadMenuItems === true) {
			if (this.dropDown) {
				delete this.dropDown.focusedChild;
			}
			if (this.options.length) {
				this.inherited(arguments);
			} else {
				dojo.forEach(this._getChildren(), function (child) {
					child.destroyRecursive();
				});
				var item = new dijit.MenuItem({label:"&nbsp;"});
				this.dropDown.addChild(item);
			}
		} else {
			this._updateSelection();
		}
		var len = this.options.length;
		this._isLoaded = false;
		this._childrenLoaded = true;
		if (!this._loadingStore) {
			this._setValueAttr(this.value);
		}
	}, _setValueAttr:function (value) {
		this.inherited(arguments);
		dojo.attr(this.valueNode, "value", this.attr("value"));
	}, _setDisplay:function (newDisplay) {
		this.containerNode.innerHTML = "<span class=\"dijitReset dijitInline " + this.baseClass + "Label\">" + (newDisplay || this.emptyLabel || "&nbsp;") + "</span>";
		dijit.setWaiState(this.focusNode, "valuenow", (newDisplay || this.emptyLabel || "&nbsp;"));
	}, validate:function (isFocused) {
		var isValid = this.isValid(isFocused);
		this.state = isValid ? "" : "Error";
		this._setStateClass();
		dijit.setWaiState(this.focusNode, "invalid", isValid ? "false" : "true");
		var message = isValid ? "" : this._missingMsg;
		if (this._message !== message) {
			this._message = message;
			dijit.hideTooltip(this.domNode);
			if (message) {
				dijit.showTooltip(message, this.domNode, this.tooltipPosition);
			}
		}
		return isValid;
	}, isValid:function (isFocused) {
		return (!this.required || !(/^\s*$/.test(this.value)));
	}, reset:function () {
		this.inherited(arguments);
		dijit.hideTooltip(this.domNode);
		this.state = "";
		this._setStateClass();
		delete this._message;
	}, postMixInProperties:function () {
		this.inherited(arguments);
		this._missingMsg = dojo.i18n.getLocalization("dijit.form", "validate", this.lang).missingMessage;
	}, postCreate:function () {
		this.inherited(arguments);
		if (this.tableNode.style.width) {
			dojo.addClass(this.domNode, this.baseClass + "FixedWidth");
		}
	}, isLoaded:function () {
		return this._isLoaded;
	}, loadDropDown:function (loadCallback) {
		this._loadChildren(true);
		this._isLoaded = true;
		loadCallback();
	}, uninitialize:function (preserveDom) {
		if (this.dropDown && !this.dropDown._destroyed) {
			this.dropDown.destroyRecursive(preserveDom);
			delete this.dropDown;
		}
		this.inherited(arguments);
	}});
}
if (!dojo._hasResource["dijit._editor.plugins.LinkDialog"]) {
	dojo._hasResource["dijit._editor.plugins.LinkDialog"] = true;
	dojo.provide("dijit._editor.plugins.LinkDialog");
	dojo.declare("dijit._editor.plugins.LinkDialog", dijit._editor._Plugin, {buttonClass:dijit.form.DropDownButton, useDefaultCommand:false, urlRegExp:"((https?|ftps?|file)\\://|./|/|)(/[a-zA-Z]{1,1}:/|)(((?:(?:[\\da-zA-Z](?:[-\\da-zA-Z]{0,61}[\\da-zA-Z])?)\\.)*(?:[a-zA-Z](?:[-\\da-zA-Z]{0,80}[\\da-zA-Z])?)\\.?)|(((\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.){3}(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])|(0[xX]0*[\\da-fA-F]?[\\da-fA-F]\\.){3}0[xX]0*[\\da-fA-F]?[\\da-fA-F]|(0+[0-3][0-7][0-7]\\.){3}0+[0-3][0-7][0-7]|(0|[1-9]\\d{0,8}|[1-3]\\d{9}|4[01]\\d{8}|42[0-8]\\d{7}|429[0-3]\\d{6}|4294[0-8]\\d{5}|42949[0-5]\\d{4}|429496[0-6]\\d{3}|4294967[01]\\d{2}|42949672[0-8]\\d|429496729[0-5])|0[xX]0*[\\da-fA-F]{1,8}|([\\da-fA-F]{1,4}\\:){7}[\\da-fA-F]{1,4}|([\\da-fA-F]{1,4}\\:){6}((\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.){3}(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])))(\\:\\d+)?(/(?:[^?#\\s/]+/)*(?:[^?#\\s/]+(?:\\?[^?#\\s/]*)?(?:#.*)?)?)?", htmlTemplate:"<a href=\"${urlInput}\" _djrealurl=\"${urlInput}\"" + " target=\"${targetSelect}\"" + ">${textInput}</a>", tag:"a", _hostRxp:new RegExp("^((([^\\[:]+):)?([^@]+)@)?(\\[([^\\]]+)\\]|([^\\[:]*))(:([0-9]+))?$"), linkDialogTemplate:["<table><tr><td>", "<label for='${id}_urlInput'>${url}</label>", "</td><td>", "<input dojoType='dijit.form.ValidationTextBox' regExp='${urlRegExp}' required='true' " + "id='${id}_urlInput' name='urlInput' intermediateChanges='true'>", "</td></tr><tr><td>", "<label for='${id}_textInput'>${text}</label>", "</td><td>", "<input dojoType='dijit.form.ValidationTextBox' required='true' id='${id}_textInput' " + "name='textInput' intermediateChanges='true'>", "</td></tr><tr><td>", "<label for='${id}_targetSelect'>${target}</label>", "</td><td>", "<select id='${id}_targetSelect' name='targetSelect' dojoType='dijit.form.Select'>", "<option selected='selected' value='_self'>${currentWindow}</option>", "<option value='_blank'>${newWindow}</option>", "<option value='_top'>${topWindow}</option>", "<option value='_parent'>${parentWindow}</option>", "</select>", "</td></tr><tr><td colspan='2'>", "<button dojoType='dijit.form.Button' type='submit' id='${id}_setButton'>${set}</button>", "<button dojoType='dijit.form.Button' type='button' id='${id}_cancelButton'>${buttonCancel}</button>", "</td></tr></table>"].join(""), _initButton:function () {
		var _this = this;
		this.tag = this.command == "insertImage" ? "img" : "a";
		var messages = dojo.mixin(dojo.i18n.getLocalization("dijit", "common", this.lang), dojo.i18n.getLocalization("dijit._editor", "LinkDialog", this.lang));
		var dropDown = (this.dropDown = new dijit.TooltipDialog({title:messages[this.command + "Title"], execute:dojo.hitch(this, "setValue"), onOpen:function () {
			_this._onOpenDialog();
			dijit.TooltipDialog.prototype.onOpen.apply(this, arguments);
		}, onCancel:function () {
			setTimeout(dojo.hitch(_this, "_onCloseDialog"), 0);
		}}));
		messages.urlRegExp = this.urlRegExp;
		messages.id = dijit.getUniqueId(this.editor.id);
		this._uniqueId = messages.id;
		this._setContent(dropDown.title + "<div style='border-bottom: 1px black solid;padding-bottom:2pt;margin-bottom:4pt'></div>" + dojo.string.substitute(this.linkDialogTemplate, messages));
		dropDown.startup();
		this._urlInput = dijit.byId(this._uniqueId + "_urlInput");
		this._textInput = dijit.byId(this._uniqueId + "_textInput");
		this._setButton = dijit.byId(this._uniqueId + "_setButton");
		this.connect(dijit.byId(this._uniqueId + "_cancelButton"), "onClick", function () {
			this.dropDown.onCancel();
		});
		if (this._urlInput) {
			this.connect(this._urlInput, "onChange", "_checkAndFixInput");
		}
		if (this._textInput) {
			this.connect(this._textInput, "onChange", "_checkAndFixInput");
		}
		this._connectTagEvents();
		this.inherited(arguments);
	}, _checkAndFixInput:function () {
		var self = this;
		var url = this._urlInput.attr("value");
		var fixupUrl = function (url) {
			var appendHttp = false;
			if (url && url.length > 7) {
				url = dojo.trim(url);
				if (url.indexOf("/") > 0) {
					if (url.indexOf("://") === -1) {
						if (url.charAt(0) !== "/" && url.indexOf("./") !== 0) {
							if (self._hostRxp.test(url)) {
								appendHttp = true;
							}
						}
					}
				}
			}
			if (appendHttp) {
				self._urlInput.attr("value", "http://" + url);
			}
			self._setButton.attr("disabled", !self._isValid());
		};
		if (this._delayedCheck) {
			clearTimeout(this._delayedCheck);
			this._delayedCheck = null;
		}
		this._delayedCheck = setTimeout(function () {
			fixupUrl(url);
		}, 250);
	}, _connectTagEvents:function () {
		this.editor.onLoadDeferred.addCallback(dojo.hitch(this, function () {
			this.connect(this.editor.editNode, "ondblclick", this._onDblClick);
		}));
	}, _isValid:function () {
		return this._urlInput.isValid() && this._textInput.isValid();
	}, _setContent:function (staticPanel) {
		this.dropDown.attr("content", staticPanel);
	}, _checkValues:function (args) {
		if (args && args.urlInput) {
			args.urlInput = args.urlInput.replace(/"/g, "&quot;");
		}
		return args;
	}, setValue:function (args) {
		this._onCloseDialog();
		if (dojo.isIE) {
			var sel = dijit.range.getSelection(this.editor.window);
			var range = sel.getRangeAt(0);
			var a = range.endContainer;
			if (a.nodeType === 3) {
				a = a.parentNode;
			}
			if (a && (a.nodeName && a.nodeName.toLowerCase() !== this.tag)) {
				a = dojo.withGlobal(this.editor.window, "getSelectedElement", dijit._editor.selection, [this.tag]);
			}
			if (a && (a.nodeName && a.nodeName.toLowerCase() === this.tag)) {
				if (this.editor.queryCommandEnabled("unlink")) {
					dojo.withGlobal(this.editor.window, "selectElementChildren", dijit._editor.selection, [a]);
					this.editor.execCommand("unlink");
				}
			}
		}
		args = this._checkValues(args);
		this.editor.execCommand("inserthtml", dojo.string.substitute(this.htmlTemplate, args));
	}, _onCloseDialog:function () {
		this.editor.focus();
	}, _getCurrentValues:function (a) {
		var url, text, target;
		if (a && a.tagName.toLowerCase() === this.tag) {
			url = a.getAttribute("_djrealurl");
			target = a.getAttribute("target") || "_self";
			text = a.textContent || a.innerText;
			dojo.withGlobal(this.editor.window, "selectElement", dijit._editor.selection, [a, true]);
		} else {
			text = dojo.withGlobal(this.editor.window, dijit._editor.selection.getSelectedText);
		}
		return {urlInput:url || "", textInput:text || "", targetSelect:target || ""};
	}, _onOpenDialog:function () {
		var a;
		if (dojo.isIE) {
			var sel = dijit.range.getSelection(this.editor.window);
			var range = sel.getRangeAt(0);
			a = range.endContainer;
			if (a.nodeType === 3) {
				a = a.parentNode;
			}
			if (a && (a.nodeName && a.nodeName.toLowerCase() !== this.tag)) {
				a = dojo.withGlobal(this.editor.window, "getSelectedElement", dijit._editor.selection, [this.tag]);
			}
		} else {
			a = dojo.withGlobal(this.editor.window, "getAncestorElement", dijit._editor.selection, [this.tag]);
		}
		this.dropDown.reset();
		this._setButton.attr("disabled", true);
		this.dropDown.attr("value", this._getCurrentValues(a));
	}, _onDblClick:function (e) {
		if (e && e.target) {
			var t = e.target;
			var tg = t.tagName ? t.tagName.toLowerCase() : "";
			if (tg === this.tag) {
				this.editor.onDisplayChanged();
				dojo.withGlobal(this.editor.window, "selectElement", dijit._editor.selection, [t]);
				setTimeout(dojo.hitch(this, function () {
					this.button.attr("disabled", false);
					this.button.openDropDown();
				}), 10);
			}
		}
	}});
	dojo.declare("dijit._editor.plugins.ImgLinkDialog", [dijit._editor.plugins.LinkDialog], {linkDialogTemplate:["<table><tr><td>", "<label for='${id}_urlInput'>${url}</label>", "</td><td>", "<input dojoType='dijit.form.ValidationTextBox' regExp='${urlRegExp}' " + "required='true' id='${id}_urlInput' name='urlInput' intermediateChanges='true'>", "</td></tr><tr><td>", "<label for='${id}_textInput'>${text}</label>", "</td><td>", "<input dojoType='dijit.form.ValidationTextBox' required='false' id='${id}_textInput' " + "name='textInput' intermediateChanges='true'>", "</td></tr><tr><td>", "</td><td>", "</td></tr><tr><td colspan='2'>", "<button dojoType='dijit.form.Button' type='submit' id='${id}_setButton'>${set}</button>", "<button dojoType='dijit.form.Button' type='button' id='${id}_cancelButton'>${buttonCancel}</button>", "</td></tr></table>"].join(""), htmlTemplate:"<img src=\"${urlInput}\" _djrealurl=\"${urlInput}\" alt=\"${textInput}\" />", tag:"img", _getCurrentValues:function (img) {
		var url, text;
		if (img && img.tagName.toLowerCase() === this.tag) {
			url = img.getAttribute("_djrealurl");
			text = img.getAttribute("alt");
			dojo.withGlobal(this.editor.window, "selectElement", dijit._editor.selection, [img, true]);
		} else {
			text = dojo.withGlobal(this.editor.window, dijit._editor.selection.getSelectedText);
		}
		return {urlInput:url || "", textInput:text || ""};
	}, _isValid:function () {
		return this._urlInput.isValid();
	}, _connectTagEvents:function () {
		this.inherited(arguments);
		this.editor.onLoadDeferred.addCallback(dojo.hitch(this, function () {
			this.connect(this.editor.editNode, "onclick", this._selectTag);
		}));
	}, _selectTag:function (e) {
		if (e && e.target) {
			var t = e.target;
			var tg = t.tagName ? t.tagName.toLowerCase() : "";
			if (tg === this.tag) {
				dojo.withGlobal(this.editor.window, "selectElement", dijit._editor.selection, [t]);
			}
		}
	}, _checkValues:function (args) {
		if (args && args.urlInput) {
			args.urlInput = args.urlInput.replace(/"/g, "&quot;");
		}
		if (args && args.textInput) {
			args.textInput = args.textInput.replace(/"/g, "&quot;");
		}
		return args;
	}});
	dojo.subscribe(dijit._scopeName + ".Editor.getPlugin", null, function (o) {
		if (o.plugin) {
			return;
		}
		switch (o.args.name) {
		  case "createLink":
			o.plugin = new dijit._editor.plugins.LinkDialog({command:o.args.name});
			break;
		  case "insertImage":
			o.plugin = new dijit._editor.plugins.ImgLinkDialog({command:o.args.name});
			break;
		}
	});
}
if (!dojo._hasResource["wm.base.widget.Editors.RichText"]) {
	dojo._hasResource["wm.base.widget.Editors.RichText"] = true;
	dojo.provide("wm.base.widget.Editors.RichText");
	dojo.declare("wm.RichText", wm.LargeTextArea, {width:"100%", height:"200px", padding:"0", _ready:false, emptyValue:"emptyString", dataValue:"", displayValue:"", plugins:null, toolbarUndo:true, toolbarStyle:true, toolbarStyleAll:false, toolbarAlign:true, toolbarList:true, toolbarLink:false, toolbarFont:false, toolbarColor:false, classNames:"wmeditor wmrichtext", afterPaletteDrop:function () {
		this.setCaption(this.name);
	}, init:function () {
		this.inherited(arguments);
		this.plugins = [];
		this.updatePlugins();
	}, updatePlugins:function () {
		this.plugins = ["dijit._editor.plugins.AlwaysShowToolbar", "dijit._editor.plugins.EnterKeyHandling"];
		if (this.toolbarUndo) {
			this.plugins.push("undo");
			this.plugins.push("redo");
			this.plugins.push("|");
		}
		if (this.toolbarStyle) {
			this.plugins.push("bold");
			this.plugins.push("italic");
			this.plugins.push("underline");
			if (this.toolbarStyleAll) {
				this.plugins.push("strikethrough");
				this.plugins.push("subscript");
				this.plugins.push("superscript");
			}
			this.plugins.push("|");
		}
		if (this.toolbarAlign) {
			this.plugins.push("justifyLeft");
			this.plugins.push("justifyRight");
			this.plugins.push("justifyCenter");
			this.plugins.push("justifyFull");
			this.plugins.push("|");
		}
		if (this.toolbarList) {
			this.plugins.push("insertOrderedList");
			this.plugins.push("insertUnorderedList");
			this.plugins.push("indent");
			this.plugins.push("outdent");
			this.plugins.push("|");
		}
		if (this.toolbarLink) {
			this.plugins.push("createLink");
			this.plugins.push("unlink");
			this.plugins.push("|");
		}
		if (this.toolbarFont) {
			this.plugins.push("fontName");
			this.plugins.push("fontSize");
			this.plugins.push("formatBlock");
			this.plugins.push("|");
		}
		if (this.toolbarColor) {
			this.plugins.push("dijit._editor.plugins.TextColor");
			this.plugins.push("foreColor");
			this.plugins.push("hiliteColor");
			this.plugins.push("|");
		}
	}, setReadonly:function (inReadonly) {
		if (this.readonly && !inReadonly) {
			var val = this.getDataValue();
			this.inherited(arguments);
			this.setDataValue(val);
		} else {
			this.inherited(arguments);
		}
	}, sizeEditor:function () {
		if (!this._ready) {
			return;
		}
		this.inherited(arguments);
		var h = parseInt(this.editorNode.style.height);
		var toolh = this.editorNode.childNodes[0].clientHeight;
		this.editor.iframe.style.height = (h - toolh) + "px";
		if (this.editor.focusNode) {
			this.editor.focusNode.style.height = (h - toolh) + "px";
		}
	}, _createEditor:function (inNode, inProps) {
		this._ready = false;
		this.editorNode = document.createElement("div");
		this.domNode.appendChild(this.editorNode);
		this.editor = new dijit.Editor({height:"", plugins:this.plugins}, this.editorNode);
		if (this.editor.focusNode) {
			this.onLoad();
		} else {
			this.connect(this.editor, "onLoad", this, "onLoad");
		}
		return this.editor;
	}, onLoad:function () {
		this._ready = true;
		this._cupdating = false;
		this.sizeEditor();
		this.connect(this.editor, "onFocus", this, function () {
			dojo.addClass(this.editorNode, "Focused");
		});
		this.connect(this.editor, "onBlur", this, function () {
			dojo.removeClass(this.editorNode, "Focused");
		});
		this.editor.focusNode.style.lineHeight = "12px";
		this.editor.focusNode.style.overflow = "auto";
		this.editor.attr("value", this.dataValue || "");
	}, isReady:function () {
		return Boolean(this._ready && this.editor && this.editor.focusNode);
	}, setDisabled:function () {
		wm.logging && console.warn("wm.RichText.setDisabled is not supported");
	}, getEditorValue:function () {
		try {
			return this.inherited(arguments);
		}
		catch (e) {
		}
		return this.dataValue;
	}, _setEditorAttempts:0, setEditorValue:function (inValue) {
		if (!this._ready) {
			this.dataValue = inValue;
		} else {
			if (inValue === null || inValue === undefined) {
				inValue = "\n\n";
			}
			if (dojo.isString(inValue)) {
				inValue += "";
			}
			try {
				this.editor.attr("value", inValue);
				this.updateReadonlyValue();
			}
			catch (e) {
				console.warn("setEditorValue Failed: " + e);
			}
		}
	}});
	wm.Object.extendSchema(wm.RichText, {changeOnEnter:{ignore:1}, changeOnKey:{ignore:1}, password:{ignore:1}, emptyValue:{ignore:1}, regExp:{ignore:1}, invalidMessage:{ignore:1}, maxChars:{ignore:1}, singleLine:{ignore:1}, tooltipDisplayTime:{ignore:1}, disabled:{ignore:1}, promptMessage:{ignore:1}, displayValue:{ignore:1}, toolbarUndo:{group:"toolbar", order:1, shortname:"undo"}, toolbarStyle:{group:"toolbar", order:2, shortname:"styles"}, toolbarStyleAll:{group:"toolbar", order:3, shortname:"more styles"}, toolbarAlign:{group:"toolbar", order:4, shortname:"align"}, toolbarList:{group:"toolbar", order:5, shortname:"lists"}, toolbarLink:{group:"toolbar", order:6, shortname:"link"}, toolbarFont:{ignore:1}, toolbarColor:{group:"toolbar", order:8, shortname:"color"}});
	wm.RichText.extend({setToolbarUndo:function (val) {
		this.toolbarUndo = val;
		this.updatePlugins();
		this.createEditor();
	}, setToolbarStyle:function (val) {
		this.toolbarStyle = val;
		this.updatePlugins();
		this.createEditor();
	}, setToolbarStyleAll:function (val) {
		if (val) {
			this.toolbarStyle = true;
		}
		this.toolbarStyleAll = val;
		this.updatePlugins();
		this.createEditor();
	}, setToolbarAlign:function (val) {
		this.toolbarAlign = val;
		this.updatePlugins();
		this.createEditor();
	}, setToolbarList:function (val) {
		this.toolbarList = val;
		this.updatePlugins();
		this.createEditor();
	}, setToolbarLink:function (val) {
		this.toolbarLink = val;
		this.updatePlugins();
		this.createEditor();
	}, setToolbarFont:function (val) {
		this.toolbarFont = val;
		this.updatePlugins();
		this.createEditor();
	}, setToolbarColor:function (val) {
		this.toolbarColor = val;
		this.updatePlugins();
		this.createEditor();
	}});
}
if (!dojo._hasResource["dojo.dnd.TimedMoveable"]) {
	dojo._hasResource["dojo.dnd.TimedMoveable"] = true;
	dojo.provide("dojo.dnd.TimedMoveable");
	(function () {
		var oldOnMove = dojo.dnd.Moveable.prototype.onMove;
		dojo.declare("dojo.dnd.TimedMoveable", dojo.dnd.Moveable, {timeout:40, constructor:function (node, params) {
			if (!params) {
				params = {};
			}
			if (params.timeout && typeof params.timeout == "number" && params.timeout >= 0) {
				this.timeout = params.timeout;
			}
		}, markupFactory:function (params, node) {
			return new dojo.dnd.TimedMoveable(node, params);
		}, onMoveStop:function (mover) {
			if (mover._timer) {
				clearTimeout(mover._timer);
				oldOnMove.call(this, mover, mover._leftTop);
			}
			dojo.dnd.Moveable.prototype.onMoveStop.apply(this, arguments);
		}, onMove:function (mover, leftTop) {
			mover._leftTop = leftTop;
			if (!mover._timer) {
				var _t = this;
				mover._timer = setTimeout(function () {
					mover._timer = null;
					oldOnMove.call(_t, mover, mover._leftTop);
				}, this.timeout);
			}
		}});
	})();
}
if (!dojo._hasResource["dijit.DialogUnderlay"]) {
	dojo._hasResource["dijit.DialogUnderlay"] = true;
	dojo.provide("dijit.DialogUnderlay");
	dojo.declare("dijit.DialogUnderlay", [dijit._Widget, dijit._Templated], {templateString:"<div class='dijitDialogUnderlayWrapper'><div class='dijitDialogUnderlay' dojoAttachPoint='node'></div></div>", dialogId:"", "class":"", attributeMap:{id:"domNode"}, _setDialogIdAttr:function (id) {
		dojo.attr(this.node, "id", id + "_underlay");
	}, _setClassAttr:function (clazz) {
		this.node.className = "dijitDialogUnderlay " + clazz;
	}, postCreate:function () {
		dojo.body().appendChild(this.domNode);
	}, layout:function () {
		var is = this.node.style, os = this.domNode.style;
		os.display = "none";
		var viewport = dijit.getViewport();
		os.top = viewport.t + "px";
		os.left = viewport.l + "px";
		is.width = viewport.w + "px";
		is.height = viewport.h + "px";
		os.display = "block";
	}, show:function () {
		this.domNode.style.display = "block";
		this.layout();
		this.bgIframe = new dijit.BackgroundIframe(this.domNode);
	}, hide:function () {
		this.bgIframe.destroy();
		this.domNode.style.display = "none";
	}, uninitialize:function () {
		if (this.bgIframe) {
			this.bgIframe.destroy();
		}
		this.inherited(arguments);
	}});
}
if (!dojo._hasResource["dijit.Dialog"]) {
	dojo._hasResource["dijit.Dialog"] = true;
	dojo.provide("dijit.Dialog");
	dojo.declare("dijit._DialogBase", [dijit._Templated, dijit.form._FormMixin, dijit._DialogMixin], {templateString:dojo.cache("dijit", "templates/Dialog.html", "<div class=\"dijitDialog\" tabindex=\"-1\" waiRole=\"dialog\" waiState=\"labelledby-${id}_title\">\r\n\t<div dojoAttachPoint=\"titleBar\" class=\"dijitDialogTitleBar\">\r\n\t<span dojoAttachPoint=\"titleNode\" class=\"dijitDialogTitle\" id=\"${id}_title\"></span>\r\n\t<span dojoAttachPoint=\"closeButtonNode\" class=\"dijitDialogCloseIcon\" dojoAttachEvent=\"onclick: onCancel, onmouseenter: _onCloseEnter, onmouseleave: _onCloseLeave\" title=\"${buttonCancel}\">\r\n\t\t<span dojoAttachPoint=\"closeText\" class=\"closeText\" title=\"${buttonCancel}\">x</span>\r\n\t</span>\r\n\t</div>\r\n\t\t<div dojoAttachPoint=\"containerNode\" class=\"dijitDialogPaneContent\"></div>\r\n</div>\r\n"), attributeMap:dojo.delegate(dijit._Widget.prototype.attributeMap, {title:[{node:"titleNode", type:"innerHTML"}, {node:"titleBar", type:"attribute"}], "aria-describedby":""}), open:false, duration:dijit.defaultDuration, refocus:true, autofocus:true, _firstFocusItem:null, _lastFocusItem:null, doLayout:false, draggable:true, "aria-describedby":"", postMixInProperties:function () {
		var _nlsResources = dojo.i18n.getLocalization("dijit", "common");
		dojo.mixin(this, _nlsResources);
		this.inherited(arguments);
	}, postCreate:function () {
		dojo.style(this.domNode, {display:"none", position:"absolute"});
		dojo.body().appendChild(this.domNode);
		this.inherited(arguments);
		this.connect(this, "onExecute", "hide");
		this.connect(this, "onCancel", "hide");
		this._modalconnects = [];
	}, onLoad:function () {
		this._position();
		this.inherited(arguments);
	}, _endDrag:function (e) {
		if (e && e.node && e.node === this.domNode) {
			this._relativePosition = dojo.position(e.node);
		}
	}, _setup:function () {
		var node = this.domNode;
		if (this.titleBar && this.draggable) {
			this._moveable = (dojo.isIE == 6) ? new dojo.dnd.TimedMoveable(node, {handle:this.titleBar}) : new dojo.dnd.Moveable(node, {handle:this.titleBar, timeout:0});
			dojo.subscribe("/dnd/move/stop", this, "_endDrag");
		} else {
			dojo.addClass(node, "dijitDialogFixed");
		}
		this.underlayAttrs = {dialogId:this.id, "class":dojo.map(this["class"].split(/\s/), function (s) {
			return s + "_underlay";
		}).join(" ")};
		this._fadeIn = dojo.fadeIn({node:node, duration:this.duration, beforeBegin:dojo.hitch(this, function () {
			var underlay = dijit._underlay;
			if (!underlay) {
				underlay = dijit._underlay = new dijit.DialogUnderlay(this.underlayAttrs);
			} else {
				underlay.attr(this.underlayAttrs);
			}
			var zIndex = 948 + dijit._dialogStack.length * 2;
			dojo.style(dijit._underlay.domNode, "zIndex", zIndex);
			dojo.style(this.domNode, "zIndex", zIndex + 1);
			underlay.show();
		}), onEnd:dojo.hitch(this, function () {
			if (this.autofocus) {
				this._getFocusItems(this.domNode);
				dijit.focus(this._firstFocusItem);
			}
		})});
		this._fadeOut = dojo.fadeOut({node:node, duration:this.duration, onEnd:dojo.hitch(this, function () {
			node.style.display = "none";
			var ds = dijit._dialogStack;
			if (ds.length == 0) {
				dijit._underlay.hide();
			} else {
				dojo.style(dijit._underlay.domNode, "zIndex", 948 + ds.length * 2);
				dijit._underlay.attr(ds[ds.length - 1].underlayAttrs);
			}
			if (this.refocus) {
				var focus = this._savedFocus;
				if (ds.length > 0) {
					var pd = ds[ds.length - 1];
					if (!dojo.isDescendant(focus.node, pd.domNode)) {
						pd._getFocusItems(pd.domNode);
						focus = pd._firstFocusItem;
					}
				}
				dijit.focus(focus);
			}
		})});
	}, uninitialize:function () {
		var wasPlaying = false;
		if (this._fadeIn && this._fadeIn.status() == "playing") {
			wasPlaying = true;
			this._fadeIn.stop();
		}
		if (this._fadeOut && this._fadeOut.status() == "playing") {
			wasPlaying = true;
			this._fadeOut.stop();
		}
		if ((this.open || wasPlaying) && !dijit._underlay._destroyed) {
			dijit._underlay.hide();
		}
		if (this._moveable) {
			this._moveable.destroy();
		}
		this.inherited(arguments);
	}, _size:function () {
		this._checkIfSingleChild();
		if (this._singleChild) {
			if (this._singleChildOriginalStyle) {
				this._singleChild.domNode.style.cssText = this._singleChildOriginalStyle;
			}
			delete this._singleChildOriginalStyle;
		} else {
			dojo.style(this.containerNode, {width:"auto", height:"auto"});
		}
		var mb = dojo.marginBox(this.domNode);
		var viewport = dijit.getViewport();
		if (mb.w >= viewport.w || mb.h >= viewport.h) {
			var w = Math.min(mb.w, Math.floor(viewport.w * 0.75)), h = Math.min(mb.h, Math.floor(viewport.h * 0.75));
			if (this._singleChild && this._singleChild.resize) {
				this._singleChildOriginalStyle = this._singleChild.domNode.style.cssText;
				this._singleChild.resize({w:w, h:h});
			} else {
				dojo.style(this.containerNode, {width:w + "px", height:h + "px", overflow:"auto", position:"relative"});
			}
		} else {
			if (this._singleChild && this._singleChild.resize) {
				this._singleChild.resize();
			}
		}
	}, _position:function () {
		if (!dojo.hasClass(dojo.body(), "dojoMove")) {
			var node = this.domNode, viewport = dijit.getViewport(), p = this._relativePosition, bb = p ? null : dojo._getBorderBox(node), l = Math.floor(viewport.l + (p ? p.x : (viewport.w - bb.w) / 2)), t = Math.floor(viewport.t + (p ? p.y : (viewport.h - bb.h) / 2));
			dojo.style(node, {left:l + "px", top:t + "px"});
		}
	}, _onKey:function (evt) {
		var ds = dijit._dialogStack;
		if (ds[ds.length - 1] != this) {
			return;
		}
		if (evt.charOrCode) {
			var dk = dojo.keys;
			var node = evt.target;
			if (evt.charOrCode === dk.TAB) {
				this._getFocusItems(this.domNode);
			}
			var singleFocusItem = (this._firstFocusItem == this._lastFocusItem);
			if (node == this._firstFocusItem && evt.shiftKey && evt.charOrCode === dk.TAB) {
				if (!singleFocusItem) {
					dijit.focus(this._lastFocusItem);
				}
				dojo.stopEvent(evt);
			} else {
				if (node == this._lastFocusItem && evt.charOrCode === dk.TAB && !evt.shiftKey) {
					if (!singleFocusItem) {
						dijit.focus(this._firstFocusItem);
					}
					dojo.stopEvent(evt);
				} else {
					while (node) {
						if (node == this.domNode || dojo.hasClass(node, "dijitPopup")) {
							if (evt.charOrCode == dk.ESCAPE) {
								this.onCancel();
							} else {
								return;
							}
						}
						node = node.parentNode;
					}
					if (evt.charOrCode !== dk.TAB) {
						dojo.stopEvent(evt);
					} else {
						if (!dojo.isOpera) {
							try {
								this._firstFocusItem.focus();
							}
							catch (e) {
							}
						}
					}
				}
			}
		}
	}, show:function () {
		if (this.open) {
			return;
		}
		if (!this._alreadyInitialized) {
			this._setup();
			this._alreadyInitialized = true;
		}
		if (this._fadeOut.status() == "playing") {
			this._fadeOut.stop();
		}
		this._modalconnects.push(dojo.connect(window, "onscroll", this, "layout"));
		this._modalconnects.push(dojo.connect(window, "onresize", this, function () {
			var viewport = dijit.getViewport();
			if (!this._oldViewport || viewport.h != this._oldViewport.h || viewport.w != this._oldViewport.w) {
				this.layout();
				this._oldViewport = viewport;
			}
		}));
		this._modalconnects.push(dojo.connect(dojo.doc.documentElement, "onkeypress", this, "_onKey"));
		dojo.style(this.domNode, {opacity:0, display:""});
		this.open = true;
		this._onShow();
		this._size();
		this._position();
		dijit._dialogStack.push(this);
		this._fadeIn.play();
		this._savedFocus = dijit.getFocus(this);
	}, hide:function () {
		var ds = dijit._dialogStack;
		if (!this._alreadyInitialized || this != ds[ds.length - 1]) {
			return;
		}
		if (this._fadeIn.status() == "playing") {
			this._fadeIn.stop();
		}
		ds.pop();
		this._fadeOut.play();
		if (this._scrollConnected) {
			this._scrollConnected = false;
		}
		dojo.forEach(this._modalconnects, dojo.disconnect);
		this._modalconnects = [];
		if (this._relativePosition) {
			delete this._relativePosition;
		}
		this.open = false;
		this.onHide();
	}, layout:function () {
		if (this.domNode.style.display != "none") {
			if (dijit._underlay) {
				dijit._underlay.layout();
			}
			this._position();
		}
	}, destroy:function () {
		dojo.forEach(this._modalconnects, dojo.disconnect);
		if (this.refocus && this.open) {
			setTimeout(dojo.hitch(dijit, "focus", this._savedFocus), 25);
		}
		this.inherited(arguments);
	}, _onCloseEnter:function () {
		dojo.addClass(this.closeButtonNode, "dijitDialogCloseIcon-hover");
	}, _onCloseLeave:function () {
		dojo.removeClass(this.closeButtonNode, "dijitDialogCloseIcon-hover");
	}});
	dojo.declare("dijit.Dialog", [dijit.layout.ContentPane, dijit._DialogBase], {});
	dijit._dialogStack = [];
}
if (!dojo._hasResource["dojox.fx._base"]) {
	dojo._hasResource["dojox.fx._base"] = true;
	dojo.provide("dojox.fx._base");
	dojo.mixin(dojox.fx, {anim:dojo.anim, animateProperty:dojo.animateProperty, fadeTo:dojo._fade, fadeIn:dojo.fadeIn, fadeOut:dojo.fadeOut, combine:dojo.fx.combine, chain:dojo.fx.chain, slideTo:dojo.fx.slideTo, wipeIn:dojo.fx.wipeIn, wipeOut:dojo.fx.wipeOut});
	dojox.fx.sizeTo = function (args) {
		var node = args.node = dojo.byId(args.node), abs = "absolute";
		var method = args.method || "chain";
		if (!args.duration) {
			args.duration = 500;
		}
		if (method == "chain") {
			args.duration = Math.floor(args.duration / 2);
		}
		var top, newTop, left, newLeft, width, height = null;
		var init = (function (n) {
			return function () {
				var cs = dojo.getComputedStyle(n), pos = cs.position, w = cs.width, h = cs.height;
				top = (pos == abs ? n.offsetTop : parseInt(cs.top) || 0);
				left = (pos == abs ? n.offsetLeft : parseInt(cs.left) || 0);
				width = (w == "auto" ? 0 : parseInt(w));
				height = (h == "auto" ? 0 : parseInt(h));
				newLeft = left - Math.floor((args.width - width) / 2);
				newTop = top - Math.floor((args.height - height) / 2);
				if (pos != abs && pos != "relative") {
					var ret = dojo.coords(n, true);
					top = ret.y;
					left = ret.x;
					n.style.position = abs;
					n.style.top = top + "px";
					n.style.left = left + "px";
				}
			};
		})(node);
		var anim1 = dojo.animateProperty(dojo.mixin({properties:{height:function () {
			init();
			return {end:args.height || 0, start:height};
		}, top:function () {
			return {start:top, end:newTop};
		}}}, args));
		var anim2 = dojo.animateProperty(dojo.mixin({properties:{width:function () {
			return {start:width, end:args.width || 0};
		}, left:function () {
			return {start:left, end:newLeft};
		}}}, args));
		var anim = dojo.fx[(args.method == "combine" ? "combine" : "chain")]([anim1, anim2]);
		return anim;
	};
	dojox.fx.slideBy = function (args) {
		var node = args.node = dojo.byId(args.node), top, left;
		var init = (function (n) {
			return function () {
				var cs = dojo.getComputedStyle(n);
				var pos = cs.position;
				top = (pos == "absolute" ? n.offsetTop : parseInt(cs.top) || 0);
				left = (pos == "absolute" ? n.offsetLeft : parseInt(cs.left) || 0);
				if (pos != "absolute" && pos != "relative") {
					var ret = dojo.coords(n, true);
					top = ret.y;
					left = ret.x;
					n.style.position = "absolute";
					n.style.top = top + "px";
					n.style.left = left + "px";
				}
			};
		})(node);
		init();
		var _anim = dojo.animateProperty(dojo.mixin({properties:{top:top + (args.top || 0), left:left + (args.left || 0)}}, args));
		dojo.connect(_anim, "beforeBegin", _anim, init);
		return _anim;
	};
	dojox.fx.crossFade = function (args) {
		var node1 = args.nodes[0] = dojo.byId(args.nodes[0]), op1 = dojo.style(node1, "opacity"), node2 = args.nodes[1] = dojo.byId(args.nodes[1]), op2 = dojo.style(node2, "opacity");
		var _anim = dojo.fx.combine([dojo[(op1 == 0 ? "fadeIn" : "fadeOut")](dojo.mixin({node:node1}, args)), dojo[(op1 == 0 ? "fadeOut" : "fadeIn")](dojo.mixin({node:node2}, args))]);
		return _anim;
	};
	dojox.fx.highlight = function (args) {
		var node = args.node = dojo.byId(args.node);
		args.duration = args.duration || 400;
		var startColor = args.color || "#ffff99", endColor = dojo.style(node, "backgroundColor");
		if (endColor == "rgba(0, 0, 0, 0)") {
			endColor = "transparent";
		}
		var anim = dojo.animateProperty(dojo.mixin({properties:{backgroundColor:{start:startColor, end:endColor}}}, args));
		if (endColor == "transparent") {
			dojo.connect(anim, "onEnd", anim, function () {
				node.style.backgroundColor = endColor;
			});
		}
		return anim;
	};
	dojox.fx.wipeTo = function (args) {
		args.node = dojo.byId(args.node);
		var node = args.node, s = node.style;
		var dir = (args.width ? "width" : "height"), endVal = args[dir], props = {};
		props[dir] = {start:function () {
			s.overflow = "hidden";
			if (s.visibility == "hidden" || s.display == "none") {
				s[dir] = "1px";
				s.display = "";
				s.visibility = "";
				return 1;
			} else {
				var now = dojo.style(node, dir);
				return Math.max(now, 1);
			}
		}, end:endVal};
		var anim = dojo.animateProperty(dojo.mixin({properties:props}, args));
		return anim;
	};
}
if (!dojo._hasResource["dojox.image.Lightbox"]) {
	dojo._hasResource["dojox.image.Lightbox"] = true;
	dojo.provide("dojox.image.Lightbox");
	dojo.experimental("dojox.image.Lightbox");
	dojo.declare("dojox.image.Lightbox", dijit._Widget, {group:"", title:"", href:"", duration:500, modal:false, _allowPassthru:false, _attachedDialog:null, startup:function () {
		this.inherited(arguments);
		var tmp = dijit.byId("dojoxLightboxDialog");
		if (tmp) {
			this._attachedDialog = tmp;
		} else {
			this._attachedDialog = new dojox.image.LightboxDialog({id:"dojoxLightboxDialog"});
			this._attachedDialog.startup();
		}
		if (!this.store) {
			this._addSelf();
			this.connect(this.domNode, "onclick", "_handleClick");
		}
	}, _addSelf:function () {
		this._attachedDialog.addImage({href:this.href, title:this.title}, this.group || null);
	}, _handleClick:function (e) {
		if (!this._allowPassthru) {
			e.preventDefault();
		} else {
			return;
		}
		this.show();
	}, show:function () {
		this._attachedDialog.show(this);
	}, hide:function () {
		this._attachedDialog.hide();
	}, disable:function () {
		this._allowPassthru = true;
	}, enable:function () {
		this._allowPassthru = false;
	}, onClick:function () {
	}});
	dojo.declare("dojox.image.LightboxDialog", dijit.Dialog, {title:"", inGroup:null, imgUrl:dijit._Widget.prototype._blankGif, errorMessage:"Image not found.", adjust:true, modal:false, _groups:{XnoGroupX:[]}, errorImg:dojo.moduleUrl("dojox.image", "resources/images/warning.png"), templateString:dojo.cache("dojox.image", "resources/Lightbox.html", "<div class=\"dojoxLightbox\" dojoAttachPoint=\"containerNode\">\r\n\t<div style=\"position:relative\">\r\n\t\t<div dojoAttachPoint=\"imageContainer\" class=\"dojoxLightboxContainer\" dojoAttachEvent=\"onclick: _onImageClick\">\r\n\t\t\t<img dojoAttachPoint=\"imgNode\" src=\"${imgUrl}\" class=\"dojoxLightboxImage\" alt=\"${title}\">\r\n\t\t\t<div class=\"dojoxLightboxFooter\" dojoAttachPoint=\"titleNode\">\r\n\t\t\t\t<div class=\"dijitInline LightboxClose\" dojoAttachPoint=\"closeNode\"></div>\r\n\t\t\t\t<div class=\"dijitInline LightboxNext\" dojoAttachPoint=\"nextNode\"></div>\t\r\n\t\t\t\t<div class=\"dijitInline LightboxPrev\" dojoAttachPoint=\"prevNode\"></div>\r\n\t\t\t\t<div class=\"dojoxLightboxText\" dojoAttachPoint=\"titleTextNode\"><span dojoAttachPoint=\"textNode\">${title}</span><span dojoAttachPoint=\"groupCount\" class=\"dojoxLightboxGroupText\"></span></div>\r\n\t\t\t</div>\r\n\t\t</div>\r\n\t</div>\r\n</div>\r\n"), startup:function () {
		this.inherited(arguments);
		this._animConnects = [];
		this.connect(this.nextNode, "onclick", "_nextImage");
		this.connect(this.prevNode, "onclick", "_prevImage");
		this.connect(this.closeNode, "onclick", "hide");
		this._makeAnims();
		this._vp = dijit.getViewport();
		return this;
	}, show:function (groupData) {
		var _t = this;
		this._lastGroup = groupData;
		if (!_t.open) {
			_t.inherited(arguments);
			this._modalconnects.push(dojo.connect(dojo.global, "onscroll", this, "_position"), dojo.connect(dojo.global, "onresize", this, "_position"), dojo.connect(dojo.body(), "onkeypress", this, "_handleKey"));
			if (!groupData.modal) {
				this._modalconnects.push(dojo.connect(dijit._underlay.domNode, "onclick", this, "onCancel"));
			}
		}
		if (this._wasStyled) {
			dojo.destroy(_t.imgNode);
			_t.imgNode = dojo.create("img", null, _t.imageContainer, "first");
			_t._makeAnims();
			_t._wasStyled = false;
		}
		dojo.style(_t.imgNode, "opacity", "0");
		dojo.style(_t.titleNode, "opacity", "0");
		var src = groupData.href;
		if ((groupData.group && groupData !== "XnoGroupX") || _t.inGroup) {
			if (!_t.inGroup) {
				_t.inGroup = _t._groups[(groupData.group)];
				dojo.forEach(_t.inGroup, function (g, i) {
					if (g.href == groupData.href) {
						_t._index = i;
					}
				}, _t);
			}
			if (!_t._index) {
				_t._index = 0;
				src = _t.inGroup[_t._index].href;
			}
			_t.groupCount.innerHTML = " (" + (_t._index + 1) + " of " + _t.inGroup.length + ")";
			_t.prevNode.style.visibility = "visible";
			_t.nextNode.style.visibility = "visible";
		} else {
			_t.groupCount.innerHTML = "";
			_t.prevNode.style.visibility = "hidden";
			_t.nextNode.style.visibility = "hidden";
		}
		if (!groupData.leaveTitle) {
			_t.textNode.innerHTML = groupData.title;
		}
		_t._ready(src);
	}, _ready:function (src) {
		var _t = this;
		_t._imgError = dojo.connect(_t.imgNode, "error", _t, function () {
			dojo.disconnect(_t._imgError);
			_t.imgNode.src = _t.errorImg;
			_t.textNode.innerHTML = _t.errorMessage;
		});
		_t._imgConnect = dojo.connect(_t.imgNode, "load", _t, function (e) {
			_t.resizeTo({w:_t.imgNode.width, h:_t.imgNode.height, duration:_t.duration});
			dojo.disconnect(_t._imgConnect);
			if (_t._imgError) {
				dojo.disconnect(_t._imgError);
			}
		});
		_t.imgNode.src = src;
	}, _nextImage:function () {
		if (!this.inGroup) {
			return;
		}
		if (this._index + 1 < this.inGroup.length) {
			this._index++;
		} else {
			this._index = 0;
		}
		this._loadImage();
	}, _prevImage:function () {
		if (this.inGroup) {
			if (this._index == 0) {
				this._index = this.inGroup.length - 1;
			} else {
				this._index--;
			}
			this._loadImage();
		}
	}, _loadImage:function () {
		this._loadingAnim.play(1);
	}, _prepNodes:function () {
		this._imageReady = false;
		this.show({href:this.inGroup[this._index].href, title:this.inGroup[this._index].title});
	}, resizeTo:function (size, forceTitle) {
		var adjustSize = dojo.boxModel == "border-box" ? dojo._getBorderExtents(this.domNode).w : 0, titleSize = forceTitle || {h:30};
		this._lastTitleSize = titleSize;
		if (this.adjust && (size.h + titleSize.h + adjustSize + 80 > this._vp.h || size.w + adjustSize + 60 > this._vp.w)) {
			this._lastSize = size;
			size = this._scaleToFit(size);
		}
		this._currentSize = size;
		var _sizeAnim = dojox.fx.sizeTo({node:this.containerNode, duration:size.duration || this.duration, width:size.w + adjustSize, height:size.h + titleSize.h + adjustSize});
		this.connect(_sizeAnim, "onEnd", "_showImage");
		_sizeAnim.play(15);
	}, _scaleToFit:function (size) {
		var ns = {};
		if (this._vp.h > this._vp.w) {
			ns.w = this._vp.w - 80;
			ns.h = ns.w * (size.h / size.w);
		} else {
			ns.h = this._vp.h - 60 - this._lastTitleSize.h;
			ns.w = ns.h * (size.w / size.h);
		}
		this._wasStyled = true;
		this._setImageSize(ns);
		ns.duration = size.duration;
		return ns;
	}, _setImageSize:function (size) {
		var s = this.imgNode;
		s.height = size.h;
		s.width = size.w;
	}, _size:function () {
	}, _position:function (e) {
		this._vp = dijit.getViewport();
		this.inherited(arguments);
		if (e && e.type == "resize") {
			if (this._wasStyled) {
				this._setImageSize(this._lastSize);
				this.resizeTo(this._lastSize);
			} else {
				if (this.imgNode.height + 80 > this._vp.h || this.imgNode.width + 60 > this._vp.h) {
					this.resizeTo({w:this.imgNode.width, h:this.imgNode.height});
				}
			}
		}
	}, _showImage:function () {
		this._showImageAnim.play(1);
	}, _showNav:function () {
		var titleSizeNow = dojo.marginBox(this.titleNode);
		if (titleSizeNow.h > this._lastTitleSize.h) {
			this.resizeTo(this._wasStyled ? this._lastSize : this._currentSize, titleSizeNow);
		} else {
			this._showNavAnim.play(1);
		}
	}, hide:function () {
		dojo.fadeOut({node:this.titleNode, duration:200, onEnd:dojo.hitch(this, function () {
			this.imgNode.src = this._blankGif;
		})}).play(5);
		this.inherited(arguments);
		this.inGroup = null;
		this._index = null;
	}, addImage:function (child, group) {
		var g = group;
		if (!child.href) {
			return;
		}
		if (g) {
			if (!this._groups[g]) {
				this._groups[g] = [];
			}
			this._groups[g].push(child);
		} else {
			this._groups["XnoGroupX"].push(child);
		}
	}, _handleKey:function (e) {
		if (!this.open) {
			return;
		}
		var dk = dojo.keys;
		switch (e.charOrCode) {
		  case dk.ESCAPE:
			this.hide();
			break;
		  case dk.DOWN_ARROW:
		  case dk.RIGHT_ARROW:
		  case 78:
			this._nextImage();
			break;
		  case dk.UP_ARROW:
		  case dk.LEFT_ARROW:
		  case 80:
			this._prevImage();
			break;
		}
	}, _makeAnims:function () {
		dojo.forEach(this._animConnects, dojo.disconnect);
		this._animConnects = [];
		this._showImageAnim = dojo.fadeIn({node:this.imgNode, duration:this.duration});
		this._animConnects.push(dojo.connect(this._showImageAnim, "onEnd", this, "_showNav"));
		this._loadingAnim = dojo.fx.combine([dojo.fadeOut({node:this.imgNode, duration:175}), dojo.fadeOut({node:this.titleNode, duration:175})]);
		this._animConnects.push(dojo.connect(this._loadingAnim, "onEnd", this, "_prepNodes"));
		this._showNavAnim = dojo.fadeIn({node:this.titleNode, duration:225});
	}, onClick:function (groupData) {
	}, _onImageClick:function (e) {
		if (e && e.target == this.imgNode) {
			this.onClick(this._lastGroup);
			if (this._lastGroup.declaredClass) {
				this._lastGroup.onClick(this._lastGroup);
			}
		}
	}});
}
if (!dojo._hasResource["wm.base.widget.DojoLightbox"]) {
	dojo._hasResource["wm.base.widget.DojoLightbox"] = true;
	dojo.provide("wm.base.widget.DojoLightbox");
	dojo.extend(dojox.image.Lightbox, {removeImage:function (child, group) {
		if (this._attachedDialog) {
			this._attachedDialog.removeImage(child, group);
		}
	}, pop:function (group) {
		if (this._attachedDialog) {
			this._attachedDialog.pop(group);
		}
	}, clearGroup:function (group) {
		if (this._attachedDialog) {
			this._attachedDialog.clearGroup(group);
		}
	}});
	dojo.extend(dojox.image.LightboxDialog, {removeImage:function (child, group) {
		var g = group;
		if (!child.href) {
			return;
		}
		if (!g) {
			g = "XnoGroupX";
		}
		if (!this._groups[g]) {
			return;
		}
		for (var i = 0; i < this._groups[g].length; i++) {
			if (this._groups[g][i].href == child.href) {
				this._groups[g].slice(i, 1);
				break;
			}
		}
	}, pop:function (group) {
		var g = group;
		if (!g) {
			g = "XnoGroupX";
		}
		if (!this._groups[g]) {
			return;
		}
		this._groups[g].pop();
	}, clearGroup:function (group) {
		if (this._groups[group]) {
			delete this._groups[group];
		}
	}});
	dojo.declare("wm.DojoLightbox", wm.Component, {dataSet:null, imageUrlField:"", imageLabelField:"", postInit:function () {
		this.inherited(arguments);
		if (!this.$.binding && this.isDesignLoaded()) {
			new wm.Binding({name:"binding", owner:this});
		}
		this.createDojoObj();
	}, destroy:function () {
		this.inherited(arguments);
		this.destroyDojoObj();
	}, destroyDojoObj:function () {
		if (this.dojoObj) {
			this.dojoObj.destroy();
		}
	}, createDojoObj:function () {
		this.destroyDojoObj();
		this.dojoObj = new dojox.image.Lightbox({group:this.name});
		this.dojoObj.startup();
	}, renderDojoObj:function () {
		if (this._loading || !this.variable || !this.imageUrlField || this.imageUrlField == "") {
			return;
		}
		if (!this.dojoObj) {
			this.createDojoObj();
		} else {
			this.empty();
		}
		var imgUrlArray = [];
		for (var i = 0; i < this.variable.getCount(); i++) {
			var dataObj = this.variable.getItem(i).data;
			var imgObj = {};
			if (dataObj && dataObj != null) {
				imgObj.href = dataObj[this.imageUrlField];
				imgObj.title = this.imageLabelField && this.imageLabelField != "" ? dataObj[this.imageLabelField] : "";
			}
			imgUrlArray[imgUrlArray.length] = imgObj;
		}
		this.addToLightBox(imgUrlArray);
	}, addToLightBox:function (dataArray) {
		dojo.forEach(dataArray, function (item) {
			this.dojoObj._attachedDialog.addImage(item, this.name);
		}, this);
	}, activate:function () {
		this.show();
	}, show:function (startFromUrl) {
		if (startFromUrl) {
			this.dojoObj.href = startFromUrl;
		}
		this.dojoObj.show(this.name);
	}, getDataSet:function () {
		return this.variable;
	}, setDataSet:function (inValue, inDefault) {
		this.variable = inValue;
		this.renderDojoObj();
	}, setImageUrlField:function (inValue) {
		this.imageUrlField = inValue;
		this.renderDojoObj();
	}, setImageLabelField:function (inValue) {
		this.imageLabelField = inValue;
		this.renderDojoObj();
	}, empty:function () {
		if (this.dojoObj) {
			this.dojoObj.clearGroup(this.name);
		}
	}, update:function () {
		this.show();
	}});
	wm.Object.extendSchema(wm.DojoLightbox, {variable:{ignore:1}, dataSet:{bindable:1, group:"edit", order:10, isList:true}, imageUrlField:{group:"edit", order:20}, imageLabelField:{group:"edit", order:30}});
	wm.DojoLightbox.description = "A dojo Lightbox.";
}
if (!dojo._hasResource["wm.base.widget.Dashboard"]) {
	dojo._hasResource["wm.base.widget.Dashboard"] = true;
	dojo.provide("wm.base.widget.Dashboard");
	dojo.declare("wm.Dashboard", wm.Control, {margin:4, width:"100%", height:"100%", dojoObj:null, hasResizableColumns:false, opacity:0.3, nbZones:3, allowAutoScroll:true, withHandles:true, minChildWidth:200, minColWidth:10, saveInCookie:true, portlets:[], dijitPortlets:[], init:function () {
		dojo["require"]("dojox.layout.GridContainer");
		dojo["require"]("dojox.widget.Portlet");
		dojo["require"]("dijit.TooltipDialog");
		this.inherited(arguments);
	}, postInit:function () {
		this.inherited(arguments);
		this.initAddDialog();
		this.bcPortlets(this.portlets);
		this.portletsObj = {};
		dojo.forEach(this.portlets, function (p) {
			this.portletsObj[p.id] = p;
		}, this);
		dojo.addOnLoad(dojo.hitch(this, "renderDojoObj"));
	}, createAddDialog:function () {
		this.addDialog = new dijit.TooltipDialog({}, "tt");
		this.addDialog.startup();
		var dom = this.addDialog.containerNode;
		this.selectEditor = new wm.SelectMenu({"caption":"Widget", "display":"Select", "readonly":false, "width":"250px", captionSize:"80px", required:true, isRelativePositioned:true});
		dom.appendChild(this.selectEditor.domNode);
		var panel = dojo.create("div", {style:"text-align:center"}, dom);
		this.okButton = new wm.Button({"height":"100%", "width":"60px", "caption":"Add", isRelativePositioned:true});
		this.cancelButton = new wm.Button({"height":"100%", "width":"60px", "caption":"Cancel", isRelativePositioned:true});
		panel.appendChild(this.okButton.domNode);
		panel.appendChild(this.cancelButton.domNode);
	}, initAddDialog:function () {
		if (this.isDesignLoaded()) {
			return;
		}
		if (!this.addDialog) {
			this.createAddDialog();
		}
		var e = this.selectEditor;
		var eData = [];
		dojo.forEach(this.portlets, function (obj) {
			eData.push({name:obj.title, dataValue:obj});
		});
		var ds = e.dataSet = new wm.Variable({name:"optionsVar", owner:e, type:"EntryData"});
		ds.setData(eData);
		e.displayField = "name";
		e.dataField = "dataValue";
		e.createEditor();
		dojo.connect(this.okButton, "onclick", this, "_onOkClick");
		dojo.connect(this.cancelButton, "onclick", this, "_onCancelClick");
	}, _onOkClick:function () {
		var props = this.selectEditor.getDataValue();
		props.isOpen = true;
		if (props) {
			this.addPortlet(props);
			this.updateClosedList(props.id, false);
		}
		this.closeDialog();
	}, _onCancelClick:function () {
		this.closeDialog();
	}, update:function (e) {
		if (e && e.currentTarget) {
			this.openDialog(e.currentTarget);
		}
	}, closeDialog:function () {
		dijit.popup.close(this.addDialog);
	}, openDialog:function (inNearDOM) {
		dijit.popup.open({popup:this.addDialog, around:inNearDOM});
	}, renderBounds:function () {
		this.inherited(arguments);
		this.resizeDijit();
	}, resizeDijit:function () {
		if (this.dojoObj) {
			this.dojoObj.resize();
		}
	}, renderDojoObj:function () {
		if (this.dojoObj != null) {
			this.dojoObj.destroy();
		}
		var props = {acceptTypes:["dojox.widget.Portlet", "dojox.widget.FeedPortlet"], handleClasses:["dijitTitlePaneTitle"], isAutoOrganized:false, hasResizableColumns:this.hasResizableColumns, opacity:this.opacity, nbZones:this.nbZones, allowAutoScroll:this.allowAutoScroll, withHandles:this.withHandles, minChildWidth:this.minChildWidth, minColWidth:this.minColWidth, style:"width:100%;height:100%;"};
		this.dojoObj = new dojox.layout.GridContainer(props, dojo.create("div", {}, this.domNode));
		this.connectDojoEvents();
		this.dojoRenderer();
		this.renderPortlets();
	}, dojoRenderer:function () {
		if (!this.dojoObj) {
			return;
		}
		this.dojoObj.startup();
	}, renderPortlets:function () {
		var visiblePortlets = {}, opened = [], closed = [];
		dojo.forEach(this.portlets, function (p) {
			if (p.isOpen) {
				visiblePortlets[p.id] = p;
			}
		}, this);
		if (!this.isDesignLoaded() && this.saveInCookie) {
			var strPortletList = dojo.cookie(this.getId() + "_portlets");
			if (strPortletList && strPortletList != "") {
				opened = dojo.fromJson(strPortletList);
				this.bcPortlets(opened);
				dojo.forEach(opened, function (p) {
					var validPortlet = this.portletsObj[p.id];
					if (validPortlet) {
						visiblePortlets[p.id] = dojo.mixin({}, validPortlet, {x:p.x, y:p.y, isOpen:true});
					}
				}, this);
			}
			var strClosedList = dojo.cookie(this.getId() + "_closed_portlets");
			if (strClosedList && strClosedList != "") {
				closed = dojo.fromJson(strClosedList);
				dojo.forEach(closed, function (pId) {
					var validPortlet = this.portletsObj[pId];
					if (validPortlet) {
						visiblePortlets[pId] = dojo.mixin({}, validPortlet, {isOpen:false});
					}
				}, this);
			}
		}
		var portletArray = [];
		for (var i in visiblePortlets) {
			portletArray.push(visiblePortlets[i]);
		}
		if (!this.isDesignLoaded()) {
			this.onBeforeRenderPortlet(portletArray);
		}
		for (var i = 0; i < portletArray.length; i++) {
			this.addPortlet(portletArray[i]);
		}
	}, onBeforeRenderPortlet:function (portlets) {
	}, connectDojoEvents:function () {
	}, addPortlet:function (props) {
		if (!props.isOpen) {
			return;
		}
		var portletProps = {"title":props.title, "class":"soria", "dndType":"Portlet", "closable":props.isClosable};
		var portlet = new dojox.widget.Portlet(portletProps, dojo.create("div"));
		portlet.wmProps = props;
		if (this.isDesignLoaded()) {
			props.portletId = portlet.id;
			portlet.closeIcon.style.display = props.isClosable ? "block" : "none";
		}
		portlet.containerNode.style.padding = "0px";
		this.dojoObj.addService(portlet, props.x || 0, props.y || 0);
		portlet.wm_pageContainer = new wm.PageContainer({loadParentFirst:false, owner:this, parentNode:portlet.containerNode, isRelativePositioned:true});
		if (props.page) {
			portlet.wm_pageContainer.setPageName(props.page);
			window.setTimeout(dojo.hitch(this, function () {
				var c = dojo.coords(portlet.wm_pageContainer.domNode.parentNode);
				portlet.wm_pageContainer.setBounds(null, null, c.w - 2, c.h - 4);
				portlet.wm_pageContainer.reflow();
			}), 100);
		}
		if (!this.isDesignLoaded()) {
			dojo.connect(portlet, "onClose", this, "portletClosed");
			portlet.subscribe("/dnd/drop", dojo.hitch(this, "_onDashboardChange"));
			this._onDashboardChange();
		}
		this.dijitPortlets.push(portlet);
		return props;
	}, addNewPortlet:function (props) {
		props.id = this.getNewPortletId(props.id);
		props.title = this.getPortletTitleFromId(props.id);
		this.addPortlet(props);
		return props;
	}, getNewPortletId:function (inId) {
		inId = inId.toLowerCase().replace(/ /g, "_");
		if (!this.pIds) {
			this.pIds = {};
			dojo.forEach(this.portlets, function (p) {
				this.pIds[p.id] = true;
			}, this);
		}
		if (!this.pIds[inId]) {
			this.pIds[inId] = true;
			return inId;
		}
		var c = 1;
		while (this.pIds[inId + "_" + c]) {
			c++;
		}
		this.pIds[inId + "_" + c] = true;
		return inId + "_" + c;
	}, portletClosed:function (e) {
		var p = dijit.getEnclosingWidget(e.target);
		if (p) {
			var wmProps = p.wmProps;
			this.updateClosedList(wmProps.id, true);
			p.destroy();
		}
		this._onDashboardChange(e);
	}, updateClosedList:function (id, isClosed) {
		if (!this.saveInCookie) {
			return;
		}
		if (!this.closedList) {
			var strClosedList = dojo.cookie(this.getId() + "_closed_portlets") || "[]";
			this.closedList = dojo.fromJson(strClosedList);
		}
		if ((isClosed && this.closedList.indexOf(id) != -1) || (!isClosed && this.closedList.indexOf(id) == -1)) {
			return;
		}
		if (isClosed) {
			this.closedList.push(id);
		} else {
			while (this.closedList.indexOf(id) != -1) {
				var idx = this.closedList.indexOf(id);
				this.closedList.splice(idx, 1);
			}
		}
		dojo.cookie(this.getId() + "_closed_portlets", dojo.toJson(this.closedList), {expires:5});
	}, _onDashboardChange:function (e) {
		var pList = this.updatePortletXY();
		console.info("saving in cookie....", pList);
		if (this.saveInCookie) {
			dojo.cookie(this.getId() + "_portlets", dojo.toJson(pList), {expires:5});
		}
		this.onDashboardChange(pList);
	}, onDashboardChange:function (activePortlets) {
	}, _togglePortlet:function (evt) {
		var p = dijit.getEnclosingWidget(evt.originalTarget);
		dojo.toggleDOM(p.containerNode);
	}, destroyPortlet:function (props) {
		var p = dijit.byId(props.portletId);
		delete props.portletId;
		if (p) {
			p.destroy();
		}
	}, updatePortletXY:function () {
		this.portletXY = {};
		var _this = this;
		var currentPortletList = [];
		dojo.forEach(this.dojoObj.grid, function (colObj, x) {
			dojo.forEach(colObj.getAllNodes(), function (domPort, y) {
				var portlet = dijit.getEnclosingWidget(domPort);
				var wmProps = portlet.wmProps;
				if (portlet) {
					_this.portletXY[portlet.id] = {x:x, y:y};
					wmProps.x = x;
					wmProps.y = y;
					currentPortletList.push(wmProps);
				}
			});
		});
		return currentPortletList;
	}, destroy:function () {
		this.inherited(arguments);
		if (this.addDialog) {
			this.addDialog.destroy();
			delete this.addDialog;
		}
	}, bcPortlets:function (pList) {
		dojo.forEach(pList, function (p) {
			if (p.id) {
				return;
			}
			p.id = this.getPortletIdFromTitle(p.title);
		}, this);
	}, getPortletIdFromTitle:function (inTitle) {
		if (!inTitle) {
			return "";
		}
		return inTitle.replace(/ /g, "_");
	}, getPortletTitleFromId:function (pId) {
		return pId.replace(/_/g, " ");
	}});
	dojo.toggleDOM = function (domNode, animate) {
		var n = domNode;
		if (dojo.style(n, "display") == "none") {
			if (animate) {
				dojo.style(n, {"display":"block", "height":"1px", "width":"auto"});
				dojo.fx.wipeIn({node:n}).play();
			} else {
				dojo.style(n, {"display":"block"});
			}
		} else {
			if (animate) {
				dojo.fx.wipeOut({node:n, onEnd:dojo.hitch(this, function () {
					dojo.style(n, {"display":"none", "height":"", "width":""});
				})}).play();
			} else {
				dojo.style(n, {"display":"none"});
			}
		}
	};
}
if (!dojo._hasResource["wm.base.widget.ContextMenuDialog"]) {
	dojo._hasResource["wm.base.widget.ContextMenuDialog"] = true;
	dojo.provide("wm.base.widget.ContextMenuDialog");
	dojo.declare("wm.ContextMenuDialog", null, {constructor:function (dialogTitle, addButtonLabel, onAddButtonClick, headerAttr, dataSet, newRowDefault, domNode, addDeleteColumn, helpText) {
		this.helpText = helpText;
		this.dialogTitle = dialogTitle;
		this.addButtonLabel = addButtonLabel;
		this.dataSet = dataSet;
		this.onAddButtonClick = onAddButtonClick;
		this.newRowDefault = newRowDefault;
		this.addDeleteColumn = addDeleteColumn;
		this.headerAttr = headerAttr;
		this.trObjMap = {};
		this.trId = 0;
		this.showModal = true;
		this.deleteButtonProps = {id:"deleteButton", title:" ", width:"", type:"img", label:"Delete", src:"images/delete_24.png", width:"20px"};
		dojo.connect(domNode, "oncontextmenu", this, "show");
	}, show:function (e) {
		if (!this.menu) {
			this.createRightClickMenu();
		}
		this.menu.show();
		if (!this.showModal) {
			dijit._underlay.hide();
		}
		if (e) {
			dojo.stopEvent(e);
		}
	}, hide:function () {
		this.menu.hide();
	}, setDataSet:function (dataSet) {
		this.trObjMap = {};
		this.trId = 0;
		this.dataSet = dataSet;
		if (this.menuTable) {
			dojo.destroy(this.menuTable);
			delete this.menuTable;
			this.createMenuHTML(this.headerAttr, this.dataSet);
		}
	}, getUpdatedDataSet:function () {
		if (!this.menu) {
			return this.dataSet;
		}
		var arr = [];
		for (var tr in this.trObjMap) {
			arr.push(this.trObjMap[tr]);
		}
		return arr;
	}, rowPropChanged:function (obj, columnId, trObj, widget, inValue) {
		if (columnId == "deleteButton" && this.addDeleteColumn) {
			this.deleteRow(obj, columnId, trObj, inValue);
			return;
		}
		obj[columnId] = inValue;
		var trId = dojo.attr(trObj, "trId");
		this.onPropChanged(obj, columnId, inValue, trObj, widget);
		this.trObjMap["TR_" + trId] = obj;
	}, widthTextChanged:function (obj, columnId, trObj, textWidget, typeWidget, inValue) {
		var w = this.getWidthProps(inValue);
		inValue = w.text;
		textWidget.attr("value", inValue);
		if (w.dd) {
			inValue += w.dd;
			typeWidget.attr("value", w.dd);
		} else {
			inValue += typeWidget.attr("value");
		}
		obj[columnId] = inValue;
		var trId = dojo.attr(trObj, "trId");
		this.onPropChanged(obj, columnId, inValue, trObj);
		this.trObjMap["TR_" + trId] = obj;
	}, widthTypeChanged:function (obj, columnId, trObj, textWidget, typeWidget, inValue) {
		var w = this.getWidthProps(obj[columnId]);
		var width = w.text + inValue;
		obj[columnId] = width;
		var trId = dojo.attr(trObj, "trId");
		this.onPropChanged(obj, columnId, inValue, trObj);
		this.trObjMap["TR_" + trId] = obj;
	}, onPropChanged:function (Obj, prop, inValue, trObj) {
	}, deleteRow:function (obj, columnId, trObj, inValue) {
		var trId = dojo.attr(trObj, "trId");
		dojo.destroy(trObj);
		delete this.trObjMap["TR_" + trId];
		this.onRowDelete(obj);
	}, onRowDelete:function (Obj) {
	}, createRightClickMenu:function () {
		this.menu = new dijit.Dialog({title:this.dialogTitle}, dojo.doc.createElement("div"));
		if (this.helpText) {
			this.helpTextDiv = dojo.create("div", {innerHTML:this.helpText, style:"padding-left:5px;margin:5px;background:#FFF1A8;border:1px solid #DCDCDC;"}, this.menu.containerNode);
		}
		this.createMenuHTML(this.headerAttr, this.dataSet);
	}, createMenuHTML:function (headerAttr, rows) {
		this.hasAdvancedColumn = false;
		this.isAdvancedHidden = true;
		this.advancedColumns = [];
		this.menuTable = dojo.doc.createElement("table");
		this.menuTable.style.display = "none";
		var thead = dojo.doc.createElement("thead");
		this.menuTable.appendChild(thead);
		var tr = dojo.doc.createElement("tr");
		dojo.attr(tr, "style", "background-color:#DCDCDC");
		thead.appendChild(tr);
		dojo.forEach(headerAttr, function (attr) {
			this.addHeaderColumn(tr, attr);
			if (attr.isAdvanced) {
				this.hasAdvancedColumn = true;
			}
		}, this);
		if (this.addDeleteColumn) {
			if (this.hasAdvancedColumn) {
				this.deleteButtonProps.isAdvanced = true;
			}
			this.addHeaderColumn(tr, this.deleteButtonProps);
		}
		this.rightClickTBody = dojo.doc.createElement("tbody");
		this.menuTable.appendChild(this.rightClickTBody);
		this.menu.containerNode.appendChild(this.menuTable);
		dojo.forEach(rows, function (row) {
			this.addNewRow(row, headerAttr, this.rightClickTBody);
		}, this);
		this.paintNewColumnButton();
		if (this.hasAdvancedColumn) {
			this.addAdvancedProperties();
		}
	}, addAdvancedProperties:function () {
		this.destoryAdvancedPropertiesDiv();
		this.advancedButtonDiv = dojo.create("div", {style:"text-align:right;"}, this.menu.containerNode);
		dojo.place(this.advancedButtonDiv, this.helpTextDiv, "after");
		this.advancedButton = new dijit.form.Button({label:"Show Advanced Properties >>"}, dojo.create("div", {}, this.advancedButtonDiv));
		dojo.connect(this.advancedButton, "onClick", this, "toggleAdvancedProps");
	}, destoryAdvancedPropertiesDiv:function () {
		if (!this.advancedButton) {
			return;
		}
		dojo.destroy(this.advancedButton);
		dojo.destroy(this.advancedButtonDiv);
	}, toggleAdvancedProps:function () {
		if (this.isAdvancedHidden) {
			this.isAdvancedHidden = false;
			dojo.forEach(this.advancedColumns, function (td) {
				td.style.display = "";
			});
			this.advancedButton.attr("label", "<< Hide Advanced Properties");
		} else {
			this.isAdvancedHidden = true;
			dojo.forEach(this.advancedColumns, function (td) {
				td.style.display = "none";
			});
			this.advancedButton.attr("label", "Show Advanced Properties >>");
		}
		this.menu._position();
	}, addHeaderColumn:function (tr, attr) {
		var td = dojo.doc.createElement("td");
		dojo.attr(td, "width", attr.width);
		dojo.attr(td, "align", "center");
		td.innerHTML = attr.title;
		tr.appendChild(td);
		if (attr.isAdvanced) {
			td.style.display = "none";
			this.advancedColumns.push(td);
		}
	}, addNewRow:function (obj, headerAttr, tbody) {
		var tr = dojo.doc.createElement("tr");
		dojo.attr(tr, "trId", this.trId);
		this.trObjMap["TR_" + this.trId] = obj;
		dojo.forEach(headerAttr, function (column) {
			this.addChildColumn(tr, column, obj);
		}, this);
		if (this.addDeleteColumn) {
			this.addChildColumn(tr, this.deleteButtonProps, obj);
		}
		tbody.appendChild(tr);
		this.menuTable.style.display = "block";
		this.trId++;
	}, addChildColumn:function (tr, column, obj) {
		try {
			var td = dojo.doc.createElement("td");
			var widget = null;
			switch (column.type) {
			  case "checkbox":
				dojo.attr(td, "align", "center");
				var params = {};
				if (obj[column.id]) {
					params.checked = true;
				}
				widget = new dijit.form.CheckBox(params, dojo.doc.createElement("div"));
				widget.onChange = dojo.hitch(this, "rowPropChanged", obj, column.id, tr, widget);
				break;
			  case "button":
				widget = new dijit.form.Button({label:column.label, style:"padding:0px;"});
				widget.onClick = dojo.hitch(this, "rowPropChanged", obj, column.id, tr, widget);
				break;
			  case "img":
				var src = column.src;
				if (column.id == "deleteButton" && obj.noDelete) {
					dojo.create("div", {}, td);
					break;
				}
				var imgProps = {src:src, onclick:dojo.hitch(this, "rowPropChanged", obj, column.id, tr)};
				if (column.width) {
					imgProps.width = column.width;
				}
				if (column.height) {
					imgProps.height = column.height;
				}
				widget = dojo.create("img", imgProps, td);
				break;
			  case "dropdown":
				var params = {value:obj[column.id] || "", autoComplete:false, store:column.dataStore, query:{}};
				if (column.width) {
					params.style = {width:"100%"};
				}
				widget = new dijit.form.ComboBox(params);
				widget.onChange = dojo.hitch(this, "rowPropChanged", obj, column.id, tr, widget);
				dojo.query(".dijitValidationIcon", widget.domNode).forEach(function (domNode) {
					domNode.style.display = "none";
				});
				break;
			  case "width":
				var w = this.getWidthProps(obj[column.id]);
				var params = {value:w.text, style:"width:40px;height:14px"};
				if (column.readOnly) {
					params.readOnly = true;
				}
				var tf = new dijit.form.TextBox(params, dojo.doc.createElement("div"));
				td.appendChild(tf.domNode);
				var params = {value:w.dd || "px", autoComplete:false, tabIndex:-1, store:this.getWidthStore(), query:{}, style:"width:60px;height:14px"};
				if (column.readOnly) {
					params.readOnly = true;
				}
				widget = new dijit.form.FilteringSelect(params);
				dojo.query(".dijitValidationIcon", widget.domNode).forEach(function (domNode) {
					domNode.style.display = "none";
				});
				tf.onChange = dojo.hitch(this, "widthTextChanged", obj, column.id, tr, tf, widget);
				widget.onChange = dojo.hitch(this, "widthTypeChanged", obj, column.id, tr, tf, widget);
				break;
			  default:
				var params = {value:obj[column.id] || ""};
				if (column.width) {
					params.style = {width:"100%"};
				}
				if (column.readOnly) {
					params.readOnly = true;
				}
				widget = new dijit.form.TextBox(params, dojo.doc.createElement("div"));
				widget.onChange = dojo.hitch(this, "rowPropChanged", obj, column.id, tr, widget);
			}
			if (column.type != "img") {
				if (widget) {
					td.appendChild(widget.domNode);
				} else {
					dojo.create("div", {}, td);
				}
			}
			tr.appendChild(td);
			if (column.isAdvanced) {
				this.advancedColumns.push(td);
				if (this.isAdvancedHidden) {
					td.style.display = "none";
				}
			}
		}
		catch (e) {
			console.info("Error while adding column: ", column, obj, e);
		}
	}, getWidthProps:function (inValue) {
		var props = {text:"auto"};
		if (!inValue) {
			return props;
		}
		inValue = inValue.toLowerCase();
		if (inValue.indexOf("p") != -1) {
			props.dd = "px";
		} else {
			if (inValue.indexOf("%") != -1) {
				props.dd = "%";
			}
		}
		inValue = inValue.replace(/p|x|%/g, "");
		props.text = inValue;
		return props;
	}, getWidthStore:function () {
		var arr = [{name:"px", value:"px"}, {name:"%", value:"%"}];
		var data = {identifier:"value", label:"name", value:"value", items:arr};
		return new dojo.data.ItemFileReadStore({data:data});
	}, paintNewColumnButton:function () {
		if (this.newColumnButton) {
			this.newColumnButton.destroy();
		}
		var div = dojo.doc.createElement("div");
		this.menu.containerNode.appendChild(div);
		this.newColumnButton = new dijit.form.Button({label:this.addButtonLabel, onClick:dojo.hitch(this, "addNewColumn"), style:"padding:5px;"});
		this.newColumnButton.placeAt(div);
	}, addNewColumn:function () {
		var props = dojo.clone(this.newRowDefault);
		var prop2 = this.onAddButtonClick(props);
		if (!prop2) {
			prop2 = props;
		}
		this.addNewRow(prop2, this.headerAttr, this.rightClickTBody);
		this.onAddNewColumnSuccess(prop2);
	}, onAddNewColumnSuccess:function (columnProps) {
	}});
}
if (!dojo._hasResource["wm.base.widget.Dashboard_design"]) {
	dojo._hasResource["wm.base.widget.Dashboard_design"] = true;
	dojo.provide("wm.base.widget.Dashboard_design");
	wm.Dashboard.extend({themeable:false, configPortlets:"(Configure Portlets)", headerAttr:[{id:"isOpen", title:"Default", width:"10%", type:"checkbox"}, {id:"title", title:"Title", width:"30%", type:"text"}, {id:"page", title:"Page", width:"30%", type:"dropdown"}, {id:"isClosable", title:"Closable", width:"10%", type:"checkbox"}], designCreate:function () {
		this.inherited(arguments);
		var defaultPortletParams = {id:"portlet", title:"Portlet", page:"", isOpen:true, isClosable:true, x:0, y:0};
		this.updatePageList();
		this.headerAttr[2].dataStore = this.pageStore;
		this.contextMenu = new wm.ContextMenuDialog("Configure Portlets", "Add Portlet", dojo.hitch(this, "addNewPortlet"), this.headerAttr, this.portlets, defaultPortletParams, this.domNode, true);
		dojo.connect(this.contextMenu, "onPropChanged", this, "portletPropChanged");
		dojo.connect(this.contextMenu, "onRowDelete", this, "destroyPortlet");
	}, showMenuDialog:function (e) {
		this.contextMenu.show();
	}, portletPropChanged:function (Obj, prop, inValue, trObj) {
		switch (prop) {
		  case "isOpen":
			if (inValue) {
				this.addPortlet(Obj);
			} else {
				this.destroyPortlet(Obj);
			}
			break;
		  case "title":
			var p = dijit.byId(Obj.portletId);
			if (!p) {
				return;
			}
			p.attr("title", inValue);
			break;
		  case "page":
			var p = dijit.byId(Obj.portletId);
			if (!p) {
				return;
			}
			p.wm_pageContainer.setPageName(inValue);
			break;
		  case "isClosable":
			var p = dijit.byId(Obj.portletId);
			if (!p) {
				return;
			}
			p.closeIcon.style.display = inValue ? "block" : "none";
			break;
		}
	}, removePortlet:function (obj) {
		this.destroyPortlet(Obj);
	}, updatePageList:function () {
		var pages = wm.getPageList(false);
		var pageList = [];
		dojo.forEach(pages, function (pageName) {
			pageList.push({name:pageName, value:pageName});
		});
		if (!this.pageStore) {
			var storeData = {identifier:"value", label:"name", value:"value", items:pageList};
			this.pageStore = new dojo.data.ItemFileWriteStore({data:storeData});
		} else {
			this.pageStore.attr("data", pageList);
		}
	}, makePropEdit:function (inName, inValue, inDefault) {
		switch (inName) {
		  case "configPortlets":
			return makeReadonlyButtonEdit(inName, inValue, inDefault);
		}
		return this.inherited(arguments);
	}, editProp:function (inName, inValue, inInspector) {
		switch (inName) {
		  case "configPortlets":
			return this.showMenuDialog();
		}
		return this.inherited(arguments);
	}, writeComponents:function () {
		return "";
	}, writeProps:function () {
		try {
			var props = this.inherited(arguments);
			var pList = this.contextMenu.getUpdatedDataSet();
			this.updatePortletXY();
			var writePortlets = [];
			dojo.forEach(pList, function (obj) {
				var coord = this.portletXY[obj.portletId];
				if (coord) {
					obj.x = coord.x;
					obj.y = coord.y;
				}
				var wObj = dojo.clone(obj);
				delete wObj.portletId;
				writePortlets.push(wObj);
			}, this);
			props.portlets = writePortlets;
			return props;
		}
		catch (e) {
			console.info("Error while saving dashboard data..............", e);
		}
	}});
	wm.Dashboard.description = "A dojo Grid Container that is used as a dashboard element.";
	wm.Object.extendSchema(wm.Dashboard, {caption:{ignore:1}, disabled:{ignore:1}, dataValue:{ignore:1}, minWidth:{ignore:1}, portlets:{ignore:1}, dijitPortlets:{ignore:1}, addDialogName:{hidden:true}, headerAttr:{ignore:1}, configPortlets:{group:"edit", order:10}});
}
if (!dojo._hasResource["wm.base.widget.DojoGrid"]) {
	dojo._hasResource["wm.base.widget.DojoGrid"] = true;
	dojo.provide("wm.base.widget.DojoGrid");
	dojo.declare("wm.DojoGrid", wm.Control, {margin:4, width:"100%", height:"200px", variable:null, dataSet:null, dsType:null, store:null, query:"", dojoObj:null, singleClickEdit:false, selectedItem:null, emptySelection:true, isRowSelected:false, selectionMode:"single", addDialogName:"", addFormName:"", columns:[], selectFirstRow:false, caseSensitiveSort:true, init:function () {
		dojo["require"]("dojox.grid.DataGrid");
		dojo["require"]("dojox.grid.cells.dijit");
		dojo["require"]("dojo.data.ItemFileWriteStore");
		dojo["require"]("dojo.string");
		dojo["require"]("wm.base.lib.currencyMappings");
		dojo["require"]("dijit.Dialog");
		this.inherited(arguments);
		var varProps = {name:"selectedItem", owner:this, json:this.selectionMode == "multiple" ? "[]" : "", type:this.variable ? this.variable.type : "any"};
		this.selectedItem = new wm.Variable(varProps);
		this.updateSelectedItem(-1);
		this.setSelectionMode(this.selectionMode);
		this.updateDOMNode();
	}, updateDOMNode:function () {
		if (this.showAddButton || this.showDeleteButton) {
			if (!this.actionNode) {
				this.actionNode = dojo.create("div", {style:"height:27px"}, this.domNode);
				this.gridNode = dojo.create("div", {style:"width:100%;height:100%"}, this.domNode);
			}
			this.addActionButtons();
		} else {
			if (this.actionNode) {
				dojo.destroy(this.actionNode);
				delete this.actionNode;
			}
			this.gridNode = this.domNode;
		}
	}, postInit:function () {
		this.inherited(arguments);
		var thisObj = this;
		if (this.addDialogName && this.addDialogName != "") {
			this.addDialog = this.widgets[this.addDialogName];
			if (this.isDesignLoaded()) {
				this.addDialog.setOwner(this);
			}
			if (this.addDialog) {
				this.liveForm = this.addDialog.widgets[this.addFormName];
				if (this.liveForm) {
					dojo.connect(this.liveForm, "cancelEdit", this, "cancelEdit");
					dojo.connect(this.liveForm, "onSuccess", this, "_onDBAddRow");
					dojo.connect(this.liveForm, "onDeleteData", this, "_onDBDeleteRow");
				}
			}
		}
		if (this.variable && this.variable.getData()) {
			this.renderDojoObj();
		}
	}, dataSetToSelectedItem:function () {
		this.selectedItem.setLiveView((this.variable || 0).liveView);
		this.selectedItem.setType(this.variable && this.variable.type ? this.variable.type : "any");
	}, setSelectedRow:function (rowIndex, isSelected) {
		if (isSelected == undefined) {
			isSelected = true;
		}
		if (isSelected) {
			this.dojoObj.selection.select(rowIndex);
		} else {
			this.dojoObj.selection.setSelected(rowIndex, isSelected);
		}
	}, selectItemOnGrid:function (obj, pkList) {
		if (!this.store) {
			return;
		}
		if (obj instanceof wm.Variable) {
			obj = obj.getData();
		}
		var dateFields = this.getDateFields();
		if (!pkList) {
			pkList = wm.data.getIncludeFields(this.variable.type);
		}
		var q = {};
		dojo.forEach(pkList, function (f) {
			q[f] = obj[f];
			if (dateFields.indexOf(f) != -1) {
				q[f] = new Date(obj[f]);
			}
		});
		var _this = this;
		var sItem = function (items, request) {
			if (items.length < 1) {
				return;
			}
			var idx = _this.dojoObj.getItemIndex(items[0]);
			if (idx == -1) {
				idx = _this.variable.getItemIndexByPrimaryKey(obj, pkList) || -1;
			}
			if (idx >= 0) {
				setTimeout(function () {
					_this.setSelectedRow(idx);
					_this.dojoObj.scrollToRow(idx);
				}, 0);
			}
		};
		this.store.fetch({query:q, onComplete:sItem});
	}, deselect:function () {
		this.updateSelectedItem(-1);
		this.onSelectionChange();
	}, select:function () {
		if (this.selectionMode == "multiple") {
			this.updateAllSelectedItem();
		} else {
			this.updateSelectedItem(this.getSelectedIndex());
		}
		this.onSelectionChange();
	}, selectionChange:function () {
		if (this.selectionMode == "multiple") {
			this.updateAllSelectedItem();
		} else {
			this.updateSelectedItem(this.getSelectedIndex());
		}
		this.onSelectionChange();
	}, cellEditted:function (inValue, inRowIndex, inFieldName) {
		var rowIdx = this.getSelectedIndex();
		if (rowIdx != inRowIndex) {
			this.setSelectedRow(inRowIndex, true);
		} else {
			var oldObj = this.selectedItem.getData();
			if (oldObj[inFieldName] == inValue) {
				return;
			}
		}
		this.updateSelectedItem(this.getSelectedIndex());
		this.onCellEditted(inValue, inRowIndex, inFieldName);
	}, updateSelectedItem:function (selectedIndex) {
		if (selectedIndex == -1) {
			this.selectedItem.clearData();
		} else {
			var newdata = this.itemToJSONObject(this.store, this.getRowData(selectedIndex));
			for (prop in newdata) {
				if (newdata[prop] instanceof Date) {
					newdata[prop] = newdata[prop].getTime();
				}
			}
			this.selectedItem.setData(newdata);
		}
		this.setValue("emptySelection", !this.hasSelection());
		this.setValue("isRowSelected", this.hasSelection());
	}, updateAllSelectedItem:function () {
		if (!this.dojoObj) {
			return;
		}
		this.selectedItem.clearData();
		var items = this.dojoObj.selection.getSelected();
		var objList = [];
		dojo.forEach(items, function (obj) {
			objList.push(this.itemToJSONObject(this.store, obj));
		}, this);
		this.selectedItem._setArrayData(objList);
	}, onSelectionChange:function () {
	}, onCellEditted:function (inValue, inRowIndex, inFieldName) {
	}, getSelectedIndex:function () {
		if (!this.dojoObj) {
			return -1;
		}
		return this.dojoObj.selection.selectedIndex;
	}, getRowData:function (rowIndex) {
		return this.dojoObj.getItem(rowIndex);
	}, findRowIndexByFieldValue:function (inFieldName, inFieldValue) {
		var item;
		for (var i = 0; i < this.getRowCount(); i++) {
			item = this.dojoObj.getItem(i);
			if (this.store.getValue(item, inFieldName) == inFieldValue) {
				return this.dojoObj.getItemIndex(item);
			}
		}
		return -1;
	}, getCell:function (rowIndex, fieldName) {
		var item = this.dojoObj.getItem(rowIndex);
		return this.dojoObj.store.getValue(item, fieldName);
	}, editCell:function (rowIndex, fieldName) {
		var cells = this.dojoObj.layout.cells;
		for (var i = 0; i < cells.length; i++) {
			if (cells[i].field == fieldName) {
				this.dojoObj.edit.setEditCell(cells[i], rowIndex);
				return;
			}
		}
	}, setCell:function (rowIndex, fieldName, newValue) {
		if (rowIndex < 0) {
			console.error("setCell requires 0 or greater for row index");
			return;
		}
		var item = this.dojoObj.getItem(rowIndex);
		this.dojoObj.store.setValue(item, fieldName, newValue);
		if (this.getSelectedIndex() == rowIndex) {
			this.updateSelectedItem(rowIndex);
		}
	}, deleteRow:function (rowIndex) {
		this.updateSelectedItem(-1);
		var item = this.getRowData(rowIndex);
		this.dojoObj.store.deleteItem(item);
	}, addRow:function (inFields, selectOnAdd) {
		if (this.getRowCount() == 0 && this.variable) {
			this.variable.setData([inFields]);
			this.renderDojoObj();
			if (selectOnAdd) {
				this.setSelectedRow(0);
				this.selectionChange();
			}
			return;
		}
		var data = dojo.clone(inFields);
		var schema = this.selectedItem._dataSchema;
		for (var key in schema) {
			if (!(key in data)) {
				data[key] = "";
			}
		}
		var result = this.store.newItem(data);
		if (selectOnAdd) {
			var rowNumb = this.dojoObj.getItemIndex(result);
			this.setSelectedRow(rowNumb);
			this.selectionChange();
			var self = this;
			setTimeout(function () {
				self.dojoObj.scrollToRow(rowNumb);
			}, 0);
		}
		return result;
	}, getRowCount:function () {
		return this.dojoObj.rowCount;
	}, hasSelection:function () {
		return Boolean(this.getSelectedIndex() != -1);
	}, getEmptySelection:function () {
		return !this.hasSelection();
	}, getEmptySelection:function () {
		var result = Boolean(!this.selectedItem.getData() || this.getSelectedIndex() == -1);
		return result;
	}, getIsRowSelected:function () {
		return !this.getEmptySelection();
	}, renderBounds:function () {
		this.inherited(arguments);
		if (this.showAddButton || this.showDeleteButton) {
			var position = this.getStyleBounds();
			this.gridNode.style.height = (position.h - 27) + "px";
		}
		this.resizeDijit();
	}, resizeDijit:function () {
		if (this.dojoObj) {
			this.dojoObj.resize();
		}
	}, renderDojoObj:function () {
		if (this._cupdating) {
			return;
		}
		if (this.dojoObj != null) {
			this.dojoObj.destroy();
			this.dojoObj = null;
		}
		if (!this.variable) {
			return;
		}
		var structure = this.getStructure();
		if (structure[0].length == 0) {
			structure = {};
		}
		var props = {escapeHTMLInData:false, structure:structure, store:this.store, singleClickEdit:this.singleClickEdit, columnReordering:true, query:this.query || {}};
		this.dojoObj = new dojox.grid.DataGrid(props, dojo.create("div", {style:"width:100%;height:100%"}, this.gridNode));
		this.connectDojoEvents();
		this.setSelectionMode(this.selectionMode);
		this.dojoRenderer();
		if (!this.selectedItem.getData() && this.selectFirstRow) {
			this.updateSelectedItem(0);
		}
		var selectedData = this.selectedItem.getData();
		if (selectedData) {
			this.selectItemOnGrid(this.selectedItem);
		}
		if (this.isDesignLoaded()) {
			var scrollNode = this.dojoObj.scroller.contentNodes[0].parentNode;
			if (dojo.isFF) {
				this.connect(scrollNode, "onmousedown", this, function (evt) {
					if (evt.button == 2 || evt.ctrlKey) {
						dojo.stopEvent(evt);
						this.showMenuDialog();
					}
				});
			}
			if (dojo.isWebKit) {
				this.connect(scrollNode, "oncontextmenu", this, function (evt) {
					dojo.stopEvent(evt);
					this.showMenuDialog();
					return false;
				});
			}
		}
	}, dojoRenderer:function () {
		if (!this.dojoObj) {
			return;
		}
		this.dojoObj.startup();
	}, connectDojoEvents:function () {
		dojo.connect(this.dojoObj, "onSelectionChanged", this, "selectionChange");
		if (this.isDesignLoaded()) {
			dojo.connect(this.dojoObj, "onMoveColumn", this, "_onMoveColumn");
			dojo.connect(this.dojoObj, "onResizeColumn", this, "_onResizeColumn");
			dojo.connect(this.dojoObj.domNode, "oncontextmenu", this, "showMenuDialog");
			if (dojo.isFF) {
				dojo.connect(this.dojoObj, "onHeaderCellMouseDown", this, function (evt) {
					if (evt.button == 2 || evt.ctrlKey) {
						dojo.stopEvent(evt);
						this.showMenuDialog();
					}
				});
			} else {
				dojo.connect(this.dojoObj, "onHeaderContextMenu", this, "showMenuDialog");
			}
			dojo.connect(this.dojoObj, "onRowContextMenu", this, "showMenuDialog");
			dojo.connect(this.dojoObj, "onCellContextMenu", this, "showMenuDialog");
		} else {
			dojo.connect(this.dojoObj, "onCellContextMenu", this, "_onCellRightClick");
			dojo.connect(this.dojoObj, "onApplyCellEdit", this, "cellEditted");
			dojo.connect(this.dojoObj, "onClick", this, "_onClick");
			dojo.connect(this.dojoObj, "onCellDblClick", this, "_onCellDblClick");
		}
	}, getDataSet:function () {
		return this.variable;
	}, setDataSet:function (inValue, inDefault) {
		this.variable = inValue;
		if (this.variable) {
			this.dataSetToSelectedItem();
		}
		if (this.isDesignLoaded() && !this._loading) {
			this.setColumnData();
		}
		this.setDojoStore();
		var thisObj = this;
		dojo.addOnLoad(function () {
			thisObj.renderDojoObj();
		});
	}, customSort:function (a, b) {
		return "";
	}, setDojoStore:function () {
		if (!this.variable) {
			this.store = null;
			this.dsType = null;
			return;
		}
		var storeData = {"items":[]};
		var dataList = this.variable.getData();
		if (this.customSort != this.constructor.prototype.customSort && dojo.isFunction(this.customSort)) {
			dataList = dataList.sort(this.customSort);
		}
		var dateFields = this.getDateFields();
		dojo.forEach(dataList, function (obj) {
			var dates = {};
			dojo.forEach(dateFields, function (f) {
				if (obj[f]) {
					dates[f] = new Date(obj[f]);
				}
			});
			storeData.items[storeData.items.length] = dojo.mixin({}, obj, dates);
		}, this);
		this.store = new dojo.data.ItemFileWriteStore({data:storeData});
		if (!this.caseSensitiveSort) {
			this.makeSortingInsensitive();
		}
	}, makeSortingInsensitive:function () {
		this.store.comparatorMap = {};
		dojo.forEach(this.columns, function (col) {
			if (col.displayType == "Text") {
				this.store.comparatorMap[col.id] = dojo.hitch(this, "sortNoCase");
			}
		}, this);
	}, sortNoCase:function (a, b) {
		var a = a.toLowerCase();
		var b = b.toLowerCase();
		if (a > b) {
			return 1;
		}
		if (a < b) {
			return -1;
		}
		return 0;
	}, setQuery:function (q) {
		this.query = q;
		if (this.dojoObj) {
			this.dojoObj.setQuery(q);
		}
	}, getStructure:function () {
		var structure = [];
		var hasAutoField = false;
		dojo.forEach(this.columns, function (col) {
			var obj = {hidden:(!col.show), field:col.id, name:col.title, width:col.width, fieldType:col.fieldType, editable:col.editable, expression:col.expression, displayType:col.displayType};
			if (col.show && col.width && col.width == "auto") {
				hasAutoField = true;
			}
			if (col.align && col.align != "") {
				obj.styles = "text-align:" + col.align + ";";
			}
			if (col.formatFunc && col.formatFunc != "") {
				switch (col.formatFunc) {
				  case "wm_date_formatter":
					obj.formatter = dojo.hitch(this, "dateFormatter");
					break;
				  case "wm_number_formatter":
					obj.formatter = dojo.hitch(this, "numberFormatter");
					break;
				  case "wm_currency_formatter":
					obj.formatter = dojo.hitch(this, "currencyFormatter");
					break;
				  case "wm_image_formatter":
					obj.formatter = dojo.hitch(this, "imageFormatter");
					break;
				  default:
					if (!this.isDesignLoaded()) {
						obj.formatter = dojo.hitch(this.owner, col.formatFunc);
					}
					break;
				}
			}
			if (obj.fieldType && obj.fieldType != "") {
				obj.type = dojo.getObject(obj.fieldType);
			}
			if (obj.expression && obj.expression != "" && !obj.get) {
				obj.get = dojo.hitch(this, "getExpressionValue", obj.expression);
			} else {
				if (obj.field && obj.field.indexOf(".") != -1) {
					obj.get = dojo.hitch(this, "getExpressionValue", "${" + obj.field + "}");
				}
			}
			structure.push(obj);
		}, this);
		if (!hasAutoField) {
			structure.push({field:"wmAutoField", name:" ", width:"auto", value:" "});
		}
		structure = [structure];
		return structure;
	}, setColumnData:function () {
		if (!this.variable || (this.variable.type == this.dsType && this.columns.length > 0)) {
			return;
		}
		this.dsType = this.variable.type;
		this.columns = [];
		var viewFields = this.getViewFields();
		dojo.forEach(viewFields, function (f, i) {
			this.columns.push({show:i < 15, id:f.dataIndex, title:wm.capitalize(f.dataIndex), width:"auto", displayType:f.displayType, noDelete:true, align:f.displayType == "Number" ? "right" : "left"});
		}, this);
		if (this.isDesignLoaded()) {
			if (!this.contextMenu) {
				this.designCreate();
			}
			this.contextMenu.setDataSet(this.columns);
		}
	}, getDateFields:function () {
		var dateFields = [];
		dojo.forEach(this.columns, function (col) {
			if (col.displayType == "Date") {
				dateFields.push(col.id);
			}
		});
		return dateFields;
	}, setSelectionMode:function (inMode) {
		this.selectionMode = inMode;
		if (this.dojoObj) {
			this.dojoObj.selection.setMode(this.selectionMode);
		}
	}, getViewFields:function () {
		var fields = [];
		if (this.variable instanceof wm.LiveVariable) {
			fields = this.variable.getViewFields();
		} else {
			if (this.variable instanceof wm.Variable) {
				for (prop in this.variable._dataSchema) {
					if (this.variable._dataSchema[prop].isList) {
						continue;
					}
					fields[fields.length] = {dataIndex:prop};
				}
			}
		}
		return fields;
	}, _onGridEvent:function (evt) {
		var params = {};
		if (!evt.grid) {
			return params;
		}
		params.cellNode = evt.cellNode;
		params.rowNode = evt.rowNode;
		params.rowId = evt.rowIndex;
		params.selectedItem = this.selectedItem;
		params.fieldId = evt.cell.field;
		return params;
	}, _onClick:function (evt) {
		var params = this._onGridEvent(evt);
		this.onClick(evt, params.selectedItem, params.rowId, params.fieldId, params.rowNode, params.cellNode);
	}, _onCellDblClick:function (evt) {
		var params = this._onGridEvent(evt);
		this.onCellDblClick(evt, params.selectedItem, params.rowId, params.fieldId, params.rowNode, params.cellNode);
	}, _onCellRightClick:function (evt) {
		var params = this._onGridEvent(evt);
		this.onCellRightClick(evt, params.selectedItem, params.rowId, params.fieldId, params.rowNode, params.cellNode);
	}, onClick:function (evt, selectedItem, rowId, fieldId, rowNode, cellNode) {
	}, onCellDblClick:function (evt, selectedItem, rowId, fieldId, rowNode, cellNode) {
	}, onCellRightClick:function (evt, selectedItem, rowId, fieldId, rowNode, cellNode) {
	}, addColumnToCSV:function (csvArray, value) {
		if (dojo.isString(value)) {
			value = value.replace(/\"/g, "\\\"");
		}
		csvArray.push("\"" + value + "\"");
		csvArray.push(",");
	}, addBreakToCSV:function (csvArray) {
		csvArray.pop();
		csvArray.push("<br>");
	}, showCSVData:function () {
		if (!this.csvDialog) {
			this.csvDialog = new dijit.Dialog({title:"CSV Data for " + this.name});
			dojo.body().appendChild(this.csvDialog.domNode);
			this.csvDialog.startup();
		}
		this.csvDialog.attr("content", this.toCSV());
		this.csvDialog.show();
	}, toCSV:function () {
		var csvData = [];
		dojo.forEach(this.columns, function (col, idx) {
			if (!col.show) {
				return;
			}
			this.addColumnToCSV(csvData, col.title);
		}, this);
		if (csvData.length == 0) {
			return "CSV Data cannot be extracted for this Grid.";
		}
		this.addBreakToCSV(csvData);
		var dataList = this.variable.getData();
		dojo.forEach(dataList, function (obj) {
			dojo.forEach(this.columns, function (col, idx) {
				if (!col.show) {
					return;
				}
				var value = obj[col.id];
				if (col.expression) {
					value = this.getExpressionValue(col.expression, idx, obj, true);
				} else {
					if (col.formatFunc) {
						switch (col.formatFunc) {
						  case "wm_date_formatter":
							value = this.dateFormatter(value);
							break;
						  case "wm_number_formatter":
							value = this.numberFormatter(value);
							break;
						  case "wm_currency_formatter":
							value = this.currencyFormatter(value);
							break;
						  case "wm_image_formatter":
							value = this.imageFormatter(value);
							break;
						  default:
							if (!this.isDesignLoaded()) {
								value = dojo.hitch(this.owner, col.formatFunc)(value);
							}
							break;
						}
					}
				}
				this.addColumnToCSV(csvData, value);
			}, this);
			this.addBreakToCSV(csvData);
		}, this);
		return csvData.join("");
	}, getExpressionValue:function (exp, idx, dataObj, isSimpleDataObj) {
		var expValue = "..";
		if (!dataObj) {
			return expValue;
		}
		var json = dataObj;
		if (!isSimpleDataObj) {
			json = this.itemToJSONObject(this.store, dataObj);
		}
		if (!json) {
			return expValue;
		}
		try {
			expValue = wm.expression.getValue(exp, json);
		}
		catch (e) {
		}
		return expValue;
	}, dateFormatter:function (inDatum) {
		var constraints = {selector:"date", formatLength:"short", locale:dojo.locale};
		return dojo.date.locale.format(new Date(inDatum), constraints);
	}, numberFormatter:function (inValue) {
		return dojo.number.format(inValue);
	}, currencyFormatter:function (inValue) {
		return dojo.currency.format(inValue, {currency:wm.getLocaleCurrency()});
	}, imageFormatter:function (inValue) {
		console.info("image inValue = ", inValue);
		if (inValue && inValue != "") {
			return "<img src=\"" + inValue + "\">";
		}
		return inValue;
	}, addActionButtons:function () {
		if (this.showAddButton && !this.addButton) {
			this.addButton = this.createActionButton("Add", dojo.hitch(this, "addActionCall"), this.actionNode);
		}
		if (this.showDeleteButton && !this.deleteButton) {
			this.deleteButton = this.createActionButton("Delete", dojo.hitch(this, "deleteActionCall"), this.actionNode);
		}
	}, createActionButton:function (title, onclick, parentNode) {
		var button = dojo.create("span", {"innerHTML":title, "class":"gridActionButton"}, parentNode);
		this._connections.push(dojo.connect(button, "onclick", onclick));
		this._connections.push(dojo.connect(button, "onmousedown", this, "actionButtonMouseDown"));
		this._connections.push(dojo.connect(button, "onmouseup", this, "actionButtonMouseUp"));
		return button;
	}, actionButtonMouseDown:function (evt) {
		dojo.toggleClass(evt.currentTarget, "gridActionButtonMouseDown");
	}, actionButtonMouseUp:function (evt) {
		dojo.toggleClass(evt.currentTarget, "gridActionButtonMouseDown");
	}, addActionCall:function (evt) {
		if (this.addDialog) {
			this.addDialog.show();
		}
		if (this.liveForm) {
			this.liveForm.beginDataInsert();
		}
		this.onAddButtonClick(evt);
	}, cancelEdit:function () {
		this.addDialog.hide();
	}, _onDBAddRow:function (inData) {
		this.addRow(inData, true);
		this.addDialog.hide();
	}, _onDBDeleteRow:function (inResult) {
		this.deleteRow(this.deletingRowIdx);
		this.onDeleteSuccess(inResult);
	}, deleteActionCall:function () {
		this.deletingRowIdx = this.getSelectedIndex();
		this.liveForm.setDataSet(this.selectedItem);
		this.liveForm._confirmDelete = false;
		this.liveForm.deleteData();
	}, onDeleteSuccess:function (inResult) {
	}, saveActionCall:function () {
	}, onAddButtonClick:function (inEvent) {
	}, getNumColumns:function (includeInvisibleColumns) {
		if (includeInvisibleColumns) {
			return this.columns.length;
		}
		return dojo.filter(this.columns, function (col) {
			return col.show;
		}).length;
	}, getNumRows:function () {
		return this.getRowCount();
	}, getRow:function (idx) {
		return this.itemToJSONObject(this.store, this.getRowData(idx) || {});
	}});
	wm.DojoGrid.description = "A dojo grid.";
	wm.DojoGrid.extend({itemToJSONObject:function (store, item) {
		var json = {};
		if (item && store) {
			var attributes = store.getAttributes(item);
			if (attributes && attributes.length > 0) {
				var i;
				for (i = 0; i < attributes.length; i++) {
					var values = store.getValues(item, attributes[i]);
					if (values) {
						if (values.length > 1) {
							var j;
							json[attributes[i]] = [];
							for (j = 0; j < values.length; j++) {
								var value = values[j];
								if (store.isItem(value)) {
									json[attributes[i]].push(this.itemToJSONObject(store, value));
								} else {
									json[attributes[i]].push(value);
								}
							}
						} else {
							if (store.isItem(values[0])) {
								json[attributes[i]] = this.itemToJSONObject(store, values[0]);
							} else {
								json[attributes[i]] = values[0];
							}
						}
					}
				}
			}
		}
		return json;
	}});
}
if (!dojo._hasResource["wm.base.widget.DojoGrid_design"]) {
	dojo._hasResource["wm.base.widget.DojoGrid_design"] = true;
	dojo.provide("wm.base.widget.DojoGrid_design");
	wm.DojoGrid.extend({editColumns:"(Edit Columns)", showAddDialog:"(Show Dialog)", fieldOptions:[{name:"Text", value:"dojox.grid.cells._Widget"}, {name:"Number", value:"dojox.grid.cells.NumberTextBox"}, {name:"Date", value:"dojox.grid.cells.DateTextBox"}, {name:"Checkbox", value:"dojox.grid.cells.Bool"}], headerAttr:[{id:"show", title:" ", width:"2%", type:"checkbox"}, {id:"id", title:"Field", width:"15%", type:"text", readOnly:true}, {id:"title", title:"Title", width:"15%", type:"text"}, {id:"width", title:"Width", width:"13%", type:"width"}, {id:"align", title:"Alignment", width:"10%", type:"dropdown"}, {id:"formatFunc", title:"Format", width:"15%", type:"dropdown"}, {id:"fieldType", title:"Edit Field Type", width:"12%", type:"dropdown", isAdvanced:true}, {id:"editable", title:"Editable", width:"2%", type:"checkbox", isAdvanced:true}, {id:"expression", title:"Data Expression", width:"20%", type:"text", isAdvanced:true}], defaultFormatters:[{name:"", value:""}, {name:"Currency (WaveMaker)", value:"wm_currency_formatter"}, {name:"Date (WaveMaker)", value:"wm_date_formatter"}, {name:"Number (WaveMaker)", value:"wm_number_formatter"}, {name:"Image (WaveMaker)", value:"wm_image_formatter"}], themeableStyles:[], themeableSharedStyles:["-Even Rows", "Row-Background-Color", "Row-Font-Color", "-Odd Rows", "Row-Background-Odd-Color", "Row-Font-Odd-Color", "-Hover Row", "Row-Background-Hover-Color", "Row-Font-Hover-Color", "-Selected Row", "Row-Background-Selected-Color", "Row-Font-Selected-Color", "-Misc", "Row-Border-Color", "-Header Styles", "Header-Background-Color", "Header-Font-Color", "Header-Image", "Header-Image-Position", "Header-Image-Repeat"], afterPaletteDrop:function () {
		this.caption = this.caption || this.name;
		this.renderDojoObj();
	}, set_dataSet:function (inDataSet) {
		if (inDataSet && !(inDataSet instanceof wm.Variable)) {
			var ds = this.getValueById(inDataSet);
			if (ds) {
				this.components.binding.addWire("", "dataSet", ds.getId());
			}
		} else {
			this.setDataSet(inDataSet);
		}
	}, designCreate:function () {
		if (this._studioCreating) {
			this.studioCreate();
		}
		this.inherited(arguments);
		this.headerAttr[4].dataStore = this.getAlignmentTypeStore();
		this.updateFormatterList();
		this.headerAttr[5].dataStore = this.formatterStore;
		this.updateFieldTypeList(this.fieldOptions);
		this.headerAttr[6].dataStore = this.fieldTypeStore;
		var defaultCustomFieldParams = {id:"customField", isCustomField:true, expression:"", show:true, width:"auto"};
		var helpText = "* To re-arrange columns close dialog box and drag columns on grid to desired position.<br>* You can right click on grid to open this dialog.";
		this.contextMenu = new wm.ContextMenuDialog("DojoGrid Column Properties", "Add Column", dojo.hitch(this, "addNewColumn"), this.headerAttr, this.columns, defaultCustomFieldParams, this.domNode, true, helpText);
		this.contextMenu.showModal = false;
		dojo.connect(this.contextMenu, "onPropChanged", this, "columnPropChanged");
		dojo.connect(this.contextMenu, "onRowDelete", this, "destroyColumn");
		dojo.connect(this.contextMenu, "onAddNewColumnSuccess", this, "columnAddSuccess");
	}, showMenuDialog:function (e) {
		this.updateFormatterList();
		this.contextMenu.show();
	}, columnPropChanged:function (obj, columnId, inValue, trObj, widget) {
		if (columnId && columnId == "width" && !isNaN(dojo.number.parse(inValue))) {
			obj.width = inValue + "px";
		}
		var addFormatter = false;
		if (columnId && columnId == "formatFunc" && inValue == "- Add Formatter") {
			var evtName = wm.getValidJsName("format" + wm.getValidJsName(wm.capitalize(obj.id)) + wm.capitalize(this.name));
			obj.formatFunc = evtName;
			widget.attr("value", evtName, false);
			addFormatter = true;
		}
		this.updateGridStructure();
		if (addFormatter) {
			this.contextMenu.hide();
			eventEdit(this, "_formatterSignature", evtName, true);
		}
	}, _formatterSignature:function (inValue) {
	}, destroyColumn:function () {
		this.updateGridStructure();
	}, columnAddSuccess:function () {
		this.updateGridStructure();
	}, updateFormatterList:function () {
		var fArray = dojo.clone(this.defaultFormatters);
		dojo.forEach(getAllEventsInCode(), function (f) {
			fArray.push({name:f, value:f});
		});
		fArray.push({name:"- Add Formatter", value:"- Add Formatter"});
		var data = {identifier:"value", label:"name", value:"value", items:fArray};
		if (!this.formatterStore) {
			this.formatterStore = new dojo.data.ItemFileReadStore({data:data});
		} else {
			this.formatterStore.reload(data);
		}
	}, updateFieldTypeList:function (options) {
		if (!this.fieldTypeStore) {
			var fieldTypeData = {identifier:"value", label:"name", value:"value", items:options};
			this.fieldTypeStore = new dojo.data.ItemFileWriteStore({data:fieldTypeData});
		} else {
			this.fieldTypeStore.attr("data", options);
		}
	}, getAlignmentTypeStore:function () {
		var fieldTypeData = {identifier:"value", label:"name", value:"value", items:[{name:"Left", value:"left"}, {name:"Center", value:"center"}, {name:"Right", value:"right"}]};
		return new dojo.data.ItemFileReadStore({data:fieldTypeData});
	}, getNewColumnId:function (cId) {
		if (!this.columnIds) {
			this.columnIds = {};
			dojo.forEach(this.columns, function (col) {
				if (col.id.indexOf(cId) != -1) {
					this.columnIds[col.id] = true;
				}
			}, this);
		}
		if (!this.columnIds[cId]) {
			this.columnIds[cId] = true;
			return cId;
		}
		var c = 1;
		while (this.columnIds["customField" + c]) {
			c++;
		}
		this.columnIds["customField" + c] = true;
		return "customField" + c;
	}, setShowAddButton:function (inValue) {
		this.showAddButton = inValue;
		this.updateDOMNode();
		this.renderDojoObj();
		this.addDialogForInsert();
	}, setShowDeleteButton:function (inValue) {
		this.showDeleteButton = inValue;
		this.updateDOMNode();
		this.renderDojoObj();
	}, setSingleClickEdit:function (inValue) {
		this.singleClickEdit = inValue;
		if (this.dojoObj) {
			this.dojoObj.singleClickEdit = this.singleClickEdit;
		}
		this.dojoObj.render();
	}, addNewColumn:function () {
		var customField = {id:this.getNewColumnId("customField"), isCustomField:true, expression:"", show:true, width:"auto"};
		return customField;
	}, addDialogForInsert:function () {
		try {
			if (!this.showAddButton) {
				return;
			}
			if (!this.addDialog) {
				this.addDialogName = studio.page.getUniqueName(this.name + "_AddDialog");
				this.addDialog = new wm.Dialog({width:320, height:95, name:this.addDialogName, fitToContentHeight:true, border:2, borderColor:"rgb(80,80,80)", parent:this, owner:this, modal:false, animateSlide:true});
			}
			if (!this.liveForm && this.variable instanceof wm.LiveVariable) {
				this.addFormName = studio.page.getUniqueName(this.name + "_AddForm");
				this.liveForm = new wm.LiveForm({name:this.addFormName, owner:this.owner, parent:this.addDialog, verticalAlign:"top", horizontalAlign:"left", _liveSource:this.variable.liveSource});
				this.liveForm.createLiveSource(this.liveForm._liveSource);
				this.liveForm.beginDataInsert();
				this.addDialog.setHeight(this.liveForm.height);
			}
		}
		catch (e) {
			console.info("error while creating dialog and live variable: ", e);
		}
	}, updateGridStructure:function () {
		this.columns = this.contextMenu.getUpdatedDataSet();
		this.dojoObj.attr("structure", this.getStructure());
		this.dojoObj.render();
	}, _onResizeColumn:function (idx, inDrag, delta) {
		var sArray = this.contextMenu.getUpdatedDataSet();
		sArray[idx].width = delta.w + "px";
		this.contextMenu.setDataSet(sArray);
		wm.fire(studio.inspector, "reinspect");
	}, _onMoveColumn:function (arg1, arg2, oldPos, newPos) {
		var sArray = this.contextMenu.getUpdatedDataSet();
		var tmp = sArray[oldPos];
		sArray.splice(oldPos, 1);
		sArray.splice(newPos, 0, tmp);
		this.contextMenu.setDataSet(sArray);
		wm.fire(studio.inspector, "reinspect");
	}, makePropEdit:function (inName, inValue, inDefault) {
		switch (inName) {
		  case "dataSet":
			return new wm.propEdit.DataSetSelect({component:this, name:inName, value:this.dataSet ? this.dataSet.getId() : "", allowAllTypes:true, listMatch:true});
		  case "selectionMode":
			return makeSelectPropEdit(inName, inValue, ["single", "multiple", "extended", "none"], inDefault);
		  case "editColumns":
			return makeReadonlyButtonEdit(inName, inValue, inDefault);
		  case "showAddDialog":
			return makeReadonlyButtonEdit(inName, inValue, inDefault);
		}
		return this.inherited(arguments);
	}, editProp:function (inName, inValue, inInspector) {
		switch (inName) {
		  case "editColumns":
			return this.showMenuDialog();
		  case "showAddDialog":
			if (this.addDialog) {
				this.addDialog.show();
			} else {
				this.addDialogForInsert();
			}
			return;
		}
		return this.inherited(arguments);
	}, writeProps:function () {
		try {
			var props = this.inherited(arguments);
			props.columns = this.contextMenu.getUpdatedDataSet();
			return props;
		}
		catch (e) {
			console.info("Error while saving dashboard data..............", e);
		}
	}});
	wm.Object.extendSchema(wm.DojoGrid, {variable:{ignore:1}, caption:{ignore:1}, scrollX:{ignore:1}, scrollY:{ignore:1}, disabled:{ignore:1}, query:{ignore:1}, editColumns:{group:"edit", order:40}, showAddDialog:{group:"edit", order:40}, singleClickEdit:{group:"edit", order:32}, caseSensitiveSort:{group:"display", order:40}, selectFirstRow:{group:"display", order:41}, store:{ignore:1}, menu:{ignore:1}, storeGUID:{ignore:1}, dataValue:{ignore:1}, selectedItem:{ignore:1, bindSource:1, simpleBindProp:true}, emptySelection:{ignore:true, bindSource:1, type:"Boolean"}, isRowSelected:{ignore:true, bindSource:1, type:"Boolean"}, dataSet:{bindTarget:1, group:"edit", order:30, isList:true}, selectionMode:{group:"edit", order:31}, rightClickTBody:{ignore:1}, addDialogName:{hidden:true}, addFormName:{hidden:true}, dsType:{hidden:true}, columns:{ignore:1}});
}
if (!dojo._hasResource["dijit.MenuBar"]) {
	dojo._hasResource["dijit.MenuBar"] = true;
	dojo.provide("dijit.MenuBar");
	dojo.declare("dijit.MenuBar", dijit._MenuBase, {templateString:dojo.cache("dijit", "templates/MenuBar.html", "<div class=\"dijitMenuBar dijitMenuPassive\" dojoAttachPoint=\"containerNode\"  waiRole=\"menubar\" tabIndex=\"${tabIndex}\" dojoAttachEvent=\"onkeypress: _onKeyPress\"></div>\r\n"), _isMenuBar:true, constructor:function () {
		this._orient = this.isLeftToRight() ? {BL:"TL"} : {BR:"TR"};
	}, postCreate:function () {
		var k = dojo.keys, l = this.isLeftToRight();
		this.connectKeyNavHandlers(l ? [k.LEFT_ARROW] : [k.RIGHT_ARROW], l ? [k.RIGHT_ARROW] : [k.LEFT_ARROW]);
	}, focusChild:function (item) {
		var prev_item = this.focusedChild, showpopup = prev_item && prev_item.popup && prev_item.popup.isShowingNow;
		this.inherited(arguments);
		if (showpopup && item.popup && !item.disabled) {
			this._openPopup();
		}
	}, _onKeyPress:function (evt) {
		if (evt.ctrlKey || evt.altKey) {
			return;
		}
		switch (evt.charOrCode) {
		  case dojo.keys.DOWN_ARROW:
			this._moveToPopup(evt);
			dojo.stopEvent(evt);
		}
	}, onItemClick:function (item, evt) {
		if (item.popup && item.popup.isShowingNow) {
			item.popup.onCancel();
		} else {
			this.inherited(arguments);
		}
	}});
}
if (!dojo._hasResource["dijit.MenuBarItem"]) {
	dojo._hasResource["dijit.MenuBarItem"] = true;
	dojo.provide("dijit.MenuBarItem");
	dojo.declare("dijit._MenuBarItemMixin", null, {templateString:dojo.cache("dijit", "templates/MenuBarItem.html", "<div class=\"dijitReset dijitInline dijitMenuItem dijitMenuItemLabel\" dojoAttachPoint=\"focusNode\" waiRole=\"menuitem\" tabIndex=\"-1\"'\r\n\t\tdojoAttachEvent=\"onmouseenter:_onHover,onmouseleave:_onUnhover,ondijitclick:_onClick\">\r\n\t<span dojoAttachPoint=\"containerNode\"></span>\r\n</div>\r\n"), attributeMap:dojo.delegate(dijit._Widget.prototype.attributeMap, {label:{node:"containerNode", type:"innerHTML"}})});
	dojo.declare("dijit.MenuBarItem", [dijit.MenuItem, dijit._MenuBarItemMixin], {});
}
if (!dojo._hasResource["dijit.PopupMenuBarItem"]) {
	dojo._hasResource["dijit.PopupMenuBarItem"] = true;
	dojo.provide("dijit.PopupMenuBarItem");
	dojo.declare("dijit.PopupMenuBarItem", [dijit.PopupMenuItem, dijit._MenuBarItemMixin], {});
}
if (!dojo._hasResource["dojox.html.styles"]) {
	dojo._hasResource["dojox.html.styles"] = true;
	dojo.provide("dojox.html.styles");
	(function () {
		var dynamicStyleMap = {};
		var pageStyleSheets = {};
		var titledSheets = [];
		var styleIndicies = [];
		dojox.html.insertCssRule = function (selector, declaration, styleSheetName) {
			var ss = dojox.html.getDynamicStyleSheet(styleSheetName);
			var styleText = selector + " {" + declaration + "}";
			console.log("insertRule:", styleText);
			if (dojo.isIE) {
				ss.cssText += styleText;
				console.log("ss.cssText:", ss.cssText);
			} else {
				if (ss.sheet) {
					ss.sheet.insertRule(styleText, ss._indicies.length);
				} else {
					ss.appendChild(dojo.doc.createTextNode(styleText));
				}
			}
			ss._indicies.push(selector + " " + declaration);
			return selector;
		};
		dojox.html.removeCssRule = function (selector, declaration, styleSheetName) {
			var ss;
			var index = -1;
			for (var nm in dynamicStyleMap) {
				if (styleSheetName && styleSheetName != nm) {
					continue;
				}
				ss = dynamicStyleMap[nm];
				for (var i = 0; i < ss._indicies.length; i++) {
					if (selector + " " + declaration == ss._indicies[i]) {
						index = i;
						break;
					}
				}
				if (index > -1) {
					break;
				}
			}
			if (!ss) {
				console.log("No dynamic style sheet has been created from which to remove a rule.");
				return false;
			}
			if (index == -1) {
				console.log("The css rule was not found and could not be removed.");
				return false;
			}
			ss._indicies.splice(index, 1);
			if (dojo.isIE) {
				ss.removeRule(index);
			} else {
				if (ss.sheet) {
					ss.sheet.deleteRule(index);
				} else {
					if (document.styleSheets[0]) {
						console.log("what browser hath useth thith?");
					}
				}
			}
			return true;
		};
		dojox.html.getStyleSheet = function (styleSheetName) {
			if (dynamicStyleMap[styleSheetName || "default"]) {
				return dynamicStyleMap[styleSheetName || "default"];
			}
			if (!styleSheetName) {
				return false;
			}
			var allSheets = dojox.html.getStyleSheets();
			if (allSheets[styleSheetName]) {
				return dojox.html.getStyleSheets()[styleSheetName];
			}
			for (var nm in allSheets) {
				if (allSheets[nm].href && allSheets[nm].href.indexOf(styleSheetName) > -1) {
					return allSheets[nm];
				}
			}
			return false;
		};
		dojox.html.getDynamicStyleSheet = function (styleSheetName) {
			if (!styleSheetName) {
				styleSheetName = "default";
			}
			if (!dynamicStyleMap[styleSheetName]) {
				if (dojo.doc.createStyleSheet) {
					dynamicStyleMap[styleSheetName] = dojo.doc.createStyleSheet();
					dynamicStyleMap[styleSheetName].title = styleSheetName;
				} else {
					dynamicStyleMap[styleSheetName] = dojo.doc.createElement("style");
					dynamicStyleMap[styleSheetName].setAttribute("type", "text/css");
					dojo.doc.getElementsByTagName("head")[0].appendChild(dynamicStyleMap[styleSheetName]);
					console.log(styleSheetName, " ss created: ", dynamicStyleMap[styleSheetName].sheet);
				}
				dynamicStyleMap[styleSheetName]._indicies = [];
			}
			return dynamicStyleMap[styleSheetName];
		};
		dojox.html.enableStyleSheet = function (styleSheetName) {
			var ss = dojox.html.getStyleSheet(styleSheetName);
			if (ss) {
				if (ss.sheet) {
					ss.sheet.disabled = false;
				} else {
					ss.disabled = false;
				}
			}
		};
		dojox.html.disableStyleSheet = function (styleSheetName) {
			var ss = dojox.html.getStyleSheet(styleSheetName);
			if (ss) {
				if (ss.sheet) {
					ss.sheet.disabled = true;
				} else {
					ss.disabled = true;
				}
			}
		};
		dojox.html.activeStyleSheet = function (title) {
			var sheets = dojox.html.getToggledStyleSheets();
			if (arguments.length == 1) {
				dojo.forEach(sheets, function (s) {
					s.disabled = (s.title == title) ? false : true;
				});
			} else {
				for (var i = 0; i < sheets.length; i++) {
					if (sheets[i].disabled == false) {
						return sheets[i];
					}
				}
			}
			return true;
		};
		dojox.html.getPreferredStyleSheet = function () {
		};
		dojox.html.getToggledStyleSheets = function () {
			if (!titledSheets.length) {
				var sObjects = dojox.html.getStyleSheets();
				for (var nm in sObjects) {
					if (sObjects[nm].title) {
						titledSheets.push(sObjects[nm]);
					}
				}
			}
			return titledSheets;
		};
		dojox.html.getStyleSheets = function () {
			if (pageStyleSheets.collected) {
				return pageStyleSheets;
			}
			var sheets = dojo.doc.styleSheets;
			dojo.forEach(sheets, function (n) {
				var s = (n.sheet) ? n.sheet : n;
				var name = s.title || s.href;
				if (dojo.isIE) {
					if (s.cssText.indexOf("#default#VML") == -1) {
						if (s.href) {
							pageStyleSheets[name] = s;
						} else {
							if (s.imports.length) {
								dojo.forEach(s.imports, function (si) {
									pageStyleSheets[si.title || si.href] = si;
								});
							} else {
								pageStyleSheets[name] = s;
							}
						}
					}
				} else {
					pageStyleSheets[name] = s;
					pageStyleSheets[name].id = s.ownerNode.id;
					dojo.forEach(s.cssRules, function (r) {
						if (r.href) {
							pageStyleSheets[r.href] = r.styleSheet;
							pageStyleSheets[r.href].id = s.ownerNode.id;
						}
					});
				}
			});
			pageStyleSheets.collected = true;
			return pageStyleSheets;
		};
	})();
}
if (!dojo._hasResource["wm.base.widget.DojoMenu"]) {
	dojo._hasResource["wm.base.widget.DojoMenu"] = true;
	dojo.provide("wm.base.widget.DojoMenu");
	dojo.declare("wm.DojoMenu", wm.Control, {padding:4, width:"100%", height:"35px", structure:"", fullStructure:null, dojoObj:null, menu:"", vertical:false, eventList:[], menuItems:[], init:function () {
		this.inherited(arguments);
		dojo.addClass(this.domNode, "dojoMenu");
	}, postInit:function () {
		this.inherited(arguments);
		var thisObj = this;
		dojo.addOnLoad(function () {
			thisObj.renderDojoObj();
		});
	}, setTransparent:function (inTrans) {
		this.transparent = inTrans;
		if (inTrans) {
			this.removeUserClass("ClickableDojoMenu");
		} else {
			this.addUserClass("ClickableDojoMenu");
		}
	}, getTransparent:function () {
		if (this._classes && this._classes.domNode) {
			return dojo.indexOf(this._classes.domNode, "ClickableDojoMenu") == -1;
		}
		return true;
	}, renderBounds:function () {
		this.inherited(arguments);
		if (this.dojoObj && this.dojoObj.domNode) {
			var bounds = this.getContentBounds();
			this.dojoObj.domNode.style.width = bounds.w + "px";
		}
	}, renderDojoObj:function () {
		if (this.dojoObj) {
			this.dojoObj.destroyRecursive();
		}
		this.menuItems = [];
		if (this.vertical) {
			this.dojoObj = new dijit.Menu({style:"width:0%"});
		} else {
			this.dojoObj = new dijit.MenuBar({});
		}
		dojo.addClass(this.dojoObj.domNode, this.id + "_CSS");
		this.dojoObj.placeAt(this.domNode);
		if (this.fullStructure) {
			var structure = dojo.clone(this.fullStructure);
			for (var i = 0; i < structure.length; i++) {
				var menuData = structure[i];
				this.addAdvancedMenuChildren(this.dojoObj, menuData, true);
			}
		} else {
			var structure = this.getStructure();
			for (var i = 0; i < structure.items.length; i++) {
				var menuData = structure.items[i];
				var menuItem = this.addMenuChildren(this.dojoObj, menuData, true);
				this.menuItems[this.menuItems.length] = menuItem;
			}
		}
		this.dojoRenderer();
	}, addMenuChildren:function (parentObj, data, isTop) {
		var menuObj = null;
		if (isTop) {
			if (this.vertical) {
				menuObj = new dijit.MenuItem({label:data.label});
			} else {
				menuObj = new dijit.PopupMenuBarItem({label:data.label});
			}
		} else {
			if (dojo.trim(data.label) == "separator") {
				menuObj = new dijit.MenuSeparator();
			} else {
				if (!data.children) {
					menuObj = new dijit.MenuItem({label:data.label});
				} else {
					menuObj = new dijit.PopupMenuItem({label:data.label});
				}
			}
		}
		var evtObj = this.getEventObj(this.getEventName(data.label));
		if (!this.isDesignLoaded() && evtObj && evtObj.onClick && evtObj.onClick != "") {
			var f = this.owner[evtObj.onClick];
			menuObj.onClick = this.owner.makeEvent(f, evtObj.onClick);
		}
		if (data.children && data.children.length > 0) {
			var subMenu = new dijit.Menu({});
			dojo.addClass(subMenu.domNode, this.owner.name + "_" + this.name + "_PopupMenu");
			for (var i = 0; i < data.children.length; i++) {
				var subMenuData = data.children[i];
				var menuItem = this.addMenuChildren(subMenu, subMenuData, false);
				this.menuItems[this.menuItems.length] = menuItem;
			}
			if (menuObj.arrowWrapper) {
				menuObj.arrowWrapper.style.visibility = "";
			}
			menuObj.popup = subMenu;
		}
		parentObj.addChild(menuObj);
		dojo.addClass(menuObj.domNode, this.id + "_CSS");
		return menuObj;
	}, addAdvancedMenuChildren:function (parentObj, data, isTop) {
		var menuObj = null;
		var onClick = data.onClick;
		delete data.onClick;
		var idInPage = data.idInPage;
		delete data.idInPage;
		if (isTop) {
			menuObj = new dijit.PopupMenuBarItem({label:data.label});
		} else {
			if (data.separator === true) {
				menuObj = new dijit.MenuSeparator();
			} else {
				menuObj = new dijit.MenuItem(data);
			}
		}
		if (!this.isDesignLoaded() && this.eventList[data.label] && this.eventList[data.label] != "") {
			menuObj.onClick = dojo.hitch(this.eventList[data.label]);
		}
		if (onClick) {
			menuObj.onClick = dojo.hitch(this.owner, onClick, menuObj, data);
		}
		if (idInPage) {
			this.owner[idInPage] = menuObj;
		}
		if (data.children) {
			var subMenu = new dijit.Menu({});
			dojo.addClass(subMenu.domNode, this.owner.name + "_" + this.name + "_PopupMenu");
			dojo.addClass(subMenu.domNode, this.owner.name + "_" + idInPage + "_PopupMenu");
			for (var i = 0; i < data.children.length; i++) {
				var subMenuData = data.children[i];
				this.addAdvancedMenuChildren(subMenu, subMenuData, false);
			}
			menuObj.popup = subMenu;
		}
		parentObj.addChild(menuObj);
	}, addNewMenuItem:function (parentObj, data) {
		var subMenu = parentObj.popup;
		this.addAdvancedMenuChildren(subMenu, data, false);
	}, dojoRenderer:function () {
	}, setFullStructure:function (inStruct) {
		this.fullStructure = inStruct;
		this.renderDojoObj();
	}, getStructure:function () {
		return this.structure == "" ? {items:[]} : dojo.fromJson(this.structure);
	}, setStructure:function (strStructure) {
		if (this.fullStructure) {
			return;
		}
		if (strStructure == "") {
			return;
		}
		var tempAllItems = [];
		var allMenuItems = [];
		var items = [];
		var sArray = strStructure.split("\n");
		for (var i = 0; i < sArray.length; i++) {
			if (dojo.trim(sArray[i]) == "") {
				continue;
			}
			var nArr = sArray[i].split(">");
			var obj = {label:dojo.trim(nArr[0])};
			var parent = this.findInItems(allMenuItems, obj.label);
			if (parent == null) {
				tempAllItems[tempAllItems.length] = obj;
			}
			this.addToEventList(obj);
			var children = [];
			if (nArr.length > 1) {
				var itemArray = nArr[1].split(",");
				for (var j = 0; j < itemArray.length; j++) {
					var itemObj = {label:dojo.trim(itemArray[j])};
					this.addToEventList(dojo.clone(itemObj));
					children[children.length] = itemObj;
					allMenuItems[allMenuItems.length] = itemObj;
					tempAllItems[tempAllItems.length] = dojo.clone(itemObj);
				}
				obj.children = children;
			}
			if (parent != null) {
				parent.children = children;
			} else {
				items[items.length] = obj;
			}
		}
		this.removeOldEvents(tempAllItems);
		this.structure = dojo.toJson({items:items});
	}, findInItems:function (allMenuItems, label) {
		for (var i = allMenuItems.length - 1; i >= 0; i--) {
			if (allMenuItems[i].label == label) {
				return allMenuItems[i];
			}
		}
		return null;
	}, addToEventList:function (obj) {
		for (var i = 0; i < this.eventList.length; i++) {
			if (this.eventList[i].label == obj.label) {
				return;
			}
		}
		this.eventList[this.eventList.length] = obj;
	}, removeOldEvents:function (newList) {
		var updatedEventList = [];
		for (var i = 0; i < this.eventList.length; i++) {
			var eventObj = this.eventList[i];
			var exists = false;
			for (var j = 0; j < newList.length; j++) {
				if (eventObj.label == newList[j].label) {
					updatedEventList[updatedEventList.length] = eventObj;
				}
			}
		}
		this.eventList = updatedEventList;
	}, overrideCSS:function (menuType, style) {
		dojox.html.insertCssRule(this.getCSSMenuTypeClass(menuType) + this.id + "_CSS", style);
	}, getCSSMenuTypeClass:function (menuType) {
		switch (menuType) {
		  case "MenuBar":
			return ".tundra .dijitMenuBar.";
		  case "MenuItem":
			return ".tundra .dijitMenuItem.";
		  case "MenuHover":
			return ".tundra .dijitMenuItemHover.";
		  case "MenuPassiveHover":
			return ".tundra .dijitMenuPassive .dijitMenuItemHover.";
		}
	}});
	wm.Object.extendSchema(wm.DojoMenu, {transparent:{group:"style", order:150, type:"Boolean"}, caption:{ignore:1}, structure:{hidden:true, order:10}, eventList:{hidden:true}, dataValue:{ignore:1}, dataSet:{ignore:1}, disabled:{ignore:1}, menuItems:{ignore:1}});
	wm.DojoMenu.description = "A dojo menu.";
	wm.DojoMenu.extend({themeableStyles:[{name:"wm.DojoMenu-Right_Margin", displayName:"Right Margin"}, {name:"wm.DojoMenu_Image", displayName:"Drop Icon"}], designCreate:function () {
		if (this._studioCreating) {
			this.studioCreate();
		}
		this.inherited(arguments);
	}, afterPaletteDrop:function () {
		this.caption = this.caption || this.name;
		this.renderDojoObj();
	}, makePropEdit:function (inName, inValue, inDefault) {
		switch (inName) {
		  case "menu":
			return makeTextPropEdit(inName, inValue, inDefault);
		  case "transparent":
			return makeCheckPropEdit(inName, inValue, inDefault);
		}
		return this.inherited(arguments);
	}, setMenu:function (inValue) {
		this.menu = inValue;
		this.setStructure(inValue);
		this.renderDojoObj();
	}, listProperties:function () {
		var props = this.inherited(arguments);
		for (evt in props) {
			if (props[evt].isMenuItem) {
				delete props[evt];
			}
		}
		dojo.forEach(this.eventList, function (obj) {
			props[this.getEventName(obj.label)] = {isEvent:true, isObject:false, noprop:false, type:"string", isMenuItem:true};
		}, this);
		return props;
	}, writeEvents:function (arg) {
		var e = this.inherited(arguments);
		return e;
	}, generateEventName:function (p) {
		var name = this.inherited(arguments);
		return this.getCleanText(name);
	}, updatingEvent:function (prop, inValue) {
		var evtObj = this.getEventObj(prop);
		if (evtObj != null) {
			evtObj.onClick = inValue;
		}
	}, getEventObj:function (prop) {
		prop = this.getCleanText(prop);
		for (var i = 0; i < this.eventList.length; i++) {
			if (prop == this.getEventName(this.eventList[i].label)) {
				return this.eventList[i];
			}
		}
		return null;
	}, setVertical:function (inValue) {
		this.vertical = inValue;
		if (this.vertical) {
			this.setHeight("100%");
			this.setWidth("95px");
		} else {
			this.setHeight("35px");
			this.setWidth("100%");
		}
		this.renderDojoObj();
	}, getProp:function (inProp) {
		var evtObj = this.getEventObj(inProp);
		if (evtObj != null) {
			return evtObj.onClick;
		} else {
			return this.inherited(arguments);
		}
	}, setProp:function (inProp, inValue) {
		var evtObj = this.getEventObj(inProp);
		if (evtObj != null) {
			this.updatingEvent(inProp, inValue);
		} else {
			this.inherited(arguments);
		}
	}, getCleanText:function (text) {
		return text.replace(/[^a-zA-Z0-9]+/g, "_");
	}, getEventName:function (label) {
		return "on" + this.getCleanText(label) + "Click";
	}, getSharedEventLookupName:function (inProp) {
		if (inProp.match(/^on.*Click$/)) {
			return "onClick";
		} else {
			return inProp;
		}
	}, renameComponentEvents:function (originalId, newId) {
		this.renameComponentEventsMenu(this.eventList, originalId, newId);
	}, renameComponentEventsMenu:function (children, originalId, newId) {
		for (var i = 0; i < children.length; i++) {
			var item = children[i];
			if (item.onClick && item.onClick == originalId) {
				item.onClick = newId;
			}
			if (item.children) {
				this.renameComponentEventsMenu(item.children, originalId, newId);
			}
		}
	}});
}
if (!dojo._hasResource["wm.base.widget.DojoChart"]) {
	dojo._hasResource["wm.base.widget.DojoChart"] = true;
	dojo.provide("wm.base.widget.DojoChart");
	var chartThemes = ["GreySkies", "Adobebricks", "Algae", "Bahamation", "BlueDusk", "CubanShirts", "Desert", "Dollar", "Grasshopper", "Grasslands", "IndigoNation", "Ireland", "MiamiNice", "Midwest", "Minty", "PurpleRain", "RoyalPurples", "SageToLime", "Shrooms", "Tufte", "WatersEdge", "Wetland", "PlotKit.blue", "PlotKit.cyan", "PlotKit.green", "PlotKit.orange", "PlotKit.purple", "PlotKit.red"];
	var chartTypes = ["Columns", "ClusteredColumns", "StackedColumns", "Bars", "ClusteredBars", "StackedBars", "Areas", "StackedAreas", "Pie", "Lines"];
	dojo.declare("wm.DojoChart", wm.Control, {padding:4, width:"200px", height:"200px", legendHeight:"50px", variable:null, dataSet:null, dojoObj:null, theme:"CubanShirts", xAxis:"wmDefaultX", isTimeXAxis:false, maxTimePoints:15, xMajorTickStep:5, xMinorTicks:false, xMinorTickStep:1, yAxis:"wmDefaultY", yUpperRange:"", chartColor:"", includeX:true, includeY:true, enableAnimation:true, chartType:"Columns", includeGrid:false, gap:2, defaultXY:[{"wmDefaultX":"Jan", "wmDefaultY":3}, {"wmDefaultX":"Feb", "wmDefaultY":5}, {"wmDefaultX":"Mar", "wmDefaultY":8}, {"wmDefaultX":"Apr", "wmDefaultY":2}], addedSeries:{}, aniHighlight:null, aniShake:null, magnify:null, aniTooltip:null, addSilverlight:false, init:function () {
		if (this.showAddSilverlight()) {
			return;
		}
		dojo["require"]("dojox.charting.Chart2D");
		dojo["require"]("dojox.charting.widget.Legend");
		dojo["require"]("dojox.charting.action2d.Highlight");
		dojo["require"]("dojox.charting.action2d.Magnify");
		dojo["require"]("dojox.charting.action2d.MoveSlice");
		dojo["require"]("dojox.charting.action2d.Shake");
		dojo["require"]("dojox.charting.action2d.Tooltip");
		dojo["require"]("dojo.fx.easing");
		this.inherited(arguments);
	}, postInit:function () {
		this.inherited(arguments);
	}, renderDojoObj:function () {
		if (this._loading || this.addSilverlight) {
			return;
		}
		if (this.dojoObj != null) {
			this.dojoObj.destroy();
			while (this.domNode.childNodes.length > 0) {
				this.domNode.removeChild(this.domNode.childNodes[0]);
			}
		}
		this.dojoDiv = dojo.doc.createElement("div");
		this.updateChartDivHeight();
		this.domNode.appendChild(this.dojoDiv);
		this.dojoObj = new dojox.charting.Chart2D(this.dojoDiv);
		this.setChartTheme();
		this.updateChartType();
		this.addXAxis();
		this.addYAxis();
		if (this.includeGrid) {
			this.dojoObj.addPlot("grid", {type:"Grid", hMinorLines:true, vMinorLines:true});
		}
		this.addAnimation();
		this.addChartSeries();
		var self = this;
		dojo.addOnLoad(function () {
			self.dojoRenderer();
			self.connectDojoEvents();
		});
	}, renderBounds:function () {
		this.inherited(arguments);
		this.resizeDijit();
	}, resizeDijit:function () {
		this.renderDojoObj();
	}, createLegend:function () {
		if (this.legend && this.legend != null) {
			this.legend.destroy();
		}
		this.legendDiv = dojo.doc.createElement("div");
		dojo.attr(this.legendDiv, "align", "center");
		this.domNode.appendChild(this.legendDiv);
		try {
			this.legend = new dojox.charting.widget.Legend({chart:this.dojoObj}, this.legendDiv);
		}
		catch (e) {
		}
	}, updateChartDivHeight:function () {
		if (!this.dojoDiv) {
			return;
		}
		var h = dojo.coords(this.domNode).h;
		var lh = wm.splitUnits(this.legendHeight);
		var l = lh.value;
		var reducedHeight = h - l;
		if (reducedHeight > 0) {
			this.dojoDiv.style.width = this.width;
			this.dojoDiv.style.height = reducedHeight + "px";
		}
	}, dojoRenderer:function () {
		if (!this.dojoObj) {
			return;
		}
		try {
			this.dojoObj.render();
		}
		catch (e) {
		}
		this.createLegend();
	}, connectDojoEvents:function () {
		this.dojoObj.connectToPlot("default", dojo.hitch(this, "dojoChartEvent"));
	}, getDataSet:function () {
		return this.variable;
	}, setDataSet:function (inValue, inDefault) {
		this.variable = inValue;
		if (!this.variable || !this.variable.getData()) {
			return;
		}
		var thisObj = this;
		if (this.isTimeXAxis && this.dojoObj) {
			this.incrementSeries();
		} else {
			dojo.addOnLoad(function () {
				thisObj.renderDojoObj();
			});
		}
	}, addChartSeries:function (isUpdate) {
		this.updateXLabelSet();
		dojo.forEach(this.yAxis.split(","), function (columnName, idx) {
			try {
				columnName = dojo.trim(columnName);
				if (!columnName) {
					return;
				}
				var columnData = this.getColumnDataSet(columnName);
				var seriesName = wm.capitalize(columnName);
				if (isUpdate && this.addedSeries[seriesName] && this.addedSeries[seriesName].length > 0) {
					columnData = this.addedSeries[seriesName].concat(columnData);
					while (columnData.length > this.maxTimePoints) {
						columnData.shift();
					}
				}
				if (this.chartColor instanceof Array) {
					var color = this.chartColor[idx];
				}
				if (color && color != "" && this.chartType != "Pie") {
					this.dojoObj.addSeries(seriesName, columnData, {stroke:{width:0}, fill:color});
				} else {
					if (!isUpdate) {
						this.dojoObj.addSeries(seriesName, columnData);
					} else {
						this.dojoObj.updateSeries(seriesName, columnData);
					}
				}
				this.addedSeries[seriesName] = columnData;
			}
			catch (e) {
				console.info("Error while making chartdata", e);
			}
		}, this);
	}, getChartDataSet:function () {
		if ((this.xAxis == "wmDefaultX" || this.yAxis == "wmDefaultY") && this.isDesignLoaded()) {
			return this.defaultXY;
		}
		if (!this.variable || this.variable == "") {
			return [];
		}
		var ds = this.variable.getData();
		if (ds && !(ds instanceof Array)) {
			ds = [ds];
		}
		return ds;
	}, updateXLabelSet:function () {
		if (this.isTimeXAxis) {
			return [];
		}
		this.xLabels = {};
		var ds = this.getChartDataSet();
		var x = (this.xAxis == "wmDefaultX" || this.yAxis == "wmDefaultY") ? "wmDefaultX" : this.xAxis;
		dojo.forEach(ds, function (obj, idx) {
			var label = obj[x];
			this.xLabels[label] = this.addXLabel(label);
		}, this);
		return this.xLabels;
	}, isPieChart:function () {
		return this.chartType == "Pie";
	}, getColumnDataSet:function (columnName) {
		var data = [], x = "";
		var ds = this.getChartDataSet();
		var xField = (this.xAxis == "wmDefaultX" || this.yAxis == "wmDefaultY") ? "wmDefaultX" : this.xAxis;
		dojo.forEach(ds, function (dataObj, i) {
			var obj = {y:dataObj[columnName]};
			if (this.isPieChart()) {
				if (xField != "") {
					obj.legend = dataObj[xField];
				}
				if (this.chartColor != "") {
					if (this.chartColor instanceof Array) {
						var color = this.chartColor[i];
						if (color) {
							obj.color = color;
						}
					} else {
						obj.color = dataObj[this.chartColor];
					}
				}
			} else {
				if (this.isTimeXAxis) {
					x = this.getTimeX();
				} else {
					if (xField) {
						x = this.xLabels[dataObj[xField]];
					}
				}
				if (x != "") {
					obj.x = x;
				}
			}
			data.push(obj);
		}, this);
		return data;
	}, getPieDataSet:function (columnName) {
		if ((columnName == "wmDefaultX" || columnName == "wmDefaultY") && this.isDesignLoaded()) {
			if (columnName == "wmDefaultX") {
				return this.defaultXY;
			} else {
				return this.defaultXY;
			}
		}
		if (this.variable == null || this.variable == "") {
			return [];
		}
		var data = [];
		for (var i = 0; i < this.variable.getCount(); i++) {
			var dataObj = this.variable.getItem(i).data;
			if (dataObj && dataObj != null) {
				var obj = {y:dataObj[columnName]};
				if (this.xAxis != "") {
					obj.legend = dataObj[this.xAxis];
				}
				if (this.chartColor != "") {
					if (this.chartColor instanceof Array) {
						var color = this.chartColor[i];
						if (color) {
							obj.color = color;
						}
					} else {
						obj.color = dataObj[this.chartColor];
					}
				}
				data[data.length] = obj;
			}
		}
		return data;
	}, addXAxis:function () {
		if (!this.includeX) {
			this.dojoObj.removeAxis("x");
			return;
		}
		var x = this.dojoObj ? this.dojoObj.getAxis("x") : {}, xParams = {};
		if (x && x.opt) {
			xParams = x.opt;
		}
		xParams.minorTicks = this.xMinorTicks;
		var fontProp = this.getFontProperty();
		if (fontProp) {
			dojo.mixin(xParams, fontProp);
		}
		if (this.xMajorTickStep) {
			xParams.majorTickStep = this.xMajorTickStep;
		}
		if (this.xMinorTickStep) {
			xParams.minorTickStep = this.xMinorTickStep;
		}
		this.dojoObj.addAxis("x", xParams);
	}, addYAxis:function () {
		if (this.includeY) {
			var yProp = {vertical:true, natural:true, includeZero:true, fixUpper:"minor"};
			var fontProp = this.getFontProperty();
			if (fontProp) {
				dojo.mixin(yProp, fontProp);
			}
			if (this.yLowerRange) {
				yProp.min = this.yLowerRange;
			}
			if (this.yUpperRange && this.yUpperRange != "") {
				yProp.max = this.yUpperRange;
			}
			if (this.yMajorTickStep) {
				yProp.majorTickStep = this.yMajorTickStep;
			}
			this.dojoObj.addAxis("y", yProp);
		}
	}, getFontProperty:function () {
		var defaultFontProp = {style:"normal", variant:"normal", weight:"normal", size:"7pt", family:"Tahoma"};
		var results = {};
		var fontProp = {};
		var fontPropExists = false;
		if (this._classes && this._classes.domNode) {
			for (var i = 0; i < this._classes.domNode.length; i++) {
				var classProp = this._classes.domNode[i];
				var propObj = this.getDojoGFXCssPropObj(classProp);
				if (propObj) {
					fontProp[propObj.propName] = propObj.propValue;
					fontPropExists = true;
				}
			}
			if (fontPropExists) {
				var fontPropStr = "";
				for (p in defaultFontProp) {
					if (fontProp[p] && fontProp[p] != "") {
						fontPropStr += " " + fontProp[p];
					} else {
						fontPropStr += " " + defaultFontProp[p];
					}
				}
				results.font = dojo.trim(fontPropStr);
				if (fontProp.fontColor) {
					results.fontColor = fontProp.fontColor;
				}
				return results;
			}
		}
		return null;
	}, addSeries:function () {
		return;
		thisObj = this;
		dojo.forEach(this.yAxis.split(","), function (columnName, idx) {
			var columnData = null;
			if (thisObj.chartType == "Pie") {
				columnData = thisObj.getPieDataSet(columnName);
			} else {
				columnData = thisObj.getColumnDataSet(columnName);
			}
			columnName = dojo.trim(columnName);
			var seriesName = wm.capitalize(columnName);
			var counter = 1;
			while (dojo.indexOf(thisObj.addedSeries, seriesName) != -1) {
				seriesName += " " + counter;
				counter++;
			}
			if (thisObj.chartType != "Pie" && thisObj.chartColor instanceof Array) {
				var color = thisObj.chartColor[idx];
				if (color && color != "") {
					thisObj.dojoObj.addSeries(seriesName, columnData, {stroke:{width:0}, fill:color});
				} else {
					thisObj.dojoObj.addSeries(seriesName, columnData);
				}
			} else {
				thisObj.dojoObj.addSeries(seriesName, columnData);
			}
			thisObj.addedSeries[thisObj.addedSeries.length] = seriesName;
		});
	}, incrementSeries:function () {
		this.addChartSeries(true);
		this.dojoObj.render();
		this.renderBounds();
	}, updateSeries:function (seriesName, inData) {
		try {
			this.dojoObj.updateSeries(seriesName, inData);
			this.dojoObj.render();
		}
		catch (e) {
			console.info("error while updating series for ", this.declaredClass);
		}
	}, setChartTheme:function () {
		var js = "dojox.charting.themes." + this.theme;
		dojo["require"](js);
		var self = this;
		dojo.addOnLoad(function () {
			self.updateChartTheme();
		});
	}, updateChartTheme:function () {
		var themeObj = dojo.getObject("dojox.charting.themes." + this.theme);
		this.dojoObj.setTheme(themeObj);
	}, updateChartType:function () {
		this.updateChartXY();
		var prop = {type:this.chartType, gap:this.gap};
		if (this.chartType == "Lines") {
			prop.markers = true;
		}
		this.dojoObj.addPlot("default", prop);
	}, getDojoGFXCssPropObj:function (prop) {
		var propArray = prop.split("_");
		if (propArray.length == 3) {
			switch (propArray[1]) {
			  case "FontFamily":
				return {propName:"family", propValue:propArray[2]};
			  case "FontSizePx":
				return {propName:"size", propValue:propArray[2]};
			  case "FontColor":
				return {propName:"fontColor", propValue:propArray[2]};
			  case "TextDecoration":
				return {propName:"weight", propValue:propArray[2]};
			}
		}
		return null;
	}, updateChartXY:function () {
		if (this.chartType == "Pie") {
			this.dojoObj.removeAxis("x");
		} else {
			this.addXAxis();
		}
		this.addSeries();
	}, addAnimation:function () {
		if (this.aniHighlight != null) {
			this.aniHighlight.destroy();
			this.aniShake.destroy();
			this.aniTooltip.destroy();
			if (this.magnify) {
				this.magnify.destroy();
			}
		}
		if (this.enableAnimation) {
			var dc = dojox.charting;
			var dur = 450;
			this.aniHighlight = new dc.action2d.Highlight(this.dojoObj, "default", {duration:dur, easing:dojo.fx.easing.sineOut});
			this.aniShake = new dc.action2d.Shake(this.dojoObj, "default");
			this.aniTooltip = new dc.action2d.Tooltip(this.dojoObj, "default");
			if (this.chartType == "Lines") {
				this.magnify = new dc.action2d.Magnify(this.dojoObj, "default");
			}
		}
	}, getTimeX:function () {
		var today = new Date();
		var h = today.getHours(), m = today.getMinutes(), s = today.getSeconds(), text = h + ":" + m + ":" + s;
		var xAxis = this.dojoObj.getAxis("x"), labels = xAxis.opt.labels || [];
		if (labels.length < 1) {
			var value = 1;
		} else {
			var value = labels[labels.length - 1].value + 1;
			while (labels.length > this.maxTimePoints) {
				labels.shift();
			}
		}
		labels.push({value:value, text:text});
		xAxis.labels = labels;
		this.dojoObj.addAxis("x", xAxis);
		return value;
	}, addXLabel:function (label) {
		var xAxis = this.dojoObj.getAxis("x"), labels = xAxis.opt.labels || [], value = 0;
		if (labels.length < 1) {
			value = 1;
		} else {
			value = labels[labels.length - 1].value + 1;
		}
		labels.push({value:value, text:label + ""});
		xAxis.labels = labels;
		this.dojoObj.addAxis("x", xAxis);
		return value;
	}, dojoChartEvent:function (e) {
		var type = e.type;
		var idx = e.index;
		if (!this.variable || !type || !idx || type == null || idx == null || this.variable == null) {
			return;
		}
		var dataObj = null;
		var item = this.variable.getItem(idx);
		if (item != null) {
			dataObj = item.data;
		}
		if (type == "onclick") {
			dojo.hitch(this, "onClick")(e, dataObj);
		} else {
			if (type == "onmouseover") {
				dojo.hitch(this, "onMouseOver")(e, dataObj);
			} else {
				if (type == "onmouseout") {
					dojo.hitch(this, "onMouseOut")(e, dataObj);
				}
			}
		}
	}, onClick:function (e, dataObj) {
	}, onMouseOver:function (e, dataObj) {
	}, onMouseOut:function (e, dataObj) {
	}});
	wm.Object.extendSchema(wm.DojoChart, {variable:{ignore:1}, dojoDiv:{ignore:1}, caption:{ignore:1}, disabled:{ignore:1}, dataValue:{ignore:1}, defaultValuesX:{ignore:1}, defaultValuesY:{ignore:1}, addedSeries:{ignore:1}, aniHighlight:{ignore:1}, aniShake:{ignore:1}, magnify:{ignore:1}, aniTooltip:{ignore:1}, xLabels:{ignore:1}, legendDiv:{ignore:1}, legend:{ignore:1}, dataSet:{bindable:1, group:"edit", order:10, isList:true}, xAxis:{group:"edit", order:20}, isTimeXAxis:{group:"edit", order:21}, maxTimePoints:{group:"edit", order:22}, yAxis:{group:"edit", order:30}, chartColor:{group:"edit", order:40}, chartType:{order:10}, theme:{order:20}, addSilverlight:{ignore:1}});
	wm.DojoChart.description = "A dojo chart.";
	wm.DojoChart.extend({themeable:false, designCreate:function () {
		if (this._studioCreating) {
			this.studioCreate();
		}
		this.inherited(arguments);
	}, afterPaletteDrop:function () {
		this.caption = this.caption || this.name;
		this.renderDojoObj();
	}, makePropEdit:function (inName, inValue, inDefault) {
		switch (inName) {
		  case "theme":
			return makeSelectPropEdit(inName, inValue, chartThemes, inDefault);
		  case "chartType":
			return makeSelectPropEdit(inName, inValue, chartTypes, inDefault);
		}
		return this.inherited(arguments);
	}, setXAxis:function (inValue) {
		this.xAxis = inValue;
		this.renderDojoObj();
	}, setYAxis:function (inValue) {
		this.yAxis = inValue;
		this.renderDojoObj();
	}, setYUpperRange:function (inValue) {
		this.yUpperRange = inValue;
		this.renderDojoObj();
	}, setChartColor:function (inValue) {
		if (inValue.indexOf(",") != -1 || this.chartType != "Pie") {
			this.chartColor = inValue.split(",");
		} else {
			this.chartColor = inValue;
		}
		this.renderDojoObj();
	}, setTheme:function (inValue) {
		this.theme = inValue;
		this.setChartTheme();
		var self = this;
		dojo.addOnLoad(function () {
			self.dojoRenderer();
		});
	}, setChartType:function (inValue) {
		this.chartType = inValue;
		this.updateChartType();
		this.dojoRenderer();
	}, setLegendHeight:function (inValue) {
		this.legendHeight = inValue;
		this.updateChartSize();
	}, addUserClass:function (arg1, arg2) {
		this.inherited(arguments);
		this.updateStyle();
	}, removeUserClass:function (arg1, arg2) {
		this.inherited(arguments);
		this.updateStyle();
	}, updateStyle:function () {
		this.setIncludeX(this.includeX);
		this.setIncludeY(this.includeY);
	}, setIncludeX:function (inValue) {
		this.includeX = inValue;
		if (this.includeX) {
			this.addXAxis();
		} else {
			this.dojoObj.removeAxis("x");
		}
		this.dojoRenderer();
	}, setIncludeY:function (inValue) {
		this.includeY = inValue;
		if (this.includeY) {
			var yProp = {vertical:true, natural:true, includeZero:true, fixUpper:"minor"};
			var fontProp = this.getFontProperty();
			if (fontProp) {
				dojo.mixin(yProp, fontProp);
			}
			this.dojoObj.addAxis("y", yProp);
		} else {
			this.dojoObj.removeAxis("y");
		}
		this.dojoRenderer();
	}, setIncludeGrid:function (inValue) {
		this.includeGrid = inValue;
		if (this.includeGrid) {
			this.dojoObj.addPlot("grid", {type:"Grid", hMinorLines:true, vMinorLines:true});
		} else {
			this.dojoObj.removePlot("grid");
		}
		this.dojoRenderer();
	}, setGap:function (inValue) {
		this.gap = inValue;
		this.updateChartType();
		this.dojoRenderer();
	}, setEnableAnimation:function (inValue) {
		this.enableAnimation = inValue;
		this.addAnimation();
		this.dojoRenderer();
	}, showAddSilverlight:function () {
		if (!dojo.isIE || !Silverlight || Silverlight.isInstalled()) {
			return;
		}
		this.addSilverlight = true;
		var link = dojo.doc.createElement("a");
		dojo.attr(link, "href", "http://go.microsoft.com/fwlink/?LinkId=149156");
		dojo.attr(link, "style", "text-decoration: none;");
		var img = dojo.doc.createElement("img");
		dojo.attr(img, "src", "http://go.microsoft.com/fwlink/?LinkId=108181");
		dojo.attr(img, "alt", "Get Microsoft Silverlight");
		dojo.attr(img, "style", "border-style: none");
		link.appendChild(img);
		this.domNode.appendChild(link);
	}, designResize:function (inBounds) {
		this.inherited(arguments);
		this.updateChartSize();
	}, setSizeProp:function (n, v) {
		this.inherited(arguments);
		this.updateChartSize();
	}, updateChartSize:function () {
		if (this.dojoObj != null) {
			this.updateChartDivHeight();
			this.dojoObj.resize();
			this.dojoObj.render();
		}
	}});
}
if (!dojo._hasResource["wm.base.widget.DojoFisheye"]) {
	dojo._hasResource["wm.base.widget.DojoFisheye"] = true;
	dojo.provide("wm.base.widget.DojoFisheye");
	dojo.declare("wm.DojoFisheye", wm.Control, {padding:0, width:"100%", height:"40px", dataSet:null, imageUrlField:"", imageLabelField:"", itemWidth:40, itemHeight:40, itemMaxWidth:150, itemMaxHeight:150, connectEvents:[], variableConnectEvents:[], init:function () {
		dojo["require"]("dojox.widget.FisheyeList");
		this.inherited(arguments);
		this.selectedItem = new wm.Variable({name:"selectedItem", owner:this});
		this.connectEvents = [];
	}, destroy:function () {
		this.inherited(arguments);
		this.destroyDojoObj();
		delete this.dojoObj;
		delete this.variable;
		this.connectEvents = null;
		delete this.connectEvents;
		if (this.variableConnectEvents) {
			dojo.forEach(this.variableConnectEvents, dojo.disconnect);
		}
		delete this.variableConnectEvents;
		if (this.selectedItem) {
			this.selectedItem.destroy();
		}
		delete this.selectedItem;
	}, destroyDojoObj:function () {
		if (this.dojoObj) {
			this.dojoObj.destroy();
		}
		if (this.connectEvents.length > 0) {
			dojo.forEach(this.connectEvents, dojo.disconnect);
		}
	}, renderDojoObj:function () {
		if (this._loading || !this.variable || !this.imageUrlField || this.imageUrlField == "") {
			this.destroyDojoObj();
			return;
		}
		this.destroyDojoObj();
		var prop = {itemWidth:this.itemWidth, itemHeight:this.itemHeight, itemMaxWidth:this.itemMaxWidth, itemMaxHeight:this.itemMaxHeight, effectUnits:2, itemPadding:10, attachEdge:"center", labelEdge:"bottom", orientation:"horizontal"};
		this.updateDOMStyle();
		this.dojoObj = new dojox.widget.FisheyeList(prop, dojo.create("div", null, this.domNode));
		var imgUrlArray = [];
		for (var i = 0; i < this.variable.getCount(); i++) {
			var dataObj = this.variable.getItem(i).data;
			if (!dataObj || !dataObj[this.imageUrlField] || dataObj[this.imageUrlField] == "") {
				continue;
			}
			var imgObj = {};
			if (dataObj && dataObj != null) {
				imgObj.url = dataObj[this.imageUrlField];
				imgObj.label = this.imageLabelField && this.imageLabelField != "" ? dataObj[this.imageLabelField] : "";
				imgObj.data = dataObj;
			}
			imgUrlArray[imgUrlArray.length] = imgObj;
		}
		for (var i = 0; i < imgUrlArray.length; i++) {
			this.addImageToFish(imgUrlArray[i]);
		}
	}, updateDOMStyle:function () {
		this.domNode.style.overflow = "visible";
		if (dojo.isIE) {
			this.domNode.style.overflowX = "visible";
			this.domNode.style.overflowY = "visible";
		}
		if (this.parent && this.parent instanceof wm.Panel) {
			this.parent.domNode.style.overflow = "visible";
			if (dojo.isIE) {
				this.parent.domNode.style.overflowX = "visible";
				this.parent.domNode.style.overflowY = "visible";
			}
		}
	}, addImageToFish:function (imgObj) {
		if (!this.dojoObj) {
			return;
		}
		var item = new dojox.widget.FisheyeListItem();
		item.label = imgObj.label;
		item.iconSrc = imgObj.url;
		try {
			this.connectEvents.push(dojo.connect(item, "onClick", dojo.hitch(this, "_onClick", imgObj.data)));
		}
		catch (e) {
			console.info("exception while connecting to on click ", e);
		}
		item.postCreate();
		this.dojoObj.addChild(item);
		this.dojoObj.startup();
		item.startup();
	}, getDataSet:function () {
		return this.variable;
	}, setDataSet:function (inValue, inDefault) {
		if (this.variableConnectEvents) {
			dojo.forEach(this.variableConnectEvents, dojo.disconnect);
		}
		this.variableConnectEvents = [];
		this.variable = inValue;
		if (this.variable && this.variable != "") {
			this.variableConnectEvents.push(dojo.connect(this.variable, "onSetData", this, "sourceDataChanged"));
		}
		var t = (inValue || 0).type || "AnyData";
		this.setSelectedItemType(t);
		this.dataSetToSelectedItem(inValue);
		this.onsetdata(this.variable);
		this.renderDojoObj();
	}, sourceDataChanged:function () {
		this.renderDojoObj();
	}, setSelectedItemType:function (inType) {
		this.selectedItem.setType(inType);
	}, dataSetToSelectedItem:function () {
		this.selectedItem.setLiveView((this.variable || 0).liveView);
		this.selectedItem.setType(this.variable ? this.variable.type : "any");
	}, updateSelected:function (dataObj) {
		this.selectedItem.setDataSchema(dataObj);
		this.selectedItem.setData(dataObj);
		this.setValue("emptySelection", Boolean(!dataObj));
	}, _onClick:function (dataObj, event) {
		this.updateSelected(dataObj);
		this.onClick(dataObj, event);
	}, onClick:function (dataObj, event) {
	}, onsetdata:function (inData) {
	}});
	wm.Object.extendSchema(wm.DojoFisheye, {variable:{ignore:1}, connectEvents:{ignore:1}, variableConnectEvents:{ignore:1}, dataSet:{bindable:1, group:"edit", order:10, isList:true}, imageUrlField:{group:"edit", order:20}, imageLabelField:{group:"edit", order:30}, itemWidth:{group:"edit", order:40}, itemHeight:{group:"edit", order:50}, itemMaxWidth:{group:"edit", order:60}, itemMaxHeight:{group:"edit", order:70}, selectedItem:{ignore:true, isObject:true, bindSource:true, simpleBindProp:true}});
	wm.DojoFisheye.description = "A dojo Fisheye.";
	wm.DojoFisheye.extend({themeable:false, setImageUrlField:function (inValue) {
		this.imageUrlField = inValue;
		this.renderDojoObj();
	}, setImageLabelField:function (inValue) {
		this.imageLabelField = inValue;
		this.renderDojoObj();
	}, setItemMaxWidth:function (inValue) {
		this.itemMaxWidth = inValue;
		this.renderDojoObj();
	}, setItemMaxHeight:function (inValue) {
		this.itemMaxHeight = inValue;
		this.renderDojoObj();
	}, setItemHeight:function (inValue) {
		this.itemHeight = inValue;
		this.renderDojoObj();
	}, setItemWidth:function (inValue) {
		this.itemWidth = inValue;
		this.renderDojoObj();
	}});
}
dojo.i18n._preloadLocalizations("dojo.nls.studio_wm", ["ROOT", "ar", "ca", "cs", "da", "de", "de-de", "el", "en", "en-gb", "en-us", "es", "es-es", "fi", "fi-fi", "fr", "fr-fr", "he", "he-il", "hu", "it", "it-it", "ja", "ja-jp", "ko", "ko-kr", "nb", "nl", "nl-nl", "pl", "pt", "pt-br", "pt-pt", "ru", "sk", "sl", "sv", "th", "tr", "xx", "zh", "zh-cn", "zh-tw"]);

