/*
	Copyright (c) 2004-2009, The Dojo Foundation All Rights Reserved.
	Available via Academic Free License >= 2.1 OR the modified BSD license.
	see: http://dojotoolkit.org/license for details
*/

/*
	This is a compiled version of Dojo, built for deployment and not for
	development. To get an editable version, please visit:

		http://dojotoolkit.org

	for documentation and information on getting the source.
*/

dojo.provide("wm");
if(!dojo._hasResource['wm.base.lib.util']){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource['wm.base.lib.util'] = true;
/*
 *  Copyright (C) 2008-2010 WaveMaker Software, Inc.
 *
 *  This file is part of the WaveMaker Client Runtime.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
dojo.provide('wm.base.lib.util');

/**
	@namespace Master namespace for all WaveMaker library objects.
*/
wm = window["wm"] || {};

// simple logging
wm.logErrors = false;
wm.log = function() {
	console.log.apply(console, arguments);
}

// strings

wm.capitalize = function(s) {
	return s ? s.charAt(0).toUpperCase() + s.slice(1) : "";
}

wm.decapitalize = function(s) {
	return s ? s.charAt(0).toLowerCase() + s.slice(1) : "";
}

wm.isEqual = function (a1, a2){ 
	try{
		if(a1 == a2)
			return true; 
		if(dojo.isArray(a1) && dojo.isArray(a2)) 
			return dojo.toJson([].concat(a1).sort()) == dojo.toJson([].concat(a2).sort())   
		return dojo.toJson(a1) == dojo.toJson(a2) 
	} catch(e) {
		console.info('Could not compare objects ', arguments, ' therefore returning false. Error ', e);
		return false;
	}
} 

wm.compareStrings = function(a, b) {
	return a < b ? -1 : a == b ? 0 : 1;
}

wm.toTitleCase = function(s){
	return s.replace(/\b\w+\b/g, function(word) {
		return word ? word.charAt(0).toUpperCase() + (word.slice(1) || "").toLowerCase() : "";
	}); 
}

wm.delimCat = function(inPrefix, inSuffix, inDelim) {
	return inPrefix + (inPrefix && inSuffix ? inDelim : "") + inSuffix;
}

wm.joinEx = function(inValues, inDelim) {
	var i = 0;
	while (i < inValues.length) {
		if (inValues[i++] !== "")
			inValues.splice(--i, 1);
	}
	return inValues.join(inDelim);
}

// number

wm.isNumber = function(v) {
	return (typeof v == 'number') || (v instanceof Number);
}

wm.compareNumbers = function(a, b) {
	var na = wm.isNumber(a), nb = wm.isNumber(b);
	return na && nb ? a - b : (na ? -1 : (nb ? 1 : 0));
}

wm.max = function(list) {
  var max = list[0];
  for (var i = 1; i < list.length; i++) if (list[i] > max) max = list[i];
  return max;
}
wm.sum = function(list) {
  var sum = 0;
  for (var i = 0; i < list.length; i++) sum += list[i];
  return sum;
}

wm.average = function(list) {
  return wm.sum(list)/list.length;
}

// lang

wm.nop = function() {};

wm.isEmpty = function(inObj) {
	for (var i in inObj)
		return false;
	return true;
}

wm.fire = function(obj, method, args) {
	var f = obj && method && obj[method];
	if (f) 
		return args ? f.apply(obj, args) : f.call(obj);
}

wm.async = function(f, delay) {
	return function(){setTimeout(f, delay || 1);};
}

wm.forEach = function(inObject, inFunc) {
	if (dojo.isArray(inObject))
		dojo.forEach(inObject, inFunc);
	else
		wm.forEachProperty(inObject, inFunc);
}

wm.forEachProperty = function(inObject, inFunc) {
	for (var i in inObject) {
			inFunc(inObject[i], i);
	}
}

wm.isDomShowing = function(inNode) {
    var n = inNode;
    while(n && n != window.document.body && n.style.display != "none") {
	n = n.parentNode;
    }
    return !n || n.style.display != "none";
}

wm.evalJs = function(inJavascript, inDefault) {
	var r = inDefault || "";
	try {
		r = eval(inJavascript);
	} catch(e) {
		wm.logging && console.log("Error evaluating Javascript:", e);
	}
	return r;
};

wm.getClassProp = function(inClassName, inProp) {
	var klass = dojo.getObject(inClassName);
	var ptype = klass && klass.prototype;
	return ptype && ptype[inProp];
}

// DOM

wm.showHideNode = function(inNode, inTrueToShow) {
	inNode.style.display = inTrueToShow ? "" : "none";
};

wm.kids = function(inNode, inTag) {
	var result = [], t=inTag.toUpperCase();
	for (var i=0, n; (n=inNode.childNodes[i]); i++) 
		if (n.tagName == inTag) 
			result.push(n);
	return result;
}

wm.divkids = function(inNode) {
	return wm.kids(inNode, 'div');
}

wm.clearSelection = function() {
	try{
		if (window.getSelection) 
			window.getSelection().collapseToEnd();
		else if (document.selection) 
			document.selection.clear();
	}catch(e){
	}
}

wm.focusOnIdle = function(inNode) {
	setTimeout(function() {
		try {
			wm.fire(inNode, "focus");
			wm.fire(inNode, "select");
		} catch(e) {};
	}, 1);
}

wm.inScrollbar = function(e) {
	var t = e.target;
	var s = t.style && dojo.getComputedStyle(t);
	return  s && (
		((s.overflow != 'hidden' || s.overflowX != 'hidden') && (t.scrollWidth != t.offsetWidth) && (t.offsetWidth - 19 - e.clientX < 0)) ||
		((s.overflow != 'hidden' || s.overflowY != 'hidden') && (t.scrollHeight != t.offsetHeight) && (t.offsetHeight - 19 - e.clientY < 0))
	);
};

wm.preloadImage = function(inPath) {
	var i = new Image();
	i.src = inPath;
	(wm.preloaded = (wm.preloaded || [])).push(i);
}

// style

wm.setUnitsBox = function(node, l, t, w, h) {
	with (node.style) {
		l&&(left = l);
		t&&(top = t);
		w&&(width = w);
		h&&(height = h);
	}
}

wm.getNaturalBox = function(node){
	var tn = node.tagName, cs = dojo.getComputedStyle(node), box = dojo._getContentBox(node, cs);
	if(tn=="BUTTON" || tn=="TABLE"){
		var pb = dojo._getPadBorderExtents(node, cs);
		box.w += pb.w;
		box.h += pb.h;
	}
	return box;
}

wm.calcOffset = function(inNode, inAncestor, inAdjustMargin) {
	var o = { x:0, y: 0}, n = inNode, cs, mb, be;
	while (n && n != inAncestor && n != document) {
		cs = dojo.getComputedStyle(n);
		mb = dojo._getMarginBox(n, cs);
		be = dojo._getBorderExtents(n, cs);
		me = inAdjustMargin ? dojo._getMarginExtents(n, cs) : {l:0, t:0};
		o.x += mb.l + be.l + me.l - (n.scrollLeft || 0);
		o.y += mb.t + be.t + me.t - (n.scrollTop || 0);
		n = n.parentNode;
	}
	return o;
}

wm.addRemoveClass = function(node, classn, addRemove) {
	dojo[addRemove ? "addClass" : "removeClass"](node, classn);
}

// misc

wm.onidle = function(/*hitch args*/) {
	return setTimeout(dojo.hitch.apply(dojo, arguments), 1);
}

wm.job = function(inName, inDelay, inJob) {
	wm.cancelJob(inName);
	var job = function() {
		delete wm._jobs[inName];
		inJob();
	}
	wm._jobs[inName] = setTimeout(job, inDelay);
}
wm.cancelJob = function(inName) {
	clearTimeout(wm._jobs[inName]);
}
wm._jobs = [ ];

wm.connectEvents = function(inObject, inNode, inEvents) {
	// FIXME: maybe remove this at some point
	if (!dojo.isArray(inEvents)){throw("wm.connectEvents: event list must be an array (did you use variable args?)")};
	var links = [];
	for (var i=0, e; (e=inEvents[i]); i++) {
		links.push(dojo.connect(inNode, 'on' + e, inObject, e));
	}
	return links;
}

wm._isUniqueName = function(inName, inNameSpaces) {
	for (var j=0, s; (s=inNameSpaces[j]); j++) 
		if (inName in s)
			return false;
	return true;
}

wm.findUniqueName = function(inName, inNameSpaces) {
	if (wm._isUniqueName(inName, inNameSpaces))
		return inName;
	var m = (inName || '').match(/([^\d]*)([\d]*)/);
	var i = m[2] || 1, n0 = m[1] || 'noname';
	do { 
		inName = n0 + (i > 0 ? i : ''); 
		i++; 
	} while (!wm._isUniqueName(inName, inNameSpaces));
	return inName;
}

wm.getValidJsName = function(inName) {
	var dc = "_";
	inName = inName.replace(new RegExp("[- ]", "g"), dc);
	inName = inName.replace(new RegExp("[^a-zA-Z0-9_]", "g"), "");
	if (inName.match(new RegExp("^[0-9]")) || !inName)
		inName = dc + inName;
	return inName;
}

wm._modules = [];
wm.loadModule = function(inModule) {
	if (!wm._modules[inModule]) {
		tag = [ '<scrip', 't type="text/javascript" src="', inModule, '.js"></scrip', 't>' ].join('');
		document.write(tag);
		wm._modules[inModule] = true;
	}
}

wm.widgetIsShowing = function(inWidget) {
	var w = inWidget, p;
	while (w) {
		p = w.parent;
		if (!w.showing || (w.isActive && !w.isActive()))
			return false;
		w = p;
	}
	return true;
}

wm.forEachWidget = function(inWidget, inFunc, inIgnoreBuiltin) {
	if (inFunc&&inFunc(inWidget) === false)
		return false;
	if (!inWidget)
		return false;
	for (var i=0, ws = inWidget.getOrderedWidgets(), r, w; w=ws[i]; i++) {
		r = w.forEachWidget && !inIgnoreBuiltin ? w.forEachWidget(inFunc) : wm.forEachWidget(w, inFunc, inIgnoreBuiltin);
		if (r === false)
			return false;
	}
}

// themes
wm.theme = {
	getPath: function() {
			return dojo.moduleUrl("wm.base","widget/themes/" + "default/");
	},
	getImagesPath: function() {
		return wm.theme.getPath() + "images/";
	}
};

//utility: ensure dijit tooltip is hidden
wm.hideToolTip = function(inImmediate) {
	var tt = dijit._masterTT;
	if (tt) {
		dijit.hideTooltip(tt.aroundNode);
		tt._onDeck=null;
		if (inImmediate && tt.fadeOut) {
			tt.fadeOut.stop(true);
			dojo.style(tt.fadeOut.node, "opacity", 0);
		}
	}
};

/* Tested only for firefox; its not great, but better than nothing. */
wm.printStackTrace = function(msg) {
     console.group(msg);
     var done = 0;
     try {
	aaaaaaa.aaaaa.aaaa++;
     } catch(e) {
	if (e.stack) { //Firefox
		var lines = e.stack.split("\n");
		for (var i=0, len=lines.length; i<len; i++) {
				console.log(lines[i]);
				done = 1;
		}
	} else if (window.opera && e.message) { //Opera
		var lines = e.message.split("\n");
		for (var i=0, len=lines.length; i<len; i++) {
		   if (lines[i].match(/^\s*[A-Za-z0-9\-_\$]+\(/)) {
			console.log(lines[i]);
			if (lines[i+1])
			console.log("AT: " + lines[i+1]);
			done = 1;
		   }
		i++;
		}
	}
	if (!done) { //IE and Safari
		var currentFunction = arguments.callee.caller;
		while (currentFunction) {
			var fn = currentFunction.toString();
			var fname = fn.substring(fn.indexOf("function") + 8, fn.indexOf("(")) || "anonymous";
			console.log(callstack.push(fname));
			currentFunction = currentFunction.caller;
		}
	}
	console.groupEnd();
   }
};

wm.focusContainer = function(inContainer) {
	wm.onidle(function() {
		wm.forEachWidget(inContainer, function(w) {
			if (w && w.focus && (!w.canFocus || w.canFocus())) {
				w.focus();
				return false;
			}
		});
	});
}

/*
wm.isInstanceType = function(obj, type){
	try
	{
		if (!obj)
			return false;
		if (obj.instanceType)
			return obj.instanceType[type];
		else
			return (obj instanceof dojo.getObject(type));
	}
	catch(e)
	{
		console.info('failed responding to instanceType query with obj = ', obj, ' and type = ', type);
	}
	
	return false;
}
*/


wm.isClassInstanceType = function(inClass, type) {
    try {
        return inClass.prototype instanceof type;
    } catch(e) {}
    return false;
}
wm.isInstanceType = function(obj, type){
    try {
        return obj instanceof type;
    } catch(e) {}
    return false;
}
/* Obsolete with dojo 1.4 
wm.isClassInstanceType = function(inClass, type) {
        //console.log("TEST " + inClass.prototype.declaredClass);

        if (inClass.prototype === type.prototype) return true;

        // its possible for a class to be redefined, which would cause prototypes NOT to be identical, but its still the same class
        if (inClass.prototype.declaredClass && inClass.prototype.declaredClass == type.prototype.declaredClass) return true;

        if (inClass.superclass) {
                var class_names = inClass.superclass.declaredClass.split(/\B_/);
                for (var i = 0; i < class_names.length; i++) {
                        if (wm.isClassInstanceType(dojo.getObject(class_names[i]), type)) return true;
                }
        }
        return false
}

wm.isInstanceType = function(obj, type){
        try
        {
                if (!obj)
                        return false;
                if (obj instanceof type) return true;
                return wm.isClassInstanceType(obj.constructor, type);
        }
        catch(e)
        {
                console.info('failed responding to instanceType query with obj = ', obj, ' and type = ', type);
        }

        return false;
}
*/


wm.getWidgetByDomNode = function(element) {
        if (!element) return;
        if (dojo.isString(element))
                element = dojo.byId(element);
        if (!element) return;
        var pageName = app._page.name;
        var reg = new RegExp("^(" + pageName + "|app)_?");

        // If the node has no ID, then its a subnode of one of our widgets, find the node with the REAL ID.
        while ((!element.id || !element.id.match(reg)) && element.parentNode) element = element.parentNode;
        var id = element.id;
        if (!id) return;

        var originalId = id;
        var id = id.replace(reg,"");
        var elements = id.split(/_+/);
        var name = "";
        var widget = (originalId.match(/^app_/)) ? app : app._page;
        for (var i = 0; i < elements.length; i++) {
            if (wm.isInstanceType(widget, wm.PageDialog)) {
                widget = widget.pageContainer;
            }
                if (wm.isInstanceType(widget, wm.PageContainer) || wm.isInstanceType(widget, wm.pageContainerMixin)) {
                        widget = widget.page;
                        name = "";
                } else {
                        name += ((name) ? "_" : "") + elements[i];
                        if (wm.isInstanceType(widget, wm.Application)) {
                                if (widget[name]) {
                                        widget = widget[name];
                                        name = "";
                                }

                        } else {
                                if (widget.$[name]) {
                                        widget = widget.$[name];
                                        name = "";
                                }
                        }
                }
        }
        return widget;
}

if (!wm.Array) wm.Array = {};

/* Side effect: alters input inArray Object.  Returns inArray Object; Return is mostly used for chaining operations together */
wm.Array.removeElementAt = function(inArray, inIndex) {
    inArray.splice(inIndex, 1);
    return inArray;
}

/* Side effect: alters input inArray Object.  Returns inArray Object; Return is mostly used for chaining operations together */
wm.Array.removeElement = function(inArray, inElement) {
    var index = dojo.indexOf(inArray, inElement);
    if (index >= 0)
	inArray.splice(index, 1);
    return inArray; 
}

wm.Array.equals = function(a, b,optionalCallback) {
    if (a == b) return true;
    if (!a || !b) return false;
    if (a.length != b.length) return false;
    for (var i = 0; i < i.length; i++) {
	if (optionalCallback) {
	    if (!optionalCallback(a[i],b[i])) return false;
	} else {
	    if (a[i] != b[i]) return false;
	}
    }
    return true;
}

wm.Array.last = function(inArray) {
    return inArray[inArray.length-1];
}

if (!wm.String) wm.String = {};
wm.String.endStringWith = function(inString, inEnd) {
    if (!inString.match(new RegExp(inEnd + "$")))
	return inString + inEnd;
    else
	return inString;
}


}

if(!dojo._hasResource['wm.base.lib.types']){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource['wm.base.lib.types'] = true;
/*
 *  Copyright (C) 2008-2010 WaveMaker Software, Inc.
 *
 *  This file is part of the WaveMaker Client Runtime.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
dojo.provide('wm.base.lib.types');

wm.typeManager = {
	types: {},
	initialized: false,
	initTypes: function() {
		var types = (wm.types||0).types;
		if (types)
			wm.typeManager.setTypes(types);
	},
	setTypes: function(inTypes) {
		this.clearTypes();
		dojo.mixin(this.types, inTypes);
		if (!this.initialized)
			this.addDefaultTypes();
	},
	clearTypes: function() {
		this._publicTypes = {};
		// clear all non-user types
		for (var i in this.types) {
			if (!this.types[i].userType)
				delete this.types[i];
		}
	},
	getPrimitiveType: function(inTypeName) {
		return (this.types[inTypeName] || 0).primitiveType;
	},
	isStructuredType: function(inTypeName) {
		return this.types[inTypeName] && !this.getPrimitiveType(inTypeName);
	},
	getService: function(inTypeName) {
		var t = this.types[inTypeName];
		return (t && t.service);
	},
	getLiveService: function(inTypeName) {
		var t = this.types[inTypeName];
		return (t && t.liveService && t.service);
	},
	generatePublicTypes: function() {
		var types = {};
		for (var i in this.types)
			if (this.isPublicType(i))
				types[i] = this.types[i];
		return types;
	},
	getPublicTypes: function() {
		return wm.isEmpty(this._publicTypes) ?
			this._publicTypes = this.generatePublicTypes() : this._publicTypes;
	},
	getLiveServiceTypes: function() {
		var types = this.getPublicTypes(), liveServiceTypes = {};
		for (var i in types)
			if (this.getLiveService(i))
				liveServiceTypes[i] = types[i];
		return liveServiceTypes;
	},
	isPublicType: function(inTypeName) {
		var t = this.types[inTypeName];
		return (t && !t.internal && !t.primitiveType);
	},
	getTypeSchema: function(inTypeName) {
		return (this.types[inTypeName] || 0).fields;
	},
	getType: function(inTypeName) {
		return this.types[inTypeName];
	},
	isType: function(inTypeName) {
		return Boolean(this.getType(inTypeName));
	},
	getPropertyInfoFromSchema: function(inTypeSchema, inPropName) {
		var
			s = inTypeSchema,
			parts = dojo.isString(inPropName) ? inPropName.split(".") : inPropName,
			p = parts.shift(),
			f = s[p];
		if (!parts.length)
			return f;
		else {
			var
				t = (f || 0).type,
				ts = this.getTypeSchema(t);
			if (ts)
				return this.getPropertyInfoFromSchema(ts, parts);
		}
	},

	getFilteredPropNames: function(inTypeSchema, inFilterFunc) {
		var ts = [], u = [], t, hasFilter = dojo.isFunction(inFilterFunc);
		wm.forEach(inTypeSchema, function(o, i) {
			if (!hasFilter || inFilterFunc(o)) {
				var elem = {};
				elem.info = o;
				elem.name = i;
				ts.push(elem);
			}
		});

		ts.sort(function(a, b) {
			return (a.info.fieldOrder - b.info.fieldOrder);
		});
		for (i=0; (ti=ts[i]); i++) {
			u.push(ti.name);
		}

		return u;
	},
	getSimplePropNames: function(inTypeSchema) {
		return this.getFilteredPropNames(inTypeSchema, function(p) {
			return !wm.typeManager.isStructuredType((p || 0).type);
		});
	},
	getStructuredPropNames: function(inTypeSchema) {
		return this.getFilteredPropNames(inTypeSchema, function(p) {
			return wm.typeManager.isStructuredType((p || 0).type);
		});
	},
	getPropNames: function(inTypeSchema, inStructured) {
		var
			u = this.getSimplePropNames(inTypeSchema),
			s = inStructured ? this.getStructuredPropNames(inTypeSchema) : [];
		return u.concat(s);
	},
	// returns an array of each property part ordered in schema
	getPropertyOrder: function(inType, inPropName) {
		var
			o = [],
			parts = dojo.isString(inPropName) ? inPropName.split(".") : inPropName,
			p = parts.shift(),
			schema = this.getTypeSchema(inType),
			propertyArray = this.getPropNames(schema, true);
		var c, l = propertyArray.length;
		// find property in array
		for (var i=0, n; (n = propertyArray[i]); i++)
			if (p == n) {
				c = i;
				break;
			}
		o.push(c !== undefined ? c : l);
		var
			f = schema && schema[p],
			t = (f || 0).type;
		// if no properties to descend to, return array of indices
		if (!parts.length || !t)
			return o;
		// otherwise recurse
		else
			return o.concat(this.getPropertyOrder(t, parts));
	},
	hasStructuredType: function(inTypeName, inCondition) {
		var s = this.getTypeSchema(inTypeName), p, c = dojo.isFunction(inCondition) && inCondition;
		for (var i in s) {
			p = s[i];
			if (this.isStructuredType(p.type))
				if (c) {
					if (c(p))
						return true;
				} else
					return true;
		}
	},
	// these types can be added indepenedent of server types
	addType: function(inName, inTypeInfo) {
		if (!inTypeInfo || wm.isEmpty(inTypeInfo))
			return;
		inTypeInfo.userType = true;
		this.types[inName] = inTypeInfo;
		if (this.isPublicType(inName) && !wm.isEmpty(this._publicTypes))
			this._publicTypes[inName] = inTypeInfo;
	},
	removeType: function(inName) {
	    delete this._publicTypes[inName];
	},
	addDefaultTypes: function() {
		var d = wm.defaultTypes || {};
		for (var i in d)
			this.addType(i, d[i]);
	},
	isPropInList: function(inTypeSchema, inPropName) {
		var
			s = inTypeSchema,
			parts = dojo.isString(inPropName) ? inPropName.split(".") : inPropName,
			p = parts.shift(),
			f = s[p];
		if (!f)
			return false;
		else if (f.isList)
			return true;
		else if (parts.length) {
			var
				t = (f || 0).type,
				ts = this.getTypeSchema(t);
			if (ts)
				return this.isPropInList(ts, parts);
		}
	}
};

wm.defaultTypes = {
	NumberData: {
		fields: {
			dataValue: {type: "Number"}
		}
	},
	BooleanData: {
		fields: {
			dataValue: {type: "Boolean"}
		}
	},
	StringData: {
		fields: {
			dataValue: {type: "String"}
		}
	},
	DateData: {
		fields: {
			dataValue: {type: "Date"}
		}
	},
	EntryData: {
		fields: {
			name: {type: "string"},
			dataValue: {type: "any"}
		}
	},
	AnyData: {
		fields: {
			dataValue: {type: "any"}
		}
	}
};
/*AnyData: {value: {type: "Any", isList: false, isObject: false}},
StringData: {stringValue: {type: "String", isList: false, isObject: false}},
NumericData: {numericValue: {type: "Number", isList: false, isObject: false}},
ListData: {listValue: {type: "Any", isList: true, isObject: false}}
*/
//wm.types = {};
//wm.primitives = {};

wm.isListType = function(inTypeName) {
	return inTypeName && inTypeName.charAt(0) == "[";
}

// use forceList to optionally force friendly type to show list.
wm.getFriendlyTypeName = function(inType, inForceList) {
	inType = inType || "(any)";
	var
		s = wm.typeManager.getService(inType),
		isList = wm.isListType(inType),
		t = s ? [s, inType.split(".").pop()].join('.') : inType;
	if (isList)
		t = t.slice(0,-1);
	if (inForceList || isList)
		t = t + " list";
	return t;
}

wm.getPrimitiveDisplayType = function(inPrimitiveName) {
	var t = wm.typeManager.getPrimitiveType(inPrimitiveName);
	if (t == "Boolean")
		t = "CheckBox";
	if (!t || t == "String")
		t = "Text";
	return t;
}

}

if(!dojo._hasResource['wm.base.lib.data']){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource['wm.base.lib.data'] = true;
/*
 *  Copyright (C) 2008-2010 WaveMaker Software, Inc.
 *
 *  This file is part of the WaveMaker Client Runtime.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
dojo.provide('wm.base.lib.data');

wm.data = wm.data || {};

dojo.mixin(wm.data, {
	// returns fields that should be included for type
	getIncludeFields: function(inTypeName) {
		var
			pi, fields=[],
			schema = wm.typeManager.getTypeSchema(inTypeName);
		for (var i in schema) {
			pi = schema[i];
			if (pi.include && pi.include.length) {
				// composite key
				if (wm.typeManager.isStructuredType(pi.type)) {
					var compSchema = wm.typeManager.getTypeSchema(pi.type);
					for (var j in compSchema)
						fields.push(i + "." + j);
				} else
					fields.push(i);
			}
		}
		return fields;
	},
	// Reports if given data of type has include data.
	// This is equivalent to having primary key information
	// that is necessary for initiating update and delete operations.
	// By default related structured types are not checked for include data
	// That information is typically not required for update / delete operations.
	hasIncludeData: function(inTypeName, inData) {
		if (!inData || wm.isEmpty(inData))
			return false;
		var fields = this.getIncludeFields(inTypeName);
		for (var i=0, f; f=fields[i]; i++)
			if (dojo.getObject(f, false, inData) === undefined)
				return;
		return true;
	},
	// Reports if given data of type contains necessary contents
	// to perform given operation. 
	hasOperationData: function(inOperation, inTypeName, inData) {
		if (!wm.typeManager.getLiveService(inTypeName))
			return false;
		switch(inOperation) {
			// read ok if we provide no data or we have necessary root include data
			case "read":
				return !inData || wm.data.hasIncludeData(inTypeName, inData);
			// root include data is required for delete and update
			case "delete":
			case "update":
				return wm.data.hasIncludeData(inTypeName, inData);
			// for insert all required root and provided related required data is necessary
			case "insert":
				return wm.data.hasRequiredData(inOperation, inTypeName, inData, true);
		}
	},
	// Reports if given data of type contains all required data
	// This info is helpful for determining if there's enough data to perform an insert operation
	// In this case we want to check structured related data also.
	// Operation and the structured data flag are provided for additional flexibility...
	hasRequiredData: function(inOperation, inTypeName, inData, inCheckStructured) {
		var schema = wm.typeManager.getTypeSchema(inTypeName),
			s, d, isStructured, hasData, missingRequired, hasExcluded;
		for (var i in schema) {
			s = schema[i];
			isStructured = wm.typeManager.isStructuredType(s.type);
			d = inData && inData[i];
			// check structured type
			if (isStructured && inCheckStructured) {
				if ((d || s.required) && !s.isList && !this.hasRequiredData(s.type, d, inCheckStructured))
					return false;
			} else {
				hasData = (d !== undefined);
				missingRequired = s.required && !hasData;
				// return false if we have excluded data or missing required data.
				if (dojo.indexOf(s.exclude, inOperation) != -1 ? hasData : missingRequired)
					return false;
			}
		}
		return true;
	},
	// binding
	clearBinding: function(inObject, inTargetProperty) {
		var w = wm.data.getPropWire(inObject, inTargetProperty);
		if (w) {
			var b = w.owner, target = w.target, tp = w.targetProperty;
			// note: removing wire may have side-effects so reset value with care after removing.
			if (b)
				b.removeWire(w.getWireId());
			// reset value here.
			if (target && tp)
				target.setValue(tp, "");
		}
	},
	getPropWire: function(inTargetObject, inTargetProperty) {
		var
			tp = inTargetProperty,
			tobj = inTargetObject,
			binding = tobj && tobj.$.binding,
			// Note: target bindings are stored in wires hash by targetProperty
			// source bindings has targetId appended so they will be ignored below
			w = binding && binding.wires[tp];
		// if there's a target binding, return it
		if (w)
			return w;
		// FIXME: design check...
		var ownerApp = tobj && tobj.isDesignLoaded() ? studio.application : app;
		// otherwise, if the object is owned by the application try to return a source binding.
		if (tobj && tobj.isOwnedBy(ownerApp))
			return wm.data.findSourceWire((tobj||0).getId(), tp);
	},
	findSourceWire: function(inTargetId, inProp) {
		if (inTargetId) {
			var c, o, id, wires, w;
			// search all components, wee...
			for (var i in wm.Component.byId) {
				c = wm.Component.byId[i];
				// FIXME: design check...
				if ((c instanceof wm.Binding) && (c.isDesignLoaded() || !(window.studio && window.studio._isWaveMakerStudio))) {
					var wires = c.findWiresByProps({targetId: inTargetId, targetProperty: inProp});
					if (wires.length)
						return wires[0];
				}
			}
		}
	},
	// FIXME: deprecated
	/*getPropertyBindWire: function(inBinding, inTargetProperty) {
		var wires = inBinding.wires, w;
		for (var i in wires) {
			w = wires[i];
			if (w.targetProperty == inTargetProperty)
				return w;
		}
	},*/
	getPropBindSource: function(inTargetObject, inTargetProperty) {
		var w = wm.data.getPropWire(inTargetObject, inTargetProperty);
		if (w)
			return inTargetObject.getValueById(w.source);
	},
	// a simple comparator
	compare: function(a, b) {
		return a === b ? 0 :
			a === undefined ? -1 :
			b === undefined ? 1 :
			b === null ? 1 :
			a > b ? 1 :
			-1;
	}
});

}

if(!dojo._hasResource["wm.base.data.expression"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["wm.base.data.expression"] = true;
/*
 *  Copyright (C) 2009-2010 WaveMaker Software, Inc.
 *
 *  This file is part of the WaveMaker Client Runtime.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
dojo.provide("wm.base.data.expression");

/**
	@class
	Static API for handling data expressions.
	Data expressions are strings can contain valid JavaScript and
	special macros.
	Macros are expanded via preprocessing, and use this syntax:
	<pre class="code">${&lt;id&gt;}</pre>
	&lt;id&gt; supports dot notation, e.g. ${address.name.lastName}.<br/>
	<br/>
	<b>Example:</b>
	<pre class="code">
"Half of " + ${editor1.dataValue} + " is " + ${editor1.dataValue}/2.

<i>// Macros are replaced with quoted JSON and should not be inside of literal strings</i>
"${lastName}, ${firstName}" <i>// bad</i>
${lastName} + ", " + ${firstName} <i>// good</i>
</pre>
*/
wm.expression = {
	/**
		Evaluate expression with given namespace root.
		@param {String} inExpression Valid javascript that is evaluated in global scope. The expression can contain 
			macros.
		@param {String} inRoot The root object under which id macros are evaluated.
		@example 
var exp = '"Half of " + ${editor1.dataValue} + " is " + ${editor1.dataValue}/2.';
wm.expression.getValue(exp, app.main);
	*/
	getValue: function(inExpression, inRoot) {
		var v = wm.expression._getText(inExpression, inRoot);
		return wm.evalJs(v);
	},
	getSources: function(inExpression) {
		var re = wm.expression._getSourceRegEx
		re.lastIndex = 0;
		var m, sources=[];
		while((m = re.exec(inExpression)) != null) {
		  sources.push(m[1]);
		  var mList = m[1].split(".");
		  mList.pop();
		  while(mList.length > 1) {
		    sources.push(mList.join("."));
		    mList.pop();
		  }
		}
		return sources;
	},
	_getText: function(inExpression, inRoot) {
		//return inExpression.replace(wm.expression._getSourceRegEx(), function(){
		return inExpression.replace(wm.expression._getSourceRegEx, function(){
			try {
				if (inRoot.getValue){
					var v = inRoot.getValue(arguments[1]);
				}
				else if (arguments[1].indexOf('.') != -1){
					var arr = arguments[1].split('.');
					var v = inRoot;		
					dojo.forEach(arr, function(prop){
						v = v[prop];
					});
				} else {
					var v = inRoot[arguments[1]];
				}
				// objects cannot be returned directly since they are eval'd.
				if (v instanceof wm.Object || v === undefined)
					v = "";
				// do we want to automatically jsonify all values?
				return dojo.toJson(v);
			} catch(e) {}
		});
	},
	_getSourceRegEx: new RegExp(/\$\{([^\s\:\}]+)(?:\:([^\s\:\}]+))?\}/g)
	//_getSourceRegEx: function() {
	//	return new RegExp(/\$\{([^\s\:\}]+)(?:\:([^\s\:\}]+))?\}/g);
	//}
}

}

if(!dojo._hasResource["dojo.data.util.sorter"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["dojo.data.util.sorter"] = true;
dojo.provide("dojo.data.util.sorter");

dojo.data.util.sorter.basicComparator = function(	/*anything*/ a, 
													/*anything*/ b){
	//	summary:  
	//		Basic comparision function that compares if an item is greater or less than another item
	//	description:  
	//		returns 1 if a > b, -1 if a < b, 0 if equal.
	//		'null' values (null, undefined) are treated as larger values so that they're pushed to the end of the list.
	//		And compared to each other, null is equivalent to undefined.
	
	//null is a problematic compare, so if null, we set to undefined.
	//Makes the check logic simple, compact, and consistent
	//And (null == undefined) === true, so the check later against null
	//works for undefined and is less bytes.
	var r = -1;
	if(a === null){
		a = undefined;
	}
	if(b === null){
		b = undefined;
	}
	if(a == b){
		r = 0; 
	}else if(a > b || a == null){
		r = 1; 
	}
	return r; //int {-1,0,1}
};

dojo.data.util.sorter.createSortFunction = function(	/* attributes array */sortSpec,
														/*dojo.data.core.Read*/ store){
	//	summary:  
	//		Helper function to generate the sorting function based off the list of sort attributes.
	//	description:  
	//		The sort function creation will look for a property on the store called 'comparatorMap'.  If it exists
	//		it will look in the mapping for comparisons function for the attributes.  If one is found, it will
	//		use it instead of the basic comparator, which is typically used for strings, ints, booleans, and dates.
	//		Returns the sorting function for this particular list of attributes and sorting directions.
	//
	//	sortSpec: array
	//		A JS object that array that defines out what attribute names to sort on and whether it should be descenting or asending.
	//		The objects should be formatted as follows:
	//		{
	//			attribute: "attributeName-string" || attribute,
	//			descending: true|false;   // Default is false.
	//		}
	//	store: object
	//		The datastore object to look up item values from.
	//
	var sortFunctions=[];

	function createSortFunction(attr, dir, comp, s){
		//Passing in comp and s (comparator and store), makes this
		//function much faster.
		return function(itemA, itemB){
			var a = s.getValue(itemA, attr);
			var b = s.getValue(itemB, attr);
			return dir * comp(a,b); //int
		};
	}
	var sortAttribute;
	var map = store.comparatorMap;
	var bc = dojo.data.util.sorter.basicComparator;
	for(var i = 0; i < sortSpec.length; i++){
		sortAttribute = sortSpec[i];
		var attr = sortAttribute.attribute;
		if(attr){
			var dir = (sortAttribute.descending) ? -1 : 1;
			var comp = bc;
			if(map){
				if(typeof attr !== "string" && ("toString" in attr)){
					 attr = attr.toString();
				}
				comp = map[attr] || bc;
			}
			sortFunctions.push(createSortFunction(attr, 
				dir, comp, store));
		}
	}
	return function(rowA, rowB){
		var i=0;
		while(i < sortFunctions.length){
			var ret = sortFunctions[i++](rowA, rowB);
			if(ret !== 0){
				return ret;//int
			}
		}
		return 0; //int  
	}; // Function
};

}

if(!dojo._hasResource["dojo.data.util.simpleFetch"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["dojo.data.util.simpleFetch"] = true;
dojo.provide("dojo.data.util.simpleFetch");


dojo.data.util.simpleFetch.fetch = function(/* Object? */ request){
	//	summary:
	//		The simpleFetch mixin is designed to serve as a set of function(s) that can
	//		be mixed into other datastore implementations to accelerate their development.  
	//		The simpleFetch mixin should work well for any datastore that can respond to a _fetchItems() 
	//		call by returning an array of all the found items that matched the query.  The simpleFetch mixin
	//		is not designed to work for datastores that respond to a fetch() call by incrementally
	//		loading items, or sequentially loading partial batches of the result
	//		set.  For datastores that mixin simpleFetch, simpleFetch 
	//		implements a fetch method that automatically handles eight of the fetch()
	//		arguments -- onBegin, onItem, onComplete, onError, start, count, sort and scope
	//		The class mixing in simpleFetch should not implement fetch(),
	//		but should instead implement a _fetchItems() method.  The _fetchItems() 
	//		method takes three arguments, the keywordArgs object that was passed 
	//		to fetch(), a callback function to be called when the result array is
	//		available, and an error callback to be called if something goes wrong.
	//		The _fetchItems() method should ignore any keywordArgs parameters for
	//		start, count, onBegin, onItem, onComplete, onError, sort, and scope.  
	//		The _fetchItems() method needs to correctly handle any other keywordArgs
	//		parameters, including the query parameter and any optional parameters 
	//		(such as includeChildren).  The _fetchItems() method should create an array of 
	//		result items and pass it to the fetchHandler along with the original request object 
	//		-- or, the _fetchItems() method may, if it wants to, create an new request object 
	//		with other specifics about the request that are specific to the datastore and pass 
	//		that as the request object to the handler.
	//
	//		For more information on this specific function, see dojo.data.api.Read.fetch()
	request = request || {};
	if(!request.store){
		request.store = this;
	}
	var self = this;

	var _errorHandler = function(errorData, requestObject){
		if(requestObject.onError){
			var scope = requestObject.scope || dojo.global;
			requestObject.onError.call(scope, errorData, requestObject);
		}
	};

	var _fetchHandler = function(items, requestObject){
		var oldAbortFunction = requestObject.abort || null;
		var aborted = false;

		var startIndex = requestObject.start?requestObject.start:0;
		var endIndex = (requestObject.count && (requestObject.count !== Infinity))?(startIndex + requestObject.count):items.length;

		requestObject.abort = function(){
			aborted = true;
			if(oldAbortFunction){
				oldAbortFunction.call(requestObject);
			}
		};

		var scope = requestObject.scope || dojo.global;
		if(!requestObject.store){
			requestObject.store = self;
		}
		if(requestObject.onBegin){
			requestObject.onBegin.call(scope, items.length, requestObject);
		}
		if(requestObject.sort){
			items.sort(dojo.data.util.sorter.createSortFunction(requestObject.sort, self));
		}
		if(requestObject.onItem){
			for(var i = startIndex; (i < items.length) && (i < endIndex); ++i){
				var item = items[i];
				if(!aborted){
					requestObject.onItem.call(scope, item, requestObject);
				}
			}
		}
		if(requestObject.onComplete && !aborted){
			var subset = null;
			if(!requestObject.onItem){
				subset = items.slice(startIndex, endIndex);
			}
			requestObject.onComplete.call(scope, subset, requestObject);
		}
	};
	this._fetchItems(request, _fetchHandler, _errorHandler);
	return request;	// Object
};

}

if(!dojo._hasResource["wm.base.data.SimpleStore"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["wm.base.data.SimpleStore"] = true;
/*
 *  Copyright (C) 2008-2010 WaveMaker Software, Inc.
 *
 *  This file is part of the WaveMaker Client Runtime.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
dojo.provide("wm.base.data.SimpleStore");


dojo.declare("wm.base.data.SimpleStore", null, {
	constructor: function(inData, inIdentity) {
		// assumed to be a list .isList = true
		this.data = inData || [];
		this.identity = inIdentity;
	},
	getCount: function() {
		return this.data.length;
	},
	// find item by identity
	_fetchItemByIdentity: function(inIdentity) {
		var id = this.identity;
		for (var i=0, data = this.data, l=this.getCount(), d; i<l && (d=data[i]); i++)
			if (d[id] === inIdentity)
				return d;
	},
	
	_getQuery: function(inRequest) {
		var query = inRequest.query;
		if (dojo.isString(query)) {
			var q = query;
			query = {};
			query[this.identity] = q;
		}
		return query;
	},
	// one level deep object matching
	_objectsMatch: function(inA, inB) {
		var
			ac = 0,
			a = inA instanceof wm.Variable ? inA.getData() : inA,
			b = inB instanceof wm.Variable ? inB.getData() : inB;
		for (var i in a) {
			// ignore object properties since we are matching only 1 level deep
			if (dojo.isObject(a[i]))
				continue;
			ac++;
			if (a[i] != (b && b[i]))
				return;
		}
		var bc = 0;
		for (var i in b) {
			// ignore object properties since we are matching only 1 level deep
			if (!dojo.isObject(b[i]))
				bc++;
		}
		return ac == bc;
	},
	_itemInQuery: function(inItem, inQuery, inIgnoreCase, inExactMatch) {
		var
			d = inItem, w = "*", a, b, exact;
		for (var i in inQuery) {
			a = d[i];
			b = inQuery[i];
			if (b == w)
				continue;
			exact = inExactMatch || (b.indexOf(w) == - 1);
			if (dojo.isString(a) && dojo.isString(b) && !exact) {
				if (b.charAt(b.length-1) == w)
					b = b.slice(0, -1);
				if (inIgnoreCase) {
					a = a.toLowerCase();
					b = b.toLowerCase();
				}
				if (a.indexOf(b) != 0)
					return;
			}
			else if (dojo.isObject(a) && dojo.isObject(b)) {
				return this._objectsMatch(a, b);
			}
			else if (a !== b)
				return;
		}
		return true;
	},
	
	_fetchItems: function(inRequest, inFetchHandler, inErrorHandler) {
		var
			query = this._getQuery(inRequest),
			opts = inRequest.queryOptions,
			ignoreCase = opts && opts.ignoreCase,
			exactMatch = opts && opts.exactMatch,
			result = [];
		for (var i=0, data = this.data, l=this.getCount(), d; i<l && (d=data[i]); i++)
			if (this._itemInQuery(d, query, ignoreCase, exactMatch)) {
				result.push(d);
				if (exactMatch)
					break;
			}
		inFetchHandler(result, inRequest);
		// FIXME: ever an error condition?
	},
	
	_assertIsItem: function(/* item */ item){
		if(!this.isItem(item)){ 
			throw new Error("Invalid item:", item);
		}
	},
	getValue: function(	/* item */ item, 
						/* attribute-name-string */ attribute, 
						/* value? */ defaultValue){
		this._assertIsItem(item);
		var v = item[attribute];
		return v !== undefined ? v : defaultValue;
	},
	getValues: function(/* item */ item,
						/* attribute-name-string */ attribute){
		var d = this.getValue(item, attribute);
		return d ? [d] : []; // an array that may contain literals and items
	},
	
	getAttributes: function(/* item */ item){
		this._assertIsItem(item);
		var
			result = [];
			for (var i in item)
				result.push(i);
		return result; // array
	},

	hasAttribute: function(/* item */ item,
							/* attribute-name-string */ attribute){
		this._assertIsItem(item);
		for (var i in item)
			if (attribute == i)
				return true;
		return false;
	},

	containsValue: function(/* item */ item,
							/* attribute-name-string */ attribute, 
							/* anything */ value){
		this._assertIsItem(item);
		return (this.getValue(item, attribute) === value);
	},

	isItem: function(/* anything */ something){
		return something && dojo.isObject(something);
	},

	isItemLoaded: function(/* anything */ something) {
		return this.isItem(something);
	},

	loadItem: function(/* object */ keywordArgs){
		if (!this.isItemLoaded(keywordArgs.item)) {
			throw new Error('Unimplemented API: dojo.data.api.Read.loadItem');
		}
	},
	
	getFeatures: function(){
		return {
			'dojo.data.api.Read': true,
			'dojo.data.api.Identity': true
		};
	},

	close: function(/*dojo.data.api.Request || keywordArgs || null */ request){
	},

	getLabel: function(/* item */ item){
		this._assertIsItem(item);
		return (item || []).toString();
	},

	getLabelAttributes: function(/* item */ item){
		return this.getAttributes(item);
	},
	
	getIdentity: function(/* item */ item){
		this._assertIsItem(item);
		return item[this.identity] || null;
	},

	getIdentityAttributes: function(/* item */ item){
		return this.identity;
	},

	fetchItemByIdentity: function(/* object */ keywordArgs){
		var inIdentity = keywordArgs.identity;
		if (inIdentity === undefined) {
			if(keywordArgs.onError)
				keywordArgs.onError.call(scope, "No item found");
			return;
		}
		var
			item = this._fetchItemByIdentity(inIdentity),
			scope = keywordArgs.scope ? keywordArgs.scope : dojo.global;
		if (item) {
				if(keywordArgs.onItem)
					keywordArgs.onItem.call(scope, item);
		} else {
			if(keywordArgs.onError)
				keywordArgs.onError.call(scope, "No item found");
		}
	}
});

//Mix in the simple fetch implementation to this class.
dojo.extend(wm.base.data.SimpleStore,dojo.data.util.simpleFetch);

}

if(!dojo._hasResource["wm.base.Object"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["wm.base.Object"] = true;
/*
 *  Copyright (C) 2008-2010 WaveMaker Software, Inc.
 *
 *  This file is part of the WaveMaker Client Runtime.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
dojo.provide("wm.base.Object");


/**
	Base class that supports property inspection and binding.
	<br/><br/>
	Almost all objects in WaveMaker are instances of <i>wm.Object</i>.
	In particular, all Components and Widgets descend from <i>wm.Object</i> 
	<br/><br/>
	<i>wm.Object</i> supports a generalized property system: in order to
	access or modify properties on a <i>wm.Object</i> use the
	<a href="#getValue">getValue</a>/<a href="#setValue">setValue</a> API.
	<br/><br/>
	<a href="#getValue">getValue</a> takes the name of the property to examine. 
	<a href="#setValue">setValue</a> takes 
	the name of the property and the value to set. 
	<a href="#getValue">getValue</a>/<a href="#setValue">setValue</a> support dot notation.
	<br/><br/>
	For all objects that descend from <i>wm.Object</i>.use the
	<a href="#getValue">getValue</a>/<a href="#setValue">setValue</a>
	API to access documented properties 
	<br/><br/>
	Examples
	@example
	// To examine the name of a Component
	var n = this.myComponent.getValue("name");
	<br/>
	// To change the name of the Component
	this.myComponent.setValue("name", "newName");
	<br/>
	//"panel1" contains an object named "label1"
	this.panel1.setValue("label1.caption", "hello world");
	
	@name wm.Object
	@class
*/
dojo.declare("wm.Object", null, {
	/** @lends wm.Object.prototype */
	// hey ma, no props!
	//===========================================================================
	// Construction
	//===========================================================================
	constructor: function() {
		this.type = this.declaredClass;
	},
	/**
		Returns a string identifier (primarily for debugging).
	*/
	toString: function() {
		return '[' + this.declaredClass + ']';
	},
	//===========================================================================
	// Properties
	//===========================================================================
	/** @private */
	getProp: function(inPropertyName) {
		var g = this._getPropWorker(this, inPropertyName, "get");
		if (g)
			return g.call(this, inPropertyName);
		else
			return this._getProp(inPropertyName);
	},
	_getProp: function(inProp) {
		return this[inProp];
	},
	/** @private */
	setProp: function(inProp, inValue) {
		if (this.isDestroyed)
			return;
		var s = this._getPropWorker(this, inProp, "set");
		if (s)
			s.call(this, inValue);
		else
			this._setProp(inProp, inValue);
		this.valueChanged(inProp, this.getProp(inProp));
	},
	_setProp: function(inProp, inValue) {
		if (inProp in this)
			this[inProp] = inValue;
	},
	_getPropWorker: function(inObj, inProp, inPrefix) {
		//if (inProp=="dataValue" || inProp=="value")
		//	return null;
		var w = inObj[inPrefix + "_" + inProp] || this[inPrefix + inProp.slice(0, 1).toUpperCase() + inProp.slice(1)];
		if (dojo.isFunction(w))
			return w;
	},
	//===========================================================================
	// Values
	//===========================================================================
	/** @private */
	valueChanged: function(inProp, inValue) {
	},
	_getValue: function(inProp) {
		// private API for getting a named value/property
		// for Object, values are props
		return this.getProp(inProp);
	},
	_setValue: function(inProp, inValue) {
		// private API for setting a named value/property
		// for Object, values are props
		this.setProp(inProp, inValue);
	},
	/**
		Get the value of a named property.
		
		Supports dot notation, e.g. 
		@example this.getValue("customer.name.first")
		
		@param {String} inName Name of property
		
		@see <a href="#setValue">setValue</a>
	*/
	getValue: function(inName) {
		// public API for getting a named value/property using dot-notation
		// all *actual* getting is delegated, we only manage dots here
		// inProp is like "foo.bar.baz" or ["foo", "bar", "baz"]
		if (!inName)
			return;

		// Replace all [\d+] with .[\d+] so that split will work properly and separate out array index substrings
	    var parts = dojo.isString(inName) ? inName.replace(/([^\.])\[/g, "$1.[").split('.') : inName;

	    // if we get something stupid like "studio.wip.widgetname" thats not going to be resolvable by this object as this object won't 
	    // know what studio is.  window does know what studio is...
	    var o = (parts[0] == "studio" && this instanceof wm.Application) ? window : this;
	    var p;
		while (parts.length > 1) {
			p = parts.shift();
			var pmatch;
			// replace ${myVar[5]} with ${myVar.[5]}
			if (this instanceof wm.Variable || this instanceof Array) {
			  pmatch =  p.match(/^\[(\d+)\]$/);
		        }
			if (pmatch && this instanceof wm.Variable)
			  o = o.getItem(pmatch[1]);
			else if (pmatch && this instanceof Array)
			  o = o[pmatch1];
			else
			  o = o.getValue ? o.getValue(p) : o[p];
			if (!o) {
				wm.logging && console.debug(this, "notice: Object.getValue: couldn't marshall property ", p, " for ", inName);
				return;
			}
			if (o.getValue)
				return o.getValue(parts);
		}
		p = parts.shift();
		return o._getValue ? o._getValue(p) : o[p];
	},
	/**
		Set the value of a named property. 
		Using this method to set properties is <b>required</b> to support binding.
		
		Supports dot notation, e.g. 
		@example this.setValue("customer.name.first", "Harry")
		
		@param {String} inName Name of property
		@param {Any} inValue Value to set on property
		
		@see <a href="#setValue">getValue</a>
	*/
	setValue: function(inName, inValue) {
		// public API for setting a named value/property using dot-notation
		// all *actual* setting is delegated, we only manage dots here
		// inProp is like "foo.bar.baz" or ["foo", "bar", "baz"]
		var parts = dojo.isString(inName) ? inName.split('.') : inName, o=this, p;
		while (parts.length > 1) {
			o = o.getValue(parts.shift());
			// it's possible this value is not yet settable
			if (!o)
				return;
			if (o instanceof wm.Object)
				return o.setValue(parts, inValue);
		}
		p = parts.shift();
		o._setValue ? o._setValue(p, inValue) : o[p] = inValue;
	}
});

//===========================================================================
// Class Properties
//===========================================================================
/** @lends wm.Object */
dojo.mixin(wm.Object, {
	/**
		@private
		Object metadata (aka "schema") is stored using function prototypes
		(aka classes) to take advantage of built-in copy-on-write 
		prototype chaining.
		Schema class is stored in a class-property called "schemaClass",
		and an instance of it is made available in the related class prototype 
		as "schema".
	*/
	//FIXME: have I confused myself into using a overly complex mechanism? 
	makeSchema: function(inClass) {
		//console.info("makeSchema:", inClass.prototype);
		// make an empty function so we get a prototype
		inClass.schemaClass = function(){};
		var superClass = inClass.superclass;
		try{
			if (inClass._meta.parents && inClass._meta.parents.length > 1){
				superClass = inClass._meta.parents[0].prototype;
			}
		}
		catch(e){
			// do nothing.
		}
		
		// if we have a superclass, chain to it's schema
		if (superClass) {
			var ctor = this.getSchemaClass(superClass.constructor);
			inClass.schemaClass.prototype = new ctor();
		}
		inClass.prototype.schema = new inClass.schemaClass();
		return inClass.schemaClass;
	},
	/** @private */
	// Get the schema class for class inClass. Manufacture the schema class if necessary.
	getSchemaClass: function(inClass) {
		return inClass.schemaClass || wm.Object.makeSchema(inClass);
	},
	/**
		Add entries to a class schema.
		Note that "inClass" is a class (function), not a class-name (string).
		
		@param {Function} inClass Add schema entries to this class.
		@param {Object} inSchema Schema entries in object notation.
		
		@example
wm.Object.extendSchema(wm.MyButton, {
	confirmPrompt: { writeonly: 1} // configure flags for confirmPrompt property
});
	*/
	extendSchema: function(inClass, inSchema) {
		dojo.extend(wm.Object.getSchemaClass(inClass), inSchema);
		// expunge memoized property information
		delete inClass._publishedProps;
	}
});

//===========================================================================
// Design Schema
//===========================================================================
wm.Object.extendSchema(wm.Object, {
	declaredClass: { ignore: 1 },
	schema: { ignore: 1 },
	schemaClass: { ignore: 1 },
	type: { ignore: 1 }
});

//===========================================================================
// Design Time Extensions
//===========================================================================
/** @lends wm.Object.prototype */
/**#@+ @design */
wm.Object.extend({
	//===========================================================================
	// Extensions for property enumeration
	//===========================================================================
	/**
		Hook for subclasses to add flags to the typeInfo structure
		for property <i>inName</i>.
		Called from <a href="#getPropertyType">getPropertyType</a>.
		@param {String} inName Name of property.
		@param {Object} inTypeInfo Type info structure to modify.
	*/
	getPropFlags: function(inName, inTypeInfo) {
	},
	/**
		Get type information for a property.
		Returns a structure containing schema information for property <i>inName</i>,
		including at least the following fields:
		<ul>
			<li>type: <i>(string) name of type</i></li>
			<li>isObject: <i>(boolean) true if property is itself a wm.Object</i></li>
			<li>isEvent: <i>(boolean) true if property represents an event</i></li>
		</ul>
	*/
	getPropertyType: function(inName) {
		var v = this.getProp(inName);
		var t = {
			type: v && v.type || typeof v,
			isObject: v instanceof wm.Object
		}
		this.getPropFlags(inName, t);
		var s = this.schema[inName] || {
		    noprop: Boolean((v === undefined) || (v === null) || inName.charAt(0)=='_' || (dojo.isFunction(v) || dojo.isObject(v)) && !t.isCustomMethod)
		};
		return dojo.mixin(t, s);
	},
	// $ Build property information into ioProps from the properties of
	// $ inSchema filtered by inGetTypeInfo function (or getPropertyType by default).
	_listSchemaProperties: function(ioProps, inSchema, inGetTypeInfo) {
		var getInfo = this[inGetTypeInfo||"getPropertyType"], op = Object.prototype;
		for (var p in inSchema) {
			if (p == 'inherited'){
				//console.info('ignoring inherited function here..... for id = ', inSchema.id);
				continue;	
			}
			
			if (!(p in ioProps) && !(p in op)) {
				var t = getInfo.call(this, p);
				if (!t.noprop)
					ioProps[p] = t;
			}
		}
		return ioProps;
	},
	//$ Combine property information from basic reflection with
	//$ explicit schema information to form a list
	//$ of property information records.
	_listProperties: function() {
		var props = {};
		this._listSchemaProperties(props, this);
		return this._listSchemaProperties(props, this.schema);
	},
	/**
		Return memoized list of property information records.
	*/
	listProperties: function() {
		return this.constructor._publishedProps || (this.constructor._publishedProps = this._listProperties());
	},
	/**
		Return memoized list of value information records.
		wm.Object does not distinguish properties from values, so
		the base implementation just calls <a href="#listProperties">listProperties</a>.
	*/
	listDataProperties: function() {
		return this.listProperties();
	}
});
/**#@-*/

//===========================================================================
// One-stop wm.Objects
//===========================================================================
wm.define = function(inClass, inSuperclasses, inProperties) {
	if (arguments.length < 3) {
		inProperties = inSuperclasses;
		inSuperclasses = wm.Control;
	}
	var schema = inProperties.published;
	delete inProperties.published;
	var ctor = dojo.declare(inClass, inSuperclasses, inProperties);
	wm.Object.extendSchema(ctor, schema);
	return ctor;
}

}

if(!dojo._hasResource["wm.base.Component"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["wm.base.Component"] = true;
/*
 *  Copyright (C) 2008-2010 WaveMaker Software, Inc.
 *
 *  This file is part of the WaveMaker Client Runtime.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
dojo.provide("wm.base.Component");


/**
	Base class for all palette objects.
	<br><br>Component:
	<ul>
		<li>can own components, and can itself be owned.</li>
		<li>ensures all owned components have distinct names.</li>
		<li>can be identified by a globally unique string id.</li>
		<li>sends notification messages (via id) when it's values change</li>
		<li>can read or write it's properties to a stream</li>
	@name wm.Component
	@class
	@extends wm.Object
*/

dojo.declare("wm.Component", wm.Object, {
        theme: "wm_tundra", // default theme for all components (including Application and Page)

	/** @lends wm.Component.prototype */
	/** 
		Name of this object. 
		Must be unique to it's owner.
		@type String
		@example this.label1.setValue("name", "titleLabel");
	*/
	name: '',
	/** 
		Name of this object. 
		Must be unique to it's owner.
		@type String
		@example newButton.setValue("owner", this);
	*/
	owner: null,
	//=======================================================
	// Construction
	//=======================================================
	/**
		Component constructor optionally takes a set of properties to initialize on
		the new instance.
		@example
		var foo = new wm.Component({name: "foo"});
		@param {Object} inProperties Properties to initialize on the new instance.
		May be ommitted.
	*/
    getParentDialog: function() {
	var w = this;
	while (w) {
	    if (w instanceof wm.Dialog) {
		return w;
	    } else {
		w = w.parent;
	    }
	}
	return null;
    },
    getParentPage: function() {
	if (this instanceof wm.Page || this instanceof wm.PageDialog) 
	    return this;
	if (this.owner)
	    return this.owner.getParentPage();
	return null;
    },

    getOwnerApp: function() {
        if (wm.isInstanceType(this, wm.Application)) return this;

        if (!this.isDesignLoaded()) {
            return window.app;
        } else {
            if (this == studio.page)
                return studio.application;
            else
                return this.owner.getOwnerApp();
        }
    },
	constructor: function(inProps) {
		this.$ = this.components = {};
		this._connections = [];
		this._subscriptions = [];
		this._designee = this;
		this.isDestroyed = false;
		this._subscriptions.push(dojo.subscribe('applicationDestroyed', this, 'destroy'));
	},
	postscript: function(inProps) {
		this.create(inProps);
		wm.Component.add(this);
	},

	create: function(inProps){
		if (wm.debugPerformance) this.startTimerWithName("create",this.declaredClass);
		this.prepare(inProps);
	    //this.startTimerWithName("build",this.declaredClass);
		this.build();
	    //this.stopTimerWithName("build",this.declaredClass);
	    //this.startTimerWithName("init",this.declaredClass);
		this.init();

		if (this._designer)
			wm.fire(this, "designCreate");
		
		if (!this._loading) {
			this.postInit();
		}
		
		dojo.addOnWindowUnload(this, 'destroy');
		if (wm.debugPerformance) this.stopTimerWithName("create",this.declaredClass);
	},
	/**
		Remove this component from the system and clean up
		all resources.
	*/
	destroy: function() {
		if (this.isDestroyed)
			return;
		try
		{
			this._disconnect();
			this._unsubscribe();
			wm.fire(this, "designDestroy");

			var comps = [];
			for (var n in this.components)
				comps.push(this.components[n]);
			for(var i=0, c; (c=comps[i]); i++)
			{
				c.destroy();
				for (var n in c)
					delete c[n];
				c.isDestroyed = true;
			}	
			comps = null;
			delete this.components;
			delete this.$;
			wm.Component.remove(this);
			this.setOwner(null);
			/*
			delete this.owner;
			delete this._designee;			
			delete this.target;			
			delete this.widgets;
			*/
			this.isDestroyed = true;
		}
		catch(e)
		{
			//console.info('error while deleting component', e);
		}			
	},
	prepare: function(inProps) {
		this.readProps(inProps);
		dojo.mixin(this, {flags:{}}, inProps);
		this.setOwner(this.owner);
	},
	readProps: function(inProps) {
	},
	build: function() {
	},
	init: function() {
	},
	postInit: function() {
		this.valueChanged("", this);
	},
	loaded: function() {
		  this._loading = false;
		  this.postInit();
	},
	toString: function() {
	    return '[' + this.declaredClass + ((this.name) ? ':' + this.name : "") + ']';
	},
	//=======================================================
	// FIXME: deprecated, remove asap
	//=======================================================
	// Get a named component by ascending owner chain
	getComponent: function(inName) {
		return this.components[inName] || this.owner && this.owner.getComponent(inName);
	},
	//=======================================================
	// Design Support
	//=======================================================
	isDesignedComponent: function() {
/*
	    if (!this.isDesignLoaded()) return false;

            var page = this.getParentPage();
	    while (page && page.name != "wip") 
		page = page.owner;

	    return page.name == "wip";
*/
	    return this.isDesignLoaded(); // Doh!
        },
	isDesignLoaded: function() {
	    if (!window.studio) return false;
	    if (this.isOwnedBy(studio.page)) return true;
	    if (this == studio.page) return true;
	    if (this.isOwnedBy(studio.application)) return true;
	    if (!this.isOwnedBy(app)) return true;
	    return false;
	},
	getPath: function() {
		// FIXME: hack, at least move studio awareness to design-only code
		var p = '';
		if (this.isDesignLoaded() && studio.project) {
		    p = "projects/" + studio.project.getProjectPath() + "/";
		}

		return p;
	},
	//=======================================================
	// Ownership
	//=======================================================
	addComponent: function(inComponent) {
		var n = inComponent.name;
		//if (this.components[n]) 
		//	wm.logging && console.debug('Duplicate object name "' + n + '" in owner ' + this);
		this.components[n] = inComponent;
	},
	removeComponent: function(inComponent) {
		if (!this.components)
			return;
			
		var n = inComponent.name;
		if (this.components[n] == inComponent)
			delete this.components[n];
	},
        setOwner: function(inOwner, nonWritable) {
		var originalOwner = this.owner;
		if (this.owner)
			this.owner.removeComponent(this);
		this.owner = inOwner;
		//this.cacheRuntimeId = this.getRuntimeId();
		if (this.owner) {
		    if (!nonWritable) {
			this.owner.addComponent(this);
			if (!this._designer)
				this._designer = this.owner._designer;
		    }
		    // if the owner has changed between being page and app level, then we need to reset IDs.
		    // If there is a way to move components from one page to another, we'll need to do this as well, but
		    // that does not yet exist.
		    if ((!originalOwner && this.owner instanceof wm.Page == false) ||
			(this.owner != originalOwner && originalOwner &&
			(this.owner instanceof wm.Page == false && originalOwner instanceof wm.Page ||
			 this.owner instanceof wm.Page && originalOwner instanceof wm.Page == false))) 
		    {
			this.updateId();  
			// If my id has been changed by this, then so will all of my children's ids...
			if (this.isDesignLoaded())
			    this.resetChildIds(); 
		    }
		}
	        delete this.rootId;

	},
	isOwnedBy: function(inOwner) {
		var o = this.owner;
		while (o) {
			if (o == inOwner) 
				return true;
			o = o.owner;
		}
	},
	qualifyName: function(inName) {
		inName = this.name + '_' + inName;
		if (window.studio && (window.studio.page == this.owner || window.studio.application == this.owner))
			return inName;
		return this.owner ? this.owner.qualifyName(inName) : inName;
	},
	getUniqueName: function(inName) {
		return wm.findUniqueName(inName, [this, this.components]);
	},
	//=======================================================
	// Name & Id
	//=======================================================
	setName: function(inName) {
		if (!inName)
			return;
		wm.Component.remove(this);
		this.owner.removeComponent(this);
		this.name = inName;
		this.owner.addComponent(this);
		this.updateId();
		wm.Component.add(this);
	},
	updateId: function() {
	        var id = this.makeId();
	        if (id != this.id) {
		    this.id = id;
		    delete this.runtimeId;
		}	    
	},

	// make a streamable id
	// an id is fully qualified within its root
	makeId: function(inName) {
		inName = this.name + (inName ? (this.name ? "." : "") + inName : "");
		return this.owner ? this.owner.getId(inName) : inName;
	},
	/**
		Return a string that can identify a name as a child of
		this component in the namespace of the root object.
		@see <a href="#getRoot">getRoot</a>
		@param {String} inName The name to qualify.
		@returns {String} The qualified id string.
	*/
	getId: function(inName) {
	    if (inName)  return this.makeId(inName);
	    var id = this.id;
	    if (!this.id || this.isDesignLoaded()) {
		    var id = this.makeId();
	   	    this.id = id;
	    }
	    return id;
	},
    resetChildIds: function() {
	for(var i in this.components) {
	    delete this.components[i].id;
	    delete this.components[i].runtimeId;
	    delete this.components[i].rootId;
	    this.components[i].resetChildIds();
	}
    },
	// get the root object that owns this component and under which its id is qualified
	getRoot: function() {
	    if (this.owner)
		return this.owner.getRoot();
	    else
		return null;
	},
	// get the root portion of the runtime id
	getRootId: function() {
	    if (!this.rootId || this.isDesignLoaded()) {
		var r = this.getRoot();
		r = r ? r.getRuntimeId() : "";
		this.rootId =  r ? r + (r.charAt(r.length-1) == "." ? "" : ".") : "";
	    }
	    return this.rootId;
	},
	/**
		Return a string that can globally identify a name 
		as a child of this component.
		@param {String} inName The name to qualify.
		@returns {String} The qualified id string.
	*/
	// make a globally unique runtime id
	getRuntimeId: function(inName) {
	    if (!this.runtimeId || this.isDesignLoaded()) {		
		this.runtimeId = this.getRootId() + this.getId();
	    }
	    var result =  (inName) ? this.runtimeId + "." + inName :  this.runtimeId;
	    return result;
	},
/*
	getRuntimeId: function(inName) {
		if (this.cacheRuntimeId && this.cacheRuntimeId != '')
		{
			//usingCacheRuntimeId++;
			if (!inName || inName == '')
			{
				return this.cacheRuntimeId;
			}
			else
			{
				return this.cacheRuntimeId + '.' + inName;
			}
		}

		var r = this.getRootId() + this.getId(inName);
		return r;
	},
	*/
	// get a value under root using an id
	getValueById: function(inId) {
		var r = this.getRoot();
		r = r && r.getValue(inId);
		var result;
		if (r && r._wmNull) {
		  return app.getValue(inId);
		}

		return r || wm.Component.byId[inId];
	},
	/* 
  	LiveForm does not work with the impovement changes below.
        getValue: function(inName) {
                if (typeof inName != "string" || inName.indexOf(".") != -1)
                        return this.inherited(arguments);
                var s1 = "get" + wm.capitalize(inName);
                var s2 = "get_" + wm.capitalize(inName);
                if (this[s1])
                        return this[s1]();
                else if (this[s2])
                        return this[s2]();
                else
                        return this.inherited(arguments);
        },
        setValue: function(inName, inValue) {
                if (typeof inName != "string" || inName.indexOf(".") != -1)
                        return this.inherited(arguments);
                var s1 = "set" + wm.capitalize(inName);
                var s2 = "set_" + wm.capitalize(inName);
                if (this[s1])
                        return this[s1](inValue);
                else if (this[s2])
                        return this[s2](inValue);
                else
                        return this.inherited(arguments);

        },
	*/
	
	//=======================================================
	// Utility
	//=======================================================
	connect: function() {
		this._connections.push(dojo.connect.apply(dojo, arguments));
	},
	connectEvents: function(inObject, inEvents) {
		this._connections = this._connections.concat(wm.connectEvents(this, inObject, inEvents));
	},

	_disconnect: function(inNode, inEvents) {
		dojo.forEach(this._connections, dojo.disconnect);
		this._connections = [];
	},
	/* Only use this if you want to disconnect a single event from "this" because you plan to keep on using "this".
	   If "this" is going to go away, then the destructor takes care of all disconnects */
	disconnectEvent: function(inEvent) {
	  this._connections = dojo.filter(this._connections, function(item, index, array) {
	    if (item[1] == inEvent) {
	      dojo.disconnect(item);
	      return false;
	    } else
	      return true;
	    return item[1] != inEvent;
	  });
	},
	subscribe: function() {
            var s = dojo.subscribe.apply(dojo, arguments);
	    this._subscriptions.push(s);
            return s;
	},
        unsubscribe: function(subname) {
            for (var i = this._subscriptions.length-1; i >= 0; i--) {
                if (this._subscriptions[i][0] == subname) {
                    dojo.unsubscribe(this._subscriptions[i]);
                    wm.Array.removeElementAt(this._subscriptions,i);
                }
            }
        },
	_unsubscribe: function() {
		dojo.forEach(this._subscriptions, dojo.unsubscribe);
		this._subscriptions = [];
	},
	//=======================================================
	// Properties
	//=======================================================
	isEventProp: function(n) {
		return dojo.isFunction(this._designee[n]) && (n.slice(0,2)=="on");
	},
	isCustomMethodProp: function(n) {
		return dojo.isFunction(this.constructor.prototype[n]) && (n.slice(0,6)=="custom");
	},
	_getProp: function(n) {
		if (this.isEventProp(n))
			return this.eventBindings ? (this.eventBindings[n] || "") : "";
		// do we need this?
		var g = this._getPropWorker(this._designee, n, "get");
		if (g)
			return g.call(this, n);
		return n in this._designee ? this._designee[n] : this.components[n];
	},
	_setProp: function(n, v) {
		if (this.isEventProp(n))
			this.setEvent(n, v);
		else {
			// do we need this?
			var s = this._getPropWorker(this._designee, n, "set");
			if (s)
				s.call(this, v);
			else
				this._designee[n] = v;
		}
	},
	//=======================================================
	// Values
	//=======================================================
	// id-based notification
	valueChanged: function(inProp, inValue) {
		//console.info('inProp "' + inProp + '" => this.getRootId(): ' + this.getRootId() + ' this.getId(inProp): ' + this.getId(inProp) + ' == '+ this.getRuntimeId(inProp));
		var evtId = this.getRuntimeId(inProp);
		if (evtId == '')
		{
			return;
		}
		
		//console.info('Event: ' + evtId);
		dojo.publish(evtId + "-changed", [inValue, this]);
	},
	//=======================================================
	// Streaming In
	//=======================================================
	_create: function(ctor, props) {
		try
		{
		  return new ctor(props);
		}
		catch(e)
		{
		    console.debug("Component._create: ignoring unknown component type: ", ctor.prototype, props);
		}
		//throw ("Page._create: unknown component type: " + p);
	},
	adjustChildProps: function(inCtor, inProps) {
		dojo.mixin(inProps, {owner: this});
	},
	/**
		Create a component as a child of this component.
		@param inName {String} Name of the new component (may be altered to ensure uniqueness).
		@param inType {String} Type of component to create (note, a string, not a constructor).
		@param inProps {Object} Hash of properties to pass to the new components <a href="#constructor">constructor</a>.
		@param inEvents {Object} Name/value pairs that match events in the new component to functions in the owner.
		@param inChildren {Object} Name/value pairs that describe child components to create on this object.
		@param inOwner {Object} Optional. Override automatic value for "owner".
		@example
this.panel1.createComponent("custom", "wm.Panel", { 
	// properties
	height: "3em",
}, {
	// events
	onclick: "click" // connect onclick event to owner's "click" function
}, {
	// children
	// name: [ "[type]", { [properties] }, { [events] }, { [children] } ]
	spacer1: [ "wm.Spacer", { width: "300px" } ],
	content: [ "wm.Label", { width: "1flex" } ],
	spacer2: [ "wm.Spacer", { width: "300px" } ]
});
	*/
	createComponent: function(inName, inType, inProps, inEvents, inChildren, inOwner) {

	       if (wm.debugPerformance) {
		 if (inType == "wm.Layout") {
		   if (dojo.isFF)
		     console.groupCollapsed("CREATE " + inType + ": " + inName + " AT " + startTime);
		   else
		     console.group("CREATE " + inType + ": " + inName + " AT " + startTime);
		 }
		   this.startTimer("CreateComponent", inType);
	       }


		var ctor = dojo.getObject(inType);
		if (!ctor)
		{
			//console.info('trying to get component from componentList');
			try
			{
                            /* wm.componentList accessed here */
				wm.getComponentStructure(inType);
				ctor = dojo.getObject(inType);
			}
			catch(e)
			{
				console.info('error while getComponentStructure: ' + e);
			}
		}

		if (!ctor) throw('Component type "' + inType + '" is not available.');
		//

		var props = dojo.mixin({_designer: this._designer, _loading: true}, inProps);
		this.adjustChildProps(ctor, props);

		if (inOwner)
			props.owner = inOwner;
		//
		// FIXME: avoid unique names if owner root is loading...
		// fix to prevent extra components in application children
		// FIXME: or owner itself is loading (avoids copy/paste sub-components duplication)

		props.name = props.owner.getRoot()._loading || props.owner._loading ? inName : props.owner.getUniqueName(inName);

	    // All custom methods should be page methods; page methods have not been evaled, so 
	    // can not be defined nor invoked at design time
	    if (!this.isDesignLoaded()) {
		for (var p in props) {
		    if (p.indexOf("custom") == 0 && dojo.isFunction(ctor.prototype[p])) {
			var owner = props.owner;
			props[p] = dojo.hitch(owner, owner[props[p]]);
		    }
		}
	    }

		//
		var w = this._create(ctor, props);
                if (w.name != inName && wm.pasting && window["studio"]) 
                    studio.renamedDuringPaste[inName] = w;

		try{
		  if (inEvents && w.owner) {
		    w.owner.makeEvents(inEvents, w);
		  }
		  if (inChildren) {
		    w.createComponents(inChildren);
		  }
		}
		catch(e){
			console.info('error while creating component: ', e);
		}
		finally{
			w.loaded();
		}

	    if (wm.debugPerformance) this.stopTimerWithName("CreateComponent",inType,1);
		return w;
	},
	createComponents: function(inComponents, inOwner) {
		var result = [];
		for (var i in inComponents) {
			var c = inComponents[i];
			result.push(this.createComponent(i, c[0], c[1], c[2], c[3], inOwner));
		}
		return result;
	},
	_eventArgs: function(c, a) {
		var args = [ c ];
		for (var i=0,l=a.length; i<l; i++){args.push(a[i])};
		return args;
	},
	makeEvents: function(inEvents, inComponent) {
		var e, n, f;
		for (n in inEvents) {
			// name of the source
			f = inEvents[n];
			// the target
			e = this[f] || f;
			if (this._designer)
				// if designing, note the eventBinding
				wm.fire(inComponent, "setProp", [n, f]);
			else
				// otherwise, connect the named event
				this.connect(inComponent._eventSource||inComponent, n, this.makeEvent(e, f));
		}
	},
	makeEvent: function(inHandler, inName) {
		return dojo.isFunction(inHandler) ? this._makeEvent(inName) : this._makeComponentEvent(inHandler);
	},
	_makeEvent: function(inName) {
		var self = this;
		return function() { 
			self[inName].apply(self, self._eventArgs(this, arguments));
		}
	},
	_makeComponentEvent: function(inHandler) {
		var self = this;
		// FIXME: experimental: can call a method on a component
		return function(e) { 
			// inHandler could be a component
			// or a (string) Id of a component
			// or a (string) Id of a component + a dotted method suffix
			//console.info('inHandler ', inHandler, ' instanceof wm.Component = ' + (inHandler instanceof wm.Component));
			//console.info('wm.isInstanceType = ' + wm.isInstanceType(inHandler, 'wm.Component'));
			var c = wm.isInstanceType(inHandler, wm.Component) ? inHandler : self.getValueById(inHandler);
			if (wm.isInstanceType(c, wm.Component))
				wm.fire(c, "update", [e]);
			// call a method on a component
			else if (dojo.isString(inHandler)) {
				var o = inHandler.split('.');
				if (o.length > 1) {
					var m = o.pop();
					c = self.getValueById(o);
					if (c && c[m])
						c[m]();
				}
			}
		}
	},
	readComponents: function(inComponents) {
		var c = dojo.fromJson(inComponents);
		return this.createComponents(c);
	},
	 startTimerWithName: function(timerName, componentName) {
	  if (!wm.debugPerformance) return;
	  if (!this.logTimesWithComponentNames) this.logTimesWithComponentNames = {};
	  if (!this.logTimesWithComponentNames[componentName]) this.logTimesWithComponentNames[componentName] = {};
	  this.logTimesWithComponentNames[componentName][timerName] = new Date().getTime();
	 },
	stopTimerWithName: function(timerName, componentName) {
	  if (!wm.debugPerformance) return;
	  if (!this.logTimesWithComponentNames) this.logTimesWithComponentNames = {};
	  if (!this.logTimesWithComponentNames[componentName]) this.logTimesWithComponentNames[componentName] = {};
	  var startTime = this.logTimesWithComponentNames[componentName][timerName];
	  if (!startTime) return -1;
	  this.logTimesWithComponentNames[componentName][timerName] = 0;

	  var result = new Date().getTime() - startTime;

	    var timingObj = wm.Component.timingByComponent[componentName];
	    if (!timingObj) {
		wm.Component.timingByComponent[componentName] = {};
		timingObj = wm.Component.timingByComponent[componentName];
	    }
	    if (!timingObj[timerName]) timingObj[timerName] = [];
	    timingObj[timerName].push(result);
	
	  return result;
	},
        subtractTimerWithName: function(timerName, componentName,time) {
	  if (!wm.debugPerformance) return;
	  if (!this.logTimesWithComponentNames) this.logTimesWithComponentNames = {};
	  if (!this.logTimesWithComponentNames[componentName]) this.logTimesWithComponentNames[componentName] = {};
	  var startTime = this.logTimesWithComponentNames[componentName][timerName];
	  if (!startTime) return -1;
	    var timingObj = wm.Component.timingByComponent[componentName];
	    if (!timingObj) {
		wm.Component.timingByComponent[componentName] = {};
		timingObj = wm.Component.timingByComponent[componentName];
	    }
	    var tmp = timingObj[timereName];
	    tmp[tmp.length-1] -= time;
	},
	startTimer: function(timerName) {
	  if (!wm.debugPerformance) return;
	  if (!this.logTimes) this.logTimes = {};
	  this.logTimes[timerName] = new Date().getTime();
	},
	stopTimer: function(timerName, addToComponentLog) {
	  if (!wm.debugPerformance) return;
	  if (!this.logTimes) this.logTimes = {};
	  var startTime = this.logTimes[timerName];
	  if (!startTime) return -1;
	  this.logTimes[timerName] = 0;
	  var result = new Date().getTime() - startTime;

	  if (addToComponentLog) {
	    var timingObj = wm.Component.timingByComponent[this.declaredClass];
	    if (!timingObj) {
	      wm.Component.timingByComponent[this.declaredClass] = {};
	      timingObj = wm.Component.timingByComponent[this.declaredClass];
	    }
	    if (!timingObj[timerName]) timingObj[timerName] = [];
	    timingObj[timerName].push(result);
	  }
	  return result;
	}
});

//=======================================================
// Class Properties
//=======================================================
dojo.mixin(wm.Component, {
	//=======================================================
	// Component registry
	//=======================================================
	/** @lends wm.Component */
	byId: {},
        timingByComponent: {},
	add: function(inComponent){
		wm.Component.byId[inComponent.getRuntimeId()] = inComponent;
	},
	remove: function(inComponent){
		delete wm.Component.byId[inComponent.getRuntimeId()];
	},
	property: {
	}
});


//window.$$ = wm.Component.byId;

}

if(!dojo._hasResource["wm.base.Control"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["wm.base.Control"] = true;
/*
 *  Copyright (C) 2008-2010 WaveMaker Software, Inc.
 *
 *  This file is part of the WaveMaker Client Runtime.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
dojo.provide("wm.base.Control");
wm.splitUnits = function(inUnitValue) {
    if (!dojo.isString(inUnitValue)) return {value: inUnitValue, units: "px"};
	var m = (inUnitValue || "").match(wm.splitUnits.Rx);
	return { value: Number(m[1]) || 0, units: m[2] || "px" };
}
wm.splitUnits.Rx = /(\d*)(.*)/;

/**
	Manages geometry for a rectangle, including margins, borders, and padding and frame-of-reference calculations.
	@class
	@name wm.Bounds
*/
dojo.declare("wm.Bounds", null, {
	/** @lends wm.Bounds.prototype */
	padding: "",
	border: "",
	margin: "",
	constructor: function() {
		this.bounds = {l:0, t:0, w:96, h:64};
		this.borderExtents = {l:0, t:0, r:0, b: 0};
		this.paddingExtents = {l:0, t:0, r:0, b: 0};
		this.marginExtents = {l:0, t:0, r:0, b: 0, w: 0, h:0};
		this.padBorderMargin = {};
		this.calcPadBorderMargin();
	},
	getBounds: function() {
		return this.bounds;
	},
	/**
		Set the outermost area of this box, including margin, border, and padding.
		l, t describe the position of the outer most corner of this box.
		w, h describe the size of the box, including margin, border, and padding.
		@param {Object} inBox {l: Number, t: Number, w: Number, h: Number }
	*/
	setBounds: function(inL, inT, inW, inH) {
		if (arguments.length == 1) {
			return this.setBounds(inL.l, inL.t, inL.w, inL.h)
		}
		
		var b = this.bounds;
		if (!isNaN(inL) && b.l != inL) {
			b.l = inL;
		}
		if (!isNaN(inT) && b.t != inT) {
			b.t = inT;
		}
		if (inW >= 0 && b.w != inW) {
			b.w = inW;
			this._boundsDirty = true;
		}
		if (inH >= 0 && b.h != inH) {
			b.h = inH;
			this._boundsDirty = true;
		}
		
		// If b.l, b.w, b.t or b.h is a string like "100", it should be changed to integer before adding.
		// To ensure that we multiple it by 1.
		b.r = b.l*1 + b.w*1;
		b.b = b.t*1 + b.h*1;
		return b;
	},
	setContentBounds: function(inBox) {
		var b= {};
		var sm = this.getScrollMargins();
		if ("w" in inBox) {
			b.w = inBox.w + this.padBorderMargin.w + sm.w;
		}
		if ("h" in inBox) {
			b.h = inBox.h + this.padBorderMargin.h + sm.h;
		}
		return this.setBounds(b);
	},
	_parseExtents: function(inExtents) {
		var r = {};
		if (typeof inExtents == "number")
			r = { l: inExtents, t: inExtents, r: inExtents, b: inExtents };
		else {
			var ex = inExtents.split(",");
			var l = ex.length;
			r.t = parseFloat(ex[0]) || 0;
			r.r = l < 2 ? r.t : parseFloat(ex[1]) || 0;
			r.b = l < 3 ? r.t : parseFloat(ex[2]) || 0;
			r.l = l < 4 ? r.r : parseFloat(ex[3]) || 0;
		}
		return r;
	},
        _stringifyExtents: function(inExtents) {
            return inExtents.t + "," + inExtents.r + "," + inExtents.b + "," + inExtents.l;
        },
	/**
		Set padding extents in pixels.
		@param {String||Number} inPadding "t, <r, b, l>" || Number
	*/
	setPadding: function(inPadding) {
	    this.padding = String(inPadding);
	    this.paddingExtents = this._parseExtents(this.padding);
		this.padBorderMarginChanged();
	        this.invalidCss = true;
	        this.render();
	},
	/**
		Set border extents in pixels.
		@param {String||Number} inBorder "t, <r, b, l>" || Number
	*/
	setBorder: function(inBorder) {
	    inBorder = String(inBorder);
	    inBorder = (inBorder && inBorder.match(/\d/)) ? inBorder : "0";
	        if (inBorder !== this.border) {
		    this.border = inBorder
		    this.borderExtents = this._parseExtents(inBorder);
		    this.padBorderMarginChanged();
		    this.invalidCss = true;
		    this.render();
		}
	},
	/**
		Set margin extents in pixels.
		@param {String||Number} inMargin "t, <r, b, l>" || Number
	*/
	setMargin: function(inMargin) {
	        this.margin = String(inMargin);
		var me = this.marginExtents = this._parseExtents(this.margin);
		me.h = me.t + me.b;
		me.w = me.l + me.r;
		this.padBorderMarginChanged();
	        this.invalidCss = true;
	        this.render();
	},
        setOneMargin: function(inMargin,edge) {
            var m = this.marginExtents;
            m[edge] = inMargin;
            this.setMargin(this._stringifyExtents(m));
        },
	/**
		Update metrics when padBorderMargin has changed.
		@protected
	*/
	padBorderMarginChanged: function() {
		this.calcPadBorderMargin();
	},
	/**
		Accumulate padBorderMargin extents.
		@private
	*/
	_edges: {l:1, t:1, r:1, b:1},
	calcPadBorderMargin: function() {
		var pbm = this.padBorderMargin;
		for(var e in this._edges)
			pbm[e] = this.borderExtents[e] + this.paddingExtents[e] + this.marginExtents[e];
		pbm.w = pbm.l + pbm.r;
		pbm.h = pbm.t + pbm.b;
	},
	getScrollMargins: function() {
		return {w:0, h:0};
	},
	/**
		Get an object describing the content-box area.
		l, t describe the position of the origin for objects in this frame.
		w, h describe the size of the content area of the box (inside margin, border, padding, and scrollbars).
		@return {Object} {l: Number, t: Number, w: Number, h: Number}
	*/
	getContentBounds: function() {
		var sm = this.getScrollMargins();
		var b = {
			l: this.paddingExtents.l,
			t: this.paddingExtents.t,
			w: Math.floor(this.bounds.w) - this.padBorderMargin.w - sm.w,
			h: Math.floor(this.bounds.h) - this.padBorderMargin.h - sm.h
		};
 	       if (b.w < 0) b.w = 0;
 	       if (b.h < 0) b.h = 0;
		b.r = b.l + b.w;
		b.b = b.t + b.h;
		return b;
	},
	getStyleBounds: function() {
		if (this.isRelativePositioned){
			return {w: this.width, h: this.height};
		}
		
		var pbm = (this.dom.node.tagName.toLowerCase() == "button") ? this.marginExtents : this.padBorderMargin;
		var b = {
			l: this.bounds.l,
			t: this.bounds.t,
			w: this.bounds.w - pbm.w,
			h: this.bounds.h - pbm.h
		};
 	       if (b.w < 0) b.w = 0;
 	       if (b.h < 0) b.h = 0;
		b.r = b.l + b.w;
		b.b = b.t + b.h;
		return b;
	},
	cloneBounds: function() {
		with (this.bounds) {
			return {l:l, t:t, w:w, h:h, r:r, b:b};
		}
	}
});

dojo.declare("wm.DomNode", null, {
	constructor: function(inNode, isRelativePositioned) {
		this.node = inNode || document.createElement('div');
		this.isRelativePositioned = isRelativePositioned;
	},
	append: function(inDomNode) {
		this.node.appendChild(inDomNode.node);
	},
	remove: function(inDomNode) {
		this.node.removeChild(inDomNode.node);
	},
	getWidth: function() {
		return this.node.offsetWidth;
	},
	getHeight: function() {
		return this.node.offsetHeight;
	},
	setBox: function(inBox, inSingleLine) {
		var s = this.node.style;
//		var style = {};
		if (this.isRelativePositioned){
			s.width = inBox.w;	
			s.height = inBox.h;
			return;	
		}
		
		var bl = inBox.l + "px";
		if (!isNaN(inBox.l) && s.left != bl) {
			s.left = bl;
		}
		var bt = inBox.t + "px";
		if (!isNaN(inBox.t) && s.top != bt) {
			s.top = bt;
		}
		var bw = inBox.w + "px";
		if (inBox.w >=0 && s.width != bw) {
			s.width = bw;
		}
		var bh = inBox.h + "px";
		if (inBox.h >= 0) {
			//if (s.height != bh)
			s.height = bh;
			s.lineHeight = inSingleLine ? bh : "normal";
		} 

		//dojo.style(this.node, style);  proven to be very slow
	},
	setCssText: function(inText) {
		this.node.style.cssText += ";" + inText;
	},
	addCssText: function(inText) {
		this.node.style.cssText += inText;
	}
});

wm.aligns = [
	"topLeft", "center", "bottomRight", "justified"
];

/**
	Base class for all <i>visual</i> components.
	@name wm.Control
	@class
	@extends wm.Component
*/
wm.define("wm.Control", [wm.Component, wm.Bounds], {
	/** @lends wm.Control.prototype */
	published: {
	        invalidCss: {ignore: 1},
	        renderedOnce: {ignore: 1},
		bounds: {ignore: 1},
		border: {group: "style"},
		borderColor: {group: "style"},
		//backgroundColor: {group: "style"},
		backgroundColor: {ignore: 1},
		margin: {group: "style"},
		padding: {group: "style"},
	        autoScroll: {group: "scrolling", order: 100, ignore: 1},
	        scrollX: {group: "scrolling", order: 101},
	        scrollY: {group: "scrolling", order: 102},
		left: {writeonly: 1, ignore: 1},
		top: {writeonly: 1, ignore: 1}
	},
        renderedOnce: 0,
        invalidCss: 1,
	autoScroll: false,
	backgroundColor: "",
	//border: 1,
	borderColor: "#F0F0F0",
        binding: '(data binding)',
	classNames: '',
	id: '',
	autoSizeWidth: false,
	autoSizeHeight: false,
        _needsAutoSize: true,
	/*
	flex: '',
	left: '',
	top: '',
	*/
	/**
		Display width specified as a string with units.<br>
		<br>
		Supports CSS units and <i>flex</i> units.<br>
		@example
this.button.setValue("width", "96px");
this.text.setValue("width", "4em");
this.box.setValue("width", "1flex");
		@type String
	*/
	width: '',
	/**
		Display height specified as a string with units.<br>
		<br>
		Supports CSS units and <i>flex</i> units.<br>
		@example
this.button.setValue("height", "96px");
this.text.setValue("height", "4em");
this.box.setValue("height", "1flex");
		@type String
	*/
	height: '',
        minHeight: 0, // number represents pixels
        minWidth: 0,
        //maxHeight: 0, // number represents pixels
        //maxWidth: 0,
	left: 0,
	top: 0,
	group: '',
	styles: '',
	state : null,
	/**
		Showing state.<br>
		<br>
		Whether the widget if shown on the display.<br>
		@see <a href="#hide">hide</a>, <a href="#show">show</a>.
		@example
this.button.setValue("showing", false);
this.panel.show();
this.label.hide();
		@type Boolean
	*/
	showing: true,
	/**
		Disabled state.<br>
		<br>
		Some widgets change behavior or display based on the disabled state.<br>
		@see <a href="#disable">disable</a>, <a href="#enable">enable</a>.
		@example
this.button.setValue("disabled", true);
this.panel.disable();
this.label.enable();
		@type Boolean
	*/
	disabled: false,
	container: false,
        _classes: {domNode:[]}, // prototype gets a blank object for us to clone; allows theme to provide default classes
	scrollX: false,
	scrollY: false,

	//===========================================================================
	// Construction
	//===========================================================================
	constructor: function() {
		this.widgets = {};
	        this._classes = dojo.clone(this._classes);    
	},
    prepare: function(inProps) {
	try {
	if (inProps) {
            var owner = inProps.owner;
            if (owner) owner = owner.getOwnerApp();
            if (owner)
                owner.loadThemePrototypeForClass(this.constructor, this);
	}
	} catch(e) {
	    console.error("What the hell?" + e);
	}
	this.inherited(arguments);
    },
	postscript: function(inProps) {
		this.inherited(arguments);
	},
	create: function() {
		this._cupdating = true;
		this.inherited(arguments);
	},
	build: function() {
		this.domNode = dojo.byId(this.domNode||/*this.id||*/undefined);
		if (!this.domNode)
			this.domNode = document.createElement('div');
	},
	initDomNode: function() {
		if (!this.dom) {
			this.dom = new wm.DomNode(this.domNode, this.isRelativePositioned);
			if (!this.isRelativePositioned)
				this.domNode.style.position = "absolute";
                        else
				this.domNode.style.position = "relative";				
			this.setParent(this.parent);
			this.setDomNode(this.domNode);
		}
	},
	init: function() {

		this.initDomNode();
		this.inherited(arguments);
	        this.bc(); // mostly in here to support wm.Container's bc method
		//

/*
		this.setBorder(this.border);
		this.setMargin(this.margin);
		this.setPadding(this.padding);
*/
	    if (this.isDesignLoaded())
		// enable design borders
		this.set_border((this.border) ? String(this.border) : "0");
	    else {
	        this.border = (this.border) ? String(this.border) : "0";
	    }
	    this.borderExtents = this._parseExtents(this.border); 

		this.padding = String(this.padding);
		this.paddingExtents = this._parseExtents(this.padding);
		this.setMargin(this.margin);
	        this.doSetSizeBc();
	        if (!this.showing) this.setShowing(false,true);

   	        this.setDisabled(this.disabled);

	        /* This code is only used in design mode... if then */
  	        if (this.styles) {
		    this.set_styles(this.styles);
		    this.styles = "";
		}

		this.appendDOMNode(this.parent);
		this.updateBounds();
	},

	bc: function() {
		// oboslete method; but the version in wm.Container is still required for framework to function
	},

	postInit: function() {
		this._cupdating = false;
		this.inherited(arguments);

	    // After we've finished creating the widget, NOW we render() -- just once; not over and over while we're setting borders and
	    // margins and everything else.
	    this.render(1);


	    if (!this.$.binding && this.isDesignLoaded())
			new wm.Binding({name: "binding", owner: this});
	},


	destroy: function() {
		if (this.isDestroyed)
			return;
		try
		{
			if (this.widgets) {
				var wids = [];
				for (var n in this.widgets) 
					wids.push(this.widgets[n]);
				for (var i = 0, w; (w = wids[i]); i++) 
					w.destroy();
				wids = [];
			}
			
			this.widgets = null;
			this.parentNode = null
			this.setParent(null);
		    wm.fire(this.designWrapper, "destroy");
			this.layout = null;
			this.inherited(arguments);
		}
		catch (e)
		{
			console.info('Error while destroying : ' + this.name, e);
		}
		finally
		{
	        if (this.domNode)
		    	dojo.destroy(this.domNode);
			this.domNode =  null;
			this._designee = null;
			if (this.dom && this.dom.node)
			{
				dojo.destroy(this.dom.node);
				this.dom.node = null;
				this.dom = null;
			}
			
		}
	},
	loaded: function() {
		this.inherited(arguments);
		this.initUserClasses();
	},
	setDomNode: function(inDomNode) {
		var n = this.domNode = inDomNode;
		if (dojo.isIE) {
			// forcing a size on the node now seems to help IE
			// honor auto sizing later
			n.style.width = "0px";
		}
		// id
		this.updateId();
		// classes
		var cNames = this.classNames + (this.owner ? ' ' + this.owner.declaredClass.replace(/\./g,"") + '-' + this.name : '') + (this.isRelativePositioned && this.parent && this.parent.layoutKind == 'left-to-right' ? ' wmInlineDiv' : '');
	    dojo.addClass(n,cNames);
		this.initUserClasses();
		//this.updateBounds();
	},
    isAncestorHiddenLayer: function() {
	  if (this instanceof wm.Layout) return false;
	  if (this instanceof wm.Layer && this.parent && this.parent.getActiveLayer() != this) return true;
	  if (this.parent == null || !(this.parent instanceof wm.Control)) return false;
	  return this.parent.isAncestorHiddenLayer();
	},
        isAncestorHidden: function() {
            if (!this.showing) return true;
	  if (this instanceof wm.Layout || this instanceof wm.Dialog) return false;
	  if (this instanceof wm.Layer && this.parent.getActiveLayer() != this) return true;
	  if (this.parent == null || !(this.parent instanceof wm.Control)) return true;
	  return this.parent.isAncestorHidden();
	},
    isAncestor: function(inParent) {
	var o;
	while (o && o != inParent) {
	    o = o.parent;
	}
	return (o == inParent);
    },

	//===========================================================================
	// Name & Id
	//===========================================================================
	updateId: function() {
		this.inherited(arguments);
		if (this.domNode) {
			var rid = this.getRuntimeId();
			this.domNode.rid = rid;
			this.domNode.id = rid.replace(/\./g, "_");
		}
	},
	//===========================================================================
	// Ownership
	//===========================================================================
	getUniqueName: function(inName) {
		return wm.findUniqueName(inName, [this, this.components, this.widgets]);
	},
	//===========================================================================
	// Parentage
	//===========================================================================
	setName: function(inName) {
		if (!inName)
			return;
		if (this.parent)
			this.parent.removeWidget(this);
		this.addRemoveDefaultCssClass(false);
		this.inherited(arguments);
		if (this.parent)
			this.parent.addWidget(this);
		this.addRemoveDefaultCssClass(true);
	},
	addWidget: function(inWidget){
		this.widgets[inWidget.name] = inWidget;
		    var p = this.containerNode || this.domNode;
  	            if (inWidget.domNode.parentNode != p) {
			p.appendChild(inWidget.domNode);
		    }
	},
    /* NOTE: I don't see this called anywhere */
    insertDomNodes: function() {
	for (var i in this.widgets) 
	    this.widgets[i].insertDomNodes();
	
	var parentPage = this.getParentPage();
	    try {
		var a= 1;
		if ((!parentPage || parentPage._disableRendering) && this.invalidCss) {
		    this.renderCss();
		    this.invalidCss = false;
		}
		
		var p = this.containerNode || this.parentNode || this.parent.domNode;
		
  		if (this.domNode.parentNode != p && this.domNode.parentNode != window.document.body) 
		    p.appendChild(this.domNode);
	    } catch (e) {
		console.log("ERROR INSERTING DOM NODES FOR " + this.name );
	    }
//	}
    },
    leafFirstRenderCss: function() {
	for (var i in this.widgets) 
	    this.widgets[i].leafFirstRenderCss();
	if (this.invalidCss) {
	    this.render(1);
	}
    },
	removeWidget: function(inWidget){
		if (this.widgets)
			delete this.widgets[inWidget.name];
	},
	adjustChildProps: function(inCtor, inProps) {
	        if (wm.isClassInstanceType(inCtor, wm.Control))
			dojo.mixin(inProps, {owner: this.owner, parent: this});
		else
			this.inherited(arguments);
	},
	//=======================================================
	// Properties
	//=======================================================
	listProperties: function() {
		var p = this.inherited(arguments);
		p.autoSizeWidth.ignore = (!this.isSizeable() && !this.autoSizeWidth) || (this.schema.autoSizeWidth && this.schema.autoSizeWidth.ignore);
		p.autoSizeHeight.ignore = (!this.isSizeable() && !this.autoSizeHeight) || (this.schema.autoSizeHeight && this.schema.autoSizeHeight.ignore);
                p.minWidth.ignore = !this.schema.minWidth || this.schema.minWidth.ignore || (!this._percEx.w && !this.autoSizeWidth); // minWidth only applies if width is % or autosize is on
                p.minHeight.ignore = this.schema.minHeight.ignore || (!this._percEx.h && !this.autoSizeHeight); // minHeight only applies if height is % or autosize is on
		//p.width.ignore = p.width.writeonly = !this.isSizeable() || !this.canSetWidth();
		//p.height.ignore = p.height.writeonly = !this.isSizeable() || !this.canSetHeight();
	        p.width.ignore = p.width.writeonly = this.schema.width.ignore || !this.isSizeable() || this.autoSizeWidth;
	        p.height.ignore = p.height.writeonly = this.schema.height.ignore || !this.isSizeable() || this.autoSizeHeight;
		// _classes as array for bc; now an object that supports storing sets of classes
		if (p._classes)
			p._classes.writeonly = (dojo.isArray(this._classes) && this._classes.length) || !wm.isEmpty(this._classes);
		return p;
	},

	//===========================================================================
	// Bounds
	//===========================================================================
	// BC -->
	doSetSizeBc: function() {
		/*if (!this.width) {
			this.setSizeProp("width", "100%");
		}
		if (!this.height) {
			this.setSizeProp("height", "100%");
		}*/
		if (this.sizeUnits == "flex") {
			this.setFlex(this.size);
		} else if (this.sizeUnits) {
			var b = this.getParentBox(), p = {v: "height", h: "width"}[b];
			this.setSizeProp(p, this.size + this.sizeUnits);
		} else if (this.flex) {
			this.setFlex(this.flex);
		}
	},
	setFlex: function(inFlex) {
		var box = this.getParentBox();
		if (box) {
			var ex = {h: "width", v: "height"}[box];
			this.setSizeProp(ex, inFlex*100 + "%");
			this._boundsDirty = true;
		} else {
			this.setSizeProp("width", inFlex*100 + "%");
			this.setSizeProp("height", inFlex*100 + "%");
		}
	},
    /* mkantor: Commented out 4/14/2010; presumed WM 4.x only 
	isFlex: function() {
		var box = this.getParentBox();
		if (!box)
			return false;
		var ex = {h: "width", v: "height"}[box];
		return (this[ex].indexOf("flex")>=0);
	},
        */
	// <-- BC
	getScrollMargins: function() {
	    return {w: (this.scrollY || this._xscrollY) ? 17 : 0, h: (this.scrollX || this._xscrollX) ? 17 : 0};
/*
	  if (!this.autoScroll) {
	    return {w: (this.scrollY) ? 17 : 0, h: (this.scrollX) ? 17 : 0};
	  } else {
	    return {w: (this._xscrollY || this.domNode.style.overflow == "auto") ? 17 : 0, h: (this._xscrollX || this.domNode.style.overflow == "auto") ? 17 : 0};
	  }
	  */
	},
    isReflowEnabled: function() {
	if (this._cupdating) return false;
	if (this.owner) {
	    if (wm.isInstanceType(this.owner, wm.Control))
		return this.owner.isReflowEnabled();
	    else {
		return !this.owner._loadingPage;
	    }
	}
	return true;
    },
	padBorderMarginChanged: function() {
		this.inherited(arguments);

                if (!this._doingAutoSize)
	            this._needsAutoSize = true; 

	        if (this.isReflowEnabled()) {
		    if (this.parent) 
			this.parent.reflow();
		    else {
			this.render();
			wm.fire(this, "flow");
		    }
		}
	},
	/**
		Update width and height properties after bounds change.
	*/
	boundsResized: function() {
		var box = dojo.marginBox(this.dom.node);
		if (this.bounds.w != box.w) {
			this.width = this.bounds.w + "px";
		}
		if (this.bounds.h != box.h) {
			this.height = this.bounds.h + "px";
		}
		this.updateBounds();
	},
	/**
		Update bounds and flex properties based on width/height properties 
	*/
	updateBounds: function() {
		//this.domNode.flex = 0;
		//this.fluidSize = 0;
		this._percEx = {w:0, h: 0};
		//
		//var pd = this.getParentBox();
		//
		var su = wm.splitUnits(this.width);
		var w = su.value;
		switch (su.units) {
			// FIXME: 'flex' and 'em' are deprecated, probably this should be in BC block
			case "flex":
				w *= 100;
				this._percEx.w = w;
				this.width = w + "%";
				w = NaN;
				break;
			case "em":
				w *= 18;
				this.width = w + "px";
				break;
			case "%":
				this._percEx.w = w;
				w = NaN;
				break;
		}
		//
		su = wm.splitUnits(this.height);
		var h = su.value;
		switch (su.units) {
			// FIXME: 'flex' and 'em' are deprecated, probably this should be in BC block
			case "flex":
				h *= 100;
				this._percEx.h = h;
				this.height = h + "%";
				h = NaN;
				break;
			case "em":
				h *= h * 18;
				this.height = h + "px";
				break;
			case "%":
				this._percEx.h = h;
				h = NaN;
				break;
		}

		//console.log(w, h);
		this.setBounds(NaN, NaN, w, h);
		//this.setBounds(this.left, this.top, w, h);
	},
	// return the 'box' setting of our parentNode
	getParentBox: function() {
		var n = (this.domNode || 0).parentNode;
		return n && (n.box || (n.getAttribute && n.getAttribute("box"))) || (this.parent||0).box || '';
	},

        adjustSetSizeProp: function(n,v) {return v;},
        setSizeProp: function(n, v, inMinSize) {
	    // We either have a minSize passed in from user set properties, or we let the widget itself decide what its minimum size should be.
	    var minName = "min"    + wm.capitalize(n);
	    var getMin  = "getMin" + wm.capitalize(n) + "Prop";
	    var minSize = inMinSize || this[getMin]();

	    v = this.adjustSetSizeProp(n,v);

	    if (this[n] == v && this[minName] == inMinSize) {
		if (v.match(/px/) && parseInt(v) != this.bounds[(n=="height") ? "h" : "w"]) {
		    ;
		} else {
		    return;
		}
	    }

	       this[n] = v;
	       this[minName] = inMinSize;

            // If widget suppports resizing, and isn't in the middle of doing an autoSize, then it now needs to be autoResized as its width or height have changed
            if (!this._doingAutoSize) {
	        this._needsAutoSize = true; 

                // A setSize call that is not made while doing autoSize means we are no longer an autosize widget
                if (this.autoSizeHeight && n == "height") this.autoSizeHeight = false;
                if (this.autoSizeWidth && n == "width") this.autoSizeWidth = false;
            }

	        // MK: One line fix added Feb 18 2010:
	        // Because the domNode of the designWrapper is not getting updated, we need to set invalidCss to true.  May prove unnecessary.
		if(this.designWrapper) this.designWrapper.invalidCss = true;
	
		if (!this._loading)
			this.updateBounds();
	    if (this.isReflowEnabled() && this.showing) 
		    this.reflowParent();
	},
	setWidth: function(inWidth) {
	    this.setSizeProp("width", inWidth, this.minWidth);
	},
	setHeight: function(inHeight) {
	    this.setSizeProp("height", inHeight, this.minHeight);
	},
	setMinWidth: function(inMinWidth) {
	    inMinWidth = (inMinWidth) ? parseInt(inMinWidth) : 0;
	    this.setSizeProp("width", this.width, inMinWidth);
	},
	setMinHeight: function(inMinHeight) {
	    inMinHeight = (inMinHeight) ? parseInt(inMinHeight) : 0;
	    this.setSizeProp("height", this.height, inMinHeight);
	},

	// this method is related to set/getMinWidth/Height, but whereas set/getMinWidth/Height are basic setters/getters of the minWidth/minHeight property, 
	// these methods are designed to allow each object to calculate at runtime what its preferred minimum is... unless one has been specified by the user.
        // NOTE: minWidth/minHeight are ignored if size is set in px instead of %.  minHeight/minWidth may also kick in for fitToContent containers.
	getMinWidthProp: function() {
		return this.minWidth || 30;
	},
	getMinHeightProp: function() {
		return this.minHeight || 15;
	},
/*
	setMaxWidth: function(inMaxWidth) {
	    inMaxWidth = parseInt(inMaxWidth) || 0;
	    this.setSizeProp("width", this.width, this.minWidth, inMaxWidth);
	},
	*/
	setMaxHeight: function(inMaxHeight) {
	    inMaxHeight = parseInt(inMaxHeight) || 0;
	    this.maxHeight = inMaxHeight;
            if (inMaxHeight > this.bounds.h)
                this.reflowParent();
	},


	getDomHeight: function() {
	    return dojo.coords(this.domNode,false).h;
	},

	// Returns integer value in pixels
	getDomWidth: function() {
	    return dojo.coords(this.domNode,false).w;
	},

    /* This should work, but risks the UI being rather jumpy, so best to provide custom method for each widget where possible */
        doAutoSize: function(setSize, force) {
            if (this._doingAutoSize || !this.autoSizeHeight && !this.autoSizeWidth) return;
	    if (!force && !this._needsAutoSize) return;

	    if (this.isAncestorHidden()) {
		return;
	    }


            this._doingAutoSize = true;
	    this._needsAutoSize = false;

            if (this.autoSizeWidth) {
                this.domNode.style.width = "";
                var neww = dojo.coords(this.domNode).w;
                if (this.minWidth && this.minWidth > neww) neww = this.minWidth;
                if (setSize) {
                    this.setWidth(neww + "px");
                } else {
                    this.bounds.w = neww;
                    this.domNode.style.width = neww + "px";
                }
            } 

            if (this.autoSizeHeight) {
                this.domNode.style.height = "";
                var newh = dojo.coords(this.domNode).h;
                if (this.minHeight && this.minHeight > neww) newh = this.minHeight;
                if (setSize) {
                    this.setHeight(newh + "px");
                } else {
                    this.bounds.h = newh;
                    this.domNode.style.height = newh + "px";
                }
            }
	    if (this.isDesignLoaded() && studio.designer.selected == this)
		setTimeout(dojo.hitch(studio.inspector, "reinspect"), 100); 		
            this._doingAutoSize = false;
	},

	setAutoSizeWidth: function(inAutoSize) {
	    this.autoSizeWidth = inAutoSize;
	    if (this.autoSizeWidth) {
                if (this._percEx.w) {
                    this.width = this.bounds.w + "px";
                    this._percEx.w = 0;
                }
		this.doAutoSize(1,1);
            }
	},
	setAutoSizeHeight: function(inAutoSize) {
	    this.autoSizeHeight = inAutoSize;
	    if (this.autoSizeHeight) {
                if (this._percEx.h) {
                    this.height = this.bounds.h + "px";
                    this._percEx.h = 0;
                }
		this.doAutoSize(1,1);
            }
	},

	// If its chrome, overflow needs to be turned off, then on again for autoScrolling to be enabled but for the scrollbars to be hidden.
	// Insure that only one onidle is queued per node.
	disruptChromeOverflow: function(propName) {
		if (dojo.isChrome) {
			if (!this[propName] || !this[propName].style) 
				return;
			if (this["_disruptChromeOverflowPending_" + propName]) 
				return;
			this["_disruptChromeOverflowPending_" + propName] = true;
			this[propName].style.overflow = "none";
				wm.onidle(this, function() {
					this[propName].style.overflow = "auto";
					this["_disruptChromeOverflowPending_" + propName] = false;
				});
		}
	},
	//===========================================================================
	// Rendering; forceRender is a way to skip the isReflowEnabled test
	//===========================================================================    
	render: function(forceRender) {
	    if (forceRender || this.isReflowEnabled()) {
		this.renderCss();
	    } else {
		this.invalidCss = true;
	    }
	    return true;
	},

	renderCss: function() {
	    if (!this.invalidCss) return;
	    this.invalidCss = false;

	    // these should be called only once per object
	    var cssObj = this.buildCssSetterObj();

	    // some browsers are faster to set via cssText... but its NOT faster to reset them via cssText using our method of appending to the css string after an initial set of values have been stored.  
	    if (!this.renderedOnce && (dojo.isFF || dojo.isSafari || dojo.isChrome)) {
		this.setCssViaCssText(cssObj);
		this.renderedOnce = 1;
	    } else {
		this.setCssViaDom(cssObj);
	    }

	    // handles special case where a call to render bounds neesd to call render which calls renderCss which should NOT
  	    // then call renderBounds again.
	    if (!this.noRenderBounds)
		    this.renderBounds();
	},
        buildCssSetterObj: function() {
		var marginSplitter = this.getCssSplitter(this.margin);
		var paddingSplitter = this.getCssSplitter(this.padding);
		var borderSplitter = this.getCssSplitter(this.border);

		if (this.margin.indexOf(",") == -1 && this.margin.indexOf(" ") != -1)
		{
			marginSplitter = " ";
		}

		var paddArr = this.padding.split(paddingSplitter);

	    if (this.designBorderState) {
		return {
		margin:  (this.margin.split(marginSplitter).join("px ") || 0) + "px",
		padding: (paddArr.join("px ") || 0) + "px",
		borderLeftStyle: (this.designBorderState && this.designBorderState.l) ? "dashed" : "solid",
		borderRightStyle: (this.designBorderState && this.designBorderState.r) ? "dashed" : "solid",
		borderTopStyle: (this.designBorderState && this.designBorderState.t) ? "dashed" :  "solid",
		borderBottomStyle: (this.designBorderState && this.designBorderState.b) ? "dashed" : "solid" ,
		borderLeftColor: (this.designBorderState && this.designBorderState.l) ? "#C1C1C1" : this.borderColor,
		borderRightColor: (this.designBorderState && this.designBorderState.r) ? "#C1C1C1" : this.borderColor,
		borderTopColor: (this.designBorderState && this.designBorderState.t) ? "#C1C1C1" :  this.borderColor,
		borderBottomColor: (this.designBorderState && this.designBorderState.b) ? "#C1C1C1" : this.borderColor,
		borderLeftWidth:  ((this.designBorderState && this.designBorderState.l) ? "1" : this.borderExtents.l) + "px",
		borderRightWidth:  ((this.designBorderState && this.designBorderState.r) ? "1" : this.borderExtents.r) + "px",
		borderTopWidth: ((this.designBorderState && this.designBorderState.t) ? "1" : this.borderExtents.t) + "px",
		borderBottomWidth: ((this.designBorderState && this.designBorderState.b) ? "1" : this.borderExtents.b) + "px",
		backgroundColor: this.backgroundColor,
		overflow:  (this.autoScroll || this._xscrollX || this._xscrollY ? "auto" : "hidden"),
		overflowX: (this.scrollX ? "scroll" : "hidden"),
		overflowY: (this.scrollY ? "scroll" : "hidden")};

	    } else {
	    return {
		margin:  (this.margin.split(marginSplitter).join("px ") || 0) + "px",
		padding: (paddArr.join("px ") || 0) + "px",
		borderStyle:  "solid",
		borderWidth:  (this.border.split(borderSplitter).join("px ") || 0) + "px",
		borderColor:  this.borderColor,
		backgroundColor: this.backgroundColor,
		overflow:  (this.autoScroll || this._xscrollX || this._xscrollY ? "auto" : "hidden"),
		overflowX: (this.scrollX ? "scroll" : "hidden"),
		overflowY: (this.scrollY ? "scroll" : "hidden")};
	    }
	},
	setCssViaCssText: function(cssObj) {
	    if (!this.domNode) return;
	    // why is it +=?  So that position: absolute isn't blown away; so that any custom widget styles aren't blown away.
	    // How efficient is resetting cssText (cssText is "border:5", how efficient is cssText += ";border:10" handled?)
	    if (this.designBorderState) {
	    this.domNode.style.cssText += 
		"margin:" + cssObj.margin + ";"  
	  	    + "padding:" + cssObj.padding + ";"
		    + "border-top:" + cssObj.borderTopStyle + " " + cssObj.borderTopWidth + " " + cssObj.borderTopColor + ";"
		    + "border-bottom:" + cssObj.borderBottomStyle + " " + cssObj.borderBottomWidth + " " + cssObj.borderBottomColor + ";"
		    + "border-right:" + cssObj.borderRightStyle + " " + cssObj.borderRightWidth + " " + cssObj.borderRightColor + ";"
		    + "border-left:" + cssObj.borderLeftStyle + " " + cssObj.borderLeftWidth + " " + cssObj.borderLeftColor + ";"

		+ (cssObj.backgroundColor ? "background-color:" + cssObj.backgroundColor + ";" : "")
		    //+ "overflow:" + (this.autoScroll ? "auto" : "hidden") + ";"
		    // Frankies one line change for scrolling
		//+ "overflow:" + cssObj.overflow +";" 
		+ "overflow-x:" + ((cssObj.overflow != "auto") ? cssObj.overflowX : cssObj.overflow) + ";"
		+ "overflow-y:" + ((cssObj.overflow != "auto") ? cssObj.overflowY : cssObj.overflow) + ";"
		;

	    } else {
	    this.domNode.style.cssText += 
		     "margin:" + cssObj.margin + ";"  
	  	    + "padding:" + cssObj.padding + ";"
		    + "border-style:" + cssObj.borderStyle + ";" 
		    + "border-width:" + cssObj.borderWidth + ";"
		    + "border-color:" + cssObj.borderColor + ";"
		    + (cssObj.backgroundColor ? "background-color:" + cssObj.backgroundColor + ";" : "")
		    //+ "overflow:" + (this.autoScroll ? "auto" : "hidden") + ";"
		    // Frankies one line change for scrolling
		//+ "overflow:" + cssObj.overflow +";" 
		    + "overflow-x:" + ((cssObj.overflow != "auto") ? cssObj.overflowX : cssObj.overflow) + ";"
		    + "overflow-y:" + ((cssObj.overflow != "auto") ? cssObj.overflowY : cssObj.overflow) + ";"
		;

	    }

	},
	setCssViaDom: function(cssObj) {
	    if (!this.domNode) return;
	    var s = this.domNode.style;
	    try {
			if (s.margin != cssObj.margin && !(s.margin == '' && cssObj.margin == '0px'))	
				s.margin    = cssObj.margin;
			if (s.padding != cssObj.padding)	
				s.padding   = cssObj.padding;		       
		        if (!this.designBorderState) {
			    if (s.borderStyle != cssObj.borderStyle)	
				s.borderStyle    = cssObj.borderStyle;
			    if (s.borderWidth != cssObj.borderWidth)	
				s.borderWidth = cssObj.borderWidth;
			    if (s.borderColor != cssObj.borderColor)	
				s.borderColor = cssObj.borderColor;

			} else {
			    s.borderLeft = cssObj.borderLeftStyle + " " + cssObj.borderLeftWidth + " " + cssObj.borderLeftColor;
			    s.borderRight = cssObj.borderRightStyle + " " + cssObj.borderRightWidth + " " + cssObj.borderRightColor;
			    s.borderTop = cssObj.borderTopStyle + " " + cssObj.borderTopWidth + " " + cssObj.borderTopColor;
			    s.borderBottom = cssObj.borderBottomStyle + " " + cssObj.borderBottomWidth + " " + cssObj.borderBottomColor;

			}
			if (cssObj.backgroundColor)
			        s.backgroundColor = cssObj.backgroundColor;
			var o =  (cssObj.overflow != "auto") ? cssObj.overflowX : cssObj.overflow;
			if (s.overflowX != o)
				s.overflowX = o;
			o = (cssObj.overflow != "auto") ? cssObj.overflowY : cssObj.overflow;
			if (s.overflowY != o)
				s.overflowY= o;
	    } catch(e) {
			console.error("Invalid style specified for " + this.name + ": " + e);
	    }
	},
	getCssSplitter: function (value) {
		var splitter = ",";
	        value = dojo.string.trim(value);
		if (value.indexOf(",") == -1 && value.indexOf(" ") != -1)
		{
			splitter = " ";
		}
		
		return splitter;
	},
	renderBounds: function() {
		if (this.dom)
			this.dom.setBox(this.getStyleBounds(), this.singleLine);
		// bc
		if (this.designWrapper) {
			this.designWrapper.controlBoundsChange();
			this.designWrapper.renderBounds();			
		}
	},
	//===========================================================================
	// Flow
	//===========================================================================
	// FIXME: controversial update implementation cribbed from Layers.js
	/*
	beginUpdate: function() {
		this.domNode._reflowing = true;
	},
	endUpdate: function() {
		this.domNode._reflowing = false;
	},
	*/
	reflow: function() {
		//wm.fire(this.domNode, "reflow");
	},
	reflowParent: function() {
		wm.fire(this.parent, "reflow");
		//wm.fire(this.domNode.parentNode, "reflow");
	},
	setScrollX: function(inScrollX) {
		this.scrollX = inScrollX;
	        this.invalidCss = true;
	        this.render();
		this.reflowParent();
	},
	setScrollY: function(inScrollY) {
		this.scrollY = inScrollY;
	        this.invalidCss = true;
	        this.render();
		this.reflowParent();
	},
	setAutoScroll: function(inAutoScroll) {
		this.autoScroll = inAutoScroll;
	        if (inAutoScroll) {
		    if (this.isDesignLoaded() && (this.scrollX || this.scrollY)) {
			this.scrollX = false;
			this.scrollY = false;
                        if (studio.designer.selected == this)
			    studio.inspector.reinspect();
		    }
		}

	        // Update the css without also updating the bounds (TODO: make this mechanism less cumbersome)
		this.noRenderBounds=true;
		this.invalidCss = true;
		this.renderCss();
		delete this.noRenderBounds;
	},
	//===========================================================================
	// Groups
	//===========================================================================
	groupHandler: function(inMessage, inArgument) {
		switch(inMessage){
			case "disabled":
				this.setDisabled(inDisabled);
				break;
		}
	},
	//===========================================================================
	// Convenience
	//===========================================================================
	/**
		Set <a href="#showing">showing</a> property true.
	*/
	show: function() {
		this.setValue("showing", true);
	},
	/**
		Set <a href="#showing">showing</a> property false.
	*/
	hide: function() {
		this.setValue("showing", false);
	},
	/**
		Set <a href="#disabled">disabled</a> property true.
	*/
	disable: function() {
		this.setValue("disabled", true);
	},
	/**
		Set <a href="#disabled">disabled</a> property false.
	*/
	enable: function() {
		this.setValue("disabled", false);
	},
	toString: function() {
	    return '[' + this.declaredClass + ((this.name) ? ':' + this.name : "") + ((!this.showing) ? "(hidden)" : "") + ']';
	},
	//===========================================================================
	// Setters
	//===========================================================================
	setParent: function(inParent) {
		var oldParent = this.parent;
		var newParent = this.parent = inParent;

	    // Tricky new addition: if the parent has a containerWidget AND the parent OWNS that containerWidget, then switch parents!
	    if (inParent && inParent.containerWidget && inParent.containerWidget.owner == inParent)
		newParent = this.parent = inParent.containerWidget;

		// If the new parent is not the same as the old parent, remove the widget from the old parent
		// and remove the control from the old parent (Note: lookup difference between widget and control)
		if (oldParent && oldParent != newParent) {
			oldParent.removeWidget(this);
			// BC: we still have non-container parents (e.g. wm.Dialog)
			if (oldParent.removeControl)
				oldParent.removeControl(this);
		}

		if (!this._cupdating)
		{
			this.appendDOMNode(newParent);
		}
		
		// If there is a new parent, add this component to its widgets and controls		
		/*
		if (newParent) {
		        newParent.addWidget(this);
			// BC: we still have non-container parents (e.g. wm.Dialog)
			if (newParent.addControl)
				newParent.addControl(this);
		}
		// BC: wm.Layout
		else if (this.parentNode && this.domNode) {
			this.parentNode.appendChild(this.domNode);
		}
		 */
		if (newParent && oldParent)
			dojo.publish("wmwidget-parentChange", [oldParent, newParent, this]);
	},
	appendDOMNode: function(inParent){
		var newParent = inParent;
		if (newParent) {
		        newParent.addWidget(this);
			// BC: we still have non-container parents (e.g. wm.Dialog)
			if (newParent.addControl)
				newParent.addControl(this);
		}
		// BC: wm.Layout
		else if (this.parentNode && this.domNode) {
			this.parentNode.appendChild(this.domNode);
		}
	},
	canChangeShowing: function() {
		return true;
	},
	setShowing: function(inShowing,forceChange) {
		if (!this.canChangeShowing())
			return;
		if (forceChange || this.showing != inShowing) {
			this.showing = inShowing;
			this.domNode.style.display = inShowing ? '' : 'none';
		        this.reflowParent();
		}
	},
	/**
		Set disabled property for this widget.<br/>
		<br/>
		Some widgets change behavior or display based on the disabled state.<br>
		@param {Boolean} inDisabled True to set disabled.
	*/
	setDisabled: function(inDisabled) {
		for (var i in this.widgets) {
			this.widgets[i].setDisabled(inDisabled);
		}
		this.disabled = inDisabled;
	},
	setGroup: function(inGroup) {
		this.group = inGroup;
		dojo.unsubscribe(this._subscription);
		if (this.group)
			this._subscription = dojo.subscribe(this.group, this, "groupHandler");
	},
	setBackgroundColor: function(inColor) {
		this.backgroundColor = inColor;
		this.invalidCss = true;
		this.render();
	},
	setBorderColor: function(inColor) {
		this.borderColor = inColor;
	        this.invalidCss = true;
		this.render();
	},
	//===========================================================================
	// Default and User Style Classes
	//===========================================================================
	addRemoveDefaultCssClass: function(inAdd) {
		if (this.owner)
			dojo[inAdd ? "addClass" : "removeClass"](this.domNode, this.owner.declaredClass + '-' + this.name);
	},
	getUserNodeClasses: function(inNodeName) {
		var klasses = this._classes;
		for (var i in klasses) {
			if (inNodeName == i)
				return klasses[i].join(' ');
		}
		return "";
	},
	initUserClasses: function() {
		// bc
		if (dojo.isArray(this._classes))
			this._classes = {domNode: this._classes};
		var klasses = this._classes;
		for (var i in klasses)
			this.initUserNodeClasses(klasses[i], i);
	},
	initUserNodeClasses: function(inClasses, inNodeName) {
		var k = inClasses || [], n = this[inNodeName];
		if (n)
			// add classes together for speed; we don't care about checking if the class is already on the node
			dojo.addClass(n, k.join(' '));
	},
	/**
		Add CSS class to a widget node.<br/>
		@param {String} inClass The class to add.
		@param {String} inNodeName (Optional) a property in this widget that references a node. 
		If ommitted, the default node is used.
		@example this.panel.addUserClass("hilite-border");
	*/
	addUserClass: function(inClass, inNodeName) {
		inNodeName = inNodeName || "domNode";
		var cs = this._classes[inNodeName] = this._classes[inNodeName] || [];
		cs.push(inClass);
		var n = this[inNodeName];
		if (n)
			dojo.addClass(n, inClass);
	},
	/**
		Remove a CSS class from a widget node.<br/>
		@param {String} inClass The class to remove.
		@param {String} inNodeName (Optional) a property in this widget that references a node. 
		If ommitted, the default node is used.
		@example this.panel.removeUserClass("hilite-border"); 
	*/
	removeUserClass: function(inClass, inNodeName) {
		inNodeName = inNodeName || "domNode";
		var n = this[inNodeName];
		if (n)
			dojo.removeClass(n, inClass);
		var cs = this._classes[inNodeName] || [];
		for (var i=0, c; c=cs[i]; i++) 
			if (c == inClass)
				cs.splice(i--, 1);
		if (!cs.length)
			delete this._classes[inNodeName];
	},
	getOrderedWidgets: function() {
		return [];
	},
	updatingEvent: function (prop, inValue){
	}
});

// layout specific

/*
wm.Control.extend({
	//fluidSize: 0,
	//alignInParent: "justified",
	//setFluidSize: function(inFluidSize) {
	//	this.fluidSize = inFluidSize;
	//	this.reflowParent();
	//}
});

wm.Object.extendSchema(wm.Control, {
	//fluidSize: {group: "layout"},
});
*/

wm.Widget = wm.Control;

}

if(!dojo._hasResource["wm.base.Plugin"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["wm.base.Plugin"] = true;
/*
 *  Copyright (C) 2008-2010 WaveMaker Software, Inc.
 *
 *  This file is part of the WaveMaker Client Runtime.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
dojo.provide("wm.base.Plugin");

wm.Plugin = {
	targetClass: null,
	callerFactory: function(inOverrides) {
		return function(inArgs, inNewArgs) {
			var fn = inOverrides[inArgs.callee.nom];
			if (fn)
				return fn.apply(this, inNewArgs || inArgs || []);
		}
	},
	plugin: function(inName, inClass, inProps) {
		var overrides = [];
		for (var p in inProps) {
			if (dojo.isFunction(inProps[p]) && inClass.prototype[p])
				overrides[p] = inClass.prototype[p];
		}
		inProps[inName + 'Socket'] = this.callerFactory(overrides);
		inClass.extend(inProps);
	}
}

}

if(!dojo._hasResource["wm.base.widget.Container"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["wm.base.widget.Container"] = true;
/*
 *  Copyright (C) 2009-2010 WaveMaker Software, Inc.
 *
 *  This file is part of the WaveMaker Client Runtime.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
dojo.provide("wm.base.widget.Container");

/**
	Base class for widget containers.
	@name wm.Container
	@class
	@extends wm.Control
*/
wm.define("wm.Container", wm.Control, {
	/** @lends wm.Container.prototype */
	published: {
		invalid: { ignore: 1, bindSource: 1, readonly: 1, type: "Boolean" },
		lock: { order: 0 },
		freeze: { order: 5 },
		box: { ignore: 1 },
		boxPosition: { ignore: 1},
		disabled: { ignore: 1 },
	        autoScroll: {group: "scrolling", order: 100, ignore: 0}
	},
	imageList: "",
	border: 0,
	container: true,
	lock: false,
	freeze: false,
	classNames: "wmcontainer",
	autoScroll: false,
        isMajorContent: false,
    //themeStyleType: "",        // A funky parameter that won't ever show up in widgets.js; instead it adds/removes classes (more of a style's inspector kind of property, but one that identifies the type of content and leaves it to the theme to decide how to render it)
        fitToContentWidth: false,  // Container automatically resizes itself to match the width of its content, or minWidth if % sized content
        fitToContentHeight: false, // Container automatically resizes itself to match the height of its content, or minHeight if % sized content      
        fitToContent: false,       // shortcut for (fitToContentWidth || fitToContentHeight)
        _needsFitToContent: false, // Init time flag that signals that this fitToContent container has not yet been fit to its content

	constructor: function() {
		this.c$ = [];
	},
	init: function() {
	    this.inherited(arguments);
	    this.setLayoutKind(this.layoutKind);
	    this.domNode.box = this.box = "";
	    this._needsFitToContent = this.fitToContent = this.fitToContentWidth || this.fitToContentHeight;
	},
	postInit: function() {
		if (this.isDesignLoaded())
			this.setLock(this.lock);
		this.inherited(arguments);
/*
	    if (this.isMajorContent)  // obsolete property
                this.setThemeStyleType("ContentPanel");
            else if (this.themeStyleType)
                this.setThemeStyleType(this.themeStyleType);
                */
	},
        setThemeStyleType: function(inType) {
	    var oldType = this.getThemeStyleType();
	    if (oldType)
		this.removeUserClass(oldType);
	    this.addUserClass(inType);
	},
        getThemeStyleType: function() {
	    var types = ["MainContent", "EmphasizedContent", "HeaderContent"];
	    if (this._classes && this._classes.domNode)
		for (var i = 0; i < types.length; i++) {
		    if (dojo.indexOf(this._classes.domNode, types[i]) != -1) return types[i];
		}
	},
	destroy: function()
	{
		if (this.domNode && this.domNode.box)
			delete this.domNode.box;
		this.inherited(arguments);
	},
	// backward-compatibility fixups
	afterPaletteDrop: function() {
		if (this.verticalAlign == "justified")
			this.verticalAlign = "top";
		if (this.horizontalAlign == "justified")
			this.horizontalAlign = "left";
	},
	bc: function() {
		this.inherited(arguments);
		/*
		if (this.verticalAlign == "justified") {
			this.verticalAlign = "top";
		}
		if (this.horizontalAlign == "justified") {
			this.horizontalAlign = "left";
		}
		*/
		delete this.layoutJustify;
		if (this.layoutAlign) {
			this.contentAlign = this.layoutAlign;
			delete this.layoutAlign;
		}
	    
	        /* this.layoutFit I believe is an obsolete wm 4.x property */
		if (this.layoutFit) {
			this.fitToContentWidth = this.fitToContentHeight = this.layoutFit;
			delete this.layoutFit;
		}
		if (this.box == "h") {
			this.layoutKind = "left-to-right";
			//this.layout = wm.Container.vBox;
		}
		if (this.boxPosition) {
			var
				boxPositions = ['topLeft', 'center', 'bottomRight'],
				vAligns = ["top", "middle", "bottom"],
				hAligns = ["left", "center", "right"],
				h = this.layoutKind == "left-to-right",
				i = dojo.indexOf(boxPositions, this.boxPosition);
			if (i != -1) {
				if (h)
					this.horizontalAlign = hAligns[i];
				else
					this.verticalAlign = vAligns[i];
			}
		}
	},
	//
	// Child Controls
	//
	addWidget: function(inWidget){
		this.inherited(arguments);

			if (this.box == 'h' && !inWidget.width)
				inWidget.setProp("width", "64px");
			else if (this.box == 'v' && !inWidget.height)
				inWidget.setProp("height", "64px");
			//inWidget.setSize(inWidget.size);
	},
	getOrderedWidgets: function() {
		return this.c$;
	},
	addControl: function(inControl) {
		this.c$.push(inControl);
		//this.dom.append(inControl.dom);
	},
	removeControl: function(inControl) {
		//this.dom.remove(inControl.dom);
		for (var i=0, c; c=this.c$[i]; i++){
			if (c == inControl) {
				this.c$.splice(i, 1);
				return i;
			}
		}
	},
        // Added by michael k 5/15/09 to support the PopupHelp dialog
	removeAllControls: function() {
		    while (this.c$.length) {
			  var c = this.c$[0];
			  this.removeControl(c);
			  c.destroy();
		    }
			  /*
	      while (this.c$.length) this.removeControl(this.c$[0]);
	      for (var n in this.widgets)
		    this.removeWidget(this.widgets[n]);
	      while (this.domNode.firstChild) this.domNode.removeChild(this.domNode.firstChild);
			  */
	      this.reflow();
	},
	insertControl: function(inControl, inIndex) {
		this.c$.splice(inIndex, 0, inControl);
		//this.dom.append(inControl.dom);
	},
	moveControl: function(inControl, inIndex) {
		var i0 = this.removeControl(inControl);
		if (i0 < inIndex)
			inIndex--;
		this.c$.splice(inIndex, 0, inControl);
	},
	indexOfControl: function(inControl) {
		for (var i=0, c; c=this.c$[i]; i++){
			if (c == inControl) {
				return i;
			}
		}
		return -1;
	},
	nextSibling: function(inControl) {
		for (var i=0, c; c=this.c$[i]; i++){
			if (c == inControl) {
				return this.c$[i+1];
			}
		}
	},
	prevSibling: function(inControl) {
		for (var i=0, c; c=this.c$[i]; i++){
			if (c == inControl) {
				return this.c$[i-1];
			}
		}
	},
	setAutoScroll: function(inAutoScroll) {
		this._xscrollX = false;
		this._xscrollY = false;
		this.inherited(arguments);
		this.reflow();
	},


        adjustSetSizeProp: function(n,v) {
	    if (n == "height" && this.fitToContentHeight && this.getPreferredFitToContentHeight)
		return this.getPreferredFitToContentHeight() + "px";
	    if (n == "width" && this.fitToContentWidth && this.getPreferredFitToContentWidth) 
		return this.getPreferredFitToContentWidth() + "px";
	    return v;
	},
	//
	// Flow
	//
	reflow: function() {
	    this._boundsDirty = true;
	    if (!this.isReflowEnabled()) 
		return;
	    /* If this widget is fitToContent, then we'll need to update this container's width/height to fit its contents; and that means the parent will need to reflow.
	     * If the parent is fitToContent, (TODO: Is this still needed?) then any we'll need to call this.parent.reflow() which will cause the parent to flow its children, 
	     * (of which this container is one), and the children to flow their children of which this is one. 
	     *  After this is done, this too will call calcFitToContent.  
	     */
		if (this.parent && (this.fitToContent || this.parent.fitToContent)) {
			if (this._needsFitToContent) delete this._needsFitToContent;
			this.parent.reflow();
                    /*
			if (this.fitToContent) {
				this.calcFitToContent();
			}
                        */
		} else {
			this.flow();
		}
	},
	flow: function() {
	       if (this._boundsDirty && this.isReflowEnabled()) {
			// call flow; if autoScroll is enabled, then this call to flow is just to test if scrollbars are needed.	
			// If autoScroll is enabled, we'll need to call flow again, 
                   /* all autoscroll calculations moved to Box.js
			if (this.autoScroll) {
			    // This call sets _xscrollX/_xscrollY and returns without doing a real traversal.
			    // Setting these values means when we do the real call to flow we will get an adjusted return value when we call getContentBounds()
			    this.layout.flow(this,true);  
			} 
                        */

			this.layout.flow(this,false);
		}
		//else (!this._boundsDirty)
		//	console.log(this.name, ": not flowing (clean bounds)");
	},
	renderControls: function() {
	    // code to insure that a container's scrollbars are updated when a child is resized... 
	    // this means that autoscroll has a slower rendering execution than non-autoscroll
	    //if (this.autoScroll && this._xneedReflow || this.fitToContent) this.renderBounds();
	    for (var i=0, c; c=this.c$[i]; i++) {
		c.renderBounds();
	    }
	},
        forEachControl: function(inFunc, paramArray) {
	  dojo.forEach(this.c$, function(inControl) {
	    inFunc.apply(inControl, (paramArray) ? paramArray : []);
	    });
	},
	// bc
	nodeBoundsChange: function() {
		// should be caused by box layout flow
		/*
		this.setBounds(dojo.marginBox(this.domNode));
		this.flow();
		*/
	},
	//
	// Image list
	//
	imageListChanged: function() {
		for (var i=0, c; c=this.c$[i]; i++) {
			wm.fire(c, "imageListChanged");
		}
	},
	setImageList: function(inImageList) {
		this.imageList = inImageList;
		this.imageListChanged();
	},
	//
	// validation
	//
	validate: function() {
		this.setValue("invalid", this.getInvalid());
		wm.fire(this.parent, "validate");
	},
	getInvalid: function() {
	    for (var i in this.widgets) {
		var w = this.widgets[i];
		if (w.invalid)
		    return true;
                else if (w.invalid === undefined && w.getInvalid && w.getInvalid())
                    return true;
	    }

	    if (dojo.isFunction(this.customGetValidate))
		return !this.customGetValidate();
	    return false;
	},
        customGetValidate: function() {
	    return true;
        },
	getInvalidWidget: function() {
	    for (var i in this.widgets) {
		var w = this.widgets[i];
		if (wm.isInstanceType(w,wm.Editor) ||
		    wm.isInstanceType(w,wm.AbstractEditor)) {
		    if (w.getInvalid()) return w;
		} else if (wm.isInstanceType(w,wm.Container)) {
		    var tmp = w.getInvalidWidget();
		    if (tmp) return tmp;
		}
	    }
	    return null;
	},

	//
	// Lock/freeze
	//
	getLock: function() {
		return this.lock || (this.parent && wm.fire(this.parent, "getLock"));
	},
	setLock: function(inLock) {
	        var original = this.lock;
		this.lock = inLock;
		if (window['studio'] && (this.lock != original || this.lock)) {
		    studio.refreshComponentOnTree(this);
		}
	},
	getFreeze: function() {
		return this.freeze || this.getLock();
	},
	// FIXME: design only? vestigal?
	/*
	findContainer: function(inType) {
		if (!this.lock) {
			if (this.freeze || !this.isWidgetTypeAllowed(inType)) {
				for (var i in this.widgets) {
					var w = this.widgets[i];
					if (w.container) {
						var r = w.findContainer(inType);
						if (r)
							return r;
					}
				}
			} else {
				return this;
			}
		}
	},
	*/
	// used by paste
	isWidgetTypeAllowed: function(inType) {
		// subclasses should override this to enforce only certain widget types
		// are allowed to be added to the container.
		return true;
	},
	/*
	setBox: function(inBox) {
		if (this.box != inBox) {
			this.box = (this.containerNode || this.domNode).box = inBox;
			// FIXME: wtf?
			//if (this.isSizeable() || !this.isMoveable())
				this._reorientChildren(this.box);
			this.reflow();
		}
	},
	*/
	/*
	_reorientChildren: function(inBox) {
		var b = inBox, bp = wm.Box.prototype, bw = bp.width, bh = bp.height;
		var parentNode = this.containerNode || this.domNode;
		wm.forEachProperty(this.widgets, function(w) {
			if (w.domNode.parentNode != parentNode)
				return;
			var s = w.domNode.style, f = (b == 'flow' || b == '');
			if (f) {
				s.position = 'static';
				w.left = w.top = '';
				w.updateBounds();
			} else
				s.position = 'absolute';
			w.moveable = !f;
			if (b == 'h' || b == 'v') {
				w.width = bw; 
				w.height = bh;
				w.updateBounds();
			}
		});
	},*/
	_reorientChildren: function(inBox) {
		var parentNode = this.containerNode || this.domNode;
		wm.forEachProperty(this.widgets, function(w) {
			if (w.domNode.parentNode != parentNode)
				return;
			var ww = w.width;
			w.width = w.height;
			w.height = ww;
			w.updateBounds();
		});
	},
	clearData: function() {
		var clear = function(w) {
			if (w instanceof wm.Editor)
				w.clear();
		}

		wm.forEachWidget(this,clear);
	},
    /* What is the maximum width that this container can achieve given its parents and assuming we aren't planning on using scrollbars? 
     * The answer is a function of the parent's getCurrentMaxWidth and the sizes of this container's siblings.
     */
	getCurrentMaxWidth: function() {
		// If no parent, or if the parent doesn't have the getCurrentMaxWidth method, then there is nothing to look up, just
		// return the available width within this container
		if (!this.parent || !this.parent.getCurrentMaxWidth)
			return this.bounds.w - this.padBorderMargin.l - this.padBorderMargin.r;

		// Else if we are fitToContent, then we need to get the parent's current max width, as that is how far our fitToContent container can extend
		else if (this.fitToContent)
			return this.parent.getCurrentMaxWidth();

		// If we are NOT fitToContent, but we are % sized in a top-to-bottom layout, then our max width is the width of the parent
		else if (this._percEx.w && this.layoutKind == "top-to-bottom")
			return this.parent.getCurrentMaxWidth();

		// If we are NOT fitToContent but we are % sized in a left-to-right layout, then calc how much free space there is in the parent
		// return free space minus the width of this object to get the full space available for this container to grow
		else if (this._percEx.w && this.layoutKind == "top-to-bottom") {
			var maxWidth = this.parent.layout.getMaxFreeSpace(this.parent.c$, "w",this.parent.bounds.w - this.parent.padBorderMargin.l - this.parent.padBorderMargin.r);
			return maxWidth + this.bounds.w;
		}
		// Else we must be px sized, so just return our width
		else
			return this.bounds.w - this.padBorderMargin.l - this.padBorderMargin.r;
	},

    /* What is the maximum height that this container can achieve given its parents and assuming we aren't planning on using scrollbars? 
     * The answer is a function of the parent's getCurrentMaxHeight and the sizes of this container's siblings.
     */
	getCurrentMaxHeight: function() {
		if (!this.parent || !this.parent.getCurrentMaxHeight)
			return this.bounds.h - this.padBorderMargin.t - this.padBorderMargin.b;

		else if (this.fitToContent)
			return this.parent.getCurrentMaxHeight();

		else if (this._percEx.h && this.layoutKind == "left-to-right")
			return this.parent.getCurrentMaxHeight();
		else if (this._percEx.h && this.layoutKind == "top-to-bottom") {
			var maxHeight = this.parent.layout.getMaxFreeSpace(this.parent.c$, "h",this.parent.bounds.h - this.parent.padBorderMargin.t - this.parent.padBorderMargin.b);
			return maxHeight + this.bounds.h;
		}
		else
			return this.bounds.h - this.padBorderMargin.t - this.padBorderMargin.b;
	}
});

// Design

wm.Container.extend({
	listProperties: function() {
		var p = this.inherited(arguments);
		p.freeze.ignore = this.schema.freeze.ignore || this.getLock();
		return p;
	},
	writeChildren: function(inNode, inIndent, inOptions) {
		var s = [];
		wm.forEach(this.getOrderedWidgets(), function(c) {
			if (wm.isDesignable(c) && !c.flags.notStreamable)
				s.push(c.write(inIndent, inOptions));
		});
		return s;
	},
	suggestDropRect: function(inControl, ioInfo) {
		this.layout.suggest(this, inControl, ioInfo);
	},
	suggestSize: function(inControl, ioInfo) {
		this.layout.suggestSize(this, inControl, ioInfo);
	},
	designMoveControl: function(inControl, inDropInfo) {
		info = {l:inDropInfo.l, t:inDropInfo.t, i: inDropInfo.i};
		if (inControl.parent == this) {
			// inDropInfo.index 'i' may be counting inControl
			this.moveControl(inControl, info.i || 0);
		} else {
			var p = inControl.parent;
			inControl.setParent(this);
			inControl.designWrapper.controlParentChanged();
			// inDropInfo.index 'i' is never counting inControl
			this.removeControl(inControl);
			this.insertControl(inControl, info.i || 0);
			if (p)
				p.reflow();
		}
		if (this.layout.insert) {
			this.layout.insert(this, inControl, inDropInfo);
			//return;
		}
		this.reflow();
	},
	resizeUpdate: function(inBounds) {
		// update the boundary rectangle highlight only
		this.designWrapper._setBounds(inBounds);
	},

    /* Get the preferred width of this container, for use if this is a fitToContentWidth container.
     * left-to-right container: width is the sum of the widths of all px sized children and the sum of all minWidths for % sized children.
     * top-to-bottom container: width is the max of the widths of all px sized children and the minWidths for % sized children
     */
	getPreferredFitToContentWidth: function() {
		// get the maximum width in this column; 
		// and get the sum of widths in this row... we'll worry later about whether its a row or column
                var extra = this.padBorderMargin.r + this.padBorderMargin.l;	
	        var max = 0;
	        var sum = 0;
		var v;
		for (var i=0, c; c=this.c$[i]; i++) {
			if (this.layout.inFlow(c)) {
				if (c.fitToContentWidth) {
					v =  c.getPreferredFitToContentWidth();
				} else if (!c._percEx.w) {
					v =  c.bounds.w;
				} else {
					v = c.minWidth || c.getMinWidthProp();
				}
				max = Math.max(max, v);
				sum += v;				
			}
		}

                // Never return less than 30px wide; mostly this is for design mode where users still need to be able to find and drop widgets into the container.
	        var result = ((this.layoutKind == "top-to-bottom") ? max : sum) + extra;
	    return Math.max(result, wm.Control.prototype.getMinWidthProp.call(this));
	},

    /* Get the preferred height of this container, for use if this is a fitToContentHeight container.
     * top-to-bottom container: height is the sum of the heights of all px sized children and the sum of all minHeights for % sized children.
     * left-to-right container: height is the max of the heights of all px sized children and the minHeights for % sized children
     */
	getPreferredFitToContentHeight: function() {
		// get the maximum width in this column; 
		// and get the sum of height in this row... we'll worry later about whether its a row or column
            var extra = this.padBorderMargin.t + this.padBorderMargin.b;	
	    var max = 0;
	    var sum = 0;
		var v;
		for (var i=0, c; c=this.c$[i]; i++) {
			if (this.layout.inFlow(c)) {
				 if (c.fitToContentHeight) {
					v = c.getPreferredFitToContentHeight();
				} else if (!c._percEx.h) {
					v = c.bounds.h;
				} else {
					v =  c.minHeight || c.getMinHeightProp();
				}
				max = Math.max(max, v);
				sum += v;
			}
		}
            // never return less than 15px height
            var result =  ((this.layoutKind == "left-to-right") ? max : sum) + extra;
	    return Math.max(result, wm.Control.prototype.getMinHeightProp.call(this));
	},
	getMinWidthProp: function() {
            if (this.fitToContentWidth)
                return this.getPreferredFitToContentWidth();
	    else
		return this.inherited(arguments);
	},
	getMinHeightProp: function() {
            if (this.fitToContentHeight)
                return this.getPreferredFitToContentHeight();
	    else
		return this.inherited(arguments);
	},
        focusFirstEditor: function() {
	    for (var i in this.widgets) {
		var w = this.widgets[i];
		if (wm.isInstanceType(w,wm.Editor) ||
		    wm.isInstanceType(w,wm.AbstractEditor)) {
		    w.focus();
		    return w;
		} else if (wm.isInstanceType(w,wm.Container)) {
		    var tmp = w.focusFirstEditor();
		    if (tmp) return tmp;
		}
	    }
	    return null;
	},
        setIsMajorContent: function(inMajor) {
	    if (inMajor)
		this.addUserClass("wmcontentarea");
	    else
		this.removeUserClass("wmcontentarea");
	},
        getIsMajorContent: function() {
	    try {
		return dojo.indexOf(this._classes.domNode, "wmcontentarea") != -1;
	    } catch(e){}
	},
	// bc
	clearEditors: function(){
		return this.clearData();
	}
});

// this stuff is layout specific

wm.Container.extend({
	layoutKind: "top-to-bottom",
	//layoutFit: false,
	//contentAlign: "leftTop",
	horizontalAlign: "justified",
	verticalAlign: "justified",
	//horizontalAlign: "left",
	//verticalAlign: "top",
	makePropEdit: function(inName, inValue, inDefault) {
		switch (inName) {
			case "layoutKind":
				return new wm.propEdit.Select({component: this, value: inValue, name: inName, options: wm.layout.listLayouts()});
			case "horizontalAlign":
				return new wm.propEdit.Select({component: this, value: inValue, name: inName, options: ["left", "center", "right"/*, "justified"*/]});
			case "verticalAlign":
				return new wm.propEdit.Select({component: this, value: inValue, name: inName, options: ["top", "middle", "bottom"/*, "justified"*/]});
                case "themeStyleType":
		    return new wm.propEdit.Select({component: this, value: inValue, name: inName, options: ["", "MainContent", "EmphasizedContent", "HeaderContent"]});
		}
		return this.inherited(arguments);
	},
	setLayoutKind: function(inLayoutKind) {
		if (this.layoutKind != inLayoutKind || !this.layout) {
		  /*
			var ctor = wm.layout.registry[inLayoutKind];
			if (!ctor) {
				return;
			}
			this.layoutKind = inLayoutKind;
			this.layout = new ctor();
		  */
		  this.layoutKind = inLayoutKind;
		  this.layout = wm.layout.cache[inLayoutKind];
		}

	        // KANA: for the JobDesigner
		if (this.isDesignLoaded())
		    dojo.publish("LayoutKindChanged", [this]); 
		this.reflow();
	},
	setHorizontalAlign: function(inHorizAlign) {
		this.horizontalAlign = inHorizAlign;
		this.reflow();
	},
	setVerticalAlign: function(inVertAlign) {
		this.verticalAlign = inVertAlign;
		this.reflow();
	},
	setFitToContentWidth: function(inFitToContent) {
		this.fitToContentWidth = inFitToContent;
		this.fitToContent = this.fitToContentWidth || this.fitToContentHeight;
		this.updateBounds();
		this.reflowParent();
		this.calcFitToContent();
		this.reflowParent();
	},
	setFitToContentHeight: function(inFitToContent) {
		this.fitToContentHeight = inFitToContent;
		this.fitToContent = this.fitToContentWidth || this.fitToContentHeight;
		this.updateBounds();
		this.reflowParent();
		this.calcFitToContent();
		this.reflowParent();
	},
	calcFitToContent: function() {
	        if (this.fitToContentHeight) {
			this.height = this.bounds.h + "px";
                        this._percEx.h = 0;
                }
	        if (this.fitToContentWidth) {
			this.width = this.bounds.w + "px";
                        this._percEx.w = 0;
                }
	}
});

wm.Object.extendSchema(wm.Container, {
    layoutKind:         {group: "layout", order: 100},
    horizontalAlign:    {group: "layout", order: 110},
    verticalAlign:      {group: "layout", order: 120},
    fitToContent:       {ignore: true},
    fitToContentWidth:  {group: "advanced layout", order: 90, shortname: "Auto Width"},
    fitToContentHeight: {group: "advanced layout", order: 91, shortname: "Auto Height"},
    autoScroll: {group: "scrolling", order: 100, ignore: 0},
    isMajorContent: {group: "style", order: 150, ignore: 1},
    themeStyleType: {ignore: true, group: "style", order: 150}
});

}

if(!dojo._hasResource["wm.base.widget.Layers.Decorator"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["wm.base.widget.Layers.Decorator"] = true;
/*
 *  Copyright (C) 2008-2010 WaveMaker Software, Inc.
 *
 *  This file is part of the WaveMaker Client Runtime.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
dojo.provide("wm.base.widget.Layers.Decorator");

dojo.declare("wm.LayersDecorator", null, {
	decorationClass: "",
	constructor: function(inDecoree) {
		this.decoree = inDecoree;
	},
	destroy: function() {
		this.decoree = null;
	},
	decorate: function() {
		this.decorateContainer();
		this.decorateLayers();
	},
	decorateContainer: function() {
		var d = this.decoree;
		dojo.addClass(d.domNode, this.decorationClass);
	},
	decorateLayers: function() {
		dojo.forEach(this.decoree.layers, function(l, i) {
			this.decorateLayer(l, i);
		}, this);
	},
	decorateLayer: function(inLayer, inIndex) {
		inLayer.decorator = this;
	},
	undecorate: function() {
		this.undecorateContainer();
	    var layers = this.decoree.layers;
	    for (var i = layers.length-1; i >= 0; i--) {
			this.undecorateLayer(layers[i], i);
	    }
	},
	undecorateContainer: function() {
		dojo.removeClass(this.decoree.domNode, this.decorationClass);
	},
	undecorateLayer: function() {
	},
	setLayerShowing: function(inLayer, inShowing) {
		wm.Control.prototype.setShowing.call(inLayer, inShowing);
	},
	setLayerActive: function(inLayer, inActive) {
	    if (inLayer.active == inActive)
		return;

	    inLayer.inFlow = inActive;
	    inLayer.active = inActive;

	    var page = inLayer.getParentPage();
	    if (!this.decoree._cupdating && page && !page._loadingPage && !window["studio"] && this.decoree.transition && this.decoree.transition != "none") {
		console.log("SET ACTIVE LAYER FADE!");
		if (!inActive) {
		    /* FADE OUT */
		    this["anim" + wm.capitalize(this.decoree.transition)](inLayer, false);
		} else {
		    this["anim" + wm.capitalize(this.decoree.transition)](inLayer, true);
		}
	    } else {			    
		inLayer.domNode.style.display = inActive ? '' : 'none';
	    }

		// design only code: need to show / hide designwrapper
		wm.fire(inLayer, 'domNodeShowingChanged', [inActive]);
	},
        animSlide: function(inLayer, inShowing) {
	    if (inShowing) {

		// Need to render it so it will slide correctly; needs to be non-hidden (but set opacity as low as it will go so its not visible either)
		inLayer.domNode.style.opacity = "0.1"; 
		inLayer.domNode.style.display = "";
		inLayer.reflowParent();

		// ok, now move it to its starting positino and reset opacity
		var left = inLayer.bounds.w + "px";
		inLayer.domNode.style.left = (inLayer.transitionNext) ? left : "-" + left;
		inLayer.domNode.style.opacity = 1;

	    }
	    var newleft = (inShowing) ? 0 : inLayer.transitionNext ? - parseInt(inLayer.domNode.style.width) : parseInt(inLayer.domNode.style.width);
	    var anim = dojo.animateProperty({
		node: inLayer.domNode,
		properties:{
		    left: newleft
		},
		duration: 350
	    });
	    dojo.connect(anim,"onEnd", function(){
		console.log("animation ended");
		if (!inShowing) {
		    inLayer.domNode.style.display = "none";
		    inLayer.domNode.style.left = 0;
		}
	    });
	    anim.play();

    },
    animFade: function(inLayer, inShowing) {
	    if (inShowing) {
		inLayer.domNode.style.opacity = 0.1; // can't fade in if its opacity starts at 1!
		inLayer.domNode.style.display = "";
	    }
	    var newopacity = (inShowing) ? 1 : 0.1;
	    var anim = dojo.animateProperty({
		node: inLayer.domNode,
		properties:{
		    opacity: newopacity
		},
		duration: 350
	    });
	    dojo.connect(anim,"onEnd", function(){
		console.log("animation ended");
		if (!inShowing) {
		    inLayer.domNode.style.display = "none";
		    inLayer.domNode.style.opacity = 1;
		}
	    });
	    anim.play();

    },

	activateLayer: function(inLayer) {
		var d = this.decoree;
		var old = d.getLayer(d.lastLayerIndex);
	        if (old && old != inLayer) {
		        old.transitionNext = inLayer.transitionNext = inLayer.getIndex() > old.getIndex();
			this.setLayerActive(old, false);		    
		}
		this.setLayerActive(inLayer, true);
		d.reflow();
	},
	// default decorator has no caption
	applyLayerCaption: function() {
	},
	moveLayerIndex: function(inFromIndex, inToIndex) {
		var d = this.decoree, l = d.getLayer(inFromIndex);
		// move in client
		d.client.removeControl(l);
		d.client.insertControl(l, inToIndex);
	}
});

}

if(!dojo._hasResource["wm.base.widget.Layers.TabsDecorator"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["wm.base.widget.Layers.TabsDecorator"] = true;
/*
 *  Copyright (C) 2008-2010 WaveMaker Software, Inc.
 *
 *  This file is part of the WaveMaker Client Runtime.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
dojo.provide("wm.base.widget.Layers.TabsDecorator");


dojo.declare("wm.TabsDecorator", wm.LayersDecorator, {
	decorationClass: "wmtablayers",
        decoratorPadding: "7, 0, 0, 0",
	undecorate: function() {
		this.inherited(arguments);
		this.tabsControl.destroy();
	},
	decorateContainer: function() {
		this.inherited(arguments);
		this.btns = [];
		this.tabsControl = new wm.TabsControl({
			parent: this.decoree, 
		        owner: this.decoree,
		        padding: this.decoratorPadding
		});
		this.decoree.moveControl(this.tabsControl, 0);
	},
	createTab: function(inCaption, inIndex, inLayer) {
		var b = this.btns[inIndex] = document.createElement("button");
	        //b.style.outline = "none";
		b.style.display = inLayer.showing ? "" : "none";
		this.setBtnText(b, inCaption);
		this.decoree.connect(b, "onclick", dojo.hitch(this, "tabClicked", inLayer));
	        b.className=this.decorationClass + "-tab";
		this.tabsControl.domNode.appendChild(b);
	},
	tabClicked: function(inLayer, e) {
		var d = this.decoree;
		// prevent designer click
		if (d.isDesignLoaded())
			dojo.stopEvent(e);
		d.setLayer(inLayer);
	},
	decorateLayer: function(inLayer, inIndex) {
		this.inherited(arguments);
		this.createTab(inLayer.caption, inIndex, inLayer);
	},
	undecorateLayer: function(inLayer, inIndex) {
		dojo._destroyElement(this.btns[inIndex]);
		this.btns.splice(inIndex, 1);
	},
	setLayerShowing: function(inLayer, inShowing) {
		var i = inLayer.getIndex();
		if (i != -1)
			this.btns[i].style.display = inShowing ? "" : "none";
		this.inherited(arguments);
	},
	setLayerActive: function(inLayer, inActive) {
		var b=this.btns[inLayer.getIndex()];
		if (b)
		    dojo[inActive ? "addClass" : "removeClass"](b, this.decorationClass + '-selected');
		this.inherited(arguments);
	},
	applyLayerCaption: function(inLayer) {
		var d = this.decoree, i = inLayer.getIndex();
		if (i != -1)
			this.setBtnText(this.btns[i], inLayer.caption);
	},
	setBtnText: function(inBtn, inCaption) {
		inBtn.innerHTML = inCaption || '&nbsp;';
	},
	getBtn: function(inCaption) {
		var d = this.decoree, i = d.indexOfLayerCaption(inCaption);
		if (i != -1)
			return this.btns[i];
	},
	disenableTab: function(inCaption, inDisable) {
		var b = this.getBtn(inCaption);
		if (b)
			b.disabled = inDisable ? "disabled" : "";
	},
	disableTab: function(inCaption) {
		this.disenableTab(inCaption, true);
	},
	enableTab: function(inCaption) {
		this.disenableTab(inCaption, false);
	},
	moveLayerIndex: function(inFromIndex, inToIndex) {
		this.inherited(arguments);
		var d = this.tabsControl.domNode, f = this.btns[inFromIndex], t = this.btns[inToIndex], c = this.decoree.getCount()-1;
		if (inToIndex < inFromIndex) {
			d.insertBefore(f, t);
		} else if (inToIndex > inFromIndex) {
			if (inToIndex == c)
				d.appendChild(f);
			else {
				var nl = this.btns[inToIndex + 1];
				if (nl)
					d.insertBefore(f, nl);
			}
		}
		this.btns[inToIndex] = f;
		this.btns[inFromIndex] = t;
	}
});

dojo.declare("wm.RoundedTabsDecorator", wm.TabsDecorator, {
	decorateContainer: function() {
		this.inherited(arguments);
		dojo.removeClass(this.tabsControl.domNode, "wmtablayers-tabbar");
		dojo.addClass(this.tabsControl.domNode, "wmtablayers-roundedtabbar");
		this.tabsControl.setPadding("0,0,0,15");
		this.tabsControl.domNode.style.paddingTop = "0px";								
		this.tabsControl.domNode.style.paddingLeft = "15px";
	},
	createTab: function(inCaption, inIndex, inLayer) {
		var b = this.btns[inIndex] = document.createElement("div");		
		b.style.display = inLayer.showing ? "" : "none";
		
		var divLeft = document.createElement("div");
		var divCenter = document.createElement("div");
		var divRight = document.createElement("div");
		
		divLeft.innerHTML = "&nbsp;";
		divCenter.innerHTML = "&nbsp;";
		divRight.innerHTML = "&nbsp;";
		
		this.setBtnText(divCenter, inCaption);
		this.decoree.connect(b, "onclick", dojo.hitch(this, "tabClicked", inLayer));
		this.decoree.connect(b, "onmouseover", dojo.hitch(this, "mouseoverout", inLayer, true));
		this.decoree.connect(b, "onmouseout", dojo.hitch(this, "mouseoverout", inLayer, false));

		b.className="wmtablayers-roundedtab";
		divLeft.className="wmtablayers-roundedtab-left";
		divCenter.className="wmtablayers-roundedtab-center";
		divRight.className="wmtablayers-roundedtab-right";

		b.appendChild(divLeft);
		b.appendChild(divCenter);
		b.appendChild(divRight);
		
		dojo.connect(b, "onselectstart", dojo, "stopEvent");
		this.tabsControl.domNode.appendChild(b);
	},
	tabClicked: function(inLayer){
		var b=this.btns[inLayer.getIndex()];
		var divLeft = b.childNodes[0];
		var divCenter = b.childNodes[1];
		var divRight = b.childNodes[2];		
		if (b){
			dojo.removeClass(divLeft, 'wmtablayers-roundedtab-left-hover');				
			dojo.removeClass(divCenter, 'wmtablayers-roundedtab-center-hover');
			dojo.removeClass(divRight, 'wmtablayers-roundedtab-right-hover');			
		}
		this.inherited(arguments);					
	},
	mouseoverout: function(inLayer, inActive){
		var inIndex = inLayer.getIndex();		
		if(this.decoree.layerIndex != inIndex){ // user has put mouse over an inactive tab
			var b=this.btns[inIndex];
			var divLeft = b.childNodes[0];
			var divCenter = b.childNodes[1];
			var divRight = b.childNodes[2];
			if (b){				
				dojo[inActive ? "addClass" : "removeClass"](divLeft, 'wmtablayers-roundedtab-left-hover');				
				dojo[inActive ? "addClass" : "removeClass"](divCenter, 'wmtablayers-roundedtab-center-hover');
				dojo[inActive ? "addClass" : "removeClass"](divRight, 'wmtablayers-roundedtab-right-hover');
			}							
		}
	},
	applyLayerCaption: function(inLayer) {
		var d = this.decoree, i = inLayer.getIndex();
		if (i != -1)
			this.setBtnText(this.btns[i].childNodes[1], inLayer.caption);
	}
	
});

dojo.declare("wm.WizardDecorator", wm.TabsDecorator, {
    decorationClass: "wmwizardlayers",
    decoratorPadding: "2",
    buttonPanel: null,
    nextButton: null,
    prevButton: null,
	undecorate: function() {
	    this.inherited(arguments);
	    if (this.buttonPanel)
		this.buttonPanel.destroy();
	    this.buttonPanel = null;
	    this.nextButton  = null;
	    this.prevButton  = null;
	},
	addFooter: function() {
	    this.buttonPanel = new wm.Panel({name: "buttonPanel",
					     parent: this.decoree,
					     owner: this.decoree,
					     layoutKind: "left-to-right",
					     height: "40px",
					     width: "100%",
                                             freeze: true,
                                             lock: true,
					     verticalAlign: "top",
					     horizontalAlign: "right"});
	    this.prevButton = new wm.Button({name: "prevButton",
					     parent: this.buttonPanel,
					     owner: this.decoree,
					     width: "80px",
					     height: "100%",
					     caption: "Back"});
	    this.nextButton = new wm.Button({name: "nextButton",
					     parent: this.buttonPanel,
					     owner: this.decoree,
					     width: "80px",
					     height: "100%",
					     caption: "Next"});
	    dojo.connect(this.prevButton, "onclick", this, "backClick");
	    dojo.connect(this.nextButton, "onclick", this, "nextClick");
	},
	setLayerActive: function(inLayer, inActive) {
	    this.inherited(arguments);
	    var i = inLayer.getIndex();

	    /*
	    this.prevButton.setShowing(i > 0);
	    this.nextButton.setShowing(i < inLayer.decorator.decoree.layers.length-1);
	    */

	    this.nextButton.setCaption(i < inLayer.decorator.decoree.layers.length-1 ? "Next" : "Done");
	},
    nextClick: function() {
	var i = this.decoree.layerIndex;
	var layer = this.decoree.getActiveLayer();
	this.validateCurrentLayer();
	if (!layer.invalid) {
	    if (i == this.decoree.layers.length-1) {
		this.decoree.onDoneClick();
	    } else {
		this.decoree.setLayerIndex(i+1);
		var layer = this.decoree.getActiveLayer();
		layer.focusFirstEditor();
	    }
	} else {
	    this.validateCurrentLayer(); // Notify user of the problem
	}
    },
    validateCurrentLayer: function(noWarn) {
	var i = this.decoree.layerIndex;
	var layer = this.decoree.getActiveLayer();

	// Mark as invalid before we start
	//layer.layerHasBeenValidated = false; 
	dojo.removeClass(this.btns[i], "done");

	var invalidWidget = layer.getInvalidWidget();
	if (invalidWidget && !noWarn) {

	    // focusing on an invalid editor will automatically show its invalid message without needing an alert
	    invalidWidget.focus();
	    invalidWidget.editor.displayMessage(invalidWidget.invalidMessage || "Invalid Input", true);

	    app.toastDialog.showToast("Invalid value for " + (invalidWidget.caption || invalidWidget.name), 3000, "Warning", "cc");
	    return false;
	}


	if (invalidWidget) return false;
	var result = {invalidMessage: null};
	this.decoree.onLayerValidation(layer, result);
	if (result.invalidMessage) {
	    app.alertDialog.setUserPrompt(result.invalidMessage);
	    app.alertDialog.show();
	    return false;
	}

	//layer.layerHasBeenValidated = true;
	//dojo.addClass(this.btns[i], "done");
	return true;
    },
    backClick: function() {
	this.validateCurrentLayer(true);
	var i = this.decoree.layerIndex;
	if (i == 0)
	    this.decoree.onCancelClick();
	else
	    this.decoree.setLayerIndex(i-1);
    },
    tabClicked: function(inLayer, e) {
	if (this.decoree.isDesignLoaded()) return this.inherited(arguments);
	var layer = this.decoree.getActiveLayer();

	var newindex = inLayer.getIndex();
	for (var i = 0; i < newindex; i++) {
	    if (this.decoree.layers[i].invalid) {
		app.toastDialog.showToast("Please fill out \"" + this.decoree.layers[i].caption + "\" first", 3000, "Warning", "cc");
		return;
	    }
	}

	this.inherited(arguments);
    }

});

dojo.declare("wm.TabsControl", wm.Control, {
	height: "27px",
	width: "100%",
	border: 0,
	init: function() {
		if (this.parent && this.parent.isRelativePositioned)
			this.isRelativePositioned = true;
		dojo.addClass(this.domNode, "wmtablayers-tabbar");
		this.height = this.owner && this.owner.headerHeight;
		this.inherited(arguments);
	}
});

}

if(!dojo._hasResource["wm.base.widget.Layers.AccordionDecorator"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["wm.base.widget.Layers.AccordionDecorator"] = true;
/*
 *  Copyright (C) 2008-2010 WaveMaker Software, Inc.
 *
 *  This file is part of the WaveMaker Client Runtime.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
dojo.provide("wm.base.widget.Layers.AccordionDecorator");


dojo.declare("wm.AccordionDecorator", wm.LayersDecorator, {
	decorationClass: "wmaccordion",
        captionBorder: 0,
        captionBorderColor: "",
	decorateLayer: function(inLayer, inIndex) {
		this.inherited(arguments);
		this.createHeader(inLayer, inIndex);
	},
	createHeader: function(inLayer, inIndex) {
                var captionHeight = inLayer.parent.captionHeight;
		var p = this.decoree.client;
		var h = inLayer.header = new wm.Label({
		    caption: inLayer.caption + "<span class='accordionArrowNode'></span>",
		        margin: "0,0,2,0",
		        height: captionHeight + "px",
                        padding: "4,4,0,4",
			_classes: {domNode: ["wmaccordion-header"]},
			showing: inLayer.showing,
			parent: p,
		        owner: p,
		        border: this.captionBorder,
		        borderColor: this.captionBorderColor
		});
		p.moveControl(h, inIndex*2);
		dojo.addClass(inLayer.domNode, "wmaccordion-content");
		this.decoree.connect(h.domNode, 'onclick', dojo.hitch(this, "headerClicked", inLayer));
	},
	headerClicked: function(inLayer, e) {
		var d = this.decoree;
		// prevent designer click
		if (d.isDesignLoaded())
			dojo.stopEvent(e);
		d.setProp(inLayer.active && d.multiActive ? "layerInactive" : "layer", inLayer);
	},
	getNewLayerIndex: function(inLayer) {
		for (var i=0, layers=this.decoree.layers, l; (l=layers[i]); i++)
			if (l != inLayer && l.active)
				return i;
	},
	deactivateLayer: function(inLayer) {
		var newIndex = this.getNewLayerIndex(inLayer);
		if (newIndex != undefined) {
			this.setLayerActive(inLayer, false);
			var d = this.decoree;
			d.layerIndex = newIndex;
			d.reflow();
		}
	},
	activateLayer: function(inLayer) {
		var d = this.decoree;
		if (d.multiActive && !d._loading) {
			this.setLayerActive(inLayer, true);
			d.reflow();
		} else
			this.inherited(arguments);
	},

	undecorateLayer: function(inLayer, inIndex) {
		inLayer.header.destroy();
		dojo.removeClass(inLayer.domNode, 'wmaccordion-content');
	},
	setLayerShowing: function(inLayer, inShowing) {
		inLayer.header.setShowing(inShowing);
		this.inherited(arguments);
	},
	setLayerActive: function(inLayer, inShowing) {
		dojo[inShowing ? 'removeClass' : 'addClass'](inLayer.header.domNode, 'wmaccordion-collapsed');
		this.inherited(arguments);
	},
	applyLayerCaption: function(inLayer) {
	    inLayer.header.setCaption(inLayer.caption +  "<span class='accordionArrowNode'></span>");
	},
	moveLayerIndex: function(inFromIndex, inToIndex) {
		var d = this.decoree, client = d.client, l = d.getLayer(inFromIndex);
		client.removeControl(l);
		client.removeControl(l.header);
		client.insertControl(l.header, inFromIndex*2);
		client.insertControl(l, inFromIndex*2 + 1);
	}
});

}

if(!dojo._hasResource["wm.base.widget.Layers"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["wm.base.widget.Layers"] = true;
/*
 *  Copyright (C) 2008-2010 WaveMaker Software, Inc.
 *
 *  This file is part of the WaveMaker Client Runtime.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
dojo.provide("wm.base.widget.Layers");





dojo.declare("wm.Layer", wm.Container, {
	height: "100%",
	width: "100%",
	caption: "",
	layoutKind: "top-to-bottom",
	moveable: false,
	_requiredParent: "wm.Layers",
        transition: "none",
	destroy: function() {
		//console.info('layer destroy called');
		if (this.parent)
			this.parent.setCaptionMapLayer(this.caption, null);
		this.inherited(arguments);
	},
	init: function() {
		this.inherited(arguments);
		// bc
		if (this.title) {
			this.caption = this.title;
			delete this.title;
		}
		this.setCaption(this.caption);
		if (!this.isRelativePositioned)
			dojo.addClass(this.domNode, "wmlayer");
            this.setBorder(this.parent.clientBorder);
            this.setBorderColor(this.parent.clientBorderColor);
	},
	// FIXME: override so that we do not remove and re-add layer
	// this is nasty but avoids dealing with layer order changing
	setName: function(inName) {
		if (this.parent)
			delete this.parent.widgets[this.name];
		this.addRemoveDefaultCssClass(false);
		wm.Component.prototype.setName.apply(this, arguments);
		if (this.parent)
			this.parent.widgets[this.name] = this;
		this.addRemoveDefaultCssClass(true);
	},
	activate: function() {
		var p = this.parent;
		if (p && this.showing && !this.isActive())
			p.setLayer(this);
	},
	isActive: function() {
		return this.active;
	},
	setShowing: function(inShowing) {
		if (!this.canChangeShowing())
			return;
		if (this.showing != inShowing) {
			this.showing = inShowing;
			this.decorator.setLayerShowing(this, inShowing);
			var p = this.parent;
			if (!inShowing && p.layerIndex == this.getIndex()) {
				p.setNext();
			}
		}
	},
        show: function() {
	    this.setShowing(true);
	},
        hide: function() {
	    this.setShowing(false);
	},
	setCaption: function(inCaption) {
		this.caption = inCaption;
		if (this.parent)
			this.parent.setCaptionMapLayer(inCaption, this);
		this.decorator.applyLayerCaption(this);
	},
	getIndex: function() {
		var p = this.parent;
		return p && p.indexOfLayer(this);
	},
	// fired by Layers
	onShow: function() {
		// FIXME: remove _onShowParent when no longer used (e.g. PageContainer)
		wm.forEachProperty(this.widgets, function(w) {
			wm.fire(w, "_onShowParent");
		})
	}
});

dojo.declare("wm.Layers", wm.Container, {
        clientBorder: "",
        clientBorderColor: "",
	layerIndex: -1,
	defaultLayer: -1,
	decoratorClass: wm.LayersDecorator,
	layersType: 'Layers',
	layoutKind: "top-to-bottom",
	height: "100%",
	width: "100%",
	destroy: function() {
		//console.info('LAYERS destroy called');
		this.inherited(arguments);
		if (this.decorator) 
		{
			this.decorator.destroy();
			this.decorator = null;
		}
		
		this.layers = null;
		this.captionMap = null;
		this.client = null;
	},
	prepare: function() {
		this.layers = [];
		this.captionMap =[];
		this.inherited(arguments);
	},
	build: function() {
		this.inherited(arguments);
		this.setLayersType(this.layersType);
	},
	init: function() {
		if (!this.isRelativePositioned)
			dojo.addClass(this.domNode, "wmlayers");
		else
			this.setHeaderHeight('20px');
            // vertical defaults to justified; once we get rid of justified, we can remove this property
	    this.client = new wm.Panel({isRelativePositioned:this.isRelativePositioned, border: 0, name: "client", parent: this, owner: this, height: "100%", width: "100%",  flags: {notInspectable: true}});
		this.inherited(arguments);
	},
	postInit: function() {
		this.inherited(arguments);
		if (!this.getCount())
			this.addLayer();
		this._initDefaultLayer();
		// fire onshow when loaded
		if (wm.widgetIsShowing(this))
			this._fireLayerOnShow();
	},
        afterPaletteDrop: function(){
	    this.inherited(arguments);
	    this.setClientBorder(this.clientBorder);
	    this.setClientBorderColor(this.clientBorderColor);
	},
	_initDefaultLayer: function() {
		var d = this.defaultLayer;
		d = d != -1 ? d : 0;
		var dl = this.getLayer(d);
		// call private index setter so we avoid canShow; however, honor showing property
		if (dl && !dl.showing) {
			d = this._getPrevNextShownIndex(d);
			dl = this.getLayer(d);
		}
		if (dl)
			this._setLayerIndex(dl.getIndex());
	},
	createLayer: function(inCaption) {
		var
			defName = this.owner.getUniqueName(inCaption || "layer1"),
	    props = {width: "100%", height: "100%", caption: defName, parent: this, horizontalAlign: "left", verticalAlign: "top", themeStyleType: this.themeStyleType},
			o = this.getRoot();
		if (o)
			return o.createComponent(defName, "wm.Layer", props);
	},
        themeStyleType: "",
        setThemeStyleType: function(inMajor) {
	    this.themeStyleType = inMajor;
            for (var i = 0; i < this.layers.length; i++) {
	        this.layers[i].setThemeStyleType(inMajor);
            }
	},

        setClientBorder: function(inBorder) {
            this.clientBorder = inBorder;
	    // in design mode, set_border updates the design borders
	    var method = this.isDesignLoaded() ? "set_border" : "setBorder";
            for (var i = 0; i < this.layers.length; i++) {
		this.layers[i][method](inBorder);
	    }
        },
        setClientBorderColor: function(inBorderColor) {
            this.clientBorderColor = inBorderColor;
            for (var i = 0; i < this.layers.length; i++)
                this.layers[i].setBorderColor(inBorderColor);
        },    
	// public api for adding a layer
	addLayer: function(inCaption) {
		var pg = this.createLayer(inCaption);
		this._setLayerIndex(this.getCount()-1);
		return pg;
	},
	// called by owner automatically.
	addWidget: function(inWidget) {
		if (inWidget instanceof wm.Layer) {
			this.client.addWidget(inWidget);
			this.layers.push(inWidget);
			this.setCaptionMapLayer(inWidget.caption, inWidget);
			if (this.decorator) {
				this.decorator.decorateLayer(inWidget, this.getCount()-1);
				// de-activate layer by default
				this.decorator.setLayerActive(inWidget, false);
			}
		} else {
			this.inherited(arguments);
		}
	},
	removeWidget: function(inWidget) {
		if (inWidget instanceof wm.Layer) {
			var i = this.indexOfLayer(inWidget);
			this.layers.splice(i, 1);
			this.setCaptionMapLayer(inWidget.caption, null);
			this.decorator.undecorateLayer(inWidget, i);
			this.client.removeWidget(inWidget);
			this.setLayerIndex(0);
		} else {
			this.inherited(arguments);
		}
	},
	addControl: function(inControl) {
		if (inControl.owner == this) {
			this.inherited(arguments);
		} else if (inControl instanceof wm.Layer) {
			this.client.addControl(inControl);
		}
	},
	removeControl: function(inControl) {
		if (inControl.owner == this) {
			this.inherited(arguments);
		} else if (inControl instanceof wm.Layer) {
			this.client.removeControl(inControl);
		}
	},
	isWidgetTypeAllowed: function(inChildType) {
		return inChildType == "wm.Layer";
	},
	getLayer: function(inIndex) {
		return this.layers[inIndex != undefined ? inIndex : this.layerIndex];
	},
	getActiveLayer: function() {
	  if (this.layerIndex != -1) return this.layers[this.layerIndex];
	  var defaultIndex = (this.defaultLayer == -1) ? 0 : this.defaultLayer;
	  return this.layers[defaultIndex];
	},
	// public api for removing a layer
	removeLayer: function(inIndex) {
		if (!this.layers)
			return;
		var p = this.getLayer(inIndex);
		if (p)
			this.removeWidget(p);
	},
	indexOfLayer: function(inLayer) {
		for (var i=0, l; (l=this.getLayer(i)); i++)
			if (l == inLayer)
				return i;
		return -1;
	},
	indexOfLayerName: function(inLayerName) {
		for (var i=0, l; (l=this.getLayer(i)); i++)
			if (l.name == inLayerName)
				return i;
		return -1;
	},
	indexOfLayerCaption: function(inCaption) {
		return this.indexOfLayer(this.captionMap[inCaption]);
	},
	getLayerCaption: function(inIndex) {
		var p = this.getLayer(inIndex);
		return p && p.caption;
	},
	getLayerByCaption: function(inCaption) {
		return this.getLayer(this.indexOfLayerCaption(inCaption));
	},
	setLayerByCaption: function(inCaption) {
		var p = this.captionMap[inCaption];
		this.setLayerByName(p || inCaption);
	},
	setLayerByName: function(inName) {
		var l = this.client.widgets[inName];
		if (l)
			this.setLayer(l);
		else if (inName)
			this.addLayer(inName);
	},
	setLayer: function(inNameOrLayer) {
		if (inNameOrLayer instanceof wm.Layer)
			// note: use setProp so we can call design version
			this.setProp("layerIndex", inNameOrLayer.getIndex());
		else
			this.setLayerByName(inNameOrLayer);
	},
	setLayerInactive: function(inLayer) {
		wm.fire(inLayer.decorator, "deactivateLayer", [inLayer]);
	},
	setLayerIndex: function(inIndex) {
		if (inIndex == this.layerIndex)
			return;
		var
			fireEvents = !this.loading,
			l = this.getLayer(inIndex);
		if (fireEvents) {
			var info = {newIndex: inIndex, canChange: l && l.showing};
			this.oncanchange(info);
			if (info.canChange === false)
				return;
			inIndex = info.newIndex;
		}
		if (inIndex < 0 || inIndex > this.getCount()-1)
			return;

		this._setLayerIndex(inIndex);
		if (fireEvents) {
			l && l.onShow();
		}
		if (fireEvents && this.lastLayerIndex != this.layerIndex)
			this.onchange(this.layerIndex);
	},
	_setLayerIndex: function(inIndex) {
		this.lastLayerIndex = this.layerIndex;
		this.layerIndex = inIndex;
		var l = this.getLayer(inIndex);
		if (l)
			this.decorator.activateLayer(l);
	},
	setDecoratorClass: function(inClass) {
		this.decoratorClass = inClass;
		this.createDecorator();
	},
	createDecorator: function() {
		if (this.decorator)
			this.decorator.destroy();
		this.decorator = this.decoratorClass ? new this.decoratorClass(this) : null;
	},
	setLayersType: function(inLayersType) {
		var ctor = wm[inLayersType + 'Decorator'];
		if (!ctor)
			return;
		this.layersType = inLayersType;
		var i = this.layerIndex;
	    if (this.decorator) {
		this.decorator.undecorate();
		this.decorator.destroy();
		this.decorator = null;
	    }
		this.setDecoratorClass(ctor);
		this.decorator.decorate();
		this._setLayerIndex(i);
		this.reflow();
	},
	setDefaultLayer: function(inLayerIndex) {
		this.defaultLayer = inLayerIndex;
	},
	getCount: function() {
		return this.layers.length;
	},
	setCaptionMapLayer: function(inCaption, inLayer) {
		try
		{
			this.captionMap[inCaption] = inLayer;
		}
		catch(e)
		{
			// do nothing as this might happen when we are trying to destroy all the layers.
		}
	},
	_getPrevNextShownIndex: function(inIndex, inPrev, inBounded) {
		var
			d = inPrev ? -1 : 1,
			c = this.getCount(),
			e = inPrev ? 0 : c-1,
			w = inPrev ? c-1 : 0,
			i = inPrev ? Math.min(inIndex+d, w) : Math.max(inIndex+d, 0),
			l;
		while (i != inIndex) {
			l = this.getLayer(i);
			if (l && l.showing)
				return i;
			if (inPrev ? i > e : i < e)
				i = i + d;
			else {
				if (inBounded)
					return;
				else
					i = w;
			}
		}
	},
	setNext: function(inBounded) {
		var p = this._getPrevNextShownIndex(Number(this.layerIndex), false, inBounded);
		if (p !== undefined)
			this.setLayerIndex(p);
	},
	setPrevious: function(inBounded) {
		var p = this._getPrevNextShownIndex(Number(this.layerIndex), true, inBounded);
		if (p !== undefined)
			this.setLayerIndex(p);
	},
	moveLayerIndex: function(inLayer, inIndex) {
		var i = inLayer.getIndex(), inIndex = Math.max(0, Math.min(inIndex, this.getCount()-1));
		if (i == inIndex)
			return;
		// fixup layers array
		this.layers.splice(i, 1);
		this.layers.splice(inIndex, 0, inLayer);
		// decorate
		this.decorator.moveLayerIndex(i, inIndex);
		// change layer
		this._setLayerIndex(inIndex);
	},
	_fireLayerOnShow: function() {
		var l = this.getLayer(this.layerIndex);
		l && l.onShow();
	},
	_onShowParent: function() {
		this._fireLayerOnShow();
	},
	clear: function() {
		wm.forEach(this.widgets, function(w) {
			w.destroy();
		});
		this.widgets = {};
		this.layers = [];
		this.domNode.innerHTML = "";
	},
	// events
	oncanchange: function(inChangeInfo) {
	},
	onchange: function(inIndex) {
	},
	// used only by Tabs
	headerHeight: "27px",
	setHeaderHeight: function(inHeight) {
		if (this.layersType != 'Tabs' && this.layersType != "RoundedTabs")
			return;
		this.headerHeight = inHeight;
		this.decorator && this.decorator.tabsControl && this.decorator.tabsControl.setHeight(inHeight);
	},
        getMinHeightProp: function() {
            if (this.minHeight) return this.minHeight;
            var minHeight = 80;
            if (this.layersType.match(/tabs/i)) minHeight += parseInt(this.headerHeight);
            return minHeight;
        },
        getMinWidthProp: function() {
            if (this.minWidth) return this.minWidth;
            var minWidth = 80;
            if (this.layersType.match(/tabs/i)) minWidth += 120; // need horiz space for tabs
            return minWidth;
        }
});


dojo.declare("wm.TabLayers", wm.Layers, {
        //useDesignBorder: 0,
       themeStyleType: "ContentPanel",
       layersType: 'Tabs'/*,
	   afterPaletteDrop: function(){
	   	this.inherited(arguments);
	   	this.setLayersType("RoundedTabs");
	   }		*/
});

dojo.declare("wm.AccordionLayers", wm.Layers, {
    multiActive: false,
    themeStyleType: "ContentPanel",
    layersType: 'Accordion',
    layerBorder: 1,
    captionHeight: 26, // used by decorator
    postInit: function() {
        this.inherited(arguments);
        this.setLayerBorder(this.layerBorder);
    },
    setBorderColor: function(inColor) {
	this.inherited(arguments);
        for (var i = 0; i < this.layers.length; i++) {
	    this.layers[i].setBorderColor(this.borderColor);
	}
    },
    setLayerBorder: function(inBorder) {
        this.layerBorder = inBorder;
        for (var i = 0; i < this.layers.length; i++) {
            this.layers[i].setBorder(this.layerBorder);
	    this.layers[i].setBorderColor(this.borderColor);
	}
    },
    addLayer: function() {
        this.inherited(arguments);
        this.setLayerBorder(this.layerBorder);
    }
});


/************************************************************************
 * FEATURES:
 * 1. Next/previous button built in to get user to next/previous step of wizard (or next/previous card)
 * 2. Turns tabs into breadcrumbs
 * 3. Manages state and clickability of each breadcrumb
 * 4. Manages carriage return, maps it to Next button.
 * 5. Autofocus on any invalid or missing required field and refuses to go to next step
 * 6. Autofocus on first editor after going to next step
 * 7. Introduces animated layer transitions
 * 8. The entire wizard comes with two events that fire if the user backs out of the wizard, or hits next after the wizard is complete (onCancelClick, onDoneClick)
 * 9. Added the ability to auto focus on a widget that fails validation or is required.
 * 10. Added animated transitions
 * 11. Custom validators per layer
 */
dojo.declare("wm.WizardLayers", wm.Layers, {
    themeStyleType: "ContentPanel",
    layersType: 'Wizard',
    transition: "fade",
    //useDesignBorder: 0,
    init: function() {
	this.inherited(arguments);
	this.decorator.addFooter();
	this.connect(this.domNode, "keydown", this, "keydown");
    },
    keydown: function(e) {
	var keyCode = e.keyCode;
	if (e.keyCode == dojo.keys.ENTER || e.keyCode == dojo.keys.NUMPAD_ENTER) {
	    this.decorator.nextClick();
	    dojo.stopEvent(e);
	    return false;
	}
	return true;
    },
    onCancelClick: function(inSender) {

    },
    onDoneClick: function(inSender) {

    },
    /* This should really be an event of wm.Layer, but we should first discuss whether we want form
     * validation to be build into wm.Layer */
    onLayerValidation: function(inLayer, outResult) {

    }
});



}

if(!dojo._hasResource["wm.modules.rbac.RbacPlugin"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["wm.modules.rbac.RbacPlugin"] = true;
/*
 * Copyright (C) 2009-2010 WaveMaker Software, Inc.
 *
 * This file is part of WaveMaker Enterprise.
 * You may not use this file in any manner except through written agreement with WaveMaker Software, Inc.
 *
 */ 
//dojo.provide("wm.modules.rbac.RbacPlugin");
dojo.provide("wm.base.RbacPlugin");




wm.Plugin.plugin("rbac", wm.Widget, {
	roles: '',
	loaded: function() {
		this.rbacSocket(arguments);
		if (this.roles && this.roles.length) {
			this.setShowing(this.showing);
		}
	},
	setShowing: function(inValue) {
		if (this.roles && this.roles.length) {
			inValue = inValue && this.isAllowed();
		}
		this.rbacSocket(arguments);
	},
	setRoles: function(inValue) {
		var s = inValue.split(','), r=[];
		for (var i=0, v, f; (f=s[i]); i++) {
			v = dojo.trim(f);
			if (v)
				r.push(v);
		}
		this.roles = r;
		this.setShowing(true);
	},
	addRole: function(inRole) {
		if (!this.roles) {
			this.roles = [];
		}
		this.roles.push(inRole);
	},
	removeRole: function(inRole) {
		if (this.roles) {
			for (var i=0, c; c=this.roles[i]; i++) 
				if (c == inRole)
					this.roles.splice(i--, 1);
			if (!this.roles.length) {
				this.roles = '';
			}
		}
	},
	removeAllRoles: function() {
		this.roles = '';
	},
	isAllowed: function() {
		var userRoles = this._getUserRoles();
		if (userRoles) {
			for (var i=0, r; (r=this.roles[i]); i++) {
				for (var j=0, ur; (ur=userRoles[j]); j++) {
					if (r == ur) {
						return true;
					}
				}
			}
			return false;
		}
		return true;
	},
	_getUserRoles: function() {
		if (this.isDesignLoaded()) {
			// this should return the "Preview By Role(s)" roles
			return null;
		} else {
			return wm.getUserRoles();
		}
	}
});

wm.Plugin.plugin("rbacLayer", wm.Layer, {
	setShowing: function(inValue) {
		if (this.roles && this.roles.length) {
			inValue = inValue && this.isAllowed();
		}
		this.rbacLayerSocket(arguments);
	}
});

wm.Object.extendSchema(wm.Widget, {
	roles: {ignore: 1, writeonly: 1, category: "Security",
	categoryProps: {content: "Security", image: "images/lock_16.png", inspector: "Security"}}
});

}

if(!dojo._hasResource["wm.base.Widget"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["wm.base.Widget"] = true;
/*
 *  Copyright (C) 2008-2010 WaveMaker Software, Inc.
 *
 *  This file is part of the WaveMaker Client Runtime.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
dojo.provide("wm.base.Widget");

}

if(!dojo._hasResource["wm.base.components.Page"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["wm.base.components.Page"] = true;
/*
 *  Copyright (C) 2008-2010 WaveMaker Software, Inc.
 *
 *  This file is part of the WaveMaker Client Runtime.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
dojo.provide("wm.base.components.Page");


dojo.connect(window, "onresize", function(){ dojo.publish("window-resize"); });

var wmObjectList = [];
wm.getObject = function(inType){
	if (!wmObjectList[inType])
	{
		wmObjectList[inType] = dojo.getObject(inType);
	}

	return wmObjectList[inType];
}

dojo.declare("wm.Page", wm.Component, {
	name: '',
        deletionDisabled: 1,
	create: function() {
		this.inherited(arguments);
		if (!this.name) 
		    this.name = this.declaredClass.toLowerCase();
		//dojo.addOnLoad(wm.async(dojo.hitch(this, "render")));
		this.render();
	},
	getMainPage: function() {
	  if (!this.owner)
	  	return null;
	  var owner = this.owner;
	  while(owner.owner) {
	    owner = owner.owner;
	  }
	  if (owner instanceof wm.Application)
	    return owner;
	},
	destroy: function() {
	  	var owner = this.getMainPage();
	  	if (owner) 
			owner.subPageUnloaded(this);	  
	  	if (window.app) 
			window.app.subPageUnloaded(this);
		wm.fire(this.root, "destroy");
		this.inherited(arguments);
		delete this.app;
		delete this.domNode;
		delete this.root;
		owner = null;
		delete this._designee;
	},
	/* TODO: Does't this mean that if my page name is document, then window.document property gets clobbered? (MK)*/
	init: function() {
		this.app = window.app;
		if (this.owner instanceof wm.Application)		
			window[this.name] = this;
		else
			this.owner[this.name] = this;
		this.inherited(arguments);
	},
	forEachWidget: function(inFunc) {
		if (this.root)
			return wm.forEachWidget(this.root, inFunc);
		// returning pure "false" will halt the forEach, undefined is ok
	},
	render: function() {
		//console.time('renderTime ');
		var d = this.domNode || document.body;
		// FIXME: hiding pages not owned by app when rendered
		// this really only applies to pages loaded into pageContainers
		// however, due to asynchronous rendering it's not convenient to put
		// this code elsewhere right now.
		var notAppOwned = (this.owner != app), ds = d.style;
		dojo.addClass(d, this.declaredClass);
		
		// if noAppOwned, we set left to negetive value so that user cannot see
		// the actual rendering. After this is done, we should place this div at 
		// the place it was earlier(ie, previousStyleLeft).
		var previousStyleLeft = ds.left;
		if (notAppOwned)
			ds.left = "-100000px";
		wm.timePage && console.time("page.loadComponents");
	    this._loadingPage = true;
	    var startTime = new Date().getTime();
	    var widgets = this.constructor.widgets || this.widgets;
	    if (wm.isEmpty(widgets)) 
			alert("Page " + this.name + " has been corrupted, and no longer has a wm.Layout nor any widgets; please create a new project or edit " + this.name + ".widgets.js by hand");
		this.loadComponents(widgets, null);

	    //this._layoutPanel.parentNode.appendChild(this._layoutPanel.domNode);

		//this.loadCssHtml();
		wm.timePage && console.timeEnd("page.loadComponents");
		var self = this;
	    
		// reverting Michael's change here.
		//if (this.getRoot() instanceof wm.Page && this.getRoot()._loadingPage) {
		//this.postRender();
		//this.onShow();
	    //} else
		
		dojo.addOnLoad(function(){
			self.postRender();
			if (notAppOwned)
				ds.left = previousStyleLeft;
			self.onShow();
		    //alert("Page rendered in " + ( new Date().getTime() - startTime) + " ms");
			//console.timeEnd('renderTime ');
			//console.info('postInitCalled = ' + postInitCalled);
			//postInitCalled = 0;
		});

		//console.profile();

	},
	postRender: function() {
		wm.timePage && console.time("root.reflow");
		wm.fire(this.root, "reflow");
		wm.timePage && console.timeEnd("root.reflow");
		/*
		if (this.owner && this.owner.reflowParent)
			this.owner.reflowParent();
		else
			dojo.publish("window-resize");
		*/
		// FIXME: automatically unload support for parts used in the studio interface
		// so as not to conflict with user parts
		wm.fire(this, "unloadSupport");
		try {
	            this._loadingPage = false;
		    if (this.root) {
			//this.root.leafFirstRenderCss();
			this.reflow();
		    }
		    this.start();
                    this._startCalled = true;
	        if (wm.debugPerformance) {
	            var timeToLoad = this.stopTimerWithName("LoadPage", "wm.Layout");

		    console.log("PAGE "+ timeToLoad + " ms");
		}

		    this.onStart();

                    /* Moved to Application.pageChanged
		    if (this.owner == app) {
			this.connect(document, "keydown", this, "keydown");
		    }*/
		} catch(e) {
		  console.error("Failed to initialize page " + this.name + "; " + e);
		}

	},
	start: function() {
	},
	reflow: function() {
		wm.fire(this.root, "reflow");
	},
	addComponent: function(inComponent) {
		this[inComponent.name] = inComponent;
		if (inComponent instanceof wm.Widget) {
			// FIXME: hack to resolve clickability problem on IE at design-time
			// nodes must have some background or content to receive mouse events
			// on IE.
			if (this._designer && dojo.isIE) {
				var s = inComponent.domNode && dojo.getComputedStyle(inComponent.domNode);
				if (s && s.backgroundImage=="none"){
					inComponent.domNode.style.backgroundImage = "url(images/blank.gif)";
				}
			}
		/*}else{
			this.inherited(arguments);
		*/
		}
		this.inherited(arguments);
	},
	removeComponent: function(inComponent) {
		delete this[inComponent.name];
		this.inherited(arguments);
	},
	// design support
	isDesignLoaded: function() {
	    //return Boolean(this._designer);
            return this.name == "wip";
	},
	getRoot: function() {
		return this;
	},
	getId: function(inName) {
		return inName;
	},
	getRuntimeId: function(inId) {
		inId = this.name + (inId ? "." + inId : "");
		return this.owner ? this.owner.getRuntimeId(inId) : inId;
	},
	getComponent: function(inName) {
		return this.components[inName] || this[inName] || this.owner && this.owner.getComponent(inName);
	},
	_create: function(ctor, props) {
		if (ctor.prototype instanceof dijit._Widget && window.dijit){
			return new wm.DijitWrapper(dojo.mixin(props||{}, { dijitClass: ctor, publishClass: p.declaredClass }));
		}
		return this.inherited(arguments);
	},
	loadComponent: function(inName, inParent, inType, inProps, inEvents, inChildren, isSecond) {
		// Some code for debugging performance; normally skipped
		if (wm.debugPerformance) {
			if (inType == "wm.Layout") {
				if (dojo.isFF)
					console.groupCollapsed("LOAD COMPONENT " + inType + ": " + inName);
				else
					console.group("LOAD COMPONENT " + inType + ": " + inName);
			}

		    this.startTimerWithName("LoadComponent", inType);
		    this.startTimerWithName("LoadPage", inType);
		}

		var ctor = wm.getObject(inType);
		if (!ctor)
		{
			try
			{
				wm.getComponentStructure(inType);
				ctor = dojo.getObject(inType);
			}
			catch (e)
			{
				console.info('Error : Page.js trying to get component dynamically-------------> ' + e);
			}

			if (!ctor) 
			{
				console.debug('Component type "' + inType + '" is not available.');
				ctor = wm.Box;
			}
		}
		

		// FIXME: this check really needs to go
		// yuk
		var props = {};
		isWidget = (ctor.prototype instanceof wm.Widget || ctor.prototype instanceof dijit._Widget);
		if (isWidget){
			var parentNode = (inParent ? inParent.containerNode || inParent.domNode : this.domNode);
			props = {
				owner: this,
				parent: inParent,
				domNode: parentNode ? null : document.body,
				parentNode: parentNode
			};
		}
	    
        // props.name should overwrite getUniqueName(inName), which should overwrite inProps.
            var newOwner;
            if (inParent && inParent instanceof wm.Layout)
                newOwner = inParent.owner;
            else if (inParent)
                newOwner = inParent;
            else
                newOwner = this;
        props = dojo.mixin({}, inProps, {
			name: this.getUniqueName(inName),
	                owner: newOwner,
			_designer: this._designer,
			_loading: true
		}, props);

		if (this.isRelativePositioned){
			props.isRelativePositioned = true;	
		}

	    // All custom methods should be page methods; page methods have not been evaled, so 
	    // can not be defined nor invoked at design time
	    if (!this.isDesignLoaded()) {
		for (var p in props) {
		    if (p.indexOf("custom") == 0 && dojo.isFunction(ctor.prototype[p])) {
			var owner = props.owner;
			props[p] = dojo.hitch(owner, owner[props[p]]);
		    }
		}
	    }



		// Calls Component.create, which calls prepare, build, init and postInit
		var c = this._create(ctor, props);


		// FIXME: this initialization should be in Component
		// to remove the distinction between 'loading' and 'creating'
			if (!inParent && isWidget) {
				c.moveable = false;
				this.root = c;
			}

			this.makeEvents(inEvents, c);
			//if (!(c instanceof wm.Layer) || !c.deferLoading)

			if (inChildren)
				this.loadComponents(inChildren, c);

			c.loaded(); // Component.loaded calls postInit 

	                var timeToLoad = this.stopTimerWithName("LoadComponent", inType);
	        if (wm.debugPerformance) {
		  if (inType == "wm.Layout") {
		    console.log(inType + ": " + inName + " TOOK "+ timeToLoad + " ms");
		    console.groupEnd();
		    this.printPagePerformanceData();
		    console.log(inType + ": " + inName + " TOOK "+ timeToLoad + " ms");
		  }
 		}

		return c;
	},
	printPagePerformanceData: function() {
	  var totalsByMethod = {};
			    
			    for (var componentType in wm.Component.timingByComponent) {
			      var obj = wm.Component.timingByComponent[componentType];

			      var display = false;
			      for (var i in obj) {
				if (wm.sum(obj[i]) > 10) display = true;
			      }
			      //if (!display) continue;
			      console.group("Timing for " + componentType);
			      for (var i in obj) {
				console.log(i + ": Total: " + wm.sum(obj[i]) + ", Average: " + wm.average(obj[i]) + ", Worst: " + wm.max(obj[i]) + ", Instances: " + obj[i].length);
				if (!totalsByMethod[i]) totalsByMethod[i] = 0;
				totalsByMethod[i] += wm.sum(obj[i]);
			      }
			      console.groupEnd();
			    }
			    for (var i in totalsByMethod) {
			      console.log("TOTAL TIME IN " + i + ": " + totalsByMethod[i]);
			    }

	},

	loadComponents: function(inChildren, inParent) {
		for (var i in inChildren) {
			try 
			{
			 this.loadComponent(i, inParent, inChildren[i][0], inChildren[i][1], inChildren[i][2], inChildren[i][3]);
			} catch(e) {
			  console.error("FAILED TO LOAD " + "[" + inChildren[i][1].name + "] " + i + ": ", e);
			  console.log("COMPONENT:");console.log(inChildren);
			  console.log("PARENT:");console.log(inParent);
			}
		}
	},
	onShow: function() {
	},
	onStart: function(inPage) {		
	},
	keydown: function(e) {
            // Ignore keydown if a dialog is open; if the owner is not the main application; if the main page of the application is not this page (this page is in a page container)
	      if (wm.dialog.showing || this.owner != app || this != app._page) return true;
	    var chr = String.fromCharCode(e.keyCode);
	    if (e.shiftKey) {
		if (e.keyCode != dojo.keys.SHIFT)
		    this.onShiftKey(e.keyCode, chr);
	    } else if (e.ctrlKey) {
		if (e.keyCode != dojo.keys.CTRL)
		    this.onCtrlKey(e.keyCode, chr);
	    } else if (e.keyCode == dojo.keys.ESCAPE)
		this.onEscapeKey();
	    else if (e.keyCode == dojo.keys.ENTER)
		this.onEnterKey();
	    else if (chr)
		this.onLetterKey(chr);
	    else 
		this.onMiscKey(e.keyCode);
	},
        onEnterKey: function() {},
        onShiftKey: function(inKeyCode, inCharacter) {},
        onCtrlKey: function(inKeyCode, inCharacter) {},
        onEscapeKey: function() {},

        onLetterKey: function(inCharacter) {},
        onMiscKey: function(inKeyCode) {},
	// bc only: load page css and html
	/*loadCssHtml: function() {
		var path = wm.pagesFolder + this.declaredClass + "/" + this.declaredClass;
		var hasCssLoader, hasHtmlLoader;
		for (var i in this.$) {
			if (this.$[i] instanceof wm.CssLoader)
				hasCssLoader = true;
			if (this.$[i] instanceof wm.HtmlLoader)
				hasHtmlLoader = true;
		}
		if (!hasCssLoader)
			this.loadComponent("cssLoader", null, "wm.CssLoader", {owner: this, url: path + ".css"});
		if (!hasHtmlLoader)
			this.loadComponent("htmlLoader", null, "wm.HtmlLoader", {owner: this, url: path + ".html"});
	},*/
	_end: 0
});

wm.Page.extend({
	designCreate: function() {
		this.inherited(arguments);
		this.app = this.isDesignLoaded() ? studio.application : app;
	},
	// FIXME: unload support for parts that are specifically loaded into our development environment
	// this is so that they do not conflict with user named parts with the same names.
	// the "_isWaveMakerStudio" flag is set in studio and is specifically to detect if we're in the real studio.
	unloadSupport: function() {
		if (!this.isDesignLoaded() && window.studio && window.studio._isWaveMakerStudio) {
			this.constructor._supported = false;
			this.constructor.widgets = {};
		}
	},
	generateEventName: function(inEventName) {
	    return inEventName;
	},
	_getProp: function(n) {
	    if (window["studio"] && this == studio.page && this.isEventProp(n))
		return (getEvent(n,studio.getScript())) ? n : "";
	    return this.inherited(arguments);
	}
});

wm.Object.extendSchema(wm.Page, {
    onStart: {events: ["js", "disableNoEvent"]},
    onShow: {events: ["js", "disableNoEvent"]},
    onShiftKey: {events: ["js", "disableNoEvent"]},
    onCtrlKey: {events: ["js", "disableNoEvent"]},
    onEscapeKey: {events: ["js", "disableNoEvent"]},
    onEnterKey: {}, // allow all events
    onLetterKey: {events: ["js", "disableNoEvent"]},
    onMiscKey: {events: ["js", "disableNoEvent"]}
});

// bc
wm.Part = wm.Page

}

if(!dojo._hasResource["wm.base.components.HtmlLoader"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["wm.base.components.HtmlLoader"] = true;
/*
 *  Copyright (C) 2008-2010 WaveMaker Software, Inc.
 *
 *  This file is part of the WaveMaker Client Runtime.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
dojo.provide("wm.base.components.HtmlLoader");

wm.getNodeIds = function(inNode) {
	var ids = [];
	dojo.forEach(inNode.childNodes, function(n) {
		if (n.id)
			ids.push(n.id)
	});
	return ids;
}

dojo.declare("wm.HtmlLoader", wm.Component, {
	url: "",
	html: "",
	relativeUrl: true,
	init: function() {
		this.inherited(arguments);
		this.inherited(arguments);
		if (this.url)
			this.setUrl(this.url);
		else
			this.setHtml(this.html);
	},
	destroy: function() {
		this.html = null;
		dojo.destroy(this._htmlNode);
		this._htmlNode = null;
		this.inherited(arguments);
	},
	setUrl: function(inUrl) {
		this.url = inUrl || "";
		if (this.url) {
			var loadUrl = this.relativeUrl ? this.getPath() + this.url : this.url;
			this.setHtml(wm.load(loadUrl, true));
		}
	},
	setHtml: function(inHtml) {
		this.clearHtml();
		this.html = inHtml || "";
		if (this.html)
			this.addHtml(this.html);
		dojo.publish("wm-markupchanged");
	},
	clearHtml: function() {
		this.html = "";
		this.removeHtml();
	},
	getHtmlNode: function() {
		if (!this._htmlNode) {
			var n = this._htmlNode = document.createElement("div");
			n.style.display = "none";
			document.body.appendChild(n);
		}
		return this._htmlNode;
	},
	/*installHtml: function(inHtml) {
		var n = this.getHtmlNode();
		n.innerHTML = inHtml;
	},*/
	addHtml: function(inHtml) {
		if (this.isDesignLoaded()) {
			var p = this.getPath();
			// if relative paths to images are used in html, prepend the project design path
			// so that the image is resolved at designtime.
			inHtml = inHtml.replace(/<img([^>]*)src[^>]*=[^>]*(["'])([^(http:)\/][^>]*)\2/g, '<img$1src="' + p + '$3"');
		}
		var n = this.getHtmlNode();
		n.innerHTML = [n.innerHTML, inHtml].join("\n");
	},
	removeHtml: function() {
		var n = this.getHtmlNode();
		if (n)
			n.innerHTML = "";
	},
	listProperties: function() {
		var p = this.inherited(arguments);
		p.html.ignore = this.url;
		return p;
	},
	getNodeIds: function() {
		return wm.getNodeIds(this.getHtmlNode());
	}
});

wm.HtmlLoader.extend({
	makePropEdit: function(inName, inValue, inDefault) {
		switch (inName) {
			case "html":
				return makeReadonlyButtonEdit(inName, "(html)", "(html)");
		}
		return this.inherited(arguments);
	},
	editProp: function(inName, inValue, inInspector) {
		switch (inName) {
			case "html":
				this.showHtmlDialog();
				return;
		}
		return this.inherited(arguments);
	},
	showHtmlDialog: function() {
		var d = wm.getSyntaxEditorDialog();
		this._dialogConnect = dojo.connect(d, "onClose", this, "htmlDialogClosed");
		d.show();
		d.page.update(this.html, "html");
	},
	htmlDialogClosed: function(inWhy) {
		dojo.disconnect(this._dialogConnect);
		this._dialogConnect = null;
		if (inWhy == "OK") {
			var d = wm.getSyntaxEditorDialog();
			this.setHtml(d.page.getEditorText());
		}
	}
});

/*
wm.registerPackage(["Components", "HtmlLoader", "wm.HtmlLoader", "wm.base.components.HtmlLoader", "images/wm/content.png", ""]);
*/

}

if(!dojo._hasResource["wm.base.components.CssLoader"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["wm.base.components.CssLoader"] = true;
/*
 *  Copyright (C) 2008-2010 WaveMaker Software, Inc.
 *
 *  This file is part of the WaveMaker Client Runtime.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
dojo.provide("wm.base.components.CssLoader");

dojo.declare("wm.CssLoader", wm.Component, {
	url: "",
	css: "",
	relativeUrl: true,
	init: function() {
		this.inherited(arguments);
		if (this.url)
			this.setUrl(this.url);
		else
			this.setCss(this.css);
	},
	destroy: function () {
		this._sheet = null;
		this.inherited(arguments);
	},
	getStyleSheet: function() {
		// should we have a shared stylsheet or manage separate ones (IE has a 30 stylesheet limit)
		if (dojo.isIE && !this._sheet)
				this._sheet = wm.CssLoader.sheet || (wm.CssLoader.sheet = this.makeSheet());
		if (!this._sheet) {
			this._sheet = this.makeSheet();
		}
		return this._sheet;
	},
	makeSheet: function() {
		var sheet = document.createElement("style");
		sheet.setAttribute("type", "text/css");
	        document.getElementsByTagName("head")[0].appendChild(sheet);
	        //document.getElementbody.previousSibling.appendChild(sheet); in Firefox 4 beta, this come up as a <TextNode/>
		return sheet;
	},
	setUrl: function(inUrl) {
		this.url = inUrl || "";
		if (this.url) {
			var loadUrl = this.relativeUrl ? this.getPath() + this.url : this.url;
			this.setCss(wm.load(loadUrl, true));
		}
	},
	setCss: function(inCss) {
		this.clearCss();
		this.css = inCss || "";
		if (this.css)
			this.addCss(this.css);
	},
	/*installCss: function(inCss){
		this.removeCss();
		this.addCss(inCss);
	},*/
	clearCss: function() {
		this.css = "";
		this.removeCss();
	},
	removeCss: function() {
		// FIXME: IE uses global stylesheet so do not clear styles
		// this will be an IE limitation until addressed with better stripping logic
		if (dojo.isIE)
			return;
		var s=this.getStyleSheet();
		if (s)
			if(s.styleSheet)//IE
				s.styleSheet.cssText = "";
			else {
				while (s.firstChild)
					s.removeChild(s.firstChild);
			}
	},
	addCss: function(inCss) {
		if (this.isDesignLoaded()) {
			var p = this.getPath();
			// if relative paths to images are used in css, prepend the project design path
			// so that the image is resolved at designtime.
			inCss = inCss.replace(/url\s*\(\s*([^(http:)\/].*)\.*\)/g, "url(" + p + "$1)");
		}
		var s = this.getStyleSheet();
		if(s.styleSheet) {//IE
			s.styleSheet.cssText = [s.styleSheet.cssText, inCss].join("\n");
		} else {
			s.appendChild(document.createTextNode("\n"));
			s.appendChild(document.createTextNode(inCss));
		}
	},
	listProperties: function() {
		var p = this.inherited(arguments);
		p.css.ignore = this.url;
		return p;
	}
});

wm.getSyntaxEditorDialog = function() {
	if (!wm._syntaxEditorDialog) {
		wm._syntaxEditorDialog = new wm.PageDialog({
			name: "syntaxEditorDialog",
			owner: studio,
			contentWidth: 600,
			contentHeight: 500,
			hideControls: true,
			pageName: "SyntaxEditor"
		});
	}
	return wm._syntaxEditorDialog;
}

wm.CssLoader.extend({
	makePropEdit: function(inName, inValue, inDefault) {
		switch (inName) {
			case "css":
				return makeReadonlyButtonEdit(inName, "(css)", "(css)");
		}
		return this.inherited(arguments);
	},
	editProp: function(inName, inValue, inInspector) {
		switch (inName) {
			case "css":
				this.showCssDialog();
				return;
		}
		return this.inherited(arguments);
	},
	showCssDialog: function() {
		var d = wm.getSyntaxEditorDialog();
		this._dialogConnect = dojo.connect(d, "onClose", this, "cssDialogClosed");
		d.show();
		d.page.update(this.css, "css");
	},
	cssDialogClosed: function(inWhy) {
		dojo.disconnect(this._dialogConnect);
		this._dialogConnect = null;
		if (inWhy == "OK") {
			var d = wm.getSyntaxEditorDialog();
			this.setCss(d.page.getEditorText());
		}
	}
});

/*
wm.registerPackage(["Components", "CssLoader", "wm.CssLoader", "wm.base.components.CssLoader", "images/wm/content.png", ""]);
*/

}

if(!dojo._hasResource["wm.base.components.PageLoader"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["wm.base.components.PageLoader"] = true;
/*
 *  Copyright (C) 2008-2010 WaveMaker Software, Inc.
 *
 *  This file is part of the WaveMaker Client Runtime.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
dojo.provide("wm.base.components.PageLoader");

wm.load = function(inFile, allowCache) {
    if (djConfig.isDebug && !dojo.isFF) {
	console.info("wm.load: " + inFile);
    }
	
    return dojo.xhrGet({url: inFile, sync: true, preventCache: !allowCache}).results[0];
}

// this function will load script file on the fly and uses dojo method to this.
// if there's an error or any problem it returns false else returns true.
// Benefits of using this is that you dont have to do an eval on the js file
// as it is required for wm.load() function.
// And you dont have to put this in try catch block either since that is taken care of.
wm.dojoScriptLoader = function(uri){
	try{
		dojo._loadUri(uri);
	}catch(e){
		console.error(e);
		return false; // Boolean
	}
}

wm.gzScriptLoader = function(name){
	try{
		var path = 'resources/gzipped/';
		dojo._loadUri(path + name.replace(/[.]/g, '/') + '.js');
	}catch(e){
		console.error('error while loading gzipped file ', e);
		return false; // Boolean
	}
}

dojo.declare("wm.PageLoader", wm.Component, {
	init: function() {
		this.randomNum = new Date().valueOf();
		this.inherited(arguments);
		this._pageConnections = [];
		this.pageProps = {};
		this.cssLoader = new wm.CssLoader({owner: this, relativeUrl: false});
		this.htmlLoader = new wm.HtmlLoader({owner: this, relativeUrl: false});
	},
	// dojo.connect args without source object (first) argument.
	pageConnect: function() {
		var ctor = this.getPageCtor();
		if (ctor) {
			var args = [ctor.prototype].concat(dojo._toArray(arguments));
			this._pageConnections.push(dojo.connect.apply(dojo, args));
		}
	},
	_disconnectPage: function() {
		dojo.forEach(this._pageConnections, dojo.disconnect);
	},
	getPageCtor: function() {
		return dojo.getObject(this.className || "");
	},
	loadController: function(inName, inPath) {
		var ctor = dojo.getObject(inName);
		if (!ctor) {
			wm.dojoScriptLoader(inPath + ".js?dojo.preventCache="+ new Date().valueOf());
		        ctor = dojo.getObject(inName);
                }
                if (!ctor) {
                    app.alert("Error parsing " + inPath + ".js");
                    ctor = dojo.declare(inName, wm.Page); // so at least we can display widgets.js
		}
		return ctor;
	},
	loadSupport: function(inCtor, inPath) {
		if (!inCtor._supported) {
		    this.cssLoader.setUrl(inPath + ".css");
			inCtor.css = this.cssLoader.css;
			this.htmlLoader.setUrl(inPath + ".html");
			inCtor.html = this.htmlLoader.html;
			inCtor.html = inCtor.css = "";
			
			// We do not propertly cache the widgets.js file after its been loaded... 
			// we delete it from memory.  But dojoScriptLoader assumes we keep it in memory and refuses to reload it.
			// By deleting it from its list of loaded urls, it should always reload.
			delete dojo._loadedUrls[inPath + ".widgets.js"];
			wm.dojoScriptLoader(inPath + ".widgets.js?rand=" + new Date().valueOf());
			inCtor._supported = true;
		}
	},
	unloadSupport: function(ctor) {
		//this.cssLoader.clearCss();
		//this.htmlLoader.clearHtml();
		if (!ctor)
			ctor = this.getPageCtor();
		if (ctor) {
			ctor.css = ctor.html = "";
			ctor._supported = false;
		}
	},
	loadPageCode: function(inName) {
		//console.info('this.getpath(): ' + this.getPath());		//console.info('wm.pagesFolder: ' + wm.pagesFolder);
		
		var path = this.getPath() + wm.pagesFolder + inName + "/" + inName;
		var ctor = this.loadController(inName, path);
		if (ctor)
			this.loadSupport(ctor, path);
		return ctor;
	},
	loadPage: function(inClassName, inName) {
		inName = inName || inClassName;
		if (!inName) {
			wm.logging && console.debug("Invalid page name. Must load a valid page.");
			return;
		}

		this.previousPage = this.page;
		this.previousClassName = this.className;
		this.className = inClassName;
		var ctor = this.loadPageCode(inClassName);
		if (ctor) {
			this.onBeforeCreatePage();
			this.createPage(ctor, inName);
			this.pageChanged();
			this.unloadSupport(ctor);
		} else
			console.log("Page not found:", inClassName);
		
	},
	createPage: function(inCtor, inName) {
		var props = dojo.mixin({name: inName, owner: this.owner, domNode: this.domNode, isRelativePositioned: this.isRelativePositioned}, this.pageProps || {});
		this.page = new inCtor(props);
	},
	destroyPage: function(inPage) {
		this._disconnectPage();
		if (inPage)
			wm.fire(inPage, "destroy");
	},
	destroy: function(){
		this.destroyPage();
		delete this.cssLoader;
		delete this.htmlLoader;
		this.inherited(arguments);
		if (this.domNode)
		{
			dojo.destroy(this.domNode);
			this.domNode = null;
		}
	},
	pageChanged: function() {
		this.onPageChanged(this.page, this.previousPage);
		if (this.previousPage) {
			this.destroyPage(this.previousPage);
			delete this.previousPage;
			
			// since we are deleting previous page, we should also mark '_supported = false' because 
			// while deleting previous page we are deleting all html nodes too. 
			if (this.previousClassName)
			{
				try
				{
				var preObj = dojo.getObject(this.previousClassName);
				preObj._supported = false;
				}
				catch(e)
				{
					// do nothing.
				}
			}
		}
	},
	onBeforeCreatePage: function() {
	},
	onPageChanged: function(inNewPage, inPreviousPage) {
	}
});

}

if(!dojo._hasResource["wm.base.components.Application"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["wm.base.components.Application"] = true;
/*
 *  Copyright (C) 2008-2010 WaveMaker Software, Inc.
 *
 *  This file is part of the WaveMaker Client Runtime.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and 
 *  limitations under the License.
 */
dojo.provide("wm.base.components.Application");


wm.componentLoaders = wm.componentLoaders || {};

wm.registerComponentLoader = function(inType, inLoader){
	wm.componentLoaders[inType] = inLoader;
};

dojo.declare("wm.Application", wm.Component, {
	main: "Main",
        deletionDisabled: 1,
        projectSubVersion: 1,
        projectVersion: 1,
        studioVersion: "",
        theme: "wm_notheme",
        toastPosition: "br",
        _lastTheme: "",
    //IERoundedCorners: false,
	init: function() {
		app = wm.application = wm.application || this;
		this.connectList = [];
		this.app = this;
		this.inherited(arguments);
		wm.typeManager.initTypes();
	        this.setTheme(themematch ? themematch[1] : this.theme, true);
		this.pageDialog = new wm.PageDialog({name: "pageDialog", owner: this});
		this.toastDialog = new wm.Toast({name: "toastDialog", owner: this});
	       try{
		    this.alertDialog = new wm.GenericDialog({name: "alertDialog",
						     owner: this,
						     title: "Alert!",
						     noEscape: false,
						     width: "300px",
						     height: "180px",
						     button1Caption: "OK",
						     button1Close: true,
						     userPrompt: ""});
                this.alertDialog.domNode.style.zIndex = 45;
		   } catch(e){
		   	console.info('error while creating alert Dialog ', e);
		   }
				
		this.createPageLoader();
		this.components = {};
		this.scrim = new wm.Scrim();
	        var themematch = window.location.search.match(/theme\=(.*?)\&/) ||
		                 window.location.search.match(/theme\=(.*?)$/);

		this.loadComponents(this.constructor.widgets || this.widgets);
	},
    setTheme: function(inTheme, isInit, optionalCss, optionalPrototype, noRegen, forceUpdate) {
	    var isDesigned = (window["studio"] && this != app);
	    var node = isDesigned ? studio.designer.domNode : document.body;
	    dojo.removeClass(node, this.theme);
            this._lastTheme = this.theme;
	    this.theme = inTheme;
	    dojo.addClass(node, this.theme);
	    if (isDesigned || !isInit) {
		try {
		    this.loadThemeCss(this.theme, isDesigned, optionalCss);

		    // write before we change the prototype so defaults are left blank
		    if (isDesigned && !isInit) {
			this._themeChanged = true;
			this.cacheWidgets();
		    }
		    this.loadThemePrototype(this.theme, optionalPrototype);
		    if (isDesigned && !isInit && !noRegen) {
			this.useWidgetCache();
		    }
		} catch(e) {
		    if (inTheme != "wm_notheme")  {
			this.setTheme("wm_notheme", isInit, optionalCss, optionalPrototype, noRegen);
			app.alert("The theme '" + inTheme + "' was not found.  This can happen when importing a project that uses a theme that is not in your library.  You can download that theme and copy it into your WaveMaker/common/themes folder or go to your model, select 'Project', and pick a new theme");
		    } else  {
			app.alert("Fatal error loading theme wm_notheme.  If you see this, please contact WaveMaker support.");
		    }
		return;
		}
	    } else {
		this.loadThemePrototype(this.theme, optionalPrototype);
	    }

    },
            // don't regenerate over and over; as long as the user remains in the theme designer,
            // widgetsjs shouldn't change except as prototypes change, 
            // and we don't want the design to change each time the prototype border changes...
    cacheWidgets: function() {
        if (!this._widgetsjs) {
	    var widgetsjs = dojo.fromJson("{"+ studio.page.root.write("") + "}");
            this._widgetsjs = widgetsjs;            
        }
    },
    useWidgetCache: function() {
	studio.page.root.destroy();
        delete studio.page.root;
	studio.page.loadComponents(this._widgetsjs,null);
        delete this._widgetsjs;
	studio.page.reflow();
	studio.refreshWidgetsTree();
    },
    loadThemePrototype: function(inThemeName, optionalThemeData) {
        var themeData = wm.Application.themeData[inThemeName];
        if (!themeData || optionalThemeData) {
	    var path;
	    if (inThemeName.match(/^wm_/))
		path = dojo.moduleUrl("wm") + "base/widget/themes/" + inThemeName + "/Theme.js";
	    else
		path = dojo.moduleUrl("common") + "themes/" + inThemeName + "/Theme.js";
	    themeData = optionalThemeData || dojo.fromJson(dojo.xhrGet({url:path, sync:true, preventCache:true}).results[0]);
            wm.Application.themeData[inThemeName] = themeData || {};
        }

        var propHash = themeData["wm.Control"];
	for (var j in propHash) {
	    wm.Control.prototype[j] = propHash[j];
	}

        wm.Application.themePrototypeData = {"wm.Control":this.theme};
    
/*
	for (var i in themeData) {
	    try {
	    console.log("Set prototype of " + i);
	    var propHash = themeData[i];
	    var ctor = dojo.getObject(i);
	    if (ctor && ctor.prototype) {
		var prototype = ctor.prototype;
		for (var j in propHash) {
		    var property = propHash[j];
		    prototype[j] = propHash[j];
		}
	    } else {
		console.log("Theme Error: " + i + " not found");
	    }
	    } catch(e) {console.error("Uncaught error in themes: " + e);}
	    }
            */
    },
    loadThemePrototypeForClass: function(ctor, optionalWidget) {
        if (!this.theme || !ctor) return;

        var declaredClass = ctor.prototype.declaredClass;
        if (declaredClass == "wm.Template") declaredClass = "wm.Panel";
        if (!wm.Application.themePrototypeData[declaredClass] || wm.Application.themePrototypeData[declaredClass] != this.theme) {
            var p = ctor.prototype;
            var lastTheme = wm.Application.themePrototypeData[declaredClass];
            var oldThemeData = wm.Application.themeData[lastTheme]; // app not this; if studio is loaded, we have multiple apps; just have one of them manage this global

            // undo all changes from the last theme for this class
            if (oldThemeData) {
                var oldCtorData = oldThemeData[declaredClass];
                if (oldCtorData) 
                    for (var j in oldCtorData) {
                        delete p[j]; // deleting it lets its parent class prototype value come through (only tested in chrome...)
                        // however, for purposes of reflection/property inspection, if there is no parent class value coming through, lets give it some value.  TODO: Check its type and assign it something based on the property's type.
                        if (p[j] === undefined) 
                            p[j] = "";
			//if (optionalWidget) optionalWidget[j] = "";
                    }
            }

            // make all changes need for this theme for this class
            var themeData = wm.Application.themeData[this.theme];
            var ctorData = themeData[ctor.prototype.declaredClass];
            if (ctorData) {
	        for (var j in ctorData) {
                    ctor.prototype[j] = ctorData[j];
		    if (optionalWidget) optionalWidget[j] = ctorData[j];
                }
            }
            wm.Application.themePrototypeData[declaredClass] = this.theme;
        }
    },
    loadThemeCss: function(inThemeName, inDesign, optionalCss) {
	    var path;
	    var themecss;
	    if (inThemeName.match(/^wm_/))
		path = dojo.moduleUrl("wm") + "base/widget/themes/" + inThemeName + "/theme.css";
	    else
		   path = dojo.moduleUrl("common") + "themes/" + inThemeName + "/theme.css";
	    
	    if (inDesign) {
                var imagepath = path.replace(/\/[^\/]*$/,"/images");
                while (imagepath.match(/[^\/]+\/\.\.\//)) 
                    imagepath = imagepath.replace(/[^\/]+\/\.\.\//,"");
		var results = dojo.xhrGet({url:path, sync:true, preventCache:false}).results;
		if (results[1])
		    throw results[1];

		themecss = optionalCss || results[0] || "";
		themecss = themecss.replace(/url\s*\(\s*images/g,"url(" + imagepath);
		setCss("theme_ss", themecss);
	    } else {
		wm.headAppend(wm.createElement("link", {rel: "stylesheet", type: "text/css", href: path}));
	    }
	},
	postInit: function() {
		this.inherited(arguments);
		//this.getRuntimeService();
	},
	destroy: function() {
		wm.fire(this.scrim, "destroy");
		wm.fire(this._runtimeService, "destroy");
		this.inherited(arguments);
		dojo.forEach(this.connectList, dojo.disconnect);
		this.connectList = null;
		delete this._page;
		if (this._pageLoader)
		{
			this._pageLoader.destroy();
			this._pageLoader = null;
		}	
		
		if (this.domNode)
		{
			dojo.destroy(this.domNode);
			this.domNode = null;
		}		
		
		this.pageDialog.destroy();
		delete this.pageDialog;
		this.scrim.destroy();
		delete this.scrim;
		delete this.app;
		//dojo.publish('applicationDestroyed',[]);
	},
	createPageLoader: function() {
		this._pageLoader = new wm.PageLoader({owner: this});
		this.connectList[this.connectList.length] = this.connect(this._pageLoader, "onBeforeCreatePage", this, "beforeCreatePage");
		this.connectList[this.connectList.length] = this.connect(this._pageLoader, "onPageChanged", this, "pageChanged");
	},
	// avoid unique names when loading components
	loadComponents: function(inChildren) {
		this._loading = true;
		this.createComponents(inChildren);
		// bc only
		//this.createComponent("cssLoader", "wm.CssLoader", {owner: this, url: "app.css"});
		this._loading = false;
	},
	subPageLoaded: function(inPage) {
	  if (djConfig.isDebug) {
	    if (this.debugSubPageList === undefined) 	this.debugSubPageList = {};
	    this.debugSubPageList[inPage.name] = inPage;
	  }
	},
	subPageUnloaded: function(inPage) {
	  if (djConfig.isDebug && inPage) {
	    if (this.debugSubPageList != undefined)
	      delete(this.debugSubPageList[inPage.name]);
	  }
	},
	qualifyName: function(inName) {
		return inName;
	},
	addComponent: function(inComponent) {
		this.inherited(arguments);
		this[inComponent.name] = inComponent;
	},
	removeComponent: function(inComponent) {
		delete this[inComponent.name];
		this.inherited(arguments);
	},
	getRuntimeService: function(owner) {
		if (!this._runtimeService)
		    this._runtimeService = new wm.JsonRpcService({service: "runtimeService",
								  owner: owner});
		return this._runtimeService;
	},
	getRuntimeServiceDesignTime: function(owner) {
		if (!this._runtimeService)
		    this._runtimeService = new wm.JsonRpcService({service: "runtimeService",
								  owner: owner, designTime: true});
		return this._runtimeService;
	},
	getRoot: function() {
		return this;
	},

	getRuntimeId: function(inId) {
		return inId;
	},
	getId: function(inId) {
	    if (inId)
		return "app." + inId;
	    else
		return "app";
	},
	reflow: function() {
		var d = this.domNode;
		d.scrollTop = 0;
	},
	reflowParent: function() {
		this.reflow();
	},
	hideLoadingIndicator: function() {
		dojo._destroyElement("_wm_loading");
	},
	run: function() {
		// highlander when running
		app = wm.application = this;
		dojo.addOnLoad(dojo.hitch(this, "runOnLoad"));
	},
	runOnLoad: function() {
		// In IE6 addOnLoad is sometimes called before the dom is actually ready (bad Dojo)
		// correct here by adding a small delay.
		setTimeout(dojo.hitch(this, "doRun"), dojo.isIE < 7 ? 100 : 1);
	},
	doRun: function() {
		this._pageLoader.domNode = this.domNode = dojo.byId(this.domNode) || document.body;
		this.loadPage(app.main);
	},
	start: function() {
		//this.hideLoadingIndicator();
	},
	getServerComponents: function() {
		if (this.serverComponents === undefined) {
			this.loadServerComponents();
		}
		return this.serverComponents;
	},
	loadServerComponents: function(inComponentType) {
		if (inComponentType && this.serverComponents) {
			for (var i=0, c; c=this.serverComponents[i]; i++) {
				if (c.type == inComponentType)
					this.serverComponents.splice(i--, 1);
			}
			var cl = wm.componentLoaders[inComponentType];
			if (cl)
				this.serverComponents = this.serverComponents.concat(cl.getComponents());
		} else {
			this.serverComponents = [];
			for (var i in wm.componentLoaders) {
				this.serverComponents = this.serverComponents.concat(wm.componentLoaders[i].getComponents());
			}
		}
	},
	addServerComponent: function(inComponent) {
		this.serverComponents.push(inComponent);
	},
	removeServerComponent: function(inComponent) {
		for (var i=0, c; c=this.serverComponents[i]; i++){
			if (c == inComponent) {
				this.serverComponents.splice(i, 1);
				return i;
			}
		}
	},
	removeServerComponentByName: function(inComponentName, inComponentType) {
		for (var i=0, c; c=this.serverComponents[i]; i++){
			if (c.type == inComponentType && c.name == inComponentName) {
				this.serverComponents.splice(i, 1);
				return i;
			}
		}
	},
	beforeCreatePage: function() {
		this._pageLoader.pageConnect("start", this, "start");
		this.pageLoadedDeferred = new dojo.Deferred()
	},
	pageChanged: function(inPage, inPreviousPage) {
		// establish page reference
		this._page = inPage;
		var n = inPage.name, o = (inPreviousPage || 0).name;
		// clean up previous reference
		if (o) {
		    // delete window[o]; Kana reported problems with this in IE so replacing with setting it to undefined
		    window[o] = undefined;
		    delete this[o];
		}
		window[n] = this[n] = this._page;
		// change callback / event
		if (this.pageLoadedDeferred)
			this.pageLoadedDeferred.callback({page: inPage, previousPage: inPreviousPage});

            // Insures only the main page gets the keydown events unless end user hacks their own
	    this.connect(document, "keydown", inPage, "keydown");

		this.onPageChanged(inPage, inPreviousPage);
	},
	loadPage: function(inName) {
            this._pageName = inName;
		//this._pageLoader.unloadSupport();
		try 
		{
			this._pageLoader.loadPage(inName, inName.toLowerCase());
		}
		catch (e)
		{
			// do nothing
		  if (djConfig.isDebug)
		    console.error("loadPage error: " + e);
		}
		finally 
		{
			this.hideLoadingIndicator();
		}
	},
        // Provided for use in debugging. Note that when we do a better job of caching pages from server, we will need to deallocate them in this call
        forceReloadPage: function() {
            this.loadPage(this._pageName);
        },
	onPageChanged: function(inNewPage, inPreviousPage) {
	},
        getFullVersionNumber: function() {
	    return this.projectVersion + "." + this.projectSubVersion;
	},
        alert: function(inText, nonmodal) {
	    if (dojo.isObject(inText))
		inText = inText.toString();
	    nonmodal = Boolean(nonmodal);
	    this.alertDialog.setUserPrompt(inText);
	    this.alertDialog.setModal(!nonmodal);
	    this.alertDialog.show();
	},

        confirmOKFunc: null,
        confirmCancelFunc: null,
    confirm: function(inText, nonmodal, onOKFunc, onCancelFunc, optionalOKText,optionalCancelText, noshow) {
            if (!this.confirmDialog) {
	        this.confirmDialog = new wm.GenericDialog({name: "confirmDialog",
						           owner: this,
						           noEscape: false,
						           width: "350px",
						           height: "180px",
						           button1Caption: "OK",
						           button1Close: true,
						           button2Caption: "Cancel",
						           button2Close: true,
						           userPrompt: "confirm..."});
                this.confirmDialog.domNode.style.zIndex = 50;
                this.confirmDialog.connect(this.confirmDialog, "onButton1Click", this,"confirmDialogOKClick");
                this.confirmDialog.connect(this.confirmDialog, "onButton2Click", this,"confirmDialogCancelClick");
            }
	    nonmodal = Boolean(nonmodal);
	    this.confirmDialog.setUserPrompt(inText);
	    this.confirmDialog.setModal(!nonmodal);
            this.confirmDialog.setShowInput(false);
	    this.confirmDialog.setTitle("Confirm..."),
            this.confirmOKFunc = onOKFunc;
            this.confirmCancelFunc = onCancelFunc;
            this.confirmDialog.setButton1Caption(optionalOKText || "OK");
            this.confirmDialog.setButton2Caption(optionalCancelText || "Cancel");
            if (!noshow)
	        this.confirmDialog.show();
        },
    prompt: function(inText, inDefaultValue, onOKFunc, onCancelFunc, optionalOKText,optionalCancelText) {
        this.confirm(inText, false, onOKFunc, onCancelFunc, optionalOKText, optionalCancelText, true);
        this.confirmDialog.setShowInput(true);
	    this.confirmDialog.setTitle("Prompt..."),
        this.confirmDialog.setInputDataValue(inDefaultValue || "");
        this.confirmDialog.show();
    },
    confirmDialogOKClick: function() {
        if (this.confirmDialog.showInput) {
            var val = this.confirmDialog.getInputDataValue();
            if (!val)
                return this.confirmDialogCancelClick();
            else if (this.confirmOKFunc)
                this.confirmOKFunc(val);
        } else {
            if (this.confirmOKFunc)
                this.confirmOKFunc();
        }
    },
    confirmDialogCancelClick: function() {
        if (this.confirmCancelFunc)
            this.confirmCancelFunc();
    },
    toastError: function(inMsg) {
        this.toastDialog.showToast(inMsg, 8000, "Error");
    },
    toastWarning: function(inMsg) {
        this.toastDialog.showToast(inMsg, 8000, "Warning");
    },
    toastSuccess: function(inMsg) {
        this.toastDialog.showToast(inMsg, 5000, "Success");
    },
    toastInfo: function(inMsg) {
        this.toastDialog.showToast(inMsg, 5000, "Info");
    },
    createMinifiedDialogPanel: function() {
	this.wmMinifiedDialogPanel = new wm.Panel({name: "wmMinifiedDialogPanel", width: this._page.root.bounds.w + "px", height: "25px", border: "2,0,0,0", padding: "2", autoScroll: true, verticalAlign: "top", horizontalAlign: "left", layoutKind: "left-to-right"});
	document.body.appendChild(this.wmMinifiedDialogPanel.domNode);
	this.wmMinifiedDialogPanel.subscribe("window-resize", this, "resizeMinifiedDialogPanel");
	this.resizeMinifiedDialogPanel();
    },
    createMinifiedDialogLabel: function(title) {
	var l = new wm.Button({caption: title, parent: app.wmMinifiedDialogPanel, owner: this, width: "100px", height: "100%", margin: "0", padding: "0"});
	app.wmMinifiedDialogPanel.show();
	return l;
    },
    removeMinifiedDialogLabel: function(minifiedLabel) {
	minifiedLabel.destroy();
	this.wmMinifiedDialogPanel.setShowing(Boolean(this.wmMinifiedDialogPanel.c$.length));
    },
    resizeMinifiedDialogPanel: function() {
	var b = {l: 0,
		 t: this._page.root.bounds.h - this.wmMinifiedDialogPanel.bounds.h,
		 w: this._page.root.bounds.w,
		 h: 25};
	this.wmMinifiedDialogPanel.setBounds(b);
	this.wmMinifiedDialogPanel.renderBounds();
    }
});

wm.Application.extend({
    firstThemeChange: true,
/*
    set_theme: function(inTheme) {
        if (this.firstThemeChange) {
            app.confirm("Sometimes data can be lost when changing themes.  Do you want to save your project before changing themes?", true,
			dojo.hitch(this, function() {
			    studio.project.saveProject();
			    this.firstThemeChange = false;
			    this.setTheme(inTheme);
			}),
			dojo.hitch(this, function() {
			    this.firstThemeChange = false;
			    this.setTheme(inTheme);
			}),
			"Save and Change",
			"Change Only");

	} else {
	    this.setTheme(inTheme);
	}
    },
*/

	write: function(inIndent) {
	    var props = dojo.toJson(this.writeProps(),true);
	    props = props.substring(1,props.length-2);


	    var compsArray = this.writeComponents(inIndent);

	    var classOrdering = ["wm.TypeDefinition", "wm.LiveView"];

	    compsArray = compsArray.sort(function(a,b) {
		var alist = a.match(/^(.*?)\:\s*\[\"(.*?)\"/);
		var blist = b.match(/^(.*?)\:\s*\[\"(.*?)\"/);
		var aindex = dojo.indexOf(classOrdering, alist[2]);
		var bindex = dojo.indexOf(classOrdering, blist[2]);
		if (aindex == -1) aindex = classOrdering.length;
		if (bindex == -1) bindex = classOrdering.length;
		if (aindex == bindex)
		    return (alist[1] <= blist[1]) ? -1 : 1;
		else
		    return (aindex < bindex) ? -1 : 1;

	    });

	    var comps = compsArray.join(", " + sourcer_nl);
	
	    var customsrc = String(studio.getAppScript()).trim() || studio.project.projectName + ".extend({\n\n\t" + terminus + "\n});";
	    var src = 'dojo.declare("' + this.declaredClass + '", wm.Application, {' +
		props + ",\n\t" + 
		    '"widgets": {\n' +  (comps || "") + '\n\t},\n\t' +
		terminus + "\n});\n\n" + // terminus is defined in events.js
		customsrc;

	    return src;
	},
    setToastPosition: function(inPosition) {
        this.toastPosition = inPosition.replace(/top/, "t").replace(/bottom/,"b").replace(/left/,"l").replace(/right/,"r").replace(/center/,"c").replace(/ /,"");
    },
    makePropEdit: function(inName, inValue, inDefault) {
	switch (inName) {
	case "main":
	    return new wm.propEdit.PagesSelect({component: this, name: inName, value: inValue, currentPageOK: true});
	case "theme":
            var options = [];
            var data = studio.themesListVar.getData();
            dojo.forEach(data, function(item) {options.push(item.dataValue);});
	    return new wm.propEdit.Select({component: this, value: inValue, name: inName, options: options});
        case "toastPosition":
            inValue = inValue.replace(/^c/, "center ").replace(/^t/, "top ").replace(/^b/, "bottom ").replace(/l$/, "left").replace(/r$/, "right").replace(/c$/, "center");
            return new wm.propEdit.Select({component: this, value: inValue, name: inName, options: ["top left", "top center", "top right", "center left", "center center", "center right", "bottom left", "bottom center", "bottom right"]});
	}
	return this.inherited(arguments);
    },
    setMain: function(inMain) {
	this.main = inMain;
	studio.setProjectMainPage(inMain);
    },
    incSubversionNumber: function() {
	if (dojo.isString(this.projectSubVersion)) {
	    if (parseInt(this.projectSubVersion) + "" == this.projectSubVersion)
		this.projectSubVersion = parseInt(this.projectSubVersion) + 1;
	    else {
		var result = this.projectSubVersion.match(/\d+$/);
		if (result) {
		    this.projectSubVersion = this.projectSubVersion.replace(/\d+$/, "");
		    result = parseInt(result[0]) + 1;
		    this.projectSubVersion += result;
		} else {
		    this.projectSubVersion += "0";
		}
	    }
	} else
	    this.projectSubVersion++;
    }
});
wm.Object.extendSchema(wm.Application, {
    name: {ignore: 1}, // at some point, we might provide this as a way to rename the project... but renaming is really a server side op, so requires confirmation. 
    main: {shortname: "mainPageName"},
    promptChromeFrame: {shorname: "chromeFrame (NA)"},
    theme: {type: "string"},
    //IERoundedCorners: {type: "boolean"},
    studioVersion: {writeonly: true, type: "string"},
    projectVersion: {type: "string"},
    projectSubVersion: {type: "string"},
    firstThemeChange: {ignore: true},
    documentation: {ignore: true},
    generateDocumentation: {ignore: true}
});


wm.Application.themePrototypeData = {};
wm.Application.themeData = {};			    

}

if(!dojo._hasResource["wm.base.components.Binding"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["wm.base.components.Binding"] = true;
/*
 *  Copyright (C) 2008-2010 WaveMaker Software, Inc.
 *
 *  This file is part of the WaveMaker Client Runtime.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
dojo.provide("wm.base.components.Binding");



dojo.declare("wm.Wire", wm.Component, {
	expression: "",
	source: "",
	targetProperty: "",
	targetId: "",
	destroy: function() {
		this.disconnectWire();
		this.inherited(arguments);
	},
	/*
	init: function() {
		this.inherited(arguments);
		this.target = this.targetId ? this.getRoot().getValueById(this.targetId) : this.owner.owner;
		if (!this.target) {
			console.info("wm.Wire.init(): bad target: " + this.targetId + " (" + this.owner.owner.name + ")");
			this.bad = true;
			return;
		}
		// make sure binding is fully added to owner before updating values.
		if (this.owner)
			this.owner._addWire(this);
		this.connectWire();
	},
	*/
	setExpression: function(inExpression) {
		this.expression = inExpression || "";
		this.connectWire();
	},
	setSource: function(inSource) {
		this.source = inSource;
		this.connectWire();
	},
	setTargetProperty: function(inTargetProperty) {
		this.targetProperty = inTargetProperty;
		this.connectWire();
	},
	getFullTarget: function() {
		return this.target.getId() + "." + this.targetProperty;
	},
	// FIXME: if one of our source is the target's targetProperty, then will generate an infinite loop
	// this should never happen unless the user sets up an expression.
	canSetValue: function() {
		if (this.expression) {
			var sources = wm.expression.getSources(this.expression), ft = this.getFullTarget();
			for (var i=0, s; (s=sources[i]); i++)
				if (s == ft) {
					wm.logging && console.debug("Wire:", ft, "cannot be set because the target is an expression source");
					return false;
				}
		}
		return true;
	},
	_sourceValueChanged: function(inValue) {
		if (wm.bindingsDisabled)
			return;
		inValue = this.expression ? wm.expression.getValue(this.expression, this.getRoot()) : inValue;
		if (this.canSetValue())
			this.target.setValue(this.targetProperty, inValue);
	},
	sourceValueChanged: function(inValue, inV2) {
		wm.logging && console.info("==> (sourceValueChanged) ", this.getFullTarget(), " <= ", this.source, "(" + inValue + ")");
		this._sourceValueChanged(inValue);
		//wm.logging && console.groupEnd();
	},
	sourceTopUpdated: function(inSource, inId) {
		wm.logging && console.info("==> (sourceTopUpdated) ", this.getFullTarget(), " <= ", inSource);
		//if (wm.bindingsDisabled)
		//	return;
		//wm.logging && console.info("==> (top) ", this.source, "=>", this.getFullTarget(), " Wire.sourceTopUpdated");
		//if (this.expression || this.source.indexOf(inSource)==0) {
			this.refreshValue();
		//}
	},
	sourceRootUpdated: function() {
		// root updated is a special binding situation where we just want to check the value of the source
		// to give it a chance to create itself (this is currently necessary for Variable lazy loading)
		wm.logging && console.info("==> (sourceRootUpdated)", this.source);
		this.getValueById(this.source);
	},
	refreshValue: function() {
		//wm.logging && console.info("==> (refresh) ", this.source, "=>", this.getFullTarget(), " Wire.refreshValue");
		this._sourceValueChanged(this.getValueById(this.source));
		//wm.logging && console.groupEnd();
	},
	disconnectWire: function() {
		//wm.logging && console.debug("Wire: ", this.target.getId() + "." + this.targetProperty, "[disconnected from]", this.source);
		this._disconnect();
		this._unsubscribe();
	},
	_watch: function(inSource, inRid) {
		wm.logging && console.info("Wire._watch: ", this.target.getId() + "." + this.targetProperty, "watching", inSource);
		// Rule 1: listen to "changed" on our source
		var pre = inSource.indexOf("app.") == 0 ? "" : inRid;
		var topic = pre + inSource + "-changed";
		this.subscribe(topic, this, "sourceValueChanged")
		wm.logging && console.info("***", " subscribed to [", topic, "]");
		/*
		var p = inSource.split("."), top = p.shift();
		if (top == "app" && p.length)
			top += "." + p.shift();
		topic = pre + top + "-ownerChanged"
		*/
		// Rule 2: listen to "ownerChanged" on source's owner
		// (should be only for Variable sources, which we can't actually identify right now)
		var oid = inSource.split(".");
		oid.pop();
		oid = oid.join(".");
		if (oid && oid != "app") {
			topic = pre + oid + "-ownerChanged"
			this.subscribe(topic, this, "sourceTopUpdated")
			wm.logging && console.info("***", " subscribed to [", topic, "]");
			//
			// Rule 3: listen to "rootChanged" on source's owner root
			// (again, should be only for Variable sources, to make sure objects exist for lazy loading...)
			var p = inSource.split("."), rootId = p.shift();
			if (rootId == "app" && p.length)
				rootId += "." + p.shift();
			if (rootId != oid) {
				topic = pre + rootId + "-rootChanged"
				this.subscribe(topic, this, "sourceRootUpdated")
				wm.logging && console.info("Wire._watch: ", this.source, " subscribed to ", topic);
			}
			//
		}
	},
	connectWire: function() {
		this.disconnectWire();
		this.target = this.target || (this.targetId ? this.getRoot().getValueById(this.targetId) : this.owner.owner);
		if (!this.target) {
			console.info("wm.Wire.init(): bad target: " + this.targetId + " (" + this.owner.owner.name + ")");
			this.bad = true;
			return;
		}
		if (this.targetProperty && (this.source || this.expression)) {
			this.subscribe("wmwidget-idchanged", this, "wireChanged");
			// Figure out runtimeId from context. Key: referenced object must be a child of target's root.
			var rid = this.getRootId();
			if (this.expression) {
				dojo.forEach(wm.expression.getSources(this.expression), dojo.hitch(this, function(s) {
					this._watch(s, rid);
				}));
			} else {
				this._watch(this.source, rid);
			}
			//if (this.targetProperty == "dataStoreName") 
			//	console.info("Wire: ", this.target.getId() + "." + this.targetProperty, "[connected to]", this.source, "via", rid + this.source + '-changed');
			this.refreshValue();
		}
	},
	changeExpressionId: function(inOldId, inNewId) {
		var
			e = this.expression;
			o = "\\${" + inOldId.replace(new RegExp("\\.", "g"), "\\.");
			n = "${" + inNewId,
			r = (e.match(o + "[\\.|}]"));
		e = e.replace(new RegExp(o + "\\.", "g"), n + ".");
		e = e.replace(new RegExp(o + "}", "g"), n + "}");
		this.expression = e;
		return r;
	},
	// check if a wire needs to be updated and redo it if necessary.
	// to match, the checkId should start 
	isPartialId: function(inId, inIdPart) {
		return (inId.indexOf(inIdPart) == 0) && (inIdPart.length == inId.length || inId.charAt(inIdPart.length) == ".");
	},
	// for id checking, convert id to rtId if it's not app level
	isPartialRootId: function(inId, inChangeRtId) {
		if (!inId)
			return;
		inId = inId.match("^app\.") ? inId : this.getRootId() + inId;
		return this.isPartialId(inId, inChangeRtId);
	},
	getWireId: function() {
		return (this.targetId ? this.targetId + "." : "") + this.targetProperty;
	},
	wireChanged: function(inOldId, inNewId, inOldRtId, inNewRtId) {
		var changed, wireId = this.getWireId();
		// expression
		if (this.expression)
			changed = this.changeExpressionId(inOldId, inNewId);
		// source
		if (this.isPartialRootId(this.source, inOldRtId)) {
			changed = true;
			this.source = inNewId + this.source.slice(inOldId.length);
		}
		// targetProperty
		if (this.isPartialRootId(this.targetProperty, inOldRtId)) {
			changed = true;
			this.targetProperty = inNewId + this.targetProperty.slice(inOldId.length);
		}
		// targetId
		if (this.isPartialRootId(this.targetId, inOldRtId)){
			changed = true;
			this.targetId = inNewId + this.targetId.slice(inOldId.length);
		}
		if (changed) {
			this.connectWire();
			if (this.owner && this.owner.wires) {
				delete this.owner.wires[wireId];
				this.owner.wires[this.getWireId()] = this;
			}
		}
	}
});

wm.Object.extendSchema(wm.Wire, {
	expression: {},
	source: {},
	targetProperty: {},
	targetId: {}
});

dojo.declare("wm.Binding", wm.Component, {
	constructor: function(inProps) {
		this.wires = {};
	},
	destroy: function() {
		this.removeWires();
		this.inherited(arguments);
	},
	loaded: function() {
		for (var i in this.components) {
			var c = this.components[i];
			this.wires[c.getWireId()] = c;
			c.connectWire();
		}
		this.inherited(arguments);
	},
	refresh: function() {
		wm.forEachProperty(this.wires, function(w) { w.refreshValue(); });
	},
	addWire: function(inTargetId, inTargetProperty, inSource, inExpression) {
		var id = (inTargetId ? inTargetId + "." : "") + inTargetProperty;
		this.removeWire(id);
		var props = {
			// FIXME: remove need for unique name here.
			name: this.getUniqueName("wire"),
			owner: this,
			targetId: inTargetId,
			targetProperty: inTargetProperty,
			source: inSource,
			expression: inExpression
		};
		var wire = this.wires[id] = new wm.Wire(props);
		wire.connectWire();
	},
	// for greater control, optionally removal only occurs if source and/or expression match arguments
	removeWire: function(inWireId, inSource, inExpression) {
		var wire = this.wires[inWireId];
		if (wire) {
			var 
				s = inSource == undefined || inSource == wire.source,
				e = inExpression == undefined || inExpression == wire.expression;
			if (s && e) {
				wire.destroy();
				delete this.wires[inWireId];
			}
		}
	},
	findWiresByProps: function(inProps) {
		var match = function(w) {
			for (var i in inProps)
				if (inProps[i] != w[i])
					return;
			return true;
		};
		return this.findWires(match);
	},
	findWires: function(inMatchFunc) {
		var f = [];
		if (inMatchFunc)
			wm.forEachProperty(this.wires, function(w) {
				if (inMatchFunc(w))
					f.push(w);
			});
		return f;
	},
	removeWireByProps: function(inProps) {
		var wires = this.findWiresByProps(inProps);
		this.removeWiresList(wires);
	},
	removeWireList: function(inWires) {
		dojo.forEach(inWires, dojo.hitch(this, function(w) {
			this.removeWire(w.getWireId());
		}));
	},
	removeWires: function() {
		wm.forEachProperty(this.wires, function(w) { w.destroy(); });
		this.wires = {};
	},
	write: function(inIndent) {
		return !wm.isEmpty(this.wires) ? this.inherited(arguments): null;
	}
});

}

if(!dojo._hasResource["wm.base.components.LiveView"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["wm.base.components.LiveView"] = true;
/*
 *  Copyright (C) 2008-2010 WaveMaker Software, Inc.
 *
 *  This file is part of the WaveMaker Client Runtime.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
dojo.provide("wm.base.components.LiveView");



// View related utitlities
wm.getViewField = function(inTypeSchema, inPropName) {
	if (inTypeSchema) {
		var propInfo = wm.typeManager.getPropertyInfoFromSchema(inTypeSchema, inPropName);
		return {
			caption: wm.capitalize(inPropName.split(".").pop()),
			sortable: true,
			dataIndex: inPropName,
			type: propInfo.type,
			displayType: wm.getPrimitiveDisplayType(propInfo.type),
			required: propInfo.required,
			readonly: dojo.indexOf(propInfo.noChange, "read") >= 0,
			includeLists: true,
			includeForms: true,
			order: propInfo.fieldOrder
		};
	}
}

wm.getDefaultView = function(inTypeName, inPropertyPath) {
	inPropertyPath = inPropertyPath || "";
	var
		v = [], tm = wm.typeManager,
		schema = tm.getTypeSchema(inTypeName),
		propSchema = inPropertyPath ? tm.getTypeSchema(tm.getPropertyInfoFromSchema(schema, inPropertyPath).type) : schema,
		fields = wm.typeManager.getSimplePropNames(propSchema);
		wm.forEach(fields, function(f) {
			v.push(wm.getViewField(schema, (inPropertyPath ? inPropertyPath + "." : "") + f));
		});
	return v;
}

/**
	Component that provides information about live service, datatype,
	related objects, and field information.
	@name wm.LiveView
	@class
	@extends wm.Component
*/
dojo.declare("wm.LiveView", wm.Component, {
	/** @lends wm.LiveView.prototype */
	/** Name of the service on which this view operates. */
	service: "",
	/** Fully qualified data type we operate on. */
	dataType: "",
	/** Fields to fetch */
	related: [],
	/** Fields to display */
	view: [],
	constructor: function() {
		this.related = [];
		this.view = [];
	},
	init: function() {
		this.inherited(arguments);
		this.setDataType(this.dataType);
	},
	loaded: function() {
		this.inherited(arguments);
		this.viewChanged();
	},
	viewChanged: function() {
		dojo.publish(this.getRuntimeId() + "-viewChanged", [this.getId()]);
	},
	createDefaultView: function() {
		this.setFields(this.related || [], wm.getDefaultView(this.dataType));
	},
	getRelatedFields: function(){
		if (!this.related || this.related.length == 0)
			this.related = this.getRequiredRelatedFields();
		return this.related || [];
	},
	getRequiredRelatedFields: function(){
		try
		{
			var ts = [];
			var schema = wm.typeManager.getTypeSchema(this.dataType);
			for (var i in schema) {
				var field = schema[i];
				var isRelatedField = wm.typeManager.isStructuredType(field.type);
				if (isRelatedField && field.required)
				{
					this.addRelated(i);
					ts.push(i);
				}
			}
			
			return ts;
		}
		catch(e)
		{
			console.info('error finding required fields.', e);
		}
		
		return [];
	},
	setFields: function(inRelated, inView) {
		this.related = inRelated;
		this._sortView(inView);
		this.view = inView;
	},
	getFieldIndex: function(inField) {
		var di = dojo.isObject(inField) ? inField.dataIndex : inField;
		for (var i=0, view=this.view, f; f=view[i]; i++)
			if (f.dataIndex == di)
				return i;
		return -1;
	},
	hasField: function(inField) {
		return (this.getFieldIndex(inField) > -1);
	},
	getRelatedIndex: function(inRelated) {
		for (var i=0, related=this.related, r; r=related[i]; i++)
			if (r == inRelated)
				return i;
		return -1;
	},
	hasRelated: function(inRelated) {
		return (this.getRelatedIndex(inRelated) > -1);
	},
	addField: function(inField) {
		var f = inField && wm.getViewField(wm.typeManager.getTypeSchema(this.dataType), inField);
		if (f && !this.hasField(f)) {
			this.view.push(f)
			this._sortView(this.view);
		}
		return f;
	},
	removeField: function(inField) {
		var i = this.getFieldIndex(inField);
		if (i > -1)
			this.view.splice(i, 1);
	},
	addRelated: function(inRelated) {
		if (inRelated && !this.hasRelated(inRelated)) {
			this.related.push(inRelated);
			this.addRelatedDefaultView(inRelated);
		}
	},
	removeRelated: function(inRelated) {
		var i = this.getRelatedIndex(inRelated);
		if (i > -1)
			this.related.splice(i, 1);
	},
	addRelatedDefaultView: function(inRelated) {
		var relatedFields = wm.getDefaultView(this.dataType, inRelated);
		dojo.forEach(relatedFields, function(f) {
			if (!this.hasField(f))
				this.view.push(f);
		}, this);
		this._sortView();
	},
	
	_sortView: function(inView) {
		if (dojo.isArray(inView)) {
			var t = this.dataType;
			// sort view by order or alpha place property chain
			inView.sort(function(a, b) {
				// if either has order, compare by order
				if (wm.isNumber(a.order) || wm.isNumber(b.order)) {
					return wm.compareNumbers(a.order, b.order);
				// otherwise compare by "shallowest" or alpha
				} else {
					a = a.dataIndex;
					b = b.dataIndex;
					var al = a.split(".").length, bl = b.split(".").length;
					return al == bl ? wm.data.compare(a, b) : wm.compareNumbers(al, bl);
				}
			});
		}
	},
	_copyView: function(inView) {
		var view = [];
		for (var i=0, v; (v=inView[i]); i++)
			view.push(dojo.mixin({}, v));
		return view;
	},
	getViewById: function(inLiveViewId) {
		if (inLiveViewId instanceof wm.LiveView)
			return inLiveViewId;
		else if (inLiveViewId)
			return this.getRoot().app.getValueById(inLiveViewId);
	},
	copyLiveView: function(inLiveView) {
		var lv = this.getViewById(inLiveView);
		if (lv) {
			this.setService(lv.service);
			this.setDataType(lv.dataType);
			var v = this._copyView(lv.view);
			this.setFields(lv.related, v);
		} else
			this.clearView();
	},
	clearView: function() {
		this.setService("");
		this.setDataType("");
		this.setFields([], []);
	},
	setService: function(inService) {
		this.service = inService;
	},
	//$ Set the dataType for the dataView. This is a type that supports crud operations.
	setDataType: function(inType) {
		var t = this.dataType;
		this.dataType = inType;
		if (t != this.dataType)
			this.dataTypeChanged();
		if (this._defaultView)
			this.createDefaultView();
	},
	dataTypeChanged: function() {
		// FIXME: we need to do something smart here. changing the datatype should probably zot
		// the view info and may need to inform things bound to this and/or update.
		this.related = [];
		this.view = [];
	},
	hasRelatedProp: function(inRelatedProp) {
		for (var i=0, related=this.related, r; (r=related[i]); i++)
			if (r == inRelatedProp)
				return true;
	},
	getListView: function(inPropPath) {
		var schema = wm.typeManager.getTypeSchema(this.getSubType(inPropPath));
		return dojo.filter(this.getSubView(inPropPath), function(v) {
			return !wm.typeManager.isPropInList(schema, v.dataIndex);
		})
	},
	// get the type of a property path from our dataType
	getSubType: function(inPropPath) {
		if (inPropPath) {
			var schema = wm.typeManager.getTypeSchema(this.dataType);
			return (schema && (wm.typeManager.getPropertyInfoFromSchema(schema, inPropPath) || 0).type) || this.dataType;
		} else
			return this.dataType;
	},
	// get a related list starting at inPropPath
	getSubRelated: function(inPropPath) {
		inPropPath = inPropPath ? inPropPath + "." : "";
		if (inPropPath) {
			var list = [], l = inPropPath.length;
			dojo.forEach(this.related, function(r) {
				if (r.indexOf(inPropPath) == 0)
					list.push(r.substring(l));
			});
			return list;
		} 
		else
			return this.related;
	},
	// get a view starting at inPropPath
	getSubView: function(inPropPath) {
		inPropPath = inPropPath ? inPropPath + "." : "";
		var view = this._copyView(this.view);
		if (inPropPath) {
			var list = [], l = inPropPath.length;
			dojo.forEach(view, function(v) {
				if (v.dataIndex.indexOf(inPropPath) == 0) {
					v.dataIndex = v.dataIndex.substring(l);
					list.push(v);
				}
			});
			return list;
		} else
			return view;
	}
});

wm.Object.extendSchema(wm.LiveView, {
	related: { ignore: 1, writeonly: 1 },
	view: { ignore: 1, writeonly: 1 },
	service: { ignore: 1, writeonly: 1 },
	dataType: {ignore: 1, writeonly: 1}
});

}

if(!dojo._hasResource["wm.base.components.Variable"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["wm.base.components.Variable"] = true;
/*
 *  Copyright (C) 2008-2010 WaveMaker Software, Inc.
 *
 *  This file is part of the WaveMaker Client Runtime.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at 
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
dojo.provide("wm.base.components.Variable");


// FIXME: because we cannot guarantee the global "app" is a component's application 
// (because studio has an app) and the runtimeService must be local to a project
// get the app corresponding to the given component.
wm.getRuntimeService = function(inComponent) {
	var a = dojo.getObject("studio.wip.app") || app;
	return wm.fire(a, "getRuntimeService");
};

wm.getRuntimeServiceDesignTime = function(inComponent) {
	var a = dojo.getObject("studio.wip.app") || app;
	return wm.fire(a, "getRuntimeServiceDesignTime");
};

/**
	Base class for all data handling components.
	@name wm.Variable
	@class
	@extends wm.Component
*/
dojo.declare("wm.Variable", wm.Component, {
	/** @lends wm.Variable.prototype */
	json: "",
	/** 
		Type of data stored in the variable, or type of each item in the list.
		@type String
	*/
	type: "",
	/** 
		True if this variable contains a list (aka array).
		@type Boolean
	*/
	isList: false,
	_updating: 0,
	_dataSchema: {},
	_greedyLoadProps: false,
	_allowLazyLoad: true,
	cursor: 0,
	constructor: function() {
		this.subscribe("wmtypes-changed", this, "wmTypesChanged");
	},
	postInit: function() {
		this.inherited(arguments);
		// optimization: we should never need bindings on subNards so not creating them
		if (!this._subNard && !this.$.binding)
			new wm.Binding({name: "binding", owner: this});
		this.setType(this.type);
		if (this.json)
			this.setJson(this.json);
		else
			this._clearData();
		// need to reinitialize after type is set
		if (!this._updating && this.$.binding)
			this.$.binding.refresh();
	},
	//===========================================================================
	// Type Information
	//===========================================================================
	wmTypesChanged: function() {
		if (this.isPrimitive || wm.typeManager.isType(this.type))
			this.setType(this.type);
	},
	canSetType: function(inType) {
		// type is locked to dataSet type if it is set
		if (this.dataSet) {
			wm.logging && console.debug(this.name, "cannot set variable type because this variable has a dataSet");
			return;
		}
		return true;
	},
	setType: function(inType) {
                this.unsubscribe("TypeChange-" + this.type);
		if (!this.canSetType(inType))
			return;
		
		var t = inType;
		if (wm.isListType(t)) {
			this.isList = true;
			t = t.slice(1, -1);
		// don't reset isList if we have data
		} else if (!(this.data && this.data.list))
			this.isList = false;

		this.type = t;
		//
		if (this._proxy)
			this._proxy.setType(this.type);
		this.typeChanged(this.type);
            if (this.isDesignLoaded()) {
                this.subscribe("TypeChange-" + inType, dojo.hitch(this, function() {
                    this.setType(inType); // reset the type if the type definition has changed
                    // Reevaluate the json for the new type
                    if (this.json)
                        this.setJson(this.json);
                }));
            }
	},
	typeChanged: function(inType) {
		var t = inType;
		var primitive = wm.typeManager.getPrimitiveType(t) || !t || t == "wm.Variable";
		this.isPrimitive = Boolean(primitive);
		var schema = this._getSchemaForType(t);
		if (schema)
			this.setDataSchema(schema);
	},
	_getSchemaForType: function(inType) {
		var p = wm.typeManager.getPrimitiveType(inType);
		if (this.isPrimitive) {
			// we're a string primitive by default
			return {dataValue:{type: p || 'String'/*, isList:this.isList*/}};
		} else {
			return wm.typeManager.getTypeSchema(inType) || {dataValue:{type: p || 'String', isList:this.isList}};
		}
	},
	setDataSchema: function(inSchema) {
		this._dataSchema = inSchema;
	},
	setJson: function(inJson) {
		this.json = inJson;
		try { 
			var d = eval("(" + inJson + ")");
			this.setData(d);
		} catch(e) {
		  console.error("Json error in " + this.name + ": " + e);
		}
	},
	hasList: function() {
		return this.data && ("list" in this.data);
	},
	getDataTypeInfo: function(inProp) {
		return this._dataSchema[inProp];
	},
	listDataProperties: function() {
		var list = this._listSchemaProperties({}, this._dataSchema, "getDataTypeInfo");
		for (var i in list) { 
			list[i].bindable = true; 
		};
		return list;
	},
	//===========================================================================
	// Update Buffering
	//===========================================================================
	beginUpdate: function() {
		this._updating++;
	},
	endUpdate: function() {
		this._updating--;
	},
	isUpdating: function() {
		return this._updating > 0;
	},
	//===========================================================================
	// Data API
	//===========================================================================
	/**
		Clear all data values.
	*/
	clearData: function() {
		this._clearData();
		this.setType(this.type);
		this.notify();
	},
	_clearData: function() {
		this._isNull = false;
		this._nostub = false;
		if (!this.data)
			this.data = {};
		if (this.isList)
			this.data = {list: []};
		else {
			// maintain any subNards, but otherwise clear data
			var d;
			for (var i in this.data) {
				d = this.data[i];
				if (d instanceof wm.Variable)
					d._clearData();
				else
					delete this.data[i];
			}
		}
	},
	_setNull: function(inNull) {
		this._isNull = inNull;
		// owner null can be unset but not set. consequence: all null values != null
		if (!inNull && this._subNard && this.owner) {
			this.owner._setNull(inNull);
		}
	},
	/**
		Copy data into this variable.<br/>
		<br/>
		Input data can be a primitive value, an array, a plain old JavaScript object (POJSO), or a wm.Variable.
		Success of setData requires that the type of the input is compatible with the type of this variable.
		@param {Any} inData Input data.
	*/
	// NB: input can be a POJSO or a Variable
	setData: function(inData) {
	        this.onPrepareSetData(inData);
		if (inData instanceof wm.Variable)
			this._setVariableData(inData);
		else if (dojo.isArray(inData))
			this._setArrayData(inData);
		else if (this.isPrimitive)
			this._setPrimitiveData(inData);
		else
			this._setObjectData(inData);
		this.notify();
		this.onSetData();
	},
	onPrepareSetData: function(inData) {
	},
	onSetData: function() {},
	notify: function() {
		this.dataOwnerChanged();
		this.dataChanged();
	},
	_setPrimitiveData: function(inValue) {
		this.data = { dataValue: inValue };
		this.isList = false;
	},
	_setVariableData: function(inVariable) {
		this.setData(inVariable.getData());
	},
	_setArrayData: function(inArray) {
		this.data = { list: inArray };
		this.isList = true;
	},
	_setObjectData: function(inObject) {
		this.beginUpdate();
		this._clearData();
		this.isList = false;
		if (!("list" in this._dataSchema))
			delete this.data.list;
		var d, v, nv, isNull = inObject === null, empty = wm.isEmpty(inObject);
		for (var i in this._dataSchema) {
			d = this.data[i];
			v = !empty ? inObject[i] : undefined;
			// nv is parent null or v, called null-checked value
			nv = isNull ? null : v;
			if (this._isVariableProp(i)) {
				// for existing variable props, set null-checked value iff it exists
				if (d instanceof wm.Variable) {
					if (nv !== undefined) {
						// we don't need to propagate messages from variable properties
						// since this variable will propagete them
						d.beginUpdate();
						d.setData(nv);
						d.endUpdate();
					}
				// for non-existing variable props, set *value* iff it exists
				// (we do not set null values here because that can prompt infinite marshalling)
				} else if (v !== undefined)
					this._setDataValue(i, v);
			// for non-variable props, set null-checked value iff it exists
			} else {
				if (nv !== undefined)
					this._setDataValue(i, nv);
			}
		}
		this._setNull(isNull);
		this.endUpdate();
	},
	/**
		Export data from this variable into a plain old JavaScript object (POJSO).<br/>
		@returns Object
	*/
	// NB: output is POJSO
	getData: function() {
		if (!this.data)
			return;
		if (this._isNull)
			return null;
		else if (this.isList) {
			var data = [];
			for (var i=0, l= this.getCount(), v; i<l; i++) {
				v = (this.getItem(i) || 0).getData();
				if (v)
					data.push(v);
			}
			return data;
		} else {
			var data = {};
			var props = this.listDataProperties();
			for (var i in props) {
				var v = this.data[i];
				// we may not always want all related junk
				if (v !== undefined) {
					v = v instanceof wm.Variable ? v.getData() : v;
					// don't return undefined or empty, non-null variables properties
					if (v === undefined || (v !== null && typeof v == "object" && wm.isEmpty(v)))
						continue;
					data[i] = v;
				}
			}
			if (!wm.isEmpty(data))
				return data;
		}
	},
	//===========================================================================
	// Value API
	//===========================================================================
	_getDataValue: function(n) {
		if (!this.data)
				this.data = {};
		var d, f;
		if (this.isList) {
			f = this.getCursorItem();
			d = f && f.data;
		} else
			d = this.data;
		var v = d && d[n], typeInfo = this._dataSchema[n];
		// FIXME: Encountered a project where _isVariableProp(n) was true, but v was a string
		if (this._isVariableProp(n) && (!v || (v._isStub && v._isStub()))) {
			v = d[n] = (f || this).marshallVariable(n, typeInfo, v);
		}
		return v;
	},
	_setDataValue: function(n, v) {
		// NOTE: variable value is null iff it has been explicitly set to null
		// and no value has subsequently been set to any value, including null.
		if (this._isNull && v !== undefined)
			this._setNull(false);
		this.beginUpdate();
		var o = this._getDataValue(n);
		this.endUpdate();
		if (o instanceof wm.Variable) {
			// if we are updating, o's listeners will be notified by us
			// o doesn't need to message them directly
			if (this._updating)
				o._updating++;
			o.setData(v);
			if (this._updating)
				o._updating--;
			return;
		}
		if (!(v instanceof wm.Variable)) {
			this.data[n] = v;
			this.dataValueChanged(n, v);
		}
	},
	//===========================================================================
	// List API
	//===========================================================================
	/**
		Return the number of items in the list owned by this variable (only valid if <a href="#isList">isList</a> is true).
		@returns Number
	*/
	getCount: function() {
	  if (this._isNull) return 0;
	  if (this.isList) return (this.data && this.data.list) ? this.data.list.length : 0;
	  return 1;
	},

	_isEmpty: function(obj) {
		for (var prop in obj) {
			if(obj.hasOwnProperty(prop)) return false;
		}
		return true;
	},
	// Returns a Variable representing item inIndex
	// If the item is currently raw data, it's replaced
	// with a new Variable. Created Variable is initialized 
	// with the raw list data unless inData is supplied.
	// If inData is supplied the Variable is populated with 
	// inData.
	_needItem: function(inIndex, inData) {
		if (inIndex >= this.getCount() && inData === undefined) return null;
		// fetch the stored data object
		var item = this.data.list[inIndex];
		// optional raw data to initialize the object with
		var data = inData;
		if (!(item instanceof wm.Variable)) {
			// we want to populate with original raw data
			// unless override data iss provided
			data = inData || item;
			// create a new Variable to represent this data
			item = this.createVariable({/*name: "itemProxy",*/ type: this.type, _subNard: true, itemIndex: inIndex});
			this.data.list[inIndex] = item;
		}
		if (data !== undefined) {
			item.beginUpdate();
			item.setData(data);
			item.endUpdate();
		}
		return item;
	},
	/**
		Return an item by numeric index in the list owned by this variable (only valid if <a href="#isList">isList</a> is true).
		@param {Number} inIndex The numeric index of the item to fetch
		@returns Any 
	*/
	getItem: function(inIndex) {
		return this.isList && this._needItem(inIndex);
	},
	_populateItems: function() {
		for (var i=0, c = this.getCount(); i<c; i++)
			this.getItem(i);
	},
	// note: low level sort that requires a comparator function to be used.
	sort: function(inComparator) {
		this._populateItems();
		var l = this.isList && this.data && this.data.list;
		l && l.sort(inComparator);
	},
	/**
		Set the cursor by index. When data forms a list, the cursor indicates the item used in calls to getValue.
		@param {Number} inCursor The numeric index of the item to use as the Variable's 
		@returns Any 
	*/
	setCursor: function(inCursor) {
		this.cursor = Math.max(0, Math.min(this.getCount()-1, inCursor));
		this.notify();
	},
	/**
		Increments the cursor.
		@returns Any 
	*/
	setNext: function() {
		this.setCursor(this.cursor+1);
	},
	/**
		Decrements the cursor.
		@returns Any 
	*/
	setPrevious: function() {
		this.setCursor(this.cursor-1);
	},
	/**
		Sets the cursor to the first item.
		@returns Any 
	*/
	setFirst: function() {
		this.setCursor(0);
	},
	/**
		Sets the cursor to the last item.
		@returns Any 
	*/
	setLast: function() {
		this.setCursor(this.getCount()-1);
	},
	/**
		Retrieves the data item at the current list cursor. If data is not a list, returns the Variable
		@returns wm.Variable
	*/
	getCursorItem: function() {
		return this.getItem(this.cursor || 0) || this;
	},
	/**
		Set an item by numeric index in the list owned by this variable (only valid if <a href="#isList">isList</a> is true).
		@param {Number} inIndex The numeric index of the item to set
		@param {Any} inData The data to store
	*/
	setItem: function(inIndex, inData) {
		this._setItem(inIndex, inData);
		this.cursor = inIndex;
		this.notify();
	},
	_setItem: function(inIndex, inData) {
		if (this.isList)
			this._needItem(inIndex, inData);
	},
	/**
		Adds an item to the list of data. Only functions if data forms a list.
		@param {wm.Variable or Object} inData The data to add, either a an Object or wm.Variable
		@param {Number} inIndex (Optional) The numeric index at which to insert the data.
		@returns Any
	*/
	addItem: function(inData, inIndex) {
		this._addItem(inData, inIndex);
		this.cursor = inIndex;
		this.notify();
	},
	_addItem: function(inData, inIndex) {
		if (this.isList) {
			var c = this.getCount();
			if (inIndex >= 0 && inIndex < c)
				this.data.list.splice(inIndex, 0, {});
			else
				inIndex = this.getCount();
			this._setItem(inIndex, inData);
		}
	},
	/**
		Removes an item from the list of data. Only functions if data forms a list.
		@param {Number} inIndex The numeric index of the item to remove.
		@returns Any
	*/
	removeItem: function(inIndex) {
		this._removeItem(inIndex);
		this.cursor = 0;
		this.notify();
	},
	_removeItem: function(inIndex) {
		if (this.isList)
			this.data.list.splice(inIndex, 1);
	},
	// should we store this for faster access? (items have itemIndex, but this is not maintained)
	getItemIndex: function(inVariable) {
		if (!this.isList)
			return;
		var list = (this.data || 0).list || [];
		for (var i=0, l = list.length; i < l; i++) {
			if (inVariable == list[i])
				return i;
		}
	},
	getItemIndexByPrimaryKey: function(inVariable, pkList){
		if (!this.isList || !pkList || pkList.length < 1)
			return;
		var obj = inVariable;
		if (obj instanceof wm.Variable){
			obj = inVariable.getData();			
		}

		var list = (this.data || 0).list || [];
		for (var i=0, l = list.length; i < l; i++) {
			obj2 = list[i] instanceof wm.Variable ? list[i].getData() : list[i];
			var isEqual = true;
			for (var j = 0; j < pkList.length; j++){
				var f = pkList[j];
				if (obj[f] != obj2[f]){
					isEqual = false;
					break;
				}
			}
			
			if (isEqual)
				return i;
		}
		
	},
	//===========================================================================
	// Update Messaging
	//===========================================================================
	dataRootChanged: function() {
		if (this._subNard)
			return;
		// find first owner after root and send change message on that.
		// this should trigger rule #3 for bindings.
		var o = this.owner, p, root = this.getRoot();
		while (o && o != root) {
			p = o;
			o = o && o.owner;
		}
		var n = p ? p.getRuntimeId() : this.getRuntimeId();
		topic = n + "-rootChanged";
		wm.logging && console.group("<== ROOTCHANGED [", topic, "] published by Variable.dataRootChanged");
		dojo.publish(topic, [n]);
		wm.logging && console.groupEnd();
	},
	dataOwnerChanged: function() {
		if (this._updating)
			return;
		var n = this.getRuntimeId();
		var topic = n + "-ownerChanged";
		wm.logging && console.group("<== OWNERCHANGED [", topic, "] published by Variable.dataOwnerChanged");
		dojo.publish(topic, [n]);
		wm.logging && console.groupEnd();
		//
		// send root changed message
		if (this._allowLazyLoad)
			this.dataRootChanged();
		//
		var v = this.getCursorItem();
		for (var i in v.data) {
			wm.fire(v.data[i], "dataOwnerChanged");
		}
	},
	dataChanged: function() {
		if (this._updating)
			return;
		var id = this.getRuntimeId();
		var topic=[id, "-changed"].join('');
		wm.logging && console.group("<== CHANGED [", topic, "] published by Variable.dataChanged");
		dojo.publish(topic, [this]);
		// Rule: change notification is propagated up through owners
		// propagate change up only if this is a subNard.
		if (this._subNard)
			wm.fire(this.owner, "dataChanged");
		wm.logging && console.groupEnd();
	},
	// id-based notification
	dataValueChanged: function(inProp, inValue) {
		if (!this._updating) {
			// Can't simply call valueChanged; see note below.
			wm.Component.prototype.valueChanged.call(this, inProp, inValue);
			this.dataChanged();
		}
	},
	// id-based notification
	valueChanged: function(inProp, inValue) {
		// Code exists to deal with collisions between component props and data props in this class.
		// However, the distinction is lost in change notifications. Likely, data props should have
		// special ids to distinguish them. Until then, we simply avoid sending change notification
		// for properties when there is a collision.
		if (!this.isDataProp(inProp))
			this.inherited(arguments);
	},
	//===========================================================================
	// Referencing
	//===========================================================================
	setDataSet: function(inDataSet) {
		this.dataSet = "";
		if (inDataSet instanceof wm.Variable) {
			this.setType(inDataSet ? inDataSet.type : "wm.Variable");
			this.dataSet = inDataSet;
			this.cursor = inDataSet.cursor;
		}
		this.setData(inDataSet);
	},
	//===========================================================================
	// Property API
	//===========================================================================
	_isVariableProp: function(inPropName) {
		var typeInfo = this._dataSchema[inPropName];
		return Boolean(typeInfo && wm.typeManager.isStructuredType(typeInfo.type));
	},
	isDataProp: function(inProp) {
		return inProp in this._dataSchema;
	},
	_getValue: function(inProp) {
		return this.isDataProp(inProp) ? this._getDataValue(inProp) : this.inherited(arguments);
	},
	_setValue: function(n, v) {
		// if setting to default, then don't do data setting
		if ((this.schema[n]||0).defaultBindTarget || !this.isDataProp(n))
			this.inherited(arguments);
		else
			this._setDataValue(n, v);
	},
	//===========================================================================
	// Data Marshalling / Lazy Loading
	//===========================================================================
	createVariable: function(inProps, inPropName) {
		var v = new wm.Variable(inProps);
		v.owner = this;
		return v;
	},
	marshallVariable: function(inPropName, inTypeInfo, inVariable) {
		var
			p = inPropName, v = inVariable,
			t = inTypeInfo.isList ? '[' + inTypeInfo.type + ']' : inTypeInfo.type;
		if (!(v instanceof wm.Variable)) {
			v = this.createVariable({name: p, type: t, _subNard: true}, p);
			if (inVariable || inVariable === null) {
				v.beginUpdate();
				v.setData(inVariable);
				v.endUpdate();
			}
		}
		// lazy load!
		if (v._isStub() && this.canLazyLoad(inTypeInfo)) {
			this.beginUpdate();
			this.lazyLoadData(p, v);
			this.endUpdate();
		}
		return v;
	},
	_isStub: function() {
		if (!this._nostub && !this._isNull /*&& (!this.isList || !this.hasList())*/) {
			// stub if there is no data
			if (this.data === undefined)
				return true;
			// stub if we're a list and there's no list data
			if (this.isList || this.hasList())
				return !this.data.list || !this.data.list.length;
			// optionally treat as stub if there is any data v. if there is missing data
			// stub if dont' have data for any property not structured / list
			if (this._greedyLoadProps) {
				var schema = this._dataSchema, s;
				for (var i in schema) {
					s = schema[i];
					if (!s.isList && (this.data[i] === undefined) 
						&& !wm.typeManager.isStructuredType(s.type))
						return true;
				}
			// stub if we have no data
			} else if (wm.isEmpty(this.data))
				return true;
		}
		this._nostub = true;
		return false;
	},
	lazyLoadData: function(inPropName, inVariable) {
		var s = wm.getRuntimeService(this), v = inVariable;
		try{
			if (s.ready) {
				var d = this.getData();
				if (!wm.isEmpty(d)) {
					var args = [null, this.type, d, {properties: [inPropName]}];
					wm.logging && console.log("lazyLoad", inVariable.owner && inVariable.owner.getId(), args);
					var f = function() {
					  var r = s.result, propData = r && r[inPropName];
					  if (propData) {
					    v.beginUpdate();
					    v.setData(propData);
					    v.endUpdate();
					  }
					}					  
					
					// NOTE: Default is that async doesn't have a value; this feature seems unreliable so far so don't use
					if (this.async) {
					  s.requestAsync("read", args, f);
					} else {
					  s.requestSync("read", args);
					  f();
					}
				};
			}
		}catch(x){}
	},
	canLazyLoad: function(inTypeInfo) {
		if (this._updating || !wm.typeManager.getLiveService(inTypeInfo.type))
			return;
		// FIXME: prevent lazy loading if livelayout is not ready
		// reference to studio especially bad.
		if (this.isDesignLoaded() && !studio.isLiveLayoutReady())
			return false;
		var o = this;
		// if this variable or any owner does not allow lazy loading then cannot lazy load!
		while (o instanceof wm.Variable) {
			if (!o._allowLazyLoad)
				return false;
			o = o.owner;
		}
		// lazy load if the type is a list or we have required data to read.
		return inTypeInfo.isList || this._hasRequiredReadData();
	},
	// check our schema and data to see if 
	// we have all necessary data that is required
	// for the lazy load "read" operation
	_hasRequiredReadData: function() {
		var ds = this._dataSchema, s, d;
		for (var i in ds) {
			s = ds[i];
			if (s.include && dojo.indexOf(s.include, "read") > -1) {
				d = this.data[i];
				if (d === undefined || d === null)
					return false;
			}
		}
		return true;
	}
});

// FIXME: variable should have a data loader which can optionally have a liveView.
// A difficulty is that liveView is responsible both for data to load and storing field info
// that can be used to create ui.
// The issue is made worse by the need to copy variables (and associated liveViews)
// extension to extend Variable to load data with a liveView
wm.Variable.extend({
	_includeListProps: false,
	createVariable: function(inProps, inPropName) {
		inProps = inProps || {};
		inProps.liveView = this.liveView;
		var r = this._rootField, n = inPropName;
		inProps._rootField = r && inPropName ? r + "." + inPropName : (inPropName || "");
		var v = new wm.Variable(inProps);
		//v.owner = this;
	    v.setOwner(this, true);
		return v;
	},
	setDataSet: function(inDataSet) {
		this.dataSet = "";
		if (inDataSet instanceof wm.Variable) {
			this._rootField = inDataSet._rootField || "";
			this.setLiveView(inDataSet.liveView);
			this.setType(inDataSet ? inDataSet.type : "wm.Variable");
			this.dataSet = inDataSet;
			this.cursor = inDataSet.cursor;
		}
		this.setData(inDataSet);
	},
	_getEagerProps: function(inVariable) {
		var
			v = inVariable,
			props = this.liveView ? this.liveView.getSubRelated(v._rootField) : [],
			schema = wm.typeManager.getTypeSchema(v.type);
		return this._includeListProps ? props :
			dojo.filter(props, function(r) {
				return !wm.typeManager.isPropInList(schema, r);
			});
	},
	_getLoadProps: function(inPropName, inVariable) {
		return [inPropName].concat(dojo.map(this._getEagerProps(inVariable), function(r) {
			return [inPropName, r].join(".");
		}));
	},
	// FIXME: avoid sync request
	lazyLoadData: function(inPropName, inVariable) {
		var s = wm.getRuntimeService(this), v = inVariable;
		try{
			if (s.ready) {
				var d = this.getData();
				if (!wm.isEmpty(d)) {
					var
						props = this.liveView ? this._getLoadProps(inPropName, v) : inPropName,
						args = [null, this.type, d, {properties: props}];
					//console.log("lazyLoad", this.getId(), args);
					wm.logging && console.log("lazyLoad", inVariable.owner && inVariable.owner.getId(), args);

					var f = function(r) {
					  var propData = r && r[inPropName];
					  if (propData) {
					    v.beginUpdate();
					    v.setData(propData);
					    v.endUpdate();
					  }
					}					  

					if (this.async) {
					  s.requestAsync("read", args, f);
					} else {
					  s.requestSync("read", args);
					  f(s.result);
					}


					// FIXME: non-sync, need to protect against multiple requests?
					// create a queue of requests?
					/*if (!this._inflight) {
						var def = s.requestAsync("read", args);
						this._inflight = true;
						def.addBoth(dojo.hitch(this, function(r) {
							this._inflight = false;
							return r;
						}));
						def.addCallback(dojo.hitch(this, function(r) {
							var propData = r && r[inPropName];
							if (propData) {
								v.beginUpdate();
								v.setData(propData);
								v.endUpdate();
								console.log("got data!", "notify!", this.getId(), this._updating);
								this.owner.notify();
							}
							return r;
						}));
					}*/
				}
			}
		}catch(x){
			wm.logging && console.log("Failed to lazy load.", args);
		}
	},
	setLiveView: function(inLiveView) {
		this.liveView = inLiveView;
	},
	getViewType: function() {
		return this.liveView  && this.liveView.getSubType(this._rootField);
	},
	getViewFields: function() {
		return (this.liveView && this.liveView.getSubView(this._rootField)) || [];
	},
	getViewListFields: function() {
		return (this.liveView && this.liveView.getListView(this._rootField)) || [];
	},
	getViewRelated: function() {
		return (this.liveView && this.liveView.getSubRelated(this._rootField)) || [];
	}
});

//===========================================================================
// Design Time Extensions
//===========================================================================
wm.Object.extendSchema(wm.Variable, {
        onPrepareSetData: {events: ["js","sharedjs"]},
	data: { ignore: 1 },
	isList: { ignore: 1 },
	cursor: { ignore: 1},
	isPrimitive: { ignore: 1},
	type: { ignore: 0, group: "common", order: 1},
	json: { group: "data", order: 5},
	dataSet: { readonly: 1, bindable: 1, group: "data", order: 0, defaultBindTarget: 1, isObject: true, type: "any", categoryParent: "Properties", categoryProps: {content: "dataSet", inspector: "Data"} }
});

/**#@+ @design */
wm.Variable.extend({
	/** @lends wm.Variable.prototype */
	makePropEdit: function(inName, inValue, inDefault) {
		switch (inName) {
			case "type":
				return new wm.propEdit.DataTypesSelect({component: this, name: inName, value: inValue});
			case "json":
				return makeTextPropEdit(inName, inValue, inDefault)
		}
		return this.inherited(arguments);
	},
	isListBindable: function() {
		return this.isList;
	}
});
/**#@- @design */

}

if(!dojo._hasResource["wm.base.components.Service"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["wm.base.components.Service"] = true;
/*
 *  Copyright (C) 2008-2010 WaveMaker Software, Inc.
 *
 *  This file is part of the WaveMaker Client Runtime.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
dojo.provide("wm.base.components.Service");


/**
	Component that can be configured to perform a task.
	<br/><br/>
	@name wm.Service
	@class
	@extends wm.Component
*/
dojo.declare("wm.Service", wm.Component, {
	/** @lends wm.Service.prototype */
	_operations: {},
	/**
		Result data (if any) returned from the last invocation.
	*/
	result: null,
	/**
		Error data (if any) returned from the last invocation.
	*/
	error: null,
	getOperationsList: function() {
		var l = [];
		for (var i in this._operations)
			l.push(i);
		l.sort();
		return l;
	},
	getOperation: function(inOperation) {
		return this._operations[inOperation];
	},
	initService: function() {
	},
	/**
		Invoke a method on this service object with arguments.
		<br/><br/>
		Invocations may be asynchronous. Responses are available 
		via the returned Deferred object or from the 
		<a href="#onResult">onResult</a> and 
		<a href="#onError">onError</a> events.
		@param {String} inMethod The method to invoke on this object.
		@param {Array} inArgs An array of parameters for the method.
		@returns {dojo.Deferred} Response handler object.
	*/
        invoke: function(inMethod, inArgs, inOwner) {
		var
			d = new dojo.Deferred(),
			m = this[inMethod];
		if (m) {
			var result = m.apply(this, inArgs);
			this.onResult();
			wm.onidle(function() {
				d.callback(result);
			});
		} else {
			this.onError();
			wm.onidle(function() {
				d.errback("operation: " + inMethod + " does not exist.");
			});
		}
		return d;
	},
	/**
		Event that fires after a succesful service invocation.
		@param {Any} inResult Any result data returned from the service.
	*/
	onResult: function(inResult) {
		this.error = null;
		return this.result = inResult;
	},
	/**
		Event that fires after a service invocation has resulted in an error.
		@param {Any} inError Any error data returned from the service.
	*/
	onError: function(inError) {
		this.result = null;
		return this.error = inError;
	}
});

// FIXME: needs its own module
// ==========================================================
// Services registry (provides info about available services)
// ==========================================================

wm.services = {
	byName: {},
	_services: {},
	add: function(inService){
		return wm.services.byName[inService.name] = inService;
	},
	remove: function(inService){
		var n = inService.name;
		this._destroyService(n);
		delete wm.services.byName[n];
	},
	getNamesList: function() {
		var l = [], services = wm.services.byName, s;
		for (var i in services) {
			s = services[i];
			if (!s.clientHide) 
				l.push(i);
		}
		l.sort();
		return l;
	},
	forEach: function(inFunction) {
		wm.forEach(this.byName, function(s) {
			inFunction(s);
		});
	},
	clear: function() {
		var n = wm.services.byName, s;
		for (var i in n) {
			s = n[i];
			if (!s.isClientService)
				this.remove(s);
			else
				this._destroyService(s);
		}
	},
	getService: function(inName) {
		var s;
		if (inName) {
			s = this._services[inName] || this._createService(inName);
			if (!s._service)
				s.initService();
		}
		return s;
	},
	_createService: function(inName) {
		var
			defaultCtor = "wm.JsonRpcService",
			s = this.byName[inName];
		if (!s)
			s = this.add({name: inName, ctor: defaultCtor});
		var ctor = dojo.getObject(s.ctor || defaultCtor);
		// FIXME: we don't want to be streamed so don't include owner
		// otoh without owner, we don't know how to resolve paths at designTime
		var service = new ctor({name: inName, service: inName});
		service.owner = dojo.getObject("studio.wip.app") || app;
		return service;
	},
	_destroyService: function(inService) {
		wm.fire(this._services[inService.name], "destroy");
	}
};

}

if(!dojo._hasResource["wm.base.components.ServiceQueue"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["wm.base.components.ServiceQueue"] = true;
/*
 *  Copyright (C) 2008-2010 WaveMaker Software, Inc.
 *
 *  This file is part of the WaveMaker Client Runtime.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
dojo.provide("wm.base.components.ServiceQueue");

dojo.declare("wm.ServiceQueue", wm.Component, {
	services: "",
	init: function() {
		this._services = [];
		this._serviceConnections = [];
		this.inherited(arguments);
	},
	getServicesCount: function() {
		return this._services && this._services.length;
	},
	getServicesList: function() {
		for (var i=0, l=[], ss=this.services.split(","), s, v; (s=ss[i]); i++) {
			v = this.getValueById(dojo.string.trim(s));
			if (v)
				l.push(v);
		}
		return l;
	},
	update: function() {
		this.beginUpdate();
	},
	beginUpdate: function() {
		this._services = this.getServicesList();
		this.connectServices();
		this._currentService = 0;
		this.updateNextService();
	},
	getCurrentService: function() {
		return this._services[this._currentService];
	},
	updateNextService: function() {
		if (this._currentService < this.getServicesCount()) {
			var s = this.getCurrentService();
			this._currentService++;
			s.update();
		} else
			this.completeUpdate();
	},
	completeUpdate: function() {
		this.disconnectServices();
	},
	abortUpdate: function() {
		this.disconnectServices();
	},
	connectServices: function() {
		this.disconnectServices();
		dojo.forEach(this._services, dojo.hitch(this, function(s) {
			this._serviceConnections.push(dojo.connect(s, "onResult", this, "updateNextService"));
			this._serviceConnections.push(dojo.connect(s, "onError", this, "abortUpdate"));
		}));
	},
	disconnectServices: function() {
		dojo.forEach(this._serviceConnections, function(s) {
			dojo.disconnect(s);
		});
	}
});

wm.ServiceQueue.extend({
	getAvailableServicesList: function() {
		var d = wm.listComponentIds([studio.application, studio.page], wm.ServiceVariable);
		d = d.concat(wm.listComponentIds([studio.application, studio.page], wm.NavigationCall));
		// don't show this!
		var i = dojo.indexOf(d, this.owner.getId());
		if (i != -1)
			d.splice(i, 1);
		return d;
	},
	write: function(inIndent) {
		return this.services ? this.inherited(arguments): null;
	}
});

}

if(!dojo._hasResource["wm.base.components.ServiceCall"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["wm.base.components.ServiceCall"] = true;
/*
 *  Copyright (C) 2008-2010 WaveMaker Software, Inc.
 *
 *  This file is part of the WaveMaker Client Runtime.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"); 
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
dojo.provide("wm.base.components.ServiceCall");



//===========================================================================
// Provides basic service calling infrastructure
//===========================================================================
// Note: wm.ServiceCall is not a component. This primarily so that it can be combined
// with components that have other capabilities.
/**
	Infrastructure for encapsulating a {@link wm.Service} configuration with a trigger 
	to invoke the configured service.
	@name wm.ServiceCall
	@class
	@noindex
*/
dojo.declare("wm.ServiceCall", null, {
	/** @lends wm.ServiceCall.prototype */
	/**
		Set true to automatically <a href="#update">update</a> this service when 
		the service configuration or input is modified.
		@type String
	*/
	autoUpdate: false,
	/**
		Set true to automatically <a href="#update">update</a> this service when it's created.
		@type String
	*/
	startUpdate: false,
	startUpdateComplete: false,
	/**
		Name of the service called by this object.
		@type String
	*/
	service: "",
	/**
		Name of the operation to invoke on the service.
		@type String
	*/
	operation: "",
	_operationInfo: {},
	destroy: function() {
		this.inherited(arguments);
		wm.fire(this._requester, "cancel");
	},
	postInit: function() {
		this.inherited(arguments);
		this.connectStartUpdate();
		if (!this.$.queue)
			new wm.ServiceQueue({name: "queue", owner: this});
		this.initInput();
		this.setService(this.service);
		this._setOperation(this.operation);
	},
	initInput: function() {
		this.input = this.$.input;
		if (!this.input)
			this.input = this.createInput();
		this.subscribe(this.input.getRuntimeId() + "-changed", this, "inputChanged");
	},
	//=======================================================
	// Service
	//=======================================================
	setService: function(inService) {
		this.service = inService;
		this._service = wm.services.getService(this.service) || new wm.Service({});
		wm.fire(this._service, "setServiceCall", [this]);
	},
	//=======================================================
	// Operation
	//=======================================================
	_setOperation: function(inOperation) {
		this.operation = inOperation;
		this._operationInfo = this.getOperationInfo(this.operation);
		this.operationChanged();
	},
	setOperation: function(inOperation) {
		this._setOperation(inOperation);
		this.doAutoUpdate();
	},
	getOperationInfo: function(inOperation) {
		return (this._service && this._service.getOperation(inOperation)) || {};
	},
	operationChanged: function() {
		this.input.operationChanged(this.operation, this._operationInfo.parameters);
	},
	//=======================================================
	// Input
	//=======================================================
	createInput: function() {
		var i = new wm.ServiceInput({name: "input", owner: this });
		i.operationChanged(this.operation, this._operationInfo.parameters);
		return i;
	},
	inputChanged: function() {
		this.doAutoUpdate();
	},
	//=======================================================
	// Updating
	//=======================================================
	connectStartUpdate: function() {
		if (this.owner && this.owner.start)
			this.connect(this.owner, "start", this, "doStartUpdate");
	},
	setAutoUpdate: function(inAutoUpdate) {
		this.autoUpdate = inAutoUpdate;
		this.doAutoUpdate();
	},
	setStartUpdate: function(inStartUpdate) {
		this.startUpdate = inStartUpdate;
		if (this.startUpdate && !this._loading && this.isDesignLoaded()) {
		  this.update();
		}
	},
	doStartUpdate: function() {
	        if (this.startUpdate && !this._loading) {
			this.update();
			this.startUpdateComplete = true;
		}
	},
	doAutoUpdate: function() {
	        if (this.autoUpdate && !this._loading && (!this.startUpdate || this.startUpdateComplete || this.isDesignLoaded()))
			this.update();
	},
	/**
		Invoke the service.
		Use the <a href="onResult">onResult</a>,
		<a href="onSuccess">onSuccess</a>,
		and/or <a href="onError">onError</a> events 
		to monitor the outcome of the service call.
	*/
	update: function() {
		return this.isDesignLoaded() ? this.doDesigntimeUpdate() : this._update();
	},
	_update: function() {
		if (this.canUpdate()) {
			this.onBeforeUpdate(this.input);
			return this.request();
		}
	},
	/**
		Return a boolean value used to determine if the service can be updated.
		Use the <a href="onCanUpdate">onCanUpdate</a>,
		event to control the output of canUpdate.
	*/
	canUpdate: function() {
		var info = {canUpdate: this._getCanUpdate() };
		this.onCanUpdate(info);
		return info.canUpdate;
	},
	_getCanUpdate: function() {
		return this._service && this.operation && !Boolean(this._requester);
	},
	getArgs: function() {
		return this.input.getArgs();
	},
	request: function(inArgs) {
		inArgs = inArgs || this.getArgs();
		wm.logging && console.debug("request", this.getId(), "operation", this.operation, "args", inArgs);
		if (djConfig.isDebug)
		  console.log("REQUEST   Component: " + this.getRoot() + "." + this.name + ";  Operation: " + this.operation);
	          var d = this._requester = this._service.invoke(this.operation, inArgs, this.owner);
		return this.processRequest(d);
	},
	processRequest: function(inDeferred) {
		var d = inDeferred;
		if (d) {
			d.canceller = function(inDeferred) {
				inDeferred.fired = 1;
			}
			d.addBoth(dojo.hitch(this, function(r) {
				this._requester = false;
				return r;
			}));
			d.addCallbacks(dojo.hitch(this, "result"), dojo.hitch(this, "error"));
			return d;
		}
	},
	//=======================================================
	// Result Processing
	//=======================================================
	result: function(inResult) {
		var tmp = [];
		var max = this.isDesignLoaded() ? this.designMaxResults : this.maxResults;
		if ((this instanceof wm.ServiceVariable) && !(this instanceof wm.LiveVariable) && inResult 
		    && dojo.isArray(inResult) && inResult.length > 1 && max > 0) {
			var cnt = 0;
			for (var o in inResult) {
				tmp[cnt] = inResult[cnt];
				cnt++;
				if (max > 0 && cnt == max) break;
			}
			this.processResult(tmp);
			return tmp;
		} else {
			this.processResult(inResult);
			return inResult;
		}
	},
	processResult: function(inResult) {
		this.onResult(inResult);
		this.onSuccess(inResult);
		this.$.queue.update();
	},
	error: function(inError) {
		this.processError(inError);
		return inError;
	},
	processError: function(inError) {
		this.onResult(inError);
		this.onError(inError);
	},
	//=======================================================
	// Events
	//=======================================================
	/**
		onCanUpdate event fires before a service is invoked.
		@param {Any} ioUpdate An object containing a canUpdate flag.
		Setting this flag to false will prevent the service from updating.
		@event
	*/
	onCanUpdate: function(ioUpdate) {
	},
	/**
		onBeforeUpdate event fires before a service is invoked.
		@param {wm.ServiceInput} ioInput The input object used to determine what data 
		will be passed to the service.
		@event
	*/
	onBeforeUpdate: function(ioInput) {
	},
	/**
		onResult event fires whenever a service returns, whether the
		service returned successfully or reported an error.
		@param {Any} inData Result data. The format of this data on the service.
		@event
	*/
	// fires on success or error
	onResult: function(inDeprecated) {
	},
	/**
		onSuccess event fires whenever a service returns successfully.
		@param {Any} inData Result data. The format of this data on the service.
		@event
	*/
	// fires only on success
	onSuccess: function(inDeprecated) {
	},
	/**
		onError event fires whenever a service reports an error.
		@param {Any} inData Result data. The format of this data on the service.
		@event
	*/
	// fires only on error
	onError: function(inError) {
		var errCodes = inError.message.match(/(\d+)$/);
		var errCode = (errCodes) ? errCodes[0] : "";

		// If the failer is a security access error, AND if its NOT a security error that comes from live view 
		// (happens when a project accesses the server while running within studio), then tell the user to log back in.
		// Also don't repeat this alert more than once every 3 minutes (it takes 4 server accesses to open a page, so thats 4 alerts in a row!)
		if (errCode == 403) {
		  dojo.publish("session-expiration-servicecall", [this]);
		} else {
		  dojo.publish("service-variable-error", [this, inError]);
		}
	}
});

/**#@+ @design */
wm.ServiceCall.extend({
	clearInput: "(clear input)",
	updateNow: "(update now)",
	queue: "(serviceCalls)",
	/** @lends wm.ServiceCall.prototype */
	doDesigntimeUpdate: function() {
		this.designTime = true;
		return studio.makeLiveDataCall(dojo.hitch(this, "_update"));
	},
	doClearInput: function() {
		this.input.destroy();
		this.input = this.createInput();
	},
	set_operation: function(inOperation) {
		this.setOperation(inOperation);
		if (this.isDesignLoaded() && studio.selected == this)
			studio.inspector.inspect(studio.selected);
	},
	getServicesList: function() {
		return [""].concat(wm.services.getNamesList()||[]);
	},
	showQueueDialog: function() {
		var d = wm.ServiceQueue.dialog, q = this.$.queue;
		if (d) {
			d.page.binding = q;
			d.page.update();
		}else{
			wm.ServiceQueue.dialog = d = new wm.PageDialog({
				name: "queueDialog",
				owner: studio,
				contentWidth: 600,
				contentHeight: 400,
				hideControls: true,
				pageName: "QueueDialog",
				pageProperties: {binding: q}
			});
		}
		d.show();
	},
	makePropEdit: function(inName, inValue, inDefault) {
		switch (inName) {
			case "service":
				return makeSelectPropEdit(inName, inValue, this.getServicesList(), inDefault);
			case "operation":
				var
					s = this._service,
					valueOk = s && s.getOperation(inValue),
					methods = s && s.getOperationsList();
				if (!valueOk){
					inValue = methods ? methods[0] : "";
					if (inValue)
						this.set_operation(inValue);
				}
				if (methods)
					return makeSelectPropEdit(inName, inValue, methods, inDefault);
				break;
			case "queue":
			case "updateNow":
			case "clearInput":
				return makeReadonlyButtonEdit(inName, inValue, inDefault);
		}
		return this.inherited(arguments);
	},
	editProp: function(inName, inValue, inInspector) {
		switch (inName) {
			case "updateNow":
				return this.update();
			case "queue":
				this.showQueueDialog();
				return;
			case "clearInput":
				return this.doClearInput();
		}
		return this.inherited(arguments);
	}
});
wm.Object.extendSchema(wm.ServiceCall, {
    startUpdateComplete: { ignore: 1},
    designTime: {ignore: 1}
});


//===========================================================================
// Variable used as a service input
//===========================================================================
/**
	Variable used as a service input
	@name wm.ServiceInput
	@class
	@noindex
	@extends wm.Variable
*/
dojo.declare("wm.ServiceInput", wm.Variable, {
	/** @lends wm.ServiceInput.prototype */
	_allowLazyLoad: false,
	isDataProp: function(inProp) {
		// Note: it's important we assume all properties are data properties unless _dataSchema is set
		// Since the dataSchema is set externally, 
		// bindings may set data properties before data schema is set, creating errors.
		return wm.isEmpty(this._dataSchema) || (inProp in this._dataSchema) ;
	},
	operationChanged: function(inType, inSchema) {
		this.setType(inType + "Inputs");
		this.setDataSchema(inSchema);
		// input bindings may need to reinitialize after gleaning
		// operation type information (in light of constants)
		if (this.$.binding)
		{
			this.$.binding.refresh();
		}

	},
	getArgs: function() {
		var data= this.getData(), args=[], d;
		// convert to array
		for (var p in this._dataSchema) {
			if (data !== undefined)
				d = data[p];
			args.push(d !== undefined ? d : null);
		}
		return args;
	}
});

wm.Object.extendSchema(wm.ServiceInput, {
	dataSet: { ignore: 1, defaultBindTarget: false, isObject: true, type: "any"}
});

wm.ServiceInputVariable = wm.ServiceInput;

}

if(!dojo._hasResource["wm.base.components.ServiceVariable"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["wm.base.components.ServiceVariable"] = true;
/*
 *  Copyright (C) 2008-2010 WaveMaker Software, Inc.
 *
 *  This file is part of the WaveMaker Client Runtime.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
dojo.provide("wm.base.components.ServiceVariable");




//===========================================================================
// Main service calling class: calls services with input data and returns data
//===========================================================================
/**
	Main service calling class: calls services with input data and returns data
	@name wm.ServiceVariable
	@class
	@extends wm.Variable
	@extends wm.ServiceCall
*/
dojo.declare("wm.ServiceVariable", [wm.Variable, wm.ServiceCall], {
	total: 0,
	_page: 0,
	/** Maximum number of results to return */
	maxResults: 0,
	designMaxResults: 50,
	processResult: function(inResult) {
		this.setData(inResult);
		this.inherited(arguments);
	},
	getTotal: function() {
		return this.total || this.getCount();
	},
	getPageCount: function() {
		return Math.ceil(this.getTotal() / (this.getCount() || 1));
	},
	setPage: function(inPage) {
		this._page = Math.max(0, Math.min(this.getPageCount() - 1, inPage));
		this.firstRow = this._page * this.maxResults;
		this.update();
	},
	getPage: function() {
		return this._page;
	},
	setFirstPage: function() {
		this.setPage(0);
	},
	setPreviousPage: function() {
		this.setPage(this._page-1);
	},
	setNextPage: function() {
		this.setPage(this._page+1);
	},
	setLastPage: function() {
		this.setPage(this.getPageCount());
	},
	operationChanged: function() {
		this.inherited(arguments);
		// output has named type matching operation returnType
		var op = this._operationInfo;
		if (op)
			this.setType(op.returnType);
		if ((this.autoUpdate || this.startUpdate) && !this._loading && this.isDesignLoaded()) {
		  this.update();
		}
	}
});

wm.Object.extendSchema(wm.ServiceVariable, {
	operation: { group: "common", order: 24},
	clearInput: { group: "operation", order: 30},
	onSetData: {ignore: 1},
        onCanUpdate: {events: ["js", "sharedjs", "sharedEventHandlers"]},
	input: { ignore: 1 , writeonly: 1, componentonly: 1, categoryParent: "Properties", categoryProps: {component: "input", bindToComponent: true, inspector: "Data"}},
	service: {group: "common", order: 23 },
	autoUpdate: {group: "common", order: 25},
	startUpdate: {group: "common", order: 26},
	maxResults: {group: "data", order: 17},
	designMaxResults: {group: "data", order: 18},
	updateNow: { group: "operation", order: 10},
	queue: { group: "operation", order: 20},
	json: {ignore: 1},
	listType: {ignore: 1},
	isList: {ignore: 1},
	// binding inherited from Variable, keep it and write it but don't show it
	// potentially needed for source bindings.
	binding: {ignore: 1, writeonly: 1},
	type: { ignore: 1 },
	dataSet: { ignore: 1, defaultBindTarget: 1, isObject: true, type: "any"},
	startUpdateComplete: { ignore: 1},
	total: {ignore: 1}
});


wm.ServiceVariable.description = "Data from a service.";

/**#@+ @design */
wm.ServiceVariable.extend({
	/** @lends wm.ServiceVariable.prototype */
});
/**#@- @design */

}

if(!dojo._hasResource["wm.base.components.LiveVariable"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["wm.base.components.LiveVariable"] = true;
/*
 *  Copyright (C) 2009-2010 WaveMaker Software, Inc.
 *
 *  This file is part of the WaveMaker Client Runtime.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
dojo.provide("wm.base.components.LiveVariable");

 

/**
	Component that marshalls a LiveView and can perform all data operations: read, insert, update, delete.
	@name wm.LiveVariable
	@class
	@extends wm.ServiceVariable
*/
dojo.declare("wm.LiveVariable", wm.ServiceVariable, {
	/**
		@lends wm.LiveVariable.prototype
	*/
	autoUpdate: true,
	startUpdate: true,
	operation: "read",
	/** First row of results */
	firstRow: 0,
	/** Optional starting source data */
	sourceData: null,
	/** Method by which data is filtered */
	matchMode: "start",
	/** Toggle for data sorting to ignore alphabetical case or not. */
	ignoreCase: false,
	/** Optional order by clause, example "asc: cityId, desc: city" */
	orderBy: "",
	/** LiveView or LiveTable from which this LiveVariable gets its field information; can use a liveView or liveTable */
	liveSource: null,
	/** our liveView **/
	liveView: null,
	/** Maximum number of results to return */
	//maxResults: 0,
	//designMaxResults: 50,
	/** Field in view to use as our root object / type */
	_rootField: "",
	destroy: function() {
		this._unsubscribeLiveView();
		this.inherited(arguments);
	},
	init: function() {
		this.inherited(arguments);
		this.filter = new wm.Variable({name: "filter", owner: this, type: this.type || "any" });
		this.sourceData = new wm.Variable({name: "sourceData", owner: this, type: this.type || "any" });
		this.subscribe(this.filter.getRuntimeId() + "-changed", this, "filterChanged");
		this.subscribe(this.sourceData.getRuntimeId() + "-changed", this, "sourceDataChanged");
	},
	postInit: function() {
		this.inherited(arguments);
		// initialize via liveSource or optionally directly with a liveView)
		if (this.liveSource)
			this.setLiveSource(this.liveSource);
		else
			this.setLiveView(this.liveView || this.createLiveView(this.type));
		this.doAutoUpdate();
	},
	_subscribeLiveView: function() {
		this._unsubscribeLiveView();
		if (this.liveView)
			this._liveViewSubscription = dojo.subscribe(this.liveView.getRuntimeId() + "-viewChanged", dojo.hitch(this, "_liveViewChanged"));
	},
	_unsubscribeLiveView: function() {
		dojo.unsubscribe(this._liveViewSubscription);
		this._liveViewSubscription = null;
	},
	isLiveType: function() {
		return wm.typeManager.getLiveService(this.type);
	},
	doAutoUpdate: function() {
		if (this.isLiveType())
			this.inherited(arguments);
	},
	filterChanged: function() {
		this.doAutoUpdate();
	},
	sourceDataChanged: function() {
		this.doAutoUpdate();
	},
	/** Set the filter used for read operations */
	setFilter: function(inFilter) {
		if ((inFilter || 0).type == this.type) {
			this.filter.setDataSet(inFilter);
		}
	},
	/** Set the orderBy property used for read operations */
	setOrderBy: function(inOrderBy) {
		this.orderBy = inOrderBy;
		this.doAutoUpdate();
	},
	/** Set the source data which is used for operations. */
	setSourceData: function(inSourceData) {
		var liveType = this.isLiveType();
		if (!liveType || (inSourceData || 0).type == this.type) {
			this.sourceData.setDataSet(inSourceData);
			if (!liveType) {
				this._updating++;
				this.setLiveSource(this.sourceData.type);
				this._updating--;
			}
		}
	},
	// ==========================================================
	// LiveView integration
	// ==========================================================
	/** Set the LiveView or LiveTable from which we will get data information */
	/* valid input: LiveView full id or LiveTable full name */
	setLiveSource: function(inLiveSource) {
		var
			s =this.liveSource = inLiveSource,
			v = this.getRoot().app.getValueById(s) || this.createLiveView(s);
		if (v)
			this.setLiveView(v);
		this.doAutoUpdate();
	},
		     /*
	setLiveSource: function(inLiveSource) {
	    studio.testThis = this;
	    var s =this.liveSource = inLiveSource;
	    var v;
	    if (this.getRoot().app)
		v = this.getRoot().app.getValueById(s);
	    if (!v)
		v = this.createLiveView(s);
	    if (v)
		this.setLiveView(v);
	    this.doAutoUpdate();
	},*/
	setLiveView: function(inLiveView) {
		this.clearData();
		this.liveView = inLiveView;
		this._subscribeLiveView();
		this.setType(this.getViewType());
	},
	createLiveView: function(inType) {
		return new wm.LiveView({
			name: "liveView",
			owner: this,
			dataType: inType,
			_defaultView: true
		});
	},
	setType: function(inType) {
		this.inherited(arguments);
		this.filter.setType(this.type);
		this.sourceData.setType(this.type);
		if (!this._updating && this.$.binding)
			this.$.binding.refresh();
	},
	_liveViewChanged: function() {
		this.setType(this.liveView.dataType);
		if (this.isDesignLoaded())
			this.doAutoUpdate();
	},
	// ==========================================================
	// Server I/O
	// ==========================================================
	_getCanUpdate: function() {
		return this.inherited(arguments) &&
			!(this.operation == "read" && this._isSourceDataBound() && wm.isEmpty(this.sourceData.getData()) );
	},
	// FIXME: need to zot this
	operationChanged: function() {
	},
	_update: function() {
		// note: runtime service only available when application is deployed
		// so must wait until here to set it.
		if (this.designTime)
			this._service = wm.getRuntimeServiceDesignTime(this);
		else
			this._service = wm.getRuntimeService(this);
		//console.log(this.name, "update");
		return this.inherited(arguments);
	},
	getArgs: function() {
		var
			d = this.sourceData.getData(),
			t = this.sourceData.type || this.type,
			s = wm.typeManager.getService(this.type),
			args = [s, t, wm.isEmpty(d) ? null : d];
		if (this.operation == "read") {
			args = args.concat(this._getReadArguments());
		}
		return args;
	},
	_getReadArguments: function() {
		var
			props = {properties: this._getEagerProps(this), filters: this._getFilters(), matchMode: this.matchMode, ignoreCase: this.ignoreCase},
			paging = this.orderBy ? {orderBy: (this.orderBy || "").split(",")} : {},
			max = this.isDesignLoaded() ? this.designMaxResults : this.maxResults,
			results = max ? { maxResults: max, firstResult: this.firstRow } : {};
		dojo.mixin(paging, results);
		return [props, paging];
	},
	_getFilters: function() {
		return this._getFilterValues(this.filter.getData());
	},
	_getFilterValues: function(inData, inPrefix) {
		var f = [], d, p;
		for (var i in inData) {
			d = inData[i];
			p = (inPrefix ? (inPrefix ||"") + "." : "") + i;
			if (dojo.isObject(d) && d !== null)
				f = f.concat(this._getFilterValues(d, p));
			else if (p !== undefined && d !== undefined && d !== null)
				f.push(p + "=" + d);
		}
		return f;
	},
	_isSourceDataBound: function() {
		var wires = this.$.binding.wires, w;
		for (var i in wires) {
			w = wires[i];
			if ((w.targetProperty || "").indexOf("sourceData") == 0)
				return true;
		}
	},
	processResult: function(inResult) {
		this.dataSetCount = this._service.fullResult.dataSetSize;
		this.inherited(arguments);
	},
	//===========================================================================
	// Paging
	//===========================================================================
	/** Return the current data page; only relevant when maxResults is set. */
	getPage: function() {
		return Math.floor(this.firstRow / (this.maxResults || 1));
	},
	/** Return the total number of data pages. */
	getTotalPages: function() {
		return Math.ceil((this.dataSetCount || 1) / (this.maxResults || 1));
	},
	/** Set and retrieve the current data page.
		@param {Number} inPageIndex the page number to set
	 */
	setPage: function(inPageIndex) {
		inPageIndex = Math.max(0, Math.min(this.getTotalPages()-1, inPageIndex));
		this.firstRow = inPageIndex * (this.maxResults || 0);
		this.update();
	},
	/** Set and retrieve the next page of data. */
	setNextPage: function() {
		this.setPage(this.getPage()+1);
	},
	/** Set and retrieve the previous page of data. */
	setPreviousPage: function() {
		this.setPage(this.getPage()-1);
	},
	/** Set and retrieve the first page of data. */
	setFirstPage: function() {
		this.setPage(0);
	},
	/** Set and retrieve the last page of data. */
	setLastPage: function() {
		this.setPage(this.getTotalPages()-1);
	}
});

//===========================================================================
// Design Only
//===========================================================================

wm.Object.extendSchema(wm.LiveVariable, {
	update: {ignore: 1, publicEvent: 1},
	related: { ignore: 1},
	view: { ignore: 1},
	service: { ignore: 1},
	dataType: { ignore: 1},
	operation: { group: "data", order: 0},
	input: {ignore: 1},
	liveSource: { group: "data", order: 1},
	liveView: { ignore: 1},
	sourceData: {ignore: 1, group: "data", order: 3, bindTarget: 1, categoryParent: "Properties", categoryProps: {component: "sourceData", inspector: "Data"}},
	filter: { ignore: 1, group: "data", order: 5, bindTarget: 1, categoryParent: "Properties", categoryProps: {component: "filter", inspector: "Data"}},
	matchMode: {group: "data", order: 10},
	firstRow: {group: "data", order: 15},
	//maxResults: {group: "data", order: 17},
	//designMaxResults: {group: "data", order: 18},
	orderBy: {group: "data", order: 19},
	ignoreCase:  {group: "data", order: 20},
	configure: { ignore: 1 },
	dataSetCount: { ignore: 1 }
});

wm.LiveVariable.extend({
	_operations: ["read", "insert", "update", "delete"],
	_matchModes: ["start", "end", "anywhere", "exact"],
	listProperties: function() {
		var
			p = this.inherited(arguments),
			r = (this.operation == "read");
		p.matchMode.ignore = !r;
		p.firstRow.ignore = !r;
		p.maxResults.ignore = !r;
		p.designMaxResults.ignore = !r;
		p.orderBy.ignore = !r;
		p.ignoreCase.ignore = !r;
		p.filter.bindTarget = r;
		p.filter.categoryParent = r ? "Properties" : "";
		return p;
	},
	isListBindable: function() {
		return this.operation == "read" ? !(this.sourceData && !wm.isEmpty(this.sourceData.getData())) : false;
	},
	designCreate: function() {
		this.inherited(arguments);
		this.subscribe("wmwidget-idchanged", this, "componentNameChanged");
		
	},
	componentNameChanged: function(inOldId, inNewId, inOldRtId, inNewRtId) {
		if (inOldId == this.liveSource)
			this.setLiveSource(inNewId);
	},
	set_operation: function(inOperation) {
		this.operation = inOperation;
		// just a good idea for safety
		if (this.isDesignLoaded()) {
			// automatically set autoUpdate to true if we're reading, 
			// since this is the default anyway, otherwise set to false.
			this.setAutoUpdate(inOperation == "read");
			if (studio.selected == this)
				studio.inspector.inspect(this);
		}
	},
	set_liveSource: function(inLiveSource) {
		this.setLiveSource(inLiveSource);
		if (this.isDesignLoaded() && studio.selected == this)
			studio.inspector.inspect(this);
	},
	set_sourceData: function(inSourceData) {
		this.setSourceData(inSourceData);
		if (this.isDesignLoaded() && studio.selected == this)
			studio.inspector.inspect(this);
	},
	set_filter: function(inFilter) {
		this.setFilter(inFilter);
		if (this.isDesignLoaded() && studio.selected == this)
			studio.inspector.inspect(this);
	},
	checkOrderBy: function(inOrderBy) {
		var
			orderParts = (inOrderBy || "").split(','),
			re = new RegExp("^(?:asc|desc)\:", "i");
		for (var i=0, o; (o = orderParts[i]); i++)
			if (!dojo.trim(o).match(re)) {
				alert("Each property used in the orderBy clause must be of the form asc|desc: <propertyPath>. \"" + o + "\" does not match this format." + 
					" The current orderBy clause will generate an error and should be corrected.");
				return;
			}
		return true;
	},
	set_orderBy: function(inOrderBy) {
		this.checkOrderBy(inOrderBy);
		this.setOrderBy(inOrderBy);
	},
	makePropEdit: function(inName, inValue, inDefault) {
		switch (inName) {
			case "liveSource":
				return new wm.propEdit.LiveSourcesSelect({component: this, name: inName, value: inValue});
			case "matchMode":
				return makeSelectPropEdit(inName, inValue, this._matchModes, inDefault);
			case "operation":
				return makeSelectPropEdit(inName, inValue, this._operations, inDefault);
		}
		return this.inherited(arguments);
	}
});


}

if(!dojo._hasResource["dojo.rpc.RpcService"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["dojo.rpc.RpcService"] = true;
dojo.provide("dojo.rpc.RpcService");

dojo.declare("dojo.rpc.RpcService", null, {
	constructor: function(args){
		//summary:
		//Take a string as a url to retrieve an smd or an object that is an smd or partial smd to use
		//as a definition for the service
		//
		//	args: object
		//		Takes a number of properties as kwArgs for defining the service.  It also
		//		accepts a string.  When passed a string, it is treated as a url from
		//		which it should synchronously retrieve an smd file.  Otherwise it is a kwArgs
		//		object.  It accepts serviceUrl, to manually define a url for the rpc service
		//		allowing the rpc system to be used without an smd definition. strictArgChecks
		//		forces the system to verify that the # of arguments provided in a call
		//		matches those defined in the smd.  smdString allows a developer to pass
		//		a jsonString directly, which will be converted into an object or alternatively
		//		smdObject is accepts an smdObject directly.
		//				
		if(args){
			//if the arg is a string, we assume it is a url to retrieve an smd definition from
			if( (dojo.isString(args)) || (args instanceof dojo._Url)){
				if (args instanceof dojo._Url){
					var url = args + "";
				}else{
					url = args;
				}
				var def = dojo.xhrGet({
					url: url,
					handleAs: "json-comment-optional",
					sync: true
				});
				
				def.addCallback(this, "processSmd");
				def.addErrback(function() {
					throw new Error("Unable to load SMD from " + args);
				});

			}else if(args.smdStr){
				this.processSmd(dojo.eval("("+args.smdStr+")"));
			}else{
				// otherwise we assume it's an arguments object with the following
				// (optional) properties:
				//      - serviceUrl
				//      - strictArgChecks
				//      - smdStr
				//      - smdObj

				if(args.serviceUrl){
					this.serviceUrl = args.serviceUrl;
				}

				this.timeout = args.timeout || 3000;

				if("strictArgChecks" in args){
					this.strictArgChecks = args.strictArgChecks;
				}

				this.processSmd(args);
			}
		}
	},

	strictArgChecks: true,
	serviceUrl: "",

	parseResults: function(obj){
		// summary
		// 		parse the results coming back from an rpc request.  this
		// 		base implementation, just returns the full object
		// 		subclasses should parse and only return the actual results
		//	obj: Object
		//		Object that is the return results from an rpc request
		return obj;
	},

	errorCallback: function(/* dojo.Deferred */ deferredRequestHandler){
		// summary:
		//		create callback that calls the Deferres errback method
		//	deferredRequestHandler: Deferred
		//		The deferred object handling a request.
		return function(data){
			deferredRequestHandler.errback(data.message);
		};
	},

	resultCallback: function(/* dojo.Deferred */ deferredRequestHandler){
		// summary:
		// 		create callback that calls the Deferred's callback method
		//	deferredRequestHandler: Deferred
		//		The deferred object handling a request.

		var tf = dojo.hitch(this, 
			function(obj){
				if(obj.error!=null){
					var err;
					if(typeof obj.error == 'object'){
						err = new Error(obj.error.message);
						err.code = obj.error.code;
						err.error = obj.error.error;
					}else{
						err = new Error(obj.error);
					}
					err.id = obj.id;
					err.errorObject = obj;
					deferredRequestHandler.errback(err);
				}else{
					deferredRequestHandler.callback(this.parseResults(obj)); 
				}
			}
		);
		return tf;
	},

	generateMethod: function(/*string*/ method, /*array*/ parameters, /*string*/ url){
		// summary:
		// 		generate the local bind methods for the remote object
		//	method: string
		//		The name of the method we are generating
		//	parameters: array
		//		the array of parameters for this call.
		//	url: string
		//		the service url for this call

		return dojo.hitch(this, function(){
			var deferredRequestHandler = new dojo.Deferred();

			// if params weren't specified, then we can assume it's varargs
			if( (this.strictArgChecks) &&
				(parameters != null) &&
				(arguments.length != parameters.length)
			){
				// put error stuff here, no enough params
				throw new Error("Invalid number of parameters for remote method.");
			}else{
				this.bind(method, dojo._toArray(arguments), deferredRequestHandler, url);
			}

			return deferredRequestHandler;
		});
	},

	processSmd: function(object){
		// summary:
		// 		callback method for reciept of a smd object.  Parse the smd
		// 		and generate functions based on the description
		//	object:
		//		smd object defining this service.

		if(object.methods){
			dojo.forEach(object.methods, function(m){
				if(m && m.name){
					this[m.name] = this.generateMethod(	m.name,
										m.parameters, 
										m.url||m.serviceUrl||m.serviceURL);
					if(!dojo.isFunction(this[m.name])){
						throw new Error("RpcService: Failed to create" + m.name + "()");
						/*console.log("RpcService: Failed to create", m.name, "()");*/
					}
				}
			}, this);
		}

		this.serviceUrl = object.serviceUrl||object.serviceURL;
		this.required = object.required;
		this.smd = object;
	}
});

}

if(!dojo._hasResource["dojo.rpc.JsonService"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["dojo.rpc.JsonService"] = true;
dojo.provide("dojo.rpc.JsonService");


dojo.declare("dojo.rpc.JsonService", dojo.rpc.RpcService, {
		bustCache: false,
		contentType: "application/json-rpc",
		lastSubmissionId: 0,

		callRemote: function(method, params){
			// summary:
			// 		call an arbitrary remote method without requiring it to be
			// 		predefined with SMD
			//	method: string
			//		the name of the remote method you want to call.
			//	params: array
			//		array of parameters to pass to method

			var deferred = new dojo.Deferred();
			this.bind(method, params, deferred);
			return deferred;
		},

		bind: function(method, parameters, deferredRequestHandler, url){
			//summary:
			//		JSON-RPC bind method. Takes remote method, parameters,
			//		deferred, and a url, calls createRequest to make a JSON-RPC
			//		envelope and passes that off with bind.
			//	method: string
			//		The name of the method we are calling
			//	parameters: array
			//		The parameters we are passing off to the method
			//	deferredRequestHandler: deferred
			//		The Deferred object for this particular request

			var def = dojo.rawXhrPost({
				url: url||this.serviceUrl,
				postData: this.createRequest(method, parameters),
				contentType: this.contentType,
				timeout: this.timeout, 
				handleAs: "json-comment-optional"
			});
			def.addCallbacks(this.resultCallback(deferredRequestHandler), this.errorCallback(deferredRequestHandler));
		},

		createRequest: function(method, params){
			// summary:
			//	create a JSON-RPC envelope for the request
			//	method: string
			//		The name of the method we are creating the requst for
			//	params: array
			//		The array of parameters for this request;
			
			var req = { "params": params, "method": method, "id": ++this.lastSubmissionId };
			var data = dojo.toJson(req);
			return data;
		},

		parseResults: function(/*anything*/obj){
			//summary:
			//		parse the result envelope and pass the results back to
			//		the callback function
			//	obj: Object
			//		Object containing envelope of data we recieve from the server

			if(dojo.isObject(obj)){
				if("result" in obj){
					return obj.result;
				}
				if("Result" in obj){
					return obj.Result;
				}
				if("ResultSet" in obj){
					return obj.ResultSet;
				}
			}
			return obj;
		}
	}
);

}

if(!dojo._hasResource["wm.base.components.JsonRpcService"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["wm.base.components.JsonRpcService"] = true;
/*
 *  Copyright (C) 2008-2010 WaveMaker Software, Inc.
 *
 *  This file is part of the WaveMaker Client Runtime.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
dojo.provide("wm.base.components.JsonRpcService");



wm.inflight = {
	_inflight: [],
	getCount: function() {
		return this._inflight.length;
	},
	change: function() {
	},
	add: function(inDeferred) {
		inDeferred._timeStamp = new Date().getTime();
		this._inflight.push(inDeferred);
		inDeferred.addBoth(dojo.hitch(this, "remove", inDeferred));
		this.change();
	},
	remove: function(inDeferred, inResult) {
		var i = dojo.indexOf(this._inflight, inDeferred);
		if (i==-1)
			return;
		var delta = new Date().getTime() - inDeferred._timeStamp;
		//console.info("deferred inflight for ", delta + "ms", inDeferred);
		this._inflight.splice(i, 1);
		this.change();
		return inResult;
	},
	cancel: function() {
		dojo.forEach(this._inflight, function(d) {
			if (!d.canceller)
				d.canceller = function() {};
			d.cancel();
		});
	}
}

dojo.subscribe("wm-unload-app", wm.inflight, "cancel");

dojo.declare("wm.JsonRpc", dojo.rpc.JsonService, {
	smd: null,
	required: false,
	sync: false,
	designTime: false,
	bind: function(method, parameters, deferredRequestHandler, url){
		//console.log("method", method, "parameters", parameters || [], "url", url || this.serviceUrl);
		url = url || this.serviceUrl;
		if (!url)
			return;
		if (this.designTime) 
					url = url + "?designTime=true";
		var props = {
			url: url||this.serviceUrl,
			postData: this.createRequest(method, parameters || []),
			contentType: this.contentType,
			timeout: this.timeout, 
			handleAs: "json",
			sync: this.sync
		}
		var def = dojo.rawXhrPost(props);
		def.addCallbacks(this.resultCallback(deferredRequestHandler), this.errorCallback(deferredRequestHandler));
	},
	// override dojo default, we want full result object, not just {result: ...}
	parseResults: function(obj){
		return obj;
	}
});

dojo.declare("wm.JsonRpcService", wm.Service, {
	operations: "",
	ready: false,
	service: "",
	// 0 indicates no timeout.
	timeout: 0,
	errorLevel: 10,
	sync: false,
	url: "",
	_methods: [],
	_operations: {},
	_service: null,
	init: function() {
		//dojo.mixin(this.readonlyProps, { methods: 1, ready: 1 });
		this.inherited(arguments);
		this.initService();
	},
	setSync: function(inSync) {
		this.sync = inSync;
	},
	getServiceRoot: function() {
		return this.getPath() + "services/";
	},
	getJsonPath: function() {
		var p = '';
		// this window.studio test is needed for the login page to run when not in debug mode
		if(this.isDesignLoaded() && window.studio && studio.project) {
		    var projectPrefix = studio.projectPrefix;
		    p = '/' + projectPrefix + studio.project.getProjectPath() + '/';
		}
		return p;
	},
	// FIXME: we're making a new service object for every rpc service.
	// This is unnecessary and one side effect is that the smd is re-requested for each rpc service
	// at the least we could cache this smd data to avoid re-retrieving it.
	// it seems unnecessary to have more than one JsonRpc per service
	// and it may be unnecessary to have more than one JsonRpcService (ever) per service 
	// JsonRpcService has a few properties that make collapsing the number of them non-trivial (e.g. sync, timeout)
	initService: function() {
		var
			n = this.service || this.name,
		    url = this.url || (n && (this.getServiceRoot() + n + ".smd?rand=" + Math.floor(Math.random()*1000000)));
		this._service = null;
		if (url) {
			try{
			    this._service = wm.JsonRpcService.smdCache[url];
			    if (this._service) {
				this.listOperations();
			    } else {

				this._service = new wm.JsonRpc(url);
				if (this.designTime)
					this._service.designTime = true;
				this._service.timeout = this.timeout;
				this.ready = Boolean(this._service && this._service.smd);
				if (this.ready) {
				    this._service.serviceUrl = this.getJsonPath() + this._service.serviceUrl;
				    this.listOperations();
				}
			    }
			}catch(e){
				console.debug(e);
			}
		}
	},
	setName: function(inName) {
		this.inherited(arguments);
		if (!this.url)
			this.initService();
	},
	ensureArgs: function(inMethod, inArgs) {
		if (inMethod in this._operations && dojo.isArray(inArgs)) {
			var op = this._operations[inMethod], argCount=0;
			if (op) {
				for (var o in op.parameters)
					argCount++;
				for (var i=inArgs.length; i<argCount; i++)
					inArgs.push(null);
			}
		}
	},
        invoke: function(inMethod, inArgs, owner) {
		if (!this._service) 
			return null;
		this._service.sync = this.sync;
		this.ensureArgs(inMethod, inArgs);
		//if (wm.logging)
	        this.debugLastMethod = inMethod;
		if (djConfig.isDebug && !dojo.isFF) {
		    console.group("JsonRpcService.invoke method:", inMethod);
		    if (inArgs && inArgs.length) {
		      console.log("Arguments:");
		      console.log(inArgs); 
		    }
		    console.groupEnd();
		}
		this.result = null;
		this.error = null;
		var d = this._service.callRemote(inMethod, inArgs || []);
		d.addBoth(dojo.hitch(this, function(r) {
			this.inflight = false;
			return r;
		}));
		d.addCallbacks(dojo.hitch(this, "onResult"), dojo.hitch(this, "onError"));
		wm.inflight.add(d);
		this.inflight = true;
		return d;
	},
	request: function(inMethod, inArgs, inResult, inError) {
		var d = this.invoke(inMethod, inArgs);
		if (inResult) {
			if (dojo.isFunction(inResult))
				d.addCallback(inResult);
			else
				d.addCallback(this.owner, inResult);
		}
		if (inError) {
			if (dojo.isFunction(inError))
				d.addErrback(inError);
			else
				d.addErrback(this.owner, inError);
		}
		return d;
	},
	// force a sync call, irrespective of our sync setting
	requestSync: function(inMethod, inArgs, inResult, inError) {
		var s = this.sync;
		this.sync = true;
		var d = this.request.apply(this, arguments);
		this.sync = s;
		return d;
	},
	// force an async call, irrespective of our sync setting
	requestAsync: function(inMethod, inArgs, inResult, inError) {
		var s = this.sync;
		this.sync = false;
		var
			cb = inResult ? dojo.hitch(this, function() {
				this.sync = s;
				return inResult.apply(this, dojo._toArray(arguments));
			}) : null,
			eb = inError ? dojo.hitch(this, function() {
				this.sync = s;
				return inError.apply(this, dojo._toArray(arguments));
			}) : null;
		return this.request(inMethod, inArgs, cb, eb);
	},
	getResultSync: function(inMethod, inArgs) {
		var d = this.requestSync(inMethod, inArgs);
		return d.results[0];
	},
	onResult: function(inResult) {
		var r = this.fullResult = inResult;
		this.result = (r || 0).result;
		if (djConfig.isDebug && !dojo.isFF) {
			console.group("Service Call Completed: " + this.name + "." + this.debugLastMethod);
			if (this.result) {
			    console.log(this.result);
			} else {
			    console.log("Response was null");
			}
			console.groupEnd();
		}
		return this.result;
	},
	onError: function(inError) {
	    try {
	        console.group("Service Call Failed: " + this.name + "." + this.debugLastMethod);                              
		if (inError)
		  console.error(inError.message);                                                                               
                console.groupEnd();    
		var errCodes = inError.message.match(/(\d+)$/);
		var errCode = (errCodes) ? errCodes[0] : "";

		// If the failer is a security access error, AND if its NOT a security error that comes from live view 
		// (happens when a project accesses the server while running within studio), then tell the user to log back in.
		// Also don't repeat this alert more than once every 3 minutes (it takes 4 server accesses to open a page, so thats 4 alerts in a row!)
		if (errCode == 403) {
		      dojo.publish("session-expiration", []);
		} 	       
	    } catch(e) {		
		if (wm.logging) {
		    console.dir(e);
		    console.dir(inError);
		}
	    }
	    this.reportError(inError);
	    return this.error = inError;
	},
	reportError: function(inError) {
		var m = dojo.isString(inError) ? inError : (inError.message ? "Error: " + inError.message : "Unspecified Error");
		m = (this.name ? this.name + ": " : "") + m;
		if (this.errorLevel > 5) {
			if (!inError.dojoType == "cancel")
				console.error(m);
		} else if (this.errorLevel > 0)
			wm.logging && console.debug(m);
	},
	paramArrayToHash: function(inParams) {
		var hash = {};
		for (var i=0, p; (p=inParams[i]); i++)
		    hash[p.name] = { type: p.type, hidden: p.hidden };
		return hash;
	},
	listOperations: function() {
		this._methods = [];
		this._operations = {};
		var m = (this._service.smd||0).methods || [];
		for (var i=0, op; (op=m[i]); i++){
			this._methods.push(op.name);
			this._operations[op.name] = {
				parameters: this.paramArrayToHash(op.parameters || []),
				returnType: op.returnType || "any"
			};
		}
		this._methods.sort();
	}, 
	makePropEdit: function(inName, inValue, inDefault) {
		if (inName == "operations")
			return makeSelectPropEdit(inName, inValue, this._methods||[], inDefault);
		return this.inherited(arguments);
	}
});

wm.Object.extendSchema(wm.JsonRpcService, {
	ready: { ignore: 1 }
});

wm.JsonRpcService.description = "Any JsonRpc service.";
wm.JsonRpcService.smdCache = {};

}

if(!dojo._hasResource["wm.base.components.NavigationService"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["wm.base.components.NavigationService"] = true;
/*
 *  Copyright (C) 2008-2010 WaveMaker Software, Inc.
 *
 *  This file is part of the WaveMaker Client Runtime.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
dojo.provide("wm.base.components.NavigationService");


/**
	Service for client side navigation.
	<br /><br />
	Navigation methods on this class are also
	available as service operations where noted.
	Service operation inputs match the
	arguments on the related method, and so they
	are not documented separately.
	<br />
	@name wm.NavigationService
	@class
	@extends wm.Service
*/
dojo.declare("wm.NavigationService", wm.Service, {
	/** @lends wm.NavigationService.prototype */
	layer: "",
	layers: "",
	operation: "",
	_operations: {
		gotoLayer: {
			parameters: {
			        layer: { type: "wm.Layer"},
				showOnlyParentLayer: {type: "boolean"}
			},
			returnType: "any",
			hint: "This operations displays the selected layer."
		},
		nextLayer: {
			parameters: {
				layers: { type: "wm.Layers"}
			},
			returnType: "any",
			hint: "The operation displays the next layer in the selected layers widget."
		},
		previousLayer: {
			parameters: {
				layers: { type: "wm.Layers"}
			},
			returnType: "any",
			hint: "The operation displays the previous layer in the selected layers widget."
		},
		gotoPage: {
			parameters: {
				pageName: { type: "string" }
			},
			returnType: "any",
			hint: "This operation displays a different page and requires a pageName."
		},
		gotoPageContainerPage: {
			parameters: {
				pageName: { type: "string" },
				pageContainer: { type: "wm.PageContainer" }
			},
			returnType: "any",
			hint: "This operation displays a page in a pageContainer and requires both a pageContainer and a pageName."
		},
		gotoDialogPage: {
			parameters: {
				pageName: {type: "string"},
				hideControls: {type: "boolean"},
				title: {type: "string"},
				modal: {type: "boolean"},
				width: {type: "number"},
				height: {type: "number"}
			},
			returnType: "any",
			hint: "This operation displays a page in a dialog."
		    },
		showToast: {
			parameters: {
				content: {type: "string"},
				duration: {type: "number"},
 			    cssClasses: {type: "string"},
                            dialogPosition: {type: "string"}
			},
			returnType: "any",
			hint: "This operation displays a page in a dialog."
		}
	},
	update: function() {
		this[this.operation || "gotoLayer"]();
	},
        invoke: function(inMethod, inArgs, inOwner) {
		var
			d = this._deferred = new dojo.Deferred(),
			m = this[inMethod];
	       
		if (m) {
		       inArgs.push(inOwner);
		       m.apply(this, inArgs);
		} else {
			this.onError();
			d.errback("operation: " + inMethod + " does not exist.");
		}
		return d;
	},
	doResult: function() {
		if (this._resultConnect) {
			dojo.disconnect(this._resultConnect);
			this._resultConnect = null;
		}
		this.onResult();
		if (this._deferred && this._deferred.fired == -1)
			this._deferred.callback(true);
		this._deferred = null;
	},
	/**
		Shows a layer.
		<br /><br />
		This method is available as a configurable operation on this service.
		@param {wm.Layer} inLayer The layer to show.
	*/
	gotoLayer: function(inLayer,showParentOnly) {
		var l = inLayer instanceof wm.Layer ? inLayer : null;
		if (l)
		  this.showLayer(l,showParentOnly);
		this.doResult();
	},
	/**
		Show the next layer in a set of layers.
		<br /><br />
		This method is available as a configurable operation on this service.
		@param {wm.Layers} inLayers The set of layers to operate on.
	*/
	nextLayer: function(inLayers) {
		var l = inLayers instanceof wm.Layers ? inLayers : null;
		if (l)
			l.setNext();
		this.doResult();
	},
	/**
		Show the previous layer in a set of layers.
		<br /><br />
		This method is available as a configurable operation on this service.
		@param {wm.Layers} inLayers The set of layers to operate on.
	*/
	previousLayer: function(inLayers) {
		var l = inLayers instanceof wm.Layers ? inLayers : null;
		if (l)
			l.setPrevious();
		this.doResult();
	},
	showLayer: function(inLayer,showParentOnly) {
		var l = inLayer;
		while (l) {
			wm.fire(l, "activate");
			l = l.parent;
			if (showParentOnly) break;
		}
	},
	/**
		Dynamically load and show a top level page.
		<br /><br />
		This method is available as a configurable operation on this service.
		@param {String} inPageName The page to load.
	*/
        gotoPage: function(inPageName, inOwner) {
	    var page = inOwner.getParentPage();
	    // If no app level page exists yet (untested condition that probably never arises)
	    // Or if inOwner has no page (untested condition that implies the owner is app level or has an improperly set owner)
	    // Or if the page of inOwner is the app level page, then change the app level page
	    if (!app._page || !page || page == app._page) {
		this._resultConnect = dojo.connect(app, "onPageChanged", this, "doResult");

                // Delay openning the page as loading the page immediately will cause the widgets/components that triggered this to be destroyed in the
                // middle of calling this.  Use wm.job so that if another page request fires, this one is canceled
                wm.job(this.getId() + ": PageChange", 1, function() {
		    app.loadPage(inPageName);
                });
	    } else if (page.owner instanceof wm.PageContainer || page.owner instanceof wm.PageContainerMixin) {
		this.gotoPageContainerPage(inPageName, page.owner);
	    }
	},
	/**
		Dynamically load and show a page inside of a page container.
		<br /><br />
		This method is available as a configurable operation on this service.
		@param {String} inPageName The page to load.
		@param {wm.PageContainer} inPageContainer The page container that will contain the page.
	*/
	gotoPageContainerPage: function(inPageName, inPageContainer) {
		if (inPageContainer) {
			// note, pageContainer does not call onPageChanged unless a page actually changed
			// to avoid confusion, we choose to process the navigation regardless
			// so call doResult manually if the page will not change.
			if (inPageName != inPageContainer.pageName) {
			    this._resultConnect = dojo.connect(inPageContainer, "onPageChanged", this, "doResult");
			    inPageContainer.setPageName(inPageName);

			} else
				this.doResult();
		} else
			wm.logging && console.debug("pageContainer not found", inPageContainer);
	},
	/**
		Dynamically load and show a page inside of dialog box.
		<br /><br />
		This method is available as a configurable operation on this service.
		@param {String} inPageName The page to load.
		@param {Boolean} inHideControls Set true to hide the default dialog controls.
		@param {Number} inWidth The width of the dialog content area in pixels.
		@param {Number} inHeight The height of the dialog content area in pixels.
	*/
	    gotoDialogPage: function(inPageName, inHideControls, inTitle, inModal, inWidth, inHeight) {
		this._resultConnect = dojo.connect(app.pageDialog, "onPageReady", this, "doResult");
		app.pageDialog.showPage(inPageName, inHideControls, String(inWidth)+"px", String(inHeight)+"px", inTitle, inModal);
	},
        showToast: function(inContent, inDuration, cssClasses, toastPosition) {
	    app.toastDialog.showToast(inContent, inDuration, cssClasses, toastPosition);
	    this._deferred.callback(); // the action is now complete; fire any deferred code (clears this._requester)
	}

});

wm.services.add({name: "navigationService", ctor: "wm.NavigationService", isClientService: true, clientHide: true});

}

if(!dojo._hasResource["wm.base.components.NavigationCall"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["wm.base.components.NavigationCall"] = true;
/*
 *  Copyright (C) 2008-2010 WaveMaker Software, Inc.
 *
 *  This file is part of the WaveMaker Client Runtime.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
dojo.provide("wm.base.components.NavigationCall");



/**
	Encapsulates a {@link wm.NavigationService} configuration with a trigger to invoke the configured service.
	@see wm.ServiceCall#update
	@name wm.NavigationCall
	@class
	@extends wm.Component
	@extends wm.ServiceCall
*/
dojo.declare("wm.NavigationCall", [wm.Component, wm.ServiceCall], {
	/** @lends wm.Variable.prototype */
	service: "navigationService",
	operation: "gotoLayer",
	// page navigation can lead to destruction, so abort processing
	processResult: function(inResult) {
		if (!this.owner)
			return;
		return this.inherited(arguments);
	},
	processError: function(inError) {
		if (!this.owner)
			return;
		return this.inherited(arguments);
	}
});

wm.Object.extendSchema(wm.NavigationCall,{
	owner: { group: "common", order: 1, readonly: true, options: ["Page", "Application"], ignore: 1 },
	autoUpdate: {ignore: 1},
        startUpdateComplete: { ignore: 1},
	startUpdate: {ignore: 1},
	service: {ignore: 1, writeonly: 1},
	operation: { group: "common", order: 24},
	updateNow: { ignore: 1},
	queue: { group: "operation", order: 20},
	clearInput: { group: "operation", order: 30},
	input: { ignore: 1 , writeonly: 1, componentonly: 1, categoryParent: "Properties", categoryProps: {component: "input", bindToComponent: true, inspector: "Navigation"}}
});

// design only...
/**#@+ @design */
wm.NavigationCall.extend({
	listProperties: function() {
		var result = this.inherited(arguments);
		result.owner.ignore = (this.operation == "gotoPage" || this.operation == "gotoDialogPage") ? 0 : 1;
		return result;
	},
	operationChanged: function() {
		this.inherited(arguments);
	    if (this.isDesignLoaded() && this.owner instanceof wm.Application && this.operation != "gotoPage" && this.operation != "gotoDialogPage" && studio.page) {
			this.set_owner("Page");
		}
	}

});
/**#@- @design */

wm.NavigationCall.description = "Navigation service call.";

}

if(!dojo._hasResource["wm.base.components.TypeDefinition"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["wm.base.components.TypeDefinition"] = true;
/*
 *  Copyright (C) 2010 WaveMaker Software, Inc.
 *
 *  This file is part of the WaveMaker Client Runtime.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at 
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
dojo.provide("wm.base.components.TypeDefinition");


dojo.declare("wm.TypeDefinitionField", wm.Component, {
    fieldType: "String", // options are "string/String", "Date", "Boolean", "any", "Number", as well as any more complex types.  Note that String/Number are not the same as StringType and NumberType; they are literals not objects.
    isObject: false, // boolean
    isList: false, // boolean 
    fieldName: "",
    init: function() {
        this.inherited(arguments);
        this.setFieldName(this.fieldName);
    },
    toTypeObj: function() {
        return {type: this.fieldType, isObject: this.isObject, isList: this.isList};
    },
    setFieldName: function(inFieldName) {
        this.fieldName = inFieldName;
        this._treeNodeName = inFieldName; // used by studio to show node in model tree
        if (!this._cupdating) {
            this.owner.doRemoveType();
            this.owner.doAddType();
        }
    },
    setFieldType: function(inType) {
        this.fieldType = inType || "String";
        if (!this._cupdating) {
            this.owner.doRemoveType();
            this.owner.doAddType();
        }
    },
    setIsObject: function(inIsObject) {
        this.isObject = inIsObject;
        if (!this._cupdating) {
            this.owner.doRemoveType();
            this.owner.doAddType();
        }
    },
    setIsList: function(inIsList) {
        this.isList = inIsList;
        if (!this._cupdating) {
            this.owner.doRemoveType();
            this.owner.doAddType();
        }
    }


});
wm.TypeDefinitionField.extend({
	makePropEdit: function(inName, inValue, inDefault) {
		switch (inName) {
			case "fieldType":
				return new wm.propEdit.AllDataTypesSelect({component: this, name: inName, value: inValue});
                }
            return this.inherited(arguments);
        }
});

wm.Object.extendSchema(wm.TypeDefinitionField, {
    documentation: {ignore: true},
    generateDocumentation: {ignore: true}
});

dojo.declare("wm.TypeDefinition", wm.Component, {
    internal: false,
    collection: "Fields",
    fields: null,
    init: function() {
	this.inherited(arguments);
	if (this.isDesignLoaded() && studio.application)
	    this.setOwner(studio.application);
    },
    // not init; must wait for page loader to load all subcomponents (typedefinitionfields) which postInit waits for
    postInit: function() {
/*
        for (var i in this.$) {
            this.$[i].parent = this;
        }
        */
        this.doAddType();
    },
    doRemoveType: function() {
        wm.typeManager.removeType(this.name);
    },
    doAddType: function() {
        this.fieldsAsTypes = {};
        for (var i in this.$) {
            this.fieldsAsTypes[this.$[i].fieldName] = this.$[i].toTypeObj();
        }
        wm.typeManager.addType(this.name, {internal: this.internal, fields: this.fieldsAsTypes});        
        dojo.publish("TypeChange-" + this.name);
    },
    getCollection: function(inName) {
        if (!this.fields) {
            this.fields = [];
            for (var i in this.$) {
                this.fields.push(this.$[i]);
            }
        }
        return this.fields;
    },
    setName: function(inName) {
        this.doRemoveType();
        this.inherited(arguments);
        this.doAddType();
    }

});

wm.Object.extendSchema(wm.TypeDefinition, {
    addField: {group: "operation", order: 1},
    internal: {ignore: true}, // only way to set something as internal is to hardcode it into widgets.js; should only be internal if in use by studio to define a type for use by studio but not by the user
    owner: {ignore: true}
});

wm.TypeDefinition.extend({
    addField: "(add field)",
	makePropEdit: function(inName, inValue, inDefault) {
		switch (inName) {
			case "addField":
				return makeReadonlyButtonEdit(inName, inValue, inDefault);
                }
            return this.inherited(arguments);
        },
	editProp: function(inName, inValue, inInspector) {
	    switch (inName) {
	    case "addField":
                this.addField();
                return;
            }
            return this.inherited(arguments);
        },
        addField: function() {
            this.fields = null; // force this to be recalculated
            this.fieldsAsTypes = null;
	    var	defName = this.getUniqueName("field1");
            var field = new wm.TypeDefinitionField({name: defName, owner: this});
	    studio.refreshComponentOnTree(this);
	    studio.select(field);
            this.doRemoveType(); // old type def is missing this field
            this.doAddType(); // now we update the type def
        }
});

}

if(!dojo._hasResource["wm.base.components.ServerComponent"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["wm.base.components.ServerComponent"] = true;
/*
 *  Copyright (C) 2008-2010 WaveMaker Software, Inc.
 *
 *  This file is part of the WaveMaker Client Runtime.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
dojo.provide("wm.base.components.ServerComponent");


/**
	Base class for all server-side components.
	@name wm.ServerComponent
	@class
	@extends wm.Component
*/
dojo.declare("wm.ServerComponent", wm.Component, {
	noInspector: true,
	init: function() {
		this.inherited(arguments);
		this.publishClass = this.publishClass || this.declaredClass;
	},
	prepare: function() {
		this.inherited(arguments);
		this.setOwner(null);
	},
	write: function() {
		return "";
	},
	designSelect: function() {
		this.editView();
	},
	editView: function() {
	}
});

}

if(!dojo._hasResource["dojo.regexp"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["dojo.regexp"] = true;
dojo.provide("dojo.regexp");

/*=====
dojo.regexp = {
	// summary: Regular expressions and Builder resources
};
=====*/

dojo.regexp.escapeString = function(/*String*/str, /*String?*/except){
	//	summary:
	//		Adds escape sequences for special characters in regular expressions
	// except:
	//		a String with special characters to be left unescaped

	return str.replace(/([\.$?*|{}\(\)\[\]\\\/\+^])/g, function(ch){
		if(except && except.indexOf(ch) != -1){
			return ch;
		}
		return "\\" + ch;
	}); // String
}

dojo.regexp.buildGroupRE = function(/*Object|Array*/arr, /*Function*/re, /*Boolean?*/nonCapture){
	//	summary:
	//		Builds a regular expression that groups subexpressions
	//	description:
	//		A utility function used by some of the RE generators. The
	//		subexpressions are constructed by the function, re, in the second
	//		parameter.  re builds one subexpression for each elem in the array
	//		a, in the first parameter. Returns a string for a regular
	//		expression that groups all the subexpressions.
	// arr:
	//		A single value or an array of values.
	// re:
	//		A function. Takes one parameter and converts it to a regular
	//		expression. 
	// nonCapture:
	//		If true, uses non-capturing match, otherwise matches are retained
	//		by regular expression. Defaults to false

	// case 1: a is a single value.
	if(!(arr instanceof Array)){
		return re(arr); // String
	}

	// case 2: a is an array
	var b = [];
	for(var i = 0; i < arr.length; i++){
		// convert each elem to a RE
		b.push(re(arr[i]));
	}

	 // join the REs as alternatives in a RE group.
	return dojo.regexp.group(b.join("|"), nonCapture); // String
}

dojo.regexp.group = function(/*String*/expression, /*Boolean?*/nonCapture){
	// summary:
	//		adds group match to expression
	// nonCapture:
	//		If true, uses non-capturing match, otherwise matches are retained
	//		by regular expression. 
	return "(" + (nonCapture ? "?:":"") + expression + ")"; // String
}

}

if(!dojo._hasResource["dojo.cookie"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["dojo.cookie"] = true;
dojo.provide("dojo.cookie");



/*=====
dojo.__cookieProps = function(){
	//	expires: Date|String|Number?
	//		If a number, the number of days from today at which the cookie
	//		will expire. If a date, the date past which the cookie will expire.
	//		If expires is in the past, the cookie will be deleted.
	//		If expires is omitted or is 0, the cookie will expire when the browser closes. << FIXME: 0 seems to disappear right away? FF3.
	//	path: String?
	//		The path to use for the cookie.
	//	domain: String?
	//		The domain to use for the cookie.
	//	secure: Boolean?
	//		Whether to only send the cookie on secure connections
	this.expires = expires;
	this.path = path;
	this.domain = domain;
	this.secure = secure;
}
=====*/


dojo.cookie = function(/*String*/name, /*String?*/value, /*dojo.__cookieProps?*/props){
	//	summary: 
	//		Get or set a cookie.
	//	description:
	// 		If one argument is passed, returns the value of the cookie
	// 		For two or more arguments, acts as a setter.
	//	name:
	//		Name of the cookie
	//	value:
	//		Value for the cookie
	//	props: 
	//		Properties for the cookie
	//	example:
	//		set a cookie with the JSON-serialized contents of an object which
	//		will expire 5 days from now:
	//	|	dojo.cookie("configObj", dojo.toJson(config), { expires: 5 });
	//	
	//	example:
	//		de-serialize a cookie back into a JavaScript object:
	//	|	var config = dojo.fromJson(dojo.cookie("configObj"));
	//	
	//	example:
	//		delete a cookie:
	//	|	dojo.cookie("configObj", null, {expires: -1});
	var c = document.cookie;
	if(arguments.length == 1){
		var matches = c.match(new RegExp("(?:^|; )" + dojo.regexp.escapeString(name) + "=([^;]*)"));
		return matches ? decodeURIComponent(matches[1]) : undefined; // String or undefined
	}else{
		props = props || {};
// FIXME: expires=0 seems to disappear right away, not on close? (FF3)  Change docs?
		var exp = props.expires;
		if(typeof exp == "number"){ 
			var d = new Date();
			d.setTime(d.getTime() + exp*24*60*60*1000);
			exp = props.expires = d;
		}
		if(exp && exp.toUTCString){ props.expires = exp.toUTCString(); }

		value = encodeURIComponent(value);
		var updatedCookie = name + "=" + value, propName;
		for(propName in props){
			updatedCookie += "; " + propName;
			var propValue = props[propName];
			if(propValue !== true){ updatedCookie += "=" + propValue; }
		}
		document.cookie = updatedCookie;
	}
};

dojo.cookie.isSupported = function(){
	//	summary:
	//		Use to determine if the current browser supports cookies or not.
	//		
	//		Returns true if user allows cookies.
	//		Returns false if user doesn't allow cookies.

	if(!("cookieEnabled" in navigator)){
		this("__djCookieTest__", "CookiesAllowed");
		navigator.cookieEnabled = this("__djCookieTest__") == "CookiesAllowed";
		if(navigator.cookieEnabled){
			this("__djCookieTest__", "", {expires: -1});
		}
	}
	return navigator.cookieEnabled;
};

}

if(!dojo._hasResource["wm.base.components.Security"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["wm.base.components.Security"] = true;
/*
 *  Copyright (C) 2008-2010 WaveMaker Software, Inc.
 *
 *  This file is part of the WaveMaker Client Runtime.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
dojo.provide("wm.base.components.Security");




wm.disableUserPrincipalCookie = false;

wm.login = function(args, loginSuccessCallback, loginFailedCallback, properties, projectName) {
	if (properties === undefined || properties == null) {
		properties = {
			j_username : args[0],
			j_password : args[1]
		};
	}

	properties.acegiAjaxLogin = 'true';

	var def= dojo.xhrPost({
		url: (projectName ? '/' + projectName + '/' : '') + 'j_acegi_security_check',
		content : properties,
		handleAs: "json",
		load: function(response, ioArgs) {
			if (response.url) {
                            var pathname = location.protocol + "//" + location.host + location.pathname + location.search; // sometimes using search helps and sometimes it breaks this test; still working out what is going on
				if (dojo.cookie.isSupported() && !wm.disableUserPrincipalCookie) {
					var p = {username: properties.j_username, roles: wm.getUserRoles(true)};
					wm.setUserPrincipal(p);
				}
				if (loginSuccessCallback) {
					loginSuccessCallback(response.url);
				} else {
				    if (window.studio) {
					// studio.application is set to null on projectClose; studio.project seems to retain value
					if (studio.application && studio.page && studio.project) {
					    if (studio.studioService.requestSync("openProject", [studio.project.projectName]));
					    studio.navGotoDesignerClick();
					} else 
					    studio.startLayer.activate();
                                        // Typically this tests to see if we're on login.html and being directed to index.html
				    } else if (pathname != response.url) {
					location.href = response.url;

                                        // If the page name is login, but app.main is not login, then we're on the real project,
                                        // not the special project used for logging in.  If we're on the real project, a wm page nav is all that is needed
				    } else if (app._page.name == "login" && app.main != "login") {
                                        app.loadPage(app.main);
                                    }
				}
			} else if (response.error) {
				if (loginFailedCallback) {
					loginFailedCallback(response.error);
				} else {
					console.error(response.error);
				}
			}
		}
	});
}

wm.getUserPrincipal = function() {
	return wm.disableUserPrincipalCookie ? {} : 
		dojo.fromJson(dojo.cookie("wmUserPrincipal")) || {};
}

wm.setUserPrincipal = function(userPrincipal) {
	dojo.cookie("wmUserPrincipal", dojo.toJson(userPrincipal));
}

wm.clearUserPrincipal = function() {
	dojo.cookie("wmUserPrincipal", null, {expires: -1});
}

wm.getUserRoles = function(force) {
	if (!force && wm.getUserPrincipal().roles) {
		return wm.getUserPrincipal().roles;
	}
	var s = wm.securityService || (wm.securityService = 
		new wm.JsonRpcService({name: "securityService", sync: true}));
	try {
		if (s.ready) {
			s.request("getUserRoles", null);
			if (s.result) {
				return s.result;
			}
		}
	} catch(x) {}
}

wm.logout = function() {
	var s = wm.securityService || (wm.securityService = 
		new wm.JsonRpcService({name: "securityService", sync: true, errorLevel: 2}));
	try {
		if (s.ready) {
			s.request("logout", null);
			window.location.reload();
		}
	} catch(x) {}
}

/**
	Component that provides information about security.
	@name wm.Security
	@class
	@extends wm.ServerComponent
*/
dojo.declare("wm.Security", wm.ServerComponent, {
	afterPaletteDrop: function() {
		this.editView();
		studio.navGotoModelTreeClick();
		return true;
	},
	editView: function() {
		studio.navGotoEditor("Security");
	}
});

dojo.declare("wm.SecurityLoader", null, {
	getComponents: function() {
		var cs = [];
		wm.services.forEach(function(s) {
			if (s.name == "securityService" || s.name == "securityServiceJOSSO") {
				var c = new wm.Security({name: "Security"});
				cs.push(c);
			}
		});
		return cs;
	}
});

wm.registerComponentLoader("wm.Security", new wm.SecurityLoader());

}

if(!dojo._hasResource["wm.base.widget.Box"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["wm.base.widget.Box"] = true;
/*
 *  Copyright (C) 2008-2010 WaveMaker Software, Inc.
 *
 *  This file is part of the WaveMaker Client Runtime.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/* mkantor: This file is NOT obsolete, but should be.  Recommendations:
   1. wm.Box = wm.Control;
   2. Remove Box.js from manifest.js and dojo.requires
   3. Warning: Box_design.js has some code in it; looks very wavemaker 4ish.  
   */
dojo.provide("wm.base.widget.Box");


/**
	Adds box layout features to Widget.
	@name wm.Box
	@class
	@extends wm.Widget
*/
dojo.declare("wm.Box", wm.Widget, {
	/** @lends wm.Widget.prototype */
	/*
	width: "96px", 
	height: "48px",
	autoSize: false,
	setDomNode: function(inDomNode) {
		var n = inDomNode;
		if (!n) return;
		if (this.autoSize)
			this.width = this.height = "";
		// the domNode might already have box and flex ...
		this.box && (n.box = this.box);
		this.flex && (n.flex = this.flex);
		this.boxPosition && (n.boxPosition = this.boxPosition);
		this.inherited(arguments);
		dojo.addClass(this.domNode, "wmbox");
	},
	setBox: function(inBox) {
		this.domNode.box = this.box = inBox;
		this.reflowParent();
	},
	setBoxPosition: function(inPosition) {
		this.boxPosition = this.domNode.boxPosition = inPosition;
		this.reflowParent();
	}
	*/
});

}

if(!dojo._hasResource["wm.base.widget.Spacer"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["wm.base.widget.Spacer"] = true;
/*
 *  Copyright (C) 2008-2010 WaveMaker Software, Inc.
 *
 *  This file is part of the WaveMaker Client Runtime.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
dojo.provide("wm.base.widget.Spacer");


dojo.declare("wm.Spacer", wm.Control, {
	classNames: "wmspacer",
        border: 0,
    getMinWidthProp: function() {return this.minWidth || 0;},
    getMinHeightProp: function() {return this.minHeight || 0;}
});

wm.Object.extendSchema(wm.Spacer, {
        disabled: { ignore: 1 },
	scrollX:  { ignore: 1 },
	scrollY:  { ignore: 1 },
	margin:   { ignore: 1 },
	padding:  { ignore: 1 },
	border:   { ignore: 1 },
	borderColor:  { ignore: 1 }
});

// design-time
dojo.extend(wm.Spacer, {
        themeable: false,
	scrim: true
});

wm.Spacer.description = "Resizable spacer for layouts.";

}

if(!dojo._hasResource["wm.base.widget.layout.Layout"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["wm.base.widget.layout.Layout"] = true;
/*
 *  Copyright (C) 2009-2010 WaveMaker Software, Inc.
 *
 *  This file is part of the WaveMaker Client Runtime.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
dojo.provide("wm.base.widget.layout.Layout");

// bc only
wm.inLayout = function(inNode) {
	if (!inNode)
		return false;
	var s = inNode.style;
	return s &&
		s.zIndex >=0 && s.zIndex <= 1
		&& s.display != 'none'
		&& s.visibility != 'hidden'
		&& inNode.tagName != 'SCRIPT'
		&& inNode.nodeType == 1;
}

dojo.declare("wm.layout.Base", null, {
	inFlow: function(inControl) {
		return inControl.showing && (inControl.inFlow !== false) &&
			wm.inLayout(inControl.domNode); //bc only
	},
	flow: function(inContainer) {
	},
	suggest: function(inContainer, inControl, ioInfo) {
	},
	suggestSize: function(inContainer, inControl, ioInfo) {
	},
	insert: function(inTarget, inControl, inInfo) {
	}
});

dojo.mixin(wm.layout, {
	registry: {},
	cache: {},
	register: function(inName, inClass) {
		this.registry[inName] = inClass;
	},
	addCache: function(inName, inObj) {
		this.cache[inName] = inObj;
	},
	listLayouts: function() {
		var list = [];
		for (var n in this.registry) {
			list.push(n);
		}
		return list;
	}
});

}

if(!dojo._hasResource["wm.base.widget.layout.Box"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["wm.base.widget.layout.Box"] = true;
/*
 *  Copyright (C) 2009-2010 WaveMaker Software, Inc.
 *
 *  This file is part of the WaveMaker Client Runtime.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
dojo.provide("wm.base.widget.layout.Box");

dojo.declare("wm.layout.Box", wm.layout.Base, {

    /* Call flow on each container whose contents we want to layout.
     * flow figures out the proper parameters to put into the call to _flow, and then after everything is flowed, we call renderControls
     * to update css to the sizes calculated in flow.
     */
	flow: function(inContainer,reflowTest) {
		if (this.direction == 'h') 
			this._flow(inContainer, "l", "t", "w", "h", inContainer.horizontalAlign, inContainer.verticalAlign, reflowTest);
		else
			this._flow(inContainer, "t", "l", "h", "w", inContainer.verticalAlign, inContainer.horizontalAlign, reflowTest);
		if (!reflowTest)
			inContainer.renderControls();
            
            if (inContainer._autoSizeList) {
                var c;
                while(c = inContainer._autoSizeList.pop()) {
                    c.doAutoSize(1,1);
                }
            }

	},

    /* Private method for calculating the width/height of each widget within a container; then calls flow on each subcontainer.
     * Parameters:
     *    inContainer: the container to layout
     *    inFlowOrd: "l" or "t" (left or top).
     *               inContainer.bounds[inFlowOrd] will give us the start point for our calculations along the axis of flow
     *    inFitOrd:  "l" or "t" (left or top),
     *               inContainer.bounds[inFlowOrd] will give us the start point for our calculations along the axis of "fit" (opposite of axis of flow)
     *    inFlowAxis: "w" or "h" (width or height),
     *               indicates if we are flowing the widgets based on their width or height; this determines if we are trying to find values for bounds.w or bounds.h
     *               so that all of the children fit inside of the parent.
     *    inFitAxis: "w" or "h" (width or height),
     *               indicates if we are fitting the widgets based on their width or height; this determines if we are trying to find values for bounds.w or bounds.h
     *               for each widget that may stretch across the flow of the container
     *    inFlowAlign: left, center, right, top, middle, bottom
     *               If there is extra space left over, then ajust how widgets are aligned within the flow of the container.  Does not work if % sized widgets are used
     *    inFitAlign:  left, center, right, top, middle, bottom
     *               Determines how to vertically align a column of widgets or horizontally align row of widgets within a container. Works fine for % sized widgets.
     *    reflowTest: Finds sizes for each widget without recursively calling flow on subcontainers; does not update bounds of widgets, just tests to see how much 
     *                space is needed. TODO: Maybe we don't need this anymore?  Used to see if we should turn on/off autoScroll before we layout a container.
     */  
	_flow: function(inContainer, inFlowOrd, inFitOrd, inFlowAxis, inFitAxis, inFlowAlign, inFitAlign, reflowTest) {
            if (inContainer.fitToContentHeight) {
                if (inContainer.layoutKind == "top-to-bottom")
                    inFlowAlign = "top";
            }
            if (inContainer.fitToContentWidth) {
                if (inContainer.layoutKind == "left-to-right")
                    inFlowAlign = "left";
            }

            /* Step 1: If any of the widgets inside of this container are autosizing, then now is the time for them to figure out their sizes, 
             *         before we lay out them and their siblings.  NOTE: if they size themselves based on the bounds of their siblings,
             *         they may not get accurate information at this point; autoSizing should be done with disregard for siblings! 
             *         Note also that a widget that autosizes based on the size of the parent may find the paren't available size changing
             *         if the parent adds/removes scrollbars from its content area.  But we autoSize widgets before adding scrollbars so that
             *         a widget may resize itself BEYOND the size of the parent and force it to add scrollbars.
             */
	    this.handleAutoSizingWidgets(inContainer);

            /* Step 2: If the container is autoScrolling, figure out if scrollbars will be needed, and update them if needed.  We need to know if scrollbars
             *         are on or not as they affect our bounds.
             */
            if (inContainer.autoScroll) {
                this.handleAutoScrollBars(inContainer);               
            }

            /* Step 3: Get the container's bounds; must be done after autoScroll modifies the bounds */
	    var b = inContainer.getContentBounds();

            /* Step 4: flowEx gives us two points of information:
             *         flowEx.free:  Find out how much free space is available for for % sized widgets.  If the number is negative, 
             *                       then hopefully scrollbars are enabled or widgets will not all be visible.  
             *         flowEx.ratio: This ratio can be multiplied against each c._percEx to get the desired width or height.  It accounts for two things:
             *                       1. how much free space is available in the container, 2. If the sum of the container widget's % sizes is over 100%, 
             *                       this is a modifier on each widget's % to normalize the total back to 100%.
             */
	    var flowEx = this.calcFlexRatio(inContainer.c$, inFlowAxis, b[inFlowAxis]);

            
            /* Step 5: Typically, we start laying out widgets at inContainer.bounds[inFlowOrd].  But if alignment is used, we may start somewhere else.  
             *         Find our starting point.
             *         NOTE: contentAlign only makes sense if there are no % children. 
             *         TODO: Invalid assumption; a 50% widget can still be aligned as its not taking up the full 100% of the container.  
             *               Back in wm 4.x when flex size was used, containers were always filled.
             */
	    if (flowEx.free) {
                var free = flowEx.free;
	        for (var i=0, c; c=inContainer.c$[i]; i++) {
		    if (this.inFlow(c)) {                
                        free -= c._percEx[inFlowAxis] ? (flowEx.ratio * c._percEx[inFlowAxis]) : 0;
                    }
                }
		switch (inFlowAlign) {
		case "bottom":
		case "right":
		    b[inFlowOrd] += free;
		    break;
		case "middle":
		case "center":
		    b[inFlowOrd] += free / 2;
		    if (b[inFlowOrd] < 0) b[inFlowOrd] = 0;
		    break;
		}
	    }
	    var fitOrd = b[inFitOrd];
	    var fitBound = b[inFitAxis];

            /* Step 6: We need the maximum size against the flow if we are doing a fitToContent against the flow; this will be the new width/height of inContainer,
             *         and will be used for all % calculations of width or height of the container's widgets.
             *         TODO: if autoScroll is on, then we've already called getPreferredFitToContentHeight AND Width; we should cache the results of the prior call
             * /
	    if (inContainer.fitToContentHeight  && inContainer.layoutKind == "left-to-right" ||
		inContainer.fitToContentWidth && inContainer.layoutKind == "top-to-bottom") 
            {
		fitBound = (inContainer.layoutKind == "left-to-right") ? inContainer.getPreferredFitToContentHeight() : inContainer.getPreferredFitToContentWidth();
                b[inFitAxis] = fitBound;
            }
            */
            /* Step 7: Iterate over each widget in this container, calculate its size and call setBounds on it. */
	    for (var i=0, c; c=inContainer.c$[i]; i++) {
		if (this.inFlow(c)) {

                    /* Step 7a: Calculate the bounds in flow of axis.
                     * If its % sized: bounds.w or bounds.h is now the %size * our ratio multiplier that builds in amount of free space and normalizes % to total of 100%
                     *                 for all children.  
                     * If px sized: We aren't calculating this bounds axis, its a fixed size, so just set it to NaN
                     */
		    b[inFlowAxis] = c._percEx[inFlowAxis] ? Math.round((flowEx.ratio * c._percEx[inFlowAxis])) : NaN;		

                    /* Step 7b: Calculate the bounds against the flow, and update the bounds and set cFitSize
                     * If its % sized: then set bounds and cFitSize to a size calculated from the parent's size * this widget's % size
                     * If its px sized: cFitSize is the control's bounds size, and then delete the bounds value; its fixed size so we won't be setting it.  
                     */
		    var cFitSize;
		    if (c._percEx[inFitAxis]) {
			    cFitSize = b[inFitAxis] = Math.min(100, c._percEx[inFitAxis]) * fitBound * 0.01;
		    } else {
                        cFitSize = c.bounds[inFitAxis];
			delete b[inFitAxis];
                    }

                    /* Step 7c: Find the left edge or top edge of the widget.  Typically goes at 0px (or if there's padding/border/margin, 
                     *          at inContainer.getContentBounds()[inFitOrd]).  But if alignement against the flow is specified, then we'll need to modify that
                     *          start value.  End result is that b["l" or "t"] has been updated.
                     */
		    b[inFitOrd] = fitOrd;  // bounds["l" or "t"] = the "l" or "t" inContainer.
		    switch (inFitAlign) {
		    case "justified": // no longer supported
            		if (djConfig.isDebug && !wm.isInstanceType(inContainer, wm.Editor) && inContainer.isDesignedComponent() && inFitAxis == "w" && !wm.isInstanceType(inContainer, wm.Layers) && !wm.isInstanceType(inContainer.owner, wm.Layers))
                	dojo.deprecated("justified", inContainer.owner.toString() + ":" + inContainer.toString() + "'s " + ((inFitAxis == "w") ? "horizontalAlign" : "verticalAlign") + " is set to 'justified', which may yield unexpected behaviors; please change this alignment in the property editor");
			b[inFitAxis] = fitBound;
			break;
		    case "center":
		    case "middle":
			b[inFitOrd] = (fitOrd + fitBound - cFitSize) / 2; 
			if (b[inFitOrd] < 0) b[inFitOrd] = 0;
			break;
		    case "bottom":
		    case "right":
			b[inFitOrd] = fitOrd + fitBound - cFitSize;  
			break;
		    }

                    /* Step 7d: Verify that sizes have not been reduced below user-set or widget-preferred minimums
                     * TODO: This may be the third time in this _flow that we've called getMinHeight/WidthProp; 
                     * definitely need to cache the result for the duration of this call
                     */
		    if (c._percEx.h) {
			var minHeight = c.getMinHeightProp();
			if (minHeight > b.h) b.h = minHeight;
		    }
		    if (c._percEx.w) {
			var minWidth  = c.getMinWidthProp();
			if (minWidth > b.w) b.w = minWidth;			    
		    }

                    /* Step 7e:  Update the bounds for the control; any bounds that were deleted or set to NaN will be left as is */
 		    c.setBounds(b.l, b.t, b.w, b.h);
                    c._renderEngineBoundsSet = true;

                    /* Step 7f: If the widget has a flow method (typically means its a wm.Container), call flow on it */
		    if (c.flow) {
			    c.flow();
		    }

                    /* Step 7g: The next widget's left or top will start after the edge of the widget just placed; so add the width to b["t" or "l"].
                       TODO: Couldn't we just set this to c.bounds["r" or "b"]?
                       */
		    b[inFlowOrd] += Math.max(0, c.bounds[inFlowAxis]);
		    wm.flowees++;
		}
            }

		/* Start of Frankie's new code
		if (inContainer.autoScroll && reflowTest) {
		    if (flowEx.free < 0) {
			if (inContainer.parent) {
			    inContainer.parent._xneedReflow = true;
			}
			inContainer._xneedReflow = true;
			inContainer[(inFlowAxis == "h" ? "_xscrollY" : "_xscrollX")] = true;
			inContainer.domNode.style["overflow" + ((inFlowAxis == "h") ? "Y" : "X")] = "auto";
		    } else {
			if (inContainer.domNode.style["overflow" + ((inFlowAxis == "h") ? "Y" : "X")] == "auto") {
			    inContainer.domNode.style["overflow" + ((inFlowAxis == "h") ? "Y" : "X")] = "hidden";
			    inContainer.domNode[(inFlowAxis == "h") ? "scrollTop" : "scrollLeft"] = 0;
			}
			inContainer[(inFlowAxis == "h" ? "_xscrollY" : "_xscrollX")] = false;
		    }
		    if (cFitSizeMax > fitBound) {
			if (inContainer.parent) {
			    inContainer.parent._xneedReflow = true;
			}
			inContainer._xneedReflow = true;
			inContainer[(inFitAxis == "h" ? "_xscrollY" : "_xscrollX")] = true;
			inContainer.domNode.style["overflow" + ((inFitAxis == "h") ? "Y" : "X")] = "auto";
		    } else {
			if (inContainer.domNode.style["overflow" + ((inFitAxis == "h") ? "Y" : "X")] == "auto") {
			    inContainer.domNode.style["overflow" + ((inFitAxis == "h") ? "Y" : "X")] = "hidden";
			    inContainer.domNode[(inFitAxis == "h") ? "scrollTop" : "scrollLeft"] = 0;
			}
			inContainer[(inFitAxis == "h" ? "_xscrollY" : "_xscrollX")] = false;
		    }
		}
		 End of Frankie's new code */


                /* Step 8: if we have a fitToContent container, resize it to fit its children's width and height.
                *          Never resize a container to less than 30px high and 50px wide as a fitToContent container could disappear entirely when removing its last
                *          control, and be imposible to select or even see.
                * /
                if (inContainer.fitToContent) {
		    var bx = {};
		    if (/ *flowEx.ratio == 0 && * /(inContainer.fitToContentWidth && inFlowAxis == "w" || inContainer.fitToContentHeight && inFlowAxis == "h")) 
                        
			bx[inFlowAxis] = Math.max(b[inFlowOrd],(inFlowAxis == "h") ? 30 : 50); // Containers with fitToContent set should never be resized below 30px high and 50px wide		    
		    if (inContainer.fitToContentWidth && inFlowAxis == "h" || inContainer.fitToContentHeight && inFlowAxis == "w") 
		        bx[inFitAxis] = Math.max(fitBound, (inFlowAxis == "h") ? 30 : 50);
		    inContainer.setContentBounds(bx);
                    inContainer.calcFitToContent();
                    inContainer.renderBounds();
		}
                */

	},
    
    handleAutoSizingWidgets: function(inContainer) {
	if (!inContainer.isAncestorHiddenLayer() && inContainer.showing && (!wm.isInstanceType(inContainer, wm.Layer) || inContainer.active)) {
            var hasAutoHeight;
            var hasAutoWidth;
	    for (var i = 0; i < inContainer.c$.length; i++) {			
		var c = inContainer.c$[i];
		if (c.showing) {

                    if (c._needsAutoSize && (c.autoSizeWidth || c.autoSizeHeight)) {
                        var topParent = (c.owner instanceof wm.Page) ? c.owner.root : c.owner;
                        if (!topParent._autoSizeList)
                            topParent._autoSizeList = [];
                        topParent._autoSizeList.push(c);
/*
		        var cupdatingwas = c._cupdating;
		        c._cupdating = true;				
                        c.doAutoSize(false,false);
		        c._cupdating = cupdatingwas;
                        if (c.autoSizeWidth) hasAutoWidth = true;
                        if (c.autoSizeHeight) hasAutoHeight = true;
                        */
                    } else  if (c.fitToContent) {
                        if (c.fitToContentHeight) 
                            c.bounds.h = c.getPreferredFitToContentHeight();
                        if (c.fitToContentWidth)
                            c.bounds.w = c.getPreferredFitToContentWidth();
                        c.calcFitToContent();
                        if (c.fitToContentWidth) hasAutoWidth = true;
                        if (c.fitToContentHeight) hasAutoHeight = true;
                    }
		}
	    }
	}
    },

    /* Note: we must turn overflow between auto/hidden instead of leaving it on auto because chrome browser, once the scrollbars appear,
     * won't ever go away even if scrolling is no longer needed */
    handleAutoScrollBars: function(inContainer) {
        /* Vertical scrollbars */
        if (inContainer.fitToContentHeight) {
            inContainer._xscrollY = false;
            scrollY = "hidden";
        } else {
            var needsScrollY = inContainer.getPreferredFitToContentHeight() > inContainer.bounds.h;
            var scrollY = (needsScrollY) ? "auto" : "hidden";
            inContainer._xscrollY = (scrollY=="auto");
        }
	if (inContainer.domNode.style.overflowY != scrollY) {
	    inContainer.domNode.style.overflowY = scrollY;
            inContainer.domNode.scrollTop = 0;
        }


        /* Horizontal scrollbars */
        if (inContainer.fitToContentWidth) {
            inContainer._xscrollX = false;
            scrollX = "hidden";
        } else {
            var needsScrollX = inContainer.getPreferredFitToContentWidth() > inContainer.bounds.w;
            var scrollX = (needsScrollX) ? "auto" : "hidden";
        }
        inContainer._xscrollX = (scrollX=="auto");
	if (inContainer.domNode.style.overflowX != scrollX) {
	    inContainer.domNode.style.overflowX = scrollX;
            inContainer.domNode.scrollLeft = 0;
        }
    },
	calcFlexRatio: function(inC$, inAxis, inExtent) {
		var flex = 0;
		var free = inExtent;
		var minSizeSum = 0;
	        var minname = "getMin" + ((inAxis == "h") ? "Height" : "Width") + "Prop";
		for (var i=0, c; c=inC$[i]; i++) {
			if (this.inFlow(c)) {
				if (c._percEx[inAxis]) {
					flex += Number(c._percEx[inAxis]) || 0;
				        minSizeSum += c[minname]();
				} else
					free -= c.bounds[inAxis];
			}
		}

		// If this number is less than 0, then treat all minSized widgets as fixed size and factor in the minSize into the amount of free space
		if (free - minSizeSum < 0) free -= minSizeSum; 
		if (flex && flex < 100)
			flex = 100;
		return {
			free: free,
			ratio: (flex && free>0) ? (free / flex) : 0
		};
	},
        // TODO: This, and perhaps calcFlexRatio should probably use not just minHeight/minWidth, but getMinWidthProp/getMinHeightProp
        getMaxFreeSpace: function(inC$, inAxis, inExtent) {
                var free = inExtent;
                var minSizeSum = 0;
                var minname = "min" + ((inAxis == "h") ? "Height" : "Width");
                for (var i=0, c; c=inC$[i]; i++) {
                        if (this.inFlow(c)) {
                                if (c._percEx[inAxis]) {
                                        if (c[minname]) minSizeSum += c[minname];
                                } else
                                        free -= c.bounds[inAxis];
                        }
                }

                // If this number is less than 0, then treat all minSized widgets as fixed size and factor in the minSize into the amount of free space
                if (free - minSizeSum < 0) free -= minSizeSum;
                return free;
        }

});

dojo.declare("wm.layout.HBox", wm.layout.Box, {
	direction: "h",
	suggest: function(inContainer, inControl, ioRect) {
		var x = 0;
		for (var i=0, c; c=inContainer.c$[i]; i++) {
			if (this.inFlow(c)) {
				if (ioRect.l < c.bounds.l + c.bounds.w / 2) {
					x = c.bounds.l - 1;
					break;
				}
				x = c.bounds.r;
			}
		}
		var b = inContainer.getContentBounds();
		ioRect.l = x;
		ioRect.t = b.t;
		ioRect.h = b.h;
		ioRect.i = i;
	}
});

dojo.declare("wm.layout.VBox", wm.layout.Box, {
	direction: "v",
	suggest: function(inContainer, inControl, ioRect) {
		var y = 0;
		for (var i=0, c; c=inContainer.c$[i]; i++) {
			if (this.inFlow(c)) {
				if (ioRect.t < c.bounds.t + c.bounds.h / 2) {
					y = c.bounds.t - 1;
					break;
				}
				y = c.bounds.b;
			}
		}
		var b = inContainer.getContentBounds();
		ioRect.l = b.l;
		ioRect.t = y;
		ioRect.w = b.w;
		ioRect.i = i;
	}
});

wm.layout.register("left-to-right", wm.layout.HBox);
wm.layout.register("top-to-bottom", wm.layout.VBox);
wm.layout.addCache("left-to-right", new wm.layout.HBox());
wm.layout.addCache("top-to-bottom", new wm.layout.VBox());

}

if(!dojo._hasResource["wm.base.widget.Panel"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["wm.base.widget.Panel"] = true;
/*
 *  Copyright (C) 2008-2010 WaveMaker Software, Inc.
 *
 *  This file is part of the WaveMaker Client Runtime.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
dojo.provide("wm.base.widget.Panel");

/**
	Container for widgets.
	@name wm.Panel
	@class
	@extends wm.Container
*/
dojo.declare("wm.Panel", wm.Container, {
	/** @lends wm.Panel.prototype */
	//border: 1,
    classNames: "wmcontainer wmpanel",    
    setThemeStyleType: function(inType) {        
        var widgetsjs = this.write("");
	widgetsjs = dojo.fromJson(widgetsjs.replace(/^.*?\:/,""));
	var name = this.name;	
        var parent = this.parent;
	var owner = this.owner;
        var indexInParent = dojo.indexOf(this.parent.c$, this);
        this.destroy();
	
        var clone = parent.createComponent(name, "wm." + inType + "Panel", widgetsjs[1], widgetsjs[2], widgetsjs[3], owner);
        parent.moveControl(clone, indexInParent);
        parent.reflow();
	studio.refreshWidgetsTree();
	studio.select(clone);
    },
    getThemeStyleType: function() {
        return this.declaredClass.replace(/^wm\.(.*)Panel/,"$1");
    }

});


dojo.declare("wm.MainContentPanel", wm.Panel, {
    classNames: "wmcontainer wmpanel MainContent"
});

dojo.declare("wm.EmphasizedContentPanel", wm.Panel, {
    classNames: "wmcontainer wmpanel EmphasizedContent"
});

dojo.declare("wm.HeaderContentPanel", wm.Panel, {
    classNames: "wmcontainer wmpanel HeaderContent"
});
wm.Object.extendSchema(wm.Panel, {
    themeStyleType: {group: "style", order: 150},
});
dojo.declare("wm.FancyPanel", wm.Panel, {
    //useDesignBorder: 0, // move this to a _design file if we ever create one
    freeze: true,
    classNames: "wmcontainer wmfancypanel",
    //_classes: 	{"domNode": ["wm_FontSizePx_16px", "wm_BackgroundGradient_Blue", "wm_Border_TopStyleCurved12px", "wm_Border_BottomStyleCurved4px", "wm_FontColor_White", "wm_TextDecoration_Bold", "wm_Border_DropShadow"]},
    title: "Panel Heading",
    labelWidget: null,
    containerWidget: null,
    layoutKind: "top-to-bottom",
    innerLayoutKind: "top-to-bottom",
    innerHorizontalAlign: "left",
    innerVerticalAlign: "top",
    margin: "6",
    padding: "0",    
    border: "0",
    innerBorder: "3",
    borderColor: "#404040",
    width: "100%",
    height: "100%",
    _topImgWidth: 0,
    _bottomImgWidth: 0,
    labelHeight: 30,
    themeStyleType: "ContentPanel",
    init: function() {
	var classes = this._classes;
	var containerClasses = {domNode:[]};
	for (var i = classes.domNode.length-1; i >= 0; i--) {
	    if (classes.domNode[i].match(/^wm_Border_(Bottom|Drop)/)) {
		containerClasses.domNode.push(classes.domNode[i]);
		wm.Array.removeElementAt(classes.domNode,i);
	    }
	}
	this._classes = {domNode:[]};
        try {
	    //var classes = this.captionClasses.split(/\s+/);
	    this.layout = wm.layout.cache["top-to-bottom"];
	    this.inherited(arguments);
	    this.labelWidget = new wm.Label({border: this.innerBorder,
                                             borderColor: this.borderColor,
                                             showing: Boolean(this.title),
		                             _classes: classes,
                                             name: "labelWidget",
                                             caption: this.title,
                                             width: "100%",
                                             height: this.labelHeight + "px",
                                             padding: "0,0,0,10",
                                             owner: this,
                                             parent: this,
                                             noInspector: true});
	    var innerBorder = String(this.innerBorder);
            innerBorder = this._parseExtents(innerBorder);
	    this.containerWidget = new wm.Container({
		                                     _classes: containerClasses,
                                                     name:           "containerWidget",
                                                     layoutKind:     this.innerLayoutKind,
                                                     width:          "100%",
                                                     height:         "100%",
                                                     owner:          this,
                                                     parent:         this,
                                                     noInspector:    true,
                                                     autoScroll:     true,
                                                     horizontalAlign:this.innerHorizontalAlign,
                                                     verticalAlign:  this.innerVerticalAlign,
                                                     fitToContentHeight: this.fitToContentHeight,
                                                     fitToContentWidth: this.fitToContentWidth,
                                                     /* margin: "0,0,7,0",*/
                                                     border:         "0,"+innerBorder.r+","+innerBorder.b+","+innerBorder.l,
                                                     borderColor: this.borderColor});

	    this.containerWidget.setLayoutKind(this.innerLayoutKind);
	    this.widgets.labelWidget = this.labelWidget;
	    this.widgets.containerWidget = this.containerWidget;
            this.setTitle(this.title);
/*
	    wm.onidle(this, function() {
                try {
		    this._readyForInitClasses = true;
		    if (dojo.isIE < 9) {
                        var namelist = ["topRightCornerImg","topLeftCornerImg","bottomRightCornerImg","bottomLeftCornerImg"];
                        for (var i = 0; i < namelist.length; i++) {
                            var name = namelist[i];
                            var div = document.createElement("div");
                            div.id = this.getRuntimeId() + "_" + name;
                            div.className = "FancyPanel" + name;
		            this.parent.domNode.appendChild(div);
                            this["_" + name] = div;
                        }
		        this.initUserClasses();
		        this.renderCorners();
                        console.log("initUserClasses: " + this.toString() + " has label: " + Boolean(this.labelWidget));
                    }
		    this.initUserClasses();
                    this.setShowing(this.showing, true);
                } catch(e) {
                    alert("onIdle Panel:" + e);
		}

	    });
            */
        } catch(e) {
            alert("PANEL:" + e);
        }
    },
    setFitToContentHeight: function(inValue) {
        this.inherited(arguments);
        if (this.containerWidget)
            this.containerWidget.setFitToContentHeight(inValue);
    },
    setFitToContentWidth: function(inValue) {
        this.inherited(arguments);
        if (this.containerWidget)
            this.containerWidget.setFitToContentWidth(inValue);
    },
    setBorder: function(inBorder) {
        wm.Control.prototype.setBorder.call(this, "0");
    },

    setShowing: function(inShowing) {
	this.inherited(arguments);
	if(dojo.isIE < 9) {
            if (this._topLeftCornerImg) {
	        this._topLeftCornerImg.style.display = (this.showing) ? "block" : "none";
	        this._topRightCornerImg.style.display = (this.showing) ? "block" : "none";
            }
            if (this._bottomLeftCornerImg) {
	        this._bottomLeftCornerImg.style.display = (this.showing) ? "block" : "none";
	        this._bottomRightCornerImg.style.display = (this.showing) ? "block" : "none";
            }
	}
    },
	getMinHeightProp: function() {
            if (this.minHeight) return this.minHeight;
            if (!this.containerWidget) return this.inherited(arguments);
            return this.containerWidget.getMinHeightProp() + ((this.labelWidget && this.labelWidget.showing) ? this.labelWidget.bounds.h : 0) + 30;
	},
	getPreferredFitToContentWidth: function() {
		// get the maximum width in this column; 
		// and get the sum of widths in this row... we'll worry later about whether its a row or column
                var extra = this.padBorderMargin.r + this.padBorderMargin.l;	
	        var max = 0;
	        var sum = 0;
		var v;
		for (var i=0, c; c=this.c$[i]; i++) {
			if (this.layout.inFlow(c)) {
			    if (c instanceof wm.Container) {
				if (c.fitToContentWidth || c._percEx.w) {
					v =  c.getPreferredFitToContentWidth();
				} else {
					v =  c.bounds.w;
				}
			    } else {
				if (c._percEx.w) {
				        v =  c.getMinWidthProp();
				} else {
					v =  c.bounds.w;
				}				
			    }
				max = Math.max(max, v);
				sum += v;				
			}
		}

                // Never return less than 30px wide; mostly this is for design mode where users still need to be able to find and drop widgets into the container.
	        var result = ((this.layoutKind == "top-to-bottom") ? max : sum) + extra;
                return Math.max(result, 30);
	},

    /* Get the preferred height of this container, for use if this is a fitToContentHeight container.
     * top-to-bottom container: height is the sum of the heights of all px sized children and the sum of all minHeights for % sized children.
     * left-to-right container: height is the max of the heights of all px sized children and the minHeights for % sized children
     */
	getPreferredFitToContentHeight: function() {
		// get the maximum width in this column; 
		// and get the sum of height in this row... we'll worry later about whether its a row or column
            var extra = this.padBorderMargin.t + this.padBorderMargin.b;	
	    var max = 0;
	    var sum = 0;
		var v;
		for (var i=0, c; c=this.c$[i]; i++) {
			if (this.layout.inFlow(c)) {
			    if (c instanceof wm.Container) {
				 if (c.fitToContentHeight || c._percEx.h) {
					v = c.getPreferredFitToContentHeight();
				 } else {
					v = c.bounds.h;
				}
			    } else {
				 if (c.fitToContentHeight || c._percEx.h) {
					v = c.getMinHeightProp();
				 } else {
					v = c.bounds.h;
				}
			    }
			    max = Math.max(max, v);
			    sum += v;
			}
		}
            // never return less than 15px height
            var result =  ((this.layoutKind == "left-to-right") ? max : sum) + extra;
	    return Math.max(result, 15);
	},

    destroy: function() {
	if(dojo.isIE < 9) {
            if (this._topLeftCornerImg) {
	        dojo.destroy(this._topLeftCornerImg);
	        dojo.destroy(this._topRightCornerImg);
            }
            if (this._bottomLeftCornerImg) {
	        dojo.destroy(this._bottomLeftCornerImg);
	        dojo.destroy(this._bottomRightCornerImg);
            }
	}
	this.inherited(arguments);
    },
    flow: function() {
	this.inherited(arguments);
	if (dojo.isIE < 9)
	    this.renderCorners();
    },
    renderCorners: function() {
	if (!this._topLeftCornerImg) return;
	if (this._topLeftCornerImg.className.match(/px/)) {
	    this._topLeftCornerImg.style.top =  this._topRightCornerImg.style.top = 
		(this.bounds.t + this.marginExtents.t) + "px";

	    this._topLeftCornerImg.style.left = (this.bounds.l + this.marginExtents.l) + "px";
	    this._topRightCornerImg.style.left = (this.bounds.r-this._topImgWidth-this.marginExtents.r) + "px";
	}

	if (this._bottomLeftCornerImg.className.match(/px/)) {
	    this._bottomLeftCornerImg.style.top =  this._bottomRightCornerImg.style.top = 
		(this.bounds.b - this.marginExtents.b - this._bottomImgHeight) + "px";

	    this._bottomLeftCornerImg.style.left = (this.bounds.l + this.marginExtents.l) + "px";
	    this._bottomRightCornerImg.style.left = (this.bounds.r-this._bottomImgWidth-this.marginExtents.r) + "px";
	}

	
    },
    postInit: function() {
	var changeParents = [];
	for (var i = 0; i < this.c$.length; i++) {
	    var c = this.c$[i];
	    if (this.$[c.name] != c && c instanceof wm.Control) {
		changeParents.push(c);
	    }
	}
	for (var i = 0; i < changeParents.length; i++) {
	    var c = changeParents[i];
	    c.setParent(this.containerWidget);
	    if (c.designWrapper)
		c.designWrapper.controlParentChanged();
	}
	this.inherited(arguments);
    },
    writeComponents: function(inIndent, inOptions) {
	var result = [];
	if (this.containerWidget)
	    result = result.concat(this.containerWidget.writeComponents(inIndent, inOptions));
	if (this.components.binding)
	    result = result.concat(this.components.binding.write(inIndent, inOptions));
	return result;
    },
    setInnerHorizontalAlign: function(inAlign) {
	this.innerHorizontalAlign = inAlign
	if (this.containerWidget)
	    this.containerWidget.setHorizontalAlign(inAlign);
    },    
    setInnerVerticalAlign: function(inAlign) {
	this.innerVerticalAlign = inAlign
	if (this.containerWidget)
	    this.containerWidget.setVerticalAlign(inAlign);
    },    
    setInnerLayoutKind: function(inKind) {
	this.innerLayoutKind = inKind;
	if (this.containerWidget)
	    this.containerWidget.setLayoutKind(inKind);
    },    
    setInnerBorder: function(inBorder) {
	inBorder = String(inBorder);
        this.innerBorder = inBorder;
        this.labelWidget.setBorder(inBorder);
        var b = this._parseExtents(inBorder);
        this.containerWidget.setBorder("0," + b.r + "," + b.b + "," + b.l);
    },
    setLayoutKind: function(inKind) {
	wm.Panel.prototype.setLayoutKind.call(this,"top-to-bottom");
	if (this.containerWidget) {
	    this.setInnerLayoutKind(inKind);
	}
	
	// noop
	/*
	this.innerLayoutKind = inKind;
	if (this.containerWidget)
	    this.containerWidget.setLayoutKind(inKind);
	    */
    },    

/*
	addUserClass: function(inClass, inNodeName) {
            if (!this._readyForInitClasses) return this.inherited(arguments);

		this.inherited(arguments);
		if (dojo.isIE < 9)
		    switch(inClass) {
		    case "wm_Border_TopStyleCurved12px":
			dojo.addClass(this._topRightCornerImg, "topright_wm_Border_TopStyleCurved12px");
			dojo.addClass(this._topLeftCornerImg, "topleft_wm_Border_TopStyleCurved12px");
			this._topImgWidth = 11;
			break;
		    case "wm_Border_TopStyleCurved8px":
			dojo.addClass(this._topRightCornerImg, "topright_wm_Border_TopStyleCurved8px");
			dojo.addClass(this._topLeftCornerImg, "topleft_wm_Border_TopStyleCurved8px");
			this._topImgWidth = 7;
			break;
		    case "wm_Border_TopStyleCurved4px":
			dojo.addClass(this._topRightCornerImg, "topright_wm_Border_TopStyleCurved4px");
			dojo.addClass(this._topLeftCornerImg, "topleft_wm_Border_TopStyleCurved4px");
			this._topImgWidth = 3;
			break;
		    case "wm_Border_BottomStyleCurved12px":
			dojo.addClass(this._bottomRightCornerImg, "bottomright_wm_Border_BottomStyleCurved12px");
			dojo.addClass(this._bottomLeftCornerImg, "bottomleft_wm_Border_BottomStyleCurved12px");
			this._bottomImgWidth = 11;
			this._bottomImgHeight = 10;
			break;
		    case "wm_Border_BottomStyleCurved8px":
			dojo.addClass(this._bottomRightCornerImg, "bottomright_wm_Border_BottomStyleCurved8px");
			dojo.addClass(this._bottomLeftCornerImg, "bottomleft_wm_Border_BottomStyleCurved8px");
			this._bottomImgWidth = 7;
			this._bottomImgHeight = 7;
			break;
		    case "wm_Border_BottomStyleCurved4px":
			dojo.addClass(this._bottomRightCornerImg, "bottomright_wm_Border_BottomStyleCurved4px");
			dojo.addClass(this._bottomLeftCornerImg, "bottomleft_wm_Border_BottomStyleCurved4px");
			this._bottomImgWidth = 3;
			this._bottomImgHeight = 3;
			break;
		    }
 		if (inClass.match(/_bottom/i)) {
		    this.containerWidget.addUserClass("wm_Border_BottomStyleCurved4px", inNodeName);
		}

            
	},
    	removeUserClass: function(inClass, inNodeName) {
            if (!this._readyForInitClasses) return this.inherited(arguments);

		this.inherited(arguments);
		if (dojo.isIE < 9) 
		    switch(inClass) {
		    case "wm_Border_TopStyleCurved12px":
			dojo.removeClass(this._topRightCornerImg, "topright_wm_Border_TopStyleCurved12px");
			dojo.removeClass(this._topLeftCornerImg, "topleft_wm_Border_TopStyleCurved12px");
			break;
		    case "wm_Border_TopStyleCurved8px":
			dojo.removeClass(this._topRightCornerImg, "topright_wm_Border_TopStyleCurved8px");
			dojo.removeClass(this._topLeftCornerImg, "topleft_wm_Border_TopStyleCurved8px");
			break;
		    case "wm_Border_TopStyleCurved4px":
			dojo.removeClass(this._topRightCornerImg, "topright_wm_Border_TopStyleCurved4px");
			dojo.removeClass(this._topLeftCornerImg, "topleft_wm_Border_TopStyleCurved4px");
			break;
		    case "wm_Border_BottomStyleCurved12px":
			dojo.removeClass(this._bottomRightCornerImg, "bottomright_wm_Border_BottomStyleCurved12px");
			dojo.removeClass(this._bottomLeftCornerImg, "bottomleft_wm_Border_BottomStyleCurved12px");
			break;
		    case "wm_Border_BottomStyleCurved8px":
			dojo.removeClass(this._bottomRightCornerImg, "bottomright_wm_Border_BottomStyleCurved8px");
			dojo.removeClass(this._bottomLeftCornerImg, "bottomleft_wm_Border_BottomStyleCurved8px");
			break;
		    case "wm_Border_BottomStyleCurved4px":
			dojo.removeClass(this._bottomRightCornerImg, "bottomright_wM_Border_BottomStyleCurved4px");
			dojo.removeClass(this._bottomLeftCornerImg, "bottomleft_wm_Border_BottomStyleCurved4px");
			break;
		    }
 		if (inClass.match(/_bottom/i)) {
		    if (dojo.indexOf(this._classes.domNode, "wm_Border_BottomStyleCurved12px") != -1 ||
			dojo.indexOf(this._classes.domNode, "wm_Border_BottomStyleCurved8px") != -1 ||
			dojo.indexOf(this._classes.domNode, "wm_Border_BottomStyleCurved4px") != -1)
			this.containerWidget.removeUserClass("wm_Border_BottomStyleCurved4px", inNodeName);
		}
	},
	initUserNodeClasses: function(inClasses, inNodeName) {
	    if (!this._readyForInitClasses) return;
	    this._classes.domNode = [];
	    var k = dojo.clone(inClasses) || [], n = this[inNodeName];	    
	    if (n) {
		for (var i = 0; i < k.length; i++) {
		    this.addUserClass(k[i]);
		}
	    }
	},
        */
    setTitle: function(inTitle) {
	var oldTitle = this.title;
	this.title = inTitle;
	if (this.containerWidget) {
	    this.labelWidget.setCaption(inTitle);
	    this.labelWidget.setShowing(Boolean(inTitle));
            //this.containerWidget.setOneMargin((inTitle) ? 0 : 7, "t"); // make room for the curved corners if there's no title showing
	}
    },

        setThemeStyleType: function(inMajor) {
	    this.containerWidget.setThemeStyleType(inMajor);
	    this.themeStyleType = inMajor;
	},
    setLabelHeight: function(inHeight) {
        this.labelHeight = inHeight;
        this.labelWidget.setHeight(inHeight);
    }
});

wm.Panel.extend({
    themeable: false,
    // backward-compatibility fixups
	afterPaletteDrop: function() {
		this.inherited(arguments);
	    if (this instanceof wm.FancyPanel) return;
	    var v = "top-to-bottom", h = "left-to-right", pv = (this.parent.layoutKind == v);
	    this.setLayoutKind(pv ? h : v);
		if (pv)
			this.setWidth("100%");
		else
			this.setHeight("100%");                 
	//        this.setIsRounded(true);
	}

});

 
wm.FancyPanel.extend({
    themeable: true,
    themeableProps: ["innerBorder","borderColor","labelHeight"],
	makePropEdit: function(inName, inValue, inDefault) {
		switch (inName) {
			case "innerLayoutKind":
				return new wm.propEdit.Select({component: this, value: inValue, name: inName, options: wm.layout.listLayouts()});
			case "innerHorizontalAlign":
				return new wm.propEdit.Select({component: this, value: inValue, name: inName, options: ["left", "center", "right"/*, "justified"*/]});
			case "innerVerticalAlign":
				return new wm.propEdit.Select({component: this, value: inValue, name: inName, options: ["top", "middle", "bottom"/*, "justified"*/]});
		}
		return this.inherited(arguments);
	}
});

wm.Object.extendSchema(wm.FancyPanel, {
    title: { type: "String", bindable: 1, group: "display", order: 100, focus: true },
    labelWidget: {ignore: 1},
    themeStyleType:  {ignore: 1},
    containerWidget: {ignore: 1},
    layoutKind: {ignore: 1},
    innerLayoutKind: {group: "layout", order: 100, shortname: "layoutKind"},
    innerHorizontalAlign: {group: "layout", order: 101, shortname: "horizontalAlign"},
    innerVerticalAlign: {group: "layout", order: 101, shortname: "verticalAlign"},
    padding: {ignore: 1},
    labelHeight: {group: "layout", order: 90},
    border: {ignore: 1},
    innerBorder: {group: "style", shortname: "border"}
});


wm.Panel.description = "A container for widgets.";

}

if(!dojo._hasResource["wm.base.widget.Template"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["wm.base.widget.Template"] = true;
/*
 *  Copyright (C) 2008-2010 WaveMaker Software, Inc.
 *
 *  This file is part of the WaveMaker Client Runtime.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
dojo.provide("wm.base.widget.Template");


dojo.declare("wm.Template", wm.Container, {
	layoutKind: "top-to-bottom",
	init: function() {
		this.readTemplate();
		this.inherited(arguments);
	},
	readTemplate: function() {
		if (this._template) {
			if (dojo.isObject(this._template))
				this._template = dojo.toJson(this._template);
			this.readComponents(this._template);
		}
	},
        adjustChildProps: function(inCtor, inProps) {
	    if (wm.isClassInstanceType(inCtor, wm.Control))
                this.inherited(arguments);
            else
		dojo.mixin(inProps, {owner: this.owner});                
        }
});
wm.Template.extend({
    themeable: false
});
wm.Template.description = "A set of built from a template.";

}

if(!dojo._hasResource["wm.base.widget.Layout"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["wm.base.widget.Layout"] = true;
/*
 *  Copyright (C) 2008-2010 WaveMaker Software, Inc.
 *
 *  This file is part of the WaveMaker Client Runtime.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
dojo.provide("wm.base.widget.Layout");

dojo.declare("wm.Layout", wm.Container, {
	// useful properties
	classNames: 'wmlayout',
        autoScroll: true,
	fit: false,
	width: "",
	height: "",
	create: function() {
		this.inherited(arguments);
	},
	build: function() {
		this.inherited(arguments);
		this.domNode.style.cssText += this.style + "overflow: hidden; position: relative;";
	},
	init: function() {
		this.inherited(arguments);
		/*
		// FIXME: detect ownership under app. Seems like it would be cleaner if, at least, part controlled this.
		var mainBox = (this.owner && this.owner.owner == window.app);
		if (mainBox) {
			this.fit = {
				w: (!this.width || wm.splitUnits(this.width).units == "flex"),
				h: (!this.height || wm.splitUnits(this.height).units == "flex")
			};
		}
		*/
		//if(this.domNode === document.body || mainBox){ 
			this.subscribe("window-resize", this, "resize");
		//}
	},

	fitTo: function() {
		if(this.domNode === document.body) {
			document.body.scrollTop = 0;
		}
		var pn = this.domNode.parentNode;
		if (pn && !wm.isEmpty(this.fit)) {
			pn.scrollTop = 0;
			var n = dojo.contentBox(pn), b = {}, f = this.fit;
			b.l = n.l;
			b.t = n.t;
			for (var i in f)
				if (f[i])
					b[i] = n[i];
			dojo.marginBox(this.domNode, b);
		}
	},
	resize: function() {
		// if we have a parent, they control our reflow
		// so we ignore window-resize message
		if (!this.parent)
			this.reflow();
	},
	updateBounds: function() {
		this._percEx = {w:100, h: 100};
		if (!this.parent) {
			var pn = this.domNode.parentNode;
			this.setBounds(0, 0, pn.offsetWidth, pn.offsetHeight);
			//this.setBounds(dojo.contentBox(pn));
		} else {
			this.setBounds(this.parent.getContentBounds());
		}
	},
	reflow: function() {
		if (this._cupdating)
			return;
	        this.updateBounds();
		this.renderBounds();
		//this.fitTo();
		this.inherited(arguments);
		//wm.layout.box.reflow(this.domNode);
	}/*,
	canResize: function() {
		return false;
	}*/
});

// design-time
wm.Object.extendSchema(wm.Layout, {
    themeStyleType: {group: "style", order: 150},
	fitToContent: { ignore: 1 },
	fitToContentWidth: { ignore: 1 },
	fitToContentHeight: { ignore: 1 },
	minWidth: { ignore: 1 },
	minHeight: { ignore: 1 },
	fit: { ignore: 1 }
});

// bc
wm.LayoutBox = wm.Layout;

dojo.extend(wm.Layout, {
    themeable: true,
    themeableStyles: ["Document-Styles-BorderStyle_Radius", "Document-Styles-BorderStyle_Shadow"]
});

}

if(!dojo._hasResource["wm.base.widget.Content"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["wm.base.widget.Content"] = true;
/*
 *  Copyright (C) 2008-2010 WaveMaker Software, Inc.
 *
 *  This file is part of the WaveMaker Client Runtime.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
dojo.provide("wm.base.widget.Content");


dojo.declare("wm.Content", wm.Box, {
	width: "100%", 
	height: "200px",
	scrim: true,
	autoScroll: true,
	allowDuplicateContent: false,
	content: "",
	resource: "",
	/*build: function() {
		if (this.content)
			this.domNode = this._makeContentNode();
		this.inherited(arguments);
	},*/
	init: function() {
		this.inherited(arguments);
		this.setContent(this.content);
	},
	setContent: function(inContent) {
		this.content = inContent;
		this.contentChanged(true);
	},
	setResource: function(inResourcePath) {
	    this.resource = inResourcePath;
	    this.contentChanged();
	},
	_makeContentNode: function() {
		var
			c = this.content && dojo.byId(this.content),
			n = c ? (this.allowDuplicateContent ? c.cloneNode(true) : c) : document.createElement('div');

		dojo.addClass(n, "wmcontent");
		return n;
	},
	contentChanged: function(forceUpdate) {
	    // ignore publish events about markup changes if your stuck in a page container
	    if (!forceUpdate && this.isDesignedComponent() && this.owner != studio.page) return;
		var dn = this.domNode;
		if (dn.firstChild)
			dn.removeChild(dn.firstChild);
		if (this.resource) {
		    var root = this.resource.slice(0, 4) != "http" && this.resource.slice(0, 1) != "/" ? this.getPath() : "";
			if (!this.htmlLoader)
				this.htmlLoader = new wm.HtmlLoader({owner: this, relativeUrl: true});
			this.htmlLoader._htmlNode = this.domNode;
		        this.htmlLoader.setUrl(root + this.resource);
		} else {
		    var n = this._makeContentNode();
		    dn.appendChild(n);
		}
		/*var o=this.domNode, p=o&&o.parentNode;
		var n = this._makeContentNode();
		if (n) {
			var b = dojo._getMarginBox(o);
			if (p) {
				var ns = o.nextSibling;
				p.removeChild(o);
				n = n || document.createElement('div');
				p.insertBefore(n, ns);
			}
			// use box from the content node.
			//this.box = n.box;
			this.setDomNode(n);
			dojo.marginBox(n, b);
			this.reflowParent();
		}*/
	}
});


}

if(!dojo._hasResource["wm.base.widget.Bevel"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["wm.base.widget.Bevel"] = true;
/*
 *  Copyright (C) 2008-2010 WaveMaker Software, Inc.
 *
 *  This file is part of the WaveMaker Client Runtime.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
dojo.provide("wm.base.widget.Bevel");


dojo.declare("wm.Bevel", wm.Widget, {
	className: "wmbevel",
	flex: 0,
        bevelSize: 4,
	init: function() {
		this.inherited(arguments);
	},
	getOrientedStyleName: function() {
		return this.className + " " + this.className + (this.vertical ? "-h" : "-v");
	},
	addOrientation: function() {
		dojo.addClass(this.domNode, this.getOrientedStyleName());
	},
	removeOrientation: function() {
		dojo.removeClass(this.domNode, this.getOrientedStyleName());
	},
	updateSize: function() {
		var h = (this.parent||0).layoutKind == "left-to-right", d = this.bevelSize + "px";
		this.setWidth(h ? d : "100%");
		this.setHeight(h ? "100%" : d);
	},
	setParent: function() {
		this.inherited(arguments);
		this.addOrientation();
		this.updateSize();
	}
});

// design-time
wm.Object.extendSchema(wm.Bevel, {
	vertical: { ignore: 1 },
	disabled: { ignore: 1 },
	border: {ignore: 1},
	borderColor: {ignore: 1},
	margin: {ignore: 1},
	padding: {ignore: 1},
	scrollX: {ignore: 1},
        scrollY: {ignore: 1},
        minWidth:  {ignore: 1},
        minHeight: {ignore: 1}
});

wm.Bevel.extend({
    themeableProps: ["bevelSize", "border", "borderColor"],
	scrim: true,
	sizeable: false
});

}

if(!dojo._hasResource["wm.base.widget.Button"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["wm.base.widget.Button"] = true;
/*
 *  Copyright (C) 2008-2010 WaveMaker Software, Inc.
 *
 *  This file is part of the WaveMaker Client Runtime.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
dojo.provide("wm.base.widget.Button");


dojo.declare("wm.ToolButton", wm.Widget, {
	width: "80px", 
	border: 0,
	padding: "",
	margin: "",
	caption: "",
	hint: "",
	imageList: "",
	classNames: "wmtoolbutton",
	imageIndex: -1,
	iconUrl: "",        
	iconWidth: "40px",
	iconHeight: "40px",
	iconMargin: "0 10px 0 0",
        clicked: false,
	//alignInParent: "topLeft",
	build: function() {
		if (!this.domNode)
		{

			this.domNode = document.createElement('button');
			// in IE8, type becomes submit and then acts weired everywhere.
			// therefore setting type to 'button'.
			dojo.attr(this.domNode, 'type', 'button'); 
		}	
		this.btnNode = this.domNode;
	},
	destroy: function(){
		if (this.btnNode)
		{
			dojo.destroy(this.btnNode);
			this.btnNode = null;
		}

		if (this.domNode)
		{
			dojo.destroy(this.domNode);
			this.domNode = null;
		}

		this.inherited(arguments);
	},
	init: function() {
		this.inherited(arguments);
		this.connectEvents(this.btnNode, ["click"]);
		this.setHint(this.title || this.hint);
		this.imageListChanged();
	},
	click: function(inEvent) {
		this.onclick(inEvent);
	        if (!this.clicked) 
		    this.setProp("clicked", true);
	},
	onclick: function(inEvent) {
	},
	findImageList: function() {
		var t = this;
		while (t && !t.imageList) {
			t = t.parent;
		}
		return t ? t.imageList : null;
	},
	setDisabled: function(inDisabled) {
		this.inherited(arguments);
		this.btnNode.disabled = inDisabled ? "disabled" : "";
		dojo[inDisabled ? "addClass" : "removeClass"](this.domNode, "wmbutton-disabled");
	        this.invalidCss = true;
		this.render();
	},
	setSelected: function(inSelected) {
		this.selected = inSelected;
	        this.invalidCss = true;
		this.render();
	},
	setCaption: function(inCaption) {
		this.caption = inCaption;
	        this.invalidCss = true;
		this.render();
	},
	setIconUrl: function(inUrl) {
		this.iconUrl = inUrl;
	        this.invalidCss = true;
		this.render();
	},
	setIconWidth: function(w) {
	        this.iconWidth = w;
	        this.invalidCss = true;
		this.render();
	},
	setIconHeight: function(h) {
	        this.iconHeight = h;
	        this.invalidCss = true;
		this.render();
	},
	setIconMargin: function(m) {
	        this.iconMargin = m;
	        this.invalidCss = true;
		this.render();
	},
	setContent: function(inContent) { // BC
		this.setCaption(inContent);
	},
	setHint: function(inHint) {
		this.btnNode.title = this.hint = inHint;
	},

	setImageList: function(inImageList) {
		this.imageList = inImageList;
		this.imageListChanged();
	},
	setImageIndex: function(inImageIndex) {
		if (inImageIndex !== undefined) {
			this.imageIndex = inImageIndex;
			this.imageListChanged();
		}
	},
	imageListChanged: function() {
		var iln = this.findImageList();
		this._imageList = iln ? iln instanceof wm.ImageList ? iln : this.owner.getValueById(iln) : null;
	        this.invalidCss = true;
		this.render();
	},
	render: function(forceRender) {
	    if (!forceRender && (!this.invalidCss || !this.isReflowEnabled())) return;
	    this.inherited(arguments);
		var il = this._imageList;
		if (il && il.getImageHtml && this.imageIndex >= 0) {
			var ii = this.imageIndex + (this.disabled ? il.colCount * 2 : 0) + (this.selected ? il.colCount : 0);
			var sl = this.singleLine ? "line-height: " + this.height + "; " : "";
			var captionHtml = this.caption ? '<span style="padding-left: 2px; ' + sl +'">' + this.caption + '</span>' : "";
			this.btnNode.innerHTML = il.getImageHtml(ii) + captionHtml;
			this.btnNode.style.padding = "0px";
		} else if (this.iconUrl) {
			var sl = this.singleLine ? "line-height: " + this.height + "; " : "";
			var captionHtml = this.caption ? '<span style="padding-left: 2px; ' + sl +'">' + this.caption + '</span>' : "";
			var root =  this.getPath() || "";

			this.btnNode.innerHTML = "<img src='" + wm.theme.getImagesPath() + "blank.gif' style='margin: " + this.iconMargin + "; width: " + this.iconWidth + "; height: " + this.iconHeight + "; vertical-align: middle; background:url(" + root + this.iconUrl + ") no-repeat; background-color: transparent;' />" + captionHtml;

			this.btnNode.style.padding = "0px";
		} else {
			this.btnNode.innerHTML = this.caption;
			this.btnNode.style.padding = "";
		}
	}
});

wm.Object.extendSchema(wm.ToolButton, {
	scrollX:  { ignore: 1 },
	scrollY:  { ignore: 1 },
        clicked: {ignore: 1, bindSource: true},
	iconUrl: {group: "format", bindable: true, type: "String", subtype: "File"},
	iconWidth: {group: "format"},
	iconHeight: {group: "format"},
	iconMargin: {group: "format"}
});

wm.ToolButton.extend({
        scrim: true,
	makePropEdit: function(inName, inValue, inDefault) {
		switch (inName) {
			case "iconWidth":
			case "iconHeight":
				return new wm.propEdit.UnitValue({
					component: this,
					name: inName,
					value: inValue,
					options: this._sizeUnits
				});
		}
		return this.inherited(arguments);
	},

	destroy: function(){
		if (this.btnNode)
		{
			dojo.destroy(this.btnNode);
			this.btnNode = null;
		}

		if (this.domNode)
		{
			dojo.destroy(this.domNode);
			this.domNode = null;
		}

		this.inherited(arguments);
	}
});

dojo.declare("wm.Button", wm.ToolButton, {
	height: "32px",
	border: 1,
	borderColor: "#ABB8CF",
	margin: 4,
	caption: "Button",
	classNames: "wmbutton"
});

dojo.declare("wm.ToggleButton", wm.ToolButton, {
	height: "32px",
	border: 1,
	borderColor: "#ABB8CF",
	margin: 4,
	captionUp: "Btn Up",
        captionDown: "Btn Down",
        classNames: "wmbutton wmtogglebutton",
        init: function() {
	    this.caption = this.captionUp;
	    this.inherited(arguments);
            if (this.clicked)
                this.setClicked(true);
	},
        click: function() {
	    this.onclick();
	    this.setProp("clicked", !this.clicked);
	},
    /* Sets the state, updates the css, does not fire events; useful in a set of toggle buttons where clicking one updates the states of the others, but firing events on each one would be bad */
    setClicked: function(inClicked) {
	if (inClicked != this.clicked) {
	    this.clicked = inClicked;
	    this.valueChanged("clicked", inClicked);
	    this.setCaption(this.clicked ? this.captionDown : this.captionUp);
	    dojo[this.clicked ? "addClass" : "removeClass"](this.domNode, "toggleButtonDown");
	}
    },
    setCaptionUp: function(inCaption) {
        this.captionUp = inCaption;
        this.setCaption(inCaption);
    }
});

wm.Object.extendSchema(wm.ToggleButton, {
        captionUp: { group: "display", bindTarget: 1, order: 10, focus: 1 },
	captionDown: { group: "display", bindTarget: 1, order: 11},
        clicked: { group: "display", bindTarget: 1, bindSource: 1, order: 12 },
        caption: {ignore: 1}
});

dojo.declare("wm.RoundedButton", wm.Button, {
        useDesignBorder: 0, // move this to a _design file if we ever create one
	classNames: "roundedwmbutton",
	margin: 2,
	padding: 0,
	border: 0,
	leftImgWidth: 12,
	rightImgWidth: 12,
        width: "110px",
        height: "40px",
	build: function() {
		if (!this.domNode){
			this.domNode = document.createElement('div');
			var buttonLeft = document.createElement('div');
			var buttonCenter = document.createElement('div');
			var buttonRight = document.createElement('div');
				
			dojo.addClass(buttonLeft, "button-gray-left");
			dojo.addClass(buttonCenter, "button-gray-center");
			dojo.addClass(buttonRight, "button-gray-right");
						
			buttonLeft.innerHTML = "&nbsp;";
			buttonRight.innerHTML = "&nbsp;";
			
			this.domNode.appendChild(buttonLeft);
			this.domNode.appendChild(buttonCenter);
			this.domNode.appendChild(buttonRight);
		}
			
		this.btnNode = this.domNode;
		
		this.connect(this.btnNode, "onmouseover", dojo.hitch(this, "mouseoverout", this, true));
		this.connect(this.btnNode, "onmouseout", dojo.hitch(this, "mouseoverout", this, false));		
		dojo.connect(this.btnNode, "onselectstart", dojo, "stopEvent");

		this.invalidCss = true;
	},
	mouseoverout: function(inButton, inActive){		
		if (inButton && !inButton.disabled){
			var btnNode = inButton.btnNode;
			var buttonLeft = btnNode.childNodes[0];
			var buttonCenter = btnNode.childNodes[1];
			var buttonRight = btnNode.childNodes[2];												
			dojo[inActive ? "addClass" : "removeClass"](buttonLeft, 'button-blue-left');				
			dojo[inActive ? "addClass" : "removeClass"](buttonCenter, 'button-blue-center');
			dojo[inActive ? "addClass" : "removeClass"](buttonRight, 'button-blue-right');
			dojo[inActive ? "addClass" : "removeClass"](inButton.btnNode, 'button-pointer');						
		}							
	},
	click: function(inEvent) {
		if(!this.disabled){
			this.onclick(inEvent);
		}		
	},	
	render: function(forceRender) {
	    if (!forceRender && (!this.invalidCss || !this.isReflowEnabled())) return;
	    dojo.hitch(this,wm.Control.prototype.render)(forceRender);
		var il = this._imageList;
		if (il && il.getImageHtml && this.imageIndex >= 0) {
			var ii = this.imageIndex + (this.disabled ? il.colCount * 2 : 0) + (this.selected ? il.colCount : 0);
			var sl = this.singleLine ? "line-height: " + this.height + "; " : "";
			var captionHtml = this.caption ? '<span style="padding-left: 2px; ' + sl +'">' + this.caption + '</span>' : "";
			this.btnNode.innerHTML = il.getImageHtml(ii) + captionHtml;
			this.btnNode.style.padding = "0px";
		} else if (this.iconUrl) {
			var sl = this.singleLine ? "line-height: " + this.height + "; " : "";
			var captionHtml = this.caption ? '<span style="padding-left: 2px; ' + sl +'">' + this.caption + '</span>' : "";
			var root =  this.getPath() || "";
			this.btnNode.innerHTML = "<img src='" + wm.theme.getImagesPath() + "blank.gif' style='margin: " + this.iconMargin + "; width: " + this.iconWidth + "; height: " + this.iconHeight + "; vertical-align: middle; background:url(" + root + this.iconUrl + ") no-repeat; background-color: transparent;' />" + captionHtml;
			this.btnNode.style.padding = "0px";
		} else {
			this.btnNode.childNodes[1].innerHTML = this.caption;
			//this.btnNode.childNodes[1].style.width = parseInt(this.width) - (this.leftImgWidth + this.rightImgWidth + (this.margin * 2)) + "px";								
			this.btnNode.style.padding = "";
		}
	},
	updateBounds: function(){
		this.inherited(arguments);
	    var bounds = this.getContentBounds();
	    var width = bounds.w;
	    this.btnNode.childNodes[1].style.width = width - (this.leftImgWidth + this.rightImgWidth) + "px";
	}	
});


// design-time

wm.Object.extendSchema(wm.Button, {
	caption: { group: "display", bindable: 1, order: 10, focus: 1 },
	hint: { group: "display", order: 20 },
	imageList: { group: "display",order: 50},
	imageIndex: { group: "display", order: 51 }

});


wm.Object.extendSchema(wm.RoundedButton, {
    imageList: {ignore: 1},
    imageIndex: {ignore: 1},
    iconHeight: {ignore: 1},
    iconWidth: {ignore: 1},
    iconUrl: {ignore: 1},
    iconMargin: {ignore: 1},
    leftImgWidth: {ignore: 1},
    rightImgWidth: {ignore: 1},
    border: {ignore: 1},
    borderColor: {ignore: 1},
    scrollX:  {ignore: 1},
    scrollY:  {ignore: 1},
    padding:  {ignore: 1}
});

wm.Button.description = "A simple button.";

}

if(!dojo._hasResource["wm.base.widget.Formatters"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["wm.base.widget.Formatters"] = true;
/*
 *  Copyright (C) 2008-2010 WaveMaker Software, Inc.
 *
 *  This file is part of the WaveMaker Client Runtime.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
dojo.provide("wm.base.widget.Formatters");

// FIXME: need formatter registry
wm.formatters = [ 
	"Number", "Date", "Time", "DateTime", "Currency", "Link",
	"RegularExpression", "Evaluation","Image" 
];

wm.getFormatter = function(inName) {
	var c = inName;
	if (c.slice(0, 5) != "wm")
		c = "wm." + c + "Formatter";
	return dojo.getObject(c) || wm.DataFormatter;
}

dojo.declare("wm.DataFormatter", wm.Component, {
	getColProps: function() {
		return {
			formatter: this.format
		}
	},
	format: function(inDatum) {
		return (inDatum !== undefined) ? inDatum : '&nbsp;';
	},
	valueChanged: function(inProp, inValue) {
		this.inherited(arguments);
		if (inProp)
			wm.fire(this.owner, "formatChanged");
	}
});

dojo.declare("wm.NumberFormatter", wm.DataFormatter, {
	digits: 0,
	locale: "",
	round: false,
	noFormat: false,
	// NB: called in 'cell' context
	format: function(inDatum) {
		return (inDatum === undefined) ? '-' : (this.wmNoFormat ? inDatum : dojo.number.format(inDatum, this.getFormatProps()));
	},
	getFormatProps: function() {
		return {
			places: Number(this.digits),
			locale: this.locale,
			round: this.round ? 0 : -1
		}
	},
	getColProps: function() {
		return {
			formatter: this.format,
			getFormatProps: dojo.hitch(this, "getFormatProps"),
			wmNoFormat: this.noFormat
		}
	}
});

dojo.declare("wm.CurrencyFormatter", wm.NumberFormatter, {
	currency: "$",
	format: function(inDatum) {
		return (inDatum == undefined) ? '-' : dojo.currency.format(inDatum, this.getFormatProps());
	},
	getFormatProps: function() {
		var p = this.inherited(arguments);
		// Dojo uses an iso4217 currency code, but let's allow $ to mean U.S. dollars (see http://www.xe.com/iso4217.php)
		this.digits = 2;
		p.currency = this.currency == "$" ? "USD" : this.currency;
		return p;
	}
});

dojo.declare("wm.RegularExpressionFormatter", wm.DataFormatter, {
	expression: ".*",
	global: false,
	caseSensitive: true,
	replace: "$&",
	// NB: called in 'cell' context
	init: function() {
		/*console.log(this.expression);
		this.expression = this.expression.replace(new RegExp(/\\/g), "\\\\");
		console.log(this.expression);*/
		this.inherited(arguments);
	},
	format: function(inDatum) {
		var
			opts = (this.global ? "g" : "") + (this.caseSensitive ? "" : "i");
			re = new RegExp(this.expression, opts);
		return (inDatum != undefined) ? (this.expression ? String(inDatum).replace(re, this.replace) : inDatum) : '-';
	},
	getColProps: function() {
		return {
			expression: this.expression,
			global: this.global,
			caseSensitive: this.caseSensitive,
			replace: this.replace,
			formatter: this.format
		}
	}
});

dojo.declare("wm.EvaluationFormatter", wm.DataFormatter, {
	_field: "$&",
	expression: "",
	init: function() {
		this.expression = this.expression || this._field;
		this.inherited(arguments);
	},
	// NB: called in 'cell' context
	format: function(inDatum) {
		// FIXME: hack to support formatting object data
		// trick: eval is called in this scope so we can pass in any local variable names.
		var isObject = dojo.isObject(inDatum), _data;
		if (isObject) {
			if (inDatum instanceof wm.Variable) {
				var o = inDatum.getData();
				_data = wm.isEmpty(o) ? inDatum.data : o;
			} else
				_data = inDatum;
			inDatum = "_data";
		}
		var ev = this.expression.replace(new RegExp("\\" + this._field, "g"), isObject? inDatum : '\"' + inDatum + '\"');
		try {
			return String(eval("(" + ev + ")"));
		} catch(e) {
			console.log("evaluation error: ", e);
		}
	},
	getColProps: function() {
		return {
			expression : this.expression,
			_field: this._field,
			formatter: this.format
		}
	}
});

dojo.declare("wm.DateTimeFormatter", wm.DataFormatter, {
	formatLength: "medium", // long, short, medium or full
	_selector: "",
	datePattern: "", // "M/d/yy",
	timePattern: "", // "h:m:s a",
	locale: "",
	// NB: called in 'cell' context
	format: function(inDatum) {
		var opts = {
			selector: this._selector,
			formatLength: this.formatLength,
			datePattern: this.datePattern,
			timePattern: this.timePattern,
			locale: this.locale
		}
		var d = new Date(inDatum);
		if (isNaN(d.getTime()))
			d = new Date(Number(inDatum));
		return (inDatum == undefined) || isNaN(d.getTime()) ? '-' : dojo.date.locale.format(d, opts);
	},
	getColProps: function() {
		return {
			_selector: this._selector,
			formatLength: this.formatLength,
			datePattern: this.datePattern,
			timePattern: this.timePattern,
			locale: this.locale,
			formatter: this.format
		}
	},
	makePropEdit: function(inName, inValue, inDefault) {
		switch (inName) {
			case "formatLength":
				return makeSelectPropEdit(inName, inValue, ["medium", "short", "long", "full"], inDefault);
		}
		return this.inherited(arguments);
	}
});

dojo.declare("wm.DateFormatter", wm.DateTimeFormatter, {
	_selector: "date"
});

dojo.declare("wm.TimeFormatter", wm.DateTimeFormatter, {
	_selector: "time"
});

dojo.declare("wm.LinkFormatter", wm.DataFormatter, {
	link: "",
	// NB: called in 'cell' context
	format: function(inDatum) {
		if (inDatum === undefined)
			return '-';
		else {
			var l = this.link;
			return l.indexOf("<a") >=0 ? dojo.string.substitute(l, {data: inDatum}) : 
				['<a href="', this.link, this.link ? "#" : "", inDatum, '">', inDatum, '</a>'].join('');
		}
	},
	getColProps: function() {
		return {
			link: this.link,
			formatter: this.format
		}
	}
});

dojo.declare("wm.ImageFormatter", wm.DataFormatter, {
	imageWidth:'50px',
	imageHeight:'50px',
	
	format: function(src) {
		if (!src || src == '')
			return "-";
		return ['<img src="', src, "#", '" width="', this.imageWidth,'" height="', this.imageHeight, '"/>'].join('');
	},
	getColProps: function() {
		return {
			imageWidth: this.imageWidth,
			imageHeight: this.imageHeight,
			formatter: this.format
		}
	}
});

// design only...
wm.Object.extendSchema(wm.DataFormatter, {
	name: { ignore: 1 }
});

wm.Object.extendSchema(wm.DateFormatter, {
	timePattern: { ignore: 1 }
});

wm.Object.extendSchema(wm.TimeFormatter, {
	datePattern: { ignore: 1 }
});

}

if(!dojo._hasResource["wm.base.widget.Label"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["wm.base.widget.Label"] = true;
/*
 *  Copyright (C) 2008-2010 WaveMaker Software, Inc.
 *
 *  This file is part of the WaveMaker Client Runtime.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
dojo.provide("wm.base.widget.Label");


dojo.declare("wm.Label", wm.Control, {
	width: "200px",
	height: "36px",
	caption: '',
	link: '',
	display: '',
	format: '(details)',
	//resizeToFit: "(Resize to Fit)",
	padding: 4,
	singleLine: true,
	align: "none",
	init: function() {
		dojo.addClass(this.domNode, "wmlabel");
		this.inherited(arguments);
		this.connectEvents(this.domNode, ["click"]);            
		// this.connectEvents(this.domNode, ["dblclick"]);  WAVEMAKER: Uncomment this if we find a good use for this...
	},
	click: function(e) {
		this.onclick(e);
	},
	/* Uncomment this if/when we find a good use for it
	dblclick: function(e) {
		this.ondblclick(e);
	},
	ondblclick: function(inEvent) {
	}, */
	postInit: function() {
		this.inherited(arguments);
		if (!this.$.format)
			new wm.DataFormatter({name: "format", owner: this});
		this.caption = this.label || this.content || this.caption;
		// bc
		delete this.content;
		delete this.label;
		this.renderLabel();
		this.valueChanged("caption", this.caption);
		this.valueChanged("link", this.link);
	},
	renderLabel: function() {
		if (this._loading)
			return;
		var c = this.$.format.format(this.caption);
		if (this.link)
			c = ['<a ', (this.link.indexOf("#") == -1 && this.link.indexOf("javascript") == -1)? 'target="_blank" ' : '', 'href="', this.link, '">', c, '</a>'].join('');
		if (this.domNode.innerHTML != c)
			this.domNode.innerHTML = c;
		var whitespace = (this.singleLine || this.autoSizeWidth) ? "nowrap" : "normal";
		if (this.domNode.style.whiteSpace != whitespace)
		        this.domNode.style.whiteSpace = whitespace;
                var align = (this.align == "none") ? "" : this.align;
		if (this.domNode.style.textAlign != align)
			this.domNode.style.textAlign = align;
		//this.reflowParent();
		//this.doAutoSize();
	},
	setCaption: function(inCaption) {
            var innerHTML = this.domNode.innerHTML;
	    if (inCaption && dojo.isArray(inCaption))
		inCaption = inCaption.join(', ');
	    else if (inCaption && dojo.isObject(inCaption))
		inCaption = "";
	    this.caption = inCaption;
	    this.renderLabel();
            if ( innerHTML != this.domNode.innerHTML && (this.autoSizeHeight || this.autoSizeWidth)) {
		this.scheduleAutoSize();
            }
	},

    scheduleAutoSize: function() {
        this._needsAutoSize = true;
        return wm.job(this.getId() + ": doAutoSize", 10,  dojo.hitch(this, function() {this.doAutoSize(true,false);}));
    },
        doAutoSize: function(setSize, force) {
            if (this._doingAutoSize || !this.autoSizeHeight && !this.autoSizeWidth) return;
	    if (!force && !this._needsAutoSize) return;

	    if (this.isAncestorHidden()) {
		return;
	    }

            this._doingAutoSize = true;
	    this._needsAutoSize = false;

	    var divObj = wm.Label.sizingNode;
	    divObj.innerHTML = this.caption;
	    divObj.className = this.domNode.className;  // make sure it gets the same css selectors as this.domNode (we may need to handle ID as well, but most styling is done via classes)
	    var b = this.bounds;
  	    var s = divObj.style;
	    s.position = "absolute";
	    s.height = (!this.autoSizeHeight) ? (b.h - this.padBorderMargin.t - this.padBorderMargin.b) + "px" : "";
	    s.width = (!this.autoSizeWidth) ? (b.w - this.padBorderMargin.l - this.padBorderMargin.r) + "px" : "";

	    // If I have a 5px padding on the left or right, that will throw off the calculation unless we build that into our test div and force it to render with that as part of its width
	    s.paddingLeft = (this.autoSizeWidth) ?  (this.padBorderMargin.l + this.padBorderMargin.r) + "px" : "";
	    s.paddingTop = (this.autoSizeHeight) ?  (this.padBorderMargin.t + this.padBorderMargin.b) + "px" : "";

	    // singleLine disabled if autoSizeHeight
	    s.lineHeight = (this.singleLine || this.autoSizeWidth) ? b.h + "px" : "normal";
	    s.whiteSpace = (this.singleLine || this.autoSizeWidth) ? "nowrap" : "";

	    // append to parent so that it gets the same css selectors as this.domNode.
	    this.parent.domNode.appendChild(divObj);

	    var captionWidth  = divObj.clientWidth;
	    var captionHeight = divObj.clientHeight;
	    divObj.parentNode.removeChild(divObj);

	    if (this.autoSizeHeight) {
		var newh = captionHeight;
                var minHeight = this.getMinHeightProp();
		if (newh < minHeight) newh = minHeight;
                if (setSize)
                    this.setHeight(newh + "px");
                else {
		    this.bounds.h = newh;
		    this.height = newh + "px";
		}
	    }
	    if (this.autoSizeWidth) {
		var neww = captionWidth;
                var minWidth = this.getMinWidthProp();
		if (neww < minWidth) neww = minWidth;
                if (setSize)
                    this.setWidth(neww + "px");
                else {
		    this.bounds.w = neww; 
		    this.width = neww + "px";
		}
	    }

	    // the line underneath updates panel's width property. Therefore only required for studio.
	    if (this.isDesignLoaded() && studio.designer.selected == this)
		studio.inspector.reinspect();
            this._doingAutoSize = false;
	},
	setLink: function(inLink) {
		this.link = inLink;
		this.renderLabel();
	},
	setSingleLine: function(inSingleLine) {
            var oldSingleLine = this.singleLine;
	    this.singleLine = inSingleLine;
            if (oldSingleLine != inSingleLine)
                this.domNode.style.lineHeight = (inSingleLine) ? this.bounds.h + "px" : "normal";
	    this.renderLabel();
	    if (inSingleLine && this.autoSizeHeight) 
		this.autoSizeHeight = false;

	    if (inSingleLine != oldSingleLine && (this.autoSizeHeight || this.autoSizeWidth)) {
		this.scheduleAutoSize();
            }
	},
	setAlign: function(inAlign) {
		this.align = inAlign;
	    	this.renderLabel();
	},
	formatChanged: function() {
		this.renderLabel();
	},
	onclick: function(inEvent) {
	}
});

// design only...
wm.Object.extendSchema(wm.Label, {
    disabled: { ignore: 1 },
    caption: { type: "String", bindable: 1, group: "display", order: 100, focus: true },
    display: { group: "format", order: 20 },
    align: { group: "display", order: 25 },
    singleLine: { group: "display", order: 200 },
    format: { ignore: 1, writeonly: 1, categoryParent: "Properties", categoryProps: {component: "format"}},
    link: { type: "String", bindable: 1, group: "format", order: 40 },
    autoSizeHeight: {type: "Boolean", group: "advanced layout", order: 31, writeonly: true, ignore: true},
    autoSizeWidth: {type: "Boolean", group: "advanced layout", order: 32, shortname: "Auto Size"}
    //resizeToFit:{ group: "layout", order: 30 }
});

wm.Label.description = "A simple label.";

wm.Label.extend({
        themeable: false,
	designCreate: function() {
		// if this is being created in studio, supply a default caption
		if (this._studioCreating)
			this.studioCreate();
		this.inherited(arguments);
	},
	afterPaletteDrop: function() {
		this.caption = this.caption || this.name;
		this.renderLabel();
	},
	setDisplay: function(inDisplay) {
		if (this.display == inDisplay)
			return;
		this.display = inDisplay;
		var ctor = wm.getFormatter(this.display);
		this.components.format.destroy();
		new ctor({name: "format", owner: this});
		this.renderLabel();
	},
/*
	resizeLabel: function(){
		var divObj = dojo.doc.createElement('span');
		divObj.innerHTML = this.caption;
		divObj.style.padding = '5px';
		document.body.appendChild(divObj);
		var coords = dojo.coords(divObj);
		var captionWidth = coords.w;
		divObj.parentNode.removeChild(divObj);
		this.setWidth(captionWidth + 'px');
		// the line underneath updates panel's width property. Therefore only required for studio.
		if (this.isDesignLoaded())
			setTimeout(dojo.hitch(studio.inspector, "reinspect"), 100); 		
	},
        */
	makePropEdit: function(inName, inValue, inDefault) {
		switch (inName) {
			case "display":
				return makeSelectPropEdit(inName, inValue, [""].concat(wm.formatters), inDefault);
/*
			case "resizeToFit":
				return makeReadonlyButtonEdit(inName, inValue, inDefault);
                                */
                        case "autoSizeWidth": 
		                return makeSelectPropEdit(inName, (this.autoSizeHeight) ? "height" : (this.autoSizeWidth) ? "width" : "none", ["none", "width", "height"], inDefault);
			case "align":
				return makeSelectPropEdit(inName, inValue, ["none", "left", "center", "right", "justify"], inDefault);
		}
		return this.inherited(arguments);
	},

    /* This hack should only be called at design time */
    setAutoSizeWidth: function(inValue) {
        if (inValue == "none") {
            wm.Control.prototype.setAutoSizeWidth.call(this, false);
            this.setAutoSizeHeight(false);
        } else if (inValue == "width") {
            if (inValue) {
                this.setSingleLine(true);
            }
            this.setAutoSizeHeight(false);
            wm.Control.prototype.setAutoSizeWidth.call(this, true);
        } else if (inValue == "height") {
            if (inValue) {
                this.setSingleLine(false);
            }
            wm.Control.prototype.setAutoSizeWidth.call(this, false);
            this.setAutoSizeHeight(true);
        }
    },

    // Any time the user changes the class for the label, recalculate autosize with the new styleing which may include font size changes	
    addUserClass: function(inClass, inNodeName) {
	this.inherited(arguments);
        if (this.autoSizeHeight || this.autoSizeWidth) {
	    this.scheduleAutoSize();
        }
    }
});

// NOTE: This sizing node is used by ALL classes that need a sizing node (wm.Html, wm.Base, etc...)
wm.Label.sizingNode = document.createElement("div");

}

if(!dojo._hasResource["wm.base.widget.PageContainer"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["wm.base.widget.PageContainer"] = true;
/*
 *  Copyright (C) 2008-2010 WaveMaker Software, Inc.
 *
 *  This file is part of the WaveMaker Client Runtime.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
dojo.provide("wm.base.widget.PageContainer");



wm.pagesFolder = "pages/";

dojo.declare("wm.PageContainer", wm.Box, {
	width: "100%", 
	height: "100%",
	pageName: "",
	deferLoad: false,
	loadParentFirst: true,
	pageProperties: null,
	classNames: "wmpagecontainer",
	init: function() {
		this.pageLoadedList = [];
		this.inherited(arguments);
		this.createPageLoader();
		this.pageLoadedDeferred = new dojo.Deferred();
	        if (!this.deferLoad || !this.isAncestorHidden())
		  this.loadPage(this.pageName);
		//this._connections.push(dojo.connect(window, "onbeforeunload", this, "destroy"));
		dojo.addOnWindowUnload(this, 'destroy');
	},
        postInit: function() {
	    this.inherited(arguments);
	    if (this.isDesignedComponent() && this.designWrapper) {
		dojo.addClass(this.designWrapper.domNode, "pageContainerDesignWrapper");
                this.designWrapper.domNode.style.backgroundColor = "white";
                this.createOpenPageButton();
	    }
	},
    createOpenPageButton: function() {
        if (this.openPageButton) {
            dojo.destroy(this.openPageButton);
            dojo.disconnect(this.openPageButtonConnect);
        }
	var openPageButton = this.openPageButton = document.createElement("div");
                
	openPageButton.className = "openPageContainerDesignWrapperButton" + ((this.pageName) ? " hasPageName" : ""); 
	openPageButton.innerHTML = (this.pageName) ? "Open Page" : "New Page";
	this.designWrapper.domNode.appendChild(openPageButton);	
	this._designerOpenPageButton = openPageButton;
	this.openPageButtonConnect = dojo.connect(openPageButton, "onclick", this, function() {
            if (this.pageName) {
	        if (!studio.isPageDirty() || window.confirm("Are you sure you want to close the current page and open " + this.pageName + "?"))
		    studio.project.openPage(this.pageName);
            } else {
                this.createNewPage();
            }
	});

    },
	createPageLoader: function() {
		this._pageLoader = new wm.PageLoader({owner: this, domNode: this.domNode, isRelativePositioned: this.isRelativePositioned});
		this._connections.push(this.connect(this._pageLoader, "onPageChanged", this, "pageChanged"));
	},
	getMainPage: function() {
	  var owner = this.owner;
	  while(owner.owner) {
	    owner = owner.owner;
	  }
	  if (owner instanceof wm.Application)
	    return owner;
	},
	/* Not sure if this gets called */
	destroy: function() {
		if (this.isDestroyed)
			return;
	  var owner = this.getMainPage();
	  if (owner) owner.subPageUnloaded(this.page);	  
	  try {
		this.inherited(arguments);
	  } catch(e) {}
	  
	  if (this._pageLoader)
	  {
		this.destroyPreviousPage();
	  	this._pageLoader.destroy();
		this._pageLoader = null;
	  }
	  owner = null;	
	},
	destroyPreviousPage: function(){
	  	for (var i = 0; i < this.pageLoadedList.length; i++)
		{
			try
			{
		  		this._pageLoader.destroyPage(this.pageLoadedList[i]);
			}
			catch(e)
			{
				console.info('couldnt delete page <--------------');
			}
		}

		this.pageLoadedList = [];
	},
	pageChanged: function(inPage, inPreviousPage) {
		try
		{
			// establish page reference
			this.destroyPreviousPage();
			this.pageLoadedList.push(inPage);
			this.page = inPage;
			this[inPage.name] = inPage;
	
			var owner = this.getMainPage();
			if (owner) owner.subPageLoaded(this.page);	  
	
			// FIXME: parent required for layout
			if (this.page.root)
				this.page.root.parent = this;
			// change callback / event
			if (this.pageLoadedDeferred)
				this.pageLoadedDeferred.callback({page: inPage, previousPage: inPreviousPage});
			this.onPageChanged(inPage, inPreviousPage);
			// clean up previous page reference
			var o = (inPreviousPage || 0).name
			if (o && this[o])
				delete this[o];
		}
		catch(e)
		{
			console.info('error in pageChanged in pagecontainer.js ......', e);			
		}
	},
	loadPage: function(inName) {
	    try {
		var d = this.isDesignLoaded(), s = wm.studioConfig;
		if (d && s && s.preventSubPages)
			return;
		// bc: name with initial letter lowercase is required
		var pageName = inName.charAt(0).toLowerCase() + inName.slice(1);

	        // If the design is loaded, then page loading of the container is handled elsewhere.
		if (pageName) {
		    if (!d && this.loadParentFirst && this.getParentPage()._loadingPage) {
			// Prevent this from being connected multiple times
			if (!this._pageLoaderConnectedToOwnerStart) {
				if (this._currentPageConnect)
					dojo.disconnect(this._currentPageConnect);
			    this._currentPageConnect = this.owner.connect(this.owner, "start", dojo.hitch(this, 'pageLoaderOnOwnerStart', inName, pageName));
			    this._pageLoaderConnectedToOwnerStart = true;
			}
		    } else {
		      this._pageLoader.loadPage(inName, pageName);
				if (this._currentPageConnect)
					dojo.disconnect(this._currentPageConnect);
                        if (this._pageLoader.page._startCalled)
                            this.onStart();
                        else
		            this._currentPageConnect = this._pageLoader.page.connect(this._pageLoader.page, "onStart", this, "onStart");
		    }
		} else {
			this.destroyPreviousPage();
		}
	    } catch(e) {
		console.error("PageContainer page  '" + inName + "' failed to load: " + e);
	    }
	},
	pageLoaderOnOwnerStart: function(inName, pageName) {
		this._pageLoaderConnectedToOwnerStart = false;
		this._pageLoader.loadPage(inName, pageName);
		this._pageLoader.page.connect(this._pageLoader.page, "onStart", this, "onStart");
    },
	onStart: function() {
	    if (this.parent && this.page && !dojo.coords(this.page.root.domNode).w) 
			this.parent.reflow();
	},
	forEachWidget: function(inFunc) {
		if (this.page)
			return this.page.forEachWidget(inFunc);
	},
	setPageName: function(inPageName) {
		if (this._pageLoading)
			return;
	    if (inPageName == "-New Page" && this.isDesignLoaded()) {
	        return this.createNewPage();
	    }

	    if (this._designerOpenPageButton)
		dojo[this.pageName ? "addClass" : "removeClass"](this._designerOpenPageButton, "hasPageName");

		var o = this.pageName;
		this.pageName = inPageName || "";
	    if (this.isDesignedComponent() && this.designWrapper) {
                this.createOpenPageButton();
            }

	    this.pageLoadedDeferred = new dojo.Deferred();
            if (o != this.pageName)
		this.loadPage(this.pageName);
	},

        // Provided for use in debugging. Note that when we do a better job of caching pages from server, we will need to deallocate them in this call
        forceReloadPage: function() {
            var pageName = this.pageName;
            this.setPageName(null);
            delete window[pageName];
            this.setPageName(pageName);
        },
	onPageChanged: function(inNewPage, inPreviousPage) {
	},
	// optimization: page created when shown if doesn't exist.
	_onShowParent: function() {
		this.revealed();
	},
	revealed: function() {
		if (!this.page)
			this.loadPage(this.pageName);
	},
	flow: function() {
		if (this._boundsDirty)
			wm.fire(this.page, "reflow");
	},
	reflow: function() {
		this._boundsDirty = true;
		this.flow();
	},
	hasPageLoaded: function(optionalPageName) {
	  if (!optionalPageName) return Boolean(this.page);
	  return Boolean(this.page && this.page.name == optionalPageName);
	}
});

// design only
wm.PageContainer.extend({
        themeable: false,
	scrim: true,
	_isBindSource: true,
    createNewPage: function() {
	var pages = studio.project.getPageList();

	var l = {};
	dojo.forEach(pages, function(p) {
	    l[p] = true;
	});
        studio.promptForName("page", wm.findUniqueName("Page", [l]), pages,
                             dojo.hitch(this, function(n) {
				 n = wm.capitalize(n);
				 this.pageName = n;
				 app.confirm("Can we save your current page before moving on to the next page? This will save your pageContainer's pageName.", 
					     false,
					     dojo.hitch(this,function() {
						 studio.project.saveProject();
						 studio.project.newPage(n);
					     }),
					     dojo.hitch(this,function() {
						 studio.project.newPage(n);
					     }));
			     }));
    },
	designCreate: function() {
		this.inherited(arguments);
		if (this.designWrapper)
			dojo.addClass(this.designWrapper.domNode, "wmchrome-wrapper");
	},
	writeChildren: function() {
		return [];
	},
	// write only binding.
	writeComponents: function(inIndent) {
		var
			s = [];
			c = this.components.binding.write(inIndent);
		if (c) 
			s.push(c);
		return s;
	},
	makePropEdit: function(inName, inValue, inDefault) {
		switch (inName) {
			case "pageName":
		    return new wm.propEdit.PagesSelect({component: this, name: inName, value: inValue, newPage: true});
		}
		return this.inherited(arguments);
	},
	afterPaletteDrop: function() {
		// change default so deferLoad is false
		// this.inherited(arguments);
		this.deferLoad = true;
	}
})

wm.Object.extendSchema(wm.PageContainer, {
	pageLoadedDeferred: {ignore: 1},
	pageName: {group: "common", bindable: 1, type: "string", order: 50},
	deferLoad: {group: "common", order: 100},
	loadParentFirst: {group: "common", order: 101},
	box: {ignore: 1},
	disabled: {ignore: 1},
	page: {ignore: 1},
	pageProperties: {ignore: 1, writeonly: 1}
});

}

if(!dojo._hasResource["wm.base.widget.LivePanel"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["wm.base.widget.LivePanel"] = true;
/*
 *  Copyright (C) 2008-2010 WaveMaker Software, Inc.
 *
 *  This file is part of the WaveMaker Client Runtime.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
dojo.provide("wm.base.widget.LivePanel");

dojo.declare("wm.LivePanel", wm.Panel, {
	height: "100%",
	width: "100%",
	layoutKind: "top-to-bottom",
	liveDataName: "",
        autoScroll: true,
	afterPaletteDrop: function() {
		wm.Container.prototype.afterPaletteDrop.call(this);
	        var fancyPanel1 = new wm.FancyPanel({parent: this,
                                                     horizontalAlign: "left",
                                                     verticalAlign: "top",
						     owner: this.owner,
						     name: this.liveDataName + "GridPanel",
						     title: wm.capitalize(this.liveDataName)});
		this.dataGrid = new wm.DojoGrid({
                                border: "0", // wm.FancyPanel + theme change; fancy panel provides the border; ignore any default borders provided by theme
				name: studio.page.getUniqueName(this.liveDataName + "DojoGrid"),
				owner: this.owner,
				height:'100%',
				parent: fancyPanel1.containerWidget, // wm.FancyPanel change; revert to returning "this"
				_classes: {"domNode":["omgDataGrid"]}
			});
	        var fancyPanel2 = new wm.FancyPanel({parent: this,
                                                     horizontalAlign: "left",
                                                     verticalAlign: "top",
						     owner: this.owner,
						     name: this.liveDataName + "DetailsPanel",
						    title: "Details"});
		this.liveForm = new wm.LiveForm({
				name: studio.page.getUniqueName(this.liveDataName + "LiveForm1"),
				owner: this.owner,
		                parent: fancyPanel2.containerWidget, // wm.FancyPanel change; revert to returning "this"
				verticalAlign: "top",
				horizontalAlign: "left",
				_liveSource: this.liveSource
			});
	        this.reflow(); // added for fancypanel support
		this.liveForm.createLiveSource(this.liveSource);
		var lvar = this.liveForm.dataSet.name;
		this.dataGrid.set_dataSet(lvar);
		this.liveForm.set_dataSet(this.dataGrid.name + ".selectedItem");
		this.liveForm.eventBindings.onSuccess = lvar;
		fancyPanel2.setFitToContentHeight(true);
	}
});

wm.Object.extendSchema(wm.LivePanel, {
    themeStyleType: {ignore: 1},
	liveDataName: {ignore: 1},
	liveSource: {ignore: 1}
});

}

if(!dojo._hasResource["wm.base.widget.LayoutBox"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["wm.base.widget.LayoutBox"] = true;
/*
 *  Copyright (C) 2008-2010 WaveMaker Software, Inc.
 *
 *  This file is part of the WaveMaker Client Runtime.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
dojo.provide("wm.base.widget.LayoutBox");


wm.LayoutBox = wm.Layout;


}

if(!dojo._hasResource["wm.base.widget.Scrim"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["wm.base.widget.Scrim"] = true;
/*
 *  Copyright (C) 2008-2010 WaveMaker Software, Inc.
 *
 *  This file is part of the WaveMaker Client Runtime.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
dojo.provide("wm.base.widget.Scrim");


dojo.declare("wm.Scrim", wm.Widget, {
	showing: false,
	waitCursor: true,
	init: function() {
	    if (this.owner && this.owner.isDesignedComponent())
		studio.designer.domNode.appendChild(this.domNode);
	    else
		document.body.appendChild(this.domNode);
	    this.inherited(arguments);
		dojo.addClass(this.domNode, "wmscrim");
		// remember, zIndex must be set in style to avoid layout.
		this.domNode.style.zIndex = 10;
		this.domNode.style.position = "absolute";
		if (this.waitCursor)
			this.domNode.style.cursor = "wait";
	},
	reflowParent: function() {
		//if (this.domNode.parentNode)
		dojo.marginBox(this.domNode, dojo.contentBox(this.domNode.parentNode));
	},
	scrimify: function(/*inFunc*/) {
		var f = dojo.hitch.apply(dojo, arguments);
		this.setShowing(true);
		try{
			f();
			//inFunc();
		}finally{
			this.setShowing(false);
		}
	},
	scrimOnIdle: function(/*inFunc*/) {
		this.setShowing(true);
		var self = this, args = arguments;
		setTimeout(function() {
			self.scrimify.apply(self, args)
		}, 100);
	},
	setShowing: function(inShowing) {
		this.inherited(arguments);
		// FIXME: Try to get scrim behavior in IE.... (not currently working)
		/*if (dojo.isIE) {
			setTimeout(dojo.hitch(this, function() {
				if (this.waitCursor)
					document.body.style.cursor = inShowing ? "wait" : "";
				document.body[inShowing ? "setCapture" : "releaseCapture"](true);
			}), 0);
		}*/
	},
	scrimifyDeferred: function(inDeferred) {
		this.setShowing(true);
		inDeferred.addCallback(dojo.hitch(this, this.setShowing, false));
	}
});

}

if(!dojo._hasResource["wm.base.widget.Picture"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["wm.base.widget.Picture"] = true;
/*
 *  Copyright (C) 2008-2010 WaveMaker Software, Inc.
 *
 *  This file is part of the WaveMaker Client Runtime.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
dojo.provide("wm.base.widget.Picture");


dojo.declare("wm.Picture", wm.Box, {
	aspect: "none",
	hint: "",
	width: "100px",
	height: "100px",
	link: "",
	source: "",
	init: function() {
		this.inherited(arguments);
		var d=this.domNode;
		d.innerHTML = '<a><img></a>';
		dojo.addClass(d, "wmpicture");
		this.linkNode = d.firstChild;
		this.img = this.linkNode.firstChild;
		dojo.addClass(this.img, "wmpicture-image");
		//this.connect(this.img, "load", this, "imageLoaded");
		this.connect(this.img, "click", this, "onclick");
		this.setSource(this.source);
		this.setAspect(this.aspect);
		this.setLink(this.link);
		this.setHint(this.hint);
	},
	setSource: function(inSource) {
		this.source = inSource || "";
		this.valueChanged("source", this.source);
		this.img.style.display = this.source ? "" : "none";
		var root = this.source.slice(0, 4) != "http" && this.source.slice(0, 1) != "/" ? this.getPath() : "";
		this.img.src = root + this.source;

	},
	setHint: function(inHint) {
		this.domNode.title = this.hint = inHint;
	},
	setAspect: function(inAspect) {
		var s=this.img.style, w="width", h="height", a=this.aspect=inAspect;
		s.width = (a=="v" ? "100%" : "");
		s.height = (a=="h" ? "100%" : "");
	},
	setLink: function(inLink) {
		this.link = inLink;
		if (inLink) {
			this.linkNode.target = "_blank";
			this.linkNode.href = inLink;
		} else
			this.linkNode.removeAttribute("href");
	},
	onclick: function() {
	}
});

wm.Object.extendSchema(wm.Picture, {
    source: { type: "String", bindable: 1, group: "common", order: 1, focus: 1, subtype: "File", extensionMatch: ["jpg","jpeg","gif","png","tiff"] },
	hint: { group: "common", order: 2 },
	link: { type: "String", bindable: 1 },
	aspect: { group: "layout", order: 50}
});

// design-time 
dojo.extend(wm.Picture, {
        themeable: false,
        themeableDemoProps: {source: "images/add.png"},
	makePropEdit: function(inName, inValue, inDefault) {
		switch(inName){
			case "source": 
				return makePictureSourcePropEdit(inName, inValue, inDefault);
			case "aspect": 
				return makeSelectPropEdit(inName, inValue, ["h", "v", "none"], inDefault);
		}
		return this.inherited("makePropEdit", arguments);
	}
});

makePictureSourcePropEdit = function(inName, inValue, inDefault) {
	var i = makeInputPropEdit(inName, inValue, inDefault);
	var f = '<form class="inspector-filebox"><input class="inspector-fileinput" onchange="inspectFileboxUrlChange.call(this)" size="1" type="file"/></form>';
	return '<table width="100%" cellpadding="0" cellspacing="0" border="0"><tr><td>' + i + '</td><td>' + f + '</td></tr></table>';
}


}

if(!dojo._hasResource["dijit._base.manager"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["dijit._base.manager"] = true;
dojo.provide("dijit._base.manager");

dojo.declare("dijit.WidgetSet", null, {
	// summary:
	//		A set of widgets indexed by id. A default instance of this class is
	//		available as `dijit.registry`
	//
	// example:
	//		Create a small list of widgets:
	//		|	var ws = new dijit.WidgetSet();
	//		|	ws.add(dijit.byId("one"));
	//		| 	ws.add(dijit.byId("two"));
	//		|	// destroy both:
	//		|	ws.forEach(function(w){ w.destroy(); });
	//
	// example:
	//		Using dijit.registry:
	//		|	dijit.registry.forEach(function(w){ /* do something */ });

	constructor: function(){
		this._hash = {};
		this.length = 0;
	},

	add: function(/*dijit._Widget*/ widget){
		// summary:
		//		Add a widget to this list. If a duplicate ID is detected, a error is thrown.
		//
		// widget: dijit._Widget
		//		Any dijit._Widget subclass.
		if(this._hash[widget.id]){
			throw new Error("Tried to register widget with id==" + widget.id + " but that id is already registered");
		}
		this._hash[widget.id] = widget;
		this.length++;
	},

	remove: function(/*String*/ id){
		// summary:
		//		Remove a widget from this WidgetSet. Does not destroy the widget; simply
		//		removes the reference.
		if(this._hash[id]){
			delete this._hash[id];
			this.length--;
		}
	},

	forEach: function(/*Function*/ func, /* Object? */thisObj){
		// summary:
		//		Call specified function for each widget in this set.
		//
		// func:
		//		A callback function to run for each item. Is passed the widget, the index
		//		in the iteration, and the full hash, similar to `dojo.forEach`.
		//
		// thisObj:
		//		An optional scope parameter
		//
		// example:
		//		Using the default `dijit.registry` instance:
		//		|	dijit.registry.forEach(function(widget){
		//		|		console.log(widget.declaredClass);
		//		|	});
		//
		// returns:
		//		Returns self, in order to allow for further chaining.

		thisObj = thisObj || dojo.global;
		var i = 0, id;
		for(id in this._hash){
			func.call(thisObj, this._hash[id], i++, this._hash);
		}
		return this;	// dijit.WidgetSet
	},

	filter: function(/*Function*/ filter, /* Object? */thisObj){
		// summary:
		//		Filter down this WidgetSet to a smaller new WidgetSet
		//		Works the same as `dojo.filter` and `dojo.NodeList.filter`
		//
		// filter:
		//		Callback function to test truthiness. Is passed the widget
		//		reference and the pseudo-index in the object.
		//
		// thisObj: Object?
		//		Option scope to use for the filter function.
		//
		// example:
		//		Arbitrary: select the odd widgets in this list
		//		|	dijit.registry.filter(function(w, i){
		//		|		return i % 2 == 0;
		//		|	}).forEach(function(w){ /* odd ones */ });

		thisObj = thisObj || dojo.global;
		var res = new dijit.WidgetSet(), i = 0, id;
		for(id in this._hash){
			var w = this._hash[id];
			if(filter.call(thisObj, w, i++, this._hash)){
				res.add(w);
			}
		}
		return res; // dijit.WidgetSet
	},

	byId: function(/*String*/ id){
		// summary:
		//		Find a widget in this list by it's id.
		// example:
		//		Test if an id is in a particular WidgetSet
		//		| var ws = new dijit.WidgetSet();
		//		| ws.add(dijit.byId("bar"));
		//		| var t = ws.byId("bar") // returns a widget
		//		| var x = ws.byId("foo"); // returns undefined

		return this._hash[id];	// dijit._Widget
	},

	byClass: function(/*String*/ cls){
		// summary:
		//		Reduce this widgetset to a new WidgetSet of a particular `declaredClass`
		//
		// cls: String
		//		The Class to scan for. Full dot-notated string.
		//
		// example:
		//		Find all `dijit.TitlePane`s in a page:
		//		|	dijit.registry.byClass("dijit.TitlePane").forEach(function(tp){ tp.close(); });

		var res = new dijit.WidgetSet(), id, widget;
		for(id in this._hash){
			widget = this._hash[id];
			if(widget.declaredClass == cls){
				res.add(widget);
			}
		 }
		 return res; // dijit.WidgetSet
},

	toArray: function(){
		// summary:
		//		Convert this WidgetSet into a true Array
		//
		// example:
		//		Work with the widget .domNodes in a real Array
		//		|	dojo.map(dijit.registry.toArray(), function(w){ return w.domNode; });

		var ar = [];
		for(var id in this._hash){
			ar.push(this._hash[id]);
		}
		return ar;	// dijit._Widget[]
},

	map: function(/* Function */func, /* Object? */thisObj){
		// summary:
		//		Create a new Array from this WidgetSet, following the same rules as `dojo.map`
		// example:
		//		|	var nodes = dijit.registry.map(function(w){ return w.domNode; });
		//
		// returns:
		//		A new array of the returned values.
		return dojo.map(this.toArray(), func, thisObj); // Array
	},

	every: function(func, thisObj){
		// summary:
		// 		A synthetic clone of `dojo.every` acting explictly on this WidgetSet
		//
		// func: Function
		//		A callback function run for every widget in this list. Exits loop
		//		when the first false return is encountered.
		//
		// thisObj: Object?
		//		Optional scope parameter to use for the callback

		thisObj = thisObj || dojo.global;
		var x = 0, i;
		for(i in this._hash){
			if(!func.call(thisObj, this._hash[i], x++, this._hash)){
				return false; // Boolean
			}
		}
		return true; // Boolean
	},

	some: function(func, thisObj){
		// summary:
		// 		A synthetic clone of `dojo.some` acting explictly on this WidgetSet
		//
		// func: Function
		//		A callback function run for every widget in this list. Exits loop
		//		when the first true return is encountered.
		//
		// thisObj: Object?
		//		Optional scope parameter to use for the callback

		thisObj = thisObj || dojo.global;
		var x = 0, i;
		for(i in this._hash){
			if(func.call(thisObj, this._hash[i], x++, this._hash)){
				return true; // Boolean
			}
		}
		return false; // Boolean
	}

});

/*=====
dijit.registry = {
	// summary:
	//		A list of widgets on a page.
	// description:
	//		Is an instance of `dijit.WidgetSet`
};
=====*/
dijit.registry= new dijit.WidgetSet();

dijit._widgetTypeCtr = {};

dijit.getUniqueId = function(/*String*/widgetType){
	// summary:
	//		Generates a unique id for a given widgetType

	var id;
	do{
		id = widgetType + "_" +
			(widgetType in dijit._widgetTypeCtr ?
				++dijit._widgetTypeCtr[widgetType] : dijit._widgetTypeCtr[widgetType] = 0);
	}while(dijit.byId(id));
	return dijit._scopeName == "dijit" ? id : dijit._scopeName + "_" + id; // String
};

dijit.findWidgets = function(/*DomNode*/ root){
	// summary:
	//		Search subtree under root returning widgets found.
	//		Doesn't search for nested widgets (ie, widgets inside other widgets).

	var outAry = [];

	function getChildrenHelper(root){
		if (!root)
			return;

		for(var node = root.firstChild; node; node = node.nextSibling){
			if(node.nodeType == 1){
				var widgetId = node.getAttribute("widgetId");
				if(widgetId){
					var widget = dijit.byId(widgetId);
					outAry.push(widget);
				}else{
					getChildrenHelper(node);
				}
			}
		}
	}

	getChildrenHelper(root);
	return outAry;
};

dijit._destroyAll = function(){
	// summary:
	//		Code to destroy all widgets and do other cleanup on page unload

	// Clean up focus manager lingering references to widgets and nodes
	dijit._curFocus = null;
	dijit._prevFocus = null;
	dijit._activeStack = [];

	// Destroy all the widgets, top down
	dojo.forEach(dijit.findWidgets(dojo.body()), function(widget){
		// Avoid double destroy of widgets like Menu that are attached to <body>
		// even though they are logically children of other widgets.
		if(!widget._destroyed){
			if(widget.destroyRecursive){
				widget.destroyRecursive();
			}else if(widget.destroy){
				widget.destroy();
			}
		}
	});
};

if(dojo.isIE){
	// Only run _destroyAll() for IE because we think it's only necessary in that case,
	// and because it causes problems on FF.  See bug #3531 for details.
	dojo.addOnWindowUnload(function(){
		dijit._destroyAll();
	});
}

dijit.byId = function(/*String|Widget*/id){
	// summary:
	//		Returns a widget by it's id, or if passed a widget, no-op (like dojo.byId())
	return typeof id == "string" ? dijit.registry._hash[id] : id; // dijit._Widget
};

dijit.byNode = function(/* DOMNode */ node){
	// summary:
	//		Returns the widget corresponding to the given DOMNode
	return dijit.registry.byId(node.getAttribute("widgetId")); // dijit._Widget
};

dijit.getEnclosingWidget = function(/* DOMNode */ node){
	// summary:
	//		Returns the widget whose DOM tree contains the specified DOMNode, or null if
	//		the node is not contained within the DOM tree of any widget
	while(node){
		var id = node.getAttribute && node.getAttribute("widgetId");
		if(id){
			return dijit.byId(id);
		}
		node = node.parentNode;
	}
	return null;
};

dijit._isElementShown = function(/*Element*/elem){
	var style = dojo.style(elem);
	return (style.visibility != "hidden")
		&& (style.visibility != "collapsed")
		&& (style.display != "none")
		&& (dojo.attr(elem, "type") != "hidden");
}

dijit.isTabNavigable = function(/*Element*/elem){
	// summary:
	//		Tests if an element is tab-navigable

	// TODO: convert (and rename method) to return effectivite tabIndex; will save time in _getTabNavigable()
	if(dojo.attr(elem, "disabled")){
		return false;
	}else if(dojo.hasAttr(elem, "tabIndex")){
		// Explicit tab index setting
		return dojo.attr(elem, "tabIndex") >= 0; // boolean
	}else{
		// No explicit tabIndex setting, need to investigate node type
		switch(elem.nodeName.toLowerCase()){
			case "a":
				// An <a> w/out a tabindex is only navigable if it has an href
				return dojo.hasAttr(elem, "href");
			case "area":
			case "button":
			case "input":
			case "object":
			case "select":
			case "textarea":
				// These are navigable by default
				return true;
			case "iframe":
				// If it's an editor <iframe> then it's tab navigable.
				if(dojo.isMoz){
					return elem.contentDocument.designMode == "on";
				}else if(dojo.isWebKit){
					var doc = elem.contentDocument,
						body = doc && doc.body;
					return body && body.contentEditable == 'true';
				}else{
					// contentWindow.document isn't accessible within IE7/8
					// if the iframe.src points to a foreign url and this
					// page contains an element, that could get focus
					try{
						doc = elem.contentWindow.document;
						body = doc && doc.body;
						return body && body.firstChild && body.firstChild.contentEditable == 'true';
					}catch(e){
						return false;
					}
				}
			default:
				return elem.contentEditable == 'true';
		}
	}
};

dijit._getTabNavigable = function(/*DOMNode*/root){
	// summary:
	//		Finds descendants of the specified root node.
	//
	// description:
	//		Finds the following descendants of the specified root node:
	//		* the first tab-navigable element in document order
	//		  without a tabIndex or with tabIndex="0"
	//		* the last tab-navigable element in document order
	//		  without a tabIndex or with tabIndex="0"
	//		* the first element in document order with the lowest
	//		  positive tabIndex value
	//		* the last element in document order with the highest
	//		  positive tabIndex value
	var first, last, lowest, lowestTabindex, highest, highestTabindex;
	var walkTree = function(/*DOMNode*/parent){
		dojo.query("> *", parent).forEach(function(child){
			var isShown = dijit._isElementShown(child);
			if(isShown && dijit.isTabNavigable(child)){
				var tabindex = dojo.attr(child, "tabIndex");
				if(!dojo.hasAttr(child, "tabIndex") || tabindex == 0){
					if(!first){ first = child; }
					last = child;
				}else if(tabindex > 0){
					if(!lowest || tabindex < lowestTabindex){
						lowestTabindex = tabindex;
						lowest = child;
					}
					if(!highest || tabindex >= highestTabindex){
						highestTabindex = tabindex;
						highest = child;
					}
				}
			}
			if(isShown && child.nodeName.toUpperCase() != 'SELECT'){ walkTree(child) }
		});
	};
	if(dijit._isElementShown(root)){ walkTree(root) }
	return { first: first, last: last, lowest: lowest, highest: highest };
}
dijit.getFirstInTabbingOrder = function(/*String|DOMNode*/root){
	// summary:
	//		Finds the descendant of the specified root node
	//		that is first in the tabbing order
	var elems = dijit._getTabNavigable(dojo.byId(root));
	return elems.lowest ? elems.lowest : elems.first; // DomNode
};

dijit.getLastInTabbingOrder = function(/*String|DOMNode*/root){
	// summary:
	//		Finds the descendant of the specified root node
	//		that is last in the tabbing order
	var elems = dijit._getTabNavigable(dojo.byId(root));
	return elems.last ? elems.last : elems.highest; // DomNode
};

/*=====
dojo.mixin(dijit, {
	// defaultDuration: Integer
	//		The default animation speed (in ms) to use for all Dijit
	//		transitional animations, unless otherwise specified
	//		on a per-instance basis. Defaults to 200, overrided by
	//		`djConfig.defaultDuration`
	defaultDuration: 300
});
=====*/

dijit.defaultDuration = dojo.config["defaultDuration"] || 200;

}

if(!dojo._hasResource["dijit._base.focus"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["dijit._base.focus"] = true;
dojo.provide("dijit._base.focus");

	// for dijit.isTabNavigable()

// summary:
//		These functions are used to query or set the focus and selection.
//
//		Also, they trace when widgets become activated/deactivated,
//		so that the widget can fire _onFocus/_onBlur events.
//		"Active" here means something similar to "focused", but
//		"focus" isn't quite the right word because we keep track of
//		a whole stack of "active" widgets.  Example: ComboButton --> Menu -->
//		MenuItem.  The onBlur event for ComboButton doesn't fire due to focusing
//		on the Menu or a MenuItem, since they are considered part of the
//		ComboButton widget.  It only happens when focus is shifted
//		somewhere completely different.

dojo.mixin(dijit, {
	// _curFocus: DomNode
	//		Currently focused item on screen
	_curFocus: null,

	// _prevFocus: DomNode
	//		Previously focused item on screen
	_prevFocus: null,

	isCollapsed: function(){
		// summary:
		//		Returns true if there is no text selected
		return dijit.getBookmark().isCollapsed;
	},

	getBookmark: function(){
		// summary:
		//		Retrieves a bookmark that can be used with moveToBookmark to return to the same range
		var bm, rg, tg, sel = dojo.doc.selection, cf = dijit._curFocus;

		if(dojo.global.getSelection){
			//W3C Range API for selections.
			sel = dojo.global.getSelection();
			if(sel){
				if(sel.isCollapsed){
					tg = cf? cf.tagName : "";
					if(tg){
						//Create a fake rangelike item to restore selections.
						tg = tg.toLowerCase();
						if(tg == "textarea" ||
								(tg == "input" && (!cf.type || cf.type.toLowerCase() == "text"))){
							sel = {
								start: cf.selectionStart,
								end: cf.selectionEnd,
								node: cf,
								pRange: true
							};
							return {isCollapsed: (sel.end <= sel.start), mark: sel}; //Object.
						}
					}
					bm = {isCollapsed:true};
				}else{
					rg = sel.getRangeAt(0);
					bm = {isCollapsed: false, mark: rg.cloneRange()};
				}
			}
		}else if(sel){
			// If the current focus was a input of some sort and no selection, don't bother saving
			// a native bookmark.  This is because it causes issues with dialog/page selection restore.
			// So, we need to create psuedo bookmarks to work with.
			tg = cf ? cf.tagName : "";
			tg = tg.toLowerCase();
			if(cf && tg && (tg == "button" || tg == "textarea" || tg == "input")){
				if(sel.type && sel.type.toLowerCase() == "none"){
					return {
						isCollapsed: true,
						mark: null
					}
				}else{
					rg = sel.createRange();
					return {
						isCollapsed: rg.text && rg.text.length?false:true,
						mark: {
							range: rg,
							pRange: true
						}
					};
				}
			}
			bm = {};

			//'IE' way for selections.
			try{
				// createRange() throws exception when dojo in iframe
				//and nothing selected, see #9632
				rg = sel.createRange();
				bm.isCollapsed = !(sel.type == 'Text' ? rg.htmlText.length : rg.length);
			}catch(e){
				bm.isCollapsed = true;
				return bm;
			}
			if(sel.type.toUpperCase() == 'CONTROL'){
				if(rg.length){
					bm.mark=[];
					var i=0,len=rg.length;
					while(i<len){
						bm.mark.push(rg.item(i++));
					}
				}else{
					bm.isCollapsed = true;
					bm.mark = null;
				}
			}else{
				bm.mark = rg.getBookmark();
			}
		}else{
			console.warn("No idea how to store the current selection for this browser!");
		}
		return bm; // Object
	},

	moveToBookmark: function(/*Object*/bookmark){
		// summary:
		//		Moves current selection to a bookmark
		// bookmark:
		//		This should be a returned object from dijit.getBookmark()

		var _doc = dojo.doc,
			mark = bookmark.mark;
		if(mark){
			if(dojo.global.getSelection){
				//W3C Rangi API (FF, WebKit, Opera, etc)
				var sel = dojo.global.getSelection();
				if(sel && sel.removeAllRanges){
					if(mark.pRange){
						var r = mark;
						var n = r.node;
						n.selectionStart = r.start;
						n.selectionEnd = r.end;
					}else{
						sel.removeAllRanges();
						sel.addRange(mark);
					}
				}else{
					console.warn("No idea how to restore selection for this browser!");
				}
			}else if(_doc.selection && mark){
				//'IE' way.
				var rg;
				if(mark.pRange){
					rg = mark.range;
				}else if(dojo.isArray(mark)){
					rg = _doc.body.createControlRange();
					//rg.addElement does not have call/apply method, so can not call it directly
					//rg is not available in "range.addElement(item)", so can't use that either
					dojo.forEach(mark, function(n){
						rg.addElement(n);
					});
				}else{
					rg = _doc.body.createTextRange();
					rg.moveToBookmark(mark);
				}
				rg.select();
			}
		}
	},

	getFocus: function(/*Widget?*/ menu, /*Window?*/ openedForWindow){
		// summary:
		//		Called as getFocus(), this returns an Object showing the current focus
		//		and selected text.
		//
		//		Called as getFocus(widget), where widget is a (widget representing) a button
		//		that was just pressed, it returns where focus was before that button
		//		was pressed.   (Pressing the button may have either shifted focus to the button,
		//		or removed focus altogether.)   In this case the selected text is not returned,
		//		since it can't be accurately determined.
		//
		// menu: dijit._Widget or {domNode: DomNode} structure
		//		The button that was just pressed.  If focus has disappeared or moved
		//		to this button, returns the previous focus.  In this case the bookmark
		//		information is already lost, and null is returned.
		//
		// openedForWindow:
		//		iframe in which menu was opened
		//
		// returns:
		//		A handle to restore focus/selection, to be passed to `dijit.focus`
		var node = !dijit._curFocus || (menu && dojo.isDescendant(dijit._curFocus, menu.domNode)) ? dijit._prevFocus : dijit._curFocus;
		return {
			node: node,
			bookmark: (node == dijit._curFocus) && dojo.withGlobal(openedForWindow || dojo.global, dijit.getBookmark),
			openedForWindow: openedForWindow
		}; // Object
	},

	focus: function(/*Object || DomNode */ handle){
		// summary:
		//		Sets the focused node and the selection according to argument.
		//		To set focus to an iframe's content, pass in the iframe itself.
		// handle:
		//		object returned by get(), or a DomNode

		if(!handle){ return; }

		var node = "node" in handle ? handle.node : handle,		// because handle is either DomNode or a composite object
			bookmark = handle.bookmark,
			openedForWindow = handle.openedForWindow,
			collapsed = bookmark ? bookmark.isCollapsed : false;

		// Set the focus
		// Note that for iframe's we need to use the <iframe> to follow the parentNode chain,
		// but we need to set focus to iframe.contentWindow
		if(node){
			var focusNode = (node.tagName.toLowerCase() == "iframe") ? node.contentWindow : node;
			if(focusNode && focusNode.focus){
				try{
					// Gecko throws sometimes if setting focus is impossible,
					// node not displayed or something like that
					focusNode.focus();
				}catch(e){/*quiet*/}
			}
			dijit._onFocusNode(node);
		}

		// set the selection
		// do not need to restore if current selection is not empty
		// (use keyboard to select a menu item) or if previous selection was collapsed
		// as it may cause focus shift (Esp in IE).
		if(bookmark && dojo.withGlobal(openedForWindow || dojo.global, dijit.isCollapsed) && !collapsed){
			if(openedForWindow){
				openedForWindow.focus();
			}
			try{
				dojo.withGlobal(openedForWindow || dojo.global, dijit.moveToBookmark, null, [bookmark]);
			}catch(e2){
				/*squelch IE internal error, see http://trac.dojotoolkit.org/ticket/1984 */
			}
		}
	},

	// _activeStack: dijit._Widget[]
	//		List of currently active widgets (focused widget and it's ancestors)
	_activeStack: [],

	registerIframe: function(/*DomNode*/ iframe){
		// summary:
		//		Registers listeners on the specified iframe so that any click
		//		or focus event on that iframe (or anything in it) is reported
		//		as a focus/click event on the <iframe> itself.
		// description:
		//		Currently only used by editor.
		// returns:
		//		Handle to pass to unregisterIframe()
		return dijit.registerWin(iframe.contentWindow, iframe);
	},

	unregisterIframe: function(/*Object*/ handle){
		// summary:
		//		Unregisters listeners on the specified iframe created by registerIframe.
		//		After calling be sure to delete or null out the handle itself.
		// handle:
		//		Handle returned by registerIframe()

		dijit.unregisterWin(handle);
	},

	registerWin: function(/*Window?*/targetWindow, /*DomNode?*/ effectiveNode){
		// summary:
		//		Registers listeners on the specified window (either the main
		//		window or an iframe's window) to detect when the user has clicked somewhere
		//		or focused somewhere.
		// description:
		//		Users should call registerIframe() instead of this method.
		// targetWindow:
		//		If specified this is the window associated with the iframe,
		//		i.e. iframe.contentWindow.
		// effectiveNode:
		//		If specified, report any focus events inside targetWindow as
		//		an event on effectiveNode, rather than on evt.target.
		// returns:
		//		Handle to pass to unregisterWin()

		// TODO: make this function private in 2.0; Editor/users should call registerIframe(),

		var mousedownListener = function(evt){
			dijit._justMouseDowned = true;
			setTimeout(function(){ dijit._justMouseDowned = false; }, 0);
			dijit._onTouchNode(effectiveNode || evt.target || evt.srcElement, "mouse");
		};
		//dojo.connect(targetWindow, "onscroll", ???);

		// Listen for blur and focus events on targetWindow's document.
		// IIRC, I'm using attachEvent() rather than dojo.connect() because focus/blur events don't bubble
		// through dojo.connect(), and also maybe to catch the focus events early, before onfocus handlers
		// fire.
		// Connect to <html> (rather than document) on IE to avoid memory leaks, but document on other browsers because
		// (at least for FF) the focus event doesn't fire on <html> or <body>.
		var doc = dojo.isIE ? targetWindow.document.documentElement : targetWindow.document;
		if(doc){
			if(dojo.isIE){
				doc.attachEvent('onmousedown', mousedownListener);
				var activateListener = function(evt){
					// IE reports that nodes like <body> have gotten focus, even though they have tabIndex=-1,
					// Should consider those more like a mouse-click than a focus....
					if(evt.srcElement.tagName.toLowerCase() != "#document" &&
						dijit.isTabNavigable(evt.srcElement)){
						dijit._onFocusNode(effectiveNode || evt.srcElement);
					}else{
						dijit._onTouchNode(effectiveNode || evt.srcElement);
					}
				};
				doc.attachEvent('onactivate', activateListener);
				var deactivateListener =  function(evt){
					dijit._onBlurNode(effectiveNode || evt.srcElement);
				};
				doc.attachEvent('ondeactivate', deactivateListener);

				return function(){
					doc.detachEvent('onmousedown', mousedownListener);
					doc.detachEvent('onactivate', activateListener);
					doc.detachEvent('ondeactivate', deactivateListener);
					doc = null;	// prevent memory leak (apparent circular reference via closure)
				};
			}else{
				doc.addEventListener('mousedown', mousedownListener, true);
				var focusListener = function(evt){
					dijit._onFocusNode(effectiveNode || evt.target);
				};
				doc.addEventListener('focus', focusListener, true);
				var blurListener = function(evt){
					dijit._onBlurNode(effectiveNode || evt.target);
				};
				doc.addEventListener('blur', blurListener, true);

				return function(){
					doc.removeEventListener('mousedown', mousedownListener, true);
					doc.removeEventListener('focus', focusListener, true);
					doc.removeEventListener('blur', blurListener, true);
					doc = null;	// prevent memory leak (apparent circular reference via closure)
				};
			}
		}
	},

	unregisterWin: function(/*Handle*/ handle){
		// summary:
		//		Unregisters listeners on the specified window (either the main
		//		window or an iframe's window) according to handle returned from registerWin().
		//		After calling be sure to delete or null out the handle itself.

		// Currently our handle is actually a function
		handle && handle();
	},

	_onBlurNode: function(/*DomNode*/ node){
		// summary:
		// 		Called when focus leaves a node.
		//		Usually ignored, _unless_ it *isn't* follwed by touching another node,
		//		which indicates that we tabbed off the last field on the page,
		//		in which case every widget is marked inactive
		dijit._prevFocus = dijit._curFocus;
		dijit._curFocus = null;

		if(dijit._justMouseDowned){
			// the mouse down caused a new widget to be marked as active; this blur event
			// is coming late, so ignore it.
			return;
		}

		// if the blur event isn't followed by a focus event then mark all widgets as inactive.
		if(dijit._clearActiveWidgetsTimer){
			clearTimeout(dijit._clearActiveWidgetsTimer);
		}
		dijit._clearActiveWidgetsTimer = setTimeout(function(){
			delete dijit._clearActiveWidgetsTimer;
			dijit._setStack([]);
			dijit._prevFocus = null;
		}, 100);
	},

	_onTouchNode: function(/*DomNode*/ node, /*String*/ by){
		// summary:
		//		Callback when node is focused or mouse-downed
		// node:
		//		The node that was touched.
		// by:
		//		"mouse" if the focus/touch was caused by a mouse down event

		// ignore the recent blurNode event
		if(dijit._clearActiveWidgetsTimer){
			clearTimeout(dijit._clearActiveWidgetsTimer);
			delete dijit._clearActiveWidgetsTimer;
		}

		// compute stack of active widgets (ex: ComboButton --> Menu --> MenuItem)
		var newStack=[];
		try{
			while(node){
				var popupParent = dojo.attr(node, "dijitPopupParent");
				if(popupParent){
					node=dijit.byId(popupParent).domNode;
				}else if(node.tagName && node.tagName.toLowerCase() == "body"){
					// is this the root of the document or just the root of an iframe?
					if(node === dojo.body()){
						// node is the root of the main document
						break;
					}
					// otherwise, find the iframe this node refers to (can't access it via parentNode,
					// need to do this trick instead). window.frameElement is supported in IE/FF/Webkit
					node=dijit.getDocumentWindow(node.ownerDocument).frameElement;
				}else{
					var id = node.getAttribute && node.getAttribute("widgetId");
					if(id){
						newStack.unshift(id);
					}
					node=node.parentNode;
				}
			}
		}catch(e){ /* squelch */ }

		dijit._setStack(newStack, by);
	},

	_onFocusNode: function(/*DomNode*/ node){
		// summary:
		//		Callback when node is focused

		if(!node){
			return;
		}

		if(node.nodeType == 9){
			// Ignore focus events on the document itself.  This is here so that
			// (for example) clicking the up/down arrows of a spinner
			// (which don't get focus) won't cause that widget to blur. (FF issue)
			return;
		}

		dijit._onTouchNode(node);

		if(node == dijit._curFocus){ return; }
		if(dijit._curFocus){
			dijit._prevFocus = dijit._curFocus;
		}
		dijit._curFocus = node;
		dojo.publish("focusNode", [node]);
	},

	_setStack: function(/*String[]*/ newStack, /*String*/ by){
		// summary:
		//		The stack of active widgets has changed.  Send out appropriate events and records new stack.
		// newStack:
		//		array of widget id's, starting from the top (outermost) widget
		// by:
		//		"mouse" if the focus/touch was caused by a mouse down event

		var oldStack = dijit._activeStack;
		dijit._activeStack = newStack;

		// compare old stack to new stack to see how many elements they have in common
		for(var nCommon=0; nCommon<Math.min(oldStack.length, newStack.length); nCommon++){
			if(oldStack[nCommon] != newStack[nCommon]){
				break;
			}
		}

		var widget;
		// for all elements that have gone out of focus, send blur event
		for(var i=oldStack.length-1; i>=nCommon; i--){
			widget = dijit.byId(oldStack[i]);
			if(widget){
				widget._focused = false;
				widget._hasBeenBlurred = true;
				if(widget._onBlur){
					widget._onBlur(by);
				}
				if(widget._setStateClass){
					widget._setStateClass();
				}
				dojo.publish("widgetBlur", [widget, by]);
			}
		}

		// for all element that have come into focus, send focus event
		for(i=nCommon; i<newStack.length; i++){
			widget = dijit.byId(newStack[i]);
			if(widget){
				widget._focused = true;
				if(widget._onFocus){
					widget._onFocus(by);
				}
				if(widget._setStateClass){
					widget._setStateClass();
				}
				dojo.publish("widgetFocus", [widget, by]);
			}
		}
	}
});

// register top window and all the iframes it contains
dojo.addOnLoad(function(){
	var handle = dijit.registerWin(window);
	if(dojo.isIE){
		dojo.addOnWindowUnload(function(){
			dijit.unregisterWin(handle);
			handle = null;
		})
	}
});

}

if(!dojo._hasResource["dojo.AdapterRegistry"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["dojo.AdapterRegistry"] = true;
dojo.provide("dojo.AdapterRegistry");

dojo.AdapterRegistry = function(/*Boolean?*/ returnWrappers){
	//	summary:
	//		A registry to make contextual calling/searching easier.
	//	description:
	//		Objects of this class keep list of arrays in the form [name, check,
	//		wrap, directReturn] that are used to determine what the contextual
	//		result of a set of checked arguments is. All check/wrap functions
	//		in this registry should be of the same arity.
	//	example:
	//	|	// create a new registry
	//	|	var reg = new dojo.AdapterRegistry();
	//	|	reg.register("handleString",
	//	|		dojo.isString,
	//	|		function(str){
	//	|			// do something with the string here
	//	|		}
	//	|	);
	//	|	reg.register("handleArr",
	//	|		dojo.isArray,
	//	|		function(arr){
	//	|			// do something with the array here
	//	|		}
	//	|	);
	//	|
	//	|	// now we can pass reg.match() *either* an array or a string and
	//	|	// the value we pass will get handled by the right function
	//	|	reg.match("someValue"); // will call the first function
	//	|	reg.match(["someValue"]); // will call the second

	this.pairs = [];
	this.returnWrappers = returnWrappers || false; // Boolean
}

dojo.extend(dojo.AdapterRegistry, {
	register: function(/*String*/ name, /*Function*/ check, /*Function*/ wrap, /*Boolean?*/ directReturn, /*Boolean?*/ override){
		//	summary: 
		//		register a check function to determine if the wrap function or
		//		object gets selected
		//	name:
		//		a way to identify this matcher.
		//	check:
		//		a function that arguments are passed to from the adapter's
		//		match() function.  The check function should return true if the
		//		given arguments are appropriate for the wrap function.
		//	directReturn:
		//		If directReturn is true, the value passed in for wrap will be
		//		returned instead of being called. Alternately, the
		//		AdapterRegistry can be set globally to "return not call" using
		//		the returnWrappers property. Either way, this behavior allows
		//		the registry to act as a "search" function instead of a
		//		function interception library.
		//	override:
		//		If override is given and true, the check function will be given
		//		highest priority. Otherwise, it will be the lowest priority
		//		adapter.
		this.pairs[((override) ? "unshift" : "push")]([name, check, wrap, directReturn]);
	},

	match: function(/* ... */){
		// summary:
		//		Find an adapter for the given arguments. If no suitable adapter
		//		is found, throws an exception. match() accepts any number of
		//		arguments, all of which are passed to all matching functions
		//		from the registered pairs.
		for(var i = 0; i < this.pairs.length; i++){
			var pair = this.pairs[i];
			if(pair[1].apply(this, arguments)){
				if((pair[3])||(this.returnWrappers)){
					return pair[2];
				}else{
					return pair[2].apply(this, arguments);
				}
			}
		}
		throw new Error("No match found");
	},

	unregister: function(name){
		// summary: Remove a named adapter from the registry

		// FIXME: this is kind of a dumb way to handle this. On a large
		// registry this will be slow-ish and we can use the name as a lookup
		// should we choose to trade memory for speed.
		for(var i = 0; i < this.pairs.length; i++){
			var pair = this.pairs[i];
			if(pair[0] == name){
				this.pairs.splice(i, 1);
				return true;
			}
		}
		return false;
	}
});

}

if(!dojo._hasResource["dijit._base.place"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["dijit._base.place"] = true;
dojo.provide("dijit._base.place");



// ported from dojo.html.util

dijit.getViewport = function(){
	// summary:
	//		Returns the dimensions and scroll position of the viewable area of a browser window

	var scrollRoot = (dojo.doc.compatMode == 'BackCompat')? dojo.body() : dojo.doc.documentElement;

	// get scroll position
	var scroll = dojo._docScroll(); // scrollRoot.scrollTop/Left should work
	return { w: scrollRoot.clientWidth, h: scrollRoot.clientHeight, l: scroll.x, t: scroll.y };
};

/*=====
dijit.__Position = function(){
	// x: Integer
	//		horizontal coordinate in pixels, relative to document body
	// y: Integer
	//		vertical coordinate in pixels, relative to document body

	thix.x = x;
	this.y = y;
}
=====*/


dijit.placeOnScreen = function(
	/* DomNode */			node,
	/* dijit.__Position */	pos,
	/* String[] */			corners,
	/* dijit.__Position? */	padding){
	// summary:
	//		Positions one of the node's corners at specified position
	//		such that node is fully visible in viewport.
	// description:
	//		NOTE: node is assumed to be absolutely or relatively positioned.
	//	pos:
	//		Object like {x: 10, y: 20}
	//	corners:
	//		Array of Strings representing order to try corners in, like ["TR", "BL"].
	//		Possible values are:
	//			* "BL" - bottom left
	//			* "BR" - bottom right
	//			* "TL" - top left
	//			* "TR" - top right
	//	padding:
	//		set padding to put some buffer around the element you want to position.
	// example:
	//		Try to place node's top right corner at (10,20).
	//		If that makes node go (partially) off screen, then try placing
	//		bottom left corner at (10,20).
	//	|	placeOnScreen(node, {x: 10, y: 20}, ["TR", "BL"])

	var choices = dojo.map(corners, function(corner){
		var c = { corner: corner, pos: {x:pos.x,y:pos.y} };
		if(padding){
			c.pos.x += corner.charAt(1) == 'L' ? padding.x : -padding.x;
			c.pos.y += corner.charAt(0) == 'T' ? padding.y : -padding.y;
		}
		return c;
	});

	return dijit._place(node, choices);
}

dijit._place = function(/*DomNode*/ node, /* Array */ choices, /* Function */ layoutNode){
	// summary:
	//		Given a list of spots to put node, put it at the first spot where it fits,
	//		of if it doesn't fit anywhere then the place with the least overflow
	// choices: Array
	//		Array of elements like: {corner: 'TL', pos: {x: 10, y: 20} }
	//		Above example says to put the top-left corner of the node at (10,20)
	// layoutNode: Function(node, aroundNodeCorner, nodeCorner)
	//		for things like tooltip, they are displayed differently (and have different dimensions)
	//		based on their orientation relative to the parent.   This adjusts the popup based on orientation.

	// get {x: 10, y: 10, w: 100, h:100} type obj representing position of
	// viewport over document
	var view = dijit.getViewport();

	// This won't work if the node is inside a <div style="position: relative">,
	// so reattach it to dojo.doc.body.   (Otherwise, the positioning will be wrong
	// and also it might get cutoff)
	if(!node.parentNode || String(node.parentNode.tagName).toLowerCase() != "body"){
		dojo.body().appendChild(node);
	}

	var best = null;
	dojo.some(choices, function(choice){
		var corner = choice.corner;
		var pos = choice.pos;

		// configure node to be displayed in given position relative to button
		// (need to do this in order to get an accurate size for the node, because
		// a tooltips size changes based on position, due to triangle)
		if(layoutNode){
			layoutNode(node, choice.aroundCorner, corner);
		}

		// get node's size
		var style = node.style;
		var oldDisplay = style.display;
		var oldVis = style.visibility;
		style.visibility = "hidden";
		style.display = "";
		var mb = dojo.marginBox(node);
		style.display = oldDisplay;
		style.visibility = oldVis;

		// coordinates and size of node with specified corner placed at pos,
		// and clipped by viewport
		var startX = Math.max(view.l, corner.charAt(1) == 'L' ? pos.x : (pos.x - mb.w)),
			startY = Math.max(view.t, corner.charAt(0) == 'T' ? pos.y : (pos.y - mb.h)),
			endX = Math.min(view.l + view.w, corner.charAt(1) == 'L' ? (startX + mb.w) : pos.x),
			endY = Math.min(view.t + view.h, corner.charAt(0) == 'T' ? (startY + mb.h) : pos.y),
			width = endX - startX,
			height = endY - startY,
			overflow = (mb.w - width) + (mb.h - height);

		if(best == null || overflow < best.overflow){
			best = {
				corner: corner,
				aroundCorner: choice.aroundCorner,
				x: startX,
				y: startY,
				w: width,
				h: height,
				overflow: overflow
			};
		}
		return !overflow;
	});

	node.style.left = best.x + "px";
	node.style.top = best.y + "px";
	if(best.overflow && layoutNode){
		layoutNode(node, best.aroundCorner, best.corner);
	}
	return best;
}

dijit.placeOnScreenAroundNode = function(
	/* DomNode */		node,
	/* DomNode */		aroundNode,
	/* Object */		aroundCorners,
	/* Function? */		layoutNode){

	// summary:
	//		Position node adjacent or kitty-corner to aroundNode
	//		such that it's fully visible in viewport.
	//
	// description:
	//		Place node such that corner of node touches a corner of
	//		aroundNode, and that node is fully visible.
	//
	// aroundCorners:
	//		Ordered list of pairs of corners to try matching up.
	//		Each pair of corners is represented as a key/value in the hash,
	//		where the key corresponds to the aroundNode's corner, and
	//		the value corresponds to the node's corner:
	//
	//	|	{ aroundNodeCorner1: nodeCorner1, aroundNodeCorner2: nodeCorner2, ...}
	//
	//		The following strings are used to represent the four corners:
	//			* "BL" - bottom left
	//			* "BR" - bottom right
	//			* "TL" - top left
	//			* "TR" - top right
	//
	// layoutNode: Function(node, aroundNodeCorner, nodeCorner)
	//		For things like tooltip, they are displayed differently (and have different dimensions)
	//		based on their orientation relative to the parent.   This adjusts the popup based on orientation.
	//
	// example:
	//	|	dijit.placeOnScreenAroundNode(node, aroundNode, {'BL':'TL', 'TR':'BR'});
	//		This will try to position node such that node's top-left corner is at the same position
	//		as the bottom left corner of the aroundNode (ie, put node below
	//		aroundNode, with left edges aligned).  If that fails it will try to put
	// 		the bottom-right corner of node where the top right corner of aroundNode is
	//		(ie, put node above aroundNode, with right edges aligned)
	//

	// get coordinates of aroundNode
	aroundNode = dojo.byId(aroundNode);
	var oldDisplay = aroundNode.style.display;
	aroundNode.style.display="";
	// #3172: use the slightly tighter border box instead of marginBox
	var aroundNodePos = dojo.position(aroundNode, true);
	aroundNode.style.display=oldDisplay;

	// place the node around the calculated rectangle
	return dijit._placeOnScreenAroundRect(node,
		aroundNodePos.x, aroundNodePos.y, aroundNodePos.w, aroundNodePos.h,	// rectangle
		aroundCorners, layoutNode);
};

/*=====
dijit.__Rectangle = function(){
	// x: Integer
	//		horizontal offset in pixels, relative to document body
	// y: Integer
	//		vertical offset in pixels, relative to document body
	// width: Integer
	//		width in pixels
	// height: Integer
	//		height in pixels

	this.x = x;
	this.y = y;
	this.width = width;
	this.height = height;
}
=====*/


dijit.placeOnScreenAroundRectangle = function(
	/* DomNode */			node,
	/* dijit.__Rectangle */	aroundRect,
	/* Object */			aroundCorners,
	/* Function */			layoutNode){

	// summary:
	//		Like dijit.placeOnScreenAroundNode(), except that the "around"
	//		parameter is an arbitrary rectangle on the screen (x, y, width, height)
	//		instead of a dom node.

	return dijit._placeOnScreenAroundRect(node,
		aroundRect.x, aroundRect.y, aroundRect.width, aroundRect.height,	// rectangle
		aroundCorners, layoutNode);
};

dijit._placeOnScreenAroundRect = function(
	/* DomNode */		node,
	/* Number */		x,
	/* Number */		y,
	/* Number */		width,
	/* Number */		height,
	/* Object */		aroundCorners,
	/* Function */		layoutNode){

	// summary:
	//		Like dijit.placeOnScreenAroundNode(), except it accepts coordinates
	//		of a rectangle to place node adjacent to.

	// TODO: combine with placeOnScreenAroundRectangle()

	// Generate list of possible positions for node
	var choices = [];
	for(var nodeCorner in aroundCorners){
		choices.push( {
			aroundCorner: nodeCorner,
			corner: aroundCorners[nodeCorner],
			pos: {
				x: x + (nodeCorner.charAt(1) == 'L' ? 0 : width),
				y: y + (nodeCorner.charAt(0) == 'T' ? 0 : height)
			}
		});
	}

	return dijit._place(node, choices, layoutNode);
};

dijit.placementRegistry= new dojo.AdapterRegistry();
dijit.placementRegistry.register("node",
	function(n, x){
		return typeof x == "object" &&
			typeof x.offsetWidth != "undefined" && typeof x.offsetHeight != "undefined";
	},
	dijit.placeOnScreenAroundNode);
dijit.placementRegistry.register("rect",
	function(n, x){
		return typeof x == "object" &&
			"x" in x && "y" in x && "width" in x && "height" in x;
	},
	dijit.placeOnScreenAroundRectangle);

dijit.placeOnScreenAroundElement = function(
	/* DomNode */		node,
	/* Object */		aroundElement,
	/* Object */		aroundCorners,
	/* Function */		layoutNode){

	// summary:
	//		Like dijit.placeOnScreenAroundNode(), except it accepts an arbitrary object
	//		for the "around" argument and finds a proper processor to place a node.

	return dijit.placementRegistry.match.apply(dijit.placementRegistry, arguments);
};

dijit.getPopupAlignment = function(/*Array*/ position, /*Boolean*/ leftToRight){
	// summary:
	//		Transforms the passed array of preferred positions into a format suitable for passing as the aroundCorners argument to dijit.placeOnScreenAroundElement.
	//
	// position: String[]
	//		This variable controls the position of the drop down.
	//		It's an array of strings with the following values:
	//
	//			* before: places drop down to the left of the target node/widget, or to the right in
	//			  the case of RTL scripts like Hebrew and Arabic
	//			* after: places drop down to the right of the target node/widget, or to the left in
	//			  the case of RTL scripts like Hebrew and Arabic
	//			* above: drop down goes above target node
	//			* below: drop down goes below target node
	//
	//		The list is positions is tried, in order, until a position is found where the drop down fits
	//		within the viewport.
	//
	// leftToRight: Boolean
	//		Whether the popup will be displaying in leftToRight mode.
	//
	var align = {};
	dojo.forEach(position, function(pos){
		switch(pos){
			case "after":
				align[leftToRight ? "BR" : "BL"] = leftToRight ? "BL" : "BR";
				break;
			case "before":
				align[leftToRight ? "BL" : "BR"] = leftToRight ? "BR" : "BL";
				break;
			case "below":
				// first try to align left borders, next try to align right borders (or reverse for RTL mode)
				align[leftToRight ? "BL" : "BR"] = leftToRight ? "TL" : "TR";
				align[leftToRight ? "BR" : "BL"] = leftToRight ? "TR" : "TL";
				break;
			case "above":
			default:
				// first try to align left borders, next try to align right borders (or reverse for RTL mode)
				align[leftToRight ? "TL" : "TR"] = leftToRight ? "BL" : "BR";
				align[leftToRight ? "TR" : "TL"] = leftToRight ? "BR" : "BL";
				break;
		}
	});
	return align;
};
dijit.getPopupAroundAlignment = function(/*Array*/ position, /*Boolean*/ leftToRight){
	// summary:
	//		Transforms the passed array of preferred positions into a format suitable for passing as the aroundCorners argument to dijit.placeOnScreenAroundElement.
	//
	// position: String[]
	//		This variable controls the position of the drop down.
	//		It's an array of strings with the following values:
	//
	//			* before: places drop down to the left of the target node/widget, or to the right in
	//			  the case of RTL scripts like Hebrew and Arabic
	//			* after: places drop down to the right of the target node/widget, or to the left in
	//			  the case of RTL scripts like Hebrew and Arabic
	//			* above: drop down goes above target node
	//			* below: drop down goes below target node
	//
	//		The list is positions is tried, in order, until a position is found where the drop down fits
	//		within the viewport.
	//
	// leftToRight: Boolean
	//		Whether the popup will be displaying in leftToRight mode.
	//
	var align = {};
	dojo.forEach(position, function(pos){
		switch(pos){
			case "after":
				align[leftToRight ? "BR" : "BL"] = leftToRight ? "BL" : "BR";
				break;
			case "before":
				align[leftToRight ? "BL" : "BR"] = leftToRight ? "BR" : "BL";
				break;
			case "below":
				// first try to align left borders, next try to align right borders (or reverse for RTL mode)
				align[leftToRight ? "BL" : "BR"] = leftToRight ? "TL" : "TR";
				align[leftToRight ? "BR" : "BL"] = leftToRight ? "TR" : "TL";
				break;
			case "above":
			default:
				// first try to align left borders, next try to align right borders (or reverse for RTL mode)
				align[leftToRight ? "TL" : "TR"] = leftToRight ? "BL" : "BR";
				align[leftToRight ? "TR" : "TL"] = leftToRight ? "BR" : "BL";
				break;
		}
	});
	return align;
};

}

if(!dojo._hasResource["dijit._base.window"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["dijit._base.window"] = true;
dojo.provide("dijit._base.window");

// TODO: remove this in 2.0, it's not used anymore, or at least not internally

dijit.getDocumentWindow = function(doc){
	// summary:
	// 		Get window object associated with document doc

	// In some IE versions (at least 6.0), document.parentWindow does not return a
	// reference to the real window object (maybe a copy), so we must fix it as well
	// We use IE specific execScript to attach the real window reference to
	// document._parentWindow for later use
	if(dojo.isIE && window !== document.parentWindow && !doc._parentWindow){
		/*
		In IE 6, only the variable "window" can be used to connect events (others
		may be only copies).
		*/
		doc.parentWindow.execScript("document._parentWindow = window;", "Javascript");
		//to prevent memory leak, unset it after use
		//another possibility is to add an onUnload handler which seems overkill to me (liucougar)
		var win = doc._parentWindow;
		doc._parentWindow = null;
		return win;	//	Window
	}

	return doc._parentWindow || doc.parentWindow || doc.defaultView;	//	Window
}

}

if(!dojo._hasResource["dijit._base.popup"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["dijit._base.popup"] = true;
dojo.provide("dijit._base.popup");





dijit.popup = new function(){
	// summary:
	//		This class is used to show/hide widgets as popups.

	var stack = [],
		beginZIndex=1000,
		idGen = 1;

	this.moveOffScreen = function(/*DomNode*/ node){
		// summary:
		//		Moves node offscreen without hiding it (so that all layout widgets included 
		//		in this node can still layout properly)
		//
		// description:
		//		Attaches node to dojo.doc.body, and
		//		positions it off screen, but not display:none, so that
		//		the widget doesn't appear in the page flow and/or cause a blank
		//		area at the bottom of the viewport (making scrollbar longer), but
		//		initialization of contained widgets works correctly

		var s = node.style;
		s.visibility = "hidden";	// so TAB key doesn't navigate to hidden popup
		s.position = "absolute";
		s.top = "-9999px";
		if(s.display == "none"){
			s.display="";
		}
		dojo.body().appendChild(node);
	};

/*=====
dijit.popup.__OpenArgs = function(){
	// popup: Widget
	//		widget to display
	// parent: Widget
	//		the button etc. that is displaying this popup
	// around: DomNode
	//		DOM node (typically a button); place popup relative to this node.  (Specify this *or* "x" and "y" parameters.)
	// x: Integer
	//		Absolute horizontal position (in pixels) to place node at.  (Specify this *or* "around" parameter.)
	// y: Integer
	//		Absolute vertical position (in pixels) to place node at.  (Specity this *or* "around" parameter.)
	// orient: Object || String
	//		When the around parameter is specified, orient should be an
	//		ordered list of tuples of the form (around-node-corner, popup-node-corner).
	//		dijit.popup.open() tries to position the popup according to each tuple in the list, in order,
	//		until the popup appears fully within the viewport.
	//
	//		The default value is {BL:'TL', TL:'BL'}, which represents a list of two tuples:
	//			1. (BL, TL)
	//			2. (TL, BL)
	//		where BL means "bottom left" and "TL" means "top left".
	//		So by default, it first tries putting the popup below the around node, left-aligning them,
	//		and then tries to put it above the around node, still left-aligning them.   Note that the
	//		default is horizontally reversed when in RTL mode.
	//
	//		When an (x,y) position is specified rather than an around node, orient is either
	//		"R" or "L".  R (for right) means that it tries to put the popup to the right of the mouse,
	//		specifically positioning the popup's top-right corner at the mouse position, and if that doesn't
	//		fit in the viewport, then it tries, in order, the bottom-right corner, the top left corner,
	//		and the top-right corner.
	// onCancel: Function
	//		callback when user has canceled the popup by
	//			1. hitting ESC or
	//			2. by using the popup widget's proprietary cancel mechanism (like a cancel button in a dialog);
	//			   i.e. whenever popupWidget.onCancel() is called, args.onCancel is called
	// onClose: Function
	//		callback whenever this popup is closed
	// onExecute: Function
	//		callback when user "executed" on the popup/sub-popup by selecting a menu choice, etc. (top menu only)
	// padding: dijit.__Position
	//		adding a buffer around the opening position. This is only useful when around is not set.
	this.popup = popup;
	this.parent = parent;
	this.around = around;
	this.x = x;
	this.y = y;
	this.orient = orient;
	this.onCancel = onCancel;
	this.onClose = onClose;
	this.onExecute = onExecute;
	this.padding = padding;
}
=====*/

	// Compute the closest ancestor popup that's *not* a child of another popup.
	// Ex: For a TooltipDialog with a button that spawns a tree of menus, find the popup of the button.
	var getTopPopup = function(){
		for(var pi=stack.length-1; pi > 0 && stack[pi].parent === stack[pi-1].widget; pi--){
			/* do nothing, just trying to get right value for pi */
		}
		return stack[pi];
	};

	var wrappers=[];
	this.open = function(/*dijit.popup.__OpenArgs*/ args){
		// summary:
		//		Popup the widget at the specified position
		//
		// example:
		//		opening at the mouse position
		//		|		dijit.popup.open({popup: menuWidget, x: evt.pageX, y: evt.pageY});
		//
		// example:
		//		opening the widget as a dropdown
		//		|		dijit.popup.open({parent: this, popup: menuWidget, around: this.domNode, onClose: function(){...}});
		//
		//		Note that whatever widget called dijit.popup.open() should also listen to its own _onBlur callback
		//		(fired from _base/focus.js) to know that focus has moved somewhere else and thus the popup should be closed.

		var widget = args.popup,
			orient = args.orient || (
				dojo._isBodyLtr() ?
				{'BL':'TL', 'BR':'TR', 'TL':'BL', 'TR':'BR'} :
				{'BR':'TR', 'BL':'TL', 'TR':'BR', 'TL':'BL'}
			),
			around = args.around,
			id = (args.around && args.around.id) ? (args.around.id+"_dropdown") : ("popup_"+idGen++);

		// make wrapper div to hold widget and possibly hold iframe behind it.
		// we can't attach the iframe as a child of the widget.domNode because
		// widget.domNode might be a <table>, <ul>, etc.

		var wrapperobj = wrappers.pop(), wrapper, iframe;
		if(!wrapperobj){
			wrapper = dojo.create("div",{
				"class":"dijitPopup"
			}, dojo.body());
			dijit.setWaiRole(wrapper, "presentation");
		}else{
			// recycled a old wrapper, so that we don't need to reattach the iframe
			// which is slow even if the iframe is empty, see #10167
			wrapper = wrapperobj[0];
			iframe = wrapperobj[1];
		}

		dojo.attr(wrapper,{
			id: id,
			style:{
				zIndex: beginZIndex + stack.length,
				visibility:"hidden",
				// prevent transient scrollbar causing misalign (#5776), and initial flash in upper left (#10111)
				top: "-9999px"
			},
			dijitPopupParent: args.parent ? args.parent.id : ""
		});

		var s = widget.domNode.style;
		s.display = "";
		s.visibility = "";
		s.position = "";
		s.top = "0px";
		wrapper.appendChild(widget.domNode);

		if(!iframe){
			iframe = new dijit.BackgroundIframe(wrapper);
		}else{
			iframe.resize(wrapper)
		}

		// position the wrapper node
		var best = around ?
			dijit.placeOnScreenAroundElement(wrapper, around, orient, widget.orient ? dojo.hitch(widget, "orient") : null) :
			dijit.placeOnScreen(wrapper, args, orient == 'R' ? ['TR','BR','TL','BL'] : ['TL','BL','TR','BR'], args.padding);

		wrapper.style.visibility = "visible";
		// TODO: use effects to fade in wrapper

		var handlers = [];

		// provide default escape and tab key handling
		// (this will work for any widget, not just menu)
		handlers.push(dojo.connect(wrapper, "onkeypress", this, function(evt){
			if(evt.charOrCode == dojo.keys.ESCAPE && args.onCancel){
				dojo.stopEvent(evt);
				args.onCancel();
			}else if(evt.charOrCode === dojo.keys.TAB){
				dojo.stopEvent(evt);
				var topPopup = getTopPopup();
				if(topPopup && topPopup.onCancel){
					topPopup.onCancel();
				}
			}
		}));

		// watch for cancel/execute events on the popup and notify the caller
		// (for a menu, "execute" means clicking an item)
		if(widget.onCancel){
			handlers.push(dojo.connect(widget, "onCancel", args.onCancel));
		}

		handlers.push(dojo.connect(widget, widget.onExecute ? "onExecute" : "onChange", function(){
			var topPopup = getTopPopup();
			if(topPopup && topPopup.onExecute){
				topPopup.onExecute();
			}
		}));

		stack.push({
			wrapper: wrapper,
			iframe: iframe,
			widget: widget,
			parent: args.parent,
			onExecute: args.onExecute,
			onCancel: args.onCancel,
 			onClose: args.onClose,
			handlers: handlers
		});

		if(widget.onOpen){
			// TODO: in 2.0 standardize onShow() (used by StackContainer) and onOpen() (used here)
			widget.onOpen(best);
		}

		return best;
	};

	this.close = function(/*dijit._Widget*/ popup){
		// summary:
		//		Close specified popup and any popups that it parented
		
		// Basically work backwards from the top of the stack closing popups
		// until we hit the specified popup, but IIRC there was some issue where closing
		// a popup would cause others to close too.  Thus if we are trying to close B in [A,B,C]
		// closing C might close B indirectly and then the while() condition will run where stack==[A]...
		// so the while condition is constructed defensively.
		while(dojo.some(stack, function(elem){return elem.widget == popup;})){
			var top = stack.pop(),
				wrapper = top.wrapper,
				iframe = top.iframe,
				widget = top.widget,
				onClose = top.onClose;

			if(widget.onClose){
				// TODO: in 2.0 standardize onHide() (used by StackContainer) and onClose() (used here)
				widget.onClose();
			}
			dojo.forEach(top.handlers, dojo.disconnect);

			// Move the widget offscreen, unless it has already been destroyed in above onClose() etc.
			if(widget && widget.domNode){
				this.moveOffScreen(widget.domNode);
			}
                        
			// recycle the wrapper plus iframe, so we prevent reattaching iframe everytime an popup opens
			// don't use moveOffScreen which would also reattach the wrapper to body, which causes reloading of iframe
			wrapper.style.top = "-9999px";
			wrapper.style.visibility = "hidden";
			wrappers.push([wrapper,iframe]);

			if(onClose){
				onClose();
			}
		}
	};
}();

dijit._frames = new function(){
	// summary:
	//		cache of iframes
	var queue = [];

	this.pop = function(){
		var iframe;
		if(queue.length){
			iframe = queue.pop();
			iframe.style.display="";
		}else{
			if(dojo.isIE){
				var burl = dojo.config["dojoBlankHtmlUrl"] || (dojo.moduleUrl("dojo", "resources/blank.html")+"") || "javascript:\"\"";
				var html="<iframe src='" + burl + "'"
					+ " style='position: absolute; left: 0px; top: 0px;"
					+ "z-index: -1; filter:Alpha(Opacity=\"0\");'>";
				iframe = dojo.doc.createElement(html);
			}else{
			 	iframe = dojo.create("iframe");
				iframe.src = 'javascript:""';
				iframe.className = "dijitBackgroundIframe";
				dojo.style(iframe, "opacity", 0.1);
			}
			iframe.tabIndex = -1; // Magic to prevent iframe from getting focus on tab keypress - as style didnt work.
		}
		return iframe;
	};

	this.push = function(iframe){
		iframe.style.display="none";
		queue.push(iframe);
	}
}();


dijit.BackgroundIframe = function(/* DomNode */node){
	// summary:
	//		For IE/FF z-index schenanigans. id attribute is required.
	//
	// description:
	//		new dijit.BackgroundIframe(node)
	//			Makes a background iframe as a child of node, that fills
	//			area (and position) of node

	if(!node.id){ throw new Error("no id"); }
	if(dojo.isIE || dojo.isMoz){
		var iframe = dijit._frames.pop();
		node.appendChild(iframe);
		if(dojo.isIE<7){
			this.resize(node);
			this._conn = dojo.connect(node, 'onresize', this, function(){
				this.resize(node);
			});
		}else{
			dojo.style(iframe, {
				width: '100%',
				height: '100%'
			});
		}
		this.iframe = iframe;
	}
};

dojo.extend(dijit.BackgroundIframe, {
	resize: function(node){
		// summary:
		// 		resize the iframe so its the same size as node
		// description:
		//		this function is a no-op in all browsers except
		//		IE6, which does not support 100% width/height 
		//		of absolute positioned iframes
		if(this.iframe && dojo.isIE<7){
			dojo.style(this.iframe, {
				width: node.offsetWidth + 'px',
				height: node.offsetHeight + 'px'
			});
		}
	},
	destroy: function(){
		// summary:
		//		destroy the iframe
		if(this._conn){
			dojo.disconnect(this._conn);
			this._conn = null;
		}
		if(this.iframe){
			dijit._frames.push(this.iframe);
			delete this.iframe;
		}
	}
});

}

if(!dojo._hasResource["dijit._base.scroll"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["dijit._base.scroll"] = true;
dojo.provide("dijit._base.scroll");

dijit.scrollIntoView = function(/*DomNode*/ node, /*Object?*/ pos){
	// summary:
	//		Scroll the passed node into view, if it is not already.
	
	// don't rely on that node.scrollIntoView works just because the function is there

	try{ // catch unexpected/unrecreatable errors (#7808) since we can recover using a semi-acceptable native method
	node = dojo.byId(node);
	var doc = node.ownerDocument || dojo.doc,
		body = doc.body || dojo.body(),
		html = doc.documentElement || body.parentNode,
		isIE = dojo.isIE, isWK = dojo.isWebKit;
	// if an untested browser, then use the native method
	if((!(dojo.isMoz || isIE || isWK) || node == body || node == html) && (typeof node.scrollIntoView != "undefined")){
		node.scrollIntoView(false); // short-circuit to native if possible
		return;
	}
	var backCompat = doc.compatMode == 'BackCompat',
		clientAreaRoot = backCompat? body : html,
		scrollRoot = isWK ? body : clientAreaRoot,
		rootWidth = clientAreaRoot.clientWidth,
		rootHeight = clientAreaRoot.clientHeight,
		rtl = !dojo._isBodyLtr(),
		nodePos = pos || dojo.position(node),
		el = node.parentNode,
		isFixed = function(el){
			return ((isIE <= 6 || (isIE && backCompat))? false : (dojo.style(el, 'position').toLowerCase() == "fixed"));
		};
	if(isFixed(node)){ return; } // nothing to do
	while(el){
		if(el == body){ el = scrollRoot; }
		var elPos = dojo.position(el),
			fixedPos = isFixed(el);
		with(elPos){
			if(el == scrollRoot){
				w = rootWidth, h = rootHeight;
				if(scrollRoot == html && isIE && rtl){ x += scrollRoot.offsetWidth-w; } // IE workaround where scrollbar causes negative x
				if(x < 0 || !isIE){ x = 0; } // IE can have values > 0
				if(y < 0 || !isIE){ y = 0; }
			}else{
				var pb = dojo._getPadBorderExtents(el);
				w -= pb.w; h -= pb.h; x += pb.l; y += pb.t;
			}
			with(el){
				if(el != scrollRoot){ // body, html sizes already have the scrollbar removed
					var clientSize = clientWidth,
						scrollBarSize = w - clientSize;
					if(clientSize > 0 && scrollBarSize > 0){
						w = clientSize;
						if(isIE && rtl){ x += scrollBarSize; }
					}
					clientSize = clientHeight;
					scrollBarSize = h - clientSize;
					if(clientSize > 0 && scrollBarSize > 0){
						h = clientSize;
					}
				}
				if(fixedPos){ // bounded by viewport, not parents
					if(y < 0){
						h += y, y = 0;
					}
					if(x < 0){
						w += x, x = 0;
					}
					if(y + h > rootHeight){
						h = rootHeight - y;
					}
					if(x + w > rootWidth){
						w = rootWidth - x;
					}
				}
				// calculate overflow in all 4 directions
				var l = nodePos.x - x, // beyond left: < 0
					t = nodePos.y - Math.max(y, 0), // beyond top: < 0
					r = l + nodePos.w - w, // beyond right: > 0
					bot = t + nodePos.h - h; // beyond bottom: > 0
				if(r * l > 0){
					var s = Math[l < 0? "max" : "min"](l, r);
					nodePos.x += scrollLeft;
					scrollLeft += (isIE >= 8 && !backCompat && rtl)? -s : s;
					nodePos.x -= scrollLeft;
				}
				if(bot * t > 0){
					nodePos.y += scrollTop;
					scrollTop += Math[t < 0? "max" : "min"](t, bot);
					nodePos.y -= scrollTop;
				}
			}
		}
		el = (el != scrollRoot) && !fixedPos && el.parentNode;
	}
	}catch(error){
		console.error('scrollIntoView: ' + error);
		node.scrollIntoView(false);
	}
};

}

if(!dojo._hasResource["dijit._base.sniff"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["dijit._base.sniff"] = true;
// summary:
//		Applies pre-set CSS classes to the top-level HTML node, based on:
// 			- browser (ex: dj_ie)
//			- browser version (ex: dj_ie6)
//			- box model (ex: dj_contentBox)
//			- text direction (ex: dijitRtl)
//
//		In addition, browser, browser version, and box model are
//		combined with an RTL flag when browser text is RTL.  ex: dj_ie-rtl.
//
//		Simply doing a require on this module will
//		establish this CSS.  Modified version of Morris' CSS hack.

dojo.provide("dijit._base.sniff");

(function(){

	var d = dojo,
		html = d.doc.documentElement,
		ie = d.isIE,
		opera = d.isOpera,
		maj = Math.floor,
		ff = d.isFF,
		boxModel = d.boxModel.replace(/-/,''),

		classes = {
			dj_ie: ie,
			dj_ie6: maj(ie) == 6,
			dj_ie7: maj(ie) == 7,
			dj_ie8: maj(ie) == 8,
			dj_iequirks: ie && d.isQuirks,

			// NOTE: Opera not supported by dijit
			dj_opera: opera,

			dj_khtml: d.isKhtml,

			dj_webkit: d.isWebKit,
			dj_safari: d.isSafari,
			dj_chrome: d.isChrome,

			dj_gecko: d.isMozilla,
			dj_ff3: maj(ff) == 3
		}; // no dojo unsupported browsers

	classes["dj_" + boxModel] = true;

	// apply browser, browser version, and box model class names
	for(var p in classes){
		if(classes[p]){
			if(html.className){
				html.className += " " + p;
			}else{
				html.className = p;
			}
		}
	}

	// If RTL mode then add dijitRtl flag plus repeat existing classes
	// with -rtl extension
	// (unshift is to make this code run after <body> node is loaded but before parser runs)
	dojo._loaders.unshift(function(){
		if(!dojo._isBodyLtr()){
			html.className += " dijitRtl";
			for(var p in classes){
				if(classes[p]){
					html.className += " " + p + "-rtl";
				}
			}
		}
	});

})();

}

if(!dojo._hasResource["dijit._base.typematic"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["dijit._base.typematic"] = true;
dojo.provide("dijit._base.typematic");

dijit.typematic = {
	// summary:
	//		These functions are used to repetitively call a user specified callback
	//		method when a specific key or mouse click over a specific DOM node is
	//		held down for a specific amount of time.
	//		Only 1 such event is allowed to occur on the browser page at 1 time.

	_fireEventAndReload: function(){
		this._timer = null;
		this._callback(++this._count, this._node, this._evt);
		
		// Schedule next event, reducing the timer a little bit each iteration, bottoming-out at 10 to avoid
		// browser overload (particularly avoiding starving DOH robot so it never gets to send a mouseup)
		this._currentTimeout = Math.max(
			this._currentTimeout < 0 ? this._initialDelay :
				(this._subsequentDelay > 1 ? this._subsequentDelay : Math.round(this._currentTimeout * this._subsequentDelay)),
			10);
		this._timer = setTimeout(dojo.hitch(this, "_fireEventAndReload"), this._currentTimeout);
	},

	trigger: function(/*Event*/ evt, /* Object */ _this, /*DOMNode*/ node, /* Function */ callback, /* Object */ obj, /* Number */ subsequentDelay, /* Number */ initialDelay){
		// summary:
		//		Start a timed, repeating callback sequence.
		//		If already started, the function call is ignored.
		//		This method is not normally called by the user but can be
		//		when the normal listener code is insufficient.
		// evt:
		//		key or mouse event object to pass to the user callback
		// _this:
		//		pointer to the user's widget space.
		// node:
		//		the DOM node object to pass the the callback function
		// callback:
		//		function to call until the sequence is stopped called with 3 parameters:
		// count:
		//		integer representing number of repeated calls (0..n) with -1 indicating the iteration has stopped
		// node:
		//		the DOM node object passed in
		// evt:
		//		key or mouse event object
		// obj:
		//		user space object used to uniquely identify each typematic sequence
		// subsequentDelay:
		//		if > 1, the number of milliseconds until the 3->n events occur
		//		or else the fractional time multiplier for the next event's delay, default=0.9
		// initialDelay:
		//		the number of milliseconds until the 2nd event occurs, default=500ms
		if(obj != this._obj){
			this.stop();
			this._initialDelay = initialDelay || 500;
			this._subsequentDelay = subsequentDelay || 0.90;
			this._obj = obj;
			this._evt = evt;
			this._node = node;
			this._currentTimeout = -1;
			this._count = -1;
			this._callback = dojo.hitch(_this, callback);
			this._fireEventAndReload();
		}
	},

	stop: function(){
		// summary:
		//		Stop an ongoing timed, repeating callback sequence.
		if(this._timer){
			clearTimeout(this._timer);
			this._timer = null;
		}
		if(this._obj){
			this._callback(-1, this._node, this._evt);
			this._obj = null;
		}
	},

	addKeyListener: function(/*DOMNode*/ node, /*Object*/ keyObject, /*Object*/ _this, /*Function*/ callback, /*Number*/ subsequentDelay, /*Number*/ initialDelay){
		// summary:
		//		Start listening for a specific typematic key.
		//		See also the trigger method for other parameters.
		// keyObject:
		//		an object defining the key to listen for.
		// charOrCode:
		//		the printable character (string) or keyCode (number) to listen for.
		// keyCode:
		//		(deprecated - use charOrCode) the keyCode (number) to listen for (implies charCode = 0).
		// charCode:
		//		(deprecated - use charOrCode) the charCode (number) to listen for.
		// ctrlKey:
		//		desired ctrl key state to initiate the calback sequence:
		//			- pressed (true)
		//			- released (false)
		//			- either (unspecified)
		// altKey:
		//		same as ctrlKey but for the alt key
		// shiftKey:
		//		same as ctrlKey but for the shift key
		// returns:
		//		an array of dojo.connect handles
		if(keyObject.keyCode){
			keyObject.charOrCode = keyObject.keyCode;
			dojo.deprecated("keyCode attribute parameter for dijit.typematic.addKeyListener is deprecated. Use charOrCode instead.", "", "2.0");
		}else if(keyObject.charCode){
			keyObject.charOrCode = String.fromCharCode(keyObject.charCode);
			dojo.deprecated("charCode attribute parameter for dijit.typematic.addKeyListener is deprecated. Use charOrCode instead.", "", "2.0");
		}
		return [
			dojo.connect(node, "onkeypress", this, function(evt){
				if(evt.charOrCode == keyObject.charOrCode &&
				(keyObject.ctrlKey === undefined || keyObject.ctrlKey == evt.ctrlKey) &&
				(keyObject.altKey === undefined || keyObject.altKey == evt.altKey) &&
				(keyObject.metaKey === undefined || keyObject.metaKey == (evt.metaKey || false)) && // IE doesn't even set metaKey
				(keyObject.shiftKey === undefined || keyObject.shiftKey == evt.shiftKey)){
					dojo.stopEvent(evt);
					dijit.typematic.trigger(keyObject, _this, node, callback, keyObject, subsequentDelay, initialDelay);
				}else if(dijit.typematic._obj == keyObject){
					dijit.typematic.stop();
				}
			}),
			dojo.connect(node, "onkeyup", this, function(evt){
				if(dijit.typematic._obj == keyObject){
					dijit.typematic.stop();
				}
			})
		];
	},

	addMouseListener: function(/*DOMNode*/ node, /*Object*/ _this, /*Function*/ callback, /*Number*/ subsequentDelay, /*Number*/ initialDelay){
		// summary:
		//		Start listening for a typematic mouse click.
		//		See the trigger method for other parameters.
		// returns:
		//		an array of dojo.connect handles
		var dc = dojo.connect;
		return [
			dc(node, "mousedown", this, function(evt){
				dojo.stopEvent(evt);
				dijit.typematic.trigger(evt, _this, node, callback, node, subsequentDelay, initialDelay);
			}),
			dc(node, "mouseup", this, function(evt){
				dojo.stopEvent(evt);
				dijit.typematic.stop();
			}),
			dc(node, "mouseout", this, function(evt){
				dojo.stopEvent(evt);
				dijit.typematic.stop();
			}),
			dc(node, "mousemove", this, function(evt){
				dojo.stopEvent(evt);
			}),
			dc(node, "dblclick", this, function(evt){
				dojo.stopEvent(evt);
				if(dojo.isIE){
					dijit.typematic.trigger(evt, _this, node, callback, node, subsequentDelay, initialDelay);
					setTimeout(dojo.hitch(this, dijit.typematic.stop), 50);
				}
			})
		];
	},

	addListener: function(/*Node*/ mouseNode, /*Node*/ keyNode, /*Object*/ keyObject, /*Object*/ _this, /*Function*/ callback, /*Number*/ subsequentDelay, /*Number*/ initialDelay){
		// summary:
		//		Start listening for a specific typematic key and mouseclick.
		//		This is a thin wrapper to addKeyListener and addMouseListener.
		//		See the addMouseListener and addKeyListener methods for other parameters.
		// mouseNode:
		//		the DOM node object to listen on for mouse events.
		// keyNode:
		//		the DOM node object to listen on for key events.
		// returns:
		//		an array of dojo.connect handles
		return this.addKeyListener(keyNode, keyObject, _this, callback, subsequentDelay, initialDelay).concat(
			this.addMouseListener(mouseNode, _this, callback, subsequentDelay, initialDelay));
	},
	destroy: function(){
		//console.info('destroy for typematic called', this);
		delete this._evt;
		delete this._node;
	}
};

dojo.addOnWindowUnload(function(){
	dijit.typematic.destroy();
});

}

if(!dojo._hasResource["dijit._base.wai"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["dijit._base.wai"] = true;
dojo.provide("dijit._base.wai");

dijit.wai = {
	onload: function(){
		// summary:
		//		Detects if we are in high-contrast mode or not

		// This must be a named function and not an anonymous
		// function, so that the widget parsing code can make sure it
		// registers its onload function after this function.
		// DO NOT USE "this" within this function.

		// create div for testing if high contrast mode is on or images are turned off
		var div = dojo.create("div",{
			id: "a11yTestNode",
			style:{
				cssText:'border: 1px solid;'
					+ 'border-color:red green;'
					+ 'position: absolute;'
					+ 'height: 5px;'
					+ 'top: -999px;'
					+ 'background-image: url("' + (dojo.config.blankGif || dojo.moduleUrl("dojo", "resources/blank.gif")) + '");'
			}
		}, dojo.body());

		// test it
		var cs = dojo.getComputedStyle(div);
		if(cs){
			var bkImg = cs.backgroundImage;
			var needsA11y = (cs.borderTopColor == cs.borderRightColor) || (bkImg != null && (bkImg == "none" || bkImg == "url(invalid-url:)" ));
			dojo[needsA11y ? "addClass" : "removeClass"](dojo.body(), "dijit_a11y");
			if(dojo.isIE){
				div.outerHTML = "";		// prevent mixed-content warning, see http://support.microsoft.com/kb/925014
			}else{
				dojo.body().removeChild(div);
			}
		}
	}
};

// Test if computer is in high contrast mode.
// Make sure the a11y test runs first, before widgets are instantiated.
if(dojo.isIE || dojo.isMoz){	// NOTE: checking in Safari messes things up
	dojo._loaders.unshift(dijit.wai.onload);
}

dojo.mixin(dijit, {
	_XhtmlRoles: /banner|contentinfo|definition|main|navigation|search|note|secondary|seealso/,

	hasWaiRole: function(/*Element*/ elem, /*String*/ role){
		// summary:
		//		Determines if an element has a particular non-XHTML role.
		// returns:
		//		True if elem has the specific non-XHTML role attribute and false if not.
		// 		For backwards compatibility if role parameter not provided,
		// 		returns true if has non XHTML role
		var waiRole = this.getWaiRole(elem);
		return role ? (waiRole.indexOf(role) > -1) : (waiRole.length > 0);
	},

	getWaiRole: function(/*Element*/ elem){
		// summary:
		//		Gets the non-XHTML role for an element (which should be a wai role).
		// returns:
		//		The non-XHTML role of elem or an empty string if elem
		//		does not have a role.
		 return dojo.trim((dojo.attr(elem, "role") || "").replace(this._XhtmlRoles,"").replace("wairole:",""));
	},

	setWaiRole: function(/*Element*/ elem, /*String*/ role){
		// summary:
		//		Sets the role on an element.
		// description:
		//		Replace existing role attribute with new role.
		//		If elem already has an XHTML role, append this role to XHTML role
		//		and remove other ARIA roles.

		var curRole = dojo.attr(elem, "role") || "";
		if(!this._XhtmlRoles.test(curRole)){
			dojo.attr(elem, "role", role);
		}else{
			if((" "+ curRole +" ").indexOf(" " + role + " ") < 0){
				var clearXhtml = dojo.trim(curRole.replace(this._XhtmlRoles, ""));
				var cleanRole = dojo.trim(curRole.replace(clearXhtml, ""));
				dojo.attr(elem, "role", cleanRole + (cleanRole ? ' ' : '') + role);
			}
		}
	},

	removeWaiRole: function(/*Element*/ elem, /*String*/ role){
		// summary:
		//		Removes the specified non-XHTML role from an element.
		// 		Removes role attribute if no specific role provided (for backwards compat.)

		var roleValue = dojo.attr(elem, "role");
		if(!roleValue){ return; }
		if(role){
			var t = dojo.trim((" " + roleValue + " ").replace(" " + role + " ", " "));
			dojo.attr(elem, "role", t);
		}else{
			elem.removeAttribute("role");
		}
	},

	hasWaiState: function(/*Element*/ elem, /*String*/ state){
		// summary:
		//		Determines if an element has a given state.
		// description:
		//		Checks for an attribute called "aria-"+state.
		// returns:
		//		true if elem has a value for the given state and
		//		false if it does not.

		return elem.hasAttribute ? elem.hasAttribute("aria-"+state) : !!elem.getAttribute("aria-"+state);
	},

	getWaiState: function(/*Element*/ elem, /*String*/ state){
		// summary:
		//		Gets the value of a state on an element.
		// description:
		//		Checks for an attribute called "aria-"+state.
		// returns:
		//		The value of the requested state on elem
		//		or an empty string if elem has no value for state.

		return elem.getAttribute("aria-"+state) || "";
	},

	setWaiState: function(/*Element*/ elem, /*String*/ state, /*String*/ value){
		// summary:
		//		Sets a state on an element.
		// description:
		//		Sets an attribute called "aria-"+state.

		elem.setAttribute("aria-"+state, value);
	},

	removeWaiState: function(/*Element*/ elem, /*String*/ state){
		// summary:
		//		Removes a state from an element.
		// description:
		//		Sets an attribute called "aria-"+state.

		elem.removeAttribute("aria-"+state);
	}
});

}

if(!dojo._hasResource["dijit._base"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["dijit._base"] = true;
dojo.provide("dijit._base");











}

if(!dojo._hasResource["dijit._Widget"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["dijit._Widget"] = true;
dojo.provide("dijit._Widget");

dojo.require( "dijit._base" );


// This code is to assist deferring dojo.connect() calls in widgets (connecting to events on the widgets'
// DOM nodes) until someone actually needs to monitor that event.
dojo.connect(dojo, "_connect",
	function(/*dijit._Widget*/ widget, /*String*/ event){
		if(widget && dojo.isFunction(widget._onConnect)){
			widget._onConnect(event);
		}
	});

dijit._connectOnUseEventHandler = function(/*Event*/ event){};

// Keep track of where the last keydown event was, to help avoid generating
// spurious ondijitclick events when:
// 1. focus is on a <button> or <a>
// 2. user presses then releases the ENTER key
// 3. onclick handler fires and shifts focus to another node, with an ondijitclick handler
// 4. onkeyup event fires, causing the ondijitclick handler to fire
dijit._lastKeyDownNode = null;
if(dojo.isIE){
	(function(){
		var keydownCallback = function(evt){
			dijit._lastKeyDownNode = evt.srcElement;
		};
		dojo.doc.attachEvent('onkeydown', keydownCallback);
		dojo.addOnWindowUnload(function(){
			dojo.doc.detachEvent('onkeydown', keydownCallback);
		});
	})();
}else{
	dojo.doc.addEventListener('keydown', function(evt){
		dijit._lastKeyDownNode = evt.target;
	}, true);
}

(function(){

var _attrReg = {},	// cached results from getSetterAttributes
	getSetterAttributes = function(widget){
		// summary:
		//		Returns list of attributes with custom setters for specified widget
		var dc = widget.declaredClass;
		if(!_attrReg[dc]){
			var r = [],
				attrs,
				proto = widget.constructor.prototype;
			for(var fxName in proto){
				if(dojo.isFunction(proto[fxName]) && (attrs = fxName.match(/^_set([a-zA-Z]*)Attr$/)) && attrs[1]){
					r.push(attrs[1].charAt(0).toLowerCase() + attrs[1].substr(1));
				}
			}
			_attrReg[dc] = r;
		}
		return _attrReg[dc] || [];	// String[]
	};

dojo.declare("dijit._Widget", null, {
	// summary:
	//		Base class for all Dijit widgets.

	// id: [const] String
	//		A unique, opaque ID string that can be assigned by users or by the
	//		system. If the developer passes an ID which is known not to be
	//		unique, the specified ID is ignored and the system-generated ID is
	//		used instead.
	id: "",

	// lang: [const] String
	//		Rarely used.  Overrides the default Dojo locale used to render this widget,
	//		as defined by the [HTML LANG](http://www.w3.org/TR/html401/struct/dirlang.html#adef-lang) attribute.
	//		Value must be among the list of locales specified during by the Dojo bootstrap,
	//		formatted according to [RFC 3066](http://www.ietf.org/rfc/rfc3066.txt) (like en-us).
	lang: "",

	// dir: [const] String
	//		Unsupported by Dijit, but here for completeness.  Dijit only supports setting text direction on the
	//		entire document.
	//		Bi-directional support, as defined by the [HTML DIR](http://www.w3.org/TR/html401/struct/dirlang.html#adef-dir)
	//		attribute. Either left-to-right "ltr" or right-to-left "rtl".
	dir: "",

	// class: String
	//		HTML class attribute
	"class": "",

	// style: String||Object
	//		HTML style attributes as cssText string or name/value hash
	style: "",

	// title: String
	//		HTML title attribute.
	//
	//		For form widgets this specifies a tooltip to display when hovering over
	//		the widget (just like the native HTML title attribute).
	//
	//		For TitlePane or for when this widget is a child of a TabContainer, AccordionContainer,
	//		etc., it's used to specify the tab label, accordion pane title, etc.
	title: "",

	// tooltip: String
	//		When this widget's title attribute is used to for a tab label, accordion pane title, etc.,
	//		this specifies the tooltip to appear when the mouse is hovered over that text.
	tooltip: "",

	// srcNodeRef: [readonly] DomNode
	//		pointer to original DOM node
	srcNodeRef: null,

	// domNode: [readonly] DomNode
	//		This is our visible representation of the widget! Other DOM
	//		Nodes may by assigned to other properties, usually through the
	//		template system's dojoAttachPoint syntax, but the domNode
	//		property is the canonical "top level" node in widget UI.
	domNode: null,

	// containerNode: [readonly] DomNode
	//		Designates where children of the source DOM node will be placed.
	//		"Children" in this case refers to both DOM nodes and widgets.
	//		For example, for myWidget:
	//
	//		|	<div dojoType=myWidget>
	//		|		<b> here's a plain DOM node
	//		|		<span dojoType=subWidget>and a widget</span>
	//		|		<i> and another plain DOM node </i>
	//		|	</div>
	//
	//		containerNode would point to:
	//
	//		|		<b> here's a plain DOM node
	//		|		<span dojoType=subWidget>and a widget</span>
	//		|		<i> and another plain DOM node </i>
	//
	//		In templated widgets, "containerNode" is set via a
	//		dojoAttachPoint assignment.
	//
	//		containerNode must be defined for any widget that accepts innerHTML
	//		(like ContentPane or BorderContainer or even Button), and conversely
	//		is null for widgets that don't, like TextBox.
	containerNode: null,

/*=====
	// _started: Boolean
	//		startup() has completed.
	_started: false,
=====*/

	// attributeMap: [protected] Object
	//		attributeMap sets up a "binding" between attributes (aka properties)
	//		of the widget and the widget's DOM.
	//		Changes to widget attributes listed in attributeMap will be
	//		reflected into the DOM.
	//
	//		For example, calling attr('title', 'hello')
	//		on a TitlePane will automatically cause the TitlePane's DOM to update
	//		with the new title.
	//
	//		attributeMap is a hash where the key is an attribute of the widget,
	//		and the value reflects a binding to a:
	//
	//		- DOM node attribute
	// |		focus: {node: "focusNode", type: "attribute"}
	// 		Maps this.focus to this.focusNode.focus
	//
	//		- DOM node innerHTML
	//	|		title: { node: "titleNode", type: "innerHTML" }
	//		Maps this.title to this.titleNode.innerHTML
	//
	//		- DOM node innerText
	//	|		title: { node: "titleNode", type: "innerText" }
	//		Maps this.title to this.titleNode.innerText
	//
	//		- DOM node CSS class
	// |		myClass: { node: "domNode", type: "class" }
	//		Maps this.myClass to this.domNode.className
	//
	//		If the value is an array, then each element in the array matches one of the
	//		formats of the above list.
	//
	//		There are also some shorthands for backwards compatibility:
	//		- string --> { node: string, type: "attribute" }, for example:
	//	|	"focusNode" ---> { node: "focusNode", type: "attribute" }
	//		- "" --> { node: "domNode", type: "attribute" }
	attributeMap: {id:"", dir:"", lang:"", "class":"", style:"", title:""},

	// _deferredConnects: [protected] Object
	//		attributeMap addendum for event handlers that should be connected only on first use
	_deferredConnects: {
		onClick: "",
		onDblClick: "",
		onKeyDown: "",
		onKeyPress: "",
		onKeyUp: "",
		onMouseMove: "",
		onMouseDown: "",
		onMouseOut: "",
		onMouseOver: "",
		onMouseLeave: "",
		onMouseEnter: "",
		onMouseUp: ""
	},

	onClick: dijit._connectOnUseEventHandler,
	/*=====
	onClick: function(event){
		// summary:
		//		Connect to this function to receive notifications of mouse click events.
		// event:
		//		mouse Event
		// tags:
		//		callback
	},
	=====*/
	onDblClick: dijit._connectOnUseEventHandler,
	/*=====
	onDblClick: function(event){
		// summary:
		//		Connect to this function to receive notifications of mouse double click events.
		// event:
		//		mouse Event
		// tags:
		//		callback
	},
	=====*/
	onKeyDown: dijit._connectOnUseEventHandler,
	/*=====
	onKeyDown: function(event){
		// summary:
		//		Connect to this function to receive notifications of keys being pressed down.
		// event:
		//		key Event
		// tags:
		//		callback
	},
	=====*/
	onKeyPress: dijit._connectOnUseEventHandler,
	/*=====
	onKeyPress: function(event){
		// summary:
		//		Connect to this function to receive notifications of printable keys being typed.
		// event:
		//		key Event
		// tags:
		//		callback
	},
	=====*/
	onKeyUp: dijit._connectOnUseEventHandler,
	/*=====
	onKeyUp: function(event){
		// summary:
		//		Connect to this function to receive notifications of keys being released.
		// event:
		//		key Event
		// tags:
		//		callback
	},
	=====*/
	onMouseDown: dijit._connectOnUseEventHandler,
	/*=====
	onMouseDown: function(event){
		// summary:
		//		Connect to this function to receive notifications of when the mouse button is pressed down.
		// event:
		//		mouse Event
		// tags:
		//		callback
	},
	=====*/
	onMouseMove: dijit._connectOnUseEventHandler,
	/*=====
	onMouseMove: function(event){
		// summary:
		//		Connect to this function to receive notifications of when the mouse moves over nodes contained within this widget.
		// event:
		//		mouse Event
		// tags:
		//		callback
	},
	=====*/
	onMouseOut: dijit._connectOnUseEventHandler,
	/*=====
	onMouseOut: function(event){
		// summary:
		//		Connect to this function to receive notifications of when the mouse moves off of nodes contained within this widget.
		// event:
		//		mouse Event
		// tags:
		//		callback
	},
	=====*/
	onMouseOver: dijit._connectOnUseEventHandler,
	/*=====
	onMouseOver: function(event){
		// summary:
		//		Connect to this function to receive notifications of when the mouse moves onto nodes contained within this widget.
		// event:
		//		mouse Event
		// tags:
		//		callback
	},
	=====*/
	onMouseLeave: dijit._connectOnUseEventHandler,
	/*=====
	onMouseLeave: function(event){
		// summary:
		//		Connect to this function to receive notifications of when the mouse moves off of this widget.
		// event:
		//		mouse Event
		// tags:
		//		callback
	},
	=====*/
	onMouseEnter: dijit._connectOnUseEventHandler,
	/*=====
	onMouseEnter: function(event){
		// summary:
		//		Connect to this function to receive notifications of when the mouse moves onto this widget.
		// event:
		//		mouse Event
		// tags:
		//		callback
	},
	=====*/
	onMouseUp: dijit._connectOnUseEventHandler,
	/*=====
	onMouseUp: function(event){
		// summary:
		//		Connect to this function to receive notifications of when the mouse button is released.
		// event:
		//		mouse Event
		// tags:
		//		callback
	},
	=====*/

	// Constants used in templates

	// _blankGif: [protected] String
	//		Path to a blank 1x1 image.
	//		Used by <img> nodes in templates that really get their image via CSS background-image.
	_blankGif: (dojo.config.blankGif || dojo.moduleUrl("dojo", "resources/blank.gif")).toString(),

	//////////// INITIALIZATION METHODS ///////////////////////////////////////

	postscript: function(/*Object?*/params, /*DomNode|String*/srcNodeRef){
		// summary:
		//		Kicks off widget instantiation.  See create() for details.
		// tags:
		//		private
		this.create(params, srcNodeRef);
	},

	create: function(/*Object?*/params, /*DomNode|String?*/srcNodeRef){
		// summary:
		//		Kick off the life-cycle of a widget
		// params:
		//		Hash of initialization parameters for widget, including
		//		scalar values (like title, duration etc.) and functions,
		//		typically callbacks like onClick.
		// srcNodeRef:
		//		If a srcNodeRef (DOM node) is specified:
		//			- use srcNodeRef.innerHTML as my contents
		//			- if this is a behavioral widget then apply behavior
		//			  to that srcNodeRef
		//			- otherwise, replace srcNodeRef with my generated DOM
		//			  tree
		// description:
		//		Create calls a number of widget methods (postMixInProperties, buildRendering, postCreate,
		//		etc.), some of which of you'll want to override. See http://docs.dojocampus.org/dijit/_Widget
		//		for a discussion of the widget creation lifecycle.
		//
		//		Of course, adventurous developers could override create entirely, but this should
		//		only be done as a last resort.
		// tags:
		//		private

		// store pointer to original DOM tree
		this.srcNodeRef = dojo.byId(srcNodeRef);

		// For garbage collection.  An array of handles returned by Widget.connect()
		// Each handle returned from Widget.connect() is an array of handles from dojo.connect()
		this._connects = [];

		// For garbage collection.  An array of handles returned by Widget.subscribe()
		// The handle returned from Widget.subscribe() is the handle returned from dojo.subscribe()
		this._subscribes = [];

		// To avoid double-connects, remove entries from _deferredConnects
		// that have been setup manually by a subclass (ex, by dojoAttachEvent).
		// If a subclass has redefined a callback (ex: onClick) then assume it's being
		// connected to manually.
		this._deferredConnects = dojo.clone(this._deferredConnects);
		for(var attr in this.attributeMap){
			delete this._deferredConnects[attr]; // can't be in both attributeMap and _deferredConnects
		}
		for(attr in this._deferredConnects){
			if(this[attr] !== dijit._connectOnUseEventHandler){
				delete this._deferredConnects[attr];	// redefined, probably dojoAttachEvent exists
			}
		}

		//mixin our passed parameters
		if(this.srcNodeRef && (typeof this.srcNodeRef.id == "string")){ this.id = this.srcNodeRef.id; }
		if(params){
			this.params = params;
			dojo.mixin(this,params);
		}
		this.postMixInProperties();

		// generate an id for the widget if one wasn't specified
		// (be sure to do this before buildRendering() because that function might
		// expect the id to be there.)
		if(!this.id){
			this.id = dijit.getUniqueId(this.declaredClass.replace(/\./g,"_"));
		}
		dijit.registry.add(this);

		this.buildRendering();

		if(this.domNode){
			// Copy attributes listed in attributeMap into the [newly created] DOM for the widget.
			this._applyAttributes();

			var source = this.srcNodeRef;
			if(source && source.parentNode){
				source.parentNode.replaceChild(this.domNode, source);
			}

			// If the developer has specified a handler as a widget parameter
			// (ex: new Button({onClick: ...})
			// then naturally need to connect from DOM node to that handler immediately,
			for(attr in this.params){
				this._onConnect(attr);
			}
		}

		if(this.domNode){
			this.domNode.setAttribute("widgetId", this.id);
		}
		this.postCreate();

		// If srcNodeRef has been processed and removed from the DOM (e.g. TemplatedWidget) then delete it to allow GC.
		if(this.srcNodeRef && !this.srcNodeRef.parentNode){
			delete this.srcNodeRef;
		}

		this._created = true;
	},

	_applyAttributes: function(){
		// summary:
		//		Step during widget creation to copy all widget attributes to the
		//		DOM as per attributeMap and _setXXXAttr functions.
		// description:
		//		Skips over blank/false attribute values, unless they were explicitly specified
		//		as parameters to the widget, since those are the default anyway,
		//		and setting tabIndex="" is different than not setting tabIndex at all.
		//
		//		It processes the attributes in the attribute map first, and then
		//		it goes through and processes the attributes for the _setXXXAttr
		//		functions that have been specified
		// tags:
		//		private
		var condAttrApply = function(attr, scope){
			if((scope.params && attr in scope.params) || scope[attr]){
				scope.attr(attr, scope[attr]);
			}
		};

		// Do the attributes in attributeMap
		for(var attr in this.attributeMap){
			condAttrApply(attr, this);
		}

		// And also any attributes with custom setters
		dojo.forEach(getSetterAttributes(this), function(a){
			if(!(a in this.attributeMap)){
				condAttrApply(a, this);
			}
		}, this);
	},

	postMixInProperties: function(){
		// summary:
		//		Called after the parameters to the widget have been read-in,
		//		but before the widget template is instantiated. Especially
		//		useful to set properties that are referenced in the widget
		//		template.
		// tags:
		//		protected
	},

	buildRendering: function(){
		// summary:
		//		Construct the UI for this widget, setting this.domNode
		// description:
		//		Most widgets will mixin `dijit._Templated`, which implements this
		//		method.
		// tags:
		//		protected
		this.domNode = this.srcNodeRef || dojo.create('div');
	},

	postCreate: function(){
		// summary:
		//		Processing after the DOM fragment is created
		// description:
		//		Called after the DOM fragment has been created, but not necessarily
		//		added to the document.  Do not include any operations which rely on
		//		node dimensions or placement.
		// tags:
		//		protected
	},

	startup: function(){
		// summary:
		//		Processing after the DOM fragment is added to the document
		// description:
		//		Called after a widget and its children have been created and added to the page,
		//		and all related widgets have finished their create() cycle, up through postCreate().
		//		This is useful for composite widgets that need to control or layout sub-widgets.
		//		Many layout widgets can use this as a wiring phase.
		this._started = true;
	},

	//////////// DESTROY FUNCTIONS ////////////////////////////////

	destroyRecursive: function(/*Boolean?*/ preserveDom){
		// summary:
		// 		Destroy this widget and its descendants
		// description:
		//		This is the generic "destructor" function that all widget users
		// 		should call to cleanly discard with a widget. Once a widget is
		// 		destroyed, it is removed from the manager object.
		// preserveDom:
		//		If true, this method will leave the original DOM structure
		//		alone of descendant Widgets. Note: This will NOT work with
		//		dijit._Templated widgets.

		this._beingDestroyed = true;
		this.destroyDescendants(preserveDom);
		this.destroy(preserveDom);
	},

	destroy: function(/*Boolean*/ preserveDom){
		// summary:
		// 		Destroy this widget, but not its descendants.
		//		This method will, however, destroy internal widgets such as those used within a template.
		// preserveDom: Boolean
		//		If true, this method will leave the original DOM structure alone.
		//		Note: This will not yet work with _Templated widgets

		this._beingDestroyed = true;
		this.uninitialize();
		var d = dojo,
			dfe = d.forEach,
			dun = d.unsubscribe;
		dfe(this._connects, function(array){
			dfe(array, d.disconnect);
		});
		dfe(this._subscribes, function(handle){
			dun(handle);
		});

		// destroy widgets created as part of template, etc.
		dfe(this._supportingWidgets || [], function(w){
			if(w.destroyRecursive){
				w.destroyRecursive();
			}else if(w.destroy){
				w.destroy();
			}
		});

		this.destroyRendering(preserveDom);
		dijit.registry.remove(this.id);
		this._destroyed = true;
	},

	destroyRendering: function(/*Boolean?*/ preserveDom){
		// summary:
		//		Destroys the DOM nodes associated with this widget
		// preserveDom:
		//		If true, this method will leave the original DOM structure alone
		//		during tear-down. Note: this will not work with _Templated
		//		widgets yet.
		// tags:
		//		protected

		if(this.bgIframe){
			this.bgIframe.destroy(preserveDom);
			delete this.bgIframe;
		}

		if(this.domNode){
			if(preserveDom){
				dojo.removeAttr(this.domNode, "widgetId");
			}else{
				dojo.destroy(this.domNode);
			}
			delete this.domNode;
		}

		if(this.srcNodeRef){
			if(!preserveDom){
				dojo.destroy(this.srcNodeRef);
			}
			delete this.srcNodeRef;
		}
	},

	destroyDescendants: function(/*Boolean?*/ preserveDom){
		// summary:
		//		Recursively destroy the children of this widget and their
		//		descendants.
		// preserveDom:
		//		If true, the preserveDom attribute is passed to all descendant
		//		widget's .destroy() method. Not for use with _Templated
		//		widgets.

		// get all direct descendants and destroy them recursively
		dojo.forEach(this.getChildren(), function(widget){
			if(widget.destroyRecursive){
				widget.destroyRecursive(preserveDom);
			}
		});
	},


	uninitialize: function(){
		// summary:
		//		Stub function. Override to implement custom widget tear-down
		//		behavior.
		// tags:
		//		protected
		return false;
	},

	////////////////// MISCELLANEOUS METHODS ///////////////////

	onFocus: function(){
		// summary:
		//		Called when the widget becomes "active" because
		//		it or a widget inside of it either has focus, or has recently
		//		been clicked.
		// tags:
		//		callback
	},

	onBlur: function(){
		// summary:
		//		Called when the widget stops being "active" because
		//		focus moved to something outside of it, or the user
		//		clicked somewhere outside of it, or the widget was
		//		hidden.
		// tags:
		//		callback
	},

	_onFocus: function(e){
		// summary:
		//		This is where widgets do processing for when they are active,
		//		such as changing CSS classes.  See onFocus() for more details.
		// tags:
		//		protected
		this.onFocus();
	},

	_onBlur: function(){
		// summary:
		//		This is where widgets do processing for when they stop being active,
		//		such as changing CSS classes.  See onBlur() for more details.
		// tags:
		//		protected
		this.onBlur();
	},

	_onConnect: function(/*String*/ event){
		// summary:
		//		Called when someone connects to one of my handlers.
		//		"Turn on" that handler if it isn't active yet.
		//
		//		This is also called for every single initialization parameter
		//		so need to do nothing for parameters like "id".
		// tags:
		//		private
		if(event in this._deferredConnects){
			var mapNode = this[this._deferredConnects[event] || 'domNode'];
			this.connect(mapNode, event.toLowerCase(), event);
			delete this._deferredConnects[event];
		}
	},

	_setClassAttr: function(/*String*/ value){
		// summary:
		//		Custom setter for the CSS "class" attribute
		// tags:
		//		protected
		var mapNode = this[this.attributeMap["class"] || 'domNode'];
		dojo.removeClass(mapNode, this["class"])
		this["class"] = value;
		dojo.addClass(mapNode, value);
	},

	_setStyleAttr: function(/*String||Object*/ value){
		// summary:
		//		Sets the style attribut of the widget according to value,
		//		which is either a hash like {height: "5px", width: "3px"}
		//		or a plain string
		// description:
		//		Determines which node to set the style on based on style setting
		//		in attributeMap.
		// tags:
		//		protected

		var mapNode = this[this.attributeMap.style || 'domNode'];

		// Note: technically we should revert any style setting made in a previous call
		// to his method, but that's difficult to keep track of.

		if(dojo.isObject(value)){
			dojo.style(mapNode, value);
		}else{
			if(mapNode.style.cssText){
				mapNode.style.cssText += "; " + value;
			}else{
				mapNode.style.cssText = value;
			}
		}

		this.style = value;
	},

	setAttribute: function(/*String*/ attr, /*anything*/ value){
		// summary:
		//		Deprecated.  Use attr() instead.
		// tags:
		//		deprecated
		dojo.deprecated(this.declaredClass+"::setAttribute() is deprecated. Use attr() instead.", "", "2.0");
		this.attr(attr, value);
	},

	_attrToDom: function(/*String*/ attr, /*String*/ value){
		// summary:
		//		Reflect a widget attribute (title, tabIndex, duration etc.) to
		//		the widget DOM, as specified in attributeMap.
		//
		// description:
		//		Also sets this["attr"] to the new value.
		//		Note some attributes like "type"
		//		cannot be processed this way as they are not mutable.
		//
		// tags:
		//		private

		var commands = this.attributeMap[attr];
		dojo.forEach(dojo.isArray(commands) ? commands : [commands], function(command){

			// Get target node and what we are doing to that node
			var mapNode = this[command.node || command || "domNode"];	// DOM node
			var type = command.type || "attribute";	// class, innerHTML, innerText, or attribute

			switch(type){
				case "attribute":
					if(dojo.isFunction(value)){ // functions execute in the context of the widget
						value = dojo.hitch(this, value);
					}

					// Get the name of the DOM node attribute; usually it's the same
					// as the name of the attribute in the widget (attr), but can be overridden.
					// Also maps handler names to lowercase, like onSubmit --> onsubmit
					var attrName = command.attribute ? command.attribute :
						(/^on[A-Z][a-zA-Z]*$/.test(attr) ? attr.toLowerCase() : attr);

					dojo.attr(mapNode, attrName, value);
					break;
				case "innerText":
					mapNode.innerHTML = "";
					mapNode.appendChild(dojo.doc.createTextNode(value));
					break;
				case "innerHTML":
					mapNode.innerHTML = value;
					break;
				case "class":
					dojo.removeClass(mapNode, this[attr]);
					dojo.addClass(mapNode, value);
					break;
			}
		}, this);
		this[attr] = value;
	},

	attr: function(/*String|Object*/name, /*Object?*/value){
		// summary:
		//		Set or get properties on a widget instance.
		//	name:
		//		The property to get or set. If an object is passed here and not
		//		a string, its keys are used as names of attributes to be set
		//		and the value of the object as values to set in the widget.
		//	value:
		//		Optional. If provided, attr() operates as a setter. If omitted,
		//		the current value of the named property is returned.
		// description:
		//		Get or set named properties on a widget. If no value is
		//		provided, the current value of the attribute is returned,
		//		potentially via a getter method. If a value is provided, then
		//		the method acts as a setter, assigning the value to the name,
		//		potentially calling any explicitly provided setters to handle
		//		the operation. For instance, if the widget has properties "foo"
		//		and "bar" and a method named "_setFooAttr", calling:
		//	|	myWidget.attr("foo", "Howdy!");
		//		would be equivalent to calling:
		//	|	widget._setFooAttr("Howdy!");
		//		while calling:
		//	|	myWidget.attr("bar", "Howdy!");
		//		would be the same as writing:
		//	|	widget.bar = "Howdy!";
		//		It also tries to copy the changes to the widget's DOM according
		//		to settings in attributeMap (see description of `dijit._Widget.attributeMap`
		//		for details)
		//		For example, calling:
		//	|	myTitlePane.attr("title", "Howdy!");
		//		will do
		//	|	myTitlePane.title = "Howdy!";
		//	|	myTitlePane.title.innerHTML = "Howdy!";
		//		It works for DOM node attributes too.  Calling
		//	|	widget.attr("disabled", true)
		//		will set the disabled attribute on the widget's focusNode,
		//		among other housekeeping for a change in disabled state.

		//	open questions:
		//		- how to handle build shortcut for attributes which want to map
		//		into DOM attributes?
		//		- what relationship should setAttribute()/attr() have to
		//		layout() calls?
		var args = arguments.length;
		if(args == 1 && !dojo.isString(name)){
			for(var x in name){ this.attr(x, name[x]); }
			return this;
		}
		var names = this._getAttrNames(name);
		if(args >= 2){ // setter
			if(this[names.s]){
				// use the explicit setter
				args = dojo._toArray(arguments, 1);
				return this[names.s].apply(this, args) || this;
			}else{
				// if param is specified as DOM node attribute, copy it
				if(name in this.attributeMap){
					this._attrToDom(name, value);
				}

				// FIXME: what about function assignments? Any way to connect() here?
				this[name] = value;
			}
			return this;
		}else{ // getter
			return this[names.g] ? this[names.g]() : this[name];
		}
	},

	_attrPairNames: {},		// shared between all widgets
	_getAttrNames: function(name){
		// summary:
		//		Helper function for Widget.attr().
		//		Caches attribute name values so we don't do the string ops every time.
		// tags:
		//		private

		var apn = this._attrPairNames;
		if(apn[name]){ return apn[name]; }
		var uc = name.charAt(0).toUpperCase() + name.substr(1);
		return (apn[name] = {
			n: name+"Node",
			s: "_set"+uc+"Attr",
			g: "_get"+uc+"Attr"
		});
	},

	toString: function(){
		// summary:
		//		Returns a string that represents the widget
		// description:
		//		When a widget is cast to a string, this method will be used to generate the
		//		output. Currently, it does not implement any sort of reversible
		//		serialization.
		return '[Widget ' + this.declaredClass + ', ' + (this.id || 'NO ID') + ']'; // String
	},

	getDescendants: function(){
		// summary:
		//		Returns all the widgets contained by this, i.e., all widgets underneath this.containerNode.
		//		This method should generally be avoided as it returns widgets declared in templates, which are
		//		supposed to be internal/hidden, but it's left here for back-compat reasons.

		return this.containerNode ? dojo.query('[widgetId]', this.containerNode).map(dijit.byNode) : []; // dijit._Widget[]
	},

	getChildren: function(){
		// summary:
		//		Returns all the widgets contained by this, i.e., all widgets underneath this.containerNode.
		//		Does not return nested widgets, nor widgets that are part of this widget's template.
		return this.containerNode ? dijit.findWidgets(this.containerNode) : []; // dijit._Widget[]
	},

	// nodesWithKeyClick: [private] String[]
	//		List of nodes that correctly handle click events via native browser support,
	//		and don't need dijit's help
	nodesWithKeyClick: ["input", "button"],

	connect: function(
			/*Object|null*/ obj,
			/*String|Function*/ event,
			/*String|Function*/ method){
		// summary:
		//		Connects specified obj/event to specified method of this object
		//		and registers for disconnect() on widget destroy.
		// description:
		//		Provide widget-specific analog to dojo.connect, except with the
		//		implicit use of this widget as the target object.
		//		This version of connect also provides a special "ondijitclick"
		//		event which triggers on a click or space or enter keyup
		// returns:
		//		A handle that can be passed to `disconnect` in order to disconnect before
		//		the widget is destroyed.
		// example:
		//	|	var btn = new dijit.form.Button();
		//	|	// when foo.bar() is called, call the listener we're going to
		//	|	// provide in the scope of btn
		//	|	btn.connect(foo, "bar", function(){
		//	|		console.debug(this.toString());
		//	|	});
		// tags:
		//		protected

		var d = dojo,
			dc = d._connect,
			handles = [];
		if(event == "ondijitclick"){
			// add key based click activation for unsupported nodes.
			// do all processing onkey up to prevent spurious clicks
			// for details see comments at top of this file where _lastKeyDownNode is defined
			if(!this.nodesWithKeyClick[obj.tagName.toLowerCase()]){
				var m = d.hitch(this, method);
				handles.push(
					dc(obj, "onkeydown", this, function(e){
						//console.log(this.id + ": onkeydown, e.target = ", e.target, ", lastKeyDownNode was ", dijit._lastKeyDownNode, ", equality is ", (e.target === dijit._lastKeyDownNode));
						if((e.keyCode == d.keys.ENTER || e.keyCode == d.keys.SPACE) &&
							!e.ctrlKey && !e.shiftKey && !e.altKey && !e.metaKey){
							// needed on IE for when focus changes between keydown and keyup - otherwise dropdown menus do not work
							dijit._lastKeyDownNode = e.target;
							d.stopEvent(e);		// stop event to prevent scrolling on space key in IE
						}
			 		}),
					dc(obj, "onkeyup", this, function(e){
						//console.log(this.id + ": onkeyup, e.target = ", e.target, ", lastKeyDownNode was ", dijit._lastKeyDownNode, ", equality is ", (e.target === dijit._lastKeyDownNode));
						if( (e.keyCode == d.keys.ENTER || e.keyCode == d.keys.SPACE) &&
							e.target === dijit._lastKeyDownNode &&
							!e.ctrlKey && !e.shiftKey && !e.altKey && !e.metaKey){
								//need reset here or have problems in FF when focus returns to trigger element after closing popup/alert
								dijit._lastKeyDownNode = null;
								return m(e);
						}
					})
				);
			}
			event = "onclick";
		}
		handles.push(dc(obj, event, this, method));

		this._connects.push(handles);
		return handles;		// _Widget.Handle
	},

	disconnect: function(/* _Widget.Handle */ handles){
		// summary:
		//		Disconnects handle created by `connect`.
		//		Also removes handle from this widget's list of connects.
		// tags:
		//		protected
		for(var i=0; i<this._connects.length; i++){
			if(this._connects[i] == handles){
				dojo.forEach(handles, dojo.disconnect);
				this._connects.splice(i, 1);
				return;
			}
		}
	},

	subscribe: function(
			/*String*/ topic,
			/*String|Function*/ method){
		// summary:
		//		Subscribes to the specified topic and calls the specified method
		//		of this object and registers for unsubscribe() on widget destroy.
		// description:
		//		Provide widget-specific analog to dojo.subscribe, except with the
		//		implicit use of this widget as the target object.
		// example:
		//	|	var btn = new dijit.form.Button();
		//	|	// when /my/topic is published, this button changes its label to
		//	|   // be the parameter of the topic.
		//	|	btn.subscribe("/my/topic", function(v){
		//	|		this.attr("label", v);
		//	|	});
		var d = dojo,
			handle = d.subscribe(topic, this, method);

		// return handles for Any widget that may need them
		this._subscribes.push(handle);
		return handle;
	},

	unsubscribe: function(/*Object*/ handle){
		// summary:
		//		Unsubscribes handle created by this.subscribe.
		//		Also removes handle from this widget's list of subscriptions
		for(var i=0; i<this._subscribes.length; i++){
			if(this._subscribes[i] == handle){
				dojo.unsubscribe(handle);
				this._subscribes.splice(i, 1);
				return;
			}
		}
	},

	isLeftToRight: function(){
		// summary:
		//		Checks the page for text direction
		// tags:
		//		protected
		return dojo._isBodyLtr(); //Boolean
	},

	isFocusable: function(){
		// summary:
		//		Return true if this widget can currently be focused
		//		and false if not
		return this.focus && (dojo.style(this.domNode, "display") != "none");
	},

	placeAt: function(/* String|DomNode|_Widget */reference, /* String?|Int? */position){
		// summary:
		//		Place this widget's domNode reference somewhere in the DOM based
		//		on standard dojo.place conventions, or passing a Widget reference that
		//		contains and addChild member.
		//
		// description:
		//		A convenience function provided in all _Widgets, providing a simple
		//		shorthand mechanism to put an existing (or newly created) Widget
		//		somewhere in the dom, and allow chaining.
		//
		// reference:
		//		The String id of a domNode, a domNode reference, or a reference to a Widget posessing
		//		an addChild method.
		//
		// position:
		//		If passed a string or domNode reference, the position argument
		//		accepts a string just as dojo.place does, one of: "first", "last",
		//		"before", or "after".
		//
		//		If passed a _Widget reference, and that widget reference has an ".addChild" method,
		//		it will be called passing this widget instance into that method, supplying the optional
		//		position index passed.
		//
		// returns:
		//		dijit._Widget
		//		Provides a useful return of the newly created dijit._Widget instance so you
		//		can "chain" this function by instantiating, placing, then saving the return value
		//		to a variable.
		//
		// example:
		// | 	// create a Button with no srcNodeRef, and place it in the body:
		// | 	var button = new dijit.form.Button({ label:"click" }).placeAt(dojo.body());
		// | 	// now, 'button' is still the widget reference to the newly created button
		// | 	dojo.connect(button, "onClick", function(e){ console.log('click'); });
		//
		// example:
		// |	// create a button out of a node with id="src" and append it to id="wrapper":
		// | 	var button = new dijit.form.Button({},"src").placeAt("wrapper");
		//
		// example:
		// |	// place a new button as the first element of some div
		// |	var button = new dijit.form.Button({ label:"click" }).placeAt("wrapper","first");
		//
		// example:
		// |	// create a contentpane and add it to a TabContainer
		// |	var tc = dijit.byId("myTabs");
		// |	new dijit.layout.ContentPane({ href:"foo.html", title:"Wow!" }).placeAt(tc)

		if(reference.declaredClass && reference.addChild){
			reference.addChild(this, position);
		}else{
			dojo.place(this.domNode, reference, position);
		}
		return this;
	},

	_onShow: function(){
		// summary:
		//		Internal method called when this widget is made visible.
		//		See `onShow` for details.
		this.onShow();
	},

	onShow: function(){
		// summary:
		//		Called when this widget becomes the selected pane in a
		//		`dijit.layout.TabContainer`, `dijit.layout.StackContainer`,
		//		`dijit.layout.AccordionContainer`, etc.
		//
		//		Also called to indicate display of a `dijit.Dialog`, `dijit.TooltipDialog`, or `dijit.TitlePane`.
		// tags:
		//		callback
	},

	onHide: function(){
		// summary:
			//		Called when another widget becomes the selected pane in a
			//		`dijit.layout.TabContainer`, `dijit.layout.StackContainer`,
			//		`dijit.layout.AccordionContainer`, etc.
			//
			//		Also called to indicate hide of a `dijit.Dialog`, `dijit.TooltipDialog`, or `dijit.TitlePane`.
			// tags:
			//		callback
	}
});

})();

}

if(!dojo._hasResource["dojo.string"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["dojo.string"] = true;
dojo.provide("dojo.string");

/*=====
dojo.string = { 
	// summary: String utilities for Dojo
};
=====*/

dojo.string.rep = function(/*String*/str, /*Integer*/num){
	//	summary:
	//		Efficiently replicate a string `n` times.
	//	str:
	//		the string to replicate
	//	num:
	//		number of times to replicate the string
	
	if(num <= 0 || !str){ return ""; }
	
	var buf = [];
	for(;;){
		if(num & 1){
			buf.push(str);
		}
		if(!(num >>= 1)){ break; }
		str += str;
	}
	return buf.join("");	// String
};

dojo.string.pad = function(/*String*/text, /*Integer*/size, /*String?*/ch, /*Boolean?*/end){
	//	summary:
	//		Pad a string to guarantee that it is at least `size` length by
	//		filling with the character `ch` at either the start or end of the
	//		string. Pads at the start, by default.
	//	text:
	//		the string to pad
	//	size:
	//		length to provide padding
	//	ch:
	//		character to pad, defaults to '0'
	//	end:
	//		adds padding at the end if true, otherwise pads at start
	//	example:
	//	|	// Fill the string to length 10 with "+" characters on the right.  Yields "Dojo++++++".
	//	|	dojo.string.pad("Dojo", 10, "+", true);

	if(!ch){
		ch = '0';
	}
	var out = String(text),
		pad = dojo.string.rep(ch, Math.ceil((size - out.length) / ch.length));
	return end ? out + pad : pad + out;	// String
};

dojo.string.substitute = function(	/*String*/		template, 
									/*Object|Array*/map, 
									/*Function?*/	transform, 
									/*Object?*/		thisObject){
	//	summary:
	//		Performs parameterized substitutions on a string. Throws an
	//		exception if any parameter is unmatched.
	//	template: 
	//		a string with expressions in the form `${key}` to be replaced or
	//		`${key:format}` which specifies a format function. keys are case-sensitive. 
	//	map:
	//		hash to search for substitutions
	//	transform: 
	//		a function to process all parameters before substitution takes
	//		place, e.g. mylib.encodeXML
	//	thisObject: 
	//		where to look for optional format function; default to the global
	//		namespace
	//	example:
	//		Substitutes two expressions in a string from an Array or Object
	//	|	// returns "File 'foo.html' is not found in directory '/temp'."
	//	|	// by providing substitution data in an Array
	//	|	dojo.string.substitute(
	//	|		"File '${0}' is not found in directory '${1}'.",
	//	|		["foo.html","/temp"]
	//	|	);
	//	|
	//	|	// also returns "File 'foo.html' is not found in directory '/temp'."
	//	|	// but provides substitution data in an Object structure.  Dotted
	//	|	// notation may be used to traverse the structure.
	//	|	dojo.string.substitute(
	//	|		"File '${name}' is not found in directory '${info.dir}'.",
	//	|		{ name: "foo.html", info: { dir: "/temp" } }
	//	|	);
	//	example:
	//		Use a transform function to modify the values:
	//	|	// returns "file 'foo.html' is not found in directory '/temp'."
	//	|	dojo.string.substitute(
	//	|		"${0} is not found in ${1}.",
	//	|		["foo.html","/temp"],
	//	|		function(str){
	//	|			// try to figure out the type
	//	|			var prefix = (str.charAt(0) == "/") ? "directory": "file";
	//	|			return prefix + " '" + str + "'";
	//	|		}
	//	|	);
	//	example:
	//		Use a formatter
	//	|	// returns "thinger -- howdy"
	//	|	dojo.string.substitute(
	//	|		"${0:postfix}", ["thinger"], null, {
	//	|			postfix: function(value, key){
	//	|				return value + " -- howdy";
	//	|			}
	//	|		}
	//	|	);

	thisObject = thisObject || dojo.global;
	transform = transform ? 
		dojo.hitch(thisObject, transform) : function(v){ return v; };

	return template.replace(/\$\{([^\s\:\}]+)(?:\:([^\s\:\}]+))?\}/g,
		function(match, key, format){
			var value = dojo.getObject(key, false, map);
			if(format){
				value = dojo.getObject(format, false, thisObject).call(thisObject, value, key);
			}
			return transform(value, key).toString();
		}); // String
};

/*=====
dojo.string.trim = function(str){
	//	summary:
	//		Trims whitespace from both sides of the string
	//	str: String
	//		String to be trimmed
	//	returns: String
	//		Returns the trimmed string
	//	description:
	//		This version of trim() was taken from [Steven Levithan's blog](http://blog.stevenlevithan.com/archives/faster-trim-javascript).
	//		The short yet performant version of this function is dojo.trim(),
	//		which is part of Dojo base.  Uses String.prototype.trim instead, if available.
	return "";	// String
}
=====*/

dojo.string.trim = String.prototype.trim ?
	dojo.trim : // aliasing to the native function
	function(str){
		str = str.replace(/^\s+/, '');
		for(var i = str.length - 1; i >= 0; i--){
			if(/\S/.test(str.charAt(i))){
				str = str.substring(0, i + 1);
				break;
			}
		}
		return str;
	};

}

if(!dojo._hasResource["dojo.date.stamp"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["dojo.date.stamp"] = true;
dojo.provide("dojo.date.stamp");

// Methods to convert dates to or from a wire (string) format using well-known conventions

dojo.date.stamp.fromISOString = function(/*String*/formattedString, /*Number?*/defaultTime){
	//	summary:
	//		Returns a Date object given a string formatted according to a subset of the ISO-8601 standard.
	//
	//	description:
	//		Accepts a string formatted according to a profile of ISO8601 as defined by
	//		[RFC3339](http://www.ietf.org/rfc/rfc3339.txt), except that partial input is allowed.
	//		Can also process dates as specified [by the W3C](http://www.w3.org/TR/NOTE-datetime)
	//		The following combinations are valid:
	//
	//			* dates only
	//			|	* yyyy
	//			|	* yyyy-MM
	//			|	* yyyy-MM-dd
	// 			* times only, with an optional time zone appended
	//			|	* THH:mm
	//			|	* THH:mm:ss
	//			|	* THH:mm:ss.SSS
	// 			* and "datetimes" which could be any combination of the above
	//
	//		timezones may be specified as Z (for UTC) or +/- followed by a time expression HH:mm
	//		Assumes the local time zone if not specified.  Does not validate.  Improperly formatted
	//		input may return null.  Arguments which are out of bounds will be handled
	// 		by the Date constructor (e.g. January 32nd typically gets resolved to February 1st)
	//		Only years between 100 and 9999 are supported.
	//
  	//	formattedString:
	//		A string such as 2005-06-30T08:05:00-07:00 or 2005-06-30 or T08:05:00
	//
	//	defaultTime:
	//		Used for defaults for fields omitted in the formattedString.
	//		Uses 1970-01-01T00:00:00.0Z by default.

	if(!dojo.date.stamp._isoRegExp){
		dojo.date.stamp._isoRegExp =
//TODO: could be more restrictive and check for 00-59, etc.
			/^(?:(\d{4})(?:-(\d{2})(?:-(\d{2}))?)?)?(?:T(\d{2}):(\d{2})(?::(\d{2})(.\d+)?)?((?:[+-](\d{2}):(\d{2}))|Z)?)?$/;
	}

	var match = dojo.date.stamp._isoRegExp.exec(formattedString),
		result = null;

	if(match){
		match.shift();
		if(match[1]){match[1]--;} // Javascript Date months are 0-based
		if(match[6]){match[6] *= 1000;} // Javascript Date expects fractional seconds as milliseconds

		if(defaultTime){
			// mix in defaultTime.  Relatively expensive, so use || operators for the fast path of defaultTime === 0
			defaultTime = new Date(defaultTime);
			dojo.map(["FullYear", "Month", "Date", "Hours", "Minutes", "Seconds", "Milliseconds"], function(prop){
				return defaultTime["get" + prop]();
			}).forEach(function(value, index){
				if(match[index] === undefined){
					match[index] = value;
				}
			});
		}
		result = new Date(match[0]||1970, match[1]||0, match[2]||1, match[3]||0, match[4]||0, match[5]||0, match[6]||0); //TODO: UTC defaults
		if(match[0] < 100){
			result.setFullYear(match[0] || 1970);
		}

		var offset = 0,
			zoneSign = match[7] && match[7].charAt(0);
		if(zoneSign != 'Z'){
			offset = ((match[8] || 0) * 60) + (Number(match[9]) || 0);
			if(zoneSign != '-'){ offset *= -1; }
		}
		if(zoneSign){
			offset -= result.getTimezoneOffset();
		}
		if(offset){
			result.setTime(result.getTime() + offset * 60000);
		}
	}

	return result; // Date or null
}

/*=====
	dojo.date.stamp.__Options = function(){
		//	selector: String
		//		"date" or "time" for partial formatting of the Date object.
		//		Both date and time will be formatted by default.
		//	zulu: Boolean
		//		if true, UTC/GMT is used for a timezone
		//	milliseconds: Boolean
		//		if true, output milliseconds
		this.selector = selector;
		this.zulu = zulu;
		this.milliseconds = milliseconds;
	}
=====*/

dojo.date.stamp.toISOString = function(/*Date*/dateObject, /*dojo.date.stamp.__Options?*/options){
	//	summary:
	//		Format a Date object as a string according a subset of the ISO-8601 standard
	//
	//	description:
	//		When options.selector is omitted, output follows [RFC3339](http://www.ietf.org/rfc/rfc3339.txt)
	//		The local time zone is included as an offset from GMT, except when selector=='time' (time without a date)
	//		Does not check bounds.  Only years between 100 and 9999 are supported.
	//
	//	dateObject:
	//		A Date object

	var _ = function(n){ return (n < 10) ? "0" + n : n; };
	options = options || {};
	var formattedDate = [],
		getter = options.zulu ? "getUTC" : "get",
		date = "";
	if(options.selector != "time"){
		var year = dateObject[getter+"FullYear"]();
		date = ["0000".substr((year+"").length)+year, _(dateObject[getter+"Month"]()+1), _(dateObject[getter+"Date"]())].join('-');
	}
	formattedDate.push(date);
	if(options.selector != "date"){
		var time = [_(dateObject[getter+"Hours"]()), _(dateObject[getter+"Minutes"]()), _(dateObject[getter+"Seconds"]())].join(':');
		var millis = dateObject[getter+"Milliseconds"]();
		if(options.milliseconds){
			time += "."+ (millis < 100 ? "0" : "") + _(millis);
		}
		if(options.zulu){
			time += "Z";
		}else if(options.selector != "time"){
			var timezoneOffset = dateObject.getTimezoneOffset();
			var absOffset = Math.abs(timezoneOffset);
			time += (timezoneOffset > 0 ? "-" : "+") + 
				_(Math.floor(absOffset/60)) + ":" + _(absOffset%60);
		}
		formattedDate.push(time);
	}
	return formattedDate.join('T'); // String
}

}

if(!dojo._hasResource["dojo.parser"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["dojo.parser"] = true;
dojo.provide("dojo.parser");


dojo.parser = new function(){
	// summary: The Dom/Widget parsing package

	var d = dojo;
	this._attrName = d._scopeName + "Type";
	this._query = "[" + this._attrName + "]";

	function val2type(/*Object*/ value){
		// summary:
		//		Returns name of type of given value.

		if(d.isString(value)){ return "string"; }
		if(typeof value == "number"){ return "number"; }
		if(typeof value == "boolean"){ return "boolean"; }
		if(d.isFunction(value)){ return "function"; }
		if(d.isArray(value)){ return "array"; } // typeof [] == "object"
		if(value instanceof Date) { return "date"; } // assume timestamp
		if(value instanceof d._Url){ return "url"; }
		return "object";
	}

	function str2obj(/*String*/ value, /*String*/ type){
		// summary:
		//		Convert given string value to given type
		switch(type){
			case "string":
				return value;
			case "number":
				return value.length ? Number(value) : NaN;
			case "boolean":
				// for checked/disabled value might be "" or "checked".  interpret as true.
				return typeof value == "boolean" ? value : !(value.toLowerCase()=="false");
			case "function":
				if(d.isFunction(value)){
					// IE gives us a function, even when we say something like onClick="foo"
					// (in which case it gives us an invalid function "function(){ foo }"). 
					//  Therefore, convert to string
					value=value.toString();
					value=d.trim(value.substring(value.indexOf('{')+1, value.length-1));
				}
				try{
					if(value.search(/[^\w\.]+/i) != -1){
						// The user has specified some text for a function like "return x+5"
						return new Function(value);
					}else{
						// The user has specified the name of a function like "myOnClick"
						return d.getObject(value, false);
					}
				}catch(e){ return new Function(); }
			case "array":
				return value ? value.split(/\s*,\s*/) : [];
			case "date":
				switch(value){
					case "": return new Date("");	// the NaN of dates
					case "now": return new Date();	// current date
					default: return d.date.stamp.fromISOString(value);
				}
			case "url":
				return d.baseUrl + value;
			default:
				return d.fromJson(value);
		}
	}

	var instanceClasses = {
		// map from fully qualified name (like "dijit.Button") to structure like
		// { cls: dijit.Button, params: {label: "string", disabled: "boolean"} }
	};

	// Widgets like BorderContainer add properties to _Widget via dojo.extend().
	// If BorderContainer is loaded after _Widget's parameter list has been cached,
	// we need to refresh that parameter list (for _Widget and all widgets that extend _Widget).
	dojo.connect(dojo, "extend", function(){
		instanceClasses = {};
	});

	function getClassInfo(/*String*/ className){
		// className:
		//		fully qualified name (like "dijit.form.Button")
		// returns:
		//		structure like
		//			{ 
		//				cls: dijit.Button, 
		//				params: { label: "string", disabled: "boolean"}
		//			}

		if(!instanceClasses[className]){
			// get pointer to widget class
			var cls = d.getObject(className);
			if(!d.isFunction(cls)){
				throw new Error("Could not load class '" + className +
					"'. Did you spell the name correctly and use a full path, like 'dijit.form.Button'?");
			}
			var proto = cls.prototype;
	
			// get table of parameter names & types
			var params = {}, dummyClass = {};
			for(var name in proto){
				if(name.charAt(0)=="_"){ continue; } 	// skip internal properties
				if(name in dummyClass){ continue; }		// skip "constructor" and "toString"
				var defVal = proto[name];
				params[name]=val2type(defVal);
			}

			instanceClasses[className] = { cls: cls, params: params };
		}
		return instanceClasses[className];
	}

	this._functionFromScript = function(script){
		var preamble = "";
		var suffix = "";
		var argsStr = script.getAttribute("args");
		if(argsStr){
			d.forEach(argsStr.split(/\s*,\s*/), function(part, idx){
				preamble += "var "+part+" = arguments["+idx+"]; ";
			});
		}
		var withStr = script.getAttribute("with");
		if(withStr && withStr.length){
			d.forEach(withStr.split(/\s*,\s*/), function(part){
				preamble += "with("+part+"){";
				suffix += "}";
			});
		}
		return new Function(preamble+script.innerHTML+suffix);
	}

	this.instantiate = function(/* Array */nodes, /* Object? */mixin, /* Object? */args){
		// summary:
		//		Takes array of nodes, and turns them into class instances and
		//		potentially calls a layout method to allow them to connect with
		//		any children		
		// mixin: Object?
		//		An object that will be mixed in with each node in the array.
		//		Values in the mixin will override values in the node, if they
		//		exist.
		// args: Object?
		//		An object used to hold kwArgs for instantiation.
		//		Only supports 'noStart' currently.
		var thelist = [], dp = dojo.parser;
		mixin = mixin||{};
		args = args||{};
		
		d.forEach(nodes, function(node){
			if(!node){ return; }
			var type = dp._attrName in mixin?mixin[dp._attrName]:node.getAttribute(dp._attrName);
			if(!type || !type.length){ return; }
			var clsInfo = getClassInfo(type),
				clazz = clsInfo.cls,
				ps = clazz._noScript || clazz.prototype._noScript;

			// read parameters (ie, attributes).
			// clsInfo.params lists expected params like {"checked": "boolean", "n": "number"}
			var params = {},
				attributes = node.attributes;
			for(var name in clsInfo.params){
				var item = name in mixin?{value:mixin[name],specified:true}:attributes.getNamedItem(name);
				if(!item || (!item.specified && (!dojo.isIE || name.toLowerCase()!="value"))){ continue; }
				var value = item.value;
				// Deal with IE quirks for 'class' and 'style'
				switch(name){
				case "class":
					value = "className" in mixin?mixin.className:node.className;
					break;
				case "style":
					value = "style" in mixin?mixin.style:(node.style && node.style.cssText); // FIXME: Opera?
				}
				var _type = clsInfo.params[name];
				if(typeof value == "string"){
					params[name] = str2obj(value, _type);
				}else{
					params[name] = value;
				}
			}

			// Process <script type="dojo/*"> script tags
			// <script type="dojo/method" event="foo"> tags are added to params, and passed to
			// the widget on instantiation.
			// <script type="dojo/method"> tags (with no event) are executed after instantiation
			// <script type="dojo/connect" event="foo"> tags are dojo.connected after instantiation
			// note: dojo/* script tags cannot exist in self closing widgets, like <input />
			if(!ps){
				var connects = [],	// functions to connect after instantiation
					calls = [];		// functions to call after instantiation

				d.query("> script[type^='dojo/']", node).orphan().forEach(function(script){
					var event = script.getAttribute("event"),
						type = script.getAttribute("type"),
						nf = d.parser._functionFromScript(script);
					if(event){
						if(type == "dojo/connect"){
							connects.push({event: event, func: nf});
						}else{
							params[event] = nf;
						}
					}else{
						calls.push(nf);
					}
				});
			}

			var markupFactory = clazz.markupFactory || clazz.prototype && clazz.prototype.markupFactory;
			// create the instance
			var instance = markupFactory ? markupFactory(params, node, clazz) : new clazz(params, node);
			thelist.push(instance);

			// map it to the JS namespace if that makes sense
			var jsname = node.getAttribute("jsId");
			if(jsname){
				d.setObject(jsname, instance);
			}

			// process connections and startup functions
			if(!ps){
				d.forEach(connects, function(connect){
					d.connect(instance, connect.event, null, connect.func);
				});
				d.forEach(calls, function(func){
					func.call(instance);
				});
			}
		});

		// Call startup on each top level instance if it makes sense (as for
		// widgets).  Parent widgets will recursively call startup on their
		// (non-top level) children
		if(!mixin._started){
			d.forEach(thelist, function(instance){
				if(	!args.noStart && instance  && 
					instance.startup &&
					!instance._started && 
					(!instance.getParent || !instance.getParent())
				){
					instance.startup();
				}
			});
		}
		return thelist;
	};

	this.parse = function(/*DomNode?*/ rootNode, /* Object? */ args){
		// summary:
		//		Scan the DOM for class instances, and instantiate them.
		//
		// description:
		//		Search specified node (or root node) recursively for class instances,
		//		and instantiate them Searches for
		//		dojoType="qualified.class.name"
		//
		// rootNode: DomNode?
		//		A default starting root node from which to start the parsing. Can be
		//		omitted, defaulting to the entire document. If omitted, the `args`
		//		object can be passed in this place. If the `args` object has a 
		//		`rootNode` member, that is used.
		//
		// args:
		//		a kwArgs object passed along to instantiate()
		//		
		//			* noStart: Boolean?
		//				when set will prevent the parser from calling .startup()
		//				when locating the nodes. 
		//			* rootNode: DomNode?
		//				identical to the function's `rootNode` argument, though
		//				allowed to be passed in via this `args object. 
		//
		// example:
		//		Parse all widgets on a page:
		//	|		dojo.parser.parse();
		//
		// example:
		//		Parse all classes within the node with id="foo"
		//	|		dojo.parser.parse(dojo.byId(foo));
		//
		// example:
		//		Parse all classes in a page, but do not call .startup() on any 
		//		child
		//	|		dojo.parser.parse({ noStart: true })
		//
		// example:
		//		Parse all classes in a node, but do not call .startup()
		//	|		dojo.parser.parse(someNode, { noStart:true });
		//	|		// or
		// 	|		dojo.parser.parse({ noStart:true, rootNode: someNode });

		// determine the root node based on the passed arguments.
		var root;
		if(!args && rootNode && rootNode.rootNode){
			args = rootNode;
			root = args.rootNode;
		}else{
			root = rootNode;
		}

		var	list = d.query(this._query, root);
			// go build the object instances
		return this.instantiate(list, null, args); // Array

	};
}();

//Register the parser callback. It should be the first callback
//after the a11y test.

(function(){
	var parseRunner = function(){ 
		if(dojo.config.parseOnLoad){
			dojo.parser.parse(); 
		}
	};

	// FIXME: need to clobber cross-dependency!!
	if(dojo.exists("dijit.wai.onload") && (dijit.wai.onload === dojo._loaders[0])){
		dojo._loaders.splice(1, 0, parseRunner);
	}else{
		dojo._loaders.unshift(parseRunner);
	}
})();

}

if(!dojo._hasResource["dojo.cache"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["dojo.cache"] = true;
dojo.provide("dojo.cache");

/*=====
dojo.cache = { 
	// summary:
	// 		A way to cache string content that is fetchable via `dojo.moduleUrl`.
};
=====*/

(function(){
	var cache = {};
	dojo.cache = function(/*String||Object*/module, /*String*/url, /*String||Object?*/value){
		// summary:
		// 		A getter and setter for storing the string content associated with the
		// 		module and url arguments.
		// description:
		// 		module and url are used to call `dojo.moduleUrl()` to generate a module URL.
		// 		If value is specified, the cache value for the moduleUrl will be set to
		// 		that value. Otherwise, dojo.cache will fetch the moduleUrl and store it
		// 		in its internal cache and return that cached value for the URL. To clear
		// 		a cache value pass null for value. Since XMLHttpRequest (XHR) is used to fetch the
		// 		the URL contents, only modules on the same domain of the page can use this capability.
		// 		The build system can inline the cache values though, to allow for xdomain hosting.
		// module: String||Object
		// 		If a String, the module name to use for the base part of the URL, similar to module argument
		// 		to `dojo.moduleUrl`. If an Object, something that has a .toString() method that
		// 		generates a valid path for the cache item. For example, a dojo._Url object.
		// url: String
		// 		The rest of the path to append to the path derived from the module argument. If
		// 		module is an object, then this second argument should be the "value" argument instead.
		// value: String||Object?
		// 		If a String, the value to use in the cache for the module/url combination.
		// 		If an Object, it can have two properties: value and sanitize. The value property
		// 		should be the value to use in the cache, and sanitize can be set to true or false,
		// 		to indicate if XML declarations should be removed from the value and if the HTML
		// 		inside a body tag in the value should be extracted as the real value. The value argument
		// 		or the value property on the value argument are usually only used by the build system
		// 		as it inlines cache content.
		//	example:
		//		To ask dojo.cache to fetch content and store it in the cache (the dojo["cache"] style
		// 		of call is used to avoid an issue with the build system erroneously trying to intern
		// 		this example. To get the build system to intern your dojo.cache calls, use the
		// 		"dojo.cache" style of call):
		// 		|	//If template.html contains "<h1>Hello</h1>" that will be
		// 		|	//the value for the text variable.
		//		|	var text = dojo["cache"]("my.module", "template.html");
		//	example:
		//		To ask dojo.cache to fetch content and store it in the cache, and sanitize the input
		// 		 (the dojo["cache"] style of call is used to avoid an issue with the build system 
		// 		erroneously trying to intern this example. To get the build system to intern your
		// 		dojo.cache calls, use the "dojo.cache" style of call):
		// 		|	//If template.html contains "<html><body><h1>Hello</h1></body></html>", the
		// 		|	//text variable will contain just "<h1>Hello</h1>".
		//		|	var text = dojo["cache"]("my.module", "template.html", {sanitize: true});
		//	example:
		//		Same example as previous, but demostrates how an object can be passed in as
		//		the first argument, then the value argument can then be the second argument.
		// 		|	//If template.html contains "<html><body><h1>Hello</h1></body></html>", the
		// 		|	//text variable will contain just "<h1>Hello</h1>".
		//		|	var text = dojo["cache"](new dojo._Url("my/module/template.html"), {sanitize: true});

		//Module could be a string, or an object that has a toString() method
		//that will return a useful path. If it is an object, then the "url" argument
		//will actually be the value argument.
		if(typeof module == "string"){
			var pathObj = dojo.moduleUrl(module, url);
		}else{
			pathObj = module;
			value = url;
		}
		var key = pathObj.toString();

		var val = value;
		if(value !== undefined && !dojo.isString(value)){
			val = ("value" in value ? value.value : undefined);
		}

		var sanitize = value && value.sanitize ? true : false;

		if(val || val === null){
			//We have a value, either clear or set the cache value.
			if(val == null){
				delete cache[key];
			}else{
				val = cache[key] = sanitize ? dojo.cache._sanitize(val) : val;
			}
		}else{
			//Allow cache values to be empty strings. If key property does
			//not exist, fetch it.
			if(!(key in cache)){
				val = dojo._getText(key);
				cache[key] = sanitize ? dojo.cache._sanitize(val) : val;
			}
			val = cache[key];
		}
		return val; //String
	};

	dojo.cache._sanitize = function(/*String*/val){
		// summary: 
		//		Strips <?xml ...?> declarations so that external SVG and XML
		// 		documents can be added to a document without worry. Also, if the string
		//		is an HTML document, only the part inside the body tag is returned.
		// description:
		// 		Copied from dijit._Templated._sanitizeTemplateString.
		if(val){
			val = val.replace(/^\s*<\?xml(\s)+version=[\'\"](\d)*.(\d)*[\'\"](\s)*\?>/im, "");
			var matches = val.match(/<body[^>]*>\s*([\s\S]+)\s*<\/body>/im);
			if(matches){
				val = matches[1];
			}
		}else{
			val = "";
		}
		return val; //String
	};
})();

}

if(!dojo._hasResource["dijit._Templated"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["dijit._Templated"] = true;
dojo.provide("dijit._Templated");






dojo.declare("dijit._Templated",
	null,
	{
		// summary:
		//		Mixin for widgets that are instantiated from a template

		// templateString: [protected] String
		//		A string that represents the widget template. Pre-empts the
		//		templatePath. In builds that have their strings "interned", the
		//		templatePath is converted to an inline templateString, thereby
		//		preventing a synchronous network call.
		//
		//		Use in conjunction with dojo.cache() to load from a file.
		templateString: null,

		// templatePath: [protected deprecated] String
		//		Path to template (HTML file) for this widget relative to dojo.baseUrl.
		//		Deprecated: use templateString with dojo.cache() instead.
		templatePath: null,

		// widgetsInTemplate: [protected] Boolean
		//		Should we parse the template to find widgets that might be
		//		declared in markup inside it?  False by default.
		widgetsInTemplate: false,

		// skipNodeCache: [protected] Boolean
		//		If using a cached widget template node poses issues for a
		//		particular widget class, it can set this property to ensure
		//		that its template is always re-built from a string
		_skipNodeCache: false,

		// _earlyTemplatedStartup: Boolean
		//		A fallback to preserve the 1.0 - 1.3 behavior of children in
		//		templates having their startup called before the parent widget
		//		fires postCreate. Defaults to 'false', causing child widgets to
		//		have their .startup() called immediately before a parent widget
		//		.startup(), but always after the parent .postCreate(). Set to
		//		'true' to re-enable to previous, arguably broken, behavior.
		_earlyTemplatedStartup: false,

		// _attachPoints: [private] String[]
		//		List of widget attribute names associated with dojoAttachPoint=... in the
		//		template, ex: ["containerNode", "labelNode"]
/*=====
 		_attachPoints: [],
 =====*/

		constructor: function(){
			this._attachPoints = [];
		},

		_stringRepl: function(tmpl){
			// summary:
			//		Does substitution of ${foo} type properties in template string
			// tags:
			//		private
			var className = this.declaredClass, _this = this;
			// Cache contains a string because we need to do property replacement
			// do the property replacement
			return dojo.string.substitute(tmpl, this, function(value, key){
				if(key.charAt(0) == '!'){ value = dojo.getObject(key.substr(1), false, _this); }
				if(typeof value == "undefined"){ throw new Error(className+" template:"+key); } // a debugging aide
				if(value == null){ return ""; }

				// Substitution keys beginning with ! will skip the transform step,
				// in case a user wishes to insert unescaped markup, e.g. ${!foo}
				return key.charAt(0) == "!" ? value :
					// Safer substitution, see heading "Attribute values" in
					// http://www.w3.org/TR/REC-html40/appendix/notes.html#h-B.3.2
					value.toString().replace(/"/g,"&quot;"); //TODO: add &amp? use encodeXML method?
			}, this);
		},

		// method over-ride
		buildRendering: function(){
			// summary:
			//		Construct the UI for this widget from a template, setting this.domNode.
			// tags:
			//		protected

			// Lookup cached version of template, and download to cache if it
			// isn't there already.  Returns either a DomNode or a string, depending on
			// whether or not the template contains ${foo} replacement parameters.
			var cached = dijit._Templated.getCachedTemplate(this.templatePath, this.templateString, this._skipNodeCache);

			var node;
			if(dojo.isString(cached)){
				node = dojo._toDom(this._stringRepl(cached));
				if(node.nodeType != 1){
					// Flag common problems such as templates with multiple top level nodes (nodeType == 11)
					throw new Error("Invalid template: " + cached);
				}
			}else{
				// if it's a node, all we have to do is clone it
				node = cached.cloneNode(true);
			}

			this.domNode = node;

			// recurse through the node, looking for, and attaching to, our
			// attachment points and events, which should be defined on the template node.
			this._attachTemplateNodes(node);

			if(this.widgetsInTemplate){
				// Make sure dojoType is used for parsing widgets in template.
				// The dojo.parser.query could be changed from multiversion support.
				var parser = dojo.parser, qry, attr;
				if(parser._query != "[dojoType]"){
					qry = parser._query;
					attr = parser._attrName;
					parser._query = "[dojoType]";
					parser._attrName = "dojoType";
				}

				// Store widgets that we need to start at a later point in time
				var cw = (this._startupWidgets = dojo.parser.parse(node, {
					noStart: !this._earlyTemplatedStartup
				}));

				// Restore the query.
				if(qry){
					parser._query = qry;
					parser._attrName = attr;
				}

				this._supportingWidgets = dijit.findWidgets(node);

				this._attachTemplateNodes(cw, function(n,p){
					return n[p];
				});
			}

			this._fillContent(this.srcNodeRef);
		},

		_fillContent: function(/*DomNode*/ source){
			// summary:
			//		Relocate source contents to templated container node.
			//		this.containerNode must be able to receive children, or exceptions will be thrown.
			// tags:
			//		protected
			var dest = this.containerNode;
			if(source && dest){
				while(source.hasChildNodes()){
					dest.appendChild(source.firstChild);
				}
			}
		},

		_attachTemplateNodes: function(rootNode, getAttrFunc){
			// summary:
			//		Iterate through the template and attach functions and nodes accordingly.
			// description:
			//		Map widget properties and functions to the handlers specified in
			//		the dom node and it's descendants. This function iterates over all
			//		nodes and looks for these properties:
			//			* dojoAttachPoint
			//			* dojoAttachEvent
			//			* waiRole
			//			* waiState
			// rootNode: DomNode|Array[Widgets]
			//		the node to search for properties. All children will be searched.
			// getAttrFunc: Function?
			//		a function which will be used to obtain property for a given
			//		DomNode/Widget
			// tags:
			//		private

			getAttrFunc = getAttrFunc || function(n,p){ return n.getAttribute(p); };

			var nodes = dojo.isArray(rootNode) ? rootNode : (rootNode.all || rootNode.getElementsByTagName("*"));
			var x = dojo.isArray(rootNode) ? 0 : -1;
			for(; x<nodes.length; x++){
				var baseNode = (x == -1) ? rootNode : nodes[x];
				if(this.widgetsInTemplate && getAttrFunc(baseNode, "dojoType")){
					continue;
				}
				// Process dojoAttachPoint
				var attachPoint = getAttrFunc(baseNode, "dojoAttachPoint");
				if(attachPoint){
					var point, points = attachPoint.split(/\s*,\s*/);
					while((point = points.shift())){
						if(dojo.isArray(this[point])){
							this[point].push(baseNode);
						}else{
							this[point]=baseNode;
						}
						this._attachPoints.push(point);
					}
				}

				// Process dojoAttachEvent
				var attachEvent = getAttrFunc(baseNode, "dojoAttachEvent");
				if(attachEvent){
					// NOTE: we want to support attributes that have the form
					// "domEvent: nativeEvent; ..."
					var event, events = attachEvent.split(/\s*,\s*/);
					var trim = dojo.trim;
					while((event = events.shift())){
						if(event){
							var thisFunc = null;
							if(event.indexOf(":") != -1){
								// oh, if only JS had tuple assignment
								var funcNameArr = event.split(":");
								event = trim(funcNameArr[0]);
								thisFunc = trim(funcNameArr[1]);
							}else{
								event = trim(event);
							}
							if(!thisFunc){
								thisFunc = event;
							}
							this.connect(baseNode, event, thisFunc);
						}
					}
				}

				// waiRole, waiState
				var role = getAttrFunc(baseNode, "waiRole");
				if(role){
					dijit.setWaiRole(baseNode, role);
				}
				var values = getAttrFunc(baseNode, "waiState");
				if(values){
					dojo.forEach(values.split(/\s*,\s*/), function(stateValue){
						if(stateValue.indexOf('-') != -1){
							var pair = stateValue.split('-');
							dijit.setWaiState(baseNode, pair[0], pair[1]);
						}
					});
				}
			}
		},

		startup: function(){
			dojo.forEach(this._startupWidgets, function(w){
				if(w && !w._started && w.startup){
					w.startup();
				}
			});
			this.inherited(arguments);
		},

		destroyRendering: function(){
			// Delete all attach points to prevent IE6 memory leaks.
			dojo.forEach(this._attachPoints, function(point){
				delete this[point];
			}, this);
			this._attachPoints = [];

			this.inherited(arguments);
		}
	}
);

// key is either templatePath or templateString; object is either string or DOM tree
dijit._Templated._templateCache = {};

dijit._Templated.getCachedTemplate = function(templatePath, templateString, alwaysUseString){
	// summary:
	//		Static method to get a template based on the templatePath or
	//		templateString key
	// templatePath: String||dojo.uri.Uri
	//		The URL to get the template from.
	// templateString: String?
	//		a string to use in lieu of fetching the template from a URL. Takes precedence
	//		over templatePath
	// returns: Mixed
	//		Either string (if there are ${} variables that need to be replaced) or just
	//		a DOM tree (if the node can be cloned directly)

	// is it already cached?
	var tmplts = dijit._Templated._templateCache;
	var key = templateString || templatePath;
	var cached = tmplts[key];
	if(cached){
		try{
			// if the cached value is an innerHTML string (no ownerDocument) or a DOM tree created within the current document, then use the current cached value
			if(!cached.ownerDocument || cached.ownerDocument == dojo.doc){
				// string or node of the same document
				return cached;
			}
		}catch(e){ /* squelch */ } // IE can throw an exception if cached.ownerDocument was reloaded
		dojo.destroy(cached);
	}

	// If necessary, load template string from template path
	if(!templateString){
		templateString = dojo.cache(templatePath, {sanitize: true});
	}
	templateString = dojo.string.trim(templateString);

	if(alwaysUseString || templateString.match(/\$\{([^\}]+)\}/g)){
		// there are variables in the template so all we can do is cache the string
		return (tmplts[key] = templateString); //String
	}else{
		// there are no variables in the template so we can cache the DOM tree
		var node = dojo._toDom(templateString);
		if(node.nodeType != 1){
			throw new Error("Invalid template: " + templateString);
		}
		return (tmplts[key] = node); //Node
	}
};

if(dojo.isIE){
	dojo.addOnWindowUnload(function(){
		var cache = dijit._Templated._templateCache;
		for(var key in cache){
			var value = cache[key];
			if(typeof value == "object"){ // value is either a string or a DOM node template
				dojo.destroy(value);
			}
			delete cache[key];
		}
	});
}

// These arguments can be specified for widgets which are used in templates.
// Since any widget can be specified as sub widgets in template, mix it
// into the base widget class.  (This is a hack, but it's effective.)
dojo.extend(dijit._Widget,{
	dojoAttachEvent: "",
	dojoAttachPoint: "",
	waiRole: "",
	waiState:""
});

}

if(!dojo._hasResource["dijit.form._FormWidget"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["dijit.form._FormWidget"] = true;
dojo.provide("dijit.form._FormWidget");




dojo.declare("dijit.form._FormWidget", [dijit._Widget, dijit._Templated],
	{
	// summary:
	//		Base class for widgets corresponding to native HTML elements such as <checkbox> or <button>,
	//		which can be children of a <form> node or a `dijit.form.Form` widget.
	//
	// description:
	//		Represents a single HTML element.
	//		All these widgets should have these attributes just like native HTML input elements.
	//		You can set them during widget construction or afterwards, via `dijit._Widget.attr`.
	//
	//		They also share some common methods.

	// baseClass: [protected] String
	//		Root CSS class of the widget (ex: dijitTextBox), used to add CSS classes of widget
	//		(ex: "dijitTextBox dijitTextBoxInvalid dijitTextBoxFocused dijitTextBoxInvalidFocused")
	//		See _setStateClass().
	baseClass: "",

	// name: String
	//		Name used when submitting form; same as "name" attribute or plain HTML elements
	name: "",

	// alt: String
	//		Corresponds to the native HTML <input> element's attribute.
	alt: "",

	// value: String
	//		Corresponds to the native HTML <input> element's attribute.
	value: "",

	// type: String
	//		Corresponds to the native HTML <input> element's attribute.
	type: "text",

	// tabIndex: Integer
	//		Order fields are traversed when user hits the tab key
	tabIndex: "0",

	// disabled: Boolean
	//		Should this widget respond to user input?
	//		In markup, this is specified as "disabled='disabled'", or just "disabled".
	disabled: false,

	// intermediateChanges: Boolean
	//		Fires onChange for each value change or only on demand
	intermediateChanges: false,

	// scrollOnFocus: Boolean
	//		On focus, should this widget scroll into view?
	scrollOnFocus: true,

	// These mixins assume that the focus node is an INPUT, as many but not all _FormWidgets are.
	attributeMap: dojo.delegate(dijit._Widget.prototype.attributeMap, {
		value: "focusNode",
		id: "focusNode",
		tabIndex: "focusNode",
		alt: "focusNode",
		title: "focusNode"
	}),

	postMixInProperties: function(){
		// Setup name=foo string to be referenced from the template (but only if a name has been specified)
		// Unfortunately we can't use attributeMap to set the name due to IE limitations, see #8660
		this.nameAttrSetting = this.name ? ("name='" + this.name + "'") : "";
		this.inherited(arguments);
	},

	_setDisabledAttr: function(/*Boolean*/ value){
		this.disabled = value;
		dojo.attr(this.focusNode, 'disabled', value);
		if(this.valueNode){
			dojo.attr(this.valueNode, 'disabled', value);
		}
		dijit.setWaiState(this.focusNode, "disabled", value);

		if(value){
			// reset those, because after the domNode is disabled, we can no longer receive
			// mouse related events, see #4200
			this._hovering = false;
			this._active = false;
			// remove the tabIndex, especially for FF
			this.focusNode.setAttribute('tabIndex', "-1");
		}else{
			this.focusNode.setAttribute('tabIndex', this.tabIndex);
		}
		this._setStateClass();
	},

	setDisabled: function(/*Boolean*/ disabled){
		// summary:
		//		Deprecated.   Use attr('disabled', ...) instead.
		dojo.deprecated("setDisabled("+disabled+") is deprecated. Use attr('disabled',"+disabled+") instead.", "", "2.0");
		this.attr('disabled', disabled);
	},

	_onFocus: function(e){
		if(this.scrollOnFocus){
			dijit.scrollIntoView(this.domNode);
		}
		this.inherited(arguments);
	},

	_onMouse : function(/*Event*/ event){
		// summary:
		//	Sets _hovering, _active, and stateModifier properties depending on mouse state,
		//	then calls setStateClass() to set appropriate CSS classes for this.domNode.
		//
		//	To get a different CSS class for hover, send onmouseover and onmouseout events to this method.
		//	To get a different CSS class while mouse button is depressed, send onmousedown to this method.

		var mouseNode = event.currentTarget;
		if(mouseNode && mouseNode.getAttribute){
			this.stateModifier = mouseNode.getAttribute("stateModifier") || "";
		}

		if(!this.disabled){
			switch(event.type){
				case "mouseenter":
				case "mouseover":
					this._hovering = true;
					this._active = this._mouseDown;
					break;

				case "mouseout":
				case "mouseleave":
					this._hovering = false;
					this._active = false;
					break;

				case "mousedown" :
					this._active = true;
					this._mouseDown = true;
					// set a global event to handle mouseup, so it fires properly
					//	even if the cursor leaves the button
					var mouseUpConnector = this.connect(dojo.body(), "onmouseup", function(){
						// if user clicks on the button, even if the mouse is released outside of it,
						// this button should get focus (which mimics native browser buttons)
						if(this._mouseDown && this.isFocusable()){
							this.focus();
						}
						this._active = false;
						this._mouseDown = false;
						this._setStateClass();
						this.disconnect(mouseUpConnector);
					});
					break;
			}
			this._setStateClass();
		}
	},

	isFocusable: function(){
		// summary:
		//		Tells if this widget is focusable or not.   Used internally by dijit.
		// tags:
		//		protected
		return !this.disabled && !this.readOnly && this.focusNode && (dojo.style(this.domNode, "display") != "none");
	},

	focus: function(){
		// summary:
		//		Put focus on this widget
		dijit.focus(this.focusNode);
	},

	_setStateClass: function(){
		// summary:
		//		Update the visual state of the widget by setting the css classes on this.domNode
		//		(or this.stateNode if defined) by combining this.baseClass with
		//		various suffixes that represent the current widget state(s).
		//
		// description:
		//		In the case where a widget has multiple
		//		states, it sets the class based on all possible
		//	 	combinations.  For example, an invalid form widget that is being hovered
		//		will be "dijitInput dijitInputInvalid dijitInputHover dijitInputInvalidHover".
		//
		//		For complex widgets with multiple regions, there can be various hover/active states,
		//		such as "Hover" or "CloseButtonHover" (for tab buttons).
		//		This is controlled by a stateModifier="CloseButton" attribute on the close button node.
		//
		//		The widget may have one or more of the following states, determined
		//		by this.state, this.checked, this.valid, and this.selected:
		//			- Error - ValidationTextBox sets this.state to "Error" if the current input value is invalid
		//			- Checked - ex: a checkmark or a ToggleButton in a checked state, will have this.checked==true
		//			- Selected - ex: currently selected tab will have this.selected==true
		//
		//		In addition, it may have one or more of the following states,
		//		based on this.disabled and flags set in _onMouse (this._active, this._hovering, this._focused):
		//			- Disabled	- if the widget is disabled
		//			- Active		- if the mouse (or space/enter key?) is being pressed down
		//			- Focused		- if the widget has focus
		//			- Hover		- if the mouse is over the widget

		// Compute new set of classes
		var newStateClasses = this.baseClass.split(" ");

		function multiply(modifier){
			newStateClasses = newStateClasses.concat(dojo.map(newStateClasses, function(c){ return c+modifier; }), "dijit"+modifier);
		}

		if(this.checked){
			multiply("Checked");
		}
		if(this.state){
			multiply(this.state);
		}
		if(this.selected){
			multiply("Selected");
		}

		if(this.disabled){
			multiply("Disabled");
		}else if(this.readOnly){
			multiply("ReadOnly");
		}else if(this._active){
			multiply(this.stateModifier+"Active");
		}else{
			if(this._focused){
				multiply("Focused");
			}
			if(this._hovering){
				multiply(this.stateModifier+"Hover");
			}
		}

		// Remove old state classes and add new ones.
		// For performance concerns we only write into domNode.className once.
		var tn = this.stateNode || this.domNode,
			classHash = {};	// set of all classes (state and otherwise) for node

		dojo.forEach(tn.className.split(" "), function(c){ classHash[c] = true; });

		if("_stateClasses" in this){
			dojo.forEach(this._stateClasses, function(c){ delete classHash[c]; });
		}

		dojo.forEach(newStateClasses, function(c){ classHash[c] = true; });

		var newClasses = [];
		for(var c in classHash){
			newClasses.push(c);
		}
		tn.className = newClasses.join(" ");

		this._stateClasses = newStateClasses;
	},

	compare: function(/*anything*/val1, /*anything*/val2){
		// summary:
		//		Compare 2 values (as returned by attr('value') for this widget).
		// tags:
		//		protected
		if(typeof val1 == "number" && typeof val2 == "number"){
			return (isNaN(val1) && isNaN(val2)) ? 0 : val1 - val2;
		}else if(val1 > val2){
			return 1;
		}else if(val1 < val2){
			return -1;
		}else{
			return 0;
		}
	},

	onChange: function(newValue){
		// summary:
		//		Callback when this widget's value is changed.
		// tags:
		//		callback
	},

	// _onChangeActive: [private] Boolean
	//		Indicates that changes to the value should call onChange() callback.
	//		This is false during widget initialization, to avoid calling onChange()
	//		when the initial value is set.
	_onChangeActive: false,

	_handleOnChange: function(/*anything*/ newValue, /* Boolean? */ priorityChange){
		// summary:
		//		Called when the value of the widget is set.  Calls onChange() if appropriate
		// newValue:
		//		the new value
		// priorityChange:
		//		For a slider, for example, dragging the slider is priorityChange==false,
		//		but on mouse up, it's priorityChange==true.  If intermediateChanges==true,
		//		onChange is only called form priorityChange=true events.
		// tags:
		//		private
		this._lastValue = newValue;
		if(this._lastValueReported == undefined && (priorityChange === null || !this._onChangeActive)){
			// this block executes not for a change, but during initialization,
			// and is used to store away the original value (or for ToggleButton, the original checked state)
			this._resetValue = this._lastValueReported = newValue;
		}
		if((this.intermediateChanges || priorityChange || priorityChange === undefined) &&
			((typeof newValue != typeof this._lastValueReported) ||
				this.compare(newValue, this._lastValueReported) != 0)){
			this._lastValueReported = newValue;
			if(this._onChangeActive){
				if(this._onChangeHandle){
					clearTimeout(this._onChangeHandle);
				}
				// setTimout allows hidden value processing to run and
				// also the onChange handler can safely adjust focus, etc
				this._onChangeHandle = setTimeout(dojo.hitch(this,
					function(){
						this._onChangeHandle = null;
						this.onChange(newValue);
					}), 0); // try to collapse multiple onChange's fired faster than can be processed
			}
		}
	},

	create: function(){
		// Overrides _Widget.create()
		this.inherited(arguments);
		this._onChangeActive = true;
		this._setStateClass();
	},

	destroy: function(){
		if(this._onChangeHandle){ // destroy called before last onChange has fired
			clearTimeout(this._onChangeHandle);
			this.onChange(this._lastValueReported);
		}
		this.inherited(arguments);
	},

	setValue: function(/*String*/ value){
		// summary:
		//		Deprecated.   Use attr('value', ...) instead.
		dojo.deprecated("dijit.form._FormWidget:setValue("+value+") is deprecated.  Use attr('value',"+value+") instead.", "", "2.0");
		this.attr('value', value);
	},

	getValue: function(){
		// summary:
		//		Deprecated.   Use attr('value') instead.
		dojo.deprecated(this.declaredClass+"::getValue() is deprecated. Use attr('value') instead.", "", "2.0");
		return this.attr('value');
	}
});

dojo.declare("dijit.form._FormValueWidget", dijit.form._FormWidget,
{
	// summary:
	//		Base class for widgets corresponding to native HTML elements such as <input> or <select> that have user changeable values.
	// description:
	//		Each _FormValueWidget represents a single input value, and has a (possibly hidden) <input> element,
	//		to which it serializes it's input value, so that form submission (either normal submission or via FormBind?)
	//		works as expected.

	// Don't attempt to mixin the 'type', 'name' attributes here programatically -- they must be declared
	// directly in the template as read by the parser in order to function. IE is known to specifically
	// require the 'name' attribute at element creation time.   See #8484, #8660.
	// TODO: unclear what that {value: ""} is for; FormWidget.attributeMap copies value to focusNode,
	// so maybe {value: ""} is so the value *doesn't* get copied to focusNode?
	// Seems like we really want value removed from attributeMap altogether
	// (although there's no easy way to do that now)

	// readOnly: Boolean
	//		Should this widget respond to user input?
	//		In markup, this is specified as "readOnly".
	//		Similar to disabled except readOnly form values are submitted.
	readOnly: false,

	attributeMap: dojo.delegate(dijit.form._FormWidget.prototype.attributeMap, {
		value: "",
		readOnly: "focusNode"
	}),

	_setReadOnlyAttr: function(/*Boolean*/ value){
		this.readOnly = value;
		dojo.attr(this.focusNode, 'readOnly', value);
		dijit.setWaiState(this.focusNode, "readonly", value);
		this._setStateClass();
	},

	postCreate: function(){
		if(dojo.isIE){ // IE won't stop the event with keypress
			this.connect(this.focusNode || this.domNode, "onkeydown", this._onKeyDown);
		}
		// Update our reset value if it hasn't yet been set (because this.attr
		// is only called when there *is* a value
		if(this._resetValue === undefined){
			this._resetValue = this.value;
		}
	},

	_setValueAttr: function(/*anything*/ newValue, /*Boolean, optional*/ priorityChange){
		// summary:
		//		Hook so attr('value', value) works.
		// description:
		//		Sets the value of the widget.
		//		If the value has changed, then fire onChange event, unless priorityChange
		//		is specified as null (or false?)
		this.value = newValue;
		this._handleOnChange(newValue, priorityChange);
	},

	_getValueAttr: function(){
		// summary:
		//		Hook so attr('value') works.
		return this._lastValue;
	},

	undo: function(){
		// summary:
		//		Restore the value to the last value passed to onChange
		this._setValueAttr(this._lastValueReported, false);
	},

	reset: function(){
		// summary:
		//		Reset the widget's value to what it was at initialization time
		this._hasBeenBlurred = false;
		this._setValueAttr(this._resetValue, true);
	},

	_onKeyDown: function(e){
		if(e.keyCode == dojo.keys.ESCAPE && !(e.ctrlKey || e.altKey || e.metaKey)){
			var te;
			if(dojo.isIE){
				e.preventDefault(); // default behavior needs to be stopped here since keypress is too late
				te = document.createEventObject();
				te.keyCode = dojo.keys.ESCAPE;
				te.shiftKey = e.shiftKey;
				e.srcElement.fireEvent('onkeypress', te);
			}
		}
	},

	_layoutHackIE7: function(){
		// summary:
		//		Work around table sizing bugs on IE7 by forcing redraw

		if(dojo.isIE == 7){ // fix IE7 layout bug when the widget is scrolled out of sight
			var domNode = this.domNode;
			var parent = domNode.parentNode;
			var pingNode = domNode.firstChild || domNode; // target node most unlikely to have a custom filter
			var origFilter = pingNode.style.filter; // save custom filter, most likely nothing
			while(parent && parent.clientHeight == 0){ // search for parents that haven't rendered yet
				parent._disconnectHandle = this.connect(parent, "onscroll", dojo.hitch(this, function(e){
					this.disconnect(parent._disconnectHandle); // only call once
					parent.removeAttribute("_disconnectHandle"); // clean up DOM node
					pingNode.style.filter = (new Date()).getMilliseconds(); // set to anything that's unique
					setTimeout(function(){ pingNode.style.filter = origFilter }, 0); // restore custom filter, if any
				}));
				parent = parent.parentNode;
			}
		}
	}
});

}

if(!dojo._hasResource["dojo.dnd.common"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["dojo.dnd.common"] = true;
dojo.provide("dojo.dnd.common");

dojo.dnd.getCopyKeyState = dojo.isCopyKey;

dojo.dnd._uniqueId = 0;
dojo.dnd.getUniqueId = function(){
	// summary:
	//		returns a unique string for use with any DOM element
	var id;
	do{
		id = dojo._scopeName + "Unique" + (++dojo.dnd._uniqueId);
	}while(dojo.byId(id));
	return id;
};

dojo.dnd._empty = {};

dojo.dnd.isFormElement = function(/*Event*/ e){
	// summary:
	//		returns true if user clicked on a form element
	var t = e.target;
	if(t.nodeType == 3 /*TEXT_NODE*/){
		t = t.parentNode;
	}
	return " button textarea input select option ".indexOf(" " + t.tagName.toLowerCase() + " ") >= 0;	// Boolean
};

}

if(!dojo._hasResource["dojo.dnd.autoscroll"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["dojo.dnd.autoscroll"] = true;
dojo.provide("dojo.dnd.autoscroll");

dojo.dnd.getViewport = function(){
	// summary:
	//		Returns a viewport size (visible part of the window)

	// TODO: remove this when getViewport() moved to dojo core, see #7028

	// FIXME: need more docs!!
	var d = dojo.doc, dd = d.documentElement, w = window, b = dojo.body();
	if(dojo.isMozilla){
		return {w: dd.clientWidth, h: w.innerHeight};	// Object
	}else if(!dojo.isOpera && w.innerWidth){
		return {w: w.innerWidth, h: w.innerHeight};		// Object
	}else if (!dojo.isOpera && dd && dd.clientWidth){
		return {w: dd.clientWidth, h: dd.clientHeight};	// Object
	}else if (b.clientWidth){
		return {w: b.clientWidth, h: b.clientHeight};	// Object
	}
	return null;	// Object
};

dojo.dnd.V_TRIGGER_AUTOSCROLL = 32;
dojo.dnd.H_TRIGGER_AUTOSCROLL = 32;

dojo.dnd.V_AUTOSCROLL_VALUE = 16;
dojo.dnd.H_AUTOSCROLL_VALUE = 16;

dojo.dnd.autoScroll = function(e){
	// summary:
	//		a handler for onmousemove event, which scrolls the window, if
	//		necesary
	// e: Event
	//		onmousemove event

	// FIXME: needs more docs!
	var v = dojo.dnd.getViewport(), dx = 0, dy = 0;
	if(e.clientX < dojo.dnd.H_TRIGGER_AUTOSCROLL){
		dx = -dojo.dnd.H_AUTOSCROLL_VALUE;
	}else if(e.clientX > v.w - dojo.dnd.H_TRIGGER_AUTOSCROLL){
		dx = dojo.dnd.H_AUTOSCROLL_VALUE;
	}
	if(e.clientY < dojo.dnd.V_TRIGGER_AUTOSCROLL){
		dy = -dojo.dnd.V_AUTOSCROLL_VALUE;
	}else if(e.clientY > v.h - dojo.dnd.V_TRIGGER_AUTOSCROLL){
		dy = dojo.dnd.V_AUTOSCROLL_VALUE;
	}
	window.scrollBy(dx, dy);
};

dojo.dnd._validNodes = {"div": 1, "p": 1, "td": 1};
dojo.dnd._validOverflow = {"auto": 1, "scroll": 1};

dojo.dnd.autoScrollNodes = function(e){
	// summary:
	//		a handler for onmousemove event, which scrolls the first avaialble
	//		Dom element, it falls back to dojo.dnd.autoScroll()
	// e: Event
	//		onmousemove event

	// FIXME: needs more docs!
	for(var n = e.target; n;){
		if(n.nodeType == 1 && (n.tagName.toLowerCase() in dojo.dnd._validNodes)){
			var s = dojo.getComputedStyle(n);
			if(s.overflow.toLowerCase() in dojo.dnd._validOverflow){
				var b = dojo._getContentBox(n, s), t = dojo.position(n, true);
				//console.log(b.l, b.t, t.x, t.y, n.scrollLeft, n.scrollTop);
				var w = Math.min(dojo.dnd.H_TRIGGER_AUTOSCROLL, b.w / 2), 
					h = Math.min(dojo.dnd.V_TRIGGER_AUTOSCROLL, b.h / 2),
					rx = e.pageX - t.x, ry = e.pageY - t.y, dx = 0, dy = 0;
				if(dojo.isWebKit || dojo.isOpera){
					// FIXME: this code should not be here, it should be taken into account 
					// either by the event fixing code, or the dojo.position()
					// FIXME: this code doesn't work on Opera 9.5 Beta
					rx += dojo.body().scrollLeft, ry += dojo.body().scrollTop;
				}
				if(rx > 0 && rx < b.w){
					if(rx < w){
						dx = -w;
					}else if(rx > b.w - w){
						dx = w;
					}
				}
				//console.log("ry =", ry, "b.h =", b.h, "h =", h);
				if(ry > 0 && ry < b.h){
					if(ry < h){
						dy = -h;
					}else if(ry > b.h - h){
						dy = h;
					}
				}
				var oldLeft = n.scrollLeft, oldTop = n.scrollTop;
				n.scrollLeft = n.scrollLeft + dx;
				n.scrollTop  = n.scrollTop  + dy;
				if(oldLeft != n.scrollLeft || oldTop != n.scrollTop){ return; }
			}
		}
		try{
			n = n.parentNode;
		}catch(x){
			n = null;
		}
	}
	dojo.dnd.autoScroll(e);
};

}

if(!dojo._hasResource["dojo.dnd.Mover"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["dojo.dnd.Mover"] = true;
dojo.provide("dojo.dnd.Mover");




dojo.declare("dojo.dnd.Mover", null, {
	constructor: function(node, e, host){
		// summary:
		//		an object, which makes a node follow the mouse. 
		//		Used as a default mover, and as a base class for custom movers.
		// node: Node
		//		a node (or node's id) to be moved
		// e: Event
		//		a mouse event, which started the move;
		//		only pageX and pageY properties are used
		// host: Object?
		//		object which implements the functionality of the move,
		//	 	and defines proper events (onMoveStart and onMoveStop)
		this.node = dojo.byId(node);
		this.marginBox = {l: e.pageX, t: e.pageY};
		this.mouseButton = e.button;
		var h = this.host = host, d = node.ownerDocument, 
			firstEvent = dojo.connect(d, "onmousemove", this, "onFirstMove");
		this.events = [
			dojo.connect(d, "onmousemove", this, "onMouseMove"),
			dojo.connect(d, "onmouseup",   this, "onMouseUp"),
			// cancel text selection and text dragging
			dojo.connect(d, "ondragstart",   dojo.stopEvent),
			dojo.connect(d.body, "onselectstart", dojo.stopEvent),
			firstEvent
		];
		// notify that the move has started
		if(h && h.onMoveStart){
			h.onMoveStart(this);
		}
	},
	// mouse event processors
	onMouseMove: function(e){
		// summary:
		//		event processor for onmousemove
		// e: Event
		//		mouse event
		dojo.dnd.autoScroll(e);
		var m = this.marginBox;
		this.host.onMove(this, {l: m.l + e.pageX, t: m.t + e.pageY});
		dojo.stopEvent(e);
	},
	onMouseUp: function(e){
		if(dojo.isWebKit && dojo.isMac && this.mouseButton == 2 ? 
				e.button == 0 : this.mouseButton == e.button){
			this.destroy();
		}
		dojo.stopEvent(e);
	},
	// utilities
	onFirstMove: function(){
		// summary:
		//		makes the node absolute; it is meant to be called only once. 
		// 		relative and absolutely positioned nodes are assumed to use pixel units
		var s = this.node.style, l, t, h = this.host;
		switch(s.position){
			case "relative":
			case "absolute":
				// assume that left and top values are in pixels already
				l = Math.round(parseFloat(s.left));
				t = Math.round(parseFloat(s.top));
				break;
			default:
				s.position = "absolute";	// enforcing the absolute mode
				var m = dojo.marginBox(this.node);
				// event.pageX/pageY (which we used to generate the initial
				// margin box) includes padding and margin set on the body.
				// However, setting the node's position to absolute and then
				// doing dojo.marginBox on it *doesn't* take that additional
				// space into account - so we need to subtract the combined
				// padding and margin.  We use getComputedStyle and
				// _getMarginBox/_getContentBox to avoid the extra lookup of
				// the computed style. 
				var b = dojo.doc.body;
				var bs = dojo.getComputedStyle(b);
				var bm = dojo._getMarginBox(b, bs);
				var bc = dojo._getContentBox(b, bs);
				l = m.l - (bc.l - bm.l);
				t = m.t - (bc.t - bm.t);
				break;
		}
		this.marginBox.l = l - this.marginBox.l;
		this.marginBox.t = t - this.marginBox.t;
		if(h && h.onFirstMove){
			h.onFirstMove(this);
		}
		dojo.disconnect(this.events.pop());
	},
	destroy: function(){
		// summary:
		//		stops the move, deletes all references, so the object can be garbage-collected
		dojo.forEach(this.events, dojo.disconnect);
		// undo global settings
		var h = this.host;
		if(h && h.onMoveStop){
			h.onMoveStop(this);
		}
		// destroy objects
		this.events = this.node = this.host = null;
	}
});

}

if(!dojo._hasResource["dojo.dnd.Moveable"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["dojo.dnd.Moveable"] = true;
dojo.provide("dojo.dnd.Moveable");



/*=====
dojo.declare("dojo.dnd.__MoveableArgs", [], {
	// handle: Node||String
	//		A node (or node's id), which is used as a mouse handle.
	//		If omitted, the node itself is used as a handle.
	handle: null,

	// delay: Number
	//		delay move by this number of pixels
	delay: 0,

	// skip: Boolean
	//		skip move of form elements
	skip: false,

	// mover: Object
	//		a constructor of custom Mover
	mover: dojo.dnd.Mover
});
=====*/

dojo.declare("dojo.dnd.Moveable", null, {
	// object attributes (for markup)
	handle: "",
	delay: 0,
	skip: false,
	
	constructor: function(node, params){
		// summary:
		//		an object, which makes a node moveable
		// node: Node
		//		a node (or node's id) to be moved
		// params: dojo.dnd.__MoveableArgs?
		//		optional parameters
		this.node = dojo.byId(node);
		if(!params){ params = {}; }
		this.handle = params.handle ? dojo.byId(params.handle) : null;
		if(!this.handle){ this.handle = this.node; }
		this.delay = params.delay > 0 ? params.delay : 0;
		this.skip  = params.skip;
		this.mover = params.mover ? params.mover : dojo.dnd.Mover;
		this.events = [
			dojo.connect(this.handle, "onmousedown", this, "onMouseDown"),
			// cancel text selection and text dragging
			dojo.connect(this.handle, "ondragstart",   this, "onSelectStart"),
			dojo.connect(this.handle, "onselectstart", this, "onSelectStart")
		];
	},

	// markup methods
	markupFactory: function(params, node){
		return new dojo.dnd.Moveable(node, params);
	},

	// methods
	destroy: function(){
		// summary:
		//		stops watching for possible move, deletes all references, so the object can be garbage-collected
		dojo.forEach(this.events, dojo.disconnect);
		this.events = this.node = this.handle = null;
	},
	
	// mouse event processors
	onMouseDown: function(e){
		// summary:
		//		event processor for onmousedown, creates a Mover for the node
		// e: Event
		//		mouse event
		if(this.skip && dojo.dnd.isFormElement(e)){ return; }
		if(this.delay){
			this.events.push(
				dojo.connect(this.handle, "onmousemove", this, "onMouseMove"),
				dojo.connect(this.handle, "onmouseup", this, "onMouseUp")
			);
			this._lastX = e.pageX;
			this._lastY = e.pageY;
		}else{
			this.onDragDetected(e);
		}
		dojo.stopEvent(e);
	},
	onMouseMove: function(e){
		// summary:
		//		event processor for onmousemove, used only for delayed drags
		// e: Event
		//		mouse event
		if(Math.abs(e.pageX - this._lastX) > this.delay || Math.abs(e.pageY - this._lastY) > this.delay){
			this.onMouseUp(e);
			this.onDragDetected(e);
		}
		dojo.stopEvent(e);
	},
	onMouseUp: function(e){
		// summary:
		//		event processor for onmouseup, used only for delayed drags
		// e: Event
		//		mouse event
		for(var i = 0; i < 2; ++i){
			dojo.disconnect(this.events.pop());
		}
		dojo.stopEvent(e);
	},
	onSelectStart: function(e){
		// summary:
		//		event processor for onselectevent and ondragevent
		// e: Event
		//		mouse event
		if(!this.skip || !dojo.dnd.isFormElement(e)){
			dojo.stopEvent(e);
		}
	},
	
	// local events
	onDragDetected: function(/* Event */ e){
		// summary:
		//		called when the drag is detected;
		//		responsible for creation of the mover
		new this.mover(this.node, e, this);
	},
	onMoveStart: function(/* dojo.dnd.Mover */ mover){
		// summary:
		//		called before every move operation
		dojo.publish("/dnd/move/start", [mover]);
		dojo.addClass(dojo.body(), "dojoMove"); 
		dojo.addClass(this.node, "dojoMoveItem"); 
	},
	onMoveStop: function(/* dojo.dnd.Mover */ mover){
		// summary:
		//		called after every move operation
		dojo.publish("/dnd/move/stop", [mover]);
		dojo.removeClass(dojo.body(), "dojoMove");
		dojo.removeClass(this.node, "dojoMoveItem");
	},
	onFirstMove: function(/* dojo.dnd.Mover */ mover){
		// summary:
		//		called during the very first move notification;
		//		can be used to initialize coordinates, can be overwritten.
		
		// default implementation does nothing
	},
	onMove: function(/* dojo.dnd.Mover */ mover, /* Object */ leftTop){
		// summary:
		//		called during every move notification;
		//		should actually move the node; can be overwritten.
		this.onMoving(mover, leftTop);
		var s = mover.node.style;
		s.left = leftTop.l + "px";
		s.top  = leftTop.t + "px";
		this.onMoved(mover, leftTop);
	},
	onMoving: function(/* dojo.dnd.Mover */ mover, /* Object */ leftTop){
		// summary:
		//		called before every incremental move; can be overwritten.
		
		// default implementation does nothing
	},
	onMoved: function(/* dojo.dnd.Mover */ mover, /* Object */ leftTop){
		// summary:
		//		called after every incremental move; can be overwritten.
		
		// default implementation does nothing
	}
});

}

if(!dojo._hasResource["dojo.dnd.move"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["dojo.dnd.move"] = true;
dojo.provide("dojo.dnd.move");




/*=====
dojo.declare("dojo.dnd.move.__constrainedMoveableArgs", [dojo.dnd.__MoveableArgs], {
	// constraints: Function
	//		Calculates a constraint box.
	//		It is called in a context of the moveable object.
	constraints: function(){},

	// within: Boolean
	//		restrict move within boundaries.
	within: false
});
=====*/

dojo.declare("dojo.dnd.move.constrainedMoveable", dojo.dnd.Moveable, {
	// object attributes (for markup)
	constraints: function(){},
	within: false,
	
	// markup methods
	markupFactory: function(params, node){
		return new dojo.dnd.move.constrainedMoveable(node, params);
	},

	constructor: function(node, params){
		// summary:
		//		an object that makes a node moveable
		// node: Node
		//		a node (or node's id) to be moved
		// params: dojo.dnd.move.__constrainedMoveableArgs?
		//		an optional object with additional parameters;
		//		the rest is passed to the base class
		if(!params){ params = {}; }
		this.constraints = params.constraints;
		this.within = params.within;
	},
	onFirstMove: function(/* dojo.dnd.Mover */ mover){
		// summary:
		//		called during the very first move notification;
		//		can be used to initialize coordinates, can be overwritten.
		var c = this.constraintBox = this.constraints.call(this, mover);
		c.r = c.l + c.w;
		c.b = c.t + c.h;
		if(this.within){
			var mb = dojo.marginBox(mover.node);
			c.r -= mb.w;
			c.b -= mb.h;
		}
	},
	onMove: function(/* dojo.dnd.Mover */ mover, /* Object */ leftTop){
		// summary:
		//		called during every move notification;
		//		should actually move the node; can be overwritten.
		var c = this.constraintBox, s = mover.node.style;
		s.left = (leftTop.l < c.l ? c.l : c.r < leftTop.l ? c.r : leftTop.l) + "px";
		s.top  = (leftTop.t < c.t ? c.t : c.b < leftTop.t ? c.b : leftTop.t) + "px";
	}
});

/*=====
dojo.declare("dojo.dnd.move.__boxConstrainedMoveableArgs", [dojo.dnd.move.__constrainedMoveableArgs], {
	// box: Object
	//		a constraint box
	box: {}
});
=====*/

dojo.declare("dojo.dnd.move.boxConstrainedMoveable", dojo.dnd.move.constrainedMoveable, {
	// box:
	//		object attributes (for markup)
	box: {},
	
	// markup methods
	markupFactory: function(params, node){
		return new dojo.dnd.move.boxConstrainedMoveable(node, params);
	},

	constructor: function(node, params){
		// summary:
		//		an object, which makes a node moveable
		// node: Node
		//		a node (or node's id) to be moved
		// params: dojo.dnd.move.__boxConstrainedMoveableArgs?
		//		an optional object with parameters
		var box = params && params.box;
		this.constraints = function(){ return box; };
	}
});

/*=====
dojo.declare("dojo.dnd.move.__parentConstrainedMoveableArgs", [dojo.dnd.move.__constrainedMoveableArgs], {
	// area: String
	//		A parent's area to restrict the move.
	//		Can be "margin", "border", "padding", or "content".
	area: ""
});
=====*/

dojo.declare("dojo.dnd.move.parentConstrainedMoveable", dojo.dnd.move.constrainedMoveable, {
	// area:
	//		object attributes (for markup)
	area: "content",

	// markup methods
	markupFactory: function(params, node){
		return new dojo.dnd.move.parentConstrainedMoveable(node, params);
	},

	constructor: function(node, params){
		// summary:
		//		an object, which makes a node moveable
		// node: Node
		//		a node (or node's id) to be moved
		// params: dojo.dnd.move.__parentConstrainedMoveableArgs?
		//		an optional object with parameters
		var area = params && params.area;
		this.constraints = function(){
			var n = this.node.parentNode, 
				s = dojo.getComputedStyle(n), 
				mb = dojo._getMarginBox(n, s);
			if(area == "margin"){
				return mb;	// Object
			}
			var t = dojo._getMarginExtents(n, s);
			mb.l += t.l, mb.t += t.t, mb.w -= t.w, mb.h -= t.h;
			if(area == "border"){
				return mb;	// Object
			}
			t = dojo._getBorderExtents(n, s);
			mb.l += t.l, mb.t += t.t, mb.w -= t.w, mb.h -= t.h;
			if(area == "padding"){
				return mb;	// Object
			}
			t = dojo._getPadExtents(n, s);
			mb.l += t.l, mb.t += t.t, mb.w -= t.w, mb.h -= t.h;
			return mb;	// Object
		};
	}
});

// WARNING: below are obsolete objects, instead of custom movers use custom moveables (above)

dojo.dnd.move.constrainedMover = function(fun, within){
	// summary:
	//		returns a constrained version of dojo.dnd.Mover
	// description:
	//		this function produces n object, which will put a constraint on 
	//		the margin box of dragged object in absolute coordinates
	// fun: Function
	//		called on drag, and returns a constraint box
	// within: Boolean
	//		if true, constraints the whole dragged object withtin the rectangle, 
	//		otherwise the constraint is applied to the left-top corner

	dojo.deprecated("dojo.dnd.move.constrainedMover, use dojo.dnd.move.constrainedMoveable instead");
	var mover = function(node, e, notifier){
		dojo.dnd.Mover.call(this, node, e, notifier);
	};
	dojo.extend(mover, dojo.dnd.Mover.prototype);
	dojo.extend(mover, {
		onMouseMove: function(e){
			// summary: event processor for onmousemove
			// e: Event: mouse event
			dojo.dnd.autoScroll(e);
			var m = this.marginBox, c = this.constraintBox,
				l = m.l + e.pageX, t = m.t + e.pageY;
			l = l < c.l ? c.l : c.r < l ? c.r : l;
			t = t < c.t ? c.t : c.b < t ? c.b : t;
			this.host.onMove(this, {l: l, t: t});
		},
		onFirstMove: function(){
			// summary: called once to initialize things; it is meant to be called only once
			dojo.dnd.Mover.prototype.onFirstMove.call(this);
			var c = this.constraintBox = fun.call(this);
			c.r = c.l + c.w;
			c.b = c.t + c.h;
			if(within){
				var mb = dojo.marginBox(this.node);
				c.r -= mb.w;
				c.b -= mb.h;
			}
		}
	});
	return mover;	// Object
};

dojo.dnd.move.boxConstrainedMover = function(box, within){
	// summary:
	//		a specialization of dojo.dnd.constrainedMover, which constrains to the specified box
	// box: Object
	//		a constraint box (l, t, w, h)
	// within: Boolean
	//		if true, constraints the whole dragged object withtin the rectangle, 
	//		otherwise the constraint is applied to the left-top corner

	dojo.deprecated("dojo.dnd.move.boxConstrainedMover, use dojo.dnd.move.boxConstrainedMoveable instead");
	return dojo.dnd.move.constrainedMover(function(){ return box; }, within);	// Object
};

dojo.dnd.move.parentConstrainedMover = function(area, within){
	// summary:
	//		a specialization of dojo.dnd.constrainedMover, which constrains to the parent node
	// area: String
	//		"margin" to constrain within the parent's margin box, "border" for the border box,
	//		"padding" for the padding box, and "content" for the content box; "content" is the default value.
	// within: Boolean
	//		if true, constraints the whole dragged object within the rectangle, 
	//		otherwise the constraint is applied to the left-top corner

	dojo.deprecated("dojo.dnd.move.parentConstrainedMover, use dojo.dnd.move.parentConstrainedMoveable instead");
	var fun = function(){
		var n = this.node.parentNode, 
			s = dojo.getComputedStyle(n), 
			mb = dojo._getMarginBox(n, s);
		if(area == "margin"){
			return mb;	// Object
		}
		var t = dojo._getMarginExtents(n, s);
		mb.l += t.l, mb.t += t.t, mb.w -= t.w, mb.h -= t.h;
		if(area == "border"){
			return mb;	// Object
		}
		t = dojo._getBorderExtents(n, s);
		mb.l += t.l, mb.t += t.t, mb.w -= t.w, mb.h -= t.h;
		if(area == "padding"){
			return mb;	// Object
		}
		t = dojo._getPadExtents(n, s);
		mb.l += t.l, mb.t += t.t, mb.w -= t.w, mb.h -= t.h;
		return mb;	// Object
	};
	return dojo.dnd.move.constrainedMover(fun, within);	// Object
};

// patching functions one level up for compatibility

dojo.dnd.constrainedMover = dojo.dnd.move.constrainedMover;
dojo.dnd.boxConstrainedMover = dojo.dnd.move.boxConstrainedMover;
dojo.dnd.parentConstrainedMover = dojo.dnd.move.parentConstrainedMover;

}

if(!dojo._hasResource["dojo.fx.Toggler"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["dojo.fx.Toggler"] = true;
dojo.provide("dojo.fx.Toggler");

dojo.declare("dojo.fx.Toggler", null, {
	// summary:
	//		A simple `dojo.Animation` toggler API.
	//
	// description:
	//		class constructor for an animation toggler. It accepts a packed
	//		set of arguments about what type of animation to use in each
	//		direction, duration, etc. All available members are mixed into 
	//		these animations from the constructor (for example, `node`, 
	//		`showDuration`, `hideDuration`). 
	//
	// example:
	//	|	var t = new dojo.fx.Toggler({
	//	|		node: "nodeId",
	//	|		showDuration: 500,
	//	|		// hideDuration will default to "200"
	//	|		showFunc: dojo.fx.wipeIn, 
	//	|		// hideFunc will default to "fadeOut"
	//	|	});
	//	|	t.show(100); // delay showing for 100ms
	//	|	// ...time passes...
	//	|	t.hide();

	// node: DomNode
	//		the node to target for the showing and hiding animations
	node: null,

	// showFunc: Function
	//		The function that returns the `dojo.Animation` to show the node
	showFunc: dojo.fadeIn,

	// hideFunc: Function	
	//		The function that returns the `dojo.Animation` to hide the node
	hideFunc: dojo.fadeOut,

	// showDuration:
	//		Time in milliseconds to run the show Animation
	showDuration: 200,

	// hideDuration:
	//		Time in milliseconds to run the hide Animation
	hideDuration: 200,

	// FIXME: need a policy for where the toggler should "be" the next
	// time show/hide are called if we're stopped somewhere in the
	// middle.
	// FIXME: also would be nice to specify individual showArgs/hideArgs mixed into
	// each animation individually. 
	// FIXME: also would be nice to have events from the animations exposed/bridged

	/*=====
	_showArgs: null,
	_showAnim: null,

	_hideArgs: null,
	_hideAnim: null,

	_isShowing: false,
	_isHiding: false,
	=====*/

	constructor: function(args){
		var _t = this;

		dojo.mixin(_t, args);
		_t.node = args.node;
		_t._showArgs = dojo.mixin({}, args);
		_t._showArgs.node = _t.node;
		_t._showArgs.duration = _t.showDuration;
		_t.showAnim = _t.showFunc(_t._showArgs);

		_t._hideArgs = dojo.mixin({}, args);
		_t._hideArgs.node = _t.node;
		_t._hideArgs.duration = _t.hideDuration;
		_t.hideAnim = _t.hideFunc(_t._hideArgs);

		dojo.connect(_t.showAnim, "beforeBegin", dojo.hitch(_t.hideAnim, "stop", true));
		dojo.connect(_t.hideAnim, "beforeBegin", dojo.hitch(_t.showAnim, "stop", true));
	},

	show: function(delay){
		// summary: Toggle the node to showing
		// delay: Integer?
		//		Ammount of time to stall playing the show animation
		return this.showAnim.play(delay || 0);
	},

	hide: function(delay){
		// summary: Toggle the node to hidden
		// delay: Integer?
		//		Ammount of time to stall playing the hide animation
		return this.hideAnim.play(delay || 0);
	}
});

}

if(!dojo._hasResource["dojo.fx"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["dojo.fx"] = true;
dojo.provide("dojo.fx");
 // FIXME: remove this back-compat require in 2.0 
/*=====
dojo.fx = {
	// summary: Effects library on top of Base animations
};
=====*/
(function(){
	
	var d = dojo, 
		_baseObj = {
			_fire: function(evt, args){
				if(this[evt]){
					this[evt].apply(this, args||[]);
				}
				return this;
			}
		};

	var _chain = function(animations){
		this._index = -1;
		this._animations = animations||[];
		this._current = this._onAnimateCtx = this._onEndCtx = null;

		this.duration = 0;
		d.forEach(this._animations, function(a){
			this.duration += a.duration;
			if(a.delay){ this.duration += a.delay; }
		}, this);
	};
	d.extend(_chain, {
		_onAnimate: function(){
			this._fire("onAnimate", arguments);
		},
		_onEnd: function(){
			d.disconnect(this._onAnimateCtx);
			d.disconnect(this._onEndCtx);
			this._onAnimateCtx = this._onEndCtx = null;
			if(this._index + 1 == this._animations.length){
				this._fire("onEnd");
			}else{
				// switch animations
				this._current = this._animations[++this._index];
				this._onAnimateCtx = d.connect(this._current, "onAnimate", this, "_onAnimate");
				this._onEndCtx = d.connect(this._current, "onEnd", this, "_onEnd");
				this._current.play(0, true);
			}
		},
		play: function(/*int?*/ delay, /*Boolean?*/ gotoStart){
			if(!this._current){ this._current = this._animations[this._index = 0]; }
			if(!gotoStart && this._current.status() == "playing"){ return this; }
			var beforeBegin = d.connect(this._current, "beforeBegin", this, function(){
					this._fire("beforeBegin");
				}),
				onBegin = d.connect(this._current, "onBegin", this, function(arg){
					this._fire("onBegin", arguments);
				}),
				onPlay = d.connect(this._current, "onPlay", this, function(arg){
					this._fire("onPlay", arguments);
					d.disconnect(beforeBegin);
					d.disconnect(onBegin);
					d.disconnect(onPlay);
				});
			if(this._onAnimateCtx){
				d.disconnect(this._onAnimateCtx);
			}
			this._onAnimateCtx = d.connect(this._current, "onAnimate", this, "_onAnimate");
			if(this._onEndCtx){
				d.disconnect(this._onEndCtx);
			}
			this._onEndCtx = d.connect(this._current, "onEnd", this, "_onEnd");
			this._current.play.apply(this._current, arguments);
			return this;
		},
		pause: function(){
			if(this._current){
				var e = d.connect(this._current, "onPause", this, function(arg){
						this._fire("onPause", arguments);
						d.disconnect(e);
					});
				this._current.pause();
			}
			return this;
		},
		gotoPercent: function(/*Decimal*/percent, /*Boolean?*/ andPlay){
			this.pause();
			var offset = this.duration * percent;
			this._current = null;
			d.some(this._animations, function(a){
				if(a.duration <= offset){
					this._current = a;
					return true;
				}
				offset -= a.duration;
				return false;
			});
			if(this._current){
				this._current.gotoPercent(offset / this._current.duration, andPlay);
			}
			return this;
		},
		stop: function(/*boolean?*/ gotoEnd){
			if(this._current){
				if(gotoEnd){
					for(; this._index + 1 < this._animations.length; ++this._index){
						this._animations[this._index].stop(true);
					}
					this._current = this._animations[this._index];
				}
				var e = d.connect(this._current, "onStop", this, function(arg){
						this._fire("onStop", arguments);
						d.disconnect(e);
					});
				this._current.stop();
			}
			return this;
		},
		status: function(){
			return this._current ? this._current.status() : "stopped";
		},
		destroy: function(){
			if(this._onAnimateCtx){ d.disconnect(this._onAnimateCtx); }
			if(this._onEndCtx){ d.disconnect(this._onEndCtx); }
		}
	});
	d.extend(_chain, _baseObj);

	dojo.fx.chain = function(/*dojo.Animation[]*/ animations){
		// summary: 
		//		Chain a list of `dojo.Animation`s to run in sequence
		//
		// description:
		//		Return a `dojo.Animation` which will play all passed
		//		`dojo.Animation` instances in sequence, firing its own
		//		synthesized events simulating a single animation. (eg:
		//		onEnd of this animation means the end of the chain, 
		//		not the individual animations within)
		//
		// example:
		//	Once `node` is faded out, fade in `otherNode`
		//	|	dojo.fx.chain([
		//	|		dojo.fadeIn({ node:node }),
		//	|		dojo.fadeOut({ node:otherNode })
		//	|	]).play();
		//
		return new _chain(animations) // dojo.Animation
	};

	var _combine = function(animations){
		this._animations = animations||[];
		this._connects = [];
		this._finished = 0;

		this.duration = 0;
		d.forEach(animations, function(a){
			var duration = a.duration;
			if(a.delay){ duration += a.delay; }
			if(this.duration < duration){ this.duration = duration; }
			this._connects.push(d.connect(a, "onEnd", this, "_onEnd"));
		}, this);
		
		this._pseudoAnimation = new d.Animation({curve: [0, 1], duration: this.duration});
		var self = this;
		d.forEach(["beforeBegin", "onBegin", "onPlay", "onAnimate", "onPause", "onStop", "onEnd"], 
			function(evt){
				self._connects.push(d.connect(self._pseudoAnimation, evt,
					function(){ self._fire(evt, arguments); }
				));
			}
		);
	};
	d.extend(_combine, {
		_doAction: function(action, args){
			d.forEach(this._animations, function(a){
				a[action].apply(a, args);
			});
			return this;
		},
		_onEnd: function(){
			if(++this._finished > this._animations.length){
				this._fire("onEnd");
			}
		},
		_call: function(action, args){
			var t = this._pseudoAnimation;
			t[action].apply(t, args);
		},
		play: function(/*int?*/ delay, /*Boolean?*/ gotoStart){
			this._finished = 0;
			this._doAction("play", arguments);
			this._call("play", arguments);
			return this;
		},
		pause: function(){
			this._doAction("pause", arguments);
			this._call("pause", arguments);
			return this;
		},
		gotoPercent: function(/*Decimal*/percent, /*Boolean?*/ andPlay){
			var ms = this.duration * percent;
			d.forEach(this._animations, function(a){
				a.gotoPercent(a.duration < ms ? 1 : (ms / a.duration), andPlay);
			});
			this._call("gotoPercent", arguments);
			return this;
		},
		stop: function(/*boolean?*/ gotoEnd){
			this._doAction("stop", arguments);
			this._call("stop", arguments);
			return this;
		},
		status: function(){
			return this._pseudoAnimation.status();
		},
		destroy: function(){
			d.forEach(this._connects, dojo.disconnect);
		}
	});
	d.extend(_combine, _baseObj);

	dojo.fx.combine = function(/*dojo.Animation[]*/ animations){
		// summary: 
		//		Combine a list of `dojo.Animation`s to run in parallel
		//
		// description:
		//		Combine an array of `dojo.Animation`s to run in parallel, 
		//		providing a new `dojo.Animation` instance encompasing each
		//		animation, firing standard animation events.
		//
		// example:
		//	Fade out `node` while fading in `otherNode` simultaneously
		//	|	dojo.fx.combine([
		//	|		dojo.fadeIn({ node:node }),
		//	|		dojo.fadeOut({ node:otherNode })
		//	|	]).play();
		//
		// example:
		//	When the longest animation ends, execute a function:
		//	|	var anim = dojo.fx.combine([
		//	|		dojo.fadeIn({ node: n, duration:700 }),
		//	|		dojo.fadeOut({ node: otherNode, duration: 300 })
		//	|	]);
		//	|	dojo.connect(anim, "onEnd", function(){
		//	|		// overall animation is done.
		//	|	});
		//	|	anim.play(); // play the animation
		//
		return new _combine(animations); // dojo.Animation
	};

	dojo.fx.wipeIn = function(/*Object*/ args){
		// summary:
		//		Expand a node to it's natural height.
		//
		// description:
		//		Returns an animation that will expand the
		//		node defined in 'args' object from it's current height to
		//		it's natural height (with no scrollbar).
		//		Node must have no margin/border/padding.
		//
		// args: Object
		//		A hash-map of standard `dojo.Animation` constructor properties
		//		(such as easing: node: duration: and so on)
		//
		// example:
		//	|	dojo.fx.wipeIn({
		//	|		node:"someId"
		//	|	}).play()
		var node = args.node = d.byId(args.node), s = node.style, o;

		var anim = d.animateProperty(d.mixin({
			properties: {
				height: {
					// wrapped in functions so we wait till the last second to query (in case value has changed)
					start: function(){
						// start at current [computed] height, but use 1px rather than 0
						// because 0 causes IE to display the whole panel
						o = s.overflow;
						s.overflow = "hidden";
						if(s.visibility == "hidden" || s.display == "none"){
							s.height = "1px";
							s.display = "";
							s.visibility = "";
							return 1;
						}else{
							var height = d.style(node, "height");
							return Math.max(height, 1);
						}
					},
					end: function(){
						return node.scrollHeight;
					}
				}
			}
		}, args));

		d.connect(anim, "onEnd", function(){ 
			s.height = "auto";
			s.overflow = o;
		});

		return anim; // dojo.Animation
	}

	dojo.fx.wipeOut = function(/*Object*/ args){
		// summary:
		//		Shrink a node to nothing and hide it. 
		//
		// description:
		//		Returns an animation that will shrink node defined in "args"
		//		from it's current height to 1px, and then hide it.
		//
		// args: Object
		//		A hash-map of standard `dojo.Animation` constructor properties
		//		(such as easing: node: duration: and so on)
		// 
		// example:
		//	|	dojo.fx.wipeOut({ node:"someId" }).play()
		
		var node = args.node = d.byId(args.node), s = node.style, o;
		
		var anim = d.animateProperty(d.mixin({
			properties: {
				height: {
					end: 1 // 0 causes IE to display the whole panel
				}
			}
		}, args));

		d.connect(anim, "beforeBegin", function(){
			o = s.overflow;
			s.overflow = "hidden";
			s.display = "";
		});
		d.connect(anim, "onEnd", function(){
			s.overflow = o;
			s.height = "auto";
			s.display = "none";
		});

		return anim; // dojo.Animation
	}

	dojo.fx.slideTo = function(/*Object*/ args){
		// summary:
		//		Slide a node to a new top/left position
		//
		// description:
		//		Returns an animation that will slide "node" 
		//		defined in args Object from its current position to
		//		the position defined by (args.left, args.top).
		//
		// args: Object
		//		A hash-map of standard `dojo.Animation` constructor properties
		//		(such as easing: node: duration: and so on). Special args members
		//		are `top` and `left`, which indicate the new position to slide to.
		//
		// example:
		//	|	dojo.fx.slideTo({ node: node, left:"40", top:"50", units:"px" }).play()

		var node = args.node = d.byId(args.node), 
			top = null, left = null;

		var init = (function(n){
			return function(){
				var cs = d.getComputedStyle(n);
				var pos = cs.position;
				top = (pos == 'absolute' ? n.offsetTop : parseInt(cs.top) || 0);
				left = (pos == 'absolute' ? n.offsetLeft : parseInt(cs.left) || 0);
				if(pos != 'absolute' && pos != 'relative'){
					var ret = d.position(n, true);
					top = ret.y;
					left = ret.x;
					n.style.position="absolute";
					n.style.top=top+"px";
					n.style.left=left+"px";
				}
			};
		})(node);
		init();

		var anim = d.animateProperty(d.mixin({
			properties: {
				top: args.top || 0,
				left: args.left || 0
			}
		}, args));
		d.connect(anim, "beforeBegin", anim, init);

		return anim; // dojo.Animation
	}

})();

}

if(!dojo._hasResource["dojo.colors"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["dojo.colors"] = true;
dojo.provide("dojo.colors");

//TODO: this module appears to break naming conventions

/*=====
dojo.colors = {
	// summary: Color utilities
}
=====*/

(function(){
	// this is a standard conversion prescribed by the CSS3 Color Module
	var hue2rgb = function(m1, m2, h){
		if(h < 0){ ++h; }
		if(h > 1){ --h; }
		var h6 = 6 * h;
		if(h6 < 1){ return m1 + (m2 - m1) * h6; }
		if(2 * h < 1){ return m2; }
		if(3 * h < 2){ return m1 + (m2 - m1) * (2 / 3 - h) * 6; }
		return m1;
	};
	
	dojo.colorFromRgb = function(/*String*/ color, /*dojo.Color?*/ obj){
		// summary:
		//		get rgb(a) array from css-style color declarations
		// description:
		//		this function can handle all 4 CSS3 Color Module formats: rgb,
		//		rgba, hsl, hsla, including rgb(a) with percentage values.
		var m = color.toLowerCase().match(/^(rgba?|hsla?)\(([\s\.\-,%0-9]+)\)/);
		if(m){
			var c = m[2].split(/\s*,\s*/), l = c.length, t = m[1], a;
			if((t == "rgb" && l == 3) || (t == "rgba" && l == 4)){
				var r = c[0];
				if(r.charAt(r.length - 1) == "%"){
					// 3 rgb percentage values
					a = dojo.map(c, function(x){
						return parseFloat(x) * 2.56;
					});
					if(l == 4){ a[3] = c[3]; }
					return dojo.colorFromArray(a, obj);	// dojo.Color
				}
				return dojo.colorFromArray(c, obj);	// dojo.Color
			}
			if((t == "hsl" && l == 3) || (t == "hsla" && l == 4)){
				// normalize hsl values
				var H = ((parseFloat(c[0]) % 360) + 360) % 360 / 360,
					S = parseFloat(c[1]) / 100,
					L = parseFloat(c[2]) / 100,
					// calculate rgb according to the algorithm 
					// recommended by the CSS3 Color Module 
					m2 = L <= 0.5 ? L * (S + 1) : L + S - L * S, 
					m1 = 2 * L - m2;
				a = [
					hue2rgb(m1, m2, H + 1 / 3) * 256,
					hue2rgb(m1, m2, H) * 256,
					hue2rgb(m1, m2, H - 1 / 3) * 256,
					1
				];
				if(l == 4){ a[3] = c[3]; }
				return dojo.colorFromArray(a, obj);	// dojo.Color
			}
		}
		return null;	// dojo.Color
	};
	
	var confine = function(c, low, high){
		// summary:
		//		sanitize a color component by making sure it is a number,
		//		and clamping it to valid values
		c = Number(c);
		return isNaN(c) ? high : c < low ? low : c > high ? high : c;	// Number
	};
	
	dojo.Color.prototype.sanitize = function(){
		// summary: makes sure that the object has correct attributes
		var t = this;
		t.r = Math.round(confine(t.r, 0, 255));
		t.g = Math.round(confine(t.g, 0, 255));
		t.b = Math.round(confine(t.b, 0, 255));
		t.a = confine(t.a, 0, 1);
		return this;	// dojo.Color
	};
})();


dojo.colors.makeGrey = function(/*Number*/ g, /*Number?*/ a){
	// summary: creates a greyscale color with an optional alpha
	return dojo.colorFromArray([g, g, g, a]);
};

// mixin all CSS3 named colors not already in _base, along with SVG 1.0 variant spellings
dojo.mixin(dojo.Color.named, {
	aliceblue:	[240,248,255],
	antiquewhite:	[250,235,215],
	aquamarine:	[127,255,212],
	azure:	[240,255,255],
	beige:	[245,245,220],
	bisque:	[255,228,196],
	blanchedalmond:	[255,235,205],
	blueviolet:	[138,43,226],
	brown:	[165,42,42],
	burlywood:	[222,184,135],
	cadetblue:	[95,158,160],
	chartreuse:	[127,255,0],
	chocolate:	[210,105,30],
	coral:	[255,127,80],
	cornflowerblue:	[100,149,237],
	cornsilk:	[255,248,220],
	crimson:	[220,20,60],
	cyan:	[0,255,255],
	darkblue:	[0,0,139],
	darkcyan:	[0,139,139],
	darkgoldenrod:	[184,134,11],
	darkgray:	[169,169,169],
	darkgreen:	[0,100,0],
	darkgrey:	[169,169,169],
	darkkhaki:	[189,183,107],
	darkmagenta:	[139,0,139],
	darkolivegreen:	[85,107,47],
	darkorange:	[255,140,0],
	darkorchid:	[153,50,204],
	darkred:	[139,0,0],
	darksalmon:	[233,150,122],
	darkseagreen:	[143,188,143],
	darkslateblue:	[72,61,139],
	darkslategray:	[47,79,79],
	darkslategrey:	[47,79,79],
	darkturquoise:	[0,206,209],
	darkviolet:	[148,0,211],
	deeppink:	[255,20,147],
	deepskyblue:	[0,191,255],
	dimgray:	[105,105,105],
	dimgrey:	[105,105,105],
	dodgerblue:	[30,144,255],
	firebrick:	[178,34,34],
	floralwhite:	[255,250,240],
	forestgreen:	[34,139,34],
	gainsboro:	[220,220,220],
	ghostwhite:	[248,248,255],
	gold:	[255,215,0],
	goldenrod:	[218,165,32],
	greenyellow:	[173,255,47],
	grey:	[128,128,128],
	honeydew:	[240,255,240],
	hotpink:	[255,105,180],
	indianred:	[205,92,92],
	indigo:	[75,0,130],
	ivory:	[255,255,240],
	khaki:	[240,230,140],
	lavender:	[230,230,250],
	lavenderblush:	[255,240,245],
	lawngreen:	[124,252,0],
	lemonchiffon:	[255,250,205],
	lightblue:	[173,216,230],
	lightcoral:	[240,128,128],
	lightcyan:	[224,255,255],
	lightgoldenrodyellow:	[250,250,210],
	lightgray:	[211,211,211],
	lightgreen:	[144,238,144],
	lightgrey:	[211,211,211],
	lightpink:	[255,182,193],
	lightsalmon:	[255,160,122],
	lightseagreen:	[32,178,170],
	lightskyblue:	[135,206,250],
	lightslategray:	[119,136,153],
	lightslategrey:	[119,136,153],
	lightsteelblue:	[176,196,222],
	lightyellow:	[255,255,224],
	limegreen:	[50,205,50],
	linen:	[250,240,230],
	magenta:	[255,0,255],
	mediumaquamarine:	[102,205,170],
	mediumblue:	[0,0,205],
	mediumorchid:	[186,85,211],
	mediumpurple:	[147,112,219],
	mediumseagreen:	[60,179,113],
	mediumslateblue:	[123,104,238],
	mediumspringgreen:	[0,250,154],
	mediumturquoise:	[72,209,204],
	mediumvioletred:	[199,21,133],
	midnightblue:	[25,25,112],
	mintcream:	[245,255,250],
	mistyrose:	[255,228,225],
	moccasin:	[255,228,181],
	navajowhite:	[255,222,173],
	oldlace:	[253,245,230],
	olivedrab:	[107,142,35],
	orange:	[255,165,0],
	orangered:	[255,69,0],
	orchid:	[218,112,214],
	palegoldenrod:	[238,232,170],
	palegreen:	[152,251,152],
	paleturquoise:	[175,238,238],
	palevioletred:	[219,112,147],
	papayawhip:	[255,239,213],
	peachpuff:	[255,218,185],
	peru:	[205,133,63],
	pink:	[255,192,203],
	plum:	[221,160,221],
	powderblue:	[176,224,230],
	rosybrown:	[188,143,143],
	royalblue:	[65,105,225],
	saddlebrown:	[139,69,19],
	salmon:	[250,128,114],
	sandybrown:	[244,164,96],
	seagreen:	[46,139,87],
	seashell:	[255,245,238],
	sienna:	[160,82,45],
	skyblue:	[135,206,235],
	slateblue:	[106,90,205],
	slategray:	[112,128,144],
	slategrey:	[112,128,144],
	snow:	[255,250,250],
	springgreen:	[0,255,127],
	steelblue:	[70,130,180],
	tan:	[210,180,140],
	thistle:	[216,191,216],
	tomato:	[255,99,71],
	transparent: [0, 0, 0, 0],
	turquoise:	[64,224,208],
	violet:	[238,130,238],
	wheat:	[245,222,179],
	whitesmoke:	[245,245,245],
	yellowgreen:	[154,205,50]
});

}

if(!dojo._hasResource["dojox.color._base"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["dojox.color._base"] = true;
dojo.provide("dojox.color._base");


//	alias all the dojo.Color mechanisms
dojox.color.Color=dojo.Color;
dojox.color.blend=dojo.blendColors;
dojox.color.fromRgb=dojo.colorFromRgb;
dojox.color.fromHex=dojo.colorFromHex;
dojox.color.fromArray=dojo.colorFromArray;
dojox.color.fromString=dojo.colorFromString;

//	alias the dojo.colors mechanisms
dojox.color.greyscale=dojo.colors.makeGrey;

//	static methods
dojo.mixin(dojox.color, {
	fromCmy: function(/* Object|Array|int */cyan, /*int*/magenta, /*int*/yellow){
		//	summary
		//	Create a dojox.color.Color from a CMY defined color.
		//	All colors should be expressed as 0-100 (percentage)

		if(dojo.isArray(cyan)){
			magenta=cyan[1], yellow=cyan[2], cyan=cyan[0];
		} else if(dojo.isObject(cyan)){
			magenta=cyan.m, yellow=cyan.y, cyan=cyan.c;
		}
		cyan/=100, magenta/=100, yellow/=100;

		var r=1-cyan, g=1-magenta, b=1-yellow;
		return new dojox.color.Color({ r:Math.round(r*255), g:Math.round(g*255), b:Math.round(b*255) });	//	dojox.color.Color
	},

	fromCmyk: function(/* Object|Array|int */cyan, /*int*/magenta, /*int*/yellow, /*int*/black){
		//	summary
		//	Create a dojox.color.Color from a CMYK defined color.
		//	All colors should be expressed as 0-100 (percentage)

		if(dojo.isArray(cyan)){
			magenta=cyan[1], yellow=cyan[2], black=cyan[3], cyan=cyan[0];
		} else if(dojo.isObject(cyan)){
			magenta=cyan.m, yellow=cyan.y, black=cyan.b, cyan=cyan.c;
		}
		cyan/=100, magenta/=100, yellow/=100, black/=100;
		var r,g,b;
		r = 1-Math.min(1, cyan*(1-black)+black);
		g = 1-Math.min(1, magenta*(1-black)+black);
		b = 1-Math.min(1, yellow*(1-black)+black);
		return new dojox.color.Color({ r:Math.round(r*255), g:Math.round(g*255), b:Math.round(b*255) });	//	dojox.color.Color
	},
	
	fromHsl: function(/* Object|Array|int */hue, /* int */saturation, /* int */luminosity){
		//	summary
		//	Create a dojox.color.Color from an HSL defined color.
		//	hue from 0-359 (degrees), saturation and luminosity 0-100.

		if(dojo.isArray(hue)){
			saturation=hue[1], luminosity=hue[2], hue=hue[0];
		} else if(dojo.isObject(hue)){
			saturation=hue.s, luminosity=hue.l, hue=hue.h;
		}
		saturation/=100;
		luminosity/=100;

		while(hue<0){ hue+=360; }
		while(hue>=360){ hue-=360; }
		
		var r, g, b;
		if(hue<120){
			r=(120-hue)/60, g=hue/60, b=0;
		} else if (hue<240){
			r=0, g=(240-hue)/60, b=(hue-120)/60;
		} else {
			r=(hue-240)/60, g=0, b=(360-hue)/60;
		}
		
		r=2*saturation*Math.min(r, 1)+(1-saturation);
		g=2*saturation*Math.min(g, 1)+(1-saturation);
		b=2*saturation*Math.min(b, 1)+(1-saturation);
		if(luminosity<0.5){
			r*=luminosity, g*=luminosity, b*=luminosity;
		}else{
			r=(1-luminosity)*r+2*luminosity-1;
			g=(1-luminosity)*g+2*luminosity-1;
			b=(1-luminosity)*b+2*luminosity-1;
		}
		return new dojox.color.Color({ r:Math.round(r*255), g:Math.round(g*255), b:Math.round(b*255) });	//	dojox.color.Color
	},
	
	fromHsv: function(/* Object|Array|int */hue, /* int */saturation, /* int */value){
		//	summary
		//	Create a dojox.color.Color from an HSV defined color.
		//	hue from 0-359 (degrees), saturation and value 0-100.

		if(dojo.isArray(hue)){
			saturation=hue[1], value=hue[2], hue=hue[0];
		} else if (dojo.isObject(hue)){
			saturation=hue.s, value=hue.v, hue=hue.h;
		}
		
		if(hue==360){ hue=0; }
		saturation/=100;
		value/=100;
		
		var r, g, b;
		if(saturation==0){
			r=value, b=value, g=value;
		}else{
			var hTemp=hue/60, i=Math.floor(hTemp), f=hTemp-i;
			var p=value*(1-saturation);
			var q=value*(1-(saturation*f));
			var t=value*(1-(saturation*(1-f)));
			switch(i){
				case 0:{ r=value, g=t, b=p; break; }
				case 1:{ r=q, g=value, b=p; break; }
				case 2:{ r=p, g=value, b=t; break; }
				case 3:{ r=p, g=q, b=value; break; }
				case 4:{ r=t, g=p, b=value; break; }
				case 5:{ r=value, g=p, b=q; break; }
			}
		}
		return new dojox.color.Color({ r:Math.round(r*255), g:Math.round(g*255), b:Math.round(b*255) });	//	dojox.color.Color
	}
});

//	Conversions directly on dojox.color.Color
dojo.extend(dojox.color.Color, {
	toCmy: function(){
		//	summary
		//	Convert this Color to a CMY definition.
		var cyan=1-(this.r/255), magenta=1-(this.g/255), yellow=1-(this.b/255);
		return { c:Math.round(cyan*100), m:Math.round(magenta*100), y:Math.round(yellow*100) };		//	Object
	},
	
	toCmyk: function(){
		//	summary
		//	Convert this Color to a CMYK definition.
		var cyan, magenta, yellow, black;
		var r=this.r/255, g=this.g/255, b=this.b/255;
		black = Math.min(1-r, 1-g, 1-b);
		cyan = (1-r-black)/(1-black);
		magenta = (1-g-black)/(1-black);
		yellow = (1-b-black)/(1-black);
		return { c:Math.round(cyan*100), m:Math.round(magenta*100), y:Math.round(yellow*100), b:Math.round(black*100) };	//	Object
	},
	
	toHsl: function(){
		//	summary
		//	Convert this Color to an HSL definition.
		var r=this.r/255, g=this.g/255, b=this.b/255;
		var min = Math.min(r, b, g), max = Math.max(r, g, b);
		var delta = max-min;
		var h=0, s=0, l=(min+max)/2;
		if(l>0 && l<1){
			s = delta/((l<0.5)?(2*l):(2-2*l));
		}
		if(delta>0){
			if(max==r && max!=g){
				h+=(g-b)/delta;
			}
			if(max==g && max!=b){
				h+=(2+(b-r)/delta);
			}
			if(max==b && max!=r){
				h+=(4+(r-g)/delta);
			}
			h*=60;
		}
		return { h:h, s:Math.round(s*100), l:Math.round(l*100) };	//	Object
	},

	toHsv: function(){
		//	summary
		//	Convert this Color to an HSV definition.
		var r=this.r/255, g=this.g/255, b=this.b/255;
		var min = Math.min(r, b, g), max = Math.max(r, g, b);
		var delta = max-min;
		var h = null, s = (max==0)?0:(delta/max);
		if(s==0){
			h = 0;
		}else{
			if(r==max){
				h = 60*(g-b)/delta;
			}else if(g==max){
				h = 120 + 60*(b-r)/delta;
			}else{
				h = 240 + 60*(r-g)/delta;
			}

			if(h<0){ h+=360; }
		}
		return { h:h, s:Math.round(s*100), v:Math.round(max*100) };	//	Object
	}
});

}

if(!dojo._hasResource["dojox.color"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["dojox.color"] = true;
dojo.provide("dojox.color");


}

if(!dojo._hasResource["dojo.i18n"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["dojo.i18n"] = true;
dojo.provide("dojo.i18n");

/*=====
dojo.i18n = {
	// summary: Utility classes to enable loading of resources for internationalization (i18n)
};
=====*/

dojo.i18n.getLocalization = function(/*String*/packageName, /*String*/bundleName, /*String?*/locale){
	//	summary:
	//		Returns an Object containing the localization for a given resource
	//		bundle in a package, matching the specified locale.
	//	description:
	//		Returns a hash containing name/value pairs in its prototypesuch
	//		that values can be easily overridden.  Throws an exception if the
	//		bundle is not found.  Bundle must have already been loaded by
	//		`dojo.requireLocalization()` or by a build optimization step.  NOTE:
	//		try not to call this method as part of an object property
	//		definition (`var foo = { bar: dojo.i18n.getLocalization() }`).  In
	//		some loading situations, the bundle may not be available in time
	//		for the object definition.  Instead, call this method inside a
	//		function that is run after all modules load or the page loads (like
	//		in `dojo.addOnLoad()`), or in a widget lifecycle method.
	//	packageName:
	//		package which is associated with this resource
	//	bundleName:
	//		the base filename of the resource bundle (without the ".js" suffix)
	//	locale:
	//		the variant to load (optional).  By default, the locale defined by
	//		the host environment: dojo.locale

	locale = dojo.i18n.normalizeLocale(locale);

	// look for nearest locale match
	var elements = locale.split('-');
	var module = [packageName,"nls",bundleName].join('.');
	var bundle = dojo._loadedModules[module];
	if(bundle){
		var localization;
		for(var i = elements.length; i > 0; i--){
			var loc = elements.slice(0, i).join('_');
			if(bundle[loc]){
				localization = bundle[loc];
				break;
			}
		}
		if(!localization){
			localization = bundle.ROOT;
		}

		// make a singleton prototype so that the caller won't accidentally change the values globally
		if(localization){
			var clazz = function(){};
			clazz.prototype = localization;
			return new clazz(); // Object
		}
	}

	throw new Error("Bundle not found: " + bundleName + " in " + packageName+" , locale=" + locale);
};

dojo.i18n.normalizeLocale = function(/*String?*/locale){
	//	summary:
	//		Returns canonical form of locale, as used by Dojo.
	//
	//  description:
	//		All variants are case-insensitive and are separated by '-' as specified in [RFC 3066](http://www.ietf.org/rfc/rfc3066.txt).
	//		If no locale is specified, the dojo.locale is returned.  dojo.locale is defined by
	//		the user agent's locale unless overridden by djConfig.

	var result = locale ? locale.toLowerCase() : dojo.locale;
	if(result == "root"){
		result = "ROOT";
	}
	return result; // String
};

dojo.i18n._requireLocalization = function(/*String*/moduleName, /*String*/bundleName, /*String?*/locale, /*String?*/availableFlatLocales){
	//	summary:
	//		See dojo.requireLocalization()
	//	description:
	// 		Called by the bootstrap, but factored out so that it is only
	// 		included in the build when needed.

	var targetLocale = dojo.i18n.normalizeLocale(locale);
 	var bundlePackage = [moduleName, "nls", bundleName].join(".");
	// NOTE: 
	//		When loading these resources, the packaging does not match what is
	//		on disk.  This is an implementation detail, as this is just a
	//		private data structure to hold the loaded resources.  e.g.
	//		`tests/hello/nls/en-us/salutations.js` is loaded as the object
	//		`tests.hello.nls.salutations.en_us={...}` The structure on disk is
	//		intended to be most convenient for developers and translators, but
	//		in memory it is more logical and efficient to store in a different
	//		order.  Locales cannot use dashes, since the resulting path will
	//		not evaluate as valid JS, so we translate them to underscores.
	
	//Find the best-match locale to load if we have available flat locales.
	var bestLocale = "";
	if(availableFlatLocales){
		var flatLocales = availableFlatLocales.split(",");
		for(var i = 0; i < flatLocales.length; i++){
			//Locale must match from start of string.
			//Using ["indexOf"] so customBase builds do not see
			//this as a dojo._base.array dependency.
			if(targetLocale["indexOf"](flatLocales[i]) == 0){
				if(flatLocales[i].length > bestLocale.length){
					bestLocale = flatLocales[i];
				}
			}
		}
		if(!bestLocale){
			bestLocale = "ROOT";
		}		
	}

	//See if the desired locale is already loaded.
	var tempLocale = availableFlatLocales ? bestLocale : targetLocale;
	var bundle = dojo._loadedModules[bundlePackage];
	var localizedBundle = null;
	if(bundle){
		if(dojo.config.localizationComplete && bundle._built){return;}
		var jsLoc = tempLocale.replace(/-/g, '_');
		var translationPackage = bundlePackage+"."+jsLoc;
		localizedBundle = dojo._loadedModules[translationPackage];
	}

	if(!localizedBundle){
		bundle = dojo["provide"](bundlePackage);
		var syms = dojo._getModuleSymbols(moduleName);
		var modpath = syms.concat("nls").join("/");
		var parent;

		dojo.i18n._searchLocalePath(tempLocale, availableFlatLocales, function(loc){
			var jsLoc = loc.replace(/-/g, '_');
			var translationPackage = bundlePackage + "." + jsLoc;
			var loaded = false;
			if(!dojo._loadedModules[translationPackage]){
				// Mark loaded whether it's found or not, so that further load attempts will not be made
				dojo["provide"](translationPackage);
				var module = [modpath];
				if(loc != "ROOT"){module.push(loc);}
				module.push(bundleName);
				var filespec = module.join("/") + '.js';
				loaded = dojo._loadPath(filespec, null, function(hash){
					// Use singleton with prototype to point to parent bundle, then mix-in result from loadPath
					var clazz = function(){};
					clazz.prototype = parent;
					bundle[jsLoc] = new clazz();
					for(var j in hash){ bundle[jsLoc][j] = hash[j]; }
				});
			}else{
				loaded = true;
			}
			if(loaded && bundle[jsLoc]){
				parent = bundle[jsLoc];
			}else{
				bundle[jsLoc] = parent;
			}
			
			if(availableFlatLocales){
				//Stop the locale path searching if we know the availableFlatLocales, since
				//the first call to this function will load the only bundle that is needed.
				return true;
			}
		});
	}

	//Save the best locale bundle as the target locale bundle when we know the
	//the available bundles.
	if(availableFlatLocales && targetLocale != bestLocale){
		bundle[targetLocale.replace(/-/g, '_')] = bundle[bestLocale.replace(/-/g, '_')];
	}
};

(function(){
	// If other locales are used, dojo.requireLocalization should load them as
	// well, by default. 
	// 
	// Override dojo.requireLocalization to do load the default bundle, then
	// iterate through the extraLocale list and load those translations as
	// well, unless a particular locale was requested.

	var extra = dojo.config.extraLocale;
	if(extra){
		if(!extra instanceof Array){
			extra = [extra];
		}

		var req = dojo.i18n._requireLocalization;
		dojo.i18n._requireLocalization = function(m, b, locale, availableFlatLocales){
			req(m,b,locale, availableFlatLocales);
			if(locale){return;}
			for(var i=0; i<extra.length; i++){
				req(m,b,extra[i], availableFlatLocales);
			}
		};
	}
})();

dojo.i18n._searchLocalePath = function(/*String*/locale, /*Boolean*/down, /*Function*/searchFunc){
	//	summary:
	//		A helper method to assist in searching for locale-based resources.
	//		Will iterate through the variants of a particular locale, either up
	//		or down, executing a callback function.  For example, "en-us" and
	//		true will try "en-us" followed by "en" and finally "ROOT".

	locale = dojo.i18n.normalizeLocale(locale);

	var elements = locale.split('-');
	var searchlist = [];
	for(var i = elements.length; i > 0; i--){
		searchlist.push(elements.slice(0, i).join('-'));
	}
	searchlist.push(false);
	if(down){searchlist.reverse();}

	for(var j = searchlist.length - 1; j >= 0; j--){
		var loc = searchlist[j] || "ROOT";
		var stop = searchFunc(loc);
		if(stop){ break; }
	}
};

dojo.i18n._preloadLocalizations = function(/*String*/bundlePrefix, /*Array*/localesGenerated){
	//	summary:
	//		Load built, flattened resource bundles, if available for all
	//		locales used in the page. Only called by built layer files.

	function preload(locale){
		locale = dojo.i18n.normalizeLocale(locale);
		dojo.i18n._searchLocalePath(locale, true, function(loc){
			for(var i=0; i<localesGenerated.length;i++){
				if(localesGenerated[i] == loc){
					dojo["require"](bundlePrefix+"_"+loc);
					return true; // Boolean
				}
			}
			return false; // Boolean
		});
	}
	preload();
	var extra = dojo.config.extraLocale||[];
	for(var i=0; i<extra.length; i++){
		preload(extra[i]);
	}
};

}

if(!dojo._hasResource["dojox.widget.ColorPicker"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["dojox.widget.ColorPicker"] = true;
dojo.provide("dojox.widget.ColorPicker");
dojo.experimental("dojox.widget.ColorPicker"); // level: beta //TODO: which?





 
 



;(function(d){
	
	var webSafeFromHex = function(hex){
		// stub, this is planned later:
		return hex;
	}
	
	dojo.declare("dojox.widget.ColorPicker",
		dijit.form._FormWidget,
		{
		// summary: a HSV color picker - similar to Photoshop picker
		//
		// description: 
		//		Provides an interactive HSV ColorPicker similar to
		//		PhotoShop's color selction tool. This is an enhanced 
		//		version of the default dijit.ColorPalette, though provides
		//		no accessibility.
		//
		// example:
		// |	var picker = new dojox.widget.ColorPicker({
		// |		// a couple of example toggles:
		// |		animatePoint:false,
		// |		showHsv: false,
		// |		webSafe: false,
		// |		showRgb: false 	
		// |	});
		//	
		// example: 
		// | 	<!-- markup: -->
		// | 	<div dojoType="dojox.widget.ColorPicker"></div>
		//
		// showRgb: Boolean
		//	show/update RGB input nodes
		showRgb: true,
	
		// showHsv: Boolean
		//	show/update HSV input nodes
		showHsv: true,
	
		// showHex: Boolean
		//	show/update Hex value field
		showHex: true,

		// webSafe: Boolean
		//	deprecated? or just use a toggle to show/hide that node, too?
		webSafe: true,

		// animatePoint: Boolean
		//	toggle to use slideTo (true) or just place the cursor (false) on click
		animatePoint: true,

		// slideDuration: Integer
		//	time in ms picker node will slide to next location (non-dragging) when animatePoint=true
		slideDuration: 250, 

		// liveUpdate: Boolean
		//		Set to true to fire onChange in an indeterminate way
		liveUpdate: false, 

		// PICKER_HUE_H: int
		//     Height of the hue picker, used to calculate positions    
		PICKER_HUE_H: 150,
		
		// PICKER_SAT_VAL_H: int
		//     Height of the 2d picker, used to calculate positions    
		PICKER_SAT_VAL_H: 150,
		
		// PICKER_SAT_VAL_W: int
		//     Width of the 2d picker, used to calculate positions    
		PICKER_SAT_VAL_W: 150,
		
		// value: String
		//	Default color for this component. Only hex values are accepted as incoming/returned
		//	values. Adjust this value with `.attr`, eg: dijit.byId("myPicker").attr("value", "#ededed");
		//	to cause the points to adjust and the values to reflect the current color. 
		value: "#ffffff",
		
		_underlay: d.moduleUrl("dojox.widget","ColorPicker/images/underlay.png"),
		// don't change to d.moduleUrl, build won't intern it.
		templateString: dojo.cache("dojox.widget", "ColorPicker/ColorPicker.html", "<div class=\"dojoxColorPicker\" dojoAttachEvent=\"onkeypress: _handleKey\">\r\n\t<div class=\"dojoxColorPickerBox\">\r\n\t\t<div dojoAttachPoint=\"cursorNode\" tabIndex=\"0\" class=\"dojoxColorPickerPoint\"></div>\r\n\t\t<img dojoAttachPoint=\"colorUnderlay\" dojoAttachEvent=\"onclick: _setPoint\" class=\"dojoxColorPickerUnderlay\" src=\"${_underlay}\">\r\n\t</div>\r\n\t<div class=\"dojoxHuePicker\">\r\n\t\t<div dojoAttachPoint=\"hueCursorNode\" tabIndex=\"0\" class=\"dojoxHuePickerPoint\"></div>\r\n\t\t<div dojoAttachPoint=\"hueNode\" class=\"dojoxHuePickerUnderlay\" dojoAttachEvent=\"onclick: _setHuePoint\"></div>\r\n\t</div>\r\n\t<div dojoAttachPoint=\"previewNode\" class=\"dojoxColorPickerPreview\"></div>\r\n\t<div dojoAttachPoint=\"safePreviewNode\" class=\"dojoxColorPickerWebSafePreview\"></div>\r\n\t<div class=\"dojoxColorPickerOptional\" dojoAttachEvent=\"onchange: _colorInputChange\">\r\n\t\t<div class=\"dijitInline dojoxColorPickerRgb\" dojoAttachPoint=\"rgbNode\">\r\n\t\t\t<table>\r\n\t\t\t<tr><td>${redLabel}</td><td><input dojoAttachPoint=\"Rval\" size=\"1\"></td></tr>\r\n\t\t\t<tr><td>${greenLabel}</td><td><input dojoAttachPoint=\"Gval\" size=\"1\"></td></tr>\r\n\t\t\t<tr><td>${blueLabel}</td><td><input dojoAttachPoint=\"Bval\" size=\"1\"></td></tr>\r\n\t\t\t</table>\r\n\t\t</div>\r\n\t\t<div class=\"dijitInline dojoxColorPickerHsv\" dojoAttachPoint=\"hsvNode\">\r\n\t\t\t<table>\r\n\t\t\t<tr><td>${hueLabel}</td><td><input dojoAttachPoint=\"Hval\"size=\"1\"> ${degLabel}</td></tr>\r\n\t\t\t<tr><td>${saturationLabel}</td><td><input dojoAttachPoint=\"Sval\" size=\"1\"> ${percentSign}</td></tr>\r\n\t\t\t<tr><td>${valueLabel}</td><td><input dojoAttachPoint=\"Vval\" size=\"1\"> ${percentSign}</td></tr>\r\n\t\t\t</table>\r\n\t\t</div>\r\n\t\t<div class=\"dojoxColorPickerHex\" dojoAttachPoint=\"hexNode\">\t\r\n\t\t\t${hexLabel}: <input dojoAttachPoint=\"hexCode, focusNode, valueNode\" size=\"6\" class=\"dojoxColorPickerHexCode\">\r\n\t\t</div>\r\n\t</div>\r\n</div>\r\n"),

		postMixInProperties: function(){
			dojo.mixin(this, dojo.i18n.getLocalization("dojox.widget", "ColorPicker"));
			dojo.mixin(this, dojo.i18n.getLocalization("dojo.cldr", "number"));
			this.inherited(arguments);
		},

		postCreate: function(){
			this.inherited(arguments);

			// summary: As quickly as we can, set up ie6 alpha-filter support for our
			// 	underlay.  we don't do image handles (done in css), just the 'core' 
			//	of this widget: the underlay. 
			if(d.isIE < 7){ 
				this.colorUnderlay.style.filter = "progid:DXImageTransform.Microsoft.AlphaImageLoader(src='"+this._underlay+"', sizingMethod='scale')";
				this.colorUnderlay.src = this._blankGif.toString();
			}
			// hide toggle-able nodes:
			if(!this.showRgb){ this.rgbNode.style.display = "none"; }
			if(!this.showHsv){ this.hsvNode.style.display = "none"; }
			if(!this.showHex){ this.hexNode.style.display = "none"; } 
			if(!this.webSafe){ this.safePreviewNode.style.visibility = "hidden"; } 
			
			// this._offset = ((d.marginBox(this.cursorNode).w)/2); 
			this._offset = 0; 
			var cmb = d.marginBox(this.cursorNode);
			var hmb = d.marginBox(this.hueCursorNode);

			this._shift = {
				hue: {
					x: Math.round(hmb.w / 2) - 1,
					y: Math.round(hmb.h / 2) - 1
				},
				picker: {
					x: Math.floor(cmb.w / 2),
					y: Math.floor(cmb.h / 2)
				}
			};
			
			//setup constants
			this.PICKER_HUE_H = d.coords(this.hueNode).h;
			
			var cu = d.coords(this.colorUnderlay);
			this.PICKER_SAT_VAL_H = cu.h;
			this.PICKER_SAT_VAL_W = cu.w;
			
			var ox = this._shift.picker.x;
			var oy = this._shift.picker.y;
			this._mover = new d.dnd.move.boxConstrainedMoveable(this.cursorNode, {
				box: {
					t:0 - oy,
					l:0 - ox,
					w:this.PICKER_SAT_VAL_W,
					h:this.PICKER_SAT_VAL_H
				}
			});
			
			this._hueMover = new d.dnd.move.boxConstrainedMoveable(this.hueCursorNode, {
				box: {
					t:0 - this._shift.hue.y,
					l:0,
					w:0,
					h:this.PICKER_HUE_H
				}
			});
			
			// no dnd/move/move published ... use a timer:
			d.subscribe("/dnd/move/stop", d.hitch(this, "_clearTimer"));
			d.subscribe("/dnd/move/start", d.hitch(this, "_setTimer"));
			
		},
		
		startup: function(){
			this._started = true;
			this.attr("value", this.value);
		},
		
		_setValueAttr: function(value){
			if(!this._started){ return; }
			this.setColor(value, true);
		},
		
		setColor: function(/* String */color, force){
			// summary: Set a color on a picker. Usually used to set
			//          initial color as an alternative to passing defaultColor option
			//          to the constructor. 
			var col = dojox.color.fromString(color);
			
			this._updatePickerLocations(col);
			this._updateColorInputs(col);
			this._updateValue(col, force);
		},
		
		_setTimer: function(/* d.dnd.Mover */mover){
			// FIXME: should I assume this? focus on mouse down so on mouse up
			dijit.focus(mover.node);
			d.setSelectable(this.domNode,false);
			this._timer = setInterval(d.hitch(this, "_updateColor"), 45);	
		},
		
		_clearTimer: function(/* d.dnd.Mover */mover){
			clearInterval(this._timer);
			this._timer = null;
			this.onChange(this.value);
			d.setSelectable(this.domNode,true);
		},
		
		_setHue: function(/* Decimal */h){
			// summary: sets a natural color background for the 
			// 	underlay image against closest hue value (full saturation) 
			// h: 0..360 
			d.style(this.colorUnderlay, "backgroundColor", dojox.color.fromHsv(h,100,100).toHex());
			
		},
		
		_updateColor: function(){
			// summary: update the previewNode color, and input values [optional]
			
			var _huetop = d.style(this.hueCursorNode,"top") + this._shift.hue.y, 
				_pickertop = d.style(this.cursorNode,"top") + this._shift.picker.y,
				_pickerleft = d.style(this.cursorNode,"left") + this._shift.picker.x,
			
				h = Math.round(360 - (_huetop / this.PICKER_HUE_H * 360)),
				col = dojox.color.fromHsv(h, _pickerleft / this.PICKER_SAT_VAL_W * 100, 100 - (_pickertop / this.PICKER_SAT_VAL_H * 100))
			;

			
			this._updateColorInputs(col);
			this._updateValue(col, true);
			
			// update hue, not all the pickers
			if (h!=this._hue) {
				this._setHue(h);
			}
		},
		
		_colorInputChange: function(e){
			//summary: updates picker position and inputs 
			//         according to rgb, hex or hsv input changes

			var col, hasit = false;
			switch (e.target) {
				//transform to hsv to pixels

				case this.hexCode:
					col = dojox.color.fromString(e.target.value);
					hasit = true;
					
					break;
				case this.Rval:
				case this.Gval:
				case this.Bval:
					col = dojox.color.fromArray([this.Rval.value, this.Gval.value, this.Bval.value]);
					hasit = true;
					break;
				case this.Hval:
				case this.Sval:
				case this.Vval:
					col = dojox.color.fromHsv(this.Hval.value, this.Sval.value, this.Vval.value);
					hasit = true;
					break
			}
			
			if(hasit){
				this._updatePickerLocations(col);
				this._updateColorInputs(col);
				this._updateValue(col, true);
			}
			
		},
		
		_updateValue: function(/* dojox.color.Color */col, /* Boolean */fireChange){
			// summary: updates the value of the widget
			//          can cancel reverse onChange by specifying second param
			var hex = col.toHex();
			
			this.value = this.valueNode.value = hex;
			
			// anytime we muck with the color, fire onChange?
			if(fireChange && (!this._timer || this.liveUpdate)) {
				this.onChange(hex);
			}
		},
		
		_updatePickerLocations: function(/* dojox.color.Color */col){
			//summary: update handles on the pickers acording to color values
			//  
			var hsv = col.toHsv(),
				ypos = Math.round(this.PICKER_HUE_H - hsv.h / 360 * this.PICKER_HUE_H - this._shift.hue.y),
				newLeft = Math.round(hsv.s / 100 * this.PICKER_SAT_VAL_W - this._shift.picker.x),
				newTop = Math.round(this.PICKER_SAT_VAL_H - hsv.v / 100 * this.PICKER_SAT_VAL_H - this._shift.picker.y)
			;
			
			if (this.animatePoint) {
				d.fx.slideTo({
					node: this.hueCursorNode,
					duration: this.slideDuration,
					top: ypos,
					left: 0
				}).play();
				
				d.fx.slideTo({
					node: this.cursorNode,
					duration: this.slideDuration,
					top: newTop,
					left: newLeft
				}).play();
				
			}
			else {
				d.style(this.hueCursorNode, "top", ypos + "px");
				d.style(this.cursorNode, {
					left: newLeft + "px",
					top: newTop + "px"
				});
			}
			
			// limit hue calculations to only when it changes
			if (hsv.h != this._hue) {
				this._setHue(hsv.h);
			}
			
		},
		
		_updateColorInputs: function(/* dojox.color.Color */col){
			//summary: updates color inputs that were changed through other inputs
			//or by clicking on the picker
			
			var hex = col.toHex();
			
			if (this.showRgb) {
				this.Rval.value = col.r;
				this.Gval.value = col.g;
				this.Bval.value = col.b;
			}
			
			if (this.showHsv) {
				var hsv = col.toHsv();
				this.Hval.value = Math.round((hsv.h)); // convert to 0..360
				this.Sval.value = Math.round(hsv.s);
				this.Vval.value = Math.round(hsv.v);
			}
			
			if (this.showHex) {
				this.hexCode.value = hex;
			}
			
			this.previewNode.style.backgroundColor = hex;
			
			if (this.webSafe) {
				this.safePreviewNode.style.backgroundColor = webSafeFromHex(hex);
			}
		},
		
		_setHuePoint: function(/* Event */evt){ 
			// summary: set the hue picker handle on relative y coordinates
			var ypos = evt.layerY - this._shift.hue.y;
			if(this.animatePoint){
				d.fx.slideTo({ 
					node: this.hueCursorNode, 
					duration:this.slideDuration,
					top: ypos,
					left: 0,
					onEnd: d.hitch(this, "_updateColor", true)
				}).play();
			}else{
				d.style(this.hueCursorNode, "top", ypos + "px");
				this._updateColor(false); 
			}
		},
		
		_setPoint: function(/* Event */evt){
			// summary: set our picker point based on relative x/y coordinates
			//  evt.preventDefault();
			var newTop = evt.layerY - this._shift.picker.y,
				newLeft = evt.layerX - this._shift.picker.x
			;
			if(evt){ dijit.focus(evt.target); }

			if(this.animatePoint){
				d.fx.slideTo({ 
					node: this.cursorNode, 
					duration: this.slideDuration,
					top: newTop,
					left: newLeft,
					onEnd: d.hitch(this,"_updateColor", true)
				}).play();
			}else{
				d.style(this.cursorNode, {
					left: newLeft + "px",
					top: newTop + "px"	
				});
				this._updateColor(false); 
			}
		},
		
		_handleKey: function(/* Event */e){
			// FIXME: not implemented YET
			// var keys = d.keys;
		}
		
	});
	
})(dojo);

}

if(!dojo._hasResource["wm.base.widget.Dialog"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["wm.base.widget.Dialog"] = true;
/*
 *  Copyright (C) 2008-2010 WaveMaker Software, Inc.
 *
 *  This file is part of the WaveMaker Client Runtime.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/* DIALOG TODO LIST:
 * 1. Are you sure you want to close project (confirm)
 * 2. Enter new project name (new project, copy project)
 * 3. Are you sure you want to delete (project name)
 * 4. Successfully exported project to zip file...
 */

dojo.provide("wm.base.widget.Dialog");



wm.dialog = {showingList: []};

wm.dialog.getNextZIndex = function() {
    var index = 30;
    for (var i = 0; i < wm.dialog.showingList.length; i++) 
	index = Math.max(index, wm.dialog.showingList[i].domNode.style.zIndex);
    return index+1;
}

wm.dismiss = function(inWidget, inWhy) {
	var o = inWidget;
	while (o && !dojo.isFunction(o.dismiss))
		o = o.owner;
	wm.fire(o, "dismiss", [inWhy]);
}

wm.bgIframe = {
	create: function() {
		var html=[
				"<iframe src='javascript:\"\"'",
				" style='position: absolute; left: 0px; top: 0px;",
				" z-index: 2; filter:Alpha(Opacity=\"0\");'>"
			].join(''),
			f = this.domNode = dojo.isIE ? document.createElement(html) : document.createElement("IFRAME");
		document.body.appendChild(f);
		f.style.display = "none";
		if (dojo.isMoz) {
			f.style.position = "absolute";
			f.style.left = f.style.top = "0px";
			f.style.opacity = 0;
			f.style.zIndex = 2;
		}
		dojo.subscribe("window-resize", this, "size")
	},
        setShowing: function(inShowing,forceChange) {
		if (!this.domNode)
			return;
		if (forceChange || inShowing != this.showing) {
			this.domNode.style.display = inShowing ? "" : "none";
			this.showing = inShowing;
		}
		if (inShowing)
			this.size();

	},
	size: function(inNode) {
		if (!this.domNode || !this.showing)
			return;
		if (inNode)
			this.sizeNode = inNode;
		var sizeNode = this.sizeNode || document.body;
		dojo.marginBox(this.domNode, dojo.contentBox(sizeNode));
	}
};

dojo.addOnLoad(function() {
	// iframe covering required on IE6 and (wah) on FF2 Mac
	if ((dojo.isIE && dojo.isIE < 7) || (dojo.isMoz && dojo.isMoz < 6 && navigator.userAgent.indexOf("Macintosh") != -1))
		wm.bgIframe.create();
});

dojo.declare("wm.Dialog", wm.Container, {
    containerClass: "MainContent",
    corner: "cc", // center vertical, center horizontal; this is almost always the desired default... but for some nonmodal dialogs, its useful to have other options
    scrim: true,

    useContainerWidget: false,  // if true, we create a container widget, if false we just use the dom node directly.  dom node is fine if you just want to set innerHTML or stick a 3rd party widget into the dialog.
    useButtonBar: true,
    _minified: false,
    _maxified: false,
    noEscape: false,
	layoutKind: "top-to-bottom",
    horizontalAlign: "left",
    verticalAlign: "top",
	border: 2,
    borderColor: "rgb(80,80,80)",
    titlebarBorder: "1",
    titlebarBorderColor: "black",
    titlebarHeight: "23",
/*
	contentWidth: 640,
	contentHeight: 400,
	*/
    margin: "3",
    width: "640px",
    height: "400px",
	showing: false,
        dialogScrim: null,
	modal: true,
    init: function() {
        this.inherited(arguments);
	this.dialogScrim = new wm.Scrim({owner: this, _classes: {domNode: ["wmdialog-scrim"]}, waitCursor: false});
	this.createTitle();
    },
	postInit: function() {
		this.inherited(arguments);
	    if (this.isDesignedComponent())
		studio.designer.domNode.appendChild(this.domNode);
	    else
		document.body.appendChild(this.domNode);
		dojo.addClass(this.domNode, "wmdialog");
/*
		this.setContentWidth(this.contentWidth);
		this.setContentHeight(this.contentHeight);
		*/
		this.domNode.style.position = "absolute";
	    this.domNode.style.zIndex = wm.dialog.getNextZIndex();
		this.domNode.style.display = "none";		
		this._connections.push(this.connect(document, "onkeypress", this, "keyPress"));
		this._subscriptions.push(dojo.subscribe("window-resize", this, "reflow"));	    

	    var containerWidget, containerNode;
	    
	    if (this.$.containerWidget)
		this.containerWidget = this.$.containerWidget;

                    var owner = (this.declaredClass == "wm.Dialog" || this instanceof wm.DesignableDialog) ? this.owner : this; // set the owner to wm.Page to allow othis to be written... IF its an instance not a subclass of wm.Dialog

	    if (this.useContainerWidget) {
		if (!this.containerWidget) {
                    for (var i = 0; i < this.c$.length; i++) {
                        if (this.c$[i].name.match(/containerWidget/)) {
                            this.containerWidget = this.c$[i];
                            break;
                        }
                    }
                }
	            containerWidget = this.containerWidget ||  new wm.Container({
			_classes: {domNode: ["wmdialogcontainer", this.containerClass]}, 
			name: owner.getUniqueName("containerWidget"),
			parent: this,
			owner: owner,
			layoutKind: "top-to-bottom",
			padding: "5",
			fitToContentHeight: this.fitToContentHeight,
			margin: "0",
			border: "0",
			width: "100%",
			height: "100%",
			horizontalAlign: "left",
			verticalAlign: "top",
			autoScroll: true});
		containerNode = containerWidget.domNode;
	    } else {
	        containerNode = this.domNode;//this.container.domNode;
	    }
	    this.setModal(this.modal);

            this.setTitlebarBorder(this.titlebarBorder);
            this.setTitlebarBorderColor(this.titlebarBorderColor);

	    if (this.useButtonBar) {
		if (this.$.buttonBar)
		    this.buttonBar = this.$.buttonBar;
		else if (this.useContainerWidget) {
		    this.buttonBar = new wm.Panel({_classes: {domNode: ["dialogfooter"]},
						   name: "buttonBar",
						   owner: owner,
						   parent: this,
						   width: "100%",
						   height: "0px",
						   fitToContentHeight: true,
						   minHeight: (this.isDesignLoaded()) ? 5 : 1,
						   horizontalAlign: "right",
						   verticalAlign: "top",
						   layoutKind: "left-to-right",
						   border: this.footerBorder + ",0,0,0",
						   borderColor: this.titlebarBorderColor});
		}
	    }
	    // must set this AFTER creating the button bar, or the button
	    // bar will be ADDED to the containerWidget
	    if (containerWidget) {
		this.containerWidget = containerWidget;
	    }
	    this.containerNode = containerNode;
	},
    setTitlebarBorder: function(inBorder) {
        this.titlebarBorder = inBorder;
	var border = (String(inBorder).match(",")) ? inBorder : "0,0," + inBorder + ",0";
        this.titleBar.setBorder(border);
        this.titleBar.setHeight((parseInt(this.titlebarHeight) + this.titleBar.padBorderMargin.t + this.titleBar.padBorderMargin.b) + "px");
    },
    setTitlebarBorderColor: function(inBorderColor) {
        this.titlebarBorderColor = inBorderColor;
        this.titleBar.setBorderColor(inBorderColor);
    },
    setFooterBorder: function(inBorder) {
        this.footerBorder = inBorder;
        if (this.$.buttonBar) {
            this.$.buttonBar.setBorder(inBorder + ",0,0,0");
            //this.$.buttonBar.setHeight((34 + this.$.buttonBar.padBorderMargin.t + this.$.buttonBar.padBorderMargin.b) + "px");
        }
    },
    setFooterBorderColor: function(inBorderColor) {
        this.footerBorderColor = inBorderColor;
        if (this.$.buttonBar)
            this.$.buttonBar.setBorderColor(inBorderColor);
    },

    setModal: function(inModal) {
	dojo[inModal ? "removeClass" : "addClass"](this.domNode, "nonmodaldialog");
	this.modal = (inModal === undefined || inModal === null) ? true : inModal;

	if (this.dojoMoveable) {
	    this.dojoMoveable.destroy();
	    this.dojoMoveable = null;
	}
	if (!inModal) 
	    this.dojoMoveable = new dojo.dnd.Moveable(this.domNode, {handle: this.titleLabel.domNode});
	if (this.showing) {
	    this.dialogScrim.setShowing(this.modal);
	    wm.bgIframe.setShowing(!this.modal && !this.isDesignedComponent());
	}
	this.titleClose.setShowing(!this.modal && !this.noEscape);
	this.titleMinify.setShowing(!this.modal);
	this.titleMaxify.setShowing(!this.modal);
    },
    setNoEscape: function(inNoEscape) {
	this.noEscape = inNoEscape;
	this.titleClose.setShowing(!this.modal && !this.noEscape);
    },	
    minify: function() {
	this._minified = true;
	this.setShowing(false);
	if (!app.wmMinifiedDialogPanel) {
	    app.createMinifiedDialogPanel();
	}
	this.minifiedLabel = app.createMinifiedDialogLabel(this.title);
	this.minifiedLabel.connect(this.minifiedLabel, "onclick", this, function() {
	    app.removeMinifiedDialogLabel(this.minifiedLabel);
	    delete this.minifiedLabel;
	    app.wmMinifiedDialogPanel.reflow();
	    this._minified = false;
	    this.setShowing(true);
	});
	app.wmMinifiedDialogPanel.reflow();
    },
    unminifyormove: function(inEvent) {
	this._unminifyMouseX = inEvent.x;
	this._unminifyMouseY = inEvent.y;
    },
    unminify: function(inEvent, dontCallSetShowing) {
	if (!this._minified) return;
	app.removeMinifiedDialogLabel(this.minifiedLabel);
	delete this.minifiedLabel;
	    app.wmMinifiedDialogPanel.reflow();
	this._minified = false;
	if (!dontCallSetShowing) 
	    this.show();
    },
    maxify: function() {
	if (this._maxified) {
	    this._maxified = false;
	    //this.titleMaxify.setCaption(" ");
	    this.bounds.h = parseInt(this.height);
	    this.bounds.w = parseInt(this.width);
	} else {
	    this._maxified = true;
	    //this.titleMaxify.setCaption("O");
	}
	this.renderBounds();
	this.reflow();
    },

	reflowParent: function() {
	},

	dismiss: function(e) {
	        this.setShowing(false, false, true);
		var why = "" || dojo.isString(e) ? e : e && e.target && e.target.innerHTML;
		this.onClose(why);
		why = null;
	},
        destroy: function() {
	    this.dismiss();
	    if (this.dialogScrim)
                this.dialogScrim.destroy();
	    if (this.minifiedLabel)
		this.minfiedLabel.destroy();
	    this.inherited(arguments);
	},
	flow: function() {
		if (this.showing) {
			// Dialog is responsible for rendering itself.
			this.renderBounds();
			this.inherited(arguments);
			this.dialogScrim.reflowParent();
		}
	},
 	renderBounds: function() {
		if (this.showing) {
		    if (this.fitToContentHeight) 
			this.bounds.h = this.getPreferredFitToContentHeight();

		    if (this._minified) {
			var parentBox = dojo.contentBox(window.document.body);
			var t = parentBox.h - 30;
			var l = parentBox.w - 200;
			this.setBounds(l,t,200,30);
		    } else if (this._maxified) {
			var parentBox = dojo.contentBox(window.document.body);
			this.setBounds(20,20,parentBox.w-40,parentBox.h-40);
		    } else {
			//// center within parent
			//var parentBox = dojo.contentBox(this.domNode.parentNode);
			//var bounds = this.getBounds();
                        if (!this._fixPosition) {
                            this.renderBoundsByCorner();
/*
			    var t = (parentBox.h - bounds.h) / 2;
			    var l = (parentBox.w - bounds.w) / 2;
			    this.setBounds(l, t);
			    this.domNode.style.top = t + "px";
			    this.domNode.style.left = l + "px";
                            */
                        } else {
                            this.insureDialogVisible();
                        }
		        wm.bgIframe.size();
		    }
/*
		    if (this.isDesignedComponent()) 
			this.dialogScrim.size(studio.designer.domNode);
			*/
		    return this.inherited(arguments);
		}            
	},
        // This should be able to take both the human readable value "top right", and also the streamlined "tr" and have it work regardless.
    // Note that vertical axis must always come before horizontal axis
    setCorner: function(inCorner) {
        this.corner = inCorner.replace(/top/, "t").replace(/bottom/,"b").replace(/left/,"l").replace(/right/,"r").replace(/center/,"c").replace(/ /,"");
        this.renderBoundsByCorner();
    },
/* if the dialog is off the edge of the screen, attempt to compensate */
    insureDialogVisible: function() {
	if (!this.showing) return;
        var w = this.bounds.w;
        var h = this.bounds.h;
        var isDesigned =  (this.domNode.parentNode != document.body);
        var W = (isDesigned) ? studio.designer.bounds.w : app._page.root.bounds.w;
        var H = (isDesigned) ? studio.designer.bounds.h : app._page.root.bounds.h;
        if (this.bounds.t + this.bounds.h > H)
            this.bounds.t = H - this.bounds.h;
        if (this.bounds.l + this.bounds.w > W)
            this.bounds.l = W - this.bounds.w;
        if (this.bounds.t < 0)
            this.bounds.t = 0;
        if (this.bounds.l < 0)
            this.bounds.l = 0;

	wm.Control.prototype.renderBounds.call(this);        
    },
    renderBoundsByCorner: function() {
	if (!this.showing) return;
        var w = this.bounds.w;
        var h = this.bounds.h;
/*
        var isDesigned =  (this.domNode.parentNode != document.body);
        var W = (isDesigned) ? studio.designer.bounds.w : app._page.root.bounds.w;
        var H = (isDesigned) ? studio.designer.bounds.h : app._page.root.bounds.h;
        */
        var W = this.domNode.parentNode.clientWidth;
        var H = this.domNode.parentNode.clientHeight;
        var buffer = 10;
        var t,l;
        
        var top  = this.corner.substring(0,1);
        var left = this.corner.substring(1,2);
	for (var i = wm.dialog.showingList.length - 1; i >= 0 && wm.dialog.showingList[i] == this; i--)
	    ;
	var last = (i >= 0 && (!window["studio"] || this != window["studio"].dialog)) ? wm.dialog.showingList[i] : null;

        switch(left) {
        case "l":
            l = buffer;
            break;
        case "r":
            l = W - w - buffer;
            break;
        case "c":
	    if (last && last.corner == this.corner)
		l = last.bounds.l + 15;
	    else
		l = Math.floor((W - w)/2);

            break;
        }

        switch(top) {
        case "t":
            t = buffer;
            break;
        case "b":
            t = H - h - buffer;
            break;
        case "c":
	    if (last && last.corner == this.corner)
		t = last.bounds.t + 15;
	    else
		t = Math.floor((H - h)/2);
            break;
        }

	this.setBounds(l, t, w, h);
	wm.Control.prototype.renderBounds.call(this);
    },
	setContent: function(inContent) {
		this.containerNode.innerHTML = inContent;
	},
        setShowing: function(inShowing, forceChange, skipOnClose) {
		if (inShowing != this.showing && this.modal)
			this.dialogScrim.setShowing(inShowing);
		this.inherited(arguments);
		// global flag for easily finding the most recently shown dialog
	        wm.Array.removeElement(wm.dialog.showingList, this);
	    if (inShowing && (!window["studio"] || this != window["studio"].dialog)) {
		    wm.dialog.showingList.push(this);
	        this.domNode.style.zIndex = wm.dialog.getNextZIndex();
            }

		if (this.showing) {
		    if (this._minified)
			this.unminify(null, true);
			this.reflow();
		}/* else
			// FIXME: hide any tooltips that may be showing
			wm.hideToolTip(true);*/
	    wm.bgIframe.setShowing(inShowing && this.modal && !this.isDesignedComponent());

		if (this.showing)
			this.onShow();
	        else if (!skipOnClose) 
		    this.onClose("");
	    if (this.designWrapper)
		this.designWrapper.setShowing(inShowing);
	},
/*
	setContentWidth: function(inWidth) {
		this.contentWidth = inWidth;
		this.setWidth(inWidth + "px");
	},

	setContentHeight: function(inHeight) {
		this.contentHeight = inHeight;
		this.setHeight(inHeight + "px");
	},
	setContentSize: function(inWidth, inHeight) {
		this.setContentWidth(inWidth);
		this.setContentHeight(inHeight);
	},
	*/
	keyPress: function(inEvent) {
            if (!this.showing) return true;
            var dialogs = dojo.query(".wmdialog");
            var zindex = parseInt(this.domNode.style.zIndex);
            for (var i = 0; i < dialogs.length; i++) {
                if (dialogs[i].style.display != "none" && parseInt(dialogs[i].style.zIndex) > zindex) {
                    return true; // this isn't the foremost dialog
                }
            }

	    if (inEvent.keyCode == dojo.keys.ESCAPE && !this.noEscape) {
		if (this.showing) {
		    this.setShowing(false);
		    this.onClose("cancel");
		    //inEvent.stopPropagation(); // Else escape will also change what the selected canvas item is
		}
	    } else if (inEvent.keyCode == dojo.keys.ENTER) {
                if (this.$.textInput && this.$.textInput.getDataValue)
                    this.onEnterKeyPress(this.$.textInput.getDataValue());
                else
                    this.onEnterKeyPress();
            }
            return true;
	},
        onEnterKeyPress: function(inText) {
        },
	onShow: function() {
	},
	onClose: function(inWhy) {
	},
    setTitlebarHeight: function(inHeight) {
        this.titlebarHeight = inHeight;
        if (this.titleBar) this.titleBar.setHeight(inHeight + "px");
    },
    createTitle: function() {
	this.titleBar = new wm.Container({_classes: {domNode: ["dialogtitlebar"]}, 
					  noInspector: true,
					  showing: this.title,
					  name: "titleBar", 
					  parent: this,
					  owner: this,
					  width: "100%",
					  height: this.titlebarHeight + "px",
					  margin: "0",
					  padding: "0",
					  border: this.titlebarBorder,
					  borderColor: this.titlebarBorderColor,
					  verticalAlign: "middle",
					  layoutKind: "left-to-right"});
	this.titleClose = new wm.Picture({_classes: {domNode: ["dialogclosebutton"]},
					  source: "/wavemaker/lib/wm/base/widget/themes/default/images/blank.gif",
					  noInspector: true,
					 name: "titleClose",
					 width: "22px",
					 height: "19px",
					  margin: "3,3,0,3",
					 parent: this.titleBar,
					 owner: this,
					 showing: !this.modal && !this.noEscape });
	this.titleMinify = new wm.Picture({_classes: {domNode: ["dialogminifybutton"]},
					  noInspector: true,
					  source: "/wavemaker/lib/wm/base/widget/themes/default/images/blank.gif",
					  name: "titleMinify",
					  width: "19px",
					 height: "19px",
					  margin: "3,3,0,0",
					  parent: this.titleBar,
					  owner: this,
					  showing: !this.modal});	

	this.titleMaxify = new wm.Picture({_classes: {domNode: ["dialogmaxifybutton"]},
					  noInspector: true,
					  source: "/wavemaker/lib/wm/base/widget/themes/default/images/blank.gif",
					  name: "titleMinify",
					  caption: " ",
					  width: "19px",
					 height: "19px",
					  margin: "3,3,0,0",
					  parent: this.titleBar,
					  owner: this,
					  showing: !this.modal});	
	this.titleLabel = new wm.Label({
					  noInspector: true,
	                                name: "dialogTitleLabel",
					parent: this.titleBar,
					owner: this,
					caption: this.title,
					showing: Boolean(this.title),
					margin: "3,3,0,10",
					width: "100%",
					height: "100%"});
	//this.titleBevel = new wm.Bevel({ parent: this, owner: this, showing: Boolean(this.title) });
	this.connect(this.titleClose, "onclick", this, "dismiss");
	this.connect(this.titleMinify, "onclick", this, "minify");
	this.connect(this.titleMaxify, "onclick", this, "maxify");
	this.connect(this.titleLabel, "onclick", this, "unminify");
	this.connect(this.titleLabel.domNode, "onmousedown", this, "unminifyormove");
    },
    setTitle: function(inTitle) {
	this.title = inTitle;
	if (this.titleLabel) {
	    this.titleLabel.setCaption(inTitle);
	    this.titleLabel.setShowing(true);
	}	
	if (this.titleBar)
	    this.titleBar.setShowing(Boolean(inTitle));
    },
    setSizeProp: function(n, v, inMinSize) {
	this.inherited(arguments);
	this.renderBounds();
	if(this.designWrapper) {
	    this.designWrapper.controlBoundsChange();
	    this.designWrapper.renderBounds();			
	}
        this.reflow();
    },

    // this is what is called when you bind an event handler to a dialog
    update: function() {
	this.show();
    },
    // design only; fired when dialog is selected; we want it to autoshow when selected in the designer
    activate: function() {
	this.show();
    },
    // design only; fired when dialog is selected; we want it to autohide when deselected in the designer
    deactivate: function() {
	this.hide();
    }
});


wm.Dialog.extend({
    themeableStyles: ["wm.Dialog_Inner-Radius"],
    // backward-compatibility fixups
	afterPaletteDrop: function() {
	    this.inherited(arguments);
	    this.setParent(null);
	    studio.designer.domNode.appendChild(this.domNode);
	    this.show();
	},
    makePropEdit: function(inName, inValue, inDefault) {
	switch (inName) {
        case "corner":
            inValue = inValue.replace(/^c/, "center ").replace(/^t/, "top ").replace(/^b/, "bottom ").replace(/l$/, "left").replace(/r$/, "right").replace(/c$/, "center");
            return new wm.propEdit.Select({component: this, value: inValue, name: inName, options: ["top left", "top center", "top right", "center left", "center center", "center right", "bottom left", "bottom center", "bottom right"]});
	}
	return this.inherited(arguments);
    },

});


wm.Object.extendSchema(wm.Dialog, {
    title: {group: "Header and Footer", order: 1},
    titlebarBorder: {group: "Header and Footer", order: 5},
    titlebarBorderColor: {group: "Header and Footer", order: 6},
    titlebarHeight: {group: "Header and Footer", order: 7},
    noEscape: {group: "Dialog Keyboard", order: 1},
    enterKeyIsButton1: {group: "Dialog Keyboard", order: 2, ignore: 1},
    modal: {group: "Dialog Options", order: 1},
    fitToContentWidth: {ignore: 1},
    fitToContentHeight: {ignore: 1},
    useContainerWidget: {ignore: 1},
    useButtonBar: {ignore: 1}, // user doesn't decide this; buttonbar is autosizing; if nothing in there, then it doesn't show.
    lock: {ignore: 1},
    freeze: {ignore: 1},
    padding: {ignore: 1},
    margin: {ignore: 1},
    scrollX: {ignore: 1},
    scrollY: {ignore: 1},
    layoutKind: {ignore: 1},
    horizontalAlign: {ignore: 1},
    verticalAlign: {ignore: 1},
    showing: {ignore: 1},
    owner: { group: "common", order: 1, readonly: true, options: ["Page", "Application"] }
});




dojo.declare("wm.WidgetsJsDialog", wm.Dialog, { 
    margin: "0,4,4,0",
    useContainerWidget: true,
    useButtonBar: false,
    widgets_data: null,
    widgets_json: "",
    width: "400px",
    height: "150px",

    setShowing: function(inShowing, forceChange) {
	this.inherited(arguments);
	if (this.isReflowEnabled() && !this._rendered) {
	    this.leafFirstRenderCss();
	    this._rendered = true;
	}
    },
    postInit: function() {
	this.inherited(arguments);
	if (!this.widgets_data)
	    this.setWidgetsJson(this.widgets_json);
	this.generateContents();
	this.containerWidget.setPadding("0");
	this.renderBounds();
	this.reflow();
    },

    setWidgetsJson: function(inJson) {
	try {
	    this.widgets_json = inJson;
	    this.widgets_data = dojo.fromJson(this.widgets_json);
	    if (!this._cupdating)
		this.generateContents();
	} catch(e) {console.error(e);}
    },
    generateContents: function() {
	this.containerWidget._cupdating = true;
	this.containerWidget.createComponents(this.widgets_data, this);
	this.containerWidget._cupdating = false;
	this.containerWidget.reflow();
    }
});


dojo.declare("wm.RichTextDialog", wm.WidgetsJsDialog, {
    autoScroll: false,
    noEscape: true,
    footerBorder: "",
    footerBorderColor: "",
    title: "Write Your Documentation",
    padding: "0",
    width: "500px",
    height: "500px",
    modal: false,
    html: "", // initial html to show in the editor; use getHtml for current value
    prepare: function() {
        this.inherited(arguments);
        this.widgets_data = {documentation: ["wm.RichText", {width: "100%", height: "100%", "toolbarAlign":false,"toolbarLink":true,"toolbarColor":true, dataValue: this.html, displayValue: this.html}, {}],
		             buttonBar: ["wm.Panel", {_classes: {domNode: ["dialogfooter"]}, name: "buttonBar", layoutKind: "left-to-right",  padding: "2,0,2,0", horizontalAlign: "right", height: "34px", fitToContentHeight: true, width: "100%", borderColor: this.footerBorderColor, border: this.footerBorder + ",0,0,0"}, {}, {
		                 okButton: ["wm.Button", {"width":"150px","caption": "OK"}, {"onclick":"onOkClick"}],
		                 cancelButton: ["wm.Button", {"width":"150px","caption": "Cancel"}, {"onclick":"onCancelClick"}]
	                     }]};
    },
 
    setHtml: function(inHtml) {
        this.html = inHtml; // for design mode use only
        if (this.$.documentation)
	    this.$.documentation.setDataValue(inHtml);
    },
    getHtml: function() {
        if (this.$.documentation)
	    return this.$.documentation.getDataValue();
    },
    onOkClick: function() {
	this.dismiss();
    },
    onCancelClick: function() {
	this.dismiss();
    },
    setShowing: function(inShowing) {
        this.inherited(arguments);
        if (this.$.documentation && !this.$.documentation.editor)
            this.$.documentation.setShowing(true);
    }
});
wm.Object.extendSchema(wm.RichTextDialog, {
    html: {group: "Dialog Options", order: 2, bindable: true, simpleBindProp: true},
    enterKeyIsButton1: {group: "Dialog Keyboard", order: 2},
    footerBorder: {group: "style", order: 100},
    footerBorderColor:  {group: "style", order: 101}
});
wm.RichTextDialog.extend({
    themeable: false
});

dojo.declare("wm.GenericDialog", wm.WidgetsJsDialog, {
    enterKeyIsButton1: true,
    autoScroll: false,
    noEscape: true,
    title: "Generic Dialog",
    footerBorder: "",
    footerBorderColor: "",
    padding: "0",
    regExp: ".*",
    button1Caption: "",
    button2Caption: "",
    button3Caption: "",
    button4Caption: "",
    button1Close: false,
    button2Close: false,
    button3Close: false,
    button4Close: false,
    userPrompt: "Testing...",
    showInput: false,
    prepare: function() {
        this.inherited(arguments);
        this.widgets_data = {
	    genericInfoPanel: ["wm.Panel", {layoutKind: "top-to-bottom",  width: "100%", height: "100%", horizontalAlign: "left", verticalAlign: "top", autoScroll: true, fitToContentHeight: true, padding: "10,5,10,5"}, {}, {
		userQuestionLabel: ["wm.Html", {autoScroll: false, "height":"25px",autoSizeHeight: true, "width":"100%",html: ""}],
		textInput: ["wm.TextEditor", {"width":"100%","captionSize":"0%","showing":false}, {}, {
		    editor: ["wm._TextEditor", {}, {}]
		}]
	    }],
	    buttonBar: ["wm.Panel", {_classes: {domNode: ["dialogfooter"]},
				    name: "buttonBar",
				    layoutKind: "left-to-right",
				    padding: "2,6,2,6", 
				    horizontalAlign: "right",
                                     borderColor: this.footerBorderColor, border: this.footerBorder + ",0,0,0",
				     fitToContentHeight: true,
				    height: "34px",
				    width: "100%"}, {}, {
		                        button4: ["wm.Button", {"width":"130px","showing":false}, {"onclick":"buttonClick"}],
		                        button3: ["wm.Button", {"width":"130px","showing":false}, {"onclick":"buttonClick"}],
		                        button2: ["wm.Button", {"width":"130px","showing":false}, {"onclick":"buttonClick"}],
		                        button1: ["wm.Button", {"width":"130px","showing":false}, {"onclick":"buttonClick"}]
	                            }]
        };

    },
    postInit: function() {
	this.inherited(arguments);
        this.setFooterBorder(this.footerBorder);
        this.setFooterBorderColor(this.footerBorderColor);

	var captionFound = false;
	for (var i = 1; i <= 6; i++) {
	    var caption = this["button" + i + "Caption"];
	    var button = this.$["button" + i];
	    if (caption) {
		captionFound = true;
		button.setCaption(caption);
		button.show();
	    }
            if (this.$.buttonBar)
	        this.$.buttonBar.setShowing(captionFound);
	    this.setShowInput(this.showInput);
	}
        if (this.$.userQuestionLabel)
	    this.$.userQuestionLabel.setHtml(this.userPrompt);
        this.containerWidget.setFitToContentHeight(true);
    },
    setFooterBorder: function(inBorder) {
        this.footerBorder = inBorder;
        if (this.$.buttonBar) {
            this.$.buttonBar.setBorder(inBorder);
            this.$.buttonBar.setHeight((34 + this.$.buttonBar.padBorderMargin.t + this.$.buttonBar.padBorderMargin.b) + "px");
        }
    },
    setFooterBorderColor: function(inBorderColor) {
        this.footerBorderColor = inBorderColor;
        if (this.$.buttonBar)
            this.$.buttonBar.setBorderColor(inBorderColor);
    },
    // handle fitToContentHeight adjustments
    reflow: function() {
        try {
            if (!this._settingHeight) {
                var height = this.getPreferredFitToContentHeight();
                this._settingHeight = true;
                this.setHeight(height + "px");
                this._settingHeight = false;
                this.inherited(arguments);
            }
        } catch(e) {this._settingHeight = false;}
        
    },
    setShowing: function(inShowing,forceChange) {
        this.inherited(arguments);
        if (inShowing) {
            if (this.$.userQuestionLabel)
                this.$.userQuestionLabel.doAutoSize(true,true);
            if (this.showInput && this.$.textInput && this.$.textInput.focus)
                this.$.textInput.focus();
            wm.onidle(this, "reflow");
        }
    },
    setShowInput: function(inShowInput) {
	this.showInput = inShowInput;
        if (this.$.textInput)
	    this.$.textInput.setShowing(inShowInput);
    },

    setInputDataValue: function(inValue) {
        if (this.$.textInput)
	    this.$.textInput.setDataValue(inValue);
    },
        getInputDataValue: function(inValue) {
        var result;
        if (this.$.textInput) {
	    result = this.$.textInput.getDataValue();
            if (dojo.isString(result))
                result = dojo.trim(result);
            return result;
        }
    },
    setUserPrompt: function(inPrompt) {
	this.userPrompt = inPrompt;
        if (this.$.userQuestionLabel)
	    this.$.userQuestionLabel.setHtml(inPrompt);
    },
    setButton1Caption: function(inCap) {this.setButtonCaption(1,inCap);},
    setButton2Caption: function(inCap) {this.setButtonCaption(2,inCap);},
    setButton3Caption: function(inCap) {this.setButtonCaption(3,inCap);},
    setButton4Caption: function(inCap) {this.setButtonCaption(4,inCap);},
    
    setButtonCaption: function(inButtonNumber, inButtonCaption) {
	var button = this.$["button" + inButtonNumber];
	this["button" + inButtonNumber + "Caption"] = inButtonCaption;
        if (!button) return;
	if (inButtonCaption) {
	    button.setCaption(inButtonCaption);
	    button.show();
	} else {
	    button.hide();
	}	
	this.$.buttonBar.setShowing(this.button1Caption || this.button2Caption || this.button3Caption || this.button4Caption);
    },
    onEnterKeyPress: function(inText) {
        if (this.enterKeyIsButton1) {
            if (this.button1Close) this.dismiss();
            this.onButton1Click(this.button1, inText);
        }
    },
    buttonClick: function(inSender) {
	var name = inSender.name;
	var id = parseInt(name.match(/\d+/)[0]);
	if (this["button" + id + "Close"]) this.dismiss();

	var text = (this.$.textInput) ? this.$.textInput.getDataValue() : "";
	switch(id) {
	case 1:  this.onButton1Click(inSender, text);break;
	case 2:  this.onButton2Click(inSender, text);break;
	case 3:  this.onButton3Click(inSender, text);break;
	case 4:  this.onButton4Click(inSender, text);break;
	}
    },
    onButton1Click: function(inButton, inText) {},
    onButton2Click: function(inButton, inText) {},
    onButton3Click: function(inButton, inText) {},
    onButton4Click: function(inButton, inText) {},
});


wm.Object.extendSchema(wm.GenericDialog, {
    
    enterKeyIsButton1: {group: "Dialog Keyboard", order: 2},
    widgets_json: {ignore: 1},
    button1Caption: {group: "Buttons", order: 1},
    button1Close: {group: "Buttons", order: 2},
    button2Caption: {group: "Buttons", order: 3},
    button2Close: {group: "Buttons", order: 4},
    button3Caption: {group: "Buttons", order: 5},
    button3Close: {group: "Buttons", order: 6},
    button4Caption: {group: "Buttons", order: 7},
    button4Close: {group: "Buttons", order: 8},
    footerBorder: {group: "Header and Footer", order: 10},
    footerBorderColor: {group: "Header and Footer", order: 11},
    userPrompt: {group: "Dialog Options", order: 2, bindTarget: true},
    showInput: {group: "Dialog Options", order: 3, bindTarget: true},
    inputDataValue: {group: "Dialog Options", order: 4, bindable: true, simpleBindProp: true},
    regExp: {group: "Dialog Options", order: 4},
    footerBorder: {group: "style", order: 100},
    footerBorderColor:  {group: "style", order: 101}
});

wm.GenericDialog.extend({

});


dojo.declare("wm.FileUploadDialog", wm.GenericDialog, {
    uploadService: "",
    uploadOperation: "",
    width: "500px",
    height: "120px",
    showInput: true,
    button1Caption: "Upload",
    button2Caption: "Cancel",
    button1Close: true,
    button2Close: true,
    postInit: function() {
        this.widgets_data.genericInfoPanel[3].textInput = ["wm.FileUpload", {  caption: "",
                                                                               uploadButton: false,
						   padding: "0,20,0,20",
						   width: "100%",
						   height: "28px",
						   captionSize: "100px",						   
						   captionAlign: "left",
						   captionPosition: "left",
						   uploadButtonPosition: "right",
						   uploadButtonWidth: "100px",
						   uploadButtonHeight: "30px",
						   service: "",
						   operation: ""}, 
                                                {  onUploadSuccess: "importClickCallback",
						   onUploadError: "importClickError",
						   onBegin:       "startImportClick"}, {}];
        this.inherited(arguments);
        this.fileUploader = this.$.textInput;
        this.setUploadService(this.uploadService);
        this.setUploadOperation(this.uploadOperation);
    },
    startImportClick: function(inSender) {
        if (window["studio"])
	    studio.beginWait("Importing File...");
    },			  
    importClickCallback: function(inSource, inResponse) {
        if (window["studio"])
	    studio.endWait();
	wm.fire(this.owner, "dismiss");
    },
    importClickError: function(inSource,inError) {
        if (window["studio"])
	    studio.endWait();
        app.toastDialog.showToast("Import failed!", 3000, "Warning");
	// any notification to user must be done by the component that requested the file
    },
    setUploadService: function(inService) {
	this.uploadService = inService;
	this.fileUploader.setService(inService);
    },
    setUploadOperation: function(inOperation) {
	this.uploadOperation = inOperation;
	this.fileUploader.setOperation(inOperation);
    },


    buttonClick: function(inSender) {
	var name = inSender.name;
	var id = parseInt(name.match(/\d+/)[0]);
	switch(id) {
	case 1:  this.onButton1Click(inSender);break;
	case 2:  this.onButton2Click(inSender);break;
	case 3:  this.onButton3Click(inSender);break;
	case 4:  this.onButton4Click(inSender);break;
	case 5:  this.onButton5Click(inSender);break;
	case 6:  this.onButton6Click(inSender); break;
	}
	if (this["button" + id + "Close"]) this.dismiss();
    },

    onButton1Click: function(inButton) {
        this.fileUploader.upload();
    },

    onButton2Click: function(inButton) {},
    onButton3Click: function(inButton) {},
    onButton4Click: function(inButton) {},
    onButton5Click: function(inButton) {},
    onButton6Click: function(inButton) {}
});


dojo.declare("wm.Toast", wm.WidgetsJsDialog, {
    classNames: "wmtoast wmtoastExtraSpecific",
    title: "",
    modal: false,
    useContainerWidget: true,
    _timeoutId: 0,
    duration: 5000,
    content: "Toast",
    height: "100px",
    width: "350px",
    corner: "br", // bottom right
    border: "2",
    margin: "0",
    prepare: function() {
        this.inherited(arguments);
        this.widgets_data = {
	    img: ["wm.Picture", {_classes: {domNode: ["ToastLeft"]}, width: "30px", height: "100%",margin: "4,0,0,4"}],
	    rightColumn: ["wm.Panel", {layoutKind: "top-to-bottom", width: "100%", height: "100%", fitToContentHeight: true, padding: "0"},{},{
		title: ["wm.Label", { height: "20px", width: "100%", singleLine: true}],
		message: ["wm.Label", { height: "100px", width: "100%", singleLine: false, autoSizeHeight: true}]
	    }]
	};
    },
    postInit: function() {
	this.inherited(arguments);
	this.containerWidget.setLayoutKind("left-to-right");
	this.containerWidget.setPadding("4");	
        this.img = this.containerWidget.c$[0];
        this.title = this.containerWidget.c$[1].c$[0];
        this.message = this.containerWidget.c$[1].c$[1];

	this.setContent(this.content);
	this.connectEvents(this.domNode, ["click"]);
    },
    click: function() {
        this.fadeaway(true);
        this.onToastClick();
    },
    onToastClick: function() {},
    setShowing: function(inShow, forceChange) {
        this.inherited(arguments);
        if (inShow)
            this.renderBounds();
    },
    renderBounds: function() {
        this.renderBoundsByCorner();
    },
    setContent: function(inContent) {
	this.content = inContent;
        if (this.message)
            this.message.setCaption(inContent);
    },
    setTitle: function(inTitle) {
	if (this.title)
	    this.title.setCaption(inTitle);
    },
    // classes supported "Success", "Error", "Warning", "Info".  User may add their own classes via css file
    showToast: function(inContent,inDuration, inCssClasses, inPosition, optionalTitle) {
        if (inPosition)
            inPosition = inPosition.replace(/top/, "t").replace(/bottom/,"b").replace(/left/,"l").replace(/right/,"r").replace(/center/,"c").replace(/ /,"");
        this.corner = inPosition || app.toastPosition || "br";
	if (this._timeoutId) {
	    window.clearTimeout(this._timeoutId);
	    this.hide();
	    this._timeoutId = 0;
	}
	this.setTitle(optionalTitle || inCssClasses);
        inCssClasses = inCssClasses || "Info";
        var classes = (inCssClasses) ? inCssClasses.split(" ") : [];

        if (dojo.indexOf(classes, "Success") != -1) {
            this.setBorderColor("rgb(0,120,0)");
        } else if (dojo.indexOf(classes, "Error") != -1) {
            this.setBorderColor("rgb(120,0,0)");
        } else if (dojo.indexOf(classes, "Warning") != -1) {
            this.setBorderColor("#f9a215");
        } else {
            this.setBorderColor("rgb(0,0,0)");
        }

        this.message.autoSizeHeight = false;
	this.setContent(inContent);
        this.message.autoSizeHeight = true;
	this.duration = inDuration || this.duration;
	this.domNode.className = this.classNames + " " + ((inCssClasses) ? inCssClasses : "");

        // After a timeout, animate the toast away
	this._timeoutId = window.setTimeout(dojo.hitch(this, "fadeaway"), this.duration);

	this.domNode.style.opacity = "0.01";
	this.show();
        this.message.doAutoSize(true, true);
        this.setHeight((this.containerWidget.padBorderMargin.t + this.containerWidget.padBorderMargin.b + this.message.parent.bounds.h + this.padBorderMargin.t + this.padBorderMargin.b) + "px" );
	dojo.anim(this.domNode, { opacity: 1}, 800);

    },
    fadeaway: function(fromClick) {
        if (!this._timeoutId) return;
	this._timeoutId = 0;
        if (fromClick) {
	    dojo.anim(this.domNode, { opacity: 0 }, 200, null, dojo.hitch(this, function() {
                this.hide();
                this.domNode.style.opacity = 1;
            }));
        } else {
	    dojo.anim(this.domNode, { opacity: 0.01 }, 500, null, dojo.hitch(this, function() {this.hide();}));
        }
    },
    // this is what is called when you bind an event handler to a dialog; call showToast so that the timer is triggered
    update: function() {
	this.showToast(this.content,this.duration, this.domNode.className);
    }

});

dojo.declare("wm.ToastFirstDraft", wm.Dialog, {
    classNames: "wmtoast wmtoastExtraSpecific",
    title: "",
    modal: false,
    useContainerWidget: true,
    _timeoutId: 0,
    duration: 5000,
    content: "Toast",
    height: "50px",
    border: "0,0,5,0",
    margin: "0",
    init: function() {
	this.inherited(arguments);
	this.containerWidget.setPadding("2,20,2,20");
	this.setContent(this.content);
	this.connectEvents(this.domNode, ["click"]);
    },
    click: function() {
        this.fadeaway(true);
        this.onToastClick();
    },
    onToastClick: function() {},
    postInit: function() {
	this.inherited(arguments);
        this.containerWidget.setHeight("100px");
	this.containerWidget.renderCss();
    },
    renderBounds: function() {
	if (this.showing) {
	    var t = 0;
	    var l = 0;
	    var coords = dojo.coords(app.domNode);
	    this.setBounds(l, t, coords.w, this.height);
	    this.domNode.style.top = t + "px";
	    this.domNode.style.left = l + "px";
	    this.domNode.style.width = coords.w + "px";
	    this.domNode.style.height = this.height;
	    wm.Control.prototype.renderBounds.call(this);

	}
    },
    setContent: function(inContent) {
	this.inherited(arguments);
	this.content = inContent;
    },

    // classes supported "Success", "Warning", "Info".  User may add their own classes via css file
    showToast: function(inContent,inDuration, inCssClasses) {
	if (this._timeoutId) {
	    window.clearTimeout(this._timeoutId);
	    this.hide();
	    this._timeoutId = 0;
	}
        inCssClasses = inCssClasses || "Info";
        var classes = (inCssClasses) ? inCssClasses.split(" ") : [];
        if (dojo.indexOf(classes, "Success") != -1) {
            this.setBorderColor("rgb(0,120,0)");
        } else if (dojo.indexOf(classes, "Warning") != -1) {
            this.setBorderColor("rgb(120,0,0)");
        } else {
            this.setBorderColor("rgb(0,0,0)");
        }
        if (!inContent || !inContent.match(/\<img/)) 
            inContent = "<img src='" + wm.theme.getImagesPath() + "blank.gif' class='ToastLeft'/>" + inContent;

	this.toastHeight = parseInt(this.height);
	this.setContent(inContent);
	this.duration = inDuration || this.duration;
	this.domNode.className = this.classNames + " " + ((inCssClasses) ? inCssClasses : "");

        // After a timeout, animate the toast away
	this._timeoutId = window.setTimeout(dojo.hitch(this, "fadeaway"), this.duration);

	this.show();

	this.domNode.style.height = "1px";
	dojo.anim(this.domNode, { height: parseInt(this.height) }, 400);

    },
    fadeaway: function(fromClick) {
        if (!this._timeoutId) return;
	this._timeoutId = 0;
        if (fromClick) {
	    dojo.anim(this.domNode, { opacity: 0 }, 200, null, dojo.hitch(this, function() {
                this.hide();
                this.domNode.style.opacity = 1;
            }));
        } else {
	    dojo.anim(this.domNode, { height: 0 }, 800, null, dojo.hitch(this, function() {this.hide();}));
        }
    },
    // this is what is called when you bind an event handler to a dialog; call showToast so that the timer is triggered
    update: function() {
	this.showToast(this.content,this.duration, this.domNode.className);
    }

});


wm.Object.extendSchema(wm.Toast, {
    modal: {ignore: 1},
    backgroundColor: {}
});
// Any project can overwrite this array in their page.start method.
wm.Toast.classList = ["wm_FontSizePx_16px","wm_TextDecoration_Bold"];

dojo.declare("wm.pageContainerMixin", null, {
	pageName: "",
	hideControls: false,
	pageProperties: null,
	initPageContainer: function() {
	    this.pageContainer = new wm.PageContainer({loadParentFirst: false, parent: this, owner: this, flex: 1, pageProperties: this.pageProperties});
		this._connections.push(this.connect(this.pageContainer, "onPageChanged", this, "_pageChanged"));
		this.pageContainer.dismiss = dojo.hitch(this, "dismiss");
		if (this.pageName)
			this.setPage(this.pageName);
	    this.createControls();
	},
	setPage: function(inPageName) {
		if (inPageName) {
		    if (this.pageContainer.pageName != inPageName) {
                        if (this.page) 
                            this.page.root.hide();
		        this.pageContainer.setPageName(inPageName);
                    }
		    else
			this.onPageReady();
		}
	},
    showPage: function(inPageName, inHideControls, inWidth, inHeight, inTitle, inModal) {
	if (inTitle !== undefined) this.setTitle(inTitle);
	if (inModal !== undefined) this.setModal(inModal);
		this.setContainerOptions(inHideControls, inWidth, inHeight);
		this.setShowing(true);
		this.setPage(inPageName);
		// IE requires reflow here
		this.reflow();
	},
	setContainerOptions: function(inHideControls, inWidth, inHeight) {
		this.setHideControls(inHideControls);
	},
	_pageChanged: function() {
		this.page = this.pageContainer.page;
		this[this.page.name] = this.page;
		this.onPageReady();
		this.reflow();
		wm.focusContainer(this.page.root);
	},
	onPageReady: function() {
	},
	forEachWidget: function(inFunc) {
		return this.pageContainer.forEachWidget(inFunc);
	},
	createControls: function() {
	    var cp = this.controlsPanel = new wm.Panel({ parent: this,
							 owner: this,
							 layoutKind: "top-to-bottom",
							 horizontalAlign: "left",
							 verticalAlign: "top",
							 height: "40px",
							 width: "100%",
						         border: this.footerBorder || "",
							 borderColor: this.footerBorderColor || ""});
	    if (!this.noBevel)
		this.controlsBevel = new wm.Bevel({ parent: cp, owner: this });
		var bp = this.buttonPanel = new wm.Panel({ parent: cp, owner: this, width: "100%", height: "100%", layoutKind: "left-to-right", horizontalAlign: "right"});
		dojo.addClass(bp.domNode, "wmpagedialog-controlspanel");
		this.closeButton = new wm.Button({ parent: bp, owner: this, caption: "Close", width: "80px", height: "100%"})
		this._connections.push(this.connect(this.closeButton, "onclick", this, "dismiss"));
		cp.setShowing(!this.hideControls);
		cp = null;
		bp = null;
	},
	setHideControls: function(inHideControls) {
		if (inHideControls !== undefined) {
			this.hideControls = inHideControls;
			this.controlsPanel.setShowing(!inHideControls);
		}
	},
    destroy: function() {
		if (this.controlsPanel) 
		{
			this.controlsPanel.destroy();
			this.controlsPanel = null;
		}
		
		if (this.closeButton) 
		{
			this.closeButton.destroy();
			this.closeButton = null;
		}
		
		if (this.controlsBevel) 
		{
		    this.controlsBevel.destroy();
			this.controlsBevel = null;
		}
		
		if (this.buttonPanel) 
		{
		    this.buttonPanel.destroy();
			this.buttonPanel = null;
		}


		if (this.pageContainer) 
		{
			this.pageContainer.dismiss = null;
		    this.pageContainer.destroy();
			this.pageContainer = null;
		}
		
	    this.inherited(arguments);
	}
});

dojo.declare("wm.PageDialog", [wm.Dialog, wm.pageContainerMixin], {
        noBevel: false,
    footerBorder: "",
    footerBorderColor: "",
	postInit: function() {
		this.inherited(arguments);
		this.initPageContainer();
	},
        setPageName: function(inPageName) {return this.setPage(inPageName);},
        setPage: function(inPageName) {
	    this.pageName = inPageName;
            if (inPageName && this.pageContainer.pageName != inPageName) 
                this.showLoadingIndicator();
            this.inherited(arguments);
        },
	setContainerOptions: function(inHideControls, inWidth, inHeight) {
		inWidth = inWidth || wm.Dialog.prototype.contentWidth;
		inHeight = inHeight || wm.Dialog.prototype.contentHeight;
	        if (!dojo.isString(inWidth)) inWidth += "px";
	        if (!dojo.isString(inHeight)) inHeight += "px";
		this.setWidth(inWidth);
		this.setHeight(inHeight);
		this.inherited(arguments);
	},
	hideLoadingIndicator: function() {
            if (this._loader) {
	        dojo._destroyElement(this._loader);
                delete this._loader;
            }
	},
        showLoadingIndicator: function() {
            if (this.width < 150 || this.height < 80) return;
            var text = "&nbsp;Loading...";
            var imgsrc = wm.theme.getImagesPath() + "loadingThrobber.gif";
	    this._loader = wm.createElement("div", {
	        id: "_wm_loading_" + this.id,
	        innerHTML: '<div class="_wm_loading" style="position: absolute; font-weight: bold; font-size: 10pt; z-index: 100; top: 40%; left: 40%;"><img alt="loading" style="vertical-align: middle" src="' + imgsrc + '" />' + text + '</div>'});
	    this.domNode.appendChild(this._loader);
        },
    onPageReady: function() {
            this.hideLoadingIndicator();
    },
    makePropEdit: function(inName, inValue, inDefault) {
	switch (inName) {
	case "pageName":
	    return new wm.propEdit.PagesSelect({component: this, name: inName, value: inValue});
	}
	return this.inherited(arguments);
    },

    destroy: function() {
	    //this.pageContainerMixinDestroy();
	    this.inherited(arguments);
		if (this.containerNode)
		{
			dojo.destroy(this.containerNode);
			this.containerNode = null;
		}
		
		this.c$ =[];
	}
});

wm.PageDialog.extend({
    themeable: false
});

wm.Object.extendSchema(wm.PageDialog, {
    pageName: {group: "Dialog Options", bindable: 1, type: "string", order: 50},
    noBevel: {ignore: 1},
    footerBorder: {group: "style", order: 100},
    footerBorderColor:  {group: "style", order: 101}
});
// design-time
wm.Dialog.description = "Popup dialog.";

dojo.declare("wm.PopoutDialog", wm.Dialog, {
	popout: "",
	postInit: function() {
		this.inherited(arguments);
	},
        setShowing: function(inShow, forceChange) {
		this.inherited(arguments);
		if (this.getValueById(this.popout))
			this[this.showing ? "_addPopout" : "_removePopout"]();
	},
	_addPopout: function() {
		var p = this.getValueById(this.popout);
		this._popoutShowing = p.showing;
		this._popoutParent = p.parent;
		this._popoutIndex = dojo.indexOf(p.parent.c$, this);
		p.setParent(this);
		this.moveControl(p, 0);
		if (!this._popoutShowing)
			p.setShowing(true);
		if (this._popoutShowing)
			this._popoutParent.reflow();
		this.flow();
	},
	_removePopout: function() {
		var p = this.getValueById(this.popout);
		p.setShowing(this._popoutShowing);
		p.setParent(this._popoutParent);
		this._popoutParent.moveControl(p, this._popoutIndex);
		if (this._popoutShowing)
			this._popoutParent.reflow();
	}
});


dojo.declare("wm.ColorPickerDialog", wm.Dialog, {
    colorPicker: null,  
    colorPickerSet: false,
    border: "1",
    borderColor: "#888888",
    width: "325px",
    height: "210px",
    modal: false,
    colorPickerControl: null,
    init: function() {
	this.inherited(arguments);
        
    },
    postInit: function() {
	this.inherited(arguments);

        if (!wm.ColorPickerDialog.cssLoaded) {
            var link = document.createElement("link");
            link.rel = "stylesheet";
            link.type = "text/css";
            link.href = dojo.moduleUrl("dojox.widget.ColorPicker").uri + "ColorPicker.css";
            document.getElementsByTagName("head")[0].appendChild(link);
            wm.ColorPickerDialog.cssLoaded = true;
        }
        this.colorPickerControl = new wm.Control({name: "colorPickerControl", width: "325px", height: "170px", owner: this, parent: this});
        this.buttonPanel = new wm.Panel({name: "buttonPanel", width: "100%", height: "100%", layoutKind: "left-to-right", owner: this, parent: this, horizontalAlign: "right"});
        this.BrightenButton = new wm.Button({caption: "Bright", width: "80px", height: "30px", parent: this.buttonPanel});
        this.DarkenButton = new wm.Button({caption: "Dark", width: "80px", height: "30px", parent: this.buttonPanel});
        this.CancelButton = new wm.Button({caption: "Cancel", width: "80px", height: "30px", parent: this.buttonPanel});
        this.OKButton = new wm.Button({caption: "OK", width: "80px", height: "30px", parent: this.buttonPanel});

        this.connect(this.BrightenButton, "onclick", this, "brighten");
        this.connect(this.DarkenButton, "onclick", this, "darken");
        this.connect(this.OKButton, "onclick", this, "onOK");
        this.connect(this.CancelButton, "onclick", this, "onCancel");
        this.domNode.style.backgroundColor = "white";
    },
    onCancel: function() {
    },
    onOK: function() {
        this.dismiss();
    },
    getValue: function() {
        if (this.colorPicker) {
            return this.colorPicker.getValue();
        } else {
            return this._tmpValue;
        }
    },
    setValue: function(inValue) {
        if (this.colorPicker) {
            this.colorPicker.setColor(inValue);
        } else {
            this._tmpValue = inValue;
        }
    },
    setShowing: function(inShowing, forceShow) {
        if (!this.colorPicker && inShowing && this.domNode) {
            this.colorPicker = new dojox.widget.ColorPicker({animatePoint: true, showHsv: false, showRtb: true, webSave: false, onChange: dojo.hitch(this, "valueChange")}, this.domNode);       
            /* Hack because the colorpicker is beta and has problems getting these values correctly.  As the picker always appears in exactly the same place
             * in our dialog, we can always have these values be the same
             */
	    this.colorPicker.PICKER_SAT_VAL_H = 152;
	    this.colorPicker.PICKER_SAT_VAL_W = 152;
	    this.colorPicker.PICKER_HUE_H = 150;
            this.colorPicker._shift.picker.x = 5;
            this.colorPicker._shift.picker.y = 5;
        }
        
        if (inShowing) {

            // If it isn't currently showing, and we're now showing it, set _changed to false
            if (!this.showing)
                this._changed = false;

            if (this._tmpValue) {
                this.setValue(this._tmpValue);
                delete this._tmpValue;
            }
            if (this.domNode.parentNode != document.body) {
                document.body.appendChild(this.domNode);
                this.colorPickerControl.domNode.appendChild(this.colorPicker.domNode);
            }
            if (this.owner.editorNode) {
		var o = dojo._abs(this.owner.editorNode);
                o.y += this.owner.bounds.h;
                this.bounds.t = o.y;
                this.bounds.l = o.x;
                this._fixPosition = true;
            }
        }
        this.inherited(arguments);
    },
    valueChange: function(inValue) {        
        this._changed = true;
        this.onChange(inValue);
    },
    onChange: function(inValue) {

    },
    brighten: function() {
        var value = this.colorPicker.attr("value");
        var values = [parseInt(value.substr(1,2),16),
                      parseInt(value.substr(3,2),16),
                      parseInt(value.substr(5,2),16)];
        var result = "#";
        var zeroCount = 0;
        var maxCount = 0;
        for (var i = 0; i < 3; i++) {
            if (values[i] == 0) zeroCount++;
            else if (values[i] == 255) maxCount++;
        }

        var minValue = 0;
        if (maxCount + zeroCount == 3)
            minValue = 40;
        for (var i = 0; i < 3; i++) {
            values[i] = Math.max(minValue,Math.min(255,Math.floor(values[i] * 1.2)));
            var str = values[i].toString(16);            
            if (str.length < 2) str = "0" + str;
            result += str;
        }



        this.setValue(result);
        this.onChange(result);
    },
    darken: function() {
        var value = this.colorPicker.attr("value");
        var values = [parseInt(value.substr(1,2),16),
                      parseInt(value.substr(3,2),16),
                      parseInt(value.substr(5,2),16)];
        var result = "#";
        for (var i = 0; i < 3; i++) {
            values[i] = Math.floor(values[i] * 0.8);
            var str = values[i].toString(16);
            if (str.length < 2) str = "0" + str;
            result += str;
        }
        this.setValue(result);
        this.onChange(result);
    },
    destroy: function() {
        if (this.colorPicker) // doesn't exist if the dialog never shown
            this.colorPicker.destroyRecursive();
        this.inherited(arguments);
    }
    

});

wm.ColorPickerDialog.cssLoaded = false;


dojo.declare("wm.DesignableDialog", wm.Dialog, {
    border: "1",
    borderColor: "black",
    titlebarBorder: "1",
    titlebarBorderColor: "black",
    footerBorder: "1",
    footerBorderColor: "black",
    scrim: false,
    useContainerWidget: true,
    title: "Dialog",
    postInit: function() {
	this.inherited(arguments);
	delete this.containerNode; // containerNode is where child nodes get added to when appending children; just let the normal parent/child relationships prevail...
    }
});

wm.Object.extendSchema(wm.DesignableDialog, {
    owner: {ignore: true}
});

}

if(!dojo._hasResource["wm.base.widget.EditPanel"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["wm.base.widget.EditPanel"] = true;
/*
 *  Copyright (C) 2008-2010 WaveMaker Software, Inc.
 *
 *  This file is part of the WaveMaker Client Runtime.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
dojo.provide("wm.base.widget.EditPanel");

dojo.declare("wm.EditPanel", wm.Panel, {
	border: "0",
	operationPanel: "",
	savePanel: "",
	liveForm: "",
	layoutKind: "top-to-bottom",
        verticalAlign: "top",
        horizontalAlign: "right",
	lock: true,
	formUneditable: false,
	formInvalid: true,
	width: "100%",
	height: "40px",
        editPanelStyle: "wm.RoundedButton",
	destroy: function() {
		this._unsubscribeLiveForm();
		this.inherited(arguments);
	},
	init: function() {
		this.inherited(arguments);
		this.setLiveForm(this.liveForm);
		this.updateControlsStatus();
	},
	loaded: function() {
		this.inherited(arguments);
		if (wm.pasting)
			wm.fire(this, "designPasted");
	},
	setLiveForm: function(inLiveForm) {
		if (inLiveForm instanceof wm.Component)
			inLiveForm = inLiveForm.getId();
		this.liveForm = inLiveForm;
		this._subscribeLiveForm();
	},
	_subscribeLiveForm: function() {
		this._unsubscribeLiveForm();
		var c = this._liveFormSubscriptions = [];
		var w = this._liveFormWires = [];
		if (this.liveForm) {
			// update control status when liveForm dataSet changes
			var form = this.getValueById(this.liveForm);
			c.push(dojo.connect(form, "setDataSet", this, "updateControlsStatus"));
			c.push(dojo.connect(form, "beginEdit", this, "_beginEdit"));
			c.push(dojo.connect(form, "endEdit", this, "_endEdit"));
			// liveForm wires.
			w.push(new wm.Wire({
				owner: this,
				targetId: this.getId(),
				targetProperty: "formInvalid",
				source: [this.liveForm, "invalid"].join(".")
			}).connectWire());
		}
	},
	_unsubscribeLiveForm: function() {
		dojo.forEach(this._liveFormSubscriptions, dojo.disconnect);
		dojo.forEach(this._liveFormWires, function(w) { wm.fire(w, "destroy")});
	},
	_beginEdit: function() {
		this._toggleEdit(true);
	},
	_endEdit: function() {
		this._toggleEdit(false);
	},
	_toggleEdit: function(inEdit) {
		wm.fire(this.getValueById(this.operationPanel), "setShowing", [!inEdit]);
		wm.fire(this.getValueById(this.savePanel), "setShowing", [inEdit]);
	},
	updateControlsStatus: function() {
		this.setValue("formUneditable", !wm.fire(this.getValueById(this.liveForm), "hasEditableData"));
	},
	beginDataInsert: function() {
		wm.fire(this.getValueById(this.liveForm), "beginDataInsert");
	},
	beginDataUpdate: function() {
		wm.fire(this.getValueById(this.liveForm), "beginDataUpdate");
	},
	deleteData: function() {
		wm.fire(this.getValueById(this.liveForm), "deleteData");
	},
	saveData: function() {
		wm.fire(this.getValueById(this.liveForm), "saveData");
	},
	cancelEdit: function() {
		wm.fire(this.getValueById(this.liveForm), "cancelEdit");
	}
});

//===========================================================================
// Design-time
//===========================================================================

wm.EditPanel.description = "Controls for editing a form.";

wm.Object.extendSchema(wm.EditPanel, {
	addControls: { group: "operation", order: 7},
	removeControls: { group: "operation", order: 8},
	liveForm: { group: "common", order: 200},
	savePanel: {ignore: 1, writeonly: 1},
	operationPanel: {ignore: 1, writeonly: 1},
	formUneditable: {ignore: 1, bindSource: 1},
    formInvalid: {ignore: 1, bindSource: 1},
    editPanelStyle: {ignore: 1}
});

wm.EditPanel.extend({
	addControls: "(addControls)",
	removeControls: "(removeControls)",
	_defaultClasses: {domNode: ["wm_Padding_4px"]},
	_buttonWidth: "100px",
	designCreate: function() {
		this.inherited(arguments);
		this.subscribe("wmwidget-idchanged", this, "widgetNameChanged");
		
	},
	//FIXME: fix potential bad controls info caused by copy/paste
	// requirement (currently necessitated only for copy /paste)
	// is that op/save panels must be children of this editPanel
	designPasted: function() {
		if (!this._controlsOk())
			this._resetContents();
	},
	_resetContents: function() {
		this.setLiveForm("");
		this._unsetControls();
		wm.forEach(this.widgets, function(w) {
			w.destroy();
		});
	},
	_unsetControls: function() {
		this.operationPanel = this.savePanel = null;
	},
	_createSavePanel: function() {
		var
	          props = {showing: false, layoutKind: "left-to-right", horizontalAlign: "right", verticalAlign: "top", width: "100%", height: "100%", border: "0"},
			p = this.owner.loadComponent("savePanel1", this, "wm.Panel", props);
		this.savePanel = p.getId();
		//
		var
			n = this.getId(),
			sb = this.owner.loadComponent("saveButton1", p, this.editPanelStyle, {caption: "Save", width: this._buttonWidth, height: "100%"}, {onclick: n + ".saveData"});
		this.owner.loadComponent("cancelButton1", p, this.editPanelStyle, {caption: "Cancel", width: this._buttonWidth, height: "100%"}, {onclick: n + ".cancelEdit"});
		sb.$.binding.addWire("", "disabled", n + ".formInvalid");
		this.reflow();
	},
	_createOperationPanel: function() {
		var
	    props = {layoutKind: "left-to-right", horizontalAlign: "right", verticalAlign: "top", width: "100%", height: "100%", border: "0"},
			p = this.owner.loadComponent("operationPanel1", this, "wm.Panel", props);
		this.operationPanel = p.getId();
		//
		var n = this.getId();
		this.owner.loadComponent("newButton1", p, this.editPanelStyle, {caption: "New", width: this._buttonWidth, height: "100%"}, {onclick: n + ".beginDataInsert"});
		var u = this.owner.loadComponent("updateButton1", p, this.editPanelStyle, {caption: "Update", width: this._buttonWidth, height: "100%"}, {onclick: n + ".beginDataUpdate"});
		var d = this.owner.loadComponent("deleteButton1", p, this.editPanelStyle, {caption: "Delete", width: this._buttonWidth, height: "100%"}, {onclick: n + ".deleteData"});
		this.reflow();
		//
		u.$.binding.addWire("", "disabled", n + ".formUneditable");
		d.$.binding.addWire("", "disabled", n + ".formUneditable");
	},
	removeControls: function() {
		if (confirm("Are you sure? All widgets in " + this.getId() + " will be deleted.")) {
			this._removeControls();
		}
	},
	_removeControls: function() {
		this._destroyControls();
		this.reflow();
		this.updateDesignTrees();
	},
	_destroyControls: function() {
		var o = this.getValueById(this.operationPanel);
		wm.fire(o, "destroy");
		var s = this.getValueById(this.savePanel);
		wm.fire(s, "destroy");
		this._unsetControls();
	},
	_addControls: function() {
		this._destroyControls();
		this._createSavePanel();
		this._createOperationPanel();
		this.setLock(true);
		this.updateControlsStatus();
		this.reflow();
	},
	updateDesignTrees: function() {
		wm.fire(studio, "refreshComponentOnTree", [this]);
	},
	set_liveForm: function(inLiveForm) {
		this.setLiveForm(inLiveForm);
		var a = this.getValueById(this.liveForm);
		if (a) {
			if (!this.c$.length)
				this._addControls();
			a.setReadonly(true);
		}
	},
	getLiveFormNames: function() {
		var l = [""];
		wm.forEachWidget(studio.page.root, function(w) {
			if (w instanceof wm.LiveForm)
				l.push(w.getId());
		});
		return l;
	},
	widgetNameChanged: function(inOldId, inNewId, inOldRtId, inNewRtId) {
		var monitored = {
			"operationPanel": 1,
			"savePanel": 1,
			"liveForm": 1
		};
		for (var i in monitored)
			if (this[i] == inOldId)
				this[i] = inNewId;
	},
	// check if save / operation panels are children
	// (if they are not, then we assume controls are not setup properly)
	_controlsOk: function() {
		var
			op = this.getValueById(this.operationPanel),
			sp = this.getValueById(this.savePanel);
		return ((!op || op.parent == this) && (!sp || sp.parent == this));
	},
	makePropEdit: function(inName, inValue, inDefault) {
		switch (inName) {
			case "addControls":
			case "removeControls":
				return makeReadonlyButtonEdit(inName, inValue, inDefault);
			case "liveForm":
				return makeSelectPropEdit(inName, inValue, this.getLiveFormNames(inValue), inDefault);
		}
		return this.inherited(arguments);
	},
	editProp: function(inName, inValue, inInspector) {
		switch (inName) {
			case "addControls":
				return this._addControls();
			case "removeControls":
				return this.removeControls();
		}
		return this.inherited(arguments);
	}
});

}

if(!dojo._hasResource["dijit.Tooltip"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["dijit.Tooltip"] = true;
dojo.provide("dijit.Tooltip");




dojo.declare(
	"dijit._MasterTooltip",
	[dijit._Widget, dijit._Templated],
	{
		// summary:
		//		Internal widget that holds the actual tooltip markup,
		//		which occurs once per page.
		//		Called by Tooltip widgets which are just containers to hold
		//		the markup
		// tags:
		//		protected

		// duration: Integer
		//		Milliseconds to fade in/fade out
		duration: dijit.defaultDuration,

		templateString: dojo.cache("dijit", "templates/Tooltip.html", "<div class=\"dijitTooltip dijitTooltipLeft\" id=\"dojoTooltip\">\r\n\t<div class=\"dijitTooltipContainer dijitTooltipContents\" dojoAttachPoint=\"containerNode\" waiRole='alert'></div>\r\n\t<div class=\"dijitTooltipConnector\"></div>\r\n</div>\r\n"),

		postCreate: function(){
			dojo.body().appendChild(this.domNode);

			this.bgIframe = new dijit.BackgroundIframe(this.domNode);

			// Setup fade-in and fade-out functions.
			this.fadeIn = dojo.fadeIn({ node: this.domNode, duration: this.duration, onEnd: dojo.hitch(this, "_onShow") });
			this.fadeOut = dojo.fadeOut({ node: this.domNode, duration: this.duration, onEnd: dojo.hitch(this, "_onHide") });

		},

		show: function(/*String*/ innerHTML, /*DomNode*/ aroundNode, /*String[]?*/ position){
			// summary:
			//		Display tooltip w/specified contents to right of specified node
			//		(To left if there's no space on the right, or if LTR==right)

			if(this.aroundNode && this.aroundNode === aroundNode){
				return;
			}

			if(this.fadeOut.status() == "playing"){
				// previous tooltip is being hidden; wait until the hide completes then show new one
				this._onDeck=arguments;
				return;
			}
			this.containerNode.innerHTML=innerHTML;

			// Firefox bug. when innerHTML changes to be shorter than previous
			// one, the node size will not be updated until it moves.
			this.domNode.style.top = (this.domNode.offsetTop + 1) + "px";

			var pos = dijit.placeOnScreenAroundElement(this.domNode, aroundNode, dijit.getPopupAroundAlignment((position && position.length) ? position : dijit.Tooltip.defaultPosition, this.isLeftToRight()), dojo.hitch(this, "orient"));

			// show it
			dojo.style(this.domNode, "opacity", 0);
			this.fadeIn.play();
			this.isShowingNow = true;
			this.aroundNode = aroundNode;
		},

		orient: function(/* DomNode */ node, /* String */ aroundCorner, /* String */ tooltipCorner){
			// summary:
			//		Private function to set CSS for tooltip node based on which position it's in.
			//		This is called by the dijit popup code.
			// tags:
			//		protected

			node.className = "dijitTooltip " +
				{
					"BL-TL": "dijitTooltipBelow dijitTooltipABLeft",
					"TL-BL": "dijitTooltipAbove dijitTooltipABLeft",
					"BR-TR": "dijitTooltipBelow dijitTooltipABRight",
					"TR-BR": "dijitTooltipAbove dijitTooltipABRight",
					"BR-BL": "dijitTooltipRight",
					"BL-BR": "dijitTooltipLeft"
				}[aroundCorner + "-" + tooltipCorner];
		},

		_onShow: function(){
			// summary:
			//		Called at end of fade-in operation
			// tags:
			//		protected
			if(dojo.isIE){
				// the arrow won't show up on a node w/an opacity filter
				this.domNode.style.filter="";
			}
		},

		hide: function(aroundNode){
			// summary:
			//		Hide the tooltip
			if(this._onDeck && this._onDeck[1] == aroundNode){
				// this hide request is for a show() that hasn't even started yet;
				// just cancel the pending show()
				this._onDeck=null;
			}else if(this.aroundNode === aroundNode){
				// this hide request is for the currently displayed tooltip
				this.fadeIn.stop();
				this.isShowingNow = false;
				this.aroundNode = null;
				this.fadeOut.play();
			}else{
				// just ignore the call, it's for a tooltip that has already been erased
			}
		},

		_onHide: function(){
			// summary:
			//		Called at end of fade-out operation
			// tags:
			//		protected

			this.domNode.style.cssText="";	// to position offscreen again
			if(this._onDeck){
				// a show request has been queued up; do it now
				this.show.apply(this, this._onDeck);
				this._onDeck=null;
			}
		}

	}
);

dijit.showTooltip = function(/*String*/ innerHTML, /*DomNode*/ aroundNode, /*String[]?*/ position){
	// summary:
	//		Display tooltip w/specified contents in specified position.
	//		See description of dijit.Tooltip.defaultPosition for details on position parameter.
	//		If position is not specified then dijit.Tooltip.defaultPosition is used.
	if(!dijit._masterTT){ dijit._masterTT = new dijit._MasterTooltip(); }
	return dijit._masterTT.show(innerHTML, aroundNode, position);
};

dijit.hideTooltip = function(aroundNode){
	// summary:
	//		Hide the tooltip
	if(!dijit._masterTT){ dijit._masterTT = new dijit._MasterTooltip(); }
	return dijit._masterTT.hide(aroundNode);
};

dojo.declare(
	"dijit.Tooltip",
	dijit._Widget,
	{
		// summary:
		//		Pops up a tooltip (a help message) when you hover over a node.

		// label: String
		//		Text to display in the tooltip.
		//		Specified as innerHTML when creating the widget from markup.
		label: "",

		// showDelay: Integer
		//		Number of milliseconds to wait after hovering over/focusing on the object, before
		//		the tooltip is displayed.
		showDelay: 400,

		// connectId: [const] String[]
		//		Id's of domNodes to attach the tooltip to.
		//		When user hovers over any of the specified dom nodes, the tooltip will appear.
		//
		//		Note: Currently connectId can only be specified on initialization, it cannot
		//		be changed via attr('connectId', ...)
		//
		//		Note: in 2.0 this will be renamed to connectIds for less confusion.
		connectId: [],

		// position: String[]
		//		See description of `dijit.Tooltip.defaultPosition` for details on position parameter.
		position: [],

		constructor: function(){
			// Map id's of nodes I'm connected to to a list of the this.connect() handles
			this._nodeConnectionsById = {};
		},

		_setConnectIdAttr: function(newIds){
			for(var oldId in this._nodeConnectionsById){
				this.removeTarget(oldId);
			}
			dojo.forEach(dojo.isArrayLike(newIds) ? newIds : [newIds], this.addTarget, this);
		},

		_getConnectIdAttr: function(){
			var ary = [];
			for(var id in this._nodeConnectionsById){
				ary.push(id);
			}
			return ary;
		},

		addTarget: function(/*DOMNODE || String*/ id){
			// summary:
			//		Attach tooltip to specified node, if it's not already connected
			var node = dojo.byId(id);
			if(!node){ return; }
			if(node.id in this._nodeConnectionsById){ return; }//Already connected

			this._nodeConnectionsById[node.id] = [
				this.connect(node, "onmouseenter", "_onTargetMouseEnter"),
				this.connect(node, "onmouseleave", "_onTargetMouseLeave"),
				this.connect(node, "onfocus", "_onTargetFocus"),
				this.connect(node, "onblur", "_onTargetBlur")
			];
			if(dojo.isIE && !node.style.zoom){//preserve zoom
				// BiDi workaround
				node.style.zoom = 1;
			}
		},

		removeTarget: function(/*DOMNODE || String*/ node){
			// summary:
			//		Detach tooltip from specified node

			// map from DOMNode back to plain id string
			var id = node.id || node;

			if(id in this._nodeConnectionsById){
				dojo.forEach(this._nodeConnectionsById[id], this.disconnect, this);
				delete this._nodeConnectionsById[id];
			}
		},

		postCreate: function(){
			dojo.addClass(this.domNode,"dijitTooltipData");
		},

		startup: function(){
			this.inherited(arguments);

			// If this tooltip was created in a template, or for some other reason the specified connectId[s]
			// didn't exist during the widget's initialization, then connect now.
			var ids = this.connectId;
			dojo.forEach(dojo.isArrayLike(ids) ? ids : [ids], this.addTarget, this);
		},

		_onTargetMouseEnter: function(/*Event*/ e){
			// summary:
			//		Handler for mouseenter event on the target node
			// tags:
			//		private
			this._onHover(e);
		},

		_onTargetMouseLeave: function(/*Event*/ e){
			// summary:
			//		Handler for mouseleave event on the target node
			// tags:
			//		private
			this._onUnHover(e);
		},

		_onTargetFocus: function(/*Event*/ e){
			// summary:
			//		Handler for focus event on the target node
			// tags:
			//		private

			this._focus = true;
			this._onHover(e);
		},

		_onTargetBlur: function(/*Event*/ e){
			// summary:
			//		Handler for blur event on the target node
			// tags:
			//		private

			this._focus = false;
			this._onUnHover(e);
		},

		_onHover: function(/*Event*/ e){
			// summary:
			//		Despite the name of this method, it actually handles both hover and focus
			//		events on the target node, setting a timer to show the tooltip.
			// tags:
			//		private
			if(!this._showTimer){
				var target = e.target;
				this._showTimer = setTimeout(dojo.hitch(this, function(){this.open(target)}), this.showDelay);
			}
		},

		_onUnHover: function(/*Event*/ e){
			// summary:
			//		Despite the name of this method, it actually handles both mouseleave and blur
			//		events on the target node, hiding the tooltip.
			// tags:
			//		private

			// keep a tooltip open if the associated element still has focus (even though the
			// mouse moved away)
			if(this._focus){ return; }

			if(this._showTimer){
				clearTimeout(this._showTimer);
				delete this._showTimer;
			}
			this.close();
		},

		open: function(/*DomNode*/ target){
 			// summary:
			//		Display the tooltip; usually not called directly.
			// tags:
			//		private

			if(this._showTimer){
				clearTimeout(this._showTimer);
				delete this._showTimer;
			}
			dijit.showTooltip(this.label || this.domNode.innerHTML, target, this.position);

			this._connectNode = target;
			this.onShow(target, this.position);
		},

		close: function(){
			// summary:
			//		Hide the tooltip or cancel timer for show of tooltip
			// tags:
			//		private

			if(this._connectNode){
				// if tooltip is currently shown
				dijit.hideTooltip(this._connectNode);
				delete this._connectNode;
				this.onHide();
			}
			if(this._showTimer){
				// if tooltip is scheduled to be shown (after a brief delay)
				clearTimeout(this._showTimer);
				delete this._showTimer;
			}
		},

		onShow: function(target, position){
			// summary:
			//		Called when the tooltip is shown
			// tags:
			//		callback
		},

		onHide: function(){
			// summary:
			//		Called when the tooltip is hidden
			// tags:
			//		callback
		},

		uninitialize: function(){
			this.close();
			this.inherited(arguments);
		}
	}
);

// dijit.Tooltip.defaultPosition: String[]
//		This variable controls the position of tooltips, if the position is not specified to
//		the Tooltip widget or *TextBox widget itself.  It's an array of strings with the following values:
//
//			* before: places tooltip to the left of the target node/widget, or to the right in
//			  the case of RTL scripts like Hebrew and Arabic
//			* after: places tooltip to the right of the target node/widget, or to the left in
//			  the case of RTL scripts like Hebrew and Arabic
//			* above: tooltip goes above target node
//			* below: tooltip goes below target node
//
//		The list is positions is tried, in order, until a position is found where the tooltip fits
//		within the viewport.
//
//		Be careful setting this parameter.  A value of "above" may work fine until the user scrolls
//		the screen so that there's no room above the target node.   Nodes with drop downs, like
//		DropDownButton or FilteringSelect, are especially problematic, in that you need to be sure
//		that the drop down and tooltip don't overlap, even when the viewport is scrolled so that there
//		is only room below (or above) the target node, but not both.
dijit.Tooltip.defaultPosition = ["after", "before"];

}

if(!dojo._hasResource["wm.base.widget.dijit.Dijit"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["wm.base.widget.dijit.Dijit"] = true;
/*
 *  Copyright (C) 2008-2010 WaveMaker Software, Inc.
 *
 *  This file is part of the WaveMaker Client Runtime.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
dojo.provide("wm.base.widget.dijit.Dijit");

// include tooltip so the master tooltip is created right away


// style dijit a11y node to hidden so that it does not interfere with wm.box
// a11yTestNode is created in dijit.util.wai and if it is changed to be 
// style="visibility: hidden" there then this code can be removed 
// FIXME: make a dojo ticket to make this happen
// hide master tooltip node also
dojo.addOnLoad(function() {
	var invisible = function(inId) {
		var n = dojo.byId(inId);
		n&&(n.style.visibility='hidden');
	}
	invisible('a11yTestNode');
});

// Note: dijit events and properties must be exposed manually.
// This gives finer control over what is exposed via our API.
/**
	Wrapper class to contain a Dijit.
	@name wm.Dijit
	@class
	@extends wm.Box
*/
dojo.declare("wm.Dijit", wm.Box, {
	/** @lends wm.Dijit.prototype */
	dijitClass: null,
	// FIXME: ignore props not intended for dijit
	nonDijitProps: {
		name: 1,
		flex: 1,
		box: 1,
		left: 1,
		top: 1,
		width: 1,
		height: 1,
		owner: 1,
		parent: 1,
		publishClass: 1,
		dijitClass: 1,
		domNode: 1,
		id: 1
	},
	prepare: function(inProps) {
		this.dijitProps = {};
		for (var i in inProps)
			if (!(i in this.nonDijitProps))
				this.dijitProps[i] = inProps[i];
		this.inherited(arguments);
	},
	destroy: function() {
		this.dijit.destroy();
		this.inherited(arguments);
	},
	setDomNode: function(inDomNode) {
		inDomNode = this.initDijit(inDomNode);
		this.inherited(arguments);
	},
	initDijit: function(inDomNode) {
		var n = document.createElement('div');
		inDomNode.appendChild(n);
		var p = dojo.mixin({srcNodeRef: n}, this.getProperties());
		this.dijit = this.dijitClass ? new this.dijitClass(p) : null;
		this.setEvents();
		return inDomNode;
	},
	// return properties intended for the dijit
	getProperties: function() {
		return this.dijitProps;
	},
	// connect our events to dijit events of the same name
	setEvents: function() {
		for (var n in this.dijit) {
			// only if n starts with "on" (indexOf == 0)
			if (!n.indexOf("on")) {
				// we match "_on<Event>" first
				var e = '_' + n;
				if (!this[e])
					// we match "on<Event>" second
					e = n;
				// connect our facade event to the dijit event
				if (this[e])
					this.connect(this.dijit, n, this, e);
			}
		}
	}
});

wm.Object.extendSchema(wm.Dijit, {
	/*dojoAttachEvent: {ignore: 1},
	dojoAttachPoint: {ignore: 1},
	baseClass: {ignore: 1},
	widgetsInTemplate: {ignore: 1},
	templateString: {ignore: 1},
	alt: {ignore: 1},
	dir: {ignore: 1},
	type: {ignore: 1},
	waiRole: {ignore: 1},
	waiState: {ignore: 1},
	intermediateChanges:  {ignore: 1},*/
	box: {ignore: 1}
});

dojo.declare("wm.DijitWrapper", wm.Dijit, {
});

}

if(!dojo._hasResource["wm.base.components.Timer"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["wm.base.components.Timer"] = true;
// TODO: Add it to build system

/*
 *  Copyright (C) 2010 WaveMaker Software, Inc.
 *
 *  This file is part of the WaveMaker Client Runtime.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at 
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
dojo.provide("wm.base.components.Timer");



dojo.declare("wm.Timer", wm.Component, {
    delay: 500, // number of miliseconds until firing
    repeating: true, // determines whether we're using setInterval or setTimeout
    _timeoutId: 0,
    _intervalId: 0,
    autoStart: false,
    count: 0,
    init: function() {
	this.inherited(arguments);
	if (this.autoStart) {
	    this.startTimer();
	}
    },
    startTimer: function() {
	this.stopTimer();
	this.count = 0;
	if (this.repeating) {
	    this._intervalId = window.setInterval(dojo.hitch(this, "onTimerFire"), this.delay);
	} else {
	    this._timeoutId = window.setTimeout(dojo.hitch(this, "onTimerFire"), this.delay);
	}
    },
    stopTimer: function() {
	if (this._timeoutId) {
	    window.clearTimeout(this._timeoutId);
	    this._timeoutId = 0;
	}
	if (this._intervalId) {
	    window.clearInterval(this._intervalId);
	    this._intervalId = 0;
	}
    },

    // event that gets called each time the timer fires; this is what fires
    // the developer's real code.
    onTimerFire: function() {
	this.count++;
	this.valueChanged("count", this.count);
    },

    // If I have a ServiceVariable, and its onSuccess method points to this timer,
    // the Activate method is what would be called.  So, onSuccess, the timer starts up.
    activate: function() {
	this.startTimer();
    },

    // Changes the repeating value, and if the timer was already running
    // restarts the timer
    setRepeating: function(inRepeating) {
	var isRunning = this._timeoutId || this._intervalId;
	if (isRunning)
	    this.stopTimer();
	this.repeating = inRepeating;
	if (isRunning)
	    this.startTimer();
    },
    
    setDelay: function(inDelay) {
	var isRunning = this._timeoutId || this._intervalId;
	if (isRunning)
	    this.stopTimer();
	this.delay = inDelay;
	if (isRunning)
	    this.startTimer();
    }
    
});


wm.Object.extendSchema(wm.Timer, {
    delay: {bindTarget: true},
    count: {bindSource: true, ignore: true}
});

}


dojo.i18n._preloadLocalizations("dojo.nls.lib_build", ["ROOT","ar","ca","cs","da","de","de-de","el","en","en-gb","en-us","es","es-es","fi","fi-fi","fr","fr-fr","he","he-il","hu","it","it-it","ja","ja-jp","ko","ko-kr","nb","nl","nl-nl","pl","pt","pt-br","pt-pt","ru","sk","sl","sv","th","tr","xx","zh","zh-cn","zh-tw"]);
