/*
 *  Copyright (C) 2008-2010 WaveMaker Software, Inc.
 *
 *  This file is part of the WaveMaker Client Runtime.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
dojo.provide("wm.base.widget.Layers.TabsDecorator");
dojo.require("wm.base.widget.Layers.Decorator");

dojo.declare("wm.TabsDecorator", wm.LayersDecorator, {
	decorationClass: "wmtablayers",
        decoratorPadding: "7, 0, 0, 0",
	undecorate: function() {
		this.inherited(arguments);
		this.tabsControl.destroy();
	},
	decorateContainer: function() {
		this.inherited(arguments);
		this.btns = [];
		this.tabsControl = new wm.TabsControl({
			parent: this.decoree, 
		        owner: this.decoree,
		        padding: this.decoratorPadding
		});
		this.decoree.moveControl(this.tabsControl, 0);
	},
	createTab: function(inCaption, inIndex, inLayer) {
		var b = this.btns[inIndex] = document.createElement("button");
	        //b.style.outline = "none";
		b.style.display = inLayer.showing ? "" : "none";
		this.setBtnText(b, inCaption);
		this.decoree.connect(b, "onclick", dojo.hitch(this, "tabClicked", inLayer));
	        b.className=this.decorationClass + "-tab";
		this.tabsControl.domNode.appendChild(b);
	},
	tabClicked: function(inLayer, e) {
		var d = this.decoree;
		// prevent designer click
		if (d.isDesignLoaded())
			dojo.stopEvent(e);
		d.setLayer(inLayer);
	},
	decorateLayer: function(inLayer, inIndex) {
		this.inherited(arguments);
		this.createTab(inLayer.caption, inIndex, inLayer);
	},
	undecorateLayer: function(inLayer, inIndex) {
		dojo._destroyElement(this.btns[inIndex]);
		this.btns.splice(inIndex, 1);
	},
	setLayerShowing: function(inLayer, inShowing) {
		var i = inLayer.getIndex();
		if (i != -1)
			this.btns[i].style.display = inShowing ? "" : "none";
		this.inherited(arguments);
	},
	setLayerActive: function(inLayer, inActive) {
		var b=this.btns[inLayer.getIndex()];
		if (b)
		    dojo[inActive ? "addClass" : "removeClass"](b, this.decorationClass + '-selected');
		this.inherited(arguments);
	},
	applyLayerCaption: function(inLayer) {
		var d = this.decoree, i = inLayer.getIndex();
		if (i != -1)
			this.setBtnText(this.btns[i], inLayer.caption);
	},
	setBtnText: function(inBtn, inCaption) {
		inBtn.innerHTML = inCaption || '&nbsp;';
	},
	getBtn: function(inCaption) {
		var d = this.decoree, i = d.indexOfLayerCaption(inCaption);
		if (i != -1)
			return this.btns[i];
	},
	disenableTab: function(inCaption, inDisable) {
		var b = this.getBtn(inCaption);
		if (b)
			b.disabled = inDisable ? "disabled" : "";
	},
	disableTab: function(inCaption) {
		this.disenableTab(inCaption, true);
	},
	enableTab: function(inCaption) {
		this.disenableTab(inCaption, false);
	},
	moveLayerIndex: function(inFromIndex, inToIndex) {
		this.inherited(arguments);
		var d = this.tabsControl.domNode, f = this.btns[inFromIndex], t = this.btns[inToIndex], c = this.decoree.getCount()-1;
		if (inToIndex < inFromIndex) {
			d.insertBefore(f, t);
		} else if (inToIndex > inFromIndex) {
			if (inToIndex == c)
				d.appendChild(f);
			else {
				var nl = this.btns[inToIndex + 1];
				if (nl)
					d.insertBefore(f, nl);
			}
		}
		this.btns[inToIndex] = f;
		this.btns[inFromIndex] = t;
	}
});

dojo.declare("wm.RoundedTabsDecorator", wm.TabsDecorator, {
	decorateContainer: function() {
		this.inherited(arguments);
		dojo.removeClass(this.tabsControl.domNode, "wmtablayers-tabbar");
		dojo.addClass(this.tabsControl.domNode, "wmtablayers-roundedtabbar");
		this.tabsControl.setPadding("0,0,0,15");
		this.tabsControl.domNode.style.paddingTop = "0px";								
		this.tabsControl.domNode.style.paddingLeft = "15px";
	},
	createTab: function(inCaption, inIndex, inLayer) {
		var b = this.btns[inIndex] = document.createElement("div");		
		b.style.display = inLayer.showing ? "" : "none";
		
		var divLeft = document.createElement("div");
		var divCenter = document.createElement("div");
		var divRight = document.createElement("div");
		
		divLeft.innerHTML = "&nbsp;";
		divCenter.innerHTML = "&nbsp;";
		divRight.innerHTML = "&nbsp;";
		
		this.setBtnText(divCenter, inCaption);
		this.decoree.connect(b, "onclick", dojo.hitch(this, "tabClicked", inLayer));
		this.decoree.connect(b, "onmouseover", dojo.hitch(this, "mouseoverout", inLayer, true));
		this.decoree.connect(b, "onmouseout", dojo.hitch(this, "mouseoverout", inLayer, false));

		b.className="wmtablayers-roundedtab";
		divLeft.className="wmtablayers-roundedtab-left";
		divCenter.className="wmtablayers-roundedtab-center";
		divRight.className="wmtablayers-roundedtab-right";

		b.appendChild(divLeft);
		b.appendChild(divCenter);
		b.appendChild(divRight);
		
		dojo.connect(b, "onselectstart", dojo, "stopEvent");
		this.tabsControl.domNode.appendChild(b);
	},
	tabClicked: function(inLayer){
		var b=this.btns[inLayer.getIndex()];
		var divLeft = b.childNodes[0];
		var divCenter = b.childNodes[1];
		var divRight = b.childNodes[2];		
		if (b){
			dojo.removeClass(divLeft, 'wmtablayers-roundedtab-left-hover');				
			dojo.removeClass(divCenter, 'wmtablayers-roundedtab-center-hover');
			dojo.removeClass(divRight, 'wmtablayers-roundedtab-right-hover');			
		}
		this.inherited(arguments);					
	},
	mouseoverout: function(inLayer, inActive){
		var inIndex = inLayer.getIndex();		
		if(this.decoree.layerIndex != inIndex){ // user has put mouse over an inactive tab
			var b=this.btns[inIndex];
			var divLeft = b.childNodes[0];
			var divCenter = b.childNodes[1];
			var divRight = b.childNodes[2];
			if (b){				
				dojo[inActive ? "addClass" : "removeClass"](divLeft, 'wmtablayers-roundedtab-left-hover');				
				dojo[inActive ? "addClass" : "removeClass"](divCenter, 'wmtablayers-roundedtab-center-hover');
				dojo[inActive ? "addClass" : "removeClass"](divRight, 'wmtablayers-roundedtab-right-hover');
			}							
		}
	},
	applyLayerCaption: function(inLayer) {
		var d = this.decoree, i = inLayer.getIndex();
		if (i != -1)
			this.setBtnText(this.btns[i].childNodes[1], inLayer.caption);
	}
	
});

dojo.declare("wm.WizardDecorator", wm.TabsDecorator, {
    decorationClass: "wmwizardlayers",
    decoratorPadding: "2",
    buttonPanel: null,
    nextButton: null,
    prevButton: null,
	undecorate: function() {
	    this.inherited(arguments);
	    if (this.buttonPanel)
		this.buttonPanel.destroy();
	    this.buttonPanel = null;
	    this.nextButton  = null;
	    this.prevButton  = null;
	},
	addFooter: function() {
	    this.buttonPanel = new wm.Panel({name: "buttonPanel",
					     parent: this.decoree,
					     owner: this.decoree,
					     layoutKind: "left-to-right",
					     height: "40px",
					     width: "100%",
                                             freeze: true,
                                             lock: true,
					     verticalAlign: "top",
					     horizontalAlign: "right"});
	    this.prevButton = new wm.Button({name: "prevButton",
					     parent: this.buttonPanel,
					     owner: this.decoree,
					     width: "80px",
					     height: "100%",
					     caption: "Back"});
	    this.nextButton = new wm.Button({name: "nextButton",
					     parent: this.buttonPanel,
					     owner: this.decoree,
					     width: "80px",
					     height: "100%",
					     caption: "Next"});
	    dojo.connect(this.prevButton, "onclick", this, "backClick");
	    dojo.connect(this.nextButton, "onclick", this, "nextClick");
	},
	setLayerActive: function(inLayer, inActive) {
	    this.inherited(arguments);
	    var i = inLayer.getIndex();

	    /*
	    this.prevButton.setShowing(i > 0);
	    this.nextButton.setShowing(i < inLayer.decorator.decoree.layers.length-1);
	    */

	    this.nextButton.setCaption(i < inLayer.decorator.decoree.layers.length-1 ? "Next" : "Done");
	},
    nextClick: function() {
	var i = this.decoree.layerIndex;
	var layer = this.decoree.getActiveLayer();
	this.validateCurrentLayer();
	if (!layer.invalid) {
	    if (i == this.decoree.layers.length-1) {
		this.decoree.onDoneClick();
	    } else {
		this.decoree.setLayerIndex(i+1);
		var layer = this.decoree.getActiveLayer();
		layer.focusFirstEditor();
	    }
	} else {
	    this.validateCurrentLayer(); // Notify user of the problem
	}
    },
    validateCurrentLayer: function(noWarn) {
	var i = this.decoree.layerIndex;
	var layer = this.decoree.getActiveLayer();

	// Mark as invalid before we start
	//layer.layerHasBeenValidated = false; 
	dojo.removeClass(this.btns[i], "done");

	var invalidWidget = layer.getInvalidWidget();
	if (invalidWidget && !noWarn) {

	    // focusing on an invalid editor will automatically show its invalid message without needing an alert
	    invalidWidget.focus();
	    invalidWidget.editor.displayMessage(invalidWidget.invalidMessage || "Invalid Input", true);

	    app.toastDialog.showToast("Invalid value for " + (invalidWidget.caption || invalidWidget.name), 3000, "Warning", "cc");
	    return false;
	}


	if (invalidWidget) return false;
	var result = {invalidMessage: null};
	this.decoree.onLayerValidation(layer, result);
	if (result.invalidMessage) {
	    app.alertDialog.setUserPrompt(result.invalidMessage);
	    app.alertDialog.show();
	    return false;
	}

	//layer.layerHasBeenValidated = true;
	//dojo.addClass(this.btns[i], "done");
	return true;
    },
    backClick: function() {
	this.validateCurrentLayer(true);
	var i = this.decoree.layerIndex;
	if (i == 0)
	    this.decoree.onCancelClick();
	else
	    this.decoree.setLayerIndex(i-1);
    },
    tabClicked: function(inLayer, e) {
	if (this.decoree.isDesignLoaded()) return this.inherited(arguments);
	var layer = this.decoree.getActiveLayer();

	var newindex = inLayer.getIndex();
	for (var i = 0; i < newindex; i++) {
	    if (this.decoree.layers[i].invalid) {
		app.toastDialog.showToast("Please fill out \"" + this.decoree.layers[i].caption + "\" first", 3000, "Warning", "cc");
		return;
	    }
	}

	this.inherited(arguments);
    }

});

dojo.declare("wm.TabsControl", wm.Control, {
	height: "27px",
	width: "100%",
	border: 0,
	init: function() {
		if (this.parent && this.parent.isRelativePositioned)
			this.isRelativePositioned = true;
		dojo.addClass(this.domNode, "wmtablayers-tabbar");
		this.height = this.owner && this.owner.headerHeight;
		this.inherited(arguments);
	}
});
