/*
	Copyright (c) 2004-2009, The Dojo Foundation All Rights Reserved.
	Available via Academic Free License >= 2.1 OR the modified BSD license.
	see: http://dojotoolkit.org/license for details
*/

/*
	This is a compiled version of Dojo, built for deployment and not for
	development. To get an editable version, please visit:

		http://dojotoolkit.org

	for documentation and information on getting the source.
*/

dojo.provide("wm.compressed.wm_charts");if(!dojo._hasResource["dojox.gfx.matrix"]){dojo._hasResource["dojox.gfx.matrix"]=true;dojo.provide("dojox.gfx.matrix");(function(){var m=dojox.gfx.matrix;var _1={};m._degToRad=function(_2){return _1[_2]||(_1[_2]=(Math.PI*_2/180));};m._radToDeg=function(_3){return _3/Math.PI*180;};m.Matrix2D=function(_4){if(_4){if(typeof _4=="number"){this.xx=this.yy=_4;}else{if(_4 instanceof Array){if(_4.length>0){var _5=m.normalize(_4[0]);for(var i=1;i<_4.length;++i){var l=_5,r=dojox.gfx.matrix.normalize(_4[i]);_5=new m.Matrix2D();_5.xx=l.xx*r.xx+l.xy*r.yx;_5.xy=l.xx*r.xy+l.xy*r.yy;_5.yx=l.yx*r.xx+l.yy*r.yx;_5.yy=l.yx*r.xy+l.yy*r.yy;_5.dx=l.xx*r.dx+l.xy*r.dy+l.dx;_5.dy=l.yx*r.dx+l.yy*r.dy+l.dy;}dojo.mixin(this,_5);}}else{dojo.mixin(this,_4);}}}};dojo.extend(m.Matrix2D,{xx:1,xy:0,yx:0,yy:1,dx:0,dy:0});dojo.mixin(m,{identity:new m.Matrix2D(),flipX:new m.Matrix2D({xx:-1}),flipY:new m.Matrix2D({yy:-1}),flipXY:new m.Matrix2D({xx:-1,yy:-1}),translate:function(a,b){if(arguments.length>1){return new m.Matrix2D({dx:a,dy:b});}return new m.Matrix2D({dx:a.x,dy:a.y});},scale:function(a,b){if(arguments.length>1){return new m.Matrix2D({xx:a,yy:b});}if(typeof a=="number"){return new m.Matrix2D({xx:a,yy:a});}return new m.Matrix2D({xx:a.x,yy:a.y});},rotate:function(_6){var c=Math.cos(_6);var s=Math.sin(_6);return new m.Matrix2D({xx:c,xy:-s,yx:s,yy:c});},rotateg:function(_7){return m.rotate(m._degToRad(_7));},skewX:function(_8){return new m.Matrix2D({xy:Math.tan(_8)});},skewXg:function(_9){return m.skewX(m._degToRad(_9));},skewY:function(_a){return new m.Matrix2D({yx:Math.tan(_a)});},skewYg:function(_b){return m.skewY(m._degToRad(_b));},reflect:function(a,b){if(arguments.length==1){b=a.y;a=a.x;}var a2=a*a,b2=b*b,n2=a2+b2,xy=2*a*b/n2;return new m.Matrix2D({xx:2*a2/n2-1,xy:xy,yx:xy,yy:2*b2/n2-1});},project:function(a,b){if(arguments.length==1){b=a.y;a=a.x;}var a2=a*a,b2=b*b,n2=a2+b2,xy=a*b/n2;return new m.Matrix2D({xx:a2/n2,xy:xy,yx:xy,yy:b2/n2});},normalize:function(_c){return (_c instanceof m.Matrix2D)?_c:new m.Matrix2D(_c);},clone:function(_d){var _e=new m.Matrix2D();for(var i in _d){if(typeof (_d[i])=="number"&&typeof (_e[i])=="number"&&_e[i]!=_d[i]){_e[i]=_d[i];}}return _e;},invert:function(_f){var M=m.normalize(_f),D=M.xx*M.yy-M.xy*M.yx,M=new m.Matrix2D({xx:M.yy/D,xy:-M.xy/D,yx:-M.yx/D,yy:M.xx/D,dx:(M.xy*M.dy-M.yy*M.dx)/D,dy:(M.yx*M.dx-M.xx*M.dy)/D});return M;},_multiplyPoint:function(_10,x,y){return {x:_10.xx*x+_10.xy*y+_10.dx,y:_10.yx*x+_10.yy*y+_10.dy};},multiplyPoint:function(_11,a,b){var M=m.normalize(_11);if(typeof a=="number"&&typeof b=="number"){return m._multiplyPoint(M,a,b);}return m._multiplyPoint(M,a.x,a.y);},multiply:function(_12){var M=m.normalize(_12);for(var i=1;i<arguments.length;++i){var l=M,r=m.normalize(arguments[i]);M=new m.Matrix2D();M.xx=l.xx*r.xx+l.xy*r.yx;M.xy=l.xx*r.xy+l.xy*r.yy;M.yx=l.yx*r.xx+l.yy*r.yx;M.yy=l.yx*r.xy+l.yy*r.yy;M.dx=l.xx*r.dx+l.xy*r.dy+l.dx;M.dy=l.yx*r.dx+l.yy*r.dy+l.dy;}return M;},_sandwich:function(_13,x,y){return m.multiply(m.translate(x,y),_13,m.translate(-x,-y));},scaleAt:function(a,b,c,d){switch(arguments.length){case 4:return m._sandwich(m.scale(a,b),c,d);case 3:if(typeof c=="number"){return m._sandwich(m.scale(a),b,c);}return m._sandwich(m.scale(a,b),c.x,c.y);}return m._sandwich(m.scale(a),b.x,b.y);},rotateAt:function(_14,a,b){if(arguments.length>2){return m._sandwich(m.rotate(_14),a,b);}return m._sandwich(m.rotate(_14),a.x,a.y);},rotategAt:function(_15,a,b){if(arguments.length>2){return m._sandwich(m.rotateg(_15),a,b);}return m._sandwich(m.rotateg(_15),a.x,a.y);},skewXAt:function(_16,a,b){if(arguments.length>2){return m._sandwich(m.skewX(_16),a,b);}return m._sandwich(m.skewX(_16),a.x,a.y);},skewXgAt:function(_17,a,b){if(arguments.length>2){return m._sandwich(m.skewXg(_17),a,b);}return m._sandwich(m.skewXg(_17),a.x,a.y);},skewYAt:function(_18,a,b){if(arguments.length>2){return m._sandwich(m.skewY(_18),a,b);}return m._sandwich(m.skewY(_18),a.x,a.y);},skewYgAt:function(_19,a,b){if(arguments.length>2){return m._sandwich(m.skewYg(_19),a,b);}return m._sandwich(m.skewYg(_19),a.x,a.y);}});})();dojox.gfx.Matrix2D=dojox.gfx.matrix.Matrix2D;}if(!dojo._hasResource["dojox.gfx._base"]){dojo._hasResource["dojox.gfx._base"]=true;dojo.provide("dojox.gfx._base");(function(){var g=dojox.gfx,b=g._base;g._hasClass=function(_1a,_1b){var cls=_1a.getAttribute("className");return cls&&(" "+cls+" ").indexOf(" "+_1b+" ")>=0;};g._addClass=function(_1c,_1d){var cls=_1c.getAttribute("className")||"";if(!cls||(" "+cls+" ").indexOf(" "+_1d+" ")<0){_1c.setAttribute("className",cls+(cls?" ":"")+_1d);}};g._removeClass=function(_1e,_1f){var cls=_1e.getAttribute("className");if(cls){_1e.setAttribute("className",cls.replace(new RegExp("(^|\\s+)"+_1f+"(\\s+|$)"),"$1$2"));}};b._getFontMeasurements=function(){var _20={"1em":0,"1ex":0,"100%":0,"12pt":0,"16px":0,"xx-small":0,"x-small":0,"small":0,"medium":0,"large":0,"x-large":0,"xx-large":0};if(dojo.isIE){dojo.doc.documentElement.style.fontSize="100%";}var div=dojo.doc.createElement("div");var s=div.style;s.position="absolute";s.left="-100px";s.top="0px";s.width="30px";s.height="1000em";s.border="0px";s.margin="0px";s.padding="0px";s.outline="none";s.lineHeight="1";s.overflow="hidden";dojo.body().appendChild(div);for(var p in _20){div.style.fontSize=p;_20[p]=Math.round(div.offsetHeight*12/16)*16/12/1000;}dojo.body().removeChild(div);div=null;return _20;};var _21=null;b._getCachedFontMeasurements=function(_22){if(_22||!_21){_21=b._getFontMeasurements();}return _21;};var _23=null,_24={};b._getTextBox=function(_25,_26,_27){var m,s,al=arguments.length;if(!_23){m=_23=dojo.doc.createElement("div");s=m.style;s.position="absolute";s.left="-10000px";s.top="0";dojo.body().appendChild(m);}else{m=_23;s=m.style;}m.className="";s.border="0";s.margin="0";s.padding="0";s.outline="0";if(al>1&&_26){for(var i in _26){if(i in _24){continue;}s[i]=_26[i];}}if(al>2&&_27){m.className=_27;}m.innerHTML=_25;if(m["getBoundingClientRect"]){var bcr=m.getBoundingClientRect();return {l:bcr.left,t:bcr.top,w:bcr.width||(bcr.right-bcr.left),h:bcr.height||(bcr.bottom-bcr.top)};}else{return dojo.marginBox(m);}};var _28=0;b._getUniqueId=function(){var id;do{id=dojo._scopeName+"Unique"+(++_28);}while(dojo.byId(id));return id;};})();dojo.mixin(dojox.gfx,{defaultPath:{type:"path",path:""},defaultPolyline:{type:"polyline",points:[]},defaultRect:{type:"rect",x:0,y:0,width:100,height:100,r:0},defaultEllipse:{type:"ellipse",cx:0,cy:0,rx:200,ry:100},defaultCircle:{type:"circle",cx:0,cy:0,r:100},defaultLine:{type:"line",x1:0,y1:0,x2:100,y2:100},defaultImage:{type:"image",x:0,y:0,width:0,height:0,src:""},defaultText:{type:"text",x:0,y:0,text:"",align:"start",decoration:"none",rotated:false,kerning:true},defaultTextPath:{type:"textpath",text:"",align:"start",decoration:"none",rotated:false,kerning:true},defaultStroke:{type:"stroke",color:"black",style:"solid",width:1,cap:"butt",join:4},defaultLinearGradient:{type:"linear",x1:0,y1:0,x2:100,y2:100,colors:[{offset:0,color:"black"},{offset:1,color:"white"}]},defaultRadialGradient:{type:"radial",cx:0,cy:0,r:100,colors:[{offset:0,color:"black"},{offset:1,color:"white"}]},defaultPattern:{type:"pattern",x:0,y:0,width:0,height:0,src:""},defaultFont:{type:"font",style:"normal",variant:"normal",weight:"normal",size:"10pt",family:"serif"},getDefault:(function(){var _29={};return function(_2a){var t=_29[_2a];if(t){return new t();}t=_29[_2a]=new Function;t.prototype=dojox.gfx["default"+_2a];return new t();};})(),normalizeColor:function(_2b){return (_2b instanceof dojo.Color)?_2b:new dojo.Color(_2b);},normalizeParameters:function(_2c,_2d){if(_2d){var _2e={};for(var x in _2c){if(x in _2d&&!(x in _2e)){_2c[x]=_2d[x];}}}return _2c;},makeParameters:function(_2f,_30){if(!_30){return dojo.delegate(_2f);}var _31={};for(var i in _2f){if(!(i in _31)){_31[i]=dojo.clone((i in _30)?_30[i]:_2f[i]);}}return _31;},formatNumber:function(x,_32){var val=x.toString();if(val.indexOf("e")>=0){val=x.toFixed(4);}else{var _33=val.indexOf(".");if(_33>=0&&val.length-_33>5){val=x.toFixed(4);}}if(x<0){return val;}return _32?" "+val:val;},makeFontString:function(_34){return _34.style+" "+_34.variant+" "+_34.weight+" "+_34.size+" "+_34.family;},splitFontString:function(str){var _35=dojox.gfx.getDefault("Font");var t=str.split(/\s+/);do{if(t.length<5){break;}_35.style=t[0];_35.variant=t[1];_35.weight=t[2];var i=t[3].indexOf("/");_35.size=i<0?t[3]:t[3].substring(0,i);var j=4;if(i<0){if(t[4]=="/"){j=6;}else{if(t[4].charAt(0)=="/"){j=5;}}}if(j<t.length){_35.family=t.slice(j).join(" ");}}while(false);return _35;},cm_in_pt:72/2.54,mm_in_pt:7.2/2.54,px_in_pt:function(){return dojox.gfx._base._getCachedFontMeasurements()["12pt"]/12;},pt2px:function(len){return len*dojox.gfx.px_in_pt();},px2pt:function(len){return len/dojox.gfx.px_in_pt();},normalizedLength:function(len){if(len.length==0){return 0;}if(len.length>2){var _36=dojox.gfx.px_in_pt();var val=parseFloat(len);switch(len.slice(-2)){case "px":return val;case "pt":return val*_36;case "in":return val*72*_36;case "pc":return val*12*_36;case "mm":return val*dojox.gfx.mm_in_pt*_36;case "cm":return val*dojox.gfx.cm_in_pt*_36;}}return parseFloat(len);},pathVmlRegExp:/([A-Za-z]+)|(\d+(\.\d+)?)|(\.\d+)|(-\d+(\.\d+)?)|(-\.\d+)/g,pathSvgRegExp:/([A-Za-z])|(\d+(\.\d+)?)|(\.\d+)|(-\d+(\.\d+)?)|(-\.\d+)/g,equalSources:function(a,b){return a&&b&&a==b;}});}if(!dojo._hasResource["dojox.gfx"]){dojo._hasResource["dojox.gfx"]=true;dojo.provide("dojox.gfx");dojo.loadInit(function(){var gfx=dojo.getObject("dojox.gfx",true),sl,_37,_38;if(!gfx.renderer){if(dojo.config.forceGfxRenderer){dojox.gfx.renderer=dojo.config.forceGfxRenderer;return;}var _39=(typeof dojo.config.gfxRenderer=="string"?dojo.config.gfxRenderer:"svg,vml,silverlight,canvas").split(",");var ua=navigator.userAgent,_3a=0,_3b=0;if(dojo.isSafari>=3){if(ua.indexOf("iPhone")>=0||ua.indexOf("iPod")>=0){_38=ua.match(/Version\/(\d(\.\d)?(\.\d)?)\sMobile\/([^\s]*)\s?/);if(_38){_3a=parseInt(_38[4].substr(0,3),16);}}}if(dojo.isWebKit){if(!_3a){_38=ua.match(/Android\s+(\d+\.\d+)/);if(_38){_3b=parseFloat(_38[1]);}}}for(var i=0;i<_39.length;++i){switch(_39[i]){case "svg":if(!dojo.isIE&&(!_3a||_3a>=1521)&&!_3b&&!dojo.isAIR){dojox.gfx.renderer="svg";}break;case "vml":if(dojo.isIE){dojox.gfx.renderer="vml";}break;case "silverlight":try{if(dojo.isIE){sl=new ActiveXObject("AgControl.AgControl");if(sl&&sl.IsVersionSupported("1.0")){_37=true;}}else{if(navigator.plugins["Silverlight Plug-In"]){_37=true;}}}catch(e){_37=false;}finally{sl=null;}if(_37){dojox.gfx.renderer="silverlight";}break;case "canvas":if(!dojo.isIE){dojox.gfx.renderer="canvas";}break;}if(dojox.gfx.renderer){break;}}if(dojo.config.isDebug){console.log("gfx renderer = "+dojox.gfx.renderer);}}});dojo.requireIf(dojox.gfx.renderer=="svg","dojox.gfx.svg");dojo.requireIf(dojox.gfx.renderer=="vml","dojox.gfx.vml");dojo.requireIf(dojox.gfx.renderer=="silverlight","dojox.gfx.silverlight");dojo.requireIf(dojox.gfx.renderer=="canvas","dojox.gfx.canvas");}if(!dojo._hasResource["dojox.lang.functional.lambda"]){dojo._hasResource["dojox.lang.functional.lambda"]=true;dojo.provide("dojox.lang.functional.lambda");(function(){var df=dojox.lang.functional,_3c={};var _3d="ab".split(/a*/).length>1?String.prototype.split:function(sep){var r=this.split.call(this,sep),m=sep.exec(this);if(m&&m.index==0){r.unshift("");}return r;};var _3e=function(s){var _3f=[],_40=_3d.call(s,/\s*->\s*/m);if(_40.length>1){while(_40.length){s=_40.pop();_3f=_40.pop().split(/\s*,\s*|\s+/m);if(_40.length){_40.push("(function("+_3f+"){return ("+s+")})");}}}else{if(s.match(/\b_\b/)){_3f=["_"];}else{var l=s.match(/^\s*(?:[+*\/%&|\^\.=<>]|!=)/m),r=s.match(/[+\-*\/%&|\^\.=<>!]\s*$/m);if(l||r){if(l){_3f.push("$1");s="$1"+s;}if(r){_3f.push("$2");s=s+"$2";}}else{var _41=s.replace(/(?:\b[A-Z]|\.[a-zA-Z_$])[a-zA-Z_$\d]*|[a-zA-Z_$][a-zA-Z_$\d]*:|this|true|false|null|undefined|typeof|instanceof|in|delete|new|void|arguments|decodeURI|decodeURIComponent|encodeURI|encodeURIComponent|escape|eval|isFinite|isNaN|parseFloat|parseInt|unescape|dojo|dijit|dojox|window|document|'(?:[^'\\]|\\.)*'|"(?:[^"\\]|\\.)*"/g,"").match(/([a-z_$][a-z_$\d]*)/gi)||[],t={};dojo.forEach(_41,function(v){if(!(v in t)){_3f.push(v);t[v]=1;}});}}}return {args:_3f,body:s};};var _42=function(a){return a.length?function(){var i=a.length-1,x=df.lambda(a[i]).apply(this,arguments);for(--i;i>=0;--i){x=df.lambda(a[i]).call(this,x);}return x;}:function(x){return x;};};dojo.mixin(df,{rawLambda:function(s){return _3e(s);},buildLambda:function(s){s=_3e(s);return "function("+s.args.join(",")+"){return ("+s.body+");}";},lambda:function(s){if(typeof s=="function"){return s;}if(s instanceof Array){return _42(s);}if(s in _3c){return _3c[s];}s=_3e(s);return _3c[s]=new Function(s.args,"return ("+s.body+");");},clearLambdaCache:function(){_3c={};}});})();}if(!dojo._hasResource["dojox.lang.functional.array"]){dojo._hasResource["dojox.lang.functional.array"]=true;dojo.provide("dojox.lang.functional.array");(function(){var d=dojo,df=dojox.lang.functional,_43={};d.mixin(df,{filter:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||d.global;f=df.lambda(f);var t=[],v,i,n;if(d.isArray(a)){for(i=0,n=a.length;i<n;++i){v=a[i];if(f.call(o,v,i,a)){t.push(v);}}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){for(i=0;a.hasNext();){v=a.next();if(f.call(o,v,i++,a)){t.push(v);}}}else{for(i in a){if(!(i in _43)){v=a[i];if(f.call(o,v,i,a)){t.push(v);}}}}}return t;},forEach:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||d.global;f=df.lambda(f);var i,n;if(d.isArray(a)){for(i=0,n=a.length;i<n;f.call(o,a[i],i,a),++i){}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){for(i=0;a.hasNext();f.call(o,a.next(),i++,a)){}}else{for(i in a){if(!(i in _43)){f.call(o,a[i],i,a);}}}}return o;},map:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||d.global;f=df.lambda(f);var t,n,i;if(d.isArray(a)){t=new Array(n=a.length);for(i=0;i<n;t[i]=f.call(o,a[i],i,a),++i){}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){t=[];for(i=0;a.hasNext();t.push(f.call(o,a.next(),i++,a))){}}else{t=[];for(i in a){if(!(i in _43)){t.push(f.call(o,a[i],i,a));}}}}return t;},every:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||d.global;f=df.lambda(f);var i,n;if(d.isArray(a)){for(i=0,n=a.length;i<n;++i){if(!f.call(o,a[i],i,a)){return false;}}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){for(i=0;a.hasNext();){if(!f.call(o,a.next(),i++,a)){return false;}}}else{for(i in a){if(!(i in _43)){if(!f.call(o,a[i],i,a)){return false;}}}}}return true;},some:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||d.global;f=df.lambda(f);var i,n;if(d.isArray(a)){for(i=0,n=a.length;i<n;++i){if(f.call(o,a[i],i,a)){return true;}}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){for(i=0;a.hasNext();){if(f.call(o,a.next(),i++,a)){return true;}}}else{for(i in a){if(!(i in _43)){if(f.call(o,a[i],i,a)){return true;}}}}}return false;}});})();}if(!dojo._hasResource["dojox.lang.functional.object"]){dojo._hasResource["dojox.lang.functional.object"]=true;dojo.provide("dojox.lang.functional.object");(function(){var d=dojo,df=dojox.lang.functional,_44={};d.mixin(df,{keys:function(obj){var t=[];for(var i in obj){if(!(i in _44)){t.push(i);}}return t;},values:function(obj){var t=[];for(var i in obj){if(!(i in _44)){t.push(obj[i]);}}return t;},filterIn:function(obj,f,o){o=o||d.global;f=df.lambda(f);var t={},v,i;for(i in obj){if(!(i in _44)){v=obj[i];if(f.call(o,v,i,obj)){t[i]=v;}}}return t;},forIn:function(obj,f,o){o=o||d.global;f=df.lambda(f);for(var i in obj){if(!(i in _44)){f.call(o,obj[i],i,obj);}}return o;},mapIn:function(obj,f,o){o=o||d.global;f=df.lambda(f);var t={},i;for(i in obj){if(!(i in _44)){t[i]=f.call(o,obj[i],i,obj);}}return t;}});})();}if(!dojo._hasResource["dojox.lang.functional"]){dojo._hasResource["dojox.lang.functional"]=true;dojo.provide("dojox.lang.functional");}if(!dojo._hasResource["dojox.lang.functional.fold"]){dojo._hasResource["dojox.lang.functional.fold"]=true;dojo.provide("dojox.lang.functional.fold");(function(){var d=dojo,df=dojox.lang.functional,_45={};d.mixin(df,{foldl:function(a,f,z,o){if(typeof a=="string"){a=a.split("");}o=o||d.global;f=df.lambda(f);var i,n;if(d.isArray(a)){for(i=0,n=a.length;i<n;z=f.call(o,z,a[i],i,a),++i){}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){for(i=0;a.hasNext();z=f.call(o,z,a.next(),i++,a)){}}else{for(i in a){if(!(i in _45)){z=f.call(o,z,a[i],i,a);}}}}return z;},foldl1:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||d.global;f=df.lambda(f);var z,i,n;if(d.isArray(a)){z=a[0];for(i=1,n=a.length;i<n;z=f.call(o,z,a[i],i,a),++i){}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){if(a.hasNext()){z=a.next();for(i=1;a.hasNext();z=f.call(o,z,a.next(),i++,a)){}}}else{var _46=true;for(i in a){if(!(i in _45)){if(_46){z=a[i];_46=false;}else{z=f.call(o,z,a[i],i,a);}}}}}return z;},foldr:function(a,f,z,o){if(typeof a=="string"){a=a.split("");}o=o||d.global;f=df.lambda(f);for(var i=a.length;i>0;--i,z=f.call(o,z,a[i],i,a)){}return z;},foldr1:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||d.global;f=df.lambda(f);var n=a.length,z=a[n-1],i=n-1;for(;i>0;--i,z=f.call(o,z,a[i],i,a)){}return z;},reduce:function(a,f,z){return arguments.length<3?df.foldl1(a,f):df.foldl(a,f,z);},reduceRight:function(a,f,z){return arguments.length<3?df.foldr1(a,f):df.foldr(a,f,z);},unfold:function(pr,f,g,z,o){o=o||d.global;f=df.lambda(f);g=df.lambda(g);pr=df.lambda(pr);var t=[];for(;!pr.call(o,z);t.push(f.call(o,z)),z=g.call(o,z)){}return t;}});})();}if(!dojo._hasResource["dojox.lang.functional.reversed"]){dojo._hasResource["dojox.lang.functional.reversed"]=true;dojo.provide("dojox.lang.functional.reversed");(function(){var d=dojo,df=dojox.lang.functional;d.mixin(df,{filterRev:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||d.global;f=df.lambda(f);var t=[],v,i=a.length-1;for(;i>=0;--i){v=a[i];if(f.call(o,v,i,a)){t.push(v);}}return t;},forEachRev:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||d.global;f=df.lambda(f);for(var i=a.length-1;i>=0;f.call(o,a[i],i,a),--i){}},mapRev:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||d.global;f=df.lambda(f);var n=a.length,t=new Array(n),i=n-1,j=0;for(;i>=0;t[j++]=f.call(o,a[i],i,a),--i){}return t;},everyRev:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||d.global;f=df.lambda(f);for(var i=a.length-1;i>=0;--i){if(!f.call(o,a[i],i,a)){return false;}}return true;},someRev:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||d.global;f=df.lambda(f);for(var i=a.length-1;i>=0;--i){if(f.call(o,a[i],i,a)){return true;}}return false;}});})();}if(!dojo._hasResource["dojox.color.Palette"]){dojo._hasResource["dojox.color.Palette"]=true;dojo.provide("dojox.color.Palette");(function(){var dxc=dojox.color;dxc.Palette=function(_47){this.colors=[];if(_47 instanceof dojox.color.Palette){this.colors=_47.colors.slice(0);}else{if(_47 instanceof dojox.color.Color){this.colors=[null,null,_47,null,null];}else{if(dojo.isArray(_47)){this.colors=dojo.map(_47.slice(0),function(_48){if(dojo.isString(_48)){return new dojox.color.Color(_48);}return _48;});}else{if(dojo.isString(_47)){this.colors=[null,null,new dojox.color.Color(_47),null,null];}}}}};function _49(p,_4a,val){var ret=new dojox.color.Palette();ret.colors=[];dojo.forEach(p.colors,function(_4b){var r=(_4a=="dr")?_4b.r+val:_4b.r,g=(_4a=="dg")?_4b.g+val:_4b.g,b=(_4a=="db")?_4b.b+val:_4b.b,a=(_4a=="da")?_4b.a+val:_4b.a;ret.colors.push(new dojox.color.Color({r:Math.min(255,Math.max(0,r)),g:Math.min(255,Math.max(0,g)),b:Math.min(255,Math.max(0,b)),a:Math.min(1,Math.max(0,a))}));});console.log("The return colors are ",ret.colors," from the original colors ",p.colors);return ret;};function _4c(p,_4d,val){var ret=new dojox.color.Palette();ret.colors=[];dojo.forEach(p.colors,function(_4e){var o=_4e.toCmy(),c=(_4d=="dc")?o.c+val:o.c,m=(_4d=="dm")?o.m+val:o.m,y=(_4d=="dy")?o.y+val:o.y;ret.colors.push(dojox.color.fromCmy(Math.min(100,Math.max(0,c)),Math.min(100,Math.max(0,m)),Math.min(100,Math.max(0,y))));});return ret;};function _4f(p,_50,val){var ret=new dojox.color.Palette();ret.colors=[];dojo.forEach(p.colors,function(_51){var o=_51.toCmyk(),c=(_50=="dc")?o.c+val:o.c,m=(_50=="dm")?o.m+val:o.m,y=(_50=="dy")?o.y+val:o.y,k=(_50=="dk")?o.b+val:o.b;ret.colors.push(dojox.color.fromCmyk(Math.min(100,Math.max(0,c)),Math.min(100,Math.max(0,m)),Math.min(100,Math.max(0,y)),Math.min(100,Math.max(0,k))));});return ret;};function _52(p,_53,val){var ret=new dojox.color.Palette();ret.colors=[];dojo.forEach(p.colors,function(_54){var o=_54.toHsl(),h=(_53=="dh")?o.h+val:o.h,s=(_53=="ds")?o.s+val:o.s,l=(_53=="dl")?o.l+val:o.l;ret.colors.push(dojox.color.fromHsl(h%360,Math.min(100,Math.max(0,s)),Math.min(100,Math.max(0,l))));});return ret;};function _55(p,_56,val){var ret=new dojox.color.Palette();ret.colors=[];dojo.forEach(p.colors,function(_57){var o=_57.toHsv(),h=(_56=="dh")?o.h+val:o.h,s=(_56=="ds")?o.s+val:o.s,v=(_56=="dv")?o.v+val:o.v;ret.colors.push(dojox.color.fromHsv(h%360,Math.min(100,Math.max(0,s)),Math.min(100,Math.max(0,v))));});return ret;};function _58(val,low,_59){return _59-((_59-val)*((_59-low)/_59));};dojo.extend(dxc.Palette,{transform:function(_5a){var fn=_49;if(_5a.use){var use=_5a.use.toLowerCase();if(use.indexOf("hs")==0){if(use.charAt(2)=="l"){fn=_52;}else{fn=_55;}}else{if(use.indexOf("cmy")==0){if(use.charAt(3)=="k"){fn=_4f;}else{fn=_4c;}}}}else{if("dc" in _5a||"dm" in _5a||"dy" in _5a){if("dk" in _5a){fn=_4f;}else{fn=_4c;}}else{if("dh" in _5a||"ds" in _5a){if("dv" in _5a){fn=_55;}else{fn=_52;}}}}var _5b=this;for(var p in _5a){if(p=="use"){continue;}_5b=fn(_5b,p,_5a[p]);}return _5b;},clone:function(){return new dxc.Palette(this);}});dojo.mixin(dxc.Palette,{generators:{analogous:function(_5c){var _5d=_5c.high||60,low=_5c.low||18,_5e=dojo.isString(_5c.base)?new dojox.color.Color(_5c.base):_5c.base,hsv=_5e.toHsv();var h=[(hsv.h+low+360)%360,(hsv.h+Math.round(low/2)+360)%360,hsv.h,(hsv.h-Math.round(_5d/2)+360)%360,(hsv.h-_5d+360)%360];var s1=Math.max(10,(hsv.s<=95)?hsv.s+5:(100-(hsv.s-95))),s2=(hsv.s>1)?hsv.s-1:21-hsv.s,v1=(hsv.v>=92)?hsv.v-9:Math.max(hsv.v+9,20),v2=(hsv.v<=90)?Math.max(hsv.v+5,20):(95+Math.ceil((hsv.v-90)/2)),s=[s1,s2,hsv.s,s1,s1],v=[v1,v2,hsv.v,v1,v2];return new dxc.Palette(dojo.map(h,function(hue,i){return dojox.color.fromHsv(hue,s[i],v[i]);}));},monochromatic:function(_5f){var _60=dojo.isString(_5f.base)?new dojox.color.Color(_5f.base):_5f.base,hsv=_60.toHsv();var s1=(hsv.s-30>9)?hsv.s-30:hsv.s+30,s2=hsv.s,v1=_58(hsv.v,20,100),v2=(hsv.v-20>20)?hsv.v-20:hsv.v+60,v3=(hsv.v-50>20)?hsv.v-50:hsv.v+30;return new dxc.Palette([dojox.color.fromHsv(hsv.h,s1,v1),dojox.color.fromHsv(hsv.h,s2,v3),_60,dojox.color.fromHsv(hsv.h,s1,v3),dojox.color.fromHsv(hsv.h,s2,v2)]);},triadic:function(_61){var _62=dojo.isString(_61.base)?new dojox.color.Color(_61.base):_61.base,hsv=_62.toHsv();var h1=(hsv.h+57+360)%360,h2=(hsv.h-157+360)%360,s1=(hsv.s>20)?hsv.s-10:hsv.s+10,s2=(hsv.s>90)?hsv.s-10:hsv.s+10,s3=(hsv.s>95)?hsv.s-5:hsv.s+5,v1=(hsv.v-20>20)?hsv.v-20:hsv.v+20,v2=(hsv.v-30>20)?hsv.v-30:hsv.v+30,v3=(hsv.v-30>70)?hsv.v-30:hsv.v+30;return new dxc.Palette([dojox.color.fromHsv(h1,s1,hsv.v),dojox.color.fromHsv(hsv.h,s2,v2),_62,dojox.color.fromHsv(h2,s2,v1),dojox.color.fromHsv(h2,s3,v3)]);},complementary:function(_63){var _64=dojo.isString(_63.base)?new dojox.color.Color(_63.base):_63.base,hsv=_64.toHsv();var h1=((hsv.h*2)+137<360)?(hsv.h*2)+137:Math.floor(hsv.h/2)-137,s1=Math.max(hsv.s-10,0),s2=_58(hsv.s,10,100),s3=Math.min(100,hsv.s+20),v1=Math.min(100,hsv.v+30),v2=(hsv.v>20)?hsv.v-30:hsv.v+30;return new dxc.Palette([dojox.color.fromHsv(hsv.h,s1,v1),dojox.color.fromHsv(hsv.h,s2,v2),_64,dojox.color.fromHsv(h1,s3,v2),dojox.color.fromHsv(h1,hsv.s,hsv.v)]);},splitComplementary:function(_65){var _66=dojo.isString(_65.base)?new dojox.color.Color(_65.base):_65.base,_67=_65.da||30,hsv=_66.toHsv();var _68=((hsv.h*2)+137<360)?(hsv.h*2)+137:Math.floor(hsv.h/2)-137,h1=(_68-_67+360)%360,h2=(_68+_67)%360,s1=Math.max(hsv.s-10,0),s2=_58(hsv.s,10,100),s3=Math.min(100,hsv.s+20),v1=Math.min(100,hsv.v+30),v2=(hsv.v>20)?hsv.v-30:hsv.v+30;return new dxc.Palette([dojox.color.fromHsv(h1,s1,v1),dojox.color.fromHsv(h1,s2,v2),_66,dojox.color.fromHsv(h2,s3,v2),dojox.color.fromHsv(h2,hsv.s,hsv.v)]);},compound:function(_69){var _6a=dojo.isString(_69.base)?new dojox.color.Color(_69.base):_69.base,hsv=_6a.toHsv();var h1=((hsv.h*2)+18<360)?(hsv.h*2)+18:Math.floor(hsv.h/2)-18,h2=((hsv.h*2)+120<360)?(hsv.h*2)+120:Math.floor(hsv.h/2)-120,h3=((hsv.h*2)+99<360)?(hsv.h*2)+99:Math.floor(hsv.h/2)-99,s1=(hsv.s-40>10)?hsv.s-40:hsv.s+40,s2=(hsv.s-10>80)?hsv.s-10:hsv.s+10,s3=(hsv.s-25>10)?hsv.s-25:hsv.s+25,v1=(hsv.v-40>10)?hsv.v-40:hsv.v+40,v2=(hsv.v-20>80)?hsv.v-20:hsv.v+20,v3=Math.max(hsv.v,20);return new dxc.Palette([dojox.color.fromHsv(h1,s1,v1),dojox.color.fromHsv(h1,s2,v2),_6a,dojox.color.fromHsv(h2,s3,v3),dojox.color.fromHsv(h3,s2,v2)]);},shades:function(_6b){var _6c=dojo.isString(_6b.base)?new dojox.color.Color(_6b.base):_6b.base,hsv=_6c.toHsv();var s=(hsv.s==100&&hsv.v==0)?0:hsv.s,v1=(hsv.v-50>20)?hsv.v-50:hsv.v+30,v2=(hsv.v-25>=20)?hsv.v-25:hsv.v+55,v3=(hsv.v-75>=20)?hsv.v-75:hsv.v+5,v4=Math.max(hsv.v-10,20);return new dxc.Palette([new dojox.color.fromHsv(hsv.h,s,v1),new dojox.color.fromHsv(hsv.h,s,v2),_6c,new dojox.color.fromHsv(hsv.h,s,v3),new dojox.color.fromHsv(hsv.h,s,v4)]);}},generate:function(_6d,_6e){if(dojo.isFunction(_6e)){return _6e({base:_6d});}else{if(dxc.Palette.generators[_6e]){return dxc.Palette.generators[_6e]({base:_6d});}}throw new Error("dojox.color.Palette.generate: the specified generator ('"+_6e+"') does not exist.");}});})();}if(!dojo._hasResource["dojox.charting.Theme"]){dojo._hasResource["dojox.charting.Theme"]=true;dojo.provide("dojox.charting.Theme");(function(){var dxc=dojox.charting;dxc.Theme=function(_6f){_6f=_6f||{};var def=dxc.Theme._def;dojo.forEach(["chart","plotarea","axis","series","marker"],function(n){this[n]=dojo.delegate(def[n],_6f[n]||{});},this);this.markers=dojo.delegate(dxc.Theme.Markers,_6f.markers||{});this.colors=[];this.antiAlias=("antiAlias" in _6f)?_6f.antiAlias:true;this.assignColors=("assignColors" in _6f)?_6f.assignColors:true;this.assignMarkers=("assignMarkers" in _6f)?_6f.assignMarkers:true;_6f.colors=_6f.colors||def.colors;dojo.forEach(_6f.colors,function(_70){this.colors.push(_70);},this);this._current={color:0,marker:0};this._markers=[];this._buildMarkerArray();};dxc.Theme.Markers={CIRCLE:"m-3,0 c0,-4 6,-4 6,0 m-6,0 c0,4 6,4 6,0",SQUARE:"m-3,-3 l0,6 6,0 0,-6 z",DIAMOND:"m0,-3 l3,3 -3,3 -3,-3 z",CROSS:"m0,-3 l0,6 m-3,-3 l6,0",X:"m-3,-3 l6,6 m0,-6 l-6,6",TRIANGLE:"m-3,3 l3,-6 3,6 z",TRIANGLE_INVERTED:"m-3,-3 l3,6 3,-6 z"};dxc.Theme._def={chart:{stroke:null,fill:"white"},plotarea:{stroke:null,fill:"white"},axis:{stroke:{color:"#333",width:1},majorTick:{color:"#666",width:1,length:6,position:"center"},minorTick:{color:"#666",width:0.8,length:3,position:"center"},microTick:{color:"#666",width:0.5,length:1,position:"center"},font:"normal normal normal 7pt Tahoma",fontColor:"#333"},series:{outline:{width:0.1,color:"#ccc"},stroke:{width:1.5,color:"#333"},fill:"#ccc",font:"normal normal normal 7pt Tahoma",fontColor:"#000"},marker:{stroke:{width:1},fill:"#333",font:"normal normal normal 7pt Tahoma",fontColor:"#000"},colors:["#54544c","#858e94","#6e767a","#948585","#474747"]};dojo.extend(dxc.Theme,{defineColors:function(obj){var _71=obj||{};var c=[],n=_71.num||5;if(_71.colors){var l=_71.colors.length;for(var i=0;i<n;i++){c.push(_71.colors[i%l]);}this.colors=c;}else{if(_71.hue){var s=_71.saturation||100;var st=_71.low||30;var end=_71.high||90;var l=(end+st)/2;this.colors=dojox.color.Palette.generate(dojox.color.fromHsv(_71.hue,s,l),"monochromatic").colors;}else{if(_71.generator){this.colors=dojox.color.Palette.generate(_71.base,_71.generator).colors;}}}},_buildMarkerArray:function(){this._markers=[];for(var p in this.markers){this._markers.push(this.markers[p]);}this._current.marker=0;},_clone:function(){return new dxc.Theme({chart:this.chart,plotarea:this.plotarea,axis:this.axis,series:this.series,marker:this.marker,antiAlias:this.antiAlias,assignColors:this.assignColors,assignMarkers:this.assigneMarkers,colors:dojo.delegate(this.colors)});},addMarker:function(_72,_73){this.markers[_72]=_73;this._buildMarkerArray();},setMarkers:function(obj){this.markers=obj;this._buildMarkerArray();},next:function(_74){if(_74=="marker"){return this._markers[this._current.marker++%this._markers.length];}else{return this.colors[this._current.color++%this.colors.length];}},clear:function(){this._current={color:0,marker:0};}});})();}if(!dojo._hasResource["dojox.charting.Element"]){dojo._hasResource["dojox.charting.Element"]=true;dojo.provide("dojox.charting.Element");dojo.declare("dojox.charting.Element",null,{constructor:function(_75){this.chart=_75;this.group=null;this.htmlElements=[];this.dirty=true;},createGroup:function(_76){if(!_76){_76=this.chart.surface;}if(!this.group){this.group=_76.createGroup();}return this;},purgeGroup:function(){this.destroyHtmlElements();if(this.group){this.group.clear();this.group.removeShape();this.group=null;}this.dirty=true;return this;},cleanGroup:function(_77){this.destroyHtmlElements();if(!_77){_77=this.chart.surface;}if(this.group){this.group.clear();}else{this.group=_77.createGroup();}this.dirty=true;return this;},destroyHtmlElements:function(){if(this.htmlElements.length){dojo.forEach(this.htmlElements,dojo.destroy);this.htmlElements=[];}},destroy:function(){this.purgeGroup();}});}if(!dojo._hasResource["dojox.charting.Series"]){dojo._hasResource["dojox.charting.Series"]=true;dojo.provide("dojox.charting.Series");dojo.declare("dojox.charting.Series",dojox.charting.Element,{constructor:function(_78,_79,_7a){dojo.mixin(this,_7a);if(typeof this.plot!="string"){this.plot="default";}this.data=_79;this.dirty=true;this.clear();},clear:function(){this.dyn={};}});}if(!dojo._hasResource["dojox.charting.scaler.common"]){dojo._hasResource["dojox.charting.scaler.common"]=true;dojo.provide("dojox.charting.scaler.common");(function(){var eq=function(a,b){return Math.abs(a-b)<=0.000001*(Math.abs(a)+Math.abs(b));};dojo.mixin(dojox.charting.scaler.common,{findString:function(val,_7b){val=val.toLowerCase();for(var i=0;i<_7b.length;++i){if(val==_7b[i]){return true;}}return false;},getNumericLabel:function(_7c,_7d,_7e){var def=_7e.fixed?_7c.toFixed(_7d<0?-_7d:0):_7c.toString();if(_7e.labelFunc){var r=_7e.labelFunc(def,_7c,_7d);if(r){return r;}}if(_7e.labels){var l=_7e.labels,lo=0,hi=l.length;while(lo<hi){var mid=Math.floor((lo+hi)/2),val=l[mid].value;if(val<_7c){lo=mid+1;}else{hi=mid;}}if(lo<l.length&&eq(l[lo].value,_7c)){return l[lo].text;}--lo;if(lo>=0&&lo<l.length&&eq(l[lo].value,_7c)){return l[lo].text;}lo+=2;if(lo<l.length&&eq(l[lo].value,_7c)){return l[lo].text;}}return def;}});})();}if(!dojo._hasResource["dojox.charting.scaler.linear"]){dojo._hasResource["dojox.charting.scaler.linear"]=true;dojo.provide("dojox.charting.scaler.linear");(function(){var _7f=3,dc=dojox.charting,dcs=dc.scaler,_80=dcs.common,_81=_80.findString,_82=_80.getNumericLabel;var _83=function(min,max,_84,_85,_86,_87,_88){_84=dojo.delegate(_84);if(!_85){if(_84.fixUpper=="major"){_84.fixUpper="minor";}if(_84.fixLower=="major"){_84.fixLower="minor";}}if(!_86){if(_84.fixUpper=="minor"){_84.fixUpper="micro";}if(_84.fixLower=="minor"){_84.fixLower="micro";}}if(!_87){if(_84.fixUpper=="micro"){_84.fixUpper="none";}if(_84.fixLower=="micro"){_84.fixLower="none";}}var _89=_81(_84.fixLower,["major"])?Math.floor(_84.min/_85)*_85:_81(_84.fixLower,["minor"])?Math.floor(_84.min/_86)*_86:_81(_84.fixLower,["micro"])?Math.floor(_84.min/_87)*_87:_84.min,_8a=_81(_84.fixUpper,["major"])?Math.ceil(_84.max/_85)*_85:_81(_84.fixUpper,["minor"])?Math.ceil(_84.max/_86)*_86:_81(_84.fixUpper,["micro"])?Math.ceil(_84.max/_87)*_87:_84.max;if(_84.useMin){min=_89;}if(_84.useMax){max=_8a;}var _8b=(!_85||_84.useMin&&_81(_84.fixLower,["major"]))?min:Math.ceil(min/_85)*_85,_8c=(!_86||_84.useMin&&_81(_84.fixLower,["major","minor"]))?min:Math.ceil(min/_86)*_86,_8d=(!_87||_84.useMin&&_81(_84.fixLower,["major","minor","micro"]))?min:Math.ceil(min/_87)*_87,_8e=!_85?0:(_84.useMax&&_81(_84.fixUpper,["major"])?Math.round((max-_8b)/_85):Math.floor((max-_8b)/_85))+1,_8f=!_86?0:(_84.useMax&&_81(_84.fixUpper,["major","minor"])?Math.round((max-_8c)/_86):Math.floor((max-_8c)/_86))+1,_90=!_87?0:(_84.useMax&&_81(_84.fixUpper,["major","minor","micro"])?Math.round((max-_8d)/_87):Math.floor((max-_8d)/_87))+1,_91=_86?Math.round(_85/_86):0,_92=_87?Math.round(_86/_87):0,_93=_85?Math.floor(Math.log(_85)/Math.LN10):0,_94=_86?Math.floor(Math.log(_86)/Math.LN10):0,_95=_88/(max-min);if(!isFinite(_95)){_95=1;}return {bounds:{lower:_89,upper:_8a,from:min,to:max,scale:_95,span:_88},major:{tick:_85,start:_8b,count:_8e,prec:_93},minor:{tick:_86,start:_8c,count:_8f,prec:_94},micro:{tick:_87,start:_8d,count:_90,prec:0},minorPerMajor:_91,microPerMinor:_92,scaler:dcs.linear};};dojo.mixin(dojox.charting.scaler.linear,{buildScaler:function(min,max,_96,_97){var h={fixUpper:"none",fixLower:"none",natural:false};if(_97){if("fixUpper" in _97){h.fixUpper=String(_97.fixUpper);}if("fixLower" in _97){h.fixLower=String(_97.fixLower);}if("natural" in _97){h.natural=Boolean(_97.natural);}}if("min" in _97){min=_97.min;}if("max" in _97){max=_97.max;}if(_97.includeZero){if(min>0){min=0;}if(max<0){max=0;}}h.min=min;h.useMin=true;h.max=max;h.useMax=true;if("from" in _97){min=_97.from;h.useMin=false;}if("to" in _97){max=_97.to;h.useMax=false;}if(max<=min){return _83(min,max,h,0,0,0,_96);}var mag=Math.floor(Math.log(max-min)/Math.LN10),_98=_97&&("majorTickStep" in _97)?_97.majorTickStep:Math.pow(10,mag),_99=0,_9a=0,_9b;if(_97&&("minorTickStep" in _97)){_99=_97.minorTickStep;}else{do{_99=_98/10;if(!h.natural||_99>0.9){_9b=_83(min,max,h,_98,_99,0,_96);if(_9b.bounds.scale*_9b.minor.tick>_7f){break;}}_99=_98/5;if(!h.natural||_99>0.9){_9b=_83(min,max,h,_98,_99,0,_96);if(_9b.bounds.scale*_9b.minor.tick>_7f){break;}}_99=_98/2;if(!h.natural||_99>0.9){_9b=_83(min,max,h,_98,_99,0,_96);if(_9b.bounds.scale*_9b.minor.tick>_7f){break;}}return _83(min,max,h,_98,0,0,_96);}while(false);}if(_97&&("microTickStep" in _97)){_9a=_97.microTickStep;_9b=_83(min,max,h,_98,_99,_9a,_96);}else{do{_9a=_99/10;if(!h.natural||_9a>0.9){_9b=_83(min,max,h,_98,_99,_9a,_96);if(_9b.bounds.scale*_9b.micro.tick>_7f){break;}}_9a=_99/5;if(!h.natural||_9a>0.9){_9b=_83(min,max,h,_98,_99,_9a,_96);if(_9b.bounds.scale*_9b.micro.tick>_7f){break;}}_9a=_99/2;if(!h.natural||_9a>0.9){_9b=_83(min,max,h,_98,_99,_9a,_96);if(_9b.bounds.scale*_9b.micro.tick>_7f){break;}}_9a=0;}while(false);}return _9a?_9b:_83(min,max,h,_98,_99,0,_96);},buildTicks:function(_9c,_9d){var _9e,_9f,_a0,_a1=_9c.major.start,_a2=_9c.minor.start,_a3=_9c.micro.start;if(_9d.microTicks&&_9c.micro.tick){_9e=_9c.micro.tick,_9f=_a3;}else{if(_9d.minorTicks&&_9c.minor.tick){_9e=_9c.minor.tick,_9f=_a2;}else{if(_9c.major.tick){_9e=_9c.major.tick,_9f=_a1;}else{return null;}}}var _a4=1/_9c.bounds.scale;if(_9c.bounds.to<=_9c.bounds.from||isNaN(_a4)||!isFinite(_a4)||_9e<=0||isNaN(_9e)||!isFinite(_9e)){return null;}var _a5=[],_a6=[],_a7=[];while(_9f<=_9c.bounds.to+_a4){if(Math.abs(_a1-_9f)<_9e/2){_a0={value:_a1};if(_9d.majorLabels){_a0.label=_82(_a1,_9c.major.prec,_9d);}_a5.push(_a0);_a1+=_9c.major.tick;_a2+=_9c.minor.tick;_a3+=_9c.micro.tick;}else{if(Math.abs(_a2-_9f)<_9e/2){if(_9d.minorTicks){_a0={value:_a2};if(_9d.minorLabels&&(_9c.minMinorStep<=_9c.minor.tick*_9c.bounds.scale)){_a0.label=_82(_a2,_9c.minor.prec,_9d);}_a6.push(_a0);}_a2+=_9c.minor.tick;_a3+=_9c.micro.tick;}else{if(_9d.microTicks){_a7.push({value:_a3});}_a3+=_9c.micro.tick;}}_9f+=_9e;}return {major:_a5,minor:_a6,micro:_a7};},getTransformerFromModel:function(_a8){var _a9=_a8.bounds.from,_aa=_a8.bounds.scale;return function(x){return (x-_a9)*_aa;};},getTransformerFromPlot:function(_ab){var _ac=_ab.bounds.from,_ad=_ab.bounds.scale;return function(x){return x/_ad+_ac;};}});})();}if(!dojo._hasResource["dojox.charting.axis2d.common"]){dojo._hasResource["dojox.charting.axis2d.common"]=true;dojo.provide("dojox.charting.axis2d.common");(function(){var g=dojox.gfx;var _ae=function(s){s.marginLeft="0px";s.marginTop="0px";s.marginRight="0px";s.marginBottom="0px";s.paddingLeft="0px";s.paddingTop="0px";s.paddingRight="0px";s.paddingBottom="0px";s.borderLeftWidth="0px";s.borderTopWidth="0px";s.borderRightWidth="0px";s.borderBottomWidth="0px";};var _af=function(n){if(n["getBoundingClientRect"]){var bcr=n.getBoundingClientRect();return bcr.width||(bcr.right-bcr.left);}else{return dojo.marginBox(n).w;}};dojo.mixin(dojox.charting.axis2d.common,{createText:{gfx:function(_b0,_b1,x,y,_b2,_b3,_b4,_b5){return _b1.createText({x:x,y:y,text:_b3,align:_b2}).setFont(_b4).setFill(_b5);},html:function(_b6,_b7,x,y,_b8,_b9,_ba,_bb,_bc){var p=dojo.doc.createElement("div"),s=p.style,_bd;_ae(s);s.font=_ba;p.innerHTML=String(_b9).replace(/\s/g,"&nbsp;");s.color=_bb;s.position="absolute";s.left="-10000px";dojo.body().appendChild(p);var _be=g.normalizedLength(g.splitFontString(_ba).size);if(!_bc){_bd=_af(p);}dojo.body().removeChild(p);s.position="relative";if(_bc){s.width=_bc+"px";switch(_b8){case "middle":s.textAlign="center";s.left=(x-_bc/2)+"px";break;case "end":s.textAlign="right";s.left=(x-_bc)+"px";break;default:s.left=x+"px";s.textAlign="left";break;}}else{switch(_b8){case "middle":s.left=Math.floor(x-_bd/2)+"px";break;case "end":s.left=Math.floor(x-_bd)+"px";break;default:s.left=Math.floor(x)+"px";break;}}s.top=Math.floor(y-_be)+"px";var _bf=dojo.doc.createElement("div"),w=_bf.style;_ae(w);w.width="0px";w.height="0px";_bf.appendChild(p);_b6.node.insertBefore(_bf,_b6.node.firstChild);return _bf;}}});})();}if(!dojo._hasResource["dojox.charting.axis2d.Base"]){dojo._hasResource["dojox.charting.axis2d.Base"]=true;dojo.provide("dojox.charting.axis2d.Base");dojo.declare("dojox.charting.axis2d.Base",dojox.charting.Element,{constructor:function(_c0,_c1){this.vertical=_c1&&_c1.vertical;},clear:function(){return this;},initialized:function(){return false;},calculate:function(min,max,_c2){return this;},getScaler:function(){return null;},getTicks:function(){return null;},getOffsets:function(){return {l:0,r:0,t:0,b:0};},render:function(dim,_c3){return this;}});}if(!dojo._hasResource["dojox.lang.utils"]){dojo._hasResource["dojox.lang.utils"]=true;dojo.provide("dojox.lang.utils");(function(){var _c4={},du=dojox.lang.utils;var _c5=function(o){if(dojo.isArray(o)){return dojo._toArray(o);}if(!dojo.isObject(o)||dojo.isFunction(o)){return o;}return dojo.delegate(o);};dojo.mixin(du,{coerceType:function(_c6,_c7){switch(typeof _c6){case "number":return Number(eval("("+_c7+")"));case "string":return String(_c7);case "boolean":return Boolean(eval("("+_c7+")"));}return eval("("+_c7+")");},updateWithObject:function(_c8,_c9,_ca){if(!_c9){return _c8;}for(var x in _c8){if(x in _c9&&!(x in _c4)){var t=_c8[x];if(t&&typeof t=="object"){du.updateWithObject(t,_c9[x],_ca);}else{_c8[x]=_ca?du.coerceType(t,_c9[x]):_c5(_c9[x]);}}}return _c8;},updateWithPattern:function(_cb,_cc,_cd,_ce){if(!_cc||!_cd){return _cb;}for(var x in _cd){if(x in _cc&&!(x in _c4)){_cb[x]=_ce?du.coerceType(_cd[x],_cc[x]):_c5(_cc[x]);}}return _cb;}});})();}if(!dojo._hasResource["dojox.charting.axis2d.Default"]){dojo._hasResource["dojox.charting.axis2d.Default"]=true;dojo.provide("dojox.charting.axis2d.Default");(function(){var dc=dojox.charting,df=dojox.lang.functional,du=dojox.lang.utils,g=dojox.gfx,lin=dc.scaler.linear,_cf=4;dojo.declare("dojox.charting.axis2d.Default",dojox.charting.axis2d.Base,{defaultParams:{vertical:false,fixUpper:"none",fixLower:"none",natural:false,leftBottom:true,includeZero:false,fixed:true,majorLabels:true,minorTicks:true,minorLabels:true,microTicks:false,htmlLabels:true},optionalParams:{min:0,max:1,from:0,to:1,majorTickStep:4,minorTickStep:2,microTickStep:1,labels:[],labelFunc:null,maxLabelSize:0,stroke:{},majorTick:{},minorTick:{},microTick:{},font:"",fontColor:""},constructor:function(_d0,_d1){this.opt=dojo.delegate(this.defaultParams,_d1);du.updateWithPattern(this.opt,_d1,this.optionalParams);},dependOnData:function(){return !("min" in this.opt)||!("max" in this.opt);},clear:function(){delete this.scaler;delete this.ticks;this.dirty=true;return this;},initialized:function(){return "scaler" in this&&!(this.dirty&&this.dependOnData());},setWindow:function(_d2,_d3){this.scale=_d2;this.offset=_d3;return this.clear();},getWindowScale:function(){return "scale" in this?this.scale:1;},getWindowOffset:function(){return "offset" in this?this.offset:0;},_groupLabelWidth:function(_d4,_d5){if(_d4[0]["text"]){_d4=df.map(_d4,function(_d6){return _d6.text;});}var s=_d4.join("<br>");return dojox.gfx._base._getTextBox(s,{font:_d5}).w||0;},calculate:function(min,max,_d7,_d8){if(this.initialized()){return this;}var o=this.opt;this.labels="labels" in o?o.labels:_d8;this.scaler=lin.buildScaler(min,max,_d7,o);var tsb=this.scaler.bounds;if("scale" in this){o.from=tsb.lower+this.offset;o.to=(tsb.upper-tsb.lower)/this.scale+o.from;if(!isFinite(o.from)||isNaN(o.from)||!isFinite(o.to)||isNaN(o.to)||o.to-o.from>=tsb.upper-tsb.lower){delete o.from;delete o.to;delete this.scale;delete this.offset;}else{if(o.from<tsb.lower){o.to+=tsb.lower-o.from;o.from=tsb.lower;}else{if(o.to>tsb.upper){o.from+=tsb.upper-o.to;o.to=tsb.upper;}}this.offset=o.from-tsb.lower;}this.scaler=lin.buildScaler(min,max,_d7,o);tsb=this.scaler.bounds;if(this.scale==1&&this.offset==0){delete this.scale;delete this.offset;}}var _d9=0,ta=this.chart.theme.axis,_da="font" in o?o.font:ta.font,_db=_da?g.normalizedLength(g.splitFontString(_da).size):0;if(this.vertical){if(_db){_d9=_db+_cf;}}else{if(_db){var _dc,i;if(o.labelFunc&&o.maxLabelSize){_dc=o.maxLabelSize;}else{if(this.labels){_dc=this._groupLabelWidth(this.labels,_da);}else{var _dd=Math.ceil(Math.log(Math.max(Math.abs(tsb.from),Math.abs(tsb.to)))/Math.LN10),t=[];if(tsb.from<0||tsb.to<0){t.push("-");}t.push(dojo.string.rep("9",_dd));var _de=Math.floor(Math.log(tsb.to-tsb.from)/Math.LN10);if(_de>0){t.push(".");for(i=0;i<_de;++i){t.push("9");}}_dc=dojox.gfx._base._getTextBox(t.join(""),{font:_da}).w;}}_d9=_dc+_cf;}}this.scaler.minMinorStep=_d9;this.ticks=lin.buildTicks(this.scaler,o);return this;},getScaler:function(){return this.scaler;},getTicks:function(){return this.ticks;},getOffsets:function(){var o=this.opt;var _df={l:0,r:0,t:0,b:0},_e0,a,b,c,d,gl=dc.scaler.common.getNumericLabel,_e1=0,ta=this.chart.theme.axis,_e2="font" in o?o.font:ta.font,_e3="majorTick" in o?o.majorTick:ta.majorTick,_e4="minorTick" in o?o.minorTick:ta.minorTick,_e5=_e2?g.normalizedLength(g.splitFontString(_e2).size):0,s=this.scaler;if(!s){return _df;}var ma=s.major,mi=s.minor;if(this.vertical){if(_e5){if(o.labelFunc&&o.maxLabelSize){_e0=o.maxLabelSize;}else{if(this.labels){_e0=this._groupLabelWidth(this.labels,_e2);}else{_e0=this._groupLabelWidth([gl(ma.start,ma.prec,o),gl(ma.start+ma.count*ma.tick,ma.prec,o),gl(mi.start,mi.prec,o),gl(mi.start+mi.count*mi.tick,mi.prec,o)],_e2);}}_e1=_e0+_cf;}_e1+=_cf+Math.max(_e3.length,_e4.length);_df[o.leftBottom?"l":"r"]=_e1;_df.t=_df.b=_e5/2;}else{if(_e5){_e1=_e5+_cf;}_e1+=_cf+Math.max(_e3.length,_e4.length);_df[o.leftBottom?"b":"t"]=_e1;if(_e5){if(o.labelFunc&&o.maxLabelSize){_e0=o.maxLabelSize;}else{if(this.labels){_e0=this._groupLabelWidth(this.labels,_e2);}else{_e0=this._groupLabelWidth([gl(ma.start,ma.prec,o),gl(ma.start+ma.count*ma.tick,ma.prec,o),gl(mi.start,mi.prec,o),gl(mi.start+mi.count*mi.tick,mi.prec,o)],_e2);}}_df.l=_df.r=_e0/2;}}if(_e0){this._cachedLabelWidth=_e0;}return _df;},render:function(dim,_e6){if(!this.dirty){return this;}var o=this.opt;var _e7,_e8,_e9,_ea,_eb,_ec,ta=this.chart.theme.axis,_ed="stroke" in o?o.stroke:ta.stroke,_ee="majorTick" in o?o.majorTick:ta.majorTick,_ef="minorTick" in o?o.minorTick:ta.minorTick,_f0="microTick" in o?o.microTick:ta.minorTick,_f1="font" in o?o.font:ta.font,_f2="fontColor" in o?o.fontColor:ta.fontColor,_f3=Math.max(_ee.length,_ef.length),_f4=_f1?g.normalizedLength(g.splitFontString(_f1).size):0;if(this.vertical){_e7={y:dim.height-_e6.b};_e8={y:_e6.t};_e9={x:0,y:-1};if(o.leftBottom){_e7.x=_e8.x=_e6.l;_ea={x:-1,y:0};_ec="end";}else{_e7.x=_e8.x=dim.width-_e6.r;_ea={x:1,y:0};_ec="start";}_eb={x:_ea.x*(_f3+_cf),y:_f4*0.4};}else{_e7={x:_e6.l};_e8={x:dim.width-_e6.r};_e9={x:1,y:0};_ec="middle";if(o.leftBottom){_e7.y=_e8.y=dim.height-_e6.b;_ea={x:0,y:1};_eb={y:_f3+_cf+_f4};}else{_e7.y=_e8.y=_e6.t;_ea={x:0,y:-1};_eb={y:-_f3-_cf};}_eb.x=0;}this.cleanGroup();try{var s=this.group,c=this.scaler,t=this.ticks,_f5,f=lin.getTransformerFromModel(this.scaler),_f6=(dojox.gfx.renderer=="canvas"),_f7=_f6||this.opt.htmlLabels&&!dojo.isIE&&!dojo.isOpera?"html":"gfx",dx=_ea.x*_ee.length,dy=_ea.y*_ee.length;s.createLine({x1:_e7.x,y1:_e7.y,x2:_e8.x,y2:_e8.y}).setStroke(_ed);dojo.forEach(t.major,function(_f8){var _f9=f(_f8.value),_fa,x=_e7.x+_e9.x*_f9,y=_e7.y+_e9.y*_f9;s.createLine({x1:x,y1:y,x2:x+dx,y2:y+dy}).setStroke(_ee);if(_f8.label){_fa=dc.axis2d.common.createText[_f7](this.chart,s,x+_eb.x,y+_eb.y,_ec,_f8.label,_f1,_f2,this._cachedLabelWidth);if(_f7=="html"){this.htmlElements.push(_fa);}}},this);dx=_ea.x*_ef.length;dy=_ea.y*_ef.length;_f5=c.minMinorStep<=c.minor.tick*c.bounds.scale;dojo.forEach(t.minor,function(_fb){var _fc=f(_fb.value),_fd,x=_e7.x+_e9.x*_fc,y=_e7.y+_e9.y*_fc;s.createLine({x1:x,y1:y,x2:x+dx,y2:y+dy}).setStroke(_ef);if(_f5&&_fb.label){_fd=dc.axis2d.common.createText[_f7](this.chart,s,x+_eb.x,y+_eb.y,_ec,_fb.label,_f1,_f2,this._cachedLabelWidth);if(_f7=="html"){this.htmlElements.push(_fd);}}},this);dx=_ea.x*_f0.length;dy=_ea.y*_f0.length;dojo.forEach(t.micro,function(_fe){var _ff=f(_fe.value),elem,x=_e7.x+_e9.x*_ff,y=_e7.y+_e9.y*_ff;s.createLine({x1:x,y1:y,x2:x+dx,y2:y+dy}).setStroke(_f0);},this);}catch(e){}this.dirty=false;return this;}});})();}if(!dojo._hasResource["dojox.charting.plot2d.common"]){dojo._hasResource["dojox.charting.plot2d.common"]=true;dojo.provide("dojox.charting.plot2d.common");(function(){var df=dojox.lang.functional,dc=dojox.charting.plot2d.common;dojo.mixin(dojox.charting.plot2d.common,{makeStroke:function(_100){if(!_100){return _100;}if(typeof _100=="string"||_100 instanceof dojo.Color){_100={color:_100};}return dojox.gfx.makeParameters(dojox.gfx.defaultStroke,_100);},augmentColor:function(_101,_102){var t=new dojo.Color(_101),c=new dojo.Color(_102);c.a=t.a;return c;},augmentStroke:function(_103,_104){var s=dc.makeStroke(_103);if(s){s.color=dc.augmentColor(s.color,_104);}return s;},augmentFill:function(fill,_105){var fc,c=new dojo.Color(_105);if(typeof fill=="string"||fill instanceof dojo.Color){return dc.augmentColor(fill,_105);}return fill;},defaultStats:{hmin:Number.POSITIVE_INFINITY,hmax:Number.NEGATIVE_INFINITY,vmin:Number.POSITIVE_INFINITY,vmax:Number.NEGATIVE_INFINITY},collectSimpleStats:function(_106){var _107=dojo.clone(dc.defaultStats);for(var i=0;i<_106.length;++i){var run=_106[i];if(!run.data.length){continue;}if(typeof run.data[0]=="number"){var _108=_107.vmin,_109=_107.vmax;if(!("ymin" in run)||!("ymax" in run)){dojo.forEach(run.data,function(val,i){var x=i+1,y=val;if(isNaN(y)){y=0;}_107.hmin=Math.min(_107.hmin,x);_107.hmax=Math.max(_107.hmax,x);_107.vmin=Math.min(_107.vmin,y);_107.vmax=Math.max(_107.vmax,y);});}if("ymin" in run){_107.vmin=Math.min(_108,run.ymin);}if("ymax" in run){_107.vmax=Math.max(_109,run.ymax);}}else{var _10a=_107.hmin,_10b=_107.hmax,_108=_107.vmin,_109=_107.vmax;if(!("xmin" in run)||!("xmax" in run)||!("ymin" in run)||!("ymax" in run)){dojo.forEach(run.data,function(val,i){var x="x" in val?val.x:i+1,y=val.y;if(isNaN(x)){x=0;}if(isNaN(y)){y=0;}_107.hmin=Math.min(_107.hmin,x);_107.hmax=Math.max(_107.hmax,x);_107.vmin=Math.min(_107.vmin,y);_107.vmax=Math.max(_107.vmax,y);});}if("xmin" in run){_107.hmin=Math.min(_10a,run.xmin);}if("xmax" in run){_107.hmax=Math.max(_10b,run.xmax);}if("ymin" in run){_107.vmin=Math.min(_108,run.ymin);}if("ymax" in run){_107.vmax=Math.max(_109,run.ymax);}}}return _107;},calculateBarSize:function(_10c,opt,_10d){if(!_10d){_10d=1;}var gap=opt.gap,size=(_10c-2*gap)/_10d;if("minBarSize" in opt){size=Math.max(size,opt.minBarSize);}if("maxBarSize" in opt){size=Math.min(size,opt.maxBarSize);}size=Math.max(size,1);gap=(_10c-size*_10d)/2;return {size:size,gap:gap};},collectStackedStats:function(_10e){var _10f=dojo.clone(dc.defaultStats);if(_10e.length){_10f.hmin=Math.min(_10f.hmin,1);_10f.hmax=df.foldl(_10e,"seed, run -> Math.max(seed, run.data.length)",_10f.hmax);for(var i=0;i<_10f.hmax;++i){var v=_10e[0].data[i];if(isNaN(v)){v=0;}_10f.vmin=Math.min(_10f.vmin,v);for(var j=1;j<_10e.length;++j){var t=_10e[j].data[i];if(isNaN(t)){t=0;}v+=t;}_10f.vmax=Math.max(_10f.vmax,v);}}return _10f;},curve:function(a,_110){var arr=a.slice(0);if(_110=="x"){arr[arr.length]=arr[0];}var p=dojo.map(arr,function(item,i){if(i==0){return "M"+item.x+","+item.y;}if(!isNaN(_110)){var dx=item.x-arr[i-1].x,dy=arr[i-1].y;return "C"+(item.x-(_110-1)*(dx/_110))+","+dy+" "+(item.x-(dx/_110))+","+item.y+" "+item.x+","+item.y;}else{if(_110=="X"||_110=="x"||_110=="S"){var p0,p1=arr[i-1],p2=arr[i],p3;var bz1x,bz1y,bz2x,bz2y;var f=1/6;if(i==1){if(_110=="x"){p0=arr[arr.length-2];}else{p0=p1;}f=1/3;}else{p0=arr[i-2];}if(i==(arr.length-1)){if(_110=="x"){p3=arr[1];}else{p3=p2;}f=1/3;}else{p3=arr[i+1];}var p1p2=Math.sqrt((p2.x-p1.x)*(p2.x-p1.x)+(p2.y-p1.y)*(p2.y-p1.y));var p0p2=Math.sqrt((p2.x-p0.x)*(p2.x-p0.x)+(p2.y-p0.y)*(p2.y-p0.y));var p1p3=Math.sqrt((p3.x-p1.x)*(p3.x-p1.x)+(p3.y-p1.y)*(p3.y-p1.y));var _111=p0p2*f;var _112=p1p3*f;if(_111>p1p2/2&&_112>p1p2/2){_111=p1p2/2;_112=p1p2/2;}else{if(_111>p1p2/2){_111=p1p2/2;_112=p1p2/2*p1p3/p0p2;}else{if(_112>p1p2/2){_112=p1p2/2;_111=p1p2/2*p0p2/p1p3;}}}if(_110=="S"){if(p0==p1){_111=0;}if(p2==p3){_112=0;}}bz1x=p1.x+_111*(p2.x-p0.x)/p0p2;bz1y=p1.y+_111*(p2.y-p0.y)/p0p2;bz2x=p2.x-_112*(p3.x-p1.x)/p1p3;bz2y=p2.y-_112*(p3.y-p1.y)/p1p3;}}return "C"+(bz1x+","+bz1y+" "+bz2x+","+bz2y+" "+p2.x+","+p2.y);});return p.join(" ");}});})();}if(!dojo._hasResource["dojox.charting.scaler.primitive"]){dojo._hasResource["dojox.charting.scaler.primitive"]=true;dojo.provide("dojox.charting.scaler.primitive");dojox.charting.scaler.primitive={buildScaler:function(min,max,span,_113){return {bounds:{lower:min,upper:max,from:min,to:max,scale:span/(max-min),span:span},scaler:dojox.charting.scaler.primitive};},buildTicks:function(_114,_115){return {major:[],minor:[],micro:[]};},getTransformerFromModel:function(_116){var _117=_116.bounds.from,_118=_116.bounds.scale;return function(x){return (x-_117)*_118;};},getTransformerFromPlot:function(_119){var _11a=_119.bounds.from,_11b=_119.bounds.scale;return function(x){return x/_11b+_11a;};}};}if(!dojo._hasResource["dojox.charting.plot2d.Base"]){dojo._hasResource["dojox.charting.plot2d.Base"]=true;dojo.provide("dojox.charting.plot2d.Base");dojo.declare("dojox.charting.plot2d.Base",dojox.charting.Element,{destroy:function(){this.resetEvents();this.inherited(arguments);},clear:function(){this.series=[];this._hAxis=null;this._vAxis=null;this.dirty=true;return this;},setAxis:function(axis){if(axis){this[axis.vertical?"_vAxis":"_hAxis"]=axis;}return this;},addSeries:function(run){this.series.push(run);return this;},calculateAxes:function(dim){return this;},isDirty:function(){return this.dirty||this._hAxis&&this._hAxis.dirty||this._vAxis&&this._vAxis.dirty;},render:function(dim,_11c){return this;},getRequiredColors:function(){return this.series.length;},plotEvent:function(o){},connect:function(_11d,_11e){this.dirty=true;return dojo.connect(this,"plotEvent",_11d,_11e);},events:function(){var ls=this.plotEvent._listeners;if(!ls||!ls.length){return false;}for(var i in ls){if(!(i in Array.prototype)){return true;}}return false;},resetEvents:function(){this.plotEvent({type:"onplotreset",plot:this});},_calc:function(dim,_11f){if(this._hAxis){if(!this._hAxis.initialized()){this._hAxis.calculate(_11f.hmin,_11f.hmax,dim.width);}this._hScaler=this._hAxis.getScaler();}else{this._hScaler=dojox.charting.scaler.primitive.buildScaler(_11f.hmin,_11f.hmax,dim.width);}if(this._vAxis){if(!this._vAxis.initialized()){this._vAxis.calculate(_11f.vmin,_11f.vmax,dim.height);}this._vScaler=this._vAxis.getScaler();}else{this._vScaler=dojox.charting.scaler.primitive.buildScaler(_11f.vmin,_11f.vmax,dim.height);}},_connectEvents:function(_120,o){_120.connect("onmouseover",this,function(e){o.type="onmouseover";o.event=e;this.plotEvent(o);});_120.connect("onmouseout",this,function(e){o.type="onmouseout";o.event=e;this.plotEvent(o);});_120.connect("onclick",this,function(e){o.type="onclick";o.event=e;this.plotEvent(o);});}});}if(!dojo._hasResource["dojox.charting.plot2d.Default"]){dojo._hasResource["dojox.charting.plot2d.Default"]=true;dojo.provide("dojox.charting.plot2d.Default");(function(){var df=dojox.lang.functional,du=dojox.lang.utils,dc=dojox.charting.plot2d.common,_121=df.lambda("item.purgeGroup()");dojo.declare("dojox.charting.plot2d.Default",dojox.charting.plot2d.Base,{defaultParams:{hAxis:"x",vAxis:"y",lines:true,areas:false,markers:false,shadows:0,tension:0},optionalParams:{},constructor:function(_122,_123){this.opt=dojo.clone(this.defaultParams);du.updateWithObject(this.opt,_123);this.series=[];this.hAxis=this.opt.hAxis;this.vAxis=this.opt.vAxis;},calculateAxes:function(dim){this._calc(dim,dc.collectSimpleStats(this.series));return this;},render:function(dim,_124){this.dirty=this.isDirty();if(this.dirty){dojo.forEach(this.series,_121);this.cleanGroup();var s=this.group;df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,_125,_126,_127,_128,_129=this.events();this.resetEvents();for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){continue;}run.cleanGroup();if(!run.data.length){run.dirty=false;continue;}var s=run.group,_12a,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler);if(typeof run.data[0]=="number"){_12a=dojo.map(run.data,function(v,i){return {x:ht(i+1)+_124.l,y:dim.height-_124.b-vt(v)};},this);}else{_12a=dojo.map(run.data,function(v,i){return {x:ht(v.x)+_124.l,y:dim.height-_124.b-vt(v.y)};},this);}if(!run.fill||!run.stroke){_127=run.dyn.color=new dojo.Color(t.next("color"));}var _12b=this.opt.tension?dc.curve(_12a,this.opt.tension):"";if(this.opt.areas){var fill=run.fill?run.fill:dc.augmentFill(t.series.fill,_127);var _12c=dojo.clone(_12a);if(this.opt.tension){var _12d="L"+_12c[_12c.length-1].x+","+(dim.height-_124.b)+" L"+_12c[0].x+","+(dim.height-_124.b)+" L"+_12c[0].x+","+_12c[0].y;run.dyn.fill=s.createPath(_12b+" "+_12d).setFill(fill).getFill();}else{_12c.push({x:_12a[_12a.length-1].x,y:dim.height-_124.b});_12c.push({x:_12a[0].x,y:dim.height-_124.b});_12c.push(_12a[0]);run.dyn.fill=s.createPolyline(_12c).setFill(fill).getFill();}}if(this.opt.lines||this.opt.markers){_125=run.dyn.stroke=run.stroke?dc.makeStroke(run.stroke):dc.augmentStroke(t.series.stroke,_127);if(run.outline||t.series.outline){_126=run.dyn.outline=dc.makeStroke(run.outline?run.outline:t.series.outline);_126.width=2*_126.width+_125.width;}}if(this.opt.markers){_128=run.dyn.marker=run.marker?run.marker:t.next("marker");}var _12e=null,_12f=null,_130=null;if(this.opt.shadows&&_125){var sh=this.opt.shadows,_131=new dojo.Color([0,0,0,0.3]),_132=dojo.map(_12a,function(c){return {x:c.x+sh.dx,y:c.y+sh.dy};}),_133=dojo.clone(_126?_126:_125);_133.color=_131;_133.width+=sh.dw?sh.dw:0;if(this.opt.lines){if(this.opt.tension){run.dyn.shadow=s.createPath(dc.curve(_132,this.opt.tension)).setStroke(_133).getStroke();}else{run.dyn.shadow=s.createPolyline(_132).setStroke(_133).getStroke();}}if(this.opt.markers){_130=dojo.map(_132,function(c){return s.createPath("M"+c.x+" "+c.y+" "+_128).setStroke(_133).setFill(_131);},this);}}if(this.opt.lines){if(_126){if(this.opt.tension){run.dyn.outline=s.createPath(_12b).setStroke(_126).getStroke();}else{run.dyn.outline=s.createPolyline(_12a).setStroke(_126).getStroke();}}if(this.opt.tension){run.dyn.stroke=s.createPath(_12b).setStroke(_125).getStroke();}else{run.dyn.stroke=s.createPolyline(_12a).setStroke(_125).getStroke();}}if(this.opt.markers){_12e=new Array(_12a.length);_12f=new Array(_12a.length);dojo.forEach(_12a,function(c,i){var path="M"+c.x+" "+c.y+" "+_128;if(_126){_12f[i]=s.createPath(path).setStroke(_126);}_12e[i]=s.createPath(path).setStroke(_125).setFill(_125.color);},this);if(_129){dojo.forEach(_12e,function(s,i){var o={element:"marker",index:i,run:run,plot:this,hAxis:this.hAxis||null,vAxis:this.vAxis||null,shape:s,outline:_12f[i]||null,shadow:_130&&_130[i]||null,cx:_12a[i].x,cy:_12a[i].y};if(typeof run.data[0]=="number"){o.x=i+1;o.y=run.data[i];}else{o.x=run.data[i].x;o.y=run.data[i].y;}this._connectEvents(s,o);},this);}}run.dirty=false;}this.dirty=false;return this;}});})();}if(!dojo._hasResource["dojox.charting.plot2d.Lines"]){dojo._hasResource["dojox.charting.plot2d.Lines"]=true;dojo.provide("dojox.charting.plot2d.Lines");dojo.declare("dojox.charting.plot2d.Lines",dojox.charting.plot2d.Default,{constructor:function(){this.opt.lines=true;}});}if(!dojo._hasResource["dojox.charting.plot2d.Areas"]){dojo._hasResource["dojox.charting.plot2d.Areas"]=true;dojo.provide("dojox.charting.plot2d.Areas");dojo.declare("dojox.charting.plot2d.Areas",dojox.charting.plot2d.Default,{constructor:function(){this.opt.lines=true;this.opt.areas=true;}});}if(!dojo._hasResource["dojox.charting.plot2d.Markers"]){dojo._hasResource["dojox.charting.plot2d.Markers"]=true;dojo.provide("dojox.charting.plot2d.Markers");dojo.declare("dojox.charting.plot2d.Markers",dojox.charting.plot2d.Default,{constructor:function(){this.opt.markers=true;}});}if(!dojo._hasResource["dojox.charting.plot2d.MarkersOnly"]){dojo._hasResource["dojox.charting.plot2d.MarkersOnly"]=true;dojo.provide("dojox.charting.plot2d.MarkersOnly");dojo.declare("dojox.charting.plot2d.MarkersOnly",dojox.charting.plot2d.Default,{constructor:function(){this.opt.lines=false;this.opt.markers=true;}});}if(!dojo._hasResource["dojox.charting.plot2d.Scatter"]){dojo._hasResource["dojox.charting.plot2d.Scatter"]=true;dojo.provide("dojox.charting.plot2d.Scatter");dojo.declare("dojox.charting.plot2d.Scatter",dojox.charting.plot2d.Default,{constructor:function(){this.opt.lines=false;this.opt.markers=true;}});}if(!dojo._hasResource["dojox.lang.functional.sequence"]){dojo._hasResource["dojox.lang.functional.sequence"]=true;dojo.provide("dojox.lang.functional.sequence");(function(){var d=dojo,df=dojox.lang.functional;d.mixin(df,{repeat:function(n,f,z,o){o=o||d.global;f=df.lambda(f);var t=new Array(n),i=1;t[0]=z;for(;i<n;t[i]=z=f.call(o,z),++i){}return t;},until:function(pr,f,z,o){o=o||d.global;f=df.lambda(f);pr=df.lambda(pr);var t=[];for(;!pr.call(o,z);t.push(z),z=f.call(o,z)){}return t;}});})();}if(!dojo._hasResource["dojox.charting.plot2d.Stacked"]){dojo._hasResource["dojox.charting.plot2d.Stacked"]=true;dojo.provide("dojox.charting.plot2d.Stacked");(function(){var df=dojox.lang.functional,dc=dojox.charting.plot2d.common,_134=df.lambda("item.purgeGroup()");dojo.declare("dojox.charting.plot2d.Stacked",dojox.charting.plot2d.Default,{calculateAxes:function(dim){var _135=dc.collectStackedStats(this.series);this._maxRunLength=_135.hmax;this._calc(dim,_135);return this;},render:function(dim,_136){if(this._maxRunLength<=0){return this;}var acc=df.repeat(this._maxRunLength,"-> 0",0);for(var i=0;i<this.series.length;++i){var run=this.series[i];for(var j=0;j<run.data.length;++j){var v=run.data[j];if(isNaN(v)){v=0;}acc[j]+=v;}}this.dirty=this.isDirty();if(this.dirty){dojo.forEach(this.series,_134);this.cleanGroup();var s=this.group;df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,_137,_138,_139,_13a,_13b=this.events(),ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler);this.resetEvents();for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){continue;}run.cleanGroup();var s=run.group,_13c=dojo.map(acc,function(v,i){return {x:ht(i+1)+_136.l,y:dim.height-_136.b-vt(v)};},this);if(!run.fill||!run.stroke){_139=new dojo.Color(t.next("color"));}var _13d=this.opt.tension?dc.curve(_13c,this.opt.tension):"";if(this.opt.areas){var _13e=dojo.clone(_13c);var fill=run.fill?run.fill:dc.augmentFill(t.series.fill,_139);if(this.opt.tension){var p=dc.curve(_13e,this.opt.tension);p+=" L"+_13c[_13c.length-1].x+","+(dim.height-_136.b)+" L"+_13c[0].x+","+(dim.height-_136.b)+" L"+_13c[0].x+","+_13c[0].y;run.dyn.fill=s.createPath(p).setFill(fill).getFill();}else{_13e.push({x:_13c[_13c.length-1].x,y:dim.height-_136.b});_13e.push({x:_13c[0].x,y:dim.height-_136.b});_13e.push(_13c[0]);run.dyn.fill=s.createPolyline(_13e).setFill(fill).getFill();}}if(this.opt.lines||this.opt.markers){_137=run.stroke?dc.makeStroke(run.stroke):dc.augmentStroke(t.series.stroke,_139);if(run.outline||t.series.outline){_138=dc.makeStroke(run.outline?run.outline:t.series.outline);_138.width=2*_138.width+_137.width;}}if(this.opt.markers){_13a=run.dyn.marker=run.marker?run.marker:t.next("marker");}var _13f,_140,_141;if(this.opt.shadows&&_137){var sh=this.opt.shadows,_142=new dojo.Color([0,0,0,0.3]),_143=dojo.map(_13c,function(c){return {x:c.x+sh.dx,y:c.y+sh.dy};}),_144=dojo.clone(_138?_138:_137);_144.color=_142;_144.width+=sh.dw?sh.dw:0;if(this.opt.lines){if(this.opt.tension){run.dyn.shadow=s.createPath(dc.curve(_143,this.opt.tension)).setStroke(_144).getStroke();}else{run.dyn.shadow=s.createPolyline(_143).setStroke(_144).getStroke();}}if(this.opt.markers){_141=dojo.map(_143,function(c){return s.createPath("M"+c.x+" "+c.y+" "+_13a).setStroke(_144).setFill(_142);},this);}}if(this.opt.lines){if(_138){if(this.opt.tension){run.dyn.outline=s.createPath(_13d).setStroke(_138).getStroke();}else{run.dyn.outline=s.createPolyline(_13c).setStroke(_138).getStroke();}}if(this.opt.tension){run.dyn.stroke=s.createPath(_13d).setStroke(_137).getStroke();}else{run.dyn.stroke=s.createPolyline(_13c).setStroke(_137).getStroke();}}if(this.opt.markers){_13f=new Array(_13c.length);_140=new Array(_13c.length);dojo.forEach(_13c,function(c,i){var path="M"+c.x+" "+c.y+" "+_13a;if(_138){_140[i]=s.createPath(path).setStroke(_138);}_13f[i]=s.createPath(path).setStroke(_137).setFill(_137.color);},this);if(_13b){dojo.forEach(_13f,function(s,i){var o={element:"marker",index:i,run:run,plot:this,hAxis:this.hAxis||null,vAxis:this.vAxis||null,shape:s,outline:_140[i]||null,shadow:_141&&_141[i]||null,cx:_13c[i].x,cy:_13c[i].y,x:i+1,y:run.data[i]};this._connectEvents(s,o);},this);}}run.dirty=false;for(var j=0;j<run.data.length;++j){var v=run.data[j];if(isNaN(v)){v=0;}acc[j]-=v;}}this.dirty=false;return this;}});})();}if(!dojo._hasResource["dojox.charting.plot2d.StackedLines"]){dojo._hasResource["dojox.charting.plot2d.StackedLines"]=true;dojo.provide("dojox.charting.plot2d.StackedLines");dojo.declare("dojox.charting.plot2d.StackedLines",dojox.charting.plot2d.Stacked,{constructor:function(){this.opt.lines=true;}});}if(!dojo._hasResource["dojox.charting.plot2d.StackedAreas"]){dojo._hasResource["dojox.charting.plot2d.StackedAreas"]=true;dojo.provide("dojox.charting.plot2d.StackedAreas");dojo.declare("dojox.charting.plot2d.StackedAreas",dojox.charting.plot2d.Stacked,{constructor:function(){this.opt.lines=true;this.opt.areas=true;}});}if(!dojo._hasResource["dojox.gfx.fx"]){dojo._hasResource["dojox.gfx.fx"]=true;dojo.provide("dojox.gfx.fx");(function(){var d=dojo,g=dojox.gfx,m=g.matrix;var _145=function(_146,end){this.start=_146,this.end=end;};d.extend(_145,{getValue:function(r){return (this.end-this.start)*r+this.start;}});var _147=function(_148,end,_149){this.start=_148,this.end=end;this.units=_149;};d.extend(_147,{getValue:function(r){return (this.end-this.start)*r+this.start+this.units;}});var _14a=function(_14b,end){this.start=_14b,this.end=end;this.temp=new dojo.Color();};d.extend(_14a,{getValue:function(r){return d.blendColors(this.start,this.end,r,this.temp);}});var _14c=function(_14d){this.values=_14d;this.length=_14d.length;};d.extend(_14c,{getValue:function(r){return this.values[Math.min(Math.floor(r*this.length),this.length-1)];}});var _14e=function(_14f,def){this.values=_14f;this.def=def?def:{};};d.extend(_14e,{getValue:function(r){var ret=dojo.clone(this.def);for(var i in this.values){ret[i]=this.values[i].getValue(r);}return ret;}});var _150=function(_151,_152){this.stack=_151;this.original=_152;};d.extend(_150,{getValue:function(r){var ret=[];dojo.forEach(this.stack,function(t){if(t instanceof m.Matrix2D){ret.push(t);return;}if(t.name=="original"&&this.original){ret.push(this.original);return;}if(!(t.name in m)){return;}var f=m[t.name];if(typeof f!="function"){ret.push(f);return;}var val=dojo.map(t.start,function(v,i){return (t.end[i]-v)*r+v;}),_153=f.apply(m,val);if(_153 instanceof m.Matrix2D){ret.push(_153);}},this);return ret;}});var _154=new d.Color(0,0,0,0);var _155=function(prop,obj,name,def){if(prop.values){return new _14c(prop.values);}var _156,_157,end;if(prop.start){_157=g.normalizeColor(prop.start);}else{_157=_156=obj?(name?obj[name]:obj):def;}if(prop.end){end=g.normalizeColor(prop.end);}else{if(!_156){_156=obj?(name?obj[name]:obj):def;}end=_156;}return new _14a(_157,end);};var _158=function(prop,obj,name,def){if(prop.values){return new _14c(prop.values);}var _159,_15a,end;if(prop.start){_15a=prop.start;}else{_15a=_159=obj?obj[name]:def;}if(prop.end){end=prop.end;}else{if(typeof _159!="number"){_159=obj?obj[name]:def;}end=_159;}return new _145(_15a,end);};g.fx.animateStroke=function(args){if(!args.easing){args.easing=d._defaultEasing;}var anim=new d.Animation(args),_15b=args.shape,_15c;d.connect(anim,"beforeBegin",anim,function(){_15c=_15b.getStroke();var prop=args.color,_15d={},_15e,_15f,end;if(prop){_15d.color=_155(prop,_15c,"color",_154);}prop=args.style;if(prop&&prop.values){_15d.style=new _14c(prop.values);}prop=args.width;if(prop){_15d.width=_158(prop,_15c,"width",1);}prop=args.cap;if(prop&&prop.values){_15d.cap=new _14c(prop.values);}prop=args.join;if(prop){if(prop.values){_15d.join=new _14c(prop.values);}else{_15f=prop.start?prop.start:(_15c&&_15c.join||0);end=prop.end?prop.end:(_15c&&_15c.join||0);if(typeof _15f=="number"&&typeof end=="number"){_15d.join=new _145(_15f,end);}}}this.curve=new _14e(_15d,_15c);});d.connect(anim,"onAnimate",_15b,"setStroke");return anim;};g.fx.animateFill=function(args){if(!args.easing){args.easing=d._defaultEasing;}var anim=new d.Animation(args),_160=args.shape,fill;d.connect(anim,"beforeBegin",anim,function(){fill=_160.getFill();var prop=args.color,_161={};if(prop){this.curve=_155(prop,fill,"",_154);}});d.connect(anim,"onAnimate",_160,"setFill");return anim;};g.fx.animateFont=function(args){if(!args.easing){args.easing=d._defaultEasing;}var anim=new d.Animation(args),_162=args.shape,font;d.connect(anim,"beforeBegin",anim,function(){font=_162.getFont();var prop=args.style,_163={},_164,_165,end;if(prop&&prop.values){_163.style=new _14c(prop.values);}prop=args.variant;if(prop&&prop.values){_163.variant=new _14c(prop.values);}prop=args.weight;if(prop&&prop.values){_163.weight=new _14c(prop.values);}prop=args.family;if(prop&&prop.values){_163.family=new _14c(prop.values);}prop=args.size;if(prop&&prop.units){_165=parseFloat(prop.start?prop.start:(_162.font&&_162.font.size||"0"));end=parseFloat(prop.end?prop.end:(_162.font&&_162.font.size||"0"));_163.size=new _147(_165,end,prop.units);}this.curve=new _14e(_163,font);});d.connect(anim,"onAnimate",_162,"setFont");return anim;};g.fx.animateTransform=function(args){if(!args.easing){args.easing=d._defaultEasing;}var anim=new d.Animation(args),_166=args.shape,_167;d.connect(anim,"beforeBegin",anim,function(){_167=_166.getTransform();this.curve=new _150(args.transform,_167);});d.connect(anim,"onAnimate",_166,"setTransform");return anim;};})();}if(!dojo._hasResource["dojox.charting.plot2d.Columns"]){dojo._hasResource["dojox.charting.plot2d.Columns"]=true;dojo.provide("dojox.charting.plot2d.Columns");(function(){var df=dojox.lang.functional,du=dojox.lang.utils,dc=dojox.charting.plot2d.common,_168=df.lambda("item.purgeGroup()");dojo.declare("dojox.charting.plot2d.Columns",dojox.charting.plot2d.Base,{defaultParams:{hAxis:"x",vAxis:"y",gap:0,shadows:null,animate:null},optionalParams:{minBarSize:1,maxBarSize:1},constructor:function(_169,_16a){this.opt=dojo.clone(this.defaultParams);du.updateWithObject(this.opt,_16a);du.updateWithPattern(this.opt,_16a,this.optionalParams);this.series=[];this.hAxis=this.opt.hAxis;this.vAxis=this.opt.vAxis;this.animate=this.opt.animate;},calculateAxes:function(dim){var _16b=dc.collectSimpleStats(this.series);_16b.hmin-=0.5;_16b.hmax+=0.5;this._calc(dim,_16b);return this;},render:function(dim,_16c){this.dirty=this.isDirty();if(this.dirty){dojo.forEach(this.series,_168);this.cleanGroup();var s=this.group;df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,_16d,_16e,fill,f,gap,_16f,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),_170=Math.max(0,this._vScaler.bounds.lower),_171=vt(_170),_172=this.events();f=dc.calculateBarSize(this._hScaler.bounds.scale,this.opt);gap=f.gap;_16f=f.size;this.resetEvents();for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){continue;}run.cleanGroup();var s=run.group;if(!run.fill||!run.stroke){_16d=run.dyn.color=new dojo.Color(t.next("color"));}_16e=run.stroke?run.stroke:dc.augmentStroke(t.series.stroke,_16d);fill=run.fill?run.fill:dc.augmentFill(t.series.fill,_16d);for(var j=0;j<run.data.length;++j){var _173=run.data[j],v=typeof _173=="number"?_173:_173.y,vv=vt(v),_174=vv-_171,h=Math.abs(_174),_175=_16d,_176=fill,_177=_16e;if(typeof _173!="number"){if(_173.color){_175=new dojo.Color(_173.color);}if("fill" in _173){_176=_173.fill;}else{if(_173.color){_176=dc.augmentFill(t.series.fill,_175);}}if("stroke" in _173){_177=_173.stroke;}else{if(_173.color){_177=dc.augmentStroke(t.series.stroke,_175);}}}if(_16f>=1&&h>=1){var _178=s.createRect({x:_16c.l+ht(j+0.5)+gap,y:dim.height-_16c.b-(v>_170?vv:_171),width:_16f,height:h}).setFill(_176).setStroke(_177);run.dyn.fill=_178.getFill();run.dyn.stroke=_178.getStroke();if(_172){var o={element:"column",index:j,run:run,plot:this,hAxis:this.hAxis||null,vAxis:this.vAxis||null,shape:_178,x:j+0.5,y:v};this._connectEvents(_178,o);}if(this.animate){this._animateColumn(_178,dim.height-_16c.b-_171,h);}}}run.dirty=false;}this.dirty=false;return this;},_animateColumn:function(_179,_17a,_17b){dojox.gfx.fx.animateTransform(dojo.delegate({shape:_179,duration:1200,transform:[{name:"translate",start:[0,_17a-(_17a/_17b)],end:[0,0]},{name:"scale",start:[1,1/_17b],end:[1,1]},{name:"original"}]},this.animate)).play();}});})();}if(!dojo._hasResource["dojox.charting.plot2d.StackedColumns"]){dojo._hasResource["dojox.charting.plot2d.StackedColumns"]=true;dojo.provide("dojox.charting.plot2d.StackedColumns");(function(){var df=dojox.lang.functional,dc=dojox.charting.plot2d.common,_17c=df.lambda("item.purgeGroup()");dojo.declare("dojox.charting.plot2d.StackedColumns",dojox.charting.plot2d.Columns,{calculateAxes:function(dim){var _17d=dc.collectStackedStats(this.series);this._maxRunLength=_17d.hmax;_17d.hmin-=0.5;_17d.hmax+=0.5;this._calc(dim,_17d);return this;},render:function(dim,_17e){if(this._maxRunLength<=0){return this;}var acc=df.repeat(this._maxRunLength,"-> 0",0);for(var i=0;i<this.series.length;++i){var run=this.series[i];for(var j=0;j<run.data.length;++j){var _17f=run.data[j],v=typeof _17f=="number"?_17f:_17f.y;if(isNaN(v)){v=0;}acc[j]+=v;}}this.dirty=this.isDirty();if(this.dirty){dojo.forEach(this.series,_17c);this.cleanGroup();var s=this.group;df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,_180,_181,fill,f,gap,_182,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),_183=this.events();f=dc.calculateBarSize(this._hScaler.bounds.scale,this.opt);gap=f.gap;_182=f.size;this.resetEvents();for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){continue;}run.cleanGroup();var s=run.group;if(!run.fill||!run.stroke){_180=run.dyn.color=new dojo.Color(t.next("color"));}_181=run.stroke?run.stroke:dc.augmentStroke(t.series.stroke,_180);fill=run.fill?run.fill:dc.augmentFill(t.series.fill,_180);for(var j=0;j<acc.length;++j){var v=acc[j],_184=vt(v),_17f=run.data[j],_185=_180,_186=fill,_187=_181;if(typeof _17f!="number"){if(_17f.color){_185=new dojo.Color(_17f.color);}if("fill" in _17f){_186=_17f.fill;}else{if(_17f.color){_186=dc.augmentFill(t.series.fill,_185);}}if("stroke" in _17f){_187=_17f.stroke;}else{if(_17f.color){_187=dc.augmentStroke(t.series.stroke,_185);}}}if(_182>=1&&_184>=1){var _188=s.createRect({x:_17e.l+ht(j+0.5)+gap,y:dim.height-_17e.b-vt(v),width:_182,height:_184}).setFill(_186).setStroke(_187);run.dyn.fill=_188.getFill();run.dyn.stroke=_188.getStroke();if(_183){var o={element:"column",index:j,run:run,plot:this,hAxis:this.hAxis||null,vAxis:this.vAxis||null,shape:_188,x:j+0.5,y:v};this._connectEvents(_188,o);}if(this.animate){this._animateColumn(_188,dim.height-_17e.b,_184);}}}run.dirty=false;for(var j=0;j<run.data.length;++j){var _17f=run.data[j],v=typeof _17f=="number"?_17f:_17f.y;if(isNaN(v)){v=0;}acc[j]-=v;}}this.dirty=false;return this;}});})();}if(!dojo._hasResource["dojox.charting.plot2d.ClusteredColumns"]){dojo._hasResource["dojox.charting.plot2d.ClusteredColumns"]=true;dojo.provide("dojox.charting.plot2d.ClusteredColumns");(function(){var df=dojox.lang.functional,dc=dojox.charting.plot2d.common,_189=df.lambda("item.purgeGroup()");dojo.declare("dojox.charting.plot2d.ClusteredColumns",dojox.charting.plot2d.Columns,{render:function(dim,_18a){this.dirty=this.isDirty();if(this.dirty){dojo.forEach(this.series,_189);this.cleanGroup();var s=this.group;df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,_18b,_18c,fill,f,gap,_18d,_18e,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),_18f=Math.max(0,this._vScaler.bounds.lower),_190=vt(_18f),_191=this.events();f=dc.calculateBarSize(this._hScaler.bounds.scale,this.opt,this.series.length);gap=f.gap;_18d=_18e=f.size;this.resetEvents();for(var i=0;i<this.series.length;++i){var run=this.series[i],_192=_18e*i;if(!this.dirty&&!run.dirty){continue;}run.cleanGroup();var s=run.group;if(!run.fill||!run.stroke){_18b=run.dyn.color=new dojo.Color(t.next("color"));}_18c=run.stroke?run.stroke:dc.augmentStroke(t.series.stroke,_18b);fill=run.fill?run.fill:dc.augmentFill(t.series.fill,_18b);for(var j=0;j<run.data.length;++j){var _193=run.data[j],v=typeof _193=="number"?_193:_193.y,vv=vt(v),_194=vv-_190,h=Math.abs(_194),_195=_18b,_196=fill,_197=_18c;if(typeof _193!="number"){if(_193.color){_195=new dojo.Color(_193.color);}if("fill" in _193){_196=_193.fill;}else{if(_193.color){_196=dc.augmentFill(t.series.fill,_195);}}if("stroke" in _193){_197=_193.stroke;}else{if(_193.color){_197=dc.augmentStroke(t.series.stroke,_195);}}}if(_18d>=1&&h>=1){var _198=s.createRect({x:_18a.l+ht(j+0.5)+gap+_192,y:dim.height-_18a.b-(v>_18f?vv:_190),width:_18d,height:h}).setFill(_196).setStroke(_197);run.dyn.fill=_198.getFill();run.dyn.stroke=_198.getStroke();if(_191){var o={element:"column",index:j,run:run,plot:this,hAxis:this.hAxis||null,vAxis:this.vAxis||null,shape:_198,x:j+0.5,y:v};this._connectEvents(_198,o);}if(this.animate){this._animateColumn(_198,dim.height-_18a.b-_190,h);}}}run.dirty=false;}this.dirty=false;return this;}});})();}if(!dojo._hasResource["dojox.charting.plot2d.Bars"]){dojo._hasResource["dojox.charting.plot2d.Bars"]=true;dojo.provide("dojox.charting.plot2d.Bars");(function(){var df=dojox.lang.functional,du=dojox.lang.utils,dc=dojox.charting.plot2d.common,_199=df.lambda("item.purgeGroup()");dojo.declare("dojox.charting.plot2d.Bars",dojox.charting.plot2d.Base,{defaultParams:{hAxis:"x",vAxis:"y",gap:0,shadows:null,animate:null},optionalParams:{minBarSize:1,maxBarSize:1},constructor:function(_19a,_19b){this.opt=dojo.clone(this.defaultParams);du.updateWithObject(this.opt,_19b);du.updateWithPattern(this.opt,_19b,this.optionalParams);this.series=[];this.hAxis=this.opt.hAxis;this.vAxis=this.opt.vAxis;this.animate=this.opt.animate;},calculateAxes:function(dim){var _19c=dc.collectSimpleStats(this.series),t;_19c.hmin-=0.5;_19c.hmax+=0.5;t=_19c.hmin,_19c.hmin=_19c.vmin,_19c.vmin=t;t=_19c.hmax,_19c.hmax=_19c.vmax,_19c.vmax=t;this._calc(dim,_19c);return this;},render:function(dim,_19d){this.dirty=this.isDirty();if(this.dirty){dojo.forEach(this.series,_199);this.cleanGroup();var s=this.group;df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,_19e,_19f,fill,f,gap,_1a0,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),_1a1=Math.max(0,this._hScaler.bounds.lower),_1a2=ht(_1a1),_1a3=this.events();f=dc.calculateBarSize(this._vScaler.bounds.scale,this.opt);gap=f.gap;_1a0=f.size;this.resetEvents();for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){continue;}run.cleanGroup();var s=run.group;if(!run.fill||!run.stroke){_19e=run.dyn.color=new dojo.Color(t.next("color"));}_19f=run.stroke?run.stroke:dc.augmentStroke(t.series.stroke,_19e);fill=run.fill?run.fill:dc.augmentFill(t.series.fill,_19e);for(var j=0;j<run.data.length;++j){var _1a4=run.data[j],v=typeof _1a4=="number"?_1a4:_1a4.y,hv=ht(v),_1a5=hv-_1a2,w=Math.abs(_1a5),_1a6=_19e,_1a7=fill,_1a8=_19f;if(typeof _1a4!="number"){if(_1a4.color){_1a6=new dojo.Color(_1a4.color);}if("fill" in _1a4){_1a7=_1a4.fill;}else{if(_1a4.color){_1a7=dc.augmentFill(t.series.fill,_1a6);}}if("stroke" in _1a4){_1a8=_1a4.stroke;}else{if(_1a4.color){_1a8=dc.augmentStroke(t.series.stroke,_1a6);}}}if(w>=1&&_1a0>=1){var _1a9=s.createRect({x:_19d.l+(v<_1a1?hv:_1a2),y:dim.height-_19d.b-vt(j+1.5)+gap,width:w,height:_1a0}).setFill(_1a7).setStroke(_1a8);run.dyn.fill=_1a9.getFill();run.dyn.stroke=_1a9.getStroke();if(_1a3){var o={element:"bar",index:j,run:run,plot:this,hAxis:this.hAxis||null,vAxis:this.vAxis||null,shape:_1a9,x:v,y:j+1.5};this._connectEvents(_1a9,o);}if(this.animate){this._animateBar(_1a9,_19d.l+_1a2,-w);}}}run.dirty=false;}this.dirty=false;return this;},_animateBar:function(_1aa,_1ab,_1ac){dojox.gfx.fx.animateTransform(dojo.delegate({shape:_1aa,duration:1200,transform:[{name:"translate",start:[_1ab-(_1ab/_1ac),0],end:[0,0]},{name:"scale",start:[1/_1ac,1],end:[1,1]},{name:"original"}]},this.animate)).play();}});})();}if(!dojo._hasResource["dojox.charting.plot2d.StackedBars"]){dojo._hasResource["dojox.charting.plot2d.StackedBars"]=true;dojo.provide("dojox.charting.plot2d.StackedBars");(function(){var df=dojox.lang.functional,dc=dojox.charting.plot2d.common,_1ad=df.lambda("item.purgeGroup()");dojo.declare("dojox.charting.plot2d.StackedBars",dojox.charting.plot2d.Bars,{calculateAxes:function(dim){var _1ae=dc.collectStackedStats(this.series),t;this._maxRunLength=_1ae.hmax;_1ae.hmin-=0.5;_1ae.hmax+=0.5;t=_1ae.hmin,_1ae.hmin=_1ae.vmin,_1ae.vmin=t;t=_1ae.hmax,_1ae.hmax=_1ae.vmax,_1ae.vmax=t;this._calc(dim,_1ae);return this;},render:function(dim,_1af){if(this._maxRunLength<=0){return this;}var acc=df.repeat(this._maxRunLength,"-> 0",0);for(var i=0;i<this.series.length;++i){var run=this.series[i];for(var j=0;j<run.data.length;++j){var _1b0=run.data[j],v=typeof _1b0=="number"?_1b0:_1b0.y;if(isNaN(v)){v=0;}acc[j]+=v;}}this.dirty=this.isDirty();if(this.dirty){dojo.forEach(this.series,_1ad);this.cleanGroup();var s=this.group;df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,_1b1,_1b2,fill,f,gap,_1b3,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),_1b4=this.events();f=dc.calculateBarSize(this._vScaler.bounds.scale,this.opt);gap=f.gap;_1b3=f.size;this.resetEvents();for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){continue;}run.cleanGroup();var s=run.group;if(!run.fill||!run.stroke){_1b1=run.dyn.color=new dojo.Color(t.next("color"));}_1b2=run.stroke?run.stroke:dc.augmentStroke(t.series.stroke,_1b1);fill=run.fill?run.fill:dc.augmentFill(t.series.fill,_1b1);for(var j=0;j<acc.length;++j){var v=acc[j],_1b5=ht(v),_1b0=run.data[j],_1b6=_1b1,_1b7=fill,_1b8=_1b2;if(typeof _1b0!="number"){if(_1b0.color){_1b6=new dojo.Color(_1b0.color);}if("fill" in _1b0){_1b7=_1b0.fill;}else{if(_1b0.color){_1b7=dc.augmentFill(t.series.fill,_1b6);}}if("stroke" in _1b0){_1b8=_1b0.stroke;}else{if(_1b0.color){_1b8=dc.augmentStroke(t.series.stroke,_1b6);}}}if(_1b5>=1&&_1b3>=1){var _1b9=s.createRect({x:_1af.l,y:dim.height-_1af.b-vt(j+1.5)+gap,width:_1b5,height:_1b3}).setFill(_1b7).setStroke(_1b8);run.dyn.fill=_1b9.getFill();run.dyn.stroke=_1b9.getStroke();if(_1b4){var o={element:"bar",index:j,run:run,plot:this,hAxis:this.hAxis||null,vAxis:this.vAxis||null,shape:_1b9,x:v,y:j+1.5};this._connectEvents(_1b9,o);}if(this.animate){this._animateBar(_1b9,_1af.l,-_1b5);}}}run.dirty=false;for(var j=0;j<run.data.length;++j){var _1b0=run.data[j],v=typeof _1b0=="number"?_1b0:_1b0.y;if(isNaN(v)){v=0;}acc[j]-=v;}}this.dirty=false;return this;}});})();}if(!dojo._hasResource["dojox.charting.plot2d.ClusteredBars"]){dojo._hasResource["dojox.charting.plot2d.ClusteredBars"]=true;dojo.provide("dojox.charting.plot2d.ClusteredBars");(function(){var df=dojox.lang.functional,dc=dojox.charting.plot2d.common,_1ba=df.lambda("item.purgeGroup()");dojo.declare("dojox.charting.plot2d.ClusteredBars",dojox.charting.plot2d.Bars,{render:function(dim,_1bb){this.dirty=this.isDirty();if(this.dirty){dojo.forEach(this.series,_1ba);this.cleanGroup();var s=this.group;df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,_1bc,_1bd,fill,f,gap,_1be,_1bf,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),_1c0=Math.max(0,this._hScaler.bounds.lower),_1c1=ht(_1c0),_1c2=this.events();f=dc.calculateBarSize(this._vScaler.bounds.scale,this.opt,this.series.length);gap=f.gap;_1be=_1bf=f.size;this.resetEvents();for(var i=this.series.length-1;i>=0;--i){var run=this.series[i],_1c3=_1bf*(this.series.length-i-1);if(!this.dirty&&!run.dirty){continue;}run.cleanGroup();var s=run.group;if(!run.fill||!run.stroke){_1bc=run.dyn.color=new dojo.Color(t.next("color"));}_1bd=run.stroke?run.stroke:dc.augmentStroke(t.series.stroke,_1bc);fill=run.fill?run.fill:dc.augmentFill(t.series.fill,_1bc);for(var j=0;j<run.data.length;++j){var _1c4=run.data[j],v=typeof _1c4=="number"?_1c4:_1c4.y,hv=ht(v),_1c5=hv-_1c1,w=Math.abs(_1c5),_1c6=_1bc,_1c7=fill,_1c8=_1bd;if(typeof _1c4!="number"){if(_1c4.color){_1c6=new dojo.Color(_1c4.color);}if("fill" in _1c4){_1c7=_1c4.fill;}else{if(_1c4.color){_1c7=dc.augmentFill(t.series.fill,_1c6);}}if("stroke" in _1c4){_1c8=_1c4.stroke;}else{if(_1c4.color){_1c8=dc.augmentStroke(t.series.stroke,_1c6);}}}if(w>=1&&_1be>=1){var _1c9=s.createRect({x:_1bb.l+(v<_1c0?hv:_1c1),y:dim.height-_1bb.b-vt(j+1.5)+gap+_1c3,width:w,height:_1be}).setFill(_1c7).setStroke(_1c8);run.dyn.fill=_1c9.getFill();run.dyn.stroke=_1c9.getStroke();if(_1c2){var o={element:"bar",index:j,run:run,plot:this,hAxis:this.hAxis||null,vAxis:this.vAxis||null,shape:_1c9,x:v,y:j+1.5};this._connectEvents(_1c9,o);}if(this.animate){this._animateBar(_1c9,_1bb.l+_1c1,-_1c5);}}}run.dirty=false;}this.dirty=false;return this;}});})();}if(!dojo._hasResource["dojox.charting.plot2d.Grid"]){dojo._hasResource["dojox.charting.plot2d.Grid"]=true;dojo.provide("dojox.charting.plot2d.Grid");(function(){var du=dojox.lang.utils;dojo.declare("dojox.charting.plot2d.Grid",dojox.charting.Element,{defaultParams:{hAxis:"x",vAxis:"y",hMajorLines:true,hMinorLines:false,vMajorLines:true,vMinorLines:false,hStripes:"none",vStripes:"none"},optionalParams:{},constructor:function(_1ca,_1cb){this.opt=dojo.clone(this.defaultParams);du.updateWithObject(this.opt,_1cb);this.hAxis=this.opt.hAxis;this.vAxis=this.opt.vAxis;this.dirty=true;},clear:function(){this._hAxis=null;this._vAxis=null;this.dirty=true;return this;},setAxis:function(axis){if(axis){this[axis.vertical?"_vAxis":"_hAxis"]=axis;}return this;},addSeries:function(run){return this;},calculateAxes:function(dim){return this;},isDirty:function(){return this.dirty||this._hAxis&&this._hAxis.dirty||this._vAxis&&this._vAxis.dirty;},getRequiredColors:function(){return 0;},render:function(dim,_1cc){this.dirty=this.isDirty();if(!this.dirty){return this;}this.cleanGroup();var s=this.group,ta=this.chart.theme.axis;try{var _1cd=this._vAxis.getScaler(),vt=_1cd.scaler.getTransformerFromModel(_1cd),_1ce=this._vAxis.getTicks();if(this.opt.hMinorLines){dojo.forEach(_1ce.minor,function(tick){var y=dim.height-_1cc.b-vt(tick.value);s.createLine({x1:_1cc.l,y1:y,x2:dim.width-_1cc.r,y2:y}).setStroke(ta.minorTick);});}if(this.opt.hMajorLines){dojo.forEach(_1ce.major,function(tick){var y=dim.height-_1cc.b-vt(tick.value);s.createLine({x1:_1cc.l,y1:y,x2:dim.width-_1cc.r,y2:y}).setStroke(ta.majorTick);});}}catch(e){}try{var _1cf=this._hAxis.getScaler(),ht=_1cf.scaler.getTransformerFromModel(_1cf),_1ce=this._hAxis.getTicks();if(_1ce&&this.opt.vMinorLines){dojo.forEach(_1ce.minor,function(tick){var x=_1cc.l+ht(tick.value);s.createLine({x1:x,y1:_1cc.t,x2:x,y2:dim.height-_1cc.b}).setStroke(ta.minorTick);});}if(_1ce&&this.opt.vMajorLines){dojo.forEach(_1ce.major,function(tick){var x=_1cc.l+ht(tick.value);s.createLine({x1:x,y1:_1cc.t,x2:x,y2:dim.height-_1cc.b}).setStroke(ta.majorTick);});}}catch(e){}this.dirty=false;return this;}});})();}if(!dojo._hasResource["dojox.charting.plot2d.Pie"]){dojo._hasResource["dojox.charting.plot2d.Pie"]=true;dojo.provide("dojox.charting.plot2d.Pie");(function(){var df=dojox.lang.functional,du=dojox.lang.utils,dc=dojox.charting.plot2d.common,da=dojox.charting.axis2d.common,g=dojox.gfx;dojo.declare("dojox.charting.plot2d.Pie",dojox.charting.Element,{defaultParams:{labels:true,ticks:false,fixed:true,precision:1,labelOffset:20,labelStyle:"default",htmlLabels:true},optionalParams:{font:"",fontColor:"",radius:0},constructor:function(_1d0,_1d1){this.opt=dojo.clone(this.defaultParams);du.updateWithObject(this.opt,_1d1);du.updateWithPattern(this.opt,_1d1,this.optionalParams);this.run=null;this.dyn=[];},destroy:function(){this.resetEvents();this.inherited(arguments);},clear:function(){this.dirty=true;this.dyn=[];this.run=null;return this;},setAxis:function(axis){return this;},addSeries:function(run){this.run=run;return this;},calculateAxes:function(dim){return this;},getRequiredColors:function(){return this.run?this.run.data.length:0;},plotEvent:function(o){},connect:function(_1d2,_1d3){this.dirty=true;return dojo.connect(this,"plotEvent",_1d2,_1d3);},events:function(){var ls=this.plotEvent._listeners;if(!ls||!ls.length){return false;}for(var i in ls){if(!(i in Array.prototype)){return true;}}return false;},resetEvents:function(){this.plotEvent({type:"onplotreset",plot:this});},_connectEvents:function(_1d4,o){_1d4.connect("onmouseover",this,function(e){o.type="onmouseover";o.event=e;this.plotEvent(o);});_1d4.connect("onmouseout",this,function(e){o.type="onmouseout";o.event=e;this.plotEvent(o);});_1d4.connect("onclick",this,function(e){o.type="onclick";o.event=e;this.plotEvent(o);});},render:function(dim,_1d5){if(!this.dirty){return this;}this.dirty=false;this.cleanGroup();var s=this.group,_1d6,t=this.chart.theme;this.resetEvents();if(!this.run||!this.run.data.length){return this;}var rx=(dim.width-_1d5.l-_1d5.r)/2,ry=(dim.height-_1d5.t-_1d5.b)/2,r=Math.min(rx,ry),_1d7="font" in this.opt?this.opt.font:t.axis.font,size=_1d7?g.normalizedLength(g.splitFontString(_1d7).size):0,_1d8="fontColor" in this.opt?this.opt.fontColor:t.axis.fontColor,_1d9=0,step,_1da,_1db,_1dc,_1dd,_1de,run=this.run.data,_1df=this.events();if(typeof run[0]=="number"){_1da=df.map(run,"Math.max(x, 0)");if(df.every(_1da,"<= 0")){return this;}_1db=df.map(_1da,"/this",df.foldl(_1da,"+",0));if(this.opt.labels){_1dc=dojo.map(_1db,function(x){return x>0?this._getLabel(x*100)+"%":"";},this);}}else{_1da=df.map(run,"Math.max(x.y, 0)");if(df.every(_1da,"<= 0")){return this;}_1db=df.map(_1da,"/this",df.foldl(_1da,"+",0));if(this.opt.labels){_1dc=dojo.map(_1db,function(x,i){if(x<=0){return "";}var v=run[i];return "text" in v?v.text:this._getLabel(x*100)+"%";},this);}}if(this.opt.labels){_1dd=df.foldl1(df.map(_1dc,function(_1e0){return dojox.gfx._base._getTextBox(_1e0,{font:_1d7}).w;},this),"Math.max(a, b)")/2;if(this.opt.labelOffset<0){r=Math.min(rx-2*_1dd,ry-size)+this.opt.labelOffset;}_1de=r-this.opt.labelOffset;}if("radius" in this.opt){r=this.opt.radius;_1de=r-this.opt.labelOffset;}var _1e1={cx:_1d5.l+rx,cy:_1d5.t+ry,r:r};this.dyn=[];dojo.some(_1db,function(_1e2,i){if(_1e2<=0){return false;}var v=run[i];if(_1e2>=1){var _1e3,fill,_1e4;if(typeof v=="object"){_1e3="color" in v?v.color:new dojo.Color(t.next("color"));fill="fill" in v?v.fill:dc.augmentFill(t.series.fill,_1e3);_1e4="stroke" in v?v.stroke:dc.augmentStroke(t.series.stroke,_1e3);}else{_1e3=new dojo.Color(t.next("color"));fill=dc.augmentFill(t.series.fill,_1e3);_1e4=dc.augmentStroke(t.series.stroke,_1e3);}var _1e5=s.createCircle(_1e1).setFill(fill).setStroke(_1e4);this.dyn.push({color:_1e3,fill:fill,stroke:_1e4});if(_1df){var o={element:"slice",index:i,run:this.run,plot:this,shape:_1e5,x:i,y:typeof v=="number"?v:v.y,cx:_1e1.cx,cy:_1e1.cy,cr:r};this._connectEvents(_1e5,o);}return true;}var end=_1d9+_1e2*2*Math.PI;if(i+1==_1db.length){end=2*Math.PI;}var step=end-_1d9,x1=_1e1.cx+r*Math.cos(_1d9),y1=_1e1.cy+r*Math.sin(_1d9),x2=_1e1.cx+r*Math.cos(end),y2=_1e1.cy+r*Math.sin(end);var _1e3,fill,_1e4;if(typeof v=="object"){_1e3="color" in v?v.color:new dojo.Color(t.next("color"));fill="fill" in v?v.fill:dc.augmentFill(t.series.fill,_1e3);_1e4="stroke" in v?v.stroke:dc.augmentStroke(t.series.stroke,_1e3);}else{_1e3=new dojo.Color(t.next("color"));fill=dc.augmentFill(t.series.fill,_1e3);_1e4=dc.augmentStroke(t.series.stroke,_1e3);}var _1e5=s.createPath({}).moveTo(_1e1.cx,_1e1.cy).lineTo(x1,y1).arcTo(r,r,0,step>Math.PI,true,x2,y2).lineTo(_1e1.cx,_1e1.cy).closePath().setFill(fill).setStroke(_1e4);this.dyn.push({color:_1e3,fill:fill,stroke:_1e4});if(_1df){var o={element:"slice",index:i,run:this.run,plot:this,shape:_1e5,x:i,y:typeof v=="number"?v:v.y,cx:_1e1.cx,cy:_1e1.cy,cr:r};this._connectEvents(_1e5,o);}_1d9=end;return false;},this);if(this.opt.labels){_1d9=0;dojo.some(_1db,function(_1e6,i){if(_1e6<=0){return false;}if(_1e6>=1){var v=run[i],elem=da.createText[this.opt.htmlLabels&&dojox.gfx.renderer!="vml"?"html":"gfx"](this.chart,s,_1e1.cx,_1e1.cy+size/2,"middle",_1dc[i],_1d7,(typeof v=="object"&&"fontColor" in v)?v.fontColor:_1d8);if(this.opt.htmlLabels){this.htmlElements.push(elem);}return true;}var end=_1d9+_1e6*2*Math.PI,v=run[i];if(i+1==_1db.length){end=2*Math.PI;}var _1e7=(_1d9+end)/2,x=_1e1.cx+_1de*Math.cos(_1e7),y=_1e1.cy+_1de*Math.sin(_1e7)+size/2;var elem=da.createText[this.opt.htmlLabels&&dojox.gfx.renderer!="vml"?"html":"gfx"](this.chart,s,x,y,"middle",_1dc[i],_1d7,(typeof v=="object"&&"fontColor" in v)?v.fontColor:_1d8);if(this.opt.htmlLabels){this.htmlElements.push(elem);}_1d9=end;return false;},this);}return this;},_getLabel:function(_1e8){return this.opt.fixed?_1e8.toFixed(this.opt.precision):_1e8.toString();}});})();}if(!dojo._hasResource["dojox.charting.plot2d.Bubble"]){dojo._hasResource["dojox.charting.plot2d.Bubble"]=true;dojo.provide("dojox.charting.plot2d.Bubble");(function(){var df=dojox.lang.functional,du=dojox.lang.utils,dc=dojox.charting.plot2d.common,_1e9=df.lambda("item.purgeGroup()");dojo.declare("dojox.charting.plot2d.Bubble",dojox.charting.plot2d.Base,{defaultParams:{hAxis:"x",vAxis:"y"},optionalParams:{},constructor:function(_1ea,_1eb){this.opt=dojo.clone(this.defaultParams);du.updateWithObject(this.opt,_1eb);this.series=[];this.hAxis=this.opt.hAxis;this.vAxis=this.opt.vAxis;},calculateAxes:function(dim){this._calc(dim,dc.collectSimpleStats(this.series));return this;},render:function(dim,_1ec){this.dirty=this.isDirty();if(this.dirty){dojo.forEach(this.series,_1e9);this.cleanGroup();var s=this.group;df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,_1ed,_1ee,_1ef,_1f0,_1f1,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),_1f2=this.events();this.resetEvents();for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){continue;}run.cleanGroup();if(!run.data.length){run.dirty=false;continue;}if(typeof run.data[0]=="number"){console.warn("dojox.charting.plot2d.Bubble: the data in the following series cannot be rendered as a bubble chart; ",run);continue;}var s=run.group,_1f3=dojo.map(run.data,function(v,i){return {x:ht(v.x)+_1ec.l,y:dim.height-_1ec.b-vt(v.y),radius:this._vScaler.bounds.scale*(v.size/2)};},this);if(run.fill){_1ef=run.fill;}else{if(run.stroke){_1ef=run.stroke;}else{_1ef=run.dyn.color=new dojo.Color(t.next("color"));}}run.dyn.fill=_1ef;_1ed=run.dyn.stroke=run.stroke?dc.makeStroke(run.stroke):dc.augmentStroke(t.series.stroke,_1ef);var _1f4=null,_1f5=null,_1f6=null;if(this.opt.shadows&&_1ed){var sh=this.opt.shadows,_1f1=new dojo.Color([0,0,0,0.2]),_1f0=dojo.clone(_1ee?_1ee:_1ed);_1f0.color=_1f1;_1f0.width+=sh.dw?sh.dw:0;run.dyn.shadow=_1f0;var _1f7=dojo.map(_1f3,function(item){var sh=this.opt.shadows;return s.createCircle({cx:item.x+sh.dx,cy:item.y+sh.dy,r:item.radius}).setStroke(_1f0).setFill(_1f1);},this);}if(run.outline||t.series.outline){_1ee=dc.makeStroke(run.outline?run.outline:t.series.outline);_1ee.width=2*_1ee.width+_1ed.width;run.dyn.outline=_1ee;_1f5=dojo.map(_1f3,function(item){s.createCircle({cx:item.x,cy:item.y,r:item.radius}).setStroke(_1ee);},this);}_1f4=dojo.map(_1f3,function(item){return s.createCircle({cx:item.x,cy:item.y,r:item.radius}).setStroke(_1ed).setFill(_1ef);},this);if(_1f2){dojo.forEach(_1f4,function(s,i){var o={element:"circle",index:i,run:run,plot:this,hAxis:this.hAxis||null,vAxis:this.vAxis||null,shape:s,outline:_1f5&&_1f5[i]||null,shadow:_1f6&&_1f6[i]||null,x:run.data[i].x,y:run.data[i].y,r:run.data[i].size/2,cx:_1f3[i].x,cy:_1f3[i].y,cr:_1f3[i].radius};this._connectEvents(s,o);},this);}run.dirty=false;}this.dirty=false;return this;}});})();}if(!dojo._hasResource["dojox.charting.plot2d.Candlesticks"]){dojo._hasResource["dojox.charting.plot2d.Candlesticks"]=true;dojo.provide("dojox.charting.plot2d.Candlesticks");(function(){var df=dojox.lang.functional,du=dojox.lang.utils,dc=dojox.charting.plot2d.common,_1f8=df.lambda("item.purgeGroup()");dojo.declare("dojox.charting.plot2d.Candlesticks",dojox.charting.plot2d.Base,{defaultParams:{hAxis:"x",vAxis:"y",gap:2,shadows:null},optionalParams:{minBarSize:1,maxBarSize:1},constructor:function(_1f9,_1fa){this.opt=dojo.clone(this.defaultParams);du.updateWithObject(this.opt,_1fa);du.updateWithPattern(this.opt,_1fa,this.optionalParams);this.series=[];this.hAxis=this.opt.hAxis;this.vAxis=this.opt.vAxis;},collectStats:function(_1fb){var _1fc=dojo.clone(dc.defaultStats);for(var i=0;i<_1fb.length;i++){var run=_1fb[i];if(!run.data.length){continue;}var _1fd=_1fc.vmin,_1fe=_1fc.vmax;if(!("ymin" in run)||!("ymax" in run)){dojo.forEach(run.data,function(val,idx){var x=val.x||idx+1;_1fc.hmin=Math.min(_1fc.hmin,x);_1fc.hmax=Math.max(_1fc.hmax,x);_1fc.vmin=Math.min(_1fc.vmin,val.open,val.close,val.high,val.low);_1fc.vmax=Math.max(_1fc.vmax,val.open,val.close,val.high,val.low);});}if("ymin" in run){_1fc.vmin=Math.min(_1fd,run.ymin);}if("ymax" in run){_1fc.vmax=Math.max(_1fe,run.ymax);}}return _1fc;},calculateAxes:function(dim){var _1ff=this.collectStats(this.series),t;_1ff.hmin-=0.5;_1ff.hmax+=0.5;this._calc(dim,_1ff);return this;},render:function(dim,_200){this.dirty=this.isDirty();if(this.dirty){dojo.forEach(this.series,_1f8);this.cleanGroup();var s=this.group;df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,_201,_202,fill,f,gap,_203,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),_204=Math.max(0,this._vScaler.bounds.lower),_205=vt(_204),_206=this.events();f=dc.calculateBarSize(this._hScaler.bounds.scale,this.opt);gap=f.gap;_203=f.size;this.resetEvents();for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){continue;}run.cleanGroup();var s=run.group;if(!run.fill||!run.stroke){_201=run.dyn.color=new dojo.Color(t.next("color"));}_202=run.stroke?run.stroke:dc.augmentStroke(t.series.stroke,_201);fill=run.fill?run.fill:dc.augmentFill(t.series.fill,_201);for(var j=0;j<run.data.length;++j){var v=run.data[j];var x=ht(v.x||(j+0.5))+_200.l+gap,y=dim.height-_200.b,open=vt(v.open),_207=vt(v.close),high=vt(v.high),low=vt(v.low);if("mid" in v){var mid=vt(v.mid);}if(low>high){var tmp=high;high=low;low=tmp;}if(_203>=1){var _208=open>_207;var line={x1:_203/2,x2:_203/2,y1:y-high,y2:y-low},rect={x:0,y:y-Math.max(open,_207),width:_203,height:Math.max(_208?open-_207:_207-open,1)};shape=s.createGroup();shape.setTransform({dx:x,dy:0});var _209=shape.createGroup();_209.createLine(line).setStroke(_202);_209.createRect(rect).setStroke(_202).setFill(_208?fill:"white");if("mid" in v){_209.createLine({x1:(_202.width||1),x2:_203-(_202.width||1),y1:y-mid,y2:y-mid}).setStroke(_208?{color:"white"}:_202);}run.dyn.fill=fill;run.dyn.stroke=_202;if(_206){var o={element:"candlestick",index:j,run:run,plot:this,hAxis:this.hAxis||null,vAxis:this.vAxis||null,shape:_209,x:x,y:y-Math.max(open,_207),cx:_203/2,cy:(y-Math.max(open,_207))+(Math.max(_208?open-_207:_207-open,1)/2),width:_203,height:Math.max(_208?open-_207:_207-open,1),data:v};this._connectEvents(shape,o);}}}run.dirty=false;}this.dirty=false;return this;}});})();}if(!dojo._hasResource["dojox.charting.plot2d.OHLC"]){dojo._hasResource["dojox.charting.plot2d.OHLC"]=true;dojo.provide("dojox.charting.plot2d.OHLC");(function(){var df=dojox.lang.functional,du=dojox.lang.utils,dc=dojox.charting.plot2d.common,_20a=df.lambda("item.purgeGroup()");dojo.declare("dojox.charting.plot2d.OHLC",dojox.charting.plot2d.Base,{defaultParams:{hAxis:"x",vAxis:"y",gap:2,shadows:null},optionalParams:{minBarSize:1,maxBarSize:1},constructor:function(_20b,_20c){this.opt=dojo.clone(this.defaultParams);du.updateWithObject(this.opt,_20c);du.updateWithPattern(this.opt,_20c,this.optionalParams);this.series=[];this.hAxis=this.opt.hAxis;this.vAxis=this.opt.vAxis;},collectStats:function(_20d){var _20e=dojo.clone(dc.defaultStats);for(var i=0;i<_20d.length;i++){var run=_20d[i];if(!run.data.length){continue;}var _20f=_20e.vmin,_210=_20e.vmax;if(!("ymin" in run)||!("ymax" in run)){dojo.forEach(run.data,function(val,idx){var x=val.x||idx+1;_20e.hmin=Math.min(_20e.hmin,x);_20e.hmax=Math.max(_20e.hmax,x);_20e.vmin=Math.min(_20e.vmin,val.open,val.close,val.high,val.low);_20e.vmax=Math.max(_20e.vmax,val.open,val.close,val.high,val.low);});}if("ymin" in run){_20e.vmin=Math.min(_20f,run.ymin);}if("ymax" in run){_20e.vmax=Math.max(_210,run.ymax);}}return _20e;},calculateAxes:function(dim){var _211=this.collectStats(this.series),t;_211.hmin-=0.5;_211.hmax+=0.5;this._calc(dim,_211);return this;},render:function(dim,_212){this.dirty=this.isDirty();if(this.dirty){dojo.forEach(this.series,_20a);this.cleanGroup();var s=this.group;df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,_213,_214,fill,f,gap,_215,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),_216=Math.max(0,this._vScaler.bounds.lower),_217=vt(_216),_218=this.events();f=dc.calculateBarSize(this._hScaler.bounds.scale,this.opt);gap=f.gap;_215=f.size;this.resetEvents();for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){continue;}run.cleanGroup();var s=run.group;if(!run.fill||!run.stroke){_213=run.dyn.color=new dojo.Color(t.next("color"));}_214=run.stroke?run.stroke:dc.augmentStroke(t.series.stroke,_213);fill=run.fill?run.fill:dc.augmentFill(t.series.fill,_213);for(var j=0;j<run.data.length;++j){var v=run.data[j];var x=ht(v.x||(j+0.5))+_212.l+gap,y=dim.height-_212.b,open=vt(v.open),_219=vt(v.close),high=vt(v.high),low=vt(v.low);if(low>high){var tmp=high;high=low;low=tmp;}if(_215>=1){var hl={x1:_215/2,x2:_215/2,y1:y-high,y2:y-low},op={x1:0,x2:((_215/2)+((_214.width||1)/2)),y1:y-open,y2:y-open},cl={x1:((_215/2)-((_214.width||1)/2)),x2:_215,y1:y-_219,y2:y-_219};shape=s.createGroup();shape.setTransform({dx:x,dy:0});var _21a=shape.createGroup();_21a.createLine(hl).setStroke(_214);_21a.createLine(op).setStroke(_214);_21a.createLine(cl).setStroke(_214);run.dyn.fill=fill;run.dyn.stroke=_214;if(_218){var o={element:"candlestick",index:j,run:run,plot:this,hAxis:this.hAxis||null,vAxis:this.vAxis||null,shape:_21a,x:x,y:y-Math.max(open,_219),cx:_215/2,cy:(y-Math.max(open,_219))+(Math.max(open>_219?open-_219:_219-open,1)/2),width:_215,height:Math.max(open>_219?open-_219:_219-open,1),data:v};this._connectEvents(shape,o);}}}run.dirty=false;}this.dirty=false;return this;}});})();}if(!dojo._hasResource["dojox.charting.Chart2D"]){dojo._hasResource["dojox.charting.Chart2D"]=true;dojo.provide("dojox.charting.Chart2D");(function(){var df=dojox.lang.functional,dc=dojox.charting,_21b=df.lambda("item.clear()"),_21c=df.lambda("item.purgeGroup()"),_21d=df.lambda("item.destroy()"),_21e=df.lambda("item.dirty = false"),_21f=df.lambda("item.dirty = true");dojo.declare("dojox.charting.Chart2D",null,{constructor:function(node,_220){if(!_220){_220={};}this.margins=_220.margins?_220.margins:{l:10,t:10,r:10,b:10};this.stroke=_220.stroke;this.fill=_220.fill;this.theme=null;this.axes={};this.stack=[];this.plots={};this.series=[];this.runs={};this.dirty=true;this.coords=null;this.node=dojo.byId(node);var box=dojo.marginBox(node);this.surface=dojox.gfx.createSurface(this.node,box.w,box.h);},destroy:function(){dojo.forEach(this.series,_21d);dojo.forEach(this.stack,_21d);df.forIn(this.axes,_21d);this.surface.destroy();},getCoords:function(){if(!this.coords){this.coords=dojo.coords(this.node,true);}return this.coords;},setTheme:function(_221){this.theme=_221._clone();this.dirty=true;return this;},addAxis:function(name,_222){var axis;if(!_222||!("type" in _222)){axis=new dc.axis2d.Default(this,_222);}else{axis=typeof _222.type=="string"?new dc.axis2d[_222.type](this,_222):new _222.type(this,_222);}axis.name=name;axis.dirty=true;if(name in this.axes){this.axes[name].destroy();}this.axes[name]=axis;this.dirty=true;return this;},getAxis:function(name){return this.axes[name];},removeAxis:function(name){if(name in this.axes){this.axes[name].destroy();delete this.axes[name];this.dirty=true;}return this;},addPlot:function(name,_223){var plot;if(!_223||!("type" in _223)){plot=new dc.plot2d.Default(this,_223);}else{plot=typeof _223.type=="string"?new dc.plot2d[_223.type](this,_223):new _223.type(this,_223);}plot.name=name;plot.dirty=true;if(name in this.plots){this.stack[this.plots[name]].destroy();this.stack[this.plots[name]]=plot;}else{this.plots[name]=this.stack.length;this.stack.push(plot);}this.dirty=true;return this;},removePlot:function(name){if(name in this.plots){var _224=this.plots[name];delete this.plots[name];this.stack[_224].destroy();this.stack.splice(_224,1);df.forIn(this.plots,function(idx,name,_225){if(idx>_224){_225[name]=idx-1;}});this.dirty=true;}return this;},addSeries:function(name,data,_226){var run=new dc.Series(this,data,_226);if(name in this.runs){this.series[this.runs[name]].destroy();this.series[this.runs[name]]=run;}else{this.runs[name]=this.series.length;this.series.push(run);}run.name=name;this.dirty=true;if(!("ymin" in run)&&"min" in run){run.ymin=run.min;}if(!("ymax" in run)&&"max" in run){run.ymax=run.max;}return this;},removeSeries:function(name){if(name in this.runs){var _227=this.runs[name],_228=this.series[_227].plot;delete this.runs[name];this.series[_227].destroy();this.series.splice(_227,1);df.forIn(this.runs,function(idx,name,runs){if(idx>_227){runs[name]=idx-1;}});this.dirty=true;}return this;},updateSeries:function(name,data){if(name in this.runs){var run=this.series[this.runs[name]];run.data=data;run.dirty=true;this._invalidateDependentPlots(run.plot,false);this._invalidateDependentPlots(run.plot,true);}return this;},resize:function(_229,_22a){var box;switch(arguments.length){case 0:box=dojo.marginBox(this.node);break;case 1:box=_229;break;default:box={w:_229,h:_22a};break;}dojo.marginBox(this.node,box);this.surface.setDimensions(box.w,box.h);this.dirty=true;this.coords=null;return this.render();},getGeometry:function(){var ret={};df.forIn(this.axes,function(axis){if(axis.initialized()){ret[axis.name]={name:axis.name,vertical:axis.vertical,scaler:axis.scaler,ticks:axis.ticks};}});return ret;},setAxisWindow:function(name,_22b,_22c){var axis=this.axes[name];if(axis){axis.setWindow(_22b,_22c);}return this;},setWindow:function(sx,sy,dx,dy){if(!("plotArea" in this)){this.calculateGeometry();}df.forIn(this.axes,function(axis){var _22d,_22e,_22f=axis.getScaler().bounds,s=_22f.span/(_22f.upper-_22f.lower);if(axis.vertical){_22d=sy;_22e=dy/s/_22d;}else{_22d=sx;_22e=dx/s/_22d;}axis.setWindow(_22d,_22e);});return this;},calculateGeometry:function(){if(this.dirty){return this.fullGeometry();}dojo.forEach(this.stack,function(plot){if(plot.dirty||(plot.hAxis&&this.axes[plot.hAxis].dirty)||(plot.vAxis&&this.axes[plot.vAxis].dirty)){plot.calculateAxes(this.plotArea);}},this);return this;},fullGeometry:function(){this._makeDirty();dojo.forEach(this.stack,_21b);if(!this.theme){this.setTheme(new dojox.charting.Theme(dojox.charting._def));}dojo.forEach(this.series,function(run){if(!(run.plot in this.plots)){var plot=new dc.plot2d.Default(this,{});plot.name=run.plot;this.plots[run.plot]=this.stack.length;this.stack.push(plot);}this.stack[this.plots[run.plot]].addSeries(run);},this);dojo.forEach(this.stack,function(plot){if(plot.hAxis){plot.setAxis(this.axes[plot.hAxis]);}if(plot.vAxis){plot.setAxis(this.axes[plot.vAxis]);}},this);var dim=this.dim=this.surface.getDimensions();dim.width=dojox.gfx.normalizedLength(dim.width);dim.height=dojox.gfx.normalizedLength(dim.height);df.forIn(this.axes,_21b);dojo.forEach(this.stack,function(p){p.calculateAxes(dim);});var _230=this.offsets={l:0,r:0,t:0,b:0};df.forIn(this.axes,function(axis){df.forIn(axis.getOffsets(),function(o,i){_230[i]+=o;});});df.forIn(this.margins,function(o,i){_230[i]+=o;});this.plotArea={width:dim.width-_230.l-_230.r,height:dim.height-_230.t-_230.b};df.forIn(this.axes,_21b);dojo.forEach(this.stack,function(plot){plot.calculateAxes(this.plotArea);},this);return this;},render:function(){if(this.theme){this.theme.clear();}if(this.dirty){return this.fullRender();}this.calculateGeometry();df.forEachRev(this.stack,function(plot){plot.render(this.dim,this.offsets);},this);df.forIn(this.axes,function(axis){axis.render(this.dim,this.offsets);},this);this._makeClean();if(this.surface.render){this.surface.render();}return this;},fullRender:function(){this.fullGeometry();var _231=this.offsets,dim=this.dim;var _232=df.foldl(this.stack,"z + plot.getRequiredColors()",0);this.theme.defineColors({num:_232,cache:false});dojo.forEach(this.series,_21c);df.forIn(this.axes,_21c);dojo.forEach(this.stack,_21c);this.surface.clear();var t=this.theme,fill=t.plotarea&&t.plotarea.fill,_233=t.plotarea&&t.plotarea.stroke;if(fill){this.surface.createRect({x:_231.l,y:_231.t,width:dim.width-_231.l-_231.r,height:dim.height-_231.t-_231.b}).setFill(fill);}if(_233){this.surface.createRect({x:_231.l,y:_231.t,width:dim.width-_231.l-_231.r-1,height:dim.height-_231.t-_231.b-1}).setStroke(_233);}df.foldr(this.stack,function(z,plot){return plot.render(dim,_231),0;},0);fill=this.fill?this.fill:(t.chart&&t.chart.fill);_233=this.stroke?this.stroke:(t.chart&&t.chart.stroke);if(fill=="inherit"){var node=this.node,fill=new dojo.Color(dojo.style(node,"backgroundColor"));while(fill.a==0&&node!=document.documentElement){fill=new dojo.Color(dojo.style(node,"backgroundColor"));node=node.parentNode;}}if(fill){if(_231.l){this.surface.createRect({width:_231.l,height:dim.height+1}).setFill(fill);}if(_231.r){this.surface.createRect({x:dim.width-_231.r,width:_231.r+1,height:dim.height+1}).setFill(fill);}if(_231.t){this.surface.createRect({width:dim.width+1,height:_231.t}).setFill(fill);}if(_231.b){this.surface.createRect({y:dim.height-_231.b,width:dim.width+1,height:_231.b+2}).setFill(fill);}}if(_233){this.surface.createRect({width:dim.width-1,height:dim.height-1}).setStroke(_233);}df.forIn(this.axes,function(axis){axis.render(dim,_231);});this._makeClean();if(this.surface.render){this.surface.render();}return this;},connectToPlot:function(name,_234,_235){return name in this.plots?this.stack[this.plots[name]].connect(_234,_235):null;},_makeClean:function(){dojo.forEach(this.axes,_21e);dojo.forEach(this.stack,_21e);dojo.forEach(this.series,_21e);this.dirty=false;},_makeDirty:function(){dojo.forEach(this.axes,_21f);dojo.forEach(this.stack,_21f);dojo.forEach(this.series,_21f);this.dirty=true;},_invalidateDependentPlots:function(_236,_237){if(_236 in this.plots){var plot=this.stack[this.plots[_236]],axis,_238=_237?"vAxis":"hAxis";if(plot[_238]){axis=this.axes[plot[_238]];if(axis&&axis.dependOnData()){axis.dirty=true;dojo.forEach(this.stack,function(p){if(p[_238]&&p[_238]==plot[_238]){p.dirty=true;}});}}else{plot.dirty=true;}}}});})();}if(!dojo._hasResource["dojox.charting.widget.Legend"]){dojo._hasResource["dojox.charting.widget.Legend"]=true;dojo.provide("dojox.charting.widget.Legend");dojo.declare("dojox.charting.widget.Legend",[dijit._Widget,dijit._Templated],{chartRef:"",horizontal:true,swatchSize:18,templateString:"<table dojoAttachPoint='legendNode' class='dojoxLegendNode'><tbody dojoAttachPoint='legendBody'></tbody></table>",legendNode:null,legendBody:null,postCreate:function(){if(!this.chart){if(!this.chartRef){return;}this.chart=dijit.byId(this.chartRef);if(!this.chart){var node=dojo.byId(this.chartRef);if(node){this.chart=dijit.byNode(node);}else{console.log("Could not find chart instance with id: "+this.chartRef);return;}}this.series=this.chart.chart.series;}else{this.series=this.chart.series;}this.refresh();},refresh:function(){var df=dojox.lang.functional;if(this._surfaces){dojo.forEach(this._surfaces,function(_239){_239.destroy();});}this._surfaces=[];while(this.legendBody.lastChild){dojo.destroy(this.legendBody.lastChild);}if(this.horizontal){dojo.addClass(this.legendNode,"dojoxLegendHorizontal");this._tr=dojo.doc.createElement("tr");this.legendBody.appendChild(this._tr);}var s=this.series;if(s.length==0){return;}if(s[0].chart.stack[0].declaredClass=="dojox.charting.plot2d.Pie"){var t=s[0].chart.stack[0];if(typeof t.run.data[0]=="number"){var _23a=df.map(t.run.data,"Math.max(x, 0)");if(df.every(_23a,"<= 0")){return;}var _23b=df.map(_23a,"/this",df.foldl(_23a,"+",0));dojo.forEach(_23b,function(x,i){this._addLabel(t.dyn[i],t._getLabel(x*100)+"%");},this);}else{dojo.forEach(t.run.data,function(x,i){this._addLabel(t.dyn[i],x.legend||x.text||x.y);},this);}}else{dojo.forEach(s,function(x){this._addLabel(x.dyn,x.legend||x.name);},this);}},_addLabel:function(dyn,_23c){var icon=dojo.doc.createElement("td"),text=dojo.doc.createElement("td"),div=dojo.doc.createElement("div");dojo.addClass(icon,"dojoxLegendIcon");dojo.addClass(text,"dojoxLegendText");div.style.width=this.swatchSize+"px";div.style.height=this.swatchSize+"px";icon.appendChild(div);if(this._tr){this._tr.appendChild(icon);this._tr.appendChild(text);}else{var tr=dojo.doc.createElement("tr");this.legendBody.appendChild(tr);tr.appendChild(icon);tr.appendChild(text);}this._makeIcon(div,dyn);text.innerHTML=String(_23c);},_makeIcon:function(div,dyn){var mb={h:this.swatchSize,w:this.swatchSize};var _23d=dojox.gfx.createSurface(div,mb.w,mb.h);this._surfaces.push(_23d);if(dyn.fill){_23d.createRect({x:2,y:2,width:mb.w-4,height:mb.h-4}).setFill(dyn.fill).setStroke(dyn.stroke);}else{if(dyn.stroke||dyn.marker){var line={x1:0,y1:mb.h/2,x2:mb.w,y2:mb.h/2};if(dyn.stroke){_23d.createLine(line).setStroke(dyn.stroke);}if(dyn.marker){var c={x:mb.w/2,y:mb.h/2};if(dyn.stroke){_23d.createPath({path:"M"+c.x+" "+c.y+" "+dyn.marker}).setFill(dyn.stroke.color).setStroke(dyn.stroke);}else{_23d.createPath({path:"M"+c.x+" "+c.y+" "+dyn.marker}).setFill(dyn.color).setStroke(dyn.color);}}}else{_23d.createRect({x:2,y:2,width:mb.w-4,height:mb.h-4}).setStroke("black");_23d.createLine({x1:2,y1:2,x2:mb.w-2,y2:mb.h-2}).setStroke("black");_23d.createLine({x1:2,y1:mb.h-2,x2:mb.w-2,y2:2}).setStroke("black");}}}});}if(!dojo._hasResource["dojo.fx.easing"]){dojo._hasResource["dojo.fx.easing"]=true;dojo.provide("dojo.fx.easing");dojo.fx.easing={linear:function(n){return n;},quadIn:function(n){return Math.pow(n,2);},quadOut:function(n){return n*(n-2)*-1;},quadInOut:function(n){n=n*2;if(n<1){return Math.pow(n,2)/2;}return -1*((--n)*(n-2)-1)/2;},cubicIn:function(n){return Math.pow(n,3);},cubicOut:function(n){return Math.pow(n-1,3)+1;},cubicInOut:function(n){n=n*2;if(n<1){return Math.pow(n,3)/2;}n-=2;return (Math.pow(n,3)+2)/2;},quartIn:function(n){return Math.pow(n,4);},quartOut:function(n){return -1*(Math.pow(n-1,4)-1);},quartInOut:function(n){n=n*2;if(n<1){return Math.pow(n,4)/2;}n-=2;return -1/2*(Math.pow(n,4)-2);},quintIn:function(n){return Math.pow(n,5);},quintOut:function(n){return Math.pow(n-1,5)+1;},quintInOut:function(n){n=n*2;if(n<1){return Math.pow(n,5)/2;}n-=2;return (Math.pow(n,5)+2)/2;},sineIn:function(n){return -1*Math.cos(n*(Math.PI/2))+1;},sineOut:function(n){return Math.sin(n*(Math.PI/2));},sineInOut:function(n){return -1*(Math.cos(Math.PI*n)-1)/2;},expoIn:function(n){return (n==0)?0:Math.pow(2,10*(n-1));},expoOut:function(n){return (n==1)?1:(-1*Math.pow(2,-10*n)+1);},expoInOut:function(n){if(n==0){return 0;}if(n==1){return 1;}n=n*2;if(n<1){return Math.pow(2,10*(n-1))/2;}--n;return (-1*Math.pow(2,-10*n)+2)/2;},circIn:function(n){return -1*(Math.sqrt(1-Math.pow(n,2))-1);},circOut:function(n){n=n-1;return Math.sqrt(1-Math.pow(n,2));},circInOut:function(n){n=n*2;if(n<1){return -1/2*(Math.sqrt(1-Math.pow(n,2))-1);}n-=2;return 1/2*(Math.sqrt(1-Math.pow(n,2))+1);},backIn:function(n){var s=1.70158;return Math.pow(n,2)*((s+1)*n-s);},backOut:function(n){n=n-1;var s=1.70158;return Math.pow(n,2)*((s+1)*n+s)+1;},backInOut:function(n){var s=1.70158*1.525;n=n*2;if(n<1){return (Math.pow(n,2)*((s+1)*n-s))/2;}n-=2;return (Math.pow(n,2)*((s+1)*n+s)+2)/2;},elasticIn:function(n){if(n==0||n==1){return n;}var p=0.3;var s=p/4;n=n-1;return -1*Math.pow(2,10*n)*Math.sin((n-s)*(2*Math.PI)/p);},elasticOut:function(n){if(n==0||n==1){return n;}var p=0.3;var s=p/4;return Math.pow(2,-10*n)*Math.sin((n-s)*(2*Math.PI)/p)+1;},elasticInOut:function(n){if(n==0){return 0;}n=n*2;if(n==2){return 1;}var p=0.3*1.5;var s=p/4;if(n<1){n-=1;return -0.5*(Math.pow(2,10*n)*Math.sin((n-s)*(2*Math.PI)/p));}n-=1;return 0.5*(Math.pow(2,-10*n)*Math.sin((n-s)*(2*Math.PI)/p))+1;},bounceIn:function(n){return (1-dojo.fx.easing.bounceOut(1-n));},bounceOut:function(n){var s=7.5625;var p=2.75;var l;if(n<(1/p)){l=s*Math.pow(n,2);}else{if(n<(2/p)){n-=(1.5/p);l=s*Math.pow(n,2)+0.75;}else{if(n<(2.5/p)){n-=(2.25/p);l=s*Math.pow(n,2)+0.9375;}else{n-=(2.625/p);l=s*Math.pow(n,2)+0.984375;}}}return l;},bounceInOut:function(n){if(n<0.5){return dojo.fx.easing.bounceIn(n*2)/2;}return (dojo.fx.easing.bounceOut(n*2-1)/2)+0.5;}};}if(!dojo._hasResource["dojox.charting.action2d.Base"]){dojo._hasResource["dojox.charting.action2d.Base"]=true;dojo.provide("dojox.charting.action2d.Base");(function(){var _23e=400,_23f=dojo.fx.easing.backOut,df=dojox.lang.functional;dojo.declare("dojox.charting.action2d.Base",null,{overOutEvents:{onmouseover:1,onmouseout:1},constructor:function(_240,plot,_241){this.chart=_240;this.plot=plot?plot:"default";this.anim={};if(!_241){_241={};}this.duration=_241.duration?_241.duration:_23e;this.easing=_241.easing?_241.easing:_23f;},connect:function(){this.handle=this.chart.connectToPlot(this.plot,this,"process");},disconnect:function(){if(this.handle){dojo.disconnect(this.handle);this.handle=null;}},reset:function(){},destroy:function(){if(this.handle){this.disconnect();}df.forIn(this.anim,function(o){df.forIn(o,function(anim){anim.action.stop(true);});});this.anim={};}});})();}if(!dojo._hasResource["dojox.charting.action2d.Highlight"]){dojo._hasResource["dojox.charting.action2d.Highlight"]=true;dojo.provide("dojox.charting.action2d.Highlight");(function(){var _242=100,_243=75,_244=50,c=dojox.color,cc=function(_245){return function(){return _245;};},hl=function(_246){var a=new c.Color(_246),x=a.toHsl();if(x.s==0){x.l=x.l<50?100:0;}else{x.s=_242;if(x.l<_244){x.l=_243;}else{if(x.l>_243){x.l=_244;}else{x.l=x.l-_244>_243-x.l?_244:_243;}}}return c.fromHsl(x);};dojo.declare("dojox.charting.action2d.Highlight",dojox.charting.action2d.Base,{defaultParams:{duration:400,easing:dojo.fx.easing.backOut},optionalParams:{highlight:"red"},constructor:function(_247,plot,_248){var a=_248&&_248.highlight;this.colorFun=a?(dojo.isFunction(a)?a:cc(a)):hl;this.connect();},process:function(o){if(!o.shape||!(o.type in this.overOutEvents)){return;}var _249=o.run.name,_24a=o.index,anim,_24b,_24c;if(_249 in this.anim){anim=this.anim[_249][_24a];}else{this.anim[_249]={};}if(anim){anim.action.stop(true);}else{var _24d=o.shape.getFill();if(!_24d||!(_24d instanceof dojo.Color)){return;}this.anim[_249][_24a]=anim={start:_24d,end:this.colorFun(_24d)};}var _24e=anim.start,end=anim.end;if(o.type=="onmouseout"){var t=_24e;_24e=end;end=t;}anim.action=dojox.gfx.fx.animateFill({shape:o.shape,duration:this.duration,easing:this.easing,color:{start:_24e,end:end}});if(o.type=="onmouseout"){dojo.connect(anim.action,"onEnd",this,function(){if(this.anim[_249]){delete this.anim[_249][_24a];}});}anim.action.play();}});})();}if(!dojo._hasResource["dojox.charting.action2d.Magnify"]){dojo._hasResource["dojox.charting.action2d.Magnify"]=true;dojo.provide("dojox.charting.action2d.Magnify");(function(){var _24f=2,m=dojox.gfx.matrix,gf=dojox.gfx.fx;dojo.declare("dojox.charting.action2d.Magnify",dojox.charting.action2d.Base,{defaultParams:{duration:400,easing:dojo.fx.easing.backOut,scale:_24f},optionalParams:{},constructor:function(_250,plot,_251){this.scale=_251&&typeof _251.scale=="number"?_251.scale:_24f;this.connect();},process:function(o){if(!o.shape||!(o.type in this.overOutEvents)||!("cx" in o)||!("cy" in o)){return;}var _252=o.run.name,_253=o.index,_254=[],anim,init,_255;if(_252 in this.anim){anim=this.anim[_252][_253];}else{this.anim[_252]={};}if(anim){anim.action.stop(true);}else{this.anim[_252][_253]=anim={};}if(o.type=="onmouseover"){init=m.identity;_255=this.scale;}else{init=m.scaleAt(this.scale,o.cx,o.cy);_255=1/this.scale;}var _256={shape:o.shape,duration:this.duration,easing:this.easing,transform:[{name:"scaleAt",start:[1,o.cx,o.cy],end:[_255,o.cx,o.cy]},init]};if(o.shape){_254.push(gf.animateTransform(_256));}if(o.oultine){_256.shape=o.outline;_254.push(gf.animateTransform(_256));}if(o.shadow){_256.shape=o.shadow;_254.push(gf.animateTransform(_256));}if(!_254.length){delete this.anim[_252][_253];return;}anim.action=dojo.fx.combine(_254);if(o.type=="onmouseout"){dojo.connect(anim.action,"onEnd",this,function(){if(this.anim[_252]){delete this.anim[_252][_253];}});}anim.action.play();}});})();}if(!dojo._hasResource["dojox.lang.functional.scan"]){dojo._hasResource["dojox.lang.functional.scan"]=true;dojo.provide("dojox.lang.functional.scan");(function(){var d=dojo,df=dojox.lang.functional,_257={};d.mixin(df,{scanl:function(a,f,z,o){if(typeof a=="string"){a=a.split("");}o=o||d.global;f=df.lambda(f);var t,n,i;if(d.isArray(a)){t=new Array((n=a.length)+1);t[0]=z;for(i=0;i<n;z=f.call(o,z,a[i],i,a),t[++i]=z){}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){t=[z];for(i=0;a.hasNext();t.push(z=f.call(o,z,a.next(),i++,a))){}}else{t=[z];for(i in a){if(!(i in _257)){t.push(z=f.call(o,z,a[i],i,a));}}}}return t;},scanl1:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||d.global;f=df.lambda(f);var t,n,z,_258=true;if(d.isArray(a)){t=new Array(n=a.length);t[0]=z=a[0];for(var i=1;i<n;t[i]=z=f.call(o,z,a[i],i,a),++i){}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){if(a.hasNext()){t=[z=a.next()];for(var i=1;a.hasNext();t.push(z=f.call(o,z,a.next(),i++,a))){}}}else{for(var i in a){if(!(i in _257)){if(_258){t=[z=a[i]];_258=false;}else{t.push(z=f.call(o,z,a[i],i,a));}}}}}return t;},scanr:function(a,f,z,o){if(typeof a=="string"){a=a.split("");}o=o||d.global;f=df.lambda(f);var n=a.length,t=new Array(n+1),i=n;t[n]=z;for(;i>0;--i,z=f.call(o,z,a[i],i,a),t[i]=z){}return t;},scanr1:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||d.global;f=df.lambda(f);var n=a.length,t=new Array(n),z=a[n-1],i=n-1;t[i]=z;for(;i>0;--i,z=f.call(o,z,a[i],i,a),t[i]=z){}return t;}});})();}if(!dojo._hasResource["dojox.charting.action2d.MoveSlice"]){dojo._hasResource["dojox.charting.action2d.MoveSlice"]=true;dojo.provide("dojox.charting.action2d.MoveSlice");(function(){var _259=1.05,_25a=7,m=dojox.gfx.matrix,gf=dojox.gfx.fx,df=dojox.lang.functional;dojo.declare("dojox.charting.action2d.MoveSlice",dojox.charting.action2d.Base,{defaultParams:{duration:400,easing:dojo.fx.easing.backOut,scale:_259,shift:_25a},optionalParams:{},constructor:function(_25b,plot,_25c){if(!_25c){_25c={};}this.scale=typeof _25c.scale=="number"?_25c.scale:_259;this.shift=typeof _25c.shift=="number"?_25c.shift:_25a;this.connect();},process:function(o){if(!o.shape||o.element!="slice"||!(o.type in this.overOutEvents)){return;}if(!this.angles){if(typeof o.run.data[0]=="number"){this.angles=df.map(df.scanl(o.run.data,"+",0),"* 2 * Math.PI / this",df.foldl(o.run.data,"+",0));}else{this.angles=df.map(df.scanl(o.run.data,"a + b.y",0),"* 2 * Math.PI / this",df.foldl(o.run.data,"a + b.y",0));}}var _25d=o.index,anim,_25e,_25f,_260,_261,_262=(this.angles[_25d]+this.angles[_25d+1])/2,_263=m.rotateAt(-_262,o.cx,o.cy),_264=m.rotateAt(_262,o.cx,o.cy);anim=this.anim[_25d];if(anim){anim.action.stop(true);}else{this.anim[_25d]=anim={};}if(o.type=="onmouseover"){_260=0;_261=this.shift;_25e=1;_25f=this.scale;}else{_260=this.shift;_261=0;_25e=this.scale;_25f=1;}anim.action=dojox.gfx.fx.animateTransform({shape:o.shape,duration:this.duration,easing:this.easing,transform:[_264,{name:"translate",start:[_260,0],end:[_261,0]},{name:"scaleAt",start:[_25e,o.cx,o.cy],end:[_25f,o.cx,o.cy]},_263]});if(o.type=="onmouseout"){dojo.connect(anim.action,"onEnd",this,function(){delete this.anim[_25d];});}anim.action.play();},reset:function(){delete this.angles;}});})();}if(!dojo._hasResource["dojox.charting.action2d.Shake"]){dojo._hasResource["dojox.charting.action2d.Shake"]=true;dojo.provide("dojox.charting.action2d.Shake");(function(){var _265=3,m=dojox.gfx.matrix,gf=dojox.gfx.fx;dojo.declare("dojox.charting.action2d.Shake",dojox.charting.action2d.Base,{defaultParams:{duration:400,easing:dojo.fx.easing.backOut,shiftX:_265,shiftY:_265},optionalParams:{},constructor:function(_266,plot,_267){if(!_267){_267={};}this.shiftX=typeof _267.shiftX=="number"?_267.shiftX:_265;this.shiftY=typeof _267.shiftY=="number"?_267.shiftY:_265;this.connect();},process:function(o){if(!o.shape||!(o.type in this.overOutEvents)){return;}var _268=o.run.name,_269=o.index,_26a=[],anim,_26b=o.type=="onmouseover"?this.shiftX:-this.shiftX,_26c=o.type=="onmouseover"?this.shiftY:-this.shiftY;if(_268 in this.anim){anim=this.anim[_268][_269];}else{this.anim[_268]={};}if(anim){anim.action.stop(true);}else{this.anim[_268][_269]=anim={};}var _26d={shape:o.shape,duration:this.duration,easing:this.easing,transform:[{name:"translate",start:[this.shiftX,this.shiftY],end:[0,0]},m.identity]};if(o.shape){_26a.push(gf.animateTransform(_26d));}if(o.oultine){_26d.shape=o.outline;_26a.push(gf.animateTransform(_26d));}if(o.shadow){_26d.shape=o.shadow;_26a.push(gf.animateTransform(_26d));}if(!_26a.length){delete this.anim[_268][_269];return;}anim.action=dojo.fx.combine(_26a);if(o.type=="onmouseout"){dojo.connect(anim.action,"onEnd",this,function(){if(this.anim[_268]){delete this.anim[_268][_269];}});}anim.action.play();}});})();}if(!dojo._hasResource["dojox.charting.action2d.Tooltip"]){dojo._hasResource["dojox.charting.action2d.Tooltip"]=true;dojo.provide("dojox.charting.action2d.Tooltip");(function(){var _26e=function(o){var t=o.run&&o.run.data&&o.run.data[o.index];if(t&&typeof t!="number"&&(t.tooltip||t.text)){return t.tooltip||t.text;}if(o.element=="candlestick"){return "<table cellpadding=\"1\" cellspacing=\"0\" border=\"0\" style=\"font-size:0.9em;\">"+"<tr><td>Open:</td><td align=\"right\"><strong>"+o.data.open+"</strong></td></tr>"+"<tr><td>High:</td><td align=\"right\"><strong>"+o.data.high+"</strong></td></tr>"+"<tr><td>Low:</td><td align=\"right\"><strong>"+o.data.low+"</strong></td></tr>"+"<tr><td>Close:</td><td align=\"right\"><strong>"+o.data.close+"</strong></td></tr>"+(o.data.mid!==undefined?"<tr><td>Mid:</td><td align=\"right\"><strong>"+o.data.mid+"</strong></td></tr>":"")+"</table>";}return o.element=="bar"?o.x:o.y;};var df=dojox.lang.functional,pi4=Math.PI/4,pi2=Math.PI/2;dojo.declare("dojox.charting.action2d.Tooltip",dojox.charting.action2d.Base,{defaultParams:{text:_26e},optionalParams:{},constructor:function(_26f,plot,_270){this.text=_270&&_270.text?_270.text:_26e;this.connect();},process:function(o){if(o.type==="onplotreset"||o.type==="onmouseout"){dijit.hideTooltip(this.aroundRect);this.aroundRect=null;return;}if(!o.shape||o.type!=="onmouseover"){return;}var _271={type:"rect"},_272=["after","before"];switch(o.element){case "marker":_271.x=o.cx;_271.y=o.cy;_271.width=_271.height=1;break;case "circle":_271.x=o.cx-o.cr;_271.y=o.cy-o.cr;_271.width=_271.height=2*o.cr;break;case "column":_272=["above","below"];case "bar":_271=dojo.clone(o.shape.getShape());break;case "candlestick":_271.x=o.x;_271.y=o.y;_271.width=o.width;_271.height=o.height;break;default:if(!this.angles){if(typeof o.run.data[0]=="number"){this.angles=df.map(df.scanl(o.run.data,"+",0),"* 2 * Math.PI / this",df.foldl(o.run.data,"+",0));}else{this.angles=df.map(df.scanl(o.run.data,"a + b.y",0),"* 2 * Math.PI / this",df.foldl(o.run.data,"a + b.y",0));}}var _273=(this.angles[o.index]+this.angles[o.index+1])/2;_271.x=o.cx+o.cr*Math.cos(_273);_271.y=o.cy+o.cr*Math.sin(_273);_271.width=_271.height=1;if(_273<pi4){}else{if(_273<pi2+pi4){_272=["below","above"];}else{if(_273<Math.PI+pi4){_272=["before","after"];}else{if(_273<2*Math.PI-pi4){_272=["above","below"];}}}}break;}var lt=dojo.coords(this.chart.node,true);_271.x+=lt.x;_271.y+=lt.y;_271.x=Math.round(_271.x);_271.y=Math.round(_271.y);_271.width=Math.ceil(_271.width);_271.height=Math.ceil(_271.height);this.aroundRect=_271;dijit.showTooltip(this.text(o),this.aroundRect,_272);}});})();}if(!dojo._hasResource["wm.base.widget.DojoChart"]){dojo._hasResource["wm.base.widget.DojoChart"]=true;dojo.provide("wm.base.widget.DojoChart");var chartThemes=["GreySkies","Adobebricks","Algae","Bahamation","BlueDusk","CubanShirts","Desert","Dollar","Grasshopper","Grasslands","IndigoNation","Ireland","MiamiNice","Midwest","Minty","PurpleRain","RoyalPurples","SageToLime","Shrooms","Tufte","WatersEdge","Wetland","PlotKit.blue","PlotKit.cyan","PlotKit.green","PlotKit.orange","PlotKit.purple","PlotKit.red"];var chartTypes=["Columns","ClusteredColumns","StackedColumns","Bars","ClusteredBars","StackedBars","Areas","StackedAreas","Pie","Lines"];dojo.declare("wm.DojoChart",wm.Control,{padding:4,width:"200px",height:"200px",legendHeight:"50px",variable:null,dataSet:null,dojoObj:null,theme:"CubanShirts",xAxis:"wmDefaultX",isTimeXAxis:false,maxTimePoints:15,xMajorTickStep:5,xMinorTicks:false,xMinorTickStep:1,yAxis:"wmDefaultY",yUpperRange:"",chartColor:"",includeX:true,includeY:true,enableAnimation:true,chartType:"Columns",includeGrid:false,gap:2,defaultXY:[{"wmDefaultX":"Jan","wmDefaultY":3},{"wmDefaultX":"Feb","wmDefaultY":5},{"wmDefaultX":"Mar","wmDefaultY":8},{"wmDefaultX":"Apr","wmDefaultY":2}],addedSeries:{},aniHighlight:null,aniShake:null,magnify:null,aniTooltip:null,addSilverlight:false,init:function(){if(this.showAddSilverlight()){return;}dojo["require"]("dojox.charting.Chart2D");dojo["require"]("dojox.charting.widget.Legend");dojo["require"]("dojox.charting.action2d.Highlight");dojo["require"]("dojox.charting.action2d.Magnify");dojo["require"]("dojox.charting.action2d.MoveSlice");dojo["require"]("dojox.charting.action2d.Shake");dojo["require"]("dojox.charting.action2d.Tooltip");dojo["require"]("dojo.fx.easing");this.inherited(arguments);},postInit:function(){this.inherited(arguments);},renderDojoObj:function(){if(this._loading||this.addSilverlight){return;}if(this.dojoObj!=null){this.dojoObj.destroy();while(this.domNode.childNodes.length>0){this.domNode.removeChild(this.domNode.childNodes[0]);}}this.dojoDiv=dojo.doc.createElement("div");this.updateChartDivHeight();this.domNode.appendChild(this.dojoDiv);this.dojoObj=new dojox.charting.Chart2D(this.dojoDiv);this.setChartTheme();this.updateChartType();this.addXAxis();this.addYAxis();if(this.includeGrid){this.dojoObj.addPlot("grid",{type:"Grid",hMinorLines:true,vMinorLines:true});}this.addAnimation();this.addChartSeries();var self=this;dojo.addOnLoad(function(){self.dojoRenderer();self.connectDojoEvents();});},renderBounds:function(){this.inherited(arguments);this.resizeDijit();},resizeDijit:function(){this.renderDojoObj();},createLegend:function(){if(this.legend&&this.legend!=null){this.legend.destroy();}this.legendDiv=dojo.doc.createElement("div");dojo.attr(this.legendDiv,"align","center");this.domNode.appendChild(this.legendDiv);try{this.legend=new dojox.charting.widget.Legend({chart:this.dojoObj},this.legendDiv);}catch(e){}},updateChartDivHeight:function(){if(!this.dojoDiv){return;}var h=dojo.coords(this.domNode).h;var lh=wm.splitUnits(this.legendHeight);var l=lh.value;var _274=h-l;if(_274>0){this.dojoDiv.style.width=this.width;this.dojoDiv.style.height=_274+"px";}},dojoRenderer:function(){if(!this.dojoObj){return;}try{this.dojoObj.render();}catch(e){}this.createLegend();},connectDojoEvents:function(){this.dojoObj.connectToPlot("default",dojo.hitch(this,"dojoChartEvent"));},getDataSet:function(){return this.variable;},setDataSet:function(_275,_276){this.variable=_275;if(!this.variable||!this.variable.getData()){return;}var _277=this;if(this.isTimeXAxis&&this.dojoObj){this.incrementSeries();}else{dojo.addOnLoad(function(){_277.renderDojoObj();});}},addChartSeries:function(_278){this.updateXLabelSet();dojo.forEach(this.yAxis.split(","),function(_279,idx){try{_279=dojo.trim(_279);if(!_279){return;}var _27a=this.getColumnDataSet(_279);var _27b=wm.capitalize(_279);if(_278&&this.addedSeries[_27b]&&this.addedSeries[_27b].length>0){_27a=this.addedSeries[_27b].concat(_27a);while(_27a.length>this.maxTimePoints){_27a.shift();}}if(this.chartColor instanceof Array){var _27c=this.chartColor[idx];}if(_27c&&_27c!=""&&this.chartType!="Pie"){this.dojoObj.addSeries(_27b,_27a,{stroke:{width:0},fill:_27c});}else{if(!_278){this.dojoObj.addSeries(_27b,_27a);}else{this.dojoObj.updateSeries(_27b,_27a);}}this.addedSeries[_27b]=_27a;}catch(e){console.info("Error while making chartdata",e);}},this);},getChartDataSet:function(){if((this.xAxis=="wmDefaultX"||this.yAxis=="wmDefaultY")&&this.isDesignLoaded()){return this.defaultXY;}if(!this.variable||this.variable==""){return [];}var ds=this.variable.getData();if(ds&&!(ds instanceof Array)){ds=[ds];}return ds;},updateXLabelSet:function(){if(this.isTimeXAxis){return [];}this.xLabels={};var ds=this.getChartDataSet();var x=(this.xAxis=="wmDefaultX"||this.yAxis=="wmDefaultY")?"wmDefaultX":this.xAxis;dojo.forEach(ds,function(obj,idx){var _27d=obj[x];this.xLabels[_27d]=this.addXLabel(_27d);},this);return this.xLabels;},isPieChart:function(){return this.chartType=="Pie";},getColumnDataSet:function(_27e){var data=[],x="";var ds=this.getChartDataSet();var _27f=(this.xAxis=="wmDefaultX"||this.yAxis=="wmDefaultY")?"wmDefaultX":this.xAxis;dojo.forEach(ds,function(_280,i){var obj={y:_280[_27e]};if(this.isPieChart()){if(_27f!=""){obj.legend=_280[_27f];}if(this.chartColor!=""){if(this.chartColor instanceof Array){var _281=this.chartColor[i];if(_281){obj.color=_281;}}else{obj.color=_280[this.chartColor];}}}else{if(this.isTimeXAxis){x=this.getTimeX();}else{if(_27f){x=this.xLabels[_280[_27f]];}}if(x!=""){obj.x=x;}}data.push(obj);},this);return data;},getPieDataSet:function(_282){if((_282=="wmDefaultX"||_282=="wmDefaultY")&&this.isDesignLoaded()){if(_282=="wmDefaultX"){return this.defaultXY;}else{return this.defaultXY;}}if(this.variable==null||this.variable==""){return [];}var data=[];for(var i=0;i<this.variable.getCount();i++){var _283=this.variable.getItem(i).data;if(_283&&_283!=null){var obj={y:_283[_282]};if(this.xAxis!=""){obj.legend=_283[this.xAxis];}if(this.chartColor!=""){if(this.chartColor instanceof Array){var _284=this.chartColor[i];if(_284){obj.color=_284;}}else{obj.color=_283[this.chartColor];}}data[data.length]=obj;}}return data;},addXAxis:function(){if(!this.includeX){this.dojoObj.removeAxis("x");return;}var x=this.dojoObj?this.dojoObj.getAxis("x"):{},_285={};if(x&&x.opt){_285=x.opt;}_285.minorTicks=this.xMinorTicks;var _286=this.getFontProperty();if(_286){dojo.mixin(_285,_286);}if(this.xMajorTickStep){_285.majorTickStep=this.xMajorTickStep;}if(this.xMinorTickStep){_285.minorTickStep=this.xMinorTickStep;}this.dojoObj.addAxis("x",_285);},addYAxis:function(){if(this.includeY){var _287={vertical:true,natural:true,includeZero:true,fixUpper:"minor"};var _288=this.getFontProperty();if(_288){dojo.mixin(_287,_288);}if(this.yLowerRange){_287.min=this.yLowerRange;}if(this.yUpperRange&&this.yUpperRange!=""){_287.max=this.yUpperRange;}if(this.yMajorTickStep){_287.majorTickStep=this.yMajorTickStep;}this.dojoObj.addAxis("y",_287);}},getFontProperty:function(){var _289={style:"normal",variant:"normal",weight:"normal",size:"7pt",family:"Tahoma"};var _28a={};var _28b={};var _28c=false;if(this._classes&&this._classes.domNode){for(var i=0;i<this._classes.domNode.length;i++){var _28d=this._classes.domNode[i];var _28e=this.getDojoGFXCssPropObj(_28d);if(_28e){_28b[_28e.propName]=_28e.propValue;_28c=true;}}if(_28c){var _28f="";for(p in _289){if(_28b[p]&&_28b[p]!=""){_28f+=" "+_28b[p];}else{_28f+=" "+_289[p];}}_28a.font=dojo.trim(_28f);if(_28b.fontColor){_28a.fontColor=_28b.fontColor;}return _28a;}}return null;},addSeries:function(){return;thisObj=this;dojo.forEach(this.yAxis.split(","),function(_290,idx){var _291=null;if(thisObj.chartType=="Pie"){_291=thisObj.getPieDataSet(_290);}else{_291=thisObj.getColumnDataSet(_290);}_290=dojo.trim(_290);var _292=wm.capitalize(_290);var _293=1;while(dojo.indexOf(thisObj.addedSeries,_292)!=-1){_292+=" "+_293;_293++;}if(thisObj.chartType!="Pie"&&thisObj.chartColor instanceof Array){var _294=thisObj.chartColor[idx];if(_294&&_294!=""){thisObj.dojoObj.addSeries(_292,_291,{stroke:{width:0},fill:_294});}else{thisObj.dojoObj.addSeries(_292,_291);}}else{thisObj.dojoObj.addSeries(_292,_291);}thisObj.addedSeries[thisObj.addedSeries.length]=_292;});},incrementSeries:function(){this.addChartSeries(true);this.dojoObj.render();this.renderBounds();},updateSeries:function(_295,_296){try{this.dojoObj.updateSeries(_295,_296);this.dojoObj.render();}catch(e){console.info("error while updating series for ",this.declaredClass);}},setChartTheme:function(){var js="dojox.charting.themes."+this.theme;dojo["require"](js);var self=this;dojo.addOnLoad(function(){self.updateChartTheme();});},updateChartTheme:function(){var _297=dojo.getObject("dojox.charting.themes."+this.theme);this.dojoObj.setTheme(_297);},updateChartType:function(){this.updateChartXY();var prop={type:this.chartType,gap:this.gap};if(this.chartType=="Lines"){prop.markers=true;}this.dojoObj.addPlot("default",prop);},getDojoGFXCssPropObj:function(prop){var _298=prop.split("_");if(_298.length==3){switch(_298[1]){case "FontFamily":return {propName:"family",propValue:_298[2]};case "FontSizePx":return {propName:"size",propValue:_298[2]};case "FontColor":return {propName:"fontColor",propValue:_298[2]};case "TextDecoration":return {propName:"weight",propValue:_298[2]};}}return null;},updateChartXY:function(){if(this.chartType=="Pie"){this.dojoObj.removeAxis("x");}else{this.addXAxis();}this.addSeries();},addAnimation:function(){if(this.aniHighlight!=null){this.aniHighlight.destroy();this.aniShake.destroy();this.aniTooltip.destroy();if(this.magnify){this.magnify.destroy();}}if(this.enableAnimation){var dc=dojox.charting;var dur=450;this.aniHighlight=new dc.action2d.Highlight(this.dojoObj,"default",{duration:dur,easing:dojo.fx.easing.sineOut});this.aniShake=new dc.action2d.Shake(this.dojoObj,"default");this.aniTooltip=new dc.action2d.Tooltip(this.dojoObj,"default");if(this.chartType=="Lines"){this.magnify=new dc.action2d.Magnify(this.dojoObj,"default");}}},getTimeX:function(){var _299=new Date();var h=_299.getHours(),m=_299.getMinutes(),s=_299.getSeconds(),text=h+":"+m+":"+s;var _29a=this.dojoObj.getAxis("x"),_29b=_29a.opt.labels||[];if(_29b.length<1){var _29c=1;}else{var _29c=_29b[_29b.length-1].value+1;while(_29b.length>this.maxTimePoints){_29b.shift();}}_29b.push({value:_29c,text:text});_29a.labels=_29b;this.dojoObj.addAxis("x",_29a);return _29c;},addXLabel:function(_29d){var _29e=this.dojoObj.getAxis("x"),_29f=_29e.opt.labels||[],_2a0=0;if(_29f.length<1){_2a0=1;}else{_2a0=_29f[_29f.length-1].value+1;}_29f.push({value:_2a0,text:_29d+""});_29e.labels=_29f;this.dojoObj.addAxis("x",_29e);return _2a0;},dojoChartEvent:function(e){var type=e.type;var idx=e.index;if(!this.variable||!type||!idx||type==null||idx==null||this.variable==null){return;}var _2a1=null;var item=this.variable.getItem(idx);if(item!=null){_2a1=item.data;}if(type=="onclick"){dojo.hitch(this,"onClick")(e,_2a1);}else{if(type=="onmouseover"){dojo.hitch(this,"onMouseOver")(e,_2a1);}else{if(type=="onmouseout"){dojo.hitch(this,"onMouseOut")(e,_2a1);}}}},onClick:function(e,_2a2){},onMouseOver:function(e,_2a3){},onMouseOut:function(e,_2a4){}});wm.Object.extendSchema(wm.DojoChart,{variable:{ignore:1},dojoDiv:{ignore:1},caption:{ignore:1},disabled:{ignore:1},dataValue:{ignore:1},defaultValuesX:{ignore:1},defaultValuesY:{ignore:1},addedSeries:{ignore:1},aniHighlight:{ignore:1},aniShake:{ignore:1},magnify:{ignore:1},aniTooltip:{ignore:1},xLabels:{ignore:1},legendDiv:{ignore:1},legend:{ignore:1},dataSet:{bindable:1,group:"edit",order:10,isList:true},xAxis:{group:"edit",order:20},isTimeXAxis:{group:"edit",order:21},maxTimePoints:{group:"edit",order:22},yAxis:{group:"edit",order:30},chartColor:{group:"edit",order:40},chartType:{order:10},theme:{order:20},addSilverlight:{ignore:1}});wm.DojoChart.description="A dojo chart.";wm.DojoChart.extend({themeable:false,designCreate:function(){if(this._studioCreating){this.studioCreate();}this.inherited(arguments);},afterPaletteDrop:function(){this.caption=this.caption||this.name;this.renderDojoObj();},makePropEdit:function(_2a5,_2a6,_2a7){switch(_2a5){case "theme":return makeSelectPropEdit(_2a5,_2a6,chartThemes,_2a7);case "chartType":return makeSelectPropEdit(_2a5,_2a6,chartTypes,_2a7);}return this.inherited(arguments);},setXAxis:function(_2a8){this.xAxis=_2a8;this.renderDojoObj();},setYAxis:function(_2a9){this.yAxis=_2a9;this.renderDojoObj();},setYUpperRange:function(_2aa){this.yUpperRange=_2aa;this.renderDojoObj();},setChartColor:function(_2ab){if(_2ab.indexOf(",")!=-1||this.chartType!="Pie"){this.chartColor=_2ab.split(",");}else{this.chartColor=_2ab;}this.renderDojoObj();},setTheme:function(_2ac){this.theme=_2ac;this.setChartTheme();var self=this;dojo.addOnLoad(function(){self.dojoRenderer();});},setChartType:function(_2ad){this.chartType=_2ad;this.updateChartType();this.dojoRenderer();},setLegendHeight:function(_2ae){this.legendHeight=_2ae;this.updateChartSize();},addUserClass:function(arg1,arg2){this.inherited(arguments);this.updateStyle();},removeUserClass:function(arg1,arg2){this.inherited(arguments);this.updateStyle();},updateStyle:function(){this.setIncludeX(this.includeX);this.setIncludeY(this.includeY);},setIncludeX:function(_2af){this.includeX=_2af;if(this.includeX){this.addXAxis();}else{this.dojoObj.removeAxis("x");}this.dojoRenderer();},setIncludeY:function(_2b0){this.includeY=_2b0;if(this.includeY){var _2b1={vertical:true,natural:true,includeZero:true,fixUpper:"minor"};var _2b2=this.getFontProperty();if(_2b2){dojo.mixin(_2b1,_2b2);}this.dojoObj.addAxis("y",_2b1);}else{this.dojoObj.removeAxis("y");}this.dojoRenderer();},setIncludeGrid:function(_2b3){this.includeGrid=_2b3;if(this.includeGrid){this.dojoObj.addPlot("grid",{type:"Grid",hMinorLines:true,vMinorLines:true});}else{this.dojoObj.removePlot("grid");}this.dojoRenderer();},setGap:function(_2b4){this.gap=_2b4;this.updateChartType();this.dojoRenderer();},setEnableAnimation:function(_2b5){this.enableAnimation=_2b5;this.addAnimation();this.dojoRenderer();},showAddSilverlight:function(){if(!dojo.isIE||!Silverlight||Silverlight.isInstalled()){return;}this.addSilverlight=true;var link=dojo.doc.createElement("a");dojo.attr(link,"href","http://go.microsoft.com/fwlink/?LinkId=149156");dojo.attr(link,"style","text-decoration: none;");var img=dojo.doc.createElement("img");dojo.attr(img,"src","http://go.microsoft.com/fwlink/?LinkId=108181");dojo.attr(img,"alt","Get Microsoft Silverlight");dojo.attr(img,"style","border-style: none");link.appendChild(img);this.domNode.appendChild(link);},designResize:function(_2b6){this.inherited(arguments);this.updateChartSize();},setSizeProp:function(n,v){this.inherited(arguments);this.updateChartSize();},updateChartSize:function(){if(this.dojoObj!=null){this.updateChartDivHeight();this.dojoObj.resize();this.dojoObj.render();}}});}
