/*
 * Copyright (C) 2009-2010 WaveMaker Software, Inc.
 *
 * This file is part of WaveMaker Studio.
 *
 * WaveMaker Studio is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, version 3 of the License, only.
 *
 * WaveMaker Studio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with WaveMaker Studio.  If not, see <http://www.gnu.org/licenses/>.
 */ 
DataObjectsEditor.widgets = {
	columnListVar: ["wm.Variable", {type: "com.activegrid.tools.data.ColumnInfo"}, {}],
	relationshipsListVar: ["wm.Variable", {type: "com.activegrid.tools.data.RelatedInfo"}, {}],
	smallToolbarImageList: ["wm.ImageList", {width: 16, height: 16, colCount: 32, url: "images/smallToolbarBtns.png"}, {}],
	layoutBox: ["wm.Layout", {_classes: {domNode: ["wm-darksnazzy"]}, height: "1flex", layoutFlex: 1, width: "1flex", imageList: "smallToolbarImageList"}, {}, {
		editorToolbar: ["wm.Panel", {border: "0", height: "29px", layoutKind: "left-to-right"}, {}, {
			toolbarBtnHolder: ["wm.Panel", {border: "0", height: "100%", layoutKind: "left-to-right", layoutFlex: 1, width: "100%", padding: "0,4"}, {}, {
				saveButton1: ["wm.ToolButton", {imageIndex: 8, title: "エンティティを保存", width: "24px", height: "100%", border: "", margin: "", hint: "エンティティを保存"}, {onclick: "saveAll"}],
				toolbarspacer1: ["wm.Spacer", {height: "24px", width: "12px", margin: "0,5"}, {}],
				addEntityButton: ["wm.ToolButton", {imageIndex: 25, title: "新規", width: "24px", height: "100%", border: "", margin: "", hint: "新規"}, {onclick: "addButtonClick"}],
				removeButton: ["wm.ToolButton", {imageIndex: 0, title: "削除", width: "24px", height: "100%", border: "", margin: "", hint: "削除"}, {onclick: "removeButtonClick"}],
				toolbarspacer2: ["wm.Spacer", {height: "24px", width: "12px", margin: "0,5"}, {}],
				importDBButton: ["wm.ToolButton", {imageIndex: 20, title: "データベースをインポート", width: "24px", height: "100%", border: "", margin: "", hint: "データベースをインポート"}, {onclick: "importDBButtonClick"}],
				dbSettingsButton: ["wm.ToolButton", {imageIndex: 21, title: "データベース接続", width: "24px", height: "100%", border: "", margin: "", hint: "データベース接続"}, {onclick: "dbSettingsButtonClick"}]
			}],
			logoBtmHolder: ["wm.Panel", {border: "0", width: "221px"}, {}]
		}],
		pages: ["wm.Layers", {layoutFlex: 1}, {oncanchange: "pagesCanChange"}, {
			objectquery: ["wm.Layer", {inFlow: true, layoutFlex: 1, layoutKind: "left-to-right", caption: "オブジェクト"}, {}, {
				treePanel: ["wm.Panel", {border: "0", width: "182px", showing: false}, {}, {
					tree: ["wm.Tree", {height: "1flex", width: "1flex", layoutFlex: 1}, {onselect: "treeSelect", ondeselect: "treeDeselect"}]
				}],
				splitter: ["wm.Splitter", {layout: "left", border: "", layoutFlex: 0, showing: false}, {}],
				objectPages: ["wm.Layers", {layoutFlex: 1, border: ""}, {}, {
					defaultPage: ["wm.Layer", {inFlow: true, layoutFlex: 1, layoutKind: "left-to-right", caption: "デフォルト"}, {}],
					objectPage: ["wm.Layer", {inFlow: false, layoutFlex: 1, layoutKind: "left-to-right", caption: "オブジェクト"}, {}, {
						panel0: ["wm.Panel", {border: "0", height: "1flex", layoutFlex: 1, width: "1flex"}, {}, {
							panel001: ["wm.Panel", {_classes: {domNode: ["wmToolbar"]}, border: "1,0,0,0", borderColor: "#000000", height: "29px", layoutKind: "left-to-right"}, {}, {
								entityLabel: ["wm.Label", {_classes: {domNode: ["wm_Padding_6px"]}, width: "45px", border: "", caption: "一般"}, {}, {
									format: ["wm.DataFormatter", {}, {}]
								}],
								entityLabelSpacer: ["wm.Spacer", {height: "24px", border: "", width: "16px"}, {}],
								saveButton: ["wm.ToolButton", {imageIndex: 8, title: "エンティティを保存", width: "24px", height: "100%", border: "", margin: "", hint: "エンティティを保存", showing: false}, {onclick: "saveAll"}],
								dataModelChangedWarningLabel: ["wm.Label", {width: "1flex", caption: "データモデルが変更されています。有効にする場合は、データモデルをエクスポートしてください。", layoutFlex: 1, height: "1flex", showing: false}, {}, {
									format: ["wm.DataFormatter", {}, {}]
								}]
							}],
							entityPanel: ["wm.Panel", {border: "0", height: "180px", layoutKind: "left-to-right", width: "800px"}, {}, {
								tableDetailPanel: ["wm.Panel", {border: "0", width: "400px"}, {}, {
									tableDetailPackageName: ["wm.Editor", {caption: "パッケージ", height: "26px", layoutKind: "left-to-right", readonly: true}, {onchange: "tableDetailPackageNameChange"}, {
										editor: ["wm._TextEditor", {layoutFlex: 10}, {}]
									}],
									tableDetailSchemaName: ["wm.Editor", {caption: "スキーマ", height: "26px", layoutKind: "left-to-right"}, {onchange: "tableDetailSchemaNameChange"}, {
										editor: ["wm._TextEditor", {layoutFlex: 10}, {}]
									}],
									tableDetailCatalogName: ["wm.Editor", {caption: "カタログ", height: "26px", layoutKind: "left-to-right"}, {onchange: "tableDetailCatalogNameChange"}, {
										editor: ["wm._TextEditor", {layoutFlex: 10}, {}]
									}],
									spacer1: ["wm.Spacer", {height: "10px", border: ""}, {}],
									tableDetailTableName: ["wm.Editor", {caption: "テーブル名", height: "26px", layoutKind: "left-to-right"}, {onchange: "tableDetailTableNameChange"}, {
										editor: ["wm._TextEditor", {layoutFlex: 10}, {}]
									}],
									tableDetailEntityName: ["wm.Editor", {caption: "エンティティ名", height: "26px", layoutKind: "left-to-right"}, {onchange: "tableDetailEntityNameChange"}, {
										editor: ["wm._TextEditor", {layoutFlex: 10}, {}]
									}]
								}],
								tableSettingsPanel: ["wm.Panel", {padding: "5,0,0,0", width: "150px"}, {}, {
									dynamicInsertCheckBox: ["wm.Editor", {caption: "Dynamic Insert", display: "CheckBox", displayValue: "0", height: "26px", captionSize: "115px", layoutKind: "left-to-right"}, {onchange: "dynamicInsertChange"}, {
										editor: ["wm._CheckBoxEditor", {layoutFlex: 10}, {}]
									}],
									dynamicUpdateCheckBox: ["wm.Editor", {caption: "Dynamic Update", display: "CheckBox", displayValue: "0", height: "26px", captionSize: "115px", layoutKind: "left-to-right"}, {onchange: "dynamicUpdateChange"}, {
										editor: ["wm._CheckBoxEditor", {layoutFlex: 10}, {}]
									}],
									refreshCheckBox: ["wm.Editor", {caption: "エンティティの更新", display: "CheckBox", displayValue: "0", height: "26px", captionSize: "115px", layoutKind: "left-to-right"}, {onchange: "refreshChange"}, {
										editor: ["wm._CheckBoxEditor", {layoutFlex: 10}, {}]
									}]
								}],
								inlineHelpPanel: ["wm.Panel", {border: "1,0,0,0", borderColor: "#000000", layoutFlex: 1, width: "1flex"}, {}, {
									inlineHelpText: ["wm.Label", {_classes: {domNode: ["wm_Padding_6px", "wmGroupBox"]}, border: "", caption: "Dynamic Insert： Insert文にnull値を含めないでください。<br/><br/>Dynamic Update： 文にnull値を含めないでください。<br/><br/>エンティティの更新： Insert/Updateの後にデータベースからインスタンスを読み込む。", padding: "4", layoutFlex: 1, singleLine: false, height: "1flex"}, {}, {
										format: ["wm.DataFormatter", {}, {}]
									}]
								}]
							}],
							panel002: ["wm.Panel", {_classes: {domNode: ["wmToolbar"]}, border: "1,0,0,0", borderColor: "#000000", height: "29px", layoutKind: "left-to-right"}, {}, {
								tableLabel: ["wm.Label", {_classes: {domNode: ["wm_Padding_6px"]}, width: "80px", border: "", caption: "列"}, {}, {
									format: ["wm.DataFormatter", {}, {}]
								}],
								toolbarspacer3: ["wm.Spacer", {height: "24px", width: "12px", margin: "0,5"}, {}],
								addColButton: ["wm.ToolButton", {imageIndex: 25, title: "列を追加", width: "24px", height: "100%", border: "", margin: "", hint: "列を追加"}, {onclick: "addColButtonClick"}],
								removeColButton: ["wm.ToolButton", {imageIndex: 0, title: "列を削除", width: "24px", height: "100%", border: "", margin: "", hint: "列を削除"}, {onclick: "removeCol"}]
							}],
							columnList: ["wm.DataGrid", {border: "", layoutFlex: 1}, {onCellClick: "columnsChange", onCanEdit: "columnListCanEdit"}, {
								name1: ["wm.DataGridColumn", {field: "name", index: 1, columnWidth: "150px", caption: "名前", editor: dojox.grid.editors.input}, {}, {
									format: ["wm.DataFormatter", {}, {}]
								}],
								isPk: ["wm.DataGridColumn", {field: "isPk", index: 2, columnWidth: "100px", caption: "主キー", editor: dojox.grid.editors.bool}, {}, {
									format: ["wm.DataFormatter", {}, {}]
								}],
								isFk: ["wm.DataGridColumn", {field: "isFk", index: 3, columnWidth: "100px", caption: "外部キー"}, {}, {
									format: ["wm.DataFormatter", {}, {}]
								}],
								sqlType: ["wm.DataGridColumn", {field: "sqlType", index: 4, columnWidth: "150px", caption: "型", editor: dojox.grid.editors.select, selectOptions: ["big_decimal","big_integer","blob","boolean","byte","calendar","calendar_date","character","clob","currency","date","double","float","integer","locale","string","short","text","time","timestamp","timezone", "true_false", "yes_no"]}, {}, {
									format: ["wm.DataFormatter", {}, {}]
								}],
								notNull: ["wm.DataGridColumn", {field: "notNull", index: 5, columnWidth: "100px", caption: "Not Null", editor: dojox.grid.editors.bool}, {}, {
									format: ["wm.DataFormatter", {}, {}]
								}],
								length: ["wm.DataGridColumn", {field: "length", index: 6, columnWidth: "100px", caption: "長さ", editor: dojox.grid.editors.input}, {}, {
									format: ["wm.DataFormatter", {}, {}]
								}],
								precision: ["wm.DataGridColumn", {field: "precision", index: 7, columnWidth: "100px", caption: "小数点", editor: dojox.grid.editors.input}, {}, {
									format: ["wm.DataFormatter", {}, {}]
								}],
								generator: ["wm.DataGridColumn", {field: "generator", index: 8, columnWidth: "100px", caption: "自動生成", editor: dojox.grid.editors.select, selectOptions: [" ", "assigned","identity","sequence","native"]}, {}, {
									format: ["wm.DataFormatter", {}, {}]
								}],
								param: ["wm.DataGridColumn", {field: "generatorParam", index: 9, columnWidth: "150px", caption: "引数", editor: dojox.grid.editors.input}, {}, {
									format: ["wm.DataFormatter", {}, {}]
								}]
							}],
							panel003: ["wm.Panel", {_classes: {domNode: ["wmToolbar"]}, border: "1,0,0,0", borderColor: "#000000", height: "29px", layoutKind: "left-to-right", imageList: ""}, {}, {
								relationshipsLabel: ["wm.Label", {_classes: {domNode: ["wm_Padding_6px"]}, width: "80px", border: "", caption: "関連"}, {}, {
									format: ["wm.DataFormatter", {}, {}]
								}],
								toolbarspacer4: ["wm.Spacer", {height: "24px", width: "12px", margin: "0,5"}, {}],
								addRelButton: ["wm.ToolButton", {imageIndex: 25, title: "関連を追加", width: "24px", height: "100%", border: "", margin: "", hint: "関連を追加"}, {onclick: "addRel"}],
								removeRelButton: ["wm.ToolButton", {imageIndex: 0, title: "関連を削除", width: "24px", height: "100%", border: "", margin: "", hint: "関連を削除"}, {onclick: "removeRel"}]
							}],
							relationshipsList: ["wm.DataGrid", {border: "", layoutFlex: 1}, {onCellClick: "relationshipsChange"}, {
								name1: ["wm.DataGridColumn", {field: "name", index: 1, columnWidth: "150px", caption: "名前", editor: dojox.grid.editors.input}, {}, {
									format: ["wm.DataFormatter", {}, {}]
								}],
								relatedType: ["wm.DataGridColumn", {field: "relatedType", index: 2, columnWidth: "150px", caption: "関連項目", editor: dojox.grid.editors.select}, {}, {
									format: ["wm.DataFormatter", {}, {}]
								}],
								cardinality: ["wm.DataGridColumn", {field: "cardinality", index: 3, columnWidth: "150px", caption: "多重度"}, {}, {
									format: ["wm.DataFormatter", {}, {}]
								}],
								tableName: ["wm.DataGridColumn", {field: "tableName", index: 4, columnWidth: "150px", caption: "テーブル名"}, {}, {
									format: ["wm.DataFormatter", {}, {}]
								}],
								columnNames: ["wm.DataGridColumn", {field: "columnNames", index: 5, columnWidth: "150px", caption: "列名"}, {}, {
									format: ["wm.DataFormatter", {}, {}]
								}],
								cascadeOptions: ["wm.DataGridColumn", {field: "cascadeOptions", index: 5, columnWidth: "150px", caption: "カスケード",  editor: dojox.grid.editors.select, selectOptions: ["none", "save-update", "persist", "merge", "delete", "remove", "lock", "replicate", "evict", "refresh", "delete-orphan", "all"]}, {}, {
									format: ["wm.DataFormatter", {}, {}]
								}]
							}],
							changePropNamePanel: ["wm.Panel", {_classes: {domNode: ["wmChangeNamePanel"]}, padding: "4,0,0,0", border: "1,0,0,0", borderColor: "#000000", height: "28px", layoutKind: "left-to-right"}, {}, {
								propertyNameLabel: ["wm.Label", {width: "90px", border: "", caption: "プロパティ名：", padding: "4"}, {}, {
									format: ["wm.DataFormatter", {}, {}]
								}],
								propertyName: ["wm.Input", {caption: "", width: "200px", border: ""}, {onchange: "propertyNameChange"}]
							}]
						}]
					}]
				}]
			}]
		}],
		benchbevel4: ["wm.Bevel", {}, {}]
	}]
}