/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocListener;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.BasicPdfWriter;
import com.lowagie.text.pdf.EudcFontRegistry;
import com.lowagie.text.pdf.IEudcFontRegistry;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfDocument;
import java.io.OutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PdfWriter
extends BasicPdfWriter {
    private IEudcFontRegistry eudcFontRegistry;
    private boolean isSupportEUDC = false;
    private static Pattern patternSplitEudc = Pattern.compile("[\ue000-\uf8ff]+");
    private static final float ITALIC_ANGLE = 0.21256f;

    public static PdfWriter getInstance(Document document, OutputStream outputStream) throws DocumentException {
        PdfDocument pdfDocument = new PdfDocument();
        document.addDocListener(pdfDocument);
        PdfWriter pdfWriter = new PdfWriter(pdfDocument, outputStream);
        pdfDocument.addWriter(pdfWriter);
        return pdfWriter;
    }

    public static PdfWriter getInstance(Document document, OutputStream outputStream, IEudcFontRegistry iEudcFontRegistry) throws DocumentException {
        PdfDocument pdfDocument = new PdfDocument();
        document.addDocListener(pdfDocument);
        PdfWriter pdfWriter = new PdfWriter(pdfDocument, outputStream, iEudcFontRegistry);
        pdfDocument.addWriter(pdfWriter);
        return pdfWriter;
    }

    public static PdfWriter getInstance(Document document, OutputStream outputStream, IEudcFontRegistry iEudcFontRegistry, DocListener docListener) throws DocumentException {
        PdfDocument pdfDocument = new PdfDocument();
        pdfDocument.addDocListener(docListener);
        document.addDocListener(pdfDocument);
        PdfWriter pdfWriter = new PdfWriter(pdfDocument, outputStream, iEudcFontRegistry);
        pdfDocument.addWriter(pdfWriter);
        return pdfWriter;
    }

    protected PdfWriter() {
    }

    protected PdfWriter(PdfDocument pdfDocument, OutputStream outputStream) {
        super(pdfDocument, outputStream);
        this.eudcFontRegistry = new EudcFontRegistry();
        this.isSupportEUDC = this.eudcFontRegistry != null;
    }

    protected PdfWriter(PdfDocument pdfDocument, OutputStream outputStream, IEudcFontRegistry iEudcFontRegistry) {
        super(pdfDocument, outputStream);
        this.eudcFontRegistry = iEudcFontRegistry;
        this.isSupportEUDC = iEudcFontRegistry != null;
    }

    public boolean isSupportEUDC() {
        return this.isSupportEUDC;
    }

    public boolean processEudc(PdfContentByte pdfContentByte, String string, PdfContentByte.GraphicState graphicState) {
        boolean bl;
        BaseFont baseFont = graphicState.fontDetails.baseFont;
        BaseFont baseFont2 = this.eudcFontRegistry.getEudcFont(baseFont);
        boolean bl2 = bl = baseFont.getFontDescriptor(4, 0.0f) != 0.0f;
        if (baseFont2 != null) {
            Matcher matcher = patternSplitEudc.matcher(string);
            float f = graphicState.yTLM * 0.21256f;
            int n = string.length();
            int n2 = 0;
            int n3 = n;
            while (matcher.find()) {
                int n4 = matcher.start();
                n3 = matcher.end();
                if (n4 > n2) {
                    pdfContentByte.showTextSimple(string.substring(n2, n4));
                }
                if (baseFont2 != null) {
                    pdfContentByte.setFontAndSize(baseFont2, graphicState.size);
                    if (bl) {
                        pdfContentByte.concatCTM(1.0f, 0.0f, 0.21256f, 1.0f, -f, 0.0f);
                    }
                    pdfContentByte.showTextSimple(string.substring(n4, n3));
                    pdfContentByte.setFontAndSize(baseFont, graphicState.size);
                    if (bl) {
                        pdfContentByte.concatCTM(1.0f, 0.0f, -0.21256f, 1.0f, f, 0.0f);
                    }
                } else {
                    StringBuffer stringBuffer = new StringBuffer();
                    for (int i = n4; i < n3; ++i) {
                        stringBuffer.append('\u25a1');
                    }
                    pdfContentByte.showTextSimple(stringBuffer.toString());
                }
                n2 = n3;
            }
            if (n2 < n) {
                pdfContentByte.showTextSimple(string.substring(n2, n));
            }
            return true;
        }
        return false;
    }
}

