/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.lexer;

import org.netbeans.lib.lexer.EmbeddedJoinInfo;
import org.netbeans.lib.lexer.EmbeddedTokenList;
import org.netbeans.lib.lexer.TokenListList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JoinTokenListBase {
    private static final int INDEX_GAP_LENGTH_INITIAL_SIZE = 0x3FFFFFFF;
    int tokenListCount;
    int joinTokenCount;
    int indexGapsIndex;
    int joinTokenIndexGapLength = 0x3FFFFFFF;
    int tokenListIndexGapLength = 0x3FFFFFFF;
    int extraModCount;

    public JoinTokenListBase(int n) {
        this.tokenListCount = n;
        this.indexGapsIndex = n;
    }

    int joinTokenIndex(int n) {
        return n < this.joinTokenIndexGapLength ? n : n - this.joinTokenIndexGapLength;
    }

    int tokenListIndex(int n) {
        return n < this.tokenListIndexGapLength ? n : n - this.tokenListIndexGapLength;
    }

    public void moveIndexGap(TokenListList<?> tokenListList, int n, int n2) {
        if (n2 < this.indexGapsIndex) {
            int n3 = n2;
            do {
                EmbeddedJoinInfo embeddedJoinInfo = ((EmbeddedTokenList)tokenListList.get((int)(n + n3++))).joinInfo;
                embeddedJoinInfo.rawTokenListIndex += this.tokenListIndexGapLength;
                embeddedJoinInfo.rawJoinTokenIndex += this.joinTokenIndexGapLength;
            } while (n3 < this.indexGapsIndex);
            this.indexGapsIndex = n2;
        } else if (n2 > this.indexGapsIndex) {
            int n4 = n2;
            do {
                EmbeddedJoinInfo embeddedJoinInfo = ((EmbeddedTokenList)tokenListList.get((int)(n + --n4))).joinInfo;
                embeddedJoinInfo.rawTokenListIndex -= this.tokenListIndexGapLength;
                embeddedJoinInfo.rawJoinTokenIndex -= this.joinTokenIndexGapLength;
            } while (n4 > this.indexGapsIndex);
            this.indexGapsIndex = n2;
        }
    }

    public void tokenListModNotify(int n) {
        this.indexGapsIndex += n;
        this.tokenListCount += n;
        this.tokenListIndexGapLength -= n;
    }

    public int joinTokenCount() {
        return this.joinTokenCount;
    }

    public void updateJoinTokenCount(int n) {
        this.joinTokenCount += n;
        this.joinTokenIndexGapLength -= n;
    }

    public void incrementExtraModCount() {
        ++this.extraModCount;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(70);
        stringBuilder.append("tokenListCount=").append(this.tokenListCount);
        stringBuilder.append(", tokenCount=").append(this.joinTokenCount);
        stringBuilder.append(", indexGapsIndex=").append(this.indexGapsIndex);
        return stringBuilder.toString();
    }
}

