/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.charts.multiaxis;

import com.jaspersoft.ireport.designer.NotRealElementNode;
import com.jaspersoft.ireport.designer.charts.multiaxis.MultiAxisChartElementNode;
import com.jaspersoft.ireport.designer.outline.nodes.ElementNode;
import com.jaspersoft.ireport.designer.outline.nodes.properties.charts.AxisPositionTypeProperty;
import com.jaspersoft.ireport.locale.I18n;
import java.io.IOException;
import net.sf.jasperreports.charts.design.JRDesignChartAxis;
import net.sf.jasperreports.charts.design.JRDesignMultiAxisPlot;
import net.sf.jasperreports.engine.design.JRDesignChart;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.Lookup;

public class AxisChartNode
extends ElementNode
implements NotRealElementNode {
    JRDesignChartAxis chartAxis = null;

    public AxisChartNode(JasperDesign jd, JRDesignChartAxis chartAxis, Lookup doLkp) {
        super(jd, (JRDesignElement)((JRDesignChart)chartAxis.getChart()), doLkp);
        this.chartAxis = chartAxis;
        this.setIconBaseWithExtension("com/jaspersoft/ireport/designer/resources/chartaxis-16.png");
    }

    private JRDesignChart getChart() {
        return (JRDesignChart)this.chartAxis.getChart();
    }

    protected Sheet createSheet() {
        Sheet sheet = super.createSheet();
        Node.PropertySet[] sets = sheet.toArray();
        for (int i = 0; i < sets.length; ++i) {
            sheet.remove(sets[i].getName());
        }
        Sheet.Set propertySet = Sheet.createPropertiesSet();
        propertySet.setName("AXIS_PROPERTIES");
        propertySet.setDisplayName(I18n.getString("Global.AxisProperties"));
        propertySet.put((Node.Property)new AxisPositionTypeProperty(this.chartAxis));
        sheet.put(propertySet);
        for (int i = 0; i < sets.length; ++i) {
            sheet.put((Sheet.Set)sets[i]);
        }
        return sheet;
    }

    public void destroy() throws IOException {
        JRDesignChart element;
        JRDesignMultiAxisPlot plot;
        super.destroy();
        Node node = this.getParentNode();
        if (node instanceof MultiAxisChartElementNode && (plot = (JRDesignMultiAxisPlot)(element = (JRDesignChart)((MultiAxisChartElementNode)node).getElement()).getPlot()).getAxes().size() > 1) {
            plot.getAxes().remove(this.chartAxis);
            JRDesignChartAxis axis0 = (JRDesignChartAxis)plot.getAxes().get(0);
            ((JRDesignChart)plot.getChart()).setDataset(axis0.getChart().getDataset());
            plot.getEventSupport().firePropertyChange("axes", null, (Object)plot.getAxes());
        }
    }

    public boolean canRename() {
        return false;
    }
}

